/*
 * Decompiled with CFR 0.152.
 */
package org.polymc.impl;

import java.applet.Applet;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.polymc.Launcher;
import org.polymc.applet.LegacyFrame;
import org.polymc.utils.Parameters;
import org.polymc.utils.Utils;

public final class OneSixLauncher
implements Launcher {
    private static final int DEFAULT_WINDOW_WIDTH = 854;
    private static final int DEFAULT_WINDOW_HEIGHT = 480;
    private static final Logger LOGGER = Logger.getLogger("OneSixLauncher");
    private final List<String> mcParams;
    private final List<String> traits;
    private final String appletClass;
    private final String mainClass;
    private final String userName;
    private final String sessionId;
    private final String windowTitle;
    private final int winSizeW;
    private final int winSizeH;
    private final boolean maximize;
    private final String cwd;
    private final String serverAddress;
    private final String serverPort;
    private final ClassLoader classLoader = ClassLoader.getSystemClassLoader();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OneSixLauncher(Parameters parameters) {
        this.mcParams = parameters.allSafe("param", Collections.emptyList());
        this.mainClass = parameters.firstSafe("mainClass", "net.minecraft.client.Minecraft");
        this.appletClass = parameters.firstSafe("appletClass", "net.minecraft.client.MinecraftApplet");
        this.traits = parameters.allSafe("traits", Collections.emptyList());
        this.userName = parameters.first("userName");
        this.sessionId = parameters.first("sessionId");
        this.windowTitle = parameters.firstSafe("windowTitle", "Minecraft");
        this.serverAddress = parameters.firstSafe("serverAddress", null);
        this.serverPort = parameters.firstSafe("serverPort", null);
        this.cwd = System.getProperty("user.dir");
        String string = parameters.firstSafe("windowParams", null);
        if (string != null) {
            String[] stringArray = string.split("x");
            if (string.equalsIgnoreCase("max")) {
                this.maximize = true;
                this.winSizeW = 854;
                this.winSizeH = 480;
                return;
            } else {
                if (stringArray.length != 2) throw new IllegalArgumentException("Unexpected window size parameter value: " + string);
                this.maximize = false;
                this.winSizeW = Integer.parseInt(stringArray[0]);
                this.winSizeH = Integer.parseInt(stringArray[1]);
            }
            return;
        } else {
            this.maximize = false;
            this.winSizeW = 854;
            this.winSizeH = 480;
        }
    }

    private void invokeMain(Class<?> clazz) throws Exception {
        Method method = clazz.getMethod("main", String[].class);
        method.invoke(null, new Object[]{this.mcParams.toArray(new String[0])});
    }

    private void legacyLaunch() throws Exception {
        Class<?> clazz = this.classLoader.loadClass(this.mainClass);
        Field field = Utils.getMinecraftBaseDirField(clazz);
        if (field == null) {
            LOGGER.warning("Could not find Minecraft path field.");
        } else {
            field.setAccessible(true);
            field.set(null, new File(this.cwd));
        }
        System.setProperty("minecraft.applet.TargetDirectory", this.cwd);
        if (!this.traits.contains("noapplet")) {
            LOGGER.info("Launching with applet wrapper...");
            try {
                Class<?> clazz2 = this.classLoader.loadClass(this.appletClass);
                Applet applet = (Applet)clazz2.getConstructor(new Class[0]).newInstance(new Object[0]);
                LegacyFrame legacyFrame = new LegacyFrame(this.windowTitle, applet);
                legacyFrame.start(this.userName, this.sessionId, this.winSizeW, this.winSizeH, this.maximize, this.serverAddress, this.serverPort);
                return;
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Applet wrapper failed: ", exception);
                LOGGER.warning("Falling back to using main class.");
            }
        }
        this.invokeMain(clazz);
    }

    private void launchWithMainClass() throws Exception {
        if (!this.maximize) {
            this.mcParams.add("--width");
            this.mcParams.add(Integer.toString(this.winSizeW));
            this.mcParams.add("--height");
            this.mcParams.add(Integer.toString(this.winSizeH));
        }
        if (this.serverAddress != null) {
            this.mcParams.add("--server");
            this.mcParams.add(this.serverAddress);
            this.mcParams.add("--port");
            this.mcParams.add(this.serverPort);
        }
        this.invokeMain(this.classLoader.loadClass(this.mainClass));
    }

    @Override
    public void launch() throws Exception {
        if (this.traits.contains("legacyLaunch") || this.traits.contains("alphaLaunch")) {
            this.legacyLaunch();
        } else {
            this.launchWithMainClass();
        }
    }
}

