#
# Copyright (c) 2014-present, Facebook, Inc.
#
# CMake package configuration file for fbzmq
#
# Defines the target "fbzmq::fbzmq"
# Add this to your target_link_libraries() call to depend on fbzmq.


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was fbzmq-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set_and_check(FBZMQ_CMAKE_DIR "${PACKAGE_PREFIX_DIR}/lib/cmake/fbzmq")

if (NOT TARGET fbzmq::fbzmq)
  include("${FBZMQ_CMAKE_DIR}/fbzmq-targets.cmake")
endif()

if (NOT fbzmq_FIND_QUIETLY)
  message(STATUS "Found fbzmq: ${PACKAGE_PREFIX_DIR}")
endif()
