/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.animation;

import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.openstreetmap.josm.gui.animation.AnimationExtension;
import org.openstreetmap.josm.gui.animation.DropImage;
import org.openstreetmap.josm.gui.animation.IAnimObject;
import org.openstreetmap.josm.gui.animation.Star;

public class ChristmasExtension
implements AnimationExtension {
    private static final Random seed = new Random();
    private final List<IAnimObject> objs = new ArrayList<IAnimObject>(50);

    @Override
    public void paint(Graphics g) {
        this.objs.forEach(o -> o.paint(g));
    }

    @Override
    public void animate() {
        this.objs.forEach(IAnimObject::animate);
    }

    @Override
    public final void adjustForSize(int w, int h, int x, int y) {
        int count = w / 22;
        while (this.objs.size() > count) {
            this.objs.remove(this.objs.size() - 1);
        }
        this.objs.forEach(o -> o.setExtend(w, h));
        while (this.objs.size() < count) {
            this.objs.add(seed.nextInt(5) > 0 ? new Star(w, h) : new DropImage(w, h));
        }
    }
}

