/*
 * Decompiled with CFR 0.152.
 */
package ch.poole.openinghoursparser;

import ch.poole.openinghoursparser.I18n;
import java.util.ArrayList;
import java.util.List;

public enum Event {
    DAWN("dawn"),
    SUNRISE("sunrise"),
    DUSK("dusk"),
    SUNSET("sunset");

    private final String name;

    private Event(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static Event getValue(String event) {
        for (Event e : Event.values()) {
            if (!e.toString().equals(event)) continue;
            return e;
        }
        throw new IllegalArgumentException(I18n.tr("invalid_event", event));
    }

    public static List<String> nameValues() {
        ArrayList<String> result = new ArrayList<String>();
        for (Event e : Event.values()) {
            result.add(e.toString());
        }
        return result;
    }
}

