/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.Config;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResAttr;
import brut.androlib.res.data.value.ResIntValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang3.tuple.Pair;
import org.xmlpull.v1.XmlSerializer;

public class ResEnumAttr
extends ResAttr {
    private static final Logger LOGGER = Logger.getLogger(ResEnumAttr.class.getName());
    private final Pair<ResReferenceValue, ResScalarValue>[] mItems;
    private final Map<Integer, String> mItemsCache;

    ResEnumAttr(ResReferenceValue parent, int type, Integer min, Integer max, Boolean l10n, Pair<ResReferenceValue, ResScalarValue>[] items) {
        super(parent, type, min, max, l10n);
        this.mItems = items;
        this.mItemsCache = new HashMap<Integer, String>();
    }

    @Override
    public String convertToResXmlFormat(ResScalarValue value) throws AndrolibException {
        String decoded;
        if (value instanceof ResIntValue && (decoded = this.decodeValue(((ResIntValue)value).getValue())) != null) {
            return decoded;
        }
        return super.convertToResXmlFormat(value);
    }

    @Override
    protected void serializeBody(XmlSerializer serializer, ResResource res) throws AndrolibException, IOException {
        for (Pair<ResReferenceValue, ResScalarValue> item : this.mItems) {
            ResReferenceValue ref = item.getLeft();
            ResScalarValue val = item.getRight();
            ResResSpec referent = ref.getReferent();
            if (referent == null && this.mConfig.getDecodeResolve() == Config.DecodeResolve.REMOVE) {
                LOGGER.fine(String.format("null enum reference: ref=0x%08x(%s), val=0x%08x(%s)", ref.getRawIntValue(), ref.getType(), val.getRawIntValue(), val.getType()));
                continue;
            }
            serializer.startTag(null, "enum");
            serializer.attribute(null, "name", referent != null ? referent.getName() : String.format("APKTOOL_MISSING_0x%08x", ref.getRawIntValue()));
            serializer.attribute(null, "value", Integer.toString(val.getRawIntValue()));
            serializer.endTag(null, "enum");
        }
    }

    private String decodeValue(int value) throws AndrolibException {
        String decoded = this.mItemsCache.get(value);
        if (decoded == null) {
            ResReferenceValue ref = null;
            for (Pair<ResReferenceValue, ResScalarValue> item : this.mItems) {
                ResScalarValue val = item.getRight();
                if (val.getRawIntValue() != value) continue;
                ref = item.getLeft();
                break;
            }
            if (ref != null && !ref.referentIsNull()) {
                decoded = ref.getReferent().getName();
                this.mItemsCache.put(value, decoded);
            }
        }
        return decoded;
    }
}

