/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.internal;

import java.util.Map;
import java.util.Optional;
import org.asciidoctor.jruby.internal.RubyHashUtil;
import org.jruby.Ruby;

public class RubyGemsPreloader {
    private static final String CODERAY = "coderay";
    private static final String ERUBIS = "erubis";
    private static final String EPUB3 = "epub3";
    private static final String PDF = "pdf";
    private static final String REVEALJS = "asciidoctor-revealjs";
    private static final Map<String, String> optionToRequiredGem = Map.of("eruby", "require 'erubis'", "template_dirs", "require 'tilt'", "cache-uri", "require 'open-uri/cached'", "data-uri", "require 'base64'", "source-highlighter", "require 'coderay'", "epub3", "require 'asciidoctor-epub3'", "pdf", "require 'asciidoctor-pdf'", "asciidoctor-revealjs", "require 'asciidoctor-revealjs'");
    private final Ruby rubyRuntime;

    public RubyGemsPreloader(Ruby rubyRuntime) {
        this.rubyRuntime = rubyRuntime;
    }

    public void preloadRequiredLibraries(Map<? super String, Object> options) {
        Map<Object, Object> opts = RubyHashUtil.convertRubyHashMapToMap(options);
        Map attributes = (Map)opts.get("attributes");
        if (attributes != null) {
            if (this.isOptionSet(attributes, "source-highlighter") && this.isOptionWithValue(attributes, "source-highlighter", CODERAY)) {
                this.preloadLibrary("source-highlighter");
            }
            if (this.isOptionSet(attributes, "cache-uri")) {
                this.preloadLibrary("cache-uri");
            }
            if (this.isOptionSet(attributes, "data-uri")) {
                this.preloadLibrary("data-uri");
            }
        }
        if (this.isOptionSet(opts, "eruby") && this.isOptionWithValue(opts, "eruby", ERUBIS)) {
            this.preloadLibrary("eruby");
        }
        if (this.isOptionSet(opts, "template_dirs")) {
            this.preloadLibrary("template_dirs");
        }
        Optional.ofNullable(opts.get("backend")).or(() -> Optional.ofNullable(attributes).map(a -> a.get("backend"))).map(Object::toString).ifPresent(backend -> {
            if (EPUB3.equalsIgnoreCase((String)backend)) {
                this.preloadLibrary(EPUB3);
            } else if (PDF.equalsIgnoreCase((String)backend)) {
                this.preloadLibrary(PDF);
            } else if ("revealjs".equalsIgnoreCase((String)backend)) {
                this.preloadLibrary(REVEALJS);
            }
        });
    }

    private void preloadLibrary(String option) {
        this.rubyRuntime.evalScriptlet(optionToRequiredGem.get(option));
    }

    private boolean isOptionWithValue(Map<? super String, Object> attributes, String attribute, String value) {
        return value.equals(attributes.get(attribute));
    }

    private boolean isOptionSet(Map<? super String, Object> attributes, String attribute) {
        return attributes.containsKey(attribute);
    }
}

