/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.util;

import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream
extends OutputStream {
    private ByteBuffer buffer;
    private int count = 0;

    public ByteBufferOutputStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBufferOutputStream(boolean nativeBuffer, int initialSize) {
        this.buffer = nativeBuffer ? ByteBuffer.allocateDirect(initialSize) : ByteBuffer.allocate(initialSize);
    }

    public ByteBufferOutputStream() {
        this(false, 1024);
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
        this.count += b.length;
    }

    private void growBuffer(int minimumSize) {
        ByteBuffer newBuffer = this.buffer.isDirect() ? ByteBuffer.allocateDirect(Math.max(this.buffer.capacity() << 1, minimumSize)) : ByteBuffer.allocate(Math.max(this.buffer.capacity() << 1, minimumSize));
        this.buffer.flip();
        newBuffer.put(this.buffer);
        this.buffer = newBuffer;
    }

    @Override
    public void write(byte[] byteArray, int offset, int length) {
        if (length > this.buffer.remaining()) {
            this.growBuffer(length + this.buffer.capacity());
        }
        this.buffer.put(byteArray, offset, length);
        this.count += length;
    }

    public void write(ByteBuffer inputBuffer) {
        if (inputBuffer.remaining() > this.buffer.remaining()) {
            this.growBuffer(inputBuffer.remaining() + this.buffer.capacity());
        }
        this.count += inputBuffer.remaining();
        this.buffer.put(inputBuffer);
    }

    @Override
    public void write(int b) {
        if (this.buffer.remaining() == 0) {
            this.growBuffer(1 + this.buffer.capacity());
        }
        this.buffer.put((byte)b);
        ++this.count;
    }

    public int size() {
        return this.count;
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer returnBuffer = this.buffer.asReadOnlyBuffer();
        returnBuffer.flip();
        return returnBuffer;
    }

    public void reset() {
        this.buffer.clear();
        this.count = 0;
    }
}

