/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.text;

import java.awt.Color;
import org.basex.gui.GUIConstants;
import org.basex.gui.text.Syntax;
import org.basex.gui.text.TextIterator;
import org.basex.util.Token;
import org.basex.util.hash.TokenSet;

final class SyntaxJSON
extends Syntax {
    private static final TokenSet KEYWORDS = new TokenSet("false", "true", "null");
    private boolean quoted;
    private boolean back;

    SyntaxJSON() {
    }

    @Override
    public void init(Color color) {
        super.init(color);
        this.quoted = false;
        this.back = false;
    }

    @Override
    public Color getColor(TextIterator iter) {
        boolean quote;
        int ch = iter.curr();
        boolean bl = quote = !this.back && ch == 34;
        if (this.quoted) {
            this.back = !this.back && ch == 92;
        } else {
            if ("{}[]:,".indexOf(ch) != -1) {
                return GUIConstants.GRAY;
            }
            byte[] token = Token.token(iter.currString());
            if (KEYWORDS.contains(token)) {
                return GUIConstants.BLUE;
            }
            if (Token.digit(ch) && !Double.isNaN(Token.toDouble(token))) {
                return GUIConstants.PURPLE;
            }
        }
        if (quote) {
            this.quoted ^= true;
        }
        return quote || this.quoted ? GUIConstants.DGRAY : GUIConstants.RED;
    }
}

