/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial.csv;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.build.csv.CsvOptions;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.csv.CsvSerializer;
import org.basex.query.QueryError;
import org.basex.query.util.ft.FTPos;
import org.basex.query.value.item.QNm;
import org.basex.util.Token;
import org.basex.util.XMLToken;
import org.basex.util.hash.TokenObjectMap;
import org.basex.util.list.TokenList;

public final class CsvDirectSerializer
extends CsvSerializer {
    private final TokenList headers;
    private final boolean atts;
    private final boolean lax;
    private TokenObjectMap<byte[]> data;
    private byte[] attv;

    public CsvDirectSerializer(OutputStream os, SerializerOptions sopts) throws IOException {
        super(os, sopts);
        this.headers = this.header ? new TokenList() : null;
        this.atts = this.copts.get(CsvOptions.FORMAT) == CsvOptions.CsvFormat.ATTRIBUTES;
        this.lax = this.copts.get(CsvOptions.LAX) != false || this.atts;
    }

    @Override
    protected void startOpen(QNm name) {
        if (this.level == 1) {
            this.data = new TokenObjectMap();
        }
        this.attv = null;
    }

    @Override
    protected void finishEmpty() throws IOException {
        this.finishOpen();
        if (this.level == 2) {
            this.cache(Token.EMPTY);
        }
        this.finishClose();
    }

    @Override
    protected void text(byte[] value, FTPos ftp) throws IOException {
        if (this.level == 3) {
            this.cache(value);
        }
    }

    @Override
    protected void finishClose() throws IOException {
        if (this.level != 1) {
            return;
        }
        TokenList tl = new TokenList();
        if (this.headers != null) {
            int i;
            int size = this.headers.size();
            if (this.header) {
                for (i = 0; i < size; ++i) {
                    tl.add((byte[])this.headers.get(i));
                }
                this.record(tl);
                this.header = false;
            }
            for (i = 0; i < size; ++i) {
                tl.add(this.data.get((byte[])this.headers.get(i)));
            }
        } else {
            for (byte[] value : this.data.values()) {
                tl.add(value);
            }
        }
        this.record(tl);
    }

    @Override
    protected void attribute(byte[] name, byte[] value, boolean standalone) {
        this.attv = value;
    }

    private void cache(byte[] value) throws IOException {
        if (this.headers != null) {
            byte[] old;
            byte[] key = this.atts && this.attv != null ? this.attv : this.elem.string();
            byte[] name = XMLToken.decode(key, this.lax);
            if (name == null) {
                throw QueryError.CSV_SERIALIZE_X_X.getIO("Invalid element name", key);
            }
            if (!this.headers.contains(name)) {
                this.headers.add(name);
            }
            this.data.put(name, (old = this.data.get(name)) == null || old.length == 0 ? value : (value.length == 0 ? old : Token.concat(old, Character.valueOf(','), value)));
        } else {
            this.data.put(Token.token(this.data.size()), value);
        }
    }
}

