/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class Instance
extends Single {
    public final SeqType seqType;
    private int check;

    public Instance(InputInfo info, Expr expr, SeqType seqType) {
        super(info, expr, SeqType.BOOLEAN_O);
        this.seqType = seqType;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        return super.compile(cc).optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        if (this.expr instanceof Value) {
            return cc.preEval(this);
        }
        SeqType et = this.expr.seqType();
        if (!this.expr.has(Flag.NDT)) {
            if (et.instanceOf(this.seqType)) {
                return cc.replaceWith(this, Bln.TRUE);
            }
            if (et.intersect(this.seqType) == null) {
                return cc.replaceWith(this, Bln.FALSE);
            }
        }
        this.check = et.with(this.seqType.occ).instanceOf(this.seqType) ? 1 : (et.occ.instanceOf(this.seqType.occ) ? 2 : 0);
        return this;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        return Bln.get(this.test(qc, ii, 0L));
    }

    @Override
    public boolean test(QueryContext qc, InputInfo ii, long pos) throws QueryException {
        Item item;
        Iter iter = this.expr.iter(qc);
        if (iter.valueIter()) {
            return this.seqType.instance(iter.value(qc, this.expr));
        }
        if (this.check == 2) {
            Item item2;
            while ((item2 = qc.next(iter)) != null) {
                if (this.seqType.instance(item2)) continue;
                return false;
            }
            return true;
        }
        long max = this.seqType.occ.max;
        if (this.check == 1) {
            return iter.next() == null ? !this.seqType.oneOrMore() : max > 1L || max > 0L && iter.next() == null;
        }
        long c = 0L;
        while ((item = qc.next(iter)) != null) {
            if (++c <= max && this.seqType.instance(item)) continue;
            return false;
        }
        return c != 0L || !this.seqType.oneOrMore();
    }

    @Override
    public Instance copy(CompileContext cc, IntObjectMap<Var> vm) {
        Instance ex = this.copyType(new Instance(this.info, this.expr.copy(cc, vm), this.seqType));
        ex.check = this.check;
        return ex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Instance)) return false;
        Instance inst = (Instance)obj;
        if (!this.seqType.eq(inst.seqType)) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "of", this.seqType), this.expr);
    }

    @Override
    public void toString(QueryString qs) {
        qs.token(this.expr).token("instance").token("of").token(this.seqType);
    }
}

