/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.Arrays;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.func.DynFuncCall;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class PartFunc
extends Arr {
    private final int placeholders;
    private final int[] placeholderPerm;

    public PartFunc(InputInfo info, Expr[] exprs, int placeholders, int[] placeholderPerm) {
        super(info, SeqType.FUNCTION_O, exprs);
        this.placeholders = placeholders;
        this.placeholderPerm = placeholderPerm;
    }

    private Expr body() {
        return this.exprs[this.exprs.length - 1];
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        if (this.values(false, cc)) {
            return cc.preEval(this);
        }
        Expr func = this.body();
        FuncType ft = func.funcType();
        if (ft != null && ft != SeqType.FUNCTION) {
            int nargs = this.exprs.length - 1;
            int arity = ft.argTypes.length;
            if (nargs != arity) {
                throw QueryError.arityError(func, nargs, arity, false, this.info);
            }
            SeqType[] args = new SeqType[this.placeholders];
            int a = 0;
            for (int e = 0; e < nargs; ++e) {
                if (!PartFunc.placeholder(this.exprs[e])) continue;
                args[this.placeholderPerm == null ? a : this.placeholderPerm[a]] = ft.argTypes[e];
                ++a;
            }
            this.exprType.assign(FuncType.get(ft.declType, args).seqType());
        }
        return this;
    }

    @Override
    public FuncItem item(QueryContext qc, InputInfo ii) throws QueryException {
        Expr expr;
        int el = this.exprs.length - 1;
        int nargs = el;
        FItem func = this.toFunction(this.body(), qc);
        int arity = func.arity();
        if (nargs != arity) {
            throw QueryError.arityError(func, nargs, arity, false, this.info);
        }
        FuncType ft = func.funcType();
        Expr[] args = new Expr[nargs];
        VarScope vs = new VarScope();
        Var[] params = new Var[this.placeholders];
        int p = 0;
        for (int e = 0; e < el; ++e) {
            expr = this.exprs[e];
            SeqType at = ft.argTypes[e];
            if (PartFunc.placeholder(expr)) {
                Var param = vs.addNew(func.paramName(e), at, qc, this.info);
                args[e] = new VarRef(this.info, param);
                params[this.placeholderPerm == null ? p : this.placeholderPerm[p]] = param;
                ++p;
                continue;
            }
            args[e] = at.coerce(expr.value(qc), null, qc, null, ii);
        }
        AnnList anns = func.annotations();
        boolean updating = anns.contains(Annotation.UPDATING);
        expr = new DynFuncCall(this.info, updating, false, (Expr)func, args);
        FuncType type = FuncType.get(anns, ft.declType, params);
        return new FuncItem(this.info, expr, params, anns, type, vs.stackSize(), null, qc.focus.copy());
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(Arrays.copyOf(this.exprs, this.exprs.length - 1));
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new PartFunc(this.info, PartFunc.copyAll((CompileContext)cc, vm, (Expr[])this.exprs), this.placeholders, this.placeholderPerm));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof PartFunc)) return false;
        PartFunc pf = (PartFunc)obj;
        if (this.placeholders != pf.placeholders) return false;
        if (!Arrays.equals(this.placeholderPerm, pf.placeholderPerm)) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    static boolean placeholder(Expr expr) {
        return expr == Empty.UNDEFINED;
    }

    @Override
    public void toString(QueryString qs) {
        qs.token(this.body()).token('(');
        int el = this.exprs.length - 1;
        for (int e = 0; e < el; ++e) {
            Expr expr;
            if (e > 0) {
                qs.token(", ");
            }
            if (PartFunc.placeholder(expr = this.exprs[e])) {
                qs.token('?');
                continue;
            }
            qs.token(this.exprs[e]);
        }
        qs.token(')');
    }
}

