/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.index;

import org.basex.data.Data;
import org.basex.util.Util;

public final class IndexCosts
implements Comparable<IndexCosts> {
    public static final IndexCosts ENFORCE_STATIC = new IndexCosts(-2);
    public static final IndexCosts ENFORCE_DYNAMIC = new IndexCosts(-1);
    public static final IndexCosts ZERO = new IndexCosts(0);
    private final int results;

    private IndexCosts(int results) {
        this.results = results;
    }

    public static IndexCosts get(int results) {
        if (results < 0) {
            throw Util.notExpected("Costs cannot be negative.", new Object[0]);
        }
        return results == 0 ? ZERO : new IndexCosts(results);
    }

    public static IndexCosts add(IndexCosts ic1, IndexCosts ic2) {
        int r1 = ic1 == null ? 0 : ic1.results;
        int r2 = ic2 == null ? 0 : ic2.results;
        int r = r1 + r2;
        return r1 < 0 || r2 < 0 ? ENFORCE_DYNAMIC : IndexCosts.get(r >= 0 ? r : Integer.MAX_VALUE);
    }

    public int results() {
        return this.results;
    }

    public boolean tooExpensive(Data data) {
        return this.results > data.meta.size;
    }

    @Override
    public int compareTo(IndexCosts ic) {
        return Integer.signum(this.results - ic.results);
    }

    public String toString() {
        return Util.className(this) + "[" + this.results + "]";
    }
}

