/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.data.DataText;
import org.basex.io.serial.MarkupSerializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryError;
import org.basex.query.QueryIOException;
import org.basex.query.value.item.QNm;
import org.basex.util.Token;
import org.basex.util.hash.TokenSet;

final class HTMLSerializer
extends MarkupSerializer {
    static final TokenSet EMPTIES;
    static final TokenSet EMPTIES5;
    static final TokenSet FORMATTEDS;
    static final TokenSet INLINES;
    static final TokenSet URIS;
    private static final TokenSet SCRIPTS;
    private static final TokenSet BOOLEAN;

    HTMLSerializer(OutputStream os, SerializerOptions sopts) throws IOException {
        super(os, sopts, "5.0", "4.01", "4.0");
    }

    @Override
    protected void attribute(byte[] name, byte[] value, boolean standalone) throws IOException {
        if (!standalone) {
            this.delimitAttribute();
        }
        this.out.print(name);
        byte[] val = value;
        if (!BOOLEAN.isEmpty() || !URIS.isEmpty()) {
            byte[] key = Token.concat(Token.lc(this.elem.string()), DataText.ATT, Token.lc(name));
            if (BOOLEAN.contains(key) && Token.eq(Token.lc(name), Token.lc(val))) {
                return;
            }
            if (this.escape && URIS.contains(key)) {
                val = Token.encodeUri(val, Token.UriEncoder.ESCAPE);
            }
        }
        this.out.print(DataText.ATT1);
        int vl = val.length;
        for (int v = 0; v < vl; v += Token.cl(val, v)) {
            int ch = Token.cp(val, v);
            if (ch == 60 || ch == 38 && val[Math.min(v + 1, vl - 1)] == 123) {
                this.out.print(ch);
                continue;
            }
            if (ch == 34) {
                this.out.print(DataText.E_QUOT);
                continue;
            }
            if (ch == 9 || ch == 10) {
                this.printHex(ch);
                continue;
            }
            this.printChar(ch);
        }
        this.out.print(DataText.ATT2);
    }

    @Override
    protected void comment(byte[] value) throws IOException {
        if (this.sep) {
            this.indent();
        }
        this.out.print(DataText.COMM_O);
        this.out.print(value);
        this.out.print(DataText.COMM_C);
    }

    @Override
    protected void pi(byte[] name, byte[] value) throws IOException {
        if (this.sep) {
            this.indent();
        }
        if (Token.contains(value, 62)) {
            throw QueryError.SERPI.getIO(new Object[0]);
        }
        this.out.print(DataText.PI_O);
        this.out.print(name);
        this.out.print(32);
        this.out.print(value);
        this.out.print(DataText.ELEM_C);
    }

    @Override
    protected void print(int cp) throws IOException {
        if (this.script > 0) {
            this.out.print(cp);
        } else {
            if (cp > 127 && cp < 160 && !this.html5) {
                throw QueryError.SERILL_X.getIO(Integer.toHexString(cp));
            }
            if (cp == 160) {
                this.out.print(DataText.E_NBSP);
            } else {
                super.print(cp);
            }
        }
    }

    @Override
    protected void startOpen(QNm name) throws IOException {
        if (this.opened.isEmpty()) {
            this.checkRoot(name);
        }
        if (this.sep) {
            this.indent();
        }
        this.out.print(DataText.ELEM_O);
        this.out.print(name.string());
        this.indAttrLength = this.out.lineLength();
        this.sep = this.indent;
        if (this.content && Token.eq(Token.lc(this.elem.local()), DataText.HEAD)) {
            ++this.skip;
        }
    }

    @Override
    protected void finishOpen() throws IOException {
        super.finishOpen();
        this.printCT(false, true);
        if (SCRIPTS.contains(Token.lc(this.elem.local()))) {
            ++this.script;
        }
    }

    @Override
    protected void finishEmpty() throws IOException {
        byte[] uri = this.elem.uri();
        if (uri.length > 0 && !Token.eq(uri, DataText.XHTML_URI)) {
            super.finishEmpty();
        } else {
            if (this.printCT(true, true)) {
                return;
            }
            this.out.print(DataText.ELEM_C);
            byte[] lc = Token.lc(this.elem.local());
            if (EMPTIES.contains(lc) && ((uri = this.nsUri(Token.EMPTY)) == null || uri.length == 0)) {
                return;
            }
            if (this.html5 && EMPTIES5.contains(lc)) {
                return;
            }
            this.sep = false;
            this.finishClose();
        }
    }

    @Override
    protected void finishClose() throws IOException {
        super.finishClose();
        if (SCRIPTS.contains(Token.lc(this.elem.local()))) {
            --this.script;
        }
    }

    @Override
    protected void doctype(QNm name) throws IOException {
        if (this.docpub != null || this.docsys != null) {
            this.printDoctype(name.local(), this.docpub, this.docsys);
        } else if (this.html5 && Token.eq(Token.lc(name.local()), DataText.HTML)) {
            this.printDoctype(Token.uc(DataText.HTML), null, null);
        }
    }

    @Override
    boolean inline() {
        return INLINES.contains(Token.lc(this.closed.local())) || this.opening && INLINES.contains(Token.lc(this.elem.local())) || super.inline();
    }

    @Override
    boolean suppressIndentation(QNm qname) throws QueryIOException {
        return FORMATTEDS.contains(Token.lc(qname.local())) || super.suppressIndentation(qname);
    }

    static {
        SCRIPTS = new TokenSet("script", "style");
        BOOLEAN = new TokenSet("area@nohref", "audio@autoplay", "audio@controls", "audio@loop", "audio@muted", "button@disabled", "button@autofocus", "button@formnovalidate", "details@open", "dialog@open", "dir@compact", "dl@compact", "fieldset@disabled", "form@novalidate", "frame@noresize", "hr@noshade", "img@ismap", "input@checked", "input@disabled", "input@multiple", "input@readonly", "input@required", "input@autofocus", "input@formnovalidate", "iframe@seamless", "keygen@autofocus", "keygen@disabled", "menu@compact", "object@declare", "object@typemustmatch", "ol@compact", "ol@reversed", "optgroup@disabled", "option@selected", "option@disabled", "script@defer", "script@async", "select@multiple", "select@disabled", "select@autofocus", "select@required", "style@scoped", "td@nowrap", "textarea@disabled", "textarea@readonly", "textarea@autofocus", "textarea@required", "th@nowrap", "track@default", "ul@compact", "video@autoplay", "video@controls", "video@loop", "video@muted");
        EMPTIES = new TokenSet("area", "base", "basefont", "br", "col", "embed", "frame", "hr", "img", "input", "isindex", "link", "meta", "param");
        EMPTIES5 = new TokenSet("area", "base", "br", "col", "command", "embed", "hr", "img", "input", "keygen", "link", "meta", "param", "source", "track", "wbr");
        FORMATTEDS = new TokenSet("pre", "script", "style", "textarea", "title");
        INLINES = new TokenSet("a", "abbr", "acronym", "applet", "area", "audio", "b", "basefont", "bdi", "bdo", "big", "br", "button", "canvas", "cite", "code", "data", "datalist", "del", "dfn", "em", "embed", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "link", "map", "mark", "math", "meta", "meter", "noscript", "object", "output", "picture", "progress", "q", "ruby", "s", "samp", "script", "select", "slot", "small", "span", "strike", "strong", "sub", "sup", "svg", "template", "textarea", "time", "tt", "u", "var", "video", "wbr");
        URIS = new TokenSet("a@href", "a@name", "applet@codebase", "area@href", "base@href", "blockquote@cite", "body@background", "button@datasrc", "del@cite", "div@datasrc", "form@action", "frame@longdesc", "frame@src", "head@profile", "iframe@longdesc", "iframe@src", "img@longdesc", "img@src", "img@usemap", "input@datasrc", "input@src", "input@usemap", "ins@cite", "link@href", "object@archive", "object@classid", "object@codebase", "object@data", "object@datasrc", "object@usemap", "q@cite", "script@for", "script@src", "select@datasrc", "span@datasrc", "table@datasrc", "textarea@datasrc");
    }
}

