/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.Arrays;
import java.util.Stack;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.regex.parse.ParseException;
import org.basex.query.util.regex.parse.RegExParser;
import org.basex.query.util.regex.parse.TokenMgrError;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjectMap;

abstract class RegExFn
extends StandardFunc {
    static final byte[] REGEX_CHARS = Token.token("\\^$.|?*+()[]{}");
    private final TokenObjectMap<RegExpr> patterns = new TokenObjectMap();

    RegExFn() {
    }

    final Pattern pattern(byte[] pattern, byte[] flags) throws QueryException {
        return this.regExpr((byte[])pattern, (byte[])flags).pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final RegExpr regExpr(byte[] pattern, byte[] flags) throws QueryException {
        byte[] key = Token.concat(pattern, Character.valueOf('\b'), flags);
        TokenObjectMap<RegExpr> tokenObjectMap = this.patterns;
        synchronized (tokenObjectMap) {
            RegExpr regExpr = this.patterns.get(key);
            if (regExpr == null) {
                regExpr = this.parse(pattern, flags);
                this.patterns.put(key, regExpr);
            }
            return regExpr;
        }
    }

    static int patternChar(byte[] pattern) {
        int sl = pattern.length;
        int separator = sl > 0 && Token.cl(pattern, 0) == sl ? Token.cp(pattern, 0) : -1;
        return separator == -1 || Token.contains(REGEX_CHARS, separator) ? -1 : separator;
    }

    private RegExpr parse(byte[] regex, byte[] modifiers) throws QueryException {
        int flags = 0;
        boolean strip = false;
        boolean comments = false;
        boolean java = false;
        for (byte mod : modifiers) {
            if (mod == 105) {
                flags |= 0x42;
                continue;
            }
            if (mod == 109) {
                flags |= 8;
                continue;
            }
            if (mod == 115) {
                flags |= 0x20;
                continue;
            }
            if (mod == 113) {
                flags |= 0x10;
                continue;
            }
            if (mod == 120) {
                strip = true;
                continue;
            }
            if (mod == 99) {
                comments = true;
                continue;
            }
            if (mod == 106 || mod == 33) {
                java = true;
                continue;
            }
            if (mod == 59) continue;
            throw QueryError.REGFLAG_X.get(this.info, Character.valueOf((char)mod));
        }
        try {
            Pattern pattern;
            if (java || (flags & 0x10) != 0) {
                pattern = Pattern.compile(Token.string(regex), flags);
            } else {
                RegExParser parser = new RegExParser(regex, strip, comments, (flags & 0x20) != 0, (flags & 8) != 0);
                String string = parser.parse().toString();
                pattern = Pattern.compile(string, flags);
            }
            return new RegExpr(pattern);
        }
        catch (PatternSyntaxException | ParseException | TokenMgrError ex) {
            Util.debug(ex);
            throw QueryError.REGINVALID_X.get(this.info, new Object[]{regex});
        }
    }

    static class RegExpr {
        final Pattern pattern;
        private GroupInfo groupInfo;

        RegExpr(Pattern pattern) {
            this.pattern = pattern;
            this.groupInfo = null;
        }

        int[] getParentGroups() {
            if (this.groupInfo == null) {
                this.groupInfo = GroupScanner.groupInfo(this.pattern.pattern());
            }
            return this.groupInfo.parentGroups;
        }

        boolean[] getAssertionFlags() {
            if (this.groupInfo == null) {
                this.groupInfo = GroupScanner.groupInfo(this.pattern.pattern());
            }
            return this.groupInfo.assertionFlags;
        }
    }

    protected static final class GroupScanner {
        private final String pattern;
        private final int len;
        private int pos;
        private int chrCount;

        private GroupScanner(String pattern) {
            this.pattern = pattern;
            this.len = pattern.length();
            this.pos = 0;
        }

        public static GroupInfo groupInfo(String pattern) {
            GroupScanner gnd = new GroupScanner(pattern);
            Stack<Integer> open = new Stack<Integer>();
            open.push(0);
            int[] parentGroups = new int[]{};
            boolean[] inAssertion = new boolean[]{};
            boolean quoted = false;
            int classLevel = 0;
            int assrtMark = 0;
            block11: while (true) {
                switch (gnd.nxtToken()) {
                    case EOP: {
                        return new GroupInfo(parentGroups, inAssertion);
                    }
                    case LBRACKET: {
                        if (quoted) continue block11;
                        ++classLevel;
                        continue block11;
                    }
                    case RBRACKET: {
                        if (quoted) continue block11;
                        --classLevel;
                        continue block11;
                    }
                    case LQUOTE: {
                        if (classLevel != 0) continue block11;
                        quoted = true;
                        continue block11;
                    }
                    case RQUOTE: {
                        if (classLevel != 0) continue block11;
                        quoted = false;
                        continue block11;
                    }
                    case CAPT_LPAREN: {
                        if (quoted || classLevel != 0) continue block11;
                        parentGroups = Arrays.copyOf(parentGroups, parentGroups.length + 1);
                        parentGroups[parentGroups.length - 1] = (Integer)open.peek();
                        inAssertion = Arrays.copyOf(inAssertion, inAssertion.length + 1);
                        inAssertion[inAssertion.length - 1] = assrtMark != 0;
                        open.push(parentGroups.length);
                        continue block11;
                    }
                    case ASSRT_LPAREN: {
                        if (quoted || classLevel != 0) continue block11;
                        open.push((Integer)open.peek());
                        if (assrtMark != 0) continue block11;
                        assrtMark = open.size();
                        continue block11;
                    }
                    case LPAREN: {
                        if (quoted || classLevel != 0) continue block11;
                        open.push((Integer)open.peek());
                        continue block11;
                    }
                    case RPAREN: {
                        if (quoted || classLevel != 0) continue block11;
                        if (open.size() == assrtMark) {
                            assrtMark = 0;
                        }
                        open.pop();
                        continue block11;
                    }
                }
            }
        }

        private Token nxtToken() {
            switch (this.nxtCp()) {
                case -1: {
                    return Token.EOP;
                }
                case 93: {
                    return Token.RBRACKET;
                }
                case 91: {
                    return Token.LBRACKET;
                }
                case 41: {
                    return Token.RPAREN;
                }
                case 92: {
                    return switch (this.nxtCp()) {
                        case -1 -> Token.EOP;
                        case 81 -> Token.LQUOTE;
                        case 69 -> Token.RQUOTE;
                        default -> Token.OTHER;
                    };
                }
                case 40: {
                    switch (this.nxtCp()) {
                        case 63: {
                            return switch (this.nxtCp()) {
                                case 33, 61 -> Token.ASSRT_LPAREN;
                                case 60 -> {
                                    switch (this.nxtCp()) {
                                        case 33: 
                                        case 61: {
                                            yield Token.ASSRT_LPAREN;
                                        }
                                    }
                                    this.reset();
                                    yield Token.CAPT_LPAREN;
                                }
                                default -> {
                                    this.reset();
                                    yield Token.LPAREN;
                                }
                            };
                        }
                    }
                    this.reset();
                    return Token.CAPT_LPAREN;
                }
            }
            return Token.OTHER;
        }

        private int nxtCp() {
            int cp;
            if (this.pos < this.len) {
                cp = this.pattern.codePointAt(this.pos);
                this.chrCount = Character.charCount(cp);
                this.pos += this.chrCount;
            } else {
                cp = -1;
                this.chrCount = 0;
            }
            return cp;
        }

        private void reset() {
            this.pos -= this.chrCount;
        }

        private static enum Token {
            EOP,
            CAPT_LPAREN,
            LPAREN,
            ASSRT_LPAREN,
            RPAREN,
            LBRACKET,
            RBRACKET,
            LQUOTE,
            RQUOTE,
            OTHER;

        }
    }

    public static class GroupInfo {
        public final int[] parentGroups;
        public final boolean[] assertionFlags;

        GroupInfo(int[] parentGroup, boolean[] assertionFlags) {
            this.parentGroups = parentGroup;
            this.assertionFlags = assertionFlags;
        }
    }
}

