/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.up.primitives.name.NameUpdate;
import org.basex.util.list.StringList;

final class NameUpdates {
    private final List<NameUpdate> nameUpdates = new LinkedList<NameUpdate>();

    NameUpdates() {
    }

    void add(NameUpdate up) throws QueryException {
        boolean alter = up.type == UpdateType.DBALTER;
        boolean drop = up.type == UpdateType.DBDROP;
        for (NameUpdate o : this.nameUpdates) {
            if (o.type == up.type) {
                o.merge(up);
            }
            if ((!drop || o.type != UpdateType.DBALTER) && (!alter || o.type != UpdateType.DBDROP)) continue;
            throw QueryError.DB_CONFLICT3_X.get(o.info(), o.name());
        }
        this.nameUpdates.add(up);
    }

    void prepare() throws QueryException {
        for (NameUpdate o : this.nameUpdates) {
            o.prepare();
        }
        Collections.sort(this.nameUpdates);
    }

    void apply(boolean before) throws QueryException {
        int pos = UpdateType._NODE_UPDATES_.ordinal();
        for (NameUpdate up : this.nameUpdates) {
            int ord = up.type.ordinal();
            if (!(before ? ord < pos : ord > pos)) continue;
            up.apply();
        }
    }

    int size() {
        int size = 0;
        for (NameUpdate up : this.nameUpdates) {
            size += up.size();
        }
        return size;
    }

    void databases(StringList db) {
        for (NameUpdate up : this.nameUpdates) {
            up.databases(db);
        }
    }
}

