/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import java.util.Arrays;
import java.util.function.Supplier;
import org.basex.util.Array;
import org.basex.util.ArrayIterator;
import org.basex.util.hash.TokenSet;

public final class TokenObjectMap<E>
extends TokenSet {
    private Object[] values = new Object[this.capacity()];

    public TokenObjectMap() {
        this(2L);
    }

    public TokenObjectMap(long capacity) {
        super(capacity);
    }

    public E put(byte[] key, E value) {
        int i = this.put(key);
        Object v = this.values[i];
        this.values[i] = value;
        return (E)v;
    }

    public E computeIfAbsent(byte[] key, Supplier<? extends E> func) {
        E value = this.get(key);
        if (value == null) {
            value = func.get();
            this.put(key, value);
        }
        return value;
    }

    public E get(byte[] key) {
        return (E)(key != null ? this.values[this.index(key)] : null);
    }

    public E value(int index) {
        return (E)this.values[index];
    }

    public void value(int index, E value) {
        this.values[index] = value;
    }

    public Iterable<E> values() {
        return new ArrayIterator(this.values, 1, this.size);
    }

    @Override
    public int remove(byte[] key) {
        int i = super.remove(key);
        this.values[i] = null;
        return i;
    }

    @Override
    protected void rehash(int newSize) {
        super.rehash(newSize);
        this.values = Array.copy(this.values, new Object[newSize]);
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.values, null);
    }

    @Override
    public String toString() {
        return this.toString((Object[])this.keys, this.values);
    }
}

