/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.xqitemtype;

import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItemType;
import net.xqj.core.XQDynamicExpression;

public class XQItemTypeImpl
implements XQItemType {
    private int XQBaseType;
    private int XQItemKind;
    private int XQItemOccurrence = 2;
    private String piName = null;
    private QName typeName = null;
    private QName nodeName = null;
    private URI schemaURI = null;
    private boolean isElementNillable = false;

    private XQItemTypeImpl(int XQBaseType, int XQItemKind) {
        this.XQBaseType = XQBaseType;
        this.XQItemKind = XQItemKind;
    }

    private XQItemTypeImpl(int XQBaseType) {
        this(XQBaseType, 1);
    }

    static XQItemTypeImpl newInstance(int XQBaseType, int XQItemKind) {
        return new XQItemTypeImpl(XQBaseType, XQItemKind);
    }

    static XQItemTypeImpl newInstance(int XQBaseType) {
        return new XQItemTypeImpl(XQBaseType);
    }

    void setBaseType(int XQBaseType) {
        this.XQBaseType = XQBaseType;
    }

    void setItemKind(int XQItemKind) {
        this.XQItemKind = XQItemKind;
    }

    public void setItemOccurrence(int XQItemOccurrence) {
        this.XQItemOccurrence = XQItemOccurrence;
    }

    public int getBaseType() throws XQException {
        switch (this.getItemKind()) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                break;
            }
            default: {
                throw new XQException("XQItemType does not have a base type.");
            }
        }
        return this.XQBaseType;
    }

    public int getItemKind() {
        return this.XQItemKind;
    }

    public int getItemOccurrence() {
        return this.XQItemOccurrence;
    }

    public QName getNodeName() throws XQException {
        switch (this.getItemKind()) {
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                break;
            }
            default: {
                throw new XQException("XQItemType (" + XQDynamicExpression.XQJ_ITEMKIND_MAP[this.getItemKind()] + ") is not compatible with node().");
            }
        }
        return this.nodeName;
    }

    public void setNodeName(QName nodeName) {
        this.nodeName = nodeName;
    }

    public URI getSchemaURI() {
        return this.schemaURI;
    }

    public void setSchemaURI(URI schemaURI) {
        this.schemaURI = schemaURI;
    }

    public QName getTypeName() throws XQException {
        switch (this.getItemKind()) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                break;
            }
            default: {
                throw new XQException("Can not call getTypeName() with the current XQItemType kind.");
            }
        }
        if (this.typeName != null) {
            return this.typeName;
        }
        String str = XQDynamicExpression.XQJ_BASETYPE_MAP[this.getBaseType()];
        int colon = str.indexOf(":");
        return new QName("http://www.w3.org/2001/XMLSchema", str.substring(colon + 1, str.length()), str.substring(0, colon));
    }

    public void setTypeName(QName typeName) {
        this.typeName = typeName;
    }

    public boolean isAnonymousType() {
        return this.XQItemKind == 12 && this.XQBaseType == 2;
    }

    public boolean isElementNillable() {
        return this.isElementNillable;
    }

    public void setElementNillable(boolean isElementNillable) {
        this.isElementNillable = isElementNillable;
    }

    public String getPIName() throws XQException {
        if (this.getItemKind() != 10) {
            throw new XQException("XQItemType is not a processing instruction.");
        }
        return this.piName;
    }

    public void setPIName(String piName) {
        this.piName = piName;
    }

    public XQItemType getItemType() {
        return this;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        if (this.XQItemKind == 1) {
            try {
                QName typeName = this.getTypeName();
                b.append(this.getTypeName().getPrefix() + ":" + this.getTypeName().getLocalPart());
            }
            catch (XQException e) {
                throw new RuntimeException("bizarre XQException occured.", e);
            }
        } else {
            b.append(XQDynamicExpression.XQJ_ITEMKIND_MAP[this.XQItemKind]);
        }
        switch (this.getItemOccurrence()) {
            case 1: {
                b.append('?');
                break;
            }
            case 3: {
                b.append('*');
                break;
            }
            case 4: {
                b.append('+');
            }
        }
        return b.toString();
    }

    public static final boolean isCompatibile(XQItemType t1, XQItemType t2) throws XQException {
        if (t1.getItemOccurrence() != t2.getItemOccurrence() && t1.getItemOccurrence() != 3 && t2.getItemOccurrence() != 3) {
            return false;
        }
        return t1.getBaseType() == t2.getBaseType() && t2.getItemKind() == t2.getItemKind() || t1.getItemKind() == 8 || t2.getItemKind() == 8;
    }

    public boolean equals(Object object) {
        if (!(object instanceof XQItemType)) {
            return false;
        }
        XQItemType xqit = (XQItemType)object;
        try {
            if (this.getItemKind() != xqit.getItemKind()) {
                System.out.println("Different Item Kinds");
                return false;
            }
            int itemKind = this.getItemKind();
            if ((itemKind == 5 || itemKind == 6 || itemKind == 7 || itemKind == 12 || itemKind == 2 || itemKind == 13 || itemKind == 1) && this.getBaseType() != xqit.getBaseType()) {
                System.out.println("Different Item BaseTypes (" + itemKind + ")");
                return false;
            }
            if (!(itemKind != 5 && itemKind != 6 && itemKind != 7 && itemKind != 12 && itemKind != 2 && itemKind != 13 || this.getNodeName() == null || this.getNodeName().equals(xqit.getNodeName()))) {
                System.out.println("Different Node Names");
                return false;
            }
            if (this.getSchemaURI() != null || xqit.getSchemaURI() != null || this.getSchemaURI() != null && this.getSchemaURI().equals(xqit.getSchemaURI()) || xqit.getSchemaURI() != null && xqit.getSchemaURI().equals(this.getSchemaURI())) {
                System.out.println("Different Schema URI (" + xqit.getSchemaURI() + ") (" + this.getSchemaURI() + ")");
                return false;
            }
            if (!(itemKind != 5 && itemKind != 6 && itemKind != 1 && itemKind != 7 && itemKind != 12 && itemKind != 2 && itemKind != 13 || this.getTypeName().equals(xqit.getTypeName()))) {
                System.out.println("Different Type Names");
                return false;
            }
            if (this.isAnonymousType() != xqit.isAnonymousType()) {
                System.out.println("Different Anonymous Types");
                return false;
            }
            if (this.isElementNillable() != xqit.isElementNillable()) {
                System.out.println("Different Element Nillables");
                return false;
            }
            if (itemKind == 10 && !this.getPIName().equals(xqit.getPIName())) {
                System.out.println("Different Processing Instruction Names");
                return false;
            }
            return true;
        }
        catch (XQException e) {
            throw new RuntimeException("XQException occurred, " + e.getMessage());
        }
    }
}

