/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JLabel;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXLayout;

public class BaseXLabel
extends JLabel {
    public BaseXLabel() {
        this("", false, false);
    }

    public BaseXLabel(String text) {
        this(text, false, false);
    }

    public BaseXLabel(String text, boolean dist, boolean bold) {
        super(text);
        if (dist) {
            this.border(0, 0, this.getFont().getSize() / 2, 0);
        }
        if (bold) {
            BaseXLayout.boldFont(this);
        }
    }

    public final BaseXLabel border(int t, int l, int b, int r) {
        this.setBorder(BaseXLayout.border(t, l, b, r));
        return this;
    }

    public final BaseXLabel resize(float factor) {
        BaseXLayout.resizeFont(this, factor);
        return this;
    }

    public final BaseXLabel setText(String text, GUIConstants.Msg icon) {
        this.setIcon(text == null ? null : icon.small);
        this.setText(text == null ? " " : text);
        return this;
    }

    public final BaseXLabel setChoppedText(String text, int width) {
        Object txt;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (width < fm.stringWidth((String)(txt = text))) {
            int tl = ((String)txt).length();
            while (tl > 0 && width < fm.stringWidth((String)txt + "...")) {
                txt = ((String)txt).substring(0, --tl);
            }
            txt = (String)txt + "...";
        }
        this.setText((String)txt);
        return this;
    }

    public final BaseXLabel large() {
        Font f = this.getFont();
        this.setFont(new Font(f.getName(), 1, (int)((double)f.getSize2D() * 1.4)));
        return this;
    }

    @Override
    public void setEnabled(boolean flag) {
        if (flag != this.isEnabled()) {
            super.setEnabled(flag);
        }
    }
}

