/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.func.fn.FnError;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;

public abstract class Mapping
extends Arr {
    Mapping(InputInfo info, SeqType seqType, Expr ... exprs) {
        super(info, seqType, exprs);
    }

    @Override
    public final void checkUp() throws QueryException {
        int el = this.exprs.length;
        for (int e = 0; e < el - 1; ++e) {
            this.checkNoUp(this.exprs[e]);
        }
        this.exprs[el - 1].checkUp();
    }

    @Override
    public final boolean vacuous() {
        return this.exprs[this.exprs.length - 1].vacuous();
    }

    @Override
    public final Expr compile(CompileContext cc) throws QueryException {
        int el = this.exprs.length;
        boolean items = this.items();
        for (int e = 0; e < el; ++e) {
            Expr expr = cc.compileOrError(this.exprs[e], e == 0);
            if (e == 0) {
                cc.pushFocus(expr, items);
            } else {
                cc.updateFocus(expr, items);
            }
            this.exprs[e] = expr;
        }
        cc.removeFocus();
        return this.optimize(cc);
    }

    abstract boolean items();

    @Override
    public final boolean has(Flag ... flags) {
        return Flag.FCS.oneOf(flags) || Flag.CTX.oneOf(flags) && this.exprs[0].has(Flag.CTX) || Flag.POS.oneOf(flags) && this.exprs[0].has(Flag.POS) || super.has(Flag.remove(flags, Flag.POS, Flag.CTX));
    }

    @Override
    public final boolean accept(ASTVisitor visitor) {
        visitor.enterFocus();
        if (!Mapping.visitAll(visitor, this.exprs)) {
            return false;
        }
        visitor.exitFocus();
        return true;
    }

    @Override
    public final VarUsage count(Var var) {
        VarUsage uses = this.exprs[0].count(var);
        if (var != null) {
            boolean items = this.items();
            int el = this.exprs.length;
            for (int e = 1; e < el && uses != VarUsage.MORE_THAN_ONCE; ++e) {
                VarUsage vu = this.exprs[e].count(var);
                if (vu == VarUsage.NEVER) continue;
                uses = items ? VarUsage.MORE_THAN_ONCE : uses.plus(vu);
            }
        }
        return uses;
    }

    @Override
    public final boolean inlineable(InlineContext ic) {
        if (ic.var != null && ic.expr.has(Flag.CTX)) {
            int el = this.exprs.length;
            for (int e = 1; e < el; ++e) {
                if (!this.exprs[e].uses(ic.var)) continue;
                return false;
            }
        }
        return this.exprs[0].inlineable(ic);
    }

    @Override
    public final Expr inline(InlineContext ic) throws QueryException {
        boolean changed = false;
        CompileContext cc = ic.cc;
        int el = ic.var == null ? 1 : this.exprs.length;
        boolean items = this.items();
        for (int e = 0; e < el; ++e) {
            Expr inlined;
            try {
                inlined = this.exprs[e].inline(ic);
            }
            catch (QueryException ex) {
                inlined = FnError.get(ex, this.exprs[e]);
            }
            if (inlined != null) {
                this.exprs[e] = inlined;
                changed = true;
            } else {
                inlined = this.exprs[e];
            }
            if (e == 0) {
                cc.pushFocus(inlined, items);
                continue;
            }
            cc.updateFocus(inlined, items);
        }
        cc.removeFocus();
        return changed ? this.optimize(cc) : null;
    }

    @Override
    public final void markTailCalls(CompileContext cc) {
        int el = this.exprs.length - 1;
        if (this.items()) {
            for (int e = 0; e < el; ++e) {
                if (this.exprs[e].seqType().zeroOrOne()) continue;
                return;
            }
        }
        this.exprs[el].markTailCalls(cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Expr[] merge(CompileContext cc) throws QueryException {
        int el = this.exprs.length;
        ExprList list = (ExprList)((Object)new ExprList(el).add(this.exprs[0]));
        boolean pushed = false;
        try {
            boolean items = this.items();
            for (int e = 1; e < el; ++e) {
                Expr merged = this.merge((Expr)list.peek(), this.exprs[e], cc);
                if (merged != null) {
                    list.set(list.size() - 1, merged);
                } else {
                    list.add(this.exprs[e]);
                }
                if (list.size() <= 1) continue;
                Expr expr = (Expr)list.get(list.size() - 2);
                if (pushed) {
                    cc.updateFocus(expr, items);
                    continue;
                }
                cc.pushFocus(expr, items);
                pushed = true;
            }
        }
        finally {
            if (pushed) {
                cc.removeFocus();
            }
        }
        for (int n = list.size() - 1; n > 0; --n) {
            if (!(list.get(n) instanceof ContextValue)) continue;
            list.remove(n);
        }
        int ls = list.size();
        if (ls == el) {
            return null;
        }
        cc.info("simplify %: %", this::description, this);
        return (Expr[])list.finish();
    }

    static Expr inline(Expr expr, Expr next, CompileContext cc) {
        if (!next.has(Flag.POS, Flag.HOF)) {
            InlineContext ic = new InlineContext(null, expr, cc);
            if (ic.inlineable(next)) {
                Expr inlined;
                try {
                    inlined = ic.inline(next);
                }
                catch (QueryException ex) {
                    inlined = FnError.get(ex, next);
                }
                return inlined;
            }
        }
        return null;
    }

    abstract Expr merge(Expr var1, Expr var2, CompileContext var3) throws QueryException;
}

