/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.exec;

import java.sql.SQLException;
import java.sql.Savepoint;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSavepoint;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;

public class JDBCSavepointImpl
implements DBCSavepoint,
Savepoint {
    private static final Log log = Log.getLog(JDBCSavepointImpl.class);
    private final JDBCExecutionContext context;
    private final Savepoint original;

    public JDBCSavepointImpl(@NotNull JDBCExecutionContext context, @NotNull Savepoint savepoint) {
        this.context = context;
        this.original = savepoint;
    }

    public int getId() {
        try {
            return this.original.getSavepointId();
        }
        catch (SQLException e) {
            log.error((Object)e);
            return 0;
        }
    }

    public String getName() {
        try {
            return this.original.getSavepointName();
        }
        catch (SQLException e) {
            log.error((Object)e);
            return null;
        }
    }

    @NotNull
    public DBCExecutionContext getContext() {
        return this.context;
    }

    @Override
    public int getSavepointId() throws SQLException {
        return this.original.getSavepointId();
    }

    @Override
    public String getSavepointName() throws SQLException {
        return this.original.getSavepointName();
    }

    public Savepoint getOriginal() {
        return this.original;
    }
}

