/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.zoom;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.internal.Messages;
import org.eclipse.draw2d.zoom.DefaultScrollPolicy;
import org.eclipse.draw2d.zoom.IZoomScrollPolicy;
import org.eclipse.draw2d.zoom.ZoomListener;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractZoomManager {
    public static final int ANIMATE_NEVER = 0;
    public static final int ANIMATE_ZOOM_IN_OUT = 1;
    private final List<ZoomListener> listeners = new CopyOnWriteArrayList<ZoomListener>();
    private double multiplier = 1.0;
    private final ScalableFigure pane;
    private final Viewport viewport;
    private double zoom = 1.0;
    private double[] zoomLevels = new double[]{0.5, 0.75, 1.0, 1.5, 2.0, 2.5, 3.0, 4.0};
    private List<String> zoomLevelContributions = Collections.emptyList();
    DecimalFormat format = new DecimalFormat(Messages.AbstractZoomManager_PercentFormat);
    private IZoomScrollPolicy scrollPolicy;

    protected AbstractZoomManager(ScalableFigure pane, Viewport viewport, IZoomScrollPolicy scrollPolicy) {
        this.pane = pane;
        this.viewport = viewport;
        this.scrollPolicy = scrollPolicy;
    }

    protected AbstractZoomManager(ScalableFigure pane, Viewport viewport) {
        this(pane, viewport, new DefaultScrollPolicy());
    }

    public void addZoomListener(ZoomListener listener) {
        this.listeners.add(listener);
    }

    public void removeZoomListener(ZoomListener listener) {
        this.listeners.remove(listener);
    }

    public boolean canZoomIn() {
        return this.getZoom() < this.getMaxZoom();
    }

    public boolean canZoomOut() {
        return this.getZoom() > this.getMinZoom();
    }

    protected void fireZoomChanged() {
        this.listeners.forEach(listener -> listener.zoomChanged(this.zoom));
    }

    private double getFitXZoomLevel(int which) {
        Dimension dimension;
        IFigure fig = this.getScalableFigure();
        Dimension available = this.getViewport().getClientArea().getSize();
        if (fig instanceof FreeformFigure) {
            FreeformFigure freeFormFig = (FreeformFigure)fig;
            dimension = freeFormFig.getFreeformExtent().getCopy().union(0, 0).getSize();
        } else {
            dimension = fig.getPreferredSize().getCopy();
        }
        Dimension desired = dimension;
        desired.width -= fig.getInsets().getWidth();
        desired.height -= fig.getInsets().getHeight();
        while (fig != this.getViewport()) {
            available.width -= fig.getInsets().getWidth();
            available.height -= fig.getInsets().getHeight();
            fig = fig.getParent();
        }
        double scaleX = Math.min((double)available.width * this.zoom / (double)desired.width, this.getMaxZoom());
        double scaleY = Math.min((double)available.height * this.zoom / (double)desired.height, this.getMaxZoom());
        if (which == 0) {
            return scaleX;
        }
        if (which == 1) {
            return scaleY;
        }
        return Math.min(scaleX, scaleY);
    }

    protected double getFitHeightZoomLevel() {
        return this.getFitXZoomLevel(1);
    }

    protected double getFitPageZoomLevel() {
        return this.getFitXZoomLevel(2);
    }

    protected double getFitWidthZoomLevel() {
        return this.getFitXZoomLevel(0);
    }

    public double getMaxZoom() {
        return this.getZoomLevels()[this.getZoomLevels().length - 1];
    }

    public double getMinZoom() {
        return this.getZoomLevels()[0];
    }

    public double getUIMultiplier() {
        return this.multiplier;
    }

    public double getNextZoomLevel() {
        double[] dArray = this.zoomLevels;
        int n = this.zoomLevels.length;
        int n2 = 0;
        while (n2 < n) {
            double zoomLevel = dArray[n2];
            if (zoomLevel > this.zoom) {
                return zoomLevel;
            }
            ++n2;
        }
        return this.getMaxZoom();
    }

    public double getPreviousZoomLevel() {
        int i = 1;
        while (i < this.zoomLevels.length) {
            if (this.zoomLevels[i] >= this.zoom) {
                return this.zoomLevels[i - 1];
            }
            ++i;
        }
        return this.getMinZoom();
    }

    public ScalableFigure getScalableFigure() {
        return this.pane;
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public double getZoom() {
        return this.zoom;
    }

    public String getZoomAsText() {
        return this.format.format(this.zoom * this.multiplier);
    }

    public List<String> getZoomLevelContributions() {
        return this.zoomLevelContributions;
    }

    public double[] getZoomLevels() {
        return this.zoomLevels;
    }

    public String[] getZoomLevelsAsText() {
        String[] zoomLevelStrings = new String[this.zoomLevels.length + this.zoomLevelContributions.size()];
        int i = 0;
        while (i < this.zoomLevels.length) {
            zoomLevelStrings[i] = this.format.format(this.zoomLevels[i] * this.multiplier);
            ++i;
        }
        i = 0;
        while (i < this.zoomLevelContributions.size()) {
            zoomLevelStrings[i + this.zoomLevels.length] = this.zoomLevelContributions.get(i);
            ++i;
        }
        return zoomLevelStrings;
    }

    protected void primSetZoom(double zoom) {
        Point newLocation = this.scrollPolicy.calcNewViewLocation(this.getViewport(), this.zoom, zoom);
        this.zoom = zoom;
        this.pane.setScale(zoom);
        this.fireZoomChanged();
        this.getViewport().validate();
        this.setViewLocation(newLocation);
    }

    public void setUIMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    public void setViewLocation(Point p) {
        this.viewport.setViewLocation(p.x, p.y);
    }

    public void setZoom(double zoom) {
        zoom = Math.min(this.getMaxZoom(), zoom);
        zoom = Math.max(this.getMinZoom(), zoom);
        if (this.zoom != zoom) {
            this.primSetZoom(zoom);
        }
    }

    public void setZoomAnimationStyle(int style) {
    }

    public void setZoomAsText(String zoomString) {
        if (this.isFitHeight(zoomString)) {
            this.primSetZoom(this.getFitHeightZoomLevel());
            this.viewport.getUpdateManager().performUpdate();
            this.viewport.setViewLocation(this.viewport.getHorizontalRangeModel().getValue(), this.viewport.getVerticalRangeModel().getMinimum());
        } else if (this.isFitAll(zoomString)) {
            this.primSetZoom(this.getFitPageZoomLevel());
            this.viewport.getUpdateManager().performUpdate();
            this.viewport.setViewLocation(this.viewport.getHorizontalRangeModel().getMinimum(), this.viewport.getVerticalRangeModel().getMinimum());
        } else if (this.isFitWidth(zoomString)) {
            this.primSetZoom(this.getFitWidthZoomLevel());
            this.viewport.getUpdateManager().performUpdate();
            this.viewport.setViewLocation(this.viewport.getHorizontalRangeModel().getMinimum(), this.viewport.getVerticalRangeModel().getValue());
        } else {
            try {
                if (zoomString.charAt(zoomString.length() - 1) == '%') {
                    zoomString = zoomString.substring(0, zoomString.length() - 1);
                }
                double newZoom = NumberFormat.getInstance().parse(zoomString).doubleValue() / 100.0;
                this.setZoom(newZoom / this.multiplier);
            }
            catch (Exception e) {
                Display.getCurrent().beep();
            }
        }
    }

    protected abstract boolean isFitWidth(String var1);

    protected abstract boolean isFitAll(String var1);

    protected abstract boolean isFitHeight(String var1);

    public void setZoomLevelContributions(List<String> contributions) {
        this.zoomLevelContributions = contributions != null ? contributions : Collections.emptyList();
    }

    public void setZoomLevels(double[] zoomLevels) {
        this.zoomLevels = zoomLevels;
    }

    public void setScrollPolicy(IZoomScrollPolicy scrollPolicy) {
        this.scrollPolicy = scrollPolicy;
    }

    public void zoomIn() {
        this.setZoom(this.getNextZoomLevel());
    }

    public void zoomTo(Rectangle rect) {
    }

    public void zoomOut() {
        this.setZoom(this.getPreviousZoomLevel());
    }
}

