/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.select;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueFunctionExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;

public class SQLQueryRowsTableProcModel
extends SQLQueryRowsSourceModel {
    private static final Log log = Log.getLog(SQLQueryRowsTableProcModel.class);
    @NotNull
    private final SQLQueryValueFunctionExpression callExpr;

    public SQLQueryRowsTableProcModel(@NotNull SQLQueryValueFunctionExpression callExpr) {
        super(callExpr.getSyntaxNode(), new SQLQueryNodeModel[0]);
        this.callExpr = callExpr;
    }

    @NotNull
    public SQLQueryValueFunctionExpression getFunctionExpression() {
        return this.callExpr;
    }

    @Override
    protected SQLQueryRowsSourceContext resolveRowSourcesImpl(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics) {
        this.callExpr.resolveRowSources(context, statistics);
        return context.reset();
    }

    @Override
    protected SQLQueryRowsDataContext resolveRowDataImpl(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        this.callExpr.resolveValueRelations(context, statistics);
        SQLQueryExprType procResult = this.callExpr.getValueType();
        LinkedList<SQLQueryResultColumn> resultColumns = new LinkedList<SQLQueryResultColumn>();
        if (procResult != SQLQueryExprType.UNKNOWN) {
            try {
                SQLQueryExprType rowType = procResult.findIndexedItemType(statistics.getMonitor(), 1, null);
                if (rowType != null) {
                    for (SQLQueryExprType.SQLQueryExprTypeMemberInfo field : rowType.getNamedMembers(statistics.getMonitor())) {
                        resultColumns.addLast(new SQLQueryResultColumn(resultColumns.size(), new SQLQuerySymbol(field.name()), this, null, field.attribute(), field.type()));
                    }
                } else {
                    statistics.appendError(this.getSyntaxNode(), this.callExpr.getProcName().getNameString() + " is not a rowset-producing procedure");
                }
            }
            catch (DBException e) {
                String message = "Failed to resolve function result fields for " + String.valueOf(this.callExpr.getProcName());
                log.debug((Object)message, (Throwable)e);
                statistics.appendError(this.getSyntaxNode(), message);
                this.getRowsSources().resetAsUnresolved().makeEmptyTuple();
            }
        }
        return this.getRowsSources().makeTuple(this, List.copyOf(resultColumns), Collections.emptyList());
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitRowsTableProc(this, arg);
    }
}

