/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.LabelRetargetAction;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.internal.IActionSetContributionItem;
import org.eclipse.ui.internal.PluginAction;

public class WWinPluginAction
extends PluginAction
implements IActionSetContributionItem {
    private HelpListener localHelpListener;
    private IWorkbenchWindow window;
    private String actionSetId;
    private RetargetAction retargetAction;
    private static ArrayList<WWinPluginAction> staticActionList = new ArrayList(50);

    public WWinPluginAction(IConfigurationElement actionElement, IWorkbenchWindow window, String id, int style) {
        super(actionElement, id, style);
        this.window = window;
        String retarget = actionElement.getAttribute("retarget");
        if (retarget != null && Boolean.parseBoolean(retarget)) {
            String allowLabelUpdate = actionElement.getAttribute("allowLabelUpdate");
            String label = actionElement.getAttribute("label");
            this.retargetAction = allowLabelUpdate != null && Boolean.parseBoolean(allowLabelUpdate) ? new LabelRetargetAction(id, label, style) : new RetargetAction(id, label, style);
            this.retargetAction.addPropertyChangeListener(event -> {
                Object val4;
                if (event.getProperty().equals("enabled")) {
                    Object val1 = event.getNewValue();
                    if (val1 instanceof Boolean) {
                        this.setEnabled((Boolean)val1);
                    }
                } else if (event.getProperty().equals("checked")) {
                    Object val2 = event.getNewValue();
                    if (val2 instanceof Boolean) {
                        this.setChecked((Boolean)val2);
                    }
                } else if (event.getProperty().equals("text")) {
                    Object val3 = event.getNewValue();
                    if (val3 instanceof String) {
                        this.setText((String)val3);
                    }
                } else if (event.getProperty().equals("toolTipText") && (val4 = event.getNewValue()) instanceof String) {
                    this.setToolTipText((String)val4);
                }
            });
            this.retargetAction.setEnabled(false);
            this.setEnabled(false);
            window.getPartService().addPartListener(this.retargetAction);
            IWorkbenchPart activePart = window.getPartService().getActivePart();
            if (activePart != null) {
                this.retargetAction.partActivated(activePart);
            }
        } else {
            window.getSelectionService().addSelectionListener(this);
            this.refreshSelection();
        }
        WWinPluginAction.addToActionList(this);
        super.setHelpListener(e -> {
            HelpListener listener = null;
            if (this.retargetAction != null) {
                listener = this.retargetAction.getHelpListener();
            }
            if (listener == null) {
                listener = this.localHelpListener;
            }
            if (listener != null) {
                listener.helpRequested(e);
            }
        });
    }

    private static void addToActionList(WWinPluginAction action) {
        staticActionList.add(action);
        Shell shell = action.window.getShell();
        if (shell != null) {
            shell.addDisposeListener(x -> action.dispose());
        }
    }

    private static void removeFromActionList(WWinPluginAction action) {
        staticActionList.remove(action);
    }

    public static void refreshActionList() {
        for (WWinPluginAction action : staticActionList) {
            if (action.getDelegate() != null || !action.isOkToCreateDelegate()) continue;
            action.createDelegate();
        }
    }

    @Override
    protected IActionDelegate validateDelegate(Object obj) throws WorkbenchException {
        if (obj instanceof IWorkbenchWindowActionDelegate) {
            return (IWorkbenchWindowActionDelegate)obj;
        }
        throw new WorkbenchException("Action must implement IWorkbenchWindowActionDelegate");
    }

    @Override
    protected void initDelegate() {
        super.initDelegate();
        ((IWorkbenchWindowActionDelegate)this.getDelegate()).init(this.window);
    }

    @Override
    public void dispose() {
        if (this.window == null) {
            return;
        }
        WWinPluginAction.removeFromActionList(this);
        if (this.retargetAction != null) {
            this.window.getPartService().removePartListener(this.retargetAction);
            this.retargetAction.dispose();
            this.retargetAction = null;
        }
        this.window.getSelectionService().removeSelectionListener(this);
        super.dispose();
        this.window = null;
    }

    @Override
    public String getActionSetId() {
        return this.actionSetId;
    }

    @Override
    public boolean isOkToCreateDelegate() {
        return super.isOkToCreateDelegate() && this.window != null && this.retargetAction == null;
    }

    @Override
    public void runWithEvent(Event event) {
        if (this.retargetAction == null) {
            super.runWithEvent(event);
            return;
        }
        if (event != null) {
            this.retargetAction.runWithEvent(event);
        } else {
            this.retargetAction.run();
        }
    }

    @Override
    public void setActionSetId(String newActionSetId) {
        this.actionSetId = newActionSetId;
    }

    public void setHelpListener(HelpListener listener) {
        this.localHelpListener = listener;
    }

    public void setChecked(boolean checked) {
        super.setChecked(checked);
        if (this.retargetAction != null) {
            this.retargetAction.setChecked(checked);
        }
    }

    protected void refreshSelection() {
        ISelection selection = this.window.getSelectionService().getSelection();
        this.selectionChanged(selection);
    }

    public String toString() {
        return "WWinPluginAction [id=" + this.getId() + ", enabled=" + this.isEnabled() + (String)(this.actionSetId != null ? ", actionSet=" + this.actionSetId : "") + "]";
    }
}

