#!/bin/sh

LC_NUMERIC=en_US.ISO8859-1
export LC_NUMERIC

files="None"
while [ x"$1" != x ]; do
    case $1 in
	-file)
            files="$2"
	    shift
	    shift
	    continue;;
	*)  
            break;;
    esac
done

if [ x"$1" = xgnuplot ]; then

  if [ x`which gnuplot 2>/dev/null` = x ]; then
    echo "ERROR: gnuplot not available"
    exit 1
  fi
  awk '
  BEGIN{
    mode=1
    initparam=0
    counts=0
  }
  mode==1{
    if( initparam == 0 ){
      if( files == "None" ){
        files=""
        dofile="true"
      }
      else{
        dofile="false"
      }
      initparam=1
    }
    if( dofile == "true" && $1 == "#" && $2 == "data" && $3 == "file:" ){
      if( files != "" ) files = files ","
      files = files $4
    }
    else if( $1 == "#" && $2 == "column:" ){
      column = $3
    }
    else if( $1 == "------" ){
      head = sprintf("set nokey; set title \"funhist(%s)\"\n", files)
      head = head sprintf("set xlabel \"%s_bin\"\n", column)
      head = head sprintf("set ylabel \"value\"\n")
      head = head sprintf("plot \"-\" with boxes\n")
      mode = 2
      next
    }
  }
  mode==2{
    if( NF == 4 ){
      if( $4 > $3 ){
        data = data sprintf("%.8f %s %s\n", ($3+$4)/2, $2, ($4-$3))
      }
      else{
        data = data sprintf("%.8f %s 1\n", ($3+$4)/2, $2)
      }
      counts += $2
    }
    else{
     mode = 3
    }
  }
  END{
    if( counts == 0 ){
      exit 0
    }
    else{
      print head
      print data
    }
  }
  ' files="$files" | gnuplot -persist - 1>/dev/null 2>&1
  exit 0

elif [ x"$1" = xds9 ]; then

  awk '
  BEGIN{
    mode=1
    initparam=0
  }
  mode==1{
    if( initparam == 0 ){
      if( files == "None" ){
        files=""
        dofile="true"
      }
      else{
        dofile="false"
      }
      initparam=1
    }
    if( dofile == "true" && $1 == "#" && $2 == "data" && $3 == "file:" ){
      if( files != "" ) files = files ","
      files = files $4
    }
    else if( $1 == "#" && $2 == "column:" ){
      column = $3
    }
    else if( $1 == "------" ){
      ds9header="'"${DS9_PLOT_HEADER}"'"
      if( ds9header != "" ) {
	  printf "%s 2\n", ds9header
      }
      else{
          printf "funhist(%s) %s_bin value 2\n", files, column
      }
      mode = 2
      next
    }
  }
  mode==2{
    if( NF == 4 ){
      printf "%.8f %s\n", ($3+$4)/2, $2
    }
    else{
      mode = 3
    }
  }
  ' files="$files"
  exit 0
else
  
  echo "ERROR: unknown argument: " $1
  echo "funhist ... | funhist.plot [ds9|gnuplot]"
  exit 1

fi
