/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { Storage } from '../config/storage.js';
import { type SkillDefinition } from './skillLoader.js';
import type { GeminiCLIExtension } from '../config/config.js';
export { type SkillDefinition };
export declare class SkillManager {
    private skills;
    private activeSkillNames;
    /**
     * Clears all discovered skills.
     */
    clearSkills(): void;
    /**
     * Discovers skills from standard user and project locations, as well as extensions.
     * Precedence: Extensions (lowest) -> User -> Project (highest).
     */
    discoverSkills(storage: Storage, extensions?: GeminiCLIExtension[]): Promise<void>;
    private addSkillsWithPrecedence;
    /**
     * Returns the list of enabled discovered skills.
     */
    getSkills(): SkillDefinition[];
    /**
     * Returns all discovered skills, including disabled ones.
     */
    getAllSkills(): SkillDefinition[];
    /**
     * Filters discovered skills by name.
     */
    filterSkills(predicate: (skill: SkillDefinition) => boolean): void;
    /**
     * Sets the list of disabled skill names.
     */
    setDisabledSkills(disabledNames: string[]): void;
    /**
     * Reads the full content (metadata + body) of a skill by name.
     */
    getSkill(name: string): SkillDefinition | null;
    /**
     * Activates a skill by name.
     */
    activateSkill(name: string): void;
    /**
     * Checks if a skill is active.
     */
    isSkillActive(name: string): boolean;
}
