import { ae as AgentCard, x as MessageSendParams, S as SendMessageResponse, F as Message, ay as Task, aQ as TaskStatusUpdateEvent, aS as TaskArtifactUpdateEvent, $ as TaskPushNotificationConfig, b as SetTaskPushNotificationConfigResponse, Z as TaskIdParams, c as GetTaskPushNotificationConfigResponse, a7 as ListTaskPushNotificationConfigParams, k as ListTaskPushNotificationConfigResponse, a9 as DeleteTaskPushNotificationConfigParams, h as DeleteTaskPushNotificationConfigResponse, X as TaskQueryParams, G as GetTaskResponse, C as CancelTaskResponse, j as JSONRPCResponse, E as Extensions, a3 as GetTaskPushNotificationConfigParams, z as PushNotificationConfig } from './extensions-DvruCIzw.cjs';

type A2AStreamEventData = Message | Task | TaskStatusUpdateEvent | TaskArtifactUpdateEvent;
type SendMessageResult = Message | Task;
interface A2AClientOptions {
    agentCardPath?: string;
    fetchImpl?: typeof fetch;
}
/**
 * A2AClient is a TypeScript HTTP client for interacting with A2A-compliant agents.
 * Only JSON-RPC transport is supported.
 * @deprecated Use {@link ClientFactory}
 */
declare class A2AClient {
    private static emptyOptions?;
    private readonly agentCardPromise;
    private readonly customFetchImpl?;
    private serviceEndpointUrl?;
    private transport?;
    private requestIdCounter;
    /**
     * Constructs an A2AClient instance from an AgentCard.
     * @param agentCard The AgentCard object.
     * @param options Optional. The options for the A2AClient including the fetch/auth implementation.
     */
    constructor(agentCard: AgentCard | string, options?: A2AClientOptions);
    /**
     * Dynamically resolves the fetch implementation to use for requests.
     * Prefers a custom implementation if provided, otherwise falls back to the global fetch.
     * @returns The fetch implementation.
     * @param args Arguments to pass to the fetch implementation.
     * @throws If no fetch implementation is available.
     */
    private _fetch;
    /**
     * Creates an A2AClient instance by fetching the AgentCard from a URL then constructing the A2AClient.
     * @param agentCardUrl The URL of the agent card.
     * @param options Optional. The options for the A2AClient including the fetch/auth implementation.
     * @returns A Promise that resolves to a new A2AClient instance.
     */
    static fromCardUrl(agentCardUrl: string, options?: A2AClientOptions): Promise<A2AClient>;
    /**
     * Sends a message to the agent.
     * The behavior (blocking/non-blocking) and push notification configuration
     * are specified within the `params.configuration` object.
     * Optionally, `params.message.contextId` or `params.message.taskId` can be provided.
     * @param params The parameters for sending the message, including the message content and configuration.
     * @returns A Promise resolving to SendMessageResponse, which can be a Message, Task, or an error.
     */
    sendMessage(params: MessageSendParams): Promise<SendMessageResponse>;
    /**
     * Sends a message to the agent and streams back responses using Server-Sent Events (SSE).
     * Push notification configuration can be specified in `params.configuration`.
     * Optionally, `params.message.contextId` or `params.message.taskId` can be provided.
     * Requires the agent to support streaming (`capabilities.streaming: true` in AgentCard).
     * @param params The parameters for sending the message.
     * @returns An AsyncGenerator yielding A2AStreamEventData (Message, Task, TaskStatusUpdateEvent, or TaskArtifactUpdateEvent).
     * The generator throws an error if streaming is not supported or if an HTTP/SSE error occurs.
     */
    sendMessageStream(params: MessageSendParams): AsyncGenerator<A2AStreamEventData, void, undefined>;
    /**
     * Sets or updates the push notification configuration for a given task.
     * Requires the agent to support push notifications (`capabilities.pushNotifications: true` in AgentCard).
     * @param params Parameters containing the taskId and the TaskPushNotificationConfig.
     * @returns A Promise resolving to SetTaskPushNotificationConfigResponse.
     */
    setTaskPushNotificationConfig(params: TaskPushNotificationConfig): Promise<SetTaskPushNotificationConfigResponse>;
    /**
     * Gets the push notification configuration for a given task.
     * @param params Parameters containing the taskId.
     * @returns A Promise resolving to GetTaskPushNotificationConfigResponse.
     */
    getTaskPushNotificationConfig(params: TaskIdParams): Promise<GetTaskPushNotificationConfigResponse>;
    /**
     * Lists the push notification configurations for a given task.
     * @param params Parameters containing the taskId.
     * @returns A Promise resolving to ListTaskPushNotificationConfigResponse.
     */
    listTaskPushNotificationConfig(params: ListTaskPushNotificationConfigParams): Promise<ListTaskPushNotificationConfigResponse>;
    /**
     * Deletes the push notification configuration for a given task.
     * @param params Parameters containing the taskId and push notification configuration ID.
     * @returns A Promise resolving to DeleteTaskPushNotificationConfigResponse.
     */
    deleteTaskPushNotificationConfig(params: DeleteTaskPushNotificationConfigParams): Promise<DeleteTaskPushNotificationConfigResponse>;
    /**
     * Retrieves a task by its ID.
     * @param params Parameters containing the taskId and optional historyLength.
     * @returns A Promise resolving to GetTaskResponse, which contains the Task object or an error.
     */
    getTask(params: TaskQueryParams): Promise<GetTaskResponse>;
    /**
     * Cancels a task by its ID.
     * @param params Parameters containing the taskId.
     * @returns A Promise resolving to CancelTaskResponse, which contains the updated Task object or an error.
     */
    cancelTask(params: TaskIdParams): Promise<CancelTaskResponse>;
    /**
     * @template TExtensionParams The type of parameters for the custom extension method.
     * @template TExtensionResponse The type of response expected from the custom extension method.
     * This should extend JSONRPCResponse. This ensures the extension response is still a valid A2A response.
     * @param method Custom JSON-RPC method defined in the AgentCard's extensions.
     * @param params Extension paramters defined in the AgentCard's extensions.
     * @returns A Promise that resolves to the RPC response.
     */
    callExtensionMethod<TExtensionParams, TExtensionResponse extends JSONRPCResponse>(method: string, params: TExtensionParams): Promise<TExtensionResponse>;
    /**
     * Resubscribes to a task's event stream using Server-Sent Events (SSE).
     * This is used if a previous SSE connection for an active task was broken.
     * Requires the agent to support streaming (`capabilities.streaming: true` in AgentCard).
     * @param params Parameters containing the taskId.
     * @returns An AsyncGenerator yielding A2AStreamEventData (Message, Task, TaskStatusUpdateEvent, or TaskArtifactUpdateEvent).
     */
    resubscribeTask(params: TaskIdParams): AsyncGenerator<A2AStreamEventData, void, undefined>;
    private _getOrCreateTransport;
    /**
     * Fetches the Agent Card from the agent's well-known URI and caches its service endpoint URL.
     * This method is called by the constructor.
     * @param agentBaseUrl The base URL of the A2A agent (e.g., https://agent.example.com)
     * @param agentCardPath path to the agent card, defaults to .well-known/agent-card.json
     * @returns A Promise that resolves to the AgentCard.
     */
    private _fetchAndCacheAgentCard;
    /**
     * Retrieves the Agent Card.
     * If an `agentBaseUrl` is provided, it fetches the card from that specific URL.
     * Otherwise, it returns the card fetched and cached during client construction.
     * @param agentBaseUrl Optional. The base URL of the agent to fetch the card from.
     * @param agentCardPath path to the agent card, defaults to .well-known/agent-card.json
     * If provided, this will fetch a new card, not use the cached one from the constructor's URL.
     * @returns A Promise that resolves to the AgentCard.
     */
    getAgentCard(agentBaseUrl?: string, agentCardPath?: string): Promise<AgentCard>;
    /**
     * Determines the agent card URL based on the agent URL.
     * @param agentBaseUrl The agent URL.
     * @param agentCardPath Optional relative path to the agent card, defaults to .well-known/agent-card.json
     */
    private resolveAgentCardUrl;
    /**
     * Gets the RPC service endpoint URL. Ensures the agent card has been fetched first.
     * @returns A Promise that resolves to the service endpoint URL string.
     */
    private _getServiceEndpoint;
    private invokeJsonRpc;
}

/**
 * Function that applies an update to a {@link ClientCallContext}.
 */
type ContextUpdate = (context: ClientCallContext) => void;
/**
 * Opaque context object to carry per-call context data.
 * Use {@link ClientCallContextKey} to create typed keys for storing and retrieving values.
 */
type ClientCallContext = Record<symbol, unknown>;
declare const ClientCallContext: {
    /**
     * Create a new {@link ClientCallContext} with optional updates applied.
     */
    create: (...updates: ContextUpdate[]) => ClientCallContext;
    /**
     * Create a new {@link ClientCallContext} based on an existing one with updates applied.
     */
    createFrom: (context: ClientCallContext | undefined, ...updates: ContextUpdate[]) => ClientCallContext;
};
/**
 * Each instance represents a unique key for storing
 * and retrieving typed values in a {@link ClientCallContext}.
 *
 * @example
 * ```ts
 * const key = new ClientCallContextKey<string>('My key');
 * const context = ClientCallContext.create(key.set('example-value'));
 * const value = key.get(context); // 'example-value'
 * ```
 */
declare class ClientCallContextKey<T> {
    readonly symbol: symbol;
    constructor(description: string);
    set(value: T): ContextUpdate;
    get(context: ClientCallContext): T | undefined;
}

interface CallInterceptor {
    /**
     * Invoked before transport method.
     */
    before(args: BeforeArgs): Promise<void>;
    /**
     * Invoked after transport method.
     */
    after(args: AfterArgs): Promise<void>;
}
interface BeforeArgs<K extends keyof Client = keyof Client> {
    /**
     * Identifies the client method invoked and its payload.
     * Payload inside the input object can be modified.
     */
    readonly input: ClientCallInput<K>;
    /**
     * Identifies the agent card cached on the client
     */
    readonly agentCard: AgentCard;
    /**
     * If set by the interceptor, stops execution, invokes "after"
     * for executed interceptors and returns the result. Transport is not called.
     */
    earlyReturn?: ClientCallResult<K>;
    /**
     * Options passed to the client.
     */
    options?: RequestOptions;
}
interface AfterArgs<K extends keyof Client = keyof Client> {
    /**
     * Identifies the client method invoked and its result.
     * Payload inside the result object can be modified.
     */
    readonly result: ClientCallResult<K>;
    /**
     * Identifies the agent card cached on the client
     */
    readonly agentCard: AgentCard;
    /**
     * If set by the interceptor, stops execution and returns result value,
     * remaining interceptors are not executed.
     */
    earlyReturn?: boolean;
    /**
     * Options passed to the client.
     */
    options?: RequestOptions;
}
type ClientCallInput<K extends keyof Client = keyof Client> = MethodInput<Client, K>;
type ClientCallResult<K extends keyof Client = keyof Client> = MethodResult<Client, K, ResultsOverrides>;
/**
 * For
 *
 * interface Foo {
 *   f1(arg: string): Promise<Result1>;
 *   f2(arg: number): Promise<Result2>;
 * }
 *
 * MethodInputs<Foo> resolves to
 *
 * {
 *   readonly method: "f1";
 *   value: string;
 * } | {
 *   readonly method: "f2";
 *   value: number;
 * }
 */
type MethodInput<T, TMembers extends keyof T = keyof T> = {
    [M in TMembers]: T[M] extends (options: RequestOptions | undefined) => unknown ? {
        readonly method: M;
        value?: never;
    } : T[M] extends (payload: infer P) => unknown ? {
        readonly method: M;
        value: P;
    } : never;
}[TMembers];
/**
 * For
 *
 * interface Foo {
 *   f1(): Promise<Result1>;
 *   f2(): Promise<Result2>;
 * }
 *
 * MethodsResults<Foo> resolves to
 *
 * {
 *   readonly method: "f1";
 *   value: Result1;
 * } | {
 *   readonly method: "f2";
 *   value: Result2;
 * }
 */
type MethodResult<T, TMembers extends keyof T = keyof T, TOverrides = object> = {
    [M in TMembers]: M extends keyof TOverrides ? {
        readonly method: M;
        value: TOverrides[M];
    } : T[M] extends (payload: unknown) => infer R ? {
        readonly method: M;
        value: Awaited<R>;
    } : never;
}[TMembers];
interface ResultsOverrides {
    sendMessageStream: A2AStreamEventData;
    resubscribeTask: A2AStreamEventData;
}

type ServiceParametersUpdate = (parameters: ServiceParameters) => void;
type ServiceParameters = Record<string, string>;
declare const ServiceParameters: {
    create(...updates: ServiceParametersUpdate[]): ServiceParameters;
    createFrom: (serviceParameters: ServiceParameters | undefined, ...updates: ServiceParametersUpdate[]) => ServiceParameters;
};
declare function withA2AExtensions(...extensions: Extensions): ServiceParametersUpdate;

interface Transport {
    getExtendedAgentCard(options?: RequestOptions): Promise<AgentCard>;
    sendMessage(params: MessageSendParams, options?: RequestOptions): Promise<SendMessageResult>;
    sendMessageStream(params: MessageSendParams, options?: RequestOptions): AsyncGenerator<A2AStreamEventData, void, undefined>;
    setTaskPushNotificationConfig(params: TaskPushNotificationConfig, options?: RequestOptions): Promise<TaskPushNotificationConfig>;
    getTaskPushNotificationConfig(params: GetTaskPushNotificationConfigParams, options?: RequestOptions): Promise<TaskPushNotificationConfig>;
    listTaskPushNotificationConfig(params: ListTaskPushNotificationConfigParams, options?: RequestOptions): Promise<TaskPushNotificationConfig[]>;
    deleteTaskPushNotificationConfig(params: DeleteTaskPushNotificationConfigParams, options?: RequestOptions): Promise<void>;
    getTask(params: TaskQueryParams, options?: RequestOptions): Promise<Task>;
    cancelTask(params: TaskIdParams, options?: RequestOptions): Promise<Task>;
    resubscribeTask(params: TaskIdParams, options?: RequestOptions): AsyncGenerator<A2AStreamEventData, void, undefined>;
}
interface TransportFactory {
    get protocolName(): string;
    create(url: string, agentCard: AgentCard): Promise<Transport>;
}

interface ClientConfig {
    /**
     * Whether client prefers to poll for task updates instead of blocking until a terminal state is reached.
     * If set to true, non-streaming send message result might be a Message or a Task in any (including non-terminal) state.
     * Callers are responsible for running the polling loop. This configuration does not apply to streaming requests.
     */
    polling?: boolean;
    /**
     * Specifies the default list of accepted media types to apply for all "send message" calls.
     */
    acceptedOutputModes?: string[];
    /**
     * Specifies the default push notification configuration to apply for every Task.
     */
    pushNotificationConfig?: PushNotificationConfig;
    /**
     * Interceptors invoked for each request.
     */
    interceptors?: CallInterceptor[];
}
interface RequestOptions {
    /**
     * Signal to abort request execution.
     */
    signal?: AbortSignal;
    /**
     * A key-value map for passing horizontally applicable context or parameters.
     * All parameters are passed to the server via underlying transports (e.g. In JsonRPC via Headers).
     */
    serviceParameters?: ServiceParameters;
    /**
     * Arbitrary data available to interceptors and transport implementation.
     */
    context?: ClientCallContext;
}
declare class Client {
    readonly transport: Transport;
    private agentCard;
    readonly config?: ClientConfig;
    constructor(transport: Transport, agentCard: AgentCard, config?: ClientConfig);
    /**
     * If the current agent card supports the extended feature, it will try to fetch the extended agent card from the server,
     * Otherwise it will return the current agent card value.
     */
    getAgentCard(options?: RequestOptions): Promise<AgentCard>;
    /**
     * Sends a message to an agent to initiate a new interaction or to continue an existing one.
     * Uses blocking mode by default.
     */
    sendMessage(params: MessageSendParams, options?: RequestOptions): Promise<SendMessageResult>;
    /**
     * Sends a message to an agent to initiate/continue a task AND subscribes the client to real-time updates for that task.
     * Performs fallback to non-streaming if not supported by the agent.
     */
    sendMessageStream(params: MessageSendParams, options?: RequestOptions): AsyncGenerator<A2AStreamEventData, void, undefined>;
    /**
     * Sets or updates the push notification configuration for a specified task.
     * Requires the server to have AgentCard.capabilities.pushNotifications: true.
     */
    setTaskPushNotificationConfig(params: TaskPushNotificationConfig, options?: RequestOptions): Promise<TaskPushNotificationConfig>;
    /**
     * Retrieves the current push notification configuration for a specified task.
     * Requires the server to have AgentCard.capabilities.pushNotifications: true.
     */
    getTaskPushNotificationConfig(params: TaskIdParams, options?: RequestOptions): Promise<TaskPushNotificationConfig>;
    /**
     * Retrieves the associated push notification configurations for a specified task.
     * Requires the server to have AgentCard.capabilities.pushNotifications: true.
     */
    listTaskPushNotificationConfig(params: ListTaskPushNotificationConfigParams, options?: RequestOptions): Promise<TaskPushNotificationConfig[]>;
    /**
     * Deletes an associated push notification configuration for a task.
     */
    deleteTaskPushNotificationConfig(params: DeleteTaskPushNotificationConfigParams, options?: RequestOptions): Promise<void>;
    /**
     * Retrieves the current state (including status, artifacts, and optionally history) of a previously initiated task.
     */
    getTask(params: TaskQueryParams, options?: RequestOptions): Promise<Task>;
    /**
     * Requests the cancellation of an ongoing task. The server will attempt to cancel the task,
     * but success is not guaranteed (e.g., the task might have already completed or failed, or cancellation might not be supported at its current stage).
     */
    cancelTask(params: TaskIdParams, options?: RequestOptions): Promise<Task>;
    /**
     * Allows a client to reconnect to an updates stream for an ongoing task after a previous connection was interrupted.
     */
    resubscribeTask(params: TaskIdParams, options?: RequestOptions): AsyncGenerator<A2AStreamEventData, void, undefined>;
    private applyClientConfig;
    private executeWithInterceptors;
    private interceptBefore;
    private interceptAfter;
}

type TransportProtocolName = 'JSONRPC' | 'HTTP+JSON' | 'GRPC' | (string & {});

export { type A2AStreamEventData as A, type BeforeArgs as B, type ClientConfig as C, type RequestOptions as R, type SendMessageResult as S, type TransportFactory as T, type TransportProtocolName as a, Client as b, type Transport as c, A2AClient as d, type A2AClientOptions as e, type CallInterceptor as f, type AfterArgs as g, type ClientCallInput as h, type ClientCallResult as i, ServiceParameters as j, type ServiceParametersUpdate as k, ClientCallContext as l, type ContextUpdate as m, ClientCallContextKey as n, withA2AExtensions as w };
