/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { type AnySchema } from 'ajv';
/**
 * Simple utility to validate objects against JSON Schemas
 */
export declare class SchemaValidator {
    /**
     * Returns null if the data conforms to the schema described by schema (or if schema
     *  is null). Otherwise, returns a string describing the error.
     */
    static validate(schema: unknown | undefined, data: unknown): string | null;
    /**
     * Validates a JSON schema itself. Returns null if the schema is valid,
     * otherwise returns a string describing the validation errors.
     */
    static validateSchema(schema: AnySchema | undefined): string | null;
}
