/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.build.event.types.DefaultInternalPayloadSerializedAdditionalData;
import org.gradle.internal.build.event.types.DefaultInternalProxiedAdditionalData;
import org.gradle.internal.build.event.types.DefaultProblemDetails;
import org.gradle.internal.build.event.types.DefaultProblemEvent;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.classloader.ClassLoaderVisitor;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.snapshot.impl.IsolatableSerializerRegistry;
import org.gradle.tooling.internal.protocol.problem.InternalAdditionalData;
import org.gradle.tooling.internal.protocol.problem.InternalProblemDetailsVersion2;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;

public class ProblemAdditionalDataRemapper
implements BuildEventConsumer {
    private final PayloadSerializer payloadSerializer;
    private final BuildEventConsumer delegate;
    private final IsolatableSerializerRegistry isolatableSerializerRegistry;

    public ProblemAdditionalDataRemapper(PayloadSerializer payloadSerializer, BuildEventConsumer delegate, IsolatableSerializerRegistry isolatableSerializerRegistry) {
        this.payloadSerializer = payloadSerializer;
        this.delegate = delegate;
        this.isolatableSerializerRegistry = isolatableSerializerRegistry;
    }

    public void dispatch(Object message) {
        this.remapAdditionalData(message);
        this.delegate.dispatch(message);
    }

    private void remapAdditionalData(Object message) {
        if (!(message instanceof DefaultProblemEvent)) {
            return;
        }
        DefaultProblemEvent problemEvent = (DefaultProblemEvent)message;
        InternalProblemDetailsVersion2 details = problemEvent.getDetails();
        if (!(details instanceof DefaultProblemDetails)) {
            return;
        }
        InternalAdditionalData additionalData = ((DefaultProblemDetails)details).getAdditionalData();
        if (!(additionalData instanceof DefaultInternalPayloadSerializedAdditionalData)) {
            return;
        }
        DefaultInternalPayloadSerializedAdditionalData serializedAdditionalData = (DefaultInternalPayloadSerializedAdditionalData)additionalData;
        SerializedPayload serializedType = (SerializedPayload)serializedAdditionalData.getSerializedType();
        Class type = (Class)this.payloadSerializer.deserialize(serializedType);
        if (type == null) {
            return;
        }
        byte[] isolatableBytes = serializedAdditionalData.getBytesForIsolatadObject();
        List<URL> classPath = ProblemAdditionalDataRemapper.getClassPath(type);
        VisitableURLClassLoader visitableURLClassLoader = new VisitableURLClassLoader("name", this.getClass().getClassLoader(), classPath);
        Object o = ClassLoaderUtils.executeInClassloader((ClassLoader)visitableURLClassLoader, () -> {
            Isolatable isolatable = this.isolatableSerializerRegistry.deserialize(isolatableBytes);
            return isolatable.isolate();
        });
        ((DefaultProblemDetails)details).setAdditionalData((InternalAdditionalData)new DefaultInternalProxiedAdditionalData(o, serializedType));
    }

    @Nonnull
    private static List<URL> getClassPath(Class<?> type) {
        final ArrayList<URL> classPath = new ArrayList<URL>();
        ((VisitableURLClassLoader)type.getClassLoader()).visit(new ClassLoaderVisitor(){

            public void visitClassPath(URL[] urls) {
                Collections.addAll(classPath, urls);
            }
        });
        return classPath;
    }
}

