/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.tasks.testing.report.ClassTestResults;
import org.gradle.api.internal.tasks.testing.report.CompositeTestResults;
import org.gradle.api.internal.tasks.testing.report.PackageTestResults;
import org.gradle.api.internal.tasks.testing.report.TestResult;

public class AllTestResults
extends CompositeTestResults {
    private final Map<String, PackageTestResults> packages = new TreeMap<String, PackageTestResults>();

    public AllTestResults() {
        super(null);
    }

    @Override
    public String getTitle() {
        return "Test Summary";
    }

    @Override
    public String getBaseUrl() {
        return "index.html";
    }

    public Collection<PackageTestResults> getPackages() {
        return this.packages.values();
    }

    public TestResult addTest(long classId, String className, String testName, long duration) {
        return this.addTest(classId, className, className, testName, testName, duration);
    }

    public TestResult addTest(long classId, String className, String classDisplayName, String testName, String testDisplayName, long duration) {
        PackageTestResults packageResults = this.addPackageForClass(className);
        return this.addTest(packageResults.addTest(classId, className, classDisplayName, testName, testDisplayName, duration));
    }

    public ClassTestResults addTestClass(long classId, String className) {
        return this.addTestClass(classId, className, className);
    }

    public ClassTestResults addTestClass(long classId, String className, String classDisplayName) {
        return this.addPackageForClass(className).addClass(classId, className, classDisplayName);
    }

    private PackageTestResults addPackageForClass(String className) {
        String packageName = StringUtils.substringBeforeLast((String)className, (String)".");
        if (packageName.equals(className)) {
            packageName = "";
        }
        return this.addPackage(packageName);
    }

    private PackageTestResults addPackage(String packageName) {
        PackageTestResults packageResults = this.packages.get(packageName);
        if (packageResults == null) {
            packageResults = new PackageTestResults(packageName, this);
            this.packages.put(packageName, packageResults);
        }
        return packageResults;
    }
}

