/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.analyzers;

import java.lang.module.FindException;
import java.lang.module.InvalidModuleDescriptorException;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.nio.file.Path;
import java.util.Optional;
import org.kordamp.jarviz.core.JarvizException;
import org.kordamp.jarviz.core.analyzers.JarPathAnalyzer;
import org.kordamp.jarviz.core.model.ModuleName;
import org.kordamp.jarviz.util.StringUtils;

public class ModuleNameJarPathAnalyzer
implements JarPathAnalyzer<ModuleName> {
    private final String automaticModuleNameByManifest;
    private final String automaticModuleNameByFilename;
    private ModuleName moduleName;

    public ModuleNameJarPathAnalyzer(String automaticModuleNameByManifest, String automaticModuleNameByFilename) {
        this.automaticModuleNameByManifest = automaticModuleNameByManifest;
        this.automaticModuleNameByFilename = automaticModuleNameByFilename;
    }

    @Override
    public ModuleName getResult() {
        return this.moduleName;
    }

    @Override
    public void handle(Path path) throws JarvizException {
        if (StringUtils.isNotBlank(this.automaticModuleNameByManifest)) {
            this.moduleName = ModuleName.fromAutomaticByManifest(this.automaticModuleNameByManifest, this.isAutomaticNameValid(this.automaticModuleNameByManifest).orElse(null));
        }
        try {
            this.moduleName = ModuleFinder.of(path).findAll().stream().map(ModuleReference::descriptor).map(this::toModuleName).findFirst().get();
        }
        catch (FindException fe) {
            Throwable cause = this.getRootCause(fe);
            if (cause instanceof InvalidModuleDescriptorException) {
                this.moduleName = ModuleName.fromModuleDescriptor("", cause.getMessage());
                return;
            }
            if (null == this.moduleName) {
                this.moduleName = ModuleName.fromAutomaticByFilename(this.automaticModuleNameByFilename, cause.getMessage());
            }
        }
        catch (InvalidModuleDescriptorException imde) {
            this.moduleName = ModuleName.fromModuleDescriptor("", imde.getMessage());
        }
    }

    private ModuleName toModuleName(ModuleDescriptor moduleDescriptor) {
        return ModuleName.fromModuleDescriptor(moduleDescriptor.name(), moduleDescriptor.isAutomatic() && StringUtils.isNotBlank(this.automaticModuleNameByManifest), moduleDescriptor.isAutomatic() && StringUtils.isBlank(this.automaticModuleNameByManifest) && StringUtils.isNotBlank(this.automaticModuleNameByFilename), this.isValid(moduleDescriptor.name()).orElse(null));
    }

    private Optional<String> isAutomaticNameValid(String name) {
        try {
            ModuleDescriptor.newAutomaticModule(name);
            return Optional.empty();
        }
        catch (IllegalArgumentException exception) {
            return Optional.of(exception.getMessage());
        }
    }

    private Optional<String> isValid(String name) {
        try {
            ModuleDescriptor.newModule(name);
            return Optional.empty();
        }
        catch (IllegalArgumentException exception) {
            return Optional.of(exception.getMessage());
        }
    }

    private Throwable getRootCause(Throwable throwable) {
        while (null != throwable.getCause()) {
            throwable = throwable.getCause();
        }
        return throwable;
    }
}

