/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.model;

import java.util.Objects;
import org.kordamp.jarviz.util.Algorithm;

public class Checksum
implements Comparable<Checksum> {
    private final Algorithm algorithm;
    private final Outcome outcome;

    public static Checksum success(Algorithm algorithm) {
        return new Checksum(algorithm, Outcome.SUCCESS);
    }

    public static Checksum failure(Algorithm algorithm) {
        return new Checksum(algorithm, Outcome.FAILURE);
    }

    public static Checksum unavailable(Algorithm algorithm) {
        return new Checksum(algorithm, Outcome.UNAVAILABLE);
    }

    private Checksum(Algorithm algorithm, Outcome outcome) {
        this.algorithm = algorithm;
        this.outcome = outcome;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public Outcome getOutcome() {
        return this.outcome;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Checksum checksum = (Checksum)o;
        return this.algorithm == checksum.algorithm;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.algorithm});
    }

    @Override
    public int compareTo(Checksum o) {
        if (null == o) {
            return -1;
        }
        return this.algorithm.compareTo(o.algorithm);
    }

    public static enum Outcome {
        SUCCESS,
        FAILURE,
        UNAVAILABLE;

    }
}

