/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.api.packagers;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.api.common.Activatable;
import org.jreleaser.model.api.common.Domain;
import org.jreleaser.model.api.common.ExtraProperties;
import org.jreleaser.util.StringUtils;

public interface DockerConfiguration
extends Domain,
ExtraProperties,
Activatable {
    public static final String TYPE = "docker";

    public String getTemplateDirectory();

    public List<String> getSkipTemplates();

    public String getBaseImage();

    public String getEntrypoint();

    public String getCmd();

    public Map<String, String> getLabels();

    public Set<String> getImageNames();

    public List<String> getBuildArgs();

    public List<String> getPreCommands();

    public List<String> getPostCommands();

    public Set<? extends Registry> getRegistries();

    public boolean isUseLocalArtifact();

    public DockerCommand getCommand();

    public Buildx getBuildx();

    public static interface Buildx
    extends Domain {
        public boolean isEnabled();

        public boolean isCreateBuilder();

        public List<String> getCreateBuilderFlags();

        public List<String> getPlatforms();
    }

    public static interface Registry
    extends Domain,
    Activatable,
    Comparable<Registry> {
        public String getServer();

        public String getServerName();

        public String getRepositoryName();

        public String getUsername();

        public String getPassword();

        public boolean isExternalLogin();
    }

    public static enum DockerCommand {
        DOCKER,
        PODMAN;


        public static DockerCommand of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            return DockerCommand.valueOf(str.toUpperCase(Locale.ENGLISH).trim());
        }

        public String formatted() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

