/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.announce;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.Active;
import org.jreleaser.model.Mail;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.AbstractMessageAnnouncer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.StringUtils;

public final class SmtpAnnouncer
extends AbstractMessageAnnouncer<SmtpAnnouncer, org.jreleaser.model.api.announce.SmtpAnnouncer> {
    private static final long serialVersionUID = 8158533914621631647L;
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private Mail.Transport transport;
    private String host;
    private Integer port;
    private Boolean auth;
    private String username;
    private String password;
    private String from;
    private String to;
    private String cc;
    private String bcc;
    private String subject;
    private Mail.MimeType mimeType;
    @JsonIgnore
    private final org.jreleaser.model.api.announce.SmtpAnnouncer immutable = new org.jreleaser.model.api.announce.SmtpAnnouncer(){
        private static final long serialVersionUID = -7617403297991452674L;

        public String getType() {
            return "smtp";
        }

        public Mail.Transport getTransport() {
            return SmtpAnnouncer.this.transport;
        }

        public String getHost() {
            return SmtpAnnouncer.this.host;
        }

        public Integer getPort() {
            return SmtpAnnouncer.this.port;
        }

        public boolean isAuth() {
            return SmtpAnnouncer.this.isAuth();
        }

        public String getUsername() {
            return SmtpAnnouncer.this.username;
        }

        public String getPassword() {
            return SmtpAnnouncer.this.password;
        }

        public String getFrom() {
            return SmtpAnnouncer.this.from;
        }

        public String getTo() {
            return SmtpAnnouncer.this.to;
        }

        public String getCc() {
            return SmtpAnnouncer.this.cc;
        }

        public String getBcc() {
            return SmtpAnnouncer.this.bcc;
        }

        public String getSubject() {
            return SmtpAnnouncer.this.subject;
        }

        public String getMessage() {
            return SmtpAnnouncer.this.getMessage();
        }

        public String getMessageTemplate() {
            return SmtpAnnouncer.this.getMessageTemplate();
        }

        public Mail.MimeType getMimeType() {
            return SmtpAnnouncer.this.mimeType;
        }

        public Map<String, String> getProperties() {
            return Collections.unmodifiableMap(SmtpAnnouncer.this.properties);
        }

        public String getName() {
            return SmtpAnnouncer.this.getName();
        }

        public boolean isSnapshotSupported() {
            return SmtpAnnouncer.this.isSnapshotSupported();
        }

        public Active getActive() {
            return SmtpAnnouncer.this.getActive();
        }

        public boolean isEnabled() {
            return SmtpAnnouncer.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(SmtpAnnouncer.this.asMap(full));
        }

        public String getPrefix() {
            return SmtpAnnouncer.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(SmtpAnnouncer.this.getExtraProperties());
        }

        public Integer getConnectTimeout() {
            return SmtpAnnouncer.this.getConnectTimeout();
        }

        public Integer getReadTimeout() {
            return SmtpAnnouncer.this.getReadTimeout();
        }
    };

    public SmtpAnnouncer() {
        super("smtp");
    }

    @Override
    public org.jreleaser.model.api.announce.SmtpAnnouncer asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(SmtpAnnouncer source) {
        super.merge(source);
        this.transport = this.merge(this.transport, source.transport);
        this.host = this.merge(this.host, source.host);
        this.port = this.merge(this.port, source.port);
        this.auth = this.merge(this.auth, source.auth);
        this.username = this.merge(this.username, source.username);
        this.password = this.merge(this.password, source.password);
        this.from = this.merge(this.from, source.from);
        this.to = this.merge(this.to, source.to);
        this.cc = this.merge(this.cc, source.cc);
        this.bcc = this.merge(this.bcc, source.bcc);
        this.subject = this.merge(this.subject, source.subject);
        this.mimeType = this.merge(this.mimeType, source.mimeType);
        this.setProperties(this.merge(this.properties, source.properties));
    }

    public String getResolvedSubject(JReleaserContext context) {
        TemplateContext props = context.fullProps();
        MustacheUtils.applyTemplates((JReleaserLogger)context.getLogger(), (TemplateContext)props, this.resolvedExtraProperties());
        props.set("tagName", (Object)context.getModel().getRelease().getReleaser().getEffectiveTagName(context));
        props.set("previousTagName", (Object)context.getModel().getRelease().getReleaser().getResolvedPreviousTagName(context));
        return Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)this.subject, (TemplateContext)props);
    }

    public Mail.Transport getTransport() {
        return this.transport;
    }

    public void setTransport(String transport) {
        this.transport = Mail.Transport.valueOf((String)transport.replace(" ", "_").replace("-", "_").toUpperCase(Locale.ENGLISH));
    }

    public void setTransport(Mail.Transport transport) {
        this.transport = transport;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public boolean isAuth() {
        return null != this.auth && this.auth != false;
    }

    public void setAuth(Boolean auth) {
        this.auth = auth;
    }

    public boolean isAuthSet() {
        return null != this.auth;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getCc() {
        return this.cc;
    }

    public void setCc(String cc) {
        this.cc = cc;
    }

    public String getBcc() {
        return this.bcc;
    }

    public void setBcc(String bcc) {
        this.bcc = bcc;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Mail.MimeType getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = Mail.MimeType.valueOf((String)mimeType.replace(" ", "_").replace("-", "_").toUpperCase(Locale.ENGLISH));
    }

    public void setMimeType(Mail.MimeType mimeType) {
        this.mimeType = mimeType;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties.putAll(properties);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("transport", this.transport);
        props.put("host", this.host);
        props.put("port", this.port);
        props.put("auth", this.isAuth());
        props.put("username", this.username);
        props.put("password", StringUtils.isNotBlank((String)this.password) ? "************" : "**unset**");
        props.put("from", this.from);
        props.put("to", this.to);
        props.put("cc", this.cc);
        props.put("bcc", this.bcc);
        props.put("subject", this.subject);
        super.asMap(full, props);
        props.put("mimeType", this.mimeType);
        props.put("properties", this.properties);
    }
}

