/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.signing;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.JReleaserOutput;
import org.jreleaser.model.Signing;
import org.jreleaser.model.api.signing.Signing;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.signing.SigningTool;
import org.jreleaser.util.StringUtils;

public final class Signing
extends AbstractActivatable<Signing>
implements Domain {
    private static final long serialVersionUID = -2921377312639467517L;
    private final Pgp pgp = new Pgp();
    private final Cosign cosign = new Cosign();
    private final Minisign minisign = new Minisign();
    @JsonIgnore
    private final org.jreleaser.model.api.signing.Signing immutable = new org.jreleaser.model.api.signing.Signing(){
        private static final long serialVersionUID = 7518353475296750193L;

        public boolean isArmored() {
            return Signing.this.isArmored();
        }

        public boolean isVerify() {
            return Signing.this.pgp.isVerify();
        }

        public String getPublicKey() {
            return Signing.this.pgp.getPublicKey();
        }

        public String getSecretKey() {
            return Signing.this.pgp.getSecretKey();
        }

        public String getPassphrase() {
            return Signing.this.pgp.getPassphrase();
        }

        public Signing.Mode getMode() {
            return Signing.this.pgp.getMode();
        }

        public boolean isArtifacts() {
            return Signing.this.pgp.isArtifacts();
        }

        public boolean isFiles() {
            return Signing.this.pgp.isFiles();
        }

        public boolean isChecksums() {
            return Signing.this.pgp.isChecksums();
        }

        public boolean isCatalogs() {
            return Signing.this.pgp.isCatalogs();
        }

        public Signing.Command getCommand() {
            return Signing.this.pgp.command.asImmutable();
        }

        public Signing.Pgp getPgp() {
            return Signing.this.pgp.asImmutable();
        }

        public Signing.Cosign getCosign() {
            return Signing.this.cosign.asImmutable();
        }

        public Signing.Minisign getMinisign() {
            return Signing.this.minisign.asImmutable();
        }

        public Active getActive() {
            return Signing.this.getActive();
        }

        public boolean isEnabled() {
            return Signing.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Signing.this.asMap(full);
        }
    };

    public org.jreleaser.model.api.signing.Signing asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Signing source) {
        super.merge(source);
        this.setPgp(source.pgp);
        this.setCosign(source.cosign);
        this.setMinisign(source.minisign);
    }

    public boolean isArmored() {
        return this.pgp.isArmored();
    }

    @Deprecated
    public void setArmored(Boolean armored) {
        JReleaserOutput.nag((String)"signing.armored is deprecated since 1.22.0 and will be removed in 2.0.0. Use signing.pgp.armored instead");
        this.pgp.setArmored(armored);
    }

    public boolean isArmoredSet() {
        return this.pgp.isArmoredSet();
    }

    public boolean isVerify() {
        return this.pgp.isVerify();
    }

    @Deprecated
    public void setVerify(Boolean verify) {
        JReleaserOutput.nag((String)"signing.verify is deprecated since 1.22.0 and will be removed in 2.0.0. Use signing.pgp.verify instead");
        this.pgp.setVerify(verify);
    }

    public boolean isVerifySet() {
        return this.pgp.isVerifySet();
    }

    public String getPublicKey() {
        return this.pgp.getPublicKey();
    }

    @Deprecated
    public void setPublicKey(String publicKey) {
        JReleaserOutput.nag((String)"signing.publicKey is deprecated since 1.22.0 and will be removed in 2.0.0. Use signing.pgp.publicKey instead");
        this.pgp.setPublicKey(publicKey);
    }

    public String getSecretKey() {
        return this.pgp.getSecretKey();
    }

    @Deprecated
    public void setSecretKey(String secretKey) {
        JReleaserOutput.nag((String)"signing.secretKey is deprecated since 1.22.0 and will be removed in 2.0.0. Use signing.pgp.secretKey instead");
        this.pgp.setSecretKey(secretKey);
    }

    public String getPassphrase() {
        return this.pgp.getPassphrase();
    }

    @Deprecated
    public void setPassphrase(String passphrase) {
        JReleaserOutput.nag((String)"signing.passphrase is deprecated since 1.22.0 and will be removed in 2.0.0. Use signing.pgp.passphrase instead");
        this.pgp.setPassphrase(passphrase);
    }

    public Signing.Mode getMode() {
        return this.pgp.getMode();
    }

    @Deprecated
    public void setMode(Signing.Mode mode) {
        JReleaserOutput.nag((String)"signing.mode is deprecated since 1.22.0 and will be removed in 2.0.0. Use signing.pgp.mode instead");
        this.pgp.setMode(mode);
    }

    @Deprecated
    public void setMode(String str) {
        this.setMode(Signing.Mode.of((String)str));
    }

    public boolean isArtifactsSet() {
        return this.pgp.isArtifactsSet();
    }

    public boolean isArtifacts() {
        return this.pgp.isArtifacts();
    }

    @Deprecated
    public void setArtifacts(Boolean artifacts) {
        JReleaserOutput.nag((String)"signing.artifacts is deprecated since 1.22.0 and will be removed in 2.0.0. Use signing.pgp.artifacts instead");
        this.pgp.setArtifacts(artifacts);
    }

    public boolean isFiles() {
        return this.pgp.isFiles();
    }

    @Deprecated
    public void setFiles(Boolean files) {
        JReleaserOutput.nag((String)"signing.files is deprecated since 1.22.0 and will be removed in 2.0.0. Use signing.pgp.files instead");
        this.pgp.setFiles(files);
    }

    public boolean isFilesSet() {
        return this.pgp.isFilesSet();
    }

    public boolean isChecksumsSet() {
        return this.pgp.isChecksums();
    }

    public boolean isChecksums() {
        return this.pgp.isChecksums();
    }

    @Deprecated
    public void setChecksums(Boolean checksums) {
        JReleaserOutput.nag((String)"signing.checksums is deprecated since 1.22.0 and will be removed in 2.0.0. Use signing.pgp.checksums instead");
        this.pgp.setChecksums(checksums);
    }

    public boolean isCatalogsSet() {
        return this.pgp.isEnabled();
    }

    public boolean isCatalogs() {
        return this.pgp.isCatalogs();
    }

    @Deprecated
    public void setCatalogs(Boolean catalogs) {
        JReleaserOutput.nag((String)"signing.catalogs is deprecated since 1.22.0 and will be removed in 2.0.0. Use signing.pgp.catalogs instead");
        this.pgp.setCatalogs(catalogs);
    }

    public Command getCommand() {
        return this.pgp.getCommand();
    }

    @Deprecated
    public void setCommand(Command command) {
        JReleaserOutput.nag((String)"signing.command is deprecated since 1.22.0 and will be removed in 2.0.0. Use signing.pgp.command instead");
        this.pgp.setCommand(command);
    }

    public Pgp getPgp() {
        return this.pgp;
    }

    public void setPgp(Pgp pgp) {
        this.pgp.merge(pgp);
    }

    public Cosign getCosign() {
        return this.cosign;
    }

    public void setCosign(Cosign cosign) {
        this.cosign.merge(cosign);
    }

    public Minisign getMinisign() {
        return this.minisign;
    }

    public void setMinisign(Minisign minisign) {
        this.minisign.merge(minisign);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.pgp.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("active", this.getActive());
        props.put("pgp", this.pgp.asMap(full));
        props.put("cosign", this.cosign.asMap(full));
        props.put("minisign", this.minisign.asMap(full));
        return props;
    }

    public static class Minisign
    extends AbstractSigningTool<Minisign>
    implements Domain {
        private static final long serialVersionUID = -6158083413967906887L;
        private String version;
        private String secretKeyFile;
        private String publicKeyFile;
        @JsonIgnore
        private final Signing.Minisign immutable = new Signing.Minisign(){
            private static final long serialVersionUID = 5488348796140511090L;

            public String getVersion() {
                return version;
            }

            public String getSecretKeyFile() {
                return secretKeyFile;
            }

            public String getPublicKeyFile() {
                return publicKeyFile;
            }

            public String getPassphrase() {
                return passphrase;
            }

            public boolean isVerify() {
                return this.isVerify();
            }

            public boolean isArtifacts() {
                return this.isArtifacts();
            }

            public boolean isFiles() {
                return this.isFiles();
            }

            public boolean isChecksums() {
                return this.isChecksums();
            }

            public boolean isCatalogs() {
                return this.isCatalogs();
            }

            public Active getActive() {
                return this.getActive();
            }

            public boolean isEnabled() {
                return this.isEnabled();
            }

            public Map<String, Object> asMap(boolean full) {
                return this.asMap(full);
            }
        };

        public Signing.Minisign asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Minisign source) {
            super.merge(source);
            this.version = this.merge(this.version, source.version);
            this.secretKeyFile = this.merge(this.secretKeyFile, source.secretKeyFile);
            this.publicKeyFile = this.merge(this.publicKeyFile, source.publicKeyFile);
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        @Deprecated
        public String getPrivate() {
            return this.getSecretKeyFile();
        }

        public void setPrivateKeyFile(String secretKeyFile) {
            JReleaserOutput.nag((String)"cosign.privateKeyFile is deprecated since 1.22.0 and will be removed in 2.0.0. Use cosign.secretKeyFile instead");
            this.setSecretKeyFile(secretKeyFile);
        }

        public String getSecretKeyFile() {
            return this.secretKeyFile;
        }

        public void setSecretKeyFile(String secretKeyFile) {
            this.secretKeyFile = secretKeyFile;
        }

        public String getPublicKeyFile() {
            return this.publicKeyFile;
        }

        public void setPublicKeyFile(String publicKeyFile) {
            this.publicKeyFile = publicKeyFile;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            if (!full && !this.isEnabled()) {
                return Collections.emptyMap();
            }
            Map<String, Object> props = super.asMap(full);
            props.put("version", this.version);
            props.put("secretKeyFile", null != this.secretKeyFile ? "************" : "**unset**");
            props.put("publicKeyFile", this.publicKeyFile);
            props.put("passphrase", StringUtils.isNotBlank((String)this.passphrase) ? "************" : "**unset**");
            return props;
        }

        public Path getResolvedSecretKeyFilePath(JReleaserContext context) {
            String secretKey = this.getSecretKeyFile();
            if (StringUtils.isNotBlank((String)secretKey)) {
                return context.getBasedir().resolve(secretKey);
            }
            return this.resolveMinisigHomeDir().resolve("minisign.key");
        }

        public Path getResolvedPublicKeyFilePath(JReleaserContext context) {
            String publicKey = this.getPublicKeyFile();
            if (StringUtils.isNotBlank((String)publicKey)) {
                return context.getBasedir().resolve(publicKey);
            }
            return context.getBasedir().resolve("minisign.pub");
        }

        private Path resolveMinisigHomeDir() {
            return Paths.get(System.getProperty("user.home") + File.separator + ".minisign", new String[0]);
        }

        @Override
        public String getSignatureExtension() {
            return ".minisig";
        }
    }

    public static class Cosign
    extends AbstractSigningTool<Cosign>
    implements Domain {
        private static final long serialVersionUID = 3142049026548421252L;
        private String version;
        private String secretKeyFile;
        private String publicKeyFile;
        @JsonIgnore
        private final Signing.Cosign immutable = new Signing.Cosign(){
            private static final long serialVersionUID = 7075702207538130646L;

            public String getVersion() {
                return version;
            }

            public String getPrivateKeyFile() {
                return this.getSecretKeyFile();
            }

            public String getSecretKeyFile() {
                return secretKeyFile;
            }

            public String getPublicKeyFile() {
                return publicKeyFile;
            }

            public String getPassphrase() {
                return passphrase;
            }

            public boolean isVerify() {
                return this.isVerify();
            }

            public boolean isArtifacts() {
                return this.isArtifacts();
            }

            public boolean isFiles() {
                return this.isFiles();
            }

            public boolean isChecksums() {
                return this.isChecksums();
            }

            public boolean isCatalogs() {
                return this.isCatalogs();
            }

            public Active getActive() {
                return this.getActive();
            }

            public boolean isEnabled() {
                return this.isEnabled();
            }

            public Map<String, Object> asMap(boolean full) {
                return this.asMap(full);
            }
        };

        public Signing.Cosign asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Cosign source) {
            super.merge(source);
            this.version = this.merge(this.version, source.version);
            this.secretKeyFile = this.merge(this.secretKeyFile, source.secretKeyFile);
            this.publicKeyFile = this.merge(this.publicKeyFile, source.publicKeyFile);
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getSecretKeyFile() {
            return this.secretKeyFile;
        }

        public void setSecretKeyFile(String secretKeyFile) {
            this.secretKeyFile = secretKeyFile;
        }

        public String getPublicKeyFile() {
            return this.publicKeyFile;
        }

        public void setPublicKeyFile(String publicKeyFile) {
            this.publicKeyFile = publicKeyFile;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            if (!full && !this.isEnabled()) {
                return Collections.emptyMap();
            }
            Map<String, Object> props = super.asMap(full);
            props.put("version", this.version);
            props.put("secretKeyFile", null != this.secretKeyFile ? "************" : "**unset**");
            props.put("publicKeyFile", this.publicKeyFile);
            props.put("passphrase", StringUtils.isNotBlank((String)this.passphrase) ? "************" : "**unset**");
            return props;
        }

        public Path getResolvedSecretKeyFilePath(JReleaserContext context) {
            String secretKey = this.getSecretKeyFile();
            if (StringUtils.isNotBlank((String)secretKey)) {
                return context.getBasedir().resolve(secretKey);
            }
            return this.resolveJReleaserHomeDir().resolve("cosign.key");
        }

        public Path getResolvedPublicKeyFilePath(JReleaserContext context) {
            String publicKey = this.getPublicKeyFile();
            if (StringUtils.isNotBlank((String)publicKey)) {
                return context.getBasedir().resolve(publicKey);
            }
            return this.resolveJReleaserHomeDir().resolve("cosign.pub");
        }

        private Path resolveJReleaserHomeDir() {
            String home = System.getenv("JRELEASER_USER_HOME");
            if (StringUtils.isBlank((String)home)) {
                home = System.getProperty("user.home") + File.separator + ".jreleaser";
            }
            return Paths.get(home, new String[0]);
        }

        @Override
        public String getSignatureExtension() {
            return ".cosign";
        }
    }

    public static class Pgp
    extends AbstractSigningTool<Pgp>
    implements Domain {
        private static final long serialVersionUID = -5762843351226833958L;
        private final Command command = new Command();
        private Boolean armored;
        private Signing.Mode mode;
        @JsonIgnore
        private final Signing.Pgp immutable = new Signing.Pgp(){
            private static final long serialVersionUID = -7221508841211382727L;

            public boolean isArmored() {
                return this.isArmored();
            }

            public String getPublicKey() {
                return publicKey;
            }

            public String getSecretKey() {
                return secretKey;
            }

            public Signing.Mode getMode() {
                return mode;
            }

            public Signing.Command getCommand() {
                return command.asImmutable();
            }

            public Active getActive() {
                return this.getActive();
            }

            public boolean isEnabled() {
                return this.isEnabled();
            }

            public String getPassphrase() {
                return passphrase;
            }

            public boolean isVerify() {
                return this.isVerify();
            }

            public boolean isArtifacts() {
                return this.isArtifacts();
            }

            public boolean isFiles() {
                return this.isFiles();
            }

            public boolean isChecksums() {
                return this.isChecksums();
            }

            public boolean isCatalogs() {
                return this.isCatalogs();
            }

            public Map<String, Object> asMap(boolean full) {
                return this.asMap(full);
            }
        };

        public Signing.Pgp asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Pgp source) {
            super.merge(source);
            this.armored = this.merge(this.armored, source.armored);
            this.mode = this.merge(this.mode, source.mode);
            this.setCommand(source.command);
        }

        public Signing.Mode resolveMode() {
            if (null == this.mode) {
                this.mode = Signing.Mode.MEMORY;
            }
            return this.mode;
        }

        public boolean isArmored() {
            return null != this.armored && this.armored != false;
        }

        public void setArmored(Boolean armored) {
            this.armored = armored;
        }

        public boolean isArmoredSet() {
            return null != this.armored;
        }

        public Signing.Mode getMode() {
            return this.mode;
        }

        public void setMode(Signing.Mode mode) {
            this.mode = mode;
        }

        public void setMode(String str) {
            this.setMode(Signing.Mode.of((String)str));
        }

        public Command getCommand() {
            return this.command;
        }

        public void setCommand(Command command) {
            this.command.merge(command);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            if (!full && !this.isEnabled()) {
                return Collections.emptyMap();
            }
            Map<String, Object> props = super.asMap(full);
            props.put("armored", this.isArmored());
            props.put("mode", this.mode);
            if (this.mode == Signing.Mode.COMMAND) {
                props.put("command", this.command.asMap(full));
            } else {
                props.put("publicKey", StringUtils.isNotBlank((String)this.publicKey) ? "************" : "**unset**");
                props.put("secretKey", StringUtils.isNotBlank((String)this.secretKey) ? "************" : "**unset**");
            }
            return props;
        }

        @Override
        public String getSignatureExtension() {
            return this.isArmored() ? ".asc" : ".sig";
        }
    }

    public static class Command
    extends AbstractModelObject<Command>
    implements Domain {
        private static final long serialVersionUID = -6208172775388448492L;
        private final List<String> args = new ArrayList<String>();
        private String executable;
        private String keyName;
        private String homeDir;
        private String publicKeyring;
        private Boolean defaultKeyring;
        @JsonIgnore
        private final Signing.Command immutable = new Signing.Command(){
            private static final long serialVersionUID = -8636071040086599491L;

            public String getExecutable() {
                return executable;
            }

            public String getKeyName() {
                return keyName;
            }

            public String getHomeDir() {
                return homeDir;
            }

            public String getPublicKeyring() {
                return publicKeyring;
            }

            public boolean isDefaultKeyring() {
                return this.isDefaultKeyring();
            }

            public List<String> getArgs() {
                return Collections.unmodifiableList(args);
            }

            public Map<String, Object> asMap(boolean full) {
                return this.asMap(full);
            }
        };

        public Signing.Command asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Command source) {
            this.executable = this.merge(this.executable, source.executable);
            this.keyName = this.merge(this.keyName, source.keyName);
            this.homeDir = this.merge(this.homeDir, source.homeDir);
            this.publicKeyring = this.merge(this.publicKeyring, source.publicKeyring);
            this.defaultKeyring = this.merge(this.defaultKeyring, source.defaultKeyring);
            this.setArgs(this.merge(this.args, source.args));
        }

        public String getExecutable() {
            return this.executable;
        }

        public void setExecutable(String executable) {
            this.executable = executable;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public String getHomeDir() {
            return this.homeDir;
        }

        public void setHomeDir(String homeDir) {
            this.homeDir = homeDir;
        }

        public String getPublicKeyring() {
            return this.publicKeyring;
        }

        public void setPublicKeyring(String publicKeyring) {
            this.publicKeyring = publicKeyring;
        }

        public boolean isDefaultKeyringSet() {
            return null != this.defaultKeyring;
        }

        public boolean isDefaultKeyring() {
            return null == this.defaultKeyring || this.defaultKeyring != false;
        }

        public void setDefaultKeyring(Boolean defaultKeyring) {
            this.defaultKeyring = defaultKeyring;
        }

        public List<String> getArgs() {
            return this.args;
        }

        public void setArgs(List<String> args) {
            this.args.clear();
            this.args.addAll(args);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("executable", this.executable);
            props.put("keyName", this.keyName);
            props.put("homeDir", this.homeDir);
            props.put("publicKeyring", this.publicKeyring);
            props.put("defaultKeyring", this.isDefaultKeyring());
            props.put("args", this.args);
            return props;
        }
    }

    private static abstract class AbstractSigningTool<S extends AbstractSigningTool<S>>
    extends AbstractActivatable<S>
    implements SigningTool {
        private static final long serialVersionUID = -1852513790818848365L;
        protected String publicKey;
        protected String secretKey;
        protected String passphrase;
        protected Boolean verify;
        protected Boolean artifacts;
        protected Boolean files;
        protected Boolean checksums;
        protected Boolean catalogs;

        private AbstractSigningTool() {
        }

        @Override
        public void merge(S source) {
            super.merge(source);
            this.publicKey = this.merge(this.publicKey, ((AbstractSigningTool)source).publicKey);
            this.secretKey = this.merge(this.secretKey, ((AbstractSigningTool)source).secretKey);
            this.passphrase = this.merge(this.passphrase, ((AbstractSigningTool)source).passphrase);
            this.verify = this.merge(this.verify, ((AbstractSigningTool)source).verify);
            this.artifacts = this.merge(this.artifacts, ((AbstractSigningTool)source).artifacts);
            this.files = this.merge(this.files, ((AbstractSigningTool)source).files);
            this.checksums = this.merge(this.checksums, ((AbstractSigningTool)source).checksums);
            this.catalogs = this.merge(this.catalogs, ((AbstractSigningTool)source).catalogs);
        }

        @Override
        public String getPublicKey() {
            return this.publicKey;
        }

        @Override
        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        @Override
        public String getSecretKey() {
            return this.secretKey;
        }

        @Override
        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        @Override
        public String getPassphrase() {
            return this.passphrase;
        }

        @Override
        public void setPassphrase(String passphrase) {
            this.passphrase = passphrase;
        }

        @Override
        public boolean isVerify() {
            return null == this.verify || this.verify != false;
        }

        @Override
        public void setVerify(Boolean verify) {
            this.verify = verify;
        }

        public boolean isVerifySet() {
            return null != this.verify;
        }

        public boolean isArtifactsSet() {
            return null != this.artifacts;
        }

        @Override
        public boolean isArtifacts() {
            return null == this.artifacts || this.artifacts != false;
        }

        @Override
        public void setArtifacts(Boolean artifacts) {
            this.artifacts = artifacts;
        }

        @Override
        public boolean isFiles() {
            return null == this.files || this.files != false;
        }

        @Override
        public void setFiles(Boolean files) {
            this.files = files;
        }

        public boolean isFilesSet() {
            return null != this.files;
        }

        public boolean isChecksumsSet() {
            return null != this.checksums;
        }

        @Override
        public boolean isChecksums() {
            return null == this.checksums || this.checksums != false;
        }

        @Override
        public void setChecksums(Boolean checksums) {
            this.checksums = checksums;
        }

        public boolean isCatalogsSet() {
            return null != this.catalogs;
        }

        @Override
        public boolean isCatalogs() {
            return null == this.catalogs || this.catalogs != false;
        }

        @Override
        public void setCatalogs(Boolean catalogs) {
            this.catalogs = catalogs;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            if (!full && !this.isEnabled()) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("enabled", this.isEnabled());
            props.put("active", this.getActive());
            props.put("verify", this.isVerify());
            props.put("artifacts", this.isArtifacts());
            props.put("files", this.isFiles());
            props.put("checksums", this.isChecksums());
            props.put("catalogs", this.isCatalogs());
            return props;
        }
    }
}

