// Jubatus: Online machine learning framework for distributed environment
// Copyright (C) 2011 Preferred Networks and Nippon Telegraph and Telephone Corporation.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License version 2.1 as published by the Free Software Foundation.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef JUBATUS_CORE_FRAMEWORK_DIFFV_HPP_
#define JUBATUS_CORE_FRAMEWORK_DIFFV_HPP_

#include "../storage/storage_type.hpp"

namespace jubatus {
namespace core {
namespace framework {

struct diffv {
 public:
  diffv(int c, const storage::diff_t& w)
      : count(c),
        v(w) {
  }

  diffv()
      : count(0),
        v() {
  }

  int count;
  storage::diff_t v;

  diffv& operator/=(double d) {
    this->v.diff /= d;
    return *this;
  }

  MSGPACK_DEFINE(count, v);
};

}  // namespace frameowrk
}  // namespace core
}  // namespace jubatus

#endif  // JUBATUS_CORE_FRAMEWORK_DIFFV_HPP_
