# Security Policy

## Supported Versions

We are committed to providing security updates for the following versions of killport:

| Version | Supported          |
| ------- | ------------------ |
| 0.9.x   | :white_check_mark: |
| < 0.9.0 | :x:                |

Older versions of killport may still work but are not actively maintained or supported. We encourage users to upgrade to the latest version to receive security updates and feature improvements.

## Reporting a Vulnerability

We take security seriously and value the input of security researchers and our user community. If you believe you've found a security vulnerability in killport, we encourage you to report it to us.

Please follow these steps to report a vulnerability:

1. Go to the [GitHub Security tab](https://github.com/jkfran/killport/security/advisories) in the killport repository.
2. Click on "New draft advisory."
3. Provide a descriptive title for the advisory, such as "Security Vulnerability in killport v0.9.0."
4. Provide a detailed description of the vulnerability, including steps to reproduce the issue, affected components, and potential impact.
5. If you have a suggested patch or workaround, please include it in the report. However, this is not required.
6. Submit the draft advisory.

We will acknowledge receipt of your report within 48 hours and keep you updated on our progress in resolving the issue through the advisory discussion.

We kindly ask you to:

- Not disclose the vulnerability publicly until we have had a chance to address it.
- Not use the vulnerability for malicious purposes or to exploit other users.

We appreciate your help in making killport a more secure and reliable project. In recognition of your contribution, we will credit you in our security advisory and release notes once the issue has been resolved.

Thank you for your support and dedication to the security of the killport project.

