/*
 * Copyright (c) 2024 Frederick H. G. Wright II <fw@fwright.net>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * A complication here is that some recent compilers treat preprocessor
 * undefined warnings as errors, and 10.15+ SDKs reference the possibly
 * undefined TARGET_OS_* macros.  To get around that, we temporarily
 * define TARGET_OS_OSX as 1 if necessary, and then undo that afterward.
 * This assumes that we're actually building for macOS, which should usually
 * be the case with these headers.  Setting TARGET_OS_OSX avoids the check
 * for TARGET_OS_MACCATALYST.  The only possibly unwanted effect of this
 * is the "#define __IPHONE_COMPAT_VERSION  __IPHONE_NA", which is most
 * likely correct if it matters at all.
 *
 * Now that we're providing a definition for TARGET_OS_OSX in our wrapper
 * for TargetConditionals.h, we need to be sure that we don't undo that
 * action here if it was included by this header.  So we include a condition
 * for that.
 *
 * We don't bother with a guard macro here, since repeating the extra wrapper
 * code is a NOP, anyway.
 */

/* Avoid possible error from TARGET_OS_OSX test */
#ifndef TARGET_OS_OSX
#define TARGET_OS_OSX 1
#define __MPLS_TARGET_OS_OSX_UNDEF
#endif

#include_next <AvailabilityMacros.h>

/* Now restore the original TARGET_OS_OSX, unless we overrode it. */
#if defined(__MPLS_TARGET_OS_OSX_UNDEF) \
    && !defined(__MPLS_TARGETCONDITIONALS__)
#undef TARGET_OS_OSX
#endif
#undef __MPLS_TARGET_OS_OSX_UNDEF
