/*
 * This file is subject to the terms and conditions defined in
 * file 'LICENSE.txt', which is part of this source code package.
 */

"use strict";(self.webpackChunk=self.webpackChunk||[]).push([["445"],{85676:function(n){n.exports="---\ntitle: ClickHouse\ndescription: Learn how to connect Metabase to your ClickHouse database, including connection settings, database selection, and SSL configuration.\n---\n\n# ClickHouse\n\nTo add a database connection, click on the **gear** icon in the top right, and navigate to **Admin settings** > **Databases** > **Add a database**.\n\nYou can edit these settings at any time. Just remember to save your changes.\n\n## Connection and Sync\n\nAfter connecting to a database, you'll see the \"Connection and sync\" section that displays the current connection status and options to manage your database connection.\n\nHere you can [sync the database schema and rescan field values](../sync-scan.md), and edit connection details.\n\n## Edit connection details\n\nTo access or modify your database connection settings, click the **Edit connection details** button.\n\n### Connection string\n\nPaste a connection string here to pre-fill the remaining fields below.\n\n### Display name\n\nThe display name for the database in the Metabase interface.\n\n### Host\n\nYour database's IP address (e.g., `98.137.149.56`) or its domain name (e.g., `name.database.com`).\n\n### Port\n\nThe database port (e.g., `8123`).\n\n### Username\n\nThe database username for the account that you want to use to connect to your database. You can set up multiple connections to the same database using different user accounts to connect to the same database, each with different sets of [privileges](../users-roles-privileges.md).\n\n### Password\n\nThe password for the username that you use to connect to the database.\n\n### Databases\n\nInclude all of the database you want to be able to query in Metabase. Separate databases with the space character, e.g., `db1 db2 db3`.\n\n### Scan all databases\n\nScan all tables from all available ClickHouse databases except the system ones.\n\n### Use a secure connection (SSL)\n\nSee [SSL certificates](../ssl-certificates.md).\n\n### Use an SSH-tunnel\n\nIf a direct connection to your database isn't possible, you may want to use an SSH tunnel. See [SSH tunneling](../ssh-tunnel.md).\n\n### Disable system wide proxy settings\n\nSystem-wide proxy settings are disabled by default. You can disable them with this toggle.\n\n### ClickHouse settings (comma-separated)\n\nHere you can add a string to specify additional ClickHouse settings. Separate settings with a comma, like so:\n\n```\nallow_experimental_analyzer=1,max_result_rows=100\n```\n\n### Max open HTTP connections in the JDBC driver (default: 100)\n\nYou can limit the number of HTTP connections in the JDBC driver used to connect Metabase to ClickHouse.\n\n### Additional JDBC connection string options\n\nYou can append options to the JDBC connection string. Separate options with `&`, like so:\n\n```\nconnection_timeout=1000&socket_timeout=300000\n```\n\n### Re-run queries for simple explorations\n\nTurn this option **OFF** if people want to click **Run** (the play button) before applying any [Summarize](../../questions/query-builder/summarizing-and-grouping.md) or filter selections.\n\nBy default, Metabase will execute a query as soon as you choose an grouping option from the **Summarize** menu or a filter condition from the [drill-through menu](https://www.metabase.com/learn/metabase-basics/querying-and-dashboards/questions/drill-through). If your database is slow, you may want to disable re-running to avoid loading data on each click.\n\n### Choose when syncs and scans happen\n\nSee [syncs and scans](../sync-scan.md#choose-when-syncs-and-scans-happen).\n\n### Periodically refingerprint tables\n\n> Periodic refingerprinting will increase the load on your database.\n\nTurn this option **ON** to scan a sample of values every time Metabase runs a [sync](../sync-scan.md#how-database-syncs-work).\n\nA fingerprinting query examines the first 10,000 rows from each column and uses that data to guesstimate how many unique values each column has, what the minimum and maximum values are for numeric and timestamp columns, and so on. If you leave this option **OFF**, Metabase will only fingerprint your columns once during setup.\n\n## Model features\n\nThere aren't (yet) any model features for ClickHouse.\n\n## Danger zone\n\nSee [Danger zone](../danger-zone.md).\n"}}]);