/*
 * This file is subject to the terms and conditions defined in
 * file 'LICENSE.txt', which is part of this source code package.
 */

"use strict";(self.webpackChunk=self.webpackChunk||[]).push([["615"],{99202:function(e){e.exports="---\ntitle: Databricks\n---\n\n# Databricks\n\nTo add a database connection, click on the **gear** icon in the top right, and navigate to **Admin settings** > **Databases** > **Add a database**. Then select **Databricks**.\n\nYou can edit these settings at any time. Just remember to save your changes.\n\n## Edit connection details\n\n### Connection string\n\nPaste a connection string here to pre-fill the remaining fields below.\n\n### Display name\n\nThe display name for the database in the Metabase interface.\n\n### Host\n\nYour database's IP address, or its domain name (e.g., `xxxxxxxxxx.cloud.databricks.com` or `adb-xxxxx.azuredatabricks.net`). This is the value of your Databrick's compute resource's Server Hostname.\n\nSee [Compute settings for the Databricks JDBC Driver](https://docs.databricks.com/en/integrations/jdbc/compute.html).\n\n### HTTP path\n\nThis is the Databrick's compute resources HTTP Path value. This value is often a SQL warehouse endpoint in the format `/sql/1.0/endpoints/abcdef1234567890`. See [Connect to a SQL warehouse](https://docs.databricks.com/en/compute/sql-warehouse/index.html).\n\nAdditionally, see [Compute settings for the Databricks JDBC Driver](https://docs.databricks.com/en/integrations/jdbc/compute.html).\n\n### Authentication\n\nThere are two ways to authenticate with Databricks. You can use a personal access token (PAT) or a service principal using OAuth (OAuth M2M).\n\nThe Databricks driver supports both options. Use the toggle to select the authentication method you want to use.\n\n#### Personal access token authentication\n\nSee [Personal Access Token (PAT)](https://docs.databricks.com/en/dev-tools/auth/pat.html).\n\n#### Authenticate access with a service principal using OAuth (OAuth M2M)\n\nSee [Authenticate access with a service principal using OAuth](https://docs.databricks.com/en/dev-tools/auth/oauth-m2m.html).\n\n### Enable multiple catalogs\n\nToggle on to sync multiple catalogs. If you enable this, you'll be able to [specify which catalogs to sync](#catalogs-and-schemas).\n\n### Default catalog\n\nRequired. You must specify a default catalog (so you don't have to deal with catalog qualification in native queries).\n\nYou can't sync Databricks's legacy catalogs, however, including the `samples` or `hive_metastore` catalogs.\n\n### Catalogs and schemas\n\nYou can specify which catalogs and schemas you want to sync and scan. Options are:\n\n- All\n- Only these...\n- All except...\n\nFor the **Only these** and **All except** options, you can input a comma-separated list of values to tell Metabase which catalogs and schemas you want to include (or exclude). For example:\n\n```\nfoo,bar,baz\n```\n\nYou can use the `*` wildcard to match multiple schemas.\n\nLet's say you have three schemas: foo, bar, and baz.\n\n- If you have **Only these...** set, and enter the string `b*`, you'll sync with bar and baz.\n- If you have **All except...** set, and enter the string `b*`, you'll just sync foo.\n\nNote that only the `*` wildcard is supported; you can't use other special characters or regexes.\n\n### Additional JDBC connection string options\n\nYou can append options to the connection string that Metabase uses to connect to your database. E.g., `IgnoreTransactions=0`.\n\nSee [Compute settings for the Databricks JDBC Driver](https://docs.databricks.com/en/integrations/jdbc/compute.html).\n\n### Re-run queries for simple explorations\n\nTurn this option **OFF** if people want to click **Run** (the play button) before applying any summarizations or filters in the query builder.\n\nBy default, Metabase will execute a query as soon as you choose an grouping option from the **Summarize** menu or a filter condition from the [drill-through menu](https://www.metabase.com/learn/metabase-basics/querying-and-dashboards/questions/drill-through). If your database is slow, you may want to disable re-running to avoid loading data on each click.\n\n### Choose when syncs and scans happen\n\nSee [syncs and scans](../sync-scan.md#choose-when-syncs-and-scans-happen).\n\n### Periodically refingerprint tables\n\n> Periodic refingerprinting will increase the load on your database.\n\nTurn this option **ON** to scan a sample of values every time Metabase runs a [sync](../sync-scan.md#how-database-syncs-work).\n\nA fingerprinting query examines the first 10,000 rows from each column and uses that data to guesstimate how many unique values each column has, what the minimum and maximum values are for numeric and timestamp columns, and so on. If you leave this option **OFF**, Metabase will only fingerprint your columns once during setup.\n\n## Model features\n\nThere aren't (yet) any model features available for Databricks.\n\n## Database routing\n\nWith database routing, an admin can build a question once using one database, and the question will run its query against a different database with the same schema depending on who is viewing the question.\n\nWhen **multi-catalog is not enabled**, you can route between catalogs on the same host. If multi-catalog is enabled, then you can only route between databases on separate hosts.\n\nSee [Database routing](../../permissions/database-routing.md).\n\n## Danger zone\n\nSee [Danger zone](../danger-zone.md).\n\n## Further reading\n\n- [Managing databases](../../databases/connecting.md)\n- [Metadata editing](../../data-modeling/metadata-editing.md)\n- [Models](../../data-modeling/models.md)\n- [Setting data access permissions](../../permissions/data.md)\n"}}]);