# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.database_management.src.oci_cli_database_management.generated import database_management_service_cli


@click.command(cli_util.override('perfhub.perfhub_root_group.command_name', 'perfhub'), cls=CommandGroupWithAlias, help=cli_util.override('perfhub.perfhub_root_group.help', """Use the Database Management API to monitor and manage resources such as
Oracle Databases, MySQL Databases, and External Database Systems.
For more information, see [Database Management]."""), short_help=cli_util.override('perfhub.perfhub_root_group.short_help', """Database Management API"""))
@cli_util.help_option_group
def perfhub_root_group():
    pass


@click.command(cli_util.override('perfhub.managed_database_group.command_name', 'managed-database'), cls=CommandGroupWithAlias, help="""The details of a Managed Database.""")
@cli_util.help_option_group
def managed_database_group():
    pass


database_management_service_cli.database_management_service_group.add_command(perfhub_root_group)
perfhub_root_group.add_command(managed_database_group)


@managed_database_group.command(name=cli_util.override('perfhub.modify_snapshot_settings.command_name', 'modify-snapshot-settings'), help=u"""Modifies the snapshot settings for the specified Database. \n[Command Reference](modifySnapshotSettings)""")
@cli_util.option('--managed-database-id', required=True, help=u"""The [OCID] of the Managed Database.""")
@cli_util.option('--retention', type=click.INT, help=u"""The retention time in minutes. Acceptable values are 0, 1440 to 52596000 (inclusive), and null.""")
@cli_util.option('--interval', type=click.INT, help=u"""The interval time in minutes. Acceptable values are 0, 10 to 527040 (inclusive), and null.""")
@cli_util.option('--opc-named-credential-id', help=u"""The OCID of the Named Credential.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def modify_snapshot_settings(ctx, from_json, managed_database_id, retention, interval, opc_named_credential_id):

    if isinstance(managed_database_id, six.string_types) and len(managed_database_id.strip()) == 0:
        raise click.UsageError('Parameter --managed-database-id cannot be whitespace or empty string')

    kwargs = {}
    if opc_named_credential_id is not None:
        kwargs['opc_named_credential_id'] = opc_named_credential_id
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if retention is not None:
        _details['retention'] = retention

    if interval is not None:
        _details['interval'] = interval

    client = cli_util.build_client('database_management', 'perfhub', ctx)
    result = client.modify_snapshot_settings(
        managed_database_id=managed_database_id,
        modify_snapshot_settings_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)
