/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_cs extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ccp = "\u010dakma";
        final String metaValue_kpe = "kpelle";
        final String metaValue_nqo = "n\u2019ko";
        final String metaValue_vai = "vai";
        final Object[][] data = new Object[][] {
            { "001", "sv\u011bt" },
            { "002", "Afrika" },
            { "003", "Severn\u00ed Amerika" },
            { "005", "Ji\u017en\u00ed Amerika" },
            { "009", "Oce\u00e1nie" },
            { "011", "z\u00e1padn\u00ed Afrika" },
            { "013", "St\u0159edn\u00ed Amerika" },
            { "014", "v\u00fdchodn\u00ed Afrika" },
            { "015", "severn\u00ed Afrika" },
            { "017", "st\u0159edn\u00ed Afrika" },
            { "018", "ji\u017en\u00ed Afrika" },
            { "019", "Amerika" },
            { "021", "Severn\u00ed Amerika (oblast)" },
            { "029", "Karibik" },
            { "030", "v\u00fdchodn\u00ed Asie" },
            { "034", "ji\u017en\u00ed Asie" },
            { "035", "jihov\u00fdchodn\u00ed Asie" },
            { "039", "ji\u017en\u00ed Evropa" },
            { "053", "Australasie" },
            { "054", "Melan\u00e9sie" },
            { "057", "Mikron\u00e9sie (region)" },
            { "061", "Polyn\u00e9sie" },
            { "142", "Asie" },
            { "143", "St\u0159edn\u00ed Asie" },
            { "145", "z\u00e1padn\u00ed Asie" },
            { "150", "Evropa" },
            { "151", "v\u00fdchodn\u00ed Evropa" },
            { "154", "severn\u00ed Evropa" },
            { "155", "z\u00e1padn\u00ed Evropa" },
            { "202", "subsaharsk\u00e1 Afrika" },
            { "419", "Latinsk\u00e1 Amerika" },
            { "AC", "Ascension" },
            { "AD", "Andorra" },
            { "AE", "Spojen\u00e9 arabsk\u00e9 emir\u00e1ty" },
            { "AF", "Afgh\u00e1nist\u00e1n" },
            { "AG", "Antigua a Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Alb\u00e1nie" },
            { "AM", "Arm\u00e9nie" },
            { "AO", "Angola" },
            { "AQ", "Antarktida" },
            { "AR", "Argentina" },
            { "AS", "Americk\u00e1 Samoa" },
            { "AT", "Rakousko" },
            { "AU", "Austr\u00e1lie" },
            { "AW", "Aruba" },
            { "AX", "\u00c5landy" },
            { "AZ", "\u00c1zerb\u00e1jd\u017e\u00e1n" },
            { "BA", "Bosna a Hercegovina" },
            { "BB", "Barbados" },
            { "BD", "Banglad\u00e9\u0161" },
            { "BE", "Belgie" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulharsko" },
            { "BH", "Bahrajn" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Svat\u00fd Bartolom\u011bj" },
            { "BM", "Bermudy" },
            { "BN", "Brunej" },
            { "BO", "Bol\u00edvie" },
            { "BQ", "Karibsk\u00e9 Nizozemsko" },
            { "BR", "Braz\u00edlie" },
            { "BS", "Bahamy" },
            { "BT", "Bh\u00fat\u00e1n" },
            { "BV", "Bouvet\u016fv ostrov" },
            { "BW", "Botswana" },
            { "BY", "B\u011blorusko" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kokosov\u00e9 ostrovy" },
            { "CD", "Kongo \u2013 Kinshasa" },
            { "CF", "St\u0159edoafrick\u00e1 republika" },
            { "CG", "Kongo \u2013 Brazzaville" },
            { "CH", "\u0160v\u00fdcarsko" },
            { "CI", "Pob\u0159e\u017e\u00ed slonoviny" },
            { "CK", "Cookovy ostrovy" },
            { "CL", "Chile" },
            { "CM", "Kamerun" },
            { "CN", "\u010c\u00edna" },
            { "CO", "Kolumbie" },
            { "CP", "Clipperton\u016fv ostrov" },
            { "CR", "Kostarika" },
            { "CU", "Kuba" },
            { "CV", "Kapverdy" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "V\u00e1no\u010dn\u00ed ostrov" },
            { "CY", "Kypr" },
            { "CZ", "\u010cesko" },
            { "DE", "N\u011bmecko" },
            { "DG", "Diego Garc\u00eda" },
            { "DJ", "D\u017eibutsko" },
            { "DK", "D\u00e1nsko" },
            { "DM", "Dominika" },
            { "DO", "Dominik\u00e1nsk\u00e1 republika" },
            { "DZ", "Al\u017e\u00edrsko" },
            { "EA", "Ceuta a Melilla" },
            { "EC", "Ekv\u00e1dor" },
            { "EE", "Estonsko" },
            { "EG", "Egypt" },
            { "EH", "Z\u00e1padn\u00ed Sahara" },
            { "ER", "Eritrea" },
            { "ES", "\u0160pan\u011blsko" },
            { "ET", "Etiopie" },
            { "EU", "Evropsk\u00e1 unie" },
            { "EZ", "euroz\u00f3na" },
            { "FI", "Finsko" },
            { "FJ", "Fid\u017ei" },
            { "FK", "Falklandsk\u00e9 ostrovy" },
            { "FM", "Mikron\u00e9sie" },
            { "FO", "Faersk\u00e9 ostrovy" },
            { "FR", "Francie" },
            { "GA", "Gabon" },
            { "GB", "Spojen\u00e9 kr\u00e1lovstv\u00ed" },
            { "GD", "Grenada" },
            { "GE", "Gruzie" },
            { "GF", "Francouzsk\u00e1 Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Gr\u00f3nsko" },
            { "GM", "Gambie" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Rovn\u00edkov\u00e1 Guinea" },
            { "GR", "\u0158ecko" },
            { "GS", "Ji\u017en\u00ed Georgie a Ji\u017en\u00ed Sandwichovy ostrovy" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hongkong \u2013 ZAO \u010c\u00edny" },
            { "HM", "Heard\u016fv ostrov a McDonaldovy ostrovy" },
            { "HN", "Honduras" },
            { "HR", "Chorvatsko" },
            { "HT", "Haiti" },
            { "HU", "Ma\u010farsko" },
            { "IC", "Kan\u00e1rsk\u00e9 ostrovy" },
            { "ID", "Indon\u00e9sie" },
            { "IE", "Irsko" },
            { "IL", "Izrael" },
            { "IM", "Ostrov Man" },
            { "IN", "Indie" },
            { "IO", "Britsk\u00e9 indickooce\u00e1nsk\u00e9 \u00fazem\u00ed" },
            { "IQ", "Ir\u00e1k" },
            { "IR", "\u00cdr\u00e1n" },
            { "IS", "Island" },
            { "IT", "It\u00e1lie" },
            { "JE", "Jersey" },
            { "JM", "Jamajka" },
            { "JO", "Jord\u00e1nsko" },
            { "JP", "Japonsko" },
            { "KE", "Ke\u0148a" },
            { "KG", "Kyrgyzst\u00e1n" },
            { "KH", "Kambod\u017ea" },
            { "KI", "Kiribati" },
            { "KM", "Komory" },
            { "KN", "Svat\u00fd Kry\u0161tof a Nevis" },
            { "KP", "Severn\u00ed Korea" },
            { "KR", "Ji\u017en\u00ed Korea" },
            { "KW", "Kuvajt" },
            { "KY", "Kajmansk\u00e9 ostrovy" },
            { "KZ", "Kazachst\u00e1n" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "Svat\u00e1 Lucie" },
            { "LI", "Lichten\u0161tejnsko" },
            { "LK", "Sr\u00ed Lanka" },
            { "LR", "Lib\u00e9rie" },
            { "LS", "Lesotho" },
            { "LT", "Litva" },
            { "LU", "Lucembursko" },
            { "LV", "Loty\u0161sko" },
            { "LY", "Libye" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Moldavsko" },
            { "ME", "\u010cern\u00e1 Hora" },
            { "MF", "Svat\u00fd Martin (Francie)" },
            { "MG", "Madagaskar" },
            { "MH", "Marshallovy ostrovy" },
            { "MK", "Severn\u00ed Makedonie" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Barma)" },
            { "MN", "Mongolsko" },
            { "MO", "Macao \u2013 ZAO \u010c\u00edny" },
            { "MP", "Severn\u00ed Mariany" },
            { "MQ", "Martinik" },
            { "MR", "Maurit\u00e1nie" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauricius" },
            { "MV", "Maledivy" },
            { "MW", "Malawi" },
            { "MX", "Mexiko" },
            { "MY", "Malajsie" },
            { "MZ", "Mosambik" },
            { "NA", "Namibie" },
            { "NC", "Nov\u00e1 Kaledonie" },
            { "NE", "Niger" },
            { "NF", "Norfolk" },
            { "NG", "Nig\u00e9rie" },
            { "NI", "Nikaragua" },
            { "NL", "Nizozemsko" },
            { "NO", "Norsko" },
            { "NP", "Nep\u00e1l" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nov\u00fd Z\u00e9land" },
            { "OM", "Om\u00e1n" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Francouzsk\u00e1 Polyn\u00e9sie" },
            { "PG", "Papua-Nov\u00e1 Guinea" },
            { "PH", "Filip\u00edny" },
            { "PK", "P\u00e1kist\u00e1n" },
            { "PL", "Polsko" },
            { "PM", "Saint-Pierre a Miquelon" },
            { "PN", "Pitcairnovy ostrovy" },
            { "PR", "Portoriko" },
            { "PS", "Palestinsk\u00e1 \u00fazem\u00ed" },
            { "PT", "Portugalsko" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Katar" },
            { "QO", "vn\u011bj\u0161\u00ed Oce\u00e1nie" },
            { "RE", "R\u00e9union" },
            { "RO", "Rumunsko" },
            { "RS", "Srbsko" },
            { "RU", "Rusko" },
            { "RW", "Rwanda" },
            { "SA", "Sa\u00fadsk\u00e1 Ar\u00e1bie" },
            { "SB", "\u0160alamounovy ostrovy" },
            { "SC", "Seychely" },
            { "SD", "S\u00fad\u00e1n" },
            { "SE", "\u0160v\u00e9dsko" },
            { "SG", "Singapur" },
            { "SH", "Svat\u00e1 Helena" },
            { "SI", "Slovinsko" },
            { "SJ", "\u0160picberky a Jan Mayen" },
            { "SK", "Slovensko" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Som\u00e1lsko" },
            { "SR", "Surinam" },
            { "SS", "Ji\u017en\u00ed S\u00fad\u00e1n" },
            { "ST", "Svat\u00fd Tom\u00e1\u0161 a Princ\u016fv ostrov" },
            { "SV", "Salvador" },
            { "SX", "Svat\u00fd Martin (Nizozemsko)" },
            { "SY", "S\u00fdrie" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks a Caicos" },
            { "TD", "\u010cad" },
            { "TF", "Francouzsk\u00e1 ji\u017en\u00ed \u00fazem\u00ed" },
            { "TG", "Togo" },
            { "TH", "Thajsko" },
            { "TJ", "T\u00e1d\u017eikist\u00e1n" },
            { "TK", "Tokelau" },
            { "TL", "V\u00fdchodn\u00ed Timor" },
            { "TM", "Turkmenist\u00e1n" },
            { "TN", "Tunisko" },
            { "TO", "Tonga" },
            { "TR", "Turecko" },
            { "TT", "Trinidad a Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Tchaj-wan" },
            { "TZ", "Tanzanie" },
            { "UA", "Ukrajina" },
            { "UG", "Uganda" },
            { "UM", "Men\u0161\u00ed odlehl\u00e9 ostrovy USA" },
            { "UN", "Organizace spojen\u00fdch n\u00e1rod\u016f" },
            { "US", "Spojen\u00e9 st\u00e1ty" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekist\u00e1n" },
            { "VA", "Vatik\u00e1n" },
            { "VC", "Svat\u00fd Vincenc a Grenadiny" },
            { "VE", "Venezuela" },
            { "VG", "Britsk\u00e9 Panensk\u00e9 ostrovy" },
            { "VI", "Americk\u00e9 Panensk\u00e9 ostrovy" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis a Futuna" },
            { "WS", "Samoa" },
            { "XA", "simulovan\u00e1 diakritika" },
            { "XB", "simulovan\u00fd obousm\u011brn\u00fd z\u00e1pis" },
            { "XK", "Kosovo" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "Jihoafrick\u00e1 republika" },
            { "ZM", "Zambie" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "nezn\u00e1m\u00e1 oblast" },
            { "aa", "afar\u0161tina" },
            { "ab", "abch\u00e1z\u0161tina" },
            { "ae", "avest\u00e1n\u0161tina" },
            { "af", "afrik\u00e1n\u0161tina" },
            { "ak", "akan\u0161tina" },
            { "am", "amhar\u0161tina" },
            { "an", "aragon\u0161tina" },
            { "ar", "arab\u0161tina" },
            { "as", "\u00e1s\u00e1m\u0161tina" },
            { "av", "avar\u0161tina" },
            { "ay", "ajmar\u0161tina" },
            { "az", "\u00e1zerb\u00e1jd\u017e\u00e1n\u0161tina" },
            { "ba", "ba\u0161kir\u0161tina" },
            { "be", "b\u011bloru\u0161tina" },
            { "bg", "bulhar\u0161tina" },
            { "bi", "bislam\u0161tina" },
            { "bm", "bambar\u0161tina" },
            { "bn", "beng\u00e1l\u0161tina" },
            { "bo", "tibet\u0161tina" },
            { "br", "breton\u0161tina" },
            { "bs", "bosen\u0161tina" },
            { "ca", "katal\u00e1n\u0161tina" },
            { "ce", "\u010de\u010den\u0161tina" },
            { "ch", "\u010damoro" },
            { "co", "korsi\u010dtina" },
            { "cr", "kr\u00edj\u0161tina" },
            { "cs", "\u010de\u0161tina" },
            { "cu", "staroslov\u011bn\u0161tina" },
            { "cv", "\u010duva\u0161tina" },
            { "cy", "vel\u0161tina" },
            { "da", "d\u00e1n\u0161tina" },
            { "de", "n\u011bm\u010dina" },
            { "dv", "malediv\u0161tina" },
            { "dz", "dzongk\u00e4" },
            { "ee", "ewe\u0161tina" },
            { "el", "\u0159e\u010dtina" },
            { "en", "angli\u010dtina" },
            { "eo", "esperanto" },
            { "es", "\u0161pan\u011bl\u0161tina" },
            { "et", "eston\u0161tina" },
            { "eu", "baski\u010dtina" },
            { "fa", "per\u0161tina" },
            { "ff", "fulb\u0161tina" },
            { "fi", "fin\u0161tina" },
            { "fj", "fid\u017eij\u0161tina" },
            { "fo", "faer\u0161tina" },
            { "fr", "francouz\u0161tina" },
            { "fy", "fr\u00ed\u0161tina (z\u00e1padn\u00ed)" },
            { "ga", "ir\u0161tina" },
            { "gd", "skotsk\u00e1 gael\u0161tina" },
            { "gl", "galicij\u0161tina" },
            { "gn", "guaran\u0161tina" },
            { "gu", "gud\u017ear\u00e1t\u0161tina" },
            { "gv", "man\u0161tina" },
            { "ha", "hau\u0161tina" },
            { "he", "hebrej\u0161tina" },
            { "hi", "hind\u0161tina" },
            { "ho", "hiri motu" },
            { "hr", "chorvat\u0161tina" },
            { "ht", "hait\u0161tina" },
            { "hu", "ma\u010far\u0161tina" },
            { "hy", "arm\u00e9n\u0161tina" },
            { "hz", "herer\u0161tina" },
            { "ia", "interlingua" },
            { "id", "indon\u00e9\u0161tina" },
            { "ie", "interlingue" },
            { "ig", "igbo\u0161tina" },
            { "ii", "i\u0161tina (se\u010du\u00e1nsk\u00e1)" },
            { "ik", "inupiak\u0161tina" },
            { "io", "ido" },
            { "is", "island\u0161tina" },
            { "it", "ital\u0161tina" },
            { "iu", "inuktitut\u0161tina" },
            { "ja", "japon\u0161tina" },
            { "jv", "jav\u00e1n\u0161tina" },
            { "ka", "gruz\u00edn\u0161tina" },
            { "kg", "kon\u017e\u0161tina" },
            { "ki", "kikuj\u0161tina" },
            { "kj", "kua\u0148am\u0161tina" },
            { "kk", "kaza\u0161tina" },
            { "kl", "gr\u00f3n\u0161tina" },
            { "km", "khm\u00e9r\u0161tina" },
            { "kn", "kannad\u0161tina" },
            { "ko", "korej\u0161tina" },
            { "kr", "kanuri" },
            { "ks", "ka\u0161m\u00edr\u0161tina" },
            { "ku", "kurd\u0161tina" },
            { "kv", "komij\u0161tina" },
            { "kw", "korn\u0161tina" },
            { "ky", "kyrgyz\u0161tina" },
            { "la", "latina" },
            { "lb", "lucembur\u0161tina" },
            { "lg", "gand\u0161tina" },
            { "li", "limbur\u0161tina" },
            { "ln", "lingal\u0161tina" },
            { "lo", "lao\u0161tina" },
            { "lt", "litev\u0161tina" },
            { "lu", "lubu-katan\u017e\u0161tina" },
            { "lv", "loty\u0161tina" },
            { "mg", "malga\u0161tina" },
            { "mh", "mar\u0161\u00e1l\u0161tina" },
            { "mi", "maor\u0161tina" },
            { "mk", "makedon\u0161tina" },
            { "ml", "malaj\u00e1lam\u0161tina" },
            { "mn", "mongol\u0161tina" },
            { "mr", "mar\u00e1th\u0161tina" },
            { "ms", "malaj\u0161tina" },
            { "mt", "malt\u0161tina" },
            { "my", "barm\u0161tina" },
            { "na", "naur\u0161tina" },
            { "nb", "nor\u0161tina (bokm\u00e5l)" },
            { "nd", "ndebele (Zimbabwe)" },
            { "ne", "nep\u00e1l\u0161tina" },
            { "ng", "ndond\u0161tina" },
            { "nl", "nizozem\u0161tina" },
            { "nn", "nor\u0161tina (nynorsk)" },
            { "no", "nor\u0161tina" },
            { "nr", "ndebele (Ji\u017en\u00ed Afrika)" },
            { "nv", "nava\u017e\u0161tina" },
            { "ny", "\u0148and\u017e\u0161tina" },
            { "oc", "okcit\u00e1n\u0161tina" },
            { "oj", "od\u017eibvej\u0161tina" },
            { "om", "orom\u0161tina" },
            { "or", "urij\u0161tina" },
            { "os", "oset\u0161tina" },
            { "pa", "pa\u0148d\u017e\u00e1b\u0161tina" },
            { "pi", "p\u00e1l\u00ed" },
            { "pl", "pol\u0161tina" },
            { "ps", "pa\u0161t\u0161tina" },
            { "pt", "portugal\u0161tina" },
            { "qu", "ke\u010du\u00e1n\u0161tina" },
            { "rm", "r\u00e9torom\u00e1n\u0161tina" },
            { "rn", "kirund\u0161tina" },
            { "ro", "rumun\u0161tina" },
            { "ru", "ru\u0161tina" },
            { "rw", "ki\u0148arwand\u0161tina" },
            { "sa", "sanskrt" },
            { "sc", "sard\u0161tina" },
            { "sd", "sindh\u0161tina" },
            { "se", "s\u00e1m\u0161tina (severn\u00ed)" },
            { "sg", "sang\u0161tina" },
            { "sh", "srbochorvat\u0161tina" },
            { "si", "sinh\u00e1l\u0161tina" },
            { "sk", "sloven\u0161tina" },
            { "sl", "slovin\u0161tina" },
            { "sm", "samoj\u0161tina" },
            { "sn", "\u0161on\u0161tina" },
            { "so", "som\u00e1l\u0161tina" },
            { "sq", "alb\u00e1n\u0161tina" },
            { "sr", "srb\u0161tina" },
            { "ss", "siswat\u0161tina" },
            { "st", "sot\u0161tina (ji\u017en\u00ed)" },
            { "su", "sund\u0161tina" },
            { "sv", "\u0161v\u00e9d\u0161tina" },
            { "sw", "svahil\u0161tina" },
            { "ta", "tamil\u0161tina" },
            { "te", "telug\u0161tina" },
            { "tg", "t\u00e1d\u017ei\u010dtina" },
            { "th", "thaj\u0161tina" },
            { "ti", "tigrinij\u0161tina" },
            { "tk", "turkmen\u0161tina" },
            { "tl", "tagalog" },
            { "tn", "setswan\u0161tina" },
            { "to", "tong\u00e1n\u0161tina" },
            { "tr", "ture\u010dtina" },
            { "ts", "tsonga" },
            { "tt", "tatar\u0161tina" },
            { "tw", "twi" },
            { "ty", "tahit\u0161tina" },
            { "ug", "ujgur\u0161tina" },
            { "uk", "ukrajin\u0161tina" },
            { "ur", "urd\u0161tina" },
            { "uz", "uzbe\u010dtina" },
            { "ve", "venda" },
            { "vi", "vietnam\u0161tina" },
            { "vo", "volap\u00fck" },
            { "wa", "valon\u0161tina" },
            { "wo", "wolof\u0161tina" },
            { "xh", "xho\u0161tina" },
            { "yi", "jidi\u0161" },
            { "yo", "jorub\u0161tina" },
            { "za", "\u010duang\u0161tina" },
            { "zh", "\u010d\u00edn\u0161tina" },
            { "zu", "zulu\u0161tina" },
            { "ace", "aceh\u0161tina" },
            { "ach", "akol\u0161tina" },
            { "ada", "adangme" },
            { "ady", "adygej\u0161tina" },
            { "aeb", "arab\u0161tina (tunisk\u00e1)" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ain\u0161tina" },
            { "akk", "akkad\u0161tina" },
            { "akz", "alabam\u0161tina" },
            { "ale", "aleut\u0161tina" },
            { "aln", "alb\u00e1n\u0161tina (Gheg)" },
            { "alt", "altaj\u0161tina (ji\u017en\u00ed)" },
            { "ang", "staroangli\u010dtina" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "aramej\u0161tina" },
            { "arn", "mapudungun" },
            { "aro", "araon\u0161tina" },
            { "arp", "arapa\u017e\u0161tina" },
            { "arq", "arab\u0161tina (al\u017e\u00edrsk\u00e1)" },
            { "ars", "arab\u0161tina (Nad\u017ed)" },
            { "arw", "arawack\u00e9 jazyky" },
            { "ary", "arab\u0161tina (marock\u00e1)" },
            { "arz", "arab\u0161tina (egyptsk\u00e1)" },
            { "asa", "asu" },
            { "ase", "znakov\u00e1 \u0159e\u010d (americk\u00e1)" },
            { "ast", "astur\u0161tina" },
            { "atj", "atikamek\u0161tina" },
            { "avk", "kotava" },
            { "awa", "awadh\u0161tina" },
            { "bal", "bal\u00fa\u010d\u0161tina" },
            { "ban", "balij\u0161tina" },
            { "bar", "bavor\u0161tina" },
            { "bas", "basa" },
            { "bax", "bamun" },
            { "bbc", "batak toba" },
            { "bbj", "ghomala" },
            { "bej", "bed\u017ea" },
            { "bem", "bemb\u0161tina" },
            { "bew", "batav\u0161tina" },
            { "bez", "bena" },
            { "bfd", "bafut" },
            { "bfq", "badag\u0161tina" },
            { "bgc", "harij\u00e1n\u0161tina" },
            { "bgn", "bal\u00fa\u010d\u0161tina (z\u00e1padn\u00ed)" },
            { "bho", "bh\u00f3d\u017epur\u0161tina" },
            { "bik", "bikol\u0161tina" },
            { "bin", "bini" },
            { "bjn", "band\u017ear\u0161tina" },
            { "bkm", "kom" },
            { "bla", "siksika" },
            { "bpy", "bi\u0161nuprijskomanipur\u0161tina" },
            { "bqi", "bachtij\u00e1r\u0161tina" },
            { "bra", "brad\u017e\u0161tina" },
            { "brh", "brahuj\u0161tina" },
            { "brx", "bodo\u0161tina" },
            { "bss", "akoose" },
            { "bua", "burjat\u0161tina" },
            { "bug", "bugi\u0161tina" },
            { "bum", "bulu" },
            { "byn", "blin\u0161tina" },
            { "byv", "medumba" },
            { "cad", "caddo" },
            { "car", "karib\u0161tina" },
            { "cay", "kajug\u0161tina" },
            { "cch", "atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "cebu\u00e1n\u0161tina" },
            { "cgg", "kiga" },
            { "chb", "\u010dib\u010da" },
            { "chg", "\u010dagataj\u0161tina" },
            { "chk", "\u010duk\u0161tina" },
            { "chm", "marij\u0161tina" },
            { "chn", "\u010dinuk pid\u017ein" },
            { "cho", "\u010dokt\u0161tina" },
            { "chp", "\u010dipevaj\u0161tina" },
            { "chr", "\u010derok\u00e9z\u0161tina" },
            { "chy", "\u010dejen\u0161tina" },
            { "ckb", "kurd\u0161tina (sor\u00e1n\u00ed)" },
            { "clc", "\u010dilkotin\u0161tina" },
            { "cop", "kopt\u0161tina" },
            { "cps", "kapiznon\u0161tina" },
            { "crg", "mi\u010dif" },
            { "crh", "tatar\u0161tina (krymsk\u00e1)" },
            { "crj", "kr\u00edj\u0161tina (jihov\u00fdchodn\u00ed)" },
            { "crk", "kr\u00edj\u0161tina (z pl\u00e1n\u00ed)" },
            { "crl", "kr\u00edj\u0161tina (severov\u00fdchodn\u00ed)" },
            { "crm", "kr\u00edj\u0161tina (Moose)" },
            { "crr", "algonkin\u0161tina (Karol\u00edna)" },
            { "crs", "kreol\u0161tina (seychelsk\u00e1)" },
            { "csb", "ka\u0161ub\u0161tina" },
            { "csw", "kr\u00edj\u0161tina (z ba\u017ein)" },
            { "dak", "dakot\u0161tina" },
            { "dar", "darg\u0161tina" },
            { "dav", "taita" },
            { "del", "delawar\u0161tina" },
            { "den", "slejv\u0161tina (athabask\u00fd jazyk)" },
            { "dgr", "dogrib" },
            { "din", "dink\u0161tina" },
            { "dje", "zarm\u0161tina" },
            { "doi", "dogar\u0161tina" },
            { "dsb", "dolnolu\u017eick\u00e1 srb\u0161tina" },
            { "dtp", "kadazandusun\u0161tina" },
            { "dua", "dual\u0161tina" },
            { "dum", "holand\u0161tina (st\u0159edov\u011bk\u00e1)" },
            { "dyo", "jola-fonyi" },
            { "dyu", "djula" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efik\u0161tina" },
            { "egl", "emilij\u0161tina" },
            { "egy", "egypt\u0161tina star\u00e1" },
            { "eka", "ekajuk" },
            { "elx", "elamit\u0161tina" },
            { "enm", "angli\u010dtina (st\u0159edov\u011bk\u00e1)" },
            { "esu", "jupik\u0161tina (st\u0159edoalja\u0161sk\u00e1)" },
            { "ewo", "ewondo" },
            { "ext", "extremadur\u0161tina" },
            { "fan", "fang" },
            { "fat", "fant\u0161tina" },
            { "fil", "filip\u00edn\u0161tina" },
            { "fit", "fin\u0161tina (tornedalsk\u00e1)" },
            { "fon", "fon\u0161tina" },
            { "frc", "francouz\u0161tina (cajunsk\u00e1)" },
            { "frm", "francouz\u0161tina (st\u0159edov\u011bk\u00e1)" },
            { "fro", "francouz\u0161tina (star\u00e1)" },
            { "frp", "franko-provens\u00e1l\u0161tina" },
            { "frr", "fr\u00ed\u0161tina (severn\u00ed)" },
            { "frs", "fr\u00ed\u0161tina (v\u00fdchodn\u00ed)" },
            { "fur", "furlan\u0161tina" },
            { "gaa", "ga\u0161tina" },
            { "gag", "gagauz\u0161tina" },
            { "gan", "\u010d\u00edn\u0161tina (dialekty Gan)" },
            { "gay", "gayo" },
            { "gba", "gbaja" },
            { "gbz", "dar\u00edj\u0161tina (zoroastrijsk\u00e1)" },
            { "gez", "geez" },
            { "gil", "kiribat\u0161tina" },
            { "glk", "gila\u010dtina" },
            { "gmh", "hornon\u011bm\u010dina (st\u0159edov\u011bk\u00e1)" },
            { "goh", "hornon\u011bm\u010dina (star\u00e1)" },
            { "gom", "konk\u00e1n\u0161tina (Goa)" },
            { "gon", "g\u00f3nd\u0161tina" },
            { "gor", "gorontalo" },
            { "got", "g\u00f3t\u0161tina" },
            { "grb", "grebo" },
            { "grc", "staro\u0159e\u010dtina" },
            { "gsw", "n\u011bm\u010dina (\u0160v\u00fdcarsko)" },
            { "guc", "way\u00fau\u0161tina" },
            { "gur", "frafra" },
            { "guz", "gusii" },
            { "gwi", "gwich\u02bcin" },
            { "hai", "haid\u0161tina" },
            { "hak", "\u010d\u00edn\u0161tina (dialekty Hakka)" },
            { "haw", "havaj\u0161tina" },
            { "hax", "haid\u0161tina (ji\u017en\u00ed)" },
            { "hif", "hind\u0161tina (Fid\u017ei)" },
            { "hil", "hiligajnon\u0161tina" },
            { "hit", "chetit\u0161tina" },
            { "hmn", "hmong\u0161tina" },
            { "hsb", "hornolu\u017eick\u00e1 srb\u0161tina" },
            { "hsn", "\u010d\u00edn\u0161tina (dialekty Xiang)" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban\u0161tina" },
            { "ibb", "ibibio" },
            { "ikt", "inuktitut\u0161tina (z\u00e1padokanadsk\u00e1)" },
            { "ilo", "ilok\u00e1n\u0161tina" },
            { "inh", "ingu\u0161tina" },
            { "izh", "ingrij\u0161tina" },
            { "jam", "jamajsk\u00e1 kreol\u0161tina" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "ma\u0161ame" },
            { "jpr", "judeoper\u0161tina" },
            { "jrb", "judeoarab\u0161tina" },
            { "jut", "jut\u0161tina" },
            { "kaa", "karakalpa\u010dtina" },
            { "kab", "kabyl\u0161tina" },
            { "kac", "ka\u010dij\u0161tina" },
            { "kaj", "jju" },
            { "kam", "kamb\u0161tina" },
            { "kaw", "kawi" },
            { "kbd", "kabardin\u0161tina" },
            { "kbl", "kanembu" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "kapverd\u0161tina" },
            { "ken", "kenyang" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "kh\u00e1s\u00ed" },
            { "kho", "chot\u00e1n\u0161tina" },
            { "khq", "koyra chiini" },
            { "khw", "chovar\u0161tina" },
            { "kiu", "zazak\u0161tina" },
            { "kkj", "kako" },
            { "kln", "kalend\u017ein" },
            { "kmb", "kimbund\u0161tina" },
            { "koi", "komi-permja\u010dtina" },
            { "kok", "konk\u00e1n\u0161tina" },
            { "kos", "kosraj\u0161tina" },
            { "kpe", metaValue_kpe },
            { "krc", "kara\u010dajevo-balkar\u0161tina" },
            { "kri", "krio" },
            { "krj", "kinaraj-a" },
            { "krl", "karel\u0161tina" },
            { "kru", "kuruch\u0161tina" },
            { "ksb", "\u0161ambala" },
            { "ksf", "bafia" },
            { "ksh", "kol\u00edn\u0161tina" },
            { "kum", "kumy\u010dtina" },
            { "kut", "kutenaj\u0161tina" },
            { "kwk", "kvakiut\u0161tina" },
            { "lad", "ladin\u0161tina" },
            { "lag", "langi" },
            { "lah", "lahnd\u0161tina" },
            { "lam", "lamb\u0161tina" },
            { "lez", "lezgin\u0161tina" },
            { "lfn", "lingua franca nova" },
            { "lij", "ligur\u0161tina" },
            { "lil", "lillooet\u0161tina" },
            { "liv", "livon\u0161tina" },
            { "lkt", "lakot\u0161tina" },
            { "lmo", "lombard\u0161tina" },
            { "lol", "mong\u0161tina" },
            { "lou", "kreol\u0161tina (Louisiana)" },
            { "loz", "loz\u0161tina" },
            { "lrc", "l\u00far\u0161tina (severn\u00ed)" },
            { "lsm", "samia" },
            { "ltg", "latgal\u0161tina" },
            { "lua", "luba-lulua\u0161tina" },
            { "lui", "luise\u0148o" },
            { "lun", "lund\u0161tina" },
            { "luo", "luo\u0161tina" },
            { "lus", "mizo\u0161tina" },
            { "luy", "luhja" },
            { "lzh", "\u010d\u00edn\u0161tina (klasick\u00e1)" },
            { "lzz", "laz\u0161tina" },
            { "mad", "madur\u0161tina" },
            { "maf", "mafa" },
            { "mag", "magahij\u0161tina" },
            { "mai", "maithili\u0161tina" },
            { "mak", "makasar\u0161tina" },
            { "man", "manding\u0161tina" },
            { "mas", "masaj\u0161tina" },
            { "mde", "maba" },
            { "mdf", "mok\u0161an\u0161tina" },
            { "mdr", "mandar" },
            { "men", "mende" },
            { "mer", "meru" },
            { "mfe", "mauricijsk\u00e1 kreol\u0161tina" },
            { "mga", "ir\u0161tina (st\u0159edov\u011bk\u00e1)" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta\u2019" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mnc", "mand\u017eu\u0161tina" },
            { "mni", "manipur\u0161tina" },
            { "moe", "innu-aimun" },
            { "moh", "mohawk\u0161tina" },
            { "mos", "mosi" },
            { "mrj", "marij\u0161tina (z\u00e1padn\u00ed)" },
            { "mua", "mundang" },
            { "mul", "v\u00edce jazyk\u016f" },
            { "mus", "kr\u00edk\u0161tina" },
            { "mwl", "mirand\u0161tina" },
            { "mwr", "m\u00e1rv\u00e1r\u0161tina" },
            { "mwv", "mentavaj\u0161tina" },
            { "mye", "myene" },
            { "myv", "erzjan\u0161tina" },
            { "mzn", "m\u00e1zandar\u00e1n\u0161tina" },
            { "nan", "\u010d\u00edn\u0161tina (dialekty Minnan)" },
            { "nap", "neapol\u0161tina" },
            { "naq", "nama\u0161tina" },
            { "nds", "dolnon\u011bm\u010dina" },
            { "new", "n\u00e9v\u00e1r\u0161tina" },
            { "nia", "nias" },
            { "niu", "niue\u0161tina" },
            { "njo", "ao (jazyky N\u00e1g\u00e1landu)" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogaj\u0161tina" },
            { "non", "nor\u0161tina historick\u00e1" },
            { "nov", "novial" },
            { "nqo", metaValue_nqo },
            { "nso", "sot\u0161tina (severn\u00ed)" },
            { "nus", "nuer\u0161tina" },
            { "nwc", "newar\u0161tina (klasick\u00e1)" },
            { "nym", "\u0148amwe\u017e\u0161tina" },
            { "nyn", "\u0148ankol\u0161tina" },
            { "nyo", "\u0148or\u0161tina" },
            { "nzi", "nzima" },
            { "ojb", "od\u017eibvej\u0161tina (severoz\u00e1padn\u00ed)" },
            { "ojc", "od\u017eibvej\u0161tina (st\u0159edn\u00ed)" },
            { "ojs", "od\u017eibvej\u0161tina (severn\u00ed)" },
            { "ojw", "od\u017eibvej\u0161tina (z\u00e1padn\u00ed)" },
            { "oka", "okanagan\u0161tina" },
            { "osa", "osage" },
            { "ota", "ture\u010dtina (osmansk\u00e1)" },
            { "pag", "pangasinan\u0161tina" },
            { "pal", "pahlav\u0161tina" },
            { "pam", "papangau" },
            { "pap", "papiamento" },
            { "pau", "palau\u0161tina" },
            { "pcd", "picard\u0161tina" },
            { "pcm", "nigerijsk\u00fd pid\u017ein" },
            { "pdc", "n\u011bm\u010dina (pensylv\u00e1nsk\u00e1)" },
            { "pdt", "n\u011bm\u010dina (plautdietsch)" },
            { "peo", "staroper\u0161tina" },
            { "pfl", "fal\u010dtina" },
            { "phn", "f\u00e9ni\u010dtina" },
            { "pis", "pid\u017ein (\u0160alomounovy ostrovy)" },
            { "pms", "piemon\u0161tina" },
            { "pnt", "pont\u0161tina" },
            { "pon", "pohnpei\u0161tina" },
            { "pqm", "malesit\u0161tina-passamaquodd\u0161tina" },
            { "prg", "pru\u0161tina" },
            { "pro", "provens\u00e1l\u0161tina" },
            { "quc", "ki\u010d\u00e9" },
            { "qug", "ke\u010du\u00e1n\u0161tina (chimborazo)" },
            { "raj", "r\u00e1d\u017east\u00e1n\u0161tina" },
            { "rap", "rapanuj\u0161tina" },
            { "rar", "rarotong\u00e1n\u0161tina" },
            { "rgn", "roma\u0148ol\u0161tina" },
            { "rhg", "rohing\u0161tina" },
            { "rif", "r\u00edf\u0161tina" },
            { "rof", "rombo" },
            { "rom", "rom\u0161tina" },
            { "rtm", "rotuman\u0161tina" },
            { "rue", "rus\u00edn\u0161tina" },
            { "rug", "rovian\u0161tina" },
            { "rup", "arumun\u0161tina" },
            { "rwk", "rwa" },
            { "sad", "sandaw\u0161tina" },
            { "sah", "jakut\u0161tina" },
            { "sam", "samar\u0161tina" },
            { "saq", "samburu" },
            { "sas", "sasak\u0161tina" },
            { "sat", "sant\u00e1l\u0161tina" },
            { "saz", "saur\u00e1\u0161ter\u0161tina" },
            { "sba", "ngambay" },
            { "sbp", "sango\u0161tina" },
            { "scn", "sicil\u0161tina" },
            { "sco", "skot\u0161tina" },
            { "sdc", "sassar\u0161tina" },
            { "sdh", "kurd\u0161tina (ji\u017en\u00ed)" },
            { "see", "seneca" },
            { "seh", "sena" },
            { "sei", "seri\u0161tina" },
            { "sel", "selkup\u0161tina" },
            { "ses", "koyraboro senni" },
            { "sga", "ir\u0161tina (star\u00e1)" },
            { "sgs", "\u017eemait\u0161tina" },
            { "shi", "ta\u0161elhit" },
            { "shn", "\u0161an\u0161tina" },
            { "shu", "arab\u0161tina (\u010dadsk\u00e1)" },
            { "sid", "sidamo" },
            { "slh", "lushootseed (ji\u017en\u00ed)" },
            { "sli", "n\u011bm\u010dina (slezsk\u00e1)" },
            { "sly", "selajar\u0161tina" },
            { "sma", "s\u00e1m\u0161tina (ji\u017en\u00ed)" },
            { "smj", "s\u00e1m\u0161tina (lulejsk\u00e1)" },
            { "smn", "s\u00e1m\u0161tina (inarijsk\u00e1)" },
            { "sms", "s\u00e1m\u0161tina (skoltsk\u00e1)" },
            { "snk", "sonik\u0161tina" },
            { "sog", "sogd\u0161tina" },
            { "srn", "sranan tongo" },
            { "srr", "serer\u0161tina" },
            { "ssy", "saho" },
            { "stq", "fr\u00ed\u0161tina (saterlandsk\u00e1)" },
            { "str", "sali\u0161tina (z \u00fa\u017ein)" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumer\u0161tina" },
            { "swb", "komor\u0161tina" },
            { "syc", "syr\u0161tina (klasick\u00e1)" },
            { "syr", "syr\u0161tina" },
            { "szl", "slez\u0161tina" },
            { "tce", "tut\u010don\u0161tina (ji\u017en\u00ed)" },
            { "tcy", "tulu\u0161tina" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "tetum\u0161tina" },
            { "tgx", "tagi\u0161" },
            { "tht", "tahltan" },
            { "tig", "tigrej\u0161tina" },
            { "tiv", "tiv\u0161tina" },
            { "tkl", "tokelau\u0161tina" },
            { "tkr", "cachur\u0161tina" },
            { "tlh", "klingon\u0161tina" },
            { "tli", "tlingit" },
            { "tly", "taly\u0161tina" },
            { "tmh", "tama\u0161ek" },
            { "tog", "ton\u017e\u0161tina (nyasa)" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "tru", "turoj\u0161tina" },
            { "trv", "taroko" },
            { "tsd", "tsakon\u0161tina" },
            { "tsi", "tsim\u0161ijsk\u00e9 jazyky" },
            { "ttm", "tut\u010don\u0161tina (severn\u00ed)" },
            { "ttt", "tat\u0161tina" },
            { "tum", "tumbuk\u0161tina" },
            { "tvl", "tuval\u0161tina" },
            { "twq", "tasawaq" },
            { "tyv", "tuvin\u0161tina" },
            { "tzm", "tamazight (st\u0159edn\u00ed Maroko)" },
            { "udm", "udmurt\u0161tina" },
            { "uga", "ugarit\u0161tina" },
            { "umb", "umbundu" },
            { "und", "nezn\u00e1m\u00fd jazyk" },
            { "vai", metaValue_vai },
            { "vec", "ben\u00e1t\u0161tina" },
            { "vep", "vep\u0161tina" },
            { "vls", "vl\u00e1m\u0161tina (z\u00e1padn\u00ed)" },
            { "vmf", "n\u011bm\u010dina (mohansko-fransk\u00e9 dialekty)" },
            { "vot", "vot\u0161tina" },
            { "vro", "v\u00f5ru\u0161tina" },
            { "vun", "vunjo" },
            { "wae", "n\u011bm\u010dina (walser)" },
            { "wal", "wolajt\u0161tina" },
            { "war", "waraj\u0161tina" },
            { "was", "wa\u0161tina" },
            { "wbp", "warlpiri" },
            { "wuu", "\u010d\u00edn\u0161tina (dialekty Wu)" },
            { "xal", "kalmy\u010dtina" },
            { "xmf", "mingrel\u0161tina" },
            { "xog", "sog\u0161tina" },
            { "yao", "jao\u0161tina" },
            { "yap", "jap\u0161tina" },
            { "yav", "jangben\u0161tina" },
            { "ybb", "yemba" },
            { "yrl", "nheengatu" },
            { "yue", "kanton\u0161tina" },
            { "zap", "zapot\u00e9\u010dtina" },
            { "zbl", "bliss syst\u00e9m" },
            { "zea", "z\u00e9land\u0161tina" },
            { "zen", "zenaga" },
            { "zgh", "tamazight (standardn\u00ed marock\u00fd)" },
            { "zun", "zunij\u0161tina" },
            { "zxx", "\u017e\u00e1dn\u00fd jazykov\u00fd obsah" },
            { "zza", "zaza" },
            { "Adlm", "adlam" },
            { "Afak", "afaka" },
            { "Aghb", "kavkazskoalb\u00e1nsk\u00e9" },
            { "Arab", "arabsk\u00e9" },
            { "Aran", "nastalik" },
            { "Armi", "aramejsk\u00e9 (imperi\u00e1ln\u00ed)" },
            { "Armn", "arm\u00e9nsk\u00e9" },
            { "Avst", "avest\u00e1nsk\u00e9" },
            { "Bali", "balijsk\u00e9" },
            { "Bamu", "bamumsk\u00e9" },
            { "Bass", "bassa vah" },
            { "Batk", "batack\u00e9" },
            { "Beng", "beng\u00e1lsk\u00e9" },
            { "Blis", "Blissovo p\u00edsmo" },
            { "Bopo", "bopomofo" },
            { "Brah", "br\u00e1hm\u00ed" },
            { "Brai", "Braillovo p\u00edsmo" },
            { "Bugi", "buginsk\u00e9" },
            { "Buhd", "buhidsk\u00e9" },
            { "Cakm", metaValue_ccp },
            { "Cans", "slabi\u010dn\u00e9 p\u00edsmo kanadsk\u00fdch domorodc\u016f" },
            { "Cari", "karijsk\u00e9" },
            { "Cham", "\u010dam" },
            { "Cher", "\u010derok\u00ed" },
            { "Cirt", "kirt" },
            { "Copt", "koptsk\u00e9" },
            { "Cprt", "kypersk\u00e9" },
            { "Cyrl", "cyrilice" },
            { "Cyrs", "cyrilce - staroslov\u011bnsk\u00e1" },
            { "Deva", "d\u00e9van\u00e1gar\u00ed" },
            { "Dsrt", "deseret" },
            { "Dupl", "Duploy\u00e9ho t\u011bsnopis" },
            { "Egyd", "egyptsk\u00e9 d\u00e9motick\u00e9" },
            { "Egyh", "egyptsk\u00e9 hieratick\u00e9" },
            { "Egyp", "egyptsk\u00e9 hieroglyfy" },
            { "Elba", "elbasansk\u00e9" },
            { "Ethi", "etiopsk\u00e9" },
            { "Geok", "gruz\u00ednsk\u00e9 chutsuri" },
            { "Geor", "gruz\u00ednsk\u00e9" },
            { "Glag", "hlaholice" },
            { "Gong", "gund\u017eala gond\u00ed" },
            { "Goth", "gotick\u00e9" },
            { "Gran", "grantha" },
            { "Grek", "\u0159eck\u00e9" },
            { "Gujr", "gud\u017ear\u00e1t\u00ed" },
            { "Guru", "gurmukhi" },
            { "Hanb", "hanb" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanun\u00f3o" },
            { "Hans", "zjednodu\u0161en\u00e9" },
            { "Hant", "tradi\u010dn\u00ed" },
            { "Hebr", "hebrejsk\u00e9" },
            { "Hira", "hiragana" },
            { "Hluw", "anatolsk\u00e9 hieroglyfy" },
            { "Hmng", "hmongsk\u00e9" },
            { "Hmnp", "nyiakeng puachue hmong" },
            { "Hrkt", "japonsk\u00e9 slabi\u010dn\u00e9" },
            { "Hung", "staroma\u010farsk\u00e9" },
            { "Inds", "harappsk\u00e9" },
            { "Ital", "etrusk\u00e9" },
            { "Jamo", "jamo" },
            { "Java", "jav\u00e1nsk\u00e9" },
            { "Jpan", "japonsk\u00e9" },
            { "Jurc", "d\u017e\u00fcr\u010densk\u00e9" },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Khar", "kh\u00e1r\u00f3\u0161th\u00ed" },
            { "Khmr", "khmersk\u00e9" },
            { "Khoj", "chod\u017eiki" },
            { "Knda", "kannadsk\u00e9" },
            { "Kore", "korejsk\u00e9" },
            { "Kpel", metaValue_kpe },
            { "Kthi", "kaithi" },
            { "Lana", "lanna" },
            { "Laoo", "laosk\u00e9" },
            { "Latf", "latinka - lomen\u00e1" },
            { "Latg", "latinka - galsk\u00e1" },
            { "Latn", "latinka" },
            { "Lepc", "lep\u010dsk\u00e9" },
            { "Limb", "limbu" },
            { "Lina", "line\u00e1rn\u00ed A" },
            { "Linb", "line\u00e1rn\u00ed B" },
            { "Lisu", "Fraserovo" },
            { "Loma", "loma" },
            { "Lyci", "l\u00fdkijsk\u00e9" },
            { "Lydi", "l\u00fddsk\u00e9" },
            { "Mahj", "mah\u00e1d\u017ean\u00ed" },
            { "Mand", "mandejsk\u00e9" },
            { "Mani", "manichejsk\u00e9" },
            { "Maya", "maysk\u00e9 hieroglyfy" },
            { "Mend", "mendsk\u00e9" },
            { "Merc", "meroitick\u00e9 psac\u00ed" },
            { "Mero", "meroitick\u00e9" },
            { "Mlym", "malajl\u00e1msk\u00e9" },
            { "Modi", "mod\u00ed" },
            { "Mong", "mongolsk\u00e9" },
            { "Moon", "Moonovo p\u00edsmo" },
            { "Mroo", "mro" },
            { "Mtei", "mejtej majek (manipursk\u00e9)" },
            { "Mymr", "myanmarsk\u00e9" },
            { "Narb", "staroseveroarabsk\u00e9" },
            { "Nbat", "nabatejsk\u00e9" },
            { "Nkgb", "naxi geba" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "n\u00fc-\u0161u" },
            { "Ogam", "ogamsk\u00e9" },
            { "Olck", "sant\u00e1lsk\u00e9 (ol chiki)" },
            { "Orkh", "orchonsk\u00e9" },
            { "Orya", "urijsk\u00e9" },
            { "Osma", "osmansk\u00e9" },
            { "Palm", "palm\u00fdrsk\u00e9" },
            { "Pauc", "pau cin hau" },
            { "Perm", "staropermsk\u00e9" },
            { "Phag", "phags-pa" },
            { "Phli", "pahlavsk\u00e9 kl\u00ednov\u00e9" },
            { "Phlp", "pahlavsk\u00e9 \u017ealmov\u00e9" },
            { "Phlv", "pahlavsk\u00e9 kni\u017en\u00ed" },
            { "Phnx", "f\u00e9nick\u00e9" },
            { "Plrd", "Pollardova fonetick\u00e1 abeceda" },
            { "Prti", "parthsk\u00e9 kl\u00ednov\u00e9" },
            { "Qaag", "zawgyi" },
            { "Rjng", "red\u017eansk\u00e9" },
            { "Rohg", "hanifi" },
            { "Roro", "rongorongo" },
            { "Runr", "runov\u00e9" },
            { "Samr", "sama\u0159sk\u00e9" },
            { "Sara", "sarati" },
            { "Sarb", "starojihoarabsk\u00e9" },
            { "Saur", "saur\u00e1\u0161tersk\u00e9" },
            { "Sgnw", "SignWriting" },
            { "Shaw", "Shawova abeceda" },
            { "Shrd", "\u0161\u00e1rad\u00e1" },
            { "Sidd", "siddham" },
            { "Sind", "chud\u00e1b\u00e1d\u00ed" },
            { "Sinh", "sinh\u00e1lsk\u00e9" },
            { "Sora", "sora sompeng" },
            { "Sund", "sundsk\u00e9" },
            { "Sylo", "sylhetsk\u00e9" },
            { "Syrc", "syrsk\u00e9" },
            { "Syre", "syrsk\u00e9 - estrangelo" },
            { "Syrj", "syrsk\u00e9 - z\u00e1padn\u00ed" },
            { "Syrn", "syrsk\u00e9 - v\u00fdchodn\u00ed" },
            { "Tagb", "tagbanwa" },
            { "Takr", "takr\u00ed" },
            { "Tale", "tai le" },
            { "Talu", "tai l\u00fc nov\u00e9" },
            { "Taml", "tamilsk\u00e9" },
            { "Tang", "tangut" },
            { "Tavt", "tai viet" },
            { "Telu", "telugsk\u00e9" },
            { "Teng", "tengwar" },
            { "Tfng", "berbersk\u00e9" },
            { "Tglg", "tagalsk\u00e9" },
            { "Thaa", "thaana" },
            { "Thai", "thajsk\u00e9" },
            { "Tibt", "tibetsk\u00e9" },
            { "Tirh", "tirhuta" },
            { "Ugar", "ugaritsk\u00e9 kl\u00ednov\u00e9" },
            { "Vaii", metaValue_vai },
            { "Visp", "viditeln\u00e1 \u0159e\u010d" },
            { "Wara", "varang k\u0161iti" },
            { "Wole", "karol\u00ednsk\u00e9 (woleai)" },
            { "Xpeo", "staropersk\u00e9 kl\u00ednov\u00e9 p\u00edsmo" },
            { "Xsux", "sumero-akkadsk\u00e9 kl\u00ednov\u00e9 p\u00edsmo" },
            { "Yiii", "yi" },
            { "Zinh", "zd\u011bd\u011bn\u00e9" },
            { "Zmth", "matematick\u00fd z\u00e1pis" },
            { "Zsye", "emod\u017ei" },
            { "Zsym", "symboly" },
            { "Zxxx", "bez z\u00e1pisu" },
            { "Zyyy", "obecn\u00e9" },
            { "Zzzz", "nezn\u00e1m\u00e9 p\u00edsmo" },
            { "de_CH", "n\u011bm\u010dina standardn\u00ed (\u0160v\u00fdcarsko)" },
            { "en_GB", "angli\u010dtina (Velk\u00e1 Brit\u00e1nie)" },
            { "en_US", "angli\u010dtina (USA)" },
            { "es_ES", "\u0161pan\u011bl\u0161tina (Evropa)" },
            { "fa_AF", "dar\u00ed" },
            { "nl_BE", "vl\u00e1m\u0161tina" },
            { "pt_PT", "portugal\u0161tina (Evropa)" },
            { "ro_MD", "moldav\u0161tina" },
            { "sw_CD", "svahil\u0161tina (Kongo)" },
            { "ar_001", "arab\u0161tina (modern\u00ed standardn\u00ed)" },
            { "key.ca", "Kalend\u00e1\u0159" },
            { "key.cf", "M\u011bnov\u00fd form\u00e1t" },
            { "key.co", "\u0158azen\u00ed" },
            { "key.cu", "M\u011bna" },
            { "key.hc", "Hodinov\u00fd cyklus (12 vs. 24)" },
            { "key.lb", "Styl zalamov\u00e1n\u00ed \u0159\u00e1dk\u016f" },
            { "key.ms", "M\u011brn\u00e1 soustava" },
            { "key.nu", "\u010c\u00edsla" },
            { "key.tz", "\u010casov\u00e9 p\u00e1smo" },
            { "key.va", "Varianta n\u00e1rodn\u00edho prost\u0159ed\u00ed" },
            { "nds_NL", "dolnosa\u0161tina" },
            { "zh_Hans", "\u010d\u00edn\u0161tina (zjednodu\u0161en\u00e1)" },
            { "%%SCOTLAND", "angli\u010dtina (Skotsko)" },
            { "%%WADEGILE", "Wade-Giles" },
            { "type.ca.roc", "Kalend\u00e1\u0159 \u010c\u00ednsk\u00e9 republiky" },
            { "type.co.eor", "Evropsk\u00e9 \u0159azen\u00ed" },
            { "type.hc.h11", "12hodinov\u00fd syst\u00e9m (0\u201311)" },
            { "type.hc.h12", "12hodinov\u00fd syst\u00e9m (1\u201312)" },
            { "type.hc.h23", "24hodinov\u00fd syst\u00e9m (0\u201323)" },
            { "type.hc.h24", "24hodinov\u00fd syst\u00e9m (1\u201324)" },
            { "type.m0.bgn", "Transliterace podle BGN" },
            { "type.nu.arab", "Arabsko-indick\u00e9 \u010d\u00edslice" },
            { "type.nu.armn", "Arm\u00e9nsk\u00e9 \u010d\u00edslice" },
            { "type.nu.bali", "Balijsk\u00e9 \u010d\u00edslice" },
            { "type.nu.beng", "Beng\u00e1lsk\u00e9 \u010d\u00edslice" },
            { "type.nu.cakm", "\u010cakmsk\u00e9 \u010d\u00edslice" },
            { "type.nu.deva", "\u010c\u00edslice p\u00edsma d\u00e9van\u00e1gar\u00ed" },
            { "type.nu.ethi", "Etiopsk\u00e9 \u010d\u00edslice" },
            { "type.nu.geor", "Gruz\u00ednsk\u00e9 \u010d\u00edslice" },
            { "type.nu.grek", "\u0158eck\u00e9 \u010d\u00edslice" },
            { "type.nu.gujr", "Gud\u017ear\u00e1tsk\u00e9 \u010d\u00edslice" },
            { "type.nu.guru", "\u010c\u00edslice gurmukh\u00ed" },
            { "type.nu.hans", "\u010c\u00edslice zjednodu\u0161en\u00e9 \u010d\u00edn\u0161tiny" },
            { "type.nu.hant", "\u010c\u00edslice tradi\u010dn\u00ed \u010d\u00edn\u0161tiny" },
            { "type.nu.hebr", "Hebrejsk\u00e9 \u010d\u00edslice" },
            { "type.nu.java", "Jav\u00e1nsk\u00e9 \u010d\u00edslice" },
            { "type.nu.jpan", "Japonsk\u00e9 \u010d\u00edslice" },
            { "type.nu.khmr", "Khmersk\u00e9 \u010d\u00edslice" },
            { "type.nu.knda", "Kannadsk\u00e9 \u010d\u00edslice" },
            { "type.nu.laoo", "Laosk\u00e9 \u010d\u00edslice" },
            { "type.nu.latn", "Z\u00e1padn\u00ed \u010d\u00edslice" },
            { "type.nu.mlym", "Malaj\u00e1lamsk\u00e9 \u010d\u00edslice" },
            { "type.nu.mong", "Mongolsk\u00e9 \u010d\u00edslice" },
            { "type.nu.mtei", "Manipursk\u00e9 \u010d\u00edslice" },
            { "type.nu.mymr", "Myanmarsk\u00e9 \u010d\u00edslice" },
            { "type.nu.olck", "Sant\u00e1lsk\u00e9 \u010d\u00edslice" },
            { "type.nu.orya", "Urijsk\u00e9 \u010d\u00edslice" },
            { "type.nu.osma", "Som\u00e1lsk\u00e9 \u010d\u00edslice" },
            { "type.nu.saur", "Saur\u00e1\u0161tersk\u00e9 \u010d\u00edslice" },
            { "type.nu.sund", "Sundsk\u00e9 \u010d\u00edslice" },
            { "type.nu.taml", "Tamilsk\u00e9 tradi\u010dn\u00ed \u010d\u00edslice" },
            { "type.nu.telu", "Telugsk\u00e9 \u010d\u00edslice" },
            { "type.nu.thai", "Thajsk\u00e9 \u010d\u00edslice" },
            { "type.nu.tibt", "Tibetsk\u00e9 \u010d\u00edslice" },
            { "type.nu.vaii", "Vaisk\u00e9 \u010d\u00edslice" },
            { "type.ca.dangi", "Korejsk\u00fd kalend\u00e1\u0159 Dangi" },
            { "type.co.ducet", "V\u00fdchoz\u00ed \u0159azen\u00ed Unicode" },
            { "type.lb.loose", "Voln\u00fd styl zalamov\u00e1n\u00ed \u0159\u00e1dk\u016f" },
            { "type.nu.roman", "\u0158\u00edmsk\u00e9 \u010d\u00edslice" },
            { "type.ca.coptic", "Koptsk\u00fd kalend\u00e1\u0159" },
            { "type.ca.hebrew", "Hebrejsk\u00fd kalend\u00e1\u0159" },
            { "type.ca.indian", "Indick\u00fd n\u00e1rodn\u00ed kalend\u00e1\u0159" },
            { "type.co.compat", "P\u0159edchoz\u00ed \u0159azen\u00ed, kompatibilita" },
            { "type.co.pinyin", "\u0158azen\u00ed podle pchin-jinu" },
            { "type.co.search", "Obecn\u00e9 hled\u00e1n\u00ed" },
            { "type.co.stroke", "\u0158azen\u00ed podle tah\u016f" },
            { "type.co.unihan", "\u0158azen\u00ed podle radik\u00e1l\u016f" },
            { "type.co.zhuyin", "\u0158azen\u00ed podle \u010du-jinu" },
            { "type.d0.fwidth", "Pln\u00e1 \u0161\u00ed\u0159ka" },
            { "type.d0.hwidth", "Polovi\u010dn\u00ed \u0161\u00ed\u0159ka" },
            { "type.lb.normal", "B\u011b\u017en\u00fd styl zalamov\u00e1n\u00ed \u0159\u00e1dk\u016f" },
            { "type.lb.strict", "Striktn\u00ed styl zalamov\u00e1n\u00ed \u0159\u00e1dk\u016f" },
            { "type.m0.ungegn", "Transliterace podle UNGEGN" },
            { "type.ms.metric", "Metrick\u00e1 soustava" },
            { "type.nu.native", "Nativn\u00ed \u010d\u00edslice" },
            { "type.ca.chinese", "\u010c\u00ednsk\u00fd kalend\u00e1\u0159" },
            { "type.ca.islamic", "Kalend\u00e1\u0159 podle hid\u017ery" },
            { "type.ca.iso8601", "Kalend\u00e1\u0159 ISO-8601" },
            { "type.ca.persian", "Persk\u00fd kalend\u00e1\u0159" },
            { "type.cf.account", "\u00da\u010detn\u00ed m\u011bnov\u00fd form\u00e1t" },
            { "type.co.big5han", "\u0158azen\u00ed pro tradi\u010dn\u00ed \u010d\u00edn\u0161tinu \u2013 Big5" },
            { "type.d0.npinyin", "Numerick\u00fd" },
            { "type.nu.arabext", "Roz\u0161\u00ed\u0159en\u00e9 arabsko-indick\u00e9 \u010d\u00edslice" },
            { "type.nu.armnlow", "Mal\u00e9 arm\u00e9nsk\u00e9 \u010d\u00edslice" },
            { "type.nu.finance", "Finan\u010dn\u00ed z\u00e1pis \u010d\u00edsel" },
            { "type.nu.greklow", "Mal\u00e9 \u0159eck\u00e9 \u010d\u00edslice" },
            { "type.nu.hanidec", "\u010c\u00ednsk\u00e9 des\u00edtkov\u00e9 \u010d\u00edslice" },
            { "type.nu.hansfin", "Finan\u010dn\u00ed \u010d\u00edslice zjednodu\u0161en\u00e9 \u010d\u00edn\u0161tiny" },
            { "type.nu.hantfin", "Finan\u010dn\u00ed \u010d\u00edslice tradi\u010dn\u00ed \u010d\u00edn\u0161tiny" },
            { "type.nu.jpanfin", "Japonsk\u00e9 finan\u010dn\u00ed \u010d\u00edslice" },
            { "type.nu.tamldec", "Tamilsk\u00e9 \u010d\u00edslice" },
            { "type.ca.buddhist", "Buddhistick\u00fd kalend\u00e1\u0159" },
            { "type.ca.ethiopic", "Etiopsk\u00fd kalend\u00e1\u0159" },
            { "type.ca.japanese", "Japonsk\u00fd kalend\u00e1\u0159" },
            { "type.cf.standard", "Standardn\u00ed m\u011bnov\u00fd form\u00e1t" },
            { "type.co.phonetic", "Fonetick\u00e9 \u0159azen\u00ed" },
            { "type.co.reformed", "Reformovan\u00e9 \u0159azen\u00ed" },
            { "type.co.searchjl", "Vyhled\u00e1vat podle po\u010d\u00e1te\u010dn\u00ed souhl\u00e1sky p\u00edsma hangul" },
            { "type.co.standard", "Standardn\u00ed \u0159azen\u00ed" },
            { "type.ms.uksystem", "Britsk\u00e1 m\u011brn\u00e1 soustava" },
            { "type.ms.ussystem", "Americk\u00e1 m\u011brn\u00e1 soustava" },
            { "type.nu.fullwide", "\u010c\u00edslice \u2013 pln\u00e1 \u0161\u00ed\u0159ka" },
            { "type.nu.romanlow", "Mal\u00e9 \u0159\u00edmsk\u00e9 \u010d\u00edslice" },
            { "type.ca.gregorian", "Gregori\u00e1nsk\u00fd kalend\u00e1\u0159" },
            { "type.co.gb2312han", "\u0158azen\u00ed pro zjednodu\u0161enou \u010d\u00edn\u0161tinu \u2013 GB2312" },
            { "type.co.phonebook", "\u0158azen\u00ed telefonn\u00edho seznamu" },
            { "type.co.dictionary", "Slovn\u00edkov\u00e9 \u0159azen\u00ed" },
            { "type.co.traditional", "Tradi\u010dn\u00ed \u0159azen\u00ed" },
            { "type.nu.traditional", "Tradi\u010dn\u00ed \u010d\u00edslovky" },
            { "type.ca.islamic-civil", "Kalend\u00e1\u0159 podle hid\u017ery (ob\u010dansk\u00fd)" },
            { "type.ca.islamic-umalqura", "Kalend\u00e1\u0159 podle hid\u017ery (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Etiopsk\u00fd kalend\u00e1\u0159 (amete alem)" },
        };
        return data;
    }
}
