/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ig extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Oge Mpaghara Greemwich Mean",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Oge Izugbe Apia",
               "",
               "Oge Ihe Apia",
               "",
               "Oge Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Oge Izugbe Cook Islands",
               "",
               "Oge \u1ecckara Okpom\u1ecdk\u1ee5 Cook Islands",
               "",
               "Oge Cook Islands",
               "",
            };
        final String[] Cuba = new String[] {
               "Oge Izugbe Cuba",
               "CST",
               "Oge Ihe Mpaghara Cuba",
               "CDT",
               "Oge Cuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Oge Izugbe Fiji",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Fiji",
               "",
               "Oge Fiji",
               "",
            };
        final String[] Gulf = new String[] {
               "Oge Izugbe Gulf",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Oge Izugbe Hovd",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Hovd",
               "",
               "Oge Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Oge Izugbe Iran",
               "",
               "Oge Ihe Iran",
               "",
               "Oge Iran",
               "",
            };
        final String[] Niue = new String[] {
               "Oge Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Oge Izugbe Omsk",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Omsk",
               "",
               "Oge Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Oge Izugbe Peru",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Peru",
               "",
               "Oge Peru",
               "",
            };
        final String[] Truk = new String[] {
               "Oge Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Oge Wake Island",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Oge Izugbe Chile",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Chile",
               "",
               "Oge Chile",
               "",
            };
        final String[] China = new String[] {
               "Oge Izugbe China",
               "CST",
               "Oge Ihe China",
               "CDT",
               "Oge China",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Oge Cocos Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Oge Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Oge Izugbe India",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Oge Izugbe Japan",
               "JST",
               "Oge Ihe Japan",
               "JDT",
               "Oge Japan",
               "JT",
            };
        final String[] Korea = new String[] {
               "Oge Izugbe Korea",
               "KST",
               "Oge Ihe Korea",
               "KST",
               "Oge Korea",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Oge Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Oge Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Oge Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Oge Izugbe Samoa",
               "SST",
               "Oge Ihe Samoa",
               "SST",
               "Oge Samoa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Oge Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Oge Izugbe Tonga",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Tonga",
               "",
               "Oge Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Oge Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Oge Izugbe Alaska",
               "AKST",
               "Oge Ihe Alaska",
               "AKDT",
               "Oge Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Oge Izugbe Amazon",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Amazon",
               "",
               "Oge Amazon",
               "",
            };
        final String[] Azores = new String[] {
               "Oge Izugbe Azores",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Azores",
               "",
               "Oge Azores",
               "",
            };
        final String[] Bhutan = new String[] {
               "Oge Bhutan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Oge Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Oge Izugbe Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Island",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Island",
               "",
               "Oge Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Island",
               "",
            };
        final String[] Guyana = new String[] {
               "Oge Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Oge Izugbe Israel",
               "IST",
               "Oge Ihe Israel",
               "IDT",
               "Oge Israel",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Oge Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Oge Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Oge Izugbe Moscow",
               "MSK",
               "Oge Okpom\u1ecdk\u1ee5 Moscow",
               "MSK",
               "Oge Moscow",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Oge Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Oge Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Oge Izugbe Taipei",
               "CST",
               "Oge Ihe Taipei",
               "CDT",
               "Oge Taipei",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Oge Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Oge Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Oge Wallis & Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Oge Izugbe Arab",
               "",
               "Oge Ihe Arab",
               "",
               "Oge Arab",
               "",
            };
        final String[] Armenia = new String[] {
               "Oge Izugbe Armenia",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Armenia",
               "",
               "Oge Armenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Oge Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Oge Izugbe Chatham",
               "",
               "Oge Ihe Chatham",
               "",
               "Oge Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Nhazi Oge \u1ee4wa Niile",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Oge Ecuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Oge Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Oge Izugbe Georgia",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Georgia",
               "",
               "Oge Georgia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Oge Izugbe Irkutsk",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Irkutsk",
               "",
               "Oge Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Oge Izugbe Magadan",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Magadan",
               "",
               "Oge Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Oge Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Oge Izugbe Norfolk Island",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Norfolk Island",
               "",
               "Oge Norfolk Island",
               "",
            };
        final String[] Noronha = new String[] {
               "Oge Izugbe Fernando de Noronha",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Fernando de Noronha",
               "",
               "Oge Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Oge R\u00e9union",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Oge Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Oge Solomon Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Oge Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Oge Izugbe Uruguay",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Uruguay",
               "",
               "Oge Uruguay",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Oge Izugbe Vanuatu",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Vanuatu",
               "",
               "Oge Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Oge Izugbe Yakutsk",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Yakutsk",
               "",
               "Oge Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Oge Izugbe Mpaghara Atlantic",
               "AST",
               "Oge Ihe Mpaghara Atlantic",
               "ADT",
               "Oge Mpaghara Atlantic",
               "AT",
            };
        final String[] Brasilia = new String[] {
               "Oge Izugbe Brasilia",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Brasilia",
               "",
               "Oge Brasilia",
               "",
            };
        final String[] Chamorro = new String[] {
               "Oge Izugbe Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Oge Izugbe Columbia",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Columbia",
               "",
               "Oge Columbia",
               "",
            };
        final String[] Falkland = new String[] {
               "Oge Izugbe Falkland Islands",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Falkland Islands",
               "",
               "Oge Falkland Islands",
               "",
            };
        final String[] Malaysia = new String[] {
               "Oge Malaysia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Oge Maldives",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Oge Izugbe Ulaanbaatar",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Ulaanbaatar",
               "",
               "Oge Ulaanbaatar",
               "",
            };
        final String[] Pakistan = new String[] {
               "Oge Izugbe Pakistan",
               "PKT",
               "Oge Okpom\u1ecdk\u1ee5 Pakistan",
               "PKST",
               "Oge Pakistan",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Oge Izugbe Paraguay",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Paraguay",
               "",
               "Oge Paraguay",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Oge Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Oge Izugbe Sakhalin",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Sakhalin",
               "",
               "Oge Sakhalin",
               "",
            };
        final String[] Suriname = new String[] {
               "Oge Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Oge Izugbe Argentina",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Argentina",
               "",
               "Oge Argentina",
               "",
            };
        final String[] Christmas = new String[] {
               "Oge Ekeresimesi Island",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Oge Galapagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Oge Izugbe Hong Kong",
               "HKT",
               "Oge Okpom\u1ecdk\u1ee5 Hong Kong",
               "HKST",
               "Oge Hong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Oge Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Oge Kyrgyzstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Oge Izugbe Lord Howe",
               "",
               "Oge Ihe Lord Howe",
               "",
               "Oge Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Oge Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Oge Izugbe Mauritius",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Mauritius",
               "",
               "Oge Mauritius",
               "",
            };
        final String[] Singapore = new String[] {
               "Oge Izugbe Singapore",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Oge Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Oge Izugbe Volgograd",
               "MSK",
               "Oge Okpom\u1ecdk\u1ee5 Volgograd",
               "MSK",
               "Oge Volgograd",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Oge Izugbe Azerbaijan",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Azerbaijan",
               "",
               "Oge Azerbaijan",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Oge Izugbe Bangladesh",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Bangladesh",
               "",
               "Oge Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Oge Izugbe Cape Verde",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Cape Verde",
               "",
               "Oge Cape Verde",
               "",
            };
        final String[] East_Timor = new String[] {
               "Oge Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Timor",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Oge Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Oge Tajikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Oge Izugbe Uzbekist",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Uzbekist",
               "",
               "Oge Uzbekist",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Oge Afghanistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Oge Izugbe Krasnoyarsk",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Krasnoyarsk",
               "",
               "Oge Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Oge Izugbe New Zealand",
               "NZST",
               "Oge Ihe New Zealand",
               "NZDT",
               "Oge New Zealand",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Oge Izugbe Novosibirsk",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Novosibirsk",
               "",
               "Oge Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Oge Izugbe Philippine",
               "PST",
               "Oge Okpom\u1ecdk\u1ee5 Philippine",
               "PDT",
               "Oge Philippine",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Oge Izugbe Vladivostok",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Vladivostok",
               "",
               "Oge Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Oge Osimiri India",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Oge Line Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Oge Izugbe Newfoundland",
               "NST",
               "Oge Ihe Newfoundland",
               "NDT",
               "Oge Newfoundland",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Oge Izugbe Turkmenist",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Turkmenist",
               "",
               "Oge Turkmenist",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Oge French Guiana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Oge Izugbe New Caledonia",
               "",
               "Oge Okpom\u1ecdk\u1ee5 New Caledonia",
               "",
               "Oge New Caledonia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Oge South Georgia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Oge Izugbe Yekaterinburg",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Yekaterinburg",
               "",
               "Oge Yekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Oge Etiti Afr\u1ecbka",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Oge Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Afr\u1ecbka",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Oge Izugbe Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Afr\u1ecbka",
               "WAT",
               "Oge Okpom\u1ecdk\u1ee5 Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Afr\u1ecbka",
               "WAT",
               "Oge Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Afr\u1ecbka",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Oge Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Oge Izugbe Mpaghara Etiti Europe",
               "CET",
               "Oge Okpom\u1ecdk\u1ee5 Mpaghara Etiti Europe",
               "CEST",
               "Oge Mpaghara Etiti Europe",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Oge Izugbe Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Europe",
               "EET",
               "Oge Okpom\u1ecdk\u1ee5 Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Europe",
               "EEST",
               "Oge Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Europe",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Oge Izugbe Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Europe",
               "WET",
               "Oge Okpom\u1ecdk\u1ee5 Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Europe",
               "WEST",
               "Oge Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Europe",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Oge Izugbe Mexican Pacific",
               "MST",
               "Oge Ihe Mexican Pacific",
               "MDT",
               "Oge Mexican Pacific",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Oge Izugbe Mpaghara Mgbada Ugwu Afr\u1ecbka",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Oge Izugbe Mpaghara Etiti",
               "CST",
               "Oge Ihe Mpaghara Etiti",
               "CDT",
               "Oge Mpaghara Etiti",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Oge Izugbe Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5",
               "EST",
               "Oge Ihe Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5",
               "EST",
               "Oge Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Oge Izugbe Mpaghara Pacific",
               "PST",
               "Oge Ihe Mpaghara Pacific",
               "PDT",
               "Oge Mpaghara Pacific",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Oge French Southern & Antarctic",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Oge Gilbert Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Oge Izugbe Hawaii-Aleutian",
               "HST",
               "Oge Ihe Hawaii-Aleutian",
               "HST",
               "Oge Hawaii-Aleutian",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Oge Phoenix Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Oge Izugbe St. Pierre & Miquelon",
               "",
               "Oge Ihe St. Pierre & Miquelon",
               "",
               "Oge St. Pierre & Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Oge Izugbe Mpaghara Ugwu",
               "MST",
               "Oge Ihe Mpaghara Ugwu",
               "MST",
               "Oge Mpaghara Ugwu",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Oge Marshall Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Oge Izugbe Northwest Mexico",
               "",
               "Oge Ihe Northwest Mexico",
               "",
               "Oge Northwest Mexico",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Oge Papua New Guinea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Oge Izugbe Etiti Australia",
               "ACST",
               "Oge Ihe Etiti Australia",
               "ACDT",
               "Oge Etiti Australia",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Oge Izugbe Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Australia",
               "AEST",
               "Oge Ihe Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Australia",
               "AEDT",
               "Oge Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Australia",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Oge Izugbe Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Australia",
               "AWST",
               "Oge Ihe Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Australia",
               "AWDT",
               "Oge Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Australia",
               "AWT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Oge Izugbe Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Greenland",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Greenland",
               "",
               "Oge Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Greenland",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Oge Izugbe Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Greenland",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Greenland",
               "",
               "Oge Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Greenland",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Oge Etiti Indonesia",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Oge Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Indonesia",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Oge Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Indonesia",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Oge Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Oge Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Oge Izugbe Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Etiti Australia",
               "",
               "Oge Ihe Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Etiti Australia",
               "",
               "Oge Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Etiti Australia",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Truk },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Oge Mpaghara Greemwich Mean",
                    "GMT",
                    "Oge Okpom\u1ecdk\u1ee5 Ireland",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Oge Mpaghara Greemwich Mean",
                    "GMT",
                    "Oge Okpom\u1ecdk\u1ee5 Britain",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Oge Mpaghara Greemwich Mean",
                    "GMT",
                    "Oge Okpom\u1ecdk\u1ee5 Britain",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Ponape },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Etc/Unknown", "Obodo Amagh\u1ecb" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
        };
        return data;
    }
}
