/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.xslf;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.sl.usermodel.TableCell;
import org.apache.poi.sl.usermodel.TextParagraph;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFTable;
import org.apache.poi.xslf.usermodel.XSLFTableCell;
import org.apache.poi.xslf.usermodel.XSLFTableRow;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.apache.poi.xslf.usermodel.XSLFTextRun;

public final class Tutorial4 {
    private Tutorial4() {
    }

    public static void main(String[] args) throws IOException {
        try (XMLSlideShow ppt = new XMLSlideShow();){
            XSLFSlide slide = ppt.createSlide();
            XSLFTable tbl = slide.createTable();
            tbl.setAnchor((Rectangle2D)new Rectangle(50, 50, 450, 300));
            int numColumns = 3;
            int numRows = 5;
            XSLFTableRow headerRow = tbl.addRow();
            headerRow.setHeight(50.0);
            for (int i = 0; i < numColumns; ++i) {
                XSLFTableCell th = headerRow.addCell();
                XSLFTextParagraph p = th.addNewTextParagraph();
                p.setTextAlign(TextParagraph.TextAlign.CENTER);
                XSLFTextRun r = p.addNewTextRun();
                r.setText("Header " + (i + 1));
                r.setBold(true);
                r.setFontColor(Color.white);
                th.setFillColor(new Color(79, 129, 189));
                th.setBorderWidth(TableCell.BorderEdge.bottom, 2.0);
                th.setBorderColor(TableCell.BorderEdge.bottom, Color.white);
                tbl.setColumnWidth(i, 150.0);
            }
            for (int rownum = 0; rownum < numRows; ++rownum) {
                XSLFTableRow tr = tbl.addRow();
                tr.setHeight(50.0);
                for (int i = 0; i < numColumns; ++i) {
                    XSLFTableCell cell = tr.addCell();
                    XSLFTextParagraph p = cell.addNewTextParagraph();
                    XSLFTextRun r = p.addNewTextRun();
                    r.setText("Cell " + (i + 1));
                    if (rownum % 2 == 0) {
                        cell.setFillColor(new Color(208, 216, 232));
                        continue;
                    }
                    cell.setFillColor(new Color(233, 247, 244));
                }
            }
            try (FileOutputStream out = new FileOutputStream("table.pptx");){
                ppt.write((OutputStream)out);
            }
        }
    }
}

