#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtWidgets, except for defaults which are replaced by "...".
"""

# Module PySide2.QtWidgets
import PySide2
try:
    import typing
except ImportError:
    from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

from shiboken2 import Shiboken

import PySide2.QtCore
import PySide2.QtGui
import PySide2.QtWidgets


class QAbstractButton(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def animateClick(self, msec: int = ...) -> None: ...
    def autoExclusive(self) -> bool: ...
    def autoRepeat(self) -> bool: ...
    def autoRepeatDelay(self) -> int: ...
    def autoRepeatInterval(self) -> int: ...
    def changeEvent(self, e: PySide2.QtCore.QEvent) -> None: ...
    def checkStateSet(self) -> None: ...
    def click(self) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, e: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, e: PySide2.QtGui.QFocusEvent) -> None: ...
    def group(self) -> PySide2.QtWidgets.QButtonGroup: ...
    def hitButton(self, pos: PySide2.QtCore.QPoint) -> bool: ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    def iconSize(self) -> PySide2.QtCore.QSize: ...
    def isCheckable(self) -> bool: ...
    def isChecked(self) -> bool: ...
    def isDown(self) -> bool: ...
    def keyPressEvent(self, e: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, e: PySide2.QtGui.QKeyEvent) -> None: ...
    def mouseMoveEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def nextCheckState(self) -> None: ...
    def paintEvent(self, e: PySide2.QtGui.QPaintEvent) -> None: ...
    def setAutoExclusive(self, arg__1: bool) -> None: ...
    def setAutoRepeat(self, arg__1: bool) -> None: ...
    def setAutoRepeatDelay(self, arg__1: int) -> None: ...
    def setAutoRepeatInterval(self, arg__1: int) -> None: ...
    def setCheckable(self, arg__1: bool) -> None: ...
    def setChecked(self, arg__1: bool) -> None: ...
    def setDown(self, arg__1: bool) -> None: ...
    def setIcon(self, icon: PySide2.QtGui.QIcon) -> None: ...
    def setIconSize(self, size: PySide2.QtCore.QSize) -> None: ...
    def setShortcut(self, key: PySide2.QtGui.QKeySequence) -> None: ...
    def setText(self, text: str) -> None: ...
    def shortcut(self) -> PySide2.QtGui.QKeySequence: ...
    def text(self) -> str: ...
    def timerEvent(self, e: PySide2.QtCore.QTimerEvent) -> None: ...
    def toggle(self) -> None: ...


class QAbstractGraphicsShapeItem(PySide2.QtWidgets.QGraphicsItem):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...

    def brush(self) -> PySide2.QtGui.QBrush: ...
    def isObscuredBy(self, item: PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def pen(self) -> PySide2.QtGui.QPen: ...
    def setBrush(self, brush: PySide2.QtGui.QBrush) -> None: ...
    def setPen(self, pen: PySide2.QtGui.QPen) -> None: ...


class QAbstractItemDelegate(PySide2.QtCore.QObject):
    NoHint                   : QAbstractItemDelegate.EndEditHint = ... # 0x0
    EditNextItem             : QAbstractItemDelegate.EndEditHint = ... # 0x1
    EditPreviousItem         : QAbstractItemDelegate.EndEditHint = ... # 0x2
    SubmitModelCache         : QAbstractItemDelegate.EndEditHint = ... # 0x3
    RevertModelCache         : QAbstractItemDelegate.EndEditHint = ... # 0x4

    class EndEditHint(Shiboken.Enum):
        NoHint                   : QAbstractItemDelegate.EndEditHint = ... # 0x0
        EditNextItem             : QAbstractItemDelegate.EndEditHint = ... # 0x1
        EditPreviousItem         : QAbstractItemDelegate.EndEditHint = ... # 0x2
        SubmitModelCache         : QAbstractItemDelegate.EndEditHint = ... # 0x3
        RevertModelCache         : QAbstractItemDelegate.EndEditHint = ... # 0x4

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def createEditor(self, parent: PySide2.QtWidgets.QWidget, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QWidget: ...
    def destroyEditor(self, editor: PySide2.QtWidgets.QWidget, index: PySide2.QtCore.QModelIndex) -> None: ...
    def editorEvent(self, event: PySide2.QtCore.QEvent, model: PySide2.QtCore.QAbstractItemModel, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> bool: ...
    @staticmethod
    def elidedText(fontMetrics: PySide2.QtGui.QFontMetrics, width: int, mode: PySide2.QtCore.Qt.TextElideMode, text: str) -> str: ...
    def helpEvent(self, event: PySide2.QtGui.QHelpEvent, view: PySide2.QtWidgets.QAbstractItemView, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> None: ...
    def paintingRoles(self) -> typing.List[int]: ...
    def setEditorData(self, editor: PySide2.QtWidgets.QWidget, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setModelData(self, editor: PySide2.QtWidgets.QWidget, model: PySide2.QtCore.QAbstractItemModel, index: PySide2.QtCore.QModelIndex) -> None: ...
    def sizeHint(self, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QSize: ...
    def updateEditorGeometry(self, editor: PySide2.QtWidgets.QWidget, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> None: ...


class QAbstractItemView(PySide2.QtWidgets.QAbstractScrollArea):
    MoveUp                   : QAbstractItemView.CursorAction = ... # 0x0
    MoveDown                 : QAbstractItemView.CursorAction = ... # 0x1
    MoveLeft                 : QAbstractItemView.CursorAction = ... # 0x2
    MoveRight                : QAbstractItemView.CursorAction = ... # 0x3
    MoveHome                 : QAbstractItemView.CursorAction = ... # 0x4
    MoveEnd                  : QAbstractItemView.CursorAction = ... # 0x5
    MovePageUp               : QAbstractItemView.CursorAction = ... # 0x6
    MovePageDown             : QAbstractItemView.CursorAction = ... # 0x7
    MoveNext                 : QAbstractItemView.CursorAction = ... # 0x8
    MovePrevious             : QAbstractItemView.CursorAction = ... # 0x9
    NoDragDrop               : QAbstractItemView.DragDropMode = ... # 0x0
    DragOnly                 : QAbstractItemView.DragDropMode = ... # 0x1
    DropOnly                 : QAbstractItemView.DragDropMode = ... # 0x2
    DragDrop                 : QAbstractItemView.DragDropMode = ... # 0x3
    InternalMove             : QAbstractItemView.DragDropMode = ... # 0x4
    OnItem                   : QAbstractItemView.DropIndicatorPosition = ... # 0x0
    AboveItem                : QAbstractItemView.DropIndicatorPosition = ... # 0x1
    BelowItem                : QAbstractItemView.DropIndicatorPosition = ... # 0x2
    OnViewport               : QAbstractItemView.DropIndicatorPosition = ... # 0x3
    NoEditTriggers           : QAbstractItemView.EditTrigger = ... # 0x0
    CurrentChanged           : QAbstractItemView.EditTrigger = ... # 0x1
    DoubleClicked            : QAbstractItemView.EditTrigger = ... # 0x2
    SelectedClicked          : QAbstractItemView.EditTrigger = ... # 0x4
    EditKeyPressed           : QAbstractItemView.EditTrigger = ... # 0x8
    AnyKeyPressed            : QAbstractItemView.EditTrigger = ... # 0x10
    AllEditTriggers          : QAbstractItemView.EditTrigger = ... # 0x1f
    EnsureVisible            : QAbstractItemView.ScrollHint = ... # 0x0
    PositionAtTop            : QAbstractItemView.ScrollHint = ... # 0x1
    PositionAtBottom         : QAbstractItemView.ScrollHint = ... # 0x2
    PositionAtCenter         : QAbstractItemView.ScrollHint = ... # 0x3
    ScrollPerItem            : QAbstractItemView.ScrollMode = ... # 0x0
    ScrollPerPixel           : QAbstractItemView.ScrollMode = ... # 0x1
    SelectItems              : QAbstractItemView.SelectionBehavior = ... # 0x0
    SelectRows               : QAbstractItemView.SelectionBehavior = ... # 0x1
    SelectColumns            : QAbstractItemView.SelectionBehavior = ... # 0x2
    NoSelection              : QAbstractItemView.SelectionMode = ... # 0x0
    SingleSelection          : QAbstractItemView.SelectionMode = ... # 0x1
    MultiSelection           : QAbstractItemView.SelectionMode = ... # 0x2
    ExtendedSelection        : QAbstractItemView.SelectionMode = ... # 0x3
    ContiguousSelection      : QAbstractItemView.SelectionMode = ... # 0x4
    NoState                  : QAbstractItemView.State = ... # 0x0
    DraggingState            : QAbstractItemView.State = ... # 0x1
    DragSelectingState       : QAbstractItemView.State = ... # 0x2
    EditingState             : QAbstractItemView.State = ... # 0x3
    ExpandingState           : QAbstractItemView.State = ... # 0x4
    CollapsingState          : QAbstractItemView.State = ... # 0x5
    AnimatingState           : QAbstractItemView.State = ... # 0x6

    class CursorAction(Shiboken.Enum):
        MoveUp                   : QAbstractItemView.CursorAction = ... # 0x0
        MoveDown                 : QAbstractItemView.CursorAction = ... # 0x1
        MoveLeft                 : QAbstractItemView.CursorAction = ... # 0x2
        MoveRight                : QAbstractItemView.CursorAction = ... # 0x3
        MoveHome                 : QAbstractItemView.CursorAction = ... # 0x4
        MoveEnd                  : QAbstractItemView.CursorAction = ... # 0x5
        MovePageUp               : QAbstractItemView.CursorAction = ... # 0x6
        MovePageDown             : QAbstractItemView.CursorAction = ... # 0x7
        MoveNext                 : QAbstractItemView.CursorAction = ... # 0x8
        MovePrevious             : QAbstractItemView.CursorAction = ... # 0x9

    class DragDropMode(Shiboken.Enum):
        NoDragDrop               : QAbstractItemView.DragDropMode = ... # 0x0
        DragOnly                 : QAbstractItemView.DragDropMode = ... # 0x1
        DropOnly                 : QAbstractItemView.DragDropMode = ... # 0x2
        DragDrop                 : QAbstractItemView.DragDropMode = ... # 0x3
        InternalMove             : QAbstractItemView.DragDropMode = ... # 0x4

    class DropIndicatorPosition(Shiboken.Enum):
        OnItem                   : QAbstractItemView.DropIndicatorPosition = ... # 0x0
        AboveItem                : QAbstractItemView.DropIndicatorPosition = ... # 0x1
        BelowItem                : QAbstractItemView.DropIndicatorPosition = ... # 0x2
        OnViewport               : QAbstractItemView.DropIndicatorPosition = ... # 0x3

    class EditTrigger(Shiboken.Enum):
        NoEditTriggers           : QAbstractItemView.EditTrigger = ... # 0x0
        CurrentChanged           : QAbstractItemView.EditTrigger = ... # 0x1
        DoubleClicked            : QAbstractItemView.EditTrigger = ... # 0x2
        SelectedClicked          : QAbstractItemView.EditTrigger = ... # 0x4
        EditKeyPressed           : QAbstractItemView.EditTrigger = ... # 0x8
        AnyKeyPressed            : QAbstractItemView.EditTrigger = ... # 0x10
        AllEditTriggers          : QAbstractItemView.EditTrigger = ... # 0x1f

    class EditTriggers(object): ...

    class ScrollHint(Shiboken.Enum):
        EnsureVisible            : QAbstractItemView.ScrollHint = ... # 0x0
        PositionAtTop            : QAbstractItemView.ScrollHint = ... # 0x1
        PositionAtBottom         : QAbstractItemView.ScrollHint = ... # 0x2
        PositionAtCenter         : QAbstractItemView.ScrollHint = ... # 0x3

    class ScrollMode(Shiboken.Enum):
        ScrollPerItem            : QAbstractItemView.ScrollMode = ... # 0x0
        ScrollPerPixel           : QAbstractItemView.ScrollMode = ... # 0x1

    class SelectionBehavior(Shiboken.Enum):
        SelectItems              : QAbstractItemView.SelectionBehavior = ... # 0x0
        SelectRows               : QAbstractItemView.SelectionBehavior = ... # 0x1
        SelectColumns            : QAbstractItemView.SelectionBehavior = ... # 0x2

    class SelectionMode(Shiboken.Enum):
        NoSelection              : QAbstractItemView.SelectionMode = ... # 0x0
        SingleSelection          : QAbstractItemView.SelectionMode = ... # 0x1
        MultiSelection           : QAbstractItemView.SelectionMode = ... # 0x2
        ExtendedSelection        : QAbstractItemView.SelectionMode = ... # 0x3
        ContiguousSelection      : QAbstractItemView.SelectionMode = ... # 0x4

    class State(Shiboken.Enum):
        NoState                  : QAbstractItemView.State = ... # 0x0
        DraggingState            : QAbstractItemView.State = ... # 0x1
        DragSelectingState       : QAbstractItemView.State = ... # 0x2
        EditingState             : QAbstractItemView.State = ... # 0x3
        ExpandingState           : QAbstractItemView.State = ... # 0x4
        CollapsingState          : QAbstractItemView.State = ... # 0x5
        AnimatingState           : QAbstractItemView.State = ... # 0x6

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def alternatingRowColors(self) -> bool: ...
    def autoScrollMargin(self) -> int: ...
    def clearSelection(self) -> None: ...
    def closeEditor(self, editor: PySide2.QtWidgets.QWidget, hint: PySide2.QtWidgets.QAbstractItemDelegate.EndEditHint) -> None: ...
    def closePersistentEditor(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    def commitData(self, editor: PySide2.QtWidgets.QWidget) -> None: ...
    def currentChanged(self, current: PySide2.QtCore.QModelIndex, previous: PySide2.QtCore.QModelIndex) -> None: ...
    def currentIndex(self) -> PySide2.QtCore.QModelIndex: ...
    def dataChanged(self, topLeft: PySide2.QtCore.QModelIndex, bottomRight: PySide2.QtCore.QModelIndex, roles: typing.List[int] = ...) -> None: ...
    def defaultDropAction(self) -> PySide2.QtCore.Qt.DropAction: ...
    def dirtyRegionOffset(self) -> PySide2.QtCore.QPoint: ...
    def doAutoScroll(self) -> None: ...
    def doItemsLayout(self) -> None: ...
    def dragDropMode(self) -> PySide2.QtWidgets.QAbstractItemView.DragDropMode: ...
    def dragDropOverwriteMode(self) -> bool: ...
    def dragEnabled(self) -> bool: ...
    def dragEnterEvent(self, event: PySide2.QtGui.QDragEnterEvent) -> None: ...
    def dragLeaveEvent(self, event: PySide2.QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, event: PySide2.QtGui.QDragMoveEvent) -> None: ...
    def dropEvent(self, event: PySide2.QtGui.QDropEvent) -> None: ...
    def dropIndicatorPosition(self) -> PySide2.QtWidgets.QAbstractItemView.DropIndicatorPosition: ...
    @typing.overload
    def edit(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    @typing.overload
    def edit(self, index: PySide2.QtCore.QModelIndex, trigger: PySide2.QtWidgets.QAbstractItemView.EditTrigger, event: PySide2.QtCore.QEvent) -> bool: ...
    def editTriggers(self) -> PySide2.QtWidgets.QAbstractItemView.EditTriggers: ...
    def editorDestroyed(self, editor: PySide2.QtCore.QObject) -> None: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, object: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    def executeDelayedItemsLayout(self) -> None: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def hasAutoScroll(self) -> bool: ...
    def horizontalOffset(self) -> int: ...
    def horizontalScrollMode(self) -> PySide2.QtWidgets.QAbstractItemView.ScrollMode: ...
    def horizontalScrollbarAction(self, action: int) -> None: ...
    def horizontalScrollbarValueChanged(self, value: int) -> None: ...
    def horizontalStepsPerItem(self) -> int: ...
    def iconSize(self) -> PySide2.QtCore.QSize: ...
    def indexAt(self, point: PySide2.QtCore.QPoint) -> PySide2.QtCore.QModelIndex: ...
    def indexWidget(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QWidget: ...
    def inputMethodEvent(self, event: PySide2.QtGui.QInputMethodEvent) -> None: ...
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def isIndexHidden(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def isPersistentEditorOpen(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    @typing.overload
    def itemDelegate(self) -> PySide2.QtWidgets.QAbstractItemDelegate: ...
    @typing.overload
    def itemDelegate(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QAbstractItemDelegate: ...
    def itemDelegateForColumn(self, column: int) -> PySide2.QtWidgets.QAbstractItemDelegate: ...
    def itemDelegateForRow(self, row: int) -> PySide2.QtWidgets.QAbstractItemDelegate: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyboardSearch(self, search: str) -> None: ...
    def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
    def mouseDoubleClickEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def moveCursor(self, cursorAction: PySide2.QtWidgets.QAbstractItemView.CursorAction, modifiers: PySide2.QtCore.Qt.KeyboardModifiers) -> PySide2.QtCore.QModelIndex: ...
    def openPersistentEditor(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    def reset(self) -> None: ...
    def resetHorizontalScrollMode(self) -> None: ...
    def resetVerticalScrollMode(self) -> None: ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent) -> None: ...
    def rootIndex(self) -> PySide2.QtCore.QModelIndex: ...
    def rowsAboutToBeRemoved(self, parent: PySide2.QtCore.QModelIndex, start: int, end: int) -> None: ...
    def rowsInserted(self, parent: PySide2.QtCore.QModelIndex, start: int, end: int) -> None: ...
    def scheduleDelayedItemsLayout(self) -> None: ...
    def scrollDirtyRegion(self, dx: int, dy: int) -> None: ...
    def scrollTo(self, index: PySide2.QtCore.QModelIndex, hint: PySide2.QtWidgets.QAbstractItemView.ScrollHint = ...) -> None: ...
    def scrollToBottom(self) -> None: ...
    def scrollToTop(self) -> None: ...
    def selectAll(self) -> None: ...
    def selectedIndexes(self) -> typing.List[int]: ...
    def selectionBehavior(self) -> PySide2.QtWidgets.QAbstractItemView.SelectionBehavior: ...
    def selectionChanged(self, selected: PySide2.QtCore.QItemSelection, deselected: PySide2.QtCore.QItemSelection) -> None: ...
    def selectionCommand(self, index: PySide2.QtCore.QModelIndex, event: typing.Optional[PySide2.QtCore.QEvent] = ...) -> PySide2.QtCore.QItemSelectionModel.SelectionFlags: ...
    def selectionMode(self) -> PySide2.QtWidgets.QAbstractItemView.SelectionMode: ...
    def selectionModel(self) -> PySide2.QtCore.QItemSelectionModel: ...
    def setAlternatingRowColors(self, enable: bool) -> None: ...
    def setAutoScroll(self, enable: bool) -> None: ...
    def setAutoScrollMargin(self, margin: int) -> None: ...
    def setCurrentIndex(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setDefaultDropAction(self, dropAction: PySide2.QtCore.Qt.DropAction) -> None: ...
    def setDirtyRegion(self, region: PySide2.QtGui.QRegion) -> None: ...
    def setDragDropMode(self, behavior: PySide2.QtWidgets.QAbstractItemView.DragDropMode) -> None: ...
    def setDragDropOverwriteMode(self, overwrite: bool) -> None: ...
    def setDragEnabled(self, enable: bool) -> None: ...
    def setDropIndicatorShown(self, enable: bool) -> None: ...
    def setEditTriggers(self, triggers: PySide2.QtWidgets.QAbstractItemView.EditTriggers) -> None: ...
    def setHorizontalScrollMode(self, mode: PySide2.QtWidgets.QAbstractItemView.ScrollMode) -> None: ...
    def setHorizontalStepsPerItem(self, steps: int) -> None: ...
    def setIconSize(self, size: PySide2.QtCore.QSize) -> None: ...
    def setIndexWidget(self, index: PySide2.QtCore.QModelIndex, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def setItemDelegate(self, delegate: PySide2.QtWidgets.QAbstractItemDelegate) -> None: ...
    def setItemDelegateForColumn(self, column: int, delegate: PySide2.QtWidgets.QAbstractItemDelegate) -> None: ...
    def setItemDelegateForRow(self, row: int, delegate: PySide2.QtWidgets.QAbstractItemDelegate) -> None: ...
    def setModel(self, model: PySide2.QtCore.QAbstractItemModel) -> None: ...
    def setRootIndex(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setSelection(self, rect: PySide2.QtCore.QRect, command: PySide2.QtCore.QItemSelectionModel.SelectionFlags) -> None: ...
    def setSelectionBehavior(self, behavior: PySide2.QtWidgets.QAbstractItemView.SelectionBehavior) -> None: ...
    def setSelectionMode(self, mode: PySide2.QtWidgets.QAbstractItemView.SelectionMode) -> None: ...
    def setSelectionModel(self, selectionModel: PySide2.QtCore.QItemSelectionModel) -> None: ...
    def setState(self, state: PySide2.QtWidgets.QAbstractItemView.State) -> None: ...
    def setTabKeyNavigation(self, enable: bool) -> None: ...
    def setTextElideMode(self, mode: PySide2.QtCore.Qt.TextElideMode) -> None: ...
    def setVerticalScrollMode(self, mode: PySide2.QtWidgets.QAbstractItemView.ScrollMode) -> None: ...
    def setVerticalStepsPerItem(self, steps: int) -> None: ...
    def showDropIndicator(self) -> bool: ...
    def sizeHintForColumn(self, column: int) -> int: ...
    def sizeHintForIndex(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QSize: ...
    def sizeHintForRow(self, row: int) -> int: ...
    def startAutoScroll(self) -> None: ...
    def startDrag(self, supportedActions: PySide2.QtCore.Qt.DropActions) -> None: ...
    def state(self) -> PySide2.QtWidgets.QAbstractItemView.State: ...
    def stopAutoScroll(self) -> None: ...
    def tabKeyNavigation(self) -> bool: ...
    def textElideMode(self) -> PySide2.QtCore.Qt.TextElideMode: ...
    def timerEvent(self, event: PySide2.QtCore.QTimerEvent) -> None: ...
    @typing.overload
    def update(self) -> None: ...
    @typing.overload
    def update(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    def updateEditorData(self) -> None: ...
    def updateEditorGeometries(self) -> None: ...
    def updateGeometries(self) -> None: ...
    def verticalOffset(self) -> int: ...
    def verticalScrollMode(self) -> PySide2.QtWidgets.QAbstractItemView.ScrollMode: ...
    def verticalScrollbarAction(self, action: int) -> None: ...
    def verticalScrollbarValueChanged(self, value: int) -> None: ...
    def verticalStepsPerItem(self) -> int: ...
    def viewOptions(self) -> PySide2.QtWidgets.QStyleOptionViewItem: ...
    def viewportEvent(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def viewportSizeHint(self) -> PySide2.QtCore.QSize: ...
    def visualRect(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide2.QtCore.QItemSelection) -> PySide2.QtGui.QRegion: ...


class QAbstractScrollArea(PySide2.QtWidgets.QFrame):
    AdjustIgnored            : QAbstractScrollArea.SizeAdjustPolicy = ... # 0x0
    AdjustToContentsOnFirstShow: QAbstractScrollArea.SizeAdjustPolicy = ... # 0x1
    AdjustToContents         : QAbstractScrollArea.SizeAdjustPolicy = ... # 0x2

    class SizeAdjustPolicy(Shiboken.Enum):
        AdjustIgnored            : QAbstractScrollArea.SizeAdjustPolicy = ... # 0x0
        AdjustToContentsOnFirstShow: QAbstractScrollArea.SizeAdjustPolicy = ... # 0x1
        AdjustToContents         : QAbstractScrollArea.SizeAdjustPolicy = ... # 0x2

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def addScrollBarWidget(self, widget: PySide2.QtWidgets.QWidget, alignment: PySide2.QtCore.Qt.Alignment) -> None: ...
    def contextMenuEvent(self, arg__1: PySide2.QtGui.QContextMenuEvent) -> None: ...
    def cornerWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def dragEnterEvent(self, arg__1: PySide2.QtGui.QDragEnterEvent) -> None: ...
    def dragLeaveEvent(self, arg__1: PySide2.QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, arg__1: PySide2.QtGui.QDragMoveEvent) -> None: ...
    def dropEvent(self, arg__1: PySide2.QtGui.QDropEvent) -> None: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1: PySide2.QtCore.QObject, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    def horizontalScrollBar(self) -> PySide2.QtWidgets.QScrollBar: ...
    def horizontalScrollBarPolicy(self) -> PySide2.QtCore.Qt.ScrollBarPolicy: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent) -> None: ...
    def maximumViewportSize(self) -> PySide2.QtCore.QSize: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseDoubleClickEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent) -> None: ...
    def scrollBarWidgets(self, alignment: PySide2.QtCore.Qt.Alignment) -> typing.List[PySide2.QtWidgets.QWidget]: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def setCornerWidget(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def setHorizontalScrollBar(self, scrollbar: PySide2.QtWidgets.QScrollBar) -> None: ...
    def setHorizontalScrollBarPolicy(self, arg__1: PySide2.QtCore.Qt.ScrollBarPolicy) -> None: ...
    def setSizeAdjustPolicy(self, policy: PySide2.QtWidgets.QAbstractScrollArea.SizeAdjustPolicy) -> None: ...
    def setVerticalScrollBar(self, scrollbar: PySide2.QtWidgets.QScrollBar) -> None: ...
    def setVerticalScrollBarPolicy(self, arg__1: PySide2.QtCore.Qt.ScrollBarPolicy) -> None: ...
    def setViewport(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    @typing.overload
    def setViewportMargins(self, left: int, top: int, right: int, bottom: int) -> None: ...
    @typing.overload
    def setViewportMargins(self, margins: PySide2.QtCore.QMargins) -> None: ...
    def setupViewport(self, viewport: PySide2.QtWidgets.QWidget) -> None: ...
    def sizeAdjustPolicy(self) -> PySide2.QtWidgets.QAbstractScrollArea.SizeAdjustPolicy: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def verticalScrollBar(self) -> PySide2.QtWidgets.QScrollBar: ...
    def verticalScrollBarPolicy(self) -> PySide2.QtCore.Qt.ScrollBarPolicy: ...
    def viewport(self) -> PySide2.QtWidgets.QWidget: ...
    def viewportEvent(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def viewportMargins(self) -> PySide2.QtCore.QMargins: ...
    def viewportSizeHint(self) -> PySide2.QtCore.QSize: ...
    def wheelEvent(self, arg__1: PySide2.QtGui.QWheelEvent) -> None: ...


class QAbstractSlider(PySide2.QtWidgets.QWidget):
    SliderNoAction           : QAbstractSlider.SliderAction = ... # 0x0
    SliderSingleStepAdd      : QAbstractSlider.SliderAction = ... # 0x1
    SliderSingleStepSub      : QAbstractSlider.SliderAction = ... # 0x2
    SliderPageStepAdd        : QAbstractSlider.SliderAction = ... # 0x3
    SliderPageStepSub        : QAbstractSlider.SliderAction = ... # 0x4
    SliderToMinimum          : QAbstractSlider.SliderAction = ... # 0x5
    SliderToMaximum          : QAbstractSlider.SliderAction = ... # 0x6
    SliderMove               : QAbstractSlider.SliderAction = ... # 0x7
    SliderRangeChange        : QAbstractSlider.SliderChange = ... # 0x0
    SliderOrientationChange  : QAbstractSlider.SliderChange = ... # 0x1
    SliderStepsChange        : QAbstractSlider.SliderChange = ... # 0x2
    SliderValueChange        : QAbstractSlider.SliderChange = ... # 0x3

    class SliderAction(Shiboken.Enum):
        SliderNoAction           : QAbstractSlider.SliderAction = ... # 0x0
        SliderSingleStepAdd      : QAbstractSlider.SliderAction = ... # 0x1
        SliderSingleStepSub      : QAbstractSlider.SliderAction = ... # 0x2
        SliderPageStepAdd        : QAbstractSlider.SliderAction = ... # 0x3
        SliderPageStepSub        : QAbstractSlider.SliderAction = ... # 0x4
        SliderToMinimum          : QAbstractSlider.SliderAction = ... # 0x5
        SliderToMaximum          : QAbstractSlider.SliderAction = ... # 0x6
        SliderMove               : QAbstractSlider.SliderAction = ... # 0x7

    class SliderChange(Shiboken.Enum):
        SliderRangeChange        : QAbstractSlider.SliderChange = ... # 0x0
        SliderOrientationChange  : QAbstractSlider.SliderChange = ... # 0x1
        SliderStepsChange        : QAbstractSlider.SliderChange = ... # 0x2
        SliderValueChange        : QAbstractSlider.SliderChange = ... # 0x3

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def changeEvent(self, e: PySide2.QtCore.QEvent) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def hasTracking(self) -> bool: ...
    def invertedAppearance(self) -> bool: ...
    def invertedControls(self) -> bool: ...
    def isSliderDown(self) -> bool: ...
    def keyPressEvent(self, ev: PySide2.QtGui.QKeyEvent) -> None: ...
    def maximum(self) -> int: ...
    def minimum(self) -> int: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def pageStep(self) -> int: ...
    def repeatAction(self) -> PySide2.QtWidgets.QAbstractSlider.SliderAction: ...
    def setInvertedAppearance(self, arg__1: bool) -> None: ...
    def setInvertedControls(self, arg__1: bool) -> None: ...
    def setMaximum(self, arg__1: int) -> None: ...
    def setMinimum(self, arg__1: int) -> None: ...
    def setOrientation(self, arg__1: PySide2.QtCore.Qt.Orientation) -> None: ...
    def setPageStep(self, arg__1: int) -> None: ...
    def setRange(self, min: int, max: int) -> None: ...
    def setRepeatAction(self, action: PySide2.QtWidgets.QAbstractSlider.SliderAction, thresholdTime: int = ..., repeatTime: int = ...) -> None: ...
    def setSingleStep(self, arg__1: int) -> None: ...
    def setSliderDown(self, arg__1: bool) -> None: ...
    def setSliderPosition(self, arg__1: int) -> None: ...
    def setTracking(self, enable: bool) -> None: ...
    def setValue(self, arg__1: int) -> None: ...
    def singleStep(self) -> int: ...
    def sliderChange(self, change: PySide2.QtWidgets.QAbstractSlider.SliderChange) -> None: ...
    def sliderPosition(self) -> int: ...
    def timerEvent(self, arg__1: PySide2.QtCore.QTimerEvent) -> None: ...
    def triggerAction(self, action: PySide2.QtWidgets.QAbstractSlider.SliderAction) -> None: ...
    def value(self) -> int: ...
    def wheelEvent(self, e: PySide2.QtGui.QWheelEvent) -> None: ...


class QAbstractSpinBox(PySide2.QtWidgets.QWidget):
    UpDownArrows             : QAbstractSpinBox.ButtonSymbols = ... # 0x0
    PlusMinus                : QAbstractSpinBox.ButtonSymbols = ... # 0x1
    NoButtons                : QAbstractSpinBox.ButtonSymbols = ... # 0x2
    CorrectToPreviousValue   : QAbstractSpinBox.CorrectionMode = ... # 0x0
    CorrectToNearestValue    : QAbstractSpinBox.CorrectionMode = ... # 0x1
    StepNone                 : QAbstractSpinBox.StepEnabledFlag = ... # 0x0
    StepUpEnabled            : QAbstractSpinBox.StepEnabledFlag = ... # 0x1
    StepDownEnabled          : QAbstractSpinBox.StepEnabledFlag = ... # 0x2
    DefaultStepType          : QAbstractSpinBox.StepType = ... # 0x0
    AdaptiveDecimalStepType  : QAbstractSpinBox.StepType = ... # 0x1

    class ButtonSymbols(Shiboken.Enum):
        UpDownArrows             : QAbstractSpinBox.ButtonSymbols = ... # 0x0
        PlusMinus                : QAbstractSpinBox.ButtonSymbols = ... # 0x1
        NoButtons                : QAbstractSpinBox.ButtonSymbols = ... # 0x2

    class CorrectionMode(Shiboken.Enum):
        CorrectToPreviousValue   : QAbstractSpinBox.CorrectionMode = ... # 0x0
        CorrectToNearestValue    : QAbstractSpinBox.CorrectionMode = ... # 0x1

    class StepEnabled(object): ...

    class StepEnabledFlag(Shiboken.Enum):
        StepNone                 : QAbstractSpinBox.StepEnabledFlag = ... # 0x0
        StepUpEnabled            : QAbstractSpinBox.StepEnabledFlag = ... # 0x1
        StepDownEnabled          : QAbstractSpinBox.StepEnabledFlag = ... # 0x2

    class StepType(Shiboken.Enum):
        DefaultStepType          : QAbstractSpinBox.StepType = ... # 0x0
        AdaptiveDecimalStepType  : QAbstractSpinBox.StepType = ... # 0x1

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def buttonSymbols(self) -> PySide2.QtWidgets.QAbstractSpinBox.ButtonSymbols: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def closeEvent(self, event: PySide2.QtGui.QCloseEvent) -> None: ...
    def contextMenuEvent(self, event: PySide2.QtGui.QContextMenuEvent) -> None: ...
    def correctionMode(self) -> PySide2.QtWidgets.QAbstractSpinBox.CorrectionMode: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def fixup(self, input: str) -> None: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def hasAcceptableInput(self) -> bool: ...
    def hasFrame(self) -> bool: ...
    def hideEvent(self, event: PySide2.QtGui.QHideEvent) -> None: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionSpinBox) -> None: ...
    def inputMethodQuery(self, arg__1: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def interpretText(self) -> None: ...
    def isAccelerated(self) -> bool: ...
    def isGroupSeparatorShown(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyboardTracking(self) -> bool: ...
    def lineEdit(self) -> PySide2.QtWidgets.QLineEdit: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent) -> None: ...
    def selectAll(self) -> None: ...
    def setAccelerated(self, on: bool) -> None: ...
    def setAlignment(self, flag: PySide2.QtCore.Qt.Alignment) -> None: ...
    def setButtonSymbols(self, bs: PySide2.QtWidgets.QAbstractSpinBox.ButtonSymbols) -> None: ...
    def setCorrectionMode(self, cm: PySide2.QtWidgets.QAbstractSpinBox.CorrectionMode) -> None: ...
    def setFrame(self, arg__1: bool) -> None: ...
    def setGroupSeparatorShown(self, shown: bool) -> None: ...
    def setKeyboardTracking(self, kt: bool) -> None: ...
    def setLineEdit(self, edit: PySide2.QtWidgets.QLineEdit) -> None: ...
    def setReadOnly(self, r: bool) -> None: ...
    def setSpecialValueText(self, txt: str) -> None: ...
    def setWrapping(self, w: bool) -> None: ...
    def showEvent(self, event: PySide2.QtGui.QShowEvent) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def specialValueText(self) -> str: ...
    def stepBy(self, steps: int) -> None: ...
    def stepDown(self) -> None: ...
    def stepEnabled(self) -> PySide2.QtWidgets.QAbstractSpinBox.StepEnabled: ...
    def stepUp(self) -> None: ...
    def text(self) -> str: ...
    def timerEvent(self, event: PySide2.QtCore.QTimerEvent) -> None: ...
    def validate(self, input: str, pos: int) -> PySide2.QtGui.QValidator.State: ...
    def wheelEvent(self, event: PySide2.QtGui.QWheelEvent) -> None: ...
    def wrapping(self) -> bool: ...


class QAccessibleWidget(PySide2.QtGui.QAccessibleObject):

    def __init__(self, o: PySide2.QtWidgets.QWidget, r: PySide2.QtGui.QAccessible.Role = ..., name: str = ...) -> None: ...

    def actionNames(self) -> typing.List[str]: ...
    def addControllingSignal(self, signal: str) -> None: ...
    def backgroundColor(self) -> PySide2.QtGui.QColor: ...
    def child(self, index: int) -> PySide2.QtGui.QAccessibleInterface: ...
    def childCount(self) -> int: ...
    def doAction(self, actionName: str) -> None: ...
    def focusChild(self) -> PySide2.QtGui.QAccessibleInterface: ...
    def foregroundColor(self) -> PySide2.QtGui.QColor: ...
    def indexOfChild(self, child: PySide2.QtGui.QAccessibleInterface) -> int: ...
    def interface_cast(self, t: PySide2.QtGui.QAccessible.InterfaceType) -> int: ...
    def isValid(self) -> bool: ...
    def keyBindingsForAction(self, actionName: str) -> typing.List[str]: ...
    def parent(self) -> PySide2.QtGui.QAccessibleInterface: ...
    def parentObject(self) -> PySide2.QtCore.QObject: ...
    def rect(self) -> PySide2.QtCore.QRect: ...
    def relations(self, match: PySide2.QtGui.QAccessible.Relation = ...) -> typing.List[typing.Tuple[PySide2.QtGui.QAccessibleInterface, PySide2.QtGui.QAccessible.Relation]]: ...
    def role(self) -> PySide2.QtGui.QAccessible.Role: ...
    def state(self) -> PySide2.QtGui.QAccessible.State: ...
    def text(self, t: PySide2.QtGui.QAccessible.Text) -> str: ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...
    def window(self) -> PySide2.QtGui.QWindow: ...


class QAction(PySide2.QtCore.QObject):
    Trigger                  : QAction.ActionEvent = ... # 0x0
    Hover                    : QAction.ActionEvent = ... # 0x1
    NoRole                   : QAction.MenuRole = ... # 0x0
    TextHeuristicRole        : QAction.MenuRole = ... # 0x1
    ApplicationSpecificRole  : QAction.MenuRole = ... # 0x2
    AboutQtRole              : QAction.MenuRole = ... # 0x3
    AboutRole                : QAction.MenuRole = ... # 0x4
    PreferencesRole          : QAction.MenuRole = ... # 0x5
    QuitRole                 : QAction.MenuRole = ... # 0x6
    LowPriority              : QAction.Priority = ... # 0x0
    NormalPriority           : QAction.Priority = ... # 0x80
    HighPriority             : QAction.Priority = ... # 0x100

    class ActionEvent(Shiboken.Enum):
        Trigger                  : QAction.ActionEvent = ... # 0x0
        Hover                    : QAction.ActionEvent = ... # 0x1

    class MenuRole(Shiboken.Enum):
        NoRole                   : QAction.MenuRole = ... # 0x0
        TextHeuristicRole        : QAction.MenuRole = ... # 0x1
        ApplicationSpecificRole  : QAction.MenuRole = ... # 0x2
        AboutQtRole              : QAction.MenuRole = ... # 0x3
        AboutRole                : QAction.MenuRole = ... # 0x4
        PreferencesRole          : QAction.MenuRole = ... # 0x5
        QuitRole                 : QAction.MenuRole = ... # 0x6

    class Priority(Shiboken.Enum):
        LowPriority              : QAction.Priority = ... # 0x0
        NormalPriority           : QAction.Priority = ... # 0x80
        HighPriority             : QAction.Priority = ... # 0x100

    @typing.overload
    def __init__(self, icon: PySide2.QtGui.QIcon, text: str, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def actionGroup(self) -> PySide2.QtWidgets.QActionGroup: ...
    def activate(self, event: PySide2.QtWidgets.QAction.ActionEvent) -> None: ...
    def associatedGraphicsWidgets(self) -> typing.List[PySide2.QtWidgets.QGraphicsWidget]: ...
    def associatedWidgets(self) -> typing.List[PySide2.QtWidgets.QWidget]: ...
    def autoRepeat(self) -> bool: ...
    def data(self) -> typing.Any: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def hover(self) -> None: ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    def iconText(self) -> str: ...
    def isCheckable(self) -> bool: ...
    def isChecked(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isIconVisibleInMenu(self) -> bool: ...
    def isSeparator(self) -> bool: ...
    def isShortcutVisibleInContextMenu(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def menu(self) -> PySide2.QtWidgets.QMenu: ...
    def menuRole(self) -> PySide2.QtWidgets.QAction.MenuRole: ...
    def parentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def priority(self) -> PySide2.QtWidgets.QAction.Priority: ...
    def setActionGroup(self, group: PySide2.QtWidgets.QActionGroup) -> None: ...
    def setAutoRepeat(self, arg__1: bool) -> None: ...
    def setCheckable(self, arg__1: bool) -> None: ...
    def setChecked(self, arg__1: bool) -> None: ...
    def setData(self, var: typing.Any) -> None: ...
    def setDisabled(self, b: bool) -> None: ...
    def setEnabled(self, arg__1: bool) -> None: ...
    def setFont(self, font: PySide2.QtGui.QFont) -> None: ...
    def setIcon(self, icon: PySide2.QtGui.QIcon) -> None: ...
    def setIconText(self, text: str) -> None: ...
    def setIconVisibleInMenu(self, visible: bool) -> None: ...
    def setMenu(self, menu: PySide2.QtWidgets.QMenu) -> None: ...
    def setMenuRole(self, menuRole: PySide2.QtWidgets.QAction.MenuRole) -> None: ...
    def setPriority(self, priority: PySide2.QtWidgets.QAction.Priority) -> None: ...
    def setSeparator(self, b: bool) -> None: ...
    def setShortcut(self, shortcut: PySide2.QtGui.QKeySequence) -> None: ...
    def setShortcutContext(self, context: PySide2.QtCore.Qt.ShortcutContext) -> None: ...
    def setShortcutVisibleInContextMenu(self, show: bool) -> None: ...
    @typing.overload
    def setShortcuts(self, arg__1: PySide2.QtGui.QKeySequence.StandardKey) -> None: ...
    @typing.overload
    def setShortcuts(self, shortcuts: typing.Sequence[PySide2.QtGui.QKeySequence]) -> None: ...
    def setStatusTip(self, statusTip: str) -> None: ...
    def setText(self, text: str) -> None: ...
    def setToolTip(self, tip: str) -> None: ...
    def setVisible(self, arg__1: bool) -> None: ...
    def setWhatsThis(self, what: str) -> None: ...
    def shortcut(self) -> PySide2.QtGui.QKeySequence: ...
    def shortcutContext(self) -> PySide2.QtCore.Qt.ShortcutContext: ...
    def shortcuts(self) -> typing.List[PySide2.QtGui.QKeySequence]: ...
    def showStatusText(self, widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> bool: ...
    def statusTip(self) -> str: ...
    def text(self) -> str: ...
    def toggle(self) -> None: ...
    def toolTip(self) -> str: ...
    def trigger(self) -> None: ...
    def whatsThis(self) -> str: ...


class QActionGroup(PySide2.QtCore.QObject):

    class ExclusionPolicy(Shiboken.Enum):
        None_                    : QActionGroup.ExclusionPolicy = ... # 0x0
        Exclusive                : QActionGroup.ExclusionPolicy = ... # 0x1
        ExclusiveOptional        : QActionGroup.ExclusionPolicy = ... # 0x2

    def __init__(self, parent: PySide2.QtCore.QObject) -> None: ...

    def actions(self) -> typing.List[PySide2.QtWidgets.QAction]: ...
    @typing.overload
    def addAction(self, a: PySide2.QtWidgets.QAction) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, icon: PySide2.QtGui.QIcon, text: str) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, text: str) -> PySide2.QtWidgets.QAction: ...
    def checkedAction(self) -> PySide2.QtWidgets.QAction: ...
    def exclusionPolicy(self) -> PySide2.QtWidgets.QActionGroup.ExclusionPolicy: ...
    def isEnabled(self) -> bool: ...
    def isExclusive(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def removeAction(self, a: PySide2.QtWidgets.QAction) -> None: ...
    def setDisabled(self, b: bool) -> None: ...
    def setEnabled(self, arg__1: bool) -> None: ...
    def setExclusionPolicy(self, policy: PySide2.QtWidgets.QActionGroup.ExclusionPolicy) -> None: ...
    def setExclusive(self, arg__1: bool) -> None: ...
    def setVisible(self, arg__1: bool) -> None: ...


class QApplication(PySide2.QtGui.QGuiApplication):
    NormalColor              : QApplication.ColorSpec = ... # 0x0
    CustomColor              : QApplication.ColorSpec = ... # 0x1
    ManyColor                : QApplication.ColorSpec = ... # 0x2

    class ColorSpec(Shiboken.Enum):
        NormalColor              : QApplication.ColorSpec = ... # 0x0
        CustomColor              : QApplication.ColorSpec = ... # 0x1
        ManyColor                : QApplication.ColorSpec = ... # 0x2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: typing.Sequence[str]) -> None: ...

    @staticmethod
    def aboutQt() -> None: ...
    @staticmethod
    def activeModalWidget() -> PySide2.QtWidgets.QWidget: ...
    @staticmethod
    def activePopupWidget() -> PySide2.QtWidgets.QWidget: ...
    @staticmethod
    def activeWindow() -> PySide2.QtWidgets.QWidget: ...
    @staticmethod
    def alert(widget: PySide2.QtWidgets.QWidget, duration: int = ...) -> None: ...
    @staticmethod
    def allWidgets() -> typing.List[PySide2.QtWidgets.QWidget]: ...
    def autoSipEnabled(self) -> bool: ...
    @staticmethod
    def beep() -> None: ...
    @staticmethod
    def closeAllWindows() -> None: ...
    @staticmethod
    def colorSpec() -> int: ...
    @staticmethod
    def cursorFlashTime() -> int: ...
    @staticmethod
    def desktop() -> PySide2.QtWidgets.QDesktopWidget: ...
    @staticmethod
    def doubleClickInterval() -> int: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    @staticmethod
    def exec_() -> int: ...
    @staticmethod
    def focusWidget() -> PySide2.QtWidgets.QWidget: ...
    @typing.overload
    @staticmethod
    def font() -> PySide2.QtGui.QFont: ...
    @typing.overload
    @staticmethod
    def font(arg__1: PySide2.QtWidgets.QWidget) -> PySide2.QtGui.QFont: ...
    @typing.overload
    @staticmethod
    def font(className: bytes) -> PySide2.QtGui.QFont: ...
    @staticmethod
    def fontMetrics() -> PySide2.QtGui.QFontMetrics: ...
    @staticmethod
    def globalStrut() -> PySide2.QtCore.QSize: ...
    @staticmethod
    def isEffectEnabled(arg__1: PySide2.QtCore.Qt.UIEffect) -> bool: ...
    @staticmethod
    def keyboardInputInterval() -> int: ...
    def notify(self, arg__1: PySide2.QtCore.QObject, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    @typing.overload
    @staticmethod
    def palette() -> PySide2.QtGui.QPalette: ...
    @typing.overload
    @staticmethod
    def palette(arg__1: PySide2.QtWidgets.QWidget) -> PySide2.QtGui.QPalette: ...
    @typing.overload
    @staticmethod
    def palette(className: bytes) -> PySide2.QtGui.QPalette: ...
    @staticmethod
    def setActiveWindow(act: PySide2.QtWidgets.QWidget) -> None: ...
    def setAutoSipEnabled(self, enabled: bool) -> None: ...
    @staticmethod
    def setColorSpec(arg__1: int) -> None: ...
    @staticmethod
    def setCursorFlashTime(arg__1: int) -> None: ...
    @staticmethod
    def setDoubleClickInterval(arg__1: int) -> None: ...
    @staticmethod
    def setEffectEnabled(arg__1: PySide2.QtCore.Qt.UIEffect, enable: bool = ...) -> None: ...
    @typing.overload
    @staticmethod
    def setFont(arg__1: PySide2.QtGui.QFont) -> None: ...
    @typing.overload
    @staticmethod
    def setFont(arg__1: PySide2.QtGui.QFont, className: typing.Optional[bytes] = ...) -> None: ...
    @staticmethod
    def setGlobalStrut(arg__1: PySide2.QtCore.QSize) -> None: ...
    @staticmethod
    def setKeyboardInputInterval(arg__1: int) -> None: ...
    @typing.overload
    @staticmethod
    def setPalette(arg__1: PySide2.QtGui.QPalette, className: typing.Optional[bytes] = ...) -> None: ...
    @typing.overload
    @staticmethod
    def setPalette(pal: PySide2.QtGui.QPalette) -> None: ...
    @staticmethod
    def setStartDragDistance(l: int) -> None: ...
    @staticmethod
    def setStartDragTime(ms: int) -> None: ...
    @typing.overload
    @staticmethod
    def setStyle(arg__1: PySide2.QtWidgets.QStyle) -> None: ...
    @typing.overload
    @staticmethod
    def setStyle(arg__1: str) -> PySide2.QtWidgets.QStyle: ...
    def setStyleSheet(self, sheet: str) -> None: ...
    @staticmethod
    def setWheelScrollLines(arg__1: int) -> None: ...
    @staticmethod
    def setWindowIcon(icon: PySide2.QtGui.QIcon) -> None: ...
    @staticmethod
    def startDragDistance() -> int: ...
    @staticmethod
    def startDragTime() -> int: ...
    @staticmethod
    def style() -> PySide2.QtWidgets.QStyle: ...
    def styleSheet(self) -> str: ...
    @typing.overload
    @staticmethod
    def topLevelAt(p: PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QWidget: ...
    @typing.overload
    @staticmethod
    def topLevelAt(x: int, y: int) -> PySide2.QtWidgets.QWidget: ...
    @staticmethod
    def topLevelWidgets() -> typing.List[PySide2.QtWidgets.QWidget]: ...
    @staticmethod
    def wheelScrollLines() -> int: ...
    @typing.overload
    @staticmethod
    def widgetAt(p: PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QWidget: ...
    @typing.overload
    @staticmethod
    def widgetAt(x: int, y: int) -> PySide2.QtWidgets.QWidget: ...
    @staticmethod
    def windowIcon() -> PySide2.QtGui.QIcon: ...


class QBoxLayout(PySide2.QtWidgets.QLayout):
    LeftToRight              : QBoxLayout.Direction = ... # 0x0
    RightToLeft              : QBoxLayout.Direction = ... # 0x1
    Down                     : QBoxLayout.Direction = ... # 0x2
    TopToBottom              : QBoxLayout.Direction = ... # 0x2
    BottomToTop              : QBoxLayout.Direction = ... # 0x3
    Up                       : QBoxLayout.Direction = ... # 0x3

    class Direction(Shiboken.Enum):
        LeftToRight              : QBoxLayout.Direction = ... # 0x0
        RightToLeft              : QBoxLayout.Direction = ... # 0x1
        Down                     : QBoxLayout.Direction = ... # 0x2
        TopToBottom              : QBoxLayout.Direction = ... # 0x2
        BottomToTop              : QBoxLayout.Direction = ... # 0x3
        Up                       : QBoxLayout.Direction = ... # 0x3

    def __init__(self, arg__1: PySide2.QtWidgets.QBoxLayout.Direction, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def addItem(self, arg__1: PySide2.QtWidgets.QLayoutItem) -> None: ...
    def addLayout(self, layout: PySide2.QtWidgets.QLayout, stretch: int = ...) -> None: ...
    def addSpacerItem(self, spacerItem: PySide2.QtWidgets.QSpacerItem) -> None: ...
    def addSpacing(self, size: int) -> None: ...
    def addStretch(self, stretch: int = ...) -> None: ...
    def addStrut(self, arg__1: int) -> None: ...
    @typing.overload
    def addWidget(self, arg__1: PySide2.QtWidgets.QWidget, stretch: int = ..., alignment: PySide2.QtCore.Qt.Alignment = ...) -> None: ...
    @typing.overload
    def addWidget(self, w: PySide2.QtWidgets.QWidget) -> None: ...
    def count(self) -> int: ...
    def direction(self) -> PySide2.QtWidgets.QBoxLayout.Direction: ...
    def expandingDirections(self) -> PySide2.QtCore.Qt.Orientations: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def insertItem(self, index: int, arg__2: PySide2.QtWidgets.QLayoutItem) -> None: ...
    def insertLayout(self, index: int, layout: PySide2.QtWidgets.QLayout, stretch: int = ...) -> None: ...
    def insertSpacerItem(self, index: int, spacerItem: PySide2.QtWidgets.QSpacerItem) -> None: ...
    def insertSpacing(self, index: int, size: int) -> None: ...
    def insertStretch(self, index: int, stretch: int = ...) -> None: ...
    def insertWidget(self, index: int, widget: PySide2.QtWidgets.QWidget, stretch: int = ..., alignment: PySide2.QtCore.Qt.Alignment = ...) -> None: ...
    def invalidate(self) -> None: ...
    def itemAt(self, arg__1: int) -> PySide2.QtWidgets.QLayoutItem: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def minimumHeightForWidth(self, arg__1: int) -> int: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def setDirection(self, arg__1: PySide2.QtWidgets.QBoxLayout.Direction) -> None: ...
    def setGeometry(self, arg__1: PySide2.QtCore.QRect) -> None: ...
    def setSpacing(self, spacing: int) -> None: ...
    def setStretch(self, index: int, stretch: int) -> None: ...
    @typing.overload
    def setStretchFactor(self, l: PySide2.QtWidgets.QLayout, stretch: int) -> bool: ...
    @typing.overload
    def setStretchFactor(self, w: PySide2.QtWidgets.QWidget, stretch: int) -> bool: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def spacing(self) -> int: ...
    def stretch(self, index: int) -> int: ...
    def takeAt(self, arg__1: int) -> PySide2.QtWidgets.QLayoutItem: ...


class QButtonGroup(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def addButton(self, arg__1: PySide2.QtWidgets.QAbstractButton, id: int = ...) -> None: ...
    def button(self, id: int) -> PySide2.QtWidgets.QAbstractButton: ...
    def buttons(self) -> typing.List[PySide2.QtWidgets.QAbstractButton]: ...
    def checkedButton(self) -> PySide2.QtWidgets.QAbstractButton: ...
    def checkedId(self) -> int: ...
    def exclusive(self) -> bool: ...
    def id(self, button: PySide2.QtWidgets.QAbstractButton) -> int: ...
    def removeButton(self, arg__1: PySide2.QtWidgets.QAbstractButton) -> None: ...
    def setExclusive(self, arg__1: bool) -> None: ...
    def setId(self, button: PySide2.QtWidgets.QAbstractButton, id: int) -> None: ...


class QCalendarWidget(PySide2.QtWidgets.QWidget):
    NoHorizontalHeader       : QCalendarWidget.HorizontalHeaderFormat = ... # 0x0
    SingleLetterDayNames     : QCalendarWidget.HorizontalHeaderFormat = ... # 0x1
    ShortDayNames            : QCalendarWidget.HorizontalHeaderFormat = ... # 0x2
    LongDayNames             : QCalendarWidget.HorizontalHeaderFormat = ... # 0x3
    NoSelection              : QCalendarWidget.SelectionMode = ... # 0x0
    SingleSelection          : QCalendarWidget.SelectionMode = ... # 0x1
    NoVerticalHeader         : QCalendarWidget.VerticalHeaderFormat = ... # 0x0
    ISOWeekNumbers           : QCalendarWidget.VerticalHeaderFormat = ... # 0x1

    class HorizontalHeaderFormat(Shiboken.Enum):
        NoHorizontalHeader       : QCalendarWidget.HorizontalHeaderFormat = ... # 0x0
        SingleLetterDayNames     : QCalendarWidget.HorizontalHeaderFormat = ... # 0x1
        ShortDayNames            : QCalendarWidget.HorizontalHeaderFormat = ... # 0x2
        LongDayNames             : QCalendarWidget.HorizontalHeaderFormat = ... # 0x3

    class SelectionMode(Shiboken.Enum):
        NoSelection              : QCalendarWidget.SelectionMode = ... # 0x0
        SingleSelection          : QCalendarWidget.SelectionMode = ... # 0x1

    class VerticalHeaderFormat(Shiboken.Enum):
        NoVerticalHeader         : QCalendarWidget.VerticalHeaderFormat = ... # 0x0
        ISOWeekNumbers           : QCalendarWidget.VerticalHeaderFormat = ... # 0x1

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def calendar(self) -> PySide2.QtCore.QCalendar: ...
    def dateEditAcceptDelay(self) -> int: ...
    @typing.overload
    def dateTextFormat(self) -> typing.Dict[PySide2.QtCore.QDate, PySide2.QtGui.QTextCharFormat]: ...
    @typing.overload
    def dateTextFormat(self, date: PySide2.QtCore.QDate) -> PySide2.QtGui.QTextCharFormat: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, watched: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    def firstDayOfWeek(self) -> PySide2.QtCore.Qt.DayOfWeek: ...
    def headerTextFormat(self) -> PySide2.QtGui.QTextCharFormat: ...
    def horizontalHeaderFormat(self) -> PySide2.QtWidgets.QCalendarWidget.HorizontalHeaderFormat: ...
    def isDateEditEnabled(self) -> bool: ...
    def isGridVisible(self) -> bool: ...
    def isNavigationBarVisible(self) -> bool: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def maximumDate(self) -> PySide2.QtCore.QDate: ...
    def minimumDate(self) -> PySide2.QtCore.QDate: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def monthShown(self) -> int: ...
    def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def paintCell(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRect, date: PySide2.QtCore.QDate) -> None: ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent) -> None: ...
    def selectedDate(self) -> PySide2.QtCore.QDate: ...
    def selectionMode(self) -> PySide2.QtWidgets.QCalendarWidget.SelectionMode: ...
    def setCalendar(self, calendar: PySide2.QtCore.QCalendar) -> None: ...
    def setCurrentPage(self, year: int, month: int) -> None: ...
    def setDateEditAcceptDelay(self, delay: int) -> None: ...
    def setDateEditEnabled(self, enable: bool) -> None: ...
    def setDateRange(self, min: PySide2.QtCore.QDate, max: PySide2.QtCore.QDate) -> None: ...
    def setDateTextFormat(self, date: PySide2.QtCore.QDate, format: PySide2.QtGui.QTextCharFormat) -> None: ...
    def setFirstDayOfWeek(self, dayOfWeek: PySide2.QtCore.Qt.DayOfWeek) -> None: ...
    def setGridVisible(self, show: bool) -> None: ...
    def setHeaderTextFormat(self, format: PySide2.QtGui.QTextCharFormat) -> None: ...
    def setHorizontalHeaderFormat(self, format: PySide2.QtWidgets.QCalendarWidget.HorizontalHeaderFormat) -> None: ...
    def setMaximumDate(self, date: PySide2.QtCore.QDate) -> None: ...
    def setMinimumDate(self, date: PySide2.QtCore.QDate) -> None: ...
    def setNavigationBarVisible(self, visible: bool) -> None: ...
    def setSelectedDate(self, date: PySide2.QtCore.QDate) -> None: ...
    def setSelectionMode(self, mode: PySide2.QtWidgets.QCalendarWidget.SelectionMode) -> None: ...
    def setVerticalHeaderFormat(self, format: PySide2.QtWidgets.QCalendarWidget.VerticalHeaderFormat) -> None: ...
    def setWeekdayTextFormat(self, dayOfWeek: PySide2.QtCore.Qt.DayOfWeek, format: PySide2.QtGui.QTextCharFormat) -> None: ...
    def showNextMonth(self) -> None: ...
    def showNextYear(self) -> None: ...
    def showPreviousMonth(self) -> None: ...
    def showPreviousYear(self) -> None: ...
    def showSelectedDate(self) -> None: ...
    def showToday(self) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def updateCell(self, date: PySide2.QtCore.QDate) -> None: ...
    def updateCells(self) -> None: ...
    def verticalHeaderFormat(self) -> PySide2.QtWidgets.QCalendarWidget.VerticalHeaderFormat: ...
    def weekdayTextFormat(self, dayOfWeek: PySide2.QtCore.Qt.DayOfWeek) -> PySide2.QtGui.QTextCharFormat: ...
    def yearShown(self) -> int: ...


class QCheckBox(PySide2.QtWidgets.QAbstractButton):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def checkState(self) -> PySide2.QtCore.Qt.CheckState: ...
    def checkStateSet(self) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def hitButton(self, pos: PySide2.QtCore.QPoint) -> bool: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionButton) -> None: ...
    def isTristate(self) -> bool: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def nextCheckState(self) -> None: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def setCheckState(self, state: PySide2.QtCore.Qt.CheckState) -> None: ...
    def setTristate(self, y: bool = ...) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...


class QColorDialog(PySide2.QtWidgets.QDialog):
    ShowAlphaChannel         : QColorDialog.ColorDialogOption = ... # 0x1
    NoButtons                : QColorDialog.ColorDialogOption = ... # 0x2
    DontUseNativeDialog      : QColorDialog.ColorDialogOption = ... # 0x4

    class ColorDialogOption(Shiboken.Enum):
        ShowAlphaChannel         : QColorDialog.ColorDialogOption = ... # 0x1
        NoButtons                : QColorDialog.ColorDialogOption = ... # 0x2
        DontUseNativeDialog      : QColorDialog.ColorDialogOption = ... # 0x4

    class ColorDialogOptions(object): ...

    @typing.overload
    def __init__(self, initial: PySide2.QtGui.QColor, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def changeEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def currentColor(self) -> PySide2.QtGui.QColor: ...
    @staticmethod
    def customColor(index: int) -> PySide2.QtGui.QColor: ...
    @staticmethod
    def customCount() -> int: ...
    def done(self, result: int) -> None: ...
    @staticmethod
    def getColor(initial: PySide2.QtGui.QColor = ..., parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., title: str = ..., options: PySide2.QtWidgets.QColorDialog.ColorDialogOptions = ...) -> PySide2.QtGui.QColor: ...
    @typing.overload
    def open(self) -> None: ...
    @typing.overload
    def open(self, receiver: PySide2.QtCore.QObject, member: bytes) -> None: ...
    def options(self) -> PySide2.QtWidgets.QColorDialog.ColorDialogOptions: ...
    def selectedColor(self) -> PySide2.QtGui.QColor: ...
    def setCurrentColor(self, color: PySide2.QtGui.QColor) -> None: ...
    @staticmethod
    def setCustomColor(index: int, color: PySide2.QtGui.QColor) -> None: ...
    def setOption(self, option: PySide2.QtWidgets.QColorDialog.ColorDialogOption, on: bool = ...) -> None: ...
    def setOptions(self, options: PySide2.QtWidgets.QColorDialog.ColorDialogOptions) -> None: ...
    @staticmethod
    def setStandardColor(index: int, color: PySide2.QtGui.QColor) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    @staticmethod
    def standardColor(index: int) -> PySide2.QtGui.QColor: ...
    def testOption(self, option: PySide2.QtWidgets.QColorDialog.ColorDialogOption) -> bool: ...


class QColormap(Shiboken.Object):
    Direct                   : QColormap.Mode = ... # 0x0
    Indexed                  : QColormap.Mode = ... # 0x1
    Gray                     : QColormap.Mode = ... # 0x2

    class Mode(Shiboken.Enum):
        Direct                   : QColormap.Mode = ... # 0x0
        Indexed                  : QColormap.Mode = ... # 0x1
        Gray                     : QColormap.Mode = ... # 0x2

    def __init__(self, colormap: PySide2.QtWidgets.QColormap) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def cleanup() -> None: ...
    def colorAt(self, pixel: int) -> PySide2.QtGui.QColor: ...
    def colormap(self) -> typing.List[PySide2.QtGui.QColor]: ...
    def depth(self) -> int: ...
    @staticmethod
    def initialize() -> None: ...
    @staticmethod
    def instance(screen: int = ...) -> PySide2.QtWidgets.QColormap: ...
    def mode(self) -> PySide2.QtWidgets.QColormap.Mode: ...
    def pixel(self, color: PySide2.QtGui.QColor) -> int: ...
    def size(self) -> int: ...


class QColumnView(PySide2.QtWidgets.QAbstractItemView):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def columnWidths(self) -> typing.List[int]: ...
    def createColumn(self, rootIndex: PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QAbstractItemView: ...
    def currentChanged(self, current: PySide2.QtCore.QModelIndex, previous: PySide2.QtCore.QModelIndex) -> None: ...
    def horizontalOffset(self) -> int: ...
    def indexAt(self, point: PySide2.QtCore.QPoint) -> PySide2.QtCore.QModelIndex: ...
    def initializeColumn(self, column: PySide2.QtWidgets.QAbstractItemView) -> None: ...
    def isIndexHidden(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def moveCursor(self, cursorAction: PySide2.QtWidgets.QAbstractItemView.CursorAction, modifiers: PySide2.QtCore.Qt.KeyboardModifiers) -> PySide2.QtCore.QModelIndex: ...
    def previewWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent) -> None: ...
    def resizeGripsVisible(self) -> bool: ...
    def rowsInserted(self, parent: PySide2.QtCore.QModelIndex, start: int, end: int) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def scrollTo(self, index: PySide2.QtCore.QModelIndex, hint: PySide2.QtWidgets.QAbstractItemView.ScrollHint = ...) -> None: ...
    def selectAll(self) -> None: ...
    def setColumnWidths(self, list: typing.Sequence[int]) -> None: ...
    def setModel(self, model: PySide2.QtCore.QAbstractItemModel) -> None: ...
    def setPreviewWidget(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def setResizeGripsVisible(self, visible: bool) -> None: ...
    def setRootIndex(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setSelection(self, rect: PySide2.QtCore.QRect, command: PySide2.QtCore.QItemSelectionModel.SelectionFlags) -> None: ...
    def setSelectionModel(self, selectionModel: PySide2.QtCore.QItemSelectionModel) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def verticalOffset(self) -> int: ...
    def visualRect(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide2.QtCore.QItemSelection) -> PySide2.QtGui.QRegion: ...


class QComboBox(PySide2.QtWidgets.QWidget):
    NoInsert                 : QComboBox.InsertPolicy = ... # 0x0
    InsertAtTop              : QComboBox.InsertPolicy = ... # 0x1
    InsertAtCurrent          : QComboBox.InsertPolicy = ... # 0x2
    InsertAtBottom           : QComboBox.InsertPolicy = ... # 0x3
    InsertAfterCurrent       : QComboBox.InsertPolicy = ... # 0x4
    InsertBeforeCurrent      : QComboBox.InsertPolicy = ... # 0x5
    InsertAlphabetically     : QComboBox.InsertPolicy = ... # 0x6
    AdjustToContents         : QComboBox.SizeAdjustPolicy = ... # 0x0
    AdjustToContentsOnFirstShow: QComboBox.SizeAdjustPolicy = ... # 0x1
    AdjustToMinimumContentsLength: QComboBox.SizeAdjustPolicy = ... # 0x2
    AdjustToMinimumContentsLengthWithIcon: QComboBox.SizeAdjustPolicy = ... # 0x3

    class InsertPolicy(Shiboken.Enum):
        NoInsert                 : QComboBox.InsertPolicy = ... # 0x0
        InsertAtTop              : QComboBox.InsertPolicy = ... # 0x1
        InsertAtCurrent          : QComboBox.InsertPolicy = ... # 0x2
        InsertAtBottom           : QComboBox.InsertPolicy = ... # 0x3
        InsertAfterCurrent       : QComboBox.InsertPolicy = ... # 0x4
        InsertBeforeCurrent      : QComboBox.InsertPolicy = ... # 0x5
        InsertAlphabetically     : QComboBox.InsertPolicy = ... # 0x6

    class SizeAdjustPolicy(Shiboken.Enum):
        AdjustToContents         : QComboBox.SizeAdjustPolicy = ... # 0x0
        AdjustToContentsOnFirstShow: QComboBox.SizeAdjustPolicy = ... # 0x1
        AdjustToMinimumContentsLength: QComboBox.SizeAdjustPolicy = ... # 0x2
        AdjustToMinimumContentsLengthWithIcon: QComboBox.SizeAdjustPolicy = ... # 0x3

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    @typing.overload
    def addItem(self, icon: PySide2.QtGui.QIcon, text: str, userData: typing.Any = ...) -> None: ...
    @typing.overload
    def addItem(self, text: str, userData: typing.Any = ...) -> None: ...
    def addItems(self, texts: typing.Sequence[str]) -> None: ...
    def autoCompletion(self) -> bool: ...
    def autoCompletionCaseSensitivity(self) -> PySide2.QtCore.Qt.CaseSensitivity: ...
    def changeEvent(self, e: PySide2.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def clearEditText(self) -> None: ...
    def completer(self) -> PySide2.QtWidgets.QCompleter: ...
    def contextMenuEvent(self, e: PySide2.QtGui.QContextMenuEvent) -> None: ...
    def count(self) -> int: ...
    def currentData(self, role: int = ...) -> typing.Any: ...
    def currentIndex(self) -> int: ...
    def currentText(self) -> str: ...
    def duplicatesEnabled(self) -> bool: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def findData(self, data: typing.Any, role: int = ..., flags: PySide2.QtCore.Qt.MatchFlags = ...) -> int: ...
    def findText(self, text: str, flags: PySide2.QtCore.Qt.MatchFlags = ...) -> int: ...
    def focusInEvent(self, e: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, e: PySide2.QtGui.QFocusEvent) -> None: ...
    def hasFrame(self) -> bool: ...
    def hideEvent(self, e: PySide2.QtGui.QHideEvent) -> None: ...
    def hidePopup(self) -> None: ...
    def iconSize(self) -> PySide2.QtCore.QSize: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionComboBox) -> None: ...
    def inputMethodEvent(self, arg__1: PySide2.QtGui.QInputMethodEvent) -> None: ...
    @typing.overload
    def inputMethodQuery(self, arg__1: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    @typing.overload
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery, argument: typing.Any) -> typing.Any: ...
    @typing.overload
    def insertItem(self, index: int, icon: PySide2.QtGui.QIcon, text: str, userData: typing.Any = ...) -> None: ...
    @typing.overload
    def insertItem(self, index: int, text: str, userData: typing.Any = ...) -> None: ...
    def insertItems(self, index: int, texts: typing.Sequence[str]) -> None: ...
    def insertPolicy(self) -> PySide2.QtWidgets.QComboBox.InsertPolicy: ...
    def insertSeparator(self, index: int) -> None: ...
    def isEditable(self) -> bool: ...
    def itemData(self, index: int, role: int = ...) -> typing.Any: ...
    def itemDelegate(self) -> PySide2.QtWidgets.QAbstractItemDelegate: ...
    def itemIcon(self, index: int) -> PySide2.QtGui.QIcon: ...
    def itemText(self, index: int) -> str: ...
    def keyPressEvent(self, e: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, e: PySide2.QtGui.QKeyEvent) -> None: ...
    def lineEdit(self) -> PySide2.QtWidgets.QLineEdit: ...
    def maxCount(self) -> int: ...
    def maxVisibleItems(self) -> int: ...
    def minimumContentsLength(self) -> int: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
    def modelColumn(self) -> int: ...
    def mousePressEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, e: PySide2.QtGui.QPaintEvent) -> None: ...
    def placeholderText(self) -> str: ...
    def removeItem(self, index: int) -> None: ...
    def resizeEvent(self, e: PySide2.QtGui.QResizeEvent) -> None: ...
    def rootModelIndex(self) -> PySide2.QtCore.QModelIndex: ...
    def setAutoCompletion(self, enable: bool) -> None: ...
    def setAutoCompletionCaseSensitivity(self, sensitivity: PySide2.QtCore.Qt.CaseSensitivity) -> None: ...
    def setCompleter(self, c: PySide2.QtWidgets.QCompleter) -> None: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def setCurrentText(self, text: str) -> None: ...
    def setDuplicatesEnabled(self, enable: bool) -> None: ...
    def setEditText(self, text: str) -> None: ...
    def setEditable(self, editable: bool) -> None: ...
    def setFrame(self, arg__1: bool) -> None: ...
    def setIconSize(self, size: PySide2.QtCore.QSize) -> None: ...
    def setInsertPolicy(self, policy: PySide2.QtWidgets.QComboBox.InsertPolicy) -> None: ...
    def setItemData(self, index: int, value: typing.Any, role: int = ...) -> None: ...
    def setItemDelegate(self, delegate: PySide2.QtWidgets.QAbstractItemDelegate) -> None: ...
    def setItemIcon(self, index: int, icon: PySide2.QtGui.QIcon) -> None: ...
    def setItemText(self, index: int, text: str) -> None: ...
    def setLineEdit(self, edit: PySide2.QtWidgets.QLineEdit) -> None: ...
    def setMaxCount(self, max: int) -> None: ...
    def setMaxVisibleItems(self, maxItems: int) -> None: ...
    def setMinimumContentsLength(self, characters: int) -> None: ...
    def setModel(self, model: PySide2.QtCore.QAbstractItemModel) -> None: ...
    def setModelColumn(self, visibleColumn: int) -> None: ...
    def setPlaceholderText(self, placeholderText: str) -> None: ...
    def setRootModelIndex(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setSizeAdjustPolicy(self, policy: PySide2.QtWidgets.QComboBox.SizeAdjustPolicy) -> None: ...
    def setValidator(self, v: PySide2.QtGui.QValidator) -> None: ...
    def setView(self, itemView: PySide2.QtWidgets.QAbstractItemView) -> None: ...
    def showEvent(self, e: PySide2.QtGui.QShowEvent) -> None: ...
    def showPopup(self) -> None: ...
    def sizeAdjustPolicy(self) -> PySide2.QtWidgets.QComboBox.SizeAdjustPolicy: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def validator(self) -> PySide2.QtGui.QValidator: ...
    def view(self) -> PySide2.QtWidgets.QAbstractItemView: ...
    def wheelEvent(self, e: PySide2.QtGui.QWheelEvent) -> None: ...


class QCommandLinkButton(PySide2.QtWidgets.QPushButton):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, description: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def description(self) -> str: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def setDescription(self, description: str) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...


class QCommonStyle(PySide2.QtWidgets.QStyle):

    def __init__(self) -> None: ...

    def drawComplexControl(self, cc: PySide2.QtWidgets.QStyle.ComplexControl, opt: PySide2.QtWidgets.QStyleOptionComplex, p: PySide2.QtGui.QPainter, w: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    def drawControl(self, element: PySide2.QtWidgets.QStyle.ControlElement, opt: PySide2.QtWidgets.QStyleOption, p: PySide2.QtGui.QPainter, w: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    def drawPrimitive(self, pe: PySide2.QtWidgets.QStyle.PrimitiveElement, opt: PySide2.QtWidgets.QStyleOption, p: PySide2.QtGui.QPainter, w: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    def generatedIconPixmap(self, iconMode: PySide2.QtGui.QIcon.Mode, pixmap: PySide2.QtGui.QPixmap, opt: PySide2.QtWidgets.QStyleOption) -> PySide2.QtGui.QPixmap: ...
    def hitTestComplexControl(self, cc: PySide2.QtWidgets.QStyle.ComplexControl, opt: PySide2.QtWidgets.QStyleOptionComplex, pt: PySide2.QtCore.QPoint, w: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> PySide2.QtWidgets.QStyle.SubControl: ...
    def layoutSpacing(self, control1: PySide2.QtWidgets.QSizePolicy.ControlType, control2: PySide2.QtWidgets.QSizePolicy.ControlType, orientation: PySide2.QtCore.Qt.Orientation, option: typing.Optional[PySide2.QtWidgets.QStyleOption] = ..., widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> int: ...
    def pixelMetric(self, m: PySide2.QtWidgets.QStyle.PixelMetric, opt: typing.Optional[PySide2.QtWidgets.QStyleOption] = ..., widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> int: ...
    @typing.overload
    def polish(self, app: PySide2.QtWidgets.QApplication) -> None: ...
    @typing.overload
    def polish(self, application: PySide2.QtWidgets.QApplication) -> None: ...
    @typing.overload
    def polish(self, arg__1: PySide2.QtGui.QPalette) -> None: ...
    @typing.overload
    def polish(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def sizeFromContents(self, ct: PySide2.QtWidgets.QStyle.ContentsType, opt: PySide2.QtWidgets.QStyleOption, contentsSize: PySide2.QtCore.QSize, widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> PySide2.QtCore.QSize: ...
    def standardIcon(self, standardIcon: PySide2.QtWidgets.QStyle.StandardPixmap, opt: typing.Optional[PySide2.QtWidgets.QStyleOption] = ..., widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> PySide2.QtGui.QIcon: ...
    def standardPixmap(self, sp: PySide2.QtWidgets.QStyle.StandardPixmap, opt: typing.Optional[PySide2.QtWidgets.QStyleOption] = ..., widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> PySide2.QtGui.QPixmap: ...
    def styleHint(self, sh: PySide2.QtWidgets.QStyle.StyleHint, opt: typing.Optional[PySide2.QtWidgets.QStyleOption] = ..., w: typing.Optional[PySide2.QtWidgets.QWidget] = ..., shret: typing.Optional[PySide2.QtWidgets.QStyleHintReturn] = ...) -> int: ...
    def subControlRect(self, cc: PySide2.QtWidgets.QStyle.ComplexControl, opt: PySide2.QtWidgets.QStyleOptionComplex, sc: PySide2.QtWidgets.QStyle.SubControl, w: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> PySide2.QtCore.QRect: ...
    def subElementRect(self, r: PySide2.QtWidgets.QStyle.SubElement, opt: PySide2.QtWidgets.QStyleOption, widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def unpolish(self, application: PySide2.QtWidgets.QApplication) -> None: ...
    @typing.overload
    def unpolish(self, widget: PySide2.QtWidgets.QWidget) -> None: ...


class QCompleter(PySide2.QtCore.QObject):
    PopupCompletion          : QCompleter.CompletionMode = ... # 0x0
    UnfilteredPopupCompletion: QCompleter.CompletionMode = ... # 0x1
    InlineCompletion         : QCompleter.CompletionMode = ... # 0x2
    UnsortedModel            : QCompleter.ModelSorting = ... # 0x0
    CaseSensitivelySortedModel: QCompleter.ModelSorting = ... # 0x1
    CaseInsensitivelySortedModel: QCompleter.ModelSorting = ... # 0x2

    class CompletionMode(Shiboken.Enum):
        PopupCompletion          : QCompleter.CompletionMode = ... # 0x0
        UnfilteredPopupCompletion: QCompleter.CompletionMode = ... # 0x1
        InlineCompletion         : QCompleter.CompletionMode = ... # 0x2

    class ModelSorting(Shiboken.Enum):
        UnsortedModel            : QCompleter.ModelSorting = ... # 0x0
        CaseSensitivelySortedModel: QCompleter.ModelSorting = ... # 0x1
        CaseInsensitivelySortedModel: QCompleter.ModelSorting = ... # 0x2

    @typing.overload
    def __init__(self, completions: typing.Sequence[str], parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, model: PySide2.QtCore.QAbstractItemModel, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def caseSensitivity(self) -> PySide2.QtCore.Qt.CaseSensitivity: ...
    def complete(self, rect: PySide2.QtCore.QRect = ...) -> None: ...
    def completionColumn(self) -> int: ...
    def completionCount(self) -> int: ...
    def completionMode(self) -> PySide2.QtWidgets.QCompleter.CompletionMode: ...
    def completionModel(self) -> PySide2.QtCore.QAbstractItemModel: ...
    def completionPrefix(self) -> str: ...
    def completionRole(self) -> int: ...
    def currentCompletion(self) -> str: ...
    def currentIndex(self) -> PySide2.QtCore.QModelIndex: ...
    def currentRow(self) -> int: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, o: PySide2.QtCore.QObject, e: PySide2.QtCore.QEvent) -> bool: ...
    def filterMode(self) -> PySide2.QtCore.Qt.MatchFlags: ...
    def maxVisibleItems(self) -> int: ...
    def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
    def modelSorting(self) -> PySide2.QtWidgets.QCompleter.ModelSorting: ...
    def pathFromIndex(self, index: PySide2.QtCore.QModelIndex) -> str: ...
    def popup(self) -> PySide2.QtWidgets.QAbstractItemView: ...
    def setCaseSensitivity(self, caseSensitivity: PySide2.QtCore.Qt.CaseSensitivity) -> None: ...
    def setCompletionColumn(self, column: int) -> None: ...
    def setCompletionMode(self, mode: PySide2.QtWidgets.QCompleter.CompletionMode) -> None: ...
    def setCompletionPrefix(self, prefix: str) -> None: ...
    def setCompletionRole(self, role: int) -> None: ...
    def setCurrentRow(self, row: int) -> bool: ...
    def setFilterMode(self, filterMode: PySide2.QtCore.Qt.MatchFlags) -> None: ...
    def setMaxVisibleItems(self, maxItems: int) -> None: ...
    def setModel(self, c: PySide2.QtCore.QAbstractItemModel) -> None: ...
    def setModelSorting(self, sorting: PySide2.QtWidgets.QCompleter.ModelSorting) -> None: ...
    def setPopup(self, popup: PySide2.QtWidgets.QAbstractItemView) -> None: ...
    def setWidget(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def setWrapAround(self, wrap: bool) -> None: ...
    def splitPath(self, path: str) -> typing.List[str]: ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...
    def wrapAround(self) -> bool: ...


class QDataWidgetMapper(PySide2.QtCore.QObject):
    AutoSubmit               : QDataWidgetMapper.SubmitPolicy = ... # 0x0
    ManualSubmit             : QDataWidgetMapper.SubmitPolicy = ... # 0x1

    class SubmitPolicy(Shiboken.Enum):
        AutoSubmit               : QDataWidgetMapper.SubmitPolicy = ... # 0x0
        ManualSubmit             : QDataWidgetMapper.SubmitPolicy = ... # 0x1

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    @typing.overload
    def addMapping(self, widget: PySide2.QtWidgets.QWidget, section: int) -> None: ...
    @typing.overload
    def addMapping(self, widget: PySide2.QtWidgets.QWidget, section: int, propertyName: PySide2.QtCore.QByteArray) -> None: ...
    def clearMapping(self) -> None: ...
    def currentIndex(self) -> int: ...
    def itemDelegate(self) -> PySide2.QtWidgets.QAbstractItemDelegate: ...
    def mappedPropertyName(self, widget: PySide2.QtWidgets.QWidget) -> PySide2.QtCore.QByteArray: ...
    def mappedSection(self, widget: PySide2.QtWidgets.QWidget) -> int: ...
    def mappedWidgetAt(self, section: int) -> PySide2.QtWidgets.QWidget: ...
    def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def removeMapping(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def revert(self) -> None: ...
    def rootIndex(self) -> PySide2.QtCore.QModelIndex: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def setCurrentModelIndex(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setItemDelegate(self, delegate: PySide2.QtWidgets.QAbstractItemDelegate) -> None: ...
    def setModel(self, model: PySide2.QtCore.QAbstractItemModel) -> None: ...
    def setOrientation(self, aOrientation: PySide2.QtCore.Qt.Orientation) -> None: ...
    def setRootIndex(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setSubmitPolicy(self, policy: PySide2.QtWidgets.QDataWidgetMapper.SubmitPolicy) -> None: ...
    def submit(self) -> bool: ...
    def submitPolicy(self) -> PySide2.QtWidgets.QDataWidgetMapper.SubmitPolicy: ...
    def toFirst(self) -> None: ...
    def toLast(self) -> None: ...
    def toNext(self) -> None: ...
    def toPrevious(self) -> None: ...


class QDateEdit(PySide2.QtWidgets.QDateTimeEdit):

    @typing.overload
    def __init__(self, date: PySide2.QtCore.QDate, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QDateTimeEdit(PySide2.QtWidgets.QAbstractSpinBox):
    NoSection                : QDateTimeEdit.Section = ... # 0x0
    AmPmSection              : QDateTimeEdit.Section = ... # 0x1
    MSecSection              : QDateTimeEdit.Section = ... # 0x2
    SecondSection            : QDateTimeEdit.Section = ... # 0x4
    MinuteSection            : QDateTimeEdit.Section = ... # 0x8
    HourSection              : QDateTimeEdit.Section = ... # 0x10
    TimeSections_Mask        : QDateTimeEdit.Section = ... # 0x1f
    DaySection               : QDateTimeEdit.Section = ... # 0x100
    MonthSection             : QDateTimeEdit.Section = ... # 0x200
    YearSection              : QDateTimeEdit.Section = ... # 0x400
    DateSections_Mask        : QDateTimeEdit.Section = ... # 0x700

    class Section(Shiboken.Enum):
        NoSection                : QDateTimeEdit.Section = ... # 0x0
        AmPmSection              : QDateTimeEdit.Section = ... # 0x1
        MSecSection              : QDateTimeEdit.Section = ... # 0x2
        SecondSection            : QDateTimeEdit.Section = ... # 0x4
        MinuteSection            : QDateTimeEdit.Section = ... # 0x8
        HourSection              : QDateTimeEdit.Section = ... # 0x10
        TimeSections_Mask        : QDateTimeEdit.Section = ... # 0x1f
        DaySection               : QDateTimeEdit.Section = ... # 0x100
        MonthSection             : QDateTimeEdit.Section = ... # 0x200
        YearSection              : QDateTimeEdit.Section = ... # 0x400
        DateSections_Mask        : QDateTimeEdit.Section = ... # 0x700

    class Sections(object): ...

    @typing.overload
    def __init__(self, d: PySide2.QtCore.QDate, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, dt: PySide2.QtCore.QDateTime, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, t: PySide2.QtCore.QTime, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, val: typing.Any, parserType: type, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def calendar(self) -> PySide2.QtCore.QCalendar: ...
    def calendarPopup(self) -> bool: ...
    def calendarWidget(self) -> PySide2.QtWidgets.QCalendarWidget: ...
    def clear(self) -> None: ...
    def clearMaximumDate(self) -> None: ...
    def clearMaximumDateTime(self) -> None: ...
    def clearMaximumTime(self) -> None: ...
    def clearMinimumDate(self) -> None: ...
    def clearMinimumDateTime(self) -> None: ...
    def clearMinimumTime(self) -> None: ...
    def currentSection(self) -> PySide2.QtWidgets.QDateTimeEdit.Section: ...
    def currentSectionIndex(self) -> int: ...
    def date(self) -> PySide2.QtCore.QDate: ...
    def dateTime(self) -> PySide2.QtCore.QDateTime: ...
    def dateTimeFromText(self, text: str) -> PySide2.QtCore.QDateTime: ...
    def displayFormat(self) -> str: ...
    def displayedSections(self) -> PySide2.QtWidgets.QDateTimeEdit.Sections: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def fixup(self, input: str) -> None: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionSpinBox) -> None: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def maximumDate(self) -> PySide2.QtCore.QDate: ...
    def maximumDateTime(self) -> PySide2.QtCore.QDateTime: ...
    def maximumTime(self) -> PySide2.QtCore.QTime: ...
    def minimumDate(self) -> PySide2.QtCore.QDate: ...
    def minimumDateTime(self) -> PySide2.QtCore.QDateTime: ...
    def minimumTime(self) -> PySide2.QtCore.QTime: ...
    def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent) -> None: ...
    def sectionAt(self, index: int) -> PySide2.QtWidgets.QDateTimeEdit.Section: ...
    def sectionCount(self) -> int: ...
    def sectionText(self, section: PySide2.QtWidgets.QDateTimeEdit.Section) -> str: ...
    def setCalendar(self, calendar: PySide2.QtCore.QCalendar) -> None: ...
    def setCalendarPopup(self, enable: bool) -> None: ...
    def setCalendarWidget(self, calendarWidget: PySide2.QtWidgets.QCalendarWidget) -> None: ...
    def setCurrentSection(self, section: PySide2.QtWidgets.QDateTimeEdit.Section) -> None: ...
    def setCurrentSectionIndex(self, index: int) -> None: ...
    def setDate(self, date: PySide2.QtCore.QDate) -> None: ...
    def setDateRange(self, min: PySide2.QtCore.QDate, max: PySide2.QtCore.QDate) -> None: ...
    def setDateTime(self, dateTime: PySide2.QtCore.QDateTime) -> None: ...
    def setDateTimeRange(self, min: PySide2.QtCore.QDateTime, max: PySide2.QtCore.QDateTime) -> None: ...
    def setDisplayFormat(self, format: str) -> None: ...
    def setMaximumDate(self, max: PySide2.QtCore.QDate) -> None: ...
    def setMaximumDateTime(self, dt: PySide2.QtCore.QDateTime) -> None: ...
    def setMaximumTime(self, max: PySide2.QtCore.QTime) -> None: ...
    def setMinimumDate(self, min: PySide2.QtCore.QDate) -> None: ...
    def setMinimumDateTime(self, dt: PySide2.QtCore.QDateTime) -> None: ...
    def setMinimumTime(self, min: PySide2.QtCore.QTime) -> None: ...
    def setSelectedSection(self, section: PySide2.QtWidgets.QDateTimeEdit.Section) -> None: ...
    def setTime(self, time: PySide2.QtCore.QTime) -> None: ...
    def setTimeRange(self, min: PySide2.QtCore.QTime, max: PySide2.QtCore.QTime) -> None: ...
    def setTimeSpec(self, spec: PySide2.QtCore.Qt.TimeSpec) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def stepBy(self, steps: int) -> None: ...
    def stepEnabled(self) -> PySide2.QtWidgets.QAbstractSpinBox.StepEnabled: ...
    def textFromDateTime(self, dt: PySide2.QtCore.QDateTime) -> str: ...
    def time(self) -> PySide2.QtCore.QTime: ...
    def timeSpec(self) -> PySide2.QtCore.Qt.TimeSpec: ...
    def validate(self, input: str, pos: int) -> PySide2.QtGui.QValidator.State: ...
    def wheelEvent(self, event: PySide2.QtGui.QWheelEvent) -> None: ...


class QDesktopWidget(PySide2.QtWidgets.QWidget):

    def __init__(self) -> None: ...

    @typing.overload
    def availableGeometry(self, point: PySide2.QtCore.QPoint) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def availableGeometry(self, screen: int = ...) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def availableGeometry(self, widget: PySide2.QtWidgets.QWidget) -> PySide2.QtCore.QRect: ...
    def isVirtualDesktop(self) -> bool: ...
    def numScreens(self) -> int: ...
    def primaryScreen(self) -> int: ...
    def resizeEvent(self, e: PySide2.QtGui.QResizeEvent) -> None: ...
    @typing.overload
    def screen(self) -> PySide2.QtGui.QScreen: ...
    @typing.overload
    def screen(self, screen: int = ...) -> PySide2.QtWidgets.QWidget: ...
    def screenCount(self) -> int: ...
    @typing.overload
    def screenGeometry(self, point: PySide2.QtCore.QPoint) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def screenGeometry(self, screen: int = ...) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def screenGeometry(self, widget: PySide2.QtWidgets.QWidget) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def screenNumber(self, arg__1: PySide2.QtCore.QPoint) -> int: ...
    @typing.overload
    def screenNumber(self, widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> int: ...


class QDial(PySide2.QtWidgets.QAbstractSlider):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionSlider) -> None: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, me: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, me: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, me: PySide2.QtGui.QMouseEvent) -> None: ...
    def notchSize(self) -> int: ...
    def notchTarget(self) -> float: ...
    def notchesVisible(self) -> bool: ...
    def paintEvent(self, pe: PySide2.QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, re: PySide2.QtGui.QResizeEvent) -> None: ...
    def setNotchTarget(self, target: float) -> None: ...
    def setNotchesVisible(self, visible: bool) -> None: ...
    def setWrapping(self, on: bool) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def sliderChange(self, change: PySide2.QtWidgets.QAbstractSlider.SliderChange) -> None: ...
    def wrapping(self) -> bool: ...


class QDialog(PySide2.QtWidgets.QWidget):
    Rejected                 : QDialog.DialogCode = ... # 0x0
    Accepted                 : QDialog.DialogCode = ... # 0x1

    class DialogCode(Shiboken.Enum):
        Rejected                 : QDialog.DialogCode = ... # 0x0
        Accepted                 : QDialog.DialogCode = ... # 0x1

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., f: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...

    def accept(self) -> None: ...
    def adjustPosition(self, arg__1: PySide2.QtWidgets.QWidget) -> None: ...
    def closeEvent(self, arg__1: PySide2.QtGui.QCloseEvent) -> None: ...
    def contextMenuEvent(self, arg__1: PySide2.QtGui.QContextMenuEvent) -> None: ...
    def done(self, arg__1: int) -> None: ...
    def eventFilter(self, arg__1: PySide2.QtCore.QObject, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    def exec_(self) -> int: ...
    def extension(self) -> PySide2.QtWidgets.QWidget: ...
    def isSizeGripEnabled(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent) -> None: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def open(self) -> None: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def reject(self) -> None: ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent) -> None: ...
    def result(self) -> int: ...
    def setExtension(self, extension: PySide2.QtWidgets.QWidget) -> None: ...
    def setModal(self, modal: bool) -> None: ...
    def setOrientation(self, orientation: PySide2.QtCore.Qt.Orientation) -> None: ...
    def setResult(self, r: int) -> None: ...
    def setSizeGripEnabled(self, arg__1: bool) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def showEvent(self, arg__1: PySide2.QtGui.QShowEvent) -> None: ...
    def showExtension(self, arg__1: bool) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...


class QDialogButtonBox(PySide2.QtWidgets.QWidget):
    WinLayout                : QDialogButtonBox.ButtonLayout = ... # 0x0
    MacLayout                : QDialogButtonBox.ButtonLayout = ... # 0x1
    KdeLayout                : QDialogButtonBox.ButtonLayout = ... # 0x2
    GnomeLayout              : QDialogButtonBox.ButtonLayout = ... # 0x3
    AndroidLayout            : QDialogButtonBox.ButtonLayout = ... # 0x5
    InvalidRole              : QDialogButtonBox.ButtonRole = ... # -0x1
    AcceptRole               : QDialogButtonBox.ButtonRole = ... # 0x0
    RejectRole               : QDialogButtonBox.ButtonRole = ... # 0x1
    DestructiveRole          : QDialogButtonBox.ButtonRole = ... # 0x2
    ActionRole               : QDialogButtonBox.ButtonRole = ... # 0x3
    HelpRole                 : QDialogButtonBox.ButtonRole = ... # 0x4
    YesRole                  : QDialogButtonBox.ButtonRole = ... # 0x5
    NoRole                   : QDialogButtonBox.ButtonRole = ... # 0x6
    ResetRole                : QDialogButtonBox.ButtonRole = ... # 0x7
    ApplyRole                : QDialogButtonBox.ButtonRole = ... # 0x8
    NRoles                   : QDialogButtonBox.ButtonRole = ... # 0x9
    NoButton                 : QDialogButtonBox.StandardButton = ... # 0x0
    FirstButton              : QDialogButtonBox.StandardButton = ... # 0x400
    Ok                       : QDialogButtonBox.StandardButton = ... # 0x400
    Save                     : QDialogButtonBox.StandardButton = ... # 0x800
    SaveAll                  : QDialogButtonBox.StandardButton = ... # 0x1000
    Open                     : QDialogButtonBox.StandardButton = ... # 0x2000
    Yes                      : QDialogButtonBox.StandardButton = ... # 0x4000
    YesToAll                 : QDialogButtonBox.StandardButton = ... # 0x8000
    No                       : QDialogButtonBox.StandardButton = ... # 0x10000
    NoToAll                  : QDialogButtonBox.StandardButton = ... # 0x20000
    Abort                    : QDialogButtonBox.StandardButton = ... # 0x40000
    Retry                    : QDialogButtonBox.StandardButton = ... # 0x80000
    Ignore                   : QDialogButtonBox.StandardButton = ... # 0x100000
    Close                    : QDialogButtonBox.StandardButton = ... # 0x200000
    Cancel                   : QDialogButtonBox.StandardButton = ... # 0x400000
    Discard                  : QDialogButtonBox.StandardButton = ... # 0x800000
    Help                     : QDialogButtonBox.StandardButton = ... # 0x1000000
    Apply                    : QDialogButtonBox.StandardButton = ... # 0x2000000
    Reset                    : QDialogButtonBox.StandardButton = ... # 0x4000000
    LastButton               : QDialogButtonBox.StandardButton = ... # 0x8000000
    RestoreDefaults          : QDialogButtonBox.StandardButton = ... # 0x8000000

    class ButtonLayout(Shiboken.Enum):
        WinLayout                : QDialogButtonBox.ButtonLayout = ... # 0x0
        MacLayout                : QDialogButtonBox.ButtonLayout = ... # 0x1
        KdeLayout                : QDialogButtonBox.ButtonLayout = ... # 0x2
        GnomeLayout              : QDialogButtonBox.ButtonLayout = ... # 0x3
        AndroidLayout            : QDialogButtonBox.ButtonLayout = ... # 0x5

    class ButtonRole(Shiboken.Enum):
        InvalidRole              : QDialogButtonBox.ButtonRole = ... # -0x1
        AcceptRole               : QDialogButtonBox.ButtonRole = ... # 0x0
        RejectRole               : QDialogButtonBox.ButtonRole = ... # 0x1
        DestructiveRole          : QDialogButtonBox.ButtonRole = ... # 0x2
        ActionRole               : QDialogButtonBox.ButtonRole = ... # 0x3
        HelpRole                 : QDialogButtonBox.ButtonRole = ... # 0x4
        YesRole                  : QDialogButtonBox.ButtonRole = ... # 0x5
        NoRole                   : QDialogButtonBox.ButtonRole = ... # 0x6
        ResetRole                : QDialogButtonBox.ButtonRole = ... # 0x7
        ApplyRole                : QDialogButtonBox.ButtonRole = ... # 0x8
        NRoles                   : QDialogButtonBox.ButtonRole = ... # 0x9

    class StandardButton(Shiboken.Enum):
        NoButton                 : QDialogButtonBox.StandardButton = ... # 0x0
        FirstButton              : QDialogButtonBox.StandardButton = ... # 0x400
        Ok                       : QDialogButtonBox.StandardButton = ... # 0x400
        Save                     : QDialogButtonBox.StandardButton = ... # 0x800
        SaveAll                  : QDialogButtonBox.StandardButton = ... # 0x1000
        Open                     : QDialogButtonBox.StandardButton = ... # 0x2000
        Yes                      : QDialogButtonBox.StandardButton = ... # 0x4000
        YesToAll                 : QDialogButtonBox.StandardButton = ... # 0x8000
        No                       : QDialogButtonBox.StandardButton = ... # 0x10000
        NoToAll                  : QDialogButtonBox.StandardButton = ... # 0x20000
        Abort                    : QDialogButtonBox.StandardButton = ... # 0x40000
        Retry                    : QDialogButtonBox.StandardButton = ... # 0x80000
        Ignore                   : QDialogButtonBox.StandardButton = ... # 0x100000
        Close                    : QDialogButtonBox.StandardButton = ... # 0x200000
        Cancel                   : QDialogButtonBox.StandardButton = ... # 0x400000
        Discard                  : QDialogButtonBox.StandardButton = ... # 0x800000
        Help                     : QDialogButtonBox.StandardButton = ... # 0x1000000
        Apply                    : QDialogButtonBox.StandardButton = ... # 0x2000000
        Reset                    : QDialogButtonBox.StandardButton = ... # 0x4000000
        LastButton               : QDialogButtonBox.StandardButton = ... # 0x8000000
        RestoreDefaults          : QDialogButtonBox.StandardButton = ... # 0x8000000

    class StandardButtons(object): ...

    @typing.overload
    def __init__(self, buttons: PySide2.QtWidgets.QDialogButtonBox.StandardButtons, orientation: PySide2.QtCore.Qt.Orientation, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, buttons: PySide2.QtWidgets.QDialogButtonBox.StandardButtons, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, orientation: PySide2.QtCore.Qt.Orientation, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    @typing.overload
    def addButton(self, button: PySide2.QtWidgets.QAbstractButton, role: PySide2.QtWidgets.QDialogButtonBox.ButtonRole) -> None: ...
    @typing.overload
    def addButton(self, button: PySide2.QtWidgets.QDialogButtonBox.StandardButton) -> PySide2.QtWidgets.QPushButton: ...
    @typing.overload
    def addButton(self, text: str, role: PySide2.QtWidgets.QDialogButtonBox.ButtonRole) -> PySide2.QtWidgets.QPushButton: ...
    def button(self, which: PySide2.QtWidgets.QDialogButtonBox.StandardButton) -> PySide2.QtWidgets.QPushButton: ...
    def buttonRole(self, button: PySide2.QtWidgets.QAbstractButton) -> PySide2.QtWidgets.QDialogButtonBox.ButtonRole: ...
    def buttons(self) -> typing.List[PySide2.QtWidgets.QAbstractButton]: ...
    def centerButtons(self) -> bool: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def removeButton(self, button: PySide2.QtWidgets.QAbstractButton) -> None: ...
    def setCenterButtons(self, center: bool) -> None: ...
    def setOrientation(self, orientation: PySide2.QtCore.Qt.Orientation) -> None: ...
    def setStandardButtons(self, buttons: PySide2.QtWidgets.QDialogButtonBox.StandardButtons) -> None: ...
    def standardButton(self, button: PySide2.QtWidgets.QAbstractButton) -> PySide2.QtWidgets.QDialogButtonBox.StandardButton: ...
    def standardButtons(self) -> PySide2.QtWidgets.QDialogButtonBox.StandardButtons: ...


class QDirModel(PySide2.QtCore.QAbstractItemModel):
    FileIconRole             : QDirModel.Roles = ... # 0x1
    FilePathRole             : QDirModel.Roles = ... # 0x101
    FileNameRole             : QDirModel.Roles = ... # 0x102

    class Roles(Shiboken.Enum):
        FileIconRole             : QDirModel.Roles = ... # 0x1
        FilePathRole             : QDirModel.Roles = ... # 0x101
        FileNameRole             : QDirModel.Roles = ... # 0x102

    @typing.overload
    def __init__(self, nameFilters: typing.Sequence[str], filters: PySide2.QtCore.QDir.Filters, sort: PySide2.QtCore.QDir.SortFlags, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def columnCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def data(self, index: PySide2.QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def dropMimeData(self, data: PySide2.QtCore.QMimeData, action: PySide2.QtCore.Qt.DropAction, row: int, column: int, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def fileIcon(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtGui.QIcon: ...
    def fileInfo(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QFileInfo: ...
    def fileName(self, index: PySide2.QtCore.QModelIndex) -> str: ...
    def filePath(self, index: PySide2.QtCore.QModelIndex) -> str: ...
    def filter(self) -> PySide2.QtCore.QDir.Filters: ...
    def flags(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.Qt.ItemFlags: ...
    def hasChildren(self, index: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def headerData(self, section: int, orientation: PySide2.QtCore.Qt.Orientation, role: int = ...) -> typing.Any: ...
    def iconProvider(self) -> PySide2.QtWidgets.QFileIconProvider: ...
    @typing.overload
    def index(self, path: str, column: int = ...) -> PySide2.QtCore.QModelIndex: ...
    @typing.overload
    def index(self, row: int, column: int, parent: PySide2.QtCore.QModelIndex = ...) -> PySide2.QtCore.QModelIndex: ...
    def isDir(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def lazyChildCount(self) -> bool: ...
    def mimeData(self, indexes: typing.List[int]) -> PySide2.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    def mkdir(self, parent: PySide2.QtCore.QModelIndex, name: str) -> PySide2.QtCore.QModelIndex: ...
    def nameFilters(self) -> typing.List[str]: ...
    @typing.overload
    def parent(self) -> PySide2.QtCore.QObject: ...
    @typing.overload
    def parent(self, child: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def refresh(self, parent: PySide2.QtCore.QModelIndex = ...) -> None: ...
    def remove(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def resolveSymlinks(self) -> bool: ...
    def rmdir(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def rowCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def setData(self, index: PySide2.QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def setFilter(self, filters: PySide2.QtCore.QDir.Filters) -> None: ...
    def setIconProvider(self, provider: PySide2.QtWidgets.QFileIconProvider) -> None: ...
    def setLazyChildCount(self, enable: bool) -> None: ...
    def setNameFilters(self, filters: typing.Sequence[str]) -> None: ...
    def setReadOnly(self, enable: bool) -> None: ...
    def setResolveSymlinks(self, enable: bool) -> None: ...
    def setSorting(self, sort: PySide2.QtCore.QDir.SortFlags) -> None: ...
    def sort(self, column: int, order: PySide2.QtCore.Qt.SortOrder = ...) -> None: ...
    def sorting(self) -> PySide2.QtCore.QDir.SortFlags: ...
    def supportedDropActions(self) -> PySide2.QtCore.Qt.DropActions: ...


class QDockWidget(PySide2.QtWidgets.QWidget):
    NoDockWidgetFeatures     : QDockWidget.DockWidgetFeature = ... # 0x0
    DockWidgetClosable       : QDockWidget.DockWidgetFeature = ... # 0x1
    DockWidgetMovable        : QDockWidget.DockWidgetFeature = ... # 0x2
    DockWidgetFloatable      : QDockWidget.DockWidgetFeature = ... # 0x4
    AllDockWidgetFeatures    : QDockWidget.DockWidgetFeature = ... # 0x7
    DockWidgetVerticalTitleBar: QDockWidget.DockWidgetFeature = ... # 0x8
    DockWidgetFeatureMask    : QDockWidget.DockWidgetFeature = ... # 0xf
    Reserved                 : QDockWidget.DockWidgetFeature = ... # 0xff

    class DockWidgetFeature(Shiboken.Enum):
        NoDockWidgetFeatures     : QDockWidget.DockWidgetFeature = ... # 0x0
        DockWidgetClosable       : QDockWidget.DockWidgetFeature = ... # 0x1
        DockWidgetMovable        : QDockWidget.DockWidgetFeature = ... # 0x2
        DockWidgetFloatable      : QDockWidget.DockWidgetFeature = ... # 0x4
        AllDockWidgetFeatures    : QDockWidget.DockWidgetFeature = ... # 0x7
        DockWidgetVerticalTitleBar: QDockWidget.DockWidgetFeature = ... # 0x8
        DockWidgetFeatureMask    : QDockWidget.DockWidgetFeature = ... # 0xf
        Reserved                 : QDockWidget.DockWidgetFeature = ... # 0xff

    class DockWidgetFeatures(object): ...

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...
    @typing.overload
    def __init__(self, title: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...

    def allowedAreas(self) -> PySide2.QtCore.Qt.DockWidgetAreas: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def closeEvent(self, event: PySide2.QtGui.QCloseEvent) -> None: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def features(self) -> PySide2.QtWidgets.QDockWidget.DockWidgetFeatures: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionDockWidget) -> None: ...
    def isAreaAllowed(self, area: PySide2.QtCore.Qt.DockWidgetArea) -> bool: ...
    def isFloating(self) -> bool: ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent) -> None: ...
    def setAllowedAreas(self, areas: PySide2.QtCore.Qt.DockWidgetAreas) -> None: ...
    def setFeatures(self, features: PySide2.QtWidgets.QDockWidget.DockWidgetFeatures) -> None: ...
    def setFloating(self, floating: bool) -> None: ...
    def setTitleBarWidget(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def setWidget(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def titleBarWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def toggleViewAction(self) -> PySide2.QtWidgets.QAction: ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...


class QDoubleSpinBox(PySide2.QtWidgets.QAbstractSpinBox):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def cleanText(self) -> str: ...
    def decimals(self) -> int: ...
    def fixup(self, str: str) -> None: ...
    def maximum(self) -> float: ...
    def minimum(self) -> float: ...
    def prefix(self) -> str: ...
    def setDecimals(self, prec: int) -> None: ...
    def setMaximum(self, max: float) -> None: ...
    def setMinimum(self, min: float) -> None: ...
    def setPrefix(self, prefix: str) -> None: ...
    def setRange(self, min: float, max: float) -> None: ...
    def setSingleStep(self, val: float) -> None: ...
    def setStepType(self, stepType: PySide2.QtWidgets.QAbstractSpinBox.StepType) -> None: ...
    def setSuffix(self, suffix: str) -> None: ...
    def setValue(self, val: float) -> None: ...
    def singleStep(self) -> float: ...
    def stepType(self) -> PySide2.QtWidgets.QAbstractSpinBox.StepType: ...
    def suffix(self) -> str: ...
    def textFromValue(self, val: float) -> str: ...
    def validate(self, input: str, pos: int) -> PySide2.QtGui.QValidator.State: ...
    def value(self) -> float: ...
    def valueFromText(self, text: str) -> float: ...


class QErrorMessage(PySide2.QtWidgets.QDialog):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def changeEvent(self, e: PySide2.QtCore.QEvent) -> None: ...
    def done(self, arg__1: int) -> None: ...
    @staticmethod
    def qtHandler() -> PySide2.QtWidgets.QErrorMessage: ...
    @typing.overload
    def showMessage(self, message: str) -> None: ...
    @typing.overload
    def showMessage(self, message: str, type: str) -> None: ...


class QFileDialog(PySide2.QtWidgets.QDialog):
    AcceptOpen               : QFileDialog.AcceptMode = ... # 0x0
    AcceptSave               : QFileDialog.AcceptMode = ... # 0x1
    LookIn                   : QFileDialog.DialogLabel = ... # 0x0
    FileName                 : QFileDialog.DialogLabel = ... # 0x1
    FileType                 : QFileDialog.DialogLabel = ... # 0x2
    Accept                   : QFileDialog.DialogLabel = ... # 0x3
    Reject                   : QFileDialog.DialogLabel = ... # 0x4
    AnyFile                  : QFileDialog.FileMode = ... # 0x0
    ExistingFile             : QFileDialog.FileMode = ... # 0x1
    Directory                : QFileDialog.FileMode = ... # 0x2
    ExistingFiles            : QFileDialog.FileMode = ... # 0x3
    DirectoryOnly            : QFileDialog.FileMode = ... # 0x4
    ShowDirsOnly             : QFileDialog.Option = ... # 0x1
    DontResolveSymlinks      : QFileDialog.Option = ... # 0x2
    DontConfirmOverwrite     : QFileDialog.Option = ... # 0x4
    DontUseSheet             : QFileDialog.Option = ... # 0x8
    DontUseNativeDialog      : QFileDialog.Option = ... # 0x10
    ReadOnly                 : QFileDialog.Option = ... # 0x20
    HideNameFilterDetails    : QFileDialog.Option = ... # 0x40
    DontUseCustomDirectoryIcons: QFileDialog.Option = ... # 0x80
    Detail                   : QFileDialog.ViewMode = ... # 0x0
    List                     : QFileDialog.ViewMode = ... # 0x1

    class AcceptMode(Shiboken.Enum):
        AcceptOpen               : QFileDialog.AcceptMode = ... # 0x0
        AcceptSave               : QFileDialog.AcceptMode = ... # 0x1

    class DialogLabel(Shiboken.Enum):
        LookIn                   : QFileDialog.DialogLabel = ... # 0x0
        FileName                 : QFileDialog.DialogLabel = ... # 0x1
        FileType                 : QFileDialog.DialogLabel = ... # 0x2
        Accept                   : QFileDialog.DialogLabel = ... # 0x3
        Reject                   : QFileDialog.DialogLabel = ... # 0x4

    class FileMode(Shiboken.Enum):
        AnyFile                  : QFileDialog.FileMode = ... # 0x0
        ExistingFile             : QFileDialog.FileMode = ... # 0x1
        Directory                : QFileDialog.FileMode = ... # 0x2
        ExistingFiles            : QFileDialog.FileMode = ... # 0x3
        DirectoryOnly            : QFileDialog.FileMode = ... # 0x4

    class Option(Shiboken.Enum):
        ShowDirsOnly             : QFileDialog.Option = ... # 0x1
        DontResolveSymlinks      : QFileDialog.Option = ... # 0x2
        DontConfirmOverwrite     : QFileDialog.Option = ... # 0x4
        DontUseSheet             : QFileDialog.Option = ... # 0x8
        DontUseNativeDialog      : QFileDialog.Option = ... # 0x10
        ReadOnly                 : QFileDialog.Option = ... # 0x20
        HideNameFilterDetails    : QFileDialog.Option = ... # 0x40
        DontUseCustomDirectoryIcons: QFileDialog.Option = ... # 0x80

    class Options(object): ...

    class ViewMode(Shiboken.Enum):
        Detail                   : QFileDialog.ViewMode = ... # 0x0
        List                     : QFileDialog.ViewMode = ... # 0x1

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget, f: PySide2.QtCore.Qt.WindowFlags) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., caption: str = ..., directory: str = ..., filter: str = ...) -> None: ...

    def accept(self) -> None: ...
    def acceptMode(self) -> PySide2.QtWidgets.QFileDialog.AcceptMode: ...
    def changeEvent(self, e: PySide2.QtCore.QEvent) -> None: ...
    def confirmOverwrite(self) -> bool: ...
    def defaultSuffix(self) -> str: ...
    def directory(self) -> PySide2.QtCore.QDir: ...
    def directoryUrl(self) -> PySide2.QtCore.QUrl: ...
    def done(self, result: int) -> None: ...
    def fileMode(self) -> PySide2.QtWidgets.QFileDialog.FileMode: ...
    def filter(self) -> PySide2.QtCore.QDir.Filters: ...
    @staticmethod
    def getExistingDirectory(parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., caption: str = ..., dir: str = ..., options: PySide2.QtWidgets.QFileDialog.Options = ...) -> str: ...
    @staticmethod
    def getExistingDirectoryUrl(parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., caption: str = ..., dir: PySide2.QtCore.QUrl = ..., options: PySide2.QtWidgets.QFileDialog.Options = ..., supportedSchemes: typing.Sequence[str] = ...) -> PySide2.QtCore.QUrl: ...
    @staticmethod
    def getOpenFileName(parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., caption: str = ..., dir: str = ..., filter: str = ..., options: PySide2.QtWidgets.QFileDialog.Options = ...) -> typing.Tuple[str, str]: ...
    @staticmethod
    def getOpenFileNames(parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., caption: str = ..., dir: str = ..., filter: str = ..., options: PySide2.QtWidgets.QFileDialog.Options = ...) -> typing.Tuple[typing.List[str], str]: ...
    @staticmethod
    def getOpenFileUrl(parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., caption: str = ..., dir: PySide2.QtCore.QUrl = ..., filter: str = ..., options: PySide2.QtWidgets.QFileDialog.Options = ..., supportedSchemes: typing.Sequence[str] = ...) -> typing.Tuple[PySide2.QtCore.QUrl, str]: ...
    @staticmethod
    def getOpenFileUrls(parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., caption: str = ..., dir: PySide2.QtCore.QUrl = ..., filter: str = ..., options: PySide2.QtWidgets.QFileDialog.Options = ..., supportedSchemes: typing.Sequence[str] = ...) -> typing.Tuple[typing.List[PySide2.QtCore.QUrl], str]: ...
    @staticmethod
    def getSaveFileName(parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., caption: str = ..., dir: str = ..., filter: str = ..., options: PySide2.QtWidgets.QFileDialog.Options = ...) -> typing.Tuple[str, str]: ...
    @staticmethod
    def getSaveFileUrl(parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., caption: str = ..., dir: PySide2.QtCore.QUrl = ..., filter: str = ..., options: PySide2.QtWidgets.QFileDialog.Options = ..., supportedSchemes: typing.Sequence[str] = ...) -> typing.Tuple[PySide2.QtCore.QUrl, str]: ...
    def history(self) -> typing.List[str]: ...
    def iconProvider(self) -> PySide2.QtWidgets.QFileIconProvider: ...
    def isNameFilterDetailsVisible(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def itemDelegate(self) -> PySide2.QtWidgets.QAbstractItemDelegate: ...
    def labelText(self, label: PySide2.QtWidgets.QFileDialog.DialogLabel) -> str: ...
    def mimeTypeFilters(self) -> typing.List[str]: ...
    def nameFilters(self) -> typing.List[str]: ...
    @typing.overload
    def open(self) -> None: ...
    @typing.overload
    def open(self, receiver: PySide2.QtCore.QObject, member: bytes) -> None: ...
    def options(self) -> PySide2.QtWidgets.QFileDialog.Options: ...
    def proxyModel(self) -> PySide2.QtCore.QAbstractProxyModel: ...
    def resolveSymlinks(self) -> bool: ...
    def restoreState(self, state: PySide2.QtCore.QByteArray) -> bool: ...
    @staticmethod
    def saveFileContent(fileContent: PySide2.QtCore.QByteArray, fileNameHint: str = ...) -> None: ...
    def saveState(self) -> PySide2.QtCore.QByteArray: ...
    def selectFile(self, filename: str) -> None: ...
    def selectMimeTypeFilter(self, filter: str) -> None: ...
    def selectNameFilter(self, filter: str) -> None: ...
    def selectUrl(self, url: PySide2.QtCore.QUrl) -> None: ...
    def selectedFiles(self) -> typing.List[str]: ...
    def selectedMimeTypeFilter(self) -> str: ...
    def selectedNameFilter(self) -> str: ...
    def selectedUrls(self) -> typing.List[PySide2.QtCore.QUrl]: ...
    def setAcceptMode(self, mode: PySide2.QtWidgets.QFileDialog.AcceptMode) -> None: ...
    def setConfirmOverwrite(self, enabled: bool) -> None: ...
    def setDefaultSuffix(self, suffix: str) -> None: ...
    @typing.overload
    def setDirectory(self, directory: PySide2.QtCore.QDir) -> None: ...
    @typing.overload
    def setDirectory(self, directory: str) -> None: ...
    def setDirectoryUrl(self, directory: PySide2.QtCore.QUrl) -> None: ...
    def setFileMode(self, mode: PySide2.QtWidgets.QFileDialog.FileMode) -> None: ...
    def setFilter(self, filters: PySide2.QtCore.QDir.Filters) -> None: ...
    def setHistory(self, paths: typing.Sequence[str]) -> None: ...
    def setIconProvider(self, provider: PySide2.QtWidgets.QFileIconProvider) -> None: ...
    def setItemDelegate(self, delegate: PySide2.QtWidgets.QAbstractItemDelegate) -> None: ...
    def setLabelText(self, label: PySide2.QtWidgets.QFileDialog.DialogLabel, text: str) -> None: ...
    def setMimeTypeFilters(self, filters: typing.Sequence[str]) -> None: ...
    def setNameFilter(self, filter: str) -> None: ...
    def setNameFilterDetailsVisible(self, enabled: bool) -> None: ...
    def setNameFilters(self, filters: typing.Sequence[str]) -> None: ...
    def setOption(self, option: PySide2.QtWidgets.QFileDialog.Option, on: bool = ...) -> None: ...
    def setOptions(self, options: PySide2.QtWidgets.QFileDialog.Options) -> None: ...
    def setProxyModel(self, model: PySide2.QtCore.QAbstractProxyModel) -> None: ...
    def setReadOnly(self, enabled: bool) -> None: ...
    def setResolveSymlinks(self, enabled: bool) -> None: ...
    def setSidebarUrls(self, urls: typing.Sequence[PySide2.QtCore.QUrl]) -> None: ...
    def setSupportedSchemes(self, schemes: typing.Sequence[str]) -> None: ...
    def setViewMode(self, mode: PySide2.QtWidgets.QFileDialog.ViewMode) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def sidebarUrls(self) -> typing.List[PySide2.QtCore.QUrl]: ...
    def supportedSchemes(self) -> typing.List[str]: ...
    def testOption(self, option: PySide2.QtWidgets.QFileDialog.Option) -> bool: ...
    def viewMode(self) -> PySide2.QtWidgets.QFileDialog.ViewMode: ...


class QFileIconProvider(Shiboken.Object):
    Computer                 : QFileIconProvider.IconType = ... # 0x0
    Desktop                  : QFileIconProvider.IconType = ... # 0x1
    Trashcan                 : QFileIconProvider.IconType = ... # 0x2
    Network                  : QFileIconProvider.IconType = ... # 0x3
    Drive                    : QFileIconProvider.IconType = ... # 0x4
    Folder                   : QFileIconProvider.IconType = ... # 0x5
    File                     : QFileIconProvider.IconType = ... # 0x6
    DontUseCustomDirectoryIcons: QFileIconProvider.Option = ... # 0x1

    class IconType(Shiboken.Enum):
        Computer                 : QFileIconProvider.IconType = ... # 0x0
        Desktop                  : QFileIconProvider.IconType = ... # 0x1
        Trashcan                 : QFileIconProvider.IconType = ... # 0x2
        Network                  : QFileIconProvider.IconType = ... # 0x3
        Drive                    : QFileIconProvider.IconType = ... # 0x4
        Folder                   : QFileIconProvider.IconType = ... # 0x5
        File                     : QFileIconProvider.IconType = ... # 0x6

    class Option(Shiboken.Enum):
        DontUseCustomDirectoryIcons: QFileIconProvider.Option = ... # 0x1

    class Options(object): ...

    def __init__(self) -> None: ...

    @typing.overload
    def icon(self, info: PySide2.QtCore.QFileInfo) -> PySide2.QtGui.QIcon: ...
    @typing.overload
    def icon(self, type: PySide2.QtWidgets.QFileIconProvider.IconType) -> PySide2.QtGui.QIcon: ...
    def options(self) -> PySide2.QtWidgets.QFileIconProvider.Options: ...
    def setOptions(self, options: PySide2.QtWidgets.QFileIconProvider.Options) -> None: ...
    def type(self, info: PySide2.QtCore.QFileInfo) -> str: ...


class QFileSystemModel(PySide2.QtCore.QAbstractItemModel):
    DontWatchForChanges      : QFileSystemModel.Option = ... # 0x1
    DontResolveSymlinks      : QFileSystemModel.Option = ... # 0x2
    DontUseCustomDirectoryIcons: QFileSystemModel.Option = ... # 0x4
    FileIconRole             : QFileSystemModel.Roles = ... # 0x1
    FilePathRole             : QFileSystemModel.Roles = ... # 0x101
    FileNameRole             : QFileSystemModel.Roles = ... # 0x102
    FilePermissions          : QFileSystemModel.Roles = ... # 0x103

    class Option(Shiboken.Enum):
        DontWatchForChanges      : QFileSystemModel.Option = ... # 0x1
        DontResolveSymlinks      : QFileSystemModel.Option = ... # 0x2
        DontUseCustomDirectoryIcons: QFileSystemModel.Option = ... # 0x4

    class Options(object): ...

    class Roles(Shiboken.Enum):
        FileIconRole             : QFileSystemModel.Roles = ... # 0x1
        FilePathRole             : QFileSystemModel.Roles = ... # 0x101
        FileNameRole             : QFileSystemModel.Roles = ... # 0x102
        FilePermissions          : QFileSystemModel.Roles = ... # 0x103

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def canFetchMore(self, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def columnCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def data(self, index: PySide2.QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def dropMimeData(self, data: PySide2.QtCore.QMimeData, action: PySide2.QtCore.Qt.DropAction, row: int, column: int, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def fetchMore(self, parent: PySide2.QtCore.QModelIndex) -> None: ...
    def fileIcon(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtGui.QIcon: ...
    def fileInfo(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QFileInfo: ...
    def fileName(self, index: PySide2.QtCore.QModelIndex) -> str: ...
    def filePath(self, index: PySide2.QtCore.QModelIndex) -> str: ...
    def filter(self) -> PySide2.QtCore.QDir.Filters: ...
    def flags(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.Qt.ItemFlags: ...
    def hasChildren(self, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def headerData(self, section: int, orientation: PySide2.QtCore.Qt.Orientation, role: int = ...) -> typing.Any: ...
    def iconProvider(self) -> PySide2.QtWidgets.QFileIconProvider: ...
    @typing.overload
    def index(self, path: str, column: int = ...) -> PySide2.QtCore.QModelIndex: ...
    @typing.overload
    def index(self, row: int, column: int, parent: PySide2.QtCore.QModelIndex = ...) -> PySide2.QtCore.QModelIndex: ...
    def isDir(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def lastModified(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QDateTime: ...
    def mimeData(self, indexes: typing.List[int]) -> PySide2.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    def mkdir(self, parent: PySide2.QtCore.QModelIndex, name: str) -> PySide2.QtCore.QModelIndex: ...
    def myComputer(self, role: int = ...) -> typing.Any: ...
    def nameFilterDisables(self) -> bool: ...
    def nameFilters(self) -> typing.List[str]: ...
    def options(self) -> PySide2.QtWidgets.QFileSystemModel.Options: ...
    @typing.overload
    def parent(self) -> PySide2.QtCore.QObject: ...
    @typing.overload
    def parent(self, child: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def remove(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def resolveSymlinks(self) -> bool: ...
    def rmdir(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def rootDirectory(self) -> PySide2.QtCore.QDir: ...
    def rootPath(self) -> str: ...
    def rowCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def setData(self, index: PySide2.QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def setFilter(self, filters: PySide2.QtCore.QDir.Filters) -> None: ...
    def setIconProvider(self, provider: PySide2.QtWidgets.QFileIconProvider) -> None: ...
    def setNameFilterDisables(self, enable: bool) -> None: ...
    def setNameFilters(self, filters: typing.Sequence[str]) -> None: ...
    def setOption(self, option: PySide2.QtWidgets.QFileSystemModel.Option, on: bool = ...) -> None: ...
    def setOptions(self, options: PySide2.QtWidgets.QFileSystemModel.Options) -> None: ...
    def setReadOnly(self, enable: bool) -> None: ...
    def setResolveSymlinks(self, enable: bool) -> None: ...
    def setRootPath(self, path: str) -> PySide2.QtCore.QModelIndex: ...
    def sibling(self, row: int, column: int, idx: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def size(self, index: PySide2.QtCore.QModelIndex) -> int: ...
    def sort(self, column: int, order: PySide2.QtCore.Qt.SortOrder = ...) -> None: ...
    def supportedDropActions(self) -> PySide2.QtCore.Qt.DropActions: ...
    def testOption(self, option: PySide2.QtWidgets.QFileSystemModel.Option) -> bool: ...
    def timerEvent(self, event: PySide2.QtCore.QTimerEvent) -> None: ...
    def type(self, index: PySide2.QtCore.QModelIndex) -> str: ...


class QFocusFrame(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1: PySide2.QtCore.QObject, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOption) -> None: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def setWidget(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...


class QFontComboBox(PySide2.QtWidgets.QComboBox):
    AllFonts                 : QFontComboBox.FontFilter = ... # 0x0
    ScalableFonts            : QFontComboBox.FontFilter = ... # 0x1
    NonScalableFonts         : QFontComboBox.FontFilter = ... # 0x2
    MonospacedFonts          : QFontComboBox.FontFilter = ... # 0x4
    ProportionalFonts        : QFontComboBox.FontFilter = ... # 0x8

    class FontFilter(Shiboken.Enum):
        AllFonts                 : QFontComboBox.FontFilter = ... # 0x0
        ScalableFonts            : QFontComboBox.FontFilter = ... # 0x1
        NonScalableFonts         : QFontComboBox.FontFilter = ... # 0x2
        MonospacedFonts          : QFontComboBox.FontFilter = ... # 0x4
        ProportionalFonts        : QFontComboBox.FontFilter = ... # 0x8

    class FontFilters(object): ...

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def currentFont(self) -> PySide2.QtGui.QFont: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def fontFilters(self) -> PySide2.QtWidgets.QFontComboBox.FontFilters: ...
    def setCurrentFont(self, f: PySide2.QtGui.QFont) -> None: ...
    def setFontFilters(self, filters: PySide2.QtWidgets.QFontComboBox.FontFilters) -> None: ...
    def setWritingSystem(self, arg__1: PySide2.QtGui.QFontDatabase.WritingSystem) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def writingSystem(self) -> PySide2.QtGui.QFontDatabase.WritingSystem: ...


class QFontDialog(PySide2.QtWidgets.QDialog):
    NoButtons                : QFontDialog.FontDialogOption = ... # 0x1
    DontUseNativeDialog      : QFontDialog.FontDialogOption = ... # 0x2
    ScalableFonts            : QFontDialog.FontDialogOption = ... # 0x4
    NonScalableFonts         : QFontDialog.FontDialogOption = ... # 0x8
    MonospacedFonts          : QFontDialog.FontDialogOption = ... # 0x10
    ProportionalFonts        : QFontDialog.FontDialogOption = ... # 0x20

    class FontDialogOption(Shiboken.Enum):
        NoButtons                : QFontDialog.FontDialogOption = ... # 0x1
        DontUseNativeDialog      : QFontDialog.FontDialogOption = ... # 0x2
        ScalableFonts            : QFontDialog.FontDialogOption = ... # 0x4
        NonScalableFonts         : QFontDialog.FontDialogOption = ... # 0x8
        MonospacedFonts          : QFontDialog.FontDialogOption = ... # 0x10
        ProportionalFonts        : QFontDialog.FontDialogOption = ... # 0x20

    class FontDialogOptions(object): ...

    @typing.overload
    def __init__(self, initial: PySide2.QtGui.QFont, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def changeEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def currentFont(self) -> PySide2.QtGui.QFont: ...
    def done(self, result: int) -> None: ...
    def eventFilter(self, object: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    @typing.overload
    @staticmethod
    def getFont(initial: PySide2.QtGui.QFont, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., title: str = ..., options: PySide2.QtWidgets.QFontDialog.FontDialogOptions = ...) -> typing.Tuple[bool, PySide2.QtGui.QFont]: ...
    @typing.overload
    @staticmethod
    def getFont(parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> typing.Tuple[bool, PySide2.QtGui.QFont]: ...
    @typing.overload
    def open(self) -> None: ...
    @typing.overload
    def open(self, receiver: PySide2.QtCore.QObject, member: bytes) -> None: ...
    def options(self) -> PySide2.QtWidgets.QFontDialog.FontDialogOptions: ...
    def selectedFont(self) -> PySide2.QtGui.QFont: ...
    def setCurrentFont(self, font: PySide2.QtGui.QFont) -> None: ...
    def setOption(self, option: PySide2.QtWidgets.QFontDialog.FontDialogOption, on: bool = ...) -> None: ...
    def setOptions(self, options: PySide2.QtWidgets.QFontDialog.FontDialogOptions) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def testOption(self, option: PySide2.QtWidgets.QFontDialog.FontDialogOption) -> bool: ...


class QFormLayout(PySide2.QtWidgets.QLayout):
    FieldsStayAtSizeHint     : QFormLayout.FieldGrowthPolicy = ... # 0x0
    ExpandingFieldsGrow      : QFormLayout.FieldGrowthPolicy = ... # 0x1
    AllNonFixedFieldsGrow    : QFormLayout.FieldGrowthPolicy = ... # 0x2
    LabelRole                : QFormLayout.ItemRole = ... # 0x0
    FieldRole                : QFormLayout.ItemRole = ... # 0x1
    SpanningRole             : QFormLayout.ItemRole = ... # 0x2
    DontWrapRows             : QFormLayout.RowWrapPolicy = ... # 0x0
    WrapLongRows             : QFormLayout.RowWrapPolicy = ... # 0x1
    WrapAllRows              : QFormLayout.RowWrapPolicy = ... # 0x2

    class FieldGrowthPolicy(Shiboken.Enum):
        FieldsStayAtSizeHint     : QFormLayout.FieldGrowthPolicy = ... # 0x0
        ExpandingFieldsGrow      : QFormLayout.FieldGrowthPolicy = ... # 0x1
        AllNonFixedFieldsGrow    : QFormLayout.FieldGrowthPolicy = ... # 0x2

    class ItemRole(Shiboken.Enum):
        LabelRole                : QFormLayout.ItemRole = ... # 0x0
        FieldRole                : QFormLayout.ItemRole = ... # 0x1
        SpanningRole             : QFormLayout.ItemRole = ... # 0x2

    class RowWrapPolicy(Shiboken.Enum):
        DontWrapRows             : QFormLayout.RowWrapPolicy = ... # 0x0
        WrapLongRows             : QFormLayout.RowWrapPolicy = ... # 0x1
        WrapAllRows              : QFormLayout.RowWrapPolicy = ... # 0x2

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def addItem(self, item: PySide2.QtWidgets.QLayoutItem) -> None: ...
    @typing.overload
    def addRow(self, label: PySide2.QtWidgets.QWidget, field: PySide2.QtWidgets.QLayout) -> None: ...
    @typing.overload
    def addRow(self, label: PySide2.QtWidgets.QWidget, field: PySide2.QtWidgets.QWidget) -> None: ...
    @typing.overload
    def addRow(self, labelText: str, field: PySide2.QtWidgets.QLayout) -> None: ...
    @typing.overload
    def addRow(self, labelText: str, field: PySide2.QtWidgets.QWidget) -> None: ...
    @typing.overload
    def addRow(self, layout: PySide2.QtWidgets.QLayout) -> None: ...
    @typing.overload
    def addRow(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def count(self) -> int: ...
    def expandingDirections(self) -> PySide2.QtCore.Qt.Orientations: ...
    def fieldGrowthPolicy(self) -> PySide2.QtWidgets.QFormLayout.FieldGrowthPolicy: ...
    def formAlignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def getItemPosition(self, index: int, rolePtr: PySide2.QtWidgets.QFormLayout.ItemRole) -> int: ...
    def getLayoutPosition(self, layout: PySide2.QtWidgets.QLayout, rolePtr: PySide2.QtWidgets.QFormLayout.ItemRole) -> int: ...
    def getWidgetPosition(self, widget: PySide2.QtWidgets.QWidget, rolePtr: PySide2.QtWidgets.QFormLayout.ItemRole) -> int: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, width: int) -> int: ...
    def horizontalSpacing(self) -> int: ...
    @typing.overload
    def insertRow(self, row: int, label: PySide2.QtWidgets.QWidget, field: PySide2.QtWidgets.QLayout) -> None: ...
    @typing.overload
    def insertRow(self, row: int, label: PySide2.QtWidgets.QWidget, field: PySide2.QtWidgets.QWidget) -> None: ...
    @typing.overload
    def insertRow(self, row: int, labelText: str, field: PySide2.QtWidgets.QLayout) -> None: ...
    @typing.overload
    def insertRow(self, row: int, labelText: str, field: PySide2.QtWidgets.QWidget) -> None: ...
    @typing.overload
    def insertRow(self, row: int, layout: PySide2.QtWidgets.QLayout) -> None: ...
    @typing.overload
    def insertRow(self, row: int, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def invalidate(self) -> None: ...
    @typing.overload
    def itemAt(self, index: int) -> PySide2.QtWidgets.QLayoutItem: ...
    @typing.overload
    def itemAt(self, row: int, role: PySide2.QtWidgets.QFormLayout.ItemRole) -> PySide2.QtWidgets.QLayoutItem: ...
    def labelAlignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    @typing.overload
    def labelForField(self, field: PySide2.QtWidgets.QLayout) -> PySide2.QtWidgets.QWidget: ...
    @typing.overload
    def labelForField(self, field: PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QWidget: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    @typing.overload
    def removeRow(self, layout: PySide2.QtWidgets.QLayout) -> None: ...
    @typing.overload
    def removeRow(self, row: int) -> None: ...
    @typing.overload
    def removeRow(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def rowCount(self) -> int: ...
    def rowWrapPolicy(self) -> PySide2.QtWidgets.QFormLayout.RowWrapPolicy: ...
    def setFieldGrowthPolicy(self, policy: PySide2.QtWidgets.QFormLayout.FieldGrowthPolicy) -> None: ...
    def setFormAlignment(self, alignment: PySide2.QtCore.Qt.Alignment) -> None: ...
    def setGeometry(self, rect: PySide2.QtCore.QRect) -> None: ...
    def setHorizontalSpacing(self, spacing: int) -> None: ...
    def setItem(self, row: int, role: PySide2.QtWidgets.QFormLayout.ItemRole, item: PySide2.QtWidgets.QLayoutItem) -> None: ...
    def setLabelAlignment(self, alignment: PySide2.QtCore.Qt.Alignment) -> None: ...
    def setLayout(self, row: int, role: PySide2.QtWidgets.QFormLayout.ItemRole, layout: PySide2.QtWidgets.QLayout) -> None: ...
    def setRowWrapPolicy(self, policy: PySide2.QtWidgets.QFormLayout.RowWrapPolicy) -> None: ...
    def setSpacing(self, arg__1: int) -> None: ...
    def setVerticalSpacing(self, spacing: int) -> None: ...
    def setWidget(self, row: int, role: PySide2.QtWidgets.QFormLayout.ItemRole, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def spacing(self) -> int: ...
    def takeAt(self, index: int) -> PySide2.QtWidgets.QLayoutItem: ...
    def verticalSpacing(self) -> int: ...


class QFrame(PySide2.QtWidgets.QWidget):
    Plain                    : QFrame.Shadow = ... # 0x10
    Raised                   : QFrame.Shadow = ... # 0x20
    Sunken                   : QFrame.Shadow = ... # 0x30
    NoFrame                  : QFrame.Shape = ... # 0x0
    Box                      : QFrame.Shape = ... # 0x1
    Panel                    : QFrame.Shape = ... # 0x2
    WinPanel                 : QFrame.Shape = ... # 0x3
    HLine                    : QFrame.Shape = ... # 0x4
    VLine                    : QFrame.Shape = ... # 0x5
    StyledPanel              : QFrame.Shape = ... # 0x6
    Shape_Mask               : QFrame.StyleMask = ... # 0xf
    Shadow_Mask              : QFrame.StyleMask = ... # 0xf0

    class Shadow(Shiboken.Enum):
        Plain                    : QFrame.Shadow = ... # 0x10
        Raised                   : QFrame.Shadow = ... # 0x20
        Sunken                   : QFrame.Shadow = ... # 0x30

    class Shape(Shiboken.Enum):
        NoFrame                  : QFrame.Shape = ... # 0x0
        Box                      : QFrame.Shape = ... # 0x1
        Panel                    : QFrame.Shape = ... # 0x2
        WinPanel                 : QFrame.Shape = ... # 0x3
        HLine                    : QFrame.Shape = ... # 0x4
        VLine                    : QFrame.Shape = ... # 0x5
        StyledPanel              : QFrame.Shape = ... # 0x6

    class StyleMask(Shiboken.Enum):
        Shape_Mask               : QFrame.StyleMask = ... # 0xf
        Shadow_Mask              : QFrame.StyleMask = ... # 0xf0

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., f: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...

    def changeEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...
    def drawFrame(self, arg__1: PySide2.QtGui.QPainter) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def frameRect(self) -> PySide2.QtCore.QRect: ...
    def frameShadow(self) -> PySide2.QtWidgets.QFrame.Shadow: ...
    def frameShape(self) -> PySide2.QtWidgets.QFrame.Shape: ...
    def frameStyle(self) -> int: ...
    def frameWidth(self) -> int: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionFrame) -> None: ...
    def lineWidth(self) -> int: ...
    def midLineWidth(self) -> int: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def setFrameRect(self, arg__1: PySide2.QtCore.QRect) -> None: ...
    def setFrameShadow(self, arg__1: PySide2.QtWidgets.QFrame.Shadow) -> None: ...
    def setFrameShape(self, arg__1: PySide2.QtWidgets.QFrame.Shape) -> None: ...
    def setFrameStyle(self, arg__1: int) -> None: ...
    def setLineWidth(self, arg__1: int) -> None: ...
    def setMidLineWidth(self, arg__1: int) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...


class QGesture(PySide2.QtCore.QObject):
    CancelNone               : QGesture.GestureCancelPolicy = ... # 0x0
    CancelAllInContext       : QGesture.GestureCancelPolicy = ... # 0x1

    class GestureCancelPolicy(Shiboken.Enum):
        CancelNone               : QGesture.GestureCancelPolicy = ... # 0x0
        CancelAllInContext       : QGesture.GestureCancelPolicy = ... # 0x1

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def gestureCancelPolicy(self) -> PySide2.QtWidgets.QGesture.GestureCancelPolicy: ...
    def gestureType(self) -> PySide2.QtCore.Qt.GestureType: ...
    def hasHotSpot(self) -> bool: ...
    def hotSpot(self) -> PySide2.QtCore.QPointF: ...
    def setGestureCancelPolicy(self, policy: PySide2.QtWidgets.QGesture.GestureCancelPolicy) -> None: ...
    def setHotSpot(self, value: PySide2.QtCore.QPointF) -> None: ...
    def state(self) -> PySide2.QtCore.Qt.GestureState: ...
    def unsetHotSpot(self) -> None: ...


class QGestureEvent(PySide2.QtCore.QEvent):

    def __init__(self, gestures: typing.Sequence[PySide2.QtWidgets.QGesture]) -> None: ...

    @typing.overload
    def accept(self) -> None: ...
    @typing.overload
    def accept(self, arg__1: PySide2.QtCore.Qt.GestureType) -> None: ...
    @typing.overload
    def accept(self, arg__1: PySide2.QtWidgets.QGesture) -> None: ...
    def activeGestures(self) -> typing.List[PySide2.QtWidgets.QGesture]: ...
    def canceledGestures(self) -> typing.List[PySide2.QtWidgets.QGesture]: ...
    def gesture(self, type: PySide2.QtCore.Qt.GestureType) -> PySide2.QtWidgets.QGesture: ...
    def gestures(self) -> typing.List[PySide2.QtWidgets.QGesture]: ...
    @typing.overload
    def ignore(self) -> None: ...
    @typing.overload
    def ignore(self, arg__1: PySide2.QtCore.Qt.GestureType) -> None: ...
    @typing.overload
    def ignore(self, arg__1: PySide2.QtWidgets.QGesture) -> None: ...
    @typing.overload
    def isAccepted(self) -> bool: ...
    @typing.overload
    def isAccepted(self, arg__1: PySide2.QtCore.Qt.GestureType) -> bool: ...
    @typing.overload
    def isAccepted(self, arg__1: PySide2.QtWidgets.QGesture) -> bool: ...
    def mapToGraphicsScene(self, gesturePoint: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def setAccepted(self, accepted: bool) -> None: ...
    @typing.overload
    def setAccepted(self, arg__1: PySide2.QtCore.Qt.GestureType, arg__2: bool) -> None: ...
    @typing.overload
    def setAccepted(self, arg__1: PySide2.QtWidgets.QGesture, arg__2: bool) -> None: ...
    def setWidget(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...


class QGestureRecognizer(Shiboken.Object):
    Ignore                   : QGestureRecognizer.ResultFlag = ... # 0x1
    MayBeGesture             : QGestureRecognizer.ResultFlag = ... # 0x2
    TriggerGesture           : QGestureRecognizer.ResultFlag = ... # 0x4
    FinishGesture            : QGestureRecognizer.ResultFlag = ... # 0x8
    CancelGesture            : QGestureRecognizer.ResultFlag = ... # 0x10
    ResultState_Mask         : QGestureRecognizer.ResultFlag = ... # 0xff
    ConsumeEventHint         : QGestureRecognizer.ResultFlag = ... # 0x100
    ResultHint_Mask          : QGestureRecognizer.ResultFlag = ... # 0xff00

    class Result(object): ...

    class ResultFlag(Shiboken.Enum):
        Ignore                   : QGestureRecognizer.ResultFlag = ... # 0x1
        MayBeGesture             : QGestureRecognizer.ResultFlag = ... # 0x2
        TriggerGesture           : QGestureRecognizer.ResultFlag = ... # 0x4
        FinishGesture            : QGestureRecognizer.ResultFlag = ... # 0x8
        CancelGesture            : QGestureRecognizer.ResultFlag = ... # 0x10
        ResultState_Mask         : QGestureRecognizer.ResultFlag = ... # 0xff
        ConsumeEventHint         : QGestureRecognizer.ResultFlag = ... # 0x100
        ResultHint_Mask          : QGestureRecognizer.ResultFlag = ... # 0xff00

    def __init__(self) -> None: ...

    def create(self, target: PySide2.QtCore.QObject) -> PySide2.QtWidgets.QGesture: ...
    def recognize(self, state: PySide2.QtWidgets.QGesture, watched: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> PySide2.QtWidgets.QGestureRecognizer.Result: ...
    @staticmethod
    def registerRecognizer(recognizer: PySide2.QtWidgets.QGestureRecognizer) -> PySide2.QtCore.Qt.GestureType: ...
    def reset(self, state: PySide2.QtWidgets.QGesture) -> None: ...
    @staticmethod
    def unregisterRecognizer(type: PySide2.QtCore.Qt.GestureType) -> None: ...


class QGraphicsAnchor(PySide2.QtCore.QObject):
    def setSizePolicy(self, policy: PySide2.QtWidgets.QSizePolicy.Policy) -> None: ...
    def setSpacing(self, spacing: float) -> None: ...
    def sizePolicy(self) -> PySide2.QtWidgets.QSizePolicy.Policy: ...
    def spacing(self) -> float: ...
    def unsetSpacing(self) -> None: ...


class QGraphicsAnchorLayout(PySide2.QtWidgets.QGraphicsLayout):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsLayoutItem] = ...) -> None: ...

    def addAnchor(self, firstItem: PySide2.QtWidgets.QGraphicsLayoutItem, firstEdge: PySide2.QtCore.Qt.AnchorPoint, secondItem: PySide2.QtWidgets.QGraphicsLayoutItem, secondEdge: PySide2.QtCore.Qt.AnchorPoint) -> PySide2.QtWidgets.QGraphicsAnchor: ...
    def addAnchors(self, firstItem: PySide2.QtWidgets.QGraphicsLayoutItem, secondItem: PySide2.QtWidgets.QGraphicsLayoutItem, orientations: PySide2.QtCore.Qt.Orientations = ...) -> None: ...
    def addCornerAnchors(self, firstItem: PySide2.QtWidgets.QGraphicsLayoutItem, firstCorner: PySide2.QtCore.Qt.Corner, secondItem: PySide2.QtWidgets.QGraphicsLayoutItem, secondCorner: PySide2.QtCore.Qt.Corner) -> None: ...
    def anchor(self, firstItem: PySide2.QtWidgets.QGraphicsLayoutItem, firstEdge: PySide2.QtCore.Qt.AnchorPoint, secondItem: PySide2.QtWidgets.QGraphicsLayoutItem, secondEdge: PySide2.QtCore.Qt.AnchorPoint) -> PySide2.QtWidgets.QGraphicsAnchor: ...
    def count(self) -> int: ...
    def horizontalSpacing(self) -> float: ...
    def invalidate(self) -> None: ...
    def itemAt(self, index: int) -> PySide2.QtWidgets.QGraphicsLayoutItem: ...
    def removeAt(self, index: int) -> None: ...
    def setGeometry(self, rect: PySide2.QtCore.QRectF) -> None: ...
    def setHorizontalSpacing(self, spacing: float) -> None: ...
    def setSpacing(self, spacing: float) -> None: ...
    def setVerticalSpacing(self, spacing: float) -> None: ...
    def sizeHint(self, which: PySide2.QtCore.Qt.SizeHint, constraint: PySide2.QtCore.QSizeF = ...) -> PySide2.QtCore.QSizeF: ...
    def verticalSpacing(self) -> float: ...


class QGraphicsBlurEffect(PySide2.QtWidgets.QGraphicsEffect):
    PerformanceHint          : QGraphicsBlurEffect.BlurHint = ... # 0x0
    QualityHint              : QGraphicsBlurEffect.BlurHint = ... # 0x1
    AnimationHint            : QGraphicsBlurEffect.BlurHint = ... # 0x2

    class BlurHint(Shiboken.Enum):
        PerformanceHint          : QGraphicsBlurEffect.BlurHint = ... # 0x0
        QualityHint              : QGraphicsBlurEffect.BlurHint = ... # 0x1
        AnimationHint            : QGraphicsBlurEffect.BlurHint = ... # 0x2

    class BlurHints(object): ...

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def blurHints(self) -> PySide2.QtWidgets.QGraphicsBlurEffect.BlurHints: ...
    def blurRadius(self) -> float: ...
    def boundingRectFor(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def draw(self, painter: PySide2.QtGui.QPainter) -> None: ...
    def setBlurHints(self, hints: PySide2.QtWidgets.QGraphicsBlurEffect.BlurHints) -> None: ...
    def setBlurRadius(self, blurRadius: float) -> None: ...


class QGraphicsColorizeEffect(PySide2.QtWidgets.QGraphicsEffect):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def color(self) -> PySide2.QtGui.QColor: ...
    def draw(self, painter: PySide2.QtGui.QPainter) -> None: ...
    def setColor(self, c: PySide2.QtGui.QColor) -> None: ...
    def setStrength(self, strength: float) -> None: ...
    def strength(self) -> float: ...


class QGraphicsDropShadowEffect(PySide2.QtWidgets.QGraphicsEffect):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def blurRadius(self) -> float: ...
    def boundingRectFor(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def color(self) -> PySide2.QtGui.QColor: ...
    def draw(self, painter: PySide2.QtGui.QPainter) -> None: ...
    def offset(self) -> PySide2.QtCore.QPointF: ...
    def setBlurRadius(self, blurRadius: float) -> None: ...
    def setColor(self, color: PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def setOffset(self, d: float) -> None: ...
    @typing.overload
    def setOffset(self, dx: float, dy: float) -> None: ...
    @typing.overload
    def setOffset(self, ofs: PySide2.QtCore.QPointF) -> None: ...
    def setXOffset(self, dx: float) -> None: ...
    def setYOffset(self, dy: float) -> None: ...
    def xOffset(self) -> float: ...
    def yOffset(self) -> float: ...


class QGraphicsEffect(PySide2.QtCore.QObject):
    SourceAttached           : QGraphicsEffect.ChangeFlag = ... # 0x1
    SourceDetached           : QGraphicsEffect.ChangeFlag = ... # 0x2
    SourceBoundingRectChanged: QGraphicsEffect.ChangeFlag = ... # 0x4
    SourceInvalidated        : QGraphicsEffect.ChangeFlag = ... # 0x8
    NoPad                    : QGraphicsEffect.PixmapPadMode = ... # 0x0
    PadToTransparentBorder   : QGraphicsEffect.PixmapPadMode = ... # 0x1
    PadToEffectiveBoundingRect: QGraphicsEffect.PixmapPadMode = ... # 0x2

    class ChangeFlag(Shiboken.Enum):
        SourceAttached           : QGraphicsEffect.ChangeFlag = ... # 0x1
        SourceDetached           : QGraphicsEffect.ChangeFlag = ... # 0x2
        SourceBoundingRectChanged: QGraphicsEffect.ChangeFlag = ... # 0x4
        SourceInvalidated        : QGraphicsEffect.ChangeFlag = ... # 0x8

    class ChangeFlags(object): ...

    class PixmapPadMode(Shiboken.Enum):
        NoPad                    : QGraphicsEffect.PixmapPadMode = ... # 0x0
        PadToTransparentBorder   : QGraphicsEffect.PixmapPadMode = ... # 0x1
        PadToEffectiveBoundingRect: QGraphicsEffect.PixmapPadMode = ... # 0x2

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def boundingRectFor(self, sourceRect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def draw(self, painter: PySide2.QtGui.QPainter) -> None: ...
    def drawSource(self, painter: PySide2.QtGui.QPainter) -> None: ...
    def isEnabled(self) -> bool: ...
    def setEnabled(self, enable: bool) -> None: ...
    def sourceBoundingRect(self, system: PySide2.QtCore.Qt.CoordinateSystem = ...) -> PySide2.QtCore.QRectF: ...
    def sourceChanged(self, flags: PySide2.QtWidgets.QGraphicsEffect.ChangeFlags) -> None: ...
    def sourceIsPixmap(self) -> bool: ...
    def sourcePixmap(self, system: PySide2.QtCore.Qt.CoordinateSystem = ..., offset: typing.Optional[PySide2.QtCore.QPoint] = ..., mode: PySide2.QtWidgets.QGraphicsEffect.PixmapPadMode = ...) -> PySide2.QtGui.QPixmap: ...
    def update(self) -> None: ...
    def updateBoundingRect(self) -> None: ...


class QGraphicsEllipseItem(PySide2.QtWidgets.QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @typing.overload
    def __init__(self, rect: PySide2.QtCore.QRectF, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @typing.overload
    def __init__(self, x: float, y: float, w: float, h: float, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...

    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def isObscuredBy(self, item: PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    def rect(self) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def setRect(self, rect: PySide2.QtCore.QRectF) -> None: ...
    @typing.overload
    def setRect(self, x: float, y: float, w: float, h: float) -> None: ...
    def setSpanAngle(self, angle: int) -> None: ...
    def setStartAngle(self, angle: int) -> None: ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def spanAngle(self) -> int: ...
    def startAngle(self) -> int: ...
    def type(self) -> int: ...


class QGraphicsGridLayout(PySide2.QtWidgets.QGraphicsLayout):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsLayoutItem] = ...) -> None: ...

    @typing.overload
    def addItem(self, item: PySide2.QtWidgets.QGraphicsLayoutItem, row: int, column: int, alignment: PySide2.QtCore.Qt.Alignment = ...) -> None: ...
    @typing.overload
    def addItem(self, item: PySide2.QtWidgets.QGraphicsLayoutItem, row: int, column: int, rowSpan: int, columnSpan: int, alignment: PySide2.QtCore.Qt.Alignment = ...) -> None: ...
    def alignment(self, item: PySide2.QtWidgets.QGraphicsLayoutItem) -> PySide2.QtCore.Qt.Alignment: ...
    def columnAlignment(self, column: int) -> PySide2.QtCore.Qt.Alignment: ...
    def columnCount(self) -> int: ...
    def columnMaximumWidth(self, column: int) -> float: ...
    def columnMinimumWidth(self, column: int) -> float: ...
    def columnPreferredWidth(self, column: int) -> float: ...
    def columnSpacing(self, column: int) -> float: ...
    def columnStretchFactor(self, column: int) -> int: ...
    def count(self) -> int: ...
    def horizontalSpacing(self) -> float: ...
    def invalidate(self) -> None: ...
    @typing.overload
    def itemAt(self, index: int) -> PySide2.QtWidgets.QGraphicsLayoutItem: ...
    @typing.overload
    def itemAt(self, row: int, column: int) -> PySide2.QtWidgets.QGraphicsLayoutItem: ...
    def removeAt(self, index: int) -> None: ...
    def removeItem(self, item: PySide2.QtWidgets.QGraphicsLayoutItem) -> None: ...
    def rowAlignment(self, row: int) -> PySide2.QtCore.Qt.Alignment: ...
    def rowCount(self) -> int: ...
    def rowMaximumHeight(self, row: int) -> float: ...
    def rowMinimumHeight(self, row: int) -> float: ...
    def rowPreferredHeight(self, row: int) -> float: ...
    def rowSpacing(self, row: int) -> float: ...
    def rowStretchFactor(self, row: int) -> int: ...
    def setAlignment(self, item: PySide2.QtWidgets.QGraphicsLayoutItem, alignment: PySide2.QtCore.Qt.Alignment) -> None: ...
    def setColumnAlignment(self, column: int, alignment: PySide2.QtCore.Qt.Alignment) -> None: ...
    def setColumnFixedWidth(self, column: int, width: float) -> None: ...
    def setColumnMaximumWidth(self, column: int, width: float) -> None: ...
    def setColumnMinimumWidth(self, column: int, width: float) -> None: ...
    def setColumnPreferredWidth(self, column: int, width: float) -> None: ...
    def setColumnSpacing(self, column: int, spacing: float) -> None: ...
    def setColumnStretchFactor(self, column: int, stretch: int) -> None: ...
    def setGeometry(self, rect: PySide2.QtCore.QRectF) -> None: ...
    def setHorizontalSpacing(self, spacing: float) -> None: ...
    def setRowAlignment(self, row: int, alignment: PySide2.QtCore.Qt.Alignment) -> None: ...
    def setRowFixedHeight(self, row: int, height: float) -> None: ...
    def setRowMaximumHeight(self, row: int, height: float) -> None: ...
    def setRowMinimumHeight(self, row: int, height: float) -> None: ...
    def setRowPreferredHeight(self, row: int, height: float) -> None: ...
    def setRowSpacing(self, row: int, spacing: float) -> None: ...
    def setRowStretchFactor(self, row: int, stretch: int) -> None: ...
    def setSpacing(self, spacing: float) -> None: ...
    def setVerticalSpacing(self, spacing: float) -> None: ...
    def sizeHint(self, which: PySide2.QtCore.Qt.SizeHint, constraint: PySide2.QtCore.QSizeF = ...) -> PySide2.QtCore.QSizeF: ...
    def verticalSpacing(self) -> float: ...


class QGraphicsItem(Shiboken.Object):
    NoCache                  : QGraphicsItem.CacheMode = ... # 0x0
    ItemCoordinateCache      : QGraphicsItem.CacheMode = ... # 0x1
    DeviceCoordinateCache    : QGraphicsItem.CacheMode = ... # 0x2
    UserExtension            : QGraphicsItem.Extension = ... # 0x80000000
    ItemPositionChange       : QGraphicsItem.GraphicsItemChange = ... # 0x0
    ItemMatrixChange         : QGraphicsItem.GraphicsItemChange = ... # 0x1
    ItemVisibleChange        : QGraphicsItem.GraphicsItemChange = ... # 0x2
    ItemEnabledChange        : QGraphicsItem.GraphicsItemChange = ... # 0x3
    ItemSelectedChange       : QGraphicsItem.GraphicsItemChange = ... # 0x4
    ItemParentChange         : QGraphicsItem.GraphicsItemChange = ... # 0x5
    ItemChildAddedChange     : QGraphicsItem.GraphicsItemChange = ... # 0x6
    ItemChildRemovedChange   : QGraphicsItem.GraphicsItemChange = ... # 0x7
    ItemTransformChange      : QGraphicsItem.GraphicsItemChange = ... # 0x8
    ItemPositionHasChanged   : QGraphicsItem.GraphicsItemChange = ... # 0x9
    ItemTransformHasChanged  : QGraphicsItem.GraphicsItemChange = ... # 0xa
    ItemSceneChange          : QGraphicsItem.GraphicsItemChange = ... # 0xb
    ItemVisibleHasChanged    : QGraphicsItem.GraphicsItemChange = ... # 0xc
    ItemEnabledHasChanged    : QGraphicsItem.GraphicsItemChange = ... # 0xd
    ItemSelectedHasChanged   : QGraphicsItem.GraphicsItemChange = ... # 0xe
    ItemParentHasChanged     : QGraphicsItem.GraphicsItemChange = ... # 0xf
    ItemSceneHasChanged      : QGraphicsItem.GraphicsItemChange = ... # 0x10
    ItemCursorChange         : QGraphicsItem.GraphicsItemChange = ... # 0x11
    ItemCursorHasChanged     : QGraphicsItem.GraphicsItemChange = ... # 0x12
    ItemToolTipChange        : QGraphicsItem.GraphicsItemChange = ... # 0x13
    ItemToolTipHasChanged    : QGraphicsItem.GraphicsItemChange = ... # 0x14
    ItemFlagsChange          : QGraphicsItem.GraphicsItemChange = ... # 0x15
    ItemFlagsHaveChanged     : QGraphicsItem.GraphicsItemChange = ... # 0x16
    ItemZValueChange         : QGraphicsItem.GraphicsItemChange = ... # 0x17
    ItemZValueHasChanged     : QGraphicsItem.GraphicsItemChange = ... # 0x18
    ItemOpacityChange        : QGraphicsItem.GraphicsItemChange = ... # 0x19
    ItemOpacityHasChanged    : QGraphicsItem.GraphicsItemChange = ... # 0x1a
    ItemScenePositionHasChanged: QGraphicsItem.GraphicsItemChange = ... # 0x1b
    ItemRotationChange       : QGraphicsItem.GraphicsItemChange = ... # 0x1c
    ItemRotationHasChanged   : QGraphicsItem.GraphicsItemChange = ... # 0x1d
    ItemScaleChange          : QGraphicsItem.GraphicsItemChange = ... # 0x1e
    ItemScaleHasChanged      : QGraphicsItem.GraphicsItemChange = ... # 0x1f
    ItemTransformOriginPointChange: QGraphicsItem.GraphicsItemChange = ... # 0x20
    ItemTransformOriginPointHasChanged: QGraphicsItem.GraphicsItemChange = ... # 0x21
    ItemIsMovable            : QGraphicsItem.GraphicsItemFlag = ... # 0x1
    ItemIsSelectable         : QGraphicsItem.GraphicsItemFlag = ... # 0x2
    ItemIsFocusable          : QGraphicsItem.GraphicsItemFlag = ... # 0x4
    ItemClipsToShape         : QGraphicsItem.GraphicsItemFlag = ... # 0x8
    ItemClipsChildrenToShape : QGraphicsItem.GraphicsItemFlag = ... # 0x10
    ItemIgnoresTransformations: QGraphicsItem.GraphicsItemFlag = ... # 0x20
    ItemIgnoresParentOpacity : QGraphicsItem.GraphicsItemFlag = ... # 0x40
    ItemDoesntPropagateOpacityToChildren: QGraphicsItem.GraphicsItemFlag = ... # 0x80
    ItemStacksBehindParent   : QGraphicsItem.GraphicsItemFlag = ... # 0x100
    ItemUsesExtendedStyleOption: QGraphicsItem.GraphicsItemFlag = ... # 0x200
    ItemHasNoContents        : QGraphicsItem.GraphicsItemFlag = ... # 0x400
    ItemSendsGeometryChanges : QGraphicsItem.GraphicsItemFlag = ... # 0x800
    ItemAcceptsInputMethod   : QGraphicsItem.GraphicsItemFlag = ... # 0x1000
    ItemNegativeZStacksBehindParent: QGraphicsItem.GraphicsItemFlag = ... # 0x2000
    ItemIsPanel              : QGraphicsItem.GraphicsItemFlag = ... # 0x4000
    ItemIsFocusScope         : QGraphicsItem.GraphicsItemFlag = ... # 0x8000
    ItemSendsScenePositionChanges: QGraphicsItem.GraphicsItemFlag = ... # 0x10000
    ItemStopsClickFocusPropagation: QGraphicsItem.GraphicsItemFlag = ... # 0x20000
    ItemStopsFocusHandling   : QGraphicsItem.GraphicsItemFlag = ... # 0x40000
    ItemContainsChildrenInShape: QGraphicsItem.GraphicsItemFlag = ... # 0x80000
    NonModal                 : QGraphicsItem.PanelModality = ... # 0x0
    PanelModal               : QGraphicsItem.PanelModality = ... # 0x1
    SceneModal               : QGraphicsItem.PanelModality = ... # 0x2

    class CacheMode(Shiboken.Enum):
        NoCache                  : QGraphicsItem.CacheMode = ... # 0x0
        ItemCoordinateCache      : QGraphicsItem.CacheMode = ... # 0x1
        DeviceCoordinateCache    : QGraphicsItem.CacheMode = ... # 0x2

    class Extension(Shiboken.Enum):
        UserExtension            : QGraphicsItem.Extension = ... # 0x80000000

    class GraphicsItemChange(Shiboken.Enum):
        ItemPositionChange       : QGraphicsItem.GraphicsItemChange = ... # 0x0
        ItemMatrixChange         : QGraphicsItem.GraphicsItemChange = ... # 0x1
        ItemVisibleChange        : QGraphicsItem.GraphicsItemChange = ... # 0x2
        ItemEnabledChange        : QGraphicsItem.GraphicsItemChange = ... # 0x3
        ItemSelectedChange       : QGraphicsItem.GraphicsItemChange = ... # 0x4
        ItemParentChange         : QGraphicsItem.GraphicsItemChange = ... # 0x5
        ItemChildAddedChange     : QGraphicsItem.GraphicsItemChange = ... # 0x6
        ItemChildRemovedChange   : QGraphicsItem.GraphicsItemChange = ... # 0x7
        ItemTransformChange      : QGraphicsItem.GraphicsItemChange = ... # 0x8
        ItemPositionHasChanged   : QGraphicsItem.GraphicsItemChange = ... # 0x9
        ItemTransformHasChanged  : QGraphicsItem.GraphicsItemChange = ... # 0xa
        ItemSceneChange          : QGraphicsItem.GraphicsItemChange = ... # 0xb
        ItemVisibleHasChanged    : QGraphicsItem.GraphicsItemChange = ... # 0xc
        ItemEnabledHasChanged    : QGraphicsItem.GraphicsItemChange = ... # 0xd
        ItemSelectedHasChanged   : QGraphicsItem.GraphicsItemChange = ... # 0xe
        ItemParentHasChanged     : QGraphicsItem.GraphicsItemChange = ... # 0xf
        ItemSceneHasChanged      : QGraphicsItem.GraphicsItemChange = ... # 0x10
        ItemCursorChange         : QGraphicsItem.GraphicsItemChange = ... # 0x11
        ItemCursorHasChanged     : QGraphicsItem.GraphicsItemChange = ... # 0x12
        ItemToolTipChange        : QGraphicsItem.GraphicsItemChange = ... # 0x13
        ItemToolTipHasChanged    : QGraphicsItem.GraphicsItemChange = ... # 0x14
        ItemFlagsChange          : QGraphicsItem.GraphicsItemChange = ... # 0x15
        ItemFlagsHaveChanged     : QGraphicsItem.GraphicsItemChange = ... # 0x16
        ItemZValueChange         : QGraphicsItem.GraphicsItemChange = ... # 0x17
        ItemZValueHasChanged     : QGraphicsItem.GraphicsItemChange = ... # 0x18
        ItemOpacityChange        : QGraphicsItem.GraphicsItemChange = ... # 0x19
        ItemOpacityHasChanged    : QGraphicsItem.GraphicsItemChange = ... # 0x1a
        ItemScenePositionHasChanged: QGraphicsItem.GraphicsItemChange = ... # 0x1b
        ItemRotationChange       : QGraphicsItem.GraphicsItemChange = ... # 0x1c
        ItemRotationHasChanged   : QGraphicsItem.GraphicsItemChange = ... # 0x1d
        ItemScaleChange          : QGraphicsItem.GraphicsItemChange = ... # 0x1e
        ItemScaleHasChanged      : QGraphicsItem.GraphicsItemChange = ... # 0x1f
        ItemTransformOriginPointChange: QGraphicsItem.GraphicsItemChange = ... # 0x20
        ItemTransformOriginPointHasChanged: QGraphicsItem.GraphicsItemChange = ... # 0x21

    class GraphicsItemFlag(Shiboken.Enum):
        ItemIsMovable            : QGraphicsItem.GraphicsItemFlag = ... # 0x1
        ItemIsSelectable         : QGraphicsItem.GraphicsItemFlag = ... # 0x2
        ItemIsFocusable          : QGraphicsItem.GraphicsItemFlag = ... # 0x4
        ItemClipsToShape         : QGraphicsItem.GraphicsItemFlag = ... # 0x8
        ItemClipsChildrenToShape : QGraphicsItem.GraphicsItemFlag = ... # 0x10
        ItemIgnoresTransformations: QGraphicsItem.GraphicsItemFlag = ... # 0x20
        ItemIgnoresParentOpacity : QGraphicsItem.GraphicsItemFlag = ... # 0x40
        ItemDoesntPropagateOpacityToChildren: QGraphicsItem.GraphicsItemFlag = ... # 0x80
        ItemStacksBehindParent   : QGraphicsItem.GraphicsItemFlag = ... # 0x100
        ItemUsesExtendedStyleOption: QGraphicsItem.GraphicsItemFlag = ... # 0x200
        ItemHasNoContents        : QGraphicsItem.GraphicsItemFlag = ... # 0x400
        ItemSendsGeometryChanges : QGraphicsItem.GraphicsItemFlag = ... # 0x800
        ItemAcceptsInputMethod   : QGraphicsItem.GraphicsItemFlag = ... # 0x1000
        ItemNegativeZStacksBehindParent: QGraphicsItem.GraphicsItemFlag = ... # 0x2000
        ItemIsPanel              : QGraphicsItem.GraphicsItemFlag = ... # 0x4000
        ItemIsFocusScope         : QGraphicsItem.GraphicsItemFlag = ... # 0x8000
        ItemSendsScenePositionChanges: QGraphicsItem.GraphicsItemFlag = ... # 0x10000
        ItemStopsClickFocusPropagation: QGraphicsItem.GraphicsItemFlag = ... # 0x20000
        ItemStopsFocusHandling   : QGraphicsItem.GraphicsItemFlag = ... # 0x40000
        ItemContainsChildrenInShape: QGraphicsItem.GraphicsItemFlag = ... # 0x80000

    class GraphicsItemFlags(object): ...

    class PanelModality(Shiboken.Enum):
        NonModal                 : QGraphicsItem.PanelModality = ... # 0x0
        PanelModal               : QGraphicsItem.PanelModality = ... # 0x1
        SceneModal               : QGraphicsItem.PanelModality = ... # 0x2

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...

    def acceptDrops(self) -> bool: ...
    def acceptHoverEvents(self) -> bool: ...
    def acceptTouchEvents(self) -> bool: ...
    def acceptedMouseButtons(self) -> PySide2.QtCore.Qt.MouseButtons: ...
    def addToIndex(self) -> None: ...
    def advance(self, phase: int) -> None: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def boundingRegion(self, itemToDeviceTransform: PySide2.QtGui.QTransform) -> PySide2.QtGui.QRegion: ...
    def boundingRegionGranularity(self) -> float: ...
    def cacheMode(self) -> PySide2.QtWidgets.QGraphicsItem.CacheMode: ...
    def childItems(self) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    def childrenBoundingRect(self) -> PySide2.QtCore.QRectF: ...
    def clearFocus(self) -> None: ...
    def clipPath(self) -> PySide2.QtGui.QPainterPath: ...
    def collidesWithItem(self, other: PySide2.QtWidgets.QGraphicsItem, mode: PySide2.QtCore.Qt.ItemSelectionMode = ...) -> bool: ...
    def collidesWithPath(self, path: PySide2.QtGui.QPainterPath, mode: PySide2.QtCore.Qt.ItemSelectionMode = ...) -> bool: ...
    def collidingItems(self, mode: PySide2.QtCore.Qt.ItemSelectionMode = ...) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    def commonAncestorItem(self, other: PySide2.QtWidgets.QGraphicsItem) -> PySide2.QtWidgets.QGraphicsItem: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def contextMenuEvent(self, event: PySide2.QtWidgets.QGraphicsSceneContextMenuEvent) -> None: ...
    def cursor(self) -> PySide2.QtGui.QCursor: ...
    def data(self, key: int) -> typing.Any: ...
    def deviceTransform(self, viewportTransform: PySide2.QtGui.QTransform) -> PySide2.QtGui.QTransform: ...
    def dragEnterEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def dragLeaveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def dragMoveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def dropEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def effectiveOpacity(self) -> float: ...
    @typing.overload
    def ensureVisible(self, rect: PySide2.QtCore.QRectF = ..., xmargin: int = ..., ymargin: int = ...) -> None: ...
    @typing.overload
    def ensureVisible(self, x: float, y: float, w: float, h: float, xmargin: int = ..., ymargin: int = ...) -> None: ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def filtersChildEvents(self) -> bool: ...
    def flags(self) -> PySide2.QtWidgets.QGraphicsItem.GraphicsItemFlags: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusItem(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusProxy(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def focusScopeItem(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def grabKeyboard(self) -> None: ...
    def grabMouse(self) -> None: ...
    def graphicsEffect(self) -> PySide2.QtWidgets.QGraphicsEffect: ...
    def group(self) -> PySide2.QtWidgets.QGraphicsItemGroup: ...
    def handlesChildEvents(self) -> bool: ...
    def hasCursor(self) -> bool: ...
    def hasFocus(self) -> bool: ...
    def hide(self) -> None: ...
    def hoverEnterEvent(self, event: PySide2.QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def hoverLeaveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def hoverMoveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def inputMethodEvent(self, event: PySide2.QtGui.QInputMethodEvent) -> None: ...
    def inputMethodHints(self) -> PySide2.QtCore.Qt.InputMethodHints: ...
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def installSceneEventFilter(self, filterItem: PySide2.QtWidgets.QGraphicsItem) -> None: ...
    def isActive(self) -> bool: ...
    def isAncestorOf(self, child: PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def isBlockedByModalPanel(self, blockingPanel: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> bool: ...
    def isClipped(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    @typing.overload
    def isObscured(self, rect: PySide2.QtCore.QRectF = ...) -> bool: ...
    @typing.overload
    def isObscured(self, x: float, y: float, w: float, h: float) -> bool: ...
    def isObscuredBy(self, item: PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def isPanel(self) -> bool: ...
    def isSelected(self) -> bool: ...
    def isUnderMouse(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def isVisibleTo(self, parent: PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def isWidget(self) -> bool: ...
    def isWindow(self) -> bool: ...
    def itemChange(self, change: PySide2.QtWidgets.QGraphicsItem.GraphicsItemChange, value: typing.Any) -> typing.Any: ...
    def itemTransform(self, other: PySide2.QtWidgets.QGraphicsItem) -> typing.Tuple[PySide2.QtGui.QTransform, bool]: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    @typing.overload
    def mapFromItem(self, item: PySide2.QtWidgets.QGraphicsItem, path: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def mapFromItem(self, item: PySide2.QtWidgets.QGraphicsItem, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapFromItem(self, item: PySide2.QtWidgets.QGraphicsItem, polygon: PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromItem(self, item: PySide2.QtWidgets.QGraphicsItem, rect: PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromItem(self, item: PySide2.QtWidgets.QGraphicsItem, x: float, y: float) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapFromItem(self, item: PySide2.QtWidgets.QGraphicsItem, x: float, y: float, w: float, h: float) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromParent(self, path: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def mapFromParent(self, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapFromParent(self, polygon: PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromParent(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromParent(self, x: float, y: float) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapFromParent(self, x: float, y: float, w: float, h: float) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromScene(self, path: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def mapFromScene(self, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapFromScene(self, polygon: PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromScene(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromScene(self, x: float, y: float) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapFromScene(self, x: float, y: float, w: float, h: float) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapRectFromItem(self, item: PySide2.QtWidgets.QGraphicsItem, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectFromItem(self, item: PySide2.QtWidgets.QGraphicsItem, x: float, y: float, w: float, h: float) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectFromParent(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectFromParent(self, x: float, y: float, w: float, h: float) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectFromScene(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectFromScene(self, x: float, y: float, w: float, h: float) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectToItem(self, item: PySide2.QtWidgets.QGraphicsItem, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectToItem(self, item: PySide2.QtWidgets.QGraphicsItem, x: float, y: float, w: float, h: float) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectToParent(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectToParent(self, x: float, y: float, w: float, h: float) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectToScene(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectToScene(self, x: float, y: float, w: float, h: float) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapToItem(self, item: PySide2.QtWidgets.QGraphicsItem, path: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def mapToItem(self, item: PySide2.QtWidgets.QGraphicsItem, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapToItem(self, item: PySide2.QtWidgets.QGraphicsItem, polygon: PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToItem(self, item: PySide2.QtWidgets.QGraphicsItem, rect: PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToItem(self, item: PySide2.QtWidgets.QGraphicsItem, x: float, y: float) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapToItem(self, item: PySide2.QtWidgets.QGraphicsItem, x: float, y: float, w: float, h: float) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToParent(self, path: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def mapToParent(self, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapToParent(self, polygon: PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToParent(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToParent(self, x: float, y: float) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapToParent(self, x: float, y: float, w: float, h: float) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToScene(self, path: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def mapToScene(self, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapToScene(self, polygon: PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToScene(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToScene(self, x: float, y: float) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapToScene(self, x: float, y: float, w: float, h: float) -> PySide2.QtGui.QPolygonF: ...
    def matrix(self) -> PySide2.QtGui.QMatrix: ...
    def mouseDoubleClickEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def moveBy(self, dx: float, dy: float) -> None: ...
    def opacity(self) -> float: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    def panel(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def panelModality(self) -> PySide2.QtWidgets.QGraphicsItem.PanelModality: ...
    def parentItem(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def parentObject(self) -> PySide2.QtWidgets.QGraphicsObject: ...
    def parentWidget(self) -> PySide2.QtWidgets.QGraphicsWidget: ...
    def pos(self) -> PySide2.QtCore.QPointF: ...
    def prepareGeometryChange(self) -> None: ...
    def removeFromIndex(self) -> None: ...
    def removeSceneEventFilter(self, filterItem: PySide2.QtWidgets.QGraphicsItem) -> None: ...
    def resetMatrix(self) -> None: ...
    def resetTransform(self) -> None: ...
    def rotation(self) -> float: ...
    def scale(self) -> float: ...
    def scene(self) -> PySide2.QtWidgets.QGraphicsScene: ...
    def sceneBoundingRect(self) -> PySide2.QtCore.QRectF: ...
    def sceneEvent(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def sceneEventFilter(self, watched: PySide2.QtWidgets.QGraphicsItem, event: PySide2.QtCore.QEvent) -> bool: ...
    def sceneMatrix(self) -> PySide2.QtGui.QMatrix: ...
    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def sceneTransform(self) -> PySide2.QtGui.QTransform: ...
    def scroll(self, dx: float, dy: float, rect: PySide2.QtCore.QRectF = ...) -> None: ...
    def setAcceptDrops(self, on: bool) -> None: ...
    def setAcceptHoverEvents(self, enabled: bool) -> None: ...
    def setAcceptTouchEvents(self, enabled: bool) -> None: ...
    def setAcceptedMouseButtons(self, buttons: PySide2.QtCore.Qt.MouseButtons) -> None: ...
    def setActive(self, active: bool) -> None: ...
    def setBoundingRegionGranularity(self, granularity: float) -> None: ...
    def setCacheMode(self, mode: PySide2.QtWidgets.QGraphicsItem.CacheMode, cacheSize: PySide2.QtCore.QSize = ...) -> None: ...
    def setCursor(self, cursor: PySide2.QtGui.QCursor) -> None: ...
    def setData(self, key: int, value: typing.Any) -> None: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def setFiltersChildEvents(self, enabled: bool) -> None: ...
    def setFlag(self, flag: PySide2.QtWidgets.QGraphicsItem.GraphicsItemFlag, enabled: bool = ...) -> None: ...
    def setFlags(self, flags: PySide2.QtWidgets.QGraphicsItem.GraphicsItemFlags) -> None: ...
    def setFocus(self, focusReason: PySide2.QtCore.Qt.FocusReason = ...) -> None: ...
    def setFocusProxy(self, item: PySide2.QtWidgets.QGraphicsItem) -> None: ...
    def setGraphicsEffect(self, effect: PySide2.QtWidgets.QGraphicsEffect) -> None: ...
    def setGroup(self, group: PySide2.QtWidgets.QGraphicsItemGroup) -> None: ...
    def setHandlesChildEvents(self, enabled: bool) -> None: ...
    def setInputMethodHints(self, hints: PySide2.QtCore.Qt.InputMethodHints) -> None: ...
    def setMatrix(self, matrix: PySide2.QtGui.QMatrix, combine: bool = ...) -> None: ...
    def setOpacity(self, opacity: float) -> None: ...
    def setPanelModality(self, panelModality: PySide2.QtWidgets.QGraphicsItem.PanelModality) -> None: ...
    def setParentItem(self, parent: PySide2.QtWidgets.QGraphicsItem) -> None: ...
    @typing.overload
    def setPos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def setPos(self, x: float, y: float) -> None: ...
    def setRotation(self, angle: float) -> None: ...
    def setScale(self, scale: float) -> None: ...
    def setSelected(self, selected: bool) -> None: ...
    def setToolTip(self, toolTip: str) -> None: ...
    def setTransform(self, matrix: PySide2.QtGui.QTransform, combine: bool = ...) -> None: ...
    @typing.overload
    def setTransformOriginPoint(self, ax: float, ay: float) -> None: ...
    @typing.overload
    def setTransformOriginPoint(self, origin: PySide2.QtCore.QPointF) -> None: ...
    def setTransformations(self, transformations: typing.Sequence[PySide2.QtWidgets.QGraphicsTransform]) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def setX(self, x: float) -> None: ...
    def setY(self, y: float) -> None: ...
    def setZValue(self, z: float) -> None: ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def show(self) -> None: ...
    def stackBefore(self, sibling: PySide2.QtWidgets.QGraphicsItem) -> None: ...
    def toGraphicsObject(self) -> PySide2.QtWidgets.QGraphicsObject: ...
    def toolTip(self) -> str: ...
    def topLevelItem(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def topLevelWidget(self) -> PySide2.QtWidgets.QGraphicsWidget: ...
    def transform(self) -> PySide2.QtGui.QTransform: ...
    def transformOriginPoint(self) -> PySide2.QtCore.QPointF: ...
    def transformations(self) -> typing.List[PySide2.QtWidgets.QGraphicsTransform]: ...
    def type(self) -> int: ...
    def ungrabKeyboard(self) -> None: ...
    def ungrabMouse(self) -> None: ...
    def unsetCursor(self) -> None: ...
    @typing.overload
    def update(self, rect: PySide2.QtCore.QRectF = ...) -> None: ...
    @typing.overload
    def update(self, x: float, y: float, width: float, height: float) -> None: ...
    def updateMicroFocus(self) -> None: ...
    def wheelEvent(self, event: PySide2.QtWidgets.QGraphicsSceneWheelEvent) -> None: ...
    def window(self) -> PySide2.QtWidgets.QGraphicsWidget: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def zValue(self) -> float: ...


class QGraphicsItemAnimation(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def afterAnimationStep(self, step: float) -> None: ...
    def beforeAnimationStep(self, step: float) -> None: ...
    def clear(self) -> None: ...
    def horizontalScaleAt(self, step: float) -> float: ...
    def horizontalShearAt(self, step: float) -> float: ...
    def item(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def matrixAt(self, step: float) -> PySide2.QtGui.QMatrix: ...
    def posAt(self, step: float) -> PySide2.QtCore.QPointF: ...
    def posList(self) -> typing.List[typing.Tuple[float, PySide2.QtCore.QPointF]]: ...
    def reset(self) -> None: ...
    def rotationAt(self, step: float) -> float: ...
    def rotationList(self) -> typing.List[typing.Tuple[float, float]]: ...
    def scaleList(self) -> typing.List[typing.Tuple[float, PySide2.QtCore.QPointF]]: ...
    def setItem(self, item: PySide2.QtWidgets.QGraphicsItem) -> None: ...
    def setPosAt(self, step: float, pos: PySide2.QtCore.QPointF) -> None: ...
    def setRotationAt(self, step: float, angle: float) -> None: ...
    def setScaleAt(self, step: float, sx: float, sy: float) -> None: ...
    def setShearAt(self, step: float, sh: float, sv: float) -> None: ...
    def setStep(self, x: float) -> None: ...
    def setTimeLine(self, timeLine: PySide2.QtCore.QTimeLine) -> None: ...
    def setTranslationAt(self, step: float, dx: float, dy: float) -> None: ...
    def shearList(self) -> typing.List[typing.Tuple[float, PySide2.QtCore.QPointF]]: ...
    def timeLine(self) -> PySide2.QtCore.QTimeLine: ...
    def transformAt(self, step: float) -> PySide2.QtGui.QTransform: ...
    def translationList(self) -> typing.List[typing.Tuple[float, PySide2.QtCore.QPointF]]: ...
    def verticalScaleAt(self, step: float) -> float: ...
    def verticalShearAt(self, step: float) -> float: ...
    def xTranslationAt(self, step: float) -> float: ...
    def yTranslationAt(self, step: float) -> float: ...


class QGraphicsItemGroup(PySide2.QtWidgets.QGraphicsItem):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...

    def addToGroup(self, item: PySide2.QtWidgets.QGraphicsItem) -> None: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def isObscuredBy(self, item: PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    def removeFromGroup(self, item: PySide2.QtWidgets.QGraphicsItem) -> None: ...
    def type(self) -> int: ...


class QGraphicsLayout(PySide2.QtWidgets.QGraphicsLayoutItem):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsLayoutItem] = ...) -> None: ...

    def activate(self) -> None: ...
    def addChildLayoutItem(self, layoutItem: PySide2.QtWidgets.QGraphicsLayoutItem) -> None: ...
    def count(self) -> int: ...
    def getContentsMargins(self) -> typing.Tuple[float, float, float, float]: ...
    @staticmethod
    def instantInvalidatePropagation() -> bool: ...
    def invalidate(self) -> None: ...
    def isActivated(self) -> bool: ...
    def itemAt(self, i: int) -> PySide2.QtWidgets.QGraphicsLayoutItem: ...
    def removeAt(self, index: int) -> None: ...
    def setContentsMargins(self, left: float, top: float, right: float, bottom: float) -> None: ...
    @staticmethod
    def setInstantInvalidatePropagation(enable: bool) -> None: ...
    def updateGeometry(self) -> None: ...
    def widgetEvent(self, e: PySide2.QtCore.QEvent) -> None: ...


class QGraphicsLayoutItem(Shiboken.Object):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsLayoutItem] = ..., isLayout: bool = ...) -> None: ...

    def contentsRect(self) -> PySide2.QtCore.QRectF: ...
    def effectiveSizeHint(self, which: PySide2.QtCore.Qt.SizeHint, constraint: PySide2.QtCore.QSizeF = ...) -> PySide2.QtCore.QSizeF: ...
    def geometry(self) -> PySide2.QtCore.QRectF: ...
    def getContentsMargins(self) -> typing.Tuple[float, float, float, float]: ...
    def graphicsItem(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def isLayout(self) -> bool: ...
    def maximumHeight(self) -> float: ...
    def maximumSize(self) -> PySide2.QtCore.QSizeF: ...
    def maximumWidth(self) -> float: ...
    def minimumHeight(self) -> float: ...
    def minimumSize(self) -> PySide2.QtCore.QSizeF: ...
    def minimumWidth(self) -> float: ...
    def ownedByLayout(self) -> bool: ...
    def parentLayoutItem(self) -> PySide2.QtWidgets.QGraphicsLayoutItem: ...
    def preferredHeight(self) -> float: ...
    def preferredSize(self) -> PySide2.QtCore.QSizeF: ...
    def preferredWidth(self) -> float: ...
    def setGeometry(self, rect: PySide2.QtCore.QRectF) -> None: ...
    def setGraphicsItem(self, item: PySide2.QtWidgets.QGraphicsItem) -> None: ...
    def setMaximumHeight(self, height: float) -> None: ...
    @typing.overload
    def setMaximumSize(self, size: PySide2.QtCore.QSizeF) -> None: ...
    @typing.overload
    def setMaximumSize(self, w: float, h: float) -> None: ...
    def setMaximumWidth(self, width: float) -> None: ...
    def setMinimumHeight(self, height: float) -> None: ...
    @typing.overload
    def setMinimumSize(self, size: PySide2.QtCore.QSizeF) -> None: ...
    @typing.overload
    def setMinimumSize(self, w: float, h: float) -> None: ...
    def setMinimumWidth(self, width: float) -> None: ...
    def setOwnedByLayout(self, ownedByLayout: bool) -> None: ...
    def setParentLayoutItem(self, parent: PySide2.QtWidgets.QGraphicsLayoutItem) -> None: ...
    def setPreferredHeight(self, height: float) -> None: ...
    @typing.overload
    def setPreferredSize(self, size: PySide2.QtCore.QSizeF) -> None: ...
    @typing.overload
    def setPreferredSize(self, w: float, h: float) -> None: ...
    def setPreferredWidth(self, width: float) -> None: ...
    @typing.overload
    def setSizePolicy(self, hPolicy: PySide2.QtWidgets.QSizePolicy.Policy, vPolicy: PySide2.QtWidgets.QSizePolicy.Policy, controlType: PySide2.QtWidgets.QSizePolicy.ControlType = ...) -> None: ...
    @typing.overload
    def setSizePolicy(self, policy: PySide2.QtWidgets.QSizePolicy) -> None: ...
    def sizeHint(self, which: PySide2.QtCore.Qt.SizeHint, constraint: PySide2.QtCore.QSizeF = ...) -> PySide2.QtCore.QSizeF: ...
    def sizePolicy(self) -> PySide2.QtWidgets.QSizePolicy: ...
    def updateGeometry(self) -> None: ...


class QGraphicsLineItem(PySide2.QtWidgets.QGraphicsItem):

    @typing.overload
    def __init__(self, line: PySide2.QtCore.QLineF, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @typing.overload
    def __init__(self, x1: float, y1: float, x2: float, y2: float, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...

    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def isObscuredBy(self, item: PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def line(self) -> PySide2.QtCore.QLineF: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    def pen(self) -> PySide2.QtGui.QPen: ...
    @typing.overload
    def setLine(self, line: PySide2.QtCore.QLineF) -> None: ...
    @typing.overload
    def setLine(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def setPen(self, pen: PySide2.QtGui.QPen) -> None: ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def type(self) -> int: ...


class QGraphicsLinearLayout(PySide2.QtWidgets.QGraphicsLayout):

    @typing.overload
    def __init__(self, orientation: PySide2.QtCore.Qt.Orientation, parent: typing.Optional[PySide2.QtWidgets.QGraphicsLayoutItem] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsLayoutItem] = ...) -> None: ...

    def addItem(self, item: PySide2.QtWidgets.QGraphicsLayoutItem) -> None: ...
    def addStretch(self, stretch: int = ...) -> None: ...
    def alignment(self, item: PySide2.QtWidgets.QGraphicsLayoutItem) -> PySide2.QtCore.Qt.Alignment: ...
    def count(self) -> int: ...
    def dump(self, indent: int = ...) -> None: ...
    def insertItem(self, index: int, item: PySide2.QtWidgets.QGraphicsLayoutItem) -> None: ...
    def insertStretch(self, index: int, stretch: int = ...) -> None: ...
    def invalidate(self) -> None: ...
    def itemAt(self, index: int) -> PySide2.QtWidgets.QGraphicsLayoutItem: ...
    def itemSpacing(self, index: int) -> float: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def removeAt(self, index: int) -> None: ...
    def removeItem(self, item: PySide2.QtWidgets.QGraphicsLayoutItem) -> None: ...
    def setAlignment(self, item: PySide2.QtWidgets.QGraphicsLayoutItem, alignment: PySide2.QtCore.Qt.Alignment) -> None: ...
    def setGeometry(self, rect: PySide2.QtCore.QRectF) -> None: ...
    def setItemSpacing(self, index: int, spacing: float) -> None: ...
    def setOrientation(self, orientation: PySide2.QtCore.Qt.Orientation) -> None: ...
    def setSpacing(self, spacing: float) -> None: ...
    def setStretchFactor(self, item: PySide2.QtWidgets.QGraphicsLayoutItem, stretch: int) -> None: ...
    def sizeHint(self, which: PySide2.QtCore.Qt.SizeHint, constraint: PySide2.QtCore.QSizeF = ...) -> PySide2.QtCore.QSizeF: ...
    def spacing(self) -> float: ...
    def stretchFactor(self, item: PySide2.QtWidgets.QGraphicsLayoutItem) -> int: ...


class QGraphicsObject(PySide2.QtWidgets.QGraphicsItem, PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...

    def event(self, ev: PySide2.QtCore.QEvent) -> bool: ...
    def grabGesture(self, type: PySide2.QtCore.Qt.GestureType, flags: PySide2.QtCore.Qt.GestureFlags = ...) -> None: ...
    def ungrabGesture(self, type: PySide2.QtCore.Qt.GestureType) -> None: ...
    def updateMicroFocus(self) -> None: ...


class QGraphicsOpacityEffect(PySide2.QtWidgets.QGraphicsEffect):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def draw(self, painter: PySide2.QtGui.QPainter) -> None: ...
    def opacity(self) -> float: ...
    def opacityMask(self) -> PySide2.QtGui.QBrush: ...
    def setOpacity(self, opacity: float) -> None: ...
    def setOpacityMask(self, mask: PySide2.QtGui.QBrush) -> None: ...


class QGraphicsPathItem(PySide2.QtWidgets.QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @typing.overload
    def __init__(self, path: PySide2.QtGui.QPainterPath, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...

    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def isObscuredBy(self, item: PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    def path(self) -> PySide2.QtGui.QPainterPath: ...
    def setPath(self, path: PySide2.QtGui.QPainterPath) -> None: ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def type(self) -> int: ...


class QGraphicsPixmapItem(PySide2.QtWidgets.QGraphicsItem):
    MaskShape                : QGraphicsPixmapItem.ShapeMode = ... # 0x0
    BoundingRectShape        : QGraphicsPixmapItem.ShapeMode = ... # 0x1
    HeuristicMaskShape       : QGraphicsPixmapItem.ShapeMode = ... # 0x2

    class ShapeMode(Shiboken.Enum):
        MaskShape                : QGraphicsPixmapItem.ShapeMode = ... # 0x0
        BoundingRectShape        : QGraphicsPixmapItem.ShapeMode = ... # 0x1
        HeuristicMaskShape       : QGraphicsPixmapItem.ShapeMode = ... # 0x2

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @typing.overload
    def __init__(self, pixmap: PySide2.QtGui.QPixmap, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...

    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def isObscuredBy(self, item: PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def offset(self) -> PySide2.QtCore.QPointF: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def pixmap(self) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    def setOffset(self, offset: PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def setOffset(self, x: float, y: float) -> None: ...
    def setPixmap(self, pixmap: PySide2.QtGui.QPixmap) -> None: ...
    def setShapeMode(self, mode: PySide2.QtWidgets.QGraphicsPixmapItem.ShapeMode) -> None: ...
    def setTransformationMode(self, mode: PySide2.QtCore.Qt.TransformationMode) -> None: ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def shapeMode(self) -> PySide2.QtWidgets.QGraphicsPixmapItem.ShapeMode: ...
    def transformationMode(self) -> PySide2.QtCore.Qt.TransformationMode: ...
    def type(self) -> int: ...


class QGraphicsPolygonItem(PySide2.QtWidgets.QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @typing.overload
    def __init__(self, polygon: PySide2.QtGui.QPolygonF, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...

    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def fillRule(self) -> PySide2.QtCore.Qt.FillRule: ...
    def isObscuredBy(self, item: PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    def polygon(self) -> PySide2.QtGui.QPolygonF: ...
    def setFillRule(self, rule: PySide2.QtCore.Qt.FillRule) -> None: ...
    def setPolygon(self, polygon: PySide2.QtGui.QPolygonF) -> None: ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def type(self) -> int: ...


class QGraphicsProxyWidget(PySide2.QtWidgets.QGraphicsWidget):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ..., wFlags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...

    def contextMenuEvent(self, event: PySide2.QtWidgets.QGraphicsSceneContextMenuEvent) -> None: ...
    def createProxyForChildWidget(self, child: PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QGraphicsProxyWidget: ...
    def dragEnterEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def dragLeaveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def dragMoveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def dropEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, object: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def grabMouseEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def hideEvent(self, event: PySide2.QtGui.QHideEvent) -> None: ...
    def hoverEnterEvent(self, event: PySide2.QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def hoverLeaveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def hoverMoveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def inputMethodEvent(self, event: PySide2.QtGui.QInputMethodEvent) -> None: ...
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def mouseDoubleClickEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def newProxyWidget(self, arg__1: PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QGraphicsProxyWidget: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def resizeEvent(self, event: PySide2.QtWidgets.QGraphicsSceneResizeEvent) -> None: ...
    def setGeometry(self, rect: PySide2.QtCore.QRectF) -> None: ...
    def setWidget(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def showEvent(self, event: PySide2.QtGui.QShowEvent) -> None: ...
    def sizeHint(self, which: PySide2.QtCore.Qt.SizeHint, constraint: PySide2.QtCore.QSizeF = ...) -> PySide2.QtCore.QSizeF: ...
    def subWidgetRect(self, widget: PySide2.QtWidgets.QWidget) -> PySide2.QtCore.QRectF: ...
    def type(self) -> int: ...
    def ungrabMouseEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def wheelEvent(self, event: PySide2.QtWidgets.QGraphicsSceneWheelEvent) -> None: ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...


class QGraphicsRectItem(PySide2.QtWidgets.QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @typing.overload
    def __init__(self, rect: PySide2.QtCore.QRectF, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @typing.overload
    def __init__(self, x: float, y: float, w: float, h: float, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...

    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def isObscuredBy(self, item: PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    def rect(self) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def setRect(self, rect: PySide2.QtCore.QRectF) -> None: ...
    @typing.overload
    def setRect(self, x: float, y: float, w: float, h: float) -> None: ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def type(self) -> int: ...


class QGraphicsRotation(PySide2.QtWidgets.QGraphicsTransform):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def angle(self) -> float: ...
    def applyTo(self, matrix: PySide2.QtGui.QMatrix4x4) -> None: ...
    def axis(self) -> PySide2.QtGui.QVector3D: ...
    def origin(self) -> PySide2.QtGui.QVector3D: ...
    def setAngle(self, arg__1: float) -> None: ...
    @typing.overload
    def setAxis(self, axis: PySide2.QtCore.Qt.Axis) -> None: ...
    @typing.overload
    def setAxis(self, axis: PySide2.QtGui.QVector3D) -> None: ...
    def setOrigin(self, point: PySide2.QtGui.QVector3D) -> None: ...


class QGraphicsScale(PySide2.QtWidgets.QGraphicsTransform):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def applyTo(self, matrix: PySide2.QtGui.QMatrix4x4) -> None: ...
    def origin(self) -> PySide2.QtGui.QVector3D: ...
    def setOrigin(self, point: PySide2.QtGui.QVector3D) -> None: ...
    def setXScale(self, arg__1: float) -> None: ...
    def setYScale(self, arg__1: float) -> None: ...
    def setZScale(self, arg__1: float) -> None: ...
    def xScale(self) -> float: ...
    def yScale(self) -> float: ...
    def zScale(self) -> float: ...


class QGraphicsScene(PySide2.QtCore.QObject):
    NoIndex                  : QGraphicsScene.ItemIndexMethod = ... # -0x1
    BspTreeIndex             : QGraphicsScene.ItemIndexMethod = ... # 0x0
    ItemLayer                : QGraphicsScene.SceneLayer = ... # 0x1
    BackgroundLayer          : QGraphicsScene.SceneLayer = ... # 0x2
    ForegroundLayer          : QGraphicsScene.SceneLayer = ... # 0x4
    AllLayers                : QGraphicsScene.SceneLayer = ... # 0xffff

    class ItemIndexMethod(Shiboken.Enum):
        NoIndex                  : QGraphicsScene.ItemIndexMethod = ... # -0x1
        BspTreeIndex             : QGraphicsScene.ItemIndexMethod = ... # 0x0

    class SceneLayer(Shiboken.Enum):
        ItemLayer                : QGraphicsScene.SceneLayer = ... # 0x1
        BackgroundLayer          : QGraphicsScene.SceneLayer = ... # 0x2
        ForegroundLayer          : QGraphicsScene.SceneLayer = ... # 0x4
        AllLayers                : QGraphicsScene.SceneLayer = ... # 0xffff

    class SceneLayers(object): ...

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, sceneRect: PySide2.QtCore.QRectF, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, x: float, y: float, width: float, height: float, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def activePanel(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def activeWindow(self) -> PySide2.QtWidgets.QGraphicsWidget: ...
    @typing.overload
    def addEllipse(self, rect: PySide2.QtCore.QRectF, pen: PySide2.QtGui.QPen = ..., brush: PySide2.QtGui.QBrush = ...) -> PySide2.QtWidgets.QGraphicsEllipseItem: ...
    @typing.overload
    def addEllipse(self, x: float, y: float, w: float, h: float, pen: PySide2.QtGui.QPen = ..., brush: PySide2.QtGui.QBrush = ...) -> PySide2.QtWidgets.QGraphicsEllipseItem: ...
    def addItem(self, item: PySide2.QtWidgets.QGraphicsItem) -> None: ...
    @typing.overload
    def addLine(self, line: PySide2.QtCore.QLineF, pen: PySide2.QtGui.QPen = ...) -> PySide2.QtWidgets.QGraphicsLineItem: ...
    @typing.overload
    def addLine(self, x1: float, y1: float, x2: float, y2: float, pen: PySide2.QtGui.QPen = ...) -> PySide2.QtWidgets.QGraphicsLineItem: ...
    def addPath(self, path: PySide2.QtGui.QPainterPath, pen: PySide2.QtGui.QPen = ..., brush: PySide2.QtGui.QBrush = ...) -> PySide2.QtWidgets.QGraphicsPathItem: ...
    def addPixmap(self, pixmap: PySide2.QtGui.QPixmap) -> PySide2.QtWidgets.QGraphicsPixmapItem: ...
    def addPolygon(self, polygon: PySide2.QtGui.QPolygonF, pen: PySide2.QtGui.QPen = ..., brush: PySide2.QtGui.QBrush = ...) -> PySide2.QtWidgets.QGraphicsPolygonItem: ...
    @typing.overload
    def addRect(self, rect: PySide2.QtCore.QRectF, pen: PySide2.QtGui.QPen = ..., brush: PySide2.QtGui.QBrush = ...) -> PySide2.QtWidgets.QGraphicsRectItem: ...
    @typing.overload
    def addRect(self, x: float, y: float, w: float, h: float, pen: PySide2.QtGui.QPen = ..., brush: PySide2.QtGui.QBrush = ...) -> PySide2.QtWidgets.QGraphicsRectItem: ...
    def addSimpleText(self, text: str, font: PySide2.QtGui.QFont = ...) -> PySide2.QtWidgets.QGraphicsSimpleTextItem: ...
    def addText(self, text: str, font: PySide2.QtGui.QFont = ...) -> PySide2.QtWidgets.QGraphicsTextItem: ...
    def addWidget(self, widget: PySide2.QtWidgets.QWidget, wFlags: PySide2.QtCore.Qt.WindowFlags = ...) -> PySide2.QtWidgets.QGraphicsProxyWidget: ...
    def advance(self) -> None: ...
    def backgroundBrush(self) -> PySide2.QtGui.QBrush: ...
    def bspTreeDepth(self) -> int: ...
    def clear(self) -> None: ...
    def clearFocus(self) -> None: ...
    def clearSelection(self) -> None: ...
    def collidingItems(self, item: PySide2.QtWidgets.QGraphicsItem, mode: PySide2.QtCore.Qt.ItemSelectionMode = ...) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    def contextMenuEvent(self, event: PySide2.QtWidgets.QGraphicsSceneContextMenuEvent) -> None: ...
    def createItemGroup(self, items: typing.Sequence[PySide2.QtWidgets.QGraphicsItem]) -> PySide2.QtWidgets.QGraphicsItemGroup: ...
    def destroyItemGroup(self, group: PySide2.QtWidgets.QGraphicsItemGroup) -> None: ...
    def dragEnterEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def dragLeaveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def dragMoveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def drawBackground(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRectF) -> None: ...
    def drawForeground(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRectF) -> None: ...
    def dropEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, watched: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusItem(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOnTouch(self) -> bool: ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def foregroundBrush(self) -> PySide2.QtGui.QBrush: ...
    def hasFocus(self) -> bool: ...
    def height(self) -> float: ...
    def helpEvent(self, event: PySide2.QtWidgets.QGraphicsSceneHelpEvent) -> None: ...
    def inputMethodEvent(self, event: PySide2.QtGui.QInputMethodEvent) -> None: ...
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    @typing.overload
    def invalidate(self, rect: PySide2.QtCore.QRectF = ..., layers: PySide2.QtWidgets.QGraphicsScene.SceneLayers = ...) -> None: ...
    @typing.overload
    def invalidate(self, x: float, y: float, w: float, h: float, layers: PySide2.QtWidgets.QGraphicsScene.SceneLayers = ...) -> None: ...
    def isActive(self) -> bool: ...
    def isSortCacheEnabled(self) -> bool: ...
    @typing.overload
    def itemAt(self, pos: PySide2.QtCore.QPointF, deviceTransform: PySide2.QtGui.QTransform) -> PySide2.QtWidgets.QGraphicsItem: ...
    @typing.overload
    def itemAt(self, x: float, y: float, deviceTransform: PySide2.QtGui.QTransform) -> PySide2.QtWidgets.QGraphicsItem: ...
    def itemIndexMethod(self) -> PySide2.QtWidgets.QGraphicsScene.ItemIndexMethod: ...
    @typing.overload
    def items(self, order: PySide2.QtCore.Qt.SortOrder = ...) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, path: PySide2.QtGui.QPainterPath, mode: PySide2.QtCore.Qt.ItemSelectionMode = ..., order: PySide2.QtCore.Qt.SortOrder = ..., deviceTransform: PySide2.QtGui.QTransform = ...) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, polygon: PySide2.QtGui.QPolygonF, mode: PySide2.QtCore.Qt.ItemSelectionMode = ..., order: PySide2.QtCore.Qt.SortOrder = ..., deviceTransform: PySide2.QtGui.QTransform = ...) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, pos: PySide2.QtCore.QPointF, mode: PySide2.QtCore.Qt.ItemSelectionMode = ..., order: PySide2.QtCore.Qt.SortOrder = ..., deviceTransform: PySide2.QtGui.QTransform = ...) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, rect: PySide2.QtCore.QRectF, mode: PySide2.QtCore.Qt.ItemSelectionMode = ..., order: PySide2.QtCore.Qt.SortOrder = ..., deviceTransform: PySide2.QtGui.QTransform = ...) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, x: float, y: float, w: float, h: float, mode: PySide2.QtCore.Qt.ItemSelectionMode, order: PySide2.QtCore.Qt.SortOrder, deviceTransform: PySide2.QtGui.QTransform = ...) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    def itemsBoundingRect(self) -> PySide2.QtCore.QRectF: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def minimumRenderSize(self) -> float: ...
    def mouseDoubleClickEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def mouseGrabberItem(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def mouseMoveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def palette(self) -> PySide2.QtGui.QPalette: ...
    def removeItem(self, item: PySide2.QtWidgets.QGraphicsItem) -> None: ...
    def render(self, painter: PySide2.QtGui.QPainter, target: PySide2.QtCore.QRectF = ..., source: PySide2.QtCore.QRectF = ..., aspectRatioMode: PySide2.QtCore.Qt.AspectRatioMode = ...) -> None: ...
    def sceneRect(self) -> PySide2.QtCore.QRectF: ...
    def selectedItems(self) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    def selectionArea(self) -> PySide2.QtGui.QPainterPath: ...
    def sendEvent(self, item: PySide2.QtWidgets.QGraphicsItem, event: PySide2.QtCore.QEvent) -> bool: ...
    def setActivePanel(self, item: PySide2.QtWidgets.QGraphicsItem) -> None: ...
    def setActiveWindow(self, widget: PySide2.QtWidgets.QGraphicsWidget) -> None: ...
    def setBackgroundBrush(self, brush: PySide2.QtGui.QBrush) -> None: ...
    def setBspTreeDepth(self, depth: int) -> None: ...
    def setFocus(self, focusReason: PySide2.QtCore.Qt.FocusReason = ...) -> None: ...
    def setFocusItem(self, item: PySide2.QtWidgets.QGraphicsItem, focusReason: PySide2.QtCore.Qt.FocusReason = ...) -> None: ...
    def setFocusOnTouch(self, enabled: bool) -> None: ...
    def setFont(self, font: PySide2.QtGui.QFont) -> None: ...
    def setForegroundBrush(self, brush: PySide2.QtGui.QBrush) -> None: ...
    def setItemIndexMethod(self, method: PySide2.QtWidgets.QGraphicsScene.ItemIndexMethod) -> None: ...
    def setMinimumRenderSize(self, minSize: float) -> None: ...
    def setPalette(self, palette: PySide2.QtGui.QPalette) -> None: ...
    @typing.overload
    def setSceneRect(self, rect: PySide2.QtCore.QRectF) -> None: ...
    @typing.overload
    def setSceneRect(self, x: float, y: float, w: float, h: float) -> None: ...
    @typing.overload
    def setSelectionArea(self, path: PySide2.QtGui.QPainterPath, deviceTransform: PySide2.QtGui.QTransform) -> None: ...
    @typing.overload
    def setSelectionArea(self, path: PySide2.QtGui.QPainterPath, mode: PySide2.QtCore.Qt.ItemSelectionMode = ..., deviceTransform: PySide2.QtGui.QTransform = ...) -> None: ...
    @typing.overload
    def setSelectionArea(self, path: PySide2.QtGui.QPainterPath, selectionOperation: PySide2.QtCore.Qt.ItemSelectionOperation, mode: PySide2.QtCore.Qt.ItemSelectionMode = ..., deviceTransform: PySide2.QtGui.QTransform = ...) -> None: ...
    def setSortCacheEnabled(self, enabled: bool) -> None: ...
    def setStickyFocus(self, enabled: bool) -> None: ...
    def setStyle(self, style: PySide2.QtWidgets.QStyle) -> None: ...
    def stickyFocus(self) -> bool: ...
    def style(self) -> PySide2.QtWidgets.QStyle: ...
    @typing.overload
    def update(self, rect: PySide2.QtCore.QRectF = ...) -> None: ...
    @typing.overload
    def update(self, x: float, y: float, w: float, h: float) -> None: ...
    def views(self) -> typing.List[PySide2.QtWidgets.QGraphicsView]: ...
    def wheelEvent(self, event: PySide2.QtWidgets.QGraphicsSceneWheelEvent) -> None: ...
    def width(self) -> float: ...


class QGraphicsSceneContextMenuEvent(PySide2.QtWidgets.QGraphicsSceneEvent):
    Mouse                    : QGraphicsSceneContextMenuEvent.Reason = ... # 0x0
    Keyboard                 : QGraphicsSceneContextMenuEvent.Reason = ... # 0x1
    Other                    : QGraphicsSceneContextMenuEvent.Reason = ... # 0x2

    class Reason(Shiboken.Enum):
        Mouse                    : QGraphicsSceneContextMenuEvent.Reason = ... # 0x0
        Keyboard                 : QGraphicsSceneContextMenuEvent.Reason = ... # 0x1
        Other                    : QGraphicsSceneContextMenuEvent.Reason = ... # 0x2

    def __init__(self, type: PySide2.QtCore.QEvent.Type = ...) -> None: ...

    def modifiers(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def pos(self) -> PySide2.QtCore.QPointF: ...
    def reason(self) -> PySide2.QtWidgets.QGraphicsSceneContextMenuEvent.Reason: ...
    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def screenPos(self) -> PySide2.QtCore.QPoint: ...
    def setModifiers(self, modifiers: PySide2.QtCore.Qt.KeyboardModifiers) -> None: ...
    def setPos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setReason(self, reason: PySide2.QtWidgets.QGraphicsSceneContextMenuEvent.Reason) -> None: ...
    def setScenePos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setScreenPos(self, pos: PySide2.QtCore.QPoint) -> None: ...


class QGraphicsSceneDragDropEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, type: PySide2.QtCore.QEvent.Type = ...) -> None: ...

    def acceptProposedAction(self) -> None: ...
    def buttons(self) -> PySide2.QtCore.Qt.MouseButtons: ...
    def dropAction(self) -> PySide2.QtCore.Qt.DropAction: ...
    def mimeData(self) -> PySide2.QtCore.QMimeData: ...
    def modifiers(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def pos(self) -> PySide2.QtCore.QPointF: ...
    def possibleActions(self) -> PySide2.QtCore.Qt.DropActions: ...
    def proposedAction(self) -> PySide2.QtCore.Qt.DropAction: ...
    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def screenPos(self) -> PySide2.QtCore.QPoint: ...
    def setButtons(self, buttons: PySide2.QtCore.Qt.MouseButtons) -> None: ...
    def setDropAction(self, action: PySide2.QtCore.Qt.DropAction) -> None: ...
    def setModifiers(self, modifiers: PySide2.QtCore.Qt.KeyboardModifiers) -> None: ...
    def setPos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setPossibleActions(self, actions: PySide2.QtCore.Qt.DropActions) -> None: ...
    def setProposedAction(self, action: PySide2.QtCore.Qt.DropAction) -> None: ...
    def setScenePos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setScreenPos(self, pos: PySide2.QtCore.QPoint) -> None: ...
    def source(self) -> PySide2.QtWidgets.QWidget: ...


class QGraphicsSceneEvent(PySide2.QtCore.QEvent):

    def __init__(self, type: PySide2.QtCore.QEvent.Type) -> None: ...

    def widget(self) -> PySide2.QtWidgets.QWidget: ...


class QGraphicsSceneHelpEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, type: PySide2.QtCore.QEvent.Type = ...) -> None: ...

    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def screenPos(self) -> PySide2.QtCore.QPoint: ...
    def setScenePos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setScreenPos(self, pos: PySide2.QtCore.QPoint) -> None: ...


class QGraphicsSceneHoverEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, type: PySide2.QtCore.QEvent.Type = ...) -> None: ...

    def lastPos(self) -> PySide2.QtCore.QPointF: ...
    def lastScenePos(self) -> PySide2.QtCore.QPointF: ...
    def lastScreenPos(self) -> PySide2.QtCore.QPoint: ...
    def modifiers(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def pos(self) -> PySide2.QtCore.QPointF: ...
    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def screenPos(self) -> PySide2.QtCore.QPoint: ...
    def setLastPos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setLastScenePos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setLastScreenPos(self, pos: PySide2.QtCore.QPoint) -> None: ...
    def setModifiers(self, modifiers: PySide2.QtCore.Qt.KeyboardModifiers) -> None: ...
    def setPos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setScenePos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setScreenPos(self, pos: PySide2.QtCore.QPoint) -> None: ...


class QGraphicsSceneMouseEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, type: PySide2.QtCore.QEvent.Type = ...) -> None: ...

    def button(self) -> PySide2.QtCore.Qt.MouseButton: ...
    def buttonDownPos(self, button: PySide2.QtCore.Qt.MouseButton) -> PySide2.QtCore.QPointF: ...
    def buttonDownScenePos(self, button: PySide2.QtCore.Qt.MouseButton) -> PySide2.QtCore.QPointF: ...
    def buttonDownScreenPos(self, button: PySide2.QtCore.Qt.MouseButton) -> PySide2.QtCore.QPoint: ...
    def buttons(self) -> PySide2.QtCore.Qt.MouseButtons: ...
    def flags(self) -> PySide2.QtCore.Qt.MouseEventFlags: ...
    def lastPos(self) -> PySide2.QtCore.QPointF: ...
    def lastScenePos(self) -> PySide2.QtCore.QPointF: ...
    def lastScreenPos(self) -> PySide2.QtCore.QPoint: ...
    def modifiers(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def pos(self) -> PySide2.QtCore.QPointF: ...
    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def screenPos(self) -> PySide2.QtCore.QPoint: ...
    def setButton(self, button: PySide2.QtCore.Qt.MouseButton) -> None: ...
    def setButtonDownPos(self, button: PySide2.QtCore.Qt.MouseButton, pos: PySide2.QtCore.QPointF) -> None: ...
    def setButtonDownScenePos(self, button: PySide2.QtCore.Qt.MouseButton, pos: PySide2.QtCore.QPointF) -> None: ...
    def setButtonDownScreenPos(self, button: PySide2.QtCore.Qt.MouseButton, pos: PySide2.QtCore.QPoint) -> None: ...
    def setButtons(self, buttons: PySide2.QtCore.Qt.MouseButtons) -> None: ...
    def setFlags(self, arg__1: PySide2.QtCore.Qt.MouseEventFlags) -> None: ...
    def setLastPos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setLastScenePos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setLastScreenPos(self, pos: PySide2.QtCore.QPoint) -> None: ...
    def setModifiers(self, modifiers: PySide2.QtCore.Qt.KeyboardModifiers) -> None: ...
    def setPos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setScenePos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setScreenPos(self, pos: PySide2.QtCore.QPoint) -> None: ...
    def setSource(self, source: PySide2.QtCore.Qt.MouseEventSource) -> None: ...
    def source(self) -> PySide2.QtCore.Qt.MouseEventSource: ...


class QGraphicsSceneMoveEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self) -> None: ...

    def newPos(self) -> PySide2.QtCore.QPointF: ...
    def oldPos(self) -> PySide2.QtCore.QPointF: ...
    def setNewPos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setOldPos(self, pos: PySide2.QtCore.QPointF) -> None: ...


class QGraphicsSceneResizeEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self) -> None: ...

    def newSize(self) -> PySide2.QtCore.QSizeF: ...
    def oldSize(self) -> PySide2.QtCore.QSizeF: ...
    def setNewSize(self, size: PySide2.QtCore.QSizeF) -> None: ...
    def setOldSize(self, size: PySide2.QtCore.QSizeF) -> None: ...


class QGraphicsSceneWheelEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, type: PySide2.QtCore.QEvent.Type = ...) -> None: ...

    def buttons(self) -> PySide2.QtCore.Qt.MouseButtons: ...
    def delta(self) -> int: ...
    def modifiers(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def pos(self) -> PySide2.QtCore.QPointF: ...
    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def screenPos(self) -> PySide2.QtCore.QPoint: ...
    def setButtons(self, buttons: PySide2.QtCore.Qt.MouseButtons) -> None: ...
    def setDelta(self, delta: int) -> None: ...
    def setModifiers(self, modifiers: PySide2.QtCore.Qt.KeyboardModifiers) -> None: ...
    def setOrientation(self, orientation: PySide2.QtCore.Qt.Orientation) -> None: ...
    def setPos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setScenePos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setScreenPos(self, pos: PySide2.QtCore.QPoint) -> None: ...


class QGraphicsSimpleTextItem(PySide2.QtWidgets.QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...

    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def isObscuredBy(self, item: PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def setFont(self, font: PySide2.QtGui.QFont) -> None: ...
    def setText(self, text: str) -> None: ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def text(self) -> str: ...
    def type(self) -> int: ...


class QGraphicsTextItem(PySide2.QtWidgets.QGraphicsObject):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...

    def adjustSize(self) -> None: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point: PySide2.QtCore.QPointF) -> bool: ...
    def contextMenuEvent(self, event: PySide2.QtWidgets.QGraphicsSceneContextMenuEvent) -> None: ...
    def defaultTextColor(self) -> PySide2.QtGui.QColor: ...
    def document(self) -> PySide2.QtGui.QTextDocument: ...
    def dragEnterEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def dragLeaveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def dragMoveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def dropEvent(self, event: PySide2.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def extension(self, variant: typing.Any) -> typing.Any: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def hoverEnterEvent(self, event: PySide2.QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def hoverLeaveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def hoverMoveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def inputMethodEvent(self, event: PySide2.QtGui.QInputMethodEvent) -> None: ...
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def isObscuredBy(self, item: PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def mouseDoubleClickEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def openExternalLinks(self) -> bool: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def sceneEvent(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def setDefaultTextColor(self, c: PySide2.QtGui.QColor) -> None: ...
    def setDocument(self, document: PySide2.QtGui.QTextDocument) -> None: ...
    def setFont(self, font: PySide2.QtGui.QFont) -> None: ...
    def setHtml(self, html: str) -> None: ...
    def setOpenExternalLinks(self, open: bool) -> None: ...
    def setPlainText(self, text: str) -> None: ...
    def setTabChangesFocus(self, b: bool) -> None: ...
    def setTextCursor(self, cursor: PySide2.QtGui.QTextCursor) -> None: ...
    def setTextInteractionFlags(self, flags: PySide2.QtCore.Qt.TextInteractionFlags) -> None: ...
    def setTextWidth(self, width: float) -> None: ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def tabChangesFocus(self) -> bool: ...
    def textCursor(self) -> PySide2.QtGui.QTextCursor: ...
    def textInteractionFlags(self) -> PySide2.QtCore.Qt.TextInteractionFlags: ...
    def textWidth(self) -> float: ...
    def toHtml(self) -> str: ...
    def toPlainText(self) -> str: ...
    def type(self) -> int: ...


class QGraphicsTransform(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def applyTo(self, matrix: PySide2.QtGui.QMatrix4x4) -> None: ...
    def update(self) -> None: ...


class QGraphicsView(PySide2.QtWidgets.QAbstractScrollArea):
    CacheNone                : QGraphicsView.CacheModeFlag = ... # 0x0
    CacheBackground          : QGraphicsView.CacheModeFlag = ... # 0x1
    NoDrag                   : QGraphicsView.DragMode = ... # 0x0
    ScrollHandDrag           : QGraphicsView.DragMode = ... # 0x1
    RubberBandDrag           : QGraphicsView.DragMode = ... # 0x2
    DontClipPainter          : QGraphicsView.OptimizationFlag = ... # 0x1
    DontSavePainterState     : QGraphicsView.OptimizationFlag = ... # 0x2
    DontAdjustForAntialiasing: QGraphicsView.OptimizationFlag = ... # 0x4
    IndirectPainting         : QGraphicsView.OptimizationFlag = ... # 0x8
    NoAnchor                 : QGraphicsView.ViewportAnchor = ... # 0x0
    AnchorViewCenter         : QGraphicsView.ViewportAnchor = ... # 0x1
    AnchorUnderMouse         : QGraphicsView.ViewportAnchor = ... # 0x2
    FullViewportUpdate       : QGraphicsView.ViewportUpdateMode = ... # 0x0
    MinimalViewportUpdate    : QGraphicsView.ViewportUpdateMode = ... # 0x1
    SmartViewportUpdate      : QGraphicsView.ViewportUpdateMode = ... # 0x2
    NoViewportUpdate         : QGraphicsView.ViewportUpdateMode = ... # 0x3
    BoundingRectViewportUpdate: QGraphicsView.ViewportUpdateMode = ... # 0x4

    class CacheMode(object): ...

    class CacheModeFlag(Shiboken.Enum):
        CacheNone                : QGraphicsView.CacheModeFlag = ... # 0x0
        CacheBackground          : QGraphicsView.CacheModeFlag = ... # 0x1

    class DragMode(Shiboken.Enum):
        NoDrag                   : QGraphicsView.DragMode = ... # 0x0
        ScrollHandDrag           : QGraphicsView.DragMode = ... # 0x1
        RubberBandDrag           : QGraphicsView.DragMode = ... # 0x2

    class OptimizationFlag(Shiboken.Enum):
        DontClipPainter          : QGraphicsView.OptimizationFlag = ... # 0x1
        DontSavePainterState     : QGraphicsView.OptimizationFlag = ... # 0x2
        DontAdjustForAntialiasing: QGraphicsView.OptimizationFlag = ... # 0x4
        IndirectPainting         : QGraphicsView.OptimizationFlag = ... # 0x8

    class OptimizationFlags(object): ...

    class ViewportAnchor(Shiboken.Enum):
        NoAnchor                 : QGraphicsView.ViewportAnchor = ... # 0x0
        AnchorViewCenter         : QGraphicsView.ViewportAnchor = ... # 0x1
        AnchorUnderMouse         : QGraphicsView.ViewportAnchor = ... # 0x2

    class ViewportUpdateMode(Shiboken.Enum):
        FullViewportUpdate       : QGraphicsView.ViewportUpdateMode = ... # 0x0
        MinimalViewportUpdate    : QGraphicsView.ViewportUpdateMode = ... # 0x1
        SmartViewportUpdate      : QGraphicsView.ViewportUpdateMode = ... # 0x2
        NoViewportUpdate         : QGraphicsView.ViewportUpdateMode = ... # 0x3
        BoundingRectViewportUpdate: QGraphicsView.ViewportUpdateMode = ... # 0x4

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, scene: PySide2.QtWidgets.QGraphicsScene, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def backgroundBrush(self) -> PySide2.QtGui.QBrush: ...
    def cacheMode(self) -> PySide2.QtWidgets.QGraphicsView.CacheMode: ...
    @typing.overload
    def centerOn(self, item: PySide2.QtWidgets.QGraphicsItem) -> None: ...
    @typing.overload
    def centerOn(self, pos: PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def centerOn(self, x: float, y: float) -> None: ...
    def contextMenuEvent(self, event: PySide2.QtGui.QContextMenuEvent) -> None: ...
    def dragEnterEvent(self, event: PySide2.QtGui.QDragEnterEvent) -> None: ...
    def dragLeaveEvent(self, event: PySide2.QtGui.QDragLeaveEvent) -> None: ...
    def dragMode(self) -> PySide2.QtWidgets.QGraphicsView.DragMode: ...
    def dragMoveEvent(self, event: PySide2.QtGui.QDragMoveEvent) -> None: ...
    def drawBackground(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRectF) -> None: ...
    def drawForeground(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRectF) -> None: ...
    def drawItems(self, painter: PySide2.QtGui.QPainter, numItems: int, items: typing.Sequence[PySide2.QtWidgets.QGraphicsItem], options: typing.Sequence[PySide2.QtWidgets.QStyleOptionGraphicsItem]) -> None: ...
    def dropEvent(self, event: PySide2.QtGui.QDropEvent) -> None: ...
    @typing.overload
    def ensureVisible(self, item: PySide2.QtWidgets.QGraphicsItem, xmargin: int = ..., ymargin: int = ...) -> None: ...
    @typing.overload
    def ensureVisible(self, rect: PySide2.QtCore.QRectF, xmargin: int = ..., ymargin: int = ...) -> None: ...
    @typing.overload
    def ensureVisible(self, x: float, y: float, w: float, h: float, xmargin: int = ..., ymargin: int = ...) -> None: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    @typing.overload
    def fitInView(self, item: PySide2.QtWidgets.QGraphicsItem, aspectRadioMode: PySide2.QtCore.Qt.AspectRatioMode = ...) -> None: ...
    @typing.overload
    def fitInView(self, rect: PySide2.QtCore.QRectF, aspectRadioMode: PySide2.QtCore.Qt.AspectRatioMode = ...) -> None: ...
    @typing.overload
    def fitInView(self, x: float, y: float, w: float, h: float, aspectRadioMode: PySide2.QtCore.Qt.AspectRatioMode = ...) -> None: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def foregroundBrush(self) -> PySide2.QtGui.QBrush: ...
    def inputMethodEvent(self, event: PySide2.QtGui.QInputMethodEvent) -> None: ...
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def invalidateScene(self, rect: PySide2.QtCore.QRectF = ..., layers: PySide2.QtWidgets.QGraphicsScene.SceneLayers = ...) -> None: ...
    def isInteractive(self) -> bool: ...
    def isTransformed(self) -> bool: ...
    @typing.overload
    def itemAt(self, pos: PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QGraphicsItem: ...
    @typing.overload
    def itemAt(self, x: int, y: int) -> PySide2.QtWidgets.QGraphicsItem: ...
    @typing.overload
    def items(self) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, path: PySide2.QtGui.QPainterPath, mode: PySide2.QtCore.Qt.ItemSelectionMode = ...) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, polygon: PySide2.QtGui.QPolygon, mode: PySide2.QtCore.Qt.ItemSelectionMode = ...) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, pos: PySide2.QtCore.QPoint) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, rect: PySide2.QtCore.QRect, mode: PySide2.QtCore.Qt.ItemSelectionMode = ...) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, x: int, y: int) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, x: int, y: int, w: int, h: int, mode: PySide2.QtCore.Qt.ItemSelectionMode = ...) -> typing.List[PySide2.QtWidgets.QGraphicsItem]: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    @typing.overload
    def mapFromScene(self, path: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def mapFromScene(self, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def mapFromScene(self, polygon: PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygon: ...
    @typing.overload
    def mapFromScene(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygon: ...
    @typing.overload
    def mapFromScene(self, x: float, y: float) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def mapFromScene(self, x: float, y: float, w: float, h: float) -> PySide2.QtGui.QPolygon: ...
    @typing.overload
    def mapToScene(self, path: PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def mapToScene(self, point: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapToScene(self, polygon: PySide2.QtGui.QPolygon) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToScene(self, rect: PySide2.QtCore.QRect) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToScene(self, x: int, y: int) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapToScene(self, x: int, y: int, w: int, h: int) -> PySide2.QtGui.QPolygonF: ...
    def matrix(self) -> PySide2.QtGui.QMatrix: ...
    def mouseDoubleClickEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def optimizationFlags(self) -> PySide2.QtWidgets.QGraphicsView.OptimizationFlags: ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent) -> None: ...
    @typing.overload
    def render(self, painter: PySide2.QtGui.QPainter, target: PySide2.QtCore.QRectF = ..., source: PySide2.QtCore.QRect = ..., aspectRatioMode: PySide2.QtCore.Qt.AspectRatioMode = ...) -> None: ...
    @typing.overload
    def render(self, target: PySide2.QtGui.QPaintDevice, targetOffset: PySide2.QtCore.QPoint = ..., sourceRegion: PySide2.QtGui.QRegion = ..., renderFlags: PySide2.QtWidgets.QWidget.RenderFlags = ...) -> None: ...
    def renderHints(self) -> PySide2.QtGui.QPainter.RenderHints: ...
    def resetCachedContent(self) -> None: ...
    def resetMatrix(self) -> None: ...
    def resetTransform(self) -> None: ...
    def resizeAnchor(self) -> PySide2.QtWidgets.QGraphicsView.ViewportAnchor: ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent) -> None: ...
    def rotate(self, angle: float) -> None: ...
    def rubberBandRect(self) -> PySide2.QtCore.QRect: ...
    def rubberBandSelectionMode(self) -> PySide2.QtCore.Qt.ItemSelectionMode: ...
    def scale(self, sx: float, sy: float) -> None: ...
    def scene(self) -> PySide2.QtWidgets.QGraphicsScene: ...
    def sceneRect(self) -> PySide2.QtCore.QRectF: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def setAlignment(self, alignment: PySide2.QtCore.Qt.Alignment) -> None: ...
    def setBackgroundBrush(self, brush: PySide2.QtGui.QBrush) -> None: ...
    def setCacheMode(self, mode: PySide2.QtWidgets.QGraphicsView.CacheMode) -> None: ...
    def setDragMode(self, mode: PySide2.QtWidgets.QGraphicsView.DragMode) -> None: ...
    def setForegroundBrush(self, brush: PySide2.QtGui.QBrush) -> None: ...
    def setInteractive(self, allowed: bool) -> None: ...
    def setMatrix(self, matrix: PySide2.QtGui.QMatrix, combine: bool = ...) -> None: ...
    def setOptimizationFlag(self, flag: PySide2.QtWidgets.QGraphicsView.OptimizationFlag, enabled: bool = ...) -> None: ...
    def setOptimizationFlags(self, flags: PySide2.QtWidgets.QGraphicsView.OptimizationFlags) -> None: ...
    def setRenderHint(self, hint: PySide2.QtGui.QPainter.RenderHint, enabled: bool = ...) -> None: ...
    def setRenderHints(self, hints: PySide2.QtGui.QPainter.RenderHints) -> None: ...
    def setResizeAnchor(self, anchor: PySide2.QtWidgets.QGraphicsView.ViewportAnchor) -> None: ...
    def setRubberBandSelectionMode(self, mode: PySide2.QtCore.Qt.ItemSelectionMode) -> None: ...
    def setScene(self, scene: PySide2.QtWidgets.QGraphicsScene) -> None: ...
    @typing.overload
    def setSceneRect(self, rect: PySide2.QtCore.QRectF) -> None: ...
    @typing.overload
    def setSceneRect(self, x: float, y: float, w: float, h: float) -> None: ...
    def setTransform(self, matrix: PySide2.QtGui.QTransform, combine: bool = ...) -> None: ...
    def setTransformationAnchor(self, anchor: PySide2.QtWidgets.QGraphicsView.ViewportAnchor) -> None: ...
    def setViewportUpdateMode(self, mode: PySide2.QtWidgets.QGraphicsView.ViewportUpdateMode) -> None: ...
    def setupViewport(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def shear(self, sh: float, sv: float) -> None: ...
    def showEvent(self, event: PySide2.QtGui.QShowEvent) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def transform(self) -> PySide2.QtGui.QTransform: ...
    def transformationAnchor(self) -> PySide2.QtWidgets.QGraphicsView.ViewportAnchor: ...
    def translate(self, dx: float, dy: float) -> None: ...
    def updateScene(self, rects: typing.Sequence[PySide2.QtCore.QRectF]) -> None: ...
    def updateSceneRect(self, rect: PySide2.QtCore.QRectF) -> None: ...
    def viewportEvent(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def viewportTransform(self) -> PySide2.QtGui.QTransform: ...
    def viewportUpdateMode(self) -> PySide2.QtWidgets.QGraphicsView.ViewportUpdateMode: ...
    def wheelEvent(self, event: PySide2.QtGui.QWheelEvent) -> None: ...


class QGraphicsWidget(PySide2.QtWidgets.QGraphicsObject, PySide2.QtWidgets.QGraphicsLayoutItem):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ..., wFlags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...

    def actions(self) -> typing.List[PySide2.QtWidgets.QAction]: ...
    def addAction(self, action: PySide2.QtWidgets.QAction) -> None: ...
    def addActions(self, actions: typing.Sequence[PySide2.QtWidgets.QAction]) -> None: ...
    def adjustSize(self) -> None: ...
    def autoFillBackground(self) -> bool: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def close(self) -> bool: ...
    def closeEvent(self, event: PySide2.QtGui.QCloseEvent) -> None: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusPolicy(self) -> PySide2.QtCore.Qt.FocusPolicy: ...
    def focusWidget(self) -> PySide2.QtWidgets.QGraphicsWidget: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def getContentsMargins(self) -> typing.Tuple[float, float, float, float]: ...
    def getWindowFrameMargins(self) -> typing.Tuple[float, float, float, float]: ...
    def grabKeyboardEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def grabMouseEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def grabShortcut(self, sequence: PySide2.QtGui.QKeySequence, context: PySide2.QtCore.Qt.ShortcutContext = ...) -> int: ...
    def hideEvent(self, event: PySide2.QtGui.QHideEvent) -> None: ...
    def hoverLeaveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def hoverMoveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOption) -> None: ...
    def insertAction(self, before: PySide2.QtWidgets.QAction, action: PySide2.QtWidgets.QAction) -> None: ...
    def insertActions(self, before: PySide2.QtWidgets.QAction, actions: typing.Sequence[PySide2.QtWidgets.QAction]) -> None: ...
    def isActiveWindow(self) -> bool: ...
    def layout(self) -> PySide2.QtWidgets.QGraphicsLayout: ...
    def layoutDirection(self) -> PySide2.QtCore.Qt.LayoutDirection: ...
    def moveEvent(self, event: PySide2.QtWidgets.QGraphicsSceneMoveEvent) -> None: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    def paintWindowFrame(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    def palette(self) -> PySide2.QtGui.QPalette: ...
    def polishEvent(self) -> None: ...
    def propertyChange(self, propertyName: str, value: typing.Any) -> typing.Any: ...
    def rect(self) -> PySide2.QtCore.QRectF: ...
    def releaseShortcut(self, id: int) -> None: ...
    def removeAction(self, action: PySide2.QtWidgets.QAction) -> None: ...
    @typing.overload
    def resize(self, size: PySide2.QtCore.QSizeF) -> None: ...
    @typing.overload
    def resize(self, w: float, h: float) -> None: ...
    def resizeEvent(self, event: PySide2.QtWidgets.QGraphicsSceneResizeEvent) -> None: ...
    def sceneEvent(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def setAttribute(self, attribute: PySide2.QtCore.Qt.WidgetAttribute, on: bool = ...) -> None: ...
    def setAutoFillBackground(self, enabled: bool) -> None: ...
    @typing.overload
    def setContentsMargins(self, left: float, top: float, right: float, bottom: float) -> None: ...
    @typing.overload
    def setContentsMargins(self, margins: PySide2.QtCore.QMarginsF) -> None: ...
    def setFocusPolicy(self, policy: PySide2.QtCore.Qt.FocusPolicy) -> None: ...
    def setFont(self, font: PySide2.QtGui.QFont) -> None: ...
    @typing.overload
    def setGeometry(self, rect: PySide2.QtCore.QRectF) -> None: ...
    @typing.overload
    def setGeometry(self, x: float, y: float, w: float, h: float) -> None: ...
    def setLayout(self, layout: PySide2.QtWidgets.QGraphicsLayout) -> None: ...
    def setLayoutDirection(self, direction: PySide2.QtCore.Qt.LayoutDirection) -> None: ...
    def setPalette(self, palette: PySide2.QtGui.QPalette) -> None: ...
    def setShortcutAutoRepeat(self, id: int, enabled: bool = ...) -> None: ...
    def setShortcutEnabled(self, id: int, enabled: bool = ...) -> None: ...
    def setStyle(self, style: PySide2.QtWidgets.QStyle) -> None: ...
    @staticmethod
    def setTabOrder(first: PySide2.QtWidgets.QGraphicsWidget, second: PySide2.QtWidgets.QGraphicsWidget) -> None: ...
    def setWindowFlags(self, wFlags: PySide2.QtCore.Qt.WindowFlags) -> None: ...
    @typing.overload
    def setWindowFrameMargins(self, left: float, top: float, right: float, bottom: float) -> None: ...
    @typing.overload
    def setWindowFrameMargins(self, margins: PySide2.QtCore.QMarginsF) -> None: ...
    def setWindowTitle(self, title: str) -> None: ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def showEvent(self, event: PySide2.QtGui.QShowEvent) -> None: ...
    def size(self) -> PySide2.QtCore.QSizeF: ...
    def sizeHint(self, which: PySide2.QtCore.Qt.SizeHint, constraint: PySide2.QtCore.QSizeF = ...) -> PySide2.QtCore.QSizeF: ...
    def style(self) -> PySide2.QtWidgets.QStyle: ...
    def testAttribute(self, attribute: PySide2.QtCore.Qt.WidgetAttribute) -> bool: ...
    def type(self) -> int: ...
    def ungrabKeyboardEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def ungrabMouseEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def unsetLayoutDirection(self) -> None: ...
    def unsetWindowFrameMargins(self) -> None: ...
    def updateGeometry(self) -> None: ...
    def windowFlags(self) -> PySide2.QtCore.Qt.WindowFlags: ...
    def windowFrameEvent(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def windowFrameGeometry(self) -> PySide2.QtCore.QRectF: ...
    def windowFrameRect(self) -> PySide2.QtCore.QRectF: ...
    def windowFrameSectionAt(self, pos: PySide2.QtCore.QPointF) -> PySide2.QtCore.Qt.WindowFrameSection: ...
    def windowTitle(self) -> str: ...
    def windowType(self) -> PySide2.QtCore.Qt.WindowType: ...


class QGridLayout(PySide2.QtWidgets.QLayout):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget) -> None: ...

    @typing.overload
    def addItem(self, arg__1: PySide2.QtWidgets.QLayoutItem) -> None: ...
    @typing.overload
    def addItem(self, item: PySide2.QtWidgets.QLayoutItem, row: int, column: int, rowSpan: int = ..., columnSpan: int = ..., alignment: PySide2.QtCore.Qt.Alignment = ...) -> None: ...
    @typing.overload
    def addLayout(self, arg__1: PySide2.QtWidgets.QLayout, row: int, column: int, alignment: PySide2.QtCore.Qt.Alignment = ...) -> None: ...
    @typing.overload
    def addLayout(self, arg__1: PySide2.QtWidgets.QLayout, row: int, column: int, rowSpan: int, columnSpan: int, alignment: PySide2.QtCore.Qt.Alignment = ...) -> None: ...
    @typing.overload
    def addWidget(self, arg__1: PySide2.QtWidgets.QWidget, row: int, column: int, alignment: PySide2.QtCore.Qt.Alignment = ...) -> None: ...
    @typing.overload
    def addWidget(self, arg__1: PySide2.QtWidgets.QWidget, row: int, column: int, rowSpan: int, columnSpan: int, alignment: PySide2.QtCore.Qt.Alignment = ...) -> None: ...
    @typing.overload
    def addWidget(self, w: PySide2.QtWidgets.QWidget) -> None: ...
    def cellRect(self, row: int, column: int) -> PySide2.QtCore.QRect: ...
    def columnCount(self) -> int: ...
    def columnMinimumWidth(self, column: int) -> int: ...
    def columnStretch(self, column: int) -> int: ...
    def count(self) -> int: ...
    def expandingDirections(self) -> PySide2.QtCore.Qt.Orientations: ...
    def getItemPosition(self, idx: int) -> typing.Tuple[int, int, int, int]: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def horizontalSpacing(self) -> int: ...
    def invalidate(self) -> None: ...
    def itemAt(self, index: int) -> PySide2.QtWidgets.QLayoutItem: ...
    def itemAtPosition(self, row: int, column: int) -> PySide2.QtWidgets.QLayoutItem: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def minimumHeightForWidth(self, arg__1: int) -> int: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def originCorner(self) -> PySide2.QtCore.Qt.Corner: ...
    def rowCount(self) -> int: ...
    def rowMinimumHeight(self, row: int) -> int: ...
    def rowStretch(self, row: int) -> int: ...
    def setColumnMinimumWidth(self, column: int, minSize: int) -> None: ...
    def setColumnStretch(self, column: int, stretch: int) -> None: ...
    def setDefaultPositioning(self, n: int, orient: PySide2.QtCore.Qt.Orientation) -> None: ...
    def setGeometry(self, arg__1: PySide2.QtCore.QRect) -> None: ...
    def setHorizontalSpacing(self, spacing: int) -> None: ...
    def setOriginCorner(self, arg__1: PySide2.QtCore.Qt.Corner) -> None: ...
    def setRowMinimumHeight(self, row: int, minSize: int) -> None: ...
    def setRowStretch(self, row: int, stretch: int) -> None: ...
    def setSpacing(self, spacing: int) -> None: ...
    def setVerticalSpacing(self, spacing: int) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def spacing(self) -> int: ...
    def takeAt(self, index: int) -> PySide2.QtWidgets.QLayoutItem: ...
    def verticalSpacing(self) -> int: ...


class QGroupBox(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, title: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def childEvent(self, event: PySide2.QtCore.QChildEvent) -> None: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionGroupBox) -> None: ...
    def isCheckable(self) -> bool: ...
    def isChecked(self) -> bool: ...
    def isFlat(self) -> bool: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent) -> None: ...
    def setAlignment(self, alignment: int) -> None: ...
    def setCheckable(self, checkable: bool) -> None: ...
    def setChecked(self, checked: bool) -> None: ...
    def setFlat(self, flat: bool) -> None: ...
    def setTitle(self, title: str) -> None: ...
    def title(self) -> str: ...


class QHBoxLayout(PySide2.QtWidgets.QBoxLayout):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget) -> None: ...


class QHeaderView(PySide2.QtWidgets.QAbstractItemView):
    Interactive              : QHeaderView.ResizeMode = ... # 0x0
    Stretch                  : QHeaderView.ResizeMode = ... # 0x1
    Custom                   : QHeaderView.ResizeMode = ... # 0x2
    Fixed                    : QHeaderView.ResizeMode = ... # 0x2
    ResizeToContents         : QHeaderView.ResizeMode = ... # 0x3

    class ResizeMode(Shiboken.Enum):
        Interactive              : QHeaderView.ResizeMode = ... # 0x0
        Stretch                  : QHeaderView.ResizeMode = ... # 0x1
        Custom                   : QHeaderView.ResizeMode = ... # 0x2
        Fixed                    : QHeaderView.ResizeMode = ... # 0x2
        ResizeToContents         : QHeaderView.ResizeMode = ... # 0x3

    def __init__(self, orientation: PySide2.QtCore.Qt.Orientation, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def cascadingSectionResizes(self) -> bool: ...
    def count(self) -> int: ...
    def currentChanged(self, current: PySide2.QtCore.QModelIndex, old: PySide2.QtCore.QModelIndex) -> None: ...
    def dataChanged(self, topLeft: PySide2.QtCore.QModelIndex, bottomRight: PySide2.QtCore.QModelIndex, roles: typing.List[int] = ...) -> None: ...
    def defaultAlignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def defaultSectionSize(self) -> int: ...
    def doItemsLayout(self) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def headerDataChanged(self, orientation: PySide2.QtCore.Qt.Orientation, logicalFirst: int, logicalLast: int) -> None: ...
    def hiddenSectionCount(self) -> int: ...
    def hideSection(self, logicalIndex: int) -> None: ...
    def highlightSections(self) -> bool: ...
    def horizontalOffset(self) -> int: ...
    def indexAt(self, p: PySide2.QtCore.QPoint) -> PySide2.QtCore.QModelIndex: ...
    @typing.overload
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionFrame) -> None: ...
    @typing.overload
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionHeader) -> None: ...
    def initialize(self) -> None: ...
    @typing.overload
    def initializeSections(self) -> None: ...
    @typing.overload
    def initializeSections(self, start: int, end: int) -> None: ...
    def isFirstSectionMovable(self) -> bool: ...
    def isIndexHidden(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def isSectionHidden(self, logicalIndex: int) -> bool: ...
    def isSortIndicatorShown(self) -> bool: ...
    def length(self) -> int: ...
    def logicalIndex(self, visualIndex: int) -> int: ...
    @typing.overload
    def logicalIndexAt(self, pos: PySide2.QtCore.QPoint) -> int: ...
    @typing.overload
    def logicalIndexAt(self, position: int) -> int: ...
    @typing.overload
    def logicalIndexAt(self, x: int, y: int) -> int: ...
    def maximumSectionSize(self) -> int: ...
    def minimumSectionSize(self) -> int: ...
    def mouseDoubleClickEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def moveCursor(self, arg__1: PySide2.QtWidgets.QAbstractItemView.CursorAction, arg__2: PySide2.QtCore.Qt.KeyboardModifiers) -> PySide2.QtCore.QModelIndex: ...
    def moveSection(self, from_: int, to: int) -> None: ...
    def offset(self) -> int: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def paintEvent(self, e: PySide2.QtGui.QPaintEvent) -> None: ...
    def paintSection(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRect, logicalIndex: int) -> None: ...
    def reset(self) -> None: ...
    def resetDefaultSectionSize(self) -> None: ...
    def resizeContentsPrecision(self) -> int: ...
    def resizeSection(self, logicalIndex: int, size: int) -> None: ...
    @typing.overload
    def resizeSections(self) -> None: ...
    @typing.overload
    def resizeSections(self, mode: PySide2.QtWidgets.QHeaderView.ResizeMode) -> None: ...
    def restoreState(self, state: PySide2.QtCore.QByteArray) -> bool: ...
    def rowsInserted(self, parent: PySide2.QtCore.QModelIndex, start: int, end: int) -> None: ...
    def saveState(self) -> PySide2.QtCore.QByteArray: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def scrollTo(self, index: PySide2.QtCore.QModelIndex, hint: PySide2.QtWidgets.QAbstractItemView.ScrollHint) -> None: ...
    def sectionPosition(self, logicalIndex: int) -> int: ...
    def sectionResizeMode(self, logicalIndex: int) -> PySide2.QtWidgets.QHeaderView.ResizeMode: ...
    def sectionSize(self, logicalIndex: int) -> int: ...
    def sectionSizeFromContents(self, logicalIndex: int) -> PySide2.QtCore.QSize: ...
    def sectionSizeHint(self, logicalIndex: int) -> int: ...
    def sectionViewportPosition(self, logicalIndex: int) -> int: ...
    def sectionsAboutToBeRemoved(self, parent: PySide2.QtCore.QModelIndex, logicalFirst: int, logicalLast: int) -> None: ...
    def sectionsClickable(self) -> bool: ...
    def sectionsHidden(self) -> bool: ...
    def sectionsInserted(self, parent: PySide2.QtCore.QModelIndex, logicalFirst: int, logicalLast: int) -> None: ...
    def sectionsMovable(self) -> bool: ...
    def sectionsMoved(self) -> bool: ...
    def setCascadingSectionResizes(self, enable: bool) -> None: ...
    def setDefaultAlignment(self, alignment: PySide2.QtCore.Qt.Alignment) -> None: ...
    def setDefaultSectionSize(self, size: int) -> None: ...
    def setFirstSectionMovable(self, movable: bool) -> None: ...
    def setHighlightSections(self, highlight: bool) -> None: ...
    def setMaximumSectionSize(self, size: int) -> None: ...
    def setMinimumSectionSize(self, size: int) -> None: ...
    def setModel(self, model: PySide2.QtCore.QAbstractItemModel) -> None: ...
    def setOffset(self, offset: int) -> None: ...
    def setOffsetToLastSection(self) -> None: ...
    def setOffsetToSectionPosition(self, visualIndex: int) -> None: ...
    def setResizeContentsPrecision(self, precision: int) -> None: ...
    def setSectionHidden(self, logicalIndex: int, hide: bool) -> None: ...
    @typing.overload
    def setSectionResizeMode(self, logicalIndex: int, mode: PySide2.QtWidgets.QHeaderView.ResizeMode) -> None: ...
    @typing.overload
    def setSectionResizeMode(self, mode: PySide2.QtWidgets.QHeaderView.ResizeMode) -> None: ...
    def setSectionsClickable(self, clickable: bool) -> None: ...
    def setSectionsMovable(self, movable: bool) -> None: ...
    def setSelection(self, rect: PySide2.QtCore.QRect, flags: PySide2.QtCore.QItemSelectionModel.SelectionFlags) -> None: ...
    def setSortIndicator(self, logicalIndex: int, order: PySide2.QtCore.Qt.SortOrder) -> None: ...
    def setSortIndicatorShown(self, show: bool) -> None: ...
    def setStretchLastSection(self, stretch: bool) -> None: ...
    def setVisible(self, v: bool) -> None: ...
    def showSection(self, logicalIndex: int) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def sortIndicatorOrder(self) -> PySide2.QtCore.Qt.SortOrder: ...
    def sortIndicatorSection(self) -> int: ...
    def stretchLastSection(self) -> bool: ...
    def stretchSectionCount(self) -> int: ...
    def swapSections(self, first: int, second: int) -> None: ...
    def updateGeometries(self) -> None: ...
    def updateSection(self, logicalIndex: int) -> None: ...
    def verticalOffset(self) -> int: ...
    def viewportEvent(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def visualIndex(self, logicalIndex: int) -> int: ...
    def visualIndexAt(self, position: int) -> int: ...
    def visualRect(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide2.QtCore.QItemSelection) -> PySide2.QtGui.QRegion: ...


class QInputDialog(PySide2.QtWidgets.QDialog):
    NoButtons                : QInputDialog.InputDialogOption = ... # 0x1
    UseListViewForComboBoxItems: QInputDialog.InputDialogOption = ... # 0x2
    UsePlainTextEditForTextInput: QInputDialog.InputDialogOption = ... # 0x4
    TextInput                : QInputDialog.InputMode = ... # 0x0
    IntInput                 : QInputDialog.InputMode = ... # 0x1
    DoubleInput              : QInputDialog.InputMode = ... # 0x2

    class InputDialogOption(Shiboken.Enum):
        NoButtons                : QInputDialog.InputDialogOption = ... # 0x1
        UseListViewForComboBoxItems: QInputDialog.InputDialogOption = ... # 0x2
        UsePlainTextEditForTextInput: QInputDialog.InputDialogOption = ... # 0x4

    class InputMode(Shiboken.Enum):
        TextInput                : QInputDialog.InputMode = ... # 0x0
        IntInput                 : QInputDialog.InputMode = ... # 0x1
        DoubleInput              : QInputDialog.InputMode = ... # 0x2

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...

    def cancelButtonText(self) -> str: ...
    def comboBoxItems(self) -> typing.List[str]: ...
    def done(self, result: int) -> None: ...
    def doubleDecimals(self) -> int: ...
    def doubleMaximum(self) -> float: ...
    def doubleMinimum(self) -> float: ...
    def doubleStep(self) -> float: ...
    def doubleValue(self) -> float: ...
    @typing.overload
    @staticmethod
    def getDouble(parent: PySide2.QtWidgets.QWidget, title: str, label: str, value: float, minValue: float, maxValue: float, decimals: int, flags: PySide2.QtCore.Qt.WindowFlags, step: float) -> typing.Tuple[float, bool]: ...
    @typing.overload
    @staticmethod
    def getDouble(parent: PySide2.QtWidgets.QWidget, title: str, label: str, value: float, minValue: float = ..., maxValue: float = ..., decimals: int = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> typing.Tuple[float, bool]: ...
    @staticmethod
    def getInt(parent: PySide2.QtWidgets.QWidget, title: str, label: str, value: int, minValue: int = ..., maxValue: int = ..., step: int = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> typing.Tuple[int, bool]: ...
    @staticmethod
    def getItem(parent: PySide2.QtWidgets.QWidget, title: str, label: str, items: typing.Sequence[str], current: int, editable: bool = ..., flags: PySide2.QtCore.Qt.WindowFlags = ..., inputMethodHints: PySide2.QtCore.Qt.InputMethodHints = ...) -> typing.Tuple[str, bool]: ...
    @staticmethod
    def getMultiLineText(parent: PySide2.QtWidgets.QWidget, title: str, label: str, text: str, flags: PySide2.QtCore.Qt.WindowFlags = ..., inputMethodHints: PySide2.QtCore.Qt.InputMethodHints = ...) -> typing.Tuple[str, bool]: ...
    @staticmethod
    def getText(parent: PySide2.QtWidgets.QWidget, title: str, label: str, echo: PySide2.QtWidgets.QLineEdit.EchoMode, text: str = ..., flags: PySide2.QtCore.Qt.WindowFlags = ..., inputMethodHints: PySide2.QtCore.Qt.InputMethodHints = ...) -> typing.Tuple[str, bool]: ...
    def inputMode(self) -> PySide2.QtWidgets.QInputDialog.InputMode: ...
    def intMaximum(self) -> int: ...
    def intMinimum(self) -> int: ...
    def intStep(self) -> int: ...
    def intValue(self) -> int: ...
    def isComboBoxEditable(self) -> bool: ...
    def labelText(self) -> str: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def okButtonText(self) -> str: ...
    @typing.overload
    def open(self) -> None: ...
    @typing.overload
    def open(self, receiver: PySide2.QtCore.QObject, member: bytes) -> None: ...
    def setCancelButtonText(self, text: str) -> None: ...
    def setComboBoxEditable(self, editable: bool) -> None: ...
    def setComboBoxItems(self, items: typing.Sequence[str]) -> None: ...
    def setDoubleDecimals(self, decimals: int) -> None: ...
    def setDoubleMaximum(self, max: float) -> None: ...
    def setDoubleMinimum(self, min: float) -> None: ...
    def setDoubleRange(self, min: float, max: float) -> None: ...
    def setDoubleStep(self, step: float) -> None: ...
    def setDoubleValue(self, value: float) -> None: ...
    def setInputMode(self, mode: PySide2.QtWidgets.QInputDialog.InputMode) -> None: ...
    def setIntMaximum(self, max: int) -> None: ...
    def setIntMinimum(self, min: int) -> None: ...
    def setIntRange(self, min: int, max: int) -> None: ...
    def setIntStep(self, step: int) -> None: ...
    def setIntValue(self, value: int) -> None: ...
    def setLabelText(self, text: str) -> None: ...
    def setOkButtonText(self, text: str) -> None: ...
    def setOption(self, option: PySide2.QtWidgets.QInputDialog.InputDialogOption, on: bool = ...) -> None: ...
    def setTextEchoMode(self, mode: PySide2.QtWidgets.QLineEdit.EchoMode) -> None: ...
    def setTextValue(self, text: str) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def testOption(self, option: PySide2.QtWidgets.QInputDialog.InputDialogOption) -> bool: ...
    def textEchoMode(self) -> PySide2.QtWidgets.QLineEdit.EchoMode: ...
    def textValue(self) -> str: ...


class QItemDelegate(PySide2.QtWidgets.QAbstractItemDelegate):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def createEditor(self, parent: PySide2.QtWidgets.QWidget, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QWidget: ...
    def decoration(self, option: PySide2.QtWidgets.QStyleOptionViewItem, variant: typing.Any) -> PySide2.QtGui.QPixmap: ...
    def doCheck(self, option: PySide2.QtWidgets.QStyleOptionViewItem, bounding: PySide2.QtCore.QRect, variant: typing.Any) -> PySide2.QtCore.QRect: ...
    def drawBackground(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> None: ...
    def drawCheck(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionViewItem, rect: PySide2.QtCore.QRect, state: PySide2.QtCore.Qt.CheckState) -> None: ...
    def drawDecoration(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionViewItem, rect: PySide2.QtCore.QRect, pixmap: PySide2.QtGui.QPixmap) -> None: ...
    def drawDisplay(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionViewItem, rect: PySide2.QtCore.QRect, text: str) -> None: ...
    def drawFocus(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionViewItem, rect: PySide2.QtCore.QRect) -> None: ...
    def editorEvent(self, event: PySide2.QtCore.QEvent, model: PySide2.QtCore.QAbstractItemModel, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def eventFilter(self, object: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    def hasClipping(self) -> bool: ...
    def itemEditorFactory(self) -> PySide2.QtWidgets.QItemEditorFactory: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> None: ...
    def rect(self, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex, role: int) -> PySide2.QtCore.QRect: ...
    @staticmethod
    def selectedPixmap(pixmap: PySide2.QtGui.QPixmap, palette: PySide2.QtGui.QPalette, enabled: bool) -> PySide2.QtGui.QPixmap: ...
    def setClipping(self, clip: bool) -> None: ...
    def setEditorData(self, editor: PySide2.QtWidgets.QWidget, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setItemEditorFactory(self, factory: PySide2.QtWidgets.QItemEditorFactory) -> None: ...
    def setModelData(self, editor: PySide2.QtWidgets.QWidget, model: PySide2.QtCore.QAbstractItemModel, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setOptions(self, index: PySide2.QtCore.QModelIndex, option: PySide2.QtWidgets.QStyleOptionViewItem) -> PySide2.QtWidgets.QStyleOptionViewItem: ...
    def sizeHint(self, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QSize: ...
    def textRectangle(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRect, font: PySide2.QtGui.QFont, text: str) -> PySide2.QtCore.QRect: ...
    def updateEditorGeometry(self, editor: PySide2.QtWidgets.QWidget, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> None: ...


class QItemEditorCreatorBase(Shiboken.Object):

    def __init__(self) -> None: ...

    def createWidget(self, parent: PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QWidget: ...
    def valuePropertyName(self) -> PySide2.QtCore.QByteArray: ...


class QItemEditorFactory(Shiboken.Object):

    def __init__(self) -> None: ...

    def createEditor(self, userType: int, parent: PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QWidget: ...
    @staticmethod
    def defaultFactory() -> PySide2.QtWidgets.QItemEditorFactory: ...
    def registerEditor(self, userType: int, creator: PySide2.QtWidgets.QItemEditorCreatorBase) -> None: ...
    @staticmethod
    def setDefaultFactory(factory: PySide2.QtWidgets.QItemEditorFactory) -> None: ...
    def valuePropertyName(self, userType: int) -> PySide2.QtCore.QByteArray: ...


class QKeyEventTransition(PySide2.QtCore.QEventTransition):

    @typing.overload
    def __init__(self, object: PySide2.QtCore.QObject, type: PySide2.QtCore.QEvent.Type, key: int, sourceState: typing.Optional[PySide2.QtCore.QState] = ...) -> None: ...
    @typing.overload
    def __init__(self, sourceState: typing.Optional[PySide2.QtCore.QState] = ...) -> None: ...

    def eventTest(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def key(self) -> int: ...
    def modifierMask(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def onTransition(self, event: PySide2.QtCore.QEvent) -> None: ...
    def setKey(self, key: int) -> None: ...
    def setModifierMask(self, modifiers: PySide2.QtCore.Qt.KeyboardModifiers) -> None: ...


class QKeySequenceEdit(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, keySequence: PySide2.QtGui.QKeySequence, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def clear(self) -> None: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, arg__1: PySide2.QtGui.QKeyEvent) -> None: ...
    def keySequence(self) -> PySide2.QtGui.QKeySequence: ...
    def setKeySequence(self, keySequence: PySide2.QtGui.QKeySequence) -> None: ...
    def timerEvent(self, arg__1: PySide2.QtCore.QTimerEvent) -> None: ...


class QLCDNumber(PySide2.QtWidgets.QFrame):
    Hex                      : QLCDNumber.Mode = ... # 0x0
    Dec                      : QLCDNumber.Mode = ... # 0x1
    Oct                      : QLCDNumber.Mode = ... # 0x2
    Bin                      : QLCDNumber.Mode = ... # 0x3
    Outline                  : QLCDNumber.SegmentStyle = ... # 0x0
    Filled                   : QLCDNumber.SegmentStyle = ... # 0x1
    Flat                     : QLCDNumber.SegmentStyle = ... # 0x2

    class Mode(Shiboken.Enum):
        Hex                      : QLCDNumber.Mode = ... # 0x0
        Dec                      : QLCDNumber.Mode = ... # 0x1
        Oct                      : QLCDNumber.Mode = ... # 0x2
        Bin                      : QLCDNumber.Mode = ... # 0x3

    class SegmentStyle(Shiboken.Enum):
        Outline                  : QLCDNumber.SegmentStyle = ... # 0x0
        Filled                   : QLCDNumber.SegmentStyle = ... # 0x1
        Flat                     : QLCDNumber.SegmentStyle = ... # 0x2

    @typing.overload
    def __init__(self, numDigits: int, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    @typing.overload
    def checkOverflow(self, num: float) -> bool: ...
    @typing.overload
    def checkOverflow(self, num: int) -> bool: ...
    def digitCount(self) -> int: ...
    @typing.overload
    def display(self, num: float) -> None: ...
    @typing.overload
    def display(self, num: int) -> None: ...
    @typing.overload
    def display(self, str: str) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def intValue(self) -> int: ...
    def mode(self) -> PySide2.QtWidgets.QLCDNumber.Mode: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def segmentStyle(self) -> PySide2.QtWidgets.QLCDNumber.SegmentStyle: ...
    def setBinMode(self) -> None: ...
    def setDecMode(self) -> None: ...
    def setDigitCount(self, nDigits: int) -> None: ...
    def setHexMode(self) -> None: ...
    def setMode(self, arg__1: PySide2.QtWidgets.QLCDNumber.Mode) -> None: ...
    def setOctMode(self) -> None: ...
    def setSegmentStyle(self, arg__1: PySide2.QtWidgets.QLCDNumber.SegmentStyle) -> None: ...
    def setSmallDecimalPoint(self, arg__1: bool) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def smallDecimalPoint(self) -> bool: ...
    def value(self) -> float: ...


class QLabel(PySide2.QtWidgets.QFrame):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., f: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., f: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...

    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def buddy(self) -> PySide2.QtWidgets.QWidget: ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def contextMenuEvent(self, ev: PySide2.QtGui.QContextMenuEvent) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, ev: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, ev: PySide2.QtGui.QFocusEvent) -> None: ...
    def hasScaledContents(self) -> bool: ...
    def hasSelectedText(self) -> bool: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def indent(self) -> int: ...
    def keyPressEvent(self, ev: PySide2.QtGui.QKeyEvent) -> None: ...
    def margin(self) -> int: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, ev: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, ev: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, ev: PySide2.QtGui.QMouseEvent) -> None: ...
    def movie(self) -> PySide2.QtGui.QMovie: ...
    def openExternalLinks(self) -> bool: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def picture(self) -> PySide2.QtGui.QPicture: ...
    def pixmap(self) -> PySide2.QtGui.QPixmap: ...
    def selectedText(self) -> str: ...
    def selectionStart(self) -> int: ...
    def setAlignment(self, arg__1: PySide2.QtCore.Qt.Alignment) -> None: ...
    def setBuddy(self, arg__1: PySide2.QtWidgets.QWidget) -> None: ...
    def setIndent(self, arg__1: int) -> None: ...
    def setMargin(self, arg__1: int) -> None: ...
    def setMovie(self, movie: PySide2.QtGui.QMovie) -> None: ...
    @typing.overload
    def setNum(self, arg__1: float) -> None: ...
    @typing.overload
    def setNum(self, arg__1: int) -> None: ...
    def setOpenExternalLinks(self, open: bool) -> None: ...
    def setPicture(self, arg__1: PySide2.QtGui.QPicture) -> None: ...
    def setPixmap(self, arg__1: PySide2.QtGui.QPixmap) -> None: ...
    def setScaledContents(self, arg__1: bool) -> None: ...
    def setSelection(self, arg__1: int, arg__2: int) -> None: ...
    def setText(self, arg__1: str) -> None: ...
    def setTextFormat(self, arg__1: PySide2.QtCore.Qt.TextFormat) -> None: ...
    def setTextInteractionFlags(self, flags: PySide2.QtCore.Qt.TextInteractionFlags) -> None: ...
    def setWordWrap(self, on: bool) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def text(self) -> str: ...
    def textFormat(self) -> PySide2.QtCore.Qt.TextFormat: ...
    def textInteractionFlags(self) -> PySide2.QtCore.Qt.TextInteractionFlags: ...
    def wordWrap(self) -> bool: ...


class QLayout(PySide2.QtCore.QObject, PySide2.QtWidgets.QLayoutItem):
    SetDefaultConstraint     : QLayout.SizeConstraint = ... # 0x0
    SetNoConstraint          : QLayout.SizeConstraint = ... # 0x1
    SetMinimumSize           : QLayout.SizeConstraint = ... # 0x2
    SetFixedSize             : QLayout.SizeConstraint = ... # 0x3
    SetMaximumSize           : QLayout.SizeConstraint = ... # 0x4
    SetMinAndMaxSize         : QLayout.SizeConstraint = ... # 0x5

    class SizeConstraint(Shiboken.Enum):
        SetDefaultConstraint     : QLayout.SizeConstraint = ... # 0x0
        SetNoConstraint          : QLayout.SizeConstraint = ... # 0x1
        SetMinimumSize           : QLayout.SizeConstraint = ... # 0x2
        SetFixedSize             : QLayout.SizeConstraint = ... # 0x3
        SetMaximumSize           : QLayout.SizeConstraint = ... # 0x4
        SetMinAndMaxSize         : QLayout.SizeConstraint = ... # 0x5

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget) -> None: ...

    def activate(self) -> bool: ...
    def addChildLayout(self, l: PySide2.QtWidgets.QLayout) -> None: ...
    def addChildWidget(self, w: PySide2.QtWidgets.QWidget) -> None: ...
    def addItem(self, arg__1: PySide2.QtWidgets.QLayoutItem) -> None: ...
    def addWidget(self, w: PySide2.QtWidgets.QWidget) -> None: ...
    def adoptLayout(self, layout: PySide2.QtWidgets.QLayout) -> bool: ...
    def alignmentRect(self, arg__1: PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...
    def childEvent(self, e: PySide2.QtCore.QChildEvent) -> None: ...
    @staticmethod
    def closestAcceptableSize(w: PySide2.QtWidgets.QWidget, s: PySide2.QtCore.QSize) -> PySide2.QtCore.QSize: ...
    def contentsMargins(self) -> PySide2.QtCore.QMargins: ...
    def contentsRect(self) -> PySide2.QtCore.QRect: ...
    def controlTypes(self) -> PySide2.QtWidgets.QSizePolicy.ControlTypes: ...
    def count(self) -> int: ...
    def expandingDirections(self) -> PySide2.QtCore.Qt.Orientations: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def getContentsMargins(self) -> typing.Tuple[int, int, int, int]: ...
    @typing.overload
    def indexOf(self, arg__1: PySide2.QtWidgets.QLayoutItem) -> int: ...
    @typing.overload
    def indexOf(self, arg__1: PySide2.QtWidgets.QWidget) -> int: ...
    def invalidate(self) -> None: ...
    def isEmpty(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def itemAt(self, index: int) -> PySide2.QtWidgets.QLayoutItem: ...
    def layout(self) -> PySide2.QtWidgets.QLayout: ...
    def margin(self) -> int: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def menuBar(self) -> PySide2.QtWidgets.QWidget: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def parentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def removeItem(self, arg__1: PySide2.QtWidgets.QLayoutItem) -> None: ...
    def removeWidget(self, w: PySide2.QtWidgets.QWidget) -> None: ...
    def replaceWidget(self, from_: PySide2.QtWidgets.QWidget, to: PySide2.QtWidgets.QWidget, options: PySide2.QtCore.Qt.FindChildOptions = ...) -> PySide2.QtWidgets.QLayoutItem: ...
    @typing.overload
    def setAlignment(self, arg__1: PySide2.QtCore.Qt.Alignment) -> None: ...
    @typing.overload
    def setAlignment(self, l: PySide2.QtWidgets.QLayout, alignment: PySide2.QtCore.Qt.Alignment) -> bool: ...
    @typing.overload
    def setAlignment(self, w: PySide2.QtWidgets.QWidget, alignment: PySide2.QtCore.Qt.Alignment) -> bool: ...
    @typing.overload
    def setContentsMargins(self, left: int, top: int, right: int, bottom: int) -> None: ...
    @typing.overload
    def setContentsMargins(self, margins: PySide2.QtCore.QMargins) -> None: ...
    def setEnabled(self, arg__1: bool) -> None: ...
    def setGeometry(self, arg__1: PySide2.QtCore.QRect) -> None: ...
    def setMargin(self, arg__1: int) -> None: ...
    def setMenuBar(self, w: PySide2.QtWidgets.QWidget) -> None: ...
    def setSizeConstraint(self, arg__1: PySide2.QtWidgets.QLayout.SizeConstraint) -> None: ...
    def setSpacing(self, arg__1: int) -> None: ...
    def sizeConstraint(self) -> PySide2.QtWidgets.QLayout.SizeConstraint: ...
    def spacing(self) -> int: ...
    def takeAt(self, index: int) -> PySide2.QtWidgets.QLayoutItem: ...
    def totalHeightForWidth(self, w: int) -> int: ...
    def totalMaximumSize(self) -> PySide2.QtCore.QSize: ...
    def totalMinimumSize(self) -> PySide2.QtCore.QSize: ...
    def totalSizeHint(self) -> PySide2.QtCore.QSize: ...
    def update(self) -> None: ...
    def widgetEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...


class QLayoutItem(Shiboken.Object):

    def __init__(self, alignment: PySide2.QtCore.Qt.Alignment = ...) -> None: ...

    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def controlTypes(self) -> PySide2.QtWidgets.QSizePolicy.ControlTypes: ...
    def expandingDirections(self) -> PySide2.QtCore.Qt.Orientations: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def invalidate(self) -> None: ...
    def isEmpty(self) -> bool: ...
    def layout(self) -> PySide2.QtWidgets.QLayout: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def minimumHeightForWidth(self, arg__1: int) -> int: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def setAlignment(self, a: PySide2.QtCore.Qt.Alignment) -> None: ...
    def setGeometry(self, arg__1: PySide2.QtCore.QRect) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def spacerItem(self) -> PySide2.QtWidgets.QSpacerItem: ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...


class QLineEdit(PySide2.QtWidgets.QWidget):
    LeadingPosition          : QLineEdit.ActionPosition = ... # 0x0
    TrailingPosition         : QLineEdit.ActionPosition = ... # 0x1
    Normal                   : QLineEdit.EchoMode = ... # 0x0
    NoEcho                   : QLineEdit.EchoMode = ... # 0x1
    Password                 : QLineEdit.EchoMode = ... # 0x2
    PasswordEchoOnEdit       : QLineEdit.EchoMode = ... # 0x3

    class ActionPosition(Shiboken.Enum):
        LeadingPosition          : QLineEdit.ActionPosition = ... # 0x0
        TrailingPosition         : QLineEdit.ActionPosition = ... # 0x1

    class EchoMode(Shiboken.Enum):
        Normal                   : QLineEdit.EchoMode = ... # 0x0
        NoEcho                   : QLineEdit.EchoMode = ... # 0x1
        Password                 : QLineEdit.EchoMode = ... # 0x2
        PasswordEchoOnEdit       : QLineEdit.EchoMode = ... # 0x3

    @typing.overload
    def __init__(self, arg__1: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    @typing.overload
    def addAction(self, action: PySide2.QtWidgets.QAction) -> None: ...
    @typing.overload
    def addAction(self, action: PySide2.QtWidgets.QAction, position: PySide2.QtWidgets.QLineEdit.ActionPosition) -> None: ...
    @typing.overload
    def addAction(self, arg__1: PySide2.QtWidgets.QAction) -> None: ...
    @typing.overload
    def addAction(self, icon: PySide2.QtGui.QIcon, position: PySide2.QtWidgets.QLineEdit.ActionPosition) -> PySide2.QtWidgets.QAction: ...
    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def backspace(self) -> None: ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def completer(self) -> PySide2.QtWidgets.QCompleter: ...
    def contextMenuEvent(self, arg__1: PySide2.QtGui.QContextMenuEvent) -> None: ...
    def copy(self) -> None: ...
    def createStandardContextMenu(self) -> PySide2.QtWidgets.QMenu: ...
    def cursorBackward(self, mark: bool, steps: int = ...) -> None: ...
    def cursorForward(self, mark: bool, steps: int = ...) -> None: ...
    def cursorMoveStyle(self) -> PySide2.QtCore.Qt.CursorMoveStyle: ...
    def cursorPosition(self) -> int: ...
    def cursorPositionAt(self, pos: PySide2.QtCore.QPoint) -> int: ...
    def cursorRect(self) -> PySide2.QtCore.QRect: ...
    def cursorWordBackward(self, mark: bool) -> None: ...
    def cursorWordForward(self, mark: bool) -> None: ...
    def cut(self) -> None: ...
    def del_(self) -> None: ...
    def deselect(self) -> None: ...
    def displayText(self) -> str: ...
    def dragEnabled(self) -> bool: ...
    def dragEnterEvent(self, arg__1: PySide2.QtGui.QDragEnterEvent) -> None: ...
    def dragLeaveEvent(self, e: PySide2.QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, e: PySide2.QtGui.QDragMoveEvent) -> None: ...
    def dropEvent(self, arg__1: PySide2.QtGui.QDropEvent) -> None: ...
    def echoMode(self) -> PySide2.QtWidgets.QLineEdit.EchoMode: ...
    def end(self, mark: bool) -> None: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, arg__1: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, arg__1: PySide2.QtGui.QFocusEvent) -> None: ...
    def getTextMargins(self) -> typing.Tuple[int, int, int, int]: ...
    def hasAcceptableInput(self) -> bool: ...
    def hasFrame(self) -> bool: ...
    def hasSelectedText(self) -> bool: ...
    def home(self, mark: bool) -> None: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionFrame) -> None: ...
    def inputMask(self) -> str: ...
    def inputMethodEvent(self, arg__1: PySide2.QtGui.QInputMethodEvent) -> None: ...
    @typing.overload
    def inputMethodQuery(self, arg__1: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    @typing.overload
    def inputMethodQuery(self, property: PySide2.QtCore.Qt.InputMethodQuery, argument: typing.Any) -> typing.Any: ...
    def insert(self, arg__1: str) -> None: ...
    def isClearButtonEnabled(self) -> bool: ...
    def isModified(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def isRedoAvailable(self) -> bool: ...
    def isUndoAvailable(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent) -> None: ...
    def maxLength(self) -> int: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseDoubleClickEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def paste(self) -> None: ...
    def placeholderText(self) -> str: ...
    def redo(self) -> None: ...
    def selectAll(self) -> None: ...
    def selectedText(self) -> str: ...
    def selectionEnd(self) -> int: ...
    def selectionLength(self) -> int: ...
    def selectionStart(self) -> int: ...
    def setAlignment(self, flag: PySide2.QtCore.Qt.Alignment) -> None: ...
    def setClearButtonEnabled(self, enable: bool) -> None: ...
    def setCompleter(self, completer: PySide2.QtWidgets.QCompleter) -> None: ...
    def setCursorMoveStyle(self, style: PySide2.QtCore.Qt.CursorMoveStyle) -> None: ...
    def setCursorPosition(self, arg__1: int) -> None: ...
    def setDragEnabled(self, b: bool) -> None: ...
    def setEchoMode(self, arg__1: PySide2.QtWidgets.QLineEdit.EchoMode) -> None: ...
    def setFrame(self, arg__1: bool) -> None: ...
    def setInputMask(self, inputMask: str) -> None: ...
    def setMaxLength(self, arg__1: int) -> None: ...
    def setModified(self, arg__1: bool) -> None: ...
    def setPlaceholderText(self, arg__1: str) -> None: ...
    def setReadOnly(self, arg__1: bool) -> None: ...
    def setSelection(self, arg__1: int, arg__2: int) -> None: ...
    def setText(self, arg__1: str) -> None: ...
    @typing.overload
    def setTextMargins(self, left: int, top: int, right: int, bottom: int) -> None: ...
    @typing.overload
    def setTextMargins(self, margins: PySide2.QtCore.QMargins) -> None: ...
    def setValidator(self, arg__1: PySide2.QtGui.QValidator) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def text(self) -> str: ...
    def textMargins(self) -> PySide2.QtCore.QMargins: ...
    def undo(self) -> None: ...
    def validator(self) -> PySide2.QtGui.QValidator: ...


class QListView(PySide2.QtWidgets.QAbstractItemView):
    LeftToRight              : QListView.Flow = ... # 0x0
    TopToBottom              : QListView.Flow = ... # 0x1
    SinglePass               : QListView.LayoutMode = ... # 0x0
    Batched                  : QListView.LayoutMode = ... # 0x1
    Static                   : QListView.Movement = ... # 0x0
    Free                     : QListView.Movement = ... # 0x1
    Snap                     : QListView.Movement = ... # 0x2
    Fixed                    : QListView.ResizeMode = ... # 0x0
    Adjust                   : QListView.ResizeMode = ... # 0x1
    ListMode                 : QListView.ViewMode = ... # 0x0
    IconMode                 : QListView.ViewMode = ... # 0x1

    class Flow(Shiboken.Enum):
        LeftToRight              : QListView.Flow = ... # 0x0
        TopToBottom              : QListView.Flow = ... # 0x1

    class LayoutMode(Shiboken.Enum):
        SinglePass               : QListView.LayoutMode = ... # 0x0
        Batched                  : QListView.LayoutMode = ... # 0x1

    class Movement(Shiboken.Enum):
        Static                   : QListView.Movement = ... # 0x0
        Free                     : QListView.Movement = ... # 0x1
        Snap                     : QListView.Movement = ... # 0x2

    class ResizeMode(Shiboken.Enum):
        Fixed                    : QListView.ResizeMode = ... # 0x0
        Adjust                   : QListView.ResizeMode = ... # 0x1

    class ViewMode(Shiboken.Enum):
        ListMode                 : QListView.ViewMode = ... # 0x0
        IconMode                 : QListView.ViewMode = ... # 0x1

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def batchSize(self) -> int: ...
    def clearPropertyFlags(self) -> None: ...
    def contentsSize(self) -> PySide2.QtCore.QSize: ...
    def currentChanged(self, current: PySide2.QtCore.QModelIndex, previous: PySide2.QtCore.QModelIndex) -> None: ...
    def dataChanged(self, topLeft: PySide2.QtCore.QModelIndex, bottomRight: PySide2.QtCore.QModelIndex, roles: typing.List[int] = ...) -> None: ...
    def doItemsLayout(self) -> None: ...
    def dragLeaveEvent(self, e: PySide2.QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, e: PySide2.QtGui.QDragMoveEvent) -> None: ...
    def dropEvent(self, e: PySide2.QtGui.QDropEvent) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def flow(self) -> PySide2.QtWidgets.QListView.Flow: ...
    def gridSize(self) -> PySide2.QtCore.QSize: ...
    def horizontalOffset(self) -> int: ...
    def indexAt(self, p: PySide2.QtCore.QPoint) -> PySide2.QtCore.QModelIndex: ...
    def isIndexHidden(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def isRowHidden(self, row: int) -> bool: ...
    def isSelectionRectVisible(self) -> bool: ...
    def isWrapping(self) -> bool: ...
    def itemAlignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def layoutMode(self) -> PySide2.QtWidgets.QListView.LayoutMode: ...
    def modelColumn(self) -> int: ...
    def mouseMoveEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def moveCursor(self, cursorAction: PySide2.QtWidgets.QAbstractItemView.CursorAction, modifiers: PySide2.QtCore.Qt.KeyboardModifiers) -> PySide2.QtCore.QModelIndex: ...
    def movement(self) -> PySide2.QtWidgets.QListView.Movement: ...
    def paintEvent(self, e: PySide2.QtGui.QPaintEvent) -> None: ...
    def rectForIndex(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QRect: ...
    def reset(self) -> None: ...
    def resizeContents(self, width: int, height: int) -> None: ...
    def resizeEvent(self, e: PySide2.QtGui.QResizeEvent) -> None: ...
    def resizeMode(self) -> PySide2.QtWidgets.QListView.ResizeMode: ...
    def rowsAboutToBeRemoved(self, parent: PySide2.QtCore.QModelIndex, start: int, end: int) -> None: ...
    def rowsInserted(self, parent: PySide2.QtCore.QModelIndex, start: int, end: int) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def scrollTo(self, index: PySide2.QtCore.QModelIndex, hint: PySide2.QtWidgets.QAbstractItemView.ScrollHint = ...) -> None: ...
    def selectedIndexes(self) -> typing.List[int]: ...
    def selectionChanged(self, selected: PySide2.QtCore.QItemSelection, deselected: PySide2.QtCore.QItemSelection) -> None: ...
    def setBatchSize(self, batchSize: int) -> None: ...
    def setFlow(self, flow: PySide2.QtWidgets.QListView.Flow) -> None: ...
    def setGridSize(self, size: PySide2.QtCore.QSize) -> None: ...
    def setItemAlignment(self, alignment: PySide2.QtCore.Qt.Alignment) -> None: ...
    def setLayoutMode(self, mode: PySide2.QtWidgets.QListView.LayoutMode) -> None: ...
    def setModelColumn(self, column: int) -> None: ...
    def setMovement(self, movement: PySide2.QtWidgets.QListView.Movement) -> None: ...
    def setPositionForIndex(self, position: PySide2.QtCore.QPoint, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setResizeMode(self, mode: PySide2.QtWidgets.QListView.ResizeMode) -> None: ...
    def setRootIndex(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setRowHidden(self, row: int, hide: bool) -> None: ...
    def setSelection(self, rect: PySide2.QtCore.QRect, command: PySide2.QtCore.QItemSelectionModel.SelectionFlags) -> None: ...
    def setSelectionRectVisible(self, show: bool) -> None: ...
    def setSpacing(self, space: int) -> None: ...
    def setUniformItemSizes(self, enable: bool) -> None: ...
    def setViewMode(self, mode: PySide2.QtWidgets.QListView.ViewMode) -> None: ...
    def setWordWrap(self, on: bool) -> None: ...
    def setWrapping(self, enable: bool) -> None: ...
    def spacing(self) -> int: ...
    def startDrag(self, supportedActions: PySide2.QtCore.Qt.DropActions) -> None: ...
    def timerEvent(self, e: PySide2.QtCore.QTimerEvent) -> None: ...
    def uniformItemSizes(self) -> bool: ...
    def updateGeometries(self) -> None: ...
    def verticalOffset(self) -> int: ...
    def viewMode(self) -> PySide2.QtWidgets.QListView.ViewMode: ...
    def viewOptions(self) -> PySide2.QtWidgets.QStyleOptionViewItem: ...
    def viewportSizeHint(self) -> PySide2.QtCore.QSize: ...
    def visualRect(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide2.QtCore.QItemSelection) -> PySide2.QtGui.QRegion: ...
    def wheelEvent(self, e: PySide2.QtGui.QWheelEvent) -> None: ...
    def wordWrap(self) -> bool: ...


class QListWidget(PySide2.QtWidgets.QListView):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    @typing.overload
    def addItem(self, item: PySide2.QtWidgets.QListWidgetItem) -> None: ...
    @typing.overload
    def addItem(self, label: str) -> None: ...
    def addItems(self, labels: typing.Sequence[str]) -> None: ...
    def clear(self) -> None: ...
    @typing.overload
    def closePersistentEditor(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    @typing.overload
    def closePersistentEditor(self, item: PySide2.QtWidgets.QListWidgetItem) -> None: ...
    def count(self) -> int: ...
    def currentItem(self) -> PySide2.QtWidgets.QListWidgetItem: ...
    def currentRow(self) -> int: ...
    def dropEvent(self, event: PySide2.QtGui.QDropEvent) -> None: ...
    def dropMimeData(self, index: int, data: PySide2.QtCore.QMimeData, action: PySide2.QtCore.Qt.DropAction) -> bool: ...
    def editItem(self, item: PySide2.QtWidgets.QListWidgetItem) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def findItems(self, text: str, flags: PySide2.QtCore.Qt.MatchFlags) -> typing.List[PySide2.QtWidgets.QListWidgetItem]: ...
    def indexFromItem(self, item: PySide2.QtWidgets.QListWidgetItem) -> PySide2.QtCore.QModelIndex: ...
    @typing.overload
    def insertItem(self, row: int, item: PySide2.QtWidgets.QListWidgetItem) -> None: ...
    @typing.overload
    def insertItem(self, row: int, label: str) -> None: ...
    def insertItems(self, row: int, labels: typing.Sequence[str]) -> None: ...
    def isItemHidden(self, item: PySide2.QtWidgets.QListWidgetItem) -> bool: ...
    def isItemSelected(self, item: PySide2.QtWidgets.QListWidgetItem) -> bool: ...
    @typing.overload
    def isPersistentEditorOpen(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    @typing.overload
    def isPersistentEditorOpen(self, item: PySide2.QtWidgets.QListWidgetItem) -> bool: ...
    def isSortingEnabled(self) -> bool: ...
    def item(self, row: int) -> PySide2.QtWidgets.QListWidgetItem: ...
    @typing.overload
    def itemAt(self, p: PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QListWidgetItem: ...
    @typing.overload
    def itemAt(self, x: int, y: int) -> PySide2.QtWidgets.QListWidgetItem: ...
    def itemFromIndex(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QListWidgetItem: ...
    def itemWidget(self, item: PySide2.QtWidgets.QListWidgetItem) -> PySide2.QtWidgets.QWidget: ...
    def items(self, data: PySide2.QtCore.QMimeData) -> typing.List[PySide2.QtWidgets.QListWidgetItem]: ...
    def mimeData(self, items: typing.Sequence[PySide2.QtWidgets.QListWidgetItem]) -> PySide2.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    @typing.overload
    def openPersistentEditor(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    @typing.overload
    def openPersistentEditor(self, item: PySide2.QtWidgets.QListWidgetItem) -> None: ...
    def removeItemWidget(self, item: PySide2.QtWidgets.QListWidgetItem) -> None: ...
    def row(self, item: PySide2.QtWidgets.QListWidgetItem) -> int: ...
    def scrollToItem(self, item: PySide2.QtWidgets.QListWidgetItem, hint: PySide2.QtWidgets.QAbstractItemView.ScrollHint = ...) -> None: ...
    def selectedItems(self) -> typing.List[PySide2.QtWidgets.QListWidgetItem]: ...
    @typing.overload
    def setCurrentItem(self, item: PySide2.QtWidgets.QListWidgetItem) -> None: ...
    @typing.overload
    def setCurrentItem(self, item: PySide2.QtWidgets.QListWidgetItem, command: PySide2.QtCore.QItemSelectionModel.SelectionFlags) -> None: ...
    @typing.overload
    def setCurrentRow(self, row: int) -> None: ...
    @typing.overload
    def setCurrentRow(self, row: int, command: PySide2.QtCore.QItemSelectionModel.SelectionFlags) -> None: ...
    def setItemHidden(self, item: PySide2.QtWidgets.QListWidgetItem, hide: bool) -> None: ...
    def setItemSelected(self, item: PySide2.QtWidgets.QListWidgetItem, select: bool) -> None: ...
    def setItemWidget(self, item: PySide2.QtWidgets.QListWidgetItem, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def setModel(self, model: PySide2.QtCore.QAbstractItemModel) -> None: ...
    def setSelectionModel(self, selectionModel: PySide2.QtCore.QItemSelectionModel) -> None: ...
    def setSortingEnabled(self, enable: bool) -> None: ...
    def sortItems(self, order: PySide2.QtCore.Qt.SortOrder = ...) -> None: ...
    def supportedDropActions(self) -> PySide2.QtCore.Qt.DropActions: ...
    def takeItem(self, row: int) -> PySide2.QtWidgets.QListWidgetItem: ...
    def visualItemRect(self, item: PySide2.QtWidgets.QListWidgetItem) -> PySide2.QtCore.QRect: ...


class QListWidgetItem(Shiboken.Object):
    Type                     : QListWidgetItem.ItemType = ... # 0x0
    UserType                 : QListWidgetItem.ItemType = ... # 0x3e8

    class ItemType(Shiboken.Enum):
        Type                     : QListWidgetItem.ItemType = ... # 0x0
        UserType                 : QListWidgetItem.ItemType = ... # 0x3e8

    @typing.overload
    def __init__(self, icon: PySide2.QtGui.QIcon, text: str, listview: typing.Optional[PySide2.QtWidgets.QListWidget] = ..., type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, listview: typing.Optional[PySide2.QtWidgets.QListWidget] = ..., type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QListWidgetItem) -> None: ...
    @typing.overload
    def __init__(self, text: str, listview: typing.Optional[PySide2.QtWidgets.QListWidget] = ..., type: int = ...) -> None: ...

    def __lshift__(self, out: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, in_: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def background(self) -> PySide2.QtGui.QBrush: ...
    def backgroundColor(self) -> PySide2.QtGui.QColor: ...
    def checkState(self) -> PySide2.QtCore.Qt.CheckState: ...
    def clone(self) -> PySide2.QtWidgets.QListWidgetItem: ...
    def data(self, role: int) -> typing.Any: ...
    def flags(self) -> PySide2.QtCore.Qt.ItemFlags: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def foreground(self) -> PySide2.QtGui.QBrush: ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    def isHidden(self) -> bool: ...
    def isSelected(self) -> bool: ...
    def listWidget(self) -> PySide2.QtWidgets.QListWidget: ...
    def read(self, in_: PySide2.QtCore.QDataStream) -> None: ...
    def setBackground(self, brush: PySide2.QtGui.QBrush) -> None: ...
    def setBackgroundColor(self, color: PySide2.QtGui.QColor) -> None: ...
    def setCheckState(self, state: PySide2.QtCore.Qt.CheckState) -> None: ...
    def setData(self, role: int, value: typing.Any) -> None: ...
    def setFlags(self, flags: PySide2.QtCore.Qt.ItemFlags) -> None: ...
    def setFont(self, font: PySide2.QtGui.QFont) -> None: ...
    def setForeground(self, brush: PySide2.QtGui.QBrush) -> None: ...
    def setHidden(self, hide: bool) -> None: ...
    def setIcon(self, icon: PySide2.QtGui.QIcon) -> None: ...
    def setSelected(self, select: bool) -> None: ...
    def setSizeHint(self, size: PySide2.QtCore.QSize) -> None: ...
    def setStatusTip(self, statusTip: str) -> None: ...
    def setText(self, text: str) -> None: ...
    def setTextAlignment(self, alignment: int) -> None: ...
    def setTextColor(self, color: PySide2.QtGui.QColor) -> None: ...
    def setToolTip(self, toolTip: str) -> None: ...
    def setWhatsThis(self, whatsThis: str) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def statusTip(self) -> str: ...
    def text(self) -> str: ...
    def textAlignment(self) -> int: ...
    def textColor(self) -> PySide2.QtGui.QColor: ...
    def toolTip(self) -> str: ...
    def type(self) -> int: ...
    def whatsThis(self) -> str: ...
    def write(self, out: PySide2.QtCore.QDataStream) -> None: ...


class QMainWindow(PySide2.QtWidgets.QWidget):
    AnimatedDocks            : QMainWindow.DockOption = ... # 0x1
    AllowNestedDocks         : QMainWindow.DockOption = ... # 0x2
    AllowTabbedDocks         : QMainWindow.DockOption = ... # 0x4
    ForceTabbedDocks         : QMainWindow.DockOption = ... # 0x8
    VerticalTabs             : QMainWindow.DockOption = ... # 0x10
    GroupedDragging          : QMainWindow.DockOption = ... # 0x20

    class DockOption(Shiboken.Enum):
        AnimatedDocks            : QMainWindow.DockOption = ... # 0x1
        AllowNestedDocks         : QMainWindow.DockOption = ... # 0x2
        AllowTabbedDocks         : QMainWindow.DockOption = ... # 0x4
        ForceTabbedDocks         : QMainWindow.DockOption = ... # 0x8
        VerticalTabs             : QMainWindow.DockOption = ... # 0x10
        GroupedDragging          : QMainWindow.DockOption = ... # 0x20

    class DockOptions(object): ...

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...

    @typing.overload
    def addDockWidget(self, area: PySide2.QtCore.Qt.DockWidgetArea, dockwidget: PySide2.QtWidgets.QDockWidget) -> None: ...
    @typing.overload
    def addDockWidget(self, area: PySide2.QtCore.Qt.DockWidgetArea, dockwidget: PySide2.QtWidgets.QDockWidget, orientation: PySide2.QtCore.Qt.Orientation) -> None: ...
    @typing.overload
    def addToolBar(self, area: PySide2.QtCore.Qt.ToolBarArea, toolbar: PySide2.QtWidgets.QToolBar) -> None: ...
    @typing.overload
    def addToolBar(self, title: str) -> PySide2.QtWidgets.QToolBar: ...
    @typing.overload
    def addToolBar(self, toolbar: PySide2.QtWidgets.QToolBar) -> None: ...
    def addToolBarBreak(self, area: PySide2.QtCore.Qt.ToolBarArea = ...) -> None: ...
    def centralWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def contextMenuEvent(self, event: PySide2.QtGui.QContextMenuEvent) -> None: ...
    def corner(self, corner: PySide2.QtCore.Qt.Corner) -> PySide2.QtCore.Qt.DockWidgetArea: ...
    def createPopupMenu(self) -> PySide2.QtWidgets.QMenu: ...
    def dockOptions(self) -> PySide2.QtWidgets.QMainWindow.DockOptions: ...
    def dockWidgetArea(self, dockwidget: PySide2.QtWidgets.QDockWidget) -> PySide2.QtCore.Qt.DockWidgetArea: ...
    def documentMode(self) -> bool: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def iconSize(self) -> PySide2.QtCore.QSize: ...
    def insertToolBar(self, before: PySide2.QtWidgets.QToolBar, toolbar: PySide2.QtWidgets.QToolBar) -> None: ...
    def insertToolBarBreak(self, before: PySide2.QtWidgets.QToolBar) -> None: ...
    def isAnimated(self) -> bool: ...
    def isDockNestingEnabled(self) -> bool: ...
    def isSeparator(self, pos: PySide2.QtCore.QPoint) -> bool: ...
    def menuBar(self) -> PySide2.QtWidgets.QMenuBar: ...
    def menuWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def removeDockWidget(self, dockwidget: PySide2.QtWidgets.QDockWidget) -> None: ...
    def removeToolBar(self, toolbar: PySide2.QtWidgets.QToolBar) -> None: ...
    def removeToolBarBreak(self, before: PySide2.QtWidgets.QToolBar) -> None: ...
    def resizeDocks(self, docks: typing.Sequence[PySide2.QtWidgets.QDockWidget], sizes: typing.Sequence[int], orientation: PySide2.QtCore.Qt.Orientation) -> None: ...
    def restoreDockWidget(self, dockwidget: PySide2.QtWidgets.QDockWidget) -> bool: ...
    def restoreState(self, state: PySide2.QtCore.QByteArray, version: int = ...) -> bool: ...
    def saveState(self, version: int = ...) -> PySide2.QtCore.QByteArray: ...
    def setAnimated(self, enabled: bool) -> None: ...
    def setCentralWidget(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def setCorner(self, corner: PySide2.QtCore.Qt.Corner, area: PySide2.QtCore.Qt.DockWidgetArea) -> None: ...
    def setDockNestingEnabled(self, enabled: bool) -> None: ...
    def setDockOptions(self, options: PySide2.QtWidgets.QMainWindow.DockOptions) -> None: ...
    def setDocumentMode(self, enabled: bool) -> None: ...
    def setIconSize(self, iconSize: PySide2.QtCore.QSize) -> None: ...
    def setMenuBar(self, menubar: PySide2.QtWidgets.QMenuBar) -> None: ...
    def setMenuWidget(self, menubar: PySide2.QtWidgets.QWidget) -> None: ...
    def setStatusBar(self, statusbar: PySide2.QtWidgets.QStatusBar) -> None: ...
    def setTabPosition(self, areas: PySide2.QtCore.Qt.DockWidgetAreas, tabPosition: PySide2.QtWidgets.QTabWidget.TabPosition) -> None: ...
    def setTabShape(self, tabShape: PySide2.QtWidgets.QTabWidget.TabShape) -> None: ...
    def setToolButtonStyle(self, toolButtonStyle: PySide2.QtCore.Qt.ToolButtonStyle) -> None: ...
    def setUnifiedTitleAndToolBarOnMac(self, set: bool) -> None: ...
    def splitDockWidget(self, after: PySide2.QtWidgets.QDockWidget, dockwidget: PySide2.QtWidgets.QDockWidget, orientation: PySide2.QtCore.Qt.Orientation) -> None: ...
    def statusBar(self) -> PySide2.QtWidgets.QStatusBar: ...
    def tabPosition(self, area: PySide2.QtCore.Qt.DockWidgetArea) -> PySide2.QtWidgets.QTabWidget.TabPosition: ...
    def tabShape(self) -> PySide2.QtWidgets.QTabWidget.TabShape: ...
    def tabifiedDockWidgets(self, dockwidget: PySide2.QtWidgets.QDockWidget) -> typing.List[PySide2.QtWidgets.QDockWidget]: ...
    def tabifyDockWidget(self, first: PySide2.QtWidgets.QDockWidget, second: PySide2.QtWidgets.QDockWidget) -> None: ...
    def takeCentralWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def toolBarArea(self, toolbar: PySide2.QtWidgets.QToolBar) -> PySide2.QtCore.Qt.ToolBarArea: ...
    def toolBarBreak(self, toolbar: PySide2.QtWidgets.QToolBar) -> bool: ...
    def toolButtonStyle(self) -> PySide2.QtCore.Qt.ToolButtonStyle: ...
    def unifiedTitleAndToolBarOnMac(self) -> bool: ...


class QMdiArea(PySide2.QtWidgets.QAbstractScrollArea):
    DontMaximizeSubWindowOnActivation: QMdiArea.AreaOption = ... # 0x1
    SubWindowView            : QMdiArea.ViewMode = ... # 0x0
    TabbedView               : QMdiArea.ViewMode = ... # 0x1
    CreationOrder            : QMdiArea.WindowOrder = ... # 0x0
    StackingOrder            : QMdiArea.WindowOrder = ... # 0x1
    ActivationHistoryOrder   : QMdiArea.WindowOrder = ... # 0x2

    class AreaOption(Shiboken.Enum):
        DontMaximizeSubWindowOnActivation: QMdiArea.AreaOption = ... # 0x1

    class AreaOptions(object): ...

    class ViewMode(Shiboken.Enum):
        SubWindowView            : QMdiArea.ViewMode = ... # 0x0
        TabbedView               : QMdiArea.ViewMode = ... # 0x1

    class WindowOrder(Shiboken.Enum):
        CreationOrder            : QMdiArea.WindowOrder = ... # 0x0
        StackingOrder            : QMdiArea.WindowOrder = ... # 0x1
        ActivationHistoryOrder   : QMdiArea.WindowOrder = ... # 0x2

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def activateNextSubWindow(self) -> None: ...
    def activatePreviousSubWindow(self) -> None: ...
    def activationOrder(self) -> PySide2.QtWidgets.QMdiArea.WindowOrder: ...
    def activeSubWindow(self) -> PySide2.QtWidgets.QMdiSubWindow: ...
    def addSubWindow(self, widget: PySide2.QtWidgets.QWidget, flags: PySide2.QtCore.Qt.WindowFlags = ...) -> PySide2.QtWidgets.QMdiSubWindow: ...
    def background(self) -> PySide2.QtGui.QBrush: ...
    def cascadeSubWindows(self) -> None: ...
    def childEvent(self, childEvent: PySide2.QtCore.QChildEvent) -> None: ...
    def closeActiveSubWindow(self) -> None: ...
    def closeAllSubWindows(self) -> None: ...
    def currentSubWindow(self) -> PySide2.QtWidgets.QMdiSubWindow: ...
    def documentMode(self) -> bool: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, object: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def paintEvent(self, paintEvent: PySide2.QtGui.QPaintEvent) -> None: ...
    def removeSubWindow(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def resizeEvent(self, resizeEvent: PySide2.QtGui.QResizeEvent) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def setActivationOrder(self, order: PySide2.QtWidgets.QMdiArea.WindowOrder) -> None: ...
    def setActiveSubWindow(self, window: PySide2.QtWidgets.QMdiSubWindow) -> None: ...
    def setBackground(self, background: PySide2.QtGui.QBrush) -> None: ...
    def setDocumentMode(self, enabled: bool) -> None: ...
    def setOption(self, option: PySide2.QtWidgets.QMdiArea.AreaOption, on: bool = ...) -> None: ...
    def setTabPosition(self, position: PySide2.QtWidgets.QTabWidget.TabPosition) -> None: ...
    def setTabShape(self, shape: PySide2.QtWidgets.QTabWidget.TabShape) -> None: ...
    def setTabsClosable(self, closable: bool) -> None: ...
    def setTabsMovable(self, movable: bool) -> None: ...
    def setViewMode(self, mode: PySide2.QtWidgets.QMdiArea.ViewMode) -> None: ...
    def setupViewport(self, viewport: PySide2.QtWidgets.QWidget) -> None: ...
    def showEvent(self, showEvent: PySide2.QtGui.QShowEvent) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def subWindowList(self, order: PySide2.QtWidgets.QMdiArea.WindowOrder = ...) -> typing.List[PySide2.QtWidgets.QMdiSubWindow]: ...
    def tabPosition(self) -> PySide2.QtWidgets.QTabWidget.TabPosition: ...
    def tabShape(self) -> PySide2.QtWidgets.QTabWidget.TabShape: ...
    def tabsClosable(self) -> bool: ...
    def tabsMovable(self) -> bool: ...
    def testOption(self, opton: PySide2.QtWidgets.QMdiArea.AreaOption) -> bool: ...
    def tileSubWindows(self) -> None: ...
    def timerEvent(self, timerEvent: PySide2.QtCore.QTimerEvent) -> None: ...
    def viewMode(self) -> PySide2.QtWidgets.QMdiArea.ViewMode: ...
    def viewportEvent(self, event: PySide2.QtCore.QEvent) -> bool: ...


class QMdiSubWindow(PySide2.QtWidgets.QWidget):
    AllowOutsideAreaHorizontally: QMdiSubWindow.SubWindowOption = ... # 0x1
    AllowOutsideAreaVertically: QMdiSubWindow.SubWindowOption = ... # 0x2
    RubberBandResize         : QMdiSubWindow.SubWindowOption = ... # 0x4
    RubberBandMove           : QMdiSubWindow.SubWindowOption = ... # 0x8

    class SubWindowOption(Shiboken.Enum):
        AllowOutsideAreaHorizontally: QMdiSubWindow.SubWindowOption = ... # 0x1
        AllowOutsideAreaVertically: QMdiSubWindow.SubWindowOption = ... # 0x2
        RubberBandResize         : QMdiSubWindow.SubWindowOption = ... # 0x4
        RubberBandMove           : QMdiSubWindow.SubWindowOption = ... # 0x8

    class SubWindowOptions(object): ...

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...

    def changeEvent(self, changeEvent: PySide2.QtCore.QEvent) -> None: ...
    def childEvent(self, childEvent: PySide2.QtCore.QChildEvent) -> None: ...
    def closeEvent(self, closeEvent: PySide2.QtGui.QCloseEvent) -> None: ...
    def contextMenuEvent(self, contextMenuEvent: PySide2.QtGui.QContextMenuEvent) -> None: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, object: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, focusInEvent: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, focusOutEvent: PySide2.QtGui.QFocusEvent) -> None: ...
    def hideEvent(self, hideEvent: PySide2.QtGui.QHideEvent) -> None: ...
    def isShaded(self) -> bool: ...
    def keyPressEvent(self, keyEvent: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyboardPageStep(self) -> int: ...
    def keyboardSingleStep(self) -> int: ...
    def leaveEvent(self, leaveEvent: PySide2.QtCore.QEvent) -> None: ...
    def maximizedButtonsWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def maximizedSystemMenuIconWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def mdiArea(self) -> PySide2.QtWidgets.QMdiArea: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseDoubleClickEvent(self, mouseEvent: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, mouseEvent: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, mouseEvent: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, mouseEvent: PySide2.QtGui.QMouseEvent) -> None: ...
    def moveEvent(self, moveEvent: PySide2.QtGui.QMoveEvent) -> None: ...
    def paintEvent(self, paintEvent: PySide2.QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, resizeEvent: PySide2.QtGui.QResizeEvent) -> None: ...
    def setKeyboardPageStep(self, step: int) -> None: ...
    def setKeyboardSingleStep(self, step: int) -> None: ...
    def setOption(self, option: PySide2.QtWidgets.QMdiSubWindow.SubWindowOption, on: bool = ...) -> None: ...
    def setSystemMenu(self, systemMenu: PySide2.QtWidgets.QMenu) -> None: ...
    def setWidget(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def showEvent(self, showEvent: PySide2.QtGui.QShowEvent) -> None: ...
    def showShaded(self) -> None: ...
    def showSystemMenu(self) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def systemMenu(self) -> PySide2.QtWidgets.QMenu: ...
    def testOption(self, arg__1: PySide2.QtWidgets.QMdiSubWindow.SubWindowOption) -> bool: ...
    def timerEvent(self, timerEvent: PySide2.QtCore.QTimerEvent) -> None: ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...


class QMenu(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, title: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def actionAt(self, arg__1: PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QAction: ...
    def actionEvent(self, arg__1: PySide2.QtGui.QActionEvent) -> None: ...
    def actionGeometry(self, arg__1: PySide2.QtWidgets.QAction) -> PySide2.QtCore.QRect: ...
    def activeAction(self) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, arg__1: PySide2.QtGui.QIcon, arg__2: str, arg__3: object, arg__4: typing.Optional[PySide2.QtGui.QKeySequence] = ...) -> None: ...
    @typing.overload
    def addAction(self, arg__1: PySide2.QtWidgets.QAction) -> None: ...
    @typing.overload
    def addAction(self, arg__1: str, arg__2: object, arg__3: typing.Optional[PySide2.QtGui.QKeySequence] = ...) -> None: ...
    @typing.overload
    def addAction(self, icon: PySide2.QtGui.QIcon, text: str) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, icon: PySide2.QtGui.QIcon, text: str, receiver: PySide2.QtCore.QObject, member: bytes, shortcut: typing.Optional[PySide2.QtGui.QKeySequence] = ...) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, text: str) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, text: str, receiver: PySide2.QtCore.QObject, member: bytes, shortcut: typing.Optional[PySide2.QtGui.QKeySequence] = ...) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addMenu(self, icon: PySide2.QtGui.QIcon, title: str) -> PySide2.QtWidgets.QMenu: ...
    @typing.overload
    def addMenu(self, menu: PySide2.QtWidgets.QMenu) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addMenu(self, title: str) -> PySide2.QtWidgets.QMenu: ...
    @typing.overload
    def addSection(self, icon: PySide2.QtGui.QIcon, text: str) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addSection(self, text: str) -> PySide2.QtWidgets.QAction: ...
    def addSeparator(self) -> PySide2.QtWidgets.QAction: ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def columnCount(self) -> int: ...
    def defaultAction(self) -> PySide2.QtWidgets.QAction: ...
    def enterEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    @typing.overload
    @staticmethod
    def exec_(actions: typing.Sequence[PySide2.QtWidgets.QAction], pos: PySide2.QtCore.QPoint, at: typing.Optional[PySide2.QtWidgets.QAction] = ..., parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def exec_(self) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def exec_(self, pos: PySide2.QtCore.QPoint, at: typing.Optional[PySide2.QtWidgets.QAction] = ...) -> PySide2.QtWidgets.QAction: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def hideEvent(self, arg__1: PySide2.QtGui.QHideEvent) -> None: ...
    def hideTearOffMenu(self) -> None: ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionMenuItem, action: PySide2.QtWidgets.QAction) -> None: ...
    def insertMenu(self, before: PySide2.QtWidgets.QAction, menu: PySide2.QtWidgets.QMenu) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def insertSection(self, before: PySide2.QtWidgets.QAction, icon: PySide2.QtGui.QIcon, text: str) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def insertSection(self, before: PySide2.QtWidgets.QAction, text: str) -> PySide2.QtWidgets.QAction: ...
    def insertSeparator(self, before: PySide2.QtWidgets.QAction) -> PySide2.QtWidgets.QAction: ...
    def isEmpty(self) -> bool: ...
    def isTearOffEnabled(self) -> bool: ...
    def isTearOffMenuVisible(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent) -> None: ...
    def leaveEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...
    def menuAction(self) -> PySide2.QtWidgets.QAction: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def popup(self, pos: PySide2.QtCore.QPoint, at: typing.Optional[PySide2.QtWidgets.QAction] = ...) -> None: ...
    def separatorsCollapsible(self) -> bool: ...
    def setActiveAction(self, act: PySide2.QtWidgets.QAction) -> None: ...
    def setAsDockMenu(self) -> None: ...
    def setDefaultAction(self, arg__1: PySide2.QtWidgets.QAction) -> None: ...
    def setIcon(self, icon: PySide2.QtGui.QIcon) -> None: ...
    def setSeparatorsCollapsible(self, collapse: bool) -> None: ...
    def setTearOffEnabled(self, arg__1: bool) -> None: ...
    def setTitle(self, title: str) -> None: ...
    def setToolTipsVisible(self, visible: bool) -> None: ...
    @typing.overload
    def showTearOffMenu(self) -> None: ...
    @typing.overload
    def showTearOffMenu(self, pos: PySide2.QtCore.QPoint) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def timerEvent(self, arg__1: PySide2.QtCore.QTimerEvent) -> None: ...
    def title(self) -> str: ...
    def toolTipsVisible(self) -> bool: ...
    def wheelEvent(self, arg__1: PySide2.QtGui.QWheelEvent) -> None: ...


class QMenuBar(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def actionAt(self, arg__1: PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QAction: ...
    def actionEvent(self, arg__1: PySide2.QtGui.QActionEvent) -> None: ...
    def actionGeometry(self, arg__1: PySide2.QtWidgets.QAction) -> PySide2.QtCore.QRect: ...
    def activeAction(self) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, arg__1: PySide2.QtWidgets.QAction) -> None: ...
    @typing.overload
    def addAction(self, arg__1: str, arg__2: object) -> None: ...
    @typing.overload
    def addAction(self, text: str) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, text: str, receiver: PySide2.QtCore.QObject, member: bytes) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addMenu(self, icon: PySide2.QtGui.QIcon, title: str) -> PySide2.QtWidgets.QMenu: ...
    @typing.overload
    def addMenu(self, menu: PySide2.QtWidgets.QMenu) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addMenu(self, title: str) -> PySide2.QtWidgets.QMenu: ...
    def addSeparator(self) -> PySide2.QtWidgets.QAction: ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def cornerWidget(self, corner: PySide2.QtCore.Qt.Corner = ...) -> PySide2.QtWidgets.QWidget: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1: PySide2.QtCore.QObject, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, arg__1: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, arg__1: PySide2.QtGui.QFocusEvent) -> None: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionMenuItem, action: PySide2.QtWidgets.QAction) -> None: ...
    def insertMenu(self, before: PySide2.QtWidgets.QAction, menu: PySide2.QtWidgets.QMenu) -> PySide2.QtWidgets.QAction: ...
    def insertSeparator(self, before: PySide2.QtWidgets.QAction) -> PySide2.QtWidgets.QAction: ...
    def isDefaultUp(self) -> bool: ...
    def isNativeMenuBar(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent) -> None: ...
    def leaveEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent) -> None: ...
    def setActiveAction(self, action: PySide2.QtWidgets.QAction) -> None: ...
    def setCornerWidget(self, w: PySide2.QtWidgets.QWidget, corner: PySide2.QtCore.Qt.Corner = ...) -> None: ...
    def setDefaultUp(self, arg__1: bool) -> None: ...
    def setNativeMenuBar(self, nativeMenuBar: bool) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def timerEvent(self, arg__1: PySide2.QtCore.QTimerEvent) -> None: ...


class QMessageBox(PySide2.QtWidgets.QDialog):
    InvalidRole              : QMessageBox.ButtonRole = ... # -0x1
    AcceptRole               : QMessageBox.ButtonRole = ... # 0x0
    RejectRole               : QMessageBox.ButtonRole = ... # 0x1
    DestructiveRole          : QMessageBox.ButtonRole = ... # 0x2
    ActionRole               : QMessageBox.ButtonRole = ... # 0x3
    HelpRole                 : QMessageBox.ButtonRole = ... # 0x4
    YesRole                  : QMessageBox.ButtonRole = ... # 0x5
    NoRole                   : QMessageBox.ButtonRole = ... # 0x6
    ResetRole                : QMessageBox.ButtonRole = ... # 0x7
    ApplyRole                : QMessageBox.ButtonRole = ... # 0x8
    NRoles                   : QMessageBox.ButtonRole = ... # 0x9
    NoIcon                   : QMessageBox.Icon = ... # 0x0
    Information              : QMessageBox.Icon = ... # 0x1
    Warning                  : QMessageBox.Icon = ... # 0x2
    Critical                 : QMessageBox.Icon = ... # 0x3
    Question                 : QMessageBox.Icon = ... # 0x4
    ButtonMask               : QMessageBox.StandardButton = ... # -0x301
    NoButton                 : QMessageBox.StandardButton = ... # 0x0
    Default                  : QMessageBox.StandardButton = ... # 0x100
    Escape                   : QMessageBox.StandardButton = ... # 0x200
    FlagMask                 : QMessageBox.StandardButton = ... # 0x300
    FirstButton              : QMessageBox.StandardButton = ... # 0x400
    Ok                       : QMessageBox.StandardButton = ... # 0x400
    Save                     : QMessageBox.StandardButton = ... # 0x800
    SaveAll                  : QMessageBox.StandardButton = ... # 0x1000
    Open                     : QMessageBox.StandardButton = ... # 0x2000
    Yes                      : QMessageBox.StandardButton = ... # 0x4000
    YesAll                   : QMessageBox.StandardButton = ... # 0x8000
    YesToAll                 : QMessageBox.StandardButton = ... # 0x8000
    No                       : QMessageBox.StandardButton = ... # 0x10000
    NoAll                    : QMessageBox.StandardButton = ... # 0x20000
    NoToAll                  : QMessageBox.StandardButton = ... # 0x20000
    Abort                    : QMessageBox.StandardButton = ... # 0x40000
    Retry                    : QMessageBox.StandardButton = ... # 0x80000
    Ignore                   : QMessageBox.StandardButton = ... # 0x100000
    Close                    : QMessageBox.StandardButton = ... # 0x200000
    Cancel                   : QMessageBox.StandardButton = ... # 0x400000
    Discard                  : QMessageBox.StandardButton = ... # 0x800000
    Help                     : QMessageBox.StandardButton = ... # 0x1000000
    Apply                    : QMessageBox.StandardButton = ... # 0x2000000
    Reset                    : QMessageBox.StandardButton = ... # 0x4000000
    LastButton               : QMessageBox.StandardButton = ... # 0x8000000
    RestoreDefaults          : QMessageBox.StandardButton = ... # 0x8000000

    class ButtonRole(Shiboken.Enum):
        InvalidRole              : QMessageBox.ButtonRole = ... # -0x1
        AcceptRole               : QMessageBox.ButtonRole = ... # 0x0
        RejectRole               : QMessageBox.ButtonRole = ... # 0x1
        DestructiveRole          : QMessageBox.ButtonRole = ... # 0x2
        ActionRole               : QMessageBox.ButtonRole = ... # 0x3
        HelpRole                 : QMessageBox.ButtonRole = ... # 0x4
        YesRole                  : QMessageBox.ButtonRole = ... # 0x5
        NoRole                   : QMessageBox.ButtonRole = ... # 0x6
        ResetRole                : QMessageBox.ButtonRole = ... # 0x7
        ApplyRole                : QMessageBox.ButtonRole = ... # 0x8
        NRoles                   : QMessageBox.ButtonRole = ... # 0x9

    class Icon(Shiboken.Enum):
        NoIcon                   : QMessageBox.Icon = ... # 0x0
        Information              : QMessageBox.Icon = ... # 0x1
        Warning                  : QMessageBox.Icon = ... # 0x2
        Critical                 : QMessageBox.Icon = ... # 0x3
        Question                 : QMessageBox.Icon = ... # 0x4

    class StandardButton(Shiboken.Enum):
        ButtonMask               : QMessageBox.StandardButton = ... # -0x301
        NoButton                 : QMessageBox.StandardButton = ... # 0x0
        Default                  : QMessageBox.StandardButton = ... # 0x100
        Escape                   : QMessageBox.StandardButton = ... # 0x200
        FlagMask                 : QMessageBox.StandardButton = ... # 0x300
        FirstButton              : QMessageBox.StandardButton = ... # 0x400
        Ok                       : QMessageBox.StandardButton = ... # 0x400
        Save                     : QMessageBox.StandardButton = ... # 0x800
        SaveAll                  : QMessageBox.StandardButton = ... # 0x1000
        Open                     : QMessageBox.StandardButton = ... # 0x2000
        Yes                      : QMessageBox.StandardButton = ... # 0x4000
        YesAll                   : QMessageBox.StandardButton = ... # 0x8000
        YesToAll                 : QMessageBox.StandardButton = ... # 0x8000
        No                       : QMessageBox.StandardButton = ... # 0x10000
        NoAll                    : QMessageBox.StandardButton = ... # 0x20000
        NoToAll                  : QMessageBox.StandardButton = ... # 0x20000
        Abort                    : QMessageBox.StandardButton = ... # 0x40000
        Retry                    : QMessageBox.StandardButton = ... # 0x80000
        Ignore                   : QMessageBox.StandardButton = ... # 0x100000
        Close                    : QMessageBox.StandardButton = ... # 0x200000
        Cancel                   : QMessageBox.StandardButton = ... # 0x400000
        Discard                  : QMessageBox.StandardButton = ... # 0x800000
        Help                     : QMessageBox.StandardButton = ... # 0x1000000
        Apply                    : QMessageBox.StandardButton = ... # 0x2000000
        Reset                    : QMessageBox.StandardButton = ... # 0x4000000
        LastButton               : QMessageBox.StandardButton = ... # 0x8000000
        RestoreDefaults          : QMessageBox.StandardButton = ... # 0x8000000

    class StandardButtons(object): ...

    @typing.overload
    def __init__(self, icon: PySide2.QtWidgets.QMessageBox.Icon, title: str, text: str, buttons: PySide2.QtWidgets.QMessageBox.StandardButtons = ..., parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    @staticmethod
    def about(parent: PySide2.QtWidgets.QWidget, title: str, text: str) -> None: ...
    @staticmethod
    def aboutQt(parent: PySide2.QtWidgets.QWidget, title: str = ...) -> None: ...
    @typing.overload
    def addButton(self, button: PySide2.QtWidgets.QAbstractButton, role: PySide2.QtWidgets.QMessageBox.ButtonRole) -> None: ...
    @typing.overload
    def addButton(self, button: PySide2.QtWidgets.QMessageBox.StandardButton) -> PySide2.QtWidgets.QPushButton: ...
    @typing.overload
    def addButton(self, text: str, role: PySide2.QtWidgets.QMessageBox.ButtonRole) -> PySide2.QtWidgets.QPushButton: ...
    def button(self, which: PySide2.QtWidgets.QMessageBox.StandardButton) -> PySide2.QtWidgets.QAbstractButton: ...
    def buttonRole(self, button: PySide2.QtWidgets.QAbstractButton) -> PySide2.QtWidgets.QMessageBox.ButtonRole: ...
    def buttonText(self, button: int) -> str: ...
    def buttons(self) -> typing.List[PySide2.QtWidgets.QAbstractButton]: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def checkBox(self) -> PySide2.QtWidgets.QCheckBox: ...
    def clickedButton(self) -> PySide2.QtWidgets.QAbstractButton: ...
    def closeEvent(self, event: PySide2.QtGui.QCloseEvent) -> None: ...
    @typing.overload
    @staticmethod
    def critical(parent: PySide2.QtWidgets.QWidget, title: str, text: str, button0: PySide2.QtWidgets.QMessageBox.StandardButton, button1: PySide2.QtWidgets.QMessageBox.StandardButton) -> int: ...
    @typing.overload
    @staticmethod
    def critical(parent: PySide2.QtWidgets.QWidget, title: str, text: str, buttons: PySide2.QtWidgets.QMessageBox.StandardButtons = ..., defaultButton: PySide2.QtWidgets.QMessageBox.StandardButton = ...) -> PySide2.QtWidgets.QMessageBox.StandardButton: ...
    def defaultButton(self) -> PySide2.QtWidgets.QPushButton: ...
    def detailedText(self) -> str: ...
    def escapeButton(self) -> PySide2.QtWidgets.QAbstractButton: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def icon(self) -> PySide2.QtWidgets.QMessageBox.Icon: ...
    def iconPixmap(self) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    @staticmethod
    def information(parent: PySide2.QtWidgets.QWidget, title: str, text: str, button0: PySide2.QtWidgets.QMessageBox.StandardButton, button1: PySide2.QtWidgets.QMessageBox.StandardButton = ...) -> PySide2.QtWidgets.QMessageBox.StandardButton: ...
    @typing.overload
    @staticmethod
    def information(parent: PySide2.QtWidgets.QWidget, title: str, text: str, buttons: PySide2.QtWidgets.QMessageBox.StandardButtons = ..., defaultButton: PySide2.QtWidgets.QMessageBox.StandardButton = ...) -> PySide2.QtWidgets.QMessageBox.StandardButton: ...
    def informativeText(self) -> str: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    @typing.overload
    def open(self) -> None: ...
    @typing.overload
    def open(self, receiver: PySide2.QtCore.QObject, member: bytes) -> None: ...
    @typing.overload
    @staticmethod
    def question(parent: PySide2.QtWidgets.QWidget, title: str, text: str, button0: PySide2.QtWidgets.QMessageBox.StandardButton, button1: PySide2.QtWidgets.QMessageBox.StandardButton) -> int: ...
    @typing.overload
    @staticmethod
    def question(parent: PySide2.QtWidgets.QWidget, title: str, text: str, buttons: PySide2.QtWidgets.QMessageBox.StandardButtons = ..., defaultButton: PySide2.QtWidgets.QMessageBox.StandardButton = ...) -> PySide2.QtWidgets.QMessageBox.StandardButton: ...
    def removeButton(self, button: PySide2.QtWidgets.QAbstractButton) -> None: ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent) -> None: ...
    def setButtonText(self, button: int, text: str) -> None: ...
    def setCheckBox(self, cb: PySide2.QtWidgets.QCheckBox) -> None: ...
    @typing.overload
    def setDefaultButton(self, button: PySide2.QtWidgets.QMessageBox.StandardButton) -> None: ...
    @typing.overload
    def setDefaultButton(self, button: PySide2.QtWidgets.QPushButton) -> None: ...
    def setDetailedText(self, text: str) -> None: ...
    @typing.overload
    def setEscapeButton(self, button: PySide2.QtWidgets.QAbstractButton) -> None: ...
    @typing.overload
    def setEscapeButton(self, button: PySide2.QtWidgets.QMessageBox.StandardButton) -> None: ...
    def setIcon(self, arg__1: PySide2.QtWidgets.QMessageBox.Icon) -> None: ...
    def setIconPixmap(self, pixmap: PySide2.QtGui.QPixmap) -> None: ...
    def setInformativeText(self, text: str) -> None: ...
    def setStandardButtons(self, buttons: PySide2.QtWidgets.QMessageBox.StandardButtons) -> None: ...
    def setText(self, text: str) -> None: ...
    def setTextFormat(self, format: PySide2.QtCore.Qt.TextFormat) -> None: ...
    def setTextInteractionFlags(self, flags: PySide2.QtCore.Qt.TextInteractionFlags) -> None: ...
    def setWindowModality(self, windowModality: PySide2.QtCore.Qt.WindowModality) -> None: ...
    def setWindowTitle(self, title: str) -> None: ...
    def showEvent(self, event: PySide2.QtGui.QShowEvent) -> None: ...
    def standardButton(self, button: PySide2.QtWidgets.QAbstractButton) -> PySide2.QtWidgets.QMessageBox.StandardButton: ...
    def standardButtons(self) -> PySide2.QtWidgets.QMessageBox.StandardButtons: ...
    @staticmethod
    def standardIcon(icon: PySide2.QtWidgets.QMessageBox.Icon) -> PySide2.QtGui.QPixmap: ...
    def text(self) -> str: ...
    def textFormat(self) -> PySide2.QtCore.Qt.TextFormat: ...
    def textInteractionFlags(self) -> PySide2.QtCore.Qt.TextInteractionFlags: ...
    @typing.overload
    @staticmethod
    def warning(parent: PySide2.QtWidgets.QWidget, title: str, text: str, button0: PySide2.QtWidgets.QMessageBox.StandardButton, button1: PySide2.QtWidgets.QMessageBox.StandardButton) -> int: ...
    @typing.overload
    @staticmethod
    def warning(parent: PySide2.QtWidgets.QWidget, title: str, text: str, buttons: PySide2.QtWidgets.QMessageBox.StandardButtons = ..., defaultButton: PySide2.QtWidgets.QMessageBox.StandardButton = ...) -> PySide2.QtWidgets.QMessageBox.StandardButton: ...


class QMouseEventTransition(PySide2.QtCore.QEventTransition):

    @typing.overload
    def __init__(self, object: PySide2.QtCore.QObject, type: PySide2.QtCore.QEvent.Type, button: PySide2.QtCore.Qt.MouseButton, sourceState: typing.Optional[PySide2.QtCore.QState] = ...) -> None: ...
    @typing.overload
    def __init__(self, sourceState: typing.Optional[PySide2.QtCore.QState] = ...) -> None: ...

    def button(self) -> PySide2.QtCore.Qt.MouseButton: ...
    def eventTest(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def hitTestPath(self) -> PySide2.QtGui.QPainterPath: ...
    def modifierMask(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def onTransition(self, event: PySide2.QtCore.QEvent) -> None: ...
    def setButton(self, button: PySide2.QtCore.Qt.MouseButton) -> None: ...
    def setHitTestPath(self, path: PySide2.QtGui.QPainterPath) -> None: ...
    def setModifierMask(self, modifiers: PySide2.QtCore.Qt.KeyboardModifiers) -> None: ...


class QOpenGLWidget(PySide2.QtWidgets.QWidget):
    NoPartialUpdate          : QOpenGLWidget.UpdateBehavior = ... # 0x0
    PartialUpdate            : QOpenGLWidget.UpdateBehavior = ... # 0x1

    class UpdateBehavior(Shiboken.Enum):
        NoPartialUpdate          : QOpenGLWidget.UpdateBehavior = ... # 0x0
        PartialUpdate            : QOpenGLWidget.UpdateBehavior = ... # 0x1

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., f: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...

    def context(self) -> PySide2.QtGui.QOpenGLContext: ...
    def defaultFramebufferObject(self) -> int: ...
    def doneCurrent(self) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def format(self) -> PySide2.QtGui.QSurfaceFormat: ...
    def grabFramebuffer(self) -> PySide2.QtGui.QImage: ...
    def initializeGL(self) -> None: ...
    def isValid(self) -> bool: ...
    def makeCurrent(self) -> None: ...
    def metric(self, metric: PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def paintEvent(self, e: PySide2.QtGui.QPaintEvent) -> None: ...
    def paintGL(self) -> None: ...
    def redirected(self, p: PySide2.QtCore.QPoint) -> PySide2.QtGui.QPaintDevice: ...
    def resizeEvent(self, e: PySide2.QtGui.QResizeEvent) -> None: ...
    def resizeGL(self, w: int, h: int) -> None: ...
    def setFormat(self, format: PySide2.QtGui.QSurfaceFormat) -> None: ...
    def setTextureFormat(self, texFormat: int) -> None: ...
    def setUpdateBehavior(self, updateBehavior: PySide2.QtWidgets.QOpenGLWidget.UpdateBehavior) -> None: ...
    def textureFormat(self) -> int: ...
    def updateBehavior(self) -> PySide2.QtWidgets.QOpenGLWidget.UpdateBehavior: ...


class QPanGesture(PySide2.QtWidgets.QGesture):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def acceleration(self) -> float: ...
    def delta(self) -> PySide2.QtCore.QPointF: ...
    def lastOffset(self) -> PySide2.QtCore.QPointF: ...
    def offset(self) -> PySide2.QtCore.QPointF: ...
    def setAcceleration(self, value: float) -> None: ...
    def setLastOffset(self, value: PySide2.QtCore.QPointF) -> None: ...
    def setOffset(self, value: PySide2.QtCore.QPointF) -> None: ...


class QPinchGesture(PySide2.QtWidgets.QGesture):
    ScaleFactorChanged       : QPinchGesture.ChangeFlag = ... # 0x1
    RotationAngleChanged     : QPinchGesture.ChangeFlag = ... # 0x2
    CenterPointChanged       : QPinchGesture.ChangeFlag = ... # 0x4

    class ChangeFlag(Shiboken.Enum):
        ScaleFactorChanged       : QPinchGesture.ChangeFlag = ... # 0x1
        RotationAngleChanged     : QPinchGesture.ChangeFlag = ... # 0x2
        CenterPointChanged       : QPinchGesture.ChangeFlag = ... # 0x4

    class ChangeFlags(object): ...

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def centerPoint(self) -> PySide2.QtCore.QPointF: ...
    def changeFlags(self) -> PySide2.QtWidgets.QPinchGesture.ChangeFlags: ...
    def lastCenterPoint(self) -> PySide2.QtCore.QPointF: ...
    def lastRotationAngle(self) -> float: ...
    def lastScaleFactor(self) -> float: ...
    def rotationAngle(self) -> float: ...
    def scaleFactor(self) -> float: ...
    def setCenterPoint(self, value: PySide2.QtCore.QPointF) -> None: ...
    def setChangeFlags(self, value: PySide2.QtWidgets.QPinchGesture.ChangeFlags) -> None: ...
    def setLastCenterPoint(self, value: PySide2.QtCore.QPointF) -> None: ...
    def setLastRotationAngle(self, value: float) -> None: ...
    def setLastScaleFactor(self, value: float) -> None: ...
    def setRotationAngle(self, value: float) -> None: ...
    def setScaleFactor(self, value: float) -> None: ...
    def setStartCenterPoint(self, value: PySide2.QtCore.QPointF) -> None: ...
    def setTotalChangeFlags(self, value: PySide2.QtWidgets.QPinchGesture.ChangeFlags) -> None: ...
    def setTotalRotationAngle(self, value: float) -> None: ...
    def setTotalScaleFactor(self, value: float) -> None: ...
    def startCenterPoint(self) -> PySide2.QtCore.QPointF: ...
    def totalChangeFlags(self) -> PySide2.QtWidgets.QPinchGesture.ChangeFlags: ...
    def totalRotationAngle(self) -> float: ...
    def totalScaleFactor(self) -> float: ...


class QPlainTextDocumentLayout(PySide2.QtGui.QAbstractTextDocumentLayout):

    def __init__(self, document: PySide2.QtGui.QTextDocument) -> None: ...

    def blockBoundingRect(self, block: PySide2.QtGui.QTextBlock) -> PySide2.QtCore.QRectF: ...
    def cursorWidth(self) -> int: ...
    def documentChanged(self, from_: int, arg__2: int, charsAdded: int) -> None: ...
    def documentSize(self) -> PySide2.QtCore.QSizeF: ...
    def draw(self, arg__1: PySide2.QtGui.QPainter, arg__2: PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext) -> None: ...
    def ensureBlockLayout(self, block: PySide2.QtGui.QTextBlock) -> None: ...
    def frameBoundingRect(self, arg__1: PySide2.QtGui.QTextFrame) -> PySide2.QtCore.QRectF: ...
    def hitTest(self, arg__1: PySide2.QtCore.QPointF, arg__2: PySide2.QtCore.Qt.HitTestAccuracy) -> int: ...
    def pageCount(self) -> int: ...
    def requestUpdate(self) -> None: ...
    def setCursorWidth(self, width: int) -> None: ...


class QPlainTextEdit(PySide2.QtWidgets.QAbstractScrollArea):
    NoWrap                   : QPlainTextEdit.LineWrapMode = ... # 0x0
    WidgetWidth              : QPlainTextEdit.LineWrapMode = ... # 0x1

    class LineWrapMode(Shiboken.Enum):
        NoWrap                   : QPlainTextEdit.LineWrapMode = ... # 0x0
        WidgetWidth              : QPlainTextEdit.LineWrapMode = ... # 0x1

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def anchorAt(self, pos: PySide2.QtCore.QPoint) -> str: ...
    def appendHtml(self, html: str) -> None: ...
    def appendPlainText(self, text: str) -> None: ...
    def backgroundVisible(self) -> bool: ...
    def blockBoundingGeometry(self, block: PySide2.QtGui.QTextBlock) -> PySide2.QtCore.QRectF: ...
    def blockBoundingRect(self, block: PySide2.QtGui.QTextBlock) -> PySide2.QtCore.QRectF: ...
    def blockCount(self) -> int: ...
    def canInsertFromMimeData(self, source: PySide2.QtCore.QMimeData) -> bool: ...
    def canPaste(self) -> bool: ...
    def centerCursor(self) -> None: ...
    def centerOnScroll(self) -> bool: ...
    def changeEvent(self, e: PySide2.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def contentOffset(self) -> PySide2.QtCore.QPointF: ...
    def contextMenuEvent(self, e: PySide2.QtGui.QContextMenuEvent) -> None: ...
    def copy(self) -> None: ...
    def createMimeDataFromSelection(self) -> PySide2.QtCore.QMimeData: ...
    @typing.overload
    def createStandardContextMenu(self) -> PySide2.QtWidgets.QMenu: ...
    @typing.overload
    def createStandardContextMenu(self, position: PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QMenu: ...
    def currentCharFormat(self) -> PySide2.QtGui.QTextCharFormat: ...
    def cursorForPosition(self, pos: PySide2.QtCore.QPoint) -> PySide2.QtGui.QTextCursor: ...
    @typing.overload
    def cursorRect(self) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def cursorRect(self, cursor: PySide2.QtGui.QTextCursor) -> PySide2.QtCore.QRect: ...
    def cursorWidth(self) -> int: ...
    def cut(self) -> None: ...
    def doSetTextCursor(self, cursor: PySide2.QtGui.QTextCursor) -> None: ...
    def document(self) -> PySide2.QtGui.QTextDocument: ...
    def documentTitle(self) -> str: ...
    def dragEnterEvent(self, e: PySide2.QtGui.QDragEnterEvent) -> None: ...
    def dragLeaveEvent(self, e: PySide2.QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, e: PySide2.QtGui.QDragMoveEvent) -> None: ...
    def dropEvent(self, e: PySide2.QtGui.QDropEvent) -> None: ...
    def ensureCursorVisible(self) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def extraSelections(self) -> typing.List[PySide2.QtWidgets.QTextEdit.ExtraSelection]: ...
    @typing.overload
    def find(self, exp: PySide2.QtCore.QRegExp, options: PySide2.QtGui.QTextDocument.FindFlags = ...) -> bool: ...
    @typing.overload
    def find(self, exp: PySide2.QtCore.QRegularExpression, options: PySide2.QtGui.QTextDocument.FindFlags = ...) -> bool: ...
    @typing.overload
    def find(self, exp: str, options: PySide2.QtGui.QTextDocument.FindFlags = ...) -> bool: ...
    def firstVisibleBlock(self) -> PySide2.QtGui.QTextBlock: ...
    def focusInEvent(self, e: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, e: PySide2.QtGui.QFocusEvent) -> None: ...
    def getPaintContext(self) -> PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext: ...
    def inputMethodEvent(self, arg__1: PySide2.QtGui.QInputMethodEvent) -> None: ...
    @typing.overload
    def inputMethodQuery(self, property: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    @typing.overload
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery, argument: typing.Any) -> typing.Any: ...
    def insertFromMimeData(self, source: PySide2.QtCore.QMimeData) -> None: ...
    def insertPlainText(self, text: str) -> None: ...
    def isReadOnly(self) -> bool: ...
    def isUndoRedoEnabled(self) -> bool: ...
    def keyPressEvent(self, e: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, e: PySide2.QtGui.QKeyEvent) -> None: ...
    def lineWrapMode(self) -> PySide2.QtWidgets.QPlainTextEdit.LineWrapMode: ...
    def loadResource(self, type: int, name: PySide2.QtCore.QUrl) -> typing.Any: ...
    def maximumBlockCount(self) -> int: ...
    def mergeCurrentCharFormat(self, modifier: PySide2.QtGui.QTextCharFormat) -> None: ...
    def mouseDoubleClickEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def moveCursor(self, operation: PySide2.QtGui.QTextCursor.MoveOperation, mode: PySide2.QtGui.QTextCursor.MoveMode = ...) -> None: ...
    def overwriteMode(self) -> bool: ...
    def paintEvent(self, e: PySide2.QtGui.QPaintEvent) -> None: ...
    def paste(self) -> None: ...
    def placeholderText(self) -> str: ...
    def print_(self, printer: PySide2.QtGui.QPagedPaintDevice) -> None: ...
    def redo(self) -> None: ...
    def resizeEvent(self, e: PySide2.QtGui.QResizeEvent) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def selectAll(self) -> None: ...
    def setBackgroundVisible(self, visible: bool) -> None: ...
    def setCenterOnScroll(self, enabled: bool) -> None: ...
    def setCurrentCharFormat(self, format: PySide2.QtGui.QTextCharFormat) -> None: ...
    def setCursorWidth(self, width: int) -> None: ...
    def setDocument(self, document: PySide2.QtGui.QTextDocument) -> None: ...
    def setDocumentTitle(self, title: str) -> None: ...
    def setExtraSelections(self, selections: typing.Sequence[PySide2.QtWidgets.QTextEdit.ExtraSelection]) -> None: ...
    def setLineWrapMode(self, mode: PySide2.QtWidgets.QPlainTextEdit.LineWrapMode) -> None: ...
    def setMaximumBlockCount(self, maximum: int) -> None: ...
    def setOverwriteMode(self, overwrite: bool) -> None: ...
    def setPlaceholderText(self, placeholderText: str) -> None: ...
    def setPlainText(self, text: str) -> None: ...
    def setReadOnly(self, ro: bool) -> None: ...
    def setTabChangesFocus(self, b: bool) -> None: ...
    def setTabStopDistance(self, distance: float) -> None: ...
    def setTabStopWidth(self, width: int) -> None: ...
    def setTextCursor(self, cursor: PySide2.QtGui.QTextCursor) -> None: ...
    def setTextInteractionFlags(self, flags: PySide2.QtCore.Qt.TextInteractionFlags) -> None: ...
    def setUndoRedoEnabled(self, enable: bool) -> None: ...
    def setWordWrapMode(self, policy: PySide2.QtGui.QTextOption.WrapMode) -> None: ...
    def showEvent(self, arg__1: PySide2.QtGui.QShowEvent) -> None: ...
    def tabChangesFocus(self) -> bool: ...
    def tabStopDistance(self) -> float: ...
    def tabStopWidth(self) -> int: ...
    def textCursor(self) -> PySide2.QtGui.QTextCursor: ...
    def textInteractionFlags(self) -> PySide2.QtCore.Qt.TextInteractionFlags: ...
    def timerEvent(self, e: PySide2.QtCore.QTimerEvent) -> None: ...
    def toPlainText(self) -> str: ...
    def undo(self) -> None: ...
    def wheelEvent(self, e: PySide2.QtGui.QWheelEvent) -> None: ...
    def wordWrapMode(self) -> PySide2.QtGui.QTextOption.WrapMode: ...
    def zoomIn(self, range: int = ...) -> None: ...
    def zoomInF(self, range: float) -> None: ...
    def zoomOut(self, range: int = ...) -> None: ...


class QProgressBar(PySide2.QtWidgets.QWidget):
    TopToBottom              : QProgressBar.Direction = ... # 0x0
    BottomToTop              : QProgressBar.Direction = ... # 0x1

    class Direction(Shiboken.Enum):
        TopToBottom              : QProgressBar.Direction = ... # 0x0
        BottomToTop              : QProgressBar.Direction = ... # 0x1

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def format(self) -> str: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionProgressBar) -> None: ...
    def invertedAppearance(self) -> bool: ...
    def isTextVisible(self) -> bool: ...
    def maximum(self) -> int: ...
    def minimum(self) -> int: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def reset(self) -> None: ...
    def resetFormat(self) -> None: ...
    def setAlignment(self, alignment: PySide2.QtCore.Qt.Alignment) -> None: ...
    def setFormat(self, format: str) -> None: ...
    def setInvertedAppearance(self, invert: bool) -> None: ...
    def setMaximum(self, maximum: int) -> None: ...
    def setMinimum(self, minimum: int) -> None: ...
    def setOrientation(self, arg__1: PySide2.QtCore.Qt.Orientation) -> None: ...
    def setRange(self, minimum: int, maximum: int) -> None: ...
    def setTextDirection(self, textDirection: PySide2.QtWidgets.QProgressBar.Direction) -> None: ...
    def setTextVisible(self, visible: bool) -> None: ...
    def setValue(self, value: int) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def text(self) -> str: ...
    def textDirection(self) -> PySide2.QtWidgets.QProgressBar.Direction: ...
    def value(self) -> int: ...


class QProgressDialog(PySide2.QtWidgets.QDialog):

    @typing.overload
    def __init__(self, labelText: str, cancelButtonText: str, minimum: int, maximum: int, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...

    def autoClose(self) -> bool: ...
    def autoReset(self) -> bool: ...
    def cancel(self) -> None: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def closeEvent(self, event: PySide2.QtGui.QCloseEvent) -> None: ...
    def forceShow(self) -> None: ...
    def labelText(self) -> str: ...
    def maximum(self) -> int: ...
    def minimum(self) -> int: ...
    def minimumDuration(self) -> int: ...
    @typing.overload
    def open(self) -> None: ...
    @typing.overload
    def open(self, receiver: PySide2.QtCore.QObject, member: bytes) -> None: ...
    def reset(self) -> None: ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent) -> None: ...
    def setAutoClose(self, close: bool) -> None: ...
    def setAutoReset(self, reset: bool) -> None: ...
    def setBar(self, bar: PySide2.QtWidgets.QProgressBar) -> None: ...
    def setCancelButton(self, button: PySide2.QtWidgets.QPushButton) -> None: ...
    def setCancelButtonText(self, text: str) -> None: ...
    def setLabel(self, label: PySide2.QtWidgets.QLabel) -> None: ...
    def setLabelText(self, text: str) -> None: ...
    def setMaximum(self, maximum: int) -> None: ...
    def setMinimum(self, minimum: int) -> None: ...
    def setMinimumDuration(self, ms: int) -> None: ...
    def setRange(self, minimum: int, maximum: int) -> None: ...
    def setValue(self, progress: int) -> None: ...
    def showEvent(self, event: PySide2.QtGui.QShowEvent) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def value(self) -> int: ...
    def wasCanceled(self) -> bool: ...


class QProxyStyle(PySide2.QtWidgets.QCommonStyle):

    @typing.overload
    def __init__(self, key: str) -> None: ...
    @typing.overload
    def __init__(self, style: typing.Optional[PySide2.QtWidgets.QStyle] = ...) -> None: ...

    def baseStyle(self) -> PySide2.QtWidgets.QStyle: ...
    def drawItemPixmap(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRect, alignment: int, pixmap: PySide2.QtGui.QPixmap) -> None: ...
    def drawItemText(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRect, flags: int, pal: PySide2.QtGui.QPalette, enabled: bool, text: str, textRole: PySide2.QtGui.QPalette.ColorRole = ...) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def generatedIconPixmap(self, iconMode: PySide2.QtGui.QIcon.Mode, pixmap: PySide2.QtGui.QPixmap, opt: PySide2.QtWidgets.QStyleOption) -> PySide2.QtGui.QPixmap: ...
    def itemPixmapRect(self, r: PySide2.QtCore.QRect, flags: int, pixmap: PySide2.QtGui.QPixmap) -> PySide2.QtCore.QRect: ...
    def itemTextRect(self, fm: PySide2.QtGui.QFontMetrics, r: PySide2.QtCore.QRect, flags: int, enabled: bool, text: str) -> PySide2.QtCore.QRect: ...
    def layoutSpacing(self, control1: PySide2.QtWidgets.QSizePolicy.ControlType, control2: PySide2.QtWidgets.QSizePolicy.ControlType, orientation: PySide2.QtCore.Qt.Orientation, option: typing.Optional[PySide2.QtWidgets.QStyleOption] = ..., widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> int: ...
    @typing.overload
    def polish(self, app: PySide2.QtWidgets.QApplication) -> None: ...
    @typing.overload
    def polish(self, pal: PySide2.QtGui.QPalette) -> None: ...
    @typing.overload
    def polish(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def setBaseStyle(self, style: PySide2.QtWidgets.QStyle) -> None: ...
    def standardPalette(self) -> PySide2.QtGui.QPalette: ...
    @typing.overload
    def unpolish(self, app: PySide2.QtWidgets.QApplication) -> None: ...
    @typing.overload
    def unpolish(self, application: PySide2.QtWidgets.QApplication) -> None: ...
    @typing.overload
    def unpolish(self, widget: PySide2.QtWidgets.QWidget) -> None: ...


class QPushButton(PySide2.QtWidgets.QAbstractButton):

    @typing.overload
    def __init__(self, icon: PySide2.QtGui.QIcon, text: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def autoDefault(self) -> bool: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, arg__1: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, arg__1: PySide2.QtGui.QFocusEvent) -> None: ...
    def hitButton(self, pos: PySide2.QtCore.QPoint) -> bool: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionButton) -> None: ...
    def isDefault(self) -> bool: ...
    def isFlat(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent) -> None: ...
    def menu(self) -> PySide2.QtWidgets.QMenu: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def setAutoDefault(self, arg__1: bool) -> None: ...
    def setDefault(self, arg__1: bool) -> None: ...
    def setFlat(self, arg__1: bool) -> None: ...
    def setMenu(self, menu: PySide2.QtWidgets.QMenu) -> None: ...
    def showMenu(self) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...


class QRadioButton(PySide2.QtWidgets.QAbstractButton):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def hitButton(self, arg__1: PySide2.QtCore.QPoint) -> bool: ...
    def initStyleOption(self, button: PySide2.QtWidgets.QStyleOptionButton) -> None: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...


class QRubberBand(PySide2.QtWidgets.QWidget):
    Line                     : QRubberBand.Shape = ... # 0x0
    Rectangle                : QRubberBand.Shape = ... # 0x1

    class Shape(Shiboken.Enum):
        Line                     : QRubberBand.Shape = ... # 0x0
        Rectangle                : QRubberBand.Shape = ... # 0x1

    def __init__(self, arg__1: PySide2.QtWidgets.QRubberBand.Shape, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def changeEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionRubberBand) -> None: ...
    @typing.overload
    def move(self, p: PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def move(self, x: int, y: int) -> None: ...
    def moveEvent(self, arg__1: PySide2.QtGui.QMoveEvent) -> None: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    @typing.overload
    def resize(self, s: PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def resize(self, w: int, h: int) -> None: ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent) -> None: ...
    @typing.overload
    def setGeometry(self, r: PySide2.QtCore.QRect) -> None: ...
    @typing.overload
    def setGeometry(self, x: int, y: int, w: int, h: int) -> None: ...
    def shape(self) -> PySide2.QtWidgets.QRubberBand.Shape: ...
    def showEvent(self, arg__1: PySide2.QtGui.QShowEvent) -> None: ...


class QScrollArea(PySide2.QtWidgets.QAbstractScrollArea):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def ensureVisible(self, x: int, y: int, xmargin: int = ..., ymargin: int = ...) -> None: ...
    def ensureWidgetVisible(self, childWidget: PySide2.QtWidgets.QWidget, xmargin: int = ..., ymargin: int = ...) -> None: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1: PySide2.QtCore.QObject, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def setAlignment(self, arg__1: PySide2.QtCore.Qt.Alignment) -> None: ...
    def setWidget(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def setWidgetResizable(self, resizable: bool) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def takeWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def viewportSizeHint(self) -> PySide2.QtCore.QSize: ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...
    def widgetResizable(self) -> bool: ...


class QScrollBar(PySide2.QtWidgets.QAbstractSlider):

    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.Qt.Orientation, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def contextMenuEvent(self, arg__1: PySide2.QtGui.QContextMenuEvent) -> None: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def hideEvent(self, arg__1: PySide2.QtGui.QHideEvent) -> None: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionSlider) -> None: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def sliderChange(self, change: PySide2.QtWidgets.QAbstractSlider.SliderChange) -> None: ...
    def wheelEvent(self, arg__1: PySide2.QtGui.QWheelEvent) -> None: ...


class QScroller(PySide2.QtCore.QObject):
    InputPress               : QScroller.Input = ... # 0x1
    InputMove                : QScroller.Input = ... # 0x2
    InputRelease             : QScroller.Input = ... # 0x3
    TouchGesture             : QScroller.ScrollerGestureType = ... # 0x0
    LeftMouseButtonGesture   : QScroller.ScrollerGestureType = ... # 0x1
    RightMouseButtonGesture  : QScroller.ScrollerGestureType = ... # 0x2
    MiddleMouseButtonGesture : QScroller.ScrollerGestureType = ... # 0x3
    Inactive                 : QScroller.State = ... # 0x0
    Pressed                  : QScroller.State = ... # 0x1
    Dragging                 : QScroller.State = ... # 0x2
    Scrolling                : QScroller.State = ... # 0x3

    class Input(Shiboken.Enum):
        InputPress               : QScroller.Input = ... # 0x1
        InputMove                : QScroller.Input = ... # 0x2
        InputRelease             : QScroller.Input = ... # 0x3

    class ScrollerGestureType(Shiboken.Enum):
        TouchGesture             : QScroller.ScrollerGestureType = ... # 0x0
        LeftMouseButtonGesture   : QScroller.ScrollerGestureType = ... # 0x1
        RightMouseButtonGesture  : QScroller.ScrollerGestureType = ... # 0x2
        MiddleMouseButtonGesture : QScroller.ScrollerGestureType = ... # 0x3

    class State(Shiboken.Enum):
        Inactive                 : QScroller.State = ... # 0x0
        Pressed                  : QScroller.State = ... # 0x1
        Dragging                 : QScroller.State = ... # 0x2
        Scrolling                : QScroller.State = ... # 0x3
    @staticmethod
    def activeScrollers() -> typing.List[PySide2.QtWidgets.QScroller]: ...
    @typing.overload
    def ensureVisible(self, rect: PySide2.QtCore.QRectF, xmargin: float, ymargin: float) -> None: ...
    @typing.overload
    def ensureVisible(self, rect: PySide2.QtCore.QRectF, xmargin: float, ymargin: float, scrollTime: int) -> None: ...
    def finalPosition(self) -> PySide2.QtCore.QPointF: ...
    @staticmethod
    def grabGesture(target: PySide2.QtCore.QObject, gestureType: PySide2.QtWidgets.QScroller.ScrollerGestureType = ...) -> PySide2.QtCore.Qt.GestureType: ...
    @staticmethod
    def grabbedGesture(target: PySide2.QtCore.QObject) -> PySide2.QtCore.Qt.GestureType: ...
    def handleInput(self, input: PySide2.QtWidgets.QScroller.Input, position: PySide2.QtCore.QPointF, timestamp: int = ...) -> bool: ...
    @staticmethod
    def hasScroller(target: PySide2.QtCore.QObject) -> bool: ...
    def pixelPerMeter(self) -> PySide2.QtCore.QPointF: ...
    def resendPrepareEvent(self) -> None: ...
    @typing.overload
    def scrollTo(self, pos: PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def scrollTo(self, pos: PySide2.QtCore.QPointF, scrollTime: int) -> None: ...
    @staticmethod
    def scroller(target: PySide2.QtCore.QObject) -> PySide2.QtWidgets.QScroller: ...
    def scrollerProperties(self) -> PySide2.QtWidgets.QScrollerProperties: ...
    def setScrollerProperties(self, prop: PySide2.QtWidgets.QScrollerProperties) -> None: ...
    @typing.overload
    def setSnapPositionsX(self, first: float, interval: float) -> None: ...
    @typing.overload
    def setSnapPositionsX(self, positions: typing.Sequence[float]) -> None: ...
    @typing.overload
    def setSnapPositionsY(self, first: float, interval: float) -> None: ...
    @typing.overload
    def setSnapPositionsY(self, positions: typing.Sequence[float]) -> None: ...
    def state(self) -> PySide2.QtWidgets.QScroller.State: ...
    def stop(self) -> None: ...
    def target(self) -> PySide2.QtCore.QObject: ...
    @staticmethod
    def ungrabGesture(target: PySide2.QtCore.QObject) -> None: ...
    def velocity(self) -> PySide2.QtCore.QPointF: ...


class QScrollerProperties(Shiboken.Object):
    Standard                 : QScrollerProperties.FrameRates = ... # 0x0
    Fps60                    : QScrollerProperties.FrameRates = ... # 0x1
    Fps30                    : QScrollerProperties.FrameRates = ... # 0x2
    Fps20                    : QScrollerProperties.FrameRates = ... # 0x3
    OvershootWhenScrollable  : QScrollerProperties.OvershootPolicy = ... # 0x0
    OvershootAlwaysOff       : QScrollerProperties.OvershootPolicy = ... # 0x1
    OvershootAlwaysOn        : QScrollerProperties.OvershootPolicy = ... # 0x2
    MousePressEventDelay     : QScrollerProperties.ScrollMetric = ... # 0x0
    DragStartDistance        : QScrollerProperties.ScrollMetric = ... # 0x1
    DragVelocitySmoothingFactor: QScrollerProperties.ScrollMetric = ... # 0x2
    AxisLockThreshold        : QScrollerProperties.ScrollMetric = ... # 0x3
    ScrollingCurve           : QScrollerProperties.ScrollMetric = ... # 0x4
    DecelerationFactor       : QScrollerProperties.ScrollMetric = ... # 0x5
    MinimumVelocity          : QScrollerProperties.ScrollMetric = ... # 0x6
    MaximumVelocity          : QScrollerProperties.ScrollMetric = ... # 0x7
    MaximumClickThroughVelocity: QScrollerProperties.ScrollMetric = ... # 0x8
    AcceleratingFlickMaximumTime: QScrollerProperties.ScrollMetric = ... # 0x9
    AcceleratingFlickSpeedupFactor: QScrollerProperties.ScrollMetric = ... # 0xa
    SnapPositionRatio        : QScrollerProperties.ScrollMetric = ... # 0xb
    SnapTime                 : QScrollerProperties.ScrollMetric = ... # 0xc
    OvershootDragResistanceFactor: QScrollerProperties.ScrollMetric = ... # 0xd
    OvershootDragDistanceFactor: QScrollerProperties.ScrollMetric = ... # 0xe
    OvershootScrollDistanceFactor: QScrollerProperties.ScrollMetric = ... # 0xf
    OvershootScrollTime      : QScrollerProperties.ScrollMetric = ... # 0x10
    HorizontalOvershootPolicy: QScrollerProperties.ScrollMetric = ... # 0x11
    VerticalOvershootPolicy  : QScrollerProperties.ScrollMetric = ... # 0x12
    FrameRate                : QScrollerProperties.ScrollMetric = ... # 0x13
    ScrollMetricCount        : QScrollerProperties.ScrollMetric = ... # 0x14

    class FrameRates(Shiboken.Enum):
        Standard                 : QScrollerProperties.FrameRates = ... # 0x0
        Fps60                    : QScrollerProperties.FrameRates = ... # 0x1
        Fps30                    : QScrollerProperties.FrameRates = ... # 0x2
        Fps20                    : QScrollerProperties.FrameRates = ... # 0x3

    class OvershootPolicy(Shiboken.Enum):
        OvershootWhenScrollable  : QScrollerProperties.OvershootPolicy = ... # 0x0
        OvershootAlwaysOff       : QScrollerProperties.OvershootPolicy = ... # 0x1
        OvershootAlwaysOn        : QScrollerProperties.OvershootPolicy = ... # 0x2

    class ScrollMetric(Shiboken.Enum):
        MousePressEventDelay     : QScrollerProperties.ScrollMetric = ... # 0x0
        DragStartDistance        : QScrollerProperties.ScrollMetric = ... # 0x1
        DragVelocitySmoothingFactor: QScrollerProperties.ScrollMetric = ... # 0x2
        AxisLockThreshold        : QScrollerProperties.ScrollMetric = ... # 0x3
        ScrollingCurve           : QScrollerProperties.ScrollMetric = ... # 0x4
        DecelerationFactor       : QScrollerProperties.ScrollMetric = ... # 0x5
        MinimumVelocity          : QScrollerProperties.ScrollMetric = ... # 0x6
        MaximumVelocity          : QScrollerProperties.ScrollMetric = ... # 0x7
        MaximumClickThroughVelocity: QScrollerProperties.ScrollMetric = ... # 0x8
        AcceleratingFlickMaximumTime: QScrollerProperties.ScrollMetric = ... # 0x9
        AcceleratingFlickSpeedupFactor: QScrollerProperties.ScrollMetric = ... # 0xa
        SnapPositionRatio        : QScrollerProperties.ScrollMetric = ... # 0xb
        SnapTime                 : QScrollerProperties.ScrollMetric = ... # 0xc
        OvershootDragResistanceFactor: QScrollerProperties.ScrollMetric = ... # 0xd
        OvershootDragDistanceFactor: QScrollerProperties.ScrollMetric = ... # 0xe
        OvershootScrollDistanceFactor: QScrollerProperties.ScrollMetric = ... # 0xf
        OvershootScrollTime      : QScrollerProperties.ScrollMetric = ... # 0x10
        HorizontalOvershootPolicy: QScrollerProperties.ScrollMetric = ... # 0x11
        VerticalOvershootPolicy  : QScrollerProperties.ScrollMetric = ... # 0x12
        FrameRate                : QScrollerProperties.ScrollMetric = ... # 0x13
        ScrollMetricCount        : QScrollerProperties.ScrollMetric = ... # 0x14

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, sp: PySide2.QtWidgets.QScrollerProperties) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def scrollMetric(self, metric: PySide2.QtWidgets.QScrollerProperties.ScrollMetric) -> typing.Any: ...
    @staticmethod
    def setDefaultScrollerProperties(sp: PySide2.QtWidgets.QScrollerProperties) -> None: ...
    def setScrollMetric(self, metric: PySide2.QtWidgets.QScrollerProperties.ScrollMetric, value: typing.Any) -> None: ...
    @staticmethod
    def unsetDefaultScrollerProperties() -> None: ...


class QShortcut(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, arg__1: PySide2.QtGui.QKeySequence, arg__2: PySide2.QtWidgets.QWidget, arg__3: typing.Callable, arg__4: PySide2.QtCore.Qt.ShortcutContext = ...) -> None: ...
    @typing.overload
    def __init__(self, key: PySide2.QtGui.QKeySequence, parent: PySide2.QtWidgets.QWidget, member: typing.Optional[bytes] = ..., ambiguousMember: typing.Optional[bytes] = ..., shortcutContext: PySide2.QtCore.Qt.ShortcutContext = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget) -> None: ...

    def autoRepeat(self) -> bool: ...
    def context(self) -> PySide2.QtCore.Qt.ShortcutContext: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def id(self) -> int: ...
    def isEnabled(self) -> bool: ...
    def key(self) -> PySide2.QtGui.QKeySequence: ...
    def parentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def setAutoRepeat(self, on: bool) -> None: ...
    def setContext(self, context: PySide2.QtCore.Qt.ShortcutContext) -> None: ...
    def setEnabled(self, enable: bool) -> None: ...
    def setKey(self, key: PySide2.QtGui.QKeySequence) -> None: ...
    def setWhatsThis(self, text: str) -> None: ...
    def whatsThis(self) -> str: ...


class QSizeGrip(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: PySide2.QtWidgets.QWidget) -> None: ...

    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1: PySide2.QtCore.QObject, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    def hideEvent(self, hideEvent: PySide2.QtGui.QHideEvent) -> None: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, mouseEvent: PySide2.QtGui.QMouseEvent) -> None: ...
    def moveEvent(self, moveEvent: PySide2.QtGui.QMoveEvent) -> None: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def setVisible(self, arg__1: bool) -> None: ...
    def showEvent(self, showEvent: PySide2.QtGui.QShowEvent) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...


class QSizePolicy(Shiboken.Object):
    DefaultType              : QSizePolicy.ControlType = ... # 0x1
    ButtonBox                : QSizePolicy.ControlType = ... # 0x2
    CheckBox                 : QSizePolicy.ControlType = ... # 0x4
    ComboBox                 : QSizePolicy.ControlType = ... # 0x8
    Frame                    : QSizePolicy.ControlType = ... # 0x10
    GroupBox                 : QSizePolicy.ControlType = ... # 0x20
    Label                    : QSizePolicy.ControlType = ... # 0x40
    Line                     : QSizePolicy.ControlType = ... # 0x80
    LineEdit                 : QSizePolicy.ControlType = ... # 0x100
    PushButton               : QSizePolicy.ControlType = ... # 0x200
    RadioButton              : QSizePolicy.ControlType = ... # 0x400
    Slider                   : QSizePolicy.ControlType = ... # 0x800
    SpinBox                  : QSizePolicy.ControlType = ... # 0x1000
    TabWidget                : QSizePolicy.ControlType = ... # 0x2000
    ToolButton               : QSizePolicy.ControlType = ... # 0x4000
    Fixed                    : QSizePolicy.Policy = ... # 0x0
    Minimum                  : QSizePolicy.Policy = ... # 0x1
    MinimumExpanding         : QSizePolicy.Policy = ... # 0x3
    Maximum                  : QSizePolicy.Policy = ... # 0x4
    Preferred                : QSizePolicy.Policy = ... # 0x5
    Expanding                : QSizePolicy.Policy = ... # 0x7
    Ignored                  : QSizePolicy.Policy = ... # 0xd
    GrowFlag                 : QSizePolicy.PolicyFlag = ... # 0x1
    ExpandFlag               : QSizePolicy.PolicyFlag = ... # 0x2
    ShrinkFlag               : QSizePolicy.PolicyFlag = ... # 0x4
    IgnoreFlag               : QSizePolicy.PolicyFlag = ... # 0x8

    class ControlType(Shiboken.Enum):
        DefaultType              : QSizePolicy.ControlType = ... # 0x1
        ButtonBox                : QSizePolicy.ControlType = ... # 0x2
        CheckBox                 : QSizePolicy.ControlType = ... # 0x4
        ComboBox                 : QSizePolicy.ControlType = ... # 0x8
        Frame                    : QSizePolicy.ControlType = ... # 0x10
        GroupBox                 : QSizePolicy.ControlType = ... # 0x20
        Label                    : QSizePolicy.ControlType = ... # 0x40
        Line                     : QSizePolicy.ControlType = ... # 0x80
        LineEdit                 : QSizePolicy.ControlType = ... # 0x100
        PushButton               : QSizePolicy.ControlType = ... # 0x200
        RadioButton              : QSizePolicy.ControlType = ... # 0x400
        Slider                   : QSizePolicy.ControlType = ... # 0x800
        SpinBox                  : QSizePolicy.ControlType = ... # 0x1000
        TabWidget                : QSizePolicy.ControlType = ... # 0x2000
        ToolButton               : QSizePolicy.ControlType = ... # 0x4000

    class ControlTypes(object): ...

    class Policy(Shiboken.Enum):
        Fixed                    : QSizePolicy.Policy = ... # 0x0
        Minimum                  : QSizePolicy.Policy = ... # 0x1
        MinimumExpanding         : QSizePolicy.Policy = ... # 0x3
        Maximum                  : QSizePolicy.Policy = ... # 0x4
        Preferred                : QSizePolicy.Policy = ... # 0x5
        Expanding                : QSizePolicy.Policy = ... # 0x7
        Ignored                  : QSizePolicy.Policy = ... # 0xd

    class PolicyFlag(Shiboken.Enum):
        GrowFlag                 : QSizePolicy.PolicyFlag = ... # 0x1
        ExpandFlag               : QSizePolicy.PolicyFlag = ... # 0x2
        ShrinkFlag               : QSizePolicy.PolicyFlag = ... # 0x4
        IgnoreFlag               : QSizePolicy.PolicyFlag = ... # 0x8

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, horizontal: PySide2.QtWidgets.QSizePolicy.Policy, vertical: PySide2.QtWidgets.QSizePolicy.Policy, type: PySide2.QtWidgets.QSizePolicy.ControlType = ...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def controlType(self) -> PySide2.QtWidgets.QSizePolicy.ControlType: ...
    def expandingDirections(self) -> PySide2.QtCore.Qt.Orientations: ...
    def hasHeightForWidth(self) -> bool: ...
    def hasWidthForHeight(self) -> bool: ...
    def horizontalPolicy(self) -> PySide2.QtWidgets.QSizePolicy.Policy: ...
    def horizontalStretch(self) -> int: ...
    def retainSizeWhenHidden(self) -> bool: ...
    def setControlType(self, type: PySide2.QtWidgets.QSizePolicy.ControlType) -> None: ...
    def setHeightForWidth(self, b: bool) -> None: ...
    def setHorizontalPolicy(self, d: PySide2.QtWidgets.QSizePolicy.Policy) -> None: ...
    def setHorizontalStretch(self, stretchFactor: int) -> None: ...
    def setRetainSizeWhenHidden(self, retainSize: bool) -> None: ...
    def setVerticalPolicy(self, d: PySide2.QtWidgets.QSizePolicy.Policy) -> None: ...
    def setVerticalStretch(self, stretchFactor: int) -> None: ...
    def setWidthForHeight(self, b: bool) -> None: ...
    def transpose(self) -> None: ...
    def transposed(self) -> PySide2.QtWidgets.QSizePolicy: ...
    def verticalPolicy(self) -> PySide2.QtWidgets.QSizePolicy.Policy: ...
    def verticalStretch(self) -> int: ...


class QSlider(PySide2.QtWidgets.QAbstractSlider):
    NoTicks                  : QSlider.TickPosition = ... # 0x0
    TicksAbove               : QSlider.TickPosition = ... # 0x1
    TicksLeft                : QSlider.TickPosition = ... # 0x1
    TicksBelow               : QSlider.TickPosition = ... # 0x2
    TicksRight               : QSlider.TickPosition = ... # 0x2
    TicksBothSides           : QSlider.TickPosition = ... # 0x3

    class TickPosition(Shiboken.Enum):
        NoTicks                  : QSlider.TickPosition = ... # 0x0
        TicksAbove               : QSlider.TickPosition = ... # 0x1
        TicksLeft                : QSlider.TickPosition = ... # 0x1
        TicksBelow               : QSlider.TickPosition = ... # 0x2
        TicksRight               : QSlider.TickPosition = ... # 0x2
        TicksBothSides           : QSlider.TickPosition = ... # 0x3

    @typing.overload
    def __init__(self, orientation: PySide2.QtCore.Qt.Orientation, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionSlider) -> None: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, ev: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, ev: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, ev: PySide2.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, ev: PySide2.QtGui.QPaintEvent) -> None: ...
    def setTickInterval(self, ti: int) -> None: ...
    def setTickPosition(self, position: PySide2.QtWidgets.QSlider.TickPosition) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def tickInterval(self) -> int: ...
    def tickPosition(self) -> PySide2.QtWidgets.QSlider.TickPosition: ...


class QSpacerItem(PySide2.QtWidgets.QLayoutItem):

    def __init__(self, w: int, h: int, hData: PySide2.QtWidgets.QSizePolicy.Policy = ..., vData: PySide2.QtWidgets.QSizePolicy.Policy = ...) -> None: ...

    def changeSize(self, w: int, h: int, hData: PySide2.QtWidgets.QSizePolicy.Policy = ..., vData: PySide2.QtWidgets.QSizePolicy.Policy = ...) -> None: ...
    def expandingDirections(self) -> PySide2.QtCore.Qt.Orientations: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def isEmpty(self) -> bool: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def setGeometry(self, arg__1: PySide2.QtCore.QRect) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def sizePolicy(self) -> PySide2.QtWidgets.QSizePolicy: ...
    def spacerItem(self) -> PySide2.QtWidgets.QSpacerItem: ...


class QSpinBox(PySide2.QtWidgets.QAbstractSpinBox):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def cleanText(self) -> str: ...
    def displayIntegerBase(self) -> int: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def fixup(self, str: str) -> None: ...
    def maximum(self) -> int: ...
    def minimum(self) -> int: ...
    def prefix(self) -> str: ...
    def setDisplayIntegerBase(self, base: int) -> None: ...
    def setMaximum(self, max: int) -> None: ...
    def setMinimum(self, min: int) -> None: ...
    def setPrefix(self, prefix: str) -> None: ...
    def setRange(self, min: int, max: int) -> None: ...
    def setSingleStep(self, val: int) -> None: ...
    def setStepType(self, stepType: PySide2.QtWidgets.QAbstractSpinBox.StepType) -> None: ...
    def setSuffix(self, suffix: str) -> None: ...
    def setValue(self, val: int) -> None: ...
    def singleStep(self) -> int: ...
    def stepType(self) -> PySide2.QtWidgets.QAbstractSpinBox.StepType: ...
    def suffix(self) -> str: ...
    def textFromValue(self, val: int) -> str: ...
    def validate(self, input: str, pos: int) -> PySide2.QtGui.QValidator.State: ...
    def value(self) -> int: ...
    def valueFromText(self, text: str) -> int: ...


class QSplashScreen(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget, pixmap: PySide2.QtGui.QPixmap = ..., f: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...
    @typing.overload
    def __init__(self, pixmap: PySide2.QtGui.QPixmap = ..., f: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...
    @typing.overload
    def __init__(self, screen: PySide2.QtGui.QScreen, pixmap: PySide2.QtGui.QPixmap = ..., f: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...

    def clearMessage(self) -> None: ...
    def drawContents(self, painter: PySide2.QtGui.QPainter) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def finish(self, w: PySide2.QtWidgets.QWidget) -> None: ...
    def message(self) -> str: ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def pixmap(self) -> PySide2.QtGui.QPixmap: ...
    def setPixmap(self, pixmap: PySide2.QtGui.QPixmap) -> None: ...
    def showMessage(self, message: str, alignment: int = ..., color: PySide2.QtGui.QColor = ...) -> None: ...


class QSplitter(PySide2.QtWidgets.QFrame):

    @typing.overload
    def __init__(self, arg__1: PySide2.QtCore.Qt.Orientation, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def __lshift__(self, arg__1: PySide2.QtCore.QTextStream) -> PySide2.QtCore.QTextStream: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QTextStream) -> PySide2.QtCore.QTextStream: ...
    def addWidget(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...
    def childEvent(self, arg__1: PySide2.QtCore.QChildEvent) -> None: ...
    def childrenCollapsible(self) -> bool: ...
    def closestLegalPosition(self, arg__1: int, arg__2: int) -> int: ...
    def count(self) -> int: ...
    def createHandle(self) -> PySide2.QtWidgets.QSplitterHandle: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def getRange(self, index: int) -> typing.Tuple[int, int]: ...
    def handle(self, index: int) -> PySide2.QtWidgets.QSplitterHandle: ...
    def handleWidth(self) -> int: ...
    def indexOf(self, w: PySide2.QtWidgets.QWidget) -> int: ...
    def insertWidget(self, index: int, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def isCollapsible(self, index: int) -> bool: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def moveSplitter(self, pos: int, index: int) -> None: ...
    def opaqueResize(self) -> bool: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def refresh(self) -> None: ...
    def replaceWidget(self, index: int, widget: PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QWidget: ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent) -> None: ...
    def restoreState(self, state: PySide2.QtCore.QByteArray) -> bool: ...
    def saveState(self) -> PySide2.QtCore.QByteArray: ...
    def setChildrenCollapsible(self, arg__1: bool) -> None: ...
    def setCollapsible(self, index: int, arg__2: bool) -> None: ...
    def setHandleWidth(self, arg__1: int) -> None: ...
    def setOpaqueResize(self, opaque: bool = ...) -> None: ...
    def setOrientation(self, arg__1: PySide2.QtCore.Qt.Orientation) -> None: ...
    def setRubberBand(self, position: int) -> None: ...
    def setSizes(self, list: typing.Sequence[int]) -> None: ...
    def setStretchFactor(self, index: int, stretch: int) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def sizes(self) -> typing.List[int]: ...
    def widget(self, index: int) -> PySide2.QtWidgets.QWidget: ...


class QSplitterHandle(PySide2.QtWidgets.QWidget):

    def __init__(self, o: PySide2.QtCore.Qt.Orientation, parent: PySide2.QtWidgets.QSplitter) -> None: ...

    def closestLegalPosition(self, p: int) -> int: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def moveSplitter(self, p: int) -> None: ...
    def opaqueResize(self) -> bool: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent) -> None: ...
    def setOrientation(self, o: PySide2.QtCore.Qt.Orientation) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def splitter(self) -> PySide2.QtWidgets.QSplitter: ...


class QStackedLayout(PySide2.QtWidgets.QLayout):
    StackOne                 : QStackedLayout.StackingMode = ... # 0x0
    StackAll                 : QStackedLayout.StackingMode = ... # 0x1

    class StackingMode(Shiboken.Enum):
        StackOne                 : QStackedLayout.StackingMode = ... # 0x0
        StackAll                 : QStackedLayout.StackingMode = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget) -> None: ...
    @typing.overload
    def __init__(self, parentLayout: PySide2.QtWidgets.QLayout) -> None: ...

    def addItem(self, item: PySide2.QtWidgets.QLayoutItem) -> None: ...
    def addWidget(self, w: PySide2.QtWidgets.QWidget) -> int: ...
    def count(self) -> int: ...
    def currentIndex(self) -> int: ...
    def currentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, width: int) -> int: ...
    def insertWidget(self, index: int, w: PySide2.QtWidgets.QWidget) -> int: ...
    def itemAt(self, arg__1: int) -> PySide2.QtWidgets.QLayoutItem: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def setCurrentWidget(self, w: PySide2.QtWidgets.QWidget) -> None: ...
    def setGeometry(self, rect: PySide2.QtCore.QRect) -> None: ...
    def setStackingMode(self, stackingMode: PySide2.QtWidgets.QStackedLayout.StackingMode) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def stackingMode(self) -> PySide2.QtWidgets.QStackedLayout.StackingMode: ...
    def takeAt(self, arg__1: int) -> PySide2.QtWidgets.QLayoutItem: ...
    @typing.overload
    def widget(self) -> PySide2.QtWidgets.QWidget: ...
    @typing.overload
    def widget(self, arg__1: int) -> PySide2.QtWidgets.QWidget: ...


class QStackedWidget(PySide2.QtWidgets.QFrame):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def addWidget(self, w: PySide2.QtWidgets.QWidget) -> int: ...
    def count(self) -> int: ...
    def currentIndex(self) -> int: ...
    def currentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def indexOf(self, arg__1: PySide2.QtWidgets.QWidget) -> int: ...
    def insertWidget(self, index: int, w: PySide2.QtWidgets.QWidget) -> int: ...
    def removeWidget(self, w: PySide2.QtWidgets.QWidget) -> None: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def setCurrentWidget(self, w: PySide2.QtWidgets.QWidget) -> None: ...
    def widget(self, arg__1: int) -> PySide2.QtWidgets.QWidget: ...


class QStatusBar(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def addPermanentWidget(self, widget: PySide2.QtWidgets.QWidget, stretch: int = ...) -> None: ...
    def addWidget(self, widget: PySide2.QtWidgets.QWidget, stretch: int = ...) -> None: ...
    def clearMessage(self) -> None: ...
    def currentMessage(self) -> str: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def hideOrShow(self) -> None: ...
    def insertPermanentWidget(self, index: int, widget: PySide2.QtWidgets.QWidget, stretch: int = ...) -> int: ...
    def insertWidget(self, index: int, widget: PySide2.QtWidgets.QWidget, stretch: int = ...) -> int: ...
    def isSizeGripEnabled(self) -> bool: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def reformat(self) -> None: ...
    def removeWidget(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent) -> None: ...
    def setSizeGripEnabled(self, arg__1: bool) -> None: ...
    def showEvent(self, arg__1: PySide2.QtGui.QShowEvent) -> None: ...
    def showMessage(self, text: str, timeout: int = ...) -> None: ...


class QStyle(PySide2.QtCore.QObject):
    CC_SpinBox               : QStyle.ComplexControl = ... # 0x0
    CC_ComboBox              : QStyle.ComplexControl = ... # 0x1
    CC_ScrollBar             : QStyle.ComplexControl = ... # 0x2
    CC_Slider                : QStyle.ComplexControl = ... # 0x3
    CC_ToolButton            : QStyle.ComplexControl = ... # 0x4
    CC_TitleBar              : QStyle.ComplexControl = ... # 0x5
    CC_Dial                  : QStyle.ComplexControl = ... # 0x6
    CC_GroupBox              : QStyle.ComplexControl = ... # 0x7
    CC_MdiControls           : QStyle.ComplexControl = ... # 0x8
    CC_CustomBase            : QStyle.ComplexControl = ... # 0xf0000000
    CT_PushButton            : QStyle.ContentsType = ... # 0x0
    CT_CheckBox              : QStyle.ContentsType = ... # 0x1
    CT_RadioButton           : QStyle.ContentsType = ... # 0x2
    CT_ToolButton            : QStyle.ContentsType = ... # 0x3
    CT_ComboBox              : QStyle.ContentsType = ... # 0x4
    CT_Splitter              : QStyle.ContentsType = ... # 0x5
    CT_ProgressBar           : QStyle.ContentsType = ... # 0x6
    CT_MenuItem              : QStyle.ContentsType = ... # 0x7
    CT_MenuBarItem           : QStyle.ContentsType = ... # 0x8
    CT_MenuBar               : QStyle.ContentsType = ... # 0x9
    CT_Menu                  : QStyle.ContentsType = ... # 0xa
    CT_TabBarTab             : QStyle.ContentsType = ... # 0xb
    CT_Slider                : QStyle.ContentsType = ... # 0xc
    CT_ScrollBar             : QStyle.ContentsType = ... # 0xd
    CT_LineEdit              : QStyle.ContentsType = ... # 0xe
    CT_SpinBox               : QStyle.ContentsType = ... # 0xf
    CT_SizeGrip              : QStyle.ContentsType = ... # 0x10
    CT_TabWidget             : QStyle.ContentsType = ... # 0x11
    CT_DialogButtons         : QStyle.ContentsType = ... # 0x12
    CT_HeaderSection         : QStyle.ContentsType = ... # 0x13
    CT_GroupBox              : QStyle.ContentsType = ... # 0x14
    CT_MdiControls           : QStyle.ContentsType = ... # 0x15
    CT_ItemViewItem          : QStyle.ContentsType = ... # 0x16
    CT_CustomBase            : QStyle.ContentsType = ... # 0xf0000000
    CE_PushButton            : QStyle.ControlElement = ... # 0x0
    CE_PushButtonBevel       : QStyle.ControlElement = ... # 0x1
    CE_PushButtonLabel       : QStyle.ControlElement = ... # 0x2
    CE_CheckBox              : QStyle.ControlElement = ... # 0x3
    CE_CheckBoxLabel         : QStyle.ControlElement = ... # 0x4
    CE_RadioButton           : QStyle.ControlElement = ... # 0x5
    CE_RadioButtonLabel      : QStyle.ControlElement = ... # 0x6
    CE_TabBarTab             : QStyle.ControlElement = ... # 0x7
    CE_TabBarTabShape        : QStyle.ControlElement = ... # 0x8
    CE_TabBarTabLabel        : QStyle.ControlElement = ... # 0x9
    CE_ProgressBar           : QStyle.ControlElement = ... # 0xa
    CE_ProgressBarGroove     : QStyle.ControlElement = ... # 0xb
    CE_ProgressBarContents   : QStyle.ControlElement = ... # 0xc
    CE_ProgressBarLabel      : QStyle.ControlElement = ... # 0xd
    CE_MenuItem              : QStyle.ControlElement = ... # 0xe
    CE_MenuScroller          : QStyle.ControlElement = ... # 0xf
    CE_MenuVMargin           : QStyle.ControlElement = ... # 0x10
    CE_MenuHMargin           : QStyle.ControlElement = ... # 0x11
    CE_MenuTearoff           : QStyle.ControlElement = ... # 0x12
    CE_MenuEmptyArea         : QStyle.ControlElement = ... # 0x13
    CE_MenuBarItem           : QStyle.ControlElement = ... # 0x14
    CE_MenuBarEmptyArea      : QStyle.ControlElement = ... # 0x15
    CE_ToolButtonLabel       : QStyle.ControlElement = ... # 0x16
    CE_Header                : QStyle.ControlElement = ... # 0x17
    CE_HeaderSection         : QStyle.ControlElement = ... # 0x18
    CE_HeaderLabel           : QStyle.ControlElement = ... # 0x19
    CE_ToolBoxTab            : QStyle.ControlElement = ... # 0x1a
    CE_SizeGrip              : QStyle.ControlElement = ... # 0x1b
    CE_Splitter              : QStyle.ControlElement = ... # 0x1c
    CE_RubberBand            : QStyle.ControlElement = ... # 0x1d
    CE_DockWidgetTitle       : QStyle.ControlElement = ... # 0x1e
    CE_ScrollBarAddLine      : QStyle.ControlElement = ... # 0x1f
    CE_ScrollBarSubLine      : QStyle.ControlElement = ... # 0x20
    CE_ScrollBarAddPage      : QStyle.ControlElement = ... # 0x21
    CE_ScrollBarSubPage      : QStyle.ControlElement = ... # 0x22
    CE_ScrollBarSlider       : QStyle.ControlElement = ... # 0x23
    CE_ScrollBarFirst        : QStyle.ControlElement = ... # 0x24
    CE_ScrollBarLast         : QStyle.ControlElement = ... # 0x25
    CE_FocusFrame            : QStyle.ControlElement = ... # 0x26
    CE_ComboBoxLabel         : QStyle.ControlElement = ... # 0x27
    CE_ToolBar               : QStyle.ControlElement = ... # 0x28
    CE_ToolBoxTabShape       : QStyle.ControlElement = ... # 0x29
    CE_ToolBoxTabLabel       : QStyle.ControlElement = ... # 0x2a
    CE_HeaderEmptyArea       : QStyle.ControlElement = ... # 0x2b
    CE_ColumnViewGrip        : QStyle.ControlElement = ... # 0x2c
    CE_ItemViewItem          : QStyle.ControlElement = ... # 0x2d
    CE_ShapedFrame           : QStyle.ControlElement = ... # 0x2e
    CE_CustomBase            : QStyle.ControlElement = ... # 0xf0000000
    PM_ButtonMargin          : QStyle.PixelMetric = ... # 0x0
    PM_ButtonDefaultIndicator: QStyle.PixelMetric = ... # 0x1
    PM_MenuButtonIndicator   : QStyle.PixelMetric = ... # 0x2
    PM_ButtonShiftHorizontal : QStyle.PixelMetric = ... # 0x3
    PM_ButtonShiftVertical   : QStyle.PixelMetric = ... # 0x4
    PM_DefaultFrameWidth     : QStyle.PixelMetric = ... # 0x5
    PM_SpinBoxFrameWidth     : QStyle.PixelMetric = ... # 0x6
    PM_ComboBoxFrameWidth    : QStyle.PixelMetric = ... # 0x7
    PM_MaximumDragDistance   : QStyle.PixelMetric = ... # 0x8
    PM_ScrollBarExtent       : QStyle.PixelMetric = ... # 0x9
    PM_ScrollBarSliderMin    : QStyle.PixelMetric = ... # 0xa
    PM_SliderThickness       : QStyle.PixelMetric = ... # 0xb
    PM_SliderControlThickness: QStyle.PixelMetric = ... # 0xc
    PM_SliderLength          : QStyle.PixelMetric = ... # 0xd
    PM_SliderTickmarkOffset  : QStyle.PixelMetric = ... # 0xe
    PM_SliderSpaceAvailable  : QStyle.PixelMetric = ... # 0xf
    PM_DockWidgetSeparatorExtent: QStyle.PixelMetric = ... # 0x10
    PM_DockWidgetHandleExtent: QStyle.PixelMetric = ... # 0x11
    PM_DockWidgetFrameWidth  : QStyle.PixelMetric = ... # 0x12
    PM_TabBarTabOverlap      : QStyle.PixelMetric = ... # 0x13
    PM_TabBarTabHSpace       : QStyle.PixelMetric = ... # 0x14
    PM_TabBarTabVSpace       : QStyle.PixelMetric = ... # 0x15
    PM_TabBarBaseHeight      : QStyle.PixelMetric = ... # 0x16
    PM_TabBarBaseOverlap     : QStyle.PixelMetric = ... # 0x17
    PM_ProgressBarChunkWidth : QStyle.PixelMetric = ... # 0x18
    PM_SplitterWidth         : QStyle.PixelMetric = ... # 0x19
    PM_TitleBarHeight        : QStyle.PixelMetric = ... # 0x1a
    PM_MenuScrollerHeight    : QStyle.PixelMetric = ... # 0x1b
    PM_MenuHMargin           : QStyle.PixelMetric = ... # 0x1c
    PM_MenuVMargin           : QStyle.PixelMetric = ... # 0x1d
    PM_MenuPanelWidth        : QStyle.PixelMetric = ... # 0x1e
    PM_MenuTearoffHeight     : QStyle.PixelMetric = ... # 0x1f
    PM_MenuDesktopFrameWidth : QStyle.PixelMetric = ... # 0x20
    PM_MenuBarPanelWidth     : QStyle.PixelMetric = ... # 0x21
    PM_MenuBarItemSpacing    : QStyle.PixelMetric = ... # 0x22
    PM_MenuBarVMargin        : QStyle.PixelMetric = ... # 0x23
    PM_MenuBarHMargin        : QStyle.PixelMetric = ... # 0x24
    PM_IndicatorWidth        : QStyle.PixelMetric = ... # 0x25
    PM_IndicatorHeight       : QStyle.PixelMetric = ... # 0x26
    PM_ExclusiveIndicatorWidth: QStyle.PixelMetric = ... # 0x27
    PM_ExclusiveIndicatorHeight: QStyle.PixelMetric = ... # 0x28
    PM_DialogButtonsSeparator: QStyle.PixelMetric = ... # 0x29
    PM_DialogButtonsButtonWidth: QStyle.PixelMetric = ... # 0x2a
    PM_DialogButtonsButtonHeight: QStyle.PixelMetric = ... # 0x2b
    PM_MDIFrameWidth         : QStyle.PixelMetric = ... # 0x2c
    PM_MdiSubWindowFrameWidth: QStyle.PixelMetric = ... # 0x2c
    PM_MDIMinimizedWidth     : QStyle.PixelMetric = ... # 0x2d
    PM_MdiSubWindowMinimizedWidth: QStyle.PixelMetric = ... # 0x2d
    PM_HeaderMargin          : QStyle.PixelMetric = ... # 0x2e
    PM_HeaderMarkSize        : QStyle.PixelMetric = ... # 0x2f
    PM_HeaderGripMargin      : QStyle.PixelMetric = ... # 0x30
    PM_TabBarTabShiftHorizontal: QStyle.PixelMetric = ... # 0x31
    PM_TabBarTabShiftVertical: QStyle.PixelMetric = ... # 0x32
    PM_TabBarScrollButtonWidth: QStyle.PixelMetric = ... # 0x33
    PM_ToolBarFrameWidth     : QStyle.PixelMetric = ... # 0x34
    PM_ToolBarHandleExtent   : QStyle.PixelMetric = ... # 0x35
    PM_ToolBarItemSpacing    : QStyle.PixelMetric = ... # 0x36
    PM_ToolBarItemMargin     : QStyle.PixelMetric = ... # 0x37
    PM_ToolBarSeparatorExtent: QStyle.PixelMetric = ... # 0x38
    PM_ToolBarExtensionExtent: QStyle.PixelMetric = ... # 0x39
    PM_SpinBoxSliderHeight   : QStyle.PixelMetric = ... # 0x3a
    PM_DefaultTopLevelMargin : QStyle.PixelMetric = ... # 0x3b
    PM_DefaultChildMargin    : QStyle.PixelMetric = ... # 0x3c
    PM_DefaultLayoutSpacing  : QStyle.PixelMetric = ... # 0x3d
    PM_ToolBarIconSize       : QStyle.PixelMetric = ... # 0x3e
    PM_ListViewIconSize      : QStyle.PixelMetric = ... # 0x3f
    PM_IconViewIconSize      : QStyle.PixelMetric = ... # 0x40
    PM_SmallIconSize         : QStyle.PixelMetric = ... # 0x41
    PM_LargeIconSize         : QStyle.PixelMetric = ... # 0x42
    PM_FocusFrameVMargin     : QStyle.PixelMetric = ... # 0x43
    PM_FocusFrameHMargin     : QStyle.PixelMetric = ... # 0x44
    PM_ToolTipLabelFrameWidth: QStyle.PixelMetric = ... # 0x45
    PM_CheckBoxLabelSpacing  : QStyle.PixelMetric = ... # 0x46
    PM_TabBarIconSize        : QStyle.PixelMetric = ... # 0x47
    PM_SizeGripSize          : QStyle.PixelMetric = ... # 0x48
    PM_DockWidgetTitleMargin : QStyle.PixelMetric = ... # 0x49
    PM_MessageBoxIconSize    : QStyle.PixelMetric = ... # 0x4a
    PM_ButtonIconSize        : QStyle.PixelMetric = ... # 0x4b
    PM_DockWidgetTitleBarButtonMargin: QStyle.PixelMetric = ... # 0x4c
    PM_RadioButtonLabelSpacing: QStyle.PixelMetric = ... # 0x4d
    PM_LayoutLeftMargin      : QStyle.PixelMetric = ... # 0x4e
    PM_LayoutTopMargin       : QStyle.PixelMetric = ... # 0x4f
    PM_LayoutRightMargin     : QStyle.PixelMetric = ... # 0x50
    PM_LayoutBottomMargin    : QStyle.PixelMetric = ... # 0x51
    PM_LayoutHorizontalSpacing: QStyle.PixelMetric = ... # 0x52
    PM_LayoutVerticalSpacing : QStyle.PixelMetric = ... # 0x53
    PM_TabBar_ScrollButtonOverlap: QStyle.PixelMetric = ... # 0x54
    PM_TextCursorWidth       : QStyle.PixelMetric = ... # 0x55
    PM_TabCloseIndicatorWidth: QStyle.PixelMetric = ... # 0x56
    PM_TabCloseIndicatorHeight: QStyle.PixelMetric = ... # 0x57
    PM_ScrollView_ScrollBarSpacing: QStyle.PixelMetric = ... # 0x58
    PM_ScrollView_ScrollBarOverlap: QStyle.PixelMetric = ... # 0x59
    PM_SubMenuOverlap        : QStyle.PixelMetric = ... # 0x5a
    PM_TreeViewIndentation   : QStyle.PixelMetric = ... # 0x5b
    PM_HeaderDefaultSectionSizeHorizontal: QStyle.PixelMetric = ... # 0x5c
    PM_HeaderDefaultSectionSizeVertical: QStyle.PixelMetric = ... # 0x5d
    PM_TitleBarButtonIconSize: QStyle.PixelMetric = ... # 0x5e
    PM_TitleBarButtonSize    : QStyle.PixelMetric = ... # 0x5f
    PM_CustomBase            : QStyle.PixelMetric = ... # 0xf0000000
    PE_Frame                 : QStyle.PrimitiveElement = ... # 0x0
    PE_FrameDefaultButton    : QStyle.PrimitiveElement = ... # 0x1
    PE_FrameDockWidget       : QStyle.PrimitiveElement = ... # 0x2
    PE_FrameFocusRect        : QStyle.PrimitiveElement = ... # 0x3
    PE_FrameGroupBox         : QStyle.PrimitiveElement = ... # 0x4
    PE_FrameLineEdit         : QStyle.PrimitiveElement = ... # 0x5
    PE_FrameMenu             : QStyle.PrimitiveElement = ... # 0x6
    PE_FrameStatusBar        : QStyle.PrimitiveElement = ... # 0x7
    PE_FrameStatusBarItem    : QStyle.PrimitiveElement = ... # 0x7
    PE_FrameTabWidget        : QStyle.PrimitiveElement = ... # 0x8
    PE_FrameWindow           : QStyle.PrimitiveElement = ... # 0x9
    PE_FrameButtonBevel      : QStyle.PrimitiveElement = ... # 0xa
    PE_FrameButtonTool       : QStyle.PrimitiveElement = ... # 0xb
    PE_FrameTabBarBase       : QStyle.PrimitiveElement = ... # 0xc
    PE_PanelButtonCommand    : QStyle.PrimitiveElement = ... # 0xd
    PE_PanelButtonBevel      : QStyle.PrimitiveElement = ... # 0xe
    PE_PanelButtonTool       : QStyle.PrimitiveElement = ... # 0xf
    PE_PanelMenuBar          : QStyle.PrimitiveElement = ... # 0x10
    PE_PanelToolBar          : QStyle.PrimitiveElement = ... # 0x11
    PE_PanelLineEdit         : QStyle.PrimitiveElement = ... # 0x12
    PE_IndicatorArrowDown    : QStyle.PrimitiveElement = ... # 0x13
    PE_IndicatorArrowLeft    : QStyle.PrimitiveElement = ... # 0x14
    PE_IndicatorArrowRight   : QStyle.PrimitiveElement = ... # 0x15
    PE_IndicatorArrowUp      : QStyle.PrimitiveElement = ... # 0x16
    PE_IndicatorBranch       : QStyle.PrimitiveElement = ... # 0x17
    PE_IndicatorButtonDropDown: QStyle.PrimitiveElement = ... # 0x18
    PE_IndicatorItemViewItemCheck: QStyle.PrimitiveElement = ... # 0x19
    PE_IndicatorViewItemCheck: QStyle.PrimitiveElement = ... # 0x19
    PE_IndicatorCheckBox     : QStyle.PrimitiveElement = ... # 0x1a
    PE_IndicatorDockWidgetResizeHandle: QStyle.PrimitiveElement = ... # 0x1b
    PE_IndicatorHeaderArrow  : QStyle.PrimitiveElement = ... # 0x1c
    PE_IndicatorMenuCheckMark: QStyle.PrimitiveElement = ... # 0x1d
    PE_IndicatorProgressChunk: QStyle.PrimitiveElement = ... # 0x1e
    PE_IndicatorRadioButton  : QStyle.PrimitiveElement = ... # 0x1f
    PE_IndicatorSpinDown     : QStyle.PrimitiveElement = ... # 0x20
    PE_IndicatorSpinMinus    : QStyle.PrimitiveElement = ... # 0x21
    PE_IndicatorSpinPlus     : QStyle.PrimitiveElement = ... # 0x22
    PE_IndicatorSpinUp       : QStyle.PrimitiveElement = ... # 0x23
    PE_IndicatorToolBarHandle: QStyle.PrimitiveElement = ... # 0x24
    PE_IndicatorToolBarSeparator: QStyle.PrimitiveElement = ... # 0x25
    PE_PanelTipLabel         : QStyle.PrimitiveElement = ... # 0x26
    PE_IndicatorTabTear      : QStyle.PrimitiveElement = ... # 0x27
    PE_IndicatorTabTearLeft  : QStyle.PrimitiveElement = ... # 0x27
    PE_PanelScrollAreaCorner : QStyle.PrimitiveElement = ... # 0x28
    PE_Widget                : QStyle.PrimitiveElement = ... # 0x29
    PE_IndicatorColumnViewArrow: QStyle.PrimitiveElement = ... # 0x2a
    PE_IndicatorItemViewItemDrop: QStyle.PrimitiveElement = ... # 0x2b
    PE_PanelItemViewItem     : QStyle.PrimitiveElement = ... # 0x2c
    PE_PanelItemViewRow      : QStyle.PrimitiveElement = ... # 0x2d
    PE_PanelStatusBar        : QStyle.PrimitiveElement = ... # 0x2e
    PE_IndicatorTabClose     : QStyle.PrimitiveElement = ... # 0x2f
    PE_PanelMenu             : QStyle.PrimitiveElement = ... # 0x30
    PE_IndicatorTabTearRight : QStyle.PrimitiveElement = ... # 0x31
    PE_CustomBase            : QStyle.PrimitiveElement = ... # 0xf000000
    RSIP_OnMouseClickAndAlreadyFocused: QStyle.RequestSoftwareInputPanel = ... # 0x0
    RSIP_OnMouseClick        : QStyle.RequestSoftwareInputPanel = ... # 0x1
    SP_TitleBarMenuButton    : QStyle.StandardPixmap = ... # 0x0
    SP_TitleBarMinButton     : QStyle.StandardPixmap = ... # 0x1
    SP_TitleBarMaxButton     : QStyle.StandardPixmap = ... # 0x2
    SP_TitleBarCloseButton   : QStyle.StandardPixmap = ... # 0x3
    SP_TitleBarNormalButton  : QStyle.StandardPixmap = ... # 0x4
    SP_TitleBarShadeButton   : QStyle.StandardPixmap = ... # 0x5
    SP_TitleBarUnshadeButton : QStyle.StandardPixmap = ... # 0x6
    SP_TitleBarContextHelpButton: QStyle.StandardPixmap = ... # 0x7
    SP_DockWidgetCloseButton : QStyle.StandardPixmap = ... # 0x8
    SP_MessageBoxInformation : QStyle.StandardPixmap = ... # 0x9
    SP_MessageBoxWarning     : QStyle.StandardPixmap = ... # 0xa
    SP_MessageBoxCritical    : QStyle.StandardPixmap = ... # 0xb
    SP_MessageBoxQuestion    : QStyle.StandardPixmap = ... # 0xc
    SP_DesktopIcon           : QStyle.StandardPixmap = ... # 0xd
    SP_TrashIcon             : QStyle.StandardPixmap = ... # 0xe
    SP_ComputerIcon          : QStyle.StandardPixmap = ... # 0xf
    SP_DriveFDIcon           : QStyle.StandardPixmap = ... # 0x10
    SP_DriveHDIcon           : QStyle.StandardPixmap = ... # 0x11
    SP_DriveCDIcon           : QStyle.StandardPixmap = ... # 0x12
    SP_DriveDVDIcon          : QStyle.StandardPixmap = ... # 0x13
    SP_DriveNetIcon          : QStyle.StandardPixmap = ... # 0x14
    SP_DirOpenIcon           : QStyle.StandardPixmap = ... # 0x15
    SP_DirClosedIcon         : QStyle.StandardPixmap = ... # 0x16
    SP_DirLinkIcon           : QStyle.StandardPixmap = ... # 0x17
    SP_DirLinkOpenIcon       : QStyle.StandardPixmap = ... # 0x18
    SP_FileIcon              : QStyle.StandardPixmap = ... # 0x19
    SP_FileLinkIcon          : QStyle.StandardPixmap = ... # 0x1a
    SP_ToolBarHorizontalExtensionButton: QStyle.StandardPixmap = ... # 0x1b
    SP_ToolBarVerticalExtensionButton: QStyle.StandardPixmap = ... # 0x1c
    SP_FileDialogStart       : QStyle.StandardPixmap = ... # 0x1d
    SP_FileDialogEnd         : QStyle.StandardPixmap = ... # 0x1e
    SP_FileDialogToParent    : QStyle.StandardPixmap = ... # 0x1f
    SP_FileDialogNewFolder   : QStyle.StandardPixmap = ... # 0x20
    SP_FileDialogDetailedView: QStyle.StandardPixmap = ... # 0x21
    SP_FileDialogInfoView    : QStyle.StandardPixmap = ... # 0x22
    SP_FileDialogContentsView: QStyle.StandardPixmap = ... # 0x23
    SP_FileDialogListView    : QStyle.StandardPixmap = ... # 0x24
    SP_FileDialogBack        : QStyle.StandardPixmap = ... # 0x25
    SP_DirIcon               : QStyle.StandardPixmap = ... # 0x26
    SP_DialogOkButton        : QStyle.StandardPixmap = ... # 0x27
    SP_DialogCancelButton    : QStyle.StandardPixmap = ... # 0x28
    SP_DialogHelpButton      : QStyle.StandardPixmap = ... # 0x29
    SP_DialogOpenButton      : QStyle.StandardPixmap = ... # 0x2a
    SP_DialogSaveButton      : QStyle.StandardPixmap = ... # 0x2b
    SP_DialogCloseButton     : QStyle.StandardPixmap = ... # 0x2c
    SP_DialogApplyButton     : QStyle.StandardPixmap = ... # 0x2d
    SP_DialogResetButton     : QStyle.StandardPixmap = ... # 0x2e
    SP_DialogDiscardButton   : QStyle.StandardPixmap = ... # 0x2f
    SP_DialogYesButton       : QStyle.StandardPixmap = ... # 0x30
    SP_DialogNoButton        : QStyle.StandardPixmap = ... # 0x31
    SP_ArrowUp               : QStyle.StandardPixmap = ... # 0x32
    SP_ArrowDown             : QStyle.StandardPixmap = ... # 0x33
    SP_ArrowLeft             : QStyle.StandardPixmap = ... # 0x34
    SP_ArrowRight            : QStyle.StandardPixmap = ... # 0x35
    SP_ArrowBack             : QStyle.StandardPixmap = ... # 0x36
    SP_ArrowForward          : QStyle.StandardPixmap = ... # 0x37
    SP_DirHomeIcon           : QStyle.StandardPixmap = ... # 0x38
    SP_CommandLink           : QStyle.StandardPixmap = ... # 0x39
    SP_VistaShield           : QStyle.StandardPixmap = ... # 0x3a
    SP_BrowserReload         : QStyle.StandardPixmap = ... # 0x3b
    SP_BrowserStop           : QStyle.StandardPixmap = ... # 0x3c
    SP_MediaPlay             : QStyle.StandardPixmap = ... # 0x3d
    SP_MediaStop             : QStyle.StandardPixmap = ... # 0x3e
    SP_MediaPause            : QStyle.StandardPixmap = ... # 0x3f
    SP_MediaSkipForward      : QStyle.StandardPixmap = ... # 0x40
    SP_MediaSkipBackward     : QStyle.StandardPixmap = ... # 0x41
    SP_MediaSeekForward      : QStyle.StandardPixmap = ... # 0x42
    SP_MediaSeekBackward     : QStyle.StandardPixmap = ... # 0x43
    SP_MediaVolume           : QStyle.StandardPixmap = ... # 0x44
    SP_MediaVolumeMuted      : QStyle.StandardPixmap = ... # 0x45
    SP_LineEditClearButton   : QStyle.StandardPixmap = ... # 0x46
    SP_DialogYesToAllButton  : QStyle.StandardPixmap = ... # 0x47
    SP_DialogNoToAllButton   : QStyle.StandardPixmap = ... # 0x48
    SP_DialogSaveAllButton   : QStyle.StandardPixmap = ... # 0x49
    SP_DialogAbortButton     : QStyle.StandardPixmap = ... # 0x4a
    SP_DialogRetryButton     : QStyle.StandardPixmap = ... # 0x4b
    SP_DialogIgnoreButton    : QStyle.StandardPixmap = ... # 0x4c
    SP_RestoreDefaultsButton : QStyle.StandardPixmap = ... # 0x4d
    SP_CustomBase            : QStyle.StandardPixmap = ... # 0xf0000000
    State_None               : QStyle.StateFlag = ... # 0x0
    State_Enabled            : QStyle.StateFlag = ... # 0x1
    State_Raised             : QStyle.StateFlag = ... # 0x2
    State_Sunken             : QStyle.StateFlag = ... # 0x4
    State_Off                : QStyle.StateFlag = ... # 0x8
    State_NoChange           : QStyle.StateFlag = ... # 0x10
    State_On                 : QStyle.StateFlag = ... # 0x20
    State_DownArrow          : QStyle.StateFlag = ... # 0x40
    State_Horizontal         : QStyle.StateFlag = ... # 0x80
    State_HasFocus           : QStyle.StateFlag = ... # 0x100
    State_Top                : QStyle.StateFlag = ... # 0x200
    State_Bottom             : QStyle.StateFlag = ... # 0x400
    State_FocusAtBorder      : QStyle.StateFlag = ... # 0x800
    State_AutoRaise          : QStyle.StateFlag = ... # 0x1000
    State_MouseOver          : QStyle.StateFlag = ... # 0x2000
    State_UpArrow            : QStyle.StateFlag = ... # 0x4000
    State_Selected           : QStyle.StateFlag = ... # 0x8000
    State_Active             : QStyle.StateFlag = ... # 0x10000
    State_Window             : QStyle.StateFlag = ... # 0x20000
    State_Open               : QStyle.StateFlag = ... # 0x40000
    State_Children           : QStyle.StateFlag = ... # 0x80000
    State_Item               : QStyle.StateFlag = ... # 0x100000
    State_Sibling            : QStyle.StateFlag = ... # 0x200000
    State_Editing            : QStyle.StateFlag = ... # 0x400000
    State_KeyboardFocusChange: QStyle.StateFlag = ... # 0x800000
    State_ReadOnly           : QStyle.StateFlag = ... # 0x2000000
    State_Small              : QStyle.StateFlag = ... # 0x4000000
    State_Mini               : QStyle.StateFlag = ... # 0x8000000
    SH_EtchDisabledText      : QStyle.StyleHint = ... # 0x0
    SH_DitherDisabledText    : QStyle.StyleHint = ... # 0x1
    SH_ScrollBar_MiddleClickAbsolutePosition: QStyle.StyleHint = ... # 0x2
    SH_ScrollBar_ScrollWhenPointerLeavesControl: QStyle.StyleHint = ... # 0x3
    SH_TabBar_SelectMouseType: QStyle.StyleHint = ... # 0x4
    SH_TabBar_Alignment      : QStyle.StyleHint = ... # 0x5
    SH_Header_ArrowAlignment : QStyle.StyleHint = ... # 0x6
    SH_Slider_SnapToValue    : QStyle.StyleHint = ... # 0x7
    SH_Slider_SloppyKeyEvents: QStyle.StyleHint = ... # 0x8
    SH_ProgressDialog_CenterCancelButton: QStyle.StyleHint = ... # 0x9
    SH_ProgressDialog_TextLabelAlignment: QStyle.StyleHint = ... # 0xa
    SH_PrintDialog_RightAlignButtons: QStyle.StyleHint = ... # 0xb
    SH_MainWindow_SpaceBelowMenuBar: QStyle.StyleHint = ... # 0xc
    SH_FontDialog_SelectAssociatedText: QStyle.StyleHint = ... # 0xd
    SH_Menu_AllowActiveAndDisabled: QStyle.StyleHint = ... # 0xe
    SH_Menu_SpaceActivatesItem: QStyle.StyleHint = ... # 0xf
    SH_Menu_SubMenuPopupDelay: QStyle.StyleHint = ... # 0x10
    SH_ScrollView_FrameOnlyAroundContents: QStyle.StyleHint = ... # 0x11
    SH_MenuBar_AltKeyNavigation: QStyle.StyleHint = ... # 0x12
    SH_ComboBox_ListMouseTracking: QStyle.StyleHint = ... # 0x13
    SH_Menu_MouseTracking    : QStyle.StyleHint = ... # 0x14
    SH_MenuBar_MouseTracking : QStyle.StyleHint = ... # 0x15
    SH_ItemView_ChangeHighlightOnFocus: QStyle.StyleHint = ... # 0x16
    SH_Widget_ShareActivation: QStyle.StyleHint = ... # 0x17
    SH_Workspace_FillSpaceOnMaximize: QStyle.StyleHint = ... # 0x18
    SH_ComboBox_Popup        : QStyle.StyleHint = ... # 0x19
    SH_TitleBar_NoBorder     : QStyle.StyleHint = ... # 0x1a
    SH_ScrollBar_StopMouseOverSlider: QStyle.StyleHint = ... # 0x1b
    SH_Slider_StopMouseOverSlider: QStyle.StyleHint = ... # 0x1b
    SH_BlinkCursorWhenTextSelected: QStyle.StyleHint = ... # 0x1c
    SH_RichText_FullWidthSelection: QStyle.StyleHint = ... # 0x1d
    SH_Menu_Scrollable       : QStyle.StyleHint = ... # 0x1e
    SH_GroupBox_TextLabelVerticalAlignment: QStyle.StyleHint = ... # 0x1f
    SH_GroupBox_TextLabelColor: QStyle.StyleHint = ... # 0x20
    SH_Menu_SloppySubMenus   : QStyle.StyleHint = ... # 0x21
    SH_Table_GridLineColor   : QStyle.StyleHint = ... # 0x22
    SH_LineEdit_PasswordCharacter: QStyle.StyleHint = ... # 0x23
    SH_DialogButtons_DefaultButton: QStyle.StyleHint = ... # 0x24
    SH_ToolBox_SelectedPageTitleBold: QStyle.StyleHint = ... # 0x25
    SH_TabBar_PreferNoArrows : QStyle.StyleHint = ... # 0x26
    SH_ScrollBar_LeftClickAbsolutePosition: QStyle.StyleHint = ... # 0x27
    SH_ListViewExpand_SelectMouseType: QStyle.StyleHint = ... # 0x28
    SH_UnderlineShortcut     : QStyle.StyleHint = ... # 0x29
    SH_SpinBox_AnimateButton : QStyle.StyleHint = ... # 0x2a
    SH_SpinBox_KeyPressAutoRepeatRate: QStyle.StyleHint = ... # 0x2b
    SH_SpinBox_ClickAutoRepeatRate: QStyle.StyleHint = ... # 0x2c
    SH_Menu_FillScreenWithScroll: QStyle.StyleHint = ... # 0x2d
    SH_ToolTipLabel_Opacity  : QStyle.StyleHint = ... # 0x2e
    SH_DrawMenuBarSeparator  : QStyle.StyleHint = ... # 0x2f
    SH_TitleBar_ModifyNotification: QStyle.StyleHint = ... # 0x30
    SH_Button_FocusPolicy    : QStyle.StyleHint = ... # 0x31
    SH_MessageBox_UseBorderForButtonSpacing: QStyle.StyleHint = ... # 0x32
    SH_TitleBar_AutoRaise    : QStyle.StyleHint = ... # 0x33
    SH_ToolButton_PopupDelay : QStyle.StyleHint = ... # 0x34
    SH_FocusFrame_Mask       : QStyle.StyleHint = ... # 0x35
    SH_RubberBand_Mask       : QStyle.StyleHint = ... # 0x36
    SH_WindowFrame_Mask      : QStyle.StyleHint = ... # 0x37
    SH_SpinControls_DisableOnBounds: QStyle.StyleHint = ... # 0x38
    SH_Dial_BackgroundRole   : QStyle.StyleHint = ... # 0x39
    SH_ComboBox_LayoutDirection: QStyle.StyleHint = ... # 0x3a
    SH_ItemView_EllipsisLocation: QStyle.StyleHint = ... # 0x3b
    SH_ItemView_ShowDecorationSelected: QStyle.StyleHint = ... # 0x3c
    SH_ItemView_ActivateItemOnSingleClick: QStyle.StyleHint = ... # 0x3d
    SH_ScrollBar_ContextMenu : QStyle.StyleHint = ... # 0x3e
    SH_ScrollBar_RollBetweenButtons: QStyle.StyleHint = ... # 0x3f
    SH_Slider_AbsoluteSetButtons: QStyle.StyleHint = ... # 0x40
    SH_Slider_PageSetButtons : QStyle.StyleHint = ... # 0x41
    SH_Menu_KeyboardSearch   : QStyle.StyleHint = ... # 0x42
    SH_TabBar_ElideMode      : QStyle.StyleHint = ... # 0x43
    SH_DialogButtonLayout    : QStyle.StyleHint = ... # 0x44
    SH_ComboBox_PopupFrameStyle: QStyle.StyleHint = ... # 0x45
    SH_MessageBox_TextInteractionFlags: QStyle.StyleHint = ... # 0x46
    SH_DialogButtonBox_ButtonsHaveIcons: QStyle.StyleHint = ... # 0x47
    SH_SpellCheckUnderlineStyle: QStyle.StyleHint = ... # 0x48
    SH_MessageBox_CenterButtons: QStyle.StyleHint = ... # 0x49
    SH_Menu_SelectionWrap    : QStyle.StyleHint = ... # 0x4a
    SH_ItemView_MovementWithoutUpdatingSelection: QStyle.StyleHint = ... # 0x4b
    SH_ToolTip_Mask          : QStyle.StyleHint = ... # 0x4c
    SH_FocusFrame_AboveWidget: QStyle.StyleHint = ... # 0x4d
    SH_TextControl_FocusIndicatorTextCharFormat: QStyle.StyleHint = ... # 0x4e
    SH_WizardStyle           : QStyle.StyleHint = ... # 0x4f
    SH_ItemView_ArrowKeysNavigateIntoChildren: QStyle.StyleHint = ... # 0x50
    SH_Menu_Mask             : QStyle.StyleHint = ... # 0x51
    SH_Menu_FlashTriggeredItem: QStyle.StyleHint = ... # 0x52
    SH_Menu_FadeOutOnHide    : QStyle.StyleHint = ... # 0x53
    SH_SpinBox_ClickAutoRepeatThreshold: QStyle.StyleHint = ... # 0x54
    SH_ItemView_PaintAlternatingRowColorsForEmptyArea: QStyle.StyleHint = ... # 0x55
    SH_FormLayoutWrapPolicy  : QStyle.StyleHint = ... # 0x56
    SH_TabWidget_DefaultTabPosition: QStyle.StyleHint = ... # 0x57
    SH_ToolBar_Movable       : QStyle.StyleHint = ... # 0x58
    SH_FormLayoutFieldGrowthPolicy: QStyle.StyleHint = ... # 0x59
    SH_FormLayoutFormAlignment: QStyle.StyleHint = ... # 0x5a
    SH_FormLayoutLabelAlignment: QStyle.StyleHint = ... # 0x5b
    SH_ItemView_DrawDelegateFrame: QStyle.StyleHint = ... # 0x5c
    SH_TabBar_CloseButtonPosition: QStyle.StyleHint = ... # 0x5d
    SH_DockWidget_ButtonsHaveFrame: QStyle.StyleHint = ... # 0x5e
    SH_ToolButtonStyle       : QStyle.StyleHint = ... # 0x5f
    SH_RequestSoftwareInputPanel: QStyle.StyleHint = ... # 0x60
    SH_ScrollBar_Transient   : QStyle.StyleHint = ... # 0x61
    SH_Menu_SupportsSections : QStyle.StyleHint = ... # 0x62
    SH_ToolTip_WakeUpDelay   : QStyle.StyleHint = ... # 0x63
    SH_ToolTip_FallAsleepDelay: QStyle.StyleHint = ... # 0x64
    SH_Widget_Animate        : QStyle.StyleHint = ... # 0x65
    SH_Splitter_OpaqueResize : QStyle.StyleHint = ... # 0x66
    SH_ComboBox_UseNativePopup: QStyle.StyleHint = ... # 0x67
    SH_LineEdit_PasswordMaskDelay: QStyle.StyleHint = ... # 0x68
    SH_TabBar_ChangeCurrentDelay: QStyle.StyleHint = ... # 0x69
    SH_Menu_SubMenuUniDirection: QStyle.StyleHint = ... # 0x6a
    SH_Menu_SubMenuUniDirectionFailCount: QStyle.StyleHint = ... # 0x6b
    SH_Menu_SubMenuSloppySelectOtherActions: QStyle.StyleHint = ... # 0x6c
    SH_Menu_SubMenuSloppyCloseTimeout: QStyle.StyleHint = ... # 0x6d
    SH_Menu_SubMenuResetWhenReenteringParent: QStyle.StyleHint = ... # 0x6e
    SH_Menu_SubMenuDontStartSloppyOnLeave: QStyle.StyleHint = ... # 0x6f
    SH_ItemView_ScrollMode   : QStyle.StyleHint = ... # 0x70
    SH_TitleBar_ShowToolTipsOnButtons: QStyle.StyleHint = ... # 0x71
    SH_Widget_Animation_Duration: QStyle.StyleHint = ... # 0x72
    SH_ComboBox_AllowWheelScrolling: QStyle.StyleHint = ... # 0x73
    SH_SpinBox_ButtonsInsideFrame: QStyle.StyleHint = ... # 0x74
    SH_SpinBox_StepModifier  : QStyle.StyleHint = ... # 0x75
    SH_CustomBase            : QStyle.StyleHint = ... # 0xf0000000
    SC_None                  : QStyle.SubControl = ... # 0x0
    SC_ComboBoxFrame         : QStyle.SubControl = ... # 0x1
    SC_DialGroove            : QStyle.SubControl = ... # 0x1
    SC_GroupBoxCheckBox      : QStyle.SubControl = ... # 0x1
    SC_MdiMinButton          : QStyle.SubControl = ... # 0x1
    SC_ScrollBarAddLine      : QStyle.SubControl = ... # 0x1
    SC_SliderGroove          : QStyle.SubControl = ... # 0x1
    SC_SpinBoxUp             : QStyle.SubControl = ... # 0x1
    SC_TitleBarSysMenu       : QStyle.SubControl = ... # 0x1
    SC_ToolButton            : QStyle.SubControl = ... # 0x1
    SC_ComboBoxEditField     : QStyle.SubControl = ... # 0x2
    SC_DialHandle            : QStyle.SubControl = ... # 0x2
    SC_GroupBoxLabel         : QStyle.SubControl = ... # 0x2
    SC_MdiNormalButton       : QStyle.SubControl = ... # 0x2
    SC_ScrollBarSubLine      : QStyle.SubControl = ... # 0x2
    SC_SliderHandle          : QStyle.SubControl = ... # 0x2
    SC_SpinBoxDown           : QStyle.SubControl = ... # 0x2
    SC_TitleBarMinButton     : QStyle.SubControl = ... # 0x2
    SC_ToolButtonMenu        : QStyle.SubControl = ... # 0x2
    SC_ComboBoxArrow         : QStyle.SubControl = ... # 0x4
    SC_DialTickmarks         : QStyle.SubControl = ... # 0x4
    SC_GroupBoxContents      : QStyle.SubControl = ... # 0x4
    SC_MdiCloseButton        : QStyle.SubControl = ... # 0x4
    SC_ScrollBarAddPage      : QStyle.SubControl = ... # 0x4
    SC_SliderTickmarks       : QStyle.SubControl = ... # 0x4
    SC_SpinBoxFrame          : QStyle.SubControl = ... # 0x4
    SC_TitleBarMaxButton     : QStyle.SubControl = ... # 0x4
    SC_ComboBoxListBoxPopup  : QStyle.SubControl = ... # 0x8
    SC_GroupBoxFrame         : QStyle.SubControl = ... # 0x8
    SC_ScrollBarSubPage      : QStyle.SubControl = ... # 0x8
    SC_SpinBoxEditField      : QStyle.SubControl = ... # 0x8
    SC_TitleBarCloseButton   : QStyle.SubControl = ... # 0x8
    SC_ScrollBarFirst        : QStyle.SubControl = ... # 0x10
    SC_TitleBarNormalButton  : QStyle.SubControl = ... # 0x10
    SC_ScrollBarLast         : QStyle.SubControl = ... # 0x20
    SC_TitleBarShadeButton   : QStyle.SubControl = ... # 0x20
    SC_ScrollBarSlider       : QStyle.SubControl = ... # 0x40
    SC_TitleBarUnshadeButton : QStyle.SubControl = ... # 0x40
    SC_ScrollBarGroove       : QStyle.SubControl = ... # 0x80
    SC_TitleBarContextHelpButton: QStyle.SubControl = ... # 0x80
    SC_TitleBarLabel         : QStyle.SubControl = ... # 0x100
    SC_CustomBase            : QStyle.SubControl = ... # -0x10000000
    SC_All                   : QStyle.SubControl = ... # -0x1
    SE_PushButtonContents    : QStyle.SubElement = ... # 0x0
    SE_PushButtonFocusRect   : QStyle.SubElement = ... # 0x1
    SE_CheckBoxIndicator     : QStyle.SubElement = ... # 0x2
    SE_CheckBoxContents      : QStyle.SubElement = ... # 0x3
    SE_CheckBoxFocusRect     : QStyle.SubElement = ... # 0x4
    SE_CheckBoxClickRect     : QStyle.SubElement = ... # 0x5
    SE_RadioButtonIndicator  : QStyle.SubElement = ... # 0x6
    SE_RadioButtonContents   : QStyle.SubElement = ... # 0x7
    SE_RadioButtonFocusRect  : QStyle.SubElement = ... # 0x8
    SE_RadioButtonClickRect  : QStyle.SubElement = ... # 0x9
    SE_ComboBoxFocusRect     : QStyle.SubElement = ... # 0xa
    SE_SliderFocusRect       : QStyle.SubElement = ... # 0xb
    SE_ProgressBarGroove     : QStyle.SubElement = ... # 0xc
    SE_ProgressBarContents   : QStyle.SubElement = ... # 0xd
    SE_ProgressBarLabel      : QStyle.SubElement = ... # 0xe
    SE_ToolBoxTabContents    : QStyle.SubElement = ... # 0xf
    SE_HeaderLabel           : QStyle.SubElement = ... # 0x10
    SE_HeaderArrow           : QStyle.SubElement = ... # 0x11
    SE_TabWidgetTabBar       : QStyle.SubElement = ... # 0x12
    SE_TabWidgetTabPane      : QStyle.SubElement = ... # 0x13
    SE_TabWidgetTabContents  : QStyle.SubElement = ... # 0x14
    SE_TabWidgetLeftCorner   : QStyle.SubElement = ... # 0x15
    SE_TabWidgetRightCorner  : QStyle.SubElement = ... # 0x16
    SE_ItemViewItemCheckIndicator: QStyle.SubElement = ... # 0x17
    SE_ViewItemCheckIndicator: QStyle.SubElement = ... # 0x17
    SE_TabBarTearIndicator   : QStyle.SubElement = ... # 0x18
    SE_TabBarTearIndicatorLeft: QStyle.SubElement = ... # 0x18
    SE_TreeViewDisclosureItem: QStyle.SubElement = ... # 0x19
    SE_LineEditContents      : QStyle.SubElement = ... # 0x1a
    SE_FrameContents         : QStyle.SubElement = ... # 0x1b
    SE_DockWidgetCloseButton : QStyle.SubElement = ... # 0x1c
    SE_DockWidgetFloatButton : QStyle.SubElement = ... # 0x1d
    SE_DockWidgetTitleBarText: QStyle.SubElement = ... # 0x1e
    SE_DockWidgetIcon        : QStyle.SubElement = ... # 0x1f
    SE_CheckBoxLayoutItem    : QStyle.SubElement = ... # 0x20
    SE_ComboBoxLayoutItem    : QStyle.SubElement = ... # 0x21
    SE_DateTimeEditLayoutItem: QStyle.SubElement = ... # 0x22
    SE_DialogButtonBoxLayoutItem: QStyle.SubElement = ... # 0x23
    SE_LabelLayoutItem       : QStyle.SubElement = ... # 0x24
    SE_ProgressBarLayoutItem : QStyle.SubElement = ... # 0x25
    SE_PushButtonLayoutItem  : QStyle.SubElement = ... # 0x26
    SE_RadioButtonLayoutItem : QStyle.SubElement = ... # 0x27
    SE_SliderLayoutItem      : QStyle.SubElement = ... # 0x28
    SE_SpinBoxLayoutItem     : QStyle.SubElement = ... # 0x29
    SE_ToolButtonLayoutItem  : QStyle.SubElement = ... # 0x2a
    SE_FrameLayoutItem       : QStyle.SubElement = ... # 0x2b
    SE_GroupBoxLayoutItem    : QStyle.SubElement = ... # 0x2c
    SE_TabWidgetLayoutItem   : QStyle.SubElement = ... # 0x2d
    SE_ItemViewItemDecoration: QStyle.SubElement = ... # 0x2e
    SE_ItemViewItemText      : QStyle.SubElement = ... # 0x2f
    SE_ItemViewItemFocusRect : QStyle.SubElement = ... # 0x30
    SE_TabBarTabLeftButton   : QStyle.SubElement = ... # 0x31
    SE_TabBarTabRightButton  : QStyle.SubElement = ... # 0x32
    SE_TabBarTabText         : QStyle.SubElement = ... # 0x33
    SE_ShapedFrameContents   : QStyle.SubElement = ... # 0x34
    SE_ToolBarHandle         : QStyle.SubElement = ... # 0x35
    SE_TabBarScrollLeftButton: QStyle.SubElement = ... # 0x36
    SE_TabBarScrollRightButton: QStyle.SubElement = ... # 0x37
    SE_TabBarTearIndicatorRight: QStyle.SubElement = ... # 0x38
    SE_PushButtonBevel       : QStyle.SubElement = ... # 0x39
    SE_CustomBase            : QStyle.SubElement = ... # 0xf0000000

    class ComplexControl(Shiboken.Enum):
        CC_SpinBox               : QStyle.ComplexControl = ... # 0x0
        CC_ComboBox              : QStyle.ComplexControl = ... # 0x1
        CC_ScrollBar             : QStyle.ComplexControl = ... # 0x2
        CC_Slider                : QStyle.ComplexControl = ... # 0x3
        CC_ToolButton            : QStyle.ComplexControl = ... # 0x4
        CC_TitleBar              : QStyle.ComplexControl = ... # 0x5
        CC_Dial                  : QStyle.ComplexControl = ... # 0x6
        CC_GroupBox              : QStyle.ComplexControl = ... # 0x7
        CC_MdiControls           : QStyle.ComplexControl = ... # 0x8
        CC_CustomBase            : QStyle.ComplexControl = ... # 0xf0000000

    class ContentsType(Shiboken.Enum):
        CT_PushButton            : QStyle.ContentsType = ... # 0x0
        CT_CheckBox              : QStyle.ContentsType = ... # 0x1
        CT_RadioButton           : QStyle.ContentsType = ... # 0x2
        CT_ToolButton            : QStyle.ContentsType = ... # 0x3
        CT_ComboBox              : QStyle.ContentsType = ... # 0x4
        CT_Splitter              : QStyle.ContentsType = ... # 0x5
        CT_ProgressBar           : QStyle.ContentsType = ... # 0x6
        CT_MenuItem              : QStyle.ContentsType = ... # 0x7
        CT_MenuBarItem           : QStyle.ContentsType = ... # 0x8
        CT_MenuBar               : QStyle.ContentsType = ... # 0x9
        CT_Menu                  : QStyle.ContentsType = ... # 0xa
        CT_TabBarTab             : QStyle.ContentsType = ... # 0xb
        CT_Slider                : QStyle.ContentsType = ... # 0xc
        CT_ScrollBar             : QStyle.ContentsType = ... # 0xd
        CT_LineEdit              : QStyle.ContentsType = ... # 0xe
        CT_SpinBox               : QStyle.ContentsType = ... # 0xf
        CT_SizeGrip              : QStyle.ContentsType = ... # 0x10
        CT_TabWidget             : QStyle.ContentsType = ... # 0x11
        CT_DialogButtons         : QStyle.ContentsType = ... # 0x12
        CT_HeaderSection         : QStyle.ContentsType = ... # 0x13
        CT_GroupBox              : QStyle.ContentsType = ... # 0x14
        CT_MdiControls           : QStyle.ContentsType = ... # 0x15
        CT_ItemViewItem          : QStyle.ContentsType = ... # 0x16
        CT_CustomBase            : QStyle.ContentsType = ... # 0xf0000000

    class ControlElement(Shiboken.Enum):
        CE_PushButton            : QStyle.ControlElement = ... # 0x0
        CE_PushButtonBevel       : QStyle.ControlElement = ... # 0x1
        CE_PushButtonLabel       : QStyle.ControlElement = ... # 0x2
        CE_CheckBox              : QStyle.ControlElement = ... # 0x3
        CE_CheckBoxLabel         : QStyle.ControlElement = ... # 0x4
        CE_RadioButton           : QStyle.ControlElement = ... # 0x5
        CE_RadioButtonLabel      : QStyle.ControlElement = ... # 0x6
        CE_TabBarTab             : QStyle.ControlElement = ... # 0x7
        CE_TabBarTabShape        : QStyle.ControlElement = ... # 0x8
        CE_TabBarTabLabel        : QStyle.ControlElement = ... # 0x9
        CE_ProgressBar           : QStyle.ControlElement = ... # 0xa
        CE_ProgressBarGroove     : QStyle.ControlElement = ... # 0xb
        CE_ProgressBarContents   : QStyle.ControlElement = ... # 0xc
        CE_ProgressBarLabel      : QStyle.ControlElement = ... # 0xd
        CE_MenuItem              : QStyle.ControlElement = ... # 0xe
        CE_MenuScroller          : QStyle.ControlElement = ... # 0xf
        CE_MenuVMargin           : QStyle.ControlElement = ... # 0x10
        CE_MenuHMargin           : QStyle.ControlElement = ... # 0x11
        CE_MenuTearoff           : QStyle.ControlElement = ... # 0x12
        CE_MenuEmptyArea         : QStyle.ControlElement = ... # 0x13
        CE_MenuBarItem           : QStyle.ControlElement = ... # 0x14
        CE_MenuBarEmptyArea      : QStyle.ControlElement = ... # 0x15
        CE_ToolButtonLabel       : QStyle.ControlElement = ... # 0x16
        CE_Header                : QStyle.ControlElement = ... # 0x17
        CE_HeaderSection         : QStyle.ControlElement = ... # 0x18
        CE_HeaderLabel           : QStyle.ControlElement = ... # 0x19
        CE_ToolBoxTab            : QStyle.ControlElement = ... # 0x1a
        CE_SizeGrip              : QStyle.ControlElement = ... # 0x1b
        CE_Splitter              : QStyle.ControlElement = ... # 0x1c
        CE_RubberBand            : QStyle.ControlElement = ... # 0x1d
        CE_DockWidgetTitle       : QStyle.ControlElement = ... # 0x1e
        CE_ScrollBarAddLine      : QStyle.ControlElement = ... # 0x1f
        CE_ScrollBarSubLine      : QStyle.ControlElement = ... # 0x20
        CE_ScrollBarAddPage      : QStyle.ControlElement = ... # 0x21
        CE_ScrollBarSubPage      : QStyle.ControlElement = ... # 0x22
        CE_ScrollBarSlider       : QStyle.ControlElement = ... # 0x23
        CE_ScrollBarFirst        : QStyle.ControlElement = ... # 0x24
        CE_ScrollBarLast         : QStyle.ControlElement = ... # 0x25
        CE_FocusFrame            : QStyle.ControlElement = ... # 0x26
        CE_ComboBoxLabel         : QStyle.ControlElement = ... # 0x27
        CE_ToolBar               : QStyle.ControlElement = ... # 0x28
        CE_ToolBoxTabShape       : QStyle.ControlElement = ... # 0x29
        CE_ToolBoxTabLabel       : QStyle.ControlElement = ... # 0x2a
        CE_HeaderEmptyArea       : QStyle.ControlElement = ... # 0x2b
        CE_ColumnViewGrip        : QStyle.ControlElement = ... # 0x2c
        CE_ItemViewItem          : QStyle.ControlElement = ... # 0x2d
        CE_ShapedFrame           : QStyle.ControlElement = ... # 0x2e
        CE_CustomBase            : QStyle.ControlElement = ... # 0xf0000000

    class PixelMetric(Shiboken.Enum):
        PM_ButtonMargin          : QStyle.PixelMetric = ... # 0x0
        PM_ButtonDefaultIndicator: QStyle.PixelMetric = ... # 0x1
        PM_MenuButtonIndicator   : QStyle.PixelMetric = ... # 0x2
        PM_ButtonShiftHorizontal : QStyle.PixelMetric = ... # 0x3
        PM_ButtonShiftVertical   : QStyle.PixelMetric = ... # 0x4
        PM_DefaultFrameWidth     : QStyle.PixelMetric = ... # 0x5
        PM_SpinBoxFrameWidth     : QStyle.PixelMetric = ... # 0x6
        PM_ComboBoxFrameWidth    : QStyle.PixelMetric = ... # 0x7
        PM_MaximumDragDistance   : QStyle.PixelMetric = ... # 0x8
        PM_ScrollBarExtent       : QStyle.PixelMetric = ... # 0x9
        PM_ScrollBarSliderMin    : QStyle.PixelMetric = ... # 0xa
        PM_SliderThickness       : QStyle.PixelMetric = ... # 0xb
        PM_SliderControlThickness: QStyle.PixelMetric = ... # 0xc
        PM_SliderLength          : QStyle.PixelMetric = ... # 0xd
        PM_SliderTickmarkOffset  : QStyle.PixelMetric = ... # 0xe
        PM_SliderSpaceAvailable  : QStyle.PixelMetric = ... # 0xf
        PM_DockWidgetSeparatorExtent: QStyle.PixelMetric = ... # 0x10
        PM_DockWidgetHandleExtent: QStyle.PixelMetric = ... # 0x11
        PM_DockWidgetFrameWidth  : QStyle.PixelMetric = ... # 0x12
        PM_TabBarTabOverlap      : QStyle.PixelMetric = ... # 0x13
        PM_TabBarTabHSpace       : QStyle.PixelMetric = ... # 0x14
        PM_TabBarTabVSpace       : QStyle.PixelMetric = ... # 0x15
        PM_TabBarBaseHeight      : QStyle.PixelMetric = ... # 0x16
        PM_TabBarBaseOverlap     : QStyle.PixelMetric = ... # 0x17
        PM_ProgressBarChunkWidth : QStyle.PixelMetric = ... # 0x18
        PM_SplitterWidth         : QStyle.PixelMetric = ... # 0x19
        PM_TitleBarHeight        : QStyle.PixelMetric = ... # 0x1a
        PM_MenuScrollerHeight    : QStyle.PixelMetric = ... # 0x1b
        PM_MenuHMargin           : QStyle.PixelMetric = ... # 0x1c
        PM_MenuVMargin           : QStyle.PixelMetric = ... # 0x1d
        PM_MenuPanelWidth        : QStyle.PixelMetric = ... # 0x1e
        PM_MenuTearoffHeight     : QStyle.PixelMetric = ... # 0x1f
        PM_MenuDesktopFrameWidth : QStyle.PixelMetric = ... # 0x20
        PM_MenuBarPanelWidth     : QStyle.PixelMetric = ... # 0x21
        PM_MenuBarItemSpacing    : QStyle.PixelMetric = ... # 0x22
        PM_MenuBarVMargin        : QStyle.PixelMetric = ... # 0x23
        PM_MenuBarHMargin        : QStyle.PixelMetric = ... # 0x24
        PM_IndicatorWidth        : QStyle.PixelMetric = ... # 0x25
        PM_IndicatorHeight       : QStyle.PixelMetric = ... # 0x26
        PM_ExclusiveIndicatorWidth: QStyle.PixelMetric = ... # 0x27
        PM_ExclusiveIndicatorHeight: QStyle.PixelMetric = ... # 0x28
        PM_DialogButtonsSeparator: QStyle.PixelMetric = ... # 0x29
        PM_DialogButtonsButtonWidth: QStyle.PixelMetric = ... # 0x2a
        PM_DialogButtonsButtonHeight: QStyle.PixelMetric = ... # 0x2b
        PM_MDIFrameWidth         : QStyle.PixelMetric = ... # 0x2c
        PM_MdiSubWindowFrameWidth: QStyle.PixelMetric = ... # 0x2c
        PM_MDIMinimizedWidth     : QStyle.PixelMetric = ... # 0x2d
        PM_MdiSubWindowMinimizedWidth: QStyle.PixelMetric = ... # 0x2d
        PM_HeaderMargin          : QStyle.PixelMetric = ... # 0x2e
        PM_HeaderMarkSize        : QStyle.PixelMetric = ... # 0x2f
        PM_HeaderGripMargin      : QStyle.PixelMetric = ... # 0x30
        PM_TabBarTabShiftHorizontal: QStyle.PixelMetric = ... # 0x31
        PM_TabBarTabShiftVertical: QStyle.PixelMetric = ... # 0x32
        PM_TabBarScrollButtonWidth: QStyle.PixelMetric = ... # 0x33
        PM_ToolBarFrameWidth     : QStyle.PixelMetric = ... # 0x34
        PM_ToolBarHandleExtent   : QStyle.PixelMetric = ... # 0x35
        PM_ToolBarItemSpacing    : QStyle.PixelMetric = ... # 0x36
        PM_ToolBarItemMargin     : QStyle.PixelMetric = ... # 0x37
        PM_ToolBarSeparatorExtent: QStyle.PixelMetric = ... # 0x38
        PM_ToolBarExtensionExtent: QStyle.PixelMetric = ... # 0x39
        PM_SpinBoxSliderHeight   : QStyle.PixelMetric = ... # 0x3a
        PM_DefaultTopLevelMargin : QStyle.PixelMetric = ... # 0x3b
        PM_DefaultChildMargin    : QStyle.PixelMetric = ... # 0x3c
        PM_DefaultLayoutSpacing  : QStyle.PixelMetric = ... # 0x3d
        PM_ToolBarIconSize       : QStyle.PixelMetric = ... # 0x3e
        PM_ListViewIconSize      : QStyle.PixelMetric = ... # 0x3f
        PM_IconViewIconSize      : QStyle.PixelMetric = ... # 0x40
        PM_SmallIconSize         : QStyle.PixelMetric = ... # 0x41
        PM_LargeIconSize         : QStyle.PixelMetric = ... # 0x42
        PM_FocusFrameVMargin     : QStyle.PixelMetric = ... # 0x43
        PM_FocusFrameHMargin     : QStyle.PixelMetric = ... # 0x44
        PM_ToolTipLabelFrameWidth: QStyle.PixelMetric = ... # 0x45
        PM_CheckBoxLabelSpacing  : QStyle.PixelMetric = ... # 0x46
        PM_TabBarIconSize        : QStyle.PixelMetric = ... # 0x47
        PM_SizeGripSize          : QStyle.PixelMetric = ... # 0x48
        PM_DockWidgetTitleMargin : QStyle.PixelMetric = ... # 0x49
        PM_MessageBoxIconSize    : QStyle.PixelMetric = ... # 0x4a
        PM_ButtonIconSize        : QStyle.PixelMetric = ... # 0x4b
        PM_DockWidgetTitleBarButtonMargin: QStyle.PixelMetric = ... # 0x4c
        PM_RadioButtonLabelSpacing: QStyle.PixelMetric = ... # 0x4d
        PM_LayoutLeftMargin      : QStyle.PixelMetric = ... # 0x4e
        PM_LayoutTopMargin       : QStyle.PixelMetric = ... # 0x4f
        PM_LayoutRightMargin     : QStyle.PixelMetric = ... # 0x50
        PM_LayoutBottomMargin    : QStyle.PixelMetric = ... # 0x51
        PM_LayoutHorizontalSpacing: QStyle.PixelMetric = ... # 0x52
        PM_LayoutVerticalSpacing : QStyle.PixelMetric = ... # 0x53
        PM_TabBar_ScrollButtonOverlap: QStyle.PixelMetric = ... # 0x54
        PM_TextCursorWidth       : QStyle.PixelMetric = ... # 0x55
        PM_TabCloseIndicatorWidth: QStyle.PixelMetric = ... # 0x56
        PM_TabCloseIndicatorHeight: QStyle.PixelMetric = ... # 0x57
        PM_ScrollView_ScrollBarSpacing: QStyle.PixelMetric = ... # 0x58
        PM_ScrollView_ScrollBarOverlap: QStyle.PixelMetric = ... # 0x59
        PM_SubMenuOverlap        : QStyle.PixelMetric = ... # 0x5a
        PM_TreeViewIndentation   : QStyle.PixelMetric = ... # 0x5b
        PM_HeaderDefaultSectionSizeHorizontal: QStyle.PixelMetric = ... # 0x5c
        PM_HeaderDefaultSectionSizeVertical: QStyle.PixelMetric = ... # 0x5d
        PM_TitleBarButtonIconSize: QStyle.PixelMetric = ... # 0x5e
        PM_TitleBarButtonSize    : QStyle.PixelMetric = ... # 0x5f
        PM_CustomBase            : QStyle.PixelMetric = ... # 0xf0000000

    class PrimitiveElement(Shiboken.Enum):
        PE_Frame                 : QStyle.PrimitiveElement = ... # 0x0
        PE_FrameDefaultButton    : QStyle.PrimitiveElement = ... # 0x1
        PE_FrameDockWidget       : QStyle.PrimitiveElement = ... # 0x2
        PE_FrameFocusRect        : QStyle.PrimitiveElement = ... # 0x3
        PE_FrameGroupBox         : QStyle.PrimitiveElement = ... # 0x4
        PE_FrameLineEdit         : QStyle.PrimitiveElement = ... # 0x5
        PE_FrameMenu             : QStyle.PrimitiveElement = ... # 0x6
        PE_FrameStatusBar        : QStyle.PrimitiveElement = ... # 0x7
        PE_FrameStatusBarItem    : QStyle.PrimitiveElement = ... # 0x7
        PE_FrameTabWidget        : QStyle.PrimitiveElement = ... # 0x8
        PE_FrameWindow           : QStyle.PrimitiveElement = ... # 0x9
        PE_FrameButtonBevel      : QStyle.PrimitiveElement = ... # 0xa
        PE_FrameButtonTool       : QStyle.PrimitiveElement = ... # 0xb
        PE_FrameTabBarBase       : QStyle.PrimitiveElement = ... # 0xc
        PE_PanelButtonCommand    : QStyle.PrimitiveElement = ... # 0xd
        PE_PanelButtonBevel      : QStyle.PrimitiveElement = ... # 0xe
        PE_PanelButtonTool       : QStyle.PrimitiveElement = ... # 0xf
        PE_PanelMenuBar          : QStyle.PrimitiveElement = ... # 0x10
        PE_PanelToolBar          : QStyle.PrimitiveElement = ... # 0x11
        PE_PanelLineEdit         : QStyle.PrimitiveElement = ... # 0x12
        PE_IndicatorArrowDown    : QStyle.PrimitiveElement = ... # 0x13
        PE_IndicatorArrowLeft    : QStyle.PrimitiveElement = ... # 0x14
        PE_IndicatorArrowRight   : QStyle.PrimitiveElement = ... # 0x15
        PE_IndicatorArrowUp      : QStyle.PrimitiveElement = ... # 0x16
        PE_IndicatorBranch       : QStyle.PrimitiveElement = ... # 0x17
        PE_IndicatorButtonDropDown: QStyle.PrimitiveElement = ... # 0x18
        PE_IndicatorItemViewItemCheck: QStyle.PrimitiveElement = ... # 0x19
        PE_IndicatorViewItemCheck: QStyle.PrimitiveElement = ... # 0x19
        PE_IndicatorCheckBox     : QStyle.PrimitiveElement = ... # 0x1a
        PE_IndicatorDockWidgetResizeHandle: QStyle.PrimitiveElement = ... # 0x1b
        PE_IndicatorHeaderArrow  : QStyle.PrimitiveElement = ... # 0x1c
        PE_IndicatorMenuCheckMark: QStyle.PrimitiveElement = ... # 0x1d
        PE_IndicatorProgressChunk: QStyle.PrimitiveElement = ... # 0x1e
        PE_IndicatorRadioButton  : QStyle.PrimitiveElement = ... # 0x1f
        PE_IndicatorSpinDown     : QStyle.PrimitiveElement = ... # 0x20
        PE_IndicatorSpinMinus    : QStyle.PrimitiveElement = ... # 0x21
        PE_IndicatorSpinPlus     : QStyle.PrimitiveElement = ... # 0x22
        PE_IndicatorSpinUp       : QStyle.PrimitiveElement = ... # 0x23
        PE_IndicatorToolBarHandle: QStyle.PrimitiveElement = ... # 0x24
        PE_IndicatorToolBarSeparator: QStyle.PrimitiveElement = ... # 0x25
        PE_PanelTipLabel         : QStyle.PrimitiveElement = ... # 0x26
        PE_IndicatorTabTear      : QStyle.PrimitiveElement = ... # 0x27
        PE_IndicatorTabTearLeft  : QStyle.PrimitiveElement = ... # 0x27
        PE_PanelScrollAreaCorner : QStyle.PrimitiveElement = ... # 0x28
        PE_Widget                : QStyle.PrimitiveElement = ... # 0x29
        PE_IndicatorColumnViewArrow: QStyle.PrimitiveElement = ... # 0x2a
        PE_IndicatorItemViewItemDrop: QStyle.PrimitiveElement = ... # 0x2b
        PE_PanelItemViewItem     : QStyle.PrimitiveElement = ... # 0x2c
        PE_PanelItemViewRow      : QStyle.PrimitiveElement = ... # 0x2d
        PE_PanelStatusBar        : QStyle.PrimitiveElement = ... # 0x2e
        PE_IndicatorTabClose     : QStyle.PrimitiveElement = ... # 0x2f
        PE_PanelMenu             : QStyle.PrimitiveElement = ... # 0x30
        PE_IndicatorTabTearRight : QStyle.PrimitiveElement = ... # 0x31
        PE_CustomBase            : QStyle.PrimitiveElement = ... # 0xf000000

    class RequestSoftwareInputPanel(Shiboken.Enum):
        RSIP_OnMouseClickAndAlreadyFocused: QStyle.RequestSoftwareInputPanel = ... # 0x0
        RSIP_OnMouseClick        : QStyle.RequestSoftwareInputPanel = ... # 0x1

    class StandardPixmap(Shiboken.Enum):
        SP_TitleBarMenuButton    : QStyle.StandardPixmap = ... # 0x0
        SP_TitleBarMinButton     : QStyle.StandardPixmap = ... # 0x1
        SP_TitleBarMaxButton     : QStyle.StandardPixmap = ... # 0x2
        SP_TitleBarCloseButton   : QStyle.StandardPixmap = ... # 0x3
        SP_TitleBarNormalButton  : QStyle.StandardPixmap = ... # 0x4
        SP_TitleBarShadeButton   : QStyle.StandardPixmap = ... # 0x5
        SP_TitleBarUnshadeButton : QStyle.StandardPixmap = ... # 0x6
        SP_TitleBarContextHelpButton: QStyle.StandardPixmap = ... # 0x7
        SP_DockWidgetCloseButton : QStyle.StandardPixmap = ... # 0x8
        SP_MessageBoxInformation : QStyle.StandardPixmap = ... # 0x9
        SP_MessageBoxWarning     : QStyle.StandardPixmap = ... # 0xa
        SP_MessageBoxCritical    : QStyle.StandardPixmap = ... # 0xb
        SP_MessageBoxQuestion    : QStyle.StandardPixmap = ... # 0xc
        SP_DesktopIcon           : QStyle.StandardPixmap = ... # 0xd
        SP_TrashIcon             : QStyle.StandardPixmap = ... # 0xe
        SP_ComputerIcon          : QStyle.StandardPixmap = ... # 0xf
        SP_DriveFDIcon           : QStyle.StandardPixmap = ... # 0x10
        SP_DriveHDIcon           : QStyle.StandardPixmap = ... # 0x11
        SP_DriveCDIcon           : QStyle.StandardPixmap = ... # 0x12
        SP_DriveDVDIcon          : QStyle.StandardPixmap = ... # 0x13
        SP_DriveNetIcon          : QStyle.StandardPixmap = ... # 0x14
        SP_DirOpenIcon           : QStyle.StandardPixmap = ... # 0x15
        SP_DirClosedIcon         : QStyle.StandardPixmap = ... # 0x16
        SP_DirLinkIcon           : QStyle.StandardPixmap = ... # 0x17
        SP_DirLinkOpenIcon       : QStyle.StandardPixmap = ... # 0x18
        SP_FileIcon              : QStyle.StandardPixmap = ... # 0x19
        SP_FileLinkIcon          : QStyle.StandardPixmap = ... # 0x1a
        SP_ToolBarHorizontalExtensionButton: QStyle.StandardPixmap = ... # 0x1b
        SP_ToolBarVerticalExtensionButton: QStyle.StandardPixmap = ... # 0x1c
        SP_FileDialogStart       : QStyle.StandardPixmap = ... # 0x1d
        SP_FileDialogEnd         : QStyle.StandardPixmap = ... # 0x1e
        SP_FileDialogToParent    : QStyle.StandardPixmap = ... # 0x1f
        SP_FileDialogNewFolder   : QStyle.StandardPixmap = ... # 0x20
        SP_FileDialogDetailedView: QStyle.StandardPixmap = ... # 0x21
        SP_FileDialogInfoView    : QStyle.StandardPixmap = ... # 0x22
        SP_FileDialogContentsView: QStyle.StandardPixmap = ... # 0x23
        SP_FileDialogListView    : QStyle.StandardPixmap = ... # 0x24
        SP_FileDialogBack        : QStyle.StandardPixmap = ... # 0x25
        SP_DirIcon               : QStyle.StandardPixmap = ... # 0x26
        SP_DialogOkButton        : QStyle.StandardPixmap = ... # 0x27
        SP_DialogCancelButton    : QStyle.StandardPixmap = ... # 0x28
        SP_DialogHelpButton      : QStyle.StandardPixmap = ... # 0x29
        SP_DialogOpenButton      : QStyle.StandardPixmap = ... # 0x2a
        SP_DialogSaveButton      : QStyle.StandardPixmap = ... # 0x2b
        SP_DialogCloseButton     : QStyle.StandardPixmap = ... # 0x2c
        SP_DialogApplyButton     : QStyle.StandardPixmap = ... # 0x2d
        SP_DialogResetButton     : QStyle.StandardPixmap = ... # 0x2e
        SP_DialogDiscardButton   : QStyle.StandardPixmap = ... # 0x2f
        SP_DialogYesButton       : QStyle.StandardPixmap = ... # 0x30
        SP_DialogNoButton        : QStyle.StandardPixmap = ... # 0x31
        SP_ArrowUp               : QStyle.StandardPixmap = ... # 0x32
        SP_ArrowDown             : QStyle.StandardPixmap = ... # 0x33
        SP_ArrowLeft             : QStyle.StandardPixmap = ... # 0x34
        SP_ArrowRight            : QStyle.StandardPixmap = ... # 0x35
        SP_ArrowBack             : QStyle.StandardPixmap = ... # 0x36
        SP_ArrowForward          : QStyle.StandardPixmap = ... # 0x37
        SP_DirHomeIcon           : QStyle.StandardPixmap = ... # 0x38
        SP_CommandLink           : QStyle.StandardPixmap = ... # 0x39
        SP_VistaShield           : QStyle.StandardPixmap = ... # 0x3a
        SP_BrowserReload         : QStyle.StandardPixmap = ... # 0x3b
        SP_BrowserStop           : QStyle.StandardPixmap = ... # 0x3c
        SP_MediaPlay             : QStyle.StandardPixmap = ... # 0x3d
        SP_MediaStop             : QStyle.StandardPixmap = ... # 0x3e
        SP_MediaPause            : QStyle.StandardPixmap = ... # 0x3f
        SP_MediaSkipForward      : QStyle.StandardPixmap = ... # 0x40
        SP_MediaSkipBackward     : QStyle.StandardPixmap = ... # 0x41
        SP_MediaSeekForward      : QStyle.StandardPixmap = ... # 0x42
        SP_MediaSeekBackward     : QStyle.StandardPixmap = ... # 0x43
        SP_MediaVolume           : QStyle.StandardPixmap = ... # 0x44
        SP_MediaVolumeMuted      : QStyle.StandardPixmap = ... # 0x45
        SP_LineEditClearButton   : QStyle.StandardPixmap = ... # 0x46
        SP_DialogYesToAllButton  : QStyle.StandardPixmap = ... # 0x47
        SP_DialogNoToAllButton   : QStyle.StandardPixmap = ... # 0x48
        SP_DialogSaveAllButton   : QStyle.StandardPixmap = ... # 0x49
        SP_DialogAbortButton     : QStyle.StandardPixmap = ... # 0x4a
        SP_DialogRetryButton     : QStyle.StandardPixmap = ... # 0x4b
        SP_DialogIgnoreButton    : QStyle.StandardPixmap = ... # 0x4c
        SP_RestoreDefaultsButton : QStyle.StandardPixmap = ... # 0x4d
        SP_CustomBase            : QStyle.StandardPixmap = ... # 0xf0000000

    class State(object): ...

    class StateFlag(Shiboken.Enum):
        State_None               : QStyle.StateFlag = ... # 0x0
        State_Enabled            : QStyle.StateFlag = ... # 0x1
        State_Raised             : QStyle.StateFlag = ... # 0x2
        State_Sunken             : QStyle.StateFlag = ... # 0x4
        State_Off                : QStyle.StateFlag = ... # 0x8
        State_NoChange           : QStyle.StateFlag = ... # 0x10
        State_On                 : QStyle.StateFlag = ... # 0x20
        State_DownArrow          : QStyle.StateFlag = ... # 0x40
        State_Horizontal         : QStyle.StateFlag = ... # 0x80
        State_HasFocus           : QStyle.StateFlag = ... # 0x100
        State_Top                : QStyle.StateFlag = ... # 0x200
        State_Bottom             : QStyle.StateFlag = ... # 0x400
        State_FocusAtBorder      : QStyle.StateFlag = ... # 0x800
        State_AutoRaise          : QStyle.StateFlag = ... # 0x1000
        State_MouseOver          : QStyle.StateFlag = ... # 0x2000
        State_UpArrow            : QStyle.StateFlag = ... # 0x4000
        State_Selected           : QStyle.StateFlag = ... # 0x8000
        State_Active             : QStyle.StateFlag = ... # 0x10000
        State_Window             : QStyle.StateFlag = ... # 0x20000
        State_Open               : QStyle.StateFlag = ... # 0x40000
        State_Children           : QStyle.StateFlag = ... # 0x80000
        State_Item               : QStyle.StateFlag = ... # 0x100000
        State_Sibling            : QStyle.StateFlag = ... # 0x200000
        State_Editing            : QStyle.StateFlag = ... # 0x400000
        State_KeyboardFocusChange: QStyle.StateFlag = ... # 0x800000
        State_ReadOnly           : QStyle.StateFlag = ... # 0x2000000
        State_Small              : QStyle.StateFlag = ... # 0x4000000
        State_Mini               : QStyle.StateFlag = ... # 0x8000000

    class StyleHint(Shiboken.Enum):
        SH_EtchDisabledText      : QStyle.StyleHint = ... # 0x0
        SH_DitherDisabledText    : QStyle.StyleHint = ... # 0x1
        SH_ScrollBar_MiddleClickAbsolutePosition: QStyle.StyleHint = ... # 0x2
        SH_ScrollBar_ScrollWhenPointerLeavesControl: QStyle.StyleHint = ... # 0x3
        SH_TabBar_SelectMouseType: QStyle.StyleHint = ... # 0x4
        SH_TabBar_Alignment      : QStyle.StyleHint = ... # 0x5
        SH_Header_ArrowAlignment : QStyle.StyleHint = ... # 0x6
        SH_Slider_SnapToValue    : QStyle.StyleHint = ... # 0x7
        SH_Slider_SloppyKeyEvents: QStyle.StyleHint = ... # 0x8
        SH_ProgressDialog_CenterCancelButton: QStyle.StyleHint = ... # 0x9
        SH_ProgressDialog_TextLabelAlignment: QStyle.StyleHint = ... # 0xa
        SH_PrintDialog_RightAlignButtons: QStyle.StyleHint = ... # 0xb
        SH_MainWindow_SpaceBelowMenuBar: QStyle.StyleHint = ... # 0xc
        SH_FontDialog_SelectAssociatedText: QStyle.StyleHint = ... # 0xd
        SH_Menu_AllowActiveAndDisabled: QStyle.StyleHint = ... # 0xe
        SH_Menu_SpaceActivatesItem: QStyle.StyleHint = ... # 0xf
        SH_Menu_SubMenuPopupDelay: QStyle.StyleHint = ... # 0x10
        SH_ScrollView_FrameOnlyAroundContents: QStyle.StyleHint = ... # 0x11
        SH_MenuBar_AltKeyNavigation: QStyle.StyleHint = ... # 0x12
        SH_ComboBox_ListMouseTracking: QStyle.StyleHint = ... # 0x13
        SH_Menu_MouseTracking    : QStyle.StyleHint = ... # 0x14
        SH_MenuBar_MouseTracking : QStyle.StyleHint = ... # 0x15
        SH_ItemView_ChangeHighlightOnFocus: QStyle.StyleHint = ... # 0x16
        SH_Widget_ShareActivation: QStyle.StyleHint = ... # 0x17
        SH_Workspace_FillSpaceOnMaximize: QStyle.StyleHint = ... # 0x18
        SH_ComboBox_Popup        : QStyle.StyleHint = ... # 0x19
        SH_TitleBar_NoBorder     : QStyle.StyleHint = ... # 0x1a
        SH_ScrollBar_StopMouseOverSlider: QStyle.StyleHint = ... # 0x1b
        SH_Slider_StopMouseOverSlider: QStyle.StyleHint = ... # 0x1b
        SH_BlinkCursorWhenTextSelected: QStyle.StyleHint = ... # 0x1c
        SH_RichText_FullWidthSelection: QStyle.StyleHint = ... # 0x1d
        SH_Menu_Scrollable       : QStyle.StyleHint = ... # 0x1e
        SH_GroupBox_TextLabelVerticalAlignment: QStyle.StyleHint = ... # 0x1f
        SH_GroupBox_TextLabelColor: QStyle.StyleHint = ... # 0x20
        SH_Menu_SloppySubMenus   : QStyle.StyleHint = ... # 0x21
        SH_Table_GridLineColor   : QStyle.StyleHint = ... # 0x22
        SH_LineEdit_PasswordCharacter: QStyle.StyleHint = ... # 0x23
        SH_DialogButtons_DefaultButton: QStyle.StyleHint = ... # 0x24
        SH_ToolBox_SelectedPageTitleBold: QStyle.StyleHint = ... # 0x25
        SH_TabBar_PreferNoArrows : QStyle.StyleHint = ... # 0x26
        SH_ScrollBar_LeftClickAbsolutePosition: QStyle.StyleHint = ... # 0x27
        SH_ListViewExpand_SelectMouseType: QStyle.StyleHint = ... # 0x28
        SH_UnderlineShortcut     : QStyle.StyleHint = ... # 0x29
        SH_SpinBox_AnimateButton : QStyle.StyleHint = ... # 0x2a
        SH_SpinBox_KeyPressAutoRepeatRate: QStyle.StyleHint = ... # 0x2b
        SH_SpinBox_ClickAutoRepeatRate: QStyle.StyleHint = ... # 0x2c
        SH_Menu_FillScreenWithScroll: QStyle.StyleHint = ... # 0x2d
        SH_ToolTipLabel_Opacity  : QStyle.StyleHint = ... # 0x2e
        SH_DrawMenuBarSeparator  : QStyle.StyleHint = ... # 0x2f
        SH_TitleBar_ModifyNotification: QStyle.StyleHint = ... # 0x30
        SH_Button_FocusPolicy    : QStyle.StyleHint = ... # 0x31
        SH_MessageBox_UseBorderForButtonSpacing: QStyle.StyleHint = ... # 0x32
        SH_TitleBar_AutoRaise    : QStyle.StyleHint = ... # 0x33
        SH_ToolButton_PopupDelay : QStyle.StyleHint = ... # 0x34
        SH_FocusFrame_Mask       : QStyle.StyleHint = ... # 0x35
        SH_RubberBand_Mask       : QStyle.StyleHint = ... # 0x36
        SH_WindowFrame_Mask      : QStyle.StyleHint = ... # 0x37
        SH_SpinControls_DisableOnBounds: QStyle.StyleHint = ... # 0x38
        SH_Dial_BackgroundRole   : QStyle.StyleHint = ... # 0x39
        SH_ComboBox_LayoutDirection: QStyle.StyleHint = ... # 0x3a
        SH_ItemView_EllipsisLocation: QStyle.StyleHint = ... # 0x3b
        SH_ItemView_ShowDecorationSelected: QStyle.StyleHint = ... # 0x3c
        SH_ItemView_ActivateItemOnSingleClick: QStyle.StyleHint = ... # 0x3d
        SH_ScrollBar_ContextMenu : QStyle.StyleHint = ... # 0x3e
        SH_ScrollBar_RollBetweenButtons: QStyle.StyleHint = ... # 0x3f
        SH_Slider_AbsoluteSetButtons: QStyle.StyleHint = ... # 0x40
        SH_Slider_PageSetButtons : QStyle.StyleHint = ... # 0x41
        SH_Menu_KeyboardSearch   : QStyle.StyleHint = ... # 0x42
        SH_TabBar_ElideMode      : QStyle.StyleHint = ... # 0x43
        SH_DialogButtonLayout    : QStyle.StyleHint = ... # 0x44
        SH_ComboBox_PopupFrameStyle: QStyle.StyleHint = ... # 0x45
        SH_MessageBox_TextInteractionFlags: QStyle.StyleHint = ... # 0x46
        SH_DialogButtonBox_ButtonsHaveIcons: QStyle.StyleHint = ... # 0x47
        SH_SpellCheckUnderlineStyle: QStyle.StyleHint = ... # 0x48
        SH_MessageBox_CenterButtons: QStyle.StyleHint = ... # 0x49
        SH_Menu_SelectionWrap    : QStyle.StyleHint = ... # 0x4a
        SH_ItemView_MovementWithoutUpdatingSelection: QStyle.StyleHint = ... # 0x4b
        SH_ToolTip_Mask          : QStyle.StyleHint = ... # 0x4c
        SH_FocusFrame_AboveWidget: QStyle.StyleHint = ... # 0x4d
        SH_TextControl_FocusIndicatorTextCharFormat: QStyle.StyleHint = ... # 0x4e
        SH_WizardStyle           : QStyle.StyleHint = ... # 0x4f
        SH_ItemView_ArrowKeysNavigateIntoChildren: QStyle.StyleHint = ... # 0x50
        SH_Menu_Mask             : QStyle.StyleHint = ... # 0x51
        SH_Menu_FlashTriggeredItem: QStyle.StyleHint = ... # 0x52
        SH_Menu_FadeOutOnHide    : QStyle.StyleHint = ... # 0x53
        SH_SpinBox_ClickAutoRepeatThreshold: QStyle.StyleHint = ... # 0x54
        SH_ItemView_PaintAlternatingRowColorsForEmptyArea: QStyle.StyleHint = ... # 0x55
        SH_FormLayoutWrapPolicy  : QStyle.StyleHint = ... # 0x56
        SH_TabWidget_DefaultTabPosition: QStyle.StyleHint = ... # 0x57
        SH_ToolBar_Movable       : QStyle.StyleHint = ... # 0x58
        SH_FormLayoutFieldGrowthPolicy: QStyle.StyleHint = ... # 0x59
        SH_FormLayoutFormAlignment: QStyle.StyleHint = ... # 0x5a
        SH_FormLayoutLabelAlignment: QStyle.StyleHint = ... # 0x5b
        SH_ItemView_DrawDelegateFrame: QStyle.StyleHint = ... # 0x5c
        SH_TabBar_CloseButtonPosition: QStyle.StyleHint = ... # 0x5d
        SH_DockWidget_ButtonsHaveFrame: QStyle.StyleHint = ... # 0x5e
        SH_ToolButtonStyle       : QStyle.StyleHint = ... # 0x5f
        SH_RequestSoftwareInputPanel: QStyle.StyleHint = ... # 0x60
        SH_ScrollBar_Transient   : QStyle.StyleHint = ... # 0x61
        SH_Menu_SupportsSections : QStyle.StyleHint = ... # 0x62
        SH_ToolTip_WakeUpDelay   : QStyle.StyleHint = ... # 0x63
        SH_ToolTip_FallAsleepDelay: QStyle.StyleHint = ... # 0x64
        SH_Widget_Animate        : QStyle.StyleHint = ... # 0x65
        SH_Splitter_OpaqueResize : QStyle.StyleHint = ... # 0x66
        SH_ComboBox_UseNativePopup: QStyle.StyleHint = ... # 0x67
        SH_LineEdit_PasswordMaskDelay: QStyle.StyleHint = ... # 0x68
        SH_TabBar_ChangeCurrentDelay: QStyle.StyleHint = ... # 0x69
        SH_Menu_SubMenuUniDirection: QStyle.StyleHint = ... # 0x6a
        SH_Menu_SubMenuUniDirectionFailCount: QStyle.StyleHint = ... # 0x6b
        SH_Menu_SubMenuSloppySelectOtherActions: QStyle.StyleHint = ... # 0x6c
        SH_Menu_SubMenuSloppyCloseTimeout: QStyle.StyleHint = ... # 0x6d
        SH_Menu_SubMenuResetWhenReenteringParent: QStyle.StyleHint = ... # 0x6e
        SH_Menu_SubMenuDontStartSloppyOnLeave: QStyle.StyleHint = ... # 0x6f
        SH_ItemView_ScrollMode   : QStyle.StyleHint = ... # 0x70
        SH_TitleBar_ShowToolTipsOnButtons: QStyle.StyleHint = ... # 0x71
        SH_Widget_Animation_Duration: QStyle.StyleHint = ... # 0x72
        SH_ComboBox_AllowWheelScrolling: QStyle.StyleHint = ... # 0x73
        SH_SpinBox_ButtonsInsideFrame: QStyle.StyleHint = ... # 0x74
        SH_SpinBox_StepModifier  : QStyle.StyleHint = ... # 0x75
        SH_CustomBase            : QStyle.StyleHint = ... # 0xf0000000

    class SubControl(Shiboken.Enum):
        SC_None                  : QStyle.SubControl = ... # 0x0
        SC_ComboBoxFrame         : QStyle.SubControl = ... # 0x1
        SC_DialGroove            : QStyle.SubControl = ... # 0x1
        SC_GroupBoxCheckBox      : QStyle.SubControl = ... # 0x1
        SC_MdiMinButton          : QStyle.SubControl = ... # 0x1
        SC_ScrollBarAddLine      : QStyle.SubControl = ... # 0x1
        SC_SliderGroove          : QStyle.SubControl = ... # 0x1
        SC_SpinBoxUp             : QStyle.SubControl = ... # 0x1
        SC_TitleBarSysMenu       : QStyle.SubControl = ... # 0x1
        SC_ToolButton            : QStyle.SubControl = ... # 0x1
        SC_ComboBoxEditField     : QStyle.SubControl = ... # 0x2
        SC_DialHandle            : QStyle.SubControl = ... # 0x2
        SC_GroupBoxLabel         : QStyle.SubControl = ... # 0x2
        SC_MdiNormalButton       : QStyle.SubControl = ... # 0x2
        SC_ScrollBarSubLine      : QStyle.SubControl = ... # 0x2
        SC_SliderHandle          : QStyle.SubControl = ... # 0x2
        SC_SpinBoxDown           : QStyle.SubControl = ... # 0x2
        SC_TitleBarMinButton     : QStyle.SubControl = ... # 0x2
        SC_ToolButtonMenu        : QStyle.SubControl = ... # 0x2
        SC_ComboBoxArrow         : QStyle.SubControl = ... # 0x4
        SC_DialTickmarks         : QStyle.SubControl = ... # 0x4
        SC_GroupBoxContents      : QStyle.SubControl = ... # 0x4
        SC_MdiCloseButton        : QStyle.SubControl = ... # 0x4
        SC_ScrollBarAddPage      : QStyle.SubControl = ... # 0x4
        SC_SliderTickmarks       : QStyle.SubControl = ... # 0x4
        SC_SpinBoxFrame          : QStyle.SubControl = ... # 0x4
        SC_TitleBarMaxButton     : QStyle.SubControl = ... # 0x4
        SC_ComboBoxListBoxPopup  : QStyle.SubControl = ... # 0x8
        SC_GroupBoxFrame         : QStyle.SubControl = ... # 0x8
        SC_ScrollBarSubPage      : QStyle.SubControl = ... # 0x8
        SC_SpinBoxEditField      : QStyle.SubControl = ... # 0x8
        SC_TitleBarCloseButton   : QStyle.SubControl = ... # 0x8
        SC_ScrollBarFirst        : QStyle.SubControl = ... # 0x10
        SC_TitleBarNormalButton  : QStyle.SubControl = ... # 0x10
        SC_ScrollBarLast         : QStyle.SubControl = ... # 0x20
        SC_TitleBarShadeButton   : QStyle.SubControl = ... # 0x20
        SC_ScrollBarSlider       : QStyle.SubControl = ... # 0x40
        SC_TitleBarUnshadeButton : QStyle.SubControl = ... # 0x40
        SC_ScrollBarGroove       : QStyle.SubControl = ... # 0x80
        SC_TitleBarContextHelpButton: QStyle.SubControl = ... # 0x80
        SC_TitleBarLabel         : QStyle.SubControl = ... # 0x100
        SC_CustomBase            : QStyle.SubControl = ... # -0x10000000
        SC_All                   : QStyle.SubControl = ... # -0x1

    class SubControls(object): ...

    class SubElement(Shiboken.Enum):
        SE_PushButtonContents    : QStyle.SubElement = ... # 0x0
        SE_PushButtonFocusRect   : QStyle.SubElement = ... # 0x1
        SE_CheckBoxIndicator     : QStyle.SubElement = ... # 0x2
        SE_CheckBoxContents      : QStyle.SubElement = ... # 0x3
        SE_CheckBoxFocusRect     : QStyle.SubElement = ... # 0x4
        SE_CheckBoxClickRect     : QStyle.SubElement = ... # 0x5
        SE_RadioButtonIndicator  : QStyle.SubElement = ... # 0x6
        SE_RadioButtonContents   : QStyle.SubElement = ... # 0x7
        SE_RadioButtonFocusRect  : QStyle.SubElement = ... # 0x8
        SE_RadioButtonClickRect  : QStyle.SubElement = ... # 0x9
        SE_ComboBoxFocusRect     : QStyle.SubElement = ... # 0xa
        SE_SliderFocusRect       : QStyle.SubElement = ... # 0xb
        SE_ProgressBarGroove     : QStyle.SubElement = ... # 0xc
        SE_ProgressBarContents   : QStyle.SubElement = ... # 0xd
        SE_ProgressBarLabel      : QStyle.SubElement = ... # 0xe
        SE_ToolBoxTabContents    : QStyle.SubElement = ... # 0xf
        SE_HeaderLabel           : QStyle.SubElement = ... # 0x10
        SE_HeaderArrow           : QStyle.SubElement = ... # 0x11
        SE_TabWidgetTabBar       : QStyle.SubElement = ... # 0x12
        SE_TabWidgetTabPane      : QStyle.SubElement = ... # 0x13
        SE_TabWidgetTabContents  : QStyle.SubElement = ... # 0x14
        SE_TabWidgetLeftCorner   : QStyle.SubElement = ... # 0x15
        SE_TabWidgetRightCorner  : QStyle.SubElement = ... # 0x16
        SE_ItemViewItemCheckIndicator: QStyle.SubElement = ... # 0x17
        SE_ViewItemCheckIndicator: QStyle.SubElement = ... # 0x17
        SE_TabBarTearIndicator   : QStyle.SubElement = ... # 0x18
        SE_TabBarTearIndicatorLeft: QStyle.SubElement = ... # 0x18
        SE_TreeViewDisclosureItem: QStyle.SubElement = ... # 0x19
        SE_LineEditContents      : QStyle.SubElement = ... # 0x1a
        SE_FrameContents         : QStyle.SubElement = ... # 0x1b
        SE_DockWidgetCloseButton : QStyle.SubElement = ... # 0x1c
        SE_DockWidgetFloatButton : QStyle.SubElement = ... # 0x1d
        SE_DockWidgetTitleBarText: QStyle.SubElement = ... # 0x1e
        SE_DockWidgetIcon        : QStyle.SubElement = ... # 0x1f
        SE_CheckBoxLayoutItem    : QStyle.SubElement = ... # 0x20
        SE_ComboBoxLayoutItem    : QStyle.SubElement = ... # 0x21
        SE_DateTimeEditLayoutItem: QStyle.SubElement = ... # 0x22
        SE_DialogButtonBoxLayoutItem: QStyle.SubElement = ... # 0x23
        SE_LabelLayoutItem       : QStyle.SubElement = ... # 0x24
        SE_ProgressBarLayoutItem : QStyle.SubElement = ... # 0x25
        SE_PushButtonLayoutItem  : QStyle.SubElement = ... # 0x26
        SE_RadioButtonLayoutItem : QStyle.SubElement = ... # 0x27
        SE_SliderLayoutItem      : QStyle.SubElement = ... # 0x28
        SE_SpinBoxLayoutItem     : QStyle.SubElement = ... # 0x29
        SE_ToolButtonLayoutItem  : QStyle.SubElement = ... # 0x2a
        SE_FrameLayoutItem       : QStyle.SubElement = ... # 0x2b
        SE_GroupBoxLayoutItem    : QStyle.SubElement = ... # 0x2c
        SE_TabWidgetLayoutItem   : QStyle.SubElement = ... # 0x2d
        SE_ItemViewItemDecoration: QStyle.SubElement = ... # 0x2e
        SE_ItemViewItemText      : QStyle.SubElement = ... # 0x2f
        SE_ItemViewItemFocusRect : QStyle.SubElement = ... # 0x30
        SE_TabBarTabLeftButton   : QStyle.SubElement = ... # 0x31
        SE_TabBarTabRightButton  : QStyle.SubElement = ... # 0x32
        SE_TabBarTabText         : QStyle.SubElement = ... # 0x33
        SE_ShapedFrameContents   : QStyle.SubElement = ... # 0x34
        SE_ToolBarHandle         : QStyle.SubElement = ... # 0x35
        SE_TabBarScrollLeftButton: QStyle.SubElement = ... # 0x36
        SE_TabBarScrollRightButton: QStyle.SubElement = ... # 0x37
        SE_TabBarTearIndicatorRight: QStyle.SubElement = ... # 0x38
        SE_PushButtonBevel       : QStyle.SubElement = ... # 0x39
        SE_CustomBase            : QStyle.SubElement = ... # 0xf0000000

    def __init__(self) -> None: ...

    @staticmethod
    def alignedRect(direction: PySide2.QtCore.Qt.LayoutDirection, alignment: PySide2.QtCore.Qt.Alignment, size: PySide2.QtCore.QSize, rectangle: PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...
    def combinedLayoutSpacing(self, controls1: PySide2.QtWidgets.QSizePolicy.ControlTypes, controls2: PySide2.QtWidgets.QSizePolicy.ControlTypes, orientation: PySide2.QtCore.Qt.Orientation, option: typing.Optional[PySide2.QtWidgets.QStyleOption] = ..., widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> int: ...
    def drawComplexControl(self, cc: PySide2.QtWidgets.QStyle.ComplexControl, opt: PySide2.QtWidgets.QStyleOptionComplex, p: PySide2.QtGui.QPainter, widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    def drawControl(self, element: PySide2.QtWidgets.QStyle.ControlElement, opt: PySide2.QtWidgets.QStyleOption, p: PySide2.QtGui.QPainter, widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    def drawItemPixmap(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRect, alignment: int, pixmap: PySide2.QtGui.QPixmap) -> None: ...
    def drawItemText(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRect, flags: int, pal: PySide2.QtGui.QPalette, enabled: bool, text: str, textRole: PySide2.QtGui.QPalette.ColorRole = ...) -> None: ...
    def drawPrimitive(self, pe: PySide2.QtWidgets.QStyle.PrimitiveElement, opt: PySide2.QtWidgets.QStyleOption, p: PySide2.QtGui.QPainter, widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    def generatedIconPixmap(self, iconMode: PySide2.QtGui.QIcon.Mode, pixmap: PySide2.QtGui.QPixmap, opt: PySide2.QtWidgets.QStyleOption) -> PySide2.QtGui.QPixmap: ...
    def hitTestComplexControl(self, cc: PySide2.QtWidgets.QStyle.ComplexControl, opt: PySide2.QtWidgets.QStyleOptionComplex, pt: PySide2.QtCore.QPoint, widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> PySide2.QtWidgets.QStyle.SubControl: ...
    def itemPixmapRect(self, r: PySide2.QtCore.QRect, flags: int, pixmap: PySide2.QtGui.QPixmap) -> PySide2.QtCore.QRect: ...
    def itemTextRect(self, fm: PySide2.QtGui.QFontMetrics, r: PySide2.QtCore.QRect, flags: int, enabled: bool, text: str) -> PySide2.QtCore.QRect: ...
    def layoutSpacing(self, control1: PySide2.QtWidgets.QSizePolicy.ControlType, control2: PySide2.QtWidgets.QSizePolicy.ControlType, orientation: PySide2.QtCore.Qt.Orientation, option: typing.Optional[PySide2.QtWidgets.QStyleOption] = ..., widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> int: ...
    def pixelMetric(self, metric: PySide2.QtWidgets.QStyle.PixelMetric, option: typing.Optional[PySide2.QtWidgets.QStyleOption] = ..., widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> int: ...
    @typing.overload
    def polish(self, application: PySide2.QtWidgets.QApplication) -> None: ...
    @typing.overload
    def polish(self, palette: PySide2.QtGui.QPalette) -> None: ...
    @typing.overload
    def polish(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def proxy(self) -> PySide2.QtWidgets.QStyle: ...
    def sizeFromContents(self, ct: PySide2.QtWidgets.QStyle.ContentsType, opt: PySide2.QtWidgets.QStyleOption, contentsSize: PySide2.QtCore.QSize, w: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> PySide2.QtCore.QSize: ...
    @staticmethod
    def sliderPositionFromValue(min: int, max: int, val: int, space: int, upsideDown: bool = ...) -> int: ...
    @staticmethod
    def sliderValueFromPosition(min: int, max: int, pos: int, space: int, upsideDown: bool = ...) -> int: ...
    def standardIcon(self, standardIcon: PySide2.QtWidgets.QStyle.StandardPixmap, option: typing.Optional[PySide2.QtWidgets.QStyleOption] = ..., widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> PySide2.QtGui.QIcon: ...
    def standardPalette(self) -> PySide2.QtGui.QPalette: ...
    def standardPixmap(self, standardPixmap: PySide2.QtWidgets.QStyle.StandardPixmap, opt: typing.Optional[PySide2.QtWidgets.QStyleOption] = ..., widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> PySide2.QtGui.QPixmap: ...
    def styleHint(self, stylehint: PySide2.QtWidgets.QStyle.StyleHint, opt: typing.Optional[PySide2.QtWidgets.QStyleOption] = ..., widget: typing.Optional[PySide2.QtWidgets.QWidget] = ..., returnData: typing.Optional[PySide2.QtWidgets.QStyleHintReturn] = ...) -> int: ...
    def subControlRect(self, cc: PySide2.QtWidgets.QStyle.ComplexControl, opt: PySide2.QtWidgets.QStyleOptionComplex, sc: PySide2.QtWidgets.QStyle.SubControl, widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> PySide2.QtCore.QRect: ...
    def subElementRect(self, subElement: PySide2.QtWidgets.QStyle.SubElement, option: PySide2.QtWidgets.QStyleOption, widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def unpolish(self, application: PySide2.QtWidgets.QApplication) -> None: ...
    @typing.overload
    def unpolish(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    @staticmethod
    def visualAlignment(direction: PySide2.QtCore.Qt.LayoutDirection, alignment: PySide2.QtCore.Qt.Alignment) -> PySide2.QtCore.Qt.Alignment: ...
    @staticmethod
    def visualPos(direction: PySide2.QtCore.Qt.LayoutDirection, boundingRect: PySide2.QtCore.QRect, logicalPos: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    @staticmethod
    def visualRect(direction: PySide2.QtCore.Qt.LayoutDirection, boundingRect: PySide2.QtCore.QRect, logicalRect: PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...


class QStyleFactory(Shiboken.Object):

    def __init__(self) -> None: ...

    @staticmethod
    def create(arg__1: str) -> PySide2.QtWidgets.QStyle: ...
    @staticmethod
    def keys() -> typing.List[str]: ...


class QStyleHintReturn(Shiboken.Object):
    SH_Default               : QStyleHintReturn.HintReturnType = ... # 0xf000
    SH_Mask                  : QStyleHintReturn.HintReturnType = ... # 0xf001
    SH_Variant               : QStyleHintReturn.HintReturnType = ... # 0xf002
    Type                     : QStyleHintReturn.StyleOptionType = ... # 0xf000
    Version                  : QStyleHintReturn.StyleOptionVersion = ... # 0x1

    class HintReturnType(Shiboken.Enum):
        SH_Default               : QStyleHintReturn.HintReturnType = ... # 0xf000
        SH_Mask                  : QStyleHintReturn.HintReturnType = ... # 0xf001
        SH_Variant               : QStyleHintReturn.HintReturnType = ... # 0xf002

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleHintReturn.StyleOptionType = ... # 0xf000

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleHintReturn.StyleOptionVersion = ... # 0x1

    def __init__(self, version: int = ..., type: int = ...) -> None: ...


class QStyleHintReturnMask(PySide2.QtWidgets.QStyleHintReturn):
    Type                     : QStyleHintReturnMask.StyleOptionType = ... # 0xf001
    Version                  : QStyleHintReturnMask.StyleOptionVersion = ... # 0x1

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleHintReturnMask.StyleOptionType = ... # 0xf001

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleHintReturnMask.StyleOptionVersion = ... # 0x1

    def __init__(self) -> None: ...


class QStyleHintReturnVariant(PySide2.QtWidgets.QStyleHintReturn):
    Type                     : QStyleHintReturnVariant.StyleOptionType = ... # 0xf002
    Version                  : QStyleHintReturnVariant.StyleOptionVersion = ... # 0x1

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleHintReturnVariant.StyleOptionType = ... # 0xf002

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleHintReturnVariant.StyleOptionVersion = ... # 0x1

    def __init__(self) -> None: ...


class QStyleOption(Shiboken.Object):
    SO_Default               : QStyleOption.OptionType = ... # 0x0
    SO_FocusRect             : QStyleOption.OptionType = ... # 0x1
    SO_Button                : QStyleOption.OptionType = ... # 0x2
    SO_Tab                   : QStyleOption.OptionType = ... # 0x3
    SO_MenuItem              : QStyleOption.OptionType = ... # 0x4
    SO_Frame                 : QStyleOption.OptionType = ... # 0x5
    SO_ProgressBar           : QStyleOption.OptionType = ... # 0x6
    SO_ToolBox               : QStyleOption.OptionType = ... # 0x7
    SO_Header                : QStyleOption.OptionType = ... # 0x8
    SO_DockWidget            : QStyleOption.OptionType = ... # 0x9
    SO_ViewItem              : QStyleOption.OptionType = ... # 0xa
    SO_TabWidgetFrame        : QStyleOption.OptionType = ... # 0xb
    SO_TabBarBase            : QStyleOption.OptionType = ... # 0xc
    SO_RubberBand            : QStyleOption.OptionType = ... # 0xd
    SO_ToolBar               : QStyleOption.OptionType = ... # 0xe
    SO_GraphicsItem          : QStyleOption.OptionType = ... # 0xf
    SO_CustomBase            : QStyleOption.OptionType = ... # 0xf00
    SO_Complex               : QStyleOption.OptionType = ... # 0xf0000
    SO_Slider                : QStyleOption.OptionType = ... # 0xf0001
    SO_SpinBox               : QStyleOption.OptionType = ... # 0xf0002
    SO_ToolButton            : QStyleOption.OptionType = ... # 0xf0003
    SO_ComboBox              : QStyleOption.OptionType = ... # 0xf0004
    SO_TitleBar              : QStyleOption.OptionType = ... # 0xf0005
    SO_GroupBox              : QStyleOption.OptionType = ... # 0xf0006
    SO_SizeGrip              : QStyleOption.OptionType = ... # 0xf0007
    SO_ComplexCustomBase     : QStyleOption.OptionType = ... # 0xf000000
    Type                     : QStyleOption.StyleOptionType = ... # 0x0
    Version                  : QStyleOption.StyleOptionVersion = ... # 0x1

    class OptionType(Shiboken.Enum):
        SO_Default               : QStyleOption.OptionType = ... # 0x0
        SO_FocusRect             : QStyleOption.OptionType = ... # 0x1
        SO_Button                : QStyleOption.OptionType = ... # 0x2
        SO_Tab                   : QStyleOption.OptionType = ... # 0x3
        SO_MenuItem              : QStyleOption.OptionType = ... # 0x4
        SO_Frame                 : QStyleOption.OptionType = ... # 0x5
        SO_ProgressBar           : QStyleOption.OptionType = ... # 0x6
        SO_ToolBox               : QStyleOption.OptionType = ... # 0x7
        SO_Header                : QStyleOption.OptionType = ... # 0x8
        SO_DockWidget            : QStyleOption.OptionType = ... # 0x9
        SO_ViewItem              : QStyleOption.OptionType = ... # 0xa
        SO_TabWidgetFrame        : QStyleOption.OptionType = ... # 0xb
        SO_TabBarBase            : QStyleOption.OptionType = ... # 0xc
        SO_RubberBand            : QStyleOption.OptionType = ... # 0xd
        SO_ToolBar               : QStyleOption.OptionType = ... # 0xe
        SO_GraphicsItem          : QStyleOption.OptionType = ... # 0xf
        SO_CustomBase            : QStyleOption.OptionType = ... # 0xf00
        SO_Complex               : QStyleOption.OptionType = ... # 0xf0000
        SO_Slider                : QStyleOption.OptionType = ... # 0xf0001
        SO_SpinBox               : QStyleOption.OptionType = ... # 0xf0002
        SO_ToolButton            : QStyleOption.OptionType = ... # 0xf0003
        SO_ComboBox              : QStyleOption.OptionType = ... # 0xf0004
        SO_TitleBar              : QStyleOption.OptionType = ... # 0xf0005
        SO_GroupBox              : QStyleOption.OptionType = ... # 0xf0006
        SO_SizeGrip              : QStyleOption.OptionType = ... # 0xf0007
        SO_ComplexCustomBase     : QStyleOption.OptionType = ... # 0xf000000

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOption.StyleOptionType = ... # 0x0

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOption.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOption) -> None: ...
    @typing.overload
    def __init__(self, version: int = ..., type: int = ...) -> None: ...

    def init(self, w: PySide2.QtWidgets.QWidget) -> None: ...
    def initFrom(self, w: PySide2.QtWidgets.QWidget) -> None: ...


class QStyleOptionButton(PySide2.QtWidgets.QStyleOption):
    None_                    : QStyleOptionButton.ButtonFeature = ... # 0x0
    Flat                     : QStyleOptionButton.ButtonFeature = ... # 0x1
    HasMenu                  : QStyleOptionButton.ButtonFeature = ... # 0x2
    DefaultButton            : QStyleOptionButton.ButtonFeature = ... # 0x4
    AutoDefaultButton        : QStyleOptionButton.ButtonFeature = ... # 0x8
    CommandLinkButton        : QStyleOptionButton.ButtonFeature = ... # 0x10
    Type                     : QStyleOptionButton.StyleOptionType = ... # 0x2
    Version                  : QStyleOptionButton.StyleOptionVersion = ... # 0x1

    class ButtonFeature(Shiboken.Enum):
        None_                    : QStyleOptionButton.ButtonFeature = ... # 0x0
        Flat                     : QStyleOptionButton.ButtonFeature = ... # 0x1
        HasMenu                  : QStyleOptionButton.ButtonFeature = ... # 0x2
        DefaultButton            : QStyleOptionButton.ButtonFeature = ... # 0x4
        AutoDefaultButton        : QStyleOptionButton.ButtonFeature = ... # 0x8
        CommandLinkButton        : QStyleOptionButton.ButtonFeature = ... # 0x10

    class ButtonFeatures(object): ...

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionButton.StyleOptionType = ... # 0x2

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionButton.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionButton) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionComboBox(PySide2.QtWidgets.QStyleOptionComplex):
    Type                     : QStyleOptionComboBox.StyleOptionType = ... # 0xf0004
    Version                  : QStyleOptionComboBox.StyleOptionVersion = ... # 0x1

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionComboBox.StyleOptionType = ... # 0xf0004

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionComboBox.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionComboBox) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionComplex(PySide2.QtWidgets.QStyleOption):
    Type                     : QStyleOptionComplex.StyleOptionType = ... # 0xf0000
    Version                  : QStyleOptionComplex.StyleOptionVersion = ... # 0x1

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionComplex.StyleOptionType = ... # 0xf0000

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionComplex.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionComplex) -> None: ...
    @typing.overload
    def __init__(self, version: int = ..., type: int = ...) -> None: ...


class QStyleOptionDockWidget(PySide2.QtWidgets.QStyleOption):
    Type                     : QStyleOptionDockWidget.StyleOptionType = ... # 0x9
    Version                  : QStyleOptionDockWidget.StyleOptionVersion = ... # 0x2

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionDockWidget.StyleOptionType = ... # 0x9

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionDockWidget.StyleOptionVersion = ... # 0x2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionDockWidget) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionFocusRect(PySide2.QtWidgets.QStyleOption):
    Type                     : QStyleOptionFocusRect.StyleOptionType = ... # 0x1
    Version                  : QStyleOptionFocusRect.StyleOptionVersion = ... # 0x1

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionFocusRect.StyleOptionType = ... # 0x1

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionFocusRect.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionFocusRect) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionFrame(PySide2.QtWidgets.QStyleOption):
    None_                    : QStyleOptionFrame.FrameFeature = ... # 0x0
    Flat                     : QStyleOptionFrame.FrameFeature = ... # 0x1
    Rounded                  : QStyleOptionFrame.FrameFeature = ... # 0x2
    Type                     : QStyleOptionFrame.StyleOptionType = ... # 0x5
    Version                  : QStyleOptionFrame.StyleOptionVersion = ... # 0x3

    class FrameFeature(Shiboken.Enum):
        None_                    : QStyleOptionFrame.FrameFeature = ... # 0x0
        Flat                     : QStyleOptionFrame.FrameFeature = ... # 0x1
        Rounded                  : QStyleOptionFrame.FrameFeature = ... # 0x2

    class FrameFeatures(object): ...

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionFrame.StyleOptionType = ... # 0x5

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionFrame.StyleOptionVersion = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionFrame) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionGraphicsItem(PySide2.QtWidgets.QStyleOption):
    Type                     : QStyleOptionGraphicsItem.StyleOptionType = ... # 0xf
    Version                  : QStyleOptionGraphicsItem.StyleOptionVersion = ... # 0x1

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionGraphicsItem.StyleOptionType = ... # 0xf

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionGraphicsItem.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionGraphicsItem) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...

    @staticmethod
    def levelOfDetailFromTransform(worldTransform: PySide2.QtGui.QTransform) -> float: ...


class QStyleOptionGroupBox(PySide2.QtWidgets.QStyleOptionComplex):
    Type                     : QStyleOptionGroupBox.StyleOptionType = ... # 0xf0006
    Version                  : QStyleOptionGroupBox.StyleOptionVersion = ... # 0x1

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionGroupBox.StyleOptionType = ... # 0xf0006

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionGroupBox.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionGroupBox) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionHeader(PySide2.QtWidgets.QStyleOption):
    Beginning                : QStyleOptionHeader.SectionPosition = ... # 0x0
    Middle                   : QStyleOptionHeader.SectionPosition = ... # 0x1
    End                      : QStyleOptionHeader.SectionPosition = ... # 0x2
    OnlyOneSection           : QStyleOptionHeader.SectionPosition = ... # 0x3
    NotAdjacent              : QStyleOptionHeader.SelectedPosition = ... # 0x0
    NextIsSelected           : QStyleOptionHeader.SelectedPosition = ... # 0x1
    PreviousIsSelected       : QStyleOptionHeader.SelectedPosition = ... # 0x2
    NextAndPreviousAreSelected: QStyleOptionHeader.SelectedPosition = ... # 0x3
    None_                    : QStyleOptionHeader.SortIndicator = ... # 0x0
    SortUp                   : QStyleOptionHeader.SortIndicator = ... # 0x1
    SortDown                 : QStyleOptionHeader.SortIndicator = ... # 0x2
    Type                     : QStyleOptionHeader.StyleOptionType = ... # 0x8
    Version                  : QStyleOptionHeader.StyleOptionVersion = ... # 0x1

    class SectionPosition(Shiboken.Enum):
        Beginning                : QStyleOptionHeader.SectionPosition = ... # 0x0
        Middle                   : QStyleOptionHeader.SectionPosition = ... # 0x1
        End                      : QStyleOptionHeader.SectionPosition = ... # 0x2
        OnlyOneSection           : QStyleOptionHeader.SectionPosition = ... # 0x3

    class SelectedPosition(Shiboken.Enum):
        NotAdjacent              : QStyleOptionHeader.SelectedPosition = ... # 0x0
        NextIsSelected           : QStyleOptionHeader.SelectedPosition = ... # 0x1
        PreviousIsSelected       : QStyleOptionHeader.SelectedPosition = ... # 0x2
        NextAndPreviousAreSelected: QStyleOptionHeader.SelectedPosition = ... # 0x3

    class SortIndicator(Shiboken.Enum):
        None_                    : QStyleOptionHeader.SortIndicator = ... # 0x0
        SortUp                   : QStyleOptionHeader.SortIndicator = ... # 0x1
        SortDown                 : QStyleOptionHeader.SortIndicator = ... # 0x2

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionHeader.StyleOptionType = ... # 0x8

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionHeader.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionHeader) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionMenuItem(PySide2.QtWidgets.QStyleOption):
    NotCheckable             : QStyleOptionMenuItem.CheckType = ... # 0x0
    Exclusive                : QStyleOptionMenuItem.CheckType = ... # 0x1
    NonExclusive             : QStyleOptionMenuItem.CheckType = ... # 0x2
    Normal                   : QStyleOptionMenuItem.MenuItemType = ... # 0x0
    DefaultItem              : QStyleOptionMenuItem.MenuItemType = ... # 0x1
    Separator                : QStyleOptionMenuItem.MenuItemType = ... # 0x2
    SubMenu                  : QStyleOptionMenuItem.MenuItemType = ... # 0x3
    Scroller                 : QStyleOptionMenuItem.MenuItemType = ... # 0x4
    TearOff                  : QStyleOptionMenuItem.MenuItemType = ... # 0x5
    Margin                   : QStyleOptionMenuItem.MenuItemType = ... # 0x6
    EmptyArea                : QStyleOptionMenuItem.MenuItemType = ... # 0x7
    Type                     : QStyleOptionMenuItem.StyleOptionType = ... # 0x4
    Version                  : QStyleOptionMenuItem.StyleOptionVersion = ... # 0x1

    class CheckType(Shiboken.Enum):
        NotCheckable             : QStyleOptionMenuItem.CheckType = ... # 0x0
        Exclusive                : QStyleOptionMenuItem.CheckType = ... # 0x1
        NonExclusive             : QStyleOptionMenuItem.CheckType = ... # 0x2

    class MenuItemType(Shiboken.Enum):
        Normal                   : QStyleOptionMenuItem.MenuItemType = ... # 0x0
        DefaultItem              : QStyleOptionMenuItem.MenuItemType = ... # 0x1
        Separator                : QStyleOptionMenuItem.MenuItemType = ... # 0x2
        SubMenu                  : QStyleOptionMenuItem.MenuItemType = ... # 0x3
        Scroller                 : QStyleOptionMenuItem.MenuItemType = ... # 0x4
        TearOff                  : QStyleOptionMenuItem.MenuItemType = ... # 0x5
        Margin                   : QStyleOptionMenuItem.MenuItemType = ... # 0x6
        EmptyArea                : QStyleOptionMenuItem.MenuItemType = ... # 0x7

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionMenuItem.StyleOptionType = ... # 0x4

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionMenuItem.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionMenuItem) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionProgressBar(PySide2.QtWidgets.QStyleOption):
    Type                     : QStyleOptionProgressBar.StyleOptionType = ... # 0x6
    Version                  : QStyleOptionProgressBar.StyleOptionVersion = ... # 0x2

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionProgressBar.StyleOptionType = ... # 0x6

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionProgressBar.StyleOptionVersion = ... # 0x2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionProgressBar) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionRubberBand(PySide2.QtWidgets.QStyleOption):
    Type                     : QStyleOptionRubberBand.StyleOptionType = ... # 0xd
    Version                  : QStyleOptionRubberBand.StyleOptionVersion = ... # 0x1

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionRubberBand.StyleOptionType = ... # 0xd

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionRubberBand.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionRubberBand) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionSizeGrip(PySide2.QtWidgets.QStyleOptionComplex):
    Type                     : QStyleOptionSizeGrip.StyleOptionType = ... # 0xf0007
    Version                  : QStyleOptionSizeGrip.StyleOptionVersion = ... # 0x1

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionSizeGrip.StyleOptionType = ... # 0xf0007

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionSizeGrip.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionSizeGrip) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionSlider(PySide2.QtWidgets.QStyleOptionComplex):
    Type                     : QStyleOptionSlider.StyleOptionType = ... # 0xf0001
    Version                  : QStyleOptionSlider.StyleOptionVersion = ... # 0x1

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionSlider.StyleOptionType = ... # 0xf0001

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionSlider.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionSlider) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionSpinBox(PySide2.QtWidgets.QStyleOptionComplex):
    Type                     : QStyleOptionSpinBox.StyleOptionType = ... # 0xf0002
    Version                  : QStyleOptionSpinBox.StyleOptionVersion = ... # 0x1

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionSpinBox.StyleOptionType = ... # 0xf0002

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionSpinBox.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionSpinBox) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionTab(PySide2.QtWidgets.QStyleOption):
    NoCornerWidgets          : QStyleOptionTab.CornerWidget = ... # 0x0
    LeftCornerWidget         : QStyleOptionTab.CornerWidget = ... # 0x1
    RightCornerWidget        : QStyleOptionTab.CornerWidget = ... # 0x2
    NotAdjacent              : QStyleOptionTab.SelectedPosition = ... # 0x0
    NextIsSelected           : QStyleOptionTab.SelectedPosition = ... # 0x1
    PreviousIsSelected       : QStyleOptionTab.SelectedPosition = ... # 0x2
    Type                     : QStyleOptionTab.StyleOptionType = ... # 0x3
    Version                  : QStyleOptionTab.StyleOptionVersion = ... # 0x3
    None_                    : QStyleOptionTab.TabFeature = ... # 0x0
    HasFrame                 : QStyleOptionTab.TabFeature = ... # 0x1
    Beginning                : QStyleOptionTab.TabPosition = ... # 0x0
    Middle                   : QStyleOptionTab.TabPosition = ... # 0x1
    End                      : QStyleOptionTab.TabPosition = ... # 0x2
    OnlyOneTab               : QStyleOptionTab.TabPosition = ... # 0x3

    class CornerWidget(Shiboken.Enum):
        NoCornerWidgets          : QStyleOptionTab.CornerWidget = ... # 0x0
        LeftCornerWidget         : QStyleOptionTab.CornerWidget = ... # 0x1
        RightCornerWidget        : QStyleOptionTab.CornerWidget = ... # 0x2

    class CornerWidgets(object): ...

    class SelectedPosition(Shiboken.Enum):
        NotAdjacent              : QStyleOptionTab.SelectedPosition = ... # 0x0
        NextIsSelected           : QStyleOptionTab.SelectedPosition = ... # 0x1
        PreviousIsSelected       : QStyleOptionTab.SelectedPosition = ... # 0x2

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionTab.StyleOptionType = ... # 0x3

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionTab.StyleOptionVersion = ... # 0x3

    class TabFeature(Shiboken.Enum):
        None_                    : QStyleOptionTab.TabFeature = ... # 0x0
        HasFrame                 : QStyleOptionTab.TabFeature = ... # 0x1

    class TabFeatures(object): ...

    class TabPosition(Shiboken.Enum):
        Beginning                : QStyleOptionTab.TabPosition = ... # 0x0
        Middle                   : QStyleOptionTab.TabPosition = ... # 0x1
        End                      : QStyleOptionTab.TabPosition = ... # 0x2
        OnlyOneTab               : QStyleOptionTab.TabPosition = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionTab) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionTabBarBase(PySide2.QtWidgets.QStyleOption):
    Type                     : QStyleOptionTabBarBase.StyleOptionType = ... # 0xc
    Version                  : QStyleOptionTabBarBase.StyleOptionVersion = ... # 0x2

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionTabBarBase.StyleOptionType = ... # 0xc

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionTabBarBase.StyleOptionVersion = ... # 0x2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionTabBarBase) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionTabWidgetFrame(PySide2.QtWidgets.QStyleOption):
    Type                     : QStyleOptionTabWidgetFrame.StyleOptionType = ... # 0xb
    Version                  : QStyleOptionTabWidgetFrame.StyleOptionVersion = ... # 0x2

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionTabWidgetFrame.StyleOptionType = ... # 0xb

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionTabWidgetFrame.StyleOptionVersion = ... # 0x2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionTabWidgetFrame) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionTitleBar(PySide2.QtWidgets.QStyleOptionComplex):
    Type                     : QStyleOptionTitleBar.StyleOptionType = ... # 0xf0005
    Version                  : QStyleOptionTitleBar.StyleOptionVersion = ... # 0x1

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionTitleBar.StyleOptionType = ... # 0xf0005

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionTitleBar.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionTitleBar) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionToolBar(PySide2.QtWidgets.QStyleOption):
    Type                     : QStyleOptionToolBar.StyleOptionType = ... # 0xe
    Version                  : QStyleOptionToolBar.StyleOptionVersion = ... # 0x1
    None_                    : QStyleOptionToolBar.ToolBarFeature = ... # 0x0
    Movable                  : QStyleOptionToolBar.ToolBarFeature = ... # 0x1
    Beginning                : QStyleOptionToolBar.ToolBarPosition = ... # 0x0
    Middle                   : QStyleOptionToolBar.ToolBarPosition = ... # 0x1
    End                      : QStyleOptionToolBar.ToolBarPosition = ... # 0x2
    OnlyOne                  : QStyleOptionToolBar.ToolBarPosition = ... # 0x3

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionToolBar.StyleOptionType = ... # 0xe

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionToolBar.StyleOptionVersion = ... # 0x1

    class ToolBarFeature(Shiboken.Enum):
        None_                    : QStyleOptionToolBar.ToolBarFeature = ... # 0x0
        Movable                  : QStyleOptionToolBar.ToolBarFeature = ... # 0x1

    class ToolBarFeatures(object): ...

    class ToolBarPosition(Shiboken.Enum):
        Beginning                : QStyleOptionToolBar.ToolBarPosition = ... # 0x0
        Middle                   : QStyleOptionToolBar.ToolBarPosition = ... # 0x1
        End                      : QStyleOptionToolBar.ToolBarPosition = ... # 0x2
        OnlyOne                  : QStyleOptionToolBar.ToolBarPosition = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionToolBar) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionToolBox(PySide2.QtWidgets.QStyleOption):
    NotAdjacent              : QStyleOptionToolBox.SelectedPosition = ... # 0x0
    NextIsSelected           : QStyleOptionToolBox.SelectedPosition = ... # 0x1
    PreviousIsSelected       : QStyleOptionToolBox.SelectedPosition = ... # 0x2
    Type                     : QStyleOptionToolBox.StyleOptionType = ... # 0x7
    Version                  : QStyleOptionToolBox.StyleOptionVersion = ... # 0x2
    Beginning                : QStyleOptionToolBox.TabPosition = ... # 0x0
    Middle                   : QStyleOptionToolBox.TabPosition = ... # 0x1
    End                      : QStyleOptionToolBox.TabPosition = ... # 0x2
    OnlyOneTab               : QStyleOptionToolBox.TabPosition = ... # 0x3

    class SelectedPosition(Shiboken.Enum):
        NotAdjacent              : QStyleOptionToolBox.SelectedPosition = ... # 0x0
        NextIsSelected           : QStyleOptionToolBox.SelectedPosition = ... # 0x1
        PreviousIsSelected       : QStyleOptionToolBox.SelectedPosition = ... # 0x2

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionToolBox.StyleOptionType = ... # 0x7

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionToolBox.StyleOptionVersion = ... # 0x2

    class TabPosition(Shiboken.Enum):
        Beginning                : QStyleOptionToolBox.TabPosition = ... # 0x0
        Middle                   : QStyleOptionToolBox.TabPosition = ... # 0x1
        End                      : QStyleOptionToolBox.TabPosition = ... # 0x2
        OnlyOneTab               : QStyleOptionToolBox.TabPosition = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionToolBox) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionToolButton(PySide2.QtWidgets.QStyleOptionComplex):
    Type                     : QStyleOptionToolButton.StyleOptionType = ... # 0xf0003
    Version                  : QStyleOptionToolButton.StyleOptionVersion = ... # 0x1
    None_                    : QStyleOptionToolButton.ToolButtonFeature = ... # 0x0
    Arrow                    : QStyleOptionToolButton.ToolButtonFeature = ... # 0x1
    Menu                     : QStyleOptionToolButton.ToolButtonFeature = ... # 0x4
    MenuButtonPopup          : QStyleOptionToolButton.ToolButtonFeature = ... # 0x4
    PopupDelay               : QStyleOptionToolButton.ToolButtonFeature = ... # 0x8
    HasMenu                  : QStyleOptionToolButton.ToolButtonFeature = ... # 0x10

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionToolButton.StyleOptionType = ... # 0xf0003

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionToolButton.StyleOptionVersion = ... # 0x1

    class ToolButtonFeature(Shiboken.Enum):
        None_                    : QStyleOptionToolButton.ToolButtonFeature = ... # 0x0
        Arrow                    : QStyleOptionToolButton.ToolButtonFeature = ... # 0x1
        Menu                     : QStyleOptionToolButton.ToolButtonFeature = ... # 0x4
        MenuButtonPopup          : QStyleOptionToolButton.ToolButtonFeature = ... # 0x4
        PopupDelay               : QStyleOptionToolButton.ToolButtonFeature = ... # 0x8
        HasMenu                  : QStyleOptionToolButton.ToolButtonFeature = ... # 0x10

    class ToolButtonFeatures(object): ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionToolButton) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionViewItem(PySide2.QtWidgets.QStyleOption):
    Left                     : QStyleOptionViewItem.Position = ... # 0x0
    Right                    : QStyleOptionViewItem.Position = ... # 0x1
    Top                      : QStyleOptionViewItem.Position = ... # 0x2
    Bottom                   : QStyleOptionViewItem.Position = ... # 0x3
    Type                     : QStyleOptionViewItem.StyleOptionType = ... # 0xa
    Version                  : QStyleOptionViewItem.StyleOptionVersion = ... # 0x4
    None_                    : QStyleOptionViewItem.ViewItemFeature = ... # 0x0
    WrapText                 : QStyleOptionViewItem.ViewItemFeature = ... # 0x1
    Alternate                : QStyleOptionViewItem.ViewItemFeature = ... # 0x2
    HasCheckIndicator        : QStyleOptionViewItem.ViewItemFeature = ... # 0x4
    HasDisplay               : QStyleOptionViewItem.ViewItemFeature = ... # 0x8
    HasDecoration            : QStyleOptionViewItem.ViewItemFeature = ... # 0x10
    Invalid                  : QStyleOptionViewItem.ViewItemPosition = ... # 0x0
    Beginning                : QStyleOptionViewItem.ViewItemPosition = ... # 0x1
    Middle                   : QStyleOptionViewItem.ViewItemPosition = ... # 0x2
    End                      : QStyleOptionViewItem.ViewItemPosition = ... # 0x3
    OnlyOne                  : QStyleOptionViewItem.ViewItemPosition = ... # 0x4

    class Position(Shiboken.Enum):
        Left                     : QStyleOptionViewItem.Position = ... # 0x0
        Right                    : QStyleOptionViewItem.Position = ... # 0x1
        Top                      : QStyleOptionViewItem.Position = ... # 0x2
        Bottom                   : QStyleOptionViewItem.Position = ... # 0x3

    class StyleOptionType(Shiboken.Enum):
        Type                     : QStyleOptionViewItem.StyleOptionType = ... # 0xa

    class StyleOptionVersion(Shiboken.Enum):
        Version                  : QStyleOptionViewItem.StyleOptionVersion = ... # 0x4

    class ViewItemFeature(Shiboken.Enum):
        None_                    : QStyleOptionViewItem.ViewItemFeature = ... # 0x0
        WrapText                 : QStyleOptionViewItem.ViewItemFeature = ... # 0x1
        Alternate                : QStyleOptionViewItem.ViewItemFeature = ... # 0x2
        HasCheckIndicator        : QStyleOptionViewItem.ViewItemFeature = ... # 0x4
        HasDisplay               : QStyleOptionViewItem.ViewItemFeature = ... # 0x8
        HasDecoration            : QStyleOptionViewItem.ViewItemFeature = ... # 0x10

    class ViewItemFeatures(object): ...

    class ViewItemPosition(Shiboken.Enum):
        Invalid                  : QStyleOptionViewItem.ViewItemPosition = ... # 0x0
        Beginning                : QStyleOptionViewItem.ViewItemPosition = ... # 0x1
        Middle                   : QStyleOptionViewItem.ViewItemPosition = ... # 0x2
        End                      : QStyleOptionViewItem.ViewItemPosition = ... # 0x3
        OnlyOne                  : QStyleOptionViewItem.ViewItemPosition = ... # 0x4

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QStyleOptionViewItem) -> None: ...
    @typing.overload
    def __init__(self, version: int) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class QStylePainter(PySide2.QtGui.QPainter):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, pd: PySide2.QtGui.QPaintDevice, w: PySide2.QtWidgets.QWidget) -> None: ...
    @typing.overload
    def __init__(self, w: PySide2.QtWidgets.QWidget) -> None: ...

    @typing.overload
    def begin(self, arg__1: PySide2.QtGui.QPaintDevice) -> bool: ...
    @typing.overload
    def begin(self, pd: PySide2.QtGui.QPaintDevice, w: PySide2.QtWidgets.QWidget) -> bool: ...
    @typing.overload
    def begin(self, w: PySide2.QtWidgets.QWidget) -> bool: ...
    def drawComplexControl(self, cc: PySide2.QtWidgets.QStyle.ComplexControl, opt: PySide2.QtWidgets.QStyleOptionComplex) -> None: ...
    def drawControl(self, ce: PySide2.QtWidgets.QStyle.ControlElement, opt: PySide2.QtWidgets.QStyleOption) -> None: ...
    def drawItemPixmap(self, r: PySide2.QtCore.QRect, flags: int, pixmap: PySide2.QtGui.QPixmap) -> None: ...
    def drawItemText(self, r: PySide2.QtCore.QRect, flags: int, pal: PySide2.QtGui.QPalette, enabled: bool, text: str, textRole: PySide2.QtGui.QPalette.ColorRole = ...) -> None: ...
    def drawPrimitive(self, pe: PySide2.QtWidgets.QStyle.PrimitiveElement, opt: PySide2.QtWidgets.QStyleOption) -> None: ...
    def style(self) -> PySide2.QtWidgets.QStyle: ...


class QStyledItemDelegate(PySide2.QtWidgets.QAbstractItemDelegate):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def createEditor(self, parent: PySide2.QtWidgets.QWidget, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QWidget: ...
    def displayText(self, value: typing.Any, locale: PySide2.QtCore.QLocale) -> str: ...
    def editorEvent(self, event: PySide2.QtCore.QEvent, model: PySide2.QtCore.QAbstractItemModel, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def eventFilter(self, object: PySide2.QtCore.QObject, event: PySide2.QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> None: ...
    def itemEditorFactory(self) -> PySide2.QtWidgets.QItemEditorFactory: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setEditorData(self, editor: PySide2.QtWidgets.QWidget, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setItemEditorFactory(self, factory: PySide2.QtWidgets.QItemEditorFactory) -> None: ...
    def setModelData(self, editor: PySide2.QtWidgets.QWidget, model: PySide2.QtCore.QAbstractItemModel, index: PySide2.QtCore.QModelIndex) -> None: ...
    def sizeHint(self, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QSize: ...
    def updateEditorGeometry(self, editor: PySide2.QtWidgets.QWidget, option: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> None: ...


class QSwipeGesture(PySide2.QtWidgets.QGesture):
    NoDirection              : QSwipeGesture.SwipeDirection = ... # 0x0
    Left                     : QSwipeGesture.SwipeDirection = ... # 0x1
    Right                    : QSwipeGesture.SwipeDirection = ... # 0x2
    Up                       : QSwipeGesture.SwipeDirection = ... # 0x3
    Down                     : QSwipeGesture.SwipeDirection = ... # 0x4

    class SwipeDirection(Shiboken.Enum):
        NoDirection              : QSwipeGesture.SwipeDirection = ... # 0x0
        Left                     : QSwipeGesture.SwipeDirection = ... # 0x1
        Right                    : QSwipeGesture.SwipeDirection = ... # 0x2
        Up                       : QSwipeGesture.SwipeDirection = ... # 0x3
        Down                     : QSwipeGesture.SwipeDirection = ... # 0x4

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def horizontalDirection(self) -> PySide2.QtWidgets.QSwipeGesture.SwipeDirection: ...
    def setSwipeAngle(self, value: float) -> None: ...
    def swipeAngle(self) -> float: ...
    def verticalDirection(self) -> PySide2.QtWidgets.QSwipeGesture.SwipeDirection: ...


class QSystemTrayIcon(PySide2.QtCore.QObject):
    Unknown                  : QSystemTrayIcon.ActivationReason = ... # 0x0
    Context                  : QSystemTrayIcon.ActivationReason = ... # 0x1
    DoubleClick              : QSystemTrayIcon.ActivationReason = ... # 0x2
    Trigger                  : QSystemTrayIcon.ActivationReason = ... # 0x3
    MiddleClick              : QSystemTrayIcon.ActivationReason = ... # 0x4
    NoIcon                   : QSystemTrayIcon.MessageIcon = ... # 0x0
    Information              : QSystemTrayIcon.MessageIcon = ... # 0x1
    Warning                  : QSystemTrayIcon.MessageIcon = ... # 0x2
    Critical                 : QSystemTrayIcon.MessageIcon = ... # 0x3

    class ActivationReason(Shiboken.Enum):
        Unknown                  : QSystemTrayIcon.ActivationReason = ... # 0x0
        Context                  : QSystemTrayIcon.ActivationReason = ... # 0x1
        DoubleClick              : QSystemTrayIcon.ActivationReason = ... # 0x2
        Trigger                  : QSystemTrayIcon.ActivationReason = ... # 0x3
        MiddleClick              : QSystemTrayIcon.ActivationReason = ... # 0x4

    class MessageIcon(Shiboken.Enum):
        NoIcon                   : QSystemTrayIcon.MessageIcon = ... # 0x0
        Information              : QSystemTrayIcon.MessageIcon = ... # 0x1
        Warning                  : QSystemTrayIcon.MessageIcon = ... # 0x2
        Critical                 : QSystemTrayIcon.MessageIcon = ... # 0x3

    @typing.overload
    def __init__(self, icon: PySide2.QtGui.QIcon, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def contextMenu(self) -> PySide2.QtWidgets.QMenu: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def hide(self) -> None: ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    @staticmethod
    def isSystemTrayAvailable() -> bool: ...
    def isVisible(self) -> bool: ...
    def setContextMenu(self, menu: PySide2.QtWidgets.QMenu) -> None: ...
    def setIcon(self, icon: PySide2.QtGui.QIcon) -> None: ...
    def setToolTip(self, tip: str) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def show(self) -> None: ...
    @typing.overload
    def showMessage(self, title: str, msg: str, icon: PySide2.QtGui.QIcon, msecs: int = ...) -> None: ...
    @typing.overload
    def showMessage(self, title: str, msg: str, icon: PySide2.QtWidgets.QSystemTrayIcon.MessageIcon = ..., msecs: int = ...) -> None: ...
    @staticmethod
    def supportsMessages() -> bool: ...
    def toolTip(self) -> str: ...


class QTabBar(PySide2.QtWidgets.QWidget):
    LeftSide                 : QTabBar.ButtonPosition = ... # 0x0
    RightSide                : QTabBar.ButtonPosition = ... # 0x1
    SelectLeftTab            : QTabBar.SelectionBehavior = ... # 0x0
    SelectRightTab           : QTabBar.SelectionBehavior = ... # 0x1
    SelectPreviousTab        : QTabBar.SelectionBehavior = ... # 0x2
    RoundedNorth             : QTabBar.Shape = ... # 0x0
    RoundedSouth             : QTabBar.Shape = ... # 0x1
    RoundedWest              : QTabBar.Shape = ... # 0x2
    RoundedEast              : QTabBar.Shape = ... # 0x3
    TriangularNorth          : QTabBar.Shape = ... # 0x4
    TriangularSouth          : QTabBar.Shape = ... # 0x5
    TriangularWest           : QTabBar.Shape = ... # 0x6
    TriangularEast           : QTabBar.Shape = ... # 0x7

    class ButtonPosition(Shiboken.Enum):
        LeftSide                 : QTabBar.ButtonPosition = ... # 0x0
        RightSide                : QTabBar.ButtonPosition = ... # 0x1

    class SelectionBehavior(Shiboken.Enum):
        SelectLeftTab            : QTabBar.SelectionBehavior = ... # 0x0
        SelectRightTab           : QTabBar.SelectionBehavior = ... # 0x1
        SelectPreviousTab        : QTabBar.SelectionBehavior = ... # 0x2

    class Shape(Shiboken.Enum):
        RoundedNorth             : QTabBar.Shape = ... # 0x0
        RoundedSouth             : QTabBar.Shape = ... # 0x1
        RoundedWest              : QTabBar.Shape = ... # 0x2
        RoundedEast              : QTabBar.Shape = ... # 0x3
        TriangularNorth          : QTabBar.Shape = ... # 0x4
        TriangularSouth          : QTabBar.Shape = ... # 0x5
        TriangularWest           : QTabBar.Shape = ... # 0x6
        TriangularEast           : QTabBar.Shape = ... # 0x7

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def accessibleTabName(self, index: int) -> str: ...
    @typing.overload
    def addTab(self, icon: PySide2.QtGui.QIcon, text: str) -> int: ...
    @typing.overload
    def addTab(self, text: str) -> int: ...
    def autoHide(self) -> bool: ...
    def changeCurrentOnDrag(self) -> bool: ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...
    def count(self) -> int: ...
    def currentIndex(self) -> int: ...
    def documentMode(self) -> bool: ...
    def drawBase(self) -> bool: ...
    def elideMode(self) -> PySide2.QtCore.Qt.TextElideMode: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def expanding(self) -> bool: ...
    def hideEvent(self, arg__1: PySide2.QtGui.QHideEvent) -> None: ...
    def iconSize(self) -> PySide2.QtCore.QSize: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionTab, tabIndex: int) -> None: ...
    @typing.overload
    def insertTab(self, index: int, icon: PySide2.QtGui.QIcon, text: str) -> int: ...
    @typing.overload
    def insertTab(self, index: int, text: str) -> int: ...
    def isMovable(self) -> bool: ...
    def isTabEnabled(self, index: int) -> bool: ...
    def isTabVisible(self, index: int) -> bool: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent) -> None: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def minimumTabSizeHint(self, index: int) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def moveTab(self, from_: int, to: int) -> None: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def removeTab(self, index: int) -> None: ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent) -> None: ...
    def selectionBehaviorOnRemove(self) -> PySide2.QtWidgets.QTabBar.SelectionBehavior: ...
    def setAccessibleTabName(self, index: int, name: str) -> None: ...
    def setAutoHide(self, hide: bool) -> None: ...
    def setChangeCurrentOnDrag(self, change: bool) -> None: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def setDocumentMode(self, set: bool) -> None: ...
    def setDrawBase(self, drawTheBase: bool) -> None: ...
    def setElideMode(self, mode: PySide2.QtCore.Qt.TextElideMode) -> None: ...
    def setExpanding(self, enabled: bool) -> None: ...
    def setIconSize(self, size: PySide2.QtCore.QSize) -> None: ...
    def setMovable(self, movable: bool) -> None: ...
    def setSelectionBehaviorOnRemove(self, behavior: PySide2.QtWidgets.QTabBar.SelectionBehavior) -> None: ...
    def setShape(self, shape: PySide2.QtWidgets.QTabBar.Shape) -> None: ...
    def setTabButton(self, index: int, position: PySide2.QtWidgets.QTabBar.ButtonPosition, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def setTabData(self, index: int, data: typing.Any) -> None: ...
    def setTabEnabled(self, index: int, enabled: bool) -> None: ...
    def setTabIcon(self, index: int, icon: PySide2.QtGui.QIcon) -> None: ...
    def setTabText(self, index: int, text: str) -> None: ...
    def setTabTextColor(self, index: int, color: PySide2.QtGui.QColor) -> None: ...
    def setTabToolTip(self, index: int, tip: str) -> None: ...
    def setTabVisible(self, index: int, visible: bool) -> None: ...
    def setTabWhatsThis(self, index: int, text: str) -> None: ...
    def setTabsClosable(self, closable: bool) -> None: ...
    def setUsesScrollButtons(self, useButtons: bool) -> None: ...
    def shape(self) -> PySide2.QtWidgets.QTabBar.Shape: ...
    def showEvent(self, arg__1: PySide2.QtGui.QShowEvent) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def tabAt(self, pos: PySide2.QtCore.QPoint) -> int: ...
    def tabButton(self, index: int, position: PySide2.QtWidgets.QTabBar.ButtonPosition) -> PySide2.QtWidgets.QWidget: ...
    def tabData(self, index: int) -> typing.Any: ...
    def tabIcon(self, index: int) -> PySide2.QtGui.QIcon: ...
    def tabInserted(self, index: int) -> None: ...
    def tabLayoutChange(self) -> None: ...
    def tabRect(self, index: int) -> PySide2.QtCore.QRect: ...
    def tabRemoved(self, index: int) -> None: ...
    def tabSizeHint(self, index: int) -> PySide2.QtCore.QSize: ...
    def tabText(self, index: int) -> str: ...
    def tabTextColor(self, index: int) -> PySide2.QtGui.QColor: ...
    def tabToolTip(self, index: int) -> str: ...
    def tabWhatsThis(self, index: int) -> str: ...
    def tabsClosable(self) -> bool: ...
    def timerEvent(self, event: PySide2.QtCore.QTimerEvent) -> None: ...
    def usesScrollButtons(self) -> bool: ...
    def wheelEvent(self, event: PySide2.QtGui.QWheelEvent) -> None: ...


class QTabWidget(PySide2.QtWidgets.QWidget):
    North                    : QTabWidget.TabPosition = ... # 0x0
    South                    : QTabWidget.TabPosition = ... # 0x1
    West                     : QTabWidget.TabPosition = ... # 0x2
    East                     : QTabWidget.TabPosition = ... # 0x3
    Rounded                  : QTabWidget.TabShape = ... # 0x0
    Triangular               : QTabWidget.TabShape = ... # 0x1

    class TabPosition(Shiboken.Enum):
        North                    : QTabWidget.TabPosition = ... # 0x0
        South                    : QTabWidget.TabPosition = ... # 0x1
        West                     : QTabWidget.TabPosition = ... # 0x2
        East                     : QTabWidget.TabPosition = ... # 0x3

    class TabShape(Shiboken.Enum):
        Rounded                  : QTabWidget.TabShape = ... # 0x0
        Triangular               : QTabWidget.TabShape = ... # 0x1

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    @typing.overload
    def addTab(self, widget: PySide2.QtWidgets.QWidget, arg__2: str) -> int: ...
    @typing.overload
    def addTab(self, widget: PySide2.QtWidgets.QWidget, icon: PySide2.QtGui.QIcon, label: str) -> int: ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def cornerWidget(self, corner: PySide2.QtCore.Qt.Corner = ...) -> PySide2.QtWidgets.QWidget: ...
    def count(self) -> int: ...
    def currentIndex(self) -> int: ...
    def currentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def documentMode(self) -> bool: ...
    def elideMode(self) -> PySide2.QtCore.Qt.TextElideMode: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, width: int) -> int: ...
    def iconSize(self) -> PySide2.QtCore.QSize: ...
    def indexOf(self, widget: PySide2.QtWidgets.QWidget) -> int: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionTabWidgetFrame) -> None: ...
    @typing.overload
    def insertTab(self, index: int, widget: PySide2.QtWidgets.QWidget, arg__3: str) -> int: ...
    @typing.overload
    def insertTab(self, index: int, widget: PySide2.QtWidgets.QWidget, icon: PySide2.QtGui.QIcon, label: str) -> int: ...
    def isMovable(self) -> bool: ...
    def isTabEnabled(self, index: int) -> bool: ...
    def isTabVisible(self, index: int) -> bool: ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent) -> None: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def removeTab(self, index: int) -> None: ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent) -> None: ...
    def setCornerWidget(self, w: PySide2.QtWidgets.QWidget, corner: PySide2.QtCore.Qt.Corner = ...) -> None: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def setCurrentWidget(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def setDocumentMode(self, set: bool) -> None: ...
    def setElideMode(self, mode: PySide2.QtCore.Qt.TextElideMode) -> None: ...
    def setIconSize(self, size: PySide2.QtCore.QSize) -> None: ...
    def setMovable(self, movable: bool) -> None: ...
    def setTabBar(self, arg__1: PySide2.QtWidgets.QTabBar) -> None: ...
    def setTabBarAutoHide(self, enabled: bool) -> None: ...
    def setTabEnabled(self, index: int, enabled: bool) -> None: ...
    def setTabIcon(self, index: int, icon: PySide2.QtGui.QIcon) -> None: ...
    def setTabPosition(self, position: PySide2.QtWidgets.QTabWidget.TabPosition) -> None: ...
    def setTabShape(self, s: PySide2.QtWidgets.QTabWidget.TabShape) -> None: ...
    def setTabText(self, index: int, text: str) -> None: ...
    def setTabToolTip(self, index: int, tip: str) -> None: ...
    def setTabVisible(self, index: int, visible: bool) -> None: ...
    def setTabWhatsThis(self, index: int, text: str) -> None: ...
    def setTabsClosable(self, closeable: bool) -> None: ...
    def setUsesScrollButtons(self, useButtons: bool) -> None: ...
    def showEvent(self, arg__1: PySide2.QtGui.QShowEvent) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def tabBar(self) -> PySide2.QtWidgets.QTabBar: ...
    def tabBarAutoHide(self) -> bool: ...
    def tabIcon(self, index: int) -> PySide2.QtGui.QIcon: ...
    def tabInserted(self, index: int) -> None: ...
    def tabPosition(self) -> PySide2.QtWidgets.QTabWidget.TabPosition: ...
    def tabRemoved(self, index: int) -> None: ...
    def tabShape(self) -> PySide2.QtWidgets.QTabWidget.TabShape: ...
    def tabText(self, index: int) -> str: ...
    def tabToolTip(self, index: int) -> str: ...
    def tabWhatsThis(self, index: int) -> str: ...
    def tabsClosable(self) -> bool: ...
    def usesScrollButtons(self) -> bool: ...
    def widget(self, index: int) -> PySide2.QtWidgets.QWidget: ...


class QTableView(PySide2.QtWidgets.QAbstractItemView):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def clearSpans(self) -> None: ...
    def columnAt(self, x: int) -> int: ...
    def columnCountChanged(self, oldCount: int, newCount: int) -> None: ...
    def columnMoved(self, column: int, oldIndex: int, newIndex: int) -> None: ...
    def columnResized(self, column: int, oldWidth: int, newWidth: int) -> None: ...
    def columnSpan(self, row: int, column: int) -> int: ...
    def columnViewportPosition(self, column: int) -> int: ...
    def columnWidth(self, column: int) -> int: ...
    def currentChanged(self, current: PySide2.QtCore.QModelIndex, previous: PySide2.QtCore.QModelIndex) -> None: ...
    def doItemsLayout(self) -> None: ...
    def gridStyle(self) -> PySide2.QtCore.Qt.PenStyle: ...
    def hideColumn(self, column: int) -> None: ...
    def hideRow(self, row: int) -> None: ...
    def horizontalHeader(self) -> PySide2.QtWidgets.QHeaderView: ...
    def horizontalOffset(self) -> int: ...
    def horizontalScrollbarAction(self, action: int) -> None: ...
    def indexAt(self, p: PySide2.QtCore.QPoint) -> PySide2.QtCore.QModelIndex: ...
    def isColumnHidden(self, column: int) -> bool: ...
    def isCornerButtonEnabled(self) -> bool: ...
    def isIndexHidden(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def isRowHidden(self, row: int) -> bool: ...
    def isSortingEnabled(self) -> bool: ...
    def moveCursor(self, cursorAction: PySide2.QtWidgets.QAbstractItemView.CursorAction, modifiers: PySide2.QtCore.Qt.KeyboardModifiers) -> PySide2.QtCore.QModelIndex: ...
    def paintEvent(self, e: PySide2.QtGui.QPaintEvent) -> None: ...
    def resizeColumnToContents(self, column: int) -> None: ...
    def resizeColumnsToContents(self) -> None: ...
    def resizeRowToContents(self, row: int) -> None: ...
    def resizeRowsToContents(self) -> None: ...
    def rowAt(self, y: int) -> int: ...
    def rowCountChanged(self, oldCount: int, newCount: int) -> None: ...
    def rowHeight(self, row: int) -> int: ...
    def rowMoved(self, row: int, oldIndex: int, newIndex: int) -> None: ...
    def rowResized(self, row: int, oldHeight: int, newHeight: int) -> None: ...
    def rowSpan(self, row: int, column: int) -> int: ...
    def rowViewportPosition(self, row: int) -> int: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def scrollTo(self, index: PySide2.QtCore.QModelIndex, hint: PySide2.QtWidgets.QAbstractItemView.ScrollHint = ...) -> None: ...
    def selectColumn(self, column: int) -> None: ...
    def selectRow(self, row: int) -> None: ...
    def selectedIndexes(self) -> typing.List[int]: ...
    def selectionChanged(self, selected: PySide2.QtCore.QItemSelection, deselected: PySide2.QtCore.QItemSelection) -> None: ...
    def setColumnHidden(self, column: int, hide: bool) -> None: ...
    def setColumnWidth(self, column: int, width: int) -> None: ...
    def setCornerButtonEnabled(self, enable: bool) -> None: ...
    def setGridStyle(self, style: PySide2.QtCore.Qt.PenStyle) -> None: ...
    def setHorizontalHeader(self, header: PySide2.QtWidgets.QHeaderView) -> None: ...
    def setModel(self, model: PySide2.QtCore.QAbstractItemModel) -> None: ...
    def setRootIndex(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setRowHeight(self, row: int, height: int) -> None: ...
    def setRowHidden(self, row: int, hide: bool) -> None: ...
    def setSelection(self, rect: PySide2.QtCore.QRect, command: PySide2.QtCore.QItemSelectionModel.SelectionFlags) -> None: ...
    def setSelectionModel(self, selectionModel: PySide2.QtCore.QItemSelectionModel) -> None: ...
    def setShowGrid(self, show: bool) -> None: ...
    def setSortingEnabled(self, enable: bool) -> None: ...
    def setSpan(self, row: int, column: int, rowSpan: int, columnSpan: int) -> None: ...
    def setVerticalHeader(self, header: PySide2.QtWidgets.QHeaderView) -> None: ...
    def setWordWrap(self, on: bool) -> None: ...
    def showColumn(self, column: int) -> None: ...
    def showGrid(self) -> bool: ...
    def showRow(self, row: int) -> None: ...
    def sizeHintForColumn(self, column: int) -> int: ...
    def sizeHintForRow(self, row: int) -> int: ...
    @typing.overload
    def sortByColumn(self, column: int) -> None: ...
    @typing.overload
    def sortByColumn(self, column: int, order: PySide2.QtCore.Qt.SortOrder) -> None: ...
    def timerEvent(self, event: PySide2.QtCore.QTimerEvent) -> None: ...
    def updateGeometries(self) -> None: ...
    def verticalHeader(self) -> PySide2.QtWidgets.QHeaderView: ...
    def verticalOffset(self) -> int: ...
    def verticalScrollbarAction(self, action: int) -> None: ...
    def viewOptions(self) -> PySide2.QtWidgets.QStyleOptionViewItem: ...
    def viewportSizeHint(self) -> PySide2.QtCore.QSize: ...
    def visualRect(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide2.QtCore.QItemSelection) -> PySide2.QtGui.QRegion: ...
    def wordWrap(self) -> bool: ...


class QTableWidget(PySide2.QtWidgets.QTableView):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, rows: int, columns: int, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def cellWidget(self, row: int, column: int) -> PySide2.QtWidgets.QWidget: ...
    def clear(self) -> None: ...
    def clearContents(self) -> None: ...
    @typing.overload
    def closePersistentEditor(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    @typing.overload
    def closePersistentEditor(self, item: PySide2.QtWidgets.QTableWidgetItem) -> None: ...
    def column(self, item: PySide2.QtWidgets.QTableWidgetItem) -> int: ...
    def columnCount(self) -> int: ...
    def currentColumn(self) -> int: ...
    def currentItem(self) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def currentRow(self) -> int: ...
    def dropEvent(self, event: PySide2.QtGui.QDropEvent) -> None: ...
    def dropMimeData(self, row: int, column: int, data: PySide2.QtCore.QMimeData, action: PySide2.QtCore.Qt.DropAction) -> bool: ...
    def editItem(self, item: PySide2.QtWidgets.QTableWidgetItem) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def findItems(self, text: str, flags: PySide2.QtCore.Qt.MatchFlags) -> typing.List[PySide2.QtWidgets.QTableWidgetItem]: ...
    def horizontalHeaderItem(self, column: int) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def indexFromItem(self, item: PySide2.QtWidgets.QTableWidgetItem) -> PySide2.QtCore.QModelIndex: ...
    def insertColumn(self, column: int) -> None: ...
    def insertRow(self, row: int) -> None: ...
    def isItemSelected(self, item: PySide2.QtWidgets.QTableWidgetItem) -> bool: ...
    @typing.overload
    def isPersistentEditorOpen(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    @typing.overload
    def isPersistentEditorOpen(self, item: PySide2.QtWidgets.QTableWidgetItem) -> bool: ...
    def isSortingEnabled(self) -> bool: ...
    def item(self, row: int, column: int) -> PySide2.QtWidgets.QTableWidgetItem: ...
    @typing.overload
    def itemAt(self, p: PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QTableWidgetItem: ...
    @typing.overload
    def itemAt(self, x: int, y: int) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def itemFromIndex(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def itemPrototype(self) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def items(self, data: PySide2.QtCore.QMimeData) -> typing.List[PySide2.QtWidgets.QTableWidgetItem]: ...
    def mimeData(self, items: typing.Sequence[PySide2.QtWidgets.QTableWidgetItem]) -> PySide2.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    @typing.overload
    def openPersistentEditor(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    @typing.overload
    def openPersistentEditor(self, item: PySide2.QtWidgets.QTableWidgetItem) -> None: ...
    def removeCellWidget(self, row: int, column: int) -> None: ...
    def removeColumn(self, column: int) -> None: ...
    def removeRow(self, row: int) -> None: ...
    def row(self, item: PySide2.QtWidgets.QTableWidgetItem) -> int: ...
    def rowCount(self) -> int: ...
    def scrollToItem(self, item: PySide2.QtWidgets.QTableWidgetItem, hint: PySide2.QtWidgets.QAbstractItemView.ScrollHint = ...) -> None: ...
    def selectedItems(self) -> typing.List[PySide2.QtWidgets.QTableWidgetItem]: ...
    def selectedRanges(self) -> typing.List[PySide2.QtWidgets.QTableWidgetSelectionRange]: ...
    def setCellWidget(self, row: int, column: int, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def setColumnCount(self, columns: int) -> None: ...
    @typing.overload
    def setCurrentCell(self, row: int, column: int) -> None: ...
    @typing.overload
    def setCurrentCell(self, row: int, column: int, command: PySide2.QtCore.QItemSelectionModel.SelectionFlags) -> None: ...
    @typing.overload
    def setCurrentItem(self, item: PySide2.QtWidgets.QTableWidgetItem) -> None: ...
    @typing.overload
    def setCurrentItem(self, item: PySide2.QtWidgets.QTableWidgetItem, command: PySide2.QtCore.QItemSelectionModel.SelectionFlags) -> None: ...
    def setHorizontalHeaderItem(self, column: int, item: PySide2.QtWidgets.QTableWidgetItem) -> None: ...
    def setHorizontalHeaderLabels(self, labels: typing.Sequence[str]) -> None: ...
    def setItem(self, row: int, column: int, item: PySide2.QtWidgets.QTableWidgetItem) -> None: ...
    def setItemPrototype(self, item: PySide2.QtWidgets.QTableWidgetItem) -> None: ...
    def setItemSelected(self, item: PySide2.QtWidgets.QTableWidgetItem, select: bool) -> None: ...
    def setModel(self, model: PySide2.QtCore.QAbstractItemModel) -> None: ...
    def setRangeSelected(self, range: PySide2.QtWidgets.QTableWidgetSelectionRange, select: bool) -> None: ...
    def setRowCount(self, rows: int) -> None: ...
    def setSortingEnabled(self, enable: bool) -> None: ...
    def setVerticalHeaderItem(self, row: int, item: PySide2.QtWidgets.QTableWidgetItem) -> None: ...
    def setVerticalHeaderLabels(self, labels: typing.Sequence[str]) -> None: ...
    def sortItems(self, column: int, order: PySide2.QtCore.Qt.SortOrder = ...) -> None: ...
    def supportedDropActions(self) -> PySide2.QtCore.Qt.DropActions: ...
    def takeHorizontalHeaderItem(self, column: int) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def takeItem(self, row: int, column: int) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def takeVerticalHeaderItem(self, row: int) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def verticalHeaderItem(self, row: int) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def visualColumn(self, logicalColumn: int) -> int: ...
    def visualItemRect(self, item: PySide2.QtWidgets.QTableWidgetItem) -> PySide2.QtCore.QRect: ...
    def visualRow(self, logicalRow: int) -> int: ...


class QTableWidgetItem(Shiboken.Object):
    Type                     : QTableWidgetItem.ItemType = ... # 0x0
    UserType                 : QTableWidgetItem.ItemType = ... # 0x3e8

    class ItemType(Shiboken.Enum):
        Type                     : QTableWidgetItem.ItemType = ... # 0x0
        UserType                 : QTableWidgetItem.ItemType = ... # 0x3e8

    @typing.overload
    def __init__(self, icon: PySide2.QtGui.QIcon, text: str, type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QTableWidgetItem) -> None: ...
    @typing.overload
    def __init__(self, text: str, type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, type: int = ...) -> None: ...

    def __lshift__(self, out: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, in_: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def background(self) -> PySide2.QtGui.QBrush: ...
    def backgroundColor(self) -> PySide2.QtGui.QColor: ...
    def checkState(self) -> PySide2.QtCore.Qt.CheckState: ...
    def clone(self) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def column(self) -> int: ...
    def data(self, role: int) -> typing.Any: ...
    def flags(self) -> PySide2.QtCore.Qt.ItemFlags: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def foreground(self) -> PySide2.QtGui.QBrush: ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    def isSelected(self) -> bool: ...
    def read(self, in_: PySide2.QtCore.QDataStream) -> None: ...
    def row(self) -> int: ...
    def setBackground(self, brush: PySide2.QtGui.QBrush) -> None: ...
    def setBackgroundColor(self, color: PySide2.QtGui.QColor) -> None: ...
    def setCheckState(self, state: PySide2.QtCore.Qt.CheckState) -> None: ...
    def setData(self, role: int, value: typing.Any) -> None: ...
    def setFlags(self, flags: PySide2.QtCore.Qt.ItemFlags) -> None: ...
    def setFont(self, font: PySide2.QtGui.QFont) -> None: ...
    def setForeground(self, brush: PySide2.QtGui.QBrush) -> None: ...
    def setIcon(self, icon: PySide2.QtGui.QIcon) -> None: ...
    def setSelected(self, select: bool) -> None: ...
    def setSizeHint(self, size: PySide2.QtCore.QSize) -> None: ...
    def setStatusTip(self, statusTip: str) -> None: ...
    def setText(self, text: str) -> None: ...
    def setTextAlignment(self, alignment: int) -> None: ...
    def setTextColor(self, color: PySide2.QtGui.QColor) -> None: ...
    def setToolTip(self, toolTip: str) -> None: ...
    def setWhatsThis(self, whatsThis: str) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def statusTip(self) -> str: ...
    def tableWidget(self) -> PySide2.QtWidgets.QTableWidget: ...
    def text(self) -> str: ...
    def textAlignment(self) -> int: ...
    def textColor(self) -> PySide2.QtGui.QColor: ...
    def toolTip(self) -> str: ...
    def type(self) -> int: ...
    def whatsThis(self) -> str: ...
    def write(self, out: PySide2.QtCore.QDataStream) -> None: ...


class QTableWidgetSelectionRange(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QTableWidgetSelectionRange) -> None: ...
    @typing.overload
    def __init__(self, top: int, left: int, bottom: int, right: int) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def bottomRow(self) -> int: ...
    def columnCount(self) -> int: ...
    def leftColumn(self) -> int: ...
    def rightColumn(self) -> int: ...
    def rowCount(self) -> int: ...
    def topRow(self) -> int: ...


class QTapAndHoldGesture(PySide2.QtWidgets.QGesture):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def position(self) -> PySide2.QtCore.QPointF: ...
    def setPosition(self, pos: PySide2.QtCore.QPointF) -> None: ...
    @staticmethod
    def setTimeout(msecs: int) -> None: ...
    @staticmethod
    def timeout() -> int: ...


class QTapGesture(PySide2.QtWidgets.QGesture):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def position(self) -> PySide2.QtCore.QPointF: ...
    def setPosition(self, pos: PySide2.QtCore.QPointF) -> None: ...


class QTextBrowser(PySide2.QtWidgets.QTextEdit):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def backward(self) -> None: ...
    def backwardHistoryCount(self) -> int: ...
    def clearHistory(self) -> None: ...
    def doSetSource(self, name: PySide2.QtCore.QUrl, type: PySide2.QtGui.QTextDocument.ResourceType = ...) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, ev: PySide2.QtGui.QFocusEvent) -> None: ...
    def forward(self) -> None: ...
    def forwardHistoryCount(self) -> int: ...
    def historyTitle(self, arg__1: int) -> str: ...
    def historyUrl(self, arg__1: int) -> PySide2.QtCore.QUrl: ...
    def home(self) -> None: ...
    def isBackwardAvailable(self) -> bool: ...
    def isForwardAvailable(self) -> bool: ...
    def keyPressEvent(self, ev: PySide2.QtGui.QKeyEvent) -> None: ...
    def loadResource(self, type: int, name: PySide2.QtCore.QUrl) -> typing.Any: ...
    def mouseMoveEvent(self, ev: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, ev: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, ev: PySide2.QtGui.QMouseEvent) -> None: ...
    def openExternalLinks(self) -> bool: ...
    def openLinks(self) -> bool: ...
    def paintEvent(self, e: PySide2.QtGui.QPaintEvent) -> None: ...
    def reload(self) -> None: ...
    def searchPaths(self) -> typing.List[str]: ...
    def setOpenExternalLinks(self, open: bool) -> None: ...
    def setOpenLinks(self, open: bool) -> None: ...
    def setSearchPaths(self, paths: typing.Sequence[str]) -> None: ...
    @typing.overload
    def setSource(self, name: PySide2.QtCore.QUrl) -> None: ...
    @typing.overload
    def setSource(self, name: PySide2.QtCore.QUrl, type: PySide2.QtGui.QTextDocument.ResourceType) -> None: ...
    def source(self) -> PySide2.QtCore.QUrl: ...
    def sourceType(self) -> PySide2.QtGui.QTextDocument.ResourceType: ...


class QTextEdit(PySide2.QtWidgets.QAbstractScrollArea):
    AutoNone                 : QTextEdit.AutoFormattingFlag = ... # 0x0
    AutoBulletList           : QTextEdit.AutoFormattingFlag = ... # 0x1
    AutoAll                  : QTextEdit.AutoFormattingFlag = ... # -0x1
    NoWrap                   : QTextEdit.LineWrapMode = ... # 0x0
    WidgetWidth              : QTextEdit.LineWrapMode = ... # 0x1
    FixedPixelWidth          : QTextEdit.LineWrapMode = ... # 0x2
    FixedColumnWidth         : QTextEdit.LineWrapMode = ... # 0x3

    class AutoFormatting(object): ...

    class AutoFormattingFlag(Shiboken.Enum):
        AutoNone                 : QTextEdit.AutoFormattingFlag = ... # 0x0
        AutoBulletList           : QTextEdit.AutoFormattingFlag = ... # 0x1
        AutoAll                  : QTextEdit.AutoFormattingFlag = ... # -0x1

    class ExtraSelection(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, ExtraSelection: PySide2.QtWidgets.QTextEdit.ExtraSelection) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class LineWrapMode(Shiboken.Enum):
        NoWrap                   : QTextEdit.LineWrapMode = ... # 0x0
        WidgetWidth              : QTextEdit.LineWrapMode = ... # 0x1
        FixedPixelWidth          : QTextEdit.LineWrapMode = ... # 0x2
        FixedColumnWidth         : QTextEdit.LineWrapMode = ... # 0x3

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def acceptRichText(self) -> bool: ...
    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def anchorAt(self, pos: PySide2.QtCore.QPoint) -> str: ...
    def append(self, text: str) -> None: ...
    def autoFormatting(self) -> PySide2.QtWidgets.QTextEdit.AutoFormatting: ...
    def canInsertFromMimeData(self, source: PySide2.QtCore.QMimeData) -> bool: ...
    def canPaste(self) -> bool: ...
    def changeEvent(self, e: PySide2.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def contextMenuEvent(self, e: PySide2.QtGui.QContextMenuEvent) -> None: ...
    def copy(self) -> None: ...
    def createMimeDataFromSelection(self) -> PySide2.QtCore.QMimeData: ...
    @typing.overload
    def createStandardContextMenu(self) -> PySide2.QtWidgets.QMenu: ...
    @typing.overload
    def createStandardContextMenu(self, position: PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QMenu: ...
    def currentCharFormat(self) -> PySide2.QtGui.QTextCharFormat: ...
    def currentFont(self) -> PySide2.QtGui.QFont: ...
    def cursorForPosition(self, pos: PySide2.QtCore.QPoint) -> PySide2.QtGui.QTextCursor: ...
    @typing.overload
    def cursorRect(self) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def cursorRect(self, cursor: PySide2.QtGui.QTextCursor) -> PySide2.QtCore.QRect: ...
    def cursorWidth(self) -> int: ...
    def cut(self) -> None: ...
    def doSetTextCursor(self, cursor: PySide2.QtGui.QTextCursor) -> None: ...
    def document(self) -> PySide2.QtGui.QTextDocument: ...
    def documentTitle(self) -> str: ...
    def dragEnterEvent(self, e: PySide2.QtGui.QDragEnterEvent) -> None: ...
    def dragLeaveEvent(self, e: PySide2.QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, e: PySide2.QtGui.QDragMoveEvent) -> None: ...
    def dropEvent(self, e: PySide2.QtGui.QDropEvent) -> None: ...
    def ensureCursorVisible(self) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def extraSelections(self) -> typing.List[PySide2.QtWidgets.QTextEdit.ExtraSelection]: ...
    @typing.overload
    def find(self, exp: PySide2.QtCore.QRegExp, options: PySide2.QtGui.QTextDocument.FindFlags = ...) -> bool: ...
    @typing.overload
    def find(self, exp: PySide2.QtCore.QRegularExpression, options: PySide2.QtGui.QTextDocument.FindFlags = ...) -> bool: ...
    @typing.overload
    def find(self, exp: str, options: PySide2.QtGui.QTextDocument.FindFlags = ...) -> bool: ...
    def focusInEvent(self, e: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, e: PySide2.QtGui.QFocusEvent) -> None: ...
    def fontFamily(self) -> str: ...
    def fontItalic(self) -> bool: ...
    def fontPointSize(self) -> float: ...
    def fontUnderline(self) -> bool: ...
    def fontWeight(self) -> int: ...
    def inputMethodEvent(self, arg__1: PySide2.QtGui.QInputMethodEvent) -> None: ...
    @typing.overload
    def inputMethodQuery(self, property: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    @typing.overload
    def inputMethodQuery(self, query: PySide2.QtCore.Qt.InputMethodQuery, argument: typing.Any) -> typing.Any: ...
    def insertFromMimeData(self, source: PySide2.QtCore.QMimeData) -> None: ...
    def insertHtml(self, text: str) -> None: ...
    def insertPlainText(self, text: str) -> None: ...
    def isReadOnly(self) -> bool: ...
    def isUndoRedoEnabled(self) -> bool: ...
    def keyPressEvent(self, e: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, e: PySide2.QtGui.QKeyEvent) -> None: ...
    def lineWrapColumnOrWidth(self) -> int: ...
    def lineWrapMode(self) -> PySide2.QtWidgets.QTextEdit.LineWrapMode: ...
    def loadResource(self, type: int, name: PySide2.QtCore.QUrl) -> typing.Any: ...
    def mergeCurrentCharFormat(self, modifier: PySide2.QtGui.QTextCharFormat) -> None: ...
    def mouseDoubleClickEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: PySide2.QtGui.QMouseEvent) -> None: ...
    def moveCursor(self, operation: PySide2.QtGui.QTextCursor.MoveOperation, mode: PySide2.QtGui.QTextCursor.MoveMode = ...) -> None: ...
    def overwriteMode(self) -> bool: ...
    def paintEvent(self, e: PySide2.QtGui.QPaintEvent) -> None: ...
    def paste(self) -> None: ...
    def placeholderText(self) -> str: ...
    def print_(self, printer: PySide2.QtGui.QPagedPaintDevice) -> None: ...
    def redo(self) -> None: ...
    def resizeEvent(self, e: PySide2.QtGui.QResizeEvent) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def scrollToAnchor(self, name: str) -> None: ...
    def selectAll(self) -> None: ...
    def setAcceptRichText(self, accept: bool) -> None: ...
    def setAlignment(self, a: PySide2.QtCore.Qt.Alignment) -> None: ...
    def setAutoFormatting(self, features: PySide2.QtWidgets.QTextEdit.AutoFormatting) -> None: ...
    def setCurrentCharFormat(self, format: PySide2.QtGui.QTextCharFormat) -> None: ...
    def setCurrentFont(self, f: PySide2.QtGui.QFont) -> None: ...
    def setCursorWidth(self, width: int) -> None: ...
    def setDocument(self, document: PySide2.QtGui.QTextDocument) -> None: ...
    def setDocumentTitle(self, title: str) -> None: ...
    def setExtraSelections(self, selections: typing.Sequence[PySide2.QtWidgets.QTextEdit.ExtraSelection]) -> None: ...
    def setFontFamily(self, fontFamily: str) -> None: ...
    def setFontItalic(self, b: bool) -> None: ...
    def setFontPointSize(self, s: float) -> None: ...
    def setFontUnderline(self, b: bool) -> None: ...
    def setFontWeight(self, w: int) -> None: ...
    def setHtml(self, text: str) -> None: ...
    def setLineWrapColumnOrWidth(self, w: int) -> None: ...
    def setLineWrapMode(self, mode: PySide2.QtWidgets.QTextEdit.LineWrapMode) -> None: ...
    def setMarkdown(self, markdown: str) -> None: ...
    def setOverwriteMode(self, overwrite: bool) -> None: ...
    def setPlaceholderText(self, placeholderText: str) -> None: ...
    def setPlainText(self, text: str) -> None: ...
    def setReadOnly(self, ro: bool) -> None: ...
    def setTabChangesFocus(self, b: bool) -> None: ...
    def setTabStopDistance(self, distance: float) -> None: ...
    def setTabStopWidth(self, width: int) -> None: ...
    def setText(self, text: str) -> None: ...
    def setTextBackgroundColor(self, c: PySide2.QtGui.QColor) -> None: ...
    def setTextColor(self, c: PySide2.QtGui.QColor) -> None: ...
    def setTextCursor(self, cursor: PySide2.QtGui.QTextCursor) -> None: ...
    def setTextInteractionFlags(self, flags: PySide2.QtCore.Qt.TextInteractionFlags) -> None: ...
    def setUndoRedoEnabled(self, enable: bool) -> None: ...
    def setWordWrapMode(self, policy: PySide2.QtGui.QTextOption.WrapMode) -> None: ...
    def showEvent(self, arg__1: PySide2.QtGui.QShowEvent) -> None: ...
    def tabChangesFocus(self) -> bool: ...
    def tabStopDistance(self) -> float: ...
    def tabStopWidth(self) -> int: ...
    def textBackgroundColor(self) -> PySide2.QtGui.QColor: ...
    def textColor(self) -> PySide2.QtGui.QColor: ...
    def textCursor(self) -> PySide2.QtGui.QTextCursor: ...
    def textInteractionFlags(self) -> PySide2.QtCore.Qt.TextInteractionFlags: ...
    def timerEvent(self, e: PySide2.QtCore.QTimerEvent) -> None: ...
    def toHtml(self) -> str: ...
    def toMarkdown(self, features: PySide2.QtGui.QTextDocument.MarkdownFeatures = ...) -> str: ...
    def toPlainText(self) -> str: ...
    def undo(self) -> None: ...
    def wheelEvent(self, e: PySide2.QtGui.QWheelEvent) -> None: ...
    def wordWrapMode(self) -> PySide2.QtGui.QTextOption.WrapMode: ...
    def zoomIn(self, range: int = ...) -> None: ...
    def zoomInF(self, range: float) -> None: ...
    def zoomOut(self, range: int = ...) -> None: ...


class QTileRules(Shiboken.Object):

    @typing.overload
    def __init__(self, QTileRules: PySide2.QtWidgets.QTileRules) -> None: ...
    @typing.overload
    def __init__(self, horizontalRule: PySide2.QtCore.Qt.TileRule, verticalRule: PySide2.QtCore.Qt.TileRule) -> None: ...
    @typing.overload
    def __init__(self, rule: PySide2.QtCore.Qt.TileRule = ...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class QTimeEdit(PySide2.QtWidgets.QDateTimeEdit):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, time: PySide2.QtCore.QTime, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QToolBar(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, title: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    @typing.overload
    def actionAt(self, p: PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def actionAt(self, x: int, y: int) -> PySide2.QtWidgets.QAction: ...
    def actionEvent(self, event: PySide2.QtGui.QActionEvent) -> None: ...
    def actionGeometry(self, action: PySide2.QtWidgets.QAction) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def addAction(self, arg__1: PySide2.QtWidgets.QAction) -> None: ...
    @typing.overload
    def addAction(self, icon: PySide2.QtGui.QIcon, text: str) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, icon: PySide2.QtGui.QIcon, text: str, receiver: PySide2.QtCore.QObject, member: bytes) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, text: str) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, text: str, receiver: PySide2.QtCore.QObject, member: bytes) -> PySide2.QtWidgets.QAction: ...
    def addSeparator(self) -> PySide2.QtWidgets.QAction: ...
    def addWidget(self, widget: PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QAction: ...
    def allowedAreas(self) -> PySide2.QtCore.Qt.ToolBarAreas: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def iconSize(self) -> PySide2.QtCore.QSize: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionToolBar) -> None: ...
    def insertSeparator(self, before: PySide2.QtWidgets.QAction) -> PySide2.QtWidgets.QAction: ...
    def insertWidget(self, before: PySide2.QtWidgets.QAction, widget: PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QAction: ...
    def isAreaAllowed(self, area: PySide2.QtCore.Qt.ToolBarArea) -> bool: ...
    def isFloatable(self) -> bool: ...
    def isFloating(self) -> bool: ...
    def isMovable(self) -> bool: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent) -> None: ...
    def setAllowedAreas(self, areas: PySide2.QtCore.Qt.ToolBarAreas) -> None: ...
    def setFloatable(self, floatable: bool) -> None: ...
    def setIconSize(self, iconSize: PySide2.QtCore.QSize) -> None: ...
    def setMovable(self, movable: bool) -> None: ...
    def setOrientation(self, orientation: PySide2.QtCore.Qt.Orientation) -> None: ...
    def setToolButtonStyle(self, toolButtonStyle: PySide2.QtCore.Qt.ToolButtonStyle) -> None: ...
    def toggleViewAction(self) -> PySide2.QtWidgets.QAction: ...
    def toolButtonStyle(self) -> PySide2.QtCore.Qt.ToolButtonStyle: ...
    def widgetForAction(self, action: PySide2.QtWidgets.QAction) -> PySide2.QtWidgets.QWidget: ...


class QToolBox(PySide2.QtWidgets.QFrame):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., f: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...

    @typing.overload
    def addItem(self, widget: PySide2.QtWidgets.QWidget, icon: PySide2.QtGui.QIcon, text: str) -> int: ...
    @typing.overload
    def addItem(self, widget: PySide2.QtWidgets.QWidget, text: str) -> int: ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...
    def count(self) -> int: ...
    def currentIndex(self) -> int: ...
    def currentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def indexOf(self, widget: PySide2.QtWidgets.QWidget) -> int: ...
    @typing.overload
    def insertItem(self, index: int, widget: PySide2.QtWidgets.QWidget, icon: PySide2.QtGui.QIcon, text: str) -> int: ...
    @typing.overload
    def insertItem(self, index: int, widget: PySide2.QtWidgets.QWidget, text: str) -> int: ...
    def isItemEnabled(self, index: int) -> bool: ...
    def itemIcon(self, index: int) -> PySide2.QtGui.QIcon: ...
    def itemInserted(self, index: int) -> None: ...
    def itemRemoved(self, index: int) -> None: ...
    def itemText(self, index: int) -> str: ...
    def itemToolTip(self, index: int) -> str: ...
    def removeItem(self, index: int) -> None: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def setCurrentWidget(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def setItemEnabled(self, index: int, enabled: bool) -> None: ...
    def setItemIcon(self, index: int, icon: PySide2.QtGui.QIcon) -> None: ...
    def setItemText(self, index: int, text: str) -> None: ...
    def setItemToolTip(self, index: int, toolTip: str) -> None: ...
    def showEvent(self, e: PySide2.QtGui.QShowEvent) -> None: ...
    def widget(self, index: int) -> PySide2.QtWidgets.QWidget: ...


class QToolButton(PySide2.QtWidgets.QAbstractButton):
    DelayedPopup             : QToolButton.ToolButtonPopupMode = ... # 0x0
    MenuButtonPopup          : QToolButton.ToolButtonPopupMode = ... # 0x1
    InstantPopup             : QToolButton.ToolButtonPopupMode = ... # 0x2

    class ToolButtonPopupMode(Shiboken.Enum):
        DelayedPopup             : QToolButton.ToolButtonPopupMode = ... # 0x0
        MenuButtonPopup          : QToolButton.ToolButtonPopupMode = ... # 0x1
        InstantPopup             : QToolButton.ToolButtonPopupMode = ... # 0x2

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def actionEvent(self, arg__1: PySide2.QtGui.QActionEvent) -> None: ...
    def arrowType(self) -> PySide2.QtCore.Qt.ArrowType: ...
    def autoRaise(self) -> bool: ...
    def changeEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...
    def defaultAction(self) -> PySide2.QtWidgets.QAction: ...
    def enterEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def hitButton(self, pos: PySide2.QtCore.QPoint) -> bool: ...
    def initStyleOption(self, option: PySide2.QtWidgets.QStyleOptionToolButton) -> None: ...
    def leaveEvent(self, arg__1: PySide2.QtCore.QEvent) -> None: ...
    def menu(self) -> PySide2.QtWidgets.QMenu: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> None: ...
    def nextCheckState(self) -> None: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def popupMode(self) -> PySide2.QtWidgets.QToolButton.ToolButtonPopupMode: ...
    def setArrowType(self, type: PySide2.QtCore.Qt.ArrowType) -> None: ...
    def setAutoRaise(self, enable: bool) -> None: ...
    def setDefaultAction(self, arg__1: PySide2.QtWidgets.QAction) -> None: ...
    def setMenu(self, menu: PySide2.QtWidgets.QMenu) -> None: ...
    def setPopupMode(self, mode: PySide2.QtWidgets.QToolButton.ToolButtonPopupMode) -> None: ...
    def setToolButtonStyle(self, style: PySide2.QtCore.Qt.ToolButtonStyle) -> None: ...
    def showMenu(self) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def timerEvent(self, arg__1: PySide2.QtCore.QTimerEvent) -> None: ...
    def toolButtonStyle(self) -> PySide2.QtCore.Qt.ToolButtonStyle: ...


class QToolTip(Shiboken.Object):
    @staticmethod
    def font() -> PySide2.QtGui.QFont: ...
    @staticmethod
    def hideText() -> None: ...
    @staticmethod
    def isVisible() -> bool: ...
    @staticmethod
    def palette() -> PySide2.QtGui.QPalette: ...
    @staticmethod
    def setFont(arg__1: PySide2.QtGui.QFont) -> None: ...
    @staticmethod
    def setPalette(arg__1: PySide2.QtGui.QPalette) -> None: ...
    @typing.overload
    @staticmethod
    def showText(pos: PySide2.QtCore.QPoint, text: str, w: PySide2.QtWidgets.QWidget, rect: PySide2.QtCore.QRect) -> None: ...
    @typing.overload
    @staticmethod
    def showText(pos: PySide2.QtCore.QPoint, text: str, w: PySide2.QtWidgets.QWidget, rect: PySide2.QtCore.QRect, msecShowTime: int) -> None: ...
    @typing.overload
    @staticmethod
    def showText(pos: PySide2.QtCore.QPoint, text: str, w: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @staticmethod
    def text() -> str: ...


class QTreeView(PySide2.QtWidgets.QAbstractItemView):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def allColumnsShowFocus(self) -> bool: ...
    def autoExpandDelay(self) -> int: ...
    def collapse(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    def collapseAll(self) -> None: ...
    def columnAt(self, x: int) -> int: ...
    def columnCountChanged(self, oldCount: int, newCount: int) -> None: ...
    def columnMoved(self) -> None: ...
    def columnResized(self, column: int, oldSize: int, newSize: int) -> None: ...
    def columnViewportPosition(self, column: int) -> int: ...
    def columnWidth(self, column: int) -> int: ...
    def currentChanged(self, current: PySide2.QtCore.QModelIndex, previous: PySide2.QtCore.QModelIndex) -> None: ...
    def dataChanged(self, topLeft: PySide2.QtCore.QModelIndex, bottomRight: PySide2.QtCore.QModelIndex, roles: typing.List[int] = ...) -> None: ...
    def doItemsLayout(self) -> None: ...
    def dragMoveEvent(self, event: PySide2.QtGui.QDragMoveEvent) -> None: ...
    def drawBranches(self, painter: PySide2.QtGui.QPainter, rect: PySide2.QtCore.QRect, index: PySide2.QtCore.QModelIndex) -> None: ...
    def drawRow(self, painter: PySide2.QtGui.QPainter, options: PySide2.QtWidgets.QStyleOptionViewItem, index: PySide2.QtCore.QModelIndex) -> None: ...
    def drawTree(self, painter: PySide2.QtGui.QPainter, region: PySide2.QtGui.QRegion) -> None: ...
    def expand(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    def expandAll(self) -> None: ...
    def expandRecursively(self, index: PySide2.QtCore.QModelIndex, depth: int = ...) -> None: ...
    def expandToDepth(self, depth: int) -> None: ...
    def expandsOnDoubleClick(self) -> bool: ...
    def header(self) -> PySide2.QtWidgets.QHeaderView: ...
    def hideColumn(self, column: int) -> None: ...
    def horizontalOffset(self) -> int: ...
    def horizontalScrollbarAction(self, action: int) -> None: ...
    def indentation(self) -> int: ...
    def indexAbove(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def indexAt(self, p: PySide2.QtCore.QPoint) -> PySide2.QtCore.QModelIndex: ...
    def indexBelow(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def indexRowSizeHint(self, index: PySide2.QtCore.QModelIndex) -> int: ...
    def isAnimated(self) -> bool: ...
    def isColumnHidden(self, column: int) -> bool: ...
    def isExpanded(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def isFirstColumnSpanned(self, row: int, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def isHeaderHidden(self) -> bool: ...
    def isIndexHidden(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def isRowHidden(self, row: int, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def isSortingEnabled(self) -> bool: ...
    def itemsExpandable(self) -> bool: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyboardSearch(self, search: str) -> None: ...
    def mouseDoubleClickEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def moveCursor(self, cursorAction: PySide2.QtWidgets.QAbstractItemView.CursorAction, modifiers: PySide2.QtCore.Qt.KeyboardModifiers) -> PySide2.QtCore.QModelIndex: ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent) -> None: ...
    def reexpand(self) -> None: ...
    def reset(self) -> None: ...
    def resetIndentation(self) -> None: ...
    def resizeColumnToContents(self, column: int) -> None: ...
    def rootIsDecorated(self) -> bool: ...
    def rowHeight(self, index: PySide2.QtCore.QModelIndex) -> int: ...
    def rowsAboutToBeRemoved(self, parent: PySide2.QtCore.QModelIndex, start: int, end: int) -> None: ...
    def rowsInserted(self, parent: PySide2.QtCore.QModelIndex, start: int, end: int) -> None: ...
    def rowsRemoved(self, parent: PySide2.QtCore.QModelIndex, first: int, last: int) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def scrollTo(self, index: PySide2.QtCore.QModelIndex, hint: PySide2.QtWidgets.QAbstractItemView.ScrollHint = ...) -> None: ...
    def selectAll(self) -> None: ...
    def selectedIndexes(self) -> typing.List[int]: ...
    def selectionChanged(self, selected: PySide2.QtCore.QItemSelection, deselected: PySide2.QtCore.QItemSelection) -> None: ...
    def setAllColumnsShowFocus(self, enable: bool) -> None: ...
    def setAnimated(self, enable: bool) -> None: ...
    def setAutoExpandDelay(self, delay: int) -> None: ...
    def setColumnHidden(self, column: int, hide: bool) -> None: ...
    def setColumnWidth(self, column: int, width: int) -> None: ...
    def setExpanded(self, index: PySide2.QtCore.QModelIndex, expand: bool) -> None: ...
    def setExpandsOnDoubleClick(self, enable: bool) -> None: ...
    def setFirstColumnSpanned(self, row: int, parent: PySide2.QtCore.QModelIndex, span: bool) -> None: ...
    def setHeader(self, header: PySide2.QtWidgets.QHeaderView) -> None: ...
    def setHeaderHidden(self, hide: bool) -> None: ...
    def setIndentation(self, i: int) -> None: ...
    def setItemsExpandable(self, enable: bool) -> None: ...
    def setModel(self, model: PySide2.QtCore.QAbstractItemModel) -> None: ...
    def setRootIndex(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    def setRootIsDecorated(self, show: bool) -> None: ...
    def setRowHidden(self, row: int, parent: PySide2.QtCore.QModelIndex, hide: bool) -> None: ...
    def setSelection(self, rect: PySide2.QtCore.QRect, command: PySide2.QtCore.QItemSelectionModel.SelectionFlags) -> None: ...
    def setSelectionModel(self, selectionModel: PySide2.QtCore.QItemSelectionModel) -> None: ...
    def setSortingEnabled(self, enable: bool) -> None: ...
    def setTreePosition(self, logicalIndex: int) -> None: ...
    def setUniformRowHeights(self, uniform: bool) -> None: ...
    def setWordWrap(self, on: bool) -> None: ...
    def showColumn(self, column: int) -> None: ...
    def sizeHintForColumn(self, column: int) -> int: ...
    @typing.overload
    def sortByColumn(self, column: int) -> None: ...
    @typing.overload
    def sortByColumn(self, column: int, order: PySide2.QtCore.Qt.SortOrder) -> None: ...
    def timerEvent(self, event: PySide2.QtCore.QTimerEvent) -> None: ...
    def treePosition(self) -> int: ...
    def uniformRowHeights(self) -> bool: ...
    def updateGeometries(self) -> None: ...
    def verticalOffset(self) -> int: ...
    def verticalScrollbarValueChanged(self, value: int) -> None: ...
    def viewportEvent(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def viewportSizeHint(self) -> PySide2.QtCore.QSize: ...
    def visualRect(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide2.QtCore.QItemSelection) -> PySide2.QtGui.QRegion: ...
    def wordWrap(self) -> bool: ...


class QTreeWidget(PySide2.QtWidgets.QTreeView):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def addTopLevelItem(self, item: PySide2.QtWidgets.QTreeWidgetItem) -> None: ...
    def addTopLevelItems(self, items: typing.Sequence[PySide2.QtWidgets.QTreeWidgetItem]) -> None: ...
    def clear(self) -> None: ...
    @typing.overload
    def closePersistentEditor(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    @typing.overload
    def closePersistentEditor(self, item: PySide2.QtWidgets.QTreeWidgetItem, column: int = ...) -> None: ...
    def collapseItem(self, item: PySide2.QtWidgets.QTreeWidgetItem) -> None: ...
    def columnCount(self) -> int: ...
    def currentColumn(self) -> int: ...
    def currentItem(self) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def dropEvent(self, event: PySide2.QtGui.QDropEvent) -> None: ...
    def dropMimeData(self, parent: PySide2.QtWidgets.QTreeWidgetItem, index: int, data: PySide2.QtCore.QMimeData, action: PySide2.QtCore.Qt.DropAction) -> bool: ...
    def editItem(self, item: PySide2.QtWidgets.QTreeWidgetItem, column: int = ...) -> None: ...
    def event(self, e: PySide2.QtCore.QEvent) -> bool: ...
    def expandItem(self, item: PySide2.QtWidgets.QTreeWidgetItem) -> None: ...
    def findItems(self, text: str, flags: PySide2.QtCore.Qt.MatchFlags, column: int = ...) -> typing.List[PySide2.QtWidgets.QTreeWidgetItem]: ...
    def headerItem(self) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def indexFromItem(self, item: PySide2.QtWidgets.QTreeWidgetItem, column: int = ...) -> PySide2.QtCore.QModelIndex: ...
    def indexOfTopLevelItem(self, item: PySide2.QtWidgets.QTreeWidgetItem) -> int: ...
    def insertTopLevelItem(self, index: int, item: PySide2.QtWidgets.QTreeWidgetItem) -> None: ...
    def insertTopLevelItems(self, index: int, items: typing.Sequence[PySide2.QtWidgets.QTreeWidgetItem]) -> None: ...
    def invisibleRootItem(self) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def isFirstItemColumnSpanned(self, item: PySide2.QtWidgets.QTreeWidgetItem) -> bool: ...
    def isItemExpanded(self, item: PySide2.QtWidgets.QTreeWidgetItem) -> bool: ...
    def isItemHidden(self, item: PySide2.QtWidgets.QTreeWidgetItem) -> bool: ...
    def isItemSelected(self, item: PySide2.QtWidgets.QTreeWidgetItem) -> bool: ...
    @typing.overload
    def isPersistentEditorOpen(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    @typing.overload
    def isPersistentEditorOpen(self, item: PySide2.QtWidgets.QTreeWidgetItem, column: int = ...) -> bool: ...
    def itemAbove(self, item: PySide2.QtWidgets.QTreeWidgetItem) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    @typing.overload
    def itemAt(self, p: PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    @typing.overload
    def itemAt(self, x: int, y: int) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def itemBelow(self, item: PySide2.QtWidgets.QTreeWidgetItem) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def itemFromIndex(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def itemWidget(self, item: PySide2.QtWidgets.QTreeWidgetItem, column: int) -> PySide2.QtWidgets.QWidget: ...
    def items(self, data: PySide2.QtCore.QMimeData) -> typing.List[PySide2.QtWidgets.QTreeWidgetItem]: ...
    def mimeData(self, items: typing.Sequence[PySide2.QtWidgets.QTreeWidgetItem]) -> PySide2.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    @typing.overload
    def openPersistentEditor(self, index: PySide2.QtCore.QModelIndex) -> None: ...
    @typing.overload
    def openPersistentEditor(self, item: PySide2.QtWidgets.QTreeWidgetItem, column: int = ...) -> None: ...
    def removeItemWidget(self, item: PySide2.QtWidgets.QTreeWidgetItem, column: int) -> None: ...
    def scrollToItem(self, item: PySide2.QtWidgets.QTreeWidgetItem, hint: PySide2.QtWidgets.QAbstractItemView.ScrollHint = ...) -> None: ...
    def selectedItems(self) -> typing.List[PySide2.QtWidgets.QTreeWidgetItem]: ...
    def setColumnCount(self, columns: int) -> None: ...
    @typing.overload
    def setCurrentItem(self, item: PySide2.QtWidgets.QTreeWidgetItem) -> None: ...
    @typing.overload
    def setCurrentItem(self, item: PySide2.QtWidgets.QTreeWidgetItem, column: int) -> None: ...
    @typing.overload
    def setCurrentItem(self, item: PySide2.QtWidgets.QTreeWidgetItem, column: int, command: PySide2.QtCore.QItemSelectionModel.SelectionFlags) -> None: ...
    def setFirstItemColumnSpanned(self, item: PySide2.QtWidgets.QTreeWidgetItem, span: bool) -> None: ...
    def setHeaderItem(self, item: PySide2.QtWidgets.QTreeWidgetItem) -> None: ...
    def setHeaderLabel(self, label: str) -> None: ...
    def setHeaderLabels(self, labels: typing.Sequence[str]) -> None: ...
    def setItemExpanded(self, item: PySide2.QtWidgets.QTreeWidgetItem, expand: bool) -> None: ...
    def setItemHidden(self, item: PySide2.QtWidgets.QTreeWidgetItem, hide: bool) -> None: ...
    def setItemSelected(self, item: PySide2.QtWidgets.QTreeWidgetItem, select: bool) -> None: ...
    def setItemWidget(self, item: PySide2.QtWidgets.QTreeWidgetItem, column: int, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def setModel(self, model: PySide2.QtCore.QAbstractItemModel) -> None: ...
    def setSelectionModel(self, selectionModel: PySide2.QtCore.QItemSelectionModel) -> None: ...
    def sortColumn(self) -> int: ...
    def sortItems(self, column: int, order: PySide2.QtCore.Qt.SortOrder) -> None: ...
    def supportedDropActions(self) -> PySide2.QtCore.Qt.DropActions: ...
    def takeTopLevelItem(self, index: int) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def topLevelItem(self, index: int) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def topLevelItemCount(self) -> int: ...
    def visualItemRect(self, item: PySide2.QtWidgets.QTreeWidgetItem) -> PySide2.QtCore.QRect: ...


class QTreeWidgetItem(Shiboken.Object):
    ShowIndicator            : QTreeWidgetItem.ChildIndicatorPolicy = ... # 0x0
    DontShowIndicator        : QTreeWidgetItem.ChildIndicatorPolicy = ... # 0x1
    DontShowIndicatorWhenChildless: QTreeWidgetItem.ChildIndicatorPolicy = ... # 0x2
    Type                     : QTreeWidgetItem.ItemType = ... # 0x0
    UserType                 : QTreeWidgetItem.ItemType = ... # 0x3e8

    class ChildIndicatorPolicy(Shiboken.Enum):
        ShowIndicator            : QTreeWidgetItem.ChildIndicatorPolicy = ... # 0x0
        DontShowIndicator        : QTreeWidgetItem.ChildIndicatorPolicy = ... # 0x1
        DontShowIndicatorWhenChildless: QTreeWidgetItem.ChildIndicatorPolicy = ... # 0x2

    class ItemType(Shiboken.Enum):
        Type                     : QTreeWidgetItem.ItemType = ... # 0x0
        UserType                 : QTreeWidgetItem.ItemType = ... # 0x3e8

    @typing.overload
    def __init__(self, other: PySide2.QtWidgets.QTreeWidgetItem) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QTreeWidgetItem, after: PySide2.QtWidgets.QTreeWidgetItem, type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QTreeWidgetItem, strings: typing.Sequence[str], type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QTreeWidgetItem, type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, strings: typing.Sequence[str], type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, treeview: PySide2.QtWidgets.QTreeWidget, after: PySide2.QtWidgets.QTreeWidgetItem, type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, treeview: PySide2.QtWidgets.QTreeWidget, strings: typing.Sequence[str], type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, treeview: PySide2.QtWidgets.QTreeWidget, type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, type: int = ...) -> None: ...

    def __lshift__(self, out: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, in_: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def addChild(self, child: PySide2.QtWidgets.QTreeWidgetItem) -> None: ...
    def addChildren(self, children: typing.Sequence[PySide2.QtWidgets.QTreeWidgetItem]) -> None: ...
    def background(self, column: int) -> PySide2.QtGui.QBrush: ...
    def backgroundColor(self, column: int) -> PySide2.QtGui.QColor: ...
    def checkState(self, column: int) -> PySide2.QtCore.Qt.CheckState: ...
    def child(self, index: int) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def childCount(self) -> int: ...
    def childIndicatorPolicy(self) -> PySide2.QtWidgets.QTreeWidgetItem.ChildIndicatorPolicy: ...
    def clone(self) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def columnCount(self) -> int: ...
    def data(self, column: int, role: int) -> typing.Any: ...
    def emitDataChanged(self) -> None: ...
    def flags(self) -> PySide2.QtCore.Qt.ItemFlags: ...
    def font(self, column: int) -> PySide2.QtGui.QFont: ...
    def foreground(self, column: int) -> PySide2.QtGui.QBrush: ...
    def icon(self, column: int) -> PySide2.QtGui.QIcon: ...
    def indexOfChild(self, child: PySide2.QtWidgets.QTreeWidgetItem) -> int: ...
    def insertChild(self, index: int, child: PySide2.QtWidgets.QTreeWidgetItem) -> None: ...
    def insertChildren(self, index: int, children: typing.Sequence[PySide2.QtWidgets.QTreeWidgetItem]) -> None: ...
    def isDisabled(self) -> bool: ...
    def isExpanded(self) -> bool: ...
    def isFirstColumnSpanned(self) -> bool: ...
    def isHidden(self) -> bool: ...
    def isSelected(self) -> bool: ...
    def parent(self) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def read(self, in_: PySide2.QtCore.QDataStream) -> None: ...
    def removeChild(self, child: PySide2.QtWidgets.QTreeWidgetItem) -> None: ...
    def setBackground(self, column: int, brush: PySide2.QtGui.QBrush) -> None: ...
    def setBackgroundColor(self, column: int, color: PySide2.QtGui.QColor) -> None: ...
    def setCheckState(self, column: int, state: PySide2.QtCore.Qt.CheckState) -> None: ...
    def setChildIndicatorPolicy(self, policy: PySide2.QtWidgets.QTreeWidgetItem.ChildIndicatorPolicy) -> None: ...
    def setData(self, column: int, role: int, value: typing.Any) -> None: ...
    def setDisabled(self, disabled: bool) -> None: ...
    def setExpanded(self, expand: bool) -> None: ...
    def setFirstColumnSpanned(self, span: bool) -> None: ...
    def setFlags(self, flags: PySide2.QtCore.Qt.ItemFlags) -> None: ...
    def setFont(self, column: int, font: PySide2.QtGui.QFont) -> None: ...
    def setForeground(self, column: int, brush: PySide2.QtGui.QBrush) -> None: ...
    def setHidden(self, hide: bool) -> None: ...
    def setIcon(self, column: int, icon: PySide2.QtGui.QIcon) -> None: ...
    def setSelected(self, select: bool) -> None: ...
    def setSizeHint(self, column: int, size: PySide2.QtCore.QSize) -> None: ...
    def setStatusTip(self, column: int, statusTip: str) -> None: ...
    def setText(self, column: int, text: str) -> None: ...
    def setTextAlignment(self, column: int, alignment: int) -> None: ...
    def setTextColor(self, column: int, color: PySide2.QtGui.QColor) -> None: ...
    def setToolTip(self, column: int, toolTip: str) -> None: ...
    def setWhatsThis(self, column: int, whatsThis: str) -> None: ...
    def sizeHint(self, column: int) -> PySide2.QtCore.QSize: ...
    def sortChildren(self, column: int, order: PySide2.QtCore.Qt.SortOrder) -> None: ...
    def statusTip(self, column: int) -> str: ...
    def takeChild(self, index: int) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def takeChildren(self) -> typing.List[PySide2.QtWidgets.QTreeWidgetItem]: ...
    def text(self, column: int) -> str: ...
    def textAlignment(self, column: int) -> int: ...
    def textColor(self, column: int) -> PySide2.QtGui.QColor: ...
    def toolTip(self, column: int) -> str: ...
    def treeWidget(self) -> PySide2.QtWidgets.QTreeWidget: ...
    def type(self) -> int: ...
    def whatsThis(self, column: int) -> str: ...
    def write(self, out: PySide2.QtCore.QDataStream) -> None: ...


class QTreeWidgetItemIterator(Shiboken.Object):
    All                      : QTreeWidgetItemIterator.IteratorFlag = ... # 0x0
    Hidden                   : QTreeWidgetItemIterator.IteratorFlag = ... # 0x1
    NotHidden                : QTreeWidgetItemIterator.IteratorFlag = ... # 0x2
    Selected                 : QTreeWidgetItemIterator.IteratorFlag = ... # 0x4
    Unselected               : QTreeWidgetItemIterator.IteratorFlag = ... # 0x8
    Selectable               : QTreeWidgetItemIterator.IteratorFlag = ... # 0x10
    NotSelectable            : QTreeWidgetItemIterator.IteratorFlag = ... # 0x20
    DragEnabled              : QTreeWidgetItemIterator.IteratorFlag = ... # 0x40
    DragDisabled             : QTreeWidgetItemIterator.IteratorFlag = ... # 0x80
    DropEnabled              : QTreeWidgetItemIterator.IteratorFlag = ... # 0x100
    DropDisabled             : QTreeWidgetItemIterator.IteratorFlag = ... # 0x200
    HasChildren              : QTreeWidgetItemIterator.IteratorFlag = ... # 0x400
    NoChildren               : QTreeWidgetItemIterator.IteratorFlag = ... # 0x800
    Checked                  : QTreeWidgetItemIterator.IteratorFlag = ... # 0x1000
    NotChecked               : QTreeWidgetItemIterator.IteratorFlag = ... # 0x2000
    Enabled                  : QTreeWidgetItemIterator.IteratorFlag = ... # 0x4000
    Disabled                 : QTreeWidgetItemIterator.IteratorFlag = ... # 0x8000
    Editable                 : QTreeWidgetItemIterator.IteratorFlag = ... # 0x10000
    NotEditable              : QTreeWidgetItemIterator.IteratorFlag = ... # 0x20000
    UserFlag                 : QTreeWidgetItemIterator.IteratorFlag = ... # 0x1000000

    class IteratorFlag(Shiboken.Enum):
        All                      : QTreeWidgetItemIterator.IteratorFlag = ... # 0x0
        Hidden                   : QTreeWidgetItemIterator.IteratorFlag = ... # 0x1
        NotHidden                : QTreeWidgetItemIterator.IteratorFlag = ... # 0x2
        Selected                 : QTreeWidgetItemIterator.IteratorFlag = ... # 0x4
        Unselected               : QTreeWidgetItemIterator.IteratorFlag = ... # 0x8
        Selectable               : QTreeWidgetItemIterator.IteratorFlag = ... # 0x10
        NotSelectable            : QTreeWidgetItemIterator.IteratorFlag = ... # 0x20
        DragEnabled              : QTreeWidgetItemIterator.IteratorFlag = ... # 0x40
        DragDisabled             : QTreeWidgetItemIterator.IteratorFlag = ... # 0x80
        DropEnabled              : QTreeWidgetItemIterator.IteratorFlag = ... # 0x100
        DropDisabled             : QTreeWidgetItemIterator.IteratorFlag = ... # 0x200
        HasChildren              : QTreeWidgetItemIterator.IteratorFlag = ... # 0x400
        NoChildren               : QTreeWidgetItemIterator.IteratorFlag = ... # 0x800
        Checked                  : QTreeWidgetItemIterator.IteratorFlag = ... # 0x1000
        NotChecked               : QTreeWidgetItemIterator.IteratorFlag = ... # 0x2000
        Enabled                  : QTreeWidgetItemIterator.IteratorFlag = ... # 0x4000
        Disabled                 : QTreeWidgetItemIterator.IteratorFlag = ... # 0x8000
        Editable                 : QTreeWidgetItemIterator.IteratorFlag = ... # 0x10000
        NotEditable              : QTreeWidgetItemIterator.IteratorFlag = ... # 0x20000
        UserFlag                 : QTreeWidgetItemIterator.IteratorFlag = ... # 0x1000000

    class IteratorFlags(object): ...

    @typing.overload
    def __init__(self, it: PySide2.QtWidgets.QTreeWidgetItemIterator) -> None: ...
    @typing.overload
    def __init__(self, item: PySide2.QtWidgets.QTreeWidgetItem, flags: PySide2.QtWidgets.QTreeWidgetItemIterator.IteratorFlags = ...) -> None: ...
    @typing.overload
    def __init__(self, widget: PySide2.QtWidgets.QTreeWidget, flags: PySide2.QtWidgets.QTreeWidgetItemIterator.IteratorFlags = ...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, n: int) -> PySide2.QtWidgets.QTreeWidgetItemIterator: ...
    def __isub__(self, n: int) -> PySide2.QtWidgets.QTreeWidgetItemIterator: ...
    def __iter__(self) -> object: ...
    def __next__(self) -> object: ...
    def value(self) -> PySide2.QtWidgets.QTreeWidgetItem: ...


class QUndoCommand(Shiboken.Object):

    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QUndoCommand] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[PySide2.QtWidgets.QUndoCommand] = ...) -> None: ...

    def actionText(self) -> str: ...
    def child(self, index: int) -> PySide2.QtWidgets.QUndoCommand: ...
    def childCount(self) -> int: ...
    def id(self) -> int: ...
    def isObsolete(self) -> bool: ...
    def mergeWith(self, other: PySide2.QtWidgets.QUndoCommand) -> bool: ...
    def redo(self) -> None: ...
    def setObsolete(self, obsolete: bool) -> None: ...
    def setText(self, text: str) -> None: ...
    def text(self) -> str: ...
    def undo(self) -> None: ...


class QUndoGroup(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def activeStack(self) -> PySide2.QtWidgets.QUndoStack: ...
    def addStack(self, stack: PySide2.QtWidgets.QUndoStack) -> None: ...
    def canRedo(self) -> bool: ...
    def canUndo(self) -> bool: ...
    def createRedoAction(self, parent: PySide2.QtCore.QObject, prefix: str = ...) -> PySide2.QtWidgets.QAction: ...
    def createUndoAction(self, parent: PySide2.QtCore.QObject, prefix: str = ...) -> PySide2.QtWidgets.QAction: ...
    def isClean(self) -> bool: ...
    def redo(self) -> None: ...
    def redoText(self) -> str: ...
    def removeStack(self, stack: PySide2.QtWidgets.QUndoStack) -> None: ...
    def setActiveStack(self, stack: PySide2.QtWidgets.QUndoStack) -> None: ...
    def stacks(self) -> typing.List[PySide2.QtWidgets.QUndoStack]: ...
    def undo(self) -> None: ...
    def undoText(self) -> str: ...


class QUndoStack(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def beginMacro(self, text: str) -> None: ...
    def canRedo(self) -> bool: ...
    def canUndo(self) -> bool: ...
    def cleanIndex(self) -> int: ...
    def clear(self) -> None: ...
    def command(self, index: int) -> PySide2.QtWidgets.QUndoCommand: ...
    def count(self) -> int: ...
    def createRedoAction(self, parent: PySide2.QtCore.QObject, prefix: str = ...) -> PySide2.QtWidgets.QAction: ...
    def createUndoAction(self, parent: PySide2.QtCore.QObject, prefix: str = ...) -> PySide2.QtWidgets.QAction: ...
    def endMacro(self) -> None: ...
    def index(self) -> int: ...
    def isActive(self) -> bool: ...
    def isClean(self) -> bool: ...
    def push(self, cmd: PySide2.QtWidgets.QUndoCommand) -> None: ...
    def redo(self) -> None: ...
    def redoText(self) -> str: ...
    def resetClean(self) -> None: ...
    def setActive(self, active: bool = ...) -> None: ...
    def setClean(self) -> None: ...
    def setIndex(self, idx: int) -> None: ...
    def setUndoLimit(self, limit: int) -> None: ...
    def text(self, idx: int) -> str: ...
    def undo(self) -> None: ...
    def undoLimit(self) -> int: ...
    def undoText(self) -> str: ...


class QUndoView(PySide2.QtWidgets.QListView):

    @typing.overload
    def __init__(self, group: PySide2.QtWidgets.QUndoGroup, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, stack: PySide2.QtWidgets.QUndoStack, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def cleanIcon(self) -> PySide2.QtGui.QIcon: ...
    def emptyLabel(self) -> str: ...
    def group(self) -> PySide2.QtWidgets.QUndoGroup: ...
    def setCleanIcon(self, icon: PySide2.QtGui.QIcon) -> None: ...
    def setEmptyLabel(self, label: str) -> None: ...
    def setGroup(self, group: PySide2.QtWidgets.QUndoGroup) -> None: ...
    def setStack(self, stack: PySide2.QtWidgets.QUndoStack) -> None: ...
    def stack(self) -> PySide2.QtWidgets.QUndoStack: ...


class QVBoxLayout(PySide2.QtWidgets.QBoxLayout):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide2.QtWidgets.QWidget) -> None: ...


class QWhatsThis(Shiboken.Object):
    @staticmethod
    def createAction(parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> PySide2.QtWidgets.QAction: ...
    @staticmethod
    def enterWhatsThisMode() -> None: ...
    @staticmethod
    def hideText() -> None: ...
    @staticmethod
    def inWhatsThisMode() -> bool: ...
    @staticmethod
    def leaveWhatsThisMode() -> None: ...
    @staticmethod
    def showText(pos: PySide2.QtCore.QPoint, text: str, w: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...


class QWidget(PySide2.QtCore.QObject, PySide2.QtGui.QPaintDevice):
    DrawWindowBackground     : QWidget.RenderFlag = ... # 0x1
    DrawChildren             : QWidget.RenderFlag = ... # 0x2
    IgnoreMask               : QWidget.RenderFlag = ... # 0x4

    class RenderFlag(Shiboken.Enum):
        DrawWindowBackground     : QWidget.RenderFlag = ... # 0x1
        DrawChildren             : QWidget.RenderFlag = ... # 0x2
        IgnoreMask               : QWidget.RenderFlag = ... # 0x4

    class RenderFlags(object): ...

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., f: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...

    def acceptDrops(self) -> bool: ...
    def accessibleDescription(self) -> str: ...
    def accessibleName(self) -> str: ...
    def actionEvent(self, event: PySide2.QtGui.QActionEvent) -> None: ...
    def actions(self) -> typing.List[PySide2.QtWidgets.QAction]: ...
    def activateWindow(self) -> None: ...
    def addAction(self, action: PySide2.QtWidgets.QAction) -> None: ...
    def addActions(self, actions: typing.Sequence[PySide2.QtWidgets.QAction]) -> None: ...
    def adjustSize(self) -> None: ...
    def autoFillBackground(self) -> bool: ...
    def backgroundRole(self) -> PySide2.QtGui.QPalette.ColorRole: ...
    def backingStore(self) -> PySide2.QtGui.QBackingStore: ...
    def baseSize(self) -> PySide2.QtCore.QSize: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    @typing.overload
    def childAt(self, p: PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QWidget: ...
    @typing.overload
    def childAt(self, x: int, y: int) -> PySide2.QtWidgets.QWidget: ...
    def childrenRect(self) -> PySide2.QtCore.QRect: ...
    def childrenRegion(self) -> PySide2.QtGui.QRegion: ...
    def clearFocus(self) -> None: ...
    def clearMask(self) -> None: ...
    def close(self) -> bool: ...
    def closeEvent(self, event: PySide2.QtGui.QCloseEvent) -> None: ...
    def contentsMargins(self) -> PySide2.QtCore.QMargins: ...
    def contentsRect(self) -> PySide2.QtCore.QRect: ...
    def contextMenuEvent(self, event: PySide2.QtGui.QContextMenuEvent) -> None: ...
    def contextMenuPolicy(self) -> PySide2.QtCore.Qt.ContextMenuPolicy: ...
    def create(self, arg__1: int = ..., initializeWindow: bool = ..., destroyOldWindow: bool = ...) -> None: ...
    def createWinId(self) -> None: ...
    @staticmethod
    def createWindowContainer(window: PySide2.QtGui.QWindow, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> PySide2.QtWidgets.QWidget: ...
    def cursor(self) -> PySide2.QtGui.QCursor: ...
    def destroy(self, destroyWindow: bool = ..., destroySubWindows: bool = ...) -> None: ...
    def devType(self) -> int: ...
    def dragEnterEvent(self, event: PySide2.QtGui.QDragEnterEvent) -> None: ...
    def dragLeaveEvent(self, event: PySide2.QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, event: PySide2.QtGui.QDragMoveEvent) -> None: ...
    def dropEvent(self, event: PySide2.QtGui.QDropEvent) -> None: ...
    def effectiveWinId(self) -> int: ...
    def ensurePolished(self) -> None: ...
    def enterEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    @staticmethod
    def find(arg__1: int) -> PySide2.QtWidgets.QWidget: ...
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusNextChild(self) -> bool: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent) -> None: ...
    def focusPolicy(self) -> PySide2.QtCore.Qt.FocusPolicy: ...
    def focusPreviousChild(self) -> bool: ...
    def focusProxy(self) -> PySide2.QtWidgets.QWidget: ...
    def focusWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def fontInfo(self) -> PySide2.QtGui.QFontInfo: ...
    def fontMetrics(self) -> PySide2.QtGui.QFontMetrics: ...
    def foregroundRole(self) -> PySide2.QtGui.QPalette.ColorRole: ...
    def frameGeometry(self) -> PySide2.QtCore.QRect: ...
    def frameSize(self) -> PySide2.QtCore.QSize: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def getContentsMargins(self) -> typing.Tuple[int, int, int, int]: ...
    def grab(self, rectangle: PySide2.QtCore.QRect = ...) -> PySide2.QtGui.QPixmap: ...
    def grabGesture(self, type: PySide2.QtCore.Qt.GestureType, flags: PySide2.QtCore.Qt.GestureFlags = ...) -> None: ...
    def grabKeyboard(self) -> None: ...
    @typing.overload
    def grabMouse(self) -> None: ...
    @typing.overload
    def grabMouse(self, arg__1: PySide2.QtGui.QCursor) -> None: ...
    def grabShortcut(self, key: PySide2.QtGui.QKeySequence, context: PySide2.QtCore.Qt.ShortcutContext = ...) -> int: ...
    def graphicsEffect(self) -> PySide2.QtWidgets.QGraphicsEffect: ...
    def graphicsProxyWidget(self) -> PySide2.QtWidgets.QGraphicsProxyWidget: ...
    def hasFocus(self) -> bool: ...
    def hasHeightForWidth(self) -> bool: ...
    def hasMouseTracking(self) -> bool: ...
    def hasTabletTracking(self) -> bool: ...
    def height(self) -> int: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def hide(self) -> None: ...
    def hideEvent(self, event: PySide2.QtGui.QHideEvent) -> None: ...
    def initPainter(self, painter: PySide2.QtGui.QPainter) -> None: ...
    def inputMethodEvent(self, event: PySide2.QtGui.QInputMethodEvent) -> None: ...
    def inputMethodHints(self) -> PySide2.QtCore.Qt.InputMethodHints: ...
    def inputMethodQuery(self, arg__1: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def insertAction(self, before: PySide2.QtWidgets.QAction, action: PySide2.QtWidgets.QAction) -> None: ...
    def insertActions(self, before: PySide2.QtWidgets.QAction, actions: typing.Sequence[PySide2.QtWidgets.QAction]) -> None: ...
    def internalWinId(self) -> int: ...
    def isActiveWindow(self) -> bool: ...
    def isAncestorOf(self, child: PySide2.QtWidgets.QWidget) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isEnabledTo(self, arg__1: PySide2.QtWidgets.QWidget) -> bool: ...
    def isEnabledToTLW(self) -> bool: ...
    def isFullScreen(self) -> bool: ...
    def isHidden(self) -> bool: ...
    def isLeftToRight(self) -> bool: ...
    def isMaximized(self) -> bool: ...
    def isMinimized(self) -> bool: ...
    def isModal(self) -> bool: ...
    def isRightToLeft(self) -> bool: ...
    def isTopLevel(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def isVisibleTo(self, arg__1: PySide2.QtWidgets.QWidget) -> bool: ...
    def isWindow(self) -> bool: ...
    def isWindowModified(self) -> bool: ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, event: PySide2.QtGui.QKeyEvent) -> None: ...
    @staticmethod
    def keyboardGrabber() -> PySide2.QtWidgets.QWidget: ...
    def layout(self) -> PySide2.QtWidgets.QLayout: ...
    def layoutDirection(self) -> PySide2.QtCore.Qt.LayoutDirection: ...
    def leaveEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def locale(self) -> PySide2.QtCore.QLocale: ...
    def lower(self) -> None: ...
    def mapFrom(self, arg__1: PySide2.QtWidgets.QWidget, arg__2: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    def mapFromGlobal(self, arg__1: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    def mapFromParent(self, arg__1: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    def mapTo(self, arg__1: PySide2.QtWidgets.QWidget, arg__2: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    def mapToGlobal(self, arg__1: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    def mapToParent(self, arg__1: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    def mask(self) -> PySide2.QtGui.QRegion: ...
    def maximumHeight(self) -> int: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def maximumWidth(self) -> int: ...
    def metric(self, arg__1: PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def minimumHeight(self) -> int: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def minimumWidth(self) -> int: ...
    def mouseDoubleClickEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    @staticmethod
    def mouseGrabber() -> PySide2.QtWidgets.QWidget: ...
    def mouseMoveEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide2.QtGui.QMouseEvent) -> None: ...
    @typing.overload
    def move(self, arg__1: PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def move(self, x: int, y: int) -> None: ...
    def moveEvent(self, event: PySide2.QtGui.QMoveEvent) -> None: ...
    def nativeEvent(self, eventType: PySide2.QtCore.QByteArray, message: int) -> typing.Tuple[bool, int]: ...
    def nativeParentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def nextInFocusChain(self) -> PySide2.QtWidgets.QWidget: ...
    def normalGeometry(self) -> PySide2.QtCore.QRect: ...
    def overrideWindowFlags(self, type: PySide2.QtCore.Qt.WindowFlags) -> None: ...
    def overrideWindowState(self, state: PySide2.QtCore.Qt.WindowStates) -> None: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent) -> None: ...
    def palette(self) -> PySide2.QtGui.QPalette: ...
    def parentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def previousInFocusChain(self) -> PySide2.QtWidgets.QWidget: ...
    def raise_(self) -> None: ...
    def rect(self) -> PySide2.QtCore.QRect: ...
    def redirected(self, offset: PySide2.QtCore.QPoint) -> PySide2.QtGui.QPaintDevice: ...
    def releaseKeyboard(self) -> None: ...
    def releaseMouse(self) -> None: ...
    def releaseShortcut(self, id: int) -> None: ...
    def removeAction(self, action: PySide2.QtWidgets.QAction) -> None: ...
    @typing.overload
    def render(self, painter: PySide2.QtGui.QPainter, targetOffset: PySide2.QtCore.QPoint, sourceRegion: PySide2.QtGui.QRegion = ..., renderFlags: PySide2.QtWidgets.QWidget.RenderFlags = ...) -> None: ...
    @typing.overload
    def render(self, target: PySide2.QtGui.QPaintDevice, targetOffset: PySide2.QtCore.QPoint = ..., sourceRegion: PySide2.QtGui.QRegion = ..., renderFlags: PySide2.QtWidgets.QWidget.RenderFlags = ...) -> None: ...
    @typing.overload
    def repaint(self) -> None: ...
    @typing.overload
    def repaint(self, arg__1: PySide2.QtCore.QRect) -> None: ...
    @typing.overload
    def repaint(self, arg__1: PySide2.QtGui.QRegion) -> None: ...
    @typing.overload
    def repaint(self, x: int, y: int, w: int, h: int) -> None: ...
    @typing.overload
    def resize(self, arg__1: PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def resize(self, w: int, h: int) -> None: ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent) -> None: ...
    def restoreGeometry(self, geometry: PySide2.QtCore.QByteArray) -> bool: ...
    def saveGeometry(self) -> PySide2.QtCore.QByteArray: ...
    def screen(self) -> PySide2.QtGui.QScreen: ...
    @typing.overload
    def scroll(self, dx: int, dy: int) -> None: ...
    @typing.overload
    def scroll(self, dx: int, dy: int, arg__3: PySide2.QtCore.QRect) -> None: ...
    def setAcceptDrops(self, on: bool) -> None: ...
    def setAccessibleDescription(self, description: str) -> None: ...
    def setAccessibleName(self, name: str) -> None: ...
    def setAttribute(self, arg__1: PySide2.QtCore.Qt.WidgetAttribute, on: bool = ...) -> None: ...
    def setAutoFillBackground(self, enabled: bool) -> None: ...
    def setBackgroundRole(self, arg__1: PySide2.QtGui.QPalette.ColorRole) -> None: ...
    @typing.overload
    def setBaseSize(self, arg__1: PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def setBaseSize(self, basew: int, baseh: int) -> None: ...
    @typing.overload
    def setContentsMargins(self, left: int, top: int, right: int, bottom: int) -> None: ...
    @typing.overload
    def setContentsMargins(self, margins: PySide2.QtCore.QMargins) -> None: ...
    def setContextMenuPolicy(self, policy: PySide2.QtCore.Qt.ContextMenuPolicy) -> None: ...
    def setCursor(self, arg__1: PySide2.QtGui.QCursor) -> None: ...
    def setDisabled(self, arg__1: bool) -> None: ...
    def setEnabled(self, arg__1: bool) -> None: ...
    def setFixedHeight(self, h: int) -> None: ...
    @typing.overload
    def setFixedSize(self, arg__1: PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def setFixedSize(self, w: int, h: int) -> None: ...
    def setFixedWidth(self, w: int) -> None: ...
    @typing.overload
    def setFocus(self) -> None: ...
    @typing.overload
    def setFocus(self, reason: PySide2.QtCore.Qt.FocusReason) -> None: ...
    def setFocusPolicy(self, policy: PySide2.QtCore.Qt.FocusPolicy) -> None: ...
    def setFocusProxy(self, arg__1: PySide2.QtWidgets.QWidget) -> None: ...
    def setFont(self, arg__1: PySide2.QtGui.QFont) -> None: ...
    def setForegroundRole(self, arg__1: PySide2.QtGui.QPalette.ColorRole) -> None: ...
    @typing.overload
    def setGeometry(self, arg__1: PySide2.QtCore.QRect) -> None: ...
    @typing.overload
    def setGeometry(self, x: int, y: int, w: int, h: int) -> None: ...
    def setGraphicsEffect(self, effect: PySide2.QtWidgets.QGraphicsEffect) -> None: ...
    def setHidden(self, hidden: bool) -> None: ...
    def setInputMethodHints(self, hints: PySide2.QtCore.Qt.InputMethodHints) -> None: ...
    def setLayout(self, arg__1: PySide2.QtWidgets.QLayout) -> None: ...
    def setLayoutDirection(self, direction: PySide2.QtCore.Qt.LayoutDirection) -> None: ...
    def setLocale(self, locale: PySide2.QtCore.QLocale) -> None: ...
    @typing.overload
    def setMask(self, arg__1: PySide2.QtGui.QBitmap) -> None: ...
    @typing.overload
    def setMask(self, arg__1: PySide2.QtGui.QRegion) -> None: ...
    def setMaximumHeight(self, maxh: int) -> None: ...
    @typing.overload
    def setMaximumSize(self, arg__1: PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def setMaximumSize(self, maxw: int, maxh: int) -> None: ...
    def setMaximumWidth(self, maxw: int) -> None: ...
    def setMinimumHeight(self, minh: int) -> None: ...
    @typing.overload
    def setMinimumSize(self, arg__1: PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def setMinimumSize(self, minw: int, minh: int) -> None: ...
    def setMinimumWidth(self, minw: int) -> None: ...
    def setMouseTracking(self, enable: bool) -> None: ...
    def setPalette(self, arg__1: PySide2.QtGui.QPalette) -> None: ...
    @typing.overload
    def setParent(self, parent: PySide2.QtCore.QObject) -> None: ...
    @typing.overload
    def setParent(self, parent: PySide2.QtWidgets.QWidget) -> None: ...
    @typing.overload
    def setParent(self, parent: PySide2.QtWidgets.QWidget, f: PySide2.QtCore.Qt.WindowFlags) -> None: ...
    def setShortcutAutoRepeat(self, id: int, enable: bool = ...) -> None: ...
    def setShortcutEnabled(self, id: int, enable: bool = ...) -> None: ...
    @typing.overload
    def setSizeIncrement(self, arg__1: PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def setSizeIncrement(self, w: int, h: int) -> None: ...
    @typing.overload
    def setSizePolicy(self, arg__1: PySide2.QtWidgets.QSizePolicy) -> None: ...
    @typing.overload
    def setSizePolicy(self, horizontal: PySide2.QtWidgets.QSizePolicy.Policy, vertical: PySide2.QtWidgets.QSizePolicy.Policy) -> None: ...
    def setStatusTip(self, arg__1: str) -> None: ...
    def setStyle(self, arg__1: PySide2.QtWidgets.QStyle) -> None: ...
    def setStyleSheet(self, styleSheet: str) -> None: ...
    @staticmethod
    def setTabOrder(arg__1: PySide2.QtWidgets.QWidget, arg__2: PySide2.QtWidgets.QWidget) -> None: ...
    def setTabletTracking(self, enable: bool) -> None: ...
    def setToolTip(self, arg__1: str) -> None: ...
    def setToolTipDuration(self, msec: int) -> None: ...
    def setUpdatesEnabled(self, enable: bool) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def setWhatsThis(self, arg__1: str) -> None: ...
    def setWindowFilePath(self, filePath: str) -> None: ...
    def setWindowFlag(self, arg__1: PySide2.QtCore.Qt.WindowType, on: bool = ...) -> None: ...
    def setWindowFlags(self, type: PySide2.QtCore.Qt.WindowFlags) -> None: ...
    def setWindowIcon(self, icon: PySide2.QtGui.QIcon) -> None: ...
    def setWindowIconText(self, arg__1: str) -> None: ...
    def setWindowModality(self, windowModality: PySide2.QtCore.Qt.WindowModality) -> None: ...
    def setWindowModified(self, arg__1: bool) -> None: ...
    def setWindowOpacity(self, level: float) -> None: ...
    def setWindowRole(self, arg__1: str) -> None: ...
    def setWindowState(self, state: PySide2.QtCore.Qt.WindowStates) -> None: ...
    def setWindowTitle(self, arg__1: str) -> None: ...
    def sharedPainter(self) -> PySide2.QtGui.QPainter: ...
    def show(self) -> None: ...
    def showEvent(self, event: PySide2.QtGui.QShowEvent) -> None: ...
    def showFullScreen(self) -> None: ...
    def showMaximized(self) -> None: ...
    def showMinimized(self) -> None: ...
    def showNormal(self) -> None: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def sizeIncrement(self) -> PySide2.QtCore.QSize: ...
    def sizePolicy(self) -> PySide2.QtWidgets.QSizePolicy: ...
    def stackUnder(self, arg__1: PySide2.QtWidgets.QWidget) -> None: ...
    def statusTip(self) -> str: ...
    def style(self) -> PySide2.QtWidgets.QStyle: ...
    def styleSheet(self) -> str: ...
    def tabletEvent(self, event: PySide2.QtGui.QTabletEvent) -> None: ...
    def testAttribute(self, arg__1: PySide2.QtCore.Qt.WidgetAttribute) -> bool: ...
    def toolTip(self) -> str: ...
    def toolTipDuration(self) -> int: ...
    def topLevelWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def underMouse(self) -> bool: ...
    def ungrabGesture(self, type: PySide2.QtCore.Qt.GestureType) -> None: ...
    def unsetCursor(self) -> None: ...
    def unsetLayoutDirection(self) -> None: ...
    def unsetLocale(self) -> None: ...
    @typing.overload
    def update(self) -> None: ...
    @typing.overload
    def update(self, arg__1: PySide2.QtCore.QRect) -> None: ...
    @typing.overload
    def update(self, arg__1: PySide2.QtGui.QRegion) -> None: ...
    @typing.overload
    def update(self, x: int, y: int, w: int, h: int) -> None: ...
    def updateGeometry(self) -> None: ...
    def updateMicroFocus(self) -> None: ...
    def updatesEnabled(self) -> bool: ...
    def visibleRegion(self) -> PySide2.QtGui.QRegion: ...
    def whatsThis(self) -> str: ...
    def wheelEvent(self, event: PySide2.QtGui.QWheelEvent) -> None: ...
    def width(self) -> int: ...
    def winId(self) -> int: ...
    def window(self) -> PySide2.QtWidgets.QWidget: ...
    def windowFilePath(self) -> str: ...
    def windowFlags(self) -> PySide2.QtCore.Qt.WindowFlags: ...
    def windowHandle(self) -> PySide2.QtGui.QWindow: ...
    def windowIcon(self) -> PySide2.QtGui.QIcon: ...
    def windowIconText(self) -> str: ...
    def windowModality(self) -> PySide2.QtCore.Qt.WindowModality: ...
    def windowOpacity(self) -> float: ...
    def windowRole(self) -> str: ...
    def windowState(self) -> PySide2.QtCore.Qt.WindowStates: ...
    def windowTitle(self) -> str: ...
    def windowType(self) -> PySide2.QtCore.Qt.WindowType: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QWidgetAction(PySide2.QtWidgets.QAction):

    def __init__(self, parent: PySide2.QtCore.QObject) -> None: ...

    def createWidget(self, parent: PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QWidget: ...
    def createdWidgets(self) -> typing.List[PySide2.QtWidgets.QWidget]: ...
    def defaultWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def deleteWidget(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1: PySide2.QtCore.QObject, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    def releaseWidget(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def requestWidget(self, parent: PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QWidget: ...
    def setDefaultWidget(self, w: PySide2.QtWidgets.QWidget) -> None: ...


class QWidgetItem(PySide2.QtWidgets.QLayoutItem):

    def __init__(self, w: PySide2.QtWidgets.QWidget) -> None: ...

    def controlTypes(self) -> PySide2.QtWidgets.QSizePolicy.ControlTypes: ...
    def expandingDirections(self) -> PySide2.QtCore.Qt.Orientations: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def isEmpty(self) -> bool: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def setGeometry(self, arg__1: PySide2.QtCore.QRect) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...


class QWizard(PySide2.QtWidgets.QDialog):
    NoButton                 : QWizard.WizardButton = ... # -0x1
    BackButton               : QWizard.WizardButton = ... # 0x0
    NextButton               : QWizard.WizardButton = ... # 0x1
    CommitButton             : QWizard.WizardButton = ... # 0x2
    FinishButton             : QWizard.WizardButton = ... # 0x3
    CancelButton             : QWizard.WizardButton = ... # 0x4
    HelpButton               : QWizard.WizardButton = ... # 0x5
    CustomButton1            : QWizard.WizardButton = ... # 0x6
    NStandardButtons         : QWizard.WizardButton = ... # 0x6
    CustomButton2            : QWizard.WizardButton = ... # 0x7
    CustomButton3            : QWizard.WizardButton = ... # 0x8
    NButtons                 : QWizard.WizardButton = ... # 0x9
    Stretch                  : QWizard.WizardButton = ... # 0x9
    IndependentPages         : QWizard.WizardOption = ... # 0x1
    IgnoreSubTitles          : QWizard.WizardOption = ... # 0x2
    ExtendedWatermarkPixmap  : QWizard.WizardOption = ... # 0x4
    NoDefaultButton          : QWizard.WizardOption = ... # 0x8
    NoBackButtonOnStartPage  : QWizard.WizardOption = ... # 0x10
    NoBackButtonOnLastPage   : QWizard.WizardOption = ... # 0x20
    DisabledBackButtonOnLastPage: QWizard.WizardOption = ... # 0x40
    HaveNextButtonOnLastPage : QWizard.WizardOption = ... # 0x80
    HaveFinishButtonOnEarlyPages: QWizard.WizardOption = ... # 0x100
    NoCancelButton           : QWizard.WizardOption = ... # 0x200
    CancelButtonOnLeft       : QWizard.WizardOption = ... # 0x400
    HaveHelpButton           : QWizard.WizardOption = ... # 0x800
    HelpButtonOnRight        : QWizard.WizardOption = ... # 0x1000
    HaveCustomButton1        : QWizard.WizardOption = ... # 0x2000
    HaveCustomButton2        : QWizard.WizardOption = ... # 0x4000
    HaveCustomButton3        : QWizard.WizardOption = ... # 0x8000
    NoCancelButtonOnLastPage : QWizard.WizardOption = ... # 0x10000
    WatermarkPixmap          : QWizard.WizardPixmap = ... # 0x0
    LogoPixmap               : QWizard.WizardPixmap = ... # 0x1
    BannerPixmap             : QWizard.WizardPixmap = ... # 0x2
    BackgroundPixmap         : QWizard.WizardPixmap = ... # 0x3
    NPixmaps                 : QWizard.WizardPixmap = ... # 0x4
    ClassicStyle             : QWizard.WizardStyle = ... # 0x0
    ModernStyle              : QWizard.WizardStyle = ... # 0x1
    MacStyle                 : QWizard.WizardStyle = ... # 0x2
    AeroStyle                : QWizard.WizardStyle = ... # 0x3
    NStyles                  : QWizard.WizardStyle = ... # 0x4

    class WizardButton(Shiboken.Enum):
        NoButton                 : QWizard.WizardButton = ... # -0x1
        BackButton               : QWizard.WizardButton = ... # 0x0
        NextButton               : QWizard.WizardButton = ... # 0x1
        CommitButton             : QWizard.WizardButton = ... # 0x2
        FinishButton             : QWizard.WizardButton = ... # 0x3
        CancelButton             : QWizard.WizardButton = ... # 0x4
        HelpButton               : QWizard.WizardButton = ... # 0x5
        CustomButton1            : QWizard.WizardButton = ... # 0x6
        NStandardButtons         : QWizard.WizardButton = ... # 0x6
        CustomButton2            : QWizard.WizardButton = ... # 0x7
        CustomButton3            : QWizard.WizardButton = ... # 0x8
        NButtons                 : QWizard.WizardButton = ... # 0x9
        Stretch                  : QWizard.WizardButton = ... # 0x9

    class WizardOption(Shiboken.Enum):
        IndependentPages         : QWizard.WizardOption = ... # 0x1
        IgnoreSubTitles          : QWizard.WizardOption = ... # 0x2
        ExtendedWatermarkPixmap  : QWizard.WizardOption = ... # 0x4
        NoDefaultButton          : QWizard.WizardOption = ... # 0x8
        NoBackButtonOnStartPage  : QWizard.WizardOption = ... # 0x10
        NoBackButtonOnLastPage   : QWizard.WizardOption = ... # 0x20
        DisabledBackButtonOnLastPage: QWizard.WizardOption = ... # 0x40
        HaveNextButtonOnLastPage : QWizard.WizardOption = ... # 0x80
        HaveFinishButtonOnEarlyPages: QWizard.WizardOption = ... # 0x100
        NoCancelButton           : QWizard.WizardOption = ... # 0x200
        CancelButtonOnLeft       : QWizard.WizardOption = ... # 0x400
        HaveHelpButton           : QWizard.WizardOption = ... # 0x800
        HelpButtonOnRight        : QWizard.WizardOption = ... # 0x1000
        HaveCustomButton1        : QWizard.WizardOption = ... # 0x2000
        HaveCustomButton2        : QWizard.WizardOption = ... # 0x4000
        HaveCustomButton3        : QWizard.WizardOption = ... # 0x8000
        NoCancelButtonOnLastPage : QWizard.WizardOption = ... # 0x10000

    class WizardOptions(object): ...

    class WizardPixmap(Shiboken.Enum):
        WatermarkPixmap          : QWizard.WizardPixmap = ... # 0x0
        LogoPixmap               : QWizard.WizardPixmap = ... # 0x1
        BannerPixmap             : QWizard.WizardPixmap = ... # 0x2
        BackgroundPixmap         : QWizard.WizardPixmap = ... # 0x3
        NPixmaps                 : QWizard.WizardPixmap = ... # 0x4

    class WizardStyle(Shiboken.Enum):
        ClassicStyle             : QWizard.WizardStyle = ... # 0x0
        ModernStyle              : QWizard.WizardStyle = ... # 0x1
        MacStyle                 : QWizard.WizardStyle = ... # 0x2
        AeroStyle                : QWizard.WizardStyle = ... # 0x3
        NStyles                  : QWizard.WizardStyle = ... # 0x4

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...

    def addPage(self, page: PySide2.QtWidgets.QWizardPage) -> int: ...
    def back(self) -> None: ...
    def button(self, which: PySide2.QtWidgets.QWizard.WizardButton) -> PySide2.QtWidgets.QAbstractButton: ...
    def buttonText(self, which: PySide2.QtWidgets.QWizard.WizardButton) -> str: ...
    def cleanupPage(self, id: int) -> None: ...
    def currentId(self) -> int: ...
    def currentPage(self) -> PySide2.QtWidgets.QWizardPage: ...
    def done(self, result: int) -> None: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def field(self, name: str) -> typing.Any: ...
    def hasVisitedPage(self, id: int) -> bool: ...
    def initializePage(self, id: int) -> None: ...
    def next(self) -> None: ...
    def nextId(self) -> int: ...
    def options(self) -> PySide2.QtWidgets.QWizard.WizardOptions: ...
    def page(self, id: int) -> PySide2.QtWidgets.QWizardPage: ...
    def pageIds(self) -> typing.List[int]: ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent) -> None: ...
    def pixmap(self, which: PySide2.QtWidgets.QWizard.WizardPixmap) -> PySide2.QtGui.QPixmap: ...
    def removePage(self, id: int) -> None: ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent) -> None: ...
    def restart(self) -> None: ...
    def setButton(self, which: PySide2.QtWidgets.QWizard.WizardButton, button: PySide2.QtWidgets.QAbstractButton) -> None: ...
    def setButtonLayout(self, layout: typing.Sequence[PySide2.QtWidgets.QWizard.WizardButton]) -> None: ...
    def setButtonText(self, which: PySide2.QtWidgets.QWizard.WizardButton, text: str) -> None: ...
    def setDefaultProperty(self, className: bytes, property: bytes, changedSignal: bytes) -> None: ...
    def setField(self, name: str, value: typing.Any) -> None: ...
    def setOption(self, option: PySide2.QtWidgets.QWizard.WizardOption, on: bool = ...) -> None: ...
    def setOptions(self, options: PySide2.QtWidgets.QWizard.WizardOptions) -> None: ...
    def setPage(self, id: int, page: PySide2.QtWidgets.QWizardPage) -> None: ...
    def setPixmap(self, which: PySide2.QtWidgets.QWizard.WizardPixmap, pixmap: PySide2.QtGui.QPixmap) -> None: ...
    def setSideWidget(self, widget: PySide2.QtWidgets.QWidget) -> None: ...
    def setStartId(self, id: int) -> None: ...
    def setSubTitleFormat(self, format: PySide2.QtCore.Qt.TextFormat) -> None: ...
    def setTitleFormat(self, format: PySide2.QtCore.Qt.TextFormat) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def setWizardStyle(self, style: PySide2.QtWidgets.QWizard.WizardStyle) -> None: ...
    def sideWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def startId(self) -> int: ...
    def subTitleFormat(self) -> PySide2.QtCore.Qt.TextFormat: ...
    def testOption(self, option: PySide2.QtWidgets.QWizard.WizardOption) -> bool: ...
    def titleFormat(self) -> PySide2.QtCore.Qt.TextFormat: ...
    def validateCurrentPage(self) -> bool: ...
    def visitedIds(self) -> typing.List[int]: ...
    def visitedPages(self) -> typing.List[int]: ...
    def wizardStyle(self) -> PySide2.QtWidgets.QWizard.WizardStyle: ...


class QWizardPage(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def buttonText(self, which: PySide2.QtWidgets.QWizard.WizardButton) -> str: ...
    def cleanupPage(self) -> None: ...
    def field(self, name: str) -> typing.Any: ...
    def initializePage(self) -> None: ...
    def isCommitPage(self) -> bool: ...
    def isComplete(self) -> bool: ...
    def isFinalPage(self) -> bool: ...
    def nextId(self) -> int: ...
    def pixmap(self, which: PySide2.QtWidgets.QWizard.WizardPixmap) -> PySide2.QtGui.QPixmap: ...
    def registerField(self, name: str, widget: PySide2.QtWidgets.QWidget, property: typing.Optional[bytes] = ..., changedSignal: typing.Optional[bytes] = ...) -> None: ...
    def setButtonText(self, which: PySide2.QtWidgets.QWizard.WizardButton, text: str) -> None: ...
    def setCommitPage(self, commitPage: bool) -> None: ...
    def setField(self, name: str, value: typing.Any) -> None: ...
    def setFinalPage(self, finalPage: bool) -> None: ...
    def setPixmap(self, which: PySide2.QtWidgets.QWizard.WizardPixmap, pixmap: PySide2.QtGui.QPixmap) -> None: ...
    def setSubTitle(self, subTitle: str) -> None: ...
    def setTitle(self, title: str) -> None: ...
    def subTitle(self) -> str: ...
    def title(self) -> str: ...
    def validatePage(self) -> bool: ...
    def wizard(self) -> PySide2.QtWidgets.QWizard: ...

# eof
