# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import serialize
from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class NotificationList(ListResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, service_sid):
        """
        Initialize the NotificationList

        :param Version version: Version that contains the resource
        :param service_sid: The SID of the Service that the resource is associated with

        :returns: twilio.rest.notify.v1.service.notification.NotificationList
        :rtype: twilio.rest.notify.v1.service.notification.NotificationList
        """
        super(NotificationList, self).__init__(version)

        # Path Solution
        self._solution = {'service_sid': service_sid, }
        self._uri = '/Services/{service_sid}/Notifications'.format(**self._solution)

    def create(self, body=values.unset, priority=values.unset, ttl=values.unset,
               title=values.unset, sound=values.unset, action=values.unset,
               data=values.unset, apn=values.unset, gcm=values.unset,
               sms=values.unset, facebook_messenger=values.unset, fcm=values.unset,
               segment=values.unset, alexa=values.unset, to_binding=values.unset,
               delivery_callback_url=values.unset, identity=values.unset,
               tag=values.unset):
        """
        Create the NotificationInstance

        :param unicode body: The notification body text
        :param NotificationInstance.Priority priority: The priority of the notification
        :param unicode ttl: How long, in seconds, the notification is valid
        :param unicode title: The notification title
        :param unicode sound: The name of the sound to be played for the notification
        :param unicode action: The actions to display for the notification
        :param dict data: The custom key-value pairs of the notification's payload
        :param dict apn: The APNS-specific payload that overrides corresponding attributes in a generic payload for APNS Bindings
        :param dict gcm: The GCM-specific payload that overrides corresponding attributes in generic payload for GCM Bindings
        :param dict sms: The SMS-specific payload that overrides corresponding attributes in generic payload for SMS Bindings
        :param dict facebook_messenger: Deprecated
        :param dict fcm: The FCM-specific payload that overrides corresponding attributes in generic payload for FCM Bindings
        :param unicode segment: A Segment to notify
        :param dict alexa: Deprecated
        :param unicode to_binding: The destination address specified as a JSON string
        :param unicode delivery_callback_url: URL to send webhooks
        :param unicode identity: The `identity` value that identifies the new resource's User
        :param unicode tag: A tag that selects the Bindings to notify

        :returns: The created NotificationInstance
        :rtype: twilio.rest.notify.v1.service.notification.NotificationInstance
        """
        data = values.of({
            'Identity': serialize.map(identity, lambda e: e),
            'Tag': serialize.map(tag, lambda e: e),
            'Body': body,
            'Priority': priority,
            'Ttl': ttl,
            'Title': title,
            'Sound': sound,
            'Action': action,
            'Data': serialize.object(data),
            'Apn': serialize.object(apn),
            'Gcm': serialize.object(gcm),
            'Sms': serialize.object(sms),
            'FacebookMessenger': serialize.object(facebook_messenger),
            'Fcm': serialize.object(fcm),
            'Segment': serialize.map(segment, lambda e: e),
            'Alexa': serialize.object(alexa),
            'ToBinding': serialize.map(to_binding, lambda e: e),
            'DeliveryCallbackUrl': delivery_callback_url,
        })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return NotificationInstance(self._version, payload, service_sid=self._solution['service_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Notify.V1.NotificationList>'


class NotificationPage(Page):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, response, solution):
        """
        Initialize the NotificationPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param service_sid: The SID of the Service that the resource is associated with

        :returns: twilio.rest.notify.v1.service.notification.NotificationPage
        :rtype: twilio.rest.notify.v1.service.notification.NotificationPage
        """
        super(NotificationPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of NotificationInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.notify.v1.service.notification.NotificationInstance
        :rtype: twilio.rest.notify.v1.service.notification.NotificationInstance
        """
        return NotificationInstance(self._version, payload, service_sid=self._solution['service_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Notify.V1.NotificationPage>'


class NotificationInstance(InstanceResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    class Priority(object):
        HIGH = "high"
        LOW = "low"

    def __init__(self, version, payload, service_sid):
        """
        Initialize the NotificationInstance

        :returns: twilio.rest.notify.v1.service.notification.NotificationInstance
        :rtype: twilio.rest.notify.v1.service.notification.NotificationInstance
        """
        super(NotificationInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'sid': payload.get('sid'),
            'account_sid': payload.get('account_sid'),
            'service_sid': payload.get('service_sid'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'identities': payload.get('identities'),
            'tags': payload.get('tags'),
            'segments': payload.get('segments'),
            'priority': payload.get('priority'),
            'ttl': deserialize.integer(payload.get('ttl')),
            'title': payload.get('title'),
            'body': payload.get('body'),
            'sound': payload.get('sound'),
            'action': payload.get('action'),
            'data': payload.get('data'),
            'apn': payload.get('apn'),
            'gcm': payload.get('gcm'),
            'fcm': payload.get('fcm'),
            'sms': payload.get('sms'),
            'facebook_messenger': payload.get('facebook_messenger'),
            'alexa': payload.get('alexa'),
        }

        # Context
        self._context = None
        self._solution = {'service_sid': service_sid, }

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def service_sid(self):
        """
        :returns: The SID of the Service that the resource is associated with
        :rtype: unicode
        """
        return self._properties['service_sid']

    @property
    def date_created(self):
        """
        :returns: The RFC 2822 date and time in GMT when the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def identities(self):
        """
        :returns: The list of identity values of the Users to notify
        :rtype: unicode
        """
        return self._properties['identities']

    @property
    def tags(self):
        """
        :returns: The tags that select the Bindings to notify
        :rtype: unicode
        """
        return self._properties['tags']

    @property
    def segments(self):
        """
        :returns: The list of Segments to notify
        :rtype: unicode
        """
        return self._properties['segments']

    @property
    def priority(self):
        """
        :returns: The priority of the notification
        :rtype: NotificationInstance.Priority
        """
        return self._properties['priority']

    @property
    def ttl(self):
        """
        :returns: How long, in seconds, the notification is valid
        :rtype: unicode
        """
        return self._properties['ttl']

    @property
    def title(self):
        """
        :returns: The notification title
        :rtype: unicode
        """
        return self._properties['title']

    @property
    def body(self):
        """
        :returns: The notification body text
        :rtype: unicode
        """
        return self._properties['body']

    @property
    def sound(self):
        """
        :returns: The name of the sound to be played for the notification
        :rtype: unicode
        """
        return self._properties['sound']

    @property
    def action(self):
        """
        :returns: The actions to display for the notification
        :rtype: unicode
        """
        return self._properties['action']

    @property
    def data(self):
        """
        :returns: The custom key-value pairs of the notification's payload
        :rtype: dict
        """
        return self._properties['data']

    @property
    def apn(self):
        """
        :returns: The APNS-specific payload that overrides corresponding attributes in a generic payload for APNS Bindings
        :rtype: dict
        """
        return self._properties['apn']

    @property
    def gcm(self):
        """
        :returns: The GCM-specific payload that overrides corresponding attributes in generic payload for GCM Bindings
        :rtype: dict
        """
        return self._properties['gcm']

    @property
    def fcm(self):
        """
        :returns: The FCM-specific payload that overrides corresponding attributes in generic payload for FCM Bindings
        :rtype: dict
        """
        return self._properties['fcm']

    @property
    def sms(self):
        """
        :returns: The SMS-specific payload that overrides corresponding attributes in generic payload for SMS Bindings
        :rtype: dict
        """
        return self._properties['sms']

    @property
    def facebook_messenger(self):
        """
        :returns: Deprecated
        :rtype: dict
        """
        return self._properties['facebook_messenger']

    @property
    def alexa(self):
        """
        :returns: Deprecated
        :rtype: dict
        """
        return self._properties['alexa']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Notify.V1.NotificationInstance>'
