# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page
from twilio.rest.preview.trusted_comms.business.insights.impressions_rate import ImpressionsRateList


class InsightsList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, business_sid):
        """
        Initialize the InsightsList

        :param Version version: Version that contains the resource
        :param business_sid: A string that uniquely identifies this Business.

        :returns: twilio.rest.preview.trusted_comms.business.insights.InsightsList
        :rtype: twilio.rest.preview.trusted_comms.business.insights.InsightsList
        """
        super(InsightsList, self).__init__(version)

        # Path Solution
        self._solution = {'business_sid': business_sid, }

        # Components
        self._impressions_rate = None

    @property
    def impressions_rate(self):
        """
        Access the impressions_rate

        :returns: twilio.rest.preview.trusted_comms.business.insights.impressions_rate.ImpressionsRateList
        :rtype: twilio.rest.preview.trusted_comms.business.insights.impressions_rate.ImpressionsRateList
        """
        if self._impressions_rate is None:
            self._impressions_rate = ImpressionsRateList(
                self._version,
                business_sid=self._solution['business_sid'],
            )
        return self._impressions_rate

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.TrustedComms.InsightsList>'


class InsightsPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the InsightsPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param business_sid: A string that uniquely identifies this Business.

        :returns: twilio.rest.preview.trusted_comms.business.insights.InsightsPage
        :rtype: twilio.rest.preview.trusted_comms.business.insights.InsightsPage
        """
        super(InsightsPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of InsightsInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.preview.trusted_comms.business.insights.InsightsInstance
        :rtype: twilio.rest.preview.trusted_comms.business.insights.InsightsInstance
        """
        return InsightsInstance(self._version, payload, business_sid=self._solution['business_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.TrustedComms.InsightsPage>'


class InsightsInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload, business_sid):
        """
        Initialize the InsightsInstance

        :returns: twilio.rest.preview.trusted_comms.business.insights.InsightsInstance
        :rtype: twilio.rest.preview.trusted_comms.business.insights.InsightsInstance
        """
        super(InsightsInstance, self).__init__(version)

        # Context
        self._context = None
        self._solution = {'business_sid': business_sid, }

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.TrustedComms.InsightsInstance>'
