private rule architecture {
	meta:
		bits = 32
		endianness = "big"
		architecture = "MIPS"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "fgetspent"
		size = 76
		refs = "0000 _gp_disp 0018 __GI_fgetspent_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 85 ?? ?? 8F 86 ?? ?? 27 BD FF D0 8F 99 ?? ?? 27 A2 00 20 24 A5 ?? ?? AF BF 00 2C AF BC 00 18 AF A2 00 10 24 C6 ?? ?? ?? ?? ?? ?? 24 07 01 00 8F BF 00 2C 8F A2 00 20 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_92_0_0 {
	meta:
		name = "fgetgrent"
		size = 76
		refs = "0000 _gp_disp 0018 __GI_fgetgrent_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 85 ?? ?? 8F 86 ?? ?? 27 BD FF D0 8F 99 ?? ?? 27 A2 00 20 24 A5 ?? ?? AF BF 00 2C AF BC 00 18 AF A2 00 10 24 C6 ?? ?? ?? ?? ?? ?? 24 07 01 00 8F BF 00 2C 8F A2 00 20 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_639_0_0 {
	meta:
		name = "fgetpwent"
		size = 76
		refs = "0000 _gp_disp 0018 __GI_fgetpwent_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 85 ?? ?? 8F 86 ?? ?? 27 BD FF D0 8F 99 ?? ?? 27 A2 00 20 24 A5 ?? ?? AF BF 00 2C AF BC 00 18 AF A2 00 10 24 C6 ?? ?? ?? ?? ?? ?? 24 07 01 00 8F BF 00 2C 8F A2 00 20 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_459_0_0 {
	meta:
		name = "getgrgid"
		size = 76
		refs = "0000 _gp_disp 0018 __GI_getgrgid_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 85 ?? ?? 8F 86 ?? ?? 27 BD FF D0 8F 99 ?? ?? 27 A2 00 20 24 A5 ?? ?? AF BF 00 2C AF BC 00 18 AF A2 00 10 24 C6 ?? ?? ?? ?? ?? ?? 24 07 01 00 8F BF 00 2C 8F A2 00 20 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_385_0_0 {
	meta:
		name = "getgrnam"
		size = 76
		refs = "0000 _gp_disp 0018 __GI_getgrnam_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 85 ?? ?? 8F 86 ?? ?? 27 BD FF D0 8F 99 ?? ?? 27 A2 00 20 24 A5 ?? ?? AF BF 00 2C AF BC 00 18 AF A2 00 10 24 C6 ?? ?? ?? ?? ?? ?? 24 07 01 00 8F BF 00 2C 8F A2 00 20 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_411_0_0 {
	meta:
		name = "getpwnam"
		size = 76
		refs = "0000 _gp_disp 0018 __GI_getpwnam_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 85 ?? ?? 8F 86 ?? ?? 27 BD FF D0 8F 99 ?? ?? 27 A2 00 20 24 A5 ?? ?? AF BF 00 2C AF BC 00 18 AF A2 00 10 24 C6 ?? ?? ?? ?? ?? ?? 24 07 01 00 8F BF 00 2C 8F A2 00 20 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_853_0_0 {
	meta:
		name = "getpwuid"
		size = 76
		refs = "0000 _gp_disp 0018 __GI_getpwuid_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 85 ?? ?? 8F 86 ?? ?? 27 BD FF D0 8F 99 ?? ?? 27 A2 00 20 24 A5 ?? ?? AF BF 00 2C AF BC 00 18 AF A2 00 10 24 C6 ?? ?? ?? ?? ?? ?? 24 07 01 00 8F BF 00 2C 8F A2 00 20 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_422_0_0 {
	meta:
		name = "getspnam"
		size = 76
		refs = "0000 _gp_disp 0018 __GI_getspnam_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 85 ?? ?? 8F 86 ?? ?? 27 BD FF D0 8F 99 ?? ?? 27 A2 00 20 24 A5 ?? ?? AF BF 00 2C AF BC 00 18 AF A2 00 10 24 C6 ?? ?? ?? ?? ?? ?? 24 07 01 00 8F BF 00 2C 8F A2 00 20 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_246_0_0 {
	meta:
		name = "sgetspent"
		size = 76
		refs = "0000 _gp_disp 0018 __GI_sgetspent_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 85 ?? ?? 8F 86 ?? ?? 27 BD FF D0 8F 99 ?? ?? 27 A2 00 20 24 A5 ?? ?? AF BF 00 2C AF BC 00 18 AF A2 00 10 24 C6 ?? ?? ?? ?? ?? ?? 24 07 01 00 8F BF 00 2C 8F A2 00 20 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "__GI_inet_ntoa_r"
		size = 176
		refs = "0000 _gp_disp 0014 _uintmaxtostr"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF B3 00 2C 8F 93 ?? ?? AF B6 00 38 AF B5 00 34 AF B4 00 30 AF B2 00 28 AF B1 00 24 AF B0 00 20 AF BC 00 18 00 80 80 21 AF BF 00 3C 24 A4 00 0F 00 00 90 21 00 00 88 21 24 15 FF F6 24 16 00 2E 24 14 00 04 32 07 00 FF AF B5 00 10 AF A0 00 14 02 60 C8 21 ?? ?? ?? ?? 00 00 30 21 24 44 FF FF 12 40 00 02 00 10 82 02 A2 56 00 00 26 31 00 01 16 34 FF F4 00 80 90 21 8F BF 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_1_1_0 {
	meta:
		name = "__GI_inet_ntoa"
		size = 28
		refs = "0000 _gp_disp 0010 __GI_inet_ntoa_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 85 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? }
	condition:
		$1
}

rule file_542_0_0 {
	meta:
		name = "__GI_asctime"
		size = 28
		refs = "0000 _gp_disp 0010 __GI_asctime_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 85 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? }
	condition:
		$1
}

rule file_268_0_0 {
	meta:
		name = "__stdio_init_mutex"
		size = 32
		refs = "0000 _gp_disp 0010 __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 85 ?? ?? 8F 99 ?? ?? 24 06 00 18 ?? ?? ?? ?? 24 A5 ?? ?? }
	condition:
		$1
}

rule file_598_1_0 {
	meta:
		name = "ether_aton"
		size = 28
		refs = "0000 _gp_disp 0010 __GI_ether_aton_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 85 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? }
	condition:
		$1
}

rule file_598_3_0 {
	meta:
		name = "ether_ntoa"
		size = 28
		refs = "0000 _gp_disp 0010 __GI_ether_ntoa_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 85 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? }
	condition:
		$1
}

rule file_241_1_0 {
	meta:
		name = "hcreate"
		size = 28
		refs = "0000 _gp_disp 0010 __GI_hcreate_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 85 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "tcflush"
		size = 28
		refs = "0000 _gp_disp 000c __GI_ioctl"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 00 A0 30 21 ?? ?? ?? ?? 24 05 54 07 }
	condition:
		$1
}

rule file_40_8_3 {
	meta:
		name = "_ZN9__gnu_cxx13stdio_filebufIcSt11char_traitsIcEE2fdEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt12__basic_fileIcE2fdEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 38 }
	condition:
		$1
}

rule file_40_9_3 {
	meta:
		name = "_ZN9__gnu_cxx13stdio_filebufIcSt11char_traitsIcEE4fileEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt12__basic_fileIcE4fileEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 38 }
	condition:
		$1
}

rule file_40_14_3 {
	meta:
		name = "_ZN9__gnu_cxx13stdio_filebufIwSt11char_traitsIwEE2fdEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt12__basic_fileIcE2fdEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 38 }
	condition:
		$1
}

rule file_40_15_3 {
	meta:
		name = "_ZN9__gnu_cxx13stdio_filebufIwSt11char_traitsIwEE4fileEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt12__basic_fileIcE4fileEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 38 }
	condition:
		$1
}

rule file_118_14_3 {
	meta:
		name = "_ZN9__gnu_cxx18stdio_sync_filebufIcSt11char_traitsIcEE4syncEv"
		size = 24
		refs = "0000 _gp_disp 000c fflush"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 8C 84 00 20 }
	condition:
		$1
}

rule file_118_15_3 {
	meta:
		name = "_ZN9__gnu_cxx18stdio_sync_filebufIwSt11char_traitsIwEE4syncEv"
		size = 24
		refs = "0000 _gp_disp 000c fflush"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 8C 84 00 20 }
	condition:
		$1
}

rule file_82_49_3 {
	meta:
		name = "_ZN9__gnu_cxx8__detail13__mini_vectorIPjE10deallocateEPS2_j"
		size = 24
		refs = "0000 _gp_disp 000c _ZdlPv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 A0 20 21 }
	condition:
		$1
}

rule file_82_48_3 {
	meta:
		name = "_ZN9__gnu_cxx8__detail13__mini_vectorIPjE8allocateEj"
		size = 24
		refs = "0000 _gp_disp 000c _Znwj"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 05 20 80 }
	condition:
		$1
}

rule file_82_21_3 {
	meta:
		name = "_ZN9__gnu_cxx8__detail13__mini_vectorISt4pairIPNS_16bitmap_allocatorIcE12_Alloc_blockES6_EE10deallocateEPS7_j"
		size = 24
		refs = "0000 _gp_disp 000c _ZdlPv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 A0 20 21 }
	condition:
		$1
}

rule file_82_20_3 {
	meta:
		name = "_ZN9__gnu_cxx8__detail13__mini_vectorISt4pairIPNS_16bitmap_allocatorIcE12_Alloc_blockES6_EE8allocateEj"
		size = 24
		refs = "0000 _gp_disp 000c _Znwj"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 05 20 C0 }
	condition:
		$1
}

rule file_82_35_3 {
	meta:
		name = "_ZN9__gnu_cxx8__detail13__mini_vectorISt4pairIPNS_16bitmap_allocatorIwE12_Alloc_blockES6_EE10deallocateEPS7_j"
		size = 24
		refs = "0000 _gp_disp 000c _ZdlPv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 A0 20 21 }
	condition:
		$1
}

rule file_82_34_3 {
	meta:
		name = "_ZN9__gnu_cxx8__detail13__mini_vectorISt4pairIPNS_16bitmap_allocatorIwE12_Alloc_blockES6_EE8allocateEj"
		size = 24
		refs = "0000 _gp_disp 000c _Znwj"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 05 20 C0 }
	condition:
		$1
}

rule file_102_60_3 {
	meta:
		name = "_ZNKSbIwSt11char_traitsIwESaIwEE12find_last_ofEwj"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSbIwSt11char_traitsIwESaIwEE5rfindEwj"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_102_56_3 {
	meta:
		name = "_ZNKSbIwSt11char_traitsIwESaIwEE13find_first_ofEwj"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSbIwSt11char_traitsIwESaIwEE4findEwj"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_56_59_3 {
	meta:
		name = "_ZNKSs12find_last_ofEcj"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSs5rfindEcj"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 7C 05 2C 20 }
	condition:
		$1
}

rule file_56_55_3 {
	meta:
		name = "_ZNKSs13find_first_ofEcj"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSs4findEcj"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 7C 05 2C 20 }
	condition:
		$1
}

rule file_54_55_3 {
	meta:
		name = "_ZNKSt10ostrstream6pcountEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12strstreambuf6pcountEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 04 }
	condition:
		$1
}

rule file_119_17_3 {
	meta:
		name = "_ZNKSt13basic_filebufIcSt11char_traitsIcEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 38 }
	condition:
		$1
}

rule file_119_90_3 {
	meta:
		name = "_ZNKSt13basic_filebufIwSt11char_traitsIwEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 38 }
	condition:
		$1
}

rule file_119_83_3 {
	meta:
		name = "_ZNKSt13basic_fstreamIcSt11char_traitsIcEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 44 }
	condition:
		$1
}

rule file_119_156_3 {
	meta:
		name = "_ZNKSt13basic_fstreamIwSt11char_traitsIwEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 44 }
	condition:
		$1
}

rule file_119_57_3 {
	meta:
		name = "_ZNKSt14basic_ifstreamIcSt11char_traitsIcEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 40 }
	condition:
		$1
}

rule file_119_130_3 {
	meta:
		name = "_ZNKSt14basic_ifstreamIwSt11char_traitsIwEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 40 }
	condition:
		$1
}

rule file_119_70_3 {
	meta:
		name = "_ZNKSt14basic_ofstreamIcSt11char_traitsIcEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 3C }
	condition:
		$1
}

rule file_119_143_3 {
	meta:
		name = "_ZNKSt14basic_ofstreamIwSt11char_traitsIwEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 3C }
	condition:
		$1
}

rule file_48_10_3 {
	meta:
		name = "_ZNKSt5ctypeIwE10do_tolowerEw"
		size = 24
		refs = "0000 _gp_disp 000c towlower"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 A0 20 21 }
	condition:
		$1
}

rule file_48_8_3 {
	meta:
		name = "_ZNKSt5ctypeIwE10do_toupperEw"
		size = 24
		refs = "0000 _gp_disp 000c towupper"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 A0 20 21 }
	condition:
		$1
}

rule file_17_3_3 {
	meta:
		name = "_ZNKSt7codecvtIwc11__mbstate_tE13do_max_lengthEv"
		size = 24
		refs = "0000 _gp_disp 000c _stdlib_mb_cur_max"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_54_63_3 {
	meta:
		name = "_ZNKSt9strstream6pcountEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12strstreambuf6pcountEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 0C }
	condition:
		$1
}

rule file_102_87_3 {
	meta:
		name = "_ZNSbIwSt11char_traitsIwESaIwEE18_S_construct_aux_2EjwRKS1_"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSbIwSt11char_traitsIwESaIwEE12_S_constructEjwRKS1_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_102_88_3 {
	meta:
		name = "_ZNSbIwSt11char_traitsIwESaIwEE4_Rep10_M_destroyERKS1_"
		size = 24
		refs = "0000 _gp_disp 000c _ZdlPv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_102_142_3 {
	meta:
		name = "_ZNSbIwSt11char_traitsIwESaIwEE6resizeEj"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSbIwSt11char_traitsIwESaIwEE6resizeEjw"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 30 21 }
	condition:
		$1
}

rule file_102_148_3 {
	meta:
		name = "_ZNSbIwSt11char_traitsIwESaIwEEaSERKS2_"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSbIwSt11char_traitsIwESaIwEE6assignERKS2_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_102_133_3 {
	meta:
		name = "_ZNSbIwSt11char_traitsIwESaIwEEpLERKS2_"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSbIwSt11char_traitsIwESaIwEE6appendERKS2_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_76_3 {
	meta:
		name = "_ZNSirsERPv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSi10_M_extractIPvEERSiRT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_64_3 {
	meta:
		name = "_ZNSirsERb"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSi10_M_extractIbEERSiRT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_72_3 {
	meta:
		name = "_ZNSirsERd"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSi10_M_extractIdEERSiRT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_74_3 {
	meta:
		name = "_ZNSirsERe"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSi10_M_extractIeEERSiRT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_70_3 {
	meta:
		name = "_ZNSirsERf"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSi10_M_extractIfEERSiRT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_58_3 {
	meta:
		name = "_ZNSirsERj"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSi10_M_extractIjEERSiRT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_60_3 {
	meta:
		name = "_ZNSirsERl"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSi10_M_extractIlEERSiRT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_62_3 {
	meta:
		name = "_ZNSirsERm"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSi10_M_extractImEERSiRT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_56_3 {
	meta:
		name = "_ZNSirsERt"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSi10_M_extractItEERSiRT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_66_3 {
	meta:
		name = "_ZNSirsERx"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSi10_M_extractIxEERSiRT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_68_3 {
	meta:
		name = "_ZNSirsERy"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSi10_M_extractIyEERSiRT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_65_3 {
	meta:
		name = "_ZNSolsEPKv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSo9_M_insertIPKvEERSoT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_54_3 {
	meta:
		name = "_ZNSolsEb"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSo9_M_insertIbEERSoT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 30 A5 00 FF }
	condition:
		$1
}

rule file_92_60_3 {
	meta:
		name = "_ZNSolsEd"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSo9_M_insertIdEERSoT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_63_3 {
	meta:
		name = "_ZNSolsEe"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSo9_M_insertIeEERSoT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_48_3 {
	meta:
		name = "_ZNSolsEi"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSo9_M_insertIlEERSoT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_52_3 {
	meta:
		name = "_ZNSolsEj"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSo9_M_insertImEERSoT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_46_3 {
	meta:
		name = "_ZNSolsEl"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSo9_M_insertIlEERSoT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_50_3 {
	meta:
		name = "_ZNSolsEm"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSo9_M_insertImEERSoT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_51_3 {
	meta:
		name = "_ZNSolsEt"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSo9_M_insertImEERSoT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 30 A5 FF FF }
	condition:
		$1
}

rule file_92_56_3 {
	meta:
		name = "_ZNSolsEx"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSo9_M_insertIxEERSoT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_58_3 {
	meta:
		name = "_ZNSolsEy"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSo9_M_insertIyEERSoT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_56_86_3 {
	meta:
		name = "_ZNSs18_S_construct_aux_2EjcRKSaIcE"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSs12_S_constructEjcRKSaIcE"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 7C 05 2C 20 }
	condition:
		$1
}

rule file_56_87_3 {
	meta:
		name = "_ZNSs4_Rep10_M_destroyERKSaIcE"
		size = 24
		refs = "0000 _gp_disp 000c _ZdlPv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_56_141_3 {
	meta:
		name = "_ZNSs6resizeEj"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSs6resizeEjc"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 30 21 }
	condition:
		$1
}

rule file_56_147_3 {
	meta:
		name = "_ZNSsaSERKSs"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSs6assignERKSs"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_56_132_3 {
	meta:
		name = "_ZNSspLERKSs"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSs6appendERKSs"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_54_46_3 {
	meta:
		name = "_ZNSt10istrstream3strEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt12strstreambuf3strEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 08 }
	condition:
		$1
}

rule file_54_54_3 {
	meta:
		name = "_ZNSt10ostrstream3strEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt12strstreambuf3strEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 04 }
	condition:
		$1
}

rule file_23_6_3 {
	meta:
		name = "_ZNSt12__basic_fileIcE2fdEv"
		size = 24
		refs = "0000 _gp_disp 000c fileno"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 8C 84 00 00 }
	condition:
		$1
}

rule file_23_14_3 {
	meta:
		name = "_ZNSt12__basic_fileIcE4syncEv"
		size = 24
		refs = "0000 _gp_disp 000c fflush"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 8C 84 00 00 }
	condition:
		$1
}

rule file_23_9_3 {
	meta:
		name = "_ZNSt12__basic_fileIcED2Ev"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt12__basic_fileIcE5closeEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_119_26_3 {
	meta:
		name = "_ZNSt13basic_filebufIcSt11char_traitsIcEE4openERKSsSt13_Ios_Openmode"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_filebufIcSt11char_traitsIcEE4openEPKcSt13_Ios_Openmode"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 8C A5 00 00 }
	condition:
		$1
}

rule file_119_99_3 {
	meta:
		name = "_ZNSt13basic_filebufIwSt11char_traitsIwEE4openERKSsSt13_Ios_Openmode"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_filebufIwSt11char_traitsIwEE4openEPKcSt13_Ios_Openmode"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 8C A5 00 00 }
	condition:
		$1
}

rule file_119_82_3 {
	meta:
		name = "_ZNSt13basic_fstreamIcSt11char_traitsIcEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 44 }
	condition:
		$1
}

rule file_119_155_3 {
	meta:
		name = "_ZNSt13basic_fstreamIwSt11char_traitsIwEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 44 }
	condition:
		$1
}

rule file_107_138_3 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERPv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIPvEERS2_RT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_126_3 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERb"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIbEERS2_RT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_134_3 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERd"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIdEERS2_RT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_136_3 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERe"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIeEERS2_RT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_132_3 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERf"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIfEERS2_RT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_120_3 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERj"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIjEERS2_RT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_122_3 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERl"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIlEERS2_RT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_124_3 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERm"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractImEERS2_RT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_118_3 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERt"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractItEERS2_RT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_128_3 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERx"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIxEERS2_RT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_130_3 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERy"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIyEERS2_RT_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_119_3 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEPKv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertIPKvEERS2_T_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_108_3 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEb"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertIbEERS2_T_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 30 A5 00 FF }
	condition:
		$1
}

rule file_92_114_3 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEd"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertIdEERS2_T_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_117_3 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEe"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertIeEERS2_T_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_102_3 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEi"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertIlEERS2_T_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_106_3 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEj"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertImEERS2_T_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_100_3 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEl"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertIlEERS2_T_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_104_3 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEm"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertImEERS2_T_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_105_3 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEt"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertImEERS2_T_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 30 A5 FF FF }
	condition:
		$1
}

rule file_92_110_3 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEx"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertIxEERS2_T_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_112_3 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEy"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertIyEERS2_T_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_88_10_3 {
	meta:
		name = "_ZNSt13random_device16_M_getval_pretr1Ev"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt23mersenne_twister_engineIjLj32ELj624ELj397ELj31ELj2567483615ELj11ELj4294967295ELj7ELj2636928640ELj15ELj4022730752ELj18ELj1812433253EEclEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_119_56_3 {
	meta:
		name = "_ZNSt14basic_ifstreamIcSt11char_traitsIcEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 40 }
	condition:
		$1
}

rule file_119_129_3 {
	meta:
		name = "_ZNSt14basic_ifstreamIwSt11char_traitsIwEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 40 }
	condition:
		$1
}

rule file_119_69_3 {
	meta:
		name = "_ZNSt14basic_ofstreamIcSt11char_traitsIcEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 3C }
	condition:
		$1
}

rule file_119_142_3 {
	meta:
		name = "_ZNSt14basic_ofstreamIwSt11char_traitsIwEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 3C }
	condition:
		$1
}

rule file_3_5_3 {
	meta:
		name = "_ZNSt15__exception_ptr13exception_ptrC2EPv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt15__exception_ptr13exception_ptr9_M_addrefEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? AC 85 00 00 }
	condition:
		$1
}

rule file_3_8_3 {
	meta:
		name = "_ZNSt15__exception_ptr13exception_ptrD2Ev"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt15__exception_ptr13exception_ptr10_M_releaseEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_22_1_3 {
	meta:
		name = "_ZNSt18condition_variableD2Ev"
		size = 24
		refs = "0000 _gp_disp 000c pthread_cond_destroy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_22_6_3 {
	meta:
		name = "_ZNSt22condition_variable_anyD2Ev"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt18condition_variableD1Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_88_7_3 {
	meta:
		name = "_ZNSt23mersenne_twister_engineIjLj32ELj624ELj397ELj31ELj2567483615ELj11ELj4294967295ELj7ELj2636928640ELj15ELj4022730752ELj18ELj1812433253EEC2Ej"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt23mersenne_twister_engineIjLj32ELj624ELj397ELj31ELj2567483615ELj11ELj4294967295ELj7ELj2636928640ELj15ELj4022730752ELj18ELj1812433253EE4seedEj"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_90_4_3 {
	meta:
		name = "_ZNSt6localeC2ERKS_S1_i"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt6locale11_M_coalesceERKS_S1_i"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? AC 80 00 00 }
	condition:
		$1
}

rule file_2_2_3 {
	meta:
		name = "_ZNSt8valarrayIjED2Ev"
		size = 24
		refs = "0000 _gp_disp 000c _ZdlPv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 8C 84 00 04 }
	condition:
		$1
}

rule file_54_64_3 {
	meta:
		name = "_ZNSt9strstream3strEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt12strstreambuf3strEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 0C }
	condition:
		$1
}

rule file_92_30_3 {
	meta:
		name = "_ZSt4endsIcSt11char_traitsIcEERSt13basic_ostreamIT_T0_ES6_"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSo3putEc"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 28 21 }
	condition:
		$1
}

rule file_92_86_3 {
	meta:
		name = "_ZSt4endsIwSt11char_traitsIwEERSt13basic_ostreamIT_T0_ES6_"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE3putEw"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 28 21 }
	condition:
		$1
}

rule file_92_31_3 {
	meta:
		name = "_ZSt5flushIcSt11char_traitsIcEERSt13basic_ostreamIT_T0_ES6_"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSo5flushEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_87_3 {
	meta:
		name = "_ZSt5flushIwSt11char_traitsIwEERSt13basic_ostreamIT_T0_ES6_"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE5flushEv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_48_3 {
	meta:
		name = "_ZStrsISt11char_traitsIcEERSt13basic_istreamIcT_ES5_Pa"
		size = 24
		refs = "0000 _gp_disp 000c _ZStrsIcSt11char_traitsIcEERSt13basic_istreamIT_T0_ES6_PS3_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_47_3 {
	meta:
		name = "_ZStrsISt11char_traitsIcEERSt13basic_istreamIcT_ES5_Ph"
		size = 24
		refs = "0000 _gp_disp 000c _ZStrsIcSt11char_traitsIcEERSt13basic_istreamIT_T0_ES6_PS3_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_46_3 {
	meta:
		name = "_ZStrsISt11char_traitsIcEERSt13basic_istreamIcT_ES5_Ra"
		size = 24
		refs = "0000 _gp_disp 000c _ZStrsIcSt11char_traitsIcEERSt13basic_istreamIT_T0_ES6_RS3_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_45_3 {
	meta:
		name = "_ZStrsISt11char_traitsIcEERSt13basic_istreamIcT_ES5_Rh"
		size = 24
		refs = "0000 _gp_disp 000c _ZStrsIcSt11char_traitsIcEERSt13basic_istreamIT_T0_ES6_RS3_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_97_0_3 {
	meta:
		name = "_ZdaPv"
		size = 24
		refs = "0000 _gp_disp 000c _ZdlPv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_115_0_3 {
	meta:
		name = "_ZdaPvRKSt9nothrow_t"
		size = 24
		refs = "0000 _gp_disp 000c _ZdlPv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_30_0_3 {
	meta:
		name = "_ZdlPvRKSt9nothrow_t"
		size = 24
		refs = "0000 _gp_disp 000c free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_52_0_3 {
	meta:
		name = "_ZnajRKSt9nothrow_t"
		size = 24
		refs = "0000 _gp_disp 000c _ZnwjRKSt9nothrow_t"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_66_0_1 {
	meta:
		name = "__GI_cabs"
		size = 24
		refs = "0000 _gp_disp 000c __GI_hypot"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_742_0_0 {
	meta:
		name = "__GI_iswalnum"
		size = 24
		refs = "0000 _gp_disp 000c __GI_iswctype"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 01 }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "__GI_iswalpha"
		size = 24
		refs = "0000 _gp_disp 000c __GI_iswctype"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 02 }
	condition:
		$1
}

rule file_573_0_0 {
	meta:
		name = "__GI_iswblank"
		size = 24
		refs = "0000 _gp_disp 000c __GI_iswctype"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 03 }
	condition:
		$1
}

rule file_740_0_0 {
	meta:
		name = "__GI_iswcntrl"
		size = 24
		refs = "0000 _gp_disp 000c __GI_iswctype"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 04 }
	condition:
		$1
}

rule file_859_0_0 {
	meta:
		name = "__GI_iswdigit"
		size = 24
		refs = "0000 _gp_disp 000c __GI_iswctype"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 05 }
	condition:
		$1
}

rule file_192_0_0 {
	meta:
		name = "__GI_iswgraph"
		size = 24
		refs = "0000 _gp_disp 000c __GI_iswctype"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 06 }
	condition:
		$1
}

rule file_831_0_0 {
	meta:
		name = "__GI_iswlower"
		size = 24
		refs = "0000 _gp_disp 000c __GI_iswctype"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 07 }
	condition:
		$1
}

rule file_462_0_0 {
	meta:
		name = "__GI_iswprint"
		size = 24
		refs = "0000 _gp_disp 000c __GI_iswctype"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 08 }
	condition:
		$1
}

rule file_416_0_0 {
	meta:
		name = "__GI_iswpunct"
		size = 24
		refs = "0000 _gp_disp 000c __GI_iswctype"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 09 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "__GI_iswspace"
		size = 24
		refs = "0000 _gp_disp 000c __GI_iswctype"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 0A }
	condition:
		$1
}

rule file_424_0_0 {
	meta:
		name = "__GI_iswupper"
		size = 24
		refs = "0000 _gp_disp 000c __GI_iswctype"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 0B }
	condition:
		$1
}

rule file_404_0_0 {
	meta:
		name = "__GI_iswxdigit"
		size = 24
		refs = "0000 _gp_disp 000c __GI_iswctype"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 0C }
	condition:
		$1
}

rule file_702_4_0 {
	meta:
		name = "__GI_setmntent"
		size = 24
		refs = "0000 _gp_disp 000c __GI_fopen"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_604_1_0 {
	meta:
		name = "__GI_sigpause"
		size = 24
		refs = "0000 _gp_disp 000c __GI___sigpause"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 28 21 }
	condition:
		$1
}

rule file_277_0_0 {
	meta:
		name = "__GI_strtol"
		size = 24
		refs = "0000 _gp_disp 000c _stdlib_strto_l"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 07 00 01 }
	condition:
		$1
}

rule file_267_0_0 {
	meta:
		name = "__GI_strtold"
		size = 24
		refs = "0000 _gp_disp 000c __strtofpmax"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 30 21 }
	condition:
		$1
}

rule file_574_0_0 {
	meta:
		name = "__GI_strtoll"
		size = 24
		refs = "0000 _gp_disp 000c _stdlib_strto_ll"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 07 00 01 }
	condition:
		$1
}

rule file_371_0_0 {
	meta:
		name = "__GI_strtoul"
		size = 24
		refs = "0000 _gp_disp 000c _stdlib_strto_l"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 38 21 }
	condition:
		$1
}

rule file_756_0_0 {
	meta:
		name = "__GI_strtoull"
		size = 24
		refs = "0000 _gp_disp 000c _stdlib_strto_ll"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 38 21 }
	condition:
		$1
}

rule file_532_0_0 {
	meta:
		name = "__GI_wcstol"
		size = 24
		refs = "0000 _gp_disp 000c _stdlib_wcsto_l"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 07 00 01 }
	condition:
		$1
}

rule file_808_0_0 {
	meta:
		name = "__GI_wcstold"
		size = 24
		refs = "0000 _gp_disp 000c __wcstofpmax"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 30 21 }
	condition:
		$1
}

rule file_625_0_0 {
	meta:
		name = "__GI_wcstoll"
		size = 24
		refs = "0000 _gp_disp 000c _stdlib_wcsto_ll"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 07 00 01 }
	condition:
		$1
}

rule file_734_0_0 {
	meta:
		name = "__GI_wcstoul"
		size = 24
		refs = "0000 _gp_disp 000c _stdlib_wcsto_l"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 38 21 }
	condition:
		$1
}

rule file_869_0_0 {
	meta:
		name = "__GI_wcstoull"
		size = 24
		refs = "0000 _gp_disp 000c _stdlib_wcsto_ll"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 38 21 }
	condition:
		$1
}

rule file_157_15_0 {
	meta:
		name = "__GI_xdr_enum"
		size = 24
		refs = "0000 _gp_disp 000c __GI_xdr_long"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_157_4_0 {
	meta:
		name = "__GI_xdr_int"
		size = 24
		refs = "0000 _gp_disp 000c __GI_xdr_long"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_157_6_0 {
	meta:
		name = "__GI_xdr_u_int"
		size = 24
		refs = "0000 _gp_disp 000c __GI_xdr_u_long"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_30_1_1 {
	meta:
		name = "__ieee754_lgamma"
		size = 24
		refs = "0000 _gp_disp 000c __ieee754_lgamma_r 0014 __GI_signgam"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 8F 86 ?? ?? }
	condition:
		$1
}

rule file_253_0_0 {
	meta:
		name = "__libc_sigaction"
		size = 24
		refs = "0000 _gp_disp 000c __syscall_rt_sigaction"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 07 00 10 }
	condition:
		$1
}

rule file_523_0_0 {
	meta:
		name = "__vfork"
		size = 24
		refs = "0000 _gp_disp 000c fork"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_392_0_0 {
	meta:
		name = "_flushlbf"
		size = 24
		refs = "0000 _gp_disp 000c __GI_fflush_unlocked 0014 _stdio_openlist"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 8F 84 ?? ?? }
	condition:
		$1
}

rule file_24_1_3 {
	meta:
		name = "acosl"
		size = 24
		refs = "0000 _gp_disp 000c acos"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_24_2_3 {
	meta:
		name = "asinl"
		size = 24
		refs = "0000 _gp_disp 000c asin"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_24_4_3 {
	meta:
		name = "atan2l"
		size = 24
		refs = "0000 _gp_disp 000c atan2"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_24_3_3 {
	meta:
		name = "atanl"
		size = 24
		refs = "0000 _gp_disp 000c atan"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_690_0_0 {
	meta:
		name = "atof"
		size = 24
		refs = "0000 _gp_disp 000c __GI_strtod"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 28 21 }
	condition:
		$1
}

rule file_24_5_3 {
	meta:
		name = "ceill"
		size = 24
		refs = "0000 _gp_disp 000c ceil"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_24_7_3 {
	meta:
		name = "coshl"
		size = 24
		refs = "0000 _gp_disp 000c cosh"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_24_6_3 {
	meta:
		name = "cosl"
		size = 24
		refs = "0000 _gp_disp 000c cos"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_24_8_3 {
	meta:
		name = "expl"
		size = 24
		refs = "0000 _gp_disp 000c exp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_224_0_0 {
	meta:
		name = "flockfile"
		size = 24
		refs = "0000 _gp_disp 000c __pthread_mutex_lock"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 38 }
	condition:
		$1
}

rule file_24_9_3 {
	meta:
		name = "floorl"
		size = 24
		refs = "0000 _gp_disp 000c floor"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_24_10_3 {
	meta:
		name = "fmodl"
		size = 24
		refs = "0000 _gp_disp 000c fmod"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_24_11_3 {
	meta:
		name = "frexpl"
		size = 24
		refs = "0000 _gp_disp 000c frexp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_789_0_0 {
	meta:
		name = "ftrylockfile"
		size = 24
		refs = "0000 _gp_disp 000c __pthread_mutex_trylock"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 38 }
	condition:
		$1
}

rule file_820_0_0 {
	meta:
		name = "funlockfile"
		size = 24
		refs = "0000 _gp_disp 000c __pthread_mutex_unlock"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 38 }
	condition:
		$1
}

rule file_702_3_0 {
	meta:
		name = "hasmntopt"
		size = 24
		refs = "0000 _gp_disp 000c __GI_strstr"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 8C 84 00 0C }
	condition:
		$1
}

rule file_24_14_3 {
	meta:
		name = "ldexpl"
		size = 24
		refs = "0000 _gp_disp 000c ldexp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_24_16_3 {
	meta:
		name = "log10l"
		size = 24
		refs = "0000 _gp_disp 000c log10"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_24_15_3 {
	meta:
		name = "logl"
		size = 24
		refs = "0000 _gp_disp 000c log"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_140_0_0 {
	meta:
		name = "mkstemp"
		size = 24
		refs = "0000 _gp_disp 000c __gen_tempname"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 28 21 }
	condition:
		$1
}

rule file_682_0_0 {
	meta:
		name = "mkstemp64"
		size = 24
		refs = "0000 _gp_disp 000c __gen_tempname"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 01 }
	condition:
		$1
}

rule file_405_0_0 {
	meta:
		name = "mktime"
		size = 24
		refs = "0000 _gp_disp 000c _time_mktime"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 01 }
	condition:
		$1
}

rule file_24_18_3 {
	meta:
		name = "powl"
		size = 24
		refs = "0000 _gp_disp 000c pow"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "rand"
		size = 24
		refs = "0000 _gp_disp 000c __GI_random"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_480_0_0 {
	meta:
		name = "sc_getc"
		size = 24
		refs = "0000 _gp_disp 000c __GI_getc_unlocked"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 8C 84 00 08 }
	condition:
		$1
}

rule file_440_0_0 {
	meta:
		name = "siggetmask"
		size = 24
		refs = "0000 _gp_disp 000c __GI_sigblock"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 20 21 }
	condition:
		$1
}

rule file_24_20_3 {
	meta:
		name = "sinhl"
		size = 24
		refs = "0000 _gp_disp 000c sinh"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_24_19_3 {
	meta:
		name = "sinl"
		size = 24
		refs = "0000 _gp_disp 000c sin"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_24_12_3 {
	meta:
		name = "sqrtl"
		size = 24
		refs = "0000 _gp_disp 000c sqrt"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "srand48"
		size = 24
		refs = "0000 _gp_disp 000c __GI_srand48_r 0014 __libc_drand48_data"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 8F 85 ?? ?? }
	condition:
		$1
}

rule file_150_9_0 {
	meta:
		name = "svcerr_weakauth"
		size = 24
		refs = "0000 _gp_disp 000c __GI_svcerr_auth"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 05 }
	condition:
		$1
}

rule file_24_22_3 {
	meta:
		name = "tanhl"
		size = 24
		refs = "0000 _gp_disp 000c tanh"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_24_21_3 {
	meta:
		name = "tanl"
		size = 24
		refs = "0000 _gp_disp 000c tan"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_2_3_2 {
	meta:
		name = "vfork"
		size = 24
		refs = "0000 _gp_disp 000c __fork"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_673_3_0 {
	meta:
		name = "xdr_des_block"
		size = 24
		refs = "0000 _gp_disp 000c __GI_xdr_opaque"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 24 06 00 08 }
	condition:
		$1
}

rule file_157_9_0 {
	meta:
		name = "xdr_longlong_t"
		size = 24
		refs = "0000 _gp_disp 000c __GI_xdr_hyper"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_157_18_0 {
	meta:
		name = "xdr_netobj"
		size = 32
		refs = "0000 _gp_disp 000c __GI_xdr_bytes"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 00 A0 30 21 24 07 04 00 ?? ?? ?? ?? 24 A5 00 04 }
	condition:
		$1
}

rule file_157_10_0 {
	meta:
		name = "xdr_u_longlong_t"
		size = 24
		refs = "0000 _gp_disp 000c __GI_xdr_u_hyper"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "getpeername"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 4B 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "vwarn_work"
		size = 344
		refs = "0000 _gp_disp 0044 __GI___errno_location 005c __GI___xpg_strerror_r 0080 stderr 0090 __uclibc_progname 0094 _pthread_cleanup_push_defer 0098 __pthread_mutex_unlock 00b0 __pthread_mutex_lock 00c8 __GI_fprintf 00ec __GI_vfprintf 0120 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 78 AF BC 00 10 AF B6 00 80 AF B4 00 78 AF B3 00 74 AF BF 00 84 AF B5 00 7C AF B2 00 70 AF B1 00 6C AF B0 00 68 00 80 A0 21 00 A0 B0 21 10 C0 00 0E 27 B3 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8C 44 00 00 02 60 28 21 8F 99 ?? ?? ?? ?? ?? ?? 24 06 00 40 8F BC 00 10 8F 90 ?? ?? 10 00 00 03 26 10 ?? ?? 8F 90 ?? ?? 26 10 ?? ?? 8F 91 ?? ?? 8E 26 00 00 8C D2 00 34 16 40 00 0D 8F 82 ?? ?? 8F 99 ?? ?? 8F 85 ?? ?? 27 A4 00 58 ?? ?? ?? ?? 24 C6 00 38 8F BC 00 10 8E 24 00 00 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 38 8F BC 00 10 8F 82 ?? ?? 8F 85 ?? ?? 8F 95 ?? ?? 8E 24 00 00 8C 46 00 00 02 A0 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 12 80 00 08 8F BC 00 10 8F 82 ?? ?? 8F 99 ?? ?? 02 80 28 21 8C 44 00 00 02 C0 30 21 ?? ?? ?? ?? 26 10 FF FE 8E 24 00 00 02 00 28 21 02 A0 C8 21 ?? ?? ?? ?? 02 60 30 21 16 40 00 05 8F BC 00 10 8F 99 ?? ?? 27 A4 00 58 ?? ?? ?? ?? 24 05 00 01 8F BF 00 84 8F B6 00 80 8F B5 00 7C 8F B4 00 78 8F B3 00 74 8F B2 00 70 8F B1 00 6C 8F B0 00 68 03 E0 00 08 27 BD 00 88 }
	condition:
		$1
}

rule file_4_1_0 {
	meta:
		name = "__GI_vwarn"
		size = 28
		refs = "0000 _gp_disp 0014 vwarn_work"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 24 06 00 01 }
	condition:
		$1
}

rule file_4_2_0 {
	meta:
		name = "warn"
		size = 68
		refs = "0000 _gp_disp 0010 __GI_vwarn"
		altNames = "warnx"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 8F 99 ?? ?? AF A5 00 2C 27 A5 00 2C AF BF 00 24 AF BC 00 10 AF A6 00 30 AF A7 00 34 AF A5 00 18 ?? ?? ?? ?? 00 00 00 00 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_4_3_0 {
	meta:
		name = "__GI_vwarnx"
		size = 28
		refs = "0000 _gp_disp 0014 vwarn_work"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 30 21 }
	condition:
		$1
}

rule file_4_5_0 {
	meta:
		name = "__GI_verr"
		size = 64
		refs = "0000 _gp_disp 000c __GI_vwarn 0034 __GI_exit"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BC 00 10 AF B0 00 18 AF BF 00 1C 00 80 80 21 00 A0 20 21 ?? ?? ?? ?? 00 C0 28 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 }
	condition:
		$1
}

rule file_4_7_0 {
	meta:
		name = "__GI_verrx"
		size = 64
		refs = "0000 _gp_disp 000c __GI_vwarnx 0034 __GI_exit"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BC 00 10 AF B0 00 18 AF BF 00 1C 00 80 80 21 00 A0 20 21 ?? ?? ?? ?? 00 C0 28 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 }
	condition:
		$1
}

rule file_4_6_0 {
	meta:
		name = "err"
		size = 52
		refs = "0000 _gp_disp 0010 __GI_verr"
		altNames = "errx"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 8F 99 ?? ?? AF A6 00 30 27 A6 00 30 AF BC 00 10 AF BF 00 24 AF A7 00 34 AF A6 00 18 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "__GI_vswscanf"
		size = 172
		refs = "0000 _gp_disp 000c __GI_wcslen 0054 __stdio_init_mutex 008c __GI_vfwscanf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF 88 AF BF 00 74 AF B0 00 70 AF BC 00 10 AF A5 00 68 AF A6 00 6C AF A4 00 28 AF A4 00 20 ?? ?? ?? ?? 00 80 80 21 00 02 10 80 8F BC 00 10 02 02 10 21 AF A2 00 24 AF A2 00 2C 24 02 FF FD AF A2 00 1C 8F 99 ?? ?? 24 02 08 21 A7 A2 00 18 24 02 00 01 AF B0 00 30 AF B0 00 34 AF A2 00 4C 27 A4 00 50 A3 A0 00 1A ?? ?? ?? ?? AF A0 00 44 8F BC 00 10 8F A5 00 68 8F A6 00 6C 8F 99 ?? ?? 27 A4 00 18 ?? ?? ?? ?? AF A0 00 38 8F BF 00 74 8F B0 00 70 03 E0 00 08 27 BD 00 78 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "__GI_settimeofday"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F EF 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "fsetpos64"
		size = 216
		refs = "0000 _gp_disp 0038 _pthread_cleanup_push_defer 003c __pthread_mutex_unlock 0054 __pthread_mutex_lock 0064 __GI_fseeko64 00a4 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B0 AF B1 00 40 AF B0 00 3C AF BC 00 18 AF BF 00 4C AF B3 00 48 AF B2 00 44 8C 92 00 34 00 80 80 21 16 40 00 0C 00 A0 88 21 8F 99 ?? ?? 8F 85 ?? ?? 24 93 00 38 02 60 30 21 ?? ?? ?? ?? 27 A4 00 20 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 8F BC 00 18 8F 99 ?? ?? 8E 27 00 04 8E 26 00 00 AF A0 00 10 ?? ?? ?? ?? 02 00 20 21 14 40 00 07 8F BC 00 18 8E 23 00 08 AE 03 00 2C 8E 23 00 0C AE 03 00 30 8E 23 00 10 A2 03 00 02 16 40 00 08 8F BF 00 4C 8F 99 ?? ?? AF A2 00 30 27 A4 00 20 ?? ?? ?? ?? 24 05 00 01 8F A2 00 30 8F BF 00 4C 8F B3 00 48 8F B2 00 44 8F B1 00 40 8F B0 00 3C 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "timegm"
		size = 128
		refs = "0000 _gp_disp 0010 __GI_memset 0048 __GI_strcpy 0044 $LC0 0060 _time_mktime_tzi"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A8 8F 99 ?? ?? AF B0 00 4C 27 B0 00 18 AF BF 00 54 AF B1 00 50 AF BC 00 10 00 80 88 21 24 06 00 30 02 00 20 21 ?? ?? ?? ?? 00 00 28 21 8F BC 00 10 27 A4 00 28 8F 85 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? 8F BC 00 10 02 20 20 21 02 00 30 21 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 01 8F BF 00 54 8F B1 00 50 8F B0 00 4C 03 E0 00 08 27 BD 00 58 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "__GI_fileno_unlocked"
		size = 72
		refs = "0000 _gp_disp 0014 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8C 82 00 04 04 41 00 0B 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 ?? ?? ?? ?? 00 00 00 00 24 03 00 09 AC 43 00 00 8F BF 00 1C 24 02 FF FF 27 BD 00 20 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "sc_getc"
		size = 188
		refs = "0000 _gp_disp 0030 __GI_fgetwc_unlocked"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF B0 00 18 AF BC 00 10 AF BF 00 1C 00 80 80 21 8C 84 00 08 24 02 FF FD 8C 83 00 04 14 62 00 0D 8F 99 ?? ?? 8C 83 00 10 8C 82 00 0C 00 62 10 2B 50 40 00 05 94 82 00 00 8C 62 00 00 24 63 00 04 10 00 00 09 AC 83 00 10 34 42 00 04 10 00 00 12 A4 82 00 00 ?? ?? ?? ?? 00 00 00 00 24 03 FF FF 50 43 00 0E 24 02 FF FF 24 03 00 01 A2 03 00 1A 8E 03 00 08 AE 02 00 28 90 63 00 02 A2 03 00 18 8E 03 00 38 50 43 00 05 24 02 00 2E AE 02 00 04 10 00 00 02 AE 02 00 24 24 02 FF FF 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_10_1_0 {
	meta:
		name = "scan_getwc"
		size = 236
		refs = "0000 _gp_disp 0058 __GI_fgetwc_unlocked"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B1 00 20 AF B0 00 1C AF BC 00 10 AF BF 00 24 8C 82 00 10 24 11 FF FF 00 80 80 21 24 42 FF FF AC 91 00 24 04 40 00 19 AC 82 00 10 80 82 00 19 54 40 00 1F A0 80 00 19 8C 84 00 08 24 02 FF FD 8C 83 00 04 14 62 00 0D 8F 99 ?? ?? 8C 83 00 10 8C 82 00 0C 00 62 10 2B 50 40 00 05 24 02 00 02 8C 62 00 00 24 63 00 04 10 00 00 0B AC 83 00 10 A2 02 00 19 10 00 00 14 24 02 FF FF ?? ?? ?? ?? 00 00 00 00 54 51 00 05 AE 02 00 04 92 02 00 19 10 00 FF F7 34 42 00 02 AE 02 00 04 8E 02 00 08 24 03 00 01 A2 03 00 1A 90 42 00 02 A2 02 00 18 8E 02 00 0C 24 42 00 01 AE 02 00 0C 8E 02 00 04 AE 02 00 24 00 00 10 21 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_10_2_0 {
	meta:
		name = "__GI_vfwscanf"
		size = 2008
		refs = "0000 _gp_disp 0010 __GI_memset 0078 _pthread_cleanup_push_defer 007c __pthread_mutex_unlock 0094 __pthread_mutex_lock 00a4 __init_scan_cookie 00dc $LC0 00fc __GI_iswspace 01cc __psfs_parse_spec 0270 __scan_getc 029c __scan_ungetc 02ec _store_inttype 0310 __psfs_do_numeric 03c4 scan_getwc 03f4 __GI_wcrtomb 0754 __GI_ungetwc 0794 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FE C8 8F 99 ?? ?? 24 02 FF FF AF B6 01 28 27 B6 00 18 AF BC 00 10 AF B5 01 24 AF B4 01 20 AF B1 01 14 00 80 A8 21 AF BF 01 34 AF BE 01 30 AF B7 01 2C AF B3 01 1C AF B2 01 18 AF B0 01 10 00 A0 88 21 00 C0 A0 21 AF A2 00 3C 02 C0 20 21 00 00 28 21 ?? ?? ?? ?? 24 06 00 24 8E A3 00 34 8F BC 00 10 14 60 00 0C AF A3 01 04 8F 99 ?? ?? 8F 85 ?? ?? 26 B0 00 38 27 A4 00 E4 ?? ?? ?? ?? 02 00 30 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F 99 ?? ?? 27 B3 00 A4 02 60 20 21 ?? ?? ?? ?? 02 A0 28 21 8F BC 00 10 24 12 00 01 8F 82 ?? ?? 24 42 ?? ?? AF A2 00 D0 8F A2 00 AC 90 42 00 03 AF A0 00 4C A3 A2 00 BC 8F 82 ?? ?? 24 42 ?? ?? AF A2 00 E0 8E 37 00 00 12 E0 01 7D 24 02 00 01 A3 A2 00 5C 93 A2 00 BD 8F 90 ?? ?? 3C 19 7F FF 37 39 FF FF 30 42 00 01 AF B9 00 58 AF B9 00 B4 A3 A0 00 5D A3 A2 00 BD 02 00 C8 21 ?? ?? ?? ?? 02 E0 20 21 10 40 00 0D 8F BC 00 10 8F 99 ?? ?? 8E 24 00 04 ?? ?? ?? ?? 26 30 00 04 10 40 00 03 8F BC 00 10 10 00 FF F9 02 00 88 21 24 02 00 17 AF A2 00 54 10 00 00 45 02 20 80 21 24 02 00 25 16 E2 01 4D 02 20 80 21 8E 22 00 04 14 57 00 04 26 30 00 04 24 02 00 16 10 00 00 35 AF A2 00 54 27 A3 00 60 AF A3 00 48 02 00 20 21 00 60 10 21 24 08 FF 80 27 A7 00 A2 8C 85 00 00 10 A0 00 08 00 A8 30 24 14 C0 00 06 00 47 30 2B 10 C0 00 04 24 84 00 04 A0 45 00 00 10 00 FF F7 24 42 00 01 10 43 01 48 A0 40 00 00 8F 99 ?? ?? ?? ?? ?? ?? 02 C0 20 21 04 40 01 43 8F BC 00 10 00 02 10 80 02 02 80 21 93 A2 00 5C 10 40 00 1A 8F A2 00 54 8F A3 00 3C 24 02 FF FE 14 62 00 07 8F A2 00 40 8E 82 00 00 26 94 00 04 10 00 00 11 AF A2 00 44 8F A2 00 40 8F A3 00 3C 00 62 20 2A 10 80 00 08 24 63 00 01 8E 82 00 00 AF A3 00 3C 00 03 18 80 02 C3 18 21 AC 62 00 00 10 00 FF F5 26 94 00 04 00 02 10 80 02 C2 10 21 8C 42 00 00 AF A2 00 44 8F A2 00 54 3C 03 00 2D 34 63 00 01 00 43 10 07 30 42 00 01 14 40 00 14 8F A4 00 58 8F 91 ?? ?? 02 20 C8 21 ?? ?? ?? ?? 02 60 20 21 04 40 00 06 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 8F A4 00 C8 14 40 FF F7 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 8F A3 00 54 24 02 00 17 10 62 01 08 8F BC 00 10 8F A4 00 58 10 80 01 0A AF A4 00 B4 8F A2 00 54 24 03 00 16 10 43 00 F4 8F 99 ?? ?? 14 40 00 0C 28 43 00 10 93 A2 00 5C 50 40 00 FD 96 A2 00 00 8F A7 00 B0 8F 99 ?? ?? 8F A4 00 44 8F A5 00 50 ?? ?? ?? ?? 00 07 37 C3 10 00 00 F4 8F BC 00 10 10 60 00 13 28 43 00 13 8F 99 ?? ?? 02 C0 20 21 ?? ?? ?? ?? 02 60 28 21 83 A4 00 BE 24 03 00 01 14 83 00 04 8F BC 00 10 8F A3 00 CC AF A3 00 A8 AF A3 00 A4 24 03 FF FF 50 43 00 EA 96 A2 00 00 04 41 00 E2 00 00 90 21 10 00 00 E6 96 A2 00 00 14 60 00 08 93 A5 00 5C 8F A6 00 44 27 BE 00 60 AF A0 00 F4 00 C5 F0 0B 27 B1 00 FC 10 00 00 07 24 05 00 13 8F A3 00 44 27 B1 00 FC 00 65 88 0B 27 A3 00 60 24 05 00 10 00 60 F0 21 54 45 00 2A 24 04 00 11 3C 02 7F FF 34 42 FF FF 14 82 00 03 27 A3 00 F4 24 02 00 01 AF A2 00 B4 24 17 00 10 AF A3 01 00 8F 82 ?? ?? 24 59 ?? ?? ?? ?? ?? ?? 02 60 20 21 04 40 00 14 8F BC 00 10 8F A2 00 54 14 57 00 06 8F A5 00 C8 AE 25 00 00 93 A2 00 5C 00 02 10 80 10 00 00 0A 02 22 88 21 8F 99 ?? ?? 03 C0 20 21 ?? ?? ?? ?? 27 A6 00 F4 04 40 00 AD 8F BC 00 10 93 A4 00 5C 03 C2 10 21 00 44 F0 0B 10 00 FF E8 00 00 90 21 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 8F A2 00 B4 18 40 00 95 8F BC 00 10 10 00 00 AC 96 A2 00 00 10 44 00 03 24 04 00 14 54 44 00 25 8E 04 00 04 27 A3 00 F4 24 17 00 01 AF A3 01 00 8F 82 ?? ?? 24 59 ?? ?? ?? ?? ?? ?? 02 60 20 21 04 40 00 7F 8F BC 00 10 8F B2 00 C8 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 14 40 00 78 8F BC 00 10 8F A2 00 54 24 03 00 11 14 43 00 06 8F 99 ?? ?? AE 32 00 00 93 A2 00 5C 00 02 10 80 10 00 00 0A 02 22 88 21 03 C0 20 21 02 40 28 21 ?? ?? ?? ?? 27 A6 00 F4 04 40 00 7E 8F BC 00 10 93 A4 00 5C 03 C2 10 21 00 44 F0 0B 00 00 B8 21 10 00 FF E0 00 00 90 21 24 02 00 5E 10 82 00 03 26 07 00 04 10 00 00 04 AF A0 01 00 24 03 00 01 26 07 00 08 AF A3 01 00 8C E2 00 00 24 F0 00 04 24 04 00 5D 38 42 00 5D 00 E2 80 0B 24 05 00 2D 8E 02 00 00 10 44 00 0E 27 B9 00 F4 50 40 00 71 96 A2 00 00 54 45 FF FA 26 10 00 04 8E 02 00 04 50 44 FF F7 26 10 00 04 8E 06 FF FC 00 C2 10 2B 26 06 00 04 00 C2 80 0B 10 00 FF F1 26 10 00 04 24 17 00 01 AF B9 01 08 8F 82 ?? ?? AF A7 01 0C 24 59 ?? ?? ?? ?? ?? ?? 02 60 20 21 8F BC 00 10 04 40 00 3C 8F A7 01 0C 00 E0 10 21 8C 46 00 00 24 03 00 2D 14 C3 00 13 8F A5 00 C8 00 E2 20 2B 10 80 00 10 24 44 00 04 00 90 40 2B 11 00 00 0D 00 00 00 00 8C 49 FF FC 8C 48 00 04 01 28 50 2A 11 40 00 08 00 A9 48 2B 15 20 00 0A 24 82 00 04 01 05 40 2B 51 00 00 0C 00 80 10 21 10 00 00 06 00 50 20 2B 10 A6 00 09 8F B9 01 00 00 40 20 21 24 82 00 04 00 50 20 2B 54 80 FF E5 8C 46 00 00 10 00 00 02 8F B9 01 00 8F B9 01 00 00 50 10 26 2C 42 00 01 14 59 00 16 8F A2 00 54 24 03 00 12 14 43 00 06 8F 99 ?? ?? AE 25 00 00 93 A2 00 5C 00 02 10 80 10 00 00 0B 02 22 88 21 AF A7 01 0C 03 C0 20 21 ?? ?? ?? ?? 27 A6 00 F4 8F BC 00 10 04 40 00 1C 8F A7 01 0C 93 A4 00 5C 03 C2 10 21 00 44 F0 0B 00 00 B8 21 10 00 FF BF 00 00 90 21 00 00 90 21 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 16 E0 00 1B 8F BC 00 10 AE 20 00 00 A3 C0 00 00 8F A3 00 4C 93 A2 00 5C 00 62 10 21 10 00 00 0F AF A2 00 4C 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 8E 03 00 00 10 43 00 09 8F BC 00 10 10 00 00 03 8F 99 ?? ?? 00 00 90 21 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 10 00 00 06 8F BC 00 10 96 A2 00 00 30 42 00 08 10 40 FE 82 26 11 00 04 02 20 80 21 96 A2 00 00 30 43 00 08 54 60 00 0A 24 02 FF FF 8E 03 00 00 50 60 00 09 93 A2 00 BD 52 40 00 07 93 A2 00 BD 30 42 00 04 10 40 00 04 93 A2 00 BD 24 02 FF FF AF A2 00 4C 93 A2 00 BD 30 42 00 01 10 40 00 17 93 A2 00 BE 30 42 00 01 10 40 00 14 8F A5 00 AC 24 02 FF FD 8C A3 00 04 10 62 00 11 8F A3 01 04 8C A2 00 2C 14 40 00 0E 8F 99 ?? ?? ?? ?? ?? ?? 8F A4 00 A8 8F A3 00 B0 8F BC 00 10 14 60 00 04 8F A2 00 AC 8F A3 00 B8 10 00 00 02 AC 43 00 28 AC 40 00 28 93 A3 00 BC A0 43 00 03 8F A3 01 04 14 60 00 06 8F BF 01 34 8F 99 ?? ?? 27 A4 00 E4 ?? ?? ?? ?? 24 05 00 01 8F BF 01 34 8F A2 00 4C 8F BE 01 30 8F B7 01 2C 8F B6 01 28 8F B5 01 24 8F B4 01 20 8F B3 01 1C 8F B2 01 18 8F B1 01 14 8F B0 01 10 03 E0 00 08 27 BD 01 38 }
	condition:
		$1
}

rule file_11_0_0 {
	meta:
		name = "vwscanf"
		size = 40
		refs = "0000 _gp_disp 000c stdin 0014 __GI_vfwscanf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 83 ?? ?? 00 80 10 21 8F 99 ?? ?? 8C 64 00 00 00 A0 30 21 ?? ?? ?? ?? 00 40 28 21 }
	condition:
		$1
}

rule file_266_0_0 {
	meta:
		name = "__GI_vscanf"
		size = 40
		refs = "0000 _gp_disp 000c stdin 0014 __GI_vfscanf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 83 ?? ?? 00 80 10 21 8F 99 ?? ?? 8C 64 00 00 00 A0 30 21 ?? ?? ?? ?? 00 40 28 21 }
	condition:
		$1
}

rule file_706_0_0 {
	meta:
		name = "vprintf"
		size = 40
		refs = "0000 _gp_disp 000c stdout 0014 __GI_vfprintf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 83 ?? ?? 00 80 10 21 8F 99 ?? ?? 8C 64 00 00 00 A0 30 21 ?? ?? ?? ?? 00 40 28 21 }
	condition:
		$1
}

rule file_487_0_0 {
	meta:
		name = "vwprintf"
		size = 40
		refs = "0000 _gp_disp 000c stdout 0014 __GI_vfwprintf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 83 ?? ?? 00 80 10 21 8F 99 ?? ?? 8C 64 00 00 00 A0 30 21 ?? ?? ?? ?? 00 40 28 21 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "getgrent"
		size = 72
		refs = "0000 _gp_disp 0014 __GI_getgrent_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 84 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 27 BD FF D8 27 A7 00 18 24 84 ?? ?? AF BF 00 24 AF BC 00 10 24 A5 ?? ?? ?? ?? ?? ?? 24 06 01 00 8F BF 00 24 8F A2 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_810_0_0 {
	meta:
		name = "getpwent"
		size = 72
		refs = "0000 _gp_disp 0014 __GI_getpwent_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 84 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 27 BD FF D8 27 A7 00 18 24 84 ?? ?? AF BF 00 24 AF BC 00 10 24 A5 ?? ?? ?? ?? ?? ?? 24 06 01 00 8F BF 00 24 8F A2 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_683_0_0 {
	meta:
		name = "getspent"
		size = 72
		refs = "0000 _gp_disp 0014 __GI_getspent_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 84 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 27 BD FF D8 27 A7 00 18 24 84 ?? ?? AF BF 00 24 AF BC 00 10 24 A5 ?? ?? ?? ?? ?? ?? 24 06 01 00 8F BF 00 24 8F A2 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "__GI_strchr"
		size = 264
	strings:
		$1 = { 30 A2 00 FF 30 83 00 03 50 60 00 08 30 A5 00 FF 90 83 00 00 10 62 00 37 00 00 00 00 10 60 00 37 24 84 00 01 10 00 FF F8 30 83 00 03 00 05 1A 00 00 65 28 25 00 05 1C 00 3C 06 7E FE 3C 09 81 01 00 65 28 25 34 C6 FE FF 25 29 01 00 8C 83 00 00 00 65 38 26 00 07 50 27 00 E6 38 21 01 47 38 26 00 03 50 27 00 66 18 21 01 43 18 26 00 E3 18 25 00 69 18 24 14 60 00 03 24 88 00 04 10 00 FF F3 01 00 20 21 90 83 00 00 10 62 00 1A 00 00 00 00 50 60 00 1B 00 00 10 21 90 83 00 01 14 62 00 03 00 00 00 00 03 E0 00 08 24 82 00 01 50 60 00 14 00 00 10 21 90 83 00 02 14 62 00 03 00 00 00 00 03 E0 00 08 24 82 00 02 50 60 00 0D 00 00 10 21 90 83 00 03 14 62 00 03 00 00 00 00 03 E0 00 08 24 82 00 03 14 60 FF D9 01 00 20 21 03 E0 00 08 00 00 10 21 03 E0 00 08 00 80 10 21 00 00 10 21 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "rpc_thread_multi"
		size = 56
		refs = "0000 _gp_disp 000c __pthread_internal_tsd_set 0028 __libc_tsd_RPC_VARS_data"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 10 40 00 05 8F 85 ?? ?? 8F 99 ?? ?? 24 04 00 02 ?? ?? ?? ?? 24 A5 ?? ?? 8F 82 ?? ?? 24 A5 ?? ?? 03 E0 00 08 AC 45 00 00 }
	condition:
		$1
}

rule file_15_1_0 {
	meta:
		name = "__rpc_thread_destroy"
		size = 288
		refs = "0000 _gp_disp 000c __pthread_internal_tsd_get 003c __libc_tsd_RPC_VARS_data 0054 __rpc_thread_svc_cleanup 0064 __rpc_thread_clnt_cleanup 0074 free 00e4 __pthread_internal_tsd_set"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 10 40 00 06 8F 99 ?? ?? ?? ?? ?? ?? 24 04 00 02 8F BC 00 10 10 00 00 03 00 40 80 21 8F 82 ?? ?? 8C 50 00 00 12 00 00 32 8F 82 ?? ?? 24 42 ?? ?? 12 02 00 2F 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 8E 04 00 98 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 8E 04 00 9C 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 8E 04 00 A0 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 8E 04 00 BC 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 8E 04 00 AC 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 8E 04 00 B0 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F 82 ?? ?? 10 40 00 07 8F BF 00 1C 8F B0 00 18 8F 99 ?? ?? 24 04 00 02 00 00 28 21 ?? ?? ?? ?? 27 BD 00 20 8F 82 ?? ?? AC 40 00 00 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_15_2_0 {
	meta:
		name = "__rpc_thread_variables"
		size = 336
		refs = "0000 _gp_disp 0014 __pthread_internal_tsd_get 0040 __libc_tsd_RPC_VARS_data 0050 __pthread_once 0088 rpc_thread_multi 00c8 calloc 00e4 __pthread_internal_tsd_set"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B1 00 20 8F 91 ?? ?? AF BC 00 10 AF BF 00 24 AF B0 00 1C 12 20 00 06 8F 99 ?? ?? ?? ?? ?? ?? 24 04 00 02 8F BC 00 10 10 00 00 03 00 40 80 21 8F 82 ?? ?? 8C 50 00 00 16 00 00 3C 8F BF 00 24 8F 82 ?? ?? 10 40 00 08 8F 90 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 26 04 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? 10 00 00 0A 8F BC 00 10 8E 02 ?? ?? 14 40 00 07 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 24 02 00 01 AE 02 ?? ?? 12 20 00 06 8F 99 ?? ?? ?? ?? ?? ?? 24 04 00 02 8F BC 00 10 10 00 00 03 00 40 80 21 8F 82 ?? ?? 8C 50 00 00 16 00 00 1E 8F BF 00 24 8F 99 ?? ?? 24 04 00 01 ?? ?? ?? ?? 24 05 00 C8 8F BC 00 10 10 40 00 0C 00 40 80 21 8F 82 ?? ?? 10 40 00 06 8F 99 ?? ?? 24 04 00 02 ?? ?? ?? ?? 02 00 28 21 10 00 00 0F 8F BF 00 24 8F 82 ?? ?? 10 00 00 0B AC 50 00 00 12 20 00 07 8F BF 00 24 8F B1 00 20 8F B0 00 1C 8F 99 ?? ?? 24 04 00 02 ?? ?? ?? ?? 27 BD 00 28 8F 82 ?? ?? 8C 50 00 00 8F BF 00 24 02 00 10 21 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_15_3_0 {
	meta:
		name = "__GI___rpc_thread_svc_fdset"
		size = 72
		refs = "0000 _gp_disp 000c __rpc_thread_variables 0034 svc_fdset"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F BF 00 1C 27 BD 00 20 8F 84 ?? ?? 8F 83 ?? ?? 24 84 ?? ?? 00 44 20 26 03 E0 00 08 00 64 10 0A }
	condition:
		$1
}

rule file_15_4_0 {
	meta:
		name = "__GI___rpc_thread_createerr"
		size = 80
		refs = "0000 _gp_disp 000c __rpc_thread_variables 0040 rpc_createerr"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 24 44 00 80 8F BF 00 1C 8F 83 ?? ?? 27 BD 00 20 24 63 ?? ?? 00 43 10 26 8F 83 ?? ?? 00 82 18 0B 03 E0 00 08 00 60 10 21 }
	condition:
		$1
}

rule file_15_5_0 {
	meta:
		name = "__GI___rpc_thread_svc_pollfd"
		size = 80
		refs = "0000 _gp_disp 000c __rpc_thread_variables 0040 svc_pollfd"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 24 44 00 90 8F BF 00 1C 8F 83 ?? ?? 27 BD 00 20 24 63 ?? ?? 00 43 10 26 8F 83 ?? ?? 00 82 18 0B 03 E0 00 08 00 60 10 21 }
	condition:
		$1
}

rule file_15_6_0 {
	meta:
		name = "__GI___rpc_thread_svc_max_pollfd"
		size = 80
		refs = "0000 _gp_disp 000c __rpc_thread_variables 0040 svc_max_pollfd"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 24 44 00 94 8F BF 00 1C 8F 83 ?? ?? 27 BD 00 20 24 63 ?? ?? 00 43 10 26 8F 83 ?? ?? 00 82 18 0B 03 E0 00 08 00 60 10 21 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "__GI_strlen"
		size = 156
	strings:
		$1 = { 00 80 10 21 30 43 00 03 10 60 00 06 3C 06 FE FE 80 43 00 00 10 60 00 10 00 00 00 00 10 00 FF F9 24 42 00 01 3C 07 80 80 34 C6 FE FF 34 E7 80 80 8C 43 00 00 00 66 18 21 00 67 18 24 14 60 00 03 24 45 00 04 10 00 FF FA 00 A0 10 21 80 43 00 00 54 60 00 03 80 43 00 01 03 E0 00 08 00 44 10 23 54 60 00 04 80 43 00 02 00 44 10 23 03 E0 00 08 24 42 00 01 54 60 00 04 80 43 00 03 00 44 10 23 03 E0 00 08 24 42 00 02 54 60 FF E9 00 A0 10 21 00 44 10 23 03 E0 00 08 24 42 00 03 }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "__libc_getpid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F B4 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "_fpmaxtostr"
		size = 2292
		refs = "0000 _gp_disp 00a8 __nedf2 00e8 __eqdf2 010c __divdf3 0114 $LC0 0130 __ltdf2 0188 __muldf3 0190 $LC1 020c $LC2 02a4 $LC3 0310 __gedf2 038c $LC4 03b4 __fixunsdfsi 03cc __floatunsidf 03e4 __subdf3"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 10 AF B4 00 D8 8F B4 01 00 AF B3 00 D4 AF B1 00 CC AF B0 00 C8 AF BC 00 10 AF BF 00 EC AF BE 00 E8 AF B7 00 E4 AF B6 00 E0 AF B5 00 DC AF B2 00 D0 8E 82 00 08 8E 99 00 04 24 03 00 65 7C 02 9C 20 AF A4 00 F0 A3 A3 00 90 36 64 00 20 24 03 00 61 00 C0 80 21 00 E0 88 21 AF B9 00 AC 14 83 00 03 8E 92 00 00 24 53 00 06 7C 13 9C 20 2A 43 00 00 24 02 00 06 00 43 90 0B 8E 82 00 0C 30 43 00 02 10 60 00 03 A3 A0 00 A0 10 00 00 05 24 02 00 2B 30 42 00 01 10 40 00 04 8F 99 ?? ?? 24 02 00 20 A3 A2 00 A0 8F 99 ?? ?? A3 A0 00 A1 AF A0 00 2C 02 00 20 21 02 20 28 21 02 00 30 21 ?? ?? ?? ?? 02 20 38 21 10 40 00 04 8F BC 00 10 24 02 00 08 10 00 00 38 AF A2 00 2C 8F 99 ?? ?? 02 00 20 21 02 20 28 21 00 00 38 21 ?? ?? ?? ?? 00 00 30 21 14 40 00 14 8F BC 00 10 8F 82 ?? ?? 8F 99 ?? ?? 02 00 30 21 8C 45 ?? ?? 8C 44 ?? ?? ?? ?? ?? ?? 02 20 38 21 8F BC 00 10 00 60 28 21 00 40 20 21 8F 99 ?? ?? 00 00 38 21 ?? ?? ?? ?? 00 00 30 21 04 41 00 9B 8F BC 00 10 24 02 00 2D 10 00 00 98 A3 A2 00 A0 8F 99 ?? ?? 02 00 20 21 02 20 28 21 00 00 38 21 ?? ?? ?? ?? 00 00 30 21 04 41 00 05 8F BC 00 10 24 02 00 2D A3 A2 00 A0 3C 02 80 00 00 50 80 26 8F 82 ?? ?? 8F 99 ?? ?? 02 00 20 21 8C 47 ?? ?? 8C 46 ?? ?? ?? ?? ?? ?? 02 20 28 21 8F BC 00 10 02 00 20 21 02 20 28 21 8F 99 ?? ?? 00 60 38 21 ?? ?? ?? ?? 00 40 30 21 14 40 00 13 8F BC 00 10 24 02 00 20 AE 82 00 10 24 02 00 70 AF A2 00 24 2A 73 00 61 24 02 00 03 12 60 00 04 AF A2 00 28 8F A2 00 2C 24 42 00 04 AF A2 00 2C 8F 82 ?? ?? 8F A3 00 2C 27 B0 00 30 24 42 ?? ?? 00 43 10 21 10 00 01 76 AF A2 00 2C 8F 82 ?? ?? 24 19 00 09 AF B9 00 A8 8C 59 ?? ?? 8C 42 ?? ?? 02 00 B0 21 02 20 A8 21 24 17 01 00 24 1E 00 08 AF B9 00 B0 AF A2 00 B4 AF B9 00 B8 AF A2 00 BC 8F B9 00 A8 8F A6 00 B0 8F A7 00 B4 27 39 FF FF AF B9 00 A8 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 02 20 28 21 8F B9 00 A8 8F BC 00 10 04 41 00 1C 00 19 18 C0 8F 82 ?? ?? 8F 99 ?? ?? 02 C0 20 21 24 42 ?? ?? 00 43 18 21 8C 67 00 04 8C 66 00 00 ?? ?? ?? ?? 02 A0 28 21 8F BC 00 10 00 40 58 21 01 60 20 21 8F 82 ?? ?? 8F 99 ?? ?? 00 60 28 21 24 42 ?? ?? 8C 47 00 04 8C 46 00 00 AF A3 00 C4 ?? ?? ?? ?? AF AB 00 C0 8F BC 00 10 8F A3 00 C4 04 41 00 1D 8F AB 00 C0 10 00 00 19 03 D7 F0 23 8F 84 ?? ?? 8F 99 ?? ?? 02 A0 28 21 24 84 ?? ?? 00 83 18 21 8C 67 00 04 8C 66 00 00 ?? ?? ?? ?? 02 C0 20 21 8F BC 00 10 8F A6 00 B8 8F A7 00 BC 8F 99 ?? ?? 00 40 58 21 01 60 20 21 00 60 28 21 AF A3 00 C4 ?? ?? ?? ?? AF AB 00 C0 8F BC 00 10 8F A3 00 C4 04 40 00 04 8F AB 00 C0 03 D7 F0 21 01 60 B0 21 00 60 A8 21 8F B9 00 A8 17 20 FF BD 00 17 B8 43 8F 82 ?? ?? 8F 99 ?? ?? 02 A0 88 21 8C 47 ?? ?? 8C 46 ?? ?? 02 C0 20 21 ?? ?? ?? ?? 02 20 28 21 02 C0 80 21 04 40 00 0E 8F BC 00 10 8F 82 ?? ?? 8F 99 ?? ?? 02 20 28 21 8C 47 ?? ?? 8C 46 ?? ?? 02 C0 20 21 ?? ?? ?? ?? 27 DE 00 01 00 40 80 21 8F BC 00 10 10 00 00 02 00 60 88 21 24 1E FF FF 8F 99 ?? ?? 02 20 28 21 ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 00 40 20 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 B0 21 8F BC 00 10 02 20 28 21 02 00 20 21 8F 99 ?? ?? 00 60 38 21 ?? ?? ?? ?? 00 40 30 21 8F BC 00 10 00 40 20 21 00 60 28 21 8F 82 ?? ?? 8F 99 ?? ?? 8C 46 ?? ?? ?? ?? ?? ?? 8C 47 ?? ?? 8F BC 00 10 00 60 28 21 00 40 20 21 27 AA 00 83 00 00 10 21 24 03 00 0A 24 06 00 09 02 C3 00 1B 00 60 01 F4 24 42 00 01 01 42 38 23 00 00 48 10 25 29 00 30 A0 E9 00 00 14 46 FF F8 00 00 B0 12 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 00 00 18 21 27 A9 00 8C 24 04 00 0A 24 05 00 09 00 44 00 1B 00 80 01 F4 24 63 00 01 01 23 30 23 00 00 38 10 24 E7 00 30 A0 C7 00 00 14 65 FF F8 00 00 10 12 2A 62 00 61 10 40 00 06 24 02 00 67 24 02 00 45 26 73 00 20 A3 A2 00 90 7C 13 9C 20 24 02 00 67 16 62 00 06 24 02 00 66 26 42 FF FF 00 12 10 0A 00 40 90 21 10 00 00 11 00 40 20 21 16 62 00 0F 02 40 20 21 02 5E 20 21 28 82 FF FF 10 40 00 0C 24 02 00 30 3C 03 30 30 24 63 30 30 AF A3 00 78 AF A3 00 7C AF A3 00 80 AF A3 00 84 24 03 00 30 A3 A3 00 88 24 1E FF FF 24 04 FF FF 24 02 00 30 A3 A2 00 79 28 82 00 11 10 40 00 07 A3 A0 00 78 03 A4 10 21 24 42 00 7B 80 45 00 00 28 A5 00 35 10 00 00 03 38 A5 00 01 00 00 28 21 27 A2 00 8B 24 07 00 30 90 43 FF FF 24 46 FF FF 00 A3 18 21 7C 03 1C 20 A0 43 FF FF 10 67 FF FA 00 C0 10 21 28 63 00 3A 50 60 FF F8 90 43 FF FF 27 A3 00 79 00 66 10 2B 14 40 00 04 27 A5 00 7A 27 DE 00 01 00 60 30 21 00 60 28 21 24 02 00 67 24 C3 00 01 16 62 00 09 A0 C0 00 01 2B C2 FF FC 54 40 00 C5 24 04 00 67 00 9E 10 2A 54 40 00 C2 24 04 00 67 10 00 00 04 00 9E 90 23 24 02 00 66 16 62 00 BD 02 60 20 21 07 C1 00 05 03 C0 10 21 24 02 00 30 A0 A2 FF FF 03 C0 10 21 24 A5 FF FF 24 04 00 66 24 06 00 01 AF A6 00 28 24 07 00 B0 27 A6 00 A4 AF A6 00 2C AF A7 00 24 24 A6 00 01 80 A5 00 00 00 66 18 23 A3 A0 00 A5 04 40 00 17 A3 A5 00 A4 24 05 00 70 AF A5 00 30 00 43 28 2A 14 A0 00 0C AF A6 00 38 00 43 10 23 18 40 00 11 AF A3 00 34 AF A2 00 40 8F 82 ?? ?? AF A7 00 3C 00 00 18 21 24 42 ?? ?? AF A2 00 44 10 00 00 0B 27 B0 00 48 50 40 00 09 27 B0 00 30 AF A2 00 34 00 C2 30 21 10 00 00 04 00 62 18 23 10 00 00 04 27 B0 00 30 00 00 18 21 27 B0 00 3C 24 02 FF FF 8E 85 00 0C 30 A7 00 10 14 E0 00 08 24 07 00 70 54 60 00 07 AE 07 00 00 24 07 00 67 52 67 00 0B 24 42 00 01 1A 40 00 08 24 07 00 70 AE 07 00 00 24 07 00 01 AE 07 00 04 8F 87 ?? ?? 26 10 00 0C 24 E7 ?? ?? AE 07 FF FC 24 42 00 01 10 40 00 08 24 07 00 B0 AE 07 00 00 00 02 38 23 AE 07 00 04 8F 87 ?? ?? 26 10 00 0C 24 E7 ?? ?? AE 07 FF FC 50 60 00 07 24 06 00 67 24 07 00 70 AE 07 00 00 AE 03 00 04 AE 06 00 08 26 10 00 0C 24 06 00 67 56 66 00 05 00 62 10 23 30 A5 00 10 50 A0 00 0E 24 02 00 66 00 62 10 23 00 52 18 2A 50 60 00 0A 24 02 00 66 02 42 10 23 AE 02 00 04 8F 82 ?? ?? 24 03 00 B0 AE 03 00 00 24 42 ?? ?? AE 02 00 08 26 10 00 0C 24 02 00 66 10 82 00 20 83 A6 00 90 07 C1 00 03 24 04 00 2B 00 1E F0 23 24 04 00 2D A3 A0 00 9F 24 03 00 02 27 A2 00 9F 24 05 00 0A 24 09 00 03 03 C5 00 1A 00 A0 01 F4 24 63 00 01 24 47 FF FF 00 00 50 10 25 4A 00 30 A0 4A FF FF 00 00 40 12 14 69 00 03 00 00 F0 12 10 00 FF F5 00 E0 10 21 55 00 FF F3 00 E0 10 21 A0 44 FF FE A0 46 FF FD 24 04 00 70 24 42 FF FD AE 04 00 00 AE 03 00 04 AE 02 00 08 26 10 00 0C 27 A2 00 28 8C 43 00 00 8F B9 00 AC 24 42 00 0C 03 23 C8 23 00 50 18 2B 14 60 FF FA AF B9 00 AC 83 A2 00 A0 24 03 00 A0 27 A4 00 A0 00 02 10 2B AF A2 00 1C 03 22 10 23 AF A3 00 18 18 40 00 14 AF A4 00 20 8E 84 00 0C 30 84 00 08 50 80 00 08 8E 84 00 10 AE 02 00 04 8F 82 ?? ?? AE 03 00 00 26 10 00 0C 24 42 ?? ?? 10 00 00 09 AE 02 FF FC 24 03 00 30 14 83 00 05 8F B9 00 AC 8F A3 00 28 00 62 10 21 10 00 00 02 AF A2 00 28 AF B9 00 1C 27 B1 00 18 00 00 90 21 8F A4 00 F0 8E 25 00 00 8E 26 00 04 8F B9 01 04 03 20 F8 09 8E 27 00 08 8E 23 00 04 14 43 00 07 26 31 00 0C 02 42 90 21 02 30 10 2B 14 40 FF F5 8F A4 00 F0 10 00 00 05 02 40 10 21 10 00 00 03 24 02 FF FF 10 00 FF 4A 00 00 10 21 8F BF 00 EC 8F BE 00 E8 8F B7 00 E4 8F B6 00 E0 8F B5 00 DC 8F B4 00 D8 8F B3 00 D4 8F B2 00 D0 8F B1 00 CC 8F B0 00 C8 03 E0 00 08 27 BD 00 F0 }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "__sigjmp_save"
		size = 88
		refs = "0000 _gp_disp 0028 __GI_sigprocmask"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF B0 00 18 AF BF 00 1C 00 80 80 21 10 A0 00 07 00 00 10 21 8F 99 ?? ?? 24 04 00 01 00 00 28 21 ?? ?? ?? ?? 26 06 00 6C 2C 42 00 01 8F BF 00 1C AE 02 00 68 8F B0 00 18 00 00 10 21 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_21_0_0 {
	meta:
		name = "getpgid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 24 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "__GI_fread_unlocked"
		size = 500
		refs = "0000 _gp_disp 0068 __stdio_trans2r_o 0114 __GI_memcpy 014c __stdio_READ 0150 _stdio_openlist 0154 __GI_fflush_unlocked 01ac __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 94 E2 00 00 27 BD FF C0 AF BC 00 10 30 42 00 83 2C 42 00 81 AF B3 00 28 AF B2 00 24 AF B1 00 20 AF B0 00 1C AF BF 00 3C AF B7 00 38 AF B6 00 34 AF B5 00 30 AF B4 00 2C 00 80 90 21 00 A0 98 21 00 C0 80 21 14 40 00 05 00 E0 88 21 16 60 00 0B 00 00 10 21 10 00 00 5A 8F BF 00 3C 8F 99 ?? ?? 00 E0 20 21 ?? ?? ?? ?? 24 05 00 80 10 40 FF F7 8F BC 00 10 10 00 00 51 00 00 10 21 12 00 00 4E 24 02 FF FF 00 53 00 1B 02 60 01 F4 00 00 10 12 00 50 10 2B 54 40 00 42 96 22 00 00 72 70 B8 02 02 E0 80 21 96 34 00 00 32 82 00 02 10 40 00 10 26 83 FF FF 32 94 00 01 26 94 00 08 00 14 A0 80 A6 23 00 00 02 34 A0 21 8E 83 00 04 26 10 FF FF 26 42 00 01 A2 43 00 00 16 00 00 03 AE 20 00 28 10 00 00 2A 00 00 80 21 10 00 FF EE 00 40 90 21 8E 36 00 10 8E 35 00 14 02 B6 A8 23 52 A0 00 0F 32 94 03 00 02 B0 10 2B 8F 99 ?? ?? 02 02 A8 0A 02 C0 28 21 02 40 20 21 02 A0 30 21 02 D5 B0 21 ?? ?? ?? ?? 02 15 80 23 8F BC 00 10 12 00 FF EC AE 36 00 10 02 55 90 21 32 94 03 00 12 80 00 07 8F 94 ?? ?? 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 94 ?? ?? 02 20 20 21 02 40 28 21 02 80 C8 21 ?? ?? ?? ?? 02 00 30 21 50 40 00 07 02 F0 80 23 02 02 80 23 16 00 FF F7 02 42 90 21 10 00 00 01 00 00 80 21 02 F0 80 23 02 13 00 1B 02 60 01 F4 10 00 00 08 00 00 10 12 8F 99 ?? ?? 34 42 00 08 ?? ?? ?? ?? A6 22 00 00 24 03 00 16 AC 43 00 00 00 00 10 21 8F BF 00 3C 8F B7 00 38 8F B6 00 34 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_23_0_0 {
	meta:
		name = "semtimedop"
		size = 68
		refs = "0000 _gp_disp 000c __syscall_ipc"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 00 80 10 21 24 04 00 04 AF BF 00 24 AF BC 00 18 AF A5 00 10 AF A7 00 14 00 40 28 21 ?? ?? ?? ?? 00 00 38 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "__GI_statvfs"
		size = 888
		refs = "0000 _gp_disp 000c __libc_statfs 005c __GI_memset 00c0 __GI_stat 00e4 __GI___errno_location 0104 __GI_setmntent 00fc $LC0 0114 $LC1 0124 $LC2 0144 __GI_getmntent_r 01b0 $LC11 01b4 $LC3 01b8 $LC4 01cc __GI_strsep 01e8 __GI_strcmp 0234 $LC5 025c $LC6 0284 $LC7 02ac $LC8 02d4 $LC9 02fc $LC10 0328 __GI_endmntent"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FA 30 AF BC 00 10 AF B1 05 AC AF B0 05 A8 AF BF 05 CC AF BE 05 C8 AF B7 05 C4 AF B6 05 C0 AF B5 05 BC AF B4 05 B8 AF B3 05 B4 AF B2 05 B0 00 A0 80 21 27 A5 05 48 ?? ?? ?? ?? 00 80 88 21 04 40 00 BA 8F BC 00 10 8F A2 05 4C 8F 99 ?? ?? 26 04 00 30 AE 02 00 00 AE 02 00 04 8F A2 05 54 00 00 28 21 24 06 00 18 AE 02 00 08 8F A2 05 58 AE 00 00 24 AE 02 00 0C 8F A2 05 64 AE 02 00 10 8F A2 05 5C AE 02 00 14 8F A2 05 60 AE 02 00 18 8F A2 05 68 AE 02 00 20 8F A2 05 70 ?? ?? ?? ?? AE 02 00 2C 8F BC 00 10 8E 02 00 18 02 20 20 21 8F 91 ?? ?? AE 02 00 1C AE 00 00 28 02 20 C8 21 ?? ?? ?? ?? 27 A5 04 B0 02 20 B8 21 04 40 00 99 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 00 40 A0 21 8C 55 00 00 8F 84 ?? ?? 8F 92 ?? ?? 8F 91 ?? ?? 24 84 ?? ?? 02 20 C8 21 ?? ?? ?? ?? 26 45 ?? ?? 00 40 98 21 14 40 00 09 8F BC 00 10 8F 84 ?? ?? 26 45 ?? ?? 02 20 C8 21 ?? ?? ?? ?? 24 84 ?? ?? 00 40 98 21 10 40 00 7D 8F BC 00 10 8F 92 ?? ?? 27 B1 05 8C 27 B6 00 18 27 BE 04 18 02 60 20 21 02 20 28 21 02 C0 30 21 02 40 C8 21 ?? ?? ?? ?? 24 07 04 00 10 40 00 6E 8F BC 00 10 8F A4 05 90 02 E0 C8 21 ?? ?? ?? ?? 03 C0 28 21 04 40 FF F3 8F BC 00 10 8F A2 04 18 8F A3 04 B0 14 62 FF F0 02 60 20 21 8F A2 04 1C 8F A3 04 B4 14 62 FF ED 02 20 28 21 8F A2 05 98 8F 96 ?? ?? 8F 97 ?? ?? 8F 9E ?? ?? AF A2 05 A4 26 D6 ?? ?? 26 F7 ?? ?? 27 DE ?? ?? 8F 99 ?? ?? 27 A4 05 A4 ?? ?? ?? ?? 02 C0 28 21 00 40 88 21 10 40 00 51 8F BC 00 10 8F 92 ?? ?? 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 02 E0 28 21 14 40 00 04 8F BC 00 10 8E 02 00 28 10 00 00 45 34 42 00 01 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 03 C0 28 21 14 40 00 04 8F BC 00 10 8E 02 00 28 10 00 00 3C 34 42 00 02 8F 85 ?? ?? 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 00 04 8F BC 00 10 8E 02 00 28 10 00 00 32 34 42 00 08 8F 85 ?? ?? 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 00 04 8F BC 00 10 8E 02 00 28 10 00 00 28 34 42 00 04 8F 85 ?? ?? 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 00 04 8F BC 00 10 8E 02 00 28 10 00 00 1E 34 42 00 10 8F 85 ?? ?? 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 00 04 8F BC 00 10 8E 02 00 28 10 00 00 14 34 42 00 40 8F 85 ?? ?? 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 00 04 8F BC 00 10 8E 02 00 28 10 00 00 0A 34 42 04 00 8F 85 ?? ?? 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 FF AE 8F BC 00 10 8E 02 00 28 34 42 08 00 10 00 FF AA AE 02 00 28 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 10 00 00 03 AE 95 00 00 10 00 00 02 24 02 FF FF 00 00 10 21 8F BF 05 CC 8F BE 05 C8 8F B7 05 C4 8F B6 05 C0 8F B5 05 BC 8F B4 05 B8 8F B3 05 B4 8F B2 05 B0 8F B1 05 AC 8F B0 05 A8 03 E0 00 08 27 BD 05 D0 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "bsearch"
		size = 192
	strings:
		$1 = { 27 BD FF C8 AF B6 00 30 AF B5 00 2C AF B4 00 28 AF B1 00 1C AF B0 00 18 AF BF 00 34 AF B3 00 24 AF B2 00 20 00 80 A8 21 00 A0 B0 21 00 C0 80 21 00 E0 A0 21 14 E0 00 10 00 00 88 21 10 00 00 16 00 00 10 21 00 12 90 42 02 51 90 21 72 54 10 02 8F B9 00 48 02 A0 20 21 00 56 98 21 03 20 F8 09 02 60 28 21 18 40 00 09 00 00 00 00 26 51 00 01 02 00 90 21 02 40 80 21 02 30 10 2B 14 40 FF F1 02 11 90 23 10 00 00 04 00 00 10 21 14 40 FF FA 02 40 80 21 02 60 10 21 8F BF 00 34 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "l64a"
		size = 68
		refs = "0000 _gp_disp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 83 ?? ?? 24 42 ?? ?? 24 63 ?? ?? 10 80 00 07 30 85 00 3F 00 A3 28 21 90 A5 00 00 00 04 21 82 24 42 00 01 10 00 FF F9 A0 45 FF FF 03 E0 00 08 A0 40 00 00 }
	condition:
		$1
}

rule file_27_0_0 {
	meta:
		name = "getresgid"
		size = 164
		refs = "0000 _gp_disp 0050 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF BC 00 10 AF B3 00 38 AF B2 00 34 AF B1 00 30 00 80 98 21 00 A0 90 21 00 C0 88 21 AF BF 00 3C AF B0 00 2C 27 A4 00 20 27 A5 00 1C 27 A6 00 18 24 02 10 5F 00 00 00 0C 10 E0 00 07 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 10 00 00 08 24 10 FF FF 14 40 00 06 8F A2 00 20 AE 62 00 00 8F A2 00 1C AE 42 00 00 8F A2 00 18 AE 22 00 00 8F BF 00 3C 02 00 10 21 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "clearerr_unlocked"
		size = 16
	strings:
		$1 = { 94 82 00 00 30 42 FF F3 03 E0 00 08 A4 82 00 00 }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "_uintmaxtostr"
		size = 252
	strings:
		$1 = { 8F A3 00 10 00 80 10 21 8F AB 00 14 04 61 00 08 00 00 48 21 04 C1 00 06 00 03 18 23 00 07 38 23 00 07 20 2B 00 06 30 23 00 C4 30 23 24 09 00 01 24 05 FF FF 00 A3 00 1B 00 60 01 F4 A0 40 00 00 00 00 40 10 25 08 00 01 15 03 00 03 00 00 28 12 24 A5 00 01 00 00 40 21 10 C0 00 13 00 00 00 00 00 C3 00 1B 00 60 01 F4 00 00 50 10 00 00 30 12 00 E3 00 1B 00 60 01 F4 00 00 20 10 00 00 60 12 71 48 38 02 00 E4 20 21 71 45 38 02 00 83 00 1B 00 60 01 F4 00 EC 50 21 00 00 38 12 01 47 38 21 10 00 00 05 00 00 20 10 00 E3 00 1B 00 60 01 F4 00 00 20 10 00 00 38 12 2C 8A 00 0A 11 40 00 03 24 42 FF FF 10 00 00 02 24 84 00 30 00 8B 20 21 7C 04 24 20 A0 44 00 00 00 E6 20 25 14 80 FF DE 00 00 00 00 11 20 00 03 24 03 00 2D A0 43 FF FF 24 42 FF FF 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "umask"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F DC 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "__GI_snprintf"
		size = 60
		refs = "0000 _gp_disp 0010 __GI_vsnprintf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 8F 99 ?? ?? AF A7 00 34 27 A7 00 34 AF BF 00 24 AF BC 00 10 AF A7 00 18 ?? ?? ?? ?? 00 00 00 00 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_38_0_0 {
	meta:
		name = "swprintf"
		size = 60
		refs = "0000 _gp_disp 0010 __GI_vswprintf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 8F 99 ?? ?? AF A7 00 34 27 A7 00 34 AF BF 00 24 AF BC 00 10 AF A7 00 18 ?? ?? ?? ?? 00 00 00 00 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "__GI_ftruncate"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F FD 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "__GI_bind"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 49 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "puts"
		size = 224
		refs = "0000 _gp_disp 000c stdout 003c _pthread_cleanup_push_defer 0040 __pthread_mutex_unlock 0058 __pthread_mutex_lock 0068 __GI_fputs_unlocked 0084 __GI___fputc_unlocked 00b0 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 27 BD FF C0 AF B3 00 38 AF BC 00 10 AF BF 00 3C AF B2 00 34 AF B1 00 30 AF B0 00 2C 8C 51 00 00 8E 32 00 34 16 40 00 0C 00 80 98 21 8F 99 ?? ?? 8F 85 ?? ?? 26 30 00 38 27 A4 00 18 ?? ?? ?? ?? 02 00 30 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F 99 ?? ?? 02 60 20 21 ?? ?? ?? ?? 02 20 28 21 24 10 FF FF 10 50 00 0A 8F BC 00 10 8F 99 ?? ?? 24 04 00 0A 02 20 28 21 ?? ?? ?? ?? 24 50 00 01 8F BC 00 10 00 02 10 27 24 03 FF FF 00 62 80 0A 16 40 00 06 8F BF 00 3C 8F 99 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F BF 00 3C 02 00 10 21 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "fchmod"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F FE 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_36_0_0 {
	meta:
		name = "alphasort"
		size = 36
		refs = "0000 _gp_disp 0014 __GI_strcmp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8C 84 00 00 8C A5 00 00 8F 99 ?? ?? 24 84 00 0B ?? ?? ?? ?? 24 A5 00 0B }
	condition:
		$1
}

rule file_344_0_0 {
	meta:
		name = "versionsort"
		size = 36
		refs = "0000 _gp_disp 0014 __GI_strverscmp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8C 84 00 00 8C A5 00 00 8F 99 ?? ?? 24 84 00 0B ?? ?? ?? ?? 24 A5 00 0B }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "lrand48"
		size = 60
		refs = "0000 _gp_disp 000c __libc_drand48_data 0010 __GI_nrand48_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 84 ?? ?? 8F 99 ?? ?? 27 BD FF D8 27 A6 00 18 AF BF 00 24 AF BC 00 10 ?? ?? ?? ?? 00 80 28 21 8F BF 00 24 8F A2 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_460_0_0 {
	meta:
		name = "mrand48"
		size = 60
		refs = "0000 _gp_disp 000c __libc_drand48_data 0010 __GI_jrand48_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 84 ?? ?? 8F 99 ?? ?? 27 BD FF D8 27 A6 00 18 AF BF 00 24 AF BC 00 10 ?? ?? ?? ?? 00 80 28 21 8F BF 00 24 8F A2 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "wcscspn"
		size = 48
	strings:
		$1 = { 00 80 10 21 8C 46 00 00 10 C0 00 06 00 A0 18 21 8C 67 00 00 50 E0 FF FB 24 42 00 04 14 E6 FF FC 24 63 00 04 00 44 10 23 03 E0 00 08 00 02 10 83 }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "__GI_gethostbyname_r"
		size = 864
		refs = "0000 _gp_disp 0054 __GI___errno_location 0074 __get_hosts_byname_r 00f4 __GI_strlen 0124 __GI_memcpy 0160 __GI_inet_aton 01d4 __dns_lookup 0248 __GI_memmove 02c4 __GI_strcpy 030c free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 78 AF B6 00 78 8F B6 00 98 AF BC 00 20 AF B5 00 74 AF B1 00 64 AF BF 00 84 AF BE 00 80 AF B7 00 7C AF B4 00 70 AF B3 00 6C AF B2 00 68 AF B0 00 60 00 80 A8 21 8F B1 00 9C AE C0 00 00 10 80 00 B8 24 02 00 16 8F 99 ?? ?? 00 A0 80 21 00 C0 A0 21 ?? ?? ?? ?? 00 E0 90 21 8F BC 00 20 8C 5E 00 00 02 A0 20 21 8F 99 ?? ?? AC 40 00 00 24 05 00 02 AF B2 00 10 AF B6 00 14 AF B1 00 18 02 00 30 21 02 80 38 21 ?? ?? ?? ?? 00 40 98 21 14 40 00 03 8F BC 00 20 10 00 00 A2 AE 7E 00 00 8E 23 00 00 24 04 00 01 10 64 00 07 24 04 00 04 10 64 00 0B 24 04 FF FF 14 64 00 9B 8F BF 00 84 10 00 00 04 8E 64 00 00 38 42 00 02 10 00 00 05 2C 57 00 01 24 03 00 02 14 83 00 93 8F BF 00 84 00 00 B8 21 AE 7E 00 00 8F 93 ?? ?? 24 02 FF FF AE 22 00 00 02 60 C8 21 ?? ?? ?? ?? 02 A0 20 21 24 5E 00 01 03 D2 10 2A 14 40 00 03 8F BC 00 20 10 00 00 84 24 02 00 22 8F 99 ?? ?? 02 80 20 21 03 C0 30 21 ?? ?? ?? ?? 02 A0 28 21 02 9E 10 21 00 02 98 23 02 5E 90 23 32 73 00 03 02 53 18 23 24 7E FF F8 2B C4 01 00 14 80 FF F1 8F BC 00 20 00 53 98 21 8F 99 ?? ?? 26 66 00 10 AE 74 00 00 AE 60 00 04 00 C0 28 21 AF A3 00 58 AF A6 00 5C ?? ?? ?? ?? 02 A0 20 21 26 72 00 08 8F BC 00 20 8F A3 00 58 10 40 00 0E 8F A6 00 5C 24 02 00 02 AE 66 00 08 AE 60 00 0C AE 02 00 08 24 02 00 04 AE 02 00 0C AE 14 00 00 AE 13 00 04 AE 12 00 10 00 00 10 21 AE D0 00 00 10 00 00 5A AE 20 00 00 16 E0 00 0E 24 02 00 01 8F 99 ?? ?? 24 63 FF EC AF B2 00 44 AF A3 00 48 AF A0 00 4C 02 A0 20 21 24 05 00 01 27 A6 00 50 ?? ?? ?? ?? 27 A7 00 28 04 41 00 05 8F BC 00 20 24 02 00 01 AE 22 00 00 10 00 00 48 24 02 00 02 8F A3 00 2C 24 02 00 01 54 62 00 3A AE 22 00 00 8F B7 00 4C 8F A6 00 38 26 F5 00 03 72 E6 30 02 00 15 A8 80 02 A6 10 21 03 C2 F0 23 07 C0 00 32 24 02 00 22 8F 99 ?? ?? 02 55 20 21 ?? ?? ?? ?? 02 40 28 21 8F BC 00 20 26 B5 FF FC 8F A5 00 3C 8F 99 ?? ?? 02 55 A8 21 02 A0 20 21 ?? ?? ?? ?? 24 06 00 04 8F BC 00 20 00 00 10 21 00 02 18 80 02 E2 20 2B 14 80 00 05 02 43 18 21 AC 75 00 00 24 42 00 01 10 00 FF F9 26 B5 00 04 8F B7 00 28 12 E0 00 0D AC 60 00 00 8F 99 ?? ?? ?? ?? ?? ?? 02 E0 20 21 00 5E 10 2B 10 40 00 07 8F BC 00 20 8F 99 ?? ?? 02 A0 20 21 ?? ?? ?? ?? 02 E0 28 21 8F BC 00 20 02 A0 A0 21 24 02 00 02 AE 02 00 08 24 02 00 04 AE 02 00 0C AE 14 00 00 AE 13 00 04 AE 12 00 10 00 00 10 21 AE D0 00 00 10 00 00 02 AE 20 00 00 24 02 00 02 8F 99 ?? ?? 8F A4 00 28 ?? ?? ?? ?? AF A2 00 58 8F BC 00 20 8F 99 ?? ?? ?? ?? ?? ?? 8F A4 00 50 8F A2 00 58 8F BF 00 84 8F BE 00 80 8F B7 00 7C 8F B6 00 78 8F B5 00 74 8F B4 00 70 8F B3 00 6C 8F B2 00 68 8F B1 00 64 8F B0 00 60 03 E0 00 08 27 BD 00 88 }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "__GI_ioperm"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 05 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "usleep"
		size = 92
		refs = "0000 _gp_disp 0024 __GI_nanosleep"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 3C 02 00 0F 24 42 42 40 00 82 00 1B 00 40 01 F4 27 BD FF D8 24 03 03 E8 8F 99 ?? ?? AF BF 00 24 AF BC 00 10 00 00 28 21 00 00 20 10 00 00 10 12 AF A2 00 18 70 83 10 02 27 A4 00 18 ?? ?? ?? ?? AF A2 00 1C 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "__GI_memrchr"
		size = 240
	strings:
		$1 = { 30 A3 00 FF 00 86 10 21 10 C0 00 09 30 44 00 03 50 80 00 08 30 A5 00 FF 24 42 FF FF 90 44 00 00 10 83 00 31 24 C6 FF FF 10 00 FF F7 00 00 00 00 30 A5 00 FF 00 05 22 00 00 85 28 25 00 05 24 00 3C 07 7E FE 3C 08 81 01 00 85 28 25 34 E7 FE FF 25 08 01 00 2C C4 00 04 14 80 00 20 00 00 00 00 24 42 FF FC 8C 44 00 00 00 A4 20 26 00 04 48 27 00 87 20 21 01 24 20 26 00 88 20 24 50 80 FF F5 24 C6 FF FC 90 44 00 03 54 83 00 03 90 44 00 02 03 E0 00 08 24 42 00 03 54 83 00 03 90 44 00 01 03 E0 00 08 24 42 00 02 54 83 00 03 90 44 00 00 03 E0 00 08 24 42 00 01 10 83 00 0B 24 C6 FF FC 10 00 FF E5 2C C4 00 04 24 42 FF FF 00 80 30 21 90 44 00 00 10 83 00 04 00 00 00 00 14 C0 FF FA 24 C4 FF FF 00 00 10 21 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "__GI_hcreate_r"
		size = 200
		refs = "0000 _gp_disp 0024 __GI___errno_location 0090 calloc"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF B0 00 18 AF BF 00 1C 14 A0 00 08 00 A0 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 AC 43 00 00 10 00 00 1F 00 00 10 21 8C A3 00 00 00 00 10 21 14 60 00 1B 34 84 00 01 24 02 00 03 70 42 18 02 00 64 18 2B 10 60 00 08 00 00 00 00 00 82 00 1B 00 40 01 F4 00 00 18 10 10 60 00 06 24 42 00 02 10 00 FF F6 00 00 00 00 00 82 00 1B 00 40 01 F4 00 00 18 10 14 60 00 03 8F 99 ?? ?? 10 00 FF EE 24 84 00 02 AE 04 00 04 AE 00 00 08 24 84 00 01 ?? ?? ?? ?? 24 05 00 0C AE 02 00 00 00 02 10 2B 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "wmemmove"
		size = 84
	strings:
		$1 = { 00 A4 18 2B 14 60 00 09 00 80 10 21 00 80 18 21 10 C0 00 0E 24 C6 FF FF 8C A4 00 00 24 A5 00 04 AC 64 00 00 10 00 FF FA 24 63 00 04 10 C0 00 07 24 C6 FF FF 00 06 18 80 00 A3 20 21 8C 84 00 00 00 43 18 21 10 00 FF F9 AC 64 00 00 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "sched_rr_get_interval"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 45 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "setgid"
		size = 120
		refs = "0000 _gp_disp 0024 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 24 02 FF FF AF BC 00 10 AF BF 00 1C AF B0 00 18 14 82 00 07 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 AC 43 00 00 10 00 00 0B 24 02 FF FF 24 02 0F CE 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 02 00 10 21 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "__malloc_trim.constprop.0"
		size = 260
		refs = "0000 _gp_disp 0014 __malloc_state 0068 __GI_sbrk"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 AF B0 00 18 8F 90 ?? ?? AF B4 00 28 AF B2 00 20 AF BC 00 10 AF BF 00 2C AF B3 00 24 AF B1 00 1C 8E 02 00 2C 8E 03 03 5C 24 12 FF FC 8C 42 00 04 24 74 FF EF 02 42 90 24 02 92 A0 21 02 84 20 23 00 83 00 1B 00 60 01 F4 00 00 A0 12 26 94 FF FF 72 83 A0 02 1E 80 00 03 8F 91 ?? ?? 10 00 00 1D 00 00 10 21 02 20 C8 21 ?? ?? ?? ?? 00 00 20 21 00 40 98 21 8E 02 00 2C 00 52 10 21 16 62 00 15 00 00 10 21 02 20 C8 21 ?? ?? ?? ?? 00 14 20 23 02 20 C8 21 ?? ?? ?? ?? 00 00 20 21 24 03 FF FF 50 43 00 0C 00 00 10 21 02 62 10 23 50 40 00 09 00 00 10 21 8E 03 03 68 00 62 18 23 AE 03 03 68 8E 03 00 2C 02 42 10 23 34 42 00 01 AC 62 00 04 24 02 00 01 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_49_1_0 {
	meta:
		name = "__malloc_consolidate"
		size = 476
		refs = "0000 _gp_disp 00b0 __GI_abort 0198 __GI_sysconf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF B0 00 18 AF BC 00 10 AF BF 00 1C 8C 82 00 00 10 40 00 4E 00 80 80 21 24 03 FF FD 00 43 10 24 00 02 50 C2 25 4A FF FE 00 0A 50 80 00 8A 50 21 AC 82 00 00 24 89 00 34 25 4A 00 04 24 85 00 04 24 0B FF FE 24 0C FF FC 8C A2 00 00 54 40 00 05 AC A0 00 00 10 AA 00 59 24 A2 00 04 10 00 FF FA 00 40 28 21 8C 47 00 04 8C 4D 00 08 00 EB 18 24 00 43 20 21 8C 86 00 04 30 E7 00 01 14 E0 00 10 01 86 30 24 8C 47 00 00 00 47 10 23 8C 48 00 08 00 67 18 21 8D 0E 00 0C 11 C2 00 04 8C 47 00 0C 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8C EE 00 08 15 C2 FF FC 8F 99 ?? ?? AD 07 00 0C AC E8 00 08 8E 07 00 2C 10 87 00 19 00 86 38 21 8C E7 00 04 30 E7 00 01 14 E0 00 0B AC 86 00 04 8C 87 00 08 00 66 18 21 8C E8 00 0C 15 04 FF ED 8C 86 00 0C 8C C8 00 08 15 04 FF EB 8F 99 ?? ?? AC E6 00 0C AC C7 00 08 8E 04 00 3C 34 66 00 01 AE 02 00 3C AC 82 00 0C AC 46 00 04 AC 49 00 0C AC 44 00 08 00 43 10 21 10 00 00 05 AC 43 00 00 00 66 18 21 34 63 00 01 AC 43 00 04 AE 02 00 2C 15 A0 FF C9 01 A0 10 21 10 00 FF C3 00 00 00 00 24 02 00 01 24 04 00 60 00 02 18 C0 02 03 18 21 24 63 00 2C 24 42 00 01 AC 63 00 0C 14 44 FF FA AC 63 00 08 3C 02 00 01 AE 02 03 54 3C 02 00 04 AE 02 03 4C AE 02 03 44 8E 02 03 60 8F 99 ?? ?? AE 00 03 48 34 42 00 01 AE 02 03 60 8E 02 00 00 24 04 00 1E 30 42 00 03 34 42 00 48 AE 02 00 00 26 02 00 34 ?? ?? ?? ?? AE 02 00 2C AE 02 03 5C 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_49_2_0 {
	meta:
		name = "malloc_trim"
		size = 80
		refs = "0000 _gp_disp 0010 __malloc_consolidate 001c __malloc_state 0048 __malloc_trim.constprop.0"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 8F 99 ?? ?? AF B0 00 18 00 80 80 21 8F 84 ?? ?? AF BC 00 10 AF BF 00 1C ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F BF 00 1C 02 00 20 21 8F 99 ?? ?? 8F B0 00 18 27 39 ?? ?? ?? ?? ?? ?? 27 BD 00 20 }
	condition:
		$1
}

rule file_49_3_0 {
	meta:
		name = "free"
		size = 600
		refs = "0000 _gp_disp 002c __pthread_mutex_unlock 0030 __malloc_lock 0034 _pthread_cleanup_push_defer 004c __pthread_mutex_lock 0064 __malloc_state 00f0 __GI_abort 019c _pthread_cleanup_pop_restore 01b4 __malloc_consolidate 01f0 __malloc_trim.constprop.0 0208 __GI_munmap"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF BC 00 10 AF B1 00 2C AF BF 00 34 AF B2 00 30 AF B0 00 28 10 80 00 86 00 80 88 21 8F 85 ?? ?? 8F 86 ?? ?? 8F 99 ?? ?? 27 B2 00 18 ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8E 27 FF FC 24 06 FF FC 8F 83 ?? ?? 00 E6 28 24 26 22 FF F8 8C 64 00 00 00 85 40 2B 15 00 00 0B 00 60 80 21 00 05 28 C2 24 A5 FF FE 34 84 00 03 00 05 28 80 AC 64 00 00 00 65 18 21 8C 64 00 04 AE 24 00 00 10 00 00 63 AC 62 00 04 30 E7 00 02 14 E0 00 54 34 84 00 01 AC 64 00 00 00 45 18 21 8C 64 00 04 00 C4 30 24 8E 24 FF FC 30 84 00 01 54 80 00 11 8E 04 00 2C 8E 24 FF F8 00 44 10 23 8C 47 00 08 00 A4 28 21 8C E8 00 0C 11 02 00 04 8C 44 00 0C 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8C 88 00 08 15 02 FF FC 8F 99 ?? ?? AC E4 00 0C AC 87 00 08 8E 04 00 2C 10 64 00 19 00 66 20 21 8C 84 00 04 30 84 00 01 14 80 00 0A AC 66 00 04 8C 64 00 08 8C 88 00 0C 15 03 FF EE 8C 67 00 0C 8C E8 00 08 15 03 FF EB 00 A6 28 21 AC 87 00 0C AC E4 00 08 8E 03 00 3C 26 04 00 34 AC 44 00 0C AC 43 00 08 AE 02 00 3C AC 62 00 0C 34 A3 00 01 AC 43 00 04 00 45 10 21 10 00 00 06 AC 45 00 00 00 A6 28 21 34 A3 00 01 AC 43 00 04 8F 83 ?? ?? AC 62 00 2C 3C 02 00 02 00 A2 28 2B 14 A0 00 26 8F 99 ?? ?? 8E 02 00 00 30 42 00 02 50 40 00 07 8E 02 00 2C 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8E 02 00 2C 24 03 FF FC 8C 42 00 04 00 62 10 24 8E 03 03 44 00 43 10 2B 14 40 00 15 8F 99 ?? ?? 8F 82 ?? ?? 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 8C 44 03 48 10 00 00 0D 8F BC 00 10 8C 66 03 50 8E 24 FF F8 8F 99 ?? ?? 24 C6 FF FF AC 66 03 50 8C 66 03 64 00 A4 28 21 00 44 20 23 00 C5 30 23 ?? ?? ?? ?? AC 66 03 64 8F BC 00 10 8F 99 ?? ?? 02 40 20 21 ?? ?? ?? ?? 24 05 00 01 8F BF 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "__GI_rmdir"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F C8 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_52_0_0 {
	meta:
		name = "__GI_tolower"
		size = 56
		refs = "0000 _gp_disp 001c __GI___ctype_tolower"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 24 83 00 80 2C 63 01 80 10 60 00 06 00 80 10 21 8F 83 ?? ?? 00 04 10 40 8C 63 00 00 00 62 10 21 84 42 00 00 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_191_0_0 {
	meta:
		name = "__GI_toupper"
		size = 56
		refs = "0000 _gp_disp 001c __GI___ctype_toupper"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 24 83 00 80 2C 63 01 80 10 60 00 06 00 80 10 21 8F 83 ?? ?? 00 04 10 40 8C 63 00 00 00 62 10 21 84 42 00 00 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "posix_memalign"
		size = 96
		refs = "0000 _gp_disp 0030 memalign"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF B0 00 18 AF BC 00 10 00 80 80 21 30 A4 00 03 AF BF 00 1C 00 A0 18 21 14 80 00 09 24 02 00 16 8F 99 ?? ?? 00 60 20 21 ?? ?? ?? ?? 00 C0 28 21 24 03 00 0C 00 02 18 0B AE 02 00 00 00 60 10 21 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_54_0_0 {
	meta:
		name = "wcstombs"
		size = 56
		refs = "0000 _gp_disp 000c __GI_wcsrtombs"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 00 00 38 21 AF BF 00 24 AF BC 00 10 AF A5 00 18 ?? ?? ?? ?? 27 A5 00 18 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "tcdrain"
		size = 28
		refs = "0000 _gp_disp 000c __GI_ioctl"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 24 05 54 05 ?? ?? ?? ?? 24 06 00 01 }
	condition:
		$1
}

rule file_56_0_0 {
	meta:
		name = "__GI_random_r"
		size = 136
	strings:
		$1 = { 80 83 00 0C 14 60 00 0A 8C 82 00 08 8C 44 00 00 3C 03 41 C6 24 63 4E 6D 70 83 18 02 24 63 30 39 7C 63 F0 00 AC 43 00 00 10 00 00 15 AC A3 00 00 8C 83 00 00 8C 87 00 04 8C 86 00 10 8C 69 00 00 8C E8 00 00 24 63 00 04 01 28 40 21 AC 68 FF FC 00 08 40 42 AC A8 00 00 00 66 40 2B 15 00 00 04 24 E5 00 04 00 40 18 21 10 00 00 03 00 A0 10 21 00 A6 30 2B 00 A6 10 0B AC 83 00 00 AC 82 00 04 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_56_1_0 {
	meta:
		name = "__GI_srandom_r"
		size = 260
		refs = "0000 _gp_disp 00a4 __GI_random_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 00 A0 50 21 80 A5 00 0C 2C A2 00 05 10 40 00 36 00 00 00 00 8D 43 00 08 24 02 00 01 00 84 10 0B 10 A0 00 33 AC 62 00 00 81 46 00 0D 3C 07 00 01 3C 0C 7F FF 00 60 28 21 24 04 00 01 34 E7 F3 1D 24 09 41 A7 24 0B F4 EC 35 8C FF FF 00 86 40 2A 11 00 00 0E 24 A5 00 04 00 47 00 1A 00 E0 01 F4 24 84 00 01 00 00 10 12 00 00 40 10 00 4B 00 18 71 09 00 00 00 00 10 12 00 4C 40 21 28 4D 00 00 01 0D 10 0B 10 00 FF F1 AC A2 00 00 24 0B 00 0A 70 CB 58 02 81 42 00 0E 8F 99 ?? ?? 27 BD FF D8 00 02 10 80 00 62 10 21 AD 42 00 00 AF BC 00 10 AF BF 00 24 AD 43 00 04 27 AC 00 18 25 6B FF FF 05 61 00 05 01 40 20 21 8F BF 00 24 00 00 10 21 03 E0 00 08 27 BD 00 28 ?? ?? ?? ?? 01 80 28 21 10 00 FF F7 25 6B FF FF 03 E0 00 08 24 02 FF FF 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_56_2_0 {
	meta:
		name = "__GI_initstate_r"
		size = 260
		refs = "0000 _gp_disp 0054 __GI___errno_location 00a8 __GI_srandom_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 2C C2 00 80 AF BC 00 10 AF BF 00 1C AF B0 00 18 00 A0 C0 21 14 40 00 05 00 E0 78 21 2C C6 01 00 24 0E 00 03 10 00 00 10 24 02 00 04 2C C2 00 20 50 40 00 0B 2C C6 00 40 2C C6 00 08 10 C0 00 0B 00 00 70 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 AC 43 00 00 10 00 00 22 24 02 FF FF 24 0E 00 01 24 02 00 02 00 46 70 0A 8F 83 ?? ?? 25 C2 00 04 00 02 10 80 24 63 ?? ?? 00 62 10 21 8C 42 00 04 00 0E 28 80 00 A3 18 21 8C 63 00 00 27 10 00 04 A1 E2 00 0D 8F 99 ?? ?? 00 02 10 80 02 02 10 21 A1 EE 00 0C A1 E3 00 0E AD E2 00 10 AD F0 00 08 ?? ?? ?? ?? 01 E0 28 21 AF 00 00 00 11 C0 00 08 00 00 10 21 8D E3 00 04 00 70 80 23 00 10 80 83 24 03 00 05 72 03 20 02 00 8E 70 21 AF 0E 00 00 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_56_3_0 {
	meta:
		name = "__GI_setstate_r"
		size = 272
		refs = "0000 _gp_disp 00ec __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 80 A6 00 0C 27 BD FF E0 AF BC 00 10 AF BF 00 1C 24 83 00 04 14 C0 00 03 8C A2 00 08 10 00 00 08 AC 40 FF FC 8C A8 00 04 24 07 00 05 01 02 40 23 00 08 40 83 71 07 48 02 01 26 30 21 AC 46 FF FC 8C 82 00 00 24 07 00 05 00 47 00 1A 00 E0 01 F4 00 00 10 10 2C 46 00 05 10 C0 00 21 8F 88 ?? ?? 24 46 00 04 00 06 30 80 25 08 ?? ?? 00 02 48 80 01 06 30 21 01 28 40 21 8C C6 00 04 8D 08 00 00 A0 A2 00 0C A0 A6 00 0D 10 40 00 0F A0 A8 00 0E 8C 82 00 00 00 47 00 1A 00 E0 01 F4 00 00 38 12 00 07 10 80 00 E8 38 21 00 E6 00 1A 00 C0 01 F4 00 62 10 21 AC A2 00 04 00 00 10 10 00 02 38 80 00 67 38 21 AC A7 00 00 00 06 30 80 AC A3 00 08 00 66 18 21 AC A3 00 10 10 00 00 07 00 00 10 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 AC 43 00 00 24 02 FF FF 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_57_0_0 {
	meta:
		name = "sched_setscheduler"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 40 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "semop"
		size = 68
		refs = "0000 _gp_disp 000c __syscall_ipc"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 00 80 10 21 24 04 00 01 AF BF 00 24 AF BC 00 18 AF A5 00 10 AF A0 00 14 00 40 28 21 ?? ?? ?? ?? 00 00 38 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "shmdt"
		size = 68
		refs = "0000 _gp_disp 000c __syscall_ipc"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 00 00 28 21 00 00 30 21 AF BF 00 24 AF BC 00 18 AF A4 00 10 AF A0 00 14 24 04 00 16 ?? ?? ?? ?? 00 00 38 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "initgroups"
		size = 136
		refs = "0000 _gp_disp 000c __getgrouplist_internal 0044 __GI_setgroups 005c free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 3C 02 7F FF 27 BD FF D0 34 42 FF FF AF BC 00 10 AF B0 00 24 AF BF 00 2C AF B1 00 28 AF A2 00 18 ?? ?? ?? ?? 27 A6 00 18 00 40 80 21 10 40 00 0C 8F BC 00 10 8F 99 ?? ?? 8F A4 00 18 ?? ?? ?? ?? 00 40 28 21 8F BC 00 10 00 40 88 21 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 10 00 00 02 02 20 10 21 24 02 FF FF 8F BF 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "__GI_chmod"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F AF 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "__GI_getdtablesize"
		size = 72
		refs = "0000 _gp_disp 000c __GI_getrlimit"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 27 A5 00 18 AF BF 00 24 AF BC 00 10 ?? ?? ?? ?? 24 04 00 05 8F A4 00 18 8F BF 00 24 28 42 00 00 24 03 01 00 00 82 18 0A 00 60 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "__GI_getgroups"
		size = 324
		refs = "0000 _gp_disp 0030 __GI___errno_location 004c __GI_sysconf 0080 malloc 00dc free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 AF BC 00 10 AF B0 00 1C AF BF 00 2C AF B3 00 28 AF B2 00 24 AF B1 00 20 04 81 00 08 00 80 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 AC 43 00 00 10 00 00 38 24 02 FF FF 8F 91 ?? ?? 24 04 00 03 02 20 C8 21 ?? ?? ?? ?? 00 A0 98 21 02 02 10 2A 14 40 00 06 8F BC 00 10 02 20 C8 21 ?? ?? ?? ?? 24 04 00 03 8F BC 00 10 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 10 20 80 00 40 90 21 12 00 00 03 8F BC 00 10 10 40 FF E6 8F 99 ?? ?? 02 00 20 21 02 40 28 21 24 02 0F F0 00 00 00 0C 10 E0 00 08 00 40 88 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 AC 51 00 00 10 00 00 03 24 11 FF FF 16 00 00 06 00 00 00 00 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 10 00 00 0F 02 20 10 21 18 40 FF FB 8F 99 ?? ?? 00 00 10 21 00 02 18 80 02 63 20 21 02 43 18 21 8C 63 00 00 24 42 00 01 AC 83 00 00 00 51 18 2A 14 60 FF F9 00 02 18 80 10 00 FF EF 8F 99 ?? ?? 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_65_0_0 {
	meta:
		name = "swscanf"
		size = 64
		refs = "0000 _gp_disp 0010 __GI_vswscanf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 8F 99 ?? ?? AF A6 00 30 27 A6 00 30 AF BF 00 24 AF BC 00 10 AF A7 00 34 AF A6 00 18 ?? ?? ?? ?? 00 00 00 00 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_272_0_0 {
	meta:
		name = "__GI_asprintf"
		size = 64
		refs = "0000 _gp_disp 0010 __GI_vasprintf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 8F 99 ?? ?? AF A6 00 30 27 A6 00 30 AF BF 00 24 AF BC 00 10 AF A7 00 34 AF A6 00 18 ?? ?? ?? ?? 00 00 00 00 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_256_0_0 {
	meta:
		name = "__GI_fprintf"
		size = 64
		refs = "0000 _gp_disp 0010 __GI_vfprintf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 8F 99 ?? ?? AF A6 00 30 27 A6 00 30 AF BF 00 24 AF BC 00 10 AF A7 00 34 AF A6 00 18 ?? ?? ?? ?? 00 00 00 00 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_839_0_0 {
	meta:
		name = "__GI_fscanf"
		size = 64
		refs = "0000 _gp_disp 0010 __GI_vfscanf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 8F 99 ?? ?? AF A6 00 30 27 A6 00 30 AF BF 00 24 AF BC 00 10 AF A7 00 34 AF A6 00 18 ?? ?? ?? ?? 00 00 00 00 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_467_0_0 {
	meta:
		name = "__GI_fwprintf"
		size = 64
		refs = "0000 _gp_disp 0010 __GI_vfwprintf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 8F 99 ?? ?? AF A6 00 30 27 A6 00 30 AF BF 00 24 AF BC 00 10 AF A7 00 34 AF A6 00 18 ?? ?? ?? ?? 00 00 00 00 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_564_0_0 {
	meta:
		name = "__GI_sscanf"
		size = 64
		refs = "0000 _gp_disp 0010 __GI_vsscanf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 8F 99 ?? ?? AF A6 00 30 27 A6 00 30 AF BF 00 24 AF BC 00 10 AF A7 00 34 AF A6 00 18 ?? ?? ?? ?? 00 00 00 00 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_708_3_0 {
	meta:
		name = "__GI_syslog"
		size = 64
		refs = "0000 _gp_disp 0010 __GI_vsyslog"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 8F 99 ?? ?? AF A6 00 30 27 A6 00 30 AF BF 00 24 AF BC 00 10 AF A7 00 34 AF A6 00 18 ?? ?? ?? ?? 00 00 00 00 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_135_0_0 {
	meta:
		name = "dprintf"
		size = 64
		refs = "0000 _gp_disp 0010 __GI_vdprintf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 8F 99 ?? ?? AF A6 00 30 27 A6 00 30 AF BF 00 24 AF BC 00 10 AF A7 00 34 AF A6 00 18 ?? ?? ?? ?? 00 00 00 00 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_343_0_0 {
	meta:
		name = "fwscanf"
		size = 64
		refs = "0000 _gp_disp 0010 __GI_vfwscanf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 8F 99 ?? ?? AF A6 00 30 27 A6 00 30 AF BF 00 24 AF BC 00 10 AF A7 00 34 AF A6 00 18 ?? ?? ?? ?? 00 00 00 00 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "__GI_strcspn"
		size = 124
		refs = "0000 _gp_disp 0014 __GI_strchr"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 AF B2 00 24 8F 92 ?? ?? AF B3 00 28 AF B1 00 20 AF B0 00 1C AF BC 00 10 AF BF 00 2C 00 80 88 21 00 A0 98 21 00 00 80 21 82 25 00 00 10 A0 00 07 02 40 C8 21 ?? ?? ?? ?? 02 60 20 21 14 40 00 03 26 31 00 01 10 00 FF F8 26 10 00 01 8F BF 00 2C 02 00 10 21 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_68_0_0 {
	meta:
		name = "__GI_statfs64"
		size = 200
		refs = "0000 _gp_disp 000c __libc_statfs 0038 __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF 98 AF BC 00 10 AF B0 00 60 AF BF 00 64 00 A0 80 21 ?? ?? ?? ?? 27 A5 00 18 04 40 00 21 8F BC 00 10 8F A2 00 18 8F 99 ?? ?? AE 00 00 10 AE 02 00 00 8F A2 00 1C AE 00 00 18 AE 00 00 30 AE 02 00 04 8F A2 00 24 AE 00 00 20 AE 00 00 28 AE 02 00 14 8F A2 00 28 26 04 00 44 27 A5 00 44 AE 02 00 1C 8F A2 00 34 24 06 00 18 AE 02 00 34 8F A2 00 2C AE 02 00 24 8F A2 00 30 AE 02 00 2C 8F A2 00 38 AE 02 00 38 8F A2 00 3C AE 02 00 3C 8F A2 00 40 ?? ?? ?? ?? AE 02 00 40 10 00 00 02 00 00 10 21 24 02 FF FF 8F BF 00 64 8F B0 00 60 03 E0 00 08 27 BD 00 68 }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "__GI_fstatfs64"
		size = 200
		refs = "0000 _gp_disp 000c __libc_fstatfs 0038 __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF 98 AF BC 00 10 AF B0 00 60 AF BF 00 64 00 A0 80 21 ?? ?? ?? ?? 27 A5 00 18 04 40 00 21 8F BC 00 10 8F A2 00 18 8F 99 ?? ?? AE 00 00 10 AE 02 00 00 8F A2 00 1C AE 00 00 18 AE 00 00 30 AE 02 00 04 8F A2 00 24 AE 00 00 20 AE 00 00 28 AE 02 00 14 8F A2 00 28 26 04 00 44 27 A5 00 44 AE 02 00 1C 8F A2 00 34 24 06 00 18 AE 02 00 34 8F A2 00 2C AE 02 00 24 8F A2 00 30 AE 02 00 2C 8F A2 00 38 AE 02 00 38 8F A2 00 3C AE 02 00 3C 8F A2 00 40 ?? ?? ?? ?? AE 02 00 40 10 00 00 02 00 00 10 21 24 02 FF FF 8F BF 00 64 8F B0 00 60 03 E0 00 08 27 BD 00 68 }
	condition:
		$1
}

rule file_69_0_0 {
	meta:
		name = "__GI_strtod"
		size = 92
		refs = "0000 _gp_disp 000c __strtofpmax 0030 __fp_range_check"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BF 00 24 AF BC 00 10 ?? ?? ?? ?? 00 00 30 21 8F BC 00 10 00 60 28 21 00 40 20 21 8F 99 ?? ?? 00 60 38 21 00 40 30 21 AF A2 00 18 ?? ?? ?? ?? AF A3 00 1C 8F BF 00 24 8F A2 00 18 8F A3 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_804_0_0 {
	meta:
		name = "__GI_wcstod"
		size = 92
		refs = "0000 _gp_disp 000c __wcstofpmax 0030 __fp_range_check"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BF 00 24 AF BC 00 10 ?? ?? ?? ?? 00 00 30 21 8F BC 00 10 00 60 28 21 00 40 20 21 8F 99 ?? ?? 00 60 38 21 00 40 30 21 AF A2 00 18 ?? ?? ?? ?? AF A3 00 1C 8F BF 00 24 8F A2 00 18 8F A3 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_70_0_0 {
	meta:
		name = "__GI_ispunct"
		size = 40
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 00 04 20 40 8C 42 00 00 00 44 10 21 94 42 00 00 03 E0 00 08 30 42 04 00 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "prctl"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 8F A2 00 30 27 BD FF E0 AF A2 00 10 24 02 10 60 00 00 00 0C 27 BD 00 20 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "init_module"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 8F A2 00 30 27 BD FF E0 AF A2 00 10 24 02 10 20 00 00 00 0C 27 BD 00 20 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "_charpad"
		size = 148
		refs = "0000 _gp_disp 0014 __stdio_fwrite"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B3 00 2C 8F 93 ?? ?? AF B4 00 30 AF B2 00 28 AF B1 00 24 AF B0 00 20 AF BC 00 10 AF BF 00 34 00 80 A0 21 00 C0 88 21 A3 A5 00 18 00 C0 80 21 27 B2 00 18 12 00 00 0A 02 40 20 21 24 05 00 01 02 60 C8 21 ?? ?? ?? ?? 02 80 30 21 24 03 00 01 14 43 00 04 8F BF 00 34 10 00 FF F6 26 10 FF FF 8F BF 00 34 02 30 10 23 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_73_1_0 {
	meta:
		name = "_fp_out_narrow"
		size = 212
		refs = "0000 _gp_disp 0044 __GI_strlen 0070 _charpad 009c __stdio_fwrite"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 30 A2 00 80 AF BC 00 10 AF B4 00 28 AF B3 00 24 AF B2 00 20 AF B0 00 18 AF BF 00 2C AF B1 00 1C 00 80 98 21 00 A0 80 21 00 C0 90 21 10 40 00 13 00 E0 A0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 E0 20 21 02 42 90 23 8F BC 00 10 1A 40 00 0D 00 40 88 21 8F 99 ?? ?? 32 05 00 7F 02 60 20 21 27 39 ?? ?? ?? ?? ?? ?? 02 40 30 21 00 40 80 21 16 12 00 0D 8F BC 00 10 10 00 00 04 00 00 10 21 00 C0 88 21 00 00 80 21 00 00 10 21 1A 20 00 05 8F 99 ?? ?? 02 80 20 21 02 20 28 21 ?? ?? ?? ?? 02 60 30 21 00 50 10 21 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_73_2_0 {
	meta:
		name = "_vfprintf_internal"
		size = 1728
		refs = "0000 _gp_disp 0010 _ppfs_init 0070 __GI_strlen 0088 __stdio_fwrite 009c _ppfs_prepargs 011c _ppfs_parsespec 0134 _ppfs_setargs 0198 _store_inttype 025c _load_inttype 0278 _uintmaxtostr 035c $LC0 03a8 _fpmaxtostr 03f0 $LC1 0410 __GI_wcsrtombs 0448 __GI_wcrtomb 0498 __GI_strnlen 055c _charpad 0574 __GI_fputs_unlocked"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FE 88 8F 99 ?? ?? AF B3 01 5C 27 B3 00 20 AF BC 00 18 AF B2 01 58 AF B1 01 54 AF B0 01 50 AF BF 01 74 AF BE 01 70 AF B7 01 6C AF B6 01 68 AF B5 01 64 AF B4 01 60 00 80 88 21 02 60 20 21 00 A0 90 21 ?? ?? ?? ?? 00 C0 80 21 04 41 00 10 8F BC 00 18 8F B2 00 20 82 42 00 00 10 40 01 88 24 10 FF FF 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 8F BC 00 18 02 40 20 21 00 40 28 21 8F 99 ?? ?? ?? ?? ?? ?? 02 20 30 21 10 00 01 7E 8F BF 01 74 8F 99 ?? ?? 02 60 20 21 ?? ?? ?? ?? 02 00 28 21 8F BC 00 18 02 40 20 21 00 00 80 21 82 42 00 00 10 40 00 05 24 03 00 25 10 43 00 03 00 00 00 00 10 00 FF FA 26 52 00 01 12 44 00 0B 02 44 A0 23 1A 80 00 06 00 00 10 21 8F 99 ?? ?? 02 80 28 21 ?? ?? ?? ?? 02 20 30 21 8F BC 00 18 54 54 01 64 24 10 FF FF 02 02 80 21 82 42 00 00 10 40 01 60 24 02 00 25 82 43 00 01 10 62 01 59 26 44 00 01 8F 99 ?? ?? AF A4 00 20 AF A0 01 40 ?? ?? ?? ?? 02 60 20 21 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 8F A3 00 38 8F BC 00 18 93 A4 00 46 18 60 00 04 27 A2 00 70 00 04 18 C0 24 63 FF F8 00 43 10 21 00 00 28 21 00 00 18 21 8F A6 00 3C 00 66 30 2A 10 C0 00 04 24 63 00 01 00 40 28 21 10 00 FF FA 24 42 00 08 8F A2 00 40 14 40 00 0A 2C 43 00 08 8C A4 00 00 8F A5 00 30 8F 99 ?? ?? 00 10 37 C3 30 A5 0F 00 ?? ?? ?? ?? 02 00 38 21 10 00 00 86 8F BC 00 18 10 60 00 75 2C 43 00 10 8F 83 ?? ?? 24 63 ?? ?? 00 43 18 21 80 76 FF FF 24 03 00 0A 16 C3 00 08 24 12 00 57 8F A3 00 30 24 06 00 2C 30 68 00 20 00 C8 90 0B 30 63 00 40 36 46 00 80 00 C3 90 0B 2C 43 00 06 50 60 00 09 00 16 B0 23 24 03 00 03 10 43 00 05 24 03 00 01 14 43 00 04 24 15 00 06 10 00 00 04 8F A6 00 24 24 12 00 37 24 15 00 0B 8F A6 00 24 83 A3 00 37 24 14 00 20 28 C6 00 00 00 66 A0 0B 24 03 00 01 10 43 00 06 24 84 00 09 00 04 20 80 02 64 20 21 8C 84 00 00 10 00 00 02 30 84 0F 00 24 04 04 00 8F 99 ?? ?? 02 C0 30 21 ?? ?? ?? ?? 27 B7 01 37 8F BC 00 18 AF B6 00 10 00 60 38 21 8F 99 ?? ?? AF B2 00 14 02 E0 20 21 ?? ?? ?? ?? 00 40 30 21 00 40 B0 21 8F A2 00 40 2C 43 00 06 14 60 00 10 8F BC 00 18 82 C4 00 00 24 03 00 2D 14 83 00 06 8F A5 00 30 34 A5 00 02 AF A5 00 30 26 D6 00 01 10 00 00 07 24 15 00 02 30 A3 00 02 54 60 00 04 00 00 A8 21 30 A5 00 01 24 03 00 04 00 65 A8 0B 8F A8 00 24 8F A6 00 30 24 05 00 01 29 04 00 00 30 C6 00 10 00 A4 40 0B 02 F6 B8 23 10 C0 00 10 82 C4 00 00 2C 46 00 03 54 C0 00 0D 24 15 00 06 24 06 00 03 50 46 00 0A 24 15 00 09 24 06 00 04 14 46 00 07 02 E8 30 2B 54 C0 00 06 24 05 00 30 38 88 00 30 26 E6 00 01 00 C8 28 0B 00 A0 40 21 24 05 00 30 54 85 00 0E 02 E8 10 2B 24 04 00 0B 2A A5 00 06 00 85 A8 0A 24 04 00 01 10 44 00 05 8F 87 ?? ?? 55 00 00 06 02 E8 10 2B 10 00 00 60 00 00 B8 21 24 17 00 05 10 00 00 5D 24 F6 ?? ?? 14 40 00 5C 01 17 F0 23 10 00 00 5A 00 00 F0 21 10 60 00 10 2C 43 00 12 27 A2 00 24 8C A7 00 04 8C A6 00 00 AF A2 00 10 8F 82 ?? ?? 8F 99 ?? ?? 02 20 20 21 24 42 ?? ?? ?? ?? ?? ?? AF A2 00 14 04 40 00 AA 8F BC 00 18 02 02 80 21 10 00 00 A8 00 00 90 21 10 60 00 2B 2C 43 00 14 24 03 00 11 14 43 00 1A AF A0 01 38 8C A2 00 00 14 40 00 08 AF A2 01 40 8F 87 ?? ?? 24 14 00 20 24 15 00 0B 24 F6 ?? ?? 00 00 F0 21 10 00 00 3A 24 17 00 06 8F A2 00 24 8F 99 ?? ?? 24 12 FF FF 28 46 00 00 27 A4 01 40 02 46 10 0B 00 80 28 21 00 40 30 21 ?? ?? ?? ?? 27 A7 01 38 00 40 B8 21 10 52 00 8B 8F BC 00 18 10 00 00 1F 00 00 B0 21 8F 99 ?? ?? 8C A5 00 00 27 B2 00 B8 02 40 20 21 ?? ?? ?? ?? 27 A6 01 38 00 40 B8 21 24 02 FF FF 12 E2 00 7F 8F BC 00 18 02 77 10 21 A0 40 00 98 10 00 00 11 02 40 B0 21 10 60 00 79 24 03 00 13 54 43 00 10 8C A2 00 00 8C B6 00 00 12 C0 FF D6 8F 99 ?? ?? 8F A2 00 24 24 03 FF FF 28 45 00 00 00 45 18 0A 02 C0 20 21 ?? ?? ?? ?? 00 60 28 21 8F BC 00 18 00 40 B8 21 24 14 00 20 10 00 00 09 24 15 00 0B A3 A0 00 B9 27 B6 00 B8 A3 A2 00 B8 24 14 00 20 24 15 00 0B 00 00 F0 21 10 00 00 02 24 17 00 01 00 00 F0 21 24 04 00 0B 12 A4 00 06 03 D7 10 21 2A A6 00 06 24 04 00 01 24 05 00 02 00 A6 20 0A 00 44 10 21 8F A4 00 28 00 50 80 21 00 44 90 2B 00 82 20 23 00 12 20 0A 24 02 00 30 00 80 90 21 16 82 00 03 02 04 80 21 03 C4 F0 21 00 00 90 21 8F A2 00 30 8F 83 ?? ?? 30 42 00 08 14 40 00 09 24 74 ?? ?? 02 20 20 21 24 05 00 20 02 80 C8 21 ?? ?? ?? ?? 02 40 30 21 14 52 00 40 8F BC 00 18 00 00 90 21 8F 82 ?? ?? 8F 99 ?? ?? 02 20 28 21 24 42 ?? ?? ?? ?? ?? ?? 00 55 20 21 02 20 20 21 24 05 00 30 02 80 C8 21 ?? ?? ?? ?? 03 C0 30 21 14 5E 00 32 8F BC 00 18 8F A2 01 40 14 40 00 15 27 A3 01 38 16 E0 00 0B 8F 99 ?? ?? 02 40 30 21 02 20 20 21 02 80 C8 21 ?? ?? ?? ?? 24 05 00 20 00 52 10 26 00 02 90 2B 8F BC 00 18 10 00 00 24 00 12 90 23 02 C0 20 21 02 E0 28 21 ?? ?? ?? ?? 02 20 30 21 10 57 FF F1 8F BC 00 18 10 00 00 1C 24 12 FF FF AF A0 01 38 27 B5 00 B8 27 BE 01 40 AF A3 01 48 12 E0 FF E9 8F 99 ?? ?? 2E E6 00 81 24 02 00 80 02 E6 10 0B 02 A0 20 21 03 C0 28 21 00 40 30 21 ?? ?? ?? ?? 27 A7 01 38 00 40 B0 21 14 40 00 03 8F BC 00 18 10 00 FF F2 02 F6 B8 23 8F 99 ?? ?? 02 A0 20 21 00 40 28 21 ?? ?? ?? ?? 02 20 30 21 10 56 FF F8 8F BC 00 18 24 12 FF FF 16 40 00 05 8F B2 00 20 10 00 FE 90 02 40 20 21 10 00 FE 8E 26 52 00 02 10 00 00 01 24 10 FF FF 8F BF 01 74 02 00 10 21 8F BE 01 70 8F B7 01 6C 8F B6 01 68 8F B5 01 64 8F B4 01 60 8F B3 01 5C 8F B2 01 58 8F B1 01 54 8F B0 01 50 03 E0 00 08 27 BD 01 78 }
	condition:
		$1
}

rule file_74_0_0 {
	meta:
		name = "alphasort64"
		size = 36
		refs = "0000 _gp_disp 0014 __GI_strcmp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8C 84 00 00 8C A5 00 00 8F 99 ?? ?? 24 84 00 13 ?? ?? ?? ?? 24 A5 00 13 }
	condition:
		$1
}

rule file_856_0_0 {
	meta:
		name = "versionsort64"
		size = 36
		refs = "0000 _gp_disp 0014 __GI_strverscmp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8C 84 00 00 8C A5 00 00 8F 99 ?? ?? 24 84 00 13 ?? ?? ?? ?? 24 A5 00 13 }
	condition:
		$1
}

rule file_76_0_0 {
	meta:
		name = "__GI_getline"
		size = 28
		refs = "0000 _gp_disp 000c __GI_getdelim"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 00 C0 38 21 ?? ?? ?? ?? 24 06 00 0A }
	condition:
		$1
}

rule file_511_0_0 {
	meta:
		name = "setbuffer"
		size = 32
		refs = "0000 _gp_disp 000c __GI_setvbuf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 00 C0 38 21 24 06 00 02 ?? ?? ?? ?? 00 05 30 0B }
	condition:
		$1
}

rule file_77_0_0 {
	meta:
		name = "chroot"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F DD 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "shmctl"
		size = 76
		refs = "0000 _gp_disp 000c __syscall_ipc"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 00 80 18 21 34 A2 01 00 24 04 00 18 AF BF 00 24 AF BC 00 18 AF A6 00 10 AF A0 00 14 00 60 28 21 00 40 30 21 ?? ?? ?? ?? 00 00 38 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "__initbuf"
		size = 96
		refs = "0000 _gp_disp 002c malloc 0044 __GI_abort"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF B0 00 18 8F 90 ?? ?? AF BC 00 10 AF BF 00 1C 8E 02 ?? ?? 14 40 00 0B 8F BF 00 1C 8F 99 ?? ?? ?? ?? ?? ?? 24 04 10 8D AE 02 ?? ?? 14 40 00 04 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_80_1_0 {
	meta:
		name = "__GI_setprotoent"
		size = 208
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 0048 __pthread_mutex_lock 0064 __GI_rewind 0070 __GI_fopen 0068 $LC0 006c $LC1 00a8 _pthread_cleanup_pop_restore"
		altNames = "__GI_setservent"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B1 00 2C 8F 91 ?? ?? 8F 99 ?? ?? 8F 85 ?? ?? AF B0 00 28 27 B0 00 18 AF BC 00 10 26 26 ?? ?? AF BF 00 34 AF B2 00 30 00 80 90 21 ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 24 ?? ?? 8F BC 00 10 8F 91 ?? ?? 8E 24 ?? ?? 14 80 00 0A 8F 99 ?? ?? 8F 84 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 24 84 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? AE 22 ?? ?? 10 00 00 04 8F BC 00 10 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 12 40 00 03 8F 82 ?? ?? 24 03 00 01 AC 43 ?? ?? 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 24 05 00 01 8F BF 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_830_1_0 {
	meta:
		name = "__GI_setnetent"
		size = 208
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 0048 __pthread_mutex_lock 0064 __GI_rewind 0070 __GI_fopen 006c $LC0 009c _net_stayopen 00a8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B1 00 2C 8F 91 ?? ?? 8F 99 ?? ?? 8F 85 ?? ?? AF B0 00 28 27 B0 00 18 AF BC 00 10 26 26 ?? ?? AF BF 00 34 AF B2 00 30 00 80 90 21 ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 24 ?? ?? 8F BC 00 10 8F 91 ?? ?? 8E 24 ?? ?? 14 80 00 0A 8F 99 ?? ?? 8F 84 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 24 84 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? AE 22 ?? ?? 10 00 00 04 8F BC 00 10 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 12 40 00 03 8F 82 ?? ?? 24 03 00 01 AC 43 00 00 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 24 05 00 01 8F BF 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_80_2_0 {
	meta:
		name = "__GI_endprotoent"
		size = 156
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 0040 __pthread_mutex_lock 005c __GI_fclose 0074 _pthread_cleanup_pop_restore"
		altNames = "__GI_endservent"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B1 00 30 8F 91 ?? ?? 8F 99 ?? ?? 8F 85 ?? ?? AF B0 00 2C 27 B0 00 18 AF BC 00 10 26 26 ?? ?? AF BF 00 34 ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 24 ?? ?? 8F BC 00 10 8F 91 ?? ?? 8E 24 ?? ?? 10 80 00 05 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 AE 20 ?? ?? 8F 82 ?? ?? 8F 99 ?? ?? 02 00 20 21 AC 40 ?? ?? ?? ?? ?? ?? 24 05 00 01 8F BF 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_830_2_0 {
	meta:
		name = "__GI_endnetent"
		size = 156
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 0040 __pthread_mutex_lock 005c __GI_fclose 0070 _net_stayopen 0074 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B1 00 30 8F 91 ?? ?? 8F 99 ?? ?? 8F 85 ?? ?? AF B0 00 2C 27 B0 00 18 AF BC 00 10 26 26 ?? ?? AF BF 00 34 ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 24 ?? ?? 8F BC 00 10 8F 91 ?? ?? 8E 24 ?? ?? 10 80 00 05 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 AE 20 ?? ?? 8F 82 ?? ?? 8F 99 ?? ?? 02 00 20 21 AC 40 00 00 ?? ?? ?? ?? 24 05 00 01 8F BF 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_80_3_0 {
	meta:
		name = "__GI_getprotoent_r"
		size = 728
		refs = "0000 _gp_disp 0050 __GI___errno_location 0070 _pthread_cleanup_push_defer 0078 __pthread_mutex_unlock 009c __pthread_mutex_lock 00e0 $LC2 00e8 __GI_fgets 0118 __GI_fopen 0110 $LC0 0114 $LC1 015c __GI_strpbrk 0174 $LC3 01f0 __GI_atoi 0294 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A8 2C C2 00 8C AF BC 00 10 AF B3 00 3C AF B2 00 38 AF BF 00 54 AF BE 00 50 AF B7 00 4C AF B6 00 48 AF B5 00 44 AF B4 00 40 AF B1 00 34 AF B0 00 30 00 C0 90 21 00 E0 98 21 10 40 00 08 AC E0 00 00 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 22 AC 43 00 00 10 00 00 90 24 02 00 22 8F 95 ?? ?? 8F 99 ?? ?? 00 A0 80 21 8F 85 ?? ?? 27 B4 00 18 26 A6 ?? ?? 00 80 88 21 ?? ?? ?? ?? 02 80 20 21 8F BC 00 10 26 52 FF 74 26 A4 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 2E 52 10 01 12 40 00 08 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 24 10 00 22 24 03 00 22 8F BC 00 10 10 00 00 73 AC 43 00 00 8F 92 ?? ?? 26 16 00 8C 8E 42 ?? ?? 10 40 00 0D 02 40 B8 21 8F 9E ?? ?? 27 DE ?? ?? 8F 99 ?? ?? 8E E6 ?? ?? 02 C0 20 21 ?? ?? ?? ?? 24 05 10 00 00 40 A8 21 14 40 00 12 8F BC 00 10 10 00 00 62 24 10 00 02 8F 84 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 24 84 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? AE 42 ?? ?? 14 40 FF EC 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8C 50 00 00 10 00 00 53 8F BC 00 10 80 43 00 00 24 02 00 23 10 62 FF E4 02 A0 20 21 8F 92 ?? ?? 02 40 C8 21 ?? ?? ?? ?? 03 C0 28 21 10 40 FF DE 8F BC 00 10 8F 85 ?? ?? A0 40 00 00 02 A0 20 21 AE 35 00 00 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 8F BC 00 10 10 40 FF D4 8F 95 ?? ?? 24 57 00 01 A0 40 00 00 24 04 00 20 24 03 00 09 82 E2 00 00 14 44 00 03 00 00 00 00 10 00 FF FC 26 F7 00 01 50 43 FF FA 26 F7 00 01 02 E0 20 21 02 40 C8 21 ?? ?? ?? ?? 26 A5 ?? ?? 10 40 00 04 8F BC 00 10 24 56 00 01 10 00 00 02 A0 40 00 00 00 00 B0 21 8F 99 ?? ?? 02 E0 20 21 ?? ?? ?? ?? 02 00 B8 21 8F BC 00 10 AE 22 00 08 12 C0 00 1F AE 30 00 04 24 10 00 20 24 1E 00 09 26 E3 00 88 26 B5 ?? ?? 82 C2 00 00 50 40 00 18 02 E0 80 21 50 50 00 13 26 D6 00 01 14 5E 00 03 02 E3 10 2B 10 00 00 0F 26 D6 00 01 50 40 00 04 AF A3 00 28 AE F6 00 00 26 F7 00 04 AF A3 00 28 02 C0 20 21 02 40 C8 21 ?? ?? ?? ?? 02 A0 28 21 8F BC 00 10 10 40 00 05 8F A3 00 28 24 56 00 01 A0 40 00 00 56 C0 FF E9 82 C2 00 00 02 E0 80 21 AE 00 00 00 AE 71 00 00 00 00 80 21 8F 99 ?? ?? 02 80 20 21 ?? ?? ?? ?? 24 05 00 01 02 00 10 21 8F BF 00 54 8F BE 00 50 8F B7 00 4C 8F B6 00 48 8F B5 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 58 }
	condition:
		$1
}

rule file_80_4_0 {
	meta:
		name = "getprotoent"
		size = 92
		refs = "0000 _gp_disp 0020 __initbuf 003c __GI_getprotoent_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BF 00 24 AF BC 00 10 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 27 A7 00 18 24 06 10 8D 8F 82 ?? ?? 8F 84 ?? ?? 8F 99 ?? ?? 8C 45 ?? ?? ?? ?? ?? ?? 24 84 ?? ?? 8F BF 00 24 8F A2 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_543_4_0 {
	meta:
		name = "getservent"
		size = 92
		refs = "0000 _gp_disp 0020 __initbuf 003c __GI_getservent_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BF 00 24 AF BC 00 10 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 27 A7 00 18 24 06 10 8D 8F 82 ?? ?? 8F 84 ?? ?? 8F 99 ?? ?? 8C 45 ?? ?? ?? ?? ?? ?? 24 84 ?? ?? 8F BF 00 24 8F A2 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_80_5_0 {
	meta:
		name = "__GI_getprotobyname_r"
		size = 376
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 0024 __pthread_mutex_unlock 006c __pthread_mutex_lock 0080 __GI_setprotoent 0090 __GI_getprotoent_r 0094 __GI_strcmp 0114 _pthread_cleanup_pop_restore 0118 __GI_endprotoent"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A8 AF B0 00 30 8F 90 ?? ?? 8F 99 ?? ?? AF B1 00 34 00 A0 88 21 8F 85 ?? ?? AF B2 00 38 27 B2 00 18 AF BF 00 54 AF BC 00 10 AF BE 00 50 AF B7 00 4C AF B6 00 48 AF B5 00 44 AF B4 00 40 AF B3 00 3C 00 C0 B8 21 00 80 98 21 26 06 ?? ?? 02 40 20 21 ?? ?? ?? ?? 00 E0 B0 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 04 ?? ?? 8F BC 00 10 8F 94 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 8E 84 ?? ?? 8F BC 00 10 8F 95 ?? ?? 8F 9E ?? ?? 8F A7 00 68 02 20 20 21 02 E0 28 21 02 A0 C8 21 ?? ?? ?? ?? 02 C0 30 21 00 40 80 21 14 40 00 15 8F BC 00 10 8E 24 00 00 03 C0 C8 21 ?? ?? ?? ?? 02 60 28 21 8F BC 00 10 10 40 00 0E 8F 99 ?? ?? 8E 30 00 04 8E 04 00 00 10 80 FF EE 8F A7 00 68 AF B9 00 28 03 20 F8 09 02 60 28 21 8F BC 00 10 10 40 00 03 8F B9 00 28 10 00 FF F6 26 10 00 04 00 00 80 21 8E 82 ?? ?? 14 40 00 06 8F 99 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 99 ?? ?? 02 40 20 21 ?? ?? ?? ?? 24 05 00 01 8F A3 00 68 8F BF 00 54 8F BE 00 50 8C 62 00 00 8F B7 00 4C 8F B6 00 48 00 02 80 0B 02 00 10 21 8F B5 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 58 }
	condition:
		$1
}

rule file_80_6_0 {
	meta:
		name = "getprotobyname"
		size = 104
		refs = "0000 _gp_disp 0024 __initbuf 0040 __GI_getprotobyname_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF C8 AF BF 00 34 AF BC 00 18 AF A4 00 28 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 18 8F A4 00 28 24 07 10 8D 8F 82 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 8C 46 ?? ?? 27 A2 00 20 AF A2 00 10 ?? ?? ?? ?? 24 A5 ?? ?? 8F BF 00 34 8F A2 00 20 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_80_8_0 {
	meta:
		name = "getprotobynumber"
		size = 104
		refs = "0000 _gp_disp 0024 __initbuf 0040 __GI_getprotobynumber_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF C8 AF BF 00 34 AF BC 00 18 AF A4 00 28 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 18 8F A4 00 28 24 07 10 8D 8F 82 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 8C 46 ?? ?? 27 A2 00 20 AF A2 00 10 ?? ?? ?? ?? 24 A5 ?? ?? 8F BF 00 34 8F A2 00 20 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_80_7_0 {
	meta:
		name = "__GI_getprotobynumber_r"
		size = 308
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 0024 __pthread_mutex_unlock 0070 __pthread_mutex_lock 0084 __GI_setprotoent 0098 __GI_getprotoent_r 00d4 _pthread_cleanup_pop_restore 00d8 __GI_endprotoent"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B0 AF B2 00 30 8F 92 ?? ?? 8F 99 ?? ?? AF B3 00 34 00 A0 98 21 8F 85 ?? ?? AF B1 00 2C 27 B1 00 18 AF BF 00 4C AF BC 00 10 AF BE 00 48 AF B7 00 44 AF B6 00 40 AF B5 00 3C AF B4 00 38 AF B0 00 28 00 80 B0 21 00 C0 A8 21 02 20 20 21 26 46 ?? ?? 00 E0 A0 21 ?? ?? ?? ?? 8F B0 00 60 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 44 ?? ?? 8F BC 00 10 8F 92 ?? ?? 8F 99 ?? ?? 8E 44 ?? ?? ?? ?? ?? ?? 02 40 F0 21 8F BC 00 10 8F 97 ?? ?? 02 60 20 21 02 A0 28 21 02 80 30 21 02 E0 C8 21 ?? ?? ?? ?? 02 00 38 21 00 40 90 21 14 40 00 04 8F BC 00 10 8E 62 00 08 14 56 FF F6 02 60 20 21 8F C2 ?? ?? 14 40 00 06 8F 99 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 24 05 00 01 8E 02 00 00 8F BF 00 4C 8F BE 00 48 00 02 90 0B 02 40 10 21 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "__GI_closedir"
		size = 232
		refs = "0000 _gp_disp 0038 __GI___errno_location 0054 __pthread_mutex_unlock 0058 _pthread_cleanup_push_defer 0074 __pthread_mutex_lock 008c _pthread_cleanup_pop_restore 00a0 free 00c0 __GI_close"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF B2 00 34 AF B0 00 2C AF BC 00 10 AF BF 00 3C AF B3 00 38 AF B1 00 30 8C 82 00 00 24 12 FF FF 14 52 00 08 00 80 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 09 AC 43 00 00 10 00 00 1F 24 02 FF FF 8F 85 ?? ?? 8F 99 ?? ?? 24 93 00 18 27 B1 00 18 02 60 30 21 ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 8F BC 00 10 24 05 00 01 8E 13 00 00 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? AE 12 00 00 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 8E 04 00 0C 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 8F BF 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "__GI___h_errno_location"
		size = 20
		refs = "0000 _gp_disp 0010 __GI_h_errno"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 03 E0 00 08 8F 82 ?? ?? }
	condition:
		$1
}

rule file_102_20_3 {
	meta:
		name = "_ZNSbIwSt11char_traitsIwESaIwEE12_S_empty_repEv"
		size = 20
		refs = "0000 _gp_disp 0010 _ZNSbIwSt11char_traitsIwESaIwEE4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 03 E0 00 08 8F 82 ?? ?? }
	condition:
		$1
}

rule file_102_76_3 {
	meta:
		name = "_ZNSbIwSt11char_traitsIwESaIwEE4_Rep12_S_empty_repEv"
		size = 20
		refs = "0000 _gp_disp 0010 _ZNSbIwSt11char_traitsIwESaIwEE4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 03 E0 00 08 8F 82 ?? ?? }
	condition:
		$1
}

rule file_56_19_3 {
	meta:
		name = "_ZNSs12_S_empty_repEv"
		size = 20
		refs = "0000 _gp_disp 0010 _ZNSs4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 03 E0 00 08 8F 82 ?? ?? }
	condition:
		$1
}

rule file_56_75_3 {
	meta:
		name = "_ZNSs4_Rep12_S_empty_repEv"
		size = 20
		refs = "0000 _gp_disp 0010 _ZNSs4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 03 E0 00 08 8F 82 ?? ?? }
	condition:
		$1
}

rule file_106_16_3 {
	meta:
		name = "_ZNSt6locale5facet13_S_get_c_nameEv"
		size = 20
		refs = "0000 _gp_disp 0010 _ZNSt6locale5facet9_S_c_nameE"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 03 E0 00 08 8F 82 ?? ?? }
	condition:
		$1
}

rule file_291_0_0 {
	meta:
		name = "__GI___errno_location"
		size = 20
		refs = "0000 _gp_disp 0010 __GI_errno"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 03 E0 00 08 8F 82 ?? ?? }
	condition:
		$1
}

rule file_443_0_0 {
	meta:
		name = "__libc_pthread_init"
		size = 20
		refs = "0000 _gp_disp 0010 __libc_multiple_threads"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 03 E0 00 08 8F 82 ?? ?? }
	condition:
		$1
}

rule file_83_0_0 {
	meta:
		name = "swapon"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F F7 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "setpwent"
		size = 144
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 0040 __pthread_mutex_lock 005c __GI_rewind 006c _pthread_cleanup_pop_restore"
		altNames = "setgrent setspent"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B1 00 30 8F 91 ?? ?? 8F 99 ?? ?? 8F 85 ?? ?? AF B0 00 2C 27 B0 00 18 AF BC 00 10 AF BF 00 34 02 00 20 21 ?? ?? ?? ?? 26 26 ?? ?? 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 24 ?? ?? 8F BC 00 10 8F 82 ?? ?? 8C 44 ?? ?? 10 80 00 04 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 24 05 00 01 8F BF 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_84_1_0 {
	meta:
		name = "endpwent"
		size = 148
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 0040 __pthread_mutex_lock 005c __GI_fclose 0070 _pthread_cleanup_pop_restore"
		altNames = "endgrent endspent"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B1 00 30 8F 91 ?? ?? 8F 99 ?? ?? 8F 85 ?? ?? AF B0 00 2C 27 B0 00 18 AF BC 00 10 26 26 ?? ?? AF BF 00 34 ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 24 ?? ?? 8F BC 00 10 8F 91 ?? ?? 8E 24 ?? ?? 10 80 00 05 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 AE 20 ?? ?? 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 24 05 00 01 8F BF 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_84_2_0 {
	meta:
		name = "__GI_getpwent_r"
		size = 312
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 0024 __pthread_mutex_unlock 0064 __pthread_mutex_lock 0090 __GI_fopen 0088 $LC0 008c $LC1 00ac __GI___errno_location 00d0 __parsepwent 00d4 __pgsreader 00f8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A8 AF B0 00 38 8F 90 ?? ?? 8F 99 ?? ?? AF B5 00 4C 00 A0 A8 21 8F 85 ?? ?? AF B1 00 3C 27 B1 00 20 AF BC 00 18 AF BF 00 54 AF B6 00 50 AF B4 00 48 AF B3 00 44 AF B2 00 40 00 80 98 21 00 C0 A0 21 02 20 20 21 26 06 ?? ?? ?? ?? ?? ?? 00 E0 90 21 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 26 04 ?? ?? 8F BC 00 18 AE 40 00 00 8F 90 ?? ?? 8E 02 ?? ?? 14 40 00 12 02 00 B0 21 8F 84 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 24 84 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? AE 02 ?? ?? 14 40 00 07 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8C 42 00 00 10 00 00 0E 8F BC 00 18 24 03 00 01 AC 43 00 34 8E C2 ?? ?? 8F 84 ?? ?? 8F 99 ?? ?? AF A2 00 10 02 60 28 21 02 A0 30 21 ?? ?? ?? ?? 02 80 38 21 14 40 00 02 8F BC 00 18 AE 53 00 00 8F 99 ?? ?? 02 20 20 21 AF A2 00 30 ?? ?? ?? ?? 24 05 00 01 8F BF 00 54 8F A2 00 30 8F B6 00 50 8F B5 00 4C 8F B4 00 48 8F B3 00 44 8F B2 00 40 8F B1 00 3C 8F B0 00 38 03 E0 00 08 27 BD 00 58 }
	condition:
		$1
}

rule file_728_2_0 {
	meta:
		name = "__GI_getgrent_r"
		size = 312
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 0024 __pthread_mutex_unlock 0064 __pthread_mutex_lock 0090 __GI_fopen 0088 $LC0 008c $LC1 00ac __GI___errno_location 00d0 __parsegrent 00d4 __pgsreader 00f8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A8 AF B0 00 38 8F 90 ?? ?? 8F 99 ?? ?? AF B5 00 4C 00 A0 A8 21 8F 85 ?? ?? AF B1 00 3C 27 B1 00 20 AF BC 00 18 AF BF 00 54 AF B6 00 50 AF B4 00 48 AF B3 00 44 AF B2 00 40 00 80 98 21 00 C0 A0 21 02 20 20 21 26 06 ?? ?? ?? ?? ?? ?? 00 E0 90 21 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 26 04 ?? ?? 8F BC 00 18 AE 40 00 00 8F 90 ?? ?? 8E 02 ?? ?? 14 40 00 12 02 00 B0 21 8F 84 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 24 84 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? AE 02 ?? ?? 14 40 00 07 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8C 42 00 00 10 00 00 0E 8F BC 00 18 24 03 00 01 AC 43 00 34 8E C2 ?? ?? 8F 84 ?? ?? 8F 99 ?? ?? AF A2 00 10 02 60 28 21 02 A0 30 21 ?? ?? ?? ?? 02 80 38 21 14 40 00 02 8F BC 00 18 AE 53 00 00 8F 99 ?? ?? 02 20 20 21 AF A2 00 30 ?? ?? ?? ?? 24 05 00 01 8F BF 00 54 8F A2 00 30 8F B6 00 50 8F B5 00 4C 8F B4 00 48 8F B3 00 44 8F B2 00 40 8F B1 00 3C 8F B0 00 38 03 E0 00 08 27 BD 00 58 }
	condition:
		$1
}

rule file_857_2_0 {
	meta:
		name = "__GI_getspent_r"
		size = 312
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 0024 __pthread_mutex_unlock 0064 __pthread_mutex_lock 0090 __GI_fopen 0088 $LC0 008c $LC1 00ac __GI___errno_location 00d0 __parsespent 00d4 __pgsreader 00f8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A8 AF B0 00 38 8F 90 ?? ?? 8F 99 ?? ?? AF B5 00 4C 00 A0 A8 21 8F 85 ?? ?? AF B1 00 3C 27 B1 00 20 AF BC 00 18 AF BF 00 54 AF B6 00 50 AF B4 00 48 AF B3 00 44 AF B2 00 40 00 80 98 21 00 C0 A0 21 02 20 20 21 26 06 ?? ?? ?? ?? ?? ?? 00 E0 90 21 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 26 04 ?? ?? 8F BC 00 18 AE 40 00 00 8F 90 ?? ?? 8E 02 ?? ?? 14 40 00 12 02 00 B0 21 8F 84 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 24 84 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? AE 02 ?? ?? 14 40 00 07 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8C 42 00 00 10 00 00 0E 8F BC 00 18 24 03 00 01 AC 43 00 34 8E C2 ?? ?? 8F 84 ?? ?? 8F 99 ?? ?? AF A2 00 10 02 60 28 21 02 A0 30 21 ?? ?? ?? ?? 02 80 38 21 14 40 00 02 8F BC 00 18 AE 53 00 00 8F 99 ?? ?? 02 20 20 21 AF A2 00 30 ?? ?? ?? ?? 24 05 00 01 8F BF 00 54 8F A2 00 30 8F B6 00 50 8F B5 00 4C 8F B4 00 48 8F B3 00 44 8F B2 00 40 8F B1 00 3C 8F B0 00 38 03 E0 00 08 27 BD 00 58 }
	condition:
		$1
}

rule file_85_0_0 {
	meta:
		name = "wcsrchr"
		size = 32
	strings:
		$1 = { 00 00 10 21 8C 83 00 00 00 65 30 26 00 86 10 0A 14 60 FF FC 24 84 00 04 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_86_0_0 {
	meta:
		name = "personality"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 28 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_87_0_0 {
	meta:
		name = "__GI_opendir"
		size = 356
		refs = "0000 _gp_disp 000c __GI_open 0040 __GI_fstat 0058 __GI___errno_location 0070 __GI_close 0084 __GI_fcntl 00a0 malloc 00dc calloc 00f8 free 0130 __pthread_mutex_init"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF 40 3C 05 00 01 AF BC 00 10 AF B1 00 B4 AF BF 00 BC AF B2 00 B8 AF B0 00 B0 ?? ?? ?? ?? 24 A5 00 80 00 40 88 21 04 40 00 43 8F BC 00 10 8F 99 ?? ?? 00 40 20 21 ?? ?? ?? ?? 27 A5 00 18 04 41 00 0C 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8C 52 00 00 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 10 00 00 32 AE 12 00 00 8F 99 ?? ?? 02 20 20 21 24 05 00 02 ?? ?? ?? ?? 24 06 00 01 04 40 FF EF 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 24 04 00 30 00 40 80 21 10 40 00 15 8F BC 00 10 AC 51 00 00 AC 40 00 10 AC 40 00 08 AC 40 00 04 8F A2 00 6C 2C 43 02 00 54 60 00 01 24 02 02 00 AE 02 00 14 8F 99 ?? ?? 8E 05 00 14 ?? ?? ?? ?? 24 04 00 01 8F BC 00 10 14 40 00 0F AE 02 00 0C 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 0C 10 00 00 07 AC 43 00 00 8F 99 ?? ?? 26 04 00 18 ?? ?? ?? ?? 00 00 28 21 10 00 00 02 02 00 10 21 00 00 10 21 8F BF 00 BC 8F B2 00 B8 8F B1 00 B4 8F B0 00 B0 03 E0 00 08 27 BD 00 C0 }
	condition:
		$1
}

rule file_88_0_0 {
	meta:
		name = "__GI_strsep"
		size = 176
		refs = "0000 _gp_disp 0040 __GI_strpbrk 0064 __GI_strchr"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B1 00 20 AF BC 00 10 AF BF 00 24 AF B0 00 1C 8C 90 00 00 12 00 00 1C 00 80 88 21 80 A2 00 00 50 40 00 17 AE 20 00 00 80 A3 00 01 14 60 00 0A 8F 99 ?? ?? 82 03 00 00 50 62 00 0E 02 00 10 21 50 60 00 0F AE 20 00 00 26 04 00 01 00 40 28 21 10 00 00 02 8F 99 ?? ?? 02 00 20 21 03 20 F8 09 00 00 00 00 54 40 00 04 A0 40 00 00 10 00 00 04 AE 20 00 00 A0 40 00 00 24 42 00 01 AE 22 00 00 10 00 00 02 02 00 10 21 00 00 10 21 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "__sigwait"
		size = 80
		refs = "0000 _gp_disp 000c __GI_sigwaitinfo"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF B0 00 18 AF BC 00 10 AF BF 00 1C 00 A0 80 21 ?? ?? ?? ?? 00 00 28 21 24 03 FF FF 50 43 00 03 24 02 00 01 AE 02 00 00 00 00 10 21 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_90_0_0 {
	meta:
		name = "gethostent"
		size = 92
		refs = "0000 _gp_disp 000c __GI___h_errno_location 0038 __GI_gethostent_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D0 AF BF 00 2C AF BC 00 18 ?? ?? ?? ?? 00 00 00 00 8F BC 00 18 27 A7 00 20 AF A2 00 10 8F 84 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? ?? ?? ?? ?? 24 06 00 7E 8F BF 00 2C 8F A2 00 20 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_91_0_0 {
	meta:
		name = "__GI_getlogin"
		size = 28
		refs = "0000 _gp_disp 0010 __GI_getenv 000c $LC0"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 84 ?? ?? }
	condition:
		$1
}

rule file_55_1_3 {
	meta:
		name = "__cxa_get_globals"
		size = 28
		refs = "0000 _gp_disp 0010 __emutls_get_address"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 84 ?? ?? }
	condition:
		$1
}

rule file_55_0_3 {
	meta:
		name = "__cxa_get_globals_fast"
		size = 28
		refs = "0000 _gp_disp 0010 __emutls_get_address"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 84 ?? ?? }
	condition:
		$1
}

rule file_15_19_2 {
	meta:
		name = "__pthread_once_fork_child"
		size = 120
		refs = "0000 _gp_disp 0010 __pthread_mutex_init 0038 pthread_cond_init"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 84 ?? ?? 8F 99 ?? ?? 27 BD FF E0 24 84 ?? ?? AF BC 00 10 AF BF 00 1C ?? ?? ?? ?? 00 00 28 21 8F BC 00 10 00 00 28 21 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 84 ?? ?? 8F BC 00 10 3C 04 7F FF 34 84 FF FC 8F 82 ?? ?? 8C 43 ?? ?? 00 64 20 2A 50 80 00 03 AC 40 ?? ?? 24 63 00 04 AC 43 ?? ?? 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_15_18_2 {
	meta:
		name = "__pthread_once_fork_parent"
		size = 28
		refs = "0000 _gp_disp 0010 __pthread_mutex_unlock"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 84 ?? ?? }
	condition:
		$1
}

rule file_15_17_2 {
	meta:
		name = "__pthread_once_fork_prepare"
		size = 28
		refs = "0000 _gp_disp 0010 __pthread_mutex_lock"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 84 ?? ?? }
	condition:
		$1
}

rule file_176_1_0 {
	meta:
		name = "gethostid"
		size = 284
		refs = "0000 _gp_disp 0010 __GI_open 000c $LC0 0040 __GI_read 0060 __GI_close 0080 __GI_gethostname 00ac __GI_gethostbyname_r 00e0 __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 84 ?? ?? 8F 99 ?? ?? 27 BD FE 18 24 84 ?? ?? AF BC 00 18 AF B0 01 DC AF BF 01 E4 AF B1 01 E0 ?? ?? ?? ?? 00 00 28 21 00 40 80 21 04 40 00 11 8F BC 00 18 8F 99 ?? ?? 00 40 20 21 27 A5 01 D0 ?? ?? ?? ?? 24 06 00 04 8F BC 00 18 02 00 20 21 10 40 00 05 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 25 8F B0 01 D0 ?? ?? ?? ?? 00 00 00 00 8F BC 00 18 8F 99 ?? ?? 27 B1 01 6C 02 20 20 21 ?? ?? ?? ?? 24 05 00 40 04 40 00 1A 8F BC 00 18 83 A2 01 6C 10 40 00 18 00 00 80 21 27 A2 01 CC 8F 99 ?? ?? AF A2 00 10 27 A2 01 C4 AF A2 00 14 02 20 20 21 27 A5 01 B0 27 A6 00 20 ?? ?? ?? ?? 24 07 01 4C 8F A2 01 CC 10 40 00 0B 8F BC 00 18 8C 43 00 10 8F 99 ?? ?? 8C 46 00 0C 8C 65 00 00 ?? ?? ?? ?? 27 A4 01 C8 8F B0 01 C8 10 00 00 02 00 30 84 02 00 00 80 21 8F BF 01 E4 02 00 10 21 8F B1 01 E0 8F B0 01 DC 03 E0 00 08 27 BD 01 E8 }
	condition:
		$1
}

rule file_241_2_0 {
	meta:
		name = "hdestroy"
		size = 28
		refs = "0000 _gp_disp 0010 __GI_hdestroy_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 84 ?? ?? }
	condition:
		$1
}

rule file_91_1_0 {
	meta:
		name = "getlogin_r"
		size = 124
		refs = "0000 _gp_disp 001c __GI_getenv 0018 $LC0 0040 __GI_strncpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B1 00 20 00 80 88 21 8F 84 ?? ?? 8F 99 ?? ?? AF BC 00 10 AF B0 00 1C AF BF 00 24 24 84 ?? ?? ?? ?? ?? ?? 00 A0 80 21 10 40 00 0A 8F BC 00 10 8F 99 ?? ?? 02 00 30 21 02 20 20 21 00 40 28 21 ?? ?? ?? ?? 02 30 80 21 A2 00 FF FF 10 00 00 02 00 00 10 21 24 02 FF FF 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_91_2_0 {
	meta:
		name = "cuserid"
		size = 96
		refs = "0000 _gp_disp 000c __GI_getlogin 003c $LC1 0048 __GI_strcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BC 00 10 AF A4 00 18 AF BF 00 24 ?? ?? ?? ?? 00 00 00 00 8F A4 00 18 10 80 00 09 8F BC 00 10 14 40 00 03 00 40 28 21 8F 85 ?? ?? 24 A5 ?? ?? 8F BF 00 24 8F 99 ?? ?? ?? ?? ?? ?? 27 BD 00 28 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "__malloc_largebin_index"
		size = 128
	strings:
		$1 = { 00 04 1A 02 3C 05 00 01 00 65 28 2B 10 A0 00 1A 24 02 00 5F 24 66 FF 00 00 06 34 02 30 C6 00 08 00 C3 38 04 24 E5 F0 00 00 05 2C 02 30 A5 00 04 00 A7 38 04 24 E2 C0 00 00 02 14 02 30 42 00 02 00 47 38 04 00 07 1B C2 00 07 43 82 00 03 18 27 00 C5 28 21 00 A2 10 21 00 68 18 24 00 62 18 23 00 03 10 80 24 63 00 13 00 64 20 06 24 42 00 54 30 84 00 03 00 44 10 21 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_93_1_0 {
	meta:
		name = "malloc"
		size = 2540
		refs = "0000 _gp_disp 0044 _pthread_cleanup_push_defer 0048 __pthread_mutex_unlock 004c __malloc_lock 0068 __pthread_mutex_lock 0080 __GI___errno_location 00b4 __malloc_state 00d0 __malloc_consolidate 0158 __malloc_largebin_index 034c __GI_abort 0548 malloc 059c __GI_mmap 06b8 __GI_sbrk 0754 _pthread_cleanup_pop_restore 0920 free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 98 AF BC 00 18 AF B0 00 40 AF BF 00 64 AF BE 00 60 AF B7 00 5C AF B6 00 58 AF B5 00 54 AF B4 00 50 AF B3 00 4C AF B2 00 48 AF B1 00 44 10 80 00 10 00 80 80 21 8F 99 ?? ?? 8F 85 ?? ?? 8F 86 ?? ?? 27 A3 00 20 00 60 20 21 ?? ?? ?? ?? AF A3 00 34 8F BC 00 18 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 2E 02 FF E0 14 40 00 08 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 0C AC 43 00 00 10 00 02 49 00 00 10 21 26 10 00 0B 2E 02 00 10 14 40 00 03 24 11 00 10 24 11 FF F8 02 11 88 24 8F 82 ?? ?? 8C 49 00 00 31 23 00 01 14 60 00 08 00 40 80 21 55 20 01 06 8E 02 00 2C 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 10 00 01 00 8F BC 00 18 01 31 18 2B 14 60 00 0A 2E 32 01 00 00 11 18 42 24 63 FF F8 00 43 18 21 8C 62 00 04 10 40 00 04 00 00 00 00 8C 44 00 08 10 00 01 51 AC 64 00 04 12 40 00 0F 8F 99 ?? ?? 02 11 20 21 8C 83 00 38 24 84 00 2C 10 64 00 16 00 11 98 C2 00 71 88 21 8E 25 00 04 8C 62 00 0C 24 70 00 08 34 A5 00 01 AE 25 00 04 AC 82 00 0C 10 00 01 81 AC 44 00 08 27 39 ?? ?? ?? ?? ?? ?? 02 20 20 21 31 29 00 02 8F BC 00 18 11 20 00 06 00 40 98 21 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 18 8F 8C ?? ?? 8F 98 ?? ?? 26 0B 00 34 01 60 68 21 24 0E FF FC 26 2F 00 10 24 14 00 01 8E 09 00 40 8F 83 ?? ?? 11 2B 00 52 01 A0 38 21 8D 2A 00 04 8D 22 00 0C 12 40 00 17 01 CA 50 24 54 4B 00 16 AE 02 00 40 8D 84 00 30 55 24 00 13 AE 02 00 40 01 EA 20 2B 50 80 00 10 AE 02 00 40 01 31 10 21 01 51 50 23 AC 62 00 3C AC 62 00 40 AC 62 00 30 36 31 00 01 35 43 00 01 AC 4B 00 08 AC 4B 00 0C AD 31 00 04 AC 43 00 04 00 4A 10 21 10 00 00 08 AC 4A 00 00 AE 02 00 40 15 51 00 07 AC 4D 00 08 01 2A 50 21 8D 42 00 04 34 42 00 01 AD 42 00 04 10 00 01 47 25 30 00 08 2D 42 01 00 10 40 00 07 27 02 ?? ?? 00 0A 30 C2 00 06 20 C0 01 84 20 21 24 84 00 2C 10 00 00 19 8C 83 00 08 00 40 C8 21 ?? ?? ?? ?? 01 40 20 21 00 02 18 C0 01 83 18 21 24 63 00 2C 8C 65 00 08 8F BC 00 18 10 A3 00 0E 00 40 30 21 8C 64 00 0C 8C 82 00 04 01 42 10 2B 14 40 00 0A 35 4A 00 01 8C A2 00 04 01 42 10 2B 50 40 00 03 8C A4 00 0C 10 00 FF FB 8C A5 00 08 10 00 00 02 00 A0 18 21 00 60 20 21 00 06 11 43 24 42 00 CC 00 02 10 80 02 02 10 21 8C 45 00 04 00 D4 30 04 00 C5 30 25 AC 46 00 04 AD 24 00 0C AD 23 00 08 AC 69 00 0C 10 00 FF AC AC 89 00 08 56 40 00 2E 26 73 00 01 00 13 20 C0 00 64 18 21 24 64 00 2C 8C 83 00 0C 24 05 FF FC 50 64 00 27 26 73 00 01 8C 62 00 04 00 A2 10 24 00 51 30 2B 54 C0 FF FA 8C 63 00 0C 8C 66 00 08 00 51 20 23 8C C8 00 0C 15 03 00 04 8C 65 00 0C 8C A8 00 08 51 03 00 04 AC C5 00 0C 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC A6 00 08 2C 86 00 10 10 C0 00 06 24 65 00 08 00 62 18 21 8C 62 00 04 34 42 00 01 10 00 00 0C AC 62 00 04 00 71 10 21 36 31 00 01 AE 02 00 3C AE 02 00 40 AC 47 00 08 AC 47 00 0C AC 71 00 04 34 83 00 01 AC 43 00 04 00 44 10 21 AC 44 00 00 10 00 00 EA 00 A0 80 21 00 13 31 42 24 C2 00 CC 00 02 10 80 02 02 10 21 00 13 18 C0 8F 88 ?? ?? 02 03 18 21 8C 45 00 04 24 02 00 01 24 63 00 2C 02 62 10 04 00 A2 20 2B 54 80 00 04 24 C6 00 01 14 40 00 0F 00 45 20 24 24 C6 00 01 2C C2 00 03 10 40 00 39 24 C2 00 CC 00 02 10 80 02 02 10 21 8C 45 00 04 50 A0 FF F9 24 C6 00 01 00 06 1A 00 01 03 18 21 24 63 00 2C 24 02 00 01 00 45 20 24 54 80 00 04 8C 64 00 0C 24 63 00 08 10 00 FF FB 00 02 10 40 54 83 00 0A 8C 82 00 04 00 02 20 27 00 A4 28 24 24 C4 00 CC 00 04 20 80 02 04 20 21 AC 85 00 04 24 63 00 08 10 00 FF DE 00 02 10 40 8C 86 00 0C 24 05 FF FC 00 A2 10 24 00 51 28 23 AC 66 00 0C AC C3 00 08 2C A6 00 10 10 C0 00 06 24 83 00 08 00 82 20 21 8C 82 00 04 34 42 00 01 10 00 00 0F AC 82 00 04 00 91 10 21 AE 02 00 3C AE 02 00 40 AC 47 00 08 12 40 00 03 AC 47 00 0C 8F 86 ?? ?? AC C2 00 30 36 31 00 01 AC 91 00 04 34 A4 00 01 AC 44 00 04 00 45 10 21 AC 45 00 00 10 00 00 9E 00 60 80 21 8E 02 00 2C 24 05 FF FC 8C 43 00 04 00 A3 28 24 26 23 00 10 AF A3 00 30 00 A3 18 2B 14 60 00 09 8F 84 ?? ?? 00 51 18 21 00 B1 28 23 AC 83 00 2C 34 A5 00 01 36 24 00 01 AC 44 00 04 10 00 00 4D AC 65 00 04 8C 82 00 00 8C 92 03 5C 30 42 00 02 10 40 00 0B 26 55 FF FF 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 26 24 FF F9 00 40 80 21 10 00 00 7E 8F BC 00 18 8C 82 03 4C 02 22 10 2B 14 40 00 3C 00 15 B8 27 8C 83 03 50 8C 82 03 54 00 62 10 2A 50 40 00 38 8E 14 00 2C 26 52 00 0A 02 51 90 21 02 57 90 24 02 32 10 2B 50 40 00 32 8E 14 00 2C 8F 99 ?? ?? AF A0 00 10 AF A0 00 14 00 00 20 21 02 40 28 21 24 06 00 03 ?? ?? ?? ?? 24 07 08 02 24 03 FF FF 10 43 00 26 8F BC 00 18 30 43 00 07 50 60 00 08 AC 40 00 00 24 04 00 08 00 83 18 23 00 43 10 21 AC 43 00 00 02 43 18 23 10 00 00 02 34 63 00 02 36 43 00 02 AC 43 00 04 8E 03 03 50 8E 04 03 58 24 63 00 01 00 83 20 2A 10 80 00 03 AE 03 03 50 8F 84 ?? ?? AC 83 03 58 8E 03 03 64 02 43 90 21 8E 03 03 70 00 72 18 2B 10 60 00 03 AE 12 03 64 8F 83 ?? ?? AC 72 03 70 8E 03 03 68 02 43 90 21 8E 03 03 74 00 72 18 2B 10 60 00 02 8F 83 ?? ?? AC 72 03 74 10 00 00 3F 24 50 00 08 8E 14 00 2C 24 03 FF FC 8E 12 03 48 8E 82 00 04 26 52 00 10 00 62 B0 24 8E 02 03 60 02 51 90 21 30 42 00 01 70 56 18 02 02 43 90 23 02 55 90 21 02 57 90 24 1E 40 00 09 02 96 F0 21 8E 02 03 60 30 42 00 01 10 40 00 0F 3C 02 00 10 02 D5 10 21 00 52 90 21 10 00 00 0A 02 57 90 24 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 00 40 98 21 24 02 FF FF 16 62 00 27 8F BC 00 18 10 00 FF F1 8E 02 03 60 3C 02 00 10 02 42 20 2B 00 44 90 0B 02 32 10 2B 10 40 00 14 8F 99 ?? ?? 8F 99 ?? ?? AF A0 00 10 AF A0 00 14 00 00 20 21 02 40 28 21 24 06 00 03 ?? ?? ?? ?? 24 07 08 02 00 40 98 21 24 02 FF FF 12 62 00 07 8F BC 00 18 8E 05 03 60 24 04 FF FE 02 72 10 21 00 A4 20 24 10 00 00 0D AE 04 03 60 8F 99 ?? ?? ?? ?? ?? ?? 00 00 80 21 24 03 00 0C 8F BC 00 18 AC 43 00 00 8F 99 ?? ?? 27 A4 00 20 ?? ?? ?? ?? 24 05 00 01 10 00 00 95 02 00 10 21 8E 04 03 68 02 44 20 21 16 7E 00 08 AE 04 03 68 24 05 FF FF 54 45 00 06 8E 05 03 60 02 56 18 21 34 63 00 01 10 00 00 6A AE 83 00 04 8E 05 03 60 30 A6 00 01 50 C0 00 0B 8E 05 03 60 52 C0 00 09 8E 05 03 60 02 7E 30 2B 50 C0 00 06 8E 05 03 60 24 06 FF FE 00 A6 28 24 8F 86 ?? ?? AC C5 03 60 8E 05 03 60 30 A5 00 01 10 A0 00 2A 8F 86 ?? ?? 12 C0 00 04 32 62 00 07 02 7E 40 23 01 04 20 21 AC C4 03 68 50 40 00 05 02 60 F0 21 24 04 00 08 00 82 10 23 10 00 00 02 02 62 F0 21 00 00 10 21 00 56 10 21 00 52 20 21 02 64 20 21 00 95 A8 21 02 B7 B8 24 8F 95 ?? ?? 00 44 10 23 00 57 B8 21 02 A0 C8 21 ?? ?? ?? ?? 02 E0 20 21 24 04 FF FF 14 44 00 06 8F BC 00 18 02 A0 C8 21 ?? ?? ?? ?? 00 00 20 21 10 00 00 09 8F BC 00 18 00 53 20 2B 10 80 00 18 24 04 FF FF 8E 06 03 60 24 04 FF FE 02 72 10 21 00 C4 20 24 AE 04 03 60 10 00 00 10 00 00 B8 21 24 04 FF FF 02 60 F0 21 14 44 00 0F 00 00 B8 21 8F 99 ?? ?? 00 00 20 21 ?? ?? ?? ?? AF A6 00 38 8F A6 00 38 00 53 20 23 00 92 90 23 8C C4 03 68 8F BC 00 18 02 44 90 21 AC D2 03 68 24 04 FF FF 50 44 00 1F 8E 02 03 68 00 5E 10 23 00 57 10 21 34 42 00 01 AE 1E 00 2C AF C2 00 04 8E 02 03 68 8F 93 ?? ?? 02 E2 B8 21 12 C0 00 14 AE 17 03 68 24 02 FF F8 26 C3 FF F4 00 62 18 24 34 62 00 01 AE 82 00 04 24 04 00 05 02 83 10 21 2C 63 00 10 AC 44 00 04 14 60 00 09 AC 44 00 08 8E 72 03 44 8F 99 ?? ?? 24 02 FF FF AE 62 03 44 ?? ?? ?? ?? 26 84 00 08 8F BC 00 18 AE 72 03 44 8E 02 03 68 8E 03 03 6C 00 62 18 2B 50 60 00 04 8E 03 03 64 8F 83 ?? ?? AC 62 03 6C 8E 03 03 64 00 43 10 21 8E 03 03 74 00 62 18 2B 50 60 00 04 8E 10 00 2C 8F 83 ?? ?? AC 62 03 74 8E 10 00 2C 8F B9 00 30 24 03 FF FC 8E 02 00 04 00 62 18 24 00 79 F0 2B 17 C0 FF 6A 8F 84 ?? ?? 02 11 10 21 00 71 18 23 AC 82 00 2C 34 63 00 01 36 24 00 01 AE 04 00 04 AC 43 00 04 10 00 FF 67 26 10 00 08 8F BF 00 64 8F BE 00 60 8F B7 00 5C 8F B6 00 58 8F B5 00 54 8F B4 00 50 8F B3 00 4C 8F B2 00 48 8F B1 00 44 8F B0 00 40 03 E0 00 08 27 BD 00 68 }
	condition:
		$1
}

rule file_94_0_0 {
	meta:
		name = "ulimit"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F DA 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_95_0_0 {
	meta:
		name = "__GI_strtof"
		size = 140
		refs = "0000 _gp_disp 000c __strtofpmax 0034 __truncdfsf2 0050 __extendsfdf2 0068 __fp_range_check"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BF 00 24 AF B0 00 20 AF BC 00 10 ?? ?? ?? ?? 00 00 30 21 8F BC 00 10 00 40 30 21 00 C0 20 21 8F 99 ?? ?? AF A6 00 18 00 60 28 21 ?? ?? ?? ?? AF A3 00 1C 8F BC 00 10 00 40 20 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 80 21 8F BC 00 10 8F A6 00 18 8F A7 00 1C 8F 99 ?? ?? 00 40 20 21 ?? ?? ?? ?? 00 60 28 21 8F BF 00 24 02 00 10 21 8F B0 00 20 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_607_0_0 {
	meta:
		name = "__GI_wcstof"
		size = 140
		refs = "0000 _gp_disp 000c __wcstofpmax 0034 __truncdfsf2 0050 __extendsfdf2 0068 __fp_range_check"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BF 00 24 AF B0 00 20 AF BC 00 10 ?? ?? ?? ?? 00 00 30 21 8F BC 00 10 00 40 30 21 00 C0 20 21 8F 99 ?? ?? AF A6 00 18 00 60 28 21 ?? ?? ?? ?? AF A3 00 1C 8F BC 00 10 00 40 20 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 80 21 8F BC 00 10 8F A6 00 18 8F A7 00 1C 8F 99 ?? ?? 00 40 20 21 ?? ?? ?? ?? 00 60 28 21 8F BF 00 24 02 00 10 21 8F B0 00 20 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_96_0_0 {
	meta:
		name = "__stdio_trans2r_o"
		size = 208
		refs = "0000 _gp_disp 0038 __GI___errno_location 0088 __stdio_wcommit"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF B0 00 18 AF BC 00 10 AF BF 00 1C 94 82 00 00 00 A2 18 24 14 60 00 0B 00 80 80 21 30 43 08 80 50 60 00 07 00 A2 10 25 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 09 10 00 00 08 AC 43 00 00 A4 82 00 00 96 02 00 00 30 43 00 10 50 60 00 08 30 42 00 40 10 00 FF F5 8F 99 ?? ?? 96 02 00 00 34 42 00 08 A6 02 00 00 10 00 00 11 24 02 FF FF 50 40 00 0C 96 02 00 00 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 54 40 FF F6 96 02 00 00 8E 02 00 08 AE 02 00 1C 96 02 00 00 30 42 FF BF A6 02 00 00 96 02 00 00 34 42 00 01 A6 02 00 00 00 00 10 21 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "tmpfile"
		size = 192
		refs = "0000 _gp_disp 0014 ___path_search 000c $LC0 0050 __gen_tempname 006c __GI_remove 0084 __GI_fdopen 0080 $LC1 009c __GI_close"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 87 ?? ?? 27 BD EF D8 8F 99 ?? ?? AF B0 10 1C 27 B0 00 18 AF BC 00 10 AF BF 10 24 AF B1 10 20 02 00 20 21 24 05 0F FF 00 00 30 21 ?? ?? ?? ?? 24 E7 ?? ?? 10 40 00 03 8F BC 00 10 10 00 00 17 00 00 80 21 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 00 00 28 21 00 40 88 21 04 40 FF F8 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 02 20 20 21 8F 85 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? 00 40 80 21 14 40 00 04 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BF 10 24 02 00 10 21 8F B1 10 20 8F B0 10 1C 03 E0 00 08 27 BD 10 28 }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "_stdio_fopen"
		size = 840
		refs = "0000 _gp_disp 0054 __GI___errno_location 00a8 malloc 00b8 __GI_open 00f0 free 0120 __stdio_init_mutex 0164 __GI_fcntl 01fc __GI_isatty 027c _stdio_user_locking 0298 __pthread_mutex_unlock 029c _stdio_openlist_del_lock 02a0 _pthread_cleanup_push_defer 02b4 __pthread_mutex_lock 02c8 _stdio_openlist_add_lock 02fc _stdio_openlist 0300 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B0 AF B3 00 48 AF B2 00 44 AF B0 00 3C AF BC 00 10 AF BF 00 4C AF B1 00 40 80 A2 00 00 24 03 00 72 00 80 90 21 00 C0 80 21 10 43 00 0F 00 E0 98 21 24 03 00 77 10 43 00 2F 24 03 00 61 10 43 00 0B 24 11 01 09 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 8F BC 00 10 16 00 00 1D AC 43 00 00 10 00 00 AD 00 00 80 21 00 00 88 21 80 A2 00 01 38 42 00 62 2C 42 00 01 00 A2 28 21 80 A3 00 01 24 02 00 2B 14 62 00 03 00 00 00 00 36 31 00 01 26 31 00 01 12 00 00 19 8F 99 ?? ?? 06 61 00 24 32 22 20 03 36 22 20 00 8F 99 ?? ?? 00 13 98 27 00 53 88 0B 02 40 20 21 02 20 28 21 ?? ?? ?? ?? 24 06 01 B6 8F BC 00 10 04 41 00 2E AE 02 00 04 96 02 00 00 30 42 20 00 50 40 00 8F 00 00 80 21 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 10 00 00 8A 00 00 80 21 10 00 FF DD 24 11 03 01 ?? ?? ?? ?? 24 04 00 50 00 40 80 21 10 40 FF F8 8F BC 00 10 8F 99 ?? ?? 24 02 20 00 A6 02 00 00 AE 00 00 08 ?? ?? ?? ?? 26 04 00 38 10 00 FF DC 8F BC 00 10 24 42 00 01 26 43 00 01 00 43 18 24 14 62 FF C1 AE 13 00 04 00 12 10 27 30 42 00 08 00 51 10 24 14 40 00 04 8F 99 ?? ?? 32 52 20 00 10 00 00 09 02 32 88 25 02 60 20 21 24 05 00 04 ?? ?? ?? ?? 24 06 00 08 14 40 FF B3 8F BC 00 10 10 00 FF F7 32 52 20 00 32 22 00 08 96 04 00 00 32 25 20 00 32 31 00 03 26 31 00 01 3A 31 00 03 30 84 20 00 24 03 04 00 00 11 89 00 00 02 18 0A 00 91 20 25 34 02 80 00 00 05 10 0A 00 64 18 25 00 43 10 25 8E 12 00 04 A6 02 00 00 3C 02 7F FF 34 42 FF FF 12 42 00 0F 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 02 40 20 21 00 40 88 21 8F 99 ?? ?? ?? ?? ?? ?? 8C 53 00 00 10 40 00 04 8F BC 00 10 96 02 00 00 34 42 01 00 A6 02 00 00 AE 33 00 00 8E 02 00 08 54 40 00 10 A2 00 00 02 8F 99 ?? ?? ?? ?? ?? ?? 24 04 10 00 8F BC 00 10 10 40 00 07 AE 02 00 08 24 42 10 00 AE 02 00 0C 96 02 00 00 34 42 40 00 10 00 00 02 A6 02 00 00 AE 00 00 0C 8E 02 00 08 A2 00 00 02 AE 00 00 2C AE 02 00 18 AE 02 00 1C AE 02 00 10 AE 02 00 14 8F 82 ?? ?? 8C 42 00 00 AE 02 00 34 96 02 00 00 30 42 20 00 10 40 00 26 8F BF 00 4C 8F 85 ?? ?? 8F 86 ?? ?? 8F 99 ?? ?? 27 B1 00 28 ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8F 99 ?? ?? 8F 84 ?? ?? ?? ?? ?? ?? 27 B2 00 18 8F BC 00 10 8F 86 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 02 40 20 21 24 05 00 01 8F 82 ?? ?? 8F 99 ?? ?? 8C 43 00 00 AC 50 00 00 ?? ?? ?? ?? AE 03 00 20 8F BC 00 10 02 20 20 21 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 01 8F BF 00 4C 02 00 10 21 8F B3 00 48 8F B2 00 44 8F B1 00 40 8F B0 00 3C 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_99_0_0 {
	meta:
		name = "__GI_wcscasecmp"
		size = 180
		refs = "0000 _gp_disp 0014 __GI_towlower"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B3 00 28 8F 93 ?? ?? AF B2 00 24 AF B0 00 1C AF BC 00 10 AF BF 00 34 AF B5 00 30 AF B4 00 2C AF B1 00 20 00 80 80 21 00 A0 90 21 8E 11 00 00 8E 55 00 00 16 35 00 05 02 60 C8 21 12 20 00 0F 26 10 00 04 10 00 FF F9 26 52 00 04 ?? ?? ?? ?? 02 20 20 21 02 A0 20 21 02 60 C8 21 ?? ?? ?? ?? 00 40 A0 21 12 82 FF F5 02 82 A0 2B 24 03 00 01 24 02 FF FF 10 00 00 02 00 74 10 0A 00 00 10 21 8F BF 00 34 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "getnetbyname"
		size = 248
		refs = "0000 _gp_disp 0014 _net_stayopen 0038 __GI_setnetent 0050 __GI_getnetent 0054 __GI_strcmp 00c0 __GI_endnetent"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B0 00 18 8F 90 ?? ?? AF BC 00 10 AF B5 00 2C AF B4 00 28 AF B3 00 24 AF B2 00 20 AF BF 00 34 AF B6 00 30 AF B1 00 1C 8F 99 ?? ?? 00 80 90 21 8E 04 00 00 ?? ?? ?? ?? 02 00 98 21 8F BC 00 10 8F 94 ?? ?? 8F 95 ?? ?? 02 80 C8 21 ?? ?? ?? ?? 00 00 00 00 00 40 80 21 10 40 00 12 8F BC 00 10 8E 04 00 00 02 A0 C8 21 ?? ?? ?? ?? 02 40 28 21 8F BC 00 10 10 40 00 0B 8F 96 ?? ?? 8E 11 00 04 8E 24 00 00 10 80 FF F0 02 C0 C8 21 ?? ?? ?? ?? 02 40 28 21 10 40 00 03 8F BC 00 10 10 00 FF F8 26 31 00 04 8E 62 00 00 14 40 00 05 8F BF 00 34 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BF 00 34 02 00 10 21 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "__GI_vfprintf"
		size = 244
		refs = "0000 _gp_disp 0040 _pthread_cleanup_push_defer 0044 __pthread_mutex_unlock 005c __pthread_mutex_lock 007c __stdio_trans2w_o 0080 _vfprintf_internal 00bc _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B4 00 40 AF B3 00 3C AF B0 00 30 AF BC 00 10 AF BF 00 44 AF B2 00 38 AF B1 00 34 8C 91 00 34 00 80 80 21 00 A0 98 21 16 20 00 0C 00 C0 A0 21 8F 99 ?? ?? 8F 85 ?? ?? 24 92 00 38 02 40 30 21 ?? ?? ?? ?? 27 A4 00 18 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 96 03 00 00 24 02 00 C0 30 63 00 C0 14 62 00 08 8F 99 ?? ?? 8F 99 ?? ?? 02 00 20 21 02 60 28 21 ?? ?? ?? ?? 02 80 30 21 10 00 00 07 8F BC 00 10 02 00 20 21 ?? ?? ?? ?? 24 05 00 80 10 40 FF F5 8F BC 00 10 24 02 FF FF 16 20 00 08 8F BF 00 44 8F 99 ?? ?? AF A2 00 28 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F A2 00 28 8F BF 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "tempnam"
		size = 124
		refs = "0000 _gp_disp 0010 ___path_search 0048 __gen_tempname 0060 __GI_strdup"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD EF E0 8F 99 ?? ?? AF B0 10 18 27 B0 00 18 AF BC 00 10 00 80 30 21 00 A0 38 21 AF BF 10 1C 02 00 20 21 ?? ?? ?? ?? 24 05 0F FF 10 40 00 03 8F BC 00 10 10 00 00 0A 00 00 10 21 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 24 05 00 03 14 40 FF F9 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F BF 10 1C 8F B0 10 18 03 E0 00 08 27 BD 10 20 }
	condition:
		$1
}

rule file_103_0_0 {
	meta:
		name = "__freadable"
		size = 16
	strings:
		$1 = { 94 82 00 00 38 42 00 10 03 E0 00 08 7C 42 01 00 }
	condition:
		$1
}

rule file_104_0_0 {
	meta:
		name = "sigandset"
		size = 60
	strings:
		$1 = { 24 02 00 04 24 07 FF FF 24 42 FF FF 10 47 00 09 00 02 18 80 00 83 40 21 00 C3 48 21 00 A3 18 21 8D 29 00 00 8C 63 00 00 01 23 18 24 10 00 FF F6 AD 03 00 00 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_105_0_0 {
	meta:
		name = "__GI_isspace"
		size = 40
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 00 04 20 40 8C 42 00 00 00 44 10 21 94 42 00 00 03 E0 00 08 30 42 00 20 }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "__GI_adjtimex"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 1C 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_107_0_0 {
	meta:
		name = "__encode_question"
		size = 148
		refs = "0000 _gp_disp 0028 __encode_dotted"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B2 00 20 AF B1 00 1C AF B0 00 18 AF BC 00 10 AF BF 00 24 00 80 80 21 8F 99 ?? ?? 8C 84 00 00 00 A0 90 21 ?? ?? ?? ?? 00 C0 88 21 04 40 00 0F 02 22 88 23 2A 31 00 04 16 20 00 0B 02 42 28 21 92 03 00 06 24 42 00 04 A0 A3 00 00 8E 03 00 04 A0 A3 00 01 92 03 00 0A A0 A3 00 02 8E 03 00 08 10 00 00 02 A0 A3 00 03 24 02 FF FF 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "msgsnd"
		size = 64
		refs = "0000 _gp_disp 000c __syscall_ipc"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 00 80 10 21 24 04 00 0B AF BF 00 24 AF BC 00 18 AF A5 00 10 AF A0 00 14 ?? ?? ?? ?? 00 40 28 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_110_0_0 {
	meta:
		name = "atoll"
		size = 28
		refs = "0000 _gp_disp 000c __GI_strtoll"
		altNames = "__GI_atol"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 00 00 28 21 ?? ?? ?? ?? 24 06 00 0A }
	condition:
		$1
}

rule file_668_0_0 {
	meta:
		name = "setlinebuf"
		size = 32
		refs = "0000 _gp_disp 000c __GI_setvbuf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 00 00 28 21 24 06 00 01 ?? ?? ?? ?? 00 00 38 21 }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "__GI_gethostbyaddr"
		size = 128
		refs = "0000 _gp_disp 000c __GI___h_errno_location 0050 __GI_gethostbyaddr_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF B8 AF BF 00 44 AF BC 00 20 AF A4 00 30 AF A5 00 34 AF A6 00 38 ?? ?? ?? ?? 00 00 00 00 8F BC 00 20 8F A4 00 30 8F A5 00 34 8F 83 ?? ?? 8F 87 ?? ?? 8F A6 00 38 24 63 ?? ?? AF A3 00 10 8F 99 ?? ?? 24 03 01 CC AF A3 00 14 27 A3 00 28 AF A3 00 18 AF A2 00 1C ?? ?? ?? ?? 24 E7 ?? ?? 8F BF 00 44 8F A2 00 28 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "__GI_fcntl"
		size = 132
		refs = "0000 _gp_disp 0038 __GI_fcntl64 005c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 27 A2 00 30 AF A2 00 18 24 A2 FF DF AF BC 00 10 2C 42 00 03 AF BF 00 24 AF B0 00 20 AF A6 00 30 10 40 00 06 AF A7 00 34 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 0A 00 40 80 21 24 02 0F D7 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 24 02 00 10 21 8F B0 00 20 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_113_0_0 {
	meta:
		name = "iopl"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 0E 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_114_0_0 {
	meta:
		name = "wscanf"
		size = 80
		refs = "0000 _gp_disp 000c stdin 002c __GI_vfwscanf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 27 BD FF D8 AF BF 00 24 AF BC 00 10 AF A5 00 2C AF A6 00 30 AF A7 00 34 00 80 28 21 8F 99 ?? ?? 8C 44 00 00 27 A6 00 2C AF A6 00 18 ?? ?? ?? ?? 00 00 00 00 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_247_0_0 {
	meta:
		name = "__GI_printf"
		size = 80
		refs = "0000 _gp_disp 000c stdout 002c __GI_vfprintf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 27 BD FF D8 AF BF 00 24 AF BC 00 10 AF A5 00 2C AF A6 00 30 AF A7 00 34 00 80 28 21 8F 99 ?? ?? 8C 44 00 00 27 A6 00 2C AF A6 00 18 ?? ?? ?? ?? 00 00 00 00 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_240_0_0 {
	meta:
		name = "scanf"
		size = 80
		refs = "0000 _gp_disp 000c stdin 002c __GI_vfscanf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 27 BD FF D8 AF BF 00 24 AF BC 00 10 AF A5 00 2C AF A6 00 30 AF A7 00 34 00 80 28 21 8F 99 ?? ?? 8C 44 00 00 27 A6 00 2C AF A6 00 18 ?? ?? ?? ?? 00 00 00 00 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_503_0_0 {
	meta:
		name = "wprintf"
		size = 80
		refs = "0000 _gp_disp 000c stdout 002c __GI_vfwprintf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 27 BD FF D8 AF BF 00 24 AF BC 00 10 AF A5 00 2C AF A6 00 30 AF A7 00 34 00 80 28 21 8F 99 ?? ?? 8C 44 00 00 27 A6 00 2C AF A6 00 18 ?? ?? ?? ?? 00 00 00 00 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_115_0_0 {
	meta:
		name = "__stdio_wcommit"
		size = 88
		refs = "0000 _gp_disp 0030 __stdio_WRITE"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8C 85 00 08 8C 86 00 10 27 BD FF E0 AF BC 00 10 00 C5 30 23 AF B0 00 18 AF BF 00 1C 10 C0 00 04 00 80 80 21 8F 99 ?? ?? ?? ?? ?? ?? AC 85 00 10 8E 03 00 10 8E 02 00 08 8F BF 00 1C 8F B0 00 18 00 62 10 23 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_116_0_0 {
	meta:
		name = "__GI_sleep"
		size = 424
		refs = "0000 _gp_disp 0044 __GI___sigaddset 0078 __GI_sigprocmask 0098 __GI___sigismember 00ac __GI_nanosleep 00dc __GI_sigaction 010c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 80 AF BC 00 10 AF BF 00 7C AF B5 00 78 AF B4 00 74 AF B3 00 70 AF B2 00 6C AF B1 00 68 AF B0 00 64 AF A4 00 54 14 80 00 03 AF A0 00 58 10 00 00 51 00 00 10 21 8F 95 ?? ?? 27 B3 00 44 02 60 20 21 24 05 00 12 02 A0 C8 21 AF A0 00 50 AF A0 00 4C AF A0 00 48 ?? ?? ?? ?? AF A0 00 44 8F BC 00 10 27 B0 00 34 24 04 00 01 8F 92 ?? ?? 02 60 28 21 02 40 C8 21 ?? ?? ?? ?? 02 00 30 21 8F BC 00 10 02 00 20 21 24 05 00 12 8F 99 ?? ?? ?? ?? ?? ?? 27 B1 00 54 8F BC 00 10 14 40 00 28 8F 94 ?? ?? 02 60 20 21 24 05 00 12 02 A0 C8 21 AF A0 00 50 AF A0 00 4C AF A0 00 48 ?? ?? ?? ?? AF A0 00 44 8F BC 00 10 24 04 00 12 00 00 28 21 8F 99 ?? ?? ?? ?? ?? ?? 27 A6 00 18 8F A3 00 1C 24 02 00 01 14 62 00 12 24 04 00 03 02 20 20 21 02 80 C8 21 ?? ?? ?? ?? 02 20 28 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 40 88 21 8C 54 00 00 00 40 98 21 24 04 00 03 02 00 28 21 02 40 C8 21 ?? ?? ?? ?? 00 00 30 21 10 00 00 0A AE 74 00 00 02 00 28 21 02 40 C8 21 ?? ?? ?? ?? 00 00 30 21 02 20 20 21 02 80 C8 21 ?? ?? ?? ?? 02 20 28 21 00 40 88 21 12 20 00 08 00 00 10 21 8F A3 00 58 3C 02 1D CD 24 42 65 00 00 62 10 2A 8F A3 00 54 38 42 00 01 00 43 10 21 8F BF 00 7C 8F B5 00 78 8F B4 00 74 8F B3 00 70 8F B2 00 6C 8F B1 00 68 8F B0 00 64 03 E0 00 08 27 BD 00 80 }
	condition:
		$1
}

rule file_117_0_0 {
	meta:
		name = "__GI_xdr_array"
		size = 444
		refs = "0000 _gp_disp 0010 __GI_xdr_u_int 00d8 malloc 00f4 stderr 00fc __GI_fputs 00f8 $LC0 0118 __GI_memset 0180 free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 8F 99 ?? ?? AF BC 00 10 AF B6 00 30 AF B5 00 2C AF B4 00 28 AF B3 00 24 AF B2 00 20 AF B1 00 1C AF BF 00 34 AF B0 00 18 8C B0 00 00 00 A0 98 21 00 C0 28 21 00 80 A0 21 00 C0 90 21 00 E0 B0 21 ?? ?? ?? ?? 8F B5 00 48 00 00 88 21 10 40 00 4C 8F BC 00 10 8E 52 00 00 02 D2 B0 2B 56 C0 00 09 8E 83 00 00 24 02 FF FF 00 55 00 1B 02 A0 01 F4 00 00 10 12 00 52 10 2B 10 40 00 05 00 00 00 00 8E 83 00 00 24 02 00 02 14 62 00 3D 00 00 88 21 16 00 00 24 24 02 00 01 8E 82 00 00 24 03 00 01 10 43 00 06 24 11 00 01 24 03 00 02 10 43 00 35 8F BF 00 34 10 00 00 1B 24 02 00 01 12 40 00 31 8F BF 00 34 72 55 88 02 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 00 40 80 21 8F BC 00 10 14 40 00 0A AE 62 00 00 8F 82 ?? ?? 8F 84 ?? ?? 8F 99 ?? ?? 8C 45 00 00 24 84 ?? ?? ?? ?? ?? ?? 00 00 88 21 10 00 00 20 8F BF 00 34 8F 99 ?? ?? 00 40 20 21 00 00 28 21 ?? ?? ?? ?? 02 20 30 21 8F BC 00 10 24 02 00 01 00 00 B0 21 02 D2 18 2B 50 60 00 0C 8E 83 00 00 10 40 00 09 8F B9 00 4C 02 00 28 21 02 80 20 21 03 20 F8 09 24 06 FF FF 02 15 80 21 8F BC 00 10 10 00 FF F4 26 D6 00 01 8E 83 00 00 00 40 88 21 24 02 00 02 14 62 00 06 8F BF 00 34 8F 99 ?? ?? ?? ?? ?? ?? 8E 64 00 00 AE 60 00 00 8F BF 00 34 02 20 10 21 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_117_1_0 {
	meta:
		name = "xdr_vector"
		size = 136
	strings:
		$1 = { 27 BD FF D0 AF B4 00 28 AF B3 00 24 AF B2 00 20 AF B1 00 1C AF B0 00 18 AF BF 00 2C 00 80 98 21 00 A0 80 21 00 C0 90 21 00 E0 A0 21 00 00 88 21 02 32 10 2B 10 40 00 09 8F B9 00 40 02 60 20 21 02 00 28 21 03 20 F8 09 24 06 FF FF 10 40 00 05 02 14 80 21 10 00 FF F6 26 31 00 01 10 00 00 02 24 02 00 01 00 00 10 21 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "msgrcv"
		size = 80
		refs = "0000 _gp_disp 0010 __syscall_ipc"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 8F 99 ?? ?? AF A7 00 24 8F A7 00 40 27 A3 00 20 00 80 10 21 AF BF 00 2C AF BC 00 18 AF A5 00 20 AF A3 00 10 AF A0 00 14 24 04 00 0C ?? ?? ?? ?? 00 40 28 21 8F BF 00 2C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_119_0_0 {
	meta:
		name = "__GI_btowc"
		size = 16
		altNames = "wctob"
	strings:
		$1 = { 2C 83 00 80 24 02 FF FF 03 E0 00 08 00 83 10 0B }
	condition:
		$1
}

rule file_120_0_0 {
	meta:
		name = "setrlimit64"
		size = 136
		refs = "0000 _gp_disp 0060 __GI_setrlimit"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF BC 00 10 AF BF 00 24 8C A3 00 00 14 60 00 06 8C A2 00 04 3C 03 7F FF 34 63 FF FF 00 43 18 2B 54 60 00 04 8C A3 00 08 3C 02 7F FF 34 42 FF FF 8C A3 00 08 AF A2 00 18 14 60 00 06 8C A2 00 0C 3C 03 7F FF 34 63 FF FF 00 43 18 2B 14 60 00 04 8F 99 ?? ?? 3C 02 7F FF 34 42 FF FF 8F 99 ?? ?? 27 A5 00 18 ?? ?? ?? ?? AF A2 00 1C 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_121_0_0 {
	meta:
		name = "__GI_seteuid"
		size = 200
		refs = "0000 _gp_disp 0030 __GI___errno_location 004c __GI_setresuid 009c __GI_setreuid"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B2 00 20 AF BC 00 10 24 12 FF FF AF B0 00 18 AF BF 00 24 AF B1 00 1C 14 92 00 08 00 80 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 AC 43 00 00 10 00 00 1A 24 02 FF FF 8F 99 ?? ?? 24 04 FF FF 02 00 28 21 ?? ?? ?? ?? 24 06 FF FF 00 40 88 21 16 32 00 12 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8C 44 00 00 24 03 00 59 8F BC 00 10 14 83 00 0A 02 20 10 21 8F BF 00 24 8F B2 00 20 8F B1 00 1C 02 00 28 21 8F 99 ?? ?? 8F B0 00 18 24 04 FF FF ?? ?? ?? ?? 27 BD 00 28 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_153_0_0 {
	meta:
		name = "setegid"
		size = 200
		refs = "0000 _gp_disp 0030 __GI___errno_location 004c __GI_setresgid 009c __GI_setregid"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B2 00 20 AF BC 00 10 24 12 FF FF AF B0 00 18 AF BF 00 24 AF B1 00 1C 14 92 00 08 00 80 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 AC 43 00 00 10 00 00 1A 24 02 FF FF 8F 99 ?? ?? 24 04 FF FF 02 00 28 21 ?? ?? ?? ?? 24 06 FF FF 00 40 88 21 16 32 00 12 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8C 44 00 00 24 03 00 59 8F BC 00 10 14 83 00 0A 02 20 10 21 8F BF 00 24 8F B2 00 20 8F B1 00 1C 02 00 28 21 8F 99 ?? ?? 8F B0 00 18 24 04 FF FF ?? ?? ?? ?? 27 BD 00 28 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "__GI_strstr"
		size = 228
	strings:
		$1 = { 90 A6 00 00 10 C0 00 35 00 80 10 21 24 84 FF FF 24 84 00 01 90 82 00 00 50 40 00 30 00 00 10 21 54 46 FF FC 24 84 00 01 90 A9 00 01 11 20 00 2B 00 80 10 21 90 82 00 01 10 49 00 0E 24 83 00 01 10 46 FF FC 00 60 20 21 10 40 00 24 00 00 10 21 90 62 00 01 14 46 00 03 00 00 00 00 10 00 FF F5 24 64 00 01 10 40 00 1C 24 63 00 02 10 00 FF F4 90 82 00 02 90 A4 00 02 90 67 00 01 14 E4 00 12 24 62 FF FF 24 A8 00 02 24 67 00 01 10 80 00 13 00 00 00 00 91 04 00 01 90 EA 00 01 15 44 00 0A 00 00 00 00 10 80 00 0D 24 EB 00 02 91 04 00 02 90 E7 00 02 14 E4 00 04 25 0A 00 02 01 60 38 21 10 00 FF F2 01 40 40 21 10 80 00 04 00 00 00 00 10 00 FF DB 90 62 00 00 00 00 10 21 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "bzero"
		size = 28
		refs = "0000 _gp_disp 000c __GI_memset"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 00 A0 30 21 ?? ?? ?? ?? 00 00 28 21 }
	condition:
		$1
}

rule file_579_0_0 {
	meta:
		name = "gmtime_r"
		size = 28
		refs = "0000 _gp_disp 000c _time_t2tm"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 00 A0 30 21 ?? ?? ?? ?? 00 00 28 21 }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "isctype"
		size = 40
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 00 04 20 40 8C 42 00 00 00 44 10 21 94 42 00 00 03 E0 00 08 00 A2 10 24 }
	condition:
		$1
}

rule file_125_0_0 {
	meta:
		name = "__GI_fputc"
		size = 268
		refs = "0000 _gp_disp 005c __GI___fputc_unlocked 0070 _pthread_cleanup_push_defer 0078 __pthread_mutex_unlock 0090 __pthread_mutex_lock 00dc _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF B1 00 30 AF B0 00 2C AF BC 00 10 AF BF 00 3C AF B3 00 38 AF B2 00 34 8C A2 00 34 00 80 88 21 10 40 00 0F 00 A0 80 21 8C A2 00 10 8C A3 00 1C 00 43 18 2B 10 60 00 05 24 43 00 01 AC A3 00 10 A0 44 00 00 10 00 00 26 30 82 00 FF 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 22 8F BF 00 3C 8F 99 ?? ?? 24 B3 00 38 8F 85 ?? ?? 27 B2 00 18 02 40 20 21 ?? ?? ?? ?? 02 60 30 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 8E 02 00 10 8E 03 00 1C 00 43 18 2B 10 60 00 06 8F BC 00 10 24 43 00 01 AE 03 00 10 A0 51 00 00 10 00 00 07 32 31 00 FF 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 02 00 28 21 8F BC 00 10 00 40 88 21 8F 99 ?? ?? 02 40 20 21 ?? ?? ?? ?? 24 05 00 01 02 20 10 21 8F BF 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_126_0_0 {
	meta:
		name = "__GI_strerror"
		size = 68
		refs = "0000 _gp_disp 0018 __GI___xpg_strerror_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF B0 00 18 8F 90 ?? ?? 8F 99 ?? ?? AF BF 00 1C AF BC 00 10 26 05 ?? ?? ?? ?? ?? ?? 24 06 00 32 8F BF 00 1C 26 02 ?? ?? 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_127_0_0 {
	meta:
		name = "__GI_lseek"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F B3 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_128_0_0 {
	meta:
		name = "__GI_stat"
		size = 120
		refs = "0000 _gp_disp 0034 __GI___errno_location 0054 __xstat_conv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 50 AF BC 00 10 00 A0 30 21 AF BF 00 AC AF B0 00 A8 27 A5 00 18 24 02 10 0A 00 00 00 0C 10 E0 00 07 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 10 00 00 07 24 10 FF FF 14 40 00 06 8F BF 00 AC 8F 99 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 00 C0 28 21 8F BF 00 AC 02 00 10 21 8F B0 00 A8 03 E0 00 08 27 BD 00 B0 }
	condition:
		$1
}

rule file_129_0_0 {
	meta:
		name = "clntudp_geterr"
		size = 32
	strings:
		$1 = { 8C 82 00 08 8C 43 00 2C AC A3 00 00 8C 43 00 30 AC A3 00 04 8C 42 00 34 03 E0 00 08 AC A2 00 08 }
	condition:
		$1
}

rule file_129_1_0 {
	meta:
		name = "clntudp_freeres"
		size = 28
	strings:
		$1 = { 8C 84 00 08 24 02 00 02 00 A0 C8 21 AC 82 00 38 00 C0 28 21 03 20 00 08 24 84 00 38 }
	condition:
		$1
}

rule file_129_3_0 {
	meta:
		name = "clntudp_control"
		size = 312
		refs = "0000 _gp_disp 00a8 __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 24 A5 FF FF 2C A3 00 0F 10 60 00 46 8C 82 00 08 8F 83 ?? ?? 00 05 28 80 27 BD FF E0 24 63 ?? ?? 00 65 28 21 8C A3 00 00 AF BC 00 10 AF BF 00 1C 00 7C 18 21 00 60 00 08 00 00 00 00 24 03 00 01 10 00 00 2E AC 43 00 04 10 00 00 2C AC 40 00 04 8C C3 00 00 AC 43 00 24 8C C3 00 04 10 00 00 27 AC 43 00 28 8C 43 00 24 AC C3 00 00 10 00 00 09 8C 42 00 28 8C C3 00 00 AC 43 00 1C 8C C3 00 04 10 00 00 1E AC 43 00 20 8C 43 00 1C AC C3 00 00 8C 42 00 20 10 00 00 19 AC C2 00 04 8F 99 ?? ?? 00 C0 20 21 24 45 00 08 ?? ?? ?? ?? 24 06 00 10 10 00 00 19 24 02 00 01 8C 42 00 58 10 00 00 0E 8C 42 00 00 8C C4 00 00 8C 43 00 58 24 84 FF FF AC 64 00 00 8C 42 00 58 10 00 00 07 8C 42 00 10 8C 42 00 58 8C C3 00 00 10 00 00 04 AC 43 00 10 8C 42 00 58 8C 42 00 0C AC C2 00 00 10 00 00 06 24 02 00 01 8C 42 00 58 8C C3 00 00 10 00 FF FB AC 43 00 0C 00 00 10 21 8F BF 00 1C 03 E0 00 08 27 BD 00 20 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_129_4_0 {
	meta:
		name = "is_network_up"
		size = 252
		refs = "0000 _gp_disp 0014 __GI_ioctl 0084 __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD DD 40 AF B0 22 A4 8F 90 ?? ?? 24 02 22 60 AF A2 22 98 27 A2 00 18 AF BC 00 10 AF B3 22 B0 AF BF 22 BC AF B5 22 B8 AF B4 22 B4 AF B2 22 AC AF B1 22 A8 AF A2 22 9C 34 05 89 12 27 A6 22 98 02 00 C8 21 ?? ?? ?? ?? 00 80 98 21 10 40 00 03 8F BC 00 10 10 00 00 1D 00 00 10 21 8F B1 22 98 02 00 A0 21 8F B0 22 9C 00 11 89 42 27 B2 22 78 24 15 00 02 12 20 FF F7 8F 99 ?? ?? 02 40 20 21 02 00 28 21 ?? ?? ?? ?? 24 06 00 20 02 60 20 21 34 05 89 13 02 80 C8 21 03 20 F8 09 02 40 30 21 04 40 FF EC 8F BC 00 10 97 A2 22 88 30 42 00 01 10 40 00 04 26 31 FF FF 96 02 00 10 10 55 00 03 24 02 00 01 10 00 FF EB 26 10 00 20 8F BF 22 BC 8F B5 22 B8 8F B4 22 B4 8F B3 22 B0 8F B2 22 AC 8F B1 22 A8 8F B0 22 A4 03 E0 00 08 27 BD 22 C0 }
	condition:
		$1
}

rule file_129_5_0 {
	meta:
		name = "clntudp_destroy"
		size = 136
		refs = "0000 _gp_disp 0030 __GI_close 004c free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B1 00 20 AF BC 00 10 AF BF 00 24 AF B0 00 1C 8C 90 00 08 8E 02 00 04 10 40 00 05 00 80 88 21 8F 99 ?? ?? ?? ?? ?? ?? 8E 04 00 00 8F BC 00 10 8E 02 00 3C 8C 59 00 1C 53 20 00 05 8F 99 ?? ?? 03 20 F8 09 26 04 00 38 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F BF 00 24 8F B0 00 1C 02 20 20 21 8F 99 ?? ?? 8F B1 00 20 ?? ?? ?? ?? 27 BD 00 28 }
	condition:
		$1
}

rule file_129_6_0 {
	meta:
		name = "clntudp_call"
		size = 1568
		refs = "0000 _gp_disp 0168 __GI_sendto 0184 __GI___errno_location 01a4 _null_auth 0208 __GI_poll 0238 is_network_up 02d0 __GI_recvfrom 0320 __GI_recvmsg 0348 __GI_memcmp 03fc __GI___cmsg_nxthdr 04cc __GI_xdrmem_create 050c __GI_xdr_replymsg 0520 __GI__seterr_reply 0574 __GI_xdr_opaque_auth"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FE F8 AF BE 01 00 AF B5 00 F4 AF BF 01 04 AF B7 00 FC AF B6 00 F8 AF B4 00 F0 AF B3 00 EC AF B2 00 E8 AF B1 00 E4 AF B0 00 E0 AF BC 00 18 8C 97 00 08 00 80 A8 21 24 02 03 E8 8E E4 00 20 03 A0 F0 21 AF C5 01 0C 00 82 00 1A 00 40 01 F4 8E E5 00 1C 8E F9 00 28 AF C6 01 10 AF C7 01 14 AF D9 00 B8 70 45 00 00 24 02 FF FF 00 00 18 12 17 22 00 05 AF C3 00 C8 8F C3 01 24 8F D4 01 20 10 00 00 02 AF C3 00 B8 8E F4 00 24 24 19 00 02 26 E3 00 60 00 00 88 21 00 00 80 21 AF D9 00 C0 00 00 98 21 AF C3 00 C4 8F D9 01 10 13 20 00 3E 26 F2 00 38 8E E2 00 3C AE E0 00 38 8E E5 00 50 8C 59 00 14 03 20 F8 09 02 40 20 21 8E E2 00 58 27 C5 01 0C 8C 44 00 00 24 84 00 01 AC 44 00 00 8E E2 00 3C 8C 59 00 04 03 20 F8 09 02 40 20 21 54 40 00 03 8E A4 00 00 10 00 00 CE 24 02 00 01 8C 82 00 20 8C 59 00 04 03 20 F8 09 02 40 28 21 10 40 00 C8 24 02 00 01 8F C5 01 14 8F D9 01 10 03 20 F8 09 02 40 20 21 10 40 00 C2 24 02 00 01 8E E2 00 3C 8C 59 00 10 03 20 F8 09 02 40 20 21 8F DC 00 18 00 40 98 21 26 E2 00 08 8E E4 00 00 8E E5 00 58 AF A2 00 10 8E E2 00 18 8F 99 ?? ?? 02 60 30 21 AF A2 00 14 ?? ?? ?? ?? 00 00 38 21 10 53 00 08 8F DC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8C 42 00 00 AE E2 00 30 10 00 00 A9 24 02 00 03 16 80 00 05 8F 82 ?? ?? 8F C3 00 B8 10 60 00 A4 24 02 00 05 8F 82 ?? ?? 8F D9 01 1C 8F C3 01 18 8C 44 00 00 AF D9 00 3C AF C3 00 40 AF C4 00 2C 8C 44 00 04 8C 42 00 08 27 D9 00 AC AF C4 00 30 AF C2 00 34 8E E2 00 00 AF D9 00 D0 AF C2 00 AC 24 02 00 01 A7 C2 00 B0 26 62 01 0E 00 02 10 C2 00 02 10 C0 AF C2 00 D4 8F 99 ?? ?? 8F C6 00 C8 27 C4 00 AC ?? ?? ?? ?? 24 05 00 01 24 04 FF FF 10 44 00 20 8F DC 00 18 14 40 00 27 97 C2 00 B2 8F 82 ?? ?? 24 59 ?? ?? ?? ?? ?? ?? 8E E4 00 00 10 40 00 7E 8F DC 00 18 8E E2 00 1C 02 02 80 21 8E E2 00 20 02 22 88 21 3C 19 00 0F 37 39 42 40 02 39 10 2A 14 40 00 05 3C 03 00 0F 34 63 42 40 26 10 00 01 10 00 FF F8 02 23 88 23 02 14 10 2A 54 40 FF B5 26 E2 00 08 16 14 00 04 8F C3 00 B8 02 23 10 2A 54 40 FF B0 26 E2 00 08 10 00 00 68 24 02 00 05 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8C 44 00 00 24 02 00 04 10 82 FF D3 8F DC 00 18 10 00 00 5F AE E4 00 30 30 42 00 08 10 40 00 5F 8F 96 ?? ?? 8F D9 00 D4 27 C4 00 84 AF C4 00 50 03 B9 E8 23 27 A2 00 18 27 C4 00 A4 27 A8 01 18 AF C4 00 58 AF C2 00 60 24 04 00 01 24 02 01 00 24 16 00 10 AF C8 00 A4 AF D3 00 A8 AF D6 00 54 AF C4 00 5C AF C0 00 68 AF C2 00 64 8E E4 00 00 8F 99 ?? ?? 27 C3 00 50 AF C8 00 D8 AF C3 00 BC 00 60 28 21 ?? ?? ?? ?? 24 06 20 00 8F DC 00 18 04 40 00 41 8F C8 00 D8 8F 99 ?? ?? 8E E5 00 58 01 00 20 21 AF D9 00 DC 00 40 30 21 ?? ?? ?? ?? AF C2 00 D8 8F DC 00 18 8F C7 00 D8 14 40 00 36 8F D9 00 DC 8F C2 00 68 30 42 20 00 50 40 00 33 8F 96 ?? ?? 8F C2 00 54 14 40 00 05 28 E7 00 0C 10 E0 00 14 8F C2 00 64 10 00 00 2C 8F 96 ?? ?? 54 56 00 2A 8F 96 ?? ?? 97 C4 00 84 24 02 00 02 54 82 00 26 8F 96 ?? ?? 27 C4 00 88 26 E5 00 0C 03 20 F8 09 24 06 00 04 14 40 00 1F 8F DC 00 18 97 C4 00 86 96 E2 00 0A 54 82 00 1C 8F 96 ?? ?? 8F C2 00 64 8F C4 00 60 24 16 00 0B 2C 42 00 0C 00 02 20 0B 00 80 10 21 10 00 00 06 8F 99 ?? ?? 27 C4 00 50 03 20 F8 09 00 40 28 21 8F DC 00 18 8F D9 00 DC 50 40 00 0D 8F 96 ?? ?? 8C 44 00 04 54 80 FF F7 AF D9 00 DC 8C 44 00 08 54 96 FF F4 AF D9 00 DC 8C 42 00 0C AE E2 00 30 24 02 00 04 10 00 00 6A AE E2 00 2C 8F 96 ?? ?? 27 D9 00 94 27 C3 00 B4 AF D9 00 BC AF C3 00 CC 24 02 00 10 AF C2 00 B4 8E E4 00 00 8E E6 00 5C 8F C5 00 C4 27 D9 00 94 27 C2 00 B4 AF B9 00 10 AF A2 00 14 02 C0 C8 21 ?? ?? ?? ?? 00 00 38 21 04 41 00 0A 8F DC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8C 42 00 00 24 04 00 04 10 44 FF EC 8F DC 00 18 10 00 00 49 24 05 00 0B 28 44 00 04 14 80 FF 53 8F 99 ?? ?? 8F D9 01 10 13 20 00 07 8F 99 ?? ?? 8E E4 00 58 8E E5 00 60 8C 84 00 00 14 A4 FF 4B 8F 99 ?? ?? 8F 99 ?? ?? 8F C5 00 C4 27 D6 00 6C 02 C0 20 21 00 40 30 21 ?? ?? ?? ?? 24 07 00 01 8F DC 00 18 02 C0 20 21 27 D6 00 20 8F 99 ?? ?? ?? ?? ?? ?? 02 C0 28 21 10 40 00 2B 8F DC 00 18 8F 99 ?? ?? 02 C0 20 21 ?? ?? ?? ?? 26 E5 00 2C 8E E2 00 2C 14 40 00 17 8F C3 00 C0 8E A4 00 00 27 D0 00 2C 8C 82 00 20 8C 59 00 08 03 20 F8 09 02 00 28 21 14 40 00 05 8F DC 00 18 24 02 00 07 AE E2 00 2C 24 02 00 06 AE E2 00 30 8F C2 00 30 10 40 00 17 8F 99 ?? ?? 24 02 00 02 AE E2 00 38 02 40 20 21 ?? ?? ?? ?? 02 00 28 21 10 00 00 17 8E E2 00 2C 50 60 00 15 8E E2 00 2C 8E A4 00 00 8C 82 00 20 8C 59 00 0C 03 20 F8 09 00 00 00 00 10 40 00 07 8F DC 00 18 8F D9 00 C0 27 39 FF FF 10 00 FE BC AF D9 00 C0 24 02 00 02 AE E2 00 2C 10 00 00 06 8E E2 00 2C 10 45 FF 0C 8F 99 ?? ?? AE E2 00 30 AE E4 00 2C 24 02 00 04 03 C0 E8 21 8F BF 01 04 8F BE 01 00 8F B7 00 FC 8F B6 00 F8 8F B5 00 F4 8F B4 00 F0 8F B3 00 EC 8F B2 00 E8 8F B1 00 E4 8F B0 00 E0 03 E0 00 08 27 BD 01 08 }
	condition:
		$1
}

rule file_129_7_0 {
	meta:
		name = "__GI_clntudp_bufcreate"
		size = 796
		refs = "0000 _gp_disp 000c malloc 00a4 __GI___rpc_thread_createerr 00b8 stderr 00c0 __GI_fputs 00bc $LC0 00e8 free 0100 __GI_pmap_getport 0128 __GI_memcpy 0164 _create_xid 018c __GI_xdrmem_create 01c0 __GI_xdr_callhdr 01f4 __GI_socket 0234 __GI___errno_location 0250 __GI_bindresvport 026c __GI_ioctl 0284 __GI_setsockopt 02b4 __GI_authnone_create"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF 80 AF BC 00 18 AF BF 00 7C AF B7 00 78 AF B6 00 74 AF B5 00 70 AF B4 00 6C AF B3 00 68 AF B2 00 64 AF B1 00 60 AF B0 00 5C AF A7 00 8C 00 80 98 21 24 04 00 0C 00 A0 B8 21 00 C0 B0 21 ?? ?? ?? ?? 8F B2 00 94 8F B5 00 9C 8F B4 00 98 8F BC 00 18 26 B5 00 03 26 94 00 03 00 15 A8 82 00 14 A0 82 8F 99 ?? ?? 00 15 A8 80 00 14 A0 80 26 A4 00 64 00 94 20 21 ?? ?? ?? ?? 00 40 88 21 00 40 80 21 12 20 00 03 8F BC 00 18 14 40 00 13 26 A2 00 60 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 18 00 40 90 21 8F 82 ?? ?? 8F 84 ?? ?? 8F 99 ?? ?? 8C 45 00 00 ?? ?? ?? ?? 24 84 ?? ?? 24 02 00 0C 8F BC 00 18 AE 42 00 00 12 00 00 7F AE 42 00 08 10 00 00 7A 8F 99 ?? ?? 02 02 10 21 AE 02 00 58 96 62 00 02 14 40 00 0B 8F 82 ?? ?? 8F 99 ?? ?? 02 60 20 21 02 E0 28 21 02 C0 30 21 ?? ?? ?? ?? 24 07 00 11 10 40 00 6C 8F BC 00 18 A6 62 00 02 8F 82 ?? ?? 8F 99 ?? ?? 02 60 28 21 24 42 ?? ?? 26 04 00 08 24 06 00 10 AE 22 00 04 ?? ?? ?? ?? AE 30 00 08 24 02 00 10 AE 02 00 18 8F A2 00 8C 8F BC 00 18 AE 14 00 54 AE 02 00 1C 8F A2 00 90 8F 99 ?? ?? AE 15 00 5C AE 02 00 20 24 02 FF FF AE 02 00 24 ?? ?? ?? ?? AE 02 00 28 8F BC 00 18 8E 05 00 58 AF A2 00 20 8F 99 ?? ?? 24 02 00 02 26 13 00 38 AF A2 00 28 02 60 20 21 02 80 30 21 00 00 38 21 AF A0 00 24 AF B7 00 2C ?? ?? ?? ?? AF B6 00 30 8F BC 00 18 02 60 20 21 8F 99 ?? ?? ?? ?? ?? ?? 27 A5 00 20 10 40 00 3F 8F BC 00 18 8E 02 00 3C 8C 59 00 10 03 20 F8 09 02 60 20 21 AE 02 00 50 8E 42 00 00 04 41 00 2F 8F BC 00 18 8F 99 ?? ?? 24 13 00 01 AF B3 00 54 24 04 00 02 24 05 00 01 ?? ?? ?? ?? 24 06 00 11 8F BC 00 18 04 41 00 0E AE 42 00 00 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 18 00 40 90 21 24 02 00 0C 8F 99 ?? ?? ?? ?? ?? ?? AE 42 00 00 8C 42 00 00 8F BC 00 18 10 00 00 20 AE 42 00 08 8F 99 ?? ?? 00 40 20 21 ?? ?? ?? ?? 00 00 28 21 8F BC 00 18 8E 44 00 00 24 05 66 7E 8F 99 ?? ?? ?? ?? ?? ?? 27 A6 00 54 8F BC 00 18 8E 44 00 00 24 02 00 04 8F 99 ?? ?? AF B3 00 50 AF A2 00 10 00 00 28 21 24 06 00 0B ?? ?? ?? ?? 27 A7 00 50 8F BC 00 18 10 00 00 02 AE 13 00 04 AE 00 00 04 8E 42 00 00 8F 99 ?? ?? ?? ?? ?? ?? AE 02 00 00 AE 22 00 00 10 00 00 0A 02 20 10 21 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F BC 00 18 12 20 00 03 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 00 00 10 21 8F BF 00 7C 8F B7 00 78 8F B6 00 74 8F B5 00 70 8F B4 00 6C 8F B3 00 68 8F B2 00 64 8F B1 00 60 8F B0 00 5C 03 E0 00 08 27 BD 00 80 }
	condition:
		$1
}

rule file_129_8_0 {
	meta:
		name = "__GI_clntudp_create"
		size = 80
		refs = "0000 _gp_disp 0014 __GI_clntudp_bufcreate"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 8F A2 00 44 8F 99 ?? ?? AF BF 00 2C AF A2 00 14 24 02 22 60 AF A2 00 18 AF A2 00 1C 8F A2 00 40 AF BC 00 20 AF A7 00 3C AF A2 00 10 ?? ?? ?? ?? 00 00 00 00 8F BF 00 2C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_130_0_0 {
	meta:
		name = "__GI_unlink"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F AA 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_131_0_0 {
	meta:
		name = "umount2"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F D4 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_132_0_0 {
	meta:
		name = "__GI_getchar_unlocked"
		size = 64
		refs = "0000 _gp_disp 000c stdin 0034 __GI___fgetc_unlocked"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8C 44 00 00 8C 82 00 10 8C 83 00 18 00 43 18 2B 10 60 00 04 24 43 00 01 AC 83 00 10 03 E0 00 08 90 42 00 00 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_133_0_0 {
	meta:
		name = "__GI_open64"
		size = 84
		refs = "0000 _gp_disp 0038 __GI_open"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 30 A3 01 00 AF BC 00 10 AF BF 00 24 AF A6 00 30 AF A7 00 34 10 60 00 04 00 00 10 21 27 A2 00 30 AF A2 00 18 00 C0 10 21 8F 99 ?? ?? 34 A5 20 00 ?? ?? ?? ?? 00 40 30 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_136_0_0 {
	meta:
		name = "__GI_gethostbyname2"
		size = 40
		refs = "0000 _gp_disp 0014 __GI_gethostbyname"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 24 02 00 02 14 A2 00 03 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "__GI_fcntl64"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 27 A2 00 30 AF BC 00 10 AF BF 00 24 AF B0 00 20 AF A6 00 30 AF A7 00 34 AF A2 00 18 24 02 10 7C 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 24 02 00 10 21 8F B0 00 20 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_138_0_0 {
	meta:
		name = "shutdown"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 56 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "msgget"
		size = 72
		refs = "0000 _gp_disp 000c __syscall_ipc"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 00 80 10 21 00 A0 30 21 AF BF 00 24 AF BC 00 18 AF A0 00 10 AF A0 00 14 24 04 00 0D 00 40 28 21 ?? ?? ?? ?? 00 00 38 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_141_0_0 {
	meta:
		name = "__GI_strchrnul"
		size = 240
	strings:
		$1 = { 30 A2 00 FF 30 83 00 03 50 60 00 08 30 A5 00 FF 90 83 00 00 10 62 00 32 00 00 00 00 10 60 00 30 00 00 00 00 10 00 FF F7 24 84 00 01 00 05 1A 00 00 65 28 25 00 05 1C 00 3C 06 7E FE 3C 09 81 01 00 65 28 25 34 C6 FE FF 25 29 01 00 8C 83 00 00 00 65 38 26 00 07 50 27 00 E6 38 21 01 47 38 26 00 03 50 27 00 66 18 21 01 43 18 26 00 E3 18 25 00 69 18 24 14 60 00 03 24 88 00 04 10 00 FF F3 01 00 20 21 90 83 00 00 10 62 00 15 00 00 00 00 10 60 00 13 00 00 00 00 90 87 00 01 10 E2 00 12 24 83 00 01 10 E0 00 10 00 00 00 00 90 83 00 02 10 62 00 03 00 00 00 00 54 60 00 03 90 83 00 03 03 E0 00 08 24 82 00 02 10 62 00 03 00 00 00 00 54 60 FF DE 01 00 20 21 03 E0 00 08 24 82 00 03 03 E0 00 08 00 80 10 21 03 E0 00 08 00 60 10 21 }
	condition:
		$1
}

rule file_142_0_0 {
	meta:
		name = "__getgrouplist_internal"
		size = 416
		refs = "0000 _gp_disp 0010 malloc 0070 __GI_fopen 0068 $LC0 006c $LC1 0094 __pgsreader 0098 __GI_strcmp 00ac __parsegrent 00e4 __GI_fclose 012c realloc"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FE A0 8F 99 ?? ?? AF BC 00 18 AF B1 01 3C 24 11 00 01 AF B7 01 54 AF B4 01 48 AF B3 01 44 AF B0 01 38 AF BF 01 5C AF BE 01 58 AF B6 01 50 AF B5 01 4C AF B2 01 40 00 80 B8 21 AC D1 00 00 24 04 00 20 00 A0 A0 21 ?? ?? ?? ?? 00 C0 98 21 00 40 80 21 10 40 00 40 8F BC 00 18 8F 84 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? AC 54 00 00 24 84 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? 00 40 90 21 10 40 00 38 8F BC 00 18 27 B9 01 20 8F 95 ?? ?? 8F 9E ?? ?? AF B9 01 30 27 B9 00 20 AC 51 00 34 AF B9 01 34 8F 84 ?? ?? AF B2 00 10 27 A5 01 20 27 A6 00 20 02 A0 C8 21 ?? ?? ?? ?? 24 07 01 00 14 40 00 06 8F BC 00 18 8F A2 01 28 10 54 FF F5 8F B6 01 2C 10 00 00 0C 8E C4 00 00 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 10 00 00 1E AE 71 00 00 ?? ?? ?? ?? 02 E0 28 21 10 40 00 07 8F BC 00 18 26 D6 00 04 8E C4 00 00 14 80 FF F9 03 C0 C8 21 10 00 FF E5 8F 84 ?? ?? 32 22 00 07 14 40 00 0A 8F A3 01 28 8F 99 ?? ?? 26 25 00 08 02 00 20 21 ?? ?? ?? ?? 00 05 28 80 10 40 FF E8 8F BC 00 18 00 40 80 21 8F A3 01 28 00 11 10 80 02 02 10 21 AC 43 00 00 10 00 FF D3 26 31 00 01 10 00 00 02 00 00 10 21 02 00 10 21 8F BF 01 5C 8F BE 01 58 8F B7 01 54 8F B6 01 50 8F B5 01 4C 8F B4 01 48 8F B3 01 44 8F B2 01 40 8F B1 01 3C 8F B0 01 38 03 E0 00 08 27 BD 01 60 }
	condition:
		$1
}

rule file_143_0_0 {
	meta:
		name = "__GI_ioctl"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 27 A2 00 30 AF BC 00 10 AF BF 00 24 AF B0 00 20 AF A6 00 30 AF A7 00 34 AF A2 00 18 24 02 0F D6 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 24 02 00 10 21 8F B0 00 20 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "insque"
		size = 28
	strings:
		$1 = { 8C A2 00 00 10 40 00 02 AC A4 00 00 AC 44 00 04 AC 82 00 00 03 E0 00 08 AC 85 00 04 }
	condition:
		$1
}

rule file_145_0_0 {
	meta:
		name = "__GI___xpg_strerror_r"
		size = 356
		refs = "0000 _gp_disp 0070 _string_syserrmsgs 009c _uintmaxtostr 00c8 __GI_memcpy 00e0 __GI_strlen 0134 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 00 80 38 21 8F 84 ?? ?? 27 BD FF 90 00 00 18 21 24 84 ?? ?? AF B3 00 68 AF B2 00 64 AF BC 00 18 AF BF 00 6C AF B1 00 60 AF B0 00 5C 00 A0 98 21 00 C0 90 21 24 02 00 7E 00 64 28 21 90 A5 00 00 50 A7 00 09 2C 62 00 7E 24 63 00 01 54 62 FF FB 00 64 28 21 24 02 04 6D 14 E2 00 0D 24 03 00 7A 10 00 00 03 8F 90 ?? ?? 10 40 00 09 8F 90 ?? ?? 10 60 00 05 82 02 00 00 2C 42 00 01 00 62 18 23 10 00 FF FB 26 10 00 01 14 40 00 12 00 00 88 21 8F 99 ?? ?? 24 02 FF F6 00 07 37 C3 27 A4 00 51 AF A2 00 10 ?? ?? ?? ?? AF A0 00 14 8F BC 00 18 24 50 FF F2 02 00 20 21 8F 85 ?? ?? 8F 99 ?? ?? 24 06 00 0E ?? ?? ?? ?? 24 A5 ?? ?? 8F BC 00 18 24 11 00 16 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 00 13 90 0A 24 42 00 01 02 42 18 2B 14 60 00 03 8F BC 00 18 10 00 00 02 00 40 90 21 24 11 00 22 12 40 00 08 8F 99 ?? ?? 02 40 30 21 02 60 20 21 02 00 28 21 ?? ?? ?? ?? 02 72 90 21 8F BC 00 18 A2 40 FF FF 12 20 00 04 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 51 00 00 8F BF 00 6C 02 20 10 21 8F B3 00 68 8F B2 00 64 8F B1 00 60 8F B0 00 5C 03 E0 00 08 27 BD 00 70 }
	condition:
		$1
}

rule file_146_0_0 {
	meta:
		name = "sigqueue"
		size = 208
		refs = "0000 _gp_disp 0010 __GI_memset 0058 __GI_getpid 0068 __GI_getuid 009c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 50 8F 99 ?? ?? AF B1 00 A0 27 B1 00 18 AF BF 00 AC AF BC 00 10 AF B3 00 A8 AF B2 00 A4 AF B0 00 9C 00 80 90 21 00 A0 80 21 02 20 20 21 00 00 28 21 00 C0 98 21 ?? ?? ?? ?? 24 06 00 80 8F BC 00 10 24 02 FF FF AF B0 00 18 8F 99 ?? ?? ?? ?? ?? ?? AF A2 00 1C 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? AF A2 00 24 AF A2 00 28 8F BC 00 10 AF B3 00 2C 02 40 20 21 02 00 28 21 02 20 30 21 24 02 10 66 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 AC 02 00 10 21 8F B3 00 A8 8F B2 00 A4 8F B1 00 A0 8F B0 00 9C 03 E0 00 08 27 BD 00 B0 }
	condition:
		$1
}

rule file_147_0_0 {
	meta:
		name = "__GI_memmem"
		size = 212
		refs = "0000 _gp_disp 0028 __GI_memcmp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 10 E0 00 2F 00 80 10 21 00 A7 10 2B 14 40 00 21 00 A7 28 23 27 BD FF C8 AF B3 00 24 8F 93 ?? ?? AF B6 00 30 AF B5 00 2C AF B4 00 28 AF B1 00 1C AF B0 00 18 AF BC 00 10 AF BF 00 34 AF B2 00 20 00 C0 88 21 00 80 80 21 00 85 A0 21 24 D5 00 01 24 F6 FF FF 02 90 10 2B 14 40 00 10 00 00 10 21 82 03 00 00 82 22 00 00 14 62 00 08 26 12 00 01 02 40 20 21 02 A0 28 21 02 60 C8 21 ?? ?? ?? ?? 02 C0 30 21 10 40 00 05 02 00 10 21 10 00 FF F1 02 40 80 21 03 E0 00 08 00 00 10 21 8F BF 00 34 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 27 BD 00 38 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_148_0_0 {
	meta:
		name = "sigaltstack"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 6E 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_149_0_0 {
	meta:
		name = "__GI_bindresvport"
		size = 388
		refs = "0000 _gp_disp 0048 __GI___errno_location 00a8 __GI_getpid 00e8 __GI_bind"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B0 AF BC 00 10 AF B5 00 3C AF B1 00 2C AF B0 00 28 AF BF 00 4C AF BE 00 48 AF B7 00 44 AF B6 00 40 AF B4 00 38 AF B3 00 34 AF B2 00 30 00 80 A8 21 00 A0 80 21 14 A0 00 09 8F 91 ?? ?? 24 02 00 02 AF A0 00 18 AF A0 00 1C AF A0 00 20 AF A0 00 24 A7 A2 00 18 10 00 00 0C 27 B0 00 18 94 A3 00 00 24 02 00 02 10 62 00 09 8F 92 ?? ?? 02 20 C8 21 ?? ?? ?? ?? 00 00 00 00 24 03 00 7B AC 43 00 00 10 00 00 30 24 02 FF FF 8F 92 ?? ?? 86 42 ?? ?? 14 40 00 0B 02 20 C8 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 01 A8 00 43 00 1A 00 60 01 F4 00 00 10 10 24 43 02 58 A6 43 ?? ?? 02 20 C8 21 ?? ?? ?? ?? 00 00 88 21 8F BC 00 10 00 40 98 21 24 02 00 7D 8F 94 ?? ?? 8F 96 ?? ?? AE 62 00 00 24 02 FF FF 24 17 00 7D 24 1E 02 58 8E 63 00 00 14 77 00 15 8F BF 00 4C 96 42 ?? ?? A6 02 00 02 24 42 00 01 7C 02 16 20 28 43 04 00 50 60 00 02 A6 9E ?? ?? A6 82 ?? ?? 02 A0 20 21 02 00 28 21 02 C0 C8 21 ?? ?? ?? ?? 24 06 00 10 26 31 00 01 24 03 01 A8 12 23 00 04 8F BF 00 4C 04 42 FF EC 8E 63 00 00 8F BF 00 4C 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_150_0_0 {
	meta:
		name = "__GI_xprt_register"
		size = 476
		refs = "0000 _gp_disp 000c __rpc_thread_variables 0054 __GI__rpc_dtablesize 0088 malloc 00bc __GI___rpc_thread_svc_max_pollfd 00c0 __GI___rpc_thread_svc_fdset 00f0 __GI___rpc_thread_svc_pollfd 0168 realloc"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF C8 AF BC 00 10 AF B3 00 24 AF B2 00 20 AF B1 00 1C AF BF 00 34 AF B6 00 30 AF B5 00 2C AF B4 00 28 AF B0 00 18 00 80 90 21 ?? ?? ?? ?? 8C 90 00 00 00 40 88 21 8F BC 00 10 8C 42 00 B4 10 40 00 09 8F 93 ?? ?? 02 60 C8 21 ?? ?? ?? ?? 00 00 00 00 02 02 10 2A 14 40 00 0E 8F BC 00 10 10 00 00 51 8F BF 00 34 02 60 C8 21 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 02 20 80 14 40 FF F0 AE 22 00 B4 10 00 00 46 8F BF 00 34 8E 23 00 B4 00 10 10 80 00 62 10 21 AC 52 00 00 2A 02 04 00 10 40 00 0D 8F 94 ?? ?? 8F 99 ?? ?? 00 10 89 42 ?? ?? ?? ?? 00 11 88 80 00 51 10 21 8C 44 00 00 24 03 00 01 02 03 18 04 00 83 18 25 8F BC 00 10 AC 43 00 00 8F 94 ?? ?? 8F 95 ?? ?? 00 00 90 21 24 16 FF FF 02 80 C8 21 ?? ?? ?? ?? 00 00 00 00 8C 53 00 00 00 40 88 21 02 53 10 2A 10 40 00 0D 8F BC 00 10 02 A0 C8 21 ?? ?? ?? ?? 00 00 00 00 8C 44 00 00 00 12 18 C0 00 83 20 21 8C 85 00 00 14 B6 FF F0 26 52 00 01 AC 90 00 00 10 00 00 18 8C 42 00 00 8F 99 ?? ?? 26 73 00 01 ?? ?? ?? ?? AE 33 00 00 8F BC 00 10 8C 44 00 00 00 13 28 C0 8F 99 ?? ?? ?? ?? ?? ?? 00 40 90 21 10 40 00 0F AE 42 00 00 8E 24 00 00 3C 03 1F FF 34 63 FF FF 00 83 20 21 00 04 20 C0 00 44 10 21 AC 50 00 00 8E 22 00 00 00 43 18 21 8E 42 00 00 00 03 18 C0 00 43 18 21 24 02 00 C3 A4 62 00 04 8F BF 00 34 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_150_1_0 {
	meta:
		name = "__GI_xprt_unregister"
		size = 288
		refs = "0000 _gp_disp 0010 __GI__rpc_dtablesize 0048 __rpc_thread_variables 0078 __GI___rpc_thread_svc_max_pollfd 007c __GI___rpc_thread_svc_fdset 00b0 __GI___rpc_thread_svc_pollfd"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 8F 99 ?? ?? AF BC 00 10 AF B1 00 1C AF BF 00 2C AF B4 00 28 AF B3 00 24 AF B2 00 20 AF B0 00 18 8C 90 00 00 ?? ?? ?? ?? 00 80 88 21 02 02 10 2A 10 40 00 2F 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8C 42 00 B4 00 10 18 80 00 43 10 21 8C 43 00 00 14 71 00 26 8F BC 00 10 AC 40 00 00 2A 02 04 00 10 40 00 0E 8F 92 ?? ?? 8F 99 ?? ?? 00 10 89 42 ?? ?? ?? ?? 00 11 88 80 00 51 10 21 8C 44 00 00 24 03 00 01 02 03 18 04 00 03 18 27 00 64 18 24 8F BC 00 10 AC 43 00 00 8F 92 ?? ?? 8F 93 ?? ?? 00 00 88 21 24 14 FF FF 02 40 C8 21 ?? ?? ?? ?? 00 00 00 00 8C 42 00 00 02 22 10 2A 10 40 00 0B 02 60 C8 21 ?? ?? ?? ?? 00 00 00 00 8C 42 00 00 00 11 18 C0 00 43 10 21 8C 43 00 00 50 70 00 01 AC 54 00 00 10 00 FF F0 26 31 00 01 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_150_2_0 {
	meta:
		name = "__GI_svc_register"
		size = 284
		refs = "0000 _gp_disp 000c __rpc_thread_variables 005c malloc 00ec __GI_pmap_set"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF C8 AF BC 00 10 AF B5 00 30 AF B4 00 2C AF B3 00 28 AF B2 00 24 AF B1 00 20 AF B0 00 1C AF BF 00 34 00 80 A8 21 00 A0 80 21 00 C0 88 21 00 E0 98 21 ?? ?? ?? ?? 8F B4 00 48 8C 43 00 B8 8F BC 00 10 00 40 90 21 10 60 00 0D 8F 99 ?? ?? 8C 62 00 04 54 50 FF FC 8C 63 00 00 8C 62 00 08 50 51 00 03 8C 62 00 0C 10 00 FF F7 8C 63 00 00 10 53 00 0D 00 00 00 00 10 00 00 1B 00 00 10 21 ?? ?? ?? ?? 24 04 00 10 10 40 FF FB 8F BC 00 10 AC 50 00 04 AC 51 00 08 AC 53 00 0C 8E 43 00 B8 AC 43 00 00 AE 42 00 B8 12 80 00 0F 24 02 00 01 8F BF 00 34 8F B3 00 28 8F B2 00 24 02 00 20 21 02 20 28 21 8F B0 00 1C 8F B1 00 20 02 80 30 21 96 A7 00 04 8F B4 00 2C 8F B5 00 30 8F 99 ?? ?? ?? ?? ?? ?? 27 BD 00 38 8F BF 00 34 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_150_3_0 {
	meta:
		name = "__GI_svc_unregister"
		size = 192
		refs = "0000 _gp_disp 000c __rpc_thread_variables 007c free 00a4 __GI_pmap_unset"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BC 00 10 AF B1 00 20 AF B0 00 1C AF BF 00 24 00 80 80 21 ?? ?? ?? ?? 00 A0 88 21 8C 43 00 B8 8F BC 00 10 00 00 30 21 10 60 00 1C 8F BF 00 24 8C 64 00 04 54 90 00 05 00 60 30 21 8C 64 00 08 10 91 00 04 00 00 00 00 00 60 30 21 10 00 FF F6 8C 63 00 00 14 C0 00 03 8C 64 00 00 10 00 00 02 AC 44 00 B8 AC C4 00 00 8F 99 ?? ?? 00 60 20 21 ?? ?? ?? ?? AC 60 00 00 8F BC 00 10 8F BF 00 24 02 00 20 21 02 20 28 21 8F B0 00 1C 8F B1 00 20 8F 99 ?? ?? ?? ?? ?? ?? 27 BD 00 28 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_150_4_0 {
	meta:
		name = "__GI_svc_sendreply"
		size = 84
	strings:
		$1 = { 27 BD FF B0 24 03 00 01 AF A3 00 1C 8C 83 00 20 8C 82 00 08 AF BF 00 4C AF A3 00 24 8C 83 00 24 AF A6 00 34 AF A5 00 38 AF A3 00 28 8C 83 00 28 AF A0 00 30 AF A3 00 2C 8C 59 00 0C AF A0 00 20 03 20 F8 09 27 A5 00 18 8F BF 00 4C 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_150_5_0 {
	meta:
		name = "svcerr_noproc"
		size = 80
	strings:
		$1 = { 27 BD FF B0 24 03 00 01 AF A3 00 1C 8C 83 00 20 8C 82 00 08 AF BF 00 4C AF A3 00 24 8C 83 00 24 AF A0 00 20 AF A3 00 28 8C 83 00 28 AF A3 00 2C 24 03 00 03 AF A3 00 30 8C 59 00 0C 03 20 F8 09 27 A5 00 18 8F BF 00 4C 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_150_6_0 {
	meta:
		name = "__GI_svcerr_decode"
		size = 80
	strings:
		$1 = { 27 BD FF B0 24 03 00 01 AF A3 00 1C 8C 83 00 20 8C 82 00 08 AF BF 00 4C AF A3 00 24 8C 83 00 24 AF A0 00 20 AF A3 00 28 8C 83 00 28 AF A3 00 2C 24 03 00 04 AF A3 00 30 8C 59 00 0C 03 20 F8 09 27 A5 00 18 8F BF 00 4C 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_150_7_0 {
	meta:
		name = "svcerr_systemerr"
		size = 80
	strings:
		$1 = { 27 BD FF B0 24 03 00 01 AF A3 00 1C 8C 83 00 20 8C 82 00 08 AF BF 00 4C AF A3 00 24 8C 83 00 24 AF A0 00 20 AF A3 00 28 8C 83 00 28 AF A3 00 2C 24 03 00 05 AF A3 00 30 8C 59 00 0C 03 20 F8 09 27 A5 00 18 8F BF 00 4C 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_150_8_0 {
	meta:
		name = "__GI_svcerr_auth"
		size = 56
	strings:
		$1 = { 27 BD FF B0 24 02 00 01 AF BF 00 4C AF A2 00 24 AF A2 00 1C AF A2 00 20 8C 82 00 08 AF A5 00 28 8C 59 00 0C 03 20 F8 09 27 A5 00 18 8F BF 00 4C 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_150_10_0 {
	meta:
		name = "__GI_svcerr_noprog"
		size = 76
	strings:
		$1 = { 8C 85 00 20 27 BD FF B0 8C 82 00 08 AF A5 00 24 8C 85 00 24 24 03 00 01 AF BF 00 4C AF A5 00 28 8C 85 00 28 AF A3 00 30 AF A3 00 1C AF A5 00 2C 8C 59 00 0C AF A0 00 20 03 20 F8 09 27 A5 00 18 8F BF 00 4C 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_150_11_0 {
	meta:
		name = "__GI_svcerr_progvers"
		size = 88
	strings:
		$1 = { 27 BD FF B0 24 03 00 01 AF A3 00 1C 8C 83 00 20 8C 82 00 08 AF BF 00 4C AF A3 00 24 8C 83 00 24 AF A5 00 34 AF A6 00 38 AF A3 00 28 8C 83 00 28 AF A0 00 20 AF A3 00 2C 24 03 00 02 AF A3 00 30 8C 59 00 0C 03 20 F8 09 27 A5 00 18 8F BF 00 4C 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_150_12_0 {
	meta:
		name = "__GI_svc_getreq_common"
		size = 524
		refs = "0000 _gp_disp 0014 __rpc_thread_variables 006c __GI_svcerr_noprog 0070 __GI_svcerr_progvers 00d8 _null_auth 00ec __GI__authenticate 0104 __GI_svcerr_auth"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FA C8 27 A2 00 18 8F 99 ?? ?? AF A2 04 E4 27 A2 01 A8 AF BC 00 10 AF B1 05 1C AF B0 05 18 AF BF 05 34 AF B6 05 30 AF B5 05 2C AF B4 05 28 AF B3 05 24 AF B2 05 20 AF A2 04 F0 ?? ?? ?? ?? 00 80 80 21 00 40 88 21 8C 42 00 B4 00 10 80 80 00 50 80 21 8E 10 00 00 12 00 00 5F 8F BC 00 10 8F 95 ?? ?? 8F 96 ?? ?? 27 B2 04 C8 27 B4 03 38 27 B3 04 F8 8E 02 00 08 02 00 20 21 8C 59 00 00 03 20 F8 09 02 40 28 21 10 40 00 45 8F BC 00 10 8F A2 04 D4 8F A3 04 E4 AF B4 05 10 AF A2 04 F8 8F A2 04 D8 AF A3 05 08 8F A3 04 E8 AF A2 04 FC 8F A2 04 DC AF B0 05 14 AF A3 05 0C AF A2 05 00 8F A2 04 E0 14 40 00 06 AF A2 05 04 8F 82 ?? ?? AE 00 00 28 8C 42 00 00 10 00 00 0D AE 02 00 20 8F 99 ?? ?? 02 60 20 21 ?? ?? ?? ?? 02 40 28 21 10 40 00 07 8F BC 00 10 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 00 40 28 21 10 00 00 25 00 00 00 00 8E 23 00 B8 00 00 10 21 00 00 30 21 24 05 FF FF 10 60 00 15 00 00 00 00 8C 67 00 04 8F A4 04 F8 54 E4 FF FB 8C 63 00 00 8C 67 00 08 8F A2 04 FC 14 E2 00 07 00 E5 10 2B 8C 79 00 0C 02 60 20 21 03 20 F8 09 02 00 28 21 10 00 00 11 00 00 00 00 00 E2 28 0B 00 C7 10 2B 00 E2 30 0B 24 02 00 01 10 00 FF EB 8C 63 00 00 10 40 00 06 02 00 20 21 02 C0 C8 21 ?? ?? ?? ?? 00 00 00 00 10 00 00 04 00 00 00 00 02 A0 C8 21 ?? ?? ?? ?? 00 00 00 00 8E 02 00 08 8C 59 00 04 03 20 F8 09 02 00 20 21 14 40 00 07 24 03 00 01 8E 02 00 08 8C 59 00 14 03 20 F8 09 02 00 20 21 10 00 00 04 8F BF 05 34 50 43 FF A9 8E 02 00 08 8F BF 05 34 8F B6 05 30 8F B5 05 2C 8F B4 05 28 8F B3 05 24 8F B2 05 20 8F B1 05 1C 8F B0 05 18 03 E0 00 08 27 BD 05 38 }
	condition:
		$1
}

rule file_150_13_0 {
	meta:
		name = "__GI_svc_getreqset"
		size = 220
		refs = "0000 _gp_disp 000c __GI__rpc_dtablesize 0050 __GI_svc_getreq_common"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF C0 AF BC 00 10 AF B6 00 34 AF B5 00 30 AF B4 00 2C AF B3 00 28 AF B0 00 1C AF BF 00 3C AF B7 00 38 AF B2 00 24 AF B1 00 20 ?? ?? ?? ?? 00 80 80 21 8F BC 00 10 02 00 20 21 00 40 A0 21 8F 93 ?? ?? 00 00 80 21 24 15 00 1F 24 16 00 01 02 14 10 2A 10 40 00 12 24 97 00 04 8C 91 00 00 00 11 90 23 02 32 90 24 72 52 90 20 02 B2 90 23 26 44 00 01 10 80 00 07 02 60 C8 21 02 04 20 21 24 84 FF FF ?? ?? ?? ?? 02 56 90 04 10 00 FF F4 02 32 88 26 26 10 00 20 10 00 FF ED 02 E0 20 21 8F BF 00 3C 8F B7 00 38 8F B6 00 34 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_150_14_0 {
	meta:
		name = "__GI_svc_getreq"
		size = 84
		refs = "0000 _gp_disp 0038 __GI_svc_getreqset"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 60 00 00 10 21 27 A3 00 18 AF BC 00 10 AF BF 00 9C 24 05 00 20 00 02 30 80 00 66 30 21 24 42 00 01 14 45 FF FC AC C0 00 00 8F 99 ?? ?? AF A4 00 18 ?? ?? ?? ?? 00 60 20 21 8F BF 00 9C 03 E0 00 08 27 BD 00 A0 }
	condition:
		$1
}

rule file_150_15_0 {
	meta:
		name = "__GI_svc_getreq_poll"
		size = 276
		refs = "0000 _gp_disp 0020 __GI_svc_getreq_common 0024 __GI___rpc_thread_svc_max_pollfd 0028 __rpc_thread_variables 002c __GI_xprt_unregister"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF BE 00 40 AF B7 00 3C AF B6 00 38 AF B4 00 30 8F 96 ?? ?? 8F 94 ?? ?? 8F 97 ?? ?? 8F 9E ?? ?? AF B5 00 34 AF B3 00 2C AF B2 00 28 AF B1 00 24 AF B0 00 20 AF BC 00 10 AF BF 00 44 00 80 98 21 00 A0 90 21 00 00 88 21 00 00 80 21 24 15 FF FF 02 80 C8 21 ?? ?? ?? ?? 00 00 00 00 8C 42 00 00 02 02 10 2A 10 40 00 1B 02 32 10 2A 10 40 00 19 00 10 10 C0 02 62 10 21 8C 44 00 00 50 95 FF F4 26 10 00 01 84 42 00 06 50 40 FF F1 26 10 00 01 30 42 00 20 26 31 00 01 10 40 00 0A 02 C0 C8 21 02 E0 C8 21 ?? ?? ?? ?? AF A4 00 18 8F A4 00 18 8C 42 00 B4 03 C0 C8 21 00 04 20 80 00 44 20 21 8C 84 00 00 03 20 F8 09 00 00 00 00 10 00 FF E0 26 10 00 01 8F BF 00 44 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_150_16_0 {
	meta:
		name = "__rpc_thread_svc_cleanup"
		size = 104
		refs = "0000 _gp_disp 0018 __GI_svc_unregister 001c __rpc_thread_variables"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B1 00 20 AF B0 00 1C 8F 91 ?? ?? 8F 90 ?? ?? AF BC 00 10 AF BF 00 24 02 00 C8 21 ?? ?? ?? ?? 00 00 00 00 8C 42 00 B8 10 40 00 06 02 20 C8 21 8C 44 00 04 ?? ?? ?? ?? 8C 45 00 08 10 00 FF F7 02 00 C8 21 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_151_0_0 {
	meta:
		name = "__GI_uname"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 1A 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_152_0_0 {
	meta:
		name = "__GI_tcgetattr"
		size = 172
		refs = "0000 _gp_disp 000c __GI_ioctl 0044 __GI_mempcpy 0088 __GI_memset"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF B0 27 A6 00 18 AF BC 00 10 AF B1 00 48 AF B0 00 44 AF BF 00 4C 00 A0 80 21 ?? ?? ?? ?? 24 05 54 0D 00 40 88 21 14 40 00 16 8F BC 00 10 8F A2 00 18 8F 99 ?? ?? 26 04 00 11 AE 02 00 00 8F A2 00 1C 27 A5 00 29 24 06 00 17 AE 02 00 04 8F A2 00 20 AE 02 00 08 8F A2 00 24 AE 02 00 0C 93 A2 00 28 ?? ?? ?? ?? A2 02 00 10 8F BC 00 10 00 40 20 21 00 00 28 21 8F 99 ?? ?? ?? ?? ?? ?? 24 06 00 09 8F BF 00 4C 02 20 10 21 8F B0 00 44 8F B1 00 48 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "a64l"
		size = 92
		refs = "0000 _gp_disp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 87 ?? ?? 24 86 00 06 00 00 18 21 00 00 10 21 24 E7 ?? ?? 24 08 00 40 80 85 00 00 24 A5 FF D2 2C A9 00 4D 11 20 00 08 00 A7 28 21 80 A5 00 00 10 A8 00 05 00 65 28 04 24 84 00 01 00 45 10 25 14 86 FF F5 24 63 00 06 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_155_0_0 {
	meta:
		name = "putgrent"
		size = 336
		refs = "0000 _gp_disp 003c __GI___errno_location 0060 _pthread_cleanup_push_defer 0068 __pthread_mutex_unlock 007c __pthread_mutex_lock 0090 __GI_fprintf 008c $LC0 00d8 __GI___fputc_unlocked 011c _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF BC 00 18 AF B1 00 34 AF BF 00 44 AF B4 00 40 AF B3 00 3C AF B2 00 38 AF B0 00 30 10 80 00 03 00 80 88 21 14 A0 00 07 00 A0 80 21 8F 99 ?? ?? ?? ?? ?? ?? 24 10 FF FF 24 03 00 16 10 00 00 37 AC 43 00 00 8C B2 00 34 56 40 00 0D 8F 85 ?? ?? 8F 99 ?? ?? 24 B3 00 38 8F 85 ?? ?? 27 A4 00 20 ?? ?? ?? ?? 02 60 30 21 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 8F BC 00 18 8F 85 ?? ?? 8F 93 ?? ?? 8E 22 00 08 8E 26 00 00 8E 27 00 04 02 00 20 21 AF A2 00 10 02 60 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 04 40 00 16 8F BC 00 18 8F 85 ?? ?? 8E 31 00 0C 8F 94 ?? ?? 24 A5 ?? ?? 8E 26 00 00 14 C0 00 08 02 60 C8 21 8F 99 ?? ?? 02 00 28 21 ?? ?? ?? ?? 24 04 00 0A 00 02 87 C3 10 00 00 09 8F BC 00 18 ?? ?? ?? ?? 02 00 20 21 04 40 00 04 8F BC 00 18 26 31 00 04 10 00 FF F0 26 85 ?? ?? 24 10 FF FF 16 40 00 06 8F BF 00 44 8F 99 ?? ?? 27 A4 00 20 ?? ?? ?? ?? 24 05 00 01 8F BF 00 44 02 00 10 21 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "parse_printf_format"
		size = 428
		refs = "0000 _gp_disp 0010 _ppfs_init 00a0 _ppfs_parsespec"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 28 8F 99 ?? ?? AF B4 00 C0 AF B3 00 BC 27 B4 00 18 00 80 98 21 AF BC 00 10 AF B1 00 B4 AF B0 00 B0 AF BF 00 D4 AF BE 00 D0 AF B7 00 CC AF B6 00 C8 AF B5 00 C4 AF B2 00 B8 00 A0 88 21 02 80 20 21 02 60 28 21 ?? ?? ?? ?? 00 C0 80 21 04 40 00 45 8F BC 00 10 8F B2 00 30 1A 40 00 0D 02 51 10 2B 02 42 88 0B 00 00 10 21 00 51 18 2B 10 60 00 3E 24 43 00 0A 00 03 18 80 02 83 18 21 8C 63 00 00 24 42 00 01 26 10 00 04 10 00 FF F7 AE 03 FF FC 8F 97 ?? ?? 00 00 90 21 24 15 00 25 3C 16 80 00 24 1E 00 08 82 62 00 00 10 40 00 30 8F BF 00 D4 54 55 FF FC 26 73 00 01 82 63 00 01 10 75 00 26 26 62 00 01 AF A2 00 18 02 E0 C8 21 ?? ?? ?? ?? 02 80 20 21 8F A2 00 20 14 56 00 06 8F B3 00 18 12 20 00 04 26 52 00 01 AE 00 00 00 26 31 FF FF 26 10 00 04 8F A2 00 1C 14 56 00 07 00 00 10 21 12 20 00 05 26 52 00 01 AE 00 00 00 26 31 FF FF 26 10 00 04 00 00 10 21 8F A3 00 34 00 43 18 2B 10 60 FF E0 24 43 00 0A 00 03 18 80 02 83 18 21 8C 63 00 00 50 7E FF F8 24 42 00 01 12 20 00 04 26 52 00 01 AE 03 00 00 26 31 FF FF 26 10 00 04 10 00 FF F1 24 42 00 01 00 40 98 21 10 00 FF D1 26 73 00 01 00 00 90 21 8F BF 00 D4 02 40 10 21 8F BE 00 D0 8F B7 00 CC 8F B6 00 C8 8F B5 00 C4 8F B4 00 C0 8F B3 00 BC 8F B2 00 B8 8F B1 00 B4 8F B0 00 B0 03 E0 00 08 27 BD 00 D8 }
	condition:
		$1
}

rule file_157_0_0 {
	meta:
		name = "xdr_free"
		size = 40
	strings:
		$1 = { 27 BD FF C8 00 80 C8 21 24 02 00 02 AF BF 00 34 AF A2 00 18 03 20 F8 09 27 A4 00 18 8F BF 00 34 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_157_2_0 {
	meta:
		name = "__GI_xdr_long"
		size = 56
	strings:
		$1 = { 8C 82 00 00 14 40 00 04 24 06 00 01 8C 82 00 04 10 00 00 05 8C 59 00 04 54 46 00 05 38 42 00 02 8C 82 00 04 8C 59 00 00 03 20 00 08 00 00 00 00 03 E0 00 08 2C 42 00 01 }
	condition:
		$1
}

rule file_157_3_0 {
	meta:
		name = "__GI_xdr_short"
		size = 132
	strings:
		$1 = { 8C 83 00 00 27 BD FF D8 AF B0 00 20 00 A0 80 21 24 05 00 01 AF BF 00 24 50 65 00 0D 8C 82 00 04 50 60 00 04 8C 82 00 04 38 63 00 02 10 00 00 10 2C 63 00 01 86 03 00 00 27 A5 00 18 8C 59 00 04 03 20 F8 09 AF A3 00 18 10 00 00 09 00 40 18 21 8C 59 00 00 03 20 F8 09 27 A5 00 18 10 40 00 04 00 00 18 21 8F A2 00 18 24 03 00 01 A6 02 00 00 8F BF 00 24 8F B0 00 20 00 60 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_157_5_0 {
	meta:
		name = "__GI_xdr_u_long"
		size = 124
	strings:
		$1 = { 8C 83 00 00 27 BD FF D8 24 06 00 01 AF BF 00 24 AF B0 00 20 50 66 00 05 8C 82 00 04 10 60 00 0D 38 63 00 02 10 00 00 10 2C 63 00 01 00 A0 80 21 8C 59 00 00 03 20 F8 09 27 A5 00 18 10 40 00 0A 00 00 18 21 8F A2 00 18 24 03 00 01 10 00 00 06 AE 02 00 00 8C 82 00 04 8C 59 00 04 03 20 F8 09 00 00 00 00 00 40 18 21 8F BF 00 24 8F B0 00 20 00 60 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_157_7_0 {
	meta:
		name = "__GI_xdr_hyper"
		size = 216
		altNames = "__GI_xdr_u_hyper"
	strings:
		$1 = { 27 BD FF D0 AF B1 00 28 AF B0 00 24 AF BF 00 2C 8C 82 00 00 00 80 80 21 14 40 00 13 00 A0 88 21 8C A2 00 04 8C A3 00 00 AF A2 00 18 8C 82 00 04 AF A3 00 1C 8C 59 00 04 03 20 F8 09 27 A5 00 1C 54 40 00 03 8E 02 00 04 10 00 00 1E 00 00 10 21 02 00 20 21 8C 59 00 04 03 20 F8 09 27 A5 00 18 10 00 00 18 00 02 10 2B 24 03 00 01 14 43 00 14 38 42 00 02 8C 82 00 04 8C 59 00 00 03 20 F8 09 27 A5 00 1C 10 40 00 0F 00 00 10 21 8E 02 00 04 02 00 20 21 8C 59 00 00 03 20 F8 09 27 A5 00 18 50 40 00 08 00 00 10 21 8F A2 00 1C AE 22 00 00 8F A2 00 18 AE 22 00 04 10 00 00 02 24 02 00 01 2C 42 00 01 8F BF 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_157_11_0 {
	meta:
		name = "__GI_xdr_u_short"
		size = 132
	strings:
		$1 = { 8C 83 00 00 27 BD FF D8 AF B0 00 20 00 A0 80 21 24 05 00 01 AF BF 00 24 50 65 00 0D 8C 82 00 04 50 60 00 04 8C 82 00 04 38 63 00 02 10 00 00 10 2C 63 00 01 96 03 00 00 27 A5 00 18 8C 59 00 04 03 20 F8 09 AF A3 00 18 10 00 00 09 00 40 18 21 8C 59 00 00 03 20 F8 09 27 A5 00 18 10 40 00 04 00 00 18 21 8F A2 00 18 24 03 00 01 A6 02 00 00 8F BF 00 24 8F B0 00 20 00 60 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_157_12_0 {
	meta:
		name = "xdr_char"
		size = 92
		refs = "0000 _gp_disp 0020 __GI_xdr_long"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B0 00 20 AF BC 00 10 AF BF 00 24 80 A2 00 00 8F 99 ?? ?? 00 A0 80 21 AF A2 00 18 ?? ?? ?? ?? 27 A5 00 18 10 40 00 04 00 00 18 21 8F A2 00 18 24 03 00 01 A2 02 00 00 8F BF 00 24 8F B0 00 20 00 60 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_157_13_0 {
	meta:
		name = "xdr_u_char"
		size = 92
		refs = "0000 _gp_disp 0020 __GI_xdr_u_long"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B0 00 20 AF BC 00 10 AF BF 00 24 90 A2 00 00 8F 99 ?? ?? 00 A0 80 21 AF A2 00 18 ?? ?? ?? ?? 27 A5 00 18 10 40 00 04 00 00 18 21 8F A2 00 18 24 03 00 01 A2 02 00 00 8F BF 00 24 8F B0 00 20 00 60 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_157_14_0 {
	meta:
		name = "__GI_xdr_bool"
		size = 140
	strings:
		$1 = { 8C 83 00 00 27 BD FF D8 AF B0 00 20 00 A0 80 21 24 05 00 01 AF BF 00 24 50 65 00 0E 8C 82 00 04 50 60 00 04 8C 82 00 04 38 63 00 02 10 00 00 12 2C 63 00 01 8E 03 00 00 27 A5 00 18 8C 59 00 04 00 03 18 2B 03 20 F8 09 AF A3 00 18 10 00 00 0A 00 40 18 21 8C 59 00 00 03 20 F8 09 27 A5 00 18 10 40 00 05 00 00 18 21 8F A2 00 18 24 03 00 01 00 02 10 2B AE 02 00 00 8F BF 00 24 8F B0 00 20 00 60 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_157_16_0 {
	meta:
		name = "__GI_xdr_opaque"
		size = 264
		refs = "0000 _gp_disp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 10 C0 00 37 00 00 00 00 27 BD FF D8 30 C2 00 03 AF BC 00 10 AF B1 00 20 AF B0 00 1C AF BF 00 24 00 80 80 21 10 40 00 03 00 00 88 21 24 11 00 04 02 22 88 23 8E 02 00 00 24 03 00 01 50 43 00 05 8E 02 00 04 10 40 00 13 38 42 00 02 10 00 00 26 2C 42 00 01 8C 59 00 08 03 20 F8 09 02 00 20 21 14 40 00 03 8F BC 00 10 10 00 00 1F 00 00 10 21 56 20 00 03 8E 02 00 04 10 00 00 1B 24 02 00 01 8F 85 ?? ?? 02 00 20 21 8C 59 00 08 10 00 00 0E 24 A5 ?? ?? 8E 02 00 04 8C 59 00 0C 03 20 F8 09 02 00 20 21 10 40 FF F0 8F BC 00 10 52 20 00 0E 24 02 00 01 8E 02 00 04 8F 85 ?? ?? 02 00 20 21 8C 59 00 0C 24 A5 ?? ?? 8F BF 00 24 8F B0 00 1C 02 20 30 21 8F B1 00 20 03 20 00 08 27 BD 00 28 03 E0 00 08 24 02 00 01 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_157_17_0 {
	meta:
		name = "__GI_xdr_bytes"
		size = 340
		refs = "0000 _gp_disp 0010 __GI_xdr_u_long 00a4 malloc 00c0 stderr 00c8 __GI_fputs 00c4 $LC0 0100 __GI_xdr_opaque 0114 free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 8F 99 ?? ?? AF BC 00 10 AF B4 00 28 AF B3 00 24 AF B2 00 20 AF B1 00 1C AF BF 00 2C AF B0 00 18 8C B0 00 00 00 A0 90 21 00 C0 28 21 00 80 98 21 00 C0 88 21 ?? ?? ?? ?? 00 E0 A0 21 10 40 00 36 8F BC 00 10 8E 31 00 00 02 91 A0 2B 12 80 00 04 8E 63 00 00 24 04 00 02 14 64 00 32 00 00 10 21 24 02 00 01 10 62 00 07 00 00 00 00 10 60 00 18 24 02 00 02 10 62 00 22 00 00 10 21 10 00 00 2A 8F BF 00 2C 12 20 00 27 24 02 00 01 16 00 00 11 8F BF 00 2C 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 00 40 80 21 8F BC 00 10 14 40 00 09 AE 42 00 00 8F 82 ?? ?? 8F 84 ?? ?? 8F 99 ?? ?? 8C 45 00 00 ?? ?? ?? ?? 24 84 ?? ?? 10 00 00 16 00 00 10 21 8F BF 00 2C 8F B4 00 28 8F B2 00 20 02 60 20 21 02 00 28 21 8F B3 00 24 8F B0 00 18 02 20 30 21 8F 99 ?? ?? 8F B1 00 1C ?? ?? ?? ?? 27 BD 00 30 12 00 00 07 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 10 00 00 03 AE 40 00 00 10 00 00 02 00 00 10 21 24 02 00 01 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_157_19_0 {
	meta:
		name = "__GI_xdr_union"
		size = 212
		refs = "0000 _gp_disp 000c __GI_xdr_long"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D0 AF BC 00 10 AF B4 00 28 AF B3 00 24 AF B2 00 20 AF B1 00 1C AF B0 00 18 AF BF 00 2C 00 80 88 21 00 A0 A0 21 00 C0 98 21 00 E0 80 21 ?? ?? ?? ?? 8F B2 00 40 10 40 00 19 8F BC 00 10 8E 82 00 00 8E 19 00 04 13 20 00 08 00 00 00 00 8E 03 00 00 14 62 FF FB 26 10 00 08 02 20 20 21 02 60 28 21 10 00 00 06 24 06 FF FF 12 40 00 0C 02 20 20 21 02 60 28 21 24 06 FF FF 02 40 C8 21 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 20 00 08 27 BD 00 30 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 00 00 10 21 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_157_20_0 {
	meta:
		name = "__GI_xdr_string"
		size = 364
		refs = "0000 _gp_disp 004c __GI_xdr_u_long 0054 __GI_strlen 00bc free 00e0 malloc 00fc stderr 0104 __GI_fputs 0100 $LC1 0128 __GI_xdr_opaque"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B4 00 30 AF B2 00 28 AF B1 00 24 AF BC 00 10 AF BF 00 34 AF B3 00 2C AF B0 00 20 8C 82 00 00 00 80 88 21 00 A0 90 21 00 C0 A0 21 10 40 00 08 8C B0 00 00 24 03 00 02 14 43 00 0C 8F 99 ?? ?? 16 00 00 05 8F 99 ?? ?? 10 00 00 3C 24 02 00 01 12 00 00 39 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 AF A2 00 18 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 27 A5 00 18 10 40 00 2F 8F BC 00 10 8F B3 00 18 02 93 A0 2B 16 80 00 2B 24 03 00 01 8E 22 00 00 10 43 00 0A 26 64 00 01 10 40 00 1D 24 03 00 02 54 43 00 25 00 00 10 21 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 10 00 00 1D AE 40 00 00 10 80 00 1E 24 02 00 01 56 00 00 11 02 13 98 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 00 40 80 21 8F BC 00 10 14 40 00 09 AE 42 00 00 8F 82 ?? ?? 8F 84 ?? ?? 8F 99 ?? ?? 8C 45 00 00 ?? ?? ?? ?? 24 84 ?? ?? 10 00 00 0D 00 00 10 21 02 13 98 21 A2 60 00 00 8F A6 00 18 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 02 00 28 21 10 00 00 05 8F BF 00 34 10 00 00 02 24 02 00 01 00 00 10 21 8F BF 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_157_21_0 {
	meta:
		name = "xdr_wrapstring"
		size = 52
		refs = "0000 _gp_disp 000c __GI_xdr_string"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 ?? ?? ?? ?? 24 06 FF FF 8F BF 00 1C 00 02 10 2B 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_158_0_0 {
	meta:
		name = "__GI_gethostbyaddr_r"
		size = 740
		refs = "0000 _gp_disp 0070 __get_hosts_byaddr_r 00e4 __GI_memcpy 0128 __GI_sprintf 0124 $LC0 0148 __GI_memset 016c __dns_lookup 0198 __GI_strncpy 01bc free 01e4 __decode_dotted"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 70 AF B5 00 7C 8F B5 00 A8 AF BC 00 20 AF B6 00 80 AF B2 00 70 AF B1 00 6C AF B0 00 68 AF BF 00 8C AF BE 00 88 AF B7 00 84 AF B4 00 78 AF B3 00 74 00 80 B0 21 8F B1 00 A0 8F B2 00 A4 8F B0 00 AC 10 80 00 97 AE A0 00 00 24 02 00 02 14 C2 00 95 24 02 00 16 24 03 00 04 14 A3 00 92 00 A0 A0 21 8F 99 ?? ?? AF B1 00 10 AF B2 00 14 AF B5 00 18 AF B0 00 1C ?? ?? ?? ?? 00 E0 98 21 00 40 18 21 8F BC 00 20 10 60 00 87 00 00 10 21 8E 02 00 00 24 04 00 01 50 44 00 04 24 02 FF FF 54 54 00 81 00 60 10 21 24 02 FF FF AE 02 00 00 00 11 10 23 30 42 00 03 26 54 FF D4 02 22 88 21 02 82 A0 23 26 23 00 28 2A 84 01 00 AF A3 00 54 14 80 00 75 24 02 00 22 8F 99 ?? ?? 26 32 00 2C AE 23 00 20 02 C0 28 21 27 A4 00 54 24 06 00 04 AE 32 00 00 AE 20 00 04 ?? ?? ?? ?? AE 20 00 24 92 C2 00 01 8F BC 00 20 92 C6 00 03 92 C7 00 02 AF A2 00 10 92 C2 00 00 8F 85 ?? ?? 8F 99 ?? ?? 02 40 20 21 24 A5 ?? ?? ?? ?? ?? ?? AF A2 00 14 8F BC 00 20 27 B7 00 28 02 E0 20 21 8F 99 ?? ?? 00 00 28 21 ?? ?? ?? ?? 24 06 00 28 8F BC 00 20 27 B9 00 50 00 00 B0 21 AF B9 00 58 24 1E 00 05 8F 99 ?? ?? 02 40 20 21 24 05 00 0C 27 A6 00 50 ?? ?? ?? ?? 02 E0 38 21 04 41 00 03 8F BC 00 20 10 00 00 45 24 02 00 01 8F A7 00 28 8F 99 ?? ?? 02 40 20 21 00 E0 28 21 02 80 30 21 AF A7 00 5C ?? ?? ?? ?? AF A2 00 60 8F BC 00 20 8F A7 00 5C 8F 99 ?? ?? ?? ?? ?? ?? 00 E0 20 21 8F A2 00 2C 8F BC 00 20 14 5E 00 17 8F A3 00 60 26 D6 00 01 24 02 00 06 12 C2 00 0F 8F 99 ?? ?? 8F A4 00 50 8F A5 00 40 00 60 30 21 02 40 38 21 ?? ?? ?? ?? AF B4 00 10 8F BC 00 20 8F A4 00 50 8F 99 ?? ?? ?? ?? ?? ?? AF A2 00 5C 8F A2 00 5C 04 41 FF D4 8F BC 00 20 24 02 00 03 AE 02 00 00 10 00 00 22 24 02 FF FF 24 05 00 0C 14 45 00 17 8F A4 00 50 8F 99 ?? ?? 8F A5 00 40 00 60 30 21 02 40 38 21 ?? ?? ?? ?? AF B4 00 10 8F BC 00 20 8F 99 ?? ?? ?? ?? ?? ?? 8F A4 00 50 24 02 00 02 AE 62 00 08 24 02 00 04 AE 62 00 0C 26 22 00 20 AE 62 00 10 AE 72 00 00 AE 71 00 04 AE B3 00 00 00 00 10 21 10 00 00 09 AE 00 00 00 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 02 00 04 AE 02 00 00 10 00 00 02 24 02 00 02 24 02 00 16 8F BF 00 8C 8F BE 00 88 8F B7 00 84 8F B6 00 80 8F B5 00 7C 8F B4 00 78 8F B3 00 74 8F B2 00 70 8F B1 00 6C 8F B0 00 68 03 E0 00 08 27 BD 00 90 }
	condition:
		$1
}

rule file_159_0_0 {
	meta:
		name = "getpass"
		size = 604
		refs = "0000 _gp_disp 0020 __GI_fopen 001c $LC0 0010 $LC1 0060 stdin 0064 stderr 0070 __GI_fileno 0090 __GI_tcgetattr 00a4 __GI_memcpy 00e0 __GI_tcsetattr 00fc __GI_setvbuf 0118 __GI_fputs 012c __GI_fflush 0148 __GI_fgets 015c __GI_strlen 01a0 __GI_fputc 01d0 __GI___fputc_unlocked 0224 __GI_fclose"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 60 8F 85 ?? ?? AF B5 00 94 00 80 A8 21 8F 84 ?? ?? 8F 99 ?? ?? AF BC 00 10 AF B3 00 8C AF B1 00 84 AF B0 00 80 AF BF 00 9C AF B6 00 98 AF B4 00 90 AF B2 00 88 24 84 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? 8F BC 00 10 00 40 80 21 00 40 88 21 14 40 00 04 8F 93 ?? ?? 8F 82 ?? ?? 8E 70 00 00 8C 51 00 00 8F 96 ?? ?? 02 00 20 21 02 C0 C8 21 ?? ?? ?? ?? 27 B2 00 18 8F BC 00 10 00 40 20 21 02 40 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 A0 21 14 40 00 1E 8F BC 00 10 8F 99 ?? ?? 02 40 28 21 24 06 00 34 ?? ?? ?? ?? 27 A4 00 4C 8F A3 00 24 24 02 FF F6 02 00 20 21 00 62 10 24 02 C0 C8 21 ?? ?? ?? ?? AF A2 00 24 8F BC 00 10 00 40 20 21 24 05 54 10 8F 99 ?? ?? ?? ?? ?? ?? 02 40 30 21 2C 54 00 01 8E 62 00 00 12 02 00 08 8F BC 00 10 8F 99 ?? ?? 02 00 20 21 00 00 28 21 24 06 00 02 ?? ?? ?? ?? 00 00 38 21 8F BC 00 10 8F 99 ?? ?? 02 A0 20 21 ?? ?? ?? ?? 02 20 28 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 24 05 00 FF 02 00 30 21 8F 92 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 26 44 ?? ?? 8F BC 00 10 26 44 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 26 55 ?? ?? 04 41 00 03 8F BC 00 10 10 00 00 1E A2 40 ?? ?? 24 42 FF FF 02 A2 10 21 80 44 00 00 24 03 00 0A 14 83 00 18 00 00 00 00 12 80 00 22 A0 40 00 00 8E 22 00 34 10 40 00 0D 8F 99 ?? ?? 8E 23 00 10 8E 22 00 1C 00 62 10 2B 10 40 00 04 24 62 00 01 AE 22 00 10 10 00 00 0D A0 64 00 00 24 04 00 0A 02 20 28 21 10 00 00 03 8F 99 ?? ?? 24 04 00 0A 02 20 28 21 03 20 F8 09 00 00 00 00 10 00 00 04 02 C0 C8 21 52 80 00 0C 8E 62 00 00 02 C0 C8 21 ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 00 40 20 21 24 05 54 10 8F 99 ?? ?? ?? ?? ?? ?? 27 A6 00 4C 8F BC 00 10 8E 62 00 00 12 02 00 03 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F BF 00 9C 02 A0 10 21 8F B6 00 98 8F B5 00 94 8F B4 00 90 8F B3 00 8C 8F B2 00 88 8F B1 00 84 8F B0 00 80 03 E0 00 08 27 BD 00 A0 }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "__GI_iswctype"
		size = 84
		refs = "0000 _gp_disp 0024 __GI___ctype_b"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 2C 83 00 80 10 60 00 0E 00 00 10 21 2C A3 00 0D 10 60 00 0B 00 04 20 40 8F 82 ?? ?? 00 05 28 40 8C 42 00 00 00 44 20 21 8F 82 ?? ?? 94 83 00 00 24 42 ?? ?? 00 A2 28 21 94 A2 00 00 00 62 10 24 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "__GI_glob64"
		size = 704
		refs = "0000 _gp_disp 0078 $LC1 0098 $LC0 00a8 __glob_ignore_err 00d0 __glob_match_in_dir 00fc __glob_freelist 014c __GI_strlen 0168 __glob_append 018c malloc 0194 realloc 0270 __glob_sort 0274 __GI_qsort"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A8 30 A3 00 08 AF B6 00 48 AF BC 00 18 27 B6 00 20 AF B4 00 40 AF B3 00 3C AF B1 00 34 AF B0 00 30 AF BF 00 54 AF BE 00 50 AF B7 00 4C AF B5 00 44 AF B2 00 38 00 80 A0 21 00 A0 98 21 00 C0 10 21 00 E0 80 21 AF A0 00 20 AF A0 00 24 AF B6 00 28 10 60 00 02 00 00 88 21 8C F1 00 08 82 84 00 00 24 03 00 2F 10 83 00 04 8F 84 ?? ?? 02 80 18 21 10 00 00 09 24 84 ?? ?? 02 80 18 21 24 04 00 2F 80 65 00 00 54 A4 00 03 8F 84 ?? ?? 10 00 FF FC 24 63 00 01 24 84 ?? ?? 8F 85 ?? ?? 32 77 00 20 16 E0 00 04 00 A2 10 0A AE 11 00 08 AE 00 00 00 AE 00 00 04 80 65 00 00 10 A0 00 12 00 00 A8 21 8F 99 ?? ?? 27 A5 00 28 AF A5 00 10 02 60 30 21 00 60 28 21 ?? ?? ?? ?? 00 40 38 21 00 40 A8 21 24 02 00 01 16 A2 00 07 8F BC 00 18 8F 99 ?? ?? 02 C0 20 21 ?? ?? ?? ?? 24 1E 00 01 10 00 00 60 8F BF 00 54 8F A2 00 20 00 00 90 21 AF A2 00 28 8F A2 00 28 10 40 00 05 00 00 00 00 8C 42 00 00 26 52 00 01 10 00 FF FA AF A2 00 28 16 40 00 12 32 62 00 10 10 40 00 51 24 1E 00 03 8F 99 ?? ?? 02 80 20 21 ?? ?? ?? ?? AF B6 00 28 8F BC 00 18 27 A4 00 28 02 80 28 21 8F 99 ?? ?? 00 40 30 21 ?? ?? ?? ?? 00 00 38 21 24 1E 00 01 14 40 00 43 8F BC 00 18 24 12 00 01 12 E0 00 0F 8F 99 ?? ?? 8E 05 00 00 8F 99 ?? ?? 8E 04 00 04 24 A5 00 01 00 B1 28 21 00 B2 28 21 ?? ?? ?? ?? 00 05 28 80 10 40 FF D2 8F BC 00 18 AE 02 00 04 8E 02 00 00 10 00 00 12 02 22 88 21 26 24 00 01 00 92 20 21 ?? ?? ?? ?? 00 04 20 80 AE 02 00 04 10 40 FF C7 8F BC 00 18 00 00 10 21 00 51 18 2B 50 60 00 08 8F A2 00 20 8E 04 00 04 00 02 18 80 24 42 00 01 00 83 18 21 10 00 FF F8 AC 60 00 00 8F A2 00 20 AF A2 00 28 00 00 10 21 8E 03 00 04 00 51 20 21 00 04 20 80 00 52 28 2B 10 A0 00 09 00 64 18 21 8F A4 00 28 24 42 00 01 24 84 00 04 AC 64 00 00 8F A3 00 28 8C 63 00 00 10 00 FF F3 AF A3 00 28 AC 60 00 00 8E 02 00 00 32 73 00 04 02 A0 F0 21 00 52 10 21 16 60 00 09 AE 02 00 00 8E 04 00 04 8F 87 ?? ?? 8F 99 ?? ?? 00 11 88 80 00 91 20 21 02 40 28 21 ?? ?? ?? ?? 24 06 00 04 8F BF 00 54 03 C0 10 21 8F B7 00 4C 8F BE 00 50 8F B6 00 48 8F B5 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 58 }
	condition:
		$1
}

rule file_822_6_0 {
	meta:
		name = "__GI_glob"
		size = 704
		refs = "0000 _gp_disp 0078 $LC2 0098 $LC0 00a8 __glob_ignore_err 00d0 __glob_match_in_dir 00fc __glob_freelist 014c __GI_strlen 0168 __glob_append 018c malloc 0194 realloc 0270 __glob_sort 0274 __GI_qsort"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A8 30 A3 00 08 AF B6 00 48 AF BC 00 18 27 B6 00 20 AF B4 00 40 AF B3 00 3C AF B1 00 34 AF B0 00 30 AF BF 00 54 AF BE 00 50 AF B7 00 4C AF B5 00 44 AF B2 00 38 00 80 A0 21 00 A0 98 21 00 C0 10 21 00 E0 80 21 AF A0 00 20 AF A0 00 24 AF B6 00 28 10 60 00 02 00 00 88 21 8C F1 00 08 82 84 00 00 24 03 00 2F 10 83 00 04 8F 84 ?? ?? 02 80 18 21 10 00 00 09 24 84 ?? ?? 02 80 18 21 24 04 00 2F 80 65 00 00 54 A4 00 03 8F 84 ?? ?? 10 00 FF FC 24 63 00 01 24 84 ?? ?? 8F 85 ?? ?? 32 77 00 20 16 E0 00 04 00 A2 10 0A AE 11 00 08 AE 00 00 00 AE 00 00 04 80 65 00 00 10 A0 00 12 00 00 A8 21 8F 99 ?? ?? 27 A5 00 28 AF A5 00 10 02 60 30 21 00 60 28 21 ?? ?? ?? ?? 00 40 38 21 00 40 A8 21 24 02 00 01 16 A2 00 07 8F BC 00 18 8F 99 ?? ?? 02 C0 20 21 ?? ?? ?? ?? 24 1E 00 01 10 00 00 60 8F BF 00 54 8F A2 00 20 00 00 90 21 AF A2 00 28 8F A2 00 28 10 40 00 05 00 00 00 00 8C 42 00 00 26 52 00 01 10 00 FF FA AF A2 00 28 16 40 00 12 32 62 00 10 10 40 00 51 24 1E 00 03 8F 99 ?? ?? 02 80 20 21 ?? ?? ?? ?? AF B6 00 28 8F BC 00 18 27 A4 00 28 02 80 28 21 8F 99 ?? ?? 00 40 30 21 ?? ?? ?? ?? 00 00 38 21 24 1E 00 01 14 40 00 43 8F BC 00 18 24 12 00 01 12 E0 00 0F 8F 99 ?? ?? 8E 05 00 00 8F 99 ?? ?? 8E 04 00 04 24 A5 00 01 00 B1 28 21 00 B2 28 21 ?? ?? ?? ?? 00 05 28 80 10 40 FF D2 8F BC 00 18 AE 02 00 04 8E 02 00 00 10 00 00 12 02 22 88 21 26 24 00 01 00 92 20 21 ?? ?? ?? ?? 00 04 20 80 AE 02 00 04 10 40 FF C7 8F BC 00 18 00 00 10 21 00 51 18 2B 50 60 00 08 8F A2 00 20 8E 04 00 04 00 02 18 80 24 42 00 01 00 83 18 21 10 00 FF F8 AC 60 00 00 8F A2 00 20 AF A2 00 28 00 00 10 21 8E 03 00 04 00 51 20 21 00 04 20 80 00 52 28 2B 10 A0 00 09 00 64 18 21 8F A4 00 28 24 42 00 01 24 84 00 04 AC 64 00 00 8F A3 00 28 8C 63 00 00 10 00 FF F3 AF A3 00 28 AC 60 00 00 8E 02 00 00 32 73 00 04 02 A0 F0 21 00 52 10 21 16 60 00 09 AE 02 00 00 8E 04 00 04 8F 87 ?? ?? 8F 99 ?? ?? 00 11 88 80 00 91 20 21 02 40 28 21 ?? ?? ?? ?? 24 06 00 04 8F BF 00 54 03 C0 10 21 8F B7 00 4C 8F BE 00 50 8F B6 00 48 8F B5 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 58 }
	condition:
		$1
}

rule file_162_1_0 {
	meta:
		name = "__GI_globfree64"
		size = 136
		refs = "0000 _gp_disp 0038 free"
		altNames = "__GI_globfree"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B1 00 20 AF B0 00 1C AF BC 00 10 AF BF 00 24 00 80 80 21 00 00 88 21 8E 02 00 00 8E 04 00 04 02 22 10 2B 10 40 00 0B 8F 99 ?? ?? 8E 02 00 08 02 22 10 21 00 02 10 80 00 82 20 21 8C 84 00 00 26 31 00 01 ?? ?? ?? ?? 24 84 FF FC 10 00 FF F2 8F BC 00 10 ?? ?? ?? ?? 00 00 00 00 8F BF 00 24 8F B1 00 20 AE 00 00 00 AE 00 00 04 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_163_0_0 {
	meta:
		name = "putwchar_unlocked"
		size = 28
		refs = "0000 _gp_disp 000c stdout 0010 __GI_fputwc_unlocked"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 8C 45 00 00 }
	condition:
		$1
}

rule file_85_0_3 {
	meta:
		name = "_ZN10__cxxabiv116__enum_type_infoD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVN10__cxxabiv116__enum_type_infoE 0010 _ZNSt9type_infoD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_129_0_3 {
	meta:
		name = "_ZN10__cxxabiv117__array_type_infoD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVN10__cxxabiv117__array_type_infoE 0010 _ZNSt9type_infoD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_126_2_3 {
	meta:
		name = "_ZN10__cxxabiv117__class_type_infoD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVN10__cxxabiv117__class_type_infoE 0010 _ZNSt9type_infoD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_87_1_3 {
	meta:
		name = "_ZN10__cxxabiv117__pbase_type_infoD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVN10__cxxabiv117__pbase_type_infoE 0010 _ZNSt9type_infoD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_36_1_3 {
	meta:
		name = "_ZN10__cxxabiv119__pointer_type_infoD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVN10__cxxabiv119__pointer_type_infoE 0010 _ZN10__cxxabiv117__pbase_type_infoD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_27_1_3 {
	meta:
		name = "_ZN10__cxxabiv120__function_type_infoD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVN10__cxxabiv120__function_type_infoE 0010 _ZNSt9type_infoD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_84_0_3 {
	meta:
		name = "_ZN10__cxxabiv120__si_class_type_infoD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVN10__cxxabiv120__si_class_type_infoE 0010 _ZN10__cxxabiv117__class_type_infoD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_43_0_3 {
	meta:
		name = "_ZN10__cxxabiv121__vmi_class_type_infoD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVN10__cxxabiv121__vmi_class_type_infoE 0010 _ZN10__cxxabiv117__class_type_infoD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_112_0_3 {
	meta:
		name = "_ZN10__cxxabiv123__fundamental_type_infoD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVN10__cxxabiv123__fundamental_type_infoE 0010 _ZNSt9type_infoD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_7_0_3 {
	meta:
		name = "_ZN10__cxxabiv129__pointer_to_member_type_infoD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVN10__cxxabiv129__pointer_to_member_type_infoE 0010 _ZN10__cxxabiv117__pbase_type_infoD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_125_2_3 {
	meta:
		name = "_ZN12_GLOBAL__N_121future_error_categoryD2Ev"
		size = 32
		refs = "0000 _gp_disp 0010 _ZNSt14error_categoryD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 ?? ?? ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_76_6_3 {
	meta:
		name = "_ZN12_GLOBAL__N_121system_error_categoryD2Ev"
		size = 32
		refs = "0000 _gp_disp 0010 _ZNSt14error_categoryD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 ?? ?? ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_76_7_3 {
	meta:
		name = "_ZN12_GLOBAL__N_122generic_error_categoryD2Ev"
		size = 32
		refs = "0000 _gp_disp 0010 _ZNSt14error_categoryD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 ?? ?? ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_28_0_3 {
	meta:
		name = "_ZN9__gnu_cxx20recursive_init_errorD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVN9__gnu_cxx20recursive_init_errorE 0010 _ZNSt9exceptionD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_59_3_3 {
	meta:
		name = "_ZN9__gnu_cxx24__concurrence_lock_errorD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVN9__gnu_cxx24__concurrence_lock_errorE 0010 _ZNSt9exceptionD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_59_2_3 {
	meta:
		name = "_ZN9__gnu_cxx26__concurrence_unlock_errorD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVN9__gnu_cxx26__concurrence_unlock_errorE 0010 _ZNSt9exceptionD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_51_1_3 {
	meta:
		name = "_ZNSt10bad_typeidD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt10bad_typeid 0010 _ZNSt9exceptionD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_100_14_3 {
	meta:
		name = "_ZNSt11range_errorD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt11range_error 0010 _ZNSt13runtime_errorD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_108_0_3 {
	meta:
		name = "_ZNSt11regex_errorD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt11regex_error 0010 _ZNSt13runtime_errorD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_80_1_3 {
	meta:
		name = "_ZNSt12bad_weak_ptrD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt12bad_weak_ptr 0010 _ZNSt9exceptionD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_48_4_3 {
	meta:
		name = "_ZNSt12ctype_bynameIcED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt12ctype_bynameIcE 0010 _ZNSt5ctypeIcED2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_101_5_3 {
	meta:
		name = "_ZNSt12ctype_bynameIwED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt12ctype_bynameIwE 0010 _ZNSt5ctypeIwED2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_100_4_3 {
	meta:
		name = "_ZNSt12domain_errorD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt12domain_error 0010 _ZNSt11logic_errorD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_125_4_3 {
	meta:
		name = "_ZNSt12future_errorD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt12future_error 0010 _ZNSt11logic_errorD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_100_8_3 {
	meta:
		name = "_ZNSt12length_errorD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt12length_error 0010 _ZNSt11logic_errorD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_100_10_3 {
	meta:
		name = "_ZNSt12out_of_rangeD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt12out_of_range 0010 _ZNSt11logic_errorD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_76_11_3 {
	meta:
		name = "_ZNSt12system_errorD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt12system_error 0010 _ZNSt13runtime_errorD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_33_1_3 {
	meta:
		name = "_ZNSt13bad_exceptionD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt13bad_exception 0010 _ZNSt9exceptionD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_57_68_3 {
	meta:
		name = "_ZNSt14codecvt_bynameIcc11__mbstate_tED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt14codecvt_bynameIcc11__mbstate_tE 0010 _ZNSt7codecvtIcc11__mbstate_tED2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_20_68_3 {
	meta:
		name = "_ZNSt14codecvt_bynameIwc11__mbstate_tED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt14codecvt_bynameIwc11__mbstate_tE 0010 _ZNSt7codecvtIwc11__mbstate_tED2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_100_16_3 {
	meta:
		name = "_ZNSt14overflow_errorD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt14overflow_error 0010 _ZNSt13runtime_errorD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_57_57_3 {
	meta:
		name = "_ZNSt15messages_bynameIcED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt15messages_bynameIcE 0010 _ZNSt8messagesIcED2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_20_57_3 {
	meta:
		name = "_ZNSt15messages_bynameIwED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt15messages_bynameIwE 0010 _ZNSt8messagesIwED2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_57_64_3 {
	meta:
		name = "_ZNSt15numpunct_bynameIcED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt15numpunct_bynameIcE 0010 _ZNSt8numpunctIcED2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_20_64_3 {
	meta:
		name = "_ZNSt15numpunct_bynameIwED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt15numpunct_bynameIwE 0010 _ZNSt8numpunctIwED2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_57_24_3 {
	meta:
		name = "_ZNSt15time_get_bynameIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_20_24_3 {
	meta:
		name = "_ZNSt15time_get_bynameIwSt19istreambuf_iteratorIwSt11char_traitsIwEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_57_22_3 {
	meta:
		name = "_ZNSt15time_put_bynameIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_20_22_3 {
	meta:
		name = "_ZNSt15time_put_bynameIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_100_18_3 {
	meta:
		name = "_ZNSt15underflow_errorD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt15underflow_error 0010 _ZNSt13runtime_errorD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_100_6_3 {
	meta:
		name = "_ZNSt16invalid_argumentD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt16invalid_argument 0010 _ZNSt11logic_errorD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_57_20_3 {
	meta:
		name = "_ZNSt17__timepunct_cacheIcED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt17__timepunct_cacheIcE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_20_20_3 {
	meta:
		name = "_ZNSt17__timepunct_cacheIwED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt17__timepunct_cacheIwE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_68_1_3 {
	meta:
		name = "_ZNSt17bad_function_callD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt17bad_function_call 0010 _ZNSt9exceptionD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_57_60_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIcLb0EED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt17moneypunct_bynameIcLb0EE 0010 _ZNSt10moneypunctIcLb0EED2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_57_62_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIcLb1EED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt17moneypunct_bynameIcLb1EE 0010 _ZNSt10moneypunctIcLb1EED2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_20_60_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIwLb0EED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt17moneypunct_bynameIwLb0EE 0010 _ZNSt10moneypunctIwLb0EED2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_20_62_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIwLb1EED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt17moneypunct_bynameIwLb1EE 0010 _ZNSt10moneypunctIwLb1EED2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_57_25_3 {
	meta:
		name = "_ZNSt21__ctype_abstract_baseIcED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt21__ctype_abstract_baseIcE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_20_26_3 {
	meta:
		name = "_ZNSt21__ctype_abstract_baseIwED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt21__ctype_abstract_baseIwE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_57_26_3 {
	meta:
		name = "_ZNSt23__codecvt_abstract_baseIcc11__mbstate_tED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt23__codecvt_abstract_baseIcc11__mbstate_tE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_20_25_3 {
	meta:
		name = "_ZNSt23__codecvt_abstract_baseIwc11__mbstate_tED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt23__codecvt_abstract_baseIwc11__mbstate_tE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_57_18_3 {
	meta:
		name = "_ZNSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_20_18_3 {
	meta:
		name = "_ZNSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_57_19_3 {
	meta:
		name = "_ZNSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_20_19_3 {
	meta:
		name = "_ZNSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_14_1_3 {
	meta:
		name = "_ZNSt8bad_castD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt8bad_cast 0010 _ZNSt9exceptionD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_57_23_3 {
	meta:
		name = "_ZNSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_20_23_3 {
	meta:
		name = "_ZNSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_57_21_3 {
	meta:
		name = "_ZNSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_20_21_3 {
	meta:
		name = "_ZNSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_78_1_3 {
	meta:
		name = "_ZNSt9bad_allocD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt9bad_alloc 0010 _ZNSt9exceptionD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_25_0_3 {
	meta:
		name = "_ZNSt9basic_iosIcSt11char_traitsIcEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt9basic_iosIcSt11char_traitsIcEE 0010 _ZNSt8ios_baseD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_25_1_3 {
	meta:
		name = "_ZNSt9basic_iosIwSt11char_traitsIwEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt9basic_iosIwSt11char_traitsIwEE 0010 _ZNSt8ios_baseD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_57_16_3 {
	meta:
		name = "_ZNSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_20_16_3 {
	meta:
		name = "_ZNSt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_57_17_3 {
	meta:
		name = "_ZNSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_20_17_3 {
	meta:
		name = "_ZNSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 24 42 00 08 ?? ?? ?? ?? AC 82 00 00 }
	condition:
		$1
}

rule file_164_0_0 {
	meta:
		name = "__GI_poll"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 5C 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_165_0_0 {
	meta:
		name = "__libc_fork"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F A2 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_166_0_0 {
	meta:
		name = "__getdents"
		size = 232
		refs = "0000 _gp_disp 0044 __GI___errno_location 0064 __GI_strlen 0068 __GI_memmove"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF BC 00 10 AF BF 00 34 AF B6 00 30 AF B5 00 2C AF B4 00 28 AF B3 00 24 AF B2 00 20 AF B1 00 1C AF B0 00 18 24 02 10 2D 00 00 00 0C 10 E0 00 07 00 40 88 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 51 00 00 10 00 00 19 24 11 FF FF 24 02 FF FF 12 22 00 16 8F 94 ?? ?? 8F 93 ?? ?? 00 A0 80 21 00 B1 A8 21 02 15 10 2B 10 40 00 10 26 12 00 0A 96 02 00 08 02 40 20 21 02 02 10 21 02 80 C8 21 ?? ?? ?? ?? 80 56 FF FF 24 46 00 01 26 04 00 0B 02 60 C8 21 ?? ?? ?? ?? 02 40 28 21 96 02 00 08 A2 16 00 0A 10 00 FF EF 02 02 80 21 8F BF 00 34 02 20 10 21 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_167_0_0 {
	meta:
		name = "__GI_posix_openpt"
		size = 32
		refs = "0000 _gp_disp 0014 __GI_open 0010 $LC0"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 00 80 28 21 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 84 ?? ?? }
	condition:
		$1
}

rule file_168_0_0 {
	meta:
		name = "__GI_sigwaitinfo"
		size = 92
		refs = "0000 _gp_disp 0034 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 00 00 30 21 24 07 00 10 24 02 10 65 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_168_1_0 {
	meta:
		name = "__GI_sigtimedwait"
		size = 88
		refs = "0000 _gp_disp 0030 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 07 00 10 24 02 10 65 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_169_0_0 {
	meta:
		name = "__GI_setregid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F E7 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_170_0_0 {
	meta:
		name = "__GI_xdr_pmaplist"
		size = 248
		refs = "0000 _gp_disp 0038 __GI_xdr_bool 003c __GI_xdr_reference 008c __GI_xdr_pmap"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF B6 00 38 AF B5 00 34 AF B4 00 30 AF B2 00 28 AF B1 00 24 AF B0 00 20 AF BC 00 10 AF BF 00 3C AF B3 00 2C 8C 93 00 00 8F 95 ?? ?? 8F 96 ?? ?? 3A 73 00 02 00 80 88 21 00 A0 80 21 2E 73 00 01 00 00 90 21 27 B4 00 18 8E 02 00 00 02 20 20 21 02 80 28 21 00 02 10 2B 02 A0 C8 21 ?? ?? ?? ?? AF A2 00 18 10 40 00 15 8F BC 00 10 8F A2 00 18 10 40 00 13 24 02 00 01 12 60 00 03 8F 87 ?? ?? 8E 12 00 00 26 52 00 10 02 20 20 21 02 00 28 21 02 C0 C8 21 ?? ?? ?? ?? 24 06 00 14 10 40 00 08 00 00 10 21 52 60 00 03 8E 10 00 00 10 00 FF E6 02 40 80 21 10 00 FF E4 26 10 00 10 00 00 10 21 8F BF 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_171_0_0 {
	meta:
		name = "__GI_vasprintf"
		size = 212
		refs = "0000 _gp_disp 0014 __GI_vsnprintf 0064 malloc 00a0 free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 AF B2 00 20 8F 92 ?? ?? AF B4 00 28 AF B3 00 24 00 A0 A0 21 00 C0 98 21 AF BC 00 10 AF B1 00 1C AF B0 00 18 00 80 88 21 AF BF 00 2C 00 00 20 21 00 00 28 21 02 80 30 21 02 40 C8 21 ?? ?? ?? ?? 02 60 38 21 00 40 80 21 8F BC 00 10 04 40 00 14 AE 20 00 00 8F 99 ?? ?? 24 50 00 01 ?? ?? ?? ?? 02 00 20 21 10 40 00 0E AE 22 00 00 02 00 28 21 00 40 20 21 02 80 30 21 02 40 C8 21 ?? ?? ?? ?? 02 60 38 21 00 40 80 21 04 41 00 05 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 8E 24 00 00 AE 20 00 00 8F BF 00 2C 02 00 10 21 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "__GI_fgets"
		size = 192
		refs = "0000 _gp_disp 0040 _pthread_cleanup_push_defer 0044 __pthread_mutex_unlock 005c __pthread_mutex_lock 006c __GI_fgets_unlocked 0088 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B4 00 40 AF B3 00 3C AF B0 00 30 AF BC 00 10 AF BF 00 44 AF B2 00 38 AF B1 00 34 8C D1 00 34 00 80 A0 21 00 A0 98 21 16 20 00 0C 00 C0 80 21 8F 99 ?? ?? 8F 85 ?? ?? 24 D2 00 38 27 A4 00 18 ?? ?? ?? ?? 02 40 30 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 8F 99 ?? ?? 02 80 20 21 02 60 28 21 ?? ?? ?? ?? 02 00 30 21 16 20 00 07 8F BC 00 10 8F 99 ?? ?? AF A2 00 28 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F A2 00 28 8F BF 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_453_0_0 {
	meta:
		name = "fgetws"
		size = 192
		refs = "0000 _gp_disp 0040 _pthread_cleanup_push_defer 0044 __pthread_mutex_unlock 005c __pthread_mutex_lock 006c __GI_fgetws_unlocked 0088 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B4 00 40 AF B3 00 3C AF B0 00 30 AF BC 00 10 AF BF 00 44 AF B2 00 38 AF B1 00 34 8C D1 00 34 00 80 A0 21 00 A0 98 21 16 20 00 0C 00 C0 80 21 8F 99 ?? ?? 8F 85 ?? ?? 24 D2 00 38 27 A4 00 18 ?? ?? ?? ?? 02 40 30 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 8F 99 ?? ?? 02 80 20 21 02 60 28 21 ?? ?? ?? ?? 02 00 30 21 16 20 00 07 8F BC 00 10 8F 99 ?? ?? AF A2 00 28 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F A2 00 28 8F BF 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_173_0_0 {
	meta:
		name = "__GI_mallinfo"
		size = 460
		refs = "0000 _gp_disp 0010 _pthread_cleanup_push_defer 0014 __pthread_mutex_unlock 0018 __malloc_lock 0060 __pthread_mutex_lock 0070 __malloc_state 0080 __malloc_consolidate 013c _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A8 8F 99 ?? ?? 8F 85 ?? ?? 8F 86 ?? ?? AF B4 00 40 27 B4 00 18 AF BC 00 10 AF BF 00 54 AF B1 00 34 AF B0 00 30 AF BE 00 50 AF B7 00 4C AF B6 00 48 AF B5 00 44 AF B3 00 3C AF B2 00 38 00 80 80 21 ?? ?? ?? ?? 02 80 20 21 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 91 ?? ?? 8E 22 00 2C 14 40 00 07 24 12 FF FC 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8E 22 00 2C 24 12 FF FC 00 00 A8 21 8C 57 00 04 00 00 98 21 00 00 10 21 02 F2 90 24 24 05 FF FC 24 04 00 0A 00 02 18 80 02 23 18 21 8C 63 00 04 50 60 00 07 24 42 00 01 8C 66 00 04 26 B5 00 01 8C 63 00 08 00 A6 30 24 10 00 FF F9 02 66 98 21 14 44 FF F5 00 02 18 80 02 72 90 21 24 16 00 01 24 02 00 01 24 06 FF FC 24 05 00 60 00 02 20 C0 02 24 20 21 24 84 00 2C 8C 83 00 0C 50 64 00 07 24 42 00 01 8C 67 00 04 26 D6 00 01 8C 63 00 0C 00 C7 38 24 10 00 FF F9 02 47 90 21 14 45 FF F4 00 02 20 C0 8E 23 03 50 8E 22 03 64 8F 99 ?? ?? 8E 3E 03 68 02 80 20 21 8E 31 03 74 24 05 00 01 AF A2 00 2C ?? ?? ?? ?? AF A3 00 28 8F A2 00 2C 8F A3 00 28 8F BF 00 54 AE 02 00 10 24 02 FF FC AE 1E 00 00 02 E2 B8 24 03 D2 F0 23 AE 16 00 04 AE 15 00 08 AE 11 00 14 AE 13 00 18 AE 1E 00 1C AE 12 00 20 AE 17 00 24 02 00 10 21 8F BE 00 50 8F B7 00 4C 8F B6 00 48 8F B5 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 AE 03 00 0C 8F B0 00 30 03 E0 00 08 27 BD 00 58 }
	condition:
		$1
}

rule file_173_1_0 {
	meta:
		name = "malloc_stats"
		size = 160
		refs = "0000 _gp_disp 0024 stderr 002c __GI_mallinfo 0060 __GI_fprintf 005c $LC0"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 98 AF BC 00 30 AF B0 00 60 AF BF 00 64 14 80 00 03 00 80 80 21 8F 82 ?? ?? 8C 50 00 00 8F 99 ?? ?? ?? ?? ?? ?? 27 A4 00 38 8F A3 00 44 8F BC 00 30 8F A2 00 48 AF A3 00 14 8F A3 00 4C 8F A6 00 38 8F A7 00 54 AF A3 00 20 8F A3 00 58 8F 85 ?? ?? 8F 99 ?? ?? AF A3 00 24 8F A3 00 5C AF A6 00 10 AF A7 00 1C AF A3 00 28 02 00 20 21 AF A2 00 18 24 A5 ?? ?? 00 C2 30 21 ?? ?? ?? ?? 00 E2 38 21 8F BF 00 64 8F B0 00 60 03 E0 00 08 27 BD 00 68 }
	condition:
		$1
}

rule file_174_0_0 {
	meta:
		name = "__GI_fchdir"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 25 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_175_0_0 {
	meta:
		name = "fwide"
		size = 212
		refs = "0000 _gp_disp 0038 _pthread_cleanup_push_defer 003c __pthread_mutex_unlock 0054 __pthread_mutex_lock 00a4 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF B2 00 34 AF B0 00 2C AF BC 00 10 AF BF 00 3C AF B3 00 38 AF B1 00 30 8C 91 00 34 00 80 80 21 16 20 00 0C 00 A0 90 21 8F 99 ?? ?? 8F 85 ?? ?? 24 93 00 38 02 60 30 21 ?? ?? ?? ?? 27 A4 00 18 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 8F BC 00 10 12 40 00 0B 96 03 00 00 30 62 08 80 54 40 00 09 30 70 08 00 24 02 08 00 2A 52 00 01 24 04 00 80 00 92 10 0B 00 43 10 25 A6 02 00 00 96 03 00 00 30 70 08 00 30 63 00 80 16 20 00 05 02 03 80 23 8F 99 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F BF 00 3C 02 00 10 21 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_176_0_0 {
	meta:
		name = "sethostid"
		size = 220
		refs = "0000 _gp_disp 000c __GI_geteuid 0038 __GI___errno_location 0050 __GI_getuid 0068 __GI_open 0064 $LC0 0088 __GI_write 00a8 __GI_close"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BC 00 10 AF BF 00 24 AF B1 00 20 AF B0 00 1C AF A4 00 28 ?? ?? ?? ?? 00 00 00 00 10 40 00 07 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 24 11 00 01 24 03 00 01 10 00 00 1E AC 43 00 00 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 14 40 FF F6 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? 24 05 01 01 24 84 ?? ?? ?? ?? ?? ?? 24 06 01 A4 00 40 80 21 04 40 00 0F 8F BC 00 10 8F 99 ?? ?? 00 40 20 21 27 A5 00 28 ?? ?? ?? ?? 24 06 00 04 8F BC 00 10 38 42 00 04 00 02 88 2B 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 00 11 88 23 10 00 00 03 8F BF 00 24 00 40 88 21 8F BF 00 24 02 20 10 21 8F B0 00 1C 8F B1 00 20 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_177_0_0 {
	meta:
		name = "__GI_execle"
		size = 188
		refs = "0000 _gp_disp 009c __GI_execve"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF BE 00 20 03 A0 F0 21 AF C7 00 34 27 C7 00 30 AF BF 00 24 AF BC 00 10 AF C6 00 30 AF C7 00 18 00 00 18 21 8F C6 00 18 24 C8 00 04 AF C8 00 18 8C C8 00 00 11 00 00 03 24 62 00 01 10 00 FF F9 00 40 18 21 00 03 18 80 24 63 00 16 00 03 18 C2 00 03 18 C0 03 A3 E8 23 27 A3 00 10 8C C6 00 04 AF C7 00 18 AC 65 00 00 00 60 28 21 8F C7 00 18 24 A5 00 04 24 42 FF FF 24 E8 00 04 8C E7 00 00 AF C8 00 18 14 40 FF F9 AC A7 00 00 8F 99 ?? ?? ?? ?? ?? ?? 00 60 28 21 03 C0 E8 21 8F BF 00 24 8F BE 00 20 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_178_0_0 {
	meta:
		name = "__encode_header"
		size = 212
	strings:
		$1 = { 28 C6 00 0C 14 C0 00 31 24 06 FF 80 90 82 00 02 24 03 00 04 A0 A2 00 00 8C 82 00 00 A0 A2 00 01 8C 88 00 04 00 C0 10 21 8C 87 00 10 00 08 10 0A 00 40 40 21 8C 82 00 0C 8C 89 00 08 00 02 18 0A 24 02 00 02 00 07 10 0A 8C 87 00 14 31 29 00 0F 00 09 48 C0 00 07 38 2B 01 27 38 25 01 07 38 25 00 67 18 25 00 43 10 25 A0 A2 00 02 8C 82 00 18 00 02 30 0A 8C 82 00 1C 30 42 00 0F 00 C2 30 25 A0 A6 00 03 90 82 00 22 A0 A2 00 04 8C 82 00 20 A0 A2 00 05 90 82 00 26 A0 A2 00 06 8C 82 00 24 A0 A2 00 07 90 82 00 2A A0 A2 00 08 8C 82 00 28 A0 A2 00 09 90 82 00 2E A0 A2 00 0A 8C 82 00 2C A0 A2 00 0B 03 E0 00 08 24 02 00 0C 03 E0 00 08 24 02 FF FF }
	condition:
		$1
}

rule file_179_0_0 {
	meta:
		name = "posix_fadvise64"
		size = 76
	strings:
		$1 = { 27 BD FF F8 00 00 28 21 AF B1 00 04 AF B0 00 00 8F A2 00 1C 8F B0 00 18 8F B1 00 20 27 BD FF E0 AF B0 00 10 AF A2 00 14 AF B1 00 18 24 02 10 9E 00 00 00 0C 27 BD 00 20 8F B1 00 04 8F B0 00 00 00 07 10 0A 03 E0 00 08 27 BD 00 08 }
	condition:
		$1
}

rule file_180_0_0 {
	meta:
		name = "klogctl"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 07 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_181_0_0 {
	meta:
		name = "__GI___sigismember"
		size = 40
	strings:
		$1 = { 24 A5 FF FF 00 05 11 42 00 02 10 80 00 82 20 21 8C 83 00 00 24 02 00 01 00 A2 28 04 00 A3 10 24 03 E0 00 08 00 02 10 2B }
	condition:
		$1
}

rule file_181_1_0 {
	meta:
		name = "__GI___sigaddset"
		size = 44
	strings:
		$1 = { 24 A5 FF FF 00 05 11 42 00 02 10 80 00 82 20 21 24 02 00 01 00 A2 28 04 8C 82 00 00 00 45 28 25 AC 85 00 00 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_181_2_0 {
	meta:
		name = "__GI___sigdelset"
		size = 48
	strings:
		$1 = { 24 A5 FF FF 00 05 11 42 00 02 10 80 00 82 20 21 24 02 00 01 00 A2 28 04 8C 82 00 00 00 05 28 27 00 A2 28 24 AC 85 00 00 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_182_0_0 {
	meta:
		name = "mkfifo"
		size = 32
		refs = "0000 _gp_disp 000c __GI_mknod"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 34 A5 10 00 00 00 38 21 ?? ?? ?? ?? 00 00 30 21 }
	condition:
		$1
}

rule file_183_0_0 {
	meta:
		name = "__GI_recv"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 4F 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_184_0_0 {
	meta:
		name = "_time_mktime"
		size = 180
		refs = "0000 _gp_disp 0010 _time_tzlock 0014 _pthread_cleanup_push_defer 0020 __pthread_mutex_unlock 004c __pthread_mutex_lock 005c __GI_tzset 0070 _time_tzinfo 0074 _time_mktime_tzi 008c _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 8F 86 ?? ?? 8F 99 ?? ?? AF B1 00 34 00 A0 88 21 8F 85 ?? ?? AF B0 00 30 27 B0 00 18 AF BF 00 3C AF B2 00 38 AF BC 00 10 00 80 90 21 ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 02 40 20 21 8F 86 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 02 20 28 21 8F BC 00 10 02 00 20 21 AF A2 00 28 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 01 8F BF 00 3C 8F A2 00 28 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "pivot_root"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 78 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_186_0_0 {
	meta:
		name = "__GI_time"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F AD 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_187_0_0 {
	meta:
		name = "__setutent"
		size = 272
		refs = "0000 _gp_disp 003c __GI_open 005c __GI_fcntl 00b4 __GI_close 00f8 __GI_lseek"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B0 00 18 8F 90 ?? ?? AF BC 00 10 24 02 FF FF 8E 03 ?? ?? AF BF 00 24 AF B2 00 20 AF B1 00 1C 14 62 00 2E 8F BF 00 24 8F 92 ?? ?? 8F 91 ?? ?? 24 05 00 02 02 20 C8 21 ?? ?? ?? ?? 8E 44 ?? ?? AE 02 ?? ?? 04 40 00 0B 8F BC 00 10 8F 91 ?? ?? 8E 04 ?? ?? 24 05 00 01 02 20 C8 21 ?? ?? ?? ?? 00 00 30 21 04 41 00 14 8F BC 00 10 10 00 00 09 24 02 FF FF 8E 44 ?? ?? 02 20 C8 21 ?? ?? ?? ?? 00 00 28 21 AE 02 ?? ?? 04 41 FF F0 8F BC 00 10 24 02 FF FF 8F BF 00 24 8F B2 00 20 8F B1 00 1C AE 02 ?? ?? 8F 99 ?? ?? 8F B0 00 18 24 04 FF FF ?? ?? ?? ?? 27 BD 00 28 8F 83 ?? ?? 24 05 00 02 34 46 00 01 02 20 C8 21 ?? ?? ?? ?? 8C 64 ?? ?? 04 40 FF EF 8F BC 00 10 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8E 04 ?? ?? 8F 99 ?? ?? 8F B0 00 18 00 00 28 21 00 00 30 21 ?? ?? ?? ?? 27 BD 00 28 }
	condition:
		$1
}

rule file_187_1_0 {
	meta:
		name = "__getutent"
		size = 112
		refs = "0000 _gp_disp 0030 __setutent 0040 __GI_read"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 24 02 FF FF AF BC 00 10 AF BF 00 1C AF B0 00 18 14 82 00 07 8F 90 ?? ?? 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 09 00 00 10 21 8F 99 ?? ?? 24 06 01 80 ?? ?? ?? ?? 26 05 ?? ?? 38 42 01 80 26 10 ?? ?? 00 02 80 0B 02 00 10 21 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_187_2_0 {
	meta:
		name = "__getutid"
		size = 244
		refs = "0000 _gp_disp 0024 __GI_strncmp 0050 __getutent"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B5 00 2C AF B3 00 24 AF B2 00 20 8F 93 ?? ?? 8F 92 ?? ?? 8F 95 ?? ?? AF B6 00 30 AF B4 00 28 AF B1 00 1C AF BC 00 10 AF BF 00 34 AF B0 00 18 00 80 88 21 24 94 00 28 24 16 00 05 26 59 ?? ?? ?? ?? ?? ?? 8E 64 ?? ?? 10 40 00 1B 00 40 80 21 86 22 00 00 30 43 FF FF 24 64 FF FF 2C 84 00 04 10 80 00 06 00 00 00 00 86 04 00 00 54 82 00 06 24 63 FF FA 10 00 00 11 02 00 10 21 10 56 00 06 26 04 00 28 24 63 FF FA 2C 63 00 03 10 60 FF EC 26 59 ?? ?? 26 04 00 28 02 80 28 21 02 A0 C8 21 ?? ?? ?? ?? 24 06 00 04 14 40 FF E5 26 59 ?? ?? 10 00 00 02 02 00 10 21 00 00 10 21 8F BF 00 34 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_187_3_0 {
	meta:
		name = "__GI_setutent"
		size = 136
		refs = "0000 _gp_disp 0018 __pthread_mutex_unlock 001c _pthread_cleanup_push_defer 0040 __pthread_mutex_lock 0058 __setutent 0068 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B1 00 30 8F 91 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? AF B0 00 2C 27 B0 00 18 AF BF 00 34 26 26 ?? ?? AF BC 00 10 ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 24 ?? ?? 8F BC 00 10 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 02 00 20 21 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 01 8F BF 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_187_4_0 {
	meta:
		name = "endutent"
		size = 160
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 0040 __pthread_mutex_lock 0064 __GI_close 0074 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B1 00 30 8F 91 ?? ?? 8F 99 ?? ?? 8F 85 ?? ?? AF B0 00 2C 27 B0 00 18 AF BC 00 10 26 26 ?? ?? AF BF 00 34 ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 24 ?? ?? 8F BC 00 10 8F 82 ?? ?? 8C 44 ?? ?? 00 40 88 21 24 02 FF FF 10 82 00 04 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 99 ?? ?? 24 02 FF FF AE 22 ?? ?? 02 00 20 21 ?? ?? ?? ?? 24 05 00 01 8F BF 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_187_5_0 {
	meta:
		name = "getutent"
		size = 148
		refs = "0000 _gp_disp 0018 __pthread_mutex_unlock 001c _pthread_cleanup_push_defer 0040 __pthread_mutex_lock 005c __getutent 0070 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF B1 00 38 8F 91 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? AF B0 00 34 27 B0 00 18 AF BF 00 3C 26 26 ?? ?? AF BC 00 10 ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 24 ?? ?? 8F BC 00 10 8F 82 ?? ?? 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 8C 44 ?? ?? 8F BC 00 10 02 00 20 21 AF A2 00 28 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 01 8F BF 00 3C 8F A2 00 28 8F B1 00 38 8F B0 00 34 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_187_6_0 {
	meta:
		name = "__GI_getutid"
		size = 156
		refs = "0000 _gp_disp 0018 __pthread_mutex_unlock 001c _pthread_cleanup_push_defer 0048 __pthread_mutex_lock 0060 __getutid 0074 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF B1 00 34 8F 91 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? AF B0 00 30 27 B0 00 18 AF BF 00 3C 26 26 ?? ?? AF B2 00 38 AF BC 00 10 00 80 90 21 ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 24 ?? ?? 8F BC 00 10 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 02 00 20 21 AF A2 00 28 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 01 8F BF 00 3C 8F A2 00 28 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_187_7_0 {
	meta:
		name = "getutline"
		size = 244
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 0058 __pthread_mutex_lock 0070 __GI_strcmp 0078 __getutent 00bc _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B0 00 2C 8F 90 ?? ?? 8F 99 ?? ?? 8F 85 ?? ?? AF B1 00 30 27 B1 00 18 AF BC 00 10 AF BF 00 44 AF B5 00 40 AF B4 00 3C AF B3 00 38 AF B2 00 34 00 80 A0 21 26 06 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 26 04 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 26 94 00 08 8F BC 00 10 8F 93 ?? ?? 8F 92 ?? ?? 8F 95 ?? ?? 26 59 ?? ?? ?? ?? ?? ?? 8E 64 ?? ?? 00 40 80 21 10 40 00 0D 8F BC 00 10 96 02 00 00 24 42 FF FA 30 42 FF FF 2C 42 00 02 10 40 FF F6 26 59 ?? ?? 26 04 00 08 02 A0 C8 21 ?? ?? ?? ?? 02 80 28 21 14 40 FF EF 8F BC 00 10 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 24 05 00 01 8F BF 00 44 02 00 10 21 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_187_8_0 {
	meta:
		name = "pututline"
		size = 264
		refs = "0000 _gp_disp 0018 __pthread_mutex_unlock 001c _pthread_cleanup_push_defer 004c __pthread_mutex_lock 0068 __GI_lseek 0084 __getutid 00c0 __GI_write 00d8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF B1 00 30 8F 91 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? AF B3 00 38 27 B3 00 18 AF BF 00 3C 26 26 ?? ?? AF BC 00 10 AF B2 00 34 AF B0 00 2C 00 80 80 21 ?? ?? ?? ?? 02 60 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 24 ?? ?? 8F BC 00 10 24 05 FE 80 24 06 00 01 8F 91 ?? ?? 8F 92 ?? ?? 02 40 C8 21 ?? ?? ?? ?? 8E 24 ?? ?? 8F BC 00 10 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 02 00 20 21 10 40 00 04 8E 24 ?? ?? 24 05 FE 80 10 00 00 03 24 06 00 01 00 00 28 21 24 06 00 02 02 40 C8 21 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8E 24 ?? ?? 02 00 28 21 8F 99 ?? ?? ?? ?? ?? ?? 24 06 01 80 8F BC 00 10 38 42 01 80 02 60 20 21 8F 99 ?? ?? 24 05 00 01 ?? ?? ?? ?? 00 02 80 0B 8F BF 00 3C 02 00 10 21 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_187_9_0 {
	meta:
		name = "utmpname"
		size = 260
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 004c __pthread_mutex_lock 0078 free 0088 __GI_strdup 00bc __GI_close 00cc _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF B1 00 30 8F 91 ?? ?? 8F 99 ?? ?? 8F 85 ?? ?? AF B0 00 2C 27 B0 00 18 AF BC 00 10 AF BF 00 3C AF B2 00 34 26 26 ?? ?? AF B3 00 38 00 80 90 21 ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 24 ?? ?? 12 40 00 13 8F BC 00 10 8F 82 ?? ?? 8F 91 ?? ?? 8C 44 ?? ?? 26 31 ?? ?? 10 91 00 05 00 40 98 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 AE 62 ?? ?? 14 40 00 03 8F BC 00 10 8F 82 ?? ?? AC 51 ?? ?? 8F 82 ?? ?? 8C 44 ?? ?? 00 40 88 21 24 02 FF FF 10 82 00 04 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 99 ?? ?? 24 02 FF FF AE 22 ?? ?? 02 00 20 21 ?? ?? ?? ?? 24 05 00 01 8F BF 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 00 00 10 21 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_188_0_0 {
	meta:
		name = "__GI_sigaddset"
		size = 88
		refs = "0000 _gp_disp 0028 __GI___sigaddset 0034 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 24 A2 FF FF 2C 42 00 80 AF BC 00 10 AF BF 00 1C 10 40 00 04 8F BF 00 1C 8F 99 ?? ?? ?? ?? ?? ?? 27 BD 00 20 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 AC 43 00 00 8F BF 00 1C 24 02 FF FF 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_769_0_0 {
	meta:
		name = "__GI_sigdelset"
		size = 88
		refs = "0000 _gp_disp 0028 __GI___sigdelset 0034 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 24 A2 FF FF 2C 42 00 80 AF BC 00 10 AF BF 00 1C 10 40 00 04 8F BF 00 1C 8F 99 ?? ?? ?? ?? ?? ?? 27 BD 00 20 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 AC 43 00 00 8F BF 00 1C 24 02 FF FF 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_249_0_0 {
	meta:
		name = "sigismember"
		size = 88
		refs = "0000 _gp_disp 0028 __GI___sigismember 0034 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 24 A2 FF FF 2C 42 00 80 AF BC 00 10 AF BF 00 1C 10 40 00 04 8F BF 00 1C 8F 99 ?? ?? ?? ?? ?? ?? 27 BD 00 20 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 AC 43 00 00 8F BF 00 1C 24 02 FF FF 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_189_0_0 {
	meta:
		name = "sched_getparam"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 3F 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_190_0_0 {
	meta:
		name = "__syscall_ipc"
		size = 108
		refs = "0000 _gp_disp 0044 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF B0 00 18 AF BF 00 1C 8F B0 00 34 8F A2 00 30 27 BD FF E0 AF A2 00 10 AF B0 00 14 24 02 10 15 00 00 00 0C 27 BD 00 20 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_193_0_0 {
	meta:
		name = "wcpcpy"
		size = 32
	strings:
		$1 = { 8C A3 00 00 00 80 10 21 24 A5 00 04 24 84 00 04 14 60 FF FB AC 43 00 00 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_194_0_0 {
	meta:
		name = "__strtofpmax"
		size = 1148
		refs = "0000 _gp_disp 0020 __GI___ctype_b 00a4 $LC0 0104 __muldf3 0140 __floatsidf 015c __adddf3 0228 __divdf3 02c0 __eqdf2 03f0 $LC1 0424 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A8 AF B6 00 48 AF B2 00 38 00 80 B0 21 00 80 90 21 8F 84 ?? ?? AF BE 00 50 AF BC 00 10 AF BF 00 54 AF B7 00 4C AF B5 00 44 AF B4 00 40 AF B3 00 3C AF B1 00 34 AF B0 00 30 AF A5 00 5C 00 C0 F0 21 82 C2 00 00 8C 8B 00 00 00 02 18 40 01 63 18 21 94 63 00 00 30 63 00 20 10 60 00 03 24 03 00 2B 10 00 FF F7 26 D6 00 01 10 43 00 05 24 03 00 2D 54 43 00 05 00 00 98 21 10 00 00 02 24 13 00 01 00 00 98 21 26 D6 00 01 8F 82 ?? ?? 24 17 FF FF 00 00 48 21 8C 51 ?? ?? 8C 50 ?? ?? 00 00 A0 21 00 00 A8 21 24 0C FF FF 24 0D 00 30 24 0E 00 2E 82 C8 00 00 00 08 10 40 01 62 10 21 94 42 00 00 30 42 00 08 10 40 00 2F 00 00 00 00 12 EC 00 03 00 00 00 00 56 E0 00 04 26 F7 00 01 11 0D 00 27 00 00 B8 21 26 F7 00 01 2A E2 00 12 50 40 FF F0 26 D6 00 01 8F 99 ?? ?? 02 A0 28 21 AF A9 00 20 AF AB 00 1C AF AC 00 24 AF AD 00 28 AF AE 00 2C 02 80 20 21 02 20 38 21 02 00 30 21 ?? ?? ?? ?? AF A8 00 18 8F BC 00 10 8F A8 00 18 00 60 A8 21 8F 99 ?? ?? 25 04 FF D0 ?? ?? ?? ?? 00 40 A0 21 8F BC 00 10 02 A0 28 21 02 80 20 21 8F 99 ?? ?? 00 60 38 21 ?? ?? ?? ?? 00 40 30 21 8F BC 00 10 8F A9 00 20 8F AB 00 1C 8F AC 00 24 8F AD 00 28 8F AE 00 2C 00 40 A0 21 00 60 A8 21 10 00 FF CC 26 D6 00 01 15 0E 00 06 24 02 FF FF 15 20 00 39 00 00 00 00 26 D6 00 01 10 00 FF C5 02 C0 48 21 16 E2 00 36 2A E2 00 12 15 20 00 A0 8F A6 00 5C 8F 84 ?? ?? 00 00 80 21 24 84 ?? ?? 00 80 18 21 00 00 10 21 26 05 00 01 02 C2 30 21 00 A2 38 21 80 C6 00 00 00 E4 38 21 80 E7 00 00 34 C6 00 20 14 E6 00 1B 00 60 88 21 24 42 00 01 00 A2 30 21 00 C4 30 21 80 C6 00 00 54 C0 FF F4 02 C2 30 21 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 00 60 28 21 00 40 20 21 8F 99 ?? ?? 00 00 38 21 ?? ?? ?? ?? 00 00 30 21 00 40 A0 21 12 60 00 03 00 60 A8 21 3C 14 80 00 02 82 A0 26 02 30 80 21 82 12 00 00 26 52 FF FE 10 00 00 77 02 D2 90 21 02 03 10 21 80 42 00 00 02 02 80 21 02 03 10 21 80 42 00 00 14 40 FF D7 00 00 10 21 10 00 00 6F 8F A6 00 5C 12 E2 00 6C 2A E2 00 12 14 40 00 03 02 C0 90 21 26 F7 FF EF 03 D7 F0 21 11 20 00 02 01 36 48 23 03 C9 F0 21 12 60 00 03 35 08 00 20 3C 02 80 00 00 54 A0 26 24 02 00 65 15 02 00 22 8F 99 ?? ?? 82 C2 00 01 24 03 00 2B 10 43 00 06 24 03 00 2D 50 43 00 05 24 04 FF FF 26 D2 00 01 10 00 00 03 24 04 00 01 24 04 00 01 26 D2 00 02 02 40 10 21 00 00 18 21 24 07 00 0A 80 45 00 00 00 05 30 40 01 66 30 21 94 C6 00 00 30 C6 00 08 50 C0 00 08 00 52 90 26 28 66 01 55 10 C0 FF F7 24 42 00 01 70 67 30 02 24 A5 FF D0 10 00 FF F3 00 C5 18 21 02 D2 10 0A 00 40 90 21 70 83 10 02 00 5E F0 21 8F 99 ?? ?? 02 80 20 21 02 A0 28 21 00 00 38 21 ?? ?? ?? ?? 00 00 30 21 10 40 00 36 8F BC 00 10 00 1E 17 C3 00 5E B0 26 02 C2 B0 23 8F 82 ?? ?? 8C 51 ?? ?? 8C 50 ?? ?? 12 C0 00 19 32 C2 00 01 10 40 00 0D 8F 99 ?? ?? 07 C1 00 03 02 80 20 21 10 00 00 01 8F 99 ?? ?? 02 A0 28 21 02 20 38 21 03 20 F8 09 02 00 30 21 8F BC 00 10 00 40 A0 21 00 60 A8 21 8F 99 ?? ?? 02 20 28 21 02 00 20 21 02 20 38 21 ?? ?? ?? ?? 02 00 30 21 00 16 B0 43 8F BC 00 10 00 60 88 21 10 00 FF E7 00 40 80 21 8F 82 ?? ?? 8F 99 ?? ?? 02 80 20 21 8C 47 ?? ?? 8C 46 ?? ?? ?? ?? ?? ?? 02 A0 28 21 8F BC 00 10 02 80 20 21 02 A0 28 21 8F 99 ?? ?? 00 60 38 21 ?? ?? ?? ?? 00 40 30 21 14 40 00 06 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 22 AC 43 00 00 8F A6 00 5C 54 C0 00 01 AC D2 00 00 8F BF 00 54 02 80 10 21 02 A0 18 21 8F BE 00 50 8F B7 00 4C 8F B6 00 48 8F B5 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 58 }
	condition:
		$1
}

rule file_195_0_0 {
	meta:
		name = "tmpnam_r"
		size = 116
		refs = "0000 _gp_disp 002c ___path_search 0048 __gen_tempname"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF B0 00 18 AF BF 00 1C 14 80 00 03 00 80 80 21 10 00 00 0F 00 00 10 21 8F 99 ?? ?? 24 05 00 14 00 00 30 21 ?? ?? ?? ?? 00 00 38 21 14 40 FF F8 8F BC 00 10 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 24 05 00 03 14 40 00 02 00 00 10 21 02 00 10 21 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_196_4_0 {
	meta:
		name = "authnone_marshal"
		size = 108
		refs = "0000 _gp_disp 000c __rpc_thread_variables"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BC 00 10 AF B0 00 18 AF BF 00 1C ?? ?? ?? ?? 00 A0 80 21 8C 42 00 98 10 40 00 0A 8F BC 00 10 8E 03 00 04 8F BF 00 1C 02 00 20 21 8C 79 00 0C 8F B0 00 18 8C 46 00 3C 24 45 00 28 03 20 00 08 27 BD 00 20 8F BF 00 1C 8F B0 00 18 00 00 10 21 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_196_5_0 {
	meta:
		name = "__GI_authnone_create"
		size = 308
		refs = "0000 _gp_disp 000c __rpc_thread_variables 0040 calloc 006c _null_auth 0070 __GI_xdrmem_create 00c4 __GI_xdr_opaque_auth"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF C0 AF BC 00 10 AF B1 00 34 AF B0 00 30 AF BF 00 3C AF B2 00 38 ?? ?? ?? ?? 00 00 00 00 8C 50 00 98 8F BC 00 10 16 00 00 09 00 40 88 21 8F 99 ?? ?? 24 04 00 01 ?? ?? ?? ?? 24 05 00 40 00 40 80 21 10 40 00 30 8F BC 00 10 AE 22 00 98 8E 02 00 3C 14 40 00 2D 02 00 10 21 8F 82 ?? ?? 8F 99 ?? ?? 27 B1 00 18 8C 44 00 00 24 06 00 14 00 00 38 21 AE 04 00 0C 8C 43 00 04 26 05 00 28 AE 03 00 10 8C 42 00 08 AE 03 00 04 AE 04 00 00 AE 02 00 14 AE 02 00 08 8F 82 ?? ?? 02 20 20 21 24 42 ?? ?? ?? ?? ?? ?? AE 02 00 20 8F BC 00 10 02 20 20 21 8F 92 ?? ?? 02 40 C8 21 ?? ?? ?? ?? 02 00 28 21 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 26 05 00 0C 8F A2 00 1C 8C 59 00 10 03 20 F8 09 02 20 20 21 AE 02 00 3C 8F A2 00 1C 8C 59 00 1C 53 20 00 06 02 00 10 21 03 20 F8 09 02 20 20 21 10 00 00 02 02 00 10 21 00 00 10 21 8F BF 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_197_0_0 {
	meta:
		name = "sched_yield"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 42 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_198_0_0 {
	meta:
		name = "__GI_towctrans"
		size = 132
		refs = "0000 _gp_disp 005c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 24 A2 FF FF 2C 42 00 02 AF BC 00 10 AF B0 00 18 AF BF 00 1C 10 40 00 0D 00 80 80 21 34 83 00 20 24 64 FF 9F 2C 84 00 1A 10 80 00 0E 02 00 10 21 00 60 10 21 24 03 00 02 14 A3 00 0B 8F BF 00 1C 24 02 FF DF 10 00 00 08 02 02 10 24 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 AC 43 00 00 02 00 10 21 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_199_0_0 {
	meta:
		name = "__GI_qsort"
		size = 324
	strings:
		$1 = { 2C A2 00 02 14 40 00 4D 00 00 00 00 27 BD FF B8 AF B1 00 24 AF BF 00 44 AF BE 00 40 AF B7 00 3C AF B6 00 38 AF B5 00 34 AF B4 00 30 AF B3 00 2C AF B2 00 28 AF B0 00 20 10 C0 00 35 00 C0 88 21 24 A3 FF FF 24 02 00 03 00 62 00 1B 00 40 01 F4 00 80 F0 21 00 00 80 21 00 00 18 12 72 02 80 02 26 10 00 01 02 03 20 2B 54 80 FF FD 72 02 80 02 72 30 80 02 24 17 00 03 70 B1 B0 02 02 00 A0 21 02 80 A8 21 02 B0 A8 23 03 D5 90 21 02 50 98 21 AF A7 00 18 00 E0 C8 21 02 40 20 21 03 20 F8 09 02 60 28 21 1C 40 00 07 8F A7 00 18 02 91 A0 21 02 96 10 2B 14 40 FF F3 02 80 A8 21 10 00 00 0F 02 11 80 23 02 20 10 21 82 44 00 00 82 65 00 00 24 42 FF FF 26 52 00 01 A2 45 FF FF 26 73 00 01 14 40 FF F9 A2 64 FF FF 02 B0 10 2B 10 40 FF E6 02 B0 A8 23 10 00 FF EE 02 91 A0 21 02 17 00 1B 02 E0 01 F4 00 00 80 12 16 00 FF DD 02 00 A0 21 8F BF 00 44 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 27 BD 00 48 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_200_0_0 {
	meta:
		name = "link"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F A9 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_201_0_0 {
	meta:
		name = "getgrouplist"
		size = 212
		refs = "0000 _gp_disp 000c __getgrouplist_internal 0078 __GI_memcpy 0090 free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D0 AF BC 00 10 AF B4 00 28 AF B3 00 24 AF B2 00 20 AF B1 00 1C AF B0 00 18 AF BF 00 2C 00 C0 A0 21 00 E0 30 21 00 A0 80 21 00 E0 88 21 ?? ?? ?? ?? 8C F3 00 00 00 40 90 21 14 40 00 05 8F BC 00 10 12 60 00 16 24 02 00 01 10 00 00 15 AE 90 00 00 8E 22 00 00 02 62 80 2A 00 50 98 0A 12 60 00 07 02 60 80 21 8F 99 ?? ?? 02 80 20 21 02 40 28 21 ?? ?? ?? ?? 00 13 30 80 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 8E 23 00 00 24 02 FF FF 02 03 18 2A 10 00 00 02 02 03 10 0A 24 02 FF FF 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_202_0_0 {
	meta:
		name = "freopen64"
		size = 452
		refs = "0000 _gp_disp 0044 _pthread_cleanup_push_defer 0048 __pthread_mutex_unlock 0060 __pthread_mutex_lock 0074 _stdio_openlist_del_lock 00a8 _stdio_openlist_use_count 00ac _pthread_cleanup_pop_restore 00e4 __GI_fclose 0128 _stdio_openlist_del_count 0144 _stdio_fopen 0174 _stdio_openlist_dec_use"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A8 AF B4 00 4C AF B3 00 48 AF B0 00 3C AF BC 00 10 AF BF 00 54 AF B5 00 50 AF B2 00 44 AF B1 00 40 8C D2 00 34 00 80 A0 21 00 A0 98 21 16 40 00 0C 00 C0 80 21 8F 99 ?? ?? 8F 85 ?? ?? 24 D1 00 38 27 A4 00 28 ?? ?? ?? ?? 02 20 30 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8F 85 ?? ?? 8F 86 ?? ?? 8F 99 ?? ?? 27 B1 00 18 ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 02 20 20 21 24 05 00 01 8F 82 ?? ?? 8F 99 ?? ?? 8C 43 00 00 24 63 00 01 AC 43 00 00 ?? ?? ?? ?? 00 00 00 00 96 02 00 00 8F BC 00 10 30 43 9F FF 30 55 60 00 A6 03 00 00 30 42 00 30 24 03 00 30 10 43 00 18 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F 85 ?? ?? 8F 86 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 02 20 20 21 24 05 00 01 8F 82 ?? ?? 8F 99 ?? ?? 8C 43 00 00 24 63 FF FF ?? ?? ?? ?? AC 43 00 00 8F BC 00 10 8F 99 ?? ?? 02 80 20 21 02 60 28 21 02 00 30 21 ?? ?? ?? ?? 24 07 FF FE 00 40 88 21 14 40 00 03 8F BC 00 10 24 02 80 30 A6 02 00 00 96 02 00 00 8F 99 ?? ?? 02 A2 A8 25 ?? ?? ?? ?? A6 15 00 00 16 40 00 05 8F BC 00 10 8F 99 ?? ?? 27 A4 00 28 ?? ?? ?? ?? 24 05 00 01 8F BF 00 54 02 20 10 21 8F B5 00 50 8F B4 00 4C 8F B3 00 48 8F B2 00 44 8F B1 00 40 8F B0 00 3C 03 E0 00 08 27 BD 00 58 }
	condition:
		$1
}

rule file_203_0_0 {
	meta:
		name = "__GI_setresgid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 5E 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_204_0_0 {
	meta:
		name = "__getpagesize"
		size = 32
		refs = "0000 _gp_disp 000c __pagesize"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 3C 03 00 01 8C 42 00 00 03 E0 00 08 00 62 10 0A }
	condition:
		$1
}

rule file_205_0_0 {
	meta:
		name = "__GI_fgetwc_unlocked"
		size = 536
		refs = "0000 _gp_disp 0060 __stdio_trans2r_o 00f0 __GI_mbrtowc 00f4 __stdio_rfill 01a4 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF B0 00 20 AF BC 00 10 AF BF 00 3C AF B6 00 38 AF B5 00 34 AF B4 00 30 AF B3 00 2C AF B2 00 28 AF B1 00 24 94 82 00 00 30 42 08 03 2C 42 08 01 14 40 00 07 00 80 80 21 96 02 00 00 30 43 00 02 14 60 00 0A 30 43 00 01 10 00 00 18 8E 02 00 08 8F 99 ?? ?? ?? ?? ?? ?? 24 05 08 00 10 40 FF F6 8F BC 00 10 10 00 00 5E 24 02 FF FF 54 60 00 07 A2 00 00 02 8E 04 00 28 50 80 00 03 92 04 00 03 10 00 00 02 A2 00 00 02 A2 04 00 02 24 63 00 08 24 42 FF FF 00 03 18 80 A6 02 00 00 02 03 18 21 8C 62 00 04 10 00 00 44 AE 00 00 28 54 40 00 0A 8E 02 00 2C 27 A2 00 1C AE 02 00 08 AE 02 00 10 AE 02 00 14 AE 02 00 18 AE 02 00 1C 27 A2 00 1D AE 02 00 0C 8E 02 00 2C 50 40 00 01 A2 00 00 02 8F 95 ?? ?? 8F 92 ?? ?? 26 13 00 2C 27 B4 00 18 24 16 FF FE 8E 05 00 10 8E 11 00 14 02 25 88 23 12 20 00 19 02 40 C8 21 02 80 20 21 02 20 30 21 02 A0 C8 21 ?? ?? ?? ?? 02 60 38 21 04 40 00 0A 24 03 00 01 00 62 10 0A 8E 03 00 10 00 62 18 21 AE 03 00 10 92 03 00 02 00 43 10 21 A2 02 00 02 10 00 00 1D 8F A2 00 18 14 56 00 17 02 40 C8 21 8E 02 00 10 00 51 10 21 AE 02 00 10 92 02 00 02 02 22 88 21 A2 11 00 02 ?? ?? ?? ?? 02 00 20 21 14 40 FF E0 8F BC 00 10 96 02 00 00 30 42 00 08 54 40 00 0A 96 02 00 00 8E 03 00 2C 10 60 00 0A 24 02 FF FF 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 58 AC 43 00 00 96 02 00 00 34 42 00 08 A6 02 00 00 24 02 FF FF 8E 04 00 08 27 A3 00 1C 14 83 00 08 8F BF 00 3C AE 00 00 08 AE 00 00 0C AE 00 00 10 AE 00 00 14 AE 00 00 18 AE 00 00 1C 8F BF 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_206_0_0 {
	meta:
		name = "__GI_strncat"
		size = 192
	strings:
		$1 = { 00 80 10 21 00 80 18 21 80 64 00 00 10 80 00 03 24 67 00 01 10 00 FF FC 00 E0 18 21 2C C4 00 04 24 63 FF FF 14 80 00 18 00 06 40 82 80 A4 00 00 10 80 00 21 A0 64 00 01 80 A4 00 01 10 80 00 1E A0 64 00 02 80 A4 00 02 10 80 00 1B A0 64 00 03 80 A7 00 03 24 A9 00 04 24 64 00 04 10 E0 00 16 A0 67 00 04 25 08 FF FF 51 00 00 04 30 C6 00 03 01 20 28 21 10 00 FF ED 00 80 18 21 01 20 28 21 10 00 00 09 00 80 18 21 10 00 00 07 00 00 38 21 24 63 00 01 24 A4 00 01 10 E0 00 07 A0 67 00 00 24 C6 FF FF 00 80 28 21 54 C0 FF F9 80 A7 00 00 54 E0 00 01 A0 60 00 01 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_207_0_0 {
	meta:
		name = "mbtowc"
		size = 120
		refs = "0000 _gp_disp 0040 __GI_mbrtowc"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 54 A0 00 05 80 A3 00 00 8F 82 ?? ?? AC 40 ?? ?? 10 00 00 0E 00 00 10 21 10 60 00 0C 00 00 10 21 8F 90 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 26 07 ?? ?? 24 03 FF FE 14 43 00 06 8F BF 00 1C 34 02 FF FF 26 10 ?? ?? AE 02 00 04 24 02 FF FF 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_208_0_0 {
	meta:
		name = "getoffset"
		size = 176
		refs = "0000 _gp_disp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 87 ?? ?? 24 02 FF FF 00 00 18 21 24 E7 ?? ?? 24 08 00 0A 24 09 00 3A 80 86 00 00 24 C6 FF D0 30 CA 00 FF 2D 4A 00 0A 11 40 00 03 24 E7 00 01 24 84 00 01 00 C0 10 21 80 86 00 00 24 C6 FF D0 30 CA 00 FF 2D 4A 00 0A 51 40 00 05 80 E6 00 00 70 48 50 02 24 84 00 01 01 46 10 21 80 E6 00 00 00 46 50 2B 11 40 00 0D 70 C3 50 02 01 42 18 21 80 8A 00 00 15 49 00 03 00 00 10 21 24 84 00 01 24 02 FF FF 28 C6 00 02 50 C0 FF E4 80 86 00 00 AC A3 00 00 03 E0 00 08 00 80 10 21 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_208_1_0 {
	meta:
		name = "_time_tzset"
		size = 1424
		refs = "0000 _gp_disp 0010 __pthread_mutex_unlock 0014 _time_tzlock 0018 _pthread_cleanup_push_defer 005c __pthread_mutex_lock 0070 __GI_getenv 008c __GI_open 0088 $LC0 00a8 __GI_read 0100 __GI_close 0128 _time_tzinfo 0130 __GI_memset 0154 __GI_strcpy 0180 __GI_strcmp 019c __GI_strncpy 02e0 getoffset 0344 __GI_memcpy 01bc __GI___ctype_b 0354 tzname 036c daylight 037c timezone 0558 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 40 8F 85 ?? ?? 8F 86 ?? ?? 8F 99 ?? ?? AF B2 00 A8 27 B2 00 8C AF BF 00 BC AF BC 00 10 AF B3 00 AC AF B0 00 A0 AF B6 00 B8 AF B5 00 B4 AF B4 00 B0 AF B1 00 A4 00 80 98 21 AF A0 00 9C ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 84 ?? ?? 00 40 80 21 14 40 00 39 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? 00 00 28 21 ?? ?? ?? ?? 24 84 ?? ?? 00 40 A0 21 04 40 00 21 8F BC 00 10 8F 96 ?? ?? 27 B1 00 18 24 10 00 44 02 20 A8 21 02 80 20 21 02 20 28 21 02 C0 C8 21 ?? ?? ?? ?? 02 00 30 21 04 40 00 10 8F BC 00 10 50 40 00 05 02 B1 10 2B 02 02 80 23 16 00 FF F5 02 22 88 21 02 B1 10 2B 10 40 00 09 00 00 80 21 82 23 FF FF 24 02 00 0A 14 62 00 06 8F 99 ?? ?? A2 20 FF FF 10 00 00 03 02 A0 80 21 00 00 80 21 8F 99 ?? ?? ?? ?? ?? ?? 02 80 20 21 16 00 00 11 8F BC 00 10 8F 90 ?? ?? 8F 82 ?? ?? 8F 99 ?? ?? 02 00 20 21 00 00 28 21 24 06 00 30 ?? ?? ?? ?? A0 40 ?? ?? 8F BC 00 10 26 04 00 10 8F 85 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? 10 00 00 7B 8F BC 00 10 82 02 00 00 50 40 FF EF 8F 90 ?? ?? 8F 91 ?? ?? 38 42 00 3A 2C 42 00 01 8F 99 ?? ?? 02 02 80 21 02 00 20 21 ?? ?? ?? ?? 26 25 ?? ?? 10 40 00 F0 8F BC 00 10 8F 99 ?? ?? 26 24 ?? ?? 02 00 28 21 ?? ?? ?? ?? 24 06 00 44 8F BC 00 10 A3 A0 00 84 00 00 60 21 8F 98 ?? ?? 8F 91 ?? ?? 27 AD 00 5C 27 AF 00 9C 27 AE 00 18 82 03 00 00 24 02 00 3C 14 62 00 03 24 03 00 3E 10 00 00 02 26 10 00 01 00 00 18 21 24 06 00 18 71 86 10 02 02 00 58 21 00 00 20 21 24 08 00 2B 24 05 00 2D 24 09 00 07 00 4D 30 21 24 C6 00 10 81 62 00 00 18 40 00 16 00 02 38 40 8F 0A 00 00 01 47 38 21 94 E7 00 00 30 EA 00 04 11 40 00 08 00 00 00 00 24 84 00 01 24 C7 00 01 25 6B 00 01 10 89 FF B9 A0 C2 00 00 10 00 FF F1 00 E0 30 21 10 60 00 07 30 E7 08 00 54 E0 FF F7 24 84 00 01 50 48 FF F5 24 84 00 01 50 45 FF F3 24 84 00 01 28 84 00 03 14 80 FF AC A0 C0 00 00 50 60 00 04 81 62 00 00 14 43 FF A8 25 6B 00 01 81 62 00 00 24 03 00 2D 10 43 00 0E 24 03 00 2B 10 43 00 0D 01 60 20 21 11 80 00 0B 25 64 FF FF 24 42 FF D0 30 42 00 FF 2C 42 00 0A 14 40 00 06 8F A2 00 9C 01 60 80 21 24 42 F1 F0 10 00 00 11 AF A2 00 9C 01 60 20 21 26 22 ?? ?? 24 84 00 01 00 40 C8 21 ?? ?? ?? ?? 01 E0 28 21 00 40 80 21 10 40 FF 8E 8F BC 00 10 81 63 00 00 24 02 00 2D 14 62 00 05 24 03 00 18 8F A2 00 9C 00 02 10 23 AF A2 00 9C 24 03 00 18 71 83 20 02 8F A2 00 9C 00 8E 18 21 15 80 00 19 AC 62 00 44 AF A2 00 74 82 02 00 00 14 40 FF A7 24 0C 00 01 8F 84 ?? ?? 8F 99 ?? ?? 01 A0 28 21 ?? ?? ?? ?? 24 06 00 30 8F BC 00 10 8F 82 ?? ?? 8F 83 ?? ?? 24 44 00 10 AC 64 00 00 24 44 00 28 AC 64 00 04 80 44 00 28 8F 83 ?? ?? 00 04 20 2B AC 64 00 00 8C 43 00 00 8F 82 ?? ?? 10 00 00 75 AC 43 00 00 82 02 00 00 14 40 00 08 8F 8F ?? ?? 52 60 00 04 8F 90 ?? ?? 8F 90 ?? ?? 10 00 00 03 26 10 ?? ?? 26 10 ?? ?? 8F 8F ?? ?? 8F 98 ?? ?? 8F 93 ?? ?? 8F 91 ?? ?? 00 00 58 21 27 AC 00 9C 82 03 00 00 24 02 00 2C 14 62 FF 56 24 03 00 4D 82 02 00 01 10 43 00 08 26 07 00 02 24 03 00 4A 10 43 00 08 00 00 18 21 26 07 00 01 24 04 01 6D 10 00 00 07 26 62 ?? ?? 24 04 00 0C 10 00 00 04 25 E2 ?? ?? 24 03 00 4A 24 04 01 6D 27 02 ?? ?? 24 08 00 18 71 68 40 02 00 E0 80 21 25 05 00 08 01 A5 28 21 01 C8 40 21 24 A6 00 06 A5 03 00 52 24 A5 00 02 38 63 00 4D 00 A3 30 0B 24 05 00 0A 02 00 18 21 24 08 00 03 00 00 38 21 80 69 00 00 25 29 FF D0 31 2A 00 FF 2D 4A 00 0A 11 40 00 07 70 E5 50 02 25 08 FF FF 24 63 00 01 15 00 FF F7 01 49 38 21 10 00 00 04 00 00 00 00 24 09 00 03 11 09 FF 29 8F 90 ?? ?? 10 60 FF 27 8F 90 ?? ?? 80 48 00 02 00 E8 40 23 00 88 20 2B 54 80 FF 23 8F 82 ?? ?? 80 44 00 01 10 80 00 07 00 60 80 21 24 70 00 01 80 63 00 00 50 64 00 04 80 44 00 03 10 00 FF 19 8F 90 ?? ?? 80 44 00 03 24 C6 FF FE A4 C7 00 00 18 80 00 03 24 43 00 03 10 00 FF D8 00 60 10 21 24 02 1C 20 AF A2 00 9C 82 03 00 00 24 02 00 2F 14 62 00 0A 24 02 00 18 26 22 ?? ?? 26 04 00 01 00 40 C8 21 ?? ?? ?? ?? 01 80 28 21 00 40 80 21 10 40 FF 03 8F BC 00 10 24 02 00 18 71 62 18 02 25 6B 00 01 00 6E 10 21 8F A3 00 9C AC 43 00 48 24 02 00 01 51 62 FF A2 82 03 00 00 82 02 00 00 14 40 FE F8 8F 90 ?? ?? 10 00 FF 7A 8F 84 ?? ?? 8F 99 ?? ?? 02 40 20 21 ?? ?? ?? ?? 24 05 00 01 8F BF 00 BC 8F B6 00 B8 8F B5 00 B4 8F B4 00 B0 8F B3 00 AC 8F B2 00 A8 8F B1 00 A4 8F B0 00 A0 03 E0 00 08 27 BD 00 C0 }
	condition:
		$1
}

rule file_208_2_0 {
	meta:
		name = "__GI_tzset"
		size = 68
		refs = "0000 _gp_disp 000c __GI_time 0030 _time_tzset"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BC 00 10 AF BF 00 1C ?? ?? ?? ?? 00 00 20 21 8F BC 00 10 8F BF 00 1C 3C 04 45 98 8F 99 ?? ?? 24 84 4F 00 00 44 20 2A ?? ?? ?? ?? 27 BD 00 20 }
	condition:
		$1
}

rule file_209_0_0 {
	meta:
		name = "fsetpos"
		size = 212
		refs = "0000 _gp_disp 0038 _pthread_cleanup_push_defer 003c __pthread_mutex_unlock 0054 __pthread_mutex_lock 0064 __GI_fseek 00a0 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B1 00 38 AF B0 00 34 AF BC 00 10 AF BF 00 44 AF B3 00 40 AF B2 00 3C 8C 92 00 34 00 80 80 21 16 40 00 0C 00 A0 88 21 8F 99 ?? ?? 8F 85 ?? ?? 24 93 00 38 02 60 30 21 ?? ?? ?? ?? 27 A4 00 18 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 8F BC 00 10 8F 99 ?? ?? 8E 25 00 00 02 00 20 21 ?? ?? ?? ?? 00 00 30 21 14 40 00 07 8F BC 00 10 8E 23 00 04 AE 03 00 2C 8E 23 00 08 AE 03 00 30 8E 23 00 0C A2 03 00 02 16 40 00 08 8F BF 00 44 8F 99 ?? ?? AF A2 00 28 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F A2 00 28 8F BF 00 44 8F B3 00 40 8F B2 00 3C 8F B1 00 38 8F B0 00 34 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_211_0_0 {
	meta:
		name = "__syscall_sync_file_range"
		size = 108
		refs = "0000 _gp_disp 0044 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF B0 00 18 AF BF 00 1C 8F B0 00 34 8F A2 00 30 27 BD FF E0 AF A2 00 10 AF B0 00 14 24 02 10 D1 00 00 00 0C 27 BD 00 20 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_211_1_0 {
	meta:
		name = "sync_file_range"
		size = 56
		refs = "0000 _gp_disp 0030 __syscall_sync_file_range"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F A3 00 14 8F A2 00 10 8F 99 ?? ?? AF A3 00 10 8F A3 00 18 00 C0 28 21 27 39 ?? ?? 00 E0 30 21 AF A3 00 14 ?? ?? ?? ?? 00 40 38 21 }
	condition:
		$1
}

rule file_213_0_0 {
	meta:
		name = "__GI_read"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F A3 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_214_0_0 {
	meta:
		name = "setjmp"
		size = 24
		refs = "0000 _gp_disp 000c __sigsetjmp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 03 20 00 08 24 05 00 01 }
	condition:
		$1
}

rule file_215_0_0 {
	meta:
		name = "madvise"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 7A 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_216_0_0 {
	meta:
		name = "__close_nameservers"
		size = 180
		refs = "0000 _gp_disp 000c __nameserver 0030 __local_nameserver 0038 free 0048 __nameservers 004c __searchdomains 0050 __searchdomain"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 27 BD FF D8 AF B0 00 18 AF BC 00 10 AF BF 00 24 AF B2 00 20 AF B1 00 1C 8C 44 00 00 00 40 80 21 8F 82 ?? ?? 10 82 00 04 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 82 ?? ?? 8F 91 ?? ?? 8F 92 ?? ?? AE 00 00 00 AC 40 00 00 8E 22 00 00 8F 99 ?? ?? 10 40 00 0A 8F 90 ?? ?? 8E 43 00 00 24 42 FF FF AE 22 00 00 00 02 10 80 00 62 10 21 ?? ?? ?? ?? 8C 44 00 00 10 00 FF F4 8F BC 00 10 ?? ?? ?? ?? 8E 04 00 00 AE 00 00 00 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_217_0_0 {
	meta:
		name = "__GI_wctrans"
		size = 148
		refs = "0000 _gp_disp 001c __GI_strcmp"
		altNames = "__GI_wctype"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 AF B0 00 18 8F 90 ?? ?? AF B3 00 24 8F 93 ?? ?? AF B4 00 28 AF B1 00 1C AF BC 00 10 AF BF 00 2C AF B2 00 20 00 80 A0 21 24 11 00 01 26 10 ?? ?? 26 12 00 01 02 80 20 21 02 60 C8 21 ?? ?? ?? ?? 02 40 28 21 54 40 00 03 92 10 00 00 10 00 00 05 02 20 10 21 02 50 80 21 92 02 00 00 14 40 FF F4 26 31 00 01 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_218_0_0 {
	meta:
		name = "pipe"
		size = 60
		refs = "0000 _gp_disp 0030 __syscall_error"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 24 02 0F CA 00 00 00 0C 14 E0 00 05 00 00 00 00 AC 82 00 00 AC 83 00 04 03 E0 00 08 24 02 00 00 00 40 20 21 8F 99 ?? ?? 03 20 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_219_0_0 {
	meta:
		name = "ctime_r"
		size = 80
		refs = "0000 _gp_disp 000c __GI_localtime_r 0034 __GI_asctime_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF B0 AF BF 00 4C AF B0 00 48 AF BC 00 10 00 A0 80 21 ?? ?? ?? ?? 27 A5 00 18 8F BC 00 10 02 00 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BF 00 4C 8F B0 00 48 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_220_0_0 {
	meta:
		name = "__GI_inet_aton"
		size = 228
		refs = "0000 _gp_disp 0010 __GI___ctype_b"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 10 80 00 30 8F 8B ?? ?? 24 02 00 01 00 00 38 21 24 0C 00 0A 24 0D 00 04 24 0E 00 2E 24 0A 00 05 80 83 00 00 8D 69 00 00 00 03 18 40 01 23 18 21 94 63 00 00 30 63 00 08 10 60 00 22 00 00 18 21 80 86 00 00 00 06 40 40 01 28 40 21 95 08 00 00 31 0F 00 08 11 E0 00 09 24 84 00 01 70 6C 40 02 24 C6 FF D0 01 06 18 21 28 66 01 00 54 C0 FF F5 80 86 00 00 03 E0 00 08 00 00 10 21 10 4D 00 05 00 00 00 00 50 CE 00 08 00 07 3A 00 03 E0 00 08 00 00 10 21 10 C0 00 04 00 07 3A 00 31 08 00 20 11 00 00 08 00 00 00 00 24 42 00 01 14 4A FF DC 00 67 38 25 54 A0 00 05 AC A7 00 00 03 E0 00 08 24 02 00 01 03 E0 00 08 00 00 10 21 24 02 00 01 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_221_0_0 {
	meta:
		name = "access"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F C1 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_222_0_0 {
	meta:
		name = "cacheflush"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 33 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_222_1_0 {
	meta:
		name = "cachectl"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 34 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_223_0_0 {
	meta:
		name = "__sigsetjmp_aux"
		size = 72
		refs = "0000 _gp_disp 003c __sigjmp_save"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 AC 9F 00 00 AC 86 00 04 AC 87 00 28 AC 9C 00 2C AC 90 00 08 AC 91 00 0C AC 92 00 10 AC 93 00 14 AC 94 00 18 AC 95 00 1C AC 96 00 20 AC 97 00 24 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_225_0_0 {
	meta:
		name = "__GI_islower"
		size = 40
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 00 04 20 40 8C 42 00 00 00 44 10 21 94 42 00 00 03 E0 00 08 30 42 00 02 }
	condition:
		$1
}

rule file_226_0_0 {
	meta:
		name = "__GI___cmsg_nxthdr"
		size = 96
	strings:
		$1 = { 8C A2 00 00 2C 43 00 0C 14 60 00 13 24 06 FF FC 24 42 00 03 00 46 10 24 00 A2 28 21 8C 83 00 10 8C 82 00 14 00 62 18 21 24 A2 00 0C 00 62 10 2B 14 40 00 09 00 00 00 00 8C A2 00 00 24 42 00 03 00 46 10 24 00 A2 10 21 00 62 10 2B 00 02 28 0B 03 E0 00 08 00 A0 10 21 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_227_0_0 {
	meta:
		name = "__stdio_fwrite"
		size = 412
		refs = "0000 _gp_disp 005c __stdio_WRITE 0088 __GI_memcpy 00e4 __GI_memrchr 0108 __stdio_wcommit 0128 __GI_memchr"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 AF B2 00 24 AF B1 00 20 AF B0 00 1C AF BC 00 10 AF BF 00 2C AF B3 00 28 94 C2 00 00 00 80 90 21 00 A0 88 21 30 42 02 00 10 40 00 0C 00 C0 80 21 8F BF 00 2C 8F B3 00 28 02 00 20 21 02 40 28 21 8F B0 00 1C 8F B2 00 24 02 20 30 21 8F 99 ?? ?? 8F B1 00 20 ?? ?? ?? ?? 27 BD 00 30 8C C4 00 10 8C D3 00 0C 8C C3 00 04 24 02 FF FE 14 62 00 0B 02 64 98 23 02 65 10 2B 8F 99 ?? ?? 00 A2 98 0A 02 60 30 21 ?? ?? ?? ?? 02 40 28 21 8E 02 00 10 00 53 98 21 10 00 00 10 AE 13 00 10 02 65 98 2B 56 60 00 2C 8C C2 00 08 8F 99 ?? ?? 02 40 28 21 ?? ?? ?? ?? 02 20 30 21 8E 02 00 10 8F BC 00 10 00 51 10 21 AE 02 00 10 96 02 00 00 30 42 01 00 14 40 00 03 8F 99 ?? ?? 10 00 00 25 02 20 10 21 02 40 20 21 24 05 00 0A ?? ?? ?? ?? 02 20 30 21 10 40 FF F9 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 10 40 FF F4 8F BC 00 10 02 22 98 2B 02 33 10 0B 00 40 98 21 8F 99 ?? ?? 02 22 10 23 02 42 90 21 02 40 20 21 24 05 00 0A ?? ?? ?? ?? 02 60 30 21 10 40 FF E8 02 53 90 21 02 42 90 23 8E 02 00 10 00 52 10 23 AE 02 00 10 10 00 00 08 02 32 10 23 10 44 FF B6 8F 99 ?? ?? ?? ?? ?? ?? 00 C0 20 21 10 40 FF B2 8F BC 00 10 00 00 10 21 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_228_0_0 {
	meta:
		name = "bdflush"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 26 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_229_0_0 {
	meta:
		name = "__GI_fwrite_unlocked"
		size = 244
		refs = "0000 _gp_disp 0058 __stdio_trans2w_o 009c __stdio_fwrite 00bc __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 94 E3 00 00 27 BD FF D0 24 02 00 C0 30 63 00 C0 AF BC 00 10 AF B3 00 28 AF B2 00 24 AF B1 00 20 AF B0 00 1C AF BF 00 2C 00 80 98 21 00 A0 80 21 00 C0 90 21 14 62 00 05 00 E0 88 21 16 00 00 0B 00 00 10 21 10 00 00 22 8F BF 00 2C 8F 99 ?? ?? 00 E0 20 21 ?? ?? ?? ?? 24 05 00 80 10 40 FF F7 8F BC 00 10 10 00 00 19 00 00 10 21 12 40 00 16 24 02 FF FF 00 50 00 1B 02 00 01 F4 00 00 10 12 00 52 10 2B 54 40 00 0A 96 22 00 00 72 12 28 02 8F 99 ?? ?? 02 60 20 21 ?? ?? ?? ?? 02 20 30 21 00 50 00 1B 02 00 01 F4 10 00 00 08 00 00 10 12 8F 99 ?? ?? 34 42 00 08 ?? ?? ?? ?? A6 22 00 00 24 03 00 16 AC 43 00 00 00 00 10 21 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_230_0_0 {
	meta:
		name = "mallopt"
		size = 324
		refs = "0000 _gp_disp 0010 __malloc_lock 0014 _pthread_cleanup_push_defer 0020 __pthread_mutex_unlock 004c __pthread_mutex_lock 005c __malloc_state 0060 __malloc_consolidate 0118 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 8F 86 ?? ?? 8F 99 ?? ?? AF B0 00 28 00 A0 80 21 8F 85 ?? ?? AF B2 00 30 27 B2 00 18 AF BF 00 34 AF BC 00 10 AF B1 00 2C 00 80 88 21 ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 26 24 00 04 2C 82 00 06 10 40 00 27 8F BC 00 10 8F 82 ?? ?? 00 04 20 80 24 42 ?? ?? 00 44 20 21 8C 82 00 00 00 5C 10 21 00 40 00 08 00 00 00 00 2E 02 00 51 10 40 00 1D 00 00 88 21 12 00 00 07 24 02 00 08 26 10 00 0B 2E 03 00 10 14 60 00 03 24 02 00 10 24 02 FF F8 02 02 10 24 8F 83 ?? ?? 8C 64 00 00 30 84 00 03 00 44 10 25 10 00 00 0C AC 62 00 00 8F 82 ?? ?? 10 00 00 09 AC 50 03 44 8F 82 ?? ?? 10 00 00 06 AC 50 03 48 8F 82 ?? ?? 10 00 00 03 AC 50 03 4C 8F 82 ?? ?? AC 50 03 54 10 00 00 02 24 11 00 01 00 00 88 21 8F 99 ?? ?? 02 40 20 21 ?? ?? ?? ?? 24 05 00 01 8F BF 00 34 02 20 10 21 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_231_0_0 {
	meta:
		name = "__GI_getnameinfo"
		size = 848
		refs = "0000 _gp_disp 000c __GI___errno_location 00d0 __GI_gethostbyaddr 00fc __GI_getdomainname 0124 __GI_strstr 0168 __GI_strncpy 01c0 __GI_uname 01e8 $LC2 0248 $LC0 0254 $LC1 025c __GI_getservbyport 0294 __GI_snprintf 028c $LC3 02f8 __GI_inet_ntop"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FE 30 AF BC 00 10 AF BE 01 C8 AF B7 01 C4 AF B6 01 C0 AF B5 01 BC AF B4 01 B8 AF B3 01 B4 AF B2 01 B0 AF B1 01 AC AF B0 01 A8 8F B2 01 E8 AF BF 01 CC 00 80 98 21 00 A0 F0 21 00 C0 88 21 00 E0 80 21 8F B4 01 E0 ?? ?? ?? ?? 8F B5 01 E4 00 40 B0 21 8C 57 00 00 24 02 FF E0 02 42 10 24 14 40 00 9B 8F BC 00 10 12 60 00 A9 24 02 FF FA 2F C2 00 02 14 40 00 98 24 03 00 01 96 62 00 00 10 43 00 05 24 03 00 02 14 43 00 93 2F DE 00 10 57 C0 00 9F 24 02 FF FA 12 20 00 59 00 00 00 00 12 00 00 57 24 03 00 01 10 43 00 3E 24 03 00 02 14 43 00 53 32 42 00 01 14 40 00 8A 32 42 00 08 8F 99 ?? ?? 26 64 00 04 24 05 00 04 ?? ?? ?? ?? 24 06 00 02 00 40 F0 21 10 40 00 81 8F BC 00 10 32 42 00 04 10 40 00 2D 02 20 20 21 8F 99 ?? ?? 27 A6 00 18 00 C0 20 21 AF A6 01 A0 ?? ?? ?? ?? 24 05 01 00 8F BC 00 10 14 40 00 23 8F A6 01 A0 8F C3 00 00 8F 99 ?? ?? 00 C0 28 21 00 60 20 21 ?? ?? ?? ?? AF A3 01 A0 8F BC 00 10 10 40 00 1A 8F A3 01 A0 10 43 00 19 02 20 20 21 80 45 FF FF 24 04 00 2E 14 A4 00 15 02 20 20 21 24 47 FF FF 00 E3 10 23 02 02 30 2B 8F 99 ?? ?? 02 06 10 0B 00 60 28 21 AF A7 01 A0 ?? ?? ?? ?? 00 40 30 21 8F C2 00 00 8F A7 01 A0 26 03 FF FF 8F BC 00 10 00 E2 38 23 00 67 10 2B 00 62 38 0B 02 27 38 21 10 00 00 1B A0 E0 00 00 02 20 20 21 10 00 00 14 8F C5 00 00 32 42 00 01 14 40 00 0A 32 42 00 08 8F 99 ?? ?? ?? ?? ?? ?? 27 A4 00 18 14 40 00 04 8F BC 00 10 02 20 20 21 10 00 00 09 27 A5 00 59 32 42 00 08 10 40 00 04 8F 85 ?? ?? AE D7 00 00 10 00 00 4B 24 02 FF FE 02 20 20 21 24 A5 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 02 00 30 21 8F BC 00 10 12 80 00 25 00 00 00 00 12 A0 00 23 24 02 00 01 96 63 00 00 14 62 00 04 32 42 00 02 02 80 20 21 10 00 00 11 26 65 00 02 14 40 00 14 32 52 00 10 12 40 00 04 96 64 00 02 8F 85 ?? ?? 10 00 00 03 24 A5 ?? ?? 8F 85 ?? ?? 24 A5 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 40 00 08 8F BC 00 10 8C 45 00 00 02 80 20 21 8F 99 ?? ?? ?? ?? ?? ?? 02 A0 30 21 10 00 00 08 00 00 00 00 8F 86 ?? ?? 96 67 00 02 8F 99 ?? ?? 02 80 20 21 02 A0 28 21 ?? ?? ?? ?? 24 C6 ?? ?? 12 20 00 04 00 00 00 00 12 00 00 02 02 30 80 21 A2 00 FF FF 52 80 00 06 AE D7 00 00 52 A0 00 04 AE D7 00 00 02 95 A0 21 A2 80 FF FF AE D7 00 00 10 00 00 11 00 00 10 21 10 00 00 0F 24 02 FF FF 10 00 00 0D 24 02 FF FA 32 42 00 08 14 40 FF BD 8F 99 ?? ?? 24 04 00 02 26 65 00 04 02 20 30 21 ?? ?? ?? ?? 02 00 38 21 14 40 FF BF 8F BC 00 10 AE D7 00 00 24 02 FF F5 8F BF 01 CC 8F BE 01 C8 8F B7 01 C4 8F B6 01 C0 8F B5 01 BC 8F B4 01 B8 8F B3 01 B4 8F B2 01 B0 8F B1 01 AC 8F B0 01 A8 03 E0 00 08 27 BD 01 D0 }
	condition:
		$1
}

rule file_232_0_0 {
	meta:
		name = "__GI_readdir_r"
		size = 344
		refs = "0000 _gp_disp 0010 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 0060 __pthread_mutex_lock 0070 __getdents 00b0 __GI___errno_location 00fc __GI_memcpy 011c _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 8F 99 ?? ?? AF B4 00 3C 00 A0 A0 21 8F 85 ?? ?? AF B2 00 34 AF B1 00 30 27 B2 00 18 24 91 00 18 AF BC 00 10 AF BF 00 44 AF B5 00 40 AF B3 00 38 AF B0 00 2C 00 C0 98 21 00 80 80 21 02 20 30 21 ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 02 20 20 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 88 21 8F BC 00 10 8F 95 ?? ?? 8E 03 00 08 8E 02 00 04 00 43 10 2B 54 40 00 14 8E 02 00 04 8E 04 00 00 8E 05 00 0C 02 A0 C8 21 ?? ?? ?? ?? 8E 06 00 14 1C 40 00 0A 8F BC 00 10 AE 60 00 00 10 40 00 1C 00 00 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8C 50 00 00 10 00 00 16 8F BC 00 10 AE 02 00 08 AE 00 00 04 8E 02 00 04 8E 11 00 0C 02 22 88 21 96 23 00 08 00 62 10 21 AE 02 00 04 8E 22 00 04 AE 02 00 10 8E 22 00 00 50 40 FF E0 8E 03 00 08 8F 99 ?? ?? 96 26 00 08 02 80 20 21 ?? ?? ?? ?? 02 20 28 21 8F BC 00 10 AE 74 00 00 00 00 80 21 8F 99 ?? ?? 02 40 20 21 ?? ?? ?? ?? 24 05 00 01 8F BF 00 44 00 00 10 21 02 11 10 0A 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_233_0_0 {
	meta:
		name = "__GI_isalpha"
		size = 40
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 00 04 20 40 8C 42 00 00 00 44 10 21 94 42 00 00 03 E0 00 08 30 42 00 04 }
	condition:
		$1
}

rule file_234_0_0 {
	meta:
		name = "__GI_setpriority"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 01 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_235_0_0 {
	meta:
		name = "lchown"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F B0 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_236_0_0 {
	meta:
		name = "dysize"
		size = 68
	strings:
		$1 = { 30 83 00 03 14 60 00 0D 24 02 01 6D 24 02 00 64 00 82 00 1A 00 40 01 F4 00 00 18 10 14 60 00 07 24 02 01 6E 24 03 01 90 00 83 00 1A 00 60 01 F4 24 05 01 6D 00 00 30 10 00 A6 10 0B 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_237_0_0 {
	meta:
		name = "__GI_strcmp"
		size = 48
	strings:
		$1 = { 90 83 00 00 24 87 00 01 24 A6 00 01 14 60 00 03 90 A2 00 00 03 E0 00 08 00 02 10 23 00 E0 20 21 10 62 FF F7 00 C0 28 21 03 E0 00 08 00 62 10 23 }
	condition:
		$1
}

rule file_238_0_0 {
	meta:
		name = "__GI_localtime"
		size = 60
		refs = "0000 _gp_disp 000c __time_tm 0010 __GI_localtime_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 85 ?? ?? 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F BF 00 1C 27 BD 00 20 03 E0 00 08 8F 82 ?? ?? }
	condition:
		$1
}

rule file_239_0_0 {
	meta:
		name = "_ppfs_setargs"
		size = 412
	strings:
		$1 = { 8C 86 00 18 24 85 00 50 8C 83 00 08 14 C0 00 46 8C 82 00 04 3C 06 80 00 14 66 00 08 3C 03 80 00 8C 83 00 4C 24 66 00 04 AC 86 00 4C 8C 63 00 00 AC 83 00 50 AC 83 00 08 3C 03 80 00 14 43 00 08 00 00 10 21 8C 82 00 4C 24 43 00 04 AC 83 00 4C 8C 42 00 00 AC 82 00 50 AC 82 00 04 00 00 10 21 24 07 00 08 24 08 04 00 24 09 08 00 24 06 FF F8 24 0A 08 07 24 0D 00 02 24 0E 00 07 8C 83 00 1C 00 43 18 2A 10 60 00 38 24 4F 00 01 24 42 00 0A 00 02 10 80 00 82 10 21 8C 42 00 00 10 47 00 20 28 58 00 09 13 00 00 09 8C 83 00 4C 10 4D 00 17 28 58 00 03 57 00 00 16 24 62 00 04 50 4E 00 0C 24 63 00 07 10 00 00 12 24 62 00 04 10 48 00 0F 28 58 04 01 57 00 00 0E 24 62 00 04 50 49 00 04 24 63 00 07 54 4A 00 0A 24 62 00 04 24 63 00 07 00 66 18 24 24 62 00 08 AC 82 00 4C 8C 62 00 00 8C 63 00 04 10 00 00 04 AC A3 00 04 24 62 00 04 AC 82 00 4C 8C 62 00 00 AC A2 00 00 24 A5 00 08 10 00 FF D6 01 E0 10 21 3C 06 80 00 14 66 00 07 3C 03 80 00 90 83 00 24 00 03 18 C0 00 A3 18 21 8C 63 FF F8 AC 83 00 08 3C 03 80 00 54 43 00 07 8C 82 00 08 90 82 00 25 00 02 10 C0 00 A2 28 21 8C A2 FF F8 AC 82 00 04 8C 82 00 08 04 41 00 09 00 02 10 23 AC 82 00 08 8C 82 00 10 24 03 FF FE 00 62 10 24 34 42 00 08 AC 82 00 10 24 02 00 20 AC 82 00 14 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_241_0_0 {
	meta:
		name = "hsearch"
		size = 72
		refs = "0000 _gp_disp 0010 __GI_hsearch_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 27 BD FF D0 24 42 ?? ?? AF BF 00 2C AF BC 00 18 AF A4 00 30 AF A5 00 34 AF A2 00 10 ?? ?? ?? ?? 27 A7 00 20 8F BF 00 2C 8F A2 00 20 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_242_0_0 {
	meta:
		name = "putw"
		size = 68
		refs = "0000 _gp_disp 000c __GI_fwrite_unlocked"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 00 A0 38 21 24 05 00 04 AF BF 00 1C AF BC 00 10 AF A4 00 20 24 06 00 01 ?? ?? ?? ?? 27 A4 00 20 8F BF 00 1C 24 42 FF FF 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_243_0_0 {
	meta:
		name = "__GI_tcsetattr"
		size = 404
		refs = "0000 _gp_disp 0054 __GI___errno_location 0084 __GI_memcpy 00d0 __GI_ioctl"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A0 24 02 54 0F AF BC 00 10 AF B5 00 54 AF B0 00 40 AF BF 00 5C AF B6 00 58 AF B4 00 50 AF B3 00 4C AF B2 00 48 AF B1 00 44 00 80 A8 21 10 A2 00 0F 00 C0 80 21 24 02 54 10 10 A2 00 08 24 02 54 0E 10 A2 00 08 8F 99 ?? ?? ?? ?? ?? ?? 24 11 FF FF 24 03 00 16 10 00 00 40 AC 43 00 00 10 00 00 04 24 12 54 10 10 00 00 02 24 12 54 0E 24 12 54 0F 8E 02 00 00 8F 99 ?? ?? 27 A4 00 29 7C 42 F0 00 AF A2 00 18 8E 02 00 04 26 05 00 11 24 06 00 17 AF A2 00 1C 8E 02 00 08 27 B4 00 18 AF A2 00 20 8E 02 00 0C AF A2 00 24 92 02 00 10 ?? ?? ?? ?? A3 A2 00 28 8F BC 00 10 02 A0 20 21 02 40 28 21 8F 93 ?? ?? 02 60 C8 21 ?? ?? ?? ?? 02 80 30 21 00 40 88 21 14 40 00 20 8F BC 00 10 24 02 54 0E 12 42 00 03 8F 99 ?? ?? 10 00 00 1B 00 00 88 21 ?? ?? ?? ?? 00 00 00 00 02 A0 20 21 24 05 54 0D 02 80 30 21 02 60 C8 21 00 40 90 21 ?? ?? ?? ?? 8C 56 00 00 50 40 00 03 8E 03 00 08 10 00 00 0E AE 56 00 00 8F A2 00 20 00 62 10 26 30 44 01 80 54 80 00 07 24 02 00 16 30 63 00 30 10 60 00 06 00 00 88 21 30 42 00 30 10 40 00 03 24 02 00 16 AE 42 00 00 24 11 FF FF 8F BF 00 5C 02 20 10 21 8F B6 00 58 8F B5 00 54 8F B4 00 50 8F B3 00 4C 8F B2 00 48 8F B1 00 44 8F B0 00 40 03 E0 00 08 27 BD 00 60 }
	condition:
		$1
}

rule file_244_0_0 {
	meta:
		name = "__GI_fseeko64"
		size = 348
		refs = "0000 _gp_disp 003c __GI___errno_location 0060 _pthread_cleanup_push_defer 0064 __pthread_mutex_unlock 007c __pthread_mutex_lock 0098 __stdio_wcommit 00ac __stdio_adjust_position 00dc __stdio_seek 012c _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B1 00 38 8F B1 00 58 AF BC 00 10 AF BF 00 44 2E 22 00 03 AF B3 00 40 AF B2 00 3C AF B0 00 34 AF A7 00 2C 14 40 00 07 AF A6 00 28 8F 99 ?? ?? ?? ?? ?? ?? 24 10 FF FF 24 03 00 16 10 00 00 3B AC 43 00 00 8C 92 00 34 16 40 00 0C 00 80 80 21 8F 99 ?? ?? 8F 85 ?? ?? 24 93 00 38 02 60 30 21 ?? ?? ?? ?? 27 A4 00 18 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 8F BC 00 10 96 02 00 00 30 42 00 40 14 40 00 06 8F 99 ?? ?? 24 02 00 01 16 22 00 0E 27 B3 00 28 10 00 00 07 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 10 40 FF F8 8F BC 00 10 10 00 00 18 24 10 FF FF 02 00 20 21 ?? ?? ?? ?? 02 60 28 21 04 40 FF FA 8F BC 00 10 8F 99 ?? ?? 02 00 20 21 02 60 28 21 ?? ?? ?? ?? 02 20 30 21 04 40 FF F3 8F BC 00 10 96 02 00 00 AE 00 00 2C A2 00 00 02 30 42 FF B8 A6 02 00 00 8E 02 00 08 AE 02 00 10 AE 02 00 14 AE 02 00 18 AE 02 00 1C 00 00 80 21 16 40 00 06 8F BF 00 44 8F 99 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F BF 00 44 02 00 10 21 8F B3 00 40 8F B2 00 3C 8F B1 00 38 8F B0 00 34 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_245_0_0 {
	meta:
		name = "__fpurge"
		size = 48
	strings:
		$1 = { 8C 82 00 08 AC 80 00 28 AC 80 00 2C AC 82 00 18 AC 82 00 1C AC 82 00 10 AC 82 00 14 94 82 00 00 A0 80 00 02 30 42 FF BC 03 E0 00 08 A4 82 00 00 }
	condition:
		$1
}

rule file_248_0_0 {
	meta:
		name = "wctomb"
		size = 36
		refs = "0000 _gp_disp 0010 __GI_wcrtomb"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 10 80 00 03 8F 99 ?? ?? ?? ?? ?? ?? 00 00 30 21 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_250_0_0 {
	meta:
		name = "gets"
		size = 252
		refs = "0000 _gp_disp 0014 stdin 0044 _pthread_cleanup_push_defer 0048 __pthread_mutex_unlock 0060 __pthread_mutex_lock 0070 __GI_getchar_unlocked 00c4 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B0 00 2C 8F 90 ?? ?? AF B1 00 30 AF BC 00 10 AF BF 00 44 AF B5 00 40 AF B4 00 3C AF B3 00 38 AF B2 00 34 8E 06 00 00 8C D2 00 34 16 40 00 0C 00 80 88 21 8F 99 ?? ?? 8F 85 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 24 C6 00 38 8F BC 00 10 8E 04 00 00 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 38 8F BC 00 10 8F 93 ?? ?? 02 20 80 21 24 15 FF FF 24 14 00 0A 02 60 C8 21 ?? ?? ?? ?? 00 00 00 00 14 55 00 03 8F BC 00 10 10 00 00 09 00 00 88 21 7C 02 14 20 10 54 00 03 A2 02 00 00 10 00 FF F5 26 10 00 01 52 30 00 02 00 00 88 21 A2 00 00 00 16 40 00 06 8F BF 00 44 8F 99 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F BF 00 44 02 20 10 21 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_251_0_0 {
	meta:
		name = "wcpncpy"
		size = 52
	strings:
		$1 = { 00 80 38 21 00 A0 18 21 10 C0 00 07 24 68 00 04 8C 62 00 00 24 E7 00 04 AC E2 FF FC 01 02 18 0B 10 00 FF F9 24 C6 FF FF 00 65 10 23 03 E0 00 08 00 82 10 21 }
	condition:
		$1
}

rule file_252_0_0 {
	meta:
		name = "__GI_isblank"
		size = 40
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 00 04 20 40 8C 42 00 00 00 44 10 21 94 42 00 00 03 E0 00 08 30 42 01 00 }
	condition:
		$1
}

rule file_254_0_0 {
	meta:
		name = "putwchar"
		size = 84
		refs = "0000 _gp_disp 000c stdout 0030 __GI___fputc_unlocked 0048 __GI_fputc"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 83 ?? ?? 8C 65 00 00 8C A3 00 34 10 60 00 0B 00 80 10 21 8C A3 00 10 8C A6 00 1C 00 66 30 2B 10 C0 00 07 8F 99 ?? ?? 24 64 00 01 AC A4 00 10 A0 62 00 00 03 E0 00 08 30 42 00 FF 8F 99 ?? ?? 03 20 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_255_0_0 {
	meta:
		name = "setbuf"
		size = 32
		refs = "0000 _gp_disp 000c __GI_setvbuf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 24 06 00 02 00 05 30 0B ?? ?? ?? ?? 24 07 10 00 }
	condition:
		$1
}

rule file_257_0_0 {
	meta:
		name = "tee"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 D2 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_258_0_0 {
	meta:
		name = "symlink"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F F3 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_259_0_0 {
	meta:
		name = "__GI_sigsetmask"
		size = 76
		refs = "0000 _gp_disp 0010 __GI_sigprocmask"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 8F 99 ?? ?? 27 A5 00 28 AF BC 00 10 AF BF 00 3C 27 A6 00 18 AC A0 00 04 AC A0 00 08 AC A0 00 0C AF A4 00 28 ?? ?? ?? ?? 24 04 00 03 8F BF 00 3C 8F A2 00 18 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_260_0_0 {
	meta:
		name = "__GI_wmemcpy"
		size = 44
	strings:
		$1 = { 00 80 10 21 00 80 18 21 10 C0 00 06 24 C6 FF FF 8C A4 00 00 24 A5 00 04 AC 64 00 00 10 00 FF FA 24 63 00 04 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_261_0_0 {
	meta:
		name = "__GI_xdr_pmap"
		size = 176
		refs = "0000 _gp_disp 0014 __GI_xdr_u_long"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B0 00 18 8F 90 ?? ?? AF B2 00 20 AF B1 00 1C AF BC 00 10 AF BF 00 24 02 00 C8 21 00 80 90 21 ?? ?? ?? ?? 00 A0 88 21 10 40 00 17 8F BF 00 24 02 40 20 21 02 00 C8 21 ?? ?? ?? ?? 26 25 00 04 10 40 00 11 8F BF 00 24 02 40 20 21 02 00 C8 21 ?? ?? ?? ?? 26 25 00 08 10 40 00 0A 8F BC 00 10 8F BF 00 24 02 40 20 21 26 25 00 0C 8F B2 00 20 8F B1 00 1C 02 00 C8 21 8F B0 00 18 ?? ?? ?? ?? 27 BD 00 28 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 00 00 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_262_0_0 {
	meta:
		name = "__GI_sigblock"
		size = 76
		refs = "0000 _gp_disp 0010 __GI_sigprocmask"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 8F 99 ?? ?? 27 A5 00 28 AF BC 00 10 AF BF 00 3C 27 A6 00 18 AC A0 00 04 AC A0 00 08 AC A0 00 0C AF A4 00 28 ?? ?? ?? ?? 24 04 00 01 8F BF 00 3C 8F A2 00 18 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_263_0_0 {
	meta:
		name = "__GI_dirfd"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF B0 00 18 8C 90 00 00 AF BC 00 10 24 02 FF FF AF BF 00 1C 16 02 00 07 8F BF 00 1C 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 09 AC 43 00 00 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_264_0_0 {
	meta:
		name = "ftime"
		size = 132
		refs = "0000 _gp_disp 000c __GI_gettimeofday"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D0 27 A5 00 18 AF B0 00 28 AF BC 00 10 AF BF 00 2C 00 80 80 21 ?? ?? ?? ?? 27 A4 00 20 04 40 00 0F 8F A2 00 20 8F A3 00 24 AE 02 00 00 24 63 03 E7 24 02 03 E8 00 62 00 1A 00 40 01 F4 00 00 10 12 A6 02 00 04 8F A2 00 18 A6 02 00 06 8F A2 00 1C A6 02 00 08 10 00 00 02 00 00 10 21 24 02 FF FF 8F BF 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_265_0_0 {
	meta:
		name = "__libc_pselect"
		size = 236
		refs = "0000 _gp_disp 0068 __GI_sigprocmask 0088 __GI_select"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A8 AF B0 00 40 8F B0 00 68 AF BC 00 18 AF B4 00 50 AF B3 00 4C AF B2 00 48 AF B1 00 44 AF BF 00 54 00 80 A0 21 00 A0 98 21 00 C0 90 21 12 00 00 09 8F B1 00 6C 8E 02 00 00 8E 03 00 04 AF A2 00 30 24 02 03 E8 00 62 00 1A 00 40 01 F4 00 00 10 12 AF A2 00 34 12 20 00 08 8F 99 ?? ?? AF A7 00 38 24 04 00 03 02 20 28 21 ?? ?? ?? ?? 27 A6 00 20 8F BC 00 18 8F A7 00 38 8F 99 ?? ?? 27 A2 00 30 00 10 10 0A AF A2 00 10 02 80 20 21 02 60 28 21 ?? ?? ?? ?? 02 40 30 21 00 40 80 21 12 20 00 06 8F BC 00 18 8F 99 ?? ?? 24 04 00 03 27 A5 00 20 ?? ?? ?? ?? 00 00 30 21 8F BF 00 54 02 00 10 21 8F B4 00 50 8F B3 00 4C 8F B2 00 48 8F B1 00 44 8F B0 00 40 03 E0 00 08 27 BD 00 58 }
	condition:
		$1
}

rule file_268_1_0 {
	meta:
		name = "_stdio_term"
		size = 268
		refs = "0000 _gp_disp 0014 __stdio_init_mutex 0018 _stdio_openlist_add_lock 004c _stdio_openlist_del_lock 005c _stdio_openlist 006c __pthread_mutex_trylock 00bc __stdio_wcommit"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B1 00 20 8F 91 ?? ?? 8F 84 ?? ?? AF BC 00 10 AF BF 00 34 AF B5 00 30 AF B4 00 2C AF B3 00 28 AF B0 00 1C 02 20 C8 21 AF B2 00 24 ?? ?? ?? ?? 24 14 00 30 8F BC 00 10 02 20 C8 21 8F 84 ?? ?? ?? ?? ?? ?? 24 15 00 01 8F BC 00 10 8F 82 ?? ?? 8C 50 00 00 00 40 98 21 12 00 00 13 8F 99 ?? ?? 26 12 00 38 ?? ?? ?? ?? 02 40 20 21 50 40 00 08 AE 15 00 34 8E 02 00 08 A6 14 00 00 AE 02 00 18 AE 02 00 1C AE 02 00 10 AE 02 00 14 AE 15 00 34 02 20 C8 21 ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 10 00 FF ED 8E 10 00 20 8E 70 00 00 8F 91 ?? ?? 12 00 00 0A 8F BF 00 34 96 02 00 00 30 42 00 40 50 40 FF FB 8E 10 00 20 02 20 C8 21 ?? ?? ?? ?? 02 00 20 21 10 00 FF F6 8E 10 00 20 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_268_2_0 {
	meta:
		name = "_stdio_init"
		size = 168
		refs = "0000 _gp_disp 000c __GI___errno_location 003c __GI_isatty"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BC 00 10 AF BF 00 24 AF B2 00 20 AF B1 00 1C AF B0 00 18 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 00 00 20 21 00 40 80 21 8F 91 ?? ?? 02 20 C8 21 ?? ?? ?? ?? 8C 52 00 00 8F BC 00 10 14 40 00 05 02 20 C8 21 8F 82 ?? ?? 94 43 ?? ?? 38 63 01 00 A4 43 ?? ?? ?? ?? ?? ?? 24 04 00 01 14 40 00 06 8F BC 00 10 8F 82 ?? ?? 24 42 ?? ?? 94 43 00 50 38 63 01 00 A4 43 00 50 AE 12 00 00 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_270_0_0 {
	meta:
		name = "__get_hosts_byname_r"
		size = 100
		refs = "0000 _gp_disp 0018 __read_etc_hosts_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 00 80 18 21 8F A4 00 48 8F 99 ?? ?? 00 A0 10 21 AF A4 00 18 8F A4 00 4C AF BF 00 34 AF BC 00 28 AF A4 00 1C 8F A4 00 50 AF A6 00 10 AF A7 00 14 AF A4 00 20 00 60 28 21 00 00 20 21 00 40 30 21 ?? ?? ?? ?? 00 00 38 21 8F BF 00 34 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_271_0_0 {
	meta:
		name = "__get_hosts_byaddr_r"
		size = 188
		refs = "0000 _gp_disp 0028 __GI_inet_ntop 006c __read_etc_hosts_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 24 02 00 02 14 C2 00 26 00 80 18 21 24 04 00 04 14 A4 00 25 00 00 10 21 27 BD FF B0 8F 99 ?? ?? AF B0 00 44 27 B0 00 30 AF BF 00 4C AF B1 00 48 AF BC 00 28 00 60 28 21 00 E0 88 21 02 00 30 21 24 04 00 02 ?? ?? ?? ?? 24 07 00 10 8F A2 00 60 8F BC 00 28 AF B1 00 10 AF A2 00 14 8F A2 00 64 8F 99 ?? ?? 02 00 28 21 AF A2 00 18 8F A2 00 68 00 00 20 21 24 06 00 02 AF A2 00 1C 8F A2 00 6C 24 07 00 02 ?? ?? ?? ?? AF A2 00 20 8F BF 00 4C 8F B1 00 48 8F B0 00 44 10 00 00 03 27 BD 00 50 03 E0 00 08 00 00 10 21 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_273_0_0 {
	meta:
		name = "_dl_aux_init"
		size = 40
		refs = "0000 _gp_disp 0010 _dl_phdr 001c _dl_phnum"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8C 83 00 1C 8F 82 ?? ?? AC 43 00 00 8C 83 00 2C 8F 82 ?? ?? 03 E0 00 08 AC 43 00 00 }
	condition:
		$1
}

rule file_274_0_0 {
	meta:
		name = "__wcstofpmax"
		size = 1164
		refs = "0000 _gp_disp 0014 __GI_iswspace 0098 __GI___ctype_b 00a0 $LC0 0108 __muldf3 0144 __floatsidf 0160 __adddf3 0230 __divdf3 02d0 __eqdf2 0400 $LC1 0434 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A8 AF B1 00 34 8F 91 ?? ?? AF B5 00 44 AF B3 00 3C AF B2 00 38 AF BC 00 10 AF BF 00 54 AF BE 00 50 AF B7 00 4C AF B6 00 48 AF B4 00 40 AF B0 00 30 00 80 98 21 AF A5 00 5C 00 C0 90 21 00 80 A8 21 8E B0 00 00 02 20 C8 21 ?? ?? ?? ?? 02 00 20 21 10 40 00 03 8F BC 00 10 10 00 FF F9 26 B5 00 04 24 02 00 2B 12 02 00 05 24 02 00 2D 56 02 00 05 00 00 A0 21 10 00 00 02 24 14 00 01 00 00 A0 21 26 B5 00 04 8F 82 ?? ?? 8F 8B ?? ?? 24 1E FF FF 8C 51 ?? ?? 8C 50 ?? ?? 00 00 48 21 00 00 B0 21 00 00 B8 21 24 0C FF FF 24 0D 00 30 24 0E 00 2E 8E A8 00 00 8D 65 00 00 00 08 10 40 00 A2 10 21 94 42 00 00 30 42 00 08 10 40 00 2F 00 00 00 00 13 CC 00 03 00 00 00 00 57 C0 00 04 27 DE 00 01 11 0D 00 27 00 00 F0 21 27 DE 00 01 2B C2 00 12 50 40 FF EF 26 B5 00 04 8F 99 ?? ?? 02 E0 28 21 AF A9 00 1C AF AB 00 20 AF AC 00 24 AF AD 00 28 AF AE 00 2C 02 C0 20 21 02 20 38 21 02 00 30 21 ?? ?? ?? ?? AF A8 00 18 8F BC 00 10 8F A8 00 18 00 60 B8 21 8F 99 ?? ?? 25 04 FF D0 ?? ?? ?? ?? 00 40 B0 21 8F BC 00 10 02 E0 28 21 02 C0 20 21 8F 99 ?? ?? 00 60 38 21 ?? ?? ?? ?? 00 40 30 21 8F BC 00 10 8F A9 00 1C 8F AB 00 20 8F AC 00 24 8F AD 00 28 8F AE 00 2C 00 40 B0 21 00 60 B8 21 10 00 FF CB 26 B5 00 04 15 0E 00 06 24 02 FF FF 15 20 00 3B 00 00 00 00 26 B5 00 04 10 00 FF C4 02 A0 48 21 17 C2 00 38 2B C2 00 12 15 20 00 A3 8F B9 00 5C 8F 84 ?? ?? 00 00 80 21 24 84 ?? ?? 00 80 18 21 00 00 10 21 26 05 00 01 00 02 30 80 02 A6 30 21 8C C7 00 00 00 A2 30 21 00 C4 30 21 80 C6 00 00 34 E7 00 20 14 E6 00 1C 00 60 88 21 24 42 00 01 00 A2 30 21 00 C4 30 21 80 C6 00 00 54 C0 FF F3 00 02 30 80 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 00 60 28 21 00 40 20 21 8F 99 ?? ?? 00 00 38 21 ?? ?? ?? ?? 00 00 30 21 00 40 B0 21 12 80 00 03 00 60 B8 21 3C 16 80 00 02 C2 B0 26 02 30 80 21 82 13 00 00 00 13 98 80 26 73 FF F8 10 00 00 78 02 B3 98 21 02 03 10 21 80 42 00 00 02 02 80 21 02 03 10 21 80 42 00 00 14 40 FF D5 00 00 10 21 10 00 00 70 8F B9 00 5C 13 C2 00 6D 2B C2 00 12 14 40 00 03 02 A0 98 21 27 DE FF EF 02 5E 90 21 11 20 00 03 01 35 48 23 00 09 48 83 02 49 90 21 12 80 00 03 35 08 00 20 3C 02 80 00 00 56 B0 26 24 02 00 65 15 02 00 22 8F 99 ?? ?? 8E A2 00 04 24 03 00 2B 10 43 00 06 24 03 00 2D 50 43 00 05 24 04 FF FF 26 B3 00 04 10 00 00 03 24 04 00 01 24 04 00 01 26 B3 00 08 02 60 10 21 00 00 18 21 24 08 00 0A 8C 46 00 00 00 06 38 40 00 A7 38 21 94 E7 00 00 30 E7 00 08 10 E0 00 07 28 67 01 55 10 E0 FF F8 24 42 00 04 70 68 38 02 24 C6 FF D0 10 00 FF F4 00 E6 18 21 00 53 98 26 02 B3 10 0A 00 40 98 21 70 83 10 02 00 52 90 21 8F 99 ?? ?? 02 C0 20 21 02 E0 28 21 00 00 38 21 ?? ?? ?? ?? 00 00 30 21 10 40 00 36 8F BC 00 10 00 12 17 C3 00 52 A8 26 02 A2 A8 23 8F 82 ?? ?? 8C 51 ?? ?? 8C 50 ?? ?? 12 A0 00 19 32 A2 00 01 10 40 00 0D 8F 99 ?? ?? 06 41 00 03 02 C0 20 21 10 00 00 01 8F 99 ?? ?? 02 E0 28 21 02 20 38 21 03 20 F8 09 02 00 30 21 8F BC 00 10 00 40 B0 21 00 60 B8 21 8F 99 ?? ?? 02 20 28 21 02 00 20 21 02 20 38 21 ?? ?? ?? ?? 02 00 30 21 00 15 A8 43 8F BC 00 10 00 60 88 21 10 00 FF E7 00 40 80 21 8F 82 ?? ?? 8F 99 ?? ?? 02 C0 20 21 8C 47 ?? ?? 8C 46 ?? ?? ?? ?? ?? ?? 02 E0 28 21 8F BC 00 10 02 C0 20 21 02 E0 28 21 8F 99 ?? ?? 00 60 38 21 ?? ?? ?? ?? 00 40 30 21 14 40 00 06 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 22 AC 43 00 00 8F B9 00 5C 57 20 00 01 AF 33 00 00 8F BF 00 54 02 C0 10 21 02 E0 18 21 8F BE 00 50 8F B7 00 4C 8F B6 00 48 8F B5 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 58 }
	condition:
		$1
}

rule file_275_0_0 {
	meta:
		name = "readahead"
		size = 104
		refs = "0000 _gp_disp 0040 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 00 00 28 21 8F A2 00 30 27 BD FF E0 AF A2 00 10 24 02 10 7F 00 00 00 0C 27 BD 00 20 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_276_0_0 {
	meta:
		name = "delete_module"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 21 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_278_0_0 {
	meta:
		name = "__GI_mbsrtowcs"
		size = 72
		refs = "0000 _gp_disp 0028 __GI_mbsnrtowcs"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF BC 00 18 AF BF 00 24 14 E0 00 03 00 C0 10 21 8F 87 ?? ?? 24 E7 ?? ?? 8F 99 ?? ?? AF A7 00 10 24 06 FF FF ?? ?? ?? ?? 00 40 38 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_279_0_0 {
	meta:
		name = "__GI_ctime"
		size = 60
		refs = "0000 _gp_disp 000c __GI_localtime 0030 __GI_asctime"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BC 00 10 AF BF 00 1C ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F BF 00 1C 00 40 20 21 8F 99 ?? ?? ?? ?? ?? ?? 27 BD 00 20 }
	condition:
		$1
}

rule file_280_0_0 {
	meta:
		name = "socketpair"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 58 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_281_0_0 {
	meta:
		name = "sched_get_priority_max"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 43 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_282_0_0 {
	meta:
		name = "capget"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 6C 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_283_0_0 {
	meta:
		name = "__GI_close"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F A6 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_284_0_0 {
	meta:
		name = "__GI_lstat64"
		size = 120
		refs = "0000 _gp_disp 0034 __GI___errno_location 0054 __xstat64_conv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 78 AF BC 00 10 00 A0 30 21 AF BF 00 84 AF B0 00 80 27 A5 00 18 24 02 10 76 00 00 00 0C 10 E0 00 07 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 10 00 00 07 24 10 FF FF 14 40 00 06 8F BF 00 84 8F 99 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 00 C0 28 21 8F BF 00 84 02 00 10 21 8F B0 00 80 03 E0 00 08 27 BD 00 88 }
	condition:
		$1
}

rule file_285_0_0 {
	meta:
		name = "__GI_fwrite"
		size = 200
		refs = "0000 _gp_disp 0040 _pthread_cleanup_push_defer 0044 __pthread_mutex_unlock 0060 __pthread_mutex_lock 0074 __GI_fwrite_unlocked 0090 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B4 00 40 AF B3 00 3C AF B2 00 38 AF BC 00 10 AF BF 00 44 AF B1 00 34 AF B0 00 30 8C F0 00 34 00 80 A0 21 00 A0 98 21 16 00 00 0E 00 C0 90 21 8F 99 ?? ?? 8F 85 ?? ?? 24 F1 00 38 AF A7 00 28 27 A4 00 18 ?? ?? ?? ?? 02 20 30 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8F A7 00 28 8F 99 ?? ?? 02 80 20 21 02 60 28 21 ?? ?? ?? ?? 02 40 30 21 16 00 00 07 8F BC 00 10 8F 99 ?? ?? AF A2 00 28 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F A2 00 28 8F BF 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_435_0_0 {
	meta:
		name = "__GI_fread"
		size = 200
		refs = "0000 _gp_disp 0040 _pthread_cleanup_push_defer 0044 __pthread_mutex_unlock 0060 __pthread_mutex_lock 0074 __GI_fread_unlocked 0090 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B4 00 40 AF B3 00 3C AF B2 00 38 AF BC 00 10 AF BF 00 44 AF B1 00 34 AF B0 00 30 8C F0 00 34 00 80 A0 21 00 A0 98 21 16 00 00 0E 00 C0 90 21 8F 99 ?? ?? 8F 85 ?? ?? 24 F1 00 38 AF A7 00 28 27 A4 00 18 ?? ?? ?? ?? 02 20 30 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8F A7 00 28 8F 99 ?? ?? 02 80 20 21 02 60 28 21 ?? ?? ?? ?? 02 40 30 21 16 00 00 07 8F BC 00 10 8F 99 ?? ?? AF A2 00 28 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F A2 00 28 8F BF 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_286_0_0 {
	meta:
		name = "__GI_recvfrom"
		size = 108
		refs = "0000 _gp_disp 0044 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF B0 00 18 AF BF 00 1C 8F B0 00 34 8F A2 00 30 27 BD FF E0 AF A2 00 10 AF B0 00 14 24 02 10 50 00 00 00 0C 27 BD 00 20 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_287_0_0 {
	meta:
		name = "statvfs64"
		size = 936
		refs = "0000 _gp_disp 000c __GI_statfs64 0060 __GI_memset 00ec __GI_stat64 0114 __GI___errno_location 0134 __GI_setmntent 012c $LC0 0144 $LC1 0154 $LC2 0174 __GI_getmntent_r 01e0 $LC11 01e4 $LC3 01e8 $LC4 01fc __GI_strsep 0218 __GI_strcmp 0264 $LC5 028c $LC6 02b4 $LC7 02dc $LC8 0304 $LC9 032c $LC10 0358 __GI_endmntent"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FA 00 AF BC 00 10 AF B1 05 DC AF B0 05 D8 AF BF 05 FC AF BE 05 F8 AF B7 05 F4 AF B6 05 F0 AF B5 05 EC AF B4 05 E8 AF B3 05 E4 AF B2 05 E0 00 A0 88 21 27 A5 05 58 ?? ?? ?? ?? 00 80 80 21 04 40 00 C6 8F BC 00 10 8F A2 05 5C 8F A3 05 6C 8F 99 ?? ?? AE 22 00 00 AE 22 00 04 8F A2 05 68 AE 23 00 0C 8F A3 05 74 AE 22 00 08 8F A2 05 70 AE 23 00 14 8F A3 05 8C AE 22 00 10 8F A2 05 88 AE 23 00 1C 8F A3 05 7C AE 22 00 18 8F A2 05 78 AE 23 00 24 8F A3 05 84 AE 22 00 20 8F A2 05 80 AE 23 00 2C 26 24 00 48 AE 22 00 28 8F A2 05 90 00 00 28 21 24 06 00 18 AE 22 00 38 8F A2 05 98 AE 20 00 3C ?? ?? ?? ?? AE 22 00 44 8F BC 00 10 8E 23 00 2C 8E 22 00 28 02 00 20 21 8F 90 ?? ?? AE 23 00 34 AE 22 00 30 AE 20 00 40 02 00 C8 21 ?? ?? ?? ?? 27 A5 04 B8 02 00 B8 21 04 40 00 99 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 00 40 A0 21 8C 55 00 00 8F 84 ?? ?? 8F 92 ?? ?? 8F 90 ?? ?? 24 84 ?? ?? 02 00 C8 21 ?? ?? ?? ?? 26 45 ?? ?? 00 40 98 21 14 40 00 09 8F BC 00 10 8F 84 ?? ?? 26 45 ?? ?? 02 00 C8 21 ?? ?? ?? ?? 24 84 ?? ?? 00 40 98 21 10 40 00 7D 8F BC 00 10 8F 92 ?? ?? 27 B0 05 B8 27 B6 00 18 27 BE 04 18 02 60 20 21 02 00 28 21 02 C0 30 21 02 40 C8 21 ?? ?? ?? ?? 24 07 04 00 10 40 00 6E 8F BC 00 10 8F A4 05 BC 02 E0 C8 21 ?? ?? ?? ?? 03 C0 28 21 04 40 FF F3 8F BC 00 10 8F A2 04 18 8F A3 04 B8 14 62 FF F0 02 60 20 21 8F A2 04 1C 8F A3 04 BC 14 62 FF ED 02 00 28 21 8F A2 05 C4 8F 96 ?? ?? 8F 97 ?? ?? 8F 9E ?? ?? AF A2 05 D0 26 D6 ?? ?? 26 F7 ?? ?? 27 DE ?? ?? 8F 99 ?? ?? 27 A4 05 D0 ?? ?? ?? ?? 02 C0 28 21 00 40 80 21 10 40 00 51 8F BC 00 10 8F 92 ?? ?? 02 00 20 21 02 40 C8 21 ?? ?? ?? ?? 02 E0 28 21 14 40 00 04 8F BC 00 10 8E 22 00 40 10 00 00 45 34 42 00 01 02 00 20 21 02 40 C8 21 ?? ?? ?? ?? 03 C0 28 21 14 40 00 04 8F BC 00 10 8E 22 00 40 10 00 00 3C 34 42 00 02 8F 85 ?? ?? 02 00 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 00 04 8F BC 00 10 8E 22 00 40 10 00 00 32 34 42 00 08 8F 85 ?? ?? 02 00 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 00 04 8F BC 00 10 8E 22 00 40 10 00 00 28 34 42 00 04 8F 85 ?? ?? 02 00 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 00 04 8F BC 00 10 8E 22 00 40 10 00 00 1E 34 42 00 10 8F 85 ?? ?? 02 00 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 00 04 8F BC 00 10 8E 22 00 40 10 00 00 14 34 42 00 40 8F 85 ?? ?? 02 00 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 00 04 8F BC 00 10 8E 22 00 40 10 00 00 0A 34 42 04 00 8F 85 ?? ?? 02 00 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 FF AE 8F BC 00 10 8E 22 00 40 34 42 08 00 10 00 FF AA AE 22 00 40 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 10 00 00 03 AE 95 00 00 10 00 00 02 24 02 FF FF 00 00 10 21 8F BF 05 FC 8F BE 05 F8 8F B7 05 F4 8F B6 05 F0 8F B5 05 EC 8F B4 05 E8 8F B3 05 E4 8F B2 05 E0 8F B1 05 DC 8F B0 05 D8 03 E0 00 08 27 BD 06 00 }
	condition:
		$1
}

rule file_288_0_0 {
	meta:
		name = "__GI_isgraph"
		size = 40
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 00 04 20 40 8C 42 00 00 00 44 10 21 94 42 00 00 03 E0 00 08 30 42 00 80 }
	condition:
		$1
}

rule file_289_0_0 {
	meta:
		name = "__fp_range_check"
		size = 260
		refs = "0000 _gp_disp 0018 __muldf3 002c $LC0 005c __eqdf2 0074 __nedf2 00d0 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 AF B4 00 28 8F 94 ?? ?? 8F 99 ?? ?? AF B1 00 1C AF B0 00 18 00 E0 88 21 00 C0 80 21 8E 87 ?? ?? 8E 86 ?? ?? AF BC 00 10 AF BF 00 2C AF B3 00 24 AF B2 00 20 00 A0 98 21 ?? ?? ?? ?? 00 80 90 21 8F BC 00 10 02 60 28 21 02 40 20 21 8F 99 ?? ?? 00 60 38 21 ?? ?? ?? ?? 00 40 30 21 14 40 00 1D 8F BC 00 10 8F 99 ?? ?? 02 60 28 21 02 40 20 21 00 00 38 21 ?? ?? ?? ?? 00 00 30 21 10 40 00 15 8F BC 00 10 8F 99 ?? ?? 8E 87 ?? ?? 8E 86 ?? ?? 02 20 28 21 ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 02 20 28 21 02 00 20 21 8F 99 ?? ?? 00 60 38 21 ?? ?? ?? ?? 00 40 30 21 10 40 00 06 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 22 AC 43 00 00 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_290_0_0 {
	meta:
		name = "__GI_remove"
		size = 156
		refs = "0000 _gp_disp 000c __GI___errno_location 003c __GI_rmdir 0074 __GI_unlink"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BC 00 10 AF BF 00 24 AF B2 00 20 AF B1 00 1C AF B0 00 18 ?? ?? ?? ?? 00 80 88 21 8F BC 00 10 02 20 20 21 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 8C 52 00 00 04 41 00 0E 8F BC 00 10 8E 04 00 00 24 03 00 14 14 83 00 0B 8F BF 00 24 AE 12 00 00 8F BF 00 24 8F B2 00 20 8F B0 00 18 02 20 20 21 8F 99 ?? ?? 8F B1 00 1C ?? ?? ?? ?? 27 BD 00 28 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_293_0_0 {
	meta:
		name = "__GI_setvbuf"
		size = 420
		refs = "0000 _gp_disp 0048 _pthread_cleanup_push_defer 004c __pthread_mutex_unlock 0064 __pthread_mutex_lock 0080 __GI___errno_location 00e0 malloc 0118 free 016c _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B3 00 38 AF B2 00 34 AF B1 00 30 AF B0 00 2C AF BC 00 10 AF BF 00 44 AF B5 00 40 AF B4 00 3C 8C 95 00 34 00 80 80 21 00 A0 88 21 00 C0 98 21 16 A0 00 0C 00 E0 90 21 8F 99 ?? ?? 8F 85 ?? ?? 24 94 00 38 02 80 30 21 ?? ?? ?? ?? 27 A4 00 18 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 80 20 21 8F BC 00 10 2E 62 00 03 54 40 00 08 96 02 00 00 8F 99 ?? ?? ?? ?? ?? ?? 24 10 FF FF 24 03 00 16 8F BC 00 10 10 00 00 33 AC 43 00 00 30 43 08 CF 14 60 00 2F 30 42 FC FF 00 13 A2 00 02 82 A0 25 32 94 FF FF 24 02 00 02 12 62 00 11 A6 14 00 00 12 40 00 11 00 00 98 21 16 20 00 11 32 82 40 00 8E 03 00 0C 8E 02 00 08 00 62 10 23 10 52 00 1E 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 00 40 88 21 10 40 00 19 8F BC 00 10 10 00 00 04 24 13 40 00 00 00 98 21 00 00 90 21 00 00 88 21 32 82 40 00 50 40 00 08 96 02 00 00 8F 99 ?? ?? 8E 04 00 08 32 94 BF FF ?? ?? ?? ?? A6 14 00 00 8F BC 00 10 96 02 00 00 02 32 90 21 AE 11 00 08 02 62 98 25 A6 13 00 00 AE 12 00 0C AE 11 00 10 AE 11 00 14 AE 11 00 18 AE 11 00 1C 10 00 00 02 00 00 80 21 24 10 FF FF 16 A0 00 06 8F BF 00 44 8F 99 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F BF 00 44 02 00 10 21 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_294_0_0 {
	meta:
		name = "__GI_xdr_callmsg"
		size = 1080
		refs = "0000 _gp_disp 00f0 __GI_memcpy 015c __GI_xdr_u_long 01e4 malloc 0220 __GI_xdr_opaque 0268 __GI_xdr_enum 0280 __GI_xdr_u_int 03e0 __GI_xdr_opaque_auth"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B1 00 1C AF B0 00 18 AF BC 00 10 AF BF 00 24 AF B2 00 20 8C 82 00 00 00 80 88 21 14 40 00 48 00 A0 80 21 8C A3 00 20 2C 62 01 91 54 40 00 03 8C A2 00 2C 10 00 00 F6 00 00 10 21 2C 45 01 91 50 A0 00 F3 00 00 10 21 8C 86 00 04 24 65 00 03 24 12 FF FC 24 42 00 03 00 52 10 24 00 B2 28 24 8C D9 00 18 00 A2 28 21 03 20 F8 09 24 A5 00 28 10 40 00 33 8F BC 00 10 8E 03 00 00 AC 43 00 00 8E 03 00 04 AC 43 00 04 8E 03 00 04 54 60 00 E0 00 00 10 21 8E 03 00 08 AC 43 00 08 8E 04 00 08 24 03 00 02 54 83 00 DA 00 00 10 21 8E 03 00 0C AC 43 00 0C 8E 03 00 10 AC 43 00 10 8E 03 00 14 AC 43 00 14 8E 03 00 18 AC 43 00 18 8E 04 00 20 AC 44 00 1C 8E 06 00 20 10 C0 00 0B 24 43 00 20 8F 99 ?? ?? 8E 05 00 1C ?? ?? ?? ?? 00 60 20 21 00 40 18 21 8E 02 00 20 8F BC 00 10 24 42 00 03 00 52 90 24 00 72 18 21 8E 02 00 24 AC 62 00 00 8E 02 00 2C AC 62 00 04 8E 06 00 2C 50 C0 00 BC 24 02 00 01 8E 05 00 28 24 64 00 08 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 B5 24 02 00 01 8E 23 00 00 24 02 00 01 14 62 00 76 8F 92 ?? ?? 8E 22 00 04 02 20 20 21 8C 59 00 18 03 20 F8 09 24 05 00 20 10 40 00 6E 8F BC 00 10 8C 43 00 00 AE 03 00 00 8C 43 00 04 14 60 FF AE AE 03 00 04 8C 43 00 08 24 04 00 02 14 64 FF AA AE 03 00 08 8C 43 00 0C AE 03 00 0C 8C 43 00 10 AE 03 00 10 8C 43 00 14 AE 03 00 14 8C 43 00 18 AE 03 00 18 8C 52 00 1C 12 40 00 21 AE 12 00 20 2E 42 01 91 10 40 00 93 00 00 10 21 8E 02 00 1C 54 40 00 06 8E 22 00 04 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 AE 02 00 1C 8E 22 00 04 26 45 00 03 02 20 20 21 8C 59 00 18 24 02 FF FC 03 20 F8 09 00 A2 28 24 8F BC 00 10 8E 06 00 20 14 40 00 08 8E 05 00 1C 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 54 40 00 08 8E 22 00 04 10 00 00 7A 00 00 10 21 8F 99 ?? ?? 00 A0 20 21 ?? ?? ?? ?? 00 40 28 21 8E 22 00 04 02 20 20 21 8C 59 00 18 03 20 F8 09 24 05 00 08 14 40 00 0F 8F BC 00 10 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 26 05 00 24 10 40 FF 72 8F BC 00 10 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 26 05 00 2C 14 40 00 07 8F BC 00 10 10 00 00 61 00 00 10 21 8C 43 00 00 AE 03 00 24 8C 42 00 04 AE 02 00 2C 8E 12 00 2C 12 40 00 5A 24 02 00 01 2E 42 01 91 10 40 00 57 00 00 10 21 8E 02 00 28 54 40 00 06 8E 22 00 04 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 AE 02 00 28 8E 22 00 04 26 45 00 03 02 20 20 21 8C 59 00 18 24 02 FF FC 03 20 F8 09 00 A2 28 24 8F BC 00 10 8E 06 00 2C 14 40 00 06 8E 05 00 28 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 10 00 00 40 00 02 10 2B 00 A0 20 21 10 00 FF 84 00 40 28 21 8F 92 ?? ?? 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 02 00 28 21 10 40 FF 3F 8F BC 00 10 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 26 05 00 04 10 40 00 30 00 00 10 21 8E 02 00 04 14 40 00 2D 00 00 10 21 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 26 05 00 08 10 40 00 27 00 00 10 21 8E 03 00 08 24 02 00 02 14 62 00 23 00 00 10 21 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 26 05 00 0C 10 40 00 1D 00 00 10 21 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 26 05 00 10 10 40 00 17 00 00 10 21 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 26 05 00 14 10 40 FF 1A 8F BC 00 10 8F 92 ?? ?? 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 26 05 00 18 10 40 FF 13 8F BC 00 10 8F BF 00 24 02 20 20 21 26 05 00 24 8F B1 00 1C 8F B0 00 18 02 40 C8 21 8F B2 00 20 ?? ?? ?? ?? 27 BD 00 28 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_295_0_0 {
	meta:
		name = "__GI_inet_network"
		size = 336
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 8D ?? ?? 27 BD FF F0 00 00 18 21 00 00 38 21 AF B2 00 0C AF B1 00 08 AF B0 00 04 24 0A 00 30 24 0B FF DF 24 0C 00 58 24 0E 00 41 24 0F 00 61 24 18 00 2E 24 19 00 04 80 82 00 00 14 4A 00 0B 24 06 00 0A 90 82 00 01 00 4B 10 24 7C 02 14 20 10 4C 00 04 24 06 00 08 24 84 00 01 10 00 00 04 24 08 00 01 24 84 00 02 24 06 00 10 00 00 40 21 00 00 10 21 24 10 00 10 24 11 00 08 90 85 00 00 10 A0 00 1D 00 05 48 40 8D B2 00 00 02 49 48 21 95 29 00 00 31 32 00 08 12 40 00 09 00 00 00 00 14 D1 00 04 70 46 40 02 2C A8 00 38 11 00 00 1F 70 46 40 02 01 05 10 21 10 00 00 0A 24 42 FF D0 14 D0 00 0D 31 32 00 10 12 40 00 0B 31 29 00 02 00 02 11 00 01 E0 28 21 01 C9 28 0A 24 42 00 0A 00 45 10 23 2C 45 01 00 10 A0 00 10 24 84 00 01 10 00 FF E2 24 08 00 01 11 00 00 0C 00 03 32 00 00 C7 18 0B 14 B8 00 06 00 62 18 25 24 E7 00 01 10 F9 00 06 24 84 00 01 10 00 FF C8 80 82 00 00 24 02 FF FF 10 00 00 02 00 65 10 0A 24 02 FF FF 8F B2 00 0C 8F B1 00 08 8F B0 00 04 03 E0 00 08 27 BD 00 10 }
	condition:
		$1
}

rule file_296_0_0 {
	meta:
		name = "__getdents64"
		size = 436
		refs = "0000 _gp_disp 006c __GI___errno_location 00d8 __GI_memcpy 013c __GI_lseek64"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 24 C2 00 0E 00 02 10 C2 27 BD FF B0 00 02 10 C0 AF BE 00 48 AF B4 00 38 AF B2 00 30 03 A0 F0 21 AF BF 00 4C AF B7 00 44 AF B6 00 40 AF B5 00 3C AF B3 00 34 AF B1 00 2C AF B0 00 28 AF BC 00 18 03 A2 E8 23 27 B4 00 18 00 A0 90 21 02 80 28 21 24 02 10 7B 00 00 00 0C 10 E0 00 06 00 40 B8 21 8F 99 ?? ?? ?? ?? ?? ?? 24 15 FF FF 10 00 00 3D AC 57 00 00 24 02 FF FF 12 E2 00 3D 24 15 FF FF 00 80 98 21 02 40 A8 21 24 11 FF FF 24 10 FF FF 02 97 B8 21 24 03 FF F8 10 00 00 1B 02 46 38 21 8E 88 00 00 8E 91 00 0C 8E 90 00 08 AE A9 00 04 AE A8 00 00 8E 89 00 0C 8E 88 00 08 A6 A2 00 10 AE A9 00 0C AE A8 00 08 92 82 00 12 8F 99 ?? ?? 26 A4 00 13 A2 A2 00 12 96 86 00 10 26 85 00 13 AF C3 00 20 AF C7 00 24 ?? ?? ?? ?? 24 C6 FF ED 96 82 00 10 8F DC 00 18 8F C7 00 24 8F C3 00 20 02 82 A0 21 02 C0 A8 21 02 97 10 2B 50 40 00 18 02 B2 A8 23 96 82 00 10 24 42 00 07 00 43 10 24 02 A2 B0 21 00 F6 20 2B 50 80 FF DD 8E 89 00 04 8F 99 ?? ?? AF A0 00 10 02 60 20 21 02 20 38 21 ?? ?? ?? ?? 02 00 30 21 16 B2 00 08 8F DC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 24 15 FF FF 24 03 00 16 AC 43 00 00 10 00 00 03 03 C0 E8 21 02 B2 A8 23 03 C0 E8 21 8F BF 00 4C 02 A0 10 21 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_297_0_0 {
	meta:
		name = "__GI_towlower"
		size = 52
		refs = "0000 _gp_disp 0018 __GI___C_ctype_tolower"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 2C 83 00 80 10 60 00 06 00 80 10 21 8F 83 ?? ?? 00 04 10 40 8C 63 00 00 00 62 10 21 84 42 00 00 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_693_0_0 {
	meta:
		name = "__GI_towupper"
		size = 52
		refs = "0000 _gp_disp 0018 __GI___C_ctype_toupper"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 2C 83 00 80 10 60 00 06 00 80 10 21 8F 83 ?? ?? 00 04 10 40 8C 63 00 00 00 62 10 21 84 42 00 00 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_298_0_0 {
	meta:
		name = "psignal"
		size = 152
		refs = "0000 _gp_disp 0038 $LC0 004c stderr 0050 __GI_strsignal 006c __GI_fprintf 0068 $LC1"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 AF BC 00 18 AF B1 00 24 AF BF 00 2C AF B2 00 28 AF B0 00 20 10 A0 00 04 00 A0 88 21 80 A2 00 00 54 40 00 05 8F 90 ?? ?? 8F 90 ?? ?? 26 10 ?? ?? 10 00 00 02 02 00 88 21 26 10 ?? ?? 8F 82 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 8C 52 00 00 8F BC 00 18 02 40 20 21 02 20 30 21 8F 85 ?? ?? 8F 99 ?? ?? 02 00 38 21 AF A2 00 10 ?? ?? ?? ?? 24 A5 ?? ?? 8F BF 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_299_0_0 {
	meta:
		name = "__GI_fgetpwent_r"
		size = 88
		refs = "0000 _gp_disp 0024 __pgsreader 0030 __parsepwent"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 AF B0 00 24 8F B0 00 40 AF BC 00 18 AF B1 00 28 AF BF 00 2C 8F 99 ?? ?? AE 00 00 00 AF A4 00 10 8F 84 ?? ?? ?? ?? ?? ?? 00 A0 88 21 50 40 00 01 AE 11 00 00 8F BF 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_540_0_0 {
	meta:
		name = "__GI_fgetgrent_r"
		size = 88
		refs = "0000 _gp_disp 0024 __pgsreader 0030 __parsegrent"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 AF B0 00 24 8F B0 00 40 AF BC 00 18 AF B1 00 28 AF BF 00 2C 8F 99 ?? ?? AE 00 00 00 AF A4 00 10 8F 84 ?? ?? ?? ?? ?? ?? 00 A0 88 21 50 40 00 01 AE 11 00 00 8F BF 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_301_0_0 {
	meta:
		name = "__GI_fgetspent_r"
		size = 88
		refs = "0000 _gp_disp 0024 __pgsreader 0030 __parsespent"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 AF B0 00 24 8F B0 00 40 AF BC 00 18 AF B1 00 28 AF BF 00 2C 8F 99 ?? ?? AE 00 00 00 AF A4 00 10 8F 84 ?? ?? ?? ?? ?? ?? 00 A0 88 21 50 40 00 01 AE 11 00 00 8F BF 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_300_0_0 {
	meta:
		name = "__GI_fstatvfs"
		size = 884
		refs = "0000 _gp_disp 000c __libc_fstatfs 005c __GI_memset 00c0 __GI_fstat 00dc __GI___errno_location 00fc __GI_setmntent 00f4 $LC0 010c $LC1 011c $LC2 013c __GI_getmntent_r 0140 __GI_stat 01ac $LC11 01b0 $LC3 01b4 $LC4 01c8 __GI_strsep 01e4 __GI_strcmp 0230 $LC5 0258 $LC6 0280 $LC7 02a8 $LC8 02d0 $LC9 02f8 $LC10 0324 __GI_endmntent"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FA 30 AF BC 00 10 AF B1 05 AC AF B0 05 A8 AF BF 05 CC AF BE 05 C8 AF B7 05 C4 AF B6 05 C0 AF B5 05 BC AF B4 05 B8 AF B3 05 B4 AF B2 05 B0 00 A0 80 21 27 A5 05 48 ?? ?? ?? ?? 00 80 88 21 04 40 00 B9 8F BC 00 10 8F A2 05 4C 8F 99 ?? ?? 26 04 00 30 AE 02 00 00 AE 02 00 04 8F A2 05 54 00 00 28 21 24 06 00 18 AE 02 00 08 8F A2 05 58 AE 00 00 24 AE 02 00 0C 8F A2 05 64 AE 02 00 10 8F A2 05 5C AE 02 00 14 8F A2 05 60 AE 02 00 18 8F A2 05 68 AE 02 00 20 8F A2 05 70 ?? ?? ?? ?? AE 02 00 2C 8F BC 00 10 8E 02 00 18 AE 00 00 28 8F 99 ?? ?? AE 02 00 1C 02 20 20 21 ?? ?? ?? ?? 27 A5 04 B0 04 40 00 9A 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 00 40 A0 21 8C 55 00 00 8F 84 ?? ?? 8F 92 ?? ?? 8F 91 ?? ?? 24 84 ?? ?? 02 20 C8 21 ?? ?? ?? ?? 26 45 ?? ?? 00 40 98 21 14 40 00 09 8F BC 00 10 8F 84 ?? ?? 26 45 ?? ?? 02 20 C8 21 ?? ?? ?? ?? 24 84 ?? ?? 00 40 98 21 10 40 00 7E 8F BC 00 10 8F 91 ?? ?? 8F 9E ?? ?? 27 B6 05 8C 27 B2 00 18 27 B7 04 18 02 60 20 21 02 C0 28 21 02 40 30 21 02 20 C8 21 ?? ?? ?? ?? 24 07 04 00 10 40 00 6E 8F BC 00 10 8F A4 05 90 03 C0 C8 21 ?? ?? ?? ?? 02 E0 28 21 04 40 FF F3 8F BC 00 10 8F A2 04 18 8F A3 04 B0 14 62 FF F0 02 60 20 21 8F A2 04 1C 8F A3 04 B4 14 62 FF ED 02 C0 28 21 8F A2 05 98 8F 96 ?? ?? 8F 97 ?? ?? 8F 9E ?? ?? AF A2 05 A4 26 D6 ?? ?? 26 F7 ?? ?? 27 DE ?? ?? 8F 99 ?? ?? 27 A4 05 A4 ?? ?? ?? ?? 02 C0 28 21 00 40 88 21 10 40 00 51 8F BC 00 10 8F 92 ?? ?? 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 02 E0 28 21 14 40 00 04 8F BC 00 10 8E 02 00 28 10 00 00 45 34 42 00 01 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 03 C0 28 21 14 40 00 04 8F BC 00 10 8E 02 00 28 10 00 00 3C 34 42 00 02 8F 85 ?? ?? 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 00 04 8F BC 00 10 8E 02 00 28 10 00 00 32 34 42 00 08 8F 85 ?? ?? 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 00 04 8F BC 00 10 8E 02 00 28 10 00 00 28 34 42 00 04 8F 85 ?? ?? 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 00 04 8F BC 00 10 8E 02 00 28 10 00 00 1E 34 42 00 10 8F 85 ?? ?? 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 00 04 8F BC 00 10 8E 02 00 28 10 00 00 14 34 42 00 40 8F 85 ?? ?? 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 00 04 8F BC 00 10 8E 02 00 28 10 00 00 0A 34 42 04 00 8F 85 ?? ?? 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 FF AE 8F BC 00 10 8E 02 00 28 34 42 08 00 10 00 FF AA AE 02 00 28 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 10 00 00 03 AE 95 00 00 10 00 00 02 24 02 FF FF 00 00 10 21 8F BF 05 CC 8F BE 05 C8 8F B7 05 C4 8F B6 05 C0 8F B5 05 BC 8F B4 05 B8 8F B3 05 B4 8F B2 05 B0 8F B1 05 AC 8F B0 05 A8 03 E0 00 08 27 BD 05 D0 }
	condition:
		$1
}

rule file_302_0_0 {
	meta:
		name = "__GI_fputs_unlocked"
		size = 120
		refs = "0000 _gp_disp 000c __GI_strlen 0040 __GI_fwrite_unlocked"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BF 00 24 AF B2 00 20 AF B1 00 1C AF B0 00 18 AF BC 00 10 00 A0 88 21 ?? ?? ?? ?? 00 80 90 21 8F BC 00 10 02 40 20 21 02 20 38 21 8F 99 ?? ?? 24 05 00 01 00 40 30 21 ?? ?? ?? ?? 00 40 80 21 8F BF 00 24 00 50 80 26 24 03 FF FF 00 70 10 0B 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_303_0_0 {
	meta:
		name = "__GI_ptsname_r"
		size = 276
		refs = "0000 _gp_disp 000c __GI___errno_location 0050 __GI_ioctl 0074 _uintmaxtostr 00b8 __GI_strcpy 00d0 __GI_strcat"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF A8 AF BC 00 18 AF BF 00 54 AF B5 00 50 AF B4 00 4C AF B1 00 40 AF B0 00 3C AF A4 00 30 AF B3 00 48 AF B2 00 44 00 A0 88 21 ?? ?? ?? ?? 00 C0 A8 21 8F BC 00 18 8F A4 00 30 3C 05 40 04 8F 99 ?? ?? 24 A5 54 30 27 A6 00 2C 00 40 80 21 ?? ?? ?? ?? 8C 54 00 00 14 40 00 1F 8F BC 00 18 8F A7 00 2C 8F 99 ?? ?? 24 02 FF F6 27 B2 00 2B 02 40 20 21 AF A2 00 10 AF A0 00 14 ?? ?? ?? ?? 00 07 37 C3 02 42 90 23 26 52 00 0A 02 B2 A8 2B 8F BC 00 18 12 A0 00 03 00 40 98 21 10 00 00 0F 24 02 00 22 8F 85 ?? ?? 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 24 A5 ?? ?? 8F BC 00 18 02 20 20 21 8F 99 ?? ?? ?? ?? ?? ?? 02 60 28 21 AE 14 00 00 10 00 00 03 00 00 10 21 24 02 00 19 AE 02 00 00 8F BF 00 54 8F B5 00 50 8F B4 00 4C 8F B3 00 48 8F B2 00 44 8F B1 00 40 8F B0 00 3C 03 E0 00 08 27 BD 00 58 }
	condition:
		$1
}

rule file_303_1_0 {
	meta:
		name = "ptsname"
		size = 76
		refs = "0000 _gp_disp 0018 __GI_ptsname_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF B0 00 18 8F 90 ?? ?? 8F 99 ?? ?? AF BF 00 1C AF BC 00 10 26 05 ?? ?? ?? ?? ?? ?? 24 06 00 1E 8F BF 00 1C 26 10 ?? ?? 00 02 80 0B 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_304_0_0 {
	meta:
		name = "getresuid"
		size = 164
		refs = "0000 _gp_disp 0050 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF BC 00 10 AF B3 00 38 AF B2 00 34 AF B1 00 30 00 80 98 21 00 A0 90 21 00 C0 88 21 AF BF 00 3C AF B0 00 2C 27 A4 00 20 27 A5 00 1C 27 A6 00 18 24 02 10 5A 00 00 00 0C 10 E0 00 07 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 10 00 00 08 24 10 FF FF 14 40 00 06 8F A2 00 20 AE 62 00 00 8F A2 00 1C AE 42 00 00 8F A2 00 18 AE 22 00 00 8F BF 00 3C 02 00 10 21 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_305_0_0 {
	meta:
		name = "__GI_nanosleep"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 46 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_306_0_0 {
	meta:
		name = "__GI___fsetlocking"
		size = 64
		refs = "0000 _gp_disp 0024 _stdio_user_locking"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8C 82 00 34 30 42 00 01 10 A0 00 08 24 42 00 01 24 03 00 02 10 A3 00 03 8F 83 ?? ?? 10 00 00 02 8C 63 00 00 24 03 00 01 AC 83 00 34 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_307_0_0 {
	meta:
		name = "__GI_inet_addr"
		size = 64
		refs = "0000 _gp_disp 000c __GI_inet_aton"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BF 00 24 AF BC 00 10 ?? ?? ?? ?? 27 A5 00 18 8F A4 00 18 8F BF 00 24 24 03 FF FF 00 82 18 0B 00 60 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_308_0_0 {
	meta:
		name = "gai_strerror"
		size = 76
		refs = "0000 _gp_disp 0040 $LC0"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 86 ?? ?? 00 00 10 21 24 05 00 10 24 C6 ?? ?? 00 02 18 C0 00 66 18 21 8C 67 00 00 54 E4 00 03 24 42 00 01 03 E0 00 08 8C 62 00 04 14 45 FF F9 00 02 18 C0 8F 82 ?? ?? 03 E0 00 08 24 42 ?? ?? }
	condition:
		$1
}

rule file_309_0_0 {
	meta:
		name = "__GI_ftello64"
		size = 264
		refs = "0000 _gp_disp 0040 _pthread_cleanup_push_defer 0044 __pthread_mutex_unlock 005c __pthread_mutex_lock 0074 __stdio_seek 00b8 __stdio_adjust_position 00d8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF B0 00 30 AF BC 00 10 AF BF 00 3C AF B2 00 38 AF B1 00 34 8C 91 00 34 00 00 18 21 00 00 10 21 00 80 80 21 AF A3 00 2C 16 20 00 0C AF A2 00 28 8F 99 ?? ?? 8F 85 ?? ?? 24 92 00 38 02 40 30 21 ?? ?? ?? ?? 27 A4 00 18 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 96 06 00 00 24 03 00 01 8F 99 ?? ?? 30 C6 04 40 38 C6 04 40 24 02 00 02 00 66 10 0B 27 B2 00 28 02 00 20 21 02 40 28 21 ?? ?? ?? ?? 00 40 30 21 04 41 00 06 8F BC 00 10 24 03 FF FF 24 02 FF FF AF A3 00 2C 10 00 00 07 AF A2 00 28 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 02 40 28 21 04 40 FF F6 8F BC 00 10 16 20 00 06 8F BF 00 3C 8F 99 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F BF 00 3C 8F A3 00 2C 8F A2 00 28 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_310_0_0 {
	meta:
		name = "__GI_setpgid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F D9 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_312_0_0 {
	meta:
		name = "__GI_wcrtomb"
		size = 92
		refs = "0000 _gp_disp 001c __GI_wcsnrtombs"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF BC 00 18 AF BF 00 3C 14 80 00 03 8F 99 ?? ?? 00 00 28 21 27 A4 00 20 27 A2 00 34 AF A5 00 34 AF A6 00 10 27 A5 00 30 AF A2 00 30 24 06 00 01 ?? ?? ?? ?? 24 07 00 10 8F BF 00 3C 24 03 00 01 00 62 10 0A 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_313_0_0 {
	meta:
		name = "__GI_srand48_r"
		size = 64
	strings:
		$1 = { 00 04 14 03 A4 A2 00 04 24 02 33 0E A4 A2 00 00 24 02 00 05 AC A2 00 10 3C 03 DE EC 24 02 00 0B 34 63 E6 6D A4 A2 00 0C 24 02 00 01 A4 A2 00 0E A4 A4 00 02 AC A3 00 14 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_314_0_0 {
	meta:
		name = "__GI_fputs"
		size = 176
		refs = "0000 _gp_disp 0038 _pthread_cleanup_push_defer 0040 __pthread_mutex_unlock 0054 __pthread_mutex_lock 0064 __GI_fputs_unlocked 007c _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B3 00 40 AF B0 00 34 AF BC 00 10 AF BF 00 44 AF B2 00 3C AF B1 00 38 8C B1 00 34 00 80 98 21 16 20 00 0C 00 A0 80 21 8F 99 ?? ?? 24 B2 00 38 8F 85 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 02 40 30 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 8F 99 ?? ?? 02 60 20 21 ?? ?? ?? ?? 02 00 28 21 16 20 00 07 8F BC 00 10 8F 99 ?? ?? AF A2 00 28 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F A2 00 28 8F BF 00 44 8F B3 00 40 8F B2 00 3C 8F B1 00 38 8F B0 00 34 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_501_0_0 {
	meta:
		name = "__GI_fputws"
		size = 176
		refs = "0000 _gp_disp 0038 _pthread_cleanup_push_defer 0040 __pthread_mutex_unlock 0054 __pthread_mutex_lock 0064 __GI_fputws_unlocked 007c _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B3 00 40 AF B0 00 34 AF BC 00 10 AF BF 00 44 AF B2 00 3C AF B1 00 38 8C B1 00 34 00 80 98 21 16 20 00 0C 00 A0 80 21 8F 99 ?? ?? 24 B2 00 38 8F 85 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 02 40 30 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 8F 99 ?? ?? 02 60 20 21 ?? ?? ?? ?? 02 00 28 21 16 20 00 07 8F BC 00 10 8F 99 ?? ?? AF A2 00 28 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F A2 00 28 8F BF 00 44 8F B3 00 40 8F B2 00 3C 8F B1 00 38 8F B0 00 34 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_743_0_0 {
	meta:
		name = "fputwc"
		size = 176
		refs = "0000 _gp_disp 0038 _pthread_cleanup_push_defer 0040 __pthread_mutex_unlock 0054 __pthread_mutex_lock 0064 __GI_fputwc_unlocked 007c _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B3 00 40 AF B0 00 34 AF BC 00 10 AF BF 00 44 AF B2 00 3C AF B1 00 38 8C B1 00 34 00 80 98 21 16 20 00 0C 00 A0 80 21 8F 99 ?? ?? 24 B2 00 38 8F 85 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 02 40 30 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 8F 99 ?? ?? 02 60 20 21 ?? ?? ?? ?? 02 00 28 21 16 20 00 07 8F BC 00 10 8F 99 ?? ?? AF A2 00 28 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F A2 00 28 8F BF 00 44 8F B3 00 40 8F B2 00 3C 8F B1 00 38 8F B0 00 34 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_315_0_0 {
	meta:
		name = "__GI_send"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 52 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_316_0_0 {
	meta:
		name = "wait3"
		size = 44
		refs = "0000 _gp_disp 000c __GI_wait4"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 00 80 18 21 00 A0 10 21 00 C0 38 21 24 04 FF FF 00 60 28 21 ?? ?? ?? ?? 00 40 30 21 }
	condition:
		$1
}

rule file_317_0_0 {
	meta:
		name = "semget"
		size = 76
		refs = "0000 _gp_disp 000c __syscall_ipc"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 00 80 18 21 00 A0 10 21 00 C0 38 21 AF BF 00 24 AF BC 00 18 AF A0 00 10 AF A0 00 14 24 04 00 02 00 60 28 21 ?? ?? ?? ?? 00 40 30 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_318_0_0 {
	meta:
		name = "seekdir"
		size = 176
		refs = "0000 _gp_disp 0010 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 0050 __pthread_mutex_lock 0068 __GI_lseek 0080 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 8F 99 ?? ?? AF B3 00 38 00 A0 98 21 8F 85 ?? ?? AF B2 00 34 AF B1 00 30 24 92 00 18 27 B1 00 18 AF BF 00 3C AF B0 00 2C AF BC 00 10 00 80 80 21 02 40 30 21 ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 8E 04 00 00 02 60 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 30 21 8F BC 00 10 AE 02 00 10 02 20 20 21 8F 99 ?? ?? AE 00 00 04 AE 00 00 08 ?? ?? ?? ?? 24 05 00 01 8F BF 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_319_0_0 {
	meta:
		name = "__GI_strsignal"
		size = 208
		refs = "0000 _gp_disp 0058 _string_syssigmsgs 0080 _uintmaxtostr 00ac __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 00 80 38 21 8F 84 ?? ?? 27 BD FF D8 00 00 18 21 24 84 ?? ?? AF BC 00 18 AF BF 00 24 24 02 00 21 00 64 28 21 90 A5 00 00 50 A7 00 07 2C E2 00 20 24 63 00 01 14 62 FF FB 00 64 28 21 3C 03 7F FF 34 63 FF FF 2C E2 00 20 10 40 00 09 8F 88 ?? ?? 10 60 00 05 81 02 00 00 2C 42 00 01 00 62 18 23 10 00 FF FB 25 08 00 01 14 40 00 13 8F BF 00 24 8F 84 ?? ?? 8F 99 ?? ?? 24 02 FF F6 00 07 37 C3 24 84 ?? ?? AF A2 00 10 ?? ?? ?? ?? AF A0 00 14 8F BC 00 18 24 48 FF F1 01 00 20 21 8F 85 ?? ?? 8F 99 ?? ?? 24 06 00 0F ?? ?? ?? ?? 24 A5 ?? ?? 00 40 40 21 8F BF 00 24 01 00 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_320_0_0 {
	meta:
		name = "__stdio_adjust_position"
		size = 252
		refs = "0000 _gp_disp 00d4 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 94 83 00 00 30 62 00 03 50 40 00 12 00 00 10 21 24 42 FF FF 10 40 00 0F 30 66 08 00 50 C0 00 0E 30 63 00 40 24 06 00 02 50 46 00 28 24 10 FF FF 8C 82 00 28 54 40 00 25 24 10 FF FF 90 82 00 03 8C 86 00 2C 18 C0 00 03 00 02 10 23 90 86 00 02 00 46 10 23 30 63 00 40 50 60 00 02 8C 83 00 14 8C 83 00 08 8C 84 00 10 8C A6 00 04 00 64 18 23 00 43 10 21 8C A3 00 00 00 C2 38 23 00 02 27 C3 00 C7 30 2B 00 64 20 23 00 86 20 23 AC A4 00 00 AC A7 00 04 00 64 28 2A 54 A0 00 05 00 02 10 23 14 83 00 03 00 00 00 00 54 C0 00 01 00 02 10 23 04 41 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 4F AC 43 00 00 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_321_0_0 {
	meta:
		name = "__GI_chown"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 6A 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_322_0_0 {
	meta:
		name = "__GI_sgetspent_r"
		size = 208
		refs = "0000 _gp_disp 0040 __GI___errno_location 006c __GI_strlen 0084 __GI_strcpy 0098 __parsespent"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 AF B1 00 1C 8F B1 00 40 AF BC 00 10 2C E2 01 00 AF B4 00 28 AF BF 00 2C AF B3 00 24 AF B2 00 20 AF B0 00 18 00 E0 A0 21 10 40 00 08 AE 20 00 00 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 22 AC 43 00 00 10 00 00 16 24 02 00 22 00 80 98 21 00 A0 90 21 10 86 00 0C 00 C0 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 00 54 10 2B 10 40 FF F0 8F BC 00 10 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 02 60 28 21 8F BC 00 10 8F 99 ?? ?? 02 40 20 21 ?? ?? ?? ?? 02 00 28 21 50 40 00 01 AE 32 00 00 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_323_0_0 {
	meta:
		name = "_load_inttype"
		size = 112
	strings:
		$1 = { 04 C0 00 0F 30 82 08 00 50 40 00 04 24 02 01 00 8C A2 00 00 03 E0 00 08 8C A3 00 04 14 82 00 03 8C A3 00 00 10 00 00 04 30 63 00 FF 30 62 FF FF 38 84 02 00 00 44 18 0A 03 E0 00 08 00 00 10 21 54 40 FF F4 8C A2 00 00 24 02 01 00 14 82 00 03 8C A3 00 00 10 00 00 04 7C 03 1C 20 7C 03 16 20 38 84 02 00 00 44 18 0A 03 E0 00 08 00 03 17 C3 }
	condition:
		$1
}

rule file_324_0_0 {
	meta:
		name = "mblen"
		size = 120
		refs = "0000 _gp_disp 0040 __GI_mbrlen"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 54 80 00 05 80 83 00 00 8F 82 ?? ?? AC 40 ?? ?? 10 00 00 0E 00 00 10 21 10 60 00 0C 00 00 10 21 8F 90 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 26 06 ?? ?? 24 03 FF FE 14 43 00 06 8F BF 00 1C 34 02 FF FF 26 10 ?? ?? AE 02 00 04 24 02 FF FF 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_325_0_0 {
	meta:
		name = "__GI_vdprintf"
		size = 200
		refs = "0000 _gp_disp 001c __stdio_init_mutex 007c _vfprintf_internal 009c __GI_fflush_unlocked"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 40 27 A2 00 A8 AF A2 00 24 27 A2 00 68 8F 99 ?? ?? AF A2 00 20 AF A2 00 30 AF A2 00 34 AF A2 00 28 AF A2 00 2C 24 02 00 D0 A7 A2 00 18 24 02 00 01 AF BC 00 10 AF BF 00 BC AF B1 00 B8 AF B0 00 B4 AF A4 00 1C AF A2 00 4C AF A5 00 A8 AF A6 00 AC A3 A0 00 1A AF A0 00 44 ?? ?? ?? ?? 27 A4 00 50 8F BC 00 10 8F A5 00 A8 8F A6 00 AC 8F 99 ?? ?? 27 B1 00 18 AF A0 00 38 ?? ?? ?? ?? 02 20 20 21 00 40 80 21 18 40 00 06 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 24 03 FF FF 00 62 80 0B 8F BF 00 BC 02 00 10 21 8F B1 00 B8 8F B0 00 B4 03 E0 00 08 27 BD 00 C0 }
	condition:
		$1
}

rule file_327_0_0 {
	meta:
		name = "ualarm"
		size = 108
		refs = "0000 _gp_disp 000c __GI_setitimer"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF C0 27 A6 00 28 AF BC 00 10 AF A5 00 1C AF A4 00 24 AF BF 00 3C AF A0 00 18 AF A0 00 20 00 00 20 21 ?? ?? ?? ?? 27 A5 00 18 04 40 00 07 24 03 FF FF 8F A4 00 30 3C 03 00 0F 24 63 42 40 70 83 28 02 8F A2 00 34 00 A2 18 21 8F BF 00 3C 00 60 10 21 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_328_0_0 {
	meta:
		name = "sendfile64"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 8D 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_329_0_0 {
	meta:
		name = "setfsgid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 2B 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_330_0_0 {
	meta:
		name = "__parsepwent"
		size = 276
		refs = "0000 _gp_disp 0020 __GI_strchr 0024 __GI_strtoul"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B3 00 2C 8F 93 ?? ?? AF B7 00 3C AF B6 00 38 8F 97 ?? ?? 8F 96 ?? ?? AF B5 00 34 AF B4 00 30 AF B2 00 28 AF B1 00 24 AF B0 00 20 AF BC 00 10 AF BF 00 44 AF BE 00 40 00 80 90 21 00 A0 88 21 00 00 80 21 26 73 ?? ?? 24 14 00 02 27 B5 00 18 02 13 10 21 90 5E 00 00 32 02 00 06 10 54 00 0C 02 5E F0 21 24 02 00 06 12 02 00 19 AF D1 00 00 02 20 20 21 02 E0 C8 21 ?? ?? ?? ?? 24 05 00 3A 14 40 00 10 24 51 00 01 10 00 00 12 24 02 FF FF 02 20 20 21 02 A0 28 21 02 C0 C8 21 ?? ?? ?? ?? 24 06 00 0A 00 40 18 21 8F A2 00 18 10 51 FF F6 24 04 00 3A 80 45 00 00 14 A4 FF F3 24 51 00 01 AF C3 00 00 A0 40 00 00 10 00 FF E1 26 10 00 01 00 00 10 21 8F BF 00 44 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_331_0_0 {
	meta:
		name = "__GI_readdir"
		size = 256
		refs = "0000 _gp_disp 0010 _pthread_cleanup_push_defer 0014 __pthread_mutex_unlock 004c __pthread_mutex_lock 005c __getdents 00c8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 8F 99 ?? ?? 8F 85 ?? ?? AF B2 00 34 AF B1 00 30 27 B2 00 18 24 91 00 18 AF BC 00 10 AF BF 00 3C AF B3 00 38 AF B0 00 2C 02 20 30 21 00 80 80 21 ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8F 93 ?? ?? 8E 03 00 08 8E 02 00 04 00 43 10 2B 54 40 00 0B 8E 02 00 04 8E 04 00 00 8E 05 00 0C 02 60 C8 21 ?? ?? ?? ?? 8E 06 00 14 18 40 00 10 8F BC 00 10 AE 02 00 08 AE 00 00 04 8E 02 00 04 8E 11 00 0C 02 22 88 21 96 23 00 08 00 62 10 21 AE 02 00 04 8E 22 00 04 AE 02 00 10 8E 22 00 00 50 40 FF E9 8E 03 00 08 10 00 00 03 8F 99 ?? ?? 00 00 88 21 8F 99 ?? ?? 02 40 20 21 ?? ?? ?? ?? 24 05 00 01 8F BF 00 3C 02 20 10 21 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_333_0_0 {
	meta:
		name = "__encode_answer"
		size = 248
		refs = "0000 _gp_disp 0028 __encode_dotted 0064 __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 AF BC 00 10 AF B3 00 28 AF B2 00 24 AF B1 00 20 AF B0 00 1C AF BF 00 2C 8F 99 ?? ?? 00 80 80 21 8C 84 00 00 00 A0 98 21 ?? ?? ?? ?? 00 C0 90 21 00 40 88 21 04 40 00 25 8F BC 00 10 02 62 20 21 8E 02 00 10 02 51 90 23 24 42 00 09 00 52 90 2A 12 40 00 1D 8F 99 ?? ?? 92 02 00 06 24 84 00 0A A0 82 FF F6 8E 02 00 04 26 31 00 0A A0 82 FF F7 92 02 00 0A A0 82 FF F8 8E 02 00 08 A0 82 FF F9 92 02 00 0C A0 82 FF FA 92 02 00 0D A0 82 FF FB 92 02 00 0E A0 82 FF FC 8E 02 00 0C A0 82 FF FD 92 02 00 12 A0 82 FF FE 8E 02 00 10 A0 82 FF FF 8E 05 00 14 ?? ?? ?? ?? 8E 06 00 10 8E 02 00 10 10 00 00 02 02 22 10 21 24 02 FF FF 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_335_0_0 {
	meta:
		name = "__GI_utimes"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 AB 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_336_0_0 {
	meta:
		name = "__GI_basename"
		size = 36
	strings:
		$1 = { 00 80 10 21 80 83 00 00 10 60 00 04 24 84 00 01 38 63 00 2F 10 00 FF FB 00 83 10 0A 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_338_0_0 {
	meta:
		name = "__GI_geteuid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F D1 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_339_0_0 {
	meta:
		name = "__GI_execlp"
		size = 184
		refs = "0000 _gp_disp 0098 __GI_execvp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF BE 00 20 03 A0 F0 21 AF C6 00 30 27 C6 00 30 AF BF 00 24 AF BC 00 10 AF C7 00 34 AF C6 00 18 00 00 18 21 8F C7 00 18 24 62 00 01 24 E8 00 04 8C E7 00 00 10 E0 00 03 AF C8 00 18 10 00 FF F9 00 40 18 21 00 03 18 80 24 63 00 16 00 03 18 C2 00 03 18 C0 03 A3 E8 23 27 A3 00 10 AC 65 00 00 AF C6 00 18 00 60 28 21 8F C6 00 18 24 A5 00 04 24 42 FF FF 24 C7 00 04 8C C6 00 00 AF C7 00 18 14 40 FF F9 AC A6 00 00 8F 99 ?? ?? ?? ?? ?? ?? 00 60 28 21 03 C0 E8 21 8F BF 00 24 8F BE 00 20 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_340_0_0 {
	meta:
		name = "__GI_times"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F CB 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_341_0_0 {
	meta:
		name = "__GI_socket"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 57 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_342_0_0 {
	meta:
		name = "__GI_rexec_af"
		size = 1472
		refs = "0000 _gp_disp 001c __GI_snprintf 0018 $LC0 0084 __GI_memset 00a4 __GI_getaddrinfo 00d8 __GI_strncpy 00dc ahostbuf 00f8 __GI_ruserpass 0114 __GI_socket 0118 __GI_connect 011c __GI___errno_location 0120 __GI_close 0128 __GI_sleep 01c4 $LC1 01d8 __GI_perror 01fc __GI_write 01f8 $LC2 0250 __GI_listen 026c __GI_getsockname 028c $LC3 02a4 __libc_sa_len 02e0 __GI_getnameinfo 0314 __GI_atoi 032c __GI_sprintf 0328 $LC4 0350 __GI_strlen 0380 __GI_accept 03e0 $LC5 0484 free 04b0 __GI_read 04f4 __GI_freeaddrinfo"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FE 30 AF A6 01 D8 AF A6 01 98 8F 86 ?? ?? 8F 99 ?? ?? 00 A0 10 21 AF B4 01 B8 27 B4 01 48 AF BF 01 CC AF BC 00 20 AF B3 01 B4 AF B1 01 AC AF B0 01 A8 00 80 98 21 AF A7 01 DC AF A7 01 9C 02 80 20 21 00 40 38 21 24 05 00 20 24 C6 ?? ?? AF BE 01 C8 AF B7 01 C4 AF B6 01 C0 AF B5 01 BC AF B2 01 B0 ?? ?? ?? ?? 97 B0 01 EA 8F BC 00 20 27 B1 01 68 02 20 20 21 8F 99 ?? ?? 00 00 28 21 24 06 00 20 ?? ?? ?? ?? A3 A0 01 67 8F BC 00 20 8E 64 00 00 AF B0 01 6C 8F 99 ?? ?? 24 10 00 02 AF B0 01 70 AF B0 01 68 02 80 28 21 02 20 30 21 ?? ?? ?? ?? 27 A7 01 90 14 40 01 31 8F BC 00 20 8F B1 01 90 8E 25 00 18 10 A0 00 15 8F 99 ?? ?? 8F 84 ?? ?? ?? ?? ?? ?? 24 06 04 01 8F BC 00 20 27 A5 01 D8 27 A6 01 DC 8F 82 ?? ?? 8F 99 ?? ?? A0 40 04 00 AE 62 00 00 8E 24 00 18 ?? ?? ?? ?? 24 11 00 01 8F BC 00 20 8F 96 ?? ?? 8F 95 ?? ?? 8F 92 ?? ?? 8F 97 ?? ?? 10 00 00 1E 8F 9E ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? AE 60 00 00 10 00 01 14 AC 50 00 00 8F A2 01 90 02 00 20 21 02 A0 C8 21 8C 45 00 14 ?? ?? ?? ?? 8C 46 00 10 04 41 00 24 8F BC 00 20 02 40 C8 21 ?? ?? ?? ?? 00 00 00 00 8C 43 00 00 24 02 00 92 14 62 00 16 8F BC 00 20 2A 22 00 11 10 40 00 13 02 E0 C8 21 ?? ?? ?? ?? 02 00 20 21 02 20 20 21 03 C0 C8 21 ?? ?? ?? ?? 00 11 88 40 8F A2 01 90 00 00 30 21 02 C0 C8 21 8C 44 00 04 ?? ?? ?? ?? 8C 45 00 08 00 40 80 21 04 41 FF E0 8F BC 00 20 8F 84 ?? ?? 10 00 00 03 24 84 ?? ?? 8F A2 01 90 8C 44 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 E9 00 00 00 00 8F A3 01 E4 14 60 00 0A 8F A2 01 90 8F 85 ?? ?? 8F 99 ?? ?? 02 00 20 21 24 A5 ?? ?? ?? ?? ?? ?? 24 06 00 01 00 00 90 21 10 00 00 7A 8F BC 00 20 8F 99 ?? ?? 00 00 30 21 8C 44 00 04 ?? ?? ?? ?? 8C 45 00 08 00 40 88 21 04 41 00 06 8F BC 00 20 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 10 00 00 D0 00 00 00 00 8F 99 ?? ?? 00 40 20 21 ?? ?? ?? ?? 24 05 00 01 8F BC 00 20 24 02 00 80 27 B2 00 A8 8F 99 ?? ?? AF A2 01 8C 02 20 20 21 02 40 28 21 ?? ?? ?? ?? 27 A6 01 8C 04 41 00 07 8F BC 00 20 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 84 ?? ?? 10 00 00 0D 8F BC 00 20 8F 99 ?? ?? 97 A4 00 A8 ?? ?? ?? ?? 8F B5 01 8C 12 A2 00 09 8F BC 00 20 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 8F BC 00 20 AC 43 00 00 10 00 00 A2 02 20 20 21 24 02 00 20 8F 99 ?? ?? 8F A5 01 8C AF A2 00 14 24 02 00 02 02 40 20 21 AF B4 00 10 AF A2 00 18 00 00 30 21 ?? ?? ?? ?? 00 00 38 21 00 00 90 21 14 40 00 06 8F BC 00 20 8F 99 ?? ?? ?? ?? ?? ?? 02 80 20 21 8F BC 00 20 30 52 FF FF 8F 85 ?? ?? 8F 99 ?? ?? 27 B4 01 28 02 80 20 21 24 A5 ?? ?? ?? ?? ?? ?? 02 40 30 21 8F BC 00 20 02 80 20 21 27 B6 01 88 8F 99 ?? ?? ?? ?? ?? ?? 24 1E FF FF 8F BC 00 20 02 80 28 21 02 00 20 21 8F 99 ?? ?? ?? ?? ?? ?? 24 46 00 01 8F BC 00 20 24 02 00 80 27 B9 00 28 8F 97 ?? ?? 8F 94 ?? ?? AF A2 01 88 AF B9 01 A0 02 20 20 21 27 A5 00 28 02 E0 C8 21 ?? ?? ?? ?? 02 C0 30 21 00 40 A8 21 14 5E 00 08 8F BC 00 20 02 80 C8 21 ?? ?? ?? ?? 00 00 00 00 8C 44 00 00 24 02 00 04 10 82 FF F2 8F BC 00 20 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 06 A1 00 07 8F BC 00 20 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 84 ?? ?? 10 00 00 5F 8F BC 00 20 8F A3 01 E4 AC 75 00 00 8F 94 ?? ?? 8F B1 01 D8 02 80 C8 21 ?? ?? ?? ?? 02 20 20 21 8F BC 00 20 02 20 28 21 24 46 00 01 8F 91 ?? ?? 02 20 C8 21 ?? ?? ?? ?? 02 00 20 21 8F B5 01 DC 02 80 C8 21 ?? ?? ?? ?? 02 A0 20 21 24 46 00 01 02 A0 28 21 02 20 C8 21 ?? ?? ?? ?? 02 00 20 21 02 80 C8 21 ?? ?? ?? ?? 8F A4 01 E0 8F A5 01 E0 02 00 20 21 02 20 C8 21 ?? ?? ?? ?? 24 46 00 01 8F A4 01 D8 8F A3 01 98 10 83 00 05 8F BC 00 20 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 20 8F A4 01 DC 8F B9 01 9C 10 99 00 04 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 20 8F 95 ?? ?? 27 B4 01 28 02 00 20 21 02 80 28 21 02 A0 C8 21 ?? ?? ?? ?? 24 06 00 01 24 03 00 01 10 43 00 06 8F BC 00 20 8F 99 ?? ?? ?? ?? ?? ?? 8E 64 00 00 10 00 00 1B 8F BC 00 20 83 A2 01 28 10 40 00 14 8F 99 ?? ?? 24 13 00 0A 02 00 20 21 02 80 28 21 02 A0 C8 21 ?? ?? ?? ?? 24 06 00 01 24 03 00 01 14 43 00 0F 8F BC 00 20 24 04 00 02 02 80 28 21 02 20 C8 21 ?? ?? ?? ?? 24 06 00 01 83 A2 01 28 14 53 FF F1 8F BC 00 20 10 00 00 05 00 00 00 00 ?? ?? ?? ?? 8F A4 01 90 10 00 00 10 02 00 10 21 12 40 00 06 8F A3 01 E4 8C 64 00 00 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 20 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F BC 00 20 8F 99 ?? ?? ?? ?? ?? ?? 8F A4 01 90 24 02 FF FF 8F BF 01 CC 8F BE 01 C8 8F B7 01 C4 8F B6 01 C0 8F B5 01 BC 8F B4 01 B8 8F B3 01 B4 8F B2 01 B0 8F B1 01 AC 8F B0 01 A8 03 E0 00 08 27 BD 01 D0 }
	condition:
		$1
}

rule file_342_1_0 {
	meta:
		name = "rexec"
		size = 68
		refs = "0000 _gp_disp 0014 __GI_rexec_af"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 8F A2 00 40 8F 99 ?? ?? AF BF 00 2C AF A2 00 10 8F A2 00 44 AF BC 00 20 AF A2 00 14 24 02 00 02 ?? ?? ?? ?? AF A2 00 18 8F BF 00 2C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_345_0_0 {
	meta:
		name = "__drand48_iterate"
		size = 144
	strings:
		$1 = { 94 A2 00 0E 54 40 00 0B 94 82 00 02 24 02 00 05 3C 03 DE EC AC A2 00 10 24 02 00 0B 34 63 E6 6D A4 A2 00 0C 24 02 00 01 AC A3 00 14 A4 A2 00 0E 94 82 00 02 94 83 00 00 8C A6 00 10 00 02 14 00 00 62 10 25 00 C2 00 18 8C A3 00 14 94 87 00 04 70 67 00 00 00 00 30 12 00 62 00 19 00 00 10 10 00 C2 30 21 94 A2 00 0C 00 00 18 12 00 62 10 21 00 43 18 2B 00 66 18 21 A4 82 00 00 00 02 14 02 A4 82 00 02 A4 83 00 04 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_346_0_0 {
	meta:
		name = "valloc"
		size = 100
		refs = "0000 _gp_disp 0030 __GI_getpagesize 0058 memalign"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B0 00 1C 8F 90 ?? ?? AF BC 00 10 AF B1 00 20 8E 02 ?? ?? AF BF 00 24 14 40 00 06 00 80 88 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 AE 02 ?? ?? 8F BF 00 24 8E 04 ?? ?? 02 20 28 21 8F B0 00 1C 8F B1 00 20 8F 99 ?? ?? ?? ?? ?? ?? 27 BD 00 28 }
	condition:
		$1
}

rule file_348_1_0 {
	meta:
		name = "authunix_marshal"
		size = 28
	strings:
		$1 = { 8C 82 00 24 8C A3 00 04 00 A0 20 21 8C 46 01 AC 8C 79 00 0C 03 20 00 08 24 45 00 1C }
	condition:
		$1
}

rule file_348_2_0 {
	meta:
		name = "authunix_destroy"
		size = 148
		refs = "0000 _gp_disp 0024 free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF BC 00 10 AF B0 00 1C AF BF 00 24 AF B1 00 20 8C 91 00 24 8F 99 ?? ?? 00 80 80 21 ?? ?? ?? ?? 8E 24 00 04 8E 24 00 10 10 80 00 05 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 8E 04 00 24 8E 04 00 10 10 80 00 05 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F BF 00 24 8F B1 00 20 02 00 20 21 8F 99 ?? ?? 8F B0 00 1C ?? ?? ?? ?? 27 BD 00 28 }
	condition:
		$1
}

rule file_348_3_0 {
	meta:
		name = "marshal_new_auth"
		size = 232
		refs = "0000 _gp_disp 002c __GI_xdrmem_create 0054 __GI_xdr_opaque_auth 0070 __GI_perror 006c $LC0"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF BC 00 10 AF BF 00 44 AF B3 00 40 AF B1 00 38 AF B0 00 34 AF B2 00 3C 8C 92 00 24 8F 99 ?? ?? 27 B0 00 18 00 80 88 21 26 45 00 1C 02 00 20 21 24 06 01 90 ?? ?? ?? ?? 00 00 38 21 8F BC 00 10 02 00 20 21 8F 93 ?? ?? 02 60 C8 21 ?? ?? ?? ?? 02 20 28 21 14 40 00 07 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 84 ?? ?? 10 00 00 0D 8F A2 00 1C 02 00 20 21 02 60 C8 21 ?? ?? ?? ?? 26 25 00 0C 10 40 FF F5 8F BC 00 10 8F A2 00 1C 8C 59 00 10 03 20 F8 09 02 00 20 21 AE 42 01 AC 8F A2 00 1C 8C 59 00 1C 13 20 00 04 8F BF 00 44 03 20 F8 09 02 00 20 21 8F BF 00 44 8F B3 00 40 8F B2 00 3C 8F B1 00 38 8F B0 00 34 24 02 00 01 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_348_4_0 {
	meta:
		name = "authunix_refresh"
		size = 368
		refs = "0000 _gp_disp 0050 __GI_xdrmem_create 0080 __GI_xdr_authunix_parms 009c __GI_gettimeofday 0108 marshal_new_auth"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 90 AF B2 00 5C AF BC 00 10 AF BF 00 6C AF B5 00 68 AF B4 00 64 AF B3 00 60 AF B1 00 58 AF B0 00 54 8C 90 00 24 8C 83 00 04 8E 02 00 04 10 62 00 42 00 80 90 21 8E 02 00 18 AF A0 00 44 AF A0 00 34 8F 99 ?? ?? 8E 05 00 04 8E 06 00 08 24 42 00 01 27 B1 00 18 AE 02 00 18 02 20 20 21 ?? ?? ?? ?? 24 07 00 01 8F BC 00 10 27 B4 00 30 02 20 20 21 8F 95 ?? ?? 02 80 28 21 02 A0 C8 21 ?? ?? ?? ?? 00 00 98 21 10 40 00 1E 8F BC 00 10 8F 99 ?? ?? 27 A4 00 48 ?? ?? ?? ?? 00 00 28 21 8F A2 00 48 02 20 20 21 AF A2 00 30 8F A2 00 1C AF A0 00 18 8C 59 00 14 03 20 F8 09 00 00 28 21 02 20 20 21 02 A0 C8 21 ?? ?? ?? ?? 02 80 28 21 00 40 98 21 10 40 00 0B 8F BC 00 10 8E 02 00 00 8F 99 ?? ?? 02 40 20 21 AE 42 00 00 8E 02 00 04 27 39 ?? ?? AE 42 00 04 8E 02 00 08 ?? ?? ?? ?? AE 42 00 08 24 02 00 02 02 A0 C8 21 AF A2 00 18 02 20 20 21 ?? ?? ?? ?? 02 80 28 21 8F A2 00 1C 8C 59 00 1C 53 20 00 06 02 60 10 21 03 20 F8 09 02 20 20 21 10 00 00 02 02 60 10 21 00 00 10 21 8F BF 00 6C 8F B5 00 68 8F B4 00 64 8F B3 00 60 8F B2 00 5C 8F B1 00 58 8F B0 00 54 03 E0 00 08 27 BD 00 70 }
	condition:
		$1
}

rule file_348_5_0 {
	meta:
		name = "authunix_validate"
		size = 292
		refs = "0000 _gp_disp 0044 __GI_xdrmem_create 006c free 0080 __GI_xdr_opaque_auth 00f8 marshal_new_auth"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B1 00 34 AF BC 00 10 AF BF 00 44 AF B4 00 40 AF B3 00 3C AF B2 00 38 AF B0 00 30 00 80 88 21 8C A4 00 00 24 03 00 02 14 83 00 31 00 A0 10 21 8E 30 00 24 8F 99 ?? ?? 8C A5 00 04 8C 46 00 08 27 B2 00 18 02 40 20 21 ?? ?? ?? ?? 24 07 00 01 8E 04 00 10 10 80 00 06 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 AE 00 00 10 8F 93 ?? ?? 26 14 00 0C 02 40 20 21 02 60 C8 21 ?? ?? ?? ?? 02 80 28 21 10 40 00 07 8F BC 00 10 8E 02 00 0C AE 22 00 00 8E 02 00 10 AE 22 00 04 10 00 00 0E 8E 02 00 14 24 02 00 02 AF A2 00 18 02 40 20 21 02 60 C8 21 ?? ?? ?? ?? 02 80 28 21 8E 02 00 00 8F BC 00 10 AE 00 00 10 AE 22 00 00 8E 02 00 04 AE 22 00 04 8E 02 00 08 8F 99 ?? ?? AE 22 00 08 27 39 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BF 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 24 02 00 01 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_348_6_0 {
	meta:
		name = "__GI_authunix_create"
		size = 524
		refs = "0000 _gp_disp 000c malloc 006c stderr 0074 __GI_fputs 0070 $LC1 0088 free 00b0 __GI_gettimeofday 00c4 _null_auth 0110 __GI_xdrmem_create 0148 __GI_xdr_authunix_parms 015c __GI_abort 01a4 __GI_memcpy 01dc marshal_new_auth"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FE 00 AF BC 00 10 AF BF 01 FC AF B5 01 F8 AF B4 01 F4 AF B3 01 F0 AF B2 01 EC AF B1 01 E8 AF B0 01 E4 00 80 A8 21 24 04 00 28 00 A0 A0 21 00 C0 98 21 ?? ?? ?? ?? 00 E0 90 21 8F BC 00 10 24 04 01 B0 8F 99 ?? ?? ?? ?? ?? ?? 00 40 88 21 00 40 80 21 16 20 00 11 8F BC 00 10 8F 82 ?? ?? 8F 84 ?? ?? 8F 99 ?? ?? 8C 45 00 00 ?? ?? ?? ?? 24 84 ?? ?? 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 10 00 00 50 00 00 10 21 10 40 FF EF 8F 99 ?? ?? 8F 82 ?? ?? 00 00 28 21 24 42 ?? ?? AE 22 00 20 8F 82 ?? ?? AE 30 00 24 AE 00 00 18 8C 43 00 04 8C 44 00 00 8C 42 00 08 AE 03 00 10 AE 23 00 10 AE 04 00 0C AE 24 00 0C AE 02 00 14 27 A4 01 D8 ?? ?? ?? ?? AE 22 00 14 8F A2 01 D8 8F BC 00 10 AF B3 01 CC AF A2 01 C0 8F A2 02 10 8F 99 ?? ?? AF B2 01 D0 27 B3 00 18 27 B2 01 A8 AF A2 01 D4 02 40 20 21 02 60 28 21 24 06 01 90 00 00 38 21 AF B5 01 C4 ?? ?? ?? ?? AF B4 01 C8 8F BC 00 10 02 40 20 21 8F 99 ?? ?? ?? ?? ?? ?? 27 A5 01 C0 14 40 00 04 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F A2 01 AC 8C 59 00 10 03 20 F8 09 02 40 20 21 8F BC 00 10 00 40 90 21 AE 02 00 08 8F 99 ?? ?? 24 02 00 01 AE 02 00 00 ?? ?? ?? ?? 02 40 20 21 AE 02 00 04 10 40 FF B3 8F BC 00 10 8F 99 ?? ?? 00 40 20 21 02 60 28 21 ?? ?? ?? ?? 02 40 30 21 8E 02 00 00 8F BC 00 10 02 20 20 21 AE 22 00 00 8E 02 00 04 8F 99 ?? ?? AE 22 00 04 8E 02 00 08 27 39 ?? ?? ?? ?? ?? ?? AE 22 00 08 02 20 10 21 8F BF 01 FC 8F B5 01 F8 8F B4 01 F4 8F B3 01 F0 8F B2 01 EC 8F B1 01 E8 8F B0 01 E4 03 E0 00 08 27 BD 02 00 }
	condition:
		$1
}

rule file_348_7_0 {
	meta:
		name = "__GI_authunix_create_default"
		size = 300
		refs = "0000 _gp_disp 000c __GI_sysconf 0044 malloc 005c __GI_abort 006c __GI_gethostname 008c __GI_geteuid 009c __GI_getegid 00b4 __GI_getgroups 00d0 __GI_authunix_create 00fc free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FE C0 AF BC 00 18 AF B1 01 2C AF BF 01 3C AF B4 01 38 AF B3 01 34 AF B2 01 30 AF B0 01 28 ?? ?? ?? ?? 24 04 00 03 00 40 88 21 10 40 00 0A 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 02 20 80 00 40 80 21 14 40 00 05 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 80 21 8F 99 ?? ?? 27 B2 00 20 02 40 20 21 ?? ?? ?? ?? 24 05 00 FF 24 03 FF FF 10 43 FF F5 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? A3 A0 01 1F 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 40 A0 21 8F BC 00 18 02 20 20 21 02 00 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 98 21 00 40 18 21 04 40 FF E5 8F BC 00 18 28 47 00 11 8F 99 ?? ?? 24 02 00 10 00 67 10 0B 02 80 28 21 02 60 30 21 AF B0 00 10 02 40 20 21 ?? ?? ?? ?? 00 40 38 21 8F BC 00 18 02 00 20 21 8F 99 ?? ?? ?? ?? ?? ?? AF A2 01 20 8F BF 01 3C 8F A2 01 20 8F B4 01 38 8F B3 01 34 8F B2 01 30 8F B1 01 2C 8F B0 01 28 03 E0 00 08 27 BD 01 40 }
	condition:
		$1
}

rule file_349_0_0 {
	meta:
		name = "_setjmp"
		size = 24
		refs = "0000 _gp_disp 000c __sigsetjmp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 03 20 00 08 00 00 28 21 }
	condition:
		$1
}

rule file_350_0_0 {
	meta:
		name = "__open_etc_hosts"
		size = 124
		refs = "0000 _gp_disp 0020 __GI_fopen 0010 $LC0 0038 $LC1 0044 $LC2"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 8F 84 ?? ?? AF B1 00 20 AF B0 00 1C 8F 91 ?? ?? 8F 90 ?? ?? AF BC 00 10 AF BF 00 24 24 84 ?? ?? 02 00 C8 21 ?? ?? ?? ?? 26 25 ?? ?? 14 40 00 0A 8F BC 00 10 8F 84 ?? ?? 8F BF 00 24 26 25 ?? ?? 02 00 C8 21 8F B1 00 20 8F B0 00 1C 24 84 ?? ?? ?? ?? ?? ?? 27 BD 00 28 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_350_1_0 {
	meta:
		name = "__read_etc_hosts_r"
		size = 784
		refs = "0000 _gp_disp 009c __open_etc_hosts 00bc __GI___errno_location 0100 __GI_fgets 011c __GI_strchrnul 0150 __GI___ctype_b 01ac __GI_strcmp 01e8 __GI_strcasecmp 0214 __GI_inet_pton 0278 __GI_fclose"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B0 8F A3 00 70 AF B4 00 38 00 80 A0 21 8F A4 00 64 AF BC 00 10 24 02 FF FF AF B3 00 34 AF B2 00 30 AF B0 00 28 AF BF 00 4C AF BE 00 48 AF B7 00 44 AF B6 00 40 AF B5 00 3C AF B1 00 2C AC 62 00 00 8F A2 00 68 00 04 18 23 30 63 00 03 00 43 10 23 24 53 FF E0 AF A5 00 54 8F B0 00 60 06 60 00 9B 24 12 00 22 00 83 B8 21 24 04 00 01 00 C0 F0 21 00 E0 A8 21 10 E4 00 18 26 F1 00 20 24 53 FF D4 2A 62 00 50 14 40 00 92 8F BF 00 4C 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 00 40 A0 21 14 40 00 08 8F BC 00 10 8F B9 00 6C AF 20 00 00 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 84 8C 52 00 00 26 F6 00 28 AF B1 00 18 AE F6 00 20 AE E0 00 24 10 00 00 03 26 F1 00 2C 00 00 B0 21 AF A0 00 18 8F A3 00 70 24 02 00 01 24 12 00 01 AC 62 00 00 8F 99 ?? ?? 02 20 20 21 02 60 28 21 ?? ?? ?? ?? 02 80 30 21 10 40 00 55 8F BC 00 10 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 24 05 00 23 8F BC 00 10 00 00 30 21 A0 40 00 00 02 20 10 21 80 44 00 00 50 80 00 05 00 06 10 80 80 44 00 00 14 80 00 09 8F 83 ?? ?? 00 06 10 80 02 E2 10 21 AC 40 00 00 28 C2 00 02 10 40 00 0D 24 02 00 01 10 00 FF E5 8F 99 ?? ?? 00 04 20 40 8C 65 00 00 00 A4 20 21 94 84 00 00 30 84 00 20 10 80 00 40 00 60 28 21 A0 40 00 00 10 00 FF EC 24 42 00 01 12 A2 00 4F 24 02 00 02 16 A2 00 0D 24 07 00 01 8F 99 ?? ?? 8F A4 00 54 ?? ?? ?? ?? 8E E5 00 00 14 40 FF D0 8F BC 00 10 10 00 00 12 24 02 00 02 24 E7 00 01 00 E6 10 2A 10 40 FF CB 8F 99 ?? ?? 00 07 10 80 02 E2 10 21 8C 45 00 00 8F 99 ?? ?? 8F A4 00 54 AF A6 00 1C ?? ?? ?? ?? AF A7 00 20 8F BC 00 10 8F A6 00 1C 14 40 FF F1 8F A7 00 20 24 02 00 02 13 C2 00 03 8F 99 ?? ?? 10 00 FF B9 24 12 00 02 8E E5 00 00 24 04 00 02 ?? ?? ?? ?? 02 C0 30 21 18 40 FF F9 8F BC 00 10 24 02 00 04 AE 1E 00 08 AE 02 00 0C 8F A3 00 18 8E E2 00 04 8F B9 00 6C AE 03 00 10 26 E3 00 08 AE 02 00 00 AE 03 00 04 00 00 90 21 10 00 00 04 AF 30 00 00 24 02 00 01 52 A2 00 1B 8F BF 00 4C 8F 99 ?? ?? ?? ?? ?? ?? 02 80 20 21 10 00 00 16 8F BF 00 4C 28 C4 00 07 50 80 00 0E 80 44 00 00 00 06 20 80 02 E4 20 21 AC 82 00 00 10 00 00 08 24 C6 00 01 00 04 20 40 00 E4 20 21 94 84 00 00 30 84 00 20 54 80 FF A0 80 44 00 00 24 42 00 01 80 44 00 00 54 80 FF F7 8C A7 00 00 10 00 FF 9A 00 00 00 00 8F BF 00 4C 02 40 10 21 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_351_0_0 {
	meta:
		name = "__GI_lockf"
		size = 332
		refs = "0000 _gp_disp 0010 __GI_memset 007c __GI___errno_location 0090 __GI_fcntl 00b4 __GI_getpid"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A8 8F 99 ?? ?? AF B1 00 48 27 B1 00 18 AF BC 00 10 AF B3 00 50 AF B2 00 4C AF B0 00 44 00 C0 98 21 AF BF 00 54 00 80 90 21 00 A0 80 21 02 20 20 21 00 00 28 21 ?? ?? ?? ?? 24 06 00 24 24 02 00 01 A7 A2 00 1A 24 02 00 01 8F BC 00 10 12 02 00 21 AF B3 00 20 2A 03 00 02 10 60 00 05 24 13 00 02 12 00 00 1F 24 02 00 02 10 00 00 21 8F 99 ?? ?? 52 13 00 1C A7 A2 00 18 24 02 00 03 16 02 00 1B 8F 99 ?? ?? 02 40 20 21 24 05 00 0E ?? ?? ?? ?? 02 20 30 21 04 40 00 21 8F BC 00 10 87 A2 00 18 14 53 00 03 8F 99 ?? ?? 10 00 00 1D 00 00 10 21 ?? ?? ?? ?? 8F B0 00 28 12 02 FF FB 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 0B 24 03 00 0D A7 B0 00 18 10 00 00 0A 24 05 00 07 A7 A2 00 18 10 00 00 07 24 05 00 06 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 10 00 00 07 AC 43 00 00 8F 99 ?? ?? 02 40 20 21 ?? ?? ?? ?? 02 20 30 21 10 00 00 03 8F BF 00 54 24 02 FF FF 8F BF 00 54 8F B3 00 50 8F B2 00 4C 8F B1 00 48 8F B0 00 44 03 E0 00 08 27 BD 00 58 }
	condition:
		$1
}

rule file_352_0_0 {
	meta:
		name = "__GI_memcmp"
		size = 716
	strings:
		$1 = { 2C C2 00 10 14 40 00 AC 00 00 00 00 30 A2 00 03 10 40 00 09 00 A0 78 21 90 83 00 00 90 A2 00 00 24 84 00 01 00 62 10 23 14 40 00 A6 24 A5 00 01 10 00 FF F6 24 C6 FF FF 30 82 00 03 00 80 70 21 14 40 00 35 00 06 18 82 30 62 00 03 24 07 00 01 50 47 00 13 8C 87 00 00 10 40 00 0E 24 07 00 03 50 47 00 07 8C 87 00 00 8C 89 00 00 8C A8 00 00 24 84 FF F8 24 A5 FF F8 10 00 00 16 24 63 00 02 8C A2 00 00 24 84 FF FC 24 A5 FF FC 10 00 00 0E 24 63 00 01 8C 89 00 00 10 00 00 08 8C A8 00 00 8C A2 00 00 24 84 00 04 24 A5 00 04 24 63 FF FF 8C 89 00 00 14 E2 00 16 8C A8 00 00 8C 87 00 04 15 28 00 07 8C A2 00 04 8C 89 00 08 14 E2 00 10 8C A8 00 08 8C 87 00 0C 11 28 00 06 8C A2 00 0C 01 09 40 2B 24 02 FF FF 24 03 00 01 10 00 00 65 00 68 10 0B 24 63 FF FC 10 60 00 03 24 84 00 10 10 00 FF EB 24 A5 00 10 50 E2 00 5E 00 00 10 21 10 00 00 3E 00 47 38 2B 00 02 20 C0 24 09 00 20 24 02 FF FC 30 67 00 03 24 08 00 01 01 24 48 23 10 E8 00 16 01 C2 10 24 10 E0 00 0F 24 08 00 03 50 E8 00 08 8C A7 00 00 8C 4B 00 00 8C 48 00 04 8C AD 00 00 24 42 FF FC 24 A5 FF F8 10 00 00 2F 24 63 00 02 8C 4C 00 00 8C 4B 00 04 24 A5 FF FC 10 00 00 1F 24 63 00 01 8C 4A 00 00 8C 4C 00 04 8C AD 00 00 10 00 00 0F 24 42 00 04 8C 48 00 00 8C 4A 00 04 8C A7 00 00 24 42 00 08 24 A5 00 04 24 63 FF FF 01 2A C0 06 00 88 58 04 03 0B 40 25 8C 4C 00 00 11 07 00 03 8C AD 00 00 10 00 00 13 00 E8 38 2B 01 2C C0 06 00 8A 40 04 03 08 50 25 8C 4B 00 04 11 4D 00 06 8C A7 00 04 01 AA 50 2B 24 02 FF FF 24 03 00 01 10 00 00 26 00 6A 10 0B 01 2B C0 06 00 8C 50 04 03 0A 60 25 8C 48 00 08 11 87 00 06 8C AD 00 08 00 EC 38 2B 24 02 FF FF 24 03 00 01 10 00 00 1B 00 67 10 0B 01 28 C0 06 00 8B 60 04 03 0C 58 25 8C 4A 00 0C 11 6D 00 06 8C A7 00 0C 01 AB 58 2B 24 02 FF FF 24 03 00 01 10 00 00 10 00 6B 10 0B 24 63 FF FC 50 60 00 04 01 2A 48 06 24 42 00 10 10 00 FF D2 24 A5 00 10 00 88 20 04 01 24 20 25 10 87 00 05 00 E4 20 2B 24 02 FF FF 24 03 00 01 10 00 00 02 00 64 10 0B 00 00 10 21 14 40 00 0F 24 05 FF FC 00 C5 28 24 00 AE 20 21 30 C6 00 03 10 00 00 07 00 AF 28 21 90 A2 00 00 24 84 00 01 00 62 10 23 14 40 00 05 24 A5 00 01 24 C6 FF FF 54 C0 FF F9 90 83 00 00 00 00 10 21 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_353_0_0 {
	meta:
		name = "__GI_erand48_r"
		size = 180
		refs = "0000 _gp_disp 000c __drand48_iterate 0050 __subdf3 0080 $LC0"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BC 00 10 AF B1 00 20 AF B0 00 1C AF BF 00 24 00 80 80 21 ?? ?? ?? ?? 00 C0 88 21 04 40 00 1A 8F BC 00 10 00 00 10 21 24 03 03 FF 7C 02 FF C4 7C 62 F5 04 96 04 00 04 96 03 00 02 8F 99 ?? ?? 00 04 21 00 00 03 2B 02 00 A4 20 25 96 05 00 00 7C 82 98 04 00 03 25 00 00 05 29 00 00 A4 18 25 00 40 20 21 8F 82 ?? ?? 00 60 28 21 8C 47 ?? ?? ?? ?? ?? ?? 8C 46 ?? ?? AE 22 00 00 AE 23 00 04 10 00 00 02 00 00 10 21 24 02 FF FF 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_354_0_0 {
	meta:
		name = "__GI_strrchr"
		size = 152
		refs = "0000 _gp_disp 002c __GI_strchr"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B2 00 20 AF BC 00 10 30 B2 00 FF AF B1 00 1C AF BF 00 24 AF B0 00 18 12 40 00 04 8F 91 ?? ?? 00 80 18 21 10 00 00 09 00 00 80 21 8F BF 00 24 8F B2 00 20 8F B0 00 18 02 20 C8 21 8F B1 00 1C 00 00 28 21 ?? ?? ?? ?? 27 BD 00 28 00 60 20 21 02 20 C8 21 ?? ?? ?? ?? 02 40 28 21 10 40 00 03 24 43 00 01 10 00 FF F9 00 40 80 21 8F BF 00 24 02 00 10 21 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_355_0_0 {
	meta:
		name = "_ppfs_parsespec"
		size = 1320
		refs = "0000 _gp_disp 00b0 __GI___ctype_b 04b8 __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 98 AF B1 00 54 AF BC 00 10 AF BF 00 64 AF B4 00 60 AF B3 00 5C AF B2 00 58 AF B0 00 50 00 80 88 21 8C 92 00 18 8C 84 00 10 24 02 00 08 AF A0 00 38 30 84 00 80 AF A0 00 3C AF A2 00 44 AF A2 00 48 10 80 00 17 8E 23 00 00 3C 08 3F FF 00 00 10 21 35 08 FF FF 27 A9 00 18 24 07 00 20 00 48 30 21 00 06 30 80 00 66 30 21 80 C5 00 03 01 22 50 21 A1 45 00 00 8C C6 00 00 10 A6 00 03 00 00 00 00 10 00 01 1D 24 02 FF FF 10 A0 00 03 24 42 00 01 14 47 FF F3 00 48 30 21 A3 A0 00 37 27 A3 00 19 8F 8D ?? ?? 8F 98 ?? ?? 00 00 28 21 00 00 38 21 24 08 00 2A 27 A9 00 18 24 0E 00 0A 24 0A 00 25 24 0F 00 2E 24 0B 00 24 24 19 00 30 80 6C 00 00 15 88 00 06 00 60 80 21 00 05 10 23 00 02 10 80 01 22 10 21 AC 40 00 2C 24 70 00 01 00 00 10 21 82 06 00 00 8D B4 00 00 00 06 98 40 02 93 98 21 96 73 00 00 32 73 00 08 12 60 00 07 28 53 0F FF 12 60 FF F7 26 10 00 01 70 4E 98 02 24 C6 FF D0 10 00 FF F3 02 66 10 21 80 73 FF FF 56 6A 00 29 80 66 00 00 14 CB 00 09 00 00 00 00 18 40 00 07 00 00 00 00 12 40 FF CE 26 03 00 01 02 42 30 2A AF A2 00 40 10 00 00 07 00 46 90 0B 1E 40 FF C8 00 70 30 2B 10 C0 00 03 00 00 90 21 55 99 00 19 80 66 00 00 00 60 80 21 24 06 00 01 27 02 ?? ?? 82 13 00 00 80 4C 00 00 16 6C 00 04 24 43 00 01 26 10 00 01 10 00 FF F8 00 86 20 25 80 4C 00 01 00 06 30 40 15 80 FF F6 00 60 10 21 30 82 00 0A 00 02 10 43 00 02 10 27 00 82 20 24 82 02 FF FF 10 4A 00 03 00 00 10 21 10 00 FF C0 02 00 18 21 80 66 00 00 14 C8 00 10 00 00 00 00 52 40 00 0B 24 63 00 01 82 06 00 00 14 CB FF A5 26 03 00 01 18 40 FF A3 00 05 30 23 00 06 30 80 01 26 30 21 AC C2 00 20 10 00 00 03 00 60 80 21 16 03 00 BA 24 02 FF FF 3C 02 80 00 14 A0 00 09 8F 83 ?? ?? 82 03 00 00 14 6F 00 04 00 40 38 21 26 10 00 01 10 00 FF E5 24 05 FF FF 24 02 FF FF 8F 83 ?? ?? 24 63 ?? ?? 00 60 28 21 82 08 00 00 80 66 00 00 55 06 00 03 24 63 00 01 10 00 00 04 26 10 00 01 80 66 00 00 54 C0 FF FA 82 08 00 00 00 65 28 23 28 A5 00 02 50 A0 00 08 80 66 00 09 82 06 00 00 80 65 00 00 54 C5 00 04 80 66 00 09 24 63 00 09 26 10 00 01 80 66 00 09 82 05 00 00 10 A0 FF 78 00 06 32 00 8F 83 ?? ?? 24 63 ?? ?? 00 60 40 21 80 69 00 00 55 25 00 21 24 63 00 01 00 68 18 23 28 65 00 12 14 A0 00 05 8F 85 ?? ?? 30 C9 04 00 24 65 FF FE 00 A9 18 0B 8F 85 ?? ?? AE 23 00 20 24 A5 ?? ?? 24 A5 00 01 80 A9 00 00 01 23 48 2A 55 20 FF FD 24 A5 00 01 8F 83 ?? ?? 8F 89 ?? ?? 24 63 ?? ?? 00 A3 28 23 8F 83 ?? ?? 00 05 28 40 25 29 ?? ?? 24 63 ?? ?? 00 A3 18 21 84 63 00 00 00 A9 28 21 84 A5 00 00 00 C3 18 25 00 65 18 24 AF A3 00 4C 10 00 00 04 01 00 18 21 80 69 00 00 15 20 FF DB 00 00 00 00 82 05 00 00 AE 22 00 04 AE 27 00 08 AE 25 00 0C 30 87 00 04 24 02 00 30 24 05 00 20 00 A7 10 0A AE 22 00 14 24 02 FF FB 00 82 20 24 30 C6 0F 00 00 C4 20 25 24 02 00 01 AE 24 00 10 AE 22 00 1C 80 63 00 00 50 60 00 5A 24 02 FF FF 1A 40 00 44 8F 89 ?? ?? 8F 85 ?? ?? 8F 8B ?? ?? 25 29 ?? ?? 24 A5 ?? ?? 25 6B ?? ?? 00 00 10 21 27 A7 00 18 24 08 00 08 01 20 70 21 00 A0 50 21 00 A0 78 21 01 60 C0 21 24 0D 00 03 00 02 20 80 00 E4 18 21 8C 63 00 20 02 22 30 21 A0 C3 00 24 30 63 00 FF 02 43 30 2A 50 C0 00 05 00 E4 20 21 28 66 00 0A 10 C0 FF 21 00 60 90 21 00 E4 20 21 24 63 FF FF 8C 84 00 2C 00 03 60 80 02 2C 18 21 10 88 00 1F 8C 66 00 28 50 C8 00 1C 02 2C 60 21 10 C4 00 19 01 20 18 21 24 63 FF FE 84 79 00 00 13 26 00 03 00 A3 C8 2B 57 20 FF FC 24 63 FF FE 00 6A 18 23 00 03 18 43 00 6B 18 21 90 66 00 00 01 C0 18 21 24 63 FF FE 84 79 00 00 13 24 00 03 01 43 C8 2B 57 20 FF FC 24 63 FF FE 00 6F 18 23 00 03 18 43 03 03 18 21 90 63 00 00 00 66 18 2A 54 60 00 04 24 42 00 01 02 2C 60 21 AD 84 00 28 24 42 00 01 14 4D FF CE 00 02 20 80 10 00 00 08 8E 22 00 10 8F 99 ?? ?? A2 22 00 26 26 24 00 28 27 A5 00 4C ?? ?? ?? ?? 24 06 00 04 8E 22 00 10 30 42 00 80 14 40 00 03 AE 32 00 18 10 00 00 06 26 10 00 01 27 A2 00 18 02 02 80 23 8E 22 00 00 00 10 80 80 00 50 80 21 8E 22 00 1C AE 30 00 00 24 42 00 02 8F BF 00 64 8F B4 00 60 8F B3 00 5C 8F B2 00 58 8F B1 00 54 8F B0 00 50 03 E0 00 08 27 BD 00 68 }
	condition:
		$1
}

rule file_356_0_0 {
	meta:
		name = "fdatasync"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 38 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_357_0_0 {
	meta:
		name = "__GI_isalnum"
		size = 40
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 00 04 20 40 8C 42 00 00 00 44 10 21 94 42 00 00 03 E0 00 08 30 42 08 00 }
	condition:
		$1
}

rule file_358_0_0 {
	meta:
		name = "msgctl"
		size = 76
		refs = "0000 _gp_disp 000c __syscall_ipc"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 00 80 18 21 34 A2 01 00 24 04 00 0E AF BF 00 24 AF BC 00 18 AF A6 00 10 AF A0 00 14 00 60 28 21 00 40 30 21 ?? ?? ?? ?? 00 00 38 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_359_0_0 {
	meta:
		name = "__GI_isxdigit"
		size = 40
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 00 04 20 40 8C 42 00 00 00 44 10 21 94 42 00 00 03 E0 00 08 30 42 00 10 }
	condition:
		$1
}

rule file_360_0_0 {
	meta:
		name = "__init_scan_cookie"
		size = 92
		refs = "0000 _gp_disp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 AC 85 00 08 AC 80 00 0C A0 80 00 19 94 A3 00 00 30 63 00 02 10 60 00 02 00 00 10 21 8C A2 00 28 AC 82 00 14 8F 82 ?? ?? A0 80 00 1A A0 80 00 1B 24 42 ?? ?? AC 82 00 30 AC 82 00 3C 24 02 00 01 AC 82 00 34 24 02 00 2E 03 E0 00 08 AC 82 00 38 }
	condition:
		$1
}

rule file_360_1_0 {
	meta:
		name = "__scan_getc"
		size = 136
	strings:
		$1 = { 8C 82 00 10 27 BD FF D8 AF B1 00 20 24 42 FF FF 24 11 FF FF AF B0 00 1C AF BF 00 24 00 80 80 21 AC 91 00 00 04 40 00 09 AC 82 00 10 80 82 00 19 54 40 00 0B A0 80 00 19 8C 99 00 2C 03 20 F8 09 00 00 00 00 54 51 00 06 AE 02 00 04 92 02 00 19 34 42 00 02 A2 02 00 19 10 00 00 06 24 02 FF FF 8E 02 00 0C 24 42 00 01 AE 02 00 0C 8E 02 00 04 AE 02 00 00 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_360_2_0 {
	meta:
		name = "__scan_ungetc"
		size = 76
	strings:
		$1 = { 8C 82 00 10 24 03 00 02 24 42 00 01 AC 82 00 10 80 82 00 19 14 43 00 05 00 00 00 00 8C 82 00 04 A0 80 00 19 03 E0 00 08 AC 82 00 00 14 40 00 05 24 02 00 01 A0 82 00 19 8C 82 00 0C 24 42 FF FF AC 82 00 0C 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_361_0_0 {
	meta:
		name = "posix_fadvise"
		size = 88
	strings:
		$1 = { 27 BD FF F8 00 A0 10 21 AF B0 00 00 00 C0 80 21 AF B1 00 04 00 02 37 C3 00 E0 88 21 00 00 28 21 00 40 38 21 00 10 17 C3 27 BD FF E0 AF A2 00 10 AF B0 00 14 AF B1 00 18 24 02 10 9E 00 00 00 0C 27 BD 00 20 8F B1 00 04 8F B0 00 00 00 07 10 0A 03 E0 00 08 27 BD 00 08 }
	condition:
		$1
}

rule file_362_0_0 {
	meta:
		name = "__GI_xdr_reference"
		size = 264
		refs = "0000 _gp_disp 005c malloc 0080 stderr 0088 __GI_fputs 0084 $LC0 00a0 __GI_memset 00d4 free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B3 00 30 AF B2 00 2C AF B1 00 28 AF BC 00 10 AF BF 00 34 AF B0 00 24 8C B0 00 00 00 80 90 21 00 A0 88 21 16 00 00 1E 00 E0 98 21 8C 83 00 00 24 02 00 01 10 62 00 05 24 04 00 02 10 64 00 28 8F BF 00 34 10 00 00 17 02 40 20 21 8F 99 ?? ?? 00 C0 20 21 ?? ?? ?? ?? AF A6 00 18 00 40 80 21 8F BC 00 10 AE 22 00 00 14 40 00 09 8F A6 00 18 8F 82 ?? ?? 8F 84 ?? ?? 8F 99 ?? ?? 8C 45 00 00 ?? ?? ?? ?? 24 84 ?? ?? 10 00 00 14 00 00 10 21 8F 99 ?? ?? 00 40 20 21 ?? ?? ?? ?? 00 00 28 21 02 40 20 21 02 00 28 21 02 60 C8 21 03 20 F8 09 24 06 FF FF 8E 43 00 00 24 04 00 02 14 64 00 07 8F BC 00 10 8F 99 ?? ?? AF A2 00 18 ?? ?? ?? ?? 02 00 20 21 8F A2 00 18 AE 20 00 00 8F BF 00 34 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_362_1_0 {
	meta:
		name = "xdr_pointer"
		size = 156
		refs = "0000 _gp_disp 0024 __GI_xdr_bool 0070 __GI_xdr_reference"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF BC 00 10 AF B1 00 30 AF B0 00 2C AF BF 00 34 8C A2 00 00 8F 99 ?? ?? AF A6 00 20 00 02 10 2B AF A7 00 24 00 A0 80 21 AF A2 00 18 27 A5 00 18 ?? ?? ?? ?? 00 80 88 21 8F BC 00 10 00 00 18 21 8F A6 00 20 10 40 00 0B 8F A7 00 24 8F A2 00 18 14 40 00 03 24 03 00 01 10 00 00 06 AE 00 00 00 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 02 00 28 21 00 40 18 21 8F BF 00 34 8F B1 00 30 8F B0 00 2C 00 60 10 21 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_363_0_0 {
	meta:
		name = "updwtmp"
		size = 200
		refs = "0000 _gp_disp 000c __GI_open 0044 __GI_lockf 0064 __GI_write 00a0 __GI_close"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 00 00 30 21 AF BC 00 10 AF B2 00 20 AF B0 00 18 AF BF 00 24 AF B1 00 1C 00 A0 90 21 ?? ?? ?? ?? 24 05 00 09 00 40 80 21 04 40 00 1C 8F BC 00 10 8F 91 ?? ?? 00 40 20 21 24 05 00 01 02 20 C8 21 ?? ?? ?? ?? 00 00 30 21 14 40 00 14 8F BC 00 10 8F 99 ?? ?? 02 00 20 21 02 40 28 21 ?? ?? ?? ?? 24 06 01 80 02 00 20 21 02 20 C8 21 00 00 28 21 ?? ?? ?? ?? 00 00 30 21 8F BC 00 10 8F BF 00 24 8F B2 00 20 8F B1 00 1C 02 00 20 21 8F 99 ?? ?? 8F B0 00 18 ?? ?? ?? ?? 27 BD 00 28 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_364_0_0 {
	meta:
		name = "__GI_mbsnrtowcs"
		size = 200
		refs = "0000 _gp_disp 0080 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 8F A3 00 38 AF BC 00 10 AF BF 00 24 14 60 00 03 00 00 00 00 8F 83 ?? ?? 24 63 ?? ?? 50 80 00 05 00 00 40 21 14 83 00 05 24 08 00 01 10 00 00 02 00 00 40 21 24 07 FF FF 27 A4 00 18 00 C7 10 2B 8C A3 00 00 00 C2 38 0B 00 E0 10 21 00 08 30 80 50 40 00 13 27 A6 00 18 90 68 00 00 11 00 00 0E AC 88 00 00 29 08 00 80 55 00 00 08 24 63 00 01 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 58 AC 43 00 00 10 00 00 09 24 02 FF FF 00 86 20 21 10 00 FF EF 24 42 FF FF 00 00 18 21 27 A6 00 18 54 86 00 01 AC A3 00 00 00 E2 10 23 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_365_0_0 {
	meta:
		name = "mrand48_r"
		size = 28
		refs = "0000 _gp_disp 000c __GI_jrand48_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 00 A0 30 21 ?? ?? ?? ?? 00 80 28 21 }
	condition:
		$1
}

rule file_370_0_0 {
	meta:
		name = "__GI_lrand48_r"
		size = 28
		refs = "0000 _gp_disp 000c __GI_nrand48_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 00 A0 30 21 ?? ?? ?? ?? 00 80 28 21 }
	condition:
		$1
}

rule file_389_0_0 {
	meta:
		name = "drand48_r"
		size = 28
		refs = "0000 _gp_disp 000c __GI_erand48_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 00 A0 30 21 ?? ?? ?? ?? 00 80 28 21 }
	condition:
		$1
}

rule file_366_0_0 {
	meta:
		name = "__GI_getenv"
		size = 192
		refs = "0000 _gp_disp 000c __environ 003c __GI_strlen 0054 __GI_memcmp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 27 BD FF C8 AF BC 00 10 AF BF 00 34 AF B5 00 30 AF B4 00 2C AF B3 00 28 AF B2 00 24 AF B1 00 20 AF B0 00 1C 8C 51 00 00 12 20 00 17 8F 99 ?? ?? 00 80 98 21 ?? ?? ?? ?? 24 15 00 3D 8F BC 00 10 00 40 90 21 8F 94 ?? ?? 8E 30 00 00 12 00 00 0E 02 60 20 21 02 00 28 21 02 80 C8 21 ?? ?? ?? ?? 02 40 30 21 14 40 FF F8 26 31 00 04 02 12 10 21 80 42 00 00 54 55 FF F5 8E 30 00 00 26 52 00 01 10 00 00 02 02 12 10 21 00 00 10 21 8F BF 00 34 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_367_0_0 {
	meta:
		name = "cfsetspeed"
		size = 224
		refs = "0000 _gp_disp 0050 __GI_cfsetispeed 0094 __GI_cfsetospeed 00b0 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B1 00 1C 00 A0 88 21 8F 85 ?? ?? AF B0 00 18 AF BC 00 10 00 80 80 21 AF BF 00 24 AF B2 00 20 00 00 10 21 24 A5 ?? ?? 24 04 00 20 00 02 18 C0 00 A3 18 21 8C 72 00 04 56 32 00 09 8C 63 00 00 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 02 20 28 21 8F BC 00 10 02 00 20 21 10 00 00 0A 02 20 28 21 56 23 00 0D 24 42 00 01 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 02 40 28 21 8F BC 00 10 02 00 20 21 02 40 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 09 00 00 10 21 14 44 FF E5 00 02 18 C0 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 AC 43 00 00 24 02 FF FF 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_369_0_0 {
	meta:
		name = "__GI_memccpy"
		size = 68
	strings:
		$1 = { 30 C6 00 FF 10 E0 00 0D 24 E8 FF FF 80 A3 00 00 24 82 00 01 24 A9 00 01 A0 83 00 00 30 63 00 FF 10 66 00 04 01 00 38 21 01 20 28 21 10 00 FF F5 00 40 20 21 03 E0 00 08 00 00 00 00 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_372_0_0 {
	meta:
		name = "__socketcall"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 06 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_373_0_0 {
	meta:
		name = "putpwent"
		size = 148
		refs = "0000 _gp_disp 0028 __GI___errno_location 005c __GI_fprintf 0058 $LC0"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF BC 00 28 AF BF 00 34 10 80 00 03 00 80 10 21 14 A0 00 08 00 A0 20 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 AC 43 00 00 10 00 00 12 24 02 FF FF 8C 43 00 08 8C 46 00 00 8C 47 00 04 AF A3 00 10 8C 43 00 0C 8F 85 ?? ?? 8F 99 ?? ?? AF A3 00 14 8C 43 00 10 24 A5 ?? ?? AF A3 00 18 8C 43 00 14 AF A3 00 1C 8C 42 00 18 ?? ?? ?? ?? AF A2 00 20 00 02 17 C3 8F BF 00 34 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_374_0_0 {
	meta:
		name = "__GI_rewind"
		size = 172
		refs = "0000 _gp_disp 0030 _pthread_cleanup_push_defer 0034 __pthread_mutex_unlock 004c __pthread_mutex_lock 0060 __GI_fseek 0084 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B0 00 28 AF BC 00 10 AF BF 00 34 AF B2 00 30 AF B1 00 2C 8C 91 00 34 16 20 00 0C 00 80 80 21 8F 99 ?? ?? 8F 85 ?? ?? 24 92 00 38 02 40 30 21 ?? ?? ?? ?? 27 A4 00 18 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 96 02 00 00 8F 99 ?? ?? 02 00 20 21 30 42 FF F7 A6 02 00 00 00 00 28 21 ?? ?? ?? ?? 00 00 30 21 16 20 00 05 8F BC 00 10 8F 99 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F BF 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_375_0_0 {
	meta:
		name = "realpath"
		size = 808
		refs = "0000 _gp_disp 0044 __GI___errno_location 0060 __GI_strlen 0098 __GI_strcpy 00c8 __GI_getcwd 01c0 __GI_readlink 02a8 __GI_memmove"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD EF B8 AF BC 00 10 AF B3 10 2C AF BF 10 44 AF BE 10 40 AF B7 10 3C AF B6 10 38 AF B5 10 34 AF B4 10 30 AF B2 10 28 AF B1 10 24 AF B0 10 20 14 80 00 06 00 80 98 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 4F 24 03 00 16 80 82 00 00 14 40 00 06 8F 92 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 47 24 03 00 02 02 40 C8 21 ?? ?? ?? ?? 00 A0 80 21 2C 43 0F FE 10 60 00 26 8F BC 00 10 24 07 0F FF 00 E2 38 23 8F 99 ?? ?? 27 B1 00 18 02 27 90 21 02 40 20 21 ?? ?? ?? ?? 02 60 28 21 82 42 00 00 26 03 0F FE 24 14 00 2F 8F BC 00 10 10 54 00 14 AF A3 10 18 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 24 05 0F FF 10 40 00 46 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 02 02 A8 21 82 A2 FF FF 10 54 00 03 8F BC 00 10 A2 B4 00 00 26 B5 00 01 00 00 20 21 24 14 00 2F 10 00 00 0D 26 16 00 01 26 15 00 01 A2 02 00 00 10 00 FF F9 26 52 00 01 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 17 24 03 00 4E 14 A0 00 30 00 00 00 00 26 52 00 01 82 42 00 00 50 40 00 63 26 02 00 01 50 54 FF FC 26 52 00 01 24 05 00 2E 50 45 FF F6 82 45 00 01 82 42 00 00 14 40 00 35 00 00 00 00 24 97 00 01 28 84 00 21 14 80 00 07 8F 99 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 5A 10 00 00 18 AC 43 00 00 ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 A2 A0 00 00 8F 99 ?? ?? ?? ?? ?? ?? AF A2 10 1C 8F BC 00 10 24 06 0F FF 02 00 20 21 8F 99 ?? ?? 02 20 28 21 00 40 98 21 ?? ?? ?? ?? 8C 5E 00 00 00 40 30 21 8F BC 00 10 04 41 00 20 8F AA 10 1C 8E 64 00 00 24 02 00 16 50 82 00 35 24 02 00 2F 10 00 00 40 00 00 10 21 50 B4 FF D1 26 52 00 01 54 A2 FF D8 82 42 00 00 82 42 00 02 10 40 00 03 00 00 00 00 54 54 FF D3 82 42 00 00 12 B6 FF C8 26 52 00 02 26 B5 FF FF 82 A2 FF FF 54 54 FF FE 26 B5 FF FF 10 00 FF C3 82 42 00 00 10 54 FF CB 8F A3 10 18 00 75 28 2B 14 A0 FF B5 26 52 00 01 A2 A2 00 00 10 00 FF C2 26 B5 00 01 00 4A 10 21 2C 42 0F FE 54 40 00 04 83 A2 00 18 24 02 00 4E 10 00 FF DF AE 62 00 00 50 54 00 07 02 00 A8 21 26 B5 FF FF 82 A2 00 00 54 54 FF FE 26 B5 FF FF 10 00 00 02 24 07 0F FF 24 07 0F FF 00 EA 38 23 00 E6 38 23 8F 99 ?? ?? 02 27 90 21 02 40 20 21 ?? ?? ?? ?? 02 20 28 21 8F BC 00 10 24 02 00 2F AE 7E 00 00 02 E0 20 21 A2 A2 00 00 10 00 FF 9C 26 B5 00 01 52 A2 00 06 A2 A0 00 00 82 A2 FF FF 38 42 00 2F 2C 42 00 01 02 A2 A8 23 A2 A0 00 00 02 00 10 21 8F BF 10 44 8F BE 10 40 8F B7 10 3C 8F B6 10 38 8F B5 10 34 8F B4 10 30 8F B3 10 2C 8F B2 10 28 8F B1 10 24 8F B0 10 20 03 E0 00 08 27 BD 10 48 }
	condition:
		$1
}

rule file_376_0_0 {
	meta:
		name = "__GI_lockf64"
		size = 380
		refs = "0000 _gp_disp 003c __GI_memset 0080 __GI___errno_location 00c0 __GI_fcntl64 00e4 __GI_getpid"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B0 00 07 17 C3 AF BC 00 10 AF B4 00 48 AF B3 00 44 AF BF 00 4C AF B2 00 40 AF B1 00 3C AF B0 00 38 00 C0 98 21 14 C2 00 12 00 E0 A0 21 8F 99 ?? ?? 27 B1 00 18 00 80 90 21 00 A0 80 21 02 20 20 21 00 00 28 21 ?? ?? ?? ?? 24 06 00 20 24 02 00 01 A7 A2 00 1A 24 02 00 01 8F BC 00 10 AF B3 00 28 16 02 00 08 AF B4 00 2C 10 00 00 26 A7 B0 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 2A 24 03 00 4F 2A 03 00 02 10 60 00 05 24 13 00 02 12 00 00 1E 24 02 00 02 10 00 00 20 8F 99 ?? ?? 52 13 00 1B A7 A2 00 18 24 02 00 03 16 02 00 1A 8F 99 ?? ?? 02 40 20 21 24 05 00 21 ?? ?? ?? ?? 02 20 30 21 04 40 00 20 8F BC 00 10 87 A2 00 18 14 53 00 03 8F 99 ?? ?? 10 00 00 1C 00 00 10 21 ?? ?? ?? ?? 8F B0 00 30 12 02 FF FB 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 0A 24 03 00 0D 10 00 00 0A 24 05 00 07 A7 A2 00 18 10 00 00 07 24 05 00 22 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 10 00 00 07 AC 43 00 00 8F 99 ?? ?? 02 40 20 21 ?? ?? ?? ?? 02 20 30 21 10 00 00 03 8F BF 00 4C 24 02 FF FF 8F BF 00 4C 8F B4 00 48 8F B3 00 44 8F B2 00 40 8F B1 00 3C 8F B0 00 38 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_377_0_0 {
	meta:
		name = "sysinfo"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 14 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_378_0_0 {
	meta:
		name = "daemon"
		size = 284
		refs = "0000 _gp_disp 000c fork 0044 __GI_setsid 0048 __GI__exit 0070 __GI_chdir 0074 $LC0 0090 __GI_open 008c $LC1 00b4 __GI_dup2 00f4 __GI_close"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BC 00 10 AF B2 00 20 AF B1 00 1C AF B0 00 18 AF BF 00 24 00 80 88 21 00 A0 90 21 ?? ?? ?? ?? 24 10 FF FF 10 50 00 0A 8F BC 00 10 10 40 00 04 8F 99 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 20 21 ?? ?? ?? ?? 00 00 00 00 14 50 00 03 8F BC 00 10 10 00 00 27 24 02 FF FF 16 20 00 05 8F 99 ?? ?? 8F 84 ?? ?? ?? ?? ?? ?? 24 84 ?? ?? 8F BC 00 10 16 40 00 1F 00 00 10 21 8F 84 ?? ?? 8F 99 ?? ?? 24 05 00 02 24 84 ?? ?? ?? ?? ?? ?? 00 00 30 21 00 40 80 21 24 02 FF FF 12 02 00 14 8F BC 00 10 8F 91 ?? ?? 02 00 20 21 02 20 C8 21 ?? ?? ?? ?? 00 00 28 21 02 00 20 21 02 20 C8 21 ?? ?? ?? ?? 24 05 00 01 02 00 20 21 02 20 C8 21 ?? ?? ?? ?? 24 05 00 02 2A 02 00 03 14 40 00 04 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 00 00 10 21 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_379_0_0 {
	meta:
		name = "clone"
		size = 108
		refs = "0000 _gp_disp 0044 __thread_start 0060 __syscall_error"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 10 80 00 10 24 02 00 16 10 A0 00 0E 00 00 00 00 24 A5 FF E0 AC A4 00 00 AC A7 00 04 00 C0 20 21 24 02 10 18 00 00 00 0C 14 E0 00 06 00 00 00 00 10 40 ?? ?? 00 00 00 00 03 E0 00 08 27 BD 00 20 00 00 00 00 27 BD 00 20 00 40 20 21 8F 99 ?? ?? 03 20 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_379_1_0 {
	meta:
		name = "__thread_start"
		size = 40
		refs = "0018 __GI__exit"
	strings:
		$1 = { AF BC 00 10 8F B9 00 00 03 20 F8 09 8F A4 00 04 8F BC 00 10 00 40 20 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 }
	condition:
		$1
}

rule file_380_0_0 {
	meta:
		name = "_test_and_set"
		size = 40
	strings:
		$1 = { 00 00 00 0F C0 82 00 00 10 45 00 05 00 A0 18 21 E0 83 00 00 10 60 FF FB 00 00 00 00 00 00 00 0F 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_381_0_0 {
	meta:
		name = "bcopy"
		size = 32
		refs = "0000 _gp_disp 000c __GI_memmove"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 00 80 10 21 00 A0 20 21 ?? ?? ?? ?? 00 40 28 21 }
	condition:
		$1
}

rule file_382_0_0 {
	meta:
		name = "getsockopt"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 8F A2 00 30 27 BD FF E0 AF A2 00 10 24 02 10 4D 00 00 00 0C 27 BD 00 20 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_383_0_0 {
	meta:
		name = "__GI_setrlimit"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F EB 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_384_0_0 {
	meta:
		name = "getwchar_unlocked"
		size = 28
		refs = "0000 _gp_disp 000c stdin 0010 __GI_fgetwc_unlocked"
		altNames = "getwchar"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 8C 44 00 00 }
	condition:
		$1
}

rule file_75_3_3 {
	meta:
		name = "_ZSt10unexpectedv"
		size = 44
		refs = "0000 _gp_disp 000c _ZN10__cxxabiv120__unexpected_handlerE 0010 _ZN10__cxxabiv112__unexpectedEPFvvE"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 27 BD FF E0 8C 44 00 00 AF BC 00 10 AF BF 00 1C ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_75_1_3 {
	meta:
		name = "_ZSt9terminatev"
		size = 44
		refs = "0000 _gp_disp 000c _ZN10__cxxabiv119__terminate_handlerE 0010 _ZN10__cxxabiv111__terminateEPFvvE"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? 27 BD FF E0 8C 44 00 00 AF BC 00 10 AF BF 00 1C ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_79_0_3 {
	meta:
		name = "_ZZN12_GLOBAL__N_18key_initEvEN5key_sD2Ev"
		size = 28
		refs = "0000 _gp_disp 0010 pthread_key_delete"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 8C 44 ?? ?? }
	condition:
		$1
}

rule file_386_0_0 {
	meta:
		name = "__GI_ungetc"
		size = 384
		refs = "0000 _gp_disp 0038 _pthread_cleanup_push_defer 0040 __pthread_mutex_unlock 0054 __pthread_mutex_lock 00c4 __stdio_trans2r_o 0150 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF B1 00 30 AF B0 00 2C AF BC 00 10 AF BF 00 3C AF B3 00 38 AF B2 00 34 8C B2 00 34 00 80 88 21 16 40 00 0C 00 A0 80 21 8F 99 ?? ?? 24 B3 00 38 8F 85 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 02 60 30 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 8F BC 00 10 8E 02 00 10 8E 04 00 18 00 44 20 2B 10 80 00 11 96 03 00 00 24 04 FF FF 52 24 00 0F 30 63 00 83 8E 04 00 08 00 82 20 2B 50 80 00 0B 30 63 00 83 90 45 FF FF 32 24 00 FF 54 A4 00 07 30 63 00 83 24 42 FF FF 30 63 FF FB AE 02 00 10 10 00 00 25 A6 03 00 00 30 63 00 83 2C 63 00 81 14 60 00 07 8F 99 ?? ?? 96 02 00 00 30 43 00 02 54 60 00 0A 30 43 00 01 10 00 00 0D 24 03 FF FF 02 00 20 21 ?? ?? ?? ?? 24 05 00 80 10 40 FF F6 8F BC 00 10 10 00 00 14 24 11 FF FF 54 60 00 12 24 11 FF FF 8E 03 00 28 14 60 FF FA 24 03 FF FF 12 23 00 0D 24 42 00 01 8E 03 00 08 30 42 FF FF AE 03 00 18 24 03 00 01 AE 03 00 28 30 43 00 01 24 63 00 08 00 03 18 80 02 03 18 21 30 42 FF FB AC 71 00 04 A6 02 00 00 16 40 00 06 8F BF 00 3C 8F 99 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F BF 00 3C 02 20 10 21 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_387_0_0 {
	meta:
		name = "setxattr"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 8F A2 00 30 27 BD FF E0 AF A2 00 10 24 02 10 80 00 00 00 0C 27 BD 00 20 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_387_1_0 {
	meta:
		name = "lsetxattr"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 8F A2 00 30 27 BD FF E0 AF A2 00 10 24 02 10 81 00 00 00 0C 27 BD 00 20 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_387_2_0 {
	meta:
		name = "fsetxattr"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 8F A2 00 30 27 BD FF E0 AF A2 00 10 24 02 10 82 00 00 00 0C 27 BD 00 20 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_387_3_0 {
	meta:
		name = "getxattr"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 83 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_387_4_0 {
	meta:
		name = "lgetxattr"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 84 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_387_5_0 {
	meta:
		name = "fgetxattr"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 85 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_387_6_0 {
	meta:
		name = "listxattr"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 86 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_387_7_0 {
	meta:
		name = "llistxattr"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 87 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_387_8_0 {
	meta:
		name = "flistxattr"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 88 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_387_9_0 {
	meta:
		name = "removexattr"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 89 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_387_10_0 {
	meta:
		name = "lremovexattr"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 8A 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_387_11_0 {
	meta:
		name = "fremovexattr"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 8B 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_388_0_0 {
	meta:
		name = "_charpad"
		size = 148
		refs = "0000 _gp_disp 0014 _wstdio_fwrite"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B3 00 2C 8F 93 ?? ?? AF B4 00 30 AF B2 00 28 AF B1 00 24 AF B0 00 20 AF BC 00 10 AF BF 00 34 00 80 A0 21 00 C0 88 21 AF A5 00 18 00 C0 80 21 27 B2 00 18 12 00 00 0A 02 40 20 21 24 05 00 01 02 60 C8 21 ?? ?? ?? ?? 02 80 30 21 24 03 00 01 14 43 00 04 8F BF 00 34 10 00 FF F6 26 10 FF FF 8F BF 00 34 02 30 10 23 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_388_1_0 {
	meta:
		name = "_fp_out_wide"
		size = 252
		refs = "0000 _gp_disp 0044 __GI_strlen 0070 _charpad 00c4 _wstdio_fwrite"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 78 30 A2 00 80 AF BC 00 10 AF B4 00 80 AF B3 00 7C AF B2 00 78 AF B0 00 70 AF BF 00 84 AF B1 00 74 00 80 98 21 00 A0 80 21 00 C0 90 21 10 40 00 13 00 E0 A0 21 8F 99 ?? ?? ?? ?? ?? ?? 00 E0 20 21 02 42 90 23 8F BC 00 10 1A 40 00 0D 00 40 88 21 8F 99 ?? ?? 32 05 00 7F 02 60 20 21 27 39 ?? ?? ?? ?? ?? ?? 02 40 30 21 00 40 80 21 14 52 00 16 8F BC 00 10 10 00 00 03 00 00 00 00 00 C0 88 21 00 00 80 21 1A 20 00 10 00 00 10 21 27 A4 00 18 02 82 28 21 80 A5 00 00 00 02 18 80 00 83 18 21 24 42 00 01 AC 65 00 00 00 51 18 2A 14 60 FF F9 02 82 28 21 8F 99 ?? ?? 02 20 28 21 ?? ?? ?? ?? 02 60 30 21 02 02 80 21 8F BF 00 84 02 00 10 21 8F B4 00 80 8F B3 00 7C 8F B2 00 78 8F B1 00 74 8F B0 00 70 03 E0 00 08 27 BD 00 88 }
	condition:
		$1
}

rule file_388_2_0 {
	meta:
		name = "_vfwprintf_internal"
		size = 2016
		refs = "0000 _gp_disp 0024 __GI_memset 0070 __GI_wcsrtombs 00d8 _ppfs_parsespec 0144 _ppfs_prepargs 0158 __GI_wcslen 0170 _wstdio_fwrite 0218 _ppfs_setargs 027c _store_inttype 0340 _load_inttype 0358 _uintmaxtostr 03bc __GI_mbsrtowcs 0468 $LC0 04b4 _fpmaxtostr 04f8 __GI_wcsnlen 0564 __GI_btowc 05d0 $LC1 0678 _charpad 0694 __GI_fputws"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FD 70 27 B9 01 20 AF B1 02 6C AF B9 02 58 00 80 88 21 03 20 20 21 8F 99 ?? ?? AF BC 00 18 AF BF 02 8C AF B5 02 7C AF B3 02 74 AF B2 02 70 AF B0 02 68 00 A0 90 21 AF BE 02 88 00 00 28 21 AF B7 02 84 AF B6 02 80 AF B4 02 78 00 C0 80 21 ?? ?? ?? ?? 24 06 00 98 8F BC 00 18 24 02 00 80 24 15 FF FF 8F 99 ?? ?? 27 B3 00 20 AF B5 01 38 AF B2 01 20 AF A2 01 30 AF A0 00 20 AF B2 01 B8 00 00 20 21 27 A5 01 B8 24 06 FF FF ?? ?? ?? ?? 02 60 38 21 14 55 00 05 8F BC 00 18 8F 82 ?? ?? 24 42 ?? ?? 10 00 00 28 AF A2 01 20 27 A2 01 48 24 04 00 09 00 40 B8 21 24 03 00 08 24 84 FF FF AC 43 00 00 14 80 FF FD 24 42 00 04 8F 96 ?? ?? 02 40 10 21 24 15 00 25 8C 44 00 00 50 80 00 11 8F A2 01 38 54 95 FF FC 24 42 00 04 24 44 00 04 8C 42 00 04 10 55 00 08 02 C0 C8 21 AF A4 01 20 ?? ?? ?? ?? 27 A4 01 20 04 40 00 0F 8F BC 00 18 10 00 FF F1 8F A2 01 20 00 80 10 21 10 00 FF EE 24 42 00 04 AF B2 01 20 02 E0 18 21 24 04 00 08 24 42 FF FF 04 40 00 10 8F 99 ?? ?? 8C 65 00 00 14 A4 FF FB 24 63 00 04 8F B0 01 20 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F BC 00 18 02 00 20 21 00 40 28 21 8F 99 ?? ?? ?? ?? ?? ?? 02 20 30 21 10 00 01 8B 24 10 FF FF 27 A4 01 20 ?? ?? ?? ?? 02 00 28 21 8F BC 00 18 02 40 20 21 00 00 80 21 8E 42 00 00 10 40 00 06 02 44 A8 23 24 03 00 25 10 43 00 04 26 A2 00 03 10 00 FF F9 26 52 00 04 26 A2 00 03 2C 42 00 07 54 40 00 0A 8E 42 00 00 8F 99 ?? ?? 00 15 A8 83 02 A0 28 21 ?? ?? ?? ?? 02 20 30 21 14 55 FF E6 8F BC 00 18 02 02 80 21 8E 42 00 00 10 40 01 6E 24 02 00 25 8E 43 00 04 10 62 01 69 26 44 00 04 8F 99 ?? ?? AF A4 01 20 ?? ?? ?? ?? 27 A4 01 20 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 27 A4 01 20 8F A3 01 38 8F BC 00 18 93 A4 01 46 18 60 00 04 27 A2 01 70 00 04 18 C0 24 63 FF F8 00 43 10 21 00 00 28 21 00 00 18 21 8F A6 01 3C 00 66 30 2A 10 C0 00 04 24 63 00 01 00 40 28 21 10 00 FF FA 24 42 00 08 8F A2 01 40 14 40 00 0A 2C 43 00 08 8C A4 00 00 8F A5 01 30 8F 99 ?? ?? 00 10 37 C3 30 A5 0F 00 ?? ?? ?? ?? 02 00 38 21 10 00 00 90 8F BC 00 18 10 60 00 7F 2C 43 00 10 8F 83 ?? ?? 24 63 ?? ?? 00 43 18 21 80 74 FF FF 24 03 00 0A 16 83 00 08 24 12 00 57 8F A3 01 30 24 06 00 2C 30 68 00 20 00 C8 90 0B 30 63 00 40 36 46 00 80 00 C3 90 0B 2C 43 00 06 50 60 00 09 00 14 A0 23 24 03 00 03 10 43 00 05 24 03 00 01 14 43 00 04 24 16 00 06 10 00 00 04 8F A6 01 24 24 12 00 37 24 16 00 0B 8F A6 01 24 83 A3 01 37 24 15 00 20 28 C6 00 00 00 66 A8 0B 24 03 00 01 10 43 00 06 24 84 00 09 00 04 20 80 02 64 20 21 8C 84 01 00 10 00 00 02 30 84 0F 00 24 04 04 00 8F 99 ?? ?? ?? ?? ?? ?? 02 80 30 21 8F BC 00 18 AF B4 00 10 AF B2 00 14 8F 99 ?? ?? 27 A4 02 37 00 60 38 21 ?? ?? ?? ?? 00 40 30 21 00 40 B8 21 8F A2 01 40 2C 42 00 06 14 40 00 10 8F BC 00 18 82 E4 00 00 24 03 00 2D 14 83 00 06 8F A2 01 30 34 42 00 02 AF A2 01 30 26 F7 00 01 10 00 00 07 24 16 00 02 30 43 00 02 54 60 00 04 00 00 B0 21 30 42 00 01 24 03 00 04 00 62 B0 0B 8F 99 ?? ?? 00 00 20 21 02 60 28 21 27 A7 02 48 AF B7 00 20 AF A0 02 48 ?? ?? ?? ?? 00 00 30 21 8F A7 01 24 00 40 F0 21 24 05 00 01 28 E2 00 00 00 A2 38 0B 8F A2 01 30 8F BC 00 18 30 42 00 10 10 40 00 11 82 E4 00 00 8F A2 01 40 2C 46 00 03 54 C0 00 0D 24 16 00 06 24 06 00 03 50 46 00 0A 24 16 00 09 24 06 00 04 14 46 00 07 03 C7 10 2B 14 40 00 06 24 02 00 30 38 87 00 30 27 C2 00 01 00 47 28 0B 00 A0 38 21 24 02 00 30 14 82 00 0F 03 C7 10 2B 2A C4 00 06 24 02 00 0B 00 44 B0 0A 8F A4 01 40 24 02 00 01 10 82 00 05 8F 89 ?? ?? 54 E0 00 06 03 C7 10 2B 10 00 00 54 00 00 F0 21 24 1E 00 05 10 00 00 51 25 37 ?? ?? 14 40 00 5E 00 FE 38 23 10 00 00 5C 00 00 38 21 10 60 00 10 2C 43 00 12 27 A2 01 24 8C A7 00 04 8C A6 00 00 AF A2 00 10 8F 82 ?? ?? 8F 99 ?? ?? 02 20 20 21 24 42 ?? ?? ?? ?? ?? ?? AF A2 00 14 04 40 00 B1 8F BC 00 18 02 02 80 21 10 00 00 AF 00 00 90 21 10 60 00 1E 2C 43 00 14 24 03 00 11 54 43 00 12 8C A2 00 00 8C B4 00 00 12 80 00 36 8F 99 ?? ?? 8F A2 01 24 24 03 FF FF 28 45 00 00 00 45 18 0A 02 80 20 21 ?? ?? ?? ?? 00 60 28 21 00 40 F0 21 8F BC 00 18 00 00 B8 21 24 15 00 20 24 16 00 0B 10 00 00 36 00 00 38 21 AF A2 02 40 AF A0 02 44 00 00 B8 21 24 15 00 20 24 16 00 0B 00 00 38 21 24 1E 00 01 10 00 00 2D 27 B4 02 40 10 60 00 8D 24 03 00 13 14 43 00 15 8F 99 ?? ?? 8C B7 00 00 12 E0 00 1F 8F 99 ?? ?? 8F A2 01 24 24 12 FF FF 28 46 00 00 27 A4 02 48 02 46 10 0B AF B7 00 20 AF A0 02 48 02 60 28 21 00 40 30 21 ?? ?? ?? ?? 00 80 38 21 00 40 F0 21 10 52 00 7A 8F BC 00 18 24 15 00 20 10 00 00 05 24 16 00 0B ?? ?? ?? ?? 90 A4 00 03 10 00 FF DC 8F BC 00 18 10 00 00 0E 00 00 38 21 8F 89 ?? ?? 24 15 00 20 24 16 00 0B 25 37 ?? ?? 00 00 38 21 10 00 00 08 24 1E 00 06 8F 89 ?? ?? 24 15 00 20 24 16 00 0B 25 37 ?? ?? 00 00 38 21 24 1E 00 06 00 00 A0 21 24 04 00 0B 12 C4 00 06 00 FE 10 21 2A C6 00 06 24 04 00 01 24 05 00 02 00 A6 20 0A 00 44 10 21 8F A4 01 28 00 50 80 21 00 44 90 2B 00 82 20 23 00 12 20 0A 24 02 00 30 00 80 90 21 16 A2 00 03 02 04 80 21 00 E4 38 21 00 00 90 21 8F A2 01 30 8F 83 ?? ?? 30 42 00 08 14 40 00 0B 24 75 ?? ?? AF A7 02 64 02 20 20 21 24 05 00 20 02 A0 C8 21 ?? ?? ?? ?? 02 40 30 21 8F BC 00 18 14 52 00 42 8F A7 02 64 00 00 90 21 8F 82 ?? ?? 8F 99 ?? ?? 00 16 20 80 24 42 ?? ?? 00 44 20 21 02 20 28 21 ?? ?? ?? ?? AF A7 02 64 8F A7 02 64 02 20 20 21 24 05 00 30 02 A0 C8 21 ?? ?? ?? ?? 00 E0 30 21 8F A7 02 64 14 47 00 30 8F BC 00 18 16 80 00 28 8F 99 ?? ?? AF B7 02 50 8F 97 ?? ?? 27 A3 02 50 27 B9 02 38 AF A0 02 38 AF A3 02 5C 24 16 00 40 AF B9 02 60 13 C0 00 14 8F 99 ?? ?? 2F C6 00 41 02 C0 10 21 03 C6 10 0B 02 60 20 21 27 A5 02 50 00 40 30 21 ?? ?? ?? ?? 27 A7 02 38 00 40 28 21 02 60 20 21 02 20 30 21 02 E0 C8 21 ?? ?? ?? ?? 00 40 A0 21 03 C2 F0 23 10 54 FF EE 8F BC 00 18 57 C0 00 12 24 12 FF FF 02 40 30 21 02 20 20 21 02 A0 C8 21 ?? ?? ?? ?? 24 05 00 20 00 52 10 26 00 02 90 2B 8F BC 00 18 10 00 00 08 00 12 90 23 02 80 20 21 03 C0 28 21 ?? ?? ?? ?? 02 20 30 21 10 5E FF F1 8F BC 00 18 24 12 FF FF 16 40 FE 79 8F A4 01 20 10 00 FE 7F 00 80 90 21 10 00 FE 7D 26 52 00 08 8F BF 02 8C 02 00 10 21 8F BE 02 88 8F B7 02 84 8F B6 02 80 8F B5 02 7C 8F B4 02 78 8F B3 02 74 8F B2 02 70 8F B1 02 6C 8F B0 02 68 03 E0 00 08 27 BD 02 90 }
	condition:
		$1
}

rule file_390_0_0 {
	meta:
		name = "wcwidth"
		size = 56
		refs = "0000 _gp_disp 000c __GI_wcswidth"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 24 05 00 01 AF BF 00 1C AF BC 00 10 AF A4 00 20 ?? ?? ?? ?? 27 A4 00 20 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_391_0_0 {
	meta:
		name = "fcloseall"
		size = 424
		refs = "0000 _gp_disp 0010 _stdio_openlist_del_lock 0014 __pthread_mutex_unlock 0018 _pthread_cleanup_push_defer 0060 __pthread_mutex_lock 007c _stdio_openlist_use_count 0080 _pthread_cleanup_pop_restore 00a0 _stdio_openlist_add_lock 00d0 _stdio_openlist 00e4 __GI_fclose 00ec _stdio_openlist_dec_use"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B0 8F 86 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? AF B1 00 2C 27 B1 00 18 AF BF 00 4C AF BC 00 10 AF B7 00 44 AF B6 00 40 AF B5 00 3C AF B2 00 30 AF B0 00 28 AF BE 00 48 AF B4 00 38 AF B3 00 34 ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 00 00 90 21 24 15 00 30 8F 99 ?? ?? 8F 84 ?? ?? ?? ?? ?? ?? 24 17 FF FF 8F BC 00 10 02 20 20 21 24 05 00 01 8F 82 ?? ?? 8F 99 ?? ?? 8C 43 00 00 24 63 00 01 AC 43 00 00 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 85 ?? ?? 8F 86 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 02 20 20 21 24 05 00 01 8F 82 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 8C 50 00 00 8F BC 00 10 8F 96 ?? ?? 12 00 00 20 8F 99 ?? ?? 8E 13 00 34 16 60 00 0C 8E 1E 00 20 8F 99 ?? ?? 8F 85 ?? ?? 26 14 00 38 02 20 20 21 ?? ?? ?? ?? 02 80 30 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 80 20 21 8F BC 00 10 96 02 00 00 30 42 00 30 10 55 00 05 02 C0 C8 21 ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 02 E2 90 0B 56 60 FF E7 03 C0 80 21 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 24 05 00 01 8F BC 00 10 10 00 FF E0 03 C0 80 21 ?? ?? ?? ?? 00 00 00 00 8F BF 00 4C 02 40 10 21 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_393_0_0 {
	meta:
		name = "tcgetsid"
		size = 272
		refs = "0000 _gp_disp 0038 __GI___errno_location 0050 __GI_ioctl 0098 __GI_tcgetpgrp 00b0 __GI_getsid"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B2 00 2C 8F 92 ?? ?? AF BC 00 10 AF B1 00 28 8E 42 ?? ?? AF BF 00 34 AF B3 00 30 AF B0 00 24 14 40 00 19 00 80 88 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 02 20 20 21 24 05 74 16 8F 99 ?? ?? 27 A6 00 18 00 40 80 21 ?? ?? ?? ?? 8C 53 00 00 04 41 00 0A 8F BC 00 10 8E 03 00 00 24 02 00 16 10 62 00 03 24 02 00 01 10 00 00 1C 24 10 FF FF AE 42 ?? ?? 10 00 00 03 AE 13 00 00 10 00 00 17 8F B0 00 18 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 24 11 FF FF 10 51 FF F4 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 AF A2 00 18 8F BC 00 10 14 51 00 0A 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8C 44 00 00 24 03 00 03 54 83 00 03 24 10 FF FF 24 03 00 19 AC 43 00 00 8F BF 00 34 02 00 10 21 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_395_0_0 {
	meta:
		name = "sysmips"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 35 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_396_0_0 {
	meta:
		name = "__GI_sprintf"
		size = 68
		refs = "0000 _gp_disp 0010 __GI_vsnprintf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 8F 99 ?? ?? AF A7 00 34 27 A7 00 30 AF BF 00 24 AF BC 00 10 AF A6 00 30 AF A7 00 18 00 A0 30 21 ?? ?? ?? ?? 24 05 FF FF 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_397_0_0 {
	meta:
		name = "__GI___cxa_atexit"
		size = 120
		refs = "0000 _gp_disp 002c __new_exitfn"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF BC 00 10 AF B0 00 18 AF BF 00 24 AF B2 00 20 AF B1 00 1C 10 80 00 0B 00 80 80 21 8F 99 ?? ?? 00 A0 88 21 ?? ?? ?? ?? 00 C0 90 21 10 40 00 07 24 03 00 03 AC 50 00 04 AC 51 00 08 AC 52 00 0C AC 43 00 00 10 00 00 02 00 00 10 21 24 02 FF FF 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_398_0_0 {
	meta:
		name = "__GI_getgrnam_r"
		size = 300
		refs = "0000 _gp_disp 0030 __GI_fopen 0028 $LC0 002c $LC1 0078 __GI___errno_location 008c __pgsreader 0090 __GI_strcmp 009c __parsegrent 00ec __GI_fclose"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B5 00 34 AF B3 00 2C AF B2 00 28 8F B3 00 58 00 80 A8 21 00 A0 90 21 8F 84 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? AF BC 00 18 AF B7 00 3C AF B6 00 38 AF B1 00 24 AF BF 00 44 AF BE 00 40 AF B4 00 30 AF B0 00 20 24 84 ?? ?? AE 60 00 00 24 A5 ?? ?? 00 C0 B0 21 ?? ?? ?? ?? 00 E0 B8 21 00 40 88 21 14 40 00 06 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 1C 8C 50 00 00 8F 9E ?? ?? 8F 94 ?? ?? 24 02 00 01 AE 22 00 34 8F 84 ?? ?? AF B1 00 10 02 40 28 21 02 C0 30 21 03 C0 C8 21 ?? ?? ?? ?? 02 E0 38 21 00 40 80 21 14 40 00 09 8F BC 00 18 8E 44 00 00 02 80 C8 21 ?? ?? ?? ?? 02 A0 28 21 14 40 FF F1 8F BC 00 18 10 00 00 03 AE 72 00 00 38 42 00 02 00 02 80 0A 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BF 00 44 02 00 10 21 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_752_0_0 {
	meta:
		name = "__GI_getpwnam_r"
		size = 300
		refs = "0000 _gp_disp 0030 __GI_fopen 0028 $LC0 002c $LC1 0078 __GI___errno_location 008c __pgsreader 0090 __GI_strcmp 009c __parsepwent 00ec __GI_fclose"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B5 00 34 AF B3 00 2C AF B2 00 28 8F B3 00 58 00 80 A8 21 00 A0 90 21 8F 84 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? AF BC 00 18 AF B7 00 3C AF B6 00 38 AF B1 00 24 AF BF 00 44 AF BE 00 40 AF B4 00 30 AF B0 00 20 24 84 ?? ?? AE 60 00 00 24 A5 ?? ?? 00 C0 B0 21 ?? ?? ?? ?? 00 E0 B8 21 00 40 88 21 14 40 00 06 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 1C 8C 50 00 00 8F 9E ?? ?? 8F 94 ?? ?? 24 02 00 01 AE 22 00 34 8F 84 ?? ?? AF B1 00 10 02 40 28 21 02 C0 30 21 03 C0 C8 21 ?? ?? ?? ?? 02 E0 38 21 00 40 80 21 14 40 00 09 8F BC 00 18 8E 44 00 00 02 80 C8 21 ?? ?? ?? ?? 02 A0 28 21 14 40 FF F1 8F BC 00 18 10 00 00 03 AE 72 00 00 38 42 00 02 00 02 80 0A 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BF 00 44 02 00 10 21 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_539_0_0 {
	meta:
		name = "__GI_getspnam_r"
		size = 300
		refs = "0000 _gp_disp 0030 __GI_fopen 0028 $LC0 002c $LC1 0078 __GI___errno_location 008c __pgsreader 0090 __GI_strcmp 009c __parsespent 00ec __GI_fclose"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B5 00 34 AF B3 00 2C AF B2 00 28 8F B3 00 58 00 80 A8 21 00 A0 90 21 8F 84 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? AF BC 00 18 AF B7 00 3C AF B6 00 38 AF B1 00 24 AF BF 00 44 AF BE 00 40 AF B4 00 30 AF B0 00 20 24 84 ?? ?? AE 60 00 00 24 A5 ?? ?? 00 C0 B0 21 ?? ?? ?? ?? 00 E0 B8 21 00 40 88 21 14 40 00 06 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 1C 8C 50 00 00 8F 9E ?? ?? 8F 94 ?? ?? 24 02 00 01 AE 22 00 34 8F 84 ?? ?? AF B1 00 10 02 40 28 21 02 C0 30 21 03 C0 C8 21 ?? ?? ?? ?? 02 E0 38 21 00 40 80 21 14 40 00 09 8F BC 00 18 8E 44 00 00 02 80 C8 21 ?? ?? ?? ?? 02 A0 28 21 14 40 FF F1 8F BC 00 18 10 00 00 03 AE 72 00 00 38 42 00 02 00 02 80 0A 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BF 00 44 02 00 10 21 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_399_0_0 {
	meta:
		name = "getppid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F E0 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_400_0_0 {
	meta:
		name = "readv"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 31 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_401_0_0 {
	meta:
		name = "__GI__rpc_dtablesize"
		size = 80
		refs = "0000 _gp_disp 002c __GI_getdtablesize"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF B0 00 18 8F 90 ?? ?? AF BC 00 10 AF BF 00 1C 8E 02 ?? ?? 14 40 00 07 8F BF 00 1C 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AE 02 ?? ?? 8F BF 00 1C 8E 02 ?? ?? 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_402_0_0 {
	meta:
		name = "__libc_sa_len"
		size = 56
		refs = "0000 _gp_disp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 24 84 FF FF 30 84 FF FF 2C 83 00 0A 10 60 00 05 00 00 10 21 8F 82 ?? ?? 24 42 ?? ?? 00 82 20 21 80 82 00 00 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_403_0_0 {
	meta:
		name = "__GI_setsockopt"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 8F A2 00 30 27 BD FF E0 AF A2 00 10 24 02 10 55 00 00 00 0C 27 BD 00 20 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_406_0_0 {
	meta:
		name = "putspent"
		size = 432
		refs = "0000 _gp_disp 004c _pthread_cleanup_push_defer 0054 __pthread_mutex_unlock 0068 __pthread_mutex_lock 0084 $LC0 008c __GI_fprintf 0090 $LC1 0124 __GI___fputc_unlocked 0120 $LC2 016c _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B0 AF B1 00 2C AF B0 00 28 AF BC 00 10 AF BF 00 4C AF BE 00 48 AF B7 00 44 AF B6 00 40 AF B5 00 3C AF B4 00 38 AF B3 00 34 AF B2 00 30 8C B3 00 34 00 80 88 21 16 60 00 0C 00 A0 80 21 8F 99 ?? ?? 24 B2 00 38 8F 85 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 02 40 30 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 8E 27 00 04 14 E0 00 03 8E 26 00 00 8F 87 ?? ?? 24 E7 ?? ?? 8F 92 ?? ?? 8F 85 ?? ?? 02 00 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 02 40 A0 21 8F BC 00 10 04 41 00 03 00 00 90 21 10 00 00 2B 24 10 FF FF 8F 95 ?? ?? 8F 97 ?? ?? 8F 9E ?? ?? 26 B5 ?? ?? 24 16 FF FF 02 55 10 21 90 42 00 00 26 E5 ?? ?? 02 00 20 21 02 22 10 21 8C 46 00 00 27 C2 ?? ?? 02 80 C8 21 00 D6 18 26 ?? ?? ?? ?? 00 43 28 0A 04 40 FF ED 8F BC 00 10 26 52 00 01 24 02 00 06 16 42 FF F1 02 55 10 21 8E 26 00 20 24 02 FF FF 14 C2 00 09 8F 85 ?? ?? 8F 99 ?? ?? 02 00 28 21 ?? ?? ?? ?? 24 04 00 0A 28 42 00 01 8F BC 00 10 10 00 00 09 00 02 80 23 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 24 A5 ?? ?? 04 41 FF F3 8F BC 00 10 10 00 00 01 24 10 FF FF 16 60 00 06 8F BF 00 4C 8F 99 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F BF 00 4C 02 00 10 21 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_407_0_0 {
	meta:
		name = "__GI_sigprocmask"
		size = 132
		refs = "0000 _gp_disp 0030 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 10 A0 00 0A 24 82 FF FF 2C 42 00 03 14 40 00 08 24 07 00 10 8F 99 ?? ?? ?? ?? ?? ?? 24 10 FF FF 24 03 00 16 10 00 00 0B AC 43 00 00 24 07 00 10 24 02 10 63 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_408_0_0 {
	meta:
		name = "__GI_strlcpy"
		size = 72
	strings:
		$1 = { 27 BD FF F0 50 C0 00 03 00 00 30 21 10 00 00 02 24 C6 FF FF 27 A4 00 08 00 A0 10 21 80 43 00 00 10 60 00 06 A0 83 00 00 10 C0 FF FC 24 42 00 01 24 C6 FF FF 10 00 FF F9 24 84 00 01 00 45 10 23 03 E0 00 08 27 BD 00 10 }
	condition:
		$1
}

rule file_409_0_0 {
	meta:
		name = "__GI_inet_netof"
		size = 44
	strings:
		$1 = { 04 80 00 03 3C 03 C0 00 03 E0 00 08 00 04 16 02 00 83 18 24 3C 05 80 00 00 04 14 02 00 65 18 26 00 04 22 02 03 E0 00 08 00 83 10 0B }
	condition:
		$1
}

rule file_410_0_0 {
	meta:
		name = "__GI_listen"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 4E 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_412_0_0 {
	meta:
		name = "__GI_fstat64"
		size = 120
		refs = "0000 _gp_disp 0034 __GI___errno_location 0054 __xstat64_conv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 78 AF BC 00 10 00 A0 30 21 AF BF 00 84 AF B0 00 80 27 A5 00 18 24 02 10 77 00 00 00 0C 10 E0 00 07 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 10 00 00 07 24 10 FF FF 14 40 00 06 8F BF 00 84 8F 99 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 00 C0 28 21 8F BF 00 84 02 00 10 21 8F B0 00 80 03 E0 00 08 27 BD 00 88 }
	condition:
		$1
}

rule file_413_0_0 {
	meta:
		name = "sched_getaffinity"
		size = 160
		refs = "0000 _gp_disp 004c __GI___errno_location 0068 __GI_memset"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B1 00 1C AF BC 00 10 00 A0 88 21 AF B2 00 20 AF BF 00 24 AF B0 00 18 06 21 00 03 00 C0 90 21 3C 05 7F FF 34 A5 FF FF 02 40 30 21 24 02 10 90 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 0A AC 50 00 00 24 02 FF FF 12 02 00 08 8F 99 ?? ?? 02 50 20 21 00 00 28 21 ?? ?? ?? ?? 02 30 30 23 10 00 00 02 00 00 10 21 24 02 FF FF 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_414_0_0 {
	meta:
		name = "xdrrec_inline"
		size = 124
	strings:
		$1 = { 8C 82 00 00 10 40 00 06 8C 83 00 0C 24 04 00 01 50 44 00 0B 8C 66 00 34 03 E0 00 08 00 00 10 21 8C 62 00 10 8C 64 00 14 00 45 28 21 00 85 20 2B 54 80 00 10 00 00 10 21 03 E0 00 08 AC 65 00 10 00 C5 10 2B 14 40 00 0B 00 00 10 21 8C 62 00 2C 8C 67 00 30 00 45 20 21 00 E4 38 2B 14 E0 00 04 00 C5 28 23 AC 65 00 34 03 E0 00 08 AC 64 00 2C 00 00 10 21 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_414_1_0 {
	meta:
		name = "fill_input_buf"
		size = 108
	strings:
		$1 = { 27 BD FF D8 AF B0 00 1C AF BF 00 24 AF B1 00 20 8C 82 00 30 8C 91 00 28 8C 86 00 24 30 42 00 03 8C 99 00 20 00 80 80 21 8C 84 00 00 02 22 88 21 02 20 28 21 03 20 F8 09 00 C2 30 23 24 03 FF FF 50 43 00 05 00 00 10 21 AE 11 00 2C 02 22 88 21 AE 11 00 30 24 02 00 01 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_414_2_0 {
	meta:
		name = "skip_input_bytes"
		size = 148
		refs = "0000 _gp_disp 0050 fill_input_buf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B2 00 20 8F 92 ?? ?? AF B1 00 1C AF B0 00 18 AF BC 00 10 AF BF 00 24 00 80 88 21 00 A0 80 21 1A 00 00 12 24 02 00 01 8E 23 00 2C 8E 22 00 30 00 43 10 23 14 40 00 08 00 50 20 2A 26 59 ?? ?? ?? ?? ?? ?? 02 20 20 21 14 40 FF F5 00 00 10 21 10 00 00 07 8F BF 00 24 02 04 10 0A 00 62 18 21 AE 23 00 2C 10 00 FF EE 02 02 80 23 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_414_3_0 {
	meta:
		name = "xdrrec_destroy"
		size = 72
		refs = "0000 _gp_disp 0020 free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 8C 90 00 0C 8F 99 ?? ?? ?? ?? ?? ?? 8E 04 00 04 8F BC 00 10 8F BF 00 1C 02 00 20 21 8F 99 ?? ?? 8F B0 00 18 ?? ?? ?? ?? 27 BD 00 20 }
	condition:
		$1
}

rule file_414_4_0 {
	meta:
		name = "xdrrec_getpos"
		size = 140
		refs = "0000 _gp_disp 0028 __GI_lseek"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B1 00 20 AF BC 00 10 AF BF 00 24 AF B0 00 1C 8C 90 00 0C 00 80 88 21 8F 99 ?? ?? 8E 04 00 00 00 00 28 21 ?? ?? ?? ?? 24 06 00 01 24 03 FF FF 50 43 00 0D 24 02 FF FF 8E 23 00 00 10 60 00 06 24 04 00 01 54 64 00 08 24 02 FF FF 8E 04 00 2C 10 00 00 03 8E 03 00 30 8E 04 00 10 8E 03 00 0C 00 83 18 23 00 43 10 21 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_414_5_0 {
	meta:
		name = "xdrrec_setpos"
		size = 244
		refs = "0000 _gp_disp 0034 xdrrec_getpos"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF B2 00 20 AF B1 00 1C AF BC 00 10 AF BF 00 24 AF B0 00 18 27 39 ?? ?? 00 A0 90 21 00 80 88 21 ?? ?? ?? ?? 8C 90 00 0C 24 03 FF FF 10 43 00 25 00 52 28 23 8E 22 00 00 10 40 00 05 24 03 00 01 50 43 00 0F 8E 04 00 34 10 00 00 1F 00 00 10 21 8E 02 00 10 8E 03 00 18 00 45 28 23 00 65 18 2B 10 60 00 19 00 00 10 21 8E 03 00 14 00 A3 18 2B 10 60 00 16 8F BF 00 24 10 00 00 10 AE 05 00 10 8E 03 00 2C 00 A4 30 2A 10 C0 00 0F 00 00 10 21 8E 06 00 30 00 65 18 23 00 C3 30 2B 14 C0 00 0B 8F BF 00 24 8E 06 00 28 00 66 30 2B 14 C0 00 07 00 85 28 23 AE 03 00 2C AE 05 00 34 10 00 00 02 24 02 00 01 00 00 10 21 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_414_6_0 {
	meta:
		name = "get_input_bytes"
		size = 196
		refs = "0000 _gp_disp 005c fill_input_buf 0074 __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 AF B4 00 28 8F 94 ?? ?? AF B3 00 24 AF B1 00 1C AF B0 00 18 AF BC 00 10 AF BF 00 2C AF B2 00 20 00 80 88 21 00 A0 98 21 00 C0 80 21 1A 00 00 19 24 02 00 01 8E 25 00 2C 8E 32 00 30 02 45 90 23 16 40 00 08 02 50 10 2A 26 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 14 40 FF F5 8F BC 00 10 10 00 00 0D 00 00 10 21 8F 99 ?? ?? 02 02 90 0A 02 60 20 21 ?? ?? ?? ?? 02 40 30 21 8E 22 00 2C 8F BC 00 10 02 72 98 21 00 52 10 21 AE 22 00 2C 10 00 FF E7 02 12 80 23 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_414_7_0 {
	meta:
		name = "set_input_fragment"
		size = 108
		refs = "0000 _gp_disp 002c get_input_bytes"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 27 A5 00 18 24 06 00 04 AF B0 00 20 AF BC 00 10 AF BF 00 24 27 39 ?? ?? ?? ?? ?? ?? 00 80 80 21 54 40 00 03 8F A2 00 18 10 00 00 07 00 00 10 21 00 02 1F C2 10 40 FF FC AE 03 00 38 7C 42 F0 00 AE 02 00 34 24 02 00 01 8F BF 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_414_8_0 {
	meta:
		name = "xdrrec_getbytes"
		size = 224
		refs = "0000 _gp_disp 006c set_input_fragment 0098 get_input_bytes"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B5 00 30 AF B4 00 2C AF B3 00 28 AF B1 00 20 AF BC 00 10 AF BF 00 34 AF B2 00 24 AF B0 00 1C 8C 90 00 0C 8F 94 ?? ?? 8F 95 ?? ?? 00 A0 98 21 00 C0 88 21 12 20 00 1D 24 02 00 01 8E 02 00 34 14 40 00 0C 00 51 90 2B 8E 02 00 38 10 40 00 03 26 B9 ?? ?? 10 00 00 15 00 00 10 21 ?? ?? ?? ?? 02 00 20 21 14 40 FF F3 00 00 10 21 10 00 00 10 8F BF 00 34 02 32 10 0A 02 00 20 21 02 60 28 21 00 40 30 21 26 99 ?? ?? ?? ?? ?? ?? 00 40 90 21 10 40 FF F0 02 72 98 21 8E 02 00 34 02 32 88 23 00 52 10 23 10 00 FF E3 AE 02 00 34 8F BF 00 34 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_414_9_0 {
	meta:
		name = "xdrrec_getint32"
		size = 168
		refs = "0000 _gp_disp 0078 xdrrec_getbytes"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8C 82 00 0C 27 BD FF D8 AF B0 00 20 AF BC 00 10 AF BF 00 24 00 A0 80 21 8C 45 00 34 28 A5 00 04 14 A0 00 0F 8C 43 00 2C 8C 45 00 30 00 A3 28 23 28 A5 00 04 14 A0 00 0B 8F 99 ?? ?? 8C 63 00 00 AE 03 00 00 8C 43 00 34 24 63 FF FC AC 43 00 34 8C 43 00 2C 24 63 00 04 10 00 00 0A AC 43 00 2C 8F 99 ?? ?? 27 A5 00 18 27 39 ?? ?? ?? ?? ?? ?? 24 06 00 04 10 40 00 04 00 00 18 21 8F A2 00 18 AE 02 00 00 24 03 00 01 8F BF 00 24 8F B0 00 20 00 60 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_414_10_0 {
	meta:
		name = "flush_out"
		size = 136
	strings:
		$1 = { 27 BD FF D8 AF B1 00 20 AF B0 00 1C AF BF 00 24 00 80 80 21 8C 83 00 18 8C 84 00 10 38 A5 00 01 3C 02 80 00 00 83 20 23 00 05 10 0B 24 84 FF FC 00 44 10 25 AC 62 00 00 8E 05 00 0C 8E 11 00 10 8E 19 00 08 8E 04 00 00 02 25 88 23 03 20 F8 09 02 20 30 21 14 51 00 06 00 00 18 21 8E 02 00 0C 24 03 00 01 AE 02 00 18 24 42 00 04 AE 02 00 10 8F BF 00 24 8F B1 00 20 8F B0 00 1C 00 60 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_414_11_0 {
	meta:
		name = "xdrrec_putint32"
		size = 152
		refs = "0000 _gp_disp 0058 flush_out"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B1 00 20 AF BC 00 10 AF BF 00 24 AF B0 00 1C 8C 90 00 0C 8E 02 00 10 8E 04 00 14 24 43 00 04 AE 03 00 10 00 83 18 2B 10 60 00 0E 00 A0 88 21 8F 99 ?? ?? AE 02 00 10 24 02 00 01 AE 02 00 1C 02 00 20 21 27 39 ?? ?? ?? ?? ?? ?? 00 00 28 21 10 40 00 07 00 00 18 21 8E 02 00 10 24 43 00 04 AE 03 00 10 8E 23 00 00 AC 43 00 00 24 03 00 01 8F BF 00 24 8F B1 00 20 8F B0 00 1C 00 60 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_414_12_0 {
	meta:
		name = "xdrrec_putbytes"
		size = 224
		refs = "0000 _gp_disp 0048 __GI_memcpy 00a0 flush_out"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B5 00 30 AF B4 00 2C AF B3 00 28 AF B1 00 20 AF BC 00 10 AF BF 00 34 AF B2 00 24 AF B0 00 1C 8C 90 00 0C 8F 95 ?? ?? 00 A0 98 21 00 C0 88 21 24 14 00 01 12 20 00 1C 8F 99 ?? ?? 8E 04 00 10 8E 12 00 14 02 60 28 21 02 44 90 23 02 51 10 2B 02 22 90 0A ?? ?? ?? ?? 02 40 30 21 8E 02 00 10 8E 03 00 14 8F BC 00 10 00 52 10 21 AE 02 00 10 02 72 98 21 14 43 FF EF 02 32 88 23 12 20 00 0B 24 02 00 01 AE 14 00 1C 02 00 20 21 26 B9 ?? ?? ?? ?? ?? ?? 00 00 28 21 14 40 FF E6 8F BC 00 10 10 00 00 02 00 00 10 21 24 02 00 01 8F BF 00 34 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_414_13_0 {
	meta:
		name = "__GI_xdrrec_create"
		size = 412
		refs = "0054 malloc 00c0 __GI_fputs 00d0 free 0000 _gp_disp 00b0 stderr 00b4 $LC0"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF C0 AF BC 00 10 AF BF 00 3C AF B7 00 38 AF B6 00 34 AF B5 00 30 AF B4 00 2C AF B3 00 28 AF B2 00 24 AF B1 00 20 AF B0 00 1C 00 80 A0 21 24 04 00 44 00 A0 88 21 00 C0 90 21 00 E0 B8 21 8F B6 00 50 ?? ?? ?? ?? 8F B5 00 54 00 40 80 21 8F BC 00 10 24 03 0F A0 2E 22 00 64 00 62 88 0B 2E 44 00 64 24 02 FF FC 00 64 90 0B 26 31 00 03 02 22 98 24 8F 99 ?? ?? 26 52 00 03 02 42 90 24 26 64 00 04 ?? ?? ?? ?? 00 92 20 21 00 40 88 21 12 00 00 03 8F BC 00 10 54 40 00 19 AE 13 00 3C 8F 82 ?? ?? 8F 84 ?? ?? 8F 99 ?? ?? 8C 45 00 00 ?? ?? ?? ?? 24 84 ?? ?? 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F BF 00 3C 8F B7 00 38 8F B6 00 34 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B0 00 1C 02 20 20 21 8F 99 ?? ?? 8F B1 00 20 ?? ?? ?? ?? 27 BD 00 40 AE 02 00 04 00 53 98 21 AE 02 00 0C 8F 82 ?? ?? 8F BF 00 3C AE 13 00 28 24 42 ?? ?? AE 82 00 04 AE 11 00 18 AE 13 00 14 26 31 00 04 02 72 98 21 24 02 00 01 AE 12 00 40 AE 90 00 0C AE 17 00 00 AE 16 00 20 AE 15 00 08 AE 11 00 10 AE 12 00 24 AE 13 00 30 AE 13 00 2C 8F B7 00 38 8F B6 00 34 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 AE 00 00 1C AE 00 00 34 AE 02 00 38 8F B0 00 1C 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_414_14_0 {
	meta:
		name = "__GI_xdrrec_skiprecord"
		size = 164
		refs = "0040 skip_input_bytes 0064 set_input_fragment 0000 _gp_disp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B2 00 20 AF B1 00 1C AF BC 00 10 AF BF 00 24 AF B0 00 18 8C 90 00 0C 8F 91 ?? ?? 8F 92 ?? ?? 8E 05 00 34 58 A0 00 11 8E 02 00 38 26 39 ?? ?? ?? ?? ?? ?? 02 00 20 21 54 40 00 03 8E 02 00 38 10 00 00 0E 00 00 10 21 14 40 FF F5 AE 00 00 34 26 59 ?? ?? ?? ?? ?? ?? 02 00 20 21 54 40 FF F1 8E 05 00 34 10 00 00 05 00 00 10 21 10 40 FF F0 26 39 ?? ?? AE 00 00 38 24 02 00 01 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_414_15_0 {
	meta:
		name = "__GI_xdrrec_eof"
		size = 172
		refs = "0040 skip_input_bytes 0064 set_input_fragment 0000 _gp_disp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B2 00 20 AF B1 00 1C AF BC 00 10 AF BF 00 24 AF B0 00 18 8C 90 00 0C 8F 91 ?? ?? 8F 92 ?? ?? 8E 05 00 34 58 A0 00 11 8E 02 00 38 26 39 ?? ?? ?? ?? ?? ?? 02 00 20 21 54 40 00 03 8E 02 00 38 10 00 00 10 24 02 00 01 14 40 FF F5 AE 00 00 34 26 59 ?? ?? ?? ?? ?? ?? 02 00 20 21 54 40 FF F1 8E 05 00 34 10 00 00 07 24 02 00 01 10 40 FF F0 26 39 ?? ?? 8E 03 00 2C 8E 02 00 30 00 62 10 26 2C 42 00 01 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_414_16_0 {
	meta:
		name = "__GI_xdrrec_endofrecord"
		size = 120
		refs = "0000 _gp_disp 0044 flush_out"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 14 A0 00 0A 8C 84 00 0C 8C 82 00 1C 14 40 00 08 8F 99 ?? ?? 8C 83 00 10 8C 85 00 14 24 62 00 04 00 45 10 2B 54 40 00 06 8C 82 00 18 8F 99 ?? ?? AC 80 00 1C 27 39 ?? ?? ?? ?? ?? ?? 24 05 00 01 3C 05 80 00 00 62 18 23 24 63 FF FC 00 65 18 25 AC 43 00 00 8C 82 00 10 AC 82 00 18 24 42 00 04 AC 82 00 10 03 E0 00 08 24 02 00 01 }
	condition:
		$1
}

rule file_415_0_0 {
	meta:
		name = "__GI_isupper"
		size = 40
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 00 04 20 40 8C 42 00 00 00 44 10 21 94 42 00 00 03 E0 00 08 30 42 00 01 }
	condition:
		$1
}

rule file_417_0_0 {
	meta:
		name = "sigisemptyset"
		size = 52
	strings:
		$1 = { 8C 82 00 0C 24 03 00 03 24 05 FF FF 14 40 00 07 24 63 FF FF 10 65 00 05 00 00 00 00 00 03 10 80 00 82 10 21 10 00 FF F9 8C 42 00 00 03 E0 00 08 2C 42 00 01 }
	condition:
		$1
}

rule file_418_0_0 {
	meta:
		name = "__parsegrent"
		size = 416
		refs = "0000 _gp_disp 0014 __GI_strchr 0070 __GI_strtoul 00b8 __GI___ctype_b"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 AF B2 00 28 8F 92 ?? ?? AF B0 00 20 00 80 80 21 AF B1 00 24 AF BC 00 10 00 A0 20 21 8E 11 00 00 AF BF 00 2C AE 05 00 00 02 40 C8 21 ?? ?? ?? ?? 24 05 00 3A 14 40 00 03 24 44 00 01 10 00 00 4E 24 02 FF FF A0 40 00 00 24 05 00 3A 02 40 C8 21 ?? ?? ?? ?? AE 04 00 04 10 40 FF F8 8F BC 00 10 8F 99 ?? ?? 24 52 00 01 A0 40 00 00 02 40 20 21 27 A5 00 18 ?? ?? ?? ?? 24 06 00 0A AE 02 00 08 8F A2 00 18 10 52 FF ED 8F BC 00 10 80 44 00 00 24 03 00 3A 54 83 00 38 24 02 FF FF 80 43 00 01 10 60 00 1C 24 03 00 01 8F 86 ?? ?? 24 03 00 2C A0 43 00 00 00 40 20 21 24 03 00 01 24 05 00 2C 80 47 00 00 54 E5 00 10 24 82 00 01 A0 40 00 00 24 44 00 01 80 42 00 01 10 40 FF D8 24 63 00 01 50 45 00 25 24 02 FF FF 8C C7 00 00 00 02 10 40 00 E2 10 21 94 42 00 00 30 42 00 20 14 40 00 1E 24 02 FF FF 24 82 00 01 80 84 00 01 14 80 FF EC 00 40 20 21 24 04 FF FC 24 42 00 04 00 44 10 24 00 03 20 80 00 44 20 21 02 24 88 2B 16 20 FF C3 24 64 FF FF 10 80 00 0E AE 02 00 0C 8F A3 00 18 00 40 28 21 24 63 00 01 24 84 FF FF 24 42 00 04 10 80 00 07 AC A3 00 00 24 63 00 01 80 65 00 00 54 A0 FF FE 24 63 00 01 10 00 FF F6 00 40 28 21 AC 40 00 00 00 00 10 21 8F BF 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_419_0_0 {
	meta:
		name = "__GI_fclose"
		size = 448
		refs = "0000 _gp_disp 0034 _pthread_cleanup_push_defer 0038 __pthread_mutex_unlock 0050 __pthread_mutex_lock 0070 __GI_fflush_unlocked 0084 __GI_close 00a4 _stdio_openlist_del_lock 00dc _stdio_openlist_use_count 00e0 _pthread_cleanup_pop_restore 0134 free 0178 _stdio_openlist_del_count 0194 _stdio_openlist_dec_use"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B0 AF B0 00 3C AF BC 00 10 AF BF 00 4C AF B3 00 48 AF B2 00 44 AF B1 00 40 8C 93 00 34 16 60 00 0C 00 80 80 21 8F 99 ?? ?? 8F 85 ?? ?? 24 91 00 38 02 20 30 21 ?? ?? ?? ?? 27 A4 00 28 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 96 02 00 00 30 42 00 40 10 40 00 06 00 00 88 21 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 00 40 88 21 8F 99 ?? ?? 8E 04 00 04 ?? ?? ?? ?? 27 B2 00 18 8F BC 00 10 24 03 FF FF 28 42 00 00 8F 85 ?? ?? 8F 86 ?? ?? 8F 99 ?? ?? AE 03 00 04 02 40 20 21 ?? ?? ?? ?? 00 62 88 0B 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 02 40 20 21 24 05 00 01 8F 82 ?? ?? 8F 99 ?? ?? 8C 43 00 00 24 63 00 01 AC 43 00 00 ?? ?? ?? ?? 00 00 00 00 96 02 00 00 8F BC 00 10 30 42 60 00 34 42 00 30 16 60 00 06 A6 02 00 00 8F 99 ?? ?? 27 A4 00 28 ?? ?? ?? ?? 24 05 00 01 8F BC 00 10 96 02 00 00 30 42 40 00 10 40 00 06 8F 86 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 8E 04 00 08 8F BC 00 10 8F 86 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 02 40 20 21 24 05 00 01 8F 82 ?? ?? 8F 99 ?? ?? 8C 43 00 00 24 63 00 01 ?? ?? ?? ?? AC 43 00 00 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BF 00 4C 02 20 10 21 8F B3 00 48 8F B2 00 44 8F B1 00 40 8F B0 00 3C 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_420_0_0 {
	meta:
		name = "shmget"
		size = 76
		refs = "0000 _gp_disp 000c __syscall_ipc"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 00 80 18 21 00 A0 10 21 00 C0 38 21 AF BF 00 24 AF BC 00 18 AF A0 00 10 AF A0 00 14 24 04 00 17 00 60 28 21 ?? ?? ?? ?? 00 40 30 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_421_0_0 {
	meta:
		name = "__GI_stat64"
		size = 120
		refs = "0000 _gp_disp 0034 __GI___errno_location 0054 __xstat64_conv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 78 AF BC 00 10 00 A0 30 21 AF BF 00 84 AF B0 00 80 27 A5 00 18 24 02 10 75 00 00 00 0C 10 E0 00 07 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 10 00 00 07 24 10 FF FF 14 40 00 06 8F BF 00 84 8F 99 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 00 C0 28 21 8F BF 00 84 02 00 10 21 8F B0 00 80 03 E0 00 08 27 BD 00 88 }
	condition:
		$1
}

rule file_423_0_0 {
	meta:
		name = "__syscall_mmap2"
		size = 108
		refs = "0000 _gp_disp 0044 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF B0 00 18 AF BF 00 1C 8F B0 00 34 8F A2 00 30 27 BD FF E0 AF A2 00 10 AF B0 00 14 24 02 10 72 00 00 00 0C 27 BD 00 20 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_423_1_0 {
	meta:
		name = "mmap64"
		size = 100
		refs = "0000 _gp_disp 0024 __GI___errno_location 003c __syscall_mmap2"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 8F A2 00 3C AF BC 00 10 AF BF 00 1C 30 48 0F FF 15 00 00 08 8F 99 ?? ?? 8F 99 ?? ?? 8F BF 00 1C 00 02 13 02 AF A2 00 34 27 39 ?? ?? ?? ?? ?? ?? 27 BD 00 20 ?? ?? ?? ?? 00 00 00 00 24 03 00 16 AC 43 00 00 8F BF 00 1C 24 02 FF FF 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_425_0_0 {
	meta:
		name = "__GI_getcwd"
		size = 304
		refs = "0000 _gp_disp 0038 __GI_getpagesize 003c __GI___errno_location 0078 malloc 00d8 realloc 0100 free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 AF BC 00 10 AF B3 00 28 AF B0 00 1C AF BF 00 2C AF B2 00 24 AF B1 00 20 00 80 80 21 14 A0 00 0F 00 A0 98 21 10 80 00 07 8F 99 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 88 21 24 03 00 16 10 00 00 30 AC 43 00 00 ?? ?? ?? ?? 24 12 10 00 28 43 10 00 8F BC 00 10 10 00 00 04 00 43 90 0A 00 A0 90 21 14 80 00 07 00 80 88 21 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 00 40 88 21 10 40 00 20 8F BC 00 10 02 20 20 21 02 40 28 21 24 02 10 6B 00 00 00 0C 10 E0 00 07 00 40 90 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 10 00 00 0F AC 52 00 00 04 40 00 0D 00 00 00 00 56 00 00 11 02 00 88 21 16 60 00 10 8F BF 00 2C 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 00 40 28 21 10 40 00 09 00 40 80 21 10 00 00 07 02 00 88 21 56 00 00 05 00 00 88 21 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 00 00 88 21 8F BF 00 2C 02 20 10 21 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_426_0_0 {
	meta:
		name = "_stdio_openlist_dec_use"
		size = 388
		refs = "0000 _gp_disp 0010 _pthread_cleanup_push_defer 0014 __pthread_mutex_unlock 0018 _stdio_openlist_del_lock 005c __pthread_mutex_lock 0070 _stdio_openlist_use_count 007c _stdio_openlist_del_count 0094 _stdio_openlist_add_lock 00c4 _stdio_openlist 00d4 _pthread_cleanup_pop_restore 0104 free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A0 8F 99 ?? ?? 8F 85 ?? ?? 8F 86 ?? ?? AF B2 00 40 27 B2 00 28 AF BC 00 10 AF BF 00 5C AF B3 00 44 AF BE 00 58 AF B7 00 54 AF B6 00 50 AF B5 00 4C AF B4 00 48 AF B1 00 3C AF B0 00 38 ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 24 02 00 01 8F 93 ?? ?? 8E 63 00 00 14 62 00 2F 8F 82 ?? ?? 8C 43 00 00 18 60 00 2C 00 40 A8 21 8F 99 ?? ?? 8F 85 ?? ?? 8F 86 ?? ?? 27 B4 00 18 ?? ?? ?? ?? 02 80 20 21 8F BC 00 10 00 00 80 21 24 17 80 30 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 1E 00 30 8F BC 00 10 8F 83 ?? ?? 8C 64 00 00 00 60 B0 21 10 80 00 14 8F 99 ?? ?? 94 83 00 00 00 77 18 24 14 7E 00 0D 8C 91 00 20 56 00 00 02 AE 11 00 20 AE D1 00 00 94 83 00 00 30 63 20 00 50 60 FF F4 02 20 20 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 02 8F BC 00 10 00 80 80 21 10 00 FF EC 02 20 20 21 02 80 20 21 ?? ?? ?? ?? 24 05 00 01 8F BC 00 10 AE A0 00 00 8E 62 00 00 8F 99 ?? ?? 02 40 20 21 24 42 FF FF AE 62 00 00 ?? ?? ?? ?? 24 05 00 01 8F BF 00 5C 8F BE 00 58 8F B7 00 54 8F B6 00 50 8F B5 00 4C 8F B4 00 48 8F B3 00 44 8F B2 00 40 8F B1 00 3C 8F B0 00 38 03 E0 00 08 27 BD 00 60 }
	condition:
		$1
}

rule file_426_1_0 {
	meta:
		name = "__GI_fflush_unlocked"
		size = 576
		refs = "0000 _gp_disp 0014 _stdio_openlist 0054 _stdio_openlist_del_lock 0060 __pthread_mutex_unlock 0064 _pthread_cleanup_push_defer 007c __pthread_mutex_lock 0098 _stdio_openlist_use_count 009c _pthread_cleanup_pop_restore 00bc _stdio_openlist_add_lock 0100 _stdio_user_locking 0104 __stdio_wcommit 010c _stdio_openlist_dec_use"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B0 AF B2 00 30 8F 92 ?? ?? AF BC 00 10 AF B0 00 28 AF BF 00 4C AF BE 00 48 AF B7 00 44 AF B6 00 40 AF B5 00 3C AF B4 00 38 AF B3 00 34 AF B1 00 2C 10 92 00 05 00 80 80 21 14 80 00 62 24 13 01 00 10 00 00 03 8F 86 ?? ?? 00 00 98 21 8F 86 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 27 B1 00 18 ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 24 14 00 02 8F 99 ?? ?? 8F 84 ?? ?? ?? ?? ?? ?? 24 1E FF BF 8F BC 00 10 02 20 20 21 24 05 00 01 8F 82 ?? ?? 8F 99 ?? ?? 8C 43 00 00 24 63 00 01 AC 43 00 00 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 85 ?? ?? 8F 86 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 02 20 20 21 24 05 00 01 8F 99 ?? ?? 8E 50 00 00 ?? ?? ?? ?? 00 00 90 21 8F BC 00 10 8F 96 ?? ?? 8F 97 ?? ?? 12 00 00 2E 8F 99 ?? ?? 96 02 00 00 30 42 00 40 50 40 FF FB 8E 10 00 20 8E C2 00 00 10 54 00 0B 8F 99 ?? ?? 8F 85 ?? ?? 26 15 00 38 02 20 20 21 ?? ?? ?? ?? 02 A0 30 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 A0 20 21 8F BC 00 10 96 02 00 00 02 62 10 25 38 42 01 40 30 42 03 40 14 40 00 0E 8F 82 ?? ?? 02 E0 C8 21 ?? ?? ?? ?? 02 00 20 21 14 40 00 07 8F BC 00 10 8E 02 00 08 AE 02 00 1C 96 02 00 00 00 5E 10 24 10 00 00 02 A6 02 00 00 24 12 FF FF 8F 82 ?? ?? 8C 42 00 00 10 54 00 05 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 24 05 00 01 8F BC 00 10 10 00 FF D2 8E 10 00 20 ?? ?? ?? ?? 00 00 00 00 10 00 00 10 8F BF 00 4C 94 82 00 00 30 42 00 40 10 40 00 0B 00 00 90 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 54 40 00 06 24 12 FF FF 8E 02 00 08 AE 02 00 1C 96 02 00 00 30 42 FF BF A6 02 00 00 8F BF 00 4C 02 40 10 21 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_427_0_0 {
	meta:
		name = "__GI_open"
		size = 120
		refs = "0000 _gp_disp 0050 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 30 A3 01 00 AF BC 00 10 AF BF 00 24 AF B0 00 20 AF A6 00 30 AF A7 00 34 10 60 00 04 00 00 10 21 27 A2 00 30 AF A2 00 18 00 C0 10 21 00 40 30 21 24 02 0F A5 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 24 02 00 10 21 8F B0 00 20 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_428_0_0 {
	meta:
		name = "__GI_isatty"
		size = 52
		refs = "0000 _gp_disp 000c __GI_tcgetattr"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF A8 AF BF 00 54 AF BC 00 10 ?? ?? ?? ?? 27 A5 00 18 8F BF 00 54 2C 42 00 01 03 E0 00 08 27 BD 00 58 }
	condition:
		$1
}

rule file_429_0_0 {
	meta:
		name = "__GI_wcschrnul"
		size = 36
	strings:
		$1 = { 24 82 FF FC 24 42 00 04 8C 43 00 00 10 60 00 03 00 00 00 00 54 65 FF FC 24 42 00 04 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_430_0_0 {
	meta:
		name = "byte_insert_op1"
		size = 48
	strings:
		$1 = { 24 E2 00 03 10 E5 00 05 24 42 FF FF 24 E7 FF FF 90 E3 00 00 10 00 FF FB A0 43 00 00 A0 E6 00 01 00 06 32 03 A0 E4 00 00 03 E0 00 08 A0 E6 00 02 }
	condition:
		$1
}

rule file_430_1_0 {
	meta:
		name = "byte_compile_range"
		size = 216
	strings:
		$1 = { 8C A3 00 00 10 66 00 0F 8F A8 00 14 24 62 00 01 AC A2 00 00 8F A2 00 10 24 05 00 0B 7C 42 04 00 00 02 28 0A 10 E0 00 09 00 A0 10 21 90 63 00 00 30 84 00 FF 00 E4 20 21 80 84 00 00 10 00 00 03 00 E3 18 21 03 E0 00 08 24 02 00 0B 90 63 00 00 24 05 00 01 00 64 30 2B 14 C0 00 1D 00 00 00 00 10 E0 00 04 00 E4 10 21 90 42 00 00 10 00 00 02 00 02 10 C3 00 04 10 C3 10 E0 00 05 01 02 30 21 00 E4 10 21 90 42 00 00 10 00 00 02 00 02 10 C3 00 04 10 C3 01 02 10 21 10 E0 00 05 80 49 00 00 00 E4 10 21 90 42 00 00 10 00 00 02 30 42 00 07 30 82 00 07 00 45 10 04 7C 02 14 20 00 49 10 25 A0 C2 00 00 24 84 00 01 10 00 FF E2 00 00 10 21 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_430_2_0 {
	meta:
		name = "byte_common_op_match_null_string_p"
		size = 396
		refs = "0000 _gp_disp 00b8 byte_group_match_null_string_p"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 AF B0 00 20 AF BC 00 10 AF BF 00 2C AF B2 00 28 AF B1 00 24 8C 82 00 00 00 80 80 21 24 44 00 01 AF A4 00 18 90 43 00 00 2C 67 00 0D 50 E0 00 0B 24 05 00 15 2C 64 00 09 10 80 00 47 24 04 00 06 10 64 00 16 00 C0 88 21 24 04 00 08 50 64 00 3C 90 46 00 01 10 00 00 0D 00 00 00 00 50 65 00 29 24 43 00 03 2C 64 00 16 10 80 00 05 24 04 00 0D 50 64 00 1D 80 43 00 02 10 00 00 3A 00 00 10 21 24 63 FF E6 24 02 00 03 00 43 18 2B 54 60 00 35 00 00 10 21 10 00 00 31 8F A2 00 18 8F 99 ?? ?? 90 52 00 01 27 39 ?? ?? ?? ?? ?? ?? 27 A4 00 18 00 12 30 80 02 26 30 21 8C C4 00 00 3C 03 C0 00 00 64 20 24 14 83 00 04 00 00 00 00 90 C3 00 00 7C 43 39 84 A0 C3 00 00 54 40 00 20 8F A2 00 18 10 00 00 20 00 00 10 21 90 44 00 01 00 03 1A 00 00 83 18 21 04 61 00 0F 24 42 00 03 10 00 00 19 00 00 10 21 AF A3 00 18 80 45 00 04 90 46 00 03 00 05 2A 00 00 C5 28 21 54 A0 00 12 00 00 10 21 AF A4 00 18 90 44 00 01 80 42 00 02 00 02 12 00 00 82 10 21 00 62 18 21 10 00 00 07 AF A3 00 18 3C 03 C0 00 00 06 30 80 02 26 88 21 8E 22 00 00 10 00 FF E1 00 62 10 24 8F A2 00 18 AE 02 00 00 24 02 00 01 8F BF 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_430_3_0 {
	meta:
		name = "byte_group_match_null_string_p"
		size = 456
		refs = "0000 _gp_disp 00d4 byte_alt_match_null_string_p 0180 byte_common_op_match_null_string_p"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B0 AF B7 00 44 AF B6 00 40 AF B4 00 38 AF B3 00 34 AF B2 00 30 AF B1 00 2C AF B0 00 28 AF BC 00 10 AF BF 00 4C AF BE 00 48 AF B5 00 3C 8C 82 00 00 8F 96 ?? ?? 8F 97 ?? ?? 24 42 00 02 AF A2 00 18 27 A2 00 18 00 80 90 21 00 A0 88 21 00 C0 80 21 24 14 00 07 24 13 00 0F AF A2 00 20 8F A2 00 18 00 51 18 2B 50 60 00 48 00 00 10 21 90 43 00 00 50 74 00 3A 24 42 00 02 14 73 00 3B 27 A4 00 18 24 43 00 01 AF A3 00 18 80 5E 00 02 90 43 00 01 24 42 00 03 00 1E F2 00 00 7E F0 21 AF A2 00 18 07 C0 FF EE 24 15 00 0E 8F A4 00 18 27 C5 FF FD 00 85 28 21 90 A2 00 00 14 55 00 1A 26 F9 ?? ?? AF B9 00 24 ?? ?? ?? ?? 02 00 30 21 14 40 00 03 8F B9 00 24 10 00 00 2C 00 00 10 21 8F A2 00 18 00 5E 10 21 AF A2 00 18 90 44 00 00 14 93 00 0D 24 44 00 01 AF A4 00 18 80 5E 00 02 90 44 00 01 00 1E F2 00 00 9E F0 21 24 44 00 03 AF A4 00 18 00 9E 20 21 90 84 FF FD 10 95 FF E4 8F A4 00 18 AF A2 00 18 8F A4 00 18 02 00 30 21 80 9E FF FF 90 82 FF FE 00 1E F2 00 00 5E F0 21 03 20 F8 09 00 9E 28 21 10 40 00 10 00 00 10 21 8F A2 00 18 00 5E F0 21 10 00 FF C1 AF BE 00 18 AE 42 00 00 10 00 00 09 24 02 00 01 02 20 28 21 26 D9 ?? ?? ?? ?? ?? ?? 02 00 30 21 54 40 FF B9 8F A2 00 18 10 00 00 01 00 00 10 21 8F BF 00 4C 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_430_4_0 {
	meta:
		name = "byte_alt_match_null_string_p"
		size = 196
		refs = "0000 _gp_disp 0090 byte_common_op_match_null_string_p"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B4 00 30 8F 94 ?? ?? AF B3 00 2C AF B2 00 28 AF B1 00 24 AF B0 00 20 AF BC 00 10 AF BF 00 34 00 A0 80 21 00 C0 90 21 AF A4 00 18 24 13 00 0F 27 B1 00 18 8F A2 00 18 00 50 18 2B 50 60 00 15 24 02 00 01 90 43 00 00 14 73 00 0A 24 43 00 01 AF A3 00 18 90 44 00 01 24 43 00 03 80 42 00 02 00 02 12 00 00 82 10 21 00 62 10 21 10 00 FF F1 AF A2 00 18 02 20 20 21 02 00 28 21 26 99 ?? ?? ?? ?? ?? ?? 02 40 30 21 54 40 FF EB 8F A2 00 18 00 00 10 21 8F BF 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_430_5_0 {
	meta:
		name = "byte_re_compile_fastmap"
		size = 1132
		refs = "0000 _gp_disp 0040 __GI_memset 0080 re_max_failures 0370 __GI_memcpy 0420 __GI_abort"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A8 AF BE 00 50 AF B7 00 4C AF B4 00 40 AF B3 00 3C AF B2 00 38 AF BC 00 10 AF BF 00 54 AF B6 00 48 AF B5 00 44 AF B1 00 34 AF B0 00 30 8C 95 00 10 8F 99 ?? ?? 03 A0 F0 21 00 80 98 21 8C 91 00 00 8C 96 00 08 27 BD FF E0 00 00 28 21 02 A0 20 21 ?? ?? ?? ?? 24 06 01 00 8F DC 00 10 92 62 00 1C 24 03 00 01 8F 88 ?? ?? 7C 62 21 04 8F 83 ?? ?? 8F 89 ?? ?? 7C 02 39 C4 02 36 B0 21 27 B7 00 10 A2 62 00 1C 00 00 90 21 24 05 00 05 24 14 00 01 25 08 ?? ?? 24 63 ?? ?? 12 36 00 04 24 04 00 01 92 22 00 00 14 44 00 0F 2C 44 00 1E 8E 64 00 1C 92 62 00 1C 7C 84 07 C0 02 84 A0 25 7E 82 39 C4 12 40 00 D6 A2 62 00 1C 26 52 FF FF 00 12 10 80 02 E2 10 21 8C 50 00 00 24 14 00 01 10 00 FF EE 02 00 88 21 10 80 00 CA 26 30 00 01 00 02 10 80 01 02 10 21 8C 42 00 00 00 5C 10 21 00 40 00 08 00 00 00 00 92 62 00 1C 24 03 00 01 7C 62 39 C4 10 00 00 C2 A2 62 00 1C 92 22 00 02 24 04 00 01 02 A2 10 21 10 00 00 5A A0 44 00 00 92 22 00 01 26 26 00 02 24 04 FF FF 00 02 10 C0 24 42 FF FF 24 07 00 01 10 44 00 53 02 C0 80 21 00 02 50 C3 00 CA 50 21 91 4B 00 00 30 4A 00 07 01 4B 50 07 31 4A 00 01 51 40 FF F7 24 42 FF FF 02 A2 50 21 A1 47 00 00 10 00 FF F3 24 42 FF FF 92 22 00 01 24 06 00 01 00 02 10 C0 28 44 01 00 10 80 00 04 02 A2 20 21 A0 86 00 00 10 00 FF FB 24 42 00 01 92 22 00 01 26 26 00 02 24 04 FF FF 00 02 10 C0 24 42 FF FF 24 07 00 01 10 44 00 36 02 C0 80 21 00 02 50 C3 00 CA 50 21 91 4B 00 00 30 4A 00 07 01 4B 50 07 31 4A 00 01 55 40 FF F7 24 42 FF FF 02 A2 50 21 A1 47 00 00 10 00 FF F3 24 42 FF FF 00 00 10 21 24 04 00 01 24 06 01 00 00 43 38 21 80 E7 00 00 54 E4 00 04 24 42 00 01 02 A2 38 21 A0 E4 00 00 24 42 00 01 54 46 FF F9 00 43 38 21 10 00 00 1C 02 C0 80 21 00 00 10 21 24 04 00 01 24 06 01 00 00 43 38 21 80 E7 00 00 10 E4 00 02 02 A2 38 21 A0 E4 00 00 24 42 00 01 54 46 FF FA 00 43 38 21 10 00 00 0F 02 C0 80 21 82 A4 00 0A 00 00 10 21 24 0A 00 01 24 06 01 00 02 A2 38 21 24 42 00 01 14 46 FF FD A0 EA 00 00 8E 62 00 0C 30 42 00 40 54 40 00 05 8E 62 00 1C A2 A4 00 0A 02 C0 80 21 10 00 FF 91 00 00 A0 21 04 41 FF FD 02 C0 80 21 10 00 00 60 00 00 10 21 82 22 00 02 92 24 00 01 26 30 00 03 00 02 12 00 00 82 10 21 1C 40 FF 86 02 02 80 21 92 02 00 00 24 04 00 0F 10 44 00 03 24 04 00 15 14 44 FF 6F 02 00 88 21 92 04 00 01 26 02 00 03 82 10 00 02 00 10 82 00 00 90 80 21 12 40 FF 79 00 50 80 21 00 12 10 80 02 E2 10 21 8C 42 FF FC 00 50 10 26 2C 42 00 01 10 00 FF 72 02 42 90 23 00 00 88 21 82 0A 00 01 92 02 00 00 26 07 00 02 00 0A 52 00 00 4A 50 21 00 EA 50 21 01 56 10 2B 50 40 00 23 92 62 00 1C 16 45 00 1D 00 12 10 80 8D 22 00 00 24 04 00 13 70 82 10 02 00 52 10 2B 14 40 00 32 00 12 10 C0 8F 99 ?? ?? 24 42 00 08 03 A2 E8 23 02 E0 28 21 AF C3 00 28 AF C7 00 18 AF C8 00 20 AF C9 00 24 AF CA 00 1C 27 A4 00 10 ?? ?? ?? ?? 00 12 30 80 00 40 B8 21 8F DC 00 10 8F C3 00 28 8F C7 00 18 8F C8 00 20 8F C9 00 24 10 40 00 1E 8F CA 00 1C 00 12 28 40 00 12 10 80 02 E2 10 21 AC 4A 00 00 10 00 00 04 26 52 00 01 24 04 00 01 7C 82 39 C4 A2 62 00 1C 26 10 00 04 10 00 FF 40 00 F1 80 0A 82 22 00 04 92 24 00 03 00 02 12 00 00 82 10 21 54 40 FF 3A 26 30 00 05 10 00 FF C8 24 11 00 01 10 00 FF 36 26 30 00 05 10 00 FF 34 26 30 00 03 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 02 00 00 10 21 24 02 FF FE 03 C0 E8 21 8F BF 00 54 8F BE 00 50 8F B7 00 4C 8F B6 00 48 8F B5 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 58 }
	condition:
		$1
}

rule file_430_6_0 {
	meta:
		name = "byte_re_match_2_internal"
		size = 7744
		refs = "0000 _gp_disp 043c malloc 04d4 realloc 0930 byte_group_match_null_string_p 0c00 re_max_failures 0c84 __GI_memcpy 0ecc __GI_memcmp 1cb0 __GI_abort"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 40 AF BE 00 B8 AF B4 00 A8 AF B1 00 9C AF BF 00 BC AF B7 00 B4 AF B6 00 B0 AF B5 00 AC AF B3 00 A4 AF B2 00 A0 AF B0 00 98 AF BC 00 10 8C 88 00 18 8C 8C 00 00 8C 82 00 08 8C 83 00 14 03 A0 F0 21 01 82 10 21 25 0A 00 01 27 BD FF E0 AF C5 00 C4 00 E0 88 21 AF C4 00 C0 00 C0 48 21 8F C7 00 D8 8F C5 00 DC AF C2 00 34 AF C3 00 28 AF C8 00 4C AF CA 00 38 11 00 00 20 27 B4 00 10 00 0A 10 80 24 42 00 0E 00 02 10 C2 00 02 10 C0 03 A2 E8 23 27 AB 00 10 03 A2 E8 23 27 AD 00 10 03 A2 E8 23 27 AE 00 10 03 A2 E8 23 27 B9 00 10 03 A2 E8 23 27 A3 00 10 03 A2 E8 23 27 A8 00 10 03 A2 E8 23 AF C8 00 54 27 A8 00 10 03 A2 E8 23 27 AA 00 10 03 A2 E8 23 AF CB 00 20 27 AB 00 10 AF CD 00 24 AF CE 00 40 AF D9 00 44 AF C3 00 50 AF CA 00 5C 10 00 00 0A AF CB 00 60 AF C0 00 60 AF C0 00 5C AF C0 00 54 AF C0 00 50 00 00 40 21 AF C0 00 44 AF C0 00 40 AF C0 00 24 AF C0 00 20 8F CD 00 D4 05 A1 00 03 8F CE 00 D0 10 00 07 34 24 02 FF FF 8F D9 00 D4 01 2E 10 21 00 59 10 2A 14 40 FF FA 8F 84 ?? ?? 24 03 00 01 24 0A 00 03 24 84 ?? ?? 8F CB 00 38 00 6B 10 2B 10 40 00 16 8F CB 00 44 8F CD 00 40 00 03 10 80 8F CE 00 24 01 62 30 21 8F D9 00 20 AC C4 00 00 01 A2 30 21 AC C4 00 00 01 C2 30 21 AC C4 00 00 03 22 30 21 AC C4 00 00 01 02 10 21 90 46 00 00 24 63 00 01 7D 46 39 84 7C 06 29 44 7C 06 21 04 7C 06 18 C4 10 00 FF E8 A0 46 00 00 8F CD 00 D0 15 A0 00 0A 8F CA 00 D0 8F CE 00 C4 55 C0 00 03 AF C9 00 D0 10 00 00 04 AF CE 00 D0 8F D1 00 C4 00 00 48 21 AF C0 00 C4 8F CA 00 D0 8F D9 00 C4 01 25 10 2A 02 2A 50 21 03 29 18 21 14 40 00 05 AF CA 00 3C 03 25 28 21 AF C5 00 2C 10 00 00 04 02 20 78 21 00 A9 28 23 02 25 78 21 AF C3 00 2C 19 20 00 08 8F CB 00 D4 01 2B 10 2A 14 40 00 06 8F CE 00 D4 8F CD 00 C4 8F D8 00 2C 10 00 00 05 01 AB 80 21 8F CE 00 D4 01 E0 C0 21 01 C9 80 23 02 30 80 21 00 00 90 21 24 17 00 05 00 00 50 21 AF C0 00 30 AF C0 00 48 24 16 01 00 24 15 01 01 AF C0 00 58 8F D9 00 34 55 99 01 00 91 86 00 00 12 0F 00 50 00 00 00 00 11 20 00 08 00 00 20 21 8F CA 00 C4 8F CB 00 30 01 6A 10 2B 14 40 00 04 8F CC 00 2C 00 6B 20 2B 38 84 00 01 8F CC 00 2C 8F CD 00 30 03 0C 28 26 00 05 30 2B 01 B0 10 2B 00 C4 20 26 12 40 00 1D 00 C4 10 0A 8F CE 00 48 51 C0 00 04 24 02 00 01 10 40 02 A8 02 00 20 21 24 02 00 01 8F CD 00 38 00 4D 20 2B 10 80 00 0F 8F D9 00 20 00 02 20 80 8F CA 00 50 03 24 28 21 8C A6 00 00 8F CB 00 24 01 44 28 21 AC A6 00 00 8F CC 00 54 01 64 28 21 8C A5 00 00 01 84 20 21 24 42 00 01 10 00 FF EF AC 85 00 00 24 0E 00 01 AF D0 00 30 10 00 02 90 AF CE 00 48 8F D9 00 48 13 20 00 20 00 00 00 00 14 40 00 1E 00 00 00 00 8F D0 00 30 8F C8 00 30 8F CA 00 C4 01 0A 10 2B 14 40 00 05 24 02 00 01 8F CB 00 2C 00 68 10 2B 01 62 78 0A 24 02 00 01 8F C8 00 38 00 48 20 2B 10 80 00 0F 8F CC 00 50 00 02 20 80 8F CD 00 20 01 84 28 21 8C A6 00 00 8F CE 00 54 01 A4 28 21 AC A6 00 00 8F D9 00 24 01 C4 28 21 8C A5 00 00 03 24 20 21 24 42 00 01 10 00 FF EF AC 85 00 00 01 E0 C0 21 14 E0 00 0A 8F CD 00 C0 8F CB 00 2C 8F CA 00 D4 8F CC 00 C4 03 0B 10 26 02 29 88 23 02 0A 80 23 01 82 88 0A 10 00 06 86 02 11 10 23 8D A2 00 1C 7C 44 06 C0 14 80 FF F5 8F CB 00 2C 3C 04 60 00 00 44 10 24 14 40 00 22 3C 04 20 00 8F CE 00 4C 8F 99 ?? ?? 25 D3 00 02 AC F3 00 00 00 13 98 80 AF C3 00 88 AF C9 00 8C AF D8 00 84 02 60 20 21 ?? ?? ?? ?? AF C7 00 90 8F DC 00 10 8F C7 00 90 02 60 20 21 8F 99 ?? ?? AC E2 00 04 AF C7 00 90 ?? ?? ?? ?? 00 40 90 21 8F C7 00 90 8F DC 00 10 AC E2 00 08 8F C3 00 88 8F C9 00 8C 12 40 06 63 8F D8 00 84 10 40 06 61 8F D9 00 C0 24 04 00 01 93 22 00 1C 7C 82 31 44 10 00 00 24 A3 22 00 1C 14 44 00 23 8C E2 00 00 8F C8 00 4C 25 05 00 02 00 45 10 2B 50 40 00 1E 8C E2 00 00 8C E4 00 04 8F 99 ?? ?? AC E5 00 00 AF C3 00 88 AF C9 00 8C AF D8 00 84 00 05 28 80 ?? ?? ?? ?? AF C7 00 90 8F C7 00 90 8F DC 00 10 8C E5 00 00 8C E4 00 08 8F 99 ?? ?? AC E2 00 04 00 05 28 80 ?? ?? ?? ?? AF C7 00 90 8F C7 00 90 8F DC 00 10 8C E4 00 04 AC E2 00 08 8F C3 00 88 8F C9 00 8C 10 80 06 3B 8F D8 00 84 10 40 06 3A 24 02 FF FE 8C E2 00 00 10 40 00 0E 8F 86 ?? ?? 8C E2 00 04 8F CA 00 D4 8F CB 00 2C AC 4A 00 00 17 0B 00 04 8C E4 00 08 8F CC 00 C4 10 00 00 03 02 0C 10 23 02 11 10 23 00 49 10 21 AC 82 00 00 8F 86 ?? ?? 24 05 00 01 24 0A FF FF 24 C6 ?? ?? 8C E2 00 00 8F CB 00 38 00 4B 20 2B 01 64 10 0A 00 A2 10 2B 10 40 00 30 8F CD 00 20 00 05 10 80 8C EC 00 04 01 A2 20 21 8C 84 00 00 10 86 00 06 01 82 60 21 8F CE 00 24 01 C2 58 21 8D 6D 00 00 15 A6 00 06 00 00 00 00 8C E4 00 08 00 82 10 21 AC 4A 00 00 10 00 00 1E AD 8A 00 00 51 20 00 0A 00 91 20 23 8F D9 00 C4 00 99 68 2B 55 A0 00 06 00 91 20 23 00 64 68 2B 55 A0 00 03 00 91 20 23 10 00 00 02 00 99 20 23 00 89 20 21 AD 84 00 00 8C E4 00 08 00 82 10 21 11 20 00 0A 8D 64 00 00 8F C8 00 C4 00 88 58 2B 55 60 00 07 00 91 20 23 00 64 58 2B 55 60 00 04 00 91 20 23 10 00 00 03 00 88 20 23 00 91 20 23 00 89 20 21 AC 44 00 00 10 00 FF CB 24 A5 00 01 01 60 10 21 24 03 FF FF 8C E4 00 00 00 44 20 2B 10 80 FF 5D 00 02 20 80 8C E5 00 04 8C E6 00 08 00 A4 28 21 00 C4 20 21 AC 83 00 00 24 42 00 01 10 00 FF F5 AC A3 00 00 2C C2 00 1E 10 40 05 89 25 93 00 01 8F 8D ?? ?? 00 06 10 80 25 AD ?? ?? 01 A2 10 21 8C 42 00 00 00 5C 10 21 00 40 00 08 00 00 00 00 24 0A 00 01 10 00 FE F1 02 60 60 21 8F CE 00 28 25 84 00 02 11 C0 00 17 91 82 00 01 56 18 00 05 92 06 00 00 13 0F 01 AA 02 20 28 21 10 00 00 0B 01 E0 C0 21 8F D9 00 28 24 93 00 01 90 84 00 00 03 26 30 21 90 C6 00 00 14 C4 01 A0 26 05 00 01 24 42 FF FF 10 40 00 10 02 60 20 21 10 00 FF EF 00 A0 80 21 13 0F 01 9A 02 20 28 21 01 E0 C0 21 00 A0 80 21 12 18 FF FB 24 93 00 01 82 06 00 00 80 84 00 00 14 C4 01 91 26 05 00 01 24 42 FF FF 14 40 FF F7 02 60 20 21 15 40 FF DA 00 A0 80 21 02 A0 10 21 24 04 00 01 02 C2 28 2B 14 A0 FF D4 00 02 28 80 01 05 28 21 90 A6 00 00 24 42 00 01 7C 86 18 C4 7C 86 21 04 10 00 FF F7 A0 A6 00 00 12 0F 01 80 02 00 20 21 01 E0 C0 21 02 20 80 21 12 18 FF FB 8F CB 00 C0 8D 62 00 0C 30 44 00 40 54 80 00 0A 30 42 00 80 8F CC 00 28 51 80 00 04 82 05 00 00 92 04 00 00 01 84 20 21 80 85 00 00 24 04 00 0A 10 A4 01 6E 30 42 00 80 10 40 00 08 8F CD 00 28 51 A0 00 04 82 02 00 00 92 02 00 00 01 A2 10 21 80 42 00 00 10 40 01 66 02 00 20 21 55 40 FF B0 26 10 00 01 02 A0 10 21 24 04 00 01 02 C2 28 2B 14 A0 05 27 00 02 28 80 01 05 28 21 90 A6 00 00 24 42 00 01 7C 86 18 C4 7C 86 21 04 10 00 FF F7 A0 A6 00 00 38 C6 00 05 2C C6 00 01 7C 06 24 20 16 18 00 06 8F CE 00 28 52 0F 01 51 02 00 20 21 01 E0 C0 21 10 00 FF FA 02 20 80 21 11 C0 00 03 92 02 00 00 01 C2 10 21 90 42 00 00 91 85 00 01 00 05 58 C0 00 4B 58 2B 11 60 00 08 00 02 58 C2 02 6B 58 21 91 6B 00 01 30 42 00 07 38 C6 00 01 00 4B 10 07 30 42 00 01 00 C2 20 0B 10 80 01 3C 02 00 20 21 55 40 00 0F 24 A5 00 01 02 A0 10 21 24 04 00 01 02 C2 30 2B 14 C0 00 08 00 02 30 80 01 06 30 21 90 CA 00 00 24 42 00 01 7C 8A 18 C4 7C 8A 21 04 10 00 FF F7 A0 CA 00 00 24 0A 00 01 24 A5 00 01 10 00 04 F3 02 65 98 21 AF D3 00 18 91 93 00 01 3C 02 C0 00 00 13 98 80 01 13 98 21 8E 64 00 00 00 44 20 24 54 82 00 1A 91 82 00 01 8F 99 ?? ?? 8F C5 00 34 27 C4 00 18 01 00 30 21 AF C3 00 88 AF C7 00 90 AF C8 00 80 AF C9 00 8C AF CC 00 7C AF CF 00 78 27 39 ?? ?? ?? ?? ?? ?? AF D8 00 84 92 64 00 00 8F DC 00 10 7C 44 39 84 A2 64 00 00 8F D8 00 84 8F CF 00 78 8F CC 00 7C 8F C9 00 8C 8F C8 00 80 8F C7 00 90 8F C3 00 88 91 82 00 01 8F D9 00 40 8F CA 00 20 00 02 10 80 01 02 28 21 8C A5 00 00 3C 06 C0 00 03 22 20 21 00 C5 28 24 10 A0 00 08 01 42 10 21 8C 45 00 00 8F 82 ?? ?? 24 42 ?? ?? 00 A2 10 26 02 02 28 0A 10 00 00 02 00 A0 10 21 8C 42 00 00 AC 82 00 00 91 82 00 01 8F CB 00 20 24 05 00 01 00 02 10 80 01 62 10 21 AC 50 00 00 91 82 00 01 25 93 00 03 AF D3 00 58 00 02 10 80 01 02 10 21 90 44 00 00 7C A4 29 44 A0 44 00 00 91 82 00 01 00 02 10 80 01 02 10 21 90 44 00 00 7C 04 21 04 A0 44 00 00 91 96 00 01 3A A2 01 01 10 00 00 E3 02 C2 A8 0A 91 82 00 01 8F CD 00 44 8F CE 00 24 00 02 10 80 01 02 28 21 8C A5 00 00 3C 06 C0 00 01 A2 20 21 00 C5 28 24 10 A0 00 08 01 C2 10 21 8C 45 00 00 8F 82 ?? ?? 24 42 ?? ?? 00 A2 10 26 02 02 28 0A 10 00 00 02 00 A0 10 21 8C 42 00 00 AC 82 00 00 91 82 00 01 8F D9 00 24 00 02 10 80 03 22 10 21 AC 50 00 00 91 82 00 01 00 02 10 80 01 02 10 21 90 44 00 00 7C 04 29 44 12 B6 00 0F A0 44 00 00 91 82 00 01 3C 05 20 00 24 42 FF FF 30 42 00 FF 10 40 00 09 00 02 20 80 01 04 20 21 8C 84 00 00 00 A4 20 24 14 80 00 06 00 40 B0 21 24 42 FF FF 10 00 FF F7 30 42 00 FF 24 16 01 00 24 15 01 01 91 82 00 01 00 02 10 80 01 02 10 21 8C 42 00 00 7C 42 07 00 10 40 00 05 8F CB 00 34 8F CA 00 58 15 4C 00 A9 25 93 00 03 8F CB 00 34 25 82 00 03 00 4B 10 2B 10 40 00 A4 25 93 00 03 25 82 00 04 AF C2 00 18 91 82 00 03 2C 44 00 14 10 80 00 08 24 04 00 16 2C 44 00 11 10 80 00 09 24 04 00 0D 10 44 00 08 00 00 28 21 10 00 00 0E 00 00 20 21 10 44 00 04 24 05 00 01 10 00 00 0A 00 00 20 21 00 00 28 21 81 84 00 05 91 82 00 04 00 04 22 00 00 44 20 21 10 A0 00 02 25 82 00 06 25 82 00 08 AF C2 00 18 8F C2 00 18 00 44 10 21 04 81 00 85 AF C2 00 18 90 45 00 00 24 04 00 0F 14 A4 00 82 25 93 00 03 90 45 00 03 24 04 00 06 14 A4 FE C4 00 00 50 21 91 84 00 01 90 42 00 04 14 44 FE C0 00 02 10 80 01 02 10 21 8C 44 00 00 7C 84 06 C0 54 80 00 12 90 44 00 00 8F C2 00 18 26 CA 00 01 01 55 50 23 24 44 00 01 AF C4 00 18 90 44 00 01 80 53 00 02 24 42 00 03 AF C2 00 18 24 02 00 03 71 42 50 02 00 13 9A 00 00 93 98 21 8F 8B ?? ?? 24 0C 00 13 10 00 00 3B 25 4A 00 04 7C 04 18 C4 A0 44 00 00 91 82 00 01 91 85 00 02 91 84 00 01 00 A4 20 21 00 44 20 2B 10 80 FF E7 00 02 20 80 8F CA 00 40 8F CB 00 20 01 44 28 21 8C A6 00 00 8F CD 00 44 01 64 28 21 AC A6 00 00 01 A4 28 21 8C A5 00 00 00 A6 30 2B 14 C0 FF EF 24 42 00 01 8F CE 00 24 01 C4 20 21 10 00 FF EB AC 85 00 00 71 82 10 02 00 57 10 2B 14 40 04 62 00 17 10 C0 8F 99 ?? ?? 24 42 00 08 03 A2 E8 23 02 80 28 21 AF C3 00 88 AF C7 00 90 AF C8 00 80 AF C9 00 8C AF CA 00 70 AF CB 00 74 AF CC 00 7C AF CF 00 78 AF D8 00 84 27 A4 00 10 ?? ?? ?? ?? 00 17 30 80 00 40 A0 21 8F DC 00 10 8F C3 00 88 8F C7 00 90 8F C8 00 80 8F C9 00 8C 8F CA 00 70 8F CB 00 74 8F CC 00 7C 8F CF 00 78 10 40 04 46 8F D8 00 84 00 17 B8 40 02 F2 10 23 00 4A 10 2B 54 40 FF DC 8D 62 00 00 02 A0 20 21 02 C4 28 2B 14 A0 00 11 00 12 10 80 8F CA 00 20 00 04 28 80 8F CB 00 24 01 45 30 21 8C C6 00 00 02 82 10 21 26 52 00 03 AC 46 00 00 01 65 30 21 8C C6 00 00 01 05 28 21 24 84 00 01 AC 46 00 04 8C A5 00 00 10 00 FF EE AC 45 00 08 02 82 10 21 AC 55 00 00 AC 56 00 04 8F C4 00 18 26 52 00 04 AC 50 00 0C 00 93 98 21 10 00 00 02 AC 53 00 08 00 A0 80 21 02 00 20 21 24 06 00 0F 24 0A 00 15 24 0B 00 16 10 00 03 CD 24 0C 00 0D 25 93 00 03 10 00 FE 45 00 00 50 21 91 8E 00 01 25 93 00 02 8F CC 00 20 00 0E 70 80 01 8E 10 21 8C 4B 00 00 8F 82 ?? ?? 24 42 ?? ?? 11 62 FF EE 8F CD 00 24 01 AE 70 21 8D CC 00 00 11 82 FF EA AF CE 00 64 11 20 00 07 00 00 10 21 8F CE 00 C4 01 6E 20 2B 14 80 00 04 38 44 00 01 00 6B 10 2B 38 42 00 01 38 44 00 01 11 20 00 07 00 00 10 21 8F D9 00 C4 01 99 28 2B 14 A0 00 04 8F CD 00 2C 00 6C 10 2B 38 42 00 01 8F CD 00 2C 00 82 10 26 01 A2 60 0A 15 6C 00 0C 00 00 00 00 11 6F FE 1F 8F CE 00 64 8D CC 00 00 11 6C FE 1C 02 20 58 21 10 00 FF F8 00 00 00 00 12 0F FF CC 02 00 20 21 01 E0 C0 21 02 20 80 21 12 18 FF FB 8F D9 00 28 03 10 68 23 01 8B 10 23 00 4D 20 2A 13 20 00 15 00 44 68 0B 01 60 28 21 02 00 20 21 01 A0 10 21 10 40 00 2B 8F C6 00 28 24 99 00 01 24 AE 00 01 90 84 00 00 90 A5 00 00 00 C4 20 21 00 C5 28 21 80 84 00 00 80 A5 00 00 14 85 00 04 01 C0 28 21 24 42 FF FF 10 00 FF F2 03 20 20 21 10 00 00 1C 24 02 00 01 8F 99 ?? ?? 01 60 28 21 01 A0 30 21 AF C3 00 88 AF C7 00 90 AF C8 00 80 AF C9 00 8C AF CA 00 70 AF CB 00 74 AF CC 00 7C AF CD 00 6C AF CF 00 78 AF D8 00 84 ?? ?? ?? ?? 02 00 20 21 8F DC 00 10 8F D8 00 84 8F CF 00 78 8F CD 00 6C 8F CC 00 7C 8F CB 00 74 8F CA 00 70 8F C9 00 8C 8F C8 00 80 8F C7 00 90 8F C3 00 88 00 02 10 2B 54 40 FF 92 02 00 20 21 02 0D 80 21 15 40 FF B9 01 6D 58 21 02 A0 10 21 02 C2 20 2B 14 80 00 09 00 02 20 80 01 04 20 21 90 85 00 00 24 06 00 01 24 42 00 01 7C C5 18 C4 7C C5 21 04 10 00 FF F6 A0 85 00 00 10 00 FF AB 24 0A 00 01 8F C2 00 C4 02 29 10 0A 12 02 00 03 8F CB 00 D0 55 60 00 05 82 04 FF FF 8F CC 00 C0 8D 82 00 1C 10 00 00 0C 7C 42 06 80 24 02 00 0A 14 82 FF 74 02 00 20 21 8F CD 00 C0 10 00 00 13 8D A2 00 1C 8F CE 00 3C 16 0E 00 07 8F D9 00 C0 8F 22 00 1C 7C 42 06 40 50 40 FC A8 02 60 60 21 10 00 FF 68 02 00 20 21 56 03 00 02 82 02 00 00 82 22 00 00 38 42 00 0A 2C 42 00 01 10 40 FF 61 }
	condition:
		$1
}

rule file_430_7_0 {
	meta:
		name = "byte_regex_compile"
		size = 9560
		refs = "0000 _gp_disp 0040 malloc 00a4 __GI_memset 00c8 __GI___ctype_b 0124 realloc 0158 free 0768 byte_insert_op1 0b60 byte_compile_range 0d88 __GI_strcmp 0d8c $LC0 0db4 $LC1 0dd4 __GI_wctype 0e2c __GI_btowc 0e58 __GI_iswctype"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FE 70 AF BC 00 18 AF B7 01 84 AF B2 01 70 AF B1 01 6C AF BF 01 8C AF BE 01 88 AF B6 01 80 AF B5 01 7C AF B4 01 78 AF B3 01 74 AF B0 01 68 8C E3 00 14 8F 99 ?? ?? AF A4 01 90 AF A4 01 24 AF A3 01 28 24 04 02 80 00 A0 90 21 00 C0 88 21 ?? ?? ?? ?? 00 E0 B8 21 AF A2 01 2C 10 40 00 3E 8F BC 00 18 92 E2 00 1C AE F1 00 0C AE E0 00 08 7C 02 21 04 7C 02 08 44 7C 02 10 84 A2 E2 00 1C 8F 82 ?? ?? AE E0 00 18 8C 43 ?? ?? 14 60 00 1D 00 40 A8 21 8F 90 ?? ?? 8F 99 ?? ?? 00 00 28 21 26 10 ?? ?? 02 00 20 21 ?? ?? ?? ?? 24 06 01 00 8F BC 00 18 00 00 10 21 24 05 00 01 8F 84 ?? ?? 24 03 01 00 8C 87 00 00 00 02 30 40 00 E6 30 21 94 C6 00 00 30 C6 08 00 50 C0 00 04 24 42 00 01 02 02 30 21 A0 C5 00 00 24 42 00 01 54 43 FF F6 8C 87 00 00 24 02 00 01 A2 02 00 5F 24 02 00 01 AE A2 ?? ?? 8E E2 00 04 14 40 00 17 8F A8 01 90 8E E4 00 00 10 80 00 05 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 20 10 00 00 05 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 24 04 00 20 8F BC 00 18 AE E2 00 00 8E E2 00 00 54 40 00 06 24 02 00 20 8F 99 ?? ?? ?? ?? ?? ?? 8F A4 01 2C 10 00 08 F0 24 02 00 0C AE E2 00 04 8F A8 01 90 8E F6 00 00 24 19 00 20 01 12 90 21 02 C0 80 21 AF A0 01 30 AF B9 01 38 AF A0 01 34 00 00 A8 21 00 00 98 21 00 00 A0 21 8F A2 01 24 10 52 08 AD 8F A3 01 28 24 44 00 01 AF A4 01 24 10 60 00 03 90 5E 00 00 00 7E F0 21 93 DE 00 00 24 05 00 2E 13 C5 01 94 2F C5 00 2F 10 A0 00 15 24 05 00 28 13 C5 04 01 2F C5 00 29 50 A0 00 08 24 02 00 2A 24 05 00 0A 13 C5 04 0E 24 05 00 24 13 C5 00 5F 00 00 00 00 10 00 08 10 00 00 00 00 13 C2 00 A9 2F C2 00 2A 14 40 04 02 32 22 20 00 24 02 00 2B 13 C2 00 A2 32 22 04 02 10 00 08 07 00 00 00 00 24 05 00 5C 13 C5 04 12 2F C5 00 5D 50 A0 00 08 24 05 00 7B 24 02 00 3F 13 C2 00 97 24 02 00 5B 13 C2 01 98 00 00 00 00 10 00 07 FB 00 00 00 00 13 C5 03 FD 24 05 00 7C 13 C5 03 F6 24 05 00 5E 17 C5 07 F5 8F A8 01 90 25 05 00 01 10 85 00 1A 32 24 00 08 14 80 00 19 3C 06 00 01 24 45 FF FF 01 05 28 2B 50 A0 00 05 80 42 FF FF 80 44 FF FE 38 84 00 5C 2C 84 00 01 80 42 FF FF 24 05 00 28 14 45 00 03 7C 04 24 20 10 00 00 05 32 22 20 00 24 05 00 7C 14 45 07 E0 24 1E 00 5E 32 22 80 00 14 40 00 05 00 04 10 2B 14 40 00 04 3C 06 00 01 10 00 07 D9 24 1E 00 5E 3C 06 00 01 24 C7 00 01 8E FE 00 00 8E E5 00 04 02 DE 10 23 24 42 00 01 00 A2 10 2B 50 40 00 65 24 02 00 09 54 A6 00 03 00 05 28 40 10 00 08 87 24 02 00 0F 00 A7 10 2B 8F 99 ?? ?? 00 C2 28 0A AF A6 01 58 AF A7 01 5C AE E5 00 04 ?? ?? ?? ?? 03 C0 20 21 AE E2 00 00 8F BC 00 18 8F A6 01 58 10 40 FF 89 8F A7 01 5C 13 C2 FF E7 00 5E 10 23 02 A2 20 21 02 C2 B0 21 02 02 80 21 00 95 A8 0B 02 62 20 21 02 82 10 21 00 93 98 0B 10 00 FF DE 00 54 A0 0B 10 92 00 24 32 24 00 08 54 80 00 23 3C 06 00 01 80 44 00 01 24 42 00 02 00 52 28 2B 38 86 00 5C 00 05 10 0A 32 25 20 00 10 A0 00 06 2C C6 00 01 24 05 00 29 14 85 00 0C 32 25 80 00 10 00 00 16 3C 06 00 01 10 C0 00 06 00 00 28 21 10 40 00 04 00 00 00 00 80 45 00 00 38 A5 00 29 2C A5 00 01 14 A0 00 0C 32 25 80 00 54 A0 00 07 38 84 00 7C 10 C0 00 06 00 00 20 21 10 40 00 04 00 00 00 00 80 44 00 00 38 84 00 7C 2C 84 00 01 10 80 07 8F 24 1E 00 24 3C 06 00 01 24 C7 00 01 8E FE 00 00 8E E5 00 04 02 DE 10 23 24 42 00 01 00 A2 10 2B 50 40 00 1B 24 02 00 0A 10 A6 FF B7 8F 99 ?? ?? 00 05 28 40 00 A7 10 2B 00 C2 28 0A AF A6 01 58 AF A7 01 5C AE E5 00 04 ?? ?? ?? ?? 03 C0 20 21 AE E2 00 00 8F BC 00 18 8F A6 01 58 10 40 FF 41 8F A7 01 5C 13 C2 FF E9 00 5E 10 23 02 A2 20 21 02 C2 B0 21 02 02 80 21 00 95 A8 0B 02 62 20 21 02 82 10 21 00 93 98 0B 10 00 FF E0 00 54 A0 0B A2 C2 00 00 10 00 FF 41 26 D6 00 01 32 22 04 02 14 40 07 66 00 00 00 00 16 60 00 07 00 00 28 21 32 22 00 20 14 40 05 2A 8F 99 ?? ?? 32 22 00 10 10 40 07 5E 00 00 00 00 00 00 60 21 24 0D 00 2A 32 2E 00 02 24 0F 00 5C 24 07 00 2B 24 06 00 3F 3B C2 00 2B 00 02 10 2B 01 82 60 25 8F A2 01 24 3B DE 00 3F 00 1E F0 2B 10 52 00 1E 00 BE 28 25 8F B9 01 28 24 58 00 01 AF B8 01 24 13 20 00 03 90 44 00 00 03 24 20 21 90 84 00 00 10 8D FF F0 24 1E 00 2A 15 C0 00 07 00 00 00 00 10 87 FF EC 24 1E 00 2B 14 86 00 0E 24 1E 00 3F 10 00 FF E9 3B C2 00 2B 54 8F 00 0B AF A2 01 24 13 12 03 4B 8F A3 01 28 24 44 00 02 AF A4 01 24 10 60 FF F3 90 44 00 01 00 64 20 21 10 00 FF F0 90 84 00 00 AF A2 01 24 12 60 FF 0A 8F A2 01 24 10 A0 00 50 00 00 A0 21 3C 14 00 01 26 87 00 01 8E FE 00 00 8E E5 00 04 02 DE 10 23 24 42 00 03 00 A2 10 2B 10 40 00 19 8F A8 01 28 10 B4 FF 57 8F 99 ?? ?? 00 05 28 40 00 A7 10 2B 02 82 28 0A AF A7 01 5C AF AC 01 54 AE E5 00 04 ?? ?? ?? ?? 03 C0 20 21 AE E2 00 00 8F BC 00 18 8F A7 01 5C 10 40 FE E1 8F AC 01 54 13 C2 FF E9 00 5E F0 23 02 BE 10 21 02 DE B0 21 02 1E 80 21 02 7E F0 21 00 55 A8 0B 10 00 FF E2 03 D3 98 0B 11 00 00 06 8F A2 01 24 90 44 FF FE 01 04 20 21 80 85 00 00 10 00 00 03 81 04 00 2E 80 45 FF FE 24 04 00 2E 54 A4 00 1C 02 76 10 23 51 80 00 1A 02 76 10 23 00 52 20 2B 50 80 00 17 02 76 10 23 8F B9 01 28 53 20 00 06 80 44 00 00 90 42 00 00 03 22 10 21 80 44 00 00 10 00 00 02 83 22 00 0A 24 02 00 0A 14 82 00 0C 02 76 10 23 32 22 00 40 14 40 00 09 02 76 10 23 24 42 FF FD 24 04 00 0D A2 C2 00 01 00 02 12 03 A2 C4 00 00 A2 C2 00 02 10 00 00 08 24 14 00 01 24 42 FF FA 24 04 00 12 A2 C2 00 01 00 02 12 03 A2 C4 00 00 A2 C2 00 02 00 00 A0 21 26 D6 00 03 3C 07 00 01 02 C0 F0 21 24 EB 00 01 8E F6 00 00 8E E5 00 04 03 D6 10 23 24 42 00 03 00 A2 10 2B 50 40 00 1B 24 02 00 10 10 A7 FF 07 8F 99 ?? ?? 00 05 28 40 00 AB 10 2B 00 E2 28 0A AF A7 01 5C AF AB 01 48 AF AC 01 54 AE E5 00 04 ?? ?? ?? ?? 02 C0 20 21 AE E2 00 00 8F BC 00 18 8F A7 01 5C 8F AB 01 48 10 40 FE 8F 8F AC 01 54 12 C2 FF E7 00 56 18 23 02 A3 10 21 03 C3 F0 21 02 03 80 21 02 63 18 21 00 55 A8 0B 10 00 FF E0 00 73 98 0B 24 04 00 0F 00 54 20 0B 8F 82 ?? ?? 02 60 28 21 03 D3 30 23 24 59 ?? ?? ?? ?? ?? ?? 03 C0 38 21 27 D6 00 03 15 80 FE 88 8F BC 00 18 3C 1E 00 01 27 CB 00 01 8E F4 00 00 8E E5 00 04 02 D4 10 23 24 42 00 03 00 A2 10 2B 10 40 00 17 8F 99 ?? ?? 10 BE FE D9 8F 99 ?? ?? 00 05 28 40 00 AB 10 2B 03 C2 28 0A AF AB 01 48 AE E5 00 04 ?? ?? ?? ?? 02 80 20 21 AE E2 00 00 8F BC 00 18 10 40 FE 65 8F AB 01 48 12 82 FF EB 00 54 30 23 02 A6 10 21 02 C6 B0 21 02 06 80 21 02 66 30 21 00 55 A8 0B 10 00 FF E4 00 D3 98 0B 24 04 00 13 02 60 28 21 24 06 00 03 27 39 ?? ?? ?? ?? ?? ?? 02 C0 38 21 10 00 03 A7 8F BC 00 18 3C 06 00 01 02 C0 98 21 24 C7 00 01 8E FE 00 00 8E E5 00 04 02 DE 10 23 24 42 00 01 00 A2 10 2B 50 40 FF 15 24 02 00 03 10 A6 FE B1 8F 99 ?? ?? 00 05 28 40 00 A7 10 2B 00 C2 28 0A AF A6 01 58 AF A7 01 5C AE E5 00 04 ?? ?? ?? ?? 03 C0 20 21 AE E2 00 00 8F BC 00 18 8F A6 01 58 10 40 FE 3B 8F A7 01 5C 13 C2 FF E9 00 5E 10 23 02 A2 20 21 02 C2 B0 21 02 02 80 21 00 95 A8 0B 02 62 20 21 02 82 10 21 00 93 98 0B 10 00 FF E0 00 54 A0 0B 10 92 00 B6 3C 13 00 01 26 67 00 01 8E FE 00 00 8E E5 00 04 02 DE 10 23 24 42 00 22 00 A2 10 2B 10 40 00 17 3C 06 00 01 10 B3 FE 8D 8F 99 ?? ?? 00 05 28 40 00 A7 10 2B 02 62 28 0A AF A7 01 5C AE E5 00 04 ?? ?? ?? ?? 03 C0 20 21 AE E2 00 00 8F BC 00 18 10 40 FE 19 8F A7 01 5C 13 C2 FF EB 00 5E F0 23 02 BE 10 21 02 DE B0 21 02 1E 80 21 02 9E F0 21 00 55 A8 0B 10 00 FF E4 03 D4 A0 0B 02 C0 98 21 24 C7 00 01 8E FE 00 00 8E E5 00 04 02 DE 10 23 24 42 00 01 00 A2 10 2B 50 40 00 1B 8F A2 01 24 10 A6 FE 6E 8F 99 ?? ?? 00 05 28 40 00 A7 10 2B 00 C2 28 0A AF A6 01 58 AF A7 01 5C AE E5 00 04 ?? ?? ?? ?? 03 C0 20 21 AE E2 00 00 8F BC 00 18 8F A6 01 58 10 40 FD F8 8F A7 01 5C 13 C2 FF E9 00 5E 10 23 02 A2 20 21 02 C2 B0 21 02 02 80 21 00 95 A8 0B 02 62 20 21 02 82 10 21 00 93 98 0B 10 00 FF E0 00 54 A0 0B 24 04 00 04 24 03 00 5E 80 45 00 00 24 02 00 05 38 A5 00 5E 00 85 10 0B A2 C2 00 00 8F A2 01 24 80 44 00 00 14 83 00 03 26 CC 00 01 24 42 00 01 AF A2 01 24 8F A3 01 24 3C 16 00 01 26 C6 00 01 AF A3 01 3C 8E FE 00 00 8E E5 00 04 01 9E 10 23 24 42 00 01 00 A2 10 2B 10 40 00 1B 8F 99 ?? ?? 10 B6 FE 3C 8F 99 ?? ?? 00 05 28 40 00 A6 10 2B 02 C2 28 0A AF A6 01 58 AF AC 01 54 AE E5 00 04 ?? ?? ?? ?? 03 C0 20 21 AE E2 00 00 8F BC 00 18 8F A6 01 58 10 40 FD C6 8F AC 01 54 13 C2 FF E9 00 5E 10 23 02 A2 20 21 01 82 60 21 02 02 80 21 00 95 A8 0B 02 62 20 21 02 82 10 21 00 93 98 0B 10 00 FF E0 00 54 A0 0B 25 96 00 01 24 02 00 20 A1 82 00 00 02 C0 20 21 AF AC 01 54 00 00 28 21 ?? ?? ?? ?? 24 06 00 20 8F AC 01 54 24 02 00 05 91 83 FF FF 14 62 00 07 8F BC 00 18 32 22 01 00 50 40 00 3F 24 06 FF FF 91 82 00 02 34 42 00 04 A1 82 00 02 10 00 00 3A 24 06 FF FF 24 44 00 01 AF A4 01 24 11 00 00 03 90 43 00 00 01 03 18 21 90 63 00 00 32 25 00 01 14 A0 00 33 24 05 00 5C 24 05 00 5D 10 65 00 43 8F A8 01 3C 80 45 00 01 15 C0 00 45 24 07 00 2D 14 67 00 5A 8F B9 01 90 24 47 FF FF 00 F9 38 2B 50 E0 00 49 80 4F FF FF 8F A8 01 90 24 47 FF FE 00 E8 38 2B 50 E0 00 49 80 4F FF FE 24 07 00 5D 10 A7 00 4D 8F A7 01 28 8F 82 ?? ?? 00 C0 20 21 AF B1 00 10 AF B6 00 14 27 A5 01 24 02 40 30 21 24 59 ?? ?? ?? ?? ?? ?? 00 00 00 00 00 40 F0 21 14 40 00 54 8F BC 00 18 24 06 FF FF 8F A2 01 24 14 52 FF D4 8F A8 01 28 8F 99 ?? ?? ?? ?? ?? ?? 8F A4 01 2C 10 00 06 65 24 02 00 07 91 82 00 0C 24 06 00 3A 34 42 00 08 A1 82 00 0C 91 82 00 08 34 42 00 04 A1 82 00 08 10 00 FF F0 00 00 70 21 54 65 FF CE 24 05 00 5D 10 92 01 AD 8F B9 01 28 24 43 00 02 AF A3 01 24 13 20 00 03 90 46 00 01 03 26 30 21 90 C6 00 00 00 06 10 C2 02 C2 10 21 24 04 00 01 30 C3 00 07 00 64 18 04 90 44 00 00 00 64 18 25 10 00 FF DD A0 43 00 00 25 05 00 01 50 85 FF BD 80 45 00 01 10 00 01 6D 91 82 00 00 14 67 00 16 24 07 00 2D 24 07 00 5D 10 A7 FF BA 8F B9 01 90 8F 99 ?? ?? ?? ?? ?? ?? 8F A4 01 2C 10 00 06 3A 24 02 00 0B 24 07 00 5B 15 E7 FF B7 8F A8 01 90 10 00 00 09 24 07 00 2D 24 07 00 5B 15 E7 FF B7 24 07 00 5D 80 4F FF FF 24 07 00 5E 15 E7 FF B3 24 07 00 5D 24 07 00 2D 14 A7 00 16 32 27 00 04 80 4F 00 02 24 07 00 5D 11 E7 00 12 32 27 00 04 10 92 06 24 00 60 20 21 8F 83 ?? ?? 24 42 00 02 AF A2 01 24 AF B1 00 10 AF B6 00 14 27 A5 01 24 02 40 30 21 8F A7 01 28 10 00 FF A9 24 79 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 8F A4 01 2C 10 00 06 16 03 C0 10 21 50 E0 01 2F 00 03 10 C2 24 07 00 5B 54 67 01 2C 00 03 10 C2 24 07 00 3A 54 A7 00 90 24 07 00 3D 10 92 06 0B 24 42 00 02 10 52 FF A1 AF A2 01 24 00 00 10 21 24 07 00 3A 27 BE 00 20 24 0E 00 5D 8F A3 01 24 10 72 06 02 8F A8 01 28 24 65 00 01 AF A5 01 24 11 00 00 03 90 64 00 00 01 04 20 21 90 84 00 00 14 87 00 04 00 00 00 00 80 6F 00 01 51 EE 00 08 03 C2 28 21 50 B2 00 06 03 C2 28 21 24 43 00 01 03 C2 10 21 A0 44 00 00 10 00 FF EC 30 62 00 FF A0 A0 00 00 24 05 00 3A 14 85 00 66 24 42 00 01 80 64 00 01 24 03 00 5D 14 83 00 63 30 42 00 FF 8F 99 ?? ?? 8F 85 ?? ?? AF A6 01 58 AF AC 01 54 03 C0 20 21 24 A5 ?? ?? ?? ?? ?? ?? AF B9 01 48 8F BC 00 18 8F B9 01 48 2C 42 00 01 8F 85 ?? ?? 03 C0 20 21 AF A2 01 40 03 20 F8 09 24 A5 ?? ?? 8F BC 00 18 2C 42 00 01 03 C0 20 21 8F 99 ?? ?? ?? ?? ?? ?? AF A2 01 44 00 40 F0 21 8F BC 00 18 8F A6 01 58 14 40 00 06 8F AC 01 54 8F 99 ?? ?? ?? ?? ?? ?? 8F A4 01 2C 10 00 05 C9 24 02 00 04 8F A2 01 24 10 52 05 C5 24 42 00 01 10 52 FF 5B AF A2 01 24 8F 8F ?? ?? 00 00 18 21 24 07 00 01 24 0E 01 00 8F 99 ?? ?? 00 60 20 21 AF A3 01 48 AF A6 01 58 AF A7 01 5C AF AC 01 54 AF AE 01 50 ?? ?? ?? ?? AF AF 01 4C 8F BC 00 18 00 40 20 21 8F 99 ?? ?? ?? ?? ?? ?? 03 C0 28 21 8F BC 00 18 8F A3 01 48 8F A6 01 58 8F A7 01 5C 8F AC 01 54 8F AE 01 50 10 40 00 08 8F AF 01 4C 7C 62 20 C0 02 C2 10 21 90 45 00 00 30 64 00 07 00 87 20 04 00 85 20 25 A0 44 00 00 8F A8 01 28 11 00 00 14 8F B9 01 44 57 20 00 05 8D E4 00 00 8F A8 01 40 51 00 00 10 24 63 00 01 8D E4 00 00 00 03 10 40 00 82 10 21 94 42 00 00 30 42 00 03 50 40 00 09 24 63 00 01 7C 62 20 C0 02 C2 10 21 90 45 00 00 30 64 00 07 00 87 20 04 00 85 20 25 A0 44 00 00 24 63 00 01 14 6E FF CC 8F 99 ?? ?? 10 00 FF 1C 24 0E 00 01 30 42 00 FF 24 43 FF FF 10 40 FF 20 30 63 00 FF 8F A2 01 24 24 42 FF FF AF A2 01 24 10 00 FF F9 00 60 10 21 54 A7 00 47 24 06 00 2E 10 92 05 7A 24 42 00 02 10 52 FF 10 AF A2 01 24 00 00 10 21 24 07 00 3D 24 0E 00 5D 8F A3 01 24 10 72 05 72 8F B9 01 28 24 65 00 01 AF A5 01 24 13 20 00 03 90 64 00 00 03 24 20 21 90 84 00 00 14 87 00 04 00 00 00 00 80 6F 00 01 51 EE 00 08 03 A2 38 21 50 B2 00 06 03 A2 38 21 54 40 00 02 A3 A0 00 20 A3 A4 00 20 10 00 FF EC 24 02 00 01 A0 E0 00 20 24 07 00 3D 54 87 00 16 24 42 00 01 80 67 00 01 24 04 00 5D 54 E4 00 12 24 42 00 01 93 A4 00 20 50 80 00 0F 24 42 00 01 10 40 00 4F 8F 99 ?? ?? 10 B2 05 51 24 63 00 02 AF A3 01 24 00 04 18 C2 02 C3 18 21 90 65 00 00 30 84 00 07 00 82 10 04 00 45 10 25 }
	condition:
		$1
}

rule file_430_8_0 {
	meta:
		name = "re_set_syntax"
		size = 28
		refs = "0000 _gp_disp 000c re_syntax_options"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 83 ?? ?? 8C 62 00 00 03 E0 00 08 AC 64 00 00 }
	condition:
		$1
}

rule file_75_4_3 {
	meta:
		name = "_ZSt13set_terminatePFvvE"
		size = 28
		refs = "0000 _gp_disp 000c _ZN10__cxxabiv119__terminate_handlerE"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 83 ?? ?? 8C 62 00 00 03 E0 00 08 AC 64 00 00 }
	condition:
		$1
}

rule file_75_5_3 {
	meta:
		name = "_ZSt14set_unexpectedPFvvE"
		size = 28
		refs = "0000 _gp_disp 000c _ZN10__cxxabiv120__unexpected_handlerE"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 83 ?? ?? 8C 62 00 00 03 E0 00 08 AC 64 00 00 }
	condition:
		$1
}

rule file_127_0_3 {
	meta:
		name = "_ZSt15set_new_handlerPFvvE"
		size = 28
		refs = "0000 _gp_disp 000c __new_handler"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 83 ?? ?? 8C 62 00 00 03 E0 00 08 AC 64 00 00 }
	condition:
		$1
}

rule file_430_9_0 {
	meta:
		name = "__GI_re_compile_fastmap"
		size = 28
		refs = "0000 _gp_disp 0014 byte_re_compile_fastmap"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_73_6_3 {
	meta:
		name = "_ZSt18_Rb_tree_decrementPKSt18_Rb_tree_node_base"
		size = 28
		refs = "0000 _gp_disp 0014 _ZStL23local_Rb_tree_decrementPSt18_Rb_tree_node_base"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_73_5_3 {
	meta:
		name = "_ZSt18_Rb_tree_decrementPSt18_Rb_tree_node_base"
		size = 28
		refs = "0000 _gp_disp 0014 _ZStL23local_Rb_tree_decrementPSt18_Rb_tree_node_base"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_73_7_3 {
	meta:
		name = "_ZSt20_Rb_tree_rotate_leftPSt18_Rb_tree_node_baseRS0_"
		size = 28
		refs = "0000 _gp_disp 0014 _ZStL25local_Rb_tree_rotate_leftPSt18_Rb_tree_node_baseRS0_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_73_8_3 {
	meta:
		name = "_ZSt21_Rb_tree_rotate_rightPSt18_Rb_tree_node_baseRS0_"
		size = 28
		refs = "0000 _gp_disp 0014 _ZStL26local_Rb_tree_rotate_rightPSt18_Rb_tree_node_baseRS0_"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_754_1_0 {
	meta:
		name = "__GI_setenv"
		size = 28
		refs = "0000 _gp_disp 0014 __add_to_environ"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_813_7_0 {
	meta:
		name = "__ivaliduser"
		size = 28
		refs = "0000 _gp_disp 0014 __ivaliduser2.isra.1"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_18_15_2 {
	meta:
		name = "__pthread_initialize"
		size = 28
		refs = "0000 _gp_disp 0014 pthread_initialize"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_813_6_0 {
	meta:
		name = "iruserok"
		size = 28
		refs = "0000 _gp_disp 0014 iruserok2.isra.2"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_430_14_0 {
	meta:
		name = "re_match_2"
		size = 28
		refs = "0000 _gp_disp 0014 byte_re_match_2_internal"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_497_1_0 {
	meta:
		name = "waitid"
		size = 28
		refs = "0000 _gp_disp 0014 waitid5.constprop.0"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_430_10_0 {
	meta:
		name = "re_set_registers"
		size = 64
	strings:
		$1 = { 10 C0 00 09 90 82 00 1C 24 03 00 01 7C 62 31 44 A0 82 00 1C 8F A2 00 10 AC A6 00 00 AC A7 00 04 03 E0 00 08 AC A2 00 08 7C 02 31 44 A0 82 00 1C AC A0 00 00 AC A0 00 08 03 E0 00 08 AC A0 00 04 }
	condition:
		$1
}

rule file_430_11_0 {
	meta:
		name = "re_search_2"
		size = 748
		refs = "0000 _gp_disp 00ec byte_re_compile_fastmap 0284 byte_re_match_2_internal"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B0 AF B1 00 2C AF B0 00 28 8F A2 00 60 8F B0 00 64 8F B1 00 68 AF B6 00 40 AF B3 00 34 AF B2 00 30 AF BC 00 20 AF BF 00 4C AF BE 00 48 AF B7 00 44 AF B5 00 3C AF B4 00 38 00 C2 B0 21 00 80 90 21 00 C0 98 21 8C 94 00 10 8C 97 00 14 06 00 00 94 02 11 10 21 02 D0 18 2A 14 60 00 91 00 A0 F0 21 04 41 00 03 00 E0 A8 21 10 00 00 04 00 10 88 23 02 C2 10 2A 02 D0 18 23 00 62 88 0B 8E 42 00 08 10 40 00 0F 00 00 00 00 1A 20 00 0D 24 03 00 0B 8E 42 00 00 90 42 00 00 10 43 00 07 24 03 00 09 14 43 00 07 00 00 00 00 8E 42 00 1C 7C 42 06 00 14 40 00 03 00 00 00 00 1E 00 00 79 24 11 00 01 12 80 00 57 00 00 00 00 8E 42 00 1C 7C 42 07 00 14 40 00 23 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 02 40 20 21 24 03 FF FE 14 43 00 1D 8F BC 00 20 10 00 00 6E 24 02 FF FE 10 40 00 49 00 00 00 00 8E 42 00 1C 04 40 00 46 00 00 00 00 5E 20 00 18 02 13 10 2A 56 60 00 3E 02 13 10 2A 02 13 10 23 02 A2 10 21 80 42 00 00 12 E0 00 03 30 42 00 FF 02 E2 10 21 90 42 00 00 02 82 10 21 80 42 00 00 14 40 00 37 00 00 00 00 12 20 00 58 24 02 FF FF 5A 20 00 51 26 31 00 01 26 31 FF FF 26 10 00 01 16 80 FF E5 02 16 10 2A 10 00 00 2D 00 00 00 00 10 40 00 07 00 00 20 21 02 11 18 21 00 73 18 2A 14 60 00 04 02 B3 18 23 02 13 20 23 02 24 20 21 02 B3 18 23 03 C2 18 0B 00 70 18 21 12 E0 00 15 02 20 10 21 00 82 28 2A 10 A0 00 15 24 65 00 01 90 63 00 00 02 E3 18 21 90 63 00 00 02 83 18 21 80 63 00 00 54 60 00 0F 02 22 88 23 24 42 FF FF 10 00 FF F4 00 A0 18 21 90 63 00 00 02 83 18 21 80 63 00 00 54 60 00 07 02 22 88 23 24 42 FF FF 00 A0 18 21 00 82 28 2A 14 A0 FF F7 24 65 00 01 02 22 88 23 02 11 80 21 10 00 00 05 00 40 88 21 50 40 FF C3 02 13 10 23 10 00 FF C2 03 D0 10 21 06 20 00 09 8F A2 00 60 16 16 00 08 8F 99 ?? ?? 52 80 00 07 AF B0 00 14 8E 42 00 1C 04 41 00 1B 24 02 FF FF 8F A2 00 60 8F 99 ?? ?? AF B0 00 14 AF A2 00 10 8F A2 00 6C 02 40 20 21 03 C0 28 21 AF A2 00 18 8F A2 00 70 02 60 30 21 02 A0 38 21 27 39 ?? ?? ?? ?? ?? ?? AF A2 00 1C 04 41 00 0A 8F BC 00 20 24 03 FF FE 14 43 FF AF 24 02 FF FE 10 00 00 07 8F BF 00 4C 10 00 FF B1 26 10 FF FF 10 00 00 02 24 02 FF FF 02 00 10 21 8F BF 00 4C 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_430_12_0 {
	meta:
		name = "re_search"
		size = 88
		refs = "0000 _gp_disp 0014 re_search_2"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 8F A3 00 48 8F 99 ?? ?? 00 A0 10 21 AF A3 00 18 8F A3 00 4C AF BF 00 34 AF BC 00 28 AF A6 00 10 AF A7 00 14 AF A3 00 1C AF A6 00 20 00 00 28 21 00 00 30 21 ?? ?? ?? ?? 00 40 38 21 8F BF 00 34 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_430_13_0 {
	meta:
		name = "re_match"
		size = 84
		refs = "0000 _gp_disp 0040 byte_re_match_2_internal"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 8F 99 ?? ?? 8F A3 00 40 00 A0 10 21 AF BF 00 2C AF BC 00 20 AF A6 00 10 AF A7 00 14 AF A3 00 18 AF A6 00 1C 00 00 28 21 00 00 30 21 27 39 ?? ?? ?? ?? ?? ?? 00 40 38 21 8F BF 00 2C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_430_15_0 {
	meta:
		name = "re_compile_pattern"
		size = 132
		refs = "0000 _gp_disp 0034 re_syntax_options 0040 byte_regex_compile"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C 90 C2 00 1C 24 03 00 01 8F 99 ?? ?? 7C 02 31 44 7C 02 18 C4 7C 62 00 04 A0 C2 00 1C 8F 82 ?? ?? 00 C0 38 21 27 39 ?? ?? ?? ?? ?? ?? 8C 46 00 00 10 40 00 0A 8F BC 00 10 8F 83 ?? ?? 00 02 10 40 24 63 ?? ?? 00 43 10 21 94 43 00 00 8F 82 ?? ?? 24 42 ?? ?? 10 00 00 02 00 43 10 21 00 00 10 21 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_430_16_0 {
	meta:
		name = "re_comp"
		size = 300
		refs = "0000 _gp_disp 003c $LC2 0050 malloc 0060 __GI_strlen 0080 re_syntax_options 0090 byte_regex_compile"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF BC 00 10 AF B1 00 1C AF B0 00 18 AF BF 00 24 AF B2 00 20 00 80 88 21 14 80 00 07 8F 90 ?? ?? 8E 03 ?? ?? 14 60 00 37 00 00 10 21 8F 82 ?? ?? 10 00 00 34 24 42 ?? ?? 8E 02 ?? ?? 10 40 00 1D 8F 99 ?? ?? 26 10 ?? ?? 92 02 00 1C 24 03 00 01 8F 99 ?? ?? 7C 62 00 04 02 20 20 21 ?? ?? ?? ?? A2 02 00 1C 8F BC 00 10 00 40 28 21 02 20 20 21 8F 82 ?? ?? 8F 99 ?? ?? 02 00 38 21 27 39 ?? ?? ?? ?? ?? ?? 8C 46 00 00 10 40 00 1D 8F BC 00 10 8F 83 ?? ?? 00 02 10 40 24 63 ?? ?? 00 43 10 21 94 43 00 00 8F 82 ?? ?? 24 42 ?? ?? 10 00 00 15 00 43 10 21 ?? ?? ?? ?? 24 04 00 C8 AE 02 ?? ?? 14 40 00 04 8F BC 00 10 8F 82 ?? ?? 10 00 00 0D 24 42 ?? ?? 8F 99 ?? ?? 26 12 ?? ?? 24 02 00 C8 AE 42 00 04 ?? ?? ?? ?? 24 04 01 00 AE 42 00 10 14 40 FF D4 8F BC 00 10 10 00 FF F4 8F 82 ?? ?? 00 00 10 21 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_430_17_0 {
	meta:
		name = "re_exec"
		size = 104
		refs = "0000 _gp_disp 000c __GI_strlen 0038 re_search"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BF 00 24 AF B0 00 20 AF BC 00 18 ?? ?? ?? ?? 00 80 80 21 8F BC 00 18 02 00 28 21 AF A2 00 10 8F 84 ?? ?? 8F 99 ?? ?? AF A0 00 14 24 84 ?? ?? 00 40 30 21 ?? ?? ?? ?? 00 00 38 21 8F BF 00 24 00 02 10 27 8F B0 00 20 00 02 17 C2 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_430_18_0 {
	meta:
		name = "regcomp"
		size = 456
		refs = "0000 _gp_disp 0050 malloc 0090 __GI___ctype_b 0094 __GI___ctype_tolower 0118 __GI_strlen 0148 byte_regex_compile 0174 byte_re_compile_fastmap 0188 free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 30 C2 00 01 AF BC 00 10 AF B3 00 28 AF B2 00 24 AF B0 00 1C AF BF 00 2C AF B1 00 20 00 80 80 21 00 A0 98 21 10 40 00 04 00 C0 90 21 3C 11 00 03 10 00 00 03 36 31 B2 FC 3C 11 01 01 26 31 02 C6 8F 99 ?? ?? AE 00 00 00 AE 00 00 04 AE 00 00 08 ?? ?? ?? ?? 24 04 01 00 AE 02 00 10 32 42 00 02 10 40 00 1C 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 24 04 01 00 AE 02 00 14 10 40 00 45 8F BC 00 10 8F 87 ?? ?? 8F 88 ?? ?? 00 00 10 21 24 05 01 00 8C E3 00 00 00 02 20 40 8E 06 00 14 00 64 18 21 94 69 00 00 00 C2 30 21 31 29 00 01 11 20 00 04 7C 02 1C 20 8D 03 00 00 00 64 20 21 80 83 00 01 24 42 00 01 14 45 FF F2 A0 C3 00 00 10 00 00 03 32 43 00 04 AE 00 00 14 32 43 00 04 10 60 00 07 92 02 00 1C 24 03 FF BF 02 23 88 24 24 03 00 01 36 31 01 00 10 00 00 02 7C 62 00 04 7C 02 00 04 A2 02 00 1C 92 02 00 1C 8F 99 ?? ?? 7E 52 00 C0 7E 42 18 C4 02 60 20 21 ?? ?? ?? ?? A2 02 00 1C 8F BC 00 10 02 60 20 21 00 40 28 21 8F 99 ?? ?? 02 20 30 21 27 39 ?? ?? ?? ?? ?? ?? 02 00 38 21 24 03 00 10 10 43 00 14 8F BC 00 10 14 40 00 14 8F BF 00 2C 8E 02 00 10 10 40 00 0B 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 02 00 20 21 24 03 FF FE 14 43 00 05 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 8E 04 00 10 AE 00 00 10 10 00 00 04 00 00 10 21 10 00 00 02 24 02 00 0C 24 02 00 08 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_430_19_0 {
	meta:
		name = "__GI_regexec"
		size = 408
		refs = "0000 _gp_disp 000c __GI_strlen 0064 __GI_memcpy 00b0 malloc 00dc re_search 0114 free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF 88 AF BC 00 18 AF BF 00 74 AF B7 00 70 AF B6 00 6C 00 80 B8 21 AF B5 00 68 00 A0 20 21 AF B4 00 64 AF B3 00 60 AF B2 00 5C AF B1 00 58 AF B0 00 54 8F B5 00 88 00 C0 80 21 00 A0 98 21 ?? ?? ?? ?? 00 E0 B0 21 8F BC 00 18 00 40 90 21 8E E2 00 1C 8F 99 ?? ?? 27 B4 00 20 7C 42 06 C0 00 10 88 2B 02 80 20 21 02 E0 28 21 24 06 00 20 ?? ?? ?? ?? 00 02 88 0B 93 A2 00 3C 24 03 00 02 8F BC 00 18 7E A2 10 84 7E B5 00 40 7E A2 08 44 7C 62 31 44 A3 A2 00 3C 12 20 00 0C 00 00 10 21 8F 99 ?? ?? AF B0 00 40 ?? ?? ?? ?? 00 10 20 C0 AF A2 00 44 10 40 00 28 8F BC 00 18 00 10 18 80 00 43 10 21 AF A2 00 48 27 A2 00 40 8F 99 ?? ?? AF B2 00 10 02 40 30 21 AF A2 00 14 02 80 20 21 02 60 28 21 ?? ?? ?? ?? 00 00 38 21 00 40 90 21 12 20 00 17 8F BC 00 18 8F A4 00 44 04 41 00 06 00 00 18 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 12 00 12 17 C2 00 70 10 2B 10 40 FF F9 00 03 28 80 00 85 30 21 8C C6 00 00 00 03 10 C0 02 C2 10 21 AC 46 00 00 8F A6 00 48 24 63 00 01 00 C5 28 21 8C A5 00 00 10 00 FF F3 AC 45 00 04 10 00 00 02 00 12 17 C2 24 02 00 01 8F BF 00 74 8F B7 00 70 8F B6 00 6C 8F B5 00 68 8F B4 00 64 8F B3 00 60 8F B2 00 5C 8F B1 00 58 8F B0 00 54 03 E0 00 08 27 BD 00 78 }
	condition:
		$1
}

rule file_430_20_0 {
	meta:
		name = "regerror"
		size = 208
		refs = "0000 _gp_disp 0030 __GI_abort 0050 __GI_strlen 0088 __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 2C 82 00 11 AF BC 00 10 AF BF 00 2C AF B2 00 28 AF B1 00 24 AF B0 00 20 14 40 00 04 8F 82 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 00 04 20 40 8F 85 ?? ?? 24 42 ?? ?? 00 82 20 21 94 82 00 00 8F 99 ?? ?? 24 A5 ?? ?? 00 A2 28 21 00 A0 20 21 AF A5 00 18 00 C0 80 21 ?? ?? ?? ?? 00 E0 90 21 24 51 00 01 8F BC 00 10 12 40 00 0E 8F A5 00 18 02 51 10 2B 10 40 00 08 8F 99 ?? ?? 26 52 FF FF 02 40 30 21 02 00 20 21 ?? ?? ?? ?? 02 12 90 21 10 00 00 04 A2 40 00 00 02 00 20 21 ?? ?? ?? ?? 02 20 30 21 8F BF 00 2C 02 20 10 21 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_430_21_0 {
	meta:
		name = "__GI_regfree"
		size = 124
		refs = "0000 _gp_disp 0020 free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BF 00 1C AF B0 00 18 AF BC 00 10 00 80 80 21 8F 99 ?? ?? ?? ?? ?? ?? 8C 84 00 00 8F BC 00 10 8E 04 00 10 AE 00 00 00 8F 99 ?? ?? AE 00 00 04 ?? ?? ?? ?? AE 00 00 08 8F BC 00 10 92 02 00 1C 8E 04 00 14 8F 99 ?? ?? 7C 02 21 04 A2 02 00 1C ?? ?? ?? ?? AE 00 00 10 8F BF 00 1C AE 00 00 14 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_431_0_0 {
	meta:
		name = "feof"
		size = 152
		refs = "0000 _gp_disp 0030 _pthread_cleanup_push_defer 0034 __pthread_mutex_unlock 004c __pthread_mutex_lock 006c _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B0 00 28 AF BC 00 10 AF BF 00 34 AF B2 00 30 AF B1 00 2C 8C 91 00 34 16 20 00 0C 00 80 80 21 8F 99 ?? ?? 8F 85 ?? ?? 24 92 00 38 02 40 30 21 ?? ?? ?? ?? 27 A4 00 18 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 96 10 00 00 32 10 00 04 16 20 00 05 32 10 FF FF 8F 99 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F BF 00 34 02 00 10 21 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_432_0_0 {
	meta:
		name = "getw"
		size = 72
		refs = "0000 _gp_disp 000c __GI_fread_unlocked"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 00 80 38 21 27 A4 00 18 AF BC 00 10 AF BF 00 24 24 05 00 04 ?? ?? ?? ?? 24 06 00 01 14 40 00 02 8F A2 00 18 24 02 FF FF 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_433_0_0 {
	meta:
		name = "__GI_chdir"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F AC 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_434_0_0 {
	meta:
		name = "ftok"
		size = 96
		refs = "0000 _gp_disp 000c __GI_stat"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF 48 AF B0 00 B0 AF BC 00 10 AF BF 00 B4 00 A0 80 21 ?? ?? ?? ?? 27 A5 00 18 04 40 00 07 93 A2 00 1F 97 A3 00 2A 00 10 86 00 00 02 14 00 00 43 10 25 10 00 00 02 00 50 10 25 24 02 FF FF 8F BF 00 B4 8F B0 00 B0 03 E0 00 08 27 BD 00 B8 }
	condition:
		$1
}

rule file_436_0_0 {
	meta:
		name = "__GI_fgetwc"
		size = 160
		refs = "0000 _gp_disp 0030 _pthread_cleanup_push_defer 0034 __pthread_mutex_unlock 004c __pthread_mutex_lock 005c __GI_fgetwc_unlocked 0070 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF B0 00 30 AF BC 00 10 AF BF 00 3C AF B2 00 38 AF B1 00 34 8C 91 00 34 16 20 00 0C 00 80 80 21 8F 99 ?? ?? 8F 85 ?? ?? 24 92 00 38 02 40 30 21 ?? ?? ?? ?? 27 A4 00 18 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 16 20 00 07 8F BC 00 10 8F 99 ?? ?? AF A2 00 28 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F A2 00 28 8F BF 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_486_0_0 {
	meta:
		name = "__GI_fileno"
		size = 160
		refs = "0000 _gp_disp 0030 _pthread_cleanup_push_defer 0034 __pthread_mutex_unlock 004c __pthread_mutex_lock 005c __GI_fileno_unlocked 0070 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF B0 00 30 AF BC 00 10 AF BF 00 3C AF B2 00 38 AF B1 00 34 8C 91 00 34 16 20 00 0C 00 80 80 21 8F 99 ?? ?? 8F 85 ?? ?? 24 92 00 38 02 40 30 21 ?? ?? ?? ?? 27 A4 00 18 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 16 20 00 07 8F BC 00 10 8F 99 ?? ?? AF A2 00 28 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F A2 00 28 8F BF 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_437_0_0 {
	meta:
		name = "confstr"
		size = 172
		refs = "0000 _gp_disp 0020 __GI___errno_location 0058 __GI_memcpy 0060 $LC0"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 14 80 00 05 8F 99 ?? ?? 10 C0 00 1D 24 02 00 0E 10 00 00 07 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 24 03 00 16 AC 43 00 00 10 00 00 15 00 00 10 21 10 A0 00 12 2C C2 00 0E 14 40 00 08 8F 99 ?? ?? 00 A0 20 21 8F 85 ?? ?? 24 06 00 0E ?? ?? ?? ?? 24 A5 ?? ?? 10 00 00 0A 24 02 00 0E 00 A0 20 21 8F 85 ?? ?? 24 D0 FF FF 02 00 30 21 ?? ?? ?? ?? 24 A5 ?? ?? 00 50 18 21 A0 60 00 00 24 02 00 0E 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_438_0_0 {
	meta:
		name = "wcscpy"
		size = 36
	strings:
		$1 = { 00 80 10 21 00 80 18 21 8C A4 00 00 24 63 00 04 24 A5 00 04 14 80 FF FC AC 64 FF FC 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_439_0_0 {
	meta:
		name = "__GI_gethostname"
		size = 176
		refs = "0000 _gp_disp 000c __GI_uname 0044 __GI_strlen 0064 __GI___errno_location 007c __GI_strcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FE 50 AF BC 00 10 AF B2 01 A8 AF B1 01 A4 AF BF 01 AC AF B0 01 A0 00 80 88 21 27 A4 00 18 ?? ?? ?? ?? 00 A0 90 21 24 03 FF FF 10 43 00 15 8F BC 00 10 8F 99 ?? ?? 27 B0 00 59 ?? ?? ?? ?? 02 00 20 21 24 42 00 01 02 42 90 2B 12 40 00 07 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 10 00 00 07 AC 43 00 00 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 02 00 28 21 10 00 00 02 00 00 10 21 24 02 FF FF 8F BF 01 AC 8F B2 01 A8 8F B1 01 A4 8F B0 01 A0 03 E0 00 08 27 BD 01 B0 }
	condition:
		$1
}

rule file_441_0_0 {
	meta:
		name = "_ppfs_prepargs"
		size = 96
		refs = "0000 _gp_disp 0030 _ppfs_setargs"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B1 00 20 8C 91 00 18 AF BC 00 10 AF B0 00 1C AF BF 00 24 00 80 80 21 1A 20 00 08 AC 85 00 4C 8F 99 ?? ?? AC 91 00 1C AC 80 00 18 AC 80 00 04 ?? ?? ?? ?? AC 80 00 08 AE 11 00 18 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_442_0_0 {
	meta:
		name = "__time_localtime_tzi"
		size = 940
		refs = "0000 _gp_disp 0094 _time_t2tm 00b8 ll_tzname_UTC 00bc __GI_strcmp 0100 __GI_strnlen 011c ll_tzname_UNKNOWN 0128 malloc 0140 __GI_strcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B0 AF B3 00 34 8F 93 ?? ?? AF B5 00 3C 3C 15 7F F6 26 73 ?? ?? AF B6 00 40 AF B4 00 38 AF B2 00 30 AF B1 00 2C AF B0 00 28 AF BC 00 10 AF BF 00 4C AF BE 00 48 AF B7 00 44 00 80 A0 21 00 A0 80 21 00 C0 90 21 00 00 88 21 36 B5 C5 80 02 60 B0 21 24 17 00 18 72 37 10 02 3C 03 00 09 34 63 3A 80 00 52 B8 21 8E E2 00 00 00 62 10 23 8E 83 00 00 00 75 20 2A 14 80 00 03 24 05 FF F9 00 02 10 23 24 05 00 07 8F 99 ?? ?? 00 62 10 21 AF A2 00 18 27 A4 00 18 ?? ?? ?? ?? 02 00 30 21 8F BC 00 10 AE 11 00 20 8E E2 00 00 8F 83 ?? ?? 8F 99 ?? ?? 00 02 10 23 AE 02 00 24 26 F7 00 10 24 7E 00 04 AF A3 00 20 AF B9 00 24 03 C0 20 21 03 20 F8 09 02 E0 28 21 8F BC 00 10 8F A3 00 20 10 40 00 1C 8F B9 00 24 8C 63 00 00 54 60 FF F5 24 7E 00 04 8F 99 ?? ?? 02 E0 20 21 ?? ?? ?? ?? 24 05 00 07 8F BC 00 10 28 43 00 07 14 60 00 03 8F 9E ?? ?? 10 00 00 10 27 C2 00 04 8F 99 ?? ?? ?? ?? ?? ?? 24 44 00 08 10 40 FF FA 8F BC 00 10 8F C3 00 00 8F 99 ?? ?? AF C2 00 00 AC 43 00 00 24 44 00 04 ?? ?? ?? ?? 02 E0 28 21 10 00 00 02 8F BC 00 10 03 C0 10 21 AE 02 00 28 26 31 00 01 24 02 00 01 16 22 00 82 8F BF 00 4C 82 42 00 28 10 40 00 7B 00 00 20 21 8E 03 00 1C 24 09 00 18 8E 02 00 08 71 23 20 02 8E 03 00 04 00 82 48 21 24 02 00 3C 71 22 20 02 00 83 48 21 71 22 20 02 8E 03 00 00 00 83 48 21 8E 03 00 14 24 04 01 90 00 64 00 1A 00 80 01 F4 00 00 18 10 24 62 07 6C 30 46 00 03 14 C0 00 0B 00 00 28 21 24 05 00 64 00 45 00 1A 00 A0 01 F4 00 00 30 10 14 C0 00 05 24 05 00 01 00 44 00 1A 00 80 01 F4 00 00 28 10 2C A5 00 01 24 63 07 6B 24 06 FF 9C 00 66 00 1A 00 C0 01 F4 00 03 38 83 24 06 01 90 00 47 38 21 24 04 00 07 3C 0E 00 01 00 00 60 21 24 18 00 4A 24 19 00 4D 24 17 00 1F 24 0A 00 07 25 CE 51 80 24 0D 00 01 00 00 10 12 00 E2 10 21 00 00 38 21 00 66 00 1A 00 C0 01 F4 00 00 78 12 00 4F 78 21 02 40 10 21 01 E4 00 1A 00 80 01 F4 00 00 20 21 00 00 78 10 84 46 00 0E 14 D8 00 08 84 43 00 08 50 A0 00 28 24 63 FF FF 28 66 00 3C 10 C0 00 25 00 00 00 00 10 00 00 23 24 63 FF FF 14 D9 00 21 00 00 00 00 84 48 00 0C 01 13 30 21 90 CB FF FF 71 17 30 02 10 A0 00 04 00 CB 30 23 28 DE 00 3B 2F DE 00 01 00 DE 30 21 02 C8 F0 21 93 DE 00 00 25 6B 00 1F 10 A0 00 04 01 7E 58 23 29 08 00 02 2D 08 00 01 01 68 58 21 01 E6 40 21 01 0A 00 1A 01 40 01 F4 00 00 F0 10 00 7E 18 23 24 68 FF F9 28 7E 00 00 01 1E 18 0A 84 48 00 0A 71 0A F0 02 03 C3 18 21 00 6B 58 2A 24 68 FF F9 01 0B 18 0A 00 C3 18 21 10 E0 00 08 70 6E 40 02 8C 48 FF E8 8C 46 00 00 00 6C 60 2A 00 8C 20 21 01 06 30 23 01 26 48 21 70 6E 40 02 8C 46 00 04 24 E7 00 01 24 42 00 18 01 06 30 21 01 26 30 2A 2C C6 00 01 14 ED 00 03 00 86 20 21 10 00 FF C2 00 60 60 21 30 84 00 01 14 80 FF 3B AE 04 00 20 8F BF 00 4C 02 00 10 21 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_444_0_0 {
	meta:
		name = "erand48"
		size = 60
		refs = "0000 _gp_disp 000c __libc_drand48_data 0010 __GI_erand48_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 85 ?? ?? 8F 99 ?? ?? 27 BD FF D8 AF BF 00 24 AF BC 00 10 ?? ?? ?? ?? 27 A6 00 18 8F BF 00 24 8F A3 00 1C 8F A2 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_445_0_0 {
	meta:
		name = "mktemp"
		size = 72
		refs = "0000 _gp_disp 000c __gen_tempname"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 24 05 00 03 AF B0 00 18 AF BC 00 10 AF BF 00 1C ?? ?? ?? ?? 00 80 80 21 04 42 00 01 A2 00 00 00 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_446_0_0 {
	meta:
		name = "__syscall_pwrite.constprop.0"
		size = 112
		refs = "0000 _gp_disp 0048 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF B0 00 18 00 E0 10 21 AF BF 00 1C 00 00 38 21 8F B0 00 30 27 BD FF E0 AF A2 00 10 AF B0 00 14 24 02 10 69 00 00 00 0C 27 BD 00 20 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_446_1_0 {
	meta:
		name = "__syscall_pread.constprop.1"
		size = 112
		refs = "0000 _gp_disp 0048 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF B0 00 18 00 E0 10 21 AF BF 00 1C 00 00 38 21 8F B0 00 30 27 BD FF E0 AF A2 00 10 AF B0 00 14 24 02 10 68 00 00 00 0C 27 BD 00 20 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_446_2_0 {
	meta:
		name = "__libc_pread"
		size = 56
		refs = "0000 _gp_disp 0024 __syscall_pread.constprop.1"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BF 00 24 AF BC 00 18 AF A7 00 10 27 39 ?? ?? ?? ?? ?? ?? 00 07 3F C3 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_446_4_0 {
	meta:
		name = "__libc_pwrite"
		size = 56
		refs = "0000 _gp_disp 0024 __syscall_pwrite.constprop.0"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BF 00 24 AF BC 00 18 AF A7 00 10 27 39 ?? ?? ?? ?? ?? ?? 00 07 3F C3 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_446_3_0 {
	meta:
		name = "__libc_pread64"
		size = 36
		refs = "0000 _gp_disp 001c __syscall_pread.constprop.1"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F A2 00 14 8F 99 ?? ?? 8F A7 00 10 27 39 ?? ?? ?? ?? ?? ?? AF A2 00 10 }
	condition:
		$1
}

rule file_446_5_0 {
	meta:
		name = "__libc_pwrite64"
		size = 36
		refs = "0000 _gp_disp 001c __syscall_pwrite.constprop.0"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F A2 00 14 8F 99 ?? ?? 8F A7 00 10 27 39 ?? ?? ?? ?? ?? ?? AF A2 00 10 }
	condition:
		$1
}

rule file_447_0_0 {
	meta:
		name = "__GI_fstat"
		size = 120
		refs = "0000 _gp_disp 0034 __GI___errno_location 0054 __xstat_conv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 50 AF BC 00 10 00 A0 30 21 AF BF 00 AC AF B0 00 A8 27 A5 00 18 24 02 10 0C 00 00 00 0C 10 E0 00 07 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 10 00 00 07 24 10 FF FF 14 40 00 06 8F BF 00 AC 8F 99 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 00 C0 28 21 8F BF 00 AC 02 00 10 21 8F B0 00 A8 03 E0 00 08 27 BD 00 B0 }
	condition:
		$1
}

rule file_448_0_0 {
	meta:
		name = "truncate64"
		size = 88
		refs = "0000 _gp_disp 0030 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 00 00 28 21 24 02 10 73 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_449_0_0 {
	meta:
		name = "__GI_connect"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 4A 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_450_0_0 {
	meta:
		name = "putchar_unlocked"
		size = 72
		refs = "0000 _gp_disp 000c stdout 003c __GI___fputc_unlocked"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 83 ?? ?? 8C 65 00 00 8C A3 00 10 8C A6 00 1C 00 66 30 2B 10 C0 00 06 00 80 10 21 24 64 00 01 AC A4 00 10 A0 62 00 00 03 E0 00 08 30 42 00 FF 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_451_0_0 {
	meta:
		name = "_create_xid"
		size = 232
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 004c __pthread_mutex_lock 006c __GI_gettimeofday 0088 __GI_srand48_r 00a4 __GI_lrand48_r 00bc _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B1 00 38 8F 91 ?? ?? 8F 99 ?? ?? 8F 85 ?? ?? AF B0 00 34 27 B0 00 18 AF BC 00 10 26 26 ?? ?? AF BF 00 44 AF B3 00 40 AF B2 00 3C ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 26 24 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 27 B2 00 28 8F BC 00 10 8F 93 ?? ?? 8E 62 ?? ?? 14 40 00 0F 8F 91 ?? ?? 8F 99 ?? ?? 02 40 20 21 ?? ?? ?? ?? 00 00 28 21 8F BC 00 10 8F A2 00 28 8F A4 00 2C 8F 99 ?? ?? 26 25 ?? ?? ?? ?? ?? ?? 00 82 20 26 8F BC 00 10 24 02 00 01 AE 62 ?? ?? 8F 99 ?? ?? 26 24 ?? ?? ?? ?? ?? ?? 02 40 28 21 8F BC 00 10 02 00 20 21 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 01 8F BF 00 44 8F A2 00 28 8F B3 00 40 8F B2 00 3C 8F B1 00 38 8F B0 00 34 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_452_0_0 {
	meta:
		name = "pmap_getmaps"
		size = 252
		refs = "0000 _gp_disp 0034 __GI_clnttcp_create 0078 __GI_xdr_pmaplist 0080 __GI_xdr_void 00c0 __GI_clnt_perror 00bc $LC0"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 24 02 FF FF AF A2 00 30 24 02 00 3C AF BC 00 20 AF A2 00 28 24 02 00 6F AF B1 00 40 AF B0 00 3C AF BF 00 44 8F 99 ?? ?? A4 82 00 02 24 02 00 32 AF A2 00 10 3C 05 00 01 24 02 01 F4 AF A0 00 34 AF A0 00 2C AF A2 00 14 34 A5 86 A0 24 06 00 02 27 A7 00 30 ?? ?? ?? ?? 00 80 88 21 00 40 80 21 10 40 00 1B 8F BC 00 20 8F 83 ?? ?? 8C 42 00 04 8F 86 ?? ?? AF A3 00 10 27 A3 00 34 AF A3 00 14 8F A3 00 28 02 00 20 21 24 05 00 04 AF A3 00 18 8F A3 00 2C AF A3 00 1C 8C 59 00 00 03 20 F8 09 00 00 38 21 10 40 00 06 8F BC 00 20 8F 85 ?? ?? 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 24 A5 ?? ?? 8E 02 00 04 8C 59 00 10 03 20 F8 09 02 00 20 21 8F BF 00 44 8F A2 00 34 8F B0 00 3C A6 20 00 02 8F B1 00 40 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_454_0_0 {
	meta:
		name = "__GI_mremap"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 8F A2 00 30 27 BD FF E0 AF A2 00 10 24 02 10 47 00 00 00 0C 27 BD 00 20 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_456_0_0 {
	meta:
		name = "quotactl"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 23 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_457_0_0 {
	meta:
		name = "__GI_lfind"
		size = 112
	strings:
		$1 = { 8C C2 00 00 27 BD FF D0 AF B2 00 24 AF B1 00 20 AF B0 00 1C AF BF 00 2C AF B3 00 28 00 80 88 21 00 A0 80 21 00 E0 90 21 10 40 00 0A 24 53 FF FF 8F B9 00 40 02 20 20 21 03 20 F8 09 02 00 28 21 10 40 00 03 02 60 10 21 10 00 FF F7 02 12 80 21 02 00 10 21 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_458_0_0 {
	meta:
		name = "__GI_execv"
		size = 28
		refs = "0000 _gp_disp 000c __environ 0010 __GI_execve"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 8C 46 00 00 }
	condition:
		$1
}

rule file_461_0_0 {
	meta:
		name = "ptrace"
		size = 160
		refs = "0000 _gp_disp 0054 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 27 A2 00 34 AF B1 00 28 24 91 FF FF AF BC 00 10 AF A2 00 18 2E 31 00 03 27 A2 00 1C AF A7 00 3C AF BF 00 2C AF B0 00 24 AF A5 00 34 AF A6 00 38 00 51 38 0B 24 02 0F BA 00 00 00 0C 10 E0 00 07 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 10 00 00 09 24 02 FF FF 06 00 00 08 8F BF 00 2C 12 20 00 06 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 40 00 00 8F A2 00 1C 8F BF 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_463_0_0 {
	meta:
		name = "tcflow"
		size = 28
		refs = "0000 _gp_disp 000c __GI_ioctl"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 00 A0 30 21 ?? ?? ?? ?? 24 05 54 06 }
	condition:
		$1
}

rule file_464_0_0 {
	meta:
		name = "__GI_wcschr"
		size = 36
	strings:
		$1 = { 8C 82 00 00 10 45 00 05 00 00 00 00 14 40 FF FC 24 84 00 04 03 E0 00 08 00 00 00 00 03 E0 00 08 00 80 10 21 }
	condition:
		$1
}

rule file_465_0_0 {
	meta:
		name = "__ether_line"
		size = 156
		refs = "0000 _gp_disp 000c __GI_ether_aton_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF B0 00 18 AF BC 00 10 AF BF 00 1C ?? ?? ?? ?? 00 80 80 21 24 04 FF DF 10 40 00 16 24 03 00 09 82 02 00 00 00 44 28 24 7C 05 2C 20 50 A0 00 05 24 04 00 20 50 43 00 03 24 04 00 20 10 00 FF F8 26 10 00 01 24 03 00 09 82 02 00 00 50 40 00 0A 00 00 10 21 14 44 00 03 00 00 00 00 10 00 FF FA 26 10 00 01 50 43 FF F8 26 10 00 01 10 00 00 02 02 00 10 21 00 00 10 21 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_465_1_0 {
	meta:
		name = "__ether_line_w"
		size = 136
		refs = "0000 _gp_disp 0014 __GI_strchr 0080 __ether_line"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B1 00 1C 8F 91 ?? ?? AF BC 00 10 AF B2 00 20 AF B0 00 18 AF BF 00 24 00 A0 90 21 02 20 C8 21 24 05 00 23 ?? ?? ?? ?? 00 80 80 21 14 40 00 07 8F BC 00 10 02 00 20 21 02 20 C8 21 ?? ?? ?? ?? 24 05 00 0A 10 40 00 02 8F BC 00 10 A0 40 00 00 8F 99 ?? ?? 8F BF 00 24 8F B1 00 1C 02 00 20 21 02 40 28 21 8F B0 00 18 8F B2 00 20 27 39 ?? ?? ?? ?? ?? ?? 27 BD 00 28 }
	condition:
		$1
}

rule file_465_2_0 {
	meta:
		name = "ether_line"
		size = 152
		refs = "0000 _gp_disp 0024 __ether_line 0034 __GI___ctype_b"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BC 00 10 AF B0 00 18 AF BF 00 1C 27 39 ?? ?? ?? ?? ?? ?? 00 C0 80 21 10 40 00 15 8F BC 00 10 8F 85 ?? ?? 24 04 00 23 80 43 00 00 50 60 00 0E A2 00 00 00 10 64 00 0B 00 03 30 40 8C A7 00 00 00 E6 30 21 94 C6 00 00 30 C6 00 20 54 C0 00 06 A2 00 00 00 A2 03 00 00 24 42 00 01 10 00 FF F2 26 10 00 01 A2 00 00 00 10 00 00 02 00 00 10 21 24 02 FF FF 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_465_3_0 {
	meta:
		name = "ether_ntohost"
		size = 308
		refs = "0000 _gp_disp 0028 __GI_fopen 0024 $LC0 0020 $LC1 0068 __GI_fgets 0070 __GI_memcmp 00a0 __ether_line_w 00cc __GI_strcpy 00ec __GI_fclose"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FE B8 AF B6 01 38 AF B5 01 34 00 A0 B0 21 00 80 A8 21 8F 85 ?? ?? 8F 84 ?? ?? 8F 99 ?? ?? AF BC 00 10 AF B0 01 20 AF BF 01 44 AF BE 01 40 AF B7 01 3C AF B4 01 30 AF B3 01 2C AF B2 01 28 AF B1 01 24 24 84 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? 00 40 80 21 10 40 00 27 8F BC 00 10 8F 94 ?? ?? 8F 97 ?? ?? 8F 9E ?? ?? 27 B1 00 18 27 B2 01 18 02 20 20 21 24 05 01 00 02 80 C8 21 ?? ?? ?? ?? 02 00 30 21 10 40 00 15 8F BC 00 10 02 20 20 21 26 F9 ?? ?? ?? ?? ?? ?? 02 40 28 21 10 40 FF F4 00 40 98 21 02 C0 20 21 02 40 28 21 03 C0 C8 21 ?? ?? ?? ?? 24 06 00 06 14 40 FF ED 8F BC 00 10 8F 99 ?? ?? 02 A0 20 21 ?? ?? ?? ?? 02 60 28 21 00 00 88 21 10 00 00 02 8F BC 00 10 24 11 FF FF 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 10 00 00 02 02 20 10 21 24 02 FF FF 8F BF 01 44 8F BE 01 40 8F B7 01 3C 8F B6 01 38 8F B5 01 34 8F B4 01 30 8F B3 01 2C 8F B2 01 28 8F B1 01 24 8F B0 01 20 03 E0 00 08 27 BD 01 48 }
	condition:
		$1
}

rule file_465_4_0 {
	meta:
		name = "ether_hostton"
		size = 260
		refs = "0000 _gp_disp 0028 __GI_fopen 0024 $LC0 0020 $LC1 0060 __GI_fgets 0068 __GI_strcasecmp 0094 __ether_line_w 00c4 __GI_fclose"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FE C8 AF B4 01 28 AF B3 01 24 00 A0 A0 21 00 80 98 21 8F 85 ?? ?? 8F 84 ?? ?? 8F 99 ?? ?? AF BC 00 10 AF B0 01 18 AF BF 01 34 AF B6 01 30 AF B5 01 2C AF B2 01 20 AF B1 01 1C 24 84 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? 00 40 80 21 10 40 00 1F 8F BC 00 10 8F 92 ?? ?? 8F 95 ?? ?? 8F 96 ?? ?? 27 B1 00 18 02 20 20 21 24 05 01 00 02 40 C8 21 ?? ?? ?? ?? 02 00 30 21 10 40 00 0E 8F BC 00 10 02 20 20 21 26 B9 ?? ?? ?? ?? ?? ?? 02 80 28 21 10 40 FF F4 02 60 20 21 02 C0 C8 21 ?? ?? ?? ?? 00 40 28 21 14 40 FF EF 8F BC 00 10 10 00 00 02 00 00 88 21 24 11 FF FF 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 10 00 00 02 02 20 10 21 24 02 FF FF 8F BF 01 34 8F B6 01 30 8F B5 01 2C 8F B4 01 28 8F B3 01 24 8F B2 01 20 8F B1 01 1C 8F B0 01 18 03 E0 00 08 27 BD 01 38 }
	condition:
		$1
}

rule file_466_0_0 {
	meta:
		name = "_buf"
		size = 92
		refs = "0000 _gp_disp 000c __rpc_thread_variables 0038 malloc"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BC 00 10 AF B0 00 18 AF BF 00 1C ?? ?? ?? ?? 00 00 00 00 00 40 80 21 8C 42 00 9C 14 40 00 05 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 24 04 01 00 AE 02 00 9C 8F BF 00 1C 8E 02 00 9C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_466_1_0 {
	meta:
		name = "free_mem"
		size = 60
		refs = "0000 _gp_disp 000c __rpc_thread_variables 0030 free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BC 00 10 AF BF 00 1C ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F BF 00 1C 8C 44 00 9C 8F 99 ?? ?? ?? ?? ?? ?? 27 BD 00 20 }
	condition:
		$1
}

rule file_466_2_0 {
	meta:
		name = "__GI_clnt_sperrno"
		size = 88
		refs = "0000 _gp_disp 004c $LC0"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 86 ?? ?? 00 00 10 21 24 05 00 12 24 C6 ?? ?? 00 02 18 C0 00 66 18 21 8C 67 00 00 54 E4 00 06 24 42 00 01 8F 82 ?? ?? 8C 63 00 04 24 42 ?? ?? 03 E0 00 08 00 43 10 21 14 45 FF F6 00 02 18 C0 8F 82 ?? ?? 03 E0 00 08 24 42 ?? ?? }
	condition:
		$1
}

rule file_466_3_0 {
	meta:
		name = "clnt_perrno"
		size = 68
		refs = "0000 _gp_disp 000c __GI_clnt_sperrno 0030 stderr 0034 __GI_fputs"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BC 00 10 AF BF 00 1C ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 00 40 20 21 8F BF 00 1C 8F 82 ?? ?? 8F 99 ?? ?? 8C 45 00 00 ?? ?? ?? ?? 27 BD 00 20 }
	condition:
		$1
}

rule file_466_5_0 {
	meta:
		name = "__GI_clnt_perror"
		size = 68
		refs = "0000 _gp_disp 000c __GI_clnt_sperror 0030 stderr 0034 __GI_fputs"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BC 00 10 AF BF 00 1C ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 00 40 20 21 8F BF 00 1C 8F 82 ?? ?? 8F 99 ?? ?? 8C 45 00 00 ?? ?? ?? ?? 27 BD 00 20 }
	condition:
		$1
}

rule file_466_7_0 {
	meta:
		name = "clnt_pcreateerror"
		size = 68
		refs = "0000 _gp_disp 000c __GI_clnt_spcreateerror 0030 stderr 0034 __GI_fputs"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BC 00 10 AF BF 00 1C ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 00 40 20 21 8F BF 00 1C 8F 82 ?? ?? 8F 99 ?? ?? 8C 45 00 00 ?? ?? ?? ?? 27 BD 00 20 }
	condition:
		$1
}

rule file_466_4_0 {
	meta:
		name = "__GI_clnt_sperror"
		size = 608
		refs = "0000 _gp_disp 003c _buf 006c __GI_sprintf 0070 $LC1 008c __GI_clnt_sperrno 00a0 __GI_strcpy 00b4 __GI_strlen 0100 __GI___glibc_strerror_r 0120 $LC2 0174 $LC4 01c4 $LC5 01e4 $LC3 0200 $LC6"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FB B0 AF B1 04 38 AF B0 04 34 AF BC 00 10 AF A4 04 28 AF BF 04 4C AF B5 04 48 AF B4 04 44 AF B3 04 40 AF B2 04 3C 27 39 ?? ?? ?? ?? ?? ?? 00 A0 80 21 00 40 88 21 10 40 00 7B 8F A4 04 28 8C 82 00 04 8C 59 00 08 03 20 F8 09 27 A5 04 18 8F BC 00 10 02 00 30 21 02 20 20 21 8F 93 ?? ?? 8F 85 ?? ?? 02 60 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 8F BC 00 10 8F A4 04 18 02 22 80 21 8F 99 ?? ?? ?? ?? ?? ?? 02 60 90 21 8F BC 00 10 02 00 20 21 8F 94 ?? ?? 02 80 C8 21 ?? ?? ?? ?? 00 40 28 21 8F BC 00 10 8F 95 ?? ?? 02 A0 C8 21 ?? ?? ?? ?? 02 00 20 21 02 02 80 21 8F A2 04 18 8F BC 00 10 2C 43 00 12 10 60 00 4A 02 80 C8 21 8F 83 ?? ?? 00 02 10 80 24 63 ?? ?? 00 62 10 21 8C 42 00 00 00 5C 10 21 00 40 00 08 00 00 00 00 8F A4 04 1C 8F 99 ?? ?? 27 B3 00 18 02 60 28 21 ?? ?? ?? ?? 24 06 04 00 8F BC 00 10 02 00 20 21 02 60 30 21 8F 85 ?? ?? 10 00 00 2A 24 A5 ?? ?? 8F 86 ?? ?? 8F A5 04 1C 00 00 10 21 24 C6 ?? ?? 24 04 00 08 00 02 18 C0 00 66 18 21 8C 67 00 00 14 E5 00 06 24 42 00 01 8F 93 ?? ?? 8C 62 00 04 26 73 ?? ?? 10 00 00 04 02 62 98 21 14 44 FF F6 00 02 18 C0 00 00 98 21 8F 85 ?? ?? 02 00 20 21 ?? ?? ?? ?? 24 A5 ?? ?? 02 A0 C8 21 ?? ?? ?? ?? 02 00 20 21 02 02 80 21 8F BC 00 10 12 60 00 0A 02 00 20 21 8F 99 ?? ?? ?? ?? ?? ?? 02 60 28 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 10 00 00 19 02 02 80 21 8F 85 ?? ?? 8F A6 04 1C 24 A5 ?? ?? 02 40 C8 21 ?? ?? ?? ?? 00 00 00 00 10 00 00 11 02 02 80 21 8F 85 ?? ?? 02 00 20 21 8F A6 04 1C 24 A5 ?? ?? 8F A7 04 20 10 00 00 07 02 60 C8 21 8F 85 ?? ?? 8F A6 04 1C 8F A7 04 20 02 00 20 21 24 A5 ?? ?? 02 60 C8 21 ?? ?? ?? ?? 00 00 00 00 02 02 80 21 24 02 00 0A A2 02 00 00 A2 00 00 01 10 00 00 02 02 20 10 21 00 00 10 21 8F BF 04 4C 8F B5 04 48 8F B4 04 44 8F B3 04 40 8F B2 04 3C 8F B1 04 38 8F B0 04 34 03 E0 00 08 27 BD 04 50 }
	condition:
		$1
}

rule file_466_6_0 {
	meta:
		name = "__GI_clnt_spcreateerror"
		size = 440
		refs = "0000 _gp_disp 0038 _buf 004c __GI___rpc_thread_createerr 0068 __GI_sprintf 0064 $LC1 0080 __GI_clnt_sperrno 0098 __GI_strcpy 00ac __GI_strlen 00dc $LC7 0144 __GI___glibc_strerror_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FB C8 AF BC 00 10 AF B3 04 28 AF B0 04 1C AF BF 04 34 AF B5 04 30 AF B4 04 2C AF B2 04 24 AF B1 04 20 27 39 ?? ?? ?? ?? ?? ?? 00 80 80 21 00 40 98 21 10 40 00 52 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 02 00 30 21 02 60 20 21 8F 85 ?? ?? 8F 99 ?? ?? 00 40 A0 21 ?? ?? ?? ?? 24 A5 ?? ?? 8F BC 00 10 8E 84 00 00 8F 95 ?? ?? 02 A0 C8 21 ?? ?? ?? ?? 02 62 80 21 8F BC 00 10 02 00 20 21 8F 92 ?? ?? 02 40 C8 21 ?? ?? ?? ?? 00 40 28 21 8F BC 00 10 8F 91 ?? ?? 02 20 C8 21 ?? ?? ?? ?? 02 00 20 21 02 02 80 21 8E 82 00 00 24 03 00 0C 10 43 00 13 8F BC 00 10 24 03 00 0E 54 43 00 2A 24 02 00 0A 8F 85 ?? ?? 02 00 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 02 20 C8 21 ?? ?? ?? ?? 02 00 20 21 8E 84 00 04 02 A0 C8 21 ?? ?? ?? ?? 02 02 80 21 00 40 28 21 10 00 00 13 02 00 20 21 8F 85 ?? ?? 02 00 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 02 20 C8 21 ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8E 84 00 08 27 B4 00 18 8F 99 ?? ?? 02 02 80 21 02 80 28 21 ?? ?? ?? ?? 24 06 04 00 02 00 20 21 02 80 28 21 02 40 C8 21 ?? ?? ?? ?? 00 00 00 00 02 20 C8 21 ?? ?? ?? ?? 02 00 20 21 02 02 80 21 24 02 00 0A A2 02 00 00 A2 00 00 01 10 00 00 02 02 60 10 21 00 00 10 21 8F BF 04 34 8F B5 04 30 8F B4 04 2C 8F B3 04 28 8F B2 04 24 8F B1 04 20 8F B0 04 1C 03 E0 00 08 27 BD 04 38 }
	condition:
		$1
}

rule file_468_0_0 {
	meta:
		name = "__cxa_finalize"
		size = 196
		refs = "0000 _gp_disp 000c __exit_count 0034 __exit_function_table"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 27 BD FF D0 AF B4 00 28 AF B3 00 24 AF B2 00 20 AF B1 00 1C AF BC 00 10 AF BF 00 2C AF B0 00 18 8C 50 00 00 8F 94 ?? ?? 00 80 88 21 24 12 00 03 00 00 98 21 12 00 00 17 26 10 FF FF 8E 83 00 00 00 10 11 00 12 20 00 04 00 62 10 21 8C 43 00 0C 16 23 FF F8 00 00 00 00 C0 44 00 00 14 92 00 06 00 00 18 21 02 60 18 21 E0 43 00 00 10 60 FF FA 00 00 00 00 00 00 00 0F 10 60 FF EE 00 00 00 00 8C 59 00 04 03 20 F8 09 8C 44 00 08 10 00 FF E9 00 00 00 00 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_469_0_0 {
	meta:
		name = "__GI_wcsrtombs"
		size = 60
		refs = "0000 _gp_disp 000c __GI_wcsnrtombs"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 00 C0 10 21 24 06 FF FF AF BF 00 24 AF BC 00 18 AF A7 00 10 ?? ?? ?? ?? 00 40 38 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_470_0_0 {
	meta:
		name = "sigpending"
		size = 88
		refs = "0000 _gp_disp 0030 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 05 00 10 24 02 10 64 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_471_0_0 {
	meta:
		name = "lldiv"
		size = 260
		refs = "0000 _gp_disp 0020 __divdi3 0074 __moddi3"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF B2 00 20 AF B1 00 1C 8F B2 00 54 8F B1 00 50 8F 99 ?? ?? AF BC 00 10 00 E0 28 21 AF BF 00 3C AF BE 00 38 AF B7 00 34 AF B6 00 30 AF B5 00 2C AF B4 00 28 AF B3 00 24 AF B0 00 18 00 C0 A0 21 00 E0 F0 21 00 80 80 21 02 40 38 21 00 C0 20 21 ?? ?? ?? ?? 02 20 30 21 8F BC 00 10 02 80 20 21 03 C0 28 21 8F 99 ?? ?? 02 20 30 21 02 40 38 21 00 40 B8 21 00 60 98 21 ?? ?? ?? ?? 00 60 A8 21 02 E0 B0 21 00 40 20 21 06 80 00 09 00 60 28 21 04 81 00 07 00 51 88 23 26 75 00 01 00 72 28 23 02 B3 98 2B 00 65 18 2B 02 77 B0 21 02 23 20 23 8F BF 00 3C AE 16 00 00 AE 15 00 04 02 00 10 21 8F BE 00 38 8F B7 00 34 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C AE 04 00 08 AE 05 00 0C 8F B0 00 18 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_472_0_0 {
	meta:
		name = "__GI_sigemptyset"
		size = 24
	strings:
		$1 = { AC 80 00 0C AC 80 00 08 AC 80 00 04 AC 80 00 00 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_473_0_0 {
	meta:
		name = "__GI_nrand48_r"
		size = 104
		refs = "0000 _gp_disp 000c __drand48_iterate"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF B1 00 20 AF B0 00 1C AF BC 00 10 AF BF 00 24 00 80 80 21 ?? ?? ?? ?? 00 C0 88 21 04 42 00 08 24 02 FF FF 96 03 00 02 96 02 00 04 00 03 18 42 00 02 13 C0 00 62 10 25 AE 22 00 00 00 00 10 21 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_474_0_0 {
	meta:
		name = "setdomainname"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 19 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_475_0_0 {
	meta:
		name = "_stdlib_wcsto_ll"
		size = 724
		refs = "0000 _gp_disp 0014 __GI_iswspace 0100 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B5 00 34 8F 95 ?? ?? AF B6 00 38 AF B3 00 2C AF B2 00 28 AF B1 00 24 AF B0 00 20 AF BC 00 10 AF BF 00 44 AF BE 00 40 AF B7 00 3C AF B4 00 30 00 80 B0 21 00 A0 98 21 00 C0 88 21 00 E0 90 21 00 80 80 21 8E 14 00 00 02 A0 C8 21 ?? ?? ?? ?? 02 80 20 21 10 40 00 03 8F BC 00 10 10 00 FF F9 26 10 00 04 24 02 00 2B 12 82 00 05 24 02 00 2D 56 82 00 05 00 00 A8 21 10 00 00 02 24 15 00 01 00 00 A8 21 26 10 00 04 24 02 FF EF 02 22 10 24 14 40 00 14 26 22 FF FE 8E 03 00 00 24 02 00 30 50 62 00 03 8E 04 00 04 10 00 00 0A 26 22 00 0A 24 03 00 78 26 16 00 04 34 84 00 20 14 83 00 04 26 22 00 08 26 10 00 08 10 00 00 02 00 02 10 40 02 C0 80 21 24 11 00 10 28 43 00 11 00 43 88 0B 26 22 FF FE 2C 42 00 23 10 40 00 4E 00 00 18 21 8F 99 ?? ?? 00 00 10 21 00 00 18 21 3C 14 04 00 00 11 BF C3 3C 09 01 00 24 1E 00 22 8E 04 00 00 24 86 FF D0 2C C5 00 0A 54 A0 00 07 30 C6 00 FF 34 84 00 20 2C 85 00 61 14 A0 00 03 24 06 00 28 24 86 FF A9 30 C6 00 FF 00 D1 20 2A 10 80 00 39 00 54 20 2B 10 80 00 0D 26 10 00 04 02 E3 00 18 70 51 00 00 00 00 10 12 00 71 00 19 00 00 28 12 00 C5 18 21 00 66 30 2B 00 00 20 10 00 44 10 21 00 C2 10 21 10 00 FF E5 02 00 B0 21 30 64 00 FF 70 91 28 02 00 03 22 02 00 02 1A 02 00 A6 30 21 00 02 2E 00 00 A4 20 25 02 E4 00 18 70 71 00 00 00 06 1A 02 00 00 10 12 00 91 00 19 00 00 28 12 00 65 38 21 00 E3 18 2B 00 00 20 10 00 44 10 21 00 40 20 21 00 62 10 21 00 49 10 2B 50 40 00 0B AF A9 00 18 00 05 16 02 00 04 3A 00 00 05 1A 00 00 47 38 25 00 C3 18 21 00 06 17 C3 00 47 38 21 00 66 30 2B 10 00 FF DF 00 C7 10 21 03 20 F8 09 AF B9 00 1C 8F BC 00 10 AC 5E 00 00 02 B2 A8 24 24 02 FF FF 24 03 FF FF 8F A9 00 18 10 00 FF D5 8F B9 00 1C 56 60 00 01 AE 76 00 00 52 A0 00 04 3C 10 7F FF 3C 10 80 00 10 00 00 03 00 00 88 21 36 10 FF FF 24 11 FF FF 12 40 00 0D 02 02 20 2B 14 80 00 05 8F 99 ?? ?? 14 50 00 09 02 23 20 2B 10 80 00 07 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 24 03 00 22 AC 43 00 00 02 00 10 21 02 20 18 21 12 A0 00 05 8F BF 00 44 00 03 18 23 00 03 20 2B 00 02 10 23 00 44 10 23 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_476_0_0 {
	meta:
		name = "skip_nospace"
		size = 80
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 86 ?? ?? 00 80 10 21 24 07 00 0A 80 43 00 00 10 60 00 0A 00 03 20 40 8C C5 00 00 00 A4 20 21 94 84 00 00 30 84 00 20 14 80 00 04 00 00 00 00 54 67 FF F6 24 42 00 01 A0 40 00 00 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_476_1_0 {
	meta:
		name = "skip_and_NUL_space"
		size = 96
		refs = "0000 _gp_disp 0010 __GI___ctype_b"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 00 80 10 21 8F 84 ?? ?? 24 05 00 0A 24 06 00 23 80 43 00 00 10 60 00 0D 00 03 38 40 8C 88 00 00 01 07 38 21 94 E7 00 00 30 E7 00 20 10 E0 00 07 00 00 00 00 10 65 00 05 A0 40 00 00 10 66 00 03 00 00 00 00 10 00 FF F2 24 42 00 01 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_476_2_0 {
	meta:
		name = "__open_nameservers"
		size = 1140
		refs = "0000 _gp_disp 000c __res_sync 0048 __nameservers 004c __GI_time 006c __close_nameservers 0094 __GI_fopen 008c $LC0 00a4 $LC1 00b4 $LC2 00e4 __GI_fgets 0108 skip_and_NUL_space 0118 skip_nospace 013c __GI_strcmp 0138 $LC3 016c __GI_inet_pton 0198 __nameserver 01a0 realloc 01d4 __GI_memcpy 0200 $LC4 021c $LC5 0238 __searchdomains 023c __searchdomain 0264 free 02d0 __GI_strdup 031c __GI_fclose 0338 malloc 0358 __local_nameserver 0390 __GI_gethostname 03b0 __GI_strchr"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 27 BD FE 28 AF BC 00 10 AF BF 01 D4 AF BE 01 D0 AF B7 01 CC AF B6 01 C8 AF B5 01 C4 AF B4 01 C0 AF B3 01 BC AF B2 01 B8 AF B1 01 B4 AF B0 01 B0 8C 43 00 00 14 60 00 0E 8F 92 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 20 21 8F BC 00 10 7C 42 3A 00 8F 83 ?? ?? 90 64 ?? ?? 10 82 00 04 8F 99 ?? ?? ?? ?? ?? ?? A0 62 ?? ?? 8F BC 00 10 8F 92 ?? ?? 8E 42 00 00 14 40 00 EA 8F 82 ?? ?? 8F 84 ?? ?? 8F 93 ?? ?? 8F 90 ?? ?? 24 84 ?? ?? 02 00 C8 21 ?? ?? ?? ?? 26 65 ?? ?? 00 40 88 21 14 40 00 09 8F BC 00 10 8F 84 ?? ?? 26 65 ?? ?? 02 00 C8 21 ?? ?? ?? ?? 24 84 ?? ?? 00 40 88 21 10 40 00 97 8F BC 00 10 8F 93 ?? ?? 8F 94 ?? ?? 26 73 ?? ?? 26 94 ?? ?? 8F 99 ?? ?? 27 B0 01 18 02 00 20 21 24 05 00 80 ?? ?? ?? ?? 02 20 30 21 10 40 00 87 8F BC 00 10 02 60 C8 21 ?? ?? ?? ?? 02 00 20 21 00 40 20 21 02 80 C8 21 ?? ?? ?? ?? 00 40 A8 21 02 60 C8 21 ?? ?? ?? ?? 00 40 20 21 8F BC 00 10 00 40 80 21 02 A0 20 21 8F 82 ?? ?? 8F 96 ?? ?? 02 C0 C8 21 ?? ?? ?? ?? 24 45 ?? ?? 14 40 00 2C 8F BC 00 10 02 80 C8 21 ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 24 04 00 02 A0 40 00 00 8F 99 ?? ?? AF A0 01 98 AF A0 01 9C AF A0 01 A0 AF A0 01 A4 02 00 28 21 ?? ?? ?? ?? 27 A6 01 9C 27 B5 01 98 18 40 FF D4 8F BC 00 10 8F 96 ?? ?? 8E 45 00 00 8F 99 ?? ?? 24 02 00 02 8E C4 00 00 A7 A2 01 98 24 A5 00 01 24 02 00 35 A7 A2 01 9A 8F 90 ?? ?? ?? ?? ?? ?? 00 05 29 00 10 40 FF C6 8F BC 00 10 8E 04 00 00 8F 99 ?? ?? AE C2 00 00 24 83 00 01 00 04 21 00 AE 03 00 00 00 44 20 21 02 A0 28 21 ?? ?? ?? ?? 24 06 00 10 10 00 FF BA 8F BC 00 10 8F 85 ?? ?? 02 A0 20 21 02 C0 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 10 40 00 08 8F BC 00 10 8F 85 ?? ?? 02 A0 20 21 02 C0 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 FF AC 8F BC 00 10 8F 95 ?? ?? 8F 9E ?? ?? 8E A2 00 00 8F 96 ?? ?? 10 40 00 0B 8F 97 ?? ?? 8F C3 00 00 24 42 FF FF AE A2 00 00 00 02 10 80 00 62 10 21 8F 99 ?? ?? ?? ?? ?? ?? 8C 44 00 00 10 00 FF F3 8F BC 00 10 02 E0 A8 21 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BC 00 10 8E E5 00 00 8E C4 00 00 8F 99 ?? ?? 24 A5 00 01 00 05 28 80 ?? ?? ?? ?? 00 40 F0 21 00 40 18 21 10 40 FF 87 8F BC 00 10 8F 82 ?? ?? 8F 99 ?? ?? 02 00 20 21 AC 43 00 00 ?? ?? ?? ?? AF A3 01 A8 8F BC 00 10 10 40 FF 7E 8F A3 01 A8 8E A4 00 00 24 85 00 01 00 04 20 80 00 64 18 21 AE A5 00 00 AC 62 00 00 83 C2 00 00 14 40 FF DB 03 C0 80 21 10 00 FF 74 8F 99 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8E 42 00 00 14 40 00 14 8F 90 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 04 00 10 8F BC 00 10 8F 83 ?? ?? 10 40 00 08 AC 62 00 00 8F 99 ?? ?? 8F 85 ?? ?? 00 40 20 21 ?? ?? ?? ?? 24 06 00 10 10 00 00 03 8F BC 00 10 8F 82 ?? ?? AC 62 00 00 24 02 00 01 AE 42 00 00 8F 90 ?? ?? 8E 02 00 00 14 40 00 29 8F 82 ?? ?? 8F 99 ?? ?? 27 B1 00 18 02 20 20 21 ?? ?? ?? ?? 24 05 00 FF 8F BC 00 10 14 40 00 20 A3 A0 01 17 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 24 05 00 2E 10 40 00 1A 8F BC 00 10 80 43 00 01 50 60 00 18 8F 82 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 44 00 01 00 40 88 21 10 40 00 11 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 24 04 00 04 8F BC 00 10 8F 83 ?? ?? 14 40 00 06 AC 62 00 00 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 10 00 00 05 8F BC 00 10 AC 51 00 00 8E 02 00 00 24 42 00 01 AE 02 00 00 8F 82 ?? ?? 8C 59 00 00 13 20 00 04 8F BF 01 D4 03 20 F8 09 00 00 00 00 8F BF 01 D4 8F BE 01 D0 8F B7 01 CC 8F B6 01 C8 8F B5 01 C4 8F B4 01 C0 8F B3 01 BC 8F B2 01 B8 8F B1 01 B4 8F B0 01 B0 03 E0 00 08 27 BD 01 D8 }
	condition:
		$1
}

rule file_477_0_0 {
	meta:
		name = "__GI_strptime"
		size = 1344
		refs = "0000 _gp_disp 0070 __GI___ctype_b 01c0 __GI_nl_langinfo 0224 __GI_strlen 023c __GI_strncasecmp 02e4 __GI___errno_location 0320 __GI_strtol 0358 __GI_localtime_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 60 00 00 10 21 24 03 00 0D AF B2 00 80 AF B1 00 7C AF B0 00 78 AF BC 00 10 00 A0 88 21 AF BF 00 9C AF BE 00 98 AF B7 00 94 AF B6 00 90 AF B5 00 8C AF B4 00 88 AF B3 00 84 00 80 80 21 AF A6 00 A8 27 B2 00 18 3C 05 80 00 00 02 20 80 02 44 20 21 24 42 00 01 14 43 FF FC AC 85 00 00 8F 93 ?? ?? 8F 95 ?? ?? 00 00 A0 21 26 73 ?? ?? 82 24 00 00 14 80 00 1A 24 02 00 25 56 80 00 14 26 94 FF FF 8F A3 00 30 24 02 00 07 50 62 00 01 AF A0 00 30 00 00 10 21 3C 06 80 00 24 05 00 08 00 02 20 80 02 44 18 21 8C 63 00 00 10 66 00 03 8F A7 00 A8 00 E4 20 21 AC 83 00 00 24 42 00 01 14 45 FF F8 00 02 20 80 10 00 01 0E 02 00 10 21 00 14 10 80 02 42 10 21 10 00 FF E5 8C 51 00 34 54 82 00 F3 82 22 00 00 82 23 00 01 10 64 00 EE 26 22 00 01 24 04 00 4F 10 64 00 05 24 05 00 45 14 65 00 07 24 04 00 3F 10 00 00 02 24 04 FF 80 24 04 00 40 34 84 00 3F 30 84 00 FF 26 22 00 02 80 43 00 00 10 60 00 8A 34 65 00 20 24 A5 FF 9F 30 A5 00 FF 2C A5 00 1A 50 A0 00 F2 00 00 10 21 00 73 18 21 90 63 FF BF 00 64 20 24 2C 84 00 3F 10 80 00 7F 30 64 00 30 24 05 00 30 14 85 00 1C 24 51 00 01 24 04 00 04 12 84 00 79 00 14 38 80 24 42 00 01 02 47 38 21 30 71 00 0F AC E2 00 34 2E 22 00 08 10 40 00 06 26 97 00 01 26 31 00 5A 02 71 88 21 92 22 00 00 10 00 00 0B 02 22 88 21 8F 99 ?? ?? 30 63 00 07 27 39 ?? ?? 03 23 18 21 90 64 00 00 8F 99 ?? ?? ?? ?? ?? ?? 34 84 03 00 8F BC 00 10 00 40 88 21 10 00 FF A9 02 E0 A0 21 24 02 00 10 14 82 00 3B 30 63 00 0F 30 7E 00 FF 03 D3 10 21 90 4A 00 1D 90 4B 00 1A 01 40 B8 21 35 6B 03 00 8F 99 ?? ?? 26 F7 FF FF 01 77 20 21 AF AA 00 68 ?? ?? ?? ?? AF AB 00 6C 8F BC 00 10 00 40 20 21 AF A2 00 60 8F 99 ?? ?? ?? ?? ?? ?? 00 40 B0 21 8F BC 00 10 02 00 20 21 02 C0 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 30 21 8F BC 00 10 8F AA 00 68 14 40 00 1B 8F AB 00 6C 82 C2 00 00 10 40 00 18 00 00 00 00 8F A2 00 60 24 44 00 01 AF A4 00 60 80 42 00 01 14 40 FF FB 26 10 00 01 57 C0 00 09 00 0A 50 42 24 02 00 0C 72 E2 18 02 8F A2 00 3C 04 40 FF 7A AF A3 00 38 00 43 18 21 10 00 FF 77 AF A3 00 20 02 EA 00 1A 01 40 01 F4 00 1E 48 C0 02 49 48 21 00 00 10 10 10 00 FF 70 AD 22 00 08 16 E0 FF D0 8F 99 ?? ?? 10 00 00 91 00 00 10 21 24 02 00 20 14 82 00 34 00 03 48 40 54 60 FF 68 82 24 00 00 8F 99 ?? ?? ?? ?? ?? ?? AF B0 00 60 8C 43 00 00 8F BC 00 10 AC 40 00 00 00 40 B8 21 82 02 00 00 8E A4 00 00 00 02 10 40 00 82 10 21 94 42 00 00 30 42 00 20 14 40 00 0B 8F BE 00 60 8F 99 ?? ?? AF A3 00 68 02 00 20 21 27 A5 00 60 ?? ?? ?? ?? 24 06 00 0A 8F BC 00 10 8F A3 00 68 AF A2 00 5C 8F BE 00 60 13 D0 00 71 00 00 10 21 8E E2 00 00 10 40 00 03 8F 99 ?? ?? 10 00 00 6C 00 00 10 21 8F A5 00 A8 27 A4 00 5C ?? ?? ?? ?? AE E3 00 00 8F BC 00 10 00 00 10 21 24 04 00 08 8F A7 00 A8 00 02 18 80 02 43 28 21 00 E3 18 21 8C 63 00 00 24 42 00 01 14 44 FF F9 AC A3 00 00 10 00 FF 36 03 C0 80 21 25 29 00 3A 02 69 48 21 91 22 00 01 28 43 00 03 10 60 00 07 24 03 FF FF 38 42 00 01 24 03 01 6E 24 04 27 0F 00 82 18 0B 00 60 10 21 24 03 FF FF 24 06 00 0A 82 04 00 00 24 84 FF D0 30 85 00 FF 2C A5 00 0A 10 A0 00 09 00 03 28 27 00 05 18 0A 70 66 28 02 00 A4 18 21 00 43 20 2A 14 80 FF D5 26 10 00 01 10 00 FF F4 82 04 00 00 91 22 00 00 30 44 00 01 00 64 20 2A 14 80 FF CE 7C 44 00 40 00 64 18 23 24 64 F8 94 30 45 00 04 00 85 18 0B 24 04 00 49 14 44 00 08 00 02 20 C2 38 64 00 0C 00 04 18 0A 8F A4 00 38 04 80 00 02 00 64 20 21 AF A4 00 20 00 02 20 C2 00 04 20 80 24 42 FF B0 02 44 20 21 2C 42 00 09 10 40 FF 02 AC 83 00 00 8F A2 00 40 04 43 00 05 8F A3 00 44 28 64 00 45 24 62 00 64 10 00 00 07 00 44 18 0B 24 42 FF ED 28 64 00 00 00 04 18 0B 24 04 00 64 70 44 28 02 00 A3 18 21 10 00 FE F3 AF A3 00 2C 00 40 88 21 82 22 00 00 8E A3 00 00 00 02 20 40 00 64 20 21 94 84 00 00 30 84 00 20 10 80 00 0A 26 31 00 01 82 02 00 00 00 02 10 40 00 62 10 21 94 42 00 00 30 42 00 20 50 40 FE E4 82 24 00 00 10 00 FF F8 26 10 00 01 82 03 00 00 14 62 FF 96 26 04 00 01 10 00 FE DC 00 80 80 21 8F BF 00 9C 8F BE 00 98 8F B7 00 94 8F B6 00 90 8F B5 00 8C 8F B4 00 88 8F B3 00 84 8F B2 00 80 8F B1 00 7C 8F B0 00 78 03 E0 00 08 27 BD 00 A0 }
	condition:
		$1
}

rule file_478_0_0 {
	meta:
		name = "epoll_create"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 98 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_478_1_0 {
	meta:
		name = "epoll_ctl"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 99 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_478_2_0 {
	meta:
		name = "epoll_wait"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 9A 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_480_1_0 {
	meta:
		name = "scan_getwc"
		size = 324
		refs = "0000 _gp_disp 0064 __scan_getc 0068 __GI_mbrtowc 00e4 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B0 00 24 AF BC 00 10 AF BF 00 44 AF B7 00 40 AF B6 00 3C AF B5 00 38 AF B4 00 34 AF B3 00 30 AF B2 00 2C AF B1 00 28 8C 92 00 10 00 80 80 21 26 52 FF FF 06 41 00 06 AC 92 00 10 90 82 00 19 34 42 00 02 A0 82 00 19 10 00 00 2F 24 02 FF FF 3C 02 7F FF 8F 93 ?? ?? 8F 97 ?? ?? 34 42 FF FF AC 82 00 10 24 11 FF FD 27 B4 00 1C 24 95 00 1C 27 B6 00 18 02 60 C8 21 ?? ?? ?? ?? 02 00 20 21 04 40 00 12 8F BC 00 10 8E 02 00 00 02 C0 20 21 02 80 28 21 A3 A2 00 1C 24 06 00 01 02 E0 C8 21 ?? ?? ?? ?? 02 A0 38 21 00 40 88 21 04 40 00 04 8F BC 00 10 8F A2 00 18 10 00 00 11 AE 02 00 24 24 02 FF FE 12 22 FF EC 02 60 C8 21 24 02 FF FD 16 22 00 05 8F 99 ?? ?? 24 02 FF FF AE 02 00 24 10 00 00 07 24 11 FF FF ?? ?? ?? ?? 00 00 00 00 24 03 00 58 AC 43 00 00 24 02 00 01 A2 02 00 1B AE 12 00 10 02 20 10 21 8F BF 00 44 8F B7 00 40 8F B6 00 3C 8F B5 00 38 8F B4 00 34 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_480_2_0 {
	meta:
		name = "__GI_vfscanf"
		size = 1964
		refs = "0000 _gp_disp 0010 __GI_memset 007c _pthread_cleanup_push_defer 0080 __pthread_mutex_unlock 0098 __pthread_mutex_lock 00a8 __init_scan_cookie 0104 __GI___ctype_b 016c __scan_getc 018c __psfs_parse_spec 0268 __scan_ungetc 02b8 _store_inttype 02dc __psfs_do_numeric 0544 scan_getwc 072c __GI_ungetc 0768 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FD C8 8F 99 ?? ?? 27 A3 01 18 24 02 FF FF AF BC 00 10 AF B4 02 20 AF B3 02 1C AF B0 02 10 00 80 A0 21 AF BF 02 34 AF BE 02 30 AF B7 02 2C AF B6 02 28 AF B5 02 24 AF B2 02 18 AF B1 02 14 00 A0 80 21 00 C0 98 21 AF A2 01 3C AF A3 01 FC 00 60 20 21 00 00 28 21 ?? ?? ?? ?? 24 06 00 24 8E 99 00 34 8F BC 00 10 17 20 00 0C AF B9 02 00 8F 99 ?? ?? 8F 85 ?? ?? 26 91 00 38 27 A4 01 E4 ?? ?? ?? ?? 02 20 30 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8F 99 ?? ?? 27 B1 01 A4 02 20 20 21 ?? ?? ?? ?? 02 80 28 21 8F BC 00 10 3C 16 7F FF 24 12 00 01 8F 82 ?? ?? 36 D6 FF FF 24 42 ?? ?? AF A2 01 D0 8F A2 01 AC 90 42 00 03 AF A0 01 4C A3 A2 01 BC 8F A2 01 D4 AF A2 01 E0 92 02 00 00 10 40 01 7B 24 03 00 01 A3 A3 01 5C 93 A3 01 BD 8F 9E ?? ?? 00 02 20 40 30 63 00 01 A3 A3 01 BD 8F C3 00 00 A3 A0 01 5D AF B6 01 58 AF B6 01 B4 00 64 20 21 94 84 00 00 30 84 00 20 50 80 00 0D 24 03 00 25 92 02 00 01 00 02 10 40 00 62 10 21 94 42 00 00 30 42 00 20 10 40 00 03 26 04 00 01 10 00 FF F8 00 80 80 21 24 02 00 17 10 00 00 33 AF A2 01 54 14 43 01 4D 8F 99 ?? ?? 92 03 00 01 14 62 00 05 26 17 00 01 24 02 00 16 AF A2 01 54 10 00 00 23 02 E0 80 21 8F 99 ?? ?? AF B7 01 48 ?? ?? ?? ?? 27 A4 01 18 04 40 01 50 8F BC 00 10 02 E2 80 21 93 A2 01 5C 10 40 00 1A 8F A2 01 54 8F A4 01 3C 24 03 FF FE 14 83 00 05 27 A2 00 18 8E 62 00 00 26 73 00 04 10 00 00 11 AF A2 01 44 8F A3 01 40 8F A4 01 3C 00 83 28 2A 10 A0 00 08 24 84 00 01 8E 63 00 00 AF A4 01 3C 00 04 20 80 00 44 20 21 AC 83 01 00 10 00 FF F5 26 73 00 04 00 03 18 80 00 43 10 21 8C 42 01 00 AF A2 01 44 8F A2 01 54 3C 03 00 2D 34 63 00 01 00 43 10 07 30 42 00 01 14 40 00 17 8F A7 01 58 8F 97 ?? ?? 02 E0 C8 21 ?? ?? ?? ?? 02 20 20 21 04 40 00 09 8F BC 00 10 8F A2 01 A4 8F C3 00 00 00 02 10 40 00 62 10 21 94 42 00 00 30 42 00 20 14 40 FF F5 02 E0 C8 21 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F A3 01 54 24 02 00 17 10 62 01 12 8F BC 00 10 8F A7 01 58 10 E0 01 16 AF A7 01 B4 8F B7 01 54 24 02 00 16 12 E2 01 01 8F 99 ?? ?? 16 E0 00 0C 2A E2 00 10 93 A2 01 5C 50 40 01 07 96 82 00 00 8F A7 01 B0 8F 99 ?? ?? 8F A4 01 44 8F A5 01 50 ?? ?? ?? ?? 00 07 37 C3 10 00 00 FE 8F BC 00 10 10 40 00 0C 2A E2 00 12 8F 99 ?? ?? 27 A4 01 18 ?? ?? ?? ?? 02 20 28 21 24 03 FF FF 10 43 00 FC 8F BC 00 10 04 41 00 F3 00 00 90 21 10 00 00 F9 96 82 00 00 14 40 00 82 8F A2 01 44 93 A4 01 5C 27 B5 01 60 00 44 A8 0B 24 02 00 13 16 E2 00 10 24 02 00 14 14 F6 00 03 8F 97 ?? ?? 24 02 00 01 AF A2 01 B4 02 E0 C8 21 ?? ?? ?? ?? 02 20 20 21 04 40 00 8A 8F BC 00 10 8F A2 01 A4 00 00 90 21 A2 A2 00 00 93 A2 01 5C 10 00 FF F6 02 A2 A8 21 56 E2 00 17 92 04 00 01 8F 99 ?? ?? 24 17 00 01 AF B9 02 04 03 20 F8 09 02 20 20 21 8F BC 00 10 04 40 00 5C 8F B9 02 04 8F A2 01 A4 8F C5 00 00 00 02 20 40 00 A4 20 21 94 84 00 00 30 84 00 20 54 80 00 55 8F 99 ?? ?? A2 A2 00 00 93 A2 01 5C 00 00 B8 21 00 00 90 21 10 00 FF ED 02 A2 A8 21 24 02 00 5E 10 82 00 03 00 00 18 21 10 00 00 03 26 10 00 01 26 10 00 02 24 03 00 01 8F 99 ?? ?? 27 A8 00 18 01 00 20 21 00 60 28 21 AF A3 02 04 AF A7 02 08 ?? ?? ?? ?? 24 06 01 00 8F A3 02 04 92 04 00 00 00 40 40 21 38 63 00 01 24 02 00 5D 8F BC 00 10 AF A3 01 F8 14 82 00 03 8F A7 02 08 A3 A3 00 75 26 10 00 01 24 05 00 5D 24 06 00 2D 92 02 00 00 50 45 00 1A 24 02 00 12 50 40 00 A9 96 82 00 00 14 46 00 12 8F B9 01 F8 92 04 00 01 50 85 00 10 26 10 00 01 92 02 FF FF 00 44 48 2B 51 20 00 0B 92 02 00 00 26 10 00 01 8F A3 01 F8 24 42 00 01 01 02 48 21 A1 23 00 00 00 44 48 2A 15 20 FF FB 8F A3 01 F8 92 02 00 00 8F B9 01 F8 26 10 00 01 01 02 10 21 10 00 FF E5 A0 59 00 00 12 E2 00 1B 8F A2 01 44 8F 9E ?? ?? 24 17 00 01 AF A8 02 04 03 C0 C8 21 ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 04 40 00 0B 8F A8 02 04 8F A2 01 A4 01 02 20 21 90 84 00 00 10 80 00 06 00 00 90 21 A2 A2 00 00 93 A2 01 5C 00 00 B8 21 10 00 FF F0 02 A2 A8 21 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 16 E0 00 77 8F BC 00 10 10 00 00 5F A2 A0 00 00 93 A4 01 5C 27 B5 01 F4 00 44 A8 0B 24 02 00 10 16 E2 00 1A AF A0 01 C0 14 F6 00 04 8F 99 ?? ?? 24 02 00 01 AF A2 01 B4 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 02 20 20 21 04 40 00 08 8F BC 00 10 8F A2 01 C8 00 00 90 21 AE A2 00 00 93 A2 01 5C 00 02 10 80 10 00 FF F4 02 A2 A8 21 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F A2 01 B4 18 40 00 42 8F BC 00 10 10 00 00 57 96 82 00 00 24 02 00 11 12 E2 00 03 24 17 00 01 10 00 00 27 27 BE 00 18 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 02 20 20 21 04 40 00 2C 8F BC 00 10 8F A2 01 C8 2C 44 01 00 50 80 00 09 AE A2 00 00 8F C5 00 00 00 02 20 40 00 A4 20 21 94 84 00 00 30 84 00 20 54 80 00 21 00 00 90 21 AE A2 00 00 93 A2 01 5C 00 00 B8 21 00 00 90 21 00 02 10 80 10 00 FF E9 02 A2 A8 21 8F A2 01 C8 2C 44 01 00 10 80 00 13 8F A3 01 F8 03 C2 20 21 90 84 00 00 10 80 00 12 00 00 90 21 AE A2 00 00 93 A2 01 5C 00 00 B8 21 00 00 90 21 00 02 10 80 02 A2 A8 21 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 02 20 20 21 04 41 FF ED 8F BC 00 10 10 00 00 05 8F 99 ?? ?? 50 60 FF F2 AE A2 00 00 00 00 90 21 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 16 E0 00 1B 8F BC 00 10 83 A2 01 BF 54 40 00 19 96 82 00 00 AE A0 00 00 8F A3 01 4C 93 A2 01 5C 00 62 10 21 10 00 00 0B AF A2 01 4C ?? ?? ?? ?? 02 20 20 21 92 03 00 00 10 43 00 06 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 10 00 00 08 8F BC 00 10 96 82 00 00 30 42 00 08 10 40 FE 87 26 10 00 01 10 00 00 03 96 82 00 00 02 E0 80 21 96 82 00 00 30 43 00 08 54 60 00 0A 24 02 FF FF 92 03 00 00 50 60 00 09 93 A2 01 BD 52 40 00 07 93 A2 01 BD 30 42 00 04 10 40 00 04 93 A2 01 BD 24 02 FF FF AF A2 01 4C 93 A2 01 BD 30 42 00 01 10 40 00 0E 8F A3 02 00 8F 99 ?? ?? 8F A4 01 A8 ?? ?? ?? ?? 8F A5 01 AC 8F A3 01 B0 8F BC 00 10 14 60 00 04 8F A2 01 AC 8F A3 01 B8 10 00 00 02 AC 43 00 28 AC 40 00 28 8F A3 02 00 14 60 00 06 8F BF 02 34 8F 99 ?? ?? 27 A4 01 E4 ?? ?? ?? ?? 24 05 00 01 8F BF 02 34 8F A2 01 4C 8F BE 02 30 8F B7 02 2C 8F B6 02 28 8F B5 02 24 8F B4 02 20 8F B3 02 1C 8F B2 02 18 8F B1 02 14 8F B0 02 10 03 E0 00 08 27 BD 02 38 }
	condition:
		$1
}

rule file_482_0_0 {
	meta:
		name = "exchange.constprop.2"
		size = 248
		refs = "0000 _gp_disp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 86 ?? ?? 24 C7 ?? ?? 8C E2 00 20 8C E3 00 24 8C C5 ?? ?? 00 C0 58 21 00 65 30 2A 10 C0 00 2B 00 43 30 2A 10 C0 00 29 00 A3 40 23 00 62 48 23 01 28 30 2A 14 C0 00 03 00 43 60 23 10 00 00 13 00 00 30 21 00 00 30 21 00 AC 60 21 00 C9 40 2A 11 00 00 0C 00 46 50 21 01 86 40 21 00 0A 50 80 00 08 40 80 00 8A 50 21 00 88 40 21 8D 4D 00 00 8D 0E 00 00 24 C6 00 01 AD 4E 00 00 10 00 FF F3 AD 0D 00 00 10 00 FF E4 00 A9 28 23 00 C8 48 2A 11 20 00 0C 00 46 50 21 00 66 48 21 00 0A 50 80 00 09 48 80 00 8A 50 21 00 89 48 21 8D 4C 00 00 8D 2D 00 00 24 C6 00 01 AD 4D 00 00 10 00 FF F3 AD 2C 00 00 10 00 FF D4 00 48 10 21 8D 62 ?? ?? 8C E3 00 24 8C E4 00 20 AC E2 00 24 00 43 18 23 00 83 18 21 03 E0 00 08 AC E3 00 20 }
	condition:
		$1
}

rule file_482_1_0 {
	meta:
		name = "_getopt_internal"
		size = 2176
		refs = "0000 _gp_disp 000c opterr 0048 optind 00b8 __GI_getenv 00b4 $LC0 018c exchange.constprop.2 01f8 __GI_strcmp 01f0 $LC1 0318 __GI_strchr 0380 __GI_strncmp 03cc __GI_strlen 0498 stderr 04ac __GI_fprintf 04bc $LC3 04d8 $LC4 054c $LC5 05f4 $LC2 06e8 $LC9 06f8 $LC10 076c $LC11 07d0 optopt 07dc optarg 083c $LC6 0858 $LC7 0874 $LC8"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 83 ?? ?? 27 BD FF 90 AF B5 00 5C AF B4 00 58 AF B3 00 54 AF B2 00 50 AF B0 00 48 AF BC 00 18 AF BF 00 6C AF BE 00 68 AF B7 00 64 AF B6 00 60 AF B1 00 4C 8C 63 00 00 00 80 A8 21 8F 84 ?? ?? AF A3 00 20 8F 90 ?? ?? 8F B9 00 20 8C 82 00 00 26 03 ?? ?? AC 79 00 04 AE 02 ?? ?? 00 A0 90 21 80 C5 00 00 00 C0 98 21 00 60 A0 21 38 A4 00 3A 00 04 C8 0A 1A A0 00 7A AF B9 00 20 00 E0 88 21 10 40 00 06 AC 60 00 08 8C 62 00 10 50 40 00 06 8E 02 ?? ?? 10 00 00 22 8E 82 00 1C 24 02 00 01 AE 02 ?? ?? 8E 02 ?? ?? 8F 84 ?? ?? 8F 99 ?? ?? AE 82 00 24 24 84 ?? ?? AE 82 00 20 ?? ?? ?? ?? AE 80 00 1C 00 02 10 2B 8F BC 00 18 AE 82 00 18 82 64 00 00 24 05 00 2D 14 85 00 04 24 05 00 2B 24 02 00 02 10 00 00 04 AE 82 00 14 14 85 00 04 00 00 00 00 AE 80 00 14 10 00 00 06 26 73 00 01 10 40 00 03 24 02 00 01 10 00 00 03 AE 80 00 14 AE 82 00 14 24 02 00 01 AE 82 00 10 8E 82 00 1C 50 40 00 04 8E 02 ?? ?? 80 42 00 00 14 40 00 68 8E 02 ?? ?? 8E 84 00 24 00 44 20 2A 54 80 00 01 AE 82 00 24 8E 84 00 20 00 44 20 2A 54 80 00 01 AE 82 00 20 8E 85 00 14 24 04 00 01 14 A4 00 1F 8E 16 ?? ?? 8E 85 00 24 8E 84 00 20 10 85 00 08 00 00 00 00 10 A2 00 08 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 02 40 20 21 10 00 00 03 8F BC 00 18 54 82 00 01 AE 82 00 20 24 05 00 2D 8E 02 ?? ?? 00 55 20 2A 10 80 00 0B 00 02 20 80 02 44 20 21 8C 84 00 00 80 86 00 00 50 C5 00 04 80 84 00 01 24 42 00 01 10 00 FF F5 AE 02 ?? ?? 50 80 FF FD 24 42 00 01 AE 82 00 24 8E 16 ?? ?? 12 D5 00 18 00 16 10 80 8F 85 ?? ?? 02 42 10 21 8F 99 ?? ?? 8C 44 00 00 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 00 10 8F BC 00 18 8F 82 ?? ?? 26 D6 00 01 8E 84 00 20 AC 56 ?? ?? 8E 82 00 24 50 82 00 07 AE 96 00 20 10 56 00 05 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 02 40 20 21 8F BC 00 18 AE 95 00 24 AE 15 ?? ?? 8E 04 ?? ?? 14 95 00 08 00 04 30 80 8E 82 00 20 8E 84 00 24 10 44 00 02 8F 84 ?? ?? AC 82 ?? ?? 10 00 01 56 24 02 FF FF 02 46 30 21 8C C2 00 00 24 05 00 2D 80 47 00 00 54 E5 00 05 8E 82 00 14 80 45 00 01 14 A0 00 0A 00 00 00 00 8E 82 00 14 10 40 FF F3 24 84 00 01 8F 82 ?? ?? AC 44 ?? ?? 8C C2 00 00 AE 82 00 08 10 00 01 44 24 02 00 01 12 20 00 03 38 A4 00 2D 10 00 00 02 2C 84 00 01 00 00 20 21 24 84 00 01 00 44 10 21 AE 82 00 1C 12 20 00 E6 8E 1E ?? ?? 24 02 00 2D 00 1E 60 80 02 4C 60 21 8D 96 00 00 82 C3 00 01 10 62 00 0F AF A3 00 24 8F B9 00 84 53 20 00 DD 8E 96 00 1C 82 C2 00 02 54 40 00 0A 8E 97 00 1C 8F 99 ?? ?? AF AC 00 40 02 60 20 21 ?? ?? ?? ?? 00 60 28 21 8F BC 00 18 14 40 00 D1 8F AC 00 40 8E 97 00 1C 24 04 00 3D 02 E0 48 21 81 22 00 00 10 40 00 05 24 03 FF FF 10 44 00 04 01 37 C8 23 10 00 FF FA 25 29 00 01 01 37 C8 23 00 00 58 21 AF A3 00 28 00 00 50 21 00 00 40 21 AF B9 00 2C 8E 2D 00 00 11 A0 00 35 8F 99 ?? ?? 8F A6 00 2C 01 A0 20 21 AF A8 00 38 AF A9 00 34 AF AA 00 3C AF AB 00 44 AF AC 00 40 AF AD 00 30 ?? ?? ?? ?? 02 E0 28 21 8F BC 00 18 8F A8 00 38 8F A9 00 34 8F AA 00 3C 8F AB 00 44 8F AC 00 40 14 40 00 20 8F AD 00 30 8F 99 ?? ?? ?? ?? ?? ?? 01 A0 20 21 8F A3 00 2C 8F BC 00 18 8F A8 00 38 8F A9 00 34 8F AA 00 3C 8F AB 00 44 10 62 00 1D 8F AC 00 40 51 00 00 12 AF AB 00 28 8F B9 00 84 57 20 00 10 24 0A 00 01 8D 04 00 04 8E 22 00 04 54 82 00 0C 24 0A 00 01 8D 04 00 08 8E 22 00 08 54 82 00 08 24 0A 00 01 8E 22 00 0C 8D 04 00 0C 00 82 20 26 24 02 00 01 10 00 00 02 00 44 50 0B 02 20 40 21 26 31 00 10 10 00 FF CA 25 6B 00 01 15 40 00 64 8F A3 00 20 8F AB 00 28 11 00 00 79 01 00 88 21 27 C2 00 01 AE 02 ?? ?? 81 25 00 00 8F 96 ?? ?? 10 A0 00 25 8E 24 00 04 10 80 00 04 8F B9 00 20 25 29 00 01 10 00 00 45 AE 89 00 08 13 20 00 14 8F 84 ?? ?? 8D 85 00 00 24 07 00 2D 80 A8 00 01 8E 46 00 00 8F 99 ?? ?? 8E 22 00 00 15 07 00 07 8C 84 00 00 8F 85 ?? ?? 00 40 38 21 ?? ?? ?? ?? 24 A5 ?? ?? 10 00 00 06 00 00 00 00 80 A7 00 00 8F 85 ?? ?? AF A2 00 10 ?? ?? ?? ?? 24 A5 ?? ?? 8E 92 00 1C 02 C0 C8 21 ?? ?? ?? ?? 02 40 20 21 02 42 10 21 8F BC 00 18 AE 82 00 1C 8E 22 00 0C 10 00 00 4D AE 82 00 0C 24 05 00 01 54 85 00 24 AF AB 00 44 00 55 A8 2A 12 A0 00 07 8F A3 00 20 8F 82 ?? ?? 27 DE 00 02 AC 5E ?? ?? 8D 82 00 04 10 00 00 1A AE 82 00 08 50 60 00 0A 8E 92 00 1C 8F 82 ?? ?? 8F 85 ?? ?? 8E 46 00 00 8C 44 00 00 8D 87 00 00 8F 99 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? 8E 92 00 1C 02 C0 C8 21 ?? ?? ?? ?? 02 40 20 21 02 42 10 21 8F BC 00 18 AE 82 00 1C 8E 22 00 0C 24 04 00 3F AE 82 00 0C 82 65 00 00 24 02 00 3A 38 A5 00 3A 10 00 00 8A 00 85 10 0B AF AB 00 44 02 C0 C8 21 ?? ?? ?? ?? 02 E0 20 21 8F A3 00 80 02 E2 10 21 8F BC 00 18 AE 82 00 1C 10 60 00 02 8F AB 00 44 AC 6B 00 00 8E 24 00 08 10 80 00 7C 8E 22 00 0C AC 82 00 00 10 00 00 79 00 00 10 21 50 60 00 0B 8E 91 00 1C 8F 82 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 8C 44 00 00 8E 46 00 00 24 A5 ?? ?? ?? ?? ?? ?? 02 C0 38 21 8F BC 00 18 8E 91 00 1C 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BC 00 18 02 22 10 21 AE 82 00 1C 8E 02 ?? ?? AE 80 00 0C 24 42 00 01 AE 02 ?? ?? 10 00 00 61 24 02 00 3F 8F B9 00 84 13 20 00 74 8F B9 00 20 8F A3 00 24 24 02 00 2D 10 62 00 6F 8F 99 ?? ?? 82 E5 00 00 ?? ?? ?? ?? 02 60 20 21 10 40 00 6A 8F BC 00 18 8E 96 00 1C 8F 99 ?? ?? 02 60 20 21 26 D7 00 01 AE 97 00 1C 82 D1 00 00 8F 9E ?? ?? ?? ?? ?? ?? 02 20 28 21 82 C4 00 01 14 80 00 04 8F BC 00 18 8F C4 ?? ?? 24 84 00 01 AF C4 ?? ?? 10 40 00 05 8F B9 00 20 24 05 00 3A 56 25 00 15 80 44 00 01 8F B9 00 20 53 20 FF DC AE 91 00 0C 8E 84 00 18 8F 82 ?? ?? 8E 46 00 00 10 80 00 05 8F 99 ?? ?? 8F 85 ?? ?? 8C 44 00 00 10 00 00 04 24 A5 ?? ?? 8F 85 ?? ?? 8C 44 00 00 24 A5 ?? ?? ?? ?? ?? ?? 02 20 38 21 8F BC 00 18 10 00 FF CB AE 91 00 0C 54 85 00 2B 02 20 10 21 80 45 00 02 14 A4 00 05 82 C2 00 01 14 40 00 05 8E 02 ?? ?? 10 00 00 22 AE 80 00 08 10 40 00 05 8E 02 ?? ?? AE 97 00 08 24 42 00 01 10 00 00 1C AE 02 ?? ?? 14 55 00 14 8F 84 ?? ?? 8F A3 00 20 50 60 00 0B AE 91 00 0C 8F 82 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 8C 44 00 00 8E 46 00 00 24 A5 ?? ?? ?? ?? ?? ?? 02 20 38 21 8F BC 00 18 AE 91 00 0C 82 64 00 00 24 11 00 3A 24 02 00 3F 38 84 00 3A 10 00 00 07 00 44 88 0B 24 45 00 01 00 02 10 80 AC 85 ?? ?? 02 42 90 21 8E 42 00 00 AE 82 00 08 AE 80 00 1C 02 20 10 21 8E 04 ?? ?? 8F 85 ?? ?? 8F 83 ?? ?? AC A4 00 00 8E 85 00 08 8F 84 ?? ?? AC 85 00 00 8E 84 00 0C AC 64 00 00 8F BF 00 6C 8F BE 00 68 8F B7 00 64 8F B6 00 60 8F B5 00 5C 8F B4 00 58 8F B3 00 54 8F B2 00 50 8F B1 00 4C 8F B0 00 48 03 E0 00 08 27 BD 00 70 8F B9 00 20 13 20 00 14 8F A3 00 24 24 04 00 2D 8F 82 ?? ?? 8E 46 00 00 14 64 00 08 8F 99 ?? ?? 8F 85 ?? ?? 8C 44 00 00 02 E0 38 21 ?? ?? ?? ?? 24 A5 ?? ?? 10 00 00 08 8F BC 00 18 8F 85 ?? ?? 8C 44 00 00 82 C7 00 00 24 A5 ?? ?? ?? ?? ?? ?? AF B7 00 10 8F BC 00 18 8F 82 ?? ?? 10 00 FF 6C 24 42 ?? ?? }
	condition:
		$1
}

rule file_482_2_0 {
	meta:
		name = "__GI_getopt"
		size = 56
		refs = "0000 _gp_disp 000c _getopt_internal"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BF 00 24 AF BC 00 18 AF A0 00 10 AF A0 00 14 ?? ?? ?? ?? 00 00 38 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_482_3_0 {
	meta:
		name = "getopt_long"
		size = 60
		refs = "0000 _gp_disp 0014 _getopt_internal"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 8F A2 00 38 8F 99 ?? ?? AF BF 00 24 AF BC 00 18 AF A2 00 10 AF A0 00 14 ?? ?? ?? ?? 00 00 00 00 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_482_4_0 {
	meta:
		name = "getopt_long_only"
		size = 64
		refs = "0000 _gp_disp 0014 _getopt_internal"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 8F A2 00 38 8F 99 ?? ?? AF BF 00 24 AF A2 00 10 24 02 00 01 AF BC 00 18 AF A2 00 14 ?? ?? ?? ?? 00 00 00 00 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_483_0_0 {
	meta:
		name = "__GI_nl_langinfo"
		size = 96
		refs = "0000 _gp_disp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 00 04 1A 03 2C 65 00 06 10 A0 00 0F 24 42 ?? ?? 00 43 18 21 90 65 00 00 90 63 00 01 30 84 00 FF 00 A4 20 21 00 83 18 2B 10 60 00 07 30 83 00 40 00 82 20 21 90 84 00 07 00 03 18 40 24 63 00 61 00 64 18 21 00 43 10 21 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_484_0_0 {
	meta:
		name = "__GI_wcscmp"
		size = 56
	strings:
		$1 = { 8C 82 00 00 8C A3 00 00 54 43 00 05 00 43 18 2B 10 40 00 07 24 84 00 04 10 00 FF F9 24 A5 00 04 24 04 00 01 24 02 FF FF 03 E0 00 08 00 83 10 0A 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_485_0_0 {
	meta:
		name = "__libc_longjmp"
		size = 92
		refs = "0000 _gp_disp 0030 __GI_sigprocmask 0048 __GI___longjmp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B1 00 20 AF B0 00 1C AF BC 00 10 AF BF 00 24 8C 82 00 68 00 80 80 21 10 40 00 07 00 A0 88 21 8F 99 ?? ?? 24 04 00 03 26 05 00 6C ?? ?? ?? ?? 00 00 30 21 8F BC 00 10 8F 99 ?? ?? 24 05 00 01 02 00 20 21 ?? ?? ?? ?? 02 31 28 0B }
	condition:
		$1
}

rule file_488_0_0 {
	meta:
		name = "tcsendbreak"
		size = 64
		refs = "0000 _gp_disp 0010 __GI_ioctl"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 1C A0 00 04 8F 99 ?? ?? 24 05 54 05 10 00 00 07 00 00 30 21 24 A6 00 63 24 02 00 64 00 C2 00 1A 00 40 01 F4 24 05 54 86 00 00 30 12 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_489_0_0 {
	meta:
		name = "munlock"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 3B 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_490_0_0 {
	meta:
		name = "__exit_handler"
		size = 220
		refs = "0000 _gp_disp 0018 __exit_function_table 001c __exit_count 00d0 free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 AF B2 00 20 AF B0 00 18 8F 92 ?? ?? 8F 90 ?? ?? AF B4 00 28 AF B3 00 24 AF B1 00 1C AF BC 00 10 AF BF 00 2C 00 80 88 21 24 13 00 02 24 14 00 03 8E 02 00 00 10 40 00 1A 24 42 FF FF 8E 43 00 00 AE 02 00 00 00 02 11 00 00 62 10 21 8C 43 00 00 50 73 00 05 8C 59 00 04 50 74 00 0A 8C 59 00 04 10 00 FF F4 8E 02 00 00 53 20 FF F2 8E 02 00 00 8C 45 00 08 03 20 F8 09 02 20 20 21 10 00 00 06 8F BC 00 10 53 20 FF EB 8E 02 00 00 03 20 F8 09 8C 44 00 08 8F BC 00 10 10 00 FF E6 8E 02 00 00 8F 82 ?? ?? 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 8C 44 00 00 8F 99 ?? ?? ?? ?? ?? ?? 27 BD 00 30 }
	condition:
		$1
}

rule file_490_1_0 {
	meta:
		name = "__new_exitfn"
		size = 280
		refs = "0000 _gp_disp 0010 __pthread_mutex_unlock 0014 _pthread_cleanup_push_defer 0018 __atexit_lock 0048 __pthread_mutex_lock 0058 __exit_slots 005c __exit_count 0070 __exit_function_table 0074 realloc 0090 __GI___errno_location 00bc __exit_handler 00c0 __exit_cleanup 00e8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 8F 85 ?? ?? 8F 99 ?? ?? 8F 86 ?? ?? AF B2 00 34 27 B2 00 18 AF BC 00 10 AF BF 00 3C AF B3 00 38 AF B1 00 30 AF B0 00 2C ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 91 ?? ?? 8F 93 ?? ?? 8E 25 00 00 8E 62 00 00 00 45 10 2A 14 40 00 13 8F 90 ?? ?? 8F 99 ?? ?? 8E 04 00 00 24 A5 00 14 ?? ?? ?? ?? 00 05 29 00 14 40 00 08 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 80 21 24 03 00 0C 8F BC 00 10 10 00 00 10 AC 43 00 00 AE 02 00 00 8E 22 00 00 24 42 00 14 AE 22 00 00 8F 83 ?? ?? 8F 82 ?? ?? 8E 10 00 00 AC 43 00 00 8E 62 00 00 24 43 00 01 00 02 11 00 02 02 80 21 24 02 00 01 AE 63 00 00 AE 02 00 00 8F 99 ?? ?? 02 40 20 21 ?? ?? ?? ?? 24 05 00 01 8F BF 00 3C 02 00 10 21 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_491_0_0 {
	meta:
		name = "__GI_fputwc_unlocked"
		size = 76
		refs = "0000 _gp_disp 000c _wstdio_fwrite"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 00 A0 30 21 24 05 00 01 AF BF 00 1C AF BC 00 10 AF A4 00 20 ?? ?? ?? ?? 27 A4 00 20 8F A4 00 20 8F BF 00 1C 24 03 FF FF 00 82 18 0B 00 60 10 21 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_492_0_0 {
	meta:
		name = "token"
		size = 692
		refs = "0000 _gp_disp 0050 __GI___fgetc_unlocked 0238 __GI_strcmp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF B1 00 20 8F 91 ?? ?? AF BC 00 10 AF BF 00 3C 8E 22 ?? ?? AF B7 00 38 AF B6 00 34 AF B5 00 30 AF B4 00 2C AF B3 00 28 AF B2 00 24 AF B0 00 1C 94 43 00 00 30 63 00 0C 14 60 00 8F 00 00 10 21 8F 90 ?? ?? 24 12 FF FF 24 13 00 20 24 14 00 2C 8E 24 ?? ?? 8C 82 00 10 8C 83 00 18 00 43 18 2B 10 60 00 04 24 43 00 01 AC 83 00 10 10 00 00 08 90 42 00 00 02 00 C8 21 ?? ?? ?? ?? 00 00 00 00 14 52 00 03 8F BC 00 10 10 00 00 7B 00 00 10 21 24 43 FF F7 2C 63 00 02 14 60 FF EE 8E 24 ?? ?? 50 53 FF ED 8C 82 00 10 10 54 FF EA 24 03 00 22 14 43 00 28 8F 92 ?? ?? 8F 93 ?? ?? 26 50 ?? ?? 24 15 FF FF 24 14 00 22 24 16 00 5C 8E 24 ?? ?? 8C 82 00 10 8C 83 00 18 00 43 18 2B 10 60 00 04 24 43 00 01 AC 83 00 10 10 00 00 06 90 42 00 00 02 60 C8 21 ?? ?? ?? ?? 00 00 00 00 10 55 00 45 8F BC 00 10 50 54 00 44 A2 00 00 00 54 56 00 0F A2 02 00 00 8E 24 ?? ?? 8C 82 00 10 8C 83 00 18 00 43 18 2B 10 60 00 04 24 43 00 01 AC 83 00 10 10 00 00 05 90 42 00 00 02 60 C8 21 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 A2 02 00 00 10 00 FF DF 26 10 00 01 8F 90 ?? ?? 8F 93 ?? ?? A2 42 ?? ?? 26 10 ?? ?? 24 15 FF FF 24 16 00 20 24 14 00 2C 24 17 00 5C 8E 24 ?? ?? 8C 82 00 10 8C 83 00 18 00 43 18 2B 10 60 00 04 24 43 00 01 AC 83 00 10 10 00 00 06 90 42 00 00 02 60 C8 21 ?? ?? ?? ?? 00 00 00 00 10 55 00 1B 8F BC 00 10 24 43 FF F7 2C 63 00 02 54 60 00 18 A2 00 00 00 50 56 00 16 A2 00 00 00 50 54 00 14 A2 00 00 00 54 57 00 0F A2 02 00 00 8E 24 ?? ?? 8C 82 00 10 8C 83 00 18 00 43 18 2B 10 60 00 04 24 43 00 01 AC 83 00 10 10 00 00 05 90 42 00 00 02 60 C8 21 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 A2 02 00 00 10 00 FF D9 26 10 00 01 A2 00 00 00 82 42 ?? ?? 10 40 FF 9A 8F 95 ?? ?? 8F 96 ?? ?? 8F 93 ?? ?? 00 00 80 21 26 B5 ?? ?? 26 D6 ?? ?? 26 52 ?? ?? 24 14 00 07 00 10 88 C0 02 35 88 21 8E 24 00 00 02 40 28 21 02 60 C8 21 ?? ?? ?? ?? 02 C4 20 21 14 40 00 03 26 10 00 01 10 00 00 04 8E 22 00 04 16 14 FF F5 00 10 88 C0 24 02 00 0A 8F BF 00 3C 8F B7 00 38 8F B6 00 34 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_492_1_0 {
	meta:
		name = "__GI_ruserpass"
		size = 1280
		refs = "0000 _gp_disp 000c __GI_getuid 0058 __GI_geteuid 006c __GI_getgid 007c __GI_getegid 0094 __GI_getenv 0090 $LC0 00ac __GI_strlen 00d0 __GI_strcpy 00f4 __GI_strcat 00f0 $LC1 010c __GI_fopen 0108 $LC2 0128 __GI___errno_location 0148 __GI_printf 0144 $LC3 0160 __GI___fsetlocking 017c __GI_gethostname 0194 __GI_strchr 01d8 token 0224 __GI_strcasecmp 028c __GI_strncasecmp 02d8 __GI_fclose 035c malloc 0398 __GI_strcmp 03d0 __GI_fileno 03e4 __GI_fstat 036c $LC4 03b0 $LC5 0408 $LC6 0420 $LC7 0324 $LC8"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FB 20 AF BF 04 DC AF BE 04 D8 AF B7 04 D4 03 A0 F0 21 AF B6 04 D0 AF B2 04 C0 AF B0 04 B8 AF BC 00 10 AF B5 04 CC AF B4 04 C8 AF B3 04 C4 AF B1 04 BC 00 80 90 21 00 A0 B0 21 ?? ?? ?? ?? 00 C0 B8 21 8F DC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 40 80 21 16 02 01 17 8F DC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F DC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 40 80 21 16 02 01 0E 8F DC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 84 ?? ?? 00 40 88 21 10 40 01 07 8F DC 00 10 8F 93 ?? ?? 02 60 C8 21 ?? ?? ?? ?? 00 40 20 21 8F DC 00 10 24 42 00 16 00 02 10 C2 02 20 28 21 00 02 10 C0 8F 91 ?? ?? 03 A2 E8 23 27 B0 00 10 02 20 C8 21 ?? ?? ?? ?? 02 00 20 21 8F DC 00 10 02 00 20 21 8F 85 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? 8F DC 00 10 02 00 20 21 8F 85 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? 8F DC 00 10 8F 94 ?? ?? 14 40 00 0F AE 82 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 88 21 8C 43 00 00 24 02 00 02 10 62 00 E2 8F DC 00 10 8F 84 ?? ?? 8F 99 ?? ?? 02 00 28 21 ?? ?? ?? ?? 24 84 ?? ?? 10 00 00 DC 03 C0 E8 21 8F 99 ?? ?? 00 40 20 21 ?? ?? ?? ?? 24 05 00 02 8F DC 00 10 27 D0 00 18 02 00 20 21 8F 99 ?? ?? ?? ?? ?? ?? 24 05 04 00 04 41 00 02 8F DC 00 10 A3 C0 00 18 8F 91 ?? ?? 02 00 20 21 02 20 C8 21 ?? ?? ?? ?? 24 05 00 2E 00 40 A8 21 14 40 00 06 8F DC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F DC 00 10 02 02 A8 21 8F 93 ?? ?? 00 00 88 21 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 40 00 3B 8F DC 00 10 24 03 00 01 10 43 00 13 24 03 00 0B 14 43 FF F7 8F 99 ?? ?? 16 20 00 2C 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 0A 14 43 FF EF 8F DC 00 10 8F 90 ?? ?? 02 40 20 21 02 00 C8 21 ?? ?? ?? ?? 26 65 ?? ?? 14 40 00 05 8F DC 00 10 10 00 00 1F 26 70 ?? ?? 10 00 00 1C 24 11 00 01 8F 99 ?? ?? 02 40 20 21 ?? ?? ?? ?? 24 05 00 2E 10 40 FF DE 8F DC 00 10 00 40 20 21 02 A0 28 21 02 00 C8 21 ?? ?? ?? ?? AF C2 04 B0 8F DC 00 10 14 40 FF D6 8F C6 04 B0 8F 99 ?? ?? 00 D2 80 23 02 40 20 21 26 65 ?? ?? ?? ?? ?? ?? 02 00 30 21 14 40 FF CE 8F DC 00 10 26 66 ?? ?? 02 06 80 21 82 02 00 00 14 40 FF C9 00 00 88 21 26 70 ?? ?? 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 2C 43 00 02 10 60 00 07 8F DC 00 10 8E 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 88 21 10 00 00 7A 03 C0 E8 21 24 03 00 0B 10 43 FF F8 24 03 00 03 10 43 00 2E 28 43 00 04 50 60 00 06 28 42 00 06 24 03 00 02 10 43 00 07 8F 99 ?? ?? 10 00 00 66 8F 82 ?? ?? 14 40 FF E7 8F 99 ?? ?? 10 00 00 62 8F 82 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 40 FF DF 8F DC 00 10 8E C4 00 00 14 80 00 15 8F 99 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F DC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 24 44 00 01 14 40 00 05 8F DC 00 10 8F 84 ?? ?? 8F 99 ?? ?? 10 00 00 2C 24 84 ?? ?? 8F 99 ?? ?? 00 40 20 21 ?? ?? ?? ?? 02 00 28 21 AE C2 00 00 10 00 FF C8 8F DC 00 10 ?? ?? ?? ?? 02 00 28 21 10 40 FF C4 8F DC 00 10 10 00 FF 8A 8F 99 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 8E C4 00 00 ?? ?? ?? ?? 24 A5 ?? ?? 10 40 00 20 8F DC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 8E 84 ?? ?? 8F DC 00 10 00 40 20 21 8F 99 ?? ?? ?? ?? ?? ?? 27 C5 04 18 04 40 00 16 8F DC 00 10 8F C2 04 2C 30 42 00 3F 10 40 00 13 8F 99 ?? ?? 8F 90 ?? ?? 8F 84 ?? ?? 02 00 C8 21 ?? ?? ?? ?? 24 84 ?? ?? 8F DC 00 10 02 00 C8 21 8F 84 ?? ?? 24 84 ?? ?? ?? ?? ?? ?? 24 11 FF FF 8F DC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 8E 84 ?? ?? 10 00 00 22 03 C0 E8 21 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 40 FF 96 8F DC 00 10 8E E2 00 00 14 40 FF 94 8F 99 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F DC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 24 44 00 01 10 40 FF B8 8F DC 00 10 8F 99 ?? ?? 00 40 20 21 ?? ?? ?? ?? 02 00 28 21 AE E2 00 00 10 00 FF 83 8F DC 00 10 8F 99 ?? ?? 02 00 28 21 ?? ?? ?? ?? 24 44 ?? ?? 10 00 FF 7D 8F DC 00 10 24 11 FF FF 03 C0 E8 21 8F BF 04 DC 02 20 10 21 8F BE 04 D8 8F B7 04 D4 8F B6 04 D0 8F B5 04 CC 8F B4 04 C8 8F B3 04 C4 8F B2 04 C0 8F B1 04 BC 8F B0 04 B8 03 E0 00 08 27 BD 04 E0 }
	condition:
		$1
}

rule file_493_0_0 {
	meta:
		name = "__GI_abort"
		size = 344
		refs = "0000 _gp_disp 0018 __pthread_mutex_lock 003c __GI___sigaddset 0064 __GI_sigprocmask 008c __pthread_mutex_unlock 009c __GI_raise 00d0 __GI_sigaction 0138 __GI__exit"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A8 AF B1 00 50 8F 91 ?? ?? 8F 99 ?? ?? AF BF 00 54 AF BC 00 10 AF B0 00 4C ?? ?? ?? ?? 26 24 ?? ?? 8F BC 00 10 27 B0 00 34 02 00 20 21 8F 99 ?? ?? 24 05 00 06 AF A0 00 40 AF A0 00 3C AF A0 00 38 ?? ?? ?? ?? AF A0 00 34 8F BC 00 10 02 00 28 21 24 04 00 02 8F 99 ?? ?? ?? ?? ?? ?? 00 00 30 21 8F BC 00 10 8F 90 ?? ?? 8E 02 ?? ?? 14 40 00 10 8E 03 ?? ?? 24 02 00 01 AE 02 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 26 24 ?? ?? 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 24 04 00 06 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 24 ?? ?? 8F BC 00 10 8E 03 ?? ?? 24 04 00 01 14 64 00 12 8F 82 ?? ?? 24 03 00 02 8F 99 ?? ?? AC 43 ?? ?? 24 02 FF FF AF A0 00 18 AF A0 00 1C AF A0 00 30 AF A2 00 2C AF A2 00 28 AF A2 00 24 AF A2 00 20 24 04 00 06 27 A5 00 18 ?? ?? ?? ?? 00 00 30 21 10 00 FF E0 8F BC 00 10 24 04 00 02 14 64 00 05 8E 03 ?? ?? 24 03 00 03 AC 43 ?? ?? 00 FF 00 0D 8E 03 ?? ?? 24 02 00 03 14 62 00 06 8F 82 ?? ?? 8F 99 ?? ?? 24 03 00 04 AC 43 ?? ?? ?? ?? ?? ?? 24 04 00 7F 00 FF 00 0D 10 00 FF FE 00 00 00 00 }
	condition:
		$1
}

rule file_494_0_0 {
	meta:
		name = "__decode_dotted"
		size = 380
		refs = "0000 _gp_disp 00ec __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B0 AF BC 00 10 AF B2 00 30 AF BF 00 4C AF BE 00 48 AF B7 00 44 AF B6 00 40 AF B5 00 3C AF B4 00 38 AF B3 00 34 AF B1 00 2C AF B0 00 28 14 80 00 03 00 80 90 21 10 00 00 41 24 02 FF FF 00 E0 B0 21 00 C0 A0 21 00 00 20 21 00 00 80 21 24 13 00 01 24 07 FF C0 24 08 00 C0 24 09 00 2E 00 B4 10 2A 10 40 00 36 24 02 FF FF 24 A2 00 01 02 45 28 21 90 B1 00 00 12 20 00 30 00 13 18 2B 02 27 28 24 14 A8 00 0D 02 03 80 21 00 54 28 2A 10 A0 FF E9 02 03 80 21 02 42 10 21 90 42 00 00 32 25 00 3F 00 05 2A 00 00 A2 28 25 00 80 A8 21 00 00 98 21 10 00 FF EA 02 A0 20 21 8F A5 00 60 02 24 B8 21 26 F5 00 01 02 A5 18 2B 10 60 FF DA 02 22 F0 21 27 C3 00 01 00 74 18 2B 10 60 FF D6 8F 99 ?? ?? 02 42 28 21 AF A7 00 18 AF A8 00 1C AF A9 00 20 02 C4 20 21 ?? ?? ?? ?? 02 20 30 21 72 71 10 02 8F BC 00 10 03 C0 28 21 02 D7 B8 21 8F A7 00 18 8F A8 00 1C 00 50 80 21 02 5E 10 21 90 42 00 00 10 40 00 03 8F A9 00 20 10 00 FF E1 A2 E9 00 00 10 00 FF DF A2 E0 00 00 02 13 10 21 8F BF 00 4C 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_495_0_0 {
	meta:
		name = "__GI_setresuid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 59 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_496_0_0 {
	meta:
		name = "lsearch"
		size = 148
		refs = "0000 _gp_disp 0014 __GI_lfind 0054 __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 8F A2 00 48 8F 99 ?? ?? AF BC 00 18 AF B3 00 30 AF B2 00 2C AF B1 00 28 AF B0 00 24 AF BF 00 34 AF A2 00 10 00 80 90 21 00 A0 98 21 00 C0 80 21 ?? ?? ?? ?? 00 E0 88 21 14 40 00 0B 8F BC 00 18 8E 04 00 00 8F 99 ?? ?? 02 40 28 21 72 24 10 02 02 20 30 21 ?? ?? ?? ?? 00 53 20 21 8E 03 00 00 24 63 00 01 AE 03 00 00 8F BF 00 34 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_497_0_0 {
	meta:
		name = "waitid5.constprop.0"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 00 00 10 21 27 BD FF E0 AF A2 00 10 24 02 10 B6 00 00 00 0C 27 BD 00 20 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_498_0_0 {
	meta:
		name = "shmat"
		size = 88
		refs = "0000 _gp_disp 000c __syscall_ipc"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D0 00 80 10 21 24 04 00 15 AF BC 00 18 AF A5 00 10 AF BF 00 2C AF A0 00 14 00 40 28 21 ?? ?? ?? ?? 27 A7 00 20 3C 03 FF FC 24 63 00 01 00 43 18 2B 54 60 00 01 8F A2 00 20 8F BF 00 2C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_499_0_0 {
	meta:
		name = "__GI_wmempcpy"
		size = 40
	strings:
		$1 = { 00 80 10 21 10 C0 00 06 24 C6 FF FF 8C A3 00 00 24 A5 00 04 AC 43 00 00 10 00 FF FA 24 42 00 04 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_500_0_0 {
	meta:
		name = "__psfs_do_numeric"
		size = 1672
		refs = "0000 _gp_disp 0060 __scan_getc 0094 __scan_ungetc 01dc __GI___ctype_b 02d0 _stdlib_strto_ll 0320 _store_inttype 0340 __GI_strcpy 04c4 __strtofpmax 05fc __truncdfsf2"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 00 8F 82 ?? ?? AF BE 00 F8 AF B2 00 E0 AF B1 00 DC AF B0 00 D8 AF BC 00 10 AF BF 00 FC AF B7 00 F4 AF B6 00 F0 AF B5 00 EC AF B4 00 E8 AF B3 00 E4 8C 95 00 3C 24 42 ?? ?? 00 80 80 21 02 A2 10 21 90 52 FF FF 24 02 00 01 00 A0 F0 21 16 A2 00 23 8F 91 ?? ?? 8F 93 ?? ?? 26 73 ?? ?? 02 60 A0 21 02 20 C8 21 ?? ?? ?? ?? 03 C0 20 21 04 40 00 05 8F BC 00 10 92 63 00 00 8F C2 00 00 50 62 00 09 26 73 00 01 8F 99 ?? ?? 03 C0 20 21 ?? ?? ?? ?? 02 93 98 2B 12 60 00 12 02 20 C8 21 10 00 01 6A 24 02 FF FE 92 62 00 00 14 40 FF EE 02 20 C8 21 92 02 00 44 50 40 01 64 00 00 10 21 8E 02 00 34 8E 04 00 2C 8E 05 00 38 24 42 00 01 AE 02 00 34 00 00 38 21 10 00 00 8E 00 00 30 21 02 20 C8 21 ?? ?? ?? ?? 03 C0 20 21 8F C2 00 00 04 40 01 55 8F BC 00 10 24 03 00 2B 10 43 00 03 24 04 00 2D 14 44 00 07 27 B7 00 18 A3 A2 00 18 02 20 C8 21 ?? ?? ?? ?? 03 C0 20 21 8F BC 00 10 27 B7 00 19 32 42 00 EF 54 40 00 23 8F C2 00 00 8F D3 00 00 24 02 00 30 16 62 00 1D 24 02 00 0A 02 20 C8 21 ?? ?? ?? ?? 03 C0 20 21 8F C4 00 00 24 02 00 78 34 84 00 20 14 82 00 08 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 03 C0 20 21 04 40 01 31 8F BC 00 10 10 00 00 0F 24 12 00 10 8F 99 ?? ?? ?? ?? ?? ?? 03 C0 20 21 8F BC 00 10 AF D3 00 00 8E 02 00 3C 28 42 00 08 50 40 00 06 24 12 00 0A 7E 52 38 40 26 52 00 08 10 00 00 02 32 52 00 FF 00 52 90 0A 8F C2 00 00 24 04 00 30 10 44 00 08 00 00 A0 21 27 A3 00 18 00 00 B0 21 00 00 98 21 8F 85 ?? ?? 24 06 00 10 10 00 00 20 AF A3 00 C8 26 F3 00 01 A2 E2 00 00 24 14 00 30 02 20 C8 21 ?? ?? ?? ?? 03 C0 20 21 8F C2 00 00 10 54 FF FB 8F BC 00 10 02 60 B8 21 10 00 FF EE 24 14 00 01 16 46 00 1C 24 44 FF D1 8F A3 00 C8 02 E3 20 23 28 84 00 41 50 80 00 05 26 73 00 01 A2 E2 00 00 24 14 00 01 26 F7 00 01 24 16 00 01 AF A5 00 CC AF A6 00 D0 02 20 C8 21 ?? ?? ?? ?? 03 C0 20 21 8F BC 00 10 8F A6 00 D0 8F A5 00 CC 8F C2 00 00 8C A8 00 00 00 02 20 40 01 04 20 21 94 84 00 00 30 84 00 10 14 80 FF E6 00 00 00 00 10 00 00 05 8E 02 00 3C 02 44 20 2A 10 80 FF E4 8F A3 00 C8 8E 02 00 3C 28 42 00 08 50 40 00 23 8F D5 00 3C 8F 99 ?? ?? ?? ?? ?? ?? 03 C0 20 21 8F BC 00 10 12 80 00 E3 A2 E0 00 00 92 02 00 44 10 40 00 DB 93 A3 00 18 8F 99 ?? ?? 2A B5 00 06 38 62 00 2D 8E 03 00 34 00 02 A8 0A 24 07 00 01 24 63 00 01 8E 11 00 2C AE 03 00 34 27 A4 00 18 8E 10 00 38 00 00 28 21 02 40 30 21 ?? ?? ?? ?? 00 F5 38 23 8F BC 00 10 02 20 20 21 02 00 28 21 00 60 38 21 00 40 30 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 C2 00 00 00 00 92 A2 00 00 54 40 00 0B 8F C4 00 00 8F 99 ?? ?? 8F C5 00 30 ?? ?? ?? ?? 02 E0 20 21 8F C2 00 34 8F BC 00 10 12 C0 00 10 02 E2 B8 21 10 00 00 20 24 16 00 10 10 44 00 07 02 20 C8 21 8F C2 00 3C 00 55 A8 2B 12 A0 00 34 8F 99 ?? ?? 10 00 00 B0 00 00 00 00 ?? ?? ?? ?? 03 C0 20 21 26 B5 00 01 10 00 FF E7 8F BC 00 10 8F C2 00 00 24 04 00 30 14 44 00 0F 24 16 00 10 26 F4 00 01 A2 E2 00 00 26 73 00 01 24 15 00 30 02 20 C8 21 ?? ?? ?? ?? 03 C0 20 21 8F C2 00 00 26 73 FF FF 10 55 FF FA 8F BC 00 10 02 80 B8 21 24 14 00 01 24 16 00 10 27 B5 00 18 8F 83 ?? ?? 8F C2 00 00 8C 65 00 00 00 02 20 40 00 A4 20 21 94 84 00 00 30 84 00 10 10 80 00 11 00 00 00 00 16 56 00 0C 24 44 FF D1 02 F5 20 23 28 84 00 41 10 80 00 04 02 20 C8 21 A2 E2 00 00 24 14 00 01 26 F7 00 01 ?? ?? ?? ?? 03 C0 20 21 10 00 FF EB 8F BC 00 10 02 44 20 2A 10 80 FF F4 02 F5 20 23 56 80 00 24 8F C2 00 00 24 02 00 10 12 42 00 79 24 05 00 69 8F C2 00 00 34 44 00 20 10 85 00 06 24 05 00 6E 14 85 00 74 8F 99 ?? ?? 8F 92 ?? ?? 10 00 00 03 26 52 ?? ?? 8F 92 ?? ?? 26 52 ?? ?? A2 E2 00 00 02 20 C8 21 ?? ?? ?? ?? 03 C0 20 21 8F C4 00 00 92 42 00 00 26 F7 00 01 34 85 00 20 14 A2 00 04 8F BC 00 10 A2 E4 00 00 10 00 FF F5 26 52 00 01 10 40 00 40 8F 99 ?? ?? 8F 82 ?? ?? 24 42 ?? ?? 12 42 00 3D 27 A4 00 18 10 00 00 5A 8F 99 ?? ?? 24 04 00 65 34 45 00 20 14 A4 00 36 8F 99 ?? ?? A2 E2 00 00 02 20 C8 21 ?? ?? ?? ?? 03 C0 20 21 8F C2 00 00 04 40 00 4E 8F BC 00 10 24 04 00 2B 10 44 00 05 24 04 00 2D 50 44 00 04 A2 E2 00 01 10 00 00 09 26 F7 00 01 A2 E2 00 01 02 20 C8 21 ?? ?? ?? ?? 03 C0 20 21 8F BC 00 10 26 F2 00 02 02 40 B8 21 8F C2 00 00 24 04 00 30 14 44 00 16 00 00 90 21 26 F2 00 01 A2 E2 00 00 24 14 00 30 02 20 C8 21 ?? ?? ?? ?? 03 C0 20 21 8F C2 00 00 10 54 FF FB 8F BC 00 10 02 40 B8 21 10 00 00 0A 24 12 00 01 10 80 00 05 02 20 C8 21 26 52 00 01 A2 E2 00 00 32 52 00 FF 26 F7 00 01 ?? ?? ?? ?? 03 C0 20 21 8F BC 00 10 93 C2 00 03 24 44 FF D0 2C 84 00 0A 14 80 FF F3 2E 44 00 14 12 40 00 20 8F 99 ?? ?? 27 A4 00 18 A2 E0 00 00 27 A5 00 C0 ?? ?? ?? ?? 02 60 30 21 92 04 00 44 10 80 00 13 8F BC 00 10 8E 04 00 38 30 85 08 00 14 A0 00 04 8E 11 00 2C 30 84 04 00 10 80 00 04 8F 99 ?? ?? AE 23 00 04 10 00 00 06 AE 22 00 00 00 60 28 21 ?? ?? ?? ?? 00 40 20 21 8F BC 00 10 AE 22 00 00 8E 02 00 34 24 42 00 01 AE 02 00 34 8F 99 ?? ?? ?? ?? ?? ?? 03 C0 20 21 10 00 00 07 00 00 10 21 8F 99 ?? ?? ?? ?? ?? ?? 03 C0 20 21 10 00 00 02 24 02 FF FE 24 02 FF FF 8F BF 00 FC 8F BE 00 F8 8F B7 00 F4 8F B6 00 F0 8F B5 00 EC 8F B4 00 E8 8F B3 00 E4 8F B2 00 E0 8F B1 00 DC 8F B0 00 D8 03 E0 00 08 27 BD 01 00 }
	condition:
		$1
}

rule file_502_0_0 {
	meta:
		name = "__pgsreader"
		size = 472
		refs = "0000 _gp_disp 004c __GI___errno_location 0078 _pthread_cleanup_push_defer 007c __pthread_mutex_unlock 0094 __pthread_mutex_lock 00a4 __GI___ctype_b 00b0 __GI_fgets_unlocked 00e4 __GI_strlen 0164 __parsegrent 0194 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B0 2C E2 01 00 AF BC 00 10 AF B2 00 30 AF B1 00 2C AF BF 00 4C AF BE 00 48 AF B7 00 44 AF B6 00 40 AF B5 00 3C AF B4 00 38 AF B3 00 34 AF B0 00 28 00 E0 88 21 10 40 00 07 8F B2 00 60 8F 99 ?? ?? ?? ?? ?? ?? 24 10 00 22 24 03 00 22 10 00 00 51 AC 43 00 00 8E 53 00 34 00 80 A0 21 00 A0 A8 21 16 60 00 0C 00 C0 80 21 8F 99 ?? ?? 8F 85 ?? ?? 26 56 00 38 27 A4 00 18 ?? ?? ?? ?? 02 C0 30 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 C0 20 21 8F BC 00 10 8F 96 ?? ?? 00 00 B8 21 02 11 F0 21 8F 99 ?? ?? 02 00 20 21 02 20 28 21 ?? ?? ?? ?? 02 40 30 21 14 40 00 07 8F BC 00 10 96 43 00 00 24 10 00 22 24 02 00 02 30 63 00 04 10 00 00 2B 00 43 80 0B 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 24 44 FF FF 02 04 20 21 80 86 00 00 24 05 00 0A 14 C5 00 03 8F BC 00 10 10 00 00 06 A0 80 00 00 24 42 00 01 14 51 00 03 00 00 00 00 10 00 FF E4 26 F7 00 01 52 E0 00 03 82 02 00 00 10 00 FF E0 26 F7 FF FF 14 40 00 03 24 03 00 23 10 00 FF DC 00 00 B8 21 10 43 FF FD 00 02 10 40 8E C3 00 00 00 62 10 21 94 42 00 00 30 42 00 20 14 40 FF D4 00 00 B8 21 8F 82 ?? ?? 52 82 00 01 AE BE 00 00 02 A0 20 21 02 80 C8 21 03 20 F8 09 02 00 28 21 14 40 FF EE 8F BC 00 10 00 00 80 21 16 60 00 06 8F BF 00 4C 8F 99 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F BF 00 4C 02 00 10 21 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_504_0_0 {
	meta:
		name = "__GI_rawmemchr"
		size = 180
	strings:
		$1 = { 30 A2 00 FF 30 83 00 03 50 60 00 06 30 A5 00 FF 90 83 00 00 10 62 00 25 00 00 00 00 10 00 FF F9 24 84 00 01 00 05 1A 00 00 65 28 25 00 05 1C 00 3C 07 7E FE 3C 08 81 01 00 65 28 25 34 E7 FE FF 25 08 01 00 8C 83 00 00 00 A3 18 26 00 03 48 27 00 67 18 21 01 23 18 26 00 68 18 24 14 60 00 03 24 86 00 04 10 00 FF F7 00 C0 20 21 90 83 00 00 10 62 00 0E 00 00 00 00 90 83 00 01 54 62 00 03 90 83 00 02 03 E0 00 08 24 82 00 01 54 62 00 03 90 83 00 03 03 E0 00 08 24 82 00 02 54 62 FF E9 00 C0 20 21 03 E0 00 08 24 82 00 03 03 E0 00 08 00 80 10 21 }
	condition:
		$1
}

rule file_505_0_0 {
	meta:
		name = "putchar"
		size = 272
		refs = "0000 _gp_disp 000c stdout 0060 __GI___fputc_unlocked 0074 _pthread_cleanup_push_defer 0078 __pthread_mutex_unlock 0094 __pthread_mutex_lock 00e0 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 27 BD FF C0 AF B1 00 30 AF BC 00 10 AF BF 00 3C AF B3 00 38 AF B2 00 34 AF B0 00 2C 8C 50 00 00 8E 02 00 34 10 40 00 0F 00 80 88 21 8E 02 00 10 8E 03 00 1C 00 43 18 2B 10 60 00 05 24 43 00 01 AE 03 00 10 A0 44 00 00 10 00 00 26 30 82 00 FF 8F 99 ?? ?? ?? ?? ?? ?? 02 00 28 21 10 00 00 22 8F BF 00 3C 8F 99 ?? ?? 8F 85 ?? ?? 26 13 00 38 27 B2 00 18 02 40 20 21 ?? ?? ?? ?? 02 60 30 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 8E 02 00 10 8E 03 00 1C 00 43 18 2B 10 60 00 06 8F BC 00 10 24 43 00 01 AE 03 00 10 A0 51 00 00 10 00 00 07 32 31 00 FF 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 02 00 28 21 8F BC 00 10 00 40 88 21 8F 99 ?? ?? 02 40 20 21 ?? ?? ?? ?? 24 05 00 01 02 20 10 21 8F BF 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_507_0_0 {
	meta:
		name = "freopen"
		size = 452
		refs = "0000 _gp_disp 0044 _pthread_cleanup_push_defer 0048 __pthread_mutex_unlock 0060 __pthread_mutex_lock 0074 _stdio_openlist_del_lock 00a8 _stdio_openlist_use_count 00ac _pthread_cleanup_pop_restore 00e4 __GI_fclose 0128 _stdio_openlist_del_count 0144 _stdio_fopen 0174 _stdio_openlist_dec_use"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A8 AF B4 00 4C AF B3 00 48 AF B0 00 3C AF BC 00 10 AF BF 00 54 AF B5 00 50 AF B2 00 44 AF B1 00 40 8C D2 00 34 00 80 A0 21 00 A0 98 21 16 40 00 0C 00 C0 80 21 8F 99 ?? ?? 8F 85 ?? ?? 24 D1 00 38 27 A4 00 28 ?? ?? ?? ?? 02 20 30 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8F 85 ?? ?? 8F 86 ?? ?? 8F 99 ?? ?? 27 B1 00 18 ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 02 20 20 21 24 05 00 01 8F 82 ?? ?? 8F 99 ?? ?? 8C 43 00 00 24 63 00 01 AC 43 00 00 ?? ?? ?? ?? 00 00 00 00 96 02 00 00 8F BC 00 10 30 43 9F FF 30 55 60 00 A6 03 00 00 30 42 00 30 24 03 00 30 10 43 00 18 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F 85 ?? ?? 8F 86 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 02 20 20 21 24 05 00 01 8F 82 ?? ?? 8F 99 ?? ?? 8C 43 00 00 24 63 FF FF ?? ?? ?? ?? AC 43 00 00 8F BC 00 10 8F 99 ?? ?? 02 80 20 21 02 60 28 21 02 00 30 21 ?? ?? ?? ?? 24 07 FF FF 00 40 88 21 14 40 00 03 8F BC 00 10 24 02 80 30 A6 02 00 00 96 02 00 00 8F 99 ?? ?? 02 A2 A8 25 ?? ?? ?? ?? A6 15 00 00 16 40 00 05 8F BC 00 10 8F 99 ?? ?? 27 A4 00 28 ?? ?? ?? ?? 24 05 00 01 8F BF 00 54 02 20 10 21 8F B5 00 50 8F B4 00 4C 8F B3 00 48 8F B2 00 44 8F B1 00 40 8F B0 00 3C 03 E0 00 08 27 BD 00 58 }
	condition:
		$1
}

rule file_508_0_0 {
	meta:
		name = "setfsuid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 2A 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_509_0_0 {
	meta:
		name = "__GI___fputc_unlocked"
		size = 332
		refs = "0000 _gp_disp 0058 __stdio_trans2w_o 0098 __stdio_WRITE 00a4 __stdio_wcommit"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 AF B1 00 28 AF B0 00 24 AF BC 00 10 AF BF 00 2C 8C A2 00 10 8C A3 00 1C 00 80 88 21 00 43 18 2B 10 60 00 05 00 A0 80 21 24 43 00 01 AC A3 00 10 10 00 00 22 A0 44 00 00 94 A3 00 00 24 02 00 C0 30 63 00 C0 14 62 00 07 8F 99 ?? ?? 8E 03 00 04 24 02 FF FE 54 62 00 0A 8E 02 00 0C 10 00 00 32 32 22 00 FF 00 A0 20 21 ?? ?? ?? ?? 24 05 00 80 10 40 FF F6 8F BC 00 10 10 00 00 2B 24 02 FF FF 8E 03 00 08 10 62 00 20 8F 99 ?? ?? 8E 03 00 10 10 62 00 0C 8F 99 ?? ?? 8E 03 00 10 24 62 00 01 AE 02 00 10 32 22 00 FF A0 62 00 00 96 03 00 00 30 63 01 00 14 60 00 09 24 03 00 0A 10 00 00 1A 32 22 00 FF ?? ?? ?? ?? 02 00 20 21 10 40 FF F2 8F BC 00 10 10 00 00 14 24 02 FF FF 14 43 00 12 32 22 00 FF 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 10 40 00 0D 32 22 00 FF 8E 02 00 10 24 42 FF FF 10 00 00 08 AE 02 00 10 A3 B1 00 18 02 00 20 21 27 A5 00 18 ?? ?? ?? ?? 24 06 00 01 14 40 00 02 32 22 00 FF 24 02 FF FF 8F BF 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_510_0_0 {
	meta:
		name = "dup"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F C9 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_512_0_0 {
	meta:
		name = "__GI_wcsncasecmp"
		size = 204
		refs = "0000 _gp_disp 0014 __GI_towlower"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B4 00 28 8F 94 ?? ?? AF B3 00 24 AF B1 00 1C AF B0 00 18 AF BC 00 10 AF BF 00 34 AF B6 00 30 AF B5 00 2C AF B2 00 20 00 80 80 21 00 A0 88 21 00 C0 98 21 12 60 00 17 00 00 10 21 8E 12 00 00 8E 36 00 00 16 56 00 06 02 80 C8 21 12 40 00 10 26 10 00 04 26 31 00 04 10 00 FF F6 26 73 FF FF ?? ?? ?? ?? 02 40 20 21 02 C0 20 21 02 80 C8 21 ?? ?? ?? ?? 00 40 A8 21 12 A2 FF F4 02 A2 A8 2B 24 03 00 01 24 02 FF FF 10 00 00 02 00 75 10 0A 00 00 10 21 8F BF 00 34 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_513_0_0 {
	meta:
		name = "__GI_wcslen"
		size = 32
	strings:
		$1 = { 00 80 10 21 8C 43 00 00 50 60 00 03 00 44 10 23 10 00 FF FC 24 42 00 04 03 E0 00 08 00 02 10 83 }
	condition:
		$1
}

rule file_514_0_0 {
	meta:
		name = "__GI_fgets_unlocked"
		size = 260
		refs = "0000 _gp_disp 0044 __GI___fgetc_unlocked"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF BC 00 10 AF B2 00 20 AF BF 00 34 AF B6 00 30 AF B5 00 2C AF B4 00 28 AF B3 00 24 AF B1 00 1C AF B0 00 18 1C A0 00 03 00 A0 90 21 10 00 00 27 00 00 10 21 8F 95 ?? ?? 00 80 98 21 00 C0 88 21 00 80 80 21 24 16 FF FF 24 14 00 0A 26 52 FF FF 12 40 00 1A 02 70 10 2B 8E 22 00 10 8E 23 00 18 00 43 18 2B 10 60 00 05 24 44 00 01 AE 24 00 10 26 03 00 01 10 00 00 0D 80 42 00 00 02 A0 C8 21 ?? ?? ?? ?? 02 20 20 21 14 56 00 07 26 03 00 01 96 22 00 00 30 42 00 08 50 40 00 08 02 70 10 2B 10 00 00 0A 00 00 10 21 7C 02 14 20 A2 02 00 00 14 54 FF E6 00 60 80 21 02 70 10 2B 10 40 00 03 00 00 10 21 A2 00 00 00 02 60 10 21 8F BF 00 34 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_515_0_0 {
	meta:
		name = "div"
		size = 36
	strings:
		$1 = { 00 A6 00 1A 00 C0 01 F4 00 80 10 21 00 00 18 12 AC 43 00 00 70 66 20 02 00 A4 28 23 03 E0 00 08 AC 45 00 04 }
	condition:
		$1
}

rule file_516_0_0 {
	meta:
		name = "__free_initshell_memory"
		size = 92
		refs = "0000 _gp_disp 0018 free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF B0 00 18 8F 90 ?? ?? 8F 99 ?? ?? AF BF 00 1C 8E 04 ?? ?? AF BC 00 10 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 AE 00 ?? ?? 8F 90 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 8E 04 ?? ?? 8F BF 00 1C AE 00 ?? ?? 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_516_1_0 {
	meta:
		name = "initshells"
		size = 560
		refs = "0000 _gp_disp 0048 __free_initshell_memory 005c __GI_fopen 0054 $LC0 0058 $LC1 0078 __GI_fileno 0090 __GI_fstat 00ac malloc 00d4 calloc 00f4 __GI___fsetlocking 0114 __GI_fgets_unlocked 0118 __GI___ctype_b 0170 __GI_fclose"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 20 AF B0 00 B8 8F 90 ?? ?? AF BC 00 10 AF BF 00 DC 26 10 ?? ?? AF B1 00 BC 02 00 C8 21 AF BE 00 D8 AF B7 00 D4 AF B6 00 D0 AF B5 00 CC AF B4 00 C8 AF B3 00 C4 AF B2 00 C0 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 84 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 24 84 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? 00 40 88 21 10 40 00 4D 8F BC 00 10 8F 99 ?? ?? 00 40 20 21 ?? ?? ?? ?? 02 00 90 21 8F BC 00 10 00 40 20 21 8F 99 ?? ?? ?? ?? ?? ?? 27 A5 00 18 24 03 FF FF 10 43 00 39 8F BC 00 10 8F B0 00 4C 8F 99 ?? ?? ?? ?? ?? ?? 26 04 00 01 8F BC 00 10 8F 93 ?? ?? 10 40 00 31 AE 62 ?? ?? 24 04 00 03 02 04 00 1B 00 80 01 F4 8F 99 ?? ?? 24 05 00 04 ?? ?? ?? ?? 00 00 20 12 8F BC 00 10 8F 94 ?? ?? 10 40 00 26 AE 82 ?? ?? 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 24 05 00 02 8F BC 00 10 8E 92 ?? ?? 8E 70 ?? ?? 8F B7 00 4C 8F 99 ?? ?? 8F 96 ?? ?? 24 15 00 23 24 1E 00 2F 8E 65 ?? ?? AF B9 00 B0 02 00 20 21 00 B0 28 23 02 E5 28 21 03 20 F8 09 02 20 30 21 8F BC 00 10 10 40 00 0A 8F B9 00 B0 82 02 00 00 10 55 FF F5 8E 65 ?? ?? 10 5E 00 16 26 44 00 04 50 40 FF F2 AF B9 00 B0 10 00 FF F8 26 10 00 01 8F 99 ?? ?? AE 40 00 00 ?? ?? ?? ?? 02 20 20 21 10 00 00 1F 8E 82 ?? ?? 02 40 C8 21 03 20 F8 09 00 00 00 00 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8F 82 ?? ?? 10 00 00 14 24 42 ?? ?? AE 50 00 00 82 02 00 00 8E C5 00 00 00 02 18 40 00 A3 18 21 94 65 00 00 30 A5 00 20 14 A0 00 07 26 03 00 01 50 55 00 06 A2 00 00 00 50 40 00 04 A2 00 00 00 10 00 FF F3 00 60 80 21 A2 00 00 00 00 80 90 21 10 00 FF CA 00 60 80 21 8F BF 00 DC 8F BE 00 D8 8F B7 00 D4 8F B6 00 D0 8F B5 00 CC 8F B4 00 C8 8F B3 00 C4 8F B2 00 C0 8F B1 00 BC 8F B0 00 B8 03 E0 00 08 27 BD 00 E0 }
	condition:
		$1
}

rule file_516_2_0 {
	meta:
		name = "getusershell"
		size = 108
		refs = "0000 _gp_disp 0034 initshells"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF B0 00 18 8F 90 ?? ?? AF BC 00 10 AF BF 00 1C 8E 02 ?? ?? 14 40 00 08 8E 03 ?? ?? 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 AE 02 ?? ?? 8E 03 ?? ?? 8C 62 00 00 10 40 00 03 8F 84 ?? ?? 24 63 00 04 AC 83 ?? ?? 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_516_3_0 {
	meta:
		name = "endusershell"
		size = 64
		refs = "0000 _gp_disp 0020 __free_initshell_memory"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F BF 00 1C 27 BD 00 20 8F 82 ?? ?? 03 E0 00 08 AC 40 ?? ?? }
	condition:
		$1
}

rule file_516_4_0 {
	meta:
		name = "setusershell"
		size = 64
		refs = "0000 _gp_disp 0020 initshells"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F BF 00 1C 27 BD 00 20 8F 83 ?? ?? 03 E0 00 08 AC 62 ?? ?? }
	condition:
		$1
}

rule file_517_0_0 {
	meta:
		name = "__GI_readdir64_r"
		size = 352
		refs = "0000 _gp_disp 0010 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 0060 __pthread_mutex_lock 0070 __getdents64 00b0 __GI___errno_location 0104 __GI_memcpy 0124 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 8F 99 ?? ?? AF B4 00 3C 00 A0 A0 21 8F 85 ?? ?? AF B2 00 34 AF B1 00 30 27 B2 00 18 24 91 00 18 AF BC 00 10 AF BF 00 44 AF B5 00 40 AF B3 00 38 AF B0 00 2C 00 C0 98 21 00 80 80 21 02 20 30 21 ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 02 20 20 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 88 21 8F BC 00 10 8F 95 ?? ?? 8E 03 00 08 8E 02 00 04 00 43 10 2B 54 40 00 14 8E 02 00 04 8E 04 00 00 8E 05 00 0C 02 A0 C8 21 ?? ?? ?? ?? 8E 06 00 14 1C 40 00 0A 8F BC 00 10 AE 60 00 00 10 40 00 1E 00 00 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8C 50 00 00 10 00 00 18 8F BC 00 10 AE 02 00 08 AE 00 00 04 8E 02 00 04 8E 11 00 0C 02 22 88 21 96 23 00 10 00 62 10 21 AE 02 00 04 8E 22 00 0C AE 02 00 10 8E 22 00 00 8E 23 00 04 00 43 10 25 50 40 FF DE 8E 03 00 08 8F 99 ?? ?? 96 26 00 10 02 80 20 21 ?? ?? ?? ?? 02 20 28 21 8F BC 00 10 AE 74 00 00 00 00 80 21 8F 99 ?? ?? 02 40 20 21 ?? ?? ?? ?? 24 05 00 01 8F BF 00 44 00 00 10 21 02 11 10 0A 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_518_0_0 {
	meta:
		name = "scandir"
		size = 516
		refs = "0000 _gp_disp 000c __GI_opendir 005c __GI___errno_location 0084 __GI_readdir 00c0 __GI_closedir 00dc free 0124 __GI_qsort 0158 realloc 0184 malloc 01a0 __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF B8 AF BC 00 10 AF BE 00 40 AF B7 00 3C AF B6 00 38 AF B3 00 2C AF BF 00 44 AF B5 00 34 AF B4 00 30 AF B2 00 28 AF B1 00 24 AF B0 00 20 00 A0 F0 21 00 C0 B0 21 ?? ?? ?? ?? 00 E0 B8 21 00 40 98 21 10 40 00 3C 8F BC 00 10 8F 99 ?? ?? 00 00 80 21 ?? ?? ?? ?? 00 00 A8 21 8C 59 00 00 8F BC 00 10 00 40 90 21 AF B9 00 18 AC 40 00 00 00 00 88 21 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 00 40 A0 21 10 40 00 09 8F BC 00 10 12 C0 00 2C 02 C0 C8 21 03 20 F8 09 02 80 20 21 14 40 00 28 8F BC 00 10 10 00 FF F3 AE 40 00 00 8E 54 00 00 8F 99 ?? ?? 12 80 00 11 02 60 20 21 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 12 00 00 08 8F 99 ?? ?? 26 10 FF FF 00 10 10 80 02 22 10 21 ?? ?? ?? ?? 8C 44 00 00 10 00 FF F8 8F BC 00 10 ?? ?? ?? ?? 02 20 20 21 10 00 00 10 AE 54 00 00 ?? ?? ?? ?? 00 00 00 00 8F B9 00 18 8F BC 00 10 12 E0 00 07 AE 59 00 00 8F 99 ?? ?? 02 20 20 21 02 00 28 21 24 06 00 04 ?? ?? ?? ?? 02 E0 38 21 AF D1 00 00 10 00 00 24 02 00 10 21 10 00 00 22 24 02 FF FF 16 15 00 0B AE 40 00 00 8F 99 ?? ?? 24 02 00 0A 00 10 A8 40 00 50 A8 0A 02 20 20 21 ?? ?? ?? ?? 00 15 28 80 10 40 FF D1 8F BC 00 10 00 40 88 21 96 86 00 08 8F 99 ?? ?? 00 C0 20 21 ?? ?? ?? ?? AF A6 00 1C 8F BC 00 10 10 40 FF C8 8F A6 00 1C 8F 99 ?? ?? 26 03 00 01 AF A3 00 1C 00 40 20 21 02 80 28 21 ?? ?? ?? ?? 00 10 80 80 02 30 80 21 8F BC 00 10 AE 02 00 00 8F A3 00 1C 10 00 FF AD 00 60 80 21 8F BF 00 44 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_519_0_0 {
	meta:
		name = "do_close"
		size = 96
		refs = "0000 _gp_disp 000c __GI___errno_location 003c __GI_close"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D0 AF BF 00 2C AF B1 00 28 AF B0 00 24 AF BC 00 10 AF A4 00 18 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8C 51 00 00 8F A4 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 40 80 21 AE 11 00 00 8F BF 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_519_1_0 {
	meta:
		name = "__GI_rtime"
		size = 620
		refs = "0000 _gp_disp 0020 __GI_socket 0084 __GI_sendto 00cc __GI_poll 00d0 __GI___errno_location 0130 __GI_recvfrom 0198 __GI_connect 01c4 do_close 01d4 __GI_read"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 98 AF B6 00 5C 24 16 00 02 AF B5 00 58 AF B2 00 4C 8F 99 ?? ?? 24 15 00 01 02 C0 90 21 02 A6 90 0B AF BC 00 18 AF B4 00 54 AF B3 00 50 AF B1 00 48 AF B0 00 44 AF BF 00 64 AF B7 00 60 00 80 88 21 00 A0 A0 21 00 C0 98 21 24 04 00 02 02 40 28 21 ?? ?? ?? ?? 00 00 30 21 00 40 80 21 04 40 00 6C 8F BC 00 18 24 02 00 25 A6 36 00 00 16 55 00 46 A6 22 00 02 8F 99 ?? ?? 24 02 00 10 27 B5 00 3C AF B1 00 10 AF A2 00 14 02 00 20 21 02 A0 28 21 24 06 00 04 ?? ?? ?? ?? 00 00 38 21 04 40 00 36 8F BC 00 18 8E 66 00 04 24 02 03 E8 8E 63 00 00 00 C2 00 1B 00 40 01 F4 A7 B2 00 34 8F 97 ?? ?? 8F 92 ?? ?? AF B0 00 30 27 B6 00 30 24 11 00 04 70 43 00 00 00 00 98 12 02 C0 20 21 24 05 00 01 02 E0 C8 21 ?? ?? ?? ?? 02 60 30 21 04 41 00 09 8F BC 00 18 02 40 C8 21 ?? ?? ?? ?? 00 00 00 00 8C 42 00 00 10 51 FF F4 8F BC 00 18 10 00 00 1B 8F 99 ?? ?? 10 40 00 12 02 A0 28 21 24 02 00 10 8F 99 ?? ?? AF A2 00 38 27 A2 00 20 AF A2 00 10 27 A2 00 38 02 00 20 21 AF A2 00 14 24 06 00 04 ?? ?? ?? ?? 00 00 38 21 8F BC 00 18 00 40 88 21 02 00 20 21 8F 99 ?? ?? 10 00 00 21 27 39 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 91 8F BC 00 18 AC 43 00 00 8F 99 ?? ?? 02 00 20 21 10 00 00 0C 27 39 ?? ?? 8F 99 ?? ?? 02 00 20 21 02 20 28 21 ?? ?? ?? ?? 24 06 00 10 8F BC 00 18 02 00 20 21 8F 92 ?? ?? 04 41 00 06 26 52 ?? ?? 02 40 C8 21 ?? ?? ?? ?? 00 00 00 00 10 00 00 1C 24 02 FF FF 8F 99 ?? ?? 27 A5 00 3C ?? ?? ?? ?? 24 06 00 04 00 40 88 21 02 00 20 21 02 40 C8 21 ?? ?? ?? ?? 00 00 00 00 06 20 00 09 8F BC 00 18 24 02 00 04 12 22 00 08 8F A3 00 3C 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 05 AC 43 00 00 10 00 00 07 24 02 FF FF 3C 02 7C 55 34 42 81 80 00 62 10 21 AE 82 00 00 AE 80 00 04 00 00 10 21 8F BF 00 64 8F B7 00 60 8F B6 00 5C 8F B5 00 58 8F B4 00 54 8F B3 00 50 8F B2 00 4C 8F B1 00 48 8F B0 00 44 03 E0 00 08 27 BD 00 68 }
	condition:
		$1
}

rule file_520_0_0 {
	meta:
		name = "wmemset"
		size = 36
	strings:
		$1 = { 00 80 10 21 00 80 18 21 10 C0 00 04 24 C6 FF FF AC 65 00 00 10 00 FF FC 24 63 00 04 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_521_0_0 {
	meta:
		name = "__GI_clock_getres"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 A8 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_522_0_0 {
	meta:
		name = "__GI_herror"
		size = 184
		refs = "0000 _gp_disp 0044 __GI___h_errno_location 0080 stderr 0088 __GI_fprintf 0084 $LC0"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 AF BC 00 18 AF B1 00 28 AF BF 00 2C AF B0 00 24 10 80 00 04 00 80 88 21 80 82 00 00 54 40 00 04 8F 90 ?? ?? 8F 90 ?? ?? 10 00 00 02 26 10 ?? ?? 26 10 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8C 42 00 00 2C 43 00 05 10 60 00 07 8F BC 00 18 8F 83 ?? ?? 00 02 10 80 24 63 ?? ?? 00 43 10 21 10 00 00 03 8C 42 00 00 8F 82 ?? ?? 24 42 ?? ?? 8F 83 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 8C 64 00 00 02 20 30 21 02 00 38 21 AF A2 00 10 ?? ?? ?? ?? 24 A5 ?? ?? 8F BF 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_522_1_0 {
	meta:
		name = "hstrerror"
		size = 56
		refs = "0000 _gp_disp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 2C 82 00 05 10 40 00 06 00 04 20 80 8F 82 ?? ?? 24 42 ?? ?? 00 82 20 21 03 E0 00 08 8C 82 00 00 8F 82 ?? ?? 03 E0 00 08 24 42 ?? ?? }
	condition:
		$1
}

rule file_524_0_0 {
	meta:
		name = "__GI_fseek"
		size = 56
		refs = "0000 _gp_disp 000c __GI_fseeko64"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 00 A0 38 21 AF BF 00 24 AF BC 00 18 AF A6 00 10 ?? ?? ?? ?? 00 05 37 C3 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_525_0_0 {
	meta:
		name = "print_and_abort"
		size = 72
		refs = "0000 _gp_disp 000c stderr 0024 __GI_fprintf 0014 $LC0 0018 $LC1 003c __GI_exit"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 27 BD FF E0 8F 85 ?? ?? 8F 86 ?? ?? AF BC 00 10 AF BF 00 1C 8F 99 ?? ?? 8C 44 00 00 24 A5 ?? ?? ?? ?? ?? ?? 24 C6 ?? ?? 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 24 04 00 01 }
	condition:
		$1
}

rule file_525_1_0 {
	meta:
		name = "_obstack_begin"
		size = 252
		refs = "0000 _gp_disp 009c print_and_abort"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 8F A3 00 38 AF B2 00 20 AF B1 00 1C AF B0 00 18 AF BC 00 10 AF BF 00 24 AC 83 00 20 90 83 00 28 24 11 00 08 00 C6 88 0B 7C 03 39 C4 A0 83 00 28 8C 83 00 28 24 02 0F E8 00 A5 10 0B 26 32 FF FF 00 80 80 21 AC 87 00 1C AC 82 00 00 04 61 00 07 AC 92 00 18 8C 84 00 24 00 E0 C8 21 03 20 F8 09 00 40 28 21 10 00 00 05 8F BC 00 10 00 E0 C8 21 03 20 F8 09 00 40 20 21 8F BC 00 10 14 40 00 05 AE 02 00 04 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 43 00 08 00 72 90 21 8E 03 00 00 00 11 88 23 02 51 88 24 00 43 18 21 AE 11 00 08 AE 11 00 0C AC 43 00 00 AE 03 00 10 AC 40 00 04 92 02 00 28 8F BF 00 24 8F B2 00 20 7C 02 31 84 7C 02 29 44 A2 02 00 28 8F B1 00 1C 8F B0 00 18 24 02 00 01 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_525_2_0 {
	meta:
		name = "_obstack_begin_1"
		size = 260
		refs = "0000 _gp_disp 00a4 print_and_abort"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 8F A3 00 38 AF B0 00 18 00 80 80 21 AE 03 00 20 92 03 00 28 24 02 0F E8 00 A5 10 0B 24 05 00 01 7C A3 39 C4 A2 03 00 28 AF B1 00 1C 8F A4 00 3C 24 11 00 08 8E 03 00 28 00 C6 88 0B AF B2 00 20 AF BC 00 10 26 32 FF FF AF BF 00 24 AE 07 00 1C AE 02 00 00 AE 12 00 18 04 61 00 06 AE 04 00 24 00 E0 C8 21 03 20 F8 09 00 40 28 21 10 00 00 05 8F BC 00 10 00 E0 C8 21 03 20 F8 09 00 40 20 21 8F BC 00 10 14 40 00 05 AE 02 00 04 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 43 00 08 00 72 90 21 8E 03 00 00 00 11 88 23 02 51 88 24 00 43 18 21 AE 11 00 08 AE 11 00 0C AC 43 00 00 AE 03 00 10 AC 40 00 04 92 02 00 28 8F BF 00 24 8F B2 00 20 7C 02 31 84 7C 02 29 44 A2 02 00 28 8F B1 00 1C 8F B0 00 18 24 02 00 01 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_525_3_0 {
	meta:
		name = "_obstack_newchunk"
		size = 448
		refs = "0000 _gp_disp 009c print_and_abort"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 AF B3 00 28 AF B0 00 1C AF BC 00 10 AF BF 00 2C AF B2 00 24 AF B1 00 20 8C 82 00 08 8C 91 00 0C 00 80 80 21 8C 92 00 04 02 22 88 23 00 11 10 C3 02 25 28 21 00 A2 98 21 8C 82 00 18 02 62 98 21 8C 82 00 00 26 73 00 64 02 62 18 2A 00 43 98 0B 8C 82 00 28 04 41 00 06 8C 99 00 1C 8C 84 00 24 03 20 F8 09 02 60 28 21 10 00 00 04 8F BC 00 10 03 20 F8 09 02 60 20 21 8F BC 00 10 54 40 00 05 00 53 98 21 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 AE 02 00 04 AC 52 00 04 AE 13 00 10 AC 53 00 00 8E 03 00 18 24 53 00 08 00 03 20 27 02 63 98 21 02 64 98 24 28 64 00 07 14 80 00 0E 00 00 18 21 00 11 18 82 24 64 FF FF 24 06 FF FF 10 86 00 08 00 04 28 80 8E 07 00 08 24 84 FF FF 00 E5 38 21 8C E7 00 00 02 65 28 21 10 00 FF F8 AC A7 00 00 00 03 18 80 00 71 20 2A 50 80 00 08 8E 03 00 28 8E 04 00 08 00 83 20 21 80 85 00 00 02 63 20 21 24 63 00 01 10 00 FF F7 A0 85 00 00 7C 63 07 80 54 60 00 16 92 02 00 28 8E 03 00 18 26 44 00 08 00 83 20 21 00 03 18 27 00 83 18 24 8E 04 00 08 54 83 00 0E 92 02 00 28 8E 43 00 04 AC 43 00 04 8E 02 00 28 04 41 00 06 8E 19 00 20 8E 04 00 24 03 20 F8 09 02 40 28 21 10 00 00 03 00 00 00 00 03 20 F8 09 02 40 20 21 92 02 00 28 8F BF 00 2C 02 71 88 21 7C 02 31 84 AE 13 00 08 AE 11 00 0C 8F B3 00 28 8F B2 00 24 8F B1 00 20 A2 02 00 28 8F B0 00 1C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_525_4_0 {
	meta:
		name = "_obstack_allocated_p"
		size = 48
	strings:
		$1 = { 8C 82 00 04 10 40 00 08 00 45 18 2B 54 60 00 03 8C 43 00 00 10 00 FF FB 8C 42 00 04 00 65 18 2B 54 60 FF F8 8C 42 00 04 03 E0 00 08 00 02 10 2B }
	condition:
		$1
}

rule file_525_5_0 {
	meta:
		name = "obstack_free"
		size = 220
		refs = "0000 _gp_disp 00b4 __GI_abort"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 AF B2 00 24 AF B1 00 20 AF B0 00 1C AF BC 00 10 AF BF 00 2C AF B3 00 28 00 A0 88 21 8C 85 00 04 00 80 80 21 24 12 00 01 10 A0 00 1C 00 B1 18 2B 54 60 00 11 8C A3 00 00 8E 03 00 28 8C B3 00 04 04 61 00 05 8E 19 00 20 03 20 F8 09 8E 04 00 24 10 00 00 04 8F BC 00 10 03 20 F8 09 00 A0 20 21 8F BC 00 10 92 02 00 28 02 60 28 21 7E 42 31 84 10 00 FF ED A2 02 00 28 00 71 18 2B 54 60 FF EF 8E 03 00 28 AE 11 00 0C AE 11 00 08 8C A3 00 00 AE 05 00 04 10 00 00 06 AE 03 00 10 12 20 00 05 8F BF 00 2C 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_525_6_0 {
	meta:
		name = "_obstack_memory_used"
		size = 44
	strings:
		$1 = { 8C 83 00 04 00 00 10 21 10 60 00 06 00 00 00 00 8C 64 00 00 00 83 20 23 00 44 10 21 10 00 FF FA 8C 63 00 04 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_526_0_0 {
	meta:
		name = "_store_inttype"
		size = 64
	strings:
		$1 = { 24 02 01 00 14 A2 00 03 24 02 08 00 03 E0 00 08 A0 87 00 00 54 A2 00 04 24 02 02 00 AC 86 00 00 03 E0 00 08 AC 87 00 04 14 A2 00 03 00 00 00 00 03 E0 00 08 A4 87 00 00 03 E0 00 08 AC 87 00 00 }
	condition:
		$1
}

rule file_527_0_0 {
	meta:
		name = "__GI_perror"
		size = 176
		refs = "0000 _gp_disp 0038 $LC0 004c stderr 0050 __GI___errno_location 0068 __GI___glibc_strerror_r 0084 __GI_fprintf 0080 $LC1"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 90 AF BC 00 18 AF B1 00 64 AF BF 00 6C AF B2 00 68 AF B0 00 60 10 80 00 04 00 80 88 21 80 82 00 00 54 40 00 05 8F 90 ?? ?? 8F 90 ?? ?? 26 10 ?? ?? 10 00 00 02 02 00 88 21 26 10 ?? ?? 8F 82 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 8C 52 00 00 8F BC 00 18 8C 44 00 00 27 A5 00 20 8F 99 ?? ?? ?? ?? ?? ?? 24 06 00 40 8F BC 00 18 02 40 20 21 02 20 30 21 8F 85 ?? ?? 8F 99 ?? ?? 02 00 38 21 AF A2 00 10 ?? ?? ?? ?? 24 A5 ?? ?? 8F BF 00 6C 8F B2 00 68 8F B1 00 64 8F B0 00 60 03 E0 00 08 27 BD 00 70 }
	condition:
		$1
}

rule file_528_0_0 {
	meta:
		name = "get_kernel_syms"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 22 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_529_0_0 {
	meta:
		name = "msync"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 30 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_530_0_0 {
	meta:
		name = "skip"
		size = 252
		refs = "0000 _gp_disp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 00 80 10 21 00 00 28 21 24 08 00 22 24 07 00 01 24 09 00 23 24 0A 00 20 24 0B 00 5C 80 43 00 00 10 60 00 31 00 00 00 00 14 68 00 03 00 80 30 21 10 00 00 2A 38 A5 00 01 54 A7 00 08 80 4C 00 00 54 6B 00 06 80 4C 00 00 80 46 00 01 38 C6 00 22 2C C6 00 01 00 46 10 21 80 4C 00 00 24 86 00 01 10 A7 00 1E A0 8C 00 00 54 69 00 05 24 64 FF F7 8F 84 ?? ?? A0 40 00 00 10 00 00 16 A0 83 ?? ?? 30 84 00 FF 2C 84 00 02 54 80 00 04 8F 84 ?? ?? 54 6A 00 13 24 42 00 01 8F 84 ?? ?? A0 40 00 00 24 42 00 01 A0 83 ?? ?? 24 04 00 20 80 43 00 00 24 65 FF F7 30 A5 00 FF 2C A5 00 02 10 A0 00 03 00 00 00 00 10 00 FF F9 24 42 00 01 50 64 FF F7 24 42 00 01 10 00 00 04 00 C0 20 21 24 42 00 01 10 00 FF CE 00 C0 20 21 03 E0 00 08 A0 80 FF FF }
	condition:
		$1
}

rule file_530_1_0 {
	meta:
		name = "__GI_setttyent"
		size = 140
		refs = "0000 _gp_disp 0028 __GI_rewind 0044 __GI_fopen 003c $LC0 0040 $LC1 0060 __GI___fsetlocking"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF B0 00 18 8F 90 ?? ?? AF BC 00 10 AF BF 00 1C 8E 04 ?? ?? 10 80 00 05 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 0E 00 00 00 00 8F 84 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 24 84 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? AE 02 ?? ?? 10 40 00 07 8F BC 00 10 8F 99 ?? ?? 00 40 20 21 ?? ?? ?? ?? 24 05 00 02 10 00 00 02 24 02 00 01 00 00 10 21 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_530_2_0 {
	meta:
		name = "__GI_getttyent"
		size = 1092
		refs = "0000 _gp_disp 0048 __GI_setttyent 0060 malloc 0090 __GI_abort 00a8 __pthread_mutex_unlock 00b0 _pthread_cleanup_push_defer 00c8 __pthread_mutex_lock 00d8 __GI_strchr 00dc __GI___ctype_b 00e0 __GI___fgetc_unlocked 00e8 __GI_fgets_unlocked 01c0 skip 022c $LC2 0230 $LC3 0250 __GI_strncmp 0234 $LC4 032c $LC5 0400 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A8 AF B0 00 30 8F 90 ?? ?? AF BC 00 10 AF BF 00 54 8E 02 ?? ?? AF BE 00 50 AF B7 00 4C AF B6 00 48 AF B5 00 44 AF B4 00 40 AF B3 00 3C AF B2 00 38 AF B1 00 34 10 40 00 07 8F 99 ?? ?? 8F 91 ?? ?? 8E 22 ?? ?? 14 40 00 11 02 20 A8 21 10 00 00 07 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 14 40 FF F7 8F BC 00 10 10 00 00 E7 00 00 10 21 ?? ?? ?? ?? 24 04 10 00 AE 22 ?? ?? 14 40 00 04 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 27 B9 00 18 8E 06 ?? ?? 03 20 20 21 8F 85 ?? ?? AF B9 00 28 8F 99 ?? ?? 24 C6 00 38 ?? ?? ?? ?? 24 14 00 23 8F BC 00 10 8E 04 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 84 00 38 8F BC 00 10 8F 96 ?? ?? 8F 97 ?? ?? 8F 9E ?? ?? 8E B2 ?? ?? 8F 99 ?? ?? 8E 06 ?? ?? 02 40 20 21 ?? ?? ?? ?? 24 05 10 00 10 40 00 BD 8F BC 00 10 02 40 20 21 02 C0 C8 21 ?? ?? ?? ?? 24 05 00 0A 14 40 00 16 8F BC 00 10 24 13 00 0A 24 11 FF FF 8E 04 ?? ?? 8C 82 00 10 8C 83 00 18 00 43 18 2B 10 60 00 04 24 43 00 01 AC 83 00 10 10 00 00 05 90 42 00 00 03 C0 C8 21 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 10 53 FF E3 8E B2 ?? ?? 14 51 FF F1 8E 04 ?? ?? 10 00 FF E0 8F 99 ?? ?? 82 42 00 00 8E E5 00 00 00 02 20 40 00 A4 20 21 94 84 00 00 30 84 00 20 10 80 00 03 8F 91 ?? ?? 10 00 FF F7 26 52 00 01 50 40 FF D3 8E B2 ?? ?? 50 54 FF D1 8E B2 ?? ?? 8F 8D ?? ?? 8F 90 ?? ?? 8F 95 ?? ?? AD B2 ?? ?? 02 40 20 21 26 19 ?? ?? ?? ?? ?? ?? A2 A0 ?? ?? 25 A7 ?? ?? 8F BC 00 10 AC E2 00 04 00 40 98 21 80 42 00 00 03 20 80 21 14 40 00 04 00 E0 90 21 AC E0 00 08 10 00 00 0F AC E0 00 04 ?? ?? ?? ?? 02 60 20 21 8F BC 00 10 AE 42 00 08 00 40 98 21 80 42 00 00 14 40 00 03 02 00 C8 21 10 00 00 05 AE 40 00 08 ?? ?? ?? ?? 02 60 20 21 8F BC 00 10 00 40 98 21 8F 96 ?? ?? 8F 97 ?? ?? 8F 9E ?? ?? AE 40 00 0C AE 40 00 10 26 D6 ?? ?? 26 F7 ?? ?? 82 74 00 00 12 80 00 4F 8F 95 ?? ?? 02 60 20 21 02 C0 28 21 02 A0 C8 21 ?? ?? ?? ?? 24 06 00 03 14 40 00 0D 02 60 20 21 82 62 00 03 8E 24 00 00 00 02 10 40 00 82 10 21 94 42 00 00 30 42 00 20 50 40 00 05 02 60 20 21 8E 44 00 0C 24 02 FF FE 10 00 00 11 00 82 10 24 02 E0 28 21 02 A0 C8 21 ?? ?? ?? ?? 24 06 00 02 14 40 00 0D 02 60 20 21 82 62 00 02 8E 24 00 00 00 02 10 40 00 82 10 21 94 42 00 00 30 42 00 20 10 40 00 05 02 60 20 21 8E 42 00 0C 34 42 00 01 10 00 00 24 AE 42 00 0C 27 C5 ?? ?? 02 A0 C8 21 ?? ?? ?? ?? 24 06 00 06 14 40 00 0C 8F BC 00 10 82 62 00 06 8E 24 00 00 00 02 10 40 00 82 10 21 94 42 00 00 30 42 00 20 10 40 00 05 8F 85 ?? ?? 8E 42 00 0C 10 00 FF EE 34 42 00 02 8F 85 ?? ?? 02 60 20 21 24 06 00 06 02 A0 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 00 11 8F BC 00 10 82 64 00 06 24 02 00 3D 14 82 00 0D 8F 99 ?? ?? 02 60 20 21 ?? ?? ?? ?? 24 05 00 3D 24 44 00 01 00 02 20 0A AE 44 00 10 02 00 C8 21 ?? ?? ?? ?? 02 60 20 21 00 40 98 21 10 00 FF B0 8F BC 00 10 8F 82 ?? ?? 80 44 ?? ?? 24 02 00 23 10 82 00 04 24 05 00 20 56 82 00 09 AE 53 00 14 24 05 00 20 24 04 00 09 82 62 00 01 10 45 FF FE 26 73 00 01 50 44 FF FD 82 62 00 01 AE 53 00 14 82 62 00 00 50 40 00 01 AE 40 00 14 8F 99 ?? ?? 02 60 20 21 ?? ?? ?? ?? 24 05 00 0A 10 40 00 05 8F BC 00 10 10 00 00 03 A0 40 00 00 10 00 00 02 00 00 80 21 02 40 80 21 8F 99 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 02 00 10 21 8F BF 00 54 8F BE 00 50 8F B7 00 4C 8F B6 00 48 8F B5 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 58 }
	condition:
		$1
}

rule file_530_3_0 {
	meta:
		name = "__GI_endttyent"
		size = 88
		refs = "0000 _gp_disp 0028 __GI_fclose"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF B0 00 18 8F 90 ?? ?? AF BC 00 10 AF BF 00 1C 8E 04 ?? ?? 10 80 00 07 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 42 00 01 AE 00 ?? ?? 10 00 00 02 00 02 10 2B 24 02 00 01 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_530_4_0 {
	meta:
		name = "getttynam"
		size = 156
		refs = "0000 _gp_disp 000c __GI_setttyent 0038 __GI_getttyent 003c __GI_strcmp 0070 __GI_endttyent"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D0 AF BC 00 10 AF B3 00 28 AF B2 00 24 AF B1 00 20 AF BF 00 2C AF B0 00 1C ?? ?? ?? ?? 00 80 90 21 8F BC 00 10 8F 91 ?? ?? 8F 93 ?? ?? 02 20 C8 21 ?? ?? ?? ?? 00 00 00 00 00 40 80 21 10 40 00 07 8F BC 00 10 8E 05 00 00 02 60 C8 21 ?? ?? ?? ?? 02 40 20 21 14 40 FF F5 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BF 00 2C 02 00 10 21 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_531_0_0 {
	meta:
		name = "__GI_strcasecmp"
		size = 104
		refs = "0000 _gp_disp 000c __GI___ctype_tolower"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 86 ?? ?? 50 85 00 0E 80 82 00 00 90 82 00 00 8C C3 00 00 00 02 10 40 00 62 10 21 84 47 00 00 90 A2 00 00 00 02 10 40 00 62 18 21 84 62 00 00 00 E2 10 23 14 40 00 07 00 00 00 00 80 82 00 00 24 A5 00 01 10 40 00 03 24 83 00 01 10 00 FF ED 00 60 20 21 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_533_0_0 {
	meta:
		name = "__GI_sysconf"
		size = 1004
		refs = "0000 _gp_disp 0048 __GI___errno_location 0078 __GI_getdtablesize 0118 __GI_getpagesize 03b4 __GI_clock_getres"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 2C 82 00 96 AF BC 00 10 AF BF 00 1C 10 40 00 0A 00 04 20 80 8F 82 ?? ?? 24 42 ?? ?? 00 44 20 21 8C 82 00 00 00 5C 10 21 00 40 00 08 00 00 00 00 10 00 00 E7 3C 02 00 02 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 AC 43 00 00 10 00 00 E0 24 02 FF FF 10 00 00 DE 24 02 00 64 10 00 00 DC 3C 02 00 01 10 00 00 29 8F 99 ?? ?? 10 00 00 D8 24 02 00 10 10 00 00 D6 24 02 00 06 10 00 00 D4 24 02 00 01 10 00 00 D2 24 02 00 01 10 00 00 D0 24 02 00 01 10 00 00 CE 24 02 00 01 10 00 00 CC 24 02 00 01 10 00 00 CA 24 02 00 01 10 00 00 C8 24 02 00 01 10 00 00 C6 24 02 00 01 10 00 00 C4 24 02 00 01 10 00 00 C2 24 02 00 01 10 00 00 C0 24 02 00 01 10 00 00 BE 24 02 00 01 10 00 00 BC 24 02 00 01 10 00 00 BA 24 02 00 01 10 00 00 B8 24 02 00 01 10 00 00 B6 24 02 00 01 3C 02 00 03 10 00 00 B3 24 42 0D B0 8F 99 ?? ?? 8F BF 00 1C 03 20 00 08 27 BD 00 20 10 00 00 AD 24 02 00 14 3C 02 7F FF 10 00 00 AA 34 42 FF FF 10 00 00 A8 34 02 80 00 10 00 00 A6 24 02 00 20 10 00 00 A4 24 02 01 00 10 00 00 A2 24 02 00 63 10 00 00 A0 24 02 08 00 10 00 00 9E 24 02 00 63 10 00 00 9C 24 02 03 E8 10 00 00 9A 24 02 00 FF 10 00 00 98 24 02 00 20 10 00 00 96 24 02 08 00 10 00 00 94 24 02 7F FF 10 00 00 92 24 02 08 00 3C 02 00 03 10 00 00 8F 24 42 0D B0 3C 02 00 03 10 00 00 8C 24 42 0D B0 3C 02 00 03 10 00 00 89 24 42 0D B0 3C 02 00 03 10 00 00 86 24 42 0D B0 3C 02 00 03 10 00 00 83 24 42 0D B0 3C 02 00 03 10 00 00 80 24 42 0D B0 10 00 00 7E 24 02 00 01 10 00 00 7C 24 02 00 01 10 00 00 7A 24 02 01 00 10 00 00 78 24 02 01 00 10 00 00 76 24 02 01 00 10 00 00 74 24 02 00 20 10 00 00 72 24 02 00 04 10 00 00 70 24 02 04 00 10 00 00 6E 24 02 40 00 10 00 00 6C 24 02 04 00 10 00 00 6A 24 02 00 01 10 00 00 68 24 02 00 01 10 00 00 66 24 02 00 01 10 00 00 64 24 02 00 01 10 00 00 62 24 02 00 01 10 00 00 60 24 02 00 01 10 00 00 5E 24 02 00 01 10 00 00 5C 24 02 00 01 3C 02 7F FF 10 00 00 59 34 42 FF FF 10 00 00 57 24 02 10 00 10 00 00 55 24 02 01 F4 10 00 00 53 24 02 00 04 10 00 00 51 24 02 00 01 10 00 00 4F 24 02 00 01 10 00 00 4D 24 02 00 01 10 00 00 4B 24 02 00 01 10 00 00 49 24 02 00 01 10 00 00 47 24 02 00 01 10 00 00 45 24 02 00 01 10 00 00 43 24 02 00 08 10 00 00 41 24 02 00 7F 10 00 00 3F 24 02 FF 80 3C 02 7F FF 10 00 00 3C 34 42 FF FF 10 00 00 3A 3C 02 80 00 10 00 00 38 24 02 00 20 10 00 00 36 24 02 00 20 10 00 00 34 24 02 00 10 10 00 00 32 24 02 00 14 10 00 00 30 24 02 7F FF 10 00 00 2E 24 02 00 7F 10 00 00 2C 24 02 FF 80 10 00 00 2A 24 02 7F FF 10 00 00 28 24 02 80 00 10 00 00 26 24 02 00 FF 10 00 00 24 34 02 FF FF 10 00 00 22 24 02 00 09 10 00 00 20 24 02 08 00 3C 02 7F FF 10 00 00 1D 34 42 FF FF 3C 02 7F FF 10 00 00 1A 34 42 FF FF 3C 02 7F FF 10 00 00 17 34 42 FF FF 3C 02 7F FF 10 00 00 14 34 42 FF FF 10 00 00 12 24 02 00 01 10 00 00 10 24 02 00 01 10 00 00 0E 24 02 00 01 10 00 00 0C 24 02 00 01 8F 99 ?? ?? 24 04 00 01 ?? ?? ?? ?? 00 00 28 21 04 40 00 05 3C 02 00 03 10 00 00 04 24 42 0D B0 10 00 00 02 24 02 FF FF 24 02 FF FF 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_534_0_0 {
	meta:
		name = "capset"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 6D 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_535_0_0 {
	meta:
		name = "__xstat_conv"
		size = 216
		refs = "0000 _gp_disp 000c __GI_memset"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 24 06 00 98 AF BF 00 24 AF B1 00 20 AF B0 00 1C 00 80 88 21 00 A0 80 21 AF BC 00 10 00 A0 20 21 ?? ?? ?? ?? 00 00 28 21 8E 22 00 00 AE 00 00 00 AE 02 00 04 8E 22 00 10 AE 02 00 10 8E 22 00 14 AE 02 00 14 8E 22 00 18 AE 02 00 18 8E 22 00 1C AE 02 00 1C 8E 22 00 20 AE 02 00 20 8E 22 00 24 AE 00 00 28 AE 02 00 2C 8E 22 00 30 AE 02 00 34 8E 22 00 50 AE 02 00 54 8E 22 00 54 AE 02 00 58 8E 22 00 38 AE 02 00 3C 8E 22 00 40 AE 02 00 44 8E 22 00 48 AE 02 00 4C 8E 22 00 3C AE 02 00 40 8E 22 00 44 AE 02 00 48 8E 22 00 4C AE 02 00 50 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_535_1_0 {
	meta:
		name = "__xstat64_conv"
		size = 240
		refs = "0000 _gp_disp 000c __GI_memset"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 24 06 00 A0 AF BF 00 24 AF B1 00 20 AF B0 00 1C 00 80 88 21 00 A0 80 21 AF BC 00 10 00 A0 20 21 ?? ?? ?? ?? 00 00 28 21 8E 22 00 00 AE 00 00 00 AE 02 00 04 8E 23 00 14 8E 22 00 10 AE 03 00 14 AE 02 00 10 8E 22 00 18 AE 02 00 18 8E 22 00 1C AE 02 00 1C 8E 22 00 20 AE 02 00 20 8E 22 00 24 AE 02 00 24 8E 22 00 28 AE 00 00 28 AE 02 00 2C 8E 23 00 3C 8E 22 00 38 AE 03 00 3C AE 02 00 38 8E 22 00 58 AE 02 00 58 8E 23 00 64 8E 22 00 60 AE 03 00 64 AE 02 00 60 8E 22 00 40 AE 02 00 40 8E 22 00 48 AE 02 00 48 8E 22 00 50 AE 02 00 50 8E 22 00 44 8F BF 00 24 AE 02 00 44 8E 22 00 4C AE 02 00 4C 8E 22 00 54 8F B1 00 20 AE 02 00 54 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_537_0_0 {
	meta:
		name = "wcsncat"
		size = 68
	strings:
		$1 = { 00 80 10 21 00 80 18 21 8C 64 00 00 10 80 00 09 24 67 00 04 10 00 FF FC 00 E0 18 21 24 A7 00 04 10 80 00 06 AC 64 00 00 24 C6 FF FF 24 63 00 04 00 E0 28 21 54 C0 FF F9 8C A4 00 00 03 E0 00 08 AC 60 00 00 }
	condition:
		$1
}

rule file_538_0_0 {
	meta:
		name = "seed48"
		size = 64
		refs = "0000 _gp_disp 000c __libc_drand48_data 0010 __GI_seed48_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 85 ?? ?? 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F BF 00 1C 27 BD 00 20 8F 82 ?? ?? 03 E0 00 08 24 42 00 06 }
	condition:
		$1
}

rule file_541_0_0 {
	meta:
		name = "wcsncmp"
		size = 60
	strings:
		$1 = { 10 C0 00 0A 00 00 00 00 8C 82 00 00 8C A3 00 00 14 43 00 08 00 00 00 00 10 40 00 04 24 84 00 04 24 A5 00 04 10 00 FF F6 24 C6 FF FF 03 E0 00 08 00 00 10 21 03 E0 00 08 00 43 10 23 }
	condition:
		$1
}

rule file_543_3_0 {
	meta:
		name = "__GI_getservent_r"
		size = 768
		refs = "0000 _gp_disp 0050 __GI___errno_location 0070 _pthread_cleanup_push_defer 0078 __pthread_mutex_unlock 009c __pthread_mutex_lock 00e4 $LC2 00f0 $LC3 00f4 __GI_fgets 0124 __GI_fopen 011c $LC0 0120 $LC1 016c __GI_strpbrk 01d4 $LC4 01f8 __GI_atoi 02bc _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A8 2C C2 00 8C AF BC 00 10 AF B4 00 40 AF B1 00 34 AF BF 00 54 AF BE 00 50 AF B7 00 4C AF B6 00 48 AF B5 00 44 AF B3 00 3C AF B2 00 38 AF B0 00 30 00 C0 88 21 00 E0 A0 21 10 40 00 08 AC E0 00 00 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 22 AC 43 00 00 10 00 00 9A 24 02 00 22 8F 95 ?? ?? 8F 99 ?? ?? 00 A0 90 21 8F 85 ?? ?? 27 B3 00 18 26 A6 ?? ?? 00 80 80 21 ?? ?? ?? ?? 02 60 20 21 8F BC 00 10 26 31 FF 74 26 A4 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 2E 31 10 01 12 20 00 08 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 24 10 00 22 24 03 00 22 8F BC 00 10 10 00 00 7D AC 43 00 00 8F 91 ?? ?? 26 59 00 8C AF B9 00 28 8E 22 ?? ?? 10 40 00 0F 02 20 B0 21 8F 97 ?? ?? 8F 9E ?? ?? 26 F7 ?? ?? 27 DE ?? ?? 8F 99 ?? ?? 8F A4 00 28 8E C6 ?? ?? ?? ?? ?? ?? 24 05 10 00 00 40 A8 21 14 40 00 13 8F BC 00 10 10 00 00 0B 8F 99 ?? ?? 8F 84 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 24 84 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? AE 22 ?? ?? 14 40 FF EA 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 24 10 00 05 24 03 00 05 8F BC 00 10 10 00 00 59 AC 43 00 00 80 43 00 00 24 02 00 23 10 62 FF E3 02 A0 20 21 8F 91 ?? ?? 02 20 C8 21 ?? ?? ?? ?? 02 E0 28 21 10 40 FF DD 8F BC 00 10 A0 40 00 00 02 A0 20 21 AE 15 00 00 02 20 C8 21 ?? ?? ?? ?? 03 C0 28 21 8F BC 00 10 10 40 FF D4 8F 95 ?? ?? 24 43 00 01 A0 40 00 00 24 05 00 20 24 04 00 09 80 62 00 00 14 45 00 03 00 00 00 00 10 00 FF FC 24 63 00 01 50 44 FF FA 24 63 00 01 8F 82 ?? ?? 00 60 20 21 AF A3 00 2C 02 20 C8 21 ?? ?? ?? ?? 24 45 ?? ?? 8F BC 00 10 10 40 FF C0 8F A3 00 2C 8F 99 ?? ?? 00 60 20 21 A0 40 00 00 ?? ?? ?? ?? 24 56 00 01 8F BC 00 10 30 42 FF FF AE 02 00 08 8F 99 ?? ?? AE 16 00 0C AE 12 00 04 02 C0 20 21 ?? ?? ?? ?? 26 A5 ?? ?? 10 40 00 04 8F BC 00 10 24 44 00 01 10 00 00 02 A0 40 00 00 00 00 20 21 24 16 00 20 24 17 00 09 26 5E 00 88 26 B5 ?? ?? 50 80 00 16 AE 40 00 00 80 82 00 00 50 40 00 13 AE 40 00 00 50 56 FF FA 24 84 00 01 14 57 00 03 02 5E 10 2B 10 00 FF F6 24 84 00 01 10 40 00 03 02 20 C8 21 AE 44 00 00 26 52 00 04 ?? ?? ?? ?? 02 A0 28 21 10 40 00 04 8F BC 00 10 24 44 00 01 10 00 FF EB A0 40 00 00 AE 40 00 00 AE 90 00 00 00 00 80 21 8F 99 ?? ?? 02 60 20 21 ?? ?? ?? ?? 24 05 00 01 02 00 10 21 8F BF 00 54 8F BE 00 50 8F B7 00 4C 8F B6 00 48 8F B5 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 58 }
	condition:
		$1
}

rule file_543_5_0 {
	meta:
		name = "__GI_getservbyname_r"
		size = 392
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 0024 __pthread_mutex_unlock 006c __pthread_mutex_lock 0080 __GI_setservent 0090 __GI_strcmp 0094 __GI_getservent_r 0124 _pthread_cleanup_pop_restore 0128 __GI_endservent"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B0 AF B5 00 3C 8F 95 ?? ?? 8F 99 ?? ?? AF B4 00 38 00 A0 A0 21 8F 85 ?? ?? AF B2 00 30 27 B2 00 18 AF BF 00 4C AF BC 00 10 AF BE 00 48 AF B7 00 44 AF B3 00 34 AF B0 00 28 AF B6 00 40 AF B1 00 2C 00 80 98 21 00 C0 80 21 02 40 20 21 26 A6 ?? ?? ?? ?? ?? ?? 00 E0 B8 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 A4 ?? ?? 8F BC 00 10 8F 95 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 8E A4 ?? ?? 8F BC 00 10 8F 9E ?? ?? 8F 99 ?? ?? 8F A6 00 60 8F A7 00 64 02 00 20 21 ?? ?? ?? ?? 02 E0 28 21 00 40 88 21 14 40 00 1A 8F BC 00 10 8E 05 00 00 03 C0 C8 21 ?? ?? ?? ?? 02 60 20 21 8F BC 00 10 10 40 00 0B 8F 91 ?? ?? 8E 16 00 04 8E C5 00 00 10 A0 FF ED 02 20 C8 21 ?? ?? ?? ?? 02 60 20 21 10 40 00 03 8F BC 00 10 10 00 FF F8 26 D6 00 04 12 80 00 06 02 20 C8 21 8E 04 00 0C ?? ?? ?? ?? 02 80 28 21 14 40 FF E0 8F BC 00 10 00 00 88 21 8E A3 ?? ?? 14 60 00 06 8F 99 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 99 ?? ?? 02 40 20 21 ?? ?? ?? ?? 24 05 00 01 8F A3 00 64 8F BF 00 4C 8F BE 00 48 8C 62 00 00 8F B7 00 44 8F B6 00 40 00 02 88 0B 02 20 10 21 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_543_6_0 {
	meta:
		name = "getservbyname"
		size = 116
		refs = "0000 _gp_disp 0028 __initbuf 0044 __GI_getservbyname_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF C8 AF BF 00 34 AF BC 00 18 AF A4 00 28 AF A5 00 2C 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 18 8F A4 00 28 8F A5 00 2C 8F 82 ?? ?? 8F 86 ?? ?? 8F 99 ?? ?? 8C 47 ?? ?? 24 02 10 8D AF A2 00 10 27 A2 00 20 AF A2 00 14 ?? ?? ?? ?? 24 C6 ?? ?? 8F BF 00 34 8F A2 00 20 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_543_8_0 {
	meta:
		name = "__GI_getservbyport"
		size = 116
		refs = "0000 _gp_disp 0028 __initbuf 0044 __GI_getservbyport_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF C8 AF BF 00 34 AF BC 00 18 AF A4 00 28 AF A5 00 2C 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 18 8F A4 00 28 8F A5 00 2C 8F 82 ?? ?? 8F 86 ?? ?? 8F 99 ?? ?? 8C 47 ?? ?? 24 02 10 8D AF A2 00 10 27 A2 00 20 AF A2 00 14 ?? ?? ?? ?? 24 C6 ?? ?? 8F BF 00 34 8F A2 00 20 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_543_7_0 {
	meta:
		name = "__GI_getservbyport_r"
		size = 336
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 0024 __pthread_mutex_unlock 006c __pthread_mutex_lock 0080 __GI_setservent 0090 __GI_getservent_r 0094 __GI_strcmp 00ec _pthread_cleanup_pop_restore 00f0 __GI_endservent"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B0 AF B1 00 2C 8F 91 ?? ?? 8F 99 ?? ?? AF B3 00 34 00 A0 98 21 8F 85 ?? ?? AF B2 00 30 27 B2 00 18 AF BF 00 4C AF BC 00 10 AF BE 00 48 AF B7 00 44 AF B6 00 40 AF B5 00 3C AF B4 00 38 AF B0 00 28 00 80 B8 21 00 C0 80 21 02 40 20 21 26 26 ?? ?? ?? ?? ?? ?? 00 E0 B0 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 24 ?? ?? 8F BC 00 10 8F 94 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 8E 84 ?? ?? 8F BC 00 10 8F 95 ?? ?? 8F 9E ?? ?? 8F A6 00 60 8F A7 00 64 02 00 20 21 02 A0 C8 21 ?? ?? ?? ?? 02 C0 28 21 00 40 88 21 14 40 00 0B 8F BC 00 10 8E 02 00 08 14 57 FF F6 8F A6 00 60 12 60 00 06 03 C0 C8 21 8E 04 00 0C ?? ?? ?? ?? 02 60 28 21 14 40 FF EE 8F BC 00 10 8E 82 ?? ?? 14 40 00 06 8F 99 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 99 ?? ?? 02 40 20 21 ?? ?? ?? ?? 24 05 00 01 8F A3 00 64 8F BF 00 4C 8F BE 00 48 8C 62 00 00 8F B7 00 44 8F B6 00 40 00 02 88 0B 02 20 10 21 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_544_0_0 {
	meta:
		name = "__GI_readlink"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F F5 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_546_0_0 {
	meta:
		name = "__decode_header"
		size = 188
	strings:
		$1 = { 90 82 00 00 90 83 00 01 00 02 12 00 00 43 10 25 AC A2 00 00 80 82 00 02 00 02 17 C2 AC A2 00 04 90 82 00 02 7C 42 18 C0 AC A2 00 08 90 82 00 02 7C 42 00 80 AC A2 00 0C 90 82 00 02 7C 42 00 40 AC A2 00 10 90 82 00 02 30 42 00 01 AC A2 00 14 80 82 00 03 00 02 17 C2 AC A2 00 18 90 82 00 03 30 42 00 0F AC A2 00 1C 90 82 00 04 90 83 00 05 00 02 12 00 00 43 10 25 AC A2 00 20 90 82 00 06 90 83 00 07 00 02 12 00 00 43 10 25 AC A2 00 24 90 82 00 08 90 83 00 09 00 02 12 00 00 43 10 25 AC A2 00 28 90 82 00 0A 90 83 00 0B 00 02 12 00 00 43 10 25 03 E0 00 08 AC A2 00 2C }
	condition:
		$1
}

rule file_547_0_0 {
	meta:
		name = "__GI_truncate"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F FC 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_548_0_0 {
	meta:
		name = "wcstok"
		size = 180
		refs = "0000 _gp_disp 0040 __GI_wcsspn 0064 __GI_wcspbrk"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF BC 00 10 AF B2 00 20 AF B1 00 1C AF B0 00 18 AF BF 00 24 00 80 80 21 00 A0 90 21 14 80 00 04 00 C0 88 21 8C D0 00 00 52 00 00 17 00 00 80 21 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 02 40 28 21 00 02 10 80 02 02 80 21 8E 02 00 00 10 40 00 09 8F BC 00 10 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 02 40 28 21 10 40 00 06 24 43 00 04 10 00 00 05 AC 40 00 00 00 00 18 21 10 00 00 02 00 00 80 21 00 00 18 21 AE 23 00 00 8F BF 00 24 02 00 10 21 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_549_0_0 {
	meta:
		name = "__GI_mmap"
		size = 108
		refs = "0000 _gp_disp 0044 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF B0 00 18 AF BF 00 1C 8F B0 00 34 8F A2 00 30 27 BD FF E0 AF A2 00 10 AF B0 00 14 24 02 0F FA 00 00 00 0C 27 BD 00 20 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_550_0_0 {
	meta:
		name = "_time_t2tm"
		size = 484
		refs = "0000 _gp_disp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 00 C0 10 21 AC C0 00 1C 00 C0 38 21 8F 86 ?? ?? 8C 83 00 00 3C 04 00 02 24 84 0E 76 24 C6 ?? ?? 24 08 00 07 00 A4 28 21 94 CA 00 00 15 48 00 0C 01 40 20 21 00 68 00 1A 01 00 01 F4 00 65 18 21 00 00 20 10 24 84 00 0B 00 88 00 1A 01 00 01 F4 94 C4 00 02 00 04 20 80 24 84 00 01 00 00 58 10 00 64 00 1A 00 80 01 F4 00 00 48 12 71 24 60 02 00 6C 18 23 04 61 00 03 00 00 00 00 00 64 18 21 25 29 FF FF 15 48 00 09 28 8A 00 3D 24 8A FF FF 14 6A 00 06 28 8A 00 3D 8C EA 00 10 24 83 FF FE 25 4A 00 01 AC EA 00 10 28 8A 00 3D 11 40 00 04 24 E4 00 04 AC E3 00 00 10 00 00 02 01 20 18 21 AC E9 00 00 24 C6 00 02 94 C9 00 00 15 20 FF D6 00 80 38 21 8C 86 FF FC 24 05 00 04 54 C5 00 05 8C 85 00 00 24 03 00 03 AC 83 FF FC 24 03 01 6D 8C 85 00 00 8C 86 FF F4 24 07 00 19 00 65 18 21 8C 85 FF F0 AC 83 00 00 00 05 28 80 00 A6 28 21 70 A7 40 02 8C 86 FF F8 01 06 28 21 8C 86 FF FC 00 05 28 80 AC 8B FF FC 00 A6 28 21 24 A6 FE D5 24 A5 06 41 AC 86 FF F8 30 A6 00 03 54 C0 00 0E 8F 85 ?? ?? 24 06 00 64 00 A6 00 1A 00 C0 01 F4 00 00 38 10 54 E0 00 0A 8F 85 ?? ?? 24 06 01 90 00 A6 00 1A 00 C0 01 F4 00 00 38 10 50 E0 00 04 8F 85 ?? ?? 8F 85 ?? ?? 10 00 00 02 24 A5 ?? ?? 24 A5 ?? ?? 24 63 00 01 AC 80 FF F4 90 A6 00 00 00 C3 38 2A 10 E0 00 09 24 A7 FF F5 00 66 18 23 38 C6 00 1D 00 E6 28 0A 8C 86 FF F4 24 A5 00 01 24 C6 00 01 10 00 FF F5 AC 86 FF F4 AC 83 FF F0 8F 83 ?? ?? AC 80 00 04 AC 40 00 24 24 63 ?? ?? 03 E0 00 08 AC 43 00 28 }
	condition:
		$1
}

rule file_551_0_0 {
	meta:
		name = "creat"
		size = 28
		refs = "0000 _gp_disp 000c __GI_open"
		altNames = "creat64"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 00 A0 30 21 ?? ?? ?? ?? 24 05 03 01 }
	condition:
		$1
}

rule file_552_0_0 {
	meta:
		name = "atexit"
		size = 40
		refs = "0000 _gp_disp 000c __dso_handle 001c __cxa_atexit"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 50 40 00 02 00 00 30 21 8C 46 00 00 8F 99 ?? ?? ?? ?? ?? ?? 00 00 28 21 }
	condition:
		$1
}

rule file_553_0_0 {
	meta:
		name = "__GI_signal"
		size = 196
		refs = "0000 _gp_disp 0034 __GI___errno_location 004c __GI___sigaddset 0074 _sigintr 0078 __GI___sigismember 0090 __GI_sigaction"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A8 24 02 FF FF AF BC 00 10 AF BF 00 54 AF B0 00 50 10 A2 00 04 24 82 FF FF 2C 42 00 80 14 40 00 07 00 80 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 10 00 00 1A AC 43 00 00 8F 99 ?? ?? AF A5 00 38 27 A4 00 3C 02 00 28 21 AF A0 00 48 AF A0 00 44 AF A0 00 40 ?? ?? ?? ?? AF A0 00 3C 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 02 00 28 21 8F BC 00 10 3C 03 10 00 00 02 18 0B 8F 99 ?? ?? AF A3 00 34 02 00 20 21 27 A5 00 34 ?? ?? ?? ?? 27 A6 00 18 04 41 00 02 8F A2 00 1C 24 02 FF FF 8F BF 00 54 8F B0 00 50 03 E0 00 08 27 BD 00 58 }
	condition:
		$1
}

rule file_554_0_0 {
	meta:
		name = "pathconf"
		size = 320
		refs = "0000 _gp_disp 002c __GI___errno_location 009c __libc_statfs 00dc __GI_stat"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 38 AF BC 00 10 AF BF 00 C4 AF B1 00 C0 AF B0 00 BC 80 82 00 00 54 40 00 06 2C A2 00 14 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 10 24 03 00 02 10 40 00 0A 00 05 28 80 8F 82 ?? ?? 24 42 ?? ?? 00 45 28 21 8C A2 00 00 00 5C 10 21 00 40 00 08 00 00 00 00 10 00 00 31 24 02 00 7F 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 10 00 00 28 AC 43 00 00 8F 99 ?? ?? ?? ?? ?? ?? AF A4 00 B0 8F BC 00 10 8F A4 00 B0 27 A5 00 18 8F 99 ?? ?? 00 40 80 21 ?? ?? ?? ?? 8C 51 00 00 04 41 00 1F 8F A2 00 40 8E 04 00 00 24 03 00 59 14 83 00 1B 24 02 FF FF 10 00 00 18 AE 11 00 00 10 00 00 17 24 02 10 00 10 00 00 15 00 00 10 21 8F 99 ?? ?? ?? ?? ?? ?? 27 A5 00 18 04 40 00 0D 8F A3 00 2C 34 02 80 00 30 63 F0 00 10 62 00 05 38 63 60 00 24 02 00 01 24 04 FF FF 10 00 00 08 00 83 10 0B 10 00 00 06 24 02 00 01 10 00 00 04 24 02 00 20 10 00 00 02 24 02 FF FF 24 02 00 FF 8F BF 00 C4 8F B1 00 C0 8F B0 00 BC 03 E0 00 08 27 BD 00 C8 }
	condition:
		$1
}

rule file_555_0_0 {
	meta:
		name = "__GI_jrand48_r"
		size = 100
		refs = "0000 _gp_disp 000c __drand48_iterate"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF B1 00 20 AF B0 00 1C AF BC 00 10 AF BF 00 24 00 80 80 21 ?? ?? ?? ?? 00 C0 88 21 04 42 00 07 24 02 FF FF 96 02 00 04 96 03 00 02 00 02 14 00 00 43 10 25 AE 22 00 00 00 00 10 21 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_556_0_0 {
	meta:
		name = "popen"
		size = 552
		refs = "0000 _gp_disp 0058 __GI___errno_location 0074 malloc 008c __GI_pipe 00c4 __GI_fdopen 00e0 __GI_close 00fc fork 0124 __GI_dup2 0178 __GI_execl 016c $LC0 0170 $LC1 0174 $LC2 0198 __GI__exit 01d8 __GI_fclose 01ec free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B0 AF B7 00 48 AF B4 00 3C AF BC 00 18 AF BF 00 4C AF B6 00 44 AF B5 00 40 AF B3 00 38 AF B2 00 34 AF B1 00 30 AF B0 00 2C 80 A2 00 00 24 03 00 77 00 80 B8 21 10 43 00 0A 00 A0 A0 21 24 03 00 72 10 43 00 08 24 13 00 01 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 10 00 00 63 AC 43 00 00 00 00 98 21 8F 99 ?? ?? ?? ?? ?? ?? 24 04 00 0C 00 40 80 21 10 40 00 5C 8F BC 00 18 8F 99 ?? ?? 27 B1 00 20 ?? ?? ?? ?? 02 20 20 21 14 40 00 53 8F BC 00 18 00 13 10 80 02 22 10 21 8C 52 00 00 24 02 00 01 00 53 10 23 00 02 10 80 02 22 88 21 8E 35 00 00 8F 99 ?? ?? 02 80 28 21 ?? ?? ?? ?? 02 A0 20 21 8F BC 00 18 00 40 A0 21 14 40 00 07 8F 91 ?? ?? 02 20 C8 21 ?? ?? ?? ?? 02 A0 20 21 02 40 20 21 10 00 00 3A 02 20 C8 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 14 40 00 26 00 40 B0 21 02 20 C8 21 ?? ?? ?? ?? 02 A0 20 21 12 53 00 09 8F BC 00 18 8F 99 ?? ?? 02 40 20 21 ?? ?? ?? ?? 02 60 28 21 02 20 C8 21 ?? ?? ?? ?? 02 40 20 21 8F BC 00 18 8F 82 ?? ?? 8C 50 ?? ?? 12 00 00 07 02 20 C8 21 8E 02 00 04 ?? ?? ?? ?? 8C 44 00 04 8F BC 00 18 10 00 FF F9 8E 10 00 00 8F 84 ?? ?? 8F 85 ?? ?? 8F 86 ?? ?? 8F 99 ?? ?? 24 84 ?? ?? AF A0 00 10 24 A5 ?? ?? 24 C6 ?? ?? ?? ?? ?? ?? 02 E0 38 21 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 24 04 00 7F 02 20 C8 21 ?? ?? ?? ?? 02 40 20 21 1A C0 00 09 8F BC 00 18 8F 82 ?? ?? AE 16 00 08 AE 14 00 04 8C 43 ?? ?? AC 50 ?? ?? 02 80 10 21 10 00 00 0A AE 03 00 00 8F 99 ?? ?? 02 80 20 21 03 20 F8 09 00 00 00 00 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 00 00 10 21 8F BF 00 4C 8F B7 00 48 8F B6 00 44 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_556_1_0 {
	meta:
		name = "pclose"
		size = 280
		refs = "0000 _gp_disp 006c __GI___errno_location 00a8 free 00c0 __GI_fclose 00d0 __GI_waitpid"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 83 ?? ?? 27 BD FF C8 AF BC 00 10 8C 62 ?? ?? AF BF 00 34 AF B4 00 30 AF B3 00 2C AF B2 00 28 AF B1 00 24 AF B0 00 20 10 40 00 1A 00 80 80 21 8C 44 00 04 14 90 00 08 8C 44 00 00 AC 64 ?? ?? 10 00 00 16 00 40 20 21 50 70 00 0B 8C 83 00 00 00 80 10 21 8C 44 00 00 54 80 FF FB 8C 83 00 04 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 10 00 00 08 AC 43 00 00 10 00 00 08 AC 43 00 00 ?? ?? ?? ?? 00 00 00 00 8C 42 00 00 10 50 00 10 02 80 20 21 10 00 00 15 24 02 FF FF 8F 99 ?? ?? 8C 94 00 08 ?? ?? ?? ?? 27 B3 00 18 8F BC 00 10 02 00 20 21 8F 99 ?? ?? ?? ?? ?? ?? 24 10 00 04 8F BC 00 10 8F 92 ?? ?? 8F 91 ?? ?? 02 80 20 21 02 60 28 21 02 40 C8 21 ?? ?? ?? ?? 00 00 30 21 04 40 FF E7 02 20 C8 21 8F A2 00 18 8F BF 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_557_0_0 {
	meta:
		name = "rand_r"
		size = 72
	strings:
		$1 = { 8C 85 00 00 3C 03 41 C6 24 63 4E 6D 70 A3 28 02 24 A5 30 39 7C A2 54 00 70 A3 28 02 00 02 12 80 24 A5 30 39 70 A3 18 02 7C A6 4C 00 00 46 10 26 00 02 2A 80 24 63 30 39 7C 62 4C 00 AC 83 00 00 03 E0 00 08 00 A2 10 25 }
	condition:
		$1
}

rule file_558_0_0 {
	meta:
		name = "callrpc"
		size = 792
		refs = "0000 _gp_disp 000c __rpc_thread_variables 0068 calloc 0094 malloc 00d8 __GI_strcmp 0100 __GI_close 0140 __GI_gethostbyname_r 0148 __GI___errno_location 01e0 __GI_memcpy 0218 __GI_clntudp_create 0244 __GI___rpc_thread_createerr 025c __GI_strncpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF 68 AF BE 00 90 AF B5 00 84 03 A0 F0 21 AF B4 00 80 AF B3 00 7C AF B2 00 78 AF B1 00 74 AF B0 00 70 AF BC 00 20 AF BF 00 94 AF B7 00 8C AF B6 00 88 00 80 80 21 00 A0 90 21 00 C0 88 21 ?? ?? ?? ?? 00 E0 98 21 8C 55 00 A4 8F DC 00 20 16 A0 00 09 00 40 A0 21 8F 99 ?? ?? 24 04 00 01 ?? ?? ?? ?? 24 05 00 18 00 40 A8 21 10 40 00 98 8F DC 00 20 AE 82 00 A4 8E A2 00 14 54 40 00 0A 8E A2 00 10 8F 99 ?? ?? ?? ?? ?? ?? 24 04 01 00 8F DC 00 20 AE A2 00 14 A0 40 00 00 24 02 FF FF AE A2 00 04 8E A2 00 10 50 40 00 0E 8E A4 00 04 8E A2 00 08 54 52 00 0B 8E A4 00 04 8E A2 00 0C 54 51 00 08 8E A4 00 04 8F 99 ?? ?? 8E A4 00 14 ?? ?? ?? ?? 02 00 28 21 10 40 00 69 8F DC 00 20 8E A4 00 04 24 14 FF FF 10 94 00 06 AE A0 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F DC 00 20 AE B4 00 04 8E A4 00 00 10 80 00 08 27 D9 00 5C 8C 82 00 04 8C 59 00 10 03 20 F8 09 00 00 00 00 8F DC 00 20 AE A0 00 00 27 D9 00 5C AF D9 00 60 8F 96 ?? ?? 27 D9 00 4C 8F 97 ?? ?? 27 BD FB F8 AF D9 00 64 27 D9 00 28 27 A6 00 20 24 14 04 00 AF D9 00 68 27 C2 00 5C 27 D9 00 4C AF B9 00 14 AF A2 00 10 02 00 20 21 27 C5 00 28 02 C0 C8 21 ?? ?? ?? ?? 02 80 38 21 10 40 00 11 8F DC 00 20 8F C4 00 4C 24 02 FF FF 14 82 00 3B 02 E0 C8 21 ?? ?? ?? ?? 00 00 00 00 8C 44 00 00 24 02 00 22 14 82 00 35 00 14 A0 40 26 82 00 0E 00 02 10 C2 00 02 10 C0 03 A2 E8 23 10 00 FF E6 27 A6 00 20 8F C2 00 5C 50 40 FF EF 8F C4 00 4C 8C 45 00 10 8F 99 ?? ?? 8C 46 00 0C 8C A5 00 00 24 04 00 05 AF C4 00 54 AF C0 00 58 ?? ?? ?? ?? 27 C4 00 40 8F DC 00 20 24 02 00 02 A7 C2 00 3C 26 A2 00 04 AF A2 00 14 8F C2 00 58 8F 99 ?? ?? 8F C7 00 54 A7 C0 00 3E AF A2 00 10 27 C4 00 3C 02 40 28 21 ?? ?? ?? ?? 02 20 30 21 8F DC 00 20 14 40 00 06 AE A2 00 00 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 24 8C 42 00 00 8E A4 00 14 8F 99 ?? ?? 24 02 00 01 AE A2 00 10 AE B2 00 08 AE B1 00 0C 02 00 28 21 ?? ?? ?? ?? 24 06 00 FF 8E A2 00 14 10 00 00 03 A0 40 00 FF 10 00 00 16 24 02 00 0D 24 02 00 19 AF C2 00 4C AF C0 00 50 8E A4 00 00 8F C6 00 B0 8F C7 00 AC 8C 85 00 04 AF A6 00 10 8F C6 00 B4 AF A2 00 18 AF A0 00 1C AF A6 00 14 8C B9 00 00 8F C6 00 A8 03 20 F8 09 02 60 28 21 54 40 00 04 AE A0 00 10 10 00 00 03 03 C0 E8 21 00 00 10 21 03 C0 E8 21 8F BF 00 94 8F BE 00 90 8F B7 00 8C 8F B6 00 88 8F B5 00 84 8F B4 00 80 8F B3 00 7C 8F B2 00 78 8F B1 00 74 8F B0 00 70 03 E0 00 08 27 BD 00 98 }
	condition:
		$1
}

rule file_558_1_0 {
	meta:
		name = "__rpc_thread_clnt_cleanup"
		size = 124
		refs = "0000 _gp_disp 000c __rpc_thread_variables 005c free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BC 00 10 AF B0 00 18 AF BF 00 1C ?? ?? ?? ?? 00 00 00 00 8C 50 00 A4 12 00 00 0F 8F BC 00 10 8E 04 00 00 10 80 00 07 8F BF 00 1C 8C 82 00 04 8C 59 00 10 03 20 F8 09 00 00 00 00 8F BC 00 10 8F BF 00 1C 02 00 20 21 8F 99 ?? ?? 8F B0 00 18 ?? ?? ?? ?? 27 BD 00 20 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_559_0_0 {
	meta:
		name = "__GI_brk"
		size = 96
		refs = "0000 _gp_disp 0028 __curbrk 003c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C 00 80 28 21 00 A0 20 21 24 02 0F CD 00 00 00 0C 8F 83 ?? ?? 00 45 28 2B AC 62 00 00 10 A0 00 07 00 00 10 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 0C AC 43 00 00 24 02 FF FF 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_560_0_0 {
	meta:
		name = "__GI_strverscmp"
		size = 296
		refs = "0000 _gp_disp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 10 85 00 40 8F 88 ?? ?? 90 82 00 00 24 86 00 01 24 A3 00 01 90 A4 00 00 38 47 00 30 24 45 FF D0 2C E7 00 01 2C A5 00 0A 00 E5 38 21 25 08 ?? ?? 00 44 28 23 54 A0 00 10 38 82 00 30 50 40 00 0E 38 82 00 30 90 C2 00 00 00 E8 38 21 90 E5 00 00 38 49 00 30 24 47 FF D0 2D 29 00 01 2C E7 00 0A 01 27 38 21 90 64 00 00 00 E5 38 25 24 63 00 01 10 00 FF EF 24 C6 00 01 24 84 FF D0 2C 42 00 01 2C 84 00 0A 00 44 20 21 8F 82 ?? ?? 00 07 38 80 00 87 38 25 24 42 ?? ?? 00 E2 38 21 80 E2 00 00 24 04 00 02 10 44 00 19 24 04 00 03 50 44 00 0B 90 C2 00 00 03 E0 00 08 00 00 00 00 24 62 00 01 90 63 00 00 24 63 FF D0 2C 63 00 0A 10 60 00 11 00 80 30 21 00 40 18 21 90 C2 00 00 24 42 FF D0 2C 42 00 0A 14 40 FF F5 24 C4 00 01 90 63 00 00 24 02 FF FF 24 63 FF D0 2C 63 00 0A 03 E0 00 08 00 A3 10 0A 03 E0 00 08 00 00 10 21 03 E0 00 08 00 A0 10 21 03 E0 00 08 24 02 00 01 }
	condition:
		$1
}

rule file_561_0_0 {
	meta:
		name = "drand48"
		size = 64
		refs = "0000 _gp_disp 000c __libc_drand48_data 0010 __GI_erand48_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 84 ?? ?? 8F 99 ?? ?? 27 BD FF D8 27 A6 00 18 AF BF 00 24 AF BC 00 10 ?? ?? ?? ?? 00 80 28 21 8F BF 00 24 8F A3 00 1C 8F A2 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_562_0_0 {
	meta:
		name = "__GI_mkdir"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F C7 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_563_0_0 {
	meta:
		name = "clnttcp_geterr"
		size = 32
	strings:
		$1 = { 8C 82 00 08 8C 43 00 24 AC A3 00 00 8C 43 00 28 AC A3 00 04 8C 42 00 2C 03 E0 00 08 AC A2 00 08 }
	condition:
		$1
}

rule file_563_1_0 {
	meta:
		name = "clnttcp_freeres"
		size = 28
	strings:
		$1 = { 8C 84 00 08 24 02 00 02 00 A0 C8 21 AC 82 00 4C 00 C0 28 21 03 20 00 08 24 84 00 4C }
	condition:
		$1
}

rule file_563_3_0 {
	meta:
		name = "clnttcp_control"
		size = 268
		refs = "0000 _gp_disp 008c __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 24 A5 FF FF 2C A3 00 0F 10 60 00 3B 8C 82 00 08 8F 83 ?? ?? 00 05 28 80 27 BD FF E0 24 63 ?? ?? 00 65 28 21 8C A3 00 00 AF BC 00 10 AF BF 00 1C 00 7C 18 21 00 60 00 08 00 00 00 00 24 03 00 01 10 00 00 24 AC 43 00 04 10 00 00 22 AC 40 00 04 8C C3 00 00 AC 43 00 08 8C C3 00 04 AC 43 00 0C 24 03 00 01 10 00 00 1B AC 43 00 10 8C 43 00 08 AC C3 00 00 8C 42 00 0C 10 00 00 16 AC C2 00 04 8F 99 ?? ?? 00 C0 20 21 24 45 00 14 ?? ?? ?? ?? 24 06 00 10 10 00 00 15 24 02 00 01 10 00 00 0C 8C 42 00 00 10 00 00 0A 8C 42 00 30 8C C3 00 00 24 63 FF FF AC 43 00 30 10 00 00 05 8C 42 00 40 8C C3 00 00 10 00 00 03 AC 43 00 40 8C 42 00 3C AC C2 00 00 10 00 00 05 24 02 00 01 8C C3 00 00 10 00 FF FC AC 43 00 3C 00 00 10 21 8F BF 00 1C 03 E0 00 08 27 BD 00 20 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_563_4_0 {
	meta:
		name = "clnttcp_destroy"
		size = 136
		refs = "0000 _gp_disp 0030 __GI_close 004c free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B1 00 20 AF BC 00 10 AF BF 00 24 AF B0 00 1C 8C 90 00 08 8E 02 00 04 10 40 00 05 00 80 88 21 8F 99 ?? ?? ?? ?? ?? ?? 8E 04 00 00 8F BC 00 10 8E 02 00 50 8C 59 00 1C 53 20 00 05 8F 99 ?? ?? 03 20 F8 09 26 04 00 4C 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F BF 00 24 8F B0 00 1C 02 20 20 21 8F 99 ?? ?? 8F B1 00 20 ?? ?? ?? ?? 27 BD 00 28 }
	condition:
		$1
}

rule file_563_5_0 {
	meta:
		name = "clnttcp_call"
		size = 796
		refs = "0000 _gp_disp 0154 __GI_xdrrec_endofrecord 0188 _null_auth 0194 __GI_xdr_void 01b4 __GI_xdrrec_skiprecord 01e4 __GI_xdr_replymsg 021c __GI__seterr_reply 02a0 __GI_xdr_opaque_auth"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 88 AF B1 00 54 AF B0 00 50 AF BC 00 10 AF BF 00 74 AF BE 00 70 AF B7 00 6C AF B6 00 68 AF B5 00 64 AF B4 00 60 AF B3 00 5C AF B2 00 58 8C 96 00 08 00 80 88 21 AF A5 00 7C 8E C2 00 10 AF A6 00 80 AF A7 00 84 14 40 00 05 26 D0 00 4C 8F A2 00 90 AE C2 00 08 8F A2 00 94 AE C2 00 0C 8F B9 00 88 17 20 00 06 24 12 00 01 8E C2 00 08 14 40 00 04 27 B9 00 7C 8E D2 00 0C 00 12 90 2B 27 B9 00 7C AF B9 00 4C 27 B9 00 18 24 13 00 02 26 D7 00 30 AF B9 00 48 8E D5 00 30 8E C2 00 50 AE C0 00 4C 26 B5 FF FF AE C0 00 24 AE D5 00 30 8C 59 00 0C 8E C6 00 48 02 00 20 21 03 20 F8 09 02 E0 28 21 14 40 00 07 8F BC 00 10 8E C2 00 24 54 40 00 1B 02 00 20 21 24 02 00 01 10 00 00 17 AE C2 00 24 8E C2 00 50 02 00 20 21 8C 59 00 04 03 20 F8 09 27 A5 00 7C 10 40 FF F4 8F BC 00 10 8E 24 00 00 8C 82 00 20 8C 59 00 04 03 20 F8 09 02 00 28 21 10 40 FF ED 8F BC 00 10 8F A5 00 84 8F B9 00 80 03 20 F8 09 02 00 20 21 14 40 00 07 8F BC 00 10 10 00 FF E6 8E C2 00 24 02 00 20 21 24 05 00 01 10 00 00 58 8F 99 ?? ?? 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 02 40 28 21 14 40 00 03 8F BC 00 10 10 00 00 0A 24 02 00 03 12 40 00 5C 00 00 10 21 8E C2 00 08 14 40 00 07 8F 94 ?? ?? 8E C2 00 0C 14 40 00 05 8F 9E ?? ?? 24 02 00 05 10 00 00 53 AE C2 00 24 8F 9E ?? ?? 24 02 00 01 AE C2 00 4C 8E 82 00 00 8F 99 ?? ?? AF A0 00 34 AF A2 00 24 8E 82 00 04 AF BE 00 38 02 00 20 21 AF A2 00 28 8E 82 00 08 ?? ?? ?? ?? AF A2 00 2C 10 40 00 42 8F BC 00 10 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 27 A5 00 18 14 40 00 06 8F BC 00 10 8E C2 00 24 50 40 FF EC 8E 82 00 00 10 00 00 39 8F BF 00 74 8F A2 00 18 54 55 FF E7 8E 82 00 00 8F 99 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 26 C5 00 24 8E C2 00 24 14 40 00 24 00 00 00 00 8E 24 00 00 27 B1 00 24 8C 82 00 20 8C 59 00 08 03 20 F8 09 02 20 28 21 14 40 00 06 8F BC 00 10 24 02 00 07 AE C2 00 24 24 02 00 06 10 00 00 0C AE C2 00 28 8F A5 00 8C 8F B9 00 88 03 20 F8 09 02 00 20 21 14 40 00 06 8F BC 00 10 8E C2 00 24 14 40 00 04 8F A2 00 28 24 02 00 02 AE C2 00 24 8F A2 00 28 10 40 00 12 8F 99 ?? ?? 24 02 00 02 AE C2 00 4C 02 00 20 21 02 20 28 21 03 20 F8 09 00 00 00 00 10 00 00 0B 8E C2 00 24 12 60 00 08 26 75 FF FF 8E 24 00 00 8C 82 00 20 8C 59 00 0C 03 20 F8 09 00 00 00 00 14 40 FF 70 02 A0 98 21 8E C2 00 24 8F BF 00 74 8F BE 00 70 8F B7 00 6C 8F B6 00 68 8F B5 00 64 8F B4 00 60 8F B3 00 5C 8F B2 00 58 8F B1 00 54 8F B0 00 50 03 E0 00 08 27 BD 00 78 }
	condition:
		$1
}

rule file_563_6_0 {
	meta:
		name = "writetcp"
		size = 192
		refs = "0000 _gp_disp 0014 __GI_write 0068 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B4 00 2C 8F 94 ?? ?? AF B5 00 30 AF B3 00 28 AF B2 00 24 AF B1 00 20 AF B0 00 1C AF BC 00 10 AF BF 00 34 00 80 88 21 00 A0 90 21 00 C0 98 21 00 C0 80 21 24 15 FF FF 1A 00 00 13 02 40 28 21 8E 24 00 00 02 80 C8 21 ?? ?? ?? ?? 02 00 30 21 14 55 00 0A 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8C 42 00 00 AE 22 00 28 24 02 00 03 AE 22 00 24 10 00 00 05 24 02 FF FF 02 02 80 23 10 00 FF ED 02 42 90 21 02 60 10 21 8F BF 00 34 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_563_7_0 {
	meta:
		name = "readtcp"
		size = 368
		refs = "0000 _gp_disp 0054 __GI_poll 0058 __GI___errno_location 00a8 __GI_read"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B1 00 28 AF B0 00 24 AF BC 00 10 00 80 80 21 AF BF 00 44 AF B7 00 40 AF B6 00 3C AF B5 00 38 AF B4 00 34 AF B3 00 30 AF B2 00 2C 00 C0 88 21 8C 84 00 08 8E 03 00 0C 10 C0 00 3E 00 00 10 21 8E 02 00 00 8F 97 ?? ?? 8F 94 ?? ?? AF A2 00 18 24 02 00 01 A7 A2 00 1C 24 02 03 E8 00 62 00 1A 00 40 01 F4 00 A0 98 21 27 B6 00 18 70 82 00 00 00 00 A8 12 02 C0 20 21 24 05 00 01 02 E0 C8 21 ?? ?? ?? ?? 02 A0 30 21 24 12 FF FF 10 52 00 06 8F BC 00 10 14 40 00 10 8F 99 ?? ?? 24 02 00 05 10 00 00 0B AE 02 00 24 02 80 C8 21 ?? ?? ?? ?? 00 00 00 00 8C 44 00 00 24 03 00 04 10 83 FF EE 02 C0 20 21 AE 03 00 24 8C 42 00 00 AE 02 00 28 10 00 00 18 24 02 FF FF 8E 04 00 00 02 20 30 21 ?? ?? ?? ?? 02 60 28 21 00 40 88 21 10 52 00 09 8F BC 00 10 14 40 00 0F 02 20 10 21 24 02 00 83 AE 02 00 28 24 02 00 04 AE 02 00 24 10 00 00 08 24 11 FF FF 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8C 42 00 00 AE 02 00 28 24 02 00 04 AE 02 00 24 02 20 10 21 8F BF 00 44 8F B7 00 40 8F B6 00 3C 8F B5 00 38 8F B4 00 34 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_563_8_0 {
	meta:
		name = "__GI_clnttcp_create"
		size = 764
		refs = "0000 _gp_disp 000c malloc 0074 __GI___rpc_thread_createerr 0088 stderr 0090 __GI_fputs 008c $LC0 00bc __GI_pmap_getport 00ec __GI_socket 010c __GI_bindresvport 013c __GI___errno_location 015c __GI_close 0164 free 0168 __GI_connect 018c __GI_memcpy 01b0 _create_xid 01c8 __GI_xdrmem_create 01f8 __GI_xdr_callhdr 0264 __GI_xdrrec_create 029c __GI_authnone_create"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF 90 AF BC 00 18 AF BF 00 6C AF B5 00 68 AF B4 00 64 AF B3 00 60 AF B2 00 5C AF B1 00 58 AF B0 00 54 00 80 98 21 24 04 00 0C 00 A0 A8 21 00 C0 A0 21 ?? ?? ?? ?? 00 E0 90 21 8F BC 00 18 24 04 00 64 8F 99 ?? ?? ?? ?? ?? ?? 00 40 88 21 00 40 80 21 12 20 00 03 8F BC 00 18 54 40 00 11 96 62 00 02 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 18 00 40 90 21 8F 82 ?? ?? 8F 84 ?? ?? 8F 99 ?? ?? 8C 45 00 00 ?? ?? ?? ?? 24 84 ?? ?? 24 02 00 0C 8F BC 00 18 AE 42 00 00 10 00 00 82 AE 42 00 08 54 40 00 0B 8E 42 00 00 8F 99 ?? ?? 02 60 20 21 02 A0 28 21 02 80 30 21 ?? ?? ?? ?? 24 07 00 06 10 40 00 78 8F BC 00 18 A6 62 00 02 8E 42 00 00 04 43 00 28 AE 00 00 04 8F 99 ?? ?? 24 04 00 02 24 05 00 02 ?? ?? ?? ?? 24 06 00 06 8F BC 00 18 00 40 20 21 AE 42 00 00 8F 99 ?? ?? ?? ?? ?? ?? 00 00 28 21 8E 44 00 00 04 81 00 12 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 18 00 40 98 21 24 02 00 0C 8F 99 ?? ?? ?? ?? ?? ?? AE 62 00 00 8C 42 00 00 8F BC 00 18 AE 62 00 08 8E 44 00 00 04 83 00 31 8F 99 ?? ?? 10 00 00 56 8F 99 ?? ?? 8F 99 ?? ?? 02 60 28 21 ?? ?? ?? ?? 24 06 00 10 04 40 FF EA 8F BC 00 18 24 02 00 01 AE 02 00 04 8E 42 00 00 8F 99 ?? ?? 02 60 28 21 26 04 00 14 24 06 00 10 AE 02 00 00 AE 00 00 0C ?? ?? ?? ?? AE 00 00 10 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 26 13 00 4C 8F BC 00 18 AF A2 00 20 24 02 00 02 8F 99 ?? ?? AF A2 00 28 02 60 20 21 26 05 00 30 24 06 00 18 00 00 38 21 AF A0 00 24 AF B5 00 2C ?? ?? ?? ?? AF B4 00 30 8F BC 00 18 02 60 20 21 8F 99 ?? ?? ?? ?? ?? ?? 27 A5 00 20 14 40 00 0A 8F BC 00 18 8E 02 00 04 10 40 00 2A 8F 99 ?? ?? 8E 44 00 00 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 23 8F BC 00 18 8E 02 00 50 8C 59 00 10 03 20 F8 09 02 60 20 21 AE 02 00 48 8E 02 00 50 8C 59 00 1C 13 20 00 04 8F BC 00 18 03 20 F8 09 02 60 20 21 8F BC 00 18 8F 82 ?? ?? 8F 99 ?? ?? 8F A5 00 80 24 42 ?? ?? AF A2 00 10 8F 82 ?? ?? 8F A6 00 84 02 60 20 21 24 42 ?? ?? AF A2 00 14 ?? ?? ?? ?? 02 00 38 21 8F BC 00 18 AE 30 00 08 8F 82 ?? ?? 8F 99 ?? ?? 24 42 ?? ?? ?? ?? ?? ?? AE 22 00 04 AE 22 00 00 10 00 00 09 02 20 10 21 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 00 00 10 21 8F BF 00 6C 8F B5 00 68 8F B4 00 64 8F B3 00 60 8F B2 00 5C 8F B1 00 58 8F B0 00 54 03 E0 00 08 27 BD 00 70 }
	condition:
		$1
}

rule file_565_0_0 {
	meta:
		name = "__GI_iscntrl"
		size = 40
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 00 04 20 40 8C 42 00 00 00 44 10 21 94 42 00 00 03 E0 00 08 30 42 02 00 }
	condition:
		$1
}

rule file_566_0_0 {
	meta:
		name = "__GI___fgetc_unlocked"
		size = 340
		refs = "0000 _gp_disp 0040 __stdio_trans2r_o 00d0 _stdio_openlist 00d4 __GI_fflush_unlocked 00f0 __stdio_rfill 0124 __stdio_READ"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B0 00 20 AF BC 00 10 AF BF 00 24 8C 82 00 10 8C 83 00 18 00 43 18 2B 14 60 00 3A 00 80 80 21 94 82 00 00 30 42 00 83 2C 42 00 81 14 40 00 0F 8F 99 ?? ?? 96 02 00 00 30 43 00 02 50 60 00 11 8E 03 00 10 24 43 FF FF 30 42 00 01 24 42 00 08 00 02 10 80 A6 03 00 00 02 02 10 21 8C 42 00 04 AE 00 00 28 10 00 00 33 30 42 00 FF ?? ?? ?? ?? 24 05 00 80 10 40 FF EF 8F BC 00 10 10 00 00 2D 24 02 FF FF 8E 04 00 14 50 83 00 05 8E 04 00 04 24 62 00 01 AE 02 00 10 10 00 00 26 90 62 00 00 24 03 FF FE 54 83 00 04 30 42 03 00 34 42 00 04 10 00 00 1F A6 02 00 00 50 40 00 07 8E 02 00 08 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8E 02 00 08 8E 03 00 0C 10 62 00 0D 8F 99 ?? ?? AE 02 00 18 ?? ?? ?? ?? 02 00 20 21 50 40 00 10 24 02 FF FF 8E 02 00 14 AE 02 00 18 8E 02 00 10 24 43 00 01 AE 03 00 10 10 00 00 09 90 42 00 00 8F 99 ?? ?? 02 00 20 21 27 A5 00 18 ?? ?? ?? ?? 24 06 00 01 14 40 00 02 93 A2 00 18 24 02 FF FF 8F BF 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_567_0_0 {
	meta:
		name = "__GI_getpwuid_r"
		size = 276
		refs = "0000 _gp_disp 0030 __GI_fopen 0028 $LC0 002c $LC1 0074 __GI___errno_location 0088 __pgsreader 0094 __parsepwent 00d8 __GI_fclose"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B4 00 34 AF B3 00 30 AF B2 00 2C 8F B3 00 58 00 80 A0 21 00 A0 90 21 8F 84 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? AF BC 00 18 AF B6 00 3C AF B5 00 38 AF B1 00 28 AF BF 00 44 AF B7 00 40 AF B0 00 24 24 84 ?? ?? AE 60 00 00 24 A5 ?? ?? 00 C0 A8 21 ?? ?? ?? ?? 00 E0 B0 21 00 40 88 21 14 40 00 06 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 18 8C 50 00 00 8F 97 ?? ?? 24 02 00 01 AE 22 00 34 8F 84 ?? ?? AF B1 00 10 02 40 28 21 02 A0 30 21 02 E0 C8 21 ?? ?? ?? ?? 02 C0 38 21 00 40 80 21 14 40 00 06 8F BC 00 18 8E 42 00 08 14 54 FF F5 8F 84 ?? ?? 10 00 00 03 AE 72 00 00 38 42 00 02 00 02 80 0A 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BF 00 44 02 00 10 21 8F B7 00 40 8F B6 00 3C 8F B5 00 38 8F B4 00 34 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_676_0_0 {
	meta:
		name = "__GI_getgrgid_r"
		size = 276
		refs = "0000 _gp_disp 0030 __GI_fopen 0028 $LC0 002c $LC1 0074 __GI___errno_location 0088 __pgsreader 0094 __parsegrent 00d8 __GI_fclose"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B4 00 34 AF B3 00 30 AF B2 00 2C 8F B3 00 58 00 80 A0 21 00 A0 90 21 8F 84 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? AF BC 00 18 AF B6 00 3C AF B5 00 38 AF B1 00 28 AF BF 00 44 AF B7 00 40 AF B0 00 24 24 84 ?? ?? AE 60 00 00 24 A5 ?? ?? 00 C0 A8 21 ?? ?? ?? ?? 00 E0 B0 21 00 40 88 21 14 40 00 06 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 18 8C 50 00 00 8F 97 ?? ?? 24 02 00 01 AE 22 00 34 8F 84 ?? ?? AF B1 00 10 02 40 28 21 02 A0 30 21 02 E0 C8 21 ?? ?? ?? ?? 02 C0 38 21 00 40 80 21 14 40 00 06 8F BC 00 18 8E 42 00 08 14 54 FF F5 8F 84 ?? ?? 10 00 00 03 AE 72 00 00 38 42 00 02 00 02 80 0A 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BF 00 44 02 00 10 21 8F B7 00 40 8F B6 00 3C 8F B5 00 38 8F B4 00 34 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_568_0_0 {
	meta:
		name = "nice"
		size = 116
		refs = "0000 _gp_disp 002c __GI___errno_location 004c __GI_getpriority"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F C2 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 09 AC 50 00 00 14 40 00 07 8F BF 00 1C 8F B0 00 18 8F 99 ?? ?? 00 00 20 21 00 00 28 21 ?? ?? ?? ?? 27 BD 00 20 8F BF 00 1C 8F B0 00 18 24 02 FF FF 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_569_0_0 {
	meta:
		name = "__GI_vswprintf"
		size = 192
		refs = "0000 _gp_disp 0038 _vfwprintf_internal"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 90 24 02 FF FD AF B0 00 68 00 04 80 27 AF A2 00 1C 00 10 80 82 24 02 08 50 A7 A2 00 18 00 B0 10 2B 00 A2 80 0B 00 10 10 80 8F 99 ?? ?? 00 82 10 21 AF BC 00 10 AF A4 00 20 AF A4 00 28 AF A4 00 2C AF A4 00 30 AF A4 00 34 00 C0 28 21 27 A4 00 18 AF BF 00 6C A3 A0 00 1A AF A0 00 44 AF A0 00 38 AF A2 00 24 ?? ?? ?? ?? 00 E0 30 21 8F A3 00 28 8F A4 00 24 14 64 00 06 00 00 00 00 12 00 00 08 24 02 FF FF 24 63 FF FC 10 00 00 03 AF A3 00 28 12 00 00 04 8F BF 00 6C 8F A3 00 28 AC 60 00 00 8F BF 00 6C 8F B0 00 68 03 E0 00 08 27 BD 00 70 }
	condition:
		$1
}

rule file_570_0_0 {
	meta:
		name = "__GI_ttyname_r"
		size = 540
		refs = "0000 _gp_disp 000c __GI_fstat 005c __GI___errno_location 0070 __GI_isatty 00a0 __GI_strcpy 00c0 __GI_opendir 00dc __GI_lstat 00e8 __GI_readdir 00fc __GI_strlen 0170 __GI_closedir"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FE 68 AF BC 00 10 AF B5 01 84 AF B4 01 80 AF B0 01 70 AF BF 01 94 AF BE 01 90 AF B7 01 8C AF B6 01 88 AF B3 01 7C AF B2 01 78 AF B1 01 74 00 A0 A0 21 27 A5 00 B0 00 80 80 21 ?? ?? ?? ?? 00 C0 A8 21 04 41 00 06 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 60 8C 42 00 00 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 14 40 00 03 8F BC 00 10 10 00 00 54 24 11 00 19 8F 91 ?? ?? 27 B0 01 48 26 31 ?? ?? 82 32 00 00 12 40 FF F9 8F 99 ?? ?? 26 33 00 01 02 00 20 21 ?? ?? ?? ?? 02 60 28 21 8F BC 00 10 02 60 20 21 24 17 00 1E 8F 99 ?? ?? 02 12 B0 21 ?? ?? ?? ?? 02 F2 B8 23 00 40 90 21 10 40 00 3C 8F BC 00 10 8F 9E ?? ?? 27 B9 00 18 AF B9 01 68 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 10 40 00 30 8F BC 00 10 8F 99 ?? ?? 24 45 00 0B 00 A0 20 21 ?? ?? ?? ?? AF A5 01 6C 02 E2 10 2B 8F BC 00 10 14 40 FF F3 8F A5 01 6C 8F 99 ?? ?? ?? ?? ?? ?? 02 C0 20 21 02 00 20 21 03 C0 C8 21 ?? ?? ?? ?? 27 A5 00 18 14 40 FF EA 8F BC 00 10 8F A3 00 2C 24 02 20 00 30 63 F0 00 14 62 FF E6 8F 99 ?? ?? 8F A2 00 40 8F A3 00 D8 14 62 FF E2 8F A2 00 44 8F A3 00 DC 14 62 FF DE 8F 99 ?? ?? 02 40 20 21 ?? ?? ?? ?? 24 11 00 22 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 02 A2 10 2B 14 40 00 10 8F BC 00 10 8F 99 ?? ?? 02 80 20 21 ?? ?? ?? ?? 02 00 28 21 00 00 88 21 10 00 00 09 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 82 31 00 00 26 31 00 01 10 00 FF B1 02 71 88 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 51 00 00 02 20 10 21 8F BF 01 94 8F BE 01 90 8F B7 01 8C 8F B6 01 88 8F B5 01 84 8F B4 01 80 8F B3 01 7C 8F B2 01 78 8F B1 01 74 8F B0 01 70 03 E0 00 08 27 BD 01 98 }
	condition:
		$1
}

rule file_570_1_0 {
	meta:
		name = "ttyname"
		size = 76
		refs = "0000 _gp_disp 0018 __GI_ttyname_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF B0 00 18 8F 90 ?? ?? 8F 99 ?? ?? AF BF 00 1C AF BC 00 10 26 05 ?? ?? ?? ?? ?? ?? 24 06 00 20 8F BF 00 1C 26 10 ?? ?? 00 02 80 0B 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_571_0_0 {
	meta:
		name = "__GI_strspn"
		size = 56
	strings:
		$1 = { 00 00 10 21 80 86 00 00 10 C0 00 09 00 A0 18 21 80 67 00 00 10 E0 00 06 00 00 00 00 14 C7 FF FC 24 63 00 01 24 42 00 01 10 00 FF F6 24 84 00 01 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_572_0_0 {
	meta:
		name = "__GI_strncasecmp"
		size = 116
		refs = "0000 _gp_disp 000c __GI___ctype_tolower"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 87 ?? ?? 10 C0 00 16 00 00 10 21 50 85 00 0E 80 82 00 00 90 82 00 00 8C E3 00 00 00 02 10 40 00 62 10 21 84 48 00 00 90 A2 00 00 00 02 10 40 00 62 18 21 84 62 00 00 01 02 10 23 14 40 00 08 00 00 00 00 80 82 00 00 24 C6 FF FF 24 A5 00 01 10 40 00 03 24 83 00 01 10 00 FF EA 00 60 20 21 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_575_0_0 {
	meta:
		name = "remap_file_pages"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 8F A2 00 30 27 BD FF E0 AF A2 00 10 24 02 10 9B 00 00 00 0C 27 BD 00 20 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_576_0_0 {
	meta:
		name = "memcpy"
		size = 308
	strings:
		$1 = { 28 C8 00 08 15 00 00 2E 00 80 10 21 00 A4 40 26 31 08 00 03 15 00 00 33 00 05 48 23 31 29 00 03 11 20 00 05 00 C9 30 23 88 A8 00 00 00 A9 28 21 A8 88 00 00 00 89 20 21 30 C8 00 1F 11 06 00 16 00 C8 38 23 00 E5 38 21 01 00 30 21 8C A8 00 00 8C A9 00 04 8C AA 00 08 8C AB 00 0C 8C AC 00 10 8C AD 00 14 8C AE 00 18 8C AF 00 1C 24 84 00 20 24 A5 00 20 AC 88 FF E0 AC 89 FF E4 AC 8A FF E8 AC 8B FF EC AC 8C FF F0 AC 8D FF F4 AC 8E FF F8 14 A7 FF EE AC 8F FF FC 30 C8 00 03 11 06 00 08 00 C8 38 23 00 E5 38 21 01 00 30 21 8C A8 00 00 24 84 00 04 24 A5 00 04 14 A7 FF FC AC 88 FF FC 18 C0 00 06 00 C5 38 21 80 A8 00 00 24 84 00 01 24 A5 00 01 14 A7 FF FC A0 88 FF FF 03 E0 00 08 00 00 00 00 00 04 38 23 30 E7 00 03 10 E0 00 06 00 C7 30 23 88 A8 00 00 98 A8 00 03 00 A7 28 21 A8 88 00 00 00 87 20 21 30 C8 00 03 00 C8 38 23 00 E5 38 21 88 A9 00 00 98 A9 00 03 24 84 00 04 24 A5 00 04 14 A7 FF FB AC 89 FF FC 10 00 FF E4 01 00 30 21 }
	condition:
		$1
}

rule file_577_0_0 {
	meta:
		name = "modify_ldt"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 1B 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_578_0_0 {
	meta:
		name = "cfmakeraw"
		size = 84
	strings:
		$1 = { 8C 83 00 00 24 02 FA 14 A0 80 00 16 00 62 10 24 8C 83 00 04 AC 82 00 00 24 02 FF FE 00 62 10 24 8C 83 00 0C AC 82 00 04 24 02 FE B4 00 62 10 24 AC 82 00 0C 8C 82 00 08 24 03 FE CF 00 62 10 24 34 42 00 30 AC 82 00 08 24 02 00 01 03 E0 00 08 A0 82 00 15 }
	condition:
		$1
}

rule file_580_0_0 {
	meta:
		name = "__GI_mbsinit"
		size = 28
	strings:
		$1 = { 10 80 00 04 00 00 00 00 8C 82 00 00 03 E0 00 08 2C 42 00 01 03 E0 00 08 24 02 00 01 }
	condition:
		$1
}

rule file_581_0_0 {
	meta:
		name = "__GI_inet_makeaddr"
		size = 84
	strings:
		$1 = { 2C A3 00 80 10 60 00 04 00 80 10 21 00 05 2E 00 10 00 00 0D 7C C6 B8 00 3C 03 00 01 00 A3 18 2B 10 60 00 04 3C 04 01 00 00 05 2C 00 10 00 00 06 30 C6 FF FF 00 A4 20 2B 10 80 00 04 00 A6 18 25 00 05 2A 00 30 C6 00 FF 00 A6 18 25 03 E0 00 08 AC 43 00 00 }
	condition:
		$1
}

rule file_582_0_0 {
	meta:
		name = "clock_gettime"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 A7 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_583_0_0 {
	meta:
		name = "signalfd"
		size = 92
		refs = "0000 _gp_disp 0034 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 00 C0 38 21 AF BF 00 1C AF B0 00 18 24 06 00 10 24 02 10 E4 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_584_0_0 {
	meta:
		name = "__GI_waitpid"
		size = 48
		refs = "0000 _gp_disp 000c __GI_wait4"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 ?? ?? ?? ?? 00 00 38 21 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_585_0_0 {
	meta:
		name = "__GI_execl"
		size = 192
		refs = "0000 _gp_disp 0098 __environ 009c __GI_execve"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF BE 00 20 03 A0 F0 21 AF C6 00 30 27 C6 00 30 AF BF 00 24 AF BC 00 10 AF C7 00 34 AF C6 00 18 00 00 18 21 8F C7 00 18 24 62 00 01 24 E8 00 04 8C E7 00 00 10 E0 00 03 AF C8 00 18 10 00 FF F9 00 40 18 21 00 03 18 80 24 63 00 16 00 03 18 C2 00 03 18 C0 03 A3 E8 23 27 A3 00 10 AC 65 00 00 AF C6 00 18 00 60 28 21 8F C6 00 18 24 A5 00 04 24 42 FF FF 24 C7 00 04 8C C6 00 00 AF C7 00 18 14 40 FF F9 AC A6 00 00 8F 82 ?? ?? 8F 99 ?? ?? 00 60 28 21 ?? ?? ?? ?? 8C 46 00 00 03 C0 E8 21 8F BF 00 24 8F BE 00 20 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_586_0_0 {
	meta:
		name = "syscall"
		size = 104
		refs = "0000 _gp_disp 005c __syscall_error"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 00 80 10 21 00 A0 20 21 00 C0 28 21 00 E0 30 21 8F A7 00 10 8F A8 00 14 8F A9 00 18 8F AA 00 1C 27 BD FF E0 AF A8 00 10 AF A9 00 14 AF AA 00 18 AF A2 00 1C 8F A2 00 1C 00 00 00 0C 14 E0 00 03 27 BD 00 20 03 E0 00 08 00 00 00 00 00 40 20 21 8F 99 ?? ?? 03 20 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_587_0_0 {
	meta:
		name = "__GI_lseek64"
		size = 136
		refs = "0000 _gp_disp 0048 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF BC 00 10 00 C0 28 21 AF BF 00 24 00 E0 30 21 AF B0 00 20 27 A7 00 18 8F A2 00 38 27 BD FF E0 AF A2 00 10 24 02 10 2C 00 00 00 0C 27 BD 00 20 10 E0 00 07 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 10 00 00 03 24 10 FF FF 50 40 00 04 8F A2 00 18 02 00 18 21 10 00 00 02 00 10 17 C3 8F A3 00 1C 8F BF 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_588_0_0 {
	meta:
		name = "__stdio_rfill"
		size = 84
		refs = "0000 _gp_disp 0014 __stdio_READ"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8C 85 00 08 8C 86 00 0C 8F 99 ?? ?? 27 BD FF E0 00 C5 30 23 AF BF 00 1C AF B0 00 18 AF BC 00 10 ?? ?? ?? ?? 00 80 80 21 8E 03 00 08 8F BF 00 1C AE 03 00 10 00 62 18 21 AE 03 00 14 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_589_0_0 {
	meta:
		name = "__GI_wcspbrk"
		size = 60
	strings:
		$1 = { 8C 83 00 00 10 60 00 0B 00 00 00 00 00 A0 10 21 8C 46 00 00 50 C0 FF FA 24 84 00 04 10 C3 00 03 00 00 00 00 10 00 FF FA 24 42 00 04 03 E0 00 08 00 80 10 21 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_590_0_0 {
	meta:
		name = "__GI_getsid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 37 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_591_0_0 {
	meta:
		name = "clock_settime"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 A6 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_592_0_0 {
	meta:
		name = "_stdlib_strto_l"
		size = 548
		refs = "0000 _gp_disp 0018 __GI___ctype_b 010c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF B1 00 1C 00 C0 88 21 8F 86 ?? ?? AF B4 00 28 AF B3 00 24 AF B0 00 18 AF BC 00 10 AF BF 00 3C AF BE 00 38 AF B7 00 34 AF B6 00 30 AF B5 00 2C AF B2 00 20 00 A0 98 21 00 E0 A0 21 00 80 80 21 82 02 00 00 8C C5 00 00 00 02 18 40 00 A3 18 21 94 63 00 00 30 63 00 20 10 60 00 03 24 03 00 2B 10 00 FF F7 26 10 00 01 10 43 00 05 24 03 00 2D 54 43 00 05 00 00 90 21 10 00 00 02 24 12 00 01 00 00 90 21 26 10 00 01 24 02 FF EF 02 22 10 24 14 40 00 14 26 22 FF FE 82 03 00 00 24 02 00 30 50 62 00 03 82 05 00 01 10 00 00 0A 26 22 00 0A 24 03 00 78 26 04 00 01 34 A5 00 20 14 A3 00 04 26 22 00 08 26 10 00 02 10 00 00 02 00 02 10 40 00 80 80 21 24 11 00 10 28 43 00 11 00 43 88 0B 26 22 FF FE 2C 42 00 23 10 40 00 2B 00 00 18 21 24 15 FF FF 02 B1 00 1B 02 20 01 F4 8F 96 ?? ?? 24 1E 00 22 00 00 B8 10 32 F7 00 FF 00 00 A8 12 82 05 00 00 24 A2 FF D0 30 42 00 FF 2C 46 00 0A 54 C0 00 09 00 51 28 2A 34 A5 00 20 30 A5 00 FF 2C A6 00 61 14 C0 00 03 24 02 00 28 24 A2 FF A9 30 42 00 FF 00 51 28 2A 10 A0 00 13 00 00 00 00 02 A3 20 2B 14 80 00 06 26 10 00 01 14 75 00 0C 70 71 20 02 02 E2 20 2B 50 80 00 09 70 71 20 02 02 C0 C8 21 ?? ?? ?? ?? 02 54 90 24 8F BC 00 10 24 03 FF FF AC 5E 00 00 10 00 FF E1 02 00 20 21 10 00 FF FD 00 82 18 21 56 60 00 01 AE 64 00 00 16 40 00 03 3C 10 80 00 3C 10 7F FF 36 10 FF FF 12 80 00 0B 8F BF 00 3C 02 03 10 2B 10 40 00 09 00 03 10 23 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 22 AC 43 00 00 02 00 18 21 8F BF 00 3C 00 03 10 23 00 72 10 0A 8F BE 00 38 8F B7 00 34 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_594_0_0 {
	meta:
		name = "__GI_tfind"
		size = 120
	strings:
		$1 = { 27 BD FF D8 AF B2 00 20 AF B1 00 1C AF B0 00 18 AF BF 00 24 00 80 90 21 00 A0 80 21 14 A0 00 07 00 C0 88 21 10 00 00 0E 00 00 10 21 28 42 00 00 24 70 00 04 24 63 00 08 00 62 80 0A 8E 02 00 00 10 40 FF F8 02 20 C8 21 8C 45 00 00 03 20 F8 09 02 40 20 21 54 40 FF F5 8E 03 00 00 8E 02 00 00 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_595_0_0 {
	meta:
		name = "sched_setparam"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 3E 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_596_0_0 {
	meta:
		name = "realloc"
		size = 1124
		refs = "0000 _gp_disp 0070 malloc 0084 _pthread_cleanup_push_defer 0088 free 009c __pthread_mutex_unlock 00a0 __malloc_lock 00b8 __pthread_mutex_lock 00d0 __GI___errno_location 0128 __malloc_state 01c4 __GI_abort 0220 __GI_memcpy 0350 __GI_mremap 03d0 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B0 AF BC 00 10 AF B1 00 2C AF B0 00 28 AF BF 00 4C AF BE 00 48 AF B7 00 44 AF B6 00 40 AF B5 00 3C AF B4 00 38 AF B3 00 34 AF B2 00 30 00 80 80 21 14 80 00 0F 00 A0 88 21 8F BF 00 4C 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 8F 99 ?? ?? 00 A0 20 21 ?? ?? ?? ?? 27 BD 00 50 14 A0 00 06 8F 99 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 E7 00 00 10 21 8F 85 ?? ?? 8F 86 ?? ?? 27 B6 00 18 ?? ?? ?? ?? 02 C0 20 21 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 2E 22 FF E0 14 40 00 08 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 0C AC 43 00 00 10 00 00 D3 00 00 10 21 26 31 00 0B 2E 22 00 10 14 40 00 03 24 12 00 10 24 12 FF F8 02 32 90 24 8E 04 FF FC 24 02 FF FC 26 15 FF F8 30 83 00 02 14 60 00 83 00 82 88 24 02 32 18 2B 50 60 00 66 02 32 10 23 8F 85 ?? ?? 02 B1 A0 21 8C A6 00 2C 16 86 00 10 8E 83 00 04 00 43 10 24 00 51 10 21 26 43 00 10 00 43 18 2B 14 60 00 23 8F 99 ?? ?? 30 84 00 01 00 52 10 23 02 B2 A8 21 02 44 20 25 34 42 00 01 AE 04 FF FC AC B5 00 2C 10 00 00 AB AE A2 00 04 24 04 FF FE 00 64 20 24 02 84 20 21 8C 84 00 04 30 84 00 01 14 80 00 13 8F 99 ?? ?? 00 62 10 24 00 51 20 21 00 92 10 2B 14 40 00 0E 00 00 00 00 8E 83 00 08 8C 65 00 0C 14 B4 00 04 8E 82 00 0C 8C 46 00 08 50 C5 00 04 AC 62 00 0C 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 00 80 88 21 10 00 00 38 AC 43 00 08 ?? ?? ?? ?? 26 44 FF F9 00 40 98 21 10 40 00 8C 8F BC 00 10 8C 43 FF FC 24 42 FF F8 16 82 00 05 26 26 FF FC 24 02 FF FC 00 62 10 24 10 00 00 2B 02 22 88 21 00 06 10 82 2C 43 00 0A 54 60 00 07 8E 03 00 00 8F 99 ?? ?? 02 60 20 21 ?? ?? ?? ?? 02 00 28 21 10 00 00 1B 8F BC 00 10 AE 63 00 00 8E 03 00 04 AE 63 00 04 8E 03 00 08 AE 63 00 08 2C 43 00 05 14 60 00 14 8F 99 ?? ?? 8E 03 00 0C AE 63 00 0C 8E 03 00 10 AE 63 00 10 2C 43 00 07 14 60 00 0E 02 00 20 21 8E 03 00 14 AE 63 00 14 8E 03 00 18 AE 63 00 18 24 03 00 09 14 43 00 07 00 00 00 00 8E 02 00 1C AE 62 00 1C 8E 02 00 20 AE 62 00 20 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 02 60 80 21 10 00 00 5B 8F BC 00 10 02 32 10 23 2C 44 00 10 10 80 00 09 8E 03 FF FC 30 63 00 01 02 23 18 25 AE 03 FF FC 02 B1 88 21 8E 22 00 04 34 42 00 01 10 00 00 4F AE 22 00 04 30 63 00 01 02 B2 20 21 02 43 90 25 34 43 00 01 AE 12 FF FC 00 82 10 21 AC 83 00 04 8C 43 00 04 8F 99 ?? ?? 24 84 00 08 34 63 00 01 ?? ?? ?? ?? AC 43 00 04 10 00 00 40 8F BC 00 10 8F 93 ?? ?? 8E 14 FF F8 8E 62 03 5C 26 97 00 04 24 42 FF FF 02 E2 B8 21 02 F2 B8 21 00 02 10 27 02 E2 B8 24 02 F4 F0 23 12 3E 00 34 8F 99 ?? ?? 02 B4 20 23 02 34 28 21 02 E0 30 21 ?? ?? ?? ?? 24 07 00 01 24 03 FF FF 10 43 00 15 8F BC 00 10 00 54 80 21 37 DE 00 02 AE 1E 00 04 8E 62 03 64 00 51 88 23 8E 62 03 70 02 37 88 21 00 51 10 2B 10 40 00 02 AE 71 03 64 AE 71 03 70 8E 62 03 68 02 22 88 21 8E 62 03 74 00 51 10 2B 10 40 00 1B 26 10 00 08 8F 82 ?? ?? 10 00 00 18 AC 51 03 74 26 42 00 04 02 22 10 2B 10 40 00 15 8F 99 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 26 44 FF F9 00 40 90 21 10 40 00 0D 8F BC 00 10 8F 99 ?? ?? 02 00 28 21 00 40 20 21 ?? ?? ?? ?? 26 26 FF F8 8F BC 00 10 02 00 20 21 8F 99 ?? ?? ?? ?? ?? ?? 02 40 80 21 10 00 00 02 8F BC 00 10 00 00 80 21 8F 99 ?? ?? 02 C0 20 21 ?? ?? ?? ?? 24 05 00 01 02 00 10 21 8F BF 00 4C 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_597_0_0 {
	meta:
		name = "_svcauth_unix"
		size = 544
		refs = "0000 _gp_disp 0038 __GI_xdrmem_create 00a4 __GI_memcpy 014c __GI_printf 0148 $LC0 0164 __GI_xdr_authunix_parms"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B0 AF BC 00 10 AF BF 00 4C AF B3 00 3C AF B2 00 38 AF B1 00 34 AF B6 00 48 AF B5 00 44 AF B4 00 40 AF B0 00 30 8C 90 00 18 8F 99 ?? ?? 00 A0 88 21 26 02 00 18 AE 02 00 04 26 02 01 18 AE 02 00 14 8C B4 00 20 8C A5 00 1C 27 B2 00 18 02 80 30 21 24 07 00 01 00 80 98 21 ?? ?? ?? ?? 02 40 20 21 8F A2 00 1C 02 40 20 21 8C 59 00 18 03 20 F8 09 02 80 28 21 10 40 00 37 8F BC 00 10 8C 43 00 00 AE 03 00 00 8C 55 00 04 2E A3 01 00 50 60 00 4F 24 10 00 01 8F 99 ?? ?? 8E 04 00 04 24 56 00 08 02 A0 30 21 ?? ?? ?? ?? 02 C0 28 21 8E 02 00 04 8F BC 00 10 00 55 10 21 A0 40 00 00 26 B5 00 03 24 02 FF FC 02 A2 30 24 02 C6 10 21 8C 43 00 00 AE 03 00 08 8C 43 00 04 AE 03 00 0C 8C 45 00 08 2C A3 00 11 50 60 00 39 24 10 00 01 24 42 00 0C AE 05 00 10 00 00 18 21 00 65 20 2B 10 80 00 08 00 03 20 80 8E 07 00 14 24 42 00 04 00 E4 20 21 8C 47 FF FC 24 63 00 01 10 00 FF F7 AC 87 00 00 24 A2 00 05 00 02 10 80 00 46 10 21 02 82 10 2B 50 40 00 17 8E 23 00 2C 8F 84 ?? ?? 8F 99 ?? ?? 02 80 38 21 ?? ?? ?? ?? 24 84 ?? ?? 10 00 00 0E 00 00 00 00 8F 94 ?? ?? 02 40 20 21 02 80 C8 21 ?? ?? ?? ?? 02 00 28 21 54 40 00 09 8E 23 00 2C 24 02 00 02 AF A2 00 18 02 40 20 21 02 80 C8 21 ?? ?? ?? ?? 02 00 28 21 10 00 00 10 24 10 00 01 10 60 00 0A 8E 62 00 1C 8E 23 00 24 AC 43 00 20 8E 62 00 1C 8E 23 00 28 AC 43 00 24 8E 62 00 1C 8E 23 00 2C 10 00 00 04 AC 43 00 28 AC 40 00 20 8E 62 00 1C AC 40 00 28 00 00 80 21 8F A2 00 1C 8C 59 00 1C 13 20 00 04 8F BF 00 4C 03 20 F8 09 02 40 20 21 8F BF 00 4C 02 00 10 21 8F B6 00 48 8F B5 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_598_0_0 {
	meta:
		name = "__GI_ether_aton_r"
		size = 236
	strings:
		$1 = { 00 00 18 21 24 08 00 05 24 09 00 3A 24 0C 00 06 90 87 00 00 34 E7 00 20 30 E7 00 FF 24 E6 FF D0 30 C6 00 FF 2C C2 00 0A 14 40 00 07 24 82 00 02 24 E2 FF 9F 2C 42 00 06 10 40 00 2A 24 E6 FF A9 30 C6 00 FF 24 82 00 02 10 68 00 05 80 87 00 01 14 E9 00 06 34 EB 00 20 10 00 00 1B 00 A3 20 21 50 E0 00 19 00 A3 20 21 34 EB 00 20 31 67 00 FF 24 EA FF D0 31 4A 00 FF 2D 4D 00 0A 15 A0 00 05 00 06 31 00 24 ED FF 9F 2D AD 00 06 11 A0 00 15 00 00 00 00 29 6B 00 3A 15 60 00 03 30 C6 00 FF 24 E7 FF A9 30 EA 00 FF 01 46 30 21 10 68 00 05 30 C6 00 FF 24 82 00 03 80 84 00 02 14 89 00 09 00 00 00 00 00 A3 20 21 24 63 00 01 10 6C 00 03 A0 86 00 00 10 00 FF CE 00 40 20 21 03 E0 00 08 00 A0 10 21 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_598_2_0 {
	meta:
		name = "__GI_ether_ntoa_r"
		size = 112
		refs = "0000 _gp_disp 0034 __GI_sprintf 004c $LC0"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 AF BF 00 2C AF B0 00 28 AF BC 00 20 90 82 00 02 90 86 00 00 90 87 00 01 AF A2 00 10 90 82 00 03 00 A0 80 21 8F 99 ?? ?? AF A2 00 14 90 82 00 04 AF A2 00 18 90 82 00 05 00 A0 20 21 8F 85 ?? ?? AF A2 00 1C ?? ?? ?? ?? 24 A5 ?? ?? 8F BF 00 2C 02 00 10 21 8F B0 00 28 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_599_0_0 {
	meta:
		name = "__GI_inet_ntop"
		size = 428
		refs = "0000 _gp_disp 0034 __GI_memset 0130 __GI_strlen 014c __GI___errno_location 0160 __GI_strcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 24 02 00 02 AF BC 00 10 AF BF 00 44 AF B3 00 40 AF B2 00 3C AF B1 00 38 AF B0 00 34 14 82 00 52 8F 82 ?? ?? 8F 99 ?? ?? 00 A0 98 21 94 42 ?? ?? 00 00 28 21 00 C0 88 21 A7 A2 00 18 27 A4 00 1A 24 06 00 0F ?? ?? ?? ?? 00 E0 90 21 8F BC 00 10 00 00 50 21 00 00 18 21 24 0B 00 64 27 B0 00 18 24 02 00 30 24 08 00 0A 24 0C 00 2E 24 05 00 04 02 6A 30 21 90 C9 00 00 02 03 38 21 24 64 00 01 01 2B 00 1B 01 60 01 F4 00 00 30 12 24 C6 00 30 7C 06 34 20 14 C2 00 0C A0 E6 00 00 01 28 00 1B 01 00 01 F4 00 00 68 12 01 A8 00 1B 01 00 01 F4 00 00 30 10 24 C6 00 30 A0 E6 00 00 00 C2 30 26 10 00 00 0B 00 86 18 0B 01 28 00 1B 01 00 01 F4 02 04 20 21 24 63 00 02 00 00 38 12 00 E8 00 1B 01 00 01 F4 00 00 30 10 24 C6 00 30 A0 86 00 00 01 28 00 1B 01 00 01 F4 24 64 00 01 02 03 30 21 25 4A 00 01 24 63 00 02 00 00 38 10 24 E9 00 30 A0 C9 00 00 02 04 48 21 15 45 FF D5 A1 2C 00 00 8F 99 ?? ?? A1 20 00 00 ?? ?? ?? ?? 02 00 20 21 02 42 10 2B 10 40 00 06 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 0B 24 03 00 1C 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 02 00 28 21 10 00 00 08 8F BF 00 44 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 7C AC 43 00 00 00 00 10 21 8F BF 00 44 8F B3 00 40 8F B2 00 3C 8F B1 00 38 8F B0 00 34 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_599_1_0 {
	meta:
		name = "__GI_inet_pton"
		size = 280
		refs = "0000 _gp_disp 00d8 __GI_memcpy 00f4 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 24 02 00 02 AF BC 00 10 AF BF 00 24 14 82 00 35 27 A2 00 18 A3 A0 00 18 00 00 18 21 00 00 38 21 00 40 50 21 24 0B 00 2E 24 0C 00 04 24 0D 00 0A 80 A8 00 00 11 00 00 22 24 A4 00 01 25 09 FF D0 2D 25 00 0A 10 A0 00 11 00 00 00 00 90 48 00 00 71 0D 28 02 00 A9 40 21 2D 05 01 00 14 A0 00 03 00 00 00 00 10 00 00 25 00 00 10 21 14 E0 00 11 A0 48 00 00 24 63 00 01 28 65 00 05 14 A0 00 0E 24 07 00 01 10 00 00 1D 00 00 10 21 55 0B 00 1B 00 00 10 21 50 E0 00 19 00 00 10 21 50 6C 00 17 00 00 10 21 A0 40 00 01 00 00 38 21 10 00 00 02 24 42 00 01 24 07 00 01 10 00 FF DD 00 80 28 21 28 63 00 04 14 60 FF E7 8F 99 ?? ?? 00 C0 20 21 01 40 28 21 ?? ?? ?? ?? 24 06 00 04 10 00 00 07 24 02 00 01 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 7C AC 43 00 00 24 02 FF FF 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_600_0_0 {
	meta:
		name = "memset"
		size = 144
	strings:
		$1 = { 28 C9 00 08 15 20 00 1B 00 80 10 21 10 A0 00 05 30 A5 00 FF 00 05 42 00 00 A8 28 25 00 05 44 00 00 A8 28 25 00 04 40 23 31 08 00 03 11 00 00 03 00 C8 30 23 A8 85 00 00 00 88 20 21 30 C8 00 07 11 06 00 07 00 C8 38 23 00 E4 38 21 01 00 30 21 24 84 00 08 AC 85 FF F8 14 87 FF FD AC 85 FF FC 30 C8 00 04 11 00 00 03 00 C8 30 23 AC 85 00 00 24 84 00 04 18 C0 00 04 00 C4 38 21 24 84 00 01 14 87 FF FE A0 85 FF FF 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_601_0_0 {
	meta:
		name = "__GI_fopen64"
		size = 28
		refs = "0000 _gp_disp 000c _stdio_fopen"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 00 00 30 21 ?? ?? ?? ?? 24 07 FF FE }
	condition:
		$1
}

rule file_602_0_0 {
	meta:
		name = "__GI_strcat"
		size = 60
	strings:
		$1 = { 00 80 10 21 00 80 18 21 80 64 00 00 10 80 00 03 24 66 00 01 10 00 FF FC 00 C0 18 21 24 63 FF FF 80 A4 00 00 24 63 00 01 24 A5 00 01 14 80 FF FC A0 64 00 00 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_603_0_0 {
	meta:
		name = "sched_setaffinity"
		size = 400
		refs = "0000 _gp_disp 0068 __GI_getpid 00cc __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF B4 00 28 8F 94 ?? ?? AF BE 00 38 03 A0 F0 21 8E 82 ?? ?? AF B5 00 2C AF B3 00 24 AF B2 00 20 AF BF 00 3C AF B7 00 34 AF B6 00 30 AF B1 00 1C AF B0 00 18 AF BC 00 10 00 80 A8 21 00 A0 90 21 14 40 00 22 00 C0 98 21 27 BD FF 78 27 B1 00 10 24 10 00 80 24 17 00 16 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 00 40 20 21 8F DC 00 10 02 00 28 21 02 20 30 21 24 02 10 90 00 00 00 0C 10 E0 00 0E 00 40 B0 21 14 57 00 0C 00 10 10 40 24 43 00 0E 00 03 18 C2 00 03 18 C0 03 A3 E8 23 27 A3 00 10 00 62 20 21 02 24 20 26 00 50 80 21 00 60 88 21 10 00 FF E9 00 44 80 0B 12 C0 00 1F 8F 99 ?? ?? 14 E0 00 1D 00 00 00 00 AE 96 ?? ?? 8E 82 ?? ?? 00 52 18 2B 10 60 00 0A 02 62 18 21 80 63 00 00 10 60 FF FB 24 42 00 01 8F 99 ?? ?? ?? ?? ?? ?? 24 10 FF FF 24 03 00 16 10 00 00 0D AC 43 00 00 02 A0 20 21 02 40 28 21 02 60 30 21 24 02 10 8F 00 00 00 0C 10 E0 00 0C 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 10 00 00 06 03 C0 E8 21 ?? ?? ?? ?? 24 10 FF FF 10 00 FF FB AC 56 00 00 03 C0 E8 21 8F BF 00 3C 02 00 10 21 8F BE 00 38 8F B7 00 34 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_604_0_0 {
	meta:
		name = "__GI___sigpause"
		size = 156
		refs = "0000 _gp_disp 002c __GI_sigprocmask 0048 __GI_sigdelset 0074 __GI_sigsuspend"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF BC 00 10 AF B1 00 30 AF B0 00 2C AF BF 00 34 00 80 88 21 10 A0 00 0F 27 B0 00 18 8F 99 ?? ?? 24 04 00 01 00 00 28 21 ?? ?? ?? ?? 02 00 30 21 8F BC 00 10 02 00 20 21 8F 99 ?? ?? ?? ?? ?? ?? 02 20 28 21 04 41 00 07 8F BC 00 10 10 00 00 0A 24 02 FF FF AF A0 00 1C AF A0 00 20 AF A0 00 24 AF A4 00 18 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 10 00 00 02 8F BF 00 34 8F BF 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_605_0_0 {
	meta:
		name = "__libc_statfs"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 03 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_606_0_0 {
	meta:
		name = "__GI_execve"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F AB 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_608_0_0 {
	meta:
		name = "ctermid"
		size = 40
		refs = "0000 _gp_disp 001c __GI_strcpy 0010 $LC0"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 14 80 00 03 8F 85 ?? ?? 8F 84 ?? ?? 24 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? }
	condition:
		$1
}

rule file_609_0_0 {
	meta:
		name = "__GI_wait4"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 12 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_610_0_0 {
	meta:
		name = "__GI_setgroups"
		size = 256
		refs = "0000 _gp_disp 000c __GI_sysconf 0044 __GI___errno_location 0068 malloc 00d8 free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BC 00 10 AF B2 00 20 AF B1 00 1C AF BF 00 24 00 80 88 21 AF B0 00 18 24 04 00 03 ?? ?? ?? ?? 00 A0 90 21 00 51 10 2B 10 40 00 08 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 AC 43 00 00 10 00 00 23 24 02 FF FF 12 20 00 07 00 00 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 11 20 80 00 40 80 21 10 40 FF F2 8F BC 00 10 00 00 10 21 00 51 18 2B 10 60 00 07 00 02 18 80 02 03 20 21 02 43 18 21 8C 63 00 00 24 42 00 01 10 00 FF F8 AC 83 00 00 02 20 20 21 02 00 28 21 24 02 0F F1 00 00 00 0C 10 E0 00 07 00 40 88 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 AC 51 00 00 24 11 FF FF 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 02 20 10 21 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_611_0_0 {
	meta:
		name = "__dn_expand"
		size = 84
		refs = "0000 _gp_disp 0014 __GI___ns_name_uncompress"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 8F A2 00 38 8F 99 ?? ?? AF B0 00 20 AF BC 00 18 AF BF 00 24 AF A2 00 10 ?? ?? ?? ?? 00 E0 80 21 18 40 00 04 24 03 00 2E 82 04 00 00 50 83 00 01 A2 00 00 00 8F BF 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_612_0_0 {
	meta:
		name = "inotify_init"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 BC 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_612_1_0 {
	meta:
		name = "inotify_add_watch"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 BD 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_612_2_0 {
	meta:
		name = "inotify_rm_watch"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 BE 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_613_0_0 {
	meta:
		name = "load_field"
		size = 116
		refs = "0000 _gp_disp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 83 ?? ?? 00 04 10 80 00 A2 28 21 24 63 ?? ?? 8C A2 00 00 00 83 18 21 24 05 00 07 10 85 00 07 90 63 00 3A 24 05 00 05 54 85 00 06 00 62 18 2B 24 42 07 6C 10 00 00 02 24 03 27 0F 24 03 01 6D 00 62 18 2B 14 60 00 05 24 03 00 03 14 83 00 04 24 03 FF FF 03 E0 00 08 00 62 10 0A 24 02 FF FF 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_613_1_0 {
	meta:
		name = "__GI_strftime"
		size = 1564
		refs = "0000 _gp_disp 0014 _time_mktime 006c _time_tzset 01bc __GI_nl_langinfo 0204 _uintmaxtostr 025c $LC0 02d0 load_field"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 88 AF B7 00 6C 8F 97 ?? ?? AF BC 00 18 AF A6 00 48 AF BF 00 74 AF BE 00 70 AF B6 00 68 AF B5 00 64 AF B4 00 60 AF B3 00 5C AF B2 00 58 AF B0 00 50 AF A5 00 7C 02 E0 C8 21 00 00 28 21 AF B1 00 54 00 80 80 21 00 E0 20 21 ?? ?? ?? ?? 00 E0 98 21 8F BC 00 18 3C 04 45 98 24 84 4F 00 8F 99 ?? ?? 00 44 20 2A ?? ?? ?? ?? 00 00 A8 21 8F BC 00 18 8F B2 00 7C 8F A6 00 48 8F 94 ?? ?? 8F 9E ?? ?? 26 94 ?? ?? 02 80 B0 21 27 DE ?? ?? 12 40 01 53 00 00 10 21 80 C3 00 00 14 60 00 0C 24 02 00 25 16 A0 00 05 26 B5 FF FF 8F A3 00 7C A2 00 00 00 10 00 01 4A 00 72 10 23 00 15 10 80 03 A2 10 21 8C 42 00 20 10 00 FF F1 00 40 30 21 14 62 01 2D 00 C0 88 21 80 C2 00 01 10 43 01 2A 24 D1 00 01 24 03 00 4F 10 43 00 05 24 03 00 40 24 03 00 45 54 43 00 07 24 03 00 3F 24 03 FF 80 34 63 00 3F 30 63 00 FF 24 D1 00 02 10 00 00 02 24 07 00 03 24 07 00 02 82 28 00 00 35 02 00 20 24 44 FF 9F 30 84 00 FF 2C 84 00 1A 10 80 00 06 01 14 20 21 90 8A FF BF 01 43 18 24 2C 63 00 3F 14 60 00 06 31 4B 00 30 15 00 01 17 26 22 00 01 26 31 FF FF 10 00 01 13 24 E7 FF FF 24 03 00 30 55 63 00 19 24 03 00 20 24 02 00 04 12 A2 01 0D 00 15 48 80 31 42 00 0F 03 A9 48 21 26 31 00 01 2C 44 00 08 26 B7 00 01 10 80 00 06 AD 31 00 20 24 42 00 74 02 82 10 21 90 51 00 00 10 00 00 08 00 51 10 21 31 4A 00 07 01 5E 50 21 91 44 00 00 8F 99 ?? ?? ?? ?? ?? ?? 34 84 03 00 8F BC 00 18 10 00 FF C1 02 E0 A8 21 55 63 00 A7 31 48 00 1F 24 03 00 73 15 03 00 14 24 03 00 7A 8F 99 ?? ?? 02 60 20 21 ?? ?? ?? ?? 00 00 28 21 24 03 FF FF 10 43 00 E7 8F BC 00 18 8F 99 ?? ?? 24 03 FF F6 00 02 37 C3 00 40 38 21 AF A3 00 10 AF A0 00 14 ?? ?? ?? ?? 27 A4 00 3B 00 40 30 21 8F BC 00 18 10 00 00 E0 24 07 00 0C 14 43 00 20 00 00 50 21 8E 62 00 20 04 40 00 D8 24 02 00 5A 55 02 00 07 8E 63 00 24 8E 66 00 28 14 C0 00 D6 24 07 FF FF 8F 86 ?? ?? 10 00 00 D3 24 C6 ?? ?? 24 02 00 2B 04 61 00 04 A2 02 00 00 24 02 00 2D 00 03 18 23 A2 02 00 00 24 04 00 3C 00 64 00 1A 00 80 01 F4 24 06 00 64 26 10 00 01 26 52 FF FF 00 00 18 12 00 64 00 1A 00 80 01 F4 00 00 18 12 00 00 28 10 70 66 20 02 10 00 00 CC 00 85 10 21 8F 8D ?? ?? 27 AB 00 20 24 0C 00 03 02 CA 10 21 90 44 00 49 25 B9 ?? ?? ?? ?? ?? ?? 02 60 28 21 00 0A 18 80 01 63 18 21 8F BC 00 18 04 40 00 B0 AC 62 00 1C 25 4A 00 01 15 4C FF F5 02 CA 10 21 24 03 FF FD 01 03 18 24 24 02 00 55 14 62 00 11 8F AB 00 3C 8F A3 00 40 39 04 00 57 00 6B 18 23 24 62 00 07 24 63 00 08 00 64 10 0A 24 03 00 07 00 43 00 1A 00 60 01 F4 24 04 00 57 24 03 00 12 15 04 00 80 00 00 10 12 2D 6B 00 01 10 00 00 7D 00 4B 10 23 24 05 00 07 24 06 00 64 24 07 01 90 8F A4 00 40 00 8B 68 23 25 AD 00 0B 01 A5 00 1A 00 A0 01 F4 00 00 68 10 25 A2 FF FD 00 82 50 2A 11 40 00 13 8F A3 00 44 24 63 FF FF 30 6A 00 03 AF A3 00 44 15 40 00 0A 00 00 10 21 00 66 00 1A 00 C0 01 F4 00 00 50 10 15 40 00 05 24 02 00 01 00 67 00 1A 00 E0 01 F4 00 00 10 10 2C 42 00 01 24 42 01 6D 00 82 20 21 10 00 FF E5 AF A4 00 40 30 6C 00 03 15 80 00 0A 00 00 50 21 00 66 00 1A 00 C0 01 F4 00 00 60 10 15 80 00 05 24 0A 00 01 00 67 00 1A 00 E0 01 F4 00 00 50 10 2D 4A 00 01 25 4A 01 6D 25 AD 01 73 01 AA 68 23 01 A5 00 1A 00 A0 01 F4 00 00 70 10 01 CA 68 21 25 AD FF FD 00 8D 68 2A 15 A0 00 06 24 0C 00 07 00 8A 20 23 24 63 00 01 AF A4 00 40 10 00 FF C9 AF A3 00 44 00 82 20 23 00 8C 00 1A 01 80 01 F4 24 04 00 56 00 00 10 12 11 04 00 3A 24 42 00 01 24 02 00 67 55 02 00 62 00 60 10 21 24 02 00 64 00 62 00 1A 00 40 01 F4 10 00 00 32 00 00 10 10 8F 99 ?? ?? 01 14 40 21 91 04 00 42 27 39 ?? ?? ?? ?? ?? ?? 02 60 28 21 04 40 00 46 8F BC 00 18 91 05 00 58 24 06 00 0C 24 04 00 64 30 A7 00 80 30 E7 00 FF 00 C7 20 0A 30 A6 00 40 10 C0 00 04 00 A0 18 21 00 44 00 1A 00 80 01 F4 00 00 10 12 30 A6 00 20 50 C0 00 08 30 A4 00 01 00 44 00 1A 00 80 01 F4 00 80 10 21 00 00 30 10 00 E6 38 21 00 C7 10 0B 30 A4 00 01 30 A5 00 08 10 A0 00 03 00 44 10 21 24 04 00 07 00 82 10 0A 24 04 00 10 55 64 00 0E 7C 67 08 40 31 4A 00 0F 02 CA 50 21 91 43 00 6E 8F 99 ?? ?? 00 43 20 21 ?? ?? ?? ?? 34 84 03 00 00 40 30 21 8F BC 00 18 10 00 00 1F 24 07 FF FF 24 03 00 12 7C 67 08 40 24 E7 00 01 27 A4 00 30 00 87 30 21 24 05 00 0A 00 45 00 1A 00 A0 01 F4 24 C6 FF FF 00 00 40 10 25 08 00 30 A0 C8 00 00 00 86 40 2B 15 00 FF F8 00 00 10 12 83 A4 00 30 24 02 00 30 14 82 00 0D 26 22 00 01 30 63 00 10 24 63 00 20 10 00 00 09 A3 A3 00 30 10 00 00 06 24 07 00 01 10 00 00 02 24 07 00 01 00 00 38 21 8F 86 ?? ?? 24 C6 ?? ?? 26 22 00 01 50 E0 FE B9 00 40 30 21 52 40 FE B7 00 40 30 21 80 C3 00 00 10 60 FE C2 24 E7 FF FF A2 03 00 00 24 C6 00 01 26 52 FF FF 10 00 FF F5 26 10 00 01 10 00 FF D5 24 03 00 16 8F BF 00 74 8F BE 00 70 8F B7 00 6C 8F B6 00 68 8F B5 00 64 8F B4 00 60 8F B3 00 5C 8F B2 00 58 8F B1 00 54 8F B0 00 50 03 E0 00 08 27 BD 00 78 }
	condition:
		$1
}

rule file_614_0_0 {
	meta:
		name = "__GI_pmap_getport"
		size = 380
		refs = "0000 _gp_disp 0060 __GI_clntudp_bufcreate 009c __GI___rpc_thread_createerr 00b4 __GI_xdr_u_short 00d8 __GI_xdr_pmap"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A0 24 02 FF FF AF BC 00 20 AF A2 00 38 24 02 00 6F AF B5 00 58 AF B4 00 54 AF B3 00 50 AF B2 00 4C AF B0 00 44 AF BF 00 5C AF B1 00 48 A4 82 00 02 8F 82 ?? ?? 27 A3 00 38 AF A3 00 14 24 03 01 90 AF A3 00 18 AF A3 00 1C 24 43 ?? ?? 8C 63 00 04 8F 99 ?? ?? 00 E0 98 21 8C 47 ?? ?? 00 A0 A8 21 3C 05 00 01 00 C0 A0 21 A7 A0 00 3C AF A3 00 10 34 A5 86 A0 24 06 00 02 ?? ?? ?? ?? 00 80 90 21 00 40 80 21 10 40 00 2E 8F BC 00 20 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 20 00 40 88 21 AF B4 00 2C 8F 82 ?? ?? AF B3 00 30 AF A0 00 34 8E 03 00 04 AF A2 00 10 27 A2 00 3C AF A2 00 14 8F 82 ?? ?? AF B5 00 28 8F 86 ?? ?? 8C 44 ?? ?? 24 42 ?? ?? 8C 42 00 04 AF A4 00 18 24 05 00 03 AF A2 00 1C 8C 79 00 00 02 00 20 21 03 20 F8 09 27 A7 00 28 50 40 00 0A 97 A2 00 3C 24 02 00 0E AE 22 00 00 8E 02 00 04 02 00 20 21 8C 59 00 08 03 20 F8 09 26 25 00 04 10 00 00 06 8E 02 00 04 54 40 00 04 8E 02 00 04 24 02 00 0F AE 22 00 00 8E 02 00 04 8C 59 00 10 03 20 F8 09 02 00 20 21 8F BF 00 5C 97 A2 00 3C 8F B5 00 58 8F B4 00 54 8F B3 00 50 8F B1 00 48 8F B0 00 44 A6 40 00 02 8F B2 00 4C 03 E0 00 08 27 BD 00 60 }
	condition:
		$1
}

rule file_615_0_0 {
	meta:
		name = "rewinddir"
		size = 164
		refs = "0000 _gp_disp 0010 __pthread_mutex_unlock 0014 _pthread_cleanup_push_defer 0048 __pthread_mutex_lock 0060 __GI_lseek 0078 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 8F 85 ?? ?? 8F 99 ?? ?? AF B2 00 30 AF B1 00 2C 24 92 00 18 27 B1 00 18 AF BF 00 34 AF B0 00 28 AF BC 00 10 00 80 80 21 02 40 30 21 ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 8E 04 00 00 00 00 30 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 28 21 8F BC 00 10 02 20 20 21 AE 00 00 08 8F 99 ?? ?? AE 00 00 04 AE 00 00 10 ?? ?? ?? ?? 24 05 00 01 8F BF 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_616_0_0 {
	meta:
		name = "__GI_exit"
		size = 184
		refs = "0000 _gp_disp 0010 _pthread_cleanup_push_defer 0014 __pthread_mutex_unlock 0018 __atexit_lock 0044 __pthread_mutex_lock 0054 __exit_cleanup 0060 _pthread_cleanup_pop_restore 0084 __GI___uClibc_fini 0094 _stdio_term 009c __GI__exit"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 8F 99 ?? ?? 8F 85 ?? ?? 8F 86 ?? ?? AF B1 00 30 27 B1 00 18 AF BC 00 10 AF BF 00 34 AF B0 00 2C 00 80 80 21 ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 82 ?? ?? 8C 59 00 00 53 20 00 05 8F 99 ?? ?? 03 20 F8 09 02 00 20 21 8F BC 00 10 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 24 05 00 01 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 99 ?? ?? 53 20 00 05 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 }
	condition:
		$1
}

rule file_617_0_0 {
	meta:
		name = "_stdlib_wcsto_l"
		size = 540
		refs = "0000 _gp_disp 0014 __GI_iswspace 010c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B6 00 38 8F 96 ?? ?? AF B5 00 34 AF B4 00 30 AF B3 00 2C AF B1 00 24 AF B0 00 20 AF BC 00 10 AF BF 00 44 AF BE 00 40 AF B7 00 3C AF B2 00 28 00 80 98 21 00 A0 A8 21 00 C0 88 21 00 E0 A0 21 00 80 80 21 8E 12 00 00 02 C0 C8 21 ?? ?? ?? ?? 02 40 20 21 10 40 00 03 8F BC 00 10 10 00 FF F9 26 10 00 04 24 02 00 2B 12 42 00 05 24 02 00 2D 56 42 00 05 00 00 90 21 10 00 00 02 24 12 00 01 00 00 90 21 26 10 00 04 24 02 FF EF 02 22 10 24 14 40 00 14 26 22 FF FE 8E 03 00 00 24 02 00 30 50 62 00 03 8E 04 00 04 10 00 00 0A 26 22 00 0A 24 03 00 78 26 13 00 04 34 84 00 20 14 83 00 04 26 22 00 08 26 10 00 08 10 00 00 02 00 02 10 40 02 60 80 21 24 11 00 10 28 43 00 11 00 43 88 0B 26 22 FF FE 2C 42 00 23 10 40 00 29 00 00 18 21 24 16 FF FF 02 D1 00 1B 02 20 01 F4 8F 99 ?? ?? 24 17 00 22 00 00 F0 10 33 DE 00 FF 00 00 B0 12 8E 04 00 00 24 82 FF D0 2C 46 00 0A 54 C0 00 07 30 42 00 FF 34 84 00 20 2C 86 00 61 14 C0 00 03 24 02 00 28 24 82 FF A9 30 42 00 FF 00 51 20 2A 10 80 00 13 02 C3 20 2B 14 80 00 06 26 10 00 04 14 76 00 0D 70 71 20 02 03 C2 20 2B 10 80 00 0A 70 71 20 02 03 20 F8 09 AF B9 00 18 8F BC 00 10 AC 57 00 00 8F B9 00 18 02 54 90 24 24 03 FF FF 10 00 FF E3 02 00 98 21 10 00 FF FD 00 82 18 21 56 A0 00 01 AE B3 00 00 16 40 00 03 3C 10 80 00 3C 10 7F FF 36 10 FF FF 12 80 00 0B 8F BF 00 44 02 03 10 2B 10 40 00 09 00 03 10 23 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 22 AC 43 00 00 02 00 18 21 8F BF 00 44 00 03 10 23 00 72 10 0A 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_618_0_0 {
	meta:
		name = "vmsplice"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 D3 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_620_0_0 {
	meta:
		name = "__syscall_error"
		size = 64
		refs = "0000 _gp_disp 000c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF B0 00 18 AF BC 00 10 ?? ?? ?? ?? 00 80 80 21 AC 50 00 00 8F BF 00 1C 8F B0 00 18 24 02 FF FF 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_621_0_0 {
	meta:
		name = "sched_get_priority_min"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 44 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_622_0_0 {
	meta:
		name = "__stdio_trans2w_o"
		size = 288
		refs = "0000 _gp_disp 0038 __GI___errno_location 0098 __GI_fseek"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF B0 00 18 AF BC 00 10 AF BF 00 1C 94 82 00 00 00 A2 18 24 14 60 00 0B 00 80 80 21 30 43 08 80 50 60 00 07 00 A2 10 25 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 09 10 00 00 1B AC 43 00 00 A4 82 00 00 96 06 00 00 30 C2 00 20 14 40 FF F7 8F 99 ?? ?? 30 C2 00 03 50 40 00 22 96 02 00 00 30 C2 00 04 54 40 00 18 96 02 00 00 8E 03 00 14 8E 02 00 10 10 62 00 11 30 C2 00 02 30 C6 04 00 24 03 00 01 24 02 00 02 8F 99 ?? ?? 00 66 10 0A 02 00 20 21 00 00 28 21 ?? ?? ?? ?? 00 40 30 21 50 40 00 09 96 02 00 00 96 02 00 00 34 42 00 08 A6 02 00 00 10 00 00 12 24 02 FF FF 54 40 FF F0 30 C6 04 00 96 02 00 00 30 42 FF FC A6 02 00 00 8E 02 00 08 AE 02 00 18 AE 02 00 10 AE 02 00 14 96 02 00 00 34 43 00 40 A6 03 00 00 30 43 0B 00 14 60 00 03 00 00 10 21 8E 03 00 0C AE 03 00 1C 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_623_0_0 {
	meta:
		name = "__GI_getegid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F D2 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_624_0_0 {
	meta:
		name = "__sigsetjmp"
		size = 32
		refs = "0000 _gp_disp 0014 __sigsetjmp_aux"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 03 A0 30 21 03 C0 38 21 8F 99 ?? ?? 03 20 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_626_0_0 {
	meta:
		name = "getpw"
		size = 192
		refs = "0000 _gp_disp 0024 __GI___errno_location 003c __GI_getpwuid_r 0078 __GI_sprintf 0064 $LC0"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FE A8 AF BC 00 28 AF B0 01 50 AF BF 01 54 14 A0 00 07 00 A0 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 10 00 00 1D AC 43 00 00 8F 99 ?? ?? 27 A2 01 4C AF A2 00 10 27 A5 01 30 27 A6 00 30 ?? ?? ?? ?? 24 07 01 00 14 40 00 14 8F BC 00 28 8F A2 01 38 8F 85 ?? ?? 8F A6 01 30 AF A2 00 10 8F A2 01 3C 8F A7 01 34 8F 99 ?? ?? AF A2 00 14 8F A2 01 40 02 00 20 21 24 A5 ?? ?? AF A2 00 18 8F A2 01 44 AF A2 00 1C 8F A2 01 48 ?? ?? ?? ?? AF A2 00 20 10 00 00 02 00 02 17 C3 24 02 FF FF 8F BF 01 54 8F B0 01 50 03 E0 00 08 27 BD 01 58 }
	condition:
		$1
}

rule file_627_0_0 {
	meta:
		name = "__GI_strnlen"
		size = 204
	strings:
		$1 = { 10 A0 00 30 00 00 10 21 00 85 28 21 24 02 FF FF 00 A4 18 2B 00 43 28 0B 00 80 10 21 30 43 00 03 10 60 00 06 3C 07 FE FE 80 43 00 00 10 60 00 23 00 A2 18 2B 10 00 FF F9 24 42 00 01 3C 08 80 80 00 40 18 21 34 E7 FE FF 35 08 80 80 00 65 30 2B 50 C0 00 1A 00 A2 18 2B 8C 62 00 00 00 47 10 21 00 48 10 24 10 40 00 11 24 66 00 04 80 62 00 00 10 40 00 11 00 60 10 21 80 62 00 01 54 40 00 03 80 62 00 02 10 00 00 0C 24 62 00 01 54 40 00 03 80 62 00 03 10 00 00 08 24 62 00 02 54 40 00 04 00 A0 10 21 10 00 00 04 24 62 00 03 00 A0 10 21 10 00 FF E6 00 C0 18 21 00 A2 18 2B 00 A3 10 0B 00 44 10 23 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_628_0_0 {
	meta:
		name = "killpg"
		size = 84
		refs = "0000 _gp_disp 0020 __GI_kill 0030 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C 04 80 00 05 8F BF 00 1C 8F 99 ?? ?? 00 04 20 23 ?? ?? ?? ?? 27 BD 00 20 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 AC 43 00 00 8F BF 00 1C 24 02 FF FF 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_629_0_0 {
	meta:
		name = "__error"
		size = 364
		refs = "0000 _gp_disp 000c stdout 0030 __GI_fflush 004c error_print_progname 0058 stderr 006c __uclibc_progname 0074 __GI_fprintf 0070 $LC0 008c __GI_vfprintf 00a8 error_message_count 00c0 __GI_strerror 00dc $LC1 00fc __GI_fputc 012c __GI___fputc_unlocked 0148 __GI_exit"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 27 BD FF C8 AF BC 00 10 AF B3 00 30 AF B2 00 2C AF B1 00 28 AF B0 00 24 AF BF 00 34 AF A7 00 44 8F 99 ?? ?? 00 80 88 21 8C 44 00 00 00 A0 90 21 ?? ?? ?? ?? 00 C0 98 21 8F BC 00 10 8F 82 ?? ?? 8C 59 00 00 13 20 00 05 8F 90 ?? ?? 03 20 F8 09 00 00 00 00 10 00 00 09 8F BC 00 10 8F 82 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 8E 04 00 00 8C 46 00 00 ?? ?? ?? ?? 24 A5 ?? ?? 8F BC 00 10 8F 99 ?? ?? 8E 04 00 00 27 A6 00 44 AF A6 00 18 ?? ?? ?? ?? 02 60 28 21 8F BC 00 10 8F 82 ?? ?? 8C 43 00 00 24 63 00 01 12 40 00 0E AC 43 00 00 8F 82 ?? ?? 8F 99 ?? ?? 02 40 20 21 ?? ?? ?? ?? 8C 53 00 00 8F BC 00 10 02 60 20 21 00 40 30 21 8F 85 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? 8F BC 00 10 8E 05 00 00 8C A2 00 34 10 40 00 0D 8F 99 ?? ?? 8C A2 00 10 8C A3 00 1C 00 43 18 2B 10 60 00 05 24 43 00 01 AC A3 00 10 24 03 00 0A 10 00 00 08 A0 43 00 00 24 04 00 0A 10 00 00 02 8F 99 ?? ?? 24 04 00 0A 03 20 F8 09 00 00 00 00 8F BC 00 10 12 20 00 04 8F BF 00 34 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_629_1_0 {
	meta:
		name = "__error_at_line"
		size = 488
		refs = "0000 _gp_disp 000c error_one_per_line 0068 __GI_strcmp 0084 stdout 0088 __GI_fflush 0098 error_print_progname 00a4 stderr 00b8 __uclibc_progname 00c0 __GI_fprintf 00bc $LC2 00dc $LC3 00fc __GI_vfprintf 0118 error_message_count 0130 __GI_strerror 014c $LC1 016c __GI_fputc 019c __GI___fputc_unlocked 01b8 __GI_exit"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 27 BD FF C0 AF B4 00 34 AF B3 00 30 AF B2 00 2C AF B0 00 24 AF BC 00 10 AF BF 00 3C AF B5 00 38 AF B1 00 28 8C 42 00 00 00 80 98 21 00 A0 A0 21 00 C0 80 21 10 40 00 0F 00 E0 90 21 8F 82 ?? ?? 8F 91 ?? ?? 8C 43 ?? ?? 14 67 00 08 00 40 A8 21 8E 24 ?? ?? 10 C4 00 57 8F 99 ?? ?? ?? ?? ?? ?? 00 C0 28 21 10 40 00 53 8F BC 00 10 AE 30 ?? ?? AE B2 ?? ?? 8F 82 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 8C 44 00 00 8F BC 00 10 8F 82 ?? ?? 8C 59 00 00 13 20 00 05 8F 91 ?? ?? 03 20 F8 09 00 00 00 00 10 00 00 09 8F BC 00 10 8F 82 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 8E 24 00 00 8C 46 00 00 ?? ?? ?? ?? 24 A5 ?? ?? 8F BC 00 10 12 00 00 08 8F 85 ?? ?? 8F 99 ?? ?? 8E 24 00 00 24 A5 ?? ?? 02 00 30 21 ?? ?? ?? ?? 02 40 38 21 8F BC 00 10 8F 99 ?? ?? 8E 24 00 00 8F A5 00 50 27 A6 00 54 ?? ?? ?? ?? AF A6 00 18 8F BC 00 10 8F 82 ?? ?? 8C 43 00 00 24 63 00 01 12 80 00 0E AC 43 00 00 8F 82 ?? ?? 8F 99 ?? ?? 02 80 20 21 ?? ?? ?? ?? 8C 50 00 00 8F BC 00 10 02 00 20 21 00 40 30 21 8F 85 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? 8F BC 00 10 8E 25 00 00 8C A2 00 34 10 40 00 0D 8F 99 ?? ?? 8C A2 00 10 8C A3 00 1C 00 43 18 2B 10 60 00 05 24 43 00 01 AC A3 00 10 24 03 00 0A 10 00 00 08 A0 43 00 00 24 04 00 0A 10 00 00 02 8F 99 ?? ?? 24 04 00 0A 03 20 F8 09 00 00 00 00 8F BC 00 10 12 60 00 05 8F BF 00 3C 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 8F BF 00 3C 8F B5 00 38 8F B4 00 34 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_630_0_0 {
	meta:
		name = "__libc_fstatfs"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 04 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_631_0_0 {
	meta:
		name = "scandir64"
		size = 516
		refs = "0000 _gp_disp 000c __GI_opendir 005c __GI___errno_location 0084 __GI_readdir64 00c0 __GI_closedir 00dc free 0124 __GI_qsort 0158 realloc 0184 malloc 01a0 __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF B8 AF BC 00 10 AF BE 00 40 AF B7 00 3C AF B6 00 38 AF B3 00 2C AF BF 00 44 AF B5 00 34 AF B4 00 30 AF B2 00 28 AF B1 00 24 AF B0 00 20 00 A0 F0 21 00 C0 B0 21 ?? ?? ?? ?? 00 E0 B8 21 00 40 98 21 10 40 00 3C 8F BC 00 10 8F 99 ?? ?? 00 00 80 21 ?? ?? ?? ?? 00 00 A8 21 8C 59 00 00 8F BC 00 10 00 40 90 21 AF B9 00 18 AC 40 00 00 00 00 88 21 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 00 40 A0 21 10 40 00 09 8F BC 00 10 12 C0 00 2C 02 C0 C8 21 03 20 F8 09 02 80 20 21 14 40 00 28 8F BC 00 10 10 00 FF F3 AE 40 00 00 8E 54 00 00 8F 99 ?? ?? 12 80 00 11 02 60 20 21 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 12 00 00 08 8F 99 ?? ?? 26 10 FF FF 00 10 10 80 02 22 10 21 ?? ?? ?? ?? 8C 44 00 00 10 00 FF F8 8F BC 00 10 ?? ?? ?? ?? 02 20 20 21 10 00 00 10 AE 54 00 00 ?? ?? ?? ?? 00 00 00 00 8F B9 00 18 8F BC 00 10 12 E0 00 07 AE 59 00 00 8F 99 ?? ?? 02 20 20 21 02 00 28 21 24 06 00 04 ?? ?? ?? ?? 02 E0 38 21 AF D1 00 00 10 00 00 24 02 00 10 21 10 00 00 22 24 02 FF FF 16 15 00 0B AE 40 00 00 8F 99 ?? ?? 24 02 00 0A 00 10 A8 40 00 50 A8 0A 02 20 20 21 ?? ?? ?? ?? 00 15 28 80 10 40 FF D1 8F BC 00 10 00 40 88 21 96 86 00 10 8F 99 ?? ?? 00 C0 20 21 ?? ?? ?? ?? AF A6 00 1C 8F BC 00 10 10 40 FF C8 8F A6 00 1C 8F 99 ?? ?? 26 03 00 01 AF A3 00 1C 00 40 20 21 02 80 28 21 ?? ?? ?? ?? 00 10 80 80 02 30 80 21 8F BC 00 10 AE 02 00 00 8F A3 00 1C 10 00 FF AD 00 60 80 21 8F BF 00 44 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_633_0_0 {
	meta:
		name = "setpgrp"
		size = 28
		refs = "0000 _gp_disp 000c __GI_setpgid"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 00 00 20 21 ?? ?? ?? ?? 00 00 28 21 }
	condition:
		$1
}

rule file_634_0_0 {
	meta:
		name = "__GI_munmap"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F FB 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_635_0_0 {
	meta:
		name = "__GI_getgid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F CF 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_636_0_0 {
	meta:
		name = "rename"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F C6 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_637_0_0 {
	meta:
		name = "mincore"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 79 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_638_0_0 {
	meta:
		name = "semctl"
		size = 96
		refs = "0000 _gp_disp 0014 __syscall_ipc"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 00 80 18 21 8F 99 ?? ?? 27 A4 00 3C 00 A0 10 21 AF A4 00 20 27 A4 00 24 AF BF 00 2C AF BC 00 18 AF A7 00 3C AF A7 00 24 AF A4 00 10 34 C7 01 00 AF A0 00 14 24 04 00 03 00 60 28 21 ?? ?? ?? ?? 00 40 30 21 8F BF 00 2C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_640_0_0 {
	meta:
		name = "__GI_wcsnlen"
		size = 44
	strings:
		$1 = { 00 80 10 21 50 A0 00 07 00 44 10 23 8C 43 00 00 10 60 00 03 24 A5 FF FF 10 00 FF FA 24 42 00 04 00 44 10 23 03 E0 00 08 00 02 10 83 }
	condition:
		$1
}

rule file_642_0_0 {
	meta:
		name = "_wstdio_fwrite"
		size = 408
		refs = "0000 _gp_disp 0074 __GI_wmemcpy 00a8 __stdio_trans2w_o 00c4 __GI_wcsnrtombs 00cc __stdio_fwrite"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 68 AF B3 00 7C AF B2 00 78 AF B0 00 70 AF BC 00 18 AF BF 00 94 AF BE 00 90 AF B7 00 8C AF B6 00 88 AF B5 00 84 AF B4 00 80 AF B1 00 74 8C C3 00 04 24 02 FF FD 00 80 98 21 00 A0 90 21 14 62 00 12 00 C0 80 21 8C C4 00 10 8C D4 00 0C 02 84 A0 23 00 14 A0 83 00 B4 10 2B 00 A2 A0 0B 12 80 00 3D 00 A0 88 21 8F 99 ?? ?? 02 80 30 21 ?? ?? ?? ?? 02 60 28 21 8E 02 00 10 00 14 A0 80 00 54 A0 21 10 00 00 34 AE 14 00 10 94 C3 00 00 24 02 08 40 30 63 08 40 14 62 00 0A 8F 99 ?? ?? 27 B9 00 60 AF B3 00 60 00 00 88 21 AF B9 00 68 26 16 00 2C 27 B4 00 20 8F 97 ?? ?? 10 00 00 23 8F 9E ?? ?? 00 C0 20 21 ?? ?? ?? ?? 24 05 08 00 00 00 88 21 14 40 00 20 8F BC 00 18 10 00 FF F1 27 B9 00 60 02 80 20 21 27 A5 00 60 02 51 30 23 02 E0 C8 21 ?? ?? ?? ?? 24 07 00 40 00 40 A8 21 24 02 FF FF 12 A2 00 15 8F BF 00 94 16 A0 00 06 02 80 20 21 26 22 00 01 00 02 10 80 02 62 10 21 AF A2 00 60 24 15 00 01 02 A0 28 21 03 C0 C8 21 ?? ?? ?? ?? 02 00 30 21 14 55 00 08 8F BF 00 94 8F B1 00 60 02 33 88 23 00 11 88 83 02 32 10 2B 54 40 FF E4 AF B6 00 10 8F BF 00 94 02 20 10 21 8F BE 00 90 8F B7 00 8C 8F B6 00 88 8F B5 00 84 8F B4 00 80 8F B3 00 7C 8F B2 00 78 8F B1 00 74 8F B0 00 70 03 E0 00 08 27 BD 00 98 }
	condition:
		$1
}

rule file_643_0_0 {
	meta:
		name = "__GI_memchr"
		size = 236
	strings:
		$1 = { 30 A2 00 FF 10 C0 00 08 30 83 00 03 50 60 00 07 30 A5 00 FF 90 83 00 00 10 62 00 32 24 C6 FF FF 10 00 FF F8 24 84 00 01 30 A5 00 FF 00 05 1A 00 00 65 28 25 00 05 1C 00 3C 07 7E FE 3C 08 81 01 00 65 28 25 34 E7 FE FF 25 08 01 00 2C C3 00 04 14 60 00 20 00 00 00 00 8C 83 00 00 00 A3 18 26 00 03 50 27 00 67 18 21 01 43 18 26 00 68 18 24 10 60 00 11 24 89 00 04 90 83 00 00 10 62 00 19 00 00 00 00 90 83 00 01 54 62 00 03 90 83 00 02 03 E0 00 08 24 82 00 01 54 62 00 03 90 83 00 03 03 E0 00 08 24 82 00 02 14 62 00 04 24 C6 FF FC 03 E0 00 08 24 82 00 03 24 C6 FF FC 10 00 FF E3 01 20 20 21 90 85 00 00 10 A2 00 06 00 60 30 21 24 84 00 01 14 C0 FF FB 24 C3 FF FF 03 E0 00 08 00 00 10 21 03 E0 00 08 00 80 10 21 }
	condition:
		$1
}

rule file_644_0_0 {
	meta:
		name = "__GI_strpbrk"
		size = 60
		altNames = "any"
	strings:
		$1 = { 80 83 00 00 10 60 00 0B 00 00 00 00 00 A0 10 21 80 46 00 00 50 C0 FF FA 24 84 00 01 10 C3 00 03 00 00 00 00 10 00 FF FA 24 42 00 01 03 E0 00 08 00 80 10 21 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_645_0_0 {
	meta:
		name = "wcsncpy"
		size = 48
	strings:
		$1 = { 00 80 10 21 00 80 18 21 10 C0 00 07 24 A7 00 04 8C A4 00 00 24 63 00 04 AC 64 FF FC 00 E4 28 0B 10 00 FF F9 24 C6 FF FF 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_647_0_0 {
	meta:
		name = "__GI__exit"
		size = 84
		refs = "0000 _gp_disp 0014 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B0 00 18 8F 90 ?? ?? AF B1 00 1C AF BC 00 10 AF BF 00 24 AF B2 00 20 00 80 88 21 02 20 20 21 24 02 0F A1 00 00 00 0C 10 E0 FF FC 00 40 90 21 02 00 C8 21 ?? ?? ?? ?? 00 00 00 00 10 00 FF F7 AC 52 00 00 }
	condition:
		$1
}

rule file_648_0_0 {
	meta:
		name = "__GI_strcasestr"
		size = 136
		refs = "0000 _gp_disp 000c __GI___ctype_tolower"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 89 ?? ?? 00 A0 18 21 00 80 10 21 80 67 00 00 10 E0 00 16 00 00 00 00 80 46 00 00 10 E6 00 0B 30 E7 00 FF 8D 28 00 00 30 CA 00 FF 00 0A 50 40 00 07 38 40 01 07 38 21 01 0A 40 21 84 EA 00 00 85 07 00 00 15 47 00 04 00 00 00 00 24 63 00 01 10 00 FF EE 24 42 00 01 10 C0 00 06 24 84 00 01 00 A0 18 21 10 00 FF E9 00 80 10 21 03 E0 00 08 00 80 10 21 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_649_0_0 {
	meta:
		name = "__get_myaddress"
		size = 468
		refs = "0000 _gp_disp 000c __GI_socket 0060 $LC0 006c __GI_ioctl 00a4 $LC1 00ac __GI_perror 00bc __GI_exit 00e0 __GI_memcpy 0110 $LC2 016c __GI_close"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD EF 98 24 05 00 01 00 00 30 21 AF BC 00 10 AF B4 10 50 AF B0 10 40 AF BF 10 64 AF BE 10 60 AF B7 10 5C AF B6 10 58 AF B5 10 54 AF B3 10 4C AF B2 10 48 AF B1 10 44 00 80 A0 21 ?? ?? ?? ?? 24 04 00 02 00 40 80 21 04 41 00 04 8F BC 00 10 8F 84 ?? ?? 10 00 00 11 24 84 ?? ?? 8F 91 ?? ?? 24 02 10 00 AF A2 10 38 27 A2 00 18 AF A2 10 3C 02 00 20 21 34 05 89 12 02 20 C8 21 ?? ?? ?? ?? 27 A6 10 38 02 20 B0 21 8F BC 00 10 04 41 00 0A 24 12 00 01 8F 84 ?? ?? 24 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 24 04 00 01 27 B5 10 18 24 1E 00 02 24 17 00 01 8F B1 10 3C 8F B3 10 38 12 60 00 2A 8F 99 ?? ?? 02 A0 20 21 02 20 28 21 ?? ?? ?? ?? 24 06 00 20 02 00 20 21 34 05 89 13 02 C0 C8 21 ?? ?? ?? ?? 02 A0 30 21 04 41 00 04 8F BC 00 10 8F 84 ?? ?? 10 00 FF E5 24 84 ?? ?? 97 A2 10 28 30 43 00 01 50 60 00 16 26 31 00 20 96 23 00 10 54 7E 00 13 26 31 00 20 30 42 00 08 14 40 00 04 8F 99 ?? ?? 56 40 00 0E 26 31 00 20 8F 99 ?? ?? 02 80 20 21 26 25 00 10 ?? ?? ?? ?? 24 06 00 10 8F BC 00 10 24 02 00 6F A6 82 00 02 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 10 00 00 0A 24 02 00 01 10 00 FF D6 26 73 FF E0 16 57 00 03 8F 99 ?? ?? 10 00 FF D0 00 00 90 21 ?? ?? ?? ?? 02 00 20 21 00 00 10 21 8F BF 10 64 8F BE 10 60 8F B7 10 5C 8F B6 10 58 8F B5 10 54 8F B4 10 50 8F B3 10 4C 8F B2 10 48 8F B1 10 44 8F B0 10 40 03 E0 00 08 27 BD 10 68 }
	condition:
		$1
}

rule file_649_1_0 {
	meta:
		name = "__GI_pmap_set"
		size = 348
		refs = "0000 _gp_disp 0050 __get_myaddress 0088 __GI_clntudp_bufcreate 00c4 __GI_xdr_bool 00cc __GI_xdr_pmap 0114 __GI_clnt_perror 0110 $LC3"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF 98 24 02 FF FF AF B0 00 50 27 B0 00 38 AF BC 00 20 AF B4 00 60 AF B3 00 5C AF B2 00 58 AF B1 00 54 AF BF 00 64 00 80 A0 21 AF A2 00 4C 02 00 20 21 27 39 ?? ?? 00 A0 98 21 00 C0 90 21 ?? ?? ?? ?? 30 F1 FF FF 14 40 00 03 8F BC 00 20 10 00 00 36 00 00 10 21 8F 82 ?? ?? 27 A3 00 4C AF A3 00 14 24 03 01 90 AF A3 00 18 AF A3 00 1C 24 43 ?? ?? 8C 63 00 04 8F 99 ?? ?? 8C 47 ?? ?? 3C 05 00 01 02 00 20 21 AF A3 00 10 34 A5 86 A0 ?? ?? ?? ?? 24 06 00 02 00 40 80 21 10 40 FF EC 8F BC 00 20 AF B3 00 2C AF B2 00 30 AF B1 00 34 8C 43 00 04 8F 82 ?? ?? AF B4 00 28 8F 86 ?? ?? AF A2 00 10 27 A2 00 48 AF A2 00 14 8F 82 ?? ?? 24 05 00 01 27 A7 00 28 8C 44 ?? ?? 24 42 ?? ?? 8C 42 00 04 AF A4 00 18 AF A2 00 1C 8C 79 00 00 03 20 F8 09 02 00 20 21 10 40 00 07 8F BC 00 20 8F 85 ?? ?? 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 24 A5 ?? ?? AF A0 00 48 8E 02 00 04 8C 59 00 10 03 20 F8 09 02 00 20 21 8F A2 00 48 8F BF 00 64 8F B4 00 60 8F B3 00 5C 8F B2 00 58 8F B1 00 54 8F B0 00 50 03 E0 00 08 27 BD 00 68 }
	condition:
		$1
}

rule file_649_2_0 {
	meta:
		name = "__GI_pmap_unset"
		size = 292
		refs = "0000 _gp_disp 0040 __get_myaddress 0078 __GI_clntudp_bufcreate 00b4 __GI_xdr_bool 00bc __GI_xdr_pmap"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF A0 24 02 FF FF AF B0 00 50 27 B0 00 38 AF BC 00 20 AF B2 00 58 AF B1 00 54 AF BF 00 5C 00 80 90 21 AF A2 00 4C 02 00 20 21 27 39 ?? ?? ?? ?? ?? ?? 00 A0 88 21 14 40 00 03 8F BC 00 20 10 00 00 2E 00 00 10 21 8F 82 ?? ?? 27 A3 00 4C AF A3 00 14 24 03 01 90 AF A3 00 18 AF A3 00 1C 24 43 ?? ?? 8C 63 00 04 8F 99 ?? ?? 8C 47 ?? ?? 3C 05 00 01 02 00 20 21 AF A3 00 10 34 A5 86 A0 ?? ?? ?? ?? 24 06 00 02 00 40 80 21 10 40 FF EC 8F BC 00 20 AF B1 00 2C AF A0 00 30 AF A0 00 34 8C 43 00 04 8F 82 ?? ?? AF B2 00 28 8F 86 ?? ?? AF A2 00 10 27 A2 00 48 AF A2 00 14 8F 82 ?? ?? 24 05 00 02 27 A7 00 28 8C 44 ?? ?? 24 42 ?? ?? 8C 42 00 04 AF A4 00 18 AF A2 00 1C 8C 79 00 00 03 20 F8 09 02 00 20 21 8E 02 00 04 8C 59 00 10 03 20 F8 09 02 00 20 21 8F A2 00 48 8F BF 00 5C 8F B2 00 58 8F B1 00 54 8F B0 00 50 03 E0 00 08 27 BD 00 60 }
	condition:
		$1
}

rule file_650_0_0 {
	meta:
		name = "__GI_wcsnrtombs"
		size = 180
		refs = "0000 _gp_disp 0060 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 AF BC 00 10 AF BF 00 2C 50 80 00 05 00 00 40 21 14 85 00 05 24 08 00 01 10 00 00 02 00 00 40 21 24 07 FF FF 27 A4 00 18 00 C7 10 2B 8C A3 00 00 00 C2 38 0B 00 E0 10 21 10 40 00 14 27 A6 00 18 8C 66 00 00 2C C9 00 80 15 20 00 08 7C 06 34 20 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 58 AC 43 00 00 10 00 00 0C 24 02 FF FF 10 C0 00 05 A0 86 00 00 24 63 00 04 00 88 20 21 10 00 FF EE 24 42 FF FF 00 00 18 21 27 A6 00 18 54 86 00 01 AC A3 00 00 00 E2 10 23 8F BF 00 2C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_651_0_0 {
	meta:
		name = "__GI_mempcpy"
		size = 60
		refs = "0000 _gp_disp 000c __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF B0 00 18 AF BC 00 10 ?? ?? ?? ?? 00 C0 80 21 8F BF 00 1C 00 50 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_653_0_0 {
	meta:
		name = "__GI_fdopen"
		size = 128
		refs = "0000 _gp_disp 000c __GI_fcntl 0054 _stdio_fopen"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BC 00 10 AF B1 00 20 AF B0 00 1C AF BF 00 24 00 A0 88 21 24 05 00 03 ?? ?? ?? ?? 00 80 80 21 24 03 FF FF 10 43 00 0B 8F BC 00 10 8F BF 00 24 02 20 28 21 02 00 38 21 8F B1 00 20 8F B0 00 1C 8F 99 ?? ?? 00 40 20 21 00 00 30 21 ?? ?? ?? ?? 27 BD 00 28 8F BF 00 24 8F B1 00 20 8F B0 00 1C 00 00 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_654_0_0 {
	meta:
		name = "__GI_fgetc"
		size = 244
		refs = "0000 _gp_disp 0050 __GI___fgetc_unlocked 0064 _pthread_cleanup_push_defer 0068 __pthread_mutex_unlock 0084 __pthread_mutex_lock 00c8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B0 00 28 AF BC 00 10 AF BF 00 34 AF B2 00 30 AF B1 00 2C 8C 82 00 34 10 40 00 0E 00 80 80 21 8C 82 00 10 8C 83 00 18 00 43 18 2B 10 60 00 04 24 43 00 01 AC 83 00 10 10 00 00 24 90 42 00 00 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 20 8F BF 00 34 8F 99 ?? ?? 8F 85 ?? ?? 24 92 00 38 27 B1 00 18 02 20 20 21 ?? ?? ?? ?? 02 40 30 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 8E 02 00 10 8E 03 00 18 00 43 18 2B 10 60 00 05 8F BC 00 10 24 43 00 01 AE 03 00 10 10 00 00 06 90 50 00 00 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 00 40 80 21 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 24 05 00 01 02 00 10 21 8F BF 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_655_0_0 {
	meta:
		name = "__stdio_seek"
		size = 100
		refs = "0000 _gp_disp 0028 __GI_lseek64"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 8C A3 00 04 8C A2 00 00 AF B0 00 20 AF BC 00 18 AF BF 00 24 8C 84 00 04 8F 99 ?? ?? AF A6 00 10 00 60 38 21 00 40 30 21 ?? ?? ?? ?? 00 A0 80 21 04 42 00 04 00 60 10 21 AE 02 00 00 AE 03 00 04 00 00 10 21 8F BF 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_656_0_0 {
	meta:
		name = "fgetpos64"
		size = 220
		refs = "0000 _gp_disp 0038 _pthread_cleanup_push_defer 003c __pthread_mutex_unlock 0054 __pthread_mutex_lock 0064 __GI_ftello64 00ac _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF B1 00 30 AF B0 00 2C AF BC 00 10 AF BF 00 3C AF B3 00 38 AF B2 00 34 8C 92 00 34 00 80 80 21 16 40 00 0C 00 A0 88 21 8F 99 ?? ?? 8F 85 ?? ?? 24 93 00 38 02 60 30 21 ?? ?? ?? ?? 27 A4 00 18 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 AE 22 00 00 8F BC 00 10 04 40 00 09 AE 23 00 04 8E 02 00 2C AE 22 00 08 8E 02 00 30 AE 22 00 0C 92 02 00 02 00 00 80 21 10 00 00 02 AE 22 00 10 24 10 FF FF 16 40 00 06 8F BF 00 3C 8F 99 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F BF 00 3C 02 00 10 21 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_658_0_0 {
	meta:
		name = "__wcslcpy"
		size = 76
	strings:
		$1 = { 27 BD FF F0 50 C0 00 03 00 00 30 21 10 00 00 02 24 C6 FF FF 27 A4 00 08 00 A0 10 21 8C 43 00 00 10 60 00 06 AC 83 00 00 10 C0 FF FC 24 42 00 04 24 C6 FF FF 10 00 FF F9 24 84 00 04 00 45 10 23 00 02 10 83 03 E0 00 08 27 BD 00 10 }
	condition:
		$1
}

rule file_659_0_0 {
	meta:
		name = "__GI___assert"
		size = 140
		refs = "0000 _gp_disp 0024 __GI_abort 0030 stderr 003c __uclibc_progname 004c $LC0 0060 __GI_fprintf 005c $LC1"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 83 ?? ?? 27 BD FF D0 AF BC 00 20 8C 62 ?? ?? AF BF 00 2C 14 40 00 18 8F 99 ?? ?? 24 02 00 01 AC 62 ?? ?? 8F 82 ?? ?? 00 A0 40 21 8C 45 00 00 8F 82 ?? ?? 8C 43 00 00 14 E0 00 03 00 E0 10 21 8F 82 ?? ?? 24 42 ?? ?? AF A4 00 18 00 A0 20 21 8F 85 ?? ?? 8F 99 ?? ?? AF A6 00 10 AF A2 00 14 24 A5 ?? ?? 00 60 30 21 ?? ?? ?? ?? 01 00 38 21 8F BC 00 20 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_660_0_0 {
	meta:
		name = "__libc_current_sigrtmin"
		size = 24
		refs = "0000 _gp_disp"
		altNames = "_ZNSt5ctypeIcE13classic_tableEv __libc_current_sigrtmax __pthread_getconcurrency"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 03 E0 00 08 8C 42 ?? ?? }
	condition:
		$1
}

rule file_660_2_0 {
	meta:
		name = "__libc_allocate_rtsig"
		size = 88
		refs = "0000 _gp_disp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 86 ?? ?? 24 03 FF FF 8C C2 ?? ?? 10 43 00 0D 8F 85 ?? ?? 8C A3 ?? ?? 00 62 38 2A 14 E0 00 09 00 00 00 00 50 80 00 04 24 62 FF FF 24 43 00 01 03 E0 00 08 AC C3 ?? ?? AC A2 ?? ?? 03 E0 00 08 00 60 10 21 03 E0 00 08 24 02 FF FF }
	condition:
		$1
}

rule file_661_0_0 {
	meta:
		name = "tmpnam"
		size = 164
		refs = "0000 _gp_disp 0010 ___path_search 0054 __gen_tempname 0078 __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 8F 99 ?? ?? AF B0 00 34 27 B0 00 18 00 84 80 0B AF BC 00 10 AF B1 00 38 AF BF 00 3C 00 80 88 21 24 05 00 14 02 00 20 21 00 00 30 21 ?? ?? ?? ?? 00 00 38 21 10 40 00 03 8F BC 00 10 10 00 00 10 00 00 10 21 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 24 05 00 03 14 40 FF F9 8F BC 00 10 16 20 00 08 02 20 10 21 8F 83 ?? ?? 8F 99 ?? ?? 02 00 28 21 24 63 ?? ?? 00 60 20 21 ?? ?? ?? ?? 24 06 00 14 8F BF 00 3C 8F B1 00 38 8F B0 00 34 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_662_0_0 {
	meta:
		name = "tdelete"
		size = 292
		refs = "0000 _gp_disp 009c free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D0 AF BC 00 10 AF B0 00 1C AF BF 00 2C AF B3 00 28 AF B2 00 24 AF B1 00 20 14 A0 00 03 00 A0 80 21 10 00 00 35 00 00 10 21 8C B2 00 00 00 80 98 21 12 40 FF FB 00 C0 88 21 8E 02 00 00 02 60 20 21 02 20 C8 21 03 20 F8 09 8C 45 00 00 10 40 00 0B 8F BC 00 10 8E 12 00 00 28 42 00 00 26 50 00 04 26 43 00 08 00 62 80 0A 8E 02 00 00 54 40 FF F4 02 60 20 21 10 00 00 20 00 00 10 21 8E 02 00 00 8C 51 00 08 8C 42 00 04 10 40 00 17 8F 99 ?? ?? 52 20 00 14 00 40 88 21 8E 23 00 04 54 60 00 04 8C 62 00 04 10 00 00 10 AE 22 00 04 8C 62 00 04 50 40 00 04 8C 62 00 08 00 60 88 21 10 00 FF FB 00 40 18 21 AE 22 00 04 8E 02 00 00 00 60 88 21 8C 42 00 04 AC 62 00 04 8E 02 00 00 8C 42 00 08 AC 62 00 08 8F 99 ?? ?? ?? ?? ?? ?? 8E 04 00 00 AE 11 00 00 02 40 10 21 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_663_0_0 {
	meta:
		name = "__GI_fflush"
		size = 200
		refs = "0000 _gp_disp 0030 __GI_fflush_unlocked 0034 _stdio_openlist 0048 __pthread_mutex_unlock 004c _pthread_cleanup_push_defer 0064 __pthread_mutex_lock 0084 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF BC 00 10 AF B2 00 3C AF B0 00 34 AF BF 00 44 AF B3 00 40 AF B1 00 38 00 80 80 21 10 80 00 1C 8F 92 ?? ?? 8F 82 ?? ?? 10 82 00 1A 02 40 C8 21 8C 91 00 34 16 20 00 0B 8F 85 ?? ?? 8F 99 ?? ?? 24 93 00 38 02 60 30 21 ?? ?? ?? ?? 27 A4 00 18 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 02 40 C8 21 ?? ?? ?? ?? 02 00 20 21 16 20 00 0B 8F BC 00 10 8F 99 ?? ?? AF A2 00 28 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 10 00 00 04 8F A2 00 28 02 40 C8 21 ?? ?? ?? ?? 02 00 20 21 8F BF 00 44 8F B3 00 40 8F B2 00 3C 8F B1 00 38 8F B0 00 34 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_664_0_0 {
	meta:
		name = "__GI_accept"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 48 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_665_0_0 {
	meta:
		name = "mount"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 8F A2 00 30 27 BD FF E0 AF A2 00 10 24 02 0F B5 00 00 00 0C 27 BD 00 20 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_666_0_0 {
	meta:
		name = "getsubopt"
		size = 348
		refs = "0000 _gp_disp 004c __GI_strchrnul 0070 __GI_memchr 008c __GI_strncmp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B3 00 2C AF BC 00 10 AF BF 00 44 AF BE 00 40 AF B7 00 3C AF B6 00 38 AF B5 00 34 AF B4 00 30 AF B2 00 28 AF B1 00 24 AF B0 00 20 8C 91 00 00 82 22 00 00 10 40 00 38 00 80 98 21 8F 99 ?? ?? 02 20 20 21 00 A0 F0 21 24 05 00 2C ?? ?? ?? ?? 00 C0 B0 21 8F BC 00 10 02 20 20 21 24 05 00 3D 8F 99 ?? ?? 00 51 30 23 ?? ?? ?? ?? 00 40 80 21 8F BC 00 10 02 00 A8 21 00 42 A8 0B 8F 99 ?? ?? 00 00 90 21 02 B1 B8 23 00 12 10 80 03 C2 10 21 8C 54 00 00 12 80 00 19 02 20 20 21 AF B9 00 18 02 80 28 21 03 20 F8 09 02 E0 30 21 14 40 00 11 8F B9 00 18 02 97 A0 21 82 82 00 00 54 40 FF F2 26 52 00 01 26 A2 00 01 02 B0 A8 26 00 15 10 0A AE C2 00 00 82 02 00 00 50 40 00 04 AE 70 00 00 A2 00 00 00 26 10 00 01 AE 70 00 00 10 00 00 0B 02 40 10 21 10 00 FF E4 26 52 00 01 AE D1 00 00 82 02 00 00 50 40 00 04 AE 70 00 00 A2 00 00 00 26 10 00 01 AE 70 00 00 24 02 FF FF 8F BF 00 44 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_667_1_0 {
	meta:
		name = "__GI__authenticate"
		size = 108
		refs = "0000 _gp_disp 0020 _null_auth"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8C A6 00 18 AC 86 00 0C 8C A6 00 1C AC 86 00 10 8C A3 00 20 8F 86 ?? ?? AC 83 00 14 8C C6 00 00 8C 83 00 1C AC 66 00 20 8C 83 00 1C AC 60 00 28 8C 82 00 0C 2C 43 00 04 10 60 00 07 8F 83 ?? ?? 00 02 10 80 24 63 ?? ?? 00 43 10 21 8C 59 00 00 03 20 00 08 00 00 00 00 03 E0 00 08 24 02 00 02 }
	condition:
		$1
}

rule file_669_0_0 {
	meta:
		name = "munlockall"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 3D 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_670_0_0 {
	meta:
		name = "__GI_write"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F A4 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_671_0_0 {
	meta:
		name = "__GI_getuid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F B8 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_673_0_0 {
	meta:
		name = "__GI_xdr_rejected_reply"
		size = 188
		refs = "0000 _gp_disp 0014 __GI_xdr_enum 0060 __GI_xdr_u_long"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B2 00 20 8F 92 ?? ?? AF BC 00 10 AF B1 00 1C AF B0 00 18 AF BF 00 24 02 40 C8 21 00 80 88 21 ?? ?? ?? ?? 00 A0 80 21 10 40 00 19 8F BC 00 10 8E 02 00 00 10 40 00 06 24 03 00 01 14 43 00 15 8F BF 00 24 02 20 20 21 10 00 00 0B 26 05 00 04 8F 92 ?? ?? 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 26 05 00 04 10 40 00 0A 8F BC 00 10 02 20 20 21 26 05 00 08 8F BF 00 24 8F B1 00 1C 8F B0 00 18 02 40 C8 21 8F B2 00 20 03 20 00 08 27 BD 00 28 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 00 00 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_673_1_0 {
	meta:
		name = "__GI_xdr_opaque_auth"
		size = 116
		refs = "0000 _gp_disp 000c __GI_xdr_enum 004c __GI_xdr_bytes"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BC 00 10 AF B1 00 20 AF B0 00 1C AF BF 00 24 00 80 88 21 ?? ?? ?? ?? 00 A0 80 21 10 40 00 0B 8F BC 00 10 8F BF 00 24 02 20 20 21 26 05 00 04 8F B1 00 20 26 06 00 08 8F 99 ?? ?? 8F B0 00 1C 24 07 01 90 ?? ?? ?? ?? 27 BD 00 28 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_673_2_0 {
	meta:
		name = "__GI_xdr_accepted_reply"
		size = 248
		refs = "0000 _gp_disp 000c __GI_xdr_opaque_auth 0044 __GI_xdr_enum 006c __GI_xdr_u_long"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BC 00 10 AF B1 00 1C AF B0 00 18 AF BF 00 24 AF B2 00 20 00 80 88 21 ?? ?? ?? ?? 00 A0 80 21 14 40 00 03 8F BC 00 10 10 00 00 27 00 00 18 21 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 26 05 00 0C 10 40 FF F9 8F BC 00 10 8E 02 00 0C 10 40 00 05 24 03 00 02 10 43 00 0C 8F 92 ?? ?? 10 00 00 1A 24 03 00 01 8F BF 00 24 8F B2 00 20 8E 19 00 14 02 20 20 21 8E 05 00 10 8F B1 00 1C 8F B0 00 18 03 20 00 08 27 BD 00 28 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 26 05 00 10 8F BC 00 10 10 40 00 0A 00 00 18 21 8F BF 00 24 02 20 20 21 26 05 00 14 8F B1 00 1C 8F B0 00 18 02 40 C8 21 8F B2 00 20 ?? ?? ?? ?? 27 BD 00 28 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 00 60 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_673_4_0 {
	meta:
		name = "__GI_xdr_replymsg"
		size = 156
		refs = "0000 _gp_disp 000c __GI_xdr_u_long 0040 __GI_xdr_enum 006c __GI_xdr_union"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D0 AF BC 00 18 AF B1 00 28 AF B0 00 24 AF BF 00 2C 00 80 88 21 ?? ?? ?? ?? 00 A0 80 21 14 40 00 03 8F BC 00 18 10 00 00 13 00 00 10 21 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 26 05 00 04 10 40 FF F9 8F BC 00 18 8E 03 00 04 24 02 00 01 14 62 00 09 00 00 10 21 8F 87 ?? ?? 8F 99 ?? ?? AF A0 00 10 02 20 20 21 26 05 00 08 26 06 00 0C ?? ?? ?? ?? 24 E7 ?? ?? 8F BF 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_673_5_0 {
	meta:
		name = "__GI_xdr_callhdr"
		size = 224
		refs = "0000 _gp_disp 0040 __GI_xdr_u_long 0058 __GI_xdr_enum"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 24 02 00 02 AF BC 00 10 AF B1 00 1C AF B0 00 18 AF BF 00 24 AF B2 00 20 AC A0 00 04 AC A2 00 08 8C 82 00 00 00 80 88 21 14 40 00 22 00 A0 80 21 8F 92 ?? ?? 02 40 C8 21 ?? ?? ?? ?? 00 00 00 00 10 40 00 1C 8F BC 00 10 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 26 05 00 04 10 40 00 17 8F BF 00 24 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 26 05 00 08 10 40 00 11 8F BF 00 24 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 26 05 00 0C 10 40 00 0A 8F BC 00 10 8F BF 00 24 02 20 20 21 26 05 00 10 8F B1 00 1C 8F B0 00 18 02 40 C8 21 8F B2 00 20 ?? ?? ?? ?? 27 BD 00 28 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 00 00 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_673_6_0 {
	meta:
		name = "__GI__seterr_reply"
		size = 304
		refs = "0000 _gp_disp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8C 83 00 08 10 60 00 05 24 02 00 01 50 62 00 21 8C 82 00 0C 10 00 00 2B 24 02 00 10 8C 82 00 18 14 40 00 03 24 43 FF FF 03 E0 00 08 AC A0 00 00 2C 66 00 05 10 C0 00 13 00 03 18 80 8F 82 ?? ?? 24 42 ?? ?? 00 43 18 21 8C 62 00 00 00 5C 10 21 00 40 00 08 00 00 00 00 10 00 00 08 24 02 00 08 10 00 00 06 24 02 00 09 10 00 00 04 24 02 00 0A 10 00 00 02 24 02 00 0B 24 02 00 0C 10 00 00 14 AC A2 00 00 24 03 00 10 AC A3 00 00 10 00 00 0B AC A0 00 04 10 43 00 07 24 06 00 06 50 46 00 0C AC A2 00 00 24 06 00 10 AC A6 00 00 10 00 00 03 AC A3 00 04 10 00 FF F1 24 02 00 07 10 00 00 04 AC A2 00 08 AC A2 00 00 8C 82 00 08 AC A2 00 04 8C A2 00 00 24 03 00 07 10 43 00 09 24 03 00 09 10 43 00 0A 24 03 00 06 14 43 00 0C 00 00 00 00 8C 82 00 10 AC A2 00 04 10 00 00 07 8C 82 00 14 8C 82 00 10 03 E0 00 08 AC A2 00 04 8C 82 00 1C AC A2 00 04 8C 82 00 20 AC A2 00 08 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_674_0_0 {
	meta:
		name = "getitimer"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 09 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_675_0_0 {
	meta:
		name = "endhostent"
		size = 156
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 0040 __pthread_mutex_lock 0064 __GI_fclose 0078 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B1 00 30 8F 91 ?? ?? 8F 99 ?? ?? 8F 85 ?? ?? AF B0 00 2C 27 B0 00 18 AF BC 00 10 26 26 ?? ?? AF BF 00 34 ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 24 ?? ?? 8F BC 00 10 8F 91 ?? ?? 8F 82 ?? ?? 8E 24 ?? ?? 10 80 00 06 AC 40 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 AE 20 ?? ?? 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 24 05 00 01 8F BF 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_675_1_0 {
	meta:
		name = "sethostent"
		size = 140
		refs = "0000 _gp_disp 0018 __pthread_mutex_unlock 001c _pthread_cleanup_push_defer 004c __pthread_mutex_lock 0068 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B1 00 2C 8F 91 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? AF B0 00 28 27 B0 00 18 AF BF 00 34 26 26 ?? ?? AF B2 00 30 AF BC 00 10 00 80 90 21 ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 26 24 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 12 90 2B 8F BC 00 10 02 00 20 21 24 05 00 01 8F 82 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? AC 52 ?? ?? 8F BF 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_675_2_0 {
	meta:
		name = "__GI_gethostent_r"
		size = 332
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 0024 __pthread_mutex_unlock 0068 __pthread_mutex_lock 0088 __open_etc_hosts 00b0 __read_etc_hosts_r 00f4 _pthread_cleanup_pop_restore 00f8 __GI_fclose"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 98 AF B0 00 44 8F 90 ?? ?? 8F 99 ?? ?? AF B5 00 58 00 A0 A8 21 8F 85 ?? ?? AF B1 00 48 27 B1 00 30 AF BC 00 28 AF BF 00 64 AF B7 00 60 AF B6 00 5C AF B4 00 54 AF B3 00 50 AF B2 00 4C 00 80 B0 21 00 C0 A0 21 02 20 20 21 26 06 ?? ?? ?? ?? ?? ?? 00 E0 98 21 8F BC 00 28 8F 99 ?? ?? ?? ?? ?? ?? 26 04 ?? ?? 8F BC 00 28 8F 90 ?? ?? 8E 02 ?? ?? 14 40 00 0A 02 00 B8 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AE 02 ?? ?? 14 40 00 04 8F BC 00 28 AE 60 00 00 10 00 00 19 24 10 00 02 8F A2 00 78 8F 99 ?? ?? 8E E4 ?? ?? AF B6 00 10 AF B5 00 14 AF B4 00 18 AF B3 00 1C AF A2 00 20 00 00 28 21 24 06 00 02 8F 92 ?? ?? ?? ?? ?? ?? 24 07 00 01 8F BC 00 28 00 40 80 21 8F 82 ?? ?? 8C 42 ?? ?? 14 40 00 07 8F 99 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 8E 44 ?? ?? 8F BC 00 28 AE 40 ?? ?? 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 24 05 00 01 8F BF 00 64 02 00 10 21 8F B7 00 60 8F B6 00 5C 8F B5 00 58 8F B4 00 54 8F B3 00 50 8F B2 00 4C 8F B1 00 48 8F B0 00 44 03 E0 00 08 27 BD 00 68 }
	condition:
		$1
}

rule file_677_0_0 {
	meta:
		name = "__GI_tcgetpgrp"
		size = 68
		refs = "0000 _gp_disp 000c __GI_ioctl"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 3C 05 40 04 24 A5 74 77 AF BC 00 10 AF BF 00 24 ?? ?? ?? ?? 27 A6 00 18 04 41 00 02 8F A2 00 18 24 02 FF FF 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_678_0_0 {
	meta:
		name = "__GI_if_nametoindex"
		size = 228
		refs = "0000 _gp_disp 000c __opensock 0040 __GI_strncpy 0064 __GI_ioctl 0078 __GI_close 007c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF B0 AF BC 00 10 AF B2 00 44 AF B0 00 3C AF BF 00 4C AF B3 00 48 AF B1 00 40 ?? ?? ?? ?? 00 80 90 21 00 40 80 21 04 40 00 1D 8F BC 00 10 8F 99 ?? ?? 27 B1 00 18 02 20 20 21 02 40 28 21 ?? ?? ?? ?? 24 06 00 10 8F BC 00 10 02 20 30 21 02 00 20 21 8F 99 ?? ?? ?? ?? ?? ?? 34 05 89 33 8F BC 00 10 04 41 00 10 8F 91 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8C 53 00 00 02 00 20 21 02 20 C8 21 ?? ?? ?? ?? 00 40 90 21 24 02 00 16 56 62 00 09 00 00 10 21 24 02 00 59 AE 42 00 00 10 00 00 05 00 00 10 21 02 20 C8 21 ?? ?? ?? ?? 02 00 20 21 8F A2 00 28 8F BF 00 4C 8F B3 00 48 8F B2 00 44 8F B1 00 40 8F B0 00 3C 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_678_1_0 {
	meta:
		name = "__GI_if_freenameindex"
		size = 100
		refs = "0000 _gp_disp 0030 free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B1 00 20 AF B0 00 1C AF BC 00 10 AF BF 00 24 00 80 88 21 00 80 80 21 8E 04 00 04 10 80 00 05 8F 99 ?? ?? ?? ?? ?? ?? 26 10 00 08 10 00 FF FA 8F BC 00 10 8E 02 00 00 14 40 FF FA 8F BF 00 24 8F B0 00 1C 02 20 20 21 8F B1 00 20 ?? ?? ?? ?? 27 BD 00 28 }
	condition:
		$1
}

rule file_678_2_0 {
	meta:
		name = "__GI_if_nameindex"
		size = 608
		refs = "0000 _gp_disp 000c __opensock 0058 __GI_ioctl 00bc __GI_close 00dc malloc 0100 __GI_strdup 0114 __GI___errno_location 01b0 free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF B8 AF BE 00 40 AF B0 00 20 03 A0 F0 21 AF BC 00 10 AF BF 00 44 AF B7 00 3C AF B6 00 38 AF B5 00 34 AF B4 00 30 AF B3 00 2C AF B2 00 28 AF B1 00 24 ?? ?? ?? ?? 00 00 00 00 00 40 80 21 04 40 00 75 8F DC 00 10 8F 93 ?? ?? AF C0 00 1C 24 11 00 80 27 D2 00 18 00 11 10 40 24 43 00 0E 00 03 18 C2 00 03 18 C0 8F C5 00 1C 03 A3 E8 23 27 A3 00 10 00 62 20 21 00 A4 20 26 00 51 88 21 00 44 88 0B AF C3 00 1C AF D1 00 18 02 00 20 21 34 05 89 12 02 60 C8 21 ?? ?? ?? ?? 02 40 30 21 8F DC 00 10 04 41 00 06 8F 96 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 10 00 00 58 00 00 10 21 8F D4 00 18 12 91 FF E5 00 11 10 40 8F 99 ?? ?? 00 14 A1 42 26 84 00 01 ?? ?? ?? ?? 00 04 20 C0 8F DC 00 10 00 40 88 21 00 00 90 21 14 40 00 1F 8F 97 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F DC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 84 10 00 00 40 AC 43 00 00 8F C2 00 1C 00 12 99 40 02 E0 C8 21 00 53 98 21 ?? ?? ?? ?? 02 60 20 21 02 35 A8 21 8F DC 00 10 10 40 00 10 AE A2 00 04 02 00 20 21 34 05 89 33 02 C0 C8 21 ?? ?? ?? ?? 02 60 30 21 04 40 00 09 8F DC 00 10 8E 62 00 10 26 52 00 01 AE A2 00 00 02 54 10 2B 14 40 FF EA 00 12 A8 C0 10 00 00 20 8F 99 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 A0 21 8C 53 00 00 8F DC 00 10 00 40 A8 21 02 92 10 2B 10 40 00 08 8F 99 ?? ?? 00 14 10 C0 02 22 10 21 8C 44 00 04 ?? ?? ?? ?? 26 94 00 01 10 00 FF F7 8F DC 00 10 ?? ?? ?? ?? 02 20 20 21 8F DC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 24 02 00 16 12 62 00 04 3A 63 00 0C 24 02 00 84 10 00 00 02 00 43 98 0A 24 13 00 59 10 00 00 08 AE B3 00 00 02 35 A8 21 AE A0 00 00 AE A0 00 04 ?? ?? ?? ?? 02 00 20 21 10 00 00 02 02 20 10 21 00 00 10 21 03 C0 E8 21 8F BF 00 44 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_678_3_0 {
	meta:
		name = "if_indextoname"
		size = 236
		refs = "0000 _gp_disp 000c __opensock 0044 __GI_ioctl 0068 __GI_close 006c __GI___errno_location 00b8 __GI_strncpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF B0 AF BC 00 10 AF B3 00 48 AF B1 00 40 AF B0 00 3C AF BF 00 4C AF B2 00 44 00 80 88 21 ?? ?? ?? ?? 00 A0 98 21 00 40 80 21 04 40 00 23 8F BC 00 10 8F 99 ?? ?? AF B1 00 28 27 B1 00 18 00 40 20 21 34 05 89 10 ?? ?? ?? ?? 02 20 30 21 8F BC 00 10 04 41 00 0E 8F 92 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8C 51 00 00 02 00 20 21 02 40 C8 21 ?? ?? ?? ?? 00 40 98 21 3A 23 00 13 24 02 00 06 00 43 88 0A 10 00 00 0C AE 71 00 00 02 40 C8 21 ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 02 60 20 21 02 20 28 21 8F 99 ?? ?? ?? ?? ?? ?? 24 06 00 10 10 00 00 03 8F BF 00 4C 00 00 10 21 8F BF 00 4C 8F B3 00 48 8F B2 00 44 8F B1 00 40 8F B0 00 3C 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_679_0_0 {
	meta:
		name = "nrand48"
		size = 56
		refs = "0000 _gp_disp 000c __libc_drand48_data 0010 __GI_nrand48_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 85 ?? ?? 8F 99 ?? ?? 27 BD FF D8 AF BF 00 24 AF BC 00 10 ?? ?? ?? ?? 27 A6 00 18 8F BF 00 24 8F A2 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_771_0_0 {
	meta:
		name = "jrand48"
		size = 56
		refs = "0000 _gp_disp 000c __libc_drand48_data 0010 __GI_jrand48_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 85 ?? ?? 8F 99 ?? ?? 27 BD FF D8 AF BF 00 24 AF BC 00 10 ?? ?? ?? ?? 27 A6 00 18 8F BF 00 24 8F A2 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_680_0_0 {
	meta:
		name = "__GI_vsnprintf"
		size = 240
		refs = "0000 _gp_disp 0014 __stdio_init_mutex 0078 _vfprintf_internal"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 80 24 02 FF FE 8F 99 ?? ?? AF A2 00 1C 24 02 00 D0 A7 A2 00 18 24 02 00 01 AF BC 00 10 AF BF 00 7C AF B4 00 78 AF B3 00 74 AF B2 00 70 AF B1 00 6C AF B0 00 68 AF A2 00 4C 00 80 80 21 A3 A0 00 1A 27 A4 00 50 AF A0 00 44 00 A0 90 21 00 C0 A0 21 ?? ?? ?? ?? 00 E0 98 21 8F BC 00 10 00 10 10 27 02 42 88 2B 00 51 90 0A 8F 99 ?? ?? 02 12 10 21 AF A0 00 38 AF B0 00 20 AF A2 00 24 AF B0 00 28 AF B0 00 2C AF B0 00 30 AF A2 00 34 27 A4 00 18 02 80 28 21 ?? ?? ?? ?? 02 60 30 21 12 40 00 08 8F A3 00 28 8F A4 00 24 54 64 00 05 A0 60 00 00 24 63 FF FF AF A3 00 28 8F A3 00 28 A0 60 00 00 8F BF 00 7C 8F B4 00 78 8F B3 00 74 8F B2 00 70 8F B1 00 6C 8F B0 00 68 03 E0 00 08 27 BD 00 80 }
	condition:
		$1
}

rule file_681_0_0 {
	meta:
		name = "__GI_strtok_r"
		size = 184
		refs = "0000 _gp_disp 0038 __GI_strspn 0060 __GI_strpbrk 0078 __GI_rawmemchr"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF BC 00 10 AF B2 00 20 AF B1 00 1C AF B0 00 18 AF BF 00 24 00 80 80 21 00 A0 90 21 14 80 00 02 00 C0 88 21 8C D0 00 00 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 02 40 28 21 02 02 80 21 82 02 00 00 14 40 00 03 8F BC 00 10 10 00 00 11 AE 30 00 00 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 02 40 28 21 14 40 00 07 8F BC 00 10 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 00 00 28 21 10 00 00 04 AE 22 00 00 A0 40 00 00 24 42 00 01 AE 22 00 00 02 00 10 21 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_684_0_0 {
	meta:
		name = "__GI_sigfillset"
		size = 28
	strings:
		$1 = { 24 02 FF FF AC 82 00 0C AC 82 00 08 AC 82 00 04 AC 82 00 00 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_685_0_0 {
	meta:
		name = "inet_lnaof"
		size = 44
	strings:
		$1 = { 04 80 00 03 3C 03 C0 00 03 E0 00 08 7C 82 B8 00 00 83 18 24 3C 05 80 00 30 82 FF FF 00 65 18 26 30 84 00 FF 03 E0 00 08 00 83 10 0B }
	condition:
		$1
}

rule file_686_0_0 {
	meta:
		name = "firstwhite"
		size = 128
		refs = "0000 _gp_disp 0014 __GI_strchr"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B1 00 1C 8F 91 ?? ?? AF BC 00 10 AF BF 00 24 AF B2 00 20 AF B0 00 18 24 05 00 20 02 20 C8 21 ?? ?? ?? ?? 00 80 90 21 00 40 80 21 02 40 20 21 02 20 C8 21 ?? ?? ?? ?? 24 05 00 09 12 00 00 07 8F BF 00 24 10 40 00 03 02 02 18 2B 10 00 00 03 02 03 10 0B 02 00 10 21 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_686_1_0 {
	meta:
		name = "__get_next_rpcent"
		size = 468
		refs = "0000 _gp_disp 0020 __GI_strlen 0024 __GI_fgets 0088 __GI_strchr 00c4 firstwhite 0108 __GI_atoi"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B2 00 24 8F 92 ?? ?? AF B5 00 30 AF B4 00 2C 8F 95 ?? ?? 8F 94 ?? ?? AF B1 00 20 AF B0 00 1C AF BC 00 10 AF BF 00 34 AF B3 00 28 00 80 80 21 24 91 00 A8 26 52 ?? ?? 8E 06 00 00 02 20 20 21 02 80 C8 21 ?? ?? ?? ?? 24 05 10 00 10 40 00 53 02 A0 C8 21 ?? ?? ?? ?? 02 20 20 21 02 02 10 21 24 03 00 0A 8F BC 00 10 A0 43 00 A7 82 03 00 A8 24 02 00 23 10 62 FF F0 8F 93 ?? ?? 02 20 20 21 02 60 C8 21 ?? ?? ?? ?? 24 05 00 23 54 40 00 08 A0 40 00 00 02 20 20 21 02 60 C8 21 ?? ?? ?? ?? 24 05 00 0A 50 40 FF E5 8E 06 00 00 A0 40 00 00 02 40 C8 21 ?? ?? ?? ?? 02 20 20 21 02 40 98 21 10 40 FF DD 8F BC 00 10 A0 40 00 00 24 52 00 01 AE 11 00 9C 24 04 00 20 24 03 00 09 82 42 00 00 14 44 00 03 00 00 00 00 10 00 FF FC 26 52 00 01 50 43 FF FA 26 52 00 01 8F 99 ?? ?? 02 40 20 21 ?? ?? ?? ?? 26 11 00 10 AE 02 00 A4 AE 11 00 A0 02 60 C8 21 ?? ?? ?? ?? 02 40 20 21 10 40 00 03 24 44 00 01 10 00 00 02 A0 40 00 00 00 00 20 21 24 12 00 20 24 14 00 09 26 15 00 98 50 80 00 15 AE 20 00 00 80 82 00 00 50 40 00 12 AE 20 00 00 50 52 FF FA 24 84 00 01 14 54 00 03 02 35 10 2B 10 00 FF F6 24 84 00 01 10 40 00 03 02 60 C8 21 AE 24 00 00 26 31 00 04 ?? ?? ?? ?? 00 00 00 00 10 40 00 03 24 44 00 01 10 00 FF EC A0 40 00 00 AE 20 00 00 10 00 00 02 26 02 00 9C 00 00 10 21 8F BF 00 34 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_686_2_0 {
	meta:
		name = "_rpcdata"
		size = 80
		refs = "0000 _gp_disp 002c calloc"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF B0 00 18 8F 90 ?? ?? AF BC 00 10 AF BF 00 1C 8E 02 ?? ?? 14 40 00 07 8F BF 00 1C 8F 99 ?? ?? 24 04 00 01 ?? ?? ?? ?? 24 05 10 B0 AE 02 ?? ?? 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_686_3_0 {
	meta:
		name = "__copy_rpcent.part.1"
		size = 408
		refs = "0000 _gp_disp 000c __GI_memset 00ac __GI_strlen 00f8 __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF C8 AF BC 00 10 AF BF 00 34 AF B4 00 28 AF B2 00 20 AF B1 00 1C AF B0 00 18 00 80 88 21 00 A0 80 21 00 A0 20 21 00 C0 90 21 00 00 28 21 24 06 00 0C AF B6 00 30 AF B5 00 2C AF B3 00 24 ?? ?? ?? ?? 00 E0 A0 21 8F BC 00 10 02 40 20 21 00 00 28 21 8F 99 ?? ?? ?? ?? ?? ?? 02 80 30 21 8E 22 00 08 8F BC 00 10 AE 02 00 08 00 00 10 21 8E 24 00 04 00 02 18 80 00 83 18 21 8C 63 00 00 10 60 00 03 24 53 00 01 10 00 FF FA 02 60 10 21 00 13 98 80 02 93 18 2B 10 60 00 03 8F 96 ?? ?? 10 00 00 2F 24 02 00 22 AE 12 00 04 02 53 90 21 02 93 98 23 10 40 00 1B 24 55 FF FF 8E 22 00 04 00 15 A0 80 02 C0 C8 21 00 54 10 21 ?? ?? ?? ?? 8C 44 00 00 24 46 00 01 02 66 10 2B 14 40 FF F0 8F BC 00 10 8E 02 00 04 8F 99 ?? ?? 02 66 98 23 00 54 10 21 AC 52 00 00 8E 02 00 04 8E 23 00 04 02 46 90 21 00 54 10 21 00 74 A0 21 8C 44 00 00 ?? ?? ?? ?? 8E 85 00 00 8F BC 00 10 10 00 FF E5 02 A0 10 21 8F 99 ?? ?? ?? ?? ?? ?? 8E 24 00 00 00 53 98 2B 12 60 FF DA 8F BC 00 10 AE 12 00 00 8F 99 ?? ?? 8E 25 00 00 02 40 20 21 ?? ?? ?? ?? 00 40 30 21 8F A2 00 48 AC 50 00 00 00 00 10 21 8F BF 00 34 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_686_4_0 {
	meta:
		name = "__GI_endrpcent"
		size = 128
		refs = "0000 _gp_disp 0024 _rpcdata 0044 free 0060 __GI_fclose"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BC 00 10 AF B0 00 18 AF BF 00 1C 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 00 40 80 21 10 40 00 0F 8F BC 00 10 8C 42 00 0C 14 40 00 0D 8F BF 00 1C 8F 99 ?? ?? ?? ?? ?? ?? 8E 04 00 04 8E 04 00 00 8F BC 00 10 10 80 00 05 AE 00 00 04 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AE 00 00 00 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_686_5_0 {
	meta:
		name = "__GI_setrpcent"
		size = 168
		refs = "0000 _gp_disp 0028 _rpcdata 0044 __GI_rewind 0050 __GI_fopen 004c $LC0 0078 free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BC 00 10 AF B1 00 20 AF B0 00 1C AF BF 00 24 27 39 ?? ?? ?? ?? ?? ?? 00 80 88 21 00 40 80 21 10 40 00 17 8F BC 00 10 8C 44 00 00 14 80 00 0A 8F 99 ?? ?? 8F 84 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 24 84 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? 8F BC 00 10 10 00 00 04 AE 02 00 00 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 8E 04 00 04 8E 02 00 0C AE 00 00 04 00 51 88 25 AE 11 00 0C 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_686_6_0 {
	meta:
		name = "__GI_getrpcent"
		size = 148
		refs = "0000 _gp_disp 0024 _rpcdata 0058 __get_next_rpcent 0064 __GI_fopen 0060 $LC0"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BC 00 10 AF B0 00 18 AF BF 00 1C 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 00 40 80 21 10 40 00 13 8F BC 00 10 8C 42 00 00 10 40 00 08 8F 84 ?? ?? 8F 99 ?? ?? 8F BF 00 1C 02 00 20 21 8F B0 00 18 27 39 ?? ?? ?? ?? ?? ?? 27 BD 00 20 8F 85 ?? ?? 8F 99 ?? ?? 24 84 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? 8F BC 00 10 14 40 FF F2 AE 02 00 00 8F BF 00 1C 8F B0 00 18 00 00 10 21 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_686_7_0 {
	meta:
		name = "__GI_getrpcbynumber"
		size = 164
		refs = "0000 _gp_disp 002c _rpcdata 003c __GI_setrpcent 004c __GI_getrpcent 0074 __GI_endrpcent"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BC 00 10 AF B1 00 1C AF BF 00 24 AF B2 00 20 AF B0 00 18 27 39 ?? ?? ?? ?? ?? ?? 00 80 88 21 10 40 00 14 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 20 21 8F BC 00 10 8F 92 ?? ?? 02 40 C8 21 ?? ?? ?? ?? 00 00 00 00 00 40 80 21 10 40 00 04 8F BC 00 10 8E 02 00 08 14 51 FF F9 02 40 C8 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 02 02 00 10 21 00 00 10 21 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_686_8_0 {
	meta:
		name = "__GI_getrpcbyname"
		size = 228
		refs = "0000 _gp_disp 000c __GI_setrpcent 0044 __GI_getrpcent 0048 __GI_strcmp 00a8 __GI_endrpcent"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF C8 AF BC 00 10 AF B4 00 2C AF B3 00 28 AF B2 00 24 AF BF 00 34 AF B5 00 30 AF B1 00 20 AF B0 00 1C 00 80 90 21 ?? ?? ?? ?? 00 00 20 21 8F BC 00 10 8F 93 ?? ?? 8F 94 ?? ?? 02 60 C8 21 ?? ?? ?? ?? 00 00 00 00 00 40 80 21 10 40 00 12 8F BC 00 10 8E 04 00 00 02 80 C8 21 ?? ?? ?? ?? 02 40 28 21 8F BC 00 10 10 40 00 10 8F 95 ?? ?? 8E 11 00 04 8E 24 00 00 10 80 FF F0 02 A0 C8 21 ?? ?? ?? ?? 02 40 28 21 10 40 00 08 26 31 00 04 10 00 FF F9 8E 24 00 00 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 02 00 00 10 21 02 00 10 21 8F BF 00 34 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_686_9_0 {
	meta:
		name = "getrpcbynumber_r"
		size = 240
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 0024 __pthread_mutex_unlock 0068 __pthread_mutex_lock 0078 __GI_getrpcbynumber 00a8 __copy_rpcent.part.1 00b8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A8 AF B2 00 44 8F 92 ?? ?? 8F 99 ?? ?? AF B4 00 4C 00 A0 A0 21 8F 85 ?? ?? AF B0 00 3C 27 B0 00 20 AF A7 00 30 AF BF 00 54 AF BC 00 18 AF B5 00 50 AF B3 00 48 AF B1 00 40 00 80 A8 21 00 C0 98 21 02 00 20 21 26 46 ?? ?? ?? ?? ?? ?? 8F B1 00 68 8F BC 00 18 26 44 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 12 00 02 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 02 A0 20 21 8F BC 00 18 AE 20 00 00 10 40 00 0A 8F A7 00 30 8F 99 ?? ?? AF B1 00 10 00 40 20 21 02 80 28 21 27 39 ?? ?? ?? ?? ?? ?? 02 60 30 21 8F BC 00 18 00 40 90 21 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 24 05 00 01 8F BF 00 54 02 40 10 21 8F B5 00 50 8F B4 00 4C 8F B3 00 48 8F B2 00 44 8F B1 00 40 8F B0 00 3C 03 E0 00 08 27 BD 00 58 }
	condition:
		$1
}

rule file_686_10_0 {
	meta:
		name = "getrpcbyname_r"
		size = 240
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 0024 __pthread_mutex_unlock 0068 __pthread_mutex_lock 0078 __GI_getrpcbyname 00a8 __copy_rpcent.part.1 00b8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A8 AF B2 00 44 8F 92 ?? ?? 8F 99 ?? ?? AF B4 00 4C 00 A0 A0 21 8F 85 ?? ?? AF B0 00 3C 27 B0 00 20 AF A7 00 30 AF BF 00 54 AF BC 00 18 AF B5 00 50 AF B3 00 48 AF B1 00 40 00 80 A8 21 00 C0 98 21 02 00 20 21 26 46 ?? ?? ?? ?? ?? ?? 8F B1 00 68 8F BC 00 18 26 44 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 12 00 02 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 02 A0 20 21 8F BC 00 18 AE 20 00 00 10 40 00 0A 8F A7 00 30 8F 99 ?? ?? AF B1 00 10 00 40 20 21 02 80 28 21 27 39 ?? ?? ?? ?? ?? ?? 02 60 30 21 8F BC 00 18 00 40 90 21 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 24 05 00 01 8F BF 00 54 02 40 10 21 8F B5 00 50 8F B4 00 4C 8F B3 00 48 8F B2 00 44 8F B1 00 40 8F B0 00 3C 03 E0 00 08 27 BD 00 58 }
	condition:
		$1
}

rule file_686_11_0 {
	meta:
		name = "getrpcent_r"
		size = 236
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 0024 __pthread_mutex_unlock 0064 __pthread_mutex_lock 0074 __GI_getrpcent 00a4 __copy_rpcent.part.1 00b4 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B0 AF B2 00 3C 8F 92 ?? ?? 8F 99 ?? ?? AF B4 00 44 00 A0 A0 21 8F 85 ?? ?? AF B0 00 34 27 B0 00 20 AF BF 00 4C AF BC 00 18 AF B5 00 48 AF B3 00 40 AF B1 00 38 00 80 A8 21 00 C0 98 21 02 00 20 21 26 46 ?? ?? ?? ?? ?? ?? 00 E0 88 21 8F BC 00 18 26 44 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 12 00 02 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 18 10 40 00 0B AE 20 00 00 8F 99 ?? ?? AF B1 00 10 00 40 20 21 02 A0 28 21 02 80 30 21 27 39 ?? ?? ?? ?? ?? ?? 02 60 38 21 8F BC 00 18 00 40 90 21 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 24 05 00 01 8F BF 00 4C 02 40 10 21 8F B5 00 48 8F B4 00 44 8F B3 00 40 8F B2 00 3C 8F B1 00 38 8F B0 00 34 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_687_0_0 {
	meta:
		name = "__libc_select"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 8F A2 00 30 27 BD FF E0 AF A2 00 10 24 02 10 2E 00 00 00 0C 27 BD 00 20 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_688_0_0 {
	meta:
		name = "__GI_seed48_r"
		size = 140
		refs = "0000 _gp_disp 000c __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 24 06 00 06 AF BF 00 24 AF B1 00 20 AF B0 00 1C 00 80 88 21 AF BC 00 10 24 A4 00 06 ?? ?? ?? ?? 00 A0 80 21 96 22 00 04 8F BF 00 24 3C 03 DE EC A6 02 00 04 96 22 00 02 34 63 E6 6D A6 02 00 02 96 22 00 00 8F B1 00 20 AE 03 00 14 A6 02 00 00 24 02 00 05 AE 02 00 10 24 02 00 0B A6 02 00 0C 24 02 00 01 A6 02 00 0E 8F B0 00 1C 00 00 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_689_0_0 {
	meta:
		name = "__GI_setreuid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F E6 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_691_0_0 {
	meta:
		name = "__dns_lookup"
		size = 2052
		refs = "0000 _gp_disp 000c malloc 0060 __GI_strlen 00c8 __GI_memcpy 0100 __pthread_mutex_unlock 0104 __resolv_lock 0108 _pthread_cleanup_push_defer 011c __pthread_mutex_lock 012c __open_nameservers 0144 __searchdomains 0168 __searchdomain 016c __GI_strcpy 0190 __nameservers 01e4 __nameserver 0224 _pthread_cleanup_pop_restore 0240 __GI_memset 0270 __encode_header 02a8 __encode_question 02d0 __GI_socket 02f0 __GI_connect 030c __GI_send 0334 __GI_poll 035c __GI_recv 0398 __decode_header 03d8 __GI___h_errno_location 04d0 __decode_dotted 0510 __GI_strdup 05f0 __GI_close 067c free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FE 08 AF BC 00 18 AF BF 01 F4 AF B7 01 EC AF B6 01 E8 AF B0 01 D0 AF A5 01 FC 00 80 80 21 AF A6 02 00 24 04 02 00 AF BE 01 F0 AF B5 01 E4 AF B4 01 E0 AF B3 01 DC AF B2 01 D8 AF B1 01 D4 ?? ?? ?? ?? 00 E0 B0 21 8F BC 00 18 02 00 20 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 B8 21 AF A2 01 A4 2C 42 03 7F 14 40 00 03 8F BC 00 18 10 00 01 C1 AF A0 01 A0 8F A3 01 A4 8F 99 ?? ?? ?? ?? ?? ?? 24 64 00 82 AF A2 01 A0 12 E0 01 BA 8F BC 00 18 50 40 01 B8 AF A0 01 A0 82 02 00 00 10 40 01 B5 8F B9 01 A4 8F A4 01 A0 02 00 28 21 02 19 10 21 80 42 FF FF 03 20 30 21 8F 99 ?? ?? AF A2 01 B8 ?? ?? ?? ?? 24 13 FF FF 27 A3 00 20 8F B9 01 A4 AF A3 01 B4 8F A3 01 A0 27 22 00 01 8F BC 00 18 00 62 10 21 24 10 FF FF AF A0 01 B0 AF A2 01 BC 8F 85 ?? ?? 8F 86 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 27 A4 00 20 8F BC 00 18 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 18 8F A3 01 A4 8F B9 01 A0 8F 82 ?? ?? 8C 5E 00 00 03 23 10 21 02 1E 18 2B 14 60 00 03 24 03 00 2E 10 00 00 0B A0 40 00 00 A0 43 00 00 8F 82 ?? ?? 8F 99 ?? ?? 8F A4 01 BC 8C 43 00 00 00 10 10 80 00 62 10 21 ?? ?? ?? ?? 8C 45 00 00 8F BC 00 18 06 61 00 0A 8F 82 ?? ?? 8F 84 ?? ?? 8F 85 ?? ?? 8C 43 00 00 94 84 ?? ?? 8C B3 ?? ?? AF A4 01 AC 24 04 00 03 70 83 28 02 AF A5 01 B0 8C 42 00 00 8F A3 01 AC 8F 84 ?? ?? 02 62 10 2B 00 02 98 0A 24 62 00 01 8F B9 01 B0 30 42 FF FF 8F 85 ?? ?? A4 82 ?? ?? AF A2 01 AC 8F 82 ?? ?? 27 39 FF FF AF B9 01 B0 AC B3 ?? ?? 27 B9 01 78 8C 45 00 00 03 20 20 21 AF B9 01 A8 8F 99 ?? ?? 00 13 11 00 24 06 00 10 ?? ?? ?? ?? 00 A2 28 21 8F BC 00 18 27 A4 00 20 24 05 00 01 8F 99 ?? ?? 27 B2 01 20 ?? ?? ?? ?? 24 14 00 01 8F BC 00 18 02 E0 20 21 00 00 28 21 8F 99 ?? ?? ?? ?? ?? ?? 24 06 02 00 8F BC 00 18 02 40 20 21 00 00 28 21 8F 99 ?? ?? ?? ?? ?? ?? 24 06 00 30 8F BC 00 18 8F A3 01 AC AF B4 01 40 8F 99 ?? ?? AF A3 01 20 AF B4 01 34 02 40 20 21 02 E0 28 21 ?? ?? ?? ?? 24 06 02 00 00 40 88 21 04 40 01 3C 8F BC 00 18 8F B9 01 A0 8F A3 01 FC 24 06 02 00 AF B9 01 88 8F 99 ?? ?? AF B4 01 90 AF A3 01 8C 27 A4 01 88 02 E2 28 21 ?? ?? ?? ?? 00 C2 30 23 00 40 A0 21 04 40 01 2E 8F BC 00 18 8F 99 ?? ?? 97 A4 01 78 24 05 00 01 ?? ?? ?? ?? 24 06 00 11 00 40 A8 21 04 40 01 1B 8F BC 00 18 8F 99 ?? ?? 00 40 20 21 27 A5 01 78 ?? ?? ?? ?? 24 06 00 10 04 40 01 14 8F BC 00 18 8F 99 ?? ?? 02 34 30 21 02 A0 20 21 02 E0 28 21 ?? ?? ?? ?? 00 00 38 21 8F BC 00 18 27 B9 01 94 24 11 13 88 AF B9 01 A8 8F 99 ?? ?? 24 02 00 01 AF B5 01 94 A7 A2 01 98 27 A4 01 94 24 05 00 01 ?? ?? ?? ?? 02 20 30 21 18 40 01 00 8F BC 00 18 8F 99 ?? ?? 02 A0 20 21 02 E0 28 21 24 06 02 00 ?? ?? ?? ?? 24 07 00 40 00 40 A0 21 28 42 00 0C 26 31 FC 18 10 40 00 05 8F BC 00 18 16 20 FF EB 8F 99 ?? ?? 10 00 00 F2 26 73 00 01 8F 99 ?? ?? 02 E0 20 21 ?? ?? ?? ?? 02 40 28 21 8F A2 01 20 8F A3 01 AC 14 43 FF F5 8F BC 00 18 8F A2 01 24 10 40 FF F2 8F A2 01 3C 24 03 00 03 14 43 00 0E 8F B9 01 B8 24 02 00 2E 53 22 00 06 8F 99 ?? ?? 27 C2 FF FF 02 02 10 2A 14 40 00 DE 26 10 00 01 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 18 10 00 00 0B 24 03 00 01 54 40 00 D5 26 73 00 01 8F A2 01 44 1C 40 00 08 24 10 00 0C 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 18 24 03 00 04 10 00 00 DD AC 43 00 00 00 00 28 21 24 08 FF C0 24 09 00 C0 8F A2 01 40 00 A2 10 2A 10 40 00 1A 02 F0 30 21 10 C0 00 C1 02 90 10 23 00 C0 20 21 58 40 00 BF 26 73 00 01 90 83 00 00 10 60 00 0A 24 87 00 01 00 68 50 24 55 49 00 04 24 42 FF FF 24 87 00 02 10 00 00 04 24 42 FF FE 00 E3 20 21 10 00 FF F3 00 43 10 23 28 42 00 04 14 40 00 AF 00 E6 30 23 24 C6 00 04 04 C0 00 AC 02 06 80 21 10 00 FF E4 24 A5 00 01 27 A3 01 50 24 12 00 01 00 00 88 21 AF A3 01 A8 8F A2 01 44 02 22 10 2A 10 40 00 48 8F 99 ?? ?? 24 04 01 00 AF A4 00 10 02 00 28 21 02 E0 20 21 02 80 30 21 ?? ?? ?? ?? 27 A7 00 20 00 40 18 21 04 40 00 37 8F BC 00 18 24 02 FF F6 00 43 28 23 00 B0 28 23 02 85 28 21 04 A0 00 30 8F 99 ?? ?? 02 03 30 21 27 A4 00 20 AF A3 01 C0 AF A5 01 C8 AF A6 01 C4 ?? ?? ?? ?? 02 E6 F0 21 AF A2 01 50 93 C2 00 00 93 C4 00 01 8F A6 01 C4 00 02 12 00 00 44 10 25 AF A2 01 54 93 C2 00 02 93 C4 00 03 8F A5 01 C8 00 02 12 00 00 44 10 25 AF A2 01 58 93 C4 00 04 93 C2 00 05 24 C6 00 0A 00 04 26 00 00 02 14 00 00 82 10 25 93 C4 00 07 27 DE 00 0A 8F BC 00 18 00 44 10 25 93 C4 FF FC 8F A3 01 C0 00 04 22 00 00 44 10 25 AF A2 01 5C 93 C2 FF FE 93 C4 FF FF AF BE 01 64 00 02 12 00 00 44 10 25 00 A2 28 2A AF A2 01 60 14 A0 00 07 AF A6 01 68 24 63 00 0A 10 00 00 02 00 62 18 21 00 A0 18 21 04 61 00 0F 00 00 00 00 12 20 00 5F 26 73 00 01 8F A2 01 30 10 40 00 5D 24 10 FF FF 8F 99 ?? ?? ?? ?? ?? ?? 02 A0 20 21 8F A3 02 00 10 60 00 4C 8F BC 00 18 8F B9 02 00 10 00 00 4D AF 37 00 00 12 40 00 2B 02 03 80 21 8E DE 00 1C 8E D2 00 20 8E C2 00 24 8F 99 ?? ?? AF BE 01 6C AF B2 01 70 AF A2 01 74 02 C0 20 21 27 A5 01 50 ?? ?? ?? ?? 24 06 00 28 8E C2 00 04 24 03 00 18 10 43 00 08 8F BC 00 18 13 C0 FF E5 8F B9 01 FC 24 03 00 01 13 23 00 03 24 03 00 1C 17 23 FF E1 8F 99 ?? ?? 8F A3 01 FC 10 43 00 06 8F 99 ?? ?? 8E C4 00 00 ?? ?? ?? ?? 24 12 00 01 10 00 00 27 8F BC 00 18 8F A2 01 44 8E C3 00 10 00 51 10 23 24 42 FF FF 24 63 00 04 AE C2 00 24 70 43 10 02 02 42 90 2B 16 40 FF CF 8F 99 ?? ?? 10 00 00 1B AE C0 00 24 8F 99 ?? ?? ?? ?? ?? ?? 8F A4 01 50 8F A2 01 54 8F A3 01 FC 14 43 00 14 8F BC 00 18 8E C6 00 10 8F A2 01 60 50 C2 00 06 8E C4 00 24 8F 99 ?? ?? ?? ?? ?? ?? 8E C4 00 00 10 00 00 16 8F BC 00 18 8E C2 00 1C 8F 99 ?? ?? 70 C4 18 02 8F A5 01 64 ?? ?? ?? ?? 00 62 20 21 8E C2 00 24 8F BC 00 18 24 42 00 01 AE C2 00 24 10 00 FF 65 26 31 00 01 8F 99 ?? ?? ?? ?? ?? ?? 02 E0 20 21 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 8F A4 01 A0 10 00 00 20 02 80 10 21 26 73 00 01 24 10 FF FF 8F A3 01 B0 18 60 00 08 24 02 FF FF 12 A2 FE 64 8F 99 ?? ?? ?? ?? ?? ?? 02 A0 20 21 10 00 FE 60 8F BC 00 18 24 15 FF FF 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 FF FF 8F BC 00 18 12 A3 00 05 AC 43 00 00 8F 99 ?? ?? ?? ?? ?? ?? 02 A0 20 21 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 8F A4 01 A0 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 02 E0 20 21 24 02 FF FF 8F BF 01 F4 8F BE 01 F0 8F B7 01 EC 8F B6 01 E8 8F B5 01 E4 8F B4 01 E0 8F B3 01 DC 8F B2 01 D8 8F B1 01 D4 8F B0 01 D0 03 E0 00 08 27 BD 01 F8 }
	condition:
		$1
}

rule file_692_0_0 {
	meta:
		name = "__fbufsize"
		size = 16
	strings:
		$1 = { 8C 83 00 0C 8C 82 00 08 03 E0 00 08 00 62 10 23 }
	condition:
		$1
}

rule file_694_0_0 {
	meta:
		name = "labs"
		size = 16
	strings:
		$1 = { 00 04 1F C3 00 64 10 26 03 E0 00 08 00 43 10 23 }
	condition:
		$1
}

rule file_695_0_0 {
	meta:
		name = "__GI_kill"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F C5 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_696_0_0 {
	meta:
		name = "__GI_strncmp"
		size = 184
	strings:
		$1 = { 2C C2 00 04 14 40 00 1D 00 06 38 82 90 82 00 00 10 40 00 27 90 A3 00 00 14 43 00 25 00 00 00 00 90 82 00 01 10 40 00 22 90 A3 00 01 14 43 00 20 00 00 00 00 90 82 00 02 10 40 00 1D 90 A3 00 02 14 43 00 1B 24 88 00 04 90 82 00 03 90 A3 00 03 10 40 00 17 24 A4 00 04 14 43 00 15 24 E7 FF FF 10 E0 00 03 00 80 28 21 10 00 FF E8 01 00 20 21 30 C6 00 03 10 00 00 0C 01 00 20 21 00 00 18 21 10 00 00 09 00 00 10 21 24 87 00 01 90 A3 00 00 10 40 00 07 24 A4 00 01 14 43 00 05 00 80 28 21 24 C6 FF FF 00 E0 20 21 54 C0 FF F7 90 82 00 00 03 E0 00 08 00 43 10 23 }
	condition:
		$1
}

rule file_697_0_0 {
	meta:
		name = "__GI_gettimeofday"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F EE 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_698_0_0 {
	meta:
		name = "__syscall_rt_sigaction"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 62 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_699_1_0 {
	meta:
		name = "lckpwdf"
		size = 576
		refs = "0000 _gp_disp 0050 __pthread_mutex_unlock 0054 _pthread_cleanup_push_defer 006c __pthread_mutex_lock 0084 __GI_open 0080 $LC0 009c __GI_fcntl 00d4 __GI_sigaction 0114 __GI___sigaddset 013c __GI_sigprocmask 0154 __GI_alarm 0170 __GI_memset 01e4 __GI_close 01f8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 28 AF B1 00 B4 8F 91 ?? ?? AF B0 00 B0 AF BC 00 10 8E 30 ?? ?? 24 02 FF FF AF BF 00 D4 AF BE 00 D0 AF B7 00 CC AF B6 00 C8 AF B5 00 C4 AF B4 00 C0 AF B3 00 BC AF B2 00 B8 16 02 00 71 8F 92 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 27 B3 00 74 26 46 ?? ?? ?? ?? ?? ?? 02 60 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 44 ?? ?? 8F BC 00 10 24 05 00 01 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 84 ?? ?? AE 22 ?? ?? 10 50 00 58 8F BC 00 10 8F 92 ?? ?? 00 40 20 21 02 40 C8 21 ?? ?? ?? ?? 24 05 00 01 8E 24 ?? ?? 24 05 00 02 02 40 C8 21 ?? ?? ?? ?? 34 46 00 01 8F BC 00 10 27 A5 00 3C 27 B5 00 58 8F 82 ?? ?? 8F 94 ?? ?? 02 A0 30 21 24 42 ?? ?? AF A0 00 3C 24 04 00 0E AC A0 00 18 02 80 C8 21 AF A2 00 40 AF B0 00 50 AF B0 00 4C AF B0 00 48 ?? ?? ?? ?? AF B0 00 44 8F BC 00 10 27 B6 00 84 02 C0 20 21 8F 99 ?? ?? 24 05 00 0E AF A0 00 90 AF A0 00 8C AF A0 00 88 ?? ?? ?? ?? AF A0 00 84 8F BC 00 10 02 C0 28 21 27 B7 00 94 8F 96 ?? ?? 02 E0 30 21 02 C0 C8 21 ?? ?? ?? ?? 24 04 00 02 8F BC 00 10 8F 9E ?? ?? 03 C0 C8 21 ?? ?? ?? ?? 24 04 00 0F 8F BC 00 10 27 A3 00 18 00 60 20 21 8F 99 ?? ?? 00 00 28 21 24 06 00 24 ?? ?? ?? ?? AF A3 00 A8 8F A3 00 A8 8E 24 ?? ?? 24 02 00 01 00 60 30 21 24 05 00 07 02 40 C8 21 ?? ?? ?? ?? A7 A2 00 18 00 00 20 21 03 C0 C8 21 ?? ?? ?? ?? 00 40 90 21 24 04 00 03 02 E0 28 21 02 C0 C8 21 ?? ?? ?? ?? 00 00 30 21 24 04 00 0E 02 A0 28 21 02 80 C8 21 ?? ?? ?? ?? 00 00 30 21 06 41 00 06 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 8E 24 ?? ?? 8F BC 00 10 AE 30 ?? ?? 8F 99 ?? ?? 02 60 20 21 ?? ?? ?? ?? 24 05 00 01 10 00 00 01 00 00 10 21 8F BF 00 D4 8F BE 00 D0 8F B7 00 CC 8F B6 00 C8 8F B5 00 C4 8F B4 00 C0 8F B3 00 BC 8F B2 00 B8 8F B1 00 B4 8F B0 00 B0 03 E0 00 08 27 BD 00 D8 }
	condition:
		$1
}

rule file_699_2_0 {
	meta:
		name = "ulckpwdf"
		size = 184
		refs = "0000 _gp_disp 003c __pthread_mutex_unlock 0040 _pthread_cleanup_push_defer 0058 __pthread_mutex_lock 0068 __GI_close 0080 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B0 00 34 8F 90 ?? ?? AF B2 00 3C AF BC 00 10 8E 02 ?? ?? 24 12 FF FF AF BF 00 44 AF B3 00 40 AF B1 00 38 10 52 00 18 8F 93 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 27 B1 00 18 26 66 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 64 ?? ?? 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 8E 04 ?? ?? 8F BC 00 10 AF A2 00 28 AE 12 ?? ?? 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 24 05 00 01 10 00 00 02 8F A2 00 28 24 02 FF FF 8F BF 00 44 8F B3 00 40 8F B2 00 3C 8F B1 00 38 8F B0 00 34 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_700_0_0 {
	meta:
		name = "wcsstr"
		size = 72
	strings:
		$1 = { 00 A0 18 21 00 80 10 21 8C 67 00 00 10 E0 00 0A 00 00 00 00 8C 46 00 00 14 E6 00 03 24 63 00 04 10 00 FF F9 24 42 00 04 10 C0 00 05 24 84 00 04 10 00 FF F4 00 A0 18 21 03 E0 00 08 00 80 10 21 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_701_0_0 {
	meta:
		name = "__GI_hdestroy_r"
		size = 92
		refs = "0000 _gp_disp 0024 __GI___errno_location 003c free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF B0 00 18 AF BF 00 1C 14 80 00 07 00 80 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 10 00 00 05 AC 43 00 00 8F 99 ?? ?? ?? ?? ?? ?? 8C 84 00 00 AE 00 00 00 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_702_0_0 {
	meta:
		name = "__GI_getmntent_r"
		size = 444
		refs = "0000 _gp_disp 0054 __GI_fgets 0098 __GI_strtok_r 0114 $LC0 013c __GI_atoi"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF BC 00 10 AF B2 00 28 AF BF 00 3C AF B6 00 38 AF B5 00 34 AF B4 00 30 AF B3 00 2C AF B1 00 24 AF B0 00 20 14 80 00 03 00 80 90 21 10 00 00 55 00 00 10 21 10 A0 FF FD 00 A0 80 21 10 C0 FF FB 00 C0 88 21 8F 93 ?? ?? 00 E0 A0 21 24 15 00 23 24 16 00 0A 02 20 20 21 02 80 28 21 02 60 C8 21 ?? ?? ?? ?? 02 40 30 21 10 40 FF F0 8F BC 00 10 82 22 00 00 10 55 FF F8 02 20 20 21 10 56 FF F7 02 80 28 21 8F 93 ?? ?? 8F 92 ?? ?? 27 B1 00 18 AF A0 00 18 26 65 ?? ?? 02 40 C8 21 ?? ?? ?? ?? 02 20 30 21 10 40 FF E1 AE 02 00 00 00 00 20 21 26 65 ?? ?? 02 40 C8 21 ?? ?? ?? ?? 02 20 30 21 10 40 FF DA AE 02 00 04 00 00 20 21 26 65 ?? ?? 02 40 C8 21 ?? ?? ?? ?? 02 20 30 21 10 40 FF D3 AE 02 00 08 00 00 20 21 26 65 ?? ?? 02 40 C8 21 ?? ?? ?? ?? 02 20 30 21 8F BC 00 10 14 40 00 04 AE 02 00 0C 8F 82 ?? ?? 24 42 ?? ?? AE 02 00 0C 00 00 20 21 26 65 ?? ?? 02 40 C8 21 ?? ?? ?? ?? 02 20 30 21 10 40 00 06 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 10 00 00 03 AE 02 00 10 00 00 10 21 AE 02 00 10 00 00 20 21 26 65 ?? ?? 02 40 C8 21 ?? ?? ?? ?? 02 20 30 21 10 40 00 06 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 10 00 00 03 AE 02 00 14 00 00 10 21 AE 02 00 14 02 00 10 21 8F BF 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_702_1_0 {
	meta:
		name = "getmntent"
		size = 228
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 004c __pthread_mutex_lock 006c malloc 0084 __GI_abort 0098 __GI_getmntent_r 00b8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B0 00 34 8F 90 ?? ?? 8F 99 ?? ?? 8F 85 ?? ?? AF B1 00 38 27 B1 00 18 AF BC 00 10 26 06 ?? ?? AF BF 00 44 AF B3 00 40 AF B2 00 3C 00 80 90 21 ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 04 ?? ?? 8F BC 00 10 8F 90 ?? ?? 8E 02 ?? ?? 14 40 00 0A 02 00 98 21 8F 99 ?? ?? ?? ?? ?? ?? 24 04 10 00 AE 02 ?? ?? 14 40 00 04 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F 85 ?? ?? 8E 66 ?? ?? 8F 99 ?? ?? 02 40 20 21 24 07 10 00 ?? ?? ?? ?? 24 A5 ?? ?? 8F BC 00 10 02 20 20 21 AF A2 00 28 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 01 8F BF 00 44 8F A2 00 28 8F B3 00 40 8F B2 00 3C 8F B1 00 38 8F B0 00 34 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_702_2_0 {
	meta:
		name = "addmntent"
		size = 156
		refs = "0000 _gp_disp 000c __GI_fseek 0058 __GI_fprintf 0044 $LC1"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF C8 24 06 00 02 AF BC 00 20 AF B1 00 30 AF B0 00 2C AF BF 00 34 00 A0 80 21 00 00 28 21 ?? ?? ?? ?? 00 80 88 21 04 40 00 12 8F BC 00 20 8E 02 00 08 8F 85 ?? ?? 8E 06 00 00 AF A2 00 10 8E 02 00 0C 8E 07 00 04 8F 99 ?? ?? AF A2 00 14 8E 02 00 10 02 20 20 21 24 A5 ?? ?? AF A2 00 18 8E 02 00 14 ?? ?? ?? ?? AF A2 00 1C 10 00 00 02 00 02 17 C2 24 02 00 01 8F BF 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_702_5_0 {
	meta:
		name = "__GI_endmntent"
		size = 64
		refs = "0000 _gp_disp 0010 __GI_fclose"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 10 80 00 0A 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 ?? ?? ?? ?? 00 00 00 00 8F BF 00 1C 24 02 00 01 03 E0 00 08 27 BD 00 20 03 E0 00 08 24 02 00 01 }
	condition:
		$1
}

rule file_704_0_0 {
	meta:
		name = "fgetpos"
		size = 216
		refs = "0000 _gp_disp 0038 _pthread_cleanup_push_defer 003c __pthread_mutex_unlock 0054 __pthread_mutex_lock 0064 __GI_ftell 00a8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF B1 00 30 AF B0 00 2C AF BC 00 10 AF BF 00 3C AF B3 00 38 AF B2 00 34 8C 92 00 34 00 80 80 21 16 40 00 0C 00 A0 88 21 8F 99 ?? ?? 8F 85 ?? ?? 24 93 00 38 02 60 30 21 ?? ?? ?? ?? 27 A4 00 18 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 AE 22 00 00 04 40 00 09 8F BC 00 10 8E 02 00 2C AE 22 00 04 8E 02 00 30 AE 22 00 08 92 02 00 02 00 00 80 21 10 00 00 02 AE 22 00 0C 24 10 FF FF 16 40 00 06 8F BF 00 3C 8F 99 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F BF 00 3C 02 00 10 21 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_705_0_0 {
	meta:
		name = "__GI_mbrtowc"
		size = 152
		refs = "0000 _gp_disp 0054 __GI_mbsnrtowcs"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF BC 00 18 AF B0 00 30 AF BF 00 34 14 E0 00 03 00 80 80 21 8F 87 ?? ?? 24 E7 ?? ?? 54 A0 00 05 80 A3 00 00 A3 A0 00 28 27 A5 00 28 10 00 00 05 00 00 80 21 10 60 00 10 00 00 10 21 10 C0 00 0F 8F BF 00 34 8F 99 ?? ?? AF A5 00 20 AF A7 00 10 27 A4 00 24 27 A5 00 20 24 06 FF FF ?? ?? ?? ?? 24 07 00 01 04 40 00 05 8F BF 00 34 12 00 00 03 8F A3 00 24 AE 03 00 00 8F BF 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_707_0_0 {
	meta:
		name = "query_module"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 8F A2 00 30 27 BD FF E0 AF A2 00 10 24 02 10 5B 00 00 00 0C 27 BD 00 20 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_708_0_0 {
	meta:
		name = "closelog_intern"
		size = 160
		refs = "0000 _gp_disp 0038 __GI_close 0060 $LC0"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 83 ?? ?? 27 BD FF D8 AF B0 00 1C 00 80 80 21 8C 64 ?? ?? AF B1 00 20 AF BC 00 10 00 60 88 21 24 03 FF FF AF BF 00 24 10 83 00 04 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 24 02 FF FF AE 22 ?? ?? 8F 82 ?? ?? 16 00 00 0D AC 40 ?? ?? 8F 82 ?? ?? 8F 83 ?? ?? AC 40 ?? ?? 8F 82 ?? ?? 24 63 ?? ?? AC 43 ?? ?? 8F 82 ?? ?? 24 03 00 08 AC 43 ?? ?? 8F 82 ?? ?? 24 03 00 FF AC 43 ?? ?? 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_708_1_0 {
	meta:
		name = "__GI_openlog"
		size = 496
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 0024 __pthread_mutex_unlock 0064 __pthread_mutex_lock 00c8 __GI_socket 00ec __GI_fcntl 0154 _pthread_cleanup_pop_restore 015c __GI_connect 018c __GI_close"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B0 AF B3 00 38 8F 93 ?? ?? 8F 99 ?? ?? AF B4 00 3C 00 A0 A0 21 8F 85 ?? ?? AF B2 00 34 27 B2 00 18 AF BC 00 10 AF BF 00 4C AF B1 00 30 AF B0 00 2C AF B7 00 48 AF B6 00 44 AF B5 00 40 00 80 88 21 00 C0 80 21 02 40 20 21 ?? ?? ?? ?? 26 66 ?? ?? 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 64 ?? ?? 12 20 00 03 8F BC 00 10 8F 82 ?? ?? AC 51 ?? ?? 8F 95 ?? ?? 12 00 00 07 AE B4 ?? ?? 24 02 FC 07 02 02 10 24 14 40 00 04 8F 93 ?? ?? 8F 82 ?? ?? AC 50 ?? ?? 8F 93 ?? ?? 24 02 FF FF 8E 63 ?? ?? 14 62 00 21 24 10 00 01 8E A2 ?? ?? 30 42 00 08 10 40 00 1E 8E 64 ?? ?? 8F 99 ?? ?? 24 04 00 01 02 00 28 21 ?? ?? ?? ?? 00 00 30 21 24 03 FF FF 8F BC 00 10 10 43 00 33 AE 62 ?? ?? 8F 91 ?? ?? 24 06 00 01 00 40 20 21 02 20 C8 21 ?? ?? ?? ?? 24 05 00 02 8F BC 00 10 24 05 00 03 02 20 C8 21 8F 82 ?? ?? 8C 54 ?? ?? ?? ?? ?? ?? 02 80 20 21 34 46 00 80 02 80 20 21 02 20 C8 21 ?? ?? ?? ?? 24 05 00 04 8F BC 00 10 8E 64 ?? ?? 24 17 FF FF 10 97 00 1C 8F 94 ?? ?? 8F 96 ?? ?? 8E C2 ?? ?? 14 40 00 19 8F 99 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 24 06 00 10 ?? ?? ?? ?? 24 A5 ?? ?? 00 40 88 21 10 57 00 04 8F BC 00 10 24 02 00 01 10 00 00 0D AE C2 ?? ?? 8E 84 ?? ?? 10 82 00 05 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 AE 91 ?? ?? 24 02 00 01 16 02 00 04 8F 99 ?? ?? 10 00 FF C2 24 10 00 02 8F 99 ?? ?? 02 40 20 21 ?? ?? ?? ?? 24 05 00 01 8F BF 00 4C 8F B7 00 48 8F B6 00 44 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_708_2_0 {
	meta:
		name = "__GI_vsyslog"
		size = 1168
		refs = "0000 _gp_disp 001c __GI_sigaction 0090 __GI___errno_location 00b8 __pthread_mutex_unlock 00c0 _pthread_cleanup_push_defer 00d0 __pthread_mutex_lock 0130 __GI_openlog 0150 __GI_time 0174 __GI_ctime 0190 __GI_sprintf 018c $LC1 01b4 __GI_strlen 01d0 $LC2 01f4 __GI_strcpy 01f0 $LC3 0220 __GI_getpid 0238 $LC4 027c __GI_vsnprintf 02b8 __GI_memmove 02dc __GI_memcpy 0320 __GI_write 0390 closelog_intern 03b4 _pthread_cleanup_pop_restore 03cc __GI_open 03c8 $LC6 03e8 __GI_strchr 0428 __GI_close"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FB 60 AF B2 04 80 8F 92 ?? ?? AF B1 04 7C 8F 91 ?? ?? AF BC 00 10 AF BE 04 98 27 B9 04 18 00 A0 F0 21 26 52 ?? ?? 27 A5 04 34 AF BF 04 9C AF B7 04 94 AF B4 04 88 AF B3 04 84 AF B0 04 78 AF B6 04 90 AF B5 04 8C AF A0 04 34 00 80 80 21 AC A0 00 08 AC A0 00 0C AC A0 00 10 AC A0 00 14 AC A0 00 18 24 04 00 0D AF B9 04 68 00 C0 B8 21 03 20 30 21 02 20 C8 21 ?? ?? ?? ?? AF B2 04 38 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8C 59 00 00 8F BC 00 10 00 40 98 21 AF B9 04 70 8F 94 ?? ?? 27 B9 04 50 03 20 20 21 8F 85 ?? ?? AF B9 04 6C 8F 99 ?? ?? ?? ?? ?? ?? 26 86 ?? ?? 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 84 ?? ?? 8F BC 00 10 24 03 00 01 32 02 00 07 00 43 10 04 8F 83 ?? ?? 8C 63 ?? ?? 00 43 10 24 10 40 00 CF 24 02 FC 00 02 02 10 24 14 40 00 CC 8F 96 ?? ?? 8F 94 ?? ?? 8E C2 ?? ?? 04 40 00 05 8F 92 ?? ?? 8F 82 ?? ?? 8C 42 ?? ?? 14 40 00 09 32 02 03 F8 8E 45 ?? ?? 8F 99 ?? ?? 8E 84 ?? ?? 34 A5 00 08 ?? ?? ?? ?? 00 00 30 21 8F BC 00 10 32 02 03 F8 14 40 00 04 8F 99 ?? ?? 8F 82 ?? ?? 8C 42 ?? ?? 02 02 80 25 27 B1 04 60 ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 02 20 20 21 8F 99 ?? ?? ?? ?? ?? ?? 27 B1 00 18 8F BC 00 10 02 00 30 21 02 20 20 21 8F 85 ?? ?? 8F 99 ?? ?? 24 47 00 04 24 A5 ?? ?? ?? ?? ?? ?? AF B9 04 74 8E 95 ?? ?? 8F BC 00 10 12 A0 00 17 02 22 80 21 8F 99 ?? ?? ?? ?? ?? ?? 02 A0 20 21 2C 42 03 C0 8F BC 00 10 10 40 00 09 02 00 20 21 8F 85 ?? ?? 8F 99 ?? ?? 02 A0 30 21 ?? ?? ?? ?? 24 A5 ?? ?? 02 02 A8 21 10 00 00 09 8F BC 00 10 8F 85 ?? ?? 8F 99 ?? ?? 26 15 00 18 ?? ?? ?? ?? 24 A5 ?? ?? 10 00 00 02 8F BC 00 10 02 00 A8 21 8E 42 ?? ?? 30 42 00 01 10 40 00 0E 8E 82 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 02 A0 20 21 00 40 30 21 8F 85 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? 8F BC 00 10 02 A2 A8 21 8E 82 ?? ?? 10 40 00 05 24 02 00 3A A2 A2 00 00 24 02 00 20 A2 A2 00 01 26 B5 00 02 8F B9 04 70 27 B4 04 17 02 95 40 23 AE 79 00 00 8F 99 ?? ?? 01 00 28 21 03 C0 30 21 02 E0 38 21 AF A8 04 74 ?? ?? ?? ?? 02 A0 20 21 02 A2 B8 21 02 F4 10 2B 8F BC 00 10 02 F5 F0 2B 10 40 00 03 8F A8 04 74 13 C0 00 18 8E 42 ?? ?? 8F 99 ?? ?? 25 06 FF F4 26 A4 00 0C ?? ?? ?? ?? 02 A0 28 21 8F BC 00 10 02 A0 20 21 24 06 00 0C 8F 85 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? 17 C0 00 06 8F BC 00 10 10 00 00 07 27 B7 04 16 10 40 00 06 8E 42 ?? ?? 26 F7 00 01 02 F4 10 2B 54 40 FF FB 82 E2 00 00 8E 42 ?? ?? 30 42 00 20 10 40 00 0B 8E C2 ?? ?? 8F 99 ?? ?? 24 02 00 0A 02 F0 30 23 A2 E2 00 00 24 04 00 02 02 00 28 21 ?? ?? ?? ?? 24 C6 00 01 8F BC 00 10 8E C2 ?? ?? 04 40 00 1B A2 E0 00 00 8F 95 ?? ?? 02 20 A0 21 26 FE 00 01 24 10 00 04 8E C4 ?? ?? 02 80 28 21 02 A0 C8 21 ?? ?? ?? ?? 03 D4 30 23 04 41 00 0A 8F BC 00 10 8E 62 00 00 10 50 00 07 00 00 10 21 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 24 04 00 01 10 00 00 07 8F BC 00 10 02 82 A0 21 02 F4 10 2B 10 40 FF EE 8E C4 ?? ?? 10 00 00 22 8F 99 ?? ?? 8E 42 ?? ?? 30 42 00 02 10 40 00 1E 8F 99 ?? ?? 8F 84 ?? ?? 8F 99 ?? ?? 24 05 08 01 ?? ?? ?? ?? 24 84 ?? ?? 00 40 80 21 04 40 00 15 8F BC 00 10 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 24 05 00 3E 8F BC 00 10 24 45 00 01 24 02 00 0D 8F 99 ?? ?? 02 E5 30 23 A2 E2 00 00 24 02 00 0A 02 00 20 21 24 C6 00 02 ?? ?? ?? ?? A2 E2 00 01 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F 99 ?? ?? 27 A4 04 50 ?? ?? ?? ?? 24 05 00 01 8F BC 00 10 27 A5 04 18 24 04 00 0D 8F 99 ?? ?? ?? ?? ?? ?? 00 00 30 21 8F BF 04 9C 8F BE 04 98 8F B7 04 94 8F B6 04 90 8F B5 04 8C 8F B4 04 88 8F B3 04 84 8F B2 04 80 8F B1 04 7C 8F B0 04 78 03 E0 00 08 27 BD 04 A0 }
	condition:
		$1
}

rule file_708_4_0 {
	meta:
		name = "__GI_closelog"
		size = 136
		refs = "0000 _gp_disp 0018 __pthread_mutex_unlock 001c _pthread_cleanup_push_defer 0040 __pthread_mutex_lock 0058 closelog_intern 0068 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B1 00 30 8F 91 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? AF B0 00 2C 27 B0 00 18 AF BF 00 34 26 26 ?? ?? AF BC 00 10 ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 24 ?? ?? 8F BC 00 10 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 20 21 8F BC 00 10 02 00 20 21 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 01 8F BF 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_708_5_0 {
	meta:
		name = "setlogmask"
		size = 164
		refs = "0000 _gp_disp 0040 __pthread_mutex_unlock 0044 _pthread_cleanup_push_defer 005c __pthread_mutex_lock 0074 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF B1 00 2C 8F 91 ?? ?? AF BC 00 10 AF B4 00 38 AF B2 00 30 AF BF 00 3C AF B3 00 34 AF B0 00 28 00 80 90 21 10 80 00 12 8E 34 ?? ?? 8F 93 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 27 B0 00 18 26 66 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 64 ?? ?? 8F BC 00 10 AE 32 ?? ?? 02 00 20 21 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 01 8F BF 00 3C 02 80 10 21 8F B3 00 34 8F B4 00 38 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_709_0_0 {
	meta:
		name = "__libc_sigsuspend"
		size = 88
		refs = "0000 _gp_disp 0030 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 05 00 10 24 02 10 67 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_710_0_0 {
	meta:
		name = "__GI_strlcat"
		size = 88
	strings:
		$1 = { 27 BD FF F0 00 00 10 21 00 46 18 2B 54 60 00 03 80 83 00 00 10 00 00 06 27 A4 00 08 50 60 00 05 80 A3 00 00 24 84 00 01 10 00 FF F7 24 42 00 01 80 A3 00 00 10 60 00 06 A0 83 00 00 24 42 00 01 00 46 18 2B 00 83 20 21 10 00 FF F9 24 A5 00 01 03 E0 00 08 27 BD 00 10 }
	condition:
		$1
}

rule file_712_0_0 {
	meta:
		name = "__GI_xdr_authunix_parms"
		size = 212
		refs = "0000 _gp_disp 000c __GI_xdr_u_long 0044 __GI_xdr_string 0060 __GI_xdr_u_int 0094 __GI_xdr_array"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D0 AF BC 00 18 AF B1 00 24 AF B0 00 20 AF BF 00 2C AF B2 00 28 00 80 88 21 ?? ?? ?? ?? 00 A0 80 21 14 40 00 03 8F BC 00 18 10 00 00 1F 00 00 10 21 8F 99 ?? ?? 02 20 20 21 26 05 00 04 ?? ?? ?? ?? 24 06 00 FF 10 40 FF F8 8F BC 00 18 8F 92 ?? ?? 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 26 05 00 08 10 40 00 11 00 00 10 21 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 26 05 00 0C 10 40 FF EB 8F BC 00 18 8F 99 ?? ?? 24 02 00 04 AF A2 00 10 AF B2 00 14 02 20 20 21 26 05 00 14 26 06 00 10 ?? ?? ?? ?? 24 07 00 10 00 02 10 2B 8F BF 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_714_0_0 {
	meta:
		name = "mbstowcs"
		size = 60
		refs = "0000 _gp_disp 000c __GI_mbsrtowcs"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D0 27 A7 00 18 AF BF 00 2C AF BC 00 10 AF A5 00 20 AF A0 00 18 ?? ?? ?? ?? 27 A5 00 20 8F BF 00 2C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_715_0_0 {
	meta:
		name = "wmemcmp"
		size = 64
	strings:
		$1 = { 10 C0 00 08 00 00 00 00 8C 83 00 00 8C A2 00 00 14 62 00 06 24 84 00 04 24 A5 00 04 10 00 FF F8 24 C6 FF FF 03 E0 00 08 00 00 10 21 00 62 18 2B 24 04 00 01 24 02 FF FF 03 E0 00 08 00 83 10 0A }
	condition:
		$1
}

rule file_716_0_0 {
	meta:
		name = "on_exit"
		size = 100
		refs = "0000 _gp_disp 000c __new_exitfn"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF B1 00 20 AF B0 00 1C AF BC 00 10 AF BF 00 24 00 80 80 21 ?? ?? ?? ?? 00 A0 88 21 10 40 00 06 24 03 00 02 AC 50 00 04 AC 51 00 08 AC 43 00 00 10 00 00 02 00 00 10 21 24 02 FF FF 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_717_0_0 {
	meta:
		name = "__GI_vfwprintf"
		size = 244
		refs = "0000 _gp_disp 0040 _pthread_cleanup_push_defer 0044 __pthread_mutex_unlock 005c __pthread_mutex_lock 007c __stdio_trans2w_o 0080 _vfwprintf_internal 00bc _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B4 00 40 AF B3 00 3C AF B0 00 30 AF BC 00 10 AF BF 00 44 AF B2 00 38 AF B1 00 34 8C 91 00 34 00 80 80 21 00 A0 98 21 16 20 00 0C 00 C0 A0 21 8F 99 ?? ?? 8F 85 ?? ?? 24 92 00 38 02 40 30 21 ?? ?? ?? ?? 27 A4 00 18 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 96 03 00 00 24 02 08 40 30 63 08 40 14 62 00 08 8F 99 ?? ?? 8F 99 ?? ?? 02 00 20 21 02 60 28 21 ?? ?? ?? ?? 02 80 30 21 10 00 00 07 8F BC 00 10 02 00 20 21 ?? ?? ?? ?? 24 05 08 00 10 40 FF F5 8F BC 00 10 24 02 FF FF 16 20 00 08 8F BF 00 44 8F 99 ?? ?? AF A2 00 28 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F A2 00 28 8F BF 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_719_0_0 {
	meta:
		name = "__GI_setsid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F E2 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_720_0_0 {
	meta:
		name = "__encode_dotted"
		size = 296
		refs = "0000 _gp_disp 0014 __GI_strlen 0064 __GI_strchr 00b4 __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF B7 00 34 8F 97 ?? ?? AF BE 00 38 AF B5 00 2C AF B4 00 28 AF B2 00 20 AF B0 00 18 AF BC 00 10 AF BF 00 3C AF B6 00 30 AF B3 00 24 AF B1 00 1C 00 80 80 21 00 A0 A0 21 00 C0 A8 21 00 00 90 21 24 DE FF FF 12 00 00 24 00 00 00 00 82 02 00 00 10 40 00 21 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 24 05 00 2E 00 40 98 21 10 40 00 03 8F BC 00 10 10 00 00 06 00 50 88 23 02 E0 C8 21 ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 00 40 88 21 56 20 00 03 03 D2 10 23 10 00 00 14 24 02 FF FF 02 22 10 2B 10 40 FF FC 8F 99 ?? ?? 26 56 00 01 02 92 90 21 A2 51 00 00 02 96 20 21 02 00 28 21 ?? ?? ?? ?? 02 20 30 21 02 36 90 21 12 60 00 03 8F BC 00 10 10 00 FF DC 26 70 00 01 1A A0 FF EE 02 92 A0 21 A2 80 00 00 26 42 00 01 8F BF 00 3C 8F BE 00 38 8F B7 00 34 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_721_0_0 {
	meta:
		name = "__GI_gethostbyname"
		size = 104
		refs = "0000 _gp_disp 000c __GI___h_errno_location 003c __GI_gethostbyname_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF C8 AF BF 00 34 AF BC 00 18 AF A4 00 28 ?? ?? ?? ?? 00 00 00 00 8F BC 00 18 8F A4 00 28 27 A3 00 20 8F 85 ?? ?? 8F 86 ?? ?? 8F 99 ?? ?? AF A3 00 10 AF A2 00 14 24 A5 ?? ?? 24 C6 ?? ?? ?? ?? ?? ?? 24 07 01 CC 8F BF 00 34 8F A2 00 20 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_722_0_0 {
	meta:
		name = "__fpending"
		size = 36
	strings:
		$1 = { 94 83 00 00 30 63 00 40 10 60 00 04 00 00 10 21 8C 83 00 10 8C 82 00 08 00 62 10 23 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_723_0_0 {
	meta:
		name = "clearerr"
		size = 148
		refs = "0000 _gp_disp 0030 _pthread_cleanup_push_defer 0034 __pthread_mutex_unlock 004c __pthread_mutex_lock 006c _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B0 00 28 AF BC 00 10 AF BF 00 34 AF B2 00 30 AF B1 00 2C 8C 91 00 34 16 20 00 0C 00 80 80 21 8F 99 ?? ?? 8F 85 ?? ?? 24 92 00 38 02 40 30 21 ?? ?? ?? ?? 27 A4 00 18 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 96 02 00 00 30 42 FF F3 16 20 00 05 A6 02 00 00 8F 99 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F BF 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_724_1_0 {
	meta:
		name = "cfgetispeed"
		size = 32
	strings:
		$1 = { 8C 82 00 00 04 40 00 04 00 00 00 00 8C 82 00 08 03 E0 00 08 30 42 10 0F 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_724_2_0 {
	meta:
		name = "__GI_cfsetospeed"
		size = 116
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 24 02 EF F0 00 A2 10 24 50 40 00 11 8C 82 00 08 24 A2 EF FF 2C 42 00 0F 54 40 00 0D 8C 82 00 08 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 ?? ?? ?? ?? 00 00 00 00 24 03 00 16 AC 43 00 00 8F BF 00 1C 24 02 FF FF 03 E0 00 08 27 BD 00 20 24 03 EF F0 00 62 10 24 00 A2 28 25 AC 85 00 08 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_724_3_0 {
	meta:
		name = "__GI_cfsetispeed"
		size = 152
		refs = "0000 _gp_disp 0028 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 24 02 EF F0 00 A2 10 24 10 40 00 10 24 A2 EF FF 2C 42 00 0F 54 40 00 14 8C 82 00 00 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 ?? ?? ?? ?? 00 00 00 00 24 03 00 16 AC 43 00 00 8F BF 00 1C 24 02 FF FF 03 E0 00 08 27 BD 00 20 54 A0 00 06 8C 82 00 00 8C 83 00 00 3C 02 80 00 00 62 10 25 10 00 00 08 AC 82 00 00 24 03 EF F0 7C 42 F0 00 AC 82 00 00 8C 82 00 08 00 62 10 24 00 A2 28 25 AC 85 00 08 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_725_0_0 {
	meta:
		name = "getrusage"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F ED 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_726_0_0 {
	meta:
		name = "__GI_sbrk"
		size = 136
		refs = "0000 _gp_disp 0014 __curbrk 0040 __GI_brk"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B0 00 1C 8F 90 ?? ?? AF B1 00 20 AF BC 00 10 AF BF 00 24 8E 02 00 00 10 40 00 05 00 80 88 21 56 20 00 0A 8E 10 00 00 10 00 00 0E 8E 02 00 00 8F 99 ?? ?? ?? ?? ?? ?? 00 00 20 21 04 41 FF F8 8F BC 00 10 10 00 00 07 24 02 FF FF 8F 99 ?? ?? ?? ?? ?? ?? 02 11 20 21 04 40 00 02 24 02 FF FF 02 00 10 21 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_727_0_0 {
	meta:
		name = "llabs"
		size = 32
	strings:
		$1 = { 00 04 37 C3 00 C5 28 26 00 C4 20 26 00 A6 18 23 00 A3 10 2B 00 86 20 23 03 E0 00 08 00 82 10 23 }
	condition:
		$1
}

rule file_729_0_0 {
	meta:
		name = "__GI_localeconv"
		size = 116
		refs = "0000 _gp_disp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 8F 83 ?? ?? 8F 86 ?? ?? 8F 85 ?? ?? 24 42 ?? ?? AC 62 ?? ?? 24 63 ?? ?? 00 60 10 21 24 C6 ?? ?? 24 A5 ?? ?? 24 63 00 04 00 65 20 2B 14 80 FF FD AC 66 00 00 8F 83 ?? ?? 8F 85 ?? ?? 24 06 00 7F 24 63 ?? ?? 24 A5 ?? ?? A0 66 00 00 24 63 00 01 00 A3 20 2B 50 80 FF FD A0 66 00 00 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_730_0_0 {
	meta:
		name = "__GI_vsscanf"
		size = 172
		refs = "0000 _gp_disp 0014 __stdio_init_mutex 0060 __GI_strlen 007c __GI_vfscanf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 88 24 02 FF FE 8F 99 ?? ?? AF A2 00 1C 24 02 00 A1 A7 A2 00 18 24 02 00 01 AF BF 00 74 AF B0 00 70 AF BC 00 10 00 80 80 21 AF A5 00 68 AF A6 00 6C AF A2 00 4C A3 A0 00 1A AF A0 00 44 ?? ?? ?? ?? 27 A4 00 50 8F BC 00 10 AF B0 00 28 AF B0 00 20 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? AF A0 00 38 8F BC 00 10 8F A5 00 68 8F A6 00 6C 8F 99 ?? ?? 02 02 10 21 AF B0 00 34 27 A4 00 18 AF A2 00 24 AF A2 00 2C ?? ?? ?? ?? AF A2 00 30 8F BF 00 74 8F B0 00 70 03 E0 00 08 27 BD 00 78 }
	condition:
		$1
}

rule file_731_0_0 {
	meta:
		name = "gmtime"
		size = 60
		refs = "0000 _gp_disp 000c __time_tm 0010 _time_t2tm"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 86 ?? ?? 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 ?? ?? ?? ?? 00 00 28 21 8F BC 00 10 8F BF 00 1C 27 BD 00 20 03 E0 00 08 8F 82 ?? ?? }
	condition:
		$1
}

rule file_732_0_0 {
	meta:
		name = "fpathconf"
		size = 316
		refs = "0000 _gp_disp 0024 __GI___errno_location 009c __libc_fstatfs 00d8 __GI_fstat"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 38 AF BC 00 10 AF BF 00 C4 AF B1 00 C0 AF B0 00 BC 04 81 00 05 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 12 24 03 00 09 10 A0 00 3B 24 02 00 7F 24 A5 FF FF 2C A2 00 13 10 40 00 08 00 05 28 80 8F 82 ?? ?? 24 42 ?? ?? 00 45 28 21 8C A2 00 00 00 5C 10 21 00 40 00 08 00 00 00 00 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 10 00 00 27 AC 43 00 00 8F 99 ?? ?? ?? ?? ?? ?? AF A4 00 B0 8F BC 00 10 8F A4 00 B0 27 A5 00 18 8F 99 ?? ?? 00 40 80 21 ?? ?? ?? ?? 8C 51 00 00 04 43 00 1E 8F A2 00 40 8E 04 00 00 24 03 00 59 14 83 00 1A 24 02 FF FF AE 11 00 00 10 00 00 17 24 02 00 FF 10 00 00 15 00 00 10 21 8F 99 ?? ?? ?? ?? ?? ?? 27 A5 00 18 04 40 00 0D 8F A3 00 2C 34 02 80 00 30 63 F0 00 10 62 00 05 38 63 60 00 24 02 00 01 24 04 FF FF 10 00 00 08 00 83 10 0B 10 00 00 06 24 02 00 01 10 00 00 04 24 02 00 20 10 00 00 02 24 02 FF FF 24 02 10 00 8F BF 00 C4 8F B1 00 C0 8F B0 00 BC 03 E0 00 08 27 BD 00 C8 }
	condition:
		$1
}

rule file_733_0_0 {
	meta:
		name = "gaih_inet_serv.isra.0"
		size = 312
		refs = "0000 _gp_disp 0020 __GI_getservbyname_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 98 AF BE 00 60 03 A0 F0 21 27 D9 00 30 AF B5 00 54 8F 95 ?? ?? AF D9 00 38 27 D9 00 20 AF B7 00 5C AF B6 00 58 AF B4 00 50 AF B3 00 4C AF B2 00 48 AF B1 00 44 AF B0 00 40 AF BF 00 64 AF BC 00 18 00 80 B8 21 00 A0 88 21 00 C0 B0 21 00 E0 80 21 24 12 04 00 24 B3 00 03 AF D9 00 3C 24 14 00 22 26 42 00 0E 00 02 10 C2 00 02 10 C0 03 A2 E8 23 27 C2 00 30 AF B2 00 10 AF A2 00 14 02 E0 20 21 02 60 28 21 27 C6 00 20 02 A0 C8 21 ?? ?? ?? ?? 27 A7 00 18 14 40 00 06 00 00 00 00 8F C2 00 30 50 40 00 14 24 02 01 08 10 00 00 05 AE 00 00 00 14 54 00 0F 00 12 90 40 10 00 FF EA 26 42 00 0E 82 23 00 00 AE 03 00 04 92 23 00 02 30 63 00 02 50 60 00 02 82 23 00 01 8E C3 00 00 AE 03 00 08 8C 42 00 08 AE 02 00 0C 10 00 00 02 00 00 10 21 24 02 01 08 03 C0 E8 21 8F BF 00 64 8F BE 00 60 8F B7 00 5C 8F B6 00 58 8F B5 00 54 8F B4 00 50 8F B3 00 4C 8F B2 00 48 8F B1 00 44 8F B0 00 40 03 E0 00 08 27 BD 00 68 }
	condition:
		$1
}

rule file_733_1_0 {
	meta:
		name = "gaih_inet"
		size = 2052
		refs = "0000 _gp_disp 014c gaih_inet_serv.isra.0 02ec __GI_inet_pton 036c __GI_gethostbyname2_r 0420 __GI___h_errno_location 0468 __GI_memcpy 058c __GI_inet_ntop 05b0 __GI_strlen 05e0 malloc 0638 __GI_gethostbyaddr_r 0664 __GI___errno_location 0754 __GI_memset 0784 __GI_strcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 28 AF BE 00 D0 AF B7 00 CC AF B6 00 C8 AF B4 00 C0 AF B3 00 BC AF B1 00 B4 AF BF 00 D4 AF B5 00 C4 AF B2 00 B8 AF B0 00 B0 AF BC 00 20 8C C2 00 04 03 A0 F0 21 27 D3 00 6C 00 80 88 21 00 A0 A0 21 00 C0 B8 21 00 E0 B0 21 AF D3 00 88 10 40 00 04 AF C0 00 84 24 04 00 0A 14 44 00 03 00 00 90 21 8E F2 00 00 7E 52 00 C0 8E E4 00 0C AF C0 00 6C 8E E6 00 08 AE 60 00 04 AE 60 00 08 14 80 00 06 AE 60 00 0C 54 C0 00 05 8F 82 ?? ?? 8F 82 ?? ?? 10 00 00 16 24 42 ?? ?? 8F 82 ?? ?? 24 42 ?? ?? 80 45 00 03 50 A0 01 C4 24 02 01 07 10 C0 00 06 00 00 00 00 80 45 00 00 10 C5 00 03 00 00 00 00 10 00 FF F7 24 42 00 07 10 80 00 08 00 00 00 00 90 45 00 02 30 A5 00 02 14 A0 00 04 00 00 00 00 80 45 00 01 54 85 FF EE 24 42 00 07 12 80 00 59 00 00 00 00 90 47 00 02 30 E5 00 01 50 A0 00 03 8E 86 00 04 10 00 01 AE 24 02 01 08 04 C3 00 46 80 49 00 00 80 44 00 03 10 80 00 0E 8F 89 ?? ?? 8F 99 ?? ?? 27 BD FF E8 8E 84 00 00 27 A7 00 20 AF C7 00 88 00 40 28 21 27 39 ?? ?? ?? ?? ?? ?? 26 E6 00 0C 10 40 00 64 8F DC 00 20 10 00 01 9D 03 C0 E8 21 24 50 00 07 27 C3 00 88 26 E8 00 0C 82 02 00 03 10 40 00 2C 8F C2 00 88 92 04 00 02 30 82 00 01 54 40 FF FA 26 10 00 07 8E E2 00 08 50 40 00 05 8E E2 00 0C 82 05 00 00 54 45 FF F4 26 10 00 07 8E E2 00 0C 10 40 00 06 30 84 00 02 54 80 00 05 8E 84 00 00 82 04 00 01 54 44 FF EC 26 10 00 07 8E 84 00 00 27 BD FF E8 27 B5 00 20 01 00 30 21 25 39 ?? ?? AF C3 00 A0 AF C8 00 A4 AF C9 00 A8 02 00 28 21 ?? ?? ?? ?? 02 A0 38 21 8F DC 00 20 8F C3 00 A0 8F C8 00 A4 10 40 00 06 8F C9 00 A8 30 44 01 00 14 80 FF D9 26 10 00 07 10 00 01 70 03 C0 E8 21 AC 75 00 00 02 A0 18 21 10 00 FF D3 26 10 00 07 14 53 00 2F 24 02 01 08 10 00 01 68 03 C0 E8 21 27 BD FF E8 27 A5 00 20 30 E7 00 02 AF C5 00 88 AC A0 00 00 14 E0 00 02 AC A9 00 04 80 44 00 01 AC A4 00 08 10 00 00 22 AC A6 00 0C 54 C0 00 04 80 46 00 00 50 80 00 0E 24 42 00 07 80 46 00 00 27 BD FF E8 27 A5 00 20 AC A6 00 04 90 46 00 02 AF C5 00 88 30 C6 00 02 14 C0 00 02 AC A0 00 00 80 44 00 01 AC A4 00 08 10 00 00 11 AC A0 00 0C 27 C5 00 88 80 44 00 03 10 80 00 0D 00 00 00 00 80 46 00 00 27 BD FF E8 27 A4 00 20 AF A6 00 24 80 46 00 01 AF A0 00 20 AF A0 00 2C AF A6 00 28 24 42 00 07 AC A4 00 00 10 00 FF F2 00 80 28 21 12 20 00 7A 8F 99 ?? ?? 27 BD FF D8 27 B0 00 20 AF D0 00 84 AE 00 00 04 AE 00 00 18 AE 00 00 00 24 04 00 02 02 20 28 21 ?? ?? ?? ?? 26 06 00 08 18 40 00 0A 8F DC 00 20 8E E2 00 04 24 04 FF FD 00 82 10 24 50 40 00 04 24 02 00 02 12 40 01 26 24 02 00 06 24 02 00 02 AE 02 00 04 8E 02 00 04 14 40 00 5D 8F C2 00 84 8E E2 00 00 30 44 00 04 54 80 00 59 8F C2 00 84 8E E4 00 04 24 05 00 02 10 85 00 0A 8F 95 ?? ?? 56 40 00 05 30 42 00 10 10 80 00 07 27 D9 00 7C 10 00 00 4F 8F C2 00 84 10 40 00 4D 8F C2 00 84 8F 95 ?? ?? 27 D9 00 7C 24 10 02 00 AF D9 00 90 27 D3 00 58 27 D4 00 28 24 12 00 22 00 10 80 40 26 02 00 0E 00 02 10 C2 00 02 10 C0 03 A2 E8 23 27 C2 00 7C AF B0 00 10 AF A2 00 14 AF B3 00 18 02 20 20 21 24 05 00 02 02 80 30 21 02 A0 C8 21 ?? ?? ?? ?? 27 A7 00 20 14 52 00 07 8F DC 00 20 8F C4 00 58 24 02 FF FF 50 82 FF ED 00 10 80 40 10 00 00 05 8F D0 00 58 10 40 00 0A 8F C2 00 7C 8F D0 00 58 24 02 FF FF 56 02 00 29 8F C2 00 84 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 9D AC 50 00 00 10 40 00 21 00 00 88 21 27 D0 00 84 24 12 00 02 8F C4 00 7C 00 11 10 80 8C 84 00 10 00 82 20 21 8C 84 00 00 50 80 00 19 8F C2 00 84 8E 04 00 00 14 80 00 06 8F 99 ?? ?? 27 BD FF D8 27 A4 00 20 AE 04 00 00 AF A0 00 38 8E 04 00 00 24 06 00 04 AC 80 00 00 8E 04 00 00 26 31 00 01 AC 92 00 04 8F C5 00 7C 8E 04 00 00 8C A5 00 10 24 84 00 08 00 A2 10 21 ?? ?? ?? ?? 8C 45 00 00 8F DC 00 20 10 00 FF E3 8E 10 00 00 8F C2 00 84 8C 44 00 04 10 80 00 C2 24 02 01 02 10 00 00 23 00 00 00 00 27 BD FF D8 27 A2 00 20 AC 40 00 00 AC 40 00 04 AC 40 00 08 AC 40 00 0C AC 40 00 10 AC 40 00 14 AC 40 00 18 8E E4 00 04 14 80 00 0B AF C2 00 84 27 BD FF D8 27 A4 00 20 AC 44 00 00 AF A0 00 20 AF A0 00 24 AF A0 00 28 AF A0 00 2C AF A0 00 30 AF A0 00 34 AF A0 00 38 8E E4 00 04 24 05 FF FD 00 A4 20 24 14 80 00 08 24 04 00 02 AC 44 00 04 8E E4 00 00 30 84 00 01 14 80 00 03 3C 04 7F 00 24 84 00 01 AC 44 00 08 12 C0 00 98 27 D9 00 58 AF D9 00 94 27 D9 00 80 AF D9 00 98 27 D9 00 7C 8F D0 00 84 00 00 88 21 10 00 00 1A AF D9 00 9C 54 40 00 09 8C 51 00 00 8F 99 ?? ?? 8E 04 00 04 02 40 28 21 27 C6 00 28 ?? ?? ?? ?? 24 07 00 2E 8F DC 00 20 00 40 88 21 12 20 00 45 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F DC 00 20 24 42 00 01 8F D3 00 88 26 19 00 08 24 54 00 30 24 12 00 02 24 15 00 10 AF D9 00 90 16 60 00 3B 8F 99 ?? ?? 8E 10 00 00 12 00 00 79 00 00 10 21 8E E2 00 00 30 42 00 02 10 40 FF F2 00 00 10 21 AF C0 00 80 24 11 02 00 26 12 00 08 00 11 88 40 26 22 00 0E 00 02 10 C2 00 02 10 C0 03 A2 E8 23 8E 06 00 04 27 A2 00 20 27 D9 00 7C AF A2 00 10 AF B9 00 1C 27 C2 00 80 8F 99 ?? ?? 38 C7 00 0A AF A2 00 18 24 05 00 04 24 02 00 10 00 47 28 0A 02 40 20 21 27 C7 00 58 ?? ?? ?? ?? AF B1 00 14 8F DC 00 20 8F 99 ?? ?? ?? ?? ?? ?? 00 40 A0 21 8C 42 00 00 12 82 00 0D 8F DC 00 20 12 80 FF C1 8F C2 00 80 8F D1 00 7C 24 02 FF FF 56 22 FF BD 8F C2 00 80 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 51 00 00 10 00 00 4A 24 02 00 0B 8F C4 00 7C 24 02 FF FF 50 82 FF D6 00 11 88 40 10 00 FF EF 00 00 00 00 10 00 00 42 24 02 01 02 ?? ?? ?? ?? 02 80 20 21 8F DC 00 20 10 40 00 37 AE C2 00 00 8E E4 00 00 8F 99 ?? ?? 8F C5 00 90 AC 44 00 00 8E C2 00 00 24 06 00 04 AC 52 00 04 8E C2 00 00 8E 64 00 04 AC 44 00 08 8E C2 00 00 8E 64 00 08 AC 44 00 0C 8E C2 00 00 AC 55 00 10 8E C2 00 00 24 44 00 20 AC 44 00 14 8E C2 00 00 8C 42 00 14 A4 52 00 00 8E C2 00 00 8C 49 00 14 25 24 00 04 ?? ?? ?? ?? AF C9 00 A8 8F DC 00 20 8F C9 00 A8 8E 62 00 0C 8F 99 ?? ?? 25 24 00 08 A5 22 00 02 00 00 28 21 ?? ?? ?? ?? 24 06 00 08 8F DC 00 20 12 20 00 0A 8E C2 00 00 24 44 00 30 AC 44 00 18 8E C2 00 00 8F 99 ?? ?? 02 20 28 21 ?? ?? ?? ?? 8C 44 00 18 10 00 00 02 8F DC 00 20 AC 40 00 18 8E C2 00 00 AC 40 00 1C 8E C8 00 00 8E 73 00 00 10 00 FF 8A 25 16 00 1C 10 00 00 05 24 02 00 0A 10 00 00 03 00 00 10 21 24 03 01 08 00 66 10 0A 03 C0 E8 21 8F BF 00 D4 8F BE 00 D0 8F B7 00 CC 8F B6 00 C8 8F B5 00 C4 8F B4 00 C0 8F B3 00 BC 8F B2 00 B8 8F B1 00 B4 8F B0 00 B0 03 E0 00 08 27 BD 00 D8 }
	condition:
		$1
}

rule file_733_2_0 {
	meta:
		name = "__GI_freeaddrinfo"
		size = 72
		refs = "0000 _gp_disp 0020 free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 10 80 00 06 8F 99 ?? ?? ?? ?? ?? ?? 8C 90 00 1C 8F BC 00 10 10 00 FF FA 02 00 20 21 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_733_3_0 {
	meta:
		name = "__GI_getaddrinfo"
		size = 852
		refs = "0000 _gp_disp 00a0 __GI_memset 00fc __GI_strtoul 01b4 __GI___errno_location 01e4 __GI_socket 0214 __GI_close 028c __GI_freeaddrinfo"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 80 AF BC 00 10 AF B5 00 6C AF B3 00 64 AF B1 00 5C AF B0 00 58 AF BF 00 7C AF BE 00 78 AF B7 00 74 AF B6 00 70 AF B4 00 68 AF B2 00 60 00 80 80 21 00 A0 88 21 00 C0 A8 21 00 E0 98 21 10 80 00 07 AF A0 00 44 80 83 00 00 24 02 00 2A 14 62 00 03 00 00 00 00 80 82 00 01 00 02 80 0A 12 20 00 06 24 02 00 2A 82 23 00 00 14 62 00 03 00 00 00 00 82 22 00 01 00 02 88 0A 16 00 00 03 00 00 00 00 12 20 00 A4 24 02 FF FE 56 A0 00 0A 8E A2 00 00 8F 99 ?? ?? 27 B2 00 18 02 40 20 21 00 00 28 21 ?? ?? ?? ?? 24 06 00 20 8F BC 00 10 02 40 A8 21 8E A2 00 00 24 03 FB C0 00 43 18 24 54 60 00 95 24 02 FF FF 30 42 00 02 10 40 00 03 00 00 00 00 12 00 00 90 24 02 FF FF 52 20 00 1E AF A0 00 48 82 22 00 00 10 40 00 1B AF A0 00 48 8F 99 ?? ?? AF B1 00 38 02 20 20 21 27 A5 00 40 ?? ?? ?? ?? 24 06 00 0A AF A2 00 3C 8F A2 00 40 80 42 00 00 10 40 00 08 8F BC 00 10 8E A3 00 00 30 63 04 00 14 60 00 7C 24 02 FF FE 24 02 FF FF 10 00 00 07 AF A2 00 3C 8E A2 00 08 14 40 00 05 27 B9 00 38 8E A3 00 0C 10 60 00 73 24 02 FF F8 27 B9 00 38 AF B9 00 48 8F 83 ?? ?? 27 B2 00 44 00 13 90 0A 00 00 F0 21 24 77 ?? ?? 00 00 88 21 00 00 A0 21 8E E2 00 04 10 40 00 53 00 00 00 00 8E A2 00 04 8E E4 00 00 50 44 00 04 8E A2 00 00 54 40 FF F8 26 F7 00 08 8E A2 00 00 30 42 00 20 50 40 00 23 26 94 00 01 8F 99 ?? ?? 30 84 FF FF ?? ?? ?? ?? AF A4 00 50 8C 59 00 00 8F A4 00 50 00 40 48 21 24 02 00 02 8F BC 00 10 AF B9 00 4C 10 82 00 13 24 16 00 01 8F 99 ?? ?? AF A9 00 50 24 05 00 01 ?? ?? ?? ?? 00 00 30 21 8F BC 00 10 04 41 00 05 8F A9 00 50 8D 36 00 00 3A D6 00 18 10 00 00 07 2E D6 00 01 8F 99 ?? ?? AF A9 00 50 ?? ?? ?? ?? 00 40 20 21 8F BC 00 10 8F A9 00 50 8F B9 00 4C 12 C0 00 24 AD 39 00 00 26 94 00 01 13 C0 00 04 8E F9 00 04 8F C2 00 04 50 59 FF CD 26 F7 00 08 8F A5 00 48 02 00 20 21 02 A0 30 21 03 20 F8 09 02 40 38 21 00 40 B0 21 10 40 00 0F 8F BC 00 10 8E A2 00 04 14 40 00 03 32 C2 01 00 14 40 00 13 02 E0 F0 21 8F A4 00 44 10 80 00 03 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 02 FE FF 02 C2 10 24 10 00 00 20 00 02 10 23 12 40 00 06 02 E0 F0 21 8E 42 00 00 10 40 00 03 02 E0 F0 21 10 00 FF FC 24 52 00 1C 10 00 FF AE 26 F7 00 08 10 00 FF AC 02 C0 88 21 12 80 00 12 8F A2 00 44 10 40 00 04 00 00 00 00 AE 62 00 00 10 00 00 0E 00 00 10 21 16 60 00 05 00 00 00 00 16 20 00 05 00 00 10 21 10 00 00 09 8F BF 00 7C 52 20 00 06 24 02 FF FE 24 02 FE FF 02 22 88 24 10 00 00 02 00 11 10 23 24 02 FF FA 8F BF 00 7C 8F BE 00 78 8F B7 00 74 8F B6 00 70 8F B5 00 6C 8F B4 00 68 8F B3 00 64 8F B2 00 60 8F B1 00 5C 8F B0 00 58 03 E0 00 08 27 BD 00 80 }
	condition:
		$1
}

rule file_735_0_0 {
	meta:
		name = "__GI_ftell"
		size = 88
		refs = "0000 _gp_disp 000c __GI_ftello64 0030 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BC 00 10 AF BF 00 1C ?? ?? ?? ?? 00 00 00 00 00 03 27 C3 10 82 00 07 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 4F AC 43 00 00 24 03 FF FF 8F BF 00 1C 00 60 10 21 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_736_0_0 {
	meta:
		name = "__raise"
		size = 72
		refs = "0000 _gp_disp 000c __GI_getpid 0034 __GI_kill"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 ?? ?? ?? ?? 00 80 80 21 8F BC 00 10 8F BF 00 1C 02 00 28 21 8F 99 ?? ?? 8F B0 00 18 00 40 20 21 ?? ?? ?? ?? 27 BD 00 20 }
	condition:
		$1
}

rule file_6_3_2 {
	meta:
		name = "__GI_pthread_exit"
		size = 36
		refs = "0000 _gp_disp 000c __pthread_do_exit"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BC 00 10 AF BF 00 1C ?? ?? ?? ?? 03 A0 28 21 }
	condition:
		$1
}

rule file_737_0_0 {
	meta:
		name = "__GI_tsearch"
		size = 184
		refs = "0000 _gp_disp 0074 malloc"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF BC 00 10 AF B2 00 20 AF B1 00 1C AF B0 00 18 AF BF 00 24 00 80 88 21 00 A0 80 21 10 A0 00 1B 00 C0 90 21 8E 02 00 00 10 40 00 0E 02 40 C8 21 8C 45 00 00 03 20 F8 09 02 20 20 21 14 40 00 03 8F BC 00 10 10 00 00 12 8E 02 00 00 8E 03 00 00 28 42 00 00 24 70 00 04 24 63 00 08 10 00 FF F1 00 62 80 0A 8F 99 ?? ?? ?? ?? ?? ?? 24 04 00 0C 50 40 00 07 00 00 10 21 AE 02 00 00 AC 51 00 00 AC 40 00 08 10 00 00 02 AC 40 00 04 00 00 10 21 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_738_0_0 {
	meta:
		name = "__GI_wcsspn"
		size = 48
	strings:
		$1 = { 00 80 10 21 00 A0 18 21 8C 66 00 00 50 C0 00 06 00 44 10 23 8C 47 00 00 14 C7 FF FB 24 63 00 04 10 00 FF F8 24 42 00 04 03 E0 00 08 00 02 10 83 }
	condition:
		$1
}

rule file_739_0_0 {
	meta:
		name = "__GI___dl_iterate_phdr"
		size = 164
		refs = "0000 _gp_disp 000c _dl_loaded_modules"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 27 BD FF C0 AF B3 00 38 AF B2 00 34 AF B1 00 30 AF BC 00 10 AF BF 00 3C AF B0 00 2C 8C 50 00 00 00 80 90 21 00 A0 98 21 00 00 10 21 27 B1 00 18 12 00 00 11 02 20 20 21 8E 02 00 00 24 05 00 10 AF A2 00 18 8E 02 00 04 02 60 30 21 02 40 C8 21 AF A2 00 1C 8E 02 00 E0 AF A2 00 20 8E 02 00 DC 03 20 F8 09 A7 A2 00 24 14 40 00 04 8F BF 00 3C 10 00 FF EF 8E 10 00 0C 8F BF 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_739_1_0 {
	meta:
		name = "dl_iterate_phdr"
		size = 148
		refs = "0000 _gp_disp 000c _dl_phnum 0034 $LC0 0048 _dl_phdr 0070 __GI___dl_iterate_phdr"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 27 BD FF C8 AF B1 00 30 AF B0 00 2C AF BC 00 10 AF BF 00 34 8C 42 00 00 00 80 88 21 10 40 00 10 00 A0 80 21 8F 83 ?? ?? AF A0 00 18 A7 A2 00 24 24 63 ?? ?? AF A3 00 1C 8F 83 ?? ?? 27 A4 00 18 24 05 00 10 8C 63 00 00 02 00 30 21 02 20 C8 21 03 20 F8 09 AF A3 00 20 14 40 00 05 8F BC 00 10 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 02 00 28 21 8F BF 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_741_0_0 {
	meta:
		name = "__GI_strncpy"
		size = 220
	strings:
		$1 = { 00 80 10 21 24 83 FF FF 2C C4 00 04 54 80 00 23 30 C6 00 03 00 06 20 82 80 A9 00 00 00 A0 40 21 00 60 38 21 11 20 00 15 A0 69 00 01 80 A9 00 01 15 20 00 03 A0 69 00 02 10 00 00 11 24 63 00 02 80 A9 00 02 15 20 00 03 A0 69 00 03 10 00 00 0C 24 63 00 03 81 08 00 03 24 A5 00 04 24 63 00 04 11 00 00 07 A0 E8 00 04 24 84 FF FF 54 80 FF EB 80 A9 00 00 10 00 00 09 30 C6 00 03 24 63 00 01 24 C6 FF FF 00 43 20 23 00 C4 30 21 14 C0 00 0E 24 63 00 01 03 E0 00 08 00 00 00 00 10 C0 00 0D 00 00 00 00 80 A4 00 00 24 63 00 01 24 C6 FF FF 24 A7 00 01 10 C0 FF F7 A0 64 00 00 14 80 FF F9 00 E0 28 21 24 63 00 01 24 C6 FF FF 14 C0 FF FD A0 60 00 00 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_744_0_0 {
	meta:
		name = "__GI_hsearch_r"
		size = 556
		refs = "0000 _gp_disp 000c __GI_strlen 00c0 __GI_strcmp 017c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF B0 AF BC 00 10 AF B7 00 44 AF B5 00 3C AF B3 00 34 AF B2 00 30 AF BF 00 4C AF BE 00 48 AF B6 00 40 AF B4 00 38 AF B1 00 2C AF B0 00 28 AF A4 00 50 AF A5 00 54 00 C0 B8 21 00 E0 98 21 8F B2 00 60 ?? ?? ?? ?? 00 80 A8 21 8F BC 00 10 00 40 18 21 10 60 00 07 24 64 FF FF 02 A4 18 21 80 63 00 00 00 02 11 00 00 62 10 21 10 00 FF F9 00 80 18 21 8E 54 00 04 24 10 00 01 24 11 00 0C 00 54 00 1B 02 80 01 F4 8E 56 00 00 00 00 18 10 00 63 80 0B 72 11 10 02 00 56 88 21 8E 22 00 00 50 40 00 30 02 00 88 21 14 50 00 08 26 9E FF FE 8F 99 ?? ?? 8E 25 00 04 ?? ?? ?? ?? 02 A0 20 21 10 40 00 41 8F BC 00 10 26 9E FF FE 02 1E 00 1B 03 C0 01 F4 8F 99 ?? ?? 02 00 88 21 24 07 00 0C 00 00 10 10 24 5E 00 01 02 9E 30 23 03 D1 18 2B 02 26 10 21 02 3E 88 23 00 43 88 0A 12 30 00 19 72 27 10 02 00 56 18 21 8C 62 00 00 14 50 00 11 02 A0 20 21 8C 65 00 04 AF A3 00 18 AF A6 00 1C AF A7 00 20 03 20 F8 09 AF B9 00 24 8F BC 00 10 8F A3 00 18 8F A6 00 1C 8F A7 00 20 14 40 FF EB 8F B9 00 24 24 63 00 04 AE 63 00 00 10 00 00 27 24 02 00 01 14 40 FF E6 03 D1 18 2B 10 00 00 02 24 02 00 01 24 02 00 01 16 E2 00 1A 8F 99 ?? ?? 8E 42 00 08 54 54 00 06 24 02 00 0C 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 15 24 03 00 0C 72 22 88 02 8F A3 00 50 02 D1 B0 21 AE D0 00 00 8E 42 00 00 00 51 10 21 AC 43 00 04 8F A3 00 54 AC 43 00 08 8E 42 00 08 24 42 00 01 AE 42 00 08 8E 42 00 00 00 51 88 21 26 31 00 04 10 00 FF DF AE 71 00 00 ?? ?? ?? ?? 00 00 00 00 24 03 00 03 AC 43 00 00 AE 60 00 00 00 00 10 21 8F BF 00 4C 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_745_0_0 {
	meta:
		name = "__GI_localtime_r"
		size = 188
		refs = "0000 _gp_disp 0010 _time_tzlock 0014 _pthread_cleanup_push_defer 0020 __pthread_mutex_unlock 004c __pthread_mutex_lock 0064 _time_tzset 007c _time_tzinfo 0080 __time_localtime_tzi 0094 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 8F 86 ?? ?? 8F 99 ?? ?? AF B0 00 28 00 A0 80 21 8F 85 ?? ?? AF B1 00 2C 27 B1 00 18 AF BF 00 34 AF B2 00 30 AF BC 00 10 00 80 90 21 ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8E 44 00 00 3C 02 45 98 8F 99 ?? ?? 24 42 4F 00 ?? ?? ?? ?? 00 82 20 2A 8F BC 00 10 02 40 20 21 8F 86 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 02 00 28 21 8F BC 00 10 02 20 20 21 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 01 8F BF 00 34 02 00 10 21 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_746_0_0 {
	meta:
		name = "fchown"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F FF 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_747_0_0 {
	meta:
		name = "__GI_wcswidth"
		size = 124
	strings:
		$1 = { 00 00 10 21 00 45 18 2B 10 60 00 09 00 02 18 80 00 83 18 21 8C 63 00 00 10 60 00 05 30 66 00 7F 54 66 00 14 24 02 FF FF 10 00 FF F6 24 42 00 01 00 00 10 21 10 A0 00 0F 00 00 00 00 8C 83 00 00 10 60 00 0C 24 86 00 04 24 64 FF E0 2C 84 00 E0 10 80 00 07 24 63 FF 81 2C 63 00 21 14 60 00 04 24 A5 FF FF 24 42 00 01 10 00 FF F2 00 C0 20 21 24 02 FF FF 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_748_0_0 {
	meta:
		name = "__GI_fopen"
		size = 28
		refs = "0000 _gp_disp 000c _stdio_fopen"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 00 00 30 21 ?? ?? ?? ?? 24 07 FF FF }
	condition:
		$1
}

rule file_749_0_0 {
	meta:
		name = "__GI_memmove"
		size = 748
		refs = "0000 _gp_disp 0030 __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 00 85 18 23 00 66 18 2B AF BC 00 10 AF B0 00 18 AF BF 00 1C 00 80 80 21 14 60 00 06 00 C0 38 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 A7 8F BF 00 1C 2C C2 00 10 00 A6 28 21 14 40 00 9B 00 86 18 21 30 66 00 03 00 E6 10 23 10 C0 00 06 24 C6 FF FF 24 A5 FF FF 90 A4 00 00 24 63 FF FF 10 00 FF FA A0 64 00 00 30 AA 00 03 15 40 00 4B 00 02 48 82 31 24 00 07 24 84 FF FF 2C 86 00 07 10 C0 00 27 01 20 50 21 8F 86 ?? ?? 00 04 20 80 24 C6 ?? ?? 00 C4 20 21 8C 84 00 00 00 9C 20 21 00 80 00 08 00 00 00 00 24 A8 FF F8 24 67 FF FC 8C A6 FF FC 10 00 00 30 25 2A 00 06 24 A8 FF F4 24 67 FF F8 8C A4 FF FC 10 00 00 29 25 2A 00 05 24 A8 FF F0 24 67 FF F4 8C A6 FF FC 10 00 00 22 25 2A 00 04 24 A8 FF EC 24 67 FF F0 8C A4 FF FC 10 00 00 1B 25 2A 00 03 24 A8 FF E8 24 67 FF EC 8C A6 FF FC 10 00 00 14 25 2A 00 02 24 A8 FF E4 24 67 FF E8 8C A4 FF FC 10 00 00 0D 25 2A 00 01 24 A8 FF E0 24 67 FF E4 10 00 00 07 8C A6 FF FC 8C A4 FF FC 24 A8 FF DC 24 67 FF E0 25 2A FF FF 8D 06 00 1C AC E4 00 1C 8D 04 00 18 AC E6 00 18 8D 06 00 14 AC E4 00 14 8D 04 00 10 AC E6 00 10 8D 06 00 0C AC E4 00 0C 8D 04 00 08 AC E6 00 08 8D 06 00 04 AC E4 00 04 25 4A FF F8 8D 04 00 00 11 40 00 04 AC E6 00 00 25 08 FF E0 10 00 FF EC 24 E7 FF E0 10 00 00 40 AC E4 FF FC 00 0A 50 C0 24 0B 00 20 24 07 FF FC 31 24 00 03 24 06 00 02 01 6A 58 23 10 86 00 0B 00 A7 38 24 24 06 00 03 10 86 00 0E 24 E6 FF F4 24 06 00 01 10 86 00 10 24 E6 FF F0 24 68 FF F4 8C ED 00 00 10 00 00 16 8C EF FF FC 24 E6 FF F8 24 68 FF FC 8C EE 00 00 8C EC FF FC 10 00 00 1A 25 29 00 02 24 68 FF F8 8C EF 00 00 8C EE FF FC 10 00 00 10 25 29 00 01 8C EC 00 00 8C ED FF FC 24 E6 FF EC 24 68 FF F0 25 29 FF FF 01 6C 60 06 01 4D 20 04 01 84 60 25 8C CF 00 0C AD 0C 00 0C 01 6D 68 06 01 4F 20 04 01 A4 68 25 8C CE 00 08 AD 0D 00 08 01 6F 78 06 01 4E 20 04 01 E4 78 25 8C CC 00 04 AD 0F 00 04 01 6E 70 06 01 4C 20 04 01 C4 70 25 25 29 FF FC 8C CD 00 00 11 20 00 04 AD 0E 00 00 24 C6 FF F0 10 00 FF E8 25 08 FF F0 01 4D 50 04 01 6C 58 06 01 4B 50 25 AD 0A FF FC 24 04 FF FC 00 44 20 24 00 A4 28 23 00 64 18 23 30 47 00 03 10 E0 00 06 24 A5 FF FF 90 A2 00 00 24 63 FF FF 24 E7 FF FF 10 00 FF FA A0 62 00 00 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_750_0_0 {
	meta:
		name = "srandom"
		size = 152
		refs = "0000 _gp_disp 0018 __pthread_mutex_unlock 001c _pthread_cleanup_push_defer 0048 __pthread_mutex_lock 0060 __GI_srandom_r 0074 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B1 00 2C 8F 91 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? AF B0 00 28 27 B0 00 18 AF BF 00 34 26 26 ?? ?? AF B2 00 30 AF BC 00 10 00 80 90 21 ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 24 ?? ?? 8F BC 00 10 02 40 20 21 8F 85 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? 8F BC 00 10 02 00 20 21 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 01 8F BF 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_750_1_0 {
	meta:
		name = "initstate"
		size = 192
		refs = "0000 _gp_disp 001c _pthread_cleanup_push_defer 0024 __pthread_mutex_unlock 0058 __pthread_mutex_lock 0074 __GI_initstate_r 0090 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF B1 00 2C 8F 91 ?? ?? AF B3 00 34 8F 99 ?? ?? 00 A0 98 21 8F 85 ?? ?? AF B0 00 28 27 B0 00 18 AF BF 00 3C AF B4 00 38 AF B2 00 30 AF BC 00 10 00 80 A0 21 00 C0 90 21 02 00 20 21 ?? ?? ?? ?? 26 26 ?? ?? 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 24 ?? ?? 8F BC 00 10 02 40 30 21 02 80 20 21 8F 87 ?? ?? 8F 99 ?? ?? 02 60 28 21 24 E7 ?? ?? ?? ?? ?? ?? 8C F1 00 08 8F BC 00 10 02 00 20 21 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 01 8F BF 00 3C 26 22 FF FC 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_750_2_0 {
	meta:
		name = "setstate"
		size = 172
		refs = "0000 _gp_disp 0018 __pthread_mutex_unlock 001c _pthread_cleanup_push_defer 0048 __pthread_mutex_lock 0060 __GI_setstate_r 007c _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B0 00 28 8F 90 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? AF B1 00 2C 27 B1 00 18 AF BF 00 34 26 06 ?? ?? AF B2 00 30 AF BC 00 10 00 80 90 21 ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 04 ?? ?? 8F BC 00 10 02 40 20 21 8F 85 ?? ?? 8F 99 ?? ?? 24 A5 ?? ?? ?? ?? ?? ?? 8C B0 00 08 8F BC 00 10 28 42 00 00 02 20 20 21 8F 99 ?? ?? 24 05 00 01 26 10 FF FC ?? ?? ?? ?? 00 02 80 0B 8F BF 00 34 02 00 10 21 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_750_3_0 {
	meta:
		name = "__GI_random"
		size = 144
		refs = "0000 _gp_disp 0018 __pthread_mutex_unlock 001c _pthread_cleanup_push_defer 0040 __pthread_mutex_lock 0058 __GI_random_r 006c _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF B1 00 38 8F 91 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? AF B0 00 34 27 B0 00 18 AF BF 00 3C 26 26 ?? ?? AF BC 00 10 ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 24 ?? ?? 8F BC 00 10 27 A5 00 28 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 84 ?? ?? 8F BC 00 10 02 00 20 21 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 01 8F BF 00 3C 8F A2 00 28 8F B1 00 38 8F B0 00 34 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_751_0_0 {
	meta:
		name = "__GI_getpriority"
		size = 100
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 00 00 00 00 0C 10 E0 00 07 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 10 00 00 04 24 10 FF FF 04 40 00 02 24 02 00 14 00 50 80 23 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_753_0_0 {
	meta:
		name = "__GI_mknod"
		size = 88
		refs = "0000 _gp_disp 0030 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 00 E0 30 21 24 02 0F AE 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_754_0_0 {
	meta:
		name = "__add_to_environ"
		size = 576
		refs = "0000 _gp_disp 000c __GI_strchrnul 0064 _pthread_cleanup_push_defer 0068 __pthread_mutex_unlock 0080 __pthread_mutex_lock 0094 __environ 00a0 __GI_strncmp 00f0 _pthread_cleanup_pop_restore 0104 realloc 0138 __GI_memcpy 0168 __GI_strlen 0180 malloc 0198 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF A8 AF BF 00 54 AF BC 00 10 AF B7 00 4C AF B6 00 48 AF B5 00 44 AF B4 00 40 AF B3 00 3C AF B2 00 38 AF B1 00 34 AF B0 00 30 AF BE 00 50 00 A0 A0 21 24 05 00 3D 00 80 88 21 ?? ?? ?? ?? 00 C0 B8 21 8F BC 00 10 27 B5 00 18 02 A0 20 21 8F 90 ?? ?? 8F 99 ?? ?? 8F 85 ?? ?? 26 06 ?? ?? ?? ?? ?? ?? 00 51 90 23 8F BC 00 10 26 04 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 98 21 8F BC 00 10 24 03 00 3D 8F 96 ?? ?? 8E D0 00 00 12 00 00 18 8F 99 ?? ?? 8E 1E 00 00 13 C0 00 15 03 C0 20 21 AF A3 00 2C AF B9 00 28 02 20 28 21 03 20 F8 09 02 40 30 21 8F BC 00 10 8F A3 00 2C 14 40 00 09 8F B9 00 28 03 D2 F0 21 83 C2 00 00 54 43 00 06 26 73 00 01 16 E0 00 1F 00 00 98 21 10 00 00 44 8F 99 ?? ?? 26 73 00 01 10 00 FF EA 26 10 00 04 8F 9E ?? ?? 8F 99 ?? ?? 26 70 00 02 8F D7 ?? ?? 00 10 80 80 02 00 28 21 ?? ?? ?? ?? 02 E0 20 21 00 40 18 21 10 40 00 1C 8F BC 00 10 8E C5 00 00 10 B7 00 07 26 10 FF F8 8F 99 ?? ?? 00 40 20 21 ?? ?? ?? ?? 02 00 30 21 8F BC 00 10 00 40 18 21 00 70 80 21 AE C3 00 00 AF C3 ?? ?? AE 00 00 00 AE 00 00 04 12 80 00 23 8F 99 ?? ?? 02 80 20 21 ?? ?? ?? ?? 26 57 00 01 8F BC 00 10 24 56 00 01 8F 99 ?? ?? ?? ?? ?? ?? 02 D7 20 21 00 40 98 21 14 40 00 08 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 24 13 FF FF 24 03 00 0C 8F BC 00 10 10 00 00 13 AC 43 00 00 8F 99 ?? ?? 02 20 28 21 02 40 30 21 ?? ?? ?? ?? 00 40 20 21 8F BC 00 10 24 02 00 3D 02 72 90 21 8F 99 ?? ?? A2 42 00 00 02 77 20 21 02 80 28 21 ?? ?? ?? ?? 02 C0 30 21 8F BC 00 10 02 60 88 21 AE 11 00 00 00 00 98 21 8F 99 ?? ?? 02 A0 20 21 ?? ?? ?? ?? 24 05 00 01 8F BF 00 54 02 60 10 21 8F BE 00 50 8F B7 00 4C 8F B6 00 48 8F B5 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 58 }
	condition:
		$1
}

rule file_754_2_0 {
	meta:
		name = "__GI_unsetenv"
		size = 348
		refs = "0000 _gp_disp 0044 __GI_strchrnul 0060 __GI___errno_location 0080 _pthread_cleanup_push_defer 0084 __pthread_mutex_unlock 00a0 __pthread_mutex_lock 00b0 __environ 00bc __GI_strncmp 00c0 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF BC 00 10 AF B1 00 2C AF BF 00 44 AF B6 00 40 AF B5 00 3C AF B4 00 38 AF B3 00 34 AF B2 00 30 AF B0 00 28 10 80 00 0A 00 80 88 21 80 82 00 00 10 40 00 07 8F 99 ?? ?? ?? ?? ?? ?? 24 05 00 3D 80 44 00 00 24 03 00 3D 14 83 00 08 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 AC 43 00 00 10 00 00 2F 24 02 FF FF 8F 90 ?? ?? 8F 99 ?? ?? 8F 85 ?? ?? 27 B3 00 18 26 06 ?? ?? 02 60 20 21 ?? ?? ?? ?? 00 51 A0 23 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 04 ?? ?? 8F BC 00 10 8F 82 ?? ?? 8C 50 00 00 16 00 00 07 8F 95 ?? ?? 8F 99 ?? ?? 02 60 20 21 ?? ?? ?? ?? 24 05 00 01 10 00 00 18 00 00 10 21 24 16 00 3D 8E 12 00 00 12 40 FF F7 02 40 20 21 02 20 28 21 02 A0 C8 21 ?? ?? ?? ?? 02 80 30 21 14 40 00 0C 8F BC 00 10 02 54 90 21 82 42 00 00 54 56 FF F4 26 10 00 04 02 00 18 21 8C 62 00 04 24 63 00 04 14 40 FF FD AC 62 FF FC 10 00 FF EE 8E 12 00 00 10 00 FF EB 26 10 00 04 8F BF 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_754_3_0 {
	meta:
		name = "clearenv"
		size = 152
		refs = "0000 _gp_disp 0018 __pthread_mutex_unlock 001c _pthread_cleanup_push_defer 0040 __pthread_mutex_lock 0054 free 006c __environ 0070 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B1 00 30 8F 91 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? AF B0 00 2C 27 B0 00 18 AF BF 00 34 26 26 ?? ?? AF BC 00 10 ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 24 ?? ?? 8F BC 00 10 8F 91 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 8E 24 ?? ?? 8F BC 00 10 02 00 20 21 AE 20 ?? ?? 8F 82 ?? ?? 8F 99 ?? ?? 24 05 00 01 ?? ?? ?? ?? AC 40 00 00 8F BF 00 34 8F B1 00 30 8F B0 00 2C 00 00 10 21 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_754_4_0 {
	meta:
		name = "putenv"
		size = 108
		refs = "0000 _gp_disp 000c __GI_strchr 0050 __add_to_environ 0060 __GI_unsetenv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 24 05 00 3D AF BC 00 10 AF B0 00 18 AF BF 00 1C ?? ?? ?? ?? 00 80 80 21 8F BC 00 10 10 40 00 09 02 00 20 21 8F 99 ?? ?? 8F BF 00 1C 8F B0 00 18 00 00 28 21 24 06 00 01 27 39 ?? ?? ?? ?? ?? ?? 27 BD 00 20 8F BF 00 1C 8F B0 00 18 8F 99 ?? ?? ?? ?? ?? ?? 27 BD 00 20 }
	condition:
		$1
}

rule file_755_0_0 {
	meta:
		name = "__GI_ppoll"
		size = 128
		refs = "0000 _gp_disp 0058 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF BC 00 10 AF BF 00 24 AF B0 00 20 50 C0 00 06 00 00 30 21 8C C2 00 00 AF A2 00 18 8C C2 00 04 27 A6 00 18 AF A2 00 1C 24 02 00 10 27 BD FF E0 AF A2 00 10 24 02 10 CE 00 00 00 0C 27 BD 00 20 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 24 02 00 10 21 8F B0 00 20 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_757_0_0 {
	meta:
		name = "getrlimit64"
		size = 172
		refs = "0000 _gp_disp 000c __GI_getrlimit"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF B0 00 20 AF BC 00 10 AF BF 00 24 00 A0 80 21 ?? ?? ?? ?? 27 A5 00 18 04 40 00 1A 8F A2 00 18 3C 03 7F FF 34 63 FF FF 54 43 00 07 AE 02 00 04 3C 02 7F FF 24 03 FF FF 34 42 FF FF AE 03 00 04 10 00 00 02 AE 02 00 00 AE 00 00 00 8F A2 00 1C 3C 03 7F FF 34 63 FF FF 54 43 00 07 AE 02 00 0C 3C 02 7F FF 24 03 FF FF 34 42 FF FF AE 03 00 0C 10 00 00 02 AE 02 00 08 AE 00 00 08 10 00 00 02 00 00 10 21 24 02 FF FF 8F BF 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_758_0_0 {
	meta:
		name = "__GI_execvp"
		size = 704
		refs = "0000 _gp_disp 004c __GI___errno_location 0060 __GI_strchr 0078 __environ 007c __GI_execve 00dc __GI_memcpy 0104 $LC0 0124 __GI_getenv 0120 $LC1 0144 __GI_strlen 01c0 __GI_strchrnul"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF BE 00 40 AF B0 00 20 AF BF 00 44 AF B7 00 3C AF B6 00 38 AF B5 00 34 AF B4 00 30 AF B3 00 2C AF B2 00 28 AF B1 00 24 AF BC 00 10 80 82 00 00 03 A0 F0 21 14 40 00 06 00 80 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 49 24 03 00 02 8F 99 ?? ?? 00 A0 88 21 ?? ?? ?? ?? 24 05 00 2F 10 40 00 2B 8F DC 00 10 8F 82 ?? ?? 8F 99 ?? ?? 02 00 20 21 8C 46 00 00 ?? ?? ?? ?? 02 20 28 21 8F DC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8C 43 00 00 24 02 00 08 14 62 00 77 8F DC 00 10 00 00 10 21 00 02 30 80 02 26 18 21 8C 63 00 00 14 60 FF FC 24 42 00 01 24 C2 00 16 00 02 10 C2 00 02 10 C0 03 A2 E8 23 8E 22 00 00 8F 99 ?? ?? 27 A4 00 18 26 25 00 04 AF A2 00 10 ?? ?? ?? ?? AF B0 00 14 8F DC 00 10 27 B2 00 10 02 40 28 21 8F 82 ?? ?? 8F 84 ?? ?? 8F 99 ?? ?? 8C 46 00 00 ?? ?? ?? ?? 24 84 ?? ?? 10 00 00 5C 03 C0 E8 21 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 84 ?? ?? 00 40 A8 21 10 40 00 06 8F DC 00 10 80 42 00 00 54 40 00 06 8F 99 ?? ?? 10 00 FF C1 8F 99 ?? ?? 8F 83 ?? ?? 24 75 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 2C 44 0F FF 14 80 00 07 8F DC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 4E 10 00 00 41 AC 43 00 00 27 BD EF F8 24 13 0F FE 8F 99 ?? ?? 02 62 98 23 27 B2 00 10 02 53 90 21 02 00 28 21 02 40 20 21 ?? ?? ?? ?? 24 46 00 01 8F DC 00 10 00 00 80 21 24 17 00 08 8F 94 ?? ?? 8F 99 ?? ?? 02 A0 20 21 ?? ?? ?? ?? 24 05 00 3A 00 40 B0 21 02 A2 10 2B 10 40 00 16 8F DC 00 10 82 C2 FF FF 02 D5 38 23 38 42 00 2F 00 02 10 2B 00 E2 38 21 02 67 10 2B 54 40 00 1D 82 C2 00 00 8F 99 ?? ?? 02 47 80 23 00 E0 30 21 AF C7 00 18 02 00 20 21 ?? ?? ?? ?? 02 A0 28 21 8F C7 00 18 24 02 00 2F 8F DC 00 10 02 07 38 21 10 00 00 02 A0 E2 FF FF 02 40 80 21 8F 99 ?? ?? 8E 86 00 00 02 00 20 21 ?? ?? ?? ?? 02 20 28 21 8F DC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8C 42 00 00 10 57 FF 93 8F DC 00 10 24 10 00 01 82 C2 00 00 14 40 FF D3 26 D5 00 01 12 00 FF BE 8F 99 ?? ?? 10 00 00 02 03 C0 E8 21 03 C0 E8 21 8F BF 00 44 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 24 02 FF FF 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_759_0_0 {
	meta:
		name = "__GI_stpcpy"
		size = 32
	strings:
		$1 = { 80 A3 00 00 00 80 10 21 24 A5 00 01 24 84 00 01 14 60 FF FB A0 43 00 00 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_760_0_0 {
	meta:
		name = "__GI___res_query"
		size = 304
		refs = "0000 _gp_disp 0044 __GI_memset 0048 __GI___h_errno_location 0088 __dns_lookup 00c8 free 00e0 __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A0 AF BC 00 10 AF B1 00 4C AF B0 00 48 AF BF 00 5C AF B4 00 58 AF B3 00 54 AF B2 00 50 00 80 80 21 8F B1 00 70 10 80 00 04 AF A0 00 40 24 02 00 01 10 A2 00 07 8F 99 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 10 FF FF 24 03 00 03 10 00 00 2C AC 43 00 00 27 B3 00 18 00 C0 90 21 02 60 20 21 00 00 28 21 24 06 00 28 ?? ?? ?? ?? 00 E0 A0 21 8F BC 00 10 02 00 20 21 02 40 28 21 8F 99 ?? ?? 27 A6 00 40 ?? ?? ?? ?? 02 60 38 21 00 40 80 21 04 41 00 0A 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 24 10 FF FF 8C 43 00 00 14 60 00 16 8F BF 00 5C 24 03 00 02 10 00 00 12 AC 43 00 00 8F 99 ?? ?? ?? ?? ?? ?? 8F A4 00 18 8F A2 00 1C 14 52 00 09 8F BC 00 10 8F 99 ?? ?? 02 30 10 2A 8F A5 00 40 02 22 80 0B 02 80 20 21 ?? ?? ?? ?? 02 00 30 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 8F A4 00 40 8F BF 00 5C 02 00 10 21 8F B4 00 58 8F B3 00 54 8F B2 00 50 8F B1 00 4C 8F B0 00 48 03 E0 00 08 27 BD 00 60 }
	condition:
		$1
}

rule file_760_1_0 {
	meta:
		name = "__GI___res_querydomain"
		size = 396
		refs = "0000 _gp_disp 0044 __GI_strlen 0048 __GI___h_errno_location 00c4 __GI_strncpy 011c __GI_snprintf 0118 $LC0 0148 __GI___res_query"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FB B8 AF BC 00 18 AF B3 04 34 AF B0 04 28 AF BF 04 44 AF B6 04 40 AF B5 04 3C AF B4 04 38 AF B2 04 30 AF B1 04 2C 00 80 80 21 10 80 00 03 8F B3 04 58 16 60 00 06 8F 92 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 10 24 03 FF FF 00 A0 88 21 00 C0 A8 21 00 E0 A0 21 14 A0 00 20 02 40 C8 21 ?? ?? ?? ?? 00 00 00 00 24 43 00 01 2C 63 04 02 14 60 00 08 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 03 AC 43 00 00 10 00 00 31 24 02 FF FF 50 40 00 28 8F A2 04 5C 24 52 FF FF 02 12 10 21 80 43 00 00 24 02 00 2E 14 62 00 22 8F A2 04 5C 8F 99 ?? ?? 27 B1 00 20 02 40 30 21 02 20 20 21 02 00 28 21 ?? ?? ?? ?? 02 32 90 21 8F BC 00 18 10 00 00 16 A2 40 00 00 ?? ?? ?? ?? 00 00 00 00 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 00 40 B0 21 02 C2 10 21 24 56 00 02 2E D6 04 02 12 C0 FF DD 8F BC 00 18 8F 86 ?? ?? 8F 99 ?? ?? AF B1 00 10 27 B1 00 20 02 20 20 21 24 05 04 01 24 C6 ?? ?? ?? ?? ?? ?? 02 00 38 21 8F BC 00 18 02 20 80 21 8F A2 04 5C 8F 99 ?? ?? 02 00 20 21 AF A2 00 10 02 A0 28 21 02 80 30 21 ?? ?? ?? ?? 02 60 38 21 8F BF 04 44 8F B6 04 40 8F B5 04 3C 8F B4 04 38 8F B3 04 34 8F B2 04 30 8F B1 04 2C 8F B0 04 28 03 E0 00 08 27 BD 04 48 }
	condition:
		$1
}

rule file_760_2_0 {
	meta:
		name = "__res_search"
		size = 804
		refs = "0000 _gp_disp 0050 __GI___h_errno_location 0068 _res 006c __GI___res_init 0078 __pthread_mutex_unlock 007c __resolv_lock 0080 _pthread_cleanup_push_defer 0094 __pthread_mutex_lock 00ac _pthread_cleanup_pop_restore 00e0 __GI___errno_location 0168 __GI___res_querydomain"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 90 AF BC 00 18 AF B0 00 48 AF BF 00 6C AF BE 00 68 AF B7 00 64 AF B6 00 60 AF B5 00 5C AF B4 00 58 AF B3 00 54 AF B2 00 50 AF B1 00 4C 00 80 80 21 10 80 00 03 AF A6 00 78 14 E0 00 07 00 E0 88 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 FF FF 10 00 00 9E AC 43 00 00 8F 97 ?? ?? 8F 93 ?? ?? 00 A0 A0 21 27 B6 00 20 8F 85 ?? ?? 8F 86 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 02 C0 20 21 8F BC 00 18 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 18 8E F2 00 08 02 C0 20 21 8F 99 ?? ?? 24 05 00 01 ?? ?? ?? ?? 92 FE 01 59 8F BC 00 18 32 42 00 01 14 40 00 06 8F 95 ?? ?? 02 60 C8 21 ?? ?? ?? ?? 00 00 00 00 10 00 FF E7 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 18 AC 40 00 00 8F 99 ?? ?? ?? ?? ?? ?? 00 40 B0 21 00 40 98 21 24 02 00 01 8F BC 00 18 00 00 40 21 AE 62 00 00 02 00 10 21 80 44 00 00 10 80 00 05 38 84 00 2E 2C 84 00 01 01 04 40 21 10 00 FF FA 24 42 00 01 02 02 20 2B 10 80 00 04 00 00 B8 21 80 57 FF FF 3A F7 00 2E 2E F7 00 01 01 1E 10 2B 14 40 00 10 24 1E FF FF 8F B9 00 80 8F A7 00 78 AF A8 00 40 AF B9 00 14 8F 99 ?? ?? AF B1 00 10 02 00 20 21 00 00 28 21 ?? ?? ?? ?? 02 80 30 21 8F BC 00 18 1C 40 00 5B 8F A8 00 40 8E 7E 00 00 36 F7 00 08 11 00 00 05 32 42 00 80 32 E2 00 01 14 40 00 37 32 E2 00 08 32 42 02 00 10 40 00 34 32 E2 00 08 8F 99 ?? ?? 00 00 40 21 26 B5 00 3C 24 0B 00 92 24 0A 00 02 24 0C 00 04 32 52 02 00 8E A5 00 00 10 A0 00 2A 32 E2 00 08 15 00 00 27 8F A2 00 80 8F A7 00 78 AF A8 00 40 AF AA 00 38 AF AB 00 34 AF AC 00 3C AF B9 00 30 AF B1 00 10 AF A2 00 14 02 00 20 21 03 20 F8 09 02 80 30 21 8F BC 00 18 8F A8 00 40 8F AA 00 38 8F AB 00 34 8F AC 00 3C 1C 40 00 33 8F B9 00 30 8E C2 00 00 54 4B 00 03 8E 62 00 00 10 00 00 27 24 02 00 02 50 4A 00 06 8E 22 00 00 50 4C 00 08 36 F7 00 02 38 48 00 01 10 00 00 05 00 08 40 2B 30 42 00 0F 54 4A 00 02 24 08 00 01 36 F7 00 04 24 02 00 01 00 52 40 0A 10 00 FF D6 26 B5 00 04 32 E2 00 08 10 40 00 05 24 02 FF FF 53 C2 00 10 32 E2 00 02 10 00 00 12 AE 7E 00 00 8F B9 00 80 8F A7 00 78 AF B1 00 10 AF B9 00 14 8F 99 ?? ?? 02 00 20 21 00 00 28 21 ?? ?? ?? ?? 02 80 30 21 1C 40 00 0E 8F BF 00 6C 10 00 FF F0 24 02 FF FF 10 40 00 05 32 F7 00 04 24 02 00 04 AE 62 00 00 10 00 00 05 24 02 FF FF 12 E0 00 03 24 02 FF FF 24 04 00 02 AE 64 00 00 8F BF 00 6C 8F BE 00 68 8F B7 00 64 8F B6 00 60 8F B5 00 5C 8F B4 00 58 8F B3 00 54 8F B2 00 50 8F B1 00 4C 8F B0 00 48 03 E0 00 08 27 BD 00 70 }
	condition:
		$1
}

rule file_761_0_0 {
	meta:
		name = "flock"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 2F 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_763_0_0 {
	meta:
		name = "res_sync_func"
		size = 164
		refs = "0000 _gp_disp 000c __nameserver 0030 __local_nameserver 0038 _res 003c __nameservers 006c __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 27 BD FF D8 AF B1 00 1C AF BC 00 10 AF BF 00 24 AF B2 00 20 AF B0 00 18 8C 43 00 00 00 40 88 21 8F 82 ?? ?? 10 62 00 15 8F 84 ?? ?? 8F 82 ?? ?? 90 83 01 58 8C 45 00 00 00 65 28 2B 10 A0 00 02 00 80 90 21 AC 43 00 00 8C 50 00 00 26 10 FF FF 06 00 00 0A 00 10 19 00 8E 24 00 00 8F 99 ?? ?? 02 43 28 21 00 83 20 21 24 A5 00 0C ?? ?? ?? ?? 24 06 00 10 10 00 FF F5 8F BC 00 10 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_763_1_0 {
	meta:
		name = "__GI___res_init"
		size = 460
		refs = "0000 _gp_disp 0010 __pthread_mutex_unlock 0014 __resolv_lock 0018 _pthread_cleanup_push_defer 0054 __pthread_mutex_lock 0064 __close_nameservers 0074 __open_nameservers 0090 _res 0094 __res_sync 0098 __GI_memset 00b8 __GI_random 00d8 __searchdomains 00dc __searchdomain 0124 __nameservers 0128 __nameserver 0140 _pthread_cleanup_pop_restore 0168 __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 8F 85 ?? ?? 8F 86 ?? ?? 8F 99 ?? ?? AF B3 00 34 27 B3 00 18 AF BF 00 44 AF BC 00 10 AF B1 00 2C AF B0 00 28 AF B6 00 40 AF B5 00 3C AF B4 00 38 AF B2 00 30 ?? ?? ?? ?? 02 60 20 21 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 11 00 01 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 00 00 28 21 24 06 01 B4 8F 83 ?? ?? 8F 90 ?? ?? 8F 82 ?? ?? 8F 99 ?? ?? 24 63 ?? ?? AC 43 00 00 ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 24 02 00 05 AE 02 00 00 8F 99 ?? ?? 24 02 00 04 AE 11 00 08 ?? ?? ?? ?? AE 02 00 04 8F BC 00 10 A6 02 01 5E 24 03 00 07 8F 82 ?? ?? 8F 85 ?? ?? A2 11 01 59 8C 42 00 00 2C 44 00 08 00 44 18 0B 00 00 10 21 00 43 20 2A 10 80 00 0A 00 02 20 80 8C A6 00 00 00 C4 20 21 8C 86 00 00 24 44 00 0E 00 04 20 80 02 04 20 21 AC 86 00 04 10 00 FF F5 24 42 00 01 8F 94 ?? ?? 8F 95 ?? ?? 00 00 88 21 00 00 90 21 24 16 00 02 2E 22 00 03 10 40 00 14 8F 99 ?? ?? 8E 82 00 00 02 42 10 2B 10 40 00 10 00 12 29 00 8E A2 00 00 00 45 28 21 94 A2 00 00 54 56 FF F5 26 52 00 01 8F 99 ?? ?? 00 11 21 00 02 04 20 21 24 84 00 0C ?? ?? ?? ?? 24 06 00 10 8F BC 00 10 26 31 00 01 10 00 FF EB 26 52 00 01 A2 11 01 58 02 60 20 21 ?? ?? ?? ?? 24 05 00 01 8F BF 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 00 00 10 21 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_764_0_0 {
	meta:
		name = "___path_search"
		size = 368
		refs = "0000 _gp_disp 004c __GI_strlen 006c $LC0 0084 __GI_stat 0090 $LC1 00b0 __GI___errno_location 012c __GI_sprintf 010c $LC2"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 30 AF BC 00 18 AF B4 00 C8 AF B3 00 C4 AF B2 00 C0 AF B0 00 B8 AF BF 00 CC AF B1 00 BC 00 80 98 21 00 A0 A0 21 00 C0 90 21 10 E0 00 0C 00 E0 80 21 80 E2 00 00 50 40 00 0A 8F 90 ?? ?? 8F 99 ?? ?? 00 E0 20 21 ?? ?? ?? ?? 24 11 00 05 2C 43 00 06 8F BC 00 18 10 00 00 04 00 43 88 0B 8F 90 ?? ?? 24 11 00 04 26 10 ?? ?? 16 40 00 13 8F 99 ?? ?? 8F 92 ?? ?? 8F 99 ?? ?? 27 A5 00 20 ?? ?? ?? ?? 26 44 ?? ?? 14 40 00 06 8F BC 00 18 8F A2 00 34 30 42 F0 00 38 42 40 00 10 40 00 06 26 52 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 18 24 03 00 02 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 8F BC 00 18 24 04 00 2F 2C 43 00 02 14 60 00 07 24 43 FF FF 02 43 28 21 80 A5 00 00 54 A4 00 04 26 23 00 08 10 00 FF F8 00 60 10 21 26 23 00 08 00 62 18 21 02 83 A0 2B 12 80 00 08 8F 85 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 AC 43 00 00 10 00 00 0A 24 02 FF FF 8F 99 ?? ?? AF B1 00 10 AF B0 00 14 02 60 20 21 24 A5 ?? ?? 00 40 30 21 ?? ?? ?? ?? 02 40 38 21 00 00 10 21 8F BF 00 CC 8F B4 00 C8 8F B3 00 C4 8F B2 00 C0 8F B1 00 BC 8F B0 00 B8 03 E0 00 08 27 BD 00 D0 }
	condition:
		$1
}

rule file_764_1_0 {
	meta:
		name = "__gen_tempname"
		size = 944
		refs = "0000 _gp_disp 000c __GI___errno_location 0058 __GI_strlen 0080 __GI_strcmp 007c $LC3 00a8 $LC4 00ac $LC5 00c0 __GI_open 00fc __GI_gettimeofday 0140 __GI_getpid 01c0 __GI_read 01e4 __GI_close 02a8 __GI_open64 02d4 __GI_stat 0334 __GI_mkdir"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF 00 AF BC 00 10 AF BF 00 FC AF B4 00 E8 AF B2 00 E0 AF B1 00 DC AF B0 00 D8 AF BE 00 F8 AF B7 00 F4 AF B6 00 F0 AF B5 00 EC AF B3 00 E4 00 80 88 21 ?? ?? ?? ?? 00 A0 90 21 8F BC 00 10 8C 43 00 00 02 20 20 21 8F 99 ?? ?? AF A3 00 B8 ?? ?? ?? ?? 00 40 80 21 24 54 FF FA 2C 42 00 06 8F BC 00 10 14 40 00 09 02 34 A0 21 8F 85 ?? ?? 8F 99 ?? ?? 02 80 20 21 ?? ?? ?? ?? 24 A5 ?? ?? 00 00 98 21 10 40 00 04 8F BC 00 10 24 02 00 16 10 00 00 B6 AE 02 00 00 8F 97 ?? ?? 8F 9E ?? ?? 8F 95 ?? ?? 26 F7 ?? ?? 27 DE ?? ?? 26 B5 ?? ?? 8F 96 ?? ?? 02 E0 20 21 02 C0 C8 21 ?? ?? ?? ?? 00 00 28 21 00 40 18 21 04 41 00 39 8F BC 00 10 03 C0 20 21 02 C0 C8 21 ?? ?? ?? ?? 24 05 00 80 00 40 18 21 04 41 00 32 8F BC 00 10 8F 99 ?? ?? 27 A8 00 18 01 00 20 21 AF A8 00 C8 ?? ?? ?? ?? 00 00 28 21 8F A7 00 1C 8F BC 00 10 00 07 17 C3 8F 83 ?? ?? 00 07 24 02 00 02 14 00 00 82 10 25 8F A4 00 18 8C 69 ?? ?? 8C 65 ?? ?? 00 04 57 C3 8F 99 ?? ?? 00 07 3C 00 00 4A 50 26 00 E4 38 26 AF A3 00 D0 AF A5 00 CC AF A7 00 C4 AF A9 00 BC ?? ?? ?? ?? AF AA 00 C0 8F A7 00 C4 8F AA 00 C0 8F A5 00 CC 8F A9 00 BC 00 02 37 C3 00 E2 38 26 8F A3 00 D0 01 46 50 26 00 E5 28 21 01 49 48 21 00 A7 38 2B 00 E9 30 21 3C 0B 04 21 AC 66 ?? ?? AC 65 ?? ?? 8F BC 00 10 00 00 18 21 24 02 00 3E 25 6B 08 42 24 09 00 06 10 00 00 13 8F A8 00 C8 8F 99 ?? ?? 00 60 20 21 27 A5 00 B0 24 06 00 06 ?? ?? ?? ?? AF A3 00 D0 8F BC 00 10 8F A3 00 D0 AF A2 00 CC 8F 99 ?? ?? ?? ?? ?? ?? 00 60 20 21 8F A5 00 CC 24 02 00 06 10 A2 00 19 8F BC 00 10 10 00 FF BF 8F 99 ?? ?? 00 C2 00 1B 00 40 01 F4 00 00 38 10 00 07 50 80 00 00 30 12 00 A2 00 1B 00 40 01 F4 00 00 20 10 01 44 20 21 70 EB 00 00 00 00 38 12 00 82 00 1B 00 40 01 F4 00 00 50 10 01 55 20 21 90 84 00 00 00 00 28 12 00 E5 28 21 01 03 38 21 24 63 00 01 14 69 FF EB A0 E4 00 98 00 00 10 21 24 05 00 06 27 A6 00 18 24 03 00 3E 10 45 00 0B 00 C2 20 21 90 84 00 98 02 82 38 21 24 42 00 01 00 83 00 1B 00 60 01 F4 00 00 40 10 02 A8 20 21 90 84 00 00 10 00 FF F5 A0 E4 00 00 24 02 00 01 12 42 00 1C 8F 99 ?? ?? 2A 42 00 02 10 40 00 05 24 03 00 02 12 40 00 13 02 20 20 21 10 00 00 27 8E 02 00 00 12 43 00 1A 24 02 00 03 16 42 00 22 8F 99 ?? ?? AF A3 00 D0 02 20 20 21 ?? ?? ?? ?? 27 A5 00 18 04 41 00 06 8F A3 00 D0 8E 02 00 00 14 43 00 21 00 00 10 21 10 00 00 15 8F A3 00 B8 02 20 20 21 24 05 05 02 24 06 01 80 10 00 00 04 02 C0 C8 21 02 20 20 21 24 05 05 02 24 06 01 80 03 20 F8 09 00 00 00 00 10 00 00 06 8F BC 00 10 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 24 05 01 C0 8F BC 00 10 04 42 00 05 8E 02 00 00 8F A3 00 B8 10 00 00 0A AE 03 00 00 8E 02 00 00 24 03 00 11 14 43 00 05 3C 03 00 03 26 73 00 01 34 63 A2 F8 16 63 FF 53 8F 96 ?? ?? 24 02 FF FF 8F BF 00 FC 8F BE 00 F8 8F B7 00 F4 8F B6 00 F0 8F B5 00 EC 8F B4 00 E8 8F B3 00 E4 8F B2 00 E0 8F B1 00 DC 8F B0 00 D8 03 E0 00 08 27 BD 01 00 }
	condition:
		$1
}

rule file_765_0_0 {
	meta:
		name = "__GI_utime"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F BE 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_766_0_0 {
	meta:
		name = "__GI___longjmp"
		size = 80
	strings:
		$1 = { 8C 9C 00 2C 8C 90 00 08 8C 91 00 0C 8C 92 00 10 8C 93 00 14 8C 94 00 18 8C 95 00 1C 8C 96 00 20 8C 97 00 24 8C 99 00 00 8C 9D 00 04 14 A0 00 03 8C 9E 00 28 10 00 00 02 24 02 00 01 00 A0 10 21 03 20 00 08 00 00 00 00 10 00 FF FF 00 00 00 00 }
	condition:
		$1
}

rule file_767_0_0 {
	meta:
		name = "memalign"
		size = 604
		refs = "0000 _gp_disp 0054 malloc 007c _pthread_cleanup_push_defer 009c __pthread_mutex_unlock 00a0 __malloc_lock 00b8 __pthread_mutex_lock 00d0 __GI___errno_location 019c free 0228 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 2C 82 00 09 AF BC 00 10 AF B1 00 2C AF B0 00 28 AF BF 00 3C AF B4 00 38 AF B3 00 34 AF B2 00 30 00 80 80 21 10 40 00 0B 00 A0 88 21 8F BF 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 8F 99 ?? ?? 00 A0 20 21 ?? ?? ?? ?? 27 BD 00 40 24 02 00 10 2C 83 00 10 00 43 80 0B 26 02 FF FF 00 50 10 24 10 40 00 08 8F 99 ?? ?? 24 02 00 10 00 50 18 2B 50 60 00 03 00 40 80 21 10 00 FF FC 00 02 10 40 8F 99 ?? ?? 8F 85 ?? ?? 8F 86 ?? ?? 27 B4 00 18 ?? ?? ?? ?? 02 80 20 21 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 2E 22 FF E0 14 40 00 08 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 0C AC 43 00 00 10 00 00 55 00 00 10 21 26 31 00 0B 2E 22 00 10 14 40 00 03 24 13 00 10 24 13 FF F8 02 33 98 24 8F 99 ?? ?? 26 04 00 10 ?? ?? ?? ?? 00 93 20 21 10 40 00 43 8F BC 00 10 00 50 00 1B 02 00 01 F4 00 00 18 10 10 60 00 27 24 52 FF F8 26 11 FF FF 00 10 18 23 00 51 88 21 02 23 88 24 26 31 FF F8 02 32 18 23 2C 63 00 10 70 70 20 02 24 03 FF FC 00 91 88 21 8C 44 FF FC 02 32 90 23 00 83 18 24 30 84 00 02 10 80 00 08 00 72 18 23 8C 42 FF F8 34 63 00 02 AE 23 00 04 02 42 90 21 AE 32 00 00 10 00 00 28 26 31 00 08 34 64 00 01 AE 24 00 04 02 23 18 21 8C 64 00 04 8F 99 ?? ?? 34 84 00 01 AC 64 00 04 8C 43 FF FC 00 40 20 21 30 63 00 01 02 43 90 25 ?? ?? ?? ?? AC 52 FF FC 8F BC 00 10 02 20 90 21 8E 42 00 04 30 43 00 02 14 60 00 15 26 51 00 08 24 03 FF FC 00 43 10 24 26 63 00 10 00 62 18 2B 10 60 00 0F 00 53 10 23 02 53 20 21 34 42 00 01 AC 82 00 04 8E 42 00 04 8F 99 ?? ?? 24 84 00 08 30 42 00 01 02 62 98 25 ?? ?? ?? ?? AE 53 00 04 8F BC 00 10 10 00 00 02 26 51 00 08 00 00 88 21 8F 99 ?? ?? 02 80 20 21 ?? ?? ?? ?? 24 05 00 01 02 20 10 21 8F BF 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_768_0_0 {
	meta:
		name = "swab"
		size = 60
	strings:
		$1 = { 00 06 30 43 00 06 18 40 00 83 18 21 00 83 10 2B 10 40 00 08 24 A5 00 02 94 82 00 00 24 84 00 02 00 02 32 00 00 02 12 02 00 C2 10 25 10 00 FF F7 A4 A2 FF FE 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_770_0_0 {
	meta:
		name = "__GI___glibc_strerror_r"
		size = 60
		refs = "0000 _gp_disp 000c __GI___xpg_strerror_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF B0 00 18 AF BC 00 10 ?? ?? ?? ?? 00 A0 80 21 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_772_0_0 {
	meta:
		name = "__GI_recvmsg"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 51 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_773_0_0 {
	meta:
		name = "tdestroy_recurse"
		size = 136
		refs = "0000 _gp_disp 0038 tdestroy_recurse 0078 free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B1 00 20 AF B0 00 1C AF BC 00 10 AF BF 00 24 00 80 80 21 8C 84 00 04 10 80 00 06 00 A0 88 21 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8E 04 00 08 10 80 00 04 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 02 20 28 21 02 20 C8 21 03 20 F8 09 8E 04 00 00 8F BC 00 10 8F BF 00 24 8F B1 00 20 02 00 20 21 8F 99 ?? ?? 8F B0 00 1C ?? ?? ?? ?? 27 BD 00 28 }
	condition:
		$1
}

rule file_773_1_0 {
	meta:
		name = "__GI_tdestroy"
		size = 40
		refs = "0000 _gp_disp 0018 tdestroy_recurse"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 10 80 00 04 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 00 00 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_774_0_0 {
	meta:
		name = "_stdlib_strto_ll"
		size = 728
		refs = "0000 _gp_disp 0018 __GI___ctype_b 0100 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B1 00 24 00 C0 88 21 8F 86 ?? ?? AF B5 00 34 AF B4 00 30 AF B0 00 20 AF BC 00 10 AF BF 00 44 AF BE 00 40 AF B7 00 3C AF B6 00 38 AF B3 00 2C AF B2 00 28 00 A0 A0 21 00 E0 A8 21 00 80 80 21 82 02 00 00 8C C5 00 00 00 02 18 40 00 A3 18 21 94 63 00 00 30 63 00 20 10 60 00 03 24 03 00 2B 10 00 FF F7 26 10 00 01 10 43 00 05 24 03 00 2D 54 43 00 05 00 00 98 21 10 00 00 02 24 13 00 01 00 00 98 21 26 10 00 01 24 02 FF EF 02 22 10 24 14 40 00 14 26 22 FF FE 82 03 00 00 24 02 00 30 50 62 00 03 82 05 00 01 10 00 00 0A 26 22 00 0A 24 03 00 78 26 04 00 01 34 A5 00 20 14 A3 00 04 26 22 00 08 26 10 00 02 10 00 00 02 00 02 10 40 00 80 80 21 24 11 00 10 28 43 00 11 00 43 88 0B 26 22 FF FE 2C 42 00 23 10 40 00 4F 00 00 18 21 8F 99 ?? ?? 00 00 10 21 00 00 18 21 3C 1E 04 00 00 11 B7 C3 3C 12 01 00 24 17 00 22 82 05 00 00 24 A6 FF D0 30 C6 00 FF 2C C8 00 0A 55 00 00 09 00 D1 28 2A 34 A5 00 20 30 A5 00 FF 2C A8 00 61 15 00 00 03 24 06 00 28 24 A6 FF A9 30 C6 00 FF 00 D1 28 2A 10 A0 00 38 00 00 00 00 00 5E 20 2B 10 80 00 0D 26 10 00 01 02 C3 00 18 70 51 00 00 00 00 10 12 00 71 00 19 00 00 28 12 00 C5 18 21 00 66 30 2B 00 00 20 10 00 44 10 21 00 C2 10 21 10 00 FF E2 02 00 20 21 30 64 00 FF 70 91 28 02 00 03 22 02 00 02 1A 02 00 A6 30 21 00 02 2E 00 00 A4 20 25 02 C4 00 18 70 71 00 00 00 06 1A 02 00 00 10 12 00 91 00 19 00 00 28 12 00 65 40 21 01 03 18 2B 00 00 20 10 00 44 10 21 00 40 20 21 00 62 10 21 00 52 10 2B 10 40 00 0A 00 04 42 00 00 05 16 02 00 05 1A 00 00 48 40 25 00 C3 18 21 00 06 17 C3 00 48 40 21 00 66 30 2B 10 00 FF E0 00 C8 10 21 03 20 F8 09 AF B9 00 18 8F BC 00 10 AC 57 00 00 02 75 98 24 24 02 FF FF 24 03 FF FF 10 00 FF D7 8F B9 00 18 56 80 00 01 AE 84 00 00 52 60 00 04 3C 10 7F FF 3C 10 80 00 10 00 00 03 00 00 88 21 36 10 FF FF 24 11 FF FF 12 A0 00 0D 02 02 20 2B 14 80 00 05 8F 99 ?? ?? 14 50 00 09 02 23 20 2B 10 80 00 07 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 24 03 00 22 AC 43 00 00 02 00 10 21 02 20 18 21 12 60 00 05 8F BF 00 44 00 03 18 23 00 03 20 2B 00 02 10 23 00 44 10 23 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_775_0_0 {
	meta:
		name = "__stdio_WRITE"
		size = 280
		refs = "0000 _gp_disp 0014 __GI_write"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B4 00 2C 8F 94 ?? ?? AF B5 00 30 3C 15 7F FF AF B3 00 28 AF B2 00 24 AF B1 00 20 AF B0 00 1C AF BC 00 10 AF BF 00 34 00 80 88 21 00 A0 90 21 00 C0 98 21 00 C0 80 21 36 B5 FF FF 12 00 00 28 2A 06 00 00 02 A0 10 21 8E 24 00 04 02 06 10 0A 00 40 30 21 02 80 C8 21 ?? ?? ?? ?? 02 40 28 21 04 42 00 04 96 22 00 00 02 02 80 23 10 00 FF F3 02 42 90 21 8E 23 00 08 34 42 00 08 A6 22 00 00 8E 22 00 0C 00 43 10 23 50 40 00 16 02 70 10 23 02 02 20 2B 02 04 10 0B 24 05 00 0A 92 44 00 00 14 85 00 05 A0 64 00 00 96 24 00 00 30 84 01 00 54 80 00 06 8E 22 00 08 24 42 FF FF 24 63 00 01 14 40 FF F6 26 52 00 01 8E 22 00 08 AE 23 00 10 00 43 18 23 02 03 80 21 10 00 00 02 02 70 10 23 02 60 10 21 8F BF 00 34 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_776_0_0 {
	meta:
		name = "__GI___uc_malloc"
		size = 128
		refs = "0000 _gp_disp 0014 __GI___uc_malloc_failed 0028 malloc 0050 __GI__exit"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B1 00 20 8F 91 ?? ?? AF B0 00 1C AF BC 00 10 AF BF 00 24 00 80 80 21 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 12 00 00 0D 8F BC 00 10 14 40 00 0C 8F BF 00 24 8E 39 00 00 17 20 00 04 00 00 00 00 8F 99 ?? ?? ?? ?? ?? ?? 24 04 00 01 03 20 F8 09 02 00 20 21 10 00 FF F0 8F BC 00 10 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_777_0_0 {
	meta:
		name = "__GI_wcscat"
		size = 56
	strings:
		$1 = { 00 80 10 21 00 80 18 21 8C 64 00 00 10 80 00 03 24 66 00 04 10 00 FF FC 00 C0 18 21 8C A4 00 00 24 63 00 04 24 A5 00 04 14 80 FF FC AC 64 FF FC 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_778_0_0 {
	meta:
		name = "mlockall"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 3C 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_779_0_0 {
	meta:
		name = "mprotect"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 1D 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_781_0_0 {
	meta:
		name = "__fwritable"
		size = 16
	strings:
		$1 = { 94 82 00 00 38 42 00 20 03 E0 00 08 7C 42 01 40 }
	condition:
		$1
}

rule file_782_0_0 {
	meta:
		name = "vsprintf"
		size = 36
		refs = "0000 _gp_disp 000c __GI_vsnprintf"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 00 A0 10 21 00 C0 38 21 24 05 FF FF ?? ?? ?? ?? 00 40 30 21 }
	condition:
		$1
}

rule file_783_0_0 {
	meta:
		name = "__libc_system"
		size = 476
		refs = "0000 _gp_disp 003c __GI_signal 0080 fork 0114 __GI_execl 0108 $LC0 010c $LC1 0110 $LC2 012c __GI__exit 015c __GI_wait4"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF BC 00 18 AF B6 00 40 AF BF 00 44 AF B5 00 3C AF B4 00 38 AF B3 00 34 AF B2 00 30 AF B1 00 2C AF B0 00 28 10 80 00 5E 00 80 B0 21 8F 90 ?? ?? 24 04 00 03 02 00 C8 21 ?? ?? ?? ?? 24 05 00 01 24 04 00 02 24 05 00 01 02 00 C8 21 ?? ?? ?? ?? 00 40 A8 21 24 04 00 12 00 00 28 21 02 00 C8 21 ?? ?? ?? ?? 00 40 A0 21 8F BC 00 18 00 40 98 21 8F 99 ?? ?? ?? ?? ?? ?? 02 00 88 21 00 40 90 21 04 41 00 0E 24 04 00 03 02 00 C8 21 ?? ?? ?? ?? 02 A0 28 21 24 04 00 02 02 00 C8 21 ?? ?? ?? ?? 02 80 28 21 24 04 00 12 02 00 C8 21 ?? ?? ?? ?? 02 60 28 21 10 00 00 3B 24 02 FF FF 14 40 00 1A 02 00 C8 21 ?? ?? ?? ?? 00 00 28 21 24 04 00 02 02 00 C8 21 ?? ?? ?? ?? 00 00 28 21 24 04 00 12 02 00 C8 21 ?? ?? ?? ?? 00 00 28 21 8F BC 00 18 AF A0 00 10 02 C0 38 21 8F 84 ?? ?? 8F 85 ?? ?? 8F 86 ?? ?? 8F 99 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? ?? ?? ?? ?? 24 C6 ?? ?? 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 24 04 00 7F ?? ?? ?? ?? 24 05 00 01 24 04 00 02 02 00 C8 21 ?? ?? ?? ?? 24 05 00 01 8F BC 00 18 02 40 20 21 27 A5 00 20 8F 99 ?? ?? 00 00 30 21 ?? ?? ?? ?? 00 00 38 21 24 03 FF FF 50 43 00 01 AF A2 00 20 24 04 00 03 02 20 C8 21 ?? ?? ?? ?? 02 A0 28 21 24 04 00 02 02 20 C8 21 ?? ?? ?? ?? 02 80 28 21 24 04 00 12 02 20 C8 21 ?? ?? ?? ?? 02 60 28 21 10 00 00 02 8F A2 00 20 24 02 00 01 8F BF 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_784_0_0 {
	meta:
		name = "sethostname"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F EA 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_785_0_0 {
	meta:
		name = "clock"
		size = 80
		refs = "0000 _gp_disp 000c __GI_times"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D0 AF BF 00 2C AF BC 00 10 ?? ?? ?? ?? 27 A4 00 18 8F A2 00 18 8F A3 00 1C 8F BF 00 2C 27 BD 00 30 00 62 18 21 24 02 27 10 70 62 18 02 3C 02 7F FF 34 42 FF F0 03 E0 00 08 00 62 10 24 }
	condition:
		$1
}

rule file_786_0_0 {
	meta:
		name = "ldiv"
		size = 52
	strings:
		$1 = { 00 A6 00 1A 00 C0 01 F4 00 80 10 21 00 00 18 10 04 A0 00 05 00 00 20 12 04 63 00 04 AC 44 00 00 24 84 00 01 00 66 18 23 AC 44 00 00 03 E0 00 08 AC 43 00 04 }
	condition:
		$1
}

rule file_787_0_0 {
	meta:
		name = "swapoff"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 13 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_788_0_0 {
	meta:
		name = "tcsetpgrp"
		size = 60
		refs = "0000 _gp_disp 0010 __GI_ioctl"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 8F 99 ?? ?? AF A5 00 24 3C 05 80 04 AF BF 00 1C AF BC 00 10 27 A6 00 24 ?? ?? ?? ?? 24 A5 74 76 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_790_0_0 {
	meta:
		name = "getchar"
		size = 248
		refs = "0000 _gp_disp 000c stdin 0034 _pthread_cleanup_push_defer 0058 __GI___fgetc_unlocked 006c __pthread_mutex_unlock 0088 __pthread_mutex_lock 00cc _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 27 BD FF C8 AF BC 00 10 AF BF 00 34 AF B2 00 30 AF B1 00 2C AF B0 00 28 8C 50 00 00 8E 02 00 34 10 40 00 0E 8F 99 ?? ?? 8E 02 00 10 8E 03 00 18 00 43 18 2B 10 60 00 04 24 43 00 01 AE 03 00 10 10 00 00 23 90 42 00 00 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 10 00 00 1F 8F BF 00 34 8F 85 ?? ?? 26 12 00 38 27 B1 00 18 02 20 20 21 ?? ?? ?? ?? 02 40 30 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 8E 02 00 10 8E 03 00 18 00 43 18 2B 10 60 00 05 8F BC 00 10 24 43 00 01 AE 03 00 10 10 00 00 06 90 50 00 00 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F BC 00 10 00 40 80 21 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 24 05 00 01 02 00 10 21 8F BF 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_791_0_0 {
	meta:
		name = "__GI_getdomainname"
		size = 176
		refs = "0000 _gp_disp 000c __GI_uname 0044 __GI_strlen 0064 __GI___errno_location 007c __GI_strcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FE 50 AF BC 00 10 AF B2 01 A8 AF B1 01 A4 AF BF 01 AC AF B0 01 A0 00 80 88 21 27 A4 00 18 ?? ?? ?? ?? 00 A0 90 21 24 03 FF FF 10 43 00 15 8F BC 00 10 8F 99 ?? ?? 27 B0 01 5D ?? ?? ?? ?? 02 00 20 21 24 42 00 01 02 42 90 2B 12 40 00 07 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 10 00 00 07 AC 43 00 00 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 02 00 28 21 10 00 00 02 00 00 10 21 24 02 FF FF 8F BF 01 AC 8F B2 01 A8 8F B1 01 A4 8F B0 01 A0 03 E0 00 08 27 BD 01 B0 }
	condition:
		$1
}

rule file_792_0_0 {
	meta:
		name = "__psfs_parse_spec"
		size = 732
		refs = "0000 _gp_disp 0098 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8C 82 00 30 27 BD FF E0 AF BC 00 10 AF BF 00 1C 90 43 00 00 24 63 FF D0 30 63 00 FF 2C 63 00 0A 10 60 00 27 24 07 00 01 3C 08 0C CC 00 00 18 21 35 08 CC CC 24 09 00 0A 00 68 28 2A 10 A0 00 08 8C 85 00 30 24 A6 00 01 AC 86 00 30 70 69 30 02 90 A5 00 00 24 A5 FF D0 00 C5 18 21 8C 85 00 30 90 A6 00 00 24 C7 FF D0 2C E7 00 0A 54 E0 FF F3 00 68 28 2A 24 07 00 24 10 C7 00 0E 24 A5 00 01 8C 85 00 24 04 A2 00 08 AC 83 00 40 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 AC 43 00 00 10 00 00 88 24 02 FF FF 24 03 FF FE 10 00 00 3E AC 83 00 24 AC 85 00 30 10 00 00 02 00 00 38 21 00 00 18 21 8F 89 ?? ?? 24 06 00 10 25 25 ?? ?? 8C 88 00 30 90 AB 00 00 91 0A 00 00 15 6A 00 07 24 A5 00 01 90 85 00 45 25 08 00 01 AC 88 00 30 00 C5 30 25 10 00 FF F4 A0 86 00 45 90 A8 00 00 15 00 FF F3 00 06 30 40 90 85 00 45 30 A5 00 10 10 A0 00 03 00 00 00 00 10 00 00 06 A0 80 00 44 10 E0 00 09 8C 85 00 24 04 A1 FF D8 24 03 FF FE AC 83 00 24 3C 07 0C CC 00 00 18 21 34 E7 CC CC 10 00 00 12 24 08 00 0A 24 06 FF FE 10 A6 FF CF 24 63 FF FF 2C 65 00 09 10 A0 FF CD 8F 99 ?? ?? 10 00 FF F4 AC 83 00 28 50 C0 00 09 8C 85 00 30 24 A6 00 01 AC 86 00 30 70 68 30 02 90 A5 00 00 24 A5 FF D0 00 C5 18 21 AC 83 00 40 8C 85 00 30 90 A6 00 00 24 C6 FF D0 30 C6 00 FF 2C C6 00 0A 14 C0 FF F1 00 67 30 2A 8F 83 ?? ?? 24 63 ?? ?? 00 60 30 21 8C 85 00 30 90 67 00 00 90 A8 00 00 55 07 00 04 24 63 00 01 24 A5 00 01 10 00 00 04 AC 85 00 30 90 65 00 00 54 A0 FF F7 8C 85 00 30 00 66 28 23 28 A5 00 02 50 A0 00 0A 90 66 00 08 8C 85 00 30 90 66 00 00 90 A7 00 00 54 E6 00 05 90 66 00 08 24 A5 00 01 24 63 00 08 AC 85 00 30 90 66 00 08 8F 83 ?? ?? 00 06 32 00 24 63 ?? ?? AC 86 00 38 00 60 40 21 8C 87 00 30 90 65 00 00 90 E9 00 00 55 25 00 1E 24 63 00 01 8F 85 ?? ?? 00 68 18 23 24 A5 ?? ?? 00 A0 40 21 90 A9 00 00 01 23 48 2A 51 20 00 03 00 A8 28 23 10 00 FF FB 24 A5 00 01 8F 88 ?? ?? 00 05 28 40 90 89 00 45 25 08 ?? ?? 00 A8 28 21 94 A8 00 00 00 06 2A 03 00 A9 28 25 00 08 40 27 01 05 28 24 14 A0 FF 7F 28 65 00 13 14 A0 00 03 30 C6 04 00 24 65 FF FD 00 A6 18 0B AC 83 00 3C 10 00 00 06 00 E2 10 23 90 65 00 00 54 A0 FF DE 8C 87 00 30 10 00 FF 74 8F 99 ?? ?? 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_793_0_0 {
	meta:
		name = "__stdio_READ"
		size = 128
		refs = "0000 _gp_disp 0034 __GI_read"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF B0 00 18 AF BC 00 10 AF BF 00 1C 94 83 00 00 00 80 80 21 30 63 00 04 14 60 00 11 00 00 10 21 04 C1 00 03 8F 99 ?? ?? 3C 06 7F FF 34 C6 FF FF ?? ?? ?? ?? 8E 04 00 04 1C 40 00 0A 8F BF 00 1C 14 40 00 04 96 03 00 00 34 63 00 04 10 00 00 04 A6 03 00 00 34 63 00 08 A6 03 00 00 00 00 10 21 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_794_0_0 {
	meta:
		name = "__GI_dup2"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F DF 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_795_0_0 {
	meta:
		name = "__GI_wmemchr"
		size = 44
	strings:
		$1 = { 10 C0 00 06 00 00 00 00 8C 82 00 00 10 45 00 05 24 C6 FF FF 10 00 FF FA 24 84 00 04 03 E0 00 08 00 00 10 21 03 E0 00 08 00 80 10 21 }
	condition:
		$1
}

rule file_796_0_0 {
	meta:
		name = "sendfile"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 6F 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_797_0_0 {
	meta:
		name = "unlockpt"
		size = 140
		refs = "0000 _gp_disp 000c __GI___errno_location 003c __GI_ioctl"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF C8 AF BC 00 10 AF BF 00 34 AF B1 00 30 AF B0 00 2C AF A4 00 20 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F A4 00 20 3C 05 80 04 8F 99 ?? ?? AF A0 00 18 24 A5 54 31 27 A6 00 18 00 40 80 21 ?? ?? ?? ?? 8C 51 00 00 10 40 00 06 00 00 18 21 8E 04 00 00 24 02 00 16 54 82 00 02 24 03 FF FF AE 11 00 00 8F BF 00 34 8F B1 00 30 8F B0 00 2C 00 60 10 21 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_798_0_0 {
	meta:
		name = "getnetbyaddr"
		size = 172
		refs = "0000 _gp_disp 0014 _net_stayopen 002c __GI_setnetent 0044 __GI_getnetent 0080 __GI_endnetent"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B0 00 24 8F 90 ?? ?? AF BC 00 10 AF B3 00 30 AF B2 00 2C AF B1 00 28 AF BF 00 34 8F 99 ?? ?? 00 80 88 21 8E 04 00 00 ?? ?? ?? ?? 00 A0 90 21 8F BC 00 10 8F 93 ?? ?? 02 60 C8 21 ?? ?? ?? ?? 00 00 00 00 10 40 00 07 8F BC 00 10 8C 43 00 08 14 72 FF FA 02 60 C8 21 8C 43 00 0C 14 71 FF F7 00 00 00 00 8E 03 00 00 14 60 00 06 8F BF 00 34 8F 99 ?? ?? ?? ?? ?? ?? AF A2 00 18 8F A2 00 18 8F BF 00 34 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_799_0_0 {
	meta:
		name = "create_module"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 1F 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_800_0_0 {
	meta:
		name = "sigorset"
		size = 60
	strings:
		$1 = { 24 02 00 04 24 07 FF FF 24 42 FF FF 10 47 00 09 00 02 18 80 00 83 40 21 00 C3 48 21 00 A3 18 21 8D 29 00 00 8C 63 00 00 01 23 18 25 10 00 FF F6 AD 03 00 00 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_801_0_0 {
	meta:
		name = "dirname"
		size = 168
		refs = "0000 _gp_disp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 00 80 28 21 00 80 10 21 10 80 00 21 24 07 00 2F 80 46 00 00 10 C0 00 08 00 40 18 21 50 C7 00 07 80 66 00 00 24 43 00 01 00 A0 10 21 00 40 28 21 10 00 FF F7 00 60 10 21 80 66 00 00 14 C7 00 03 00 00 00 00 10 00 FF FC 24 63 00 01 54 C0 FF F8 00 40 28 21 14 A4 00 0B 00 A0 10 21 80 83 00 00 24 02 00 2F 54 62 00 0B 8F 82 ?? ?? 80 85 00 01 14 A3 00 04 24 82 00 01 80 85 00 02 24 83 00 02 00 65 10 0A A0 40 00 00 03 E0 00 08 00 80 10 21 8F 82 ?? ?? 03 E0 00 08 24 42 ?? ?? }
	condition:
		$1
}

rule file_802_1_0 {
	meta:
		name = "xdrmem_getlong"
		size = 60
		altNames = "xdrmem_getint32"
	strings:
		$1 = { 8C 83 00 14 2C 66 00 04 14 C0 00 0A 00 00 10 21 8C 82 00 0C 24 63 FF FC AC 83 00 14 8C 42 00 00 AC A2 00 00 8C 82 00 0C 24 42 00 04 AC 82 00 0C 24 02 00 01 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_802_2_0 {
	meta:
		name = "xdrmem_putlong"
		size = 60
		altNames = "xdrmem_putint32"
	strings:
		$1 = { 8C 83 00 14 2C 66 00 04 14 C0 00 0A 00 00 10 21 24 63 FF FC AC 83 00 14 8C 82 00 0C 8C A3 00 00 AC 43 00 00 8C 82 00 0C 24 42 00 04 AC 82 00 0C 24 02 00 01 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_802_3_0 {
	meta:
		name = "xdrmem_getpos"
		size = 16
	strings:
		$1 = { 8C 83 00 0C 8C 82 00 10 03 E0 00 08 00 62 10 23 }
	condition:
		$1
}

rule file_802_4_0 {
	meta:
		name = "xdrmem_setpos"
		size = 56
	strings:
		$1 = { 8C 82 00 10 8C 83 00 0C 00 45 28 21 8C 82 00 14 00 62 18 21 00 65 30 2A 14 C0 00 05 00 00 10 21 AC 85 00 0C 00 65 28 23 AC 85 00 14 24 02 00 01 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_802_5_0 {
	meta:
		name = "xdrmem_inline"
		size = 48
	strings:
		$1 = { 8C 82 00 14 00 45 18 2B 14 60 00 07 00 00 00 00 00 45 10 23 AC 82 00 14 8C 82 00 0C 00 45 28 21 03 E0 00 08 AC 85 00 0C 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_802_8_0 {
	meta:
		name = "xdrmem_putbytes"
		size = 112
		refs = "0000 _gp_disp 0038 __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B1 00 20 AF B0 00 1C AF BC 00 10 AF BF 00 24 8C 83 00 14 00 80 80 21 00 C0 88 21 00 66 20 2B 14 80 00 0A 00 00 10 21 8F 99 ?? ?? 8E 04 00 0C 00 66 18 23 ?? ?? ?? ?? AE 03 00 14 8E 02 00 0C 00 51 88 21 AE 11 00 0C 24 02 00 01 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_802_9_0 {
	meta:
		name = "xdrmem_getbytes"
		size = 116
		refs = "0000 _gp_disp 003c __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B0 00 1C 00 80 80 21 8E 03 00 14 AF BC 00 10 00 A0 20 21 00 66 28 2B AF B1 00 20 AF BF 00 24 00 C0 88 21 14 A0 00 0A 00 00 10 21 8F 99 ?? ?? 8E 05 00 0C 00 66 18 23 ?? ?? ?? ?? AE 03 00 14 8E 02 00 0C 00 51 88 21 AE 11 00 0C 24 02 00 01 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_802_10_0 {
	meta:
		name = "__GI_xdrmem_create"
		size = 44
		refs = "0000 _gp_disp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? AC 87 00 00 AC 85 00 10 24 42 ?? ?? AC 82 00 04 AC 85 00 0C 03 E0 00 08 AC 86 00 14 }
	condition:
		$1
}

rule file_803_0_0 {
	meta:
		name = "calloc"
		size = 324
		refs = "0000 _gp_disp 0038 __pthread_mutex_unlock 003c __GI___errno_location 005c __malloc_lock 0060 _pthread_cleanup_push_defer 0078 __pthread_mutex_lock 0088 malloc 00ac _pthread_cleanup_pop_restore 00cc __GI_memset"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF BC 00 10 AF B0 00 2C AF BF 00 34 AF B1 00 30 10 80 00 0D 70 85 80 02 02 04 00 1B 00 80 01 F4 00 00 20 12 50 A4 00 09 8F 85 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 0C AC 43 00 00 10 00 00 37 00 00 10 21 8F 85 ?? ?? 8F 86 ?? ?? 8F 99 ?? ?? 27 B1 00 18 ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 00 40 80 21 10 40 00 20 8F BC 00 10 8C 42 FF FC 30 43 00 02 14 60 00 1D 8F 99 ?? ?? 24 06 FF FC 00 46 30 24 24 C6 FF FC 00 06 10 82 2C 43 00 0A 14 60 00 07 2C 43 00 05 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 00 00 28 21 10 00 00 0F 8F BC 00 10 AE 00 00 00 AE 00 00 04 14 60 00 0B AE 00 00 08 2C 43 00 07 AE 00 00 0C 14 60 00 07 AE 00 00 10 24 03 00 09 AE 00 00 14 14 43 00 03 AE 00 00 18 AE 00 00 1C AE 00 00 20 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 24 05 00 01 02 00 10 21 8F BF 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_805_0_0 {
	meta:
		name = "fsync"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 16 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_806_0_0 {
	meta:
		name = "__GI_ftruncate64"
		size = 88
		refs = "0000 _gp_disp 0030 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 00 00 28 21 24 02 10 74 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_807_0_0 {
	meta:
		name = "umount"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F B6 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_809_0_0 {
	meta:
		name = "__GI_strtok"
		size = 28
		refs = "0000 _gp_disp 0010 __GI_strtok_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 86 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 C6 ?? ?? }
	condition:
		$1
}

rule file_811_0_0 {
	meta:
		name = "get_current_dir_name"
		size = 228
		refs = "0000 _gp_disp 0010 __GI_getenv 000c $LC0 0040 __GI_stat64 003c $LC1 0080 __GI_getcwd 00ac __GI_strdup"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 84 ?? ?? 8F 99 ?? ?? 27 BD FE 98 AF BC 00 10 AF B0 01 5C AF BF 01 64 AF B1 01 60 ?? ?? ?? ?? 24 84 ?? ?? 00 40 80 21 10 40 00 22 8F BC 00 10 8F 84 ?? ?? 8F 91 ?? ?? 27 A5 00 B8 02 20 C8 21 ?? ?? ?? ?? 24 84 ?? ?? 14 40 00 1A 8F BC 00 10 02 00 20 21 02 20 C8 21 ?? ?? ?? ?? 27 A5 00 18 14 40 00 14 8F BC 00 10 8F A2 00 B8 8F A3 00 18 14 62 00 11 8F 99 ?? ?? 8F A2 00 BC 8F A3 00 1C 14 62 00 0E 00 00 20 21 8F A2 00 C8 8F A3 00 28 14 62 00 09 8F A2 00 CC 8F A3 00 2C 14 62 00 05 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 10 00 00 06 8F BF 01 64 8F 99 ?? ?? 00 00 20 21 ?? ?? ?? ?? 00 00 28 21 8F BF 01 64 8F B1 01 60 8F B0 01 5C 03 E0 00 08 27 BD 01 68 }
	condition:
		$1
}

rule file_812_0_0 {
	meta:
		name = "getpgrp"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F E1 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_813_0_0 {
	meta:
		name = "iruserfopen"
		size = 260
		refs = "0000 _gp_disp 0010 __GI_lstat 005c __GI_fopen 0058 $LC0 0078 __GI_fileno 008c __GI_fstat 00b0 __GI_fclose"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 40 8F 99 ?? ?? AF B1 00 B4 27 B1 00 18 AF BC 00 10 AF B2 00 B8 AF B0 00 B0 AF BF 00 BC 00 A0 90 21 02 20 28 21 ?? ?? ?? ?? 00 80 80 21 14 40 00 2A 8F BC 00 10 8F A3 00 2C 34 02 80 00 30 63 F0 00 14 62 00 26 00 00 10 21 8F 85 ?? ?? 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 24 A5 ?? ?? 00 40 80 21 10 40 00 1D 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BC 00 10 00 40 20 21 8F 99 ?? ?? ?? ?? ?? ?? 02 20 28 21 04 40 00 10 8F BC 00 10 8F A2 00 34 50 40 00 04 8F A2 00 2C 14 52 00 0C 8F 99 ?? ?? 8F A2 00 2C 30 42 00 12 14 40 00 08 8F 99 ?? ?? 8F A2 00 30 2C 42 00 02 10 40 00 04 02 00 10 21 10 00 00 06 8F BF 00 BC 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 00 00 10 21 8F BF 00 BC 8F B2 00 B8 8F B1 00 B4 8F B0 00 B0 03 E0 00 08 27 BD 00 C0 }
	condition:
		$1
}

rule file_813_1_0 {
	meta:
		name = "__ivaliduser2.isra.1"
		size = 1116
		refs = "0000 _gp_disp 0014 $LC1 006c __GI_getline 0090 __GI___ctype_b 00d4 __GI_strcmp 0104 __GI_strchr 013c __GI___fgetc_unlocked 019c __GI___ctype_tolower 0294 malloc 0298 __GI_inet_addr 02cc __GI___errno_location 02e4 __GI_gethostbyname_r 031c free 0350 __GI_memcmp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 80 AF B5 00 6C 8F 95 ?? ?? 27 A3 00 44 27 B9 00 40 AF B4 00 68 AF B3 00 64 AF B1 00 5C AF BC 00 18 AF BF 00 7C AF BE 00 78 AF B7 00 74 AF B6 00 70 AF B2 00 60 AF B0 00 58 00 80 88 21 00 A0 98 21 AF A6 00 88 00 E0 A0 21 AF A0 00 44 AF A0 00 40 AF A3 00 4C AF B9 00 50 26 B5 ?? ?? 8F 99 ?? ?? 27 A4 00 44 27 A5 00 40 ?? ?? ?? ?? 02 20 30 21 18 40 00 1C 8F BC 00 18 8F A3 00 44 8F A2 00 40 8F 86 ?? ?? 00 62 10 21 A0 40 FF FF 8F B2 00 44 02 40 18 21 80 62 00 00 10 40 FF F0 00 02 20 40 8C C5 00 00 00 A4 20 21 94 84 00 00 30 84 00 20 10 80 00 0E 8F 96 ?? ?? 10 00 FF F6 24 63 00 01 02 A0 20 21 ?? ?? ?? ?? 03 C0 28 21 24 12 00 01 14 40 00 65 8F BC 00 18 24 02 FF FF 16 42 00 A7 00 00 00 00 10 00 00 C9 24 10 FF FF 24 03 00 23 10 43 FF DA 8F 99 ?? ?? 02 40 20 21 ?? ?? ?? ?? 24 05 00 0A 14 40 00 21 8F BC 00 18 8E 22 00 10 8E 23 00 18 00 43 18 2B 10 60 00 04 24 43 00 01 AE 23 00 10 10 00 00 05 90 42 00 00 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BC 00 18 8F 90 ?? ?? 24 16 00 0A 24 12 FF FF 10 56 FF C5 8F 99 ?? ?? 50 52 FF C4 27 A4 00 44 8E 22 00 10 8E 23 00 18 00 43 18 2B 10 60 00 04 24 43 00 01 AE 23 00 10 10 00 FF F5 90 42 00 00 02 00 C8 21 ?? ?? ?? ?? 02 20 20 21 10 00 FF F0 8F BC 00 18 8F 85 ?? ?? 82 42 00 00 10 40 00 0F 00 02 18 40 8E C4 00 00 00 83 20 21 94 84 00 00 30 84 00 20 54 80 00 07 24 03 00 20 8C A2 00 00 26 52 00 01 00 43 18 21 94 62 00 00 10 00 FF F2 A2 42 FF FF 50 43 00 05 26 50 00 01 24 03 00 09 14 43 00 1A 02 40 80 21 26 50 00 01 A2 40 00 00 82 02 00 00 10 40 00 09 00 02 10 40 8E C3 00 00 00 62 10 21 94 42 00 00 30 42 00 20 10 40 00 04 02 00 90 21 10 00 FF F6 26 10 00 01 02 00 90 21 82 42 00 00 10 40 00 09 00 02 10 40 8E C3 00 00 00 62 10 21 94 42 00 00 30 42 00 20 54 40 00 04 A2 40 00 00 10 00 FF F6 26 52 00 01 A2 40 00 00 8F BE 00 44 24 02 00 2D AF B3 00 3C 93 C4 00 00 14 82 FF 99 8F 99 ?? ?? 27 DE 00 01 24 12 FF FF 83 C2 00 00 8E C4 00 00 00 02 10 40 00 82 10 21 94 42 00 00 30 42 00 08 10 40 00 0B 8F 99 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 03 C0 20 21 24 04 FF FF 10 44 00 04 8F BC 00 18 02 62 10 26 10 00 FF 8C 00 02 90 0B 8F 99 ?? ?? ?? ?? ?? ?? 24 04 04 00 8F BC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 40 B8 21 8F BC 00 18 8C 43 00 00 00 40 B0 21 8F 99 ?? ?? 27 A2 00 38 AF A2 00 10 27 A2 00 34 03 C0 20 21 AF A3 00 48 AF A2 00 14 27 A5 00 20 02 E0 30 21 ?? ?? ?? ?? 24 07 04 00 8F BC 00 18 02 E0 20 21 10 40 00 05 8F 99 ?? ?? ?? ?? ?? ?? 00 00 90 21 10 00 00 16 8F BC 00 18 ?? ?? ?? ?? 00 00 00 00 8F B9 00 48 8F A2 00 38 8F BC 00 18 10 40 00 0E AE D9 00 00 8C 56 00 10 8F 9E ?? ?? 27 B7 00 3C 8E C5 00 00 10 A0 00 08 02 E0 20 21 03 C0 C8 21 ?? ?? ?? ?? 24 06 00 04 10 40 FF 5D 8F BC 00 18 10 00 FF F7 26 D6 00 04 00 00 90 21 10 00 FF 59 24 02 FF FF 12 40 FF 38 8F 99 ?? ?? 82 02 00 00 8F A3 00 88 00 62 80 0A 92 03 00 00 24 02 00 2D 14 62 00 09 8F 92 ?? ?? 26 04 00 01 02 40 C8 21 ?? ?? ?? ?? 02 80 28 21 2C 42 00 01 8F BC 00 18 10 00 00 0E 00 02 10 23 02 A0 20 21 02 40 C8 21 ?? ?? ?? ?? 02 00 28 21 10 40 00 0D 8F BC 00 18 02 80 20 21 02 40 C8 21 ?? ?? ?? ?? 02 00 28 21 2C 42 00 01 14 40 00 06 8F BC 00 18 24 03 FF FF 14 43 FF 19 8F 99 ?? ?? 10 00 00 02 24 10 FF FF 00 00 80 21 8F 99 ?? ?? ?? ?? ?? ?? 8F A4 00 44 8F BF 00 7C 02 00 10 21 8F BE 00 78 8F B7 00 74 8F B6 00 70 8F B5 00 6C 8F B4 00 68 8F B3 00 64 8F B2 00 60 8F B1 00 5C 8F B0 00 58 03 E0 00 08 27 BD 00 80 }
	condition:
		$1
}

rule file_813_2_0 {
	meta:
		name = "iruserok2.isra.2"
		size = 592
		refs = "0000 _gp_disp 005c $LC2 0068 iruserfopen 0090 __ivaliduser2.isra.1 00a0 __GI_fclose 00b8 __check_rhosts_file 00c8 __GI_sysconf 00e4 __GI_getpwnam_r 011c __GI_strlen 0130 malloc 0148 __GI_strcpy 0160 __GI_strcat 015c $LC3 0170 __GI_geteuid 0188 __GI_seteuid 01bc free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 98 AF BE 00 60 03 A0 F0 21 AF B5 00 54 AF B4 00 50 AF B3 00 4C AF B2 00 48 AF BF 00 64 AF B7 00 5C AF B6 00 58 AF B1 00 44 AF B0 00 40 AF BC 00 18 00 80 A8 21 00 A0 98 21 00 C0 A0 21 10 A0 00 03 00 E0 90 21 10 00 00 18 24 10 FF FF 8F 84 ?? ?? 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 24 84 ?? ?? 00 40 88 21 10 40 FF F7 8F DC 00 18 8F 99 ?? ?? 00 40 20 21 02 A0 28 21 02 40 30 21 27 39 ?? ?? ?? ?? ?? ?? 02 80 38 21 8F DC 00 18 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F DC 00 18 12 00 00 59 00 00 18 21 8F 82 ?? ?? 8C 42 00 00 02 62 98 25 12 60 00 53 8F 99 ?? ?? ?? ?? ?? ?? 24 04 00 46 8F DC 00 18 24 43 00 0E 00 03 18 C2 00 03 18 C0 8F 99 ?? ?? 03 A3 E8 23 27 C3 00 3C AF A3 00 10 02 40 20 21 27 C5 00 20 27 A6 00 18 ?? ?? ?? ?? 00 40 38 21 8F DC 00 18 14 40 00 42 24 03 FF FF 8F C2 00 3C 10 40 00 3F 8F 99 ?? ?? 8C 53 00 14 ?? ?? ?? ?? 02 60 20 21 8F DC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 24 44 00 09 8F DC 00 18 02 60 28 21 00 40 20 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 88 21 8F DC 00 18 02 20 20 21 8F 85 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? 8F DC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F DC 00 18 00 40 B8 21 8F C2 00 3C 8F 96 ?? ?? 02 C0 C8 21 ?? ?? ?? ?? 8C 44 00 08 8F DC 00 18 8F C2 00 3C 02 20 20 21 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 8C 45 00 08 8F DC 00 18 00 40 98 21 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 12 60 00 0D 8F DC 00 18 8F 99 ?? ?? 02 60 20 21 02 A0 28 21 02 40 30 21 27 39 ?? ?? ?? ?? ?? ?? 02 80 38 21 8F DC 00 18 02 60 20 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 80 21 02 C0 C8 21 ?? ?? ?? ?? 02 E0 20 21 10 00 00 02 02 00 18 21 24 03 FF FF 03 C0 E8 21 8F BF 00 64 8F BE 00 60 8F B7 00 5C 8F B6 00 58 8F B5 00 54 8F B4 00 50 8F B3 00 4C 8F B2 00 48 8F B1 00 44 8F B0 00 40 00 60 10 21 03 E0 00 08 27 BD 00 68 }
	condition:
		$1
}

rule file_813_3_0 {
	meta:
		name = "__GI_rresvport"
		size = 296
		refs = "0000 _gp_disp 000c __GI_socket 0068 __GI_bind 006c __GI___errno_location 00b8 __GI_close"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF B0 24 02 00 02 24 05 00 02 AF BC 00 10 AF B1 00 30 AF B0 00 2C AF BF 00 4C AF B7 00 48 AF B6 00 44 AF B5 00 40 AF B4 00 3C AF B3 00 38 AF B2 00 34 00 80 88 21 A7 A2 00 18 AF A0 00 1C 24 04 00 02 ?? ?? ?? ?? 00 00 30 21 00 40 80 21 04 40 00 23 8F BC 00 10 8F 95 ?? ?? 8F 96 ?? ?? 27 B4 00 18 24 17 00 7D 24 13 02 00 8E 22 00 00 02 00 20 21 02 80 28 21 A7 A2 00 1A 02 A0 C8 21 ?? ?? ?? ?? 24 06 00 10 04 41 00 17 02 C0 C8 21 ?? ?? ?? ?? 00 00 00 00 00 40 90 21 8C 42 00 00 10 57 00 06 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 10 00 00 0D 24 02 FF FF 8E 22 00 00 24 42 FF FF 14 53 FF E9 AE 22 00 00 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 24 02 00 0B AE 42 00 00 10 00 00 02 24 02 FF FF 02 00 10 21 8F BF 00 4C 8F B7 00 48 8F B6 00 44 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_813_4_0 {
	meta:
		name = "rcmd"
		size = 1932
		refs = "0000 _gp_disp 0010 __GI_getpid 0068 __GI_gethostbyname_r 006c __GI___errno_location 00dc __GI___h_errno_location 00f0 __GI_herror 013c __GI_sigblock 0164 __GI_rresvport 0198 stderr 01a0 __GI_fputs 019c $LC4 01bc __GI_fprintf 01b8 $LC5 01d4 __GI_fcntl 021c __GI_memmove 0238 __GI_connect 0258 __GI_close 02b0 __GI_sleep 02e0 __GI_inet_ntoa 0318 $LC6 0330 __GI_perror 039c $LC7 03b4 $LC8 03ec __GI_write 03e8 $LC9 042c __GI_listen 044c __GI_snprintf 0448 $LC10 0464 __GI_strlen 04b4 $LC11 04e0 __GI_poll 0508 __GI_accept 0518 $LC12 0538 $LC13 0584 $LC14 05d0 $LC15 0668 __GI_read 0688 $LC16 06b4 __GI_sigsetmask"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 30 8F 99 ?? ?? 30 A5 FF FF AF BE 00 C8 03 A0 F0 21 AF B7 00 C4 AF B6 00 C0 AF B5 00 BC AF B4 00 B8 AF B3 00 B4 AF B2 00 B0 AF B1 00 AC AF BC 00 18 AF BF 00 CC AF B0 00 A8 AF C5 00 84 00 C0 A8 21 00 80 90 21 ?? ?? ?? ?? 00 E0 A0 21 8F DC 00 18 27 D9 00 74 27 BD FB F8 8F 93 ?? ?? 8F 91 ?? ?? AF D9 00 88 27 D9 00 20 AF C2 00 80 27 A6 00 18 24 16 04 00 27 D7 00 78 AF D9 00 8C 8E 44 00 00 27 C2 00 74 AF A2 00 10 AF B7 00 14 27 C5 00 20 02 60 C8 21 ?? ?? ?? ?? 02 C0 38 21 10 40 00 1C 8F DC 00 18 8F D0 00 78 24 02 FF FF 16 02 00 07 02 20 C8 21 ?? ?? ?? ?? 00 00 00 00 8C 44 00 00 24 02 00 22 10 82 00 0B 8F DC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F DC 00 18 AC 50 00 00 8F 99 ?? ?? ?? ?? ?? ?? 8E 44 00 00 10 00 01 96 24 02 FF FF 00 16 B0 40 26 C2 00 0E 00 02 10 C2 00 02 10 C0 03 A2 E8 23 10 00 FF DC 27 A6 00 18 8F C2 00 74 10 40 FF E4 8F D0 00 78 24 03 00 01 A7 C3 00 38 A7 C3 00 40 8C 42 00 00 8F 99 ?? ?? 3C 04 00 10 ?? ?? ?? ?? AE 42 00 00 8F DC 00 18 00 40 88 21 24 02 03 FF AF C2 00 70 24 13 00 01 27 D6 00 70 8F 99 ?? ?? ?? ?? ?? ?? 02 C0 20 21 00 40 80 21 04 41 00 17 8F DC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8C 44 00 00 8F DC 00 18 24 03 00 0B 14 83 00 08 8F 82 ?? ?? 8F 84 ?? ?? 8F 99 ?? ?? 8C 45 00 00 ?? ?? ?? ?? 24 84 ?? ?? 10 00 01 65 8F DC 00 18 8F 85 ?? ?? 8F 99 ?? ?? 8C 44 00 00 ?? ?? ?? ?? 24 A5 ?? ?? 10 00 01 5E 8F DC 00 18 8F 99 ?? ?? 8F C6 00 80 00 40 20 21 ?? ?? ?? ?? 24 05 00 18 8F C2 00 74 8F DC 00 18 27 D7 00 58 8C 43 00 08 02 E0 20 21 A7 C3 00 54 8C 43 00 10 8C 42 00 0C 8C 65 00 00 2C 46 00 05 24 03 00 04 00 46 18 0B 00 60 30 21 8F 83 ?? ?? 00 60 C8 21 ?? ?? ?? ?? AF C3 00 A0 8F DC 00 18 8F D9 00 84 02 00 20 21 8F 82 ?? ?? A7 D9 00 56 27 C5 00 54 00 40 C8 21 ?? ?? ?? ?? 24 06 00 10 04 41 00 60 8F DC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F DC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8C 47 00 00 00 40 40 21 24 02 00 7D 14 E2 00 05 8F DC 00 18 8F C2 00 70 24 42 FF FF 10 00 FF B4 AF C2 00 70 24 02 00 92 14 E2 00 0A 8F C2 00 74 2A 62 00 11 10 40 00 07 8F C2 00 74 8F 99 ?? ?? 02 60 20 21 ?? ?? ?? ?? 00 13 98 40 10 00 FF A8 8F DC 00 18 8F 90 ?? ?? 8C 43 00 10 8C 64 00 04 10 80 00 37 8F 83 ?? ?? 8C 65 00 00 8F 89 ?? ?? 8F C4 00 58 AF C3 00 A0 01 20 C8 21 AF C9 00 9C AF C7 00 98 AF C8 00 94 ?? ?? ?? ?? AF C5 00 90 8F DC 00 18 8F C5 00 90 00 40 30 21 02 00 C8 21 00 A0 20 21 8F 85 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? 8F DC 00 18 8F C8 00 94 8F C7 00 98 8F 82 ?? ?? 00 00 20 21 00 40 C8 21 ?? ?? ?? ?? AD 07 00 00 8F C2 00 74 8F DC 00 18 24 06 00 04 8C 45 00 10 8F 99 ?? ?? 24 A4 00 04 AC 44 00 10 8C 42 00 0C 8C A5 00 04 02 E0 20 21 2C 47 00 05 ?? ?? ?? ?? 00 47 30 0B 8F C9 00 9C 8F C3 00 A0 8F C4 00 58 01 20 C8 21 03 20 F8 09 8C 77 00 00 8F DC 00 18 02 E0 20 21 00 40 30 21 8F 85 ?? ?? 02 00 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 10 00 FF 6D 8F DC 00 18 8F 85 ?? ?? 8C 64 00 00 8C 46 00 00 02 00 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 10 00 00 DE 8F DC 00 18 8F C2 00 70 8F D9 00 E4 24 42 FF FF 17 20 00 0A AF C2 00 70 8F 85 ?? ?? 8F 99 ?? ?? 02 00 20 21 24 A5 ?? ?? ?? ?? ?? ?? 24 06 00 01 8F DC 00 18 10 00 00 79 AF C0 00 70 8F 99 ?? ?? ?? ?? ?? ?? 02 C0 20 21 00 40 98 21 24 02 00 10 8F DC 00 18 06 60 00 C4 AF C2 00 6C 8F 99 ?? ?? 02 60 20 21 ?? ?? ?? ?? 24 05 00 01 8F DC 00 18 8F C7 00 70 27 D6 00 64 8F 86 ?? ?? 8F 99 ?? ?? 02 C0 20 21 24 05 00 08 ?? ?? ?? ?? 24 C6 ?? ?? 8F DC 00 18 8F 97 ?? ?? 02 E0 C8 21 ?? ?? ?? ?? 02 C0 20 21 8F DC 00 18 02 C0 28 21 02 00 20 21 8F 99 ?? ?? ?? ?? ?? ?? 24 46 00 01 AF C2 00 A0 02 E0 C8 21 ?? ?? ?? ?? 02 C0 20 21 8F DC 00 18 8F C3 00 A0 24 42 00 01 10 62 00 06 8F 96 ?? ?? 8F 82 ?? ?? 8F 85 ?? ?? 8C 44 00 00 10 00 00 19 24 A5 ?? ?? 8F 99 ?? ?? AF D0 00 34 ?? ?? ?? ?? AF D3 00 3C 8F DC 00 18 27 C4 00 34 AC 40 00 00 8F 99 ?? ?? 24 05 00 02 24 06 FF FF ?? ?? ?? ?? 00 40 B8 21 18 40 00 05 8F DC 00 18 97 C2 00 42 30 42 00 01 14 40 00 14 8F 99 ?? ?? 8E E3 00 00 10 60 00 09 8F 82 ?? ?? 8F 85 ?? ?? 8C 44 00 00 24 A5 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 00 06 00 00 00 00 8F 84 ?? ?? 8C 45 00 00 8F 99 ?? ?? ?? ?? ?? ?? 24 84 ?? ?? 02 60 20 21 10 00 00 76 02 C0 C8 21 02 60 20 21 27 C5 00 44 ?? ?? ?? ?? 27 C6 00 6C 00 40 B8 21 02 C0 C8 21 ?? ?? ?? ?? 02 60 20 21 06 E1 00 0A 8F DC 00 18 8F 82 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 8C 44 00 00 ?? ?? ?? ?? 24 A5 ?? ?? 8F DC 00 18 10 00 00 66 AF C0 00 70 8F D9 00 E4 97 C4 00 44 24 03 00 02 AF 37 00 00 14 83 00 05 97 C2 00 46 24 42 FE 00 2C 42 02 00 14 40 00 0A 8F 96 ?? ?? 8F 82 ?? ?? 8F 84 ?? ?? 8F 99 ?? ?? 8C 45 00 00 ?? ?? ?? ?? 24 84 ?? ?? 10 00 00 2F 8F DC 00 18 8F 96 ?? ?? 02 C0 C8 21 ?? ?? ?? ?? 02 A0 20 21 8F DC 00 18 02 A0 28 21 24 46 00 01 8F 93 ?? ?? 02 60 C8 21 ?? ?? ?? ?? 02 00 20 21 02 C0 C8 21 ?? ?? ?? ?? 02 80 20 21 24 46 00 01 02 80 28 21 02 60 C8 21 ?? ?? ?? ?? 02 00 20 21 8F C4 00 E0 02 C0 C8 21 ?? ?? ?? ?? 27 D4 00 64 8F C5 00 E0 02 00 20 21 02 60 C8 21 ?? ?? ?? ?? 24 46 00 01 8F DC 00 18 02 00 20 21 02 80 28 21 8F 95 ?? ?? 02 A0 C8 21 ?? ?? ?? ?? 24 06 00 01 24 03 00 01 10 43 00 0B 8F DC 00 18 8F 82 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 8C 44 00 00 8E 46 00 00 ?? ?? ?? ?? 24 A5 ?? ?? 8F DC 00 18 10 00 00 1C 8F C2 00 70 83 C2 00 64 10 40 00 14 8F 99 ?? ?? 24 12 00 0A 02 00 20 21 02 80 28 21 02 A0 C8 21 ?? ?? ?? ?? 24 06 00 01 24 03 00 01 14 43 00 0F 8F DC 00 18 24 04 00 02 02 80 28 21 02 60 C8 21 ?? ?? ?? ?? 24 06 00 01 83 C2 00 64 14 52 FF F1 8F DC 00 18 10 00 00 06 8F C2 00 70 ?? ?? ?? ?? 02 20 20 21 10 00 00 12 02 00 10 21 8F C2 00 70 10 40 00 08 8F 99 ?? ?? 8F D9 00 E4 8F 24 00 00 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F DC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 8F DC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 24 02 FF FF 03 C0 E8 21 8F BF 00 CC 8F BE 00 C8 8F B7 00 C4 8F B6 00 C0 8F B5 00 BC 8F B4 00 B8 8F B3 00 B4 8F B2 00 B0 8F B1 00 AC 8F B0 00 A8 03 E0 00 08 27 BD 00 D0 }
	condition:
		$1
}

rule file_813_5_0 {
	meta:
		name = "ruserok"
		size = 380
		refs = "0000 _gp_disp 0024 __GI_gethostbyname_r 0028 __GI___errno_location 010c __GI_memcpy 012c iruserok2.isra.2"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 90 AF BE 00 68 03 A0 F0 21 AF B7 00 64 AF B6 00 60 27 D9 00 3C 8F 96 ?? ?? 8F 97 ?? ?? AF B5 00 5C AF B4 00 58 AF B3 00 54 AF B2 00 50 AF B1 00 4C AF B0 00 48 AF BF 00 6C AF BC 00 18 AF D9 00 40 27 BD FB F8 27 D9 00 34 00 C0 88 21 00 80 98 21 00 A0 80 21 00 E0 90 21 27 A6 00 18 24 14 04 00 AF D9 00 44 27 D5 00 20 27 C2 00 3C 27 D9 00 34 AF B9 00 14 AF A2 00 10 02 60 20 21 02 A0 28 21 02 C0 C8 21 ?? ?? ?? ?? 02 80 38 21 10 40 00 13 8F DC 00 18 8F C4 00 34 24 02 FF FF 10 82 00 03 02 E0 C8 21 10 00 00 24 24 02 FF FF ?? ?? ?? ?? 00 00 00 00 8C 44 00 00 24 02 00 22 14 82 FF F9 00 14 A0 40 26 82 00 0E 00 02 10 C2 00 02 10 C0 03 A2 E8 23 10 00 FF E4 27 A6 00 18 8F C2 00 3C 10 40 FF ED 8F C4 00 34 8C 53 00 10 8F 95 ?? ?? 27 D4 00 38 8E 65 00 00 10 A0 FF EA 8F 99 ?? ?? 02 80 20 21 ?? ?? ?? ?? 24 06 00 04 8F C4 00 38 02 00 28 21 02 20 30 21 26 B9 ?? ?? ?? ?? ?? ?? 02 40 38 21 10 40 00 03 8F DC 00 18 10 00 FF F1 26 73 00 04 00 00 10 21 03 C0 E8 21 8F BF 00 6C 8F BE 00 68 8F B7 00 64 8F B6 00 60 8F B5 00 5C 8F B4 00 58 8F B3 00 54 8F B2 00 50 8F B1 00 4C 8F B0 00 48 03 E0 00 08 27 BD 00 70 }
	condition:
		$1
}

rule file_814_0_0 {
	meta:
		name = "wait"
		size = 60
		refs = "0000 _gp_disp 000c __GI_wait4"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 00 80 28 21 24 04 FF FF AF BF 00 1C AF BC 00 10 00 00 30 21 ?? ?? ?? ?? 00 00 38 21 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_815_0_0 {
	meta:
		name = "__GI_asctime_r"
		size = 404
		refs = "0000 _gp_disp 0020 __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF B0 00 18 00 80 80 21 00 A0 20 21 8F 85 ?? ?? 8F 99 ?? ?? AF BC 00 10 AF BF 00 1C 24 A5 ?? ?? ?? ?? ?? ?? 24 06 00 1A 8E 04 00 18 00 40 18 21 2C 82 00 07 10 40 00 0C 8F BC 00 10 24 05 00 03 70 85 30 02 8F 82 ?? ?? 24 42 ?? ?? 00 C2 10 21 90 44 00 00 A0 64 00 00 90 44 00 01 90 42 00 02 A0 64 00 01 A0 62 00 02 8E 02 00 10 2C 44 00 0C 50 80 00 0E 8E 04 00 14 24 05 00 03 70 45 10 02 8F 85 ?? ?? 24 A5 ?? ?? 24 42 00 15 00 A2 10 21 90 45 00 00 A0 65 00 04 90 45 00 01 90 42 00 02 A0 65 00 05 A0 62 00 06 8E 04 00 14 24 84 07 6C 2C 82 27 10 54 40 00 03 24 62 00 17 10 00 00 0C 24 62 00 13 24 05 00 3F 24 03 00 0A 00 83 00 1A 00 60 01 F4 24 42 FF FF 00 00 30 10 24 C6 00 30 A0 46 00 01 80 46 00 00 10 C5 FF F8 00 00 20 12 24 04 00 3F 24 05 00 0A 24 06 00 30 80 43 FF FF 02 03 18 21 8C 63 00 00 2C 67 00 64 14 E0 00 04 00 00 00 00 A0 44 FF FF 10 00 00 0A A0 44 FF FE 00 65 00 1A 00 A0 01 F4 00 00 38 10 24 E7 00 30 A0 47 FF FF 90 47 FF FE 00 00 18 12 00 67 18 21 A0 43 FF FE 80 43 FF FB 14 66 00 03 24 47 FF FD 10 00 FF EA 00 E0 10 21 80 44 FF FE 24 03 00 30 14 83 00 04 8F BF 00 1C 24 03 00 20 A0 43 FF FE 8F BF 00 1C 8F B0 00 18 24 42 FF F6 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_816_0_0 {
	meta:
		name = "__parsespent"
		size = 292
		refs = "0000 _gp_disp 0020 __GI_strchr 0024 __GI_strtoul"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B3 00 2C 8F 93 ?? ?? AF B7 00 3C AF B5 00 34 8F 97 ?? ?? 8F 95 ?? ?? AF B6 00 38 AF B4 00 30 AF B2 00 28 AF B1 00 24 AF B0 00 20 AF BC 00 10 AF BF 00 44 AF BE 00 40 00 80 90 21 00 A0 88 21 00 00 80 21 26 73 ?? ?? 27 B4 00 18 24 16 FF FF 02 13 10 21 90 5E 00 00 2A 02 00 02 10 40 00 0A 02 5E F0 21 AF D1 00 00 02 20 20 21 02 E0 C8 21 ?? ?? ?? ?? 24 05 00 3A 14 40 00 16 00 40 18 21 10 00 00 18 24 02 00 16 02 20 20 21 02 80 28 21 02 A0 C8 21 ?? ?? ?? ?? 24 06 00 0A 8F A3 00 18 00 71 88 26 02 D1 10 0A AF C2 00 00 24 02 00 08 56 02 00 05 80 64 00 00 80 63 00 00 24 02 00 16 10 00 00 08 00 03 10 0A 24 02 00 3A 14 82 00 05 24 02 00 16 24 71 00 01 A0 60 00 00 10 00 FF DC 26 10 00 01 8F BF 00 44 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_817_0_0 {
	meta:
		name = "__GI_lstat"
		size = 120
		refs = "0000 _gp_disp 0034 __GI___errno_location 0054 __xstat_conv"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 50 AF BC 00 10 00 A0 30 21 AF BF 00 AC AF B0 00 A8 27 A5 00 18 24 02 10 0B 00 00 00 0C 10 E0 00 07 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 10 00 00 07 24 10 FF FF 14 40 00 06 8F BF 00 AC 8F 99 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 00 C0 28 21 8F BF 00 AC 02 00 10 21 8F B0 00 A8 03 E0 00 08 27 BD 00 B0 }
	condition:
		$1
}

rule file_818_0_0 {
	meta:
		name = "__GI_setitimer"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 08 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_819_0_0 {
	meta:
		name = "stime"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F B9 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_821_0_0 {
	meta:
		name = "__GI_getrlimit"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F EC 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_822_1_0 {
	meta:
		name = "__glob_sort"
		size = 28
		refs = "0000 _gp_disp 0010 __GI_strcmp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8C 84 00 00 8F 99 ?? ?? ?? ?? ?? ?? 8C A5 00 00 }
	condition:
		$1
}

rule file_822_2_0 {
	meta:
		name = "__glob_is_literal"
		size = 152
	strings:
		$1 = { 00 00 18 21 24 06 00 5B 24 07 00 5C 24 08 00 5D 24 09 00 2A 24 0A 00 3F 80 82 00 00 50 40 00 1C 24 02 00 01 10 46 00 17 28 4B 00 5C 11 60 00 07 00 00 00 00 50 49 00 16 00 00 10 21 10 4A 00 14 00 00 10 21 10 00 FF F4 24 84 00 01 10 47 00 05 00 00 00 00 10 48 00 07 00 00 00 00 10 00 FF EE 24 84 00 01 50 A0 FF EC 24 84 00 01 03 E0 00 08 00 00 10 21 50 60 FF E8 24 84 00 01 03 E0 00 08 00 00 10 21 24 03 00 01 10 00 FF E3 24 84 00 01 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_822_3_0 {
	meta:
		name = "__glob_append"
		size = 172
		refs = "0000 _gp_disp 000c malloc 0050 __GI_strcpy 0074 __GI_strcat 0070 $LC0"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D0 AF BC 00 10 AF B2 00 28 AF B1 00 24 AF B0 00 20 AF A5 00 18 AF BF 00 2C 00 80 88 21 24 C4 00 09 ?? ?? ?? ?? 00 E0 90 21 00 40 80 21 8F BC 00 10 10 40 00 12 8F A5 00 18 8E 22 00 00 8F 99 ?? ?? 26 03 00 04 AC 50 00 00 00 60 20 21 ?? ?? ?? ?? AE 00 00 00 12 40 00 06 8F BC 00 10 8F 85 ?? ?? 8F 99 ?? ?? 00 40 20 21 ?? ?? ?? ?? 24 A5 ?? ?? AE 30 00 00 10 00 00 02 00 00 10 21 24 02 FF FF 8F BF 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_822_4_0 {
	meta:
		name = "__glob_match_in_dir"
		size = 1144
		refs = "0000 _gp_disp 0014 __GI_strlen 008c __GI_strchr 00b8 __GI_strcpy 00f0 __glob_is_literal 0124 $LC1 0134 __GI_opendir 0144 __GI___errno_location 0184 __GI_stat64 01b0 __glob_append 0208 __GI_fnmatch 0224 __GI_readdir64_r 0244 __GI_closedir 031c __GI_memcpy 037c __glob_match_in_dir 0430 __GI_strcmp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FC E0 AF B2 03 00 8F 92 ?? ?? AF BE 03 18 03 A0 F0 21 AF BF 03 1C AF BC 00 18 AF B6 03 10 AF B5 03 0C AF B4 03 08 AF B3 03 04 AF B1 02 FC AF B0 02 F8 AF B7 03 14 02 40 C8 21 AF C7 03 2C 00 80 80 21 00 A0 20 21 00 A0 88 21 ?? ?? ?? ?? 00 C0 B0 21 24 42 00 08 00 02 10 C2 00 02 10 C0 03 A2 E8 23 02 40 C8 21 ?? ?? ?? ?? 02 00 20 21 8F DC 00 18 00 40 90 21 32 D4 00 40 24 02 00 04 8F 99 ?? ?? 24 03 00 06 00 54 18 0A AF C3 02 E0 02 20 20 21 ?? ?? ?? ?? 24 05 00 2F 27 B5 00 18 8F DC 00 18 10 40 00 0F 00 40 98 21 8F 99 ?? ?? 02 20 28 21 02 71 88 23 02 A0 20 21 ?? ?? ?? ?? 02 B1 88 21 8F DC 00 18 24 02 00 2F A2 20 00 00 82 63 00 00 14 62 00 03 02 A0 88 21 10 00 FF FC 26 73 00 01 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 2E 85 00 01 AF C2 02 E8 82 02 00 00 24 03 00 2F 14 43 00 04 8F DC 00 18 82 02 00 01 10 00 00 03 00 02 90 0A 50 40 00 03 8F 84 ?? ?? 10 00 00 02 02 00 20 21 24 84 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F DC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 00 40 A0 21 8C 55 00 00 16 80 00 4C 8F DC 00 18 24 02 00 14 56 A2 00 03 24 02 00 0D 10 00 00 B6 00 00 10 21 16 A2 00 3A 8F D9 03 2C 82 22 00 00 14 40 00 38 02 00 20 21 8F 99 ?? ?? ?? ?? ?? ?? 27 C5 00 20 14 40 00 31 8F DC 00 18 8F C3 00 38 24 02 40 00 30 63 F0 00 14 62 00 2D 8F D9 03 2C 8F C4 03 30 8F 99 ?? ?? 02 00 28 21 02 40 30 21 ?? ?? ?? ?? 02 40 38 21 10 00 00 9F 00 02 10 2B 8F C5 02 D8 10 A0 00 1C 8F C3 02 E8 94 A2 00 10 AF DD 02 E4 02 42 10 21 24 42 00 09 00 02 10 C2 00 02 10 C0 03 A2 E8 23 27 B7 00 18 02 E0 A8 21 24 A5 00 13 14 60 00 8B 02 20 20 21 8F 99 ?? ?? ?? ?? ?? ?? 8F C6 02 E0 8F DC 00 18 10 40 00 31 00 00 00 00 8F DD 02 E4 8F 99 ?? ?? 02 80 20 21 27 C5 00 20 ?? ?? ?? ?? 27 C6 02 D8 00 40 A8 21 10 40 FF E3 8F DC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 02 80 20 21 12 A0 00 7C 00 00 10 21 8F D9 03 2C 02 00 20 21 03 20 F8 09 02 A0 28 21 10 40 00 03 32 D6 00 01 10 00 00 74 24 02 00 02 16 C0 00 72 24 02 00 02 10 00 00 70 00 00 10 21 82 22 00 00 14 40 00 0E 27 D9 02 D8 8F 99 ?? ?? 8F C4 03 30 02 00 28 21 02 40 30 21 ?? ?? ?? ?? 02 40 38 21 8F DC 00 18 00 02 80 2B 8F 99 ?? ?? ?? ?? ?? ?? 02 80 20 21 10 00 00 60 02 00 10 21 AF D9 02 EC 27 C3 00 20 32 D9 00 02 AF C3 02 F0 10 00 FF D2 AF D9 02 F4 12 60 00 0B 8F C2 02 D8 90 42 00 12 50 40 00 09 82 02 00 00 00 02 13 00 30 42 FF FF 24 03 40 00 10 43 00 03 34 03 A0 00 54 43 FF C6 8F DD 02 E4 82 02 00 00 50 40 00 12 8F D5 02 D8 8F 99 ?? ?? 02 E0 20 21 02 00 28 21 ?? ?? ?? ?? 02 40 30 21 8F DC 00 18 8F C5 02 D8 02 F2 10 21 8F 99 ?? ?? 24 03 00 2F 26 44 00 01 A0 43 00 00 02 E4 20 21 ?? ?? ?? ?? 24 A5 00 13 10 00 00 02 8F DC 00 18 26 B5 00 13 12 60 00 10 8F D9 03 30 02 A0 20 21 02 60 28 21 AF B9 00 10 8F C7 03 2C 8F 99 ?? ?? ?? ?? ?? ?? 02 C0 30 21 00 40 A8 21 10 40 FF A4 8F DC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 02 80 20 21 10 00 00 21 02 A0 10 21 8F C3 02 F4 10 60 00 10 00 00 38 21 8F C2 02 D8 90 47 00 12 10 E0 00 03 00 07 3B 00 10 00 00 08 30 E7 FF FF 8F 99 ?? ?? 02 A0 20 21 ?? ?? ?? ?? 27 C5 02 38 8F C7 02 50 8F DC 00 18 30 E7 F0 00 38 E7 40 00 2C E7 00 01 8F C2 02 D8 8F 99 ?? ?? 8F C4 03 30 94 46 00 10 02 A0 28 21 24 C6 00 01 ?? ?? ?? ?? 00 D2 30 21 10 40 FF 83 8F DC 00 18 8F 99 ?? ?? ?? ?? ?? ?? 02 80 20 21 24 02 00 01 10 00 00 06 8F DD 02 E4 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 10 00 FF 76 8F DC 00 18 03 C0 E8 21 8F BF 03 1C 8F BE 03 18 8F B7 03 14 8F B6 03 10 8F B5 03 0C 8F B4 03 08 8F B3 03 04 8F B2 03 00 8F B1 02 FC 8F B0 02 F8 03 E0 00 08 27 BD 03 20 }
	condition:
		$1
}

rule file_822_5_0 {
	meta:
		name = "__glob_freelist"
		size = 76
		refs = "0000 _gp_disp 0024 free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 8C 84 00 00 10 80 00 06 8F 99 ?? ?? ?? ?? ?? ?? 8C 90 00 00 8F BC 00 10 10 00 FF FA 02 00 20 21 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_823_0_0 {
	meta:
		name = "__GI_getsockname"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 4C 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_824_0_0 {
	meta:
		name = "setlocale"
		size = 136
		refs = "0000 _gp_disp 0050 __GI_strcmp 004c $LC0"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 2C 84 00 07 10 80 00 16 00 00 00 00 27 BD FF E0 AF BC 00 10 AF BF 00 1C 10 A0 00 14 8F 82 ?? ?? 80 A2 00 00 10 40 00 10 24 03 00 43 14 43 00 04 00 A0 20 21 80 A2 00 01 10 40 00 0C 8F 82 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? 10 40 00 05 8F BC 00 10 10 00 00 05 00 00 10 21 03 E0 00 08 00 00 10 21 8F 82 ?? ?? 24 42 ?? ?? 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_826_0_0 {
	meta:
		name = "gcvt"
		size = 92
		refs = "0000 _gp_disp 0018 __GI_sprintf 0014 $LC0"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF A5 00 14 8F 85 ?? ?? 8F 99 ?? ?? 28 C3 00 12 24 02 00 11 AF BF 00 24 AF B0 00 20 AF BC 00 18 AF A4 00 10 24 A5 ?? ?? 00 E0 20 21 00 43 30 0A ?? ?? ?? ?? 00 E0 80 21 8F BF 00 24 02 00 10 21 8F B0 00 20 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_827_0_0 {
	meta:
		name = "trecurse"
		size = 216
		refs = "0000 _gp_disp 0070 trecurse"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF D8 AF B2 00 20 AF B1 00 1C AF B0 00 18 AF BC 00 10 AF BF 00 24 8C 82 00 04 00 80 80 21 00 A0 88 21 14 40 00 04 00 C0 90 21 8C 82 00 08 10 40 00 1F 24 05 00 03 02 00 20 21 00 00 28 21 02 20 C8 21 03 20 F8 09 02 40 30 21 8E 04 00 04 10 80 00 06 8F BC 00 10 8F 99 ?? ?? 02 20 28 21 27 39 ?? ?? ?? ?? ?? ?? 26 46 00 01 02 00 20 21 24 05 00 01 02 20 C8 21 03 20 F8 09 02 40 30 21 8E 04 00 08 10 80 00 07 8F BC 00 10 8F 99 ?? ?? 02 20 28 21 27 39 ?? ?? ?? ?? ?? ?? 26 46 00 01 8F BC 00 10 02 00 20 21 24 05 00 02 02 40 30 21 8F BF 00 24 8F B2 00 20 8F B0 00 18 02 20 C8 21 8F B1 00 1C 03 20 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_827_1_0 {
	meta:
		name = "twalk"
		size = 48
		refs = "0000 _gp_disp 0020 trecurse"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 10 80 00 06 00 00 00 00 10 A0 00 04 8F 99 ?? ?? 27 39 ?? ?? ?? ?? ?? ?? 00 00 30 21 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_828_0_0 {
	meta:
		name = "sync"
		size = 76
		refs = "0000 _gp_disp 0018 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 24 02 0F C4 00 00 00 0C 10 E0 00 0B 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF B0 00 18 AF BC 00 10 ?? ?? ?? ?? 00 40 80 21 AC 50 00 00 8F BF 00 1C 8F B0 00 18 27 BD 00 20 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_829_0_0 {
	meta:
		name = "mlock"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 3A 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_830_3_0 {
	meta:
		name = "__GI_getnetent"
		size = 664
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 0058 __pthread_mutex_lock 0078 $LC1 009c malloc 00a4 __GI_fopen 00a0 $LC0 00dc __GI_abort 00ec __GI_fgets 0120 any 0150 $LC2 01b0 __GI_inet_network 0258 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B0 AF B0 00 2C 8F 90 ?? ?? 8F 99 ?? ?? 8F 85 ?? ?? AF B3 00 38 27 B3 00 18 AF BC 00 10 26 06 ?? ?? AF BF 00 4C AF B7 00 48 AF B6 00 44 AF B5 00 40 AF B4 00 3C AF B2 00 34 AF B1 00 30 ?? ?? ?? ?? 02 60 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 26 04 ?? ?? 8F BC 00 10 8F 90 ?? ?? 8E 02 ?? ?? 10 40 00 0B 8F 84 ?? ?? 8F 97 ?? ?? 8F 96 ?? ?? 8F 91 ?? ?? 26 F7 ?? ?? 26 D6 ?? ?? 8E 22 ?? ?? 14 40 00 16 8F 82 ?? ?? 10 00 00 0B 8F 99 ?? ?? 8F 85 ?? ?? 8F 99 ?? ?? 24 84 ?? ?? ?? ?? ?? ?? 24 A5 ?? ?? AE 02 ?? ?? 14 40 FF EF 8F BC 00 10 10 00 00 65 00 00 80 21 ?? ?? ?? ?? 24 04 10 01 AE 22 ?? ?? 14 40 00 04 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F 82 ?? ?? 8F 99 ?? ?? 8E 06 ?? ?? 8C 44 ?? ?? ?? ?? ?? ?? 24 05 10 00 00 40 38 21 10 40 FF EE 8F BC 00 10 80 43 00 00 24 02 00 23 10 62 FF DD 00 E0 20 21 02 C0 C8 21 ?? ?? ?? ?? 02 E0 28 21 02 C0 90 21 10 40 FF D7 8F BC 00 10 8F 95 ?? ?? 8F 94 ?? ?? A0 40 00 00 00 E0 20 21 AE A7 ?? ?? 02 C0 C8 21 ?? ?? ?? ?? 26 85 ?? ?? 10 40 FF CD 8F BC 00 10 24 51 00 01 A0 40 00 00 24 04 00 20 24 03 00 09 82 22 00 00 14 44 00 03 00 00 00 00 10 00 FF FC 26 31 00 01 50 43 FF FA 26 31 00 01 02 20 20 21 02 40 C8 21 ?? ?? ?? ?? 26 85 ?? ?? 10 40 00 04 8F BC 00 10 24 50 00 01 10 00 00 02 A0 40 00 00 00 00 80 21 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 02 30 80 0A 8F BC 00 10 26 A3 ?? ?? AC 62 00 0C 8F 87 ?? ?? 8F 8B ?? ?? 24 02 00 02 24 E7 ?? ?? AC 62 00 08 AC 67 00 04 00 60 40 21 24 09 00 20 24 0A 00 09 25 6B ?? ?? 26 94 ?? ?? 82 06 00 00 50 C0 00 15 AC E0 00 00 50 C9 00 10 26 10 00 01 14 CA 00 03 00 EB 10 2B 10 00 00 0C 26 10 00 01 10 40 00 03 02 00 20 21 AC F0 00 00 24 E7 00 04 02 40 C8 21 ?? ?? ?? ?? 02 80 28 21 10 40 00 05 8F BC 00 10 24 50 00 01 A0 40 00 00 56 00 FF EC 82 06 00 00 AC E0 00 00 01 00 80 21 8F 99 ?? ?? 02 60 20 21 ?? ?? ?? ?? 24 05 00 01 8F BF 00 4C 02 00 10 21 8F B7 00 48 8F B6 00 44 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_832_0_0 {
	meta:
		name = "__GI_stpncpy"
		size = 52
	strings:
		$1 = { 00 80 38 21 00 A0 18 21 10 C0 00 07 24 E7 00 01 80 62 00 00 24 C6 FF FF A0 E2 FF FF 00 02 10 2B 10 00 FF F9 00 62 18 21 00 65 10 23 03 E0 00 08 00 82 10 21 }
	condition:
		$1
}

rule file_833_0_0 {
	meta:
		name = "fstatvfs64"
		size = 932
		refs = "0000 _gp_disp 000c __GI_fstatfs64 0060 __GI_memset 00e8 __GI_fstat64 010c __GI___errno_location 012c __GI_setmntent 0124 $LC0 013c $LC1 014c $LC2 016c __GI_getmntent_r 0170 __GI_stat64 01dc $LC11 01e0 $LC3 01e4 $LC4 01f8 __GI_strsep 0214 __GI_strcmp 0260 $LC5 0288 $LC6 02b0 $LC7 02d8 $LC8 0300 $LC9 0328 $LC10 0354 __GI_endmntent"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FA 00 AF BC 00 10 AF B1 05 DC AF B0 05 D8 AF BF 05 FC AF BE 05 F8 AF B7 05 F4 AF B6 05 F0 AF B5 05 EC AF B4 05 E8 AF B3 05 E4 AF B2 05 E0 00 A0 88 21 27 A5 05 58 ?? ?? ?? ?? 00 80 80 21 04 40 00 C5 8F BC 00 10 8F A2 05 5C 8F A3 05 6C 8F 99 ?? ?? AE 22 00 00 AE 22 00 04 8F A2 05 68 AE 23 00 0C 8F A3 05 74 AE 22 00 08 8F A2 05 70 AE 23 00 14 8F A3 05 8C AE 22 00 10 8F A2 05 88 AE 23 00 1C 8F A3 05 7C AE 22 00 18 8F A2 05 78 AE 23 00 24 8F A3 05 84 AE 22 00 20 8F A2 05 80 AE 23 00 2C 26 24 00 48 AE 22 00 28 8F A2 05 90 00 00 28 21 24 06 00 18 AE 22 00 38 8F A2 05 98 AE 20 00 3C ?? ?? ?? ?? AE 22 00 44 8F BC 00 10 8E 23 00 2C 8E 22 00 28 8F 99 ?? ?? AE 23 00 34 AE 22 00 30 AE 20 00 40 02 00 20 21 ?? ?? ?? ?? 27 A5 04 B8 04 40 00 9A 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 00 40 A0 21 8C 55 00 00 8F 84 ?? ?? 8F 92 ?? ?? 8F 90 ?? ?? 24 84 ?? ?? 02 00 C8 21 ?? ?? ?? ?? 26 45 ?? ?? 00 40 98 21 14 40 00 09 8F BC 00 10 8F 84 ?? ?? 26 45 ?? ?? 02 00 C8 21 ?? ?? ?? ?? 24 84 ?? ?? 00 40 98 21 10 40 00 7E 8F BC 00 10 8F 90 ?? ?? 8F 9E ?? ?? 27 B6 05 B8 27 B2 00 18 27 B7 04 18 02 60 20 21 02 C0 28 21 02 40 30 21 02 00 C8 21 ?? ?? ?? ?? 24 07 04 00 10 40 00 6E 8F BC 00 10 8F A4 05 BC 03 C0 C8 21 ?? ?? ?? ?? 02 E0 28 21 04 40 FF F3 8F BC 00 10 8F A2 04 18 8F A3 04 B8 14 62 FF F0 02 60 20 21 8F A2 04 1C 8F A3 04 BC 14 62 FF ED 02 C0 28 21 8F A2 05 C4 8F 96 ?? ?? 8F 97 ?? ?? 8F 9E ?? ?? AF A2 05 D0 26 D6 ?? ?? 26 F7 ?? ?? 27 DE ?? ?? 8F 99 ?? ?? 27 A4 05 D0 ?? ?? ?? ?? 02 C0 28 21 00 40 80 21 10 40 00 51 8F BC 00 10 8F 92 ?? ?? 02 00 20 21 02 40 C8 21 ?? ?? ?? ?? 02 E0 28 21 14 40 00 04 8F BC 00 10 8E 22 00 40 10 00 00 45 34 42 00 01 02 00 20 21 02 40 C8 21 ?? ?? ?? ?? 03 C0 28 21 14 40 00 04 8F BC 00 10 8E 22 00 40 10 00 00 3C 34 42 00 02 8F 85 ?? ?? 02 00 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 00 04 8F BC 00 10 8E 22 00 40 10 00 00 32 34 42 00 08 8F 85 ?? ?? 02 00 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 00 04 8F BC 00 10 8E 22 00 40 10 00 00 28 34 42 00 04 8F 85 ?? ?? 02 00 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 00 04 8F BC 00 10 8E 22 00 40 10 00 00 1E 34 42 00 10 8F 85 ?? ?? 02 00 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 00 04 8F BC 00 10 8E 22 00 40 10 00 00 14 34 42 00 40 8F 85 ?? ?? 02 00 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 00 04 8F BC 00 10 8E 22 00 40 10 00 00 0A 34 42 04 00 8F 85 ?? ?? 02 00 20 21 02 40 C8 21 ?? ?? ?? ?? 24 A5 ?? ?? 14 40 FF AE 8F BC 00 10 8E 22 00 40 34 42 08 00 10 00 FF AA AE 22 00 40 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 10 00 00 03 AE 95 00 00 10 00 00 02 24 02 FF FF 00 00 10 21 8F BF 05 FC 8F BE 05 F8 8F B7 05 F4 8F B6 05 F0 8F B5 05 EC 8F B4 05 E8 8F B3 05 E4 8F B2 05 E0 8F B1 05 DC 8F B0 05 D8 03 E0 00 08 27 BD 06 00 }
	condition:
		$1
}

rule file_834_0_0 {
	meta:
		name = "__GI___ns_name_ntop"
		size = 528
		refs = "0000 _gp_disp 0070 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 89 ?? ?? 27 BD FF D8 00 A6 30 21 00 A0 18 21 AF B1 00 1C AF B0 00 18 AF BC 00 10 AF BF 00 24 AF B2 00 20 24 0D 00 2E 24 0E 00 2E 24 0A 00 5C 24 0B 00 64 25 29 ?? ?? 24 02 00 0A 24 0F 00 40 24 18 00 5C 24 19 00 3B 24 10 00 22 24 11 00 24 90 88 00 00 11 00 00 22 24 87 00 01 31 04 00 C0 54 80 00 2B 8F 99 ?? ?? 10 65 00 05 00 66 20 2B 50 80 00 27 8F 99 ?? ?? A0 6D 00 00 24 63 00 01 00 68 20 21 00 86 20 2B 50 80 00 21 8F 99 ?? ?? 24 E4 00 01 90 E7 00 00 10 EE 00 26 2C EC 00 2F 11 80 00 07 00 00 00 00 10 F0 00 23 24 6C 00 01 54 F1 00 28 24 EC FF DF 10 00 00 20 01 86 60 2B 10 EF 00 1D 24 6C 00 01 10 F8 00 1C 01 86 60 2B 54 F9 00 20 24 EC FF DF 10 00 00 17 24 6C 00 01 54 65 00 08 00 66 30 2B 00 66 10 2B 10 40 00 08 8F 99 ?? ?? 24 02 00 2E A0 62 00 00 24 63 00 01 00 66 30 2B 54 C0 00 08 A0 60 00 00 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 61 AC 43 00 00 10 00 00 32 24 02 FF FF 24 63 00 01 10 00 00 2F 00 65 10 23 24 6C 00 01 01 86 60 2B 51 80 FF F4 8F 99 ?? ?? A0 6A 00 00 A0 67 00 01 10 00 00 1D 24 63 00 02 2D 8C 00 5E 15 80 00 1F 00 66 60 2B 24 6C 00 03 01 86 60 2B 51 80 FF E9 8F 99 ?? ?? 00 EB 00 1B 01 60 01 F4 A0 6A 00 00 24 63 00 04 00 00 60 10 00 00 90 12 01 32 90 21 92 52 00 00 01 82 00 1B 00 40 01 F4 A0 72 FF FD 00 00 60 12 01 2C 60 21 91 8C 00 00 00 E2 00 1B 00 40 01 F4 A0 6C FF FE 00 00 60 10 01 2C 38 21 90 E7 00 00 A0 67 FF FF 25 08 FF FF 15 00 FF B1 00 80 38 21 10 00 FF A0 90 88 00 00 51 80 FF CD 8F 99 ?? ?? A0 67 00 00 10 00 FF F7 24 63 00 01 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_834_1_0 {
	meta:
		name = "__GI___ns_name_unpack"
		size = 420
		refs = "0000 _gp_disp 0064 __GI___errno_location 0080 __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B8 AF B7 00 3C 8F B7 00 58 AF BC 00 10 00 C4 10 2B AF B5 00 34 AF B2 00 28 AF BF 00 44 AF BE 00 40 AF B6 00 38 AF B4 00 30 AF B3 00 2C AF B1 00 24 AF B0 00 20 00 80 A8 21 00 C0 90 21 14 40 00 21 00 F7 B8 21 00 C5 10 2B 14 40 00 25 00 A0 98 21 10 00 00 1D 8F 99 ?? ?? 00 E2 18 21 00 77 18 2B 10 60 00 18 00 B0 88 21 02 33 18 2B 10 60 00 15 8F 99 ?? ?? 24 E3 00 01 A0 F0 00 00 00 60 20 21 AF A8 00 18 AF A9 00 1C 02 00 30 21 ?? ?? ?? ?? 02 82 A0 21 8F BC 00 10 8F A8 00 18 8F A9 00 1C 00 50 38 21 92 30 00 00 12 00 00 29 26 25 00 01 02 1E 10 24 50 40 FF E8 26 02 00 01 50 48 00 0F 00 B3 10 2B 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 61 AC 43 00 00 10 00 00 22 24 02 FF FF 00 C0 88 21 00 00 A0 21 24 16 FF FF 24 1E FF C0 24 08 00 C0 10 00 FF EB 00 A4 48 23 10 40 FF F2 8F 99 ?? ?? 06 C1 00 03 92 22 00 01 00 B2 28 23 24 B6 00 01 32 10 00 3F 00 10 82 00 02 02 88 25 02 B1 88 21 02 35 10 2B 14 40 FF E7 8F 99 ?? ?? 02 33 10 2B 10 40 FF E4 26 94 00 02 02 89 10 2A 54 40 FF D9 92 30 00 00 10 00 FF DF 00 00 00 00 2A C2 00 00 00 B2 90 23 02 42 B0 0B A0 E0 00 00 02 C0 10 21 8F BF 00 44 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_834_2_0 {
	meta:
		name = "__GI___ns_name_uncompress"
		size = 152
		refs = "0000 _gp_disp 0010 __GI___ns_name_unpack 0060 __GI___ns_name_ntop"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FE C8 8F 99 ?? ?? 24 02 00 FF AF B0 01 24 27 B0 00 20 AF BC 00 18 AF B3 01 30 AF B2 01 2C AF B1 01 28 AF BF 01 34 00 E0 98 21 AF A2 00 10 02 00 38 21 ?? ?? ?? ?? 24 12 FF FF 00 40 88 21 14 52 00 03 8F BC 00 18 10 00 00 09 24 02 FF FF 8F A6 01 48 8F 99 ?? ?? 02 00 20 21 ?? ?? ?? ?? 02 60 28 21 10 52 00 02 24 02 FF FF 02 20 10 21 8F BF 01 34 8F B3 01 30 8F B2 01 2C 8F B1 01 28 8F B0 01 24 03 E0 00 08 27 BD 01 38 }
	condition:
		$1
}

rule file_835_0_0 {
	meta:
		name = "__check_one_fd"
		size = 124
		refs = "0000 _gp_disp 000c __GI_fcntl 0044 __GI_open 0040 $LC0 005c __GI_abort"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BC 00 10 AF B1 00 20 AF B0 00 1C AF BF 00 24 00 A0 88 21 24 05 00 01 ?? ?? ?? ?? 00 80 80 21 24 03 FF FF 14 43 00 0B 8F BC 00 10 8F 84 ?? ?? 8F 99 ?? ?? 02 20 28 21 ?? ?? ?? ?? 24 84 ?? ?? 10 50 00 04 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_835_3_0 {
	meta:
		name = "__GI___uClibc_init"
		size = 112
		refs = "0000 _gp_disp 002c __pagesize 0038 __pthread_initialize_minimal 0050 _stdio_init"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 27 BD FF E0 AF BC 00 10 8C 43 ?? ?? AF BF 00 1C 14 60 00 10 24 03 00 01 AC 43 ?? ?? 8F 82 ?? ?? 24 03 10 00 AC 43 00 00 8F 82 ?? ?? 10 40 00 04 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 99 ?? ?? 13 20 00 03 8F BF 00 1C ?? ?? ?? ?? 27 BD 00 20 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_835_4_0 {
	meta:
		name = "__GI___uClibc_fini"
		size = 168
		refs = "0000 _gp_disp 000c __fini_array_start 0010 __fini_array_end 005c __app_fini 0068 __rtld_fini"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 83 ?? ?? 8F 82 ?? ?? 27 BD FF D8 AF B1 00 20 00 43 10 23 AF BC 00 10 AF BF 00 24 AF B0 00 1C 00 02 10 83 00 60 88 21 10 40 00 09 24 50 FF FF 00 10 10 80 02 22 10 21 8C 59 00 00 03 20 F8 09 00 00 00 00 8F BC 00 10 10 00 FF F7 02 00 10 21 8F 82 ?? ?? 8C 59 00 00 13 20 00 05 8F 82 ?? ?? 03 20 F8 09 00 00 00 00 8F BC 00 10 8F 82 ?? ?? 8C 59 00 00 13 20 00 05 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 20 00 08 27 BD 00 28 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_835_5_0 {
	meta:
		name = "__uClibc_main"
		size = 736
		refs = "0000 _gp_disp 0010 __libc_stack_end 0044 __rtld_fini 004c __environ 0088 __GI_memset 00c8 __GI_memcpy 00ec _dl_aux_init 00fc __GI___uClibc_init 0118 __pagesize 0144 __GI_getuid 0154 __GI_geteuid 0168 __GI_getgid 0178 __GI_getegid 01c0 __check_one_fd 01f0 __uclibc_progname 01f4 __preinit_array_start 01f8 __preinit_array_end 0200 __app_fini 0250 __init_array_start 0254 __init_array_end 0288 __GI___errno_location 0290 __GI___h_errno_location 02d4 __GI_exit"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 48 8F 82 ?? ?? 8F A3 00 D0 AF BC 00 10 AF B6 00 AC AF B5 00 A8 AF B4 00 A4 AF B2 00 9C AF B0 00 94 AF BF 00 B4 AF B7 00 B0 AF B3 00 A0 AF B1 00 98 AC 43 00 00 8F 82 ?? ?? 8F A3 00 CC 8F 92 ?? ?? 00 80 A8 21 AC 43 00 00 24 A2 00 01 00 02 10 80 00 C2 18 21 AE 43 00 00 8C C4 00 00 00 A0 A0 21 00 C0 80 21 14 64 00 04 00 E0 B0 21 24 42 FF FC 00 C2 10 21 AE 42 00 00 8F 99 ?? ?? 27 B3 00 18 02 60 20 21 00 00 28 21 ?? ?? ?? ?? 24 06 00 78 8F BC 00 10 8E 51 00 00 8E 22 00 00 14 40 FF FE 26 31 00 04 8E 24 00 00 10 80 00 0C 2C 82 00 0F 50 40 FF FC 26 31 00 08 8F 99 ?? ?? 00 04 20 C0 02 64 20 21 02 20 28 21 ?? ?? ?? ?? 24 06 00 08 8F BC 00 10 10 00 FF F3 26 31 00 08 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F A3 00 4C 24 02 10 00 00 63 10 0B 8F 83 ?? ?? AC 62 00 00 8F A3 00 74 24 02 FF FF 10 62 00 06 8F A2 00 74 24 03 FF FF 54 43 00 17 8F A3 00 7C 10 00 00 2C 8E 03 00 00 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 40 88 21 16 22 00 12 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 40 88 21 16 22 00 09 8F BC 00 10 10 00 FF E8 8F A2 00 74 14 43 00 06 8F 91 ?? ?? 8F A2 00 8C 8F A3 00 84 50 62 00 12 8E 03 00 00 8F 91 ?? ?? 00 00 20 21 3C 05 00 02 26 31 ?? ?? 02 20 C8 21 ?? ?? ?? ?? 3C 13 00 02 24 04 00 01 02 20 C8 21 ?? ?? ?? ?? 26 65 00 02 24 04 00 02 02 20 C8 21 ?? ?? ?? ?? 36 65 00 02 8F BC 00 10 8E 03 00 00 8F 82 ?? ?? 8F 93 ?? ?? 8F 97 ?? ?? AC 43 00 00 8F 82 ?? ?? 8F A3 00 C8 02 F3 B8 23 00 00 88 21 AC 43 00 00 00 17 B8 83 02 37 10 2B 10 40 00 07 00 11 10 80 02 62 10 21 8C 59 00 00 03 20 F8 09 26 31 00 01 10 00 FF F8 8F BC 00 10 12 C0 00 04 02 C0 C8 21 03 20 F8 09 00 00 00 00 8F BC 00 10 8F 93 ?? ?? 8F 96 ?? ?? 00 00 88 21 02 D3 B0 23 00 16 B0 83 02 36 10 2B 10 40 00 07 00 11 10 80 02 62 10 21 8C 59 00 00 03 20 F8 09 26 31 00 01 10 00 FF F8 8F BC 00 10 8F 99 ?? ?? 53 20 00 06 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 AC 40 00 00 8F 99 ?? ?? 53 20 00 05 8E 46 00 00 ?? ?? ?? ?? 00 00 00 00 AC 40 00 00 8E 46 00 00 02 80 20 21 02 A0 C8 21 03 20 F8 09 02 00 28 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 }
	condition:
		$1
}

rule file_836_0_0 {
	meta:
		name = "__GI_fputws_unlocked"
		size = 116
		refs = "0000 _gp_disp 000c __GI_wcslen 0040 _wstdio_fwrite"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BF 00 24 AF B2 00 20 AF B1 00 1C AF B0 00 18 AF BC 00 10 00 A0 88 21 ?? ?? ?? ?? 00 80 90 21 8F BC 00 10 02 40 20 21 02 20 30 21 8F 99 ?? ?? 00 40 28 21 ?? ?? ?? ?? 00 40 80 21 8F BF 00 24 00 50 10 26 00 02 10 2B 8F B2 00 20 8F B1 00 1C 8F B0 00 18 00 02 10 23 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_837_0_0 {
	meta:
		name = "__GI_strcpy"
		size = 40
	strings:
		$1 = { 00 80 10 21 00 80 18 21 80 A4 00 00 10 80 00 04 A0 64 00 00 24 A5 00 01 10 00 FF FB 24 63 00 01 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_838_0_0 {
	meta:
		name = "reboot"
		size = 104
		refs = "0000 _gp_disp 0040 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 00 80 30 21 3C 04 FE E1 AF BC 00 10 3C 05 28 12 AF BF 00 1C AF B0 00 18 34 84 DE AD 24 A5 19 69 24 02 0F F8 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_840_0_0 {
	meta:
		name = "__GI_strndup"
		size = 132
		refs = "0000 _gp_disp 000c __GI_strnlen 0034 malloc 004c __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BC 00 10 AF BF 00 24 AF B1 00 20 AF B0 00 1C ?? ?? ?? ?? 00 80 88 21 8F BC 00 10 24 44 00 01 8F 99 ?? ?? ?? ?? ?? ?? 00 40 80 21 00 40 18 21 10 40 00 09 8F BC 00 10 8F 99 ?? ?? 02 00 30 21 00 40 20 21 ?? ?? ?? ?? 02 20 28 21 00 50 80 21 00 40 18 21 A2 00 00 00 8F BF 00 24 8F B1 00 20 8F B0 00 1C 00 60 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_841_0_0 {
	meta:
		name = "setuid"
		size = 120
		refs = "0000 _gp_disp 0024 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 24 02 FF FF AF BC 00 10 AF BF 00 1C AF B0 00 18 14 82 00 07 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 AC 43 00 00 10 00 00 0B 24 02 FF FF 24 02 0F B7 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 02 00 10 21 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_843_0_0 {
	meta:
		name = "__GI_fgetws_unlocked"
		size = 192
		refs = "0000 _gp_disp 0014 __GI_fgetwc_unlocked"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B3 00 24 8F 93 ?? ?? AF B6 00 30 AF B5 00 2C AF B4 00 28 AF B2 00 20 AF B1 00 1C AF B0 00 18 AF BC 00 10 AF BF 00 34 00 80 88 21 00 A0 90 21 00 C0 A8 21 00 80 80 21 24 16 FF FF 24 14 00 0A 2A 42 00 02 14 40 00 0B 02 60 C8 21 ?? ?? ?? ?? 02 A0 20 21 10 56 00 07 26 03 00 04 10 54 00 04 AE 02 00 00 26 52 FF FF 10 00 FF F5 00 60 80 21 00 60 80 21 12 11 00 03 02 20 10 21 10 00 00 02 AE 00 00 00 00 00 10 21 8F BF 00 34 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_844_0_0 {
	meta:
		name = "ferror"
		size = 152
		refs = "0000 _gp_disp 0030 _pthread_cleanup_push_defer 0034 __pthread_mutex_unlock 004c __pthread_mutex_lock 006c _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C8 AF B0 00 28 AF BC 00 10 AF BF 00 34 AF B2 00 30 AF B1 00 2C 8C 91 00 34 16 20 00 0C 00 80 80 21 8F 99 ?? ?? 8F 85 ?? ?? 24 92 00 38 02 40 30 21 ?? ?? ?? ?? 27 A4 00 18 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 96 10 00 00 32 10 00 08 16 20 00 05 32 10 FF FF 8F 99 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F BF 00 34 02 00 10 21 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_845_0_0 {
	meta:
		name = "adjtime"
		size = 272
		refs = "0000 _gp_disp 0054 __GI___errno_location 0088 __GI_adjtimex"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 60 AF BC 00 10 AF B0 00 98 AF BF 00 9C 10 80 00 19 00 A0 80 21 8C 83 00 04 3C 02 00 0F 24 42 42 40 00 62 00 1A 00 40 01 F4 8C 84 00 00 00 00 18 12 00 64 18 21 24 64 08 61 2C 84 10 C3 14 80 00 07 00 00 28 10 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 24 03 00 16 10 00 00 23 AC 43 00 00 70 62 20 02 34 02 80 01 AF A2 00 18 00 85 18 21 10 00 00 02 AF A3 00 1C AF A0 00 18 8F 99 ?? ?? ?? ?? ?? ?? 27 A4 00 18 04 42 00 1A 24 02 FF FF 12 00 00 17 8F A3 00 1C 3C 02 00 0F 04 61 00 0B 24 42 42 40 00 03 20 23 00 82 00 1A 00 40 01 F4 00 00 28 10 00 05 20 23 AE 04 00 04 00 62 00 1A 00 40 01 F4 10 00 00 06 00 00 10 12 00 62 00 1A 00 40 01 F4 00 00 20 10 AE 04 00 04 00 00 10 12 10 00 00 03 AE 02 00 00 10 00 00 02 24 02 FF FF 00 00 10 21 8F BF 00 9C 8F B0 00 98 03 E0 00 08 27 BD 00 A0 }
	condition:
		$1
}

rule file_846_0_0 {
	meta:
		name = "__GI_fnmatch"
		size = 1624
		refs = "0000 _gp_disp 000c __GI___ctype_b 0010 __GI___ctype_tolower 029c __GI_fnmatch"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 87 ?? ?? 8F 88 ?? ?? 27 BD FF C0 30 CB 00 01 24 0C 00 2F AF B7 00 34 AF B6 00 30 AF B5 00 2C AF B3 00 24 AF B2 00 20 AF B1 00 1C AF B0 00 18 AF BC 00 10 AF BF 00 3C AF BE 00 38 AF B4 00 28 00 A0 80 21 30 D1 00 10 30 D2 00 04 24 13 00 2E 30 CD 00 02 24 0E 00 5C 24 15 00 2D 24 19 00 5D 24 16 00 5E 24 17 00 2A 80 82 00 00 10 40 01 61 24 83 00 01 12 20 00 0D 24 09 00 3F 04 40 00 0A 00 02 48 40 8C EA 00 00 01 49 50 21 95 4A 00 00 31 4A 00 01 51 40 00 05 24 09 00 3F 8D 02 00 00 00 49 48 21 81 22 00 01 24 09 00 3F 10 49 00 0D 28 49 00 40 51 20 00 05 24 09 00 5B 50 57 00 44 30 C2 00 04 10 00 01 3A 82 04 00 00 50 49 00 A2 82 0A 00 00 10 4E 00 19 00 00 00 00 10 00 01 34 82 04 00 00 82 02 00 00 14 40 00 03 00 00 00 00 10 00 01 4A 24 02 00 01 11 60 00 03 00 00 00 00 50 4C 01 46 24 02 00 01 52 40 01 38 26 10 00 01 54 53 01 36 26 10 00 01 12 05 01 40 24 02 00 01 51 60 01 32 26 10 00 01 82 02 FF FF 14 4C 01 2F 26 10 00 01 10 00 01 39 24 02 00 01 15 A0 00 12 00 00 00 00 80 82 00 01 10 40 FF E9 24 83 00 02 52 20 01 24 82 04 00 00 04 40 00 0D 00 02 20 40 8C E9 00 00 01 24 48 21 95 29 00 00 31 29 00 01 51 20 00 08 82 04 00 00 8D 02 00 00 00 44 20 21 10 00 00 03 80 82 00 01 12 20 00 0F 24 02 00 5C 82 04 00 00 04 82 01 13 82 04 00 00 8C E9 00 00 00 04 20 40 01 24 48 21 95 29 00 00 31 29 00 01 51 20 01 0C 82 04 00 00 8D 09 00 00 01 24 20 21 10 00 01 08 84 84 00 00 10 00 01 06 82 04 00 00 10 40 00 0F 24 82 00 02 82 03 00 00 24 02 00 2E 54 62 00 0B 24 82 00 02 12 05 01 0C 24 02 00 01 30 C2 00 01 10 40 00 06 24 82 00 02 82 03 FF FF 24 02 00 2F 10 62 01 05 24 02 00 01 24 82 00 02 80 92 00 01 24 03 00 3F 24 04 00 2A 30 C5 00 01 24 07 00 2F 16 43 00 0E 00 00 00 00 10 A0 00 04 00 00 00 00 82 08 00 00 51 07 00 F8 24 02 00 01 56 43 00 05 80 52 00 00 82 08 00 00 11 00 FF A8 26 10 00 01 80 52 00 00 10 00 FF F2 24 42 00 01 12 44 FF F2 00 00 00 00 56 40 00 03 30 C3 00 02 10 00 00 EA 00 00 10 21 14 60 00 04 02 40 98 21 24 03 00 5C 52 43 00 01 80 53 00 00 12 20 00 0F 8F 94 ?? ?? 06 60 00 0D 8F 84 ?? ?? 00 13 18 40 8C 84 00 00 00 83 20 21 94 84 00 00 30 84 00 01 10 80 00 07 8F 97 ?? ?? 8F 84 ?? ?? 8C 84 00 00 00 83 18 21 80 73 00 01 8F 94 ?? ?? 8F 97 ?? ?? 8F 9E ?? ?? 24 16 FF FB 24 55 FF FF 00 D6 B0 24 82 03 00 00 10 60 00 CD 24 02 00 01 24 02 00 5B 12 42 00 11 02 A0 20 21 12 20 00 0C 00 00 00 00 04 60 00 0A 00 03 28 40 8E E2 00 00 00 45 10 21 94 42 00 00 30 42 00 01 10 40 00 04 00 00 00 00 8F C2 00 00 00 45 28 21 84 A3 00 00 54 73 FF EC 26 10 00 01 02 A0 20 21 02 00 28 21 02 80 C8 21 ?? ?? ?? ?? 02 C0 30 21 10 40 FF C9 26 10 00 01 10 00 FF E4 82 03 00 00 11 40 00 B0 24 02 00 01 52 40 00 0B 80 82 00 01 55 53 00 09 80 82 00 01 12 05 00 AB 8F BF 00 3C 51 60 00 05 80 82 00 01 82 02 FF FF 10 4C 00 A6 24 02 00 01 80 82 00 01 24 09 00 21 50 49 00 9F 24 83 00 02 50 56 00 9D 24 83 00 02 00 00 C0 21 80 62 00 00 24 64 00 01 00 0A 78 40 15 A0 00 06 00 40 48 21 14 4E 00 04 00 00 00 00 80 89 00 00 11 20 FF 49 24 84 00 01 12 20 00 0C 00 00 00 00 05 20 00 0A 00 09 18 40 8C F4 00 00 02 83 A0 21 96 94 00 00 32 94 00 01 12 80 00 04 00 00 00 00 8D 09 00 00 01 23 18 21 80 69 00 01 50 40 00 85 24 02 00 01 24 83 00 01 12 20 00 0C 80 82 00 00 04 40 00 0A 00 02 A0 40 8C FE 00 00 03 D4 F0 21 97 DE 00 00 33 DE 00 01 13 C0 00 04 00 00 00 00 8D 02 00 00 00 54 A0 21 82 82 00 01 11 60 00 03 00 00 00 00 50 4C 00 73 24 02 00 01 14 55 00 1C 01 20 A0 21 80 94 00 01 52 99 00 19 01 20 A0 21 15 A0 00 05 24 82 00 02 16 8E 00 03 00 00 00 00 80 94 00 02 24 82 00 03 52 80 00 66 24 02 00 01 12 20 00 0E 24 43 00 01 06 82 00 0D 80 42 00 00 8C E4 00 00 00 14 18 40 00 83 20 21 94 84 00 00 30 84 00 01 50 80 00 05 24 43 00 01 8D 04 00 00 00 83 18 21 80 74 00 01 24 43 00 01 80 42 00 00 12 20 00 0C 01 40 20 21 05 42 00 0B 00 89 48 2A 8C E4 00 00 00 8F 20 21 94 84 00 00 30 84 00 01 50 80 00 04 01 40 20 21 8D 04 00 00 00 8F 20 21 84 84 00 00 00 89 48 2A 15 20 00 11 00 00 00 00 12 20 00 0C 01 40 20 21 05 42 00 0B 02 84 A0 2A 8C E4 00 00 00 8F 20 21 94 84 00 00 30 84 00 01 50 80 00 04 01 40 20 21 8D 04 00 00 00 8F 20 21 84 84 00 00 02 84 A0 2A 12 80 00 0C 00 00 00 00 14 59 FF 9A 00 60 20 21 17 00 FE C5 26 10 00 01 10 00 00 30 24 02 00 01 10 40 FE E3 24 64 00 01 11 A0 00 06 80 62 00 00 00 80 18 21 14 59 FF FA 00 00 00 00 10 00 00 08 00 00 00 00 54 4E FF FB 00 80 18 21 80 64 00 01 10 80 FE D7 24 64 00 02 10 00 FF F6 00 80 18 21 13 00 00 12 26 10 00 01 10 00 00 1C 24 02 00 01 12 20 00 0C 00 00 00 00 04 80 00 0A 00 04 48 40 8C EA 00 00 01 49 50 21 95 4A 00 00 31 4A 00 01 11 40 00 04 00 00 00 00 8D 04 00 00 00 89 48 21 85 24 00 00 14 44 FE C2 26 10 00 01 10 00 FE 9E 00 60 20 21 82 03 00 00 10 60 00 08 30 C6 00 08 10 C0 00 06 24 02 00 01 38 62 00 2F 10 00 00 03 00 02 10 2B 10 00 FF 64 24 18 00 01 8F BF 00 3C 8F BE 00 38 8F B7 00 34 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_847_0_0 {
	meta:
		name = "sysctl"
		size = 196
		refs = "0000 _gp_disp 0010 memset 008c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF A8 8F 99 ?? ?? AF B0 00 40 27 B0 00 18 AF BC 00 10 AF B4 00 50 AF B3 00 4C AF B2 00 48 AF B1 00 44 00 80 98 21 00 A0 90 21 00 C0 88 21 02 00 20 21 AF BF 00 54 00 00 28 21 24 06 00 28 ?? ?? ?? ?? 00 E0 A0 21 8F A2 00 68 8F BC 00 10 AF B3 00 18 AF A2 00 28 8F A2 00 6C AF B2 00 1C AF B1 00 20 AF B4 00 24 AF A2 00 2C 02 00 20 21 24 02 10 39 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 54 02 00 10 21 8F B4 00 50 8F B3 00 4C 8F B2 00 48 8F B1 00 44 8F B0 00 40 03 E0 00 08 27 BD 00 58 }
	condition:
		$1
}

rule file_848_0_0 {
	meta:
		name = "remque"
		size = 32
	strings:
		$1 = { 8C 83 00 00 10 60 00 02 8C 82 00 04 AC 62 00 04 54 40 00 01 AC 43 00 00 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_849_0_0 {
	meta:
		name = "_time_mktime_tzi"
		size = 960
		refs = "0000 _gp_disp 0010 __GI_memcpy 0180 _time_tzset 0308 __time_localtime_tzi"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF 88 8F 99 ?? ?? AF B2 00 58 AF B1 00 54 00 80 90 21 27 B1 00 18 AF BC 00 10 AF B3 00 5C AF B0 00 50 AF BF 00 74 00 C0 80 21 AF BE 00 70 AF B7 00 6C AF B6 00 68 AF B5 00 64 AF B4 00 60 00 A0 98 21 02 20 20 21 02 40 28 21 ?? ?? ?? ?? 24 06 00 2C 82 02 00 28 14 40 00 02 8F BC 00 10 AF A0 00 38 8F A3 00 38 10 60 00 07 00 00 A8 21 24 02 00 01 28 63 00 01 24 04 FF FF 00 83 10 0B AF A2 00 38 24 15 00 01 8F A5 00 2C 24 04 01 90 8F A3 00 28 00 A4 00 1A 00 80 01 F4 24 02 00 0C 00 00 30 12 AF A6 00 30 00 62 00 1A 00 40 01 F4 00 00 10 12 70 C4 38 02 00 A7 20 23 24 05 FF F4 70 45 30 02 00 82 20 21 00 C3 10 21 04 40 00 03 AF A4 00 2C 10 00 00 05 AF A2 00 28 24 42 00 0C 24 84 FF FF AF A2 00 28 AF A4 00 2C 8F A4 00 2C 24 84 07 6C 30 82 00 03 14 40 00 0D AF A4 00 2C 24 02 00 64 00 82 00 1A 00 40 01 F4 00 00 18 10 14 60 00 0A 8F 82 ?? ?? 24 02 01 90 00 82 00 1A 00 40 01 F4 00 00 18 10 50 60 00 04 8F 82 ?? ?? 8F 82 ?? ?? 10 00 00 02 24 42 ?? ?? 24 42 ?? ?? 8F A3 00 28 AF A0 00 34 10 60 00 0A 8F A6 00 34 90 45 00 00 24 63 FF FF 00 C5 30 21 AF A6 00 34 38 A5 00 1D 24 46 FF F5 00 C5 10 0A 10 00 FF F6 24 42 00 01 8F 99 ?? ?? ?? ?? ?? ?? 28 84 07 D7 8F A4 00 2C 24 03 01 6D 3C 05 FF F5 24 82 FF FF 70 43 30 02 24 84 00 02 28 43 00 00 00 43 20 0A 24 03 FF 9C 24 A5 06 C5 00 04 20 83 24 0A 00 18 8F A9 00 20 8F B6 00 18 8F BC 00 10 00 09 6F C3 00 43 00 1A 00 60 01 F4 00 C5 28 21 24 03 01 90 00 A4 28 21 00 00 20 12 00 A4 20 21 8F A5 00 24 00 43 00 1A 00 60 01 F4 00 00 10 12 00 82 10 21 00 40 38 21 8F A4 00 30 72 AA 18 02 00 02 37 C3 3C 02 00 02 24 42 3A 99 00 E0 00 13 00 70 B8 21 8E E3 00 00 00 C0 00 11 02 C3 B0 21 70 82 00 00 00 05 27 C3 8F A3 00 1C 00 16 5F C3 00 03 67 C3 00 00 30 10 00 C4 30 21 8F A4 00 34 00 00 38 12 00 E5 28 21 00 A7 10 2B 00 46 30 21 00 04 17 C3 00 A4 20 21 01 44 00 19 00 85 28 2B 00 C2 30 21 00 A6 30 21 00 00 20 10 00 00 28 12 01 25 40 21 24 05 00 3C 71 46 10 02 01 09 48 2B 00 15 50 0B 02 0A F0 21 00 A8 00 19 00 44 20 21 01 A4 20 21 01 24 20 21 00 00 40 10 00 00 48 12 70 A4 10 02 00 48 40 21 00 69 10 21 00 A2 00 19 00 43 18 2B 01 88 40 21 00 68 40 21 00 00 10 10 00 00 18 12 02 C3 A0 21 02 96 B0 2B 70 A8 20 02 00 82 10 21 01 62 10 21 02 C2 B0 21 3C 02 80 00 02 82 10 21 00 54 10 2B 00 56 10 21 10 40 00 04 8F A3 00 38 24 02 FF FF 10 00 00 22 AF A2 00 44 8F 99 ?? ?? 27 A4 00 44 AF A3 00 48 AF B4 00 44 02 20 28 21 ?? ?? ?? ?? 02 00 30 21 8F A4 00 44 24 02 FF FF 8F BC 00 10 10 82 00 16 8F A3 00 48 04 61 00 0D 8F A2 00 38 10 55 00 0B 00 00 00 00 8E E2 00 00 8F C3 00 00 00 62 18 23 00 03 17 C3 02 83 18 21 00 74 A0 2B 02 C2 B0 21 02 96 B0 21 10 00 FF DE 00 60 A0 21 12 60 00 07 8F BF 00 74 8F 99 ?? ?? 02 40 20 21 02 20 28 21 ?? ?? ?? ?? 24 06 00 2C 8F BF 00 74 8F A2 00 44 8F BE 00 70 8F B7 00 6C 8F B6 00 68 8F B5 00 64 8F B4 00 60 8F B3 00 5C 8F B2 00 58 8F B1 00 54 8F B0 00 50 03 E0 00 08 27 BD 00 78 }
	condition:
		$1
}

rule file_850_0_0 {
	meta:
		name = "__GI_sendto"
		size = 108
		refs = "0000 _gp_disp 0044 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF B0 00 18 AF BF 00 1C 8F B0 00 34 8F A2 00 30 27 BD FF E0 AF A2 00 10 AF B0 00 14 24 02 10 54 00 00 00 0C 27 BD 00 20 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_852_0_0 {
	meta:
		name = "__GI_strdup"
		size = 124
		refs = "0000 _gp_disp 000c __GI_strlen 0034 malloc 004c __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BC 00 10 AF BF 00 24 AF B1 00 20 AF B0 00 1C ?? ?? ?? ?? 00 80 88 21 8F BC 00 10 24 50 00 01 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 00 40 18 21 10 40 00 07 8F BC 00 10 8F 99 ?? ?? 00 40 20 21 02 20 28 21 ?? ?? ?? ?? 02 00 30 21 00 40 18 21 8F BF 00 24 8F B1 00 20 8F B0 00 1C 00 60 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_854_0_0 {
	meta:
		name = "__GI_getdelim"
		size = 424
		refs = "0000 _gp_disp 0054 __GI___errno_location 0078 _pthread_cleanup_push_defer 007c __pthread_mutex_unlock 0094 __pthread_mutex_lock 00b0 __GI___fgetc_unlocked 00cc realloc 0164 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF B0 AF BC 00 10 AF B4 00 38 AF BF 00 4C AF BE 00 48 AF B7 00 44 AF B6 00 40 AF B5 00 3C AF B3 00 34 AF B2 00 30 AF B1 00 2C AF B0 00 28 10 80 00 05 00 80 A0 21 10 A0 00 03 00 A0 98 21 14 E0 00 07 00 E0 80 21 8F 99 ?? ?? ?? ?? ?? ?? 24 12 FF FF 24 03 00 16 10 00 00 43 AC 43 00 00 8C F5 00 34 16 A0 00 0C 00 C0 B0 21 8F 99 ?? ?? 8F 85 ?? ?? 24 F1 00 38 27 A4 00 18 ?? ?? ?? ?? 02 20 30 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8E 91 00 00 52 20 00 01 AE 60 00 00 8F 97 ?? ?? 24 12 00 01 24 1E FF FF 8E 65 00 00 02 45 10 2B 54 40 00 0F 8E 02 00 10 8F 99 ?? ?? 02 20 20 21 ?? ?? ?? ?? 24 A5 00 40 00 40 88 21 14 40 00 03 8F BC 00 10 10 00 00 1C 24 12 FF FF 8E 62 00 00 AE 91 00 00 24 42 00 40 AE 62 00 00 8E 02 00 10 8E 03 00 18 00 43 18 2B 10 60 00 04 24 43 00 01 AE 03 00 10 10 00 00 06 90 42 00 00 02 E0 C8 21 ?? ?? ?? ?? 02 00 20 21 10 5E 00 05 8F BC 00 10 26 52 00 01 02 32 18 21 14 56 FF DF A0 62 FF FE 24 02 00 01 52 42 00 04 24 12 FF FF 26 52 FF FF 02 32 88 21 A2 20 00 00 16 A0 00 06 8F BF 00 4C 8F 99 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F BF 00 4C 02 40 10 21 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_858_0_0 {
	meta:
		name = "__GI_mbrlen"
		size = 56
		refs = "0000 _gp_disp 0024 __GI_mbrtowc"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 00 80 18 21 00 A0 10 21 14 C0 00 03 00 C0 38 21 8F 87 ?? ?? 24 E7 ?? ?? 8F 99 ?? ?? 00 00 20 21 00 60 28 21 ?? ?? ?? ?? 00 40 30 21 }
	condition:
		$1
}

rule file_860_0_0 {
	meta:
		name = "acct"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F D3 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_861_0_0 {
	meta:
		name = "writev"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 32 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_862_0_0 {
	meta:
		name = "pause"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F BD 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_863_0_0 {
	meta:
		name = "splice"
		size = 108
		refs = "0000 _gp_disp 0044 __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF B0 00 18 AF BF 00 1C 8F B0 00 34 8F A2 00 30 27 BD FF E0 AF A2 00 10 AF B0 00 14 24 02 10 D0 00 00 00 0C 27 BD 00 20 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_864_0_0 {
	meta:
		name = "sched_getscheduler"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 41 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_865_0_0 {
	meta:
		name = "difftime"
		size = 124
		refs = "0000 _gp_disp 000c __floatsidf 0054 __subdf3"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BF 00 24 AF B2 00 20 AF B1 00 1C AF B0 00 18 AF BC 00 10 ?? ?? ?? ?? 00 A0 90 21 8F BC 00 10 02 40 20 21 00 60 88 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 80 21 8F BC 00 10 02 20 28 21 02 00 20 21 8F 99 ?? ?? 00 60 38 21 ?? ?? ?? ?? 00 40 30 21 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_866_0_0 {
	meta:
		name = "__GI_sendmsg"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 53 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_867_0_0 {
	meta:
		name = "mkdtemp"
		size = 68
		refs = "0000 _gp_disp 000c __gen_tempname"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 24 05 00 02 AF BF 00 1C AF B0 00 18 AF BC 00 10 ?? ?? ?? ?? 00 80 80 21 8F BF 00 1C 00 02 80 0B 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_868_0_0 {
	meta:
		name = "__GI_ffs"
		size = 116
	strings:
		$1 = { 30 82 FF FF 14 40 00 03 24 03 00 01 00 04 24 03 24 03 00 11 30 82 00 FF 14 40 00 05 30 82 00 0F 24 63 00 08 7C 03 1C 20 00 04 22 03 30 82 00 0F 14 40 00 05 30 82 00 03 24 63 00 04 7C 03 1C 20 00 04 21 03 30 82 00 03 54 40 00 06 24 82 00 01 00 04 20 83 10 80 00 05 24 63 00 02 7C 03 1C 20 24 82 00 01 30 42 00 01 00 62 10 21 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_871_0_0 {
	meta:
		name = "__GI_readdir64"
		size = 264
		refs = "0000 _gp_disp 0010 _pthread_cleanup_push_defer 0014 __pthread_mutex_unlock 004c __pthread_mutex_lock 005c __getdents64 00d0 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 8F 99 ?? ?? 8F 85 ?? ?? AF B2 00 34 AF B1 00 30 27 B2 00 18 24 91 00 18 AF BC 00 10 AF BF 00 3C AF B3 00 38 AF B0 00 2C 02 20 30 21 00 80 80 21 ?? ?? ?? ?? 02 40 20 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 20 20 21 8F BC 00 10 8F 93 ?? ?? 8E 03 00 08 8E 02 00 04 00 43 10 2B 54 40 00 0B 8E 02 00 04 8E 04 00 00 8E 05 00 0C 02 60 C8 21 ?? ?? ?? ?? 8E 06 00 14 18 40 00 12 8F BC 00 10 AE 02 00 08 AE 00 00 04 8E 02 00 04 8E 11 00 0C 02 22 88 21 96 23 00 10 00 62 10 21 AE 02 00 04 8E 22 00 0C AE 02 00 10 8E 22 00 00 8E 23 00 04 00 43 10 25 50 40 FF E7 8E 03 00 08 10 00 00 03 8F 99 ?? ?? 00 00 88 21 8F 99 ?? ?? 02 40 20 21 ?? ?? ?? ?? 24 05 00 01 8F BF 00 3C 02 20 10 21 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_872_0_0 {
	meta:
		name = "vhangup"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 10 0F 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_873_0_0 {
	meta:
		name = "wcsdup"
		size = 128
		refs = "0000 _gp_disp 000c __GI_wcslen 0038 malloc 0050 __GI_memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D8 AF BC 00 10 AF BF 00 24 AF B1 00 20 AF B0 00 1C ?? ?? ?? ?? 00 80 88 21 8F BC 00 10 24 42 00 01 00 02 80 80 8F 99 ?? ?? ?? ?? ?? ?? 02 00 20 21 00 40 18 21 10 40 00 07 8F BC 00 10 8F 99 ?? ?? 00 40 20 21 02 20 28 21 ?? ?? ?? ?? 02 00 30 21 00 40 18 21 8F BF 00 24 8F B1 00 20 8F B0 00 1C 00 60 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_874_0_0 {
	meta:
		name = "__GI_gethostbyname2_r"
		size = 72
		refs = "0000 _gp_disp 0028 __GI_gethostbyname_r"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 24 09 00 02 00 C0 18 21 8F A2 00 10 00 E0 30 21 8F A8 00 14 14 A9 00 07 8F A7 00 18 8F 99 ?? ?? AF A7 00 14 AF A8 00 10 00 60 28 21 ?? ?? ?? ?? 00 40 38 21 03 E0 00 08 24 02 00 01 }
	condition:
		$1
}

rule file_875_0_0 {
	meta:
		name = "__opensock"
		size = 32
		refs = "0000 _gp_disp 000c __GI_socket"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 24 04 00 02 24 05 00 01 ?? ?? ?? ?? 00 00 30 21 }
	condition:
		$1
}

rule file_876_0_0 {
	meta:
		name = "__GI_ungetwc"
		size = 300
		refs = "0000 _gp_disp 0038 _pthread_cleanup_push_defer 0040 __pthread_mutex_unlock 0054 __pthread_mutex_lock 0074 __stdio_trans2r_o 00fc _pthread_cleanup_pop_restore"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF C0 AF B1 00 30 AF B0 00 2C AF BC 00 10 AF BF 00 3C AF B3 00 38 AF B2 00 34 8C B2 00 34 00 80 88 21 16 40 00 0C 00 A0 80 21 8F 99 ?? ?? 24 B3 00 38 8F 85 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 02 60 30 21 8F BC 00 10 8F 99 ?? ?? ?? ?? ?? ?? 02 60 20 21 8F BC 00 10 96 02 00 00 30 42 08 03 2C 42 08 01 14 40 00 07 8F 99 ?? ?? 96 02 00 00 30 43 00 02 54 60 00 0A 30 43 00 01 10 00 00 0E 24 03 FF FF 02 00 20 21 ?? ?? ?? ?? 24 05 08 00 10 40 FF F6 8F BC 00 10 10 00 00 13 24 11 FF FF 54 60 00 11 24 11 FF FF 8E 03 00 28 54 60 00 0E 24 11 FF FF 24 03 FF FF 12 23 00 0B 24 42 00 01 24 03 00 01 30 42 FF FF AE 03 00 28 30 43 00 01 24 63 00 08 00 03 18 80 02 03 18 21 30 42 FF FB AC 71 00 04 A6 02 00 00 16 40 00 06 8F BF 00 3C 8F 99 ?? ?? 27 A4 00 18 ?? ?? ?? ?? 24 05 00 01 8F BF 00 3C 02 20 10 21 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_877_0_0 {
	meta:
		name = "__xpg_basename"
		size = 116
		refs = "0000 _gp_disp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 10 80 00 17 8F 82 ?? ?? 80 82 00 00 10 40 00 13 24 83 FF FF 00 80 10 21 24 06 00 2F 80 85 00 00 50 A6 00 06 24 84 00 01 24 63 00 01 00 64 28 2B 00 85 18 0B 00 85 10 0B 24 84 00 01 80 85 00 00 14 A0 FF F6 00 00 00 00 80 44 00 00 38 84 00 2F 00 44 18 0A 03 E0 00 08 A0 60 00 01 8F 82 ?? ?? 03 E0 00 08 24 42 ?? ?? }
	condition:
		$1
}

rule file_878_0_0 {
	meta:
		name = "__GI_isprint"
		size = 40
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 82 ?? ?? 00 04 20 40 8C 42 00 00 00 44 10 21 94 42 00 00 03 E0 00 08 30 42 00 40 }
	condition:
		$1
}

rule file_879_0_0 {
	meta:
		name = "__GI_alarm"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 27 BD FF E0 AF BC 00 10 AF BF 00 1C AF B0 00 18 24 02 0F BB 00 00 00 0C 10 E0 00 06 00 40 80 21 8F 99 ?? ?? ?? ?? ?? ?? 00 00 00 00 AC 50 00 00 24 10 FF FF 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_880_0_0 {
	meta:
		name = "_ppfs_init"
		size = 232
		refs = "0000 _gp_disp 000c __GI_memset 0070 _ppfs_parsespec"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF D0 24 06 00 98 AF BC 00 10 AF B1 00 20 AF B0 00 1C 00 A0 88 21 00 80 80 21 AF BF 00 2C AF B3 00 28 AF B2 00 24 ?? ?? ?? ?? 00 00 28 21 8E 02 00 18 8F BC 00 10 AE 11 00 00 24 42 FF FF AE 02 00 18 26 03 00 28 24 02 00 09 24 04 00 08 24 42 FF FF AC 64 00 00 14 40 FF FD 24 63 00 04 8F 93 ?? ?? 02 20 10 21 24 12 00 25 80 43 00 00 50 60 00 11 AE 11 00 00 54 72 FF FC 24 42 00 01 24 43 00 01 80 42 00 01 10 52 00 08 02 60 C8 21 AE 03 00 00 ?? ?? ?? ?? 02 00 20 21 04 42 00 07 24 02 FF FF 10 00 FF F1 8E 02 00 00 00 60 10 21 10 00 FF EE 24 42 00 01 00 00 10 21 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_0_0_1 {
	meta:
		name = "lroundf"
		size = 64
		refs = "0000 _gp_disp 000c __extendsfdf2 0030 __GI_lround"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BC 00 10 AF BF 00 1C ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F BF 00 1C 00 60 28 21 8F 99 ?? ?? 00 40 20 21 ?? ?? ?? ?? 27 BD 00 20 }
	condition:
		$1
}

rule file_68_0_1 {
	meta:
		name = "ilogbf"
		size = 64
		refs = "0000 _gp_disp 000c __extendsfdf2 0030 __GI_ilogb"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BC 00 10 AF BF 00 1C ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F BF 00 1C 00 60 28 21 8F 99 ?? ?? 00 40 20 21 ?? ?? ?? ?? 27 BD 00 20 }
	condition:
		$1
}

rule file_60_0_1 {
	meta:
		name = "llrintf"
		size = 64
		refs = "0000 _gp_disp 000c __extendsfdf2 0030 __GI_llrint"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BC 00 10 AF BF 00 1C ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F BF 00 1C 00 60 28 21 8F 99 ?? ?? 00 40 20 21 ?? ?? ?? ?? 27 BD 00 20 }
	condition:
		$1
}

rule file_72_0_1 {
	meta:
		name = "llroundf"
		size = 64
		refs = "0000 _gp_disp 000c __extendsfdf2 0030 __GI_llround"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BC 00 10 AF BF 00 1C ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F BF 00 1C 00 60 28 21 8F 99 ?? ?? 00 40 20 21 ?? ?? ?? ?? 27 BD 00 20 }
	condition:
		$1
}

rule file_75_0_1 {
	meta:
		name = "lrintf"
		size = 64
		refs = "0000 _gp_disp 000c __extendsfdf2 0030 __GI_lrint"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BC 00 10 AF BF 00 1C ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 8F BF 00 1C 00 60 28 21 8F 99 ?? ?? 00 40 20 21 ?? ?? ?? ?? 27 BD 00 20 }
	condition:
		$1
}

rule file_1_0_1 {
	meta:
		name = "floorf"
		size = 88
		refs = "0000 _gp_disp 000c __extendsfdf2 002c __GI_floor 0040 __truncdfsf2"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 00 60 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BC 00 10 00 60 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_23_0_1 {
	meta:
		name = "acosf"
		size = 88
		refs = "0000 _gp_disp 000c __extendsfdf2 002c __GI_acos 0040 __truncdfsf2"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 00 60 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BC 00 10 00 60 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_9_0_1 {
	meta:
		name = "acoshf"
		size = 88
		refs = "0000 _gp_disp 000c __extendsfdf2 002c __GI_acosh 0040 __truncdfsf2"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 00 60 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BC 00 10 00 60 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_84_0_1 {
	meta:
		name = "asinf"
		size = 88
		refs = "0000 _gp_disp 000c __extendsfdf2 002c __GI_asin 0040 __truncdfsf2"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 00 60 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BC 00 10 00 60 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_59_0_1 {
	meta:
		name = "asinhf"
		size = 88
		refs = "0000 _gp_disp 000c __extendsfdf2 002c __GI_asinh 0040 __truncdfsf2"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 00 60 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BC 00 10 00 60 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_81_0_1 {
	meta:
		name = "atanf"
		size = 88
		refs = "0000 _gp_disp 000c __extendsfdf2 002c __GI_atan 0040 __truncdfsf2"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 00 60 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BC 00 10 00 60 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_42_0_1 {
	meta:
		name = "atanhf"
		size = 88
		refs = "0000 _gp_disp 000c __extendsfdf2 002c __GI_atanh 0040 __truncdfsf2"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 00 60 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BC 00 10 00 60 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_78_0_1 {
	meta:
		name = "cbrtf"
		size = 88
		refs = "0000 _gp_disp 000c __extendsfdf2 002c __GI_cbrt 0040 __truncdfsf2"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 00 60 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BC 00 10 00 60 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_48_0_1 {
	meta:
		name = "ceilf"
		size = 88
		refs = "0000 _gp_disp 000c __extendsfdf2 002c __GI_ceil 0040 __truncdfsf2"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 00 60 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BC 00 10 00 60 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_52_0_1 {
	meta:
		name = "cosf"
		size = 88
		refs = "0000 _gp_disp 000c __extendsfdf2 002c __GI_cos 0040 __truncdfsf2"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 00 60 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BC 00 10 00 60 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_61_0_1 {
	meta:
		name = "coshf"
		size = 88
		refs = "0000 _gp_disp 000c __extendsfdf2 002c __GI_cosh 0040 __truncdfsf2"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 00 60 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BC 00 10 00 60 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_14_0_1 {
	meta:
		name = "erfcf"
		size = 88
		refs = "0000 _gp_disp 000c __extendsfdf2 002c __GI_erfc 0040 __truncdfsf2"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 00 60 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BC 00 10 00 60 28 21 8F 99 ?? ?? ?? ?? ?? ?? 00 40 20 21 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_62_0_1 {
	meta:
		name = "erff"
		size = 88
		refs = "0000 _gp_disp 000c __extendsfdf2 002c __GI_erf 0040 __truncdfsf2"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 03 99 E0 21 8F 99 ?? ?? 27 BD FF E0 AF BF 00 1C AF BC 00 10 ?? ?? ?? ?? 00 00 00 00 8F BC 00 10 00 60 28 21 8F 99 ?? ?? ?? ?? 