private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "ARM"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "__fsetlocking"
		size = 48
	strings:
		$1 = { 00 30 90 E5 02 09 13 E3 00 20 A0 E1 01 00 A0 03 02 00 A0 13 00 00 51 E3 ?? ?? ?? ?? 02 39 C3 E3 02 00 51 E3 02 39 83 03 00 30 82 E5 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "prefixcmp"
		size = 36
	strings:
		$1 = { 10 30 90 E5 10 20 91 E5 02 00 53 E1 02 00 00 3A 00 00 A0 03 00 00 E0 13 ?? ?? ?? ?? 01 00 A0 E3 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_1_0 {
	meta:
		name = "scopecmp"
		size = 36
	strings:
		$1 = { 04 30 90 E5 04 20 91 E5 02 00 53 E1 02 00 00 8A 00 00 A0 03 01 00 A0 13 ?? ?? ?? ?? 00 00 E0 E3 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_2_0 {
	meta:
		name = "in6aicmp"
		size = 28
		refs = "0010 memcmp"
	strings:
		$1 = { 08 40 2D E9 08 00 80 E2 08 10 81 E2 10 20 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_3_0 {
	meta:
		name = "match_prefix"
		size = 268
	strings:
		$1 = { F0 03 2D E9 B0 30 D0 E1 02 00 53 E3 20 D0 4D E2 05 00 00 0A 0A 00 53 E3 02 00 A0 11 11 00 00 0A 20 D0 8D E2 F0 03 BD E8 ?? ?? ?? ?? B2 40 D0 E1 04 C0 90 E5 00 30 A0 E3 00 20 E0 E3 0A 00 A0 E3 14 30 8D E5 08 30 8D E5 0C 30 8D E5 10 30 8D E5 1C 30 8D E5 B6 40 CD E1 18 C0 8D E5 B6 21 CD E1 B4 00 CD E1 04 00 8D E2 10 30 91 E5 07 00 53 E3 01 70 81 E2 08 80 80 E2 FF 9C A0 E3 1B 00 00 9A 01 C0 57 E5 08 20 D0 E5 02 00 5C E1 12 00 00 1A 01 C0 88 E2 07 20 A0 E1 05 00 00 EA 00 60 D4 E5 00 40 D5 E5 04 00 56 E1 01 20 82 E2 01 C0 8C E2 09 00 00 1A 08 30 43 E2 07 00 53 E3 02 40 A0 E1 0C 50 A0 E1 F4 FF FF 8A 00 C0 D5 E5 00 20 D4 E5 02 20 2C E0 59 23 12 E0 07 00 00 0A 18 10 81 E2 10 30 91 E5 07 00 53 E3 18 70 87 E2 E3 FF FF 8A 08 50 A0 E1 01 40 A0 E1 F2 FF FF EA 14 00 91 E5 20 D0 8D E2 F0 03 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_4_0 {
	meta:
		name = "gaiconf_init"
		size = 3052
		refs = "002c _IO_new_fopen 0038 fileno 0048 __fxstat64 0090 __getline 00a8 strchr 00bc __aeabi_read_tp 026c strcmp 02cc inet_pton 02f0 strtoul 0418 malloc 0574 free 057c _IO_new_fclose 0634 qsort 08ec fini 0b9c __libc_tsd_CTYPE_B 0ba8 __libc_errno 0bc8 prefixcmp 0bd0 scopecmp"
	strings:
		$1 = { F0 4F 2D E9 88 0B 9F E5 B4 D0 4D E2 00 40 A0 E3 80 1B 9F E5 1C 40 8D E5 20 40 8D E5 1A 40 CD E5 24 40 8D E5 28 40 8D E5 1B 40 CD E5 ?? ?? ?? ?? 00 50 50 E2 34 02 00 0A ?? ?? ?? ?? 48 20 8D E2 00 10 A0 E1 03 00 A0 E3 ?? ?? ?? ?? 00 00 50 E3 59 02 00 1A 00 70 95 E5 02 79 87 E3 2C 00 8D E5 30 00 8D E5 04 00 8D E5 08 00 8D E5 00 70 85 E5 24 9B 9F E5 14 00 8D E5 10 70 17 E2 00 40 A0 E3 39 01 00 1A 2C 00 8D E2 30 10 8D E2 05 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 33 01 00 DA 2C 60 9D E5 23 10 A0 E3 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 70 C0 15 2C 60 9D 15 09 30 9F E7 ?? ?? ?? ?? 00 10 D6 E5 03 30 90 E7 81 20 A0 E1 B2 20 93 E1 02 0A 12 E3 06 00 00 0A 01 20 86 E2 02 60 A0 E1 01 10 D2 E4 81 00 A0 E1 B0 00 93 E1 02 0A 10 E3 F9 FF FF 1A 00 00 51 E3 FF 01 00 0A 01 20 86 E2 02 00 00 EA B1 10 93 E1 02 0A 11 E3 07 01 00 1A 02 A0 A0 E1 00 20 D2 E5 00 00 52 E3 82 10 A0 E1 01 20 8A E2 F6 FF FF 1A B0 00 D3 E1 0A 70 66 E0 02 0A 00 E2 00 10 A0 E3 00 00 50 E3 06 00 00 0A 01 C0 8A E2 0C A0 A0 E1 01 10 DC E4 81 20 A0 E1 B2 20 93 E1 02 0A 12 E3 F9 FF FF 1A 00 00 51 E3 6B 01 00 0A 81 20 A0 E1 B2 20 93 E1 02 0A 12 E3 67 01 00 1A 01 C0 8A E2 02 00 00 EA B2 20 93 E1 02 0A 12 E3 04 00 00 1A 0C B0 A0 E1 01 10 DC E4 00 00 51 E3 81 20 A0 E1 F7 FF FF 1A 06 00 5B E1 EE 00 00 0A 00 00 51 E3 06 00 00 0A 00 30 A0 E3 00 30 CB E5 E4 29 9F E5 ?? ?? ?? ?? 02 30 9F E7 03 30 90 E7 01 B0 8B E2 00 10 DB E5 81 00 A0 E1 B0 20 93 E1 02 0A 12 E3 06 00 00 0A 01 20 8B E2 02 B0 A0 E1 01 10 D2 E4 81 00 A0 E1 B0 C0 93 E1 02 0A 1C E3 F9 FF FF 1A 00 00 51 E3 46 01 00 0A B0 20 93 E1 02 0A 12 E3 43 01 00 1A 01 20 8B E2 02 00 00 EA B0 10 93 E1 02 0A 11 E3 04 00 00 1A 02 C0 A0 E1 01 10 D2 E4 00 00 51 E3 81 00 A0 E1 F7 FF FF 1A 00 30 A0 E3 05 70 47 E2 00 30 CC E5 05 00 57 E3 07 F1 9F 97 33 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 06 00 A0 E1 34 19 9F E5 ?? ?? ?? ?? 00 00 50 E3 28 00 00 1A 1B 10 8D E2 24 20 8D E2 10 10 8D E5 0C 20 8D E5 28 70 8D E2 14 39 9F E5 ?? ?? ?? ?? 00 10 A0 E1 03 30 9F E7 00 60 A0 E3 03 60 81 E7 0A 00 A0 E1 2F 10 A0 E3 ?? ?? ?? ?? 00 80 50 E2 38 40 8D E2 C2 01 00 0A 00 60 C8 E5 0A 10 A0 E1 04 20 A0 E1 0A 00 A0 E3 ?? ?? ?? ?? 06 00 50 E1 10 00 00 0A 01 00 98 E2 BF 01 00 0A 34 C0 8D E2 0C 10 A0 E1 0A 20 A0 E3 00 C0 8D E5 ?? ?? ?? ?? 01 00 70 E3 00 A0 A0 E1 00 C0 9D E5 05 00 00 0A 34 30 9D E5 00 30 D3 E5 06 00 53 E1 01 00 00 1A 80 00 50 E3 B6 01 00 9A 00 70 95 E5 54 FF FF EA 06 00 A0 E1 7C 18 9F E5 ?? ?? ?? ?? 00 40 50 E2 F8 FF FF 1A 70 28 9F E5 ?? ?? ?? ?? 02 30 9F E7 03 40 80 E7 2F 10 A0 E3 0A 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 40 C0 15 00 40 A0 01 01 40 80 12 0A 10 A0 E1 0A 00 A0 E3 38 20 8D E2 ?? ?? ?? ?? 00 00 50 E3 65 01 00 0A 38 30 9D E5 00 00 53 E3 E4 FF FF 1A 3C 30 9D E5 00 00 53 E3 E1 FF FF 1A 40 30 9D E5 01 08 73 E3 DE FF FF 1A 00 00 54 E3 EA 01 00 0A 04 00 A0 E1 34 10 8D E2 0A 20 A0 E3 ?? ?? ?? ?? 01 00 70 E3 00 40 A0 E1 C9 01 00 0A 34 30 9D E5 00 30 D3 E5 00 00 53 E3 D1 FF FF 1A 60 30 44 E2 20 00 53 E3 CE FF FF 8A 0B 00 A0 E1 34 10 8D E2 0A 20 A0 E3 ?? ?? ?? ?? 01 00 70 E3 00 60 A0 E1 CE 01 00 0A 34 30 9D E5 00 30 D3 E5 00 00 53 E3 C3 FF FF 1A 00 00 56 E3 C1 FF FF BA 10 00 A0 E3 ?? ?? ?? ?? 00 00 50 E3 62 01 00 0A 60 00 54 E3 80 30 64 12 00 20 E0 13 12 23 A0 11 62 38 22 10 23 34 A0 11 FF 3C C3 13 62 34 23 10 04 10 9D E5 44 20 9D E5 00 30 A0 03 02 20 03 E0 60 00 54 E3 01 10 81 03 48 00 80 E9 08 30 9D E5 FF 40 01 E2 14 10 9D E5 01 30 83 E2 04 40 8D E5 0C 10 80 E5 08 30 8D E5 00 20 80 E5 14 00 8D E5 A4 FF FF EA 06 00 A0 E1 20 17 9F E5 ?? ?? ?? ?? 00 00 50 E3 9F FF FF 1A 00 30 DA E5 79 30 73 E2 1B 00 00 1A 01 30 DA E5 65 30 73 E2 18 00 00 1A 02 30 DA E5 73 30 73 E2 15 00 00 1A 03 30 DA E5 01 30 73 E2 00 30 A0 33 E4 26 9F E5 00 00 53 E3 0C 30 82 E5 8F FF FF 0A 01 30 A0 E3 10 30 82 E5 00 70 95 E5 E2 FE FF EA 06 00 A0 E1 C4 16 9F E5 ?? ?? ?? ?? 00 00 50 E3 86 FF FF 1A 1A 30 8D E2 1C 00 8D E2 10 30 8D E5 20 70 8D E2 0C 00 8D E5 5C FF FF EA 01 30 73 E2 94 26 9F E5 00 30 A0 33 0C 30 82 E5 00 70 95 E5 D1 FE FF EA 00 40 CA E5 84 16 9F E5 ?? ?? ?? ?? 01 30 9F E7 01 10 DA E5 03 30 90 E7 81 00 A0 E1 B0 00 93 E1 0A 70 66 E0 02 0A 00 E2 02 A0 A0 E1 F5 FE FF EA 00 70 95 E5 10 70 17 E2 C5 FE FF 0A 2C 00 9D E5 14 40 9D E5 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? 20 30 9D E5 00 00 53 E3 65 00 00 1A 28 30 9D E5 2C 96 9F E5 00 00 53 E3 09 70 A0 E1 90 00 00 0A 1B 50 DD E5 00 00 55 E3 01 30 83 02 83 00 83 E0 80 01 A0 E1 28 30 8D 05 03 A0 A0 E1 ?? ?? ?? ?? 00 80 50 E2 4F 01 00 0A 00 00 55 E3 39 01 00 0A 00 00 5A E3 24 50 9D E5 01 B0 4A E2 8A A0 8A C0 8A A1 88 C0 05 60 A0 C1 0A 00 00 DA 06 E0 A0 E1 0F 00 BE E8 18 C0 4A E2 0F 00 AC E8 03 00 9E E8 03 00 8C E8 01 B0 4B E2 01 00 7B E3 18 A0 4A E2 18 60 96 E5 F4 FF FF 1A 00 00 55 E3 05 00 A0 11 8B 00 00 1A 08 00 A0 E1 28 10 9D E5 18 20 A0 E3 90 35 9F E5 ?? ?? ?? ?? 08 00 9D E5 00 00 50 E3 84 65 9F E5 6B 00 00 0A 04 10 9D E5 00 00 51 E3 01 00 80 02 08 00 8D 05 08 20 9D E5 82 00 82 E0 00 01 A0 E1 ?? ?? ?? ?? 00 50 50 E2 7D 00 00 0A 04 30 9D E5 00 00 53 E3 08 C0 9D E5 07 00 00 1A 01 C0 4C E2 8C 20 8C E0 02 21 A0 E1 04 00 9D E5 02 30 85 E0 0E 10 A0 E3 02 00 85 E7 03 00 83 E9 00 00 5C E3 01 E0 4C E2 8C C0 8C C0 0C C1 85 C0 04 30 A0 C1 06 00 00 DA 07 00 93 E8 0C C0 4C E2 07 00 8C E8 01 E0 4E E2 01 00 7E E3 0C 30 93 E5 F8 FF FF 1A 00 00 54 E3 04 00 A0 11 01 00 00 1A 04 00 00 EA 0A 00 A0 E1 0C A0 90 E5 ?? ?? ?? ?? 00 00 5A E3 FA FF FF 1A 08 10 9D E5 05 00 A0 E1 0C 20 A0 E3 C4 34 9F E5 ?? ?? ?? ?? C0 A4 9F E5 3A 00 00 EA 0A B0 A0 E1 9F FE FF EA 0B C0 A0 E1 C3 FE FF EA 1A 50 DD E5 00 00 55 E3 01 30 83 02 83 00 83 E0 80 01 A0 E1 20 30 8D 05 03 80 A0 E1 ?? ?? ?? ?? 00 70 50 E2 4C 00 00 0A 00 00 55 E3 CB 00 00 0A 00 00 58 E3 1C 50 9D E5 01 90 48 E2 88 80 88 C0 88 81 87 C0 05 60 A0 C1 0A 00 00 DA 06 E0 A0 E1 0F 00 BE E8 18 C0 48 E2 0F 00 AC E8 03 00 9E E8 03 00 8C E8 01 90 49 E2 01 00 79 E3 18 80 48 E2 18 60 96 E5 F4 FF FF 1A 00 00 55 E3 05 00 A0 11 01 00 00 1A 04 00 00 EA 06 00 A0 E1 18 60 90 E5 ?? ?? ?? ?? 00 00 56 E3 FA FF FF 1A 00 34 9F E5 07 00 A0 E1 20 10 9D E5 18 20 A0 E3 ?? ?? ?? ?? 28 30 9D E5 00 00 53 E3 E0 93 9F E5 6E FF FF 1A 08 00 9D E5 DC 63 9F E5 00 00 50 E3 06 80 A0 E1 93 FF FF 1A D4 A3 9F E5 0A 50 A0 E1 B0 43 9F E5 00 00 94 E5 09 00 50 E1 00 70 84 E5 ?? ?? ?? ?? 04 00 94 E5 06 00 50 E1 04 80 84 E5 ?? ?? ?? ?? 08 00 94 E5 0A 00 50 E1 08 50 84 E5 ?? ?? ?? ?? 98 30 8D E2 03 00 93 E8 94 33 9F E5 03 00 83 E8 B4 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 06 00 A0 E1 18 60 90 E5 ?? ?? ?? ?? 00 00 56 E3 FA FF FF 1A 6E FF FF EA 09 00 57 E1 07 00 A0 11 ?? ?? ?? ?? 06 00 58 E1 08 00 A0 11 ?? ?? ?? ?? 1C 00 9D E5 00 00 50 E3 01 00 00 1A 04 00 00 EA 05 00 A0 E1 18 50 90 E5 ?? ?? ?? ?? 00 00 55 E3 FA FF FF 1A 24 00 9D E5 00 00 50 E3 01 00 00 1A 04 00 00 EA 05 00 A0 E1 18 50 90 E5 ?? ?? ?? ?? 00 00 55 E3 FA FF FF 1A 00 00 54 E3 04 00 A0 11 01 00 00 1A 04 00 00 EA 05 00 A0 E1 0C 50 90 E5 ?? ?? ?? ?? 00 00 55 E3 FA FF FF 1A ?? ?? ?? ?? B4 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 01 00 A0 E1 01 70 A0 E1 06 A0 A0 E1 09 FE FF EA 05 40 A0 E1 DA FF FF EA 0A 10 A0 E1 02 00 A0 E3 44 20 8D E2 ?? ?? ?? ?? 00 00 50 E3 7B FE FF 0A 00 00 54 E3 90 00 00 0A 34 C0 8D E2 04 00 A0 E1 0C 10 A0 E1 0A 20 A0 E3 00 C0 8D E5 ?? ?? ?? ?? 01 00 70 E3 00 40 A0 E1 00 C0 9D E5 6F FE FF 0A 34 30 9D E5 00 30 D3 E5 00 00 53 E3 6B FE FF 1A 20 00 50 E3 69 FE FF 8A 0B 00 A0 E1 0C 10 A0 E1 0A 20 A0 E3 ?? ?? ?? ?? 01 00 70 E3 00 60 A0 E1 72 00 00 0A 34 30 9D E5 00 30 D3 E5 00 00 53 E3 5E FE FF 1A 00 00 56 E3 60 40 84 A2 99 FE FF AA 5A FE FF EA 2C 00 9D E5 14 40 9D E5 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? AD FF FF EA 0A 10 A0 E1 04 20 A0 E1 0A 00 A0 E3 ?? ?? ?? ?? 00 00 50 E3 4E FE FF 0A 34 30 9D E5 00 30 D3 E5 00 00 53 E3 80 A0 A0 03 34 C0 8D 02 48 FE FF 1A 0B 00 A0 E1 0C 10 A0 E1 0A 20 A0 E3 ?? ?? ?? ?? 01 00 70 E3 00 B0 A0 E1 41 00 00 0A 34 30 9D E5 00 30 D3 E5 00 00 53 E3 3D FE FF 1A 00 00 5B E3 3B FE FF BA 1C 00 A0 E3 ?? ?? ?? ?? 00 C0 50 E2 DC FF FF 0A 0F 00 94 E8 0F 00 8C E8 10 30 9D E5 00 10 97 E5 0C 00 9D E5 00 20 D3 E5 01 10 81 E2 00 30 90 E5 00 10 87 E5 10 10 9D E5 00 00 5A E3 01 20 82 03 10 A0 8C E5 14 B0 8C E5 00 20 C1 E5 18 30 8C E5 00 C0 80 E5 25 FE FF EA 01 80 48 E2 88 10 88 E0 81 11 A0 E1 01 30 87 E0 08 20 83 E2 01 50 87 E7 04 50 83 E5 04 50 82 E4 01 10 A0 E3 00 50 82 E5 10 50 83 E5 14 10 83 E5 26 FF FF EA 01 A0 4A E2 8A 10 8A E0 81 11 A0 E1 01 30 88 E0 08 20 83 E2 01 50 88 E7 04 50 83 E5 04 50 82 E4 28 10 A0 E3 00 50 82 E5 10 50 83 E5 14 10 83 E5 B8 FE FF EA E8 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 22 00 53 E3 2F FE FF 1A 04 FE FF EA 09 00 57 E1 5B FF FF 0A 07 00 A0 E1 ?? ?? ?? ?? 58 FF FF EA BC 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 22 00 53 E3 B7 FF FF 1A F8 FD FF EA A4 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 22 00 53 E3 2A FE FF 1A F1 FD FF EA 80 40 A0 E3 19 FE FF EA 84 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 22 00 53 E3 86 FF FF 1A E8 FD FF EA 34 30 9D E5 00 30 D3 E5 00 00 53 E3 E4 FD FF 1A 20 40 A0 E3 34 C0 8D E2 77 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_5_0 {
	meta:
		name = "gaih_inet_serv.isra.2"
		size = 184
		refs = "0048 __getservbyname_r"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 24 D0 4D E2 01 80 A0 E1 00 70 A0 E1 02 A0 A0 E1 03 90 A0 E1 0A 60 81 E2 01 4B A0 E3 38 50 4B E2 0E 30 84 E2 07 30 C3 E3 03 D0 4D E0 30 00 8D E8 08 30 8D E2 07 00 A0 E1 06 10 A0 E1 34 20 4B E2 ?? ?? ?? ?? 00 00 50 E3 0F 00 00 1A 38 30 1B E5 00 00 53 E3 0F 00 00 0A 00 20 98 E5 05 00 89 E8 08 20 D8 E5 02 00 12 E3 0E 00 00 0A 00 20 9A E5 08 30 93 E5 00 00 A0 E3 08 20 89 E5 0C 30 89 E5 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 22 00 50 E3 84 40 A0 01 E1 FF FF 0A 42 0F A0 E3 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 04 20 98 E5 EF FF FF EA }
	condition:
		$1
}

rule file_1_6_0 {
	meta:
		name = "gaih_inet"
		size = 8820
		refs = "0204 __idna_to_ascii_lz 0250 __inet_aton 02c8 free 0398 memcpy 03bc malloc 047c strchr 04a4 inet_pton 0510 strtoul 07dc __idna_to_unicode_lzlz 092c __aeabi_read_tp 0940 __res_maybe_init 0a04 __nss_lookup_function 0ae8 _dl_mcount_wrapper_check 0b50 realloc 0eec in6addr_loopback 0ef4 __nss_not_use_nscd_hosts 0ef8 __nss_database_custom 0efc __nss_hosts_database 0f00 _res_hconf 0f04 __libc_resp 0f10 __libc_errno 0f14 __libc_h_errno 130c __strdup 149c __gethostbyname2_r 151c __nscd_getai 1718 strlen 1790 if_nametoindex 17c0 __libc_alloca_cutoff 18b0 __gethostbyaddr_r 1d64 __nss_database_lookup 1d98 _res_hconf_init 1e34 mempcpy 1e54 __assert_fail 1e6c __strndup"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 A4 D0 4D E2 0C C0 92 E5 BC 4E 9F E5 02 90 A0 E1 00 00 5C E3 00 20 A0 E3 68 00 0B E5 01 50 A0 E1 5C 30 0B E5 50 40 0B E5 4C 20 0B E5 08 00 99 E5 01 00 00 1A 00 00 50 E3 20 00 00 0A 8C 3E 9F E5 00 00 50 E3 14 10 43 E2 0A 00 00 0A 14 20 13 E5 00 00 52 E1 07 00 00 0A 14 30 83 E2 0A 20 53 E5 00 00 52 E3 F5 FF FF 1A 64 0E 9F E5 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 00 00 5C E3 10 00 00 0A 0C 20 53 E5 02 00 12 E3 0D 00 00 1A 10 20 13 E5 02 00 5C E1 0A 00 00 0A 14 30 83 E2 0A 20 53 E5 00 00 52 E3 E5 FF FF 1A 00 00 50 E3 ED FF FF 1A 42 0F A0 E3 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 10 1E 9F E5 00 00 55 E3 0A 00 00 0A 08 30 D1 E5 01 00 13 E3 F5 FF FF 1A 04 30 95 E5 00 00 53 E3 31 01 00 BA 03 58 A0 E1 03 34 A0 E1 25 5C 83 E1 05 58 A0 E1 25 58 A0 E1 00 00 50 E3 1B 00 00 1A 00 00 5C E3 19 00 00 1A 1E 30 D1 E5 00 00 53 E3 19 04 00 0A 28 10 81 E2 0C 40 A0 E1 50 20 4B E2 03 00 00 EA 14 10 81 E2 0A 30 51 E5 00 00 53 E3 65 00 00 0A 0B 30 51 E5 00 00 53 E3 F8 FF FF 0A 18 D0 4D E2 14 60 11 E5 10 00 11 E5 18 30 8D E2 18 40 8D E5 24 50 8D E5 1C 60 8D E5 20 00 8D E5 10 C0 8C E2 00 30 82 E5 03 20 A0 E1 EC FF FF EA 08 40 D1 E5 18 D0 4D E2 00 20 91 E5 02 00 14 E3 18 30 8D E2 00 00 A0 E3 04 C0 91 05 05 00 83 E8 50 30 0B E5 08 C0 83 E5 0C 50 83 E5 30 40 A0 E3 8C 40 0B E5 68 40 1B E5 00 00 54 E3 3A 01 00 0A 00 20 99 E5 28 D0 4D E2 18 30 8D E2 00 10 A0 E3 40 00 12 E2 4C 30 0B E5 08 10 83 E5 1C 10 83 E5 00 10 83 E5 96 00 00 0A 00 30 A0 E3 24 40 4B E2 02 0C 12 E3 14 30 24 E5 22 24 A0 E1 01 20 02 E2 02 20 82 13 04 10 A0 E1 68 00 1B E5 ?? ?? ?? ?? 00 00 50 E3 48 00 0B E5 05 00 00 0A C9 00 50 E3 8D 01 00 0A CA 00 50 E3 69 00 A0 13 0B 00 A0 03 A3 FF FF EA 38 40 1B E5 68 C0 1B E5 74 40 0B E5 04 40 5C E0 01 40 A0 13 4C 10 1B E5 90 40 0B E5 0C 10 81 E2 74 00 1B E5 ?? ?? ?? ?? 00 00 50 E3 20 00 00 0A 04 30 99 E5 02 C0 D3 E3 79 00 00 0A 0A 00 53 E3 9E 03 00 0A 00 40 A0 E3 6C 40 0B E5 88 40 0B E5 7C 40 0B E5 84 40 0B E5 80 40 0B E5 78 40 0B E5 09 A0 A0 E3 90 40 1B E5 00 00 54 E3 C2 00 00 1A 78 40 1B E5 00 00 54 E3 BC 00 00 1A 84 40 1B E5 00 00 54 E3 B6 00 00 1A 88 40 1B E5 00 00 54 E3 0A 00 A0 01 7D FF FF 0A 6C 00 1B E5 ?? ?? ?? ?? 0A 00 A0 E1 79 FF FF EA 20 C0 8C E2 8C C0 0B E5 B2 FF FF EA 4C A0 1B E5 08 60 9A E5 00 00 56 E3 60 00 00 0A 60 00 0B E5 00 40 A0 E3 6C 40 0B E5 88 40 0B E5 7C 40 0B E5 84 40 0B E5 80 40 0B E5 78 40 0B E5 94 40 0B E5 60 70 1B E5 5C 80 1B E5 0A 50 A0 E1 70 A0 0B E5 00 40 A0 E3 09 A0 A0 E1 70 C0 1B E5 0C 00 55 E1 19 01 00 0A 70 C0 1B E5 08 90 9C E5 09 98 A0 E1 29 58 A0 E1 0A 00 55 E3 10 C0 A0 13 5C C0 0B 15 C8 00 00 0A 50 60 1B E5 00 00 56 E3 7A 00 00 0A 5C 30 1B E5 70 C0 1B E5 29 98 A0 E1 20 30 83 E2 0C C0 8C E2 60 90 0B E5 58 30 0B E5 64 C0 0B E5 0B 00 00 EA 24 00 80 E2 64 10 1B E5 04 20 A0 E3 B2 E2 C9 E1 ?? ?? ?? ?? 28 40 89 E5 2C 40 89 E5 00 60 96 E5 00 00 56 E3 1C 80 89 E2 65 00 00 0A 00 70 A0 E3 58 00 1B E5 ?? ?? ?? ?? 00 00 50 E3 00 90 A0 E1 00 00 88 E5 6A 00 00 0A 00 10 9A E5 60 30 1B E5 04 20 96 E5 5C C0 1B E5 0A 00 80 E8 08 10 96 E5 0A 00 55 E3 08 20 80 E5 20 20 80 E2 0C 10 80 E5 10 C0 80 E5 18 70 80 E5 B0 52 C0 E1 1C 40 80 E5 14 20 80 E5 0C E0 96 E5 DC FF FF 1A 10 20 A0 E3 28 00 80 E2 64 10 1B E5 B2 E2 C9 E1 24 40 89 E5 ?? ?? ?? ?? 70 C0 1B E5 1C 20 9C E5 38 20 89 E5 D9 FF FF EA 68 40 1B E5 03 10 A0 E1 90 00 0B E5 74 40 0B E5 7D FF FF EA 4C A0 1B E5 02 30 A0 E3 08 30 8A E5 00 30 99 E5 74 40 1B E5 02 30 13 E2 04 30 A0 11 60 30 0B E5 9F FF FF EA 74 00 1B E5 25 10 A0 E3 ?? ?? ?? ?? 00 50 90 E2 01 50 A0 13 00 00 55 E3 00 40 A0 E1 74 60 1B 05 41 06 00 1A 06 10 A0 E1 0C 20 8A E2 0A 00 A0 E3 ?? ?? ?? ?? 00 60 A0 E1 00 00 56 E3 26 03 00 DA 04 30 99 E5 00 00 53 E3 0A 00 53 13 00 20 A0 13 01 20 A0 03 06 02 00 1A 4C A0 1B E5 0A 30 A0 E3 08 30 8A E5 00 00 55 E3 EA 00 00 0A 0C 10 9A E5 F8 39 9F E5 F8 29 9F E5 03 30 01 E0 02 00 53 E1 A3 04 00 0A 0C 30 DA E5 FF 00 53 E3 9C 04 00 0A 01 00 84 E2 38 10 4B E2 0A 20 A0 E3 ?? ?? ?? ?? 38 30 1B E5 1C 00 8A E5 00 30 D3 E5 00 00 53 E3 D7 00 00 0A 00 40 A0 E3 6C 40 0B E5 88 40 0B E5 7C 40 0B E5 84 40 0B E5 80 40 0B E5 78 40 0B E5 F4 A9 9F E5 50 FF FF EA 06 70 A0 E1 04 00 9B E5 00 30 90 E5 01 30 83 E2 00 30 80 E5 70 C0 1B E5 00 C0 9C E5 00 00 5C E3 70 C0 0B E5 A4 04 00 0A 4C 50 1B E5 6B FF FF EA 07 00 A0 E1 60 70 0B E5 ?? ?? ?? ?? 0A A0 A0 E3 3F FF FF EA 7C 00 1B E5 ?? ?? ?? ?? 45 FF FF EA 80 00 1B E5 ?? ?? ?? ?? 3F FF FF EA 74 00 1B E5 ?? ?? ?? ?? 39 FF FF EA 0A A0 D1 E5 00 00 5A E3 A6 00 00 1A 1E 30 D1 E5 00 00 53 E3 BA FE FF 0A 50 C0 4B E2 28 60 81 E2 58 C0 0B E5 0C 80 89 E2 06 00 00 EA 14 00 16 E5 00 00 52 E1 0A 00 00 0A 14 60 86 E2 0A 30 56 E5 00 00 53 E3 8F 00 00 0A 0C 30 56 E5 01 00 13 E3 14 10 46 E2 F7 FF FF 1A 08 20 99 E5 00 00 52 E3 F1 FF FF 1A 0C 20 99 E5 00 00 52 E3 04 00 00 0A 02 00 13 E3 02 00 00 1A 10 30 16 E5 03 00 52 E1 EC FF FF 1A 18 D0 4D E2 18 70 8D E2 07 30 A0 E1 00 00 95 E5 08 20 A0 E1 3D FE FF EB 00 00 50 E3 10 A0 8A E2 48 00 0B E5 02 00 00 0A 01 0C 10 E3 E0 FF FF 1A 93 FE FF EA 58 C0 1B E5 58 70 0B E5 00 70 8C E5 DB FF FF EA 94 00 1B E5 00 00 50 E3 42 00 00 0A 00 30 9A E5 18 30 03 E2 08 00 53 E3 35 00 00 0A 1C C0 A0 E3 5C C0 0B E5 2C FF FF EA 28 D0 4D E2 68 40 1B E5 18 A0 8D E2 0A 30 A0 E1 04 40 83 E4 04 30 83 E2 04 40 8A E5 04 40 83 E4 04 40 83 E4 04 40 83 E4 04 40 83 E4 04 40 83 E4 00 40 83 E5 04 30 99 E5 00 00 53 E3 4C A0 0B E5 71 02 00 0A 00 00 53 E3 0A 00 53 13 0A 20 A0 11 09 00 00 1A 00 10 99 E5 01 00 11 E3 E4 37 9F 05 0A 20 A0 E3 08 20 8A E5 0F 00 93 08 0C C0 8A 02 0F 00 8C 08 04 30 99 05 00 20 9A E5 02 30 D3 E3 38 00 00 1A 00 10 99 E5 02 00 A0 E3 01 10 11 E2 08 00 82 E5 79 02 00 1A AC 37 9F E5 60 10 0B E5 74 10 0B E5 6C 10 0B E5 88 10 0B E5 7C 10 0B E5 84 10 0B E5 80 10 0B E5 78 10 0B E5 90 10 0B E5 94 10 0B E5 0C 30 82 E5 E8 FE FF EA 0C 30 9C E5 00 00 53 E3 05 00 00 1A 10 30 9C E5 00 00 53 E3 C3 FF FF 1A 14 30 9C E5 01 08 73 E3 72 FF FF 0A 1C 30 A0 E3 5C 30 0B E5 ED FE FF EA 00 30 9A E5 02 00 13 E3 E2 FE FF 0A 00 00 57 E3 00 90 A0 13 09 60 A0 11 26 04 00 0A 80 00 13 E3 CB 02 00 0A 02 0C 13 E3 23 34 A0 E1 01 20 03 E2 02 20 82 13 07 00 A0 E1 38 10 4B E2 ?? ?? ?? ?? 00 00 50 E3 0C 06 00 1A 38 30 1B E5 07 00 53 E1 03 70 A0 11 BE 02 00 0A 00 00 59 E3 CD FE FF 0A 06 00 A0 E1 ?? ?? ?? ?? CA FE FF EA 00 40 A0 E3 60 40 0B E5 74 40 0B E5 6C 40 0B E5 88 40 0B E5 7C 40 0B E5 84 40 0B E5 80 40 0B E5 78 40 0B E5 90 40 0B E5 94 40 0B E5 B5 FE FF EA 50 30 1B E5 04 00 53 E1 1B FE FF 0A 20 A0 8A E2 8C A0 0B E5 55 FE FF EA 0A 00 A0 E3 17 FE FF EA 18 D0 4D E2 18 C0 8D E2 00 00 95 E5 0C 30 A0 E1 0C 20 89 E2 50 C0 0B E5 B3 FD FF EB 00 00 50 E3 48 00 0B E5 47 FE FF 0A 0C FE FF EA 4C A0 1B E5 00 30 99 E5 02 30 13 E2 74 40 1B 15 60 30 0B 05 08 30 9A 15 08 30 9A 05 60 40 0B 15 00 00 53 E3 90 FE FF 1A 00 20 99 E5 04 00 12 E3 A9 00 00 1A 04 20 99 E5 02 00 52 E3 44 30 0B E5 CC 02 00 0A 20 46 9F E5 00 20 94 E5 00 00 52 E3 B0 02 00 DA 01 20 82 E2 64 00 52 E3 00 20 84 D5 00 30 84 C5 03 00 00 DA 00 36 9F E5 04 30 D3 E5 00 00 53 E3 01 03 00 0A F4 35 9F E5 00 10 93 E5 00 00 51 E3 11 05 00 0A 44 10 0B E5 00 40 A0 E3 E0 35 9F E5 00 30 93 E5 00 00 53 E3 1B 05 00 0A D4 35 9F E5 ?? ?? ?? ?? 03 30 9F E7 00 50 A0 E1 00 10 A0 E3 03 00 90 E7 ?? ?? ?? ?? BC 35 9F E5 03 30 9F E7 03 60 95 E7 8C 20 1B E5 08 10 96 E5 42 2E 82 E2 01 00 70 E3 01 40 A0 03 02 5A C1 E3 01 0A 52 E3 98 10 0B E5 64 20 0B E5 08 50 86 E5 BA 05 00 8A 42 3E 4D E2 08 D0 43 E2 18 C0 8D E2 00 00 A0 E3 6C C0 0B E5 88 00 0B E5 00 00 54 E3 AB 05 00 1A 04 A0 A0 E1 00 40 E0 E3 7C A0 0B E5 84 A0 0B E5 94 A0 0B E5 4C 60 4B E2 80 A0 0B E5 44 00 1B E5 78 40 0B E5 6C 70 1B E5 88 A0 1B E5 70 90 0B E5 42 5E A0 E3 04 C0 A0 E1 06 90 A0 E1 70 40 1B E5 04 40 94 E5 00 00 54 E3 6C 40 0B E5 21 00 00 0A 70 40 1B E5 00 30 94 E5 02 00 13 E3 78 02 00 1A 08 15 9F E5 A8 C0 0B E5 ?? ?? ?? ?? 00 80 50 E2 A8 C0 1B E5 E0 00 00 1A F4 14 9F E5 ?? ?? ?? ?? 01 30 9F E7 03 30 90 E7 02 30 D3 E3 C5 04 00 0A E0 24 9F E5 00 C0 E0 E3 02 30 9F E7 01 40 A0 E3 03 C0 80 E7 6C 40 0B E5 08 60 A0 E1 44 30 1B E5 6C 00 1B E5 00 41 83 E0 04 20 94 E5 01 00 52 E3 AE 04 00 0A 00 00 93 E5 00 00 50 E3 A8 00 00 0A 44 00 0B E5 D8 FF FF EA 9C 14 9F E5 A8 C0 0B E5 ?? ?? ?? ?? 00 80 50 E2 A8 C0 1B E5 D3 05 00 0A 38 C0 4B E2 58 C0 0B E5 48 40 4B E2 6C 60 1B E5 0F 00 00 EA 64 00 1B E5 85 30 A0 E1 00 20 83 E0 01 0A 52 E3 BE 05 00 8A 0F 30 83 E2 0F 30 C3 E3 08 10 83 E2 01 D0 4D E0 18 00 8D E2 03 10 80 E0 01 00 57 E1 70 00 00 0A 64 20 0B E5 03 50 A0 E1 00 70 A0 E1 08 00 A0 E1 48 60 0B E5 ?? ?? ?? ?? 00 40 8D E5 58 C0 1B E5 08 60 8D E5 04 C0 8D E5 74 00 1B E5 09 10 A0 E1 07 20 A0 E1 05 30 A0 E1 0F E0 A0 E1 ?? ?? ?? ?? 01 00 50 E3 29 00 00 0A 02 00 70 E3 22 00 00 1A 48 30 1B E5 22 00 53 E3 1C 00 00 1A 38 30 1B E5 01 00 73 E3 11 00 00 1A 00 00 5A E3 D6 FF FF 0A 85 50 A0 E1 07 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 51 00 00 0A 01 A0 A0 E3 DD FF FF EA 6C 30 0B E5 88 30 0B E5 7C 30 0B E5 84 30 0B E5 80 30 0B E5 78 30 0B E5 BC A3 9F E5 C2 FD FF EA 00 C0 A0 E1 02 00 53 E3 7A 01 00 0A 04 30 53 E2 00 60 73 E2 03 60 B6 E0 80 60 0B E5 A8 FF FF EA 00 C0 A0 E1 38 30 1B E5 F5 FF FF EA 02 40 80 E2 00 C0 A0 E1 38 30 1B E5 6C 40 0B E5 F2 FF FF EA 70 40 1B E5 00 30 94 E5 02 00 13 E3 00 C0 A0 E1 62 01 00 1A 00 30 99 E5 60 E3 9F E5 01 60 A0 E3 00 00 A0 E3 00 00 53 E3 0C 00 00 0A 08 10 93 E5 70 40 1B E5 02 00 51 E3 04 20 94 E5 0E 00 00 0A 00 00 52 E3 08 00 00 0A 01 00 52 E1 19 00 00 0A 00 30 93 E5 00 00 53 E3 00 30 89 E5 F2 FF FF 1A 03 40 A0 E3 6C 40 0B E5 DA FF FF EA 03 90 A0 E1 02 60 A0 E1 00 30 93 E5 E9 FF FF EA 0A 00 52 E3 EE FF FF 1A 00 10 94 E5 08 00 11 E3 EF FF FF 0A 0C 10 93 E5 08 20 83 E5 14 E0 83 E5 10 00 83 E5 18 10 83 E5 0C 00 83 E5 03 90 A0 E1 00 60 A0 E3 00 30 93 E5 DA FF FF EA 0A 00 52 E3 01 40 A0 03 03 90 A0 E1 00 60 A0 E3 00 30 93 E5 94 40 0B 05 D3 FF FF EA 03 50 85 E0 64 20 0B E5 8D FF FF EA 88 A0 0B E5 6C 70 0B E5 68 22 9F E5 00 30 A0 E1 02 20 9F E7 ?? ?? ?? ?? 02 20 90 E7 98 40 1B E5 08 00 92 E5 80 30 0B E5 02 1A 04 E2 80 40 1B E5 01 30 80 E1 08 30 82 E5 78 40 0B E5 0A A0 A0 E3 69 FD FF EA 02 00 53 E3 AD 01 00 0A 6C 20 0B E5 88 20 0B E5 7C 20 0B E5 84 20 0B E5 80 20 0B E5 78 20 0B E5 09 A0 A0 E3 5F FD FF EA 88 A0 0B E5 6C 70 0B E5 00 32 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 80 A0 1B E5 70 90 1B E5 08 50 93 E5 98 40 1B E5 02 2A 04 E2 02 50 85 E1 08 50 83 E5 D8 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 01 00 73 E3 EA 03 00 0A 00 00 5A E3 00 00 56 13 00 30 A0 03 01 30 A0 13 DE 03 00 0A 03 00 76 E3 03 00 7A 03 00 60 A0 13 01 60 A0 03 D5 03 00 1A 00 40 A0 E3 80 40 0B E5 78 40 0B E5 03 A0 A0 E3 3D FD FF EA 70 40 1B E5 04 30 94 E5 0A 00 53 E3 00 00 53 13 00 60 A0 13 01 60 A0 03 7D 00 00 1A 38 C0 4B E2 00 40 A0 E3 58 C0 0B E5 3C C0 4B E2 3C 40 0B E5 6C A0 0B E5 78 90 0B E5 40 60 4B E2 48 40 4B E2 74 90 1B E5 0C A0 A0 E1 0D 00 00 EA 40 30 1B E5 01 00 73 E3 BA 01 00 1A 85 30 A0 E1 0F 30 83 E2 0F 30 C3 E3 08 20 83 E2 02 D0 4D E0 18 20 8D E2 03 10 82 E0 01 00 57 E1 05 30 83 00 03 50 A0 E1 02 70 A0 E1 00 10 A0 E3 08 00 A0 E1 48 10 0B E5 ?? ?? ?? ?? 50 00 8D E9 00 20 A0 E3 00 50 8D E5 0C 20 8D E5 10 A0 8D E5 07 30 A0 E1 09 00 A0 E1 0A 10 A0 E3 58 20 1B E5 0F E0 A0 E1 ?? ?? ?? ?? 48 30 1B E5 22 00 53 E3 DF FF FF 0A 01 00 50 E3 78 90 1B E5 6C A0 1B E5 00 C0 A0 E1 78 00 0B E5 F5 02 00 0A 00 00 53 E3 03 60 A0 01 78 00 0B 05 44 00 00 0A 78 C0 0B E5 40 30 1B E5 01 00 73 E3 93 01 00 1A 84 20 9F E5 ?? ?? ?? ?? 02 20 9F E7 02 30 80 E7 78 30 9F E5 03 30 9F E7 03 30 90 E7 98 40 1B E5 08 10 93 E5 02 2A 04 E2 02 20 81 E1 08 20 83 E5 0B 00 A0 E3 79 FC FF EA ?? ?? ?? ?? ?? ?? ?? ?? 07 01 00 00 ?? ?? ?? ?? FF C0 00 00 FE 80 00 00 ?? ?? ?? ?? 7F 00 00 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 02 01 00 00 00 00 FF FF 05 01 00 00 0B 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? A4 04 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 04 C0 A0 E1 3C 40 1B E5 00 00 54 E3 02 00 00 0A 60 00 1B E5 00 00 50 E3 FE 03 00 0A 94 40 1B E5 00 00 56 E3 01 40 A0 13 94 40 0B E5 00 60 A0 E3 70 40 1B E5 80 60 0B E5 04 30 94 E5 02 00 D3 E3 7F 00 00 0A 0A 00 53 E3 74 00 00 0A 78 00 1B E5 01 00 50 E3 01 00 5C 13 00 40 A0 13 01 40 A0 03 B7 00 00 1A 70 40 1B E5 00 30 94 E5 02 00 13 E3 2E 00 00 0A 60 40 1B E5 00 00 54 E3 03 40 A0 13 6C 40 0B 15 01 C0 A0 13 92 FE FF 1A 44 00 1B E5 }
	condition:
		$1
}

rule file_1_7_0 {
	meta:
		name = "get_scope"
		size = 240
	strings:
		$1 = { B0 30 D0 E1 0A 00 53 E3 03 00 00 0A 02 00 53 E3 1A 00 00 0A 0F 00 A0 E3 ?? ?? ?? ?? 08 30 D0 E5 FF 00 53 E3 28 00 00 0A 08 20 90 E5 AC 30 9F E5 AC 10 9F E5 03 30 02 E0 01 00 53 E1 20 00 00 0A 00 00 52 E3 08 00 00 1A 0C 20 90 E5 00 00 52 E3 05 00 00 1A 10 20 90 E5 00 00 52 E3 02 00 00 1A 14 20 90 E5 01 04 52 E3 15 00 00 0A 74 00 9F E5 00 00 53 E1 0E 00 A0 13 05 00 A0 03 ?? ?? ?? ?? 64 30 9F E5 08 30 93 E5 04 00 90 E5 04 10 93 E5 00 20 93 E5 01 10 00 E0 02 00 51 E1 0D 00 00 0A 10 10 93 E5 0C 20 93 E5 01 10 00 E0 02 00 51 E1 0C 30 83 E2 03 20 A0 E1 F8 FF FF 1A 08 00 92 E5 ?? ?? ?? ?? 02 00 A0 E3 ?? ?? ?? ?? 09 00 D0 E5 0F 00 00 E2 ?? ?? ?? ?? 03 20 A0 E1 F6 FF FF EA FF C0 00 00 FE 80 00 00 FE C0 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_8_0 {
	meta:
		name = "rfc3484_sort"
		size = 1736
		refs = "02b4 __check_native 062c __assert_fail"
	strings:
		$1 = { F0 4F 2D E9 00 50 90 E5 05 81 85 E0 00 40 92 E5 00 60 91 E5 88 80 85 E0 08 81 A0 E1 08 B0 84 E0 06 71 86 E0 21 30 DB E5 87 70 86 E0 07 71 A0 E1 2C D0 4D E2 07 C0 84 E0 00 00 53 E3 0C 20 8D E5 08 C0 8D E5 5D 00 00 0A 21 30 DC E5 00 00 53 E3 D9 00 00 0A 08 30 94 E7 14 20 93 E5 02 00 A0 E1 04 20 8D E5 A9 FF FF EB 07 30 94 E7 04 C0 8B E2 18 00 8D E5 14 00 93 E5 10 C0 8D E5 A3 FF FF EB 08 30 9D E5 14 00 8D E5 04 30 83 E2 10 00 9D E5 1C 30 8D E5 9D FF FF EB 00 90 A0 E1 1C 00 9D E5 9A FF FF EB 14 C0 9D E5 18 10 9D E5 00 30 5C E0 01 30 A0 13 09 00 51 E1 00 30 A0 13 00 00 53 E3 04 20 9D E5 BC 00 00 1A 14 C0 9D E5 18 10 9D E5 00 C0 5C E0 00 00 7C E2 0C 00 B0 E0 09 00 51 E1 00 00 A0 03 00 00 50 E3 AA 00 00 1A 22 30 DB E5 08 C0 9D E5 01 00 13 E3 22 10 DC E5 A9 00 00 1A 01 00 11 E3 AC 00 00 1A 02 00 13 E3 AE 00 00 0A 02 00 11 E3 A8 00 00 0A 74 95 9F E5 00 A0 99 E5 02 00 A0 E1 0A 10 A0 E1 02 21 E0 E3 6E F3 FF EB 0A 10 A0 E1 00 30 A0 E1 02 21 E0 E3 10 00 9D E5 00 30 8D E5 68 F3 FF EB 07 20 94 E7 10 00 8D E5 0A 10 A0 E1 14 00 92 E5 02 21 E0 E3 62 F3 FF EB 0A 10 A0 E1 00 C0 A0 E1 02 21 E0 E3 1C 00 9D E5 04 C0 8D E5 5C F3 FF EB 08 10 9D E8 10 10 9D E5 00 20 5C E0 01 20 A0 13 01 00 53 E1 00 20 A0 13 00 00 52 E3 88 00 00 1A 00 20 5C E0 00 C0 72 E2 02 C0 BC E0 01 00 53 E1 00 C0 A0 03 00 00 5C E3 78 00 00 1A 08 30 94 E7 14 A0 93 E5 0D 00 00 EA 08 C0 9D E5 21 30 DC E5 00 00 53 E3 71 00 00 1A 08 30 94 E7 14 A0 93 E5 0A 00 A0 E1 4B FF FF EB 07 30 94 E7 18 00 8D E5 14 00 93 E5 47 FF FF EB 9C 94 9F E5 14 00 8D E5 04 90 99 E5 0A 00 A0 E1 09 10 A0 E1 00 20 A0 E3 37 F3 FF EB 07 30 94 E7 00 A0 A0 E1 09 10 A0 E1 14 00 93 E5 00 20 A0 E3 31 F3 FF EB 00 00 5A E1 63 00 00 CA 59 00 00 BA 21 30 DB E5 00 00 53 E3 40 00 00 0A 08 C0 9D E5 24 90 9B E5 24 A0 9C E5 0A 00 59 E1 3B 00 00 0A 08 00 9D E5 28 C0 9B E5 28 10 90 E5 01 00 7C E3 00 20 A0 13 01 20 A0 03 01 00 71 E3 00 30 A0 13 01 30 A0 03 02 00 93 E1 20 C0 8D E5 24 10 8D E5 29 00 00 0A 00 00 52 E3 00 20 A0 13 20 20 8D 15 00 90 E0 03 00 00 53 E3 00 30 A0 13 00 A0 E0 03 24 30 8D 15 09 00 A0 E1 20 10 8D E2 0A 20 A0 E1 24 30 8D E2 ?? ?? ?? ?? 0C C0 9D E5 04 00 9C E5 00 00 50 E3 AD 00 00 DA 0C C0 9D E5 24 10 9D E5 00 30 9C E5 10 50 8D E5 20 C0 9D E5 0C 10 8D E5 00 20 A0 E3 01 50 A0 E1 05 00 00 EA 01 00 5A E1 38 00 00 0A 01 20 82 E2 00 00 52 E1 2C 30 83 E2 3E 00 00 0A 24 10 93 E5 09 00 51 E1 F6 FF FF 1A 28 10 93 E5 01 00 71 E3 01 00 00 0A 0C 00 51 E1 C2 00 00 1A 28 C0 83 E5 F1 FF FF EA 01 30 A0 E1 00 00 5C E3 2E 00 00 1A 00 00 53 E3 15 00 00 1A 14 C0 9D E5 18 00 9D E5 00 00 5C E1 1A 00 00 CA 10 00 00 BA 21 30 DB E5 00 00 53 E3 14 00 00 0A 08 20 94 E7 07 10 94 E7 04 30 92 E5 04 00 91 E5 00 00 53 E1 0E 00 00 1A 02 00 53 E3 22 00 00 0A 0A 00 53 E3 5F 00 00 0A 00 30 A0 E3 03 20 A0 E1 02 00 53 E1 06 00 00 DA 01 00 A0 E3 2C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 01 00 11 E3 55 FF FF 1A F8 FF FF EA 06 00 55 E1 F6 FF FF 2A 00 00 E0 E3 2C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 02 00 11 E3 50 FF FF 0A EF FF FF EA 28 10 93 E5 01 00 71 E3 01 00 00 0A 05 00 51 E1 8B 00 00 1A 28 50 83 E5 BF FF FF EA 00 00 53 E3 D0 FF FF 1A EE FF FF EA 10 50 9D E5 0C 30 9D E5 C8 FF FF EA B4 30 DB E1 02 00 53 E3 99 00 00 1A 08 70 9D E5 B4 30 D7 E1 02 00 53 E3 90 00 00 1A 14 30 92 E5 08 C0 9B E5 04 00 93 E5 6C 38 2C E0 60 28 20 E0 22 24 A0 E1 23 34 A0 E1 FF 2C C2 E3 23 40 DB E5 FF 3C C3 E3 60 24 22 E0 6C 34 23 E0 02 00 23 E0 20 40 64 E2 00 30 E0 E3 13 34 10 E0 00 20 A0 13 08 00 00 1A 03 20 A0 E1 02 31 A0 E3 03 00 00 EA 01 20 82 E2 20 00 52 E3 A3 30 A0 E1 01 00 00 0A 00 00 13 E1 F9 FF FF 0A 14 30 91 E5 08 70 9D E5 04 00 93 E5 08 C0 97 E5 60 18 20 E0 6C 38 2C E0 21 14 A0 E1 23 34 A0 E1 FF 1C C1 E3 23 40 D7 E5 FF 3C C3 E3 6C 34 23 E0 60 14 21 E0 01 00 23 E0 20 40 64 E2 00 30 E0 E3 13 34 10 E0 26 00 00 1A 02 11 A0 E3 03 00 00 EA 01 30 83 E2 20 00 53 E3 A1 10 A0 E1 A6 FF FF 0A 00 00 11 E1 F9 FF FF 0A 03 00 52 E1 A2 FF FF DA AC FF FF EA B4 30 DB E1 0A 00 53 E3 50 00 00 1A 08 C0 9D E5 B4 30 DC E1 0A 00 53 E3 47 00 00 1A 14 C0 91 E5 08 00 9D E5 14 20 92 E5 08 80 8B E2 0C 30 A0 E1 08 70 80 E2 00 10 A0 E3 08 40 92 E5 04 00 B8 E5 00 00 54 E1 10 00 00 1A 08 90 93 E5 04 00 B7 E5 00 00 59 E1 0B 00 00 1A 01 10 81 E2 04 00 51 E3 04 20 82 E2 04 30 83 E2 F2 FF FF 1A 83 FF FF EA 00 30 A0 E3 DE FF FF EA 24 00 9D E5 20 C0 9D E5 0C 00 8D E5 9C FF FF EA 04 00 A0 E1 00 00 24 E0 60 38 20 E0 23 34 A0 E1 FF 3C C3 E3 60 04 23 E0 00 20 A0 E3 02 31 A0 E3 03 00 00 EA 01 20 82 E2 20 00 52 E3 A3 30 A0 E1 01 00 00 0A 00 00 13 E1 F9 FF FF 0A 08 70 9D E5 02 10 81 E2 01 31 87 E0 04 00 93 E5 01 31 9C E7 03 00 20 E0 60 38 20 E0 23 34 A0 E1 FF 3C C3 E3 60 04 23 E0 02 11 A0 E3 00 30 A0 E3 03 00 00 EA 01 30 83 E2 20 00 53 E3 A1 10 A0 E1 5F FF FF 0A 00 00 11 E1 F9 FF FF 0A B7 FF FF EA 74 00 9F E5 74 10 9F E5 74 20 9F E5 74 30 9F E5 ?? ?? ?? ?? 70 00 9F E5 60 10 9F E5 6C 20 9F E5 60 30 9F E5 ?? ?? ?? ?? 64 00 9F E5 4C 10 9F E5 71 2E A0 E3 4C 30 9F E5 ?? ?? ?? ?? 54 00 9F E5 38 10 9F E5 50 20 9F E5 38 30 9F E5 ?? ?? ?? ?? 48 00 9F E5 24 10 9F E5 44 20 9F E5 24 30 9F E5 ?? ?? ?? ?? 3C 00 9F E5 10 10 9F E5 6F 2E A0 E3 10 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? D3 06 00 00 ?? ?? ?? ?? ?? ?? ?? ?? CD 06 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 0F 07 00 00 ?? ?? ?? ?? F1 06 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_9_0 {
	meta:
		name = "freeaddrinfo"
		size = 56
		refs = "001c free"
	strings:
		$1 = { 38 40 2D E9 00 40 50 E2 01 00 00 1A 07 00 00 EA 05 40 A0 E1 18 00 84 E2 21 00 90 E8 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 00 00 55 E3 F7 FF FF 1A 38 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_10_0 {
	meta:
		name = "getaddrinfo"
		size = 2708
		refs = "0140 __pthread_once 01b4 qsort 0250 __connect 0278 __aeabi_read_tp 0340 __socket 038c memcmp 03a4 memcpy 03e0 __getsockname 05f4 qsort_r 0678 __free_in6ai 06d4 __check_pf 0748 strtoul 0800 __assert_fail 0808 freeaddrinfo 0834 free 0900 __lll_lock_wait_private 09b8 __xstat64 09f4 __libc_alloca_cutoff 0a04 malloc 0a60 gaiconf_init 0a64 in6aicmp 0a68 __libc_errno 0a70 rfc3484_sort"
	strings:
		$1 = { F0 4F 2D E9 00 70 50 E2 20 B0 8D E2 00 00 A0 E3 41 DF 4D E2 02 50 A0 E1 01 60 A0 E1 0C 31 0B E5 CC 00 0B E5 01 20 A0 03 03 00 00 0A 00 30 D7 E5 2A 00 53 E3 B9 01 00 0A 00 20 A0 E3 00 00 56 E3 99 01 00 0A 00 30 D6 E5 2A 00 53 E3 93 01 00 0A FC 39 9F E5 00 00 55 E3 03 50 A0 01 00 40 95 E5 7F 3E C4 E3 0F 30 D3 E3 F0 30 0B E5 04 02 00 1A 02 00 14 E3 38 01 00 1A 00 30 A0 E3 20 40 14 E2 C8 30 0B E5 C4 30 0B E5 CE 30 4B E5 CD 30 4B E5 8B 01 00 1A 00 00 56 E3 D2 01 00 0A 00 10 D6 E5 00 00 51 E3 A3 01 00 1A 04 30 95 E5 00 20 A0 E3 02 00 D3 E3 C0 20 0B E5 01 00 00 0A 0A 00 53 E3 F4 01 00 1A C0 30 4B E2 05 20 A0 E1 00 30 8D E5 07 00 A0 E1 CC 30 4B E2 2F F5 FF EB 00 50 50 E2 C7 01 00 1A CC 30 1B E5 00 00 53 E3 E8 30 0B 05 06 00 00 0A E8 50 0B E5 05 20 A0 E1 1C 30 93 E5 00 00 53 E3 01 20 82 E2 FB FF FF 1A E8 20 0B E5 C0 30 1B E5 01 00 53 E3 55 01 00 9A 34 29 9F E5 34 39 9F E5 2C 20 92 E5 00 00 53 E3 1C 21 0B E5 3E 02 00 0A 1C 39 9F E5 20 19 9F E5 2C 00 83 E2 ?? ?? ?? ?? E8 20 1B E5 82 50 82 E0 05 52 A0 E1 01 0A 55 E3 25 02 00 8A 08 50 85 E2 05 D0 4D E0 08 10 8D E2 00 20 A0 E3 EC 10 0B E5 18 21 0B E5 E8 00 1B E5 E8 10 1B E5 00 01 A0 E1 01 30 80 E0 EC 20 1B E5 83 30 81 E0 03 31 82 E0 00 00 54 E3 F8 00 0B E5 F4 30 0B E5 77 01 00 0A C8 00 1B E5 00 00 50 E3 03 00 00 0A C4 10 1B E5 18 20 A0 E3 AC 38 9F E5 ?? ?? ?? ?? CC 50 1B E5 00 00 55 E3 B9 01 00 0A EC 30 1B E5 04 30 83 E2 10 31 0B E5 EC 30 1B E5 0C 30 83 E2 14 31 0B E5 00 30 A0 E3 E4 30 0B E5 10 31 1B E5 F4 00 1B E5 DC 30 0B E5 14 31 1B E5 00 A0 A0 E3 04 00 40 E2 E0 30 0B E5 00 80 E0 E3 0A 30 A0 E1 0A 90 A0 E1 0A 60 A0 E1 D8 00 0B E5 EC 40 1B E5 30 00 00 EA E4 30 1B E5 02 00 53 E3 02 00 00 1A 04 30 95 E5 0A 00 53 E3 4F 00 00 0A 08 00 A0 E1 8C 10 4B E2 10 20 A0 E3 8C 60 0B E5 88 60 0B E5 84 60 0B E5 80 60 0B E5 ?? ?? ?? ?? 1C 30 A0 E3 B4 30 0B E5 08 00 A0 E1 14 10 95 E5 10 20 95 E5 ?? ?? ?? ?? 00 00 50 E3 57 00 00 0A EC 17 9F E5 ?? ?? ?? ?? 01 30 9F E7 03 30 90 E7 61 00 53 E3 33 00 00 0A 20 60 C4 E5 18 30 95 E5 00 00 53 E3 03 00 00 0A 00 00 5A E3 83 01 00 1A 18 A0 85 E5 03 A0 A0 E1 DC 30 1B E5 2C 30 83 E2 1C 20 95 E5 DC 30 0B E5 E0 30 1B E5 00 00 52 E3 2C 30 83 E2 01 90 89 E2 2C 40 84 E2 E0 30 0B E5 B3 00 00 0A 05 30 A0 E1 02 50 A0 E1 D8 20 1B E5 00 10 E0 E3 00 50 84 E5 28 10 84 E5 04 90 A2 E5 00 00 53 E3 D8 20 0B E5 03 00 00 0A 10 20 93 E5 10 10 95 E5 01 00 52 E1 1C 00 00 0A 00 30 E0 E3 01 00 78 E3 21 60 C4 E5 22 60 C4 E5 23 60 C4 E5 24 30 84 E5 BB FF FF 1A 04 30 95 E5 02 10 A0 E3 03 00 A0 E1 00 20 A0 E3 E4 30 0B E5 ?? ?? ?? ?? 1C 30 A0 E3 01 00 70 E3 00 80 A0 E1 B4 30 0B E5 C6 FF FF 0A BF FF FF EA E4 30 1B E5 0A 00 53 E3 C8 FF FF 1A 04 30 95 E5 02 00 53 E3 C5 FF FF 1A 08 00 A0 E1 06 70 A0 E3 00 00 00 EF E9 FF FF EA 14 00 93 E5 14 10 95 E5 ?? ?? ?? ?? 00 00 50 E3 DD FF FF 1A 28 10 44 E2 0C 20 54 E5 04 00 84 E2 ?? ?? ?? ?? 0C 30 54 E5 0B 00 54 E5 0A 10 54 E5 09 20 54 E5 20 30 C4 E5 08 30 14 E5 21 00 C4 E5 22 10 C4 E5 23 20 C4 E5 24 30 84 E5 AE FF FF EA 08 00 A0 E1 04 10 84 E2 B4 20 4B E2 ?? ?? ?? ?? 00 00 50 E3 A1 FF FF 1A C8 70 1B E5 B4 30 1B E5 01 10 A0 E3 00 00 57 E3 20 30 C4 E5 21 10 C4 E5 2D 00 00 0A 04 30 95 E5 02 00 53 E3 56 00 00 0A 84 00 4B E2 0C 10 84 E2 10 20 A0 E3 ?? ?? ?? ?? C4 C0 1B E5 00 30 A0 E3 00 81 0B E5 FC A0 0B E5 04 51 0B E5 08 41 0B E5 07 A0 A0 E1 03 40 A0 E1 0C 50 A0 E1 05 00 54 E1 03 00 00 3A 3B 00 00 EA 04 00 57 E1 39 00 00 9A 07 50 A0 E1 04 70 85 E0 A7 70 A0 E1 87 80 87 E0 88 81 8A E0 08 10 A0 E1 8C 00 4B E2 D4 F0 FF EB 00 00 50 E3 F3 FF FF BA 01 40 87 12 EE FF FF 1A 08 20 A0 E1 42 4F 4B E2 00 00 52 E3 FC A0 1B E5 30 00 94 E8 00 81 1B E5 05 00 00 0A 00 30 D2 E5 22 30 C4 E5 01 30 D2 E5 23 30 C4 E5 04 30 92 E5 24 30 84 E5 04 30 95 E5 02 00 53 E3 70 FF FF 1A E4 10 1B E5 0A 00 51 E3 6D FF FF 1A E0 00 1B E5 EC 10 1B E5 00 20 61 E0 14 01 1B E5 00 20 82 E0 0C 10 12 E5 00 00 51 E3 BD 00 00 1A 08 10 12 E5 00 00 51 E3 BA 00 00 1A 04 20 12 E5 01 08 72 E3 B7 00 00 1A DC 00 1B E5 EC 10 1B E5 00 20 61 E0 10 01 1B E5 00 20 82 E0 B4 30 42 E1 08 00 84 E2 18 10 84 E2 04 20 A0 E3 ?? ?? ?? ?? 10 30 A0 E3 20 30 C4 E5 52 FF FF EA 42 4F 4B E2 30 05 94 E8 04 30 95 E5 02 00 53 E3 4D FF FF 1A DB FF FF EA 00 00 52 E3 C4 FE FF 0A 00 30 E0 E3 F0 30 0B E5 47 00 00 EA E4 30 1B E5 02 00 53 E3 A5 FF FF 1A 84 00 0B E5 80 00 0B E5 E0 04 9F E5 DC 10 1B E5 EC 20 1B E5 7C 00 0B E5 10 01 1B E5 01 30 62 E0 00 30 93 E7 78 30 0B E5 9E FF FF EA 01 00 78 E3 02 00 00 0A 08 00 A0 E1 06 70 A0 E3 00 00 00 EF 94 04 9F E5 10 30 90 E5 EC 10 1B E5 E8 20 1B E5 00 00 53 E3 B4 10 0B E5 B0 20 0B E5 BA 00 00 1A B4 30 4B E2 00 30 8D E5 F4 00 1B E5 E8 10 1B E5 04 20 A0 E3 78 34 9F E5 ?? ?? ?? ?? F4 20 1B E5 00 30 92 E5 EC 00 1B E5 03 21 83 E0 82 30 83 E0 E8 10 1B E5 03 E1 90 E7 01 00 51 E3 CC E0 0B E5 9B 00 00 DA F8 30 1B E5 F4 20 1B E5 04 C0 43 E2 0C C0 82 E0 0E 10 A0 E1 00 40 A0 E1 00 00 00 EA 03 10 A0 E1 04 30 B2 E5 03 01 83 E0 80 30 83 E0 03 31 94 E7 0C 00 52 E1 1C 30 81 E5 F7 FF FF 1A 18 01 1B E5 00 20 A0 E3 00 00 50 E3 1C 20 83 E5 18 A0 8E E5 6E 00 00 1A C8 00 1B E5 ?? ?? ?? ?? CC 30 1B E5 00 00 53 E3 0B 00 00 0A 0C 11 1B E5 00 30 81 E5 F0 00 1B E5 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 01 30 D6 E5 00 00 53 E3 68 FE FF 1A 00 00 52 E3 02 60 A0 01 65 FE FF 0A 01 00 E0 E3 F0 00 0B E5 F2 FF FF EA C4 30 4B E2 CE 00 4B E2 CD 10 4B E2 C8 20 4B E2 ?? ?? ?? ?? 04 30 95 E5 00 00 53 E3 2E 00 00 1A CE 30 5B E5 00 00 53 E3 CD 30 5B E5 51 00 00 0A 00 00 53 E3 37 00 00 1A 05 E0 A0 E1 0F 00 BE E8 AC 50 4B E2 05 C0 A0 E1 0F 00 AC E8 0F 00 9E E8 02 E0 A0 E3 0F 00 8C E8 50 00 00 EA 01 30 D7 E5 00 00 53 E3 03 70 A0 01 01 20 A0 03 41 FE FF 0A 3F FE FF EA 06 00 A0 E1 8C 10 4B E2 0A 20 A0 E3 BC 60 0B E5 ?? ?? ?? ?? 8C 30 1B E5 B8 00 0B E5 00 30 D3 E5 00 00 53 E3 04 00 00 0A 00 30 95 E5 01 0B 13 E3 00 30 E0 03 B8 30 0B 05 3E 00 00 1A BC 10 4B E2 4A FE FF EA CE 00 4B E2 CD 10 4B E2 C8 20 4B E2 C4 30 4B E2 ?? ?? ?? ?? C8 00 1B E5 00 00 50 E3 82 FE FF 1A 85 FE FF EA 02 00 53 E3 09 00 00 0A 0A 00 53 E3 0A 00 00 1A CD 30 5B E5 00 00 53 E3 07 00 00 1A C8 00 1B E5 ?? ?? ?? ?? 01 10 E0 E3 F0 10 0B E5 AF FF FF EA CE 30 5B E5 00 00 53 E3 F7 FF FF 0A 00 00 56 E3 01 40 A0 E3 2C FE FF 1A 06 10 A0 E1 2D FE FF EA 7C 02 9F E5 7C 12 9F E5 7C 22 9F E5 7C 32 9F E5 ?? ?? ?? ?? CC 00 1B E5 ?? ?? ?? ?? C8 00 1B E5 ?? ?? ?? ?? 01 5C C5 E3 00 50 65 E2 F0 50 0B E5 F0 00 1B E5 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? EC 00 1B E5 ?? ?? ?? ?? 8D FF FF EA 00 00 53 E3 E5 FF FF 0A 05 E0 A0 E1 0F 00 BE E8 AC 50 4B E2 05 C0 A0 E1 0F 00 AC E8 0F 00 9E E8 0F 00 8C E8 0A E0 A0 E3 A8 E0 0B E5 01 40 A0 E3 08 FE FF EA C8 00 1B E5 ?? ?? ?? ?? 01 20 E0 E3 F0 20 0B E5 82 FF FF EA 00 20 E0 E3 F0 20 0B E5 7F FF FF EA 0E 30 A0 E1 70 FF FF EA C8 00 1B E5 ?? ?? ?? ?? 05 10 E0 E3 F0 10 0B E5 78 FF FF EA 05 A0 A0 E1 41 FF FF EA C8 01 9F E5 B8 11 9F E5 C4 21 9F E5 B8 31 9F E5 ?? ?? ?? ?? 01 10 A0 E3 30 20 80 E2 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 02 00 A0 11 ?? ?? ?? ?? 1C 31 1B E5 00 00 53 E3 04 00 00 0A 40 01 9F E5 0C 30 90 E5 00 00 53 E3 00 40 A0 E1 21 00 00 1A B4 30 4B E2 00 30 8D E5 F4 00 1B E5 E8 10 1B E5 04 20 A0 E3 30 31 9F E5 ?? ?? ?? ?? 10 11 9F E5 30 50 91 E5 3C 21 9F E5 00 10 A0 E3 05 40 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 EF FF FF 1A 01 00 55 E3 1B FF FF DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 EC 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 12 FF FF EA 03 00 A0 E3 D8 10 9F E5 8C 20 4B E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 3C 20 1B E5 14 30 94 E5 03 00 52 E1 01 00 00 0A C7 EF FF EB D1 FF FF EA 18 30 94 E5 38 20 1B E5 03 00 52 E1 F9 FF FF 1A CC FF FF EA 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 D5 FD FF 1A 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 EC 00 0B E5 01 00 A0 13 18 01 0B 15 D4 FD FF 1A C8 00 1B E5 ?? ?? ?? ?? 09 30 E0 E3 F0 30 0B E5 17 FF FF EA 1C 01 1B E5 00 00 50 E3 C1 FD FF 1A AD EF FF EB 10 10 9F E5 2C 30 91 E5 02 30 83 E3 2C 30 81 E5 BB FD FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 48 0A 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 63 0A 00 00 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_11_0 {
	meta:
		name = "fini"
		size = 100
		refs = "0018 free"
	strings:
		$1 = { 10 40 2D E9 48 40 9F E5 48 30 9F E5 00 00 94 E5 03 00 50 E1 00 30 84 15 ?? ?? ?? ?? 04 00 94 E5 34 30 9F E5 03 00 50 E1 24 20 9F E5 04 30 82 15 ?? ?? ?? ?? 08 00 94 E5 20 30 9F E5 03 00 50 E1 0C 20 9F E5 08 30 82 15 ?? ?? ?? ?? 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "bcopy"
		size = 332
		refs = "0064 _wordcopy_fwd_dest_aligned 00f4 _wordcopy_bwd_dest_aligned 012c _wordcopy_fwd_aligned 0134 _wordcopy_bwd_aligned"
	strings:
		$1 = { F8 40 2D E9 01 30 60 E0 02 00 53 E1 01 C0 A0 E1 00 40 A0 E1 22 00 00 3A 0F 00 52 E3 15 00 00 9A 00 30 61 E2 03 30 03 E2 00 00 53 E3 02 60 63 E0 43 00 00 0A 03 50 81 E0 00 E0 A0 E1 01 40 DE E4 01 40 CC E4 05 00 5C E1 FB FF FF 1A 03 40 80 E0 03 00 14 E3 05 00 A0 E1 04 10 A0 E1 26 21 A0 E1 31 00 00 0A ?? ?? ?? ?? 03 C0 C6 E3 0C 40 84 E0 03 20 06 E2 0C C0 85 E0 00 00 52 E3 06 00 00 0A 0C 30 A0 E1 04 00 63 E0 02 C0 8C E0 03 10 D0 E7 01 10 C3 E4 0C 00 53 E1 FB FF FF 1A F8 40 BD E8 ?? ?? ?? ?? 0F 00 52 E3 02 30 80 E0 02 60 81 E0 15 00 00 9A 03 10 06 E2 00 00 51 E3 02 70 61 E0 1D 00 00 0A 03 50 61 E0 06 E0 A0 E1 01 40 73 E5 05 00 53 E1 01 40 6E E5 FB FF FF 1A 06 60 61 E0 03 00 15 E3 06 00 A0 E1 05 10 A0 E1 27 21 A0 E1 0F 00 00 0A ?? ?? ?? ?? 03 10 C7 E3 03 20 17 E2 05 30 61 E0 06 60 61 E0 E3 FF FF 0A 03 20 62 E0 06 10 A0 E1 01 00 73 E5 02 00 53 E1 01 00 61 E5 FB FF FF 1A F8 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? CC FF FF EA ?? ?? ?? ?? EE FF FF EA 03 50 A0 E1 E6 FF FF EA 01 50 A0 E1 C0 FF FF EA }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "__libc_cleanup_routine"
		size = 40
		altNames = "__pthread_cleanup_routine"
	strings:
		$1 = { 08 20 90 E5 00 00 52 E3 08 40 2D E9 00 30 A0 E1 04 00 90 15 00 C0 93 15 0F E0 A0 11 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "__atomic_pwritev64_replacement"
		size = 328
		refs = "00a4 mempcpy 00c8 __pwrite64 00d4 free 00ec __aeabi_read_tp 011c __libc_alloca_cutoff 012c malloc 0144 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 00 80 52 E2 20 B0 8D E2 14 D0 4D E2 00 70 A0 E1 01 60 A0 E1 3C 00 00 DA 04 E0 91 E5 06 01 7E E3 00 C0 A0 93 0C 40 A0 91 01 50 A0 91 03 00 00 9A 2B 00 00 EA 04 E0 95 E5 0E 00 53 E1 28 00 00 3A 01 C0 8C E2 02 31 E0 E3 0E 40 84 E0 08 00 5C E1 08 50 85 E2 03 30 64 E0 F5 FF FF 1A 01 0A 54 E3 2B 00 00 8A 0E 30 84 E2 07 30 C3 E3 03 D0 4D E0 00 00 58 E3 00 30 A0 E3 08 50 8D E2 28 30 0B E5 0A 00 00 DA 00 90 A0 E3 09 A0 A0 E1 05 00 A0 E1 06 30 A0 E1 09 10 B3 E7 01 A0 8A E2 04 20 93 E5 ?? ?? ?? ?? 08 00 5A E1 08 90 89 E2 F7 FF FF 1A 0C 00 9B E9 07 00 A0 E1 0C 00 8D E8 05 10 A0 E1 04 20 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 28 00 1B E5 ?? ?? ?? ?? 04 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 54 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 00 40 E0 E3 03 20 80 E7 04 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 00 40 A0 E3 D3 FF FF EA 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 CF FF FF 1A 04 00 A0 E1 ?? ?? ?? ?? 00 50 50 E2 28 50 0B E5 00 40 E0 03 D1 FF FF 1A E2 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_1_0 {
	meta:
		name = "pwritev64"
		size = 276
		refs = "005c __aeabi_read_tp 008c __libc_enable_asynccancel 00c0 __libc_disable_asynccancel 0100 __libc_multiple_threads 0108 __libc_errno"
	strings:
		$1 = { F8 4F 2D E9 F4 30 9F E5 00 30 93 E5 00 00 53 E3 00 A0 A0 E1 01 90 A0 E1 02 80 A0 E1 28 60 9D E5 2C 50 9D E5 18 00 00 1A 06 30 A0 E1 05 40 A0 E1 CC 70 9F E5 00 00 00 EF 01 0A 70 E3 21 00 00 8A 00 40 A0 E1 00 00 54 E3 02 00 00 BA 04 00 A0 E1 F8 4F BD E8 ?? ?? ?? ?? A8 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 26 00 53 E3 F6 FF FF 1A 28 60 8D E5 2C 50 8D E5 0A 00 A0 E1 09 10 A0 E1 08 20 A0 E1 F8 4F BD E8 8A FF FF EA ?? ?? ?? ?? 05 40 A0 E1 00 B0 A0 E1 09 10 A0 E1 0A 00 A0 E1 08 20 A0 E1 06 30 A0 E1 54 70 9F E5 00 00 00 EF 01 0A 70 E3 00 40 A0 E1 09 00 00 8A 0B 00 A0 E1 ?? ?? ?? ?? DE FF FF EA 3C 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 D6 FF FF EA 24 30 9F E5 00 40 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 40 80 E7 00 40 E0 E3 EE FF FF EA ?? ?? ?? ?? 6A 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "decode_name"
		size = 232
	strings:
		$1 = { 70 00 2D E9 01 20 80 E2 00 30 A0 E1 0A 60 A0 E3 09 50 A0 E3 20 40 A0 E3 05 00 00 EA 01 10 42 E5 00 10 D3 E5 00 00 51 E3 01 20 82 E2 01 30 83 E2 12 00 00 0A 00 10 D3 E5 5C 00 51 E3 F6 FF FF 1A 01 C0 D3 E5 30 00 5C E3 0E 00 00 0A 5C 00 5C E3 1B 00 00 0A 31 00 5C E3 EF FF FF 1A 02 C0 D3 E5 33 00 5C E3 EC FF FF 1A 03 C0 D3 E5 34 00 5C E3 01 10 42 05 03 30 83 02 E7 FF FF 1A E7 FF FF EA 70 00 BD E8 ?? ?? ?? ?? 02 C0 D3 E5 34 00 5C E3 0E 00 00 0A 31 00 5C E3 DF FF FF 1A 03 C0 D3 E5 31 00 5C E3 01 50 42 05 03 30 83 02 DB FF FF 0A 32 00 5C E3 01 60 42 05 03 30 83 02 D6 FF FF 1A D6 FF FF EA 01 C0 42 E5 01 30 83 E2 D3 FF FF EA 03 C0 D3 E5 30 00 5C E3 01 40 42 05 03 30 83 02 CD FF FF 1A CD FF FF EA }
	condition:
		$1
}

rule file_6_1_0 {
	meta:
		name = "__setmntent"
		size = 108
		refs = "0014 strlen 0030 mempcpy 003c memcpy 0048 _IO_new_fopen"
	strings:
		$1 = { 30 48 2D E9 00 50 A0 E1 0C B0 8D E2 01 00 A0 E1 01 40 A0 E1 ?? ?? ?? ?? 0A 30 80 E2 07 30 C3 E3 03 D0 4D E0 00 20 A0 E1 04 10 A0 E1 0D 00 A0 E1 ?? ?? ?? ?? 03 20 A0 E3 28 10 9F E5 ?? ?? ?? ?? 05 00 A0 E1 0D 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 30 90 15 02 39 83 13 00 30 80 15 0C D0 4B E2 30 48 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_6_2_0 {
	meta:
		name = "__endmntent"
		size = 24
		refs = "0008 _IO_new_fclose"
	strings:
		$1 = { 00 00 50 E3 08 40 2D E9 ?? ?? ?? ?? 01 00 A0 E3 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_6_3_0 {
	meta:
		name = "__getmntent_r"
		size = 812
		refs = "002c fgets_unlocked 0040 strchr 02ec sscanf"
	strings:
		$1 = { F0 43 2D E9 01 DB 4D E2 04 D0 4D E2 00 60 A0 E1 01 90 A0 E1 02 50 A0 E1 03 70 A0 E1 00 80 A0 E3 05 00 A0 E1 07 10 A0 E1 06 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 55 00 00 0A 05 00 A0 E1 0A 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 00 80 C0 15 20 00 00 0A 05 C0 A0 E1 0C 40 A0 E1 01 E0 DC E4 20 00 5E E3 FB FF FF 0A 09 00 5E E3 F9 FF FF 0A 00 00 5E E3 23 00 5E 13 E9 FF FF 0A 20 00 5E E3 04 00 A0 E1 46 00 00 0A 09 00 5E E3 01 20 84 12 04 00 00 1A 42 00 00 EA 20 00 53 E3 40 00 00 0A 09 00 53 E3 3E 00 00 0A 02 40 A0 E1 01 30 D2 E4 00 00 53 E3 F7 FF FF 1A 76 FF FF EB 00 00 89 E5 60 32 9F E5 04 30 89 E5 57 00 00 EA ?? ?? ?? ?? 00 00 50 E3 DE FF FF 1A 01 1B A0 E3 0D 00 A0 E1 06 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0A 10 A0 E3 0D 00 A0 E1 F4 FF FF 1A D5 FF FF EA 00 30 A0 E3 00 30 C1 E5 01 40 81 E2 62 FF FF EB 00 00 54 E3 08 00 89 E5 04 30 A0 11 7E 00 00 0A 03 10 A0 E1 01 20 D3 E4 20 00 52 E3 FB FF FF 0A 09 00 52 E3 F9 FF FF 0A 00 00 52 E3 01 00 A0 E1 0D 00 00 0A 20 00 52 E3 5E 00 00 0A 09 00 52 E3 01 20 81 12 04 00 00 1A 5A 00 00 EA 20 00 53 E3 58 00 00 0A 09 00 53 E3 56 00 00 0A 02 10 A0 E1 01 30 D2 E4 00 00 53 E3 F7 FF FF 1A 46 FF FF EB 0C 00 89 E5 00 30 A0 E3 10 30 89 E5 00 30 A0 E3 14 30 89 E5 09 00 A0 E1 01 DB 8D E2 04 D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 00 30 A0 E3 00 30 C4 E5 39 FF FF EB 01 40 84 E2 00 00 54 E3 00 00 89 E5 BF FF FF 0A 04 30 A0 E1 03 10 A0 E1 01 20 D3 E4 20 00 52 E3 FB FF FF 0A 09 00 52 E3 F9 FF FF 0A 00 00 52 E3 01 00 A0 E1 0D 00 00 0A 20 00 52 E3 10 00 00 0A 09 00 52 E3 01 20 81 12 04 00 00 1A 0C 00 00 EA 20 00 53 E3 0A 00 00 0A 09 00 53 E3 08 00 00 0A 02 10 A0 E1 01 30 D2 E4 00 00 53 E3 F7 FF FF 1A 1C FF FF EB FC 30 9F E5 04 00 89 E5 08 30 89 E5 21 00 00 EA 00 30 A0 E3 00 30 C1 E5 01 40 81 E2 14 FF FF EB 00 00 54 E3 04 00 89 E5 04 30 A0 11 32 00 00 0A 03 10 A0 E1 01 20 D3 E4 20 00 52 E3 FB FF FF 0A 09 00 52 E3 F9 FF FF 0A 00 00 52 E3 01 00 A0 E1 0D 00 00 0A 20 00 52 E3 9E FF FF 0A 09 00 52 E3 01 20 81 12 04 00 00 1A 9A FF FF EA 20 00 53 E3 98 FF FF 0A 09 00 53 E3 96 FF FF 0A 02 10 A0 E1 01 30 D2 E4 00 00 53 E3 F7 FF FF 1A F8 FE FF EB 6C 30 9F E5 08 00 89 E5 0C 30 89 E5 AE FF FF EA 00 30 A0 E3 00 30 C1 E5 01 40 81 E2 F0 FE FF EB 00 00 54 E3 0C 00 89 E5 A7 FF FF 0A 04 00 A0 E1 40 10 9F E5 10 20 89 E2 14 30 89 E2 ?? ?? ?? ?? 00 00 50 E3 A0 FF FF 0A 01 00 50 E3 A0 FF FF 0A 09 00 A0 E1 01 DB 8D E2 04 D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 08 30 9F E5 E6 FF FF EA 00 30 9F E5 C0 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_6_4_0 {
	meta:
		name = "__addmntent"
		size = 1316
		refs = "0038 fseek 01b8 fprintf 01c8 fflush 01f4 strlen"
	strings:
		$1 = { F0 4F 2D E9 01 30 A0 E1 20 B0 8D E2 24 D0 4D E2 0C 50 83 E2 40 01 93 E8 08 70 93 E5 20 10 95 E8 14 30 93 E5 02 20 A0 E3 00 10 A0 E3 30 C0 0B E5 2C 30 0B E5 00 40 A0 E1 ?? ?? ?? ?? 00 00 50 E3 66 00 00 1A 00 90 D6 E5 00 00 59 E3 10 00 00 0A 09 30 49 E2 20 00 59 E3 01 00 53 13 63 00 00 9A 5C 00 59 E3 61 00 00 0A 06 20 A0 E1 04 00 00 EA 20 00 53 E3 01 00 51 13 5C 00 00 9A 5C 00 53 E3 5A 00 00 0A 01 30 F2 E5 00 00 53 E3 09 10 43 E2 F6 FF FF 1A 28 60 0B E5 00 90 D8 E5 00 00 59 E3 10 00 00 0A 09 30 49 E2 20 00 59 E3 01 00 53 13 75 00 00 9A 5C 00 59 E3 73 00 00 0A 08 30 A0 E1 04 00 00 EA 20 00 52 E3 01 00 51 13 6E 00 00 9A 5C 00 52 E3 6C 00 00 0A 01 20 F3 E5 00 00 52 E3 09 10 42 E2 F6 FF FF 1A 08 60 A0 E1 00 90 D7 E5 00 00 59 E3 10 00 00 0A 09 30 49 E2 20 00 59 E3 01 00 53 13 87 00 00 9A 5C 00 59 E3 85 00 00 0A 07 20 A0 E1 04 00 00 EA 20 00 53 E3 01 00 51 13 80 00 00 9A 5C 00 53 E3 7E 00 00 0A 01 30 F2 E5 00 00 53 E3 09 10 43 E2 F6 FF FF 1A 07 80 A0 E1 00 70 D5 E5 00 00 57 E3 10 00 00 0A 09 30 47 E2 20 00 57 E3 01 00 53 13 99 00 00 9A 5C 00 57 E3 97 00 00 0A 05 20 A0 E1 04 00 00 EA 20 00 53 E3 01 00 51 13 92 00 00 9A 5C 00 53 E3 90 00 00 0A 01 30 F2 E5 00 00 53 E3 09 10 43 E2 F6 FF FF 1A 05 C0 A0 E1 30 30 1B E5 00 11 8D E8 2C C0 1B E5 08 30 8D E5 0C C0 8D E5 28 20 1B E5 06 30 A0 E1 04 00 A0 E1 64 13 9F E5 ?? ?? ?? ?? 00 00 50 E3 06 00 00 BA 04 00 A0 E1 ?? ?? ?? ?? 00 00 90 E2 01 00 A0 13 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 01 00 A0 E3 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 06 00 A0 E1 ?? ?? ?? ?? 00 01 A0 E1 0F 30 80 E2 07 30 C3 E3 03 D0 4D E0 10 30 8D E2 01 10 46 E2 28 30 0B E5 09 20 A0 E1 5C C0 A0 E3 30 00 A0 E3 31 E0 A0 E3 32 A0 A0 E3 34 60 A0 E3 0E 00 00 EA 09 00 52 E3 89 00 00 0A 0A 00 52 E3 AB 00 00 0A 5C 00 52 E3 03 90 A0 01 02 20 C9 04 00 20 C3 15 01 20 C3 05 01 30 83 12 09 30 A0 01 01 20 F1 E5 00 00 52 E3 8B FF FF 0A 01 20 D1 E5 20 00 52 E3 EE FF FF 1A 00 C0 C3 E5 01 00 C3 E5 02 60 C3 E5 03 00 C3 E5 04 30 83 E2 F3 FF FF EA 08 00 A0 E1 ?? ?? ?? ?? 00 01 A0 E1 0F 30 80 E2 07 30 C3 E3 03 D0 4D E0 10 60 8D E2 01 10 48 E2 09 30 A0 E1 06 20 A0 E1 5C C0 A0 E3 30 00 A0 E3 31 E0 A0 E3 32 A0 A0 E3 34 80 A0 E3 0E 00 00 EA 09 00 53 E3 68 00 00 0A 0A 00 53 E3 8A 00 00 0A 5C 00 53 E3 02 90 A0 01 02 30 C9 04 00 30 C2 15 01 30 C2 05 01 20 82 12 09 20 A0 01 01 30 F1 E5 00 00 53 E3 79 FF FF 0A 01 30 D1 E5 20 00 53 E3 EE FF FF 1A 00 C0 C2 E5 01 00 C2 E5 02 80 C2 E5 03 00 C2 E5 04 20 82 E2 F3 FF FF EA 07 00 A0 E1 ?? ?? ?? ?? 00 01 A0 E1 0F 30 80 E2 07 30 C3 E3 03 D0 4D E0 10 80 8D E2 01 70 47 E2 09 10 A0 E1 08 20 A0 E1 5C 00 A0 E3 30 30 A0 E3 31 C0 A0 E3 32 A0 A0 E3 34 E0 A0 E3 0E 00 00 EA 09 00 51 E3 47 00 00 0A 0A 00 51 E3 51 00 00 0A 5C 00 51 E3 02 90 A0 01 02 10 C9 04 00 10 C2 15 01 10 C2 05 01 20 82 12 09 20 A0 01 01 10 F7 E5 00 00 51 E3 67 FF FF 0A 01 10 D7 E5 20 00 51 E3 EE FF FF 1A 00 00 C2 E5 01 30 C2 E5 02 E0 C2 E5 03 30 C2 E5 04 20 82 E2 F3 FF FF EA 05 00 A0 E1 ?? ?? ?? ?? 00 01 A0 E1 0F 30 80 E2 07 30 C3 E3 03 D0 4D E0 10 C0 8D E2 07 10 A0 E1 01 50 45 E2 0C 20 A0 E1 5C 00 A0 E3 30 30 A0 E3 31 E0 A0 E3 32 A0 A0 E3 34 70 A0 E3 0E 00 00 EA 09 00 51 E3 26 00 00 0A 0A 00 51 E3 30 00 00 0A 5C 00 51 E3 02 90 A0 01 02 10 C9 04 00 10 C2 15 01 10 C2 05 01 20 82 12 09 20 A0 01 01 10 F5 E5 00 00 51 E3 55 FF FF 0A 01 10 D5 E5 20 00 51 E3 EE FF FF 1A 00 00 C2 E5 01 30 C2 E5 02 70 C2 E5 03 30 C2 E5 04 20 82 E2 F3 FF FF EA 00 C0 C3 E5 01 00 C3 E5 02 E0 C3 E5 03 E0 C3 E5 04 30 83 E2 78 FF FF EA 00 C0 C2 E5 01 00 C2 E5 02 E0 C2 E5 03 E0 C2 E5 04 20 82 E2 99 FF FF EA 00 00 C2 E5 01 30 C2 E5 02 C0 C2 E5 03 C0 C2 E5 04 20 82 E2 BA FF FF EA 00 00 C2 E5 01 30 C2 E5 02 E0 C2 E5 03 E0 C2 E5 04 20 82 E2 DB FF FF EA 00 00 C2 E5 01 30 C2 E5 02 C0 C2 E5 03 A0 C2 E5 04 20 82 E2 AE FF FF EA 00 00 C2 E5 01 30 C2 E5 02 E0 C2 E5 03 A0 C2 E5 04 20 82 E2 CF FF FF EA 00 C0 C3 E5 01 00 C3 E5 02 E0 C3 E5 03 A0 C3 E5 04 30 83 E2 54 FF FF EA 00 C0 C2 E5 01 00 C2 E5 02 E0 C2 E5 03 A0 C2 E5 04 20 82 E2 75 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_6_5_0 {
	meta:
		name = "__hasmntopt"
		size = 132
		refs = "0010 strlen 0020 strchr 0038 strstr"
	strings:
		$1 = { 70 40 2D E9 00 40 A0 E1 01 00 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 0C 40 94 E5 00 60 A0 E1 03 00 00 EA ?? ?? ?? ?? 00 00 50 E3 13 00 00 0A 01 40 80 E2 05 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 30 50 E2 2C 10 A0 E3 03 00 A0 E1 0B 00 00 0A 04 00 53 E1 02 00 00 0A 01 20 53 E5 2C 00 52 E3 EF FF FF 1A 06 20 D3 E7 00 00 52 E3 3D 00 52 13 01 00 00 0A 2C 00 52 E3 E9 FF FF 1A 03 00 A0 E1 70 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "__setitimer"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 68 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "__isoc99_vwscanf"
		size = 536
		refs = "0024 __aeabi_read_tp 00a4 _IO_vfwscanf 0168 __lll_lock_wait_private 0210 _Unwind_Resume 0214 stdin"
	strings:
		$1 = { F0 47 2D E9 08 72 9F E5 00 50 97 E5 00 40 95 E5 02 49 14 E2 00 A0 A0 E1 01 90 A0 E1 43 00 00 1A 48 60 95 E5 ?? ?? ?? ?? 08 30 96 E5 13 8D 40 E2 08 00 53 E1 3F 00 00 0A 01 10 A0 E3 06 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 3D 00 00 1A 48 20 95 E5 00 30 97 E5 08 80 82 E5 48 60 95 E5 04 20 96 E5 01 20 82 E2 04 20 86 E5 3C 00 93 E5 10 00 80 E3 3C 00 83 E5 0A 10 A0 E1 03 00 A0 E1 09 20 A0 E1 00 30 A0 E3 ?? ?? ?? ?? 3C 30 95 E5 00 20 95 E5 14 30 C3 E3 02 09 12 E3 00 60 A0 E1 3C 30 85 E5 17 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 11 00 00 1A 08 30 85 E5 00 70 95 E5 00 10 A0 E3 07 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 57 E1 F0 FF FF 1A 01 00 57 E3 06 00 00 CA 06 00 A0 E1 F0 47 BD E8 ?? ?? ?? ?? 05 30 A0 E1 D3 FF FF EA 05 30 A0 E1 CE FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EF FF FF EA 06 00 A0 E1 ?? ?? ?? ?? BE FF FF EA 3C 30 95 E5 00 20 95 E5 14 30 C3 E3 02 09 12 E3 00 80 A0 E1 3C 30 85 E5 1F 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 19 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 07 00 00 DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 08 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1168_0_0 {
	meta:
		name = "__isoc99_vscanf"
		size = 536
		refs = "0024 __aeabi_read_tp 00a4 _IO_vfscanf 0168 __lll_lock_wait_private 0210 _Unwind_Resume 0214 stdin"
	strings:
		$1 = { F0 47 2D E9 08 72 9F E5 00 50 97 E5 00 40 95 E5 02 49 14 E2 00 A0 A0 E1 01 90 A0 E1 43 00 00 1A 48 60 95 E5 ?? ?? ?? ?? 08 30 96 E5 13 8D 40 E2 08 00 53 E1 3F 00 00 0A 01 10 A0 E3 06 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 3D 00 00 1A 48 20 95 E5 00 30 97 E5 08 80 82 E5 48 60 95 E5 04 20 96 E5 01 20 82 E2 04 20 86 E5 3C 00 93 E5 10 00 80 E3 3C 00 83 E5 0A 10 A0 E1 03 00 A0 E1 09 20 A0 E1 00 30 A0 E3 ?? ?? ?? ?? 3C 30 95 E5 00 20 95 E5 14 30 C3 E3 02 09 12 E3 00 60 A0 E1 3C 30 85 E5 17 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 11 00 00 1A 08 30 85 E5 00 70 95 E5 00 10 A0 E3 07 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 57 E1 F0 FF FF 1A 01 00 57 E3 06 00 00 CA 06 00 A0 E1 F0 47 BD E8 ?? ?? ?? ?? 05 30 A0 E1 D3 FF FF EA 05 30 A0 E1 CE FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EF FF FF EA 06 00 A0 E1 ?? ?? ?? ?? BE FF FF EA 3C 30 95 E5 00 20 95 E5 14 30 C3 E3 02 09 12 E3 00 80 A0 E1 3C 30 85 E5 1F 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 19 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 07 00 00 DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 08 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "allocate"
		size = 32
		refs = "0008 malloc"
	strings:
		$1 = { 08 40 2D E9 01 0B A0 E3 ?? ?? ?? ?? 08 30 9F E5 00 00 83 E5 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_1_0 {
	meta:
		name = "getnetgrent"
		size = 192
		refs = "0028 __pthread_once 0050 __getnetgrent_r 0064 __aeabi_read_tp 0094 malloc 00b4 allocate 00bc __libc_errno"
	strings:
		$1 = { F0 40 2D E9 A0 30 9F E5 00 00 53 E3 0C D0 4D E2 00 50 A0 E1 01 40 A0 E1 02 60 A0 E1 16 00 00 0A 88 00 9F E5 88 10 9F E5 ?? ?? ?? ?? 84 30 9F E5 00 30 93 E5 00 00 53 E3 08 00 00 0A 01 CB A0 E3 05 00 A0 E1 04 10 A0 E1 06 20 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 F0 40 BD E8 ?? ?? ?? ?? 54 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 0C 20 A0 E3 03 20 80 E7 00 00 E0 E3 F5 FF FF EA 2C 70 9F E5 00 30 97 E5 00 00 53 E3 28 30 9F 15 E7 FF FF 1A 01 0B A0 E3 ?? ?? ?? ?? 18 30 9F E5 02 20 A0 E3 00 00 83 E5 00 20 87 E5 E0 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "putwc"
		size = 504
		refs = "001c __aeabi_read_tp 0148 __woverflow 0158 __lll_lock_wait_private 01f4 _Unwind_Resume"
	strings:
		$1 = { F0 41 2D E9 00 40 91 E5 02 49 14 E2 01 50 A0 E1 00 60 A0 E1 18 00 00 1A 48 70 91 E5 ?? ?? ?? ?? 08 30 97 E5 13 8D 40 E2 08 00 53 E1 0F 00 00 0A 01 10 A0 E3 07 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 3B 00 00 1A 48 30 95 E5 08 80 83 E5 03 70 A0 E1 04 30 97 E5 01 30 83 E2 04 30 87 E5 5C 30 95 E5 00 00 53 E3 2D 00 00 0A 10 20 93 E5 14 10 93 E5 01 00 52 E1 04 10 82 32 10 10 83 35 00 60 82 35 26 00 00 2A 00 30 95 E5 02 09 13 E3 17 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 11 00 00 1A 08 30 85 E5 00 70 95 E5 00 10 A0 E3 07 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 57 E1 F0 FF FF 1A 01 00 57 E3 02 00 00 CA 06 00 A0 E1 F0 41 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF F3 FF FF EA 06 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 D3 FF FF EA 07 00 A0 E1 ?? ?? ?? ?? C0 FF FF EA 00 30 95 E5 02 09 13 E3 00 80 A0 E1 1F 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 19 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 07 00 00 DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 08 00 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_0_0 {
	meta:
		name = "parse_printf_format"
		size = 260
		refs = "001c __strchrnul 005c __parse_one_specmb 0100 __printf_arginfo_table"
	strings:
		$1 = { F0 43 2D E9 00 40 A0 E3 3C D0 4D E2 01 50 A0 E1 25 10 A0 E3 02 60 A0 E1 00 40 8D E5 ?? ?? ?? ?? 00 30 D0 E5 04 00 53 E1 32 00 00 0A CC 80 9F E5 04 70 A0 E1 05 00 00 EA 2C 30 9D E5 02 31 86 E7 1C 00 9D E5 00 30 D0 E5 00 00 53 E3 23 00 00 0A 04 10 A0 E1 0D 30 A0 E1 04 20 8D E2 ?? ?? ?? ?? 24 30 9D E5 01 00 73 E3 00 40 84 E0 01 00 00 0A 05 00 53 E1 03 71 86 37 20 30 9D E5 01 00 73 E3 01 00 00 0A 03 00 55 E1 03 71 86 87 28 20 9D E5 02 00 55 E1 E9 FF FF 9A 30 30 9D E5 00 00 53 E3 E6 FF FF 0A 01 00 53 E3 E2 FF FF 0A 05 10 62 E0 34 30 8D E2 0C 90 9D E5 00 C0 98 E5 04 00 8D E2 02 21 86 E0 09 C1 9C E7 0F E0 A0 E1 ?? ?? ?? ?? 1C 00 9D E5 00 30 D0 E5 00 00 53 E3 DB FF FF 1A 00 00 9D E5 00 00 54 E1 04 00 A0 21 3C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 03 00 A0 E1 FA FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "getwchar_unlocked"
		size = 72
		refs = "003c __wuflow 0044 _IO_stdin"
	strings:
		$1 = { 08 40 2D E9 38 30 9F E5 00 00 93 E5 5C 30 90 E5 00 00 53 E3 08 00 00 0A 00 20 93 E5 04 10 93 E5 01 00 52 E1 04 00 00 2A 04 10 82 E2 00 10 83 E5 00 00 92 E5 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? FB FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "rename"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 26 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "posix_spawn_file_actions_destroy"
		size = 24
		refs = "0008 free"
	strings:
		$1 = { 08 40 2D E9 08 00 90 E5 ?? ?? ?? ?? 00 00 A0 E3 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_0_1 {
	meta:
		name = "__gnu_fractdasf"
		size = 24
		refs = "0004 __aeabi_l2f 000c __aeabi_fmul"
	strings:
		$1 = { 08 40 2D E9 ?? ?? ?? ?? 03 12 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1042_0_1 {
	meta:
		name = "__gnu_fractdqsf"
		size = 24
		refs = "0004 __aeabi_l2f 000c __aeabi_fmul"
	strings:
		$1 = { 08 40 2D E9 ?? ?? ?? ?? 02 12 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1435_0_1 {
	meta:
		name = "__gnu_fractsasf"
		size = 24
		refs = "0004 __aeabi_i2f 000c __aeabi_fmul"
	strings:
		$1 = { 08 40 2D E9 ?? ?? ?? ?? 0E 13 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1410_0_1 {
	meta:
		name = "__gnu_fractsqsf"
		size = 24
		refs = "0004 __aeabi_i2f 000c __aeabi_fmul"
	strings:
		$1 = { 08 40 2D E9 ?? ?? ?? ?? 03 12 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_225_0_1 {
	meta:
		name = "__gnu_fractudasf"
		size = 24
		refs = "0004 __aeabi_ul2f 000c __aeabi_fmul"
	strings:
		$1 = { 08 40 2D E9 ?? ?? ?? ?? BE 15 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_0_1 {
	meta:
		name = "__gnu_fractudqsf"
		size = 24
		refs = "0004 __aeabi_ul2f 000c __aeabi_fmul"
	strings:
		$1 = { 08 40 2D E9 ?? ?? ?? ?? 7E 15 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1093_0_1 {
	meta:
		name = "__gnu_fractusasf"
		size = 24
		refs = "0004 __aeabi_ui2f 000c __aeabi_fmul"
	strings:
		$1 = { 08 40 2D E9 ?? ?? ?? ?? DE 15 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1564_0_1 {
	meta:
		name = "__gnu_fractusqsf"
		size = 24
		refs = "0004 __aeabi_ui2f 000c __aeabi_fmul"
	strings:
		$1 = { 08 40 2D E9 ?? ?? ?? ?? BE 15 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1014_6_0 {
	meta:
		name = "free_mem"
		size = 24
		refs = "0004 __rpc_thread_variables 000c free"
	strings:
		$1 = { 08 40 2D E9 ?? ?? ?? ?? 98 00 90 E5 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "__mmap"
		size = 72
		refs = "003c __syscall_error"
	strings:
		$1 = { 04 50 2D E5 08 50 9D E5 04 40 2D E5 08 40 9D E5 05 CA B0 E1 09 00 00 1A 25 56 A0 E1 04 70 2D E5 C0 70 A0 E3 00 00 00 EF 04 70 9D E4 04 40 9D E4 04 50 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? 15 00 E0 E3 F8 FF FF EA }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "__nl_langinfo_l"
		size = 88
	strings:
		$1 = { 40 38 A0 E1 06 00 53 E3 0C 00 00 0A 0C 00 53 E3 0A 00 00 8A 00 08 A0 E1 01 08 70 E3 20 08 A0 E1 08 00 00 0A 03 31 91 E7 20 20 93 E5 02 00 50 E1 02 00 00 2A 00 01 83 E0 24 00 90 E5 ?? ?? ?? ?? 0C 00 9F E5 ?? ?? ?? ?? 10 30 83 E2 03 01 91 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "strerror_l"
		size = 232
		refs = "0034 __uselocale 0048 __dcgettext 0068 __aeabi_read_tp 0074 free 00b4 __asprintf 00d0 _sys_nerr_internal 00d4 _sys_errlist_internal 00d8 _libc_intl_domainname 00dc .LANCHOR0"
	strings:
		$1 = { F0 41 2D E9 00 40 50 E2 01 60 A0 E1 14 00 00 BA B8 30 9F E5 00 30 93 E5 03 00 54 E1 10 00 00 AA AC 30 9F E5 04 51 93 E7 00 00 55 E3 0C 00 00 0A 06 00 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 00 40 A0 E1 05 20 A0 E3 8C 00 9F E5 ?? ?? ?? ?? 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 05 00 A0 E1 F0 41 BD E8 ?? ?? ?? ?? 70 50 9F E5 ?? ?? ?? ?? 00 70 A0 E1 00 00 95 E7 ?? ?? ?? ?? 06 00 A0 E1 ?? ?? ?? ?? 58 10 9F E5 00 60 A0 E1 05 20 A0 E3 44 00 9F E5 ?? ?? ?? ?? 00 80 A0 E1 06 00 A0 E1 05 60 87 E0 ?? ?? ?? ?? 06 00 A0 E1 08 20 A0 E1 04 30 A0 E1 2C 10 9F E5 ?? ?? ?? ?? 01 00 70 E3 00 00 A0 03 05 00 97 17 05 00 87 07 F0 41 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_1_0 {
	meta:
		name = "strerror_thread_freeres"
		size = 32
		refs = "0008 __aeabi_read_tp 0010 free 001c .LANCHOR0"
	strings:
		$1 = { 08 40 2D E9 10 30 9F E5 ?? ?? ?? ?? 00 00 93 E7 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_12_4 {
	meta:
		name = "_ZN11__gnu_debug19_Safe_sequence_base12_M_get_mutexEv"
		size = 28
		refs = "0004 _ZN12_GLOBAL__N_119get_safe_base_mutexEPv 0014 __cxa_end_cleanup 0018 __cxa_call_unexpected"
	strings:
		$1 = { 08 40 2D E9 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? 01 00 71 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_0_4 {
	meta:
		name = "_Znaj"
		size = 28
		refs = "0004 _Znwj 0014 __cxa_end_cleanup 0018 __cxa_call_unexpected"
	strings:
		$1 = { 08 40 2D E9 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? 01 00 71 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "__scanf"
		size = 64
		refs = "0028 _IO_vfscanf 003c stdin"
	strings:
		$1 = { 0F 00 2D E9 04 E0 2D E5 2C 30 9F E5 0C D0 4D E2 14 C0 8D E2 00 00 93 E5 0C 20 A0 E1 10 10 9D E5 00 30 A0 E3 04 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 10 D0 8D E2 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_935_0_0 {
	meta:
		name = "__wscanf"
		size = 64
		refs = "0028 _IO_vfwscanf 003c stdin"
	strings:
		$1 = { 0F 00 2D E9 04 E0 2D E5 2C 30 9F E5 0C D0 4D E2 14 C0 8D E2 00 00 93 E5 0C 20 A0 E1 10 10 9D E5 00 30 A0 E3 04 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 10 D0 8D E2 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "fstatvfs"
		size = 104
		refs = "0014 __fstatfs 0030 __fxstat64 004c __internal_statvfs"
	strings:
		$1 = { 70 40 2D E9 A8 D0 4D E2 01 50 A0 E1 0D 10 A0 E1 00 60 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0F 00 00 BA 40 40 8D E2 06 10 A0 E1 04 20 A0 E1 03 00 A0 E3 ?? ?? ?? ?? 01 00 70 E3 04 30 A0 11 00 00 A0 E3 00 30 A0 03 05 10 A0 E1 0D 20 A0 E1 ?? ?? ?? ?? 00 00 A0 E3 A8 D0 8D E2 70 40 BD E8 ?? ?? ?? ?? 00 00 E0 E3 FA FF FF EA }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "syscall"
		size = 48
		refs = "002c __syscall_error"
	strings:
		$1 = { 0D C0 A0 E1 F0 00 2D E9 00 70 A0 E1 01 00 A0 E1 02 10 A0 E1 03 20 A0 E1 78 00 9C E8 00 00 00 EF F0 00 BD E8 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_0_0 {
	meta:
		name = "__strverscmp"
		size = 288
	strings:
		$1 = { 01 00 50 E1 70 00 2D E9 3C 00 00 0A 00 40 D0 E5 30 C0 44 E2 09 00 5C E3 00 30 D1 E5 00 C0 A0 83 01 C0 A0 93 30 00 54 E3 01 C0 8C 02 03 50 54 E0 01 20 80 E2 01 10 81 E2 DC 60 9F 15 11 00 00 1A 00 00 54 E3 32 00 00 0A CC 60 9F E5 01 00 00 EA 00 00 50 E3 19 00 00 0A 01 00 D2 E4 30 50 40 E2 09 00 55 E3 01 30 D1 E4 0C 40 D6 E7 00 C0 A0 83 01 C0 A0 93 30 00 50 E3 01 C0 8C 02 03 50 50 E0 04 C0 8C E0 F1 FF FF 0A 8C C0 8C E0 0C 60 86 E0 30 00 53 E3 01 60 86 02 30 30 43 E2 09 00 53 E3 06 30 A0 81 01 30 86 92 DC 00 D3 E1 02 00 50 E3 05 00 A0 01 01 00 00 0A 03 00 50 E3 05 00 00 0A 70 00 BD E8 ?? ?? ?? ?? 01 30 D1 E4 30 30 43 E2 09 00 53 E3 0C 00 00 8A 01 30 D2 E4 30 30 43 E2 09 00 53 E3 F7 FF FF 9A 00 30 D1 E5 30 30 43 E2 09 00 53 E3 05 00 A0 81 00 00 E0 93 EF FF FF EA 00 00 A0 E3 70 00 BD E8 ?? ?? ?? ?? 01 00 A0 E3 EA FF FF EA 04 00 A0 E1 E8 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "getnetent"
		size = 312
		refs = "004c __aeabi_read_tp 0070 __nss_getent 00f0 __lll_lock_wait_private 0124 __libc_h_errno 0128 __getnetent_r 0130 __libc_errno"
	strings:
		$1 = { F0 41 2D E9 01 10 A0 E3 08 D0 4D E2 08 21 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 2A 00 00 1A D8 40 9F E5 D8 30 9F E5 00 40 8D E5 ?? ?? ?? ?? 03 30 9F E7 03 30 80 E0 00 50 A0 E1 04 30 8D E5 10 10 44 E2 01 3B A0 E3 B8 00 9F E5 B8 20 9F E5 ?? ?? ?? ?? B4 30 9F E5 03 30 9F E7 03 80 95 E7 00 60 A0 E1 14 70 44 E2 00 50 97 E5 00 10 A0 E3 05 40 A0 E1 80 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 0A 00 00 CA 60 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 80 E7 06 00 A0 E1 08 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? D1 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_0_0 {
	meta:
		name = "__dup2"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 3F 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "__wctrans"
		size = 144
		refs = "0010 __aeabi_read_tp 0034 __rawmemchr 0054 strcmp 008c _nl_current_LC_CTYPE"
	strings:
		$1 = { F8 40 2D E9 80 30 9F E5 00 60 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 30 90 E7 00 70 93 E5 50 40 97 E5 00 00 D4 E5 00 00 50 E3 12 00 00 0A 00 50 A0 E3 05 00 00 EA ?? ?? ?? ?? 01 30 D0 E5 00 00 53 E3 01 50 85 E2 01 40 80 E2 0C 00 00 0A 04 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E3 01 00 50 E1 04 00 A0 E1 F2 FF FF 1A 6C 30 97 E5 03 50 85 E0 05 71 87 E0 24 00 97 E5 F8 40 BD E8 ?? ?? ?? ?? 03 00 A0 E1 F8 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "critical_factorization"
		size = 336
		refs = "0010 __aeabi_read_tp 0148 __libc_tsd_CTYPE_TOLOWER"
	strings:
		$1 = { F0 47 2D E9 3C 41 9F E5 00 30 A0 E1 04 40 9F E7 ?? ?? ?? ?? 01 70 A0 E3 04 00 90 E7 07 E0 A0 E1 00 40 A0 E3 00 60 E0 E3 04 C0 8E E0 01 00 5C E1 06 50 83 E0 0C 00 00 2A 0E 50 D5 E7 0C 80 D3 E7 05 51 D0 E7 08 81 D0 E7 05 00 58 E1 27 00 00 2A 0C 40 A0 E1 01 E0 A0 E3 0C 70 66 E0 04 C0 8E E0 01 00 5C E1 06 50 83 E0 F2 FF FF 3A 00 70 82 E5 D4 40 9F E5 ?? ?? ?? ?? 04 40 9F E7 01 90 A0 E3 04 70 90 E7 00 50 A0 E3 09 40 A0 E1 00 00 E0 E3 05 C0 84 E0 0C 00 51 E1 00 80 83 E0 0C 00 00 9A 04 80 D8 E7 0C A0 D3 E7 08 81 D7 E7 0A A1 D7 E7 08 00 5A E1 13 00 00 9A 0C 50 A0 E1 01 40 A0 E3 0C 90 60 E0 05 C0 84 E0 0C 00 51 E1 00 80 83 E0 F2 FF FF 8A 01 00 80 E2 01 60 86 E2 06 00 50 E1 06 00 A0 31 00 90 82 25 F0 47 BD E8 ?? ?? ?? ?? 0A 00 00 0A 01 70 A0 E3 04 60 A0 E1 07 E0 A0 E1 07 40 84 E0 C7 FF FF EA 09 00 00 0A 01 90 A0 E3 05 00 A0 E1 09 40 A0 E1 09 50 85 E0 DB FF FF EA 07 00 5E E1 01 E0 8E 12 0C 40 A0 01 01 E0 A0 03 BC FF FF EA 09 00 54 E1 01 40 84 12 0C 50 A0 01 01 40 A0 03 D1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_25_1_0 {
	meta:
		name = "two_way_long_needle"
		size = 1096
		refs = "005c __aeabi_read_tp 00b0 __strncasecmp 0148 memchr 043c __libc_tsd_CTYPE_TOLOWER"
	strings:
		$1 = { F0 4F 2D E9 42 DE 4D E2 0C D0 4D E2 02 90 A0 E1 03 40 A0 E1 24 20 8D E2 01 30 A0 E1 00 60 A0 E1 04 10 A0 E1 09 00 A0 E1 04 30 8D E5 9F FF FF EB 42 1E 8D E2 0C 00 8D E5 04 30 9D E5 24 20 8D E2 04 10 81 E2 04 40 A2 E5 01 00 52 E1 FC FF FF 1A 00 00 54 E3 0F 00 00 0A DC 23 9F E5 ?? ?? ?? ?? 02 20 9F E7 02 E0 90 E7 01 C0 44 E2 00 20 A0 E3 02 10 D9 E7 42 5E 8D E2 01 11 9E E7 0C 00 62 E0 08 50 85 E2 01 20 82 E2 01 11 85 E0 04 00 52 E1 00 04 01 E5 F5 FF FF 1A 24 50 9D E5 09 00 A0 E1 05 10 89 E0 0C 20 9D E5 04 30 8D E5 08 50 8D E5 ?? ?? ?? ?? 00 00 50 E3 04 30 9D E5 71 00 00 1A 0C 50 9D E5 74 23 9F E5 01 50 45 E2 02 20 9F E7 00 80 A0 E1 10 50 8D E5 ?? ?? ?? ?? 02 50 90 E7 08 10 9D E5 10 00 9D E5 0C 20 9D E5 00 00 89 E0 04 10 61 E0 01 20 62 E2 18 00 8D E5 08 B0 A0 E1 01 70 44 E2 14 10 8D E5 1C 20 8D E5 03 00 A0 E1 08 00 00 EA 00 00 58 E3 03 00 00 0A 08 10 9D E5 14 20 9D E5 03 00 51 E1 02 30 A0 81 03 B0 8B E0 00 80 A0 E3 0A 00 A0 E1 04 A0 8B E0 0A 20 60 E0 00 10 A0 E3 00 00 86 E0 ?? ?? ?? ?? 00 00 50 E3 47 00 00 1A 00 00 5A E3 45 00 00 0A 0A 30 86 E0 01 30 53 E5 42 0E 8D E2 03 31 95 E7 08 00 80 E2 03 31 80 E0 00 34 13 E5 00 00 53 E3 E4 FF FF 1A 0C 30 9D E5 03 00 58 E1 08 30 A0 21 0B 00 83 E0 07 00 53 E1 00 20 86 E0 03 10 89 E0 0F 00 00 2A 00 00 D6 E7 03 C0 D9 E7 00 01 95 E7 0C C1 95 E7 00 00 5C E1 06 00 00 0A 2A 00 00 EA 01 C0 F1 E5 01 00 F2 E5 0C C1 95 E7 00 01 95 E7 00 00 5C E1 24 00 00 1A 01 30 83 E2 07 00 53 E1 F6 FF FF 3A 0C 30 9D E5 10 00 9D E5 03 00 58 E1 00 30 8B E0 03 10 86 E0 8C 00 00 2A 18 00 9D E5 03 30 D6 E7 00 20 D0 E5 03 31 95 E7 02 21 95 E7 03 00 52 E1 85 00 00 1A 00 20 A0 E1 10 30 9D E5 07 00 00 EA 01 C0 72 E5 01 00 71 E5 0C C1 95 E7 00 01 95 E7 00 00 5C E1 01 00 43 E2 03 00 00 1A 00 30 A0 E1 08 00 53 E1 F5 FF FF 1A 08 30 A0 E1 01 80 88 E2 03 00 58 E1 76 00 00 8A 08 30 9D E5 14 80 9D E5 03 B0 8B E0 B2 FF FF EA 1C 10 9D E5 0B B0 81 E0 AD FF FF EA 00 00 A0 E3 42 DE 8D E2 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 0C 50 9D E5 04 20 65 E0 05 00 52 E1 05 20 A0 31 01 20 82 E2 01 50 45 E2 1C 20 8D E5 24 20 8D E5 10 50 8D E5 90 21 9F E5 05 50 89 E0 02 20 9F E7 14 50 8D E5 0C 50 9D E5 ?? ?? ?? ?? 01 50 65 E2 18 50 8D E5 02 50 90 E7 0C 00 9D E5 14 10 8D E2 00 B0 89 E0 06 00 91 E8 08 B0 8D E5 0C B0 9D E5 02 A0 81 E0 00 90 A0 E3 01 70 44 E2 03 00 A0 E1 04 80 89 E0 08 20 60 E0 00 10 A0 E3 00 00 86 E0 ?? ?? ?? ?? 00 00 50 E3 D7 FF FF 1A 00 00 58 E3 D5 FF FF 0A 08 30 86 E0 01 30 53 E5 42 0E 8D E2 03 31 95 E7 08 00 80 E2 03 31 80 E0 00 34 13 E5 00 00 53 E3 32 00 00 1A 0B 30 89 E0 07 00 5B E1 03 10 86 E0 12 00 00 2A 08 00 9D E5 03 30 D6 E7 00 20 D0 E5 03 31 95 E7 02 21 95 E7 03 00 52 E1 2A 00 00 1A 00 20 A0 E1 0B 30 A0 E1 05 00 00 EA 01 C0 F2 E5 01 00 F1 E5 0C C1 95 E7 00 01 95 E7 00 00 5C E1 22 00 00 1A 01 30 83 E2 07 00 53 E1 F6 FF FF 3A 10 30 9D E5 01 00 73 E3 03 30 89 E0 03 20 86 E0 10 00 00 0A 14 00 9D E5 03 30 D6 E7 00 10 D0 E5 03 31 95 E7 01 11 95 E7 03 00 51 E1 0E 00 00 1A 00 30 A0 E1 05 00 00 EA 01 00 73 E5 01 10 72 E5 00 01 95 E7 01 11 95 E7 01 00 50 E1 06 00 00 1A 0A 00 53 E1 F7 FF FF 1A 09 00 86 E0 42 DE 8D E2 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 1C 30 9D E5 03 90 89 E0 08 00 A0 E1 B7 FF FF EA 0B 30 A0 E1 18 00 9D E5 09 90 80 E0 03 90 89 E0 F8 FF FF EA 0C 30 9D E5 85 FF FF EA 0B 00 86 E0 8E FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_25_2_0 {
	meta:
		name = "__strcasestr"
		size = 1200
		refs = "002c __aeabi_read_tp 00e8 __strncasecmp 0140 memchr 04a4 __libc_tsd_CTYPE_TOLOWER"
	strings:
		$1 = { F0 4F 2D E9 00 30 D0 E5 00 00 53 E3 34 D0 4D E2 00 90 A0 E1 01 80 A0 E1 18 01 00 0A 00 20 D1 E5 00 00 52 E3 9B 00 00 0A 74 14 9F E5 ?? ?? ?? ?? 01 10 9F E7 01 40 90 E7 09 C0 A0 E1 01 10 88 E2 01 70 A0 E3 02 00 00 EA 01 20 D1 E4 00 00 52 E3 0B 00 00 0A 03 01 94 E7 02 21 94 E7 01 30 FC E5 02 00 50 E1 00 70 A0 13 01 70 07 02 00 00 53 E3 01 60 A0 E1 F3 FF FF 1A 00 30 D6 E5 00 00 53 E3 80 00 00 1A 00 00 57 E3 82 00 00 1A 06 60 68 E0 1F 00 56 E3 01 90 89 E2 01 50 46 E2 07 00 00 9A 09 00 A0 E1 05 10 A0 E1 08 20 A0 E1 06 30 A0 E1 C0 FE FF EB 34 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 06 10 A0 E1 2C 20 8D E2 08 00 A0 E1 65 FE FF EB 2C 30 9D E5 00 20 A0 E1 00 B0 A0 E1 03 10 88 E0 08 00 A0 E1 0C 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 51 00 00 1A AC 33 9F E5 ?? ?? ?? ?? 03 30 9F E7 01 20 4B E2 03 40 90 E7 02 30 88 E0 08 30 8D E5 0C 30 9D E5 06 30 63 E0 14 30 8D E5 01 30 6B E2 04 20 8D E5 10 30 8D E5 07 A0 A0 E1 05 00 A0 E1 06 50 8A E0 05 20 60 E0 00 10 A0 E3 00 00 89 E0 ?? ?? ?? ?? 00 00 50 E3 4E 00 00 1A 00 00 55 E3 4C 00 00 0A 0B 00 57 E1 07 30 A0 21 0B 30 A0 31 0A 00 83 E0 03 00 56 E1 00 20 89 E0 03 10 88 E0 0F 00 00 9A 00 00 D9 E7 03 C0 D8 E7 00 01 94 E7 0C C1 94 E7 00 00 5C E1 06 00 00 0A 45 00 00 EA 01 C0 F1 E5 01 00 F2 E5 0C C1 94 E7 00 01 94 E7 00 00 5C E1 3F 00 00 1A 01 30 83 E2 03 00 56 E1 F6 FF FF 8A 04 00 9D E5 07 00 5B E1 00 30 8A E0 03 10 89 E0 AB 00 00 9A 08 00 9D E5 03 30 D9 E7 00 20 D0 E5 03 31 94 E7 02 21 94 E7 03 00 52 E1 A4 00 00 1A 00 20 A0 E1 04 30 9D E5 07 00 00 EA 01 C0 72 E5 01 00 71 E5 0C C1 94 E7 00 01 94 E7 00 00 5C E1 01 00 43 E2 03 00 00 1A 00 30 A0 E1 07 00 53 E1 F5 FF FF 1A 07 30 A0 E1 01 70 87 E2 03 00 57 E1 98 00 00 8A 0C 30 9D E5 14 70 9D E5 03 A0 8A E0 05 00 A0 E1 BC FF FF EA 68 32 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 40 90 E7 0B 30 D8 E7 01 00 8B E2 03 A1 D4 E7 00 00 55 E1 0B 30 89 E0 04 00 8D E5 0C 30 8D E5 14 00 00 2A 02 20 66 E2 05 00 89 E0 07 10 A0 E1 0B 20 82 E0 ?? ?? ?? ?? 00 00 50 E3 0C 00 00 0A 00 00 A0 E3 34 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 09 00 A0 E1 34 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 10 00 9D E5 0A A0 80 E0 03 A0 8A E0 00 70 A0 E3 DD FF FF EA 04 50 9D E5 06 30 6B E0 0B 00 53 E1 0B 30 A0 31 01 00 4B E2 01 30 83 E2 24 30 8D E5 00 30 88 E0 14 30 8D E5 01 30 6B E2 20 30 8D E5 24 30 9D E5 2C 30 8D E5 04 30 9D E5 10 00 8D E5 03 80 88 E0 20 00 9D E5 14 30 9D E5 00 70 83 E0 02 30 8B E2 08 80 8D E5 0C 10 9D E5 18 30 8D E5 1C B0 8D E5 02 00 00 EA 00 00 52 E3 D7 FF FF 0A 03 10 A0 E1 00 30 D1 E5 03 21 D4 E7 02 00 5A E1 01 30 81 E2 F7 FF FF 1A 0C 00 9D E5 04 20 9D E5 03 30 60 E0 02 00 56 E1 01 80 43 E2 14 00 00 9A 08 00 9D E5 01 30 D1 E5 00 20 D0 E5 03 31 D4 E7 02 21 94 E7 03 00 52 E1 02 10 81 E2 46 00 00 1A 08 20 9D E5 18 30 9D E5 07 00 00 EA 01 00 F2 E5 01 C0 D1 E4 00 01 94 E7 0C C1 D4 E7 0C 00 50 E1 01 00 83 E2 1B 00 00 1A 00 30 A0 E1 03 00 56 E1 F5 FF FF 1A 10 30 9D E5 01 00 73 E3 03 30 88 E0 03 20 89 E0 11 00 00 0A 14 00 9D E5 03 30 D9 E7 00 10 D0 E5 03 31 D4 E7 01 11 94 E7 03 00 51 E1 03 10 A0 11 20 00 00 1A 14 30 9D E5 05 00 00 EA 01 00 73 E5 01 10 72 E5 00 01 94 E7 01 11 D4 E7 01 00 50 E1 18 00 00 1A 07 00 53 E1 F7 FF FF 1A 08 00 89 E0 28 FF FF EA 00 00 5C E3 9B FF FF 0A 03 00 56 E1 E2 FF FF 9A 20 20 9D E5 08 80 82 E0 03 B0 88 E0 06 80 8B E0 08 20 65 E0 05 00 89 E0 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 8F FF FF 1A 00 00 58 E3 8D FF FF 0A 1C 00 9D E5 00 30 8B E0 03 30 89 E0 08 50 A0 E1 B0 FF FF EA 00 00 51 E3 86 FF FF 0A 24 30 9D E5 03 B0 88 E0 EC FF FF EA 0B 30 A0 E1 66 FF FF EA 01 60 A0 E1 01 70 A0 E3 FA FE FF EA 0A 00 89 E0 07 FF FF EA 00 00 53 E3 7A FF FF 0A 04 30 9D E5 DE FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "__libc_csu_init"
		size = 172
		refs = "005c _init 009c __preinit_array_start 00a0 __preinit_array_end 00a4 __init_array_start 00a8 __init_array_end"
	strings:
		$1 = { F8 43 2D E9 90 80 9F E5 90 90 9F E5 09 90 68 E0 49 91 B0 E1 00 50 A0 E1 01 60 A0 E1 02 70 A0 E1 04 80 48 12 00 40 A0 13 08 00 00 0A 01 40 84 E2 04 30 B8 E5 05 00 A0 E1 06 10 A0 E1 07 20 A0 E1 0F E0 A0 E1 ?? ?? ?? ?? 09 00 54 E1 F6 FF FF 1A 4C 80 9F E5 4C 90 9F E5 09 90 68 E0 ?? ?? ?? ?? 49 91 B0 E1 04 80 48 12 00 40 A0 13 08 00 00 0A 01 40 84 E2 04 30 B8 E5 05 00 A0 E1 06 10 A0 E1 07 20 A0 E1 0F E0 A0 E1 ?? ?? ?? ?? 09 00 54 E1 F6 FF FF 1A F8 43 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_26_1_0 {
	meta:
		name = "__libc_csu_fini"
		size = 68
		refs = "0030 _fini 003c __fini_array_start 0040 __fini_array_end"
	strings:
		$1 = { 38 40 2D E9 30 50 9F E5 30 40 9F E5 04 40 65 E0 44 41 B0 E1 04 51 85 10 04 00 00 0A 04 30 35 E5 0F E0 A0 E1 ?? ?? ?? ?? 01 40 54 E2 FA FF FF 1A ?? ?? ?? ?? 38 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_0_0 {
	meta:
		name = "xdr_rmtcallres"
		size = 128
		refs = "0024 xdr_reference 0048 xdr_u_long"
	strings:
		$1 = { 30 40 2D E9 00 20 91 E5 0C D0 4D E2 01 40 A0 E1 08 10 8D E2 04 20 21 E5 5C 30 9F E5 04 20 A0 E3 00 50 A0 E1 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 00 00 A0 E3 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? 05 00 A0 E1 04 10 84 E2 ?? ?? ?? ?? 00 00 50 E3 F6 FF FF 0A 04 30 9D E5 05 00 A0 E1 00 30 84 E5 08 10 94 E5 0C C0 94 E5 0F E0 A0 E1 ?? ?? ?? ?? 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_1_0 {
	meta:
		name = "xdr_rmtcall_args"
		size = 300
		refs = "0010 xdr_u_long"
	strings:
		$1 = { F0 41 2D E9 08 D0 4D E2 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 00 00 A0 E3 08 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 04 00 A0 E1 04 10 85 E2 ?? ?? ?? ?? 00 00 50 E3 F6 FF FF 0A 04 00 A0 E1 08 10 85 E2 ?? ?? ?? ?? 00 00 50 E3 F1 FF FF 0A 00 30 A0 E3 08 60 8D E2 04 30 26 E5 04 00 A0 E1 04 30 94 E5 10 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 00 70 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 E3 FF FF 0A 04 30 94 E5 04 00 A0 E1 10 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 10 10 95 E5 00 60 A0 E1 04 00 A0 E1 14 C0 95 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 D6 FF FF 0A 04 30 94 E5 04 00 A0 E1 10 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 60 66 E0 0C 60 A5 E5 07 10 A0 E1 04 30 94 E5 00 80 A0 E1 04 00 A0 E1 14 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 C3 FF FF 0A 08 10 A0 E1 04 30 94 E5 04 00 A0 E1 14 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 01 00 A0 E3 BC FF FF EA }
	condition:
		$1
}

rule file_27_2_0 {
	meta:
		name = "pmap_rmtcall"
		size = 268
		refs = "0048 clntudp_create 0104 xdr_rmtcallres 0108 xdr_rmtcall_args"
	strings:
		$1 = { F0 43 2D E9 F0 E0 9F E5 44 D0 4D E2 40 C0 8D E2 00 40 E0 E3 2C 40 2C E5 04 90 9E E5 6F 4C A0 E3 03 60 A0 E1 00 90 8D E5 04 C0 8D E5 01 80 A0 E1 B2 40 C0 E1 02 70 A0 E1 00 30 9E E5 BC 10 9F E5 02 20 A0 E3 00 50 A0 E1 ?? ?? ?? ?? 00 40 50 E2 10 60 A0 03 22 00 00 0A 64 20 9D E5 38 20 8D E5 60 20 9D E5 3C 20 8D E5 78 20 9D E5 18 20 8D E5 6C 20 9D E5 70 30 8D E2 03 00 93 E8 20 20 8D E5 7C E0 9F E5 68 20 9D E5 18 30 8D E2 08 C0 8D E2 30 60 8D E5 24 20 8D E5 04 60 94 E5 28 80 8D E5 04 30 8D E5 2C 70 8D E5 00 E0 8D E5 28 30 8D E2 03 00 8C E8 4C 20 9F E5 04 00 A0 E1 05 10 A0 E3 00 C0 96 E5 0F E0 A0 E1 ?? ?? ?? ?? 04 30 94 E5 00 60 A0 E1 04 00 A0 E1 10 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 30 A0 E3 06 00 A0 E1 B2 30 C5 E1 44 D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? A0 86 01 00 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_3_0 {
	meta:
		name = "clnt_broadcast"
		size = 1604
		refs = "001c authunix_create_default 0044 __socket 0064 __setsockopt 008c getifaddrs 0134 __dcgettext 0138 perror 0144 __close 0190 freeifaddrs 01cc _create_xid 0294 xdrmem_create 02a0 xdr_callmsg 02bc xdr_rmtcall_args 0348 __sendto 03dc __poll 042c __aeabi_read_tp 046c __recvfrom 04a0 xdr_replymsg 05f0 _libc_intl_domainname 0618 xdr_void 0620 _null_auth 0624 xdr_rmtcallres 062c __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 A3 DD 4D E2 3C D0 4D E2 01 A0 A0 E1 02 90 A0 E1 03 80 A0 E1 00 B0 A0 E1 ?? ?? ?? ?? B8 35 9F E5 00 40 A0 E1 A3 CD 8D E2 02 00 A0 E3 38 C0 8C E2 01 60 A0 E3 00 10 A0 E1 11 20 A0 E3 03 60 8C E7 ?? ?? ?? ?? 00 50 50 E2 47 00 00 BA 04 20 A0 E3 00 20 8D E5 30 30 8D E2 06 10 A0 E1 06 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 2D 00 00 BA 6C 35 9F E5 69 0E 8D E2 A3 1D 8D E2 38 10 81 E2 08 00 80 E2 BC 63 CD E1 03 50 81 E7 ?? ?? ?? ?? 00 60 50 E2 B8 00 00 1A 48 35 9F E5 A3 ED 8D E2 38 E0 8E E2 03 00 9E E7 00 00 50 E3 36 00 00 0A 00 30 A0 E1 07 00 00 EA 00 30 93 E5 13 00 56 E3 00 20 A0 C3 01 20 A0 D3 00 00 53 E3 00 20 A0 03 00 00 52 E3 2D 00 00 0A 08 20 93 E5 03 20 02 E2 03 00 52 E3 F3 FF FF 1A 0C 20 93 E5 00 00 52 E3 F0 FF FF 0A B0 20 D2 E1 02 00 52 E3 ED FF FF 1A 14 10 93 E5 A3 CD 8D E2 38 C0 8C E2 06 21 8C E0 04 10 91 E5 0A 2B 42 E2 28 10 02 E5 01 60 86 E2 28 20 42 E2 E3 FF FF EA BC 14 9F E5 05 20 A0 E3 B8 04 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 03 60 A0 E3 05 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 20 30 94 E5 10 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 06 00 A0 E1 A3 DD 8D E2 3C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 7C 14 9F E5 05 20 A0 E3 70 04 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 03 60 A0 E3 EC FF FF EA 00 60 A0 E1 ?? ?? ?? ?? 20 60 8D E5 58 14 9F E5 A3 ED 8D E2 00 60 A0 E3 02 30 A0 E3 6F 2C A0 E3 38 E0 8E E2 40 70 8D E2 B1 30 8E E1 B2 20 C7 E1 44 60 8D E5 0C 30 8D E5 48 60 8D E5 4C 60 8D E5 ?? ?? ?? ?? 0C 30 9D E5 20 14 9F E5 05 20 A0 E3 B0 30 8D E5 A8 30 8D E5 AC 10 8D E5 B4 20 8D E5 1C 00 8D E5 07 00 94 E8 B8 30 8D E2 07 00 83 E8 10 30 8D E5 0C 30 84 E2 07 00 93 E8 C4 30 8D E2 07 00 83 E8 E8 C3 9F E5 1C 00 9D E5 A3 1D 8D E2 38 10 81 E2 0C 00 81 E7 A0 C0 8D E2 D4 E3 9F E5 18 C0 8D E5 A3 CD 8D E2 38 C0 8C E2 0E B0 8C E7 C4 23 9F E5 A3 ED 8D E2 34 C0 8D E2 38 E0 8E E2 02 C0 8E E7 02 CA 8D E2 20 C9 9C E5 02 EA 8D E2 98 C0 8D E5 02 CA 8D E2 24 E9 9E E5 28 C9 9C E5 06 30 A0 E1 70 00 8D E2 12 1E 8D E2 8C 23 9F E5 6C E0 8D E5 A4 60 8D E5 8C A0 8D E5 90 90 8D E5 9C 80 8D E5 68 C0 8D E5 ?? ?? ?? ?? 70 00 8D E2 18 10 9D E5 ?? ?? ?? ?? 06 00 50 E1 01 00 00 1A 01 60 A0 E3 A2 FF FF EA 88 10 8D E2 70 00 8D E2 ?? ?? ?? ?? 06 00 50 E1 F8 FF FF 0A 74 30 9D E5 70 00 8D E2 10 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 74 30 9D E5 1C 30 93 E5 00 00 53 E3 00 60 A0 E1 70 00 8D 12 0F E0 A0 11 ?? ?? ?? ?? FA EE A0 E3 14 E0 8D E5 24 40 8D E5 20 B0 9D E5 00 00 5B E3 1F 00 00 0A CC 40 8D E2 00 80 A0 E3 40 90 8D E2 10 A0 A0 E3 01 00 00 EA 0B 00 58 E1 18 00 00 0A 04 30 B4 E5 05 00 A0 E1 00 06 8D E8 12 1E 8D E2 04 30 87 E5 06 20 A0 E1 00 30 A0 E3 ?? ?? ?? ?? 00 00 56 E1 01 80 88 E2 09 70 A0 E1 F1 FF FF 0A AC 12 9F E5 05 20 A0 E3 84 02 9F E5 24 40 9D E5 ?? ?? ?? ?? ?? ?? ?? ?? 03 60 A0 E3 70 FF FF EA 90 02 9F E5 ?? ?? ?? ?? 00 C0 A0 E3 20 C0 8D E5 81 FF FF EA 02 0A 8D E2 2C 09 90 E5 00 00 50 E3 63 00 00 0A 20 60 8D E5 6C 42 9F E5 6C A2 9F E5 18 60 9D E5 68 32 9F E5 07 00 93 E8 64 E2 9F E5 0C 30 86 E2 07 00 83 E8 60 C0 8D E2 38 00 8D E2 01 10 A0 E3 14 20 9D E5 1C C0 86 E5 20 E0 86 E5 ?? ?? ?? ?? 01 00 70 E3 54 00 00 0A 00 00 50 E3 09 00 00 1A 14 00 9D E5 7D 0E 80 E2 FA 0D 50 E3 18 60 8D E5 14 00 8D E5 20 60 9D E5 BE FF FF 1A 24 40 9D E5 05 60 A0 E3 49 FF FF EA 08 92 9F E5 10 80 A0 E3 05 00 00 EA 00 E2 9F E5 0E 30 9F E7 ?? ?? ?? ?? 03 30 90 E7 04 00 53 E3 4D 00 00 1A A3 CD 8D E2 50 20 8D E2 2C 30 8D E2 38 C0 8C E2 69 1E 8D E2 00 20 8D E5 04 30 8D E5 05 00 A0 E1 08 10 81 E2 C8 21 9F E5 00 30 A0 E3 09 80 8C E7 ?? ?? ?? ?? 00 00 50 E3 EA FF FF BA 03 00 50 E3 CB FF FF 9A 69 1E 8D E2 00 20 A0 E1 08 10 81 E2 70 00 8D E2 01 30 A0 E3 ?? ?? ?? ?? 70 00 8D E2 06 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 80 A0 01 07 00 00 0A 48 31 9F E5 A3 0D 8D E2 38 00 80 E2 03 30 90 E7 1C 10 9D E5 03 00 51 E1 31 00 00 0A 00 80 A0 E3 5C 31 9F E5 20 40 86 E5 A3 ED 8D E2 A0 60 8D E2 02 20 A0 E3 38 E0 8E E2 06 10 A0 E1 70 00 8D E2 03 20 8E E7 ?? ?? ?? ?? 02 2A 8D E2 24 39 92 E5 70 00 8D E2 28 19 92 E5 0F E0 A0 E1 ?? ?? ?? ?? 74 30 9D E5 1C 30 93 E5 00 00 53 E3 70 00 8D 12 0F E0 A0 11 ?? ?? ?? ?? 00 00 58 E3 9F FF FF 0A 24 40 9D E5 00 60 A0 E3 00 FF FF EA F4 10 9F E5 ?? ?? ?? ?? 01 30 9F E7 03 30 90 E7 04 00 53 E3 96 FF FF 0A E0 10 9F E5 05 20 A0 E3 8C 00 9F E5 24 40 9D E5 ?? ?? ?? ?? ?? ?? ?? ?? 04 60 A0 E3 F2 FE FF EA C4 10 9F E5 05 20 A0 E3 6C 00 9F E5 24 40 9D E5 ?? ?? ?? ?? ?? ?? ?? ?? 04 60 A0 E3 EA FE FF EA 08 80 96 E5 00 00 58 E3 CA FF FF 1A B8 30 9D E5 00 00 53 E3 C8 FF FF 1A 0A 30 90 E7 03 28 A0 E1 03 34 A0 E1 22 3C 83 E1 02 2A 8D E2 B2 35 CD E1 28 09 92 E5 50 10 8D E2 2C 39 92 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 BB FF FF EA 38 D7 FF FF 40 D7 FF FF A0 DD FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 48 D7 FF FF A0 86 01 00 A8 D7 FF FF 90 D7 FF FF 68 D7 FF FF 78 05 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 3C D7 FF FF ?? ?? ?? ?? ?? ?? ?? ?? 34 D7 FF FF ?? ?? ?? ?? 60 22 00 00 78 D7 FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "compute_tzname_max"
		size = 100
		refs = "0060 __tzname_cur_max"
	strings:
		$1 = { 54 30 9F E5 00 10 93 E5 50 C0 9F E5 00 00 81 E0 00 30 D1 E5 00 00 53 E3 0D 00 00 0A 01 20 81 E2 02 30 A0 E1 00 20 D2 E5 00 00 52 E3 01 20 83 E2 FA FF FF 1A 00 20 9C E5 03 10 61 E0 01 00 52 E1 00 10 8C 35 01 10 83 E2 00 00 51 E1 EF FF FF 3A ?? ?? ?? ?? 01 30 A0 E1 F9 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_1_0 {
	meta:
		name = "__tzfile_read"
		size = 3184
		refs = "0058 getenv 0070 strlen 00a4 mempcpy 00bc memcpy 00d4 __xstat64 00e8 _IO_new_fopen 00f4 fileno 0104 __fxstat64 011c free 0170 fread_unlocked 0188 memcmp 019c _IO_new_fclose 01dc strstr 03a0 malloc 04dc __uflow 07ec __tzstring 0a6c fseek 0a7c ftello 0c24 __assert_fail 0c28 __use_tzfile 0c2c __libc_enable_secure 0c54 __tzname 0c58 __timezone 0c5c __daylight"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 C4 D0 4D E2 C8 10 0B E5 10 1C 9F E5 00 30 A0 E3 00 40 50 E2 00 70 91 E5 CC 20 0B E5 00 30 81 E5 96 00 00 0A 00 50 D4 E5 03 00 55 E1 5C 00 00 0A EC 3B 9F E5 00 30 93 E5 00 00 53 E3 60 00 00 1A 2F 00 55 E3 04 60 A0 01 1A 00 00 0A D4 0B 9F E5 ?? ?? ?? ?? 00 50 50 E2 21 02 00 0A 00 30 D5 E5 00 00 53 E3 75 00 00 0A ?? ?? ?? ?? 00 90 A0 E1 01 60 80 E2 04 00 A0 E1 ?? ?? ?? ?? 01 80 80 E2 06 30 88 E0 0E 30 83 E2 07 30 C3 E3 03 D0 4D E0 05 10 A0 E1 09 20 A0 E1 0D 00 A0 E1 ?? ?? ?? ?? 2F 30 A0 E3 01 30 C0 E4 08 20 A0 E1 04 10 A0 E1 0D 60 A0 E1 ?? ?? ?? ?? 00 00 57 E3 05 00 00 0A 03 00 A0 E3 06 10 A0 E1 8C 20 4B E2 ?? ?? ?? ?? 00 00 50 E3 42 00 00 0A 06 00 A0 E1 48 1B 9F E5 ?? ?? ?? ?? 00 80 50 E2 2D 00 00 0A ?? ?? ?? ?? 8C 20 4B E2 00 10 A0 E1 03 00 A0 E3 ?? ?? ?? ?? 00 30 50 E2 24 00 00 1A 20 9B 9F E5 00 00 99 E5 E4 30 0B E5 ?? ?? ?? ?? 00 20 98 E5 E4 30 1B E5 8C 70 4B E2 C0 00 97 E8 2C 50 4B E2 30 00 95 E8 3C C0 1B E5 F8 AA 9F E5 02 29 82 E3 00 20 88 E5 00 30 89 E5 B8 00 4B E2 2C 10 A0 E3 01 20 A0 E3 08 30 A0 E1 10 60 8A E5 14 70 8A E5 08 40 8A E5 0C 50 8A E5 18 C0 8A E5 ?? ?? ?? ?? 01 00 50 E3 06 00 00 1A B8 00 4B E2 B8 1A 9F E5 04 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 D0 00 0B E5 3D 00 00 0A 08 00 A0 E1 ?? ?? ?? ?? 02 00 00 EA 08 00 A0 E1 ?? ?? ?? ?? 84 9A 9F E5 00 00 99 E5 ?? ?? ?? ?? 00 30 A0 E3 00 30 89 E5 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 2F 00 55 E3 20 00 00 0A 04 00 A0 E1 64 1A 9F E5 ?? ?? ?? ?? 00 00 50 E3 F0 FF FF 1A 96 FF FF EA 48 1A 9F E5 2C 50 4B E2 30 00 95 E8 08 30 81 E2 0C 00 93 E8 03 00 55 E1 02 00 54 01 B4 FF FF 1A 8C 50 4B E2 30 00 95 E8 10 30 81 E2 0C 00 93 E8 03 00 55 E1 02 00 54 01 AD FF FF 1A 18 30 91 E5 3C 20 1B E5 03 00 52 E1 A9 FF FF 1A E8 29 9F E5 01 30 A0 E3 00 30 82 E5 DD FF FF EA F8 59 9F E5 14 60 A0 E3 13 90 A0 E3 88 FF FF EA EC 19 9F E5 0F 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 D9 FF FF 0A 04 00 A0 E1 D0 19 9F E5 13 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 D3 FF FF 0A C8 FF FF EA BC 69 9F E5 8B FF FF EA 98 00 4B E2 41 00 90 E8 60 38 20 E0 9C 10 1B E5 23 34 A0 E1 FF 3C C3 E3 60 44 23 E0 66 28 26 E0 61 38 21 E0 A0 C0 1B E5 A4 E0 1B E5 22 24 A0 E1 23 34 A0 E1 90 70 1B E5 80 09 9F E5 FF 2C C2 E3 FF 3C C3 E3 66 64 22 E0 61 34 23 E0 6E 28 2E E0 6C 18 2C E0 00 00 54 E1 21 14 A0 E1 67 08 27 E0 22 24 A0 E1 20 04 A0 E1 FF 1C C1 E3 FF 2C C2 E3 FF 0C C0 E3 6C 14 21 E0 6E 24 22 E0 1C 40 8A E5 20 60 8A E5 24 30 8A E5 67 74 20 E0 DC 10 0B E5 D4 20 0B E5 9B FF FF 8A 04 11 A0 E1 04 50 81 E0 03 50 85 E2 03 50 C5 E3 05 20 E0 E1 A2 01 56 E1 D8 10 0B E5 93 FF FF 8A 86 61 A0 E1 06 20 85 E0 02 10 E0 E1 07 00 51 E1 8E FF FF 3A 07 20 82 E0 04 00 72 E3 8B FF FF 8A 03 20 82 E2 03 10 C2 E3 01 20 E0 E1 A2 01 53 E1 86 FF FF 8A 83 31 A0 E1 03 00 81 E0 C8 20 1B E5 E0 30 0B E5 00 30 E0 E1 02 00 53 E1 7F FF FF 3A 02 00 80 E0 E4 10 0B E5 ?? ?? ?? ?? 00 00 50 E3 00 00 89 E5 E4 10 1B E5 78 FF FF 0A D8 20 1B E5 02 E0 80 E0 01 20 80 E0 C8 10 1B E5 05 30 80 E0 00 00 51 E3 06 C0 83 E0 00 10 A0 E3 2C 30 8A E5 E0 30 1B 15 34 10 8A E5 CC 10 1B 15 30 20 8A E5 03 20 82 10 00 20 81 15 08 30 A0 E1 04 20 A0 E1 05 10 A0 E3 00 C0 8A E5 28 E0 8A E5 ?? ?? ?? ?? 1C 30 9A E5 03 00 50 E1 24 28 9F E5 5F FF FF 1A 00 00 50 E3 DA 01 00 0A 28 30 92 E5 20 10 92 E5 00 20 D3 E5 02 00 51 E1 58 FF FF 9A 01 C0 43 E2 00 C0 8C E0 02 00 00 EA 01 20 F3 E5 02 00 51 E1 52 FF FF 9A 0C 00 53 E1 FA FF FF 1A 00 10 99 E5 01 C0 40 E2 00 11 81 E0 04 20 11 E5 62 38 22 E0 23 34 A0 E1 01 C0 4C E2 FF 3C C3 E3 62 34 23 E0 01 00 7C E3 04 30 21 E5 F6 FF FF 1A C1 10 4B E2 09 30 A0 E1 00 50 A0 E3 07 90 A0 E1 BD 40 4B E2 01 70 A0 E1 03 10 A0 E1 08 10 98 E9 03 00 5C E1 07 60 A0 E1 08 00 00 9A 01 20 83 E2 04 20 88 E5 00 00 D3 E5 01 00 E6 E5 04 00 56 E1 0A 00 00 0A 02 30 A0 E1 03 00 5C E1 F6 FF FF 8A 08 00 A0 E1 E4 10 0B E5 ?? ?? ?? ?? 01 00 70 E3 E4 10 1B E5 C2 01 00 1A 01 90 A0 E1 28 FF FF EA 02 00 5C E1 B4 01 00 9A 01 30 82 E2 04 30 88 E5 00 00 D2 E5 01 00 50 E3 F6 FF FF 8A 2C 30 9A E5 85 61 A0 E1 06 30 83 E0 04 00 C3 E5 04 30 98 E5 08 20 98 E5 02 00 53 E1 A2 01 00 2A 01 20 83 E2 04 20 88 E5 00 00 D3 E5 09 00 50 E1 E9 FF FF 8A C0 20 1B E5 62 38 22 E0 2C C0 9A E5 20 E0 9A E5 23 34 A0 E1 01 50 85 E2 FF 3C C3 E3 62 34 23 E0 05 00 5E E1 06 20 8C E0 05 00 C2 E5 06 30 8C E7 C9 FF FF 8A 09 70 A0 E1 01 90 A0 E1 08 30 A0 E1 00 00 9A E5 01 10 A0 E3 07 20 A0 E1 ?? ?? ?? ?? 07 00 50 E1 C8 00 0B E5 98 36 9F E5 FC FE FF 1A 24 30 93 E5 00 00 53 E3 37 00 00 0A C1 10 4B E2 00 60 A0 E3 BD 40 4B E2 01 70 A0 E1 08 20 98 E5 07 50 A0 E1 04 30 98 E5 02 00 53 E1 73 01 00 2A 01 10 83 E2 04 10 88 E5 00 00 D3 E5 01 00 E5 E5 04 00 55 E1 F6 FF FF 1A C0 10 1B E5 61 38 21 E0 23 34 A0 E1 FF 3C C3 E3 30 00 9A E5 61 34 23 E0 86 31 80 E7 04 30 98 E5 02 00 53 E1 86 11 A0 E1 07 50 A0 E1 09 00 00 2A 01 20 83 E2 04 20 88 E5 00 00 D3 E5 01 00 E5 E5 05 00 54 E1 0A 00 00 0A 08 20 98 E5 04 30 98 E5 02 00 53 E1 F5 FF FF 3A 08 00 A0 E1 E4 10 0B E5 ?? ?? ?? ?? 01 00 70 E3 E4 10 1B E5 CE FE FF 0A F1 FF FF EA C0 20 1B E5 24 00 9A E5 62 38 22 E0 01 60 86 E2 23 34 A0 E1 06 00 50 E1 30 00 9A E5 FF 3C C3 E3 62 34 23 E0 01 10 80 E0 04 30 81 E5 CB FF FF 8A DC 20 1B E5 00 00 52 E3 3F 01 00 0A 00 40 A0 E3 02 50 A0 E1 04 30 98 E5 08 20 98 E5 02 00 53 E1 4B 01 00 2A 01 20 83 E2 04 20 88 E5 00 00 D3 E5 2C 30 9A E5 00 00 90 E2 84 31 83 E0 01 40 84 E2 01 00 A0 13 05 00 54 E1 06 00 C3 E5 F0 FF FF 1A 20 10 9A E5 04 00 51 E1 4C 35 9F E5 07 00 00 9A 2C 30 93 E5 00 20 A0 E3 84 41 83 E0 81 31 83 E0 06 20 C4 E5 08 40 84 E2 03 00 54 E1 FB FF FF 1A D4 30 1B E5 00 00 53 E3 01 30 A0 01 D4 40 1B 05 12 00 00 0A D4 50 1B E5 00 40 A0 E3 04 30 98 E5 08 20 98 E5 02 00 53 E1 30 01 00 2A 01 20 83 E2 04 20 88 E5 00 00 D3 E5 2C 30 9A E5 00 00 90 E2 84 31 83 E0 01 40 84 E2 01 00 A0 13 05 00 54 E1 07 00 C3 E5 D0 34 9F E5 EF FF FF 1A 20 30 93 E5 04 00 53 E1 07 00 00 9A 2C 10 9A E5 00 20 A0 E3 84 41 81 E0 83 31 81 E0 07 20 C4 E5 08 40 84 E2 03 00 54 E1 FB FF FF 1A B4 30 5B E5 00 00 53 E3 7B 00 00 1A 34 30 9A E5 00 00 53 E3 88 24 9F E5 02 00 00 0A 00 30 D3 E5 00 00 53 E3 34 30 82 05 08 00 A0 E1 ?? ?? ?? ?? 20 30 9A E5 00 00 53 E3 00 40 A0 13 09 00 00 0A 2C 30 9A E5 84 31 83 E0 05 30 D3 E5 00 00 9A E5 03 00 80 E0 ?? ?? ?? ?? 20 30 9A E5 01 40 84 E2 04 00 53 E1 F5 FF FF 8A 1C 40 9A E5 48 64 9F E5 00 00 54 E3 00 30 A0 E3 00 30 86 E5 04 30 86 E5 1C 84 9F 15 06 70 A0 11 02 00 00 1A D0 00 00 EA 00 00 54 E3 32 00 00 0A 28 30 9A E5 01 40 44 E2 04 20 D3 E7 2C 30 9A E5 82 31 83 E0 04 50 D3 E5 05 21 96 E7 00 00 52 E3 FC 93 9F E5 F3 FF FF 1A 05 30 D3 E5 00 00 98 E5 03 00 80 E0 ?? ?? ?? ?? 05 01 87 E7 01 50 65 E2 05 31 97 E7 00 00 53 E3 EA FF FF 0A 00 30 99 E5 00 00 53 E3 B8 00 00 0A 04 30 96 E5 00 00 53 E3 BC 33 9F E5 00 20 93 05 C8 00 1B E5 04 20 83 05 BD FD FF EB 1C 30 9A E5 00 00 53 E3 88 23 9F E5 13 00 00 1A 2C 30 92 E5 00 30 93 E5 38 30 82 E5 3C 30 82 E5 8C 03 9F E5 00 30 63 E2 88 13 9F E5 00 30 80 E5 D0 30 1B E5 00 30 81 E5 44 13 9F E5 01 20 A0 E3 00 20 81 E5 34 FE FF EA 14 60 A0 E3 13 90 A0 E3 4C 53 9F E5 DF FD FF EA 00 30 96 E5 DE FF FF EA 00 60 A0 E3 38 60 82 E5 3C 60 82 E5 2C 00 92 E5 28 40 92 E5 01 30 43 E2 06 50 A0 E1 06 20 A0 E1 06 10 A0 E1 0B 00 00 EA 03 C0 D4 E7 8C 71 80 E0 04 70 D7 E5 00 00 57 E3 08 00 00 1A 8C 51 90 E7 01 10 A0 E3 01 00 12 E1 7F 00 00 1A 00 00 53 E3 01 30 43 E2 70 00 00 0A 00 00 51 E3 F1 FF FF 0A 00 00 52 E3 07 00 00 1A 03 C0 D4 E7 8C 71 80 E0 04 70 D7 E5 00 00 57 E3 F3 FF FF 0A 8C 61 90 E7 01 20 A0 E3 EE FF FF EA 01 20 A0 E3 EC FF FF EA B8 00 4B E2 2C 10 A0 E3 01 20 A0 E3 08 30 A0 E1 ?? ?? ?? ?? 01 00 50 E3 00 40 A0 E1 F8 FD FF 1A B8 00 4B E2 80 12 9F E5 04 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 F2 FD FF 1A A0 00 1B E5 90 C0 1B E5 A4 E0 1B E5 6C 28 2C E0 60 18 20 E0 98 50 1B E5 22 24 A0 E1 21 14 A0 E1 94 60 1B E5 6E 38 2E E0 FF 2C C2 E3 FF 1C C1 E3 60 14 21 E0 6C C4 22 E0 9C 00 1B E5 23 34 A0 E1 65 28 25 E0 FF 3C C3 E3 0C C0 81 E0 22 24 A0 E1 66 18 26 E0 6E E4 23 E0 FF 2C C2 E3 60 38 20 E0 21 14 A0 E1 65 24 22 E0 FF 1C C1 E3 23 34 A0 E1 0E C0 8C E0 82 21 82 E0 66 14 21 E0 FF 3C C3 E3 02 20 8C E0 60 34 23 E0 81 10 81 E0 81 10 82 E0 83 30 83 E0 04 20 A0 E1 03 11 81 E0 08 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 C7 FD FF 1A 08 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 C3 FD FF BA 02 40 80 E2 5C 30 4B E2 0C 00 93 E8 C4 5F A0 E1 04 00 52 E1 05 10 D3 E0 BC FD FF BA 04 30 98 E5 02 60 60 E0 08 20 98 E5 0D 10 86 E2 02 00 53 E1 07 10 C1 E3 01 D0 4D E0 01 20 83 32 0D 10 A0 E1 04 20 88 35 A1 41 A0 E1 84 51 A0 E1 00 00 D3 35 08 00 A0 21 ?? ?? ?? ?? 0A 00 50 E3 AB FD FF 1A 02 60 46 E2 06 20 A0 E1 05 00 A0 E1 01 10 A0 E3 08 30 A0 E1 ?? ?? ?? ?? 00 00 56 E1 A3 FD FF 1A 00 30 A0 E3 05 00 A0 E1 84 31 C6 E7 ?? ?? ?? ?? 34 00 8A E5 20 FF FF EA 14 31 9F E5 00 00 52 E3 38 60 8A E5 3C 50 8A E5 38 50 83 05 05 30 A0 01 61 FF FF 0A 06 60 55 E0 01 60 A0 13 05 30 A0 E1 D0 60 0B E5 5C FF FF EA 38 60 8A E5 06 60 55 E0 01 60 A0 13 05 30 A0 E1 3C 50 8A E5 D0 60 0B E5 55 FF FF EA 20 30 9A E5 01 00 53 E3 C0 30 9F E5 25 00 00 1A 00 00 93 E5 ?? ?? ?? ?? 00 00 86 E5 3E FF FF EA 20 30 92 E5 00 00 53 E3 3A FE FF 1A 78 FE FF EA DC 40 1B E5 CE FE FF EA 08 00 A0 E1 ?? ?? ?? ?? 01 00 70 E3 78 FD FF 0A 08 20 98 E5 88 FE FF EA 08 00 A0 E1 E4 10 0B E5 ?? ?? ?? ?? E4 10 1B E5 5A FE FF EA 08 00 A0 E1 E4 10 0B E5 ?? ?? ?? ?? E4 10 1B E5 48 FE FF EA 08 00 A0 E1 ?? ?? ?? ?? 01 00 70 E3 B2 FE FF 1A 67 FD FF EA 04 10 98 E9 2E FE FF EA 08 00 A0 E1 ?? ?? ?? ?? 01 00 70 E3 61 FD FF 0A CC FE FF EA 44 00 9F E5 44 10 9F E5 44 20 9F E5 44 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 32 33 33 33 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EA 01 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_2_0 {
	meta:
		name = "__tzfile_default"
		size = 448
		refs = "0018 strlen 003c __tzfile_read 0074 mempcpy 0080 memcpy 01ac __use_tzfile 01b8 __timezone 01bc __tzname"
	strings:
		$1 = { F0 4F 2D E9 1C D0 4D E2 01 50 A0 E1 03 90 A0 E1 02 80 A0 E1 04 00 8D E5 ?? ?? ?? ?? 01 60 80 E2 05 00 A0 E1 ?? ?? ?? ?? 01 40 80 E2 06 70 84 E0 14 20 8D E2 07 10 A0 E1 68 01 9F E5 ?? ?? ?? ?? 64 31 9F E5 00 20 93 E5 00 00 52 E3 52 00 00 0A 58 A1 9F E5 20 20 9A E5 01 00 52 E3 00 20 A0 93 00 20 83 95 4C 00 00 9A 04 10 9D E5 06 20 A0 E1 14 00 9D E5 ?? ?? ?? ?? 04 20 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 1C 00 9A E5 14 20 9D E5 00 00 50 E3 02 30 A0 E3 00 20 8A E5 20 30 8A E5 2C 20 9A 05 2A 00 00 0A 38 10 8A E2 0A 00 91 E8 00 21 9F E5 28 E0 9A E5 09 10 61 E0 00 40 A0 E3 08 30 63 E0 00 B0 92 E5 08 10 8D E5 0C 50 8D E5 2C 20 9A E5 00 00 8E E0 04 10 A0 E1 03 50 A0 E1 0A 00 00 EA 06 10 D3 E5 00 00 51 E3 10 00 00 1A 04 10 9B E7 08 C0 9D E5 0C 10 81 E0 04 10 8B E7 00 00 5E E1 04 10 D3 E5 04 40 84 E2 0F 00 00 0A 00 30 DE E5 83 31 82 E0 04 C0 D3 E5 01 C0 CE E4 07 C0 D3 E5 00 00 5C E3 F4 FF FF 1A 00 00 51 E3 EB FF FF 1A 04 10 9B E7 05 10 81 E0 04 10 8B E7 00 00 5E E1 04 10 D3 E5 04 40 84 E2 EF FF FF 1A 0C 50 9D E5 60 C0 9F E5 00 E0 68 E2 00 80 82 E5 00 10 A0 E3 54 30 9F E5 01 40 A0 E3 00 E0 8C E5 04 C0 9D E5 05 10 C2 E5 04 10 C2 E5 08 90 82 E5 0D 60 C2 E5 07 00 A0 E1 0C 40 C2 E5 3C 80 8A E5 38 90 8A E5 00 C0 83 E5 04 50 83 E5 63 FC FF EB 1C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_3_0 {
	meta:
		name = "__tzfile_compute"
		size = 1604
		refs = "0120 __tzstring 0240 strcmp 0418 __assert_fail 0440 __tzset_parse_tz 0450 __offtime 046c __tz_compute 04a4 strlen 0614 __tzname 0620 __daylight 0624 __timezone"
	strings:
		$1 = { F0 4F 2D E9 00 00 51 E3 14 D0 4D E2 FC 55 9F E5 0C 00 8D E5 02 60 A0 E1 03 70 A0 E1 11 00 00 1A 24 10 95 E5 30 40 95 E5 00 00 A0 E3 00 00 86 E5 0C 20 9D E5 00 00 87 E5 81 01 84 E0 03 00 00 EA 08 30 30 E5 02 00 53 E1 A2 00 00 DA 0C 10 A0 E1 00 00 51 E3 01 C0 41 E2 F8 FF FF 1A 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 1C 30 95 E5 A0 B5 9F E5 00 90 A0 E3 00 00 53 E3 00 90 8B E5 04 90 8B E5 0E 01 00 0A 8C 15 9F E5 00 E0 91 E5 00 10 9E E5 00 00 51 E1 09 01 00 CA 07 11 43 E2 01 C1 9E E7 0C 00 50 E1 E1 00 00 AA 6C 45 9F E5 0C C0 60 E0 9C 14 C4 E0 CC 1F A0 E1 0C C0 84 E0 CC CB 61 E0 0C 00 53 E1 01 40 43 E2 66 00 00 8A 09 20 A0 E1 01 C0 82 E2 0C 00 54 E1 07 00 00 9A 02 30 84 E0 A3 30 A0 E1 03 11 9E E7 01 00 50 E1 77 00 00 AA 03 40 A0 E1 0C 00 54 E1 F7 FF FF 8A 28 30 95 E5 01 A0 44 E2 0A 20 D3 E7 2C 30 95 E5 82 31 83 E0 05 20 D3 E5 00 00 95 E5 02 00 80 E0 04 80 D3 E5 ?? ?? ?? ?? 1C 30 95 E5 E0 14 9F E5 03 00 54 E1 08 01 8B E7 28 C0 91 E5 D4 24 9F 35 04 00 00 3A 1D 00 00 EA 1C 30 95 E5 01 40 84 E2 04 00 53 E1 19 00 00 9A 2C 30 95 E5 04 00 DC E7 80 01 83 E0 04 80 D0 E5 08 31 9B E7 00 00 53 E3 05 00 D0 E5 98 94 9F E5 F2 FF FF 1A 00 C0 91 E5 00 00 8C E0 08 10 8D E5 04 20 8D E5 ?? ?? ?? ?? 04 20 9D E5 08 01 82 E7 01 80 68 E2 08 01 92 E7 00 00 50 E3 08 10 9D E5 95 00 00 1A 1C 30 95 E5 01 40 84 E2 04 00 53 E1 28 C0 91 E5 E5 FF FF 8A 00 00 9B E5 4C 34 9F E5 00 00 50 E3 04 00 93 05 00 00 83 05 2C 30 95 E5 0A 40 DC E7 84 41 83 E0 3C 30 95 E5 38 C0 95 E5 34 14 9F E5 0C C0 53 E0 30 24 9F E5 01 C0 A0 13 00 30 63 E2 00 00 50 E3 00 30 82 E5 00 C0 81 E5 04 34 9F E5 70 00 00 0A 04 30 9B E5 00 00 53 E3 F8 33 9F E5 00 20 93 05 04 20 83 05 38 20 9D E5 04 30 D4 E5 20 30 82 E5 03 81 9B E7 00 00 95 E5 05 30 D4 E5 08 10 A0 E1 03 00 80 E0 ?? ?? ?? ?? 00 00 50 E3 C0 33 9F E5 72 00 00 1A 38 10 9D E5 00 20 94 E5 28 80 81 E5 24 20 81 E5 24 10 93 E5 6E FF FF EA 03 C0 6C E0 01 10 4C E2 01 81 9E E7 08 00 50 E1 01 81 A0 E1 46 00 00 AA 09 00 51 E3 03 00 00 9A 08 30 8E E0 28 30 13 E5 03 00 50 E1 54 00 00 BA 04 30 48 E2 03 30 9E E7 03 00 50 E1 01 40 A0 A1 93 FF FF AA 04 80 88 E2 08 E0 8E E0 01 40 A0 E1 04 E0 4E E2 08 30 1E E5 03 00 50 E1 01 40 44 E2 FA FF FF BA 8A FF FF EA 03 20 A0 E1 7D FF FF EA 04 30 90 E5 00 30 86 E5 00 30 90 E5 03 00 52 E1 5B FF FF 1A 00 00 5C E3 04 30 90 E5 03 00 00 1A 00 00 53 E3 01 30 A0 C3 00 30 87 C5 54 FF FF CA 2E 12 41 E2 81 01 84 E0 04 00 90 E5 03 00 50 E1 4F FF FF AA 01 50 A0 E3 00 00 5C E3 00 50 87 E5 4B FF FF 0A 81 11 94 E7 05 10 81 E0 02 00 51 E1 47 FF FF 1A 05 00 80 E0 03 00 50 E1 44 FF FF 1A 8C 31 84 E0 02 20 A0 E3 05 C0 8C E0 0B 00 00 EA 10 10 13 E5 08 00 13 E5 01 10 81 E2 01 00 50 E1 09 00 00 1A 0C 40 13 E5 04 00 13 E5 01 10 84 E2 01 00 50 E1 01 20 82 E2 08 30 43 E2 1B 00 00 1A 0C 00 52 E1 02 50 A0 E1 F0 FF FF 1A 00 20 87 E5 2F FF FF EA 09 20 8C E2 02 00 53 E1 08 30 8E E0 02 00 00 9A 28 C0 93 E5 0C 00 50 E1 45 FF FF AA 01 40 A0 E1 04 20 B3 E5 02 00 50 E1 01 40 84 E2 FB FF FF AA 4A FF FF EA 20 20 93 E5 01 00 52 E3 0A 00 00 1A 00 00 93 E5 ?? ?? ?? ?? 00 00 8B E5 87 FF FF EA 0B 40 4C E2 09 20 A0 E1 35 FF FF EA 00 50 87 E5 16 FF FF EA 28 C0 99 E5 6C FF FF EA 18 02 9F E5 18 12 9F E5 18 22 9F E5 18 32 9F E5 ?? ?? ?? ?? 14 02 9F E5 04 12 9F E5 C7 2F A0 E3 04 32 9F E5 ?? ?? ?? ?? 34 00 95 E5 00 00 50 E3 03 40 A0 01 2E FF FF 0A ?? ?? ?? ?? 09 10 A0 E1 0C 00 8D E2 38 20 9D E5 ?? ?? ?? ?? 00 00 50 E3 1C 40 95 05 26 FF FF 0A 38 10 9D E5 0C 00 9D E5 01 20 A0 E3 ?? ?? ?? ?? 24 10 95 E5 30 00 95 E5 00 30 95 E5 81 01 80 E0 03 00 50 E1 E6 FE FF 1A 20 30 95 E5 02 00 53 E3 29 00 00 1A ?? ?? ?? ?? 00 40 95 E5 00 00 8B E5 04 00 A0 E1 ?? ?? ?? ?? 01 00 80 E2 00 00 84 E0 ?? ?? ?? ?? 24 10 95 E5 04 00 8B E5 D8 FE FF EA 20 A0 95 E5 44 11 9F E5 00 00 5A E3 2C 30 91 E5 4C 00 00 0A 04 A0 D3 E5 00 00 5A E3 49 00 00 0A 00 20 A0 E3 01 40 A0 E1 02 80 A0 E1 0A 00 00 EA 20 20 95 E5 01 80 88 E2 08 00 52 E1 0C 31 9F E5 24 00 00 9A 2C 00 94 E5 88 31 80 E0 04 10 D3 E5 00 00 51 E3 0D 00 00 0A 04 20 9B E5 00 00 52 E3 F2 FF FF 1A 05 30 D3 E5 00 00 95 E5 03 00 80 E0 ?? ?? ?? ?? 04 00 8B E5 EC FF FF EA F8 00 9F E5 E4 10 9F E5 F4 20 9F E5 E4 30 9F E5 ?? ?? ?? ?? 00 30 A0 E1 08 00 52 E1 88 A1 A0 11 00 80 A0 03 08 A0 A0 01 0A 30 83 E0 05 30 D3 E5 00 00 95 E5 03 00 80 E0 ?? ?? ?? ?? 04 30 9B E5 00 00 53 E3 00 00 8B E5 84 30 9F E5 04 00 00 0A 2C 40 93 E5 0A 40 84 E0 10 FF FF EA 2C 30 93 E5 EC FF FF EA 20 20 93 E5 02 00 58 E1 F7 FF FF 2A 2C 30 93 E5 0A 40 83 E0 04 10 D4 E5 00 00 51 E3 88 31 83 00 07 00 00 1A 01 80 88 E2 02 00 58 E1 02 FF FF 2A 08 30 83 E2 04 10 D3 E5 00 00 51 E3 F8 FF FF 0A 03 40 A0 E1 05 30 D4 E5 00 00 95 E5 03 00 80 E0 ?? ?? ?? ?? 2C 40 95 E5 04 00 8B E5 0A 40 84 E0 00 00 9B E5 F4 FE FF EA 0A 80 A0 E1 D4 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EF 22 1A 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 15 03 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? B7 02 00 00 }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "fgetpwent"
		size = 544
		refs = "0010 _IO_new_fgetpos 0080 _IO_new_fsetpos 00b4 __fgetpwent_r 00d8 realloc 00e8 __aeabi_read_tp 0104 free 01c4 malloc 01fc __lll_lock_wait_private 0210 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 24 D0 4D E2 14 10 8D E2 00 50 A0 E1 ?? ?? ?? ?? 00 40 50 E2 62 00 00 1A 01 10 A0 E3 DC 21 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 69 00 00 1A B0 41 9F E5 00 30 94 E5 00 00 53 E3 A0 71 9F E5 54 00 00 0A 98 61 9F E5 10 80 8D E2 94 91 9F E5 08 00 00 EA 05 00 A0 E1 14 10 8D E2 00 A0 84 E5 ?? ?? ?? ?? 7C 21 9F E5 00 00 50 E3 00 30 A0 13 00 30 99 05 00 30 82 15 00 00 53 E3 03 20 A0 E1 05 00 A0 E1 60 11 9F E5 1F 00 00 0A 04 30 97 E5 00 80 8D E5 ?? ?? ?? ?? 22 00 50 E3 17 00 00 1A 04 30 96 E5 00 B0 94 E5 01 3B 83 E2 03 10 A0 E1 0B 00 A0 E1 04 30 86 E5 ?? ?? ?? ?? 00 A0 50 E2 E3 FF FF 1A 24 11 9F E5 ?? ?? ?? ?? 00 30 A0 E1 01 C0 9F E7 0C 20 93 E7 0B 00 A0 E1 0C 20 8D E5 08 30 8D E5 ?? ?? ?? ?? 04 11 9F E5 0C 20 9D E5 08 30 9D E5 01 00 9F E7 00 20 83 E7 D4 FF FF EA 00 30 94 E5 00 00 53 E3 01 00 00 1A 00 30 A0 E3 10 30 8D E5 DC 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 60 90 E7 00 50 97 E5 00 10 A0 E3 05 40 A0 E1 AC 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 12 00 00 CA 8C 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 60 80 E7 10 00 9D E5 24 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 00 A0 E3 24 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 01 3B A0 E3 03 00 A0 E1 04 30 87 E5 ?? ?? ?? ?? 00 00 84 E5 00 30 A0 E1 A3 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 18 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF E3 FF FF EA 02 00 A0 E1 ?? ?? ?? ?? 92 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_449_0_0 {
	meta:
		name = "fgetsgent"
		size = 544
		refs = "0010 _IO_new_fgetpos 0080 _IO_new_fsetpos 00b4 __fgetsgent_r 00d8 realloc 00e8 __aeabi_read_tp 0104 free 01c4 malloc 01fc __lll_lock_wait_private 0210 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 24 D0 4D E2 14 10 8D E2 00 50 A0 E1 ?? ?? ?? ?? 00 40 50 E2 62 00 00 1A 01 10 A0 E3 DC 21 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 69 00 00 1A B0 41 9F E5 00 30 94 E5 00 00 53 E3 A0 71 9F E5 54 00 00 0A 98 61 9F E5 10 80 8D E2 94 91 9F E5 08 00 00 EA 05 00 A0 E1 14 10 8D E2 00 A0 84 E5 ?? ?? ?? ?? 7C 21 9F E5 00 00 50 E3 00 30 A0 13 00 30 99 05 00 30 82 15 00 00 53 E3 03 20 A0 E1 05 00 A0 E1 60 11 9F E5 1F 00 00 0A 04 30 97 E5 00 80 8D E5 ?? ?? ?? ?? 22 00 50 E3 17 00 00 1A 04 30 96 E5 00 B0 94 E5 01 3B 83 E2 03 10 A0 E1 0B 00 A0 E1 04 30 86 E5 ?? ?? ?? ?? 00 A0 50 E2 E3 FF FF 1A 24 11 9F E5 ?? ?? ?? ?? 00 30 A0 E1 01 C0 9F E7 0C 20 93 E7 0B 00 A0 E1 0C 20 8D E5 08 30 8D E5 ?? ?? ?? ?? 04 11 9F E5 0C 20 9D E5 08 30 9D E5 01 00 9F E7 00 20 83 E7 D4 FF FF EA 00 30 94 E5 00 00 53 E3 01 00 00 1A 00 30 A0 E3 10 30 8D E5 DC 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 60 90 E7 00 50 97 E5 00 10 A0 E3 05 40 A0 E1 AC 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 12 00 00 CA 8C 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 60 80 E7 10 00 9D E5 24 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 00 A0 E3 24 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 01 3B A0 E3 03 00 A0 E1 04 30 87 E5 ?? ?? ?? ?? 00 00 84 E5 00 30 A0 E1 A3 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 18 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF E3 FF FF EA 02 00 A0 E1 ?? ?? ?? ?? 92 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_860_0_0 {
	meta:
		name = "fgetspent"
		size = 544
		refs = "0010 _IO_new_fgetpos 0080 _IO_new_fsetpos 00b4 __fgetspent_r 00d8 realloc 00e8 __aeabi_read_tp 0104 free 01c4 malloc 01fc __lll_lock_wait_private 0210 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 24 D0 4D E2 14 10 8D E2 00 50 A0 E1 ?? ?? ?? ?? 00 40 50 E2 62 00 00 1A 01 10 A0 E3 DC 21 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 69 00 00 1A B0 41 9F E5 00 30 94 E5 00 00 53 E3 A0 71 9F E5 54 00 00 0A 98 61 9F E5 10 80 8D E2 94 91 9F E5 08 00 00 EA 05 00 A0 E1 14 10 8D E2 00 A0 84 E5 ?? ?? ?? ?? 7C 21 9F E5 00 00 50 E3 00 30 A0 13 00 30 99 05 00 30 82 15 00 00 53 E3 03 20 A0 E1 05 00 A0 E1 60 11 9F E5 1F 00 00 0A 04 30 97 E5 00 80 8D E5 ?? ?? ?? ?? 22 00 50 E3 17 00 00 1A 04 30 96 E5 00 B0 94 E5 01 3B 83 E2 03 10 A0 E1 0B 00 A0 E1 04 30 86 E5 ?? ?? ?? ?? 00 A0 50 E2 E3 FF FF 1A 24 11 9F E5 ?? ?? ?? ?? 00 30 A0 E1 01 C0 9F E7 0C 20 93 E7 0B 00 A0 E1 0C 20 8D E5 08 30 8D E5 ?? ?? ?? ?? 04 11 9F E5 0C 20 9D E5 08 30 9D E5 01 00 9F E7 00 20 83 E7 D4 FF FF EA 00 30 94 E5 00 00 53 E3 01 00 00 1A 00 30 A0 E3 10 30 8D E5 DC 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 60 90 E7 00 50 97 E5 00 10 A0 E3 05 40 A0 E1 AC 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 12 00 00 CA 8C 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 60 80 E7 10 00 9D E5 24 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 00 A0 E3 24 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 01 3B A0 E3 03 00 A0 E1 04 30 87 E5 ?? ?? ?? ?? 00 00 84 E5 00 30 A0 E1 A3 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 18 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF E3 FF FF EA 02 00 A0 E1 ?? ?? ?? ?? 92 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "__getclktck"
		size = 24
		refs = "0014 _dl_clktck"
	strings:
		$1 = { 0C 30 9F E5 00 00 93 E5 00 00 50 E3 64 00 A0 03 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "__pause_nocancel"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 1D 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_1_0 {
	meta:
		name = "__libc_pause"
		size = 100
		refs = "0028 __syscall_error 0030 __libc_enable_asynccancel 0048 __libc_disable_asynccancel"
	strings:
		$1 = { 5C C0 9F E5 0C C0 9F E7 00 00 3C E3 04 70 2D E5 05 00 00 1A 1D 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? 04 E0 2D E5 ?? ?? ?? ?? 00 C0 A0 E1 1D 70 A0 E3 00 00 00 EF 00 70 A0 E1 0C 00 A0 E1 ?? ?? ?? ?? 07 00 A0 E1 04 E0 9D E4 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "getsubopt"
		size = 268
		refs = "002c __strchrnul 0040 memchr 0074 strncmp"
	strings:
		$1 = { F0 4F 2D E9 00 70 90 E5 00 30 D7 E5 0C D0 4D E2 00 00 53 E3 00 90 A0 E1 01 50 A0 E1 04 20 8D E5 37 00 00 0A 2C 10 A0 E3 07 00 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 08 20 67 E0 07 00 A0 E1 3D 10 A0 E3 ?? ?? ?? ?? 00 40 95 E5 00 00 50 E3 00 A0 A0 11 08 A0 A0 01 00 00 54 E3 0F 00 00 0A 05 B0 A0 E1 0A 60 67 E0 00 50 A0 E3 07 00 A0 E1 04 10 A0 E1 06 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 02 00 00 1A 06 20 D4 E7 00 00 52 E3 0F 00 00 0A 04 40 BB E5 00 00 54 E3 01 50 85 E2 F2 FF FF 1A 04 30 9D E5 00 70 83 E5 00 30 D8 E5 00 00 53 E3 00 30 A0 13 00 30 C8 15 01 80 88 12 00 80 89 E5 00 00 E0 E3 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 08 00 5A E1 04 30 9D E5 01 20 8A 12 00 20 83 E5 00 30 D8 E5 00 00 53 E3 00 30 A0 13 00 30 C8 15 05 00 A0 E1 01 80 88 12 00 80 89 E5 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 00 E0 E3 EC FF FF EA }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "day_of_the_week"
		size = 236
		refs = "00e4 __mon_yday"
	strings:
		$1 = { 14 10 90 E5 F0 00 2D E9 76 3E 81 E2 10 40 90 E5 0C 30 83 E2 01 00 54 E3 01 30 43 D2 00 00 53 E3 03 60 83 E2 B4 C0 9F E5 03 60 A0 A1 46 21 A0 E1 9C 72 C5 E0 93 7C CC E0 46 10 41 E2 81 71 81 E0 87 11 81 E0 C6 6F A0 E1 01 11 81 E0 C5 51 66 E0 76 1F 41 E2 C3 3F A0 E1 05 51 85 E0 01 10 41 E2 CC 72 43 E0 05 51 85 E0 02 10 81 E0 70 60 9F E5 07 10 81 E0 84 40 A0 E1 02 20 65 E0 B4 60 96 E1 CC 33 63 E0 A2 2F 81 E0 03 20 82 E0 0C 40 90 E5 06 20 82 E0 04 20 82 E0 48 10 9F E5 01 20 42 E2 91 C2 C3 E0 C2 CF A0 E1 02 30 83 E0 43 31 6C E0 83 31 63 E0 02 30 63 E0 07 30 83 E2 91 73 C2 E0 C3 CF A0 E1 03 20 82 E0 42 21 6C E0 82 21 62 E0 03 30 62 E0 18 30 80 E5 F0 00 BD E8 ?? ?? ?? ?? 1F 85 EB 51 ?? ?? ?? ?? 93 24 49 92 }
	condition:
		$1
}

rule file_33_1_0 {
	meta:
		name = "__strptime_internal"
		size = 12936
		refs = "037c __strptime_internal 0640 _nl_select_era_entry 07e8 __localtime_r 08c8 strcmp 08ec strlen 0904 __strncasecmp_l 1320 _nl_C_LC_TIME 1920 _nl_parse_alt_digit 2f90 __assert_fail 3268 __mon_yday"
	strings:
		$1 = { F0 4F 2D E9 74 D0 4D E2 98 90 9D E5 00 B0 53 E2 34 00 8D E5 01 80 A0 E1 18 20 8D E5 08 70 99 E5 FB 00 00 0A 03 00 9B E8 18 40 9D E5 3C C0 8D E2 03 00 8C E8 0F 00 B4 E8 14 C0 8D E5 44 C0 8D E2 0F 00 AC E8 0F 00 B4 E8 0F 00 AC E8 07 00 94 E8 07 00 8C E8 44 A0 8D E2 00 30 D8 E5 00 00 53 E3 16 00 00 0A 34 10 99 E5 83 20 A0 E1 B2 20 91 E1 02 0A 12 E3 23 00 00 0A 34 30 9D E5 00 20 D3 E5 82 20 A0 E1 B2 20 91 E1 02 0A 12 E3 01 30 83 12 06 00 00 0A 34 30 8D E5 00 20 D3 E5 82 20 A0 E1 B2 20 91 E1 02 0A 12 E3 01 30 83 E2 F8 FF FF 1A 01 80 88 E2 00 30 D8 E5 00 00 53 E3 E8 FF FF 1A 00 00 5B E3 F3 07 00 0A 14 C0 9D E5 03 00 9C E8 44 40 8D E2 03 00 8B E8 18 C0 9D E5 0F 00 B4 E8 0F 00 AC E8 0F 00 B4 E8 0F 00 AC E8 07 00 94 E8 34 30 9D E5 07 00 8C E8 03 00 A0 E1 74 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 25 00 53 E3 0B 00 00 0A 34 20 9D E5 01 10 82 E2 34 10 8D E5 00 20 D2 E5 03 00 52 E1 01 80 88 E2 CA FF FF 0A 00 30 A0 E3 03 00 A0 E1 74 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 00 5B E3 01 00 88 E2 01 30 D8 05 15 00 00 0A 00 20 A0 E1 02 00 A0 E1 01 30 D2 E4 2D 00 53 E3 FB FF FF 0A 30 00 53 E3 F9 FF FF 0A 5E C0 43 E2 01 00 5C E3 F6 FF FF 9A 23 00 53 E3 F4 FF FF 0A 30 20 43 E2 09 00 52 E3 06 00 00 8A 01 20 80 E2 00 30 D2 E5 02 00 A0 E1 30 20 43 E2 09 00 52 E3 01 20 80 E2 F9 FF FF 9A 25 30 43 E2 34 50 9D E5 01 80 80 E2 55 00 53 E3 03 F1 9F 97 DA FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 3D 30 DD E5 A3 31 A0 E1 03 30 03 E2 02 00 53 E3 0A 00 00 0A CC 10 97 E5 00 20 D1 E5 00 00 52 E3 24 09 00 1A 01 00 53 E3 79 FF FF 0A 3D 30 DD E5 08 30 C3 E3 10 30 83 E3 34 50 8D E5 3D 30 CD E5 C0 CF 9F E5 CC 10 9C E5 00 30 D1 E5 00 00 53 E3 6F FF FF 0A 34 00 9D E5 00 90 8D E5 0A 20 A0 E1 14 30 9D E5 ?? ?? ?? ?? 00 00 50 E3 34 00 8D E5 32 FF FF 1A 66 FF FF EA 3D 30 DD E5 A3 31 A0 E1 03 30 03 E2 02 00 53 E3 0A 00 00 0A C8 10 97 E5 00 20 D1 E5 00 00 52 E3 32 09 00 1A 01 00 53 E3 5B FF FF 0A 3D 30 DD E5 08 30 C3 E3 10 30 83 E3 34 50 8D E5 3D 30 CD E5 48 0F 9F E5 C8 10 90 E5 00 30 D1 E5 00 00 53 E3 51 FF FF 0A 34 00 9D E5 00 90 8D E5 0A 20 A0 E1 14 30 9D E5 ?? ?? ?? ?? 00 00 50 E3 34 00 8D E5 49 FF FF 0A 3D 30 DD E5 04 30 83 E3 3D 30 CD E5 10 FF FF EA 00 30 E0 E3 3C 40 8D E2 3C B0 8D E5 40 30 8D E5 3F 30 CD E5 14 40 8D E5 02 A0 A0 E1 08 FF FF EA 00 30 D5 E5 83 20 A0 E1 B2 20 91 E1 02 0A 12 E3 05 00 A0 01 07 00 00 0A 01 50 85 E2 34 50 8D E5 05 00 A0 E1 01 30 D5 E4 83 20 A0 E1 B2 20 91 E1 02 0A 12 E3 F8 FF FF 1A 30 30 43 E2 09 00 53 E3 2C FF FF 8A 01 30 80 E2 34 30 8D E5 00 30 D0 E5 30 30 43 E2 03 21 83 E0 82 20 A0 E1 35 00 52 E3 07 00 00 8A 01 10 D0 E5 30 10 41 E2 09 00 51 E3 02 30 80 92 34 30 8D 95 01 30 D0 95 30 30 43 92 02 30 83 90 35 00 53 E3 1A FF FF 8A 3C 20 DD E5 20 20 82 E3 3E 30 CD E5 3C 20 CD E5 E0 FE FF EA 00 30 D5 E5 83 20 A0 E1 B2 20 91 E1 02 0A 12 E3 05 00 A0 01 07 00 00 0A 01 50 85 E2 34 50 8D E5 05 00 A0 E1 01 30 D5 E4 83 20 A0 E1 B2 20 91 E1 02 0A 12 E3 F8 FF FF 1A 30 30 43 E2 09 00 53 E3 04 FF FF 8A 01 30 80 E2 34 30 8D E5 00 30 D0 E5 30 30 43 E2 03 21 83 E0 82 20 A0 E1 35 00 52 E3 07 00 00 8A 01 10 D0 E5 30 10 41 E2 09 00 51 E3 02 30 80 92 34 30 8D 95 01 30 D0 95 30 30 43 92 02 30 83 90 35 00 53 E3 BD FE FF 9A F1 FE FF EA 00 30 D5 E5 83 20 A0 E1 B2 20 91 E1 02 0A 12 E3 05 00 A0 01 07 00 00 0A 01 50 85 E2 34 50 8D E5 05 00 A0 E1 01 30 D5 E4 83 20 A0 E1 B2 20 91 E1 02 0A 12 E3 F8 FF FF 1A 30 30 43 E2 09 00 53 E3 E0 FE FF 8A 01 30 80 E2 34 30 8D E5 00 30 D0 E5 30 20 43 E2 02 21 82 E0 82 20 A0 E1 0C 00 52 E3 06 00 00 8A 01 10 D0 E5 30 10 41 E2 09 00 51 E3 02 30 80 92 34 30 8D 95 01 30 D0 95 03 30 82 90 31 30 43 E2 0B 00 53 E3 CE FE FF 8A 3C 10 DD E5 3D 20 DD E5 08 10 81 E3 04 20 82 E3 10 30 8A E5 3D 20 CD E5 3C 10 CD E5 91 FE FF EA EC 60 97 E5 00 00 A0 E3 00 00 56 E1 40 00 8D E5 05 00 00 CA 22 00 00 EA 40 00 9D E5 01 00 80 E2 00 00 56 E1 40 00 8D E5 1D 00 00 DA 07 10 A0 E1 ?? ?? ?? ?? 00 30 50 E2 F6 FF FF 0A 14 50 9A E5 04 20 93 E5 30 C0 93 E5 05 50 62 E0 9C 05 15 E0 F0 FF FF 4A 08 00 93 E5 14 30 93 E5 C0 1F A0 E1 03 00 70 E0 C3 1F E1 E0 CC 3F A0 E1 90 03 04 E0 90 2C 83 E0 9C 41 24 E0 05 00 A0 E1 C5 1F A0 E1 03 30 84 E0 02 00 50 E1 03 40 D1 E0 E1 FF FF AA 3D 30 DD E5 10 30 C3 E3 08 30 83 E3 3D 30 CD E5 40 00 9D E5 00 00 56 E1 66 FE FF 1A 3D 30 DD E5 A3 21 A0 E1 03 20 02 E2 01 00 52 E3 00 20 E0 E3 40 20 8D E5 94 FE FF 0A 08 30 C3 E3 10 30 83 E3 3D 30 CD E5 34 50 9D E5 34 10 99 E5 00 20 D5 E5 82 30 A0 E1 B3 30 91 E1 02 0A 13 E3 49 08 00 0A 01 30 85 E2 34 30 8D E5 03 C0 A0 E1 01 20 D3 E4 82 00 A0 E1 B0 00 91 E1 02 0A 10 E3 F8 FF FF 1A 30 20 42 E2 09 00 52 E3 7F FE FF 8A 01 30 8C E2 34 30 8D E5 00 20 DC E5 30 30 42 E2 03 11 83 E0 81 10 A0 E1 63 00 51 E3 07 00 00 8A 01 00 DC E5 30 00 40 E2 09 00 50 E3 02 30 8C 92 34 30 8D 95 01 20 DC 95 02 20 81 90 30 30 42 92 63 00 53 E3 6D FE FF 8A 44 00 53 E3 34 30 82 92 3D 20 DD E5 05 20 82 E3 14 30 8A E5 3D 20 CD E5 31 FE FF EA 00 30 A0 E3 38 30 8D E5 00 20 D5 E5 30 20 42 E2 09 00 52 E3 60 FE FF 8A 01 50 45 E2 03 31 83 E0 83 30 A0 E1 02 20 85 E2 38 30 8D E5 34 20 8D E5 01 20 F5 E5 30 20 42 E2 02 30 83 E0 38 30 8D E5 01 20 D5 E5 30 20 42 E2 09 00 52 E3 F2 FF FF 9A 38 00 8D E2 0A 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 18 FE FF 1A 4C FE FF EA 3D 30 DD E5 A3 31 A0 E1 03 30 03 E2 02 00 53 E3 0A 00 00 0A D0 10 97 E5 00 20 D1 E5 00 00 52 E3 04 08 00 1A 01 00 53 E3 41 FE FF 0A 3D 30 DD E5 08 30 C3 E3 10 30 83 E3 34 50 8D E5 3D 30 CD E5 E0 3A 9F E5 D0 10 93 E5 00 30 D1 E5 00 00 53 E3 37 FE FF 0A 34 00 9D E5 00 90 8D E5 0A 20 A0 E1 14 30 9D E5 ?? ?? ?? ?? 00 00 50 E3 34 00 8D E5 FA FD FF 1A 2E FE FF EA 3D 30 DD E5 A3 31 A0 E1 03 30 03 E2 00 40 A0 E3 00 00 E0 E3 28 80 8D E5 90 6A 9F E5 20 30 8D E5 1C 00 8D E5 24 A0 8D E5 04 80 A0 E1 2C B0 8D E5 29 00 00 EA 0A 50 85 E0 3D 30 DD E5 05 00 58 E1 A3 31 A0 E1 5D 00 00 2A 03 30 13 E2 57 06 00 1A 24 00 9B E5 5C 10 96 E5 ?? ?? ?? ?? 00 00 50 E3 01 C0 A0 13 05 80 A0 E1 1C 40 8D E5 34 50 9D E5 20 C0 8D 15 8C B0 96 E5 0B 00 A0 E1 ?? ?? ?? ?? 00 A0 A0 E1 05 10 A0 E1 0B 00 A0 E1 0A 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 BB 05 00 1A 0A 50 85 E0 08 00 55 E1 B8 05 00 9A 02 C0 A0 E3 1C 40 8D E5 20 C0 8D E5 05 80 A0 E1 01 40 84 E2 0C 00 54 E3 04 60 86 E2 11 06 00 0A 3D 30 DD E5 34 50 9D E5 A3 31 A0 E1 03 30 03 E2 02 00 53 E3 E3 FF FF 0A 02 A8 84 E2 1A C0 8A E2 0C C8 A0 E1 2C C7 87 E0 24 30 9C E5 03 00 A0 E1 10 C0 8D E5 0C 30 8D E5 ?? ?? ?? ?? 0C 30 9D E5 00 B0 A0 E1 05 10 A0 E1 03 00 A0 E1 0B 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 10 C0 9D E5 10 00 00 1A 0B 50 85 E0 08 00 55 E1 0D 00 00 9A 3D 30 DD E5 18 00 13 E3 05 80 A0 11 1C 40 8D 15 08 00 00 1A 24 00 9C E5 8C 10 96 E5 ?? ?? ?? ?? 20 C0 9D E5 00 00 50 E3 01 C0 A0 13 20 C0 8D E5 1C 40 8D E5 05 80 A0 E1 0E A0 8A E2 0A B8 A0 E1 2B B7 87 E0 24 30 9B E5 03 00 A0 E1 0C 30 8D E5 ?? ?? ?? ?? 34 50 9D E5 0C 30 9D E5 00 A0 A0 E1 05 10 A0 E1 03 00 A0 E1 0A 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 9E FF FF 0A 3D 30 DD E5 A3 31 A0 E1 03 30 03 E2 01 00 53 E3 BB FF FF 0A 34 50 9D E5 A7 FF FF EA 3D 30 DD E5 D0 08 9F E5 A3 31 A0 E1 00 40 A0 E3 07 C0 A0 E1 00 60 E0 E3 03 30 03 E2 2C A0 8D E5 24 70 8D E5 28 80 8D E5 06 70 A0 E1 1C 30 8D E5 20 40 8D E5 00 60 A0 E1 0C A0 A0 E1 04 80 A0 E1 30 B0 8D E5 2C 00 00 EA 0B 50 85 E0 3D 30 DD E5 05 00 58 E1 A3 31 A0 E1 5D 00 00 2A 03 30 13 E2 11 06 00 1A 24 00 9A E5 24 10 96 E5 ?? ?? ?? ?? 00 00 50 E3 01 C0 A0 13 05 80 A0 E1 1C C0 8D 15 34 50 9D E5 04 70 A0 E1 40 30 96 E5 03 00 A0 E1 0C 30 8D E5 ?? ?? ?? ?? 0C 30 9D E5 00 B0 A0 E1 05 10 A0 E1 03 00 A0 E1 0B 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 4F 05 00 1A 0B 50 85 E0 08 00 55 E1 4C 05 00 9A 02 C0 A0 E3 1C C0 8D E5 05 80 A0 E1 04 70 A0 E1 01 40 84 E2 07 00 54 E3 04 60 86 E2 04 A0 8A E2 A8 05 00 0A 3D 30 DD E5 34 50 9D E5 A3 31 A0 E1 03 30 03 E2 02 00 53 E3 E0 FF FF 0A 24 C0 9D E5 04 B8 A0 E1 07 B8 8B E2 2B B7 8C E0 24 30 9B E5 03 00 A0 E1 0C 30 8D E5 ?? ?? ?? ?? 0C 30 9D E5 00 C0 A0 E1 0C 20 A0 E1 03 00 A0 E1 05 10 A0 E1 09 30 A0 E1 10 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 10 C0 9D E5 10 00 00 1A 0C 50 85 E0 08 00 55 E1 0D 00 00 9A 3D 30 DD E5 18 00 13 E3 05 80 A0 11 04 70 A0 11 08 00 00 1A 24 00 9B E5 40 10 96 E5 ?? ?? ?? ?? 1C C0 9D E5 00 00 50 E3 01 C0 A0 13 1C C0 8D E5 05 80 A0 E1 04 70 A0 E1 24 30 9A E5 03 00 A0 E1 0C 30 8D E5 ?? ?? ?? ?? 34 50 9D E5 0C 30 9D E5 00 B0 A0 E1 05 10 A0 E1 03 00 A0 E1 0B 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 9E FF FF 0A 3D 30 DD E5 A3 31 A0 E1 03 30 03 E2 01 00 53 E3 BD FF FF 0A 34 50 9D E5 A7 FF FF EA 01 30 85 E2 34 30 8D E5 00 30 D5 E5 25 00 53 E3 05 FD FF 0A 39 FD FF EA 00 30 D5 E5 83 20 A0 E1 B2 20 91 E1 02 0A 12 E3 05 00 A0 01 07 00 00 0A 01 50 85 E2 34 50 8D E5 05 00 A0 E1 01 30 D5 E4 83 20 A0 E1 B2 20 91 E1 02 0A 12 E3 F8 FF FF 1A 2D 00 53 E3 2B 00 53 13 00 30 A0 03 01 30 A0 13 26 FD FF 1A 01 10 80 E2 34 10 8D E5 00 C0 D0 E5 03 20 A0 E1 01 00 D1 E4 30 00 40 E2 09 00 50 E3 D7 06 00 8A 34 10 8D E5 03 31 83 E0 83 00 A0 E1 01 20 82 E2 01 30 51 E5 30 00 40 E2 04 00 52 E3 03 30 80 E0 F2 FF FF 1A 34 26 9F E5 93 12 82 E0 A2 22 A0 E1 02 10 A0 E1 02 21 82 E0 02 21 82 E0 02 21 43 E0 3B 00 52 E3 0C FD FF 8A 02 21 82 E0 02 21 82 E0 82 30 A0 E1 E4 25 9F E5 92 43 83 E0 01 11 81 E0 23 32 A0 E1 01 11 81 E0 01 31 83 E0 4B 0E 53 E3 01 FD FF 8A 03 32 63 E0 03 32 63 E0 DC 05 9F E5 03 32 A0 E1 90 13 83 E0 2D 00 5C E3 A3 32 A0 E1 00 30 63 02 24 30 8A E5 C2 FC FF EA 00 30 D5 E5 83 20 A0 E1 B2 20 91 E1 02 0A 12 E3 05 00 A0 01 07 00 00 0A 01 50 85 E2 34 50 8D E5 05 00 A0 E1 01 30 D5 E4 83 20 A0 E1 B2 20 91 E1 02 0A 12 E3 F8 FF FF 1A 30 30 43 E2 09 00 53 E3 E6 FC FF 8A 01 30 80 E2 34 30 8D E5 00 30 D0 E5 30 30 43 E2 03 21 83 E0 82 20 A0 E1 17 00 52 E3 07 00 00 8A 01 10 D0 E5 30 10 41 E2 09 00 51 E3 02 30 80 92 34 30 8D 95 01 30 D0 95 30 30 43 92 02 30 83 90 17 00 53 E3 D4 FC FF 8A 3C 20 DD E5 01 20 C2 E3 08 30 8A E5 3C 20 CD E5 9A FC FF EA 3D 30 DD E5 A3 31 A0 E1 03 30 03 E2 02 00 53 E3 0A 00 00 0A C4 10 97 E5 00 20 D1 E5 00 00 52 E3 4A 06 00 1A 01 00 53 E3 C4 FC FF 0A 3D 30 DD E5 08 30 C3 E3 10 30 83 E3 34 50 8D E5 3D 30 CD E5 EC 34 9F E5 C4 10 93 E5 00 30 D1 E5 00 00 53 E3 68 FD FF 1A B9 FC FF EA 00 30 D5 E5 83 20 A0 E1 B2 20 91 E1 02 0A 12 E3 05 00 A0 01 07 00 00 0A 01 50 85 E2 34 50 8D E5 05 00 A0 E1 01 30 D5 E4 83 20 A0 E1 B2 20 91 E1 02 0A 12 E3 F8 FF FF 1A 30 30 43 E2 09 00 53 E3 A8 FC FF 8A 01 30 80 E2 34 30 8D E5 00 30 D0 E5 30 30 43 E2 03 21 83 E0 82 20 A0 E1 3B 00 52 E3 07 00 00 8A 01 10 D0 E5 30 10 41 E2 09 00 51 E3 02 30 80 92 34 30 8D 95 01 30 D0 95 30 30 43 92 02 30 83 90 3B 00 53 E3 96 FC FF 8A 04 30 8A E5 5F FC FF EA 01 30 D0 E5 48 30 43 E2 02 80 80 E2 31 00 53 E3 03 F1 9F 97 8E FC FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 30 D5 E5 83 20 A0 E1 B2 20 91 E1 02 0A 12 E3 05 00 A0 01 07 00 00 0A 01 50 85 E2 34 50 8D E5 05 00 A0 E1 01 30 D5 E4 83 20 A0 E1 B2 20 91 E1 02 0A 12 E3 F8 FF FF 1A 30 30 43 E2 09 00 53 E3 4B FC FF 8A 01 30 80 E2 }
	condition:
		$1
}

rule file_33_2_0 {
	meta:
		name = "__strptime_l"
		size = 32
		refs = "0010 __strptime_internal"
	strings:
		$1 = { 04 E0 2D E5 0C D0 4D E2 00 30 8D E5 00 30 A0 E3 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1504_1_0 {
	meta:
		name = "__strtol_l"
		size = 32
		refs = "0010 ____strtol_l_internal"
	strings:
		$1 = { 04 E0 2D E5 0C D0 4D E2 00 30 8D E5 00 30 A0 E3 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1400_1_0 {
	meta:
		name = "__strtoll_l"
		size = 32
		refs = "0010 ____strtoll_l_internal"
	strings:
		$1 = { 04 E0 2D E5 0C D0 4D E2 00 30 8D E5 00 30 A0 E3 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_833_1_0 {
	meta:
		name = "__strtoul_l"
		size = 32
		refs = "0010 ____strtoul_l_internal"
	strings:
		$1 = { 04 E0 2D E5 0C D0 4D E2 00 30 8D E5 00 30 A0 E3 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1307_1_0 {
	meta:
		name = "__strtoull_l"
		size = 32
		refs = "0010 ____strtoull_l_internal"
	strings:
		$1 = { 04 E0 2D E5 0C D0 4D E2 00 30 8D E5 00 30 A0 E3 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1419_1_0 {
	meta:
		name = "__wcstol_l"
		size = 32
		refs = "0010 ____wcstol_l_internal"
	strings:
		$1 = { 04 E0 2D E5 0C D0 4D E2 00 30 8D E5 00 30 A0 E3 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_399_1_0 {
	meta:
		name = "__wcstoll_l"
		size = 32
		refs = "0010 ____wcstoll_l_internal"
	strings:
		$1 = { 04 E0 2D E5 0C D0 4D E2 00 30 8D E5 00 30 A0 E3 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1247_1_0 {
	meta:
		name = "__wcstoul_l"
		size = 32
		refs = "0010 ____wcstoul_l_internal"
	strings:
		$1 = { 04 E0 2D E5 0C D0 4D E2 00 30 8D E5 00 30 A0 E3 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_550_1_0 {
	meta:
		name = "__wcstoull_l"
		size = 32
		refs = "0010 ____wcstoull_l_internal"
	strings:
		$1 = { 04 E0 2D E5 0C D0 4D E2 00 30 8D E5 00 30 A0 E3 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "jrand48"
		size = 40
		refs = "0010 __jrand48_r 0024 __libc_drand48_data"
	strings:
		$1 = { 04 E0 2D E5 0C D0 4D E2 14 10 9F E5 04 20 8D E2 ?? ?? ?? ?? 04 00 9D E5 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_450_0_0 {
	meta:
		name = "nrand48"
		size = 40
		refs = "0010 __nrand48_r 0024 __libc_drand48_data"
	strings:
		$1 = { 04 E0 2D E5 0C D0 4D E2 14 10 9F E5 04 20 8D E2 ?? ?? ?? ?? 04 00 9D E5 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "_longjmp_unwind"
		size = 40
		refs = "0014 __pthread_cleanup_upto"
	strings:
		$1 = { 00 48 2D E9 18 30 9F E5 00 00 53 E3 04 B0 8D E2 0C 10 4B 12 ?? ?? ?? ?? 04 D0 4B E2 00 48 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_0_0 {
	meta:
		name = "mabort"
		size = 156
		refs = "002c __dcgettext 0030 __libc_fatal 0084 _libc_intl_domainname"
	strings:
		$1 = { 08 40 2D E9 03 00 50 E3 00 F1 9F 97 17 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 5C 00 9F E5 5C 10 9F E5 05 20 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 50 10 9F E5 05 20 A0 E3 40 00 9F E5 ?? ?? ?? ?? F9 FF FF EA 40 10 9F E5 05 20 A0 E3 2C 00 9F E5 ?? ?? ?? ?? F4 FF FF EA 30 10 9F E5 05 20 A0 E3 18 00 9F E5 ?? ?? ?? ?? EF FF FF EA 20 10 9F E5 05 20 A0 E3 04 00 9F E5 ?? ?? ?? ?? EA FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_1_0 {
	meta:
		name = "checkhdr.part.0"
		size = 172
	strings:
		$1 = { 38 40 2D E9 0C 30 80 E2 0A 00 13 E8 01 10 83 E0 04 30 90 E5 84 20 9F E5 03 30 21 E0 02 00 53 E1 1C 00 00 0A 78 20 9F E5 02 00 53 E1 0C 00 00 0A 02 40 A0 E3 6C 50 9F E5 00 30 A0 E3 04 00 A0 E1 00 30 85 E5 04 C0 95 E5 0F E0 A0 E1 ?? ?? ?? ?? 01 30 A0 E3 00 30 85 E5 04 00 A0 E1 38 40 BD E8 ?? ?? ?? ?? 00 20 90 E5 02 20 80 E0 18 20 D2 E5 D7 00 52 E3 03 40 A0 13 ED FF FF 1A 10 10 80 E2 06 00 91 E8 02 20 21 E0 03 00 52 E1 00 40 A0 03 E6 FF FF 1A EF FF FF EA 01 40 A0 E3 E4 FF FF EA 09 53 67 D8 EB BE DA FE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_2_0 {
	meta:
		name = "unlink_blk.isra.1"
		size = 88
	strings:
		$1 = { 00 00 51 E3 06 00 00 0A 00 20 90 E5 0C C0 91 E5 38 30 9F E5 0C C0 82 E0 03 30 2C E0 08 20 81 E5 04 30 81 E5 00 30 90 E5 00 00 53 E3 08 00 93 15 18 20 9F 15 00 00 81 10 14 30 9F 05 02 20 20 10 0C 10 83 15 04 20 83 15 08 10 83 05 ?? ?? ?? ?? EB BE DA FE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_3_0 {
	meta:
		name = "memalignhook"
		size = 352
		refs = "00e0 memset 0100 mcheck_check_all 0110 memalign 0120 __aeabi_read_tp 0150 __memalign_hook 0154 memalignhook 015c __libc_errno"
	strings:
		$1 = { F0 40 2D E9 40 51 9F E5 0C 30 95 E5 00 00 53 E3 0C D0 4D E2 01 40 A0 E1 36 00 00 1A 17 30 80 E2 00 60 60 E2 03 60 06 E0 01 30 86 E2 03 30 E0 E1 04 00 53 E1 38 00 00 3A 10 30 95 E5 0C 71 9F E5 01 10 84 E2 00 00 53 E3 06 10 81 E0 00 30 87 E5 2E 00 00 0A 0F E0 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 EC 30 9F E5 00 00 52 E3 00 30 87 E5 34 00 00 0A 08 C0 95 E5 18 60 46 E2 06 30 82 E0 06 40 82 E7 00 00 A0 E3 0C C0 83 E5 C8 10 9F E5 00 00 5C E1 01 10 2C E0 08 00 83 E5 0C 00 9C 15 04 10 83 E5 B0 10 9F 15 00 00 83 10 01 10 20 10 0A 00 8C 19 A0 10 9F E5 04 00 83 E0 01 10 22 E0 18 C0 83 E2 28 E0 E0 E3 10 20 83 E5 14 10 83 E5 04 20 A0 E1 18 E0 C0 E5 93 10 A0 E3 0C 00 A0 E1 08 30 85 E5 ?? ?? ?? ?? 00 C0 A0 E1 0C 00 A0 E1 0C D0 8D E2 F0 40 BD E8 ?? ?? ?? ?? 04 00 8D E5 00 20 8D E5 ?? ?? ?? ?? 00 20 9D E5 04 00 9D E5 C2 FF FF EA ?? ?? ?? ?? 00 20 A0 E1 D0 FF FF EA 38 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 0C 20 A0 E3 00 C0 A0 E3 03 20 80 E7 0C 00 A0 E1 0C D0 8D E2 F0 40 BD E8 ?? ?? ?? ?? 02 C0 A0 E1 E6 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EB BE DA FE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_4_0 {
	meta:
		name = "mallochook"
		size = 316
		refs = "00c0 memset 00dc mcheck_check_all 00f0 __aeabi_read_tp 0114 malloc 012c __malloc_hook 0130 mallochook 0138 __libc_errno"
	strings:
		$1 = { 70 40 2D E9 1C 51 9F E5 0C 30 95 E5 00 00 53 E3 08 D0 4D E2 00 40 A0 E1 2E 00 00 1A 1A 00 74 E3 31 00 00 8A 14 30 95 E5 FC 60 9F E5 00 00 53 E3 19 00 84 E2 00 30 86 E5 35 00 00 0A 0F E0 A0 E1 ?? ?? ?? ?? 00 30 A0 E1 E0 20 9F E5 00 00 53 E3 00 20 86 E5 31 00 00 0A 08 10 95 E5 D0 20 9F E5 0C 10 83 E5 00 00 51 E3 00 00 A0 E3 02 20 21 E0 08 00 83 E5 0C 00 91 15 04 20 83 E5 B0 20 9F 15 03 00 80 10 02 20 20 10 00 40 83 E5 0C 00 81 19 9C 20 9F E5 04 10 83 E0 02 20 23 E0 18 C0 83 E2 28 00 E0 E3 14 20 83 E5 10 30 83 E5 04 20 A0 E1 18 00 C1 E5 0C 00 A0 E1 93 10 A0 E3 08 30 85 E5 ?? ?? ?? ?? 00 C0 A0 E1 0C 00 A0 E1 08 D0 8D E2 70 40 BD E8 ?? ?? ?? ?? 04 10 8D E5 ?? ?? ?? ?? 1A 00 74 E3 04 10 9D E5 CD FF FF 9A 44 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 0C 20 A0 E3 00 C0 A0 E3 03 20 80 E7 0C 00 A0 E1 08 D0 8D E2 70 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 00 30 A0 E1 C9 FF FF EA 03 C0 A0 E1 E7 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EB BE DA FE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_5_0 {
	meta:
		name = "freehook"
		size = 212
		refs = "0060 memset 009c mcheck_check_all 00b0 free 00cc __free_hook 00d0 freehook"
	strings:
		$1 = { 70 40 2D E9 B8 50 9F E5 0C 30 95 E5 00 00 53 E3 00 40 A0 E1 01 60 A0 E1 1F 00 00 1A 00 00 54 E3 10 00 00 0A 00 30 95 E5 00 00 53 E3 1C 00 00 1A 90 30 9F E5 10 00 44 E2 14 30 04 E5 04 30 04 E5 0C 10 14 E5 18 FF FF EB 00 30 A0 E3 0C 30 04 E5 10 30 04 E5 04 00 A0 E1 18 20 14 E5 95 10 A0 E3 ?? ?? ?? ?? 08 40 14 E5 18 30 95 E5 58 50 9F E5 00 00 53 E3 04 00 A0 E1 00 30 85 E5 0B 00 00 0A 06 10 A0 E1 0F E0 A0 E1 ?? ?? ?? ?? 3C 30 9F E5 00 30 85 E5 70 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? DD FF FF EA 18 00 44 E2 D4 FE FF EB DF FF FF EA ?? ?? ?? ?? 14 30 9F E5 00 30 85 E5 70 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 09 53 67 D8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_6_0 {
	meta:
		name = "reallochook"
		size = 528
		refs = "014c mcheck_check_all 0164 memset 0194 realloc 01b4 __aeabi_read_tp 01e8 __realloc_hook 01ec __free_hook 01f0 __malloc_hook 01f4 __memalign_hook 01f8 freehook 01fc mallochook 0200 memalignhook 0204 reallochook 020c __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 00 60 51 E2 0C D0 4D E2 02 B0 A0 E1 00 40 A0 E1 6C 00 00 0A C4 51 9F E5 0C 30 95 E5 00 00 53 E3 48 00 00 1A 1A 00 76 E3 5F 00 00 8A 00 00 54 E3 5A 00 00 0A 00 30 95 E5 00 00 53 E3 18 A0 44 E2 18 70 14 E5 4C 00 00 1A 10 00 44 E2 0C 10 14 E5 DF FE FF EB 07 00 56 E1 42 00 00 3A 1C 40 95 E5 18 00 95 E5 78 81 9F E5 78 C1 9F E5 78 31 9F E5 14 10 95 E5 74 91 9F E5 10 20 95 E5 00 00 54 E3 00 00 8C E5 00 40 88 E5 00 10 83 E5 00 20 89 E5 0A 00 A0 E1 3B 00 00 0A 08 10 8D E8 0B 20 A0 E1 19 10 86 E2 0F E0 A0 E1 ?? ?? ?? ?? 08 10 9D E8 00 40 A0 E1 38 A1 9F E5 38 01 9F E5 38 11 9F E5 38 21 9F E5 00 00 54 E3 00 A0 8C E5 00 00 83 E5 00 10 89 E5 00 20 88 E5 3E 00 00 0A 08 30 95 E5 1C 11 9F E5 0C 30 84 E5 00 00 53 E3 01 10 23 E0 00 20 A0 E3 06 00 84 E9 0C 10 93 15 00 21 9F 15 04 10 81 10 02 20 21 10 00 60 84 E5 14 00 83 19 EC 30 9F E5 06 10 84 E0 03 30 24 E0 28 20 E0 E3 06 00 57 E1 10 40 84 E5 14 30 84 E5 08 40 85 E5 18 20 C1 E5 05 00 00 3A 18 00 84 E2 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? ?? ?? ?? ?? B4 FF FF EA 18 00 87 E2 06 20 67 E0 00 00 84 E0 93 10 A0 E3 ?? ?? ?? ?? F3 FF FF EA 06 00 84 E0 95 10 A0 E3 07 20 66 E0 ?? ?? ?? ?? B7 FF FF EA 0A 00 A0 E1 68 FE FF EB AF FF FF EA 19 10 86 E2 08 10 8D E8 ?? ?? ?? ?? 08 10 9D E8 00 40 A0 E1 C4 FF FF EA 04 70 A0 E1 04 A0 A0 E1 AB FF FF EA 54 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 0C 20 A0 E3 03 20 80 E7 00 00 A0 E3 DC FF FF EA 02 10 A0 E1 55 FF FF EB 06 00 A0 E1 D8 FF FF EA 04 00 A0 E1 D6 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EB BE DA FE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_7_0 {
	meta:
		name = "mcheck_check_all"
		size = 96
	strings:
		$1 = { 38 40 2D E9 50 50 9F E5 08 40 95 E5 00 30 A0 E3 03 00 54 E1 0C 30 85 E5 03 00 00 1A 0A 00 00 EA 0C 40 94 E5 00 00 54 E3 07 00 00 0A 00 30 95 E5 00 00 53 E3 F9 FF FF 0A 04 00 A0 E1 AE FF FF EB 0C 40 94 E5 00 00 54 E3 F7 FF FF 1A 01 30 A0 E3 0C 30 85 E5 38 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_8_0 {
	meta:
		name = "mcheck"
		size = 248
		refs = "005c malloc 0068 free 00cc __libc_malloc_initialized 00d0 mabort 00d8 __free_hook 00dc __memalign_hook 00e0 __malloc_hook 00e4 __realloc_hook 00e8 memalignhook 00ec freehook 00f0 mallochook 00f4 reallochook"
	strings:
		$1 = { F0 4F 2D E9 C0 30 9F E5 C0 20 9F E5 00 30 93 E5 00 00 50 E3 B8 40 9F E5 02 00 A0 01 00 00 53 E3 0C D0 4D E2 04 00 84 E5 06 00 00 DA 00 00 94 E5 00 00 50 E3 00 00 A0 13 00 00 E0 03 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 50 94 E5 00 00 55 E3 00 00 A0 13 F8 FF FF 1A 05 00 A0 E1 ?? ?? ?? ?? 04 00 8D E5 04 00 9D E5 ?? ?? ?? ?? 64 C0 9F E5 64 20 9F E5 64 10 9F E5 64 30 9F E5 64 70 9F E5 05 00 A0 E1 00 50 9C E5 00 80 92 E5 00 A0 91 E5 54 B0 9F E5 54 90 9F E5 54 60 9F E5 00 70 82 E5 00 20 93 E5 18 50 84 E5 01 50 A0 E3 00 B0 8C E5 14 A0 84 E5 00 90 81 E5 10 80 84 E5 1C 20 84 E5 00 60 83 E5 00 50 84 E5 DB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_9_0 {
	meta:
		name = "mcheck_pedantic"
		size = 36
		refs = "0004 mcheck"
	strings:
		$1 = { 08 40 2D E9 ?? ?? ?? ?? 00 00 50 E3 0C 30 9F 05 01 20 A0 03 0C 20 83 05 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_10_0 {
	meta:
		name = "mprobe"
		size = 32
	strings:
		$1 = { 14 30 9F E5 00 30 93 E5 00 00 53 E3 18 00 40 12 FA FD FF 1A 00 00 E0 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "_create_xid"
		size = 276
		refs = "0040 getpid 0060 __gettimeofday 0074 __srand48_r 0084 lrand48_r 00e0 __lll_lock_wait_private 00e8 __aeabi_read_tp"
	strings:
		$1 = { F0 40 2D E9 01 10 A0 E3 0C D0 4D E2 F8 20 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 26 00 00 1A ?? ?? ?? ?? C0 50 9F E5 04 30 95 E5 00 00 53 E1 00 40 A0 E1 08 00 00 0A 00 10 A0 E3 0D 00 A0 E1 ?? ?? ?? ?? 09 00 9D E8 03 00 20 E0 04 00 20 E0 08 10 85 E2 ?? ?? ?? ?? 04 40 85 E5 0D 10 A0 E1 88 00 9F E5 ?? ?? ?? ?? 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 70 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 06 00 00 CA 00 00 9D E5 0C D0 8D E2 F0 40 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? D5 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EF FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "__alphasort64"
		size = 32
		refs = "0014 strcoll"
	strings:
		$1 = { 08 40 2D E9 00 00 90 E5 00 10 91 E5 13 00 80 E2 13 10 81 E2 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_0_0 {
	meta:
		name = "__versionsort64"
		size = 32
		refs = "0014 __strverscmp"
	strings:
		$1 = { 08 40 2D E9 00 00 90 E5 00 10 91 E5 13 00 80 E2 13 10 81 E2 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "lrand48"
		size = 44
		refs = "0014 __nrand48_r 0028 __libc_drand48_data"
	strings:
		$1 = { 04 E0 2D E5 1C 00 9F E5 0C D0 4D E2 00 10 A0 E1 04 20 8D E2 ?? ?? ?? ?? 04 00 9D E5 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1315_0_0 {
	meta:
		name = "mrand48"
		size = 44
		refs = "0014 __jrand48_r 0028 __libc_drand48_data"
	strings:
		$1 = { 04 E0 2D E5 1C 00 9F E5 0C D0 4D E2 00 10 A0 E1 04 20 8D E2 ?? ?? ?? ?? 04 00 9D E5 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "__realpath_chk"
		size = 28
		refs = "000c __realpath 0018 __chk_fail"
	strings:
		$1 = { 01 0A 52 E3 08 40 2D E9 02 00 00 3A ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "psignal"
		size = 244
		refs = "0048 __dcgettext 0060 __fxprintf 0090 __asprintf 00b0 free 00d8 _libc_intl_domainname 00dc _sys_siglist"
	strings:
		$1 = { 70 40 2D E9 00 40 51 E2 10 D0 4D E2 00 50 A0 E1 02 00 00 0A 00 30 D4 E5 00 00 53 E3 27 00 00 1A AC 60 9F E5 06 40 A0 E1 40 00 55 E3 A4 00 9F E5 0E 00 00 8A A0 30 9F E5 05 11 93 E7 00 00 51 E3 0A 00 00 0A 05 20 A0 E3 ?? ?? ?? ?? 04 20 A0 E1 00 00 8D E5 06 30 A0 E1 80 10 9F E5 00 00 A0 E3 ?? ?? ?? ?? 10 D0 8D E2 70 40 BD E8 ?? ?? ?? ?? 6C 10 9F E5 05 20 A0 E3 ?? ?? ?? ?? 00 50 8D E5 00 10 A0 E1 04 20 A0 E1 0C 00 8D E2 06 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0A 00 00 BA 44 10 9F E5 0C 20 9D E5 00 00 A0 E3 ?? ?? ?? ?? 0C 00 9D E5 ?? ?? ?? ?? 10 D0 8D E2 70 40 BD E8 ?? ?? ?? ?? 24 60 9F E5 D7 FF FF EA 08 00 9F E5 1C 10 9F E5 DB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "__lcong48_r"
		size = 96
		refs = "0014 memcpy"
	strings:
		$1 = { 70 40 2D E9 00 60 A0 E1 06 20 A0 E3 01 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? BA 30 D6 E1 B8 10 D6 E1 00 C0 A0 E1 B6 00 D6 E1 00 20 A0 E3 03 50 A0 E1 00 40 82 E1 01 38 A0 E1 BC 10 D6 E1 03 40 84 E1 01 30 A0 E3 02 00 A0 E1 10 40 8C E5 14 50 8C E5 BC 10 CC E1 BE 30 CC E1 70 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "grantpt"
		size = 680
		refs = "0044 realloc 0070 __ptsname_internal 0088 memchr 00a4 malloc 00b4 __aeabi_read_tp 00cc free 00ec __libc_fcntl 0134 __getuid 016c __chown 0194 __chmod 01fc __sysconf 0234 __getgrnam_r 025c __getgid 0284 __libc_errno"
	strings:
		$1 = { F0 4B 2D E9 1C B0 8D E2 01 6A 4B E2 42 DD 4D E2 41 1D 4B E2 08 D0 4D E2 1C 60 46 E2 1C 10 41 E2 00 90 A0 E1 06 50 A0 E1 28 80 41 E2 01 4A A0 E3 07 00 00 EA 06 00 55 E1 18 00 00 0A 05 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 17 00 00 0A 00 50 A0 E1 00 00 54 E3 80 40 A0 03 F4 FF FF 0A 05 10 A0 E1 04 20 A0 E1 09 00 A0 E1 08 30 A0 E1 ?? ?? ?? ?? 00 70 50 E2 04 20 A0 E1 07 10 A0 E1 05 00 A0 E1 23 00 00 1A ?? ?? ?? ?? 00 00 50 E3 27 00 00 1A 06 00 55 E1 84 40 A0 E1 E6 FF FF 1A 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 E7 FF FF 1A CC 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 0C 20 A0 E3 03 20 80 E7 06 00 55 E1 05 00 A0 11 ?? ?? ?? ?? B0 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 00 40 A0 E1 01 10 A0 E3 09 00 A0 E1 03 50 94 E7 ?? ?? ?? ?? 01 00 70 E3 39 00 00 0A 19 00 55 E3 59 00 00 0A 84 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 50 80 E7 00 00 E0 E3 26 00 00 EA 70 31 9F E5 19 00 57 E3 16 70 A0 03 03 30 9F E7 ?? ?? ?? ?? 03 70 80 E7 E3 FF FF EA ?? ?? ?? ?? 18 30 98 E5 00 00 53 E1 00 40 A0 E1 1D 00 00 1A 44 71 9F E5 00 20 97 E5 01 00 72 E3 27 00 00 0A 1C 30 98 E5 03 00 52 E1 04 00 00 0A 04 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 17 00 00 BA 10 30 98 E5 83 3B A0 E1 32 03 53 E3 00 40 A0 03 03 00 00 0A 05 00 A0 E1 19 1E A0 E3 ?? ?? ?? ?? C0 4F A0 E1 06 00 55 E1 04 00 A0 01 02 00 00 0A 05 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 1C D0 4B E2 F0 4B BD E8 ?? ?? ?? ?? 05 00 A0 E1 04 10 A0 E1 1C 20 98 E5 ?? ?? ?? ?? 00 00 50 E3 DB FF FF AA 00 40 E0 E3 EE FF FF EA B0 30 9F E5 03 30 9F E7 03 30 94 E7 09 00 53 E3 C0 FF FF 1A EE FF FF EA 45 00 A0 E3 ?? ?? ?? ?? 01 00 70 E3 00 30 A0 11 01 3B A0 03 0E 20 83 E2 41 1D 4B E2 07 20 C2 E3 1C 10 41 E2 02 D0 4D E0 3C 20 41 E2 00 20 8D E5 38 10 41 E2 08 20 8D E2 64 00 9F E5 ?? ?? ?? ?? 60 30 9F E5 1C 10 4B E2 03 30 91 E7 00 00 53 E3 08 20 93 15 00 20 97 05 00 20 87 15 01 00 72 E3 BE FF FF 1A ?? ?? ?? ?? 00 20 A0 E1 BB FF FF EA 34 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 00 00 E0 E3 CB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 84 EF FF FF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "atol"
		size = 24
		refs = "000c strtol"
		altNames = "atoi atoll"
	strings:
		$1 = { 08 40 2D E9 00 10 A0 E3 0A 20 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_738_0_0 {
	meta:
		name = "__umount"
		size = 20
		refs = "0008 __umount2"
	strings:
		$1 = { 08 40 2D E9 00 10 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_572_0_0 {
	meta:
		name = "atof"
		size = 20
		refs = "0008 strtod"
	strings:
		$1 = { 08 40 2D E9 00 10 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_770_0_0 {
	meta:
		name = "ctime"
		size = 20
		refs = "0004 localtime 0008 asctime"
	strings:
		$1 = { 08 40 2D E9 ?? ?? ?? ?? ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "__getpwuid_r"
		size = 540
		refs = "007c _dl_mcount_wrapper_check 0080 __aeabi_read_tp 00f0 __nss_next2 0160 __nscd_getpwuid_r 01b8 __nss_passwd_lookup2 01fc __nss_not_use_nscd_passwd 0204 __libc_errno 0214 __nss_database_custom"
	strings:
		$1 = { F0 4F 2D E9 F0 E1 9F E5 00 C0 9E E5 00 00 5C E3 14 D0 4D E2 00 70 A0 E1 01 60 A0 E1 02 80 A0 E1 03 90 A0 E1 42 00 00 DA 01 C0 8C E2 64 00 5C E3 00 30 A0 C3 00 C0 8E D5 00 30 8E C5 3D 00 00 CA B8 41 9F E5 00 20 D4 E5 00 00 52 E3 56 00 00 0A 04 B0 94 E5 08 30 94 E5 01 00 7B E3 0C 30 8D E5 08 B0 8D E5 00 00 A0 13 01 00 A0 03 00 00 50 E3 48 00 00 1A 88 A1 9F E5 0C 00 9D E5 ?? ?? ?? ?? ?? ?? ?? ?? 0A 30 9F E7 03 30 80 E0 00 30 8D E5 06 10 A0 E1 08 20 A0 E1 09 30 A0 E1 00 B0 A0 E1 07 00 A0 E1 0C C0 9D E5 0F E0 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 00 50 A0 E3 02 00 74 E3 44 11 9F E5 08 00 8D E2 05 20 A0 E1 0C 30 8D E2 04 00 00 1A 34 E1 9F E5 0E C0 9F E7 0C C0 9B E7 22 00 5C E3 2D 00 00 0A 00 C0 A0 E3 00 40 8D E5 04 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 DE FF FF 0A 01 00 54 E3 1A 00 00 0A 38 E0 9D E5 00 50 8E E5 19 00 00 9A F8 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 00 90 E7 22 00 50 E3 30 00 00 0A 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? C1 FF FF 1A D4 30 9F E5 08 30 D3 E5 00 00 53 E3 BD FF FF 1A 38 20 9D E5 07 00 A0 E1 00 20 8D E5 06 10 A0 E1 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 EE FF FF AA B3 FF FF EA 38 20 9D E5 00 60 82 E5 98 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 50 80 E7 05 00 A0 E1 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 40 E0 E3 38 C0 9D E5 00 30 A0 E3 00 30 8C E5 D8 FF FF EA 0C 30 8D E2 08 00 8D E2 4C 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 0C 20 9D 05 08 30 9D 05 00 30 E0 13 08 20 84 05 04 30 84 E5 0F CA E0 E3 0F E0 A0 E1 5F F0 4C E2 01 30 A0 E3 00 30 C4 E5 9F FF FF EA 02 00 74 E3 CC FF FF 0A 16 50 A0 E3 DE FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_329_0_0 {
	meta:
		name = "__getpwnam_r"
		size = 540
		refs = "007c _dl_mcount_wrapper_check 0080 __aeabi_read_tp 00f0 __nss_next2 0160 __nscd_getpwnam_r 01b8 __nss_passwd_lookup2 01fc __nss_not_use_nscd_passwd 0204 __libc_errno 0214 __nss_database_custom"
	strings:
		$1 = { F0 4F 2D E9 F0 E1 9F E5 00 C0 9E E5 00 00 5C E3 14 D0 4D E2 00 70 A0 E1 01 60 A0 E1 02 80 A0 E1 03 90 A0 E1 42 00 00 DA 01 C0 8C E2 64 00 5C E3 00 30 A0 C3 00 C0 8E D5 00 30 8E C5 3D 00 00 CA B8 41 9F E5 00 20 D4 E5 00 00 52 E3 56 00 00 0A 04 B0 94 E5 08 30 94 E5 01 00 7B E3 0C 30 8D E5 08 B0 8D E5 00 00 A0 13 01 00 A0 03 00 00 50 E3 48 00 00 1A 88 A1 9F E5 0C 00 9D E5 ?? ?? ?? ?? ?? ?? ?? ?? 0A 30 9F E7 03 30 80 E0 00 30 8D E5 06 10 A0 E1 08 20 A0 E1 09 30 A0 E1 00 B0 A0 E1 07 00 A0 E1 0C C0 9D E5 0F E0 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 00 50 A0 E3 02 00 74 E3 44 11 9F E5 08 00 8D E2 05 20 A0 E1 0C 30 8D E2 04 00 00 1A 34 E1 9F E5 0E C0 9F E7 0C C0 9B E7 22 00 5C E3 2D 00 00 0A 00 C0 A0 E3 00 40 8D E5 04 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 DE FF FF 0A 01 00 54 E3 1A 00 00 0A 38 E0 9D E5 00 50 8E E5 19 00 00 9A F8 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 00 90 E7 22 00 50 E3 30 00 00 0A 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? C1 FF FF 1A D4 30 9F E5 08 30 D3 E5 00 00 53 E3 BD FF FF 1A 38 20 9D E5 07 00 A0 E1 00 20 8D E5 06 10 A0 E1 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 EE FF FF AA B3 FF FF EA 38 20 9D E5 00 60 82 E5 98 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 50 80 E7 05 00 A0 E1 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 40 E0 E3 38 C0 9D E5 00 30 A0 E3 00 30 8C E5 D8 FF FF EA 0C 30 8D E2 08 00 8D E2 4C 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 0C 20 9D 05 08 30 9D 05 00 30 E0 13 08 20 84 05 04 30 84 E5 0F CA E0 E3 0F E0 A0 E1 5F F0 4C E2 01 30 A0 E3 00 30 C4 E5 9F FF FF EA 02 00 74 E3 CC FF FF 0A 16 50 A0 E3 DE FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "__futimes"
		size = 584
		refs = "00a8 __aeabi_read_tp 00e0 _itoa_word 00f0 memcpy 0220 __libc_errno"
	strings:
		$1 = { F0 40 2D E9 00 40 51 E2 34 D0 4D E2 00 50 A0 E1 61 00 00 0A 04 30 94 E5 F8 11 9F E5 01 00 53 E1 1F 00 00 8A 0C 20 94 E5 01 00 52 E1 1C 00 00 8A E4 61 9F E5 83 02 63 E0 82 12 62 E0 00 C0 96 E5 00 31 83 E0 01 21 82 E0 00 00 94 E5 08 10 94 E5 83 31 A0 E1 82 21 A0 E1 00 00 5C E3 08 30 8D E5 10 20 8D E5 04 00 8D E5 0C 10 8D E5 15 00 00 1A 04 20 8D E2 00 10 A0 E3 01 30 A0 E1 05 00 A0 E1 57 7F A0 E3 00 00 00 EF 01 0A 70 E3 00 30 A0 E1 35 00 00 8A 03 00 A0 E1 34 D0 8D E2 F0 40 BD E8 ?? ?? ?? ?? 74 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 00 30 E0 E3 F4 FF FF EA 01 30 A0 E3 00 30 86 E5 00 C0 A0 E3 0C 30 A0 E1 2E 10 8D E2 05 00 A0 E1 0A 20 A0 E3 2E C0 CD E5 ?? ?? ?? ?? 38 11 9F E5 0E 20 A0 E3 0E 00 40 E2 ?? ?? ?? ?? 2C 71 9F E5 04 10 A0 E1 00 00 00 EF 01 0A 70 E3 00 30 A0 E1 E1 FF FF 9A 18 21 9F E5 ?? ?? ?? ?? 00 30 63 E2 02 20 9F E7 02 30 80 E7 08 31 9F E5 03 30 9F E7 03 30 90 E7 14 00 53 E3 06 00 00 0A 2B 00 00 CA 02 00 53 E3 1C 00 00 0A 0D 00 53 E3 12 00 00 1A 00 00 54 E3 10 00 00 0A DC 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 26 20 A0 E3 03 20 80 E7 00 30 E0 E3 C9 FF FF EA C4 20 9F E5 ?? ?? ?? ?? 00 30 63 E2 02 20 9F E7 02 30 80 E7 B4 30 9F E5 03 30 9F E7 03 30 90 E7 26 00 53 E3 CA FF FF 0A 00 30 E0 E3 BD FF FF EA 78 60 9F E5 00 30 96 E5 00 00 53 E3 04 20 A0 01 B0 FF FF 0A C4 FF FF EA 05 00 A0 E1 01 10 A0 E3 00 20 A0 E3 37 70 A0 E3 00 00 00 EF 01 0A 70 E3 0A 00 00 8A 68 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 26 20 A0 E3 03 20 80 E7 EA FF FF EA 24 00 53 E3 D7 FF FF 0A 28 00 53 E3 E6 FF FF 1A D4 FF FF EA 40 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 30 E0 E3 9E FF FF EA 3F 42 0F 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 0D 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "wmemset"
		size = 104
	strings:
		$1 = { 03 00 52 E3 00 30 A0 E1 0D 00 00 9A 02 C0 A0 E1 04 C0 4C E2 03 00 5C E3 00 10 83 E5 04 10 83 E5 08 10 83 E5 0C 10 83 E5 10 30 83 E2 F7 FF FF 8A 04 30 42 E2 23 31 A0 E1 01 30 83 E2 03 32 80 E0 03 20 02 E2 00 00 52 E3 ?? ?? ?? ?? 01 00 52 E3 00 10 83 E5 ?? ?? ?? ?? 03 00 52 E3 04 10 83 E5 08 10 83 05 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "__fdatasync_nocancel"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 94 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_1_0 {
	meta:
		name = "fdatasync"
		size = 104
		refs = "0028 __syscall_error 0030 __libc_enable_asynccancel 004c __libc_disable_asynccancel"
	strings:
		$1 = { 60 C0 9F E5 0C C0 9F E7 00 00 3C E3 04 70 2D E5 05 00 00 1A 94 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? 03 40 2D E9 ?? ?? ?? ?? 00 C0 A0 E1 08 00 9D E4 94 70 A0 E3 00 00 00 EF 00 70 A0 E1 0C 00 A0 E1 ?? ?? ?? ?? 07 00 A0 E1 04 E0 9D E4 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "_dl_add_to_namespace_list"
		size = 188
		refs = "0018 __pthread_mutex_lock 009c __pthread_mutex_unlock 00ac _dl_load_write_lock 00b0 _dl_ns 00b4 _dl_load_adds"
	strings:
		$1 = { F8 40 2D E9 9C 30 9F E5 00 00 53 E3 00 60 A0 E1 01 40 A0 E1 90 00 9F 15 ?? ?? ?? ?? 84 01 A0 E1 04 30 80 E0 84 10 9F E5 83 30 84 E0 03 31 A0 E1 03 20 91 E7 00 00 52 E3 03 60 81 07 01 00 00 1A 05 00 00 EA 03 20 A0 E1 0C 30 92 E5 00 00 53 E3 FB FF FF 1A 10 20 86 E5 0C 60 82 E5 04 00 80 E0 80 40 84 E0 48 00 9F E5 04 11 81 E0 0C 00 90 E8 04 C0 91 E5 3C 70 9F E5 01 40 92 E2 00 50 A3 E2 01 C0 8C E2 00 00 57 E3 04 C0 81 E5 50 22 86 E5 54 32 86 E5 30 00 80 E8 0C 00 9F 15 ?? ?? ?? ?? F8 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_51_1_0 {
	meta:
		name = "_dl_new_object"
		size = 580
		refs = "0018 strlen 0034 calloc 0060 memcpy 013c __getcwd 0148 __aeabi_read_tp 0170 realloc 0188 free 01d0 strchr 01f0 mempcpy 0220 malloc 0238 _dl_debug_mask 023c _dl_ns 0240 __libc_errno"
	strings:
		$1 = { F8 4F 2D E9 00 80 A0 E1 01 00 A0 E1 01 70 A0 E1 02 90 A0 E1 03 50 A0 E1 ?? ?? ?? ?? 00 30 A0 E1 9A 0F 80 E2 01 10 A0 E3 01 00 80 E2 01 A0 83 E0 2C 60 9D E5 ?? ?? ?? ?? 00 40 50 E2 54 00 00 0A 97 3F 84 E2 96 0F 84 E2 07 10 A0 E1 0A 20 A0 E1 64 01 84 E5 1C 30 84 E5 14 40 84 E5 9A 0F 84 E2 ?? ?? ?? ?? CC 31 9F E5 94 21 D4 E5 00 30 93 E5 03 20 C2 E3 01 0C 13 E3 03 90 09 E2 01 30 A0 E3 02 90 89 E1 FC 31 84 05 64 32 84 E5 86 21 86 E0 A4 31 9F E5 82 20 86 E0 02 31 93 E7 00 00 53 E3 57 3F 83 12 B8 31 84 15 6E 1F 84 E2 04 20 A0 E3 01 30 A0 13 00 00 55 E3 6C 51 84 E5 5C 02 84 E5 04 80 84 E5 94 91 C4 E5 18 60 84 E5 CC 11 84 E5 C8 21 84 E5 04 50 A0 01 01 00 00 1A 03 00 00 EA 02 50 A0 E1 6C 21 95 E5 00 00 52 E3 FB FF FF 1A 00 00 53 E3 29 00 00 1A 57 5F 85 E2 03 50 81 E7 57 3F 84 E2 D0 31 84 E5 00 50 D8 E5 00 00 55 E3 1F 00 00 0A 08 00 A0 E1 ?? ?? ?? ?? 2F 00 55 E3 00 70 A0 E1 01 A0 80 E2 3B 00 00 0A 0C 91 9F E5 0A 50 A0 E1 00 B0 A0 E3 09 00 00 EA ?? ?? ?? ?? 00 00 50 E3 1F 00 00 1A ?? ?? ?? ?? 09 30 9F E7 03 30 90 E7 22 00 53 E3 05 B0 A0 E1 08 00 00 1A 06 50 A0 E1 80 60 85 E2 06 10 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 7F 10 85 E2 00 50 50 E2 01 10 67 E0 ED FF FF 1A 0B 00 A0 E1 ?? ?? ?? ?? 00 50 E0 E3 A8 51 84 E5 04 00 A0 E1 F8 4F BD E8 ?? ?? ?? ?? B8 31 94 E5 57 5F 85 E2 05 00 53 E1 D3 FF FF 0A 28 20 9D E5 08 00 12 E3 04 30 A0 03 BC 31 84 15 00 30 A0 13 CC FF FF EA 05 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 01 30 50 E5 2F 00 53 E3 2F 30 A0 13 00 30 C0 15 01 00 80 12 08 10 A0 E1 0A 20 A0 E1 ?? ?? ?? ?? 01 20 50 E5 2F 00 52 E3 00 30 A0 E1 01 00 40 E2 FA FF FF 1A 00 00 55 E1 03 00 A0 01 00 30 A0 E3 00 30 C0 E5 DC FF FF EA 0A 00 A0 E1 ?? ?? ?? ?? 00 50 50 E2 05 00 A0 11 ED FF FF 1A 00 50 E0 E3 D5 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "__atfct_seterrno_2"
		size = 532
		refs = "003c __aeabi_read_tp 0068 __fxstat64 00c4 __xstat64 00fc strchr 0118 __lxstat64 0204 __libc_errno"
	strings:
		$1 = { 70 40 2D E9 70 D0 4D E2 80 60 9D E5 00 C0 92 E2 01 C0 A0 13 00 50 96 E2 01 50 A0 13 05 E0 9C E1 00 40 A0 E1 03 00 00 0A 14 00 50 E3 08 00 00 0A 02 00 50 E3 2B 00 00 0A C4 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 40 80 E7 70 D0 8D E2 70 40 BD E8 ?? ?? ?? ?? 00 00 5C E3 0A 00 00 0A 08 20 8D E2 03 00 A0 E3 04 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 04 30 9D E5 F3 FF FF 1A 18 20 9D E5 0F 2A 02 E2 01 09 52 E3 51 00 00 0A 00 00 55 E3 E9 FF FF 0A 03 10 A0 E1 08 20 8D E2 03 00 A0 E3 ?? ?? ?? ?? 00 00 50 E3 E7 FF FF 1A 18 30 9D E5 0F 3A 03 E2 01 09 53 E3 DF FF FF 1A 08 20 8D E2 03 00 A0 E3 40 11 9F E5 ?? ?? ?? ?? 00 00 50 E3 4A 00 00 1A 18 40 9D E5 0F 4A 04 E2 01 09 54 E3 14 40 A0 03 26 40 A0 13 D3 FF FF EA 00 00 5C E3 1A 00 00 0A 0E 00 82 E2 2F 10 A0 E3 04 20 8D E5 ?? ?? ?? ?? 04 20 9D E5 00 30 A0 E3 02 10 A0 E1 00 30 C0 E5 08 20 8D E2 03 00 A0 E3 ?? ?? ?? ?? 01 00 70 E3 07 00 00 0A 00 00 50 E3 0B 00 00 1A 18 30 9D E5 0F 3A 03 E2 0A 0A 53 E3 07 00 00 0A 09 40 A0 E3 BC FF FF EA C0 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 02 00 53 E3 F7 FF FF 0A 00 00 55 E3 B4 FF FF 0A 2F 10 A0 E3 0E 00 86 E2 ?? ?? ?? ?? 00 30 A0 E3 00 30 C0 E5 06 10 A0 E1 03 00 A0 E3 08 20 8D E2 ?? ?? ?? ?? 01 00 70 E3 07 00 00 0A 00 00 50 E3 A7 FF FF 1A 18 40 9D E5 0F 4A 04 E2 0A 0A 54 E3 02 40 A0 03 09 40 A0 13 A1 FF FF EA 58 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 40 90 E7 02 00 54 E3 02 40 A0 13 09 40 A0 03 99 FF FF EA 08 20 8D E2 03 00 A0 E3 28 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 04 30 9D E5 03 00 00 1A 18 20 9D E5 0F 2A 02 E2 01 09 52 E3 A2 FF FF 0A 26 40 A0 E3 8C FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_1_0 {
	meta:
		name = "renameat"
		size = 456
		refs = "0054 __aeabi_read_tp 009c strlen 00cc __snprintf 0154 __atfct_seterrno_2 01ac __have_atfcts 01b4 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 A0 81 9F E5 20 B0 8D E2 0C D0 4D E2 00 C0 98 E5 00 00 5C E3 00 90 A0 E1 01 60 A0 E1 02 A0 A0 E1 03 50 A0 E1 15 00 00 BA 7C 71 9F E5 00 00 00 EF 01 0A 70 E3 00 40 A0 E1 03 00 00 8A 04 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 5C 31 9F E5 ?? ?? ?? ?? 00 40 64 E2 03 30 9F E7 03 40 80 E7 4C 31 9F E5 03 30 9F E7 03 30 90 E7 26 00 53 E3 00 40 E0 13 F0 FF FF 1A 00 30 E0 E3 00 30 88 E5 64 00 79 E3 34 00 00 0A 00 30 D6 E5 2F 00 53 E3 31 00 00 0A 06 00 A0 E1 ?? ?? ?? ?? 00 10 50 E2 39 00 00 0A 2E 30 81 E2 07 30 C3 E3 03 D0 4D E0 08 80 8D E2 00 60 8D E5 20 10 81 E2 08 00 A0 E1 F0 20 9F E5 09 30 A0 E1 ?? ?? ?? ?? 64 00 7A E3 08 60 A0 E1 23 00 00 0A 00 30 D5 E5 2F 00 53 E3 20 00 00 0A 05 00 A0 E1 ?? ?? ?? ?? 00 10 50 E2 1E 00 00 0A 2E 30 81 E2 07 30 C3 E3 03 D0 4D E0 08 40 8D E2 00 50 8D E5 20 10 81 E2 04 00 A0 E1 A0 20 9F E5 0A 30 A0 E1 ?? ?? ?? ?? 04 50 A0 E1 06 00 A0 E1 05 10 A0 E1 26 70 A0 E3 00 00 00 EF 01 0A 70 E3 00 40 A0 91 BF FF FF 9A 04 20 A0 E1 00 80 8D E5 00 00 60 E2 0A 10 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 40 E0 E3 B7 FF FF EA 64 00 7A E3 00 80 A0 E3 DB FF FF 1A 00 40 A0 E3 EB FF FF EA 44 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 02 20 A0 E3 03 20 80 E7 00 40 E0 E3 AB FF FF EA 2C 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 02 20 A0 E3 03 20 80 E7 00 40 E0 E3 A4 FF FF EA ?? ?? ?? ?? 49 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_54_0_0 {
	meta:
		name = "__getdate_r"
		size = 1464
		refs = "0018 getenv 004c __xstat64 0078 __access 0094 _IO_new_fopen 00b0 __aeabi_read_tp 00f4 strlen 0178 memcpy 01ec strptime 021c __getline 0230 free 024c _IO_new_fclose 0290 time 029c __localtime_r 0394 __aeabi_idivmod 03dc mktime 045c __libc_alloca_cutoff 046c malloc 04d4 memset 05ac __libc_tsd_CTYPE_B"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 DC D0 4D E2 00 60 A0 E1 8C 05 9F E5 01 50 A0 E1 ?? ?? ?? ?? 00 40 50 E2 02 00 00 0A 00 30 D4 E5 00 00 53 E3 03 00 00 1A 01 00 A0 E3 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 03 00 A0 E3 04 10 A0 E1 8C 20 4B E2 ?? ?? ?? ?? 00 00 50 E3 03 00 A0 B3 F5 FF FF BA 7C 30 1B E5 0F 3A 03 E2 02 09 53 E3 04 00 A0 13 F0 FF FF 1A 04 00 A0 E1 04 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 01 00 00 AA 02 00 A0 E3 E9 FF FF EA 04 00 A0 E1 10 15 9F E5 ?? ?? ?? ?? 00 40 50 E2 F8 FF FF 0A 00 30 94 E5 02 39 83 E3 00 30 84 E5 F8 34 9F E5 ?? ?? ?? ?? 03 30 9F E7 00 20 D6 E5 03 80 90 E7 82 20 A0 E1 B2 30 98 E1 02 0A 13 E3 07 00 00 0A 01 30 86 E2 00 20 D3 E5 82 20 A0 E1 B2 20 98 E1 02 0A 12 E3 03 60 A0 E1 01 30 83 E2 F8 FF FF 1A 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 60 00 00 0A 01 70 40 E2 07 30 D6 E7 83 30 A0 E1 B3 30 98 E1 02 3A 13 E2 06 00 00 1A 4F 00 00 EA 03 20 D6 E7 82 20 A0 E1 B2 20 98 E1 02 0A 12 E3 03 00 00 0A 03 70 A0 E1 00 00 57 E3 01 30 47 E2 F6 FF FF 1A 07 00 50 E1 43 00 00 9A 01 80 87 E2 01 0A 58 E3 C0 00 00 8A 0E 30 88 E2 07 30 C3 E3 03 D0 4D E0 0D 30 A0 E1 A3 81 A0 E1 88 31 A0 E1 06 10 A0 E1 03 00 A0 E1 07 20 A0 E1 ?? ?? ?? ?? 00 A0 A0 E3 88 A1 C7 E7 F8 A0 0B E5 00 60 A0 E1 00 80 A0 E3 F0 80 0B E5 EC 80 0B E5 08 70 A0 E1 02 A1 A0 E3 00 90 E0 E3 19 00 00 EA F0 10 1B E5 02 00 D1 E7 0A 00 50 E3 02 70 C1 07 06 00 A0 E1 F0 10 1B 05 18 A0 85 E5 0C A0 85 E5 10 A0 85 E5 14 A0 85 E5 04 A0 85 E5 00 A0 85 E5 08 A0 85 E5 20 90 85 E5 24 70 85 E5 28 70 85 E5 05 20 A0 E1 ?? ?? ?? ?? 00 80 50 E2 02 00 00 0A 00 20 D8 E5 00 00 52 E3 09 00 00 0A 00 20 94 E5 10 00 12 E3 06 00 00 1A 04 20 A0 E1 F0 00 4B E2 EC 10 4B E2 ?? ?? ?? ?? 00 00 50 E3 01 20 40 E2 DE FF FF AA F8 00 1B E5 ?? ?? ?? ?? F0 00 1B E5 ?? ?? ?? ?? 00 30 94 E5 20 00 13 E3 04 00 A0 E1 05 00 00 0A ?? ?? ?? ?? 05 00 A0 E3 76 FF FF EA 00 30 A0 E3 F8 30 0B E5 C9 FF FF EA ?? ?? ?? ?? 00 00 58 E3 02 00 00 0A 00 70 D8 E5 00 00 57 E3 03 00 00 0A 07 00 A0 E3 6B FF FF EA F8 00 0B E5 BF FF FF EA E8 00 4B E2 ?? ?? ?? ?? E8 00 4B E2 E4 10 4B E2 ?? ?? ?? ?? 18 80 95 E5 06 00 58 E3 50 00 00 8A 14 60 95 E5 02 01 56 E3 07 30 A0 11 10 40 95 15 4F 00 00 0A 0B 00 54 E3 02 00 00 8A 0C 20 95 E5 02 01 52 E3 73 00 00 0A 03 00 95 E9 02 01 51 E3 00 20 95 E5 91 00 00 0A 02 01 50 E3 00 00 A0 03 04 00 85 05 02 01 52 E3 00 20 A0 03 00 20 85 05 17 00 51 E3 01 00 00 8A 02 01 54 E3 8C 00 00 0A 02 01 56 E3 D0 20 1B 05 14 20 85 05 02 01 54 E3 D4 20 1B 05 10 20 85 05 00 00 53 E3 2A 00 00 1A 10 30 95 E5 0B 00 53 E3 14 60 95 E5 0C 40 95 E5 20 00 00 8A 01 20 A0 E3 12 33 A0 E1 60 22 9F E5 02 20 03 E0 00 00 52 E3 1C 00 00 1A 54 22 9F E5 02 20 03 E0 00 00 52 E3 6C 00 00 1A 02 00 13 E3 14 00 00 0A 00 00 54 E3 12 00 00 DA 76 6E 86 E2 0C 60 86 E2 03 00 16 E3 1C 10 A0 13 0B 00 00 1A 06 00 A0 E1 64 10 A0 E3 ?? ?? ?? ?? 00 00 51 E3 1D 10 A0 13 05 00 00 1A 06 00 A0 E1 19 1E A0 E3 ?? ?? ?? ?? 00 00 51 E3 1D 10 A0 03 1C 10 A0 13 01 00 54 E1 04 00 00 DA 08 00 A0 E3 19 FF FF EA 01 40 44 E2 1E 00 54 E3 FA FF FF 8A 05 00 A0 E1 ?? ?? ?? ?? 01 00 70 E3 08 00 A0 03 00 00 A0 13 10 FF FF EA 10 40 85 E2 07 30 A0 E1 50 00 94 E8 AF FF FF EA 10 40 95 E5 02 01 54 E3 07 30 A0 11 AB FF FF 1A 0C 30 95 E5 02 01 53 E3 07 30 A0 11 AC FF FF 1A CC 00 1B E5 D4 40 4B E2 50 00 94 E8 08 00 60 E0 07 00 80 E2 14 60 85 E5 10 40 85 E5 07 10 A0 E3 ?? ?? ?? ?? D8 30 1B E5 01 10 83 E0 0C 10 85 E5 01 30 A0 E3 99 FF FF EA 08 00 A0 E1 ?? ?? ?? ?? 00 90 50 E2 3A FF FF 1A 08 00 A0 E1 ?? ?? ?? ?? 00 30 50 E2 F8 30 0B E5 05 00 00 0A 06 10 A0 E1 07 20 A0 E1 ?? ?? ?? ?? F8 60 1B E5 07 90 C6 E7 3D FF FF EA 04 00 A0 E1 ?? ?? ?? ?? 06 00 A0 E3 E3 FE FF EA 02 01 56 E3 D4 60 1B 05 D0 30 1B 05 04 60 66 00 A6 6F 83 00 14 60 85 05 02 01 58 E3 01 10 A0 03 11 00 00 0A 00 10 A0 E3 2C 20 A0 E3 B8 00 4B E2 ?? ?? ?? ?? 01 30 A0 E3 B8 00 4B E2 A4 60 0B E5 A8 40 0B E5 AC 30 0B E5 ?? ?? ?? ?? A0 00 1B E5 08 00 60 E0 07 00 80 E2 07 10 A0 E3 ?? ?? ?? ?? 14 60 95 E5 10 40 95 E5 01 10 81 E2 0C 10 85 E5 01 30 A0 E3 6D FF FF EA 01 40 44 E2 1D 00 54 E3 A6 FF FF 8A AA FF FF EA 02 01 50 E3 11 00 00 0A 00 10 A0 E3 08 10 85 E5 68 FF FF EA 0C 20 95 E5 02 01 52 E3 6F FF FF 1A 18 20 95 E5 02 01 52 E3 6C FF FF 1A DC 20 4B E2 0C 00 92 E8 D4 40 1B E5 01 10 62 E0 A1 3F 83 E0 0C 30 85 E5 10 40 85 E5 01 30 A0 E3 63 FF FF EA 02 01 52 E3 EB FF FF 1A E0 00 4B E2 03 00 90 E8 E4 20 1B E5 02 01 51 E3 03 00 85 E9 00 20 85 E5 E4 FF FF 0A 4F FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? D5 0A 00 00 28 05 00 00 }
	condition:
		$1
}

rule file_54_1_0 {
	meta:
		name = "getdate"
		size = 48
		refs = "0008 __getdate_r 002c getdate_err"
	strings:
		$1 = { 08 40 2D E9 1C 10 9F E5 ?? ?? ?? ?? 00 30 50 E2 14 20 9F 15 00 00 A0 13 00 30 82 15 04 00 9F 05 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "__nss_ethers_lookup2"
		size = 116
		refs = "0038 __nss_lookup 0054 __nss_database_lookup 006c __nss_ethers_database"
	strings:
		$1 = { F0 41 2D E9 60 50 9F E5 00 C0 95 E5 00 00 5C E3 00 40 A0 E1 01 80 A0 E1 02 70 A0 E1 03 60 A0 E1 07 00 00 0A 00 C0 84 E5 04 00 A0 E1 08 10 A0 E1 07 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? F0 41 BD E8 ?? ?? ?? ?? 0C 10 A0 E1 0C 20 A0 E1 1C 00 9F E5 05 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 C0 95 A5 EF FF FF AA 00 00 E0 E3 F3 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_882_0_0 {
	meta:
		name = "__nss_aliases_lookup2"
		size = 116
		refs = "0038 __nss_lookup 0054 __nss_database_lookup 006c __nss_aliases_database"
	strings:
		$1 = { F0 41 2D E9 60 50 9F E5 00 C0 95 E5 00 00 5C E3 00 40 A0 E1 01 80 A0 E1 02 70 A0 E1 03 60 A0 E1 07 00 00 0A 00 C0 84 E5 04 00 A0 E1 08 10 A0 E1 07 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? F0 41 BD E8 ?? ?? ?? ?? 0C 10 A0 E1 0C 20 A0 E1 1C 00 9F E5 05 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 C0 95 A5 EF FF FF AA 00 00 E0 E3 F3 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_830_0_0 {
	meta:
		name = "__nss_netgroup_lookup2"
		size = 116
		refs = "0038 __nss_lookup 0054 __nss_database_lookup 006c __nss_netgroup_database"
	strings:
		$1 = { F0 41 2D E9 60 50 9F E5 00 C0 95 E5 00 00 5C E3 00 40 A0 E1 01 80 A0 E1 02 70 A0 E1 03 60 A0 E1 07 00 00 0A 00 C0 84 E5 04 00 A0 E1 08 10 A0 E1 07 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? F0 41 BD E8 ?? ?? ?? ?? 0C 10 A0 E1 0C 20 A0 E1 1C 00 9F E5 05 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 C0 95 A5 EF FF FF AA 00 00 E0 E3 F3 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_665_0_0 {
	meta:
		name = "__nss_protocols_lookup2"
		size = 116
		refs = "0038 __nss_lookup 0054 __nss_database_lookup 006c __nss_protocols_database"
	strings:
		$1 = { F0 41 2D E9 60 50 9F E5 00 C0 95 E5 00 00 5C E3 00 40 A0 E1 01 80 A0 E1 02 70 A0 E1 03 60 A0 E1 07 00 00 0A 00 C0 84 E5 04 00 A0 E1 08 10 A0 E1 07 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? F0 41 BD E8 ?? ?? ?? ?? 0C 10 A0 E1 0C 20 A0 E1 1C 00 9F E5 05 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 C0 95 A5 EF FF FF AA 00 00 E0 E3 F3 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_282_0_0 {
	meta:
		name = "__nss_rpc_lookup2"
		size = 116
		refs = "0038 __nss_lookup 0054 __nss_database_lookup 006c __nss_rpc_database"
	strings:
		$1 = { F0 41 2D E9 60 50 9F E5 00 C0 95 E5 00 00 5C E3 00 40 A0 E1 01 80 A0 E1 02 70 A0 E1 03 60 A0 E1 07 00 00 0A 00 C0 84 E5 04 00 A0 E1 08 10 A0 E1 07 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? F0 41 BD E8 ?? ?? ?? ?? 0C 10 A0 E1 0C 20 A0 E1 1C 00 9F E5 05 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 C0 95 A5 EF FF FF AA 00 00 E0 E3 F3 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_661_0_0 {
	meta:
		name = "__nss_services_lookup2"
		size = 116
		refs = "0038 __nss_lookup 0054 __nss_database_lookup 006c __nss_services_database"
	strings:
		$1 = { F0 41 2D E9 60 50 9F E5 00 C0 95 E5 00 00 5C E3 00 40 A0 E1 01 80 A0 E1 02 70 A0 E1 03 60 A0 E1 07 00 00 0A 00 C0 84 E5 04 00 A0 E1 08 10 A0 E1 07 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? F0 41 BD E8 ?? ?? ?? ?? 0C 10 A0 E1 0C 20 A0 E1 1C 00 9F E5 05 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 C0 95 A5 EF FF FF AA 00 00 E0 E3 F3 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_0_0 {
	meta:
		name = "__setstate_r"
		size = 240
		refs = "00a4 __aeabi_idivmod 00cc __aeabi_read_tp 00ec __libc_errno"
	strings:
		$1 = { 00 00 51 E3 00 00 50 13 70 40 2D E9 01 40 A0 E1 04 50 80 E2 2B 00 00 0A 0C 30 91 E5 00 00 53 E3 08 20 91 E5 04 10 91 15 01 10 62 10 41 11 A0 11 01 11 81 10 03 30 81 10 04 30 02 E5 A0 10 9F E5 00 20 90 E5 91 32 CC E0 C2 3F A0 E1 CC 30 63 E0 03 31 83 E0 02 30 63 E0 04 00 53 E3 19 00 00 8A 80 20 9F E5 03 C1 82 E0 14 60 9C E5 03 21 92 E7 00 00 53 E3 0C 30 84 E5 10 60 84 E5 14 20 84 E5 0A 00 00 0A 00 30 90 E5 93 01 C1 E0 C3 3F A0 E1 C1 00 63 E0 00 31 85 E0 04 30 84 E5 02 00 80 E0 06 10 A0 E1 ?? ?? ?? ?? 01 11 85 E0 00 10 84 E5 06 61 85 E0 18 60 84 E5 08 50 84 E5 00 00 A0 E3 70 40 BD E8 ?? ?? ?? ?? 1C 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 00 00 E0 E3 F6 FF FF EA 67 66 66 66 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_1_0 {
	meta:
		name = "__random_r"
		size = 208
		refs = "00b4 __aeabi_read_tp 00cc __libc_errno"
	strings:
		$1 = { 00 00 51 E3 00 00 50 13 30 40 2D E9 00 30 A0 E1 26 00 00 0A 0C 00 90 E5 00 00 50 E3 08 20 93 E5 13 00 00 0A 11 00 93 E8 00 50 90 E5 00 C0 94 E5 0C C0 85 E0 18 50 93 E5 04 C0 80 E4 AC C0 A0 E1 00 00 55 E1 02 00 A0 91 00 C0 81 E5 04 20 84 92 03 00 00 8A 05 00 83 E8 00 00 A0 E3 30 40 BD E8 ?? ?? ?? ?? 04 40 84 E2 04 00 55 E1 04 20 A0 81 F7 FF FF EA 00 30 92 E5 83 C4 63 E0 0C C1 83 E0 8C C4 6C E0 8C C0 83 E0 8C C2 8C E0 0C C1 63 E0 0C 31 83 E0 03 3A 83 E2 39 30 83 E2 02 31 C3 E3 00 30 82 E5 30 40 BD E8 00 30 81 E5 ?? ?? ?? ?? 14 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 00 00 E0 E3 E3 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_2_0 {
	meta:
		name = "__srandom_r"
		size = 260
		refs = "00dc __random_r"
	strings:
		$1 = { F0 41 2D E9 00 50 51 E2 08 D0 4D E2 39 00 00 0A 0C 10 95 E5 04 00 51 E3 36 00 00 8A 00 00 50 E3 08 60 95 E5 00 20 A0 11 01 20 A0 03 00 00 51 E3 00 20 86 E5 2B 00 00 0A 10 40 95 E5 01 00 54 E3 1B 00 00 DA B4 70 9F E5 06 00 A0 E1 01 C0 A0 E3 97 12 C3 E0 C2 1F A0 E1 02 30 83 E0 43 38 61 E0 83 13 63 E0 01 11 63 E0 81 11 61 E0 01 11 83 E0 81 11 81 E0 02 20 61 E0 03 8A 63 E0 02 11 82 E0 08 81 83 E0 01 12 61 E0 08 81 83 E0 81 22 82 E0 08 12 63 E0 82 21 62 E0 01 31 63 E0 03 21 92 E0 01 C0 8C E2 06 21 42 42 04 00 5C E1 04 20 A0 E5 E6 FF FF 1A 04 41 84 E0 14 30 95 E5 84 40 A0 E1 03 31 86 E0 01 40 54 E2 48 00 85 E8 05 00 00 4A 01 40 44 E2 05 00 A0 E1 04 10 8D E2 ?? ?? ?? ?? 01 00 74 E3 F9 FF FF 1A 00 00 A0 E3 08 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 00 00 E0 E3 FA FF FF EA 5F 0B 4E 83 }
	condition:
		$1
}

rule file_57_3_0 {
	meta:
		name = "__initstate_r"
		size = 288
		refs = "0074 __srandom_r 0100 __aeabi_read_tp 011c __libc_errno"
	strings:
		$1 = { F8 40 2D E9 00 40 53 E2 01 70 A0 E1 3A 00 00 0A 08 30 94 E5 00 00 53 E3 07 00 00 0A 0C 10 94 E5 00 00 51 E3 04 C0 94 15 0C C0 63 10 4C C1 A0 11 0C C1 8C 10 01 10 8C 10 04 10 03 E5 7F 00 52 E3 10 00 00 8A 1F 00 52 E3 27 00 00 8A 07 00 52 E3 29 00 00 9A 00 50 A0 E3 04 30 87 E2 0C 50 84 E5 14 50 84 E5 10 50 84 E5 18 30 84 E5 08 30 84 E5 04 10 A0 E1 ?? ?? ?? ?? 00 50 87 E5 05 00 A0 E1 F8 40 BD E8 ?? ?? ?? ?? FF 00 52 E3 03 50 A0 93 04 50 A0 83 7C 20 9F E5 05 31 82 E0 14 30 93 E5 05 11 92 E7 04 60 87 E2 03 21 86 E0 0C 50 84 E5 10 30 84 E5 14 10 84 E5 08 60 84 E5 18 20 84 E5 04 10 A0 E1 ?? ?? ?? ?? 04 30 94 E5 03 60 66 E0 46 61 A0 E1 06 61 86 E0 05 50 86 E0 00 50 87 E5 00 00 A0 E3 F8 40 BD E8 ?? ?? ?? ?? 3F 00 52 E3 02 50 A0 83 01 50 A0 93 E5 FF FF EA 18 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 00 00 E0 E3 D9 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_0_0 {
	meta:
		name = "fputwc"
		size = 532
		refs = "001c __aeabi_read_tp 0084 _IO_fwide 0164 __woverflow 0174 __lll_lock_wait_private 0210 _Unwind_Resume"
	strings:
		$1 = { F0 41 2D E9 00 40 91 E5 02 49 14 E2 01 50 A0 E1 00 80 A0 E1 18 00 00 1A 48 60 91 E5 ?? ?? ?? ?? 08 30 96 E5 13 7D 40 E2 07 00 53 E1 0F 00 00 0A 01 10 A0 E3 06 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 42 00 00 1A 48 30 95 E5 08 70 83 E5 03 60 A0 E1 04 30 96 E5 01 30 83 E2 04 30 86 E5 05 00 A0 E1 01 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 27 00 00 BA 5C 30 95 E5 00 00 53 E3 2F 00 00 0A 10 20 93 E5 14 10 93 E5 01 00 52 E1 04 10 82 32 10 10 83 35 00 80 82 35 28 00 00 2A 00 30 95 E5 02 09 13 E3 17 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 11 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 04 00 00 CA 08 00 A0 E1 F0 41 BD E8 ?? ?? ?? ?? 00 80 E0 E3 DF FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF F1 FF FF EA 08 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 D1 FF FF EA 06 00 A0 E1 ?? ?? ?? ?? B9 FF FF EA 00 30 95 E5 02 09 13 E3 00 80 A0 E1 1F 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 19 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 07 00 00 DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 08 00 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "__towctrans_l"
		size = 92
		altNames = "__towctrans"
	strings:
		$1 = { 00 00 51 E3 ?? ?? ?? ?? 00 30 91 E5 30 33 A0 E1 04 20 91 E5 02 00 53 E1 ?? ?? ?? ?? 05 30 83 E2 03 31 91 E7 00 00 53 E3 ?? ?? ?? ?? 08 C0 91 E5 0C 20 91 E5 30 2C 02 E0 02 31 83 E0 03 30 91 E7 00 00 53 E3 10 20 91 15 02 20 00 10 02 31 83 10 03 30 91 17 03 00 80 10 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "wcscmp"
		size = 44
	strings:
		$1 = { 04 30 91 E4 00 00 53 E3 04 20 90 E4 04 00 00 0A 03 00 52 E1 F9 FF FF 0A 00 00 E0 33 01 00 A0 23 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "__iswalnum_l"
		size = 156
	strings:
		$1 = { 7F 30 D0 E3 1F 00 00 0A 00 30 91 E5 68 20 93 E5 02 31 83 E0 50 30 93 E5 00 20 93 E5 30 22 A0 E1 04 10 93 E5 01 00 52 E1 12 00 00 2A 05 20 82 E2 02 21 93 E7 00 00 52 E3 10 00 00 0A 08 C0 93 E5 0C 10 93 E5 30 1C 01 E0 01 21 82 E0 02 20 93 E7 00 00 52 E3 09 00 00 0A 10 10 93 E5 A0 12 01 E0 01 21 82 E0 02 30 93 E7 1F 00 00 E2 33 00 A0 E1 01 00 00 E2 ?? ?? ?? ?? 00 00 A0 E3 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? 34 30 91 E5 80 00 A0 E1 B0 00 93 E1 08 00 00 E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_1_0 {
	meta:
		name = "__iswalpha_l"
		size = 156
	strings:
		$1 = { 7F 30 D0 E3 1F 00 00 0A 00 30 91 E5 68 20 93 E5 02 31 83 E0 2C 30 93 E5 00 20 93 E5 30 22 A0 E1 04 10 93 E5 01 00 52 E1 12 00 00 2A 05 20 82 E2 02 21 93 E7 00 00 52 E3 10 00 00 0A 08 C0 93 E5 0C 10 93 E5 30 1C 01 E0 01 21 82 E0 02 20 93 E7 00 00 52 E3 09 00 00 0A 10 10 93 E5 A0 12 01 E0 01 21 82 E0 02 30 93 E7 1F 00 00 E2 33 00 A0 E1 01 00 00 E2 ?? ?? ?? ?? 00 00 A0 E3 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? 34 30 91 E5 80 00 A0 E1 B0 00 93 E1 01 0B 00 E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_2_0 {
	meta:
		name = "__iswblank_l"
		size = 156
	strings:
		$1 = { 7F 30 D0 E3 1F 00 00 0A 00 30 91 E5 68 20 93 E5 02 31 83 E0 44 30 93 E5 00 20 93 E5 30 22 A0 E1 04 10 93 E5 01 00 52 E1 12 00 00 2A 05 20 82 E2 02 21 93 E7 00 00 52 E3 10 00 00 0A 08 C0 93 E5 0C 10 93 E5 30 1C 01 E0 01 21 82 E0 02 20 93 E7 00 00 52 E3 09 00 00 0A 10 10 93 E5 A0 12 01 E0 01 21 82 E0 02 30 93 E7 1F 00 00 E2 33 00 A0 E1 01 00 00 E2 ?? ?? ?? ?? 00 00 A0 E3 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? 34 30 91 E5 80 00 A0 E1 B0 00 93 E1 01 00 00 E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_3_0 {
	meta:
		name = "__iswcntrl_l"
		size = 156
	strings:
		$1 = { 7F 30 D0 E3 1F 00 00 0A 00 30 91 E5 68 20 93 E5 02 31 83 E0 48 30 93 E5 00 20 93 E5 30 22 A0 E1 04 10 93 E5 01 00 52 E1 12 00 00 2A 05 20 82 E2 02 21 93 E7 00 00 52 E3 10 00 00 0A 08 C0 93 E5 0C 10 93 E5 30 1C 01 E0 01 21 82 E0 02 20 93 E7 00 00 52 E3 09 00 00 0A 10 10 93 E5 A0 12 01 E0 01 21 82 E0 02 30 93 E7 1F 00 00 E2 33 00 A0 E1 01 00 00 E2 ?? ?? ?? ?? 00 00 A0 E3 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? 34 30 91 E5 80 00 A0 E1 B0 00 93 E1 02 00 00 E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_4_0 {
	meta:
		name = "__iswdigit_l"
		size = 156
	strings:
		$1 = { 7F 30 D0 E3 1F 00 00 0A 00 30 91 E5 68 20 93 E5 02 31 83 E0 30 30 93 E5 00 20 93 E5 30 22 A0 E1 04 10 93 E5 01 00 52 E1 12 00 00 2A 05 20 82 E2 02 21 93 E7 00 00 52 E3 10 00 00 0A 08 C0 93 E5 0C 10 93 E5 30 1C 01 E0 01 21 82 E0 02 20 93 E7 00 00 52 E3 09 00 00 0A 10 10 93 E5 A0 12 01 E0 01 21 82 E0 02 30 93 E7 1F 00 00 E2 33 00 A0 E1 01 00 00 E2 ?? ?? ?? ?? 00 00 A0 E3 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? 30 00 40 E2 09 00 50 E3 00 00 A0 83 01 00 A0 93 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_5_0 {
	meta:
		name = "__iswlower_l"
		size = 156
	strings:
		$1 = { 7F 30 D0 E3 1F 00 00 0A 00 30 91 E5 68 20 93 E5 02 31 83 E0 28 30 93 E5 00 20 93 E5 30 22 A0 E1 04 10 93 E5 01 00 52 E1 12 00 00 2A 05 20 82 E2 02 21 93 E7 00 00 52 E3 10 00 00 0A 08 C0 93 E5 0C 10 93 E5 30 1C 01 E0 01 21 82 E0 02 20 93 E7 00 00 52 E3 09 00 00 0A 10 10 93 E5 A0 12 01 E0 01 21 82 E0 02 30 93 E7 1F 00 00 E2 33 00 A0 E1 01 00 00 E2 ?? ?? ?? ?? 00 00 A0 E3 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? 34 30 91 E5 80 00 A0 E1 B0 00 93 E1 02 0C 00 E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_6_0 {
	meta:
		name = "__iswgraph_l"
		size = 156
	strings:
		$1 = { 7F 30 D0 E3 1F 00 00 0A 00 30 91 E5 68 20 93 E5 02 31 83 E0 40 30 93 E5 00 20 93 E5 30 22 A0 E1 04 10 93 E5 01 00 52 E1 12 00 00 2A 05 20 82 E2 02 21 93 E7 00 00 52 E3 10 00 00 0A 08 C0 93 E5 0C 10 93 E5 30 1C 01 E0 01 21 82 E0 02 20 93 E7 00 00 52 E3 09 00 00 0A 10 10 93 E5 A0 12 01 E0 01 21 82 E0 02 30 93 E7 1F 00 00 E2 33 00 A0 E1 01 00 00 E2 ?? ?? ?? ?? 00 00 A0 E3 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? 34 30 91 E5 80 00 A0 E1 B0 00 93 E1 02 09 00 E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_7_0 {
	meta:
		name = "__iswprint_l"
		size = 156
	strings:
		$1 = { 7F 30 D0 E3 1F 00 00 0A 00 30 91 E5 68 20 93 E5 02 31 83 E0 3C 30 93 E5 00 20 93 E5 30 22 A0 E1 04 10 93 E5 01 00 52 E1 12 00 00 2A 05 20 82 E2 02 21 93 E7 00 00 52 E3 10 00 00 0A 08 C0 93 E5 0C 10 93 E5 30 1C 01 E0 01 21 82 E0 02 20 93 E7 00 00 52 E3 09 00 00 0A 10 10 93 E5 A0 12 01 E0 01 21 82 E0 02 30 93 E7 1F 00 00 E2 33 00 A0 E1 01 00 00 E2 ?? ?? ?? ?? 00 00 A0 E3 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? 34 30 91 E5 80 00 A0 E1 B0 00 93 E1 01 09 00 E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_8_0 {
	meta:
		name = "__iswpunct_l"
		size = 156
	strings:
		$1 = { 7F 30 D0 E3 1F 00 00 0A 00 30 91 E5 68 20 93 E5 02 31 83 E0 4C 30 93 E5 00 20 93 E5 30 22 A0 E1 04 10 93 E5 01 00 52 E1 12 00 00 2A 05 20 82 E2 02 21 93 E7 00 00 52 E3 10 00 00 0A 08 C0 93 E5 0C 10 93 E5 30 1C 01 E0 01 21 82 E0 02 20 93 E7 00 00 52 E3 09 00 00 0A 10 10 93 E5 A0 12 01 E0 01 21 82 E0 02 30 93 E7 1F 00 00 E2 33 00 A0 E1 01 00 00 E2 ?? ?? ?? ?? 00 00 A0 E3 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? 34 30 91 E5 80 00 A0 E1 B0 00 93 E1 04 00 00 E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_9_0 {
	meta:
		name = "__iswspace_l"
		size = 156
	strings:
		$1 = { 7F 30 D0 E3 1F 00 00 0A 00 30 91 E5 68 20 93 E5 02 31 83 E0 38 30 93 E5 00 20 93 E5 30 22 A0 E1 04 10 93 E5 01 00 52 E1 12 00 00 2A 05 20 82 E2 02 21 93 E7 00 00 52 E3 10 00 00 0A 08 C0 93 E5 0C 10 93 E5 30 1C 01 E0 01 21 82 E0 02 20 93 E7 00 00 52 E3 09 00 00 0A 10 10 93 E5 A0 12 01 E0 01 21 82 E0 02 30 93 E7 1F 00 00 E2 33 00 A0 E1 01 00 00 E2 ?? ?? ?? ?? 00 00 A0 E3 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? 34 30 91 E5 80 00 A0 E1 B0 00 93 E1 02 0A 00 E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_10_0 {
	meta:
		name = "__iswupper_l"
		size = 156
	strings:
		$1 = { 7F 30 D0 E3 1F 00 00 0A 00 30 91 E5 68 20 93 E5 02 31 83 E0 24 30 93 E5 00 20 93 E5 30 22 A0 E1 04 10 93 E5 01 00 52 E1 12 00 00 2A 05 20 82 E2 02 21 93 E7 00 00 52 E3 10 00 00 0A 08 C0 93 E5 0C 10 93 E5 30 1C 01 E0 01 21 82 E0 02 20 93 E7 00 00 52 E3 09 00 00 0A 10 10 93 E5 A0 12 01 E0 01 21 82 E0 02 30 93 E7 1F 00 00 E2 33 00 A0 E1 01 00 00 E2 ?? ?? ?? ?? 00 00 A0 E3 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? 34 30 91 E5 80 00 A0 E1 B0 00 93 E1 01 0C 00 E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_11_0 {
	meta:
		name = "__iswxdigit_l"
		size = 156
	strings:
		$1 = { 7F 30 D0 E3 1F 00 00 0A 00 30 91 E5 68 20 93 E5 02 31 83 E0 34 30 93 E5 00 20 93 E5 30 22 A0 E1 04 10 93 E5 01 00 52 E1 12 00 00 2A 05 20 82 E2 02 21 93 E7 00 00 52 E3 10 00 00 0A 08 C0 93 E5 0C 10 93 E5 30 1C 01 E0 01 21 82 E0 02 20 93 E7 00 00 52 E3 09 00 00 0A 10 10 93 E5 A0 12 01 E0 01 21 82 E0 02 30 93 E7 1F 00 00 E2 33 00 A0 E1 01 00 00 E2 ?? ?? ?? ?? 00 00 A0 E3 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? 34 30 91 E5 80 00 A0 E1 B0 00 93 E1 01 0A 00 E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_12_0 {
	meta:
		name = "__towlower_l"
		size = 100
	strings:
		$1 = { 00 30 91 E5 6C 20 93 E5 02 31 83 E0 28 30 93 E5 00 20 93 E5 30 22 A0 E1 04 10 93 E5 01 00 52 E1 ?? ?? ?? ?? 05 20 82 E2 02 21 93 E7 00 00 52 E3 ?? ?? ?? ?? 08 C0 93 E5 0C 10 93 E5 30 1C 01 E0 01 21 82 E0 02 20 93 E7 00 00 52 E3 10 10 93 15 01 10 00 10 01 21 82 10 02 30 93 17 03 00 80 10 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_13_0 {
	meta:
		name = "__towupper_l"
		size = 100
	strings:
		$1 = { 00 30 91 E5 6C 20 93 E5 02 31 83 E0 24 30 93 E5 00 20 93 E5 30 22 A0 E1 04 10 93 E5 01 00 52 E1 ?? ?? ?? ?? 05 20 82 E2 02 21 93 E7 00 00 52 E3 ?? ?? ?? ?? 08 C0 93 E5 0C 10 93 E5 30 1C 01 E0 01 21 82 E0 02 20 93 E7 00 00 52 E3 10 10 93 15 01 10 00 10 01 21 82 10 02 30 93 17 03 00 80 10 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "__strnlen"
		size = 260
	strings:
		$1 = { 00 00 51 E3 30 00 2D E9 01 00 A0 01 2E 00 00 0A 01 50 90 E0 00 50 E0 23 03 00 10 E3 32 00 00 0A 00 30 D0 E5 00 00 53 E3 01 30 80 12 04 00 00 1A 2F 00 00 EA 00 10 D2 E5 00 00 51 E3 01 30 83 E2 1E 00 00 0A 03 00 13 E3 03 20 A0 E1 F8 FF FF 1A 02 00 55 E1 19 00 00 9A 04 C0 42 E2 00 00 00 EA 03 20 A0 E1 04 40 BC E5 8C 10 9F E5 8C 30 9F E5 01 10 84 E0 03 30 01 E0 00 00 53 E3 04 30 82 E2 0B 00 00 0A 04 10 53 E5 00 00 51 E3 0B 00 00 0A 01 10 DC E5 00 00 51 E3 0D 00 00 0A 02 10 DC E5 00 00 51 E3 0C 00 00 0A 03 10 DC E5 00 00 51 E3 0B 00 00 0A 03 00 55 E1 E8 FF FF 8A 05 20 A0 E1 05 00 52 E1 02 00 60 90 05 00 60 80 30 00 BD E8 ?? ?? ?? ?? 01 20 82 E2 F8 FF FF EA 02 20 82 E2 F6 FF FF EA 03 20 82 E2 F4 FF FF EA 00 20 A0 E1 D6 FF FF EA 00 20 A0 E1 F0 FF FF EA FF FE FE FE 80 80 80 80 }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "__posix_spawnp"
		size = 44
		refs = "001c __spawni"
	strings:
		$1 = { 10 40 2D E9 10 D0 4D E2 18 40 8D E2 10 40 94 E8 01 C0 A0 E3 10 40 8D E8 08 C0 8D E5 ?? ?? ?? ?? 10 D0 8D E2 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "wait_on_socket"
		size = 268
		refs = "0024 __poll 0048 __aeabi_read_tp 0064 __gettimeofday 0080 __aeabi_idiv 0100 __libc_errno"
	strings:
		$1 = { F0 40 2D E9 14 D0 4D E2 19 30 A0 E3 00 00 8D E5 01 20 A0 E1 01 40 A0 E1 0D 00 A0 E1 01 10 A0 E3 B4 30 CD E1 ?? ?? ?? ?? 01 00 70 E3 00 30 A0 E1 03 00 00 0A 03 00 A0 E1 14 D0 8D E2 F0 40 BD E8 ?? ?? ?? ?? B4 20 9F E5 ?? ?? ?? ?? 02 20 9F E7 02 20 90 E7 04 00 52 E3 F5 FF FF 1A 00 10 A0 E3 08 00 8D E2 ?? ?? ?? ?? 0C 00 9D E5 FA 3F A0 E3 08 50 9D E5 7D 0F 80 E2 03 10 A0 E1 93 45 25 E0 ?? ?? ?? ?? 78 70 9F E5 78 60 9F E5 00 50 85 E0 12 00 00 EA ?? ?? ?? ?? 07 20 9F E7 02 20 90 E7 04 00 52 E3 E2 FF FF 1A 00 10 A0 E3 08 00 8D E2 ?? ?? ?? ?? 0C 20 9D E5 7D 2F 82 E2 96 32 C0 E0 08 30 9D E5 03 1B 63 E0 C2 2F A0 E1 01 13 83 E0 40 23 42 E0 81 30 83 E0 83 41 82 E0 05 40 84 E0 04 20 A0 E1 0D 00 A0 E1 01 10 A0 E3 ?? ?? ?? ?? 01 00 70 E3 00 30 A0 E1 E5 FF FF 0A CC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? D3 4D 62 10 }
	condition:
		$1
}

rule file_64_1_0 {
	meta:
		name = "open_socket"
		size = 608
		refs = "0034 __socket 0098 memcpy 00a8 __connect 00e8 __send 013c __aeabi_read_tp 0190 __gettimeofday 01c8 __poll 0208 __fcntl 0234 __aeabi_idiv 0240 __have_sock_cloexec 024c __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 34 42 9F E5 20 B0 8D E2 8C D0 4D E2 00 30 94 E5 00 00 53 E3 00 70 A0 E1 01 90 A0 E1 02 A0 A0 E1 3D 00 00 BA 00 20 A0 E3 01 00 A0 E3 0C 12 9F E5 ?? ?? ?? ?? 00 20 94 E5 00 00 52 E3 00 50 A0 E1 30 00 00 0A 00 00 52 E3 33 00 00 BA 00 00 55 E3 6D 00 00 BA 0F 20 8A E2 03 20 C2 E3 00 10 94 E5 0A 20 82 E2 07 20 C2 E3 02 D0 4D E0 00 00 51 E3 0D 40 A0 E1 0C 60 8A E2 5E 00 00 BA 01 20 A0 E3 24 80 4B E2 B0 27 68 E1 B4 11 9F E5 15 20 A0 E3 92 00 4B E2 ?? ?? ?? ?? 05 00 A0 E1 08 10 A0 E1 6E 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 20 00 00 BA 02 C0 A0 E3 8C 81 9F E5 09 10 A0 E1 0A 20 A0 E1 0C 00 84 E2 80 04 84 E9 00 C0 84 E5 01 90 A0 E3 ?? ?? ?? ?? 05 00 A0 E1 04 10 A0 E1 06 20 A0 E1 01 39 A0 E3 ?? ?? ?? ?? 01 00 70 E3 1B 00 00 0A 06 00 50 E1 14 00 00 1A 05 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 01 00 70 E3 01 20 A0 13 30 00 00 0A 00 20 84 E5 C9 FF FF EA 01 00 A0 E3 00 10 A0 E1 00 20 A0 E3 ?? ?? ?? ?? 00 50 A0 E1 C5 FF FF EA 10 21 9F E5 ?? ?? ?? ?? 02 20 9F E7 02 20 90 E7 73 00 52 E3 D8 FF FF 0A 05 00 A0 E1 06 70 A0 E3 00 00 00 EF 00 00 E0 E3 E6 FF FF EA ?? ?? ?? ?? 08 30 9F E7 03 30 90 E7 04 00 53 E3 D7 FF FF 0A 01 00 76 E3 DE FF FF 0A 0B 00 53 E3 F1 FF FF 1A A4 00 4B E2 00 10 A0 E3 ?? ?? ?? ?? 00 00 59 E3 1E 00 00 0A A4 20 4B E2 0C 00 92 E8 05 20 82 E2 AC 20 0B E5 A8 30 0B E5 9C 20 9F E5 1C 30 A0 E3 9C 00 4B E2 01 10 A0 E3 9C 50 0B E5 B8 39 4B E1 ?? ?? ?? ?? 00 00 50 E3 DE FF FF DA 00 90 A0 E3 BE FF FF EA 74 20 9F E5 ?? ?? ?? ?? 02 20 9F E7 02 20 90 E7 16 00 52 E3 00 20 E0 03 01 20 A0 13 C6 FF FF EA 05 00 A0 E1 04 10 A0 E3 50 20 9F E5 ?? ?? ?? ?? 9B FF FF EA 00 00 E0 E3 B9 FF FF EA A8 00 4B E2 0D 00 90 E8 AC 70 1B E5 FA 1F A0 E3 07 70 62 E0 00 00 63 E0 91 07 07 E0 ?? ?? ?? ?? 00 20 87 E0 DC FF FF EA ?? ?? ?? ?? 01 08 08 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 88 13 00 00 ?? ?? ?? ?? 02 08 00 00 }
	condition:
		$1
}

rule file_64_2_0 {
	meta:
		name = "__readall"
		size = 176
		refs = "0028 __read 0058 __aeabi_read_tp 00a8 __libc_errno"
	strings:
		$1 = { F0 47 2D E9 9C A0 9F E5 9C 90 9F E5 02 80 A0 E1 00 70 A0 E1 01 60 A0 E1 02 50 A0 E1 07 00 A0 E1 06 10 A0 E1 05 20 A0 E1 ?? ?? ?? ?? 01 00 70 E3 00 40 A0 E1 07 00 00 0A 00 00 50 E3 0E 00 00 DA 00 50 55 E0 00 60 86 E0 F3 FF FF 1A 08 00 65 E0 F0 47 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 09 30 9F E7 03 30 90 E7 04 00 53 E3 EB FF FF 0A 0B 00 53 E3 06 00 00 0A 04 00 A0 E1 F4 FF FF EA F2 FF FF 0A 0A 30 9F E7 ?? ?? ?? ?? 03 30 90 E7 F6 FF FF EA 07 00 A0 E1 C8 10 A0 E3 FD FE FF EB 00 00 50 E3 DD FF FF CA F2 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_3_0 {
	meta:
		name = "__readvall"
		size = 464
		refs = "0020 __aeabi_read_tp 0040 __readv 00b8 memcpy 01c0 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 0C D0 4D E2 AC 81 9F E5 00 70 A0 E1 01 50 A0 E1 02 60 A0 E1 04 00 00 EA ?? ?? ?? ?? 08 30 9F E7 03 30 90 E7 04 00 53 E3 51 00 00 1A 07 00 A0 E1 05 10 A0 E1 06 20 A0 E1 ?? ?? ?? ?? 01 00 70 E3 00 40 A0 E1 F3 FF FF 0A 00 00 50 E3 43 00 00 DA 00 00 56 E3 0A 00 00 DA 00 30 A0 E3 03 80 A0 E1 86 11 A0 E1 03 20 85 E0 04 20 92 E5 08 30 83 E2 01 00 53 E1 02 80 88 E0 F9 FF FF 1A 08 00 54 E1 03 00 00 3A 04 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 0A 20 83 E2 07 20 C2 E3 0D 90 A0 E1 02 D0 4D E0 05 10 A0 E1 03 20 A0 E1 0D 00 A0 E1 ?? ?? ?? ?? 00 51 9F E5 00 A0 A0 E1 04 20 A0 E1 04 10 9A E5 02 00 51 E1 13 00 00 9A 00 00 9A E5 01 10 62 E0 02 20 80 E0 04 10 8A E5 00 20 8A E5 06 20 A0 E1 07 00 A0 E1 0A 10 A0 E1 ?? ?? ?? ?? 01 00 70 E3 00 20 A0 E1 0B 00 00 0A 00 00 50 E3 12 00 00 CA 1E 00 00 1A 04 00 A0 E1 09 D0 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 02 20 61 E0 01 60 46 E2 08 A0 8A E2 E4 FF FF EA ?? ?? ?? ?? 05 10 9F E7 01 10 90 E7 04 00 51 E3 E7 FF FF 0A 0B 00 51 E3 13 00 00 0A 02 40 A0 E1 ED FF FF EA 00 40 84 E0 08 00 54 E1 D8 FF FF 3A E9 FF FF EA C7 FF FF 0A 54 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 0B 00 53 E3 C1 FF FF 1A 00 40 A0 E3 B2 FF FF EA 38 30 9F E5 ?? ?? ?? ?? 03 10 9F E7 01 10 90 E7 E9 FF FF EA 07 00 A0 E1 C8 10 A0 E3 28 20 0B E5 8C FE FF EB 00 00 50 E3 28 20 1B E5 CA FF FF CA E3 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_4_0 {
	meta:
		name = "__nscd_unmap"
		size = 80
		refs = "001c __munmap 0024 free 0040 __assert_fail"
	strings:
		$1 = { 0C 30 90 E5 00 00 53 E3 10 40 2D E9 00 40 A0 E1 06 00 00 1A 08 10 94 E5 00 00 90 E5 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 10 40 BD E8 ?? ?? ?? ?? 0C 00 9F E5 0C 10 9F E5 11 2E A0 E3 08 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_5_0 {
	meta:
		name = "__nscd_get_mapping"
		size = 892
		refs = "001c strlen 0030 __aeabi_read_tp 00e4 __close 0184 __recvmsg 01cc strcmp 01e4 __fxstat64 0214 __nscd_unmap 0230 __munmap 027c __mmap 0308 malloc 0344 time 036c __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 D4 D0 4D E2 00 40 A0 E1 01 00 A0 E1 01 50 A0 E1 02 A0 A0 E1 ?? ?? ?? ?? 44 33 9F E5 00 80 A0 E1 03 30 9F E7 08 20 80 E2 ?? ?? ?? ?? 03 30 90 E7 07 20 C2 E3 01 70 88 E2 02 D0 4D E0 04 00 A0 E1 07 20 A0 E1 05 10 A0 E1 D8 30 0B E5 9D FE FF EB 00 60 50 E2 08 90 8D E2 00 80 E0 B3 1F 00 00 BA 00 10 A0 E3 D4 30 4B E2 08 C0 A0 E3 C8 E0 4B E2 10 20 A0 E3 02 40 A0 E3 C0 30 0B E5 BC C0 0B E5 01 30 A0 E3 00 C0 E0 E3 A8 10 0B E5 A4 10 0B E5 90 10 0B E5 A0 E0 0B E5 C8 12 9F E5 B8 E0 4B E2 9C 40 0B E5 C8 90 0B E5 C4 70 0B E5 98 E0 0B E5 94 20 0B E5 B8 20 0B E5 B4 30 0B E5 B0 30 0B E5 AC C0 0B E5 3C FE FF EB 00 00 50 E3 98 42 9F C5 26 00 00 CA 00 80 E0 E3 06 00 A0 E1 ?? ?? ?? ?? 00 60 9A E5 84 32 9F E5 D8 10 1B E5 03 30 9F E7 ?? ?? ?? ?? 00 00 56 E3 03 10 80 E7 00 80 8A E5 11 00 00 0A 0C 70 86 E2 0C 50 96 E5 07 20 A0 E1 01 10 45 E2 05 40 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 2E 00 00 0A 08 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 04 20 9F E7 02 20 90 E7 04 00 52 E3 06 00 00 1A 06 00 A0 E1 A8 10 4B E2 01 21 A0 E3 ?? ?? ?? ?? 01 00 70 E3 00 30 A0 E1 F3 FF FF 0A 94 20 1B E5 0B 00 52 E3 CE FF FF 9A 98 20 1B E5 00 00 52 E3 CB FF FF 0A 00 20 92 E5 10 00 52 E3 C8 FF FF 1A 03 00 57 E1 AC 70 1B E5 1F 00 00 1A 09 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 16 00 00 1A 03 00 A0 E3 07 10 A0 E1 8C 20 4B E2 ?? ?? ?? ?? 00 00 50 E3 10 00 00 1A 5C 30 4B E2 0C 00 93 E8 78 00 52 E3 00 00 D3 E2 0B 00 00 BA D4 20 0B E5 D0 30 0B E5 14 00 00 EA 06 00 A0 E1 ?? ?? ?? ?? 08 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? E4 10 1B E5 09 00 A0 E1 ?? ?? ?? ?? 00 80 E0 E3 07 00 A0 E1 ?? ?? ?? ?? A6 FF FF EA 09 80 88 E2 08 00 53 E1 F8 FF FF 1A 09 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F3 FF FF 1A 00 00 A0 E3 01 20 A0 E3 D4 10 1B E5 00 70 8D E5 04 00 8D E5 02 30 A0 E1 ?? ?? ?? ?? 01 00 70 E3 00 90 A0 E1 E9 FF FF 0A 00 30 90 E5 02 00 53 E3 32 00 00 1A 04 30 90 E5 78 00 53 E3 2F 00 00 1A 28 30 90 E5 00 00 53 E3 2C 00 00 0A 0C 00 90 E5 00 00 50 E3 1F 00 00 0A 03 31 A0 E1 2C 40 99 E5 0F C0 83 E2 78 10 84 E2 0F C0 CC E3 0C 50 81 E0 D4 20 4B E2 06 00 92 E8 E4 10 0B E5 E0 20 0B E5 E4 10 4B E2 03 00 91 E8 05 20 A0 E1 00 30 A0 E3 01 00 53 E1 00 00 52 01 C9 FF FF 8A 14 00 A0 E3 E8 C0 0B E5 ?? ?? ?? ?? 00 80 50 E2 E8 C0 1B E5 C3 FF FF 0A 04 30 99 E5 03 C0 8C E0 0C C0 89 E0 01 30 A0 E3 00 12 88 E8 08 50 88 E5 10 40 88 E5 0C 30 88 E5 BE FF FF EA 10 50 89 E2 30 00 95 E8 ?? ?? ?? ?? 4B 4F 94 E2 00 50 A5 E2 C0 1F A0 E1 01 00 55 E1 00 00 54 01 28 30 99 25 D5 FF FF 2A D4 10 1B E5 AF FF FF EA ?? ?? ?? ?? 88 13 00 00 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_6_0 {
	meta:
		name = "__nscd_get_map_ref"
		size = 364
		refs = "010c __nscd_get_mapping 0148 time"
	strings:
		$1 = { F0 47 2D E9 02 70 A0 E1 04 20 92 E5 01 00 72 E3 08 D0 4D E2 00 90 A0 E1 01 A0 A0 E1 03 80 A0 E1 06 50 A0 13 41 00 00 0A 01 10 A0 E3 07 20 A0 E1 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 04 30 8D E5 04 30 9D E5 00 00 53 E3 2F 00 00 1A 04 60 97 E5 01 00 76 E3 2A 00 00 0A 00 00 56 E3 20 00 00 0A 00 30 96 E5 0C 00 93 E5 00 00 50 E3 2C 00 00 0A 2C 10 93 E5 10 20 96 E5 02 00 51 E1 18 00 00 8A 08 30 93 E5 01 00 13 E3 00 30 88 E5 1C 00 00 1A 0C 50 86 E2 0C 40 96 E5 05 20 A0 E1 01 10 84 E2 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 54 E1 F1 FF FF 1A 00 30 A0 E3 06 00 A0 E1 00 30 87 E5 08 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 09 00 A0 E1 0A 10 A0 E1 04 20 87 E2 ?? ?? ?? ?? 01 00 70 E3 00 60 A0 E1 00 30 90 15 DE FF FF 1A 00 60 E0 E3 EF FF FF EA 01 50 55 E2 BD FF FF 1A 00 00 E0 E3 08 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 10 50 83 E2 30 00 95 E8 ?? ?? ?? ?? 4B 4F 94 E2 00 50 A5 E2 C0 1F A0 E1 01 00 55 E1 00 00 54 01 E6 FF FF 3A 00 30 96 E5 C7 FF FF EA }
	condition:
		$1
}

rule file_64_7_0 {
	meta:
		name = "__nscd_cache_search"
		size = 404
		refs = "0020 __nis_hash 002c __aeabi_uidivmod 0118 memcmp"
	strings:
		$1 = { F0 4F 2D E9 03 50 A0 E1 0C D0 4D E2 01 A0 A0 E1 00 90 A0 E1 01 00 A0 E1 02 10 A0 E1 02 B0 A0 E1 ?? ?? ?? ?? 00 40 95 E5 28 10 94 E5 ?? ?? ?? ?? 58 61 9F E5 10 70 95 E5 97 26 86 E0 1E 10 81 E2 01 41 94 E7 01 00 74 E3 A6 62 A0 E1 4B 00 00 0A 1C 30 84 E2 03 00 57 E1 48 00 00 3A 04 80 95 E5 04 30 88 E0 03 50 13 E2 44 00 00 1A 30 20 9D E5 01 60 46 E2 18 C0 82 E2 17 00 00 EA 10 30 93 E5 03 00 54 E1 3D 00 00 0A 01 00 76 E3 3B 00 00 0A 00 00 55 E3 06 00 00 0A 04 20 88 E0 03 00 12 E2 36 00 00 1A 1C 40 84 E2 04 00 57 E1 30 00 00 3A 10 40 92 E5 01 00 73 E3 01 50 65 E2 2F 00 00 0A 1C 20 83 E2 02 00 57 E1 2C 00 00 3A 03 30 88 E0 03 00 13 E3 01 60 46 E2 28 00 00 1A 00 20 D3 E5 09 00 52 E1 E4 FF FF 1A 04 20 93 E5 0B 00 52 E1 E1 FF FF 1A 08 10 93 E5 0B 20 81 E0 02 00 57 E1 DD FF FF 3A 01 10 88 E0 0A 00 A0 E1 0B 20 A0 E1 04 30 8D E5 00 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 04 30 9D E5 00 C0 9D E5 D3 FF FF 1A 14 20 93 E5 18 10 82 E2 01 00 57 E1 CF FF FF 3A 02 10 88 E0 07 00 11 E3 0A 00 00 1A 12 00 D1 E5 00 00 50 E3 C9 FF FF 0A 02 00 98 E7 00 00 82 E0 00 00 57 E1 C5 FF FF 3A 02 20 8C E0 02 00 57 E1 C2 FF FF 3A 01 00 A0 E1 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 00 A0 E3 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? CD CC CC CC }
	condition:
		$1
}

rule file_64_8_0 {
	meta:
		name = "__nscd_open_socket"
		size = 224
		refs = "0024 __aeabi_read_tp 007c __read 00d0 __libc_errno"
	strings:
		$1 = { F0 47 2D E9 01 0B 51 E3 01 40 A0 E1 02 50 A0 E1 00 10 A0 E1 03 80 A0 E1 20 60 9D E5 29 00 00 8A A8 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 90 90 E7 04 20 A0 E1 05 00 A0 E1 05 FD FF EB 00 70 50 E2 19 00 00 BA 88 10 9F E5 BE FC FF EB 00 00 50 E3 80 A0 9F C5 05 00 00 CA 10 00 00 EA ?? ?? ?? ?? 0A 50 9F E7 05 C0 90 E7 04 00 5C E3 06 00 00 1A 07 00 A0 E1 08 10 A0 E1 06 20 A0 E1 ?? ?? ?? ?? 01 00 70 E3 00 40 A0 E1 F3 FF FF 0A 06 00 54 E1 07 00 A0 01 01 00 00 1A F0 47 BD E8 ?? ?? ?? ?? 07 00 A0 E1 06 70 A0 E3 00 00 00 EF 28 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 90 80 E7 00 00 E0 E3 F0 47 BD E8 ?? ?? ?? ?? 00 00 E0 E3 F1 FF FF EA ?? ?? ?? ?? 88 13 00 00 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "convert_and_print"
		size = 248
		refs = "0018 strlen 0068 realloc 0094 __mbsrtowcs 00b8 __vfwprintf 00d4 fputws_unlocked 00ec stderr"
	strings:
		$1 = { F0 4F 2D E9 00 70 50 E2 20 B0 8D E2 1C D0 4D E2 38 10 0B E5 28 00 00 0A ?? ?? ?? ?? 01 40 80 E2 04 51 A0 E1 0E 90 85 E2 B4 60 9F E5 B4 80 9F E5 07 90 C9 E3 00 A0 A0 E3 06 00 54 E1 09 D0 4D 90 05 10 A0 E1 0D A0 A0 91 09 00 00 9A 00 00 9A E2 01 00 A0 13 08 00 54 E1 00 00 A0 83 00 00 50 E3 0A 00 A0 01 00 00 A0 13 ?? ?? ?? ?? 00 A0 50 E2 14 00 00 0A 24 10 4B E2 00 E0 A0 E3 0C 70 21 E5 0A 00 A0 E1 04 20 A0 E1 2C 30 4B E2 2C E0 0B E5 28 E0 0B E5 ?? ?? ?? ?? 00 00 54 E1 E5 FF FF 0A 44 30 9F E5 01 00 70 E3 40 10 9F E5 38 20 1B E5 0A 10 A0 11 00 00 93 E5 ?? ?? ?? ?? 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 1C 30 9F E5 20 00 9F E5 00 10 93 E5 ?? ?? ?? ?? 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? CF 07 00 00 9F 0F 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_1_0 {
	meta:
		name = "vwarnx"
		size = 176
		refs = "0030 __fwprintf 0048 putwc_unlocked 0058 fprintf 006c vfprintf 0098 __overflow 00a0 stderr 00a4 __progname"
	strings:
		$1 = { 70 40 2D E9 94 40 9F E5 00 30 94 E5 6C 20 93 E5 00 00 52 E3 88 20 9F E5 00 50 A0 E1 01 60 A0 E1 03 00 A0 E1 00 20 92 E5 09 00 00 DA 74 10 9F E5 ?? ?? ?? ?? 05 00 A0 E1 06 10 A0 E1 B1 FF FF EB 00 10 94 E5 0A 00 A0 E3 ?? ?? ?? ?? 70 40 BD E8 ?? ?? ?? ?? 50 10 9F E5 ?? ?? ?? ?? 00 00 55 E3 05 10 A0 11 06 20 A0 11 00 00 94 15 ?? ?? ?? ?? 00 00 94 E5 14 30 90 E5 18 20 90 E5 02 00 53 E1 01 10 83 32 0A 20 A0 33 14 10 80 35 00 20 C3 35 ED FF FF 3A 0A 10 A0 E3 ?? ?? ?? ?? EA FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_2_0 {
	meta:
		name = "vwarn"
		size = 268
		refs = "001c __aeabi_read_tp 0040 __fwprintf 0060 fputws_unlocked 008c fprintf 00a4 vfprintf 00b8 fwrite_unlocked 00e0 stderr 00e4 __libc_errno 00e8 __progname"
	strings:
		$1 = { F0 41 2D E9 D4 40 9F E5 D4 30 9F E5 00 50 94 E5 03 30 9F E7 6C 20 95 E5 00 60 A0 E1 ?? ?? ?? ?? 03 70 90 E7 BC 30 9F E5 00 00 52 E3 01 80 A0 E1 05 00 A0 E1 00 20 93 E5 12 00 00 DA A8 10 9F E5 ?? ?? ?? ?? 00 00 56 E3 05 00 00 0A 06 00 A0 E1 08 10 A0 E1 7F FF FF EB 90 00 9F E5 00 10 94 E5 ?? ?? ?? ?? 88 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 70 80 E7 7C 10 9F E5 00 00 94 E5 ?? ?? ?? ?? F0 41 BD E8 ?? ?? ?? ?? 6C 10 9F E5 ?? ?? ?? ?? 00 00 56 E3 08 00 00 0A 06 10 A0 E1 08 20 A0 E1 00 00 94 E5 ?? ?? ?? ?? 50 00 9F E5 01 10 A0 E3 02 20 A0 E3 00 30 94 E5 ?? ?? ?? ?? 40 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 70 80 E7 34 10 9F E5 00 00 94 E5 ?? ?? ?? ?? F0 41 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_3_0 {
	meta:
		name = "warn"
		size = 48
		refs = "001c vwarn"
		altNames = "warnx"
	strings:
		$1 = { 0F 00 2D E9 04 E0 2D E5 0C D0 4D E2 14 30 8D E2 03 10 A0 E1 10 00 9D E5 04 30 8D E5 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 10 D0 8D E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_5_0 {
	meta:
		name = "verr"
		size = 28
		refs = "0010 vwarn 0018 exit"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 01 00 A0 E1 02 10 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_86_4 {
	meta:
		name = "_ZNSbIwSt11char_traitsIwESaIwEEC2EjwRKS1_"
		size = 40
		refs = "0014 _ZNSbIwSt11char_traitsIwESaIwEE12_S_constructEjwRKS1_"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 01 00 A0 E1 02 10 A0 E1 03 20 A0 E1 ?? ?? ?? ?? 00 00 84 E5 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_56_85_4 {
	meta:
		name = "_ZNSsC2EjcRKSaIcE"
		size = 40
		refs = "0014 _ZNSs12_S_constructEjcRKSaIcE"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 01 00 A0 E1 02 10 A0 E1 03 20 A0 E1 ?? ?? ?? ?? 00 00 84 E5 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_6_0 {
	meta:
		name = "verrx"
		size = 28
		refs = "0010 vwarnx 0018 exit"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 01 00 A0 E1 02 10 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_7_0 {
	meta:
		name = "err"
		size = 32
		refs = "001c verr"
		altNames = "errx"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 08 D0 4D E2 10 30 8D E2 03 20 A0 E1 0C 10 9D E5 04 30 8D E5 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_202_3_0 {
	meta:
		name = "_IO_obstack_printf"
		size = 48
		refs = "001c _IO_obstack_vprintf"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 08 D0 4D E2 10 30 8D E2 03 20 A0 E1 0C 10 9D E5 04 30 8D E5 ?? ?? ?? ?? 08 D0 8D E2 04 E0 9D E4 0C D0 8D E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1406_0_0 {
	meta:
		name = "___asprintf"
		size = 48
		refs = "001c _IO_vasprintf"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 08 D0 4D E2 10 30 8D E2 03 20 A0 E1 0C 10 9D E5 04 30 8D E5 ?? ?? ?? ?? 08 D0 8D E2 04 E0 9D E4 0C D0 8D E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1267_0_0 {
	meta:
		name = "__dprintf"
		size = 48
		refs = "001c _IO_vdprintf"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 08 D0 4D E2 10 30 8D E2 03 20 A0 E1 0C 10 9D E5 04 30 8D E5 ?? ?? ?? ?? 08 D0 8D E2 04 E0 9D E4 0C D0 8D E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_884_0_0 {
	meta:
		name = "__fprintf"
		size = 48
		refs = "001c vfprintf"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 08 D0 4D E2 10 30 8D E2 03 20 A0 E1 0C 10 9D E5 04 30 8D E5 ?? ?? ?? ?? 08 D0 8D E2 04 E0 9D E4 0C D0 8D E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1280_0_0 {
	meta:
		name = "__fscanf"
		size = 48
		refs = "001c __vfscanf"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 08 D0 4D E2 10 30 8D E2 03 20 A0 E1 0C 10 9D E5 04 30 8D E5 ?? ?? ?? ?? 08 D0 8D E2 04 E0 9D E4 0C D0 8D E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_869_0_0 {
	meta:
		name = "__fwprintf"
		size = 48
		refs = "001c __vfwprintf"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 08 D0 4D E2 10 30 8D E2 03 20 A0 E1 0C 10 9D E5 04 30 8D E5 ?? ?? ?? ?? 08 D0 8D E2 04 E0 9D E4 0C D0 8D E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_896_0_0 {
	meta:
		name = "__fwscanf"
		size = 48
		refs = "001c __vfwscanf"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 08 D0 4D E2 10 30 8D E2 03 20 A0 E1 0C 10 9D E5 04 30 8D E5 ?? ?? ?? ?? 08 D0 8D E2 04 E0 9D E4 0C D0 8D E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_552_0_0 {
	meta:
		name = "__isoc99_sscanf"
		size = 48
		refs = "001c __isoc99_vsscanf"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 08 D0 4D E2 10 30 8D E2 03 20 A0 E1 0C 10 9D E5 04 30 8D E5 ?? ?? ?? ?? 08 D0 8D E2 04 E0 9D E4 0C D0 8D E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1067_0_0 {
	meta:
		name = "__isoc99_swscanf"
		size = 48
		refs = "001c __isoc99_vswscanf"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 08 D0 4D E2 10 30 8D E2 03 20 A0 E1 0C 10 9D E5 04 30 8D E5 ?? ?? ?? ?? 08 D0 8D E2 04 E0 9D E4 0C D0 8D E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_626_0_0 {
	meta:
		name = "__sprintf"
		size = 48
		refs = "001c _IO_vsprintf"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 08 D0 4D E2 10 30 8D E2 03 20 A0 E1 0C 10 9D E5 04 30 8D E5 ?? ?? ?? ?? 08 D0 8D E2 04 E0 9D E4 0C D0 8D E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_348_0_0 {
	meta:
		name = "__sscanf"
		size = 48
		refs = "001c _IO_vsscanf"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 08 D0 4D E2 10 30 8D E2 03 20 A0 E1 0C 10 9D E5 04 30 8D E5 ?? ?? ?? ?? 08 D0 8D E2 04 E0 9D E4 0C D0 8D E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_868_0_0 {
	meta:
		name = "__swscanf"
		size = 48
		refs = "001c vswscanf"
	strings:
		$1 = { 0E 00 2D E9 04 E0 2D E5 08 D0 4D E2 10 30 8D E2 03 20 A0 E1 0C 10 9D E5 04 30 8D E5 ?? ?? ?? ?? 08 D0 8D E2 04 E0 9D E4 0C D0 8D E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "__scandir64"
		size = 52
		refs = "0024 scandirat64"
		altNames = "scandir"
	strings:
		$1 = { 04 E0 2D E5 02 C0 A0 E1 01 E0 A0 E1 0C D0 4D E2 00 10 A0 E1 00 30 8D E5 0E 20 A0 E1 0C 30 A0 E1 63 00 E0 E3 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_0_0 {
	meta:
		name = "ether_ntohost"
		size = 284
		refs = "0054 __aeabi_read_tp 0090 __nss_next2 00c0 strcpy 00ec __nss_ethers_lookup 0114 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 04 41 9F E5 00 30 94 E5 42 DE 4D E2 00 00 53 E3 04 D0 4D E2 00 A0 A0 E1 01 60 A0 E1 2C 00 00 0A 04 B0 94 E5 01 00 73 E3 10 B0 8D E5 0C 30 8D E5 10 50 8D 12 0C 70 8D 12 18 00 00 0A CC 90 9F E5 00 80 A0 E3 00 00 00 EA 10 B0 9D E5 09 40 9F E7 ?? ?? ?? ?? 04 00 80 E0 00 00 8D E5 14 10 8D E2 20 20 8D E2 01 3B A0 E3 06 00 A0 E1 0F E0 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 10 01 8D E8 07 00 A0 E1 8C 10 9F E5 00 20 A0 E3 05 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 EB FF FF 0A 01 00 54 E3 04 00 00 0A 00 00 E0 E3 42 DE 8D E2 04 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 0A 00 A0 E1 14 10 9D E5 ?? ?? ?? ?? 00 00 A0 E3 42 DE 8D E2 04 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 10 50 8D E2 04 70 45 E2 07 00 A0 E1 05 20 A0 E1 28 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 00 30 E0 13 00 30 84 15 E8 FF FF 1A 0C 30 8D E2 08 08 93 E8 08 08 84 E8 CB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_0_0 {
	meta:
		name = "clnttcp_geterr"
		size = 24
	strings:
		$1 = { 08 20 90 E5 24 20 82 E2 01 30 A0 E1 07 00 92 E8 07 00 83 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_1_0 {
	meta:
		name = "clnttcp_freeres"
		size = 40
	strings:
		$1 = { 08 40 2D E9 08 00 90 E5 02 30 A0 E3 4C 30 A0 E5 01 30 A0 E1 02 10 A0 E1 0F E0 A0 E1 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_3_0 {
	meta:
		name = "clnttcp_destroy"
		size = 84
		refs = "0034 free 004c __close"
	strings:
		$1 = { 38 40 2D E9 08 40 90 E5 04 30 94 E5 00 00 53 E3 00 50 A0 E1 0B 00 00 1A 50 30 94 E5 1C 30 93 E5 00 00 53 E3 4C 00 84 12 0F E0 A0 11 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? 38 40 BD E8 ?? ?? ?? ?? 00 00 94 E5 ?? ?? ?? ?? F0 FF FF EA }
	condition:
		$1
}

rule file_69_4_0 {
	meta:
		name = "clnttcp_control"
		size = 516
		refs = "0068 memcpy"
	strings:
		$1 = { 30 40 2D E9 01 10 41 E2 0C D0 4D E2 02 40 A0 E1 08 50 90 E5 0E 00 51 E3 01 F1 9F 97 76 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 02 10 A0 E1 0D 00 A0 E1 04 20 A0 E3 ?? ?? ?? ?? 00 20 9D E5 62 38 22 E0 23 34 A0 E1 FF 3C C3 E3 62 34 23 E0 08 10 8D E2 04 30 21 E5 3C 00 85 E2 04 20 A0 E3 ?? ?? ?? ?? 01 C0 A0 E3 0C 00 A0 E1 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? 03 00 92 E8 01 30 A0 E3 08 20 85 E2 03 00 82 E8 03 C0 A0 E1 10 30 85 E5 F4 FF FF EA 08 50 85 E2 03 00 95 E8 01 C0 A0 E3 03 00 82 E8 EF FF FF EA 14 50 85 E2 0F 00 95 E8 01 C0 A0 E3 0F 00 84 E8 EA FF FF EA 00 30 95 E5 01 C0 A0 E3 00 30 82 E5 E6 FF FF EA 01 C0 A0 E3 04 C0 85 E5 E3 FF FF EA 00 30 A0 E3 04 30 85 E5 01 C0 A0 E3 DF FF FF EA 30 10 85 E2 04 00 8D E2 04 20 A0 E3 ?? ?? ?? ?? 04 20 9D E5 62 38 22 E0 23 34 A0 E1 FF 3C C3 E3 62 34 23 E0 08 10 8D E2 08 30 21 E5 04 00 A0 E1 0D 10 A0 E1 04 20 A0 E3 ?? ?? ?? ?? 01 C0 A0 E3 0C 00 A0 E1 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? 02 10 A0 E1 0D 00 A0 E1 04 20 A0 E3 ?? ?? ?? ?? 00 20 9D E5 01 20 42 E2 62 38 22 E0 23 34 A0 E1 FF 3C C3 E3 62 34 23 E0 08 10 8D E2 04 30 21 E5 30 00 85 E2 04 20 A0 E3 ?? ?? ?? ?? 01 C0 A0 E3 BA FF FF EA 40 10 85 E2 D9 FF FF EA 02 10 A0 E1 0D 00 A0 E1 04 20 A0 E3 ?? ?? ?? ?? 00 20 9D E5 62 38 22 E0 23 34 A0 E1 FF 3C C3 E3 62 34 23 E0 08 10 8D E2 04 30 21 E5 40 00 85 E2 04 20 A0 E3 ?? ?? ?? ?? 01 C0 A0 E3 A8 FF FF EA 3C 10 85 E2 C7 FF FF EA 00 C0 A0 E3 A4 FF FF EA }
	condition:
		$1
}

rule file_69_5_0 {
	meta:
		name = "clnttcp_call"
		size = 752
		refs = "0114 xdrrec_endofrecord 0158 xdrrec_skiprecord 016c xdr_replymsg 01a4 _seterr_reply 02ac xdr_opaque_auth 02e8 _null_auth 02ec xdr_void"
	strings:
		$1 = { F0 4F 2D E9 08 40 90 E5 00 A0 A0 E1 10 00 94 E5 4C D0 4D E2 00 00 50 E3 0C 30 8D E5 78 30 8D 02 14 10 8D E5 03 00 93 08 08 30 84 02 03 00 83 08 70 30 9D E5 00 00 53 E3 08 20 8D E5 4C 50 84 E2 70 00 00 0A 01 30 A0 E3 00 30 8D E5 30 30 84 E2 04 30 8D E5 03 30 A0 E3 88 62 9F E5 88 92 9F E5 10 30 8D E5 00 80 A0 E3 30 B0 94 E5 01 B0 4B E2 6B 38 2B E0 23 34 A0 E1 30 B0 84 E5 FF 3C C3 E3 4C 80 84 E5 24 80 84 E5 50 C0 94 E5 05 00 A0 E1 04 10 9D E5 48 20 94 E5 6B B4 23 E0 0C C0 9C E5 0F E0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 5D 00 00 0A 50 30 94 E5 05 00 A0 E1 14 10 8D E2 04 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 55 00 00 0A 00 00 9A E5 05 10 A0 E1 20 30 90 E5 04 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 4D 00 00 0A 05 00 A0 E1 0C 10 9D E5 08 30 9D E5 0F E0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 46 00 00 0A 05 00 A0 E1 00 10 9D E5 ?? ?? ?? ?? 00 00 50 E3 4A 00 00 0A 00 30 9D E5 00 00 53 E3 4A 00 00 0A 08 30 94 E5 00 00 53 E3 2D 00 00 0A 01 30 A0 E3 4C 30 84 E5 24 70 8D E2 07 00 96 E8 07 00 87 E8 05 00 A0 E1 34 80 8D E5 38 90 8D E5 ?? ?? ?? ?? 00 00 50 E3 18 10 8D E2 05 00 A0 E1 1C 00 00 0A ?? ?? ?? ?? 00 00 50 E3 05 00 00 1A 24 00 94 E5 00 00 50 E3 EF FF FF 0A 4C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 18 30 9D E5 0B 00 53 E1 E9 FF FF 1A 18 00 8D E2 24 10 84 E2 ?? ?? ?? ?? 24 00 94 E5 00 00 50 E3 2A 00 00 0A 10 30 9D E5 01 30 53 E2 10 30 8D E5 EF FF FF 0A 00 00 9A E5 20 30 90 E5 0C C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 A1 FF FF 1A 24 00 94 E5 4C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 0C 30 94 E5 00 00 53 E3 CE FF FF 1A 05 00 A0 E3 24 00 84 E5 DE FF FF EA 08 30 94 E5 00 00 53 E3 8B FF FF 1A 0C 30 94 E5 00 30 93 E2 01 30 A0 13 00 30 8D E5 88 FF FF EA 24 30 94 E5 00 00 53 E3 01 30 A0 03 24 30 84 05 05 00 A0 E1 01 10 A0 E3 ?? ?? ?? ?? 24 00 94 E5 CD FF FF EA 03 00 A0 E3 24 00 84 E5 CA FF FF EA 00 00 9D E5 C8 FF FF EA 00 00 9A E5 07 10 A0 E1 20 30 90 E5 08 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0D 00 00 1A 07 20 A0 E3 06 30 A0 E3 24 20 84 E5 28 30 84 E5 28 30 9D E5 00 00 53 E3 D0 FF FF 0A 02 30 A0 E3 05 00 A0 E1 07 10 A0 E1 4C 30 84 E5 ?? ?? ?? ?? 24 00 94 E5 B2 FF FF EA 05 00 A0 E1 74 10 9D E5 70 30 9D E5 0F E0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 EE FF FF 1A 24 30 94 E5 00 00 53 E3 02 30 A0 03 24 30 84 05 E9 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_6_0 {
	meta:
		name = "writetcp"
		size = 128
		refs = "0034 __write 004c __aeabi_read_tp 007c __libc_errno"
	strings:
		$1 = { F8 40 2D E9 00 70 52 E2 00 60 A0 E1 01 50 A0 E1 07 40 A0 C1 03 00 00 CA 14 00 00 EA 00 00 54 E3 00 50 85 E0 11 00 00 DA 04 20 A0 E1 00 00 96 E5 05 10 A0 E1 ?? ?? ?? ?? 01 00 70 E3 00 30 A0 E1 04 40 60 E0 F4 FF FF 1A 2C 20 9F E5 ?? ?? ?? ?? 02 20 9F E7 02 10 90 E7 28 10 86 E5 03 20 A0 E3 03 00 A0 E1 24 20 86 E5 F8 40 BD E8 ?? ?? ?? ?? 07 00 A0 E1 F8 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_7_0 {
	meta:
		name = "readtcp"
		size = 288
		refs = "0060 __poll 00a0 __read 00d0 __aeabi_read_tp 0118 __libc_errno"
	strings:
		$1 = { F0 41 2D E9 00 50 52 E2 08 30 90 E5 00 40 A0 E1 08 D0 4D E2 01 70 A0 E1 0C 00 90 E5 05 30 A0 01 17 00 00 0A E8 60 9F E5 90 26 C6 E0 00 10 94 E5 C0 0F A0 E1 83 C2 63 E0 01 20 A0 E3 46 03 60 E0 0C 31 83 E0 00 10 8D E5 B4 20 CD E1 C4 80 9F E5 83 61 80 E0 0D 00 A0 E1 01 10 A0 E3 06 20 A0 E1 ?? ?? ?? ?? 01 00 70 E3 00 30 A0 E1 17 00 00 0A 00 00 50 E3 06 00 00 1A 05 30 A0 E3 24 30 84 E5 00 30 E0 E3 03 00 A0 E1 08 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 07 10 A0 E1 05 20 A0 E1 00 00 94 E5 ?? ?? ?? ?? 01 00 70 E3 00 30 A0 E1 10 00 00 0A 00 00 50 E3 F2 FF FF 1A 04 30 A0 E3 68 20 A0 E3 24 30 84 E5 28 20 84 E5 00 30 E0 E3 EC FF FF EA ?? ?? ?? ?? 08 20 9F E7 02 20 90 E7 04 00 52 E3 DB FF FF 0A 04 10 A0 E3 28 20 84 E5 24 10 84 E5 E3 FF FF EA 20 20 9F E5 ?? ?? ?? ?? 02 20 9F E7 02 10 90 E7 04 20 A0 E3 28 10 84 E5 24 20 84 E5 DB FF FF EA D3 4D 62 10 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_8_0 {
	meta:
		name = "clnttcp_create"
		size = 656
		refs = "001c malloc 0078 _create_xid 00a8 xdrmem_create 00b4 xdr_callhdr 010c xdrrec_create 0118 authnone_create 0144 pmap_getport 0164 free 01b4 __socket 01c0 bindresvport 01d8 __connect 01f8 __close 0200 __rpc_thread_createerr 0214 __dcgettext 0228 __fxprintf 0254 __aeabi_read_tp 0270 readtcp 0274 writetcp 0280 _libc_intl_domainname 028c __libc_errno"
	strings:
		$1 = { F0 47 2D E9 00 50 A0 E1 38 D0 4D E2 0C 00 A0 E3 01 A0 A0 E1 02 90 A0 E1 03 80 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 64 00 A0 E3 ?? ?? ?? ?? 00 00 56 E3 00 00 50 13 00 40 A0 E1 70 00 00 0A B2 30 D5 E1 00 00 53 E3 3A 00 00 0A 00 30 98 E5 00 00 53 E3 00 20 A0 A3 04 20 84 A5 52 00 00 BA 00 70 A0 E3 00 30 84 E5 0C 70 84 E5 10 70 84 E5 0F 00 95 E8 14 C0 84 E2 0F 00 8C E8 ?? ?? ?? ?? 4C 50 84 E2 02 C0 A0 E3 08 00 8D E5 07 30 A0 E1 05 00 A0 E1 30 10 84 E2 18 20 A0 E3 10 C0 8D E5 0C 70 8D E5 14 A0 8D E5 18 90 8D E5 ?? ?? ?? ?? 05 00 A0 E1 08 10 8D E2 ?? ?? ?? ?? 07 00 50 E1 2D 00 00 0A 50 30 94 E5 05 00 A0 E1 10 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 50 30 94 E5 1C 30 93 E5 00 00 53 E3 48 00 84 E5 05 00 A0 11 0F E0 A0 11 ?? ?? ?? ?? 78 21 9F E5 78 31 9F E5 0C 00 8D E8 58 10 8D E2 05 00 A0 E1 06 00 91 E8 04 30 A0 E1 ?? ?? ?? ?? 60 31 9F E5 18 00 86 E9 ?? ?? ?? ?? 00 00 86 E5 06 30 A0 E1 03 00 A0 E1 38 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 06 30 A0 E3 05 00 A0 E1 0A 10 A0 E1 09 20 A0 E1 ?? ?? ?? ?? 00 70 50 E2 07 38 A0 11 07 74 A0 11 23 7C 87 11 B2 70 C5 11 B9 FF FF 1A 04 00 A0 E1 ?? ?? ?? ?? 06 00 A0 E1 ?? ?? ?? ?? 07 30 A0 E1 EA FF FF EA 04 30 94 E5 07 00 53 E1 1B 00 00 1A 04 00 A0 E1 ?? ?? ?? ?? 06 00 A0 E1 ?? ?? ?? ?? 00 30 A0 E3 03 00 A0 E1 38 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 01 10 A0 E3 06 20 A0 E3 02 00 A0 E3 ?? ?? ?? ?? 00 10 A0 E3 00 00 88 E5 ?? ?? ?? ?? 00 00 98 E5 00 00 50 E3 1A 00 00 BA 05 10 A0 E1 10 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 15 00 00 BA 01 30 A0 E3 04 30 84 E5 00 30 98 E5 99 FF FF EA 00 00 98 E5 ?? ?? ?? ?? E0 FF FF EA ?? ?? ?? ?? 70 10 9F E5 00 50 A0 E1 05 20 A0 E3 68 00 9F E5 ?? ?? ?? ?? 64 10 9F E5 00 30 A0 E1 60 20 9F E5 00 00 A0 E3 ?? ?? ?? ?? 0C 30 A0 E3 00 30 85 E5 08 30 85 E5 D1 FF FF EA ?? ?? ?? ?? 0C 30 A0 E3 00 30 80 E5 3C 30 9F E5 00 20 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 30 90 E7 08 30 82 E5 00 00 98 E5 00 00 50 E3 E2 FF FF AA C4 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_70_0_0 {
	meta:
		name = "__libc_siglongjmp"
		size = 68
		refs = "000c _longjmp_unwind 002c __longjmp 003c __sigprocmask"
	strings:
		$1 = { 38 40 2D E9 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 00 31 94 E5 00 00 53 E3 04 00 00 1A 00 00 55 E3 04 00 A0 E1 05 10 A0 11 01 10 A0 03 ?? ?? ?? ?? 41 1F 84 E2 00 20 A0 E3 02 00 A0 E3 ?? ?? ?? ?? F5 FF FF EA }
	condition:
		$1
}

rule file_1417_0_0 {
	meta:
		name = "__longjmp_chk"
		size = 68
		refs = "000c _longjmp_unwind 002c ____longjmp_chk 003c __sigprocmask"
	strings:
		$1 = { 38 40 2D E9 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 00 31 94 E5 00 00 53 E3 04 00 00 1A 00 00 55 E3 04 00 A0 E1 05 10 A0 11 01 10 A0 03 ?? ?? ?? ?? 41 1F 84 E2 00 20 A0 E3 02 00 A0 E3 ?? ?? ?? ?? F5 FF FF EA }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "__getgrnam_r"
		size = 540
		refs = "007c _dl_mcount_wrapper_check 0080 __aeabi_read_tp 00f0 __nss_next2 0160 __nscd_getgrnam_r 01b8 __nss_group_lookup2 01fc __nss_not_use_nscd_group 0204 __libc_errno 0214 __nss_database_custom"
	strings:
		$1 = { F0 4F 2D E9 F0 E1 9F E5 00 C0 9E E5 00 00 5C E3 14 D0 4D E2 00 70 A0 E1 01 60 A0 E1 02 80 A0 E1 03 90 A0 E1 42 00 00 DA 01 C0 8C E2 64 00 5C E3 00 30 A0 C3 00 C0 8E D5 00 30 8E C5 3D 00 00 CA B8 41 9F E5 00 20 D4 E5 00 00 52 E3 56 00 00 0A 04 B0 94 E5 08 30 94 E5 01 00 7B E3 0C 30 8D E5 08 B0 8D E5 00 00 A0 13 01 00 A0 03 00 00 50 E3 48 00 00 1A 88 A1 9F E5 0C 00 9D E5 ?? ?? ?? ?? ?? ?? ?? ?? 0A 30 9F E7 03 30 80 E0 00 30 8D E5 06 10 A0 E1 08 20 A0 E1 09 30 A0 E1 00 B0 A0 E1 07 00 A0 E1 0C C0 9D E5 0F E0 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 00 50 A0 E3 02 00 74 E3 44 11 9F E5 08 00 8D E2 05 20 A0 E1 0C 30 8D E2 04 00 00 1A 34 E1 9F E5 0E C0 9F E7 0C C0 9B E7 22 00 5C E3 2D 00 00 0A 00 C0 A0 E3 00 40 8D E5 04 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 DE FF FF 0A 01 00 54 E3 1A 00 00 0A 38 E0 9D E5 00 50 8E E5 19 00 00 9A F8 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 00 90 E7 22 00 50 E3 30 00 00 0A 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? C1 FF FF 1A D4 30 9F E5 02 30 D3 E5 00 00 53 E3 BD FF FF 1A 38 20 9D E5 07 00 A0 E1 00 20 8D E5 06 10 A0 E1 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 EE FF FF AA B3 FF FF EA 38 20 9D E5 00 60 82 E5 98 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 50 80 E7 05 00 A0 E1 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 40 E0 E3 38 C0 9D E5 00 30 A0 E3 00 30 8C E5 D8 FF FF EA 0C 30 8D E2 08 00 8D E2 4C 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 0C 20 9D 05 08 30 9D 05 00 30 E0 13 08 20 84 05 04 30 84 E5 0F CA E0 E3 0F E0 A0 E1 5F F0 4C E2 01 30 A0 E3 00 30 C4 E5 9F FF FF EA 02 00 74 E3 CC FF FF 0A 16 50 A0 E3 DE FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_216_0_0 {
	meta:
		name = "__getgrgid_r"
		size = 540
		refs = "007c _dl_mcount_wrapper_check 0080 __aeabi_read_tp 00f0 __nss_next2 0160 __nscd_getgrgid_r 01b8 __nss_group_lookup2 01fc __nss_not_use_nscd_group 0204 __libc_errno 0214 __nss_database_custom"
	strings:
		$1 = { F0 4F 2D E9 F0 E1 9F E5 00 C0 9E E5 00 00 5C E3 14 D0 4D E2 00 70 A0 E1 01 60 A0 E1 02 80 A0 E1 03 90 A0 E1 42 00 00 DA 01 C0 8C E2 64 00 5C E3 00 30 A0 C3 00 C0 8E D5 00 30 8E C5 3D 00 00 CA B8 41 9F E5 00 20 D4 E5 00 00 52 E3 56 00 00 0A 04 B0 94 E5 08 30 94 E5 01 00 7B E3 0C 30 8D E5 08 B0 8D E5 00 00 A0 13 01 00 A0 03 00 00 50 E3 48 00 00 1A 88 A1 9F E5 0C 00 9D E5 ?? ?? ?? ?? ?? ?? ?? ?? 0A 30 9F E7 03 30 80 E0 00 30 8D E5 06 10 A0 E1 08 20 A0 E1 09 30 A0 E1 00 B0 A0 E1 07 00 A0 E1 0C C0 9D E5 0F E0 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 00 50 A0 E3 02 00 74 E3 44 11 9F E5 08 00 8D E2 05 20 A0 E1 0C 30 8D E2 04 00 00 1A 34 E1 9F E5 0E C0 9F E7 0C C0 9B E7 22 00 5C E3 2D 00 00 0A 00 C0 A0 E3 00 40 8D E5 04 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 DE FF FF 0A 01 00 54 E3 1A 00 00 0A 38 E0 9D E5 00 50 8E E5 19 00 00 9A F8 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 00 90 E7 22 00 50 E3 30 00 00 0A 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? C1 FF FF 1A D4 30 9F E5 02 30 D3 E5 00 00 53 E3 BD FF FF 1A 38 20 9D E5 07 00 A0 E1 00 20 8D E5 06 10 A0 E1 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 EE FF FF AA B3 FF FF EA 38 20 9D E5 00 60 82 E5 98 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 50 80 E7 05 00 A0 E1 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 40 E0 E3 38 C0 9D E5 00 30 A0 E3 00 30 8C E5 D8 FF FF EA 0C 30 8D E2 08 00 8D E2 4C 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 0C 20 9D 05 08 30 9D 05 00 30 E0 13 08 20 84 05 04 30 84 E5 0F CA E0 E3 0F E0 A0 E1 5F F0 4C E2 01 30 A0 E3 00 30 C4 E5 9F FF FF EA 02 00 74 E3 CC FF FF 0A 16 50 A0 E3 DE FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "__vwprintf"
		size = 36
		refs = "0014 __vfwprintf 0020 stdout"
	strings:
		$1 = { 08 40 2D E9 14 30 9F E5 01 20 A0 E1 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_824_0_0 {
	meta:
		name = "__vprintf"
		size = 36
		refs = "0014 vfprintf 0020 stdout"
	strings:
		$1 = { 08 40 2D E9 14 30 9F E5 01 20 A0 E1 00 10 A0 E1 00 00 93 E5 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "__link"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 09 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_74_0_0 {
	meta:
		name = "getpass"
		size = 432
		refs = "0014 _IO_new_fopen 0038 fileno 0040 __tcgetattr 005c __fxprintf 0064 fflush_unlocked 0074 __getline 00c0 _IO_new_fclose 0118 tcsetattr 0190 _Unwind_Resume 01a4 stdin 01ac stderr"
	strings:
		$1 = { F0 41 2D E9 88 11 9F E5 78 D0 4D E2 00 60 A0 E1 80 01 9F E5 ?? ?? ?? ?? 00 40 50 E2 4E 00 00 0A 00 30 94 E5 02 39 83 E3 00 30 84 E5 04 50 A0 E1 04 70 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 3C 10 8D E2 ?? ?? ?? ?? 00 00 50 E3 00 80 A0 13 20 00 00 0A 06 20 A0 E1 05 00 A0 E1 3C 11 9F E5 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? 30 01 9F E5 04 20 A0 E1 04 10 80 E2 ?? ?? ?? ?? 20 61 9F E5 00 30 96 E5 00 00 53 E3 07 00 00 0A 00 00 50 E3 00 20 A0 B3 00 20 C3 B5 03 00 00 BA 01 00 40 E2 00 20 D3 E7 0A 00 52 E3 1F 00 00 0A 00 00 58 E3 24 00 00 1A EC 30 9F E5 00 30 93 E5 03 00 54 E1 04 00 A0 11 ?? ?? ?? ?? 00 00 96 E5 78 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 3C E0 8D E2 0F 00 BE E8 0D C0 A0 E1 0F 00 AC E8 0F 00 BE E8 0F 00 AC E8 0F 00 BE E8 0F 00 AC E8 07 00 9E E8 48 30 9D E5 07 00 8C E8 09 30 C3 E3 04 00 A0 E1 48 30 8D E5 ?? ?? ?? ?? 3C 20 8D E2 02 10 A0 E3 ?? ?? ?? ?? 01 80 70 E2 00 80 A0 33 C9 FF FF EA 00 20 A0 E3 00 00 58 E3 00 20 C3 E7 DD FF FF 0A 05 00 A0 E1 64 10 9F E5 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 02 10 A0 E3 0D 20 A0 E1 ?? ?? ?? ?? D4 FF FF EA 40 20 9F E5 44 30 9F E5 00 40 92 E5 00 50 93 E5 05 00 54 E1 05 70 A0 01 00 70 A0 11 AD FF FF EA 00 00 57 E3 00 40 A0 E1 07 00 A0 11 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_75_0_0 {
	meta:
		name = "__isoc99_fscanf"
		size = 528
		refs = "0024 __aeabi_read_tp 00a8 _IO_vfscanf 0164 __lll_lock_wait_private 020c _Unwind_Resume"
	strings:
		$1 = { 0E 00 2D E9 F0 41 2D E9 00 40 90 E5 0C D0 4D E2 02 49 14 E2 00 50 A0 E1 24 80 9D E5 18 00 00 1A 48 60 90 E5 ?? ?? ?? ?? 08 30 96 E5 13 7D 40 E2 07 00 53 E1 0F 00 00 0A 01 10 A0 E3 06 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 3C 00 00 1A 48 30 95 E5 08 70 83 E5 03 60 A0 E1 04 30 96 E5 01 30 83 E2 04 30 86 E5 3C 30 95 E5 28 C0 8D E2 10 30 83 E3 3C 30 85 E5 08 10 A0 E1 0C 20 A0 E1 05 00 A0 E1 00 30 A0 E3 04 C0 8D E5 ?? ?? ?? ?? 3C 30 95 E5 00 20 95 E5 14 30 C3 E3 02 09 12 E3 00 60 A0 E1 3C 30 85 E5 17 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 11 00 00 1A 08 30 85 E5 00 70 95 E5 00 10 A0 E3 07 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 57 E1 F0 FF FF 1A 01 00 57 E3 04 00 00 CA 06 00 A0 E1 0C D0 8D E2 F0 41 BD E8 0C D0 8D E2 ?? ?? ?? ?? ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF F1 FF FF EA 06 00 A0 E1 ?? ?? ?? ?? BF FF FF EA 3C 30 95 E5 00 20 95 E5 14 30 C3 E3 02 09 12 E3 00 80 A0 E1 3C 30 85 E5 1F 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 19 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 07 00 00 DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 08 00 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_828_0_0 {
	meta:
		name = "__isoc99_fwscanf"
		size = 528
		refs = "0024 __aeabi_read_tp 00a8 _IO_vfwscanf 0164 __lll_lock_wait_private 020c _Unwind_Resume"
	strings:
		$1 = { 0E 00 2D E9 F0 41 2D E9 00 40 90 E5 0C D0 4D E2 02 49 14 E2 00 50 A0 E1 24 80 9D E5 18 00 00 1A 48 60 90 E5 ?? ?? ?? ?? 08 30 96 E5 13 7D 40 E2 07 00 53 E1 0F 00 00 0A 01 10 A0 E3 06 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 3C 00 00 1A 48 30 95 E5 08 70 83 E5 03 60 A0 E1 04 30 96 E5 01 30 83 E2 04 30 86 E5 3C 30 95 E5 28 C0 8D E2 10 30 83 E3 3C 30 85 E5 08 10 A0 E1 0C 20 A0 E1 05 00 A0 E1 00 30 A0 E3 04 C0 8D E5 ?? ?? ?? ?? 3C 30 95 E5 00 20 95 E5 14 30 C3 E3 02 09 12 E3 00 60 A0 E1 3C 30 85 E5 17 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 11 00 00 1A 08 30 85 E5 00 70 95 E5 00 10 A0 E3 07 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 57 E1 F0 FF FF 1A 01 00 57 E3 04 00 00 CA 06 00 A0 E1 0C D0 8D E2 F0 41 BD E8 0C D0 8D E2 ?? ?? ?? ?? ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF F1 FF FF EA 06 00 A0 E1 ?? ?? ?? ?? BF FF FF EA 3C 30 95 E5 00 20 95 E5 14 30 C3 E3 02 09 12 E3 00 80 A0 E1 3C 30 85 E5 1F 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 19 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 07 00 00 DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 08 00 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_0_0 {
	meta:
		name = "__getegid"
		size = 20
	strings:
		$1 = { 04 70 2D E5 CA 70 A0 E3 00 00 00 EF 04 70 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_0_0 {
	meta:
		name = "__mktemp"
		size = 48
		refs = "0014 __gen_tempname"
	strings:
		$1 = { 00 10 A0 E3 10 40 2D E9 02 30 A0 E3 01 20 A0 E1 00 40 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 30 A0 B3 00 30 C4 B5 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "__strcasecmp"
		size = 116
		refs = "0010 __aeabi_read_tp 0070 __libc_tsd_LOCALE"
	strings:
		$1 = { 30 40 2D E9 64 30 9F E5 00 40 A0 E1 03 30 9F E7 ?? ?? ?? ?? 01 00 54 E1 03 30 90 E7 10 00 00 0A 38 50 93 E5 01 40 44 E2 01 00 00 EA 00 00 5C E3 08 00 00 0A 01 C0 F4 E5 01 30 D1 E4 0C 21 95 E7 03 31 95 E7 03 30 52 E0 F7 FF FF 0A 03 00 A0 E1 30 40 BD E8 ?? ?? ?? ?? 0C 00 A0 E1 30 40 BD E8 ?? ?? ?? ?? 00 00 A0 E3 30 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "strftime"
		size = 56
		refs = "0010 __aeabi_read_tp 0024 __strftime_l 0034 __libc_tsd_LOCALE"
	strings:
		$1 = { 30 40 2D E9 28 40 9F E5 00 50 A0 E1 04 40 9F E7 ?? ?? ?? ?? 04 C0 90 E7 0C D0 4D E2 05 00 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_937_0_0 {
	meta:
		name = "__strtol_internal"
		size = 56
		refs = "0010 __aeabi_read_tp 0024 ____strtol_l_internal 0034 __libc_tsd_LOCALE"
	strings:
		$1 = { 30 40 2D E9 28 40 9F E5 00 50 A0 E1 04 40 9F E7 ?? ?? ?? ?? 04 C0 90 E7 0C D0 4D E2 05 00 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1304_0_0 {
	meta:
		name = "__strtoll_internal"
		size = 56
		refs = "0010 __aeabi_read_tp 0024 ____strtoll_l_internal 0034 __libc_tsd_LOCALE"
	strings:
		$1 = { 30 40 2D E9 28 40 9F E5 00 50 A0 E1 04 40 9F E7 ?? ?? ?? ?? 04 C0 90 E7 0C D0 4D E2 05 00 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_803_0_0 {
	meta:
		name = "__strtoul_internal"
		size = 56
		refs = "0010 __aeabi_read_tp 0024 ____strtoul_l_internal 0034 __libc_tsd_LOCALE"
	strings:
		$1 = { 30 40 2D E9 28 40 9F E5 00 50 A0 E1 04 40 9F E7 ?? ?? ?? ?? 04 C0 90 E7 0C D0 4D E2 05 00 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_818_0_0 {
	meta:
		name = "__strtoull_internal"
		size = 56
		refs = "0010 __aeabi_read_tp 0024 ____strtoull_l_internal 0034 __libc_tsd_LOCALE"
	strings:
		$1 = { 30 40 2D E9 28 40 9F E5 00 50 A0 E1 04 40 9F E7 ?? ?? ?? ?? 04 C0 90 E7 0C D0 4D E2 05 00 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "__wcstol_internal"
		size = 56
		refs = "0010 __aeabi_read_tp 0024 ____wcstol_l_internal 0034 __libc_tsd_LOCALE"
	strings:
		$1 = { 30 40 2D E9 28 40 9F E5 00 50 A0 E1 04 40 9F E7 ?? ?? ?? ?? 04 C0 90 E7 0C D0 4D E2 05 00 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_723_0_0 {
	meta:
		name = "__wcstoll_internal"
		size = 56
		refs = "0010 __aeabi_read_tp 0024 ____wcstoll_l_internal 0034 __libc_tsd_LOCALE"
	strings:
		$1 = { 30 40 2D E9 28 40 9F E5 00 50 A0 E1 04 40 9F E7 ?? ?? ?? ?? 04 C0 90 E7 0C D0 4D E2 05 00 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_209_0_0 {
	meta:
		name = "__wcstoul_internal"
		size = 56
		refs = "0010 __aeabi_read_tp 0024 ____wcstoul_l_internal 0034 __libc_tsd_LOCALE"
	strings:
		$1 = { 30 40 2D E9 28 40 9F E5 00 50 A0 E1 04 40 9F E7 ?? ?? ?? ?? 04 C0 90 E7 0C D0 4D E2 05 00 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_858_0_0 {
	meta:
		name = "__wcstoull_internal"
		size = 56
		refs = "0010 __aeabi_read_tp 0024 ____wcstoull_l_internal 0034 __libc_tsd_LOCALE"
	strings:
		$1 = { 30 40 2D E9 28 40 9F E5 00 50 A0 E1 04 40 9F E7 ?? ?? ?? ?? 04 C0 90 E7 0C D0 4D E2 05 00 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_346_0_0 {
	meta:
		name = "wcsftime"
		size = 56
		refs = "0010 __aeabi_read_tp 0024 __wcsftime_l 0034 __libc_tsd_LOCALE"
	strings:
		$1 = { 30 40 2D E9 28 40 9F E5 00 50 A0 E1 04 40 9F E7 ?? ?? ?? ?? 04 C0 90 E7 0C D0 4D E2 05 00 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "__socketpair"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 12 7E A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_1_0 {
	meta:
		name = "wcstol"
		size = 60
		refs = "0010 __aeabi_read_tp 0028 ____wcstol_l_internal 0038 __libc_tsd_LOCALE"
	strings:
		$1 = { 10 40 2D E9 2C 30 9F E5 00 40 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 00 90 E7 08 D0 4D E2 00 00 8D E5 00 30 A0 E3 04 00 A0 E1 ?? ?? ?? ?? 08 D0 8D E2 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "strptime"
		size = 60
		refs = "0010 __aeabi_read_tp 0028 __strptime_internal 0038 __libc_tsd_LOCALE"
	strings:
		$1 = { 10 40 2D E9 2C 30 9F E5 00 40 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 00 90 E7 08 D0 4D E2 00 00 8D E5 00 30 A0 E3 04 00 A0 E1 ?? ?? ?? ?? 08 D0 8D E2 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_937_1_0 {
	meta:
		name = "strtol"
		size = 60
		refs = "0010 __aeabi_read_tp 0028 ____strtol_l_internal 0038 __libc_tsd_LOCALE"
	strings:
		$1 = { 10 40 2D E9 2C 30 9F E5 00 40 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 00 90 E7 08 D0 4D E2 00 00 8D E5 00 30 A0 E3 04 00 A0 E1 ?? ?? ?? ?? 08 D0 8D E2 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1304_1_0 {
	meta:
		name = "strtoll"
		size = 60
		refs = "0010 __aeabi_read_tp 0028 ____strtoll_l_internal 0038 __libc_tsd_LOCALE"
	strings:
		$1 = { 10 40 2D E9 2C 30 9F E5 00 40 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 00 90 E7 08 D0 4D E2 00 00 8D E5 00 30 A0 E3 04 00 A0 E1 ?? ?? ?? ?? 08 D0 8D E2 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_803_1_0 {
	meta:
		name = "strtoul"
		size = 60
		refs = "0010 __aeabi_read_tp 0028 ____strtoul_l_internal 0038 __libc_tsd_LOCALE"
	strings:
		$1 = { 10 40 2D E9 2C 30 9F E5 00 40 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 00 90 E7 08 D0 4D E2 00 00 8D E5 00 30 A0 E3 04 00 A0 E1 ?? ?? ?? ?? 08 D0 8D E2 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_818_1_0 {
	meta:
		name = "strtoull"
		size = 60
		refs = "0010 __aeabi_read_tp 0028 ____strtoull_l_internal 0038 __libc_tsd_LOCALE"
	strings:
		$1 = { 10 40 2D E9 2C 30 9F E5 00 40 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 00 90 E7 08 D0 4D E2 00 00 8D E5 00 30 A0 E3 04 00 A0 E1 ?? ?? ?? ?? 08 D0 8D E2 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_723_1_0 {
	meta:
		name = "wcstoll"
		size = 60
		refs = "0010 __aeabi_read_tp 0028 ____wcstoll_l_internal 0038 __libc_tsd_LOCALE"
	strings:
		$1 = { 10 40 2D E9 2C 30 9F E5 00 40 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 00 90 E7 08 D0 4D E2 00 00 8D E5 00 30 A0 E3 04 00 A0 E1 ?? ?? ?? ?? 08 D0 8D E2 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_209_1_0 {
	meta:
		name = "wcstoul"
		size = 60
		refs = "0010 __aeabi_read_tp 0028 ____wcstoul_l_internal 0038 __libc_tsd_LOCALE"
	strings:
		$1 = { 10 40 2D E9 2C 30 9F E5 00 40 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 00 90 E7 08 D0 4D E2 00 00 8D E5 00 30 A0 E3 04 00 A0 E1 ?? ?? ?? ?? 08 D0 8D E2 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_858_1_0 {
	meta:
		name = "wcstoull"
		size = 60
		refs = "0010 __aeabi_read_tp 0028 ____wcstoull_l_internal 0038 __libc_tsd_LOCALE"
	strings:
		$1 = { 10 40 2D E9 2C 30 9F E5 00 40 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 00 90 E7 08 D0 4D E2 00 00 8D E5 00 30 A0 E3 04 00 A0 E1 ?? ?? ?? ?? 08 D0 8D E2 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "nfsservctl"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 A9 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_0_0 {
	meta:
		name = "listxattr"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 E8 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "memfrob"
		size = 40
	strings:
		$1 = { 00 00 51 E3 ?? ?? ?? ?? 01 10 80 E0 00 30 A0 E1 01 20 D3 E4 2A 20 22 E2 01 00 53 E1 01 20 43 E5 FA FF FF 1A ?? ?? ?? ?? }
	condition:
		$1
}

rule file_85_0_0 {
	meta:
		name = "__exit_thread"
		size = 20
	strings:
		$1 = { 04 70 2D E5 01 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 }
	condition:
		$1
}

rule file_86_0_0 {
	meta:
		name = "sigignore"
		size = 76
		refs = "0024 memset 003c __sigaction"
	strings:
		$1 = { 30 40 2D E9 94 D0 4D E2 01 30 A0 E3 90 40 8D E2 8C 30 24 E5 00 50 A0 E1 00 10 A0 E3 08 00 8D E2 80 20 A0 E3 ?? ?? ?? ?? 00 30 A0 E3 04 10 A0 E1 05 00 A0 E1 03 20 A0 E1 88 30 8D E5 ?? ?? ?? ?? 94 D0 8D E2 30 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_0_0 {
	meta:
		name = "seteuid"
		size = 176
		refs = "0038 __nptl_setxid 0054 __aeabi_read_tp 00a8 __libc_errno"
	strings:
		$1 = { 80 40 2D E9 01 00 70 E3 18 D0 4D E2 00 10 A0 E1 0E 00 00 0A 88 30 9F E5 00 00 53 E3 11 00 00 0A 00 30 E0 E3 D0 20 A0 E3 04 00 8D E2 0C 10 8D E5 0C 00 8D E9 10 30 8D E5 ?? ?? ?? ?? 00 10 A0 E1 01 00 A0 E1 18 D0 8D E2 80 40 BD E8 ?? ?? ?? ?? 50 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 F5 FF FF EA 00 00 E0 E3 00 20 A0 E1 D0 70 A0 E3 00 00 00 EF 01 0A 70 E3 01 00 00 8A 00 10 A0 E1 ED FF FF EA 1C 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 F6 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_88_0_0 {
	meta:
		name = "setlinebuf"
		size = 28
		refs = "0010 _IO_setvbuf"
	strings:
		$1 = { 08 40 2D E9 00 10 A0 E3 01 30 A0 E1 01 20 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "__libc_init_secure"
		size = 100
		refs = "001c __geteuid 0024 __getuid 0044 __getegid 004c __getgid 005c __libc_enable_secure_decided"
	strings:
		$1 = { 54 30 9F E5 00 30 93 E5 00 00 53 E3 10 40 2D E9 01 00 00 0A 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 00 40 A0 E1 ?? ?? ?? ?? 00 00 54 E1 01 00 A0 13 03 00 00 0A 24 30 9F E5 10 40 BD E8 00 00 83 E5 ?? ?? ?? ?? ?? ?? ?? ?? 00 40 A0 E1 ?? ?? ?? ?? 00 00 54 E0 01 00 A0 13 F5 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_0_0 {
	meta:
		name = "fchmodat"
		size = 400
		refs = "0060 __aeabi_read_tp 00a8 strlen 00d8 __snprintf 0108 __atfct_seterrno 0170 __have_atfcts 0178 __libc_errno"
	strings:
		$1 = { F0 4B 2D E9 01 CC D3 E3 1C B0 8D E2 08 D0 4D E2 00 80 A0 E1 01 50 A0 E1 02 90 A0 E1 3E 00 00 1A 01 0C 13 E3 43 00 00 1A 40 61 9F E5 00 30 96 E5 00 00 53 E3 15 00 00 BA 34 71 9F E5 00 00 00 EF 01 0A 70 E3 00 40 A0 E1 03 00 00 8A 04 00 A0 E1 1C D0 4B E2 F0 4B BD E8 ?? ?? ?? ?? 14 31 9F E5 ?? ?? ?? ?? 00 40 64 E2 03 30 9F E7 03 40 80 E7 04 31 9F E5 03 30 9F E7 03 30 90 E7 26 00 53 E3 00 40 E0 13 F0 FF FF 1A 00 30 E0 E3 00 30 86 E5 64 00 78 E3 1E 00 00 0A 00 30 D5 E5 2F 00 53 E3 1B 00 00 0A 05 00 A0 E1 ?? ?? ?? ?? 00 10 50 E2 27 00 00 0A 2E 30 81 E2 07 30 C3 E3 03 D0 4D E0 08 40 8D E2 00 50 8D E5 20 10 81 E2 04 00 A0 E1 A8 20 9F E5 08 30 A0 E1 ?? ?? ?? ?? 04 50 A0 E1 05 00 A0 E1 09 10 A0 E1 0F 70 A0 E3 00 00 00 EF 01 0A 70 E3 00 40 A0 91 D3 FF FF 9A 04 20 A0 E1 00 00 60 E2 08 10 A0 E1 ?? ?? ?? ?? 00 40 E0 E3 CD FF FF EA 00 40 A0 E3 F0 FF FF EA 60 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 00 40 E0 E3 C4 FF FF EA 48 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 5F 20 A0 E3 03 20 80 E7 00 40 E0 E3 BD FF FF EA 30 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 02 20 A0 E3 03 20 80 E7 00 40 E0 E3 B6 FF FF EA ?? ?? ?? ?? 4D 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_91_1_0 {
	meta:
		name = "__dlclose"
		size = 36
		refs = "000c _dlerror_run 0020 dlclose_doit"
	strings:
		$1 = { 08 40 2D E9 00 10 A0 E1 10 00 9F E5 ?? ?? ?? ?? 08 40 BD E8 00 00 50 E2 00 00 E0 13 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_92_0_0 {
	meta:
		name = "__ptsname_internal"
		size = 848
		refs = "0010 __aeabi_read_tp 0034 __isatty 0084 __ioctl 00b0 __xstat64 012c _itoa_word 01b4 memcpy 01d8 __fxstat64 0278 strlen 030c __libc_errno 033c __libc_ptyname1 034c __libc_ptyname2"
	strings:
		$1 = { F0 47 2D E9 00 43 9F E5 00 60 A0 E1 04 40 9F E7 ?? ?? ?? ?? 00 80 51 E2 20 D0 4D E2 00 50 A0 E1 02 90 A0 E1 03 70 A0 E1 04 40 90 E7 0A 00 00 0A 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0D 00 00 1A C8 32 9F E5 19 00 A0 E3 03 30 9F E7 03 00 85 E7 20 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? B0 32 9F E5 16 00 A0 E3 03 30 9F E7 03 00 85 E7 20 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 06 00 A0 E1 94 12 9F E5 04 20 8D E2 ?? ?? ?? ?? 00 C0 50 E2 21 00 00 0A 84 32 9F E5 03 30 9F E7 03 30 95 E7 16 00 53 E3 10 00 00 0A 08 10 A0 E1 03 00 A0 E3 07 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 11 00 00 BA 10 30 97 E5 0F 3A 03 E2 02 0A 53 E3 23 00 00 0A 4C 32 9F E5 ?? ?? ?? ?? 19 20 A0 E3 03 30 9F E7 03 20 80 E7 02 00 A0 E1 D9 FF FF EA 0A 00 59 E3 36 00 00 8A 2C 32 9F E5 22 00 A0 E3 03 30 9F E7 03 00 85 E7 D2 FF FF EA 1C 32 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 00 90 E7 CD FF FF EA 0C 30 A0 E1 04 00 9D E5 1C 10 8D E2 0A 20 A0 E3 1C C0 CD E5 ?? ?? ?? ?? 1D 60 8D E2 06 60 60 E0 09 30 86 E2 09 00 53 E1 00 A0 A0 E1 17 00 00 9A DC 31 9F E5 22 00 A0 E3 03 30 9F E7 03 00 85 E7 BC FF FF EA 24 10 97 E5 20 20 97 E5 FF 3E C1 E3 0F 30 C3 E3 02 06 A0 E1 20 3A 83 E1 03 00 53 E3 04 00 00 0A 04 00 53 E3 2B 00 00 0A 88 30 43 E2 07 00 53 E3 CE FF FF 8A 98 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 40 80 E7 00 00 A0 E3 A9 FF FF EA 08 00 A0 E1 80 11 9F E5 0A 20 A0 E3 ?? ?? ?? ?? 0A 10 A0 E1 06 20 A0 E1 09 00 88 E2 ?? ?? ?? ?? B5 FF FF EA 06 10 A0 E1 03 00 A0 E3 07 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 2F 00 00 BA 24 20 97 E5 20 30 97 E5 FF 1E C2 E3 0F 10 C1 E3 03 06 A0 E1 20 1A 81 E1 02 00 51 E3 14 00 00 0A 04 00 51 E3 29 00 00 0A 80 10 41 E2 07 00 51 E3 0F 00 00 9A 18 31 9F E5 ?? ?? ?? ?? 19 20 A0 E3 03 30 9F E7 03 20 80 E7 02 00 A0 E1 86 FF FF EA 22 36 A0 E1 01 3A 83 E1 FF 30 C3 E3 FF 20 02 E2 02 30 83 E1 C0 30 43 E2 3F 00 53 E3 9D FF FF 8A CD FF FF EA 23 16 A0 E1 FF 30 03 E2 02 2A 81 E1 D0 60 9F E5 FF 50 C2 E3 03 50 85 E1 06 00 A0 E1 04 50 8D E5 ?? ?? ?? ?? 25 32 A0 E1 00 00 53 E1 13 00 00 3A B0 30 9F E5 ?? ?? ?? ?? 19 20 A0 E3 03 30 9F E7 03 20 80 E7 02 00 A0 E1 6A FF FF EA 98 30 9F E5 03 30 9F E7 03 00 95 E7 66 FF FF EA 23 16 A0 E1 02 0A 81 E1 FF 30 03 E2 FF 00 C0 E3 03 00 80 E1 80 00 40 E2 3F 00 50 E3 D0 FF FF 8A E1 FF FF EA 68 10 9F E5 09 20 A0 E3 08 00 A0 E1 ?? ?? ?? ?? 5C 20 9F E5 0F 30 05 E2 03 20 D2 E7 25 12 D6 E7 00 30 A0 E3 08 10 C8 E5 09 20 C8 E5 0A 30 C8 E5 65 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 30 54 04 80 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_92_1_0 {
	meta:
		name = "ptsname"
		size = 56
		refs = "0014 __ptsname_internal"
	strings:
		$1 = { 04 E0 2D E5 6C D0 4D E2 0D 30 A0 E1 20 10 9F E5 1E 20 A0 E3 ?? ?? ?? ?? 14 30 9F E5 00 00 50 E3 03 00 A0 01 00 00 A0 13 6C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_92_2_0 {
	meta:
		name = "__ptsname_r"
		size = 28
		refs = "000c __ptsname_internal"
	strings:
		$1 = { 04 E0 2D E5 6C D0 4D E2 0D 30 A0 E1 ?? ?? ?? ?? 6C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "cbc_crypt"
		size = 312
		refs = "00f0 _des_crypt"
	strings:
		$1 = { F0 4F 2D E9 3C D0 4D E2 60 40 9D E5 00 B0 D4 E5 01 A0 D4 E5 02 90 D4 E5 03 80 D4 E5 04 70 D4 E5 05 60 D4 E5 06 50 D4 E5 07 C0 D4 E5 00 30 8D E5 07 00 12 E3 00 30 A0 E3 1C B0 CD E5 1D A0 CD E5 1E 90 CD E5 1F 80 CD E5 20 70 CD E5 21 60 CD E5 22 50 CD E5 23 C0 CD E5 18 30 8D E5 0B 00 00 0A 03 00 A0 E3 00 B0 C4 E5 01 A0 C4 E5 02 90 C4 E5 03 80 C4 E5 04 70 C4 E5 05 60 C4 E5 06 50 C4 E5 07 C0 C4 E5 3C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 02 0A 52 E3 F1 FF FF 8A 00 30 9D E5 00 90 D0 E5 01 80 D0 E5 02 70 D0 E5 03 60 D0 E5 04 50 D0 E5 05 E0 D0 E5 06 C0 D0 E5 07 A0 D0 E5 01 B0 03 E2 01 00 A0 E1 02 10 A0 E1 0C 20 8D E2 0C 90 CD E5 0D 80 CD E5 0E 70 CD E5 0F 60 CD E5 10 50 CD E5 11 E0 CD E5 12 C0 CD E5 13 A0 CD E5 14 B0 8D E5 ?? ?? ?? ?? 00 00 50 E3 02 00 A0 03 08 00 00 1A 1C B0 DD E5 1D A0 DD E5 1E 90 DD E5 1F 80 DD E5 20 70 DD E5 21 60 DD E5 22 50 DD E5 23 C0 DD E5 CF FF FF EA 00 30 9D E5 02 00 13 E3 00 00 A0 13 01 00 A0 03 F1 FF FF EA }
	condition:
		$1
}

rule file_93_1_0 {
	meta:
		name = "ecb_crypt"
		size = 172
		refs = "0088 _des_crypt"
	strings:
		$1 = { F0 47 2D E9 01 C0 A0 E3 38 D0 4D E2 07 00 12 E3 18 C0 8D E5 03 00 00 0A 03 00 A0 E3 38 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 02 0A 52 E3 F9 FF FF 8A 00 80 D0 E5 01 70 D0 E5 02 60 D0 E5 03 50 D0 E5 04 40 D0 E5 05 E0 D0 E5 06 C0 D0 E5 07 90 D0 E5 01 A0 03 E2 01 00 A0 E1 02 10 A0 E1 0C 20 8D E2 04 30 8D E5 0C 80 CD E5 0D 70 CD E5 0E 60 CD E5 0F 50 CD E5 10 40 CD E5 11 E0 CD E5 12 C0 CD E5 13 90 CD E5 14 A0 8D E5 ?? ?? ?? ?? 00 00 50 E3 04 30 9D E5 02 00 A0 03 DF FF FF 0A 02 00 13 E3 00 00 A0 13 01 00 A0 03 DB FF FF EA }
	condition:
		$1
}

rule file_94_0_0 {
	meta:
		name = "strxfrm"
		size = 44
		refs = "0010 __aeabi_read_tp 001c __strxfrm_l 0028 __libc_tsd_LOCALE"
	strings:
		$1 = { 10 40 2D E9 1C 30 9F E5 00 40 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 30 90 E7 04 00 A0 E1 ?? ?? ?? ?? 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1111_0_0 {
	meta:
		name = "__strtod_internal"
		size = 44
		refs = "0010 __aeabi_read_tp 001c ____strtod_l_internal 0028 __libc_tsd_LOCALE"
	strings:
		$1 = { 10 40 2D E9 1C 30 9F E5 00 40 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 30 90 E7 04 00 A0 E1 ?? ?? ?? ?? 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_745_0_0 {
	meta:
		name = "__strtof_internal"
		size = 44
		refs = "0010 __aeabi_read_tp 001c ____strtof_l_internal 0028 __libc_tsd_LOCALE"
	strings:
		$1 = { 10 40 2D E9 1C 30 9F E5 00 40 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 30 90 E7 04 00 A0 E1 ?? ?? ?? ?? 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_566_0_0 {
	meta:
		name = "__strtold_internal"
		size = 44
		refs = "0010 __aeabi_read_tp 001c ____strtold_l_internal 0028 __libc_tsd_LOCALE"
	strings:
		$1 = { 10 40 2D E9 1C 30 9F E5 00 40 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 30 90 E7 04 00 A0 E1 ?? ?? ?? ?? 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1100_0_0 {
	meta:
		name = "__wcstod_internal"
		size = 44
		refs = "0010 __aeabi_read_tp 001c ____wcstod_l_internal 0028 __libc_tsd_LOCALE"
	strings:
		$1 = { 10 40 2D E9 1C 30 9F E5 00 40 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 30 90 E7 04 00 A0 E1 ?? ?? ?? ?? 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1033_0_0 {
	meta:
		name = "__wcstof_internal"
		size = 44
		refs = "0010 __aeabi_read_tp 001c ____wcstof_l_internal 0028 __libc_tsd_LOCALE"
	strings:
		$1 = { 10 40 2D E9 1C 30 9F E5 00 40 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 30 90 E7 04 00 A0 E1 ?? ?? ?? ?? 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_955_0_0 {
	meta:
		name = "__wcstold_internal"
		size = 44
		refs = "0010 __aeabi_read_tp 001c ____wcstold_l_internal 0028 __libc_tsd_LOCALE"
	strings:
		$1 = { 10 40 2D E9 1C 30 9F E5 00 40 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 30 90 E7 04 00 A0 E1 ?? ?? ?? ?? 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_232_0_0 {
	meta:
		name = "wcsxfrm"
		size = 44
		refs = "0010 __aeabi_read_tp 001c __wcsxfrm_l 0028 __libc_tsd_LOCALE"
	strings:
		$1 = { 10 40 2D E9 1C 30 9F E5 00 40 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 30 90 E7 04 00 A0 E1 ?? ?? ?? ?? 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_0_0 {
	meta:
		name = "endnetgrent_hook"
		size = 76
		refs = "0024 __nss_lookup_function"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 28 00 90 E5 01 30 40 E2 03 00 73 E3 01 00 00 9A 10 40 BD E8 ?? ?? ?? ?? 20 10 9F E5 ?? ?? ?? ?? 00 30 50 E2 04 00 A0 11 0F E0 A0 11 ?? ?? ?? ?? 00 30 A0 E3 28 30 84 E5 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_1_0 {
	meta:
		name = "setup"
		size = 144
		refs = "003c __nss_lookup 0054 __nss_netgroup_lookup"
	strings:
		$1 = { 38 40 2D E9 7C 40 9F E5 00 30 D4 E5 00 00 53 E3 01 50 A0 E1 00 30 A0 E1 0A 00 00 0A 04 10 94 E5 01 00 71 E3 01 00 A0 03 04 00 00 0A 00 10 85 E5 05 00 A0 E1 50 10 9F E5 00 20 A0 E3 ?? ?? ?? ?? 38 40 BD E8 ?? ?? ?? ?? 00 20 A0 E1 01 00 A0 E1 34 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 00 30 95 05 00 30 E0 13 04 30 84 E5 0F CA E0 E3 0F E0 A0 E1 5F F0 4C E2 0C 30 9F E5 01 20 A0 E3 00 20 C3 E5 38 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_2_0 {
	meta:
		name = "__internal_setnetgrent_reuse"
		size = 376
		refs = "005c _dl_mcount_wrapper_check 0090 __nss_next2 00b0 __nss_lookup_function 00d8 strlen 00e8 malloc 0108 memcpy 012c __aeabi_read_tp 015c __assert_fail 0168 __libc_errno"
	strings:
		$1 = { F0 47 2D E9 28 70 81 E2 10 D0 4D E2 00 60 A0 E1 01 00 A0 E1 01 40 A0 E1 02 90 A0 E1 C0 FF FF EB 07 10 A0 E1 0C 00 8D E2 D0 FF FF EB 00 00 50 E3 26 00 00 1A 10 80 94 E5 00 00 58 E3 05 00 00 0A 41 00 00 EA 00 00 53 E3 21 00 00 0A 10 30 94 E5 00 00 53 E3 3C 00 00 1A 0C 00 9D E5 ?? ?? ?? ?? 04 10 A0 E1 06 00 A0 E1 0C C0 9D E5 0F E0 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 20 01 8D E8 0C 30 8D E2 07 00 A0 E1 D4 10 9F E5 00 20 A0 E3 28 A0 94 E5 ?? ?? ?? ?? 01 30 70 E2 00 30 A0 33 01 00 55 E3 00 00 50 03 E6 FF FF 1A 0A 00 A0 E1 B0 10 9F E5 ?? ?? ?? ?? 00 50 50 E2 E3 FF FF 0A ?? ?? ?? ?? 04 00 A0 E1 0F E0 A0 E1 ?? ?? ?? ?? DE FF FF EA 00 50 E0 E3 06 00 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 05 00 80 E2 01 80 82 E2 ?? ?? ?? ?? 00 70 50 E2 0C 00 00 0A 20 30 94 E5 07 00 A0 E1 04 30 80 E4 06 10 A0 E1 08 20 A0 E1 ?? ?? ?? ?? 01 30 55 E2 00 00 73 E2 03 00 B0 E0 20 70 84 E5 10 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 38 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 07 00 A0 E1 00 30 89 E5 10 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 18 00 9F E5 18 10 9F E5 88 20 A0 E3 14 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_3_0 {
	meta:
		name = "nscd_getnetgrent"
		size = 120
		refs = "0030 __rawmemchr"
	strings:
		$1 = { 38 40 2D E9 00 40 A0 E1 10 20 84 E2 0C 00 92 E8 03 30 82 E0 18 00 90 E5 03 00 50 E1 13 00 00 2A 00 50 A0 E3 05 10 A0 E1 04 00 84 E5 00 50 84 E5 ?? ?? ?? ?? 01 00 80 E2 05 10 A0 E1 18 00 84 E5 08 00 84 E5 ?? ?? ?? ?? 01 00 80 E2 18 00 84 E5 0C 00 84 E5 05 10 A0 E1 ?? ?? ?? ?? 01 00 80 E2 18 00 84 E5 01 00 A0 E3 38 40 BD E8 ?? ?? ?? ?? 00 00 E0 E3 FB FF FF EA }
	condition:
		$1
}

rule file_95_4_0 {
	meta:
		name = "free_memory.isra.0"
		size = 92
		refs = "0020 free"
	strings:
		$1 = { 38 40 2D E9 00 50 A0 E1 00 00 90 E5 00 00 50 E3 01 40 A0 E1 0B 00 00 0A 00 30 90 E5 00 30 85 E5 ?? ?? ?? ?? 00 00 95 E5 00 00 50 E3 F9 FF FF 1A 00 00 94 E5 00 00 50 E3 05 00 00 0A 00 30 90 E5 00 30 84 E5 ?? ?? ?? ?? 00 00 94 E5 00 00 50 E3 F9 FF FF 1A 38 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_5_0 {
	meta:
		name = "__internal_setnetgrent"
		size = 60
		refs = "001c __aeabi_read_tp 0038 __libc_errno"
	strings:
		$1 = { 38 40 2D E9 01 40 A0 E1 00 50 A0 E1 24 10 81 E2 20 00 84 E2 E2 FF FF EB 18 20 9F E5 ?? ?? ?? ?? 02 20 9F E7 02 20 80 E0 04 10 A0 E1 05 00 A0 E1 38 40 BD E8 5E FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_6_0 {
	meta:
		name = "setnetgrent"
		size = 316
		refs = "0080 __nscd_setnetgrent 00ec __internal_setnetgrent 00f8 __aeabi_read_tp 0120 __lll_lock_wait_private 012c __nss_not_use_nscd_netgroup 0130 __nss_database_custom"
	strings:
		$1 = { F8 40 2D E9 01 10 A0 E3 00 50 A0 E1 14 21 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 36 00 00 1A E4 20 9F E5 00 30 92 E5 00 00 53 E3 23 00 00 DA 01 30 83 E2 64 00 53 E3 00 30 A0 C3 00 30 82 D5 00 30 82 C5 1E 00 00 DA C0 30 9F E5 06 30 D3 E5 00 00 53 E3 1A 00 00 1A 05 00 A0 E1 B0 10 9F E5 ?? ?? ?? ?? 00 60 50 E2 15 00 00 BA A4 70 9F E5 08 50 97 E5 00 10 A0 E3 05 40 A0 E1 84 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 08 00 00 CA 06 00 A0 E1 F8 40 BD E8 ?? ?? ?? ?? E0 FF FF 0A 05 00 A0 E1 44 10 9F E5 ?? ?? ?? ?? 00 60 A0 E1 E4 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 18 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF ED FF FF EA 02 00 A0 E1 ?? ?? ?? ?? C5 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_7_0 {
	meta:
		name = "__internal_endnetgrent"
		size = 28
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 D4 FE FF EB 20 00 84 E2 24 10 84 E2 10 40 BD E8 83 FF FF EA }
	condition:
		$1
}

rule file_95_8_0 {
	meta:
		name = "endnetgrent"
		size = 224
		refs = "00a4 __lll_lock_wait_private 00ac __aeabi_read_tp"
	strings:
		$1 = { F8 40 2D E9 01 10 A0 E3 C0 20 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 18 00 00 1A 90 00 9F E5 BF FE FF EB 8C 00 9F E5 04 10 80 E2 6F FF FF EB 84 60 9F E5 08 50 96 E5 00 10 A0 E3 05 40 A0 E1 68 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 04 00 00 CA F8 40 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? E3 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF F1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_9_0 {
	meta:
		name = "__internal_getnetgrent_r"
		size = 480
		refs = "0034 __nss_lookup_function 0048 _dl_mcount_wrapper_check 004c __aeabi_read_tp 00a0 strcmp 00ec strlen 00f8 malloc 0114 memcpy 01d8 __libc_errno 01dc nscd_getnetgrent"
	strings:
		$1 = { F0 4F 2D E9 03 40 A0 E1 28 30 93 E5 14 D0 4D E2 00 00 53 E3 07 00 8D E9 3C A0 9D E5 40 60 9D E5 59 00 00 0A 01 00 73 E3 5B 00 00 0A 03 00 A0 E1 9C 11 9F E5 ?? ?? ?? ?? 00 70 50 E2 52 00 00 0A 90 81 9F E5 07 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 08 30 9F E7 03 30 80 E0 38 10 9D E5 04 00 A0 E1 0A 20 A0 E1 0F E0 A0 E1 ?? ?? ?? ?? 02 00 50 E3 2A 00 00 0A 01 00 50 E3 43 00 00 1A 00 30 94 E5 01 00 53 E3 46 00 00 1A 20 50 94 E5 00 00 55 E3 04 90 94 E5 07 00 00 0A 09 00 A0 E1 04 10 85 E2 ?? ?? ?? ?? 00 00 50 E3 E5 FF FF 0A 00 50 95 E5 00 00 55 E3 F7 FF FF 1A 24 B0 94 E5 00 00 5B E3 08 00 00 0A 0B 50 A0 E1 09 00 A0 E1 04 10 85 E2 ?? ?? ?? ?? 00 00 50 E3 D9 FF FF 0A 00 50 95 E5 00 00 55 E3 F7 FF FF 1A 09 00 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 05 00 80 E2 ?? ?? ?? ?? 00 90 50 E2 21 00 00 0A 09 00 A0 E1 04 B0 80 E4 01 20 85 E2 04 10 94 E5 ?? ?? ?? ?? 24 90 84 E5 C8 FF FF EA 24 30 94 E5 00 00 53 E3 02 00 00 1A 16 00 00 EA 00 00 50 E3 0D 00 00 1A 00 00 93 E5 20 10 94 E5 24 00 84 E5 06 20 A0 E1 00 10 83 E5 04 00 83 E2 20 30 84 E5 04 10 A0 E1 78 FE FF EB 24 30 94 E5 00 00 53 E3 F1 FF FF 1A 00 00 50 E3 06 00 00 0A 28 00 94 E5 00 00 50 E3 03 00 00 0A 50 10 9F E5 ?? ?? ?? ?? 00 70 50 E2 AD FF FF 1A 00 00 A0 E3 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 38 70 9F E5 A6 FF FF EA 04 30 94 E5 04 20 9D E5 00 30 82 E5 08 20 9D E5 08 30 94 E5 00 30 82 E5 0C 20 9D E5 0C 30 94 E5 00 30 82 E5 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_10_0 {
	meta:
		name = "__getnetgrent_r"
		size = 288
		refs = "0060 __aeabi_read_tp 0080 __internal_getnetgrent_r 00e4 __lll_lock_wait_private 0114 __libc_errno"
	strings:
		$1 = { F0 43 2D E9 14 D0 4D E2 01 70 A0 E1 02 60 A0 E1 00 50 A0 E1 03 90 A0 E1 30 80 9D E5 01 10 A0 E3 E8 20 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 22 00 00 1A 04 80 8D E5 00 90 8D E5 B0 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 00 80 E0 06 20 A0 E1 08 00 8D E5 07 10 A0 E1 05 00 A0 E1 94 30 9F E5 ?? ?? ?? ?? 90 60 9F E5 00 80 A0 E1 08 50 96 E5 00 10 A0 E3 05 40 A0 E1 70 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 06 00 00 CA 08 00 A0 E1 14 D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? D9 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EF FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_11_0 {
	meta:
		name = "innetgr"
		size = 904
		refs = "00ac __nss_lookup_function 00b8 _dl_mcount_wrapper_check 00e4 __nss_next2 0144 __aeabi_read_tp 0190 __strcasecmp 01b4 strcmp 0214 __nscd_innetgr 02a0 strlen 02b4 malloc 02d0 memcpy 035c __assert_fail 0360 __nss_not_use_nscd_netgroup 0364 __libc_errno 0374 __nss_database_custom"
	strings:
		$1 = { F0 4F 2D E9 54 C3 9F E5 00 E0 9C E5 11 DD 4D E2 0C D0 4D E2 00 00 5E E3 14 00 8D E5 01 60 A0 E1 02 80 A0 E1 03 90 A0 E1 70 00 00 DA 01 E0 8E E2 64 00 5E E3 00 30 A0 C3 00 E0 8C D5 00 30 8C C5 6B 00 00 CA 00 20 A0 E3 30 30 8D E2 1C 20 8D E5 20 20 8D E5 24 20 8D E5 28 20 8D E5 2C 20 8D E5 04 20 83 E4 04 20 83 E4 04 20 83 E4 04 20 83 E4 04 20 83 E4 00 20 83 E5 14 20 9D E5 44 10 8D E2 10 10 8D E5 0C 20 8D E5 D4 72 9F E5 18 00 8D E2 10 10 9D E5 C5 FD FF EB 00 00 50 E3 13 00 00 0A 8F 00 00 EA 44 00 9D E5 B8 12 9F E5 ?? ?? ?? ?? 00 A0 50 E2 03 00 00 0A ?? ?? ?? ?? 1C 00 8D E2 0F E0 A0 E1 ?? ?? ?? ?? 00 00 55 E3 8F 00 00 1A 30 00 8D E8 05 20 A0 E1 10 00 9D E5 88 12 9F E5 18 30 8D E2 ?? ?? ?? ?? 00 00 50 E3 7C 00 00 1A 2C 30 9D E5 00 00 53 E3 93 00 00 1A 18 00 9D E5 ?? ?? ?? ?? 0C 00 9D E5 1C 10 8D E2 18 C0 9D E5 0F E0 A0 E1 ?? ?? ?? ?? 01 00 50 E3 00 40 A0 E1 00 50 A0 13 DE FF FF 1A 44 00 9D E5 3C 12 9F E5 ?? ?? ?? ?? 00 50 50 E2 D9 FF FF 0A 05 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 07 30 9F E7 03 30 80 E0 48 10 8D E2 1C 00 8D E2 01 2B A0 E3 0F E0 A0 E1 ?? ?? ?? ?? 01 00 50 E3 5B 00 00 1A 1C 30 9D E5 01 00 53 E3 2B 00 00 0A 20 00 9D E5 00 00 50 E3 05 00 00 0A 00 00 56 E3 03 00 00 0A 06 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 E7 FF FF 1A 24 00 9D E5 00 00 50 E3 05 00 00 0A 00 00 58 E3 03 00 00 0A 08 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 DE FF FF 1A 28 00 9D E5 00 00 50 E3 05 00 00 0A 00 00 59 E3 03 00 00 0A 09 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 D5 FF FF 1A 01 50 A0 E3 02 40 A0 E3 AC FF FF EA 93 FF FF 1A 78 31 9F E5 06 30 D3 E5 00 00 53 E3 8F FF FF 1A 14 00 9D E5 06 10 A0 E1 08 20 A0 E1 09 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 50 A0 A1 40 00 00 AA 86 FF FF EA 3C A0 9D E5 00 00 5A E3 20 40 9D E5 07 00 00 0A 04 00 A0 E1 04 10 8A E2 ?? ?? ?? ?? 00 00 50 E3 BB FF FF 0A 00 A0 9A E5 00 00 5A E3 F7 FF FF 1A 40 A0 9D E5 00 00 5A E3 08 00 00 0A 0A B0 A0 E1 04 00 A0 E1 04 10 8B E2 ?? ?? ?? ?? 00 00 50 E3 AF FF FF 0A 00 B0 9B E5 00 00 5B E3 F7 FF FF 1A 14 00 9D E5 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 A7 FF FF 0A 04 00 A0 E1 ?? ?? ?? ?? 00 30 A0 E1 01 20 83 E2 05 00 80 E2 08 20 8D E5 ?? ?? ?? ?? 00 B0 50 E2 08 20 9D E5 1F 00 00 0A 0B 00 A0 E1 04 A0 80 E4 04 10 A0 E1 ?? ?? ?? ?? 40 B0 8D E5 97 FF FF EA 00 50 A0 E3 C0 FF FF EA 40 30 9D E5 00 00 53 E3 12 00 00 0A 00 10 93 E5 3C 20 9D E5 40 10 8D E5 04 10 83 E2 00 20 83 E5 0C 10 8D E5 3C 30 8D E5 5E FF FF EA 01 30 55 E2 00 50 73 E2 03 50 B5 E0 3C 00 8D E2 40 10 8D E2 C1 FD FF EB 05 00 A0 E1 11 DD 8D E2 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 03 50 A0 E1 F5 FF FF EA 00 50 E0 E3 A6 FF FF EA 24 00 9F E5 24 10 9F E5 24 20 9F E5 24 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? A7 01 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_96_0_0 {
	meta:
		name = "__getsgnam_r"
		size = 436
		refs = "0054 _dl_mcount_wrapper_check 0058 __aeabi_read_tp 00c8 __nss_next2 0158 __nss_gshadow_lookup2 01a0 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 90 41 9F E5 00 C0 D4 E5 00 00 5C E3 14 D0 4D E2 00 70 A0 E1 01 60 A0 E1 02 80 A0 E1 03 90 A0 E1 47 00 00 0A 04 B0 94 E5 08 30 94 E5 01 00 7B E3 0C 30 8D E5 08 B0 8D E5 00 00 A0 13 01 00 A0 03 00 00 50 E3 39 00 00 1A 4C A1 9F E5 0C 00 9D E5 ?? ?? ?? ?? ?? ?? ?? ?? 0A 30 9F E7 03 30 80 E0 00 30 8D E5 06 10 A0 E1 08 20 A0 E1 09 30 A0 E1 00 B0 A0 E1 07 00 A0 E1 0C C0 9D E5 0F E0 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 00 50 A0 E3 02 00 74 E3 08 11 9F E5 08 00 8D E2 05 20 A0 E1 0C 30 8D E2 04 00 00 1A F8 E0 9F E5 0E C0 9F E7 0C C0 9B E7 22 00 5C E3 1E 00 00 0A 00 C0 A0 E3 00 40 8D E5 04 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 DE FF FF 0A 01 00 54 E3 0B 00 00 0A 38 E0 9D E5 00 50 8E E5 0A 00 00 9A BC 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 00 90 E7 22 00 50 E3 22 00 00 0A 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 38 20 9D E5 00 60 82 E5 94 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 50 80 E7 05 00 A0 E1 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 40 E0 E3 38 C0 9D E5 00 30 A0 E3 00 30 8C E5 E7 FF FF EA 0C 30 8D E2 0C 20 A0 E1 08 00 8D E2 48 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 0C 20 9D 05 08 30 9D 05 00 30 E0 13 08 20 84 05 04 30 84 E5 0F CA E0 E3 0F E0 A0 E1 5F F0 4C E2 01 30 A0 E3 00 30 C4 E5 AD FF FF EA 02 00 74 E3 DA FF FF 0A 16 50 A0 E3 DD FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_810_0_0 {
	meta:
		name = "__getaliasbyname_r"
		size = 436
		refs = "0054 _dl_mcount_wrapper_check 0058 __aeabi_read_tp 00c8 __nss_next2 0158 __nss_aliases_lookup2 01a0 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 90 41 9F E5 00 C0 D4 E5 00 00 5C E3 14 D0 4D E2 00 70 A0 E1 01 60 A0 E1 02 80 A0 E1 03 90 A0 E1 47 00 00 0A 04 B0 94 E5 08 30 94 E5 01 00 7B E3 0C 30 8D E5 08 B0 8D E5 00 00 A0 13 01 00 A0 03 00 00 50 E3 39 00 00 1A 4C A1 9F E5 0C 00 9D E5 ?? ?? ?? ?? ?? ?? ?? ?? 0A 30 9F E7 03 30 80 E0 00 30 8D E5 06 10 A0 E1 08 20 A0 E1 09 30 A0 E1 00 B0 A0 E1 07 00 A0 E1 0C C0 9D E5 0F E0 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 00 50 A0 E3 02 00 74 E3 08 11 9F E5 08 00 8D E2 05 20 A0 E1 0C 30 8D E2 04 00 00 1A F8 E0 9F E5 0E C0 9F E7 0C C0 9B E7 22 00 5C E3 1E 00 00 0A 00 C0 A0 E3 00 40 8D E5 04 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 DE FF FF 0A 01 00 54 E3 0B 00 00 0A 38 E0 9D E5 00 50 8E E5 0A 00 00 9A BC 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 00 90 E7 22 00 50 E3 22 00 00 0A 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 38 20 9D E5 00 60 82 E5 94 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 50 80 E7 05 00 A0 E1 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 40 E0 E3 38 C0 9D E5 00 30 A0 E3 00 30 8C E5 E7 FF FF EA 0C 30 8D E2 0C 20 A0 E1 08 00 8D E2 48 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 0C 20 9D 05 08 30 9D 05 00 30 E0 13 08 20 84 05 04 30 84 E5 0F CA E0 E3 0F E0 A0 E1 5F F0 4C E2 01 30 A0 E3 00 30 C4 E5 AD FF FF EA 02 00 74 E3 DA FF FF 0A 16 50 A0 E3 DD FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1416_0_0 {
	meta:
		name = "__getprotobyname_r"
		size = 436
		refs = "0054 _dl_mcount_wrapper_check 0058 __aeabi_read_tp 00c8 __nss_next2 0158 __nss_protocols_lookup2 01a0 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 90 41 9F E5 00 C0 D4 E5 00 00 5C E3 14 D0 4D E2 00 70 A0 E1 01 60 A0 E1 02 80 A0 E1 03 90 A0 E1 47 00 00 0A 04 B0 94 E5 08 30 94 E5 01 00 7B E3 0C 30 8D E5 08 B0 8D E5 00 00 A0 13 01 00 A0 03 00 00 50 E3 39 00 00 1A 4C A1 9F E5 0C 00 9D E5 ?? ?? ?? ?? ?? ?? ?? ?? 0A 30 9F E7 03 30 80 E0 00 30 8D E5 06 10 A0 E1 08 20 A0 E1 09 30 A0 E1 00 B0 A0 E1 07 00 A0 E1 0C C0 9D E5 0F E0 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 00 50 A0 E3 02 00 74 E3 08 11 9F E5 08 00 8D E2 05 20 A0 E1 0C 30 8D E2 04 00 00 1A F8 E0 9F E5 0E C0 9F E7 0C C0 9B E7 22 00 5C E3 1E 00 00 0A 00 C0 A0 E3 00 40 8D E5 04 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 DE FF FF 0A 01 00 54 E3 0B 00 00 0A 38 E0 9D E5 00 50 8E E5 0A 00 00 9A BC 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 00 90 E7 22 00 50 E3 22 00 00 0A 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 38 20 9D E5 00 60 82 E5 94 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 50 80 E7 05 00 A0 E1 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 40 E0 E3 38 C0 9D E5 00 30 A0 E3 00 30 8C E5 E7 FF FF EA 0C 30 8D E2 0C 20 A0 E1 08 00 8D E2 48 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 0C 20 9D 05 08 30 9D 05 00 30 E0 13 08 20 84 05 04 30 84 E5 0F CA E0 E3 0F E0 A0 E1 5F F0 4C E2 01 30 A0 E3 00 30 C4 E5 AD FF FF EA 02 00 74 E3 DA FF FF 0A 16 50 A0 E3 DD FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1278_0_0 {
	meta:
		name = "__getprotobynumber_r"
		size = 436
		refs = "0054 _dl_mcount_wrapper_check 0058 __aeabi_read_tp 00c8 __nss_next2 0158 __nss_protocols_lookup2 01a0 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 90 41 9F E5 00 C0 D4 E5 00 00 5C E3 14 D0 4D E2 00 70 A0 E1 01 60 A0 E1 02 80 A0 E1 03 90 A0 E1 47 00 00 0A 04 B0 94 E5 08 30 94 E5 01 00 7B E3 0C 30 8D E5 08 B0 8D E5 00 00 A0 13 01 00 A0 03 00 00 50 E3 39 00 00 1A 4C A1 9F E5 0C 00 9D E5 ?? ?? ?? ?? ?? ?? ?? ?? 0A 30 9F E7 03 30 80 E0 00 30 8D E5 06 10 A0 E1 08 20 A0 E1 09 30 A0 E1 00 B0 A0 E1 07 00 A0 E1 0C C0 9D E5 0F E0 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 00 50 A0 E3 02 00 74 E3 08 11 9F E5 08 00 8D E2 05 20 A0 E1 0C 30 8D E2 04 00 00 1A F8 E0 9F E5 0E C0 9F E7 0C C0 9B E7 22 00 5C E3 1E 00 00 0A 00 C0 A0 E3 00 40 8D E5 04 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 DE FF FF 0A 01 00 54 E3 0B 00 00 0A 38 E0 9D E5 00 50 8E E5 0A 00 00 9A BC 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 00 90 E7 22 00 50 E3 22 00 00 0A 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 38 20 9D E5 00 60 82 E5 94 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 50 80 E7 05 00 A0 E1 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 40 E0 E3 38 C0 9D E5 00 30 A0 E3 00 30 8C E5 E7 FF FF EA 0C 30 8D E2 0C 20 A0 E1 08 00 8D E2 48 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 0C 20 9D 05 08 30 9D 05 00 30 E0 13 08 20 84 05 04 30 84 E5 0F CA E0 E3 0F E0 A0 E1 5F F0 4C E2 01 30 A0 E3 00 30 C4 E5 AD FF FF EA 02 00 74 E3 DA FF FF 0A 16 50 A0 E3 DD FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_380_0_0 {
	meta:
		name = "__getrpcbyname_r"
		size = 436
		refs = "0054 _dl_mcount_wrapper_check 0058 __aeabi_read_tp 00c8 __nss_next2 0158 __nss_rpc_lookup2 01a0 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 90 41 9F E5 00 C0 D4 E5 00 00 5C E3 14 D0 4D E2 00 70 A0 E1 01 60 A0 E1 02 80 A0 E1 03 90 A0 E1 47 00 00 0A 04 B0 94 E5 08 30 94 E5 01 00 7B E3 0C 30 8D E5 08 B0 8D E5 00 00 A0 13 01 00 A0 03 00 00 50 E3 39 00 00 1A 4C A1 9F E5 0C 00 9D E5 ?? ?? ?? ?? ?? ?? ?? ?? 0A 30 9F E7 03 30 80 E0 00 30 8D E5 06 10 A0 E1 08 20 A0 E1 09 30 A0 E1 00 B0 A0 E1 07 00 A0 E1 0C C0 9D E5 0F E0 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 00 50 A0 E3 02 00 74 E3 08 11 9F E5 08 00 8D E2 05 20 A0 E1 0C 30 8D E2 04 00 00 1A F8 E0 9F E5 0E C0 9F E7 0C C0 9B E7 22 00 5C E3 1E 00 00 0A 00 C0 A0 E3 00 40 8D E5 04 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 DE FF FF 0A 01 00 54 E3 0B 00 00 0A 38 E0 9D E5 00 50 8E E5 0A 00 00 9A BC 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 00 90 E7 22 00 50 E3 22 00 00 0A 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 38 20 9D E5 00 60 82 E5 94 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 50 80 E7 05 00 A0 E1 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 40 E0 E3 38 C0 9D E5 00 30 A0 E3 00 30 8C E5 E7 FF FF EA 0C 30 8D E2 0C 20 A0 E1 08 00 8D E2 48 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 0C 20 9D 05 08 30 9D 05 00 30 E0 13 08 20 84 05 04 30 84 E5 0F CA E0 E3 0F E0 A0 E1 5F F0 4C E2 01 30 A0 E3 00 30 C4 E5 AD FF FF EA 02 00 74 E3 DA FF FF 0A 16 50 A0 E3 DD FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1503_0_0 {
	meta:
		name = "__getrpcbynumber_r"
		size = 436
		refs = "0054 _dl_mcount_wrapper_check 0058 __aeabi_read_tp 00c8 __nss_next2 0158 __nss_rpc_lookup2 01a0 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 90 41 9F E5 00 C0 D4 E5 00 00 5C E3 14 D0 4D E2 00 70 A0 E1 01 60 A0 E1 02 80 A0 E1 03 90 A0 E1 47 00 00 0A 04 B0 94 E5 08 30 94 E5 01 00 7B E3 0C 30 8D E5 08 B0 8D E5 00 00 A0 13 01 00 A0 03 00 00 50 E3 39 00 00 1A 4C A1 9F E5 0C 00 9D E5 ?? ?? ?? ?? ?? ?? ?? ?? 0A 30 9F E7 03 30 80 E0 00 30 8D E5 06 10 A0 E1 08 20 A0 E1 09 30 A0 E1 00 B0 A0 E1 07 00 A0 E1 0C C0 9D E5 0F E0 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 00 50 A0 E3 02 00 74 E3 08 11 9F E5 08 00 8D E2 05 20 A0 E1 0C 30 8D E2 04 00 00 1A F8 E0 9F E5 0E C0 9F E7 0C C0 9B E7 22 00 5C E3 1E 00 00 0A 00 C0 A0 E3 00 40 8D E5 04 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 DE FF FF 0A 01 00 54 E3 0B 00 00 0A 38 E0 9D E5 00 50 8E E5 0A 00 00 9A BC 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 00 90 E7 22 00 50 E3 22 00 00 0A 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 38 20 9D E5 00 60 82 E5 94 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 50 80 E7 05 00 A0 E1 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 40 E0 E3 38 C0 9D E5 00 30 A0 E3 00 30 8C E5 E7 FF FF EA 0C 30 8D E2 0C 20 A0 E1 08 00 8D E2 48 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 0C 20 9D 05 08 30 9D 05 00 30 E0 13 08 20 84 05 04 30 84 E5 0F CA E0 E3 0F E0 A0 E1 5F F0 4C E2 01 30 A0 E3 00 30 C4 E5 AD FF FF EA 02 00 74 E3 DA FF FF 0A 16 50 A0 E3 DD FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_851_0_0 {
	meta:
		name = "__getspnam_r"
		size = 436
		refs = "0054 _dl_mcount_wrapper_check 0058 __aeabi_read_tp 00c8 __nss_next2 0158 __nss_shadow_lookup2 01a0 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 90 41 9F E5 00 C0 D4 E5 00 00 5C E3 14 D0 4D E2 00 70 A0 E1 01 60 A0 E1 02 80 A0 E1 03 90 A0 E1 47 00 00 0A 04 B0 94 E5 08 30 94 E5 01 00 7B E3 0C 30 8D E5 08 B0 8D E5 00 00 A0 13 01 00 A0 03 00 00 50 E3 39 00 00 1A 4C A1 9F E5 0C 00 9D E5 ?? ?? ?? ?? ?? ?? ?? ?? 0A 30 9F E7 03 30 80 E0 00 30 8D E5 06 10 A0 E1 08 20 A0 E1 09 30 A0 E1 00 B0 A0 E1 07 00 A0 E1 0C C0 9D E5 0F E0 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 00 50 A0 E3 02 00 74 E3 08 11 9F E5 08 00 8D E2 05 20 A0 E1 0C 30 8D E2 04 00 00 1A F8 E0 9F E5 0E C0 9F E7 0C C0 9B E7 22 00 5C E3 1E 00 00 0A 00 C0 A0 E3 00 40 8D E5 04 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 DE FF FF 0A 01 00 54 E3 0B 00 00 0A 38 E0 9D E5 00 50 8E E5 0A 00 00 9A BC 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 00 90 E7 22 00 50 E3 22 00 00 0A 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 38 20 9D E5 00 60 82 E5 94 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 50 80 E7 05 00 A0 E1 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 40 E0 E3 38 C0 9D E5 00 30 A0 E3 00 30 8C E5 E7 FF FF EA 0C 30 8D E2 0C 20 A0 E1 08 00 8D E2 48 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 0C 20 9D 05 08 30 9D 05 00 30 E0 13 08 20 84 05 04 30 84 E5 0F CA E0 E3 0F E0 A0 E1 5F F0 4C E2 01 30 A0 E3 00 30 C4 E5 AD FF FF EA 02 00 74 E3 DA FF FF 0A 16 50 A0 E3 DD FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "__getsockname"
		size = 28
		refs = "0018 __syscall_error"
		altNames = "__bind __dup3 __getpeername __msgget __pipe2 __semget __semop __shmat __shmdt __shmget __shutdown __socket epoll_create1 fanotify_init inotify_add_watch inotify_rm_watch prlimit64 setns syncfs timerfd_create timerfd_gettime timerfd_settime unshare"
	strings:
		$1 = { 04 70 2D E5 10 70 9F E5 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "__openat64_2"
		size = 36
		refs = "000c __openat64 001c __fortify_fail"
	strings:
		$1 = { 40 00 12 E3 08 40 2D E9 02 00 00 1A ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? 00 00 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_952_0_0 {
	meta:
		name = "__openat_2"
		size = 36
		refs = "000c __openat 001c __fortify_fail"
	strings:
		$1 = { 40 00 12 E3 08 40 2D E9 02 00 00 1A ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? 00 00 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "__getlogin_r_chk"
		size = 28
		refs = "000c getlogin_r 0018 __chk_fail"
	strings:
		$1 = { 02 00 51 E1 08 40 2D E9 02 00 00 8A ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1448_0_0 {
	meta:
		name = "__getcwd_chk"
		size = 28
		refs = "000c __getcwd 0018 __chk_fail"
	strings:
		$1 = { 02 00 51 E1 08 40 2D E9 02 00 00 8A ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_854_0_0 {
	meta:
		name = "__getdomainname_chk"
		size = 28
		refs = "000c getdomainname 0018 __chk_fail"
	strings:
		$1 = { 02 00 51 E1 08 40 2D E9 02 00 00 8A ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_849_0_0 {
	meta:
		name = "__gethostname_chk"
		size = 28
		refs = "000c __gethostname 0018 __chk_fail"
	strings:
		$1 = { 02 00 51 E1 08 40 2D E9 02 00 00 8A ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "semtimedop"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 4E 7F A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "__vswprintf_chk"
		size = 200
		refs = "0044 _IO_no_init 0050 _IO_fwide 0078 _IO_wstr_init_static 0088 _IO_vfwprintf 00c0 __chk_fail 00c4 _IO_wstrn_jumps"
	strings:
		$1 = { F0 40 2D E9 01 00 53 E1 9D DF 4D E2 01 40 A0 E1 00 60 A0 E1 02 70 A0 E1 28 00 00 3A 00 50 A0 E3 00 00 51 E3 10 51 8D E5 22 00 00 0A 90 30 9F E5 05 20 A0 E1 00 30 8D E5 C8 00 8D E2 0C 30 8D E2 02 19 A0 E3 ?? ?? ?? ?? 01 10 A0 E3 C8 00 8D E2 ?? ?? ?? ?? 00 00 57 E3 04 31 9D C5 04 30 83 C3 04 31 8D C5 06 10 A0 E1 06 30 A0 E1 01 20 44 E2 C8 00 8D E2 00 50 86 E5 ?? ?? ?? ?? A2 1F 8D E2 06 00 91 E8 C8 00 8D E2 ?? ?? ?? ?? 24 31 9D E5 18 10 93 E5 17 2E 8D E2 02 00 51 E1 05 00 00 0A 10 30 93 E5 00 20 A0 E3 00 20 83 E5 9D DF 8D E2 F0 40 BD E8 ?? ?? ?? ?? 00 00 E0 E3 FA FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_0_0 {
	meta:
		name = "__swapoff"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 73 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_0_0 {
	meta:
		name = "__gmtime_r"
		size = 24
		refs = "000c __tz_convert"
	strings:
		$1 = { 08 40 2D E9 01 20 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_692_0_0 {
	meta:
		name = "__aeabi_memclr"
		size = 24
		refs = "000c memset"
	strings:
		$1 = { 08 40 2D E9 01 20 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1293_0_0 {
	meta:
		name = "mkostemp"
		size = 28
		refs = "0010 __gen_tempname"
	strings:
		$1 = { 08 40 2D E9 01 20 A0 E1 00 10 A0 E3 01 30 A0 E1 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_1_0 {
	meta:
		name = "gmtime"
		size = 28
		refs = "000c __tz_convert 0018 _tmbuf"
	strings:
		$1 = { 08 40 2D E9 00 10 A0 E3 08 20 9F E5 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_0_0 {
	meta:
		name = "__rmdir"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 28 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "read_int"
		size = 116
	strings:
		$1 = { 30 00 2D E9 00 20 90 E5 00 30 D2 E5 5C 50 9F E5 30 30 43 E2 0C 00 00 EA 00 00 53 E3 09 00 00 BA 03 41 83 E0 02 C1 E0 E3 05 00 53 E1 84 40 A0 E1 0C C0 62 E0 02 00 00 CA 0C 00 54 E1 02 30 84 D0 00 00 00 DA 00 30 E0 E3 01 20 A0 E1 01 10 82 E2 00 10 80 E5 01 20 D2 E5 30 20 42 E2 09 00 52 E3 EC FF FF 9A 03 00 A0 E1 30 00 BD E8 ?? ?? ?? ?? CC CC CC 0C }
	condition:
		$1
}

rule file_106_1_0 {
	meta:
		name = "__parse_one_specmb"
		size = 2112
		refs = "05d8 __strchrnul 07dc __handle_registered_modifier_mb 0830 __printf_modifier_table 0834 __printf_function_table 083c __printf_arginfo_table"
	strings:
		$1 = { F0 43 2D E9 0C C0 D2 E5 02 40 A0 E1 0D 20 D2 E5 00 80 A0 E1 00 50 E0 E3 F2 20 02 E2 01 90 88 E2 0C D0 4D E2 07 C0 0C E2 20 00 A0 E3 0D 20 C4 E5 24 50 84 E5 0C C0 C4 E5 10 00 84 E5 04 90 8D E5 01 50 D8 E5 30 20 45 E2 09 00 52 E3 01 60 A0 E1 03 70 A0 E1 09 20 A0 81 F2 00 00 9A 30 30 A0 E3 20 00 45 E2 02 C0 A0 E1 29 00 50 E3 00 F1 9F 97 4A 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 0D 10 D4 E5 08 10 81 E3 0D 10 C4 E5 01 00 82 E2 04 00 8D E5 01 50 D2 E5 00 00 55 E3 00 C0 A0 E1 17 00 00 0A 00 20 A0 E1 C5 FF FF EA 10 30 84 E5 F5 FF FF EA 0C 10 D4 E5 20 10 81 E3 0C 10 C4 E5 F1 FF FF EA 0C 10 D4 E5 40 10 81 E3 0C 10 C4 E5 ED FF FF EA 0C 10 D4 E5 80 10 81 E3 0C 10 C4 E5 E9 FF FF EA 0C 10 D4 E5 08 10 81 E3 0C 10 C4 E5 E5 FF FF EA 0C 10 D4 E5 10 10 81 E3 0C 10 C4 E5 E1 FF FF EA 0C 30 D4 E5 20 00 13 E3 20 30 A0 13 10 30 84 15 00 50 A0 E3 00 30 E0 E3 20 30 84 E5 04 50 84 E5 00 30 DC E5 2A 00 53 E3 B3 00 00 0A 30 30 43 E2 09 00 53 E3 BC 00 00 9A 00 30 E0 E3 1C 30 84 E5 00 30 84 E5 00 30 DC E5 2E 00 53 E3 99 00 00 0A 0D 30 D4 E5 02 30 C3 E3 0D 30 C4 E5 2C 36 9F E5 0C 10 D4 E5 00 30 93 E5 F8 10 01 E2 00 20 A0 E3 00 00 53 E3 0C 10 C4 E5 BE 20 C4 E1 68 01 00 1A 01 20 8C E2 04 20 8D E5 00 30 DC E5 4C 30 43 E2 2E 00 53 E3 03 F1 9F 97 2B 01 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 0C 30 D4 E5 FA 30 03 E2 0C 30 C4 E5 02 10 8C E2 02 C0 A0 E1 20 35 9F E5 04 10 8D E5 00 20 93 E5 00 30 DC E5 00 00 52 E3 00 20 E0 E3 08 30 84 E5 30 20 84 E5 2F 01 00 1A 01 10 A0 E3 41 20 43 E2 2C 10 84 E5 37 00 52 E3 02 F1 9F 97 EA 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 8D E2 D6 FE FF EB 00 00 50 E3 03 00 00 0A 04 30 9D E5 00 20 D3 E5 24 00 52 E3 B9 00 00 0A 04 90 8D E5 09 20 A0 E1 01 50 D8 E5 00 FF FF EA 01 20 8C E2 04 20 8D E5 01 30 DC E5 2A 00 53 E3 A4 00 00 0A 30 30 43 E2 09 00 53 E3 00 30 A0 83 00 30 84 85 02 C0 A0 81 5A FF FF 8A 04 00 8D E2 BF FE FF EB 01 00 70 E3 00 00 84 15 04 C0 9D E5 54 FF FF EA 01 50 8C E2 04 50 8D E5 01 30 DC E5 30 30 43 E2 09 00 53 E3 75 00 00 9A 20 60 84 E5 04 50 8D E5 05 C0 A0 E1 01 60 86 E2 01 50 A0 E3 42 FF FF EA 04 00 8D E2 AD FE FF EB 01 00 70 E3 04 00 84 15 04 C0 9D E5 3C FF FF EA 02 C0 A0 E1 0C 30 D4 E5 01 30 83 E3 0C 30 C4 E5 01 10 8C E2 83 FF FF EA 01 30 DC E5 68 00 53 E3 0C 30 D4 15 0D 30 D4 05 02 30 83 13 02 30 83 03 02 10 8C 12 03 10 8C 02 0C 30 C4 15 02 C0 A0 11 0D 30 C4 05 02 C0 8C 02 76 FF FF EA 0C 30 D4 E5 05 30 83 E3 02 10 8C E2 0C 30 C4 E5 02 C0 A0 E1 70 FF FF EA 0C 30 D4 E5 04 30 83 E3 0C 30 C4 E5 01 30 DC E5 6C 00 53 E3 7F 00 00 0A 02 10 8C E2 02 C0 A0 E1 67 FF FF EA 0C 20 D4 E5 01 00 12 E3 01 2C A0 13 28 20 84 15 0D 00 00 1A 04 00 12 E3 02 2C A0 13 28 20 84 15 09 00 00 1A 02 00 12 E3 01 2B A0 13 28 20 84 15 05 00 00 1A 0D 20 D4 E5 A2 20 A0 E1 01 20 12 E2 34 00 00 0A 01 20 A0 E3 28 20 84 E5 24 20 94 E5 01 00 72 E3 0F 00 00 0A 00 00 53 E3 13 00 00 0A 04 00 9D E5 25 10 A0 E3 14 00 84 E5 ?? ?? ?? ?? 18 00 84 E5 05 00 A0 E1 0C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 05 20 A0 E3 28 20 84 E5 24 20 94 E5 01 00 72 E3 EF FF FF 1A 2C 20 94 E5 00 00 52 E3 24 60 84 15 02 50 85 10 00 00 53 E3 EB FF FF 1A 04 30 9D E5 05 00 A0 E1 01 30 43 E2 18 30 84 E5 14 30 84 E5 0C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 02 2B A0 E3 28 20 84 E5 DB FF FF EA 03 20 A0 E3 28 20 84 E5 D8 FF FF EA 04 20 A0 E3 28 20 84 E5 D5 FF FF EA 02 20 A0 E3 28 20 84 E5 D2 FF FF EA 0C 20 D4 E5 01 00 12 E3 07 20 A0 03 28 20 84 05 CD FF FF 0A B0 21 9F E5 28 20 84 E5 CA FF FF EA 04 00 8D E2 3D FE FF EB 00 00 50 E3 0D 00 00 0A 04 30 9D E5 00 20 D3 E5 24 00 52 E3 09 00 00 1A 01 00 70 E3 05 00 00 0A 01 20 40 E2 20 20 84 E5 00 20 97 E5 00 00 52 E1 00 20 87 25 00 00 87 35 01 30 83 E2 04 30 8D E5 20 30 94 E5 00 00 53 E3 74 FF FF BA 04 C0 9D E5 00 50 A0 E3 BA FE FF EA 02 10 A0 E1 05 FF FF EA 00 20 A0 E3 2C 20 84 E5 AD FF FF EA 02 80 8C E2 04 80 8D E5 02 30 DC E5 30 30 43 E2 09 00 53 E3 13 00 00 9A 1C 60 84 E5 01 50 85 E2 04 80 8D E5 08 C0 A0 E1 01 60 86 E2 AF FE FF EA 01 20 83 E2 01 00 70 E3 04 20 8D E5 05 00 00 0A 01 10 40 E2 24 10 84 E5 00 10 97 E5 00 00 51 E1 00 10 87 25 00 00 87 35 01 50 D3 E5 3E FE FF EA 02 C0 8C E2 5F FF FF EA 04 00 8D E2 06 FE FF EB 00 00 50 E3 03 00 00 0A 04 30 9D E5 00 20 D3 E5 24 00 52 E3 03 00 00 0A 1C 30 94 E5 00 00 53 E3 3F FF FF AA DF FF FF EA 01 00 70 E3 05 00 00 0A 01 20 40 E2 1C 20 84 E5 00 20 97 E5 00 00 52 E1 00 20 87 25 00 00 87 35 01 30 83 E2 04 30 8D E5 F0 FF FF EA 00 20 DC E5 02 31 93 E7 00 00 53 E3 92 FE FF 0A 04 00 8D E2 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 C0 9D E5 8C FE FF 1A 40 FF FF EA 44 20 9F E5 00 20 92 E5 03 C1 92 E7 00 00 5C E3 CA FE FF 0A 30 30 84 E2 04 00 A0 E1 01 10 A0 E3 28 20 84 E2 0F E0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 2C 00 84 E5 08 30 94 E5 62 FF FF AA BF FE FF EA ?? ?? ?? ?? ?? ?? ?? ?? 07 01 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_107_0_0 {
	meta:
		name = "__flock"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 8F 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "putgrent"
		size = 852
		refs = "002c __aeabi_read_tp 00b8 fprintf 02fc __lll_lock_wait_private 030c __overflow 0350 __libc_errno"
	strings:
		$1 = { F0 41 2D E9 00 60 50 E2 08 D0 4D E2 01 50 A0 E1 97 00 00 0A 00 00 51 E3 95 00 00 0A 00 40 91 E5 02 49 14 E2 18 00 00 1A 48 70 91 E5 ?? ?? ?? ?? 08 30 97 E5 13 8D 40 E2 08 00 53 E1 0F 00 00 0A 01 10 A0 E3 07 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 A0 00 00 1A 48 30 95 E5 08 80 83 E5 03 70 A0 E1 04 30 97 E5 01 30 83 E2 04 30 87 E5 00 20 96 E5 00 30 D2 E5 2B 00 53 E3 2D 00 53 13 04 30 96 E5 6A 00 00 1A 90 12 9F E5 00 00 53 E3 01 30 A0 01 05 00 A0 E1 84 12 9F E5 ?? ?? ?? ?? 00 00 50 E3 72 00 00 BA 0C 30 96 E5 00 00 53 E3 32 00 00 0A 00 20 93 E5 00 00 52 E3 2F 00 00 0A 60 82 9F E5 60 72 9F E5 00 40 A0 E3 03 00 00 EA 0C 30 96 E5 04 21 93 E7 00 00 52 E3 27 00 00 0A 00 00 54 E3 08 10 A0 11 07 10 A0 01 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 01 40 84 E2 F3 FF FF AA 00 30 95 E5 02 09 13 E3 17 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 11 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 63 00 00 CA 00 60 E0 E3 06 00 A0 E1 08 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 14 30 95 E5 18 20 95 E5 02 00 53 E1 55 00 00 2A 01 10 83 E2 0A 20 A0 E3 14 10 85 E5 00 20 C3 E5 00 60 A0 E3 00 30 95 E5 02 09 13 E3 EF FF FF 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 E9 FF FF 1A 08 30 85 E5 00 70 95 E5 00 10 A0 E3 07 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 57 E1 F0 FF FF 1A 01 00 57 E3 D7 FF FF DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF CE FF FF EA 08 10 96 E5 E0 00 9F E5 00 00 53 E3 00 30 A0 01 00 10 8D E5 05 00 A0 E1 DC 10 9F E5 ?? ?? ?? ?? 91 FF FF EA D4 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 00 60 E0 E3 BE FF FF EA 00 30 95 E5 02 09 13 E3 BA FF FF 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 B4 FF FF 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 A2 FF FF 0A EF FF FF EA 07 00 A0 E1 ?? ?? ?? ?? 5B FF FF EA 05 00 A0 E1 0A 10 A0 E3 ?? ?? ?? ?? C0 6F A0 E1 A9 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 92 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "svc_exit"
		size = 44
		refs = "0004 __rpc_thread_svc_pollfd 0014 free 001c __rpc_thread_svc_max_pollfd"
	strings:
		$1 = { 38 40 2D E9 ?? ?? ?? ?? 00 40 A0 E3 00 50 A0 E1 00 00 90 E5 ?? ?? ?? ?? 00 40 85 E5 ?? ?? ?? ?? 00 40 80 E5 38 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_109_1_0 {
	meta:
		name = "svc_run"
		size = 324
		refs = "0004 __rpc_thread_svc_max_pollfd 0028 __rpc_thread_svc_pollfd 0048 realloc 00ac __poll 00c8 svc_getreq_poll 00d8 __aeabi_read_tp 00f8 __dcgettext 00fc perror 0104 free 0134 __libc_errno 013c _libc_intl_domainname"
	strings:
		$1 = { F0 47 2D E9 ?? ?? ?? ?? 00 50 A0 E3 20 71 9F E5 05 40 A0 E1 05 80 A0 E1 00 60 A0 E1 00 A0 96 E5 00 00 5A E3 03 00 00 1A ?? ?? ?? ?? 00 30 90 E5 00 00 53 E3 31 00 00 0A 0A 00 55 E1 23 00 00 0A 04 00 A0 E1 8A 11 A0 E1 ?? ?? ?? ?? 00 00 50 E3 2E 00 00 0A 00 40 A0 E1 0A 90 A0 E1 0A 50 A0 E1 00 00 5A E3 0D 00 00 DA ?? ?? ?? ?? 00 10 90 E5 8A E1 A0 E1 00 C0 A0 E3 01 20 A0 E1 0C 00 B2 E7 04 30 A0 E1 0C 00 A3 E7 08 C0 8C E2 B4 20 D2 E1 0E 00 5C E1 B4 20 C3 E1 B6 80 C3 E1 F5 FF FF 1A 09 10 A0 E1 04 00 A0 E1 00 20 E0 E3 ?? ?? ?? ?? 01 00 70 E3 07 00 00 0A 00 00 50 E3 D6 FF FF 0A 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? D2 FF FF EA 05 90 A0 E1 E1 FF FF EA ?? ?? ?? ?? 07 30 9F E7 03 30 90 E7 04 00 53 E3 CB FF FF 0A 44 10 9F E5 05 20 A0 E3 40 00 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? F0 47 BD E8 ?? ?? ?? ?? 28 10 9F E5 05 20 A0 E3 1C 00 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? F0 47 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_110_0_0 {
	meta:
		name = "_dl_important_hwcaps"
		size = 2016
		refs = "01c0 memcmp 0284 strlen 03d0 malloc 042c mempcpy 07a0 _dl_signal_error 07b4 __assert_fail 07b8 _dl_hwcap 07bc _dl_hwcap_mask 07c0 _dl_sysinfo_map 07c8 _dl_arm_cap_flags"
	strings:
		$1 = { F0 4F 2D E9 AC 57 9F E5 20 B0 8D E2 A8 97 9F E5 64 D0 4D E2 30 00 95 E8 00 03 99 E8 00 C0 90 E2 54 80 0B E5 50 90 0B E5 04 80 08 E0 05 90 09 E0 01 C0 A0 13 09 E0 98 E1 4C 40 0B E5 48 50 0B E5 44 00 0B E5 2C 80 0B E5 28 90 0B E5 40 C0 0B E5 5C 10 0B E5 60 20 0B E5 58 30 0B E5 3C C0 0B E5 21 00 00 0A 00 30 A0 E3 03 10 A0 E1 01 00 A0 E3 03 E0 A0 E1 2C 60 1B E5 36 4E A0 E1 28 70 1B E5 20 60 6E E2 01 10 81 E2 17 46 84 E1 37 5E A0 E1 20 60 4E E2 20 E0 41 E2 10 3E A0 E1 37 46 84 E1 20 E0 61 E2 30 3E 83 E1 10 21 A0 E1 01 60 A0 E3 00 70 A0 E3 04 60 06 E0 05 70 07 E0 07 80 96 E1 2C 90 4B E2 00 03 99 E8 01 C0 8C 12 00 60 72 E2 00 70 E3 E2 08 60 06 E0 09 70 07 E0 07 90 96 E1 01 E0 A0 E1 E2 FF FF 1A 3C C0 0B E5 CC 36 9F E5 00 30 93 E5 00 00 53 E3 38 30 0B E5 37 00 00 0A 38 C0 1B E5 56 3F A0 E3 B3 A0 9C E1 00 00 5A E3 50 81 9C E5 31 00 00 0A 00 90 A0 E3 03 00 00 EA 01 90 89 E2 09 00 5A E1 20 80 88 E2 2B 00 00 9A 00 30 98 E5 04 00 53 E3 F8 FF FF 1A 38 40 1B E5 08 50 98 E5 00 30 94 E5 14 60 98 E5 03 50 85 E0 0C 00 56 E3 05 40 A0 E1 0C 00 85 E2 0C 00 00 8A EE FF FF EA 0C 00 94 E8 03 20 82 E2 03 30 83 E2 03 20 C2 E3 03 30 C3 E3 03 30 82 E0 0C 30 83 E2 03 40 84 E0 0C 00 84 E2 00 30 65 E0 03 00 56 E1 E2 FF FF 9A 08 30 94 E5 02 00 53 E3 F0 FF FF 1A 00 70 94 E5 04 00 57 E3 02 00 00 0A 07 20 A0 E1 04 30 94 E5 EB FF FF EA 04 16 9F E5 07 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F7 FF FF 1A 04 30 94 E5 0A 00 53 E3 24 01 00 8A 07 20 A0 E1 E1 FF FF EA 3C 50 1B E5 01 60 85 E2 86 31 A0 E1 08 30 83 E2 03 D0 4D E0 38 D0 0B E5 01 30 A0 E3 00 90 A0 E3 2C 50 4B E2 30 00 95 E8 05 50 94 E1 52 01 00 0A 00 50 A0 E3 3C 60 0B E5 05 10 A0 E1 A4 45 9F E5 2C 60 4B E2 60 00 96 E8 01 70 A0 E3 09 A0 A0 E1 35 81 A0 E1 20 00 61 E2 16 80 88 E1 20 E0 41 E2 36 8E 88 E1 36 91 A0 E1 01 20 A0 E3 00 30 A0 E3 08 20 02 E0 09 30 03 E0 03 C0 92 E1 14 00 00 0A 17 EE A0 E1 37 00 8E E1 01 31 81 E0 38 C0 1B E5 83 30 84 E0 8A 31 8C E7 30 00 0B E5 03 00 A0 E1 78 10 0B E5 ?? ?? ?? ?? 78 10 1B E5 17 E1 A0 E1 38 C0 1B E5 34 E0 0B E5 8A 31 8C E0 04 00 83 E5 34 30 4B E2 0C 00 93 E8 01 A0 8A E2 02 50 25 E0 03 60 26 E0 06 30 95 E1 01 10 81 E2 DB FF FF 1A 01 40 8A E2 3C 60 1B E5 3C 40 0B E5 0A 90 A0 E1 40 50 1B E5 00 00 55 E3 38 70 1B 15 3C 30 1B 05 44 80 1B 15 3C 90 0B 05 89 81 87 17 89 21 87 10 3C 50 1B E5 3C 90 1B 15 5C C0 1B 15 38 70 1B E5 01 30 89 12 85 41 A0 E1 BC 14 9F E5 04 C0 82 15 03 00 56 E1 03 20 A0 E3 04 30 87 E0 85 11 87 E7 04 20 83 E5 1E 01 00 1A 01 00 56 E3 AB 00 00 0A 38 C0 1B E5 04 C0 9C E5 02 00 56 E3 2C C0 0B E5 05 00 8C E2 19 00 00 9A 80 10 A0 E1 02 30 A0 E3 01 00 A0 E3 38 C0 1B E5 01 00 00 EA 03 00 A0 E1 02 30 A0 E1 80 21 8C E0 04 00 92 E5 01 20 83 E2 01 00 80 E2 02 00 56 E1 00 10 81 E0 F6 FF FF 1A 03 00 56 E3 06 00 00 0A 1F 00 56 E3 FF 00 00 8A 3C 50 1B E5 40 20 81 E2 22 30 65 E2 32 33 B0 E1 FA 00 00 1A 3C 70 1B E5 02 30 47 E2 11 03 A0 E1 01 50 A0 E3 15 76 A0 E1 40 70 0B E5 40 80 1B E5 60 90 1B E5 87 71 A0 E1 00 80 89 E5 07 00 80 E0 ?? ?? ?? ?? 00 80 50 E2 EC 00 00 0A 07 00 88 E0 02 00 56 E3 00 00 88 E5 08 00 88 E5 DC 00 00 0A 3C 70 1B E5 15 97 A0 E1 38 30 1B E5 04 C0 93 E6 01 40 47 E2 34 40 0B E5 4C 60 0B E5 05 A0 A0 E1 44 80 0B E5 09 50 A0 E1 2F 70 A0 E3 0C 80 A0 E1 03 90 A0 E1 A0 13 9F E5 03 20 A0 E3 ?? ?? ?? ?? 02 50 45 E2 01 70 C0 E4 09 60 A0 E1 34 40 1B E5 02 00 00 EA 01 40 54 E2 08 60 46 E2 07 00 00 0A 1A C4 15 E0 FA FF FF 0A 06 00 16 E9 ?? ?? ?? ?? 01 40 54 E2 01 70 C0 E4 08 60 46 E2 F7 FF FF 1A 08 10 A0 E1 2C 20 1B E5 ?? ?? ?? ?? 00 00 55 E3 01 70 C0 E4 E6 FF FF 1A 44 80 1B E5 4C 60 1B E5 01 30 A0 E3 13 06 B0 E1 00 30 A0 13 80 01 A0 11 03 10 A0 11 04 00 00 0A 03 20 88 E0 08 30 83 E2 00 00 53 E1 04 10 82 E5 FA FF FF 1A 38 30 1B E5 40 70 1B E5 86 C1 83 E0 01 40 A0 E3 00 00 57 E3 01 60 46 E2 14 16 A0 E1 08 20 88 12 07 30 A0 11 0E 00 00 0A 01 30 43 E2 03 00 11 E1 08 00 00 0A 04 00 1C E5 04 50 12 E5 01 00 80 E2 01 30 43 E2 00 00 85 E0 03 00 11 E1 04 00 02 E5 08 20 82 E2 F6 FF FF 1A 00 00 53 E3 08 20 82 E2 F0 FF FF 1A 00 00 56 E3 08 C0 4C E2 E7 FF FF 1A 3C 30 1B E5 01 40 A0 E3 14 43 A0 E1 40 50 1B E5 02 30 45 E2 04 00 53 E1 10 20 88 E2 15 00 00 0A 18 00 88 E2 02 10 A0 E1 08 60 88 E2 08 50 A0 E1 01 30 43 E2 01 C0 68 E0 01 00 13 E3 05 C0 8C 10 06 C0 8C 00 10 70 4C 12 80 10 97 18 0C C0 87 10 10 C0 1C 05 04 00 53 E1 08 C0 00 E5 08 10 81 E2 08 00 80 E2 F1 FF FF 1A 40 90 1B E5 2E 12 49 E2 01 10 63 E0 81 21 82 E0 3C C0 1B E5 07 00 E0 E3 10 0C A0 E1 00 10 92 E7 01 30 53 E2 04 10 81 E2 08 10 82 E4 FA FF FF 1A 04 30 98 E5 58 40 1B E5 08 00 A0 E1 00 30 84 E5 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 38 80 1B E5 60 90 1B E5 04 40 98 E5 02 50 A0 E3 11 00 84 E2 00 50 89 E5 ?? ?? ?? ?? 00 80 50 E2 01 30 84 E2 61 00 00 0A 04 30 88 E5 60 90 1B E5 00 30 A0 E3 00 C0 99 E5 0C 30 88 E5 38 60 1B E5 00 00 99 E5 10 30 88 E2 8C C1 88 E0 00 30 88 E5 00 10 96 E5 04 20 A0 E1 08 C0 88 E5 80 01 88 E0 ?? ?? ?? ?? 2F 30 A0 E3 00 30 C0 E5 00 50 89 E5 58 70 1B E5 04 30 98 E5 08 00 A0 E1 00 30 87 E5 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 3C 50 1B E5 03 20 A0 E1 10 30 94 E5 01 60 85 E2 08 20 42 E2 14 50 94 E5 18 40 84 E2 02 70 84 E0 03 60 86 E0 4C 20 4B E2 06 00 92 E8 A5 96 A0 E1 85 89 A0 E1 86 31 A0 E1 09 20 82 E1 08 30 83 E2 08 10 81 E1 03 D0 4D E0 74 10 0B E5 70 20 0B E5 54 30 4B E2 0C 00 93 E8 EC C0 9F E5 09 30 83 E1 08 20 82 E1 E4 E0 9F E5 74 90 4B E2 00 03 99 E8 07 00 54 E1 00 03 8C E8 0C 00 8E E8 38 D0 0B E5 00 90 A0 E1 01 30 A0 23 C1 FE FF 2A 3C 60 0B E5 38 A0 1B E5 01 80 A0 E3 01 60 84 E2 06 00 A0 E1 ?? ?? ?? ?? 00 20 D4 E5 18 22 15 E0 3C 10 1B 05 01 40 80 E2 89 21 8A 10 01 10 41 02 04 40 86 E0 89 61 8A 17 3C 10 0B 05 04 00 82 15 01 90 89 12 04 00 57 E1 EF FF FF 8A 2C 50 4B E2 30 00 95 E8 05 50 94 E1 3C 60 1B E5 01 30 89 E2 AC FE FF 1A 3C 30 0B E5 DA FE FF EA 38 90 1B E5 08 10 89 E2 06 00 91 E8 ?? ?? ?? ?? 2F 40 A0 E3 01 40 C0 E4 2C 20 1B E5 00 10 99 E5 ?? ?? ?? ?? 00 40 C0 E5 3F FF FF EA 00 10 A0 E3 01 20 A0 E1 0C 00 A0 E3 2C 30 9F E5 ?? ?? ?? ?? 28 00 9F E5 28 10 9F E5 A6 20 A0 E3 24 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "getchar_unlocked"
		size = 60
		refs = "0030 __uflow 0038 _IO_stdin"
	strings:
		$1 = { 08 40 2D E9 2C 30 9F E5 00 00 93 E5 04 30 90 E5 08 20 90 E5 02 00 53 E1 04 00 00 2A 01 20 83 E2 04 20 80 E5 00 00 D3 E5 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? FB FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "inotify_init"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 4F 7F A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_0_0 {
	meta:
		name = "__mpn_mul"
		size = 840
		refs = "0040 __mpn_mul_1 0070 __mpn_addmul_1 00a8 __mpn_add_n 00e8 __mpn_impn_mul_n 0194 __mpn_mul"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 2C D0 4D E2 04 40 9B E5 1F 00 54 E3 03 90 A0 E1 00 70 A0 E1 01 50 A0 E1 02 60 A0 E1 27 00 00 CA 00 00 54 E3 04 00 A0 01 21 00 00 0A 00 30 93 E5 01 00 53 E3 3A 00 00 9A ?? ?? ?? ?? 06 A1 A0 E1 01 00 54 E3 0A A0 87 E0 06 01 87 E7 04 80 87 E2 17 00 00 DA 04 71 87 E0 07 00 00 EA 08 00 A0 E1 05 10 A0 E1 06 20 A0 E1 ?? ?? ?? ?? 04 80 88 E2 07 00 58 E1 04 00 AA E5 0D 00 00 0A 04 30 B9 E5 01 00 53 E3 F4 FF FF 8A 00 00 A0 13 F6 FF FF 1A 08 00 A0 E1 08 10 A0 E1 05 20 A0 E1 06 30 A0 E1 ?? ?? ?? ?? 04 80 88 E2 07 00 58 E1 04 00 AA E5 F1 FF FF 1A 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 84 A1 A0 E1 08 A0 8A E2 0A D0 4D E0 08 C0 8D E2 03 20 A0 E1 00 C0 8D E5 04 30 A0 E1 28 C0 0B E5 ?? ?? ?? ?? 04 C1 A0 E1 30 C0 0B E5 06 80 64 E0 30 20 1B E5 08 00 54 E1 0C C0 85 E0 02 50 87 E0 47 00 00 DA 00 00 58 E3 1A 00 00 1A 04 40 86 E0 07 41 44 E2 04 01 97 E7 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 02 A1 A0 E1 09 00 00 0A 00 00 52 E3 0A 10 87 C0 07 30 A0 C1 00 20 A0 C3 02 00 00 DA 04 20 83 E4 01 00 53 E1 FC FF FF 1A 00 00 A0 E3 BA FF FF EA 00 00 52 E3 00 30 A0 C3 FA FF FF DA 03 20 95 E7 03 20 87 E7 04 30 83 E2 0A 00 53 E1 FA FF FF 1A F4 FF FF EA 0C 30 A0 E1 09 10 A0 E1 04 20 A0 E1 00 80 8D E5 28 00 1B E5 ?? ?? ?? ?? 05 10 A0 E1 28 20 1B E5 04 30 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 28 C0 1B E5 04 31 9C E7 03 00 80 E0 30 C0 1B E5 00 00 53 E1 28 30 1B E5 0C 10 85 E0 0C 20 83 E0 04 01 85 E7 04 10 81 E2 04 20 82 E2 06 00 00 9A 01 80 58 E2 CB FF FF 0A 04 30 92 E4 01 30 83 E2 00 00 53 E3 04 30 81 E4 F8 FF FF 0A 02 00 51 E1 C4 FF FF 0A 01 00 58 E3 C2 FF FF DA 07 C1 48 E2 0C C1 A0 E1 00 30 A0 E3 03 00 92 E7 03 00 81 E7 04 30 83 E2 0C 00 53 E1 FA FF FF 1A B9 FF FF EA 0A D0 4D E0 08 30 8D E2 02 20 83 E0 2C 30 0B E5 3C 20 0B E5 04 30 82 E2 00 20 64 E2 40 60 0B E5 38 30 0B E5 34 20 0B E5 30 60 1B E5 08 A0 64 E0 3C 80 1B E5 3C 70 0B E5 2C 70 1B E5 2C 90 0B E5 0C 90 A0 E1 28 C0 1B E5 07 00 A0 E1 00 C0 8D E5 09 10 A0 E1 2C 20 1B E5 04 30 A0 E1 ?? ?? ?? ?? 05 10 A0 E1 05 00 A0 E1 07 20 A0 E1 04 30 A0 E1 ?? ?? ?? ?? 00 30 98 E5 03 00 80 E0 06 50 85 E0 00 00 53 E1 00 00 85 E5 04 20 85 E2 04 00 A0 E1 38 10 1B E5 1D 00 00 8A 01 00 52 E1 09 00 00 0A 01 00 50 E3 07 00 00 DA 07 01 40 E2 00 01 A0 E1 00 30 A0 E3 03 C0 91 E7 03 C0 82 E7 04 30 83 E2 00 00 53 E1 FA FF FF 1A 34 C0 1B E5 0A 20 A0 E1 0C A0 8A E0 0A 30 84 E0 03 00 54 E1 06 90 89 E0 D7 FF FF DA 40 60 4B E2 09 C0 A0 E1 02 80 A0 E1 C0 00 96 E8 2C 90 1B E5 78 FF FF EA 04 30 91 E4 01 30 83 E2 00 00 53 E3 04 30 82 E4 E1 FF FF 1A 01 00 50 E2 F8 FF FF 1A EA FF FF EA }
	condition:
		$1
}

rule file_114_0_0 {
	meta:
		name = "__dup"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 29 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_115_0_0 {
	meta:
		name = "__gets_chk"
		size = 656
		refs = "0080 _IO_getline 0130 __aeabi_read_tp 01a8 __uflow 01bc __chk_fail 0258 _Unwind_Resume 0260 __lll_lock_wait_private 028c _IO_stdin"
	strings:
		$1 = { F0 47 2D E9 00 80 51 E2 08 D0 4D E2 00 60 A0 E1 69 00 00 0A 70 72 9F E5 00 50 97 E5 00 40 95 E5 02 49 14 E2 40 00 00 0A 05 00 A0 E1 04 30 90 E5 08 20 90 E5 02 00 53 E1 5A 00 00 2A 01 20 83 E2 04 20 80 E5 00 00 D3 E5 0A 00 50 E3 51 00 00 0A 00 30 97 E5 00 C0 93 E5 06 10 A0 E1 20 20 CC E3 00 20 83 E5 01 00 C1 E4 00 30 A0 E3 00 00 97 E5 01 20 48 E2 00 30 8D E5 0A 30 A0 E3 20 40 0C E2 ?? ?? ?? ?? 00 30 97 E5 00 20 93 E5 20 00 12 E3 01 00 80 E2 46 00 00 1A 02 20 84 E1 00 20 83 E5 08 00 50 E1 00 30 A0 33 00 30 C6 37 43 00 00 2A 00 30 95 E5 02 09 13 E3 17 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 11 00 00 1A 08 30 85 E5 00 70 95 E5 00 10 A0 E3 07 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 57 E1 F0 FF FF 1A 01 00 57 E3 52 00 00 CA 06 00 A0 E1 08 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 48 90 95 E5 ?? ?? ?? ?? 08 30 99 E5 13 AD 40 E2 0A 00 53 E1 16 00 00 0A 01 10 A0 E3 09 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 38 00 00 1A 48 30 95 E5 00 00 97 E5 08 A0 83 E5 03 90 A0 E1 04 30 99 E5 01 30 83 E2 04 30 89 E5 A4 FF FF EA 00 00 A0 E3 BF FF FF EA 05 00 A0 E1 F7 FF FF EA ?? ?? ?? ?? 01 00 70 E3 A4 FF FF 1A 00 60 A0 E3 BC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? 00 30 95 E5 02 09 13 E3 00 80 A0 E1 1F 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 19 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 07 00 00 DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 08 00 A0 E1 ?? ?? ?? ?? 09 00 A0 E1 ?? ?? ?? ?? C3 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF A3 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_116_0_0 {
	meta:
		name = "__ftruncate64"
		size = 64
		refs = "002c __aeabi_read_tp 003c __libc_errno"
	strings:
		$1 = { 80 40 2D E9 00 10 A0 E3 C2 70 A0 E3 00 00 00 EF 01 0A 70 E3 01 00 00 8A 80 40 BD E8 ?? ?? ?? ?? 14 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 F6 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_117_0_0 {
	meta:
		name = "__libc_fork"
		size = 848
		refs = "00dc _IO_list_lock 00e0 __aeabi_read_tp 0160 __nptl_set_robust 0164 _IO_iter_begin 0178 _IO_iter_file 0190 _IO_iter_next 0198 _IO_iter_end 01a4 _IO_list_resetlock 0244 _IO_list_unlock 030c __assert_fail 0324 __fork_handlers 032c __fork_generation_pointer 0334 _dl_load_lock 0338 __fork_lock 033c __libc_errno"
	strings:
		$1 = { F8 4F 2D E9 18 53 9F E5 24 B0 8D E2 00 60 95 E5 00 00 56 E3 B6 00 00 0A 0F CA E0 E3 0F E0 A0 E1 5F F0 4C E2 14 40 96 E5 00 00 54 E3 F6 FF FF 0A 00 20 95 E5 01 10 84 E2 14 20 82 E2 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 54 E1 E8 FF FF 1A 00 40 A0 E3 0F 00 00 EA 14 70 86 E2 14 40 96 E5 07 20 A0 E1 01 10 84 E2 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 54 E1 F1 FF FF 1A 05 40 A0 E1 04 30 96 E5 00 00 53 E3 0F E0 A0 11 ?? ?? ?? ?? 10 D0 4D E2 00 60 8D E5 00 60 96 E5 00 00 56 E3 0D 50 A0 E1 04 40 8D E5 E4 FF FF 1A ?? ?? ?? ?? ?? ?? ?? ?? 54 64 10 E5 13 CD 40 E2 00 30 66 E2 00 10 A0 E3 54 34 00 E5 00 90 A0 E1 58 A4 10 E5 68 40 8C E2 01 20 A0 E1 01 30 A0 E1 14 02 9F E5 78 70 A0 E3 00 00 00 EF 01 0A 70 E3 00 80 A0 E1 3D 00 00 8A 00 00 50 E3 41 00 00 1A 58 24 19 E5 0A 00 52 E1 75 00 00 0A EC 31 9F E5 00 30 93 E5 00 00 53 E3 00 10 93 15 04 10 81 12 00 10 83 15 D8 31 9F E5 00 00 53 E3 54 24 09 E5 0C 00 A0 11 ?? ?? ?? ?? ?? ?? ?? ?? 00 60 A0 E3 00 40 A0 E1 08 00 00 EA 04 00 A0 E1 ?? ?? ?? ?? 48 30 90 E5 04 00 A0 E1 00 60 83 E5 04 60 83 E5 08 60 83 E5 ?? ?? ?? ?? 00 40 A0 E1 ?? ?? ?? ?? 00 00 54 E1 F3 FF FF 1A ?? ?? ?? ?? 84 31 9F E5 00 20 A0 E3 01 40 A0 E3 00 00 55 E3 00 20 83 E5 04 20 83 E5 08 20 83 E5 10 20 83 E5 14 20 83 E5 0C 40 83 E5 0A 00 00 0A 00 30 95 E5 0C 20 93 E5 00 00 52 E3 02 00 00 0A 0F E0 A0 E1 ?? ?? ?? ?? 00 30 95 E5 04 50 95 E5 00 00 55 E3 14 40 83 E5 F4 FF FF 1A 30 31 9F E5 00 20 A0 E3 00 20 83 E5 08 00 A0 E1 24 D0 4B E2 F8 4F BD E8 ?? ?? ?? ?? 18 31 9F E5 00 80 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 80 80 E7 00 80 E0 E3 58 34 19 E5 0A 00 53 E1 2E 00 00 1A 54 64 09 E5 ?? ?? ?? ?? 00 00 55 E3 0E 00 00 1A ED FF FF EA 00 30 95 E5 18 20 93 E5 00 00 52 E3 06 00 00 0A B8 14 19 E5 14 00 93 E5 06 20 A0 E1 01 10 81 E3 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 04 50 95 E5 00 00 55 E3 DF FF FF 0A 00 70 95 E5 08 30 97 E5 00 00 53 E3 02 00 00 0A 0F E0 A0 E1 ?? ?? ?? ?? 00 70 95 E5 14 A0 87 E2 14 60 97 E5 0A 20 A0 E1 01 10 46 E2 06 40 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 E3 FF FF 1A D7 FF FF EA 06 50 A0 E1 77 FF FF EA 3C 00 9F E5 3C 10 9F E5 D3 20 A0 E3 38 30 9F E5 ?? ?? ?? ?? 34 00 9F E5 28 10 9F E5 8D 20 A0 E3 24 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 11 00 20 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "_IO_vasprintf"
		size = 324
		refs = "0018 malloc 0040 _IO_no_init 005c _IO_str_init_static_internal 0088 _IO_vfprintf 00bc realloc 010c memcpy 0114 free 0138 _IO_str_jumps"
	strings:
		$1 = { F0 40 2D E9 00 60 A0 E1 B4 D0 4D E2 64 00 A0 E3 01 50 A0 E1 02 40 A0 E1 ?? ?? ?? ?? 00 70 50 E2 42 00 00 0A 00 C0 A0 E3 0C 30 A0 E1 00 C0 8D E5 08 00 8D E2 02 19 A0 E3 00 20 E0 E3 50 C0 8D E5 ?? ?? ?? ?? EC C0 9F E5 07 10 A0 E1 07 30 A0 E1 08 00 8D E2 64 20 A0 E3 A0 C0 8D E5 ?? ?? ?? ?? 08 E0 9D E5 D0 C0 9F E5 D0 30 9F E5 01 E0 CE E3 08 00 8D E2 05 10 A0 E1 04 20 A0 E1 08 E0 8D E5 A8 C0 8D E5 AC 30 8D E5 ?? ?? ?? ?? 00 70 50 E2 22 00 00 BA 18 30 8D E2 18 00 93 E8 20 20 9D E5 04 40 63 E0 01 50 84 E2 02 30 63 E0 A3 00 55 E1 0D 00 00 3A 05 10 A0 E1 24 00 9D E5 ?? ?? ?? ?? 00 00 86 E5 00 30 A0 E1 00 00 53 E3 24 30 9D 05 00 20 A0 E3 00 30 86 05 04 20 C3 E7 07 00 A0 E1 B4 D0 8D E2 F0 40 BD E8 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 00 86 E5 EC FF FF 0A 24 50 9D E5 04 20 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? 00 30 96 E5 E9 FF FF EA 24 00 9D E5 ?? ?? ?? ?? 07 00 A0 E1 EB FF FF EA 00 00 E0 E3 E9 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_119_0_0 {
	meta:
		name = "getservbyport"
		size = 448
		refs = "0088 __getservbyport_r 00ac realloc 00c8 free 00d8 __aeabi_read_tp 0168 malloc 0184 __lll_lock_wait_private 01bc __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 A4 21 9F E5 01 80 A0 E1 24 D0 4D E2 00 70 A0 E1 01 10 A0 E3 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 4D 00 00 1A 64 61 9F E5 00 30 96 E5 58 21 9F E5 00 00 53 E3 14 20 8D E5 04 40 92 15 3D 00 00 0A 1C 90 8D E2 40 51 9F E5 40 B1 9F E5 00 00 00 EA 00 30 8B E5 10 02 8D E8 07 00 A0 E1 08 10 A0 E1 2C 21 9F E5 ?? ?? ?? ?? 22 00 50 E3 2D 00 00 1A 04 40 95 E5 00 A0 96 E5 84 40 A0 E1 04 10 A0 E1 0A 00 A0 E1 04 40 85 E5 ?? ?? ?? ?? 00 30 50 E2 F8 10 9F E5 ED FF FF 1A 0A 00 A0 E1 0C 10 8D E5 10 30 8D E5 ?? ?? ?? ?? E8 20 9F E5 0C 10 8D E2 0A 00 91 E8 ?? ?? ?? ?? 02 20 9F E7 0C C0 A0 E3 00 30 81 E5 02 C0 80 E7 00 30 A0 E3 1C 30 8D E5 14 30 9D E5 00 50 93 E5 00 10 A0 E3 05 40 A0 E1 A4 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 EF FF FF 1A 01 00 55 E3 13 00 00 CA 1C 00 9D E5 24 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 30 96 E5 00 00 53 E3 E6 FF FF 1A E3 FF FF EA 01 4B A0 E3 04 00 A0 E1 04 40 82 E5 ?? ?? ?? ?? 00 00 50 E3 00 00 86 E5 DC FF FF 0A 00 30 A0 E1 B8 FF FF EA 02 00 A0 E1 ?? ?? ?? ?? AE FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF E2 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_423_0_0 {
	meta:
		name = "getservbyname"
		size = 448
		refs = "0088 __getservbyname_r 00ac realloc 00c8 free 00d8 __aeabi_read_tp 0168 malloc 0184 __lll_lock_wait_private 01bc __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 A4 21 9F E5 01 80 A0 E1 24 D0 4D E2 00 70 A0 E1 01 10 A0 E3 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 4D 00 00 1A 64 61 9F E5 00 30 96 E5 58 21 9F E5 00 00 53 E3 14 20 8D E5 04 40 92 15 3D 00 00 0A 1C 90 8D E2 40 51 9F E5 40 B1 9F E5 00 00 00 EA 00 30 8B E5 10 02 8D E8 07 00 A0 E1 08 10 A0 E1 2C 21 9F E5 ?? ?? ?? ?? 22 00 50 E3 2D 00 00 1A 04 40 95 E5 00 A0 96 E5 84 40 A0 E1 04 10 A0 E1 0A 00 A0 E1 04 40 85 E5 ?? ?? ?? ?? 00 30 50 E2 F8 10 9F E5 ED FF FF 1A 0A 00 A0 E1 0C 10 8D E5 10 30 8D E5 ?? ?? ?? ?? E8 20 9F E5 0C 10 8D E2 0A 00 91 E8 ?? ?? ?? ?? 02 20 9F E7 0C C0 A0 E3 00 30 81 E5 02 C0 80 E7 00 30 A0 E3 1C 30 8D E5 14 30 9D E5 00 50 93 E5 00 10 A0 E3 05 40 A0 E1 A4 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 EF FF FF 1A 01 00 55 E3 13 00 00 CA 1C 00 9D E5 24 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 30 96 E5 00 00 53 E3 E6 FF FF 1A E3 FF FF EA 01 4B A0 E3 04 00 A0 E1 04 40 82 E5 ?? ?? ?? ?? 00 00 50 E3 00 00 86 E5 DC FF FF 0A 00 30 A0 E1 B8 FF FF EA 02 00 A0 E1 ?? ?? ?? ?? AE FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF E2 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_0_0 {
	meta:
		name = "_IO_helper_overflow"
		size = 196
		refs = "008c __wmemmove 00b4 __woverflow"
	strings:
		$1 = { F8 40 2D E9 5C 30 90 E5 0C C0 93 E5 10 20 93 E5 02 20 6C E0 42 61 B0 E1 00 40 A0 E1 01 50 A0 E1 5C 01 90 E5 09 00 00 1A 10 20 93 E5 14 10 93 E5 01 00 52 E1 04 10 82 32 10 10 83 35 05 00 A0 31 00 50 82 35 18 00 00 2A F8 40 BD E8 ?? ?? ?? ?? 98 30 90 E5 06 20 A0 E1 0C 10 A0 E1 1C C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 01 30 40 E2 03 00 73 E3 00 20 A0 E1 10 00 00 8A 5C 30 94 E5 0C 00 93 E5 02 71 A0 E1 07 10 80 E0 06 20 62 E0 ?? ?? ?? ?? 5C 20 94 E5 10 10 92 E5 00 00 52 E3 01 70 67 E0 02 30 A0 E1 10 70 82 E5 DE FF FF 1A 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? E2 FF FF EA 00 00 E0 E3 E0 FF FF EA }
	condition:
		$1
}

rule file_120_1_0 {
	meta:
		name = "buffered_vfprintf"
		size = 596
		refs = "001c _IO_fwide 0088 _IO_vfwprintf 00b0 _pthread_cleanup_push_defer 00c4 __aeabi_read_tp 0178 _pthread_cleanup_pop_restore 0234 __lll_lock_wait_private 024c _IO_funlockfile"
	strings:
		$1 = { F0 47 2D E9 81 DC 4D E2 80 D0 4D E2 01 40 A0 E1 01 10 A0 E3 02 60 A0 E1 00 50 A0 E1 ?? ?? ?? ?? 01 00 50 E3 00 30 A0 E1 00 00 E0 13 53 00 00 1A 06 20 A0 E1 B0 60 8D E2 FC E1 9F E5 6C 60 8D E5 F8 71 9F E5 81 6C 8D E2 80 60 86 E2 3C 90 95 E5 EC 81 9F E5 06 CD 8D E2 04 10 A0 E1 0E 70 86 E7 00 40 A0 E3 10 00 8D E2 C4 60 8D E5 A8 80 8D E5 6C 51 8D E5 7C 30 8D E5 58 40 8D E5 4C 90 8D E5 C0 C0 8D E5 BC C0 8D E5 ?? ?? ?? ?? B4 81 9F E5 04 80 58 E0 01 80 A0 13 04 00 58 E1 00 60 A0 E1 5B 00 00 0A 0D 00 A0 E1 9C 11 9F E5 05 20 A0 E1 ?? ?? ?? ?? 00 40 95 E5 02 49 14 E2 18 00 00 1A 48 70 95 E5 ?? ?? ?? ?? 08 30 97 E5 13 AD 40 E2 0A 00 53 E1 0F 00 00 0A 01 10 A0 E3 07 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 48 00 00 1A 48 30 95 E5 08 A0 83 E5 03 70 A0 E1 04 30 97 E5 01 30 83 E2 04 30 87 E5 6C 30 9D E5 0C 10 83 E2 12 00 91 E8 04 40 61 E0 44 41 A0 E1 00 00 54 E3 07 00 00 DA 98 30 95 E5 05 00 A0 E1 04 20 A0 E1 1C C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 04 00 50 E1 00 60 E0 13 00 30 95 E5 02 09 13 E3 08 00 00 0A 00 00 58 E3 0D 00 A0 11 00 10 A0 13 ?? ?? ?? ?? 06 00 A0 E1 81 DC 8D E2 80 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 F0 FF FF 1A 08 30 85 E5 00 70 95 E5 00 10 A0 E3 07 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 57 E1 F0 FF FF 1A 01 00 57 E3 DE FF FF DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF D5 FF FF EA 34 30 9F E5 2C 20 9F E5 81 1C 8D E2 80 10 81 E2 03 20 81 E7 04 50 8D E5 A0 FF FF EA 07 00 A0 E1 ?? ?? ?? ?? B3 FF FF EA 90 7E FF FF 04 80 AD FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 80 7E FF FF }
	condition:
		$1
}

rule file_120_2_0 {
	meta:
		name = "_IO_vfwprintf"
		size = 21816
		refs = "0018 __aeabi_read_tp 0040 _IO_fwide 0094 __wcschrnul 00d4 _pthread_cleanup_push_defer 034c _pthread_cleanup_pop_restore 06b0 free 0998 _IO_wpadn 0ac0 read_int 0bf0 __parse_one_specwc 0c58 memmove 0ccc memset 0de4 __printf_fp 0e78 __libc_errno 0e80 _IO_funlockfile 0e88 __printf_modifier_table 0e8c __printf_va_arg_table 0e9c __printf_function_table 0eec __printf_fphex 1398 __strnlen 13e0 __mbsrtowcs 1608 __btowc 1718 __strerror_r 1f3c __aeabi_uidivmod 1f64 __aeabi_uidiv 2b28 __assert_fail 2c44 __libc_fatal 2d20 __printf_arginfo_table 2d38 _nl_current_LC_NUMERIC 2d50 _itowa_upper_digits 2d54 _itowa_lower_digits 3360 __woverflow 33ac __wcsnlen 34ec _i18n_number_rewrite 358c __lll_lock_wait_private 37a4 _itowa 3968 group_number 3f14 __libc_alloca_cutoff 3f34 malloc 40d4 strlen 42b4 __wcslen 42c4 __readonly_area"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 43 DD 4D E2 0C D0 4D E2 60 3E 9F E5 00 50 A0 E1 ?? ?? ?? ?? 03 30 9F E7 00 40 A0 E1 03 30 94 E7 01 80 A0 E1 05 00 A0 E1 01 10 A0 E3 02 90 A0 E1 02 2A 4B E2 D4 3F 82 E5 ?? ?? ?? ?? 01 00 50 E3 7A 00 00 1A 00 30 95 E5 08 00 13 E3 28 0A 00 1A 00 00 58 E3 71 00 00 0A 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 01 00 50 E3 00 60 A0 E1 6F 00 00 1A 00 40 95 E5 02 70 14 E2 61 00 00 1A 02 3A 4B E2 08 00 A0 E1 25 10 A0 E3 E4 9F 83 E5 ?? ?? ?? ?? 02 CA 4B E2 02 09 14 E3 D8 0F 8C E5 E0 0F 8C E5 02 0A 4B 12 D0 7F 80 15 24 00 00 1A C0 3D 9F E5 00 00 53 E3 6A 0C 00 0A 01 0A 4B E2 04 00 40 E2 B0 1D 9F E5 05 20 A0 E1 D0 6F 8C E5 ?? ?? ?? ?? 00 40 95 E5 02 49 14 E2 18 00 00 1A 48 60 95 E5 ?? ?? ?? ?? 08 30 96 E5 13 7D 40 E2 07 00 53 E1 0F 00 00 0A 01 10 A0 E3 06 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 15 0D 00 1A 48 30 95 E5 08 70 83 E5 03 60 A0 E1 04 30 96 E5 01 30 83 E2 04 30 86 E5 02 1A 4B E2 D8 1F 91 E5 01 30 68 E0 43 A1 A0 E1 0A 20 A0 E1 98 30 95 E5 05 00 A0 E1 08 10 A0 E1 1C C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 00 5A E1 00 A0 E0 13 31 00 00 0A 00 30 95 E5 02 09 13 E3 17 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 11 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 75 14 00 CA 02 CA 4B E2 D0 CF 9C E5 00 00 5C E3 50 00 00 1A 0A 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 05 00 A0 E1 08 10 A0 E1 09 20 A0 E1 C6 14 00 EB 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 54 3C 9F E5 16 20 A0 E3 03 30 9F E7 03 20 84 E7 00 00 E0 E3 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 02 2A 4B E2 E0 3F 92 E5 00 20 93 E5 00 00 52 E3 C8 FF FF 0A 38 4C 9F E5 00 20 94 E5 00 00 52 E3 49 14 00 1A 14 1C 9F E5 00 10 91 E5 00 00 51 E3 3A 14 00 1A 08 2C 9F E5 00 20 92 E5 00 00 52 E3 29 02 00 1A 02 0A 4B E2 CC 2F 80 E5 CC 4F 90 E5 00 60 A0 E1 00 10 E0 E3 8C 2F 80 E5 AC 4F 80 E5 98 4F 86 E5 B8 1F 80 E5 04 10 93 E5 02 0A 4B E2 20 20 41 E2 00 40 A0 E3 04 30 83 E2 B0 1F 80 E5 20 C0 A0 E3 00 10 E0 E3 5A 00 52 E3 E0 3F 80 E5 70 4F 80 E5 74 4F 80 E5 7C 4F 80 E5 84 4F 80 E5 68 4F 80 E5 88 4F 80 E5 6C 4F 80 E5 A8 4F 80 E5 64 4F 80 E5 94 4F 80 E5 60 4F 80 E5 24 60 4B E2 9C 1F 80 E5 80 CF 80 E5 78 3B 9F E5 78 3B 9F 95 02 20 83 90 78 20 D2 95 02 31 93 97 01 CA 4B E2 14 C0 4C E2 0C C0 4C E2 02 0A 4B E2 BC CF 80 E5 54 7B 9F E5 03 F0 A0 E1 01 0A 4B E2 04 00 40 E2 00 10 A0 E3 ?? ?? ?? ?? A9 FF FF EA 02 3A 4B E2 E0 0F 93 E5 04 10 90 E5 20 30 41 E2 04 00 80 E2 02 CA 4B E2 5A 00 53 E3 E0 0F 8C E5 29 0D 00 8A 03 30 87 E0 78 30 D3 E5 01 20 A0 E3 74 2F 8C E5 03 31 97 E7 0C 00 A0 E1 02 2A 4B E2 B0 1F 82 E5 03 F0 A0 E1 02 3A 4B E2 E0 0F 93 E5 04 10 90 E5 20 30 41 E2 04 00 80 E2 02 CA 4B E2 5A 00 53 E3 E0 0F 8C E5 21 0D 00 8A 03 30 87 E0 78 30 D3 E5 01 20 A0 E3 0C 00 A0 E1 84 2F 8C E5 03 31 97 E7 EC FF FF EA 02 1A 4B E2 E0 0F 91 E5 04 10 90 E5 20 30 41 E2 04 00 80 E2 02 2A 4B E2 5A 00 53 E3 E0 0F 82 E5 0C 0D 00 8A 03 30 87 E0 78 30 D3 E5 01 00 A0 E3 02 C0 A0 E1 70 0F 82 E5 03 31 97 E7 DC FF FF EA 02 3A 4B E2 E0 0F 93 E5 04 10 90 E5 20 30 41 E2 04 00 80 E2 02 CA 4B E2 5A 00 53 E3 E0 0F 8C E5 06 0D 00 8A 03 30 87 E0 78 30 D3 E5 20 20 A0 E3 01 00 A0 E3 80 2F 8C E5 03 31 97 E7 7C 0F 8C E5 CB FF FF EA 02 1A 4B E2 E0 0F 91 E5 02 CA 4B E2 04 10 90 E5 80 2F 9C E5 7C CF 9C E5 20 30 41 E2 00 00 5C E3 30 20 A0 03 02 CA 4B E2 04 00 80 E2 5A 00 53 E3 80 2F 8C E5 E0 0F 8C E5 A3 01 00 8A 03 30 87 E0 78 30 D3 E5 03 31 97 E7 B8 FF FF EA 02 3A 4B E2 B8 3F 93 E5 01 00 73 E3 45 0E 00 0A 02 CA 4B E2 E0 0F 9C E5 04 10 90 E5 20 30 41 E2 04 00 80 E2 5A 00 53 E3 E0 0F 8C E5 46 0B 00 8A 03 30 87 E0 78 30 D3 E5 01 00 A0 E3 68 0F 8C E5 03 31 97 E7 A6 FF FF EA 02 1A 4B E2 E0 0F 91 E5 04 10 90 E5 20 30 41 E2 04 00 80 E2 02 2A 4B E2 5A 00 53 E3 E0 0F 82 E5 D8 0C 00 8A 03 30 87 E0 78 30 D3 E5 01 00 A0 E3 03 31 87 E0 02 C0 A0 E1 A8 0F 82 E5 3C 32 93 E5 88 0F 82 E5 94 FF FF EA 02 3A 4B E2 E0 0F 93 E5 04 10 90 E5 20 30 41 E2 04 00 80 E2 02 CA 4B E2 5A 00 53 E3 E0 0F 8C E5 62 0B 00 8A 03 30 87 E0 78 30 D3 E5 00 20 A0 E3 03 31 87 E0 0C 00 A0 E1 A8 2F 8C E5 3C 32 93 E5 88 2F 8C E5 82 FF FF EA 02 1A 4B E2 E0 3F 91 E5 04 00 93 E5 03 10 A0 E1 02 2A 4B E2 04 30 83 E2 2A 00 50 E3 E0 3F 82 E5 23 0F 00 0A 30 00 40 E2 09 00 50 E3 00 20 A0 83 02 1A 4B 82 9C 2F 81 85 F2 0E 00 9A 00 10 93 E5 20 30 41 E2 5A 00 53 E3 56 01 00 8A 03 30 87 E0 78 30 D3 E5 03 31 87 E0 4C 31 93 E5 6A FF FF EA 5C 30 95 E5 00 00 53 E3 08 0D 00 0A 10 20 93 E5 14 10 93 E5 01 00 52 E1 04 00 82 32 25 10 A0 33 10 00 83 35 00 10 82 35 00 0D 00 2A 06 01 7A E3 1D 00 00 0A 02 EA 4B E2 BC 9F 8E E5 01 60 8A E2 00 00 54 E3 C7 0C 00 1A 02 3A 4B E2 E0 4F 93 E5 04 40 84 E2 04 00 A0 E1 25 10 A0 E3 03 90 A0 E1 E0 4F 83 E5 ?? ?? ?? ?? 00 00 56 E3 E0 0F 89 E5 B7 0C 00 BA 00 20 64 E0 04 10 A0 E1 98 30 95 E5 42 21 A0 E1 05 00 A0 E1 1C C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 02 1A 4B E2 E0 3F 91 E5 03 40 64 E0 44 01 50 E1 00 40 A0 13 AE 0B 00 0A 00 A0 E0 E3 02 8A 4B E2 CC 8F 98 E5 00 00 58 E3 B9 0A 00 1A 00 00 54 E3 B4 FE FF 0A 04 00 A0 E1 ?? ?? ?? ?? B1 FE FF EA 02 0A 4B E2 88 0F 90 E5 00 00 50 E3 C3 0C 00 0A 07 30 89 E2 07 10 C3 E3 0C 00 91 E8 08 C0 81 E2 02 0A 4B E2 A3 9F B0 E1 BC CF 80 E5 01 00 00 0A 00 20 72 E2 00 30 E3 E2 43 1D 4B E2 0C 00 81 E9 0A 30 A0 E3 02 2A 4B E2 A8 3F 82 E5 02 CA 4B E2 9C CF 9C E5 00 00 5C E3 AC 0C 00 BA 9C 0C 00 1A 43 0D 4B E2 03 00 90 E9 01 10 90 E1 5B 0C 00 1A 02 1A 4B E2 70 1F 91 E5 02 2A 4B E2 A8 2F 92 E5 00 30 91 E2 01 30 A0 13 08 00 52 E3 00 30 A0 13 00 00 53 E3 92 0C 00 0A 30 30 A0 E3 04 30 06 E5 20 C0 A0 E3 02 3A 4B E2 80 CF 83 E5 04 70 46 E2 02 CA 4B E2 02 0A 4B E2 44 CF 9C E5 48 0F 90 E5 00 C0 9C E1 00 10 A0 03 01 10 A0 13 02 2A 4B E2 44 1F 82 E5 02 1A 4B E2 9C 1F 91 E5 06 30 67 E0 43 01 51 E1 10 00 00 CA 02 2A 4B E2 44 2F 92 E5 00 00 52 E3 0C 00 00 0A 02 CA 4B E2 70 CF 9C E5 02 0A 4B E2 A8 0F 90 E5 00 20 9C E2 01 20 A0 13 08 00 50 E3 00 20 A0 13 00 00 52 E3 30 30 A0 13 04 30 07 15 04 70 47 12 06 30 67 10 02 2A 4B E2 43 61 A0 E1 9C CF 92 E5 7C 3F 92 E5 00 10 66 E2 00 00 53 E3 0C 30 81 E0 C3 0F C3 E1 88 1F 82 E5 9C 0F 82 E5 02 10 A0 E1 DB 09 00 1A 88 3F 92 E5 03 20 60 E0 44 0F 91 E5 94 1F 91 E5 00 00 50 E3 01 20 82 E0 09 00 00 0A 02 CA 4B E2 70 CF 9C E5 02 0A 4B E2 A8 0F 90 E5 00 30 9C E2 01 30 A0 13 10 00 50 E3 00 30 A0 13 00 00 53 E3 02 20 42 12 02 1A 4B E2 74 1F 91 E5 02 CA 4B E2 84 CF 9C E5 02 0A 4B E2 09 30 81 E1 80 0F 90 E5 0C 30 93 E1 01 20 42 12 20 00 50 E3 7E 10 00 0A 00 00 59 E3 A1 0A 00 0A 5C 30 95 E5 00 00 53 E3 4D 10 00 0A 10 10 93 E5 14 00 93 E5 00 00 51 E1 04 C0 81 32 2D 00 A0 33 10 C0 83 35 00 00 81 35 45 10 00 2A 06 01 7A E3 73 FF FF 0A 01 A0 8A E2 02 1A 4B E2 44 1F 91 E5 00 00 51 E3 29 00 00 0A 02 9A 4B E2 70 9F 99 E5 02 CA 4B E2 A8 CF 9C E5 00 30 99 E2 01 30 A0 13 10 00 5C E3 00 30 A0 13 00 00 53 E3 1F 00 00 0A 5C 30 95 E5 00 00 53 E3 D3 0F 00 0A 10 10 93 E5 14 00 93 E5 00 00 51 E1 04 C0 81 32 30 00 A0 33 10 C0 83 35 00 00 81 35 CB 0F 00 2A 06 01 7A E3 57 FF FF 0A 5C 30 95 E5 00 00 53 E3 BC 0F 00 0A 10 10 93 E5 14 00 93 E5 00 00 51 E1 B8 0F 00 2A 02 0A 4B E2 B0 0F 90 E5 01 00 70 E3 04 00 81 E2 10 00 83 E5 02 3A 4B E2 B0 3F 93 E5 00 30 81 E5 47 FF FF 0A 0A 01 7A E3 02 A0 8A 12 44 FF FF 0A 02 9A 4B E2 9C 9F 99 E5 09 20 82 E0 00 00 52 E3 0B 00 00 DA 05 00 A0 E1 30 10 A0 E3 ?? ?? ?? ?? 01 00 70 E3 3A FF FF 0A 0A 01 7A E3 03 10 00 8A 02 31 E0 E3 03 30 6A E0 03 00 50 E1 0A A0 80 90 F8 0F 00 8A 00 00 5A E3 BB 10 00 BA 07 10 A0 E1 98 30 95 E5 05 00 A0 E1 06 20 A0 E1 1C C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 00 56 E1 28 FF FF 1A 02 31 E0 E3 03 30 6A E0 03 00 56 E1 A8 10 00 CA 0A 60 86 E0 07 FF FF EA 02 1A 4B E2 E0 3F 91 E5 04 10 93 E5 30 10 41 E2 04 30 83 E2 02 2A 4B E2 09 00 51 E3 E0 3F 82 E5 F4 3F 0B E5 A4 0F 00 9A 00 C0 99 E5 02 3A 4B E2 00 00 5C E3 94 CF 83 E5 04 90 89 E2 94 0F 00 BA 02 1A 4B E2 94 1F 91 E5 44 24 9F E5 02 00 51 E1 89 0F 00 8A 02 2A 4B E2 94 2F 92 E5 F2 0F 52 E3 08 00 00 3A 20 60 82 E2 06 61 A0 E1 01 0A 56 E3 9D 0F 00 8A 0E 30 86 E2 07 30 C3 E3 03 D0 4D E0 08 30 8D E2 06 60 83 E0 02 CA 4B E2 E0 3F 9C E5 00 10 93 E5 20 30 41 E2 5A 00 53 E3 21 00 00 8A 03 30 87 E0 78 30 D3 E5 03 31 87 E0 D4 30 93 E5 35 FE FF EA 02 EA 4B E2 BC 0F 9E E5 ?? ?? ?? ?? CC 23 9F E5 02 1A 4B E2 02 00 50 E1 94 0F 81 E5 E1 0C 00 8A 02 3A 4B E2 94 3F 93 E5 F2 0F 53 E3 08 00 00 3A 20 60 83 E2 06 61 A0 E1 01 0A 56 E3 BE 0F 00 8A 0E 30 86 E2 07 30 C3 E3 03 D0 4D E0 08 30 8D E2 06 60 83 E0 02 0A 4B E2 E0 3F 90 E5 00 10 93 E5 24 00 51 E3 0D 00 00 0A 20 30 41 E2 5A 00 53 E3 DD FF FF 9A 5C 33 9F E5 16 FE FF EA 02 CA 4B E2 0C 30 A0 E1 00 E0 E0 E3 CC 1F 8C E5 8C 1F 8C E5 AC 1F 8C E5 98 1F 83 E5 B8 EF 8C E5 01 40 A0 E1 1A 3D 4D E2 02 0A 4B E2 00 20 A0 E3 00 00 54 E3 08 D0 43 E2 A0 3F 80 E5 E8 2F 80 E5 A9 0C 00 1A 02 2A 4B E2 B8 2F 92 E5 01 00 72 E3 2F 08 00 0A 02 1A 4B E2 D8 1F 91 E5 00 40 91 E5 02 2A 4B E2 00 00 54 E3 E0 1F 82 E5 43 08 00 0A 00 40 A0 E3 1A CD A0 E3 C8 9F 82 E5 C4 AF 82 E5 C0 5F 82 E5 04 70 A0 E1 A4 4F 82 E5 01 00 A0 E1 0C A0 A0 E1 A0 9F 92 E5 04 50 A0 E1 B4 8F 82 E5 00 00 00 EA 06 00 A0 E1 04 40 89 E0 01 3A 4B E2 04 20 A0 E1 07 10 A0 E1 18 30 43 E2 ?? ?? ?? ?? 18 60 94 E5 00 40 96 E5 02 EA 4B E2 00 00 54 E3 01 50 85 E2 00 70 87 E0 E0 6F 8E E5 41 07 00 0A 85 40 85 E0 04 41 85 E0 04 41 A0 E1 04 00 5A E1 04 20 A0 E1 EA FF FF 8A 8A 30 A0 E1 0F 30 83 E2 0F 80 C3 E3 08 10 88 E2 01 D0 4D E0 08 C0 8D E2 08 10 8C E0 01 00 59 E1 0C 00 A0 E1 09 10 A0 E1 0A 80 88 00 ?? ?? ?? ?? 08 A0 A0 E1 00 90 A0 E1 DB FF FF EA 10 00 A0 E3 02 CA 4B E2 A8 0F 8C E5 02 1A 4B E2 88 1F 91 E5 00 00 51 E3 23 0A 00 0A 07 30 89 E2 07 30 C3 E3 03 00 93 E8 43 2D 4B E2 02 9A 4B E2 00 C0 A0 E3 03 00 82 E9 08 00 83 E2 84 CF 89 E5 BC 0F 89 E5 74 CF 89 E5 0C 90 A0 E1 92 FE FF EA FF 6E 4B E2 04 60 46 E2 00 10 A0 E3 14 20 A0 E3 06 00 A0 E1 ?? ?? ?? ?? 02 2A 4B E2 02 CA 4B E2 6C 2F 92 E5 88 CF 9C E5 02 EA 4B E2 A8 EF 9E E5 02 0A 4B E2 01 10 02 E2 70 0F 90 E5 01 30 0C E2 02 CA 4B E2 01 20 0E E2 74 CF 9C E5 81 30 83 E1 02 31 83 E1 01 10 00 E2 81 31 83 E1 01 20 0C E2 02 EA 4B E2 7C EF 9E E5 02 22 83 E1 02 CA 4B E2 02 3A 4B E2 84 3F 93 E5 60 CF 9C E5 01 10 0E E2 02 EA 4B E2 01 00 03 E2 68 EF 9E E5 01 30 0C E2 81 22 82 E1 83 31 A0 E1 01 10 0E E2 00 23 82 E1 04 30 83 E3 02 0A 4B E2 88 0F 90 E5 81 23 82 E1 E7 3F 4B E5 E8 2F 4B E5 02 1A 4B E2 02 2A 4B E2 02 3A 4B E2 02 CA 4B E2 9C 1F 91 E5 B0 3F 93 E5 94 2F 92 E5 80 CF 9C E5 EC 3F 0B E5 F4 1F 0B E5 F0 2F 0B E5 E4 CF 0B E5 07 30 89 E2 00 00 50 E3 07 30 C3 E3 03 00 93 E8 6C 0C 00 0A 08 E0 83 E2 01 3A 4B E2 10 30 43 E2 02 2A 4B E2 03 00 83 E9 BC EF 82 E5 01 3A 4B E2 0C 30 43 E2 24 20 4B E2 F0 3F 22 E5 06 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 27 FE FF BA 0A 01 7A E3 F0 0E 00 8A 02 31 E0 E3 03 30 6A E0 03 00 50 E1 51 0C 00 8A 0A 60 80 E0 04 FE FF EA 02 1A 4B E2 E0 0F 91 E5 04 10 90 E5 20 30 41 E2 04 00 80 E2 02 2A 4B E2 5A 00 53 E3 E0 0F 82 E5 50 09 00 8A 03 30 87 E0 78 30 D3 E5 00 00 A0 E3 B7 FD FF EA 02 3A 4B E2 E0 0F 93 E5 04 10 90 E5 20 30 41 E2 04 00 80 E2 02 CA 4B E2 5A 00 53 E3 E0 0F 8C E5 66 0A 00 8A 03 30 87 E0 78 30 D3 E5 01 20 A0 E3 BC FD FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? DE FF FF 1F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 02 EA 4B E2 02 0A 4B E2 AC EF 9E E5 A0 0F 90 E5 34 10 A0 E3 9E 01 21 E0 00 00 51 E3 07 0F 00 0A 02 EA 4B E2 24 30 91 E5 B4 EF 9E E5 01 2A 4B E2 83 31 8E E0 02 6A 4B E2 05 00 A0 E1 10 20 42 E2 F0 3F 86 E5 ?? ?? ?? ?? 00 00 50 E3 E5 FD FF BA 0A 01 7A E3 F4 0E 00 8A 02 31 E0 E3 03 30 6A E0 03 00 50 E1 5D 0F 00 8A 0A A0 80 E0 00 00 54 E3 57 0F 00 1A 00 00 5A E3 50 0F 00 BA 02 3A 4B E2 02 6A 4B E2 AC 3F 93 E5 A0 6F 96 E5 34 40 A0 E3 93 64 24 E0 14 10 84 E2 06 00 91 E8 02 20 61 E0 98 30 95 E5 42 21 A0 E1 05 00 A0 E1 1C C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 18 C0 84 E2 08 10 1C E8 03 30 4C E0 43 01 50 E1 00 40 A0 13 C5 FD FF 1A 02 31 E0 E3 03 30 6A E0 03 00 50 E1 30 0F 00 CA 00 A0 8A E0 02 0A 4B E2 AC 1F 90 E5 01 00 81 E2 02 1A 4B E2 AC 0F 81 E5 02 2A 4B E2 02 3A 4B E2 A4 2F 92 E5 AC 3F 93 E5 03 00 52 E1 00 40 A0 93 B5 FD FF 9A 02 3A 4B E2 AC 4F 93 E5 02 CA 4B E2 84 20 84 E0 A0 CF 9C E5 02 21 84 E0 02 21 A0 E1 02 70 8C E0 0C 30 D7 E5 02 6A 4B E2 A3 41 A0 E1 23 C2 A0 E1 78 4F 86 E5 5C CF 86 E5 06 40 A0 E1 A3 62 A0 E1 04 C0 A0 E1 }
	condition:
		$1
}

rule file_120_3_0 {
	meta:
		name = "read_int"
		size = 112
	strings:
		$1 = { 00 30 90 E5 00 10 93 E5 30 00 2D E9 58 40 9F E5 30 10 41 E2 0A 50 A0 E3 04 20 93 E5 30 20 42 E2 09 00 52 E3 04 30 83 E2 0B 00 00 8A 00 00 51 E3 F8 FF FF BA 02 C1 E0 E3 04 00 51 E1 0C C0 62 E0 03 00 00 CA 95 01 01 E0 01 00 5C E1 02 10 81 A0 F0 FF FF AA 00 10 E0 E3 EE FF FF EA 00 30 80 E5 30 00 BD E8 01 00 A0 E1 ?? ?? ?? ?? CC CC CC 0C }
	condition:
		$1
}

rule file_120_4_0 {
	meta:
		name = "group_number"
		size = 204
		refs = "0040 mempcpy"
	strings:
		$1 = { F8 49 2D E9 00 40 D2 E5 02 60 A0 E1 01 20 44 E2 FF 20 02 E2 FD 00 52 E3 1C B0 8D E2 01 80 A0 E1 03 70 A0 E1 25 00 00 8A 01 20 60 E0 0E 30 82 E2 07 30 C3 E3 03 D0 4D E0 00 10 A0 E1 0D 00 A0 E1 ?? ?? ?? ?? 0D 50 A0 E1 01 60 86 E2 08 10 A0 E1 05 00 50 E1 18 00 00 9A 04 C0 10 E5 01 40 54 E2 04 C0 01 E5 04 00 40 E2 04 C0 41 E2 10 00 00 1A 05 00 50 E1 0E 00 00 9A 08 70 01 E5 00 40 D6 E5 FF 00 54 E3 08 C0 41 E2 06 00 00 1A 0C 30 41 E2 04 20 30 E5 00 00 55 E1 03 10 A0 E1 04 20 03 E4 FA FF FF 3A 04 00 00 EA 00 00 54 E3 01 40 56 05 01 60 86 12 0C 10 A0 E1 E4 FF FF EA 01 00 A0 E1 1C D0 4B E2 F8 49 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_5_0 {
	meta:
		name = "_i18n_number_rewrite"
		size = 332
		refs = "001c __wctrans 002c __towctrans 0058 __libc_alloca_cutoff 0084 malloc 009c mempcpy 00ac __aeabi_read_tp 0128 free 0148 _nl_current_LC_CTYPE"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 0C D0 4D E2 00 A0 A0 E1 2C 01 9F E5 01 50 A0 E1 02 40 A0 E1 ?? ?? ?? ?? 00 10 A0 E1 00 90 A0 E1 2E 00 A0 E3 ?? ?? ?? ?? 09 10 A0 E1 28 00 0B E5 2C 00 A0 E3 ?? ?? ?? ?? 05 70 6A E0 01 0A 57 E3 00 80 A0 E1 01 00 A0 93 03 00 00 9A 07 00 A0 E1 ?? ?? ?? ?? 00 00 90 E2 01 00 A0 13 01 60 10 E2 04 00 00 0A 0E 30 87 E2 07 30 C3 E3 03 D0 4D E0 0D 50 A0 E1 03 00 00 EA 07 00 A0 E1 ?? ?? ?? ?? 00 50 50 E2 28 00 00 0A 0A 10 A0 E1 07 20 A0 E1 05 00 A0 E1 ?? ?? ?? ?? A0 20 9F E5 00 30 A0 E1 02 20 9F E7 ?? ?? ?? ?? 02 10 90 E7 04 C0 43 E2 0C 00 55 E1 15 00 00 8A 04 30 13 E5 30 20 43 E2 09 00 52 E3 04 00 00 8A 00 20 91 E5 03 31 82 E0 30 30 93 E5 04 30 04 E5 09 00 00 EA 00 00 59 E3 06 00 00 0A 02 20 C3 E3 2C 00 52 E3 03 00 00 1A 28 20 1B E5 2E 00 53 E3 08 20 A0 11 02 30 A0 E1 04 30 04 E5 0C 30 A0 E1 04 40 44 E2 E6 FF FF EA 00 00 56 E3 04 00 A0 11 04 00 00 1A 05 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 00 00 00 EA 0A 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_0_0 {
	meta:
		name = "__sched_setparam"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 9A 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "__vswscanf"
		size = 124
		refs = "0034 _IO_no_init 0040 _IO_fwide 0054 _IO_wstr_init_static 0068 _IO_vfwscanf 0078 _IO_wstr_jumps"
	strings:
		$1 = { F0 40 2D E9 6C 30 9F E5 5D DF 4D E2 00 40 A0 E3 00 70 A0 E1 01 60 A0 E1 02 50 A0 E1 00 30 8D E5 04 20 A0 E1 B4 30 8D E2 08 00 8D E2 02 19 A0 E3 50 40 8D E5 ?? ?? ?? ?? 08 00 8D E2 01 10 A0 E3 ?? ?? ?? ?? 08 00 8D E2 07 10 A0 E1 04 20 A0 E1 04 30 A0 E1 ?? ?? ?? ?? 08 00 8D E2 06 10 A0 E1 05 20 A0 E1 04 30 A0 E1 ?? ?? ?? ?? 5D DF 8D E2 F0 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "insque"
		size = 44
	strings:
		$1 = { 00 00 51 E3 00 10 80 05 04 10 80 05 ?? ?? ?? ?? 00 30 91 E5 00 00 53 E3 00 00 81 E5 04 00 83 15 00 30 80 E5 04 10 80 E5 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_1_0 {
	meta:
		name = "remque"
		size = 28
	strings:
		$1 = { 00 20 90 E5 04 30 90 E5 00 00 52 E3 04 30 82 15 00 00 53 E3 00 20 83 15 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "strcat"
		size = 52
	strings:
		$1 = { 00 20 A0 E1 00 00 00 EA 03 20 A0 E1 02 30 A0 E1 01 C0 D3 E4 00 00 5C E3 FA FF FF 1A 01 20 42 E2 01 30 D1 E4 00 00 53 E3 01 30 E2 E5 FB FF FF 1A ?? ?? ?? ?? }
	condition:
		$1
}

rule file_125_0_0 {
	meta:
		name = "__libc_tcdrain"
		size = 184
		refs = "0038 __libc_enable_asynccancel 0064 __libc_disable_asynccancel 007c __aeabi_read_tp 00a8 __libc_multiple_threads 00b0 __libc_errno"
	strings:
		$1 = { A0 30 9F E5 00 30 93 E5 00 00 53 E3 B0 40 2D E9 00 40 A0 E1 07 00 00 1A 8C 10 9F E5 01 20 A0 E3 36 70 A0 E3 00 00 00 EF 01 0A 70 E3 0F 00 00 8A B0 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 36 70 A0 E3 00 50 A0 E1 60 10 9F E5 04 00 A0 E1 01 20 A0 E3 00 00 00 EF 01 0A 70 E3 00 40 A0 E1 0A 00 00 8A 05 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 EF FF FF EA 38 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 E8 FF FF EA 20 30 9F E5 00 40 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 40 80 E7 00 40 E0 E3 ED FF FF EA ?? ?? ?? ?? 09 54 00 00 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_0_3 {
	meta:
		name = "__libc_tcdrain"
		size = 184
		refs = "0038 __pthread_enable_asynccancel 0064 __pthread_disable_asynccancel 007c __aeabi_read_tp 00a8 __pthread_multiple_threads 00b0 errno"
	strings:
		$1 = { A0 30 9F E5 00 30 93 E5 00 00 53 E3 B0 40 2D E9 00 40 A0 E1 07 00 00 1A 8C 10 9F E5 01 20 A0 E3 36 70 A0 E3 00 00 00 EF 01 0A 70 E3 0F 00 00 8A B0 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 36 70 A0 E3 00 50 A0 E1 60 10 9F E5 04 00 A0 E1 01 20 A0 E3 00 00 00 EF 01 0A 70 E3 00 40 A0 E1 0A 00 00 8A 05 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 EF FF FF EA 38 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 E8 FF FF EA 20 30 9F E5 00 40 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 40 80 E7 00 40 E0 E3 ED FF FF EA ?? ?? ?? ?? 09 54 00 00 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_126_0_0 {
	meta:
		name = "__sched_rr_get_interval"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 A1 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_127_0_0 {
	meta:
		name = "fileno"
		size = 68
		refs = "0028 __aeabi_read_tp 0040 __libc_errno"
	strings:
		$1 = { 00 30 90 E5 02 0A 13 E3 04 E0 2D E5 04 00 00 0A 38 00 90 E5 00 00 50 E3 01 00 00 BA 04 E0 9D E4 ?? ?? ?? ?? 14 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 09 20 A0 E3 03 20 80 E7 00 00 E0 E3 F6 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_128_0_0 {
	meta:
		name = "__default_morecore"
		size = 24
		refs = "0004 __sbrk"
	strings:
		$1 = { 08 40 2D E9 ?? ?? ?? ?? 01 00 70 E3 00 00 A0 03 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_75_0_4 {
	meta:
		name = "_ZN10__cxxabiv111__terminateEPFvvE"
		size = 24
		refs = "000c abort 0010 __cxa_begin_catch"
	strings:
		$1 = { 08 40 2D E9 0F E0 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FC FF FF EA }
	condition:
		$1
}

rule file_892_0_1 {
	meta:
		name = "__gnu_fractsfda"
		size = 24
		refs = "0008 __aeabi_fmul 000c __aeabi_f2lz"
	strings:
		$1 = { 08 40 2D E9 4F 14 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_723_0_1 {
	meta:
		name = "__gnu_fractsfdq"
		size = 24
		refs = "0008 __aeabi_fmul 000c __aeabi_f2lz"
	strings:
		$1 = { 08 40 2D E9 5F 14 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1075_0_1 {
	meta:
		name = "__gnu_fractsfha"
		size = 24
		refs = "0008 __aeabi_fmul 000c __aeabi_f2iz"
	strings:
		$1 = { 08 40 2D E9 43 14 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_0_1 {
	meta:
		name = "__gnu_fractsfhq"
		size = 24
		refs = "0008 __aeabi_fmul 000c __aeabi_f2iz"
	strings:
		$1 = { 08 40 2D E9 47 14 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_515_0_1 {
	meta:
		name = "__gnu_fractsfqq"
		size = 24
		refs = "0008 __aeabi_fmul 000c __aeabi_f2iz"
	strings:
		$1 = { 08 40 2D E9 43 14 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_263_0_1 {
	meta:
		name = "__gnu_fractsfsa"
		size = 24
		refs = "0008 __aeabi_fmul 000c __aeabi_f2iz"
	strings:
		$1 = { 08 40 2D E9 47 14 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_137_0_1 {
	meta:
		name = "__gnu_fractsfsq"
		size = 24
		refs = "0008 __aeabi_fmul 000c __aeabi_f2iz"
	strings:
		$1 = { 08 40 2D E9 4F 14 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1413_0_1 {
	meta:
		name = "__gnu_fractsfuda"
		size = 28
		refs = "0008 __aeabi_fmul 000c __aeabi_f2ulz"
	strings:
		$1 = { 08 40 2D E9 0C 10 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? 00 00 80 4F }
	condition:
		$1
}

rule file_1224_0_1 {
	meta:
		name = "__gnu_fractsfudq"
		size = 28
		refs = "0008 __aeabi_fmul 000c __aeabi_f2ulz"
	strings:
		$1 = { 08 40 2D E9 0C 10 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? 00 00 80 5F }
	condition:
		$1
}

rule file_1651_0_1 {
	meta:
		name = "__gnu_fractsfuha"
		size = 28
		refs = "0008 __aeabi_fmul 000c __aeabi_f2uiz"
	strings:
		$1 = { 08 40 2D E9 0C 10 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? 00 00 80 43 }
	condition:
		$1
}

rule file_65_0_1 {
	meta:
		name = "__gnu_fractsfuhq"
		size = 28
		refs = "0008 __aeabi_fmul 000c __aeabi_f2uiz"
	strings:
		$1 = { 08 40 2D E9 0C 10 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? 00 00 80 47 }
	condition:
		$1
}

rule file_1322_0_1 {
	meta:
		name = "__gnu_fractsfuqq"
		size = 28
		refs = "0008 __aeabi_fmul 000c __aeabi_f2uiz"
	strings:
		$1 = { 08 40 2D E9 0C 10 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? 00 00 80 43 }
	condition:
		$1
}

rule file_134_0_1 {
	meta:
		name = "__gnu_fractsfusa"
		size = 28
		refs = "0008 __aeabi_fmul 000c __aeabi_f2uiz"
	strings:
		$1 = { 08 40 2D E9 0C 10 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? 00 00 80 47 }
	condition:
		$1
}

rule file_950_0_1 {
	meta:
		name = "__gnu_fractsfusq"
		size = 28
		refs = "0008 __aeabi_fmul 000c __aeabi_f2uiz"
	strings:
		$1 = { 08 40 2D E9 0C 10 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? 00 00 80 4F }
	condition:
		$1
}

rule file_129_0_0 {
	meta:
		name = "setsgent"
		size = 296
		refs = "0068 __nss_setent 0070 __aeabi_read_tp 00e4 __lll_lock_wait_private 011c __nss_gshadow_lookup2 0120 __libc_errno"
	strings:
		$1 = { F0 41 2D E9 01 10 A0 E3 10 D0 4D E2 FC 20 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 27 00 00 1A CC 40 9F E5 00 10 A0 E3 04 30 44 E2 04 10 8D E5 08 10 8D E5 0C 10 8D E5 B8 00 9F E5 00 40 8D E5 08 20 44 E2 B0 10 9F E5 ?? ?? ?? ?? AC 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 90 E7 0C 60 44 E2 00 50 96 E5 00 10 A0 E3 05 40 A0 E1 7C 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 09 00 00 CA 58 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 80 E7 10 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? D4 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1082_0_0 {
	meta:
		name = "setaliasent"
		size = 296
		refs = "0068 __nss_setent 0070 __aeabi_read_tp 00e4 __lll_lock_wait_private 011c __nss_aliases_lookup2 0120 __libc_errno"
	strings:
		$1 = { F0 41 2D E9 01 10 A0 E3 10 D0 4D E2 FC 20 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 27 00 00 1A CC 40 9F E5 00 10 A0 E3 04 30 44 E2 04 10 8D E5 08 10 8D E5 0C 10 8D E5 B8 00 9F E5 00 40 8D E5 08 20 44 E2 B0 10 9F E5 ?? ?? ?? ?? AC 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 90 E7 0C 60 44 E2 00 50 96 E5 00 10 A0 E3 05 40 A0 E1 7C 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 09 00 00 CA 58 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 80 E7 10 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? D4 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1130_0_0 {
	meta:
		name = "setgrent"
		size = 296
		refs = "0068 __nss_setent 0070 __aeabi_read_tp 00e4 __lll_lock_wait_private 011c __nss_group_lookup2 0120 __libc_errno"
	strings:
		$1 = { F0 41 2D E9 01 10 A0 E3 10 D0 4D E2 FC 20 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 27 00 00 1A CC 40 9F E5 00 10 A0 E3 04 30 44 E2 04 10 8D E5 08 10 8D E5 0C 10 8D E5 B8 00 9F E5 00 40 8D E5 08 20 44 E2 B0 10 9F E5 ?? ?? ?? ?? AC 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 90 E7 0C 60 44 E2 00 50 96 E5 00 10 A0 E3 05 40 A0 E1 7C 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 09 00 00 CA 58 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 80 E7 10 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? D4 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_737_0_0 {
	meta:
		name = "setpwent"
		size = 296
		refs = "0068 __nss_setent 0070 __aeabi_read_tp 00e4 __lll_lock_wait_private 011c __nss_passwd_lookup2 0120 __libc_errno"
	strings:
		$1 = { F0 41 2D E9 01 10 A0 E3 10 D0 4D E2 FC 20 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 27 00 00 1A CC 40 9F E5 00 10 A0 E3 04 30 44 E2 04 10 8D E5 08 10 8D E5 0C 10 8D E5 B8 00 9F E5 00 40 8D E5 08 20 44 E2 B0 10 9F E5 ?? ?? ?? ?? AC 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 90 E7 0C 60 44 E2 00 50 96 E5 00 10 A0 E3 05 40 A0 E1 7C 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 09 00 00 CA 58 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 80 E7 10 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? D4 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_541_0_0 {
	meta:
		name = "setspent"
		size = 296
		refs = "0068 __nss_setent 0070 __aeabi_read_tp 00e4 __lll_lock_wait_private 011c __nss_shadow_lookup2 0120 __libc_errno"
	strings:
		$1 = { F0 41 2D E9 01 10 A0 E3 10 D0 4D E2 FC 20 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 27 00 00 1A CC 40 9F E5 00 10 A0 E3 04 30 44 E2 04 10 8D E5 08 10 8D E5 0C 10 8D E5 B8 00 9F E5 00 40 8D E5 08 20 44 E2 B0 10 9F E5 ?? ?? ?? ?? AC 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 90 E7 0C 60 44 E2 00 50 96 E5 00 10 A0 E3 05 40 A0 E1 7C 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 09 00 00 CA 58 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 80 E7 10 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? D4 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_129_1_0 {
	meta:
		name = "endsgent"
		size = 300
		refs = "0070 __nss_endent 0078 __aeabi_read_tp 00e8 __lll_lock_wait_private 0120 __nss_gshadow_lookup2 0124 __libc_errno"
	strings:
		$1 = { F0 41 2D E9 08 51 9F E5 08 30 95 E5 00 00 53 E3 08 D0 4D E2 2F 00 00 0A 01 10 A0 E3 05 20 A0 E1 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 24 00 00 1A C0 30 9F E5 00 10 A0 E3 00 30 8D E5 08 20 43 E2 04 10 8D E5 04 30 43 E2 AC 00 9F E5 AC 10 9F E5 ?? ?? ?? ?? A8 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 90 E7 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 7C 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 09 00 00 CA 58 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 80 E7 08 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? D7 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1082_1_0 {
	meta:
		name = "endaliasent"
		size = 300
		refs = "0070 __nss_endent 0078 __aeabi_read_tp 00e8 __lll_lock_wait_private 0120 __nss_aliases_lookup2 0124 __libc_errno"
	strings:
		$1 = { F0 41 2D E9 08 51 9F E5 08 30 95 E5 00 00 53 E3 08 D0 4D E2 2F 00 00 0A 01 10 A0 E3 05 20 A0 E1 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 24 00 00 1A C0 30 9F E5 00 10 A0 E3 00 30 8D E5 08 20 43 E2 04 10 8D E5 04 30 43 E2 AC 00 9F E5 AC 10 9F E5 ?? ?? ?? ?? A8 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 90 E7 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 7C 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 09 00 00 CA 58 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 80 E7 08 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? D7 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1130_1_0 {
	meta:
		name = "endgrent"
		size = 300
		refs = "0070 __nss_endent 0078 __aeabi_read_tp 00e8 __lll_lock_wait_private 0120 __nss_group_lookup2 0124 __libc_errno"
	strings:
		$1 = { F0 41 2D E9 08 51 9F E5 08 30 95 E5 00 00 53 E3 08 D0 4D E2 2F 00 00 0A 01 10 A0 E3 05 20 A0 E1 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 24 00 00 1A C0 30 9F E5 00 10 A0 E3 00 30 8D E5 08 20 43 E2 04 10 8D E5 04 30 43 E2 AC 00 9F E5 AC 10 9F E5 ?? ?? ?? ?? A8 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 90 E7 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 7C 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 09 00 00 CA 58 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 80 E7 08 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? D7 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1028_1_0 {
	meta:
		name = "endprotoent"
		size = 300
		refs = "0070 __nss_endent 0078 __aeabi_read_tp 00e8 __lll_lock_wait_private 0120 __nss_protocols_lookup2 0124 __libc_errno"
	strings:
		$1 = { F0 41 2D E9 08 51 9F E5 08 30 95 E5 00 00 53 E3 08 D0 4D E2 2F 00 00 0A 01 10 A0 E3 05 20 A0 E1 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 24 00 00 1A C0 30 9F E5 00 10 A0 E3 00 30 8D E5 08 20 43 E2 04 10 8D E5 04 30 43 E2 AC 00 9F E5 AC 10 9F E5 ?? ?? ?? ?? A8 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 90 E7 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 7C 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 09 00 00 CA 58 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 80 E7 08 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? D7 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_737_1_0 {
	meta:
		name = "endpwent"
		size = 300
		refs = "0070 __nss_endent 0078 __aeabi_read_tp 00e8 __lll_lock_wait_private 0120 __nss_passwd_lookup2 0124 __libc_errno"
	strings:
		$1 = { F0 41 2D E9 08 51 9F E5 08 30 95 E5 00 00 53 E3 08 D0 4D E2 2F 00 00 0A 01 10 A0 E3 05 20 A0 E1 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 24 00 00 1A C0 30 9F E5 00 10 A0 E3 00 30 8D E5 08 20 43 E2 04 10 8D E5 04 30 43 E2 AC 00 9F E5 AC 10 9F E5 ?? ?? ?? ?? A8 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 90 E7 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 7C 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 09 00 00 CA 58 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 80 E7 08 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? D7 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_374_1_0 {
	meta:
		name = "endrpcent"
		size = 300
		refs = "0070 __nss_endent 0078 __aeabi_read_tp 00e8 __lll_lock_wait_private 0120 __nss_rpc_lookup2 0124 __libc_errno"
	strings:
		$1 = { F0 41 2D E9 08 51 9F E5 08 30 95 E5 00 00 53 E3 08 D0 4D E2 2F 00 00 0A 01 10 A0 E3 05 20 A0 E1 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 24 00 00 1A C0 30 9F E5 00 10 A0 E3 00 30 8D E5 08 20 43 E2 04 10 8D E5 04 30 43 E2 AC 00 9F E5 AC 10 9F E5 ?? ?? ?? ?? A8 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 90 E7 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 7C 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 09 00 00 CA 58 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 80 E7 08 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? D7 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1397_1_0 {
	meta:
		name = "endservent"
		size = 300
		refs = "0070 __nss_endent 0078 __aeabi_read_tp 00e8 __lll_lock_wait_private 0120 __nss_services_lookup2 0124 __libc_errno"
	strings:
		$1 = { F0 41 2D E9 08 51 9F E5 08 30 95 E5 00 00 53 E3 08 D0 4D E2 2F 00 00 0A 01 10 A0 E3 05 20 A0 E1 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 24 00 00 1A C0 30 9F E5 00 10 A0 E3 00 30 8D E5 08 20 43 E2 04 10 8D E5 04 30 43 E2 AC 00 9F E5 AC 10 9F E5 ?? ?? ?? ?? A8 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 90 E7 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 7C 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 09 00 00 CA 58 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 80 E7 08 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? D7 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_541_1_0 {
	meta:
		name = "endspent"
		size = 300
		refs = "0070 __nss_endent 0078 __aeabi_read_tp 00e8 __lll_lock_wait_private 0120 __nss_shadow_lookup2 0124 __libc_errno"
	strings:
		$1 = { F0 41 2D E9 08 51 9F E5 08 30 95 E5 00 00 53 E3 08 D0 4D E2 2F 00 00 0A 01 10 A0 E3 05 20 A0 E1 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 24 00 00 1A C0 30 9F E5 00 10 A0 E3 00 30 8D E5 08 20 43 E2 04 10 8D E5 04 30 43 E2 AC 00 9F E5 AC 10 9F E5 ?? ?? ?? ?? A8 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 90 E7 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 7C 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 09 00 00 CA 58 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 80 E7 08 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? D7 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_129_2_0 {
	meta:
		name = "__getsgent_r"
		size = 348
		refs = "0090 __nss_getent_r 00a0 __aeabi_read_tp 0114 __lll_lock_wait_private 0150 __nss_gshadow_lookup2 0154 __libc_errno"
	strings:
		$1 = { F0 43 2D E9 01 70 A0 E1 02 60 A0 E1 2C D0 4D E2 00 80 A0 E1 03 50 A0 E1 01 10 A0 E3 1C 21 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 2F 00 00 1A EC 40 9F E5 00 C0 A0 E3 04 30 84 E2 10 80 8D E5 18 60 8D E5 04 30 8D E5 08 C0 8D E5 04 30 44 E2 0C C0 8D E5 20 C0 8D E5 14 70 8D E5 1C 50 8D E5 00 40 8D E5 BC 00 9F E5 BC 10 9F E5 BC 20 9F E5 ?? ?? ?? ?? B8 30 9F E5 00 80 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 90 90 E7 08 60 44 E2 00 50 96 E5 00 10 A0 E3 05 40 A0 E1 80 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 0A 00 00 CA 60 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 90 80 E7 08 00 A0 E1 2C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? CC FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1082_2_0 {
	meta:
		name = "__getaliasent_r"
		size = 348
		refs = "0090 __nss_getent_r 00a0 __aeabi_read_tp 0114 __lll_lock_wait_private 0150 __nss_aliases_lookup2 0154 __libc_errno"
	strings:
		$1 = { F0 43 2D E9 01 70 A0 E1 02 60 A0 E1 2C D0 4D E2 00 80 A0 E1 03 50 A0 E1 01 10 A0 E3 1C 21 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 2F 00 00 1A EC 40 9F E5 00 C0 A0 E3 04 30 84 E2 10 80 8D E5 18 60 8D E5 04 30 8D E5 08 C0 8D E5 04 30 44 E2 0C C0 8D E5 20 C0 8D E5 14 70 8D E5 1C 50 8D E5 00 40 8D E5 BC 00 9F E5 BC 10 9F E5 BC 20 9F E5 ?? ?? ?? ?? B8 30 9F E5 00 80 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 90 90 E7 08 60 44 E2 00 50 96 E5 00 10 A0 E3 05 40 A0 E1 80 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 0A 00 00 CA 60 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 90 80 E7 08 00 A0 E1 2C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? CC FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1130_2_0 {
	meta:
		name = "__getgrent_r"
		size = 348
		refs = "0090 __nss_getent_r 00a0 __aeabi_read_tp 0114 __lll_lock_wait_private 0150 __nss_group_lookup2 0154 __libc_errno"
	strings:
		$1 = { F0 43 2D E9 01 70 A0 E1 02 60 A0 E1 2C D0 4D E2 00 80 A0 E1 03 50 A0 E1 01 10 A0 E3 1C 21 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 2F 00 00 1A EC 40 9F E5 00 C0 A0 E3 04 30 84 E2 10 80 8D E5 18 60 8D E5 04 30 8D E5 08 C0 8D E5 04 30 44 E2 0C C0 8D E5 20 C0 8D E5 14 70 8D E5 1C 50 8D E5 00 40 8D E5 BC 00 9F E5 BC 10 9F E5 BC 20 9F E5 ?? ?? ?? ?? B8 30 9F E5 00 80 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 90 90 E7 08 60 44 E2 00 50 96 E5 00 10 A0 E3 05 40 A0 E1 80 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 0A 00 00 CA 60 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 90 80 E7 08 00 A0 E1 2C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? CC FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_737_2_0 {
	meta:
		name = "__getpwent_r"
		size = 348
		refs = "0090 __nss_getent_r 00a0 __aeabi_read_tp 0114 __lll_lock_wait_private 0150 __nss_passwd_lookup2 0154 __libc_errno"
	strings:
		$1 = { F0 43 2D E9 01 70 A0 E1 02 60 A0 E1 2C D0 4D E2 00 80 A0 E1 03 50 A0 E1 01 10 A0 E3 1C 21 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 2F 00 00 1A EC 40 9F E5 00 C0 A0 E3 04 30 84 E2 10 80 8D E5 18 60 8D E5 04 30 8D E5 08 C0 8D E5 04 30 44 E2 0C C0 8D E5 20 C0 8D E5 14 70 8D E5 1C 50 8D E5 00 40 8D E5 BC 00 9F E5 BC 10 9F E5 BC 20 9F E5 ?? ?? ?? ?? B8 30 9F E5 00 80 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 90 90 E7 08 60 44 E2 00 50 96 E5 00 10 A0 E3 05 40 A0 E1 80 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 0A 00 00 CA 60 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 90 80 E7 08 00 A0 E1 2C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? CC FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_541_2_0 {
	meta:
		name = "__getspent_r"
		size = 348
		refs = "0090 __nss_getent_r 00a0 __aeabi_read_tp 0114 __lll_lock_wait_private 0150 __nss_shadow_lookup2 0154 __libc_errno"
	strings:
		$1 = { F0 43 2D E9 01 70 A0 E1 02 60 A0 E1 2C D0 4D E2 00 80 A0 E1 03 50 A0 E1 01 10 A0 E3 1C 21 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 2F 00 00 1A EC 40 9F E5 00 C0 A0 E3 04 30 84 E2 10 80 8D E5 18 60 8D E5 04 30 8D E5 08 C0 8D E5 04 30 44 E2 0C C0 8D E5 20 C0 8D E5 14 70 8D E5 1C 50 8D E5 00 40 8D E5 BC 00 9F E5 BC 10 9F E5 BC 20 9F E5 ?? ?? ?? ?? B8 30 9F E5 00 80 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 90 90 E7 08 60 44 E2 00 50 96 E5 00 10 A0 E3 05 40 A0 E1 80 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 0A 00 00 CA 60 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 90 80 E7 08 00 A0 E1 2C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? CC FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_130_0_0 {
	meta:
		name = "__gethostname"
		size = 136
		refs = "0014 uname 0028 strlen 0044 memcpy 006c __aeabi_read_tp 0084 __libc_errno"
	strings:
		$1 = { F0 41 2D E9 62 DF 4D E2 00 80 A0 E1 0D 00 A0 E1 01 40 A0 E1 ?? ?? ?? ?? 00 70 50 E2 0F 00 00 1A 41 60 8D E2 06 00 A0 E1 ?? ?? ?? ?? 01 50 80 E2 04 00 55 E1 05 20 A0 31 04 20 A0 21 06 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 04 00 55 E1 05 00 00 8A 07 00 A0 E1 62 DF 8D E2 F0 41 BD E8 ?? ?? ?? ?? 00 70 E0 E3 F9 FF FF EA 14 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 24 20 A0 E3 03 20 80 E7 00 70 E0 E3 F2 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_131_0_0 {
	meta:
		name = "posix_spawnattr_setsigdefault"
		size = 28
		refs = "000c memcpy"
	strings:
		$1 = { 08 40 2D E9 08 00 80 E2 80 20 A0 E3 ?? ?? ?? ?? 00 00 A0 E3 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_132_0_0 {
	meta:
		name = "fchflags"
		size = 84
		refs = "0010 __aeabi_read_tp 004c __libc_errno"
	strings:
		$1 = { 00 00 50 E3 04 E0 2D E5 07 00 00 BA 38 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 26 20 A0 E3 03 20 80 E7 04 E0 9D E4 00 00 E0 E3 ?? ?? ?? ?? 1C 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 04 E0 9D E4 00 00 E0 E3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_134_0_0 {
	meta:
		name = "trans_compare"
		size = 24
		refs = "000c strcmp"
		altNames = "__gconv_alias_compare known_compare"
	strings:
		$1 = { 08 40 2D E9 00 00 90 E5 00 10 91 E5 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_28_4 {
	meta:
		name = "_ZN11__gnu_debug19_Safe_iterator_base12_M_get_mutexEv"
		size = 32
		refs = "0008 _ZN12_GLOBAL__N_119get_safe_base_mutexEPv 0018 __cxa_end_cleanup 001c __cxa_call_unexpected"
	strings:
		$1 = { 08 40 2D E9 00 00 90 E5 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? 01 00 71 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_6_4 {
	meta:
		name = "_ZNSt12__basic_fileIcE2fdEv"
		size = 20
		refs = "0008 fileno"
	strings:
		$1 = { 08 40 2D E9 00 00 90 E5 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_14_4 {
	meta:
		name = "_ZNSt12__basic_fileIcE4syncEv"
		size = 20
		refs = "0008 fflush"
	strings:
		$1 = { 08 40 2D E9 00 00 90 E5 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_5_4 {
	meta:
		name = "_ZNSt6locale5facet17_S_clone_c_localeERP15__locale_struct"
		size = 20
		refs = "0008 __duplocale"
	strings:
		$1 = { 08 40 2D E9 00 00 90 E5 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1230_0_0 {
	meta:
		name = "alias_compare"
		size = 32
		refs = "0010 __strcasecmp_l 001c _nl_C_locobj"
	strings:
		$1 = { 08 40 2D E9 00 00 90 E5 00 10 91 E5 08 20 9F E5 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_134_1_0 {
	meta:
		name = "open_translit"
		size = 220
		refs = "0010 __libc_dlopen_mode 0028 __libc_dlsym 0054 __libc_dlclose"
	strings:
		$1 = { 38 40 2D E9 06 11 A0 E3 00 40 A0 E1 20 00 90 E5 ?? ?? ?? ?? 00 00 50 E3 24 00 84 E5 01 50 A0 03 0F 00 00 0A A0 10 9F E5 ?? ?? ?? ?? 00 30 50 E2 06 00 00 0A 04 10 A0 E1 08 00 91 E4 0C 20 84 E2 0F E0 A0 E1 ?? ?? ?? ?? 00 50 50 E2 07 00 00 0A 24 00 94 E5 ?? ?? ?? ?? 00 30 A0 E3 24 30 84 E5 01 50 A0 E3 05 00 A0 E1 38 40 BD E8 ?? ?? ?? ?? 24 00 94 E5 54 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 10 00 84 E5 F1 FF FF 0A 24 00 94 E5 40 10 9F E5 ?? ?? ?? ?? 30 10 9F E5 18 00 84 E5 24 00 94 E5 ?? ?? ?? ?? 2C 10 9F E5 14 00 84 E5 24 00 94 E5 ?? ?? ?? ?? 01 30 A0 E3 1C 00 84 E5 28 30 84 E5 05 00 A0 E1 38 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_134_2_0 {
	meta:
		name = "__gconv_transliterate"
		size = 1108
		refs = "0010 __aeabi_read_tp 01cc __aeabi_uidivmod 02d8 _dl_mcount_wrapper_check 044c _nl_current_LC_CTYPE"
	strings:
		$1 = { F0 4F 2D E9 4C D0 4D E2 28 00 8D E5 38 34 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 60 90 E7 00 B0 96 E5 70 20 9D E5 18 01 9B E5 30 10 8D E5 00 20 92 E5 28 10 9D E5 00 00 50 E3 10 00 8D E5 14 70 91 E5 18 20 8D E5 78 90 9D E5 42 00 00 0A 74 00 9D E5 04 30 82 E2 03 00 50 E1 1C 11 9B E5 20 21 9B E5 24 01 9B E5 2C 10 8D E5 24 20 8D E5 34 00 8D E5 28 A1 9B E5 70 00 00 3A 74 00 9D E5 03 20 80 E2 00 10 A0 E3 02 30 63 E0 23 61 A0 E1 20 10 8D E5 01 60 86 E2 01 50 A0 E1 10 20 9D E5 20 00 9D E5 2C 10 9D E5 00 30 82 E0 A3 30 A0 E1 03 11 91 E7 24 20 9D E5 1C 30 8D E5 14 10 8D E5 01 01 92 E7 18 30 9D E5 01 11 82 E0 00 40 A0 E3 05 00 00 EA 04 00 B1 E5 00 00 50 E3 01 40 84 E2 64 00 00 0A 06 00 54 E1 58 00 00 0A 00 C0 93 E5 00 00 5C E1 03 20 A0 E1 04 30 83 E2 F4 FF FF 0A 00 00 54 E3 59 00 00 1A 74 00 9D E5 02 00 50 E1 52 00 00 9A 14 10 9D E5 24 30 9D E5 01 40 84 E0 04 11 93 E7 00 30 92 E5 03 00 51 E1 4B 00 00 3A 1C 10 9D E5 10 10 8D E5 20 20 9D E5 10 30 9D E5 03 00 52 E1 D4 FF FF 3A 04 33 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 60 90 E7 00 B0 96 E5 34 A1 9B E5 00 00 5A E3 06 00 00 1A 2C 31 9B E5 00 00 53 E3 06 00 A0 03 23 00 00 1A 4C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 70 20 9D E5 18 00 9D E5 74 10 9D E5 00 20 92 E5 04 30 80 E2 03 00 51 E1 10 20 8D E5 00 80 92 E5 38 41 9B E5 63 00 00 3A 00 00 5A E3 00 50 A0 C3 0B 00 00 CA EA FF FF EA 04 30 94 E5 03 00 58 E1 08 00 60 E0 03 00 00 8A 08 10 94 E5 ?? ?? ?? ?? 00 00 51 E3 91 00 00 0A 05 00 5A E1 0C 40 84 E2 DF FF FF 0A 00 00 94 E5 00 00 58 E1 01 50 85 E2 F0 FF FF 2A 2C 31 9B E5 00 00 53 E3 06 00 A0 03 DB FF FF 0A 30 51 9B E5 18 30 9D E5 40 50 8D E5 74 00 9D E5 04 20 83 E2 00 30 96 E5 02 00 50 E1 2C 61 93 E5 5F 00 00 2A 18 10 9D E5 00 00 51 E1 04 00 A0 03 07 00 A0 13 CD FF FF EA 18 10 9D E5 74 20 9D E5 02 00 51 E1 3E 00 00 0A 07 00 A0 E3 4C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 1C 00 9D E5 01 00 80 E2 20 00 8D E5 B1 FF FF EA 00 00 50 E3 F5 FF FF 1A 1C 30 9D E5 34 00 9D E5 03 81 90 E7 3C 60 8D E5 08 31 9A E7 38 40 8D E5 28 B0 9D E5 30 60 9D E5 00 00 53 E3 08 21 8A E0 23 00 00 0A 01 80 88 E2 02 30 A0 E1 00 00 00 EA 01 80 A0 E1 04 10 93 E5 00 00 51 E3 04 30 83 E2 01 10 88 E2 F9 FF FF 1A 03 40 A0 E1 00 10 99 E5 07 00 A0 E1 40 20 8D E5 44 10 8D E5 ?? ?? ?? ?? 44 10 8D E2 22 00 8D E8 08 50 8D E5 0C 50 8D E5 04 30 A0 E1 0B 00 A0 E1 06 10 A0 E1 40 20 8D E2 0F E0 A0 E1 ?? ?? ?? ?? 06 00 50 E3 10 00 00 1A 01 80 88 E2 08 31 9A E7 00 00 53 E3 DD FF FF 1A 38 40 8D E2 50 00 94 E8 18 30 9D E5 04 21 83 E0 74 FF FF EA 02 40 A0 E1 E3 FF FF EA 18 20 9D E5 74 30 9D E5 03 00 52 E1 C0 FF FF 1A 04 00 A0 E3 88 FF FF EA 04 00 50 E3 38 40 9D E5 06 00 00 0A 05 00 50 E3 83 FF FF 0A 44 30 9D E5 00 30 89 E5 4C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 70 30 9D E5 7C 00 9D E5 00 20 93 E5 00 30 90 E5 04 41 82 E0 70 10 9D E5 7C 20 9D E5 01 30 83 E2 00 40 81 E5 00 00 A0 E3 00 30 82 E5 EE FF FF EA 00 30 99 E5 07 00 A0 E1 00 40 A0 E3 44 30 8D E5 ?? ?? ?? ?? 44 20 8D E2 14 00 8D E8 28 00 9D E5 30 10 9D E5 06 31 85 E0 08 40 8D E5 0C 40 8D E5 40 20 8D E2 0F E0 A0 E1 ?? ?? ?? ?? 06 00 50 E3 61 FF FF 0A 04 00 50 E3 DB FF FF 1A 70 00 9D E5 7C 30 9D E5 00 20 93 E5 00 30 90 E5 7C 10 9D E5 01 20 82 E2 04 30 83 E2 00 20 81 E5 00 30 80 E5 04 00 A0 E1 D0 FF FF EA 7C 00 9D E5 00 30 90 E5 10 00 9D E5 04 20 80 E2 70 00 9D E5 00 20 80 E5 01 00 A0 E1 7C 10 9D E5 01 30 83 E2 00 30 81 E5 49 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_134_3_0 {
	meta:
		name = "__gconv_translit_find"
		size = 712
		refs = "005c __tfind 00e8 strlen 0120 memcmp 013c malloc 0188 mempcpy 01c4 stpcpy 01e4 memcpy 0204 __tsearch 0254 __gconv_get_path 0260 __aeabi_read_tp 0288 __lll_lock_wait_private 02a0 __assert_fail 02ac trans_compare 02b0 __gconv_path_elem 02b8 __gconv_max_path_elem_len"
	strings:
		$1 = { F0 43 2D E9 00 30 90 E5 00 00 53 E3 0C D0 4D E2 00 50 A0 E1 9D 00 00 0A 01 10 A0 E3 80 22 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 8C 00 00 1A 05 00 A0 E1 4C 12 9F E5 4C 22 9F E5 ?? ?? ?? ?? 00 40 50 E2 1E 00 00 0A 00 00 94 E5 24 30 90 E5 00 00 53 E3 18 00 00 0A 01 00 73 E3 00 60 A0 13 65 00 00 0A 18 72 9F E5 00 50 97 E5 00 10 A0 E3 05 40 A0 E1 08 22 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 64 00 00 CA 06 00 A0 E1 0C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 01 60 A0 E3 E7 FF FF EA 00 00 95 E5 ?? ?? ?? ?? BC 61 9F E5 00 30 96 E5 00 00 53 E3 01 80 80 E2 53 00 00 0A 04 00 58 E3 01 90 A0 93 07 00 00 9A 00 30 95 E5 03 00 40 E2 00 00 83 E0 94 11 9F E5 03 20 A0 E3 ?? ?? ?? ?? 00 90 90 E2 01 90 A0 13 84 31 9F E5 00 00 93 E5 2F 00 80 E2 88 00 80 E0 ?? ?? ?? ?? 00 40 50 E2 E4 FF FF 0A 00 20 A0 E3 08 30 84 E2 04 20 84 E5 04 20 83 E4 04 20 83 E4 04 20 83 E4 04 20 83 E4 04 20 83 E4 04 20 83 E4 04 20 83 E4 04 20 83 E4 2C 00 84 E2 00 20 83 E5 00 00 84 E5 08 20 A0 E1 00 10 95 E5 ?? ?? ?? ?? 00 70 96 E5 00 10 97 E5 00 00 51 E3 20 00 84 E5 08 00 00 1A 11 00 00 EA 04 00 A0 E1 48 FE FF EB 00 00 50 E3 17 00 00 0A 08 10 B7 E5 00 00 51 E3 0A 00 00 0A 20 00 94 E5 ?? ?? ?? ?? 00 10 95 E5 08 20 A0 E1 ?? ?? ?? ?? 00 00 59 E3 F1 FF FF 0A D0 10 9F E5 04 20 A0 E3 ?? ?? ?? ?? ED FF FF EA 00 30 A0 E3 20 30 84 E5 01 60 A0 E3 04 00 A0 E1 A4 10 9F E5 A4 20 9F E5 ?? ?? ?? ?? 00 00 50 E3 01 60 A0 03 9B FF FF EA 00 60 A0 E1 F6 FF FF EA 2B FE FF EB 00 60 50 E2 AC FF FF 1A 00 C0 94 E5 0F 00 BC E8 0F 00 A5 E8 0F 00 9C E8 0F 00 85 E8 00 30 94 E5 28 20 93 E5 01 20 82 E2 28 20 83 E5 8C FF FF EA 04 00 8D E5 ?? ?? ?? ?? 04 00 9D E5 A7 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 2C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 91 FF FF EA 02 00 A0 E1 ?? ?? ?? ?? 6F FF FF EA 24 00 9F E5 24 10 9F E5 53 2F A0 E3 20 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_135_0_0 {
	meta:
		name = "_itoa_word"
		size = 260
		refs = "0040 __aeabi_uidivmod 0058 __aeabi_uidiv 00f8 _itoa_upper_digits 00fc _itoa_lower_digits"
	strings:
		$1 = { F0 C0 9F E5 00 00 53 E3 F0 41 2D E9 E8 60 9F E5 0C 60 A0 11 0A 00 52 E3 02 70 A0 E1 00 40 A0 E1 26 00 00 0A 10 00 52 E3 1A 00 00 0A 08 00 52 E3 01 80 41 12 0D 00 00 0A 04 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 01 30 D6 E7 04 00 A0 E1 08 50 A0 E1 07 10 A0 E1 01 30 48 E4 ?? ?? ?? ?? 00 40 50 E2 F4 FF FF 1A 05 00 A0 E1 F0 41 BD E8 ?? ?? ?? ?? 01 10 41 E2 07 30 04 E2 03 30 D6 E7 A4 41 B0 E1 01 50 A0 E1 01 30 41 E4 F9 FF FF 1A 05 00 A0 E1 F0 41 BD E8 ?? ?? ?? ?? 01 10 41 E2 0F 30 04 E2 03 30 D6 E7 24 42 B0 E1 01 50 A0 E1 01 30 41 E4 F9 FF FF 1A 05 00 A0 E1 F0 41 BD E8 ?? ?? ?? ?? 38 00 9F E5 01 10 41 E2 90 34 82 E0 A2 21 A0 E1 02 31 82 E0 83 40 44 E0 04 30 D6 E7 00 40 52 E2 01 50 A0 E1 01 30 41 E4 F6 FF FF 1A 05 00 A0 E1 F0 41 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? CD CC CC CC }
	condition:
		$1
}

rule file_135_1_0 {
	meta:
		name = "_itoa"
		size = 1200
		refs = "04a4 _itoa_lower_digits 04a8 _itoa_upper_digits"
	strings:
		$1 = { F0 0F 2D E9 30 D0 4D E2 50 50 9D E5 90 44 9F E5 90 C4 9F E5 00 00 55 E3 04 50 A0 01 0C 50 A0 11 08 00 53 E3 03 60 A0 E1 02 A0 A0 E1 62 00 00 0A 10 00 53 E3 15 00 00 1A 00 00 51 E3 00 10 A0 01 08 00 00 0A 02 30 A0 E1 08 C0 42 E2 0F 20 00 E2 02 20 D5 E7 01 20 63 E5 0C 00 53 E1 20 02 A0 E1 F9 FF FF 1A 03 A0 A0 E1 01 30 4A E2 0F 20 01 E2 02 20 D5 E7 21 12 B0 E1 03 00 A0 E1 01 20 43 E4 F9 FF FF 1A 30 D0 8D E2 F0 0F BD E8 ?? ?? ?? ?? 02 30 43 E2 10 24 9F E5 03 31 83 E0 00 00 51 E3 03 41 82 E0 61 00 00 1A 24 00 8D E5 00 C0 A0 E1 01 90 A0 E3 04 10 D4 E5 30 20 8D E2 09 91 82 E0 20 30 8D E2 00 00 51 E3 14 90 49 E2 0C 30 8D E5 0A 00 A0 E1 30 80 A0 E3 00 70 94 E5 21 00 00 1A 00 00 5C E3 01 B0 40 12 01 00 00 1A BF 00 00 EA 03 C0 A0 E1 9C 27 83 E0 05 20 D4 E5 33 32 A0 E1 96 03 02 E0 0C C0 62 E0 0C 20 D5 E7 00 00 53 E3 0B 00 A0 E1 01 10 81 E2 01 20 4B E4 F3 FF FF 1A 0C C0 9D E5 0C 00 59 E1 D7 00 00 0A 09 30 D4 E5 03 00 51 E1 06 00 00 AA 01 30 40 E2 03 00 A0 E1 01 80 43 E4 09 20 D4 E5 01 10 81 E2 01 00 52 E1 F9 FF FF CA 04 10 D4 E5 00 00 51 E3 04 C0 19 E4 00 70 94 E5 DD FF FF 0A 00 00 5C E3 9F 00 00 0A 01 B0 40 E2 00 10 A0 E3 00 00 00 EA 03 C0 A0 E1 9C 27 83 E0 05 00 D4 E5 0C 20 63 E0 A2 20 83 E0 01 30 40 E2 32 33 A0 E1 96 03 02 E0 0C C0 62 E0 0C 20 D5 E7 00 00 53 E3 0B 00 A0 E1 01 10 81 E2 01 20 4B E4 F0 FF FF 1A D8 FF FF EA 00 00 51 E3 00 C0 A0 01 0F 00 00 0A 02 30 A0 E1 0A C0 42 E2 07 20 00 E2 02 20 D5 E7 01 20 63 E5 0C 00 53 E1 A0 01 A0 E1 F9 FF FF 1A 01 C0 01 E2 0C C1 80 E1 A1 10 B0 E1 0C 30 D5 17 03 A0 A0 01 0B 30 4A 15 01 C0 A0 11 0B A0 4A 12 01 30 4A E2 07 20 0C E2 02 20 D5 E7 AC C1 B0 E1 03 00 A0 E1 01 20 43 E4 F9 FF FF 1A 30 D0 8D E2 F0 0F BD E8 ?? ?? ?? ?? 0C 30 94 E5 08 70 D4 E5 03 00 51 E1 13 B7 A0 E1 6C 00 00 3A 00 00 57 E3 8A 00 00 0A 40 30 67 E2 30 83 A0 E1 20 20 63 E2 11 82 88 E1 20 30 43 E2 31 83 88 E1 00 30 A0 E3 08 20 A0 E1 0C 00 8D E8 14 80 8D E5 20 30 67 E2 30 C3 A0 E1 10 80 94 E5 0C 80 8D E5 0C 90 9D E5 00 80 9D E5 10 30 8D E5 98 29 83 E0 18 20 8D E5 1C 30 8D E5 10 20 9D E5 20 30 62 E2 11 C3 8C E1 09 80 A0 E1 04 30 9D E5 1C 90 9D E5 93 98 28 E0 20 90 42 E2 14 20 9D E5 08 80 82 E0 31 C9 8C E1 98 2B 83 E0 14 90 9D E5 02 10 5C E0 03 20 C9 E0 00 00 52 E3 09 00 00 0A 0B C0 51 E0 00 20 C2 E2 00 00 52 E3 0C 10 A0 E1 01 80 88 02 03 00 00 0A 0B 30 5C E0 00 20 C2 E2 02 80 88 E2 03 10 A0 E1 0B 00 51 E1 0C 90 9D E5 01 10 6B 20 91 29 83 E0 03 90 81 E0 01 80 88 22 10 07 A0 E1 99 2B 83 E0 02 C0 50 E0 03 20 C1 E0 00 00 52 E3 09 00 00 0A 0B 10 5C E0 00 20 C2 E2 00 00 52 E3 01 C0 A0 E1 01 90 89 02 03 00 00 0A 0B 30 51 E0 00 20 C2 E2 02 90 89 E2 03 C0 A0 E1 0B 00 5C E1 01 90 89 22 0C C0 6B 20 00 00 57 E3 10 10 9D 15 39 31 A0 11 18 87 83 11 3C C7 A0 E1 0C 10 9D E5 98 21 83 E0 03 00 88 E0 19 97 A0 E1 90 2B 83 E0 02 10 59 E0 03 20 C8 E0 00 00 52 E3 2C C0 8D E5 09 00 00 0A 0B 30 51 E0 00 20 C2 E2 00 00 52 E3 03 10 A0 E1 01 00 80 02 03 00 00 0A 0B 80 53 E0 00 20 C2 E2 02 00 80 E2 08 10 A0 E1 0B 00 51 E1 01 10 6B 20 31 17 A0 E1 01 00 80 22 24 00 8D E5 28 10 8D E5 03 90 A0 E3 30 FF FF EA 0C 10 A0 E1 49 FF FF EA 11 17 A0 E1 20 30 47 E2 10 13 81 E1 20 30 67 E2 30 13 81 E1 10 C0 94 E5 91 2C 83 E0 03 80 81 E0 10 07 A0 E1 98 2B 83 E0 02 C0 50 E0 03 20 C1 E0 00 00 52 E3 09 00 00 0A 0B 90 5C E0 00 20 C2 E2 00 00 52 E3 09 C0 A0 E1 01 80 88 02 03 00 00 0A 0B 10 59 E0 00 20 C2 E2 02 80 88 E2 01 C0 A0 E1 0B 00 5C E1 0C C0 6B 20 3C C7 A0 E1 01 80 88 22 24 80 8D E5 28 C0 8D E5 02 90 A0 E3 0E FF FF EA 00 20 A0 E3 00 30 A0 E3 0C 00 8D E8 14 70 8D E5 79 FF FF EA 0A 00 50 E1 00 20 A0 E1 30 30 A0 03 01 00 40 02 01 30 42 05 F7 FE FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_135_2_0 {
	meta:
		name = "_fitoa_word"
		size = 84
		refs = "0010 _itoa_word"
	strings:
		$1 = { 10 40 2D E9 10 D0 4D E2 01 40 A0 E1 10 10 8D E2 ?? ?? ?? ?? 10 10 8D E2 01 00 50 E1 08 00 00 2A 00 30 A0 E1 04 20 A0 E1 01 C0 D3 E4 10 10 8D E2 01 00 53 E1 01 C0 C2 E4 FA FF FF 1A 01 00 60 E0 00 40 84 E0 04 00 A0 E1 10 D0 8D E2 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_135_3_0 {
	meta:
		name = "_fitoa"
		size = 92
		refs = "0018 _itoa"
	strings:
		$1 = { 10 40 2D E9 28 D0 4D E2 30 C0 9D E5 02 40 A0 E1 00 C0 8D E5 28 20 8D E2 ?? ?? ?? ?? 28 20 8D E2 02 00 50 E1 08 00 00 2A 00 30 A0 E1 04 10 A0 E1 01 C0 D3 E4 28 20 8D E2 02 00 53 E1 01 C0 C1 E4 FA FF FF 1A 02 00 60 E0 00 40 84 E0 04 00 A0 E1 28 D0 8D E2 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_136_0_0 {
	meta:
		name = "__setsid"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 42 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_138_0_0 {
	meta:
		name = "__nscd_getgrouplist"
		size = 916
		refs = "0018 strlen 0034 __nscd_get_map_ref 0068 __nscd_cache_search 0208 __nscd_open_socket 0254 memcpy 02a0 __nscd_unmap 02c0 realloc 02f0 __readall 033c __assert_fail 037c __gr_map_handle 0380 __nss_not_use_nscd_group"
	strings:
		$1 = { F0 4F 2D E9 2C D0 4D E2 01 80 A0 E1 02 A0 A0 E1 03 90 A0 E1 14 00 8D E5 ?? ?? ?? ?? 01 00 80 E2 10 00 8D E5 4C 13 9F E5 4C 23 9F E5 0C 00 A0 E3 18 30 8D E2 ?? ?? ?? ?? 1C 50 8D E2 08 50 8D E5 00 60 A0 E1 00 B0 A0 E3 01 00 76 E3 67 00 00 0A 0C 20 A0 E3 00 20 8D E5 0F 00 A0 E3 14 10 9D E5 10 20 9D E5 06 30 A0 E1 ?? ?? ?? ?? 00 40 50 E2 5E 00 00 0A 00 C0 96 E5 18 70 9D E5 08 50 9C E5 07 00 55 E1 04 50 94 E5 18 30 84 E2 07 00 93 E8 0C 50 8D E5 08 50 9D E5 07 00 85 E8 0C 50 9D E5 24 40 84 E2 05 30 83 E0 96 00 00 1A 24 20 9D E5 02 21 84 E0 02 00 53 E1 94 00 00 3A 20 50 9D E5 01 00 55 E3 00 70 E0 E3 56 00 00 0A 01 00 75 E3 9D 00 00 0A 00 30 9A E5 00 00 53 E3 9E 00 00 DA 00 00 99 E5 00 30 A0 E3 03 81 80 E7 01 50 83 E2 01 00 77 E3 02 00 00 0A 07 00 A0 E1 06 70 A0 E3 00 00 00 EF 01 00 76 E3 16 00 00 0A 00 C0 96 E5 18 70 9D E5 08 30 9C E5 03 00 57 E1 15 00 00 1A 0C 80 86 E2 0C 70 96 E5 08 20 A0 E1 01 10 47 E2 07 40 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 57 E1 F0 FF FF 1A 01 00 57 E3 4C 00 00 0A 05 00 A0 E1 2C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 01 00 13 E3 18 30 8D E5 04 00 00 1A 01 B0 8B E2 05 00 5B E3 01 00 00 0A 01 00 75 E3 AB FF FF 1A 0C 20 86 E2 0C 20 8D E5 0C 70 96 E5 0C 20 9D E5 01 10 47 E2 07 40 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 57 E1 F0 FF FF 1A 01 00 57 E3 56 00 00 0A 01 00 75 E3 DE FF FF 0A 00 60 E0 E3 0C 30 A0 E3 00 30 8D E5 14 00 9D E5 10 10 9D E5 0F 20 A0 E3 1C 30 8D E2 ?? ?? ?? ?? 01 00 70 E3 00 70 A0 E1 3F 00 00 0A 20 50 9D E5 01 00 55 E3 00 40 A0 E3 A8 FF FF 1A 24 50 9D E5 00 00 55 E3 3D 00 00 BA 00 30 9A E5 03 00 55 E1 1C 00 00 AA 00 00 54 E3 00 00 99 E5 25 00 00 0A 04 10 A0 E1 05 21 A0 E1 ?? ?? ?? ?? 00 00 55 E3 A3 FF FF BA 00 00 99 E5 41 00 00 0A 00 30 90 E5 08 00 53 E1 9E FF FF 0A 00 20 A0 E1 00 30 A0 E3 02 00 00 EA 04 10 B2 E5 08 00 51 E1 98 FF FF 0A 01 30 83 E2 05 00 53 E1 F9 FF FF 1A 92 FF FF EA 06 00 A0 E1 ?? ?? ?? ?? 05 00 A0 E1 2C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 01 10 85 E2 01 11 A0 E1 00 00 99 E5 ?? ?? ?? ?? 00 00 50 E3 0C 00 00 0A 24 50 9D E5 00 00 54 E3 01 30 85 E2 00 00 89 E5 00 30 8A E5 D9 FF FF 1A 00 10 A0 E1 05 21 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 24 50 9D E5 05 01 50 E1 D5 FF FF 0A 00 50 E0 E3 79 FF FF EA 01 50 E0 E3 80 FF FF EA 00 50 E0 E3 7E FF FF EA 60 20 9F E5 01 30 A0 E3 00 30 82 E5 07 50 A0 E1 75 FF FF EA 50 00 9F E5 50 10 9F E5 64 20 A0 E3 4C 30 9F E5 ?? ?? ?? ?? 06 00 A0 E1 ?? ?? ?? ?? A5 FF FF EA 2C 20 9F E5 01 30 A0 E3 00 30 82 E5 64 FF FF EA 2C 00 9F E5 20 10 9F E5 8F 20 A0 E3 1C 30 9F E5 ?? ?? ?? ?? 05 30 A0 E1 5B FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "__uselocale"
		size = 624
		refs = "0010 __aeabi_read_tp 01f8 __libc_tsd_LOCALE 01fc _nl_global_locale 0204 _nl_current_LC_COLLATE_used 0208 _nl_current_LC_COLLATE 020c _nl_current_LC_CTYPE_used 0210 _nl_current_LC_CTYPE 0214 _nl_current_LC_MONETARY_used 0218 _nl_current_LC_MONETARY 021c _nl_current_LC_NUMERIC_used 0220 _nl_current_LC_NUMERIC 0224 _nl_current_LC_TIME_used 0228 _nl_current_LC_TIME 022c _nl_current_LC_MESSAGES_used 0230 _nl_current_LC_MESSAGES 0234 _nl_current_LC_PAPER_used 0238 _nl_current_LC_PAPER 023c _nl_current_LC_NAME_used 0240 _nl_current_LC_NAME 0244 _nl_current_LC_ADDRESS_used 0248 _nl_current_LC_ADDRESS 024c _nl_current_LC_TELEPHONE_used 0250 _nl_current_LC_TELEPHONE 0254 _nl_current_LC_MEASUREMENT_used 0258 _nl_current_LC_MEASUREMENT 025c _nl_current_LC_IDENTIFICATION_used 0260 _nl_current_LC_IDENTIFICATION 0264 __libc_tsd_CTYPE_B 0268 __libc_tsd_CTYPE_TOLOWER 026c __libc_tsd_CTYPE_TOUPPER"
	strings:
		$1 = { 30 40 2D E9 EC 21 9F E5 00 30 A0 E1 02 20 9F E7 ?? ?? ?? ?? 00 00 53 E3 DC 41 9F E5 02 10 90 E7 6F 00 00 0A D4 21 9F E5 D4 51 9F E5 01 00 73 E3 02 20 9F E7 04 30 A0 01 ?? ?? ?? ?? 00 00 55 E3 02 30 80 E7 BC 21 9F 15 0C C0 83 12 02 20 9F 17 02 C0 80 17 B0 21 9F E5 00 00 52 E3 03 00 00 0A A8 21 9F E5 ?? ?? ?? ?? 02 20 9F E7 02 30 80 E7 9C 21 9F E5 00 00 52 E3 04 00 00 0A 94 21 9F E5 ?? ?? ?? ?? 02 20 9F E7 10 C0 83 E2 02 C0 80 E7 84 21 9F E5 00 00 52 E3 04 00 00 0A 7C 21 9F E5 ?? ?? ?? ?? 02 20 9F E7 04 C0 83 E2 02 C0 80 E7 6C 21 9F E5 00 00 52 E3 04 00 00 0A 64 21 9F E5 ?? ?? ?? ?? 02 20 9F E7 08 C0 83 E2 02 C0 80 E7 54 21 9F E5 00 00 52 E3 04 00 00 0A 4C 21 9F E5 ?? ?? ?? ?? 02 20 9F E7 14 C0 83 E2 02 C0 80 E7 3C 21 9F E5 00 00 52 E3 04 00 00 0A 34 21 9F E5 ?? ?? ?? ?? 02 20 9F E7 1C C0 83 E2 02 C0 80 E7 24 21 9F E5 00 00 52 E3 04 00 00 0A 1C 21 9F E5 ?? ?? ?? ?? 02 20 9F E7 20 C0 83 E2 02 C0 80 E7 0C 21 9F E5 00 00 52 E3 04 00 00 0A 04 21 9F E5 ?? ?? ?? ?? 02 20 9F E7 24 C0 83 E2 02 C0 80 E7 F4 20 9F E5 00 00 52 E3 04 00 00 0A EC 20 9F E5 ?? ?? ?? ?? 02 20 9F E7 28 C0 83 E2 02 C0 80 E7 DC 20 9F E5 00 00 52 E3 04 00 00 0A D4 20 9F E5 ?? ?? ?? ?? 02 20 9F E7 2C C0 83 E2 02 C0 80 E7 C4 20 9F E5 00 00 52 E3 04 00 00 0A BC 20 9F E5 ?? ?? ?? ?? 02 20 9F E7 30 C0 83 E2 02 C0 80 E7 AC 20 9F E5 ?? ?? ?? ?? 34 C0 93 E5 02 20 9F E7 02 C0 80 E7 9C 20 9F E5 38 C0 93 E5 02 20 9F E7 02 C0 80 E7 90 20 9F E5 3C 30 93 E5 02 20 9F E7 02 30 80 E7 04 00 51 E1 01 00 A0 11 00 00 E0 03 30 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_140_0_0 {
	meta:
		name = "xdr_int64_t"
		size = 236
		altNames = "xdr_uint64_t"
	strings:
		$1 = { 70 40 2D E9 00 50 90 E5 01 00 55 E3 08 D0 4D E2 00 40 A0 E1 01 60 A0 E1 06 00 00 0A 10 00 00 3A 02 30 55 E2 00 00 73 E2 03 00 B0 E0 08 D0 8D E2 70 40 BD E8 ?? ?? ?? ?? 04 30 90 E5 0D 10 A0 E1 20 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 16 00 00 1A 00 00 A0 E3 08 D0 8D E2 70 40 BD E8 ?? ?? ?? ?? 0C 00 91 E8 0D 10 A0 E1 00 30 8D E5 04 20 8D E5 04 30 90 E5 24 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F1 FF FF 0A 04 30 94 E5 04 00 A0 E1 04 10 8D E2 24 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 00 90 E2 01 00 A0 13 DE FF FF EA 04 30 94 E5 04 00 A0 E1 04 10 8D E2 20 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 E0 FF FF 0A 04 10 9D E5 00 30 9D E5 00 20 A0 E3 01 20 82 E1 0C 00 86 E8 05 00 A0 E1 CF FF FF EA }
	condition:
		$1
}

rule file_140_4_0 {
	meta:
		name = "xdr_int32_t"
		size = 88
		altNames = "xdr_uint32_t"
	strings:
		$1 = { 00 20 90 E5 01 00 52 E3 08 40 2D E9 05 00 00 0A 0A 00 00 3A 02 30 52 E2 00 00 73 E2 03 00 B0 E0 08 40 BD E8 ?? ?? ?? ?? 04 30 90 E5 20 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? 04 30 90 E5 24 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_140_6_0 {
	meta:
		name = "xdr_int16_t"
		size = 140
	strings:
		$1 = { 30 40 2D E9 00 40 90 E5 01 00 54 E3 0C D0 4D E2 01 50 A0 E1 06 00 00 0A 11 00 00 3A 02 30 54 E2 00 00 73 E2 03 00 B0 E0 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? 04 30 90 E5 04 10 8D E2 20 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 30 9D 15 04 00 A0 11 B0 30 C5 11 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? F0 20 D1 E1 08 10 8D E2 04 20 21 E5 04 30 90 E5 24 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_140_7_0 {
	meta:
		name = "xdr_uint16_t"
		size = 140
	strings:
		$1 = { 30 40 2D E9 00 40 90 E5 01 00 54 E3 0C D0 4D E2 01 50 A0 E1 06 00 00 0A 11 00 00 3A 02 30 54 E2 00 00 73 E2 03 00 B0 E0 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? 04 30 90 E5 04 10 8D E2 20 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 30 9D 15 04 00 A0 11 B0 30 C5 11 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? B0 20 D1 E1 08 10 8D E2 04 20 21 E5 04 30 90 E5 24 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_140_8_0 {
	meta:
		name = "xdr_int8_t"
		size = 140
	strings:
		$1 = { 30 40 2D E9 00 40 90 E5 01 00 54 E3 0C D0 4D E2 01 50 A0 E1 06 00 00 0A 11 00 00 3A 02 30 54 E2 00 00 73 E2 03 00 B0 E0 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? 04 30 90 E5 04 10 8D E2 20 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 30 9D 15 04 00 A0 11 00 30 C5 15 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? D0 20 D1 E1 08 10 8D E2 04 20 21 E5 04 30 90 E5 24 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_140_9_0 {
	meta:
		name = "xdr_uint8_t"
		size = 140
	strings:
		$1 = { 30 40 2D E9 00 40 90 E5 01 00 54 E3 0C D0 4D E2 01 50 A0 E1 06 00 00 0A 11 00 00 3A 02 30 54 E2 00 00 73 E2 03 00 B0 E0 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? 04 30 90 E5 04 10 8D E2 20 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 30 9D 15 04 00 A0 11 00 30 C5 15 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? 00 20 D1 E5 08 10 8D E2 04 20 21 E5 04 30 90 E5 24 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_141_0_0 {
	meta:
		name = "__remap_file_pages"
		size = 32
		refs = "001c __syscall_error"
	strings:
		$1 = { 90 00 2D E9 08 40 9D E5 FD 70 A0 E3 00 00 00 EF 90 00 BD E8 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_142_0_0 {
	meta:
		name = "___vfprintf_chk"
		size = 524
		refs = "0024 __aeabi_read_tp 00a0 vfprintf 0160 __lll_lock_wait_private 0208 _Unwind_Resume"
	strings:
		$1 = { F0 47 2D E9 00 40 90 E5 02 49 14 E2 00 50 A0 E1 01 70 A0 E1 02 90 A0 E1 03 80 A0 E1 18 00 00 1A 48 60 90 E5 ?? ?? ?? ?? 08 30 96 E5 13 AD 40 E2 0A 00 53 E1 0F 00 00 0A 01 10 A0 E3 06 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 3B 00 00 1A 48 30 95 E5 08 A0 83 E5 03 60 A0 E1 04 30 96 E5 01 30 83 E2 04 30 86 E5 00 00 57 E3 3C 30 95 C5 04 30 83 C3 3C 30 85 C5 09 10 A0 E1 08 20 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 3C 30 95 E5 00 00 57 E3 00 20 95 E5 04 30 C3 C3 3C 30 85 C5 14 30 C3 E3 02 09 12 E3 00 60 A0 E1 3C 30 85 E5 17 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 11 00 00 1A 08 30 85 E5 00 70 95 E5 00 10 A0 E3 07 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 57 E1 F0 FF FF 1A 01 00 57 E3 02 00 00 CA 06 00 A0 E1 F0 47 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF F3 FF FF EA 06 00 A0 E1 ?? ?? ?? ?? C0 FF FF EA 3C 30 95 E5 00 20 95 E5 14 30 C3 E3 02 09 12 E3 00 80 A0 E1 3C 30 85 E5 1F 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 19 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 07 00 00 DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 08 00 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1268_0_0 {
	meta:
		name = "__vfwprintf_chk"
		size = 524
		refs = "0024 __aeabi_read_tp 00a0 _IO_vfwprintf 0160 __lll_lock_wait_private 0208 _Unwind_Resume"
	strings:
		$1 = { F0 47 2D E9 00 40 90 E5 02 49 14 E2 00 50 A0 E1 01 70 A0 E1 02 90 A0 E1 03 80 A0 E1 18 00 00 1A 48 60 90 E5 ?? ?? ?? ?? 08 30 96 E5 13 AD 40 E2 0A 00 53 E1 0F 00 00 0A 01 10 A0 E3 06 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 3B 00 00 1A 48 30 95 E5 08 A0 83 E5 03 60 A0 E1 04 30 96 E5 01 30 83 E2 04 30 86 E5 00 00 57 E3 3C 30 95 C5 04 30 83 C3 3C 30 85 C5 09 10 A0 E1 08 20 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 3C 30 95 E5 00 00 57 E3 00 20 95 E5 04 30 C3 C3 3C 30 85 C5 14 30 C3 E3 02 09 12 E3 00 60 A0 E1 3C 30 85 E5 17 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 11 00 00 1A 08 30 85 E5 00 70 95 E5 00 10 A0 E3 07 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 57 E1 F0 FF FF 1A 01 00 57 E3 02 00 00 CA 06 00 A0 E1 F0 47 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF F3 FF FF EA 06 00 A0 E1 ?? ?? ?? ?? C0 FF FF EA 3C 30 95 E5 00 20 95 E5 14 30 C3 E3 02 09 12 E3 00 80 A0 E1 3C 30 85 E5 1F 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 19 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 07 00 00 DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 08 00 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_143_0_0 {
	meta:
		name = "sigemptyset"
		size = 68
		refs = "0014 memset 0028 __aeabi_read_tp 0040 __libc_errno"
	strings:
		$1 = { 00 00 50 E3 08 40 2D E9 05 00 00 0A 00 10 A0 E3 80 20 A0 E3 ?? ?? ?? ?? 00 00 A0 E3 08 40 BD E8 ?? ?? ?? ?? 14 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 00 00 E0 E3 F6 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "w_addword"
		size = 184
		refs = "0028 realloc 0070 calloc 00ac free"
	strings:
		$1 = { 70 40 2D E9 00 50 51 E2 00 40 A0 E1 15 00 00 0A 00 10 90 E5 08 30 90 E5 03 10 81 E0 02 10 81 E2 01 11 A0 E1 04 00 90 E5 ?? ?? ?? ?? 00 00 50 E3 1E 00 00 0A 00 C0 94 E5 08 30 94 E5 01 20 8C E2 03 C0 8C E0 04 00 84 E5 00 20 84 E5 0C 51 80 E7 04 10 94 E5 03 30 82 E0 00 00 A0 E3 03 01 81 E7 70 40 BD E8 ?? ?? ?? ?? 01 00 A0 E3 00 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 60 A0 E1 00 50 A0 E1 0A 00 00 0A 00 10 94 E5 08 30 94 E5 03 10 81 E0 02 10 81 E2 01 11 A0 E1 04 00 94 E5 ?? ?? ?? ?? 00 00 50 E3 E2 FF FF 1A 06 00 A0 E1 ?? ?? ?? ?? 01 00 A0 E3 E9 FF FF EA }
	condition:
		$1
}

rule file_144_1_0 {
	meta:
		name = "w_addchar"
		size = 176
		refs = "006c realloc 0084 free 00a0 __assert_fail"
	strings:
		$1 = { F8 40 2D E9 00 C0 92 E5 01 50 A0 E1 00 10 91 E5 0C 00 51 E1 00 40 A0 E1 03 60 A0 E1 0A 00 00 0A 00 00 50 E3 05 00 00 0A 01 60 C4 E7 00 30 95 E5 00 20 A0 E3 01 30 83 E2 00 30 85 E5 03 20 C4 E7 04 00 A0 E1 F8 40 BD E8 ?? ?? ?? ?? 00 00 50 E3 01 00 00 0A 00 00 51 E3 0C 00 00 0A 64 30 81 E2 00 30 82 E5 65 10 81 E2 04 00 A0 E1 ?? ?? ?? ?? 00 70 50 E2 07 40 A0 11 00 10 95 15 E9 FF FF 1A 04 00 A0 E1 ?? ?? ?? ?? 07 40 A0 E1 EB FF FF EA 0C 00 9F E5 0C 10 9F E5 66 20 A0 E3 08 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_144_2_0 {
	meta:
		name = "parse_backslash"
		size = 96
	strings:
		$1 = { 38 40 2D E9 10 40 9D E5 00 C0 94 E5 01 C0 8C E2 0C 30 D3 E7 00 00 53 E3 00 50 A0 E1 05 00 A0 03 0C 00 00 0A 0A 00 53 E3 00 C0 84 05 00 00 A0 03 08 00 00 0A 00 00 95 E5 C4 FF FF EB 00 00 50 E3 00 30 94 15 01 30 83 12 00 00 85 E5 00 30 84 15 00 00 A0 13 01 00 A0 03 38 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_144_3_0 {
	meta:
		name = "parse_qtd_backslash"
		size = 232
	strings:
		$1 = { F8 43 2D E9 20 40 9D E5 00 60 94 E5 03 50 A0 E1 01 30 86 E2 03 C0 D5 E7 22 00 5C E3 00 70 A0 E1 01 90 A0 E1 02 80 A0 E1 23 00 00 0A 08 00 00 8A 00 00 5C E3 05 00 A0 03 03 00 00 0A 0A 00 5C E3 09 00 00 1A 00 30 84 E5 00 00 A0 E3 F8 43 BD E8 ?? ?? ?? ?? 5C 00 5C E3 17 00 00 0A 60 00 5C E3 15 00 00 0A 24 00 5C E3 13 00 00 0A 06 30 D5 E7 00 00 97 E5 09 10 A0 E1 08 20 A0 E1 9B FF FF EB 00 00 50 E3 00 00 87 E5 08 00 00 0A 00 30 94 E5 03 50 85 E0 09 10 A0 E1 08 20 A0 E1 01 30 D5 E5 92 FF FF EB 00 00 50 E3 00 00 87 E5 0A 00 00 1A 01 00 A0 E3 F8 43 BD E8 ?? ?? ?? ?? 09 10 A0 E1 08 20 A0 E1 0C 30 A0 E1 00 00 97 E5 87 FF FF EB 00 00 50 E3 00 00 87 E5 F4 FF FF 0A 00 30 94 E5 01 30 83 E2 D6 FF FF EA }
	condition:
		$1
}

rule file_144_4_0 {
	meta:
		name = "w_addmem"
		size = 216
		refs = "0054 realloc 0074 mempcpy 00ac free 00c8 __assert_fail"
	strings:
		$1 = { F0 41 2D E9 18 50 9D E5 00 70 91 E5 00 C0 92 E5 01 60 A0 E1 05 10 87 E0 0C 00 51 E1 00 40 A0 E1 03 80 A0 E1 1B 00 00 9A 00 00 50 E3 01 00 00 0A 00 00 5C E3 1F 00 00 0A 85 30 A0 E1 64 00 53 E3 03 10 8C 20 64 10 8C 32 00 10 82 E5 04 00 A0 E1 01 10 81 E2 ?? ?? ?? ?? 00 70 50 E2 11 00 00 0A 00 00 96 E5 07 40 A0 E1 05 20 A0 E1 00 00 84 E0 08 10 A0 E1 ?? ?? ?? ?? 00 30 A0 E3 00 30 C0 E5 00 30 96 E5 05 50 83 E0 00 50 86 E5 04 00 A0 E1 F0 41 BD E8 ?? ?? ?? ?? 00 00 50 E3 FA FF FF 0A 07 00 A0 E1 EF FF FF EA 04 00 A0 E1 ?? ?? ?? ?? 07 40 A0 E1 F4 FF FF EA 0C 00 9F E5 0C 10 9F E5 81 20 A0 E3 08 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_144_5_0 {
	meta:
		name = "exec_comm"
		size = 1776
		refs = "0054 __pipe2 00a0 __pipe 00bc __fork 00dc __close 0104 __read 012c strchr 0290 __kill 02a0 __aeabi_read_tp 02c0 __waitpid 0520 __dup2 0544 __open 0570 __fxstat64 05ac _exit 0634 free 0654 __unsetenv 0670 __execve 0674 abort 06a4 __fcntl 06ac __have_pipe2 06b0 __libc_errno 06ec __environ"
	strings:
		$1 = { F0 4F 2D E9 00 00 50 E3 4B DF 4D E2 1C 00 8D E5 00 00 A0 E3 01 60 A0 E1 02 B0 A0 E1 10 30 8D E5 24 00 8D E5 AE 00 00 0A 1C 10 9D E5 00 30 D1 E5 00 00 53 E3 AA 00 00 0A 6C 26 9F E5 00 30 92 E5 00 00 53 E3 28 40 8D E2 13 00 00 BA 02 17 A0 E3 04 00 A0 E1 ?? ?? ?? ?? 4C 16 9F E5 00 30 91 E5 00 00 53 E3 00 20 A0 E1 04 00 00 1A 01 00 70 E3 01 30 A0 13 0D 01 00 0A 2C 16 9F E5 00 30 81 E5 00 00 53 E3 03 00 00 DA 00 00 52 E3 06 00 00 AA 01 00 A0 E3 8F 00 00 EA 03 00 00 AA 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F8 FF FF BA 00 50 A0 E3 14 B0 8D E5 58 A1 9D E5 05 90 A0 E1 ?? ?? ?? ?? 00 00 50 E3 18 00 8D E5 00 01 00 BA 04 01 00 0A 00 00 55 E3 35 01 00 1A 2C 00 9D E5 ?? ?? ?? ?? 54 31 9D E5 00 00 53 E3 00 30 E0 E3 A8 70 8D E2 2C 30 8D E5 4F 00 00 0A 28 00 9D E5 07 10 A0 E1 80 20 A0 E3 ?? ?? ?? ?? 01 00 70 E3 00 80 A0 E1 77 00 00 0A 00 00 50 E3 7B 00 00 DA 00 40 A0 E3 16 00 00 EA 5C 01 9D E5 0B 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 27 00 00 1A 02 00 55 E3 00 50 A0 E1 0B 00 00 0A 54 01 9D E5 00 10 96 E5 C9 FE FF EB 01 00 50 E3 4B 00 00 0A 10 30 9D E5 14 20 9D E5 00 10 A0 E3 00 10 83 E5 00 10 82 E5 00 10 86 E5 01 90 A0 E1 01 40 84 E2 04 00 58 E1 DD FF FF DA 04 B0 D7 E7 0A 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 20 50 E2 E2 FF FF 1A 03 00 55 E3 17 00 00 0A 00 20 96 E5 0A 00 5B E3 02 00 A0 E1 0B 30 A0 E1 14 10 9D E5 10 20 9D E5 01 90 89 02 00 90 A0 13 DA FE FF EB 00 00 50 E3 00 00 86 E5 2D 00 00 0A 01 50 A0 E3 E6 FF FF EA 0A 00 5B E3 04 00 00 0A 02 30 C5 E3 01 00 53 E3 E1 FF FF 1A 02 50 A0 E3 D3 FF FF EA 01 00 55 E3 03 50 A0 03 DC FF FF EA 00 10 96 E5 54 01 9D E5 0C 20 8D E5 99 FE FF EB 01 00 50 E3 0C 20 9D E5 1A 00 00 0A 10 30 9D E5 14 10 9D E5 00 20 83 E5 04 B0 D7 E7 00 20 81 E5 00 20 86 E5 DA FF FF EA 18 80 9D E5 28 00 9D E5 07 10 A0 E1 80 20 A0 E3 ?? ?? ?? ?? 01 00 70 E3 00 40 A0 E1 6D 00 00 0A 00 00 50 E3 71 00 00 DA 00 00 96 E5 14 10 9D E5 00 40 8D E5 10 20 9D E5 07 30 A0 E1 2B FF FF EB 00 00 50 E3 04 90 89 E0 00 00 86 E5 EC FF FF 1A 18 00 9D E5 09 10 A0 E3 ?? ?? ?? ?? 14 44 9F E5 18 50 9D E5 04 00 00 EA ?? ?? ?? ?? 04 30 9F E7 03 30 90 E7 04 00 53 E3 05 00 00 1A 00 10 A0 E3 01 20 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 01 00 70 E3 F4 FF FF 0A 28 00 9D E5 ?? ?? ?? ?? 01 00 A0 E3 4B DF 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 00 A0 E3 4B DF 8D E2 F0 4F BD E8 ?? ?? ?? ?? B8 23 9F E5 ?? ?? ?? ?? 02 30 9F E7 03 30 90 E7 04 00 53 E3 7A FF FF 0A 00 80 98 E2 01 80 A0 13 24 40 8D E2 18 B0 9D E5 05 00 00 EA 90 13 9F E5 ?? ?? ?? ?? 01 30 9F E7 03 30 90 E7 04 00 53 E3 0E 00 00 1A 0B 00 A0 E1 04 10 A0 E1 08 20 A0 E1 ?? ?? ?? ?? 01 00 70 E3 F3 FF FF 0A 00 00 50 E3 67 FF FF 0A 05 00 00 EA 58 23 9F E5 ?? ?? ?? ?? 02 30 9F E7 03 30 90 E7 04 00 53 E3 08 00 00 1A 28 00 9D E5 07 10 A0 E1 80 20 A0 E3 ?? ?? ?? ?? 01 00 70 E3 F3 FF FF 0A 00 00 50 E3 00 80 A0 E1 60 FF FF CA 01 90 49 E2 00 00 A0 E3 14 20 9D E5 0E 00 00 EA 00 30 92 E5 00 00 53 E3 0D 00 00 0A 00 10 96 E5 01 30 43 E2 03 C0 D1 E7 0A 00 5C E3 08 00 00 1A 00 30 82 E5 03 00 C1 E7 00 40 92 E5 00 00 54 E3 01 30 49 E2 93 00 00 0A 03 90 A0 E1 01 00 79 E3 EE FF FF 1A 28 00 9D E5 ?? ?? ?? ?? 24 30 9D E5 00 00 53 E3 00 30 E0 E3 28 30 8D E5 B6 FF FF 0A 01 50 A0 E3 2A FF FF EA A8 12 9F E5 ?? ?? ?? ?? 01 30 9F E7 03 30 90 E7 04 00 53 E3 84 FF FF 0A 00 40 94 E2 01 40 A0 13 05 00 00 EA 88 22 9F E5 ?? ?? ?? ?? 02 30 9F E7 03 30 90 E7 04 00 53 E3 0E 00 00 1A 08 00 A0 E1 24 10 8D E2 04 20 A0 E1 ?? ?? ?? ?? 01 00 70 E3 F3 FF FF 0A 00 00 50 E3 73 FF FF 0A 05 00 00 EA 50 12 9F E5 ?? ?? ?? ?? 01 30 9F E7 03 30 90 E7 04 00 53 E3 C3 FF FF 1A 28 00 9D E5 07 10 A0 E1 80 20 A0 E3 ?? ?? ?? ?? 01 00 70 E3 F3 FF FF 0A 00 00 50 E3 00 40 A0 E1 6C FF FF CA B9 FF FF EA 14 32 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 26 00 53 E3 00 30 E0 03 01 30 A0 13 E9 FE FF EA 28 00 9D E5 ?? ?? ?? ?? 2C 00 9D E5 ?? ?? ?? ?? EA FE FF EA 00 00 55 E3 E0 21 9F E5 46 00 00 1A DC 31 9F E5 1C 10 9D E5 30 20 8D E5 50 21 9D E5 38 10 8D E5 3C 50 8D E5 34 30 8D E5 10 A0 02 E2 2C 00 9D E5 01 00 50 E3 5B 00 00 0A 01 10 A0 E3 ?? ?? ?? ?? 2C 00 9D E5 ?? ?? ?? ?? 00 00 5A E3 46 00 00 1A 02 00 A0 E3 ?? ?? ?? ?? 94 01 9F E5 01 10 A0 E3 ?? ?? ?? ?? 02 30 50 E2 01 30 A0 13 00 00 50 E3 00 30 A0 B3 00 00 53 E3 00 40 A0 E1 44 00 00 1A 03 00 A0 E3 02 10 A0 E3 40 20 8D E2 ?? ?? ?? ?? 00 00 50 E3 0A 00 00 1A 50 30 9D E5 0F 3A 03 E2 02 0A 53 E3 06 00 00 1A 60 30 8D E2 0C 00 93 E8 40 01 9F E5 00 10 A0 E3 01 00 53 E1 00 00 52 01 29 00 00 0A 5A 00 A0 E3 ?? ?? ?? ?? 28 51 9F E5 24 40 8D E2 18 60 9D E5 04 00 00 EA ?? ?? ?? ?? 05 30 9F E7 03 30 90 E7 04 00 53 E3 43 FF FF 1A 06 00 A0 E1 04 10 A0 E1 00 20 A0 E3 ?? ?? ?? ?? 01 00 70 E3 F4 FF FF 0A 18 20 9D E5 00 00 52 E1 3A FF FF 1A 24 00 9D E5 00 00 50 E3 05 00 A0 13 00 00 A0 03 32 FF FF EA 1C 10 9D E5 CC 30 9F E5 38 10 8D E5 18 10 9D E5 30 20 8D E5 3C 10 8D E5 01 A0 A0 E1 34 30 8D E5 B7 FF FF EA 00 00 96 E5 ?? ?? ?? ?? 10 20 9D E5 14 30 9D E5 00 40 82 E5 00 40 83 E5 00 40 86 E5 66 FF FF EA 90 00 9F E5 ?? ?? ?? ?? 28 00 9D E5 ?? ?? ?? ?? 84 30 9F E5 30 10 8D E2 00 20 93 E5 5C 00 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 02 10 A0 E3 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? B5 FF FF EA 18 10 9F E5 00 30 91 E5 00 00 53 E3 A3 FF FF DA 02 10 A0 E3 00 20 A0 E3 ?? ?? ?? ?? 9F FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_144_6_0 {
	meta:
		name = "parse_backtick"
		size = 368
		refs = "008c free"
	strings:
		$1 = { F0 47 2D E9 20 D0 4D E2 40 40 9D E5 00 E0 94 E5 03 50 A0 E1 0E 30 D3 E7 00 60 A0 E3 06 00 53 E1 00 90 A0 E1 01 80 A0 E1 02 70 A0 E1 18 60 8D E5 14 60 8D E5 1C 60 8D E5 46 00 00 0A 5C 00 53 E3 28 00 00 0A 60 00 53 E3 12 00 00 0A 27 00 53 E3 01 60 66 02 1C 00 9D E5 14 10 8D E2 18 20 8D E2 76 FD FF EB 00 00 50 E3 1C 00 8D E5 37 00 00 0A 00 E0 94 E5 01 E0 8E E2 00 E0 84 E5 0E 30 D5 E7 00 00 53 E3 EC FF FF 1A 1C 00 9D E5 ?? ?? ?? ?? 05 00 A0 E3 10 00 00 EA 44 20 9D E5 48 30 9D E5 00 20 8D E5 04 30 8D E5 4C 20 9D E5 50 30 9D E5 08 20 8D E5 0C 30 8D E5 09 10 A0 E1 08 20 A0 E1 07 30 A0 E1 1C 00 9D E5 10 FE FF EB 00 40 A0 E1 1C 00 9D E5 ?? ?? ?? ?? 04 00 A0 E1 20 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 00 00 56 E3 09 00 00 0A 00 40 8D E5 1C 00 8D E2 14 10 8D E2 18 20 8D E2 05 30 A0 E1 91 FD FF EB 00 60 50 E2 13 00 00 1A 01 60 A0 E3 D5 FF FF EA 01 E0 8E E2 00 E0 84 E5 1C 00 8D E2 00 40 8D E5 14 10 8D E2 18 20 8D E2 05 30 A0 E1 6D FD FF EB 00 A0 50 E2 CB FF FF 0A 1C 00 9D E5 ?? ?? ?? ?? 0A 00 A0 E1 E2 FF FF EA 01 00 A0 E3 E0 FF FF EA 03 00 A0 E1 CA FF FF EA 1C 00 9D E5 ?? ?? ?? ?? 06 00 A0 E1 DA FF FF EA }
	condition:
		$1
}

rule file_144_7_0 {
	meta:
		name = "eval_expr_multdiv"
		size = 288
		refs = "004c __aeabi_read_tp 00dc __aeabi_idiv 0118 __libc_tsd_CTYPE_B"
	strings:
		$1 = { F0 4F 2D E9 0C D0 4D E2 00 A0 A0 E1 01 70 A0 E1 8A 00 00 EB 00 90 50 E2 04 00 00 0A 05 90 A0 E3 09 00 A0 E1 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? E0 80 9F E5 E0 B0 9F E5 00 30 9A E5 00 20 D3 E5 00 00 52 E3 F5 FF FF 0A 08 10 9F E7 ?? ?? ?? ?? 01 00 90 E7 82 10 A0 E1 B1 10 90 E1 02 0A 11 E3 10 00 00 0A 01 40 83 E2 09 00 00 EA 01 20 D4 E4 00 00 52 E3 82 50 A0 E1 E8 FF FF 0A ?? ?? ?? ?? 0B 60 9F E7 06 10 90 E7 B5 10 91 E1 02 0A 11 E3 04 00 00 0A 00 00 54 E3 04 30 A0 E1 00 40 8A E5 F1 FF FF 1A 00 20 D4 E5 2A 00 52 E3 0D 00 00 0A 2F 00 52 E3 D9 FF FF 1A 01 30 83 E2 00 30 8A E5 0A 00 A0 E1 04 10 8D E2 5C 00 00 EB 00 00 50 E3 D1 FF FF 1A 00 00 97 E5 04 10 9D E5 ?? ?? ?? ?? 00 00 87 E5 D3 FF FF EA 01 30 83 E2 00 30 8A E5 0A 00 A0 E1 04 10 8D E2 50 00 00 EB 00 00 50 E3 C5 FF FF 1A 00 30 97 E5 04 20 9D E5 92 03 03 E0 00 30 87 E5 C7 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_144_8_0 {
	meta:
		name = "eval_expr_val"
		size = 304
		refs = "0028 __aeabi_read_tp 00d4 strtol 012c __libc_tsd_CTYPE_B"
	strings:
		$1 = { F8 40 2D E9 00 70 90 E5 00 00 57 E3 00 50 A0 E1 01 60 A0 E1 16 00 00 0A 00 20 D7 E5 00 00 52 E3 27 00 00 0A 00 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 10 90 E7 82 30 A0 E1 B3 30 91 E1 02 0A 13 E3 37 00 00 0A 01 30 87 E2 06 00 00 EA 01 20 D3 E4 00 00 52 E3 82 C0 A0 E1 1A 00 00 0A BC C0 91 E1 02 0A 1C E3 04 00 00 0A 00 00 53 E3 03 40 A0 E1 F5 FF FF 1A 00 40 A0 E3 00 20 D4 E5 28 00 52 E3 10 00 00 1A 00 20 D7 E5 29 00 52 E3 00 00 52 13 21 00 00 0A 01 30 87 E2 00 30 85 E5 03 C0 A0 E1 01 20 D3 E4 29 00 52 E3 00 00 52 13 F9 FF FF 1A 00 00 52 E3 0E 00 00 1A 05 00 A0 E3 F8 40 BD E8 ?? ?? ?? ?? 07 40 A0 E1 04 00 A0 E1 05 10 A0 E1 00 20 A0 E3 ?? ?? ?? ?? 00 30 95 E5 04 00 53 E1 00 00 86 E5 F3 FF FF 0A 00 00 A0 E3 F8 40 BD E8 ?? ?? ?? ?? 01 20 8C E2 00 30 A0 E3 00 20 85 E5 01 00 84 E2 06 10 A0 E1 00 30 CC E5 73 FF FF EB 00 00 50 E3 E7 FF FF 1A F2 FF FF EA 07 C0 A0 E1 E2 FF FF EA 07 40 A0 E1 D3 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_144_9_0 {
	meta:
		name = "eval_expr"
		size = 288
		refs = "0090 __aeabi_read_tp 011c __libc_tsd_CTYPE_B"
	strings:
		$1 = { F0 41 2D E9 10 D0 4D E2 10 50 8D E2 0C 00 25 E5 05 00 A0 E1 01 80 A0 E1 B0 FF FF EB 00 70 50 E2 F4 60 9F 05 14 00 00 0A 05 70 A0 E3 07 00 A0 E1 10 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 00 20 D3 E5 2B 00 52 E3 28 00 00 0A 2D 00 52 E3 F6 FF FF 1A 01 30 83 E2 05 00 A0 E1 0C 10 8D E2 04 30 8D E5 9E FF FF EB 00 00 50 E3 EE FF FF 1A 00 20 98 E5 0C 30 9D E5 02 30 63 E0 00 30 88 E5 04 30 9D E5 00 20 D3 E5 00 00 52 E3 E7 FF FF 0A 06 10 9F E7 ?? ?? ?? ?? 01 40 90 E7 82 10 A0 E1 B1 10 94 E1 02 0A 11 E3 E5 FF FF 0A 01 30 83 E2 06 00 00 EA 01 20 D3 E4 00 00 52 E3 82 C0 A0 E1 DA FF FF 0A BC C0 94 E1 02 0A 1C E3 04 00 00 0A 00 00 53 E3 04 30 8D E5 03 00 A0 E1 F4 FF FF 1A D6 FF FF EA 2B 00 52 E3 00 30 A0 E1 D6 FF FF 1A 01 30 83 E2 05 00 A0 E1 0C 10 8D E2 04 30 8D E5 77 FF FF EB 00 00 50 E3 C7 FF FF 1A 00 20 98 E5 0C 30 9D E5 03 30 82 E0 00 30 88 E5 D7 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_144_10_0 {
	meta:
		name = "w_addstr"
		size = 104
		refs = "0020 strlen 0058 __assert_fail"
	strings:
		$1 = { F0 40 2D E9 00 40 53 E2 0C D0 4D E2 00 50 A0 E1 01 70 A0 E1 02 60 A0 E1 0A 00 00 0A 04 00 A0 E1 ?? ?? ?? ?? 07 10 A0 E1 00 00 8D E5 06 20 A0 E1 05 00 A0 E1 04 30 A0 E1 C6 FC FF EB 0C D0 8D E2 F0 40 BD E8 ?? ?? ?? ?? 0C 00 9F E5 0C 10 9F E5 9B 20 A0 E3 08 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_144_11_0 {
	meta:
		name = "parse_tilde"
		size = 944
		refs = "004c strchr 00e4 __strnlen 0110 memcpy 0134 __aeabi_read_tp 0178 __getpwnam_r 0268 getenv 02d8 __getuid 0340 __getpwuid_r 03a4 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 3C D0 4D E2 4C 10 0B E5 00 10 91 E5 00 00 51 E3 48 00 0B E5 50 20 0B E5 03 40 A0 E1 0E 00 00 0A 00 50 90 E5 01 10 85 E0 01 30 51 E5 3D 00 53 E3 06 00 00 0A 3A 00 53 E3 68 00 00 1A 05 00 A0 E1 3D 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 63 00 00 0A 08 20 9B E5 00 00 52 E3 60 00 00 1A 04 C0 9B E5 00 10 9C E5 01 00 81 E2 00 30 D4 E7 DF 00 13 E3 00 50 84 E0 78 00 00 0A 2F 00 53 E3 3A 00 53 13 75 00 00 0A 09 00 53 E3 73 00 00 0A 5C 00 53 E3 00 60 A0 11 08 00 00 1A 7F 00 00 EA 3A 00 53 E3 2F 00 53 13 08 00 00 0A 09 00 53 E3 06 00 00 0A 5C 00 53 E3 78 00 00 0A 0C 60 A0 E1 01 C0 86 E2 0C 30 D4 E7 DF 00 13 E3 F3 FF FF 1A 0C 00 50 E1 61 00 00 0A 06 10 61 E0 05 00 A0 E1 ?? ?? ?? ?? 0F 30 80 E2 07 30 C3 E3 03 D0 4D E0 00 20 A0 E1 0F 00 8D E2 A0 01 A0 E1 00 30 A0 E3 05 10 A0 E1 80 31 C2 E7 80 01 A0 E1 ?? ?? ?? ?? 3F DE 4D E2 00 90 A0 E1 08 50 8D E2 FA 4F A0 E3 40 80 4B E2 44 70 4B E2 70 A2 9F E5 0B 00 00 EA ?? ?? ?? ?? 0A 10 9F E7 01 10 90 E7 22 00 51 E3 33 00 00 1A 02 D0 4D E0 08 20 8D E2 03 10 82 E0 01 00 55 E1 04 40 83 00 03 40 A0 11 02 50 A0 E1 05 20 A0 E1 04 30 A0 E1 00 70 8D E5 09 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? FD 3F 84 E2 03 30 83 E2 0F 30 C3 E3 00 00 50 E3 08 20 83 E2 E7 FF FF 1A 44 30 1B E5 00 00 53 E3 1D 00 00 0A 2C 30 1B E5 00 00 53 E3 1A 00 00 0A 48 C0 1B E5 50 20 1B E5 4C 10 1B E5 00 00 9C E5 75 FF FF EB 48 20 1B E5 00 00 82 E5 00 30 A0 E1 04 C0 9B E5 00 60 8C E5 01 00 73 E2 00 00 A0 33 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 7E 30 A0 E3 05 00 A0 E1 4C 10 1B E5 50 20 1B E5 BE FB FF EB 48 30 1B E5 00 00 83 E5 01 00 70 E2 00 00 A0 33 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 48 30 1B E5 4C 10 1B E5 00 00 93 E5 50 20 1B E5 7E 30 A0 E3 B1 FB FF EB 48 C0 1B E5 00 00 50 E3 00 30 A0 E1 00 00 8C E5 E1 FF FF 0A 50 20 1B E5 09 30 A0 E1 4C 10 1B E5 50 FF FF EB 48 20 1B E5 00 30 A0 E1 00 00 82 E5 D9 FF FF EA 3C 01 9F E5 ?? ?? ?? ?? 00 30 50 E2 18 00 00 0A 48 C0 1B E5 50 20 1B E5 4C 10 1B E5 00 00 9C E5 43 FF FF EB 48 20 1B E5 00 00 50 E3 00 30 A0 E1 00 00 82 E5 CD FF FF 1A 01 00 A0 E3 D9 FF FF EA 48 30 1B E5 4C 10 1B E5 50 20 1B E5 00 00 93 E5 7E 30 A0 E3 8E FB FF EB 48 C0 1B E5 00 00 8C E5 01 00 70 E2 00 00 A0 33 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 3F DE 4D E2 00 60 A0 E1 08 50 8D E2 FA 4F A0 E3 40 80 4B E2 44 70 4B E2 B0 90 9F E5 0B 00 00 EA ?? ?? ?? ?? 09 30 9F E7 03 30 90 E7 22 00 53 E3 18 00 00 1A 02 D0 4D E0 08 30 8D E2 0A 20 83 E0 02 00 55 E1 04 40 8A 00 0A 40 A0 11 03 50 A0 E1 05 20 A0 E1 00 70 8D E5 06 00 A0 E1 08 10 A0 E1 04 30 A0 E1 ?? ?? ?? ?? FD AF 84 E2 03 A0 8A E2 0F A0 CA E3 00 00 50 E3 08 20 8A E2 E7 FF FF 1A 44 30 1B E5 00 00 53 E3 02 00 00 0A 2C 30 1B E5 00 00 53 E3 BF FF FF 1A 48 30 1B E5 4C 10 1B E5 00 00 93 E5 50 20 1B E5 7E 30 A0 E3 5A FB FF EB 48 C0 1B E5 00 00 50 E3 00 30 A0 E1 00 00 8C E5 8C FF FF 1A BD FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_144_12_0 {
	meta:
		name = "parse_arith"
		size = 832
		refs = "00ac free 0124 _itoa_word 02d4 _itoa"
	strings:
		$1 = { F0 4F 2D E9 4C D0 4D E2 70 40 9D E5 00 E0 94 E5 03 B0 A0 E1 0E 30 D3 E7 00 90 A0 E3 09 00 53 E1 00 60 A0 E1 01 80 A0 E1 02 70 A0 E1 24 90 8D E5 20 90 8D E5 28 90 8D E5 A9 00 00 0A 01 50 A0 E3 05 A0 A0 E1 3B 00 53 E3 75 00 00 0A 19 00 00 8A 24 00 53 E3 60 00 00 0A 7D 00 00 9A 28 00 53 E3 5B 00 00 0A 29 00 53 E3 01 00 00 1A 01 50 55 E2 80 00 00 0A 28 00 9D E5 20 10 8D E2 24 20 8D E2 30 FB FF EB 00 00 50 E3 28 00 8D E5 92 00 00 0A 00 E0 94 E5 01 E0 8E E2 00 E0 84 E5 0E 30 DB E7 00 00 53 E3 E6 FF FF 1A 28 00 9D E5 ?? ?? ?? ?? 05 00 A0 E3 5D 00 00 EA 60 00 53 E3 27 00 00 0A 53 00 00 8A 5C 00 53 E3 38 00 00 0A 5D 00 53 E3 E7 FF FF 1A 01 20 55 E2 78 30 9D E5 00 50 72 E2 02 50 B5 E0 00 00 53 E3 00 50 A0 03 00 00 55 E3 51 00 00 0A 00 30 A0 E3 2C 30 8D E5 28 00 9D E5 00 30 D0 E5 00 00 53 E3 54 00 00 1A 03 00 A0 E1 00 30 A0 E3 48 10 8D E2 04 30 61 E5 0A 20 A0 E3 00 40 96 E5 ?? ?? ?? ?? 00 30 A0 E1 08 10 A0 E1 07 20 A0 E1 04 00 A0 E1 AA FE FF EB 00 00 86 E5 28 00 9D E5 ?? ?? ?? ?? 00 00 96 E5 01 00 70 E2 00 00 A0 33 4C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 74 30 9D E5 01 E0 8E E2 00 E0 84 E5 28 00 8D E2 08 02 8D E9 00 40 8D E5 0B 30 A0 E1 0C 90 8D E5 10 90 8D E5 20 10 8D E2 24 20 8D E2 5D FD FF EB 00 30 50 E2 BD FF FF 0A 28 00 9D E5 1C 30 8D E5 ?? ?? ?? ?? 1C 30 9D E5 03 00 A0 E1 1F 00 00 EA 0B 30 A0 E1 00 40 8D E5 28 00 8D E2 20 10 8D E2 24 20 8D E2 23 FB FF EB 00 30 50 E2 AF FF FF 0A F0 FF FF EA 01 50 85 E2 A5 FF FF EA 74 20 9D E5 0B 30 A0 E1 04 02 8D E9 00 40 8D E5 0C 90 8D E5 10 90 8D E5 14 A0 8D E5 28 00 8D E2 20 10 8D E2 24 20 8D E2 4D 00 00 EB 00 30 50 E2 9F FF FF 0A E0 FF FF EA 7B 00 53 E3 01 00 00 0A 7D 00 53 E3 93 FF FF 1A 28 00 9D E5 ?? ?? ?? ?? 02 00 A0 E3 4C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 28 00 9D E5 ?? ?? ?? ?? 05 00 A0 E3 4C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 0A 00 53 E3 F1 FF FF 0A 84 FF FF EA 2C 10 8D E2 CB FD FF EB 00 00 50 E3 F2 FF FF 1A 2C 00 9D E5 A5 FF FF EA 78 20 9D E5 00 00 52 E3 2C 50 8D E5 EC FF FF 1A 01 E0 8E E2 0E 30 DB E7 29 00 53 E3 E8 FF FF 1A 00 E0 84 E5 28 00 9D E5 00 30 D0 E5 00 00 53 E3 00 40 A0 03 0E 00 00 1A C4 5F A0 E1 00 30 A0 E3 48 20 8D E2 04 30 62 E5 00 30 8D E5 04 00 A0 E1 05 10 A0 E1 0A 30 A0 E3 00 40 96 E5 ?? ?? ?? ?? 92 FF FF EA 01 00 A0 E3 D2 FF FF EA 03 00 A0 E1 6F FF FF EA 2C 10 8D E2 A8 FD FF EB 00 00 50 E3 CF FF FF 1A 2C 40 9D E5 00 00 54 E3 E9 FF FF AA 00 00 96 E5 08 10 A0 E1 07 20 A0 E1 2D 30 A0 E3 8A FA FF EB 00 40 64 E2 00 00 50 E3 C4 5F A0 E1 00 00 86 E5 E0 FF FF 1A 28 00 9D E5 ?? ?? ?? ?? 01 00 A0 E3 BB FF FF EA }
	condition:
		$1
}

rule file_144_13_0 {
	meta:
		name = "parse_dollars"
		size = 5820
		refs = "016c __aeabi_read_tp 01f8 free 0430 __assert_fail 0458 strchr 065c strtol 068c getenv 09c8 strlen 09d8 _itoa_word 0a8c fnmatch 0aa0 malloc 0ab4 mempcpy 0b20 __fxprintf 0f18 stpcpy 0fa8 __strdup 0fdc strspn 1000 strcspn 10f8 __getpid 1124 __libc_tsd_CTYPE_B 114c pthread_setcancelstate 1150 __libc_argc 1154 __libc_argv 1158 _libc_intl_domainname 1420 __setenv 1490 __dcgettext"
	strings:
		$1 = { F0 4F 2D E9 8C D0 4D E2 B0 40 9D E5 00 70 94 E5 01 A0 87 E2 0A C0 D3 E7 27 00 5C E3 03 50 A0 E1 1C 00 8D E5 20 10 8D E5 24 20 8D E5 7A 00 00 0A 31 00 00 9A 28 00 5C E3 0E 00 00 0A 5B 00 5C E3 31 00 00 1A B4 E0 9D E5 01 C0 A0 E3 02 70 87 E2 00 70 84 E5 00 40 8D E5 04 E0 8D E5 08 C0 8D E5 16 FF FF EB 00 60 A0 E1 06 00 A0 E1 8C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 02 C0 87 E2 0C 30 D3 E7 28 00 53 E3 95 00 00 0A B4 10 9D E5 04 60 11 E2 04 60 A0 13 F3 FF FF 1A 00 C0 84 E5 C4 20 9D E5 0C 30 D5 E7 00 00 52 E3 B8 90 9D E5 00 90 A0 13 00 00 53 E3 58 60 8D E5 54 60 8D E5 4F 04 00 0A 01 80 A0 E3 06 70 A0 E1 06 00 A0 E1 22 20 43 E2 07 00 52 E3 02 F1 9F 97 60 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 5C E3 45 00 00 0A 22 00 5C E3 43 00 00 0A 00 A0 84 E5 0A 30 D5 E7 7B C0 53 E2 00 60 7C E2 0C 60 B6 E0 28 60 8D E5 00 00 56 E3 00 60 A0 E3 40 60 8D E5 3C 60 8D E5 48 60 8D E5 44 60 8D E5 BC 00 00 0A 02 80 87 E2 00 80 84 E5 08 30 D5 E7 23 00 53 E3 03 30 87 02 00 30 84 05 01 60 A0 03 03 80 A0 01 2C 60 8D E5 03 30 D5 07 B4 2F 9F E5 ?? ?? ?? ?? 02 20 9F E7 02 10 90 E7 83 20 A0 E1 B2 60 91 E1 01 6B 16 E2 6E 00 00 1A 5F 00 53 E3 6C 00 00 0A 30 20 43 E2 09 00 52 E3 AB 00 00 8A 3C 90 8D E2 40 80 8D E2 28 B0 9D E5 06 00 A0 E1 08 00 00 EA 00 00 5B E3 13 03 00 0A 00 C0 94 E5 01 C0 8C E2 00 C0 84 E5 0C 30 D5 E7 30 20 43 E2 09 00 52 E3 14 03 00 8A 09 10 A0 E1 08 20 A0 E1 09 FA FF EB 00 00 50 E3 F1 FF FF 1A 00 B0 A0 E3 0B 60 A0 E1 01 50 A0 E3 06 00 A0 E1 ?? ?? ?? ?? 0B 00 A0 E1 ?? ?? ?? ?? 05 60 A0 E1 06 00 A0 E1 8C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 70 84 E5 1C 60 9D E5 20 10 8D E2 06 00 91 E8 00 00 96 E5 24 30 A0 E3 F4 F9 FF EB 00 00 86 E5 01 60 70 E2 00 60 A0 33 06 00 A0 E1 8C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 00 57 E3 01 00 00 1A 01 80 58 E2 C5 03 00 0A 54 10 8D E2 58 20 8D E2 E6 F9 FF EB 00 00 50 E3 88 00 00 0A 00 30 94 E5 01 30 83 E2 00 30 84 E5 03 30 D5 E7 00 00 53 E3 8F FF FF 1A 00 A0 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 05 60 A0 E3 71 FF FF EA 00 00 57 E3 02 70 A0 03 EC FF FF 0A 02 70 57 E2 01 70 A0 13 E9 FF FF EA 00 00 57 E3 01 80 88 02 E6 FF FF EA 00 00 57 E3 01 70 A0 03 E3 FF FF 0A 01 00 57 E3 02 70 A0 13 00 70 A0 03 DF FF FF EA 03 70 87 E2 07 30 D5 E7 00 00 53 E3 07 20 A0 E1 64 FF FF 0A 07 00 A0 E1 00 10 A0 E3 00 00 51 E3 05 00 00 1A 29 00 53 E3 C1 00 00 0A 28 00 53 E3 05 00 00 1A 01 10 81 E2 03 00 00 EA 28 00 53 E3 FB FF FF 0A 29 00 53 E3 01 10 41 02 01 20 82 E2 02 30 D5 E7 00 00 53 E3 02 00 A0 E1 EE FF FF 1A 50 FF FF EA DC BD 9F E5 00 60 A0 E3 3C 90 8D E2 40 80 8D E2 06 00 A0 E1 09 10 A0 E1 08 20 A0 E1 A8 F9 FF EB 00 60 50 E2 9E FF FF 0A 00 20 94 E5 0B 30 9F E7 01 20 82 E2 ?? ?? ?? ?? 03 00 90 E7 00 20 84 E5 02 30 D5 E7 83 10 A0 E1 B1 10 90 E1 08 10 11 E2 EE FF FF 1A 5F 00 53 E3 EC FF FF 0A 34 10 8D E5 02 80 A0 E1 28 C0 9D E5 00 00 5C E3 40 00 00 1A 28 C0 9D E5 30 C0 8D E5 0C B0 A0 E1 01 80 48 E2 00 80 84 E5 0A 30 D5 E7 7B 00 53 E3 32 00 00 0A 00 00 56 E3 7B 02 00 0A 00 30 D6 E5 30 20 43 E2 09 00 52 E3 98 00 00 9A 34 C0 9D E5 00 00 5C E3 A3 00 00 0A 24 00 53 E3 3A 03 00 0A 2A 10 53 E2 00 20 71 E2 01 20 B2 E0 40 00 53 E2 00 30 70 E2 00 30 B3 E0 02 E0 93 E1 07 02 00 1A 04 0D 9F E5 40 1D 9F E5 00 2D 9F E5 40 3D 9F E5 ?? ?? ?? ?? 23 00 53 E3 64 04 00 0A 28 60 9D E5 0A 80 A0 E1 2C 60 8D E5 46 FF FF EA 03 10 A0 E1 DC 0C 9F E5 18 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 18 30 9D E5 74 02 00 0A 06 00 A0 E1 3C 10 8D E2 40 20 8D E2 63 F9 FF EB 00 60 50 E2 59 FF FF 0A 00 80 94 E5 01 C0 A0 E3 01 80 88 E2 00 80 84 E5 34 C0 8D E5 C3 FF FF EA 01 60 A0 E3 F1 FE FF EA 00 30 94 E5 03 30 D5 E7 7D 00 53 E3 05 50 A0 13 4F FF FF 1A C6 FF FF EA 08 30 D5 E7 2D 00 53 E3 B1 02 00 0A D0 01 00 8A 25 00 53 E3 A2 02 00 0A 2B 00 53 E3 AC 02 00 0A 23 00 53 E3 9B 02 00 1A 01 20 88 E2 02 10 D5 E7 23 00 51 E3 02 10 85 E0 44 03 00 0A 00 C0 A0 E3 30 30 8D E5 28 C0 8D E5 00 20 84 E5 00 30 D1 E5 00 00 53 E3 D9 03 00 0A 00 B0 A0 E3 0B 90 A0 E1 0B 80 A0 E1 0B 00 A0 E1 16 00 00 EA 22 00 53 E3 21 00 00 0A 27 00 53 E3 05 00 00 1A 00 00 58 E3 01 80 A0 03 02 00 00 0A 01 00 58 E3 00 80 A0 03 02 80 A0 13 00 30 94 E5 44 10 8D E2 03 30 D5 E7 48 20 8D E2 29 F9 FF EB 00 00 50 E3 24 00 00 0A 00 20 94 E5 01 20 82 E2 00 20 84 E5 02 30 D5 E7 00 00 53 E3 39 02 00 0A 5C 00 53 E3 10 00 00 0A E5 FF FF 9A 7B 00 53 E3 1C 00 00 0A 7D 00 53 E3 EB FF FF 1A 00 00 58 E3 E9 FF FF 1A 00 00 59 E3 A3 03 00 0A 01 90 49 E2 E5 FF FF EA 00 00 58 E3 02 80 A0 03 E2 FF FF 0A 02 80 58 E2 01 80 A0 13 DF FF FF EA 00 00 58 E3 DD FF FF 1A 01 20 82 E2 00 20 84 E5 02 20 D5 E7 00 00 52 E3 2A 02 00 0A 44 10 8D E2 48 20 8D E2 04 F9 FF EB 00 00 50 E3 D3 FF FF 1A 00 B0 A0 E1 01 50 A0 E3 FA FE FF EA 00 00 58 E3 01 90 89 02 CD FF FF EA 00 00 85 E0 01 30 D0 E5 29 00 53 E3 98 FE FF 1A B4 C0 9D E5 00 70 84 E5 00 40 8D E5 04 C0 8D E5 08 10 8D E5 1C 00 8D E2 07 00 90 E8 05 30 A0 E1 9D FD FF EB 00 60 A0 E1 85 FE FF EA 06 00 A0 E1 00 10 A0 E3 0A 20 A0 E3 ?? ?? ?? ?? E8 3A 9F E5 00 30 93 E5 03 00 50 E1 F9 01 00 BA B4 E0 9D E5 20 A0 1E E2 0A 40 A0 01 07 00 00 0A 03 50 A0 E3 DA FE FF EA 06 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 00 00 54 E3 00 A0 A0 13 F3 FF FF 0A 30 C0 9D E5 00 00 5C E3 39 01 00 0A 23 90 4C E2 2F 00 59 E3 09 F1 9F 97 AA 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 80 A0 E3 00 00 5B E3 54 80 8D E5 50 80 8D E5 4C 80 8D E5 5F 02 00 0A 00 30 DB E5 08 00 53 E1 5C 02 00 0A 0B 70 A0 E1 13 00 00 EA 24 00 53 E3 64 01 00 0A 27 00 53 E3 5C 01 00 0A 22 00 53 E3 3D 01 00 0A 4C 00 9D E5 00 30 D7 E5 07 50 A0 E1 50 10 8D E2 54 20 8D E2 8B F8 FF EB 00 00 50 E3 4C 00 8D E5 17 00 00 0A 01 70 95 E2 49 02 00 0A 01 30 D5 E5 00 00 53 E3 46 02 00 0A 2A 00 53 E3 06 00 00 0A E8 FF FF 9A 5C 00 53 E3 63 01 00 0A 7E 00 53 E3 2F 01 00 0A 3F 00 53 E3 E8 FF FF 1A 00 00 58 E3 4C 00 9D E5 E6 FF FF 0A 50 10 8D E2 54 20 8D E2 5C 30 A0 E3 73 F8 FF EB 00 00 50 E3 4C 00 8D E5 DF FF FF 1A 01 50 A0 E3 69 FE FF EA 00 00 54 E3 C9 FF FF 0A 00 30 D4 E5 00 00 53 E3 02 00 00 1A 28 C0 9D E5 00 00 5C E3 C3 FF FF 1A 2F 00 59 E3 09 F1 9F 97 B8 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 54 E3 05 00 00 0A 00 30 D4 E5 00 00 53 E3 8B FF FF 1A 28 C0 9D E5 00 00 5C E3 88 FF FF 0A 00 00 5A E3 B2 02 00 1A 0A 50 A0 E1 22 FE FF EA C8 07 9F E5 F8 17 9F E5 C4 27 9F E5 F8 37 9F E5 ?? ?? ?? ?? 00 00 54 E3 2D 02 00 0A 00 30 D4 E5 00 00 53 E3 2A 02 00 0A 06 00 A0 E1 ?? ?? ?? ?? 0B 00 A0 E1 ?? ?? ?? ?? 2C 60 9D E5 00 00 56 E3 82 00 00 0A 1C C0 9D E5 00 50 A0 E3 00 00 54 E3 84 50 CD E5 00 60 9C E5 10 03 00 0A 04 00 A0 E1 ?? ?? ?? ?? 05 30 A0 E1 84 10 8D E2 0A 20 A0 E3 ?? ?? ?? ?? 20 10 8D E2 00 30 A0 E1 06 00 91 E8 06 00 A0 E1 AD FB FF EB 1C 60 9D E5 05 00 5A E1 00 00 86 E5 0D FE FF 0A 04 00 A0 E1 ?? ?? ?? ?? 1C 60 9D E5 00 00 96 E5 08 FE FF EA 00 00 54 E3 00 00 5B 13 00 90 A0 13 01 90 A0 03 5A 00 00 0A 00 30 DB E5 00 00 53 E3 D6 FF FF 0A 04 00 A0 E1 ?? ?? ?? ?? 30 C0 9D E5 25 00 5C E3 00 50 84 E0 4F 00 00 0A 92 02 00 9A 30 C0 9D E5 4C 00 5C E3 B0 02 00 0A 52 00 5C E3 CA FF FF 1A 04 00 55 E1 04 70 A0 21 03 00 00 2A C6 FF FF EA 01 70 87 E2 07 00 55 E1 C3 FF FF 3A 0B 00 A0 E1 07 10 A0 E1 00 20 A0 E3 ?? ?? ?? ?? 01 00 50 E3 F6 FF FF 0A 07 70 64 E0 01 00 87 E2 ?? ?? ?? ?? 00 50 50 E2 C4 02 00 0A 04 10 A0 E1 07 20 A0 E1 ?? ?? ?? ?? 00 00 5A E3 00 30 A0 E3 00 30 C0 E5 05 40 A0 01 01 A0 A0 03 AF FF FF 0A 04 00 A0 E1 ?? ?? ?? ?? 05 40 A0 E1 01 A0 A0 E3 AA FF FF EA 00 00 54 E3 05 00 00 0A 00 30 D4 E5 00 00 53 E3 A5 FF FF 1A 28 C0 9D E5 00 00 5C E3 94 FF FF 0A 00 30 DB E5 00 00 53 E3 0B 30 A0 11 5B 02 00 0A 24 16 9F E5 06 20 A0 E1 00 00 A0 E3 ?? ?? ?? ?? 8B FF FF EA 00 00 54 E3 30 02 00 0A 00 50 D4 E5 00 00 55 E3 94 FF FF 1A 28 C0 9D E5 00 00 5C E3 2A 02 00 1A 00 00 5A E3 83 FF FF 0A 04 00 A0 E1 ?? ?? ?? ?? A5 FD FF EA D4 05 9F E5 04 16 9F E5 D8 25 9F E5 04 36 9F E5 ?? ?? ?? ?? 0B 00 A0 E1 05 10 A0 E1 00 20 A0 E3 ?? ?? ?? ?? 01 00 50 E3 B2 02 00 1A 01 50 45 E2 04 00 55 E1 F6 FF FF 2A 06 00 A0 E1 ?? ?? ?? ?? 0B 00 A0 E1 ?? ?? ?? ?? 2C 60 9D E5 00 00 56 E3 7E FF FF 1A 00 00 54 E3 C9 01 00 0A B8 C0 9D E5 C4 E0 9D E5 01 30 7C E2 00 30 A0 33 00 00 5E E3 01 30 83 13 00 00 53 E3 F2 00 00 0A 1C 60 9D E5 20 10 8D E2 06 00 91 E8 00 00 96 E5 04 30 A0 E1 2D FB FF EB 00 00 5A E3 00 00 86 E5 8E FD FF 0A 04 00 A0 E1 ?? ?? ?? ?? 00 00 96 E5 8A FD FF EA 3D 00 53 E3 DD 00 00 0A 96 00 00 9A 3F 00 53 E3 DA 00 00 0A 7D 00 53 E3 C9 00 00 1A 00 C0 A0 E3 28 C0 8D E5 0A 30 D5 E7 30 C0 8D E5 0C B0 A0 E1 E2 FD FF EA 2C 10 9D E5 00 00 51 E3 96 00 00 0A FC 34 9F E5 00 30 93 E5 00 00 A0 E3 00 00 53 E1 6C 00 CD E5 6C 10 8D E2 01 00 43 C2 0A 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 1C C0 9D E5 20 10 8D E2 00 30 A0 E1 06 00 91 E8 00 00 9C E5 06 FB FF EB 1C E0 9D E5 00 00 8E E5 06 00 A0 E1 ?? ?? ?? ?? 0B 00 A0 E1 ?? ?? ?? ?? 1C 10 9D E5 00 60 91 E5 01 60 76 E2 00 60 A0 33 EB FC FF EA 02 00 58 E3 77 00 00 0A 00 00 58 E3 BD FE FF 1A 02 80 A0 E3 07 50 A0 E1 C3 FE FF EA 00 00 58 E3 B8 FE FF 1A 50 30 9D E5 00 00 53 E3 B5 FE FF 1A 70 E0 8D E2 00 E0 8D E5 04 80 8D E5 4C 00 8D E2 50 10 8D E2 54 20 8D E2 07 30 A0 E1 70 80 8D E5 00 FB FF EB 00 00 50 E3 1E 00 00 0A 00 00 5A E3 00 50 A0 E1 30 01 00 1A 4C 00 9D E5 ?? ?? ?? ?? 31 FD FF EA 01 00 58 E3 5A 00 00 0A 00 00 58 E3 A0 FE FF 1A 01 80 A0 E3 E1 FF FF EA B4 10 9D E5 00 20 A0 E3 01 30 A0 E3 70 E0 8D E2 04 10 8D E5 08 20 8D E5 0C 20 8D E5 10 20 8D E5 14 30 8D E5 00 C0 A0 E3 00 E0 8D E5 4C 00 8D E2 50 10 8D E2 54 20 8D E2 07 30 A0 E1 70 C0 8D E5 9D FC FF EB 00 00 50 E3 E0 FF FF 1A 70 30 9D E5 03 70 87 E0 CB FF FF EA 4C 00 9D E5 50 10 8D E2 54 20 8D E2 16 F7 FF EB 4C 00 8D E5 01 30 D7 E5 00 00 53 E3 01 50 87 E2 39 02 00 0A 00 00 50 E3 80 FE FF 1A 9D FE FF EA 2C C0 9D E5 00 00 5C E3 0F FD FF 0A 70 33 9F E5 00 00 93 E5 88 10 8D E2 1C 60 61 E5 01 00 40 E2 0A 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 00 E0 A0 E3 00 40 A0 E1 2C E0 8D E5 22 FE FF EA 28 C0 9D E5 30 C0 8D E5 0C B0 A0 E1 01 C0 A0 E3 00 60 A0 E1 0A 30 D5 E7 34 C0 8D E5 68 FD FF EA 0C 80 A0 E1 01 C0 A0 E3 00 60 A0 E1 34 C0 8D E5 9F FD FF EA 28 60 9D E5 00 00 56 E3 A4 00 00 1A 34 60 8D E5 30 60 8D E5 06 B0 A0 E1 59 FD FF EA F4 32 9F E5 00 30 93 E5 00 41 93 E7 0A FE FF EA 00 B0 A0 E1 02 80 A0 E1 52 FD FF EA 3A 00 53 E3 34 00 00 1A 01 90 88 E2 09 10 D5 E7 BC 02 9F E5 ?? ?? ?? ?? 00 00 50 E3 6E 01 00 1A 00 B0 A0 E1 05 50 A0 E3 D4 FC FF EA 00 80 A0 E3 88 FF FF EA 00 00 52 E3 0D 01 00 0A 9C 32 9F E5 00 50 93 E5 04 30 95 E5 00 00 53 E3 03 40 A0 01 08 00 00 0A 04 70 85 E2 00 40 A0 E3 03 00 A0 E1 ?? ?? ?? ?? 04 30 B7 E5 01 00 80 E2 00 00 53 E3 00 40 84 E0 F8 FF FF 1A 04 00 A0 E1 ?? ?? ?? ?? 00 40 50 E2 51 FE FF 0A 00 30 A0 E3 00 30 C4 E5 04 10 95 E5 03 00 51 E1 0D 00 00 0A 08 70 85 E2 04 00 A0 E1 ?? ?? ?? ?? 04 30 97 E4 00 00 53 E3 20 50 A0 E3 06 00 00 0A 00 50 C0 E5 01 00 80 E2 04 10 17 E5 ?? ?? ?? ?? 04 30 97 E4 00 00 53 E3 F8 FF FF 1A 01 A0 A0 E3 D3 FD FF EA 05 50 A0 E3 00 B0 A0 E3 A5 FC FF EA 01 20 88 E2 02 10 D5 E7 25 00 51 E3 02 10 85 E0 60 FD FF 1A 00 C0 A0 E3 02 20 88 E2 28 C0 8D E5 52 C0 A0 E3 02 10 85 E0 30 C0 8D E5 5C FD FF EA 01 20 88 E2 00 C0 A0 E3 30 30 8D E5 02 10 85 E0 28 C0 8D E5 56 FD FF EA 04 00 A0 E1 ?? ?? ?? ?? 00 00 5A E3 00 60 A0 E1 C6 00 00 1A 00 00 56 E3 21 01 00 0A 00 80 A0 E3 1C 90 9D E5 24 B0 9D E5 08 70 A0 E1 06 40 A0 E1 04 00 A0 E1 C0 10 9D E5 ?? ?? ?? ?? 00 00 58 E3 00 50 84 E0 02 00 00 1A 00 30 D4 E7 00 00 53 E3 7D 00 00 0A BC 10 9D E5 05 00 A0 E1 }
	condition:
		$1
}

rule file_144_14_0 {
	meta:
		name = "wordfree"
		size = 88
		refs = "002c free"
	strings:
		$1 = { 38 40 2D E9 00 50 50 E2 10 00 00 0A 04 30 95 E5 00 00 53 E3 0D 00 00 0A 08 40 95 E5 04 01 93 E7 00 00 50 E3 04 41 83 E0 04 00 00 0A ?? ?? ?? ?? 04 00 B4 E5 00 00 50 E3 FB FF FF 1A 04 30 95 E5 03 00 A0 E1 ?? ?? ?? ?? 00 30 A0 E3 04 30 85 E5 38 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_144_15_0 {
	meta:
		name = "wordexp"
		size = 2452
		refs = "006c calloc 0088 getenv 01c0 free 0368 strchr 050c wordfree 05e0 __strdup 05f0 globfree 0774 glob 08ac __assert_fail"
	strings:
		$1 = { F0 4F 2D E9 84 D0 4D E2 1C 20 8D E5 1C 30 9D E5 01 60 A0 E1 00 40 A0 E1 07 00 91 E8 00 50 A0 E3 08 00 13 E3 44 30 8D E2 18 30 8D E5 07 00 83 E8 2C 10 8D E5 38 50 8D E5 34 50 8D E5 3C 50 8D E5 2D 02 00 1A 1C 10 9D E5 02 10 11 E2 28 10 8D E5 0B 00 00 1A 1C 20 9D E5 01 00 12 E3 00 10 86 E5 FA 01 00 1A 01 00 A0 E3 04 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 04 00 86 E5 26 01 00 0A 28 30 9D E5 08 30 86 E5 E4 08 9F E5 ?? ?? ?? ?? 00 80 50 E2 F9 01 00 0A 00 00 D8 E5 00 00 50 E3 40 10 8D 02 20 10 8D 05 01 C0 A0 01 1C 00 00 0A 40 30 8D E2 20 30 8D E5 03 C0 A0 E1 08 50 A0 E1 03 70 A0 E1 09 30 40 E2 20 00 50 E3 01 00 53 13 10 00 00 8A 07 00 5C E1 F8 01 00 9A 40 30 DD E5 00 00 53 E1 F5 01 00 0A 41 30 8D E2 03 00 00 EA 00 10 D3 E5 00 00 51 E1 01 30 83 E2 02 00 00 0A 0C 00 53 E1 03 20 A0 E1 F8 FF FF 1A 0C 00 52 E1 00 00 C2 05 01 C0 8C 02 01 00 F5 E5 00 00 50 E3 E7 FF FF 1A 00 30 A0 E3 00 30 CC E5 00 50 D4 E5 00 30 A0 E3 03 00 55 E1 30 30 8D E5 03 A0 A0 11 46 00 00 0A 3F 00 55 E3 B4 00 00 0A 2B 00 00 8A 24 00 55 E3 FD 00 00 0A 4A 00 00 9A 27 00 55 E3 AC 00 00 1A 01 20 83 E2 02 30 D4 E7 00 00 53 E3 30 20 8D E5 6A 00 00 0A 27 00 53 E3 6D 00 00 0A 3C 00 9D E5 07 00 00 EA 30 20 9D E5 01 20 82 E2 02 30 D4 E7 00 00 53 E3 30 20 8D E5 61 00 00 0A 27 00 53 E3 63 00 00 0A 34 10 8D E2 38 20 8D E2 50 F4 FF EB 00 00 50 E3 3C 00 8D E5 F1 FF FF 1A 01 50 A0 E3 ?? ?? ?? ?? 01 00 55 E3 07 00 00 0A 28 10 9D E5 00 00 51 E3 CC 01 00 0A 2C 20 9D E5 18 30 9D E5 48 20 8D E5 07 00 93 E8 07 00 86 E8 05 00 A0 E1 84 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 5C 00 55 E3 79 00 00 0A 53 00 00 9A 60 00 55 E3 63 00 00 0A 7E 00 55 E3 51 00 00 1A 00 20 96 E5 30 30 8D E2 04 20 8D E5 00 30 8D E5 3C 00 8D E2 34 10 8D E2 38 20 8D E2 04 30 A0 E1 EF F7 FF EB 00 50 50 E2 67 00 00 1A 30 30 9D E5 01 30 83 E2 03 50 D4 E7 00 00 55 E3 30 30 8D E5 B8 FF FF 1A 3C 10 9D E5 00 00 51 E3 AB 01 00 0A 06 00 A0 E1 F2 F3 FF EB 00 50 A0 E1 05 00 A0 E1 84 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 22 00 55 E3 34 00 00 1A 01 20 83 E2 02 30 D4 E7 00 00 53 E3 30 20 8D E5 1F 00 00 0A 1C 10 9D E5 30 B0 8D E2 04 70 01 E2 24 00 53 E3 D4 00 00 0A 1C 00 00 9A 5C 00 53 E3 EA 00 00 0A 60 00 53 E3 E0 00 00 1A 00 00 57 E3 9A 01 00 1A 01 C0 82 E2 1C 20 9D E5 00 B0 8D E5 84 00 8D E9 0C 70 8D E5 10 70 8D E5 3C 00 8D E2 34 10 8D E2 38 20 8D E2 04 30 A0 E1 30 C0 8D E5 6C F6 FF EB 00 00 50 E3 CD 00 00 1A 30 20 9D E5 01 20 82 E2 02 30 D4 E7 00 00 53 E3 30 20 8D E5 E2 FF FF 1A 3C 00 9D E5 05 50 A0 E3 A4 FF FF EA 22 00 53 E3 C5 00 00 1A 34 10 9D E5 00 00 51 E3 C0 FF FF 1A 06 00 A0 E1 BC F3 FF EB 00 00 50 E3 BC FF FF 0A 00 50 A0 E1 A4 FF FF EA 5B 00 55 E3 2E 00 00 0A 0C 06 9F E5 05 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 53 01 00 0A 3C 10 9D E5 00 00 51 E3 03 00 00 0A 06 00 A0 E1 AC F3 FF EB 00 50 50 E2 14 00 00 1A 38 A0 8D E5 34 A0 8D E5 3C A0 8D E5 A8 FF FF EA 1C 10 9D E5 04 00 11 E3 5F 01 00 1A 01 C0 83 E2 20 30 9D E5 30 20 8D E2 42 01 8D E9 10 30 8D E5 00 20 8D E5 3C 00 8D E2 34 10 8D E2 38 20 8D E2 04 30 A0 E1 30 C0 8D E5 35 F6 FF EB 00 50 50 E2 97 FF FF 0A 3C 00 9D E5 74 FF FF EA 30 30 8D E2 00 30 8D E5 3C 00 8D E2 34 10 8D E2 38 20 8D E2 04 30 A0 E1 E6 F3 FF EB 00 50 50 E2 8C FF FF 0A F3 FF FF EA 2A 00 55 E3 D0 FF FF 1A 30 B0 9D E5 0B 90 D4 E7 00 00 59 E3 50 30 8D 02 50 A0 8D E5 54 A0 8D E5 58 A0 8D E5 24 30 8D 05 B8 00 00 0A 50 10 8D E2 01 50 A0 E3 00 70 A0 E3 24 10 8D E5 19 00 00 EA 22 00 59 E3 35 00 00 0A 01 00 57 E3 3A 01 00 0A 24 00 59 E3 95 00 00 0A 5C 00 59 E3 1C 00 00 1A 00 00 57 E3 84 00 00 0A 30 20 8D E2 00 20 8D E5 3C 00 8D E2 34 10 8D E2 38 20 8D E2 04 30 A0 E1 DA F3 FF EB 00 50 A0 E1 00 00 55 E3 54 00 00 1A 30 B0 9D E5 01 B0 8B E2 0B 90 D4 E7 00 00 59 E3 30 B0 8D E5 99 00 00 0A 08 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 94 00 00 1A 27 00 59 E3 DE FF FF 1A 00 00 57 E3 74 00 00 0A 01 00 57 E3 16 00 00 0A 09 30 A0 E1 3C 00 9D E5 34 10 8D E2 38 20 8D E2 7D F3 FF EB 00 00 50 E3 3C 00 8D E5 E6 FF FF 1A 24 00 9D E5 ?? ?? ?? ?? 00 00 55 E3 4A FF FF 0A 3C 00 9D E5 ?? ?? ?? ?? 01 50 A0 E3 05 00 A0 E1 84 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 00 57 E3 5F 00 00 0A 02 00 57 E3 E8 FF FF 1A 00 70 A0 E1 D6 FF FF EA 1C 10 9D E5 20 20 9D E5 30 30 8D E2 42 01 8D E9 10 20 8D E5 00 30 8D E5 14 A0 8D E5 3C 00 8D E2 34 10 8D E2 38 20 8D E2 04 30 A0 E1 DB F8 FF EB 00 50 50 E2 2F FF FF 0A 96 FF FF EA 3C 00 9D E5 00 00 50 E3 03 00 00 0A ?? ?? ?? ?? 38 50 8D E5 34 50 8D E5 3C 50 8D E5 5C 30 9D E5 00 00 53 E3 00 50 A0 13 08 00 00 1A BD 00 00 EA 06 00 A0 E1 1E F3 FF EB 00 00 50 E3 08 00 00 1A 5C 30 9D E5 01 50 85 E2 03 00 55 E1 B5 00 00 2A 60 30 9D E5 05 01 93 E7 ?? ?? ?? ?? 00 10 50 E2 F2 FF FF 1A 5C 00 8D E2 ?? ?? ?? ?? 01 50 A0 E3 24 00 9D E5 ?? ?? ?? ?? 3C 00 9D E5 ED FE FF EA 1C 20 9D E5 20 30 9D E5 01 10 A0 E3 44 01 8D E9 10 30 8D E5 14 10 8D E5 00 B0 8D E5 3C 00 8D E2 34 10 8D E2 38 20 8D E2 04 30 A0 E1 AC F8 FF EB 00 00 50 E3 31 FF FF 0A 00 50 A0 E1 3C 00 9D E5 DC FE FF EA 3C 00 9D E5 34 10 8D E2 38 20 8D E2 25 F3 FF EB 00 00 50 E3 3C 00 8D E5 27 FF FF 1A D3 FE FF EA 00 B0 8D E5 3C 00 8D E2 34 10 8D E2 38 20 8D E2 04 30 A0 E1 5F F3 FF EB 00 00 50 E3 1E FF FF 0A EB FF FF EA 30 30 8D E2 00 30 8D E5 3C 00 8D E2 34 10 8D E2 38 20 8D E2 04 30 A0 E1 3D F3 FF EB 00 50 A0 E1 79 FF FF EA 01 70 A0 E3 7A FF FF EA 02 70 A0 E3 78 FF FF EA 02 20 57 E2 00 30 72 E2 1C 10 9D E5 02 30 B3 E0 30 20 8D E2 00 20 8D E5 04 10 8D E5 24 20 9D E5 20 10 9D E5 08 20 8D E5 10 10 8D E5 14 30 8D E5 0C 80 8D E5 3C 00 8D E2 34 10 8D E2 38 20 8D E2 04 30 A0 E1 77 F8 FF EB 00 50 50 E2 63 FF FF 0A 24 00 9D E5 ?? ?? ?? ?? 3C 00 9D E5 A6 FE FF EA 01 20 4B E2 24 00 9D E5 3C 10 9D E5 30 20 8D E5 C0 F2 FF EB 00 50 50 E2 38 A0 8D E5 34 A0 8D E5 3C A0 8D E5 AA FF FF 1A 50 30 9D E5 00 00 53 E3 3A 00 00 0A 05 70 A0 E1 01 B0 A0 E3 54 30 9D E5 10 10 A0 E3 07 00 93 E7 00 20 A0 E3 5C 30 8D E2 ?? ?? ?? ?? 00 50 50 E2 44 00 00 1A 00 30 D8 E5 00 00 53 E3 7E FF FF 1A 60 30 9D E5 00 30 93 E5 00 00 53 E3 6F 00 00 0A 3C 00 9D E5 34 10 8D E2 38 20 8D E2 79 F6 FF EB 5C 30 9D E5 01 00 53 E3 3C 00 8D E5 17 00 00 9A 00 00 50 E3 15 00 00 0A 01 50 A0 E3 02 00 00 EA 3C 00 9D E5 00 00 50 E3 10 00 00 0A 34 10 8D E2 38 20 8D E2 20 30 A0 E3 C2 F2 FF EB 00 00 50 E3 3C 00 8D E5 05 00 00 0A 60 30 9D E5 34 10 8D E2 05 31 93 E7 38 20 8D E2 62 F6 FF EB 3C 00 8D E5 5C 30 9D E5 01 50 85 E2 03 00 55 E1 EB FF FF 3A 5C 00 8D E2 ?? ?? ?? ?? 3C 30 9D E5 00 00 53 E3 70 FF FF 0A 50 30 9D E5 03 00 5B E1 04 70 87 E2 01 B0 8B E2 C6 FF FF 3A 24 00 9D E5 ?? ?? ?? ?? 7C FE FF EA 08 00 96 E5 04 10 A0 E3 01 00 80 E2 ?? ?? ?? ?? 00 00 50 E3 04 00 86 E5 2A FF FF 0A FC 00 9F E5 ?? ?? ?? ?? 00 80 50 E2 05 FE FF 1A F4 30 9F E5 80 20 8D E2 40 30 22 E5 20 20 8D E5 02 80 A0 E1 24 FE FF EA 01 00 55 E3 55 FF FF 0A D8 00 9F E5 D8 10 9F E5 63 2F A0 E3 D4 30 9F E5 ?? ?? ?? ?? 5C 00 8D E2 ?? ?? ?? ?? DC FF FF EA 07 20 A0 E1 10 FE FF EA BC 00 9F E5 05 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 1B 00 00 1A 05 30 A0 E1 3C 00 9D E5 34 10 8D E2 38 20 8D E2 81 F2 FF EB 00 00 50 E3 3C 00 8D E5 52 FE FF 1A 07 FF FF EA 06 00 A0 E1 ?? ?? ?? ?? 2C 50 8D E5 CD FD FF EA 06 00 A0 E1 ?? ?? ?? ?? 2F FE FF EA 01 50 A0 E1 05 00 A0 E1 84 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 04 50 A0 E3 3C 00 9D E5 ?? ?? ?? ?? 23 FE FF EA 3C 00 9D E5 04 50 A0 E3 1D FE FF EA 02 50 A0 E3 F7 FF FF EA 5C 00 59 E3 E3 FE FF 1A C7 FE FF EA 28 00 9F E5 18 10 9F E5 24 20 9F E5 14 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 20 09 0A 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 93 01 00 00 }
	condition:
		$1
}

rule file_145_0_0 {
	meta:
		name = "__wcrtomb_chk"
		size = 64
		refs = "0010 __aeabi_read_tp 002c __wcrtomb 0038 __chk_fail 003c _nl_current_LC_CTYPE"
	strings:
		$1 = { 38 40 2D E9 30 40 9F E5 00 50 A0 E1 04 40 9F E7 ?? ?? ?? ?? 04 C0 90 E7 00 C0 9C E5 58 C0 9C E5 03 00 5C E1 03 00 00 8A 05 00 A0 E1 ?? ?? ?? ?? 38 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_146_0_0 {
	meta:
		name = "critical_factorization"
		size = 280
	strings:
		$1 = { F0 03 2D E9 01 70 A0 E3 07 C0 A0 E1 00 40 A0 E3 00 50 E0 E3 04 30 8C E0 01 00 53 E1 05 60 80 E0 0A 00 00 2A 0C 60 D6 E7 03 80 D0 E7 06 00 58 E1 22 00 00 2A 03 40 A0 E1 01 C0 A0 E3 03 70 65 E0 04 30 8C E0 01 00 53 E1 05 60 80 E0 F4 FF FF 3A 01 90 A0 E3 00 70 82 E5 09 C0 A0 E1 00 40 A0 E3 00 60 E0 E3 04 30 8C E0 03 00 51 E1 06 70 80 E0 0A 00 00 9A 0C 70 D7 E7 03 80 D0 E7 07 00 58 E1 14 00 00 9A 03 40 A0 E1 01 C0 A0 E3 03 90 66 E0 04 30 8C E0 03 00 51 E1 06 70 80 E0 F4 FF FF 8A 01 60 86 E2 01 50 85 E2 05 00 56 E1 06 00 A0 21 05 00 A0 31 00 90 82 25 F0 03 BD E8 ?? ?? ?? ?? 0A 00 00 0A 01 70 A0 E3 04 50 A0 E1 07 C0 A0 E1 07 40 84 E0 CE FF FF EA 09 00 00 0A 01 90 A0 E3 04 60 A0 E1 09 C0 A0 E1 09 40 84 E0 DC FF FF EA 07 00 5C E1 01 C0 8C 12 03 40 A0 01 01 C0 A0 03 C3 FF FF EA 09 00 5C E1 01 C0 8C 12 03 40 A0 01 01 C0 A0 03 D2 FF FF EA }
	condition:
		$1
}

rule file_146_1_0 {
	meta:
		name = "two_way_long_needle"
		size = 904
		refs = "009c memcmp 0118 memchr"
	strings:
		$1 = { F0 4F 2D E9 42 DE 4D E2 04 D0 4D E2 02 90 A0 E1 03 40 A0 E1 1C 20 8D E2 01 30 A0 E1 00 50 A0 E1 04 10 A0 E1 09 00 A0 E1 00 30 8D E5 AD FF FF EB 41 1E 8D E2 00 30 9D E5 00 80 A0 E1 1C 20 8D E2 0C 10 81 E2 04 40 A2 E5 01 00 52 E1 FC FF FF 1A 00 00 54 E3 01 C0 44 12 00 20 A0 13 07 00 00 0A 02 10 D9 E7 0C 00 62 E0 42 EE 8D E2 01 20 82 E2 01 11 8E E0 04 00 52 E1 00 04 01 E5 F7 FF FF 1A 1C 00 9D E5 04 00 8D E5 04 20 9D E5 09 00 A0 E1 02 10 89 E0 08 20 A0 E1 00 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 00 30 9D E5 5F 00 00 1A 04 20 9D E5 00 70 A0 E1 01 00 48 E2 00 10 89 E0 04 20 62 E0 01 E0 68 E2 08 00 8D E5 07 B0 A0 E1 10 10 8D E5 01 60 44 E2 0C 20 8D E5 14 E0 8D E5 03 00 A0 E1 08 00 00 EA 00 00 57 E3 03 00 00 0A 04 10 9D E5 0C 20 9D E5 03 00 51 E1 02 30 A0 81 03 B0 8B E0 00 70 A0 E3 0A 00 A0 E1 04 A0 8B E0 0A 20 60 E0 00 10 A0 E3 00 00 85 E0 ?? ?? ?? ?? 00 00 50 E3 3C 00 00 1A 00 00 5A E3 3A 00 00 0A 0A 30 85 E0 01 30 53 E5 42 0E 8D E2 03 31 80 E0 00 34 13 E5 00 00 53 E3 E6 FF FF 1A 08 00 57 E1 07 30 A0 21 08 30 A0 31 0B 00 83 E0 06 00 53 E1 00 20 85 E0 03 10 89 E0 0B 00 00 2A 00 00 D5 E7 03 C0 D9 E7 00 00 5C E1 04 00 00 0A 23 00 00 EA 01 C0 F1 E5 01 00 F2 E5 00 00 5C E1 1F 00 00 1A 01 30 83 E2 06 00 53 E1 F8 FF FF 3A 08 00 9D E5 08 00 57 E1 00 30 8B E0 03 10 85 E0 72 00 00 2A 10 00 9D E5 03 30 D5 E7 00 20 D0 E5 03 00 52 E1 6D 00 00 1A 00 20 A0 E1 08 30 9D E5 05 00 00 EA 01 00 71 E5 01 C0 72 E5 00 00 5C E1 01 00 43 E2 03 00 00 1A 00 30 A0 E1 07 00 53 E1 F7 FF FF 1A 07 30 A0 E1 01 70 87 E2 03 00 57 E1 60 00 00 8A 04 30 9D E5 0C 70 9D E5 03 B0 8B E0 BD FF FF EA 14 10 9D E5 0B B0 81 E0 B8 FF FF EA 00 00 A0 E3 42 DE 8D E2 04 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 04 20 68 E0 08 00 52 E1 08 20 A0 31 01 E0 48 E2 01 20 82 E2 01 10 68 E2 0E 00 89 E0 04 E0 8D E5 10 20 8D E5 0C 10 8D E5 1C 20 8D E5 08 00 8D E5 01 B0 80 E0 08 90 89 E0 00 A0 A0 E3 01 60 44 E2 03 00 A0 E1 04 70 8A E0 07 20 60 E0 00 10 A0 E3 00 00 85 E0 ?? ?? ?? ?? 00 00 50 E3 E2 FF FF 1A 00 00 57 E3 E0 FF FF 0A 07 30 85 E0 01 30 53 E5 42 2E 8D E2 03 31 82 E0 00 34 13 E5 00 00 53 E3 29 00 00 1A 08 30 8A E0 06 00 58 E1 03 10 85 E0 0D 00 00 2A 03 30 D5 E7 00 20 D9 E5 03 00 52 E1 24 00 00 1A 09 20 A0 E1 08 30 A0 E1 03 00 00 EA 01 C0 F2 E5 01 00 F1 E5 00 00 5C E1 1E 00 00 1A 01 30 83 E2 06 00 53 E1 F8 FF FF 3A 04 30 9D E5 01 00 73 E3 03 30 8A E0 03 20 85 E0 0C 00 00 0A 08 00 9D E5 03 30 D5 E7 00 10 D0 E5 03 00 51 E1 0C 00 00 1A 00 30 A0 E1 03 00 00 EA 01 00 73 E5 01 10 72 E5 01 00 50 E1 06 00 00 1A 0B 00 53 E1 F9 FF FF 1A 0A 00 85 E0 42 DE 8D E2 04 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 10 30 9D E5 03 A0 8A E0 07 00 A0 E1 C2 FF FF EA 08 30 A0 E1 0C E0 9D E5 0A A0 8E E0 03 A0 8A E0 F8 FF FF EA 08 30 A0 E1 9B FF FF EA 0B 00 85 E0 A4 FF FF EA }
	condition:
		$1
}

rule file_146_2_0 {
	meta:
		name = "strstr"
		size = 1100
		refs = "007c strchr 0120 memcmp 016c memchr"
	strings:
		$1 = { F0 4F 2D E9 00 20 D0 E5 00 00 52 E3 2C D0 4D E2 00 80 A0 E1 01 50 A0 E1 00 01 00 0A 00 C0 D1 E5 00 00 5C E3 2D 00 00 0A 00 B0 A0 E1 01 60 81 E2 01 90 A0 E3 02 00 00 EA 01 C0 D6 E4 00 00 5C E3 09 00 00 0A 0C 00 52 E1 00 90 A0 13 01 90 09 02 01 20 FB E5 00 00 52 E3 06 40 A0 E1 F5 FF FF 1A 00 30 D4 E5 00 00 53 E3 18 00 00 1A 00 00 59 E3 1A 00 00 1A 00 10 D5 E5 01 00 88 E2 ?? ?? ?? ?? 00 70 50 E2 04 50 65 E0 18 00 00 0A 01 00 55 E3 EB 00 00 0A 05 80 88 E0 08 00 57 E1 04 A0 65 E0 08 40 67 90 01 40 A0 83 1F 00 55 E3 11 00 00 9A 07 00 A0 E1 04 10 A0 E1 0A 20 A0 E1 05 30 A0 E1 EC FE FF EB 2C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 00 A0 E3 2C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 08 00 A0 E1 2C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 09 00 A0 E1 F2 FF FF EA 05 10 A0 E1 24 20 8D E2 0A 00 A0 E1 95 FE FF EB 24 30 9D E5 00 20 A0 E1 00 90 A0 E1 03 10 8A E0 0A 00 A0 E1 04 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 4A 00 00 1A 04 20 9D E5 01 30 49 E2 00 60 A0 E1 00 80 A0 E1 05 20 62 E0 03 00 8A E0 00 00 8D E5 0C 20 8D E5 01 00 69 E2 08 00 8D E5 03 B0 A0 E1 04 00 A0 E1 05 40 88 E0 04 20 60 E0 00 10 A0 E3 00 00 87 E0 ?? ?? ?? ?? 00 00 50 E3 D5 FF FF 1A 00 00 54 E3 D3 FF FF 0A 09 00 56 E1 06 30 A0 21 09 30 A0 31 08 00 83 E0 03 00 55 E1 00 20 87 E0 03 10 8A E0 0B 00 00 9A 00 00 D7 E7 03 C0 DA E7 00 00 5C E1 04 00 00 0A 23 00 00 EA 01 C0 F1 E5 01 00 F2 E5 00 00 5C E1 1F 00 00 1A 01 30 83 E2 03 00 55 E1 F8 FF FF 8A 0B 30 88 E0 06 00 59 E1 03 10 87 E0 84 00 00 9A 00 00 9D E5 03 30 D7 E7 00 20 D0 E5 03 00 52 E1 7F 00 00 1A 00 20 A0 E1 0B 30 A0 E1 05 00 00 EA 01 00 71 E5 01 C0 72 E5 00 00 5C E1 01 00 43 E2 03 00 00 1A 00 30 A0 E1 06 00 53 E1 F7 FF FF 1A 06 30 A0 E1 01 60 86 E2 06 00 53 E1 7E 00 00 3A 04 30 9D E5 0C 60 9D E5 03 80 88 E0 04 00 A0 E1 C5 FF FF EA 08 00 9D E5 08 80 80 E0 03 80 88 E0 00 60 A0 E3 F8 FF FF EA 01 60 89 E2 09 30 87 E0 06 00 54 E1 00 30 8D E5 09 80 DA E7 62 00 00 3A 01 30 49 E2 04 30 8D E5 03 30 8A E0 08 30 8D E5 05 20 69 E0 08 00 9D E5 01 30 69 E2 09 00 52 E1 09 20 A0 31 01 20 82 E2 18 30 8D E5 06 A0 8A E0 03 B0 80 E0 02 30 89 E2 14 90 8D E5 1C 20 8D E5 24 20 8D E5 00 10 9D E5 10 30 8D E5 0C 60 8D E5 0A 90 A0 E1 02 00 00 EA 00 00 52 E3 7F FF FF 0A 03 10 A0 E1 00 20 D1 E5 02 00 58 E1 01 30 81 E2 F8 FF FF 1A 00 00 9D E5 0C 20 9D E5 03 30 60 E0 02 00 55 E1 01 A0 43 E2 0F 00 00 9A 01 30 D1 E5 00 20 D9 E5 03 00 52 E1 02 10 81 E2 09 20 A0 01 10 30 9D 05 06 00 00 0A 45 00 00 EA 01 00 F2 E5 01 C0 D1 E4 0C 00 50 E1 01 00 83 E2 16 00 00 1A 00 30 A0 E1 03 00 55 E1 F7 FF FF 1A 04 30 9D E5 01 00 73 E3 03 30 8A E0 03 10 87 E0 0C 00 00 0A 08 00 9D E5 03 20 D7 E7 00 30 D0 E5 02 00 53 E1 08 30 9D 05 04 00 00 0A 1C 00 00 EA 01 00 73 E5 01 20 71 E5 02 00 50 E1 18 00 00 1A 0B 00 53 E1 F9 FF FF 1A 0A 00 87 E0 4D FF FF EA 00 00 5C E3 4E FF FF 0A 03 00 55 E1 E7 FF FF 9A 18 20 9D E5 0A A0 82 E0 03 60 8A E0 05 A0 86 E0 0A 20 64 E0 04 00 87 E0 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 42 FF FF 1A 00 00 5A E3 40 FF FF 0A 14 00 9D E5 00 30 86 E0 03 30 87 E0 0A 40 A0 E1 BB FF FF EA 00 00 52 E3 39 FF FF 0A 1C 30 9D E5 03 60 8A E0 EC FF FF EA 09 30 A0 E1 89 FF FF EA 01 20 64 E2 09 20 82 E0 04 00 87 E0 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 2D FF FF 1A 06 40 A0 E1 93 FF FF EA 01 40 A0 E1 01 90 A0 E3 0C FF FF EA 08 00 87 E0 23 FF FF EA 00 00 53 E3 24 FF FF 0A 0C 30 9D E5 D5 FF FF EA 07 00 A0 E1 1D FF FF EA }
	condition:
		$1
}

rule file_147_2_0 {
	meta:
		name = "__libc_allocate_rtsig"
		size = 80
	strings:
		$1 = { 44 20 9F E5 00 30 92 E5 01 00 73 E3 0C 00 00 0A 04 10 92 E5 01 00 53 E1 07 00 00 CA 00 00 50 E3 01 10 83 12 01 30 41 02 03 00 A0 11 00 10 82 15 04 30 82 05 01 00 A0 01 ?? ?? ?? ?? 00 00 E0 E3 ?? ?? ?? ?? 03 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_149_0_0 {
	meta:
		name = "_IO_ftell"
		size = 688
		refs = "001c __aeabi_read_tp 0094 _IO_seekoff_unlocked 0204 __lll_lock_wait_private 02a0 _Unwind_Resume 02a4 __libc_errno"
	strings:
		$1 = { F0 43 2D E9 00 40 90 E5 02 49 14 E2 0C D0 4D E2 00 50 A0 E1 18 00 00 1A 48 60 90 E5 ?? ?? ?? ?? 08 30 96 E5 13 7D 40 E2 07 00 53 E1 0F 00 00 0A 01 10 A0 E3 06 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 66 00 00 1A 48 30 95 E5 08 70 83 E5 03 60 A0 E1 04 30 96 E5 01 30 83 E2 04 30 86 E5 01 20 A0 E3 00 30 A0 E3 0C 00 8D E8 05 00 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 01 90 A0 E1 00 10 95 E5 01 0C 11 E3 00 80 A0 E1 07 00 00 0A 00 20 E0 E3 00 30 E0 E3 03 00 59 E1 02 00 58 01 02 00 00 0A 6C 30 95 E5 00 00 53 E3 36 00 00 DA 02 09 11 E3 17 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 11 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 29 00 00 CA 00 20 E0 E3 00 30 E0 E3 03 00 59 E1 02 00 58 01 08 00 00 0A 08 20 A0 E1 C8 3F A0 E1 09 00 53 E1 08 00 52 01 08 00 A0 E1 17 00 00 1A 0C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 30 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 00 00 53 E3 00 00 E0 13 F5 FF FF 1A 18 31 9F E5 05 20 A0 E3 03 30 9F E7 03 20 80 E7 00 00 E0 E3 0C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 2C 20 95 E5 24 30 95 E5 02 30 63 E0 03 80 58 E0 C3 9F C9 E0 C2 FF FF EA E4 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 4B 20 A0 E3 03 20 80 E7 00 00 E0 E3 E0 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF CC FF FF EA 06 00 A0 E1 ?? ?? ?? ?? 95 FF FF EA 00 30 95 E5 02 09 13 E3 00 80 A0 E1 1F 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 19 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 07 00 00 DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 08 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_150_0_0 {
	meta:
		name = "__getgid"
		size = 20
	strings:
		$1 = { 04 70 2D E5 C8 70 A0 E3 00 00 00 EF 04 70 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_151_0_0 {
	meta:
		name = "__new_exitfn"
		size = 480
		refs = "016c calloc 0198 __assert_fail 01a0 __lll_lock_wait_private 01a8 __aeabi_read_tp 01d0 __new_exitfn_called"
	strings:
		$1 = { F8 40 2D E9 01 10 A0 E3 00 50 A0 E1 B8 21 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 56 00 00 1A 00 40 95 E5 00 00 54 E3 4E 00 00 0A 00 00 A0 E3 00 E0 A0 E1 04 C0 A0 E1 04 20 9C E5 00 00 52 E3 0F 00 00 0A 01 30 42 E2 03 12 8C E0 08 10 91 E5 00 00 51 E3 11 00 00 1A 02 22 8C E0 08 20 82 E2 05 00 00 EA 10 20 42 E2 10 10 12 E5 00 00 51 E3 01 10 43 E2 0A 00 00 1A 01 30 A0 E1 00 00 53 E3 F7 FF FF 1A 00 30 9C E5 00 00 53 E3 0C 00 A0 E1 04 E0 8C E5 26 00 00 0A 03 C0 A0 E1 E5 FF FF EA 02 30 A0 E1 20 00 53 E3 03 52 8C 10 01 30 83 12 08 50 85 12 04 30 8C 15 1B 00 00 0A EC 10 9F E5 0C 00 91 E8 01 20 92 E2 01 00 A0 E3 00 30 A3 E2 00 00 85 E5 0C 00 81 E8 CC 70 9F E5 00 60 97 E5 00 10 A0 E3 06 40 A0 E1 BC 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 19 00 00 CA 05 00 A0 E1 F8 40 BD E8 ?? ?? ?? ?? 00 00 50 E3 03 00 00 0A 01 30 A0 E3 04 30 80 E5 08 50 80 E2 DD FF FF EA 01 00 A0 E3 82 1F A0 E3 ?? ?? ?? ?? 00 00 50 E3 00 50 A0 01 DE FF FF 0A 00 40 80 E5 00 00 85 E5 F2 FF FF EA 44 00 9F E5 44 10 9F E5 64 20 A0 E3 40 30 9F E5 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? A5 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF DC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_151_1_0 {
	meta:
		name = "__internal_atexit"
		size = 80
		refs = "0014 __new_exitfn"
	strings:
		$1 = { 70 40 2D E9 00 40 A0 E1 03 00 A0 E1 01 60 A0 E1 02 50 A0 E1 ?? ?? ?? ?? 00 00 50 E3 09 00 00 0A 50 00 80 E9 0C 50 80 E5 0F CA E0 E3 0F E0 A0 E1 5F F0 4C E2 04 20 A0 E3 00 20 80 E5 00 00 A0 E3 70 40 BD E8 ?? ?? ?? ?? 00 00 E0 E3 FB FF FF EA }
	condition:
		$1
}

rule file_152_0_0 {
	meta:
		name = "__sched_getscheduler"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 9D 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_153_0_0 {
	meta:
		name = "putmsg"
		size = 40
		refs = "0008 __aeabi_read_tp 0024 __libc_errno"
		altNames = "__sigreturn _no_syscall fattach fdetach getmsg getpmsg lchmod putpmsg revoke setlogin sstk"
	strings:
		$1 = { 04 E0 2D E5 18 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 26 20 A0 E3 03 20 80 E7 04 E0 9D E4 00 00 E0 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "__wcscat_chk"
		size = 100
		refs = "0060 __chk_fail"
	strings:
		$1 = { 10 40 2D E9 01 20 42 E2 00 C0 A0 E1 01 00 00 EA 04 20 A0 E1 03 C0 A0 E1 01 00 72 E3 0F 00 00 0A 0C 30 A0 E1 04 40 93 E4 00 00 54 E3 01 40 42 E2 F6 FF FF 1A 04 C0 4C E2 02 00 00 EA 00 00 52 E3 01 20 42 E2 05 00 00 0A 04 30 91 E4 00 00 53 E3 04 30 AC E5 F8 FF FF 1A 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_155_0_0 {
	meta:
		name = "__readlinkat_chk"
		size = 32
		refs = "0010 readlinkat 001c __chk_fail"
	strings:
		$1 = { 08 40 2D E9 08 C0 9D E5 0C 00 53 E1 02 00 00 8A ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "_IO_wpadn"
		size = 220
	strings:
		$1 = { F0 40 2D E9 20 00 51 E3 44 D0 4D E2 00 60 A0 E1 02 40 A0 E1 2A 00 00 0A 30 00 51 E3 2A 00 00 0A 0D 20 A0 E1 40 30 8D E2 04 10 23 E5 02 00 53 E1 FC FF FF 1A 0D 70 A0 E1 00 50 A0 E3 0A 00 00 EA 98 C0 96 E5 06 00 A0 E1 07 10 A0 E1 10 20 A0 E3 1C C0 9C E5 0F E0 A0 E1 ?? ?? ?? ?? 10 00 50 E3 10 40 44 E2 00 50 85 E0 0F 00 00 1A 0F 00 54 E3 F2 FF FF CA 00 00 54 E3 07 00 00 DA 07 10 A0 E1 04 20 A0 E1 98 30 96 E5 06 00 A0 E1 1C C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 50 85 E0 05 00 A0 E1 44 D0 8D E2 F0 40 BD E8 ?? ?? ?? ?? 01 00 70 E3 05 00 A0 11 00 00 E0 03 44 D0 8D E2 F0 40 BD E8 ?? ?? ?? ?? 08 70 9F E5 DA FF FF EA 04 70 9F E5 D8 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_157_0_0 {
	meta:
		name = "mkostemps"
		size = 60
		refs = "0010 __gen_tempname 0020 __aeabi_read_tp 0038 __libc_errno"
	strings:
		$1 = { 00 00 51 E3 08 40 2D E9 03 00 00 BA 00 30 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? 14 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 00 00 E0 E3 F6 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_158_0_0 {
	meta:
		name = "fgets_unlocked"
		size = 196
		refs = "0054 _IO_getline 0090 __aeabi_read_tp 00c0 __libc_errno"
	strings:
		$1 = { 70 40 2D E9 00 00 51 E3 08 D0 4D E2 00 50 A0 E1 02 40 A0 E1 27 00 00 DA 01 00 51 E3 00 30 A0 03 00 30 C0 05 00 00 A0 01 11 00 00 0A 00 C0 92 E5 01 30 A0 E3 20 00 CC E3 01 20 41 E2 00 00 84 E5 05 10 A0 E1 00 30 8D E5 04 00 A0 E1 0A 30 A0 E3 20 60 0C E2 ?? ?? ?? ?? 00 20 50 E2 07 00 00 1A 00 30 94 E5 02 50 A0 E1 06 30 83 E1 00 30 84 E5 05 00 A0 E1 08 D0 8D E2 70 40 BD E8 ?? ?? ?? ?? 00 30 94 E5 20 00 13 E3 06 00 00 0A 2C 10 9F E5 ?? ?? ?? ?? 01 10 9F E7 01 10 90 E7 0B 00 51 E3 00 50 A0 13 EF FF FF 1A 00 30 A0 E3 02 30 C5 E7 00 30 94 E5 EB FF FF EA 00 00 A0 E3 EC FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_159_0_0 {
	meta:
		name = "enlarge_userbuf.part.0"
		size = 480
		refs = "008c __wmemcpy 00c0 _IO_wsetb 013c wmemset 01d0 __assert_fail"
	strings:
		$1 = { F0 4F 2D E9 3C A0 90 E5 5C 80 90 E5 08 A0 1A E2 03 50 A0 E1 0C D0 4D E2 00 60 A0 E1 02 40 A0 E1 14 C0 98 E5 0C 30 98 E5 04 00 00 0A 01 A0 A0 E3 0A 00 A0 E1 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 64 B0 82 E2 0B B1 A0 E1 18 70 98 E5 0B 00 A0 E1 08 10 8D E8 A0 C0 96 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 90 50 E2 08 10 9D E8 EF FF FF 0A 00 00 57 E3 0C 00 00 0A 5C 20 96 E5 1C 10 82 E2 06 00 11 E8 01 20 42 E0 07 10 A0 E1 42 21 A0 E1 ?? ?? ?? ?? 07 00 A0 E1 A4 C0 96 E5 0F E0 A0 E1 ?? ?? ?? ?? 18 A0 88 E5 08 10 9D E8 0C C0 63 E0 0B 20 89 E0 01 30 A0 E3 06 00 A0 E1 09 10 A0 E1 4C B1 A0 E1 ?? ?? ?? ?? 30 30 9D E5 00 00 53 E3 1F 00 00 0A 00 30 98 E5 0C E0 98 E5 10 C0 98 E5 14 00 98 E5 0E E0 67 E0 0C C0 67 E0 00 00 67 E0 1C 10 98 E5 03 70 67 E0 0B 20 A0 E1 CB 3F A0 E1 0E E0 89 E0 0C C0 89 E0 00 00 89 E0 07 70 89 E0 02 00 54 E1 03 60 D5 E0 08 90 88 E5 0C E0 88 E5 10 C0 88 E5 14 00 88 E5 00 70 88 E5 04 10 88 E5 23 00 00 BA 0B 01 89 E0 04 20 6B E0 00 10 A0 E3 ?? ?? ?? ?? 0A 00 A0 E1 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 03 10 98 E8 10 20 98 E5 0C C0 67 E0 00 00 67 E0 01 10 67 E0 02 70 67 E0 07 20 89 E0 1C 30 98 E5 0B 60 A0 E1 CB 7F A0 E1 0C C0 89 E0 00 00 89 E0 01 10 89 E0 06 00 54 E1 07 E0 D5 E0 0C 90 88 E5 03 10 88 E8 10 20 88 E5 14 30 88 E5 07 00 00 BA 0B 01 89 E0 04 20 6B E0 30 10 9D E5 ?? ?? ?? ?? 0A 00 A0 E1 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 0C 00 9F E5 0C 10 9F E5 E6 20 A0 E3 08 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_159_1_0 {
	meta:
		name = "_IO_wstr_underflow"
		size = 84
	strings:
		$1 = { 5C 20 90 E5 04 40 2D E5 10 30 92 E5 04 10 92 E5 01 00 53 E1 04 30 82 85 00 C0 90 E5 03 4B 0C E2 03 10 A0 81 03 0B 54 E3 14 40 92 05 00 30 92 15 02 CB CC 03 00 C0 80 05 10 40 82 05 00 30 82 05 03 00 51 E1 00 00 93 85 00 00 E0 93 04 40 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_159_2_0 {
	meta:
		name = "_IO_wstr_overflow"
		size = 416
		refs = "00d8 __wmemcpy 0100 wmemset 0118 _IO_wsetb"
	strings:
		$1 = { F0 4F 2D E9 00 20 90 E5 01 00 71 E3 00 60 A0 13 01 60 A0 03 08 00 12 E3 01 60 26 12 00 40 A0 E1 0C D0 4D E2 01 50 A0 E1 00 00 66 12 16 00 00 1A 03 3B 02 E2 01 0B 53 E3 5C 30 94 E5 04 10 93 05 18 80 93 E5 1C 70 93 E5 02 2B 82 03 00 C0 93 05 10 C0 93 15 00 20 84 05 07 70 68 E0 00 10 83 05 0C 10 93 E5 47 71 A0 E1 10 C0 83 05 06 20 87 E0 0C C0 61 E0 4C 01 52 E1 3B 00 00 8A 3C 30 94 E5 08 90 13 E2 03 00 00 0A 00 00 E0 E3 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 32 30 87 E2 83 B0 A0 E1 0B 00 57 E1 F7 FF FF 8A 83 31 A0 E1 03 00 A0 E1 04 30 8D E5 A0 C0 94 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 A0 50 E2 EF FF FF 0A 00 00 58 E3 08 00 00 0A 08 10 A0 E1 07 20 A0 E1 ?? ?? ?? ?? 08 00 A0 E1 A4 C0 94 E5 0F E0 A0 E1 ?? ?? ?? ?? 5C 30 94 E5 18 90 83 E5 0B 20 67 E0 00 10 A0 E3 07 01 8A E0 ?? ?? ?? ?? 04 30 9D E5 04 00 A0 E1 03 20 8A E0 0A 10 A0 E1 01 30 A0 E3 ?? ?? ?? ?? 5C 30 94 E5 08 40 93 E5 00 C0 93 E5 04 00 93 E5 10 10 93 E5 04 40 68 E0 0C C0 68 E0 00 00 68 E0 01 10 68 E0 1C 20 93 E5 04 40 8A E0 0C C0 8A E0 00 00 8A E0 01 10 8A E0 0C A0 83 E5 08 40 83 E5 00 C0 83 E5 04 00 83 E5 10 10 83 E5 14 20 83 E5 00 00 56 E3 10 10 93 05 04 20 81 02 10 20 93 15 10 20 83 05 00 50 81 05 04 10 93 E5 05 00 A0 E1 02 00 51 E1 04 20 83 35 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_159_3_0 {
	meta:
		name = "_IO_wstr_pbackfail"
		size = 48
		refs = "0024 _IO_wdefault_pbackfail"
	strings:
		$1 = { 08 40 2D E9 00 30 90 E5 08 00 13 E3 04 00 00 0A 01 00 71 E3 00 00 E0 13 01 00 00 0A 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_159_4_0 {
	meta:
		name = "_IO_wstr_finish"
		size = 76
		refs = "0040 _IO_wdefault_finish"
	strings:
		$1 = { 5C 30 90 E5 10 40 2D E9 00 40 A0 E1 18 00 93 E5 00 00 50 E3 06 00 00 0A 3C 20 94 E5 08 00 12 E3 03 00 00 1A A4 C0 94 E5 0F E0 A0 E1 ?? ?? ?? ?? 5C 30 94 E5 00 10 A0 E3 04 00 A0 E1 18 10 83 E5 ?? ?? ?? ?? 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_159_5_0 {
	meta:
		name = "_IO_wstr_seekoff"
		size = 620
	strings:
		$1 = { F0 41 2D E9 08 D0 4D E2 24 70 9D E5 00 00 57 E3 00 60 A0 E1 02 40 A0 E1 03 50 A0 E1 25 00 00 1A 00 30 90 E5 01 0B 13 E3 58 00 00 0A 02 0B 13 E3 34 00 00 0A 5C 30 90 E5 04 80 93 E5 10 10 93 E5 08 20 93 E5 01 00 58 E1 08 80 62 20 01 80 62 30 48 81 A0 E1 20 20 9D E5 01 00 52 E3 65 00 00 0A 02 00 52 E3 01 00 00 1A 08 40 94 E0 C8 5F A5 E0 00 00 54 E3 00 20 D5 E2 78 00 00 BA 04 00 58 E1 04 00 00 AA 20 10 86 E2 06 00 11 E8 01 20 42 E0 04 00 52 E1 68 00 00 BA 0C 20 93 E5 04 00 A0 E1 04 21 82 E0 05 10 A0 E1 10 20 83 E5 08 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 5C 30 90 E5 08 20 93 E5 10 80 93 E5 04 10 93 E5 01 00 58 E1 08 80 62 20 01 80 62 30 01 00 17 E3 48 81 A0 E1 12 00 00 1A 00 C0 E0 E3 02 70 07 E2 0C 20 A0 E1 00 00 57 E3 0C 00 A0 01 02 10 A0 01 D5 FF FF 1A 08 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 5C 30 90 E5 08 20 93 E5 04 80 93 E5 10 10 93 E5 01 00 58 E1 08 80 62 20 01 80 62 30 48 81 A0 E1 01 70 A0 E3 20 10 9D E5 01 00 51 E3 29 00 00 0A 02 00 51 E3 01 00 00 1A 08 40 94 E0 C8 5F A5 E0 00 00 54 E3 00 20 D5 E2 42 00 00 BA 04 00 58 E1 04 00 00 AA 20 10 86 E2 06 00 11 E8 01 20 42 E0 04 00 52 E1 28 00 00 BA 08 20 93 E5 04 11 82 E0 08 21 82 E0 06 00 83 E8 02 70 07 E2 04 C0 A0 E1 05 20 A0 E1 D6 FF FF EA 08 00 13 E3 08 00 00 0A 5C 30 96 E5 00 00 93 E5 08 30 93 E5 00 00 63 E0 40 01 A0 E1 C0 1F A0 E1 08 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 5C 30 96 E5 10 10 83 E2 03 00 11 E8 00 00 41 E0 40 01 A0 E1 C0 1F A0 E1 08 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 00 10 93 E5 01 20 62 E0 42 21 A0 E1 02 40 94 E0 C2 5F A5 E0 D3 FF FF EA 10 10 83 E2 06 00 11 E8 01 20 42 E0 42 21 A0 E1 02 40 94 E0 C2 5F A5 E0 96 FF FF EA 01 30 A0 E3 00 30 8D E5 06 00 A0 E1 04 20 A0 E1 05 30 A0 E1 FC FE FF EB 00 00 50 E3 0A 00 00 1A 5C 30 96 E5 CC FF FF EA 00 30 A0 E3 00 30 8D E5 06 00 A0 E1 04 20 A0 E1 05 30 A0 E1 F2 FE FF EB 00 00 50 E3 5C 30 96 05 8D FF FF 0A 00 00 E0 E3 00 10 E0 E3 A3 FF FF EA }
	condition:
		$1
}

rule file_159_6_0 {
	meta:
		name = "_IO_wstr_init_static"
		size = 140
		refs = "001c __wcslen 0034 _IO_wsetb"
	strings:
		$1 = { 00 00 52 E3 F8 40 2D E9 00 50 A0 E1 01 40 A0 E1 03 60 A0 E1 16 00 00 1A 01 00 A0 E1 ?? ?? ?? ?? 00 71 84 E0 04 10 A0 E1 05 00 A0 E1 07 20 A0 E1 00 30 A0 E3 ?? ?? ?? ?? 5C 10 95 E5 00 00 56 E3 00 30 A0 E3 0C 40 81 E5 08 40 81 E5 00 40 81 E5 10 60 81 15 14 70 81 15 04 60 81 15 10 40 81 05 14 40 81 05 04 70 81 05 A0 30 85 E5 F8 40 BD E8 ?? ?? ?? ?? 02 71 81 E0 07 00 51 E1 01 70 E0 21 03 70 C7 23 07 70 81 20 E5 FF FF EA }
	condition:
		$1
}

rule file_159_7_0 {
	meta:
		name = "_IO_wstr_count"
		size = 32
	strings:
		$1 = { 5C 30 90 E5 10 00 93 E5 0C 00 93 E9 02 00 50 E1 00 00 63 20 02 00 63 30 40 01 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_160_0_0 {
	meta:
		name = "_IO_ungetc"
		size = 472
		refs = "0024 __aeabi_read_tp 0090 _IO_sputbackc 013c __lll_lock_wait_private 01d4 _Unwind_Resume"
	strings:
		$1 = { 01 00 70 E3 F8 43 2D E9 00 70 A0 E1 01 50 A0 E1 24 00 00 0A 00 40 91 E5 02 49 14 E2 19 00 00 1A 48 60 91 E5 ?? ?? ?? ?? 08 30 96 E5 13 8D 40 E2 08 00 53 E1 00 90 A0 E1 0F 00 00 0A 01 10 A0 E3 06 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 31 00 00 1A 48 30 95 E5 08 80 83 E5 03 60 A0 E1 04 30 96 E5 01 30 83 E2 04 30 86 E5 FF 10 07 E2 05 00 A0 E1 ?? ?? ?? ?? 00 30 95 E5 02 09 13 E3 00 60 A0 E1 02 00 00 0A 06 00 A0 E1 F8 43 BD E8 ?? ?? ?? ?? 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 F6 FF FF 1A 08 30 85 E5 00 70 95 E5 00 10 A0 E3 07 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 57 E1 F0 FF FF 1A 01 00 57 E3 E4 FF FF DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 06 00 A0 E1 DB FF FF EA 06 00 A0 E1 ?? ?? ?? ?? CA FF FF EA 00 30 95 E5 02 09 13 E3 00 80 A0 E1 1E 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 18 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 06 00 00 DA B8 14 19 E5 05 00 A0 E1 01 10 81 E3 01 20 A0 E3 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 08 00 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "__dladdr1"
		size = 76
		refs = "001c _dl_addr"
	strings:
		$1 = { 01 00 53 E3 08 40 2D E9 0A 00 00 0A 02 00 53 E3 04 00 00 0A 00 20 A0 E3 02 30 A0 E1 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? 00 30 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? 02 30 A0 E1 00 20 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "__fxprintf"
		size = 244
		refs = "0038 strlen 009c __vfwprintf 00bc _IO_vfprintf 00e0 __assert_fail 00e4 stderr"
	strings:
		$1 = { 0E 00 2D E9 E0 48 2D E9 00 60 50 E2 10 B0 8D E2 CC 30 9F 05 08 D0 4D E2 00 60 93 05 6C 30 96 E5 08 20 8B E2 00 00 53 E3 04 50 9B E5 14 20 0B E5 1F 00 00 DA 05 00 A0 E1 ?? ?? ?? ?? 01 00 80 E2 00 31 A0 E1 0A 30 83 E2 07 30 C3 E3 0D 70 A0 E1 00 00 50 E3 03 D0 4D E0 0D 10 A0 E1 0C 00 00 0A 00 30 D5 E5 7F 20 D3 E3 05 E0 A0 01 04 C0 4D 02 03 00 00 0A 15 00 00 EA 01 30 FE E5 80 00 13 E3 12 00 00 1A 01 20 82 E2 02 00 50 E1 04 30 AC E5 F8 FF FF 1A 06 00 A0 E1 14 20 1B E5 ?? ?? ?? ?? 07 D0 A0 E1 10 D0 4B E2 E0 48 BD E8 0C D0 8D E2 ?? ?? ?? ?? 06 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 10 D0 4B E2 E0 48 BD E8 0C D0 8D E2 ?? ?? ?? ?? 10 00 9F E5 10 10 9F E5 2E 20 A0 E3 0C 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_163_0_0 {
	meta:
		name = "__vdprintf_chk"
		size = 216
		refs = "0038 _IO_no_init 0048 _IO_file_init 0054 _IO_file_attach 0090 _IO_vfprintf 00c4 _IO_un_link 00d0 _IO_wfile_jumps 00d4 _IO_file_jumps"
	strings:
		$1 = { F0 40 2D E9 C4 E0 9F E5 5B DF 4D E2 00 C0 A0 E3 00 E0 8D E5 00 40 A0 E1 01 70 A0 E1 08 00 8D E2 02 19 A0 E3 02 60 A0 E1 03 50 A0 E1 0C 20 A0 E1 AC 30 8D E2 50 C0 8D E5 ?? ?? ?? ?? 90 C0 9F E5 08 00 8D E2 A0 C0 8D E5 ?? ?? ?? ?? 08 00 8D E2 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 17 00 00 0A 08 30 9D E5 01 3A C3 E3 0C 30 C3 E3 44 30 83 E3 00 00 57 E3 08 30 8D E5 44 30 9D C5 06 10 A0 E1 04 30 83 C3 05 20 A0 E1 08 00 8D E2 44 30 8D C5 ?? ?? ?? ?? A0 30 9D E5 00 40 A0 E1 00 10 A0 E3 08 00 8D E2 08 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 5B DF 8D E2 F0 40 BD E8 ?? ?? ?? ?? 08 00 8D E2 ?? ?? ?? ?? 00 00 E0 E3 F8 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_164_0_0 {
	meta:
		name = "__tcgetattr"
		size = 228
		refs = "006c mempcpy 00c8 __aeabi_read_tp 00e0 __libc_errno"
	strings:
		$1 = { B0 40 2D E9 28 D0 4D E2 01 30 A0 E1 04 20 8D E2 C0 10 9F E5 36 70 A0 E3 00 00 00 EF 01 0A 70 E3 00 40 A0 E1 24 00 00 8A 00 00 50 E3 1E 00 00 1A 0C 10 9D E5 A0 20 9F E5 14 00 DD E5 20 40 9D E9 10 C0 9D E5 02 20 01 E0 08 10 83 E5 34 20 83 E5 38 20 83 E5 10 00 C3 E5 20 40 83 E8 0C C0 83 E5 11 00 83 E2 15 10 8D E2 13 20 A0 E3 ?? ?? ?? ?? 00 30 A0 E1 01 40 C3 E4 01 30 83 E2 01 40 C0 E5 01 40 C3 E4 01 40 C3 E4 01 40 C3 E4 01 40 C3 E4 01 40 C3 E4 01 40 C3 E4 01 40 C3 E4 01 40 C3 E4 01 40 C3 E4 01 40 C3 E4 00 40 C3 E5 04 00 A0 E1 28 D0 8D E2 B0 40 BD E8 ?? ?? ?? ?? 1C 30 9F E5 00 40 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 40 80 E7 00 40 E0 E3 F4 FF FF EA 01 54 00 00 0F 10 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_165_0_0 {
	meta:
		name = "ptrace"
		size = 164
		refs = "005c __aeabi_read_tp 009c __libc_errno"
	strings:
		$1 = { 0F 00 2D E9 80 40 2D E9 08 D0 4D E2 10 00 9D E5 01 C0 40 E2 14 30 8D E2 02 00 5C E3 14 10 8D E2 04 30 8D E5 1A 70 A0 E3 0E 00 91 E8 0D 30 A0 91 00 00 00 EF 01 0A 70 E3 10 00 00 8A 02 00 5C E3 00 C0 A0 83 01 C0 A0 93 00 00 50 E3 00 C0 A0 B3 00 00 5C E3 05 00 00 0A 3C 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 00 20 A0 E3 03 20 80 E7 00 00 9D E5 08 D0 8D E2 80 40 BD E8 10 D0 8D E2 ?? ?? ?? ?? 18 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 F4 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_166_0_0 {
	meta:
		name = "__inet_aton"
		size = 392
		refs = "0018 __aeabi_read_tp 0060 strtoul 016c __libc_errno 0184 __libc_tsd_CTYPE_B"
	strings:
		$1 = { F0 47 2D E9 60 21 9F E5 60 31 9F E5 02 20 9F E7 03 30 9F E7 00 A0 A0 E1 ?? ?? ?? ?? 00 C0 A0 E3 02 60 90 E7 03 C0 80 E7 00 30 DA E5 30 30 43 E2 08 D0 4D E2 09 00 53 E3 01 90 A0 E1 00 C0 8D E5 18 00 00 8A 28 81 9F E5 0D 70 A0 E1 0D 40 A0 E1 03 50 8D E2 0A 00 A0 E1 04 10 8D E2 00 20 A0 E3 ?? ?? ?? ?? 01 00 70 E3 00 30 A0 E1 15 00 00 0A 04 20 9D E5 00 10 D2 E5 2E 00 51 E3 17 00 00 1A 05 00 54 E1 07 00 00 0A FF 00 53 E3 05 00 00 8A 01 30 C4 E4 01 30 D2 E5 30 30 43 E2 09 00 53 E3 01 A0 82 E2 EA FF FF 9A C8 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 60 80 E7 00 00 A0 E3 08 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 08 20 9F E7 02 20 90 E7 22 00 52 E3 E4 FF FF 1A F1 FF FF EA 00 00 51 E3 15 00 00 1A 0A 00 52 E1 ED FF FF 0A 84 20 9F E5 04 40 67 E0 04 21 92 E7 03 00 52 E1 E8 FF FF 3A 00 00 59 E3 06 00 00 0A 63 28 23 E0 22 24 A0 E1 FF 2C C2 E3 00 10 9D E5 63 34 22 E0 01 30 83 E1 00 30 89 E5 50 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 60 80 E7 01 00 A0 E3 DE FF FF EA 80 00 11 E3 D7 FF FF 1A 34 50 9F E5 ?? ?? ?? ?? 05 50 9F E7 05 00 90 E7 81 10 A0 E1 B1 10 90 E1 02 0A 11 E3 CF FF FF 0A DE FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_166_1_0 {
	meta:
		name = "inet_addr"
		size = 40
		refs = "000c __inet_aton"
	strings:
		$1 = { 04 E0 2D E5 0C D0 4D E2 04 10 8D E2 ?? ?? ?? ?? 00 00 50 E3 04 00 9D 15 00 00 E0 03 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_167_1_0 {
	meta:
		name = "svcunix_getargs"
		size = 36
		altNames = "svctcp_getargs"
	strings:
		$1 = { 08 40 2D E9 2C 00 90 E5 01 30 A0 E1 08 00 80 E2 02 10 A0 E1 0F E0 A0 E1 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_167_2_0 {
	meta:
		name = "svcunix_freeargs"
		size = 40
		altNames = "svctcp_freeargs"
	strings:
		$1 = { 08 40 2D E9 2C 00 90 E5 02 30 A0 E3 08 30 A0 E5 01 30 A0 E1 02 10 A0 E1 0F E0 A0 E1 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_167_3_0 {
	meta:
		name = "svcunix_destroy"
		size = 92
		refs = "000c xprt_unregister 0014 __close 0048 free"
		altNames = "svctcp_destroy"
	strings:
		$1 = { 38 40 2D E9 00 40 A0 E1 2C 50 90 E5 ?? ?? ?? ?? 00 00 94 E5 ?? ?? ?? ?? B4 30 D4 E1 00 00 53 E3 00 30 A0 13 B4 30 C4 11 05 00 00 1A 0C 30 95 E5 1C 30 93 E5 00 00 53 E3 08 00 85 12 0F E0 A0 11 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 38 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_167_5_0 {
	meta:
		name = "makefd_xprt"
		size = 260
		refs = "0018 malloc 0064 xdrrec_create 0090 xprt_register 00b0 __dcgettext 00c4 __fxprintf 00cc free 00e8 readunix 00ec writeunix 00f8 _libc_intl_domainname"
	strings:
		$1 = { F0 43 2D E9 00 70 A0 E1 0C D0 4D E2 4D 0F A0 E3 01 90 A0 E1 02 80 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 1B 0E A0 E3 ?? ?? ?? ?? 00 00 54 E3 00 00 50 13 00 50 A0 E1 00 60 A0 13 01 60 A0 03 18 00 00 0A A0 E0 9F E5 A0 C0 9F E5 02 20 A0 E3 08 20 80 E4 09 10 A0 E1 08 20 A0 E1 00 E0 8D E5 04 C0 8D E5 04 30 A0 E1 ?? ?? ?? ?? 80 30 9F E5 20 20 85 E2 04 00 A0 E1 30 60 84 E5 2C 50 84 E5 24 20 84 E5 0C 60 84 E5 B4 60 C4 E1 00 70 84 E5 08 30 84 E5 ?? ?? ?? ?? 04 00 A0 E1 0C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 48 10 9F E5 05 20 A0 E3 44 00 9F E5 ?? ?? ?? ?? 40 10 9F E5 00 30 A0 E1 3C 20 9F E5 00 00 A0 E3 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? 00 00 A0 E3 0C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_836_5_0 {
	meta:
		name = "makefd_xprt"
		size = 260
		refs = "0018 malloc 0064 xdrrec_create 0090 xprt_register 00b0 __dcgettext 00c4 __fxprintf 00cc free 00e8 readtcp 00ec writetcp 00f8 _libc_intl_domainname"
	strings:
		$1 = { F0 43 2D E9 00 70 A0 E1 0C D0 4D E2 4D 0F A0 E3 01 90 A0 E1 02 80 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 1B 0E A0 E3 ?? ?? ?? ?? 00 00 54 E3 00 00 50 13 00 50 A0 E1 00 60 A0 13 01 60 A0 03 18 00 00 0A A0 E0 9F E5 A0 C0 9F E5 02 20 A0 E3 08 20 80 E4 09 10 A0 E1 08 20 A0 E1 00 E0 8D E5 04 C0 8D E5 04 30 A0 E1 ?? ?? ?? ?? 80 30 9F E5 20 20 85 E2 04 00 A0 E1 30 60 84 E5 2C 50 84 E5 24 20 84 E5 0C 60 84 E5 B4 60 C4 E1 00 70 84 E5 08 30 84 E5 ?? ?? ?? ?? 04 00 A0 E1 0C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 48 10 9F E5 05 20 A0 E3 44 00 9F E5 ?? ?? ?? ?? 40 10 9F E5 00 30 A0 E1 3C 20 9F E5 00 00 A0 E3 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? 00 00 A0 E3 0C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_167_6_0 {
	meta:
		name = "readunix"
		size = 332
		refs = "0034 __poll 00b0 __setsockopt 00c4 __aeabi_read_tp 00e4 __recvmsg 013c __libc_errno"
	strings:
		$1 = { F0 47 2D E9 00 40 90 E5 2C 71 9F E5 38 D0 4D E2 00 60 A0 E1 01 90 A0 E1 02 80 A0 E1 01 50 A0 E3 0C 00 8D E2 01 10 A0 E3 10 21 9F E5 0C 40 8D E5 B0 51 CD E1 ?? ?? ?? ?? 01 00 70 E3 37 00 00 0A 00 00 50 E3 2E 00 00 0A B2 31 DD E1 38 00 13 E3 2B 00 00 1A 01 00 13 E3 F0 FF FF 0A 01 E0 A0 E3 38 30 8D E2 04 20 A0 E3 D4 A0 9F E5 00 C0 A0 E3 30 E0 23 E5 0E 10 A0 E1 00 20 8D E5 14 70 8D E2 1C 50 A0 E3 04 00 A0 E1 10 20 A0 E3 14 90 8D E5 18 80 8D E5 28 E0 8D E5 2C A0 8D E5 24 70 8D E5 1C C0 8D E5 20 C0 8D E5 34 C0 8D E5 30 50 8D E5 ?? ?? ?? ?? 00 00 50 E3 11 00 00 1A 84 50 9F E5 04 00 00 EA ?? ?? ?? ?? 05 30 9F E7 03 30 90 E7 04 00 53 E3 0A 00 00 1A 04 00 A0 E1 1C 10 8D E2 00 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 F4 FF FF BA 34 30 9D E5 08 00 13 E3 01 00 00 1A 00 00 50 E3 03 00 00 1A 2C 30 96 E5 00 20 A0 E3 00 20 83 E5 00 00 E0 E3 38 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 07 30 9F E7 03 30 90 E7 04 00 53 E3 F3 FF FF 1A B2 31 DD E1 C5 FF FF EA ?? ?? ?? ?? B8 88 00 00 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_167_7_0 {
	meta:
		name = "writeunix"
		size = 276
		refs = "003c __getpid 0044 __geteuid 004c __getegid 00a0 __aeabi_read_tp 00c0 __sendmsg 0110 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 00 00 52 E3 3C D0 4D E2 0C 20 8D E5 08 00 8D E5 01 90 A0 E1 2F 00 00 DA E8 60 9F E5 E8 50 9F E5 02 80 A0 E1 01 B0 A0 E3 18 A0 A0 E3 00 70 A0 E3 08 30 9D E5 00 40 93 E5 ?? ?? ?? ?? 00 00 8D E5 ?? ?? ?? ?? 04 00 8D E5 ?? ?? ?? ?? 00 20 9D E5 04 30 9D E5 0C 20 86 E5 10 30 86 E5 02 20 A0 E3 14 30 8D E2 14 00 86 E5 04 B0 86 E5 08 20 86 E5 00 A0 86 E5 14 90 8D E5 18 80 8D E5 24 30 8D E5 28 B0 8D E5 1C 70 8D E5 20 70 8D E5 2C 60 8D E5 30 A0 8D E5 34 70 8D E5 04 00 00 EA ?? ?? ?? ?? 05 30 9F E7 03 30 90 E7 04 00 53 E3 0D 00 00 1A 04 00 A0 E1 1C 10 8D E2 00 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 F4 FF FF BA 08 80 60 E0 00 00 58 E3 00 90 89 E0 D5 FF FF CA 0C 00 9D E5 3C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 08 20 9D E5 2C 30 92 E5 00 00 E0 E3 00 20 A0 E3 00 20 83 E5 3C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_167_8_0 {
	meta:
		name = "rendezvous_request"
		size = 180
		refs = "001c __aeabi_read_tp 0040 accept 0080 memcpy 009c __svc_accept_failed 00b0 __libc_errno"
	strings:
		$1 = { F0 40 2D E9 00 40 A0 E1 8C D0 4D E2 2C 70 90 E5 98 60 9F E5 6E 50 A0 E3 04 00 00 EA ?? ?? ?? ?? 06 30 9F E7 03 30 90 E7 04 00 53 E3 1A 00 00 1A 00 00 94 E5 18 10 8D E2 04 20 8D E2 04 50 8D E5 ?? ?? ?? ?? 00 00 50 E3 F3 FF FF BA 00 30 A0 E3 01 C0 A0 E3 06 00 97 E8 08 30 8D E5 0C 30 8D E5 10 30 8D E5 14 30 8D E5 B8 C0 CD E1 A2 FF FF EB 08 10 8D E2 00 40 A0 E1 10 20 A0 E3 10 00 80 E2 ?? ?? ?? ?? 04 30 9D E5 00 00 A0 E3 0C 30 84 E5 8C D0 8D E2 F0 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 A0 E3 8C D0 8D E2 F0 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_167_9_0 {
	meta:
		name = "svcunix_reply"
		size = 64
		refs = "0020 xdr_replymsg 0030 xdrrec_endofrecord"
		altNames = "svctcp_reply"
	strings:
		$1 = { 38 40 2D E9 2C 30 90 E5 04 20 93 E5 08 40 83 E2 00 00 A0 E3 08 00 83 E5 00 20 81 E5 04 00 A0 E1 ?? ?? ?? ?? 01 10 A0 E3 00 50 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 05 00 A0 E1 38 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_167_10_0 {
	meta:
		name = "svcunix_stat"
		size = 48
		refs = "0018 xdrrec_eof"
		altNames = "svctcp_stat"
	strings:
		$1 = { 08 40 2D E9 2C 30 90 E5 00 00 93 E5 00 00 50 E3 04 00 00 0A 08 00 83 E2 ?? ?? ?? ?? 00 00 50 E3 02 00 A0 13 01 00 A0 03 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_167_11_0 {
	meta:
		name = "svcunix_recv"
		size = 96
		refs = "001c xdrrec_skiprecord 0028 xdr_callmsg"
	strings:
		$1 = { F8 40 2D E9 2C 40 90 E5 01 70 A0 E3 08 60 84 E2 01 50 A0 E1 06 00 A0 E1 08 70 84 E5 ?? ?? ?? ?? 05 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 10 95 15 20 20 9F 15 1C 30 A0 13 04 10 84 15 24 70 85 15 28 20 85 15 2C 30 85 15 07 00 A0 11 00 00 84 05 F8 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_167_12_0 {
	meta:
		name = "svcunix_create"
		size = 496
		refs = "0038 memset 0048 strlen 005c memcpy 0074 __bind 0084 __getsockname 009c __dcgettext 00a0 perror 00c4 __listen 00d4 malloc 0134 xprt_register 0154 __socket 0180 __close 01b4 __fxprintf 01bc free 01d4 _libc_intl_domainname 01d8 _null_auth"
	strings:
		$1 = { F0 43 2D E9 01 00 70 E3 7C D0 4D E2 00 40 A0 E1 10 00 A0 E3 01 90 A0 E1 02 80 A0 E1 03 50 A0 E1 04 00 8D E5 00 70 A0 13 46 00 00 0A 00 10 A0 E3 6E 20 A0 E3 08 00 8D E2 ?? ?? ?? ?? 01 30 A0 E3 05 00 A0 E1 B8 30 CD E1 ?? ?? ?? ?? 05 10 A0 E1 01 20 80 E2 00 60 A0 E1 0A 00 8D E2 ?? ?? ?? ?? 78 50 8D E2 03 20 86 E2 74 20 25 E5 08 10 8D E2 04 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 08 10 8D E2 05 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0A 00 00 0A 38 11 9F E5 05 20 A0 E3 34 01 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 57 E3 33 00 00 1A 00 00 A0 E3 7C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 04 00 A0 E1 80 10 A0 E3 ?? ?? ?? ?? 00 60 50 E2 EF FF FF 1A 08 00 A0 E3 ?? ?? ?? ?? 00 50 A0 E1 4D 0F A0 E3 ?? ?? ?? ?? 00 00 55 E3 00 00 50 13 00 70 A0 E1 00 C0 A0 13 01 C0 A0 03 25 00 00 0A D4 30 9F E5 D4 60 9F E5 07 00 93 E8 00 E0 E0 E3 20 30 87 E2 30 C0 87 E5 2C 50 87 E5 00 90 85 E5 07 00 83 E8 04 80 85 E5 07 00 A0 E1 00 40 87 E5 08 60 87 E5 B4 E0 C7 E1 ?? ?? ?? ?? 07 00 A0 E1 7C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 01 00 A0 E3 00 10 A0 E1 00 20 A0 E3 ?? ?? ?? ?? 00 40 50 E2 01 70 A0 A3 B1 FF FF AA 74 10 9F E5 05 20 A0 E3 60 00 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? CB FF FF EA 04 00 A0 E1 ?? ?? ?? ?? 00 00 A0 E3 7C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 48 10 9F E5 05 20 A0 E3 30 00 9F E5 ?? ?? ?? ?? 3C 10 9F E5 00 30 A0 E1 38 20 9F E5 06 00 A0 E1 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? 07 00 A0 E1 ?? ?? ?? ?? 06 00 A0 E1 B7 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_168_0_0 {
	meta:
		name = "strerror"
		size = 168
		refs = "0010 __strerror_r 0030 __aeabi_read_tp 0074 malloc 008c __dcgettext 0098 __libc_errno 00a4 _libc_intl_domainname"
	strings:
		$1 = { 00 10 A0 E3 70 40 2D E9 01 20 A0 E1 00 40 A0 E1 ?? ?? ?? ?? 00 00 50 E3 01 00 00 0A 70 40 BD E8 ?? ?? ?? ?? 68 50 9F E5 68 30 9F E5 00 20 95 E5 ?? ?? ?? ?? 03 30 9F E7 00 00 52 E3 03 60 90 E7 0A 00 00 0A 00 10 95 E5 4C 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 00 00 51 E3 03 60 80 E7 07 00 00 0A 04 00 A0 E1 01 2B A0 E3 ?? ?? ?? ?? EA FF FF EA 01 0B A0 E3 ?? ?? ?? ?? 00 00 85 E5 F0 FF FF EA 18 10 9F E5 05 20 A0 E3 14 00 9F E5 ?? ?? ?? ?? E1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_0_0 {
	meta:
		name = "__syscall_error"
		size = 52
		refs = "0030 errno"
	strings:
		$1 = { 00 00 60 E2 00 10 A0 E1 0E 20 A0 E1 0F 0A E0 E3 0F E0 A0 E1 1F F0 40 E2 02 E0 A0 E1 0C 20 9F E5 02 20 9F E7 02 10 80 E7 00 00 E0 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_171_0_0 {
	meta:
		name = "__chown"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 D4 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "___fprintf_chk"
		size = 544
		refs = "0028 __aeabi_read_tp 00ac vfprintf 0174 __lll_lock_wait_private 021c _Unwind_Resume"
	strings:
		$1 = { 0C 00 2D E9 F0 43 2D E9 00 40 90 E5 0C D0 4D E2 02 49 14 E2 00 50 A0 E1 01 70 A0 E1 28 80 9D E5 18 00 00 1A 48 60 90 E5 ?? ?? ?? ?? 08 30 96 E5 13 9D 40 E2 09 00 53 E1 0F 00 00 0A 01 10 A0 E3 06 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 3F 00 00 1A 48 30 95 E5 08 90 83 E5 03 60 A0 E1 04 30 96 E5 01 30 83 E2 04 30 86 E5 00 00 57 E3 3C 30 95 C5 04 30 83 C3 3C 30 85 C5 2C 30 8D E2 08 10 A0 E1 03 20 A0 E1 05 00 A0 E1 04 30 8D E5 ?? ?? ?? ?? 3C 30 95 E5 00 00 57 E3 00 20 95 E5 04 30 C3 C3 3C 30 85 C5 14 30 C3 E3 02 09 12 E3 00 60 A0 E1 3C 30 85 E5 17 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 11 00 00 1A 08 30 85 E5 00 70 95 E5 00 10 A0 E3 07 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 57 E1 F0 FF FF 1A 01 00 57 E3 04 00 00 CA 06 00 A0 E1 0C D0 8D E2 F0 43 BD E8 08 D0 8D E2 ?? ?? ?? ?? ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF F1 FF FF EA 06 00 A0 E1 ?? ?? ?? ?? BC FF FF EA 3C 30 95 E5 00 20 95 E5 14 30 C3 E3 02 09 12 E3 00 80 A0 E1 3C 30 85 E5 1F 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 19 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 07 00 00 DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 08 00 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_332_0_0 {
	meta:
		name = "__fwprintf_chk"
		size = 544
		refs = "0028 __aeabi_read_tp 00ac _IO_vfwprintf 0174 __lll_lock_wait_private 021c _Unwind_Resume"
	strings:
		$1 = { 0C 00 2D E9 F0 43 2D E9 00 40 90 E5 0C D0 4D E2 02 49 14 E2 00 50 A0 E1 01 70 A0 E1 28 80 9D E5 18 00 00 1A 48 60 90 E5 ?? ?? ?? ?? 08 30 96 E5 13 9D 40 E2 09 00 53 E1 0F 00 00 0A 01 10 A0 E3 06 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 3F 00 00 1A 48 30 95 E5 08 90 83 E5 03 60 A0 E1 04 30 96 E5 01 30 83 E2 04 30 86 E5 00 00 57 E3 3C 30 95 C5 04 30 83 C3 3C 30 85 C5 2C 30 8D E2 08 10 A0 E1 03 20 A0 E1 05 00 A0 E1 04 30 8D E5 ?? ?? ?? ?? 3C 30 95 E5 00 00 57 E3 00 20 95 E5 04 30 C3 C3 3C 30 85 C5 14 30 C3 E3 02 09 12 E3 00 60 A0 E1 3C 30 85 E5 17 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 11 00 00 1A 08 30 85 E5 00 70 95 E5 00 10 A0 E3 07 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 57 E1 F0 FF FF 1A 01 00 57 E3 04 00 00 CA 06 00 A0 E1 0C D0 8D E2 F0 43 BD E8 08 D0 8D E2 ?? ?? ?? ?? ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF F1 FF FF EA 06 00 A0 E1 ?? ?? ?? ?? BC FF FF EA 3C 30 95 E5 00 20 95 E5 14 30 C3 E3 02 09 12 E3 00 80 A0 E1 3C 30 85 E5 1F 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 19 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 07 00 00 DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 08 00 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_173_0_0 {
	meta:
		name = "gethostid"
		size = 424
		refs = "0070 __gethostname 00b4 __aeabi_read_tp 00fc __gethostbyname_r 0154 memcpy 019c __libc_errno"
	strings:
		$1 = { F0 49 2D E9 18 B0 8D E2 74 D0 4D E2 84 01 9F E5 02 18 A0 E3 00 20 A0 E3 05 70 A0 E3 00 00 00 EF 01 0A 70 E3 00 30 A0 E1 4D 00 00 8A 00 00 50 E3 0C 00 00 BA 80 10 4B E2 04 20 A0 E3 03 70 A0 E3 00 00 00 EF 01 0A 70 E3 00 20 A0 E1 4A 00 00 8A 03 00 A0 E1 06 70 A0 E3 00 00 00 EF 04 00 52 E3 80 00 1B 05 08 00 00 0A 60 00 4B E2 40 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 02 00 00 BA 60 30 5B E5 00 00 53 E3 03 00 00 1A 00 00 A0 E3 18 D0 4B E2 F0 49 BD E8 ?? ?? ?? ?? 01 5B 4D E2 08 D0 45 E2 01 4B A0 E3 84 70 4B E2 78 60 4B E2 E8 80 9F E5 0B 00 00 EA ?? ?? ?? ?? 08 30 9F E7 03 30 90 E7 22 00 53 E3 EF FF FF 1A 02 D0 4D E0 08 30 8D E2 01 20 83 E0 02 00 55 E1 04 10 81 00 03 50 A0 E1 01 40 A0 E1 74 10 4B E2 05 20 A0 E1 00 70 8D E5 04 60 8D E5 60 00 4B E2 04 30 A0 E1 ?? ?? ?? ?? 84 10 A0 E1 0F 10 81 E2 0F 10 C1 E3 00 00 50 E3 08 20 81 E2 02 00 00 1A 84 30 1B E5 00 00 53 E3 03 00 00 1A 78 30 1B E5 01 00 73 E3 E0 FF FF 0A D4 FF FF EA 1C 10 4B E2 0C 20 83 E2 60 00 21 E5 0C 00 92 E8 01 00 A0 E1 04 00 52 E3 04 20 A0 A3 00 10 93 E5 ?? ?? ?? ?? 7C 00 1B E5 60 08 A0 E1 C9 FF FF EA 34 20 9F E5 00 30 60 E2 02 20 9F E7 ?? ?? ?? ?? 02 30 80 E7 BA FF FF EA 20 10 9F E5 00 20 60 E2 01 10 9F E7 ?? ?? ?? ?? 01 20 80 E7 00 20 E0 E3 AD FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_174_0_0 {
	meta:
		name = "__atomic_writev_replacement"
		size = 392
		refs = "00c0 mempcpy 00d8 __write 00e4 free 00fc __aeabi_read_tp 012c __libc_alloca_cutoff 013c malloc 0170 _Unwind_Resume 0184 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 00 50 52 E2 20 B0 8D E2 0C D0 4D E2 00 70 A0 E1 01 60 A0 E1 40 00 00 DA 04 E0 91 E5 06 01 7E E3 00 C0 A0 93 0C 40 A0 91 01 20 A0 91 06 00 00 9A 2F 00 00 EA 08 20 82 E2 04 E0 92 E5 02 31 E0 E3 03 30 64 E0 0E 00 53 E1 29 00 00 3A 01 C0 8C E2 05 00 5C E1 0E 40 84 E0 F5 FF FF 1A 01 0A 54 E3 2F 00 00 8A 0E 30 84 E2 07 30 C3 E3 03 D0 4D E0 00 00 55 E3 00 30 A0 E3 28 D0 0B E5 2C 30 0B E5 10 00 00 DA 06 90 A0 E1 28 00 1B E5 04 80 A0 E1 00 A0 A0 E3 03 00 00 EA 01 A0 8A E2 05 00 5A E1 08 90 89 E2 07 00 00 0A 04 60 99 E5 06 00 58 E1 08 60 A0 31 06 20 A0 E1 00 10 99 E5 ?? ?? ?? ?? 06 80 58 E0 F3 FF FF 1A 07 00 A0 E1 28 10 1B E5 04 20 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 2C 00 1B E5 ?? ?? ?? ?? 04 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 84 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 00 40 E0 E3 03 20 80 E7 04 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 00 40 A0 E3 CF FF FF EA 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 CB FF FF 1A 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 28 00 0B E5 2C 00 0B 15 CD FF FF 1A 28 30 1B E5 00 40 E0 E3 2C 30 0B E5 DF FF FF EA 00 40 A0 E1 2C 00 1B E5 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 00 30 A0 E3 00 40 A0 E1 2C 30 0B E5 F7 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_174_1_0 {
	meta:
		name = "__libc_writev"
		size = 248
		refs = "004c __aeabi_read_tp 007c __libc_enable_asynccancel 00a8 __libc_disable_asynccancel 00e8 __libc_multiple_threads 00ec __libc_errno"
	strings:
		$1 = { F8 43 2D E9 DC 30 9F E5 00 30 93 E5 00 00 53 E3 00 80 A0 E1 01 60 A0 E1 02 50 A0 E1 16 00 00 1A 92 70 A0 E3 00 00 00 EF 01 0A 70 E3 1F 00 00 8A 00 40 A0 E1 00 00 54 E3 02 00 00 BA 04 00 A0 E1 F8 43 BD E8 ?? ?? ?? ?? 9C 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 16 00 53 E3 F6 FF FF 1A 08 00 55 E3 F4 FF FF DA 08 00 A0 E1 06 10 A0 E1 05 20 A0 E1 F8 43 BD E8 7E FF FF EA ?? ?? ?? ?? 92 70 A0 E3 00 90 A0 E1 06 10 A0 E1 08 00 A0 E1 05 20 A0 E1 00 00 00 EF 01 0A 70 E3 00 40 A0 E1 09 00 00 8A 09 00 A0 E1 ?? ?? ?? ?? E0 FF FF EA 38 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 D8 FF FF EA 20 30 9F E5 00 40 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 40 80 E7 00 40 E0 E3 EE FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_0_0 {
	meta:
		name = "fexecve"
		size = 232
		refs = "0038 __snprintf 0048 __execve 0050 __aeabi_read_tp 006c __xstat 00d4 __libc_errno"
	strings:
		$1 = { 30 40 2D E9 01 30 71 E2 00 30 A0 33 A0 3F 93 E1 7C D0 4D E2 01 40 A0 E1 02 50 A0 E1 22 00 00 1A 00 00 52 E3 20 00 00 0A 00 30 A0 E1 1B 10 A0 E3 98 20 9F E5 04 00 8D E2 ?? ?? ?? ?? 04 10 A0 E1 05 20 A0 E1 04 00 8D E2 ?? ?? ?? ?? 80 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 00 50 A0 E1 74 10 9F E5 03 00 A0 E3 20 20 8D E2 03 40 95 E7 ?? ?? ?? ?? 00 00 50 E3 04 00 00 0A 5C 30 9F E5 03 30 9F E7 03 30 95 E7 02 00 53 E3 26 40 A0 03 4C 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 40 80 E7 00 00 E0 E3 7C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? 30 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 00 00 E0 E3 7C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_176_0_0 {
	meta:
		name = "__getdtablesize"
		size = 44
		refs = "0010 __getrlimit"
	strings:
		$1 = { 04 E0 2D E5 0C D0 4D E2 0D 10 A0 E1 07 00 A0 E3 ?? ?? ?? ?? 00 00 50 E3 00 00 9D A5 01 0C A0 B3 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_177_0_0 {
	meta:
		name = "__frexp"
		size = 164
		refs = "0044 __aeabi_dmul"
	strings:
		$1 = { 94 C0 9F E5 F8 43 2D E9 02 31 C1 E3 02 80 A0 E1 0C 00 53 E1 00 20 A0 E3 00 60 A0 E1 01 70 A0 E1 01 C0 A0 E1 00 20 88 E5 17 00 00 CA 00 90 93 E1 15 00 00 0A 01 06 53 E3 06 00 00 AA 00 20 A0 E3 58 30 9F E5 ?? ?? ?? ?? 35 20 E0 E3 00 60 A0 E1 01 C0 A0 E1 02 31 C1 E3 43 3A A0 E1 7F C4 CC E3 FF 3F 43 E2 0F C6 CC E3 02 30 43 E2 FF C5 8C E3 02 20 83 E0 02 76 8C E3 06 00 A0 E1 07 10 A0 E1 00 20 88 E5 F8 43 BD E8 ?? ?? ?? ?? 06 00 A0 E1 07 10 A0 E1 F8 43 BD E8 ?? ?? ?? ?? FF FF EF 7F 00 00 50 43 }
	condition:
		$1
}

rule file_178_0_0 {
	meta:
		name = "getgrent"
		size = 296
		refs = "0060 __nss_getent 0070 __aeabi_read_tp 00e4 __lll_lock_wait_private 0118 __getgrent_r 0120 __libc_errno"
	strings:
		$1 = { F0 43 2D E9 01 10 A0 E3 0C D0 4D E2 FC 20 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 27 00 00 1A CC 40 9F E5 00 30 A0 E3 04 30 8D E5 00 40 8D E5 01 3B A0 E3 10 10 44 E2 B8 00 9F E5 B8 20 9F E5 ?? ?? ?? ?? B4 30 9F E5 00 80 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 90 90 E7 14 60 44 E2 00 50 96 E5 00 10 A0 E3 05 40 A0 E1 80 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 0A 00 00 CA 5C 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 90 80 E7 08 00 A0 E1 0C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? D4 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_277_0_0 {
	meta:
		name = "getaliasent"
		size = 296
		refs = "0060 __nss_getent 0070 __aeabi_read_tp 00e4 __lll_lock_wait_private 0118 __getaliasent_r 0120 __libc_errno"
	strings:
		$1 = { F0 43 2D E9 01 10 A0 E3 0C D0 4D E2 FC 20 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 27 00 00 1A CC 40 9F E5 00 30 A0 E3 04 30 8D E5 00 40 8D E5 01 3B A0 E3 10 10 44 E2 B8 00 9F E5 B8 20 9F E5 ?? ?? ?? ?? B4 30 9F E5 00 80 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 90 90 E7 14 60 44 E2 00 50 96 E5 00 10 A0 E3 05 40 A0 E1 80 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 0A 00 00 CA 5C 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 90 80 E7 08 00 A0 E1 0C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? D4 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1036_0_0 {
	meta:
		name = "getservent"
		size = 296
		refs = "0060 __nss_getent 0070 __aeabi_read_tp 00e4 __lll_lock_wait_private 0118 __getservent_r 0120 __libc_errno"
	strings:
		$1 = { F0 43 2D E9 01 10 A0 E3 0C D0 4D E2 FC 20 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 27 00 00 1A CC 40 9F E5 00 30 A0 E3 04 30 8D E5 00 40 8D E5 01 3B A0 E3 10 10 44 E2 B8 00 9F E5 B8 20 9F E5 ?? ?? ?? ?? B4 30 9F E5 00 80 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 90 90 E7 14 60 44 E2 00 50 96 E5 00 10 A0 E3 05 40 A0 E1 80 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 0A 00 00 CA 5C 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 90 80 E7 08 00 A0 E1 0C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? D4 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1288_0_0 {
	meta:
		name = "getsgent"
		size = 296
		refs = "0060 __nss_getent 0070 __aeabi_read_tp 00e4 __lll_lock_wait_private 0118 __getsgent_r 0120 __libc_errno"
	strings:
		$1 = { F0 43 2D E9 01 10 A0 E3 0C D0 4D E2 FC 20 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 27 00 00 1A CC 40 9F E5 00 30 A0 E3 04 30 8D E5 00 40 8D E5 01 3B A0 E3 10 10 44 E2 B8 00 9F E5 B8 20 9F E5 ?? ?? ?? ?? B4 30 9F E5 00 80 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 90 90 E7 14 60 44 E2 00 50 96 E5 00 10 A0 E3 05 40 A0 E1 80 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 0A 00 00 CA 5C 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 90 80 E7 08 00 A0 E1 0C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? D4 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_180_0_0 {
	meta:
		name = "__posix_spawn_file_actions_realloc"
		size = 60
		refs = "001c realloc"
	strings:
		$1 = { 38 40 2D E9 00 50 90 E5 08 50 85 E2 05 11 85 E0 00 40 A0 E1 01 11 A0 E1 08 00 90 E5 ?? ?? ?? ?? 00 00 50 E3 08 00 84 15 00 50 84 15 00 00 A0 13 0C 00 A0 03 38 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_180_1_0 {
	meta:
		name = "posix_spawn_file_actions_init"
		size = 28
		refs = "000c memset"
	strings:
		$1 = { 08 40 2D E9 00 10 A0 E3 4C 20 A0 E3 ?? ?? ?? ?? 00 00 A0 E3 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_181_0_0 {
	meta:
		name = "_IO_getwc"
		size = 496
		refs = "0018 __aeabi_read_tp 0140 __wuflow 0150 __lll_lock_wait_private 01ec _Unwind_Resume"
	strings:
		$1 = { F0 41 2D E9 00 40 90 E5 02 49 14 E2 00 50 A0 E1 18 00 00 1A 48 60 90 E5 ?? ?? ?? ?? 08 30 96 E5 13 7D 40 E2 07 00 53 E1 0F 00 00 0A 01 10 A0 E3 06 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 3A 00 00 1A 48 30 95 E5 08 70 83 E5 03 60 A0 E1 04 30 96 E5 01 30 83 E2 04 30 86 E5 5C 30 95 E5 00 00 53 E3 2D 00 00 0A 00 20 93 E5 04 10 93 E5 01 00 52 E1 29 00 00 2A 04 10 82 E2 00 10 83 E5 00 60 92 E5 00 30 95 E5 02 09 13 E3 17 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 11 00 00 1A 08 30 85 E5 00 70 95 E5 00 10 A0 E3 07 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 57 E1 F0 FF FF 1A 01 00 57 E3 02 00 00 CA 06 00 A0 E1 F0 41 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF F3 FF FF EA 05 00 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 D4 FF FF EA 06 00 A0 E1 ?? ?? ?? ?? C1 FF FF EA 00 30 95 E5 02 09 13 E3 00 80 A0 E1 1F 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 19 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 07 00 00 DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 08 00 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_182_0_0 {
	meta:
		name = "round_and_return"
		size = 992
		refs = "0078 __aeabi_read_tp 00a0 __aeabi_dmul 0150 __mpn_rshift 01dc __mpn_construct_double 0354 abort 03b8 _dl_hwcap 03c4 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 AC 13 9F E5 C0 00 91 E8 40 40 A0 E3 00 50 A0 E3 06 40 04 E0 07 50 05 E0 05 10 94 E1 0C D0 4D E2 00 40 A0 E1 02 70 A0 E1 03 80 A0 E1 34 60 9D E5 3C 50 9D E5 00 90 A0 03 01 00 00 0A 10 9A F1 EE 03 95 09 E2 6C 23 9F E5 00 30 E0 E3 02 00 57 E1 03 A0 D8 E0 14 00 00 AA 5C 23 9F E5 00 30 E0 E3 02 00 57 E1 03 10 D8 E0 24 00 00 AA 4C 33 9F E5 30 90 9D E5 ?? ?? ?? ?? 03 30 9F E7 22 20 A0 E3 00 00 59 E3 03 20 80 E7 01 16 A0 E3 00 00 A0 E3 30 00 00 0A 00 20 A0 E3 24 33 9F E5 ?? ?? ?? ?? 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 01 2B A0 E3 00 30 A0 E3 07 00 52 E1 08 A0 D3 E0 2B 00 00 AA 00 33 9F E5 30 A0 9D E5 ?? ?? ?? ?? 03 30 9F E7 22 20 A0 E3 00 00 5A E3 03 20 80 E7 E8 12 9F E5 00 00 E0 E3 1B 00 00 0A 00 20 E0 E3 01 36 E0 E3 ?? ?? ?? ?? 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 38 A0 9D E5 00 30 E0 E3 13 6A C6 E1 BF C3 67 E2 FF C7 8C E2 FF CB 8C E2 00 00 56 E3 01 50 85 13 35 00 5C E3 2D 00 00 0A 1F 00 5C E3 6A 00 00 CA 0C 30 A0 E1 04 00 A0 E1 01 C0 4C E2 04 10 A0 E1 02 20 A0 E3 38 C0 8D E5 00 60 94 E5 ?? ?? ?? ?? 00 A0 94 E5 2D 00 00 EA 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 38 A0 9D E5 36 BA A0 E1 00 A0 94 E5 01 B0 0B E2 30 10 9D E5 00 30 91 E2 01 30 A0 13 00 00 55 E3 01 B0 0B E2 01 60 A0 13 04 00 00 1A 38 10 9D E5 00 20 E0 E3 12 61 C6 E1 00 60 96 E2 01 60 A0 13 01 05 59 E3 60 00 00 0A 2D 00 00 DA 02 05 59 E3 63 00 00 0A 03 05 59 E3 60 00 00 1A 07 10 A0 E1 04 00 A0 E1 30 20 9D E5 ?? ?? ?? ?? C4 FF FF EA 00 A0 94 E5 04 60 94 E5 14 10 A0 E3 00 00 5A E3 00 00 56 03 00 A0 A0 E3 00 30 A0 03 01 30 A0 13 00 A0 84 E5 04 A0 84 E5 38 10 8D E5 03 50 85 E1 38 10 9D E5 36 B1 A0 E1 01 B0 1B E2 05 00 00 1A 00 00 55 E3 03 00 00 1A 00 30 E0 E3 13 31 C6 E1 00 00 53 E3 0B 00 00 0A 90 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 22 20 A0 E3 03 20 80 E7 01 16 A0 E3 00 00 A0 E3 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 03 00 8D E8 0C 00 9D E8 64 71 9F E5 00 80 E0 E3 C2 FF FF EA 00 00 59 E3 34 00 00 1A 00 00 5B E3 01 B0 0A 12 0B B0 86 11 CF FF FF 0A 00 00 5B E3 CD FF FF 0A 04 00 94 E5 01 30 8A E2 03 00 5A E1 01 00 80 82 04 00 84 85 02 06 10 E3 00 30 84 E5 2C 00 00 1A 18 21 9F E5 00 30 E0 E3 03 00 58 E1 02 00 57 01 C0 FF FF 1A 04 11 9F E5 E4 30 9F E5 01 06 10 E3 03 10 A0 11 BC FF FF EA 01 70 4C E2 C7 32 A0 E1 01 00 53 E3 1F 70 07 E2 03 61 94 E7 38 70 8D E5 02 00 00 1A 00 30 94 E5 00 00 53 E3 01 50 85 13 38 A0 9D E5 01 20 A0 E3 12 1A A0 E1 01 10 41 E2 01 00 16 E1 1F 30 0C E2 04 00 A0 E1 04 10 84 E2 01 50 85 13 ?? ?? ?? ?? 00 30 A0 E3 04 30 84 E5 00 A0 94 E5 B4 FF FF EA 00 00 53 E3 0B B0 86 01 FF B0 0B 02 CF FF FF 0A 9E FF FF EA ?? ?? ?? ?? 00 00 53 E3 0B B0 86 11 FF 30 0B 12 03 B0 A0 E1 C8 FF FF EA 01 90 97 E2 04 10 A0 E1 02 20 A0 E3 01 30 A0 E3 04 00 A0 E1 00 A0 A8 E2 ?? ?? ?? ?? 04 10 94 E5 48 20 9F E5 00 30 A0 E3 09 60 A0 E1 0A 70 A0 E1 03 00 57 E1 02 00 56 01 01 36 81 E3 04 30 84 E5 44 FF FF 0A 09 10 A0 E1 86 FF FF EA ?? ?? ?? ?? 02 FC FF FF CD FB FF FF ?? ?? ?? ?? 00 00 10 80 ?? ?? ?? ?? FF FF EF 7F ?? ?? ?? ?? 01 FC FF FF 01 04 00 00 }
	condition:
		$1
}

rule file_182_1_0 {
	meta:
		name = "str_to_mpn.isra.0"
		size = 744
		refs = "00fc __mpn_mul_1 028c __assert_fail 02c8 _tens_in_limb"
	strings:
		$1 = { F8 4F 2D E9 03 B0 A0 E1 00 40 51 E2 00 30 A0 E3 00 80 A0 E1 02 A0 A0 E1 00 30 8B E5 2C 70 9D E5 30 50 9D E5 9C 00 00 DA 03 20 A0 E1 03 90 A0 E1 01 60 A0 E3 00 00 00 EA 0C 30 A0 E1 00 10 D8 E5 30 00 41 E2 09 00 50 E3 05 00 00 9A 00 00 55 E3 02 00 00 0A 00 00 D5 E5 01 00 50 E1 11 00 00 0A 07 10 F8 E7 09 91 89 E0 89 90 81 E0 01 40 54 E2 30 90 49 E2 01 80 88 E2 01 C0 83 E2 41 00 00 0A 09 00 5C E3 EB FF FF 1A 00 00 52 E3 17 00 00 1A 00 90 8A E5 00 90 A0 E3 00 60 8B E5 09 C0 A0 E1 01 20 A0 E3 E3 FF FF EA 01 10 D5 E5 00 00 51 E3 76 00 00 0A 01 00 D8 E5 01 00 50 E1 E7 FF FF 1A 01 C0 A0 E3 02 00 00 EA 0C 00 D8 E7 01 00 50 E1 E2 FF FF 1A 01 C0 8C E2 0C 10 D5 E7 00 00 51 E3 0C 00 A0 E1 F7 FF FF 1A 00 10 F8 E7 DC FF FF EA CC 31 9F E5 0A 00 A0 E1 0A 10 A0 E1 ?? ?? ?? ?? 00 30 9A E5 03 90 89 E0 09 00 53 E1 00 30 9B E5 00 90 8A E5 15 00 00 9A 04 20 8A E2 04 00 00 EA 04 10 92 E4 01 10 81 E2 00 00 51 E3 04 10 02 E5 0E 00 00 1A 01 30 53 E2 F8 FF FF 1A 01 90 A0 E3 00 90 99 E0 0C 00 00 0A 00 30 9B E5 72 00 53 E3 56 00 00 CA 03 91 8A E7 00 20 9B E5 00 90 A0 E3 01 20 82 E2 00 20 8B E5 09 C0 A0 E1 B1 FF FF EA 00 90 A0 E3 00 90 99 E0 F2 FF FF 1A 09 C0 A0 E1 00 20 9B E5 AB FF FF EA 28 10 9D E5 30 00 91 E8 01 00 54 E3 00 10 D5 E2 05 00 00 BA 08 30 63 E2 03 60 A0 E1 C3 7F A0 E1 04 00 56 E1 05 30 D7 E0 09 00 00 AA 0C 31 9F E5 00 00 52 E3 0C 31 93 E7 10 00 00 1A 01 30 A0 E3 00 90 8A E5 00 30 8B E5 08 00 A0 E1 F8 4F BD E8 ?? ?? ?? ?? E4 30 9F E5 04 C0 8C E0 04 51 93 E7 0C 31 93 E7 28 C0 9D E5 00 00 A0 E3 00 10 A0 E3 00 00 52 E3 95 09 09 E0 03 00 8C E8 EE FF FF 0A 0A 00 A0 E1 0A 10 A0 E1 ?? ?? ?? ?? 00 30 9A E5 03 90 89 E0 09 00 53 E1 00 30 9B E5 00 90 8A E5 0A 00 00 9A 04 20 8A E2 04 00 00 EA 04 10 92 E4 01 10 81 E2 00 00 51 E3 04 10 02 E5 03 00 00 1A 01 30 53 E2 F8 FF FF 1A 01 30 A0 E3 00 00 00 EA 00 30 A0 E3 00 30 93 E0 DA FF FF 0A 00 20 9B E5 72 00 52 E3 01 10 82 D2 00 10 8B D5 02 31 8A D7 D4 FF FF DA 48 00 9F E5 48 10 9F E5 48 20 9F E5 48 30 9F E5 ?? ?? ?? ?? 01 00 A0 E3 00 10 F8 E7 71 FF FF EA 38 00 9F E5 28 10 9F E5 34 20 9F E5 28 30 9F E5 ?? ?? ?? ?? 14 00 9F E5 14 10 9F E5 24 20 9F E5 14 30 9F E5 ?? ?? ?? ?? 00 CA 9A 3B ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? B3 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 6A 01 00 00 7B 01 00 00 }
	condition:
		$1
}

rule file_182_2_0 {
	meta:
		name = "____strtod_l_internal"
		size = 10104
		refs = "0038 strlen 050c __aeabi_ldivmod 0854 memcpy 08a0 __mpn_mul 0930 __clzsi2 094c __mpn_lshift 09f0 __aeabi_uidiv 0a00 __aeabi_uidivmod 0f28 __correctly_grouped_prefixmb 0fb8 __strncasecmp_l 10c0 __mpn_cmp 1338 _nl_C_locobj 135c _fpioconst_pow10 1360 __tens 1390 __libc_errno 1648 __mpn_rshift 1a08 __mpn_submul_1 1a2c __mpn_add_n 1e3c __assert_fail 20c4 ____strtoull_l_internal 2290 __aeabi_read_tp 22b8 __aeabi_dmul"
	strings:
		$1 = { F0 4F 2D E9 01 DB 4D E2 0C D0 4D E2 00 00 52 E3 24 30 8D E5 00 A0 A0 E1 28 10 8D E5 04 30 93 E5 64 09 00 1A 38 20 8D E5 02 50 A0 E1 24 C0 93 E5 0C 00 A0 E1 14 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 3C 00 8D E5 14 C0 9D E5 68 09 00 0A 24 60 9D E5 00 20 A0 E3 00 30 A0 E3 34 10 96 E5 60 20 8D E5 64 30 8D E5 0A 20 A0 E1 00 40 D2 E5 84 30 A0 E1 B3 30 91 E1 02 3A 13 E2 02 80 A0 E1 01 20 82 E2 F8 FF FF 1A 2D 00 54 E3 08 10 A0 E1 50 01 00 0A 2B 00 54 E3 01 40 D1 05 40 30 8D E5 02 80 A0 01 00 10 DC E5 00 00 51 E3 E6 04 00 0A 00 30 D8 E5 01 00 53 E1 AD 00 00 1A 0C 00 A0 E1 08 60 A0 E1 00 30 A0 E3 02 00 00 EA 01 70 F6 E5 07 00 52 E1 A6 00 00 1A 01 20 F0 E5 01 30 83 E2 00 00 52 E3 03 70 A0 E1 F7 FF FF 1A 07 30 D8 E7 30 30 43 E2 09 00 53 E3 9D 00 00 8A 30 00 54 E3 A4 02 00 0A 38 90 9D E5 01 90 79 E2 00 90 A0 33 00 00 59 E3 24 60 9D E5 30 90 8D E5 0A 90 A0 03 38 20 96 E5 20 90 8D 05 0B 08 00 0A 0A 90 A0 E3 2C 80 8D E5 20 90 8D E5 30 00 44 E2 FF 30 00 E2 09 00 53 E3 04 31 92 E7 09 00 00 9A 20 90 9D E5 FF B0 03 E2 20 60 9D E5 10 90 59 E2 61 30 4B E2 01 90 A0 13 05 00 53 E3 10 00 56 93 18 90 8D E5 93 00 00 1A 00 90 A0 E3 18 90 8D E5 08 B0 A0 E1 09 30 A0 E1 FF 00 00 E2 09 00 50 E3 AF 00 00 9A 20 60 9D E5 10 00 56 E3 A7 00 00 0A 30 90 9D E5 00 00 59 E3 33 09 00 0A 00 00 55 E3 18 30 8D E5 B5 08 00 1A 18 50 9D E5 00 00 55 E3 00 70 A0 13 00 70 E0 03 00 00 51 E3 0B 00 00 0A 00 30 DB E5 01 00 53 E1 A2 00 00 1A 0C 10 A0 E1 0B 00 A0 E1 02 00 00 EA 01 50 F0 E5 05 00 53 E1 9C 00 00 1A 01 30 F1 E5 00 00 53 E3 F9 FF FF 1A 3C 90 9D E5 18 A0 9D E5 09 30 DB E7 0A 40 A0 E1 09 90 8B E0 20 00 9D E5 0A 00 00 EA 61 50 41 E2 05 00 55 E3 91 00 00 8A 30 30 53 E2 01 30 A0 13 01 00 77 E3 00 30 A0 13 00 00 53 E3 01 30 F9 E5 0A 70 64 10 01 A0 8A E2 30 10 43 E2 09 00 51 E3 09 B0 A0 E1 F3 FF FF 9A 10 00 50 E3 03 11 D2 E7 ED FF FF 0A 00 40 A0 E3 2C 40 8D E5 09 00 A0 E1 65 50 51 E2 20 40 9D E5 00 10 75 E2 05 10 B1 E0 10 00 54 E3 00 10 A0 03 00 00 51 E3 00 B0 A0 E1 0B 00 00 0A 01 60 DB E5 2D 00 56 E3 80 00 00 1A 02 60 DB E5 30 60 46 E2 FF 30 06 E2 01 50 A0 E3 09 00 53 E3 02 90 8B E2 44 50 8D E5 84 00 00 9A 0B 00 A0 E1 18 90 9D E5 09 00 5A E1 0E 00 00 9A 01 30 5B E5 30 00 53 E3 08 00 00 1A 0B 30 A0 E1 01 30 43 E2 01 20 53 E5 30 00 52 E3 0A 20 83 E0 02 20 6B E0 F9 FF FF 0A 02 A0 A0 E1 03 B0 A0 E1 18 40 9D E5 04 00 5A E1 D6 08 00 3A 18 50 9D E5 0A 40 55 E0 00 30 74 E2 04 30 B3 E0 00 00 5A E3 00 30 A0 03 00 00 53 E3 04 00 00 0A 60 50 8D E2 30 00 95 E8 00 00 54 E3 00 60 D5 E2 28 02 00 BA 28 90 9D E5 00 00 59 E3 00 00 89 15 00 00 5A E3 A6 00 00 1A 40 B0 9D E5 00 00 5B E3 13 00 00 0A 00 00 A0 E3 02 11 A0 E3 01 DB 8D E2 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 30 30 44 E2 09 00 53 E3 5E FF FF 9A B4 5F 9F E5 38 30 95 E5 04 21 D3 E7 69 00 52 E3 16 03 00 0A 6E 00 52 E3 03 03 00 0A 28 50 9D E5 00 00 55 E3 28 60 9D 15 00 A0 86 15 00 00 A0 E3 00 10 A0 E3 01 DB 8D E2 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 00 51 E3 0B 00 00 0A 00 30 D8 E5 01 00 53 E1 C4 02 00 1A 0C 60 A0 E1 08 70 A0 E1 02 00 00 EA 01 90 F7 E5 09 00 53 E1 BE 02 00 1A 01 30 F6 E5 00 00 53 E3 F9 FF FF 1A 2C 90 9D E5 20 60 9D E5 08 00 59 E1 10 00 56 03 58 FF FF 1A 3C 60 9D E5 06 30 D8 E7 30 60 43 E2 09 00 56 E3 53 FF FF 9A 03 31 92 E7 61 30 43 E2 FF 30 03 E2 05 00 53 E3 4E FF FF 9A AE 02 00 EA 04 01 92 E7 61 00 40 E2 FF 00 00 E2 05 00 50 E3 52 FF FF 8A 01 30 83 E2 01 40 DB E5 01 B0 8B E2 30 00 44 E2 47 FF FF EA 04 11 D2 E7 18 A0 9D E5 20 60 9D E5 10 60 56 E2 00 30 76 E2 06 30 B3 E0 70 00 51 E3 00 90 A0 13 01 90 03 02 00 00 59 E3 2C 90 8D E5 92 02 00 0A 01 60 DB E5 2D 00 56 E3 7E FF FF 0A 2B 00 56 E3 02 60 DB 05 30 60 46 E2 00 40 A0 13 00 50 A0 03 FF 30 06 E2 01 90 8B 12 44 40 8D 15 02 90 8B 02 44 50 8D 05 09 00 53 E3 7A FF FF 8A 2C 40 9D E5 00 00 54 E3 6B 02 00 1A 44 40 9D E5 00 00 54 E3 9E 02 00 0A 18 00 9D E5 00 10 A0 E3 01 50 A0 E1 5A 4F 90 E2 00 50 A5 E2 04 00 A0 E1 05 10 A0 E1 0A 20 A0 E3 00 30 A0 E3 14 C0 8D E5 ?? ?? ?? ?? 30 00 8D E5 34 10 8D E5 14 C0 9D E5 04 00 A0 E1 05 10 A0 E1 0A 20 A0 E3 00 30 A0 E3 14 C0 8D E5 ?? ?? ?? ?? 48 20 8D E5 4C 30 8D E5 54 80 8D E5 09 00 A0 E1 60 50 8D E2 30 00 95 E8 50 70 8D E5 14 C0 9D E5 30 90 8D E2 00 03 99 E8 0A 10 A0 E3 04 00 58 E1 05 20 D9 E0 3F 07 00 BA 05 00 59 E1 04 00 58 01 C6 7F A0 E1 36 07 00 0A 94 21 83 E0 91 35 23 E0 06 40 92 E0 07 50 A3 E0 60 40 8D E5 64 50 8D E5 01 60 D0 E5 30 60 46 E2 FF 30 06 E2 09 00 53 E3 01 00 80 E2 EC FF FF 9A 44 60 9D E5 50 70 8D E2 00 00 56 E3 80 01 97 E8 3E FF FF 0A 00 40 74 E2 00 50 E5 E2 60 40 8D E5 64 50 8D E5 39 FF FF EA 01 90 A0 E3 02 80 A0 E1 01 40 D1 E5 40 90 8D E5 AD FE FF EA 00 00 57 E3 2D 00 00 0A 00 00 DC E5 00 30 D8 E5 01 E0 DC E5 00 00 00 EA 01 80 88 E2 03 00 50 E1 01 30 D8 15 FB FF FF 1A 00 00 5E E3 0B 00 00 0A 01 30 D8 E5 0E 00 53 E1 F6 FF FF 1A 01 30 A0 E3 02 00 00 EA 03 10 D8 E7 02 00 51 E1 26 02 00 1A 01 30 83 E2 03 20 DC E7 00 00 52 E3 F8 FF FF 1A 20 50 9D E5 10 00 55 E3 D7 05 00 0A 60 50 8D E2 30 00 95 E8 00 20 94 E2 02 31 A5 E2 07 00 A0 E1 00 10 A0 E3 01 00 53 E1 00 00 52 01 F2 06 00 3A 20 C0 9D E5 10 00 5C E3 27 1F A0 01 07 01 A0 01 00 00 54 E0 01 10 C5 E0 3C 40 9D E5 60 00 8D E5 64 10 8D E5 04 30 87 E0 0A A0 67 E0 03 80 88 E0 20 50 9D E5 10 00 55 E3 6F 01 00 0A 60 10 8D E2 03 00 91 E8 00 00 50 E3 00 60 D1 E2 F8 03 00 BA 18 60 9D E5 06 20 5A E0 0A 30 CA E0 02 00 50 E1 03 90 D1 E0 01 00 00 AA 00 20 A0 E1 01 30 A0 E1 18 C0 9D E5 02 90 8C E0 09 40 A0 E1 00 50 A0 E3 18 40 8D E5 1C 50 8D E5 18 C0 8D E2 00 18 9C E8 68 4C 9F E5 00 50 A0 E3 02 20 50 E0 03 30 C1 E0 0B 40 54 E0 0C 50 C5 E0 02 00 54 E1 03 C0 D5 E0 60 20 8D E5 64 30 8D E5 8D 07 00 BA 00 0C 9F E5 00 10 E0 E3 00 00 52 E1 01 50 D3 E0 AE 07 00 BA 00 00 59 E3 09 70 A0 01 3E 03 00 1A 09 00 5A E1 91 07 00 9A 60 50 8D E2 30 00 95 E8 D4 2B 9F E5 00 30 A0 E3 02 00 94 E0 03 10 A5 E0 03 00 51 E1 02 00 50 01 88 07 00 8A 00 00 57 E3 92 05 00 DA 00 00 59 E3 5F 07 00 0A 05 B0 94 E1 36 C0 67 02 00 40 A0 03 5B 07 00 1A 18 10 8D E2 03 00 91 E8 0A 50 A0 E1 00 60 A0 E3 00 00 55 E0 01 10 C6 E0 0C 20 A0 E1 CC 3F A0 E1 02 00 50 E1 03 E0 D1 E0 0A C0 69 B0 18 10 8D E2 03 00 91 E8 0C 20 A0 B1 C2 3F A0 B1 00 20 92 E0 01 30 A3 E0 05 00 52 E1 06 10 D3 E0 09 A0 8C B0 0A 90 69 E0 18 90 8D E5 00 60 A0 A3 18 B0 9D E5 8F 9F 8D E2 01 50 A0 B3 48 60 8D A5 70 60 8D E2 0B A0 64 E0 48 50 8D B5 20 90 8D E5 09 B0 A0 E1 34 5B 9F E5 01 40 A0 E3 00 90 A0 E3 24 60 8D E5 0C 00 00 EA 10 10 45 E2 02 02 91 E8 1C CB 9F E5 02 90 49 E2 02 10 81 E2 09 21 A0 E1 01 11 8C E0 0B 00 A0 E1 ?? ?? ?? ?? 00 00 5A E3 84 40 A0 E1 10 50 85 E2 1A 00 00 0A 04 00 1A E1 F9 FF FF 0A 00 00 59 E3 04 A0 2A E0 ED FF FF 0A 10 10 45 E2 06 00 91 E8 D4 EA 9F E5 02 10 81 E2 0B 30 A0 E1 00 90 8D E5 06 00 A0 E1 01 11 8E E0 02 20 42 E2 ?? ?? ?? ?? 0C 30 15 E5 02 30 43 E2 00 00 50 E3 03 90 89 E0 01 90 49 02 0B 30 A0 E1 00 00 5A E3 06 B0 A0 E1 84 40 A0 E1 03 60 A0 E1 10 50 85 E2 E4 FF FF 1A 24 60 9D E5 06 00 5B E1 D3 05 00 0A 3C 50 9D E5 38 B0 9D E5 01 40 49 E2 60 30 8D E2 04 C1 A0 E1 18 10 9D E5 04 50 8D E5 00 30 8D E5 06 20 A0 E1 5C 30 8D E2 08 B0 8D E5 08 00 A0 E1 30 40 8D E5 18 C0 8D E5 01 5B 8D E2 FD FC FF EB 18 40 9D E5 08 50 85 E2 04 30 85 E0 CC 01 13 E5 ?? ?? ?? ?? 00 40 50 E2 0B 00 00 DA 20 00 9D E5 09 20 A0 E1 00 10 A0 E1 04 30 A0 E1 ?? ?? ?? ?? 06 00 A0 E1 06 10 A0 E1 04 30 A0 E1 5C 20 9D E5 ?? ?? ?? ?? 00 00 50 E3 7A 03 00 1A 5C 20 9D E5 07 00 A0 E1 C7 1F A0 E1 01 00 59 E3 60 00 8D E5 64 10 8D E5 07 02 00 0A 02 00 59 E3 BD 01 00 1A 01 00 52 E3 3C 62 9D E5 40 52 9D E5 74 04 00 DA 70 80 8D E2 00 05 98 E8 00 90 A0 E3 18 90 8D E5 68 B0 8D E2 05 38 A0 E1 23 38 A0 E1 00 C0 66 E2 20 30 8D E5 28 C0 8D E5 05 30 A0 E1 24 B0 8D E5 25 98 A0 E1 07 50 A0 E1 06 70 A0 E1 03 60 A0 E1 06 00 5A E1 B0 04 00 0A 09 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 09 10 A0 E1 00 40 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 20 30 9D E5 94 03 03 E0 28 28 A0 E1 01 18 82 E1 01 00 53 E1 07 00 00 9A 06 10 91 E0 01 20 44 E2 03 00 00 2A 01 00 53 E1 02 40 44 82 06 10 81 80 00 00 00 8A 02 40 A0 E1 01 B0 63 E0 0B 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 09 10 A0 E1 00 A0 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 20 E0 9D E5 9A 0E 0E E0 08 38 A0 E1 23 38 A0 E1 01 18 83 E1 01 00 5E E1 07 00 00 9A 06 10 91 E0 01 30 4A E2 03 00 00 2A 01 00 5E E1 02 A0 4A 82 06 10 81 80 00 00 00 8A 03 A0 A0 E1 04 48 8A E1 94 27 83 E0 01 10 6E E0 02 A0 A0 E1 01 00 53 E1 05 00 00 8A 00 20 9A E2 01 20 A0 13 01 00 53 E1 00 20 A0 13 00 00 52 E3 05 00 00 0A 07 00 5A E0 00 30 C3 E2 06 10 91 E0 00 A0 A0 E1 01 40 44 E2 F1 FF FF 3A 00 20 A0 E3 0A 80 52 E0 03 A0 C1 E0 02 00 55 E1 65 04 00 1A 02 00 54 E1 7E 04 00 0A 04 00 A0 E1 ?? ?? ?? ?? 60 30 8D E2 0C 00 93 E8 20 10 60 E2 00 20 52 E0 C0 3F C3 E0 35 00 51 E3 60 20 8D E5 64 30 8D E5 7E 05 00 DA 14 10 E0 E3 01 10 60 E0 34 11 A0 E1 35 00 80 E2 24 B0 9D E5 68 10 8D E5 18 00 8D E5 48 60 9D E5 18 90 9D E5 00 00 5A E3 01 60 86 13 01 20 52 E2 00 30 C3 E2 00 00 56 E3 1F 10 69 E2 01 80 A0 13 01 00 00 1A 00 80 98 E2 01 80 A0 13 40 50 9D E5 04 40 8D E5 00 50 8D E5 08 10 8D E5 0C 80 8D E5 0B 00 A0 E1 69 FB FF EB 06 FE FF EA 24 60 9D E5 01 30 D8 E5 38 20 96 E5 03 31 92 E7 78 00 53 E3 C9 02 00 0A 38 B0 9D E5 01 B0 7B E2 00 B0 A0 33 00 00 5B E3 0A 60 A0 03 30 B0 8D E5 20 60 8D 05 62 05 00 0A 0A 60 A0 E3 2C 80 8D E5 20 60 8D E5 CB 02 00 EA 2C 10 9D E5 18 60 9D E5 24 90 9D E5 17 00 00 EA 30 30 43 E2 09 00 53 E3 00 30 A0 93 01 30 A0 83 00 00 53 E3 10 00 00 1A 01 30 5B E5 30 00 53 E3 1B 01 00 1A 00 00 51 E3 01 20 A0 03 04 20 A0 13 02 40 94 E0 00 30 A0 E3 01 A0 4A E2 03 50 A5 E0 00 30 9A E2 01 30 A0 13 A5 3F 13 E0 01 60 46 E2 60 40 8D E5 64 50 8D E5 0D 01 00 0A 01 B0 4B E2 00 00 51 E3 01 30 5B E5 E4 FF FF 0A 34 20 99 E5 83 30 A0 E1 B3 30 92 E1 23 36 A0 E1 01 30 23 E2 01 30 03 E2 E1 FF FF EA 24 60 9D E5 00 30 D8 E5 34 E0 96 E5 83 20 A0 E1 B2 20 9E E1 01 0A 12 E3 07 00 00 1A 01 20 88 E2 00 30 D2 E5 02 80 A0 E1 83 20 A0 E1 B2 20 9E E1 01 0A 12 E3 01 20 88 E2 F8 FF FF 0A 30 00 53 E3 0C 05 00 1A 01 30 88 E2 03 80 A0 E1 01 20 D3 E4 30 00 52 E3 FB FF FF 0A 30 30 42 E2 09 00 53 E3 24 90 9D 85 38 30 99 85 02 31 93 87 5C 26 9F E5 57 30 43 82 03 41 92 E7 01 80 88 92 01 80 88 82 00 00 54 E3 9D 05 00 0A 15 20 64 E2 13 32 A0 E1 60 70 8D E2 C0 00 97 E8 18 00 9D E5 00 10 A0 E3 00 00 56 E3 00 B0 D7 E2 6C 30 8D E5 14 50 64 E2 18 00 8D E5 1C 10 8D E5 6D 04 00 BA 00 20 E0 E3 02 31 E0 E3 06 20 52 E0 07 30 C3 E0 04 20 52 E0 C4 3F C3 E0 01 20 92 E2 00 30 A3 E2 C3 0F A0 E1 03 B0 A0 E3 C0 1F A0 E1 00 C0 A0 E3 0B 00 00 E0 02 00 90 E0 0C 10 01 E0 03 10 A1 E0 20 01 A0 E1 01 2F 80 E1 41 31 A0 E1 18 10 8D E2 03 00 91 E8 03 00 51 E1 02 00 50 01 73 05 00 8A 18 10 8D E2 03 00 91 E8 01 00 50 E2 00 10 C1 E2 01 40 44 E2 00 21 A0 E1 01 31 A0 E1 20 3F 83 E1 04 20 92 E0 C4 3F A3 E0 06 20 92 E0 07 30 A3 E0 60 20 8D E5 64 30 8D E5 01 00 A0 E3 05 C0 A0 E1 3C 70 9D E5 24 60 9D E5 08 00 00 EA 01 9B 8D E2 08 90 89 E2 00 51 89 E0 A0 93 15 E5 03 A0 4C E2 11 1A 89 E1 A0 13 05 E5 04 C0 4C E2 04 A0 A0 E1 01 40 5A E2 92 00 00 0A 00 10 D8 E5 81 50 A0 E1 B5 50 9E E1 01 0A 15 E3 07 90 F8 07 09 10 A0 01 30 50 41 E2 01 90 A0 11 09 00 55 E3 38 50 96 85 01 11 95 87 01 80 88 92 30 10 49 92 01 80 88 82 57 10 41 82 02 00 5C E3 E3 FF FF CA 01 BB 8D E2 08 B0 8B E2 00 51 8B E0 A0 93 15 E5 03 B0 6C E2 31 BB 89 E1 00 00 50 E3 1D 90 8C E2 A0 B3 05 E5 11 19 A0 E1 3C 04 00 0A 68 10 8D E5 1C C0 8C E2 00 00 A0 E3 DC FF FF EA 44 50 9D E5 00 00 55 E3 38 02 00 1A 18 40 9D E5 00 00 54 E3 1B 04 00 0A 00 00 57 E3 37 05 00 1A 18 50 9D E5 01 2C A0 E3 00 30 A0 E3 05 20 52 E0 00 30 C3 E2 03 51 A0 E1 02 41 A0 E1 22 5F 85 E1 03 40 94 E2 00 50 A5 E2 2C 00 00 EA 0E 30 A0 E1 C8 FD FF EA 2C 30 8D E5 0B 00 A0 E1 DF FC FF EA 18 90 9D E5 00 00 59 E3 D2 03 00 0A 20 90 9D E5 10 70 59 E2 00 60 77 E2 07 60 B6 E0 65 00 5B E3 06 30 A0 01 01 30 86 13 00 00 53 E3 95 FC FF 0A 38 20 9D E5 05 30 A0 E1 2C 00 9D E5 08 10 A0 E1 ?? ?? ?? ?? 28 B0 9D E5 00 00 5B E3 05 00 00 0A 2C C0 9D E5 00 00 5C E1 00 80 A0 11 E4 05 00 0A 28 40 9D E5 00 80 84 E5 40 50 9D E5 00 00 55 E3 12 FD FF 0A FD FC FF EA 18 40 9D E5 00 00 54 E3 F3 01 00 0A 00 00 57 E3 1A 05 00 1A FC 43 9F E5 18 E0 9D E5 00 50 A0 E3 0E 40 54 E0 00 50 C5 E2 00 00 54 E3 00 00 D5 E2 58 FD FF AA 00 40 A0 E3 00 50 A0 E3 30 40 8D E5 34 50 8D E5 5C FD FF EA 05 30 A0 E1 08 00 A0 E1 90 13 9F E5 03 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 F4 FC FF 1A 03 30 D8 E5 28 00 53 E3 03 C0 88 E2 22 04 00 0A A0 13 9F E5 00 00 A0 E3 28 40 9D E5 00 00 54 E3 00 C0 84 15 F0 FC FF EA 08 00 A0 E1 54 13 9F E5 03 20 A0 E3 05 30 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_183_0_0 {
	meta:
		name = "__xpg_basename"
		size = 248
		refs = "001c strrchr"
	strings:
		$1 = { 10 40 2D E9 00 40 50 E2 20 00 00 0A 00 30 D4 E5 00 00 53 E3 1D 00 00 0A 2F 10 A0 E3 ?? ?? ?? ?? 00 30 50 E2 1C 00 00 0A 01 20 D3 E5 00 00 52 E3 01 00 83 12 13 00 00 1A 03 00 54 E1 2A 00 00 2A 01 20 53 E5 2F 00 52 E3 04 00 00 0A 14 00 00 EA 01 30 50 E5 2F 00 53 E3 12 00 00 1A 00 30 A0 E1 01 00 43 E2 04 00 50 E1 F8 FF FF 1A 00 30 D3 E5 00 00 53 E3 03 00 00 0A 01 00 80 E2 01 30 D0 E5 00 00 53 E3 FB FF FF 1A 10 40 BD E8 ?? ?? ?? ?? 5C 00 9F E5 10 40 BD E8 ?? ?? ?? ?? 04 00 A0 E1 F8 FF FF EA 03 00 A0 E1 01 30 40 E2 00 20 A0 E3 03 00 54 E1 00 20 C0 E5 0B 00 00 2A 02 20 50 E5 2F 00 52 E3 03 00 A0 E1 03 00 00 1A ED FF FF EA 01 30 50 E5 2F 00 53 E3 EA FF FF 0A 01 00 40 E2 04 00 50 E1 F9 FF FF 1A E6 FF FF EA 03 00 A0 E1 E4 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_184_0_0 {
	meta:
		name = "__ppoll_chk"
		size = 32
		refs = "0010 ppoll 001c __chk_fail"
	strings:
		$1 = { 08 40 2D E9 08 C0 9D E5 AC 01 51 E1 02 00 00 8A ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "execl"
		size = 360
		refs = "00a8 realloc 00d0 __execve 00e8 free 0150 memcpy 0164 __environ"
	strings:
		$1 = { 0E 00 2D E9 F0 4F 2D E9 01 DA 4D E2 10 D0 4D E2 02 1A 8D E2 CC 3F 11 E5 3C 21 9F E5 3C 91 9F E5 01 5A 8D E2 01 1A 8D E2 10 10 81 E2 38 50 85 E2 00 00 53 E3 02 30 81 E7 09 50 81 E7 00 C0 A0 E1 2F 00 00 0A 10 B0 8D E2 0B 70 A0 E1 10 60 A0 E3 01 40 A0 E3 01 8B A0 E3 00 00 00 EA 08 60 86 E2 04 50 85 E2 04 30 15 E5 01 2A 8D E2 10 20 82 E2 00 00 53 E3 04 31 87 E7 04 A1 A0 E1 09 50 82 E7 01 40 84 E2 0D 00 00 0A 04 00 58 E1 F2 FF FF 1A 0B 00 57 E1 07 00 A0 E1 06 10 A0 E1 88 80 A0 E1 20 00 00 0A 04 C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 04 C0 9D E5 17 00 00 0A 00 70 A0 E1 E6 FF FF EA 9C 30 9F E5 0C 00 A0 E1 00 20 93 E5 07 10 A0 E1 ?? ?? ?? ?? 0B 00 57 E1 00 40 A0 E1 00 00 A0 01 02 00 00 0A 07 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 01 DA 8D E2 10 D0 8D E2 F0 4F BD E8 0C D0 8D E2 ?? ?? ?? ?? 58 30 9F E5 10 10 8D E2 00 20 93 E5 ?? ?? ?? ?? F5 FF FF EA 07 00 A0 E1 ?? ?? ?? ?? 00 00 E0 E3 F1 FF FF EA 06 10 A0 E1 00 00 A0 E3 04 C0 8D E5 ?? ?? ?? ?? 00 70 50 E2 0B 10 A0 E1 04 20 8A E2 04 C0 9D E5 F4 FF FF 0A 04 C0 8D E5 ?? ?? ?? ?? 04 C0 9D E5 BF FF FF EA 00 F0 FF FF FC EF FF FF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_186_0_0 {
	meta:
		name = "_rpc_dtablesize"
		size = 40
		refs = "0014 __getdtablesize"
	strings:
		$1 = { 10 40 2D E9 18 40 9F E5 00 00 94 E5 00 00 50 E3 01 00 00 1A ?? ?? ?? ?? 00 00 84 E5 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_187_0_0 {
	meta:
		name = "__mpn_mod_1"
		size = 1484
		refs = "0034 __clzsi2 0060 __aeabi_uidivmod 0070 __aeabi_uidiv"
	strings:
		$1 = { F0 4F 2D E9 00 50 51 E2 00 40 A0 E1 14 D0 4D E2 02 60 A0 E1 05 00 A0 01 65 00 00 0A 05 31 85 E0 83 30 85 E0 83 31 A0 E1 64 00 53 E3 02 00 A0 E1 62 00 00 DA ?? ?? ?? ?? 00 90 50 E2 C7 00 00 0A 16 69 A0 E1 86 10 B0 E1 00 B0 E0 03 26 00 00 0A 00 80 66 E2 26 78 A0 E1 08 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 08 00 A0 E1 01 B0 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 06 A8 A0 E1 2A A8 A0 E1 00 80 A0 E1 9A 08 00 E0 0B 38 A0 E1 03 00 50 E1 07 00 00 9A 06 30 93 E0 01 20 48 E2 03 00 00 2A 03 00 50 E1 02 80 48 82 06 30 83 80 00 00 00 8A 02 80 A0 E1 03 B0 60 E0 0B 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 0B 00 A0 E1 01 30 A0 E1 07 10 A0 E1 00 30 8D E5 ?? ?? ?? ?? 90 0A 0A E0 00 30 9D E5 03 18 A0 E1 01 00 5A E1 25 01 00 8A 08 B8 80 E1 07 A1 45 E2 0A C1 94 E7 20 00 69 E2 02 80 55 E2 0A A1 84 E0 3C 10 A0 E1 17 00 00 4A 1C 79 A0 E1 91 4B 85 E0 04 C0 3A E5 05 40 81 E0 94 26 83 E0 3C 40 87 E1 02 50 54 E0 03 20 C1 E0 00 00 52 E3 01 80 48 E2 05 10 A0 E1 07 00 00 0A 06 70 55 E0 00 20 C2 E2 00 00 52 E3 07 10 A0 E1 02 00 00 0A 06 30 57 E0 00 20 C2 E2 03 10 A0 E1 06 00 51 E1 01 10 66 20 01 00 78 E3 E7 FF FF 1A 91 4B 85 E0 05 00 81 E0 1C C9 A0 E1 90 26 83 E0 02 00 5C E0 03 20 C1 E0 00 00 52 E3 07 00 00 0A 06 50 50 E0 00 20 C2 E2 00 00 52 E3 05 00 A0 E1 02 00 00 0A 06 70 55 E0 00 20 C2 E2 07 00 A0 E1 06 00 50 E1 00 00 66 20 30 09 A0 E1 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 50 E3 08 00 8D E5 B1 00 00 0A 16 60 A0 E1 07 A1 45 E2 0A 81 94 E7 20 70 60 E2 02 50 55 E2 0C 70 8D E5 38 97 A0 E1 06 78 A0 41 0A A1 84 E0 04 60 8D E5 27 78 A0 41 26 48 A0 41 2E 00 00 4A 04 30 9D E5 03 78 A0 E1 27 78 A0 E1 23 48 A0 E1 09 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 97 00 0B E0 09 00 A0 E1 ?? ?? ?? ?? 08 30 9D E5 18 C3 A0 E1 04 80 3A E5 0C 30 9D E5 38 93 8C E1 29 28 A0 E1 01 28 82 E1 02 00 5B E1 04 10 A0 E1 01 50 45 E2 04 00 00 9A 04 30 9D E5 03 20 92 E0 01 00 00 2A 02 00 5B E1 03 20 82 80 02 60 6B E0 06 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 97 00 0B E0 06 00 A0 E1 ?? ?? ?? ?? 09 C8 A0 E1 2C C8 A0 E1 01 18 8C E1 01 00 5B E1 04 00 00 9A 04 30 9D E5 03 10 91 E0 01 00 00 2A 01 00 5B E1 03 10 81 80 01 00 75 E3 01 90 6B E0 D4 FF FF 1A 04 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 08 30 9D E5 97 00 06 E0 18 53 A0 E1 04 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 25 38 A0 E1 01 18 83 E1 01 00 56 E1 02 00 00 9A 04 30 9D E5 03 10 91 E0 AF 00 00 3A 01 90 66 E0 09 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 90 07 07 E0 09 00 A0 E1 ?? ?? ?? ?? 05 58 A0 E1 25 58 A0 E1 01 18 85 E1 01 00 57 E1 04 00 00 9A 04 50 9D E5 05 10 91 E0 01 00 00 2A 01 00 57 E1 05 10 81 80 08 30 9D E5 01 70 67 E0 37 03 A0 E1 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 86 10 B0 E1 00 00 E0 03 24 00 00 0A 00 80 66 E2 26 78 A0 E1 08 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 08 00 A0 E1 01 A0 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 06 98 A0 E1 29 98 A0 E1 00 80 A0 E1 99 08 00 E0 0A 38 A0 E1 03 00 50 E1 07 00 00 9A 06 30 93 E0 01 20 48 E2 03 00 00 2A 03 00 50 E1 02 80 48 82 06 30 83 80 00 00 00 8A 02 80 A0 E1 03 A0 60 E0 0A 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 0A 00 A0 E1 01 B0 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 90 09 09 E0 0B 18 A0 E1 01 00 59 E1 68 00 00 8A 08 08 80 E1 01 A0 45 E2 0A 31 94 E7 03 00 56 E1 02 A0 45 82 00 30 A0 93 00 00 5A E3 1A 00 00 BA 0A C1 A0 E1 03 C0 2C E2 0A A1 84 E0 0C C0 E0 E1 00 20 A0 E3 93 40 85 E0 05 10 83 E0 91 46 85 E0 02 10 9A E7 04 70 51 E0 05 40 C3 E0 00 00 54 E3 07 30 A0 E1 04 20 42 E2 07 00 00 0A 06 10 57 E0 00 40 C4 E2 00 00 54 E3 01 30 A0 E1 02 00 00 0A 06 50 51 E0 00 40 C4 E2 05 30 A0 E1 06 00 53 E1 03 30 66 20 0C 00 52 E1 E9 FF FF 1A 03 00 A0 E1 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 01 30 45 E2 03 91 94 E7 09 00 56 E1 02 30 45 82 08 90 9D 95 00 00 53 E3 2E 00 00 BA 03 71 A0 E1 03 41 84 E0 03 70 27 E2 06 A8 A0 E1 04 40 8D E5 07 70 E0 E1 2A A8 A0 E1 26 48 A0 E1 00 B0 A0 E3 04 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 9A 00 08 E0 09 00 A0 E1 ?? ?? ?? ?? 04 30 9D E5 0B 50 93 E7 25 28 A0 E1 01 28 82 E1 02 00 58 E1 04 10 A0 E1 04 B0 4B E2 03 00 00 9A 06 20 92 E0 01 00 00 2A 02 00 58 E1 06 20 82 80 02 80 68 E0 08 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 9A 00 09 E0 08 00 A0 E1 ?? ?? ?? ?? 05 38 A0 E1 23 38 A0 E1 01 18 83 E1 01 00 59 E1 03 00 00 9A 06 10 91 E0 01 00 00 2A 01 00 59 E1 06 10 81 80 07 00 5B E1 01 90 69 E0 D9 FF FF 1A 09 00 A0 E1 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 06 10 91 E0 01 30 40 E2 02 00 00 2A 01 00 5A E1 02 00 40 82 D3 FE FF 8A 03 00 A0 E1 D1 FE FF EA 06 10 91 E0 01 30 40 E2 02 00 00 2A 01 00 59 E1 02 00 40 82 90 FF FF 8A 03 00 A0 E1 8E FF FF EA 01 00 56 E1 03 10 81 80 4C FF FF EA }
	condition:
		$1
}

rule file_188_0_0 {
	meta:
		name = "fputc"
		size = 496
		refs = "001c __aeabi_read_tp 0140 __overflow 0150 __lll_lock_wait_private 01ec _Unwind_Resume"
		altNames = "_IO_putc"
	strings:
		$1 = { F0 41 2D E9 00 40 91 E5 02 49 14 E2 01 50 A0 E1 00 60 A0 E1 18 00 00 1A 48 70 91 E5 ?? ?? ?? ?? 08 30 97 E5 13 8D 40 E2 08 00 53 E1 0F 00 00 0A 01 10 A0 E3 07 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 39 00 00 1A 48 30 95 E5 08 80 83 E5 03 70 A0 E1 04 30 97 E5 01 30 83 E2 04 30 87 E5 14 30 95 E5 18 20 95 E5 02 00 53 E1 01 20 83 32 14 20 85 35 00 60 C3 35 FF 60 06 32 26 00 00 2A 00 30 95 E5 02 09 13 E3 17 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 11 00 00 1A 08 30 85 E5 00 70 95 E5 00 10 A0 E3 07 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 57 E1 F0 FF FF 1A 01 00 57 E3 02 00 00 CA 06 00 A0 E1 F0 41 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF F3 FF FF EA FF 10 06 E2 05 00 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 D3 FF FF EA 07 00 A0 E1 ?? ?? ?? ?? C2 FF FF EA 00 30 95 E5 02 09 13 E3 00 80 A0 E1 1F 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 19 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 07 00 00 DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 08 00 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_190_0_0 {
	meta:
		name = "siggetmask"
		size = 20
		refs = "0008 __sigblock"
	strings:
		$1 = { 08 40 2D E9 00 00 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_116_4_4 {
	meta:
		name = "_ZNSt5ctypeIcE13classic_tableEv"
		size = 32
		refs = "0004 _ZNSt6locale5facet15_S_get_c_localeEv 0018 __cxa_end_cleanup 001c __cxa_call_unexpected"
	strings:
		$1 = { 08 40 2D E9 ?? ?? ?? ?? 34 00 90 E5 08 40 BD E8 ?? ?? ?? ?? 01 00 71 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_783_0_0 {
	meta:
		name = "setpgrp"
		size = 24
		refs = "000c __setpgid"
	strings:
		$1 = { 08 40 2D E9 00 00 A0 E3 00 10 A0 E1 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_191_0_0 {
	meta:
		name = "_nl_intern_locale_data"
		size = 824
		refs = "0064 malloc 0144 free 014c __aeabi_read_tp 017c __assert_fail 02f8 __libc_errno"
	strings:
		$1 = { 07 00 52 E3 F0 47 2D E9 02 70 A0 E1 00 40 A0 E1 01 50 A0 E1 A2 00 00 9A 03 00 50 E3 00 20 91 E5 16 00 00 0A 00 00 50 E3 12 00 00 0A B4 32 9F E5 03 30 20 E0 02 00 53 E1 99 00 00 1A A8 82 9F E5 04 60 95 E5 04 31 98 E7 03 00 56 E1 94 00 00 3A 02 00 86 E2 00 01 A0 E1 00 00 57 E1 90 00 00 9A 1C 00 80 E2 ?? ?? ?? ?? 00 00 50 E3 05 00 00 1A F0 47 BD E8 ?? ?? ?? ?? 70 32 9F E5 EC FF FF EA 6C 32 9F E5 EA FF FF EA 00 30 A0 E3 00 00 56 E3 A0 00 80 E9 20 60 80 E5 14 30 80 E5 10 30 80 E5 18 30 80 E5 1C 30 80 E5 F0 FF FF 0A 08 20 95 E5 02 00 57 E1 04 81 88 20 05 C0 A0 21 00 10 A0 21 01 90 44 22 1E 00 00 3A 0B 00 59 E3 09 F1 9F 97 69 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 0F 00 53 E3 60 00 00 8A 34 A0 98 E5 03 A1 9A E7 05 00 5A E3 68 00 00 0A 02 20 85 E0 24 20 81 E5 01 30 83 E2 06 00 53 E1 CF FF FF 0A 0C 20 9C E5 02 00 57 E1 04 10 81 E2 04 C0 8C E2 E0 FF FF 2A ?? ?? ?? ?? A8 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 00 00 A0 E3 C2 FF FF EA 01 00 53 E3 E7 FF FF 9A 88 01 9F E5 88 11 9F E5 89 20 A0 E3 84 31 9F E5 ?? ?? ?? ?? 04 00 53 E3 E0 FF FF 9A 78 01 9F E5 6C 11 9F E5 88 20 A0 E3 68 31 9F E5 ?? ?? ?? ?? 0C 00 53 E3 D9 FF FF 9A 60 01 9F E5 50 11 9F E5 87 20 A0 E3 4C 31 9F E5 ?? ?? ?? ?? 06 00 53 E3 D2 FF FF 9A 48 01 9F E5 34 11 9F E5 86 20 A0 E3 30 31 9F E5 ?? ?? ?? ?? 02 00 53 E3 CB FF FF 9A 30 01 9F E5 18 11 9F E5 85 20 A0 E3 14 31 9F E5 ?? ?? ?? ?? 04 00 53 E3 C4 FF FF 9A 18 01 9F E5 FC 10 9F E5 84 20 A0 E3 F8 30 9F E5 ?? ?? ?? ?? 2D 00 53 E3 BD FF FF 9A 00 01 9F E5 E0 10 9F E5 83 20 A0 E3 DC 30 9F E5 ?? ?? ?? ?? 12 00 53 E3 B6 FF FF 9A E8 00 9F E5 C4 10 9F E5 82 20 A0 E3 C0 30 9F E5 ?? ?? ?? ?? 6E 00 53 E3 AF FF FF 9A D0 00 9F E5 A8 10 9F E5 81 20 A0 E3 A4 30 9F E5 ?? ?? ?? ?? 05 00 53 E3 A8 FF FF 9A B8 00 9F E5 8C 10 9F E5 80 20 A0 E3 88 30 9F E5 ?? ?? ?? ?? 00 00 54 E3 13 00 00 1A 46 00 53 E3 A3 FF FF 8A 9E FF FF EA 94 00 9F E5 64 10 9F E5 8A 20 A0 E3 60 30 9F E5 ?? ?? ?? ?? 84 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 00 00 A0 E3 6B FF FF EA 03 00 12 E3 9E FF FF 1A 02 20 95 E7 24 20 81 E5 93 FF FF EA 58 00 9F E5 20 10 9F E5 8C 20 A0 E3 1C 30 9F E5 ?? ?? ?? ?? 15 11 03 20 ?? ?? ?? ?? 20 07 09 20 17 10 05 20 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_191_1_0 {
	meta:
		name = "_nl_load_locale"
		size = 804
		refs = "0050 __fxstat64 0070 __aeabi_read_tp 0098 __mmap 00cc _nl_intern_locale_data 011c __munmap 0140 malloc 01e8 strlen 0214 mempcpy 0238 memcpy 02b4 free 02f8 __libc_errno 0308 _nl_category_name_sizes 0310 _nl_category_name_idxs 0314 _nl_category_names"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 74 D0 4D E2 01 20 A0 E3 00 30 A0 E3 00 50 A0 E1 01 80 A0 E1 0C 00 80 E9 02 17 A0 E3 00 00 90 E5 05 70 A0 E3 00 00 00 EF 01 0A 70 E3 00 40 A0 E1 2D 00 00 8A 00 00 50 E3 28 00 00 BA 8C 20 4B E2 03 00 A0 E3 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 86 00 00 BA 7C 30 1B E5 0F 3A 03 E2 01 09 53 E3 59 00 00 0A 84 32 9F E5 ?? ?? ?? ?? 03 30 9F E7 00 70 A0 E3 03 90 90 E7 5C 10 1B E5 00 A0 A0 E1 90 00 8D E8 07 00 A0 E1 01 20 A0 E3 02 30 A0 E3 ?? ?? ?? ?? 01 00 70 E3 00 60 A0 E1 1E 00 00 0A 01 90 A0 E3 04 00 A0 E1 06 70 A0 E3 00 00 00 EF 00 00 56 E3 09 00 00 0A 08 00 A0 E1 06 10 A0 E1 5C 20 1B E5 ?? ?? ?? ?? 00 00 50 E3 00 30 A0 13 0C 90 80 15 00 30 80 15 08 00 85 15 08 00 00 0A 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 00 32 9F E5 00 40 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 40 80 E7 F6 FF FF EA 01 00 59 E3 F4 FF FF 1A 06 00 A0 E1 5C 10 1B E5 ?? ?? ?? ?? F0 FF FF EA D4 31 9F E5 03 30 9F E7 03 30 9A E7 26 00 53 E3 5B 00 00 1A 5C 70 1B E5 07 00 A0 E1 ?? ?? ?? ?? 00 60 50 E2 4E 00 00 0A 00 30 57 E2 19 00 00 DA 04 00 A0 E1 06 10 A0 E1 03 20 A0 E1 03 70 A0 E3 00 00 00 EF 01 0A 70 E3 00 A0 A0 E1 58 00 00 8A 00 00 50 E3 06 C0 A0 C1 06 00 00 CA 4A 00 00 EA 00 00 00 EF 01 0A 70 E3 00 A0 A0 E1 50 00 00 8A 00 00 50 E3 44 00 00 DA 03 30 6A E0 0A C0 8C E0 00 00 53 E3 04 00 A0 E1 03 20 A0 E1 03 70 A0 E3 0C 10 A0 E1 F1 FF FF CA 40 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 90 80 E7 00 90 A0 E3 B5 FF FF EA 04 00 A0 E1 06 70 A0 E3 00 00 00 EF 00 70 95 E5 07 00 A0 E1 ?? ?? ?? ?? 14 31 9F E5 08 60 D3 E7 00 30 86 E0 14 30 83 E2 07 30 C3 E3 03 D0 4D E0 08 40 8D E2 00 20 A0 E1 07 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? EC 10 9F E5 05 20 A0 E3 ?? ?? ?? ?? E4 30 9F E5 E4 10 9F E5 08 30 D3 E7 01 20 86 E2 03 10 81 E0 ?? ?? ?? ?? 05 70 A0 E3 04 00 A0 E1 02 17 A0 E3 00 00 00 EF 01 0A 70 E3 00 40 A0 E1 0D 00 00 8A 00 00 50 E3 A1 FF FF BA 8C 20 4B E2 03 00 A0 E3 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 7C FF FF AA 04 00 A0 E1 06 70 A0 E3 00 00 00 EF 97 FF FF EA 06 90 A0 E1 86 FF FF EA 80 30 9F E5 00 40 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 40 80 E7 8F FF FF EA 07 60 A0 E1 7D FF FF EA 06 00 A0 E1 ?? ?? ?? ?? 00 00 5A E3 ED FF FF 1A 54 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 E7 FF FF EA 40 30 9F E5 ?? ?? ?? ?? 00 A0 6A E2 03 30 9F E7 03 A0 80 E7 06 00 A0 E1 ?? ?? ?? ?? DF FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_191_2_0 {
	meta:
		name = "_nl_unload_locale"
		size = 104
		refs = "0034 free 004c __munmap"
	strings:
		$1 = { 10 30 90 E5 00 00 53 E3 10 40 2D E9 00 40 A0 E1 0F E0 A0 11 ?? ?? ?? ?? 0C 30 94 E5 00 00 53 E3 0C 00 00 0A 01 00 53 E3 06 00 00 0A 02 00 53 E3 00 00 94 15 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 10 40 BD E8 ?? ?? ?? ?? 03 00 94 E9 ?? ?? ?? ?? 0C 30 94 E5 F4 FF FF EA 04 00 94 E5 ?? ?? ?? ?? 0C 30 94 E5 F0 FF FF EA }
	condition:
		$1
}

rule file_192_1_0 {
	meta:
		name = "__strtold_l"
		size = 24
		refs = "000c ____strtod_l_internal"
	strings:
		$1 = { 08 40 2D E9 02 30 A0 E1 00 20 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1410_1_0 {
	meta:
		name = "__wcstold_l"
		size = 24
		refs = "000c ____wcstod_l_internal"
	strings:
		$1 = { 08 40 2D E9 02 30 A0 E1 00 20 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_193_0_0 {
	meta:
		name = "getutmp"
		size = 32
		refs = "0014 memcpy"
	strings:
		$1 = { 08 40 2D E9 00 30 A0 E1 06 2D A0 E3 01 00 A0 E1 03 10 A0 E1 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_194_0_0 {
	meta:
		name = "__sysv_signal"
		size = 156
		refs = "0040 memset 0058 __sigaction 0078 __aeabi_read_tp 0098 __libc_errno"
	strings:
		$1 = { 30 40 2D E9 01 00 71 E3 00 30 A0 13 01 30 A0 03 01 20 40 E2 3F 00 52 E3 01 30 83 83 00 00 53 E3 47 DF 4D E2 00 40 A0 E1 11 00 00 1A 46 5F 8D E2 18 11 25 E5 04 00 8D E2 03 10 A0 E1 80 20 A0 E3 ?? ?? ?? ?? 0E 32 A0 E3 0D 10 A0 E1 04 00 A0 E1 8C 20 8D E2 84 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 8C 00 9D A5 00 00 E0 B3 47 DF 8D E2 30 40 BD E8 ?? ?? ?? ?? 1C 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 00 00 E0 E3 47 DF 8D E2 30 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_196_0_0 {
	meta:
		name = "__getsockopt"
		size = 32
		refs = "001c __syscall_error"
		altNames = "__setsockopt name_to_handle_at"
	strings:
		$1 = { 90 00 2D E9 08 40 9D E5 10 70 9F E5 00 00 00 EF 90 00 BD E8 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_197_0_0 {
	meta:
		name = "posix_spawnattr_setschedpolicy"
		size = 20
	strings:
		$1 = { 02 00 51 E3 0C 11 80 95 00 00 A0 93 16 00 A0 83 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_199_0_0 {
	meta:
		name = "erand48"
		size = 40
		refs = "0010 __erand48_r 0024 __libc_drand48_data"
	strings:
		$1 = { 04 E0 2D E5 0C D0 4D E2 14 10 9F E5 0D 20 A0 E1 ?? ?? ?? ?? 03 00 9D E8 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_200_0_0 {
	meta:
		name = "__fstat"
		size = 28
		refs = "0010 __fxstat"
		altNames = "fstat64"
	strings:
		$1 = { 08 40 2D E9 01 20 A0 E1 00 10 A0 E1 03 00 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_808_0_0 {
	meta:
		name = "__lstat"
		size = 28
		refs = "0010 __lxstat"
	strings:
		$1 = { 08 40 2D E9 01 20 A0 E1 00 10 A0 E1 03 00 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_959_0_0 {
	meta:
		name = "__stat"
		size = 28
		refs = "0010 __xstat"
	strings:
		$1 = { 08 40 2D E9 01 20 A0 E1 00 10 A0 E1 03 00 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_989_0_0 {
	meta:
		name = "drand48_r"
		size = 24
		refs = "000c __erand48_r"
	strings:
		$1 = { 08 40 2D E9 01 20 A0 E1 00 10 A0 E1 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_598_0_0 {
	meta:
		name = "lstat64"
		size = 28
		refs = "0010 __lxstat64"
	strings:
		$1 = { 08 40 2D E9 01 20 A0 E1 00 10 A0 E1 03 00 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_609_0_0 {
	meta:
		name = "stat64"
		size = 28
		refs = "0010 __xstat64"
	strings:
		$1 = { 08 40 2D E9 01 20 A0 E1 00 10 A0 E1 03 00 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_202_0_0 {
	meta:
		name = "_IO_obstack_xsputn"
		size = 168
		refs = "0050 memcpy 0088 _obstack_newchunk 0094 mempcpy"
	strings:
		$1 = { F8 40 2D E9 00 50 A0 E1 14 00 90 E5 18 30 95 E5 02 C0 80 E0 0C 00 53 E1 02 60 A0 E1 A0 40 95 E5 01 70 A0 E1 1A 00 00 2A 0C 20 94 E5 00 00 63 E0 00 00 82 E0 10 20 94 E5 06 30 80 E0 03 00 52 E1 0C 00 84 E5 0D 00 00 3A 07 10 A0 E1 06 20 A0 E1 ?? ?? ?? ?? 0C 10 94 E5 10 30 94 E5 08 20 94 E5 06 10 81 E0 14 10 85 E5 10 20 85 E5 18 30 85 E5 06 00 A0 E1 0C 30 84 E5 F8 40 BD E8 ?? ?? ?? ?? 04 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 0C 00 94 E5 EC FF FF EA ?? ?? ?? ?? 14 00 85 E5 06 00 A0 E1 F8 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_202_1_0 {
	meta:
		name = "_IO_obstack_overflow"
		size = 140
		refs = "0034 _obstack_newchunk 007c __assert_fail"
	strings:
		$1 = { 01 00 71 E3 70 40 2D E9 01 60 A0 E1 00 50 A0 E1 A0 40 90 E5 14 00 00 0A 0C 30 94 E5 10 10 94 E5 01 20 83 E2 01 00 52 E1 04 00 00 9A 04 00 A0 E1 01 10 A0 E3 ?? ?? ?? ?? 0C 30 94 E5 01 20 83 E2 0C 20 84 E5 00 60 C3 E5 08 10 84 E2 0E 00 91 E8 06 00 A0 E1 10 10 85 E5 14 20 85 E5 18 30 85 E5 0C 30 84 E5 70 40 BD E8 ?? ?? ?? ?? 0C 00 9F E5 0C 10 9F E5 2F 20 A0 E3 08 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_202_2_0 {
	meta:
		name = "_IO_obstack_vprintf"
		size = 348
		refs = "0030 _IO_no_init 006c _IO_str_init_static_internal 00b8 _IO_vfprintf 00f4 _obstack_newchunk 0118 __assert_fail"
	strings:
		$1 = { F0 41 2D E9 00 C0 A0 E3 B0 D0 4D E2 00 40 A0 E1 0C 30 A0 E1 08 00 8D E2 01 70 A0 E1 02 60 A0 E1 02 19 A0 E3 00 20 E0 E3 00 C0 8D E5 50 C0 8D E5 ?? ?? ?? ?? 08 00 84 E2 29 00 90 E8 00 21 9F E5 00 10 55 E0 A0 20 8D E5 05 50 63 E0 23 00 00 1A 3F 00 55 E3 24 00 00 DA 08 00 94 E5 05 80 A0 E1 00 10 A0 E1 05 20 A0 E1 08 00 8D E2 ?? ?? ?? ?? 18 30 9D E5 20 20 9D E5 02 20 63 E0 05 00 52 E1 2A 00 00 1A 08 00 84 E2 05 00 90 E8 1C 10 9D E5 02 00 60 E0 00 30 83 E0 03 00 51 E1 1E 00 00 1A 08 80 82 E0 07 10 A0 E1 06 20 A0 E1 0C 80 84 E5 08 00 8D E2 A8 40 8D E5 ?? ?? ?? ?? 1C 10 8D E2 0A 00 91 E8 0C 20 94 E5 01 30 63 E0 03 30 82 E0 0C 30 84 E5 B0 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 05 80 A0 E1 01 50 A0 E1 DC FF FF EA 04 00 A0 E1 40 10 A0 E3 ?? ?? ?? ?? 0C 30 84 E2 28 00 93 E8 03 50 55 E0 D3 FF FF 1A 38 00 9F E5 38 10 9F E5 97 20 A0 E3 34 30 9F E5 ?? ?? ?? ?? 30 00 9F E5 24 10 9F E5 A2 20 A0 E3 20 30 9F E5 ?? ?? ?? ?? 20 00 9F E5 10 10 9F E5 9F 20 A0 E3 0C 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_203_0_0 {
	meta:
		name = "skip"
		size = 240
	strings:
		$1 = { 00 30 D0 E5 00 00 53 E3 00 20 A0 E1 1C 00 00 0A 00 10 A0 E3 0C 00 00 EA 00 C0 D0 E5 23 00 53 E3 00 C0 C2 E5 01 20 82 E2 2A 00 00 0A 09 C0 43 E2 20 00 53 E3 01 00 5C 13 19 00 00 9A 01 30 D0 E5 00 00 53 E3 01 00 80 E2 0D 00 00 0A 22 00 53 E3 01 10 21 02 F8 FF FF 0A 01 00 51 E3 ED FF FF 1A 5C 00 53 E3 09 00 00 0A 00 30 D0 E5 00 30 C2 E5 01 30 D0 E5 00 00 53 E3 01 20 82 E2 01 00 80 E2 F1 FF FF 1A 00 30 A0 E3 01 30 42 E5 ?? ?? ?? ?? 01 30 D0 E5 22 00 53 E3 01 00 80 02 F1 FF FF 1A F1 FF FF EA 40 C0 9F E5 00 10 A0 E1 00 00 A0 E3 01 00 C1 E4 00 30 CC E5 01 00 A0 E1 01 30 D1 E4 09 C0 43 E2 01 00 5C E3 FA FF FF 9A 20 00 53 E3 F8 FF FF 0A EA FF FF EA 0C C0 9F E5 00 10 A0 E3 00 30 CC E5 00 10 C0 E5 E5 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_203_1_0 {
	meta:
		name = "setttyent"
		size = 92
		refs = "0014 rewind 002c _IO_new_fopen"
	strings:
		$1 = { 10 40 2D E9 44 40 9F E5 04 00 94 E5 00 00 50 E3 03 00 00 0A ?? ?? ?? ?? 01 00 A0 E3 10 40 BD E8 ?? ?? ?? ?? 28 00 9F E5 28 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 00 30 90 15 02 39 83 13 04 00 84 E5 00 30 80 15 10 40 BD E8 01 00 A0 13 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_203_2_0 {
	meta:
		name = "getttyent"
		size = 848
		refs = "0024 fgets_unlocked 0038 strchr 0044 __aeabi_read_tp 00d0 __uflow 00dc setttyent 01a4 strncmp 0324 __libc_tsd_CTYPE_B"
	strings:
		$1 = { F0 41 2D E9 14 43 9F E5 04 20 94 E5 00 00 52 E3 31 00 00 0A 04 53 9F E5 04 63 9F E5 04 03 9F E5 64 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 2E 00 00 0A F0 02 9F E5 0A 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 14 00 00 0A ?? ?? ?? ?? 06 30 9F E7 08 20 D5 E5 03 C0 90 E7 82 30 A0 E1 B3 30 9C E1 02 0A 13 E3 C0 E2 9F 05 06 00 00 0A BC 32 9F E5 03 E0 A0 E1 01 20 D3 E4 82 10 A0 E1 B1 10 9C E1 02 0A 11 E3 F9 FF FF 1A 23 00 52 E3 00 00 52 13 19 00 00 1A 04 20 94 E5 E0 FF FF EA 04 20 95 E5 06 00 00 EA 01 10 83 E2 04 10 82 E5 00 00 D3 E5 0A 00 50 E3 D9 FF FF 0A 01 00 70 E3 D7 FF FF 0A 04 30 92 E5 08 10 92 E5 01 00 53 E1 F4 FF FF 3A 02 00 A0 E1 ?? ?? ?? ?? 04 20 94 E5 F3 FF FF EA ?? ?? ?? ?? 00 00 50 E3 04 20 94 15 C9 FF FF 1A 00 00 A0 E3 F0 41 BD E8 ?? ?? ?? ?? 00 30 A0 E3 0E 00 A0 E1 00 30 C4 E5 6C E0 84 E5 69 FF FF EB 70 00 84 E5 00 30 D0 E5 00 00 53 E3 00 50 A0 E1 FC 61 9F E5 70 00 00 1A 74 30 86 E5 70 30 86 E5 00 30 A0 E3 78 30 84 E5 7C 30 84 E5 00 60 D5 E5 03 00 56 E1 72 00 00 0A E4 81 9F E5 E4 71 9F E5 11 00 00 EA E0 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 20 D5 E5 03 30 90 E7 82 20 A0 E1 B2 30 93 E1 02 0A 13 E3 0E 00 00 0A 78 30 94 E5 01 30 C3 E3 78 30 84 E5 05 00 A0 E1 4A FF FF EB 00 60 D0 E5 00 00 56 E3 00 50 A0 E1 5D 00 00 0A 05 00 A0 E1 98 11 9F E5 03 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 E7 FF FF 0A 05 00 A0 E1 84 11 9F E5 02 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 0A 00 00 1A ?? ?? ?? ?? 02 30 D5 E5 07 20 9F E7 02 20 90 E7 83 30 A0 E1 B3 30 92 E1 02 0A 13 E3 78 30 94 15 01 30 83 13 78 30 84 15 E2 FF FF 1A 05 00 A0 E1 44 11 9F E5 06 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 0A 00 00 1A ?? ?? ?? ?? 06 30 D5 E5 08 20 9F E7 02 20 90 E7 83 30 A0 E1 B3 30 92 E1 02 0A 13 E3 78 30 94 15 02 30 83 13 78 30 84 15 D1 FF FF 1A 05 00 A0 E1 04 11 9F E5 06 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 09 00 00 1A 06 10 D5 E5 3D 00 51 E3 06 00 00 1A 05 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 01 30 80 12 00 30 A0 01 7C 30 84 E5 C1 FF FF EA 00 30 D4 E5 23 00 53 E3 10 00 00 0A 23 00 56 E3 0E 00 00 0A 80 50 84 E5 00 30 D5 E5 84 20 9F E5 00 00 53 E3 05 00 A0 E1 0A 10 A0 E3 80 30 82 05 ?? ?? ?? ?? 00 00 50 E3 00 30 A0 13 00 30 C0 15 8C 00 9F E5 F0 41 BD E8 ?? ?? ?? ?? 03 50 A0 E1 01 20 D5 E5 01 30 85 E2 20 00 52 E3 03 50 A0 E1 F9 FF FF 0A 09 00 52 E3 F7 FF FF 0A E8 FF FF EA F1 FE FF EB 74 00 86 E5 00 30 D0 E5 00 00 53 E3 00 50 A0 E1 74 30 86 05 89 FF FF 0A EA FE FF EB 00 50 A0 E1 86 FF FF EA 00 30 D4 E5 23 00 53 E3 DB FF FF 1A E9 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_203_3_0 {
	meta:
		name = "endttyent"
		size = 56
		refs = "0018 _IO_new_fclose"
	strings:
		$1 = { 10 40 2D E9 28 40 9F E5 04 00 94 E5 00 00 50 E3 01 00 A0 03 04 00 00 0A ?? ?? ?? ?? 00 30 A0 E3 01 00 90 E2 04 30 84 E5 01 00 A0 13 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_203_4_0 {
	meta:
		name = "getttynam"
		size = 64
		refs = "0008 setttyent 0014 strcmp 0020 getttyent 0030 endttyent"
	strings:
		$1 = { 38 40 2D E9 00 50 A0 E1 ?? ?? ?? ?? 03 00 00 EA 00 10 94 E5 ?? ?? ?? ?? 00 00 50 E3 03 00 00 0A ?? ?? ?? ?? 00 40 50 E2 05 00 A0 E1 F7 FF FF 1A ?? ?? ?? ?? 04 00 A0 E1 38 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_204_0_0 {
	meta:
		name = "quotactl"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 83 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_205_0_0 {
	meta:
		name = "__strchrnul"
		size = 284
	strings:
		$1 = { 03 00 10 E3 F0 00 2D E9 FF 10 01 E2 0E 00 00 0A 00 30 D0 E5 01 00 53 E1 35 00 00 0A 00 00 53 E3 33 00 00 0A 01 30 80 E2 04 00 00 EA 01 20 D3 E4 01 00 52 E1 2E 00 00 0A 00 00 52 E3 2C 00 00 0A 03 00 13 E3 03 00 A0 E1 F7 FF FF 1A 01 64 81 E1 06 68 86 E1 04 30 40 E2 12 00 00 EA 00 00 5C E3 23 00 00 0A 01 C0 D3 E5 01 00 5C E1 01 40 80 E2 21 00 00 0A 00 00 5C E3 1F 00 00 0A 02 C0 D3 E5 01 00 5C E1 1E 00 00 0A 00 00 5C E3 1C 00 00 0A 03 C0 D3 E5 01 00 5C E1 1B 00 00 0A 00 00 5C E3 19 00 00 0A 02 00 A0 E1 04 40 B3 E5 60 C0 9F E5 04 50 26 E0 0C 20 A0 E1 05 70 E0 E1 0C C0 85 E0 02 20 84 E0 04 50 E0 E1 02 40 25 E0 0C C0 27 E0 40 20 9F E5 04 C0 8C E1 02 20 0C E0 00 00 52 E3 04 20 80 E2 EE FF FF 0A 04 C0 52 E5 01 00 5C E1 D9 FF FF 1A F0 00 BD E8 ?? ?? ?? ?? 04 00 A0 E1 FB FF FF EA 02 00 80 E2 F9 FF FF EA 03 00 80 E2 F7 FF FF EA FF FE FE 7E 00 01 01 81 }
	condition:
		$1
}

rule file_206_0_0 {
	meta:
		name = "__waitid"
		size = 196
		refs = "0044 __libc_enable_asynccancel 0078 __libc_disable_asynccancel 008c __aeabi_read_tp 00b8 __libc_multiple_threads 00bc __libc_errno"
	strings:
		$1 = { B0 C0 9F E5 F8 43 2D E9 00 40 9C E5 00 00 54 E3 00 80 A0 E1 01 70 A0 E1 02 60 A0 E1 03 50 A0 E1 07 00 00 1A 46 7F A0 E3 00 00 00 EF 01 0A 70 E3 12 00 00 8A 00 40 A0 E1 04 00 A0 E1 F8 43 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 00 40 A0 E3 00 90 A0 E1 07 10 A0 E1 08 00 A0 E1 06 20 A0 E1 05 30 A0 E1 46 7F A0 E3 00 00 00 EF 01 0A 70 E3 00 40 A0 E1 09 00 00 8A 09 00 A0 E1 ?? ?? ?? ?? ED FF FF EA 34 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 E5 FF FF EA 1C 30 9F E5 00 40 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 40 80 E7 00 40 E0 E3 EE FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_207_0_0 {
	meta:
		name = "__snprintf"
		size = 48
		refs = "001c _IO_vsnprintf"
	strings:
		$1 = { 0C 00 2D E9 04 E0 2D E5 0C D0 4D E2 14 C0 8D E2 0C 30 A0 E1 10 20 9D E5 04 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 08 D0 8D E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_214_0_0 {
	meta:
		name = "__asprintf_chk"
		size = 48
		refs = "001c __vasprintf_chk"
	strings:
		$1 = { 0C 00 2D E9 04 E0 2D E5 0C D0 4D E2 14 C0 8D E2 0C 30 A0 E1 10 20 9D E5 04 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 08 D0 8D E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1074_0_0 {
	meta:
		name = "__dprintf_chk"
		size = 48
		refs = "001c __vdprintf_chk"
	strings:
		$1 = { 0C 00 2D E9 04 E0 2D E5 0C D0 4D E2 14 C0 8D E2 0C 30 A0 E1 10 20 9D E5 04 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 08 D0 8D E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1396_1_0 {
	meta:
		name = "__obstack_printf_chk"
		size = 48
		refs = "001c __obstack_vprintf_chk"
	strings:
		$1 = { 0C 00 2D E9 04 E0 2D E5 0C D0 4D E2 14 C0 8D E2 0C 30 A0 E1 10 20 9D E5 04 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 08 D0 8D E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1433_0_0 {
	meta:
		name = "__swprintf"
		size = 48
		refs = "001c __vswprintf"
	strings:
		$1 = { 0C 00 2D E9 04 E0 2D E5 0C D0 4D E2 14 C0 8D E2 0C 30 A0 E1 10 20 9D E5 04 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 08 D0 8D E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_895_5_0 {
	meta:
		name = "__syslog_chk"
		size = 48
		refs = "001c __vsyslog_chk"
	strings:
		$1 = { 0C 00 2D E9 04 E0 2D E5 0C D0 4D E2 14 C0 8D E2 0C 30 A0 E1 10 20 9D E5 04 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 08 D0 8D E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_208_0_0 {
	meta:
		name = "wcwidth"
		size = 144
		refs = "0010 __aeabi_read_tp 008c _nl_current_LC_CTYPE"
	strings:
		$1 = { 04 E0 2D E5 80 30 9F E5 00 10 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 30 90 E7 00 30 93 E5 54 30 93 E5 00 20 93 E5 31 22 A0 E1 04 00 93 E5 00 00 52 E1 03 00 00 2A 05 20 82 E2 02 21 93 E7 00 00 52 E3 02 00 00 1A 00 00 E0 E3 04 E0 9D E4 ?? ?? ?? ?? 08 C0 93 E5 0C 00 93 E5 31 0C 00 E0 00 21 82 E0 02 20 93 E7 00 00 52 E3 F5 FF FF 0A 10 00 93 E5 02 30 83 E0 00 10 01 E0 01 00 D3 E7 FF 00 50 E3 00 00 E0 03 04 E0 9D E4 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_210_0_0 {
	meta:
		name = "__fcvt"
		size = 172
		refs = "0048 __fcvt_r 008c malloc"
	strings:
		$1 = { F0 43 2D E9 98 60 9F E5 00 C0 96 E5 14 D0 4D E2 00 00 5C E3 00 40 A0 E1 01 50 A0 E1 02 90 A0 E1 03 80 A0 E1 30 70 9D E5 0B 00 00 0A 52 EF A0 E3 80 10 8D E8 04 00 A0 E1 05 10 A0 E1 09 20 A0 E1 08 30 A0 E1 08 E0 8D E5 ?? ?? ?? ?? 00 00 96 E5 14 D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 44 E0 9F E5 14 C0 A0 E3 80 40 8D E8 08 C0 8D E5 ?? ?? ?? ?? 01 00 70 E3 03 00 00 0A 28 00 9F E5 14 D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 52 0F A0 E3 ?? ?? ?? ?? 00 00 50 E3 00 00 86 E5 F6 FF FF 0A 00 C0 A0 E1 E1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_210_1_0 {
	meta:
		name = "__ecvt"
		size = 52
		refs = "001c __ecvt_r"
	strings:
		$1 = { 10 40 2D E9 10 D0 4D E2 18 E0 9D E5 1C 40 9F E5 14 C0 A0 E3 00 E0 8D E5 10 10 8D E9 ?? ?? ?? ?? 04 00 A0 E1 10 D0 8D E2 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_210_2_0 {
	meta:
		name = "__gcvt"
		size = 56
		refs = "0020 sprintf"
		altNames = "__qgcvt"
	strings:
		$1 = { 10 40 2D E9 08 D0 4D E2 03 00 8D E8 11 00 52 E3 11 20 A0 A3 03 00 A0 E1 14 10 9F E5 03 40 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 08 D0 8D E2 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_211_0_0 {
	meta:
		name = "ualarm"
		size = 88
		refs = "0028 __setitimer"
	strings:
		$1 = { 04 E0 2D E5 00 30 A0 E3 24 D0 4D E2 10 20 8D E2 0C 00 8D E5 04 10 8D E5 03 00 A0 E1 0D 10 A0 E1 08 30 8D E5 00 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 18 30 9D A5 83 02 63 A0 00 03 60 A0 1C 20 9D A5 80 01 83 A0 00 03 82 A0 00 00 E0 B3 24 D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_212_2_0 {
	meta:
		name = "svcraw_freeargs"
		size = 76
		refs = "000c __rpc_thread_variables"
	strings:
		$1 = { 38 40 2D E9 01 40 A0 E1 02 50 A0 E1 ?? ?? ?? ?? B8 30 90 E5 00 00 53 E3 03 00 A0 01 07 00 00 0A 20 20 9F E5 02 C0 A0 E3 8E 0D 83 E2 05 10 A0 E1 02 C0 83 E7 14 00 80 E2 0F E0 A0 E1 ?? ?? ?? ?? 38 40 BD E8 ?? ?? ?? ?? 94 23 00 00 }
	condition:
		$1
}

rule file_212_3_0 {
	meta:
		name = "svcraw_getargs"
		size = 52
		refs = "000c __rpc_thread_variables"
	strings:
		$1 = { 38 40 2D E9 01 40 A0 E1 02 50 A0 E1 ?? ?? ?? ?? B8 00 90 E5 00 00 50 E3 8E 0D 80 12 14 00 80 12 05 10 A0 11 0F E0 A0 11 ?? ?? ?? ?? 38 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_212_4_0 {
	meta:
		name = "svcraw_reply"
		size = 136
		refs = "0008 __rpc_thread_variables 004c xdr_replymsg"
	strings:
		$1 = { 38 40 2D E9 01 50 A0 E1 ?? ?? ?? ?? B8 30 90 E5 00 00 53 E3 0F 00 00 0A 8E 4D 83 E2 60 10 9F E5 18 C0 94 E5 00 20 A0 E3 14 40 84 E2 01 20 83 E7 04 00 A0 E1 02 10 A0 E1 14 C0 9C E5 0F E0 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 02 00 00 1A 00 00 A0 E3 38 40 BD E8 ?? ?? ?? ?? 04 30 94 E5 04 00 A0 E1 10 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 01 00 A0 E3 38 40 BD E8 ?? ?? ?? ?? 94 23 00 00 }
	condition:
		$1
}

rule file_212_5_0 {
	meta:
		name = "svcraw_recv"
		size = 104
		refs = "0008 __rpc_thread_variables 0050 xdr_callmsg"
	strings:
		$1 = { 38 40 2D E9 01 50 A0 E1 ?? ?? ?? ?? B8 30 90 E5 00 00 53 E3 03 00 A0 01 0F 00 00 0A 8E 4D 83 E2 3C 10 9F E5 18 20 94 E5 01 C0 A0 E3 14 40 84 E2 01 C0 83 E7 04 00 A0 E1 00 10 A0 E3 14 C0 92 E5 0F E0 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 00 90 E2 01 00 A0 13 38 40 BD E8 ?? ?? ?? ?? 94 23 00 00 }
	condition:
		$1
}

rule file_212_6_0 {
	meta:
		name = "svcraw_create"
		size = 152
		refs = "0004 __rpc_thread_variables 0054 xdrmem_create 006c calloc"
	strings:
		$1 = { 70 40 2D E9 ?? ?? ?? ?? B8 40 90 E5 00 00 54 E3 13 00 00 0A 8E 0D 84 E2 60 20 9F E5 60 E0 9F E5 60 10 9F E5 60 C0 9F E5 60 50 9F E5 00 30 A0 E3 2C 60 80 E2 05 60 84 E7 14 00 80 E2 02 30 84 E7 BE 30 84 E1 01 C0 84 E7 02 30 A0 E3 04 10 A0 E1 89 4D 84 E2 ?? ?? ?? ?? 20 00 84 E2 70 40 BD E8 ?? ?? ?? ?? 01 00 A0 E3 24 10 9F E5 ?? ?? ?? ?? 00 40 50 E2 E6 FF FF 1A 04 00 A0 E1 F6 FF FF EA 60 22 00 00 64 22 00 00 68 22 00 00 ?? ?? ?? ?? 84 22 00 00 3C 25 00 00 }
	condition:
		$1
}

rule file_213_0_0 {
	meta:
		name = "raise"
		size = 132
		refs = "0008 __aeabi_read_tp 0080 __libc_errno"
	strings:
		$1 = { 80 40 2D E9 00 20 A0 E1 ?? ?? ?? ?? 58 14 10 E5 00 00 51 E3 00 C0 A0 E1 54 04 10 E5 09 00 00 1A E0 70 A0 E3 00 00 00 EF 58 04 0C E5 00 10 A0 E1 43 7F A0 E3 00 00 00 EF 01 0A 70 E3 08 00 00 8A 80 40 BD E8 ?? ?? ?? ?? 00 00 50 E3 F7 FF FF CA 02 31 C0 E3 00 00 53 E3 00 00 60 12 01 00 A0 01 F2 FF FF EA 14 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 EF FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_215_0_0 {
	meta:
		name = "plural_eval"
		size = 452
		refs = "01a4 __aeabi_uidivmod 01b4 __aeabi_uidiv"
	strings:
		$1 = { F8 40 2D E9 00 40 A0 E1 01 50 A0 E1 00 30 94 E5 03 00 53 E3 03 F1 9F 97 43 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 08 00 94 E5 05 10 A0 E1 F1 FF FF EB 00 00 50 E3 03 00 A0 13 04 00 A0 03 00 41 94 E7 EF FF FF EA 08 00 94 E5 05 10 A0 E1 E9 FF FF EB 04 60 94 E5 0F 00 56 E3 00 70 A0 E1 19 00 00 0A 0E 00 56 E3 1B 00 00 1A 00 00 50 E3 00 00 A0 01 0A 00 00 0A 0C 00 94 E5 05 10 A0 E1 DD FF FF EB 00 00 90 E2 01 00 A0 13 04 00 00 EA 08 00 94 E5 05 10 A0 E1 D7 FF FF EB 01 00 70 E2 00 00 A0 33 F8 40 BD E8 ?? ?? ?? ?? 04 30 94 E5 00 00 53 E3 05 00 A0 01 F9 FF FF 0A 01 00 53 E3 18 00 00 1A 08 00 94 E5 F5 FF FF EA 00 00 50 E3 01 00 A0 13 F2 FF FF 1A E6 FF FF EA 05 10 A0 E1 0C 00 94 E5 C4 FF FF EB 03 60 46 E2 00 10 A0 E1 0A 00 56 E3 06 F1 9F 97 0A 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 A0 E3 DC FF FF EA 00 00 57 E0 01 00 A0 13 D9 FF FF EA 00 30 57 E0 00 00 73 E2 03 00 B0 E0 D5 FF FF EA 00 00 57 E1 00 00 A0 33 01 00 A0 23 D1 FF FF EA 00 00 57 E1 00 00 A0 83 01 00 A0 93 CD FF FF EA 00 00 57 E1 00 00 A0 93 01 00 A0 83 C9 FF FF EA 00 00 57 E1 00 00 A0 23 01 00 A0 33 C5 FF FF EA 07 00 60 E0 C3 FF FF EA 07 00 80 E0 C1 FF FF EA 07 00 A0 E1 ?? ?? ?? ?? 01 00 A0 E1 BD FF FF EA 07 00 A0 E1 ?? ?? ?? ?? BA FF FF EA 97 01 00 E0 B8 FF FF EA }
	condition:
		$1
}

rule file_215_1_0 {
	meta:
		name = "transcmp"
		size = 112
		refs = "002c strcmp"
	strings:
		$1 = { 38 40 2D E9 10 30 90 E5 00 00 53 E3 10 30 91 E5 00 50 A0 E1 01 40 A0 E1 1C 00 80 12 1C 00 95 05 00 00 53 E3 1C 10 81 12 1C 10 94 05 ?? ?? ?? ?? 00 00 50 E3 0B 00 00 1A 00 00 95 E5 00 10 94 E5 ?? ?? ?? ?? 00 00 50 E3 06 00 00 1A 08 00 95 E5 08 10 94 E5 ?? ?? ?? ?? 00 00 50 E3 04 00 95 05 04 30 94 05 00 00 63 00 38 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_215_2_0 {
	meta:
		name = "plural_lookup.isra.1"
		size = 116
		refs = "0034 __rawmemchr"
	strings:
		$1 = { 70 40 2D E9 00 40 A0 E1 60 00 90 E5 02 60 A0 E1 03 50 A0 E1 6C FF FF EB 64 40 94 E5 04 00 50 E1 05 50 86 E0 00 40 A0 31 00 40 A0 23 06 C0 A0 E1 04 00 00 EA ?? ?? ?? ?? 01 C0 80 E2 05 00 5C E1 01 40 44 E2 06 00 00 2A 00 10 A0 E3 01 00 54 E1 0C 00 A0 E1 F6 FF FF 1A 0C 00 A0 E1 70 40 BD E8 ?? ?? ?? ?? 06 C0 A0 E1 0C 00 A0 E1 70 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_215_3_0 {
	meta:
		name = "_nl_find_msg"
		size = 2924
		refs = "004c strlen 0058 __hash_string 0068 __aeabi_uidivmod 0104 strcmp 020c __pthread_rwlock_rdlock 025c __pthread_rwlock_unlock 0390 _nl_load_domain 03cc __aeabi_read_tp 03f0 __pthread_rwlock_wrlock 04e8 realloc 0548 __gconv 0570 malloc 05a0 free 0600 getenv 0650 __strdup 0688 _nl_find_msg 06a0 strstr 070c mempcpy 080c __gconv_open 0954 memcpy 0a08 __lll_lock_wait_private 0b00 calloc 0b48 _nl_current_LC_CTYPE 0b64 _nl_C_locobj"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 3C D0 4D E2 04 C0 90 E5 00 00 5C E3 44 00 0B E5 02 80 A0 E1 48 30 0B E5 4C 10 0B E5 D9 00 00 DA 44 40 1B E5 08 60 94 E5 00 00 56 E3 9B 00 00 0A 30 20 96 E5 00 00 52 E3 14 70 96 E5 9B 00 00 0A 08 00 A0 E1 ?? ?? ?? ?? 00 90 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 2C 50 96 E5 05 10 A0 E1 00 A0 A0 E1 ?? ?? ?? ?? 0A 00 A0 E1 01 40 A0 E1 02 10 45 E2 ?? ?? ?? ?? 34 C0 96 E5 01 10 81 E2 05 20 61 E0 01 50 65 E0 38 20 0B E5 3C 10 0B E5 08 20 A0 E1 30 A0 96 E5 40 50 0B E5 0C 80 A0 E1 21 00 00 EA 0C 10 96 E5 18 00 96 E5 00 00 51 E3 85 C1 90 17 6C 38 2C 10 23 34 A0 11 FF 3C C3 13 85 31 90 07 6C 34 23 10 09 00 53 E1 28 00 00 3A 00 00 51 E3 85 01 80 E0 04 00 90 15 60 38 20 10 23 34 A0 11 FF 3C C3 13 00 10 96 E5 04 30 90 05 60 34 23 10 03 10 81 E0 02 00 A0 E1 50 20 0B E5 ?? ?? ?? ?? 01 00 70 E2 00 00 A0 33 00 00 50 E3 50 20 1B E5 19 00 00 1A 38 30 1B E5 03 00 54 E1 40 30 1B 25 3C 30 1B 35 03 40 84 E0 04 51 9A E7 00 00 58 E3 65 38 25 10 23 34 A0 11 FF 3C C3 13 65 54 23 10 00 00 55 E3 55 00 00 0A 01 50 45 E2 05 00 57 E1 D2 FF FF 8A 24 30 96 E5 05 10 67 E0 81 01 93 E7 00 00 59 E1 81 31 83 E0 04 10 93 35 E0 FF FF 3A 00 00 A0 E3 00 00 50 E3 E5 FF FF 0A 07 00 55 E1 68 00 00 2A 0C 30 96 E5 00 00 53 E3 1C 30 96 E5 00 10 96 E5 85 21 83 E0 73 00 00 0A 04 C0 92 E5 85 01 93 E7 6C 28 2C E0 60 38 20 E0 22 24 A0 E1 23 34 A0 E1 FF 2C C2 E3 FF 3C C3 E3 48 40 1B E5 6C 24 22 E0 60 34 23 E0 02 20 81 E0 01 30 83 E2 00 00 54 E3 38 20 0B E5 3C 30 0B E5 5B 00 00 0A 4C 30 1B E5 00 00 53 E3 6D 00 00 0A 08 40 93 E5 00 00 54 E3 6A 00 00 0A 34 39 9F E5 00 00 53 E3 40 00 86 12 ?? ?? ?? ?? 3C A0 96 E5 00 00 5A E3 61 00 00 0A 38 30 96 E5 8A 80 8A E0 08 81 83 E0 01 00 00 EA 00 00 5A E3 5B 00 00 0A 0C 00 18 E5 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0C 80 48 E2 01 A0 4A E2 F6 FF FF 1A E8 28 9F E5 00 00 52 E3 40 00 86 12 ?? ?? ?? ?? 00 00 58 E3 5E 00 00 0A 04 30 98 E5 01 00 73 E3 38 00 00 0A 08 40 98 E5 00 00 54 E3 EF 01 00 0A 01 00 74 E3 DA 00 00 0A 05 41 94 E7 00 00 54 E3 71 00 00 0A 00 30 94 E5 04 40 84 E2 3C 30 0B E5 38 40 0B E5 2B 00 00 EA 00 00 A0 E3 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 06 A0 A0 E1 3C 70 0B E5 02 60 A0 E1 38 80 0B E5 01 00 00 EA 31 00 00 0A 01 60 85 E2 06 00 57 E1 F2 FF FF 9A 00 40 9A E5 0C 90 9A E5 18 80 9A E5 06 50 87 E0 A5 50 A0 E1 85 31 88 E0 04 10 93 E5 00 00 59 E3 61 38 21 10 23 34 A0 11 FF 3C C3 13 61 14 23 10 38 00 1B E5 01 10 84 E0 ?? ?? ?? ?? 00 00 50 E3 EA FF FF AA 06 00 55 E1 DF FF FF 9A 05 70 A0 E1 ED FF FF EA 28 30 96 E5 05 20 67 E0 82 11 83 E0 04 10 91 E5 82 31 93 E7 38 10 0B E5 3C 30 0B E5 48 40 1B E5 00 00 54 E3 A3 FF FF 1A 3C 40 1B E5 04 20 9B E5 38 00 1B E5 00 40 82 E5 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 04 20 92 E5 85 91 93 E7 02 20 81 E0 01 90 89 E2 38 20 0B E5 3C 90 0B E5 EE FF FF EA ?? ?? ?? ?? 23 FF FF EA 0A 60 A0 E1 3C 70 1B E5 77 FF FF EA 0A 80 A0 E1 A8 FF FF EA 90 A7 9F E5 08 30 9A E5 00 00 53 E3 8F 00 00 0A 0C 40 9A E5 00 00 54 E3 8D FF FF 1A 78 37 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 00 30 93 E5 5C 40 93 E5 86 FF FF EA 60 37 9F E5 00 00 53 E3 40 00 86 12 ?? ?? ?? ?? 3C 90 96 E5 00 00 59 E3 38 30 96 05 40 30 0B 05 87 00 00 0A 38 20 96 E5 89 80 89 E0 40 20 0B E5 08 81 82 E0 09 A0 A0 E1 01 00 00 EA 00 00 5A E3 7F 00 00 0A 0C 00 18 E5 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0C 80 48 E2 01 A0 4A E2 F6 FF FF 1A F4 36 9F E5 00 00 53 E3 85 FF FF 0A 40 00 86 E2 ?? ?? ?? ?? 82 FF FF EA 01 10 A0 E3 E8 26 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 5C 01 00 1A AC A6 9F E5 14 30 9A E5 04 30 83 E2 38 40 1B E5 2C 30 0B E5 18 30 9A E5 30 40 0B E5 00 60 A0 E3 0A 40 A0 E1 40 50 0B E5 3C 90 1B E5 03 20 A0 E1 13 00 00 EA 00 00 56 E3 01 60 86 E2 06 24 66 E0 02 52 A0 E1 05 10 A0 E1 22 00 00 0A 04 70 9A E5 07 00 A0 E1 18 50 8A E5 ?? ?? ?? ?? 00 00 50 E3 4C 16 9F E5 26 00 00 0A 04 00 84 E5 04 20 45 E2 04 10 80 E2 08 30 80 E2 18 20 8A E5 14 10 8A E5 2C 30 0B E5 03 00 52 E3 E9 FF FF 9A 2C 10 1B E5 04 20 42 E2 30 30 1B E5 02 20 81 E0 04 00 98 E5 00 20 8D E5 28 20 4B E2 04 20 8D E5 30 10 4B E2 09 20 83 E0 2C 30 4B E2 ?? ?? ?? ?? 04 30 D0 E3 B6 00 00 0A 05 00 50 E3 DA 00 00 1A 38 20 1B E5 30 20 0B E5 D6 FF FF EA FF 0E A0 E3 18 00 8A E5 ?? ?? ?? ?? 00 00 50 E3 09 00 00 0A 04 10 94 E5 CC 25 9F E5 00 10 80 E5 04 00 84 E5 01 60 A0 E3 DA FF FF EA 00 30 97 E5 07 00 A0 E1 04 30 81 E5 ?? ?? ?? ?? 00 30 A0 E3 14 30 8A E5 18 30 8A E5 10 50 9A E5 00 10 A0 E3 05 40 A0 E1 8C 25 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 F9 00 00 CA 00 00 E0 E3 2B FF FF EA 54 05 9F E5 ?? ?? ?? ?? 00 10 50 E2 02 00 00 0A 00 30 D1 E5 00 00 53 E3 C6 00 00 1A 0C 40 9A E5 01 30 A0 E3 08 30 8A E5 65 FF FF EA 01 A0 89 E2 8A A0 8A E0 0A 81 A0 E1 40 00 1B E5 08 10 A0 E1 ?? ?? ?? ?? 00 A0 50 E2 34 01 00 0A 04 00 A0 E1 38 A0 86 E5 ?? ?? ?? ?? 00 40 50 E2 2F 01 00 0A 0C 30 48 E2 03 80 8A E0 00 20 E0 E3 28 C0 4B E2 03 40 8A E7 44 00 1B E5 04 20 88 E5 4C 10 1B E5 D8 24 9F E5 00 C0 8D E5 00 30 A0 E3 ?? ?? ?? ?? 01 00 70 E3 D7 FF FF 0A 00 00 50 E3 5E 00 00 0A BC 14 9F E5 ?? ?? ?? ?? 00 00 50 E3 5A 00 00 0A 08 30 D0 E5 DF 20 13 E2 08 10 80 E2 0E 00 00 0A 09 30 43 E2 01 00 53 E3 1A 01 00 9A 01 00 A0 E1 00 20 A0 E3 03 00 00 EA 20 00 53 E3 06 00 00 0A 01 00 5C E3 04 00 00 9A 01 30 F0 E5 00 00 53 E3 09 C0 43 E2 01 20 82 E2 F6 FF FF 1A 0F 30 82 E2 07 30 C3 E3 03 D0 4D E0 08 A0 8D E2 0A 00 A0 E1 ?? ?? ?? ?? 00 C0 A0 E3 00 C0 C0 E5 04 30 A0 E1 01 00 00 EA 2F 00 52 E3 01 C0 8C 02 03 10 A0 E1 01 20 D3 E4 00 00 52 E3 F9 FF FF 1A 01 20 64 E0 19 20 82 E2 00 30 D4 E5 07 20 C2 E3 02 D0 4D E0 00 00 53 E3 08 90 8D E2 95 00 00 0A 04 24 9F E5 09 00 A0 E1 3C 10 92 E5 04 20 A0 E1 03 31 91 E7 01 30 C0 E4 01 30 F2 E5 00 00 53 E3 FA FF FF 1A 01 00 5C E3 76 00 00 9A 00 30 A0 E3 00 30 C0 E5 03 00 A0 E1 0A 30 A0 E1 01 00 00 EA 2F 00 52 E3 01 00 80 02 03 10 A0 E1 01 20 D3 E4 00 00 52 E3 F9 FF FF 1A 01 20 6A E0 11 20 82 E2 00 30 DA E5 07 20 C2 E3 02 D0 4D E0 00 00 53 E3 08 10 8D E2 75 00 00 0A 8C 23 9F E5 3C 20 92 E5 01 C0 A0 E1 03 31 92 E7 01 30 CC E4 01 30 FA E5 00 00 53 E3 FA FF FF 1A 01 00 50 E3 64 00 00 9A 00 E0 A0 E3 09 00 A0 E1 04 20 88 E2 01 30 A0 E3 00 E0 CC E5 ?? ?? ?? ?? 00 00 50 E3 7D 00 00 1A 3C 30 96 E5 00 20 A0 E3 01 30 83 E2 08 20 88 E5 3C 30 86 E5 04 FF FF EA 14 30 9A E5 2C 10 1B E5 08 20 98 E5 40 50 1B E5 01 10 63 E0 04 10 41 E2 00 10 83 E5 05 31 82 E7 2C 20 1B E5 18 10 9A E5 03 30 62 E0 01 30 83 E0 03 10 03 E2 01 20 82 E0 03 30 C3 E3 14 20 8A E5 18 30 8A E5 05 51 A0 E1 10 60 9A E5 00 10 A0 E3 06 40 A0 E1 C4 22 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 3E 00 00 CA 08 30 98 E5 05 40 93 E7 72 FE FF EA 10 50 9A E5 00 10 A0 E3 05 40 A0 E1 74 22 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 66 FE FF DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 2C 02 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 00 00 A0 E3 5D FE FF EA 50 10 0B E5 ?? ?? ?? ?? 01 80 80 E2 08 00 A0 E1 ?? ?? ?? ?? 00 40 50 E2 50 10 1B E5 08 20 A0 11 ?? ?? ?? ?? 0C 40 8A E5 2E FF FF EA 00 00 5C E3 2F 30 A0 E3 00 30 C0 E5 01 00 80 12 83 FF FF 1A 01 30 C0 E5 E8 11 9F E5 08 20 A0 E3 02 00 80 E2 ?? ?? ?? ?? 7D FF FF EA 00 00 50 E3 2F 30 A0 E3 00 30 CC E5 01 30 CC 05 01 C0 8C 12 02 C0 8C 02 93 FF FF EA 01 C0 A0 E1 8F FF FF EA 09 00 A0 E1 70 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 80 01 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF B7 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 5C 01 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 00 00 E0 E3 29 FE FF EA 02 00 A0 E1 ?? ?? ?? ?? 9F FE FF EA 01 00 70 E3 07 00 00 0A 20 21 9F E5 00 00 52 E3 40 00 86 12 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 00 00 A0 E3 1C FE FF EA 04 00 88 E5 75 FF FF EA 01 10 A0 E3 04 21 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 02 00 A0 11 ?? ?? ?? ?? 08 30 98 E5 00 00 53 E3 1B 00 00 0A B8 A0 9F E5 10 60 9A E5 00 10 A0 E3 06 40 A0 E1 B4 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 07 00 00 DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 6C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 08 40 98 E5 E2 FD FF EA 20 00 96 E5 04 10 A0 E3 00 00 87 E0 ?? ?? ?? ?? 00 00 50 E3 08 00 88 E5 5F FE FF 1A 00 30 E0 E3 08 30 88 E5 D9 FF FF EA 1C 30 9F E5 00 00 53 E3 B2 FE FF 0A 40 00 86 E2 ?? ?? ?? ?? AF FE FF EA 00 20 A0 E3 EE FE FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EC 0F 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_215_4_0 {
	meta:
		name = "__dcigettext"
		size = 1920
		refs = "0050 __pthread_rwlock_rdlock 008c __current_locale_name 0094 strlen 00b0 memcpy 00d4 __tfind 00e8 __pthread_rwlock_unlock 0118 __aeabi_read_tp 0154 strcmp 01dc __getcwd 01f4 __rawmemchr 0210 strcpy 022c getenv 02a4 stpcpy 02c0 mempcpy 0344 _nl_find_domain 0364 _nl_find_msg 04b8 strchr 061c malloc 06b0 __pthread_rwlock_wrlock 06c8 __tsearch 0708 free 0720 __libc_setlocale_lock 0730 transcmp 073c _nl_msg_cat_cntr 0740 _nl_domain_bindings 0744 __libc_errno 0758 _nl_category_name_idxs 075c _nl_category_names 0774 __libc_enable_secure 0778 _nl_default_dirname"
	strings:
		$1 = { F0 4F 2D E9 00 80 51 E2 20 B0 8D E2 64 D0 4D E2 5C 00 0B E5 68 20 0B E5 60 30 0B E5 11 01 00 0A 08 00 9B E5 06 20 50 E2 00 30 72 E2 02 30 B3 E0 0C 00 50 E3 01 30 83 83 00 00 53 E3 F0 00 00 1A D4 46 9F E5 00 00 54 E3 03 00 00 0A CC 06 9F E5 ?? ?? ?? ?? C8 06 9F E5 ?? ?? ?? ?? 5C 30 1B E5 00 00 53 E3 BC 36 9F 05 00 30 93 05 5C 30 0B 05 08 00 9B E5 5C C0 1B E5 00 30 A0 E3 44 C0 0B E5 34 30 0B E5 28 80 0B E5 40 00 0B E5 ?? ?? ?? ?? 00 50 A0 E1 ?? ?? ?? ?? 0F 30 80 E2 07 30 C3 E3 03 D0 4D E0 01 20 80 E2 05 10 A0 E1 08 00 8D E2 ?? ?? ?? ?? 00 00 54 E3 6C 00 0B E5 3C 00 0B E5 64 06 9F 15 ?? ?? ?? ?? 60 26 9F E5 44 00 4B E2 5C 16 9F E5 ?? ?? ?? ?? 58 26 9F E5 00 00 52 E3 64 00 0B E5 40 06 9F 15 ?? ?? ?? ?? 64 30 1B E5 00 00 53 E3 05 00 00 0A 00 30 93 E5 38 26 9F E5 0C 10 93 E5 00 20 92 E5 02 00 51 E1 18 01 00 0A 28 26 9F E5 28 36 9F E5 ?? ?? ?? ?? 03 30 9F E7 00 50 92 E5 03 30 90 E7 00 00 55 E3 74 30 0B E5 08 01 00 0A 5C 60 1B E5 03 00 00 EA 08 01 00 BA 00 50 95 E5 00 00 55 E3 02 01 00 0A 06 00 A0 E1 0C 10 85 E2 ?? ?? ?? ?? 00 00 50 E3 F6 FF FF 1A 04 C0 95 E5 00 30 DC E5 2F 00 53 E3 00 40 A0 E1 54 C0 0B E5 26 00 00 0A 54 00 1B E5 ?? ?? ?? ?? C0 A5 9F E5 C0 75 9F E5 01 60 80 E2 50 50 0B E5 06 00 00 EA B4 15 9F E5 01 20 9F E7 02 30 95 E7 22 00 53 E3 A0 00 00 1A AA A0 8A E0 20 A0 8A E2 06 30 8A E0 0E 30 83 E2 07 30 C3 E3 03 D0 4D E0 ?? ?? ?? ?? 08 90 8D E2 00 50 A0 E1 07 20 9F E7 09 00 A0 E1 0A 10 A0 E1 02 40 85 E7 ?? ?? ?? ?? 00 00 50 E3 EA FF FF 0A 00 10 A0 E3 09 00 A0 E1 54 90 0B E5 ?? ?? ?? ?? 54 15 9F E5 02 20 A0 E3 50 50 1B E5 ?? ?? ?? ?? 04 10 95 E5 01 00 80 E2 ?? ?? ?? ?? 08 00 9B E5 38 25 9F E5 38 35 9F E5 00 60 D2 E7 34 05 9F E5 03 60 86 E0 ?? ?? ?? ?? 00 70 50 E2 C3 00 00 0A 00 30 D7 E5 00 00 53 E3 C0 00 00 0A 08 00 9B E5 ?? ?? ?? ?? 00 30 D0 E5 43 00 53 E3 00 40 A0 E1 07 40 A0 11 02 00 00 1A 01 30 D4 E5 00 00 53 E3 07 40 A0 11 5C 00 1B E5 ?? ?? ?? ?? 70 00 0B E5 06 00 A0 E1 ?? ?? ?? ?? 70 C0 1B E5 00 00 8C E0 13 30 80 E2 07 30 C3 E3 03 D0 4D E0 08 C0 8D E2 0C 00 A0 E1 06 10 A0 E1 58 C0 0B E5 ?? ?? ?? ?? A4 14 9F E5 02 20 A0 E3 ?? ?? ?? ?? 70 20 1B E5 5C 10 1B E5 01 00 80 E2 ?? ?? ?? ?? 98 14 9F E5 04 20 A0 E3 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 0F 00 80 E2 07 30 C0 E3 03 D0 4D E0 08 60 8D E2 48 90 4B E2 00 C0 D4 E5 3A 00 5C E3 76 00 00 0A 00 00 5C E3 01 30 84 12 06 E0 A0 11 5B 00 00 1A 43 00 A0 E3 00 00 C6 E5 01 C0 C6 E5 01 30 D6 E5 00 00 53 E3 42 00 00 0A 06 00 A0 E1 3C 14 9F E5 ?? ?? ?? ?? 00 00 50 E3 3D 00 00 0A 06 10 A0 E1 54 00 1B E5 58 20 1B E5 05 30 A0 E1 ?? ?? ?? ?? 00 10 50 E2 50 10 0B E5 E5 FF FF 0A 01 30 A0 E3 00 90 8D E5 05 10 A0 E1 08 20 A0 E1 ?? ?? ?? ?? 00 30 50 E2 5A 00 00 0A 01 00 73 E3 2C 00 00 0A 64 10 1B E5 00 00 51 E3 9A 00 00 0A 64 10 1B E5 50 C0 1B E5 00 20 91 E5 A4 13 9F E5 10 C0 82 E5 64 C0 1B E5 00 00 91 E5 00 10 9C E5 0C 00 82 E5 14 30 81 E5 48 10 1B E5 00 20 9C E5 18 10 82 E5 AC 23 9F E5 60 10 1B E5 ?? ?? ?? ?? 74 C0 1B E5 02 20 9F E7 00 00 51 E3 02 C0 80 E7 7D 00 00 1A 58 23 9F E5 00 00 52 E3 CB 00 00 0A 34 03 9F E5 78 30 0B E5 ?? ?? ?? ?? 2C 03 9F E5 ?? ?? ?? ?? 78 30 1B E5 03 00 A0 E1 06 00 00 EA 60 10 1B E5 00 00 51 E3 15 00 00 0A 04 20 9B E5 01 00 52 E3 12 00 00 0A 68 00 1B E5 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 04 23 9F E5 00 00 52 E3 03 00 00 0A E0 02 9F E5 ?? ?? ?? ?? DC 02 9F E5 ?? ?? ?? ?? 20 33 9F E5 60 20 1B E5 ?? ?? ?? ?? 74 C0 1B E5 03 30 9F E7 00 00 52 E3 03 C0 80 E7 E9 FF FF 1A 08 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 01 C0 CE E4 00 C0 D3 E5 3A 00 5C E3 00 00 5C 13 03 40 A0 E1 00 20 A0 03 01 20 A0 13 01 30 83 E2 F6 FF FF 1A D0 12 9F E5 00 30 91 E5 00 00 53 E3 00 20 CE E5 04 00 00 0A 06 00 A0 E1 2F 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 89 FF FF 1A 00 30 D6 E5 43 00 53 E3 93 FF FF 1A 8F FF FF EA 01 40 84 E2 83 FF FF EA 50 20 1B E5 10 00 92 E5 00 00 50 E3 7F FF FF 0A 03 A0 A0 E1 02 70 A0 E1 03 00 00 EA 10 00 97 E5 00 00 50 E3 01 A0 8A E2 78 FF FF 0A 00 90 8D E5 05 10 A0 E1 08 20 A0 E1 01 30 A0 E3 ?? ?? ?? ?? 01 00 70 E3 04 70 87 E2 C0 FF FF 0A 00 00 50 E3 F1 FF FF 0A 00 30 A0 E1 50 00 1B E5 04 C0 8A E2 0C C1 90 E7 50 C0 0B E5 8B FF FF EA 08 00 9B E5 ?? ?? ?? ?? 00 40 A0 E1 44 FF FF EA 18 C2 9F E5 54 C0 0B E5 2B FF FF EA 0C C2 9F E5 00 50 A0 E3 54 C0 0B E5 27 FF FF EA 60 C0 1B E5 00 00 5C E3 14 80 93 05 0A 00 00 1A AC 01 9F E5 00 00 50 E3 B5 FF FF 0A 88 01 9F E5 ?? ?? ?? ?? 84 01 9F E5 ?? ?? ?? ?? 08 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 10 20 93 E5 08 00 92 E5 14 20 83 E2 04 10 9B E5 0C 00 92 E8 95 FB FF EB 00 80 A0 E1 EC FF FF EA 50 10 1B E5 03 20 A0 E1 08 00 91 E5 48 30 1B E5 04 10 9B E5 8D FB FF EB 00 30 A0 E1 79 FF FF EA 08 00 A0 E1 78 30 0B E5 ?? ?? ?? ?? 01 50 80 E2 6C 00 1B E5 ?? ?? ?? ?? 70 C0 1B E5 00 40 A0 E1 1E 00 8C E2 04 00 80 E0 05 00 80 E0 ?? ?? ?? ?? 00 60 50 E2 78 30 1B E5 62 FF FF 0A 70 C0 1B E5 05 20 A0 E1 08 10 A0 E1 1C 00 86 E2 01 50 8C E2 ?? ?? ?? ?? 05 20 A0 E1 5C 10 1B E5 05 50 80 E0 00 70 A0 E1 ?? ?? ?? ?? 6C 10 1B E5 01 20 84 E2 05 00 A0 E1 ?? ?? ?? ?? CC 20 9F E5 08 01 9F E5 78 30 1B E5 00 10 92 E5 00 00 50 E3 48 20 1B E5 08 00 9B E5 50 C0 1B E5 08 50 86 E5 00 70 86 E5 04 00 86 E5 10 C0 86 E5 14 30 86 E5 0C 10 86 E5 18 20 86 E5 03 00 00 0A 7C 00 9F E5 78 30 0B E5 ?? ?? ?? ?? 78 30 1B E5 06 00 A0 E1 70 10 9F E5 68 20 9F E5 78 30 0B E5 ?? ?? ?? ?? 00 40 A0 E1 60 00 9F E5 00 00 50 E3 78 30 1B E5 02 00 00 0A 44 00 9F E5 ?? ?? ?? ?? 78 30 1B E5 00 00 54 E3 02 00 00 0A 00 20 94 E5 02 00 56 E1 2D FF FF 0A 06 00 A0 E1 78 30 0B E5 ?? ?? ?? ?? 78 30 1B E5 28 FF FF EA 03 00 A0 E1 40 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 02 10 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_215_5_0 {
	meta:
		name = "free_mem"
		size = 188
		refs = "0028 free 0068 __tdestroy 00a4 _nl_domain_bindings 00a8 _nl_default_dirname 00b0 _nl_default_default_domain"
	strings:
		$1 = { 70 40 2D E9 98 50 9F E5 00 40 95 E5 00 00 54 E3 90 60 9F 15 0B 00 00 0A 04 00 94 E5 00 30 94 E5 06 00 50 E1 00 30 85 E5 ?? ?? ?? ?? 08 00 94 E5 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 00 40 95 E5 00 00 54 E3 F3 FF FF 1A 5C 20 9F E5 5C 30 9F E5 00 00 92 E5 03 00 50 E1 ?? ?? ?? ?? 50 50 9F E5 50 10 9F E5 00 00 95 E5 ?? ?? ?? ?? 04 00 95 E5 00 30 A0 E3 03 00 50 E1 00 30 85 E5 01 00 00 1A 05 00 00 EA 04 00 A0 E1 00 40 90 E5 04 40 85 E5 ?? ?? ?? ?? 00 00 54 E3 F9 FF FF 1A 70 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_217_0_0 {
	meta:
		name = "__gconv"
		size = 540
		refs = "00dc _dl_mcount_wrapper_check 01f4 __assert_fail"
	strings:
		$1 = { F0 4F 2D E9 01 00 70 E3 24 D0 4D E2 00 50 A0 E1 01 60 A0 E1 02 80 A0 E1 14 30 8D E5 4C 90 9D E5 47 00 00 0A 00 30 90 E5 00 00 59 E3 01 30 43 E2 18 30 8D E5 6F 00 00 0A 14 00 9D E5 18 20 9D E5 00 00 50 E3 00 10 90 15 18 00 9D E5 82 21 A0 E1 00 30 A0 E3 00 30 89 E5 14 10 9D 05 00 30 82 E0 03 31 85 E0 1C 20 8D E5 04 20 95 E5 08 10 83 E5 48 10 9D E5 00 00 56 E3 0C 10 83 E5 14 70 92 E5 33 00 00 0A 00 B0 96 E5 00 00 5B E3 30 00 00 0A 14 10 9D E5 00 00 51 E3 51 00 00 0A 00 30 91 E5 00 00 53 E3 08 A0 85 12 00 40 A0 13 09 00 00 1A 4B 00 00 EA 00 30 96 E5 0B 00 53 E1 12 00 00 0A 04 20 95 E5 24 20 92 E5 02 20 83 E0 02 00 58 E1 0D 00 00 3A 03 B0 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 04 00 95 E5 0A 10 A0 E1 10 02 8D E8 08 40 8D E5 0C 40 8D E5 06 20 A0 E1 08 30 A0 E1 0F E0 A0 E1 ?? ?? ?? ?? 04 00 50 E3 E9 FF FF 0A 14 10 9D E5 00 30 91 E5 00 00 53 E3 06 00 00 0A 18 10 8D E2 06 00 91 E8 01 30 82 E0 03 51 85 E0 08 30 95 E5 14 20 9D E5 00 30 82 E5 24 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 08 00 A0 E3 24 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 07 00 A0 E1 ?? ?? ?? ?? 18 00 8D E2 05 00 90 E8 00 30 82 E0 03 31 85 E0 08 10 93 E5 00 30 A0 E3 03 00 51 E1 01 10 A0 13 02 10 A0 03 04 00 95 E5 03 20 A0 E1 08 10 8D E5 08 02 8D E8 0C 30 8D E5 08 10 85 E2 0F E0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 08 00 00 1A 18 C0 9D E5 05 20 A0 E1 00 30 A0 E1 00 10 A0 E1 01 30 83 E2 03 00 5C E1 14 10 82 E5 24 20 82 E2 FA FF FF 2A 14 20 9D E5 00 00 52 E3 CC FF FF 1A 24 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 20 00 9F E5 20 10 9F E5 4A 20 A0 E3 1C 30 9F E5 ?? ?? ?? ?? 18 00 9F E5 0C 10 9F E5 2C 20 A0 E3 08 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_218_0_0 {
	meta:
		name = "_IO_getdelim"
		size = 900
		refs = "0038 __aeabi_read_tp 00c8 malloc 00f8 __underflow 0120 memchr 0170 realloc 0194 memcpy 036c _Unwind_Resume 0374 __lll_lock_wait_private 037c __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 00 00 51 E3 00 00 50 13 0C D0 4D E2 00 70 A0 E1 01 90 A0 E1 04 20 8D E5 03 50 A0 E1 9D 00 00 0A 00 30 93 E5 02 49 13 E2 03 20 A0 E1 1A 00 00 1A 48 60 95 E5 ?? ?? ?? ?? 08 20 96 E5 13 8D 40 E2 08 00 52 E1 10 00 00 0A 01 10 A0 E3 06 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 BB 00 00 1A 48 30 95 E5 03 60 A0 E1 08 80 83 E5 00 30 95 E5 04 20 96 E5 01 20 82 E2 04 20 86 E5 03 20 A0 E1 20 00 13 E3 4A 00 00 1A 00 30 97 E5 00 00 53 E3 02 00 00 0A 00 30 99 E5 00 00 53 E3 05 00 00 1A 78 00 A0 E3 00 00 89 E5 ?? ?? ?? ?? 00 00 50 E3 00 00 87 E5 63 00 00 0A 04 60 95 E5 08 40 95 E5 04 40 66 E0 00 00 54 E3 61 00 00 DA 00 A0 A0 E3 07 00 00 EA 05 00 A0 E1 ?? ?? ?? ?? 01 00 70 E3 29 00 00 0A 04 60 95 E5 08 40 95 E5 08 A0 A0 E1 04 40 66 E0 04 20 A0 E1 06 00 A0 E1 04 10 9D E5 ?? ?? ?? ?? 00 B0 50 E2 0B 40 66 10 02 31 E0 E3 01 40 84 12 03 30 6A E0 03 00 54 E1 5D 00 00 AA 04 80 8A E0 00 20 99 E5 01 30 88 E2 02 00 53 E1 00 00 97 95 0B 00 00 9A 82 20 A0 E1 02 00 53 E1 03 60 A0 21 02 60 A0 31 06 10 A0 E1 00 00 97 E5 ?? ?? ?? ?? 00 00 50 E3 3A 00 00 0A 00 00 87 E5 00 60 89 E5 04 60 95 E5 04 20 A0 E1 0A 00 80 E0 06 10 A0 E1 ?? ?? ?? ?? 04 30 95 E5 00 00 5B E3 04 40 83 E0 04 40 85 E5 D1 FF FF 0A 00 30 97 E5 00 20 A0 E3 08 20 C3 E7 00 20 95 E5 02 09 12 E3 06 00 00 0A 08 00 A0 E1 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 80 E0 E3 02 09 12 E3 F8 FF FF 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 F2 FF FF 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 E0 FF FF DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 08 00 A0 E1 D7 FF FF EA 00 20 95 E5 00 80 E0 E3 D8 FF FF EA 05 00 A0 E1 ?? ?? ?? ?? 01 00 70 E3 04 60 95 15 08 40 95 15 04 40 66 10 96 FF FF 1A 00 80 A0 E1 00 20 95 E5 CE FF FF EA D8 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 00 00 E0 E3 C3 FF FF EA C0 30 9F E5 4B 20 A0 E3 ?? ?? ?? ?? 03 30 9F E7 03 20 80 E7 00 80 E0 E3 00 20 95 E5 BF FF FF EA 00 30 95 E5 02 09 13 E3 00 80 A0 E1 1F 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 19 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 07 00 00 DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 08 00 A0 E1 ?? ?? ?? ?? 06 00 A0 E1 ?? ?? ?? ?? 40 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_219_0_0 {
	meta:
		name = "check_match.12865"
		size = 416
		refs = "0068 strcmp 0170 _dl_name_match_p 018c __assert_fail"
	strings:
		$1 = { F8 40 2D E9 04 20 90 E5 0C 30 D0 E5 00 00 52 E3 00 50 A0 E1 0C 40 A0 E1 0F 30 03 E2 4D 00 00 0A BE 10 D5 E1 24 20 94 E5 00 00 51 E3 00 20 A0 13 01 20 02 02 00 00 52 E3 3D 00 00 1A 4C 21 9F E5 52 33 A0 E1 01 00 13 E3 39 00 00 0A 20 30 94 E5 03 00 55 E1 06 00 00 0A 00 30 95 E5 1C 00 94 E5 18 10 94 E5 03 00 80 E0 ?? ?? ?? ?? 00 00 50 E3 2F 00 00 1A 10 60 94 E5 14 10 94 E5 00 00 56 E3 A4 31 91 E5 16 00 00 0A 00 00 53 E3 34 00 00 0A 0C 20 94 E5 82 20 A0 E1 B2 70 93 E1 70 31 91 E5 87 28 A0 E1 A2 28 A0 E1 02 12 83 E0 04 40 91 E5 04 10 96 E5 01 00 54 E1 20 00 00 0A 08 30 96 E5 00 00 53 E3 1A 00 00 1A 00 00 54 E3 18 00 00 1A 02 09 17 E3 16 00 00 1A 05 00 A0 E1 F8 40 BD E8 ?? ?? ?? ?? 00 00 53 E3 FA FF FF 0A 0C 10 94 E5 08 20 94 E5 81 10 A0 E1 B1 30 93 E1 02 00 12 E3 83 18 A0 E1 03 20 A0 03 02 20 A0 13 A1 08 52 E1 F0 FF FF CA 02 09 13 E3 05 00 00 1A 04 00 94 E5 00 00 50 E3 01 30 80 E2 04 30 84 E5 00 50 84 05 E9 FF FF 0A 00 00 A0 E3 F8 40 BD E8 ?? ?? ?? ?? 02 02 93 E7 00 10 96 E5 ?? ?? ?? ?? 00 00 50 E3 E0 FF FF 0A D8 FF FF EA 06 00 53 E3 AF FF FF 0A F3 FF FF EA 0C 00 96 E5 00 00 50 E3 D9 FF FF 0A ?? ?? ?? ?? 00 00 50 E3 D6 FF FF 0A 10 00 9F E5 10 10 9F E5 A7 20 A0 E3 0C 30 9F E5 ?? ?? ?? ?? 67 04 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_219_1_0 {
	meta:
		name = "do_lookup_x"
		size = 2064
		refs = "0140 _dl_name_match_p 01e4 __pthread_mutex_lock 020c __aeabi_uidivmod 0274 strcmp 02bc __pthread_mutex_unlock 039c _dl_higher_prime_number 03ac calloc 05f4 _dl_debug_printf 0618 _dl_dprintf 0620 _exit 07e0 _dl_debug_mask 07e8 _dl_ns 07f0 _dl_dynamic_weak 07f4 free 0800 _dl_argv"
	strings:
		$1 = { F0 4F 2D E9 4C D0 4D E2 88 40 9D E5 74 C0 9D E5 7C 60 9D E5 80 50 9D E5 44 40 8D E5 04 80 9C E5 01 A0 A0 E1 0C 20 8D E5 38 00 8D E5 40 30 8D E5 30 60 8D E5 28 50 8D E5 78 40 9D E5 84 90 9D E5 00 30 9C E5 A1 02 A0 E1 07 71 44 E2 8C B7 9F E5 08 00 8D E5 07 71 83 E0 00 50 A0 E3 04 30 B7 E5 14 60 93 E5 09 00 56 E1 24 50 8D E5 20 50 8D E5 34 60 8D E5 34 00 00 0A 44 30 9D E5 02 00 13 E3 02 00 00 0A 94 31 D6 E5 03 00 13 E3 2E 00 00 0A 95 31 D6 E5 20 00 13 E3 2B 00 00 1A 00 30 9B E5 08 00 13 E3 45 01 00 1A 78 11 96 E5 00 00 51 E3 25 00 00 0A 34 30 96 E5 04 00 93 E5 38 30 96 E5 84 21 96 E5 04 30 93 E5 00 00 52 E3 14 30 8D E5 3C 00 8D E5 77 01 00 0A 08 00 9D E5 7C C1 96 E5 80 31 96 E5 0C C0 00 E0 0C 21 92 E7 3A 03 A0 E1 1F C0 0A E2 32 CC A0 E1 1F 00 00 E2 32 00 0C E0 01 00 10 E3 4A 01 00 1A 2C 50 8D E5 24 30 9D E5 01 00 53 E3 13 00 00 0A 2C 30 9D E5 00 00 53 E3 09 00 00 1A 30 30 9D E5 00 00 53 E3 06 00 00 0A 0C 00 93 E5 00 00 50 E3 03 00 00 0A 34 10 9D E5 ?? ?? ?? ?? 00 00 50 E3 35 01 00 1A 01 40 84 E2 04 00 58 E1 C0 FF FF 8A 00 00 A0 E3 4C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 20 00 9D E5 00 00 50 E3 E8 FF FF 0A 0C 30 D0 E5 23 32 A0 E1 02 00 53 E3 50 00 00 0A 0A 00 53 E3 0A 00 00 0A 01 00 53 E3 E0 FF FF 1A 00 60 A0 E1 70 C0 9D E5 34 30 9D E5 00 60 8C E5 04 30 8C E5 01 00 A0 E3 4C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 34 30 9D E5 18 30 93 E5 1C 16 9F E5 83 71 83 E0 18 26 9F E5 87 30 83 E0 03 21 82 E0 00 00 51 E3 00 60 A0 E1 08 20 8D E5 02 00 A0 11 ?? ?? ?? ?? 08 20 9D E5 18 20 92 E5 08 30 9D E5 00 00 52 E3 0C 20 8D E5 1C 80 93 E5 D0 00 00 0A 0A 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 0A 00 A0 E1 10 10 8D E5 02 10 48 E2 ?? ?? ?? ?? 38 30 9D E5 01 B0 81 E2 0B 72 A0 E1 10 50 9D E5 14 60 8D E5 07 60 A0 E1 03 70 A0 E1 0C C0 9D E5 05 42 8C E0 05 00 00 EA 00 00 59 E3 27 00 00 0A 0B 50 85 E0 05 00 58 E1 06 40 84 E0 4B 00 00 9A 08 02 94 E8 0A 00 53 E1 F6 FF FF 1A 07 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F1 FF FF 1A 44 30 9D E5 02 00 13 E3 08 20 84 02 34 30 9D 15 70 00 9D 15 0C 00 92 08 70 10 9D 05 04 30 80 15 0C 00 81 08 14 60 9D E5 3C 35 9F E5 00 60 80 15 00 00 53 E3 DC 00 00 0A 08 00 9D E5 ?? ?? ?? ?? 01 00 A0 E3 B8 FF FF EA 20 15 9F E5 00 30 91 E5 00 00 53 E3 AE FF FF 0A 70 20 9D E5 00 30 92 E5 00 00 53 E3 34 30 9D 05 09 00 82 08 89 FF FF EA 08 20 9D E5 20 C0 92 E5 88 10 88 E0 0C 01 51 E1 14 60 9D E5 23 00 00 9A 0B 20 A0 E1 10 B0 9D E5 44 10 9D E5 02 00 11 E3 3C 90 9D E5 00 10 96 E5 6C 00 00 0A 01 90 89 E0 40 50 9D E5 0C 10 9D E5 02 42 A0 E1 0B 02 81 E0 03 00 00 EA 02 B0 8B E0 0B 00 58 E1 04 00 80 E0 7C 00 00 9A 04 30 90 E5 00 00 53 E3 F8 FF FF 1A 8C 10 9D E5 00 A0 80 E5 04 90 80 E5 08 50 80 E5 0C 10 80 E5 78 34 9F E5 08 20 9D E5 01 C0 8C E2 00 00 53 E3 20 C0 82 E5 84 FF FF 0A 02 00 A0 E1 ?? ?? ?? ?? 81 FF FF EA 05 50 68 E0 A8 FF FF EA 01 00 88 E2 ?? ?? ?? ?? 00 10 A0 E1 00 50 A0 E1 10 00 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 00 8D E5 90 00 00 0A 00 00 58 E3 02 30 45 02 14 30 8D 05 27 00 00 0A 0C C0 9D E5 02 20 45 E2 18 60 8D E5 14 20 8D E5 10 60 9D E5 1C A0 8D E5 08 82 8C E0 0C 90 A0 E1 02 70 A0 E1 04 B0 99 E5 00 00 5B E3 16 00 00 0A 00 A0 99 E5 05 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 0A 00 A0 E1 01 40 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 08 E0 99 E5 01 C0 81 E2 0C 00 99 E5 0C 12 A0 E1 04 32 86 E0 03 00 00 EA 0C 40 84 E0 04 00 55 E1 01 30 83 E0 22 00 00 9A 04 20 93 E5 00 00 52 E3 F8 FF FF 1A 00 4C 83 E8 0C 00 83 E5 10 90 89 E2 08 00 59 E1 E2 FF FF 1A 18 60 8D E2 40 04 96 E8 0C 00 9D E5 08 30 9D E5 24 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 08 C0 9D E5 68 33 9F E5 10 20 9D E5 24 30 8C E5 18 20 8C E5 1C 50 8C E5 0A 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 0A 00 A0 E1 01 B0 A0 E1 14 10 9D E5 ?? ?? ?? ?? 10 30 9D E5 0C 30 8D E5 08 30 9D E5 05 80 A0 E1 01 20 81 E2 20 C0 93 E5 8F FF FF EA 04 40 65 E0 D4 FF FF EA 01 90 89 E0 34 50 9D E5 0C 10 9D E5 02 42 A0 E1 0B 02 81 E0 03 00 00 EA 02 B0 8B E0 0B 00 58 E1 04 00 80 E0 0D 00 00 9A 04 30 90 E5 00 00 53 E3 F8 FF FF 1A 94 31 D5 E5 03 30 03 E2 02 00 53 E3 04 32 95 05 08 30 83 03 00 A0 80 E5 04 90 80 E5 08 60 80 E5 0C 50 80 E5 04 32 85 05 8C FF FF EA 0B B0 68 E0 E9 FF FF EA 0B B0 68 E0 7A FF FF EA 10 00 A0 E3 1F 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 0C 00 8D E5 27 00 00 0A 90 22 9F E5 90 32 9F E5 9A C2 82 E0 9A 03 83 E0 0A 10 62 E0 23 32 A0 E1 A1 20 82 E0 08 00 8D E2 83 11 63 E0 01 10 90 E8 01 31 83 E0 22 B2 A0 E1 5C 12 9F E5 0A 20 63 E0 8B B2 6B E0 1F 30 A0 E3 18 C0 80 E5 0A B0 6B E0 01 20 82 E2 24 10 80 E5 1C 30 80 E5 03 80 A0 E1 20 C0 90 E5 53 FF FF EA 04 20 96 E5 00 30 D2 E5 00 00 53 E3 05 00 00 1A 28 12 9F E5 00 30 91 E5 00 20 93 E5 20 32 9F E5 00 00 52 E3 03 20 A0 01 18 30 96 E5 14 02 9F E5 38 10 9D E5 ?? ?? ?? ?? 34 60 9D E5 A9 FE FF EA E4 31 9F E5 00 00 53 E3 08 00 9D 15 ?? ?? ?? ?? 02 00 A0 E3 F0 11 9F E5 ?? ?? ?? ?? 7F 00 A0 E3 ?? ?? ?? ?? 00 00 E0 E3 DF FE FF EA 01 00 A0 E3 DD FE FF EA 0A 00 A0 E1 ?? ?? ?? ?? 88 21 96 E5 01 21 92 E7 00 00 52 E3 AE FE FF 0A 8C 11 96 E5 02 21 81 E0 08 30 A0 E1 04 60 42 E2 04 80 A0 E1 14 40 9D E5 01 00 00 EA 01 00 12 E3 2B 00 00 1A 04 20 B6 E5 02 10 2A E0 A1 10 B0 E1 F9 FF FF 1A 34 20 9D E5 8C 21 92 E5 06 20 62 E0 42 21 A0 E1 02 02 84 E0 20 C0 8D E2 04 30 8D E5 2C 20 8D E5 EE FD FF EB 00 00 50 E3 04 30 9D E5 1E 00 00 1A 00 20 96 E5 EB FF FF EA 0C C0 9D E5 00 00 9C E5 01 00 70 E3 1B 00 00 0A ?? ?? ?? ?? 01 11 A0 E1 8C 21 96 E5 01 00 92 E7 00 00 50 E3 2C 00 8D E5 89 FE FF 0A 14 60 9D E5 06 00 00 EA 34 30 9D E5 2C 10 9D E5 88 21 93 E5 01 01 92 E7 00 00 50 E3 2C 00 8D E5 80 FE FF 0A 00 02 86 E0 20 C0 8D E2 D2 FD FF EB 00 00 50 E3 F3 FF FF 0A 94 FE FF EA 08 40 A0 E1 03 80 A0 E1 76 FE FF EA 08 40 A0 E1 03 80 A0 E1 8E FE FF EA 38 00 9D E5 00 20 D0 E5 00 00 52 E3 02 10 A0 01 21 00 00 0A 01 C0 D0 E5 00 00 5C E3 19 00 00 0A 02 E0 D0 E5 00 00 5E E3 02 22 8C E0 15 00 00 0A 03 C0 D0 E5 00 00 5C E3 02 22 8E E0 11 00 00 0A 04 E0 D0 E5 00 00 5E E3 02 22 8C E0 0D 00 00 0A 05 C0 D0 E5 00 00 5C E3 02 22 8E E0 05 00 80 E2 07 00 00 0A 14 30 9D E5 02 22 8C E0 01 C0 F0 E5 0F E2 02 E2 00 00 5C E3 2E 2C 22 E0 F9 FF FF 1A 14 30 8D E5 0F 22 C2 E3 02 00 A0 E1 04 20 8D E5 ?? ?? ?? ?? 04 20 9D E5 01 11 A0 E1 0C 00 9D E5 00 20 80 E5 BB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 85 10 42 08 09 CB 3D 8D ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_219_2_0 {
	meta:
		name = "_dl_lookup_symbol_x"
		size = 2892
		refs = "031c strlen 0350 stpcpy 036c _dl_signal_cerror 03c8 __assert_fail 0464 _dl_debug_printf 047c _dl_debug_printf_c 06d4 __pthread_mutex_lock 0754 __pthread_mutex_unlock 0798 _dl_lookup_symbol_x 07a0 __aeabi_read_tp 09fc malloc 0a40 memcpy 0a7c _dl_scope_free 0adc _dl_debug_mask 0ae4 _dl_argv 0b3c _dl_load_lock 0b40 _dl_ns"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 84 D0 4D E2 00 80 A0 E1 00 00 D0 E5 00 00 50 E3 B8 AA 9F E5 01 90 A0 E1 02 50 A0 E1 58 30 0B E5 10 60 9B E5 05 00 00 0A 08 30 A0 E1 8A A2 8A E0 0A A0 80 E0 01 00 F3 E5 00 00 50 E3 FA FF FF 1A 04 00 9B E5 00 30 A0 E3 00 20 E0 E3 00 00 50 E3 50 20 0B E5 4C 30 0B E5 48 30 0B E5 02 00 00 0A 0C 10 9B E5 05 10 D1 E3 D5 00 00 1A 00 00 56 E3 BF 00 00 1A 58 30 1B E5 00 20 93 E5 00 00 52 E3 5C 60 0B 15 FD 00 00 0A 5C 10 4B E2 12 00 91 E8 4C 70 4B E2 04 00 00 EA 72 00 00 1A 04 20 B4 E5 00 00 52 E3 12 00 00 0A 00 10 A0 E3 00 30 95 E5 04 00 9B E5 04 20 8D E5 08 10 8D E5 08 20 9B E5 0C 10 9B E5 0C 00 8D E5 10 10 8D E5 18 20 8D E5 00 70 8D E5 14 60 8D E5 1C 90 8D E5 08 00 A0 E1 0A 10 A0 E1 50 20 4B E2 BE FD FF EB 00 00 50 E3 E8 FF FF DA 4C 30 1B E5 00 00 53 E3 DF 00 00 0A 00 30 95 E5 00 00 53 E3 03 00 00 0A 0D 20 D3 E5 03 20 02 E2 03 00 52 E3 17 00 00 0A 00 30 A0 E3 48 A0 1B E5 5C 30 0B E5 94 31 DA E5 03 30 03 E2 02 00 53 E3 23 01 00 0A 0A C0 A0 E1 FC 31 9C E5 8C 29 9F E5 00 00 53 E3 01 30 A0 03 FC 31 8C 05 00 20 92 E5 7C 39 9F E5 03 30 02 E0 00 00 53 E3 9C 00 00 1A 4C 30 1B E5 00 30 85 E5 0C 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 08 20 9B E5 01 00 52 E3 2E 00 00 0A 58 00 1B E5 00 20 90 E5 00 70 A0 E3 07 00 52 E1 44 70 0B E5 40 70 0B E5 06 01 00 0A 00 40 A0 E1 01 C0 A0 E3 5C 00 1B E5 03 00 00 EA 04 20 B4 E5 00 00 52 E3 12 00 00 0A 00 30 95 E5 44 10 4B E2 06 00 8D E8 08 00 8D E5 04 20 9B E5 0C 00 9B E5 0C 20 8D E5 10 00 8D E5 18 C0 8D E5 14 60 8D E5 1C 70 8D E5 08 00 A0 E1 0A 10 A0 E1 50 20 4B E2 80 C0 0B E5 79 FD FF EB 00 00 50 E3 80 C0 1B E5 E9 FF FF 0A 44 30 1B E5 00 00 53 E3 E9 00 00 0A 40 30 1B E5 09 00 53 E1 E6 00 00 0A 00 30 95 E5 48 90 0B E5 4C 30 0B E5 09 30 A0 E1 01 10 A0 E3 03 A0 A0 E1 5C 10 0B E5 B8 FF FF EA 48 20 1B E5 09 00 52 E1 CD 00 00 0A 08 40 9B E5 4C 30 0B E5 48 90 0B E5 09 A0 A0 E1 5C 40 0B E5 AF FF FF EA 00 00 56 E3 8A FF FF 1A 04 30 9B E5 00 00 53 E3 4C 00 00 0A 00 00 59 E3 04 60 99 15 09 60 A0 01 00 30 D6 E5 00 00 53 E3 05 00 00 1A 40 38 9F E5 00 20 93 E5 00 60 92 E5 38 38 9F E5 00 00 56 E3 03 60 A0 01 04 10 9B E5 2C 78 9F E5 2C 98 9F E5 02 00 70 E3 28 48 9F E5 00 C0 91 E5 24 E8 9F E5 0C 10 91 E5 20 28 9F E5 20 38 9F E5 07 00 A0 01 09 00 A0 11 40 80 0B E5 28 00 0B E5 44 40 0B E5 3C E0 0B E5 38 C0 0B E5 30 10 0B E5 34 20 0B E5 2C 30 0B E5 44 70 4B E2 28 80 4B E2 07 00 A0 E3 01 40 A0 E3 01 00 00 EA 04 00 B7 E5 ?? ?? ?? ?? 08 00 57 E1 00 40 84 E0 FA FF FF 1A 0E 30 84 E2 07 30 C3 E3 03 D0 4D E0 20 70 8D E2 B0 17 9F E5 44 40 4B E2 07 00 A0 E1 00 00 00 EA 04 10 B4 E5 ?? ?? ?? ?? 04 00 58 E1 FB FF FF 1A 00 00 A0 E3 06 10 A0 E1 07 30 A0 E1 94 27 9F E5 ?? ?? ?? ?? 00 00 A0 E3 00 00 85 E5 7E FF FF EA 58 40 1B E5 00 20 94 E5 00 30 92 E5 00 10 93 E5 00 40 A0 E3 06 00 51 E1 5C 40 0B E5 3C FF FF 0A 04 10 A0 E1 04 00 B3 E5 06 00 50 E1 01 10 81 E2 FB FF FF 1A 5C 10 0B E5 35 FF FF EA 48 07 9F E5 48 17 9F E5 BB 2F A0 E3 44 37 9F E5 ?? ?? ?? ?? 40 07 9F E5 34 17 9F E5 3C 27 9F E5 30 37 9F E5 ?? ?? ?? ?? 04 00 12 E3 04 30 99 E5 5F FF FF 0A 00 20 D3 E5 00 00 52 E3 03 10 A0 11 05 00 00 1A E0 36 9F E5 00 20 93 E5 00 10 92 E5 D8 36 9F E5 00 00 51 E3 03 10 A0 01 04 30 9C E5 00 20 D3 E5 00 00 52 E3 18 20 99 E5 05 00 00 1A B4 36 9F E5 00 30 93 E5 00 30 93 E5 AC 06 9F E5 00 00 53 E3 00 30 A0 01 5C 40 1B E5 D0 E6 9F E5 D0 06 9F E5 18 C0 9C E5 00 00 54 E3 0E 00 A0 01 01 01 8D E9 00 C0 8D E5 BC 06 9F E5 ?? ?? ?? ?? 04 00 9B E5 00 00 50 E3 4A 00 00 0A 00 10 90 E5 A8 06 9F E5 ?? ?? ?? ?? 48 C0 1B E5 38 FF FF EA 00 30 95 E5 00 00 53 E3 03 00 00 0A 0C 30 D3 E5 23 32 A0 E1 02 00 53 E3 01 00 00 0A 00 00 56 E3 02 00 00 0A 00 00 A0 E3 00 00 85 E5 2F FF FF EA 1C 36 9F E5 00 30 93 E5 01 0C 13 E3 F8 FF FF 1A 04 20 9B E5 00 00 59 E3 04 60 99 15 14 66 9F 05 00 00 52 E3 1C 00 00 0A 04 10 9B E5 00 30 91 E5 00 00 53 E3 04 26 9F E5 F8 35 9F 05 00 10 D6 E5 00 00 51 E3 05 00 00 1A DC 15 9F E5 00 00 91 E5 00 60 90 E5 D4 15 9F E5 00 00 56 E3 01 60 A0 01 0C 16 9F E5 3C 20 0B E5 38 30 0B E5 44 10 0B E5 40 80 0B E5 44 70 4B E2 38 80 4B E2 12 00 A0 E3 01 40 A0 E3 08 00 57 E1 00 40 84 E0 05 00 00 0A 04 00 B7 E5 ?? ?? ?? ?? F9 FF FF EA 94 25 9F E5 02 30 A0 E1 E4 FF FF EA 0E 30 84 E2 07 30 C3 E3 03 D0 4D E0 20 70 8D E2 B4 15 9F E5 44 40 4B E2 07 00 A0 E1 ?? ?? ?? ?? 04 00 58 E1 09 00 00 0A 04 10 B4 E5 FA FF FF EA 08 20 9B E5 09 A0 A0 E1 5C 20 0B E5 E3 FE FF EA 88 05 9F E5 ?? ?? ?? ?? 48 C0 1B E5 EE FE FF EA 06 10 A0 E1 07 30 A0 E1 00 00 A0 E3 70 25 9F E5 ?? ?? ?? ?? B8 FF FF EA 48 30 1B E5 1A FF FF EA 0C 30 9B E5 01 00 13 E3 D8 FE FF 0A 0A 00 59 E1 2C 00 00 0A 04 32 9A E5 08 00 13 E3 D3 FE FF 1A F4 41 99 E5 64 40 0B E5 0F CA E0 E3 0F E0 A0 E1 5F F0 4C E2 F0 01 99 E5 00 00 50 E3 68 00 0B E5 0C 00 00 0A 00 30 90 E5 00 00 53 E3 09 00 00 0A 03 00 5A E1 05 00 00 0A 00 30 A0 E1 04 20 B3 E5 00 00 52 E3 03 00 00 0A 0A 00 52 E1 FA FF FF 1A 48 C0 1B E5 BE FE FF EA 64 10 1B E5 00 00 51 E3 12 00 00 0A 00 20 91 E5 00 00 52 E3 60 20 0B E5 04 20 81 E2 0F 00 00 0A 04 30 91 E5 0A 00 53 E1 F2 FF FF 0A 00 30 A0 E3 60 40 1B E5 01 30 83 E2 04 00 53 E1 07 00 00 0A 04 10 B2 E5 0A 00 51 E1 F8 FF FF 1A E9 FF FF EA 09 C0 A0 E1 A8 FE FF EA 64 00 1B E5 60 00 0B E5 0C 10 9B E5 25 3E 8A E2 0C 00 93 E8 04 10 11 E2 7C 10 0B E5 74 20 0B E5 70 30 0B E5 35 00 00 1A 68 34 9F E5 00 00 53 E3 64 04 9F 15 ?? ?? ?? ?? 18 30 99 E5 5C 24 9F E5 83 11 83 E0 81 30 83 E0 03 31 92 E7 0A 00 53 E1 00 00 53 13 03 00 00 0A 0C 30 93 E5 0A 00 53 E1 00 00 53 13 FB FF FF 1A 00 00 53 E3 00 40 E0 03 0C 00 00 0A 25 3E 8A E2 0C 00 93 E8 74 10 4B E2 03 00 91 E8 03 00 51 E1 02 00 50 01 65 00 00 0A 74 10 4B E2 03 00 91 E8 01 00 53 E1 00 00 52 01 00 40 A0 03 00 40 E0 13 F4 33 9F E5 00 00 53 E3 E4 03 9F 15 ?? ?? ?? ?? 7C 00 1B E5 00 00 50 E3 63 00 00 1A 01 00 74 E3 B4 FF FF 1A 58 30 1B E5 04 10 9B E5 08 20 9B E5 0C 40 9B E5 00 10 8D E5 04 20 8D E5 08 40 8D E5 0C 60 8D E5 08 00 A0 E1 09 10 A0 E1 05 20 A0 E1 ?? ?? ?? ?? 75 FE FF EA ?? ?? ?? ?? 13 3D 40 E2 04 30 83 E2 6C 00 0B E5 78 30 0B E5 6C 30 1B E5 BC 74 13 E5 00 10 A0 E3 07 40 A0 E1 78 20 1B E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 57 E1 EF FF FF 1A 02 00 57 E3 07 00 00 1A 6C 40 1B E5 B8 14 14 E5 78 00 1B E5 01 10 81 E3 01 20 A0 E3 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 14 33 9F E5 00 00 53 E3 10 03 9F 15 ?? ?? ?? ?? F0 31 99 E5 68 00 1B E5 03 00 50 E1 09 00 00 0A 00 00 53 E3 07 00 00 0A 00 20 93 E5 00 00 52 E3 04 00 00 0A 02 00 5A E1 18 00 00 0A 04 20 B3 E5 00 00 52 E3 FA FF FF 1A F4 31 99 E5 00 00 53 E3 99 FF FF 0A 64 10 1B E5 03 00 51 E1 81 00 00 0A 00 20 93 E5 00 00 52 E3 60 20 0B E5 04 20 83 E2 91 FF FF 0A 04 30 93 E5 03 00 5A E1 07 00 00 0A 00 30 A0 E3 60 40 1B E5 01 30 83 E2 04 00 53 E1 89 FF FF 0A 04 10 B2 E5 01 00 5A E1 F8 FF FF 1A 25 3E 8A E2 0C 00 93 E8 99 FF FF EA 04 32 9A E5 08 00 13 E3 05 00 00 1A 94 21 D9 E5 03 20 02 E2 02 00 52 E3 0D 00 00 0A 08 30 83 E3 04 32 8A E5 00 40 A0 E3 94 FF FF EA ?? ?? ?? ?? 01 30 A0 E3 BC 34 00 E5 0F CA E0 E3 0F E0 A0 E1 5F F0 4C E2 01 00 74 E3 4A FF FF 1A CC 31 99 E5 94 FF FF EA 04 22 99 E5 08 00 12 E3 EE FF FF 1A F8 71 99 E5 60 10 1B E5 01 00 57 E1 29 00 00 9A F4 31 99 E5 60 20 1B E5 02 31 83 E0 04 A0 83 E5 0F CA E0 E3 0F E0 A0 E1 5F F0 4C E2 60 40 1B E5 F4 31 99 E5 01 20 84 E2 00 20 83 E5 70 31 9F E5 00 30 93 E5 40 00 13 E3 DD FF FF 0A 04 10 9A E5 00 30 D1 E5 00 00 53 E3 05 00 00 1A 58 31 9F E5 00 20 93 E5 00 10 92 E5 50 31 9F E5 00 00 51 E3 03 10 A0 01 04 30 99 E5 00 20 D3 E5 00 00 52 E3 18 20 9A E5 05 00 00 1A 2C 31 9F E5 00 30 93 E5 00 30 93 E5 24 01 9F E5 00 00 53 E3 00 30 A0 01 18 00 99 E5 00 00 8D E5 70 01 9F E5 ?? ?? ?? ?? 00 40 A0 E3 59 FF FF EA 00 00 57 E3 87 70 A0 11 01 00 87 12 00 01 A0 11 2C 00 A0 03 0A 70 A0 03 80 30 0B E5 ?? ?? ?? ?? 80 30 1B E5 00 40 50 E2 08 30 83 03 04 32 8A 05 4C FF FF 0A 60 20 1B E5 00 00 52 E3 02 30 A0 01 08 00 00 0A 60 00 1B E5 F4 11 99 E5 00 31 A0 E1 03 20 A0 E1 04 10 81 E2 04 00 84 E2 80 30 0B E5 ?? ?? ?? ?? 80 30 1B E5 60 10 1B E5 03 30 84 E0 01 20 81 E2 04 A0 83 E5 00 20 84 E5 0F CA E0 E3 0F E0 A0 E1 5F F0 4C E2 F4 01 99 E5 00 00 50 E3 F8 71 89 E5 F4 41 89 E5 B9 FF FF 0A ?? ?? ?? ?? B7 FF FF EA 64 00 1B E5 60 10 1B E5 00 30 90 E5 01 00 53 E1 0F FF FF 9A 04 20 80 E2 01 11 92 E7 60 40 1B E5 01 00 5A E1 04 21 82 E0 82 FF FF 0A 04 10 A0 E1 01 10 81 E2 01 00 53 E1 03 00 00 9A 04 00 B2 E5 00 00 5A E1 F9 FF FF 1A 7A FF FF EA 60 30 0B E5 FF FE FF EA 05 15 00 00 ?? ?? ?? ?? 04 08 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? D6 02 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_219_3_0 {
	meta:
		name = "_dl_setup_hash"
		size = 172
		refs = "0098 __assert_fail"
	strings:
		$1 = { 4C 31 90 E5 00 00 53 E3 10 40 2D E9 13 00 00 0A 04 30 93 E5 00 C0 93 E5 78 C1 80 E5 08 20 93 E5 01 10 42 E2 02 00 11 E1 04 40 93 E5 15 00 00 1A 7C 11 80 E5 10 10 83 E2 02 21 81 E0 0C 30 93 E5 0C C1 82 E0 04 C1 4C E0 8C C1 80 E5 80 31 80 E5 88 21 80 E5 84 11 80 E5 10 40 BD E8 ?? ?? ?? ?? 30 30 90 E5 00 00 53 E3 FA FF FF 0A 04 30 93 E5 08 20 93 E4 02 11 83 E0 78 21 80 E5 88 11 80 E5 8C 31 80 E5 F3 FF FF EA 0C 00 9F E5 0C 10 9F E5 0C 20 9F E5 0C 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 67 03 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_220_0_0 {
	meta:
		name = "capset"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 B9 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_0_0 {
	meta:
		name = "__strftime_internal"
		size = 7024
		refs = "03fc memset 04b0 memcpy 05f4 strlen 08a4 mktime 0fbc __tzname 1474 _nl_get_alt_digit 18dc _nl_get_era_entry 1a04 __tzset"
	strings:
		$1 = { F0 4F 2D E9 74 D0 4D E2 08 60 93 E5 9C A0 9D E5 1C 60 8D E5 0C 00 56 E3 00 B0 A0 E1 01 60 A0 E1 28 00 93 E5 08 10 9A E5 20 30 8D E5 02 40 A0 E1 28 00 8D E5 24 10 8D E5 D1 00 00 DA 1C 20 9D E5 0C 20 42 E2 1C 20 8D E5 00 30 D4 E5 00 00 53 E3 6E 05 00 0A 00 70 A0 E3 06 80 A0 E1 09 00 00 EA 08 20 67 E0 01 00 52 E3 BD 00 00 9A 00 00 5B E3 01 30 CB 14 01 70 87 E2 01 30 D4 E5 00 00 53 E3 01 40 84 E2 F2 00 00 0A 25 00 53 E3 F3 FF FF 1A 00 20 A0 E3 18 20 8D E5 14 20 8D E5 04 10 A0 E1 01 30 D1 E5 01 10 81 E2 30 00 53 E3 01 40 A0 E1 22 00 00 0A 1B 00 00 8A 23 00 53 E3 01 20 A0 03 F6 FF FF 0A 2D 00 53 E3 1C 00 00 0A 30 00 43 E2 09 00 50 E3 00 50 E0 83 1A 00 00 8A B4 0E 9F E5 01 10 81 E2 00 50 A0 E3 0A 00 00 EA 01 30 51 E5 97 00 00 0A 05 51 85 E0 30 30 43 E2 85 50 83 E0 00 30 D1 E5 01 40 A0 E1 30 10 43 E2 09 00 51 E3 01 10 84 E2 0B 00 00 8A 00 00 55 E1 F2 FF FF DA 02 51 E0 E3 F5 FF FF EA 5E 00 53 E3 01 60 A0 03 18 60 8D 05 D9 FF FF 0A 5F 00 53 E3 E2 FF FF 1A 14 30 8D E5 D5 FF FF EA 45 00 53 E3 88 00 00 0A 4F 00 53 E3 00 90 A0 13 85 00 00 0A 7A 00 53 E3 03 F1 9F 97 8E 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 37 00 53 E3 65 FF FF DA 02 51 E0 E3 66 FF FF EA 00 00 A0 E3 74 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 03 90 A0 E1 01 40 84 E2 00 30 D4 E5 75 FF FF EA 1C 30 9D E5 00 00 53 E3 03 00 A0 E1 0C 30 A0 03 1C 30 8D E5 2A FF FF EA 01 30 54 E5 01 40 44 E2 25 00 53 E3 33 00 00 1A 04 90 A0 E1 01 60 A0 E3 05 50 66 E0 00 00 55 E3 05 30 86 A0 00 30 86 B2 08 20 67 E0 02 00 53 E1 E4 FF FF 2A 00 00 5B E3 19 00 00 0A 00 00 55 E3 09 00 00 DA 14 00 9D E5 30 00 50 E3 33 00 00 0A 0B 00 A0 E1 05 20 A0 E1 20 10 A0 E3 0C 30 8D E5 ?? ?? ?? ?? 0C 30 9D E5 05 B0 8B E0 18 10 9D E5 00 00 51 E3 22 00 00 0A 06 90 89 E0 01 20 46 E2 06 10 8B E0 01 C0 79 E5 3C 00 9A E5 01 20 42 E2 0C 01 90 E7 01 00 72 E3 01 00 61 E5 F8 FF FF 1A 06 B0 8B E0 03 70 87 E0 01 30 D4 E5 00 00 53 E3 01 40 84 E2 0C FF FF 1A 08 60 A0 E1 00 00 5B E3 00 00 56 13 00 30 A0 13 07 00 A0 11 07 00 A0 01 00 30 CB 15 74 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 01 30 44 E2 01 60 A0 E3 00 20 D3 E5 25 00 52 E3 03 90 A0 E1 01 60 86 E2 01 30 43 E2 F9 FF FF 1A C4 FF FF EA 09 10 A0 E1 0B 00 A0 E1 06 20 A0 E1 0C 30 8D E5 ?? ?? ?? ?? 0C 30 9D E5 DF FF FF EA 00 10 A0 E1 05 20 A0 E1 0B 00 A0 E1 0C 30 8D E5 05 B0 8B E0 ?? ?? ?? ?? 0C 30 9D E5 CA FF FF EA B8 9A 9F E5 98 00 9D E5 20 30 9D E5 01 04 8D E8 00 10 E0 E3 00 00 A0 E3 09 20 A0 E1 C0 FE FF EB 05 50 60 E0 00 00 55 E3 05 C0 80 A0 00 C0 80 B2 08 30 67 E0 03 00 5C E1 00 60 A0 E1 91 FF FF 2A 00 00 5B E3 0C 70 87 00 D3 FE FF 0A 00 00 55 E3 1E 04 00 DA 14 10 9D E5 30 00 51 E3 05 20 A0 E1 0B 00 A0 E1 20 10 A0 13 0C 30 8D E5 10 C0 8D E5 ?? ?? ?? ?? 0C 30 8D E2 08 10 93 E8 05 50 8B E0 98 20 9D E5 03 10 A0 E1 04 04 8D E8 05 00 A0 E1 20 30 9D E5 09 20 A0 E1 10 C0 8D E5 A0 FE FF EB 18 30 9D E5 10 C0 9D E5 00 00 53 E3 0C 70 87 E0 06 50 85 E0 EB 03 00 0A 0B 00 55 E1 E9 03 00 9A 00 20 DB E5 3C 30 9A E5 02 31 93 E7 01 30 CB E4 05 00 5B E1 F9 FF FF 1A AF FE FF EA 01 90 A0 E3 20 60 9D E5 08 10 96 E5 18 60 9D E5 00 00 52 E3 00 60 A0 13 18 60 8D E5 01 90 A0 13 24 60 9D E5 0B 00 51 E3 BC 30 A0 C3 B8 30 A0 D3 03 30 86 E0 04 00 93 E5 10 10 8D E5 ?? ?? ?? ?? 05 50 60 E0 00 00 55 E3 05 30 80 A0 00 30 80 B2 08 20 67 E0 02 00 53 E1 00 60 A0 E1 10 10 9D E5 51 FF FF 2A 00 00 5B E3 86 FF FF 0A 00 00 55 E3 0B 00 00 DA 14 00 9D E5 30 00 50 E3 23 04 00 0A 0B 00 A0 E1 20 10 A0 E3 05 20 A0 E1 0C 30 8D E5 ?? ?? ?? ?? 20 00 9D E5 0C 30 9D E5 08 10 90 E5 05 B0 8B E0 00 00 59 E3 D3 03 00 0A 0B 00 51 E3 24 10 9D E5 B8 20 A0 D3 BC 20 A0 C3 02 20 81 E0 00 00 56 E3 04 10 92 E5 01 20 46 E2 6D FF FF 0A 06 B0 8B E0 06 60 81 E0 0B 10 A0 E1 01 C0 76 E5 38 00 9A E5 01 20 42 E2 0C 01 90 E7 01 00 72 E3 01 00 61 E5 F8 FF FF 1A 62 FF FF EA 20 60 9D E5 18 30 96 E5 0C 19 9F E5 06 30 83 E2 93 01 C1 E0 C3 2F A0 E1 03 10 81 E0 41 21 62 E0 82 21 62 E0 03 30 62 E0 01 60 83 E2 01 00 55 E3 05 30 A0 A1 01 30 A0 B3 00 00 56 E3 4F 00 59 A3 06 00 A0 E1 5B 03 00 0A A6 2F B0 E1 00 00 66 12 43 C0 8D E2 90 18 9F E5 90 61 81 E0 A1 11 A0 E1 01 61 81 E0 86 00 40 E0 0C 60 A0 E1 30 C0 80 E2 00 00 51 E2 00 C0 C6 E5 01 C0 46 E2 F4 FF FF 1A 44 90 8D E2 00 00 52 E3 14 00 9D E5 2D 10 A0 13 01 10 46 15 01 60 46 12 2D 00 50 E3 1B 00 00 0A 06 C0 69 E0 03 C0 8C E0 00 00 5C E3 17 00 00 DA 5F 00 50 E3 7E 03 00 0A 08 10 67 E0 01 00 53 E1 FA FE FF 2A 00 00 52 E3 05 00 00 0A 00 00 5B E3 2D 30 A0 13 00 30 CB 15 01 60 86 E2 01 B0 8B 12 01 70 87 E2 00 00 5B E3 06 00 00 0A 0B 00 A0 E1 0C 20 A0 E1 30 10 A0 E3 10 C0 8D E5 ?? ?? ?? ?? 10 C0 9D E5 0C B0 8B E0 0C 70 87 E0 00 50 A0 E3 09 90 66 E0 05 50 69 E0 00 00 55 E3 05 30 89 A0 00 30 89 B2 08 20 67 E0 02 00 53 E1 DF FE FF 2A 00 00 5B E3 14 FF FF 0A 00 00 55 E3 09 00 00 DA 14 10 9D E5 30 00 51 E3 0B 00 A0 E1 05 20 A0 E1 52 03 00 0A 20 10 A0 E3 0C 30 8D E5 ?? ?? ?? ?? 0C 30 9D E5 05 B0 8B E0 18 20 9D E5 00 00 52 E3 3E 03 00 0A 00 00 59 E3 01 20 49 E2 02 FF FF 0A 09 B0 8B E0 0B 10 A0 E1 09 90 86 E0 01 C0 79 E5 3C 00 9A E5 01 20 42 E2 0C 01 90 E7 01 00 72 E3 01 00 61 E5 F8 FF FF 1A F7 FE FF EA 4F 00 59 E3 04 FF FF 0A 45 00 59 E3 B1 03 00 0A 24 60 9D E5 C8 90 96 E5 18 FF FF EA 20 E0 9D E5 0F 00 BE E8 44 C0 8D E2 0F 00 AC E8 0F 00 BE E8 0F 00 AC E8 07 00 9E E8 44 90 8D E2 07 00 8C E8 09 00 A0 E1 ?? ?? ?? ?? 43 C0 8D E2 A0 2F A0 E1 EC 16 9F E5 90 31 C1 E0 C0 3F A0 E1 41 11 63 E0 01 30 A0 E1 01 11 81 E0 81 10 40 E0 00 00 52 E3 00 10 61 12 30 10 81 E2 00 00 53 E3 0C 60 A0 E1 00 10 CC E5 03 00 A0 E1 01 C0 4C E2 EF FF FF 1A 01 30 A0 E3 8F FF FF EA 45 00 59 E3 DE FE FF 0A 20 10 9D E5 1C 10 81 E2 0A 00 11 E8 01 30 43 E0 B8 66 9F E5 07 30 83 E2 93 26 C6 E0 03 60 86 E0 C3 3F A0 E1 46 61 63 E0 02 00 55 E3 05 30 A0 A1 02 30 A0 B3 6C FF FF EA 01 50 45 E2 C5 6F C5 E1 01 60 86 E2 08 30 67 E0 03 00 56 E1 84 FE FF 2A 00 00 5B E3 0B 00 00 0A 00 00 55 E3 07 00 00 DA 14 00 9D E5 30 00 50 E3 C8 03 00 0A 0B 00 A0 E1 05 20 A0 E1 20 10 A0 E3 ?? ?? ?? ?? 05 B0 8B E0 09 30 A0 E3 01 30 CB E4 06 70 87 E0 B9 FD FF EA 24 60 9D E5 D0 90 96 E5 00 20 D9 E5 04 36 9F E5 00 00 52 E3 03 90 A0 01 CC FE FF EA 45 00 59 E3 B1 FE FF 0A 20 00 9D E5 01 00 55 E3 05 30 A0 A1 01 30 A0 B3 18 60 90 E5 47 FF FF EA 00 90 A0 E3 F9 FE FF EA 01 50 45 E2 C5 6F C5 E1 01 60 86 E2 08 30 67 E0 03 00 56 E1 5D FE FF 2A 00 00 5B E3 E4 FF FF 0A 00 00 55 E3 07 00 00 DA 14 20 9D E5 30 00 52 E3 9B 03 00 0A 0B 00 A0 E1 05 20 A0 E1 20 10 A0 E3 ?? ?? ?? ?? 05 B0 8B E0 0A 30 A0 E3 01 30 CB E4 D7 FF FF EA 45 00 59 E3 92 FE FF 0A 20 10 9D E5 10 60 91 E5 02 00 55 E3 05 30 A0 A1 02 30 A0 B3 01 60 86 E2 27 FF FF EA 45 00 59 E3 89 FE FF 0A 1C 60 9D E5 02 00 55 E3 05 30 A0 A1 02 30 A0 B3 14 20 9D E5 2D 00 52 E3 30 00 52 13 5F 20 A0 13 14 20 8D E5 1B FF FF EA 45 00 59 E3 7D FE FF 0A 20 10 9D E5 02 00 55 E3 05 30 A0 A1 02 30 A0 B3 08 60 91 E5 F1 FF FF EA 45 00 59 E3 75 FE FF 0A 20 20 9D E5 1C 60 92 E5 03 00 55 E3 05 30 A0 A1 03 30 A0 B3 01 60 86 E2 0A FF FF EA 45 00 59 E3 6C FE FF 0A 20 10 9D E5 02 00 55 E3 05 30 A0 A1 02 30 A0 B3 0C 60 91 E5 E0 FF FF EA 45 00 59 E3 64 FE FF 0A 20 00 9D E5 02 00 55 E3 05 30 A0 A1 02 30 A0 B3 0C 60 90 E5 FA FE FF EA 4F 00 59 E3 5C FE FF 0A 45 00 59 E3 30 03 00 0A 24 60 9D E5 C4 90 96 E5 70 FE FF EA 18 60 9D E5 00 00 52 E3 01 60 A0 13 00 00 59 E3 18 60 8D E5 51 FE FF 1A 20 60 9D E5 10 30 96 E5 24 60 9D E5 03 38 A0 E1 0E 38 83 E2 23 37 86 E0 24 10 93 E5 01 00 A0 E1 10 10 8D E5 ?? ?? ?? ?? 05 50 60 E0 00 00 55 E3 05 90 80 A0 00 90 80 B2 08 30 67 E0 03 00 59 E1 00 60 A0 E1 10 10 9D E5 F8 FD FF 2A 00 00 5B E3 20 00 00 0A 00 00 55 E3 0E 00 00 DA 14 00 9D E5 30 00 50 E3 D9 03 00 0A 0B 00 A0 E1 20 10 A0 E3 05 20 A0 E1 ?? ?? ?? ?? 20 00 9D E5 10 30 90 E5 24 10 9D E5 03 38 A0 E1 0E 38 83 E2 23 37 81 E0 24 10 93 E5 05 B0 8B E0 18 20 9D E5 00 00 52 E3 8F 02 00 0A 00 00 56 E3 01 30 46 E2 09 00 00 0A 06 B0 8B E0 0B 20 A0 E1 06 60 81 E0 01 00 76 E5 3C 10 9A E5 01 30 43 E2 00 11 91 E7 01 00 73 E3 01 10 62 E5 F8 FF FF 1A 09 70 87 E0 18 FD FF EA 20 60 9D E5 20 30 96 E5 00 00 53 E3 14 FD FF BA 24 30 96 E5 00 00 53 E3 01 60 45 E2 C6 02 00 BA C6 CF C6 E1 01 C0 8C E2 08 20 67 E0 02 00 5C E1 C6 FD FF 2A 00 00 5B E3 0F 00 00 0A 00 00 56 E3 0B 00 00 DA 14 00 9D E5 30 00 50 E3 06 20 A0 E1 0B 00 A0 E1 71 03 00 0A 20 10 A0 E3 0C 30 8D E5 10 C0 8D E5 ?? ?? ?? ?? 0C 30 8D E2 08 10 93 E8 06 B0 8B E0 2B 20 A0 E3 01 20 CB E4 0C 70 87 E0 10 13 9F E5 93 21 C1 E0 C3 2F A0 E1 03 30 81 E0 00 13 9F E5 C3 32 62 E0 93 61 C1 E0 C3 2F A0 E1 03 10 81 E0 C1 22 62 E0 02 12 62 E0 02 21 82 E0 01 31 43 E0 02 21 82 E0 02 61 83 E0 04 00 55 E3 05 30 A0 A1 04 30 A0 B3 82 FE FF EA 00 00 59 E3 E4 FD FF 1A 20 60 9D E5 10 30 96 E5 24 60 9D E5 03 38 A0 E1 1A 38 83 E2 23 37 86 E0 24 10 93 E5 00 00 52 E3 18 60 9D E5 01 00 A0 E1 01 60 A0 13 18 60 8D E5 10 10 8D E5 ?? ?? ?? ?? 05 50 60 E0 00 00 55 E3 05 90 80 A0 00 90 80 B2 08 30 67 E0 03 00 59 E1 00 60 A0 E1 10 10 9D E5 87 FD FF 2A 00 00 5B E3 AF FF FF 0A 00 00 55 E3 0E 00 00 DA 14 00 9D E5 30 00 50 E3 3C 03 00 0A 0B 00 A0 E1 20 10 A0 E3 05 20 A0 E1 ?? ?? ?? ?? 20 00 9D E5 10 30 90 E5 24 10 9D E5 03 38 A0 E1 1A 38 83 E2 23 37 81 E0 24 10 93 E5 05 B0 8B E0 18 20 9D E5 00 00 52 E3 1E 02 00 0A 00 00 56 E3 01 30 46 E2 98 FF FF 0A 06 B0 8B E0 06 10 81 E0 0B 20 A0 E1 01 C0 71 E5 3C 00 9A E5 01 30 43 E2 0C 01 90 E7 01 00 73 E3 01 00 62 E5 F8 FF FF 1A 8D FF FF EA 00 00 59 E3 A7 FD FF 1A 20 60 9D E5 18 30 96 E5 24 60 9D E5 03 38 A0 E1 07 38 83 E2 23 37 86 E0 24 10 93 E5 00 00 52 E3 18 60 9D E5 01 00 A0 E1 01 60 A0 13 18 60 8D E5 10 10 8D E5 ?? ?? ?? ?? 05 50 60 E0 00 00 55 E3 05 90 80 A0 00 90 80 B2 08 30 67 E0 03 00 59 E1 00 60 A0 E1 10 10 9D E5 4A FD FF 2A 00 00 5B E3 72 FF FF 0A 00 00 55 E3 0E 00 00 DA 14 00 9D E5 30 00 50 E3 0C 03 00 0A 0B 00 A0 E1 20 10 A0 E3 05 20 A0 E1 ?? ?? ?? ?? 20 00 9D E5 18 30 90 E5 24 10 9D E5 03 38 A0 E1 07 38 83 E2 23 37 81 E0 24 10 93 E5 05 B0 8B E0 18 20 9D E5 00 00 52 E3 E1 01 00 0A 00 00 56 E3 01 30 46 E2 5B FF FF 0A 06 B0 8B E0 06 10 81 E0 0B 20 A0 E1 01 C0 71 E5 3C 00 9A E5 01 30 43 E2 0C 01 90 E7 01 00 73 E3 01 00 62 E5 F8 FF FF 1A 50 FF FF EA 00 00 59 E3 36 FD FF 1A 01 50 45 E2 C5 6F C5 E1 01 60 86 E2 08 20 67 E0 02 00 56 E1 1E FD FF 2A 00 00 5B E3 A5 FE FF 0A 00 00 55 E3 A2 FE FF DA 14 00 9D E5 30 00 50 E3 ED 02 00 0A 0B 00 A0 E1 05 20 A0 E1 20 10 A0 E3 ?? ?? ?? ?? 05 B0 8B E0 00 30 D4 E5 98 FE FF EA 00 00 59 E3 54 FD FF 1A 80 90 9F E5 6B FD FF EA 45 00 59 E3 6D 02 00 0A 20 60 9D E5 14 20 96 E5 7C 10 9F E5 76 2E 82 E2 0C 20 82 E2 92 01 C1 E0 C2 3F A0 E1 C1 32 63 E0 03 11 83 E0 01 11 81 E0 01 21 42 E0 A2 6F 43 E0 01 00 55 E3 05 30 A0 A1 01 30 A0 B3 DC FD FF EA 45 00 59 E3 3E FD FF 0A 20 00 9D E5 02 00 55 E3 05 30 A0 A1 02 30 A0 B3 00 60 90 E5 D4 FD FF EA CC CC CC 0C ?? ?? ?? ?? CD CC CC CC 67 66 66 66 ?? ?? ?? ?? 89 88 88 88 ?? ?? ?? ?? 92 FE FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 1F 85 EB 51 6E 01 00 00 6D 01 00 00 93 24 49 92 ?? ?? ?? ?? 45 00 59 E3 26 FD FF 0A 20 60 9D E5 18 00 86 E2 01 10 90 E8 0C 20 60 E0 2C 00 8D E5 5F 2F 82 E2 30 00 1F E5 02 20 82 E2 }
	condition:
		$1
}

rule file_222_1_0 {
	meta:
		name = "__strftime_l"
		size = 44
	strings:
		$1 = { 04 E0 2D E5 14 D0 4D E2 10 C0 8D E2 00 E0 A0 E3 01 E0 6C E5 18 E0 9D E5 00 50 8D E8 1B F9 FF EB 14 D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_223_0_0 {
	meta:
		name = "__atomic_preadv64_replacement"
		size = 368
		refs = "0090 __libc_pread64 00d4 memcpy 00ec free 0104 __aeabi_read_tp 0130 __libc_alloca_cutoff 0148 malloc 016c __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 00 60 52 E2 20 B0 8D E2 14 D0 4D E2 00 50 A0 E1 01 70 A0 E1 51 00 00 DA 04 E0 91 E5 06 01 7E E3 00 C0 A0 93 0C 20 A0 91 01 40 A0 91 03 00 00 9A 31 00 00 EA 04 E0 94 E5 0E 00 53 E1 2E 00 00 3A 01 C0 8C E2 02 31 E0 E3 0E 20 82 E0 06 00 5C E1 08 40 84 E2 03 30 62 E0 F5 FF FF 1A 01 0A 52 E3 2F 00 00 8A 0E 30 82 E2 07 30 C3 E3 00 40 A0 E3 03 D0 4D E0 28 40 0B E5 08 A0 8D E2 18 00 9B E9 05 00 A0 E1 18 00 8D E8 0A 10 A0 E1 ?? ?? ?? ?? 00 90 50 E2 2F 00 00 BA 00 00 56 E3 09 50 A0 E1 0F 00 00 DA 00 80 A0 E3 02 00 00 EA 06 00 58 E1 08 70 87 E2 0A 00 00 0A 04 40 97 E5 04 00 55 E1 05 40 A0 31 0A 10 A0 E1 04 20 A0 E1 00 00 97 E5 ?? ?? ?? ?? 04 50 55 E0 01 80 88 E2 04 A0 8A E0 F1 FF FF 1A 28 00 1B E5 ?? ?? ?? ?? 09 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 64 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 00 90 E0 E3 03 20 80 E7 09 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 02 00 A0 E1 2C 20 0B E5 ?? ?? ?? ?? 00 00 50 E3 2C 20 1B E5 C9 FF FF 1A 02 00 A0 E1 2C 20 0B E5 ?? ?? ?? ?? 00 A0 50 E2 2C 20 1B E5 28 A0 0B E5 C8 FF FF 1A 00 90 E0 E3 E0 FF FF EA 00 20 A0 E3 BE FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_223_1_0 {
	meta:
		name = "preadv64"
		size = 276
		refs = "005c __aeabi_read_tp 008c __libc_enable_asynccancel 00c0 __libc_disable_asynccancel 0100 __libc_multiple_threads 0108 __libc_errno"
	strings:
		$1 = { F8 4F 2D E9 F4 30 9F E5 00 30 93 E5 00 00 53 E3 00 A0 A0 E1 01 90 A0 E1 02 80 A0 E1 28 60 9D E5 2C 50 9D E5 18 00 00 1A 06 30 A0 E1 05 40 A0 E1 CC 70 9F E5 00 00 00 EF 01 0A 70 E3 21 00 00 8A 00 40 A0 E1 00 00 54 E3 02 00 00 BA 04 00 A0 E1 F8 4F BD E8 ?? ?? ?? ?? A8 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 26 00 53 E3 F6 FF FF 1A 28 60 8D E5 2C 50 8D E5 0A 00 A0 E1 09 10 A0 E1 08 20 A0 E1 F8 4F BD E8 80 FF FF EA ?? ?? ?? ?? 05 40 A0 E1 00 B0 A0 E1 09 10 A0 E1 0A 00 A0 E1 08 20 A0 E1 06 30 A0 E1 54 70 9F E5 00 00 00 EF 01 0A 70 E3 00 40 A0 E1 09 00 00 8A 0B 00 A0 E1 ?? ?? ?? ?? DE FF FF EA 3C 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 D6 FF FF EA 24 30 9F E5 00 40 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 40 80 E7 00 40 E0 E3 EE FF FF EA ?? ?? ?? ?? 69 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_224_0_0 {
	meta:
		name = "__wcsncpy"
		size = 272
	strings:
		$1 = { 03 00 52 E3 F0 00 2D E9 04 60 40 E2 26 00 00 9A 01 C0 A0 E1 06 30 A0 E1 10 40 81 E2 22 71 A0 E1 10 00 00 EA 04 50 9C E5 00 00 55 E3 08 50 83 E5 2A 00 00 0A 08 50 9C E5 00 00 55 E3 0C 50 83 E5 2C 00 00 0A 0C 50 9C E5 00 00 55 E3 10 50 83 E5 10 C0 8C E2 06 30 A0 E1 09 00 00 0A 01 70 57 E2 10 40 84 E2 10 00 00 0A 10 10 14 E5 00 00 51 E3 04 10 83 E5 10 60 83 E2 04 10 A0 E1 E8 FF FF 1A 04 60 83 E2 01 20 42 E2 06 30 60 E0 43 21 52 E0 03 00 00 0A 00 30 A0 E3 01 20 52 E2 04 30 A6 E5 FC FF FF 1A F0 00 BD E8 ?? ?? ?? ?? 03 20 12 E2 FB FF FF 0A 04 30 86 E2 01 00 00 EA 00 00 5C E3 F3 FF FF 0A 04 C0 91 E4 01 20 52 E2 03 60 A0 E1 04 C0 83 E4 F8 FF FF 1A F0 00 BD E8 ?? ?? ?? ?? 08 60 83 E2 01 20 42 E2 06 30 60 E0 43 21 52 E0 E7 FF FF 1A EA FF FF EA 0C 60 83 E2 01 20 42 E2 06 30 60 E0 43 21 52 E0 E1 FF FF 1A E4 FF FF EA }
	condition:
		$1
}

rule file_225_0_0 {
	meta:
		name = "__wcschrnul"
		size = 56
	strings:
		$1 = { 00 30 90 E5 00 00 53 E3 ?? ?? ?? ?? 01 00 53 E1 ?? ?? ?? ?? 04 30 80 E2 01 00 00 EA 01 00 52 E1 ?? ?? ?? ?? 03 00 A0 E1 04 20 93 E4 00 00 52 E3 F9 FF FF 1A ?? ?? ?? ?? }
	condition:
		$1
}

rule file_228_0_0 {
	meta:
		name = "lrand48_r"
		size = 40
		refs = "0014 __nrand48_r"
	strings:
		$1 = { 08 40 2D E9 00 30 50 E2 01 20 A0 E1 03 00 00 0A 03 10 A0 E1 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? 00 00 E0 E3 FB FF FF EA }
	condition:
		$1
}

rule file_1029_0_0 {
	meta:
		name = "mrand48_r"
		size = 40
		refs = "0014 __jrand48_r"
	strings:
		$1 = { 08 40 2D E9 00 30 50 E2 01 20 A0 E1 03 00 00 0A 03 10 A0 E1 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? 00 00 E0 E3 FB FF FF EA }
	condition:
		$1
}

rule file_229_0_0 {
	meta:
		name = "getw"
		size = 52
		refs = "0018 _IO_fread"
	strings:
		$1 = { 04 E0 2D E5 0C D0 4D E2 00 30 A0 E1 04 10 A0 E3 04 00 8D E2 01 20 A0 E3 ?? ?? ?? ?? 01 00 50 E3 04 00 9D 05 00 00 E0 13 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_230_0_0 {
	meta:
		name = "__dcgettext"
		size = 40
		refs = "0018 __dcigettext"
	strings:
		$1 = { 04 E0 2D E5 00 30 A0 E3 0C D0 4D E2 04 20 8D E5 00 30 8D E5 03 20 A0 E1 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_231_0_0 {
	meta:
		name = "tcsendbreak"
		size = 64
		refs = "0028 __ioctl"
	strings:
		$1 = { 00 00 51 E3 28 20 9F C5 63 10 81 C2 08 40 2D E9 91 32 C2 C0 C1 1F A0 C1 C2 22 61 C0 14 10 9F D5 00 20 A0 D3 10 10 9F C5 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? 1F 85 EB 51 09 54 00 00 25 54 00 00 }
	condition:
		$1
}

rule file_234_0_0 {
	meta:
		name = "_IO_mem_sync"
		size = 100
		refs = "0050 _IO_str_overflow"
	strings:
		$1 = { 18 20 90 E5 14 30 90 E5 02 00 53 E1 00 20 A0 13 10 40 2D E9 00 40 A0 E1 00 20 C3 15 0A 00 00 0A A8 30 94 E5 10 20 94 E5 00 20 83 E5 AC 30 94 E5 14 10 84 E2 06 00 11 E8 01 20 42 E0 00 00 A0 E3 00 20 83 E5 10 40 BD E8 ?? ?? ?? ?? 00 10 A0 E3 ?? ?? ?? ?? 14 30 94 E5 01 30 43 E2 14 30 84 E5 EE FF FF EA }
	condition:
		$1
}

rule file_234_1_0 {
	meta:
		name = "_IO_mem_finish"
		size = 116
		refs = "001c realloc 0068 _IO_str_finish"
	strings:
		$1 = { 38 40 2D E9 00 40 A0 E1 10 00 80 E2 03 00 90 E8 01 10 60 E0 01 10 81 E2 A8 50 94 E5 ?? ?? ?? ?? 00 00 85 E5 A8 30 94 E5 00 30 93 E5 00 00 53 E3 0A 00 00 0A 14 00 84 E2 03 00 10 E8 00 10 41 E0 00 20 A0 E3 01 20 C3 E7 AC 30 94 E5 14 00 84 E2 03 00 10 E8 00 10 41 E0 00 10 83 E5 1C 20 84 E5 04 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 38 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_234_2_0 {
	meta:
		name = "open_memstream"
		size = 164
		refs = "0010 malloc 002c calloc 0040 _IO_init 005c _IO_str_init_static_internal 00a0 free"
	strings:
		$1 = { F8 40 2D E9 00 60 A0 E1 5E 0F A0 E3 01 50 A0 E1 ?? ?? ?? ?? 00 40 50 E2 1C 00 00 0A B0 30 84 E2 48 30 84 E5 01 00 A0 E3 02 1A A0 E3 ?? ?? ?? ?? 00 70 50 E2 15 00 00 0A 04 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 4C 20 9F E5 07 10 A0 E1 07 30 A0 E1 98 20 84 E5 04 00 A0 E1 02 2A A0 E3 ?? ?? ?? ?? 00 10 94 E5 30 20 9F E5 30 30 9F E5 01 10 C1 E3 A8 60 84 E5 AC 50 84 E5 00 10 84 E5 A0 20 84 E5 A4 30 84 E5 04 00 A0 E1 F8 40 BD E8 ?? ?? ?? ?? 00 00 A0 E3 FB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_235_0_0 {
	meta:
		name = "__getrusage"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 4D 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_236_0_0 {
	meta:
		name = "profil_count"
		size = 332
	strings:
		$1 = { F0 00 2D E9 38 61 9F E5 08 30 96 E5 10 20 93 E5 02 00 50 E1 03 00 00 3A 14 20 93 E5 02 00 50 E1 03 C0 A0 31 14 00 00 3A 90 00 96 E8 00 20 A0 E3 01 40 44 E2 05 00 00 EA 14 20 9C E5 02 00 50 E1 20 00 00 3A 01 20 83 E2 02 00 54 E1 09 00 00 3A 04 30 82 E0 A3 30 A0 E1 83 C0 83 E0 8C C1 87 E0 10 50 9C E5 05 00 50 E1 F2 FF FF 2A 01 40 43 E2 02 00 54 E1 F5 FF FF 2A 0C 30 96 E5 00 20 93 E5 00 00 51 E3 00 00 62 E0 08 10 93 E5 10 00 00 0A 20 01 A0 E1 90 21 83 E0 04 10 9C E5 22 28 A0 E1 03 28 82 E1 01 00 52 E1 1F 00 00 3A 0C 30 96 E5 0C 30 93 E5 00 20 93 E5 01 20 82 E2 00 20 83 E5 F0 00 BD E8 ?? ?? ?? ?? 08 C0 86 E5 0C 30 96 E5 E9 FF FF EA A0 00 A0 E1 90 21 83 E0 04 10 9C E5 22 28 A0 E1 03 28 82 E1 01 00 52 E1 07 00 00 2A 0C 10 9C E5 82 20 A0 E1 B2 30 91 E1 44 00 9F E5 00 00 53 E1 01 30 83 12 B2 30 81 11 EB FF FF EA 0C 30 96 E5 0C 30 93 E5 B0 20 D3 E1 01 20 82 E2 B0 20 C3 E1 F0 00 BD E8 ?? ?? ?? ?? 0C 10 9C E5 02 31 91 E7 01 00 73 E3 01 30 83 12 02 31 81 17 DE FF FF EA ?? ?? ?? ?? FF FF 00 00 }
	condition:
		$1
}

rule file_236_1_0 {
	meta:
		name = "pcmp"
		size = 44
	strings:
		$1 = { 00 30 90 E5 00 10 91 E5 08 20 93 E5 08 30 91 E5 03 00 52 E1 02 00 00 3A 00 00 A0 93 00 00 E0 83 ?? ?? ?? ?? 01 00 A0 E3 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_236_2_0 {
	meta:
		name = "insert.part.0"
		size = 276
		refs = "0028 malloc 0068 __aeabi_uidiv 00cc realloc 00fc memmove"
	strings:
		$1 = { F8 4F 2D E9 04 51 9F E5 00 C0 95 E5 00 00 5C E3 00 40 A0 E1 01 A0 A0 E1 02 90 A0 E1 03 60 A0 E1 25 00 00 1A 18 00 A0 E3 ?? ?? ?? ?? 00 70 A0 E1 00 00 57 E3 33 00 00 0A 00 80 95 E5 04 20 58 E0 C8 B0 9F E5 23 00 00 1A 84 40 84 E0 84 41 87 E0 28 30 9D E5 01 08 96 E9 00 00 53 E3 02 10 A0 03 04 10 A0 13 00 B0 84 E5 ?? ?? ?? ?? 00 20 96 E5 0C 30 96 E5 00 00 5B E3 01 80 88 E2 04 00 84 E5 0C 20 84 E5 00 80 85 E5 08 30 84 E5 10 A0 84 E5 14 90 84 E5 04 70 85 E5 70 20 9F E5 00 00 A0 13 03 00 00 1A 02 00 53 E3 0C 70 82 05 0B 00 A0 01 0B 00 A0 11 F8 4F BD E8 ?? ?? ?? ?? 01 C0 8C E2 8C 10 8C E0 81 11 A0 E1 04 00 95 E5 ?? ?? ?? ?? 00 70 A0 E1 D5 FF FF EA 01 40 84 E2 84 40 84 E0 84 01 A0 E1 18 40 40 E2 82 20 82 E0 04 40 87 E0 82 21 A0 E1 00 00 87 E0 04 10 A0 E1 ?? ?? ?? ?? 00 80 9B E5 D1 FF FF EA 00 00 E0 E3 E8 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_236_3_0 {
	meta:
		name = "profil_counter_ushort"
		size = 24
	strings:
		$1 = { 08 40 2D E9 5C 00 92 E5 00 10 A0 E3 A8 FF FF EB 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_236_4_0 {
	meta:
		name = "profil_counter_uint"
		size = 24
	strings:
		$1 = { 08 40 2D E9 5C 00 92 E5 01 10 A0 E3 A2 FF FF EB 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_236_5_0 {
	meta:
		name = "__sprofil"
		size = 1024
		refs = "0034 __profile_frequency 0040 __aeabi_idiv 00c0 qsort 010c __aeabi_uldivmod 011c __aeabi_uidiv 0218 free 02e0 __sigaction 0318 __setitimer 03cc __assert_fail 03e0 pcmp 03e4 profil_counter_uint 03e8 profil_counter_ushort"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 BC D0 4D E2 D0 10 0B E5 01 11 A0 E1 0A 10 81 E2 07 10 C1 E3 01 D0 4D E0 00 50 52 E2 00 60 A0 E1 D4 30 0B E5 08 40 8D E2 0B 00 00 0A ?? ?? ?? ?? 00 10 A0 E1 8C 03 9F E5 ?? ?? ?? ?? 88 13 9F E5 90 21 81 E0 21 19 A0 E1 81 32 61 E0 03 33 63 E0 83 31 81 E0 03 23 40 E0 06 00 85 E8 6C A3 9F E5 00 20 9A E5 00 00 52 E3 B6 00 00 1A D0 C0 1B E5 5C 33 9F E5 00 00 5C E3 04 20 8A E5 0C 30 8A E5 C5 00 00 DA 04 E0 44 E2 06 30 A0 E1 0C 12 86 E0 0E 20 A0 E1 04 30 A2 E5 10 30 83 E2 01 00 53 E1 FB FF FF 1A 04 00 A0 E1 D0 10 1B E5 04 20 A0 E3 20 33 9F E5 CC E0 0B E5 ?? ?? ?? ?? D4 C0 1B E5 01 70 0C E2 00 C0 A0 E3 C8 C0 0B E5 CC C0 1B E5 04 50 BC E5 0C 60 95 E5 01 00 56 E3 CC C0 0B E5 5D 00 00 9A 00 00 57 E3 04 10 95 E5 8B 00 00 0A 21 81 A0 E1 08 09 A0 E1 21 18 A0 E1 06 20 A0 E1 00 30 A0 E3 ?? ?? ?? ?? 08 90 95 E5 04 10 A0 E3 09 40 80 E0 ?? ?? ?? ?? 90 26 83 E0 03 10 A0 E1 22 38 A0 E1 01 38 83 E1 03 00 58 E1 01 40 84 82 09 00 E0 E1 00 00 57 E3 02 10 A0 03 04 10 A0 13 04 00 80 E0 ?? ?? ?? ?? 90 26 83 E0 03 10 A0 E1 22 38 A0 E1 01 38 83 E1 03 00 58 E1 94 00 00 9A 00 00 57 E3 02 10 A0 03 04 10 A0 13 04 00 69 E0 ?? ?? ?? ?? 90 26 83 E0 03 10 A0 E1 22 38 A0 E1 01 38 83 E1 03 00 58 E1 02 00 A0 E1 88 00 00 8A 00 30 9A E5 00 00 53 E3 03 00 A0 01 25 00 00 0A 28 32 9F E5 04 10 93 E5 00 60 A0 E3 01 C0 A0 E1 09 10 A0 E1 06 00 00 EA 04 C0 9A E5 08 00 8C E0 00 30 9A E5 01 60 86 E2 03 00 56 E1 14 10 90 E5 16 00 00 2A 86 80 86 E0 88 81 A0 E1 08 00 8C E0 10 20 90 E5 02 00 51 E1 F4 FF FF 2A 04 00 52 E1 0E 00 00 8A 00 70 8D E5 06 00 A0 E1 05 30 A0 E1 37 FF FF EB 00 00 50 E3 EA FF FF AA 04 00 9A E5 ?? ?? ?? ?? 00 30 A0 E3 00 30 8A E5 04 30 8A E5 00 00 E0 E3 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 01 90 A0 E1 06 00 A0 E1 04 00 59 E1 06 00 00 2A 00 70 8D E5 09 10 A0 E1 04 20 A0 E1 05 30 A0 E1 23 FF FF EB 00 00 50 E3 EB FF FF BA C8 C0 1B E5 D0 10 1B E5 01 C0 8C E2 01 00 5C E1 C8 C0 0B E5 95 FF FF 1A 00 00 9A E5 00 00 50 E3 4C 31 9F E5 E7 FF FF 0A D4 C0 1B E5 04 20 93 E5 01 00 1C E3 08 20 83 E5 40 31 9F 15 40 31 9F 05 01 22 A0 E3 B0 30 0B E5 24 30 4B E2 08 20 23 E5 AC 10 4B E2 00 20 E0 E3 04 20 23 E5 01 00 53 E1 FC FF FF 1A 2C 30 1B E5 1B 00 A0 E3 04 30 83 E3 B0 10 4B E2 0C 21 9F E5 2C 30 0B E5 ?? ?? ?? ?? 00 00 50 E3 CE FF FF BA 00 20 A0 E3 01 30 A0 E3 B8 20 0B E5 B4 30 0B E5 B8 30 4B E2 03 00 93 E8 C0 30 4B E2 03 00 83 E8 DC 20 9F E5 03 10 A0 E1 02 00 A0 E3 ?? ?? ?? ?? 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? A1 80 A0 E1 88 08 A0 E1 21 18 A0 E1 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 08 90 95 E5 02 10 A0 E3 09 40 80 E0 72 FF FF EA 02 00 A0 E3 10 10 8A E2 00 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 AF FF FF BA A4 30 9A E5 1B 00 A0 E3 04 30 83 E3 20 10 8A E2 00 20 A0 E3 A4 30 8A E5 ?? ?? ?? ?? 00 00 50 E3 A6 FF FF BA 04 00 9A E5 ?? ?? ?? ?? 00 00 A0 E3 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 04 00 A0 E1 D0 10 1B E5 04 20 A0 E3 28 30 9F E5 ?? ?? ?? ?? AF FF FF EA 30 00 9F E5 30 10 9F E5 65 20 A0 E3 2C 30 9F E5 ?? ?? ?? ?? 40 42 0F 00 83 DE 1B 43 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_237_0_0 {
	meta:
		name = "__memrchr"
		size = 304
	strings:
		$1 = { 00 00 52 E3 70 00 2D E9 02 00 80 E0 FF 10 01 E2 0D 00 00 0A 03 00 10 E3 17 00 00 0A 01 30 50 E5 01 00 53 E1 01 00 40 E2 05 00 00 1A 10 00 00 EA 03 00 10 E3 10 00 00 0A 01 30 70 E5 01 00 53 E1 0B 00 00 0A 01 20 52 E2 F8 FF FF 1A 00 20 A0 E3 00 20 62 E0 03 00 00 EA 01 30 50 E5 01 00 53 E1 01 00 40 E2 02 00 00 0A 02 00 50 E1 F9 FF FF 1A 00 00 A0 E3 70 00 BD E8 ?? ?? ?? ?? 01 64 81 E1 03 00 52 E3 06 68 86 E1 F0 FF FF 9A 04 C0 40 E2 00 40 A0 E1 0A 00 00 EA 02 30 D4 E5 01 00 53 E1 1A 00 00 0A 01 30 D4 E5 01 00 53 E1 1A 00 00 0A 04 30 DC E5 01 00 53 E1 ED FF FF 0A 03 00 52 E3 E2 FF FF 9A 04 30 34 E5 58 00 9F E5 06 30 23 E0 03 50 E0 E1 00 00 83 E0 4C 30 9F E5 00 00 25 E0 03 30 00 E0 00 00 53 E3 0C 00 A0 E1 04 20 42 E2 04 C0 4C E2 F0 FF FF 0A 03 30 D4 E5 01 00 53 E1 E4 FF FF 1A 03 00 80 E2 70 00 BD E8 ?? ?? ?? ?? 02 00 80 E2 70 00 BD E8 ?? ?? ?? ?? 01 00 80 E2 70 00 BD E8 ?? ?? ?? ?? FF FE FE 7E 00 01 01 81 }
	condition:
		$1
}

rule file_238_0_0 {
	meta:
		name = "rewinddir"
		size = 224
		refs = "0050 __lseek 00b4 __lll_lock_wait_private 00bc __aeabi_read_tp"
	strings:
		$1 = { F8 40 2D E9 04 70 80 E2 00 50 A0 E1 07 20 A0 E1 01 10 A0 E3 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 1A 00 00 1A 00 10 A0 E3 01 20 A0 E1 00 00 95 E5 ?? ?? ?? ?? 00 30 A0 E3 14 30 85 E5 10 30 85 E5 0C 30 85 E5 04 60 95 E5 00 10 A0 E3 06 40 A0 E1 07 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 04 00 00 CA F8 40 BD E8 ?? ?? ?? ?? 07 00 A0 E1 ?? ?? ?? ?? E1 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 07 00 A0 E1 02 10 81 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF F1 FF FF EA }
	condition:
		$1
}

rule file_239_0_0 {
	meta:
		name = "__fgets_unlocked_chk"
		size = 200
		refs = "004c _IO_getline 0088 __aeabi_read_tp 00c0 __chk_fail 00c4 __libc_errno"
	strings:
		$1 = { F0 40 2D E9 00 00 52 E3 0C D0 4D E2 00 50 A0 E1 01 60 A0 E1 03 40 A0 E1 26 00 00 DA 00 C0 93 E5 01 20 42 E2 20 10 CC E3 01 30 A0 E3 00 10 84 E5 06 00 52 E1 06 20 A0 21 00 30 8D E5 04 00 A0 E1 05 10 A0 E1 0A 30 A0 E3 20 70 0C E2 ?? ?? ?? ?? 00 20 50 E2 07 00 00 1A 00 30 94 E5 02 50 A0 E1 07 30 83 E1 00 30 84 E5 05 00 A0 E1 0C D0 8D E2 F0 40 BD E8 ?? ?? ?? ?? 00 30 94 E5 20 00 13 E3 06 00 00 0A 38 10 9F E5 ?? ?? ?? ?? 01 10 9F E7 01 10 90 E7 0B 00 51 E3 00 50 A0 13 EF FF FF 1A 02 00 56 E1 05 00 00 9A 00 30 A0 E3 02 30 C5 E7 00 30 94 E5 E9 FF FF EA 00 00 A0 E3 EA FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_240_0_0 {
	meta:
		name = "ntp_gettimex"
		size = 104
		refs = "001c __adjtimex"
	strings:
		$1 = { 70 40 2D E9 80 D0 4D E2 00 40 A0 E1 00 50 A0 E3 80 30 8D E2 0D 00 A0 E1 80 50 23 E5 ?? ?? ?? ?? 24 30 8D E2 00 C0 A0 E1 03 00 93 E8 0C 60 9D E5 10 20 9D E5 50 30 9D E5 03 00 84 E8 0C 00 A0 E1 14 50 84 E5 18 50 84 E5 1C 50 84 E5 20 50 84 E5 08 60 84 E5 0C 20 84 E5 10 30 84 E5 80 D0 8D E2 70 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_241_0_0 {
	meta:
		name = "__stpcpy"
		size = 32
	strings:
		$1 = { 00 20 D1 E5 00 30 A0 E1 01 20 C3 E4 01 20 D1 E4 00 00 52 E3 ?? ?? ?? ?? 03 00 A0 E1 F7 FF FF EA }
	condition:
		$1
}

rule file_242_0_0 {
	meta:
		name = "_dl_build_local_scope"
		size = 128
	strings:
		$1 = { 70 40 2D E9 00 10 80 E5 94 31 D1 E5 F0 41 91 E5 40 30 C3 E3 20 30 83 E3 00 00 54 E3 00 60 A0 E1 94 31 C1 E5 04 50 80 E2 10 00 00 0A 04 10 94 E5 00 00 51 E3 04 40 84 E2 03 00 00 1A 0B 00 00 EA 04 10 B4 E5 00 00 51 E3 08 00 00 0A 94 31 D1 E5 60 00 13 E3 F9 FF FF 1A 05 00 A0 E1 E7 FF FF EB 04 10 B4 E5 00 00 51 E3 00 51 85 E0 F6 FF FF 1A 05 00 66 E0 40 01 A0 E1 70 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_242_1_0 {
	meta:
		name = "openaux"
		size = 72
		refs = "0034 _dl_map_object"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 08 30 94 E5 00 00 90 E5 08 D0 4D E2 94 21 D0 E5 00 30 8D E5 18 C0 90 E5 03 20 12 E2 10 10 94 E5 04 30 94 E5 01 20 A0 03 04 C0 8D E5 ?? ?? ?? ?? 14 00 84 E5 08 D0 8D E2 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_242_2_0 {
	meta:
		name = "_dl_map_object_deps"
		size = 4092
		refs = "00c4 __aeabi_read_tp 018c strchr 01b4 _dl_catch_error 0234 malloc 0258 memcpy 0380 strlen 0678 memset 0784 memmove 081c _dl_scope_free 0968 _dl_dst_count 09f0 _dl_dst_substitute 0a18 _dl_debug_printf 0a38 _dl_get_origin 0a64 _dl_signal_error 0a84 __assert_fail 0be8 free 0f84 __libc_errno 0f8c openaux 0f9c _dl_debug_mask 0fa0 __libc_enable_secure 0fa4 _dl_platformlen 0fc8 _dl_argv 0fe8 _dl_ns"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 6C D0 4D E2 60 00 0B E5 60 40 1B E5 82 E0 82 E0 0E E1 A0 E1 94 C1 D4 E5 26 00 8E E2 07 00 C0 E3 00 D0 4D E0 40 C0 CC E3 60 00 1B E5 08 90 8D E2 14 40 8D E2 00 50 A0 E3 20 C0 8C E3 00 00 52 E3 0C 00 8D E5 10 40 8D E5 08 50 8D E5 68 90 0B E5 6C 30 0B E5 94 C1 C0 E5 88 02 00 0A 01 00 A0 E1 02 41 81 E0 20 30 8D E2 04 10 90 E4 94 C1 D1 E5 40 C0 CC E3 20 C0 8C E3 04 00 50 E1 08 10 03 E5 0C 50 03 E5 04 30 03 E5 0C 30 83 E2 94 C1 C1 E5 F4 FF FF 1A 68 40 1B E5 01 20 82 E2 54 20 0B E5 04 A0 94 E5 68 40 1B E5 00 30 A0 E3 0E E0 84 E0 50 E0 0B E5 08 30 8E E5 BC 1E 9F E5 ?? ?? ?? ?? 01 10 9F E7 B4 2E 9F E5 44 30 0B E5 01 10 90 E7 02 20 9F E7 02 30 80 E7 74 30 0B E5 7C 10 0B E5 78 30 0B E5 5C 40 0B E5 5C 31 9A E5 5C 40 1B E5 01 20 A0 E3 00 00 53 E3 00 20 84 E5 00 70 A0 13 79 00 00 0A 24 30 9A E5 00 00 53 E3 6F 00 00 0A 08 50 9A E5 34 20 9A E5 00 30 95 E5 04 80 92 E5 6C 40 1B E5 04 90 9B E5 00 00 53 E3 3C A0 0B E5 30 80 0B E5 38 40 0B E5 34 90 0B E5 33 00 00 0A 5C 40 1B E5 08 50 85 E2 64 40 0B E5 00 60 A0 E3 05 00 00 EA 00 00 57 E3 06 31 87 17 01 60 86 12 08 30 95 E4 00 00 53 E3 29 00 00 0A 01 00 53 E3 AD 01 00 1A 04 40 15 E5 04 40 88 E0 04 00 A0 E1 24 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 F2 01 00 1A 3C 30 4B E2 2C 40 0B E5 40 00 4B E2 00 30 8D E5 44 10 4B E2 45 20 4B E2 D4 3D 9F E5 ?? ?? ?? ?? 44 90 1B E5 00 00 59 E3 6C 00 00 1A 28 30 1B E5 94 21 D3 E5 A2 22 A0 E1 03 20 12 E2 E0 FF FF 1A 94 01 D3 E5 54 90 1B E5 18 D0 4D E2 50 40 1B E5 40 00 C0 E3 08 10 8D E2 20 00 80 E3 01 90 89 E2 0C 30 8D E5 08 20 8D E5 10 20 8D E5 54 90 0B E5 08 10 84 E5 50 10 0B E5 94 01 C3 E5 D0 FF FF EA 03 60 A0 E1 00 00 57 E3 19 00 00 0A 00 30 A0 E3 86 01 A0 E1 06 31 87 E7 0C 00 80 E2 ?? ?? ?? ?? 00 40 50 E2 06 61 A0 E1 15 02 00 0A 04 00 A0 E1 04 50 86 E2 07 10 A0 E1 05 20 A0 E1 04 A0 80 E4 ?? ?? ?? ?? 08 00 86 E2 05 20 A0 E1 00 00 84 E0 04 10 A0 E1 ?? ?? ?? ?? 0F CA E0 E3 0F E0 A0 E1 5F F0 4C E2 96 31 DA E5 01 30 83 E3 F0 41 8A E5 96 31 CA E5 5C 40 1B E5 00 30 94 E5 00 00 53 E3 0B 00 00 0A 5C 30 1B E5 02 00 00 EA 00 20 93 E5 00 00 52 E3 05 00 00 0A 08 30 93 E5 00 00 53 E3 F9 FF FF 1A 5C 30 0B E5 03 40 A0 E1 47 00 00 EA 5C 30 0B E5 5C 90 1B E5 04 A0 99 E5 85 FF FF EA F0 30 9A E5 00 00 53 E3 8C FF FF 1A E8 60 9A E5 00 00 56 E3 89 FF FF 1A C9 FF FF EA F0 71 9A E5 00 00 57 E3 03 70 A0 11 81 FF FF 1A 60 90 1B E5 0A 00 59 E1 7E FF FF 0A 78 3C 9F E5 B3 70 9A E1 00 00 57 E3 7A FF FF 0A 74 40 1B E5 07 71 A0 E1 04 00 57 E1 78 70 1B 95 75 FF FF 9A 0F 30 87 E2 0F 30 C3 E3 0E 20 83 E2 A2 21 A0 E1 0D 90 A0 E1 82 91 49 E0 09 D0 A0 E1 08 70 8D E2 78 40 1B E5 03 20 87 E0 02 00 54 E1 74 90 1B 05 03 90 89 00 74 90 0B 05 74 30 0B 15 78 70 0B E5 64 FF FF EA 00 40 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 0F 30 80 E2 07 30 C3 E3 03 D0 4D E0 01 20 80 E2 09 10 A0 E1 08 00 8D E2 ?? ?? ?? ?? 40 60 1B E5 00 50 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 0F 30 80 E2 07 30 C3 E3 03 D0 4D E0 01 20 80 E2 06 10 A0 E1 08 00 8D E2 ?? ?? ?? ?? 45 30 5B E5 00 00 53 E3 40 00 0B E5 C7 02 00 1A 00 00 54 E3 44 50 0B E5 00 40 E0 03 A4 3B 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 00 00 53 E3 04 00 00 1A 7C 90 1B E5 00 00 59 E3 88 3B 9F 15 03 30 9F 17 03 90 80 17 60 30 1B E5 F0 31 93 E5 00 00 53 E3 64 30 0B E5 06 00 00 0A 60 90 1B E5 94 31 D9 E5 03 30 03 E2 02 00 53 E3 00 30 A0 13 64 30 0B 15 88 01 00 0A 54 90 1B E5 89 01 A0 E1 04 00 80 E2 ?? ?? ?? ?? 00 00 50 E3 50 00 0B E5 A0 02 00 0A 54 90 1B E5 01 30 89 E2 50 90 1B E5 60 C0 1B E5 03 31 89 E0 54 90 1B E5 5C 31 8C E5 60 91 8C E5 0C 10 A0 E1 68 20 1B E5 6C C0 1B E5 00 50 A0 E3 00 00 5C E3 04 30 92 E5 66 02 00 1A 5C 01 91 E5 05 31 80 E7 04 30 92 E5 01 50 85 E2 08 20 92 E5 94 01 D3 E5 00 00 52 E3 60 00 C0 E3 94 01 C3 E5 F2 FF FF 1A D0 3A 9F E5 00 30 93 E5 02 0B 13 E3 68 20 0B E5 41 02 00 1A 60 90 1B E5 5C 11 99 E5 00 30 91 E5 09 00 53 E1 5C 30 0B E5 36 02 00 1A 60 90 1B E5 F4 71 99 E5 00 00 57 E3 2A 02 00 0A 01 00 55 E3 25 02 00 9A 05 91 A0 E1 01 30 A0 E1 58 90 0B E5 04 10 41 E2 09 10 81 E0 04 20 B3 E5 94 01 D2 E5 40 00 C0 E3 20 00 80 E3 01 00 53 E1 94 01 C2 E5 F8 FF FF 1A 00 30 97 E5 00 00 53 E3 04 70 87 E2 32 00 00 0A 54 40 0B E5 00 60 A0 E3 5C 40 1B E5 04 00 00 EA F4 11 94 E5 00 30 91 E5 01 60 86 E2 06 00 53 E1 28 00 00 9A 06 31 97 E7 94 31 D3 E5 06 A1 A0 E1 60 00 13 E3 0A 90 87 E0 F4 FF FF 0A F8 01 94 E5 01 00 80 E2 00 01 A0 E1 ?? ?? ?? ?? 00 80 50 E2 EE FF FF 0A 0A 20 A0 E1 07 10 A0 E1 04 00 88 E2 ?? ?? ?? ?? F4 11 94 E5 00 A0 91 E5 01 00 86 E2 0A 00 50 E1 F4 01 00 2A 0A 21 87 E0 09 30 A0 E1 06 C0 A0 E1 04 90 42 E2 04 20 B3 E5 94 E1 D2 E5 60 00 1E E3 0C E1 88 00 04 20 8E 05 01 C0 8C 02 09 00 53 E1 F7 FF FF 1A 01 A0 4A E2 00 00 8A E0 00 60 66 E0 00 C0 88 E5 00 30 91 E5 01 60 86 E2 06 00 53 E1 D6 FF FF 8A 54 40 1B E5 01 00 55 E3 D7 01 00 9A 5C 90 1B E5 5C 11 99 E5 58 C0 1B E5 04 00 41 E2 0C 00 80 E0 01 30 A0 E1 04 20 B3 E5 94 C1 D2 E5 00 00 53 E1 60 C0 CC E3 94 C1 C2 E5 F9 FF FF 1A 50 00 1B E5 58 20 1B E5 ?? ?? ?? ?? 85 20 A0 E1 08 30 82 E2 07 30 C3 E3 70 D0 0B E5 03 D0 4D E0 08 A0 8D E2 0A 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 01 90 45 E2 02 30 A0 E3 03 C0 A0 E1 54 30 0B E5 68 90 0B E5 50 30 1B E5 58 90 1B E5 09 30 83 E0 6C 30 0B E5 04 30 A0 E3 60 30 0B E5 74 40 0B E5 01 90 A0 E3 0C 40 A0 E1 54 C0 1B E5 68 30 1B E5 BC 20 9A E1 60 E0 1B E5 03 00 59 E1 50 30 1B E5 01 20 82 E2 BC 20 8A E1 0E 00 83 E0 0C C0 8A E0 0E 60 93 E7 11 00 00 2A 6C E0 1B E5 68 70 1B E5 04 30 1E E5 F0 21 93 E5 04 80 4E E2 00 00 52 E3 08 E0 A0 E1 04 20 42 12 02 00 00 1A 04 00 00 EA 03 00 56 E1 13 00 00 0A 04 30 B2 E5 00 00 53 E3 FA FF FF 1A 01 70 47 E2 07 00 59 E1 EF FF FF 3A 04 00 55 E1 04 90 A0 E1 25 00 00 0A 84 C0 A0 E1 05 20 64 E0 82 20 A0 E1 0C 00 8A E0 00 10 A0 E3 54 C0 0B E5 ?? ?? ?? ?? 04 31 A0 E1 60 30 0B E5 01 40 84 E2 D3 FF FF EA 60 20 1B E5 50 E0 1B E5 07 30 69 E0 04 10 82 E2 01 10 8E E0 03 21 A0 E1 84 30 0B E5 80 C0 0B E5 ?? ?? ?? ?? 84 20 A0 E1 B2 00 9A E1 05 10 69 E0 01 00 50 E1 84 30 4B E2 00 60 88 E5 02 10 8A E0 08 10 93 E8 04 90 A0 81 E1 FF FF 8A 83 20 A0 E1 54 30 1B E5 B0 60 DC E1 03 00 8A E0 87 70 A0 E1 ?? ?? ?? ?? B7 60 8A E1 B8 FF FF EA 74 40 1B E5 70 D0 1B E5 50 C0 1B E5 58 90 1B E5 00 30 A0 E3 09 30 8C E7 0F CA E0 E3 0F E0 A0 E1 5F F0 4C E2 5C 90 1B E5 96 31 D9 E5 64 90 1B E5 5C C0 1B E5 00 00 59 E3 50 90 1B E5 01 30 83 E3 F0 91 8C E5 96 31 CC E5 64 00 1B 15 ?? ?? ?? ?? 00 00 54 E3 4D 01 00 1A 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 02 30 C3 E3 0E 01 73 E3 49 FE FF 1A 04 90 15 E5 09 90 88 E0 09 00 A0 E1 24 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 E4 00 00 1A 08 30 15 E5 0E 01 73 E3 2C 90 0B E5 CD 00 00 0A 28 47 9F E5 00 30 94 E5 01 00 13 E3 9E 00 00 1A 3C 30 4B E2 00 30 8D E5 40 00 4B E2 44 10 4B E2 45 20 4B E2 F4 36 9F E5 ?? ?? ?? ?? 44 90 1B E5 00 00 59 E3 B4 FE FF 1A 18 D0 4D E2 08 40 8D E2 0C 20 A0 E3 04 00 A0 E1 64 10 1B E5 ?? ?? ?? ?? 28 30 1B E5 64 90 1B E5 00 00 57 E3 00 20 A0 E3 0C 00 89 E8 06 31 87 17 28 30 1B 15 94 21 D3 E5 01 60 86 12 60 00 12 E3 04 20 A0 11 7A 00 00 1A 94 11 D3 E5 10 20 93 E5 40 10 C1 E3 64 C0 1B E5 20 10 81 E3 00 00 52 E3 08 40 8C E5 94 11 C3 E5 0C 10 93 15 0C 10 82 15 0C 10 93 E5 00 00 51 E3 10 20 81 15 04 20 94 E5 10 10 92 E5 10 10 83 E5 10 30 82 E5 54 90 1B E5 10 10 93 E5 01 00 89 E2 00 00 51 E3 0C 30 81 15 54 00 0B E5 0C 20 83 E5 64 C0 1B E5 50 90 1B E5 09 00 5C E1 64 40 0B E5 50 40 0B 05 00 FE FF EA 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 58 00 0B E5 07 FE FF 0A 20 36 9F E5 00 30 93 E5 00 00 53 E3 32 00 00 1A 04 00 A0 E1 ?? ?? ?? ?? 00 90 A0 E1 A8 01 9A E5 00 00 50 E3 21 00 00 0A 01 00 70 E3 28 00 00 0A ?? ?? ?? ?? F0 35 9F E5 00 30 93 E5 03 00 53 E3 03 30 A0 33 00 00 53 E1 03 00 A0 21 04 00 50 E3 58 C0 1B 85 04 00 40 82 9C 90 29 80 0E 20 89 E2 07 20 C2 E3 02 D0 4D E0 00 30 A0 E3 08 20 8D E2 0A 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 30 D0 E5 00 00 53 E3 07 00 00 1A 94 E5 9F E5 00 30 9E E5 01 00 13 E3 D5 FD FF 0A 04 10 A0 E1 8C 05 9F E5 ?? ?? ?? ?? D1 FD FF EA 00 40 A0 E1 DB FD FF EA 04 30 9A E5 00 30 D3 E5 00 00 53 E3 1E 00 00 1A ?? ?? ?? ?? 01 10 40 E2 03 00 71 E3 A8 01 8A E5 D6 FF FF 9A 00 00 A0 E3 D5 FF FF EA 00 00 A0 E3 04 10 A0 E1 00 20 A0 E1 44 35 9F E5 ?? ?? ?? ?? 5C 31 99 E5 00 00 53 E3 73 FE FF 0A 34 05 9F E5 34 15 9F E5 34 25 9F E5 34 35 9F E5 ?? ?? ?? ?? 01 90 A0 E3 02 E0 A0 E1 60 A0 1B E5 54 90 0B E5 83 FD FF EA 60 90 1B E5 04 20 A0 E1 04 10 99 E5 0C 00 A0 E3 0C 35 9F E5 ?? ?? ?? ?? 08 05 9F E5 F4 14 9F E5 F9 20 A0 E3 F4 34 9F E5 ?? ?? ?? ?? 04 00 91 E5 03 00 50 E1 16 00 00 0A 01 20 A0 E1 08 10 92 E5 00 00 51 E3 F8 FF FF 1A 04 10 A0 E1 64 00 1B E5 0C 20 A0 E3 ?? ?? ?? ?? 9B FD FF EA 04 20 9A E5 00 30 D2 E5 00 00 53 E3 05 00 00 1A B8 C4 9F E5 00 30 9C E5 00 20 93 E5 B0 E4 9F E5 00 00 52 E3 0E 20 A0 01 09 10 A0 E1 A4 04 9F E5 ?? ?? ?? ?? 52 FF FF EA 64 90 1B E5 08 40 89 E5 08 C0 92 E5 08 C0 9C E5 08 E0 92 E5 50 90 1B E5 10 10 93 E5 58 C0 0B E5 09 00 5E E1 58 E0 1B E5 02 C0 A0 E1 09 20 A0 11 00 00 51 E3 08 E0 8C E5 0C 00 93 15 0C 00 81 15 0C 00 93 E5 00 00 50 E3 10 10 80 15 04 10 94 E5 10 00 91 E5 10 00 83 E5 10 30 81 E5 10 00 93 E5 00 00 50 E3 0C 30 80 15 50 20 0B E5 0C 10 83 E5 69 FF FF EA F0 03 9F E5 00 30 90 E5 01 00 13 E3 40 00 00 1A 3C 30 4B E2 00 30 8D E5 40 00 4B E2 44 10 4B E2 45 20 4B E2 BC 33 9F E5 ?? ?? ?? ?? 44 00 1B E5 00 00 50 E3 31 FF FF 0A 45 30 5B E5 00 00 53 E3 5F FD FF 0A ?? ?? ?? ?? 5D FD FF EA 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 58 00 0B E5 15 FF FF 0A 94 33 9F E5 00 30 93 E5 00 00 53 E3 48 00 00 1A 09 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 A8 01 9A E5 00 00 50 E3 37 00 00 0A 01 00 70 E3 3E 00 00 0A ?? ?? ?? ?? 64 33 9F E5 00 30 93 E5 03 00 53 E3 03 30 A0 33 00 00 53 E1 03 00 A0 21 04 00 50 E3 58 C0 1B 85 04 00 40 82 9C 40 24 80 0E 30 84 E2 07 30 C3 E3 03 D0 4D E0 08 20 8D E2 00 30 A0 E3 0A 00 A0 E1 09 10 A0 E1 ?? ?? ?? ?? 00 30 D0 E5 00 00 53 E3 1D 00 00 1A 08 20 15 E5 0E 01 72 E3 15 00 00 0A FC E2 9F E5 00 30 9E E5 01 00 13 E3 2F FD FF 0A 09 10 A0 E1 F4 02 9F E5 ?? ?? ?? ?? 2B FD FF EA 04 20 9A E5 00 30 D2 E5 00 00 53 E3 05 00 00 1A F8 12 9F E5 00 30 91 E5 00 20 93 E5 F0 32 9F E5 00 00 52 E3 03 20 A0 01 09 10 A0 E1 E8 02 9F E5 ?? ?? ?? ?? B0 FF FF EA 03 00 A0 E1 03 20 A0 E1 09 10 A0 E1 D4 32 9F E5 ?? ?? ?? ?? 00 90 A0 E1 D3 FE FF EA 04 30 9A E5 00 30 D3 E5 00 00 53 E3 0B 00 00 1A ?? ?? ?? ?? 01 20 40 E2 03 00 72 E3 A8 01 8A E5 C0 FF FF 9A 00 00 A0 E3 BF FF FF EA 00 00 A0 E3 09 10 A0 E1 00 20 A0 E1 60 32 9F E5 ?? ?? ?? ?? 70 02 9F E5 5C 12 9F E5 80 22 9F E5 5C 32 9F E5 ?? ?? ?? ?? 01 00 74 E3 04 00 A0 11 00 00 A0 03 40 10 1B E5 00 20 A0 E3 44 30 1B E5 ?? ?? ?? ?? 5C 30 1B E5 50 00 1B E5 5C 11 93 E5 58 20 1B E5 ?? ?? ?? ?? 90 FE FF EA 06 C0 A0 E1 00 60 A0 E1 16 FE FF EA 05 31 A0 E1 58 30 0B E5 E2 FD FF EA 05 C1 A0 E1 0C 20 A0 E1 50 00 1B E5 58 C0 0B E5 ?? ?? ?? ?? 01 00 55 E3 83 FE FF 9A 22 FE FF EA 0C 02 9F E5 DC 11 9F E5 08 22 9F E5 DC 31 9F E5 ?? ?? ?? ?? 00 32 9F E5 60 90 1B E5 00 80 93 E5 09 00 58 E1 B8 FD FF 1A 00 00 55 E3 B6 FD FF 0A 68 70 1B E5 5C 31 98 E5 07 61 93 E7 06 00 58 E1 05 00 00 0A D0 31 96 E5 00 00 53 E3 0D 00 00 0A 04 30 93 E5 00 00 53 E3 0A 00 00 0A 01 70 87 E2 05 00 57 E1 F2 FF FF 1A A7 FD FF EA 95 01 D3 E5 02 00 10 E3 95 FD FF 0A 60 01 91 E5 01 00 40 E2 60 01 81 E5 95 FD FF EA F0 30 96 E5 00 00 53 E3 3E 00 00 1A E8 A0 96 E5 00 00 5A E3 3B 00 00 1A 50 00 1B E5 06 10 A0 E1 2F FC FF EB 05 00 50 E1 00 90 A0 E1 30 00 00 8A 00 00 50 E3 1E 00 00 0A 50 30 1B E5 04 10 93 E4 94 01 D1 E5 60 00 C0 E3 94 01 C1 E5 0A 20 A0 E1 01 20 82 E2 02 00 59 E1 15 00 00 0A 04 10 93 E4 94 01 D1 E5 00 00 52 E3 60 00 C0 E3 94 01 C1 E5 F6 FF FF 0A 04 10 13 E5 60 10 91 E5 00 00 51 E3 95 11 D6 15 80 10 81 13 95 11 C6 15 EF FF FF EA 60 40 1B E5 00 20 A0 E1 04 10 94 E5 0C 00 A0 E3 F0 30 9F E5 ?? ?? ?? ?? 09 00 A0 E1 ?? ?? ?? ?? 34 FD FF EA 02 20 89 E2 02 A1 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 30 A0 E1 D0 01 86 E5 11 00 00 0A 08 C0 80 E2 08 20 4A E2 0C 00 A0 E1 50 10 1B E5 04 90 83 E5 00 C0 83 E5 ?? ?? ?? ?? B7 FF FF EA A0 00 9F E5 60 10 9F E5 9C 20 9F E5 60 30 9F E5 ?? ?? ?? ?? 04 10 96 E5 16 00 A0 E3 00 20 A0 E3 88 30 9F E5 ?? ?? ?? ?? 00 20 A0 E1 04 10 98 E5 0C 00 A0 E3 68 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 5A 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? F9 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 2D 01 00 00 ?? ?? ?? ?? 4A 02 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 31 02 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_243_0_0 {
	meta:
		name = "dlinfo_doit"
		size = 268
		refs = "0094 _dl_rtld_di_serinfo 00c0 strcpy 00f8 _dl_signal_error 0100 _dl_tls_get_addr_soft"
	strings:
		$1 = { 08 30 90 E5 01 30 43 E2 10 40 2D E9 04 20 90 E5 00 40 A0 E1 09 00 53 E3 03 F1 9F 97 31 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 40 02 92 E5 00 00 50 E3 29 00 00 1A 0C 30 94 E5 10 40 BD E8 00 00 83 E5 ?? ?? ?? ?? 18 20 92 E5 0C 30 90 E5 00 20 83 E5 10 40 BD E8 ?? ?? ?? ?? 0C 30 90 E5 00 20 83 E5 10 40 BD E8 ?? ?? ?? ?? 02 00 A0 E1 0C 10 94 E5 00 20 A0 E3 ?? ?? ?? ?? 10 40 BD E8 ?? ?? ?? ?? 02 00 A0 E1 0C 10 94 E5 01 20 A0 E3 ?? ?? ?? ?? 10 40 BD E8 ?? ?? ?? ?? 0C 00 90 E5 A8 11 92 E5 ?? ?? ?? ?? 10 40 BD E8 ?? ?? ?? ?? 0C 30 90 E5 00 10 A0 E3 00 10 83 E5 40 22 92 E5 00 20 83 E5 10 40 BD E8 ?? ?? ?? ?? 00 00 A0 E3 00 10 A0 E1 00 20 A0 E1 0C 30 9F E5 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? D2 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_243_1_0 {
	meta:
		name = "__dlinfo"
		size = 56
		refs = "001c _dlerror_run 0034 dlinfo_doit"
	strings:
		$1 = { 04 E0 2D E5 14 D0 4D E2 03 00 8D E9 0D 10 A0 E1 1C 00 9F E5 00 30 8D E5 0C 20 8D E5 ?? ?? ?? ?? 00 00 50 E2 00 00 E0 13 14 D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_245_0_0 {
	meta:
		name = "_nl_init_alt_digit"
		size = 196
		refs = "0038 malloc 005c __rawmemchr 00c0 _nl_cleanup_time"
	strings:
		$1 = { 70 40 2D E9 14 60 90 E5 00 00 56 E3 00 50 A0 E1 18 00 00 0A 14 40 96 E5 00 00 54 E3 13 00 00 1A E0 50 95 E5 01 30 A0 E3 00 00 55 E3 14 30 86 E5 0E 00 00 0A 19 0E A0 E3 ?? ?? ?? ?? 00 00 50 E3 0C 00 86 E5 01 00 00 1A 08 00 00 EA 0C 00 96 E5 04 50 80 E7 00 10 A0 E3 05 00 A0 E1 ?? ?? ?? ?? 04 40 84 E2 19 0E 54 E3 01 50 80 E2 F6 FF FF 1A 70 40 BD E8 ?? ?? ?? ?? 1C 00 A0 E3 ?? ?? ?? ?? 00 00 50 E3 14 00 85 E5 F8 FF FF 0A 00 30 A0 E1 04 60 83 E4 04 30 83 E2 04 60 80 E5 04 60 83 E4 04 60 83 E4 04 60 83 E4 10 20 9F E5 04 60 83 E4 10 20 85 E5 00 60 83 E5 00 60 A0 E1 D4 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_245_1_0 {
	meta:
		name = "_nl_get_alt_digit"
		size = 184
		refs = "0030 __pthread_rwlock_wrlock 006c __pthread_rwlock_unlock 00b0 __libc_setlocale_lock"
	strings:
		$1 = { 63 00 50 E3 38 40 2D E9 00 50 A0 E1 01 40 A0 E1 20 00 00 8A E0 30 91 E5 00 00 D3 E5 00 00 50 E3 13 00 00 0A 80 30 9F E5 00 00 53 E3 7C 00 9F 15 ?? ?? ?? ?? 14 30 94 E5 00 00 53 E3 0E 00 00 0A 14 20 93 E5 00 00 52 E3 0B 00 00 0A 0C 30 93 E5 00 00 53 E3 0D 00 00 0A 05 41 93 E7 50 30 9F E5 00 00 53 E3 0E 00 00 0A 40 00 9F E5 ?? ?? ?? ?? 04 00 A0 E1 38 40 BD E8 ?? ?? ?? ?? 04 00 A0 E1 AD FF FF EB 14 30 94 E5 00 00 53 E3 EE FF FF 1A 00 40 A0 E3 F0 FF FF EA 00 00 A0 E3 38 40 BD E8 ?? ?? ?? ?? 04 00 A0 E1 F1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_245_2_0 {
	meta:
		name = "_nl_get_walt_digit"
		size = 324
		refs = "0030 __pthread_rwlock_wrlock 0064 malloc 008c wcschr 00c0 __pthread_rwlock_unlock 0138 __libc_setlocale_lock 0140 _nl_cleanup_time"
	strings:
		$1 = { 63 00 50 E3 F8 40 2D E9 00 70 A0 E1 01 50 A0 E1 35 00 00 8A AC 31 91 E5 00 00 93 E5 00 00 50 E3 28 00 00 0A 08 31 9F E5 00 00 53 E3 04 01 9F 15 ?? ?? ?? ?? 14 60 95 E5 00 00 56 E3 23 00 00 0A 18 40 96 E5 00 00 54 E3 14 00 00 1A AC 51 95 E5 01 30 A0 E3 00 00 55 E3 18 30 86 E5 0F 00 00 0A 19 0E A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 00 86 E5 1B 00 00 0A 00 30 A0 E1 00 00 00 EA 10 30 96 E5 04 50 83 E7 05 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 04 40 84 E2 19 0E 54 E3 04 50 80 E2 F6 FF FF 1A 10 30 96 E5 00 00 53 E3 07 41 93 17 0C 00 00 0A 84 30 9F E5 00 00 53 E3 1B 00 00 0A 74 00 9F E5 ?? ?? ?? ?? 04 00 A0 E1 F8 40 BD E8 ?? ?? ?? ?? 1C 00 A0 E3 ?? ?? ?? ?? 00 00 50 E3 14 00 85 E5 04 00 00 1A 00 40 A0 E3 F0 FF FF EA 00 00 A0 E3 F8 40 BD E8 ?? ?? ?? ?? 00 30 A0 E1 04 60 83 E4 04 30 83 E2 04 60 80 E5 04 60 83 E4 04 60 83 E4 04 60 83 E4 24 20 9F E5 04 60 83 E4 10 20 85 E5 00 60 83 E5 00 60 A0 E1 C4 FF FF EA 04 00 A0 E1 E4 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_245_3_0 {
	meta:
		name = "_nl_parse_alt_digit"
		size = 260
		refs = "002c __pthread_rwlock_wrlock 006c strlen 0088 strncmp 00b0 __pthread_rwlock_unlock 00fc __libc_setlocale_lock"
	strings:
		$1 = { F8 4F 2D E9 AC 31 91 E5 00 30 93 E5 00 00 53 E3 01 40 A0 E1 00 B0 A0 E1 00 A0 90 E5 33 00 00 0A D0 30 9F E5 00 00 53 E3 CC 00 9F 15 ?? ?? ?? ?? 14 30 94 E5 00 00 53 E3 24 00 00 0A 14 20 93 E5 00 00 52 E3 21 00 00 0A 0C 80 93 E5 00 00 58 E3 23 00 00 0A 00 70 A0 E3 04 80 48 E2 07 40 A0 E1 00 90 E0 E3 04 60 B8 E5 06 00 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 07 00 55 E1 0A 10 A0 E1 06 00 A0 E1 05 20 A0 E1 03 00 00 9A ?? ?? ?? ?? 00 00 50 E3 04 90 A0 01 05 70 A0 01 01 40 84 E2 64 00 54 E3 EF FF FF 1A 54 30 9F E5 00 00 53 E3 48 00 9F 15 ?? ?? ?? ?? 01 00 79 E3 00 30 9B 15 07 70 83 10 00 70 8B 15 09 00 A0 E1 F8 4F BD E8 ?? ?? ?? ?? 04 00 A0 E1 19 FF FF EB 14 30 94 E5 00 00 53 E3 D8 FF FF 1A 00 70 A0 E3 00 90 E0 E3 EC FF FF EA 00 90 E0 E3 F2 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_246_0_0 {
	meta:
		name = "__aeabi_atexit"
		size = 28
		refs = "0010 __cxa_atexit"
	strings:
		$1 = { 08 40 2D E9 00 30 A0 E1 01 00 A0 E1 03 10 A0 E1 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_0_2 {
	meta:
		name = "__cargf"
		size = 28
		refs = "0010 __atan2f"
	strings:
		$1 = { 08 40 2D E9 00 30 A0 E1 01 00 A0 E1 03 10 A0 E1 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_0_0 {
	meta:
		name = "is_dst"
		size = 300
	strings:
		$1 = { F0 00 2D E9 00 C0 D1 E5 7B 00 5C E3 01 C0 D1 05 00 50 D2 E5 01 70 A0 03 07 10 81 00 00 70 A0 13 0C 00 55 E1 2A 00 00 1A 00 00 5C E3 2A 00 00 0A 01 50 A0 E1 00 40 A0 E3 01 00 00 EA 00 00 5C E3 26 00 00 0A 01 C0 F5 E5 01 60 F2 E5 06 00 5C E1 01 40 84 E2 F8 FF FF 0A 00 00 57 E3 06 00 00 0A 7D 00 5C E3 01 10 41 02 02 40 84 02 05 00 00 0A 00 00 A0 E3 F0 00 BD E8 ?? ?? ?? ?? 2F 00 5C E3 00 00 5C 13 05 00 00 1A 10 20 9D E5 00 00 52 E3 15 00 00 1A 04 00 A0 E1 F0 00 BD E8 ?? ?? ?? ?? 00 00 53 E3 08 00 00 0A 3A 00 5C E3 07 00 A0 11 EF FF FF 1A F3 FF FF EA 01 00 80 E2 00 00 51 E1 F3 FF FF 0A 00 00 53 E3 12 00 00 1A 03 00 A0 E1 E7 FF FF EA 00 40 A0 E3 DE FF FF EA 0C 40 A0 E1 00 00 57 E3 E1 FF FF 1A E6 FF FF EA 04 20 D1 E7 2F 00 52 E3 00 00 52 13 EE FF FF 0A 00 00 53 E3 F1 FF FF 0A 3A 00 52 E3 D8 FF FF 1A 01 00 80 E2 00 00 51 E1 DE FF FF 0A 02 00 51 E5 3A 00 50 E3 04 00 A0 01 00 00 A0 13 D1 FF FF EA }
	condition:
		$1
}

rule file_248_1_0 {
	meta:
		name = "is_trusted_path_normalize"
		size = 404
		refs = "00cc memcmp"
	strings:
		$1 = { 30 48 2D E9 00 00 51 E3 0C B0 8D E2 01 00 A0 01 38 00 00 0A 00 20 D0 E5 3A 00 52 E3 01 10 41 02 10 10 81 E2 07 10 C1 E3 01 D0 4D E0 01 20 D0 05 0D 40 A0 E1 01 00 80 02 0D 30 A0 E1 03 00 00 EA 00 20 C3 E5 01 00 80 E2 0C 20 A0 E1 01 30 83 E2 00 00 52 E3 0D 00 00 0A 2F 00 52 E3 01 C0 D0 E5 F6 FF FF 1A 2E 00 5C E3 29 00 00 0A 04 00 53 E1 F2 FF FF 9A 01 10 53 E5 2F 00 51 E3 01 00 80 02 0C 20 A0 01 ED FF FF 1A 00 00 52 E3 F1 FF FF 1A 04 00 53 E1 03 20 A0 E1 02 00 00 0A 01 10 53 E5 2F 00 51 E3 02 00 00 0A 2F 10 A0 E3 00 10 C2 E5 01 30 83 E2 03 50 64 E0 04 00 55 E3 10 00 00 9A C4 00 9F E5 04 10 A0 E1 05 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 2A 00 00 0A 08 00 55 E3 08 00 00 9A 04 10 A0 E1 A4 00 9F E5 09 20 A0 E3 ?? ?? ?? ?? 01 00 70 E2 00 00 A0 33 0C D0 4B E2 30 48 BD E8 ?? ?? ?? ?? 00 00 A0 E3 0C D0 4B E2 30 48 BD E8 ?? ?? ?? ?? 02 10 D0 E5 2E 00 51 E3 05 00 00 0A 2F 00 51 E3 00 00 51 13 02 00 80 02 01 20 A0 01 C6 FF FF 0A CC FF FF EA 03 10 D0 E5 2F 00 51 E3 00 00 51 13 C8 FF FF 1A 04 00 53 E1 09 00 00 9A 01 20 53 E5 2F 00 52 E3 01 30 43 E2 03 00 00 1A 04 00 00 EA 01 20 73 E5 2F 00 52 E3 01 00 00 0A 04 00 53 E1 FA FF FF 1A 03 00 80 E2 01 20 A0 E1 B2 FF FF EA 01 00 A0 E3 DA FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_2_0 {
	meta:
		name = "local_strdup"
		size = 60
		refs = "0008 strlen 0014 malloc 0028 memcpy"
		altNames = "__strdup"
	strings:
		$1 = { 38 40 2D E9 00 50 A0 E1 ?? ?? ?? ?? 01 40 80 E2 04 00 A0 E1 ?? ?? ?? ?? 00 30 50 E2 04 00 00 0A 05 10 A0 E1 04 20 A0 E1 ?? ?? ?? ?? 38 40 BD E8 ?? ?? ?? ?? 03 00 A0 E1 FB FF FF EA }
	condition:
		$1
}

rule file_248_3_0 {
	meta:
		name = "fillin_rpath"
		size = 776
		refs = "0030 __strsep_g 003c strlen 00e8 memcmp 0190 malloc 01b8 mempcpy 0238 memcpy 02e8 _dl_signal_error 02ec _dl_all_dirs"
	strings:
		$1 = { F0 4F 2D E9 24 D0 4D E2 20 B0 8D E2 0C 10 8D E5 08 20 8D E5 10 30 8D E5 04 00 2B E5 4C 80 9D E5 C4 92 9F E5 00 60 A0 E3 0B 00 A0 E1 08 10 9D E5 ?? ?? ?? ?? 00 50 50 E2 99 00 00 0A ?? ?? ?? ?? 00 40 50 E2 15 00 00 0A 01 00 54 E3 0B 00 00 9A 01 30 44 E2 03 20 D5 E7 2F 00 52 E3 05 00 00 0A 7C 00 00 EA 01 20 43 E2 02 10 D5 E7 2F 00 51 E3 79 00 00 1A 02 30 A0 E1 01 00 53 E3 F8 FF FF 1A 00 30 D5 E5 2F 00 53 E3 8E 00 00 1A 10 30 9D E5 00 00 53 E3 E3 FF FF 1A 01 40 A0 E3 03 00 00 EA 10 30 9D E5 00 00 53 E3 DE FF FF 1A 3C 52 9F E5 00 70 99 E5 00 00 57 E3 22 00 00 0A 07 A0 A0 E1 02 00 00 EA 00 A0 9A E5 00 00 5A E3 1D 00 00 0A 10 30 9A E5 04 00 53 E1 F9 FF FF 1A 05 00 A0 E1 0C 10 9A E5 04 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F3 FF FF 1A 00 00 56 E3 6F 00 00 0A 0C 10 9D E5 00 30 91 E5 0A 00 53 E1 C6 FF FF 0A 00 30 A0 E1 01 20 A0 E1 01 30 83 E2 06 00 53 E1 04 00 00 0A 04 10 B2 E5 0A 00 51 E1 F9 FF FF 1A 03 00 56 E1 BC FF FF 1A 03 21 A0 E1 01 60 83 E2 0C 30 9D E5 02 A0 83 E7 B7 FF FF EA 00 00 58 E3 14 80 8D 05 03 00 00 0A 08 00 A0 E1 ?? ?? ?? ?? 01 00 80 E2 14 00 8D E5 88 11 9F E5 00 30 91 E5 05 20 83 E2 02 21 A0 E1 01 10 82 E2 18 10 8D E5 04 00 81 E0 14 10 9D E5 01 00 80 E0 04 20 8D E5 00 30 8D E5 ?? ?? ?? ?? 00 A0 50 E2 04 20 9D E5 00 30 9D E5 4C 00 00 0A 02 00 8A E0 0C 00 8A E5 05 10 A0 E1 04 20 A0 E1 00 30 8D E5 ?? ?? ?? ?? 34 21 9F E5 00 10 92 E5 00 20 A0 E3 00 20 C0 E5 10 40 8A E5 04 00 51 E1 1C 11 9F 35 00 00 D5 E5 00 30 9D E5 00 40 81 35 2F 00 50 E3 02 00 A0 13 00 00 A0 03 00 00 53 E3 0A 10 A0 11 00 20 A0 13 04 00 00 0A 01 20 82 E2 03 00 52 E1 14 00 81 E5 04 10 81 E2 FA FF FF 1A 48 30 9D E5 00 00 58 E3 04 30 8A E5 2A 00 00 0A 18 30 9D E5 04 00 83 E0 00 00 8A E0 14 20 9D E5 08 10 A0 E1 ?? ?? ?? ?? 08 00 8A E5 0C 10 9D E5 00 70 8A E5 00 A0 89 E5 06 A1 81 E7 01 60 86 E2 73 FF FF EA 04 30 A0 E1 10 10 9D E5 2F 20 A0 E3 00 00 51 E3 03 20 C5 E7 01 40 83 E2 8E FF FF 0A 05 00 54 E3 7C 00 9F 05 02 00 00 0A 09 00 54 E3 67 FF FF 1A 70 00 9F E5 05 10 A0 E1 04 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 61 FF FF 1A 82 FF FF EA 0C 20 9D E5 02 00 A0 E1 06 51 82 E7 24 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 06 20 A0 E1 01 60 A0 E3 9C FF FF EA 01 30 A0 E3 E2 FF FF EA 08 80 8A E5 D9 FF FF EA 0A 10 A0 E1 0A 20 A0 E1 0C 00 A0 E3 18 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_4_0 {
	meta:
		name = "add_name_to_object.isra.2"
		size = 216
		refs = "002c strcmp 0044 strlen 0054 malloc 006c memcpy 00ac __assert_fail 00c0 _dl_signal_error"
	strings:
		$1 = { F0 41 2D E9 00 40 50 E2 01 60 A0 E1 04 00 00 1A 1B 00 00 EA 04 50 94 E5 00 00 55 E3 07 00 00 0A 05 40 A0 E1 06 00 A0 E1 00 10 94 E5 ?? ?? ?? ?? 00 00 50 E3 F6 FF FF 1A F0 41 BD E8 ?? ?? ?? ?? 06 00 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 0D 00 80 E2 01 80 82 E2 ?? ?? ?? ?? 00 70 50 E2 13 00 00 0A 06 10 A0 E1 08 20 A0 E1 0C 00 87 E2 ?? ?? ?? ?? 08 50 87 E5 21 00 87 E8 04 70 84 E5 F0 41 BD E8 ?? ?? ?? ?? 01 00 A0 E1 ?? ?? ?? ?? 0D 00 80 E2 ?? ?? ?? ?? 00 00 50 E3 04 00 00 0A 20 00 9F E5 20 10 9F E5 20 20 9F E5 20 30 9F E5 ?? ?? ?? ?? 06 10 A0 E1 0C 00 A0 E3 00 20 A0 E3 10 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? D5 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_5_0 {
	meta:
		name = "lose.isra.3"
		size = 112
		refs = "0024 __close 0038 free 0058 _dl_debug_state 006c _dl_signal_error"
	strings:
		$1 = { 80 40 2D E9 01 00 71 E3 08 40 8D E2 00 80 A0 E1 02 70 A0 E1 03 90 A0 E1 50 00 94 E8 10 50 9D E5 01 00 A0 11 ?? ?? ?? ?? 00 00 54 E3 02 00 00 0A A8 01 94 E5 01 00 70 E3 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 09 00 A0 E1 ?? ?? ?? ?? 00 00 55 E3 00 30 A0 13 0C 30 85 15 ?? ?? ?? ?? 08 00 A0 E1 07 10 A0 E1 06 30 A0 E1 00 20 A0 E3 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_6_0 {
	meta:
		name = "_dl_map_object_from_fd"
		size = 3692
		refs = "0024 _dl_debug_initialize 0038 __fxstat64 00b8 __close 00c0 free 013c _dl_new_object 0370 _dl_next_tls_modid 0400 __mmap 04d0 memset 07a0 _dl_setup_hash 07f8 _dl_add_to_namespace_list 08a0 __mprotect 08b4 _dl_debug_state 08e0 __lseek 08f0 __libc_read 09a8 memmove 0a80 malloc 0a94 memcpy 0ad8 __aeabi_read_tp 0b00 __munmap 0b44 __assert_fail 0b94 _dl_debug_printf 0bb4 _dl_tls_setup 0bc0 _dl_allocate_tls 0be4 _dl_deallocate_tls 0da4 _dl_ns 0da8 _dl_debug_mask 0db8 _dl_pagesize 0dc0 _dl_use_load_bias 0dd0 _dl_stack_flags 0dd4 _dl_initfirst 0dd8 _dl_profile 0dfc __libc_errno 0e20 _dl_tls_dtv_slotinfo_list 0e30 _dl_tls_max_dtv_idx 0e64 _dl_make_stack_executable_hook"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 D4 D0 4D E2 A8 00 0B E5 A0 10 0B E5 00 00 A0 E3 14 10 9B E5 9C 20 0B E5 AC 30 0B E5 ?? ?? ?? ?? A0 10 1B E5 A4 00 0B E5 8C 20 4B E2 03 00 A0 E3 ?? ?? ?? ?? 00 00 50 E3 FC 02 00 BA 14 C0 9B E5 54 3D 9F E5 8C 21 8C E0 82 20 8C E0 02 81 93 E7 00 00 58 E3 1F 00 00 0A 2C 50 4B E2 30 00 95 E8 8C 70 4B E2 C0 00 97 E8 02 00 00 EA 0C 80 98 E5 00 00 58 E3 17 00 00 0A 95 31 D8 E5 20 00 13 E3 F9 FF FF 1A 1E 3E 88 E2 0C 00 93 E8 05 00 53 E1 04 00 52 01 F4 FF FF 1A 76 3F 88 E2 0C 00 93 E8 07 00 53 E1 06 00 52 01 EF FF FF 1A A0 00 1B E5 ?? ?? ?? ?? AC 00 1B E5 ?? ?? ?? ?? 1C 00 98 E5 A8 10 1B E5 79 FF FF EB 08 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 0C C0 9B E5 04 00 1C E3 4A 02 00 1A B4 EC 9F E5 00 30 9E E5 40 00 13 E3 DC 02 00 1A A4 00 1B E5 0C 30 90 E5 00 00 53 E3 E7 01 00 0A 01 00 53 E3 00 10 A0 03 BC 10 0B 05 DB 02 00 1A 0C C0 9B E5 00 C0 8D E5 14 C0 9B E5 04 C0 8D E5 AC 00 4B E2 03 00 90 E8 08 20 9B E5 04 30 9B E5 ?? ?? ?? ?? 00 50 50 E2 D5 02 00 0A 9C C0 1B E5 B0 33 DC E1 20 10 9C E5 00 00 9C E5 9C E0 1B E5 83 42 A0 E1 01 C0 84 E0 1C 20 9E E5 00 00 5C E1 B4 C1 DE E1 56 6F A0 E3 54 21 85 E5 B4 C0 0B E5 B6 30 85 E1 CE 01 00 8A 01 10 8E E0 04 90 81 E2 83 30 83 E0 83 31 A0 E1 08 30 83 E2 B8 D0 0B E5 03 D0 4D E0 2B 30 8D E2 23 31 A0 E1 04 40 89 E0 03 C1 A0 E1 04 00 59 E1 B0 30 0B E5 90 C0 0B E5 3A 02 00 2A 00 C0 A0 E3 07 E0 A0 E3 94 C0 0B E5 D8 8B 9F E5 20 40 89 E2 98 E0 0B E5 0C A0 A0 E1 0C 00 00 EA 08 00 53 E1 69 00 00 0A C0 0B 9F E5 00 00 53 E1 61 00 00 0A 07 00 53 E3 48 00 00 0A 56 3F A0 E3 B3 30 95 E1 83 32 89 E0 03 00 56 E1 20 40 84 E2 61 00 00 2A 20 30 14 E5 06 00 53 E3 04 60 A0 E1 0B 00 00 0A ED FF FF 8A 01 00 53 E3 0B 00 00 0A 02 00 53 E3 F0 FF FF 1A 0C 20 14 E5 18 10 14 E5 6C 3B 9F E5 A2 21 A0 E1 08 10 85 E5 B3 20 85 E1 E9 FF FF EA 18 30 14 E5 50 31 85 E5 E6 FF FF EA 50 1B 9F E5 00 20 91 E5 04 C0 14 E5 01 00 42 E2 00 00 1C E0 10 02 00 1A 18 30 14 E5 1C E0 14 E5 01 C0 4C E2 03 10 6E E0 01 00 1C E1 0D 02 00 1A 01 70 42 E2 00 20 62 E2 02 E0 0E E0 10 10 14 E5 C8 E0 0B E5 0C E0 14 E5 01 10 83 E0 02 C0 03 E0 03 30 8E E0 90 E0 1B E5 8A 00 8A E0 01 70 87 E0 80 C1 8E E7 02 20 07 E0 01 A0 8A E2 80 71 8E E0 C8 00 1B E5 01 00 5A E3 08 10 87 E5 10 00 87 E5 0C 30 87 E5 04 20 87 E5 04 00 00 9A 14 30 17 E5 94 10 1B E5 03 00 5C E1 01 10 A0 13 94 10 0B E5 08 30 14 E5 B0 2A 9F E5 07 30 03 E2 03 31 A0 E1 52 33 A0 E1 0F 30 03 E2 14 30 87 E5 B6 FF FF EA 0C 30 14 E5 00 00 53 E3 B3 FF FF 0A 04 20 14 E5 00 00 52 E3 30 32 85 E5 18 30 14 15 34 22 85 E5 94 11 D5 E5 01 20 42 12 03 20 02 10 18 30 14 05 38 22 85 05 38 22 85 15 03 10 01 E2 10 20 14 E5 01 00 51 E3 2C 22 85 E5 28 32 85 E5 0C 02 00 1A ?? ?? ?? ?? 40 02 85 E5 9F FF FF EA 18 20 14 E5 0C 30 14 E5 48 22 85 E5 4C 32 85 E5 9A FF FF EA 08 C0 14 E5 98 C0 0B E5 97 FF FF EA 00 00 5A E3 0A C0 A0 E1 C0 01 00 0A 01 40 4A E2 90 E0 1B E5 84 40 84 E0 84 41 A0 E1 04 30 8E E0 B4 00 1B E5 0C A0 93 E5 00 30 9E E5 03 00 50 E3 0A A0 63 E0 07 02 00 1A E4 19 9F E5 00 00 91 E5 A0 10 1B E5 14 20 9E E5 00 10 8D E5 10 10 9E E5 00 00 03 E0 04 10 8D E5 C8 39 9F E5 C4 C0 0B E5 0A 10 A0 E1 ?? ?? ?? ?? 01 00 70 E3 AC 01 85 E5 C4 C0 1B E5 4E 00 00 0A 90 20 1B E5 94 70 1B E5 00 30 92 E5 00 00 57 E3 00 30 63 E0 0A 00 80 E0 00 30 85 E5 B0 01 85 E5 12 01 00 1A 95 31 D5 E5 40 30 83 E3 95 31 C5 E5 90 40 1B E5 14 20 94 E5 04 00 12 E3 00 30 95 15 04 10 94 15 03 30 81 10 B4 31 85 15 50 31 95 E5 00 00 53 E3 58 01 00 0A 0C 30 94 E5 08 60 94 E5 06 00 53 E1 1C 00 00 9A 34 89 9F E5 00 70 95 E5 00 10 98 E5 06 60 87 E0 01 E0 41 E2 06 E0 8E E0 00 00 61 E2 03 30 87 E0 00 E0 0E E0 03 00 5E E1 0E 70 A0 31 03 70 A0 21 06 00 57 E1 0C 00 00 9A 02 00 12 E3 FA 01 00 0A 07 20 66 E0 06 00 A0 E1 00 10 A0 E3 C0 30 0B E5 C4 C0 0B E5 ?? ?? ?? ?? 14 20 94 E5 02 00 12 E3 C0 30 1B E5 C4 C0 1B E5 18 02 00 0A 03 00 57 E1 0C 01 00 3A 18 40 84 E2 90 E0 1B E5 8C 30 8C E0 83 31 8E E0 03 00 54 E1 13 00 00 2A 04 10 94 E5 00 30 94 E5 03 00 51 E1 CB FF FF 9A A0 E0 1B E5 00 00 95 E5 14 20 94 E5 00 E0 8D E5 10 E0 94 E5 01 10 63 E0 00 00 83 E0 04 E0 8D E5 88 38 9F E5 C4 C0 0B E5 ?? ?? ?? ?? 01 00 70 E3 C4 C0 1B E5 BD FF FF 1A 74 38 9F E5 00 01 00 EA 08 30 95 E5 00 00 53 E3 B8 D0 1B E5 31 01 00 0A 00 C0 95 E5 0C 20 83 E0 00 00 52 E3 08 20 85 E5 24 01 00 0A 0C 30 93 E7 00 00 53 E3 20 00 85 E2 A5 00 00 1A 00 00 5C E3 2C 00 00 0A 30 30 95 E5 00 00 53 E3 04 20 93 15 0C 20 82 10 04 20 83 15 2C 30 95 E5 00 00 53 E3 04 20 93 15 0C 20 82 10 04 20 83 15 34 30 95 E5 00 00 53 E3 04 20 93 15 0C 20 82 10 04 20 83 15 38 30 95 E5 00 00 53 E3 04 20 93 15 0C 20 82 10 04 20 83 15 3C 30 95 E5 00 00 53 E3 04 20 93 15 0C 20 82 10 04 20 83 15 64 30 95 E5 00 00 53 E3 04 20 93 15 0C 20 82 10 04 20 83 15 7C 30 95 E5 00 00 53 E3 04 20 93 15 0C 20 82 10 04 20 83 15 E4 30 95 E5 00 00 53 E3 04 20 93 15 0C 20 82 10 04 20 83 15 4C 31 95 E5 00 00 53 E3 04 20 93 15 0C C0 82 10 04 C0 83 15 70 30 95 E5 00 00 53 E3 03 00 00 0A 04 30 93 E5 07 00 53 E3 11 00 53 13 33 01 00 1A 3C 30 95 E5 00 00 53 E3 03 00 00 0A 44 30 95 E5 04 30 93 E5 0C 00 53 E3 36 01 00 1A 64 30 95 E5 00 00 53 E3 03 00 00 0A 6C 30 95 E5 04 30 93 E5 08 00 53 E3 34 01 00 1A 98 20 95 E5 00 00 52 E3 07 00 00 0A 04 30 92 E5 02 00 13 E3 60 20 85 15 04 00 13 E3 78 20 85 15 08 00 13 E3 08 32 85 E5 80 20 85 15 B8 30 95 E5 00 00 53 E3 04 32 95 05 09 00 00 0A C8 E6 9F E5 00 10 9E E5 04 20 93 E5 40 00 11 E3 04 22 85 E5 24 01 00 1A 02 30 A0 E1 01 00 12 E3 B8 20 95 15 80 20 85 15 94 20 95 E5 00 00 52 E3 00 20 A0 13 5C 20 85 15 40 00 13 E3 F3 00 00 1A 50 31 95 E5 00 00 53 E3 D2 00 00 0A 00 20 95 E5 02 30 83 E0 50 31 85 E5 98 36 9F E5 98 C0 1B E5 00 30 93 E5 03 30 CC E1 01 00 13 E3 89 01 00 1A 28 32 95 E5 00 00 53 E3 00 20 95 15 02 30 83 10 28 32 85 15 A0 00 1B E5 ?? ?? ?? ?? 00 00 50 E3 D8 00 00 1A 94 31 D5 E5 03 20 03 E2 01 00 52 E3 8F 00 00 0A 24 E6 9F E5 54 31 95 E5 00 20 9E E5 00 00 95 E5 40 00 12 E3 03 30 80 E0 54 31 85 E5 4F 01 00 1A 05 00 A0 E1 ?? ?? ?? ?? 0C C0 9B E5 08 00 1C E3 6C 00 00 0A 04 32 95 E5 20 00 13 E3 14 36 9F 15 00 50 83 15 10 36 9F E5 00 C0 93 E5 2C 10 4B E2 03 00 91 E8 8C 30 4B E2 0C 00 93 E8 00 00 5C E3 D8 21 85 E5 DC 31 85 E5 E0 01 85 E5 E4 11 85 E5 4C 01 00 1A 05 00 A0 E1 14 10 9B E5 ?? ?? ?? ?? 05 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 07 32 63 E2 21 30 83 E2 03 21 80 E7 08 30 B2 E5 00 00 53 E3 59 FF FF 0A 21 00 53 E3 F9 FF FF 9A 09 12 E0 E3 01 10 63 E0 0F 00 51 E3 F3 FF FF 9A 83 10 A0 E1 C1 10 A0 E1 04 00 71 E3 05 00 00 9A 01 31 A0 E1 03 30 23 E2 03 30 E0 E1 03 30 80 E0 C8 20 83 E5 EC FF FF EA 70 15 9F E5 01 10 63 E0 0B 00 51 E3 24 00 00 8A 03 31 40 E0 03 31 83 E2 30 27 03 E5 E4 FF FF EA B0 E0 1B E5 04 00 92 E5 0E 11 94 E7 00 20 A0 E3 01 10 60 E0 00 00 83 E0 C4 C0 0B E5 ?? ?? ?? ?? C4 C0 1B E5 E2 FE FF EA 01 40 A0 E3 0C 40 80 E5 ?? ?? ?? ?? BC 40 0B E5 16 FE FF EA 0E 30 84 E2 A3 31 A0 E1 0D E0 A0 E1 83 E1 4E E0 0E D0 A0 E1 00 20 A0 E3 28 90 8D E2 A0 00 1B E5 ?? ?? ?? ?? A0 00 1B E5 09 10 A0 E1 04 20 A0 E1 ?? ?? ?? ?? 04 00 50 E1 F5 00 00 1A B6 30 95 E1 83 42 A0 E1 20 FE FF EA D0 14 9F E5 01 10 63 E0 0A 00 51 E3 03 31 40 90 03 31 83 92 00 23 03 95 BC FF FF EA 00 E0 E0 E3 00 60 A0 E3 14 20 94 E5 03 10 67 E0 00 E0 8D E5 04 60 8D E5 07 00 A0 E1 C4 C0 0B E5 32 30 A0 E3 ?? ?? ?? ?? 01 00 70 E3 C4 C0 1B E5 E5 FE FF 1A 84 34 9F E5 B8 D0 1B E5 5B 00 00 EA 60 30 95 E5 00 00 53 E3 8F FF FF 0A CC 31 95 E5 00 20 93 E5 57 3F 85 E2 03 00 52 E1 8A FF FF 0A 64 31 95 E5 00 50 83 E5 C8 21 95 E5 CC 11 95 E5 01 30 A0 E3 07 21 42 E2 02 21 A0 E1 68 31 85 E5 04 00 81 E2 ?? ?? ?? ?? CC 31 95 E5 59 2F 85 E2 00 20 83 E5 7C FF FF EA B4 C0 1B E5 02 00 5C E3 03 30 C3 03 94 31 C5 05 6A FF FF EA 9C 00 1B E5 10 30 94 E5 20 10 90 E5 01 00 53 E1 A1 FE FF 8A 9C 70 1B E5 41 00 94 E8 B0 E3 D7 E1 06 60 83 E0 8E E2 81 E0 06 60 60 E0 0E 00 56 E1 01 10 80 20 01 30 63 20 50 31 85 25 96 FE FF EA 04 32 95 E5 3D FF FF EA AC 00 1B E5 ?? ?? ?? ?? A0 00 1B E5 ?? ?? ?? ?? 00 00 A0 E3 73 FF FF EA B4 C0 1B E5 03 00 5C E3 F4 FF FF 1A 03 00 A0 E1 A0 33 9F E5 BC 10 1B E5 A4 20 1B E5 00 00 51 E3 00 20 A0 03 08 20 8D E5 00 50 8D E5 04 30 8D E5 A0 10 1B E5 A8 20 1B E5 AC 30 1B E5 47 FD FF EB 9C C0 1B E5 B0 43 DC E1 84 42 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 27 00 00 0A 09 10 A0 E1 04 20 A0 E1 ?? ?? ?? ?? 94 31 D5 E5 80 30 83 E3 50 01 85 E5 94 31 C5 E5 20 FF FF EA 38 33 9F E5 00 00 A0 E3 B8 D0 1B E5 E1 FF FF EA 00 00 A0 E3 28 33 9F E5 FA FF FF EA 24 33 9F E5 F8 FF FF EA 20 33 9F E5 20 23 9F E5 ?? ?? ?? ?? 02 20 9F E7 02 00 90 E7 D6 FF FF EA 0C C0 9B E5 00 00 5C E3 08 FF FF AA 6B 0F 85 E2 03 00 90 E8 01 10 60 E0 ?? ?? ?? ?? 1C 00 95 E5 08 30 90 E5 00 00 53 E3 ?? ?? ?? ?? 94 31 D5 E5 A3 33 B0 E1 09 00 00 1A 03 00 A0 E1 D4 32 9F E5 C5 FF FF EA D0 32 9F E5 E7 FF FF EA CC 02 9F E5 CC 12 9F E5 73 20 A0 E3 C8 32 9F E5 ?? ?? ?? ?? 50 01 95 E5 ?? ?? ?? ?? 00 00 A0 E3 A4 32 9F E5 B9 FF FF EA B0 02 9F E5 A4 12 9F E5 78 20 A0 E3 A0 32 9F E5 ?? ?? ?? ?? A0 02 9F E5 90 12 9F E5 7C 20 A0 E3 8C 32 9F E5 ?? ?? ?? ?? 8E 3E C2 E3 09 10 D3 E3 D7 FE FF 0A 84 02 9F E5 ?? ?? ?? ?? 04 32 95 E5 03 20 A0 E1 D3 FE FF EA 74 72 9F E5 00 30 97 E5 00 00 53 E3 EE FD FF 1A ?? ?? ?? ?? 00 00 50 E3 28 00 00 1A ?? ?? ?? ?? 00 30 50 E2 25 00 00 0A 50 72 9F E5 00 00 00 EF 01 0A 70 E3 1B 00 00 9A 03 00 A0 E1 01 10 A0 E3 ?? ?? ?? ?? 00 00 A0 E3 34 32 9F E5 AF FF FF EA 0C 10 9B E5 02 02 11 E2 20 00 00 0A 94 70 1B E5 95 21 D5 E5 00 00 95 E5 01 10 27 E2 40 20 C2 E3 01 10 01 E2 00 30 83 E0 01 13 82 E1 95 11 C5 E5 0A 20 83 E0 AC 31 85 E5 B0 21 85 E5 90 40 1B E5 2E FE FF EA 00 00 A0 E3 BC 00 0B E5 00 50 A0 E1 E0 31 9F E5 A1 FF FF EA DC E1 9F E5 00 30 9E E5 01 30 83 E2 00 30 8E E5 40 32 85 E5 65 FD FF EA 0C 00 A0 E3 C4 31 9F E5 90 FF FF EA C0 01 9F E5 A8 10 1B E5 14 20 9B E5 ?? ?? ?? ?? 1D FD FF EA B0 31 9F E5 89 FF FF EA AC 01 9F E5 AC 11 9F E5 AC 21 9F E5 AC 31 9F E5 ?? ?? ?? ?? A8 31 9F E5 8A FF FF EA 06 00 00 E0 02 20 82 E3 C0 30 0B E5 C4 C0 0B E5 ?? ?? ?? ?? 00 00 50 E3 C0 30 1B E5 C4 C0 1B E5 FB FD FF AA 80 31 9F E5 21 FF FF EA 7C 31 9F E5 7D FF FF EA 08 10 A0 E3 08 20 95 E5 00 00 8D E5 04 10 8D E5 0C 10 8D E5 14 10 8D E5 08 A0 8D E5 10 30 8D E5 50 31 95 E5 1C 10 8D E5 18 30 8D E5 56 3F A0 E3 B3 30 95 E1 44 01 9F E5 20 30 8D E5 01 30 A0 E1 ?? ?? ?? ?? 9D FE FF EA 58 30 95 E5 00 00 53 E3 AF FE FF 0A 34 20 95 E5 04 30 93 E5 04 10 92 E5 1C 00 95 E5 03 10 81 E0 5B FC FF EB A8 FE FF EA 00 10 98 E5 00 00 61 E2 06 00 00 E0 C0 30 0B E5 C4 C0 0B E5 ?? ?? ?? ?? C4 C0 1B E5 C0 30 1B E5 DD FD FF EA E8 30 9F E5 04 20 93 E5 07 20 82 E3 04 20 83 E5 10 00 9B E5 D8 30 9F E5 00 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 6A FE FF 0A C4 30 9F E5 27 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? 51 E5 74 64 52 E5 74 64 5A 01 00 00 ?? ?? ?? ?? 40 62 51 73 ?? ?? ?? ?? 02 08 00 00 12 08 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF FD FF 6F FF FE FF 6F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 05 00 0F 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 1A 04 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_7_0 {
	meta:
		name = "open_verify.isra.4"
		size = 1344
		refs = "0020 __open 003c __aeabi_read_tp 0058 __libc_read 0090 memcmp 0278 __close 02c4 __lseek 0468 strlen 0484 memcpy 0490 free 04dc __libc_errno 04f4 _dl_osversion"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 24 D0 4D E2 01 60 A0 E1 02 17 A0 E3 02 50 A0 E1 2C 30 0B E5 28 00 0B E5 ?? ?? ?? ?? 01 00 70 E3 00 80 A0 E1 7E 00 00 0A A4 34 9F E5 00 20 A0 E3 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 20 86 E5 02 10 86 E0 04 10 81 E2 02 2C 62 E2 08 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 40 96 E5 03 00 00 DA 04 40 80 E0 33 00 54 E3 00 40 86 E5 D3 00 00 9A 33 00 54 E3 B1 00 00 DA 04 70 86 E2 07 00 A0 E1 50 14 9F E5 08 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 BD 00 00 1A 28 10 96 E5 3C 34 9F E5 3C 24 9F E5 03 30 01 E0 02 00 53 E1 66 00 00 0A 0C 30 D6 E5 00 00 53 E3 5E 00 00 1A 07 20 A0 E3 0D 00 86 E2 1C 14 9F E5 ?? ?? ?? ?? 00 20 50 E2 5D 00 00 1A 18 30 96 E5 01 00 53 E3 BA 00 00 1A B6 31 D6 E1 28 00 53 E3 60 00 00 1A B4 31 D6 E1 02 30 43 E2 03 38 A0 E1 01 08 53 E3 B5 00 00 8A BE 32 D6 E1 20 00 53 E3 D1 00 00 1A B0 53 D6 E1 20 10 96 E5 85 32 A0 E1 01 C0 83 E0 04 00 5C E1 73 00 00 8A 01 10 86 E0 04 70 81 E2 03 30 87 E0 03 00 57 E1 3B 00 00 2A 20 40 87 E2 03 00 00 EA 85 32 87 E0 03 00 5A E1 20 40 84 E2 35 00 00 2A 20 30 14 E5 04 00 53 E3 04 A0 A0 E1 F7 FF FF 1A 10 90 14 E5 1F 00 59 E3 F4 FF FF 9A 04 20 14 E5 03 00 52 E3 F1 FF FF 9A 1C 10 14 E5 00 20 96 E5 09 00 81 E0 02 00 50 E1 46 00 00 8A 01 10 86 E0 04 50 81 E2 0B 00 00 EA 06 00 95 E8 03 10 81 E2 03 20 82 E2 03 10 C1 E3 03 20 C2 E3 02 20 81 E0 0C 20 82 E2 20 10 49 E2 01 00 52 E1 37 00 00 8A 09 90 62 E0 02 50 85 E0 05 00 A0 E1 18 13 9F E5 10 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 ED FF FF 1A 00 00 59 E3 2D 00 00 0A 10 30 95 E5 14 00 85 E2 00 00 53 E3 07 00 90 E8 1C 00 00 1A EC 32 9F E5 00 30 93 E5 00 00 53 E3 06 00 00 0A FF 00 00 E2 FF 10 01 E2 00 14 81 E0 FF 20 02 E2 01 24 82 E0 03 00 52 E1 11 00 00 8A 08 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 0B 20 D6 E5 03 00 52 E3 01 00 00 1A 01 00 53 E3 9B FF FF 9A A0 32 9F E5 04 20 96 E5 03 00 52 E1 61 00 00 1A 08 30 D6 E5 01 00 53 E3 61 00 00 0A 01 30 A0 E3 00 30 C5 E5 08 00 A0 E1 ?? ?? ?? ?? 78 32 9F E5 ?? ?? ?? ?? 03 30 9F E7 02 20 A0 E3 00 80 E0 E3 03 20 80 E7 08 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? B0 53 D6 E1 A5 FF FF EA 0E 20 89 E2 07 20 C2 E3 02 D0 4D E0 10 50 8D E2 00 20 A0 E3 08 00 A0 E1 ?? ?? ?? ?? 08 00 A0 E1 05 10 A0 E1 09 20 A0 E1 ?? ?? ?? ?? 00 00 59 E1 BA FF FF 0A 18 32 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 40 90 E7 0C 52 9F E5 1B 00 00 EA 0E 00 83 E2 A0 01 A0 E1 0D C0 A0 E1 80 C1 4C E0 0C D0 A0 E1 08 00 A0 E1 30 30 0B E5 ?? ?? ?? ?? 30 30 1B E5 10 70 8D E2 03 20 A0 E1 08 00 A0 E1 07 10 A0 E1 ?? ?? ?? ?? 30 30 1B E5 00 00 53 E1 B0 53 D6 01 85 32 A0 01 7A FF FF 0A E5 FF FF EA B8 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 40 90 E7 AC 31 9F E5 00 00 54 E3 9C 51 9F E5 03 50 A0 01 2C 30 1B E5 00 00 53 E3 3B 00 00 1A 00 30 A0 E3 04 50 8D E5 28 20 1B E5 04 00 A0 E1 08 10 A0 E1 00 30 8D E5 08 30 8D E5 63 FB FF EB 07 00 A0 E1 70 11 9F E5 08 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 3B FF FF 0A 07 00 A0 E1 5C 11 9F E5 08 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 35 FF FF 0A A1 FF FF EA 04 20 A0 E1 1D FF FF EA 02 40 A0 E1 3C 51 9F E5 E2 FF FF EA 02 40 A0 E1 34 51 9F E5 DF FF FF EA 00 40 A0 E3 2C 51 9F E5 DC FF FF EA 09 30 D6 E5 01 00 53 E3 00 40 A0 13 1C 51 9F 15 D7 FF FF 1A 0A 30 D6 E5 01 00 53 E3 00 40 A0 13 0C 51 9F 15 D2 FF FF 1A 0B 20 D6 E5 BF 40 12 E2 26 00 00 0A 03 00 52 E3 00 40 A0 13 F4 50 9F 15 CB FF FF 1A 0C 30 D6 E5 00 00 53 E3 15 00 00 0A 01 00 53 E3 00 40 A0 83 12 00 00 9A D8 50 9F E5 C3 FF FF EA D4 50 9F E5 02 40 A0 E1 C0 FF FF EA 28 00 1B E5 ?? ?? ?? ?? 0F 30 80 E2 07 30 C3 E3 03 D0 4D E0 01 20 80 E2 28 10 1B E5 10 00 8D E2 ?? ?? ?? ?? 00 60 A0 E1 28 00 1B E5 ?? ?? ?? ?? 28 60 0B E5 B5 FF FF EA 0D 00 86 E2 44 10 9F E5 07 20 A0 E3 ?? ?? ?? ?? 00 40 A0 E3 80 30 9F E5 04 00 50 E1 7C 50 9F E5 03 50 A0 11 A8 FF FF EA 0C 30 D6 E5 00 00 53 E3 F2 FF FF 0A 03 00 52 E3 DD FF FF 1A D9 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? 00 04 00 FF 00 04 00 05 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 7F 45 4C 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_8_0 {
	meta:
		name = "open_path.isra.5"
		size = 1392
		refs = "0090 mempcpy 0174 __aeabi_read_tp 0234 __xstat64 0270 malloc 028c memcpy 02b8 _dl_debug_printf 02e0 __fxstat64 0300 __close 03f8 _dl_debug_printf_c 04f4 free 0538 _dl_debug_mask 053c __libc_errno 0540 _dl_ns 0548 __libc_enable_secure 055c _dl_argv"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 A4 D0 4D E2 A8 30 0B E5 00 30 93 E5 00 00 53 E3 98 00 0B E5 94 10 0B E5 9C 20 0B E5 63 00 00 0A 00 75 9F E5 00 05 9F E5 08 10 97 E5 00 20 90 E5 02 20 81 E0 94 10 1B E5 01 20 82 E0 A0 30 0B E5 0E 20 82 E2 07 30 C2 E3 A0 20 1B E5 04 A0 92 E4 03 D0 4D E0 00 30 A0 E3 A0 20 0B E5 A4 30 0B E5 C8 94 9F E5 AC 30 0B E5 0D 80 A0 E1 0A 50 A0 E1 00 30 99 E5 01 00 13 E3 A6 00 00 1A 0C 10 85 E2 08 00 A0 E1 06 00 91 E8 ?? ?? ?? ?? 00 60 97 E5 00 00 56 E3 00 A0 A0 E1 3A 00 00 0A 00 40 A0 E3 04 60 A0 E1 25 00 00 EA 0C 30 97 E5 84 21 83 E0 84 11 93 E7 04 20 92 E5 0A 00 A0 E1 ?? ?? ?? ?? 98 10 4B E2 06 00 91 E8 ?? ?? ?? ?? 00 30 99 E5 00 00 68 E0 01 00 13 E3 90 00 0B E5 71 00 00 1A 10 20 9B E5 00 30 A0 E3 08 00 A0 E1 08 10 9B E5 70 FE FF EB 14 20 95 E5 00 00 52 E3 00 30 A0 E1 2E 00 00 1A 01 00 70 E3 32 00 00 0A 02 20 A0 E3 14 20 85 E5 01 60 A0 E3 9C 10 1B E5 00 00 51 E3 64 00 00 1A 01 00 73 E3 01 40 84 E2 4B 00 00 1A 00 30 97 E5 04 00 53 E1 04 50 85 E2 07 00 00 9A 14 30 95 E5 01 00 53 E3 D6 FF FF 1A 01 40 84 E2 00 30 97 E5 04 00 53 E1 04 50 85 E2 F7 FF FF 8A 00 00 56 E3 07 00 00 0A C4 33 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 02 00 53 E3 01 00 00 0A 0D 00 53 E3 09 00 00 1A A0 10 1B E5 A4 20 1B E5 04 50 91 E4 06 20 82 E1 00 00 55 E3 A0 10 0B E5 A4 20 0B E5 B1 FF FF 1A 00 00 52 E3 CA 00 00 0A 00 00 E0 E3 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 01 00 52 E3 01 60 86 13 01 00 70 E3 D1 FF FF 1A 01 40 84 E2 DD FF FF EA 0C 10 9B E5 00 00 51 E3 08 00 00 0A 18 30 91 E5 83 21 83 E0 82 30 83 E0 40 23 9F E5 03 31 92 E7 95 31 D3 E5 08 00 13 E3 01 30 A0 13 12 00 00 1A 90 30 1B E5 94 C0 1B E5 03 20 88 E0 00 00 A0 E3 0C 30 E0 E1 03 00 C2 E7 08 10 A0 E1 03 00 A0 E3 8C 20 4B E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 7C 30 1B E5 0F 3A 03 E2 01 09 53 E3 13 00 00 0A 01 30 A0 E3 14 30 85 E5 00 30 A0 E3 03 60 86 E1 01 40 84 E2 BB FF FF EA 90 00 1B E5 03 A0 A0 E1 ?? ?? ?? ?? 04 30 9B E5 00 00 50 E3 00 00 83 E5 94 00 00 0A 08 10 A0 E1 90 20 1B E5 ?? ?? ?? ?? 0A 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 02 30 A0 E3 14 30 85 E5 01 30 A0 E3 EA FF FF EA 8C 02 9F E5 08 10 A0 E1 ?? ?? ?? ?? 89 FF FF EA 80 C2 9F E5 00 20 9C E5 00 00 52 E3 96 FF FF 0A 03 10 A0 E1 03 00 A0 E3 8C 20 4B E2 C0 30 0B E5 ?? ?? ?? ?? 00 00 50 E3 C0 30 1B E5 02 00 00 1A 7C 20 1B E5 02 0B 12 E3 8B FF FF 1A 03 00 A0 E1 ?? ?? ?? ?? 40 02 9F E5 02 20 A0 E3 00 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 30 E0 E3 82 FF FF EA 04 40 95 E5 AC C0 1B E5 0C 00 54 E1 54 FF FF 0A FC 01 9F E5 08 20 97 E5 00 30 90 E5 03 30 82 E0 07 30 83 E2 07 30 C3 E3 B8 D0 0B E5 03 D0 4D E0 08 30 95 E5 F4 01 9F E5 AC 30 0B E5 ?? ?? ?? ?? A0 C0 1B E5 04 30 1C E5 00 00 53 E3 90 D0 0B E5 41 00 00 0A 04 20 93 E5 02 00 54 E1 3E 00 00 1A 01 C0 A0 E3 A0 A0 1B E5 B0 C0 0B E5 0C C0 8D E0 BC C0 0B E5 B4 80 0B E5 0A 60 A0 E1 05 A0 A0 E1 04 50 A0 E1 0C 10 83 E2 90 00 1B E5 06 00 91 E8 ?? ?? ?? ?? 00 30 97 E5 00 00 53 E3 00 40 A0 E1 24 00 00 0A 00 80 A0 E3 11 00 00 EA BC C0 1B E5 0C 00 50 E1 3B 00 00 0A 00 20 A0 E3 01 20 40 E5 B0 C0 1B E5 68 31 9F E5 00 00 5C E3 64 01 9F E5 90 10 1B E5 03 00 A0 11 ?? ?? ?? ?? 00 30 A0 E3 B0 30 0B E5 00 20 97 E5 01 80 88 E2 02 00 58 E1 10 00 00 2A 04 20 16 E5 08 21 82 E0 14 20 92 E5 01 00 52 E3 04 00 A0 E1 F5 FF FF 0A 0C 10 97 E5 88 21 81 E0 04 20 92 E5 88 11 91 E7 ?? ?? ?? ?? 90 30 1B E5 00 00 53 E1 DF FF FF 1A 00 10 A0 E3 00 10 C0 E5 E1 FF FF EA 04 30 96 E4 00 00 53 E3 02 00 00 0A 04 20 93 E5 02 00 55 E1 CC FF FF 0A B4 80 1B E5 05 40 A0 E1 0A 50 A0 E1 AC 30 1B E5 00 00 53 E3 25 00 00 0A AC C0 1B E5 00 30 DC E5 00 00 53 E3 1F 00 00 1A BC 00 9F E5 00 20 90 E5 00 20 92 E5 B4 30 9F E5 00 00 52 E3 03 20 A0 01 AC 00 9F E5 04 10 A0 E1 ?? ?? ?? ?? AC 40 0B E5 B8 D0 1B E5 EE FE FF EA 00 20 D3 E5 2F 00 52 E3 C0 FF FF 1A DC FF FF EA 0A 00 A0 E1 ?? ?? ?? ?? 34 FF FF EA A8 C0 1B E5 04 30 9C E5 00 00 53 E3 00 00 9C 15 ?? ?? ?? ?? 68 30 9F E5 A8 00 1B E5 03 00 50 E1 2B FF FF 0A A8 10 1B E5 00 00 E0 E3 00 00 81 E5 28 FF FF EA AC 20 1B E5 E3 FF FF EA 44 00 9F E5 04 10 A0 E1 ?? ?? ?? ?? E2 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_9_0 {
	meta:
		name = "add_path.13093.isra.1.constprop.7"
		size = 208
		refs = "0088 mempcpy"
	strings:
		$1 = { 01 00 70 E3 F8 40 2D E9 0C 40 A0 E1 25 00 00 0A 00 30 90 E5 00 50 A0 E1 00 60 A0 E3 0A 00 00 EA 08 20 94 E5 10 00 93 E5 0A 00 92 E8 02 00 50 E3 00 10 81 20 02 10 81 32 01 30 83 E2 0A 00 82 E8 04 30 B5 E5 00 00 53 E3 16 00 00 0A 0C 20 D4 E5 00 00 52 E3 F1 FF FF 1A 04 10 94 E5 10 20 93 E5 08 C0 94 E5 00 00 94 E5 01 10 81 E2 01 00 52 E3 04 10 84 E5 81 71 8C E0 81 01 8C E7 0B 00 00 9A 0C 10 93 E5 01 20 42 E2 ?? ?? ?? ?? 01 30 80 E2 00 30 84 E5 00 60 C0 E5 04 30 B5 E5 00 00 53 E3 04 60 87 E5 E8 FF FF 1A F8 40 BD E8 ?? ?? ?? ?? 00 00 52 E3 01 30 80 E2 2E 20 A0 03 2F 20 A0 13 00 30 84 E5 00 20 C0 E5 00 00 94 E5 EE FF FF EA }
	condition:
		$1
}

rule file_248_10_0 {
	meta:
		name = "expand_dynamic_string_token"
		size = 260
		refs = "0018 strchr 0034 _dl_dst_count 0044 strlen 008c malloc 00a8 _dl_dst_substitute 00bc _dl_get_origin 00e8 __assert_fail 00f4 _dl_platformlen"
	strings:
		$1 = { F0 41 2D E9 01 40 A0 E1 00 50 A0 E1 24 10 A0 E3 04 00 A0 E1 02 60 A0 E1 ?? ?? ?? ?? 00 00 50 E3 02 00 00 1A 04 00 A0 E1 F0 41 BD E8 8C F7 FF EA 06 10 A0 E1 ?? ?? ?? ?? 00 80 50 E2 F8 FF FF 0A 04 00 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 A8 01 95 E5 00 00 50 E3 14 00 00 0A 01 00 70 E3 1B 00 00 0A ?? ?? ?? ?? 88 30 9F E5 00 30 93 E5 03 00 53 E3 03 30 A0 33 00 00 53 E1 03 00 A0 21 04 00 50 E3 04 00 40 82 98 70 27 80 01 00 87 E2 ?? ?? ?? ?? 00 20 50 E2 14 00 00 0A 05 00 A0 E1 04 10 A0 E1 06 30 A0 E1 F0 41 BD E8 ?? ?? ?? ?? 04 30 95 E5 00 30 D3 E5 00 00 53 E3 06 00 00 1A ?? ?? ?? ?? 01 20 40 E2 03 00 72 E3 A8 01 85 E5 E3 FF FF 9A 00 00 A0 E3 E2 FF FF EA 18 00 9F E5 18 10 9F E5 1B 2E A0 E3 14 30 9F E5 ?? ?? ?? ?? F0 41 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_11_0 {
	meta:
		name = "cache_rpath.part.6"
		size = 432
		refs = "0084 malloc 00ac free 0190 _dl_signal_error 019c _dl_inhibit_rpath 01a4 __libc_enable_secure"
	strings:
		$1 = { F0 43 2D E9 08 20 82 E2 02 41 90 E7 00 00 54 E3 0C D0 4D E2 01 60 A0 E1 03 70 A0 E1 2A 00 00 0A 74 31 9F E5 34 20 90 E5 00 30 93 E5 04 10 94 E5 04 20 92 E5 00 00 53 E3 02 10 81 E0 04 80 90 E5 27 00 00 1A 01 20 A0 E3 AB FF FF EB 00 50 50 E2 4F 00 00 0A 00 40 D5 E5 00 00 54 E3 05 20 A0 11 00 C0 A0 13 17 00 00 0A 3A 00 54 E3 01 40 F2 E5 01 C0 8C 02 00 00 54 E3 FA FF FF 1A 02 00 8C E2 00 01 A0 E1 ?? ?? ?? ?? 00 90 50 E2 39 00 00 0A 04 30 A0 E1 09 10 A0 E1 00 21 9F E5 80 01 8D E8 05 00 A0 E1 3C F7 FF EB 05 00 A0 E1 ?? ?? ?? ?? 01 00 A0 E3 00 90 86 E5 04 00 86 E5 0C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 00 30 E0 E3 04 00 A0 E1 00 30 86 E5 0C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? B8 20 9F E5 00 20 92 E5 00 00 52 E3 00 20 D3 05 08 C0 A0 01 05 00 00 0A D0 FF FF EA 00 00 52 E3 17 00 00 0A 01 20 D3 E5 01 C0 8C E2 01 30 83 E2 00 40 DC E5 02 00 54 E1 F7 FF FF 0A 00 00 54 E3 01 00 00 1A 0B 00 00 EA 01 20 DC E5 00 00 52 E3 03 C0 A0 E1 C1 FF FF 0A 3A 00 52 E3 01 30 83 E2 F8 FF FF 1A 00 20 D3 E5 00 00 52 E3 BB FF FF 0A 08 C0 A0 E1 ED FF FF EA 00 00 52 E3 3A 00 52 13 F1 FF FF 1A 00 30 E0 E3 00 30 86 E5 00 00 A0 E3 D0 FF FF EA 05 00 A0 E1 ?? ?? ?? ?? 20 30 9F E5 00 10 A0 E3 01 20 A0 E1 0C 00 A0 E3 ?? ?? ?? ?? 10 30 9F E5 F9 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_12_0 {
	meta:
		name = "_dl_dst_count"
		size = 184
		refs = "008c strchr 00a8 __libc_enable_secure"
	strings:
		$1 = { F0 41 2D E9 9C 30 9F E5 00 80 93 E5 08 D0 4D E2 00 50 A0 E1 01 60 A0 E1 00 70 A0 E3 01 40 80 E2 04 10 A0 E1 80 20 9F E5 06 30 A0 E1 00 80 8D E5 05 00 A0 E1 A3 F7 FF EB 00 C0 50 E2 04 10 A0 E1 68 20 9F E5 06 30 A0 E1 05 00 A0 E1 0B 00 00 1A 00 C0 8D E5 9B F7 FF EB 00 C0 50 E2 04 10 A0 E1 4C 20 9F E5 06 30 A0 E1 05 00 A0 E1 03 00 00 1A 00 C0 8D E5 93 F7 FF EB 00 C0 50 E2 00 00 00 0A 01 70 87 E2 0C 00 84 E0 24 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 E0 FF FF 1A 07 00 A0 E1 08 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_13_0 {
	meta:
		name = "_dl_dst_substitute"
		size = 620
		refs = "0210 stpcpy 0254 __libc_enable_secure 0260 _dl_platform"
	strings:
		$1 = { F0 4F 2D E9 02 80 A0 E1 1C D0 4D E2 01 A0 A0 E1 00 20 D1 E5 00 C0 A0 E1 03 70 A0 E1 08 B0 A0 E1 08 40 A0 E1 01 50 A0 E1 00 90 A0 E3 03 00 00 EA 01 20 D5 E5 00 00 52 E3 11 00 00 0A 06 50 A0 E1 24 00 52 E3 16 00 00 0A 00 00 57 E3 00 20 C4 E5 01 60 85 E2 01 40 84 E2 F4 FF FF 0A 01 50 D5 E5 3A 00 55 E3 05 20 A0 11 F1 FF FF 1A 00 00 59 E3 05 20 A0 01 48 00 00 1A 04 B0 A0 E1 EE FF FF EA 0B 40 A0 E1 00 00 59 E3 6B 00 00 1A 00 30 A0 E3 08 00 A0 E1 00 30 C4 E5 1C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? A8 21 9F E5 00 20 92 E5 01 60 85 E2 14 20 8D E5 00 20 8D E5 07 30 A0 E1 06 10 A0 E1 0A 00 A0 E1 8C 21 9F E5 0C C0 8D E5 4F F7 FF EB 00 30 50 E2 0C C0 9D E5 22 00 00 0A 14 20 9D E5 00 00 52 E3 A8 11 9C E5 4E 00 00 0A 94 21 DC E5 03 00 12 E3 00 90 A0 13 01 90 A0 03 01 20 41 E2 03 00 72 E3 3E 00 00 9A 01 00 53 E3 37 00 00 9A 03 20 D6 E7 00 00 52 E3 03 30 86 E0 04 00 00 1A D6 FF FF EA 01 20 D3 E5 00 00 52 E3 01 30 83 E2 D2 FF FF 0A 00 00 57 E3 03 60 A0 E1 F8 FF FF 0A 3A 00 52 E3 F6 FF FF 1A 08 00 5B E1 37 00 00 1A 01 20 D3 E5 00 00 52 E3 34 00 00 0A 01 60 83 E2 08 40 A0 E1 C3 FF FF EA 00 30 8D E5 0A 00 A0 E1 07 30 A0 E1 06 10 A0 E1 DC 20 9F E5 0C C0 8D E5 22 F7 FF EB 00 30 50 E2 0C C0 9D E5 0C 00 00 0A C8 20 9F E5 00 10 92 E5 D7 FF FF EA 04 10 6B E0 0B 00 A0 E1 0C C0 8D E5 63 F7 FF EB 00 90 A0 E3 09 00 50 E1 0B 40 A0 01 05 20 A0 E1 0C C0 9D E5 AC FF FF EA 00 30 8D E5 0A 00 A0 E1 07 30 A0 E1 06 10 A0 E1 88 20 9F E5 0C C0 8D E5 0B F7 FF EB 00 30 50 E2 0C C0 9D E5 78 10 9F 15 C2 FF FF 1A 24 30 A0 E3 00 30 C4 E5 01 40 84 E2 01 20 D5 E5 8B FF FF EA 04 00 A0 E1 10 30 8D E5 0C C0 8D E5 ?? ?? ?? ?? 10 30 9D E5 00 40 A0 E1 03 20 F6 E7 0C C0 9D E5 82 FF FF EA 14 90 9D E5 B2 FF FF EA 00 20 D6 E5 0B 40 A0 E1 7D FF FF EA 04 10 6B E0 0B 00 A0 E1 3C F7 FF EB 00 00 50 E3 0B 40 A0 01 8D FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_14_0 {
	meta:
		name = "_dl_init_paths"
		size = 640
		refs = "002c _dl_important_hwcaps 0038 malloc 0160 strlen 017c memcpy 0214 free 023c _dl_signal_error 0248 _dl_platform 0250 _dl_platformlen 0258 _dl_all_dirs 0270 __libc_enable_secure"
	strings:
		$1 = { F0 4F 2D E9 3C 32 9F E5 20 B0 8D E2 38 72 9F E5 0C D0 4D E2 34 22 9F E5 00 10 92 E5 00 60 A0 E1 07 20 A0 E1 00 00 93 E5 08 30 87 E2 ?? ?? ?? ?? 0C 00 87 E5 0C 00 A0 E3 ?? ?? ?? ?? 00 00 50 E3 00 80 A0 E1 10 00 87 E5 7C 00 00 0A 00 40 97 E5 FC 31 9F E5 04 91 A0 E1 27 90 89 E2 93 29 89 E0 29 92 A0 E1 09 91 89 E0 09 03 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 50 A0 E1 00 00 88 E5 6A 00 00 0A D0 A1 9F E5 D0 01 9F E5 D0 C1 9F E5 00 30 A0 E3 05 20 A0 E3 00 00 54 E3 09 11 A0 E1 00 50 8A E5 04 00 85 E5 0C C0 85 E5 14 30 87 E5 08 30 85 E5 10 20 85 E5 06 00 00 0A 03 20 A0 E1 05 C0 A0 E1 01 30 83 E2 04 00 53 E1 14 20 8C E5 04 C0 8C E2 FA FF FF 1A 88 91 9F E5 01 C0 85 E0 09 20 A0 E3 00 30 A0 E3 00 00 54 E3 00 C0 85 E5 04 C0 88 E5 10 20 8C E5 04 00 8C E5 0C 90 8C E5 08 30 8C E5 03 20 A0 11 04 00 00 0A 01 30 83 E2 04 00 53 E1 14 20 8C E5 04 C0 8C E2 FA FF FF 1A 44 21 9F E5 00 30 A0 E3 09 00 A0 E3 00 00 56 E3 00 00 82 E5 01 30 85 E7 08 30 88 E5 02 00 00 0A 00 30 D6 E5 00 00 53 E3 04 00 00 1A 00 30 E0 E3 18 30 87 E5 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 06 00 A0 E1 ?? ?? ?? ?? 0F 30 80 E2 07 30 C3 E3 03 D0 4D E0 01 20 80 E2 06 10 A0 E1 08 00 8D E2 ?? ?? ?? ?? 00 30 D6 E5 00 00 53 E3 00 50 A0 E1 24 00 00 0A 01 20 A0 E3 3A 30 43 E2 01 00 53 E3 01 30 F6 E5 01 20 82 92 00 00 53 E3 F9 FF FF 1A 01 20 82 E2 02 01 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 10 A0 E1 18 00 87 E5 80 40 9F E5 17 00 00 0A 98 C0 9F E5 98 30 9F E5 00 20 A0 E3 00 30 93 E5 05 00 A0 E1 04 20 8D E5 00 C0 8D E5 84 20 9F E5 7E F6 FF EB 18 00 94 E5 00 30 90 E5 00 00 53 E3 04 00 00 0A 00 30 A0 E3 1C 30 87 E5 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 00 30 E0 E3 18 30 84 E5 F6 FF FF EA 08 00 A0 E3 E1 FF FF EA 44 30 9F E5 00 10 A0 E3 01 20 A0 E1 0C 00 A0 E3 ?? ?? ?? ?? 34 30 9F E5 F9 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? CD CC CC CC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_15_0 {
	meta:
		name = "_dl_map_object"
		size = 2212
		refs = "0088 _dl_name_match_p 00c0 strchr 0198 strlen 02a8 _dl_debug_printf 0318 _dl_load_cache_lookup 037c __close 0570 strcmp 0624 memcmp 071c __assert_fail 073c free 0788 _dl_new_object 07c0 _dl_add_to_namespace_list 07e8 _dl_signal_error 080c __aeabi_read_tp 0824 _dl_nns 0828 _dl_ns 082c _dl_debug_mask 0830 __libc_stack_end 0844 _dl_inhibit_cache 0858 __libc_enable_secure 086c _dl_argv 089c __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 95 DF 4D E2 7C 52 9D E5 00 00 55 E3 00 60 A0 E1 01 40 A0 E1 02 A0 A0 E1 20 30 8D E5 BE 01 00 BA F8 37 9F E5 00 30 93 E5 03 00 55 E1 B5 01 00 2A 85 81 A0 E1 05 30 88 E0 E4 77 9F E5 83 30 85 E0 03 B1 97 E7 00 00 5B E3 06 00 00 1A 13 00 00 EA 95 31 DB E5 01 00 13 E3 3A 01 00 0A 0C B0 9B E5 00 00 5B E3 0D 00 00 0A 95 31 DB E5 02 00 13 E3 F9 FF FF 1A 20 00 13 E3 F7 FF FF 1A 04 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 EF FF FF 0A 0B 00 A0 E1 95 DF 8D E2 F0 4F BD E8 ?? ?? ?? ?? 80 B7 9F E5 00 90 9B E5 40 30 19 E2 70 01 00 1A 04 00 A0 E1 2F 10 A0 E3 43 30 CD E5 ?? ?? ?? ?? 00 00 50 E3 2E 00 00 0A 00 00 56 E3 77 00 00 0A 78 C2 9D E5 01 C2 0C E2 1C C0 8D E5 06 00 A0 E1 04 10 A0 E1 00 20 A0 E3 76 FE FF EB 00 00 50 E3 44 00 8D E5 00 10 E0 03 06 00 00 0A 4C 10 8D E2 43 20 8D E2 01 30 A0 E3 C5 FA FF EB 01 00 70 E3 00 10 A0 E1 85 01 00 0A 1C C0 9D E5 00 00 5C E3 00 60 A0 13 01 00 71 E3 85 01 00 0A F8 26 9F E5 78 02 9D E5 00 C0 92 E5 48 20 8D E2 08 00 8D E5 0C 20 8D E5 44 30 9D E5 40 04 8D E8 10 50 8D E5 04 00 A0 E1 4C 20 8D E2 48 C0 8D E5 15 F7 FF EB 95 DF 8D E2 F0 4F BD E8 ?? ?? ?? ?? 04 00 A0 E1 2F 10 A0 E3 43 60 CD E5 ?? ?? ?? ?? 00 00 50 E3 4A 00 00 1A 78 C2 9D E5 01 C2 0C E2 1C C0 8D E5 04 00 A0 E1 ?? ?? ?? ?? 01 00 19 E3 01 00 80 E2 2C 00 8D E5 52 01 00 1A 00 00 56 E3 8B 00 00 0A 94 30 96 E5 00 00 53 E3 AB 00 00 0A 6C 06 9F E5 18 10 90 E5 01 00 71 E3 01 90 A0 03 13 00 00 0A 00 00 56 E3 78 C2 9D E5 00 10 97 05 06 10 A0 11 01 23 0C E2 44 30 8D E2 43 C0 8D E2 4C 00 8D E2 08 10 8D E5 00 30 8D E5 04 00 8D E5 2C 10 9D E5 0C C0 8D E5 04 00 A0 E1 24 36 9F E5 D4 FB FF EB 01 00 70 E3 00 10 A0 E1 00 90 A0 13 01 90 A0 03 00 C0 96 E2 01 C0 A0 13 0C 90 19 E0 24 C0 8D E5 14 00 00 0A E8 31 96 E5 01 00 73 E3 7A CF 86 E2 29 00 00 0A 00 00 53 E3 1E 00 00 0A 0C 30 A0 E1 78 C2 9D E5 44 20 8D E2 43 00 8D E2 4C 10 8D E2 00 20 8D E5 0C 00 8D E5 04 10 8D E5 08 60 8D E5 2C 10 9D E5 04 00 A0 E1 01 23 0C E2 24 90 8D E5 B7 FB FF EB 00 10 A0 E1 01 00 71 E3 17 00 00 0A 00 30 9B E5 01 00 13 E3 9E FF FF 0A 94 05 9F E5 18 10 8D E5 ?? ?? ?? ?? 18 10 9D E5 99 FF FF EA 04 00 A0 E1 9C F5 FF EB 78 C2 9D E5 01 C2 0C E2 1C C0 8D E5 88 FF FF EA 0C 10 A0 E1 06 00 A0 E1 1D 20 A0 E3 60 35 9F E5 18 C0 8D E5 3A FE FF EB 00 00 50 E3 18 C0 9D E5 D7 FF FF 1A 24 90 8D E5 78 C2 9D E5 01 C3 1C E2 28 C0 8D E5 BF 00 00 1A 38 35 9F E5 00 30 93 E5 00 00 53 E3 1A 00 00 1A 04 00 A0 E1 ?? ?? ?? ?? 00 90 50 E2 16 00 00 0A 24 C0 9D E5 00 00 5C E3 02 00 00 0A 04 32 96 E5 02 0B 13 E3 B6 00 00 1A 4C 10 8D E2 09 00 A0 E1 43 20 8D E2 00 30 A0 E3 35 FA FF EB 01 00 70 E3 00 10 A0 E1 08 00 00 0A 09 00 A0 E1 18 10 8D E5 71 F5 FF EB 00 00 50 E3 44 00 8D E5 18 10 9D E5 C6 FF FF 1A 01 00 A0 E1 ?? ?? ?? ?? 24 C0 9D E5 00 00 5C E3 96 00 00 0A 04 22 96 E5 06 30 A0 E1 02 0B 12 E3 89 00 00 1A 90 04 9F E5 10 20 90 E5 01 00 72 E3 85 00 00 0A 44 00 8D E2 43 E0 8D E2 4C C0 8D E2 08 30 8D E5 2C 10 9D E5 00 00 8D E5 28 20 9D E5 0C E0 8D E5 04 C0 8D E5 04 00 A0 E1 6C 34 9F E5 62 FB FF EB 00 10 A0 E1 AB FF FF EA 00 C0 97 E5 24 C0 8D E5 24 C0 9D E5 00 00 5C E3 71 FF FF 0A 94 31 DC E5 03 30 03 E2 02 00 53 E3 6D FF FF 0A 98 31 9C E5 01 00 73 E3 6A FF FF 0A 00 00 53 E3 66 9F 8C E2 8D 00 00 0A 24 30 9D E5 00 00 56 E3 78 C2 9D E5 06 30 A0 11 44 20 8D E2 43 00 8D E2 4C 10 8D E2 08 30 8D E5 00 20 8D E5 0C 00 8D E5 04 10 8D E5 09 30 A0 E1 2C 10 9D E5 04 00 A0 E1 01 23 0C E2 41 FB FF EB 01 00 70 E3 00 10 A0 E1 89 FF FF 1A 53 FF FF EA 43 00 8D E2 38 00 8D E5 00 C0 97 E5 78 02 9D E5 24 C0 8D E5 01 C3 00 E2 30 A0 8D E5 34 50 8D E5 3C 80 8D E5 28 30 8D E5 06 90 A0 E1 2C 50 9D E5 0C 80 A0 E1 38 A0 9D E5 13 00 00 EA 44 00 8D E2 4C 10 8D E2 00 00 8D E5 42 04 8D E9 0C 30 A0 E1 04 00 A0 E1 05 10 A0 E1 08 20 A0 E1 25 FB FF EB 01 00 70 E3 18 00 00 1A 28 30 9D E5 24 C0 9D E5 0C 00 59 E1 01 30 83 03 FF 30 03 E2 28 30 8D E5 6C 91 99 E5 00 00 59 E3 33 00 00 0A 98 31 99 E5 01 00 73 E3 66 CF 89 E2 F8 FF FF 0A 00 00 53 E3 E5 FF FF 1A 0C 10 A0 E1 09 00 A0 E1 0F 20 A0 E3 24 33 9F E5 18 C0 8D E5 A8 FD FF EB 00 00 50 E3 18 C0 9D E5 ED FF FF 0A DB FF FF EA 00 10 A0 E1 30 A0 9D E5 34 50 9D E5 51 FF FF EA 58 30 9B E5 00 00 53 E3 C1 FE FF 0A 34 20 9B E5 04 30 93 E5 04 90 92 E5 03 90 89 E0 09 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 09 00 00 0A 04 00 A0 E1 C8 12 9F E5 ?? ?? ?? ?? 00 00 50 E3 B3 FE FF 1A 09 00 A0 E1 B8 12 9F E5 ?? ?? ?? ?? 00 00 50 E3 AE FE FF 1A 1C 00 9B E5 04 10 A0 E1 B0 F5 FF EB 95 21 DB E5 01 20 82 E3 95 21 CB E5 0B 00 A0 E1 B4 FE FF EA 00 10 E0 E3 31 FF FF EA 28 C0 9D E5 00 00 5C E3 30 A0 9D E5 34 50 9D E5 3C 80 9D E5 F6 FE FF 1A 80 FF FF EA 05 30 88 E0 83 30 85 E0 03 31 97 E7 00 00 53 E3 67 FF FF 0A 04 22 93 E5 63 FF FF EA 4C 32 9F E5 00 30 93 E5 00 00 53 E3 5A FF FF 1A 3A FF FF EA 3C 12 9F E5 05 20 A0 E3 18 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 18 30 9D E5 06 00 00 0A 09 00 A0 E1 20 12 9F E5 09 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 18 30 9D E5 3A FF FF 1A 03 20 A0 E1 4D FF FF EA 24 00 9D E5 09 10 A0 E1 0F 20 A0 E3 E0 31 9F E5 58 FD FF EB 00 00 50 E3 D2 FE FF 0A 69 FF FF EA 00 00 56 E3 BB FE FF 0A 04 30 96 E5 78 C2 9D E5 D4 01 9F E5 00 20 D3 E5 D0 11 9F E5 01 C2 1C E2 01 00 A0 01 00 00 52 E3 1C C0 8D E5 05 00 00 1A BC 31 9F E5 00 30 93 E5 00 30 93 E5 B4 21 9F E5 00 00 53 E3 02 30 A0 01 18 20 96 E5 04 10 A0 E1 00 20 8D E5 05 20 A0 E1 ?? ?? ?? ?? 00 30 A0 E3 04 00 A0 E1 2F 10 A0 E3 43 30 CD E5 ?? ?? ?? ?? 00 00 50 E3 00 90 9B 05 7A FE FF 1A A6 FE FF EA 74 01 9F E5 04 10 A0 E1 05 20 A0 E1 ?? ?? ?? ?? A7 FE FF EA 64 01 9F E5 64 11 9F E5 64 21 9F E5 64 31 9F E5 ?? ?? ?? ?? 60 01 9F E5 50 11 9F E5 5C 21 9F E5 50 31 9F E5 ?? ?? ?? ?? 44 00 9D E5 18 10 8D E5 ?? ?? ?? ?? 18 10 9D E5 74 FE FF EA 20 C0 9D E5 00 00 5C E3 1D 00 00 0A 00 30 9B E5 02 0B 13 E3 1A 00 00 1A 04 00 A0 E1 71 F4 FF EB 00 70 50 E2 1E 00 00 0A 78 C2 9D E5 06 30 A0 E1 00 C0 8D E5 04 50 8D E5 0A 20 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 60 50 E2 15 00 00 0A 95 E1 D6 E5 94 C1 D6 E5 EC 20 9F E5 02 E0 8E E3 04 C0 8C E3 01 30 A0 E3 05 10 A0 E1 95 E1 C6 E5 94 C1 C6 E5 8C 21 86 E5 78 31 86 E5 ?? ?? ?? ?? 06 00 A0 E1 32 FE FF EA 43 20 DD E5 00 00 52 E3 0B 00 00 0A 00 00 A0 E3 04 10 A0 E1 00 20 A0 E1 A8 30 9F E5 ?? ?? ?? ?? 07 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 0C 00 A0 E3 00 20 A0 E3 90 30 9F E5 ?? ?? ?? ?? 8C 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 00 90 E7 04 10 A0 E1 7C 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 26 08 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 25 08 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_16_0 {
	meta:
		name = "_dl_rtld_di_serinfo"
		size = 436
		refs = "01a8 _dl_ns"
	strings:
		$1 = { 70 40 2D E9 00 00 52 E3 10 D0 4D E2 0C 20 CD E5 04 20 91 05 00 20 A0 13 94 30 90 E5 04 20 81 15 00 20 81 15 01 20 82 E2 08 10 8D E5 00 00 53 E3 82 11 81 E0 00 30 A0 E3 00 50 A0 E1 0A 00 8D E8 1B 00 00 0A 58 41 9F E5 0D C0 A0 E1 18 00 94 E5 77 FB FF EB E8 01 95 E5 01 00 70 E3 03 00 00 0A 00 00 50 E3 3C 00 00 0A 0D C0 A0 E1 70 FB FF EB 04 32 95 E5 02 0B 13 E3 09 00 00 0A 0C 30 DD E5 00 00 53 E3 08 30 9D 15 06 00 93 18 01 20 82 12 82 21 81 10 00 20 83 15 10 D0 8D E2 70 40 BD E8 ?? ?? ?? ?? 0D C0 A0 E1 10 00 94 E5 60 FB FF EB F1 FF FF EA 00 40 A0 E1 98 31 94 E5 01 00 73 E3 04 00 00 0A 00 00 53 E3 03 00 A0 11 19 00 00 0A 0D C0 A0 E1 56 FB FF EB 6C 41 94 E5 00 00 54 E3 F4 FF FF 1A 18 30 95 E5 00 00 53 E3 D4 FF FF 1A B0 30 9F E5 00 40 93 E5 00 00 54 E3 D0 FF FF 0A 94 31 D4 E5 03 30 03 E2 02 00 53 E3 CC FF FF 0A 05 00 54 E1 CA FF FF 0A 98 01 94 E5 01 00 70 E3 C7 FF FF 0A 00 00 50 E3 14 00 00 0A 0D C0 A0 E1 3F FB FF EB C2 FF FF EA 04 00 A0 E1 66 1F 84 E2 0F 20 A0 E3 60 30 9F E5 77 FC FF EB 00 00 50 E3 98 01 94 15 DF FF FF 0A DC FF FF EA 05 00 A0 E1 7A 1F 85 E2 1D 20 A0 E3 40 30 9F E5 6E FC FF EB 00 00 50 E3 BD FF FF 0A E8 01 95 E5 B9 FF FF EA 04 00 A0 E1 66 1F 84 E2 0F 20 A0 E3 18 30 9F E5 65 FC FF EB 00 00 50 E3 A9 FF FF 0A 98 01 94 E5 E1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_249_0_0 {
	meta:
		name = "ppoll"
		size = 520
		refs = "007c __aeabi_read_tp 00fc __sigprocmask 010c __poll 016c __libc_enable_asynccancel 01a0 __libc_disable_asynccancel 01e0 __libc_multiple_threads 01e4 __libc_errno"
	strings:
		$1 = { F0 47 2D E9 03 60 A0 E1 D0 31 9F E5 00 50 52 E2 90 D0 4D E2 00 90 A0 E1 01 80 A0 E1 00 30 93 E5 03 00 95 18 08 20 8D 12 02 50 A0 11 03 00 82 18 05 20 A0 01 00 00 53 E3 4A 00 00 1A 09 00 A0 E1 08 10 A0 E1 06 30 A0 E1 08 40 A0 E3 15 7E A0 E3 00 00 00 EF 01 0A 70 E3 52 00 00 8A 00 40 A0 E1 01 00 74 E3 03 00 00 0A 04 00 A0 E1 90 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 64 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 26 00 53 E3 F5 FF FF 1A 00 00 55 E3 13 00 00 0A 00 30 95 E5 00 00 53 E3 2A 00 00 BA 04 20 95 E5 38 11 9F E5 01 00 52 E1 26 00 00 8A 30 11 9F E5 01 00 53 E1 09 00 00 CA 1E 00 00 0A 24 11 9F E5 24 01 9F E5 01 10 82 E0 90 C1 C2 E0 83 42 63 E0 C1 1F A0 E1 42 19 61 E0 04 41 83 E0 84 41 81 E0 00 00 56 E3 0D 00 00 0A 06 10 A0 E1 10 20 8D E2 02 00 A0 E3 ?? ?? ?? ?? 08 10 A0 E1 04 20 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 10 10 8D E2 00 40 A0 E1 00 20 A0 E3 02 00 A0 E3 ?? ?? ?? ?? CF FF FF EA 04 20 A0 E1 09 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 C9 FF FF EA B0 10 9F E5 01 00 52 E1 E6 FF FF CA DC FF FF EA A4 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 BF FF FF EA 04 20 8D E5 ?? ?? ?? ?? 08 40 A0 E3 00 A0 A0 E1 08 10 A0 E1 09 00 A0 E1 04 20 9D E5 06 30 A0 E1 15 7E A0 E3 00 00 00 EF 01 0A 70 E3 00 40 A0 E1 09 00 00 8A 0A 00 A0 E1 ?? ?? ?? ?? AD FF FF EA 50 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 A5 FF FF EA 38 30 9F E5 00 40 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 40 80 E7 00 40 E0 E3 EE FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? FF C9 9A 3B 9B C4 20 00 3F 42 0F 00 83 DE 1B 43 C0 6F 90 26 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_250_0_0 {
	meta:
		name = "__atomic_readv_replacement"
		size = 384
		refs = "008c __read 00d4 memcpy 00e8 free 0100 __aeabi_read_tp 0128 __libc_alloca_cutoff 0138 malloc 0168 _Unwind_Resume 017c __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 00 50 52 E2 20 B0 8D E2 0C D0 4D E2 00 70 A0 E1 01 60 A0 E1 4C 00 00 DA 04 E0 91 E5 06 01 7E E3 00 C0 A0 93 0C 40 A0 91 01 20 A0 91 06 00 00 9A 30 00 00 EA 08 20 82 E2 04 E0 92 E5 02 31 E0 E3 03 30 64 E0 0E 00 53 E1 2A 00 00 3A 01 C0 8C E2 05 00 5C E1 0E 40 84 E0 F5 FF FF 1A 01 0A 54 E3 2E 00 00 8A 0E 30 84 E2 07 30 C3 E3 03 D0 4D E0 00 30 A0 E3 28 30 0B E5 0D 80 A0 E1 07 00 A0 E1 04 20 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 A0 50 E2 2B 00 00 BA 00 00 55 E3 0A 70 A0 E1 0F 00 00 DA 00 90 A0 E3 03 00 00 EA 01 90 89 E2 05 00 59 E1 08 60 86 E2 09 00 00 0A 04 40 96 E5 04 00 57 E1 07 40 A0 31 08 10 A0 E1 04 20 A0 E1 00 00 96 E5 ?? ?? ?? ?? 04 70 57 E0 04 80 88 E0 F1 FF FF 1A 28 00 1B E5 ?? ?? ?? ?? 0A 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 78 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 00 A0 E0 E3 03 20 80 E7 0A 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 CC FF FF 1A 04 00 A0 E1 ?? ?? ?? ?? 00 80 50 E2 28 80 0B E5 CD FF FF 1A 00 A0 E0 E3 E4 FF FF EA 00 40 A0 E3 C3 FF FF EA 00 40 A0 E1 28 00 1B E5 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 00 30 A0 E3 00 40 A0 E1 28 30 0B E5 F7 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_250_1_0 {
	meta:
		name = "__libc_readv"
		size = 248
		refs = "004c __aeabi_read_tp 007c __libc_enable_asynccancel 00a8 __libc_disable_asynccancel 00e8 __libc_multiple_threads 00ec __libc_errno"
	strings:
		$1 = { F8 43 2D E9 DC 30 9F E5 00 30 93 E5 00 00 53 E3 00 80 A0 E1 01 60 A0 E1 02 50 A0 E1 16 00 00 1A 91 70 A0 E3 00 00 00 EF 01 0A 70 E3 1F 00 00 8A 00 40 A0 E1 00 00 54 E3 02 00 00 BA 04 00 A0 E1 F8 43 BD E8 ?? ?? ?? ?? 9C 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 16 00 53 E3 F6 FF FF 1A 08 00 55 E3 F4 FF FF DA 08 00 A0 E1 06 10 A0 E1 05 20 A0 E1 F8 43 BD E8 80 FF FF EA ?? ?? ?? ?? 91 70 A0 E3 00 90 A0 E1 06 10 A0 E1 08 00 A0 E1 05 20 A0 E1 00 00 00 EF 01 0A 70 E3 00 40 A0 E1 09 00 00 8A 09 00 A0 E1 ?? ?? ?? ?? E0 FF FF EA 38 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 D8 FF FF EA 20 30 9F E5 00 40 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 40 80 E7 00 40 E0 E3 EE FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_251_0_0 {
	meta:
		name = "__umask"
		size = 20
	strings:
		$1 = { 04 70 2D E5 3C 70 A0 E3 00 00 00 EF 04 70 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_252_0_0 {
	meta:
		name = "__seed48_r"
		size = 96
		refs = "0014 memcpy"
	strings:
		$1 = { 06 20 A0 E3 38 40 2D E9 00 50 A0 E1 02 00 81 E0 01 40 A0 E1 ?? ?? ?? ?? B4 30 D5 E1 B4 30 C4 E1 B2 30 D5 E1 B2 30 C4 E1 2C 20 9F E5 B0 C0 D5 E1 05 30 A0 E3 0B 00 A0 E3 01 10 A0 E3 BC 00 C4 E1 B0 C0 C4 E1 10 20 84 E5 14 30 84 E5 BE 10 C4 E1 00 00 A0 E3 38 40 BD E8 ?? ?? ?? ?? 6D E6 EC DE }
	condition:
		$1
}

rule file_253_0_0 {
	meta:
		name = "sethostname"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 4A 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_254_0_0 {
	meta:
		name = "iruserfopen"
		size = 408
		refs = "001c __lxstat64 0044 __dcgettext 0064 _IO_new_fclose 00b8 _IO_new_fopen 00c4 fileno 00d4 __fxstat64 0170 _libc_intl_domainname 0178 __rcmd_errstr"
	strings:
		$1 = { 70 40 2D E9 68 D0 4D E2 00 50 A0 E1 01 60 A0 E1 0D 20 A0 E1 00 10 A0 E1 03 00 A0 E3 ?? ?? ?? ?? 00 40 50 E2 13 00 00 1A 10 30 9D E5 0F 3A 03 E2 02 09 53 E3 1D 00 00 0A 30 01 9F E5 30 11 9F E5 05 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 10 00 00 0A 20 31 9F E5 00 00 54 E3 00 00 83 E5 04 00 A0 E1 01 00 00 0A ?? ?? ?? ?? 00 00 A0 E3 68 D0 8D E2 70 40 BD E8 ?? ?? ?? ?? F0 00 9F E5 F8 10 9F E5 05 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 00 40 A0 E3 EE FF FF 1A 00 30 94 E5 04 00 A0 E1 02 39 83 E3 00 30 84 E5 68 D0 8D E2 70 40 BD E8 ?? ?? ?? ?? 05 00 A0 E1 C4 10 9F E5 ?? ?? ?? ?? 00 40 50 E2 20 00 00 0A ?? ?? ?? ?? 0D 20 A0 E1 00 10 A0 E1 03 00 A0 E3 ?? ?? ?? ?? 00 00 50 E3 1E 00 00 BA 18 30 9D E5 00 00 53 E3 06 00 00 0A 06 00 53 E1 04 00 00 0A 88 10 9F E5 05 20 A0 E3 6C 00 9F E5 ?? ?? ?? ?? CF FF FF EA 10 30 9D E5 12 00 13 E3 07 00 00 1A 14 30 9D E5 01 00 53 E3 DC FF FF 9A 60 10 9F E5 05 20 A0 E3 40 00 9F E5 ?? ?? ?? ?? C4 FF FF EA 50 10 9F E5 05 20 A0 E3 2C 00 9F E5 ?? ?? ?? ?? BF FF FF EA 40 10 9F E5 05 20 A0 E3 18 00 9F E5 ?? ?? ?? ?? BA FF FF EA 30 10 9F E5 05 20 A0 E3 04 00 9F E5 ?? ?? ?? ?? B5 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_254_1_0 {
	meta:
		name = "__validuser2_sa"
		size = 1160
		refs = "0040 __getline 006c __aeabi_read_tp 0118 strncmp 01d8 free 0288 getnameinfo 029c strcmp 02e0 getaddrinfo 0334 memcmp 0348 freeaddrinfo 0398 innetgr 0470 __libc_tsd_CTYPE_B 0474 __libc_tsd_CTYPE_TOLOWER"
	strings:
		$1 = { F0 4F 2D E9 00 C0 A0 E3 8C D0 4D E2 20 20 8D E5 1C 30 8D E5 2C C0 8D E5 30 C0 8D E5 4C 84 9F E5 4C 54 9F E5 4C 64 9F E5 00 70 A0 E1 01 B0 A0 E1 00 90 A0 E3 2C 00 8D E2 30 10 8D E2 07 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 D6 00 00 DA 2C 20 8D E2 0C 00 92 E8 03 30 82 E0 01 90 43 E5 2C 40 9D E5 00 20 D4 E5 00 00 52 E3 F1 FF FF 0A ?? ?? ?? ?? 08 30 9F E7 03 C0 90 E7 82 30 A0 E1 B3 E0 9C E1 02 EA 1E E2 E8 00 00 0A 04 10 A0 E1 01 30 F1 E5 00 00 53 E3 83 00 A0 E1 E5 FF FF 0A B0 00 9C E1 02 0A 10 E3 F8 FF FF 1A 23 00 53 E3 E0 FF FF 0A 00 00 5E E3 4C 00 00 1A 01 30 84 E2 04 00 00 EA 06 C0 9F E7 0C 00 90 E7 B1 10 90 E1 02 0A 11 E3 45 00 00 1A ?? ?? ?? ?? 05 10 9F E7 01 10 90 E7 02 21 91 E7 03 40 A0 E1 01 20 43 E5 01 20 D3 E4 00 00 52 E3 82 10 A0 E1 F0 FF FF 1A 04 C0 A0 E1 00 30 A0 E3 00 30 CC E5 2C 90 9D E5 02 20 A0 E3 64 03 9F E5 09 10 A0 E1 ?? ?? ?? ?? 00 20 50 E2 99 00 00 0A 02 20 A0 E3 50 03 9F E5 09 10 A0 E1 ?? ?? ?? ?? 00 20 50 E2 9C 00 00 0A 00 30 D9 E5 2D 00 53 E3 00 20 E0 03 01 90 89 02 18 20 8D 05 43 00 00 0A 2B 00 53 E3 3F 00 00 1A 01 30 D9 E5 00 00 53 E3 01 30 A0 13 18 30 8D 15 3C 00 00 1A 00 30 D4 E5 1C 10 9D E5 00 00 53 E3 01 40 A0 01 04 10 A0 E1 F0 02 9F E5 02 20 A0 E3 ?? ?? ?? ?? 00 10 50 E2 9F 00 00 0A 04 10 A0 E1 DC 02 9F E5 02 20 A0 E3 ?? ?? ?? ?? 00 10 50 E2 A0 00 00 0A 00 30 D4 E5 2D 00 53 E3 A3 00 00 0A 2B 00 53 E3 83 00 00 1A 01 30 D4 E5 00 00 53 E3 80 00 00 1A 00 40 A0 E3 2C 00 9D E5 ?? ?? ?? ?? 04 00 A0 E1 8C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 20 00 52 E3 09 00 52 13 C0 FF FF 1A 01 30 D4 E5 00 20 A0 E3 02 00 53 E1 00 20 C4 E5 01 90 84 E2 95 00 00 0A 6C 12 9F E5 ?? ?? ?? ?? 01 20 9F E7 02 10 90 E7 83 30 A0 E1 B3 30 91 E1 02 0A 13 E3 4A 00 00 0A 02 30 84 E2 02 00 00 EA B0 20 91 E1 02 0A 12 E3 46 00 00 0A 03 40 A0 E1 01 20 D3 E4 00 00 52 E3 82 00 A0 E1 F7 FF FF 1A A7 FF FF EA 01 10 A0 E3 18 10 8D E5 00 30 A0 E3 01 10 A0 E3 00 30 8D E5 04 30 8D E5 08 10 8D E5 58 20 8D E2 0B 00 A0 E1 20 10 9D E5 2E 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 04 00 00 1A 58 00 8D E2 09 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 55 00 00 0A 00 A0 A0 E3 B0 C0 DB E1 09 00 A0 E1 0A 10 A0 E1 38 20 8D E2 34 30 8D E2 38 A0 8D E5 40 A0 8D E5 44 A0 8D E5 48 A0 8D E5 4C A0 8D E5 50 A0 8D E5 54 A0 8D E5 3C C0 8D E5 ?? ?? ?? ?? 00 90 50 E2 36 00 00 1A 34 30 9D E5 0A 00 53 E1 14 30 8D E5 11 00 00 0A B0 C0 DB E1 24 90 8D E5 03 A0 A0 E1 0C 90 A0 E1 02 00 00 EA 1C A0 9A E5 00 00 5A E3 3A 00 00 0A 04 30 9A E5 09 00 53 E1 F9 FF FF 1A 14 00 9A E5 0B 10 A0 E1 10 20 9A E5 ?? ?? ?? ?? 00 00 50 E3 F3 FF FF 1A 18 90 9D E5 14 00 9D E5 ?? ?? ?? ?? 00 00 59 E3 14 00 00 BA 35 FF FF 0A 84 FF FF EA 09 40 A0 E1 01 30 84 E2 02 00 00 EA B0 20 91 E1 02 0A 12 E3 62 FF FF 1A 03 C0 A0 E1 01 20 D3 E4 00 00 52 E3 82 00 A0 E1 F7 FF FF 1A 5C FF FF EA 02 00 89 E2 02 30 A0 E1 B4 10 9D E5 ?? ?? ?? ?? 00 90 A0 E1 00 00 59 E3 EA FF FF AA 00 40 E0 E3 88 FF FF EA 02 00 89 E2 02 30 A0 E1 B4 10 9D E5 ?? ?? ?? ?? 00 90 60 E2 F5 FF FF EA 00 00 5A E3 17 FF FF 0A 66 FF FF EA 04 10 A0 E1 B0 00 9D E5 ?? ?? ?? ?? 01 00 70 E2 00 00 A0 33 00 00 50 E3 77 FF FF CA 00 00 50 E3 0D FF FF 0A 00 40 E0 E3 74 FF FF EA 18 90 9D E5 E5 FF FF EA 14 00 9D E5 24 90 9D E5 ?? ?? ?? ?? CC FF FF EA 02 00 84 E2 01 30 A0 E1 B0 20 9D E5 ?? ?? ?? ?? EE FF FF EA 02 30 A0 E1 1C FF FF EA 02 00 84 E2 01 30 A0 E1 B0 20 9D E5 ?? ?? ?? ?? 00 00 60 E2 E6 FF FF EA 01 00 84 E2 B0 10 9D E5 ?? ?? ?? ?? 00 00 50 E3 00 00 A0 13 00 00 E0 03 E1 FF FF EA 09 40 A0 E1 22 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_254_2_0 {
	meta:
		name = "ruserok2_sa"
		size = 400
		refs = "003c __sysconf 0064 __getpwnam_r 0094 strlen 00b4 mempcpy 00c0 memcpy 00c4 __geteuid 00d4 seteuid 0114 _IO_new_fclose"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 2C D0 4D E2 00 60 52 E2 00 80 A0 E1 01 70 A0 E1 03 90 A0 E1 04 50 9B E5 42 00 00 0A 00 40 E0 E3 54 31 9F E5 00 30 93 E5 03 30 96 E1 0D 00 00 0A 46 00 A0 E3 ?? ?? ?? ?? 0E 30 80 E2 07 30 C3 E3 03 D0 4D E0 44 20 4B E2 00 30 A0 E1 00 20 8D E5 05 00 A0 E1 08 20 8D E2 40 10 4B E2 ?? ?? ?? ?? 00 00 50 E3 03 00 00 0A 00 00 E0 E3 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 44 30 1B E5 00 00 53 E3 F8 FF FF 0A 14 A0 93 E5 0A 00 A0 E1 ?? ?? ?? ?? 17 30 80 E2 07 30 C3 E3 03 D0 4D E0 08 60 8D E2 00 20 A0 E1 0A 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? C8 10 9F E5 09 20 A0 E3 ?? ?? ?? ?? ?? ?? ?? ?? 44 30 1B E5 00 A0 A0 E1 08 00 93 E5 ?? ?? ?? ?? 44 30 1B E5 06 00 A0 E1 08 10 93 E5 3D FE FF EB 00 60 50 E2 09 00 00 0A 08 30 9B E5 00 90 8D E5 04 30 8D E5 08 10 A0 E1 07 20 A0 E1 05 30 A0 E1 9A FE FF EB 00 40 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 0A 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 54 00 9F E5 06 10 A0 E1 28 FE FF EB 00 A0 50 E2 B7 FF FF 0A 08 30 9B E5 08 10 A0 E1 04 30 8D E5 07 20 A0 E1 05 30 A0 E1 00 90 8D E5 85 FE FF EB 00 40 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 00 54 E3 04 00 A0 01 AB FF FF 1A 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_254_3_0 {
	meta:
		name = "rresvport_af"
		size = 368
		refs = "0030 __socket 0048 memset 0080 __aeabi_read_tp 00cc __bind 0118 __close 0164 __libc_errno"
	strings:
		$1 = { F0 41 2D E9 02 00 51 E3 80 D0 4D E2 01 80 A0 E1 00 40 A0 E1 3C 00 00 0A 0A 00 51 E3 31 00 00 1A 1C 70 A0 E3 08 00 A0 E1 01 10 A0 E3 00 20 A0 E3 ?? ?? ?? ?? 00 60 50 E2 46 00 00 BA 0D 00 A0 E1 00 10 A0 E3 80 20 A0 E3 ?? ?? ?? ?? 00 50 94 E5 02 0C 55 E3 02 5C A0 B3 B0 80 CD E1 00 50 84 B5 03 00 00 BA F4 30 9F E5 03 00 55 E1 00 30 84 C5 03 50 A0 C1 E8 80 9F E5 05 30 A0 E1 0B 00 00 EA ?? ?? ?? ?? 08 30 9F E7 03 30 90 E7 62 00 53 E3 1F 00 00 1A 00 30 94 E5 02 0C 53 E3 BC 30 9F 05 01 30 43 12 03 00 55 E1 00 30 84 E5 1E 00 00 0A 03 28 A0 E1 03 34 A0 E1 22 3C 83 E1 06 00 A0 E1 0D 10 A0 E1 07 20 A0 E1 B2 30 CD E1 ?? ?? ?? ?? 00 00 50 E3 E9 FF FF BA 06 00 A0 E1 80 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 78 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 61 20 A0 E3 03 20 80 E7 00 00 E0 E3 80 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 10 70 A0 E3 C3 FF FF EA 06 00 A0 E1 ?? ?? ?? ?? 00 00 E0 E3 80 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 06 00 A0 E1 ?? ?? ?? ?? 30 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 0B 20 A0 E3 03 20 80 E7 00 00 E0 E3 80 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 00 00 E0 E3 E7 FF FF EA FF 03 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_254_4_0 {
	meta:
		name = "rcmd_af"
		size = 2360
		refs = "0034 __getpid 0084 __snprintf 009c getaddrinfo 00d4 free 00e0 __strdup 0104 __sigblock 0130 rresvport_af 0144 __fcntl 0154 __connect 0164 __close 0168 __aeabi_read_tp 01b8 getnameinfo 01c8 __dcgettext 01dc __asprintf 01f4 __fxprintf 0214 perror 02f0 __sleep 0330 __sigsetmask 0338 freeaddrinfo 0388 __listen 03a4 strlen 03b4 __write 03fc __poll 044c accept 0514 __writev 0548 __read 05e8 gai_strerror 069c __strerror_r 08bc __libc_errno 08c4 _libc_intl_domainname"
	strings:
		$1 = { F0 4F 2D E9 61 DF 4D E2 02 CC 8D E2 B0 55 5C E1 0A 00 55 E3 18 00 8D E5 01 40 A0 E1 1C 20 8D E5 20 30 8D E5 02 00 00 0A 02 30 C5 E3 00 00 53 E3 AD 01 00 1A ?? ?? ?? ?? 04 34 A0 E1 24 44 83 E1 04 38 A0 E1 02 C0 A0 E3 00 40 A0 E3 23 38 A0 E1 08 10 A0 E3 4C 28 9F E5 00 90 A0 E1 01 60 A0 E3 38 00 8D E2 68 C0 8D E5 6C 50 8D E5 74 40 8D E5 78 40 8D E5 7C 40 8D E5 80 40 8D E5 84 40 8D E5 70 60 8D E5 ?? ?? ?? ?? 18 30 9D E5 38 10 8D E2 00 00 93 E5 68 20 8D E2 28 30 8D E2 ?? ?? ?? ?? 00 00 50 E3 77 00 00 1A 28 40 9D E5 18 30 94 E5 F4 17 9F E5 F4 27 9F E5 06 0D 8D E2 00 00 53 E3 B1 60 80 E1 B2 60 80 E1 4F 01 00 0A E0 57 9F E5 00 00 95 E5 ?? ?? ?? ?? 28 30 9D E5 18 00 93 E5 ?? ?? ?? ?? 00 00 50 E3 00 40 A0 E1 00 00 85 E5 D2 01 00 0A 18 10 9D E5 28 40 9D E5 00 00 81 E5 01 05 A0 E3 ?? ?? ?? ?? A8 37 9F E5 06 8D 8D E2 54 31 28 E5 01 30 A0 E3 24 00 8D E5 98 A7 9F E5 14 30 8D E5 00 60 A0 E3 08 00 A0 E1 B4 10 D4 E1 ?? ?? ?? ?? 00 50 50 E2 72 00 00 BA 08 10 A0 E3 09 20 A0 E1 ?? ?? ?? ?? 05 00 A0 E1 14 10 94 E5 10 20 94 E5 ?? ?? ?? ?? 00 00 50 E3 7A 00 00 AA 05 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 0A 30 9F E7 03 50 90 E7 62 00 55 E3 4F 00 00 0A 1C 30 94 E5 6F 00 55 E3 01 60 A0 03 00 00 53 E3 4E 00 00 0A 00 70 A0 E3 B8 70 8D E5 01 30 A0 E3 10 10 94 E5 14 00 94 E5 88 20 8D E2 08 30 8D E5 00 70 8D E5 2E 30 A0 E3 04 70 8D E5 ?? ?? ?? ?? FC 16 9F E5 05 20 A0 E3 F8 06 9F E5 ?? ?? ?? ?? B8 B0 8D E2 00 10 A0 E1 88 20 8D E2 0B 00 A0 E1 ?? ?? ?? ?? 07 00 50 E1 05 00 00 BA 07 00 A0 E1 D4 16 9F E5 B8 20 9D E5 ?? ?? ?? ?? B8 00 9D E5 ?? ?? ?? ?? C4 C6 9F E5 0C 30 9F E7 ?? ?? ?? ?? 03 50 80 E7 00 00 A0 E3 ?? ?? ?? ?? 1C 40 94 E5 00 50 A0 E3 01 30 A0 E3 10 10 94 E5 14 00 94 E5 88 20 8D E2 08 30 8D E5 00 50 8D E5 2E 30 A0 E3 04 50 8D E5 ?? ?? ?? ?? 84 16 9F E5 05 20 A0 E3 70 06 9F E5 ?? ?? ?? ?? 88 20 8D E2 00 10 A0 E1 0B 00 A0 E1 ?? ?? ?? ?? 05 00 50 E1 AE FF FF BA 05 00 A0 E1 50 16 9F E5 B8 20 9D E5 ?? ?? ?? ?? B8 00 9D E5 ?? ?? ?? ?? A7 FF FF EA 02 00 70 E3 D5 00 00 1A 18 C0 9D E5 00 20 9C E5 04 00 52 E1 D1 00 00 0A 04 00 A0 E1 28 16 9F E5 ?? ?? ?? ?? 00 00 E0 E3 61 DF 8D E2 F0 4F BD E8 ?? ?? ?? ?? 2C 30 9D E5 01 30 43 E2 2C 30 8D E5 96 FF FF EA 14 10 9D E5 00 60 96 E2 01 60 A0 13 10 00 51 E3 00 60 A0 C3 00 00 56 E3 E2 00 00 0A 01 00 A0 E1 03 60 A0 E1 ?? ?? ?? ?? 14 20 9D E5 82 20 A0 E1 14 20 8D E5 28 40 9D E5 87 FF FF EA C8 35 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 0B 00 53 E3 99 00 00 0A 00 00 A0 E3 B0 15 9F E5 ?? ?? ?? ?? 24 00 9D E5 ?? ?? ?? ?? 28 00 9D E5 ?? ?? ?? ?? 00 00 E0 E3 61 DF 8D E2 F0 4F BD E8 ?? ?? ?? ?? 2C 30 9D E5 AC 01 9D E5 01 30 43 E2 00 00 50 E3 2C 30 8D E5 D8 00 00 0A 08 00 A0 E1 B4 10 D4 E1 ?? ?? ?? ?? 10 30 94 E5 00 70 50 E2 30 30 8D E5 B9 00 00 BA 50 60 8D E2 01 10 A0 E3 ?? ?? ?? ?? 2C 30 9D E5 08 10 A0 E3 0C 25 9F E5 06 00 A0 E1 ?? ?? ?? ?? 06 00 A0 E1 ?? ?? ?? ?? 06 10 A0 E1 01 20 80 E2 05 00 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 01 00 80 E2 00 00 54 E1 CD 00 00 1A 40 50 8D E5 48 70 8D E5 00 35 9F E5 ?? ?? ?? ?? 00 C0 A0 E1 03 30 9F E7 00 E0 A0 E3 40 00 8D E2 02 10 A0 E3 00 20 E0 E3 03 E0 8C E7 ?? ?? ?? ?? 00 00 50 E3 D4 00 00 DA D4 34 9F E5 06 2D 8D E2 B3 30 92 E1 01 00 13 E3 CF 00 00 0A C4 94 9F E5 B8 80 8D E2 30 40 8D E2 04 00 00 EA ?? ?? ?? ?? 09 30 9F E7 03 30 90 E7 04 00 53 E3 06 00 00 1A 07 00 A0 E1 08 10 A0 E1 04 20 A0 E1 ?? ?? ?? ?? 01 00 70 E3 00 A0 A0 E1 F3 FF FF 0A B8 3B DD E1 02 00 53 E3 01 00 00 0A 0A 00 53 E3 93 00 00 1A BA 3B DD E1 03 24 A0 E1 23 34 82 E1 03 88 A0 E1 28 88 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 00 5A E3 E4 00 00 BA 50 34 9F E5 02 8C 48 E2 08 88 A0 E1 28 08 53 E1 AC 31 9D E5 00 A0 83 E5 BF 00 00 3A 1C 00 9D E5 50 00 8D E5 ?? ?? ?? ?? 01 30 80 E2 20 00 9D E5 54 30 8D E5 58 00 8D E5 ?? ?? ?? ?? 01 30 80 E2 A8 01 9D E5 5C 30 8D E5 60 00 8D E5 ?? ?? ?? ?? 01 00 80 E2 64 00 8D E5 FC 73 9F E5 04 00 00 EA ?? ?? ?? ?? 07 30 9F E7 03 30 90 E7 04 00 53 E3 05 00 00 1A 05 00 A0 E1 06 10 A0 E1 03 20 A0 E3 ?? ?? ?? ?? 01 00 70 E3 F4 FF FF 0A CC 63 9F E5 04 00 00 EA ?? ?? ?? ?? 06 30 9F E7 03 30 90 E7 04 00 53 E3 36 00 00 1A 05 00 A0 E1 04 10 A0 E1 01 20 A0 E3 ?? ?? ?? ?? 01 00 70 E3 F4 FF FF 0A 01 00 50 E3 C2 00 00 1A 30 30 DD E5 00 00 53 E3 14 00 00 1A 24 00 9D E5 ?? ?? ?? ?? 28 00 9D E5 ?? ?? ?? ?? 05 00 A0 E1 61 DF 8D E2 F0 4F BD E8 ?? ?? ?? ?? 68 13 9F E5 05 20 A0 E3 2C 03 9F E5 ?? ?? ?? ?? 28 13 9F E5 00 20 A0 E1 00 00 A0 E3 ?? ?? ?? ?? 5F FF FF EA ?? ?? ?? ?? 30 30 DD E5 0A 00 53 E3 25 00 00 0A 04 10 A0 E1 01 20 A0 E3 05 00 A0 E1 ?? ?? ?? ?? 00 30 A0 E1 01 00 53 E3 04 10 A0 E1 02 00 A0 E3 03 20 A0 E1 F1 FF FF 0A 1A 00 00 EA ?? ?? ?? ?? 08 13 9F E5 00 20 A0 E1 00 00 A0 E3 ?? ?? ?? ?? 00 00 E0 E3 61 DF 8D E2 F0 4F BD E8 ?? ?? ?? ?? 18 20 9D E5 00 30 82 E5 B9 FE FF EA 00 30 A0 E3 34 30 8D E5 18 00 9D E5 D4 12 9F E5 00 20 90 E5 34 00 8D E2 ?? ?? ?? ?? 00 00 50 E3 05 00 00 BA 00 00 A0 E3 80 12 9F E5 34 20 9D E5 ?? ?? ?? ?? 34 00 9D E5 ?? ?? ?? ?? 2C 30 9D E5 00 00 53 E3 AC C1 9D 15 00 00 9C 15 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? 2D FF FF EA 00 70 A0 E1 28 00 9D E5 ?? ?? ?? ?? 7C 32 9F E5 18 C0 9D E5 03 30 9F E7 03 00 97 E7 B8 10 8D E2 C8 20 A0 E3 00 40 9C E5 ?? ?? ?? ?? 04 20 A0 E1 00 30 A0 E1 58 12 9F E5 06 00 A0 E1 ?? ?? ?? ?? 24 00 9D E5 ?? ?? ?? ?? 1E FF FF EA 00 80 A0 E3 6E FF FF EA 3C 12 9F E5 05 00 A0 E1 01 20 A0 E3 ?? ?? ?? ?? AC 11 9D E5 50 60 8D E2 2C 10 8D E5 30 40 8D E2 70 FF FF EA 1C 32 9F E5 ?? ?? ?? ?? 03 30 9F E7 61 20 A0 E3 03 20 80 E7 00 00 E0 E3 E9 FE FF EA 00 60 A0 E3 06 4D 8D E2 FC 11 9F E5 05 20 A0 E3 A4 01 9F E5 C8 60 24 E5 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 06 00 50 E1 06 00 A0 A1 04 00 00 BA 84 11 9F E5 B8 20 9D E5 ?? ?? ?? ?? B8 00 9D E5 ?? ?? ?? ?? 07 00 A0 E1 ?? ?? ?? ?? C2 FF FF EA 00 30 A0 E3 B8 30 8D E5 AC 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 00 00 53 E3 00 40 A0 E1 19 00 00 1A B8 80 8D E2 90 11 9F E5 05 20 A0 E3 30 01 9F E5 ?? ?? ?? ?? 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 E9 FF FF BA 00 00 A0 E3 E2 FF FF EA 00 60 A0 E3 06 4D 8D E2 60 11 9F E5 05 20 A0 E3 FC 00 9F E5 4C 61 24 E5 ?? ?? ?? ?? 00 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 06 00 50 E1 06 00 A0 A1 96 FF FF AA 9A FF FF EA 34 11 9F E5 05 20 A0 E3 CC 00 9F E5 ?? ?? ?? ?? B8 80 8D E2 00 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 E5 FF FF AA 10 31 9F E5 03 30 9F E7 03 30 94 E7 00 00 53 E3 CA FF FF 1A D6 FF FF EA 00 00 A0 E3 F8 10 9F E5 ?? ?? ?? ?? 00 30 A0 E3 2C 30 8D E5 89 FF FF EA E8 10 9F E5 05 20 A0 E3 74 00 9F E5 ?? ?? ?? ?? 70 10 9F E5 00 20 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 00 E0 E3 91 FE FF EA 00 30 A0 E3 00 00 50 E3 34 30 8D E5 69 FF FF 1A B4 10 9F E5 05 20 A0 E3 3C 00 9F E5 ?? ?? ?? ?? 18 30 9D E5 00 10 A0 E1 00 20 93 E5 34 00 8D E2 ?? ?? ?? ?? 00 00 50 E3 65 FF FF AA 6A FF FF EA ?? ?? ?? ?? C4 FE FF FF CC FE FF FF ?? ?? ?? ?? FF 03 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? CE FE FF FF ?? ?? ?? ?? FF 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_254_5_0 {
	meta:
		name = "rcmd"
		size = 44
		refs = "001c rcmd_af"
	strings:
		$1 = { 10 40 2D E9 10 D0 4D E2 18 40 8D E2 10 40 94 E8 02 C0 A0 E3 10 40 8D E8 08 C0 8D E5 ?? ?? ?? ?? 10 D0 8D E2 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_331_1_0 {
	meta:
		name = "rexec"
		size = 44
		refs = "001c rexec_af"
	strings:
		$1 = { 10 40 2D E9 10 D0 4D E2 18 40 8D E2 10 40 94 E8 02 C0 A0 E3 10 40 8D E8 08 C0 8D E5 ?? ?? ?? ?? 10 D0 8D E2 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_254_7_0 {
	meta:
		name = "ruserok_af"
		size = 212
		refs = "004c getaddrinfo 00a0 freeaddrinfo"
	strings:
		$1 = { F0 41 2D E9 30 D0 4D E2 00 C0 A0 E3 B8 E4 DD E1 01 60 A0 E1 02 70 A0 E1 03 80 A0 E1 0C 10 A0 E1 10 20 8D E2 0C 30 8D E2 14 E0 8D E5 10 C0 8D E5 18 C0 8D E5 1C C0 8D E5 20 C0 8D E5 24 C0 8D E5 28 C0 8D E5 2C C0 8D E5 00 50 A0 E1 ?? ?? ?? ?? 00 00 50 E3 1C 00 00 1A 0C 40 9D E5 00 00 54 E3 03 00 00 1A 15 00 00 EA 1C 40 94 E5 00 00 54 E3 0F 00 00 0A 14 00 94 E5 10 10 94 E5 06 20 A0 E1 00 80 8D E5 04 50 8D E5 07 30 A0 E1 C0 FC FF EB 00 00 50 E3 F3 FF FF 1A 00 50 A0 E1 0C 00 9D E5 ?? ?? ?? ?? 05 00 A0 E1 30 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 0C 00 9D E5 00 50 E0 E3 F7 FF FF EA 04 00 A0 E1 00 50 E0 E3 F4 FF FF EA 00 00 E0 E3 F4 FF FF EA }
	condition:
		$1
}

rule file_254_8_0 {
	meta:
		name = "ruserok"
		size = 32
		refs = "0010 ruserok_af"
	strings:
		$1 = { 04 E0 2D E5 02 C0 A0 E3 0C D0 4D E2 00 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_254_9_0 {
	meta:
		name = "iruserok_af"
		size = 172
		refs = "0028 memset 004c memcpy"
	strings:
		$1 = { F0 41 2D E9 88 D0 4D E2 B0 4A DD E1 00 80 A0 E1 01 60 A0 E1 02 50 A0 E1 08 00 8D E2 00 10 A0 E3 80 20 A0 E3 03 70 A0 E1 ?? ?? ?? ?? 02 00 54 E3 15 00 00 0A 0A 00 54 E3 0F 00 00 1A 08 10 A0 E1 10 00 8D E2 10 20 A0 E3 B8 40 CD E1 ?? ?? ?? ?? 1C 10 A0 E3 4C C0 9F E5 00 70 8D E5 08 00 8D E2 06 20 A0 E1 05 30 A0 E1 04 C0 8D E5 8B FC FF EB 88 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 00 00 A0 E3 88 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 08 10 A0 E1 0C 00 8D E2 04 20 A0 E3 B8 40 CD E1 ?? ?? ?? ?? 10 10 A0 E3 EA FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_254_10_0 {
	meta:
		name = "iruserok"
		size = 44
		refs = "001c iruserok_af"
	strings:
		$1 = { 04 E0 2D E5 14 D0 4D E2 10 C0 8D E2 04 00 2C E5 02 E0 A0 E3 0C 00 A0 E1 00 E0 8D E5 ?? ?? ?? ?? 14 D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_254_11_0 {
	meta:
		name = "__ivaliduser"
		size = 80
	strings:
		$1 = { 04 E0 2D E5 40 E0 9F E5 1C D0 4D E2 00 C0 A0 E3 0C 10 8D E5 00 30 8D E5 04 E0 8D E5 02 30 A0 E1 02 E0 A0 E3 08 10 8D E2 10 20 A0 E3 08 C0 8D E5 10 C0 8D E5 14 C0 8D E5 B8 E0 CD E1 3F FB FF EB 1C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_255_0_0 {
	meta:
		name = "__hdestroy"
		size = 24
		refs = "0008 hdestroy_r"
	strings:
		$1 = { 08 40 2D E9 08 00 9F E5 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_255_1_0 {
	meta:
		name = "hsearch"
		size = 56
		refs = "0020 hsearch_r"
	strings:
		$1 = { 04 E0 2D E5 1C D0 4D E2 08 30 8D E2 03 00 83 E8 1C C0 9F E5 03 00 93 E8 00 C0 8D E5 14 30 8D E2 ?? ?? ?? ?? 14 00 9D E5 1C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_255_2_0 {
	meta:
		name = "hcreate"
		size = 24
		refs = "0008 hcreate_r"
	strings:
		$1 = { 08 40 2D E9 08 10 9F E5 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_718_0_0 {
	meta:
		name = "ether_aton"
		size = 24
		refs = "0008 ether_aton_r"
	strings:
		$1 = { 08 40 2D E9 08 10 9F E5 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1363_0_0 {
	meta:
		name = "ether_ntoa"
		size = 24
		refs = "0008 ether_ntoa_r"
	strings:
		$1 = { 08 40 2D E9 08 10 9F E5 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_395_0_0 {
	meta:
		name = "lcong48"
		size = 24
		refs = "0008 __lcong48_r 0014 __libc_drand48_data"
	strings:
		$1 = { 08 40 2D E9 08 10 9F E5 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1295_0_0 {
	meta:
		name = "srand48"
		size = 24
		refs = "0008 __srand48_r 0014 __libc_drand48_data"
	strings:
		$1 = { 08 40 2D E9 08 10 9F E5 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_256_0_0 {
	meta:
		name = "psiginfo"
		size = 1040
		refs = "001c fmemopen 0060 __dcgettext 0070 fprintf 018c _IO_new_fclose 0194 strlen 0234 __fxprintf 027c __libc_current_sigrtmin 028c __libc_current_sigrtmax 0360 fwrite 038c __aeabi_read_tp 039c _sys_siglist 03a0 _libc_intl_domainname 040c __libc_errno"
	strings:
		$1 = { F0 40 2D E9 83 DF 4D E2 00 40 A0 E1 01 60 A0 E1 08 00 8D E2 02 1C A0 E3 78 23 9F E5 ?? ?? ?? ?? 00 50 50 E2 77 00 00 0A 00 00 56 E3 02 00 00 0A 00 30 D6 E5 00 00 53 E3 60 00 00 1A 00 60 94 E5 40 00 56 E3 47 00 00 8A 4C 33 9F E5 06 11 93 E7 00 00 51 E3 88 00 00 0A 05 20 A0 E3 3C 03 9F E5 ?? ?? ?? ?? 38 13 9F E5 00 20 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 30 94 E5 04 30 43 E2 19 00 53 E3 0F 00 00 9A 08 20 94 E5 03 00 72 E3 A1 00 00 0A 4E 00 00 DA 01 00 72 E3 A2 00 00 0A 9F 00 00 BA 00 00 52 E3 97 00 00 0A 80 00 52 E3 F4 12 9F 05 13 00 00 0A 05 00 A0 E1 EC 12 9F E5 ?? ?? ?? ?? 16 00 00 EA E4 12 9F E5 03 21 81 E0 68 00 92 E5 00 00 50 E3 03 11 91 E7 D0 30 92 E5 E8 FF FF 0A 08 20 94 E5 00 00 52 E3 E6 FF FF DA 03 00 52 E1 E4 FF FF 8A 02 00 80 E0 01 30 50 E5 03 10 91 E0 EB FF FF 0A 05 20 A0 E3 90 02 9F E5 ?? ?? ?? ?? 9C 12 9F E5 00 20 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 30 94 E5 04 00 53 E3 31 00 00 0A 0B 00 53 E3 2F 00 00 0A 07 20 43 E2 01 00 52 E3 2C 00 00 9A 11 00 53 E3 79 00 00 0A 1D 00 53 E3 3F 00 00 0A 0C 20 84 E2 05 00 A0 E1 58 12 9F E5 0C 00 92 E8 ?? ?? ?? ?? 07 00 00 EA 4C 12 9F E5 05 20 A0 E3 28 02 9F E5 ?? ?? ?? ?? 00 20 94 E5 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? 08 00 8D E2 ?? ?? ?? ?? 04 70 A0 E3 00 20 A0 E1 08 10 8D E2 02 00 A0 E3 00 00 00 EF 01 0A 70 E3 72 00 00 8A 83 DF 8D E2 F0 40 BD E8 ?? ?? ?? ?? 06 20 A0 E1 F4 11 9F E5 ?? ?? ?? ?? 9A FF FF EA 06 00 72 E3 4D 00 00 0A 23 00 00 DA 05 00 72 E3 1F 00 00 0A 04 00 72 E3 D4 11 9F 05 C4 FF FF 0A AF FF FF EA 0C 20 94 E5 05 00 A0 E1 C4 11 9F E5 ?? ?? ?? ?? DF FF FF EA 00 00 56 E3 0C 00 00 0A 00 30 D6 E5 00 00 53 E3 09 00 00 0A A8 31 9F E5 00 10 94 E5 06 20 A0 E1 00 10 8D E5 00 00 A0 E3 98 11 9F E5 ?? ?? ?? ?? 83 DF 8D E2 F0 40 BD E8 ?? ?? ?? ?? 88 31 9F E5 03 60 A0 E1 F3 FF FF EA 0C 20 94 E5 05 00 A0 E1 78 11 9F E5 ?? ?? ?? ?? C8 FF FF EA 70 11 9F E5 A5 FF FF EA 3C 00 72 E3 68 11 9F 05 A2 FF FF 0A 8D FF FF EA ?? ?? ?? ?? 00 00 56 E1 B7 FF FF BA 00 60 94 E5 ?? ?? ?? ?? 00 00 56 E1 B3 FF FF AA 00 70 94 E5 ?? ?? ?? ?? 07 70 60 E0 ?? ?? ?? ?? 00 60 94 E5 00 00 66 E0 00 00 57 E1 09 00 00 AA ?? ?? ?? ?? 00 00 56 E1 28 00 00 0A 00 60 94 E5 ?? ?? ?? ?? 10 11 9F E5 06 20 60 E0 05 00 A0 E1 ?? ?? ?? ?? 64 FF FF EA ?? ?? ?? ?? 00 00 56 E1 18 00 00 0A ?? ?? ?? ?? 00 20 94 E5 EC 10 9F E5 00 20 62 E0 05 00 A0 E1 ?? ?? ?? ?? 5A FF FF EA DC 10 9F E5 7C FF FF EA D8 10 9F E5 7A FF FF EA D4 10 9F E5 78 FF FF EA D0 10 9F E5 76 FF FF EA CC 10 9F E5 74 FF FF EA 10 10 84 E2 0A 00 91 E8 0C 20 94 E5 05 00 A0 E1 00 10 8D E5 B4 10 9F E5 ?? ?? ?? ?? 8D FF FF EA 01 10 A0 E3 0A 20 A0 E3 05 30 A0 E1 A0 00 9F E5 ?? ?? ?? ?? 42 FF FF EA 01 10 A0 E3 0A 20 A0 E3 05 30 A0 E1 8C 00 9F E5 ?? ?? ?? ?? 3C FF FF EA 84 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 86 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_257_0_0 {
	meta:
		name = "__strndup"
		size = 68
		refs = "0008 __strnlen 0014 malloc 0030 memcpy"
	strings:
		$1 = { 38 40 2D E9 00 50 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 00 80 E2 ?? ?? ?? ?? 00 30 50 E2 06 00 00 0A 00 20 A0 E3 04 20 C3 E7 05 10 A0 E1 04 20 A0 E1 ?? ?? ?? ?? 38 40 BD E8 ?? ?? ?? ?? 03 00 A0 E1 FB FF FF EA }
	condition:
		$1
}

rule file_258_0_0 {
	meta:
		name = "__libc_init_first"
		size = 164
		refs = "003c __setfpucw 0058 __libc_init_secure 005c _dl_non_dynamic_init 006c __init_misc 0070 __ctype_init 008c _dl_starting_up 0090 __fpu_control 0098 __environ 009c __libc_argc 00a0 __libc_argv"
	strings:
		$1 = { 84 30 9F E5 00 00 53 E3 70 40 2D E9 00 40 A0 E1 01 50 A0 E1 02 60 A0 E1 02 00 00 0A 00 30 93 E5 00 00 53 E3 14 00 00 0A 60 20 9F E5 60 30 9F E5 00 00 92 E5 00 20 A0 E3 00 20 83 E5 ?? ?? ?? ?? 50 30 9F E5 50 10 9F E5 50 20 9F E5 00 60 83 E5 00 40 81 E5 00 50 82 E5 ?? ?? ?? ?? ?? ?? ?? ?? 04 00 A0 E1 05 10 A0 E1 06 20 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? 70 40 BD E8 ?? ?? ?? ?? 10 30 9F E5 01 20 A0 E3 00 20 83 E5 EC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_259_0_0 {
	meta:
		name = "getspnam"
		size = 444
		refs = "0088 __getspnam_r 00ac realloc 00c4 free 00d4 __aeabi_read_tp 0160 malloc 0180 __lll_lock_wait_private 01b8 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 01 10 A0 E3 1C D0 4D E2 00 80 A0 E1 94 21 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 4D 00 00 1A 64 71 9F E5 00 20 97 E5 58 11 9F E5 00 00 52 E3 0C 10 8D E5 04 30 91 15 3C 00 00 0A 14 90 8D E2 40 61 9F E5 40 B1 9F E5 02 00 00 EA 00 50 8B E5 05 20 A0 E1 04 30 A0 E1 00 90 8D E5 08 00 A0 E1 28 11 9F E5 ?? ?? ?? ?? 22 00 50 E3 2B 00 00 1A 04 40 96 E5 00 A0 97 E5 84 40 A0 E1 04 10 A0 E1 0A 00 A0 E1 04 40 86 E5 ?? ?? ?? ?? 00 50 50 E2 F4 20 9F E5 EC FF FF 1A 0A 00 A0 E1 08 20 8D E5 ?? ?? ?? ?? E8 30 9F E5 08 20 9D E5 03 30 9F E7 ?? ?? ?? ?? 0C 10 A0 E3 00 50 82 E5 03 10 80 E7 00 30 A0 E3 14 30 8D E5 0C 30 9D E5 00 50 93 E5 00 10 A0 E3 05 40 A0 E1 A8 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 EF FF FF 1A 01 00 55 E3 14 00 00 CA 14 00 9D E5 1C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 30 97 E5 00 00 53 E3 E6 FF FF 1A E3 FF FF EA 01 4B A0 E3 04 00 A0 E1 04 40 81 E5 ?? ?? ?? ?? 00 00 50 E3 00 00 87 E5 DC FF FF 0A 00 20 A0 E1 04 30 A0 E1 B8 FF FF EA 02 00 A0 E1 ?? ?? ?? ?? AE FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF E1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1357_0_0 {
	meta:
		name = "getaliasbyname"
		size = 444
		refs = "0088 __getaliasbyname_r 00ac realloc 00c4 free 00d4 __aeabi_read_tp 0160 malloc 0180 __lll_lock_wait_private 01b8 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 01 10 A0 E3 1C D0 4D E2 00 80 A0 E1 94 21 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 4D 00 00 1A 64 71 9F E5 00 20 97 E5 58 11 9F E5 00 00 52 E3 0C 10 8D E5 04 30 91 15 3C 00 00 0A 14 90 8D E2 40 61 9F E5 40 B1 9F E5 02 00 00 EA 00 50 8B E5 05 20 A0 E1 04 30 A0 E1 00 90 8D E5 08 00 A0 E1 28 11 9F E5 ?? ?? ?? ?? 22 00 50 E3 2B 00 00 1A 04 40 96 E5 00 A0 97 E5 84 40 A0 E1 04 10 A0 E1 0A 00 A0 E1 04 40 86 E5 ?? ?? ?? ?? 00 50 50 E2 F4 20 9F E5 EC FF FF 1A 0A 00 A0 E1 08 20 8D E5 ?? ?? ?? ?? E8 30 9F E5 08 20 9D E5 03 30 9F E7 ?? ?? ?? ?? 0C 10 A0 E3 00 50 82 E5 03 10 80 E7 00 30 A0 E3 14 30 8D E5 0C 30 9D E5 00 50 93 E5 00 10 A0 E3 05 40 A0 E1 A8 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 EF FF FF 1A 01 00 55 E3 14 00 00 CA 14 00 9D E5 1C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 30 97 E5 00 00 53 E3 E6 FF FF 1A E3 FF FF EA 01 4B A0 E3 04 00 A0 E1 04 40 81 E5 ?? ?? ?? ?? 00 00 50 E3 00 00 87 E5 DC FF FF 0A 00 20 A0 E1 04 30 A0 E1 B8 FF FF EA 02 00 A0 E1 ?? ?? ?? ?? AE FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF E1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1035_0_0 {
	meta:
		name = "getgrgid"
		size = 444
		refs = "0088 __getgrgid_r 00ac realloc 00c4 free 00d4 __aeabi_read_tp 0160 malloc 0180 __lll_lock_wait_private 01b8 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 01 10 A0 E3 1C D0 4D E2 00 80 A0 E1 94 21 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 4D 00 00 1A 64 71 9F E5 00 20 97 E5 58 11 9F E5 00 00 52 E3 0C 10 8D E5 04 30 91 15 3C 00 00 0A 14 90 8D E2 40 61 9F E5 40 B1 9F E5 02 00 00 EA 00 50 8B E5 05 20 A0 E1 04 30 A0 E1 00 90 8D E5 08 00 A0 E1 28 11 9F E5 ?? ?? ?? ?? 22 00 50 E3 2B 00 00 1A 04 40 96 E5 00 A0 97 E5 84 40 A0 E1 04 10 A0 E1 0A 00 A0 E1 04 40 86 E5 ?? ?? ?? ?? 00 50 50 E2 F4 20 9F E5 EC FF FF 1A 0A 00 A0 E1 08 20 8D E5 ?? ?? ?? ?? E8 30 9F E5 08 20 9D E5 03 30 9F E7 ?? ?? ?? ?? 0C 10 A0 E3 00 50 82 E5 03 10 80 E7 00 30 A0 E3 14 30 8D E5 0C 30 9D E5 00 50 93 E5 00 10 A0 E3 05 40 A0 E1 A8 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 EF FF FF 1A 01 00 55 E3 14 00 00 CA 14 00 9D E5 1C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 30 97 E5 00 00 53 E3 E6 FF FF 1A E3 FF FF EA 01 4B A0 E3 04 00 A0 E1 04 40 81 E5 ?? ?? ?? ?? 00 00 50 E3 00 00 87 E5 DC FF FF 0A 00 20 A0 E1 04 30 A0 E1 B8 FF FF EA 02 00 A0 E1 ?? ?? ?? ?? AE FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF E1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_523_0_0 {
	meta:
		name = "getgrnam"
		size = 444
		refs = "0088 __getgrnam_r 00ac realloc 00c4 free 00d4 __aeabi_read_tp 0160 malloc 0180 __lll_lock_wait_private 01b8 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 01 10 A0 E3 1C D0 4D E2 00 80 A0 E1 94 21 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 4D 00 00 1A 64 71 9F E5 00 20 97 E5 58 11 9F E5 00 00 52 E3 0C 10 8D E5 04 30 91 15 3C 00 00 0A 14 90 8D E2 40 61 9F E5 40 B1 9F E5 02 00 00 EA 00 50 8B E5 05 20 A0 E1 04 30 A0 E1 00 90 8D E5 08 00 A0 E1 28 11 9F E5 ?? ?? ?? ?? 22 00 50 E3 2B 00 00 1A 04 40 96 E5 00 A0 97 E5 84 40 A0 E1 04 10 A0 E1 0A 00 A0 E1 04 40 86 E5 ?? ?? ?? ?? 00 50 50 E2 F4 20 9F E5 EC FF FF 1A 0A 00 A0 E1 08 20 8D E5 ?? ?? ?? ?? E8 30 9F E5 08 20 9D E5 03 30 9F E7 ?? ?? ?? ?? 0C 10 A0 E3 00 50 82 E5 03 10 80 E7 00 30 A0 E3 14 30 8D E5 0C 30 9D E5 00 50 93 E5 00 10 A0 E3 05 40 A0 E1 A8 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 EF FF FF 1A 01 00 55 E3 14 00 00 CA 14 00 9D E5 1C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 30 97 E5 00 00 53 E3 E6 FF FF 1A E3 FF FF EA 01 4B A0 E3 04 00 A0 E1 04 40 81 E5 ?? ?? ?? ?? 00 00 50 E3 00 00 87 E5 DC FF FF 0A 00 20 A0 E1 04 30 A0 E1 B8 FF FF EA 02 00 A0 E1 ?? ?? ?? ?? AE FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF E1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_441_0_0 {
	meta:
		name = "getprotobyname"
		size = 444
		refs = "0088 __getprotobyname_r 00ac realloc 00c4 free 00d4 __aeabi_read_tp 0160 malloc 0180 __lll_lock_wait_private 01b8 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 01 10 A0 E3 1C D0 4D E2 00 80 A0 E1 94 21 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 4D 00 00 1A 64 71 9F E5 00 20 97 E5 58 11 9F E5 00 00 52 E3 0C 10 8D E5 04 30 91 15 3C 00 00 0A 14 90 8D E2 40 61 9F E5 40 B1 9F E5 02 00 00 EA 00 50 8B E5 05 20 A0 E1 04 30 A0 E1 00 90 8D E5 08 00 A0 E1 28 11 9F E5 ?? ?? ?? ?? 22 00 50 E3 2B 00 00 1A 04 40 96 E5 00 A0 97 E5 84 40 A0 E1 04 10 A0 E1 0A 00 A0 E1 04 40 86 E5 ?? ?? ?? ?? 00 50 50 E2 F4 20 9F E5 EC FF FF 1A 0A 00 A0 E1 08 20 8D E5 ?? ?? ?? ?? E8 30 9F E5 08 20 9D E5 03 30 9F E7 ?? ?? ?? ?? 0C 10 A0 E3 00 50 82 E5 03 10 80 E7 00 30 A0 E3 14 30 8D E5 0C 30 9D E5 00 50 93 E5 00 10 A0 E3 05 40 A0 E1 A8 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 EF FF FF 1A 01 00 55 E3 14 00 00 CA 14 00 9D E5 1C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 30 97 E5 00 00 53 E3 E6 FF FF 1A E3 FF FF EA 01 4B A0 E3 04 00 A0 E1 04 40 81 E5 ?? ?? ?? ?? 00 00 50 E3 00 00 87 E5 DC FF FF 0A 00 20 A0 E1 04 30 A0 E1 B8 FF FF EA 02 00 A0 E1 ?? ?? ?? ?? AE FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF E1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1458_0_0 {
	meta:
		name = "getprotobynumber"
		size = 444
		refs = "0088 __getprotobynumber_r 00ac realloc 00c4 free 00d4 __aeabi_read_tp 0160 malloc 0180 __lll_lock_wait_private 01b8 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 01 10 A0 E3 1C D0 4D E2 00 80 A0 E1 94 21 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 4D 00 00 1A 64 71 9F E5 00 20 97 E5 58 11 9F E5 00 00 52 E3 0C 10 8D E5 04 30 91 15 3C 00 00 0A 14 90 8D E2 40 61 9F E5 40 B1 9F E5 02 00 00 EA 00 50 8B E5 05 20 A0 E1 04 30 A0 E1 00 90 8D E5 08 00 A0 E1 28 11 9F E5 ?? ?? ?? ?? 22 00 50 E3 2B 00 00 1A 04 40 96 E5 00 A0 97 E5 84 40 A0 E1 04 10 A0 E1 0A 00 A0 E1 04 40 86 E5 ?? ?? ?? ?? 00 50 50 E2 F4 20 9F E5 EC FF FF 1A 0A 00 A0 E1 08 20 8D E5 ?? ?? ?? ?? E8 30 9F E5 08 20 9D E5 03 30 9F E7 ?? ?? ?? ?? 0C 10 A0 E3 00 50 82 E5 03 10 80 E7 00 30 A0 E3 14 30 8D E5 0C 30 9D E5 00 50 93 E5 00 10 A0 E3 05 40 A0 E1 A8 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 EF FF FF 1A 01 00 55 E3 14 00 00 CA 14 00 9D E5 1C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 30 97 E5 00 00 53 E3 E6 FF FF 1A E3 FF FF EA 01 4B A0 E3 04 00 A0 E1 04 40 81 E5 ?? ?? ?? ?? 00 00 50 E3 00 00 87 E5 DC FF FF 0A 00 20 A0 E1 04 30 A0 E1 B8 FF FF EA 02 00 A0 E1 ?? ?? ?? ?? AE FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF E1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_307_0_0 {
	meta:
		name = "getpwnam"
		size = 444
		refs = "0088 __getpwnam_r 00ac realloc 00c4 free 00d4 __aeabi_read_tp 0160 malloc 0180 __lll_lock_wait_private 01b8 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 01 10 A0 E3 1C D0 4D E2 00 80 A0 E1 94 21 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 4D 00 00 1A 64 71 9F E5 00 20 97 E5 58 11 9F E5 00 00 52 E3 0C 10 8D E5 04 30 91 15 3C 00 00 0A 14 90 8D E2 40 61 9F E5 40 B1 9F E5 02 00 00 EA 00 50 8B E5 05 20 A0 E1 04 30 A0 E1 00 90 8D E5 08 00 A0 E1 28 11 9F E5 ?? ?? ?? ?? 22 00 50 E3 2B 00 00 1A 04 40 96 E5 00 A0 97 E5 84 40 A0 E1 04 10 A0 E1 0A 00 A0 E1 04 40 86 E5 ?? ?? ?? ?? 00 50 50 E2 F4 20 9F E5 EC FF FF 1A 0A 00 A0 E1 08 20 8D E5 ?? ?? ?? ?? E8 30 9F E5 08 20 9D E5 03 30 9F E7 ?? ?? ?? ?? 0C 10 A0 E3 00 50 82 E5 03 10 80 E7 00 30 A0 E3 14 30 8D E5 0C 30 9D E5 00 50 93 E5 00 10 A0 E3 05 40 A0 E1 A8 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 EF FF FF 1A 01 00 55 E3 14 00 00 CA 14 00 9D E5 1C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 30 97 E5 00 00 53 E3 E6 FF FF 1A E3 FF FF EA 01 4B A0 E3 04 00 A0 E1 04 40 81 E5 ?? ?? ?? ?? 00 00 50 E3 00 00 87 E5 DC FF FF 0A 00 20 A0 E1 04 30 A0 E1 B8 FF FF EA 02 00 A0 E1 ?? ?? ?? ?? AE FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF E1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1088_0_0 {
	meta:
		name = "getpwuid"
		size = 444
		refs = "0088 __getpwuid_r 00ac realloc 00c4 free 00d4 __aeabi_read_tp 0160 malloc 0180 __lll_lock_wait_private 01b8 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 01 10 A0 E3 1C D0 4D E2 00 80 A0 E1 94 21 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 4D 00 00 1A 64 71 9F E5 00 20 97 E5 58 11 9F E5 00 00 52 E3 0C 10 8D E5 04 30 91 15 3C 00 00 0A 14 90 8D E2 40 61 9F E5 40 B1 9F E5 02 00 00 EA 00 50 8B E5 05 20 A0 E1 04 30 A0 E1 00 90 8D E5 08 00 A0 E1 28 11 9F E5 ?? ?? ?? ?? 22 00 50 E3 2B 00 00 1A 04 40 96 E5 00 A0 97 E5 84 40 A0 E1 04 10 A0 E1 0A 00 A0 E1 04 40 86 E5 ?? ?? ?? ?? 00 50 50 E2 F4 20 9F E5 EC FF FF 1A 0A 00 A0 E1 08 20 8D E5 ?? ?? ?? ?? E8 30 9F E5 08 20 9D E5 03 30 9F E7 ?? ?? ?? ?? 0C 10 A0 E3 00 50 82 E5 03 10 80 E7 00 30 A0 E3 14 30 8D E5 0C 30 9D E5 00 50 93 E5 00 10 A0 E3 05 40 A0 E1 A8 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 EF FF FF 1A 01 00 55 E3 14 00 00 CA 14 00 9D E5 1C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 30 97 E5 00 00 53 E3 E6 FF FF 1A E3 FF FF EA 01 4B A0 E3 04 00 A0 E1 04 40 81 E5 ?? ?? ?? ?? 00 00 50 E3 00 00 87 E5 DC FF FF 0A 00 20 A0 E1 04 30 A0 E1 B8 FF FF EA 02 00 A0 E1 ?? ?? ?? ?? AE FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF E1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_359_0_0 {
	meta:
		name = "getrpcbyname"
		size = 444
		refs = "0088 __getrpcbyname_r 00ac realloc 00c4 free 00d4 __aeabi_read_tp 0160 malloc 0180 __lll_lock_wait_private 01b8 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 01 10 A0 E3 1C D0 4D E2 00 80 A0 E1 94 21 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 4D 00 00 1A 64 71 9F E5 00 20 97 E5 58 11 9F E5 00 00 52 E3 0C 10 8D E5 04 30 91 15 3C 00 00 0A 14 90 8D E2 40 61 9F E5 40 B1 9F E5 02 00 00 EA 00 50 8B E5 05 20 A0 E1 04 30 A0 E1 00 90 8D E5 08 00 A0 E1 28 11 9F E5 ?? ?? ?? ?? 22 00 50 E3 2B 00 00 1A 04 40 96 E5 00 A0 97 E5 84 40 A0 E1 04 10 A0 E1 0A 00 A0 E1 04 40 86 E5 ?? ?? ?? ?? 00 50 50 E2 F4 20 9F E5 EC FF FF 1A 0A 00 A0 E1 08 20 8D E5 ?? ?? ?? ?? E8 30 9F E5 08 20 9D E5 03 30 9F E7 ?? ?? ?? ?? 0C 10 A0 E3 00 50 82 E5 03 10 80 E7 00 30 A0 E3 14 30 8D E5 0C 30 9D E5 00 50 93 E5 00 10 A0 E3 05 40 A0 E1 A8 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 EF FF FF 1A 01 00 55 E3 14 00 00 CA 14 00 9D E5 1C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 30 97 E5 00 00 53 E3 E6 FF FF 1A E3 FF FF EA 01 4B A0 E3 04 00 A0 E1 04 40 81 E5 ?? ?? ?? ?? 00 00 50 E3 00 00 87 E5 DC FF FF 0A 00 20 A0 E1 04 30 A0 E1 B8 FF FF EA 02 00 A0 E1 ?? ?? ?? ?? AE FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF E1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_537_0_0 {
	meta:
		name = "getrpcbynumber"
		size = 444
		refs = "0088 __getrpcbynumber_r 00ac realloc 00c4 free 00d4 __aeabi_read_tp 0160 malloc 0180 __lll_lock_wait_private 01b8 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 01 10 A0 E3 1C D0 4D E2 00 80 A0 E1 94 21 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 4D 00 00 1A 64 71 9F E5 00 20 97 E5 58 11 9F E5 00 00 52 E3 0C 10 8D E5 04 30 91 15 3C 00 00 0A 14 90 8D E2 40 61 9F E5 40 B1 9F E5 02 00 00 EA 00 50 8B E5 05 20 A0 E1 04 30 A0 E1 00 90 8D E5 08 00 A0 E1 28 11 9F E5 ?? ?? ?? ?? 22 00 50 E3 2B 00 00 1A 04 40 96 E5 00 A0 97 E5 84 40 A0 E1 04 10 A0 E1 0A 00 A0 E1 04 40 86 E5 ?? ?? ?? ?? 00 50 50 E2 F4 20 9F E5 EC FF FF 1A 0A 00 A0 E1 08 20 8D E5 ?? ?? ?? ?? E8 30 9F E5 08 20 9D E5 03 30 9F E7 ?? ?? ?? ?? 0C 10 A0 E3 00 50 82 E5 03 10 80 E7 00 30 A0 E3 14 30 8D E5 0C 30 9D E5 00 50 93 E5 00 10 A0 E3 05 40 A0 E1 A8 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 EF FF FF 1A 01 00 55 E3 14 00 00 CA 14 00 9D E5 1C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 30 97 E5 00 00 53 E3 E6 FF FF 1A E3 FF FF EA 01 4B A0 E3 04 00 A0 E1 04 40 81 E5 ?? ?? ?? ?? 00 00 50 E3 00 00 87 E5 DC FF FF 0A 00 20 A0 E1 04 30 A0 E1 B8 FF FF EA 02 00 A0 E1 ?? ?? ?? ?? AE FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF E1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_505_0_0 {
	meta:
		name = "getsgnam"
		size = 444
		refs = "0088 __getsgnam_r 00ac realloc 00c4 free 00d4 __aeabi_read_tp 0160 malloc 0180 __lll_lock_wait_private 01b8 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 01 10 A0 E3 1C D0 4D E2 00 80 A0 E1 94 21 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 4D 00 00 1A 64 71 9F E5 00 20 97 E5 58 11 9F E5 00 00 52 E3 0C 10 8D E5 04 30 91 15 3C 00 00 0A 14 90 8D E2 40 61 9F E5 40 B1 9F E5 02 00 00 EA 00 50 8B E5 05 20 A0 E1 04 30 A0 E1 00 90 8D E5 08 00 A0 E1 28 11 9F E5 ?? ?? ?? ?? 22 00 50 E3 2B 00 00 1A 04 40 96 E5 00 A0 97 E5 84 40 A0 E1 04 10 A0 E1 0A 00 A0 E1 04 40 86 E5 ?? ?? ?? ?? 00 50 50 E2 F4 20 9F E5 EC FF FF 1A 0A 00 A0 E1 08 20 8D E5 ?? ?? ?? ?? E8 30 9F E5 08 20 9D E5 03 30 9F E7 ?? ?? ?? ?? 0C 10 A0 E3 00 50 82 E5 03 10 80 E7 00 30 A0 E3 14 30 8D E5 0C 30 9D E5 00 50 93 E5 00 10 A0 E3 05 40 A0 E1 A8 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 EF FF FF 1A 01 00 55 E3 14 00 00 CA 14 00 9D E5 1C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 30 97 E5 00 00 53 E3 E6 FF FF 1A E3 FF FF EA 01 4B A0 E3 04 00 A0 E1 04 40 81 E5 ?? ?? ?? ?? 00 00 50 E3 00 00 87 E5 DC FF FF 0A 00 20 A0 E1 04 30 A0 E1 B8 FF FF EA 02 00 A0 E1 ?? ?? ?? ?? AE FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF E1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_261_0_0 {
	meta:
		name = "init_module"
		size = 32
		refs = "001c __syscall_error"
	strings:
		$1 = { 90 00 2D E9 08 40 9D E5 80 70 A0 E3 00 00 00 EF 90 00 BD E8 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_262_0_0 {
	meta:
		name = "print_errno_message"
		size = 60
		refs = "0014 __strerror_r 0024 __fxprintf"
	strings:
		$1 = { 04 E0 2D E5 01 DB 4D E2 04 D0 4D E2 0D 10 A0 E1 01 2B A0 E3 ?? ?? ?? ?? 18 10 9F E5 00 20 A0 E1 00 00 A0 E3 ?? ?? ?? ?? 01 DB 8D E2 04 D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_262_1_0 {
	meta:
		name = "error_tail"
		size = 448
		refs = "0034 strlen 0090 __mbsrtowcs 00b0 __vfwprintf 00bc free 00e0 __fxprintf 00e8 _IO_fflush 0138 vfprintf 0154 __libc_alloca_cutoff 0174 realloc 0194 fputws_unlocked 01a8 exit 01ac stderr 01b0 error_message_count"
	strings:
		$1 = { F0 4F 2D E9 A0 81 9F E5 20 B0 8D E2 24 D0 4D E2 00 C0 98 E5 6C E0 9C E5 00 00 5E E3 3C 00 0B E5 01 90 A0 E1 02 60 A0 E1 38 30 0B E5 3E 00 00 DA 02 00 A0 E1 ?? ?? ?? ?? 00 70 A0 E3 01 40 80 E2 07 50 A0 E1 07 A0 A0 E1 02 00 00 EA 0A 01 74 E3 2B 00 00 8A 84 40 A0 E1 04 11 A0 E1 01 0A 51 E3 39 00 00 8A 0E 10 81 E2 07 10 C1 E3 01 D0 4D E0 0D 50 A0 E1 05 00 A0 E1 30 10 4B E2 04 20 A0 E1 2C 30 4B E2 2C A0 0B E5 28 A0 0B E5 30 60 0B E5 ?? ?? ?? ?? 00 00 54 E1 EB FF FF 0A 01 00 70 E3 17 00 00 0A 00 00 98 E5 05 10 A0 E1 38 20 1B E5 ?? ?? ?? ?? 00 00 57 E3 05 00 A0 11 ?? ?? ?? ?? E8 30 9F E5 00 20 93 E5 00 00 59 E3 01 20 82 E2 00 20 83 E5 11 00 00 1A D4 10 9F E5 00 00 A0 E3 ?? ?? ?? ?? 00 00 98 E5 ?? ?? ?? ?? 3C 30 1B E5 00 00 53 E3 2A 00 00 1A 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 00 00 57 E3 0C 00 00 1A 00 00 98 E5 A0 10 9F E5 38 20 1B E5 ?? ?? ?? ?? E7 FF FF EA 09 00 A0 E1 A6 FF FF EB EA FF FF EA 02 10 A0 E1 0C 00 A0 E1 03 20 A0 E1 ?? ?? ?? ?? DF FF FF EA 05 00 A0 E1 ?? ?? ?? ?? EF FF FF EA 01 00 A0 E1 40 10 0B E5 ?? ?? ?? ?? 00 00 50 E3 40 10 1B E5 BF FF FF 1A 00 00 57 E3 05 70 A0 11 00 70 A0 03 07 00 A0 E1 ?? ?? ?? ?? 00 50 50 E2 01 70 A0 13 BB FF FF 1A 07 00 A0 E1 ?? ?? ?? ?? 00 10 98 E5 24 00 9F E5 ?? ?? ?? ?? 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 03 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_262_2_0 {
	meta:
		name = "__error"
		size = 188
		refs = "0030 pthread_setcancelstate 003c _IO_fflush 00a0 __fxprintf 00ac stdout 00b0 error_print_progname 00b4 program_invocation_name"
	strings:
		$1 = { 0C 00 2D E9 F0 40 2D E9 98 40 9F E5 00 30 A0 E3 0C D0 4D E2 03 00 54 E1 00 70 A0 E1 01 60 A0 E1 04 30 8D E5 20 50 9D E5 01 00 A0 13 04 10 8D 12 ?? ?? ?? ?? 70 30 9F E5 00 00 93 E5 ?? ?? ?? ?? 68 30 9F E5 00 00 93 E5 00 00 50 E3 10 00 00 0A 0F E0 A0 E1 ?? ?? ?? ?? 24 C0 8D E2 07 00 A0 E1 06 10 A0 E1 05 20 A0 E1 0C 30 A0 E1 00 C0 8D E5 72 FF FF EB 00 00 54 E3 04 00 9D 15 00 10 A0 13 ?? ?? ?? ?? 0C D0 8D E2 F0 40 BD E8 08 D0 8D E2 ?? ?? ?? ?? 18 20 9F E5 18 10 9F E5 00 20 92 E5 ?? ?? ?? ?? EB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_262_3_0 {
	meta:
		name = "__error_at_line"
		size = 320
		refs = "0058 pthread_setcancelstate 0064 _IO_fflush 009c __fxprintf 00f8 strcmp 011c error_one_per_line 0128 stdout 012c error_print_progname 0138 program_invocation_name"
	strings:
		$1 = { F0 41 2D E9 10 C1 9F E5 00 C0 9C E5 00 00 5C E3 08 D0 4D E2 00 80 A0 E1 01 70 A0 E1 02 40 A0 E1 03 50 A0 E1 05 00 00 0A F0 60 9F E5 00 30 96 E5 05 00 53 E1 27 00 00 0A 04 40 86 E5 00 50 86 E5 DC 60 9F E5 00 30 A0 E3 03 00 56 E1 04 30 8D E5 01 00 A0 13 04 10 8D 12 ?? ?? ?? ?? C4 30 9F E5 00 00 93 E5 ?? ?? ?? ?? BC 30 9F E5 00 00 93 E5 00 00 50 E3 23 00 00 0A 0F E0 A0 E1 ?? ?? ?? ?? A8 20 9F E5 00 00 54 E3 A4 10 9F E5 05 30 A0 E1 02 10 A0 11 00 00 A0 E3 04 20 A0 E1 ?? ?? ?? ?? 24 C0 8D E2 08 00 A0 E1 07 10 A0 E1 0C 30 A0 E1 20 20 9D E5 00 C0 8D E5 31 FF FF EB 00 00 56 E3 04 00 9D 15 00 10 A0 13 ?? ?? ?? ?? 08 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 04 00 96 E5 00 00 52 E1 F9 FF FF 0A 00 00 50 E3 D2 FF FF 0A 00 00 52 E3 D0 FF FF 0A 02 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F1 FF FF 0A CB FF FF EA 28 20 9F E5 28 10 9F E5 00 20 92 E5 ?? ?? ?? ?? D8 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_263_0_0 {
	meta:
		name = "__sched_getparam"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 9B 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_264_0_0 {
	meta:
		name = "object_compare"
		size = 76
	strings:
		$1 = { 01 30 A0 E1 08 20 93 E5 08 10 90 E5 02 00 51 E1 00 20 A0 93 01 20 A0 83 01 20 42 32 00 00 52 E3 07 00 00 1A 03 00 90 E8 0C 00 93 E8 03 00 51 E1 02 00 50 01 00 00 A0 93 01 00 A0 83 01 00 40 32 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_264_1_0 {
	meta:
		name = "add_object.isra.1"
		size = 92
		refs = "0014 malloc 0038 __tsearch 0058 object_compare"
	strings:
		$1 = { 70 40 2D E9 00 40 A0 E1 10 00 A0 E3 01 50 A0 E1 02 60 A0 E1 ?? ?? ?? ?? 00 C0 50 E2 0B 00 00 0A 0C 00 95 E8 00 E0 96 E5 30 10 84 E2 0C 00 8C E8 08 E0 8C E5 1C 20 9F E5 ?? ?? ?? ?? 00 00 50 E3 00 00 A0 13 00 00 E0 03 70 40 BD E8 ?? ?? ?? ?? 00 00 E0 E3 FB FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_264_2_0 {
	meta:
		name = "process_entry"
		size = 732
		refs = "004c mempcpy 0088 __fxstatat 00f4 realloc 0140 __tfind 01c0 __lxstat 01d0 __aeabi_read_tp 0248 __xstat 02d4 object_compare 02d8 __libc_errno"
	strings:
		$1 = { F0 47 2D E9 02 40 A0 E1 00 20 D2 E5 2E 00 52 E3 70 D0 4D E2 00 80 A0 E1 01 A0 A0 E1 03 50 A0 E1 55 00 00 0A 14 00 98 E5 10 30 98 E5 02 10 80 E2 05 10 81 E0 03 00 51 E1 2A 00 00 8A 0C 30 98 E5 00 00 83 E0 04 10 A0 E1 05 20 A0 E1 ?? ?? ?? ?? 00 30 A0 E3 00 30 C0 E5 04 10 9A E5 01 00 71 E3 1C 30 98 E5 4D 00 00 0A 01 00 13 E3 00 30 A0 03 01 3C A0 13 18 90 8D E2 00 30 8D E5 03 00 A0 E3 09 30 A0 E1 04 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 4D 00 00 BA 28 30 9D E5 0F 3A 03 E2 01 09 53 E3 6E 00 00 0A 0A 0A 53 E3 1C 30 98 E5 04 20 A0 03 00 20 A0 13 02 00 13 E3 13 00 00 0A 18 70 8D E2 C0 00 97 E8 28 50 88 E2 30 00 95 E8 05 00 57 E1 04 00 56 01 0C 00 00 0A 00 00 A0 E3 70 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 81 10 A0 E1 10 10 88 E5 0C 00 98 E5 ?? ?? ?? ?? 00 30 50 E2 53 00 00 0A 0C 30 88 E5 14 00 98 E5 CC FF FF EA 01 00 52 E3 66 00 00 1A 01 60 13 E2 12 00 00 1A 18 50 8D E2 30 00 95 E8 24 30 9D E5 08 00 8D E2 30 10 88 E2 9C 21 9F E5 08 40 8D E5 0C 50 8D E5 10 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 06 00 A0 11 E2 FF FF 1A 08 00 A0 E1 09 10 A0 E1 24 20 8D E2 90 FF FF EB 00 00 50 E3 49 00 00 1A 09 10 A0 E1 0A 20 A0 E1 08 00 A0 E1 58 00 00 EB 44 00 00 EA 01 30 D4 E5 00 00 53 E3 D3 FF FF 0A 2E 00 53 E3 A4 FF FF 1A 02 30 D4 E5 00 00 53 E3 A1 FF FF 1A CD FF FF EA 04 00 13 E3 0C 40 98 05 18 90 8D E2 01 00 13 E3 09 20 A0 E1 03 00 A0 E3 04 10 A0 E1 21 00 00 0A ?? ?? ?? ?? 00 00 50 E3 B1 FF FF AA 04 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 02 00 53 E3 0D 00 53 13 1C 30 98 E5 18 00 00 1A 01 00 13 E3 1D 00 00 1A 90 20 9D E5 0A 00 52 E3 2D 00 00 0A 04 10 9A E5 01 00 71 E3 2C 00 00 0A 01 3C A0 E3 00 30 8D E5 04 20 A0 E1 03 00 A0 E3 09 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0F 00 00 1A 28 30 9D E5 0F 3A 03 E2 0A 0A 53 E3 0B 00 00 1A 1C 30 98 E5 06 20 A0 E3 9A FF FF EA ?? ?? ?? ?? 8E FF FF EA 00 00 E0 E3 70 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 1C 30 98 E5 01 20 A0 E3 91 FF FF EA 0C 20 A0 E3 20 30 98 E5 09 10 A0 E1 02 20 93 E7 0C 00 98 E5 14 30 88 E2 24 C0 98 E5 0F E0 A0 E1 ?? ?? ?? ?? 1C 30 98 E5 10 00 13 E3 8F FF FF 0A 02 00 50 E3 8C FF FF 0A 70 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 02 21 A0 E1 ED FF FF EA 06 20 A0 E3 7C FF FF EA 04 10 A0 E1 09 20 A0 E1 03 00 A0 E3 ?? ?? ?? ?? D3 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_264_3_0 {
	meta:
		name = "ftw_dir"
		size = 1852
		refs = "004c malloc 0078 strlen 00a8 realloc 00c4 mempcpy 00d4 __readdir64 0124 __closedir 0180 __openat64_nocancel 0198 __fdopendir 0204 __rawmemchr 02e0 __aeabi_read_tp 02f4 free 0390 __fchdir 03bc __opendir 0614 __chdir 06a0 __assert_fail 06dc __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 00 00 52 E3 34 D0 4D E2 0C 20 8D E5 14 20 90 E5 0C 30 9D 15 14 20 8D E5 0C 20 9D 05 04 30 83 12 10 30 8D 15 10 20 8D 05 00 30 90 E5 04 20 90 E5 02 51 93 E7 00 00 55 E3 00 80 A0 E1 18 10 8D E5 42 00 00 0A 01 0B A0 E3 ?? ?? ?? ?? 00 70 50 E2 5B 01 00 0A 00 40 A0 E3 00 90 95 E5 04 B0 A0 E1 01 6B A0 E3 1C 80 8D E5 17 00 00 EA 13 50 80 E2 05 00 A0 E1 ?? ?? ?? ?? 04 80 80 E0 02 20 88 E2 06 00 52 E1 00 A0 A0 E1 09 00 00 3A 80 20 A0 E1 01 0B 52 E3 02 60 86 20 01 6B 86 32 06 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 06 01 00 0A 00 70 A0 E1 04 00 87 E0 05 10 A0 E1 0A 20 A0 E1 ?? ?? ?? ?? 00 B0 C0 E5 01 40 88 E2 09 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 E3 FF FF 1A 1C 80 9D E5 04 00 C7 E7 04 20 98 E5 00 30 98 E5 01 10 84 E2 00 50 A0 E1 07 00 A0 E1 02 41 93 E7 ?? ?? ?? ?? 04 30 98 E5 00 20 98 E5 08 00 84 E5 03 31 92 E7 08 30 93 E5 00 00 53 E3 45 01 00 0A 09 00 A0 E1 ?? ?? ?? ?? 0C 00 98 E8 03 11 92 E7 00 50 81 E5 03 11 92 E7 00 00 E0 E3 04 00 81 E5 03 51 82 E7 00 20 98 E5 03 31 92 E7 00 00 53 E3 4E 01 00 1A 10 30 9D E5 00 00 53 E3 92 00 00 0A 00 00 93 E5 01 00 70 E3 8F 00 00 0A 14 30 98 E5 0C 10 98 E5 12 2B A0 E3 03 10 81 E0 00 30 A0 E3 ?? ?? ?? ?? 00 30 A0 E3 01 00 70 E3 00 40 A0 E1 24 30 8D E5 22 01 00 0A ?? ?? ?? ?? 00 00 50 E3 24 00 8D E5 34 01 00 0A 04 40 98 E9 00 C0 90 E5 00 00 98 E5 01 30 82 E2 00 10 A0 E3 24 60 8D E2 0E 00 53 E1 28 C0 8D E5 2C 10 8D E5 02 61 80 E7 04 30 88 E5 1C 30 98 E5 04 10 88 05 08 00 13 E3 CD 00 00 0A 04 00 13 E3 D6 00 00 1A 18 30 98 E5 0C 40 98 E5 01 30 83 E2 18 30 88 E5 04 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 00 00 54 E1 2D 01 00 0A 01 30 50 E5 2F 00 53 E3 2F 30 A0 13 00 30 C0 15 0C 40 98 15 01 00 80 12 00 40 64 E0 14 40 88 E5 0E 00 00 EA ?? ?? ?? ?? 00 40 50 E2 70 00 00 0A 13 50 84 E2 05 00 A0 E1 ?? ?? ?? ?? 12 10 D4 E5 00 30 A0 E1 00 10 8D E5 05 20 A0 E1 08 00 A0 E1 06 10 A0 E1 AE FE FF EB 00 00 50 E3 63 00 00 1A 24 00 9D E5 00 00 50 E3 ED FF FF 1A 2C 90 9D E5 00 40 D9 E5 00 00 54 E3 13 00 00 0A 00 70 A0 E3 02 00 00 EA 01 30 D5 E5 00 00 53 E3 0C 00 00 0A 09 00 A0 E1 00 10 A0 E3 ?? ?? ?? ?? 09 20 A0 E1 00 30 69 E0 00 50 A0 E1 00 70 8D E5 08 00 A0 E1 06 10 A0 E1 96 FE FF EB 00 00 50 E3 01 90 85 E2 EF FF FF 0A 2C 90 9D E5 00 40 A0 E1 F8 33 9F E5 ?? ?? ?? ?? 03 30 9F E7 00 50 A0 E1 09 00 A0 E1 03 60 95 E7 ?? ?? ?? ?? E0 33 9F E5 03 30 9F E7 03 60 85 E7 1C 30 98 E5 10 00 13 E3 01 00 00 0A 03 00 54 E3 57 00 00 0A 14 30 98 E5 0C 10 98 E5 00 20 A0 E3 03 30 81 E0 01 20 43 E5 18 30 98 E5 02 00 54 E1 14 20 9D E5 01 30 43 E2 14 20 88 E5 18 30 88 E5 55 00 00 0A 0C 30 9D E5 00 00 53 E3 11 00 00 0A 1C 30 98 E5 04 00 13 E3 0E 00 00 0A 00 00 54 E3 04 00 00 0A 10 00 13 E3 0A 00 00 0A 01 00 54 E3 01 00 74 13 07 00 00 0A 0C 20 9D E5 00 30 92 E5 00 00 53 E3 9D 00 00 0A 00 00 93 E5 ?? ?? ?? ?? 00 00 50 E3 99 00 00 1A 04 00 A0 E1 34 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 1C 30 98 E5 04 00 13 E3 09 00 00 1A 0C 00 98 E5 ?? ?? ?? ?? 24 00 8D E5 00 00 50 E3 76 FF FF 1A 10 33 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 47 00 00 EA 0C 20 98 E5 14 30 98 E5 03 00 D2 E7 F4 12 9F E5 00 00 50 E3 03 00 82 10 01 00 A0 01 EE FF FF EA 00 40 A0 E1 24 20 9D E5 00 00 52 E3 A9 00 00 0A D4 32 9F E5 2C 10 9D E5 ?? ?? ?? ?? 03 30 9F E7 00 00 51 E3 00 50 A0 E1 03 60 90 E7 9C 00 00 1A 02 00 A0 E1 ?? ?? ?? ?? 04 20 98 E5 00 30 E0 E3 28 30 8D E5 A4 32 9F E5 00 00 52 E3 01 20 42 E2 03 30 9F E7 04 20 88 E5 08 20 98 05 03 60 85 E7 00 30 98 E5 01 20 42 02 00 10 A0 E3 04 20 88 05 02 11 83 E7 A2 FF FF EA 14 30 98 E5 0C 10 98 E5 00 20 A0 E3 03 30 81 E0 01 20 43 E5 18 30 98 E5 14 20 9D E5 01 30 43 E2 14 20 88 E5 18 30 88 E5 1C 40 98 E5 08 40 14 E2 A6 FF FF 0A 18 10 9D E5 0C 00 98 E5 05 20 A0 E3 14 30 88 E2 24 C0 98 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 9D FF FF EA 1C 32 9F E5 ?? ?? ?? ?? 03 30 9F E7 00 50 A0 E1 07 00 A0 E1 03 40 95 E7 1C 80 9D E5 ?? ?? ?? ?? 00 22 9F E5 02 20 9F E7 02 40 85 E7 04 30 A0 E1 0D 00 53 E3 35 00 00 0A 00 40 E0 E3 04 00 A0 E1 34 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 0C 00 98 E5 18 10 9D E5 01 20 A0 E3 14 30 88 E2 24 C0 98 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 40 50 E2 07 00 00 1A 1C 30 98 E5 26 FF FF EA 24 30 9D E5 00 00 93 E5 ?? ?? ?? ?? 00 00 50 E3 23 FF FF AA 00 40 E0 E3 94 31 9F E5 ?? ?? ?? ?? 00 50 A0 E1 03 30 9F E7 24 00 9D E5 03 60 95 E7 ?? ?? ?? ?? 04 20 98 E5 00 30 E0 E3 28 30 8D E5 70 31 9F E5 00 00 52 E3 01 20 42 E2 03 30 9F E7 04 20 88 E5 08 20 98 05 03 60 85 E7 00 30 98 E5 01 20 42 02 00 10 A0 E3 04 00 A0 E1 04 20 88 05 02 11 83 E7 34 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 34 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 0D 00 53 E3 C9 FF FF 1A 18 10 9D E5 0C 00 98 E5 02 20 A0 E3 14 30 88 E2 24 C0 98 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 65 FF FF EA 14 30 98 E5 01 00 53 E3 15 00 00 0A F0 00 9F E5 ?? ?? ?? ?? 00 00 50 E3 5E FF FF AA B8 FF FF EA E0 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 B1 FF FF EA D0 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 00 50 A0 E1 07 00 A0 E1 03 40 95 E7 ?? ?? ?? ?? B8 20 9F E5 02 20 9F E7 02 40 85 E7 04 30 A0 E1 A5 FF FF EA A8 00 9F E5 ?? ?? ?? ?? 00 00 50 E3 48 FF FF AA A2 FF FF EA 04 00 A0 E1 06 70 A0 E3 00 00 00 EF 24 00 9D E5 4C FF FF EA 84 00 9F E5 84 10 9F E5 84 20 9F E5 84 30 9F E5 ?? ?? ?? ?? 80 00 9F E5 70 10 9F E5 23 2E A0 E3 78 30 9F E5 ?? ?? ?? ?? 00 00 54 E3 2C 90 9D E5 05 FF FF 1A ED FE FF EA 64 00 9F E5 4C 10 9F E5 60 20 9F E5 54 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 52 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 1A 02 00 00 }
	condition:
		$1
}

rule file_264_4_0 {
	meta:
		name = "ftw_startup"
		size = 1280
		refs = "0058 memset 0060 strlen 0078 malloc 0090 stpcpy 014c __lxstat 015c __aeabi_read_tp 019c __xstat 0280 __chdir 0288 free 02a8 __open 0330 __fchdir 0358 __tdestroy 03b0 __getcwd 04bc __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 94 D0 4D E2 00 80 A0 E1 00 00 D0 E5 00 00 50 E3 01 70 A0 E1 02 50 A0 E1 04 60 9B E5 FA 00 00 0A 01 00 53 E3 01 30 A0 B3 03 21 A0 E1 0E 10 82 E2 07 10 C1 E3 01 D0 4D E0 00 C0 A0 E3 0C 10 A0 E1 0D 00 A0 E1 AC 30 0B E5 B0 C0 0B E5 B4 D0 0B E5 ?? ?? ?? ?? 08 00 A0 E1 ?? ?? ?? ?? 80 30 A0 E1 01 0A 53 E3 01 3A A0 33 03 00 A0 E1 A4 30 0B E5 ?? ?? ?? ?? 00 00 50 E3 00 40 A0 E1 A8 00 0B E5 FB 00 00 0A 08 10 A0 E1 ?? ?? ?? ?? 01 20 84 E2 02 00 50 E1 03 00 00 8A 05 00 00 EA 01 00 40 E2 02 00 50 E1 02 00 00 0A 01 30 50 E5 2F 00 53 E3 F9 FF FF 0A 00 30 A0 E3 00 00 54 E1 00 30 C0 E5 9C 30 0B E5 03 00 00 3A 05 00 00 EA 01 00 40 E2 04 00 50 E1 02 00 00 0A 01 30 50 E5 2F 00 53 E3 F9 FF FF 1A C4 33 9F E5 00 00 57 E3 1C 20 43 E2 03 70 A0 01 02 70 A0 11 00 80 A0 E3 04 20 16 E2 00 00 64 E0 94 70 0B E5 84 80 0B E5 A0 00 0B E5 98 60 0B E5 90 50 0B E5 02 80 A0 01 00 70 E0 03 5C 00 00 1A 00 00 52 E3 0E 00 00 1A 01 A0 16 E2 7C 90 4B E2 13 00 00 0A 04 10 A0 E1 09 20 A0 E1 03 00 A0 E3 ?? ?? ?? ?? 00 00 50 E3 2B 00 00 AA 5C 33 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 50 90 E7 00 40 E0 E3 39 00 00 EA A0 20 1B E5 02 20 F4 E7 40 33 9F E5 00 00 52 E3 03 40 A0 01 01 A0 16 E2 7C 90 4B E2 EB FF FF 1A 09 20 A0 E1 03 00 A0 E3 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 17 00 00 AA 14 33 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 50 90 E7 02 00 55 E3 00 A0 A0 E1 00 40 E0 13 23 00 00 1A 04 10 A0 E1 03 00 A0 E3 09 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 6C 30 1B E5 0F 3A 03 E2 0A 0A 53 E3 A4 00 00 0A D0 32 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 50 90 E7 00 40 E0 E3 13 00 00 EA 6C 30 1B E5 0F 3A 03 E2 01 09 53 E3 6D 00 00 0A 0A 0A 53 E3 94 20 1B E5 10 30 A0 03 00 30 A0 13 03 20 92 E7 09 10 A0 E1 A0 30 4B E2 A8 00 1B E5 90 C0 1B E5 0F E0 A0 E1 ?? ?? ?? ?? 80 32 9F E5 00 40 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 50 90 E7 10 00 16 E3 30 00 00 0A 02 30 44 E2 01 00 53 E3 00 40 A0 93 01 00 77 E3 2D 00 00 1A 00 00 58 E3 34 00 00 0A 08 00 A0 E1 ?? ?? ?? ?? 08 00 A0 E1 ?? ?? ?? ?? 3C 32 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 50 80 E7 2B 00 00 EA 18 02 9F E5 01 19 A0 E3 ?? ?? ?? ?? 01 00 70 E3 00 70 A0 E1 33 00 00 0A AC 30 1B E5 01 00 53 E3 01 30 43 82 AC 30 0B 85 A0 30 1B E5 00 00 53 E3 56 00 00 DA 01 00 53 E3 58 00 00 0A A8 20 1B E5 01 30 43 E2 00 10 A0 E3 03 50 D2 E7 03 10 C2 E7 A8 00 1B E5 ?? ?? ?? ?? A8 20 1B E5 A0 30 1B E5 03 30 82 E0 01 50 43 E5 00 40 A0 E1 00 00 54 E3 46 00 00 0A B8 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 50 90 E7 01 00 77 E3 D1 FF FF 0A 07 00 A0 E1 ?? ?? ?? ?? 07 00 A0 E1 06 70 A0 E3 00 00 00 EF 90 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 50 80 E7 84 00 1B E5 80 11 9F E5 ?? ?? ?? ?? A8 00 1B E5 ?? ?? ?? ?? 74 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 50 80 E7 04 20 A0 E1 02 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 54 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 50 90 E7 0D 00 55 E3 00 90 A0 E1 08 40 A0 11 E9 FF FF 1A 08 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 00 80 50 E2 C2 FF FF 1A 24 31 9F E5 03 30 9F E7 08 40 A0 E1 03 50 99 E7 DF FF FF EA 7C 50 4B E2 30 00 95 E8 00 00 5A E3 8C 40 0B E5 88 50 0B E5 B4 50 4B E2 18 00 00 0A 05 00 A0 E1 09 10 A0 E1 00 20 A0 E3 31 FD FF EB E8 30 9F E5 00 40 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 50 90 E7 90 FF FF EA D4 30 9F E5 02 20 A0 E3 ?? ?? ?? ?? 03 30 9F E7 03 20 80 E7 00 20 E0 E3 D1 FF FF EA 98 20 1B E5 A8 40 1B E5 04 20 02 E2 3A FF FF EA AC 00 9F E5 ?? ?? ?? ?? 00 40 A0 E1 AE FF FF EA 05 00 A0 E1 09 10 A0 E1 70 20 4B E2 4A FC FF EB 00 40 50 E2 E0 FF FF 0A 88 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 50 90 E7 76 FF FF EA 00 20 E0 E3 BC FF FF EA 94 30 1B E5 09 10 A0 E1 18 20 93 E5 A8 00 1B E5 A0 30 4B E2 90 C0 1B E5 0F E0 A0 E1 ?? ?? ?? ?? 50 30 9F E5 03 30 9F E7 00 40 A0 E1 03 50 9A E7 67 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_264_5_0 {
	meta:
		name = "ftw"
		size = 44
		altNames = "ftw64"
	strings:
		$1 = { 04 E0 2D E5 01 C0 A0 E1 0C D0 4D E2 00 10 A0 E3 02 30 A0 E1 00 10 8D E5 0C 20 A0 E1 B7 FE FF EB 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_264_6_0 {
	meta:
		name = "__new_nftw"
		size = 84
		refs = "0038 __aeabi_read_tp 0050 __libc_errno"
		altNames = "__new_nftw64"
	strings:
		$1 = { 04 E0 2D E5 1F C0 D3 E3 0C D0 4D E2 02 C0 A0 E1 07 00 00 1A 00 30 8D E5 01 20 A0 E1 0C 30 A0 E1 01 10 A0 E3 AA FE FF EB 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? 14 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 00 00 E0 E3 F5 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_265_0_0 {
	meta:
		name = "pmap_getmaps"
		size = 312
		refs = "0028 __get_socket 0050 clnttcp_create 00f4 __dcgettext 0100 clnt_perror 0114 __aeabi_read_tp 0124 xdr_pmaplist 0128 xdr_void 0130 _libc_intl_domainname 0134 __libc_errno"
	strings:
		$1 = { F0 41 2D E9 6F 3C A0 E3 20 D0 4D E2 B2 30 C0 E1 00 60 A0 E3 3C 30 A0 E3 00 40 A0 E1 18 30 8D E5 10 60 8D E5 1C 60 8D E5 ?? ?? ?? ?? 20 30 8D E2 32 10 A0 E3 7D 2F A0 E3 0C 00 23 E5 00 70 A0 E1 06 00 8D E8 04 00 A0 E1 D0 10 9F E5 02 20 A0 E3 ?? ?? ?? ?? 00 50 50 E2 15 00 00 0A 20 30 8D E2 03 00 13 E9 B8 80 9F E5 10 E0 8D E2 08 C0 8D E2 06 30 A0 E1 AC 20 9F E5 04 60 95 E5 00 41 8D E8 03 00 8C E8 05 00 A0 E1 04 10 A0 E3 00 C0 96 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 11 00 00 1A 04 30 95 E5 05 00 A0 E1 10 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 01 00 77 E3 04 00 00 0A 14 00 9D E5 06 70 A0 E3 00 00 00 EF 01 0A 70 E3 0D 00 00 8A 10 00 9D E5 00 30 A0 E3 B2 30 C4 E1 20 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 3C 10 9F E5 05 20 A0 E3 38 00 9F E5 ?? ?? ?? ?? 00 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? E5 FF FF EA 24 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 EB FF FF EA A0 86 01 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_266_0_0 {
	meta:
		name = "fputws_unlocked"
		size = 104
		refs = "000c __wcslen 001c _IO_fwide"
	strings:
		$1 = { F8 40 2D E9 01 40 A0 E1 00 70 A0 E1 ?? ?? ?? ?? 01 10 A0 E3 00 60 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 01 00 50 E3 00 50 A0 E1 0B 00 00 1A 07 10 A0 E1 98 30 94 E5 04 00 A0 E1 06 20 A0 E1 1C C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 06 00 50 E1 02 00 00 1A 05 00 A0 E1 F8 40 BD E8 ?? ?? ?? ?? 00 00 E0 E3 F8 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_267_1_0 {
	meta:
		name = "updwtmp_file"
		size = 536
		refs = "0030 alarm 0050 memset 0068 __sigaction 00a0 __fcntl_nocancel 00c4 __lseek64 00d8 __aeabi_ldivmod 0118 __ftruncate64 01dc __aeabi_read_tp 0208 timeout_handler 0210 __libc_errno"
	strings:
		$1 = { F0 43 2D E9 01 90 A0 E1 4D DF 4D E2 05 70 A0 E3 EC 11 9F E5 00 00 00 EF 01 0A 70 E3 00 60 A0 E1 6A 00 00 8A 00 00 50 E3 66 00 00 BA 00 00 A0 E3 ?? ?? ?? ?? CC 31 9F E5 13 5E 8D E2 18 31 25 E5 00 10 A0 E3 80 20 A0 E3 00 80 A0 E1 1C 00 8D E2 ?? ?? ?? ?? 00 40 A0 E3 05 10 A0 E1 A4 20 8D E2 0E 00 A0 E3 9C 40 8D E5 ?? ?? ?? ?? 0A 00 A0 E3 ?? ?? ?? ?? 90 31 9F E5 01 C0 A0 E3 13 EE 8D E2 08 20 8D E2 06 00 A0 E1 07 10 A0 E3 08 40 8D E5 0C 40 8D E5 10 40 8D E5 14 40 8D E5 B3 C0 8E E1 ?? ?? ?? ?? 04 00 50 E1 00 40 E0 B3 23 00 00 BA 02 70 A0 E3 00 20 A0 E3 00 30 A0 E3 00 70 8D E5 06 00 A0 E1 ?? ?? ?? ?? 06 2D A0 E3 00 30 A0 E3 00 40 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 03 10 92 E1 28 00 00 1A 09 10 A0 E1 06 00 A0 E1 06 2D A0 E3 04 70 A0 E3 00 00 00 EF 01 0A 70 E3 3A 00 00 8A 06 0D 50 E3 00 40 A0 03 04 00 00 0A 04 20 A0 E1 05 30 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 40 E0 E3 E4 30 9F E5 02 C0 A0 E3 13 EE 8D E2 08 20 8D E2 06 00 A0 E1 07 10 A0 E3 B3 C0 8E E1 ?? ?? ?? ?? 00 00 A0 E3 ?? ?? ?? ?? A4 10 8D E2 0E 00 A0 E3 00 20 A0 E3 ?? ?? ?? ?? 00 00 58 E3 06 00 00 1A 06 00 A0 E1 06 70 A0 E3 00 00 00 EF 04 00 A0 E1 4D DF 8D E2 F0 43 BD E8 ?? ?? ?? ?? 08 00 A0 E1 ?? ?? ?? ?? F5 FF FF EA 02 40 54 E0 03 50 C5 E0 04 20 A0 E1 05 30 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 30 A0 E3 00 70 8D E5 06 00 A0 E1 00 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 00 30 D1 E2 00 40 E0 B3 C7 FF FF AA D5 FF FF EA 00 00 E0 E3 E7 FF FF EA 38 30 9F E5 00 60 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 60 80 E7 00 00 E0 E3 E0 FF FF EA 20 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 C1 FF FF EA 01 00 02 00 ?? ?? ?? ?? D8 FE FF FF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_267_2_0 {
	meta:
		name = "setutent_file"
		size = 548
		refs = "0030 __lseek64 006c strcmp 00f8 __fcntl_nocancel 0134 __access 01e8 __aeabi_read_tp 0208 __libc_utmp_file_name 021c __have_o_cloexec 0220 __libc_errno"
	strings:
		$1 = { F0 40 2D E9 F4 51 9F E5 00 30 95 E5 00 00 53 E3 0C D0 4D E2 10 00 00 BA E4 41 9F E5 00 20 A0 E3 03 00 A0 E1 00 20 8D E5 00 30 A0 E3 00 20 A0 E3 ?? ?? ?? ?? 00 30 A0 E3 00 20 A0 E3 08 20 84 E5 0C 30 84 E5 00 30 E0 E3 B0 31 C4 E1 01 00 A0 E3 0C D0 8D E2 F0 40 BD E8 ?? ?? ?? ?? A4 61 9F E5 00 40 96 E5 A0 11 9F E5 04 00 A0 E1 ?? ?? ?? ?? 00 10 50 E2 2D 00 00 0A 90 11 9F E5 04 00 A0 E1 ?? ?? ?? ?? 00 10 50 E2 2E 00 00 0A 80 11 9F E5 04 00 A0 E1 ?? ?? ?? ?? 00 10 50 E2 2F 00 00 0A 70 11 9F E5 04 00 A0 E1 ?? ?? ?? ?? 00 10 50 E2 04 00 A0 11 2F 00 00 0A 44 41 9F E5 00 30 A0 E3 00 30 C4 E5 0A 18 A0 E3 05 70 A0 E3 00 00 00 EF 01 0A 70 E3 00 30 A0 E1 3F 00 00 8A 38 61 9F E5 00 20 96 E5 00 00 52 E3 00 00 85 E5 CA FF FF CA 01 10 A0 E3 00 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 2E 00 00 BA 00 30 96 E5 00 00 53 E3 03 00 00 1A 01 00 10 E3 00 30 E0 03 01 30 A0 13 00 30 86 E5 00 00 53 E3 21 00 00 BA 00 30 95 E5 BA FF FF EA DC 00 9F E5 ?? ?? ?? ?? 00 00 50 E3 13 00 00 0A 00 40 96 E5 CB FF FF EA C8 00 9F E5 ?? ?? ?? ?? 00 00 50 E3 0F 00 00 0A 00 40 96 E5 CA FF FF EA AC 00 9F E5 ?? ?? ?? ?? 00 00 50 E3 0B 00 00 1A 00 40 96 E5 C9 FF FF EA 98 00 9F E5 ?? ?? ?? ?? 00 00 50 E3 07 00 00 1A 00 00 96 E5 C9 FF FF EA 7C 00 9F E5 C7 FF FF EA 78 00 9F E5 C5 FF FF EA 64 00 9F E5 C3 FF FF EA 60 00 9F E5 C1 FF FF EA 01 20 80 E3 02 10 A0 E3 00 00 95 E5 ?? ?? ?? ?? 01 00 70 E3 D7 FF FF 1A 00 00 95 E5 06 70 A0 E3 00 00 00 EF 00 00 A0 E3 9C FF FF EA 3C 20 9F E5 00 30 60 E2 02 20 9F E7 ?? ?? ?? ?? 00 10 E0 E3 02 30 80 E7 00 10 85 E5 00 00 A0 E3 93 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_267_3_0 {
	meta:
		name = "__utmp_equal"
		size = 140
		refs = "005c strncmp"
	strings:
		$1 = { 08 40 2D E9 B0 30 D0 E1 05 30 43 E2 03 38 A0 E1 03 08 53 E3 04 00 00 8A B0 30 D1 E1 05 30 43 E2 03 38 A0 E1 03 08 53 E3 02 00 00 9A 00 00 A0 E3 08 40 BD E8 ?? ?? ?? ?? 28 30 D0 E5 00 00 53 E3 09 00 00 0A 28 30 D1 E5 00 00 53 E3 06 00 00 0A 28 00 80 E2 28 10 81 E2 04 20 A0 E3 ?? ?? ?? ?? 01 00 70 E2 00 00 A0 33 F0 FF FF EA 08 00 80 E2 08 10 81 E2 20 20 A0 E3 ?? ?? ?? ?? 01 00 70 E2 00 00 A0 33 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_267_4_0 {
	meta:
		name = "getutline_r_file"
		size = 548
		refs = "0054 alarm 0078 memset 008c __sigaction 00b4 __fcntl_nocancel 0128 strncmp 0140 memcpy 015c __aeabi_read_tp 01f4 __assert_fail 0200 timeout_handler 020c __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 EC 91 9F E5 00 30 99 E5 4D DF 4D E2 00 00 53 E3 00 B0 A0 E1 04 10 8D E5 02 A0 A0 E1 6F 00 00 BA D0 81 9F E5 08 50 88 E2 30 00 95 E8 00 60 E0 E3 00 70 E0 E3 07 00 55 E1 06 00 54 01 00 30 A0 03 00 30 82 05 00 00 E0 03 5E 00 00 0A 00 00 A0 E3 ?? ?? ?? ?? A0 31 9F E5 13 6E 8D E2 18 31 26 E5 00 10 A0 E3 80 20 A0 E3 00 40 A0 E1 1C 00 8D E2 00 50 A0 E3 ?? ?? ?? ?? 06 10 A0 E1 A4 20 8D E2 0E 00 A0 E3 9C 50 8D E5 ?? ?? ?? ?? 0A 00 A0 E3 ?? ?? ?? ?? 08 20 8D E2 00 00 99 E5 07 10 A0 E3 08 50 8D E5 0C 50 8D E5 10 50 8D E5 14 50 8D E5 ?? ?? ?? ?? 05 00 50 E1 00 50 8A B5 35 00 00 BA 08 B0 8B E2 00 00 99 E5 30 11 9F E5 06 2D A0 E3 03 70 A0 E3 00 00 00 EF 01 0A 70 E3 00 50 A0 E1 19 00 00 8A 06 0D 50 E3 17 00 00 1A B0 31 D8 E1 08 70 88 E2 C0 00 97 E8 06 30 43 E2 06 6D 96 E2 03 38 A0 E1 00 70 A7 E2 01 08 53 E3 08 60 88 E5 0C 70 88 E5 EA FF FF 8A 0B 00 A0 E1 E0 10 9F E5 20 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 E4 FF FF 1A 05 20 A0 E1 04 00 9D E5 C0 10 9F E5 ?? ?? ?? ?? 04 30 9D E5 00 30 8A E5 0A 00 00 EA B4 10 9F E5 00 20 E0 E3 00 30 E0 E3 ?? ?? ?? ?? 01 10 9F E7 03 E0 A0 E3 00 C0 A0 E3 08 20 88 E5 0C 30 88 E5 01 E0 80 E7 00 C0 8A E5 8C 30 9F E5 02 C0 A0 E3 13 EE 8D E2 00 00 99 E5 08 20 8D E2 07 10 A0 E3 B3 C0 8E E1 ?? ?? ?? ?? 00 00 A0 E3 ?? ?? ?? ?? A4 10 8D E2 0E 00 A0 E3 00 20 A0 E3 ?? ?? ?? ?? 00 00 54 E3 06 00 00 1A 00 00 9A E5 00 00 50 E3 00 00 A0 13 00 00 E0 03 4D DF 8D E2 F0 4F BD E8 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? F5 FF FF EA 28 00 9F E5 28 10 9F E5 28 20 9F E5 28 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? D8 FE FF FF ?? ?? ?? ?? ?? ?? ?? ?? 59 01 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_267_5_0 {
	meta:
		name = "getutent_r_file"
		size = 488
		refs = "0044 alarm 0068 memset 007c __sigaction 00a4 __fcntl_nocancel 0140 memcpy 01a4 __assert_fail 01b4 __aeabi_read_tp 01cc timeout_handler 01e4 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 B8 A1 9F E5 00 30 9A E5 00 00 53 E3 4B DF 4D E2 00 80 A0 E1 01 90 A0 E1 5C 00 00 BA A0 61 9F E5 08 30 86 E2 0C 00 93 E8 00 40 E0 E3 00 50 E0 E3 05 00 53 E1 04 00 52 01 4E 00 00 0A 00 00 A0 E3 ?? ?? ?? ?? 7C 31 9F E5 4A 5F 8D E2 18 31 25 E5 00 10 A0 E3 80 20 A0 E3 00 B0 A0 E1 14 00 8D E2 00 40 A0 E3 ?? ?? ?? ?? 05 10 A0 E1 9C 20 8D E2 0E 00 A0 E3 94 40 8D E5 ?? ?? ?? ?? 0A 00 A0 E3 ?? ?? ?? ?? 0D 20 A0 E1 00 00 9A E5 07 10 A0 E3 00 40 8D E5 04 40 8D E5 08 40 8D E5 0C 40 8D E5 ?? ?? ?? ?? 04 00 50 E1 04 70 A0 B1 0F 00 00 BA 00 00 9A E5 10 10 86 E2 06 2D A0 E3 03 70 A0 E3 00 00 00 EF 01 0A 70 E3 00 70 A0 E1 34 00 00 8A F4 30 9F E5 02 C0 A0 E3 4A EF 8D E2 00 00 9A E5 0D 20 A0 E1 07 10 A0 E3 B3 C0 8E E1 ?? ?? ?? ?? 00 00 A0 E3 ?? ?? ?? ?? 9C 10 8D E2 0E 00 A0 E3 00 20 A0 E3 ?? ?? ?? ?? 00 00 5B E3 10 00 00 1A 06 0D 57 E3 12 00 00 1A 08 50 86 E2 30 00 95 E8 06 4D 94 E2 00 50 A5 E2 07 20 A0 E1 08 00 A0 E1 98 10 9F E5 08 40 86 E5 0C 50 86 E5 ?? ?? ?? ?? 00 00 A0 E3 00 80 89 E5 4B DF 8D E2 F0 4F BD E8 ?? ?? ?? ?? 0B 00 A0 E1 ?? ?? ?? ?? 06 0D 57 E3 EC FF FF 0A 00 00 57 E3 00 20 E0 13 00 30 E0 13 08 20 86 15 0C 30 86 15 00 30 A0 E3 00 00 E0 E3 00 30 89 E5 4B DF 8D E2 F0 4F BD E8 ?? ?? ?? ?? 3C 00 9F E5 3C 10 9F E5 CC 20 A0 E3 38 30 9F E5 ?? ?? ?? ?? 34 30 9F E5 00 70 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 70 80 E7 00 70 E0 E3 C3 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? D8 FE FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_267_6_0 {
	meta:
		name = "endutent_file"
		size = 80
		refs = "003c __assert_fail"
	strings:
		$1 = { 38 30 9F E5 00 00 93 E5 00 00 50 E3 80 40 2D E9 05 00 00 BA 06 70 A0 E3 00 00 00 EF 00 20 E0 E3 00 20 83 E5 80 40 BD E8 ?? ?? ?? ?? 10 00 9F E5 10 10 9F E5 21 2E A0 E3 0C 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_267_7_0 {
	meta:
		name = "internal_getut_r.constprop.2"
		size = 508
		refs = "0018 alarm 0038 memset 0054 __sigaction 007c __fcntl_nocancel 0100 __aeabi_read_tp 01e4 timeout_handler 01f0 __libc_errno"
	strings:
		$1 = { F0 47 2D E9 00 90 A0 E1 4A DF 4D E2 00 00 A0 E3 01 40 A0 E1 02 A0 A0 E1 ?? ?? ?? ?? C0 31 9F E5 4A 7F 8D E2 18 31 27 E5 00 10 A0 E3 80 20 A0 E3 00 60 A0 E1 14 00 8D E2 ?? ?? ?? ?? 00 50 A0 E3 07 10 A0 E1 9C 20 8D E2 0E 00 A0 E3 94 81 9F E5 94 50 8D E5 ?? ?? ?? ?? 0A 00 A0 E3 ?? ?? ?? ?? 00 00 98 E5 0D 20 A0 E1 07 10 A0 E3 00 50 8D E5 04 50 8D E5 08 50 8D E5 0C 50 8D E5 ?? ?? ?? ?? 05 00 50 E1 01 30 A0 B3 00 30 CA B5 00 40 E0 B3 2B 00 00 BA B0 30 D9 E1 01 30 43 E2 03 38 A0 E1 03 08 53 E3 40 51 9F E5 3B 00 00 8A 09 00 00 EA 08 30 85 E2 0C 00 93 E8 F0 00 D9 E1 F0 10 D4 E1 06 2D 92 E2 00 30 A3 E2 01 00 50 E1 08 20 85 E5 0C 30 85 E5 40 00 00 0A 00 00 98 E5 04 10 A0 E1 06 2D A0 E3 03 70 A0 E3 00 00 00 EF 01 0A 70 E3 01 00 00 8A 06 0D 50 E3 EC FF FF 0A EC 10 9F E5 ?? ?? ?? ?? 01 10 9F E7 00 20 E0 E3 00 30 E0 E3 03 C0 A0 E3 08 20 85 E5 0C 30 85 E5 01 C0 80 E7 00 40 E0 E3 C8 30 9F E5 02 C0 A0 E3 4A EF 8D E2 00 00 98 E5 0D 20 A0 E1 07 10 A0 E3 B3 C0 8E E1 ?? ?? ?? ?? 00 00 A0 E3 ?? ?? ?? ?? 9C 10 8D E2 0E 00 A0 E3 00 20 A0 E3 ?? ?? ?? ?? 00 00 56 E3 06 00 A0 11 ?? ?? ?? ?? 04 00 A0 E1 4A DF 8D E2 F0 47 BD E8 ?? ?? ?? ?? 08 30 85 E2 0C 00 93 E8 06 2D 92 E2 00 30 A3 E2 08 20 85 E5 0C 30 85 E5 60 FE FF EB 00 00 50 E3 0F 00 00 1A 00 00 98 E5 04 10 A0 E1 06 2D A0 E3 03 70 A0 E3 00 00 00 EF 00 30 A0 E1 01 0A 73 E3 09 10 A0 E1 04 00 A0 E1 01 00 00 8A 06 0D 53 E3 EA FF FF 0A 24 10 9F E5 ?? ?? ?? ?? 01 10 9F E7 CA FF FF EA 00 40 A0 E3 CF FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? D8 FE FF FF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_267_8_0 {
	meta:
		name = "getutid_r_file"
		size = 192
		refs = "007c memcpy 00a4 __assert_fail"
	strings:
		$1 = { F0 47 2D E9 9C 30 9F E5 00 30 93 E5 00 00 53 E3 08 D0 4D E2 01 90 A0 E1 02 A0 A0 E1 1C 00 00 BA 84 80 9F E5 08 50 88 E2 30 00 95 E8 00 60 E0 E3 00 70 E0 E3 07 00 55 E1 06 00 54 01 00 30 A0 03 00 30 82 05 00 00 E0 03 0E 00 00 0A 00 40 A0 E3 08 20 8D E2 01 40 62 E5 10 10 88 E2 68 FF FF EB 04 00 50 E1 00 40 8A B5 00 00 E0 B3 05 00 00 BA 10 10 88 E2 09 00 A0 E1 06 2D A0 E3 ?? ?? ?? ?? 00 90 8A E5 04 00 A0 E1 08 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 14 00 9F E5 14 10 9F E5 14 20 9F E5 14 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 3B 01 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_267_9_0 {
	meta:
		name = "pututline_file"
		size = 1536
		refs = "003c strcmp 00c4 __lseek64 0100 __dup2 018c alarm 01ac memset 01c0 __sigaction 01fc __fcntl_nocancel 03cc __aeabi_ldivmod 03f0 __access 04e4 __ftruncate64 0564 __assert_fail 0574 __aeabi_read_tp 05c0 __libc_utmp_file_name 05d8 __have_o_cloexec 05e0 timeout_handler 05f4 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 AC 55 9F E5 00 30 95 E5 00 00 53 E3 B1 DF 4D E2 00 40 A0 E1 4D 01 00 BA 98 65 9F E5 00 30 D6 E5 00 00 53 E3 3C 00 00 1A 8C 85 9F E5 00 70 98 E5 88 15 9F E5 07 00 A0 E1 ?? ?? ?? ?? 00 10 50 E2 E8 00 00 0A 78 15 9F E5 07 00 A0 E1 ?? ?? ?? ?? 00 10 50 E2 03 01 00 0A 68 15 9F E5 07 00 A0 E1 ?? ?? ?? ?? 00 10 50 E2 04 01 00 0A 58 15 9F E5 07 00 A0 E1 ?? ?? ?? ?? 00 10 50 E2 07 00 A0 11 04 01 00 0A 44 15 9F E5 05 70 A0 E3 00 00 00 EF 01 0A 70 E3 00 70 A0 E1 3E 01 00 8A 30 85 9F E5 00 30 98 E5 00 00 53 E3 D4 00 00 DA 01 30 A0 E3 00 30 8D E5 00 20 A0 E3 00 30 A0 E3 00 00 95 E5 ?? ?? ?? ?? 01 30 A0 E1 00 10 A0 E3 00 20 A0 E1 00 10 8D E5 07 00 A0 E1 ?? ?? ?? ?? 00 30 E0 E3 00 20 E0 E3 03 00 51 E1 02 00 50 01 C0 34 9F E5 F0 00 00 0A 00 10 93 E5 07 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 EB 00 00 BA 07 00 A0 E1 06 70 A0 E3 00 00 00 EF 01 30 A0 E3 00 30 C6 E5 08 30 86 E2 0C 00 93 E8 01 00 52 E3 00 00 D3 E2 84 34 9F E5 08 00 00 BA B0 31 D3 E1 B0 20 D4 E1 02 00 53 E1 65 00 00 0A 8C 04 9F E5 04 10 A0 E1 C1 FD FF EB 00 00 50 E3 64 00 00 1A B4 80 8D E2 00 90 A0 E3 08 20 A0 E1 04 00 A0 E1 05 1D 8D E2 B4 90 CD E5 F2 FE FF EB B4 70 DD E5 09 00 57 E1 08 00 8D E5 FD 00 00 1A 07 00 A0 E1 ?? ?? ?? ?? 48 34 9F E5 0B AD 8D E2 98 32 2A E5 07 10 A0 E1 80 20 A0 E3 00 90 A0 E1 2C 00 8D E2 ?? ?? ?? ?? 0A 10 A0 E1 08 20 A0 E1 0E 00 A0 E3 AC 70 8D E5 ?? ?? ?? ?? 0A 00 A0 E3 ?? ?? ?? ?? 18 A0 8D E2 0C 34 9F E5 01 C0 A0 E3 0A 20 A0 E1 00 00 95 E5 07 10 A0 E3 0B BD 8D E2 18 70 8D E5 1C 70 8D E5 20 70 8D E5 24 70 8D E5 B3 C0 8B E1 ?? ?? ?? ?? 00 00 50 E3 5C 00 00 BA 08 B0 9D E5 00 00 5B E3 62 00 00 BA 08 30 86 E2 0C 00 93 E8 06 BD 52 E2 00 C0 C3 E2 00 10 A0 E3 00 00 95 E5 0B 20 A0 E1 0C 30 A0 E1 00 10 8D E5 08 B0 86 E5 0C C0 86 E5 ?? ?? ?? ?? 00 00 95 E5 04 10 A0 E1 06 2D A0 E3 04 70 A0 E3 00 00 00 EF 01 0A 70 E3 C1 00 00 8A 06 0D 50 E3 46 00 00 0A 08 B0 9D E5 00 00 5B E3 00 40 A0 A3 97 00 00 BA 64 33 9F E5 02 C0 A0 E3 0B ED 8D E2 00 00 95 E5 0A 20 A0 E1 07 10 A0 E3 B3 C0 8E E1 ?? ?? ?? ?? 00 00 A0 E3 ?? ?? ?? ?? 08 10 A0 E1 0E 00 A0 E3 00 20 A0 E3 ?? ?? ?? ?? 00 00 59 E3 03 00 00 1A 04 00 A0 E1 B1 DF 8D E2 F0 4F BD E8 ?? ?? ?? ?? 09 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 B1 DF 8D E2 F0 4F BD E8 ?? ?? ?? ?? 01 30 43 E2 03 38 A0 E1 03 08 53 E3 95 FF FF 8A 00 00 A0 E3 ?? ?? ?? ?? E0 32 9F E5 0B AD 8D E2 98 32 2A E5 00 10 A0 E3 80 20 A0 E3 00 90 A0 E1 B4 80 8D E2 2C 00 8D E2 ?? ?? ?? ?? 00 70 A0 E3 0A 10 A0 E1 08 20 A0 E1 0E 00 A0 E3 18 A0 8D E2 AC 70 8D E5 ?? ?? ?? ?? 0A 00 A0 E3 ?? ?? ?? ?? 07 10 A0 E1 10 20 A0 E3 0A 00 A0 E1 ?? ?? ?? ?? 8C 32 9F E5 01 B0 A0 E3 0B CD 8D E2 0A 20 A0 E1 00 00 95 E5 07 10 A0 E3 B3 B0 8C E1 ?? ?? ?? ?? 07 00 50 E1 08 B0 8D A5 A5 FF FF AA 07 40 A0 E1 C4 FF FF EA 08 30 86 E2 0C 00 93 E8 06 2D 92 E2 00 30 A3 E2 08 20 86 E5 0C 30 86 E5 B5 FF FF EA 10 C2 9F E5 02 E0 A0 E3 00 00 9C E5 00 20 A0 E3 00 E0 8D E5 00 30 A0 E3 ?? ?? ?? ?? 06 2D A0 E3 00 30 A0 E3 10 00 8D E5 14 10 8D E5 ?? ?? ?? ?? 03 00 92 E1 10 C0 8D E2 00 18 9C E8 45 00 00 1A 08 B0 86 E5 0C C0 86 E5 95 FF FF EA D8 01 9F E5 ?? ?? ?? ?? 00 00 50 E3 2D 00 00 0A 00 70 98 E5 10 FF FF EA 00 00 95 E5 01 10 A0 E3 00 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 0C 00 00 BA 00 30 98 E5 00 00 53 E3 03 00 00 1A 01 00 10 E3 00 30 E0 03 01 30 A0 13 00 30 88 E5 00 00 53 E3 1B FF FF AA 01 20 80 E3 02 10 A0 E3 00 00 95 E5 ?? ?? ?? ?? 01 00 70 E3 15 FF FF 1A 00 00 95 E5 06 70 A0 E3 00 00 00 EF 00 40 A0 E3 92 FF FF EA 5C 01 9F E5 ?? ?? ?? ?? 00 00 50 E3 14 00 00 0A 00 70 98 E5 F5 FE FF EA 40 01 9F E5 ?? ?? ?? ?? 00 00 50 E3 16 00 00 1A 00 70 98 E5 F4 FE FF EA 2C 01 9F E5 ?? ?? ?? ?? 00 00 50 E3 27 00 00 1A 00 00 98 E5 F4 FE FF EA 10 01 9F E5 F2 FE FF EA 07 00 A0 E1 06 70 A0 E3 00 00 00 EF 00 40 A0 E3 79 FF FF EA F8 00 9F E5 EB FE FF EA 00 00 95 E5 08 30 86 E2 0C 00 93 E8 ?? ?? ?? ?? 00 40 A0 E3 61 FF FF EA CC 00 9F E5 E3 FE FF EA 02 B0 5B E0 03 C0 CC E0 0C 30 A0 E1 08 B0 86 E5 0C C0 86 E5 A4 C0 9F E5 0B 20 A0 E1 00 00 9C E5 ?? ?? ?? ?? 94 E0 9F E5 02 10 A0 E3 00 00 9E E5 00 20 A0 E3 00 10 8D E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 00 20 D1 E2 3F FF FF AA 07 40 A0 E1 4A FF FF EA 74 00 9F E5 CC FE FF EA 8C 00 9F E5 8C 10 9F E5 19 2E A0 E3 88 30 9F E5 ?? ?? ?? ?? 84 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 39 FF FF EA 70 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 0B 20 A0 E3 09 40 A0 E1 03 20 80 E7 46 FF FF EA 58 30 9F E5 00 70 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 70 80 E7 00 40 A0 E3 3F FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 02 00 0A 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 58 FD FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_268_0_0 {
	meta:
		name = "cfsetspeed"
		size = 176
		refs = "0044 __aeabi_read_tp 0068 cfsetispeed 0074 cfsetospeed 00ac __libc_errno"
	strings:
		$1 = { A0 C0 9F E5 70 40 2D E9 00 30 A0 E3 01 40 A0 E1 00 60 A0 E1 0C 10 A0 E1 03 20 8C E0 04 50 92 E5 04 00 55 E1 0D 00 00 0A 01 20 93 E7 04 00 52 E1 08 30 83 E2 12 00 00 0A 01 0C 53 E3 F5 FF FF 1A 64 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 70 40 BD E8 00 00 E0 E3 ?? ?? ?? ?? 04 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 06 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 A0 E3 70 40 BD E8 ?? ?? ?? ?? 05 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 06 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 00 A0 E3 70 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_269_0_0 {
	meta:
		name = "strcpy"
		size = 28
	strings:
		$1 = { 00 20 61 E0 01 10 41 E2 01 30 F1 E5 00 00 53 E3 02 30 C1 E7 FB FF FF 1A ?? ?? ?? ?? }
	condition:
		$1
}

rule file_270_0_0 {
	meta:
		name = "_IO_fflush"
		size = 484
		refs = "001c __aeabi_read_tp 0110 _IO_flush_all 0120 __lll_lock_wait_private 01e0 _Unwind_Resume"
	strings:
		$1 = { F0 41 2D E9 00 50 50 E2 40 00 00 0A 00 40 95 E5 02 49 14 E2 18 00 00 1A 48 60 95 E5 ?? ?? ?? ?? 08 30 96 E5 13 7D 40 E2 07 00 53 E1 0F 00 00 0A 01 10 A0 E3 06 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 2D 00 00 1A 48 30 95 E5 08 70 83 E5 03 60 A0 E1 04 30 96 E5 01 30 83 E2 04 30 86 E5 98 30 95 E5 05 00 A0 E1 30 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 30 95 E5 00 60 50 E2 00 60 E0 13 02 09 13 E3 17 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 11 00 00 1A 08 30 85 E5 00 70 95 E5 00 10 A0 E3 07 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 57 E1 F0 FF FF 1A 01 00 57 E3 08 00 00 CA 06 00 A0 E1 F0 41 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 00 60 A0 E1 F9 FF FF EA 06 00 A0 E1 ?? ?? ?? ?? CE FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF ED FF FF EA 00 30 95 E5 02 09 13 E3 00 80 A0 E1 1F 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 19 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 07 00 00 DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 08 00 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_271_0_0 {
	meta:
		name = "__setgid"
		size = 104
		refs = "0024 __nptl_setxid 0050 __aeabi_read_tp 0064 __libc_errno"
	strings:
		$1 = { 80 40 2D E9 54 30 9F E5 00 00 53 E3 18 D0 4D E2 00 30 A0 E1 06 00 00 0A D6 20 A0 E3 04 00 8D E2 0C 00 8D E9 ?? ?? ?? ?? 18 D0 8D E2 80 40 BD E8 ?? ?? ?? ?? D6 70 A0 E3 00 00 00 EF 01 0A 70 E3 F8 FF FF 9A 18 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 F1 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_272_0_0 {
	meta:
		name = "msort_with_tmp.part.0"
		size = 792
		refs = "00f0 memcpy 02d8 mempcpy"
	strings:
		$1 = { F0 4F 2D E9 A2 60 A0 E1 00 50 90 E5 14 D0 4D E2 01 00 56 E3 04 20 8D E5 00 B0 A0 E1 08 10 8D E5 02 A0 66 E0 96 15 25 E0 06 20 A0 81 F3 FF FF 8B 01 00 5A E3 0B 00 A0 81 05 10 A0 81 0A 20 A0 81 EE FF FF 8B 00 30 9B E5 04 20 9B E5 10 40 9B E5 00 30 8D E5 08 90 9B E5 0C 80 9B E5 03 00 52 E3 02 F1 9F 97 89 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 5A E3 00 00 56 13 9E 00 00 0A 04 C0 84 E2 08 70 9D E5 0C 40 A0 E1 00 00 97 E5 00 10 95 E5 08 20 A0 E1 0F E0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 30 97 D4 04 30 95 C4 01 60 46 D2 01 A0 4A C2 04 30 04 D5 04 30 04 C5 00 00 5A E3 00 00 56 13 04 30 A0 E1 04 40 84 E2 EE FF FF 1A 03 40 A0 E1 00 00 56 E3 28 00 00 0A 00 20 9D E5 04 00 A0 E1 07 10 A0 E1 96 02 02 E0 ?? ?? ?? ?? 22 00 00 EA 0C B0 8D E5 0A B0 A0 E1 00 00 5B E3 00 00 56 13 05 A0 A0 E1 08 70 9D E5 00 50 9D E5 16 00 00 0A 0A 10 A0 E1 07 00 A0 E1 08 20 A0 E1 0F E0 A0 E1 ?? ?? ?? ?? 05 10 84 E0 00 00 50 E3 0A 30 A0 C1 07 30 A0 D1 01 B0 4B C2 05 A0 8A C0 01 60 46 D2 05 70 87 D0 01 00 54 E1 03 00 00 2A 04 20 93 E4 04 20 84 E4 04 00 51 E1 FB FF FF 8A 00 00 5B E3 00 00 56 13 01 40 A0 E1 E8 FF FF 1A 0B A0 A0 E1 0C B0 9D E5 00 00 56 E3 D6 FF FF 1A 04 30 9D E5 03 20 6A E0 00 30 9D E5 08 00 9D E5 93 02 02 E0 10 10 9B E5 ?? ?? ?? ?? 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 00 5A E3 00 00 56 13 51 00 00 0A 08 70 9D E5 08 C0 84 E2 0C B0 8D E5 07 B0 A0 E1 09 70 A0 E1 05 90 A0 E1 0A 50 A0 E1 08 A0 A0 E1 0C 80 A0 E1 07 00 00 EA 0C 00 B9 E8 0C 00 08 E9 01 50 45 E2 00 00 55 E3 00 00 56 13 08 40 A0 E1 08 80 88 E2 41 00 00 0A 0B 00 A0 E1 09 10 A0 E1 0A 20 A0 E1 0F E0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F0 FF FF CA 03 00 BB E8 01 60 46 E2 03 00 08 E9 EF FF FF EA 00 00 5A E3 00 00 56 13 31 00 00 0A 04 C0 84 E2 08 70 9D E5 0C 40 A0 E1 07 00 A0 E1 05 10 A0 E1 08 20 A0 E1 0F E0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 30 97 D4 04 30 95 C4 01 60 46 D2 01 A0 4A C2 04 30 04 D5 04 30 04 C5 00 00 5A E3 00 00 56 13 04 30 A0 E1 04 40 84 E2 EE FF FF 1A 03 40 A0 E1 91 FF FF EA 04 30 A0 E1 08 70 9D E5 09 40 A0 E1 08 90 A0 E1 03 80 A0 E1 0D 00 00 EA 0F E0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 20 9D D5 00 20 9D C5 08 00 A0 E1 07 10 A0 D1 05 10 A0 C1 01 60 46 D2 02 70 87 D0 01 A0 4A C2 02 50 85 C0 ?? ?? ?? ?? 00 80 A0 E1 00 00 5A E3 00 00 56 13 05 10 A0 E1 09 20 A0 E1 07 00 A0 E1 EB FF FF 1A 08 40 A0 E1 9E FF FF EA 08 70 9D E5 9C FF FF EA 0B 70 A0 E1 05 A0 A0 E1 0C B0 9D E5 98 FF FF EA }
	condition:
		$1
}

rule file_272_1_0 {
	meta:
		name = "qsort_r"
		size = 780
		refs = "004c __aeabi_uidiv 0060 __aeabi_read_tp 0074 malloc 0154 memcpy 01dc free 0204 _quicksort 0288 __sysconf 0304 __libc_errno"
	strings:
		$1 = { 20 00 52 E3 F0 4F 2D E9 01 40 A0 91 92 04 04 90 20 B0 8D E2 3C D0 4D E2 48 10 0B E5 02 60 A0 E1 48 20 1B 85 82 41 86 80 01 0B 54 E3 40 00 0B E5 03 70 A0 E1 8A 00 00 3A C0 52 9F E5 00 10 95 E5 00 00 51 E3 8E 00 00 0A 04 00 A0 E1 ?? ?? ?? ?? 04 30 95 E5 03 00 50 E1 63 00 00 8A A0 32 9F E5 ?? ?? ?? ?? 03 30 9F E7 00 50 A0 E1 04 00 A0 E1 03 40 95 E7 ?? ?? ?? ?? 00 00 50 E3 84 32 9F E5 54 00 0B E5 03 30 9F E7 03 40 85 E7 56 00 00 0A 28 00 0B E5 04 20 9B E5 04 30 A0 E3 20 00 56 E3 38 60 0B E5 30 70 0B E5 2C 20 0B E5 34 30 0B E5 57 00 00 9A 48 30 1B E5 28 50 1B E5 03 11 A0 E1 01 50 85 E0 01 30 85 E0 03 00 55 E1 50 30 0B E5 88 00 00 2A 40 30 1B E5 50 00 1B E5 05 20 A0 E1 04 30 82 E4 02 00 50 E1 06 30 83 E0 FB FF FF 8A 28 30 1B E5 01 10 83 E0 48 20 1B E5 03 30 A0 E3 01 00 52 E3 04 20 A0 E3 38 20 0B E5 34 30 0B E5 6E 00 00 9A 38 00 4B E2 48 20 1B E5 F1 FE FF EB 04 30 45 E2 4C 30 0B E5 00 30 A0 E3 40 70 1B E5 44 30 0B E5 4C 30 1B E5 04 40 B3 E5 07 00 54 E1 4C 30 0B E5 1C 00 00 0A 50 00 1B E5 07 10 A0 E1 06 20 A0 E1 ?? ?? ?? ?? 07 90 A0 E1 44 A0 1B E5 02 00 00 EA 04 90 A0 E1 08 A0 A0 E1 03 40 A0 E1 40 20 1B E5 06 10 A0 E1 04 00 62 E0 ?? ?? ?? ?? 06 20 A0 E1 00 80 A0 E1 0A 91 85 E7 09 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 08 31 95 E7 07 00 53 E1 08 21 85 E0 EE FF FF 1A 00 40 82 E5 04 00 A0 E1 50 10 1B E5 06 20 A0 E1 ?? ?? ?? ?? 44 30 1B E5 48 20 1B E5 01 30 83 E2 02 00 53 E1 44 30 0B E5 06 70 87 E0 D6 FF FF 1A 54 00 1B E5 ?? ?? ?? ?? 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 04 20 9B E5 40 00 1B E5 00 20 8D E5 48 10 1B E5 06 20 A0 E1 07 30 A0 E1 ?? ?? ?? ?? 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 03 00 16 E3 08 00 00 1A 40 20 1B E5 03 30 12 E2 05 00 00 1A 04 00 56 E3 02 00 00 0A 08 00 56 E3 29 00 00 0A 02 30 A0 E3 34 30 0B E5 48 20 1B E5 01 00 52 E3 E2 FF FF 9A 38 00 4B E2 40 10 1B E5 A3 FE FF EB 54 00 1B E5 ?? ?? ?? ?? DE FF FF EA 0E 30 84 E2 07 30 C3 E3 03 D0 4D E0 08 30 8D E2 28 30 0B E5 00 30 A0 E3 54 30 0B E5 83 FF FF EA 55 00 A0 E3 ?? ?? ?? ?? 01 00 70 E3 0E 32 E0 03 03 00 00 0A 03 30 80 E2 00 00 50 E3 03 00 A0 B1 40 31 A0 E1 04 30 85 E5 0F CA E0 E3 0F E0 A0 E1 5F F0 4C E2 1E 00 A0 E3 ?? ?? ?? ?? 38 50 9F E5 00 10 A0 E1 00 00 85 E5 5D FF FF EA 48 30 1B E5 00 00 53 E3 90 FF FF 1A BD FF FF EA 40 30 1B E5 07 00 13 E3 01 30 A0 03 34 30 0B 05 D2 FF FF 0A CF FF FF EA 05 10 A0 E1 7D FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_272_2_0 {
	meta:
		name = "qsort"
		size = 32
		refs = "0010 qsort_r"
	strings:
		$1 = { 04 E0 2D E5 00 C0 A0 E3 0C D0 4D E2 00 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1330_0_1 {
	meta:
		name = "__gnu_divda3"
		size = 32
		refs = "0010 __gnu_divhelperda"
	strings:
		$1 = { 04 E0 2D E5 00 C0 A0 E3 0C D0 4D E2 00 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_997_0_1 {
	meta:
		name = "__gnu_divdq3"
		size = 32
		refs = "0010 __gnu_divhelperdq"
	strings:
		$1 = { 04 E0 2D E5 00 C0 A0 E3 0C D0 4D E2 00 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1475_0_1 {
	meta:
		name = "__gnu_mulda3"
		size = 32
		refs = "0010 __gnu_mulhelperda"
	strings:
		$1 = { 04 E0 2D E5 00 C0 A0 E3 0C D0 4D E2 00 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_766_0_1 {
	meta:
		name = "__gnu_muldq3"
		size = 32
		refs = "0010 __gnu_mulhelperdq"
	strings:
		$1 = { 04 E0 2D E5 00 C0 A0 E3 0C D0 4D E2 00 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_983_0_1 {
	meta:
		name = "__gnu_muluda3"
		size = 32
		refs = "0010 __gnu_mulhelperuda"
	strings:
		$1 = { 04 E0 2D E5 00 C0 A0 E3 0C D0 4D E2 00 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1156_0_1 {
	meta:
		name = "__gnu_muludq3"
		size = 32
		refs = "0010 __gnu_mulhelperudq"
	strings:
		$1 = { 04 E0 2D E5 00 C0 A0 E3 0C D0 4D E2 00 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1287_0_1 {
	meta:
		name = "__gnu_udivuda3"
		size = 32
		refs = "0010 __gnu_divhelperuda"
	strings:
		$1 = { 04 E0 2D E5 00 C0 A0 E3 0C D0 4D E2 00 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1549_0_1 {
	meta:
		name = "__gnu_udivudq3"
		size = 32
		refs = "0010 __gnu_divhelperudq"
	strings:
		$1 = { 04 E0 2D E5 00 C0 A0 E3 0C D0 4D E2 00 C0 8D E5 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_274_0_0 {
	meta:
		name = "__nrand48_r"
		size = 56
		refs = "000c __drand48_iterate"
	strings:
		$1 = { 38 40 2D E9 02 50 A0 E1 00 40 A0 E1 ?? ?? ?? ?? 00 00 50 E3 B4 30 D4 A1 B2 20 D4 A1 83 37 A0 A1 A2 30 83 A1 00 30 85 A5 00 00 A0 A3 00 00 E0 B3 38 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_275_0_0 {
	meta:
		name = "__get_sol"
		size = 144
		refs = "007c __assert_fail"
	strings:
		$1 = { 38 40 2D E9 74 30 9F E5 00 50 A0 E1 54 40 83 E2 00 00 E0 E3 02 00 00 EA 0C 30 83 E2 04 00 53 E1 0D 00 00 0A 08 20 13 E5 01 00 72 E3 0E 00 00 0A 00 C0 93 E5 01 00 5C E1 F6 FF FF 1A 04 C0 13 E5 05 00 5C E1 06 00 00 0A 01 00 70 E3 0C 30 83 E2 02 00 A0 01 04 00 53 E1 F1 FF FF 1A 38 40 BD E8 ?? ?? ?? ?? 02 00 A0 E1 FB FF FF EA 10 00 9F E5 10 10 9F E5 45 20 A0 E3 0C 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_275_1_0 {
	meta:
		name = "getsourcefilter"
		size = 356
		refs = "0058 memcpy 006c __get_sol 0090 __getsockopt 00b8 __aeabi_read_tp 00dc free 0130 __libc_alloca_cutoff 0148 malloc 0160 __libc_errno"
	strings:
		$1 = { F0 4B 2D E9 1C B0 8D E2 18 D0 4D E2 08 50 9B E5 00 40 95 E5 84 43 A0 E1 8C 40 84 E2 01 0A 54 E3 00 80 A0 E1 02 60 A0 E1 03 70 A0 E1 20 40 0B E5 3C 00 00 8A 0E 40 84 E2 07 40 C4 E3 04 D0 4D E0 08 40 8D E2 01 90 A0 E3 04 00 A0 E1 04 10 80 E4 07 20 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 30 95 E5 B0 00 D6 E1 07 10 A0 E1 88 30 84 E5 ?? ?? ?? ?? 01 00 70 E3 00 10 A0 E1 0D 00 00 0A 20 30 4B E2 00 30 8D E5 08 00 A0 E1 30 20 A0 E3 04 30 A0 E1 ?? ?? ?? ?? 00 60 50 E2 14 00 00 0A 00 00 59 E3 06 00 A0 11 0B 00 00 0A 1C D0 4B E2 F0 4B BD E8 ?? ?? ?? ?? A4 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 01 60 A0 E1 00 00 59 E3 03 20 80 E7 06 00 A0 11 F3 FF FF 1A 04 00 A0 E1 ?? ?? ?? ?? 06 00 A0 E1 1C D0 4B E2 F0 4B BD E8 ?? ?? ?? ?? 84 30 94 E5 04 20 9B E5 00 30 82 E5 88 30 94 E5 00 20 95 E5 03 00 52 E1 03 20 A0 21 82 23 A0 E1 0C 00 9B E5 8C 10 84 E2 ?? ?? ?? ?? 88 30 94 E5 00 30 85 E5 DC FF FF EA 04 00 A0 E1 28 10 0B E5 ?? ?? ?? ?? 00 90 50 E2 28 10 1B E5 BC FF FF 1A 04 00 A0 E1 28 10 0B E5 ?? ?? ?? ?? 00 40 50 E2 28 10 1B E5 BB FF FF 1A 00 00 E0 E3 D1 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_276_0_0 {
	meta:
		name = "__strfmon"
		size = 76
		refs = "0020 __aeabi_read_tp 0034 __vstrfmon_l 0048 __libc_tsd_LOCALE"
	strings:
		$1 = { 0C 00 2D E9 30 40 2D E9 14 D0 4D E2 24 40 8D E2 0C 40 8D E5 2C 30 9F E5 00 50 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 20 90 E7 20 30 9D E5 00 40 8D E5 05 00 A0 E1 ?? ?? ?? ?? 14 D0 8D E2 30 40 BD E8 08 D0 8D E2 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_278_0_0 {
	meta:
		name = "mknodat"
		size = 52
		refs = "0024 __xmknodat"
	strings:
		$1 = { 04 E0 2D E5 0C D0 4D E2 01 E0 A0 E1 10 C0 8D E2 02 30 A0 E1 00 10 A0 E1 0E 20 A0 E1 00 C0 8D E5 01 00 A0 E3 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_279_0_0 {
	meta:
		name = "__msync_nocancel"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 90 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_279_1_0 {
	meta:
		name = "__libc_msync"
		size = 104
		refs = "0028 __syscall_error 0030 __libc_enable_asynccancel 004c __libc_disable_asynccancel"
	strings:
		$1 = { 60 C0 9F E5 0C C0 9F E7 00 00 3C E3 04 70 2D E5 05 00 00 1A 90 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? 0F 40 2D E9 ?? ?? ?? ?? 00 C0 A0 E1 0F 00 BD E8 90 70 A0 E3 00 00 00 EF 00 70 A0 E1 0C 00 A0 E1 ?? ?? ?? ?? 07 00 A0 E1 04 E0 9D E4 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_280_0_0 {
	meta:
		name = "__sendmsg_nocancel"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 4A 7F A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_280_1_0 {
	meta:
		name = "__libc_sendmsg"
		size = 104
		refs = "0028 __syscall_error 0030 __libc_enable_asynccancel 004c __libc_disable_asynccancel"
	strings:
		$1 = { 60 C0 9F E5 0C C0 9F E7 00 00 3C E3 04 70 2D E5 05 00 00 1A 4A 7F A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? 0F 40 2D E9 ?? ?? ?? ?? 00 C0 A0 E1 0F 00 BD E8 4A 7F A0 E3 00 00 00 EF 00 70 A0 E1 0C 00 A0 E1 ?? ?? ?? ?? 07 00 A0 E1 04 E0 9D E4 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_281_0_0 {
	meta:
		name = "mkostemps64"
		size = 64
		refs = "0014 __gen_tempname 0024 __aeabi_read_tp 003c __libc_errno"
	strings:
		$1 = { 00 00 51 E3 08 40 2D E9 04 00 00 BA 02 28 82 E3 00 30 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? 14 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 00 00 E0 E3 F6 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_283_0_0 {
	meta:
		name = "posix_spawnattr_setflags"
		size = 20
	strings:
		$1 = { 7F 30 D1 E3 B0 10 C0 01 03 00 A0 01 16 00 A0 13 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_284_0_0 {
	meta:
		name = "__fdelt_chk"
		size = 28
		refs = "0018 __chk_fail"
	strings:
		$1 = { 01 0B 50 E3 08 40 2D E9 02 00 00 2A C0 02 A0 E1 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_285_0_0 {
	meta:
		name = "__wmemcpy_chk"
		size = 32
		refs = "0010 memcpy 001c __chk_fail"
	strings:
		$1 = { 02 00 53 E1 08 40 2D E9 03 00 00 3A 02 21 A0 E1 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1012_0_0 {
	meta:
		name = "__wmemmove_chk"
		size = 32
		refs = "0010 memmove 001c __chk_fail"
	strings:
		$1 = { 02 00 53 E1 08 40 2D E9 03 00 00 3A 02 21 A0 E1 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1066_0_0 {
	meta:
		name = "__wmempcpy_chk"
		size = 32
		refs = "0010 mempcpy 001c __chk_fail"
	strings:
		$1 = { 02 00 53 E1 08 40 2D E9 03 00 00 3A 02 21 A0 E1 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_287_0_0 {
	meta:
		name = "strcspn"
		size = 88
		refs = "0038 strchr"
	strings:
		$1 = { 70 40 2D E9 00 30 D0 E5 00 00 53 E3 01 60 A0 E1 0E 00 00 0A 00 50 A0 E1 00 40 A0 E3 03 00 00 EA 01 30 F5 E5 00 00 53 E3 01 40 84 E2 04 00 00 0A 03 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F6 FF FF 0A 04 00 A0 E1 70 40 BD E8 ?? ?? ?? ?? 03 40 A0 E1 FA FF FF EA }
	condition:
		$1
}

rule file_288_0_0 {
	meta:
		name = "__vwprintf_chk"
		size = 556
		refs = "0028 __aeabi_read_tp 00ac _IO_vfwprintf 017c __lll_lock_wait_private 0224 _Unwind_Resume 0228 stdout"
	strings:
		$1 = { F8 4F 2D E9 1C 62 9F E5 00 50 96 E5 00 40 95 E5 02 49 14 E2 00 70 A0 E1 01 A0 A0 E1 02 90 A0 E1 1A 00 00 1A 48 80 95 E5 ?? ?? ?? ?? 08 30 98 E5 13 BD 40 E2 0B 00 53 E1 43 00 00 0A 01 10 A0 E3 08 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 41 00 00 1A 48 30 95 E5 00 00 96 E5 08 B0 83 E5 03 80 A0 E1 04 20 98 E5 01 20 82 E2 04 20 88 E5 00 00 00 EA 05 00 A0 E1 00 00 57 E3 3C 20 90 C5 04 20 82 C3 3C 20 80 C5 0A 10 A0 E1 09 20 A0 E1 ?? ?? ?? ?? 00 00 57 E3 00 30 96 C5 3C 20 93 C5 04 20 C2 C3 3C 20 83 C5 00 20 95 E5 3C 30 95 E5 02 09 12 E3 14 30 C3 E3 00 80 A0 E1 3C 30 85 E5 17 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 11 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 04 00 00 CA 08 00 A0 E1 F8 4F BD E8 ?? ?? ?? ?? 05 00 A0 E1 CA FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF F1 FF FF EA 08 00 A0 E1 ?? ?? ?? ?? BA FF FF EA 3C 30 95 E5 00 20 95 E5 14 30 C3 E3 02 09 12 E3 00 80 A0 E1 3C 30 85 E5 1F 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 19 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 07 00 00 DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 08 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_459_0_0 {
	meta:
		name = "___vprintf_chk"
		size = 556
		refs = "0028 __aeabi_read_tp 00ac vfprintf 017c __lll_lock_wait_private 0224 _Unwind_Resume 0228 stdout"
	strings:
		$1 = { F8 4F 2D E9 1C 62 9F E5 00 50 96 E5 00 40 95 E5 02 49 14 E2 00 70 A0 E1 01 A0 A0 E1 02 90 A0 E1 1A 00 00 1A 48 80 95 E5 ?? ?? ?? ?? 08 30 98 E5 13 BD 40 E2 0B 00 53 E1 43 00 00 0A 01 10 A0 E3 08 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 41 00 00 1A 48 30 95 E5 00 00 96 E5 08 B0 83 E5 03 80 A0 E1 04 20 98 E5 01 20 82 E2 04 20 88 E5 00 00 00 EA 05 00 A0 E1 00 00 57 E3 3C 20 90 C5 04 20 82 C3 3C 20 80 C5 0A 10 A0 E1 09 20 A0 E1 ?? ?? ?? ?? 00 00 57 E3 00 30 96 C5 3C 20 93 C5 04 20 C2 C3 3C 20 83 C5 00 20 95 E5 3C 30 95 E5 02 09 12 E3 14 30 C3 E3 00 80 A0 E1 3C 30 85 E5 17 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 11 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 04 00 00 CA 08 00 A0 E1 F8 4F BD E8 ?? ?? ?? ?? 05 00 A0 E1 CA FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF F1 FF FF EA 08 00 A0 E1 ?? ?? ?? ?? BA FF FF EA 3C 30 95 E5 00 20 95 E5 14 30 C3 E3 02 09 12 E3 00 80 A0 E1 3C 30 85 E5 1F 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 19 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 07 00 00 DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 08 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_289_0_0 {
	meta:
		name = "getprotoent"
		size = 296
		refs = "0060 __nss_getent 0070 __aeabi_read_tp 00e4 __lll_lock_wait_private 0118 __getprotoent_r 0120 __libc_errno"
	strings:
		$1 = { F0 43 2D E9 01 10 A0 E3 0C D0 4D E2 FC 20 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 27 00 00 1A CC 40 9F E5 00 30 A0 E3 04 30 8D E5 00 40 8D E5 01 3B A0 E3 0C 10 44 E2 B8 00 9F E5 B8 20 9F E5 ?? ?? ?? ?? B4 30 9F E5 00 80 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 90 90 E7 10 60 44 E2 00 50 96 E5 00 10 A0 E3 05 40 A0 E1 80 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 0A 00 00 CA 5C 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 90 80 E7 08 00 A0 E1 0C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? D4 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_710_0_0 {
	meta:
		name = "getrpcent"
		size = 296
		refs = "0060 __nss_getent 0070 __aeabi_read_tp 00e4 __lll_lock_wait_private 0118 __getrpcent_r 0120 __libc_errno"
	strings:
		$1 = { F0 43 2D E9 01 10 A0 E3 0C D0 4D E2 FC 20 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 27 00 00 1A CC 40 9F E5 00 30 A0 E3 04 30 8D E5 00 40 8D E5 01 3B A0 E3 0C 10 44 E2 B8 00 9F E5 B8 20 9F E5 ?? ?? ?? ?? B4 30 9F E5 00 80 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 90 90 E7 10 60 44 E2 00 50 96 E5 00 10 A0 E3 05 40 A0 E1 80 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 0A 00 00 CA 5C 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 90 80 E7 08 00 A0 E1 0C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? D4 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_291_0_0 {
	meta:
		name = "__alloc_dir"
		size = 320
		refs = "0028 __fcntl 005c malloc 00f8 __aeabi_read_tp 012c __have_o_cloexec 0138 __libc_errno"
	strings:
		$1 = { F8 40 2D E9 00 60 51 E2 00 40 A0 E1 03 50 A0 E1 1C 00 00 1A 02 07 12 E3 1A 00 00 1A 04 00 A0 E1 02 10 A0 E3 01 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 2D 00 00 BA 00 00 55 E3 E8 00 9F 05 02 59 A0 03 05 00 00 0A 38 50 95 E5 01 06 55 E3 14 00 00 2A 02 09 55 E3 02 59 A0 33 18 00 85 E2 ?? ?? ?? ?? 00 00 50 E3 1B 00 00 0A 00 20 A0 E3 24 00 80 E9 00 40 80 E5 0C 20 80 E5 10 20 80 E5 14 20 80 E5 F8 40 BD E8 ?? ?? ?? ?? 9C 70 9F E5 00 20 97 E5 00 00 52 E3 05 00 00 0A 00 00 52 E3 DE FF FF DA E3 FF FF EA 84 00 9F E5 01 56 A0 E3 EA FF FF EA 04 00 A0 E1 01 10 A0 E3 ?? ?? ?? ?? 01 00 10 E3 01 20 A0 13 00 20 E0 03 00 00 52 E3 00 20 87 E5 D1 FF FF DA D6 FF FF EA 54 00 9F E5 ?? ?? ?? ?? 00 00 50 E3 02 5A A0 13 DE FF FF 1A 00 00 56 E3 0A 00 00 0A 3C 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 20 90 E7 06 70 A0 E3 04 00 A0 E1 00 00 00 EF 24 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 20 80 E7 00 00 A0 E3 D5 FF FF EA 18 80 00 00 ?? ?? ?? ?? 18 00 10 00 18 20 00 00 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_291_1_0 {
	meta:
		name = "__opendirat"
		size = 96
		refs = "0018 __openat_nocancel 0034 __alloc_dir 003c __aeabi_read_tp 005c __libc_errno"
	strings:
		$1 = { 10 40 2D E9 00 30 D1 E5 00 00 53 E3 09 00 00 0A 40 20 9F E5 00 30 A0 E3 ?? ?? ?? ?? 00 00 50 E3 09 00 00 BA 00 20 A0 E3 02 30 A0 E1 01 10 A0 E3 10 40 BD E8 ?? ?? ?? ?? 1C 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 02 20 A0 E3 03 20 80 E7 00 00 A0 E3 10 40 BD E8 ?? ?? ?? ?? 00 48 0A 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_292_0_0 {
	meta:
		name = "__updwtmp"
		size = 236
		refs = "0010 strcmp 007c __access 00e8 __libc_utmp_file_functions"
	strings:
		$1 = { 38 40 2D E9 01 50 A0 E1 C8 10 9F E5 00 40 A0 E1 ?? ?? ?? ?? 00 10 50 E2 16 00 00 0A B8 10 9F E5 04 00 A0 E1 ?? ?? ?? ?? 00 10 50 E2 17 00 00 0A A8 10 9F E5 04 00 A0 E1 ?? ?? ?? ?? 00 10 50 E2 18 00 00 0A 98 10 9F E5 04 00 A0 E1 ?? ?? ?? ?? 00 10 50 E2 19 00 00 0A 04 00 A0 E1 05 10 A0 E1 80 30 9F E5 18 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 38 40 BD E8 ?? ?? ?? ?? 60 00 9F E5 ?? ?? ?? ?? 00 00 50 E3 E4 FF FF 1A 50 40 9F E5 F1 FF FF EA 4C 00 9F E5 ?? ?? ?? ?? 00 00 50 E3 E3 FF FF 1A 3C 40 9F E5 EB FF FF EA 30 00 9F E5 ?? ?? ?? ?? 00 00 50 E3 E2 FF FF 0A 18 40 9F E5 E5 FF FF EA 1C 00 9F E5 ?? ?? ?? ?? 0C 30 9F E5 00 00 50 E3 03 40 A0 11 DF FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_293_0_0 {
	meta:
		name = "__fchdir"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 85 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_294_0_0 {
	meta:
		name = "__clock_gettime"
		size = 116
		refs = "003c __aeabi_read_tp 006c __libc_errno"
	strings:
		$1 = { 01 00 50 E3 80 40 2D E9 58 70 9F E5 04 00 00 8A 00 00 00 EF 01 0A 70 E3 0B 00 00 8A 80 40 BD E8 ?? ?? ?? ?? 00 00 00 EF 01 0A 70 E3 FA FF FF 9A 34 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 F3 FF FF EA 1C 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 EC FF FF EA 07 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_295_0_0 {
	meta:
		name = "__assert_fail_base"
		size = 400
		refs = "002c pthread_setcancelstate 007c __asprintf 0094 __fxprintf 00a0 _IO_fflush 00dc __mmap 00f8 strcpy 0148 __munmap 0150 free 0154 abort 0164 __libc_write 0170 __progname 0180 stderr 0184 _dl_pagesize 0188 __abort_msg"
	strings:
		$1 = { 80 40 2D E9 60 C1 9F E5 20 D0 4D E2 00 00 5C E3 00 50 A0 E1 01 60 A0 E1 02 70 A0 E1 03 80 A0 E1 28 40 9D E5 01 00 A0 13 00 10 A0 13 ?? ?? ?? ?? 38 31 9F E5 00 20 93 E5 00 30 D2 E5 30 C1 9F E5 30 E1 9F E5 00 00 53 E3 0E 30 A0 01 0C 30 A0 11 00 00 54 E3 0E 40 A0 01 04 C0 A0 01 1C 00 8D E2 14 00 8D E5 80 01 8D E8 08 40 8D E5 0C C0 8D E5 10 60 8D E5 05 10 A0 E1 18 00 8D E2 ?? ?? ?? ?? 00 00 50 E3 33 00 00 BA EC 10 9F E5 18 20 9D E5 00 00 A0 E3 ?? ?? ?? ?? E0 30 9F E5 00 00 93 E5 ?? ?? ?? ?? D8 30 9F E5 1C C0 9D E5 00 30 93 E5 0C C0 83 E0 00 30 63 E2 03 C0 0C E0 00 00 A0 E3 00 30 E0 E3 00 30 8D E5 0C 10 A0 E1 04 00 8D E5 03 20 A0 E3 22 30 A0 E3 1C C0 8D E5 ?? ?? ?? ?? 01 00 70 E3 00 60 A0 E1 17 00 00 0A 1C 30 9D E5 18 10 9D E5 04 30 80 E4 ?? ?? ?? ?? 84 70 9F E5 00 50 97 E5 06 10 A0 E1 05 40 A0 E1 74 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 00 00 55 E3 05 00 A0 11 00 10 95 15 ?? ?? ?? ?? 18 00 9D E5 ?? ?? ?? ?? ?? ?? ?? ?? 2C 10 9F E5 12 20 A0 E3 02 00 A0 E3 ?? ?? ?? ?? F9 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_295_1_0 {
	meta:
		name = "__assert_fail"
		size = 68
		refs = "0024 __dcgettext 0038 __assert_fail_base 0040 _libc_intl_domainname"
	strings:
		$1 = { 80 40 2D E9 00 60 A0 E1 03 70 A0 E1 08 D0 4D E2 01 50 A0 E1 02 40 A0 E1 1C 10 9F E5 05 20 A0 E3 18 00 9F E5 ?? ?? ?? ?? 00 70 8D E5 06 10 A0 E1 05 20 A0 E1 04 30 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_298_0_0 {
	meta:
		name = "getpgrp"
		size = 20
	strings:
		$1 = { 04 70 2D E5 41 70 A0 E3 00 00 00 EF 04 70 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_299_0_0 {
	meta:
		name = "__lll_lock_wait_private"
		size = 156
		refs = "0040 __aeabi_read_tp"
	strings:
		$1 = { B0 40 2D E9 00 50 A0 E1 02 10 A0 E3 05 20 A0 E1 01 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 06 00 00 0A ?? ?? ?? ?? B8 14 10 E5 02 20 A0 E3 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 02 10 A0 E3 05 20 A0 E1 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 DC FF FF 1A B0 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_300_0_0 {
	meta:
		name = "setegid"
		size = 176
		refs = "0038 __nptl_setxid 0054 __aeabi_read_tp 00a8 __libc_errno"
	strings:
		$1 = { 80 40 2D E9 01 00 70 E3 18 D0 4D E2 00 10 A0 E1 0E 00 00 0A 88 30 9F E5 00 00 53 E3 11 00 00 0A 00 30 E0 E3 D2 20 A0 E3 04 00 8D E2 0C 10 8D E5 0C 00 8D E9 10 30 8D E5 ?? ?? ?? ?? 00 10 A0 E1 01 00 A0 E1 18 D0 8D E2 80 40 BD E8 ?? ?? ?? ?? 50 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 F5 FF FF EA 00 00 E0 E3 00 20 A0 E1 D2 70 A0 E3 00 00 00 EF 01 0A 70 E3 01 00 00 8A 00 10 A0 E1 ED FF FF EA 1C 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 F6 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_301_0_0 {
	meta:
		name = "creat64"
		size = 28
		refs = "000c __open64"
	strings:
		$1 = { 08 40 2D E9 01 20 A0 E1 08 10 9F E5 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? 41 02 00 00 }
	condition:
		$1
}

rule file_302_0_0 {
	meta:
		name = "__printf_fphex"
		size = 5092
		refs = "0034 __aeabi_read_tp 0080 __isnan 0094 __isinf 0128 _IO_padn 02d8 __woverflow 0348 __signbit 0388 _itowa 03b4 _itoa 04ac _itoa_word 0548 strlen 0590 _IO_wpadn 0914 __overflow 0fe4 _nl_current_LC_NUMERIC 0fe8 __libc_tsd_CTYPE_B 0ffc _nl_current_LC_MONETARY 1018 _itowa_lower_digits 1020 _dl_hwcap 1024 __libc_tsd_CTYPE_TOLOWER 115c abort 11bc __assert_fail"
	strings:
		$1 = { F0 4F 2D E9 0D 80 D1 E5 00 60 A0 E1 00 00 91 E5 43 DF 4D E2 01 00 18 E3 28 81 A0 E1 01 70 A0 E1 01 80 08 E2 18 00 8D E5 04 90 91 E5 79 00 00 1A AC 3F 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 00 30 93 E5 24 B0 93 E5 30 30 93 E5 14 30 8D E5 00 30 DB E5 00 00 53 E3 53 04 00 0A 14 10 9D E5 00 00 51 E3 50 04 00 0A 00 30 92 E5 30 00 93 E8 04 00 A0 E1 05 10 A0 E1 40 40 8D E5 44 50 8D E5 ?? ?? ?? ?? 00 00 50 E3 6B 00 00 1A 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 00 A0 50 E2 A7 00 00 0A 40 3F 9F E5 ?? ?? ?? ?? 03 30 9F E7 08 20 97 E5 03 30 90 E7 82 20 A0 E1 B2 00 93 E1 28 BF 9F E5 01 0C 00 E2 24 1F 9F E5 24 2F 9F E5 24 3F 9F E5 00 00 50 E3 AA 5F A0 E1 01 B0 A0 11 02 A0 A0 01 03 A0 A0 11 00 00 55 E3 0C 30 D7 E5 01 00 00 1A 50 00 13 E3 00 00 00 0A 01 90 49 E2 A3 42 A0 E1 01 40 14 E2 03 90 49 E2 5D 00 00 1A 00 00 59 E3 08 00 00 DA 00 00 58 E3 06 00 A0 E1 20 10 A0 E3 09 20 A0 E1 19 02 00 1A ?? ?? ?? ?? 09 00 50 E1 09 40 A0 01 E8 01 00 1A 00 00 55 E3 53 00 00 0A 00 00 58 E3 E8 01 00 0A 5C 30 96 E5 00 00 53 E3 2E 04 00 0A 10 20 93 E5 14 10 93 E5 01 00 52 E1 04 00 82 32 2D 10 A0 33 10 00 83 35 00 10 82 35 26 04 00 2A 01 40 84 E2 00 00 58 E3 5A 00 00 0A 03 A0 84 E2 04 50 A0 E1 5C 30 96 E5 00 00 53 E3 04 10 9B E4 12 04 00 0A 10 20 93 E5 14 00 93 E5 00 00 52 E1 0E 04 00 2A 04 00 82 E2 10 00 83 E5 01 00 71 E3 00 10 82 E5 00 00 A0 13 01 00 A0 03 00 00 50 E3 C4 01 00 1A 01 50 85 E2 0A 00 55 E1 EC FF FF 1A 0C 30 D7 E5 20 00 13 E3 53 00 00 0A 00 00 59 E3 51 00 00 DA 00 00 58 E3 06 00 A0 E1 20 10 A0 E3 09 20 A0 E1 E2 01 00 1A ?? ?? ?? ?? 09 00 50 E1 B4 01 00 1A 00 00 85 E0 43 DF 8D E2 F0 4F BD E8 ?? ?? ?? ?? DC 3D 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 00 30 93 E5 2C B0 93 E5 D0 30 93 E5 14 30 8D E5 84 FF FF EA BC 3D 9F E5 ?? ?? ?? ?? 03 30 9F E7 08 20 97 E5 03 30 90 E7 82 20 A0 E1 B2 10 93 E1 A4 BD 9F E5 01 1C 01 E2 A0 2D 9F E5 A0 AD 9F E5 A0 3D 9F E5 47 50 DD E5 00 00 51 E3 02 B0 A0 01 03 A0 A0 01 A5 53 A0 E1 97 FF FF EA 00 00 55 E3 00 40 A0 E3 AB FF FF 1A 0C 30 D7 E5 40 00 13 E3 A4 01 00 0A 00 00 58 E3 BC 01 00 0A 5C 30 96 E5 00 00 53 E3 07 00 00 0A 10 20 93 E5 14 10 93 E5 01 00 52 E1 04 00 82 32 2B 10 A0 33 10 00 83 35 00 10 82 35 A8 FF FF 3A 06 00 A0 E1 2B 10 A0 E3 ?? ?? ?? ?? 01 00 70 E3 00 00 A0 13 01 00 A0 03 8D 01 00 EA 04 50 A0 E1 0A A0 64 E0 03 40 84 E2 14 30 96 E5 18 20 96 E5 05 10 DA E7 02 00 53 E1 01 20 83 32 14 20 86 35 00 10 C3 35 B8 03 00 2A 01 50 85 E2 04 00 55 E1 F4 FF FF 1A 0C 30 D7 E5 20 00 13 E3 AB FF FF 1A 05 00 A0 E1 43 DF 8D E2 F0 4F BD E8 ?? ?? ?? ?? 05 10 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 44 30 9D E5 08 20 97 E5 FF 54 C3 E3 40 30 9D E5 03 40 8A E1 41 30 52 E2 00 20 73 E2 03 20 B2 E0 0F 56 C5 E3 20 00 8D E5 05 10 A0 E1 00 20 8D E5 10 30 A0 E3 42 2F 8D E2 04 00 A0 E1 ?? ?? ?? ?? 08 30 97 E5 41 20 53 E2 00 30 72 E2 02 30 B3 E0 00 A0 A0 E1 00 30 8D E5 04 00 A0 E1 05 10 A0 E1 88 20 8D E2 10 30 A0 E3 ?? ?? ?? ?? D4 C0 8D E2 0C 00 5A E1 1C 00 8D E5 14 00 00 9A 1C 20 9D E5 0C C0 E0 E1 0A C0 8C E0 01 00 42 E2 2C C1 A0 E1 02 30 A0 E1 00 00 6C E0 0A 10 A0 E1 30 20 A0 E3 04 20 21 E5 01 20 63 E5 00 00 53 E1 FB FF FF 1A 0C 31 A0 E1 03 30 23 E2 03 30 E0 E1 03 A0 8A E0 1C 30 9D E5 0C C0 E0 E1 0C 30 83 E0 1C 30 8D E5 B6 34 DD E1 05 00 94 E1 83 38 A0 E1 00 20 A0 13 01 20 A0 03 A3 3A B0 E1 75 01 00 0A D4 1B 9F E5 01 00 53 E1 2E 02 00 DA FF 3F 43 E2 03 30 43 E2 00 00 A0 E3 24 30 8D E5 30 00 8D E5 00 00 52 E3 31 30 A0 03 2C 30 8D 05 71 01 00 0A 31 20 A0 E3 24 50 9D E5 2C 20 8D E5 18 00 9D E5 01 00 70 E3 1C 10 9D 15 1C 20 9D 05 00 30 A0 03 28 10 8D 15 28 20 8D 05 18 30 8D 05 3D 00 8D E2 34 00 8D E5 00 10 A0 E1 0A 20 A0 E3 05 00 A0 E1 00 30 A0 E3 ?? ?? ?? ?? 60 CB 9F E5 24 00 8D E5 5C 0B 9F E5 64 20 8D E2 90 15 83 E0 A3 31 A0 E1 03 11 83 E0 81 50 45 E0 05 11 9C E7 00 50 53 E2 02 40 A0 E1 00 10 82 E5 04 20 42 E2 F5 FF FF 1A 20 20 9D E5 24 30 9D E5 34 00 9D E5 00 00 52 E3 03 C0 60 E0 03 20 E0 13 0C 30 D7 E5 02 00 00 1A 50 00 13 E3 03 20 E0 13 02 20 E0 03 18 10 9D E5 02 20 61 E0 02 20 42 E2 02 C0 8C E0 00 00 51 E3 09 C0 8C E0 EB 01 00 DA 00 00 58 E3 01 00 A0 13 05 00 00 1A 0B 00 A0 E1 10 30 8D E5 0C C0 8D E5 ?? ?? ?? ?? 10 30 9D E5 0C C0 9D E5 0C C0 60 E0 A3 32 A0 E1 01 90 13 E2 95 01 00 1A 10 30 97 E5 30 00 53 E3 0C 00 00 0A 00 00 5C E3 0A 00 00 DA 00 00 58 E3 06 00 A0 E1 20 10 A0 E3 0C 20 A0 E1 0C C0 8D E5 5A 02 00 0A ?? ?? ?? ?? 0C C0 9D E5 0C 00 50 E1 CE 00 00 1A 0C 90 A0 E1 20 20 9D E5 00 00 52 E3 84 01 00 0A 00 00 58 E3 E9 01 00 0A 5C 30 96 E5 00 00 53 E3 63 03 00 0A 10 20 93 E5 14 10 93 E5 01 00 52 E1 04 00 82 32 2D 10 A0 33 10 00 83 35 00 10 82 35 5B 03 00 2A 01 90 89 E2 00 00 58 E3 8F 01 00 0A 5C 30 96 E5 00 00 53 E3 49 03 00 0A 10 20 93 E5 14 10 93 E5 01 00 52 E1 04 00 82 32 30 10 A0 33 10 00 83 35 00 10 82 35 41 03 00 2A 08 10 97 E5 00 00 58 E3 17 10 81 E2 93 01 00 0A 5C 30 96 E5 00 00 53 E3 54 03 00 0A 10 20 93 E5 14 00 93 E5 00 00 52 E1 50 03 00 2A 04 00 82 E2 10 00 83 E5 01 00 71 E3 00 10 82 E5 00 00 A0 13 01 00 A0 03 00 00 50 E3 9C 00 00 1A 0C 30 D7 E5 20 00 13 E3 02 90 89 E2 02 00 00 1A 10 10 97 E5 30 00 51 E3 2B 02 00 0A 00 00 58 E3 8B 01 00 0A 5C 30 96 E5 00 00 53 E3 49 03 00 0A 10 20 93 E5 14 10 93 E5 01 00 52 E1 45 03 00 2A 04 10 82 E2 10 10 83 E5 2C 30 9D E5 00 30 82 E5 18 10 9D E5 00 00 51 E3 01 50 89 E2 B0 01 00 DA 00 00 58 E3 28 01 00 1A 0B 00 A0 E1 0C C0 8D E5 ?? ?? ?? ?? 00 00 50 E3 0C C0 9D E5 00 90 A0 11 0A 00 00 0A 14 30 96 E5 18 20 96 E5 01 10 DB E4 02 00 53 E1 01 20 83 32 14 20 86 35 00 10 C3 35 EE 02 00 2A 01 90 59 E2 01 50 85 E2 F4 FF FF 1A 18 00 9D E5 00 00 50 E3 22 00 00 DA 28 10 9D E5 1C 20 9D E5 01 B0 62 E0 00 00 5B E1 00 B0 A0 A1 02 90 61 E0 00 00 58 E3 00 90 89 E0 94 01 00 1A 00 00 5B E3 0C 00 00 0A 1C 30 9D E5 03 A0 65 E0 14 30 96 E5 18 20 96 E5 05 10 DA E7 02 00 53 E1 01 20 83 32 14 20 86 35 00 10 C3 35 B5 02 00 2A 01 B0 5B E2 01 50 85 E2 F4 FF FF 1A 00 00 59 E3 9A 01 00 DA 06 00 A0 E1 30 10 A0 E3 09 20 A0 E1 0C C0 8D E5 ?? ?? ?? ?? 0C C0 9D E5 09 00 50 E1 4B 00 00 1A 00 50 85 E0 08 10 97 E5 00 00 58 E3 0F 10 81 E2 8F 01 00 0A 5C 30 96 E5 00 00 53 E3 C5 02 00 0A 10 20 93 E5 14 00 93 E5 00 00 52 E1 C1 02 00 2A 04 00 82 E2 10 00 83 E5 01 00 71 E3 00 10 82 E5 00 00 A0 13 01 00 A0 03 00 00 50 E3 37 00 00 1A 30 00 9D E5 00 00 50 E3 2B 10 A0 03 2D 10 A0 13 00 00 58 E3 90 01 00 0A 5C 30 96 E5 00 00 53 E3 B8 02 00 0A 10 20 93 E5 14 00 93 E5 00 00 52 E1 04 00 82 32 10 00 83 35 00 10 82 35 B1 02 00 2A 34 10 9D E5 24 30 9D E5 00 00 58 E3 02 50 85 E2 01 90 63 E0 91 01 00 1A 00 00 59 E3 0E 00 00 0A 09 40 A0 E1 24 90 9D E5 0C A0 A0 E1 14 30 96 E5 18 20 96 E5 01 10 D9 E4 02 00 53 E1 01 20 83 32 14 20 86 35 00 10 C3 35 C8 02 00 2A 01 40 54 E2 01 50 85 E2 F4 FF FF 1A 0A C0 A0 E1 0C 30 D7 E5 20 00 13 E3 A2 FE FF 0A 10 10 97 E5 30 00 51 E3 9F FE FF 0A 00 00 5C E3 9D FE FF DA 00 00 58 E3 06 00 A0 E1 0C 20 A0 E1 0C C0 8D E5 34 02 00 0A ?? ?? ?? ?? 0C C0 9D E5 0C 00 50 E1 4A FE FF 0A 00 00 E0 E3 43 DF 8D E2 F0 4F BD E8 ?? ?? ?? ?? 14 30 96 E5 18 20 96 E5 02 00 53 E1 01 10 83 32 2D 20 A0 33 14 10 86 35 00 20 C3 35 19 FE FF 3A 06 00 A0 E1 2D 10 A0 E3 ?? ?? ?? ?? 01 00 70 E3 00 00 A0 13 01 00 A0 03 00 00 50 E3 EB FF FF 1A 10 FE FF EA 10 00 13 E3 0F FE FF 0A 00 00 58 E3 24 00 00 0A 5C 30 96 E5 00 00 53 E3 07 00 00 0A 10 20 93 E5 14 10 93 E5 01 00 52 E1 04 00 82 32 20 10 A0 33 10 00 83 35 00 10 82 35 01 FE FF 3A 06 00 A0 E1 20 10 A0 E3 ?? ?? ?? ?? 01 00 70 E3 00 00 A0 13 01 00 A0 03 E6 FF FF EA ?? ?? ?? ?? 1B FE FF EA ?? ?? ?? ?? E4 FD FF EA 14 30 96 E5 18 20 96 E5 02 00 53 E1 01 10 83 32 2B 20 A0 33 14 10 86 35 00 20 C3 35 EE FD FF 3A 06 00 A0 E1 2B 10 A0 E3 ?? ?? ?? ?? 01 00 70 E3 00 00 A0 13 01 00 A0 03 D3 FF FF EA 14 30 96 E5 18 20 96 E5 02 00 53 E1 01 10 83 32 20 20 A0 33 14 10 86 35 00 20 C3 35 DF FD FF 3A 06 00 A0 E1 20 10 A0 E3 ?? ?? ?? ?? 01 00 70 E3 00 00 A0 13 01 00 A0 03 C4 FF FF EA 00 00 52 E3 B4 00 00 1A F4 25 9F E5 30 10 A0 E3 01 30 A0 E3 2C 10 8D E5 24 20 8D E5 30 30 8D E5 04 31 9D E5 30 00 53 E3 BA 01 00 1A 88 00 8D E2 28 00 8D E5 41 3F 8D E2 00 20 A0 E1 04 10 33 E5 30 00 51 E3 01 20 42 E2 FB FF FF 0A 28 20 8D E5 18 20 9D E5 01 00 72 E3 F4 00 00 0A 28 00 9D E5 1C 10 9D E5 00 30 61 E0 03 00 52 E1 3A 00 00 AA 18 20 9D E5 00 00 52 E3 18 00 8D C2 03 00 90 C8 01 20 80 C0 2C E0 9D D5 01 E0 52 C5 41 20 4E E2 FF 20 02 E2 05 00 52 E3 1C 00 9D E5 18 20 9D E5 37 E0 4E 92 02 C0 D0 E7 04 00 00 9A 61 20 4E E2 FF 20 02 E2 05 00 52 E3 57 E0 4E 92 30 E0 4E 82 41 20 4C E2 05 00 52 E3 37 C0 4C 92 03 00 00 9A 61 20 4C E2 05 00 52 E3 57 C0 4C 92 30 C0 4C 82 07 00 1C E3 01 40 A0 13 04 00 00 1A 18 10 9D E5 01 40 81 E2 04 00 53 E1 00 40 A0 D3 01 40 A0 C3 08 35 9F E5 03 00 93 E8 40 20 A0 E3 00 30 A0 E3 00 20 02 E0 01 30 03 E0 03 00 92 E1 0D 01 00 0A 10 3A F1 EE 20 10 9D E5 07 00 5C E3 03 35 03 E2 00 C0 A0 D3 01 C0 A0 C3 00 20 91 E2 01 20 A0 13 01 05 53 E3 7D 01 00 0A 98 01 00 DA 02 05 53 E3 76 01 00 0A 03 05 53 E3 7B 01 00 1A 24 50 9D E5 47 FE FF EA 5C 30 96 E5 00 00 53 E3 AA 01 00 0A 10 20 93 E5 14 10 93 E5 01 00 52 E1 A6 01 00 2A 04 10 82 E2 10 10 83 E5 14 30 9D E5 01 00 73 E3 00 30 82 E5 00 00 A0 13 01 00 A0 03 00 00 50 E3 49 FF FF 1A 02 50 89 E2 D6 FE FF EA 00 90 A0 E3 77 FE FF EA 0C 30 D7 E5 40 00 13 E3 51 00 00 0A 00 00 58 E3 CB 00 00 0A 5C 30 96 E5 00 00 53 E3 07 00 00 0A 10 20 93 E5 14 10 93 E5 01 00 52 E1 04 00 82 32 2B 10 A0 33 10 00 83 35 00 10 82 35 77 FE FF 3A 06 00 A0 E1 2B 10 A0 E3 0C C0 8D E5 ?? ?? ?? ?? 0C C0 9D E5 01 00 70 E3 00 00 A0 13 01 00 A0 03 00 00 50 E3 2B FF FF 1A 6C FE FF EA 14 30 96 E5 18 20 96 E5 02 00 53 E1 01 10 83 32 30 20 A0 33 14 10 86 35 00 20 C3 35 72 FE FF 3A 06 00 A0 E1 30 10 A0 E3 0C C0 8D E5 ?? ?? ?? ?? 0C C0 9D E5 01 00 70 E3 00 00 A0 13 01 00 A0 03 00 00 50 E3 18 FF FF 1A 67 FE FF EA 14 30 96 E5 18 20 96 E5 02 00 53 E1 01 20 83 32 14 20 86 35 00 10 C3 35 73 FE FF 3A FF 10 01 E2 06 00 A0 E1 0C C0 8D E5 ?? ?? ?? ?? 01 00 70 E3 00 00 A0 13 01 00 A0 03 0C C0 9D E5 68 FE FF EA 14 30 96 E5 18 20 96 E5 02 00 53 E1 A4 01 00 2A 2C 00 9D E5 01 20 83 E2 14 20 86 E5 00 00 C3 E5 75 FE FF EA 08 00 13 E3 1B FE FF 0A 10 FE FF EA 03 50 A0 E1 30 30 8D E5 30 30 A0 E3 2C 30 8D E5 DC FD FF EA FF 3F 63 E2 03 30 83 E2 01 10 A0 E3 24 30 8D E5 30 10 8D E5 CF FD FF EA 10 00 13 E3 31 FE FF 0A 00 00 58 E3 E1 00 00 0A 5C 30 96 E5 00 00 53 E3 07 00 00 0A 10 20 93 E5 14 10 93 E5 01 00 52 E1 04 00 82 32 20 10 A0 33 10 00 83 35 00 10 82 35 23 FE FF 3A 06 00 A0 E1 20 10 A0 E3 AA FF FF EA 14 30 96 E5 18 20 96 E5 02 00 53 E1 06 00 A0 21 2D 10 A0 23 D7 00 00 2A 01 10 83 E2 2D 20 A0 E3 14 10 86 E5 00 20 C3 E5 15 FE FF EA 0C 30 D7 E5 08 00 13 E3 85 FE FF 0A 4A FE FF EA 00 00 5B E3 03 00 00 1A 3E 01 00 EA 01 B0 5B E2 01 50 85 E2 3B 01 00 0A 5C 30 96 E5 00 00 53 E3 04 10 9A E4 2F 01 00 0A 10 20 93 E5 14 00 93 E5 00 00 52 E1 2B 01 00 2A 04 00 82 E2 10 00 83 E5 01 00 71 E3 00 10 82 E5 00 00 A0 13 01 00 A0 03 00 00 50 E3 EC FF FF 0A B8 FE FF EA 08 10 97 E5 0F 10 81 E2 14 30 96 E5 18 20 96 E5 02 00 53 E1 01 20 83 32 14 20 86 35 00 10 C3 35 77 FE FF 3A FF 10 01 E2 06 00 A0 E1 0C C0 8D E5 ?? ?? ?? ?? 01 00 70 E3 00 00 A0 13 01 00 A0 03 0C C0 9D E5 6C FE FF EA 28 10 9D E5 1C 20 9D E5 01 10 62 E0 24 50 9D E5 18 10 8D E5 8E FD FF EA 14 30 96 E5 18 20 96 E5 02 00 53 E1 01 20 83 32 14 20 86 35 00 10 C3 35 71 FE FF 3A 06 00 A0 E1 0C C0 8D E5 ?? ?? ?? ?? 0C C0 9D E5 01 00 70 E3 00 00 A0 13 01 00 A0 03 00 00 50 E3 90 FE FF 1A 67 FE FF EA 00 00 59 E3 7C FE FF 0A 0C A0 A0 E1 02 00 00 EA 01 90 59 E2 01 50 85 E2 76 FE FF 0A 5C 30 96 E5 00 00 53 E3 04 10 94 E4 E8 00 00 0A 10 20 93 E5 14 00 93 E5 00 00 52 E1 E4 00 00 2A 04 00 82 E2 10 00 83 E5 01 00 71 E3 00 10 82 E5 00 00 A0 13 01 00 A0 03 00 00 50 E3 EC FF FF 0A 77 FE FF EA ?? ?? ?? ?? 0C C0 9D E5 A3 FD FF EA 14 30 96 E5 18 20 96 E5 02 00 53 E1 06 00 A0 21 2B 10 A0 23 6D 00 00 2A 01 10 83 E2 2B 20 A0 E3 14 10 86 E5 00 20 C3 E5 AB FD FF EA 00 00 5C E3 D1 FD FF DA 00 00 58 E3 06 00 A0 E1 0C 20 A0 E1 0C C0 8D E5 78 00 00 0A ?? ?? ?? ?? 0C C0 9D E5 0C 00 50 E1 5E FE FF 1A 0C 90 89 E0 C6 FD FF EA 07 00 5C E3 01 E0 0E E2 00 C0 A0 D3 01 C0 A0 C3 00 00 5C E3 04 40 8E 11 F9 FE FF 0A 00 00 54 E3 F7 FE FF 0A 18 00 9D E5 01 30 50 E2 38 00 00 4A 1C 10 9D E5 03 20 D1 E7 39 00 52 E3 03 40 81 E0 59 00 00 0A 70 10 9F E5 ?? ?? ?? ?? 01 10 9F E7 01 10 90 E7 02 11 91 E7 65 00 51 E3 4B 00 00 DA 18 20 9D E5 1C 00 9D E5 02 10 42 E2 01 10 80 E0 30 50 A0 E3 34 B0 8D E5 20 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_303_0_0 {
	meta:
		name = "__sched_setscheduler"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 9C 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_304_0_0 {
	meta:
		name = "_dl_runtime_resolve"
		size = 36
		refs = "0014 _dl_fixup"
	strings:
		$1 = { 1F 00 2D E9 04 00 1E E5 0E 10 4C E0 04 10 41 E2 01 10 81 E0 ?? ?? ?? ?? 00 C0 A0 E1 1F 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_304_1_0 {
	meta:
		name = "_dl_runtime_profile"
		size = 196
		refs = "003c _dl_profile_fixup 007c memcpy 00a8 _dl_call_pltexit"
	strings:
		$1 = { C4 D0 4D E2 0F 00 8D E8 10 D0 4D E2 D8 00 8D E2 20 00 8D E5 D4 20 9D E5 24 20 8D E5 04 00 1E E5 0E 10 4C E0 04 10 41 E2 01 10 81 E0 08 30 8D E2 03 00 A3 E8 D0 C0 8D E2 00 C0 8D E5 ?? ?? ?? ?? D0 C0 9D E5 00 00 5C E3 03 00 00 AA 00 C0 A0 E1 10 D0 8D E2 0F 60 9D E8 ?? ?? ?? ?? D4 70 8D E5 38 70 4D E2 0C D0 4D E0 07 D0 CD E3 08 01 87 E5 0D 00 A0 E1 11 1E 87 E2 0C 20 A0 E1 ?? ?? ?? ?? 48 C0 87 E2 0F 00 9C E8 08 C1 97 E5 0F E0 A0 E1 ?? ?? ?? ?? 0F 00 87 E8 40 C0 87 E2 03 00 9C E8 48 20 87 E2 00 30 87 E2 ?? ?? ?? ?? 0F 00 97 E8 07 D0 A0 E1 0C 71 9D E5 5C E0 9D E5 11 DE 8D E2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_305_0_0 {
	meta:
		name = "__difftime"
		size = 56
		refs = "0008 __aeabi_i2d 002c __aeabi_dsub"
	strings:
		$1 = { 70 40 2D E9 01 60 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 06 00 A0 E1 01 50 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 01 30 A0 E1 04 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 70 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_306_0_0 {
	meta:
		name = "__correctly_grouped_prefixmb"
		size = 628
		refs = "0024 strlen"
	strings:
		$1 = { F0 4F 2D E9 00 00 53 E3 14 D0 4D E2 0C 30 8D E5 00 90 A0 E1 04 10 8D E5 02 A0 A0 E1 3E 00 00 0A 02 00 A0 E1 ?? ?? ?? ?? 04 10 9D E5 09 00 51 E1 2F 00 00 9A 01 00 40 E2 01 B0 49 E2 00 70 A0 E1 04 30 9D E5 01 C0 43 E2 0C 00 59 E1 32 00 00 8A 00 60 DA E5 07 40 83 E0 03 00 00 EA 01 C0 4C E2 0B 00 5C E1 01 40 44 E2 2B 00 00 0A 01 30 54 E5 06 00 53 E1 F8 FF FF 1A 01 30 DA E5 00 00 53 E3 0C 00 00 0A 02 20 54 E5 03 00 52 E1 F2 FF FF 1A 01 10 8A E2 04 30 A0 E1 02 00 00 EA 02 00 53 E5 02 00 50 E1 EC FF FF 1A 01 20 F1 E5 00 00 52 E3 01 30 43 E2 F8 FF FF 1A 0C 00 59 E1 08 C0 8D E5 15 00 00 8A 0C 10 9D E5 00 30 D1 E5 04 10 9D E5 01 30 83 E2 01 20 6C E0 03 00 52 E1 12 00 00 0A 03 C0 8C C0 04 C0 8D E5 04 10 9D E5 01 00 59 E1 D2 FF FF 3A 04 00 9D E5 09 00 50 E1 09 00 A0 31 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 01 50 45 E2 05 00 5B E1 01 C0 4C E2 3C 00 00 1A 04 00 9D E5 14 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 0C 30 9D E5 00 30 8D E5 00 10 9D E5 01 80 D1 E5 00 00 58 E3 00 20 9D 05 00 80 D2 05 01 10 81 12 00 10 8D 15 FF 00 58 E3 01 50 4C E2 27 00 00 0A 05 00 59 E1 41 00 00 8A 00 00 56 E3 07 C0 8C E0 38 00 00 0A 05 40 A0 E1 01 30 5C E5 06 00 53 E1 13 00 00 1A 0A 10 A0 E1 0C 30 A0 E1 02 00 00 EA 01 00 53 E5 02 00 50 E1 0D 00 00 1A 01 20 F1 E5 00 00 52 E3 01 30 43 E2 F8 FF FF 1A 04 00 59 E1 04 C0 A0 E1 2B 00 00 8A 05 40 64 E0 08 00 54 E1 DC FF FF 0A 08 30 9D E5 01 30 43 E2 04 30 8D E5 C5 FF FF EA 01 40 44 E2 04 00 5B E1 01 C0 4C E2 E4 FF FF 1A 05 50 6B E0 05 00 58 E1 CB FF FF AA 08 30 9D E5 01 30 43 E2 04 30 8D E5 BA FF FF EA 05 00 59 E1 C5 FF FF 8A 00 00 56 E3 07 C0 8C E0 0C 00 00 0A 01 30 5C E5 06 00 53 E1 BB FF FF 1A 0A 10 A0 E1 0C 30 A0 E1 02 00 00 EA 01 00 53 E5 02 00 50 E1 B5 FF FF 1A 01 20 F1 E5 00 00 52 E3 01 30 43 E2 F8 FF FF 1A 05 00 59 E1 05 C0 A0 E1 B8 FF FF 9A B1 FF FF EA 05 40 A0 E1 04 00 59 E1 05 C0 A0 E1 D3 FF FF 9A 05 50 6C E0 DD FF FF EA 00 50 A0 E3 DB FF FF EA }
	condition:
		$1
}

rule file_308_0_0 {
	meta:
		name = "add_pad"
		size = 140
		refs = "0058 memset"
	strings:
		$1 = { 38 40 2D E9 00 30 90 E5 01 00 51 E3 00 40 A0 E1 01 50 A0 E1 0C 20 43 E2 14 00 00 0A 00 00 51 E3 03 00 00 1A 05 50 83 E0 00 50 84 E5 38 40 BD E8 ?? ?? ?? ?? 04 30 43 E2 03 30 80 E0 02 10 80 E0 02 20 45 E2 01 00 A0 E3 0C 00 C1 E5 06 00 83 E2 05 20 C3 E5 00 10 A0 E3 ?? ?? ?? ?? 00 30 94 E5 05 50 83 E0 00 50 84 E5 38 40 BD E8 ?? ?? ?? ?? 02 20 80 E0 00 10 A0 E3 0C 10 C2 E5 05 50 83 E0 00 50 84 E5 38 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_308_1_0 {
	meta:
		name = "option_alloc"
		size = 208
		refs = "00c0 __assert_fail"
	strings:
		$1 = { 01 C0 42 E2 04 00 52 E3 01 00 5C 13 70 40 2D E9 00 40 A0 E1 01 60 A0 E1 01 00 00 9A 08 00 52 E3 1F 00 00 1A 07 00 53 E3 1D 00 00 8A 00 00 94 E5 0C 10 50 E2 02 10 A0 03 0C 10 01 E0 02 10 61 E0 02 00 80 02 0C 10 01 E0 00 00 84 05 03 10 81 E0 04 00 A0 E1 C6 FF FF EB 00 50 94 E5 05 30 86 E0 0C 10 63 E2 00 30 84 E5 07 10 01 E2 04 00 A0 E1 BF FF FF EB 00 30 94 E5 0C 30 43 E2 07 00 13 E3 0A 00 00 1A A3 31 A0 E1 01 30 43 E2 FF 00 53 E3 03 00 00 CA 0D 30 C4 E5 05 00 84 E0 70 40 BD E8 ?? ?? ?? ?? 00 00 A0 E3 70 40 BD E8 ?? ?? ?? ?? 0C 00 9F E5 0C 10 9F E5 D4 20 A0 E3 08 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_308_2_0 {
	meta:
		name = "get_opt_end"
		size = 88
	strings:
		$1 = { 02 00 51 E1 11 00 00 2A 00 30 D1 E5 00 00 53 E3 0A 00 00 0A 02 30 81 E2 03 00 52 E1 0B 00 00 3A 01 30 D1 E5 02 30 83 E2 03 10 81 E0 01 00 52 E1 06 00 00 3A 00 10 80 E5 00 00 A0 E3 ?? ?? ?? ?? 01 10 81 E2 00 10 80 E5 03 00 A0 E1 ?? ?? ?? ?? 00 00 E0 E3 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_308_4_0 {
	meta:
		name = "inet6_option_init"
		size = 64
	strings:
		$1 = { 30 00 2D E9 3B 00 52 E3 36 00 52 13 00 30 A0 E1 0C 50 A0 03 29 40 A0 03 00 C0 A0 03 01 C0 A0 13 08 20 80 05 00 00 E0 13 00 50 83 05 04 40 83 05 0C 00 A0 01 00 30 81 05 30 00 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_308_5_0 {
	meta:
		name = "inet6_option_append"
		size = 76
		refs = "0034 memcpy"
	strings:
		$1 = { 38 40 2D E9 01 40 A0 E1 00 10 D1 E5 00 00 51 E3 01 50 D4 15 01 50 A0 03 02 50 85 12 05 10 A0 E1 98 FF FF EB 00 00 50 E3 05 00 00 0A 04 10 A0 E1 05 20 A0 E1 ?? ?? ?? ?? 00 00 A0 E3 38 40 BD E8 ?? ?? ?? ?? 00 00 E0 E3 FB FF FF EA }
	condition:
		$1
}

rule file_308_7_0 {
	meta:
		name = "inet6_option_next"
		size = 192
	strings:
		$1 = { 70 40 2D E9 04 30 90 E5 29 00 53 E3 08 D0 4D E2 01 40 A0 E1 25 00 00 1A 08 30 90 E5 3B 00 53 E3 36 00 53 13 21 00 00 1A 00 30 90 E5 0D 00 53 E3 1E 00 00 9A 0D 20 D0 E5 01 20 82 E2 82 21 A0 E1 0C 10 82 E2 01 00 53 E1 18 00 00 3A 00 10 94 E5 00 00 51 E3 02 20 80 E0 0E 10 80 02 08 50 8D 02 0C 60 82 E2 04 10 25 05 09 00 00 0A 0E 00 80 E2 00 00 51 E1 0D 00 00 3A 04 50 8D E2 05 00 A0 E1 06 20 A0 E1 9F FF FF EB 00 00 50 E3 07 00 00 1A 04 10 9D E5 00 10 84 E5 05 00 A0 E1 06 20 A0 E1 98 FF FF EB 08 D0 8D E2 70 40 BD E8 ?? ?? ?? ?? 00 00 E0 E3 08 D0 8D E2 70 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_308_8_0 {
	meta:
		name = "inet6_option_find"
		size = 224
	strings:
		$1 = { F0 41 2D E9 04 30 90 E5 29 00 53 E3 08 D0 4D E2 01 80 A0 E1 02 70 A0 E1 28 00 00 1A 08 30 90 E5 3B 00 53 E3 36 00 53 13 24 00 00 1A 00 30 90 E5 0D 00 53 E3 21 00 00 9A 0D 60 D0 E5 01 60 86 E2 86 61 A0 E1 0C 20 86 E2 02 00 53 E1 1B 00 00 3A 00 10 91 E5 00 00 51 E3 06 60 80 E0 0E 40 80 02 08 50 8D 02 0C 60 86 E2 04 40 25 05 0D 00 00 0A 0E 00 80 E2 00 00 51 E1 10 00 00 3A 04 50 8D E2 05 00 A0 E1 06 20 A0 E1 6E FF FF EB 00 00 50 E3 03 00 00 0A 09 00 00 EA 00 30 D4 E5 07 00 53 E1 0A 00 00 0A 04 40 9D E5 05 00 A0 E1 04 10 A0 E1 06 20 A0 E1 63 FF FF EB 00 00 50 E3 F5 FF FF 0A 00 00 E0 E3 08 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 00 40 88 E5 08 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_309_0_0 {
	meta:
		name = "wcsrchr"
		size = 36
	strings:
		$1 = { 00 30 A0 E1 00 00 A0 E3 03 C0 A0 E1 04 20 93 E4 01 00 52 E1 0C 00 A0 01 00 00 52 E3 F9 FF FF 1A ?? ?? ?? ?? }
	condition:
		$1
}

rule file_310_0_0 {
	meta:
		name = "__getcontext"
		size = 128
		refs = "002c __sigprocmask"
	strings:
		$1 = { 30 10 80 E2 F0 0F 81 E8 54 D0 80 E5 58 E0 80 E5 5C E0 80 E5 00 20 A0 E3 20 20 80 E5 00 40 A0 E1 00 00 A0 E3 00 10 A0 E3 68 20 84 E2 ?? ?? ?? ?? 48 20 9F E5 00 20 92 E5 E8 00 84 E2 40 00 12 E3 02 00 00 0A 10 8B A0 EC 10 1A F1 EE 04 10 80 E4 02 0C 12 E3 05 00 00 0A 02 A1 E0 EC 02 B1 E0 EC 02 C1 E0 EC 02 D1 E0 EC 02 E1 E0 EC 02 F1 E0 EC 58 E0 94 E5 30 40 94 E5 00 00 A0 E3 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_311_0_0 {
	meta:
		name = "__splice_nocancel"
		size = 36
		refs = "0020 __syscall_error"
	strings:
		$1 = { 0D C0 A0 E1 B0 00 2D E9 30 00 9C E8 55 7F A0 E3 00 00 00 EF B0 00 BD E8 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_311_1_0 {
	meta:
		name = "splice"
		size = 112
		refs = "0030 __syscall_error 0038 __libc_enable_asynccancel 0054 __libc_disable_asynccancel"
	strings:
		$1 = { 68 C0 9F E5 0C C0 9F E7 00 00 3C E3 0D C0 A0 E1 B0 00 2D E9 30 00 9C E8 05 00 00 1A 55 7F A0 E3 00 00 00 EF B0 00 BD E8 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? 0F 40 2D E9 ?? ?? ?? ?? 00 C0 A0 E1 0F 00 BD E8 55 7F A0 E3 00 00 00 EF 00 70 A0 E1 0C 00 A0 E1 ?? ?? ?? ?? 07 00 A0 E1 04 E0 9D E4 B0 00 BD E8 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_312_0_0 {
	meta:
		name = "__wcsrtombs"
		size = 684
		refs = "003c __aeabi_read_tp 0078 __wcsnlen 0094 _dl_mcount_wrapper_check 0114 __assert_fail 018c __wcslen 0244 __wcsmbs_load_conv 0284 _nl_current_LC_CTYPE 0294 __libc_errno 029c _nl_C_LC_CTYPE 02a8 __wcsmbs_gconv_fcts_c"
	strings:
		$1 = { F0 4F 2D E9 00 C0 A0 E3 70 E2 9F E5 0C 00 53 E1 53 DF 4D E2 0E 30 A0 01 01 E0 A0 E3 38 30 8D E5 44 C0 8D E5 30 C0 8D E5 34 E0 8D E5 2C E0 8D E5 4C 32 9F E5 00 60 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 30 90 E7 00 50 93 E5 14 30 95 E5 00 00 53 E3 01 80 A0 E1 02 40 A0 E1 75 00 00 0A 08 70 93 E5 00 00 56 E3 14 50 97 E5 45 00 00 0A 00 90 98 E5 04 10 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 04 40 86 E0 01 30 80 E2 05 00 A0 E1 03 91 89 E0 28 40 8D E5 24 60 8D E5 ?? ?? ?? ?? 00 20 A0 E3 48 C0 8D E2 01 10 A0 E3 09 30 A0 E1 00 20 8D E5 08 20 8D E5 0C 10 8D E5 08 20 A0 E1 07 00 A0 E1 04 C0 8D E5 24 10 8D E2 0F E0 A0 E1 ?? ?? ?? ?? 24 30 9D E5 04 20 D0 E3 03 40 66 E0 1D 00 00 0A 00 30 90 E2 01 30 A0 13 04 00 50 E3 00 00 50 13 09 00 00 0A 06 30 40 E2 01 00 53 E3 08 00 00 9A 05 00 50 E3 0F 00 00 0A 7C 01 9F E5 7C 11 9F E5 8B 20 A0 E3 78 31 9F E5 ?? ?? ?? ?? 00 00 53 E3 08 00 00 0A 04 C0 40 E2 01 00 5C E3 05 00 00 9A 60 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 54 20 A0 E3 03 20 80 E7 00 40 E0 E3 04 00 A0 E1 53 DF 8D E2 F0 4F BD E8 ?? ?? ?? ?? 01 20 53 E5 00 00 52 E3 DE FF FF 1A 03 00 56 E1 39 00 00 0A 38 30 9D E5 00 30 93 E5 00 00 53 E3 00 30 88 05 39 00 00 1A 01 40 44 E2 D5 FF FF EA 00 80 98 E5 08 00 A0 E1 ?? ?? ?? ?? 38 30 9D E5 01 A0 80 E2 03 00 93 E8 1C 30 8D E2 52 2F 8D E2 03 00 83 E8 38 30 8D E5 28 20 8D E5 14 80 8D E5 0A A1 88 E0 06 40 A0 E1 48 B0 8D E2 18 90 8D E2 01 80 A0 E3 05 00 A0 E1 24 B0 8D E5 ?? ?? ?? ?? 14 20 8D E2 0A 30 A0 E1 40 02 8D E8 08 60 8D E5 0C 80 8D E5 07 00 A0 E1 24 10 8D E2 0F E0 A0 E1 ?? ?? ?? ?? 24 30 9D E5 05 00 50 E3 03 20 6B E0 02 40 84 E0 EE FF FF 0A 04 20 D0 E3 B1 FF FF 1A 01 30 53 E5 00 00 53 E3 D6 FF FF 0A 70 00 9F E5 60 10 9F E5 63 20 A0 E3 5C 30 9F E5 ?? ?? ?? ?? 60 30 9F E5 03 00 55 E1 0D 00 00 0A 05 00 A0 E1 ?? ?? ?? ?? 14 30 95 E5 82 FF FF EA 48 00 9F E5 30 10 9F E5 7F 20 A0 E3 2C 30 9F E5 ?? ?? ?? ?? 38 00 9F E5 1C 10 9F E5 80 20 A0 E3 18 30 9F E5 ?? ?? ?? ?? 28 30 9F E5 76 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_313_0_0 {
	meta:
		name = "__brk"
		size = 132
		refs = "0038 __aeabi_read_tp 007c __libc_errno"
	strings:
		$1 = { 80 40 2D E9 00 30 A0 E1 2D 70 A0 E3 00 00 00 EF 01 0A 70 E3 0D 00 00 8A 58 20 9F E5 00 00 53 E1 00 00 82 E5 00 00 A0 93 01 00 00 8A 80 40 BD E8 ?? ?? ?? ?? 40 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 0C 20 A0 E3 03 20 80 E7 00 00 E0 E3 F6 FF FF EA 28 30 9F E5 1C 20 9F E5 00 10 60 E2 03 30 9F E7 ?? ?? ?? ?? 00 C0 E0 E3 03 10 80 E7 00 C0 82 E5 00 00 A0 E3 EC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_314_0_0 {
	meta:
		name = "gethostent"
		size = 312
		refs = "004c __aeabi_read_tp 0070 __nss_getent 00f0 __lll_lock_wait_private 0124 __libc_h_errno 0128 __gethostent_r 0130 __libc_errno"
	strings:
		$1 = { F0 41 2D E9 01 10 A0 E3 08 D0 4D E2 08 21 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 2A 00 00 1A D8 40 9F E5 D8 30 9F E5 00 40 8D E5 ?? ?? ?? ?? 03 30 9F E7 03 30 80 E0 00 50 A0 E1 04 30 8D E5 14 10 44 E2 01 3B A0 E3 B8 00 9F E5 B8 20 9F E5 ?? ?? ?? ?? B4 30 9F E5 03 30 9F E7 03 80 95 E7 00 60 A0 E1 18 70 44 E2 00 50 97 E5 00 10 A0 E3 05 40 A0 E1 80 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 0A 00 00 CA 60 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 80 E7 06 00 A0 E1 08 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? D1 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_315_0_0 {
	meta:
		name = "putw"
		size = 60
		refs = "0020 _IO_fwrite"
	strings:
		$1 = { 04 E0 2D E5 0C D0 4D E2 08 20 8D E2 04 00 22 E5 01 30 A0 E1 02 00 A0 E1 04 10 A0 E3 01 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 00 00 A0 13 00 00 E0 03 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_316_0_0 {
	meta:
		name = "__wctype_l"
		size = 136
		refs = "000c strlen 0058 memcmp"
	strings:
		$1 = { F8 43 2D E9 01 40 A0 E1 00 80 A0 E1 ?? ?? ?? ?? 00 90 94 E5 00 70 A0 E1 4C 40 99 E5 00 60 A0 E3 04 00 00 EA 01 50 85 E2 05 30 F4 E7 00 00 53 E3 11 00 00 0A 01 60 86 E2 04 00 A0 E1 ?? ?? ?? ?? 00 00 57 E1 00 50 A0 E1 F5 FF FF 1A 08 00 A0 E1 04 10 A0 E1 07 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 EF FF FF 1A 68 30 99 E5 03 60 86 E0 06 91 89 E0 24 00 99 E5 F8 43 BD E8 ?? ?? ?? ?? 03 00 A0 E1 F8 43 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_317_0_0 {
	meta:
		name = "known_compare"
		size = 44
		refs = "0014 strcmp"
	strings:
		$1 = { 01 00 50 E1 08 40 2D E9 04 00 00 0A 00 00 90 E5 00 10 91 E5 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? 00 00 A0 E3 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_317_1_0 {
	meta:
		name = "nss_parse_service_list"
		size = 1016
		refs = "0020 __aeabi_read_tp 0090 malloc 00ac mempcpy 01f8 __strncasecmp 03ac free 03d8 __libc_tsd_CTYPE_B"
	strings:
		$1 = { F0 4F 2D E9 0C D0 4D E2 00 30 A0 E3 08 70 8D E2 04 30 27 E5 BC 33 9F E5 00 50 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 40 90 E7 AC 83 9F E5 00 30 D5 E5 83 20 A0 E1 B2 20 94 E1 02 0A 12 E3 37 00 00 1A 00 00 53 E3 D9 00 00 0A 5B 00 53 E3 D7 00 00 0A 01 20 85 E2 04 00 00 EA BC 10 94 E1 02 0A 11 E3 06 00 00 1A 5B 00 53 E3 04 00 00 0A 02 90 A0 E1 01 30 D2 E4 00 00 53 E3 83 C0 A0 E1 F5 FF FF 1A 09 00 55 E1 C9 00 00 0A 09 A0 65 E0 25 00 8A E2 ?? ?? ?? ?? 00 60 50 E2 C4 00 00 0A 24 00 86 E2 0A 20 A0 E1 05 10 A0 E1 20 00 86 E5 ?? ?? ?? ?? 00 30 A0 E3 01 20 A0 E3 00 30 C0 E5 1C 30 86 E5 04 30 86 E5 08 30 86 E5 0C 30 86 E5 18 30 86 E5 00 30 86 E5 10 20 86 E5 14 20 86 E5 00 20 D9 E5 82 30 A0 E1 B3 30 94 E1 02 0A 13 E3 B7 00 00 0A 01 30 89 E2 03 50 A0 E1 01 20 D3 E4 82 10 A0 E1 B1 10 94 E1 02 0A 11 E3 F9 FF FF 1A 5B 00 52 E3 04 00 00 0A 00 60 87 E5 06 70 A0 E1 C2 FF FF EA 01 50 85 E2 C0 FF FF EA 01 20 85 E2 02 00 00 EA B1 10 94 E1 02 0A 11 E3 04 00 00 0A 02 50 A0 E1 01 30 D2 E4 00 00 53 E3 83 10 A0 E1 F7 FF FF 1A 08 20 9F E7 ?? ?? ?? ?? 02 40 90 E7 21 20 53 E2 00 90 72 E2 02 90 B9 E0 00 00 59 E3 01 30 D5 15 01 50 85 12 00 00 53 E3 8A 00 00 0A 83 20 A0 E1 B2 20 94 E1 02 0A 12 E3 86 00 00 1A 3D 00 53 E3 84 00 00 0A 5D 00 53 E3 82 00 00 0A 01 20 85 E2 06 00 00 EA B1 10 94 E1 02 0A 11 E3 09 00 00 1A 3D 00 53 E3 07 00 00 0A 5D 00 53 E3 05 00 00 0A 00 30 D2 E5 00 00 53 E3 02 B0 A0 E1 83 10 A0 E1 01 20 82 E2 F2 FF FF 1A 0B A0 65 E0 07 00 5A E3 5D 00 00 0A 08 00 5A E3 6E 00 00 1A 0A 20 A0 E1 05 00 A0 E1 E4 11 9F E5 ?? ?? ?? ?? 00 00 50 E3 00 A0 A0 01 06 00 00 0A 05 00 A0 E1 0A 20 A0 E1 CC 11 9F E5 ?? ?? ?? ?? 00 00 50 E3 61 00 00 1A 01 A0 E0 E3 00 20 DB E5 82 30 A0 E1 B3 30 94 E1 02 0A 13 E3 01 30 8B 12 05 00 00 0A 03 B0 A0 E1 01 20 D3 E4 82 10 A0 E1 B1 10 94 E1 02 0A 11 E3 F9 FF FF 1A 3D 00 52 E3 52 00 00 1A 01 B0 8B E2 00 30 DB E5 83 20 A0 E1 B2 20 94 E1 02 0A 12 E3 0B 00 A0 E1 01 B0 8B E2 F8 FF FF 1A 00 00 53 E3 48 00 00 0A 3D 00 53 E3 46 00 00 0A 5D 00 53 E3 07 00 00 1A 43 00 00 EA B2 20 94 E1 02 0A 12 E3 09 00 00 1A 3D 00 53 E3 07 00 00 0A 5D 00 53 E3 05 00 00 0A 00 30 DB E5 00 00 53 E3 0B 50 A0 E1 83 20 A0 E1 01 B0 8B E2 F2 FF FF 1A 05 20 60 E0 06 00 52 E3 2E 00 00 0A 08 00 52 E3 31 00 00 1A 00 11 9F E5 ?? ?? ?? ?? 00 00 50 E3 2D 00 00 1A 00 00 59 E3 02 A0 8A 12 0A A1 86 10 04 30 9A 15 0A A1 86 00 04 00 86 15 08 00 86 15 0C 00 86 15 10 00 86 15 0C 00 8A 05 04 30 8A 15 00 20 D5 E5 82 30 A0 E1 B3 30 94 E1 02 0A 13 E3 06 00 00 0A 01 30 85 E2 03 50 A0 E1 01 20 D3 E4 82 10 A0 E1 B1 10 94 E1 02 0A 11 E3 F9 FF FF 1A 5D 00 52 E3 1A 00 00 0A 00 30 D5 E5 7F FF FF EA 05 00 A0 E1 84 10 9F E5 0A 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 14 00 00 0A 05 00 A0 E1 0A 20 A0 E1 6C 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 06 00 00 1A 00 A0 E0 E3 A3 FF FF EA 58 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 01 00 A0 03 D1 FF FF 0A 06 00 A0 E1 ?? ?? ?? ?? 04 00 9D E5 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 01 50 85 E2 52 FF FF EA 01 A0 A0 E3 94 FF FF EA 09 50 A0 E1 4C FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_317_2_0 {
	meta:
		name = "free_database_entries"
		size = 104
		refs = "002c __tdestroy 0038 free"
	strings:
		$1 = { 70 40 2D E9 00 60 50 E2 13 00 00 0A 04 40 96 E5 00 00 54 E3 01 00 00 1A 09 00 00 EA 05 40 A0 E1 1C 00 94 E5 00 00 50 E3 34 10 9F E5 ?? ?? ?? ?? 00 50 94 E5 04 00 A0 E1 ?? ?? ?? ?? 00 00 55 E3 F5 FF FF 1A 00 40 96 E5 06 00 A0 E1 ?? ?? ?? ?? 00 00 54 E3 04 60 A0 11 EB FF FF 1A 70 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_317_3_0 {
	meta:
		name = "__nss_database_lookup"
		size = 1092
		refs = "00d4 strcmp 01c0 malloc 01f0 _IO_new_fopen 0264 __getline 028c __strchrnul 02a8 __aeabi_read_tp 0334 strlen 0364 memcpy 03a4 free 03ac _IO_new_fclose 03d4 __lll_lock_wait_private 0440 __libc_tsd_CTYPE_B"
	strings:
		$1 = { F0 4F 2D E9 01 80 A0 E1 02 90 A0 E1 24 D0 4D E2 00 60 A0 E1 03 50 A0 E1 01 10 A0 E3 04 24 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 DF 00 00 1A 00 30 95 E5 00 00 53 E3 CC 73 9F E5 14 00 00 0A 08 50 97 E5 00 10 A0 E3 05 40 A0 E1 B4 23 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 00 00 A0 D3 CC 00 00 CA 24 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 04 A0 97 E5 00 00 5A E3 49 00 00 0A 00 40 9A E5 00 00 54 E3 08 00 00 0A 08 10 94 E5 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 30 94 05 00 30 85 05 00 40 94 E5 00 00 54 E3 F6 FF FF 1A 00 30 95 E5 00 00 53 E3 17 00 00 0A 08 60 97 E5 00 10 A0 E3 06 40 A0 E1 18 23 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 B0 00 00 CA 00 00 95 E5 00 00 50 E3 00 00 A0 13 00 00 E0 03 24 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 00 58 E3 0E 00 00 0A 00 40 9A E5 00 00 54 E3 0B 00 00 0A 08 10 94 E5 08 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 30 94 05 00 30 85 05 00 40 94 E5 00 00 54 E3 F6 FF FF 1A 00 30 95 E5 00 00 53 E3 D6 FF FF 1A 00 00 59 E3 84 02 9F E5 09 00 A0 11 7B FE FF EB 00 00 50 E3 00 00 85 E5 CF FF FF 0A 0D 00 A0 E3 ?? ?? ?? ?? 00 00 50 E3 CB FF FF 0A 00 30 97 E5 00 30 80 E5 58 32 9F E5 00 20 95 E5 00 00 87 E5 0C 00 80 E9 C4 FF FF EA 48 02 9F E5 48 12 9F E5 ?? ?? ?? ?? 00 40 50 E2 71 00 00 0A 00 30 94 E5 02 39 83 E3 00 30 84 E5 08 00 A0 E3 ?? ?? ?? ?? 00 00 50 E3 04 00 8D E5 67 00 00 0A 04 30 9D E5 00 A0 83 E5 04 A0 83 E5 0A 30 A0 E1 08 60 8D E5 18 A0 8D E5 1C A0 8D E5 03 60 A0 E1 0C 80 8D E5 10 50 8D E5 14 70 8D E5 02 00 00 EA 00 30 94 E5 10 00 13 E3 4D 00 00 1A 18 00 8D E2 1C 10 8D E2 04 20 A0 E1 ?? ?? ?? ?? 00 30 50 E2 47 00 00 BA 18 00 9D E5 01 30 43 E2 03 20 D0 E7 0A 00 52 E3 03 A0 C0 07 23 10 A0 E3 18 00 9D 05 ?? ?? ?? ?? 00 A0 C0 E5 18 50 9D E5 00 30 D5 E5 00 00 53 E3 E9 FF FF 0A 94 11 9F E5 ?? ?? ?? ?? 01 20 9F E7 02 00 90 E7 83 20 A0 E1 B2 20 90 E1 02 0A 12 E3 09 00 00 0A 01 20 85 E2 00 30 D2 E5 02 50 A0 E1 83 20 A0 E1 B2 20 90 E1 02 0A 12 E3 01 20 85 E2 F8 FF FF 1A 00 00 53 E3 D7 FF FF 0A 3A 00 53 E3 D5 FF FF 0A 01 20 85 E2 01 00 00 EA 3A 00 53 E3 07 00 00 0A 02 B0 A0 E1 01 30 D2 E4 00 00 53 E3 83 10 A0 E1 CC FF FF 0A B1 10 90 E1 02 0A 11 E3 F5 FF FF 0A 05 00 5B E1 C7 FF FF 0A 00 A0 CB E5 05 00 A0 E1 ?? ?? ?? ?? 00 20 A0 E1 0D 00 80 E2 01 80 82 E2 ?? ?? ?? ?? 00 70 50 E2 01 B0 8B E2 BD FF FF 0A 0C 00 87 E2 05 10 A0 E1 08 20 A0 E1 08 00 87 E5 ?? ?? ?? ?? 0B 00 A0 E1 0B FE FF EB 00 00 56 E3 04 30 9D 05 04 00 87 E5 00 A0 87 E5 00 70 83 05 00 70 86 15 07 60 A0 E1 AE FF FF EA 18 00 9D E5 08 60 8D E2 10 50 8D E2 A0 00 95 E8 40 01 96 E8 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 04 A0 9D E5 04 A0 87 E5 40 FF FF EA 04 00 A0 E1 ?? ?? ?? ?? 00 30 A0 E3 04 30 87 E5 70 FF FF EA 02 00 A0 E1 ?? ?? ?? ?? 1C FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 34 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 00 00 A0 E3 28 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 45 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_317_4_0 {
	meta:
		name = "__nss_configure_lookup"
		size = 392
		refs = "0020 strcmp 0044 __aeabi_read_tp 0144 __lll_lock_wait_private 0174 __libc_errno 017c __nss_database_custom"
	strings:
		$1 = { F8 43 2D E9 64 81 9F E5 00 70 A0 E1 01 90 A0 E1 08 60 A0 E1 00 50 A0 E3 07 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 00 40 50 E2 0C 00 00 0A 01 50 85 E2 02 00 00 BA 0E 00 55 E3 10 60 86 E2 F5 FF FF 1A 2C 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 00 00 E0 E3 F8 43 BD E8 ?? ?? ?? ?? 05 72 A0 E1 07 30 88 E0 0C 30 93 E5 00 00 53 E3 28 00 00 0A 09 00 A0 E1 B7 FD FF EB 00 60 50 E2 27 00 00 0A 01 10 A0 E3 E8 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 21 00 00 1A 07 80 88 E0 0C 10 98 E5 B4 30 9F E5 01 20 A0 E3 00 60 81 E5 AC 60 9F E5 05 20 C3 E7 08 50 96 E5 00 10 A0 E3 05 40 A0 E1 90 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 0C 00 00 CA 00 00 A0 E3 F8 43 BD E8 ?? ?? ?? ?? 58 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 00 00 E0 E3 C5 FF FF EA 02 00 A0 E1 ?? ?? ?? ?? DA FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 14 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF E9 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_317_5_0 {
	meta:
		name = "__nss_lookup_function"
		size = 864
		refs = "0060 __tsearch 00d8 malloc 0118 strlen 0148 memcpy 0154 stpcpy 016c strcpy 017c __libc_dlsym 01dc strcmp 0204 __aeabi_read_tp 0260 __libc_dlopen_mode 02e4 __tdelete 02ec free 0304 __lll_lock_wait_private 033c known_compare 034c __libc_errno 0358 .LC12"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 0C D0 4D E2 00 50 A0 E1 28 10 0B E5 1C 23 9F E5 01 10 A0 E3 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 AC 00 00 1A 1C 80 85 E2 28 40 4B E2 08 10 A0 E1 04 00 A0 E1 D8 22 9F E5 ?? ?? ?? ?? 00 60 50 E2 4A 00 00 0A 00 30 96 E5 04 00 53 E1 16 00 00 0A 04 60 93 E5 BC 72 9F E5 08 50 97 E5 00 10 A0 E3 05 40 A0 E1 A4 22 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 91 00 00 CA 06 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 08 00 A0 E3 ?? ?? ?? ?? 00 90 50 E2 84 00 00 0A 00 90 86 E5 28 30 1B E5 00 30 89 E5 18 60 95 E5 00 00 56 E3 40 72 9F E5 27 00 00 0A 04 30 96 E5 00 00 53 E3 38 00 00 0A 01 00 73 E3 1E 00 00 0A 20 00 95 E5 ?? ?? ?? ?? 00 40 A0 E1 28 00 1B E5 ?? ?? ?? ?? 00 00 84 E0 0E 30 80 E2 07 30 C3 E3 0D 40 A0 E1 03 D0 4D E0 06 20 A0 E3 0D 00 A0 E1 F8 11 9F E5 ?? ?? ?? ?? 05 00 8D E2 20 10 95 E5 ?? ?? ?? ?? 02 20 A0 E3 E4 11 9F E5 ?? ?? ?? ?? 28 10 1B E5 01 00 80 E2 ?? ?? ?? ?? 18 30 95 E5 0D 10 A0 E1 04 00 93 E5 ?? ?? ?? ?? 00 60 A0 E1 04 D0 A0 E1 04 60 89 E5 BB FF FF EA 00 60 A0 E3 FB FF FF EA A0 71 9F E5 B7 FF FF EA 04 30 97 E5 00 00 53 E3 0C 30 87 02 04 60 93 E5 00 00 56 E3 20 A0 95 E5 04 60 83 02 04 00 00 1A 35 00 00 EA 08 30 96 E5 00 00 53 E3 31 00 00 0A 03 60 A0 E1 00 00 96 E5 0A 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F6 FF FF 1A 18 60 85 E5 C3 FF FF EA 20 00 95 E5 ?? ?? ?? ?? 14 20 80 E2 07 20 C2 E3 44 31 9F E5 ?? ?? ?? ?? 0D 60 A0 E1 02 D0 4D E0 03 30 9F E7 00 40 A0 E1 08 20 A0 E3 0D 00 A0 E1 28 11 9F E5 03 80 94 E7 ?? ?? ?? ?? 07 00 8D E2 20 10 95 E5 ?? ?? ?? ?? 14 11 9F E5 04 20 A0 E3 ?? ?? ?? ?? 03 20 A0 E3 08 11 9F E5 03 00 80 E2 ?? ?? ?? ?? 0D 00 A0 E1 06 11 A0 E3 18 A0 95 E5 ?? ?? ?? ?? 04 00 8A E5 18 30 95 E5 04 20 93 E5 00 00 52 E3 00 20 E0 03 04 20 83 05 D8 30 9F 05 03 30 9F 07 03 80 84 07 18 30 95 E5 06 D0 A0 E1 04 30 93 E5 9C FF FF EA 08 60 86 E2 0C 00 A0 E3 ?? ?? ?? ?? 00 00 50 E3 00 00 86 E5 1F 00 00 0A 00 A0 80 E5 00 20 96 E5 00 30 A0 E3 04 30 82 E5 00 20 96 E5 08 30 82 E5 00 60 96 E5 03 00 56 E1 18 60 85 E5 89 FF FF 1A 08 10 A0 E1 58 20 9F E5 04 00 A0 E1 ?? ?? ?? ?? 09 00 A0 E1 ?? ?? ?? ?? 00 60 A0 E3 61 FF FF EA 40 70 9F E5 F5 FF FF EA 02 00 A0 E1 ?? ?? ?? ?? 4F FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 14 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 64 FF FF EA 18 00 85 E5 E7 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_317_6_0 {
	meta:
		name = "__nss_lookup"
		size = 192
		refs = "0018 __nss_lookup_function"
	strings:
		$1 = { F8 40 2D E9 00 40 A0 E1 00 00 90 E5 03 50 A0 E1 02 70 A0 E1 01 60 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 00 85 E5 22 00 00 0A 00 00 50 E3 14 00 00 1A 00 C0 94 E5 08 00 9C E5 00 00 50 E3 06 10 A0 E1 12 00 00 1A 00 C0 9C E5 00 00 5C E2 15 00 00 0A 00 C0 84 E5 ?? ?? ?? ?? 00 00 50 E3 00 00 85 E5 F0 FF FF 1A 00 00 57 E3 F0 FF FF 0A 00 00 94 E5 07 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 00 85 E5 EA FF FF 0A 00 00 A0 E3 F8 40 BD E8 ?? ?? ?? ?? 00 30 9C E5 00 00 53 E3 00 00 E0 13 01 00 A0 03 F8 40 BD E8 ?? ?? ?? ?? 01 00 A0 E3 F8 40 BD E8 ?? ?? ?? ?? 00 00 57 E3 EB FF FF 1A D9 FF FF EA }
	condition:
		$1
}

rule file_317_7_0 {
	meta:
		name = "__nss_next2"
		size = 264
		refs = "0044 __nss_lookup_function 0100 __libc_fatal"
	strings:
		$1 = { F8 40 2D E9 1C C0 9D E5 00 00 5C E3 00 40 A0 E1 01 60 A0 E1 02 70 A0 E1 03 50 A0 E1 21 00 00 0A 00 30 90 E5 04 20 93 E5 01 00 52 E3 28 00 00 0A 00 00 93 E5 00 00 50 E3 17 00 00 0A 00 00 84 E5 06 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 00 85 E5 02 00 00 0A 00 00 A0 E3 F8 40 BD E8 ?? ?? ?? ?? 00 00 57 E3 05 00 00 0A 00 00 94 E5 07 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 00 85 E5 F4 FF FF 1A 00 00 94 E5 08 30 90 E5 00 00 53 E3 02 00 00 1A 00 00 90 E5 00 00 50 E3 E7 FF FF 1A 00 00 E0 E3 F8 40 BD E8 ?? ?? ?? ?? 18 30 9D E5 02 20 83 E2 04 00 52 E3 10 00 00 8A 00 30 90 E5 02 21 83 E0 04 00 92 E5 01 00 50 E3 D8 FF FF 1A F8 40 BD E8 ?? ?? ?? ?? 08 20 93 E5 01 00 52 E3 D3 FF FF 1A 0C 20 93 E5 01 00 52 E3 D0 FF FF 1A 10 00 93 E5 01 00 50 E3 CD FF FF 1A D6 FF FF EA 00 00 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_317_8_0 {
	meta:
		name = "free_defconfig"
		size = 32
		refs = "0018 free_database_entries"
	strings:
		$1 = { 14 30 9F E5 00 00 93 E5 00 00 50 E3 ?? ?? ?? ?? 00 20 A0 E3 00 20 83 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_317_9_0 {
	meta:
		name = "free_mem"
		size = 120
		refs = "0020 free_database_entries 003c free 005c __libc_dlclose"
	strings:
		$1 = { 6C 30 9F E5 70 40 2D E9 04 60 93 E5 00 00 56 E3 15 00 00 0A 00 20 A0 E3 00 00 96 E5 04 20 83 E5 ?? ?? ?? ?? 04 40 96 E5 00 00 54 E3 06 00 00 1A 0B 00 00 EA 08 50 94 E5 04 00 A0 E1 ?? ?? ?? ?? 00 00 55 E3 06 00 00 0A 05 40 A0 E1 04 00 94 E5 01 30 40 E2 03 00 73 E3 F5 FF FF 8A ?? ?? ?? ?? F3 FF FF EA 06 00 A0 E1 ?? ?? ?? ?? 70 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_317_10_0 {
	meta:
		name = "__nss_next"
		size = 40
		refs = "0018 __nss_next2"
	strings:
		$1 = { 04 E0 2D E5 0C D0 4D E2 10 C0 9D E5 08 10 8D E8 02 30 A0 E1 00 20 A0 E3 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_318_0_0 {
	meta:
		name = "__sleep"
		size = 620
		refs = "003c memset 0050 __sigaction 0074 __sigprocmask 0084 __nanosleep 0144 __aeabi_read_tp 024c __pthread_unwind 0258 __libc_errno"
	strings:
		$1 = { F0 41 2D E9 00 40 50 E2 66 DF 4D E2 00 30 A0 13 08 30 8D 15 02 81 E0 13 01 78 A0 13 21 00 00 1A 72 00 00 EA 8C 10 9D E5 01 58 11 E2 11 00 00 1A 05 10 A0 E1 80 20 A0 E3 0C 00 8D E2 ?? ?? ?? ?? 11 00 A0 E3 05 10 A0 E1 43 2F 8D E2 0C 70 8D E5 ?? ?? ?? ?? 00 00 50 E3 54 00 00 BA 0C 31 9D E5 01 00 53 E3 23 00 00 0A 05 20 A0 E1 02 00 A0 E3 8C 10 8D E2 ?? ?? ?? ?? 04 60 8D E2 06 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 01 30 70 E2 00 30 A0 33 00 00 54 E3 00 30 A0 03 00 00 53 E3 00 50 A0 E1 32 00 00 0A 04 30 9D E5 08 00 54 E1 04 30 83 90 08 30 83 80 00 10 A0 E3 80 20 A0 E3 0C 00 8D E2 04 30 8D E5 04 40 63 E0 ?? ?? ?? ?? 00 00 A0 E3 0C 10 8D E2 8C 20 8D E2 0C 70 8D E5 ?? ?? ?? ?? 00 00 50 E3 CE FF FF 0A 00 00 E0 E3 66 DF 8D E2 F0 41 BD E8 ?? ?? ?? ?? 04 60 8D E2 05 00 00 EA 0A 01 74 E3 04 20 A0 91 02 21 E0 83 08 30 9D E5 04 20 8D E5 04 40 63 E0 06 00 A0 E1 06 10 A0 E1 ?? ?? ?? ?? 01 30 74 E2 00 30 A0 33 00 00 50 E3 01 30 83 13 00 00 53 E3 00 50 A0 E1 EF FF FF 0A 10 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 00 60 A0 E1 8C 10 8D E2 00 20 A0 E3 02 00 A0 E3 03 70 96 E7 ?? ?? ?? ?? F0 30 9F E5 03 30 9F E7 03 70 86 E7 00 00 55 E3 09 00 00 0A 08 00 9D E5 DC 20 9F E5 04 30 9D E5 02 00 50 E1 03 00 A0 D1 01 00 83 C2 04 00 80 E0 66 DF 8D E2 F0 41 BD E8 ?? ?? ?? ?? 00 00 A0 E3 66 DF 8D E2 F0 41 BD E8 ?? ?? ?? ?? AC 30 9F E5 ?? ?? ?? ?? 00 40 A0 E1 05 20 A0 E1 03 30 9F E7 8C 10 8D E2 02 00 A0 E3 03 50 94 E7 ?? ?? ?? ?? 8C 30 9F E5 00 00 E0 E3 03 30 9F E7 03 50 84 E7 66 DF 8D E2 F0 41 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 3C 44 10 E5 46 30 C4 E3 08 00 53 E3 00 50 A0 E1 E5 FF FF 1A 00 30 E0 E3 13 6D 40 E2 A0 32 00 E5 84 60 86 E2 10 10 84 E3 06 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 04 00 53 E1 40 04 15 05 ?? ?? ?? ?? 3C 44 15 E5 EF FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? FF 64 CD 1D ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_319_0_0 {
	meta:
		name = "posix_spawnattr_getschedparam"
		size = 36
		refs = "0014 memcpy"
	strings:
		$1 = { 08 40 2D E9 42 3F 80 E2 04 20 A0 E3 01 00 A0 E1 03 10 A0 E1 ?? ?? ?? ?? 00 00 A0 E3 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_320_0_0 {
	meta:
		name = "skip_string"
		size = 140
		refs = "0018 __aeabi_read_tp 0088 __libc_tsd_CTYPE_B"
	strings:
		$1 = { 10 40 2D E9 00 30 D0 E5 00 00 53 E3 00 40 A0 E1 19 00 00 0A 6C 20 9F E5 ?? ?? ?? ?? 02 20 9F E7 02 00 90 E7 83 20 A0 E1 B2 20 90 E1 02 0A 12 E3 11 00 00 1A 23 00 53 E3 0F 00 00 0A 2C 00 53 E3 0D 00 00 0A 01 20 84 E2 06 00 00 EA B1 10 90 E1 02 0A 11 E3 08 00 00 1A 23 00 53 E3 06 00 00 0A 2C 00 53 E3 04 00 00 0A 02 40 A0 E1 01 30 D2 E4 00 00 53 E3 83 10 A0 E1 F3 FF FF 1A 04 00 A0 E1 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_320_1_0 {
	meta:
		name = "arg_trimdomain_list"
		size = 472
		refs = "004c __strndup 0058 __aeabi_read_tp 012c __dcgettext 0148 __asprintf 0160 __fxprintf 0168 free 01bc _res_hconf 01c0 __libc_tsd_CTYPE_B 01cc _libc_intl_domainname"
	strings:
		$1 = { F0 4F 2D E9 B0 61 9F E5 1C D0 4D E2 AC 71 9F E5 0C 10 8D E5 00 A0 A0 E1 02 B0 A0 E1 06 50 A0 E1 01 80 A0 E3 0B 00 A0 E1 D1 FF FF EB 18 40 96 E5 03 00 54 E3 00 90 A0 E1 00 10 6B E0 37 00 00 CA 01 20 84 E2 0B 00 A0 E1 18 20 85 E5 ?? ?? ?? ?? 04 41 85 E0 1C 00 84 E5 ?? ?? ?? ?? 07 20 9F E7 00 40 D9 E5 02 20 90 E7 84 10 A0 E1 B1 10 92 E1 02 0A 11 E3 27 00 00 0A 01 C0 89 E2 0C B0 A0 E1 01 40 DC E4 84 30 A0 E1 B3 30 92 E1 02 0A 13 E3 F9 FF FF 1A 2C 40 44 E2 FF 40 04 E2 0F 00 54 E3 14 00 00 8A 18 44 A0 E1 14 31 9F E5 03 30 04 E0 00 00 53 E3 0F 00 00 0A 01 10 DB E5 81 30 A0 E1 B3 30 92 E1 02 0A 13 E3 01 30 8B E2 2A 00 00 0A 02 30 8B E2 03 B0 A0 E1 01 10 D3 E4 81 00 A0 E1 B0 00 92 E1 02 0A 10 E3 F9 FF FF 1A 00 00 51 E3 23 00 51 13 24 00 00 0A 00 30 DB E5 23 00 53 E3 00 00 53 13 C6 FF FF 1A 0B 00 A0 E1 1C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 09 B0 A0 E1 DC FF FF EA A0 10 9F E5 05 20 A0 E3 9C 00 9F E5 ?? ?? ?? ?? 04 C0 A0 E3 00 10 A0 E1 0A 20 A0 E1 0C 30 9D E5 00 C0 8D E5 14 00 8D E2 ?? ?? ?? ?? 00 00 50 E3 05 00 00 BA 00 00 A0 E3 70 10 9F E5 14 20 9D E5 ?? ?? ?? ?? 14 00 9D E5 ?? ?? ?? ?? 00 00 A0 E3 1C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 00 51 E3 23 00 51 13 03 B0 A0 E1 DA FF FF 1A 40 10 9F E5 05 20 A0 E3 30 00 9F E5 ?? ?? ?? ?? 0A 20 A0 E1 00 10 A0 E1 0C 30 9D E5 14 00 8D E2 ?? ?? ?? ?? 00 00 50 E3 E6 FF FF AA EB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? 01 C0 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_320_2_0 {
	meta:
		name = "arg_spoof.isra.0"
		size = 168
		refs = "0054 __strncasecmp 009c _res_hconf"
	strings:
		$1 = { F8 40 2D E9 00 60 A0 E1 63 FF FF EB 00 20 66 E0 03 00 52 E3 00 40 A0 E1 11 00 00 0A 78 50 9F E5 2C 70 95 E5 04 00 52 E3 06 30 87 E3 2C 30 85 E5 05 00 00 0A 04 70 C7 E3 02 70 87 E3 2C 70 85 E5 04 00 A0 E1 F8 40 BD E8 ?? ?? ?? ?? 06 00 A0 E1 48 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 F4 FF FF 1A F6 FF FF EA 06 00 A0 E1 34 10 9F E5 ?? ?? ?? ?? 00 00 50 E3 20 50 9F 15 2C 70 95 15 EC FF FF 1A 14 30 9F E5 2C 20 93 E5 06 20 C2 E3 04 00 A0 E1 2C 20 83 E5 F8 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_320_3_0 {
	meta:
		name = "arg_bool"
		size = 240
		refs = "0024 __strncasecmp 0094 __dcgettext 00ac __asprintf 00c4 __fxprintf 00cc free 00dc _res_hconf 00e8 _libc_intl_domainname"
	strings:
		$1 = { F0 40 2D E9 02 40 A0 E1 14 D0 4D E2 00 70 A0 E1 01 60 A0 E1 02 00 A0 E1 B8 10 9F E5 02 20 A0 E3 03 50 A0 E1 ?? ?? ?? ?? 00 00 50 E3 07 00 00 1A A4 30 9F E5 2C 20 93 E5 02 50 85 E1 2C 50 83 E5 02 00 84 E2 14 D0 8D E2 F0 40 BD E8 ?? ?? ?? ?? 04 00 A0 E1 84 10 9F E5 03 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 07 00 00 1A 6C 30 9F E5 2C 20 93 E5 03 00 84 E2 05 50 C2 E1 2C 50 83 E5 14 D0 8D E2 F0 40 BD E8 ?? ?? ?? ?? 54 10 9F E5 05 20 A0 E3 50 00 9F E5 ?? ?? ?? ?? 00 40 8D E5 00 10 A0 E1 07 20 A0 E1 06 30 A0 E1 0C 00 8D E2 ?? ?? ?? ?? 00 00 50 E3 05 00 00 BA 00 00 A0 E3 28 10 9F E5 0C 20 9D E5 ?? ?? ?? ?? 0C 00 9D E5 ?? ?? ?? ?? 00 00 A0 E3 DA FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_320_4_0 {
	meta:
		name = "do_init"
		size = 912
		refs = "0044 getenv 005c _IO_new_fopen 0088 fgets_unlocked 009c __strchrnul 00ac __aeabi_read_tp 0118 __strncasecmp 0128 strlen 014c __dcgettext 0164 __asprintf 017c __fxprintf 0184 free 0190 _IO_new_fclose 034c _res_hconf 0360 __libc_tsd_CTYPE_B 036c _libc_intl_domainname"
	strings:
		$1 = { F0 4F 2D E9 40 93 9F E5 00 70 A0 E3 47 DF 4D E2 38 03 9F E5 00 70 89 E5 04 70 89 E5 08 70 89 E5 0C 70 89 E5 10 70 89 E5 14 70 89 E5 18 70 89 E5 1C 70 89 E5 20 70 89 E5 24 70 89 E5 28 70 89 E5 2C 70 89 E5 ?? ?? ?? ?? 04 33 9F E5 07 00 50 E1 03 00 A0 01 FC 12 9F E5 0C 00 8D E5 ?? ?? ?? ?? 00 00 50 E3 08 00 8D E5 49 00 00 0A 00 30 90 E5 02 39 83 E3 00 30 80 E5 DC 82 9F E5 18 00 8D E2 01 1C A0 E3 08 20 9D E5 ?? ?? ?? ?? 00 00 50 E3 3D 00 00 0A 18 00 8D E2 0A 10 A0 E3 ?? ?? ?? ?? 00 30 A0 E3 00 30 C0 E5 B0 22 9F E5 ?? ?? ?? ?? 02 30 9F E7 18 C0 DD E5 03 40 90 E7 8C 30 A0 E1 B3 30 94 E1 02 0A 13 E3 01 70 87 E2 56 00 00 0A 19 20 8D E2 02 50 A0 E1 01 C0 D2 E4 8C 30 A0 E1 B3 30 94 E1 02 0A 13 E3 F9 FF FF 1A 00 00 5C E3 23 00 5C 13 E0 FF FF 0A 05 00 A0 E1 C0 FE FF EB 5C 62 9F E5 00 A0 A0 E1 00 B0 65 E0 05 00 A0 E1 06 10 A0 E1 0B 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 06 00 A0 E1 02 00 00 1A ?? ?? ?? ?? 00 00 5B E1 42 00 00 0A 10 60 86 E2 08 00 56 E1 F2 FF FF 1A 20 12 9F E5 20 02 9F E5 05 20 A0 E3 ?? ?? ?? ?? 00 50 8D E5 00 10 A0 E1 14 00 8D E2 0C 20 9D E5 07 30 A0 E1 ?? ?? ?? ?? 00 00 50 E3 C2 FF FF BA F8 11 9F E5 14 20 9D E5 00 00 A0 E3 ?? ?? ?? ?? 14 00 9D E5 ?? ?? ?? ?? BB FF FF EA 08 00 9D E5 ?? ?? ?? ?? D8 01 9F E5 ?? ?? ?? ?? 00 00 50 E3 30 FF FF 1B CC 01 9F E5 ?? ?? ?? ?? 00 20 50 E2 C0 01 9F 15 01 10 A0 13 10 30 A0 13 53 FF FF 1B B4 01 9F E5 ?? ?? ?? ?? 00 20 50 E2 A8 01 9F 15 01 10 A0 13 08 30 A0 13 4C FF FF 1B 9C 01 9F E5 ?? ?? ?? ?? 00 20 50 E2 90 01 9F 15 01 10 A0 13 A6 FE FF 1B 88 01 9F E5 ?? ?? ?? ?? 00 20 50 E2 04 00 00 0A 00 30 A0 E3 74 01 9F E5 01 10 A0 E3 18 30 89 E5 9D FE FF EB 01 30 A0 E3 00 30 89 E5 47 DF 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 00 5C E3 23 00 5C 13 18 50 8D E2 8F FF FF 0A AD FF FF EA 00 30 DA E5 83 30 A0 E1 B3 30 94 E1 02 0A 13 E3 01 30 8A 12 06 00 00 0A 00 20 D3 E5 82 20 A0 E1 B2 20 94 E1 02 0A 12 E3 03 A0 A0 E1 01 30 83 E2 F8 FF FF 1A 0B 30 D6 E5 01 00 53 E3 28 00 00 0A 02 00 53 E3 2C 00 00 0A 03 00 53 E3 7A FF FF 1A 0A 20 A0 E1 0C 30 96 E5 0C 00 9D E5 07 10 A0 E1 1A FF FF EB 00 40 A0 E1 00 00 54 E3 72 FF FF 0A 00 30 D4 E5 00 00 53 E3 6F FF FF 0A C4 20 9F E5 ?? ?? ?? ?? 02 20 9F E7 02 00 90 E7 83 20 A0 E1 B2 20 90 E1 02 0A 12 E3 01 20 84 12 07 00 00 0A 02 40 A0 E1 01 30 D2 E4 00 00 53 E3 83 10 A0 E1 61 FF FF 0A B1 10 90 E1 02 0A 11 E3 F7 FF FF 1A 23 00 53 E3 5C FF FF 0A 7C 10 9F E5 58 00 9F E5 05 20 A0 E3 ?? ?? ?? ?? 00 40 8D E5 00 10 A0 E1 8C FF FF EA 0A 20 A0 E1 0C 00 9D E5 07 10 A0 E1 56 FE FF EB 00 40 A0 E1 DA FF FF EA 0A 00 A0 E1 C8 FE FF EB 00 40 A0 E1 D6 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_320_5_0 {
	meta:
		name = "_res_hconf_init"
		size = 84
		refs = "0018 __pthread_once 0050 do_init"
	strings:
		$1 = { 40 30 9F E5 00 00 53 E3 10 40 2D E9 04 00 00 0A 34 00 9F E5 34 10 9F E5 ?? ?? ?? ?? 10 40 BD E8 ?? ?? ?? ?? 20 40 9F E5 00 30 94 E5 00 00 53 E3 F9 FF FF 1A 0D FF FF EB 00 30 94 E5 02 30 83 E3 00 30 84 E5 F4 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_320_6_0 {
	meta:
		name = "_res_hconf_reorder_addrs"
		size = 876
		refs = "00e0 __aeabi_read_tp 00f8 __socket 014c __close 016c __ifreq 018c malloc 0224 __ioctl 0264 realloc 027c free 0320 __lll_lock_wait_private 0338 __assert_fail 033c _res_hconf 0348 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 30 33 9F E5 2C 30 93 E5 08 00 13 E3 1C D0 4D E2 00 50 A0 E1 02 00 00 0A 08 30 90 E5 02 00 53 E3 02 00 00 0A 1C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 04 63 9F E5 00 C0 96 E5 00 00 5C E3 25 00 00 DA 10 80 95 E5 00 90 98 E5 00 00 59 E3 F4 FF FF 0A E8 32 9F E5 00 60 93 E5 04 A0 88 E2 09 70 A0 E1 00 00 5C E3 10 00 00 DA 0C 00 96 E9 00 40 97 E5 02 20 24 E0 03 00 12 E1 10 00 00 0A 06 20 A0 E1 00 30 A0 E3 05 00 00 EA 10 00 82 E2 03 00 90 E8 00 00 24 E0 01 00 10 E1 0C 20 82 E2 07 00 00 0A 01 30 83 E2 0C 00 53 E1 F6 FF FF 1A 0A 80 A0 E1 04 70 9A E4 00 00 57 E3 E8 FF FF 1A D8 FF FF EA 00 90 88 E5 10 30 95 E5 00 70 83 E5 1C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 64 22 9F E5 ?? ?? ?? ?? 02 20 9F E7 02 A0 90 E7 03 10 A0 E1 03 00 A0 E1 00 20 A0 E3 ?? ?? ?? ?? 00 90 50 E2 C8 FF FF BA 01 10 A0 E3 3C 22 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 77 00 00 1A 00 30 96 E5 00 00 53 E3 05 00 00 DA 09 00 A0 E1 ?? ?? ?? ?? 00 C0 96 E5 00 00 5C E3 B2 FF FF 0A B8 FF FF EA 10 00 8D E2 14 10 8D E2 09 20 A0 E1 ?? ?? ?? ?? 10 30 9D E5 00 00 53 E3 60 00 00 0A 14 20 9D E5 82 00 82 E0 00 01 A0 E1 00 30 8D E5 ?? ?? ?? ?? AC C1 9F E5 00 00 50 E3 00 00 8C E5 00 30 9D E5 5B 00 00 0A 14 10 9D E5 00 00 51 E3 55 00 00 DA 00 80 A0 E3 10 20 83 E2 04 04 8D E9 08 70 A0 E1 03 40 A0 E1 03 A0 A0 E1 0C 50 8D E5 03 00 00 EA 01 70 87 E2 07 00 51 E1 20 40 84 E2 1C 00 00 DA B0 21 D4 E1 88 B0 88 E0 02 00 52 E3 0B B1 A0 11 F6 FF FF 1A 04 30 9D E5 0B 21 80 E7 04 50 6A E0 03 50 85 E0 04 20 95 E5 0B B1 A0 E1 0B 00 80 E0 38 11 9F E5 04 20 80 E5 04 20 A0 E1 09 00 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 00 C0 9D E5 00 00 50 E3 00 00 9C E5 04 10 95 A5 0B 20 80 A0 08 10 82 A5 14 10 9D B5 14 10 9D A5 01 80 88 A2 0C B0 8B A2 DE FF FF EA 08 A0 9D E5 0C 50 9D E5 0B 10 A0 E1 00 C0 8D E5 ?? ?? ?? ?? 00 C0 9D E5 00 00 50 E3 00 00 8C E5 2B 00 00 0A 10 00 9D E5 ?? ?? ?? ?? CC 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 A0 80 E7 00 80 86 E5 BC 80 9F E5 04 70 98 E5 00 10 A0 E3 07 40 A0 E1 A0 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 57 E1 F0 FF FF 1A 01 00 57 E3 9A FF FF DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 58 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 91 FF FF EA 03 80 A0 E1 DD FF FF EA 00 B0 A0 E3 0B 80 A0 E1 D1 FF FF EA 00 80 A0 E1 D6 FF FF EA 02 00 A0 E1 ?? ?? ?? ?? 84 FF FF EA 2C 00 9F E5 2C 10 9F E5 2C 20 9F E5 2C 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 1B 89 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C6 01 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_320_7_0 {
	meta:
		name = "_res_hconf_trim_domain"
		size = 128
		refs = "0008 strlen 0054 __strcasecmp 007c _res_hconf"
	strings:
		$1 = { F0 47 2D E9 00 A0 A0 E1 ?? ?? ?? ?? 68 70 9F E5 18 90 97 E5 00 00 59 E3 00 60 A0 E1 11 00 00 DA 18 70 87 E2 00 40 A0 E3 04 50 B7 E5 05 00 A0 E1 ?? ?? ?? ?? 00 30 A0 E1 06 80 60 E0 08 80 8A E0 03 00 56 E1 08 00 A0 E1 05 10 A0 E1 01 40 84 E2 02 00 00 9A ?? ?? ?? ?? 00 00 50 E3 03 00 00 0A 09 00 54 E1 EF FF FF 1A F0 47 BD E8 ?? ?? ?? ?? 00 00 C8 E5 F0 47 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_320_8_0 {
	meta:
		name = "_res_hconf_trim_domains"
		size = 96
		refs = "0024 _res_hconf_trim_domain 005c _res_hconf"
	strings:
		$1 = { 38 40 2D E9 50 30 9F E5 18 30 93 E5 00 00 53 E3 00 50 A0 E1 01 00 00 1A 38 40 BD E8 ?? ?? ?? ?? 00 00 90 E5 ?? ?? ?? ?? 04 30 95 E5 00 00 93 E5 00 00 50 E3 F7 FF FF 0A 04 40 A0 E3 ?? ?? ?? ?? 04 30 95 E5 04 00 93 E7 00 00 50 E3 04 40 84 E2 F9 FF FF 1A 38 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_321_0_0 {
	meta:
		name = "__isoc99_vswscanf"
		size = 136
		refs = "0034 _IO_no_init 0040 _IO_fwide 0054 _IO_wstr_init_static 0074 _IO_vfwscanf 0084 _IO_wstr_jumps"
	strings:
		$1 = { F0 40 2D E9 78 30 9F E5 5D DF 4D E2 00 40 A0 E3 00 70 A0 E1 01 60 A0 E1 02 50 A0 E1 00 30 8D E5 04 20 A0 E1 B4 30 8D E2 08 00 8D E2 02 19 A0 E3 50 40 8D E5 ?? ?? ?? ?? 08 00 8D E2 01 10 A0 E3 ?? ?? ?? ?? 08 00 8D E2 07 10 A0 E1 04 20 A0 E1 04 30 A0 E1 ?? ?? ?? ?? 44 C0 9D E5 08 00 8D E2 10 C0 8C E3 06 10 A0 E1 05 20 A0 E1 04 30 A0 E1 44 C0 8D E5 ?? ?? ?? ?? 5D DF 8D E2 F0 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_0_0 {
	meta:
		name = "flush_cleanup"
		size = 312
		refs = "00e8 __aeabi_read_tp"
	strings:
		$1 = { F0 40 2D E9 24 51 9F E5 00 30 95 E5 00 00 53 E3 02 00 00 0A 00 20 93 E5 02 09 12 E3 19 00 00 0A 08 30 95 E5 01 30 43 E2 00 00 53 E3 08 30 85 E5 F8 20 9F E5 11 00 00 1A 0C 30 82 E5 04 60 95 E5 00 10 A0 E3 06 40 A0 E1 E4 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 22 00 00 CA F0 40 BD E8 ?? ?? ?? ?? 48 60 93 E5 04 30 96 E5 01 30 43 E2 00 00 53 E3 04 30 86 E5 DF FF FF 1A 08 30 86 E5 00 70 96 E5 00 10 A0 E3 07 40 A0 E1 06 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 57 E1 F0 FF FF 1A 01 00 57 E3 CD FF FF DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 06 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF C4 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 10 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF D3 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_1_0 {
	meta:
		name = "save_for_backup"
		size = 448
		refs = "00b4 malloc 00dc memcpy 00ec free 015c memmove 01a0 mempcpy"
	strings:
		$1 = { F0 4F 2D E9 30 30 90 E5 0C A0 90 E5 00 00 53 E3 0C D0 4D E2 00 50 A0 E1 01 80 A0 E1 01 70 6A E0 44 00 00 0A 07 40 A0 E1 03 C0 A0 E1 08 20 9C E5 00 C0 9C E5 02 00 54 E1 02 40 A0 A1 00 00 5C E3 F9 FF FF 1A 2C B0 95 E5 24 00 95 E5 07 60 64 E0 0B 90 60 E0 09 00 56 E1 13 00 00 8A 00 00 54 E3 09 90 66 E0 39 00 00 BA 00 00 56 E3 27 00 00 1A 09 90 80 E0 07 10 A0 E1 00 00 53 E3 28 90 85 E5 05 00 00 0A 08 20 93 E5 02 20 61 E0 08 20 83 E5 00 30 93 E5 00 00 53 E3 F9 FF FF 1A 00 00 A0 E3 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 64 70 86 E2 07 00 A0 E1 ?? ?? ?? ?? 00 30 50 E2 3D 00 00 0A 00 00 54 E3 64 90 83 E2 30 00 00 BA 04 10 8A E0 06 20 A0 E1 09 00 A0 E1 04 30 8D E5 ?? ?? ?? ?? 04 30 9D E5 24 00 95 E5 04 30 8D E5 ?? ?? ?? ?? 04 30 9D E5 0C 10 95 E5 07 70 83 E0 24 30 85 E5 2C 70 85 E5 08 10 61 E0 30 30 95 E5 D9 FF FF EA 09 00 80 E0 04 10 8A E0 06 20 A0 E1 ?? ?? ?? ?? 0C 10 95 E5 24 00 95 E5 30 30 95 E5 08 10 61 E0 09 90 80 E0 CF FF FF EA 2C B0 90 E5 24 00 90 E5 00 00 57 E3 0B 90 60 E0 C8 FF FF AA 07 40 A0 E1 04 10 8B E0 00 20 64 E2 09 00 80 E0 ?? ?? ?? ?? 0C 10 95 E5 24 00 95 E5 09 40 64 E0 08 20 61 E0 04 00 80 E0 ?? ?? ?? ?? 24 30 95 E5 0C 10 95 E5 09 90 83 E0 08 10 61 E0 30 30 95 E5 B9 FF FF EA 04 10 8B E0 00 20 64 E2 09 00 A0 E1 04 30 8D E5 ?? ?? ?? ?? 0C 10 95 E5 08 20 61 E0 ?? ?? ?? ?? 04 30 9D E5 CA FF FF EA 00 00 E0 E3 B7 FF FF EA }
	condition:
		$1
}

rule file_323_2_0 {
	meta:
		name = "_IO_un_link"
		size = 784
		refs = "0038 _pthread_cleanup_push_defer 0040 __aeabi_read_tp 0244 _pthread_cleanup_pop_restore 02bc __lll_lock_wait_private 0300 flush_cleanup 0308 _IO_list_all"
	strings:
		$1 = { F0 47 2D E9 00 30 90 E5 80 00 13 E3 10 D0 4D E2 00 50 A0 E1 8B 00 00 0A DC 82 9F E5 00 80 98 E2 01 80 A0 13 00 00 58 E3 AD 00 00 0A 0D 00 A0 E1 C8 12 9F E5 00 20 A0 E3 ?? ?? ?? ?? C0 62 9F E5 ?? ?? ?? ?? 0C 30 96 E5 13 7D 40 E2 07 00 53 E1 00 90 A0 E1 0E 00 00 0A 01 10 A0 E3 04 20 86 E2 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 97 00 00 1A 0C 70 86 E5 08 30 96 E5 00 10 95 E5 01 30 83 E2 02 49 11 E2 00 50 86 E5 08 30 86 E5 18 00 00 1A 48 A0 95 E5 08 30 9A E5 03 00 57 E1 0F 00 00 0A 01 10 A0 E3 0A 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 70 00 00 1A 48 30 95 E5 08 70 83 E5 03 A0 A0 E1 04 30 9A E5 00 10 95 E5 01 30 83 E2 04 30 8A E5 02 49 01 E2 EC 21 9F E5 00 30 92 E5 00 00 53 E3 0E 00 00 0A 03 00 55 E1 54 00 00 0A 34 20 93 E5 00 00 52 E3 09 00 00 0A 02 00 55 E1 34 20 83 02 03 00 00 1A 43 00 00 EA 03 00 55 E1 40 00 00 0A 03 20 A0 E1 34 30 92 E5 00 00 53 E3 F9 FF FF 1A 80 10 C1 E3 00 00 54 E3 00 10 85 E5 17 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 11 00 00 1A 08 40 85 E5 00 70 95 E5 00 10 A0 E3 07 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 57 E1 F0 FF FF 1A 01 00 57 E3 31 00 00 CA 08 30 96 E5 01 30 43 E2 00 20 A0 E3 00 00 53 E3 00 20 86 E5 08 30 86 E5 14 21 9F E5 11 00 00 1A 0C 30 82 E5 04 50 96 E5 00 10 A0 E3 05 40 A0 E1 04 21 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 22 00 00 CA 00 00 58 E3 0D 00 A0 11 00 10 A0 13 ?? ?? ?? ?? 10 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 34 20 82 E2 18 C0 96 E5 34 00 95 E5 01 C0 8C E2 80 10 C1 E3 00 00 54 E3 00 00 82 E5 18 C0 86 E5 00 10 85 E5 D4 FF FF 1A BB FF FF EA 18 00 96 E5 34 30 95 E5 01 00 80 E2 18 00 86 E5 00 30 82 E5 B1 FF FF EA B8 14 19 E5 05 00 A0 E1 01 10 81 E3 01 20 A0 E3 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF C5 FF FF EA 0A 00 A0 E1 ?? ?? ?? ?? 8B FF FF EA B8 14 19 E5 02 00 A0 E1 01 10 81 E3 01 20 A0 E3 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF D4 FF FF EA 14 30 9F E5 08 01 8D E8 52 FF FF EA 02 00 A0 E1 ?? ?? ?? ?? 64 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_3_0 {
	meta:
		name = "_IO_link_in"
		size = 688
		refs = "003c _pthread_cleanup_push_defer 0044 __aeabi_read_tp 0148 _pthread_cleanup_pop_restore 025c __lll_lock_wait_private 02a0 flush_cleanup 02a8 _IO_list_all"
	strings:
		$1 = { F0 47 2D E9 00 30 90 E5 80 20 13 E2 10 D0 4D E2 00 60 A0 E1 4C 00 00 1A 7C 82 9F E5 00 80 98 E2 01 80 A0 13 80 30 83 E3 00 00 58 E3 00 30 80 E5 8B 00 00 0A 0D 00 A0 E1 60 12 9F E5 ?? ?? ?? ?? 5C 52 9F E5 ?? ?? ?? ?? 0C 30 95 E5 13 AD 40 E2 0A 00 53 E1 00 90 A0 E1 0E 00 00 0A 01 10 A0 E3 04 20 85 E2 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 70 00 00 1A 0C A0 85 E5 08 20 95 E5 00 30 96 E5 01 20 82 E2 02 49 13 E2 08 20 85 E5 00 60 85 E5 EC 21 9F E5 27 00 00 0A E8 31 9F E5 18 10 92 E5 00 00 93 E5 01 10 81 E2 34 00 86 E5 00 60 83 E5 18 10 82 E5 08 30 95 E5 01 30 43 E2 00 20 A0 E3 00 00 53 E3 00 20 85 E5 08 30 85 E5 B0 21 9F E5 11 00 00 1A 0C 30 82 E5 04 60 95 E5 00 10 A0 E3 06 40 A0 E1 A0 21 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 4C 00 00 CA 00 00 58 E3 0D 00 A0 11 00 10 A0 13 ?? ?? ?? ?? 10 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 48 70 96 E5 08 20 97 E5 02 00 5A E1 10 00 00 0A 01 10 A0 E3 07 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 3C 00 00 1A 48 30 96 E5 03 70 A0 E1 08 A0 83 E5 00 30 96 E5 F4 20 9F E5 04 00 97 E5 18 C0 95 E5 00 10 92 E5 02 09 13 E3 01 00 80 E2 01 30 8C E2 04 00 87 E5 00 60 82 E5 34 10 86 E5 18 30 85 E5 BD FF FF 1A 04 30 97 E5 01 30 43 E2 00 00 53 E3 04 30 87 E5 B8 FF FF 1A 08 30 87 E5 00 60 97 E5 00 10 A0 E3 06 40 A0 E1 07 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 A6 FF FF DA B8 14 19 E5 07 00 A0 E1 01 10 81 E3 01 20 A0 E3 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 9E FF FF EA 02 00 A0 E1 ?? ?? ?? ?? 8B FF FF EA 34 30 9F E5 08 01 8D E8 73 FF FF EA B8 14 19 E5 02 00 A0 E1 01 10 81 E3 01 20 A0 E3 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF AA FF FF EA 07 00 A0 E1 ?? ?? ?? ?? BF FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_4_0 {
	meta:
		name = "_IO_least_marker"
		size = 48
	strings:
		$1 = { 30 30 90 E5 0C 00 90 E5 00 00 53 E3 01 00 60 E0 ?? ?? ?? ?? 08 20 93 E5 00 30 93 E5 02 00 50 E1 02 00 A0 A1 00 00 53 E3 F9 FF FF 1A ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_5_0 {
	meta:
		name = "_IO_switch_to_main_get_area"
		size = 60
	strings:
		$1 = { 04 40 2D E5 00 40 90 E5 24 30 90 E5 08 10 90 E5 2C C0 90 E5 0C 20 90 E5 01 4C C4 E3 00 40 80 E5 08 C0 80 E5 2C 10 80 E5 24 20 80 E5 0C 30 80 E5 04 30 80 E5 04 40 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_6_0 {
	meta:
		name = "_IO_switch_to_backup_area"
		size = 60
	strings:
		$1 = { 04 40 2D E5 00 40 90 E5 2C 30 90 E5 08 C0 90 E5 0C 20 90 E5 24 10 90 E5 01 4C 84 E3 00 40 80 E5 2C C0 80 E5 08 30 80 E5 04 30 80 E5 0C 10 80 E5 24 20 80 E5 04 40 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_7_0 {
	meta:
		name = "_IO_switch_to_get_mode"
		size = 132
	strings:
		$1 = { 10 20 80 E2 0C 00 92 E8 02 00 53 E1 10 40 2D E9 00 40 A0 E1 11 00 00 8A 00 20 94 E5 01 0C 12 E3 0B 00 00 1A 08 00 94 E5 1C 10 94 E5 03 00 50 E1 0C 10 84 E5 08 30 84 35 02 2B C2 E3 0C 00 84 E8 18 30 84 E5 10 30 84 E5 00 00 A0 E3 10 40 BD E8 ?? ?? ?? ?? 28 10 94 E5 0C 10 84 E5 F5 FF FF EA 98 30 90 E5 00 10 E0 E3 0C C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 01 00 70 E3 F3 FF FF 0A 14 30 94 E5 E4 FF FF EA }
	condition:
		$1
}

rule file_323_8_0 {
	meta:
		name = "_IO_free_backup_area"
		size = 100
		refs = "0040 free"
	strings:
		$1 = { 00 30 90 E5 01 0C 13 E3 10 40 2D E9 00 40 A0 E1 11 00 00 0A 08 C0 90 E5 2C 10 90 E5 24 20 94 E5 0C 00 90 E5 01 3C C3 E3 00 30 84 E5 2C C0 84 E5 08 10 84 E5 24 00 84 E5 0C 20 84 E5 04 20 84 E5 ?? ?? ?? ?? 00 30 A0 E3 24 30 84 E5 2C 30 84 E5 28 30 84 E5 10 40 BD E8 ?? ?? ?? ?? 24 00 90 E5 F6 FF FF EA }
	condition:
		$1
}

rule file_323_9_0 {
	meta:
		name = "__overflow"
		size = 44
	strings:
		$1 = { 08 40 2D E9 6C 30 90 E5 00 00 53 E3 00 30 E0 03 6C 30 80 05 98 30 90 E5 0C C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_10_0 {
	meta:
		name = "__underflow"
		size = 260
		refs = "00d4 _IO_switch_to_get_mode 00fc _IO_free_backup_area"
	strings:
		$1 = { 6C 30 90 E5 00 00 53 E3 00 30 E0 03 10 40 2D E9 00 40 A0 E1 6C 30 80 05 01 00 00 0A 01 00 73 E3 2E 00 00 1A 00 30 94 E5 02 0B 13 E3 27 00 00 1A 04 30 94 E5 08 20 94 E5 02 00 53 E1 20 00 00 3A 00 30 94 E5 01 0C 13 E3 0E 00 00 1A 30 30 94 E5 00 00 53 E3 24 00 00 0A 04 00 A0 E1 08 10 94 E5 97 FD FF EB 00 00 50 E3 1C 00 00 1A 98 30 94 E5 04 00 A0 E1 10 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 10 40 BD E8 ?? ?? ?? ?? 24 10 94 E5 2C 00 94 E5 0C C0 94 E5 01 3C C3 E3 01 00 50 E1 00 30 84 E5 08 00 84 E5 2C 20 84 E5 04 10 84 E5 0C 10 84 E5 24 C0 84 E5 E4 FF FF 9A 00 00 D1 E5 10 40 BD E8 ?? ?? ?? ?? 00 00 D3 E5 10 40 BD E8 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 01 00 70 E3 D3 FF FF 1A 00 00 E0 E3 10 40 BD E8 ?? ?? ?? ?? 24 30 94 E5 00 00 53 E3 DC FF FF 0A 04 00 A0 E1 ?? ?? ?? ?? D9 FF FF EA }
	condition:
		$1
}

rule file_323_11_0 {
	meta:
		name = "__uflow"
		size = 276
		refs = "00e4 _IO_switch_to_get_mode 010c _IO_free_backup_area"
	strings:
		$1 = { 6C 30 90 E5 00 00 53 E3 00 30 E0 03 10 40 2D E9 00 40 A0 E1 6C 30 80 05 01 00 00 0A 01 00 73 E3 32 00 00 1A 00 30 94 E5 02 0B 13 E3 2B 00 00 1A 04 30 94 E5 08 20 94 E5 02 00 53 E1 22 00 00 3A 00 30 94 E5 01 0C 13 E3 0E 00 00 1A 30 30 94 E5 00 00 53 E3 28 00 00 0A 04 00 A0 E1 08 10 94 E5 56 FD FF EB 00 00 50 E3 20 00 00 1A 98 30 94 E5 04 00 A0 E1 14 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 10 40 BD E8 ?? ?? ?? ?? 24 10 94 E5 2C 00 94 E5 0C C0 94 E5 01 3C C3 E3 01 00 50 E1 00 30 84 E5 08 00 84 E5 2C 20 84 E5 0C 10 84 E5 24 C0 84 E5 04 10 84 95 E4 FF FF 9A 01 30 81 E2 04 30 84 E5 10 40 BD E8 00 00 D1 E5 ?? ?? ?? ?? 01 20 83 E2 04 20 84 E5 10 40 BD E8 00 00 D3 E5 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 01 00 70 E3 CF FF FF 1A 00 00 E0 E3 10 40 BD E8 ?? ?? ?? ?? 24 30 94 E5 00 00 53 E3 D8 FF FF 0A 04 00 A0 E1 ?? ?? ?? ?? D5 FF FF EA }
	condition:
		$1
}

rule file_323_12_0 {
	meta:
		name = "_IO_setb"
		size = 112
		refs = "0064 __munmap"
	strings:
		$1 = { F8 40 2D E9 00 40 A0 E1 1C 00 90 E5 00 00 50 E3 00 C0 94 E5 01 50 A0 E1 02 60 A0 E1 03 70 A0 E1 01 00 00 0A 01 00 1C E3 07 00 00 0A 00 00 57 E3 01 C0 CC 13 01 C0 8C 03 1C 50 84 E5 20 60 84 E5 00 C0 84 E5 F8 40 BD E8 ?? ?? ?? ?? 20 10 94 E5 01 10 60 E0 FF 1E 81 E2 0F 10 81 E2 FF 1E C1 E3 0F 10 C1 E3 ?? ?? ?? ?? 00 C0 94 E5 EE FF FF EA }
	condition:
		$1
}

rule file_323_13_0 {
	meta:
		name = "_IO_doallocbuf"
		size = 104
		refs = "0064 _IO_setb"
	strings:
		$1 = { 1C 30 90 E5 00 00 53 E3 10 40 2D E9 00 40 A0 E1 01 00 00 0A 10 40 BD E8 ?? ?? ?? ?? 00 30 90 E5 02 00 13 E3 02 00 00 0A 6C 30 90 E5 00 00 53 E3 06 00 00 DA 98 30 94 E5 04 00 A0 E1 34 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 01 00 70 E3 F0 FF FF 1A 04 00 A0 E1 47 10 84 E2 48 20 84 E2 00 30 A0 E3 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_15_0 {
	meta:
		name = "_IO_default_uflow"
		size = 52
	strings:
		$1 = { 98 30 90 E5 10 40 2D E9 00 40 A0 E1 10 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 01 00 70 E3 04 30 94 15 01 20 83 12 04 20 84 15 10 40 BD E8 00 00 D3 15 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_16_0 {
	meta:
		name = "_IO_default_xsputn"
		size = 200
		refs = "00ac mempcpy"
	strings:
		$1 = { F0 41 2D E9 00 70 52 E2 00 50 A0 E1 01 60 A0 E1 07 00 A0 01 29 00 00 0A 07 40 A0 E1 14 00 85 E2 03 00 90 E8 01 00 50 E1 10 00 00 2A 01 10 60 E0 01 00 54 E1 04 80 A0 31 01 80 A0 21 14 00 58 E3 17 00 00 8A 00 00 58 E3 07 00 00 0A 08 20 80 E0 06 10 A0 E1 01 C0 D1 E4 01 C0 C0 E4 02 00 50 E1 FB FF FF 1A 14 00 85 E5 08 60 86 E0 04 40 68 E0 00 00 54 E3 10 00 00 0A 00 10 D6 E5 98 30 95 E5 05 00 A0 E1 0C C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 01 00 70 E3 01 60 86 E2 07 00 00 0A 01 40 44 E2 DD FF FF EA 06 10 A0 E1 08 20 A0 E1 ?? ?? ?? ?? 08 60 86 E0 14 00 85 E5 EB FF FF EA 07 00 64 E0 F0 41 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_17_0 {
	meta:
		name = "_IO_sgetn"
		size = 28
	strings:
		$1 = { 08 40 2D E9 98 30 90 E5 20 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_18_0 {
	meta:
		name = "_IO_default_xsgetn"
		size = 168
		refs = "0070 __underflow 0090 mempcpy"
	strings:
		$1 = { F0 41 2D E9 02 70 A0 E1 00 40 A0 E1 01 60 A0 E1 02 50 A0 E1 0A 00 94 E9 03 00 51 E1 10 00 00 2A 03 30 61 E0 03 00 55 E1 05 80 A0 31 03 80 A0 21 14 00 58 E3 13 00 00 8A 00 00 58 E3 07 00 00 0A 08 20 81 E0 06 30 A0 E1 01 C0 D1 E4 02 00 51 E1 01 C0 C3 E4 FB FF FF 1A 04 10 84 E5 08 60 86 E0 05 50 68 E0 00 00 55 E3 03 00 00 0A 04 00 A0 E1 ?? ?? ?? ?? 01 00 70 E3 E5 FF FF 1A 07 00 65 E0 F0 41 BD E8 ?? ?? ?? ?? 06 00 A0 E1 08 20 A0 E1 ?? ?? ?? ?? 04 30 94 E5 08 30 83 E0 00 60 A0 E1 04 30 84 E5 ED FF FF EA }
	condition:
		$1
}

rule file_323_19_0 {
	meta:
		name = "_IO_default_setbuf"
		size = 172
		refs = "0054 _IO_setb"
	strings:
		$1 = { 70 40 2D E9 98 30 90 E5 00 40 A0 E1 01 60 A0 E1 02 50 A0 E1 30 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 01 00 70 E3 1E 00 00 0A 00 00 55 E3 00 00 56 13 00 30 A0 13 01 30 A0 03 10 00 00 0A 00 00 94 E5 02 00 C0 E3 00 00 84 E5 06 10 A0 E1 05 20 86 E0 04 00 A0 E1 ?? ?? ?? ?? 00 30 A0 E3 18 30 84 E5 14 30 84 E5 10 30 84 E5 08 30 84 E5 04 30 84 E5 0C 30 84 E5 04 00 A0 E1 70 40 BD E8 ?? ?? ?? ?? 00 30 94 E5 04 10 A0 E1 02 30 83 E3 47 30 81 E4 04 00 A0 E1 48 20 84 E2 00 30 A0 E3 ?? ?? ?? ?? EC FF FF EA 00 00 A0 E3 F2 FF FF EA }
	condition:
		$1
}

rule file_323_20_0 {
	meta:
		name = "_IO_default_seekpos"
		size = 48
	strings:
		$1 = { 04 E0 2D E5 0C D0 4D E2 10 E0 9D E5 00 C0 A0 E3 98 10 90 E5 00 50 8D E8 24 C0 91 E5 0F E0 A0 E1 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_21_0 {
	meta:
		name = "_IO_default_doallocate"
		size = 88
		refs = "0028 __mmap 0044 _IO_setb"
	strings:
		$1 = { 10 40 2D E9 00 30 A0 E3 08 D0 4D E2 00 20 E0 E3 0C 00 8D E8 00 40 A0 E1 02 1A A0 E3 03 00 A0 E1 03 20 A0 E3 22 30 A0 E3 ?? ?? ?? ?? 01 00 70 E3 05 00 00 0A 00 10 A0 E1 02 2A 81 E2 04 00 A0 E1 01 30 A0 E3 ?? ?? ?? ?? 01 00 A0 E3 08 D0 8D E2 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_22_0 {
	meta:
		name = "_IO_old_init"
		size = 100
	strings:
		$1 = { 48 20 90 E5 FB 14 81 E3 00 30 A0 E3 00 00 52 E3 AD 18 81 E3 00 10 80 E5 3C 30 80 E5 1C 30 80 E5 20 30 80 E5 0C 30 80 E5 04 30 80 E5 08 30 80 E5 10 30 80 E5 14 30 80 E5 18 30 80 E5 34 30 80 E5 24 30 80 E5 28 30 80 E5 2C 30 80 E5 30 30 80 E5 B4 34 C0 E1 00 30 82 15 04 30 82 15 08 30 82 15 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_23_0 {
	meta:
		name = "_IO_init"
		size = 40
		refs = "0008 _IO_old_init"
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 ?? ?? ?? ?? 00 30 E0 E3 00 20 A0 E3 60 20 84 E5 6C 30 84 E5 5C 30 84 E5 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_24_0 {
	meta:
		name = "_IO_no_init"
		size = 132
		refs = "0010 _IO_old_init"
	strings:
		$1 = { 70 40 2D E9 02 60 A0 E1 00 50 A0 E1 03 40 A0 E1 ?? ?? ?? ?? 00 00 56 E3 6C 60 85 E5 12 00 00 BA 00 30 A0 E3 10 20 9D E5 5C 40 85 E5 18 30 84 E5 1C 30 84 E5 08 30 84 E5 00 30 84 E5 04 30 84 E5 0C 30 84 E5 10 30 84 E5 14 30 84 E5 20 30 84 E5 24 30 84 E5 28 30 84 E5 00 30 A0 E3 B8 20 84 E5 60 30 85 E5 70 40 BD E8 ?? ?? ?? ?? 00 30 E0 E3 5C 30 85 E5 00 30 A0 E3 60 30 85 E5 70 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_26_0 {
	meta:
		name = "_IO_default_finish"
		size = 140
		refs = "004c free 0060 _IO_un_link 007c __munmap"
	strings:
		$1 = { 38 40 2D E9 00 40 A0 E1 1C 00 90 E5 00 00 50 E3 02 00 00 0A 00 30 94 E5 01 50 13 E2 10 00 00 0A 30 30 94 E5 00 00 53 E3 00 20 A0 13 03 00 00 0A 04 20 83 E5 00 30 93 E5 00 00 53 E3 FB FF FF 1A 24 00 94 E5 00 00 50 E3 02 00 00 0A ?? ?? ?? ?? 00 30 A0 E3 24 30 84 E5 04 00 A0 E1 38 40 BD E8 ?? ?? ?? ?? 20 10 94 E5 01 10 60 E0 FF 1E 81 E2 0F 10 81 E2 FF 1E C1 E3 0F 10 C1 E3 ?? ?? ?? ?? 20 50 84 E5 1C 50 84 E5 E4 FF FF EA }
	condition:
		$1
}

rule file_323_28_0 {
	meta:
		name = "_IO_sputbackc"
		size = 96
	strings:
		$1 = { 04 30 90 E5 0C 20 90 E5 02 00 53 E1 10 40 2D E9 00 40 A0 E1 05 00 00 9A 01 00 53 E5 FF 20 01 E2 02 00 50 E1 01 30 43 02 04 30 84 05 06 00 00 0A 98 30 94 E5 04 00 A0 E1 18 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 01 00 70 E3 02 00 00 0A 00 30 94 E5 10 30 C3 E3 00 30 84 E5 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_29_0 {
	meta:
		name = "_IO_sungetc"
		size = 92
	strings:
		$1 = { 04 30 90 E5 0C 20 90 E5 02 00 53 E1 10 40 2D E9 00 40 A0 E1 07 00 00 9A 01 20 43 E2 04 20 80 E5 01 00 53 E5 00 30 94 E5 10 30 C3 E3 00 30 84 E5 10 40 BD E8 ?? ?? ?? ?? 98 30 90 E5 00 10 E0 E3 18 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 01 00 70 E3 F3 FF FF 1A 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_30_0 {
	meta:
		name = "_IO_adjust_column"
		size = 100
	strings:
		$1 = { 30 00 2D E9 02 50 81 E0 05 00 51 E1 0D 00 00 2A 01 30 55 E5 0A 00 53 E3 01 C0 45 E2 01 10 41 12 02 30 45 12 04 00 00 1A 09 00 00 EA 00 40 DC E5 0A 00 54 E3 01 30 43 E2 05 00 00 0A 01 00 53 E1 03 C0 A0 E1 F8 FF FF 1A 00 00 82 E0 30 00 BD E8 ?? ?? ?? ?? 05 00 6C E0 01 00 40 E2 30 00 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_31_0 {
	meta:
		name = "_IO_flush_all_lockp"
		size = 832
		refs = "0028 _pthread_cleanup_push_defer 0038 __aeabi_read_tp 0298 _pthread_cleanup_pop_restore 02bc __lll_lock_wait_private 0330 flush_cleanup 0338 _IO_list_all"
	strings:
		$1 = { F0 4F 2D E9 00 80 50 E2 1C D0 4D E2 A6 00 00 0A 14 33 9F E5 00 00 53 E3 B5 00 00 0A 00 20 A0 E3 08 00 8D E2 04 13 9F E5 ?? ?? ?? ?? 01 20 A0 E3 04 20 8D E5 F8 62 9F E5 ?? ?? ?? ?? 0C 30 96 E5 13 5D 40 E2 05 00 53 E1 0E 00 00 0A 01 10 A0 E3 04 20 86 E2 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 98 00 00 1A 0C 50 86 E5 08 30 96 E5 01 30 83 E2 08 30 86 E5 9C 32 9F E5 00 50 93 E5 00 00 55 E3 18 90 96 E5 5C 00 00 0A 00 A0 A0 E3 33 00 00 EA 5C 30 95 E5 10 20 93 E5 0C 30 93 E5 03 00 52 E1 07 00 00 9A 98 30 95 E5 05 00 A0 E1 00 10 E0 E3 0C C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 01 00 70 E3 00 A0 E0 03 00 00 58 E3 1A 00 00 0A 00 30 95 E5 02 09 13 E3 17 00 00 1A 48 70 95 E5 04 30 97 E5 01 30 43 E2 00 00 53 E3 04 30 87 E5 11 00 00 1A 08 30 87 E5 00 B0 97 E5 00 10 A0 E3 0B 40 A0 E1 07 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 5B E1 F0 FF FF 1A 01 00 5B E3 5A 00 00 CA 18 30 96 E5 03 00 59 E1 03 90 A0 11 CC 31 9F 15 34 50 95 05 00 50 93 15 00 20 A0 E3 00 00 55 E3 00 20 86 E5 27 00 00 0A 00 00 58 E3 00 50 86 E5 1B 00 00 0A 00 40 95 E5 02 49 14 E2 18 00 00 1A 48 70 95 E5 ?? ?? ?? ?? 08 30 97 E5 13 BD 40 E2 0B 00 53 E1 0F 00 00 0A 01 10 A0 E3 07 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 34 00 00 1A 48 30 95 E5 08 B0 83 E5 03 70 A0 E1 04 30 97 E5 01 30 83 E2 04 30 87 E5 6C 30 95 E5 00 00 53 E3 A9 FF FF CA 14 20 95 E5 10 30 95 E5 03 00 52 E1 AA FF FF 8A B1 FF FF EA 05 A0 A0 E1 00 00 58 E3 17 00 00 0A 08 30 96 E5 01 30 43 E2 00 00 53 E3 08 30 86 E5 F4 20 9F E5 11 00 00 1A 0C 30 82 E5 04 50 96 E5 00 10 A0 E3 05 40 A0 E1 E4 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 1F 00 00 CA 04 20 9D E5 00 00 52 E3 08 00 8D 12 00 10 A0 13 ?? ?? ?? ?? 0A 00 A0 E1 1C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 80 60 9F E5 04 80 8D E5 76 FF FF EA 07 00 A0 E1 ?? ?? ?? ?? C7 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 07 00 A0 E1 02 10 81 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 9B FF FF EA 02 00 A0 E1 ?? ?? ?? ?? 63 FF FF EA 34 20 9F E5 0C 30 8D E5 04 30 8D E5 08 20 8D E5 4A FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 1C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF D6 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_32_0 {
	meta:
		name = "_IO_cleanup"
		size = 504
		refs = "0008 _IO_flush_all_lockp 006c __aeabi_read_tp 0114 __sched_yield 01ec _IO_list_all"
	strings:
		$1 = { F8 4F 2D E9 00 00 A0 E3 ?? ?? ?? ?? D8 31 9F E5 00 50 93 E5 00 00 55 E3 00 90 A0 E1 38 00 00 0A C8 81 9F E5 01 B0 A0 E3 00 60 E0 E3 00 30 95 E5 02 A0 13 E2 2E 00 00 1A B4 21 9F E5 02 20 03 E0 08 00 52 E3 2A 00 00 0A 6C 30 95 E5 00 00 53 E3 27 00 00 0A 48 30 95 E5 00 00 53 E3 03 20 A0 E1 01 10 A0 E3 00 40 A0 E3 12 00 00 0A ?? ?? ?? ?? 13 7D 40 E2 08 00 93 E5 00 00 57 E1 56 00 00 0A 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 18 00 00 1A 48 20 95 E5 08 70 82 E5 04 B0 82 E5 10 30 D8 E5 00 00 53 E3 02 00 00 1A 00 30 95 E5 01 00 13 E3 14 00 00 0A 00 10 A0 E3 01 20 A0 E1 98 30 95 E5 05 00 A0 E1 2C C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 02 00 5A E3 16 00 00 1A 6C 60 85 E5 34 50 95 E5 00 00 55 E3 C9 FF FF 1A 09 00 A0 E1 F8 4F BD E8 ?? ?? ?? ?? 01 A0 8A E2 ?? ?? ?? ?? 02 00 5A E3 E5 FF FF 0A CB FF FF EA 1C 20 95 E5 20 00 95 E5 14 10 98 E5 01 30 83 E3 00 00 62 E0 00 30 85 E5 64 20 85 E5 68 00 85 E5 60 10 85 E5 14 50 88 E5 DF FF FF EA 48 70 95 E5 00 00 57 E3 E5 FF FF 0A 04 30 97 E5 01 30 43 E2 00 00 53 E3 04 30 87 E5 E0 FF FF 1A 08 30 87 E5 00 A0 97 E5 00 10 A0 E3 0A 40 A0 E1 07 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 5A E1 F0 FF FF 1A 01 00 5A E3 CE FF FF DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 07 00 A0 E1 02 10 81 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF C5 FF FF EA 04 20 93 E5 01 20 82 E2 04 20 83 E5 B2 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? 08 10 00 00 }
	condition:
		$1
}

rule file_323_34_0 {
	meta:
		name = "_IO_flush_all_linebuffered"
		size = 736
		refs = "002c _pthread_cleanup_push_defer 0034 __aeabi_read_tp 0248 _pthread_cleanup_pop_restore 025c __lll_lock_wait_private 02d0 flush_cleanup 02d8 _IO_list_all"
	strings:
		$1 = { F0 4F 2D E9 C0 32 9F E5 00 30 93 E2 01 30 A0 13 1C D0 4D E2 00 00 53 E3 00 30 8D E5 A5 00 00 0A 08 00 8D E2 A4 12 9F E5 00 20 A0 E3 ?? ?? ?? ?? 9C 62 9F E5 ?? ?? ?? ?? 0C 30 96 E5 13 9D 40 E2 09 00 53 E1 04 00 8D E5 0E 00 00 0A 01 10 A0 E3 04 20 86 E2 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 89 00 00 1A 0C 90 86 E5 48 22 9F E5 08 30 96 E5 00 50 92 E5 01 30 83 E2 00 00 55 E3 08 30 86 E5 18 80 96 E5 4C 00 00 0A 00 A0 A0 E3 23 00 00 EA 00 30 95 E5 02 09 13 E3 17 00 00 1A 48 70 95 E5 04 30 97 E5 01 30 43 E2 00 00 53 E3 04 30 87 E5 11 00 00 1A 08 30 87 E5 00 B0 97 E5 00 10 A0 E3 0B 40 A0 E1 07 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 5B E1 F0 FF FF 1A 01 00 5B E3 51 00 00 CA 18 30 96 E5 03 00 58 E1 AC 21 9F 15 34 50 95 05 00 50 92 15 03 80 A0 11 00 00 55 E3 00 A0 86 E5 25 00 00 0A 00 40 95 E5 02 49 14 E2 00 50 86 E5 16 00 00 1A 48 70 95 E5 08 30 97 E5 03 00 59 E1 0F 00 00 0A 01 10 A0 E3 07 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 30 00 00 1A 48 30 95 E5 08 90 83 E5 03 70 A0 E1 04 30 97 E5 01 30 83 E2 04 30 87 E5 00 30 95 E5 82 3F 03 E2 02 0C 53 E3 BC FF FF 1A 98 30 95 E5 05 00 A0 E1 00 10 E0 E3 0C C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? B5 FF FF EA 08 30 96 E5 01 30 43 E2 00 00 53 E3 08 30 86 E5 E4 20 9F E5 11 00 00 1A 0C 30 82 E5 04 50 96 E5 00 10 A0 E3 05 40 A0 E1 D4 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 13 00 00 CA 00 20 9D E5 00 00 52 E3 08 00 8D 12 00 10 A0 13 ?? ?? ?? ?? 1C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 07 00 A0 E1 ?? ?? ?? ?? CB FF FF EA 04 30 9D E5 B8 14 13 E5 07 00 A0 E1 01 10 81 E3 01 20 A0 E3 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF A4 FF FF EA 04 30 9D E5 B8 14 13 E5 02 00 A0 E1 01 10 81 E3 01 20 A0 E3 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF E2 FF FF EA 02 00 A0 E1 ?? ?? ?? ?? 72 FF FF EA 10 30 9F E5 00 20 9D E5 08 30 8D E5 0C 20 8D E5 58 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_35_0 {
	meta:
		name = "_IO_init_marker"
		size = 92
		refs = "0050 _IO_switch_to_get_mode"
	strings:
		$1 = { 38 40 2D E9 00 30 91 E5 00 50 A0 E1 02 0B 13 E3 01 40 A0 E1 04 10 85 E5 0B 00 00 1A 01 0C 13 E3 0C 30 94 05 04 20 94 05 0C 00 94 19 03 30 42 10 02 30 63 00 08 30 85 E5 30 30 94 E5 00 30 85 E5 30 50 84 E5 38 40 BD E8 ?? ?? ?? ?? 01 00 A0 E1 ?? ?? ?? ?? 00 30 94 E5 EF FF FF EA }
	condition:
		$1
}

rule file_323_36_0 {
	meta:
		name = "_IO_remove_marker"
		size = 72
	strings:
		$1 = { 04 30 90 E5 30 20 93 E5 00 00 52 E3 ?? ?? ?? ?? 02 00 50 E1 30 20 83 02 03 00 00 1A 06 00 00 EA 03 00 50 E1 04 00 00 0A 03 20 A0 E1 00 30 92 E5 00 00 53 E3 F9 FF FF 1A ?? ?? ?? ?? 00 10 90 E5 00 10 82 E5 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_38_0 {
	meta:
		name = "_IO_marker_delta"
		size = 60
	strings:
		$1 = { 04 30 90 E5 00 00 53 E3 09 00 00 0A 00 20 93 E5 01 0C 12 E3 04 20 93 05 0C 30 93 05 0C 00 93 19 03 30 42 10 08 00 90 E5 02 30 63 00 00 00 63 E0 ?? ?? ?? ?? 00 00 E0 E3 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_39_0 {
	meta:
		name = "_IO_seekmark"
		size = 172
	strings:
		$1 = { 04 30 91 E5 00 00 53 E1 30 00 2D E9 00 00 E0 13 12 00 00 1A 08 20 91 E5 00 00 52 E3 00 00 93 E5 12 00 00 BA 01 0C 10 E3 0E 00 00 0A 08 50 93 E5 2C 40 93 E5 0C C0 93 E5 24 10 93 E5 01 0C C0 E3 00 00 83 E5 2C 50 83 E5 08 40 83 E5 24 C0 83 E5 0C 10 83 E5 02 20 81 E0 04 20 83 E5 00 00 A0 E3 30 00 BD E8 ?? ?? ?? ?? 0C 10 93 E5 F8 FF FF EA 01 0C 10 E3 0A 00 00 1A 08 50 93 E5 2C 10 93 E5 0C 40 93 E5 24 C0 93 E5 01 0C 80 E3 00 00 83 E5 2C 50 83 E5 08 10 83 E5 24 40 83 E5 0C C0 83 E5 EB FF FF EA 08 10 93 E5 E9 FF FF EA }
	condition:
		$1
}

rule file_323_40_0 {
	meta:
		name = "_IO_unsave_markers"
		size = 32
		refs = "001c _IO_free_backup_area"
	strings:
		$1 = { 30 30 90 E5 00 00 53 E3 00 30 A0 13 30 30 80 15 24 30 90 E5 00 00 53 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1125_23_0 {
	meta:
		name = "_IO_unsave_wmarkers"
		size = 32
		refs = "001c _IO_free_wbackup_area"
	strings:
		$1 = { 30 30 90 E5 00 00 53 E3 00 30 A0 13 30 30 80 15 24 30 90 E5 00 00 53 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_41_0 {
	meta:
		name = "_IO_default_pbackfail"
		size = 312
		refs = "00c8 malloc 00e4 memcpy 00f0 free"
	strings:
		$1 = { F8 43 2D E9 04 50 90 E5 0C 70 90 E5 07 00 55 E1 00 40 A0 E1 01 60 A0 E1 14 00 00 8A 00 10 90 E5 01 0C 11 E3 24 00 00 1A 24 30 94 E5 00 00 53 E3 33 00 00 0A 05 C0 A0 E1 2C 50 94 E5 08 20 94 E5 01 1C 81 E3 00 10 84 E5 0C 30 84 E5 24 C0 84 E5 2C 20 84 E5 08 50 84 E5 01 30 45 E2 04 30 84 E5 01 60 45 E5 FF 00 06 E2 F8 43 BD E8 ?? ?? ?? ?? 00 30 90 E5 01 0C 13 E3 F6 FF FF 1A 01 30 55 E5 01 00 53 E1 01 50 45 02 04 50 80 05 F4 FF FF 0A 24 30 90 E5 00 00 53 E3 19 00 00 0A 05 10 A0 E1 E1 F8 FF EB 00 00 50 E3 20 00 00 1A 02 10 94 E8 2C 50 94 E5 24 30 94 E5 DF FF FF EA 08 80 94 E5 08 80 67 E0 88 00 A0 E1 ?? ?? ?? ?? 00 90 50 E2 16 00 00 0A 08 50 89 E0 08 20 A0 E1 07 10 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 08 80 85 E0 0C 00 94 E5 ?? ?? ?? ?? 08 80 84 E5 28 50 84 E5 0C 90 84 E5 D4 FF FF EA 80 00 A0 E3 ?? ?? ?? ?? 00 00 50 E3 06 00 00 0A 80 20 80 E2 05 C0 A0 E1 28 20 84 E5 00 10 94 E5 00 30 A0 E1 02 50 A0 E1 C2 FF FF EA 00 00 E0 E3 CB FF FF EA }
	condition:
		$1
}

rule file_323_52_0 {
	meta:
		name = "_IO_list_lock"
		size = 124
		refs = "0008 __aeabi_read_tp 0070 __lll_lock_wait_private"
	strings:
		$1 = { 70 40 2D E9 6C 50 9F E5 ?? ?? ?? ?? 0C 30 95 E5 13 6D 40 E2 06 00 53 E1 0E 00 00 0A 01 10 A0 E3 04 20 85 E2 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 05 00 00 1A 0C 60 85 E5 08 30 95 E5 01 30 83 E2 08 30 85 E5 70 40 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? F6 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_53_0 {
	meta:
		name = "_IO_list_unlock"
		size = 152
		refs = "006c __aeabi_read_tp"
		altNames = "unlock"
	strings:
		$1 = { F0 40 2D E9 84 50 9F E5 08 30 95 E5 01 30 43 E2 00 00 53 E3 08 30 85 E5 11 00 00 1A 0C 30 85 E5 04 60 95 E5 00 10 A0 E3 06 40 A0 E1 60 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 01 00 00 CA F0 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 10 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF F4 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_54_0 {
	meta:
		name = "_IO_list_resetlock"
		size = 28
	strings:
		$1 = { 10 30 9F E5 00 20 A0 E3 04 20 83 E5 08 20 83 E5 0C 20 83 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_55_0 {
	meta:
		name = "buffer_free"
		size = 88
		refs = "0034 __munmap"
	strings:
		$1 = { 10 40 2D E9 48 40 9F E5 14 30 94 E5 01 20 A0 E3 00 00 53 E3 10 20 C4 E5 0B 00 00 0A 68 10 93 E5 FF 1E 81 E2 0F 10 81 E2 FF 1E C1 E3 64 00 93 E5 0F 10 C1 E3 ?? ?? ?? ?? 14 30 94 E5 60 30 93 E5 00 00 53 E3 14 30 84 E5 F3 FF FF 1A 10 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_324_0_0 {
	meta:
		name = "truncate64"
		size = 64
		refs = "002c __aeabi_read_tp 003c __libc_errno"
	strings:
		$1 = { 80 40 2D E9 00 10 A0 E3 C1 70 A0 E3 00 00 00 EF 01 0A 70 E3 01 00 00 8A 80 40 BD E8 ?? ?? ?? ?? 14 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 F6 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_325_0_0 {
	meta:
		name = "__write_nocancel"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 04 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_325_1_0 {
	meta:
		name = "__libc_write"
		size = 104
		refs = "0028 __syscall_error 0030 __libc_enable_asynccancel 004c __libc_disable_asynccancel"
	strings:
		$1 = { 60 C0 9F E5 0C C0 9F E7 00 00 3C E3 04 70 2D E5 05 00 00 1A 04 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? 0F 40 2D E9 ?? ?? ?? ?? 00 C0 A0 E1 0F 00 BD E8 04 70 A0 E3 00 00 00 EF 00 70 A0 E1 0C 00 A0 E1 ?? ?? ?? ?? 07 00 A0 E1 04 E0 9D E4 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_326_0_0 {
	meta:
		name = "wctomb"
		size = 144
		refs = "0010 __wcrtomb 0020 __aeabi_read_tp 006c __wcsmbs_load_conv 0080 __wctomb_state 0084 _nl_current_LC_CTYPE 0088 _nl_C_LC_CTYPE 008c __wcsmbs_gconv_fcts_c"
	strings:
		$1 = { 00 00 50 E3 10 40 2D E9 03 00 00 0A 6C 20 9F E5 ?? ?? ?? ?? 10 40 BD E8 ?? ?? ?? ?? 60 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 00 40 93 E5 14 30 94 E5 00 00 53 E3 07 00 00 0A 3C 20 9F E5 00 10 A0 E3 04 10 82 E5 00 10 82 E5 08 30 93 E5 10 40 BD E8 34 00 93 E5 ?? ?? ?? ?? 24 30 9F E5 03 00 54 E1 03 00 00 0A 04 00 A0 E1 ?? ?? ?? ?? 14 30 94 E5 F0 FF FF EA 0C 30 9F E5 EE FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_327_0_0 {
	meta:
		name = "sigrelse"
		size = 92
		refs = "0018 __sigprocmask 002c sigdelset"
	strings:
		$1 = { 10 40 2D E9 80 D0 4D E2 00 40 A0 E1 0D 20 A0 E1 02 00 A0 E3 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 0B 00 00 BA 04 10 A0 E1 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 06 00 00 BA 0D 10 A0 E1 02 00 A0 E3 00 20 A0 E3 ?? ?? ?? ?? 80 D0 8D E2 10 40 BD E8 ?? ?? ?? ?? 00 00 E0 E3 FA FF FF EA }
	condition:
		$1
}

rule file_675_0_0 {
	meta:
		name = "sighold"
		size = 92
		refs = "0018 __sigprocmask 002c sigaddset"
	strings:
		$1 = { 10 40 2D E9 80 D0 4D E2 00 40 A0 E1 0D 20 A0 E1 02 00 A0 E3 00 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 0B 00 00 BA 04 10 A0 E1 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 06 00 00 BA 0D 10 A0 E1 02 00 A0 E3 00 20 A0 E3 ?? ?? ?? ?? 80 D0 8D E2 10 40 BD E8 ?? ?? ?? ?? 00 00 E0 E3 FA FF FF EA }
	condition:
		$1
}

rule file_328_0_0 {
	meta:
		name = "__mempcpy"
		size = 24
		refs = "0008 memcpy"
	strings:
		$1 = { 10 40 2D E9 02 40 A0 E1 ?? ?? ?? ?? 04 00 80 E0 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_330_0_0 {
	meta:
		name = "l64a"
		size = 88
	strings:
		$1 = { 00 30 50 E2 04 40 2D E5 0C 00 00 0A 38 40 9F E5 38 C0 9F E5 00 20 A0 E3 3F 10 03 E2 01 10 DC E7 23 33 B0 E1 02 10 C4 E7 1C 00 9F E5 01 20 82 E2 F8 FF FF 1A 02 30 C0 E7 04 40 9D E4 ?? ?? ?? ?? 0C 00 9F E5 04 40 9D E4 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_331_0_0 {
	meta:
		name = "rexec_af"
		size = 1244
		refs = "0044 __snprintf 0088 getaddrinfo 00ac free 00b8 __strdup 00dc ruserpass 00f4 __socket 010c __connect 0118 __aeabi_read_tp 0138 __close 0140 __sleep 0154 perror 01a4 __listen 01bc __getsockname 01d0 __libc_sa_len 0208 getnameinfo 0228 sprintf 0230 strlen 0240 __write 0274 accept 0310 __writev 0340 __read 035c freeaddrinfo 03d4 strtol 04b0 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 01 C8 A0 E1 01 14 A0 E1 2C 1C 81 E1 65 DF 4D E2 01 18 A0 E1 18 30 8D E5 03 70 A0 E1 21 38 A0 E1 02 1C 8D E2 B0 64 51 E1 00 50 A0 E1 1C 20 8D E5 20 10 A0 E3 02 80 A0 E1 50 00 8D E2 60 24 9F E5 ?? ?? ?? ?? 01 90 A0 E3 00 C0 A0 E3 02 40 A0 E3 00 00 95 E5 50 10 8D E2 30 20 8D E2 24 30 8D E2 34 60 8D E5 6F C0 CD E5 3C C0 8D E5 40 C0 8D E5 44 C0 8D E5 48 C0 8D E5 4C C0 8D E5 38 90 8D E5 30 40 8D E5 ?? ?? ?? ?? 00 00 50 E3 D5 00 00 1A 24 30 9D E5 18 30 93 E5 00 00 53 E3 D8 00 00 0A 00 44 9F E5 00 00 94 E5 ?? ?? ?? ?? 24 30 9D E5 18 00 93 E5 ?? ?? ?? ?? 00 00 50 E3 00 00 84 E5 E7 00 00 0A 00 00 85 E5 24 30 9D E5 1C 10 8D E2 18 00 93 E5 18 20 8D E2 ?? ?? ?? ?? C8 A3 9F E5 06 60 A0 E3 24 30 9D E5 00 20 A0 E3 03 00 93 E9 ?? ?? ?? ?? 00 40 50 E2 19 00 00 BA 24 30 9D E5 14 10 93 E5 10 20 93 E5 ?? ?? ?? ?? 00 00 50 E3 17 00 00 AA ?? ?? ?? ?? 0A 30 9F E7 03 30 90 E7 6F 00 53 E3 07 00 00 1A 01 60 56 E2 05 00 00 0A 04 00 A0 E1 ?? ?? ?? ?? 09 00 A0 E1 ?? ?? ?? ?? 89 90 A0 E1 E6 FF FF EA 24 30 9D E5 18 00 93 E5 ?? ?? ?? ?? 00 00 E0 E3 65 DF 8D E2 F0 4F BD E8 ?? ?? ?? ?? 44 03 9F E5 ?? ?? ?? ?? 00 00 E0 E3 F8 FF FF EA BC 21 9D E5 00 00 52 E3 A7 00 00 0A 24 30 9D E5 00 20 A0 E3 03 00 93 E9 ?? ?? ?? ?? 00 90 50 E2 B9 00 00 BA 01 10 A0 E3 11 6E 8D E2 ?? ?? ?? ?? 80 30 A0 E3 06 10 A0 E1 09 00 A0 E1 28 20 8D E2 28 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 B2 00 00 BA 02 CC 8D E2 B0 0F 5C E1 ?? ?? ?? ?? 28 30 9D E5 03 00 50 E1 99 00 00 1A 00 20 A0 E3 20 C0 A0 E3 02 30 A0 E3 50 10 8D E2 00 10 8D E5 08 30 8D E5 00 10 A0 E1 02 30 A0 E1 04 C0 8D E5 06 00 A0 E1 ?? ?? ?? ?? 00 10 50 E2 00 20 A0 13 14 20 8D 15 6B 00 00 0A 70 B0 8D E2 90 12 9F E5 0B 00 A0 E1 ?? ?? ?? ?? 0B 00 A0 E1 ?? ?? ?? ?? 0B 10 A0 E1 01 20 80 E2 04 00 A0 E1 ?? ?? ?? ?? 80 30 A0 E3 2C 30 8D E5 68 A2 9F E5 04 00 00 EA ?? ?? ?? ?? 0A 30 9F E7 03 30 90 E7 04 00 53 E3 62 00 00 1A 09 00 A0 E1 90 10 8D E2 2C 20 8D E2 ?? ?? ?? ?? 01 00 70 E3 00 30 A0 E1 F3 FF FF 0A 09 00 A0 E1 10 30 8D E5 ?? ?? ?? ?? 10 30 9D E5 00 00 53 E3 BC 21 9D A5 00 30 82 A5 55 00 00 BA 1C 30 9D E5 03 00 A0 E1 10 31 8D E5 ?? ?? ?? ?? 18 30 9D E5 01 20 80 E2 03 00 A0 E1 14 21 8D E5 18 31 8D E5 ?? ?? ?? ?? 01 30 80 E2 B8 01 9D E5 1C 31 8D E5 20 01 8D E5 ?? ?? ?? ?? 01 00 80 E2 24 01 8D E5 D0 91 9F E5 04 00 00 EA ?? ?? ?? ?? 09 30 9F E7 03 30 90 E7 04 00 53 E3 05 00 00 1A 04 00 A0 E1 06 10 A0 E1 03 20 A0 E3 ?? ?? ?? ?? 01 00 70 E3 F4 FF FF 0A 1C 00 9D E5 08 00 50 E1 ?? ?? ?? ?? 18 00 9D E5 07 00 50 E1 ?? ?? ?? ?? 04 00 A0 E1 0B 10 A0 E1 01 20 A0 E3 ?? ?? ?? ?? 01 00 50 E3 4A 00 00 1A 70 30 DD E5 00 00 53 E3 07 00 00 1A 24 00 9D E5 ?? ?? ?? ?? 04 00 A0 E1 7C FF FF EA ?? ?? ?? ?? 70 30 DD E5 0A 00 53 E3 09 00 00 0A 0B 10 A0 E1 01 20 A0 E3 04 00 A0 E1 ?? ?? ?? ?? 00 30 A0 E1 01 00 53 E3 0B 10 A0 E1 02 00 A0 E3 03 20 A0 E1 F1 FF FF 0A 14 30 9D E5 00 00 53 E3 BC C1 9D 15 00 00 9C 15 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 24 00 9D E5 ?? ?? ?? ?? 00 00 E0 E3 63 FF FF EA 0A 20 A0 E3 50 00 8D E2 ?? ?? ?? ?? 00 08 A0 E1 20 08 A0 E1 14 00 8D E5 00 20 A0 E1 8B FF FF EA 00 00 E0 E3 59 FF FF EA 09 00 A0 E1 ?? ?? ?? ?? C0 00 9F E5 ?? ?? ?? ?? EA FF FF EA 00 30 85 E5 B4 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 40 80 E7 00 00 E0 E3 4D FF FF EA 04 00 A0 E1 9C 10 9F E5 01 20 A0 E3 ?? ?? ?? ?? BC 31 9D E5 11 6E 8D E2 14 30 8D E5 70 B0 8D E2 96 FF FF EA 80 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 09 00 A0 E1 ?? ?? ?? ?? D2 FF FF EA 64 00 9F E5 ?? ?? ?? ?? 00 00 E0 E3 38 FF FF EA 00 00 95 E5 ?? ?? ?? ?? C6 FF FF EA 04 00 A0 E1 ?? ?? ?? ?? 00 00 E0 E3 31 FF FF EA 3C 00 9F E5 ?? ?? ?? ?? 09 00 A0 E1 ?? ?? ?? ?? C2 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_333_0_0 {
	meta:
		name = "__posix_fadvise64_l64"
		size = 48
	strings:
		$1 = { B0 00 2D E9 0C 40 8D E2 14 10 9D E5 30 00 94 E8 14 70 9F E5 00 00 00 EF 01 0A 70 E3 00 00 60 82 00 00 A0 93 B0 00 BD E8 ?? ?? ?? ?? 0E 01 00 00 }
	condition:
		$1
}

rule file_334_0_0 {
	meta:
		name = "__ctype_get_mb_cur_max"
		size = 40
		refs = "0008 __aeabi_read_tp 0024 _nl_current_LC_CTYPE"
		altNames = "__aeabi_MB_CUR_MAX"
	strings:
		$1 = { 04 E0 2D E5 18 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 00 30 93 E5 04 E0 9D E4 58 00 93 E5 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_335_0_0 {
	meta:
		name = "map_newlink"
		size = 156
	strings:
		$1 = { 00 00 53 E3 30 00 2D E9 10 00 00 DA 00 C0 92 E5 01 00 7C E3 1D 00 00 0A 00 00 5C E1 1C 00 00 0A 04 20 82 E2 00 C0 A0 E3 04 00 00 EA 04 40 92 E4 01 00 74 E3 0B 00 00 0A 00 00 54 E1 06 00 00 0A 01 C0 8C E2 03 00 5C E1 02 50 A0 E1 F6 FF FF 1A 00 00 E0 E3 30 00 BD E8 ?? ?? ?? ?? 0C 00 A0 E1 30 00 BD E8 ?? ?? ?? ?? 00 00 5C E3 00 00 85 E5 F9 FF FF DA 0C 31 8C E0 83 31 6C E0 03 11 81 E0 0C 00 A0 E1 9C 10 01 E5 30 00 BD E8 ?? ?? ?? ?? 00 00 82 E5 00 00 A0 E3 ED FF FF EA }
	condition:
		$1
}

rule file_335_1_0 {
	meta:
		name = "getifaddrs_internal"
		size = 2652
		refs = "0030 __netlink_open 0044 __netlink_request 0144 __netlink_free_handle 0214 calloc 024c memset 03ec memcpy 04dc mempcpy 0a20 free 0a2c abort 0a40 __assert_fail"
	strings:
		$1 = { F0 4F 2D E9 00 80 A0 E3 20 B0 8D E2 54 D0 4D E2 54 00 0B E5 00 80 80 E5 38 00 4B E2 38 80 0B E5 34 80 0B E5 30 80 0B E5 2C 80 0B E5 28 80 0B E5 ?? ?? ?? ?? 08 00 50 E1 75 02 00 BA 38 00 4B E2 12 10 A0 E3 ?? ?? ?? ?? 08 00 50 E1 61 00 00 BA 30 30 1B E5 38 00 4B E2 01 30 83 E2 16 10 A0 E3 30 30 0B E5 ?? ?? ?? ?? 00 00 50 E3 59 00 00 BA 2C A0 1B E5 00 00 5A E3 5C 00 00 0A 34 C0 1B E5 44 80 0B E5 08 70 A0 E1 0A 40 A0 E1 08 E0 A0 E1 04 30 94 E5 00 00 53 E3 08 20 94 E5 21 00 00 0A 0F 00 52 E3 1F 00 00 9A 00 10 93 E5 0F 00 51 E3 1C 00 00 9A 01 00 52 E1 0B 00 00 2A 19 00 00 EA 03 10 81 E2 03 10 C1 E3 02 20 61 E0 0F 00 52 E3 01 30 83 E0 13 00 00 9A 00 10 93 E5 0F 00 51 E3 10 00 00 9A 02 00 51 E1 0E 00 00 8A 0C 00 93 E5 0C 00 50 E1 F1 FF FF 1A 08 50 93 E5 0C 00 94 E5 00 00 55 E1 ED FF FF 1A B4 00 D3 E1 03 00 50 E3 04 00 00 0A 10 00 50 E3 11 00 00 0A 14 00 50 E3 01 70 87 02 E5 FF FF EA 00 40 94 E5 00 00 54 E3 D6 FF FF 1A 07 70 9E E0 44 E0 0B E5 2D 00 00 1A 38 00 4B E2 ?? ?? ?? ?? 06 70 A0 E3 38 00 1B E5 00 00 00 EF 04 00 A0 E1 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 20 00 41 E2 03 00 50 E3 20 60 83 E2 16 00 00 9A B0 52 D3 E1 03 00 55 E3 13 00 00 9A 05 00 50 E1 11 00 00 3A B2 92 D3 E1 07 00 59 E3 08 00 00 1A 11 00 00 EA B0 50 D6 E1 03 00 55 E3 0A 00 00 9A 00 00 55 E1 08 00 00 8A B2 90 D6 E1 07 00 59 E3 09 00 00 0A 03 50 85 E2 03 50 C5 E3 00 00 65 E0 03 00 50 E3 05 60 86 E0 F1 FF FF 8A 01 E0 8E E2 B9 FF FF EA 00 40 E0 E3 D7 FF FF EA 04 50 45 E2 05 80 88 E0 01 E0 8E E2 B3 FF FF EA 0A 40 A0 E1 D1 FF FF EA 07 51 87 E0 85 51 67 E0 05 51 A0 E1 08 80 85 E0 08 10 A0 E1 01 00 A0 E3 70 80 0B E5 ?? ?? ?? ?? 00 00 50 E3 48 00 0B E5 EC FF FF 0A 44 00 1B E5 00 01 A0 E1 0E 30 80 E2 07 30 C3 E3 74 00 0B E5 03 D0 4D E0 FF 10 A0 E3 0D 00 A0 E1 74 20 1B E5 64 D0 0B E5 ?? ?? ?? ?? 48 10 1B E5 05 50 81 E0 5C 40 0B E5 68 50 0B E5 04 90 A0 E1 0A 70 A0 E1 04 80 97 E5 00 00 58 E3 08 A0 97 E5 F4 00 00 0A 0F 00 5A E3 F2 00 00 9A 00 50 98 E5 0F 00 55 E3 EF 00 00 9A 05 00 5A E1 ED 00 00 3A 07 60 A0 E1 0B 00 00 EA 00 30 98 E5 03 30 83 E2 03 30 C3 E3 0A A0 63 E0 0F 00 5A E3 03 80 88 E0 E3 00 00 9A 00 50 98 E5 0F 00 55 E3 E0 00 00 9A 0A 00 55 E1 DE 00 00 8A 0C 20 98 E5 34 30 1B E5 03 00 52 E1 EF FF FF 1A 08 20 98 E5 0C 30 96 E5 03 00 52 E1 EB FF FF 1A B4 30 D8 E1 03 00 53 E3 D3 00 00 0A 10 00 53 E3 1F 01 00 0A 14 00 53 E3 E4 FF FF 1A 14 00 98 E5 48 10 1B E5 64 20 1B E5 44 30 1B E5 01 00 40 E2 F5 FD FF EB 5C 10 1B E5 44 20 1B E5 01 00 70 E3 18 70 45 E2 18 40 88 E2 02 30 81 E0 B7 01 00 0A 00 21 80 E0 82 21 60 E0 48 00 1B E5 03 51 83 E0 5C 10 1B E5 02 21 80 E0 85 51 63 E0 08 20 92 E5 00 00 53 E3 05 51 80 E0 9C 50 05 C5 01 10 81 E2 03 00 57 E3 08 20 85 E5 5C 10 0B E5 2A 00 00 9A B8 31 D8 E1 03 00 53 E3 27 00 00 9A 03 00 57 E1 25 00 00 3A 88 20 85 E2 68 00 85 E2 66 10 85 E2 40 20 0B E5 4C 00 0B E5 60 10 0B E5 50 A0 0B E5 58 60 0B E5 B2 20 D4 E1 01 20 42 E2 04 A0 84 E2 04 C0 43 E2 03 00 52 E3 02 F1 9F 97 08 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 5C E3 0A 10 A0 01 0C 20 A0 01 4C 00 1B 05 ?? ?? ?? ?? B0 30 D4 E1 03 30 83 E2 03 30 C3 E3 07 70 63 E0 03 00 57 E3 03 40 84 E0 04 00 00 9A B0 30 D4 E1 03 00 53 E3 01 00 00 9A 07 00 53 E1 E3 FF FF 9A 50 A0 1B E5 58 60 1B E5 04 30 95 E5 00 00 53 E3 68 01 00 0A 0C 30 95 E5 00 00 53 E3 96 FF FF 0A B0 20 D3 E1 00 00 52 E3 93 FF FF 0A 11 00 52 E3 91 FF FF 0A 40 30 85 E2 02 00 52 E3 10 30 85 E5 59 01 00 0A 0A 00 52 E3 55 01 00 1A 48 30 85 E2 80 10 A0 E3 B0 24 C5 E1 11 20 D8 E5 02 00 51 E1 02 10 A0 21 A1 21 B0 E1 03 20 A0 01 04 00 00 0A 02 20 83 E0 00 00 E0 E3 01 00 C3 E4 02 00 53 E1 FB FF FF 1A 07 30 01 E2 08 30 63 E2 FF 10 A0 E3 11 33 A0 E1 00 30 C2 E5 77 FF FF EA 03 30 43 E2 11 00 53 E3 58 01 00 8A 40 30 1B E5 0A 10 A0 E1 04 30 85 E5 0C 20 A0 E1 03 00 A0 E1 ?? ?? ?? ?? 00 90 C0 E5 C1 FF FF EA 0C 30 95 E5 00 00 53 E3 12 00 00 0A 1C 60 85 E2 0F 00 B6 E8 64 E0 85 E2 0F 00 AE E8 0F 00 B6 E8 0F 00 AE E8 00 20 96 E5 64 30 85 E2 00 20 8E E5 1C 90 85 E5 20 90 85 E5 24 90 85 E5 28 90 85 E5 2C 90 85 E5 30 90 85 E5 34 90 85 E5 38 90 85 E5 3C 90 85 E5 14 30 85 E5 1C 30 85 E2 0C 30 85 E5 10 30 D8 E5 BC 31 C5 E1 10 30 D8 E5 02 00 53 E3 FD 00 00 0A 0A 00 53 E3 F4 00 00 1A 10 00 5C E3 A0 FF FF 1A 0C 20 A0 E1 0A 10 A0 E1 24 00 85 E2 ?? ?? ?? ?? 04 20 94 E5 BC 34 9F E5 BC 04 9F E5 03 30 02 E0 00 00 53 E1 06 00 00 0A 04 30 D4 E5 FF 00 53 E3 93 FF FF 1A 05 30 D4 E5 0F 30 03 E2 02 00 53 E3 8F FF FF 1A 14 30 98 E5 34 30 85 E5 8C FF FF EA 0C 30 95 E5 00 00 53 E3 64 60 85 12 1C 60 85 02 14 60 85 15 0C 60 85 05 10 30 D8 E5 B0 30 C6 E1 10 30 D8 E5 02 00 53 E3 E8 00 00 0A 0A 00 53 E3 DF 00 00 1A 10 00 5C E3 7D FF FF 1A 0C 20 A0 E1 0A 10 A0 E1 08 00 86 E2 ?? ?? ?? ?? 04 20 94 E5 30 34 9F E5 03 30 02 E0 2C 24 9F E5 02 00 53 E1 06 00 00 0A 04 30 D4 E5 FF 00 53 E3 70 FF FF 1A 05 30 D4 E5 0F 30 03 E2 02 00 53 E3 6C FF FF 1A 14 30 98 E5 18 30 86 E5 69 FF FF EA 06 70 A0 E1 00 70 97 E5 00 00 57 E3 03 FF FF 1A 48 20 1B E5 70 00 1B E5 68 10 1B E5 00 30 82 E0 03 00 51 E1 EF 00 00 8A 5C 20 1B E5 00 00 52 E3 10 00 00 0A 44 10 1B E5 00 00 51 E3 0D 00 00 0A 74 20 1B E5 48 00 1B E5 01 C0 82 E0 64 30 1B E5 8C C1 61 E0 0C C1 80 E0 02 00 83 E0 48 20 1B E5 04 10 93 E4 01 00 71 E3 9C C0 02 05 00 00 53 E1 9C 20 82 E2 F9 FF FF 1A 48 30 1B E5 54 00 1B E5 00 40 A0 E3 00 30 80 E5 9A FE FF EA 14 30 95 E5 00 00 53 E3 4C 10 1B 15 64 30 85 E2 64 90 85 15 00 90 81 15 6C 90 85 15 70 90 85 15 74 90 85 15 78 90 85 15 7C 90 85 15 80 90 85 15 84 90 85 15 14 30 85 E5 10 30 D8 E5 B4 36 C5 E1 10 30 D8 E5 02 00 53 E3 2E FF FF 0A 0A 00 53 E3 9F 00 00 1A 10 00 5C E3 2F FF FF 1A 0C 20 A0 E1 0A 10 A0 E1 6C 00 85 E2 ?? ?? ?? ?? 04 20 94 E5 F8 32 9F E5 03 30 02 E0 F4 22 9F E5 02 00 53 E1 06 00 00 0A 04 30 D4 E5 FF 00 53 E3 22 FF FF 1A 05 30 D4 E5 0F 30 03 E2 02 00 53 E3 1E FF FF 1A 14 30 98 E5 7C 30 85 E5 1B FF FF EA 14 00 98 E5 48 10 1B E5 01 00 40 E2 64 20 1B E5 44 30 1B E5 D7 FC FF EB 01 00 70 E3 20 50 45 E2 20 40 88 E2 9C 00 00 0A 00 31 80 E0 83 31 60 E0 48 00 1B E5 18 20 98 E5 03 31 80 E0 03 00 55 E3 08 20 83 E5 B4 FE FF 9A B0 22 D8 E1 03 00 52 E3 B1 FE FF 9A 02 00 55 E1 AF FE FF 3A 88 10 83 E2 70 00 83 E2 40 10 0B E5 58 00 0B E5 64 10 83 E2 28 00 83 E2 60 10 0B E5 6C 00 0B E5 68 70 1B E5 4C A0 0B E5 50 60 0B E5 03 60 A0 E1 B2 00 D4 E1 01 00 40 E2 04 10 84 E2 04 A0 42 E2 06 00 50 E3 00 F1 9F 97 14 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 24 00 5A E3 0B 00 00 8A 11 20 A0 E3 BC 21 C6 E1 6C 00 1B E5 0A 20 A0 E1 ?? ?? ?? ?? 27 A0 C6 E5 14 20 98 E5 20 20 86 E5 B2 11 D8 E1 1C 20 86 E2 B4 12 C6 E1 0C 20 86 E5 B0 20 D4 E1 03 20 82 E2 03 20 C2 E3 05 50 62 E0 03 00 55 E3 02 40 84 E0 04 00 00 9A B0 20 D4 E1 03 00 52 E3 01 00 00 9A 05 00 52 E1 D7 FF FF 9A 50 60 4B E2 68 70 0B E5 40 04 96 E8 77 FE FF EA 03 20 42 E2 11 00 52 E3 EC FF FF 8A 40 30 1B E5 0A 20 A0 E1 04 30 86 E5 03 00 A0 E1 ?? ?? ?? ?? 00 90 C0 E5 E5 FF FF EA 24 00 5A E3 E3 FF FF 8A 11 30 A0 E3 B4 36 C6 E1 0A 20 A0 E1 58 00 1B E5 ?? ?? ?? ?? 6F A0 C6 E5 14 20 98 E5 68 20 86 E5 60 30 1B E5 B2 21 D8 E1 14 30 86 E5 BC 26 C6 E1 D6 FF FF EA 18 70 86 E5 07 00 A0 E1 0A 20 A0 E1 ?? ?? ?? ?? 0A 70 87 E0 D0 FF FF EA 24 00 5C E3 AB FE FF 8A 0A 10 A0 E1 0C 20 A0 E1 1E 00 85 E2 ?? ?? ?? ?? A6 FE FF EA 04 00 5C E3 A4 FE FF 1A 0A 10 A0 E1 0C 20 A0 E1 20 00 85 E2 ?? ?? ?? ?? 9F FE FF EA 24 00 5C E3 9D FE FF 8A 02 00 86 E2 0A 10 A0 E1 0C 20 A0 E1 ?? ?? ?? ?? 98 FE FF EA 04 00 5C E3 96 FE FF 1A 04 00 86 E2 0A 10 A0 E1 0C 20 A0 E1 ?? ?? ?? ?? 91 FE FF EA 24 00 5C E3 8F FE FF 8A 0A 10 A0 E1 0C 20 A0 E1 60 00 1B E5 ?? ?? ?? ?? 8A FE FF EA B0 24 C5 E1 33 FE FF EA 44 30 85 E2 20 10 A0 E3 A6 FE FF EA 14 00 98 E5 48 10 1B E5 01 00 40 E2 64 20 1B E5 44 30 1B E5 41 FC FF EB 01 00 70 E3 08 00 00 0A 00 31 80 E0 83 31 60 E0 48 00 1B E5 03 31 80 E0 04 30 93 E5 04 30 85 E5 87 FE FF EA 00 00 E0 E3 CE FD FF EA 48 00 1B E5 ?? ?? ?? ?? 0A 40 E0 E3 C4 FD FF EA ?? ?? ?? ?? 14 00 9F E5 14 10 9F E5 14 20 9F E5 14 30 9F E5 ?? ?? ?? ?? FF C0 00 00 FE 80 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 1A 03 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_335_2_0 {
	meta:
		name = "__netlink_free_handle"
		size = 92
		refs = "0010 __aeabi_read_tp 0030 free 0054 __libc_errno"
	strings:
		$1 = { 38 40 2D E9 48 20 9F E5 0C 30 90 E5 02 20 9F E7 ?? ?? ?? ?? 00 00 53 E3 02 50 90 E7 01 00 00 1A 05 00 00 EA 04 30 A0 E1 00 40 93 E5 03 00 A0 E1 ?? ?? ?? ?? 00 00 54 E3 F9 FF FF 1A 14 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 50 80 E7 38 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_335_3_0 {
	meta:
		name = "__netlink_request"
		size = 844
		refs = "0014 __getpagesize 00ac __aeabi_read_tp 00d8 __sendto 0140 __recvmsg 0244 free 0284 malloc 02a0 memcpy 02cc time 030c __libc_alloca_cutoff 033c __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 4C D0 4D E2 00 50 A0 E1 01 60 A0 E1 ?? ?? ?? ?? 01 0A 50 E3 00 40 A0 E1 B9 00 00 8A 0E 30 84 E2 07 30 C3 E3 03 D0 4D E0 08 80 8D E2 58 80 0B E5 00 80 A0 E3 5C 80 0B E5 08 00 95 E5 58 80 1B E5 00 00 50 E3 54 80 0B E5 50 40 0B E5 9C 00 00 0A D8 C2 9F E5 00 30 A0 E3 14 10 A0 E3 10 20 A0 E3 24 90 4B E2 BC 63 4B E1 4C 30 0B E5 48 30 0B E5 44 30 0B E5 38 00 0B E5 34 30 0B E5 30 30 4B E5 2F 30 4B E5 2E 30 4B E5 2D 30 4B E5 BA C3 4B E1 40 10 0B E5 B8 22 69 E1 94 62 9F E5 0C 40 A0 E3 04 00 00 EA ?? ?? ?? ?? 06 30 9F E7 03 30 90 E7 04 00 53 E3 58 00 00 1A 00 00 95 E5 40 10 4B E2 00 90 8D E5 04 40 8D E5 14 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 01 00 70 E3 F1 FF FF 0A 00 00 50 E3 4D 00 00 BA 4C 62 9F E5 00 70 A0 E3 0C 20 A0 E3 54 30 4B E2 01 40 A0 E3 40 90 0B E5 3C 20 0B E5 38 30 0B E5 34 40 0B E5 30 70 0B E5 2C 70 0B E5 28 70 0B E5 04 00 00 EA ?? ?? ?? ?? 06 30 9F E7 03 30 90 E7 04 00 53 E3 3B 00 00 1A 00 00 95 E5 40 10 4B E2 00 20 A0 E3 ?? ?? ?? ?? 01 00 70 E3 F4 FF FF 0A 00 00 50 E3 00 40 A0 E1 32 00 00 BA 48 30 1B E5 00 00 53 E3 E3 FF FF 1A 28 30 1B E5 20 30 13 E2 2C 00 00 1A 0F 00 50 E3 DE FF FF 9A 58 80 1B E5 00 10 98 E5 0F 00 51 E3 DA FF FF 9A 01 00 50 E1 D8 FF FF 3A 03 A0 A0 E1 04 00 95 E5 04 C0 A0 E1 08 30 A0 E1 60 40 0B E5 07 00 00 EA 0F 00 5C E3 02 30 83 E0 25 00 00 9A 00 10 93 E5 0F 00 51 E3 22 00 00 9A 0C 00 51 E1 20 00 00 8A 0C 40 93 E5 03 20 81 E2 03 20 C2 E3 04 00 50 E1 0C C0 62 E0 F1 FF FF 1A 08 40 93 E5 08 80 95 E5 08 00 54 E1 ED FF FF 1A B4 40 D3 E1 03 00 54 E3 01 A0 8A E2 38 00 00 0A 02 00 54 E3 E7 FF FF 1A 23 00 51 E3 37 00 00 8A 2C 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 05 20 A0 E3 03 20 80 E7 5C 80 1B E5 00 00 58 E3 03 00 00 1A 00 00 E0 E3 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 58 00 1B E5 ?? ?? ?? ?? F8 FF FF EA 60 40 1B E5 00 80 A0 E3 00 00 5A E3 08 00 00 1A 00 00 58 E3 A3 FF FF 0A 5C 40 1B E5 00 00 54 E3 19 00 00 1A 00 00 A0 E3 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 10 00 84 E2 ?? ?? ?? ?? 00 A0 50 E2 E4 FF FF 0A 0A 00 A0 E1 04 20 A0 E1 10 70 80 E4 58 10 1B E5 ?? ?? ?? ?? 0C 20 95 E5 08 30 95 E5 00 00 52 E3 0C 30 8A E5 10 30 95 15 11 00 8A E9 00 A0 83 15 0C A0 85 05 10 A0 85 E5 E3 FF FF EA ?? ?? ?? ?? 08 00 85 E5 5F FF FF EA 58 00 1B E5 ?? ?? ?? ?? E2 FF FF EA 60 40 1B E5 01 80 A0 E3 D8 FF FF EA 10 20 93 E5 4C 30 9F E5 00 20 62 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 C5 FF FF EA ?? ?? ?? ?? 00 00 50 E3 42 FF FF 1A 04 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 01 80 A0 13 58 00 0B E5 5C 80 0B 15 42 FF FF 1A BD FF FF EA 01 03 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_335_4_0 {
	meta:
		name = "__netlink_close"
		size = 24
	strings:
		$1 = { 04 70 2D E5 00 00 90 E5 06 70 A0 E3 00 00 00 EF 04 70 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_335_5_0 {
	meta:
		name = "__netlink_open"
		size = 172
		refs = "0018 __socket 0048 __bind 006c __getsockname"
	strings:
		$1 = { B0 40 2D E9 03 10 A0 E3 00 50 A0 E1 10 D0 4D E2 10 00 A0 E3 00 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 00 00 85 E5 1E 00 00 BA 00 40 A0 E3 10 30 A0 E3 04 10 8D E2 0C 20 A0 E3 04 40 8D E5 08 40 8D E5 0C 40 8D E5 B4 30 CD E1 ?? ?? ?? ?? 04 00 50 E1 0E 00 00 BA 0C 30 A0 E3 10 20 8D E2 10 30 22 E5 04 10 8D E2 0D 20 A0 E1 00 00 95 E5 ?? ?? ?? ?? 00 00 50 E3 05 00 00 BA 08 30 9D E5 04 30 85 E5 04 00 A0 E1 10 D0 8D E2 B0 40 BD E8 ?? ?? ?? ?? 00 00 95 E5 06 70 A0 E3 00 00 00 EF 00 00 E0 E3 F7 FF FF EA 00 00 E0 E3 F5 FF FF EA }
	condition:
		$1
}

rule file_335_6_0 {
	meta:
		name = "getifaddrs"
		size = 32
	strings:
		$1 = { 10 40 2D E9 00 40 A0 E1 04 00 A0 E1 64 FD FF EB 0B 00 70 E3 FB FF FF 0A 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_336_0_0 {
	meta:
		name = "putwchar"
		size = 528
		refs = "0020 __aeabi_read_tp 015c __woverflow 016c __lll_lock_wait_private 0208 _Unwind_Resume 020c _IO_stdout"
	strings:
		$1 = { F8 43 2D E9 00 82 9F E5 00 50 98 E5 00 40 95 E5 02 49 14 E2 00 60 A0 E1 1A 00 00 1A 48 70 95 E5 ?? ?? ?? ?? 08 30 97 E5 13 9D 40 E2 09 00 53 E1 3D 00 00 0A 01 10 A0 E3 07 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 3F 00 00 1A 48 30 95 E5 00 00 98 E5 08 90 83 E5 48 70 95 E5 04 30 97 E5 01 30 83 E2 04 30 87 E5 00 00 00 EA 05 00 A0 E1 5C 30 90 E5 00 00 53 E3 2F 00 00 0A 10 20 93 E5 14 10 93 E5 01 00 52 E1 04 10 82 32 10 10 83 35 00 60 82 35 28 00 00 2A 00 30 95 E5 02 09 13 E3 17 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 11 00 00 1A 08 30 85 E5 00 70 95 E5 00 10 A0 E3 07 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 57 E1 F0 FF FF 1A 01 00 57 E3 04 00 00 CA 06 00 A0 E1 F8 43 BD E8 ?? ?? ?? ?? 05 00 A0 E1 D0 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF F1 FF FF EA 06 10 A0 E1 ?? ?? ?? ?? 00 60 A0 E1 D2 FF FF EA 07 00 A0 E1 ?? ?? ?? ?? BC FF FF EA 00 30 95 E5 02 09 13 E3 00 80 A0 E1 1F 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 19 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 07 00 00 DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 08 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_337_0_0 {
	meta:
		name = "futimesat"
		size = 400
		refs = "0074 strlen 00a4 __snprintf 00d4 __atfct_seterrno 00ec __futimes 0120 __aeabi_read_tp 0170 __have_atfcts 0184 __libc_errno"
	strings:
		$1 = { F0 4B 2D E9 64 61 9F E5 1C B0 8D E2 08 D0 4D E2 00 30 96 E5 00 00 53 E3 00 80 A0 E1 01 40 A0 E1 02 90 A0 E1 0A 00 00 BA 00 00 51 E3 2D 00 00 0A 3C 71 9F E5 00 00 00 EF 01 0A 70 E3 00 50 A0 E1 35 00 00 8A 05 00 A0 E1 1C D0 4B E2 F0 4B BD E8 ?? ?? ?? ?? 00 00 51 E3 26 00 00 0A 64 00 78 E3 1E 00 00 0A 00 30 D4 E5 2F 00 53 E3 1B 00 00 0A 04 00 A0 E1 ?? ?? ?? ?? 00 10 50 E2 34 00 00 0A 2E 30 81 E2 07 30 C3 E3 03 D0 4D E0 08 50 8D E2 00 40 8D E5 20 10 81 E2 05 00 A0 E1 D4 20 9F E5 08 30 A0 E1 ?? ?? ?? ?? 05 40 A0 E1 04 00 A0 E1 09 10 A0 E1 C0 70 9F E5 00 00 00 EF 01 0A 70 E3 00 50 A0 91 DE FF FF 9A 05 20 A0 E1 00 00 60 E2 08 10 A0 E1 ?? ?? ?? ?? 00 50 E0 E3 D8 FF FF EA 00 50 A0 E3 F0 FF FF EA 02 10 A0 E1 ?? ?? ?? ?? 00 50 A0 E1 D2 FF FF EA 28 D0 4D E2 08 40 8D E2 04 00 A0 E1 1D 10 A0 E3 70 20 9F E5 08 30 A0 E1 ?? ?? ?? ?? 04 50 A0 E1 E3 FF FF EA 60 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 00 50 65 E2 03 50 80 E7 50 30 9F E5 03 30 9F E7 03 30 90 E7 26 00 53 E3 00 30 E0 03 00 30 86 05 C3 FF FF 0A 00 50 E0 E3 BB FF FF EA 30 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 02 20 A0 E3 03 20 80 E7 00 50 E0 E3 B4 FF FF EA ?? ?? ?? ?? 46 01 00 00 ?? ?? ?? ?? 0D 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_340_0_0 {
	meta:
		name = "__lxstat"
		size = 172
		refs = "0060 __aeabi_read_tp 0078 __xstat32_conv 00a4 __libc_errno"
	strings:
		$1 = { 80 40 2D E9 01 00 50 E3 00 C0 A0 E1 68 D0 4D E2 01 00 A0 E1 09 00 00 0A 0D 10 A0 E1 C4 70 A0 E3 00 00 00 EF 01 0A 70 E3 16 00 00 8A 00 00 50 E3 0E 00 00 0A 68 D0 8D E2 80 40 BD E8 ?? ?? ?? ?? 02 10 A0 E1 6B 70 A0 E3 00 00 00 EF 01 0A 70 E3 F7 FF FF 9A 48 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 F0 FF FF EA 0C 00 A0 E1 0D 10 A0 E1 ?? ?? ?? ?? 68 D0 8D E2 80 40 BD E8 ?? ?? ?? ?? 18 20 9F E5 00 30 60 E2 02 20 9F E7 ?? ?? ?? ?? 02 30 80 E7 00 00 E0 E3 E3 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_341_0_0 {
	meta:
		name = "do_sigpause"
		size = 116
		refs = "0030 __sigsuspend 004c __sigprocmask 0060 sigdelset"
	strings:
		$1 = { 30 40 2D E9 00 00 51 E3 84 D0 4D E2 00 50 A0 E1 00 00 8D 05 04 30 8D 02 08 00 00 1A 04 10 83 E4 80 20 8D E2 02 00 53 E1 FB FF FF 1A 0D 00 A0 E1 ?? ?? ?? ?? 84 D0 8D E2 30 40 BD E8 ?? ?? ?? ?? 00 00 A0 E3 0D 20 A0 E1 00 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 00 00 BA 05 10 A0 E1 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 EF FF FF AA 00 00 E0 E3 EF FF FF EA }
	condition:
		$1
}

rule file_341_1_0 {
	meta:
		name = "__sigpause"
		size = 80
		refs = "0020 __libc_enable_asynccancel 003c __libc_disable_asynccancel 004c __libc_multiple_threads"
	strings:
		$1 = { 44 30 9F E5 00 30 93 E5 00 00 53 E3 70 40 2D E9 00 50 A0 E1 01 40 A0 E1 70 40 BD 08 DA FF FF 0A ?? ?? ?? ?? 04 10 A0 E1 00 60 A0 E1 05 00 A0 E1 D5 FF FF EB 00 40 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 70 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_342_0_0 {
	meta:
		name = "_nl_explode_name"
		size = 596
		refs = "01cc _nl_normalize_codeset 01ec strcmp 0208 __rawmemchr 0234 free"
	strings:
		$1 = { F8 4F 2D E9 00 C0 A0 E3 00 C0 82 E5 28 80 9D E5 00 C0 83 E5 03 A0 A0 E1 2C 30 9D E5 00 C0 88 E5 00 C0 83 E5 00 00 81 E5 00 30 D0 E5 BF 00 13 E3 02 90 A0 E1 00 20 A0 03 01 20 A0 13 5F 00 53 E3 00 20 A0 03 01 20 02 12 0C 00 52 E1 6C 00 00 0A 2E 00 53 E3 6A 00 00 0A 01 C0 80 E2 03 00 00 EA 40 00 51 E3 24 00 00 0A 2E 00 51 E3 41 00 00 0A 00 10 DC E5 5F 00 51 E3 00 00 51 13 0C 40 A0 E1 00 50 A0 03 01 50 A0 13 01 C0 8C E2 F3 FF FF 1A 04 00 50 E1 04 30 A0 E1 59 00 00 0A 40 00 51 E3 18 00 00 0A 5F 00 51 E3 1E 00 00 0A 2E 00 51 E3 33 00 00 0A 40 00 51 E3 12 00 00 0A 00 30 9A E5 00 00 53 E3 02 00 00 0A 00 30 D3 E5 00 00 53 E3 04 50 C5 03 00 30 98 E5 00 00 53 E3 03 00 00 0A 00 30 D3 E5 00 00 53 E3 02 00 C5 03 00 00 00 0A 05 00 A0 E1 F8 4F BD E8 ?? ?? ?? ?? 04 00 50 E1 3F 00 00 0A 00 50 A0 E3 04 30 A0 E1 00 20 A0 E3 01 20 C3 E4 00 30 89 E5 01 30 D4 E5 02 00 53 E1 08 50 85 13 E4 FF FF EA 00 50 C4 E5 00 C0 8A E5 01 10 D3 E5 00 00 51 E3 2E 00 51 13 0C 40 A0 E1 0A 00 00 0A 40 00 51 E3 33 00 00 0A 02 00 83 E2 01 00 00 EA 40 00 51 E3 2F 00 00 0A 00 40 A0 E1 01 10 D0 E4 2E 00 51 E3 00 00 51 13 F8 FF FF 1A 04 50 A0 E3 CC FF FF EA 04 00 50 E1 20 00 00 0A 00 50 A0 E3 04 00 A0 E1 00 30 A0 E3 01 30 C0 E4 00 00 88 E5 01 10 D4 E5 BF 00 11 E3 20 00 00 0A 00 60 A0 E1 00 00 00 EA 04 60 A0 E1 01 10 D6 E5 BF 00 11 E3 01 40 86 E2 FA FF FF 1A 04 00 50 E1 02 B0 85 E3 1E 00 00 0A 04 10 60 E0 ?? ?? ?? ?? 2C C0 9D E5 00 00 50 E3 00 70 A0 E1 00 00 8C E5 19 00 00 0A 00 00 98 E5 07 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0D 00 00 0A 03 50 85 E3 01 10 D6 E5 AB FF FF EA 00 10 A0 E3 ?? ?? ?? ?? 00 50 A0 E3 00 40 A0 E1 00 10 D0 E5 A5 FF FF EA 04 50 A0 E3 B8 FF FF EA 02 50 85 E3 00 40 A0 E1 A0 FF FF EA 07 00 A0 E1 ?? ?? ?? ?? 0B 50 A0 E1 01 10 D6 E5 9B FF FF EA 0B 50 A0 E1 99 FF FF EA 00 00 E0 E3 A7 FF FF EA }
	condition:
		$1
}

rule file_343_0_0 {
	meta:
		name = "fseeko"
		size = 504
		refs = "0024 __aeabi_read_tp 009c _IO_seekoff_unlocked 0158 __lll_lock_wait_private 01f4 _Unwind_Resume"
		altNames = "fseek"
	strings:
		$1 = { F0 43 2D E9 00 40 90 E5 02 49 14 E2 0C D0 4D E2 00 50 A0 E1 01 80 A0 E1 02 90 A0 E1 18 00 00 1A 48 60 90 E5 ?? ?? ?? ?? 08 30 96 E5 13 7D 40 E2 07 00 53 E1 0F 00 00 0A 01 10 A0 E3 06 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 39 00 00 1A 48 30 95 E5 08 70 83 E5 03 60 A0 E1 04 30 96 E5 01 30 83 E2 04 30 86 E5 03 30 A0 E3 04 30 8D E5 00 90 8D E5 05 00 A0 E1 08 20 A0 E1 C8 3F A0 E1 ?? ?? ?? ?? 00 30 95 E5 01 10 00 E0 01 00 71 E3 00 60 A0 13 01 60 A0 03 02 09 13 E3 00 60 66 E2 17 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 11 00 00 1A 08 30 85 E5 00 70 95 E5 00 10 A0 E3 07 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 57 E1 F0 FF FF 1A 01 00 57 E3 03 00 00 CA 06 00 A0 E1 0C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF F2 FF FF EA 06 00 A0 E1 ?? ?? ?? ?? C2 FF FF EA 00 30 95 E5 02 09 13 E3 00 80 A0 E1 1F 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 19 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 07 00 00 DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 08 00 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_344_0_0 {
	meta:
		name = "_dl_discover_osversion"
		size = 284
		refs = "000c __uname 00c0 __open 00d4 __read 00e0 __close"
	strings:
		$1 = { 30 40 2D E9 73 DF 4D E2 40 00 8D E2 ?? ?? ?? ?? 00 00 50 E3 C2 10 8D 02 26 00 00 1A 00 50 A0 E3 05 00 A0 E1 00 20 D1 E5 30 20 42 E2 FF 30 02 E2 09 00 53 E3 19 00 00 8A 01 30 D1 E5 30 C0 43 E2 09 00 5C E3 01 40 81 E2 08 00 00 8A 02 10 81 E2 02 21 82 E0 82 20 83 E0 01 40 A0 E1 01 30 D1 E4 30 C0 43 E2 09 00 5C E3 30 20 42 E2 F7 FF FF 9A 2E 00 53 E3 01 50 85 E2 00 04 82 E1 01 10 84 E2 04 00 00 1A 03 00 55 E3 E5 FF FF 1A 73 DF 8D E2 30 40 BD E8 ?? ?? ?? ?? 03 00 55 E3 FA FF FF 0A 03 50 65 E2 85 51 A0 E1 10 05 A0 E1 73 DF 8D E2 30 40 BD E8 ?? ?? ?? ?? 58 00 9F E5 00 10 A0 E3 ?? ?? ?? ?? 00 50 50 E2 10 00 00 BA 0D 10 A0 E1 40 20 A0 E3 ?? ?? ?? ?? 00 40 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 00 00 54 E3 08 00 00 DA 72 2F 8D E2 3F 00 54 E3 04 30 A0 B1 3F 30 A0 A3 03 30 82 E0 00 20 A0 E3 0D 10 A0 E1 C8 21 43 E5 C2 FF FF EA 00 00 E0 E3 DC FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_345_0_0 {
	meta:
		name = "__gconv_open"
		size = 2060
		refs = "0020 strchr 00ac __aeabi_read_tp 00c4 strlen 00e4 mempcpy 00f0 memcpy 0124 __gconv_find_transform 0168 __gconv_translit_find 0190 malloc 01b4 memset 0220 __strcasecmp_l 03ac __gconv_close_transform 0424 free 07e0 _nl_current_LC_CTYPE 07e8 _nl_C_locobj 07f0 __libc_errno 07fc __gconv_transliterate"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 2C D0 4D E2 01 70 A0 E1 2F 10 A0 E3 44 20 0B E5 38 30 0B E5 00 80 A0 E1 ?? ?? ?? ?? 00 00 50 E3 B1 01 00 0A 01 00 80 E2 2F 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 AC 01 00 0A 01 60 D0 E5 00 00 56 E3 00 01 00 1A 3C 60 0B E5 07 00 A0 E1 2F 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 07 00 00 0A 01 00 80 E2 2F 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 02 00 00 0A 01 30 D0 E5 00 00 53 E3 5E 01 00 1A 00 30 D8 E5 2F 00 53 E3 18 00 00 1A 01 30 D8 E5 2F 00 53 E3 15 00 00 1A 02 30 D8 E5 00 00 53 E3 12 00 00 1A 30 37 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 00 30 93 E5 5C 40 93 E5 04 00 A0 E1 ?? ?? ?? ?? 11 30 80 E2 07 30 C3 E3 03 D0 4D E0 08 80 8D E2 00 20 A0 E1 04 10 A0 E1 08 00 A0 E1 ?? ?? ?? ?? F4 16 9F E5 03 20 A0 E3 ?? ?? ?? ?? 00 30 D7 E5 2F 00 53 E3 02 00 00 1A 01 30 D7 E5 2F 00 53 E3 8A 00 00 0A 38 30 1B E5 08 00 A0 E1 00 30 8D E5 07 10 A0 E1 2C 30 4B E2 30 20 4B E2 ?? ?? ?? ?? 00 00 50 E3 00 30 A0 13 40 00 0B E5 38 30 0B 15 77 00 00 1A 00 00 56 E3 7F 01 00 0A 06 80 A0 E1 00 40 A0 E1 01 00 00 EA 06 40 A0 E1 03 60 A0 E1 00 30 96 E5 00 00 53 E3 06 00 A0 E1 02 00 00 0A ?? ?? ?? ?? 00 00 50 E3 91 01 00 1A 04 30 96 E5 00 00 53 E3 F3 FF FF 1A 2C 40 1B E5 84 51 84 E0 05 51 A0 E1 08 00 85 E2 ?? ?? ?? ?? 00 00 50 E3 38 00 0B E5 7C 00 00 0A 30 30 1B E5 05 20 A0 E1 04 30 80 E5 00 10 A0 E3 08 40 80 E4 ?? ?? ?? ?? 2C 30 1B E5 00 00 53 E3 55 00 00 0A 38 30 1B E5 00 40 A0 E3 04 70 A0 E1 04 60 A0 E1 20 50 83 E2 00 00 58 E3 04 50 05 E5 36 00 00 0A 08 A0 A0 E1 0C 30 9A E5 00 00 53 E3 2F 00 00 0A 00 90 A0 E3 02 00 00 EA 0C 30 9A E5 09 00 53 E1 2A 00 00 9A 30 20 1B E5 08 30 9A E5 04 20 82 E0 0C 00 92 E5 09 11 93 E7 C4 25 9F E5 ?? ?? ?? ?? 00 00 50 E3 01 90 89 E2 F2 FF FF 1A 18 30 9A E5 00 00 53 E3 28 00 0B E5 07 00 00 0A 30 20 1B E5 04 20 82 E0 10 10 92 E5 28 00 4B E2 0F E0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 14 00 00 1A 14 00 A0 E3 ?? ?? ?? ?? 00 00 50 E3 58 00 00 0A 10 30 9A E5 1C 20 9A E5 14 10 9A E5 00 30 80 E5 28 30 1B E5 4E 00 80 E9 08 20 95 E5 00 00 52 E3 08 20 85 02 01 00 00 1A 04 00 00 EA 03 20 A0 E1 10 30 92 E5 00 00 53 E3 FB FF FF 1A 10 20 82 E2 00 00 82 E5 04 A0 9A E5 00 00 5A E3 C9 FF FF 1A 2C 90 1B E5 01 30 49 E2 07 00 53 E1 33 01 00 9A 3C 10 1B E5 30 30 1B E5 10 10 05 E5 04 30 83 E0 30 30 93 E5 03 34 63 E0 83 A2 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 18 00 05 E5 34 00 00 0A 01 70 87 E2 0A 30 80 E0 07 00 59 E1 14 30 05 E5 3C 40 84 E2 24 50 85 E2 AE FF FF 8A 38 30 1B E5 44 10 1B E5 40 00 1B E5 00 30 81 E5 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 02 30 D7 E5 00 00 53 E3 71 FF FF 1A A0 34 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 00 30 93 E5 5C 40 93 E5 04 00 A0 E1 ?? ?? ?? ?? 11 30 80 E2 07 30 C3 E3 03 D0 4D E0 08 70 8D E2 00 20 A0 E1 04 10 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 58 14 9F E5 03 20 A0 E3 ?? ?? ?? ?? 5D FF FF EA 54 34 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 90 E7 04 10 A0 E1 30 00 1B E5 ?? ?? ?? ?? 3C 34 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 80 E7 03 30 A0 E3 40 30 0B E5 00 30 A0 E3 38 30 0B E5 D1 FF FF EA 1C 34 9F E5 ?? ?? ?? ?? 03 30 9F E7 00 00 57 E3 03 80 90 E7 14 00 00 0A 38 30 1B E5 87 61 87 E0 06 61 83 E0 08 60 86 E2 04 40 16 E5 00 00 54 E3 01 00 00 1A 08 00 00 EA 05 40 A0 E1 08 30 94 E5 00 00 53 E3 10 50 94 E5 DB 00 00 1A 04 00 A0 E1 ?? ?? ?? ?? 00 00 55 E3 F6 FF FF 1A 24 00 36 E5 ?? ?? ?? ?? 01 70 57 E2 EE FF FF 1A 38 00 1B E5 ?? ?? ?? ?? 2C 10 1B E5 D5 FF FF EA 01 40 80 E2 04 20 68 E0 0F 30 82 E2 07 30 C3 E3 03 D0 4D E0 0F 00 8D E2 00 30 A0 E3 A0 01 A0 E1 80 31 C2 E7 08 10 A0 E1 80 01 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 0F 30 80 E2 07 30 C3 E3 03 D0 4D E0 01 20 80 E2 04 10 A0 E1 08 00 8D E2 ?? ?? ?? ?? 00 60 D0 E5 2C 00 56 E3 00 50 A0 E1 04 00 00 1A 01 30 80 E2 03 50 A0 E1 01 60 D3 E4 2C 00 56 E3 FB FF FF 0A 00 00 56 E3 01 20 85 12 02 00 00 1A DB FE FF EA 2C 00 53 E3 99 00 00 0A 00 30 D2 E5 00 00 53 E3 02 40 A0 E1 01 20 82 E2 F8 FF FF 1A 00 00 55 E3 05 60 A0 01 3C 60 0B 05 D1 FE FF 0A 00 60 A0 E3 E8 A2 9F E5 3C 60 0B E5 05 00 A0 E1 E0 12 9F E5 C4 22 9F E5 ?? ?? ?? ?? 00 00 50 E3 42 00 00 1A 00 00 56 E3 72 00 00 0A 10 30 96 E5 0A 00 53 E1 19 00 00 0A 06 30 A0 E1 03 00 00 EA 10 30 92 E5 0A 00 53 E1 14 00 00 0A 02 30 A0 E1 04 20 93 E5 00 00 52 E3 F8 FF FF 1A 28 D0 4D E2 08 00 8D E2 00 10 A0 E1 04 20 81 E4 08 10 81 E2 0C 20 8D E5 04 20 81 E4 04 20 81 E4 04 20 81 E4 04 20 81 E4 00 20 81 E5 6C 22 9F E5 01 C0 A0 E3 10 20 8D E5 18 A0 8D E5 14 C0 8D E5 04 00 83 E5 00 20 D4 E5 2C 00 52 E3 47 00 00 1A 01 30 84 E2 03 50 A0 E1 01 20 D3 E4 2C 00 52 E3 FB FF FF 0A 00 00 52 E3 9F FE FF 0A 01 20 85 E2 01 00 00 EA 2C 00 53 E3 3E 00 00 0A 00 30 D2 E5 00 00 53 E3 02 40 A0 E1 01 20 82 E2 F8 FF FF 1A 00 00 55 E3 C5 FF FF 1A 93 FE FF EA 01 20 80 E2 02 20 67 E0 0F 30 82 E2 07 30 C3 E3 03 D0 4D E0 0F 00 8D E2 A0 01 A0 E1 00 30 A0 E3 07 10 A0 E1 80 31 C2 E7 80 01 A0 E1 ?? ?? ?? ?? 00 70 A0 E1 92 FE FF EA C8 11 9F E5 05 00 A0 E1 A0 21 9F E5 ?? ?? ?? ?? 00 00 50 E3 02 10 A0 03 3C 10 0B 05 D3 FF FF 0A 00 00 56 E3 3E 00 00 0A 06 90 A0 E1 00 00 00 EA 03 90 A0 E1 00 30 99 E5 00 10 53 E2 05 00 A0 E1 68 21 9F E5 02 00 00 0A ?? ?? ?? ?? 00 00 50 E3 C6 FF FF 0A 04 30 99 E5 00 00 53 E3 F3 FF FF 1A 28 D0 4D E2 10 20 8D E2 0C 30 8D E5 04 30 82 E4 04 30 82 E4 04 30 82 E4 04 30 82 E4 04 30 82 E4 08 10 8D E2 00 30 82 E5 08 50 8D E5 04 10 89 E5 00 20 D4 E5 2C 00 52 E3 B7 FF FF 0A 04 50 A0 E1 BA FF FF EA 00 30 A0 E3 00 00 55 E3 00 30 C4 E5 02 40 A0 E1 88 FF FF 1A 56 FE FF EA 00 60 A0 E1 3C 00 0B E5 53 FE FF EA 28 D0 4D E2 08 60 8D E2 06 30 A0 E1 04 00 83 E4 08 30 83 E2 04 00 86 E5 04 00 83 E4 04 00 83 E4 04 00 83 E4 D8 10 9F E5 04 00 83 E4 01 20 A0 E3 00 00 83 E5 08 10 86 E5 10 A0 86 E5 0C 20 86 E5 98 FF FF EA 40 80 1B E5 8C FE FF EA 00 30 A0 E3 00 30 C4 E5 02 40 A0 E1 66 FF FF EA 28 D0 4D E2 08 60 8D E2 00 20 A0 E3 08 30 86 E2 04 20 86 E5 04 20 83 E4 04 20 83 E4 04 20 83 E4 04 20 83 E4 04 20 83 E4 00 20 83 E5 00 50 86 E5 85 FF FF EA 0C 00 94 E5 0F E0 A0 E1 ?? ?? ?? ?? 1F FF FF EA 38 20 1B E5 3C 10 1B E5 87 71 87 E0 07 31 82 E0 01 20 81 E3 10 20 83 E5 D7 FE FF EA 00 00 54 E3 04 30 96 15 04 80 96 05 04 30 84 15 04 60 A0 01 04 30 96 15 08 30 A0 01 04 60 A0 11 65 FE FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_347_0_0 {
	meta:
		name = "setup_aeabi_stdio"
		size = 84
		refs = "003c stdin 0040 stdout 0044 stderr 0048 __aeabi_stdin 004c __aeabi_stdout 0050 __aeabi_stderr"
	strings:
		$1 = { 34 10 9F E5 34 20 9F E5 34 30 9F E5 04 40 2D E5 00 00 92 E5 00 40 91 E5 00 20 93 E5 24 C0 9F E5 24 10 9F E5 24 30 9F E5 00 40 8C E5 00 00 81 E5 00 20 83 E5 04 40 9D E4 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_349_0_0 {
	meta:
		name = "atexit"
		size = 40
		refs = "0018 __cxa_atexit 0024 __dso_handle"
	strings:
		$1 = { 08 40 2D E9 18 30 9F E5 00 00 53 E3 00 20 93 15 03 20 A0 01 00 10 A0 E3 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_350_0_0 {
	meta:
		name = "utime"
		size = 64
		refs = "0030 __utimes"
	strings:
		$1 = { 04 E0 2D E5 00 00 51 E3 14 D0 4D E2 07 00 00 0A 00 C0 91 E5 04 20 91 E5 00 30 A0 E3 00 C0 8D E5 08 20 8D E5 04 30 8D E5 0C 30 8D E5 0D 10 A0 E1 ?? ?? ?? ?? 14 D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_351_0_0 {
	meta:
		name = "strchr"
		size = 292
	strings:
		$1 = { 03 00 10 E3 F0 00 2D E9 FF 10 01 E2 0E 00 00 0A 00 20 D0 E5 01 00 52 E1 34 00 00 0A 00 00 52 E3 34 00 00 0A 01 30 80 E2 04 00 00 EA 01 20 D3 E4 01 00 52 E1 2D 00 00 0A 00 00 52 E3 2D 00 00 0A 03 00 13 E3 03 00 A0 E1 F7 FF FF 1A 01 64 81 E1 06 68 86 E1 04 30 40 E2 11 00 00 EA 00 00 52 E3 24 00 00 0A 01 20 D3 E5 01 00 52 E1 24 00 00 0A 00 00 52 E3 1F 00 00 0A 02 20 D3 E5 01 00 52 E1 21 00 00 0A 00 00 52 E3 1A 00 00 0A 03 20 D3 E5 01 00 52 E1 1E 00 00 0A 00 00 52 E3 15 00 00 0A 0C 00 A0 E1 04 40 B3 E5 6C C0 9F E5 04 50 26 E0 0C 20 A0 E1 05 70 E0 E1 0C C0 85 E0 02 20 84 E0 04 50 E0 E1 02 40 25 E0 0C C0 27 E0 4C 20 9F E5 04 C0 8C E1 02 20 0C E0 00 00 52 E3 04 C0 80 E2 EE FF FF 0A 04 20 5C E5 01 00 52 E1 DA FF FF 1A F0 00 BD E8 ?? ?? ?? ?? 02 00 A0 E1 F0 00 BD E8 ?? ?? ?? ?? 01 00 80 E2 F8 FF FF EA 02 00 80 E2 F6 FF FF EA 03 00 80 E2 F4 FF FF EA FF FE FE 7E 00 01 01 81 }
	condition:
		$1
}

rule file_353_0_0 {
	meta:
		name = "mbrtoc16"
		size = 612
		refs = "006c __aeabi_read_tp 009c _dl_mcount_wrapper_check 01e8 __assert_fail 0210 __wcsmbs_load_conv 0240 _nl_current_LC_CTYPE 0248 __libc_errno 0258 _nl_C_LC_CTYPE 0260 __wcsmbs_gconv_fcts_c"
	strings:
		$1 = { F0 4F 2D E9 00 00 53 E3 2C 42 9F E5 03 40 A0 11 00 C0 94 E5 00 00 5C E3 4C D0 4D E2 00 60 A0 E1 01 50 A0 E1 54 00 00 BA 00 00 51 E3 00 30 A0 E3 01 10 A0 E3 18 80 8D E2 1C A0 8D E2 44 30 8D E5 38 40 8D E5 01 20 A0 01 30 30 8D E5 34 10 8D E5 2C 10 8D E5 24 80 8D E5 28 A0 8D E5 DC 11 9F E5 03 60 A0 01 D8 51 9F 05 01 10 9F E7 ?? ?? ?? ?? 01 30 90 E7 00 90 93 E5 14 70 99 E5 00 00 57 E3 5D 00 00 0A 02 B0 95 E0 20 50 8D E5 56 00 00 2A 00 30 97 E5 14 90 93 E5 09 00 A0 E1 ?? ?? ?? ?? 00 10 A0 E3 01 20 A0 E3 00 00 97 E5 0B 30 A0 E1 00 10 8D E5 08 10 8D E5 0C 20 8D E5 04 A0 8D E5 24 10 8D E2 20 20 8D E2 0F E0 A0 E1 ?? ?? ?? ?? 04 30 D0 E3 18 00 00 0A 06 20 40 E2 01 00 52 E3 15 00 00 9A 05 00 50 E3 3A 00 00 1A 18 30 9D E5 20 00 9D E5 01 08 53 E3 00 00 65 E0 28 00 00 2A 24 20 9D E5 00 00 56 E3 B0 30 C6 11 08 00 52 E1 06 00 00 0A 00 00 53 E3 04 00 00 1A 38 20 9D E5 00 20 92 E5 00 00 52 E3 03 00 A0 01 3B 00 00 1A 4C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 04 20 40 E2 00 00 50 E3 01 00 52 13 E7 FF FF 9A 07 00 50 E3 01 00 E0 03 F5 FF FF 0A E8 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 54 20 A0 E3 03 20 80 E7 00 00 E0 E3 4C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 04 20 94 E5 02 C1 CC E3 00 30 A0 E3 02 00 E0 E3 00 C0 84 E5 B0 20 C6 E1 04 30 84 E5 4C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 00 56 E3 23 25 A0 11 A1 2D 42 12 B0 20 C6 11 00 20 94 E5 03 3B A0 E1 23 3B A0 E1 37 3B 83 E2 02 21 82 E3 0C 00 84 E8 4C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 6C 00 9F E5 6C 10 9F E5 71 20 A0 E3 68 30 9F E5 ?? ?? ?? ?? 01 00 75 E3 00 B0 E0 13 A5 FF FF 1A D6 FF FF EA 54 30 9F E5 03 00 59 E1 0A 00 00 0A 09 00 A0 E1 14 20 8D E5 ?? ?? ?? ?? 14 70 99 E5 14 20 9D E5 98 FF FF EA 34 00 9F E5 24 10 9F E5 80 20 A0 E3 20 30 9F E5 ?? ?? ?? ?? 24 70 9F E5 91 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_354_0_0 {
	meta:
		name = "__posix_openpt"
		size = 320
		refs = "0020 __open 005c __statfs 00a0 __close 00b0 __aeabi_read_tp 0134 __libc_errno"
	strings:
		$1 = { 30 40 2D E9 10 41 9F E5 00 30 94 E5 00 00 53 E3 44 D0 4D E2 39 00 00 1A 00 10 A0 E1 FC 00 9F E5 ?? ?? ?? ?? 01 00 70 E3 00 50 A0 E1 25 00 00 0A 04 30 94 E5 00 00 53 E3 05 00 00 0A 01 30 A0 E3 04 30 84 E5 05 00 A0 E1 44 D0 8D E2 30 40 BD E8 ?? ?? ?? ?? 0D 10 A0 E1 C4 00 9F E5 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A B8 30 9F E5 00 20 9D E5 03 00 52 E1 F0 FF FF 0A 0D 10 A0 E1 A8 00 9F E5 ?? ?? ?? ?? 00 00 50 E3 03 00 00 1A 9C 30 9F E5 00 20 9D E5 03 00 52 E1 E7 FF FF 0A 05 00 A0 E1 ?? ?? ?? ?? 01 30 A0 E3 00 30 84 E5 80 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 02 20 A0 E3 03 20 80 E7 00 00 E0 E3 DF FF FF EA 68 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 02 00 53 E3 13 00 53 13 05 00 A0 11 D7 FF FF 1A 01 30 A0 E3 05 00 A0 E1 00 30 84 E5 44 D0 8D E2 30 40 BD E8 ?? ?? ?? ?? 34 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 02 20 A0 E3 03 20 80 E7 00 00 E0 E3 CA FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? D1 1C 00 00 ?? ?? ?? ?? 73 13 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_354_1_0 {
	meta:
		name = "__bsd_getpt"
		size = 192
		refs = "0014 mempcpy 0040 __aeabi_read_tp 006c __open 00b0 __libc_ptyname1 00b4 __libc_errno 00b8 __libc_ptyname2"
	strings:
		$1 = { F0 40 2D E9 14 D0 4D E2 04 00 8D E2 98 10 9F E5 08 20 A0 E3 ?? ?? ?? ?? 90 70 9F E5 00 30 A0 E3 8C 60 9F E5 02 30 C0 E5 00 50 A0 E1 70 30 A0 E3 00 30 C5 E5 7C 40 9F E5 30 30 A0 E3 07 00 00 EA ?? ?? ?? ?? 06 30 9F E7 03 30 90 E7 02 00 53 E3 09 00 00 0A 01 30 F4 E5 00 00 53 E3 0A 00 00 0A 01 30 C5 E5 04 00 8D E2 02 10 A0 E3 ?? ?? ?? ?? 01 00 70 E3 00 20 A0 E1 F0 FF FF 0A 02 00 A0 E1 14 D0 8D E2 F0 40 BD E8 ?? ?? ?? ?? 01 30 F7 E5 00 00 53 E3 E5 FF FF 1A 1C 30 9F E5 02 10 A0 E3 03 30 9F E7 03 10 80 E7 F3 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_354_2_0 {
	meta:
		name = "__getpt"
		size = 36
		refs = "0008 __posix_openpt 0020 __bsd_getpt"
	strings:
		$1 = { 08 40 2D E9 02 00 A0 E3 ?? ?? ?? ?? 01 00 70 E3 01 00 00 0A 08 40 BD E8 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_355_0_0 {
	meta:
		name = "__bb_exit_func"
		size = 536
		refs = "0010 _IO_new_fopen 004c fwrite_unlocked 00dc __overflow 0194 _IO_new_fclose 01a8 perror 0214 __bb_head"
	strings:
		$1 = { F0 47 2D E9 FC 01 9F E5 20 D0 4D E2 F8 11 9F E5 ?? ?? ?? ?? 00 40 50 E2 61 00 00 0A 00 30 94 E5 01 C0 A0 E3 E4 E1 9F E5 02 39 83 E3 00 30 84 E5 0C 20 A0 E1 04 30 A0 E1 0C 00 8D E2 14 10 A0 E3 0C E0 8D E5 04 C0 8D E5 10 C0 8D E5 ?? ?? ?? ?? BC 31 9F E5 00 80 93 E5 00 00 58 E3 02 90 A0 13 4A 00 00 0A 14 30 94 E5 18 10 94 E5 0C 20 98 E5 01 00 53 E1 08 20 8D E5 5E 00 00 2A 01 20 83 E2 14 20 84 E5 00 90 C3 E5 14 30 94 E5 18 10 94 E5 01 00 53 E1 04 50 A0 E3 08 20 8D E2 0B 00 00 2A 00 10 D2 E5 01 00 83 E2 14 00 84 E5 00 10 C3 E5 01 60 82 E2 01 50 55 E2 0A 00 00 0A 14 30 94 E5 18 10 94 E5 01 00 53 E1 06 20 A0 E1 F3 FF FF 3A 04 00 A0 E1 00 10 D2 E5 01 60 82 E2 ?? ?? ?? ?? 01 00 70 E3 F2 FF FF 1A 08 30 9D E5 00 00 53 E3 00 70 A0 13 22 00 00 0A 14 50 98 E5 07 A1 A0 E1 0A 50 85 E0 01 50 85 E2 04 60 A0 E3 14 30 94 E5 18 20 94 E5 02 00 53 E1 26 00 00 2A 01 20 83 E2 14 20 84 E5 01 20 55 E5 00 20 C3 E5 01 60 56 E2 01 50 85 E2 F4 FF FF 1A 08 50 98 E5 0A 50 85 E0 01 50 85 E2 04 60 A0 E3 14 30 94 E5 18 20 94 E5 02 00 53 E1 1D 00 00 2A 01 20 83 E2 14 20 84 E5 01 20 55 E5 00 20 C3 E5 01 60 56 E2 01 50 85 E2 F4 FF FF 1A 08 30 9D E5 01 70 87 E2 07 00 53 E1 DC FF FF 8A 10 80 98 E5 00 00 58 E3 B4 FF FF 1A 04 00 A0 E1 ?? ?? ?? ?? 20 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 5C 00 9F E5 ?? ?? ?? ?? 20 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 04 00 A0 E1 01 10 55 E5 ?? ?? ?? ?? 01 00 70 E3 DA FF FF 0A D6 FF FF EA 04 00 A0 E1 01 10 55 E5 ?? ?? ?? ?? 01 00 70 E3 E0 FF FF 1A 08 30 9D E5 01 70 87 E2 07 00 53 E1 C0 FF FF 8A E2 FF FF EA 04 00 A0 E1 02 10 A0 E3 ?? ?? ?? ?? 9F FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? 67 6D 6F 6E ?? ?? ?? ?? }
	condition:
		$1
}

rule file_356_0_0 {
	meta:
		name = "accept4"
		size = 192
		refs = "003c __libc_enable_asynccancel 006c __libc_disable_asynccancel 0084 __aeabi_read_tp 00b0 __libc_multiple_threads 00b8 __libc_errno"
	strings:
		$1 = { A8 C0 9F E5 00 C0 9C E5 00 00 5C E3 F0 41 2D E9 00 70 A0 E1 01 60 A0 E1 02 50 A0 E1 03 40 A0 E1 05 00 00 1A 88 70 9F E5 00 00 00 EF 01 0A 70 E3 10 00 00 8A F0 41 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 06 10 A0 E1 00 80 A0 E1 05 20 A0 E1 07 00 A0 E1 04 30 A0 E1 58 70 9F E5 00 00 00 EF 01 0A 70 E3 00 40 A0 E1 0A 00 00 8A 08 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 EE FF FF EA 38 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 E7 FF FF EA 20 30 9F E5 00 40 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 40 80 E7 00 40 E0 E3 ED FF FF EA ?? ?? ?? ?? 6E 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_357_0_0 {
	meta:
		name = "dysize"
		size = 104
	strings:
		$1 = { 03 00 10 E3 10 00 00 1A 4C 10 9F E5 90 31 C1 E0 C0 2F A0 E1 C1 32 62 E0 03 31 83 E0 03 31 83 E0 03 01 50 E1 0A 00 00 1A C1 23 62 E0 02 21 82 E0 02 21 82 E0 24 C0 9F E5 24 30 9F E5 02 02 50 E1 0C 00 A0 01 03 00 A0 11 ?? ?? ?? ?? 10 00 9F E5 ?? ?? ?? ?? 04 00 9F E5 ?? ?? ?? ?? 1F 85 EB 51 6E 01 00 00 6D 01 00 00 }
	condition:
		$1
}

rule file_358_0_0 {
	meta:
		name = "__statvfs64"
		size = 96
		refs = "0014 __statfs64 0030 __xstat64 004c __internal_statvfs64"
	strings:
		$1 = { F0 40 2D E9 C4 D0 4D E2 01 60 A0 E1 0D 10 A0 E1 00 50 A0 E1 ?? ?? ?? ?? 00 40 50 E2 0B 00 00 1A 58 70 8D E2 07 20 A0 E1 05 10 A0 E1 03 00 A0 E3 ?? ?? ?? ?? 01 00 70 E3 07 30 A0 11 00 30 A0 03 05 00 A0 E1 06 10 A0 E1 0D 20 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 C4 D0 8D E2 F0 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_360_0_0 {
	meta:
		name = "__scalbn"
		size = 408
		refs = "0098 __aeabi_dmul 00dc __aeabi_dadd"
		altNames = "__scalbln"
	strings:
		$1 = { 70 40 2D E9 02 61 C1 E3 26 6A A0 E1 06 6A A0 E1 46 3A B0 E1 02 60 A0 E1 01 20 A0 E1 32 00 00 0A 58 C1 9F E5 0C 00 53 E1 29 00 00 0A 50 C1 9F E5 0C 00 56 E1 1B 00 00 BA 48 C1 9F E5 0C 00 56 E1 0D 00 00 CA 40 C1 9F E5 06 60 83 E0 0C 00 56 E1 09 00 00 CA 00 00 56 E3 32 00 00 DA 7F 24 C2 E3 0F 26 C2 E3 00 40 A0 E1 06 6A 82 E1 04 00 A0 E1 06 10 A0 E1 70 40 BD E8 ?? ?? ?? ?? 00 00 51 E3 D8 10 8F E2 03 00 91 E8 D8 10 8F B2 03 00 91 B8 C8 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 40 A0 E1 01 60 A0 E1 F0 FF FF EA 00 00 51 E3 BC 10 8F E2 03 00 91 E8 BC 10 8F B2 03 00 91 B8 AC 30 8F E2 0C 00 93 E8 ?? ?? ?? ?? 00 40 A0 E1 01 60 A0 E1 E5 FF FF EA 00 20 A0 E1 01 30 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 01 60 A0 E1 DF FF FF EA 02 31 C1 E3 00 30 93 E1 00 40 A0 E1 01 60 A0 01 DA FF FF 0A 00 20 A0 E3 84 30 9F E5 ?? ?? ?? ?? 02 31 C1 E3 23 3A A0 E1 03 3A A0 E1 43 3A A0 E1 36 30 43 E2 01 20 A0 E1 C0 FF FF EA 35 00 76 E3 DD FF FF BA 7F 34 C2 E3 0F 36 C3 E3 36 60 86 E2 06 5A 83 E1 05 10 A0 E1 00 20 A0 E3 44 30 9F E5 ?? ?? ?? ?? 00 40 A0 E1 01 60 A0 E1 C3 FF FF EA 00 00 A0 E1 9C 75 00 88 3C E4 37 7E 9C 75 00 88 3C E4 37 FE 59 F3 F8 C2 1F 6E A5 01 59 F3 F8 C2 1F 6E A5 81 FF 07 00 00 B0 3C FF FF 50 C3 00 00 FE 07 00 00 00 00 50 43 00 00 90 3C }
	condition:
		$1
}

rule file_361_0_0 {
	meta:
		name = "mkstemp"
		size = 28
		refs = "0010 __gen_tempname"
	strings:
		$1 = { 08 40 2D E9 00 10 A0 E3 01 30 A0 E1 01 20 A0 E1 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_0_0 {
	meta:
		name = "svc_find"
		size = 112
		refs = "0010 __rpc_thread_variables"
	strings:
		$1 = { F8 40 2D E9 00 40 A0 E1 01 60 A0 E1 02 70 A0 E1 ?? ?? ?? ?? B4 30 90 E5 00 00 53 E3 11 00 00 0A 00 50 A0 E3 04 00 00 EA 00 00 93 E5 00 00 50 E3 09 00 00 0A 03 50 A0 E1 00 30 A0 E1 04 C0 93 E5 04 00 5C E1 F7 FF FF 1A 08 00 93 E5 06 00 50 E1 F4 FF FF 1A 03 00 A0 E1 05 30 A0 E1 00 30 87 E5 F8 40 BD E8 ?? ?? ?? ?? 03 00 A0 E1 FA FF FF EA }
	condition:
		$1
}

rule file_362_1_0 {
	meta:
		name = "xprt_register"
		size = 296
		refs = "0008 __rpc_thread_variables 0020 _rpc_dtablesize 003c __rpc_thread_svc_max_pollfd 0044 __rpc_thread_svc_pollfd 0084 realloc 00bc __rpc_thread_svc_fdset 0114 malloc"
	strings:
		$1 = { 78 41 2D E9 00 60 A0 E1 ?? ?? ?? ?? B0 30 90 E5 00 00 53 E3 00 40 A0 E1 00 50 96 E5 3A 00 00 0A ?? ?? ?? ?? 00 00 55 E1 21 00 00 AA B0 30 94 E5 01 0B 55 E3 05 61 83 E7 1F 00 00 BA ?? ?? ?? ?? 00 60 A0 E1 ?? ?? ?? ?? 00 80 A0 E1 00 00 90 E5 00 C0 96 E5 00 30 A0 E1 00 20 A0 E3 03 00 00 EA 08 10 93 E4 01 00 71 E3 22 00 00 0A 01 20 82 E2 0C 00 52 E1 03 40 A0 E1 F8 FF FF BA 01 10 8C E2 81 11 A0 E1 ?? ?? ?? ?? 00 00 50 E3 08 00 00 0A 00 30 96 E5 01 20 83 E2 00 00 88 E5 00 20 86 E5 83 51 80 E7 00 20 96 E5 C3 30 A0 E3 82 01 80 E0 B4 30 40 E1 78 41 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? C5 2F A0 E1 00 00 55 E3 1F 30 85 E2 A2 2D A0 E1 05 30 A0 A1 02 C0 85 E0 C3 32 A0 E1 1F C0 0C E2 03 11 90 E7 0C 20 62 E0 01 C0 A0 E3 1C 22 81 E1 03 21 80 E7 D0 FF FF EA C3 30 A0 E3 00 50 84 E5 B4 30 C4 E1 78 41 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 A0 E1 ?? ?? ?? ?? 00 00 50 E3 B0 00 84 E5 BE FF FF 1A E2 FF FF EA }
	condition:
		$1
}

rule file_362_2_0 {
	meta:
		name = "xprt_unregister"
		size = 192
		refs = "000c _rpc_dtablesize 0018 __rpc_thread_variables 0044 __rpc_thread_svc_fdset 007c __rpc_thread_svc_max_pollfd 0094 __rpc_thread_svc_pollfd"
	strings:
		$1 = { F0 41 2D E9 00 50 90 E5 00 40 A0 E1 ?? ?? ?? ?? 00 00 55 E1 04 00 00 AA ?? ?? ?? ?? B0 30 90 E5 05 21 93 E7 04 00 52 E1 01 00 00 0A F0 41 BD E8 ?? ?? ?? ?? 00 20 A0 E3 01 0B 55 E3 05 21 83 E7 0D 00 00 AA ?? ?? ?? ?? C5 2F A0 E1 00 00 55 E3 1F 30 85 E2 A2 2D A0 E1 05 30 A0 A1 02 C0 85 E0 C3 32 A0 E1 1F C0 0C E2 03 11 90 E7 0C 20 62 E0 01 C0 A0 E3 1C 22 C1 E1 03 21 80 E7 ?? ?? ?? ?? 00 40 A0 E3 00 70 A0 E1 00 60 90 E5 00 80 E0 E3 06 00 00 EA ?? ?? ?? ?? 00 30 90 E5 84 21 93 E7 05 00 52 E1 84 81 83 07 00 60 97 05 01 40 84 E2 06 00 54 E1 F6 FF FF BA F0 41 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_3_0 {
	meta:
		name = "svc_register"
		size = 184
		refs = "0050 malloc 0068 __rpc_thread_variables 00a0 pmap_set"
	strings:
		$1 = { F0 41 2D E9 01 60 A0 E1 08 D0 4D E2 02 10 A0 E1 02 50 A0 E1 00 80 A0 E1 04 20 8D E2 06 00 A0 E1 03 70 A0 E1 5F FF FF EB 00 40 50 E2 06 00 00 0A 0C 30 94 E5 07 00 53 E1 10 00 00 0A 00 00 A0 E3 08 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 14 00 A0 E3 ?? ?? ?? ?? 00 40 50 E2 F7 FF FF 0A 04 60 84 E5 08 50 84 E5 0C 70 84 E5 ?? ?? ?? ?? B4 20 90 E5 00 30 A0 E3 00 20 84 E5 10 30 84 E5 B4 40 80 E5 20 30 9D E5 00 00 53 E3 01 00 A0 03 EB FF FF 0A 06 00 A0 E1 05 10 A0 E1 B4 30 D8 E1 20 20 9D E5 ?? ?? ?? ?? 00 00 50 E3 01 00 A0 13 10 00 84 15 E2 FF FF 1A E0 FF FF EA }
	condition:
		$1
}

rule file_362_4_0 {
	meta:
		name = "svc_unregister"
		size = 144
		refs = "0040 free 0070 pmap_unset 0080 __rpc_thread_variables"
	strings:
		$1 = { 70 40 2D E9 08 D0 4D E2 0D 20 A0 E1 00 60 A0 E1 01 50 A0 E1 35 FF FF EB 00 40 50 E2 14 00 00 0A 00 30 9D E5 00 00 53 E3 14 00 00 0A 00 20 94 E5 00 20 83 E5 00 30 A0 E3 00 30 84 E5 04 00 A0 E1 ?? ?? ?? ?? 06 00 A0 E1 05 10 A0 E1 04 20 8D E2 26 FF FF EB 00 00 50 E3 02 00 00 0A 10 30 90 E5 00 00 53 E3 02 00 00 1A 06 00 A0 E1 05 10 A0 E1 ?? ?? ?? ?? 08 D0 8D E2 70 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 00 30 94 E5 B4 30 80 E5 E8 FF FF EA }
	condition:
		$1
}

rule file_362_5_0 {
	meta:
		name = "svc_sendreply"
		size = 96
	strings:
		$1 = { 70 40 2D E9 00 30 A0 E1 20 00 80 E2 30 D0 4D E2 01 50 A0 E1 02 60 A0 E1 07 00 90 E8 00 E0 A0 E3 0C C0 8D E2 01 40 A0 E3 07 00 8C E8 1C 60 8D E5 20 50 8D E5 08 20 93 E5 03 00 A0 E1 10 40 8D E9 18 E0 8D E5 0D 10 A0 E1 0C C0 92 E5 0F E0 A0 E1 ?? ?? ?? ?? 30 D0 8D E2 70 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_6_0 {
	meta:
		name = "svcerr_noproc"
		size = 88
	strings:
		$1 = { 30 40 2D E9 20 20 80 E2 34 D0 4D E2 00 30 A0 E1 07 00 92 E8 0C C0 8D E2 03 E0 A0 E3 01 50 A0 E3 00 40 A0 E3 07 00 8C E8 04 50 8D E5 08 20 93 E5 03 00 A0 E1 08 40 8D E5 18 E0 8D E5 0D 10 A0 E1 0C C0 92 E5 0F E0 A0 E1 ?? ?? ?? ?? 34 D0 8D E2 30 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_7_0 {
	meta:
		name = "svcerr_decode"
		size = 88
	strings:
		$1 = { 30 40 2D E9 20 20 80 E2 34 D0 4D E2 00 30 A0 E1 07 00 92 E8 0C C0 8D E2 04 E0 A0 E3 01 50 A0 E3 00 40 A0 E3 07 00 8C E8 04 50 8D E5 08 20 93 E5 03 00 A0 E1 08 40 8D E5 18 E0 8D E5 0D 10 A0 E1 0C C0 92 E5 0F E0 A0 E1 ?? ?? ?? ?? 34 D0 8D E2 30 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_8_0 {
	meta:
		name = "svcerr_systemerr"
		size = 88
	strings:
		$1 = { 30 40 2D E9 20 20 80 E2 34 D0 4D E2 00 30 A0 E1 07 00 92 E8 0C C0 8D E2 05 E0 A0 E3 01 50 A0 E3 00 40 A0 E3 07 00 8C E8 04 50 8D E5 08 20 93 E5 03 00 A0 E1 08 40 8D E5 18 E0 8D E5 0D 10 A0 E1 0C C0 92 E5 0F E0 A0 E1 ?? ?? ?? ?? 34 D0 8D E2 30 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_9_0 {
	meta:
		name = "svcerr_auth"
		size = 60
	strings:
		$1 = { 04 E0 2D E5 01 30 A0 E3 34 D0 4D E2 10 10 8D E5 04 30 8D E5 08 30 8D E5 0C 30 8D E5 0D 10 A0 E1 08 30 90 E5 0C C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 34 D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_10_0 {
	meta:
		name = "svcerr_weakauth"
		size = 64
	strings:
		$1 = { 04 E0 2D E5 01 30 A0 E3 34 D0 4D E2 05 20 A0 E3 04 30 8D E5 08 30 8D E5 0C 30 8D E5 10 20 8D E5 08 30 90 E5 0D 10 A0 E1 0C C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 34 D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_11_0 {
	meta:
		name = "svcerr_noprog"
		size = 84
	strings:
		$1 = { 10 40 2D E9 20 20 80 E2 30 D0 4D E2 00 30 A0 E1 07 00 92 E8 01 E0 A0 E3 0C C0 8D E2 00 40 A0 E3 07 00 8C E8 04 E0 8D E5 08 20 93 E5 03 00 A0 E1 18 E0 8D E5 08 40 8D E5 0D 10 A0 E1 0C C0 92 E5 0F E0 A0 E1 ?? ?? ?? ?? 30 D0 8D E2 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_12_0 {
	meta:
		name = "svcerr_progvers"
		size = 104
	strings:
		$1 = { F0 40 2D E9 00 30 A0 E1 20 00 80 E2 34 D0 4D E2 01 70 A0 E1 02 60 A0 E1 07 00 90 E8 0C C0 8D E2 02 E0 A0 E3 01 50 A0 E3 00 40 A0 E3 07 00 8C E8 1C 70 8D E5 20 60 8D E5 08 20 93 E5 03 00 A0 E1 04 50 8D E5 08 40 8D E5 18 E0 8D E5 0D 10 A0 E1 0C C0 92 E5 0F E0 A0 E1 ?? ?? ?? ?? 34 D0 8D E2 F0 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_13_0 {
	meta:
		name = "svc_getreq_common"
		size = 464
		refs = "001c __rpc_thread_variables 0110 svcerr_progvers 0148 svcerr_noprog 0158 _authenticate 01cc _null_auth"
	strings:
		$1 = { F0 47 2D E9 53 DE 4D E2 21 3E 8D E2 80 20 8D E2 00 40 A0 E1 48 30 8D E5 3C 20 8D E5 ?? ?? ?? ?? B0 30 90 E5 04 81 93 E7 00 00 58 E3 00 50 A0 E1 40 00 00 0A 90 71 9F E5 3A 6E 8D E2 40 40 8D E2 08 30 98 E5 08 00 A0 E1 20 10 8D E2 00 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 2C 00 00 0A 2C 30 8D E2 08 42 93 E8 38 C0 9D E5 07 00 14 E8 00 30 8D E5 00 00 5C E3 0C 30 8D E2 18 60 8D E5 1C 80 8D E5 00 42 8D E9 07 00 83 E8 2F 00 00 1A 00 30 97 E5 28 C0 88 E5 20 30 88 E5 B4 30 95 E5 00 00 53 E3 26 00 00 0A 00 00 A0 E3 00 E0 9D E5 04 90 9D E5 00 20 A0 E1 00 10 E0 E3 02 00 00 EA 00 30 93 E5 00 00 53 E3 0D 00 00 0A 04 C0 93 E5 0C 00 5E E1 F9 FF FF 1A 08 C0 93 E5 09 00 5C E1 2B 00 00 0A 00 30 93 E5 0C 00 51 E1 0C 10 A0 21 0C 00 52 E1 0C 20 A0 31 00 00 53 E3 01 00 A0 E3 F1 FF FF 1A 00 00 50 E3 0D 00 00 0A 08 00 A0 E1 ?? ?? ?? ?? 08 30 98 E5 08 00 A0 E1 04 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 00 00 50 E3 1E 00 00 0A 01 00 50 E3 C1 FF FF 0A 53 DE 8D E2 F0 47 BD E8 ?? ?? ?? ?? 08 00 A0 E1 ?? ?? ?? ?? F0 FF FF EA 0D 00 A0 E1 20 10 8D E2 ?? ?? ?? ?? 00 00 50 E3 CD FF FF 0A 01 30 A0 E3 60 00 8D E5 58 30 8D E5 5C 30 8D E5 54 30 8D E5 08 00 A0 E1 08 30 98 E5 50 10 8D E2 0C C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? DF FF FF EA 0D 00 A0 E1 08 10 A0 E1 0C C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? D9 FF FF EA 08 30 98 E5 08 00 A0 E1 14 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 53 DE 8D E2 F0 47 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_14_0 {
	meta:
		name = "svc_getreqset"
		size = 104
		refs = "0008 _rpc_dtablesize 0034 svc_getreq_common 0040 __ffssi2"
	strings:
		$1 = { F8 43 2D E9 00 80 A0 E1 ?? ?? ?? ?? 01 0B 50 E3 00 90 A0 B1 01 9B A0 A3 00 00 59 E3 0F 00 00 DA 00 60 A0 E3 01 70 A0 E3 04 40 98 E4 02 00 00 EA 01 50 45 E2 ?? ?? ?? ?? 17 45 24 E0 04 00 A0 E1 ?? ?? ?? ?? 00 50 50 E2 05 00 86 E0 01 00 40 E2 F6 FF FF 1A 20 60 86 E2 09 00 56 E1 F1 FF FF BA F8 43 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_15_0 {
	meta:
		name = "svc_getreq"
		size = 60
		refs = "002c svc_getreqset"
	strings:
		$1 = { 04 E0 2D E5 84 D0 4D E2 04 30 4D E2 7C 10 8D E2 00 20 A0 E3 04 20 A3 E5 01 00 53 E1 FC FF FF 1A 80 30 8D E2 80 00 23 E5 0D 00 A0 E1 ?? ?? ?? ?? 84 D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_16_0 {
	meta:
		name = "svc_getreq_poll"
		size = 148
		refs = "0010 __rpc_thread_svc_max_pollfd 0028 __rpc_thread_variables 0038 xprt_unregister 0080 svc_getreq_common"
	strings:
		$1 = { F8 43 2D E9 00 90 51 E2 00 40 A0 E1 1E 00 00 0A ?? ?? ?? ?? 00 50 A0 E3 00 80 A0 E1 00 20 90 E5 05 70 A0 E1 09 00 00 EA ?? ?? ?? ?? B0 30 90 E5 01 70 87 E2 06 01 93 E7 ?? ?? ?? ?? 07 00 59 E1 11 00 00 DA 00 20 98 E5 01 50 85 E2 08 40 84 E2 02 00 55 E1 0C 00 00 AA 00 60 94 E5 01 00 76 E3 F8 FF FF 0A B6 30 D4 E1 00 00 53 E3 F5 FF FF 0A 20 00 13 E3 06 00 A0 E1 EA FF FF 1A 01 70 87 E2 ?? ?? ?? ?? 07 00 59 E1 ED FF FF CA F8 43 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_17_0 {
	meta:
		name = "__svc_accept_failed"
		size = 92
		refs = "0008 __aeabi_read_tp 0044 __nanosleep 0054 __libc_errno"
	strings:
		$1 = { 04 E0 2D E5 48 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 18 00 53 E3 0C D0 4D E2 02 00 00 0A 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? 00 30 A0 E3 20 20 9F E5 03 10 A0 E1 0D 00 A0 E1 00 30 8D E5 04 20 8D E5 ?? ?? ?? ?? 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? ?? ?? ?? ?? 80 F0 FA 02 }
	condition:
		$1
}

rule file_362_18_0 {
	meta:
		name = "__rpc_thread_svc_cleanup"
		size = 44
		refs = "0004 __rpc_thread_variables 0014 svc_unregister"
	strings:
		$1 = { 10 40 2D E9 ?? ?? ?? ?? 00 40 A0 E1 01 00 00 EA 03 00 93 E9 ?? ?? ?? ?? B4 30 94 E5 00 00 53 E3 FA FF FF 1A 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_363_0_0 {
	meta:
		name = "__fxstatat64"
		size = 412
		refs = "0070 __aeabi_read_tp 00a8 strlen 00d8 __snprintf 010c __atfct_seterrno 0180 __have_atfcts 0188 __libc_errno"
	strings:
		$1 = { F0 4B 2D E9 1C B0 8D E2 08 D0 4D E2 03 00 50 E3 01 60 A0 E1 02 40 A0 E1 03 80 A0 E1 04 50 9B E5 46 00 00 1A 54 C1 9F E5 00 30 9C E5 00 00 53 E3 14 00 00 BA 01 00 A0 E1 05 30 A0 E1 02 10 A0 E1 3C 71 9F E5 08 20 A0 E1 00 00 00 EF 01 0A 70 E3 41 00 00 9A 26 00 70 E3 00 30 E0 03 00 30 8C 05 08 00 00 0A 1C 31 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 1C D0 4B E2 F0 4B BD E8 ?? ?? ?? ?? 01 9C D5 E3 24 00 00 1A 64 00 76 E3 11 00 00 0A 00 30 D4 E5 2F 00 53 E3 0E 00 00 0A 04 00 A0 E1 ?? ?? ?? ?? 00 10 50 E2 2B 00 00 0A 2E 30 81 E2 07 30 C3 E3 03 D0 4D E0 08 90 8D E2 00 40 8D E5 20 10 81 E2 09 00 A0 E1 B4 20 9F E5 06 30 A0 E1 ?? ?? ?? ?? 09 40 A0 E1 01 0C 15 E3 04 00 A0 E1 08 10 A0 E1 09 00 00 0A C4 70 A0 E3 00 00 00 EF 01 0A 70 E3 DE FF FF 9A 00 00 60 E2 06 10 A0 E1 09 20 A0 E1 ?? ?? ?? ?? 00 00 E0 E3 D8 FF FF EA C3 70 A0 E3 00 00 00 EF F4 FF FF EA 64 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 00 00 E0 E3 CE FF FF EA 4C 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 00 00 E0 E3 C7 FF FF EA 00 00 A0 E3 C5 FF FF EA 2C 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 02 20 A0 E3 03 20 80 E7 00 00 E0 E3 BE FF FF EA ?? ?? ?? ?? 47 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_364_0_0 {
	meta:
		name = "setdomainname"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 79 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_365_0_0 {
	meta:
		name = "__posix_spawn"
		size = 44
		refs = "001c __spawni"
	strings:
		$1 = { 10 40 2D E9 10 D0 4D E2 18 40 8D E2 10 40 94 E8 00 C0 A0 E3 10 40 8D E8 08 C0 8D E5 ?? ?? ?? ?? 10 D0 8D E2 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_366_1_0 {
	meta:
		name = "svcudp_getargs"
		size = 36
	strings:
		$1 = { 08 40 2D E9 30 00 90 E5 01 30 A0 E1 08 00 80 E2 02 10 A0 E1 0F E0 A0 E1 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_366_2_0 {
	meta:
		name = "svcudp_freeargs"
		size = 40
	strings:
		$1 = { 08 40 2D E9 30 00 90 E5 02 30 A0 E3 08 30 A0 E5 01 30 A0 E1 02 10 A0 E1 0F E0 A0 E1 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_366_3_0 {
	meta:
		name = "svcudp_destroy"
		size = 80
		refs = "000c xprt_unregister 0014 __close 0034 free"
	strings:
		$1 = { 38 40 2D E9 30 50 90 E5 00 40 A0 E1 ?? ?? ?? ?? 00 00 94 E5 ?? ?? ?? ?? 0C 30 95 E5 1C 30 93 E5 00 00 53 E3 08 00 85 12 0F E0 A0 11 ?? ?? ?? ?? 2C 00 94 E5 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 38 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_366_4_0 {
	meta:
		name = "svcudp_recv"
		size = 772
		refs = "0078 __recvmsg 0128 xdr_callmsg 0164 __aeabi_uidivmod 01d4 memcmp 0204 __sendto 0258 __recvfrom 026c __aeabi_read_tp 0280 __svc_accept_failed 02cc memcpy 02f4 __sendmsg 0300 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 1C D0 4D E2 30 60 90 E5 EC 92 9F E5 0C 10 8D E5 00 40 A0 E1 34 B0 80 E2 3C 80 80 E2 10 70 80 E2 58 A0 80 E2 10 50 A0 E3 48 30 94 E5 00 20 A0 E3 02 00 53 E1 DC 00 A0 E3 08 10 A0 E1 14 50 8D E5 7D 00 00 0A 00 30 96 E5 2C C0 94 E5 38 30 84 E5 01 30 A0 E3 50 00 84 E5 34 C0 84 E5 44 B0 84 E5 48 30 84 E5 3C 70 84 E5 40 50 84 E5 4C A0 84 E5 00 00 94 E5 ?? ?? ?? ?? 00 00 50 E3 75 00 00 BA 50 10 94 E5 40 20 94 E5 0B 00 51 E3 14 20 8D E5 12 00 00 9A 4C 30 94 E5 00 00 53 E3 0F 00 00 0A 00 C0 93 E5 0B 00 5C E3 59 00 00 9A 03 90 8C E2 03 90 C9 E3 09 50 83 E0 01 10 83 E0 0C A0 85 E2 0A 00 51 E1 52 00 00 3A 09 90 93 E7 03 90 89 E2 03 90 C9 E3 09 50 85 E0 05 00 51 E1 4C 00 00 3A 00 30 A0 E3 4C 30 84 E5 50 30 84 E5 0C 20 84 E5 0F 00 50 E3 65 00 00 DA 08 50 86 E2 01 90 A0 E3 0C 30 96 E5 00 10 A0 E3 05 00 A0 E1 08 90 86 E5 14 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 05 00 A0 E1 0C 10 9D E5 ?? ?? ?? ?? 00 00 50 E3 57 00 00 0A 0C 10 9D E5 B0 21 96 E5 00 30 91 E5 00 00 52 E3 04 30 86 E5 2E 00 00 0A 30 30 94 E5 B0 91 93 E5 04 60 93 E5 00 10 99 E5 06 00 A0 E1 01 11 A0 E1 ?? ?? ?? ?? 04 30 99 E5 01 51 93 E7 00 00 55 E3 1C A0 89 E2 03 00 00 1A 48 00 00 EA 28 50 95 E5 00 00 55 E3 45 00 00 0A 00 30 95 E5 03 00 56 E1 F9 FF FF 1A 04 20 95 E5 18 30 99 E5 03 00 52 E1 F5 FF FF 1A 08 20 95 E5 14 30 99 E5 03 00 52 E1 F1 FF FF 1A 0C 20 95 E5 10 30 99 E5 03 00 52 E1 ED FF FF 1A 10 00 85 E2 0A 10 A0 E1 10 20 A0 E3 ?? ?? ?? ?? 00 00 50 E3 E7 FF FF 1A 48 30 94 E5 20 10 85 E2 00 00 53 E3 00 C0 A0 E1 06 00 91 E8 39 00 00 1A 14 C0 9D E5 00 00 94 E5 80 10 8D E8 ?? ?? ?? ?? 01 00 A0 E3 1C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 04 10 93 E5 00 00 51 E3 AF FF FF 1A 08 50 93 E5 08 00 55 E3 AC FF FF 1A 17 00 5C E3 0C 10 83 85 AC FF FF 8A A8 FF FF EA 14 C0 8D E2 00 00 94 E5 2C 10 94 E5 00 20 96 E5 00 70 8D E5 04 C0 8D E5 ?? ?? ?? ?? 14 30 9D E5 01 00 70 E3 0C 30 84 E5 A1 FF FF 1A ?? ?? ?? ?? 09 30 9F E7 03 30 90 E7 04 00 53 E3 6A FF FF 0A ?? ?? ?? ?? 00 00 A0 E3 1C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 00 A0 E3 1C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 0C 20 9D E5 14 30 92 E5 18 30 89 E5 10 30 92 E5 14 30 89 E5 0C 30 92 E5 0A 00 A0 E1 07 10 A0 E1 10 30 89 E5 10 20 A0 E3 ?? ?? ?? ?? 01 00 A0 E3 1C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 34 10 84 E5 38 20 84 E5 00 00 94 E5 08 10 A0 E1 0C 20 A0 E1 ?? ?? ?? ?? 01 00 A0 E3 E1 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_366_5_0 {
	meta:
		name = "svcudp_reply"
		size = 688
		refs = "0048 xdr_replymsg 00a0 __sendto 00e8 __aeabi_uidivmod 0130 __dcgettext 0140 __fxprintf 016c __sendmsg 01a4 xdrmem_create 0220 malloc 0248 free 02a0 _libc_intl_domainname"
	strings:
		$1 = { F0 47 2D E9 30 40 90 E5 00 70 A0 E3 08 60 84 E2 01 80 A0 E1 08 D0 4D E2 0C 30 94 E5 07 10 A0 E1 00 50 A0 E1 08 70 84 E5 06 00 A0 E1 14 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 04 30 94 E5 08 10 A0 E1 00 30 88 E5 06 00 A0 E1 ?? ?? ?? ?? 07 00 50 E1 03 00 00 1A 00 00 A0 E3 08 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 06 00 A0 E1 0C 30 94 E5 10 C0 93 E5 0F E0 A0 E1 ?? ?? ?? ?? 48 30 95 E5 00 00 53 E3 00 60 A0 E1 32 00 00 1A 0C C0 95 E5 10 20 85 E2 00 00 95 E5 2C 10 95 E5 04 10 8D E8 06 20 A0 E1 ?? ?? ?? ?? 06 00 50 E1 E9 FF FF 1A B0 31 94 E5 00 00 53 E3 22 00 00 0A 00 00 56 E3 20 00 00 BA 30 80 95 E5 B0 71 98 E5 0C 20 97 E5 08 30 97 E5 02 41 93 E7 00 00 54 E3 4F 00 00 0A 00 10 97 E5 00 00 94 E5 01 11 A0 E1 ?? ?? ?? ?? 04 30 97 E5 01 C1 93 E7 00 00 5C E3 01 31 83 E0 08 00 00 0A 0C 00 54 E1 03 00 00 1A 1A 00 00 EA 03 00 54 E1 17 00 00 0A 03 C0 A0 E1 28 30 9C E5 00 00 53 E3 F9 FF FF 1A 70 11 9F E5 05 20 A0 E3 6C 01 9F E5 ?? ?? ?? ?? 68 11 9F E5 00 20 A0 E1 00 00 A0 E3 ?? ?? ?? ?? 01 00 A0 E3 08 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 2C 30 95 E5 05 10 A0 E1 3C 00 91 E4 07 20 A0 E1 38 60 85 E5 34 30 85 E5 ?? ?? ?? ?? CB FF FF EA 28 30 8C E2 28 20 94 E5 00 20 83 E5 00 20 98 E5 20 90 94 E5 2C 30 95 E5 09 10 A0 E1 20 30 84 E5 24 60 84 E5 08 00 88 E2 00 30 A0 E3 2C 90 85 E5 ?? ?? ?? ?? 18 10 97 E5 14 20 97 E5 10 30 97 E5 04 E0 98 E5 0E 00 84 E9 00 E0 84 E5 1C 30 87 E2 0F 00 93 E8 10 C0 84 E2 0F 00 8C E8 30 30 95 E5 B0 31 93 E5 00 10 93 E5 0E 00 A0 E1 01 11 A0 E1 ?? ?? ?? ?? 04 30 97 E5 01 21 93 E7 28 20 84 E5 01 41 83 E7 08 20 87 E2 0C 00 92 E8 00 10 97 E5 01 00 83 E2 03 41 82 E7 ?? ?? ?? ?? 01 00 A0 E3 0C 10 87 E5 8E FF FF EA 2C 00 A0 E3 ?? ?? ?? ?? 00 40 50 E2 11 00 00 0A 00 A0 98 E5 0A 00 A0 E1 ?? ?? ?? ?? 00 90 50 E2 0A 20 A0 11 D0 FF FF 1A 04 00 A0 E1 ?? ?? ?? ?? 54 10 9F E5 05 20 A0 E3 44 00 9F E5 ?? ?? ?? ?? 40 10 9F E5 00 20 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 01 00 A0 E3 78 FF FF EA 30 10 9F E5 05 20 A0 E3 1C 00 9F E5 ?? ?? ?? ?? 18 10 9F E5 00 20 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 01 00 A0 E3 6E FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_366_6_0 {
	meta:
		name = "svcudp_bufcreate"
		size = 576
		refs = "004c bindresvport 0064 __getsockname 0074 malloc 00d0 xdrmem_create 0120 __setsockopt 013c memset 0144 xprt_register 0164 __dcgettext 0168 perror 017c __close 01a0 __bind 01b4 __socket 0200 __fxprintf 0208 free 022c _libc_intl_domainname"
	strings:
		$1 = { F0 47 2D E9 01 00 70 E3 20 D0 4D E2 10 30 A0 E3 00 40 A0 E1 01 80 A0 E1 02 90 A0 E1 08 30 8D E5 00 60 A0 13 5F 00 00 0A 00 50 A0 E3 02 30 A0 E3 10 10 8D E2 04 00 A0 E1 10 50 8D E5 14 50 8D E5 18 50 8D E5 1C 50 8D E5 B0 31 CD E1 ?? ?? ?? ?? 05 00 50 E1 4D 00 00 1A 10 10 8D E2 04 00 A0 E1 08 20 8D E2 ?? ?? ?? ?? 00 70 50 E2 39 00 00 1A 4D 0F A0 E3 ?? ?? ?? ?? 00 50 A0 E1 6D 0F A0 E3 ?? ?? ?? ?? 08 00 59 E1 09 80 A0 21 03 80 88 E2 03 80 C8 E3 00 60 A0 E1 08 00 A0 E1 ?? ?? ?? ?? 00 00 56 E3 00 00 55 13 00 A0 A0 E1 4B 00 00 0A 00 00 50 E3 49 00 00 0A 06 00 A0 E1 08 80 80 E4 08 20 A0 E1 0A 10 A0 E1 01 30 A0 E3 2C A0 85 E5 ?? ?? ?? ?? B2 21 DD E1 20 30 8D E2 40 C1 9F E5 01 10 A0 E3 02 E4 A0 E1 14 10 23 E5 22 E4 8E E1 04 10 A0 E3 20 80 86 E2 00 10 8D E5 08 20 A0 E3 07 10 A0 E1 B4 E0 C5 E1 08 C0 85 E5 B0 71 86 E5 04 00 A0 E1 30 60 85 E5 24 80 85 E5 00 40 85 E5 ?? ?? ?? ?? 00 00 50 E3 FF 70 A0 03 07 10 A0 E1 01 2C A0 E3 34 00 85 E2 0C 70 8D E5 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? 05 00 A0 E1 20 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? C8 10 9F E5 05 20 A0 E3 C4 00 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 56 E3 06 00 A0 01 F4 FF FF 0A 04 00 A0 E1 ?? ?? ?? ?? 00 00 A0 E3 20 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 04 00 A0 E1 10 10 8D E2 08 20 9D E5 B2 51 CD E1 ?? ?? ?? ?? AB FF FF EA 02 00 A0 E3 00 10 A0 E1 11 20 A0 E3 ?? ?? ?? ?? 00 40 50 E2 01 60 A0 A3 98 FF FF AA 64 10 9F E5 05 20 A0 E3 58 00 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 A0 E3 DA FF FF EA 4C 10 9F E5 05 20 A0 E3 3C 00 9F E5 ?? ?? ?? ?? 40 10 9F E5 00 30 A0 E1 3C 20 9F E5 00 00 A0 E3 ?? ?? ?? ?? 05 00 A0 E1 ?? ?? ?? ?? 06 00 A0 E1 ?? ?? ?? ?? 0A 00 A0 E1 ?? ?? ?? ?? 00 00 A0 E3 C9 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_366_7_0 {
	meta:
		name = "svcudp_create"
		size = 16
		refs = "0008 svcudp_bufcreate"
	strings:
		$1 = { 04 10 9F E5 01 20 A0 E1 ?? ?? ?? ?? 60 22 00 00 }
	condition:
		$1
}

rule file_366_8_0 {
	meta:
		name = "svcudp_enablecache"
		size = 324
		refs = "0024 __dcgettext 0034 __fxprintf 0048 malloc 0064 calloc 00a0 free 0130 _libc_intl_domainname"
	strings:
		$1 = { F8 40 2D E9 30 50 90 E5 B0 41 95 E5 00 00 54 E3 01 60 A0 E1 0A 00 00 0A 0C 11 9F E5 05 20 A0 E3 08 01 9F E5 ?? ?? ?? ?? 04 11 9F E5 00 20 A0 E1 00 00 A0 E3 ?? ?? ?? ?? 00 00 A0 E3 F8 40 BD E8 ?? ?? ?? ?? 2C 00 A0 E3 ?? ?? ?? ?? 00 70 50 E2 1F 00 00 0A 0C 40 87 E5 00 60 87 E5 04 00 A0 E3 06 11 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 40 A0 E1 04 00 87 E5 20 00 00 0A 06 10 A0 E1 04 00 A0 E3 ?? ?? ?? ?? 00 00 50 E3 08 00 87 E5 00 60 A0 E1 B0 71 85 15 01 00 A0 13 E7 FF FF 1A 04 00 A0 E1 ?? ?? ?? ?? 07 00 A0 E1 ?? ?? ?? ?? 84 10 9F E5 05 20 A0 E3 74 00 9F E5 ?? ?? ?? ?? 70 10 9F E5 00 20 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 06 00 A0 E1 D9 FF FF EA 60 10 9F E5 05 20 A0 E3 4C 00 9F E5 ?? ?? ?? ?? 48 10 9F E5 00 20 A0 E1 07 00 A0 E1 ?? ?? ?? ?? 07 00 A0 E1 CF FF FF EA 07 00 A0 E1 ?? ?? ?? ?? 34 10 9F E5 05 20 A0 E3 1C 00 9F E5 ?? ?? ?? ?? 18 10 9F E5 00 20 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 C3 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_368_0_0 {
	meta:
		name = "isfdtype"
		size = 112
		refs = "0010 __aeabi_read_tp 0030 __fxstat64 0068 __libc_errno"
	strings:
		$1 = { 70 40 2D E9 5C 30 9F E5 00 20 A0 E1 68 D0 4D E2 ?? ?? ?? ?? 03 30 9F E7 00 40 A0 E1 01 60 A0 E1 03 00 A0 E3 02 10 A0 E1 0D 20 A0 E1 03 50 94 E7 ?? ?? ?? ?? 30 30 9F E5 00 00 50 E3 03 30 9F E7 03 50 84 E7 04 00 00 1A 10 00 9D E5 0F 0A 00 E2 06 30 50 E0 00 00 73 E2 03 00 B0 E0 68 D0 8D E2 70 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_369_0_0 {
	meta:
		name = "setpriority"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 61 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_370_0_0 {
	meta:
		name = "str_to_mpn"
		size = 632
		refs = "009c __mpn_mul_1 0228 __assert_fail 0258 _tens_in_limb"
	strings:
		$1 = { F8 4F 2D E9 03 B0 A0 E1 00 40 51 E2 00 30 A0 E3 00 80 A0 E1 02 A0 A0 E1 00 30 8B E5 87 00 00 DA 03 20 A0 E1 03 90 A0 E1 03 60 A0 E1 01 50 A0 E3 00 00 00 EA 03 60 A0 E1 00 30 98 E5 30 10 43 E2 09 00 51 E3 04 30 98 85 09 91 89 E0 04 80 88 82 89 90 83 E0 01 40 54 E2 30 90 49 E2 04 80 88 E2 01 30 86 E2 2F 00 00 0A 09 00 53 E3 F0 FF FF 1A 00 00 52 E3 05 00 00 1A 00 90 8A E5 00 90 A0 E3 00 50 8B E5 09 30 A0 E1 01 20 A0 E3 E8 FF FF EA BC 31 9F E5 0A 00 A0 E1 0A 10 A0 E1 ?? ?? ?? ?? 00 30 9A E5 03 90 89 E0 09 00 53 E1 00 30 9B E5 00 90 8A E5 15 00 00 9A 04 20 8A E2 04 00 00 EA 04 10 92 E4 01 10 81 E2 00 00 51 E3 04 10 02 E5 0E 00 00 1A 01 30 53 E2 F8 FF FF 1A 01 90 A0 E3 00 90 99 E0 0C 00 00 0A 00 30 9B E5 11 00 53 E3 4D 00 00 CA 03 91 8A E7 00 20 9B E5 00 90 A0 E3 01 20 82 E2 00 20 8B E5 09 30 A0 E1 C8 FF FF EA 00 90 A0 E3 00 90 99 E0 F2 FF FF 1A 09 30 A0 E1 00 20 9B E5 C2 FF FF EA 28 C0 9D E5 30 00 9C E8 01 00 54 E3 00 10 D5 E2 04 00 00 BA 08 60 66 E2 C6 7F A0 E1 04 00 56 E1 05 C0 D7 E0 09 00 00 AA 00 11 9F E5 00 00 52 E3 03 31 91 E7 10 00 00 1A 01 30 A0 E3 00 90 8A E5 00 30 8B E5 08 00 A0 E1 F8 4F BD E8 ?? ?? ?? ?? D8 50 9F E5 28 C0 9D E5 04 61 95 E7 04 30 83 E0 00 00 A0 E3 00 10 A0 E3 00 00 52 E3 96 09 09 E0 03 31 95 E7 03 00 8C E8 EE FF FF 0A 0A 00 A0 E1 0A 10 A0 E1 ?? ?? ?? ?? 00 30 9A E5 03 90 89 E0 09 00 53 E1 00 30 9B E5 00 90 8A E5 0A 00 00 9A 04 20 8A E2 04 00 00 EA 04 10 92 E4 01 10 81 E2 00 00 51 E3 04 10 02 E5 03 00 00 1A 01 30 53 E2 F8 FF FF 1A 01 30 A0 E3 00 00 00 EA 00 30 A0 E3 00 30 93 E0 DA FF FF 0A 00 20 9B E5 11 00 52 E3 01 10 82 D2 00 10 8B D5 02 31 8A D7 D4 FF FF DA 3C 00 9F E5 3C 10 9F E5 3C 20 9F E5 3C 30 9F E5 ?? ?? ?? ?? 28 00 9F E5 28 10 9F E5 30 20 9F E5 28 30 9F E5 ?? ?? ?? ?? 28 00 9F E5 14 10 9F E5 24 20 9F E5 14 30 9F E5 ?? ?? ?? ?? 00 CA 9A 3B ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? B3 01 00 00 ?? ?? ?? ?? 7B 01 00 00 ?? ?? ?? ?? 6A 01 00 00 }
	condition:
		$1
}

rule file_370_1_0 {
	meta:
		name = "round_and_return"
		size = 800
		refs = "00c0 __mpn_rshift 00e0 __aeabi_read_tp 00f8 __aeabi_fmul 014c __mpn_construct_float 0280 abort 0308 _dl_hwcap 030c __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 FC 12 9F E5 C0 00 91 E8 40 40 A0 E3 00 50 A0 E3 06 40 04 E0 07 50 05 E0 05 10 94 E1 0C D0 4D E2 00 A0 A0 E1 02 40 A0 E1 03 50 A0 E1 30 80 9D E5 3C 90 9D E5 00 B0 A0 03 01 00 00 0A 10 BA F1 EE 03 B5 0B E2 7D 60 E0 E3 00 70 E0 E3 06 00 54 E1 07 20 D5 E0 4A 00 00 AA 95 20 E0 E3 00 30 E0 E3 02 00 54 E1 03 C0 D5 E0 38 00 00 BA 38 00 9D E5 01 20 A0 E3 12 30 A0 E1 FF 44 64 E2 FF 48 84 E2 34 10 9D E5 FF 4C 84 E2 01 30 43 E2 01 00 13 E1 82 40 84 E2 01 90 89 13 18 00 54 E3 8F 00 00 0A 00 C0 9A E5 04 30 A0 E1 0A 00 A0 E1 0A 10 A0 E1 01 40 44 E2 34 C0 8D E5 38 40 8D E5 ?? ?? ?? ?? 00 60 9A E5 34 00 8D E2 03 00 90 E8 30 71 A0 E1 01 70 17 E2 41 00 00 0A 28 32 9F E5 ?? ?? ?? ?? 03 30 9F E7 22 20 A0 E3 03 20 80 E7 02 05 A0 E3 00 10 A0 E1 ?? ?? ?? ?? 04 00 8D E5 04 30 9D E5 7E 40 E0 E3 00 50 E0 E3 00 20 98 E2 01 20 A0 13 00 00 59 E3 01 30 07 E2 01 10 A0 13 28 00 00 0A 01 05 5B E3 5A 00 00 0A 38 00 00 DA 02 05 5B E3 52 00 00 0A 03 05 5B E3 4F 00 00 1A 04 10 A0 E1 0A 00 A0 E1 08 20 A0 E1 ?? ?? ?? ?? 09 00 00 EA B4 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 22 20 A0 E3 00 00 58 E3 03 20 80 E7 02 05 A0 E3 22 00 00 1A 00 10 A0 E1 ?? ?? ?? ?? 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 81 00 54 E3 00 20 D5 E2 34 00 00 BA 78 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 22 20 A0 E3 00 00 58 E3 03 20 80 E7 64 01 9F E5 EF FF FF 0A 02 15 E0 E3 ?? ?? ?? ?? 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 34 00 8D E2 01 10 90 E8 00 10 E0 E3 11 1C C0 E1 00 10 91 E2 01 10 A0 13 CF FF FF EA 00 00 59 E3 BB FF FF 1A 00 30 E0 E3 13 31 C0 E1 00 00 53 E3 C1 FF FF 0A B6 FF FF EA 14 11 9F E5 ?? ?? ?? ?? 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 00 5B E3 18 00 00 1A 00 00 53 E3 01 30 06 12 03 30 81 11 C4 FF FF 0A 00 00 53 E3 C2 FF FF 0A 01 60 86 E2 01 04 16 E3 00 60 8A E5 19 00 00 1A 7E 20 E0 E3 00 30 E0 E3 03 00 55 E1 02 00 54 01 B9 FF FF 1A 02 05 16 E3 7E 10 E0 03 7D 10 E0 13 B6 FF FF EA 34 30 8D E2 08 10 93 E8 33 7C A0 E1 00 60 9A E5 01 70 07 E2 A2 FF FF EA ?? ?? ?? ?? 00 00 52 E3 03 30 81 11 FF 20 03 12 02 30 A0 E1 E4 FF FF EA 00 00 52 E3 03 30 81 01 FF 30 03 02 E0 FF FF 0A A4 FF FF EA 01 20 A0 E3 01 40 94 E2 02 30 A0 E1 0A 00 A0 E1 0A 10 A0 E1 00 50 A5 E2 ?? ?? ?? ?? 00 30 9A E5 00 00 55 E3 81 00 54 03 02 35 83 E3 00 30 8A E5 AC FF FF 0A 96 FF FF EA 00 20 9A E5 00 60 A0 E3 17 30 A0 E3 34 20 8D E5 06 00 52 E1 01 90 89 13 38 30 8D E5 00 60 8A E5 6F FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF FF 7F 7F 00 00 80 80 }
	condition:
		$1
}

rule file_370_2_0 {
	meta:
		name = "____wcstof_l_internal"
		size = 9036
		refs = "005c __iswspace_l 00ec __towlower_l 0224 __aeabi_ldivmod 0354 __correctly_grouped_prefixwc 0720 memcpy 0768 __mpn_mul 07dc __clzsi2 07f8 __mpn_lshift 089c __aeabi_uidiv 08ac __aeabi_uidivmod 0c60 __iswxdigit_l 106c __mpn_rshift 10ec __mpn_cmp 1454 __wcsncasecmp_l 14dc ____wcstoull_l_internal 15e0 _fpioconst_pow10 15e4 __tens 1604 _nl_C_locobj 1610 __libc_errno 1868 __mpn_submul_1 1888 __mpn_add_n 1bec __assert_fail 1fa0 __aeabi_read_tp 1fc0 __aeabi_fmul"
	strings:
		$1 = { F0 4F 2D E9 00 00 52 E3 FC D0 4D E2 03 B0 A0 E1 2C 00 8D E5 30 10 8D E5 04 30 93 E5 28 20 8D 05 02 70 A0 01 28 08 00 1A 30 30 93 E5 00 00 53 E3 1C 30 8D E5 15 08 00 0A 00 30 A0 E3 00 20 A0 E3 60 20 8D E5 64 30 8D E5 2C 30 9D E5 00 40 93 E5 0B 10 A0 E1 04 00 A0 E1 03 50 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 30 85 E2 F7 FF FF 1A 2D 00 54 E3 05 20 A0 E1 8B 02 00 0A 2B 00 54 E3 04 40 92 05 3C 00 8D E5 03 50 A0 01 1C C0 9D E5 0C 00 54 E1 70 02 00 0A 30 30 44 E2 09 00 53 E3 86 02 00 8A 30 00 54 E3 0A 60 A0 13 20 60 8D 15 71 02 00 0A 00 30 97 E2 01 30 A0 13 05 60 A0 E1 00 00 00 EA 04 40 B6 E5 30 00 54 E3 FC FF FF 0A 07 00 54 E1 00 80 A0 13 01 80 03 02 00 00 58 E3 F7 FF FF 1A 04 00 A0 E1 0B 10 A0 E1 34 60 8D E5 ?? ?? ?? ?? 30 90 44 E2 09 00 59 E3 00 A0 A0 E1 7A 00 00 8A 06 A0 A0 E1 00 C0 A0 E3 09 00 59 E3 18 C0 8D E5 0A 90 A0 E1 07 00 00 8A 18 C0 9D E5 01 C0 8C E2 18 C0 8D E5 04 40 BA E5 30 90 44 E2 09 00 59 E3 0A 90 A0 E1 F7 FF FF 9A 20 C0 9D E5 10 00 5C E3 A5 02 00 0A 00 00 57 E3 77 08 00 1A 28 30 9D E5 00 00 53 E3 E8 07 00 1A 18 C0 9D E5 1C 50 9D E5 00 00 5C E3 00 C0 A0 13 00 C0 E0 03 05 00 54 E1 28 C0 8D E5 18 A0 9D 15 86 00 00 0A 04 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 20 C0 9D E5 10 C0 5C E2 00 80 7C E2 0C 80 B8 E0 70 00 50 E3 00 40 A0 13 01 40 08 02 00 00 54 E3 2C 40 8D E5 9C 00 00 0A 04 80 99 E5 2D 00 58 E3 4C 02 00 0A 2B 00 58 E3 00 40 A0 13 00 50 A0 03 38 40 8D 15 08 80 99 05 38 50 8D 05 04 70 89 12 08 70 89 02 30 80 48 E2 09 00 58 E3 97 00 00 8A 2C C0 9D E5 00 00 5C E3 51 02 00 1A 38 50 9D E5 00 00 55 E3 81 02 00 0A 18 00 9D E5 00 10 A0 E3 01 50 A0 E1 3D 40 90 E2 00 50 A5 E2 04 00 A0 E1 05 10 A0 E1 0A 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 40 00 8D E5 44 10 8D E5 04 00 A0 E1 05 10 A0 E1 0A 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 50 20 8D E5 54 30 8D E5 48 90 8D E5 4C A0 8D E5 07 90 A0 E1 06 A0 A0 E1 60 50 8D E2 30 00 95 E8 40 70 8D E2 C0 00 97 E8 0A C0 A0 E3 04 00 56 E1 05 20 D7 E0 3D 07 00 BA 07 00 55 E1 06 00 54 01 08 00 A0 E1 00 10 A0 E3 33 07 00 0A 94 2C 83 E0 9C 35 23 E0 04 80 99 E5 00 40 92 E0 30 80 48 E2 01 50 A3 E0 09 00 58 E3 04 90 89 E2 EE FF FF 9A 38 C0 9D E5 00 00 5C E3 09 70 A0 E1 0A 60 A0 E1 48 90 9D E5 4C A0 9D E5 60 40 8D E5 64 50 8D E5 5C 00 00 0A 00 40 74 E2 00 50 E5 E2 60 40 8D E5 64 50 8D E5 57 00 00 EA 20 C0 9D E5 61 20 40 E2 10 10 5C E2 01 10 A0 13 05 00 52 E3 10 00 5C 93 7D FF FF 0A 1C C0 9D E5 0C 00 54 E1 FB 01 00 0A 00 00 51 E3 26 04 00 0A 20 E0 9D E5 10 30 5E E2 00 C0 73 E2 03 C0 BC E0 65 00 5A E3 0C A0 A0 01 01 A0 8C 13 00 00 5A E3 6F FF FF 0A 07 20 A0 E1 28 30 9D E5 05 00 A0 E1 06 10 A0 E1 14 C0 8D E5 ?? ?? ?? ?? 30 40 9D E5 00 00 54 E3 14 C0 9D E5 04 00 00 0A 00 00 55 E1 00 60 A0 11 C1 06 00 0A 30 50 9D E5 00 60 85 E5 3C 60 9D E5 00 00 56 E3 10 02 00 1A 00 00 A0 E3 FC D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 0A 50 A0 E1 18 A0 9D E5 38 80 8D E5 04 40 B5 E5 20 70 9D E5 0A 90 A0 E1 0C 80 A0 E1 2C 60 8D E5 0D 00 00 EA 04 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 61 00 40 E2 05 00 50 E3 08 02 00 8A 30 40 54 E2 01 40 A0 13 01 00 78 E3 00 40 A0 13 00 00 54 E3 04 40 B5 E5 0A 80 69 10 01 A0 8A E2 30 30 44 E2 09 00 53 E3 F4 FF FF 9A 10 00 57 E3 EC FF FF 0A 04 00 A0 E1 0B 10 A0 E1 28 80 8D E5 05 90 A0 E1 38 80 9D E5 2C 60 9D E5 ?? ?? ?? ?? 65 10 50 E2 20 50 9D E5 00 00 71 E2 01 00 B0 E0 10 00 55 E3 00 00 A0 03 00 00 50 E3 2C 80 8D E5 59 FF FF 1A 09 70 A0 E1 18 40 9D E5 04 00 5A E1 0A 00 00 9A 04 30 19 E5 30 00 53 E3 04 00 00 1A 04 90 49 E2 04 30 19 E5 30 00 53 E3 01 A0 4A E2 FA FF FF 0A 18 50 9D E5 05 00 5A E1 AC 07 00 3A 18 C0 9D E5 0A 20 5C E0 00 30 72 E2 02 30 B3 E0 00 00 5A E3 00 30 A0 03 00 00 53 E3 04 00 00 0A 60 30 8D E2 0C 00 93 E8 00 00 52 E3 00 00 D3 E2 51 02 00 BA 30 50 9D E5 00 00 55 E3 00 70 85 15 00 00 5A E3 AB FF FF 0A 28 C0 9D E5 00 00 5C E3 28 00 00 0A 00 30 96 E5 1C 40 9D E5 04 00 53 E1 07 00 00 0A 04 60 86 E2 04 10 A0 E1 00 20 96 E5 01 00 52 E1 06 30 A0 E1 04 60 86 E2 FA FF FF 1A 34 30 8D E5 28 60 9D E5 20 50 9D E5 34 C0 9D E5 01 30 86 E2 03 C1 8C E0 10 00 55 E3 00 50 A0 E3 06 20 A0 E1 34 C0 8D E5 05 30 A0 E1 60 70 8D E2 C0 00 97 E8 B0 05 00 0A 00 00 96 E2 02 11 A7 E2 03 00 51 E1 02 00 50 01 24 07 00 3A 20 50 9D E5 10 00 55 E3 28 C0 9D 05 2C 3F A0 01 0C 21 A0 01 02 20 56 E0 03 30 C7 E0 28 40 9D E5 60 20 8D E5 64 30 8D E5 0A A0 64 E0 20 50 9D E5 10 00 55 E3 B2 01 00 0A 60 10 8D E2 03 00 91 E8 00 00 50 E3 00 60 D1 E2 7B 01 00 BA 18 60 9D E5 06 20 5A E0 0A 30 CA E0 02 00 50 E1 03 C0 D1 E0 01 00 00 AA 00 20 A0 E1 01 30 A0 E1 18 40 9D E5 02 90 84 E0 09 50 A0 E1 00 60 A0 E3 20 50 8D E5 24 60 8D E5 02 20 50 E0 03 30 C1 E0 20 10 8D E2 03 00 91 E8 27 40 A0 E3 00 50 A0 E3 00 40 54 E0 01 50 C5 E0 02 00 54 E1 03 10 D5 E0 60 20 8D E5 64 30 8D E5 1D 07 00 BA 2B 00 E0 E3 00 10 E0 E3 00 00 52 E1 01 50 D3 E0 29 07 00 BA 00 00 59 E3 09 80 A0 01 1C 02 00 1A 09 00 5A E1 1F 07 00 9A 60 50 8D E2 30 00 95 E8 2C 20 94 E2 00 30 A5 E2 00 00 53 E3 2C 00 52 03 18 07 00 8A 00 00 58 E3 4B 05 00 DA 00 00 59 E3 D0 06 00 0A 05 60 94 E1 19 C0 68 02 00 40 A0 03 CC 06 00 1A 20 70 8D E2 C0 00 97 E8 0A 00 A0 E1 00 10 A0 E3 0C 20 A0 E1 CC 3F A0 E1 06 60 50 E0 07 70 C1 E0 02 00 56 E1 03 E0 D7 E0 0A C0 69 B0 20 60 8D E2 60 00 96 E8 0C 20 A0 B1 C2 3F A0 B1 05 20 92 E0 06 30 A3 E0 00 00 52 E1 01 60 D3 E0 09 A0 8C B0 68 60 8D E2 01 C0 A0 B3 0A 90 69 E0 00 50 A0 A3 18 60 8D E5 4C C0 8D B5 B0 C0 8D E2 09 60 64 E0 4C 50 8D A5 20 90 8D E5 1C C0 8D E5 F0 5E 9F E5 F0 7E 9F E5 18 A0 9D E5 0C B0 A0 E1 01 40 A0 E3 00 90 A0 E3 0B 00 00 EA 10 10 45 E2 02 02 91 E8 02 90 49 E2 02 10 81 E2 09 21 A0 E1 01 11 87 E0 0B 00 A0 E1 ?? ?? ?? ?? 00 00 56 E3 84 40 A0 E1 10 50 85 E2 19 00 00 0A 04 00 16 E1 F9 FF FF 0A 00 00 59 E3 04 60 26 E0 EE FF FF 0A 10 10 45 E2 06 00 91 E8 02 10 81 E2 0B 30 A0 E1 00 90 8D E5 0A 00 A0 E1 01 11 87 E0 02 20 42 E2 ?? ?? ?? ?? 0C 30 15 E5 02 30 43 E2 00 00 50 E3 03 90 89 E0 01 90 49 02 0B 30 A0 E1 00 00 56 E3 0A B0 A0 E1 84 40 A0 E1 03 A0 A0 E1 10 50 85 E2 E5 FF FF 1A 18 40 9D E5 04 00 5B E1 A4 05 00 0A 60 30 8D E2 01 50 49 E2 20 10 9D E5 00 30 8D E5 18 20 9D E5 58 30 8D E2 34 00 9D E5 2C 50 8D E5 05 61 A0 E1 A5 FC FF EB F8 C0 8D E2 06 30 8C E0 48 00 13 E5 ?? ?? ?? ?? 00 40 50 E2 0B 00 00 DA 1C 00 9D E5 09 20 A0 E1 00 10 A0 E1 04 30 A0 E1 ?? ?? ?? ?? 18 00 9D E5 04 30 A0 E1 00 10 A0 E1 58 20 9D E5 ?? ?? ?? ?? 00 00 50 E3 F6 02 00 1A 58 20 9D E5 08 00 A0 E1 C8 1F A0 E1 01 00 59 E3 60 00 8D E5 64 10 8D E5 66 02 00 0A 02 00 59 E3 20 02 00 1A 01 00 52 E3 B0 90 9D E5 B4 50 9D E5 4C 03 00 DA 68 A0 8D E2 00 14 9A E8 00 60 A0 E3 1C 60 8D E5 5C B0 8D E2 05 38 A0 E1 00 20 69 E2 23 38 A0 E1 18 30 8D E5 30 20 8D E5 20 B0 8D E5 08 60 A0 E1 25 48 A0 E1 09 80 A0 E1 0A 90 A0 E1 0C A0 A0 E1 05 00 5A E1 77 04 00 0A 04 10 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 70 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 18 00 9D E5 97 00 00 E0 29 38 A0 E1 01 18 83 E1 01 00 50 E1 07 00 00 9A 05 10 91 E0 01 20 47 E2 03 00 00 2A 01 00 50 E1 02 70 47 82 05 10 81 80 00 00 00 8A 02 70 A0 E1 01 A0 60 E0 0A 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 04 10 A0 E1 00 B0 A0 E1 0A 00 A0 E1 ?? ?? ?? ?? 18 A0 9D E5 9B 0A 0A E0 09 C8 A0 E1 2C C8 A0 E1 01 C8 8C E1 0C 00 5A E1 07 00 00 9A 05 C0 9C E0 01 30 4B E2 03 00 00 2A 0C 00 5A E1 02 B0 4B 82 05 C0 8C 80 00 00 00 8A 03 B0 A0 E1 07 18 8B E1 91 28 83 E0 0C 00 6A E0 02 A0 A0 E1 00 00 53 E1 05 00 00 8A 00 20 9A E2 01 20 A0 13 00 00 53 E1 00 20 A0 13 00 00 52 E3 05 00 00 0A 08 C0 5A E0 00 30 C3 E2 05 00 90 E0 0C A0 A0 E1 01 10 41 E2 F1 FF FF 3A 00 E0 A0 E3 0A 90 5E E0 03 A0 C0 E0 0E 00 56 E1 3D 04 00 1A 0E 00 51 E1 40 04 00 0A 01 00 A0 E1 14 10 8D E5 ?? ?? ?? ?? 60 70 8D E2 C0 00 97 E8 20 E0 60 E2 00 20 56 E0 C0 3F C7 E0 02 60 A0 E1 03 70 A0 E1 18 00 5E E3 60 60 8D E5 64 70 8D E5 14 10 9D E5 4F 06 00 DA 20 B0 9D E5 0A C0 A0 E1 01 40 A0 E1 09 A0 A0 E1 08 10 60 E2 34 11 A0 E1 18 00 80 E2 5C 10 8D E5 1C 00 8D E5 4C 60 9D E5 00 00 5C E3 01 60 86 13 01 20 52 E2 1C C0 9D E5 00 30 C3 E2 00 00 56 E3 1F 10 6C E2 01 A0 A0 13 01 00 00 1A 00 A0 9A E2 01 A0 A0 13 3C 50 9D E5 04 40 8D E5 00 50 8D E5 08 10 8D E5 0C A0 8D E5 0B 00 A0 E1 A2 FC FF EB 4C FE FF EA 04 30 95 E5 30 30 43 E2 09 00 53 E3 8A FD FF 8A 30 00 54 E3 0A 60 A0 13 20 60 8D 15 8D FD FF 1A 04 00 95 E5 0B 10 A0 E1 ?? ?? ?? ?? 78 00 50 E3 00 60 A0 03 10 C0 A0 03 0A C0 A0 13 08 40 95 05 28 60 8D 05 08 50 85 02 20 C0 8D E5 81 FD FF EA 01 60 A0 E3 03 50 A0 E1 04 40 92 E5 3C 60 8D E5 72 FD FF EA 04 00 A0 E1 3C 1B 9F E5 ?? ?? ?? ?? 69 00 50 E3 59 04 00 0A 6E 00 50 E3 5A 02 00 0A 30 50 9D E5 00 00 55 E3 2C 60 9D 15 30 40 9D 15 00 60 84 15 25 FE FF EA 01 C0 A0 E3 08 70 89 E2 08 80 99 E5 38 C0 8D E5 B5 FD FF EA 20 C0 9D E5 06 00 55 E1 10 00 5C 03 7A FD FF 1A 04 00 96 E5 30 20 40 E2 09 00 52 E3 76 FD FF 9A 0B 10 A0 E1 ?? ?? ?? ?? 61 00 40 E2 05 00 50 E3 F8 FD FF 8A 70 FD FF EA 38 40 9D E5 00 00 54 E3 31 02 00 1A 18 40 9D E5 00 00 54 E3 87 04 00 0A 28 50 9D E5 00 00 55 E3 55 05 00 1A 18 C0 9D E5 20 20 A0 E3 00 30 A0 E3 0C 20 52 E0 00 30 C3 E2 03 51 A0 E1 02 41 A0 E1 22 5F 85 E1 03 40 94 E2 00 50 A5 E2 29 00 00 EA 18 40 9D E5 00 50 A0 E3 05 30 A0 E1 04 20 A0 E1 00 20 72 E2 00 30 E3 E2 00 00 52 E1 01 50 D3 E0 82 FE FF AA 7F FE FF EA 30 40 9D E5 3C 50 9D E5 00 00 54 E3 00 00 84 15 00 00 55 E3 EE FD FF 0A 02 01 A0 E3 FC D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 04 00 A0 E1 0B 10 A0 E1 ?? ?? ?? ?? 61 00 40 E2 05 00 50 E3 48 FD FF 9A 52 FD FF EA 05 90 A0 E1 28 80 8D E5 2C 60 9D E5 5C FD FF EA 18 40 9D E5 00 00 54 E3 F0 01 00 0A 28 50 9D E5 00 00 55 E3 92 05 00 1A 18 C0 9D E5 27 40 A0 E3 00 50 A0 E3 0C 40 54 E0 00 50 C5 E2 00 00 54 E3 00 10 D5 E2 74 FD FF AA 00 40 A0 E3 00 50 A0 E3 40 40 8D E5 44 50 8D E5 76 FD FF EA 34 50 9D E5 00 00 95 E5 0B 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 05 40 A0 E1 04 50 85 E2 F8 FF FF 0A 00 00 94 E5 30 00 50 E3 04 00 00 1A 05 30 A0 E1 03 40 A0 E1 04 00 93 E4 30 00 50 E3 FB FF FF 0A 30 30 40 E2 09 00 53 E3 04 40 84 92 24 04 00 8A 3C 29 9F E5 03 C1 92 E7 00 00 5C E3 3F 05 00 0A 18 20 6C E2 13 32 A0 E1 60 70 8D E2 C0 00 97 E8 18 00 9D E5 00 10 A0 E3 00 00 56 E3 00 E0 D7 E2 5C 30 8D E5 17 50 6C E2 00 80 A0 E1 01 90 A0 E1 18 04 00 BA 00 20 E0 E3 02 31 E0 E3 06 20 52 E0 07 30 C3 E0 0C 20 52 E0 CC 3F C3 E0 01 00 92 E2 00 10 A3 E2 C1 3F A0 E1 40 00 8D E5 44 10 8D E5 C3 2F A0 E1 03 10 A0 E1 03 00 A0 E3 02 30 A0 E1 01 20 A0 E1 00 10 A0 E3 00 20 02 E0 01 30 03 E0 02 00 A0 E1 03 10 A0 E1 40 30 8D E2 0C 00 93 E8 02 00 90 E0 03 10 A1 E0 20 01 A0 E1 01 2F 80 E1 41 31 A0 E1 03 00 59 E1 02 00 58 01 CF 04 00 8A 01 00 58 E2 00 10 C9 E2 01 C0 4C E2 01 31 A0 E1 00 21 A0 E1 0C 20 92 E0 20 3F 83 E1 CC 3F A3 E0 02 60 96 E0 03 70 A7 E0 01 A0 5A E2 60 60 8D E5 64 70 8D E5 09 00 00 1A 60 04 00 EA 02 00 55 E3 5C 20 9D E5 BB 03 00 DA 03 10 45 E2 13 31 82 E1 01 A0 5A E2 5C 30 8D E5 04 50 45 E2 CE 03 00 0A 00 00 94 E5 0B 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 40 84 02 00 00 94 E5 30 30 40 E2 09 00 53 E3 04 40 84 92 EC FF FF 9A 0B 10 A0 E1 ?? ?? ?? ?? 04 40 84 E2 57 30 40 E2 E7 FF FF EA 2C 40 9D E5 0C 50 A0 E1 19 00 00 EA 30 00 40 E2 09 00 50 E3 00 00 A0 93 01 00 A0 83 00 00 50 E3 12 00 00 1A 04 30 19 E5 30 00 53 E3 18 00 00 1A 00 00 54 E3 60 30 8D E2 0C 00 93 E8 01 00 A0 03 04 00 A0 13 00 20 92 E0 00 10 A0 E3 01 A0 4A E2 01 30 A3 E0 00 10 9A E2 01 10 A0 13 A3 1F 11 E0 01 50 45 E2 60 20 8D E5 64 30 8D E5 08 00 00 0A 04 90 49 E2 00 00 54 E3 04 00 19 E5 E2 FF FF 0A 0B 10 A0 E1 ?? ?? ?? ?? 01 00 70 E2 00 00 A0 33 E1 FF FF EA 18 50 8D E5 86 FD FF EA 68 C0 8D E2 60 30 8D E2 0C 20 A0 E1 00 30 8D E5 34 00 9D E5 58 30 8D E2 09 10 A0 E1 18 C0 8D E5 E9 FA FF EB 60 30 8D E2 0C 00 93 E8 01 00 52 E3 00 E0 D3 E2 34 00 8D E5 58 60 9D B5 45 00 00 BA B0 40 8D E2 58 60 9D E5 F4 56 9F E5 30 40 8D E5 1C 40 8D E5 01 40 A0 E3 2C 90 8D E5 02 00 A0 E1 18 80 9D E5 06 20 A0 E1 04 70 A0 E1 28 A0 8D E5 05 90 A0 E1 03 10 A0 E1 30 60 9D E5 15 00 00 EA 10 30 19 E5 BC E6 9F E5 02 30 83 E2 00 40 8D E5 03 31 8E E0 06 00 A0 E1 08 10 A0 E1 ?? ?? ?? ?? 58 20 9D E5 00 00 50 E3 02 20 84 E0 58 20 8D E5 FA 02 00 0A 08 30 A0 E1 60 10 8D E2 03 00 91 E8 06 80 A0 E1 03 60 A0 E1 01 30 90 E1 87 70 A0 E1 10 90 89 E2 16 00 00 0A C7 BF A0 E1 00 40 07 E0 01 50 0B E0 05 C0 94 E1 F6 FF FF 0A 0C 40 19 E5 02 40 44 E2 07 00 20 E0 0B 10 21 E0 02 00 54 E1 60 00 8D E5 64 10 8D E5 DC FF FF DA 10 10 19 E5 30 06 9F E5 02 10 81 E2 00 20 8D E5 01 11 80 E0 04 20 A0 E1 06 00 A0 E1 08 30 A0 E1 ?? ?? ?? ?? DA FF FF EA 1C 40 9D E5 04 00 58 E1 28 A0 9D E5 2C 90 9D E5 02 60 A0 E1 08 10 A0 01 18 00 9D 05 02 21 A0 01 ?? ?? ?? ?? 01 40 46 E2 F8 50 8D E2 04 31 85 E0 }
	condition:
		$1
}

rule file_371_0_0 {
	meta:
		name = "mkstemps"
		size = 64
		refs = "0014 __gen_tempname 0024 __aeabi_read_tp 003c __libc_errno"
	strings:
		$1 = { 00 00 51 E3 08 40 2D E9 04 00 00 BA 00 20 A0 E3 02 30 A0 E1 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? 14 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 00 00 E0 E3 F6 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_373_0_0 {
	meta:
		name = "sendfile"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 BB 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_374_0_0 {
	meta:
		name = "setrpcent"
		size = 300
		refs = "006c __nss_setent 0074 __aeabi_read_tp 00e8 __lll_lock_wait_private 0120 __nss_rpc_lookup2 0124 __libc_errno"
	strings:
		$1 = { F0 41 2D E9 01 10 A0 E3 10 D0 4D E2 00 50 A0 E1 FC 20 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 27 00 00 1A CC 40 9F E5 00 10 A0 E3 04 30 84 E2 08 30 8D E5 0C 10 8D E5 04 30 44 E2 B8 00 9F E5 30 00 8D E8 08 20 44 E2 B0 10 9F E5 ?? ?? ?? ?? AC 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 90 E7 0C 60 44 E2 00 50 96 E5 00 10 A0 E3 05 40 A0 E1 7C 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 09 00 00 CA 58 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 80 E7 10 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? D4 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1028_0_0 {
	meta:
		name = "setprotoent"
		size = 300
		refs = "006c __nss_setent 0074 __aeabi_read_tp 00e8 __lll_lock_wait_private 0120 __nss_protocols_lookup2 0124 __libc_errno"
	strings:
		$1 = { F0 41 2D E9 01 10 A0 E3 10 D0 4D E2 00 50 A0 E1 FC 20 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 27 00 00 1A CC 40 9F E5 00 10 A0 E3 04 30 84 E2 08 30 8D E5 0C 10 8D E5 04 30 44 E2 B8 00 9F E5 30 00 8D E8 08 20 44 E2 B0 10 9F E5 ?? ?? ?? ?? AC 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 90 E7 0C 60 44 E2 00 50 96 E5 00 10 A0 E3 05 40 A0 E1 7C 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 09 00 00 CA 58 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 80 E7 10 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? D4 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1397_0_0 {
	meta:
		name = "setservent"
		size = 300
		refs = "006c __nss_setent 0074 __aeabi_read_tp 00e8 __lll_lock_wait_private 0120 __nss_services_lookup2 0124 __libc_errno"
	strings:
		$1 = { F0 41 2D E9 01 10 A0 E3 10 D0 4D E2 00 50 A0 E1 FC 20 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 27 00 00 1A CC 40 9F E5 00 10 A0 E3 04 30 84 E2 08 30 8D E5 0C 10 8D E5 04 30 44 E2 B8 00 9F E5 30 00 8D E8 08 20 44 E2 B0 10 9F E5 ?? ?? ?? ?? AC 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 90 E7 0C 60 44 E2 00 50 96 E5 00 10 A0 E3 05 40 A0 E1 7C 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 09 00 00 CA 58 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 80 80 E7 10 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? D4 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EC FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_374_2_0 {
	meta:
		name = "__getrpcent_r"
		size = 348
		refs = "0090 __nss_getent_r 00a0 __aeabi_read_tp 0114 __lll_lock_wait_private 0150 __nss_rpc_lookup2 0154 __libc_errno"
	strings:
		$1 = { F0 43 2D E9 01 70 A0 E1 02 60 A0 E1 2C D0 4D E2 00 80 A0 E1 03 50 A0 E1 01 10 A0 E3 1C 21 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 2F 00 00 1A EC 40 9F E5 00 C0 A0 E3 04 20 84 E2 08 30 84 E2 0C 00 8D E9 10 80 8D E5 18 60 8D E5 04 30 44 E2 0C C0 8D E5 20 C0 8D E5 14 70 8D E5 1C 50 8D E5 00 40 8D E5 BC 00 9F E5 BC 10 9F E5 BC 20 9F E5 ?? ?? ?? ?? B8 30 9F E5 00 80 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 90 90 E7 08 60 44 E2 00 50 96 E5 00 10 A0 E3 05 40 A0 E1 80 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 0A 00 00 CA 60 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 90 80 E7 08 00 A0 E1 2C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? CC FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1028_2_0 {
	meta:
		name = "__getprotoent_r"
		size = 348
		refs = "0090 __nss_getent_r 00a0 __aeabi_read_tp 0114 __lll_lock_wait_private 0150 __nss_protocols_lookup2 0154 __libc_errno"
	strings:
		$1 = { F0 43 2D E9 01 70 A0 E1 02 60 A0 E1 2C D0 4D E2 00 80 A0 E1 03 50 A0 E1 01 10 A0 E3 1C 21 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 2F 00 00 1A EC 40 9F E5 00 C0 A0 E3 04 20 84 E2 08 30 84 E2 0C 00 8D E9 10 80 8D E5 18 60 8D E5 04 30 44 E2 0C C0 8D E5 20 C0 8D E5 14 70 8D E5 1C 50 8D E5 00 40 8D E5 BC 00 9F E5 BC 10 9F E5 BC 20 9F E5 ?? ?? ?? ?? B8 30 9F E5 00 80 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 90 90 E7 08 60 44 E2 00 50 96 E5 00 10 A0 E3 05 40 A0 E1 80 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 0A 00 00 CA 60 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 90 80 E7 08 00 A0 E1 2C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? CC FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1397_2_0 {
	meta:
		name = "__getservent_r"
		size = 348
		refs = "0090 __nss_getent_r 00a0 __aeabi_read_tp 0114 __lll_lock_wait_private 0150 __nss_services_lookup2 0154 __libc_errno"
	strings:
		$1 = { F0 43 2D E9 01 70 A0 E1 02 60 A0 E1 2C D0 4D E2 00 80 A0 E1 03 50 A0 E1 01 10 A0 E3 1C 21 9F E5 00 40 A0 E3 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 2F 00 00 1A EC 40 9F E5 00 C0 A0 E3 04 20 84 E2 08 30 84 E2 0C 00 8D E9 10 80 8D E5 18 60 8D E5 04 30 44 E2 0C C0 8D E5 20 C0 8D E5 14 70 8D E5 1C 50 8D E5 00 40 8D E5 BC 00 9F E5 BC 10 9F E5 BC 20 9F E5 ?? ?? ?? ?? B8 30 9F E5 00 80 A0 E1 03 30 9F E7 ?? ?? ?? ?? 03 90 90 E7 08 60 44 E2 00 50 96 E5 00 10 A0 E3 05 40 A0 E1 80 20 9F E5 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 01 00 55 E3 0A 00 00 CA 60 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 90 80 E7 08 00 A0 E1 2C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? CC FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 0C 00 9F E5 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF EB FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_375_0_0 {
	meta:
		name = "tmpfile64"
		size = 160
		refs = "0020 __path_search 0038 __gen_tempname 0048 __unlink 0054 _IO_fdopen 008c __close"
	strings:
		$1 = { 30 40 2D E9 01 DA 4D E2 0C D0 4D E2 00 20 A0 E3 01 1A A0 E3 08 00 8D E2 00 20 8D E5 74 30 9F E5 ?? ?? ?? ?? 00 10 50 E2 11 00 00 1A 01 30 A0 E1 08 00 8D E2 02 28 A0 E3 ?? ?? ?? ?? 00 40 50 E2 0B 00 00 BA 08 00 8D E2 ?? ?? ?? ?? 04 00 A0 E1 44 10 9F E5 ?? ?? ?? ?? 00 50 50 E2 05 00 A0 11 08 00 00 0A 01 DA 8D E2 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? 00 00 A0 E3 01 DA 8D E2 0C D0 8D E2 30 40 BD E8 ?? ?? ?? ?? 04 00 A0 E1 ?? ?? ?? ?? 05 00 A0 E1 F2 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_376_0_0 {
	meta:
		name = "__fcntl_nocancel"
		size = 92
		refs = "0048 __aeabi_read_tp 0058 __libc_errno"
	strings:
		$1 = { 0E 00 2D E9 80 40 2D E9 0C D0 4D E2 18 30 8D E2 14 10 8D E2 04 30 8D E5 06 00 91 E8 DD 70 A0 E3 00 00 00 EF 01 0A 70 E3 03 00 00 8A 0C D0 8D E2 80 40 BD E8 0C D0 8D E2 ?? ?? ?? ?? 14 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 F4 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_0_3 {
	meta:
		name = "__fcntl_nocancel"
		size = 92
		refs = "0048 __aeabi_read_tp 0058 errno"
	strings:
		$1 = { 0E 00 2D E9 80 40 2D E9 0C D0 4D E2 18 30 8D E2 14 10 8D E2 04 30 8D E5 06 00 91 E8 DD 70 A0 E3 00 00 00 EF 01 0A 70 E3 03 00 00 8A 0C D0 8D E2 80 40 BD E8 0C D0 8D E2 ?? ?? ?? ?? 14 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 F4 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_376_1_0 {
	meta:
		name = "__libc_fcntl"
		size = 220
		refs = "0064 __libc_enable_asynccancel 008c __libc_disable_asynccancel 00a4 __aeabi_read_tp 00d0 __libc_multiple_threads 00d4 __libc_errno"
	strings:
		$1 = { 0E 00 2D E9 B0 40 2D E9 C0 30 9F E5 00 20 93 E5 14 D0 4D E2 28 30 8D E2 00 00 52 E3 24 10 8D E2 00 40 A0 E1 0C 30 8D E5 06 00 91 E8 08 00 00 1A 04 00 A0 E1 DD 70 A0 E3 00 00 00 EF 01 0A 70 E3 14 00 00 8A 14 D0 8D E2 B0 40 BD E8 0C D0 8D E2 ?? ?? ?? ?? 0E 00 51 E3 07 00 51 13 F3 FF FF 1A 06 00 8D E8 ?? ?? ?? ?? DD 70 A0 E3 00 50 A0 E1 06 00 9D E8 04 00 A0 E1 00 00 00 EF 01 0A 70 E3 00 40 A0 E1 0A 00 00 8A 05 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 EA FF FF EA 34 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 E3 FF FF EA 1C 30 9F E5 00 40 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 40 80 E7 00 40 E0 E3 ED FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_1_3 {
	meta:
		name = "__libc_fcntl"
		size = 220
		refs = "0064 __pthread_enable_asynccancel 008c __pthread_disable_asynccancel 00a4 __aeabi_read_tp 00d0 __pthread_multiple_threads 00d4 errno"
	strings:
		$1 = { 0E 00 2D E9 B0 40 2D E9 C0 30 9F E5 00 20 93 E5 14 D0 4D E2 28 30 8D E2 00 00 52 E3 24 10 8D E2 00 40 A0 E1 0C 30 8D E5 06 00 91 E8 08 00 00 1A 04 00 A0 E1 DD 70 A0 E3 00 00 00 EF 01 0A 70 E3 14 00 00 8A 14 D0 8D E2 B0 40 BD E8 0C D0 8D E2 ?? ?? ?? ?? 0E 00 51 E3 07 00 51 13 F3 FF FF 1A 06 00 8D E8 ?? ?? ?? ?? DD 70 A0 E3 00 50 A0 E1 06 00 9D E8 04 00 A0 E1 00 00 00 EF 01 0A 70 E3 00 40 A0 E1 0A 00 00 8A 05 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 EA FF FF EA 34 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 E3 FF FF EA 1C 30 9F E5 00 40 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 40 80 E7 00 40 E0 E3 ED FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_377_0_0 {
	meta:
		name = "__aeabi_errno_addr"
		size = 32
		refs = "0008 __aeabi_read_tp 001c __libc_errno"
		altNames = "__errno_location"
	strings:
		$1 = { 04 E0 2D E5 10 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 00 80 E0 04 E0 9D E4 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_945_0_0 {
	meta:
		name = "__ctype_b_loc"
		size = 32
		refs = "0008 __aeabi_read_tp 001c .LANCHOR0"
	strings:
		$1 = { 04 E0 2D E5 10 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 00 80 E0 04 E0 9D E4 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_119_0_3 {
	meta:
		name = "__errno_location"
		size = 32
		refs = "0008 __aeabi_read_tp 001c errno"
	strings:
		$1 = { 04 E0 2D E5 10 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 00 80 E0 04 E0 9D E4 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_933_0_0 {
	meta:
		name = "__h_errno_location"
		size = 32
		refs = "0008 __aeabi_read_tp 001c __libc_h_errno"
	strings:
		$1 = { 04 E0 2D E5 10 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 00 80 E0 04 E0 9D E4 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_150_0_3 {
	meta:
		name = "__h_errno_location"
		size = 32
		refs = "0008 __aeabi_read_tp 001c h_errno"
	strings:
		$1 = { 04 E0 2D E5 10 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 00 80 E0 04 E0 9D E4 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_378_0_0 {
	meta:
		name = "xdr_pmap"
		size = 92
		refs = "000c xdr_u_long"
	strings:
		$1 = { 38 40 2D E9 00 50 A0 E1 01 40 A0 E1 ?? ?? ?? ?? 00 00 50 E3 02 00 00 1A 00 00 A0 E3 38 40 BD E8 ?? ?? ?? ?? 05 00 A0 E1 04 10 84 E2 ?? ?? ?? ?? 00 00 50 E3 F7 FF FF 0A 05 00 A0 E1 08 10 84 E2 ?? ?? ?? ?? 00 00 50 E3 F2 FF FF 0A 05 00 A0 E1 0C 10 84 E2 ?? ?? ?? ?? EF FF FF EA }
	condition:
		$1
}

rule file_379_0_0 {
	meta:
		name = "do_encoding"
		size = 48
	strings:
		$1 = { 24 30 90 E5 34 20 93 E5 00 00 52 E3 05 00 00 1A 24 00 83 E2 09 00 90 E8 03 00 50 E1 03 00 A0 01 00 00 A0 13 ?? ?? ?? ?? 00 00 E0 E3 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_379_3_0 {
	meta:
		name = "do_in"
		size = 224
		refs = "0040 _dl_mcount_wrapper_check"
	strings:
		$1 = { F0 47 2D E9 18 D0 4D E2 3C E0 9D E5 40 C0 9D E5 3C 10 80 E5 28 E0 80 E5 2C C0 80 E5 24 70 90 E5 14 60 97 E5 18 50 8D E2 00 40 A0 E1 04 20 25 E5 06 00 A0 E1 03 A0 A0 E1 38 90 9D E5 44 80 9D E5 ?? ?? ?? ?? 00 C0 A0 E3 10 E0 8D E2 0A 30 A0 E1 07 00 A0 E1 05 20 A0 E1 28 10 84 E2 00 C0 8D E5 08 C0 8D E5 0C C0 8D E5 04 E0 8D E5 0F E0 A0 E1 ?? ?? ?? ?? 14 30 9D E5 00 30 89 E5 28 30 94 E5 00 30 88 E5 07 00 50 E3 00 F1 9F 97 0F 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 A0 E3 18 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 00 00 A0 E3 18 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 02 00 A0 E3 18 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_379_4_0 {
	meta:
		name = "do_unshift"
		size = 192
		refs = "0028 _dl_mcount_wrapper_check"
	strings:
		$1 = { F0 40 2D E9 54 20 80 E5 58 30 80 E5 68 10 80 E5 50 60 90 E5 14 50 96 E5 1C D0 4D E2 00 40 A0 E1 05 00 A0 E1 30 70 9D E5 ?? ?? ?? ?? 00 30 A0 E3 14 E0 8D E2 01 C0 A0 E3 03 20 A0 E1 00 30 8D E5 0C 30 8D E5 06 00 A0 E1 54 10 84 E2 04 E0 8D E5 08 C0 8D E5 0F E0 A0 E1 ?? ?? ?? ?? 54 30 94 E5 00 30 87 E5 07 00 50 E3 00 F1 9F 97 0F 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 A0 E3 1C D0 8D E2 F0 40 BD E8 ?? ?? ?? ?? 00 00 A0 E3 1C D0 8D E2 F0 40 BD E8 ?? ?? ?? ?? 02 00 A0 E3 1C D0 8D E2 F0 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_379_5_0 {
	meta:
		name = "do_out"
		size = 224
		refs = "0040 _dl_mcount_wrapper_check"
	strings:
		$1 = { F0 47 2D E9 18 D0 4D E2 3C E0 9D E5 40 C0 9D E5 68 10 80 E5 54 E0 80 E5 58 C0 80 E5 50 70 90 E5 14 60 97 E5 18 50 8D E2 00 40 A0 E1 04 20 25 E5 06 00 A0 E1 03 A0 A0 E1 38 90 9D E5 44 80 9D E5 ?? ?? ?? ?? 00 C0 A0 E3 10 E0 8D E2 0A 30 A0 E1 07 00 A0 E1 05 20 A0 E1 54 10 84 E2 00 C0 8D E5 08 C0 8D E5 0C C0 8D E5 04 E0 8D E5 0F E0 A0 E1 ?? ?? ?? ?? 14 30 9D E5 00 30 89 E5 54 30 94 E5 00 30 88 E5 07 00 50 E3 00 F1 9F 97 0F 00 00 EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 A0 E3 18 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 00 00 A0 E3 18 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? 02 00 A0 E3 18 D0 8D E2 F0 47 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_379_6_0 {
	meta:
		name = "do_length"
		size = 152
		refs = "0054 _dl_mcount_wrapper_check"
	strings:
		$1 = { F0 4B 2D E9 1C B0 8D E2 18 D0 4D E2 04 E0 9B E5 0E E1 A0 E1 0A C0 8E E2 07 C0 CC E3 0C D0 4D E0 10 C0 8D E2 0E E0 8C E0 24 80 90 E5 3C 10 80 E5 2C E0 80 E5 28 C0 80 E5 14 70 98 E5 1C 50 4B E2 00 40 A0 E1 08 20 25 E5 07 00 A0 E1 02 60 A0 E1 03 90 A0 E1 ?? ?? ?? ?? 00 C0 A0 E3 20 E0 4B E2 08 00 A0 E1 05 20 A0 E1 28 10 84 E2 09 30 A0 E1 00 50 8D E8 08 C0 8D E5 0C C0 8D E5 0F E0 A0 E1 ?? ?? ?? ?? 24 00 1B E5 00 00 66 E0 1C D0 4B E2 F0 4B BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_379_7_0 {
	meta:
		name = "_IO_fwide"
		size = 488
		refs = "008c __wcsmbs_clone_conv 00b4 memset 0190 __assert_fail 01bc do_unshift 01c0 do_in 01c4 do_encoding 01c8 do_always_noconv 01cc do_length 01d0 do_max_length 01d4 do_out"
	strings:
		$1 = { F0 41 2D E9 00 00 51 E3 18 D0 4D E2 00 60 A0 E1 6C 40 90 E5 63 00 00 BA 00 00 54 E3 53 00 00 1A 00 00 51 E3 51 00 00 0A 5C 50 90 E5 3C 80 85 E2 58 80 80 E5 2C 40 C5 E5 2D 40 C5 E5 2E 40 C5 E5 2F 40 C5 E5 30 40 C5 E5 31 40 C5 E5 32 40 C5 E5 33 40 C5 E5 04 10 95 E5 5C 30 90 E5 0C 20 95 E5 00 10 85 E5 10 20 85 E5 08 00 8D E2 34 40 C3 E5 35 40 C3 E5 36 40 C3 E5 37 40 C3 E5 38 40 C3 E5 39 40 C3 E5 3A 40 C3 E5 3B 40 C3 E5 ?? ?? ?? ?? 0C 30 9D E5 01 00 53 E3 38 00 00 1A 14 70 9D E5 01 00 57 E3 3A 00 00 1A 04 10 A0 E1 08 00 A0 E1 78 20 A0 E3 ?? ?? ?? ?? 08 30 9D E5 5C 70 85 E5 60 30 85 E5 74 70 85 E5 6C 70 85 E5 5C 20 96 E5 10 30 9D E5 2C 20 82 E2 8C 30 85 E5 78 20 85 E5 88 70 85 E5 A0 70 85 E5 98 70 85 E5 5C 20 96 E5 C0 30 9F E5 2C 20 82 E2 A4 20 85 E5 B0 30 85 E5 5C 30 96 E5 B0 40 9F E5 B8 10 93 E5 AC E0 9F E5 AC C0 9F E5 AC 00 9F E5 AC 20 9F E5 AC 30 9F E5 AC 80 9F E5 44 40 85 E5 50 00 85 E5 54 20 85 E5 58 30 85 E5 40 80 85 E5 48 E0 85 E5 4C C0 85 E5 06 00 A0 E1 98 10 86 E5 00 20 A0 E3 00 70 8D E5 00 30 A0 E3 40 C0 91 E5 0F E0 A0 E1 ?? ?? ?? ?? 50 00 86 E5 54 10 86 E5 07 40 A0 E1 6C 40 86 E5 04 00 A0 E1 18 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 50 00 9F E5 50 10 9F E5 8A 20 A0 E3 4C 30 9F E5 ?? ?? ?? ?? 48 00 9F E5 3C 10 9F E5 8B 20 A0 E3 38 30 9F E5 ?? ?? ?? ?? 00 00 54 E3 00 40 E0 03 ED FF FF 0A ED FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_381_0_0 {
	meta:
		name = "__libc_waitpid"
		size = 184
		refs = "0038 __libc_enable_asynccancel 0068 __libc_disable_asynccancel 0080 __aeabi_read_tp 00ac __libc_multiple_threads 00b0 __libc_errno"
	strings:
		$1 = { A4 30 9F E5 00 30 93 E5 00 00 53 E3 F0 41 2D E9 00 60 A0 E1 01 50 A0 E1 02 40 A0 E1 05 00 00 1A 72 70 A0 E3 00 00 00 EF 01 0A 70 E3 10 00 00 8A F0 41 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 72 70 A0 E3 00 80 A0 E1 05 10 A0 E1 06 00 A0 E1 04 20 A0 E1 00 30 A0 E3 00 00 00 EF 01 0A 70 E3 00 40 A0 E1 0A 00 00 8A 08 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 EE FF FF EA 34 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 E7 FF FF EA 1C 30 9F E5 00 40 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 40 80 E7 00 40 E0 E3 ED FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_0_3 {
	meta:
		name = "__libc_waitpid"
		size = 184
		refs = "0038 __pthread_enable_asynccancel 0068 __pthread_disable_asynccancel 0080 __aeabi_read_tp 00ac __pthread_multiple_threads 00b0 errno"
	strings:
		$1 = { A4 30 9F E5 00 30 93 E5 00 00 53 E3 F0 41 2D E9 00 60 A0 E1 01 50 A0 E1 02 40 A0 E1 05 00 00 1A 72 70 A0 E3 00 00 00 EF 01 0A 70 E3 10 00 00 8A F0 41 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 72 70 A0 E3 00 80 A0 E1 05 10 A0 E1 06 00 A0 E1 04 20 A0 E1 00 30 A0 E3 00 00 00 EF 01 0A 70 E3 00 40 A0 E1 0A 00 00 8A 08 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 EE FF FF EA 34 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 E7 FF FF EA 1C 30 9F E5 00 40 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 40 80 E7 00 40 E0 E3 ED FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_382_0_0 {
	meta:
		name = "posix_spawn_file_actions_adddup2"
		size = 140
		refs = "0014 __sysconf 0074 __posix_spawn_file_actions_realloc"
	strings:
		$1 = { 70 40 2D E9 01 40 A0 E1 02 50 A0 E1 00 60 A0 E1 04 00 A0 E3 ?? ?? ?? ?? 05 30 94 E1 02 00 00 5A 09 00 A0 E3 70 40 BD E8 ?? ?? ?? ?? 00 00 55 E1 00 00 54 B1 F9 FF FF AA 0C 00 96 E8 02 00 53 E1 0A 00 00 0A 08 00 96 E5 03 11 83 E0 01 11 A0 E1 01 C0 83 E2 01 20 80 E0 01 30 A0 E3 01 30 80 E7 30 00 82 E9 00 00 A0 E3 04 C0 86 E5 EC FF FF EA 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0C 00 A0 13 E7 FF FF 1A 04 30 96 E5 ED FF FF EA }
	condition:
		$1
}

rule file_383_0_0 {
	meta:
		name = "__aeabi_memset"
		size = 28
		refs = "0010 memset"
	strings:
		$1 = { 08 40 2D E9 01 30 A0 E1 02 10 A0 E1 03 20 A0 E1 ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_384_0_0 {
	meta:
		name = "wcschr"
		size = 40
	strings:
		$1 = { 00 20 A0 E1 04 30 90 E4 01 00 53 E1 03 00 00 0A 00 00 53 E3 F9 FF FF 1A 03 00 A0 E1 ?? ?? ?? ?? 02 00 A0 E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_385_0_0 {
	meta:
		name = "clnt_create"
		size = 664
		refs = "0024 strcmp 003c memset 0050 strcpy 0074 clntunix_create 00a0 __aeabi_read_tp 00dc __gethostbyname_r 0100 __rpc_thread_createerr 0148 memcpy 0190 __getprotobyname_r 0248 clntudp_create 0268 clnttcp_create 0290 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 20 B0 8D E2 BC D0 4D E2 00 50 A0 E1 01 A0 A0 E1 03 00 A0 E1 6C 12 9F E5 03 90 A0 E1 D0 20 0B E5 ?? ?? ?? ?? 00 40 50 E2 14 00 00 1A 6E 20 A0 E3 04 10 A0 E1 94 00 4B E2 ?? ?? ?? ?? 01 30 A0 E3 05 10 A0 E1 92 00 4B E2 B4 39 4B E1 ?? ?? ?? ?? 00 20 E0 E3 24 30 4B E2 9C 20 23 E5 94 00 4B E2 D0 20 1B E5 0A 10 A0 E1 00 40 8D E5 04 40 8D E5 ?? ?? ?? ?? 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 01 2B 4D E2 08 D0 42 E2 01 4B A0 E3 C8 70 4B E2 BC 60 4B E2 F0 81 9F E5 09 00 00 EA ?? ?? ?? ?? 08 30 9F E7 03 30 90 E7 22 00 53 E3 12 00 00 1A 84 40 A0 E1 0E 30 84 E2 07 30 C3 E3 03 D0 4D E0 08 20 8D E2 00 70 8D E5 04 60 8D E5 05 00 A0 E1 94 10 4B E2 04 30 A0 E1 ?? ?? ?? ?? 00 C0 50 E2 02 00 00 1A C8 30 1B E5 00 00 53 E3 09 00 00 1A BC 30 1B E5 01 00 73 E3 E7 FF FF 0A ?? ?? ?? ?? 0D 30 A0 E3 00 30 80 E5 00 00 A0 E3 20 D0 4B E2 F0 4F BD E8 ?? ?? ?? ?? 08 E0 93 E5 02 00 5E E3 2B 00 00 1A 98 C0 0B E5 9C C0 0B E5 10 10 93 E5 0C 20 93 E5 00 10 91 E5 A0 00 4B E2 B4 EA 4B E1 B2 CA 4B E1 ?? ?? ?? ?? 01 3B 4D E2 07 20 83 E2 08 D0 43 E2 07 20 C2 E3 01 4B A0 E3 C4 50 4B E2 28 61 9F E5 04 00 00 EA 84 40 A0 E1 0E 30 84 E2 07 30 C3 E3 03 D0 4D E0 08 20 8D E2 00 50 8D E5 09 00 A0 E1 B0 10 4B E2 04 30 A0 E1 ?? ?? ?? ?? 00 70 50 E2 02 00 00 1A C4 30 1B E5 00 00 53 E3 15 00 00 1A ?? ?? ?? ?? 06 30 9F E7 03 30 90 E7 22 00 53 E3 EB FF FF 0A ?? ?? ?? ?? 11 20 A0 E3 60 30 A0 E3 00 20 80 E5 08 30 80 E5 00 00 A0 E3 A7 FF FF EA D4 C0 0B E5 ?? ?? ?? ?? D4 C0 1B E5 00 30 A0 E1 0C 10 A0 E3 61 20 A0 E3 0C 00 A0 E1 00 10 83 E5 08 20 83 E5 9D FF FF EA 08 30 93 E5 00 20 E0 E3 06 00 53 E3 C0 20 0B E5 0E 00 00 0A 11 00 53 E3 14 00 00 1A C0 30 4B E2 05 20 A0 E3 B8 20 0B E5 B4 70 0B E5 04 30 8D E5 B4 30 1B E5 00 30 8D E5 0A 10 A0 E1 D0 20 1B E5 B8 30 1B E5 A4 00 4B E2 ?? ?? ?? ?? 89 FF FF EA 00 70 8D E5 04 70 8D E5 0A 10 A0 E1 D0 20 1B E5 A4 00 4B E2 C0 30 4B E2 ?? ?? ?? ?? 81 FF FF EA ?? ?? ?? ?? 0C 20 A0 E3 60 30 A0 E3 00 20 80 E5 08 30 80 E5 07 00 A0 E1 7A FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_386_0_0 {
	meta:
		name = "__statvfs_getflags"
		size = 1628
		refs = "0130 __setmntent 01f8 __getmntent_r 0214 strcmp 0284 __xstat64 02f4 strchr 03dc __endmntent 04bc rewind 056c __assert_fail"
	strings:
		$1 = { F0 4F 2D E9 00 B0 52 E2 12 DD 4D E2 04 D0 4D E2 00 80 A0 E1 48 00 00 0A 50 35 9F E5 03 00 51 E1 49 01 00 0A 11 00 00 DA 44 35 9F E5 03 00 51 E1 41 01 00 0A 1F 00 00 CA 38 35 9F E5 03 00 51 E1 F7 00 00 0A 41 00 00 CA 2C 35 9F E5 03 00 51 E1 E7 00 00 0A 02 30 83 E2 03 00 51 E1 2A 01 00 1A 00 60 A0 E3 06 70 A0 E1 10 A5 9F E5 54 00 00 EA 0C 35 9F E5 03 00 51 E1 2B 01 00 0A 1B 00 00 DA 00 35 9F E5 03 00 51 E1 F1 00 00 0A 43 00 00 CA F4 34 9F E5 03 00 51 E1 E5 00 00 0A EC 34 9F E5 03 00 51 E1 18 01 00 1A 00 60 A0 E3 06 70 A0 E1 DC A4 9F E5 42 00 00 EA D8 34 9F E5 03 00 51 E1 E7 00 00 0A 2B 00 00 CA CC 34 9F E5 03 00 51 E1 E7 00 00 0A C4 34 9F E5 03 00 51 E1 0A 01 00 1A 00 60 A0 E3 06 70 A0 E1 B4 A4 9F E5 34 00 00 EA B0 34 9F E5 03 00 51 E1 07 01 00 0A FC 00 00 DA A4 34 9F E5 03 00 51 E1 C1 00 00 0A 9C 34 9F E5 03 00 51 E1 FC 00 00 1A 00 60 A0 E3 06 70 A0 E1 8C A4 9F E5 26 00 00 EA 88 04 9F E5 88 14 9F E5 ?? ?? ?? ?? 00 90 50 E2 26 00 00 1A 00 00 A0 E3 12 DD 8D E2 04 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 68 34 9F E5 03 00 51 E1 A9 00 00 0A 60 34 9F E5 03 00 51 E1 E8 00 00 1A 00 60 A0 E3 06 70 A0 E1 50 A4 9F E5 12 00 00 EA 4C 34 9F E5 03 00 51 E1 AF 00 00 0A 44 34 9F E5 03 00 51 E1 DE 00 00 1A 00 60 A0 E3 06 70 A0 E1 34 A4 9F E5 08 00 00 EA 30 34 9F E5 03 00 51 E1 B5 00 00 0A 28 34 9F E5 03 00 51 E1 D4 00 00 1A 00 60 A0 E3 1C A4 9F E5 06 70 A0 E1 18 04 9F E5 EC 13 9F E5 ?? ?? ?? ?? 00 90 50 E2 D3 FF FF 0A 00 30 99 E5 02 39 83 E3 00 30 89 E5 18 50 8D E2 09 00 A0 E1 0D 10 A0 E1 80 20 8D E2 01 3B A0 E3 ?? ?? ?? ?? 00 00 50 E3 A3 00 00 0A 00 00 58 E3 04 00 00 0A 08 00 A0 E1 04 10 9D E5 ?? ?? ?? ?? 00 00 50 E3 F1 FF FF 1A 00 00 5A E3 13 00 00 0A 08 40 9D E5 0A 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 0D 00 00 0A 00 00 57 E3 04 00 00 0A 07 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 06 00 00 0A 00 00 56 E3 E0 FF FF 0A 04 10 A0 E1 06 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 DB FF FF 1A 03 00 A0 E3 04 10 9D E5 05 20 A0 E1 ?? ?? ?? ?? 00 00 50 E3 D5 FF FF BA 03 00 9B E8 18 30 8D E2 0C 00 93 E8 03 00 51 E1 02 00 50 01 CF FF FF 1A 0C 40 9D E5 00 00 54 E3 04 60 A0 01 47 00 00 0A 00 60 A0 E3 06 70 A0 E1 09 00 00 EA 01 30 D4 E5 6F 00 53 E3 10 00 00 1A 02 30 D4 E5 00 00 53 E3 0D 00 00 1A 01 60 86 E3 00 00 55 E3 3B 00 00 0A 05 40 A0 E1 04 00 A0 E1 2C 10 A0 E3 ?? ?? ?? ?? 00 00 50 E3 00 50 A0 01 00 70 C0 15 01 50 80 12 00 30 D4 E5 72 00 53 E3 EB FF FF 0A 04 00 A0 E1 C8 12 9F E5 ?? ?? ?? ?? 00 00 50 E3 02 60 86 03 EC FF FF 0A 04 00 A0 E1 B4 12 9F E5 ?? ?? ?? ?? 00 00 50 E3 08 60 86 03 E6 FF FF 0A 04 00 A0 E1 A0 12 9F E5 ?? ?? ?? ?? 00 00 50 E3 04 60 86 03 E0 FF FF 0A 04 00 A0 E1 8C 12 9F E5 ?? ?? ?? ?? 00 00 50 E3 10 60 86 03 DA FF FF 0A 04 00 A0 E1 78 12 9F E5 ?? ?? ?? ?? 00 00 50 E3 40 60 86 03 D4 FF FF 0A 04 00 A0 E1 64 12 9F E5 ?? ?? ?? ?? 00 00 50 E3 01 6B 86 03 CE FF FF 0A 04 00 A0 E1 50 12 9F E5 ?? ?? ?? ?? 00 00 50 E3 02 6B 86 03 C8 FF FF 0A 04 00 A0 E1 3C 12 9F E5 ?? ?? ?? ?? 00 00 50 E3 01 6A 86 03 00 00 55 E3 C3 FF FF 1A 09 00 A0 E1 ?? ?? ?? ?? 06 00 A0 E1 12 DD 8D E2 04 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 60 A0 E3 06 70 A0 E1 04 A2 9F E5 6F FF FF EA 00 60 A0 E3 06 70 A0 E1 F8 A1 9F E5 6B FF FF EA 00 60 A0 E3 06 70 A0 E1 EC A1 9F E5 67 FF FF EA E8 61 9F E5 E8 71 9F E5 E8 A1 9F E5 63 FF FF EA 00 60 A0 E3 06 70 A0 E1 DC A1 9F E5 5F FF FF EA 00 60 A0 E3 06 70 A0 E1 D0 A1 9F E5 5B FF FF EA 00 60 A0 E3 06 70 A0 E1 C4 A1 9F E5 57 FF FF EA 00 60 A0 E3 06 70 A0 E1 B8 A1 9F E5 53 FF FF EA 00 60 A0 E3 06 70 A0 E1 AC A1 9F E5 4F FF FF EA 00 60 A0 E3 06 70 A0 E1 A0 A1 9F E5 4B FF FF EA 00 80 98 E2 01 80 A0 13 00 00 5A E3 08 30 A0 01 01 30 88 13 00 00 53 E3 0B 00 00 0A 00 00 58 E3 03 00 00 0A 09 00 A0 E1 ?? ?? ?? ?? 00 80 A0 E3 47 FF FF EA 00 00 5A E3 22 00 00 0A 08 60 A0 E1 08 70 A0 E1 08 A0 A0 E1 F5 FF FF EA 03 60 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 06 00 A0 E1 BB FF FF EA 3C 31 9F E5 03 00 51 E1 00 60 A0 03 06 70 A0 01 30 A1 9F 05 2D FF FF 0A 00 60 A0 E3 06 70 A0 E1 06 A0 A0 E1 29 FF FF EA 00 60 A0 E3 06 70 A0 E1 14 A1 9F E5 25 FF FF EA 00 60 A0 E3 06 70 A0 E1 08 A1 9F E5 21 FF FF EA 00 60 A0 E3 06 70 A0 E1 FC A0 9F E5 1D FF FF EA 00 60 A0 E3 06 70 A0 E1 F0 A0 9F E5 19 FF FF EA EC 00 9F E5 EC 10 9F E5 CD 20 A0 E3 E8 30 9F E5 ?? ?? ?? ?? 60 96 00 00 D0 0B D0 0B 53 EF 00 00 A0 9F 00 00 ?? ?? ?? ?? 49 E8 95 F9 D1 1C 00 00 87 01 00 00 73 13 00 00 ?? ?? ?? ?? 4E 54 46 53 4A 46 53 31 73 49 65 52 ?? ?? ?? ?? 68 81 7E C9 E4 81 5E DE 10 20 F5 F2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EB E0 27 00 94 19 02 01 ?? ?? ?? ?? 42 53 46 58 72 65 65 62 ?? ?? ?? ?? 44 4D 00 00 69 69 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 3E 68 23 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_386_1_0 {
	meta:
		name = "__internal_statvfs"
		size = 184
		refs = "0074 memset 00a8 __statvfs_getflags"
	strings:
		$1 = { F8 4F 2D E9 28 B0 92 E5 02 50 A0 E1 01 40 A0 E1 14 60 82 E2 04 10 95 E5 08 A0 92 E5 0C 90 92 E5 10 80 92 E5 40 40 96 E8 1C C0 92 E5 00 00 5B E3 24 20 92 E5 00 70 A0 E1 04 00 95 E5 01 B0 A0 01 00 10 A0 E3 01 08 84 E8 14 60 84 E5 2C 20 84 E5 24 10 84 E5 08 A0 84 E5 0C 90 84 E5 10 80 84 E5 18 E0 84 E5 20 C0 84 E5 30 00 84 E2 18 20 A0 E3 03 60 A0 E1 ?? ?? ?? ?? 2C 10 95 E5 18 00 94 E5 20 00 11 E3 20 10 21 12 1C 00 84 E5 28 10 84 15 01 00 00 0A F8 4F BD E8 ?? ?? ?? ?? 07 00 A0 E1 00 10 95 E5 06 20 A0 E1 ?? ?? ?? ?? 28 00 84 E5 F8 4F BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_387_0_0 {
	meta:
		name = "ftok"
		size = 68
		refs = "001c __xstat64"
	strings:
		$1 = { 10 40 2D E9 00 30 A0 E1 68 D0 4D E2 01 40 A0 E1 0D 20 A0 E1 03 10 A0 E1 03 00 A0 E3 ?? ?? ?? ?? 00 00 50 E3 00 00 DD A5 B0 36 DD A1 00 08 83 A1 04 0C 80 A1 00 00 E0 B3 68 D0 8D E2 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_388_0_0 {
	meta:
		name = "__funlockfile"
		size = 144
		refs = "006c __aeabi_read_tp"
	strings:
		$1 = { F0 40 2D E9 48 50 90 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 11 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 01 00 00 CA F0 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF F4 FF FF EA }
	condition:
		$1
}

rule file_389_0_0 {
	meta:
		name = "call_dl_lookup"
		size = 68
		refs = "0030 _dl_lookup_symbol_x"
	strings:
		$1 = { 30 40 2D E9 00 40 A0 E1 08 50 84 E2 00 10 90 E5 20 40 95 E8 14 D0 4D E2 00 C0 A0 E3 CC 31 91 E5 14 20 94 E5 04 00 90 E5 20 50 8D E8 0C C0 8D E5 ?? ?? ?? ?? 00 00 84 E5 14 D0 8D E2 30 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_389_1_0 {
	meta:
		name = "do_sym"
		size = 736
		refs = "0028 _dl_find_dso_for_object 0070 _dl_lookup_symbol_x 00fc __aeabi_read_tp 01a4 _dl_catch_error 0228 strlen 0244 memcpy 0284 free 0298 _dl_signal_error 02d0 _dl_ns 02d4 _dl_hwcap 02d8 call_dl_lookup"
	strings:
		$1 = { F0 49 2D E9 02 60 A0 E1 18 B0 8D E2 3C D0 4D E2 00 40 A0 E1 00 20 A0 E3 06 00 A0 E1 01 70 A0 E1 03 80 A0 E1 40 20 0B E5 ?? ?? ?? ?? 00 10 50 E2 98 32 9F 05 00 10 93 05 00 00 54 E3 2E 00 00 0A 01 00 74 E3 19 00 00 0A 04 00 9B E5 00 20 A0 E3 08 00 8D E5 04 20 8D E5 0C 20 8D E5 04 10 A0 E1 00 80 8D E5 07 00 A0 E1 1D 3E 84 E2 40 20 4B E2 ?? ?? ?? ?? 40 30 1B E5 00 00 53 E3 07 00 00 0A 0C 20 D3 E5 00 00 50 E3 00 00 90 15 04 30 93 E5 0F 20 02 E2 0A 00 52 E3 03 30 80 E0 26 00 00 0A 03 00 A0 E1 18 D0 4B E2 F0 49 BD E8 ?? ?? ?? ?? 18 32 9F E5 00 30 93 E5 03 00 51 E1 76 00 00 0A 01 30 A0 E1 00 00 00 EA 02 30 A0 E1 6C 21 93 E5 00 00 52 E3 FB FF FF 1A 04 20 8D E5 08 20 8D E5 00 80 8D E5 0C 10 8D E5 07 00 A0 E1 1D 3E 83 E2 40 20 4B E2 ?? ?? ?? ?? DD FF FF EA ?? ?? ?? ?? C0 34 10 E5 00 00 53 E3 00 60 A0 E1 0F 00 00 1A 04 00 9B E5 01 20 80 E3 CC 31 91 E5 07 00 A0 E1 08 20 8D E5 00 80 8D E5 04 40 8D E5 0C 40 8D E5 40 20 4B E2 ?? ?? ?? ?? CD FF FF EA 90 21 9F E5 00 00 92 E5 0F E0 A0 E1 ?? ?? ?? ?? D4 FF FF EA 04 30 9B E5 40 20 4B E2 05 00 83 E3 01 30 A0 E3 30 70 0B E5 34 10 0B E5 2C 80 0B E5 28 00 0B E5 20 20 0B E5 BC 34 06 E5 0F CA E0 E3 0F E0 A0 E1 5F F0 4C E2 34 30 4B E2 00 30 8D E5 00 C0 A0 E3 3C 00 4B E2 38 10 4B E2 41 20 4B E2 34 31 9F E5 38 C0 0B E5 ?? ?? ?? ?? 13 7D 46 E2 00 80 A0 E1 04 70 87 E2 BC 54 16 E5 00 10 A0 E3 05 40 A0 E1 07 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 55 E1 F0 FF FF 1A 02 00 55 E3 06 00 00 1A B8 14 16 E5 07 00 A0 E1 01 10 81 E3 01 20 A0 E3 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 38 40 1B E5 00 00 54 E3 34 00 1B 05 93 FF FF 0A 04 00 A0 E1 ?? ?? ?? ?? 0F 30 80 E2 07 30 C3 E3 03 D0 4D E0 01 20 80 E2 04 10 A0 E1 10 00 8D E2 ?? ?? ?? ?? 3C 50 1B E5 00 60 A0 E1 05 00 A0 E1 ?? ?? ?? ?? 0F 30 80 E2 07 30 C3 E3 03 D0 4D E0 05 10 A0 E1 01 20 80 E2 10 00 8D E2 ?? ?? ?? ?? 41 30 5B E5 00 00 53 E3 00 50 A0 E1 04 00 A0 11 ?? ?? ?? ?? 08 00 A0 E1 05 10 A0 E1 06 30 A0 E1 00 20 A0 E3 ?? ?? ?? ?? 00 00 51 E3 05 00 00 0A AC 31 91 E5 03 00 56 E1 02 00 00 3A B0 31 91 E5 03 00 56 E1 80 FF FF 3A 00 00 A0 E3 00 10 A0 E1 00 20 A0 E1 0C 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_389_2_0 {
	meta:
		name = "_dl_vsym"
		size = 180
	strings:
		$1 = { 10 40 2D E9 00 C0 D2 E5 18 D0 4D E2 01 E0 A0 E3 00 00 5C E3 08 20 8D E5 10 E0 8D E5 1A 00 00 0A 01 E0 D2 E5 00 00 5E E3 17 00 00 0A 02 40 D2 E5 00 00 54 E3 0C C2 8E E0 13 00 00 0A 03 E0 D2 E5 00 00 5E E3 0C C2 84 E0 0F 00 00 0A 04 40 D2 E5 00 00 54 E3 0C C2 8E E0 0B 00 00 0A 05 E0 D2 E5 00 00 5E E3 0C C2 84 E0 05 20 82 E2 05 00 00 0A 0C C2 8E E0 01 E0 F2 E5 0F 42 0C E2 00 00 5E E3 24 CC 2C E0 F9 FF FF 1A 0F C2 CC E3 00 E0 A0 E3 03 20 A0 E1 00 E0 8D E5 08 30 8D E2 0C C0 8D E5 14 E0 8D E5 1D FF FF EB 18 D0 8D E2 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_389_3_0 {
	meta:
		name = "_dl_sym"
		size = 36
	strings:
		$1 = { 04 E0 2D E5 02 30 A0 E3 0C D0 4D E2 00 30 8D E5 00 30 A0 E3 14 FF FF EB 0C D0 8D E2 04 E0 9D E4 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_390_0_0 {
	meta:
		name = "__poll_nocancel"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 A8 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_390_1_0 {
	meta:
		name = "__libc_poll"
		size = 104
		refs = "0028 __syscall_error 0030 __libc_enable_asynccancel 004c __libc_disable_asynccancel"
	strings:
		$1 = { 60 C0 9F E5 0C C0 9F E7 00 00 3C E3 04 70 2D E5 05 00 00 1A A8 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? 0F 40 2D E9 ?? ?? ?? ?? 00 C0 A0 E1 0F 00 BD E8 A8 70 A0 E3 00 00 00 EF 00 70 A0 E1 0C 00 A0 E1 ?? ?? ?? ?? 07 00 A0 E1 04 E0 9D E4 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_391_0_0 {
	meta:
		name = "_openchild"
		size = 328
		refs = "0018 __pipe 0034 __fork 004c __close 0054 __dup 0070 _IO_fflush 0074 _rpc_dtablesize 00ac execlp 00b4 perror 00bc _exit 00c8 _IO_fdopen 0138 stderr"
	strings:
		$1 = { F0 40 2D E9 14 D0 4D E2 00 70 A0 E1 0D 00 A0 E1 01 60 A0 E1 02 50 A0 E1 ?? ?? ?? ?? 00 00 50 E3 42 00 00 BA 08 00 8D E2 ?? ?? ?? ?? 00 00 50 E3 36 00 00 BA ?? ?? ?? ?? 01 00 70 E3 00 40 A0 E1 2E 00 00 0A 00 00 50 E3 1C 00 00 1A ?? ?? ?? ?? 00 00 9D E5 ?? ?? ?? ?? D8 50 9F E5 01 00 A0 E3 ?? ?? ?? ?? 0C 00 9D E5 ?? ?? ?? ?? 00 00 95 E5 ?? ?? ?? ?? ?? ?? ?? ?? 01 40 40 E2 02 00 54 E3 04 00 00 DA 04 00 A0 E1 01 40 44 E2 ?? ?? ?? ?? 02 00 54 E3 FA FF FF 1A 00 00 95 E5 ?? ?? ?? ?? 07 10 A0 E1 00 20 A0 E3 07 00 A0 E1 ?? ?? ?? ?? 84 00 9F E5 ?? ?? ?? ?? 00 00 E0 E3 ?? ?? ?? ?? 78 10 9F E5 04 00 9D E5 ?? ?? ?? ?? 00 00 86 E5 00 00 9D E5 ?? ?? ?? ?? 64 10 9F E5 08 00 9D E5 ?? ?? ?? ?? 00 00 85 E5 0C 00 9D E5 ?? ?? ?? ?? 04 00 A0 E1 14 D0 8D E2 F0 40 BD E8 ?? ?? ?? ?? 08 00 9D E5 ?? ?? ?? ?? 0C 00 9D E5 ?? ?? ?? ?? 00 00 9D E5 ?? ?? ?? ?? 04 00 9D E5 ?? ?? ?? ?? 00 00 E0 E3 14 D0 8D E2 F0 40 BD E8 ?? ?? ?? ?? 00 00 E0 E3 EE FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_392_0_0 {
	meta:
		name = "strrchr"
		size = 80
		refs = "0028 strchr 0044 __rawmemchr"
	strings:
		$1 = { 38 40 2D E9 FF 40 11 E2 00 20 A0 E1 00 50 A0 13 02 00 00 1A 09 00 00 EA 01 20 80 E2 00 50 A0 E1 02 00 A0 E1 04 10 A0 E1 ?? ?? ?? ?? 00 00 50 E3 F8 FF FF 1A 05 00 A0 E1 38 40 BD E8 ?? ?? ?? ?? 04 10 A0 E1 ?? ?? ?? ?? 38 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_393_0_0 {
	meta:
		name = "__gettext_extract_plural"
		size = 280
		refs = "001c strstr 0054 __aeabi_read_tp 00cc strtoul 00f0 __gettextparse 0110 __libc_tsd_CTYPE_B"
	strings:
		$1 = { F0 41 2D E9 00 40 50 E2 10 D0 4D E2 01 70 A0 E1 02 60 A0 E1 1F 00 00 0A E8 10 9F E5 ?? ?? ?? ?? E4 10 9F E5 00 80 A0 E1 04 00 A0 E1 ?? ?? ?? ?? 00 00 58 E3 00 00 50 13 00 10 A0 E1 15 00 00 0A 09 30 D0 E5 00 00 53 E3 09 50 80 E2 11 00 00 0A B8 20 9F E5 ?? ?? ?? ?? 02 20 9F E7 02 20 90 E7 83 00 A0 E1 B0 00 92 E1 02 0A 10 E3 10 00 00 0A 0A C0 81 E2 02 00 00 EA B4 40 92 E1 02 0A 14 E3 0B 00 00 0A 0C 50 A0 E1 01 30 DC E4 00 00 53 E3 83 40 A0 E1 F7 FF FF 1A 74 20 9F E5 02 30 A0 E3 00 20 87 E5 00 30 86 E5 10 D0 8D E2 F0 41 BD E8 ?? ?? ?? ?? 30 30 43 E2 09 00 53 E3 F5 FF FF 8A 05 00 A0 E1 04 10 8D E2 0A 20 A0 E3 ?? ?? ?? ?? 04 30 9D E5 03 00 55 E1 EE FF FF 0A 10 30 8D E2 07 80 88 E2 08 80 23 E5 00 00 86 E5 03 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 E6 FF FF 1A 0C 30 9D E5 00 30 87 E5 E7 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_394_0_0 {
	meta:
		name = "basename"
		size = 36
		refs = "000c strrchr"
	strings:
		$1 = { 10 40 2D E9 2F 10 A0 E3 00 40 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 00 A0 01 01 00 80 12 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_398_0_0 {
	meta:
		name = "__gai_sigqueue"
		size = 136
		refs = "0020 memset 0034 __getuid 0074 __aeabi_read_tp 0084 __libc_errno"
	strings:
		$1 = { F0 40 2D E9 84 D0 4D E2 00 40 A0 E1 01 50 A0 E1 02 60 A0 E1 00 10 A0 E3 80 20 A0 E3 0D 00 A0 E1 ?? ?? ?? ?? 3B 30 E0 E3 0C 60 8D E5 00 40 8D E5 08 30 8D E5 ?? ?? ?? ?? B2 70 A0 E3 10 00 8D E5 14 50 8D E5 04 10 A0 E1 0D 20 A0 E1 0C 00 9D E5 00 00 00 EF 01 0A 70 E3 02 00 00 8A 84 D0 8D E2 F0 40 BD E8 ?? ?? ?? ?? 14 30 9F E5 00 20 60 E2 03 30 9F E7 ?? ?? ?? ?? 03 20 80 E7 00 00 E0 E3 F5 FF FF EA ?? ?? ?? ?? }
	condition:
		$1
}

rule file_399_0_0 {
	meta:
		name = "____wcstoll_l_internal"
		size = 1720
		refs = "0048 __iswspace_l 01e0 __aeabi_read_tp 0238 __towupper_l 0278 __iswalpha_l 0608 __correctly_grouped_prefixwc 069c __strtol_ull_max_tab 06a0 __strtol_ull_rem_tab 06a4 __strtol_ul_max_tab 06a8 __libc_errno"
	strings:
		$1 = { F0 4F 2D E9 44 D0 4D E2 68 70 9D E5 00 40 53 E2 1C 00 8D E5 18 10 8D E5 02 60 A0 E1 04 30 97 E5 67 01 00 1A 04 80 A0 E1 01 00 56 E3 6A 00 00 0A 24 00 56 E3 68 00 00 8A 1C 30 9D E5 00 00 93 E5 07 10 A0 E1 03 90 A0 E1 ?? ?? ?? ?? 00 00 50 E3 04 30 89 E2 F8 FF FF 1A 00 20 99 E5 00 00 52 E3 09 10 A0 E1 18 01 00 0A 2D 00 52 E3 AF 00 00 0A 2B 00 52 E3 04 20 91 05 24 00 8D E5 03 90 A0 01 30 00 52 E3 98 00 00 0A 00 00 56 E3 5C 00 00 0A 0A 00 56 E3 5A 00 00 0A 02 30 46 E2 00 C0 A0 E3 14 C0 8D E5 02 50 A0 E1 0C A0 A0 E1 E8 05 9F E5 E8 15 9F E5 83 01 80 E0 00 18 90 E8 E0 25 9F E5 03 10 D1 E7 00 00 55 E3 28 B0 8D E5 2C C0 8D E5 09 40 A0 E1 38 10 8D E5 03 C1 92 E7 30 01 00 0A 09 00 5A E1 00 20 A0 E3 29 01 00 0A 20 90 8D E5 08 70 8D E5 02 90 A0 E1 0C 70 A0 E1 0B 00 00 EA 14 30 9D E5 08 00 55 E1 00 30 A0 13 01 30 03 02 00 00 53 E3 5D 00 00 0A 04 50 94 E5 00 00 55 E3 04 40 84 E2 0E 00 00 0A 04 00 5A E1 84 00 00 0A 30 00 45 E2 09 00 50 E3 04 B0 A0 E1 EF FF FF 8A 06 00 50 E1 85 00 00 AA 09 00 57 E1 8A 00 00 9A 04 50 94 E5 00 00 55 E3 96 09 29 E0 04 40 84 E2 F0 FF FF 1A 09 20 A0 E1 08 70 9D E5 20 90 9D E5 08 20 8D E5 0C 50 8D E5 00 20 A0 E3 04 00 59 E1 D2 00 00 0A 18 B0 9D E5 00 00 5B E3 00 40 8B 15 00 00 52 E3 47 00 00 1A 24 40 9D E5 00 00 54 E3 2E 01 00 0A 08 10 8D E2 03 00 91 E8 02 01 51 E3 00 00 50 03 23 01 00 8A 08 30 8D E2 0C 00 93 E8 00 20 72 E2 00 30 E3 E2 02 00 A0 E1 03 10 A0 E1 44 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? C4 34 9F E5 ?? ?? ?? ?? 03 30 9F E7 16 20 A0 E3 03 20 80 E7 00 00 A0 E3 00 10 A0 E1 44 D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 00 00 54 E3 02 50 A0 E1 14 40 8D 05 04 A0 A0 01 08 30 A0 03 0A 60 A0 03 A2 FF FF 0A 02 00 58 E1 FF 00 00 0A 00 00 52 E3 F0 00 00 0A 09 60 A0 E1 07 00 00 EA ?? ?? ?? ?? 37 00 40 E2 09 00 50 E3 EB 00 00 CA 04 50 96 E5 00 00 55 E3 04 60 86 E2 F9 00 00 0A 30 30 45 E2 09 00 53 E3 06 A0 A0 E1 F7 FF FF 9A 08 00 55 E1 07 10 A0 E1 05 00 A0 E1 F3 FF FF 0A ?? ?? ?? ?? 00 00 50 E3 07 10 A0 E1 05 00 A0 E1 EA FF FF 1A D9 00 00 EA 08 10 9D E5 05 00 A0 E1 ?? ?? ?? ?? 00 30 50 E2 08 10 9D E5 05 00 A0 E1 AE 00 00 0A ?? ?? ?? ?? 37 00 40 E2 A1 FF FF EA EC 33 9F E5 24 40 9D E5 ?? ?? ?? ?? 03 30 9F E7 00 00 54 E3 22 20 A0 E3 03 20 80 E7 02 11 E0 03 00 00 E0 03 C5 FF FF 0A 00 00 A0 E3 02 11 A0 E3 C2 FF FF EA 10 C0 D6 E3 66 FF FF 1A 04 00 99 E5 07 10 A0 E1 ?? ?? ?? ?? 58 00 50 E3 08 90 89 02 0E 30 A0 03 10 60 A0 03 04 00 00 0A 00 00 56 E3 00 20 99 15 5B FF FF 1A 06 30 A0 E3 08 60 A0 E3 00 20 99 E5 5A FF FF EA 01 B0 A0 E3 03 90 A0 E1 04 20 91 E5 24 B0 8D E5 4E FF FF EA 09 20 A0 E1 00 C0 A0 E3 08 70 9D E5 20 90 9D E5 08 20 8D E5 0C C0 8D E5 85 FF FF EA 09 20 A0 E1 00 00 A0 E3 08 70 9D E5 20 90 9D E5 08 20 8D E5 0C 00 8D E5 7E FF FF EA 09 20 A0 E1 02 30 A0 E1 00 40 A0 E3 08 70 9D E5 20 90 9D E5 08 30 8D E5 0C 40 8D E5 06 20 A0 E1 C6 3F A0 E1 30 20 8D E5 34 30 8D E5 00 20 A0 E3 20 70 8D E5 10 00 8D E5 0A 70 A0 E1 3C 90 8D E5 02 A0 A0 E1 28 30 8D E2 0C 00 93 E8 08 50 8D E2 30 00 95 E8 08 80 8D E5 06 80 A0 E1 34 10 9D E5 94 01 01 E0 30 00 9D E5 90 15 21 E0 94 50 86 E0 10 C0 9D E5 06 60 81 E0 0C 00 95 E0 00 10 A6 E2 01 50 A0 E1 08 10 A0 E1 00 40 A0 E1 0A 80 A0 E1 01 A0 A0 E1 04 90 9B E5 04 B0 8B E2 00 00 59 E3 0B 60 A0 E1 44 00 00 0A 0B 00 57 E1 49 00 00 0A 30 00 49 E2 09 00 50 E3 13 00 00 9A 14 10 9D E5 08 C0 9D E5 0C 00 59 E1 00 10 A0 13 01 10 01 02 00 00 51 E3 EE FF FF 1A 09 00 A0 E1 20 10 9D E5 04 20 8D E5 00 30 8D E5 ?? ?? ?? ?? 00 00 50 E3 31 00 00 0A 09 00 A0 E1 20 10 9D E5 ?? ?? ?? ?? 00 30 9D E5 04 20 9D E5 37 00 40 E2 0A 00 50 E1 29 00 00 AA 05 00 53 E1 04 00 52 01 09 00 00 3A 03 00 55 E1 02 00 54 01 38 C0 9D E5 00 10 A0 13 01 10 A0 03 0C 00 50 E1 00 10 A0 93 01 10 01 82 00 00 51 E3 2E 00 00 0A 01 80 A0 E3 D0 FF FF EA 1C 90 9D E5 18 B0 9D E5 00 00 5B E3 36 00 00 0A 1C C0 9D E5 09 30 6C E0 07 00 53 E3 05 00 00 CA 1C 40 9D E5 18 B0 9D E5 00 00 A0 E3 00 40 8B E5 00 10 A0 E1 3C FF FF EA 07 10 A0 E1 04 00 19 E5 ?? ?? ?? ?? 58 00 50 E3 F4 FF FF 1A 08 30 19 E5 30 00 53 E3 F1 FF FF 1A 04 90 49 E2 00 00 A0 E3 00 90 8B E5 00 10 A0 E1 2F FF FF EA 08 40 8D E5 0C 50 8D E5 08 20 A0 E1 06 40 A0 E1 3C 90 9D E5 20 70 9D E5 09 FF FF EA 08 40 8D E5 0C 50 8D E5 08 20 A0 E1 06 40 A0 E1 06 FF FF EA 09 20 A0 E1 01 70 A0 E1 20 90 9D E5 08 20 8D E5 0C 30 8D E5 FD FE FF EA 0A 10 A0 E1 10 00 8D E5 08 A0 A0 E1 01 80 A0 E1 90 FF FF EA 00 30 A0 E3 08 20 8D E5 0C 30 8D E5 F4 FE FF EA 00 10 A0 E3 00 20 A0 E3 08 10 8D E5 0C 20 8D E5 EF FE FF EA 00 00 A0 E3 00 10 A0 E1 0C FF FF EA 2C 40 93 E5 00 20 D4 E5 01 20 42 E2 FF 20 02 E2 FD 00 52 E3 03 00 00 8A 34 80 93 E5 00 00 58 E3 00 40 A0 03 8E FE FF EA 00 40 A0 E3 8B FE FF EA 09 A0 A0 E1 0A 10 A0 E1 04 30 A0 E1 08 20 A0 E1 09 00 A0 E1 ?? ?? ?? ?? 01 20 A0 E3 00 A0 A0 E1 00 50 99 E5 08 30 A0 E3 14 20 8D E5 0A 60 A0 E3 A0 FE FF EA 00 00 A0 E3 00 10 A0 E3 09 40 A0 E1 08 00 8D E5 0C 10 8D E5 CD FE FF EA 06 A0 A0 E1 EB FF FF EA 60 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 22 20 A0 E3 03 20 80 E7 1F FF FF EA 08 10 8D E2 03 00 91 E8 00 20 E0 E3 02 31 E0 E3 03 00 51 E1 02 00 50 01 00 20 A0 91 01 30 A0 91 D0 FE FF 9A 28 10 9F E5 ?? ?? ?? ?? 01 10 9F E7 22 C0 A0 E3 01 C0 80 E7 CA FE FF EA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_400_0_0 {
	meta:
		name = "allocate_dtv"
		size = 68
		refs = "001c calloc 0040 _dl_tls_max_dtv_idx"
	strings:
		$1 = { 38 40 2D E9 34 30 9F E5 00 30 93 E5 00 40 A0 E1 08 10 A0 E3 10 00 83 E2 0E 50 83 E2 ?? ?? ?? ?? 00 00 50 E3 00 30 A0 11 08 50 83 14 00 40 A0 01 04 00 A0 E1 00 30 84 15 38 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_400_1_0 {
	meta:
		name = "_dl_next_tls_modid"
		size = 252
		refs = "0094 __assert_fail 00dc _dl_tls_dtv_gaps 00e0 _dl_tls_max_dtv_idx 00e4 _dl_tls_static_nelem 00e8 _dl_tls_dtv_slotinfo_list"
	strings:
		$1 = { D4 20 9F E5 F8 40 2D E9 00 30 D2 E5 00 00 53 E3 05 00 00 1A C4 30 9F E5 00 00 93 E5 01 00 80 E2 00 00 83 E5 F8 40 BD E8 ?? ?? ?? ?? B0 10 9F E5 A8 30 9F E5 00 00 91 E5 00 60 93 E5 01 00 80 E2 A0 10 9F E5 06 00 50 E1 00 10 91 E5 18 00 00 8A 00 40 91 E5 00 C0 A0 E3 01 70 86 E2 00 50 6C E0 04 00 55 E1 0B 00 00 2A 85 51 81 E0 0C 50 95 E5 00 00 55 E3 0C 00 00 0A 01 00 80 E2 07 00 50 E1 F5 FF FF 9A 60 00 9F E5 60 10 9F E5 4B 20 A0 E3 5C 30 9F E5 ?? ?? ?? ?? 04 10 91 E5 00 00 51 E3 04 C0 8C E0 00 40 91 15 EB FF FF 1A 06 00 50 E1 DB FF FF 9A 01 60 86 E2 00 00 56 E1 00 10 A0 03 00 10 C2 05 D3 FF FF 0A 28 00 9F E5 1C 10 9F E5 59 20 A0 E3 18 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_400_2_0 {
	meta:
		name = "_dl_get_tls_static_info"
		size = 36
		refs = "001c _dl_tls_static_size 0020 _dl_tls_static_align"
	strings:
		$1 = { 14 30 9F E5 00 20 93 E5 10 30 9F E5 00 20 80 E5 00 30 93 E5 00 30 81 E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_400_3_0 {
	meta:
		name = "_dl_allocate_tls_storage"
		size = 152
		refs = "002c __libc_memalign 0050 memset 0074 free 008c _dl_tls_static_align 0090 _dl_tls_static_size"
	strings:
		$1 = { 84 30 9F E5 00 00 93 E5 70 40 2D E9 7C 50 9F E5 4B 4E 80 E2 00 20 60 E2 00 30 95 E5 0F 40 84 E2 04 40 02 E0 03 40 84 E0 04 10 A0 E1 ?? ?? ?? ?? 00 60 50 E2 12 00 00 0A 00 30 95 E5 04 40 63 E0 04 40 86 E0 13 0D 44 E2 00 10 A0 E3 40 20 9F E5 ?? ?? ?? ?? 04 00 A0 E1 8F FF FF EB 00 40 50 E2 02 00 00 0A 04 00 A0 E1 70 40 BD E8 ?? ?? ?? ?? 06 00 A0 E1 ?? ?? ?? ?? 04 00 A0 E1 70 40 BD E8 ?? ?? ?? ?? 06 40 A0 E1 F5 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? C8 04 00 00 }
	condition:
		$1
}

rule file_400_4_0 {
	meta:
		name = "_dl_allocate_tls_init"
		size = 456
		refs = "00a0 mempcpy 00b4 memset 0158 __assert_fail 01a0 _dl_tls_dtv_slotinfo_list 01a4 _dl_tls_max_dtv_idx"
	strings:
		$1 = { F0 4F 2D E9 00 00 50 E3 0C D0 4D E2 04 00 8D E5 54 00 00 0A 84 31 9F E5 00 B0 90 E5 80 A1 9F E5 00 70 A0 E3 00 90 93 E5 00 20 9A E5 0B 30 A0 E1 07 80 A0 E1 07 B0 A0 E1 03 70 A0 E1 01 50 78 E2 00 00 99 E5 00 50 A0 33 00 00 55 E1 37 00 00 2A 08 10 85 E0 02 00 51 E1 3F 00 00 8A 01 60 85 E2 86 61 89 E0 04 60 86 E2 1B 00 00 EA 05 00 52 E1 40 00 00 1A 2C 22 94 E5 30 12 94 E5 02 00 51 E1 41 00 00 3A 04 30 9D E5 85 11 87 E0 00 00 83 E0 01 30 A0 E3 85 01 87 E7 04 30 C1 E5 28 12 94 E5 ?? ?? ?? ?? 23 3E 84 E2 0C 00 13 E8 02 20 43 E0 00 10 A0 E3 ?? ?? ?? ?? 00 00 99 E5 01 50 85 E2 05 00 50 E1 18 00 00 9A 00 10 9A E5 08 20 85 E0 02 00 51 E1 08 60 86 E2 1F 00 00 3A 00 40 96 E5 00 00 54 E3 F4 FF FF 0A 3C 02 94 E5 04 10 16 E5 01 20 80 E2 01 00 5B E1 01 B0 A0 31 01 00 52 E3 40 22 94 E5 D8 FF FF 8A 00 30 E0 E3 82 31 87 E7 82 11 87 E0 00 30 A0 E3 04 30 C1 E5 00 00 99 E5 01 50 85 E2 05 00 50 E1 E6 FF FF 8A 00 20 9A E5 05 80 88 E0 02 00 58 E1 07 00 00 2A 04 90 99 E5 00 00 59 E3 BC FF FF 1A 58 00 9F E5 58 10 9F E5 58 20 9F E5 58 30 9F E5 ?? ?? ?? ?? 07 30 A0 E1 0B 70 A0 E1 00 70 83 E5 04 00 9D E5 0C D0 8D E2 F0 4F BD E8 ?? ?? ?? ?? 38 00 9F E5 28 10 9F E5 34 20 9F E5 28 30 9F E5 ?? ?? ?? ?? 2C 00 9F E5 14 10 9F E5 28 20 9F E5 14 30 9F E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? BE 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? A6 01 00 00 ?? ?? ?? ?? A7 01 00 00 }
	condition:
		$1
}

rule file_400_5_0 {
	meta:
		name = "_dl_allocate_tls"
		size = 36
		refs = "0014 _dl_allocate_tls_init 0018 _dl_allocate_tls_storage"
	strings:
		$1 = { 00 00 50 E3 08 40 2D E9 02 00 00 0A 0A FF FF EB 08 40 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? 08 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_400_6_0 {
	meta:
		name = "_dl_deallocate_tls"
		size = 152
		refs = "003c free 0090 _dl_static_dtv 0094 _dl_tls_static_align"
	strings:
		$1 = { F0 41 2D E9 00 60 90 E5 00 70 A0 E1 01 80 A0 E1 08 20 16 E5 06 40 A0 E1 00 50 A0 E3 09 00 00 EA 0C 30 D4 E5 00 00 53 E3 01 50 85 E2 04 00 00 1A 08 00 94 E5 01 00 70 E3 01 00 00 0A ?? ?? ?? ?? 08 20 16 E5 08 40 84 E2 02 00 55 E1 F3 FF FF 3A 38 30 9F E5 03 00 56 E1 08 00 46 12 ?? ?? ?? ?? 00 00 58 E3 07 00 00 0A 24 30 9F E5 00 30 93 E5 4B 2E 83 E2 0F 20 82 E2 00 30 63 E2 02 00 03 E0 07 00 60 E0 ?? ?? ?? ?? F0 41 BD E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_400_7_0 {
	meta:
		name = "_dl_tls_get_addr_soft"
		size = 164
		refs = "0010 __aeabi_read_tp 009c _dl_tls_generation 00a0 _dl_tls_dtv_slotinfo_list"
	strings:
		$1 = { 40 32 90 E5 00 00 53 E3 10 40 2D E9 0C 00 00 0A ?? ?? ?? ?? 00 20 90 E5 7C 00 9F E5 00 10 92 E5 00 00 90 E5 00 00 51 E1 07 00 00 1A 83 31 92 E7 01 00 73 E3 03 00 A0 11 00 00 A0 03 10 40 BD E8 ?? ?? ?? ?? 03 00 A0 E1 FB FF FF EA 08 00 12 E5 00 00 53 E1 0E 00 00 2A 40 00 9F E5 00 00 90 E5 00 40 90 E5 04 00 53 E1 03 C0 A0 E1 04 00 00 3A 04 00 90 E5 0C C0 64 E0 00 40 90 E5 0C 00 54 E1 FA FF FF 9A 01 C0 8C E2 8C 01 90 E7 00 00 51 E1 E5 FF FF 2A 00 00 A0 E3 E7 FF FF EA ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_400_8_0 {
	meta:
		name = "_dl_add_to_slotinfo"
		size = 240
		refs = "0064 malloc 0090 memset 00a8 __assert_fail 00cc _dl_signal_error 00d0 _dl_tls_dtv_slotinfo_list 00d4 _dl_tls_generation"
	strings:
		$1 = { F8 40 2D E9 C4 30 9F E5 00 60 A0 E1 40 42 90 E5 00 50 93 E5 04 00 00 EA 04 20 95 E5 00 00 52 E3 04 40 63 E0 0B 00 00 0A 02 50 A0 E1 00 30 95 E5 03 00 54 E1 F7 FF FF 2A 94 30 9F E5 00 30 93 E5 84 41 85 E0 01 30 83 E2 0C 60 84 E5 08 30 84 E5 F8 40 BD E8 ?? ?? ?? ?? 00 00 54 E3 0D 00 00 1A 7E 0F A0 E3 ?? ?? ?? ?? 00 00 50 E3 00 70 A0 E1 04 00 85 E5 0C 00 00 0A 3E 30 A0 E3 08 00 80 E2 04 10 A0 E1 1F 2E A0 E3 18 00 87 E8 07 50 A0 E1 ?? ?? ?? ?? E7 FF FF EA 38 00 9F E5 38 10 9F E5 38 20 9F E5 38 30 9F E5 ?? ?? ?? ?? 20 C0 9F E5 00 E0 9C E5 04 20 A0 E1 01 E0 8E E2 0C 00 A0 E3 20 10 9F E5 20 30 9F E5 00 E0 8C E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 5A 03 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_401_0_0 {
	meta:
		name = "ftello"
		size = 688
		refs = "001c __aeabi_read_tp 0094 _IO_seekoff_unlocked 0204 __lll_lock_wait_private 02a0 _Unwind_Resume 02a4 __libc_errno"
	strings:
		$1 = { F0 43 2D E9 00 40 90 E5 02 49 14 E2 0C D0 4D E2 00 50 A0 E1 18 00 00 1A 48 60 90 E5 ?? ?? ?? ?? 08 30 96 E5 13 7D 40 E2 07 00 53 E1 0F 00 00 0A 01 10 A0 E3 06 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 00 00 53 E3 66 00 00 1A 48 30 95 E5 08 70 83 E5 03 60 A0 E1 04 30 96 E5 01 30 83 E2 04 30 86 E5 01 20 A0 E3 00 30 A0 E3 0C 00 8D E8 05 00 A0 E1 00 20 A0 E3 00 30 A0 E3 ?? ?? ?? ?? 01 90 A0 E1 00 10 95 E5 01 0C 11 E3 00 80 A0 E1 07 00 00 0A 00 20 E0 E3 00 30 E0 E3 03 00 59 E1 02 00 58 01 02 00 00 0A 6C 30 95 E5 00 00 53 E3 36 00 00 DA 02 09 11 E3 17 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 11 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 29 00 00 CA 00 20 E0 E3 00 30 E0 E3 03 00 59 E1 02 00 58 01 08 00 00 0A 08 20 A0 E1 C8 3F A0 E1 09 00 53 E1 08 00 52 01 08 00 A0 01 17 00 00 1A 0C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 30 31 9F E5 ?? ?? ?? ?? 03 30 9F E7 03 30 90 E7 00 00 53 E3 00 00 E0 13 F5 FF FF 1A 18 31 9F E5 05 20 A0 E3 03 30 9F E7 03 20 80 E7 00 00 E0 E3 0C D0 8D E2 F0 43 BD E8 ?? ?? ?? ?? 2C 20 95 E5 24 30 95 E5 02 30 63 E0 03 80 58 E0 C3 9F C9 E0 C2 FF FF EA E4 30 9F E5 ?? ?? ?? ?? 03 30 9F E7 4B 20 A0 E3 03 20 80 E7 00 00 E0 E3 E0 FF FF EA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF CC FF FF EA 06 00 A0 E1 ?? ?? ?? ?? 95 FF FF EA 00 30 95 E5 02 09 13 E3 00 80 A0 E1 1F 00 00 1A 48 50 95 E5 04 30 95 E5 01 30 43 E2 00 00 53 E3 04 30 85 E5 19 00 00 1A 08 30 85 E5 00 60 95 E5 00 10 A0 E3 06 40 A0 E1 05 20 A0 E1 00 30 92 E5 04 00 53 E1 05 00 00 1A 04 00 A0 E1 0F 3A E0 E3 0F E0 A0 E1 3F F0 43 E2 F7 FF FF 3A 04 30 A0 E1 03 00 56 E1 F0 FF FF 1A 01 00 56 E3 07 00 00 DA ?? ?? ?? ?? B8 14 10 E5 01 20 A0 E3 02 10 81 E1 05 00 A0 E1 00 30 A0 E3 F0 70 A0 E3 00 00 00 EF 08 00 A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_0_0 {
	meta:
		name = "time"
		size = 56
		refs = "0014 __gettimeofday"
	strings:
		$1 = { 10 40 2D E9 08 D0 4D E2 00 40 A0 E1 00 10 A0 E3 0D 00 A0 E1 ?? ?? ?? ?? 00 00 50 E3 00 00 9D 05 00 00 E0 13 00 00 54 E3 00 00 84 15 08 D0 8D E2 10 40 BD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_403_0_0 {
	meta:
		name = "epoll_ctl"
		size = 28
		refs = "0018 __syscall_error"
	strings:
		$1 = { 04 70 2D E5 FB 70 A0 E3 00 00 00 EF 04 70 9D E4 01 0A 70 E3 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_404_0_0 {
	meta:
		name = "_nl_init_era_entries.part.0"
		size = 520
		refs = "0014 __pthread_rwlock_wrlock 003c __pthread_rwlock_unlock 0060 free 0094 realloc 00e0 __rawmemchr 0114 wcschr 0148 memcpy 01a0 malloc 01fc __libc_setlocale_lock 0204 _nl_cleanup_time"
	strings:
		$1 = { F0 31 9F E5 00 00 53 E3 F0 47 2D E9 00 50 A0 E1 E4 01 9F 15 ?? ?? ?? ?? 14 70 95 E5 00 00 57 E3 5D 00 00 0A 08 30 97 E5 00 00 53 E3 05 00 00 0A C8 31 9F E5 00 00 53 E3 BC 01 9F 15 ?? ?? ?? ?? F0 47 BD E8 ?? ?? ?? ?? EC 80 95 E5 00 00 58 E3 07 00 00 1A 00 00 97 E5 00 00 50 E3 01 00 00 0A ?? ?? ?? ?? 00 80 87 E5 01 30 A0 E3 08 30 87 E5 EE FF FF EA 04 30 97 E5 03 00 58 E1 00 40 97 E5 05 00 00 0A 88 10 88 E0 01 11 88 E0 04 00 A0 E1 01 11 A0 E1 ?? ?? ?? ?? 00 40 A0 E1 00 00 54 E3 4F 00 00 0A F0 50 95 E5 00 60 A0 E3 10 01 87 E8 00 A0 E0 E3 01 90 A0 E3 1F 00 00 EA 2C 00 00 0A 00 30 94 E5 2B 00 53 E3 09 30 A0 11 0A 30 A0 01 30 30 84 E5 20 00 85 E2 20 00 84 E5 00 10 A0 E3 ?? ?? ?? ?? 01 00 80 E2 24 00 84 E5 00 10 A0 E3 ?? ?? ?? ?? 01 00 80 E2 00 50 65 E0 03 50 85 E2 05 50 E0 E1 03 50 05 E2 05 00 80 E0 28 00 84 E5 00 10 A0 E3 ?? ?? ?? ?? 04 00 80 E2 2C 00 84 E5 00 10 A0 E3 ?? ?? ?? ?? 01 60 86 E2 08 00 56 E1 34 40 84 E2 04 50 80 E2 CA FF FF 0A 20 20 A0 E3 04 00 A0 E1 05 10 A0 E1 ?